/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: k8s.io/api/apidiscovery/v2/generated.proto

package v2

import (
	fmt "fmt"

	io "io"

	proto "github.com/gogo/protobuf/proto"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"

	math "math"
	math_bits "math/bits"
	reflect "reflect"
	strings "strings"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion3 // please upgrade the proto package

func (m *APIGroupDiscovery) Reset()      { *m = APIGroupDiscovery{} }
func (*APIGroupDiscovery) ProtoMessage() {}
func (*APIGroupDiscovery) Descriptor() ([]byte, []int) {
	return fileDescriptor_e0b7287280068d8f, []int{0}
}
func (m *APIGroupDiscovery) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *APIGroupDiscovery) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalToSizedBuffer(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (m *APIGroupDiscovery) XXX_Merge(src proto.Message) {
	xxx_messageInfo_APIGroupDiscovery.Merge(m, src)
}
func (m *APIGroupDiscovery) XXX_Size() int {
	return m.Size()
}
func (m *APIGroupDiscovery) XXX_DiscardUnknown() {
	xxx_messageInfo_APIGroupDiscovery.DiscardUnknown(m)
}

var xxx_messageInfo_APIGroupDiscovery proto.InternalMessageInfo

func (m *APIGroupDiscoveryList) Reset()      { *m = APIGroupDiscoveryList{} }
func (*APIGroupDiscoveryList) ProtoMessage() {}
func (*APIGroupDiscoveryList) Descriptor() ([]byte, []int) {
	return fileDescriptor_e0b7287280068d8f, []int{1}
}
func (m *APIGroupDiscoveryList) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *APIGroupDiscoveryList) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalToSizedBuffer(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (m *APIGroupDiscoveryList) XXX_Merge(src proto.Message) {
	xxx_messageInfo_APIGroupDiscoveryList.Merge(m, src)
}
func (m *APIGroupDiscoveryList) XXX_Size() int {
	return m.Size()
}
func (m *APIGroupDiscoveryList) XXX_DiscardUnknown() {
	xxx_messageInfo_APIGroupDiscoveryList.DiscardUnknown(m)
}

var xxx_messageInfo_APIGroupDiscoveryList proto.InternalMessageInfo

func (m *APIResourceDiscovery) Reset()      { *m = APIResourceDiscovery{} }
func (*APIResourceDiscovery) ProtoMessage() {}
func (*APIResourceDiscovery) Descriptor() ([]byte, []int) {
	return fileDescriptor_e0b7287280068d8f, []int{2}
}
func (m *APIResourceDiscovery) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *APIResourceDiscovery) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalToSizedBuffer(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (m *APIResourceDiscovery) XXX_Merge(src proto.Message) {
	xxx_messageInfo_APIResourceDiscovery.Merge(m, src)
}
func (m *APIResourceDiscovery) XXX_Size() int {
	return m.Size()
}
func (m *APIResourceDiscovery) XXX_DiscardUnknown() {
	xxx_messageInfo_APIResourceDiscovery.DiscardUnknown(m)
}

var xxx_messageInfo_APIResourceDiscovery proto.InternalMessageInfo

func (m *APISubresourceDiscovery) Reset()      { *m = APISubresourceDiscovery{} }
func (*APISubresourceDiscovery) ProtoMessage() {}
func (*APISubresourceDiscovery) Descriptor() ([]byte, []int) {
	return fileDescriptor_e0b7287280068d8f, []int{3}
}
func (m *APISubresourceDiscovery) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *APISubresourceDiscovery) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalToSizedBuffer(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (m *APISubresourceDiscovery) XXX_Merge(src proto.Message) {
	xxx_messageInfo_APISubresourceDiscovery.Merge(m, src)
}
func (m *APISubresourceDiscovery) XXX_Size() int {
	return m.Size()
}
func (m *APISubresourceDiscovery) XXX_DiscardUnknown() {
	xxx_messageInfo_APISubresourceDiscovery.DiscardUnknown(m)
}

var xxx_messageInfo_APISubresourceDiscovery proto.InternalMessageInfo

func (m *APIVersionDiscovery) Reset()      { *m = APIVersionDiscovery{} }
func (*APIVersionDiscovery) ProtoMessage() {}
func (*APIVersionDiscovery) Descriptor() ([]byte, []int) {
	return fileDescriptor_e0b7287280068d8f, []int{4}
}
func (m *APIVersionDiscovery) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *APIVersionDiscovery) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	b = b[:cap(b)]
	n, err := m.MarshalToSizedBuffer(b)
	if err != nil {
		return nil, err
	}
	return b[:n], nil
}
func (m *APIVersionDiscovery) XXX_Merge(src proto.Message) {
	xxx_messageInfo_APIVersionDiscovery.Merge(m, src)
}
func (m *APIVersionDiscovery) XXX_Size() int {
	return m.Size()
}
func (m *APIVersionDiscovery) XXX_DiscardUnknown() {
	xxx_messageInfo_APIVersionDiscovery.DiscardUnknown(m)
}

var xxx_messageInfo_APIVersionDiscovery proto.InternalMessageInfo

func init() {
	proto.RegisterType((*APIGroupDiscovery)(nil), "k8s.io.api.apidiscovery.v2.APIGroupDiscovery")
	proto.RegisterType((*APIGroupDiscoveryList)(nil), "k8s.io.api.apidiscovery.v2.APIGroupDiscoveryList")
	proto.RegisterType((*APIResourceDiscovery)(nil), "k8s.io.api.apidiscovery.v2.APIResourceDiscovery")
	proto.RegisterType((*APISubresourceDiscovery)(nil), "k8s.io.api.apidiscovery.v2.APISubresourceDiscovery")
	proto.RegisterType((*APIVersionDiscovery)(nil), "k8s.io.api.apidiscovery.v2.APIVersionDiscovery")
}

func init() {
	proto.RegisterFile("k8s.io/api/apidiscovery/v2/generated.proto", fileDescriptor_e0b7287280068d8f)
}

var fileDescriptor_e0b7287280068d8f = []byte{
	// 736 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xbc, 0x55, 0xcd, 0x4e, 0xdb, 0x4c,
	0x14, 0x8d, 0x09, 0xf9, 0x48, 0x26, 0xc9, 0xd7, 0x30, 0x80, 0x6a, 0x65, 0xe1, 0xa0, 0x6c, 0x4a,
	0xab, 0x32, 0x86, 0x94, 0xa2, 0x2e, 0x9b, 0x94, 0xb6, 0x8a, 0xfa, 0x87, 0x26, 0x15, 0x8b, 0xaa,
	0x95, 0xea, 0x38, 0x83, 0xe3, 0x82, 0x7f, 0x34, 0xe3, 0x44, 0x62, 0xd7, 0x47, 0xe8, 0x13, 0xf4,
	0x79, 0xe8, 0x8e, 0x05, 0x0b, 0x56, 0x51, 0x49, 0x77, 0x7d, 0x04, 0x56, 0xd5, 0x8c, 0xc7, 0x3f,
	0x21, 0x44, 0x41, 0x5d, 0x74, 0x81, 0x84, 0xcf, 0x9c, 0x73, 0xee, 0x3d, 0xd7, 0xd7, 0x13, 0xf0,
	0xe0, 0xe8, 0x09, 0x43, 0xb6, 0xa7, 0x1b, 0xbe, 0xcd, 0xff, 0x7a, 0x36, 0x33, 0xbd, 0x21, 0xa1,
	0x27, 0xfa, 0xb0, 0xa1, 0x5b, 0xc4, 0x25, 0xd4, 0x08, 0x48, 0x0f, 0xf9, 0xd4, 0x0b, 0x3c, 0x58,
	0x0d, 0xb9, 0xc8, 0xf0, 0x6d, 0x94, 0xe6, 0xa2, 0x61, 0xa3, 0xba, 0x69, 0xd9, 0x41, 0x7f, 0xd0,
	0x45, 0xa6, 0xe7, 0xe8, 0x96, 0x67, 0x79, 0xba, 0x90, 0x74, 0x07, 0x87, 0xe2, 0x49, 0x3c, 0x88,
	0xff, 0x42, 0xab, 0xea, 0x4e, 0x52, 0xd6, 0x31, 0xcc, 0xbe, 0xed, 0xf2, 0x92, 0xfe, 0x91, 0xc5,
	0x01, 0xa6, 0x3b, 0x24, 0x30, 0xf4, 0xe1, 0xf6, 0xf5, 0x06, 0xaa, 0xfa, 0x2c, 0x15, 0x1d, 0xb8,
	0x81, 0xed, 0x90, 0x29, 0xc1, 0xee, 0x3c, 0x01, 0x33, 0xfb, 0xc4, 0x31, 0xae, 0xeb, 0xea, 0xe7,
	0x0a, 0x58, 0x6e, 0xee, 0xb7, 0x5f, 0x52, 0x6f, 0xe0, 0xef, 0x45, 0x31, 0xe1, 0x67, 0x90, 0xe7,
	0x9d, 0xf5, 0x8c, 0xc0, 0x50, 0x95, 0x75, 0x65, 0xa3, 0xd8, 0xd8, 0x42, 0xc9, 0x48, 0xe2, 0x02,
	0xc8, 0x3f, 0xb2, 0x38, 0xc0, 0x10, 0x67, 0xa3, 0xe1, 0x36, 0x7a, 0xd7, 0xfd, 0x42, 0xcc, 0xe0,
	0x0d, 0x09, 0x8c, 0x16, 0x3c, 0x1d, 0xd5, 0x32, 0xe3, 0x51, 0x0d, 0x24, 0x18, 0x8e, 0x5d, 0xe1,
	0x27, 0x90, 0x1f, 0x12, 0xca, 0x6c, 0xcf, 0x65, 0xea, 0xc2, 0x7a, 0x76, 0xa3, 0xd8, 0xd0, 0xd1,
	0xec, 0xa1, 0xa3, 0xe6, 0x7e, 0xfb, 0x20, 0xa4, 0xc7, 0x4d, 0xb6, 0x2a, 0xb2, 0x40, 0x5e, 0x9e,
	0x30, 0x1c, 0x5b, 0xd6, 0x7f, 0x28, 0x60, 0x6d, 0x2a, 0xd6, 0x6b, 0x9b, 0x05, 0xf0, 0xe3, 0x54,
	0x34, 0x74, 0xbb, 0x68, 0x5c, 0x2d, 0x82, 0xc5, 0x75, 0x23, 0x24, 0x15, 0x0b, 0x83, 0x9c, 0x1d,
	0x10, 0x27, 0xca, 0xb4, 0x39, 0x27, 0xd3, 0x64, 0x7f, 0xad, 0xb2, 0x74, 0xce, 0xb5, 0xb9, 0x07,
	0x0e, 0xad, 0xea, 0xdf, 0x17, 0xc1, 0x6a, 0x73, 0xbf, 0x8d, 0x09, 0xf3, 0x06, 0xd4, 0x24, 0xc9,
	0x5b, 0x7a, 0x08, 0xf2, 0x54, 0x82, 0x22, 0x4a, 0x21, 0x69, 0x2d, 0x22, 0xe3, 0x98, 0x01, 0x8f,
	0x41, 0x89, 0x12, 0xe6, 0x7b, 0x2e, 0x23, 0xaf, 0x6c, 0xb7, 0xa7, 0x2e, 0x88, 0xf0, 0xbb, 0xb7,
	0x0b, 0x2f, 0x1a, 0x95, 0x73, 0xe6, 0xea, 0x56, 0x65, 0x3c, 0xaa, 0x95, 0x70, 0xca, 0x0f, 0x4f,
	0xb8, 0xc3, 0x1d, 0x90, 0x63, 0xa6, 0xe7, 0x13, 0x35, 0x2b, 0x1a, 0xd3, 0xa2, 0x64, 0x1d, 0x0e,
	0x5e, 0x8d, 0x6a, 0xe5, 0xa8, 0x43, 0x01, 0xe0, 0x90, 0x0c, 0xf7, 0x40, 0x85, 0xd9, 0xae, 0x35,
	0x38, 0x36, 0x68, 0x74, 0xae, 0x2e, 0x0a, 0x03, 0x55, 0x1a, 0x54, 0x3a, 0xd7, 0xce, 0xf1, 0x94,
	0x02, 0xd6, 0x40, 0x6e, 0x48, 0x68, 0x97, 0xa9, 0xb9, 0xf5, 0xec, 0x46, 0xa1, 0x55, 0xe0, 0x75,
	0x0f, 0x38, 0x80, 0x43, 0x1c, 0x22, 0x00, 0x58, 0xdf, 0xa3, 0xc1, 0x5b, 0xc3, 0x21, 0x4c, 0xfd,
	0x4f, 0xb0, 0xfe, 0xe7, 0xab, 0xda, 0x89, 0x51, 0x9c, 0x62, 0x70, 0xbe, 0x69, 0x04, 0xc4, 0xf2,
	0xa8, 0x4d, 0x98, 0xba, 0x94, 0xf0, 0x9f, 0xc5, 0x28, 0x4e, 0x31, 0xa0, 0x03, 0x4a, 0x6c, 0xd0,
	0x8d, 0x26, 0xcf, 0xd4, 0xbc, 0x58, 0x86, 0x47, 0x73, 0x96, 0xa1, 0x93, 0x48, 0x92, 0x95, 0x58,
	0x95, 0xb9, 0x4b, 0xa9, 0x53, 0x86, 0x27, 0xec, 0xeb, 0xe7, 0x0b, 0xe0, 0xee, 0x0c, 0x3d, 0x7c,
	0x0c, 0x8a, 0x29, 0xae, 0x5c, 0x93, 0x15, 0x69, 0x5a, 0x4c, 0x49, 0x70, 0x9a, 0xf7, 0x8f, 0x97,
	0x85, 0x81, 0xb2, 0x61, 0x9a, 0xc4, 0x0f, 0x48, 0xef, 0xfd, 0x89, 0x4f, 0x98, 0x9a, 0x15, 0x03,
	0xfb, 0xdb, 0x72, 0x6b, 0x32, 0x5e, 0xb9, 0x99, 0x36, 0xc5, 0x93, 0x35, 0x92, 0x2d, 0x59, 0xbc,
	0x79, 0x4b, 0xea, 0xbf, 0x15, 0xb0, 0x72, 0xc3, 0xbd, 0x03, 0xef, 0x83, 0x25, 0x79, 0xcf, 0xc8,
	0x71, 0xde, 0x91, 0xf5, 0x96, 0x24, 0x15, 0x47, 0xe7, 0xd0, 0x00, 0x85, 0x64, 0x0b, 0xc2, 0x2b,
	0x61, 0x6b, 0xce, 0x16, 0x4c, 0x7d, 0xe6, 0xad, 0x65, 0x69, 0x5f, 0xc0, 0xf1, 0xfb, 0x4f, 0x5c,
	0xe1, 0x73, 0x50, 0x38, 0xa4, 0x84, 0xf5, 0x5d, 0xc2, 0x98, 0xfc, 0xd8, 0xee, 0x45, 0x82, 0x17,
	0xd1, 0xc1, 0xd5, 0xa8, 0x06, 0x63, 0xc3, 0x18, 0xc5, 0x89, 0xb2, 0xf5, 0xf4, 0xf4, 0x52, 0xcb,
	0x9c, 0x5d, 0x6a, 0x99, 0x8b, 0x4b, 0x2d, 0xf3, 0x75, 0xac, 0x29, 0xa7, 0x63, 0x4d, 0x39, 0x1b,
	0x6b, 0xca, 0xc5, 0x58, 0x53, 0x7e, 0x8e, 0x35, 0xe5, 0xdb, 0x2f, 0x2d, 0xf3, 0xa1, 0x3a, 0xfb,
	0x37, 0xf4, 0x4f, 0x00, 0x00, 0x00, 0xff, 0xff, 0x5d, 0x35, 0x6a, 0x0f, 0x60, 0x07, 0x00, 0x00,
}

func (m *APIGroupDiscovery) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *APIGroupDiscovery) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *APIGroupDiscovery) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Versions) > 0 {
		for iNdEx := len(m.Versions) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Versions[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintGenerated(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x12
		}
	}
	{
		size, err := m.ObjectMeta.MarshalToSizedBuffer(dAtA[:i])
		if err != nil {
			return 0, err
		}
		i -= size
		i = encodeVarintGenerated(dAtA, i, uint64(size))
	}
	i--
	dAtA[i] = 0xa
	return len(dAtA) - i, nil
}

func (m *APIGroupDiscoveryList) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *APIGroupDiscoveryList) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *APIGroupDiscoveryList) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Items) > 0 {
		for iNdEx := len(m.Items) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Items[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintGenerated(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x12
		}
	}
	{
		size, err := m.ListMeta.MarshalToSizedBuffer(dAtA[:i])
		if err != nil {
			return 0, err
		}
		i -= size
		i = encodeVarintGenerated(dAtA, i, uint64(size))
	}
	i--
	dAtA[i] = 0xa
	return len(dAtA) - i, nil
}

func (m *APIResourceDiscovery) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *APIResourceDiscovery) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *APIResourceDiscovery) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Subresources) > 0 {
		for iNdEx := len(m.Subresources) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Subresources[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintGenerated(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x42
		}
	}
	if len(m.Categories) > 0 {
		for iNdEx := len(m.Categories) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.Categories[iNdEx])
			copy(dAtA[i:], m.Categories[iNdEx])
			i = encodeVarintGenerated(dAtA, i, uint64(len(m.Categories[iNdEx])))
			i--
			dAtA[i] = 0x3a
		}
	}
	if len(m.ShortNames) > 0 {
		for iNdEx := len(m.ShortNames) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.ShortNames[iNdEx])
			copy(dAtA[i:], m.ShortNames[iNdEx])
			i = encodeVarintGenerated(dAtA, i, uint64(len(m.ShortNames[iNdEx])))
			i--
			dAtA[i] = 0x32
		}
	}
	if len(m.Verbs) > 0 {
		for iNdEx := len(m.Verbs) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.Verbs[iNdEx])
			copy(dAtA[i:], m.Verbs[iNdEx])
			i = encodeVarintGenerated(dAtA, i, uint64(len(m.Verbs[iNdEx])))
			i--
			dAtA[i] = 0x2a
		}
	}
	i -= len(m.SingularResource)
	copy(dAtA[i:], m.SingularResource)
	i = encodeVarintGenerated(dAtA, i, uint64(len(m.SingularResource)))
	i--
	dAtA[i] = 0x22
	i -= len(m.Scope)
	copy(dAtA[i:], m.Scope)
	i = encodeVarintGenerated(dAtA, i, uint64(len(m.Scope)))
	i--
	dAtA[i] = 0x1a
	if m.ResponseKind != nil {
		{
			size, err := m.ResponseKind.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintGenerated(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	i -= len(m.Resource)
	copy(dAtA[i:], m.Resource)
	i = encodeVarintGenerated(dAtA, i, uint64(len(m.Resource)))
	i--
	dAtA[i] = 0xa
	return len(dAtA) - i, nil
}

func (m *APISubresourceDiscovery) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *APISubresourceDiscovery) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *APISubresourceDiscovery) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Verbs) > 0 {
		for iNdEx := len(m.Verbs) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.Verbs[iNdEx])
			copy(dAtA[i:], m.Verbs[iNdEx])
			i = encodeVarintGenerated(dAtA, i, uint64(len(m.Verbs[iNdEx])))
			i--
			dAtA[i] = 0x22
		}
	}
	if len(m.AcceptedTypes) > 0 {
		for iNdEx := len(m.AcceptedTypes) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.AcceptedTypes[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintGenerated(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x1a
		}
	}
	if m.ResponseKind != nil {
		{
			size, err := m.ResponseKind.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintGenerated(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	i -= len(m.Subresource)
	copy(dAtA[i:], m.Subresource)
	i = encodeVarintGenerated(dAtA, i, uint64(len(m.Subresource)))
	i--
	dAtA[i] = 0xa
	return len(dAtA) - i, nil
}

func (m *APIVersionDiscovery) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *APIVersionDiscovery) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *APIVersionDiscovery) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	i -= len(m.Freshness)
	copy(dAtA[i:], m.Freshness)
	i = encodeVarintGenerated(dAtA, i, uint64(len(m.Freshness)))
	i--
	dAtA[i] = 0x1a
	if len(m.Resources) > 0 {
		for iNdEx := len(m.Resources) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Resources[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintGenerated(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x12
		}
	}
	i -= len(m.Version)
	copy(dAtA[i:], m.Version)
	i = encodeVarintGenerated(dAtA, i, uint64(len(m.Version)))
	i--
	dAtA[i] = 0xa
	return len(dAtA) - i, nil
}

func encodeVarintGenerated(dAtA []byte, offset int, v uint64) int {
	offset -= sovGenerated(v)
	base := offset
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return base
}
func (m *APIGroupDiscovery) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = m.ObjectMeta.Size()
	n += 1 + l + sovGenerated(uint64(l))
	if len(m.Versions) > 0 {
		for _, e := range m.Versions {
			l = e.Size()
			n += 1 + l + sovGenerated(uint64(l))
		}
	}
	return n
}

func (m *APIGroupDiscoveryList) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = m.ListMeta.Size()
	n += 1 + l + sovGenerated(uint64(l))
	if len(m.Items) > 0 {
		for _, e := range m.Items {
			l = e.Size()
			n += 1 + l + sovGenerated(uint64(l))
		}
	}
	return n
}

func (m *APIResourceDiscovery) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Resource)
	n += 1 + l + sovGenerated(uint64(l))
	if m.ResponseKind != nil {
		l = m.ResponseKind.Size()
		n += 1 + l + sovGenerated(uint64(l))
	}
	l = len(m.Scope)
	n += 1 + l + sovGenerated(uint64(l))
	l = len(m.SingularResource)
	n += 1 + l + sovGenerated(uint64(l))
	if len(m.Verbs) > 0 {
		for _, s := range m.Verbs {
			l = len(s)
			n += 1 + l + sovGenerated(uint64(l))
		}
	}
	if len(m.ShortNames) > 0 {
		for _, s := range m.ShortNames {
			l = len(s)
			n += 1 + l + sovGenerated(uint64(l))
		}
	}
	if len(m.Categories) > 0 {
		for _, s := range m.Categories {
			l = len(s)
			n += 1 + l + sovGenerated(uint64(l))
		}
	}
	if len(m.Subresources) > 0 {
		for _, e := range m.Subresources {
			l = e.Size()
			n += 1 + l + sovGenerated(uint64(l))
		}
	}
	return n
}

func (m *APISubresourceDiscovery) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Subresource)
	n += 1 + l + sovGenerated(uint64(l))
	if m.ResponseKind != nil {
		l = m.ResponseKind.Size()
		n += 1 + l + sovGenerated(uint64(l))
	}
	if len(m.AcceptedTypes) > 0 {
		for _, e := range m.AcceptedTypes {
			l = e.Size()
			n += 1 + l + sovGenerated(uint64(l))
		}
	}
	if len(m.Verbs) > 0 {
		for _, s := range m.Verbs {
			l = len(s)
			n += 1 + l + sovGenerated(uint64(l))
		}
	}
	return n
}

func (m *APIVersionDiscovery) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Version)
	n += 1 + l + sovGenerated(uint64(l))
	if len(m.Resources) > 0 {
		for _, e := range m.Resources {
			l = e.Size()
			n += 1 + l + sovGenerated(uint64(l))
		}
	}
	l = len(m.Freshness)
	n += 1 + l + sovGenerated(uint64(l))
	return n
}

func sovGenerated(x uint64) (n int) {
	return (math_bits.Len64(x|1) + 6) / 7
}
func sozGenerated(x uint64) (n int) {
	return sovGenerated(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (this *APIGroupDiscovery) String() string {
	if this == nil {
		return "nil"
	}
	repeatedStringForVersions := "[]APIVersionDiscovery{"
	for _, f := range this.Versions {
		repeatedStringForVersions += strings.Replace(strings.Replace(f.String(), "APIVersionDiscovery", "APIVersionDiscovery", 1), `&`, ``, 1) + ","
	}
	repeatedStringForVersions += "}"
	s := strings.Join([]string{`&APIGroupDiscovery{`,
		`ObjectMeta:` + strings.Replace(strings.Replace(fmt.Sprintf("%v", this.ObjectMeta), "ObjectMeta", "v1.ObjectMeta", 1), `&`, ``, 1) + `,`,
		`Versions:` + repeatedStringForVersions + `,`,
		`}`,
	}, "")
	return s
}
func (this *APIGroupDiscoveryList) String() string {
	if this == nil {
		return "nil"
	}
	repeatedStringForItems := "[]APIGroupDiscovery{"
	for _, f := range this.Items {
		repeatedStringForItems += strings.Replace(strings.Replace(f.String(), "APIGroupDiscovery", "APIGroupDiscovery", 1), `&`, ``, 1) + ","
	}
	repeatedStringForItems += "}"
	s := strings.Join([]string{`&APIGroupDiscoveryList{`,
		`ListMeta:` + strings.Replace(strings.Replace(fmt.Sprintf("%v", this.ListMeta), "ListMeta", "v1.ListMeta", 1), `&`, ``, 1) + `,`,
		`Items:` + repeatedStringForItems + `,`,
		`}`,
	}, "")
	return s
}
func (this *APIResourceDiscovery) String() string {
	if this == nil {
		return "nil"
	}
	repeatedStringForSubresources := "[]APISubresourceDiscovery{"
	for _, f := range this.Subresources {
		repeatedStringForSubresources += strings.Replace(strings.Replace(f.String(), "APISubresourceDiscovery", "APISubresourceDiscovery", 1), `&`, ``, 1) + ","
	}
	repeatedStringForSubresources += "}"
	s := strings.Join([]string{`&APIResourceDiscovery{`,
		`Resource:` + fmt.Sprintf("%v", this.Resource) + `,`,
		`ResponseKind:` + strings.Replace(fmt.Sprintf("%v", this.ResponseKind), "GroupVersionKind", "v1.GroupVersionKind", 1) + `,`,
		`Scope:` + fmt.Sprintf("%v", this.Scope) + `,`,
		`SingularResource:` + fmt.Sprintf("%v", this.SingularResource) + `,`,
		`Verbs:` + fmt.Sprintf("%v", this.Verbs) + `,`,
		`ShortNames:` + fmt.Sprintf("%v", this.ShortNames) + `,`,
		`Categories:` + fmt.Sprintf("%v", this.Categories) + `,`,
		`Subresources:` + repeatedStringForSubresources + `,`,
		`}`,
	}, "")
	return s
}
func (this *APISubresourceDiscovery) String() string {
	if this == nil {
		return "nil"
	}
	repeatedStringForAcceptedTypes := "[]GroupVersionKind{"
	for _, f := range this.AcceptedTypes {
		repeatedStringForAcceptedTypes += fmt.Sprintf("%v", f) + ","
	}
	repeatedStringForAcceptedTypes += "}"
	s := strings.Join([]string{`&APISubresourceDiscovery{`,
		`Subresource:` + fmt.Sprintf("%v", this.Subresource) + `,`,
		`ResponseKind:` + strings.Replace(fmt.Sprintf("%v", this.ResponseKind), "GroupVersionKind", "v1.GroupVersionKind", 1) + `,`,
		`AcceptedTypes:` + repeatedStringForAcceptedTypes + `,`,
		`Verbs:` + fmt.Sprintf("%v", this.Verbs) + `,`,
		`}`,
	}, "")
	return s
}
func (this *APIVersionDiscovery) String() string {
	if this == nil {
		return "nil"
	}
	repeatedStringForResources := "[]APIResourceDiscovery{"
	for _, f := range this.Resources {
		repeatedStringForResources += strings.Replace(strings.Replace(f.String(), "APIResourceDiscovery", "APIResourceDiscovery", 1), `&`, ``, 1) + ","
	}
	repeatedStringForResources += "}"
	s := strings.Join([]string{`&APIVersionDiscovery{`,
		`Version:` + fmt.Sprintf("%v", this.Version) + `,`,
		`Resources:` + repeatedStringForResources + `,`,
		`Freshness:` + fmt.Sprintf("%v", this.Freshness) + `,`,
		`}`,
	}, "")
	return s
}
func valueToStringGenerated(v interface{}) string {
	rv := reflect.ValueOf(v)
	if rv.IsNil() {
		return "nil"
	}
	pv := reflect.Indirect(rv).Interface()
	return fmt.Sprintf("*%v", pv)
}
func (m *APIGroupDiscovery) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowGenerated
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: APIGroupDiscovery: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: APIGroupDiscovery: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ObjectMeta", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthGenerated
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.ObjectMeta.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Versions", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthGenerated
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Versions = append(m.Versions, APIVersionDiscovery{})
			if err := m.Versions[len(m.Versions)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipGenerated(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthGenerated
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *APIGroupDiscoveryList) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowGenerated
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: APIGroupDiscoveryList: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: APIGroupDiscoveryList: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ListMeta", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthGenerated
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.ListMeta.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Items", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthGenerated
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Items = append(m.Items, APIGroupDiscovery{})
			if err := m.Items[len(m.Items)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipGenerated(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthGenerated
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *APIResourceDiscovery) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowGenerated
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: APIResourceDiscovery: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: APIResourceDiscovery: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Resource", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthGenerated
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Resource = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ResponseKind", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthGenerated
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ResponseKind == nil {
				m.ResponseKind = &v1.GroupVersionKind{}
			}
			if err := m.ResponseKind.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Scope", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthGenerated
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Scope = ResourceScope(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SingularResource", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthGenerated
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SingularResource = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Verbs", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthGenerated
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Verbs = append(m.Verbs, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ShortNames", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthGenerated
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ShortNames = append(m.ShortNames, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Categories", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthGenerated
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Categories = append(m.Categories, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Subresources", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthGenerated
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Subresources = append(m.Subresources, APISubresourceDiscovery{})
			if err := m.Subresources[len(m.Subresources)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipGenerated(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthGenerated
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *APISubresourceDiscovery) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowGenerated
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: APISubresourceDiscovery: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: APISubresourceDiscovery: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Subresource", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthGenerated
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Subresource = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ResponseKind", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthGenerated
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ResponseKind == nil {
				m.ResponseKind = &v1.GroupVersionKind{}
			}
			if err := m.ResponseKind.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AcceptedTypes", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthGenerated
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.AcceptedTypes = append(m.AcceptedTypes, v1.GroupVersionKind{})
			if err := m.AcceptedTypes[len(m.AcceptedTypes)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Verbs", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthGenerated
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Verbs = append(m.Verbs, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipGenerated(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthGenerated
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *APIVersionDiscovery) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowGenerated
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: APIVersionDiscovery: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: APIVersionDiscovery: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Version", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthGenerated
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Version = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Resources", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthGenerated
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Resources = append(m.Resources, APIResourceDiscovery{})
			if err := m.Resources[len(m.Resources)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Freshness", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthGenerated
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthGenerated
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Freshness = DiscoveryFreshness(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipGenerated(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthGenerated
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipGenerated(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	depth := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowGenerated
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
		case 1:
			iNdEx += 8
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowGenerated
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if length < 0 {
				return 0, ErrInvalidLengthGenerated
			}
			iNdEx += length
		case 3:
			depth++
		case 4:
			if depth == 0 {
				return 0, ErrUnexpectedEndOfGroupGenerated
			}
			depth--
		case 5:
			iNdEx += 4
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
		if iNdEx < 0 {
			return 0, ErrInvalidLengthGenerated
		}
		if depth == 0 {
			return iNdEx, nil
		}
	}
	return 0, io.ErrUnexpectedEOF
}

var (
	ErrInvalidLengthGenerated        = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowGenerated          = fmt.Errorf("proto: integer overflow")
	ErrUnexpectedEndOfGroupGenerated = fmt.Errorf("proto: unexpected end of group")
)
