#!/usr/bin/env python3

import asyncio
import json
import re
from pathlib import Path

here = Path(__file__).parent.absolute()

input_filename = here / "../src/js/components/FlowTable/FlowColumns.tsx"
filename = here / "../../mitmproxy/tools/web/web_columns.py"


def extract_columns() -> list:
    # Read the Typescript file content
    input_file_content = input_filename.read_text()

    pattern = r"//\s*parsed by web/gen/web_columns\s*\n([\s\w,]+)"

    match = re.search(pattern, input_file_content, re.MULTILINE)

    columns_str = match.group(1)

    columns = [col.strip() for col in columns_str.split(",") if col.strip()]

    return columns


async def make() -> str:
    available_web_columns = extract_columns()

    # language=Python
    content = (
        "# Auto-generated by web/gen/web_columns.py\n"
        f"AVAILABLE_WEB_COLUMNS = {json.dumps(available_web_columns, indent=4)}"
    ).replace("\n]", ",\n]\n")

    return content


if __name__ == "__main__":
    filename.write_bytes(asyncio.run(make()).encode())
