/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.output2;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import javax.swing.text.Segment;
import javax.swing.text.TabExpander;
import javax.swing.text.Utilities;
import javax.swing.text.View;
import org.netbeans.core.output2.ExtPlainView;
import org.netbeans.core.output2.LineInfo;
import org.netbeans.core.output2.Lines;
import org.netbeans.core.output2.OutputDocument;
import org.openide.awt.GraphicsUtils;
import org.openide.util.Exceptions;

public class WrappedTextView
extends View
implements TabExpander {
    static final int TAB_SIZE = 8;
    private JTextComponent comp;
    private int charsPerLine = 80;
    private int fontDescent = 4;
    private static final Segment SEGMENT = new Segment();
    private int width = 0;
    private boolean changed = true;
    private int charWidth = 12;
    private int charHeight = 7;
    static final int[] ln = new int[3];
    private boolean aa = false;
    static final Color arrowColor = new Color(80, 162, 80);
    int tabSize;
    int tabBase;
    private int tabOffsetX = 0;
    private final PropertyChangeListener propertyChangeListener;
    float viewWidth = -1.0f;

    public WrappedTextView(Element element, JTextComponent jTextComponent, PropertyChangeListener propertyChangeListener) {
        super(element);
        this.comp = jTextComponent;
        this.propertyChangeListener = propertyChangeListener;
    }

    @Override
    public float getPreferredSpan(int n) {
        OutputDocument outputDocument = this.odoc();
        float f = 0.0f;
        if (outputDocument != null) {
            this.updateWidth();
            switch (n) {
                case 0: {
                    f = this.charsPerLine;
                    break;
                }
                case 1: {
                    f = outputDocument.getLines().getLogicalLineCountIfWrappedAt(this.charsPerLine) * this.charHeight + this.fontDescent;
                    break;
                }
                default: {
                    throw new IllegalArgumentException(Integer.toString(n));
                }
            }
        }
        return f;
    }

    @Override
    public float getMinimumSpan(int n) {
        return this.getPreferredSpan(n);
    }

    @Override
    public float getMaximumSpan(int n) {
        return this.getPreferredSpan(n);
    }

    @Override
    public void setSize(float f, float f2) {
        super.setSize(f, f2);
        if (this.viewWidth != f) {
            this.viewWidth = f;
            this.updateMetrics();
        }
    }

    private int getTabSize() {
        return 8;
    }

    @Override
    public float nextTabStop(float f, int n) {
        if (this.tabSize == 0) {
            return f;
        }
        int n2 = ((int)f - WrappedTextView.margin() + this.tabOffsetX) / this.tabSize;
        return WrappedTextView.margin() + (n2 + 1) * this.tabSize - this.tabOffsetX;
    }

    void updateMetrics() {
        Font font = this.comp.getFont();
        FontMetrics fontMetrics = this.comp.getFontMetrics(font);
        this.charWidth = fontMetrics.charWidth('m');
        this.charHeight = fontMetrics.getHeight();
        this.fontDescent = fontMetrics.getMaxDescent();
        Graphics2D graphics2D = (Graphics2D)this.comp.getGraphics();
        if (graphics2D != null) {
            this.aa = graphics2D.getRenderingHint(RenderingHints.KEY_ANTIALIASING) == RenderingHints.VALUE_ANTIALIAS_ON;
        }
        this.tabSize = this.getTabSize() * this.charWidth;
        this.updateWidth();
    }

    private OutputDocument odoc() {
        Document document = this.comp.getDocument();
        if (document instanceof OutputDocument) {
            return (OutputDocument)document;
        }
        return null;
    }

    private void updateWidth() {
        int n = this.charsPerLine;
        if (this.comp.getParent() instanceof JViewport) {
            JViewport jViewport = (JViewport)this.comp.getParent();
            this.width = jViewport.getExtentSize().width - (this.aa ? 18 : 17);
        } else {
            this.width = this.comp.getWidth() - (this.aa ? 18 : 17);
        }
        if (this.width < 0) {
            this.width = 0;
        }
        this.charsPerLine = this.width / this.charWidth;
        if (this.charsPerLine != n) {
            this.propertyChangeListener.propertyChange(new PropertyChangeEvent(this, "charsPerLine", n, this.charsPerLine));
        }
    }

    private static int margin() {
        return 9;
    }

    @Override
    public void paint(Graphics graphics, Shape shape) {
        GraphicsUtils.configureDefaultRenderingHints((Graphics)graphics);
        this.comp.getHighlighter().paint(graphics);
        this.tabBase = ((Rectangle)shape).x + WrappedTextView.margin();
        OutputDocument outputDocument = this.odoc();
        if (outputDocument != null) {
            Rectangle rectangle = graphics.getClipBounds();
            rectangle.y = Math.max(0, rectangle.y - this.charHeight);
            rectangle.height += this.charHeight * 2;
            int n = outputDocument.getElementCount();
            if (n == 0) {
                return;
            }
            WrappedTextView.ln[0] = rectangle.y / this.charHeight;
            Lines lines = outputDocument.getLines();
            lines.toPhysicalLineIndex(ln, this.charsPerLine);
            int n2 = ln[0];
            graphics.setColor(this.comp.getForeground());
            Segment segment = SwingUtilities.isEventDispatchThread() ? SEGMENT : new Segment();
            int n3 = this.comp.getSelectionStart();
            int n4 = this.comp.getSelectionEnd();
            int n5 = rectangle.y - rectangle.y % this.charHeight + this.charHeight;
            int n6 = (rectangle.height + this.charHeight - 1) / this.charHeight * this.charsPerLine;
            try {
                for (int i = n2; i < lines.getLineCount(); ++i) {
                    int n7;
                    if (n5 > rectangle.y + rectangle.height) {
                        return;
                    }
                    int n8 = lines.realToVisibleLine(i);
                    if (n8 < 0) continue;
                    int n9 = outputDocument.getLineStart(i);
                    int n10 = outputDocument.getLineEnd(i);
                    int n11 = n10 - n9;
                    if (n11 == 0) {
                        n5 += this.charHeight;
                        continue;
                    }
                    n11 = lines.lengthWithTabs(i);
                    LineInfo lineInfo = lines.getLineInfo(i);
                    int n12 = n11 <= this.charsPerLine ? 1 : (this.charsPerLine == 0 ? n11 : (n11 + this.charsPerLine - 1) / this.charsPerLine);
                    int n13 = i == n2 && n12 > 0 && ln[1] > 0 ? ln[1] : 0;
                    int n14 = 0;
                    int n15 = 0;
                    int n16 = n13 - 1;
                    int n17 = 0;
                    int n18 = this.charsPerLine;
                    if (n13 > 0) {
                        n7 = n13 * this.charsPerLine;
                        int[] nArray = new int[]{0};
                        n7 = lines.getNumPhysicalChars(n9, n7, nArray);
                        n9 += n7;
                        if (nArray[0] > 0) {
                            n18 -= nArray[0];
                            n17 = nArray[0] * this.charWidth;
                            n15 += nArray[0];
                        }
                    } else {
                        n7 = 0;
                    }
                    n11 = Math.min(n6, n11 - n7);
                    int n19 = Math.min(n6, n10 - n9);
                    outputDocument.getText(n9, n19, segment);
                    this.tabOffsetX = this.charWidth * n13 * this.charsPerLine;
                    block3: for (LineInfo.Segment segment2 : lineInfo.getLineSegments()) {
                        if (segment2.getEnd() < n7) continue;
                        graphics.setColor(segment2.getColor());
                        int n20 = 0;
                        while (n14 < segment2.getEnd() - n7 && n13 < n12) {
                            int n21;
                            int n22 = n21 = Math.min(n18, segment2.getEnd() - n7 - n14);
                            if (n21 > 0) {
                                n22 = this.getCharsForLengthWithTabs(segment.array, n14, n13 * this.charsPerLine + n20, n21, n18);
                                if (n13 != n12 - 1 && n16 != n13) {
                                    n16 = n13;
                                    this.drawArrow(graphics, n5, n13 == n12 - 2);
                                }
                                Color color = segment2.getCustomBackground();
                                this.drawText(segment, graphics, n17, n5, n9, n14, n3, n22, n4, color);
                                if (segment2.getListener() != null) {
                                    this.underline(graphics, segment, n14, n22, n17, n5);
                                }
                            }
                            n21 = this.getCharLengthWithTabs(segment.array, n14, n13 * this.charsPerLine + n20, n22);
                            n14 += n22;
                            if (n22 == 0) continue block3;
                            n15 += n21;
                            n18 -= n21;
                            n17 += n21 * this.charWidth;
                            n20 += n21;
                            while (n18 <= 0) {
                                int n23;
                                int n24;
                                int n25;
                                n20 = -n18;
                                n18 += this.charsPerLine;
                                ++n13;
                                n17 = n20 * this.charWidth;
                                this.tabOffsetX += this.charWidth * this.charsPerLine;
                                if ((n5 += this.charHeight) > rectangle.y + rectangle.height) {
                                    return;
                                }
                                if (n20 <= 0 || n3 == n4 || (n25 = Math.max(n3, n24 = n9 + n14)) >= (n23 = Math.min(n4, n24 + n22))) continue;
                                this.drawSelection(graphics, 0, n17, n5);
                            }
                        }
                    }
                    if (this.charsPerLine != 0 && n15 % this.charsPerLine == 0) continue;
                    n5 += this.charHeight;
                }
                this.tabOffsetX = 0;
            }
            catch (BadLocationException badLocationException) {
                Exceptions.printStackTrace((Throwable)badLocationException);
            }
        }
    }

    private void drawText(Segment segment, Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6, int n7, Color color) {
        int n8;
        int n9;
        int n10;
        Color color2 = graphics.getColor();
        if (n5 != n7 && (n10 = Math.max(n5, n9 = n3 + n4)) < (n8 = Math.min(n7, n9 + n6))) {
            n9 = this.odoc().getLines().getNumLogicalChars(n3, n9 - n3) + n3;
            n10 = this.odoc().getLines().getNumLogicalChars(n3, n10 - n3) + n3;
            n8 = this.odoc().getLines().getNumLogicalChars(n3, n8 - n3) + n3;
            int n11 = n + WrappedTextView.margin() + (n10 - n9) * this.charWidth;
            int n12 = (n8 - n10) * this.charWidth;
            int n13 = this.charsPerLine * this.charWidth;
            if (n11 - WrappedTextView.margin() + n12 > n13) {
                n12 = n13 - n11 + WrappedTextView.margin();
            }
            graphics.setColor(this.comp.getSelectionColor());
            graphics.fillRect(n11, n2 + this.fontDescent - this.charHeight, n12, this.charHeight);
            graphics.setColor(color2);
        }
        n9 = segment.count;
        n10 = segment.offset;
        segment.count = n6;
        segment.offset = n4;
        this.drawTextBackground(graphics, color2, color, n5 != n7, segment, n, n2, n4);
        Utilities.drawTabbedText(segment, WrappedTextView.margin() + n, n2, graphics, (TabExpander)this, n4);
        segment.count = n9;
        segment.offset = n10;
    }

    private void drawTextBackground(Graphics graphics, Color color, Color color2, boolean bl, Segment segment, int n, int n2, int n3) {
        if (color2 != null && !bl) {
            int n4 = Utilities.getTabbedTextWidth(segment, graphics.getFontMetrics(), n, (TabExpander)this, n3);
            int n5 = graphics.getFontMetrics().getHeight();
            graphics.setColor(color2);
            graphics.fillRect(n + WrappedTextView.margin(), n2 - n5 + graphics.getFontMetrics().getDescent(), n4, n5);
        }
        graphics.setColor(color);
    }

    private void drawSelection(Graphics graphics, int n, int n2, int n3) {
        Color color = graphics.getColor();
        graphics.setColor(this.comp.getSelectionColor());
        graphics.fillRect(n + WrappedTextView.margin(), n3 + this.fontDescent - this.charHeight, n2 - n, this.charHeight);
        graphics.setColor(color);
    }

    private void underline(Graphics graphics, Segment segment, int n, int n2, int n3, int n4) {
        if (!ExtPlainView.isLinkUndeliningEnabled(this)) {
            return;
        }
        int n5 = WrappedTextView.margin() + n3;
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n6 = n5 + fontMetrics.charsWidth(segment.array, n, n2);
        int n7 = fontMetrics.getDescent() - 1;
        graphics.drawLine(n5, n4 + n7, n6, n4 + n7);
    }

    private void drawArrow(Graphics graphics, int n, boolean bl) {
        int n2;
        Color color = graphics.getColor();
        graphics.setColor(WrappedTextView.arrowColor());
        int n3 = this.width + 15;
        n += 2;
        int n4 = n2 = this.aa ? 8 : 4;
        if (this.aa) {
            graphics.drawArc(n3 - n2, n - this.charHeight / 2, n2 + 1, this.charHeight, 265, 185);
            ++n3;
        } else {
            graphics.drawLine(n3 - n2, n - this.charHeight / 2, n3, n - this.charHeight / 2);
            graphics.drawLine(n3, n - this.charHeight / 2 + 1, n3, n + this.charHeight / 2 - 1);
            graphics.drawLine(n3 - n2, n + this.charHeight / 2, n3, n + this.charHeight / 2);
        }
        if (bl) {
            n2 = this.aa ? 7 : 8;
            int[] nArray = new int[]{n3 - n2, n3 - n2 + 5, n3 - n2 + 5};
            int[] nArray2 = new int[]{n + this.charHeight / 2, n + this.charHeight / 2 - 5, n + this.charHeight / 2 + 5};
            graphics.fillPolygon(nArray, nArray2, 3);
        }
        graphics.setColor(WrappedTextView.arrowColor());
        graphics.drawLine(1, n - this.charHeight / 2, 5, n - this.charHeight / 2);
        graphics.drawLine(1, n - this.charHeight / 2, 1, n + this.charHeight / 2);
        graphics.drawLine(1, n + this.charHeight / 2, 5, n + this.charHeight / 2);
        graphics.setColor(color);
    }

    private static Color arrowColor() {
        return arrowColor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Shape modelToView(int n, Shape shape, Position.Bias bias) throws BadLocationException {
        Rectangle rectangle = new Rectangle();
        rectangle.setBounds(0, 0, this.charWidth, this.charHeight);
        OutputDocument outputDocument = this.odoc();
        if (outputDocument != null) {
            int n2;
            int n3;
            Object object = outputDocument.getLines().readLock();
            synchronized (object) {
                n3 = Math.max(0, outputDocument.getLines().getLineAt(n));
                n2 = outputDocument.getLineStart(n3);
            }
            int n4 = n - n2;
            n4 = outputDocument.getLines().getNumLogicalChars(n2, n4);
            int n5 = outputDocument.getLines().getLogicalLineCountAbove(n3, this.charsPerLine);
            int n6 = this.getLineEnd(n3, outputDocument.getLines());
            int n7 = outputDocument.getLines().getNumLogicalChars(n2, n6 - n2);
            if (n4 >= this.charsPerLine && this.charsPerLine != 0) {
                n5 += n4 % this.charsPerLine == 0 && n4 == n7 ? n4 / this.charsPerLine - 1 : n4 / this.charsPerLine;
                n4 = n4 % this.charsPerLine == 0 && n4 == n7 ? this.charsPerLine : n4 % this.charsPerLine;
            }
            rectangle.y = n5 * this.charHeight + this.fontDescent;
            rectangle.x = WrappedTextView.margin() + n4 * this.charWidth;
        }
        return rectangle;
    }

    @Override
    public int viewToModel(float f, float f2, Shape shape, Position.Bias[] biasArray) {
        OutputDocument outputDocument = this.odoc();
        if (outputDocument != null) {
            int n = Math.max((int)f - WrappedTextView.margin(), 0);
            int n2 = (int)f2 - this.fontDescent;
            WrappedTextView.ln[0] = n2 / this.charHeight;
            outputDocument.getLines().toPhysicalLineIndex(ln, this.charsPerLine);
            int n3 = ln[0];
            int n4 = ln[2] - 1;
            int n5 = outputDocument.getLines().getLineCount();
            if (n5 == 0) {
                return 0;
            }
            if (n3 >= n5) {
                return outputDocument.getLength();
            }
            int n6 = outputDocument.getLineStart(n3);
            int n7 = outputDocument.getLines().lengthWithTabs(n3);
            int n8 = n6 + n7;
            int n9 = n / this.charWidth;
            if (n9 > n7) {
                n9 = n7;
            }
            int n10 = n4 > 0 ? Math.min(n8, n6 + ln[1] * this.charsPerLine + n9) : Math.min(n6 + n9, n8);
            Lines lines = outputDocument.getLines();
            n10 = lines.getNumPhysicalChars(n6, n10 - n6, null) + n6;
            n10 = Math.min(outputDocument.getLength(), n10);
            return n10;
        }
        return 0;
    }

    private int getCharLengthWithTabs(char[] cArray, int n, int n2, int n3) {
        int n4 = Math.min(cArray.length, n + n3);
        int n5 = 0;
        for (int i = n; i < n4; ++i) {
            if ('\t' != cArray[i]) continue;
            int n6 = 8 - (i - n + n2 + n5) % 8;
            n5 += n6 - 1;
            n3 += n6 - 1;
        }
        return n3;
    }

    private int getCharsForLengthWithTabs(char[] cArray, int n, int n2, int n3, int n4) {
        int n5;
        int n6 = Math.min(cArray.length, n + n3);
        int n7 = 0;
        int n8 = 0;
        for (n5 = n; n5 < n6 && n7 < n4; ++n5) {
            if ('\t' == cArray[n5]) {
                int n9 = 8 - (n5 - n + n2 + n8) % 8;
                n8 += n9 - 1;
                n7 += n9;
                continue;
            }
            ++n7;
        }
        if (n7 > n4 && n5 > n + 1 && cArray[n5 - 1] != '\t') {
            --n5;
        }
        return n5 - n;
    }

    @Override
    public int getNextVisualPositionFrom(int n, Position.Bias bias, Shape shape, int n2, Position.Bias[] biasArray) throws BadLocationException {
        Element element = this.getElement();
        if (n == -1) {
            n = n2 == 5 || n2 == 3 ? this.getStartOffset() : this.getEndOffset() - 1;
        }
        Lines lines = this.odoc().getLines();
        switch (n2) {
            case 1: {
                PositionInfo positionInfo = this.getPositionInfo(n);
                if (positionInfo.lineIndex <= 0 && positionInfo.innerRowIndex <= 0) break;
                if (positionInfo.innerRowIndex > 0) {
                    return this.jumpInLine(lines, positionInfo, n2);
                }
                return this.jumpToLine(lines, positionInfo, n2);
            }
            case 5: {
                PositionInfo positionInfo = this.getPositionInfo(n);
                if (positionInfo.innerRowIndex < positionInfo.innerRowsCount - 1) {
                    return this.jumpInLine(lines, positionInfo, n2);
                }
                int n3 = lines.realToVisibleLine(positionInfo.lineIndex);
                if (n3 >= element.getElementCount() - 1) break;
                return this.jumpToLine(lines, positionInfo, n2);
            }
            case 7: {
                int n4 = lines.getLineAt(n);
                n = Math.max(0, n - 1);
                int n5 = lines.getLineAt(n);
                if (n4 == n5) break;
                int n6 = lines.realToVisibleLine(n4);
                n = element.getElement(n6 - 1).getEndOffset() - 1;
                break;
            }
            case 3: {
                int n7 = lines.getLineAt(n);
                n = Math.min(n + 1, element.getEndOffset() - 1);
                int n8 = lines.getLineAt(n);
                if (n7 == n8) break;
                int n9 = lines.realToVisibleLine(n7);
                n = element.getElement(n9 + 1).getStartOffset();
                break;
            }
            default: {
                throw new IllegalArgumentException("Bad direction");
            }
        }
        return n;
    }

    private PositionInfo getLineInfo(int n) {
        Lines lines = this.odoc().getLines();
        int n2 = lines.getLineStart(n);
        return this.getPositionInfo(lines, n, n2, n2);
    }

    private PositionInfo getPositionInfo(int n) {
        Lines lines = this.odoc().getLines();
        int n2 = lines.getLineAt(n);
        int n3 = lines.getLineStart(n2);
        return this.getPositionInfo(lines, n2, n3, n);
    }

    private PositionInfo getPositionInfo(Lines lines, int n, int n2, int n3) {
        PositionInfo positionInfo = new PositionInfo();
        positionInfo.offset = n3;
        positionInfo.lineIndex = n;
        positionInfo.lineStart = n2;
        positionInfo.lineEnd = this.getLineEnd(positionInfo.lineIndex, lines);
        int n4 = positionInfo.lineEnd - positionInfo.lineStart;
        int n5 = n3 - positionInfo.lineStart;
        int n6 = lines.getNumLogicalChars(positionInfo.lineStart, n5);
        positionInfo.logicalLineLength = lines.getNumLogicalChars(positionInfo.lineStart, n4);
        int n7 = positionInfo.logicalLineLength / this.charsPerLine + (positionInfo.logicalLineLength % this.charsPerLine > 0 ? 1 : 0);
        positionInfo.innerRowsCount = Math.max(1, n7);
        positionInfo.innerRowIndex = n6 / this.charsPerLine - (positionInfo.logicalLineLength > 0 && n6 == positionInfo.logicalLineLength && n6 % this.charsPerLine == 0 ? 1 : 0);
        positionInfo.innerColumn = n4 > 0 && positionInfo.lineEnd == n3 && positionInfo.logicalLineLength % this.charsPerLine == 0 ? this.charsPerLine - (positionInfo.innerRowsCount > 1 ? 1 : 0) : lines.getNumLogicalChars(positionInfo.lineStart, n3 - positionInfo.lineStart) % this.charsPerLine;
        return positionInfo;
    }

    private int jumpToLine(Lines lines, PositionInfo positionInfo, int n) {
        assert (n == 1 || n == 5);
        int n2 = this.findNearestVisibleLine(lines, positionInfo.lineIndex, n);
        if (n2 < 0) {
            return positionInfo.offset;
        }
        PositionInfo positionInfo2 = this.getLineInfo(n2);
        int n3 = n == 1 ? positionInfo2.innerRowsCount - 1 : 0;
        int n4 = positionInfo2.lineStart + lines.getNumPhysicalChars(positionInfo2.lineStart, n3 * this.charsPerLine, null);
        int n5 = lines.getNumPhysicalChars(n4, positionInfo.innerColumn, null);
        int n6 = this.fixPhysicalPosition(lines, n4 + n5, n3, positionInfo2.lineStart);
        return Math.min(n6, positionInfo2.lineEnd);
    }

    private int findNearestVisibleLine(Lines lines, int n, int n2) {
        assert (n2 == 5 || n2 == 1);
        int n3 = n2 == 5 ? 1 : -1;
        int n4 = lines.realToVisibleLine(n);
        if (n4 < 0) {
            for (int i = n + n3; i >= 0 && i < lines.getLineCount(); i += n3) {
                if (lines.realToVisibleLine(i) < 0) continue;
                return i;
            }
            return -1;
        }
        return lines.visibleToRealLine(n4 + n3);
    }

    private int jumpInLine(Lines lines, PositionInfo positionInfo, int n) {
        assert (n == 1 || n == 5);
        assert (positionInfo.innerRowIndex > 0 || n == 5);
        assert (positionInfo.innerRowIndex + 1 < positionInfo.innerRowsCount || n == 1);
        int n2 = positionInfo.innerRowIndex + (n == 5 ? 1 : -1);
        int n3 = n2 * this.charsPerLine + positionInfo.innerColumn;
        int n4 = positionInfo.lineStart + lines.getNumPhysicalChars(positionInfo.lineStart, n3, null);
        n4 = this.fixPhysicalPosition(lines, n4, n2, positionInfo.lineStart);
        return Math.min(positionInfo.lineEnd, Math.max(positionInfo.lineStart, n4));
    }

    private int fixPhysicalPosition(Lines lines, int n, int n2, int n3) {
        int n4 = n2 * this.charsPerLine;
        int n5 = lines.getNumLogicalChars(n3, n - n3);
        if (n5 < n4) {
            return n + 1;
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getLineEnd(int n, Lines lines) {
        Object object = lines.readLock();
        synchronized (object) {
            return n + 1 < lines.getLineCount() ? lines.getLineStart(n + 1) - 1 : lines.getCharCount();
        }
    }

    private static final class PositionInfo {
        public int offset;
        public int lineIndex;
        public int lineStart;
        public int lineEnd;
        public int logicalLineLength;
        public int innerRowsCount;
        public int innerRowIndex;
        public int innerColumn;

        private PositionInfo() {
        }
    }
}

