#include "catch2/catch_test_macros.hpp"
#include "utils/is_requester_allowed_to_persist.hpp"
#include "xmpp/jid.hpp"


TEST_CASE("default")
{
  Jid jid("foo@example.com");
  Config::clear();
  Config::set("persist_user_denylist", "");
  Config::set("persist_user_allowlist", "");
  Config::set("default_persistence_allowed", "");
  bool result = utils::is_requester_allowed_to_persist(jid);
  CHECK(result == true);
  Config::clear();
}

TEST_CASE("default - default_persistence_allowed - false")
{
  Jid jid("foo@example.com");
  Config::clear();
  Config::set("persist_user_denylist", "");
  Config::set("persist_user_allowlist", "");
  Config::set("default_persistence_allowed", "false");
  bool result = utils::is_requester_allowed_to_persist(jid);
  CHECK(result == false);
  Config::clear();
}

TEST_CASE("default - default_persistence_allowed - true")
{
  Jid jid("foo@example.com");
  Config::clear();
  Config::set("persist_user_denylist", "");
  Config::set("persist_user_allowlist", "");
  Config::set("default_persistence_allowed", "true");
  bool result = utils::is_requester_allowed_to_persist(jid);
  CHECK(result == true);
  Config::clear();
}

TEST_CASE("denylist - jid")
{
  Jid jid("foo@example.com");
  Config::clear();
  Config::set("persist_user_denylist", "foo@example.com");
  Config::set("persist_user_allowlist", "");
  Config::set("default_persistence_allowed", "");
  bool result = utils::is_requester_allowed_to_persist(jid);
  CHECK(result == false);
  Config::clear();
}

TEST_CASE("denylist - domain")
{
  Jid jid("foo@example.com");
  Config::clear();
  Config::set("persist_user_denylist", "example.com");
  Config::set("persist_user_allowlist", "");
  Config::set("default_persistence_allowed", "");
  bool result = utils::is_requester_allowed_to_persist(jid);
  CHECK(result == false);
  Config::clear();
}

TEST_CASE("allowlist - jid")
{
  Jid jid("foo@example.com");
  Config::clear();
  Config::set("persist_user_allowlist", "foo@example.com");
  Config::set("persist_user_denylist", "");
  Config::set("default_persistence_allowed", "");
  bool result = utils::is_requester_allowed_to_persist(jid);
  CHECK(result == true);
  Config::clear();
}

TEST_CASE("allowlist - domain")
{
  Jid jid("foo@example.com");
  Config::clear();
  Config::set("persist_user_allowlist", "example.com");
  Config::set("persist_user_denylist", "");
  Config::set("default_persistence_allowed", "");
  bool result = utils::is_requester_allowed_to_persist(jid);
  CHECK(result == true);
  Config::clear();
}

TEST_CASE("denylist + allowlist - deny domain, allow jid")
{
  Jid jid("foo@example.com");
  Config::clear();
  Config::set("persist_user_denylist", "example.com");
  Config::set("persist_user_allowlist", "foo@example.com");
  Config::set("default_persistence_allowed", "");
  bool result = utils::is_requester_allowed_to_persist(jid);
  CHECK(result == true);
  Config::clear();
}

TEST_CASE("denylist + allowlist - deny jid, allow domain")
{
  Jid jid("foo@example.com");
  Config::clear();
  Config::set("persist_user_denylist", "foo@example.com");
  Config::set("persist_user_allowlist", "example.com");
  Config::set("default_persistence_allowed", "");
  bool result = utils::is_requester_allowed_to_persist(jid);
  CHECK(result == false);
  Config::clear();
}

TEST_CASE("denylist + allowlist - deny jid, allow jid")
{
  Jid jid("foo@example.com");
  Config::clear();
  Config::set("persist_user_denylist", "foo@example.com");
  Config::set("persist_user_allowlist", "foo@example.com");
  Config::set("default_persistence_allowed", "");
  bool result = utils::is_requester_allowed_to_persist(jid);
  CHECK(result == false);
  Config::clear();
}

