<?php

declare(strict_types=1);

/**
 * This code was auto-generated by {this script}[https://github.com/cucumber/messages/blob/main/codegen/codegen.rb]
 */

namespace Cucumber\Messages;

use JsonSerializable;
use Cucumber\Messages\DecodingException\SchemaViolationException;

/**
 * Represents the TestRunFinished message in Cucumber's message protocol
 * @see https://github.com/cucumber/messages
 *
 */
final class TestRunFinished implements JsonSerializable
{
    use JsonEncodingTrait;

    /**
     * Construct the TestRunFinished with all properties
     *
     */
    public function __construct(

        /**
         * An informative message about the test run. Typically additional information about failure, but not necessarily.
         */
        public readonly ?string $message = null,

        /**
         * A test run is successful if all steps are either passed or skipped, all before/after hooks passed and no other exceptions where thrown.
         */
        public readonly bool $success = false,

        /**
         * Timestamp when the TestRun is finished
         */
        public readonly Timestamp $timestamp = new Timestamp(),

        /**
         * Any exception thrown during the test run, if any. Does not include exceptions thrown while executing steps.
         */
        public readonly ?Exception $exception = null,
        public readonly ?string $testRunStartedId = null,
    ) {
    }

    /**
     * @throws SchemaViolationException
     *
     * @internal
     */
    public static function fromArray(array $arr): self
    {
        self::ensureMessage($arr);
        self::ensureSuccess($arr);
        self::ensureTimestamp($arr);
        self::ensureException($arr);
        self::ensureTestRunStartedId($arr);

        return new self(
            isset($arr['message']) ? (string) $arr['message'] : null,
            (bool) $arr['success'],
            Timestamp::fromArray($arr['timestamp']),
            isset($arr['exception']) ? Exception::fromArray($arr['exception']) : null,
            isset($arr['testRunStartedId']) ? (string) $arr['testRunStartedId'] : null,
        );
    }

    /**
     * @psalm-assert array{message?: string|int|bool} $arr
     */
    private static function ensureMessage(array $arr): void
    {
        if (array_key_exists('message', $arr) && is_array($arr['message'])) {
            throw new SchemaViolationException('Property \'message\' was array');
        }
    }

    /**
     * @psalm-assert array{success: string|int|bool} $arr
     */
    private static function ensureSuccess(array $arr): void
    {
        if (!array_key_exists('success', $arr)) {
            throw new SchemaViolationException('Property \'success\' is required but was not found');
        }
        if (array_key_exists('success', $arr) && is_array($arr['success'])) {
            throw new SchemaViolationException('Property \'success\' was array');
        }
    }

    /**
     * @psalm-assert array{timestamp: array} $arr
     */
    private static function ensureTimestamp(array $arr): void
    {
        if (!array_key_exists('timestamp', $arr)) {
            throw new SchemaViolationException('Property \'timestamp\' is required but was not found');
        }
        if (array_key_exists('timestamp', $arr) && !is_array($arr['timestamp'])) {
            throw new SchemaViolationException('Property \'timestamp\' was not array');
        }
    }

    /**
     * @psalm-assert array{exception?: array} $arr
     */
    private static function ensureException(array $arr): void
    {
        if (array_key_exists('exception', $arr) && !is_array($arr['exception'])) {
            throw new SchemaViolationException('Property \'exception\' was not array');
        }
    }

    /**
     * @psalm-assert array{testRunStartedId?: string|int|bool} $arr
     */
    private static function ensureTestRunStartedId(array $arr): void
    {
        if (array_key_exists('testRunStartedId', $arr) && is_array($arr['testRunStartedId'])) {
            throw new SchemaViolationException('Property \'testRunStartedId\' was array');
        }
    }
}
