// DO NOT EDIT!
// Code generated by ffjson <https://github.com/pquerna/ffjson>
// source: mesos.pb.go
// DO NOT EDIT!

package mesos

import (
	"bytes"
	"encoding/base64"
	"errors"
	"fmt"
	fflib "github.com/pquerna/ffjson/fflib/v1"
	"reflect"
)

func (mj *Address) MarshalJSON() ([]byte, error) {
	var buf fflib.Buffer
	if mj == nil {
		buf.WriteString("null")
		return buf.Bytes(), nil
	}
	err := mj.MarshalJSONBuf(&buf)
	if err != nil {
		return nil, err
	}
	return buf.Bytes(), nil
}
func (mj *Address) MarshalJSONBuf(buf fflib.EncodingBuffer) error {
	if mj == nil {
		buf.WriteString("null")
		return nil
	}
	var err error
	var obj []byte
	_ = obj
	_ = err
	buf.WriteByte('{')
	if mj.Hostname != nil {
		if true {
			buf.WriteString(`"hostname":`)
			fflib.WriteJsonString(buf, string(*mj.Hostname))
			buf.WriteByte(',')
		}
	}
	if mj.IP != nil {
		if true {
			buf.WriteString(`"ip":`)
			fflib.WriteJsonString(buf, string(*mj.IP))
			buf.WriteByte(',')
		}
	}
	buf.WriteString(`"port":`)
	fflib.FormatBits2(buf, uint64(mj.Port), 10, mj.Port < 0)
	buf.WriteByte('}')
	return nil
}

const (
	ffj_t_Addressbase = iota
	ffj_t_Addressno_such_key

	ffj_t_Address_Hostname

	ffj_t_Address_IP

	ffj_t_Address_Port
)

var ffj_key_Address_Hostname = []byte("hostname")

var ffj_key_Address_IP = []byte("ip")

var ffj_key_Address_Port = []byte("port")

func (uj *Address) UnmarshalJSON(input []byte) error {
	fs := fflib.NewFFLexer(input)
	return uj.UnmarshalJSONFFLexer(fs, fflib.FFParse_map_start)
}

func (uj *Address) UnmarshalJSONFFLexer(fs *fflib.FFLexer, state fflib.FFParseState) error {
	var err error = nil
	currentKey := ffj_t_Addressbase
	_ = currentKey
	tok := fflib.FFTok_init
	wantedTok := fflib.FFTok_init

mainparse:
	for {
		tok = fs.Scan()
		//	println(fmt.Sprintf("debug: tok: %v  state: %v", tok, state))
		if tok == fflib.FFTok_error {
			goto tokerror
		}

		switch state {

		case fflib.FFParse_map_start:
			if tok != fflib.FFTok_left_bracket {
				wantedTok = fflib.FFTok_left_bracket
				goto wrongtokenerror
			}
			state = fflib.FFParse_want_key
			continue

		case fflib.FFParse_after_value:
			if tok == fflib.FFTok_comma {
				state = fflib.FFParse_want_key
			} else if tok == fflib.FFTok_right_bracket {
				goto done
			} else {
				wantedTok = fflib.FFTok_comma
				goto wrongtokenerror
			}

		case fflib.FFParse_want_key:
			// json {} ended. goto exit. woo.
			if tok == fflib.FFTok_right_bracket {
				goto done
			}
			if tok != fflib.FFTok_string {
				wantedTok = fflib.FFTok_string
				goto wrongtokenerror
			}

			kn := fs.Output.Bytes()
			if len(kn) <= 0 {
				// "" case. hrm.
				currentKey = ffj_t_Addressno_such_key
				state = fflib.FFParse_want_colon
				goto mainparse
			} else {
				switch kn[0] {

				case 'h':

					if bytes.Equal(ffj_key_Address_Hostname, kn) {
						currentKey = ffj_t_Address_Hostname
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				case 'i':

					if bytes.Equal(ffj_key_Address_IP, kn) {
						currentKey = ffj_t_Address_IP
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				case 'p':

					if bytes.Equal(ffj_key_Address_Port, kn) {
						currentKey = ffj_t_Address_Port
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				}

				if fflib.SimpleLetterEqualFold(ffj_key_Address_Port, kn) {
					currentKey = ffj_t_Address_Port
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.SimpleLetterEqualFold(ffj_key_Address_IP, kn) {
					currentKey = ffj_t_Address_IP
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffj_key_Address_Hostname, kn) {
					currentKey = ffj_t_Address_Hostname
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				currentKey = ffj_t_Addressno_such_key
				state = fflib.FFParse_want_colon
				goto mainparse
			}

		case fflib.FFParse_want_colon:
			if tok != fflib.FFTok_colon {
				wantedTok = fflib.FFTok_colon
				goto wrongtokenerror
			}
			state = fflib.FFParse_want_value
			continue
		case fflib.FFParse_want_value:

			if tok == fflib.FFTok_left_brace || tok == fflib.FFTok_left_bracket || tok == fflib.FFTok_integer || tok == fflib.FFTok_double || tok == fflib.FFTok_string || tok == fflib.FFTok_bool || tok == fflib.FFTok_null {
				switch currentKey {

				case ffj_t_Address_Hostname:
					goto handle_Hostname

				case ffj_t_Address_IP:
					goto handle_IP

				case ffj_t_Address_Port:
					goto handle_Port

				case ffj_t_Addressno_such_key:
					err = fs.SkipField(tok)
					if err != nil {
						return fs.WrapErr(err)
					}
					state = fflib.FFParse_after_value
					goto mainparse
				}
			} else {
				goto wantedvalue
			}
		}
	}

handle_Hostname:

	/* handler: uj.Hostname type=string kind=string quoted=false*/

	{

		{
			if tok != fflib.FFTok_string && tok != fflib.FFTok_null {
				return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for string", tok))
			}
		}

		if tok == fflib.FFTok_null {

			uj.Hostname = nil

		} else {

			var tval string
			outBuf := fs.Output.Bytes()

			tval = string(string(outBuf))
			uj.Hostname = &tval

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_IP:

	/* handler: uj.IP type=string kind=string quoted=false*/

	{

		{
			if tok != fflib.FFTok_string && tok != fflib.FFTok_null {
				return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for string", tok))
			}
		}

		if tok == fflib.FFTok_null {

			uj.IP = nil

		} else {

			var tval string
			outBuf := fs.Output.Bytes()

			tval = string(string(outBuf))
			uj.IP = &tval

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_Port:

	/* handler: uj.Port type=int32 kind=int32 quoted=false*/

	{
		if tok != fflib.FFTok_integer && tok != fflib.FFTok_null {
			return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for int32", tok))
		}
	}

	{

		if tok == fflib.FFTok_null {

		} else {

			tval, err := fflib.ParseInt(fs.Output.Bytes(), 10, 32)

			if err != nil {
				return fs.WrapErr(err)
			}

			uj.Port = int32(tval)

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

wantedvalue:
	return fs.WrapErr(fmt.Errorf("wanted value token, but got token: %v", tok))
wrongtokenerror:
	return fs.WrapErr(fmt.Errorf("ffjson: wanted token: %v, but got token: %v output=%s", wantedTok, tok, fs.Output.String()))
tokerror:
	if fs.BigError != nil {
		return fs.WrapErr(fs.BigError)
	}
	err = fs.Error.ToError()
	if err != nil {
		return fs.WrapErr(err)
	}
	panic("ffjson-generated: unreachable, please report bug.")
done:

	return nil
}

func (mj *AgentID) MarshalJSON() ([]byte, error) {
	var buf fflib.Buffer
	if mj == nil {
		buf.WriteString("null")
		return buf.Bytes(), nil
	}
	err := mj.MarshalJSONBuf(&buf)
	if err != nil {
		return nil, err
	}
	return buf.Bytes(), nil
}
func (mj *AgentID) MarshalJSONBuf(buf fflib.EncodingBuffer) error {
	if mj == nil {
		buf.WriteString("null")
		return nil
	}
	var err error
	var obj []byte
	_ = obj
	_ = err
	buf.WriteString(`{"value":`)
	fflib.WriteJsonString(buf, string(mj.Value))
	buf.WriteByte('}')
	return nil
}

const (
	ffj_t_AgentIDbase = iota
	ffj_t_AgentIDno_such_key

	ffj_t_AgentID_Value
)

var ffj_key_AgentID_Value = []byte("value")

func (uj *AgentID) UnmarshalJSON(input []byte) error {
	fs := fflib.NewFFLexer(input)
	return uj.UnmarshalJSONFFLexer(fs, fflib.FFParse_map_start)
}

func (uj *AgentID) UnmarshalJSONFFLexer(fs *fflib.FFLexer, state fflib.FFParseState) error {
	var err error = nil
	currentKey := ffj_t_AgentIDbase
	_ = currentKey
	tok := fflib.FFTok_init
	wantedTok := fflib.FFTok_init

mainparse:
	for {
		tok = fs.Scan()
		//	println(fmt.Sprintf("debug: tok: %v  state: %v", tok, state))
		if tok == fflib.FFTok_error {
			goto tokerror
		}

		switch state {

		case fflib.FFParse_map_start:
			if tok != fflib.FFTok_left_bracket {
				wantedTok = fflib.FFTok_left_bracket
				goto wrongtokenerror
			}
			state = fflib.FFParse_want_key
			continue

		case fflib.FFParse_after_value:
			if tok == fflib.FFTok_comma {
				state = fflib.FFParse_want_key
			} else if tok == fflib.FFTok_right_bracket {
				goto done
			} else {
				wantedTok = fflib.FFTok_comma
				goto wrongtokenerror
			}

		case fflib.FFParse_want_key:
			// json {} ended. goto exit. woo.
			if tok == fflib.FFTok_right_bracket {
				goto done
			}
			if tok != fflib.FFTok_string {
				wantedTok = fflib.FFTok_string
				goto wrongtokenerror
			}

			kn := fs.Output.Bytes()
			if len(kn) <= 0 {
				// "" case. hrm.
				currentKey = ffj_t_AgentIDno_such_key
				state = fflib.FFParse_want_colon
				goto mainparse
			} else {
				switch kn[0] {

				case 'v':

					if bytes.Equal(ffj_key_AgentID_Value, kn) {
						currentKey = ffj_t_AgentID_Value
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				}

				if fflib.SimpleLetterEqualFold(ffj_key_AgentID_Value, kn) {
					currentKey = ffj_t_AgentID_Value
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				currentKey = ffj_t_AgentIDno_such_key
				state = fflib.FFParse_want_colon
				goto mainparse
			}

		case fflib.FFParse_want_colon:
			if tok != fflib.FFTok_colon {
				wantedTok = fflib.FFTok_colon
				goto wrongtokenerror
			}
			state = fflib.FFParse_want_value
			continue
		case fflib.FFParse_want_value:

			if tok == fflib.FFTok_left_brace || tok == fflib.FFTok_left_bracket || tok == fflib.FFTok_integer || tok == fflib.FFTok_double || tok == fflib.FFTok_string || tok == fflib.FFTok_bool || tok == fflib.FFTok_null {
				switch currentKey {

				case ffj_t_AgentID_Value:
					goto handle_Value

				case ffj_t_AgentIDno_such_key:
					err = fs.SkipField(tok)
					if err != nil {
						return fs.WrapErr(err)
					}
					state = fflib.FFParse_after_value
					goto mainparse
				}
			} else {
				goto wantedvalue
			}
		}
	}

handle_Value:

	/* handler: uj.Value type=string kind=string quoted=false*/

	{

		{
			if tok != fflib.FFTok_string && tok != fflib.FFTok_null {
				return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for string", tok))
			}
		}

		if tok == fflib.FFTok_null {

		} else {

			outBuf := fs.Output.Bytes()

			uj.Value = string(string(outBuf))

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

wantedvalue:
	return fs.WrapErr(fmt.Errorf("wanted value token, but got token: %v", tok))
wrongtokenerror:
	return fs.WrapErr(fmt.Errorf("ffjson: wanted token: %v, but got token: %v output=%s", wantedTok, tok, fs.Output.String()))
tokerror:
	if fs.BigError != nil {
		return fs.WrapErr(fs.BigError)
	}
	err = fs.Error.ToError()
	if err != nil {
		return fs.WrapErr(err)
	}
	panic("ffjson-generated: unreachable, please report bug.")
done:

	return nil
}

func (mj *AgentInfo) MarshalJSON() ([]byte, error) {
	var buf fflib.Buffer
	if mj == nil {
		buf.WriteString("null")
		return buf.Bytes(), nil
	}
	err := mj.MarshalJSONBuf(&buf)
	if err != nil {
		return nil, err
	}
	return buf.Bytes(), nil
}
func (mj *AgentInfo) MarshalJSONBuf(buf fflib.EncodingBuffer) error {
	if mj == nil {
		buf.WriteString("null")
		return nil
	}
	var err error
	var obj []byte
	_ = obj
	_ = err
	buf.WriteString(`{ "hostname":`)
	fflib.WriteJsonString(buf, string(mj.Hostname))
	buf.WriteByte(',')
	if mj.Port != nil {
		if true {
			buf.WriteString(`"port":`)
			fflib.FormatBits2(buf, uint64(*mj.Port), 10, *mj.Port < 0)
			buf.WriteByte(',')
		}
	}
	buf.WriteString(`"resources":`)
	if mj.Resources != nil {
		buf.WriteString(`[`)
		for i, v := range mj.Resources {
			if i != 0 {
				buf.WriteString(`,`)
			}

			{

				err = v.MarshalJSONBuf(buf)
				if err != nil {
					return err
				}

			}
		}
		buf.WriteString(`]`)
	} else {
		buf.WriteString(`null`)
	}
	buf.WriteString(`,"attributes":`)
	if mj.Attributes != nil {
		buf.WriteString(`[`)
		for i, v := range mj.Attributes {
			if i != 0 {
				buf.WriteString(`,`)
			}

			{

				err = v.MarshalJSONBuf(buf)
				if err != nil {
					return err
				}

			}
		}
		buf.WriteString(`]`)
	} else {
		buf.WriteString(`null`)
	}
	buf.WriteByte(',')
	if mj.ID != nil {
		if true {
			buf.WriteString(`"id":`)

			{

				err = mj.ID.MarshalJSONBuf(buf)
				if err != nil {
					return err
				}

			}
			buf.WriteByte(',')
		}
	}
	if mj.Domain != nil {
		if true {
			buf.WriteString(`"domain":`)

			{

				err = mj.Domain.MarshalJSONBuf(buf)
				if err != nil {
					return err
				}

			}
			buf.WriteByte(',')
		}
	}
	buf.Rewind(1)
	buf.WriteByte('}')
	return nil
}

const (
	ffj_t_AgentInfobase = iota
	ffj_t_AgentInfono_such_key

	ffj_t_AgentInfo_Hostname

	ffj_t_AgentInfo_Port

	ffj_t_AgentInfo_Resources

	ffj_t_AgentInfo_Attributes

	ffj_t_AgentInfo_ID

	ffj_t_AgentInfo_Domain
)

var ffj_key_AgentInfo_Hostname = []byte("hostname")

var ffj_key_AgentInfo_Port = []byte("port")

var ffj_key_AgentInfo_Resources = []byte("resources")

var ffj_key_AgentInfo_Attributes = []byte("attributes")

var ffj_key_AgentInfo_ID = []byte("id")

var ffj_key_AgentInfo_Domain = []byte("domain")

func (uj *AgentInfo) UnmarshalJSON(input []byte) error {
	fs := fflib.NewFFLexer(input)
	return uj.UnmarshalJSONFFLexer(fs, fflib.FFParse_map_start)
}

func (uj *AgentInfo) UnmarshalJSONFFLexer(fs *fflib.FFLexer, state fflib.FFParseState) error {
	var err error = nil
	currentKey := ffj_t_AgentInfobase
	_ = currentKey
	tok := fflib.FFTok_init
	wantedTok := fflib.FFTok_init

mainparse:
	for {
		tok = fs.Scan()
		//	println(fmt.Sprintf("debug: tok: %v  state: %v", tok, state))
		if tok == fflib.FFTok_error {
			goto tokerror
		}

		switch state {

		case fflib.FFParse_map_start:
			if tok != fflib.FFTok_left_bracket {
				wantedTok = fflib.FFTok_left_bracket
				goto wrongtokenerror
			}
			state = fflib.FFParse_want_key
			continue

		case fflib.FFParse_after_value:
			if tok == fflib.FFTok_comma {
				state = fflib.FFParse_want_key
			} else if tok == fflib.FFTok_right_bracket {
				goto done
			} else {
				wantedTok = fflib.FFTok_comma
				goto wrongtokenerror
			}

		case fflib.FFParse_want_key:
			// json {} ended. goto exit. woo.
			if tok == fflib.FFTok_right_bracket {
				goto done
			}
			if tok != fflib.FFTok_string {
				wantedTok = fflib.FFTok_string
				goto wrongtokenerror
			}

			kn := fs.Output.Bytes()
			if len(kn) <= 0 {
				// "" case. hrm.
				currentKey = ffj_t_AgentInfono_such_key
				state = fflib.FFParse_want_colon
				goto mainparse
			} else {
				switch kn[0] {

				case 'a':

					if bytes.Equal(ffj_key_AgentInfo_Attributes, kn) {
						currentKey = ffj_t_AgentInfo_Attributes
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				case 'd':

					if bytes.Equal(ffj_key_AgentInfo_Domain, kn) {
						currentKey = ffj_t_AgentInfo_Domain
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				case 'h':

					if bytes.Equal(ffj_key_AgentInfo_Hostname, kn) {
						currentKey = ffj_t_AgentInfo_Hostname
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				case 'i':

					if bytes.Equal(ffj_key_AgentInfo_ID, kn) {
						currentKey = ffj_t_AgentInfo_ID
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				case 'p':

					if bytes.Equal(ffj_key_AgentInfo_Port, kn) {
						currentKey = ffj_t_AgentInfo_Port
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				case 'r':

					if bytes.Equal(ffj_key_AgentInfo_Resources, kn) {
						currentKey = ffj_t_AgentInfo_Resources
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				}

				if fflib.SimpleLetterEqualFold(ffj_key_AgentInfo_Domain, kn) {
					currentKey = ffj_t_AgentInfo_Domain
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.SimpleLetterEqualFold(ffj_key_AgentInfo_ID, kn) {
					currentKey = ffj_t_AgentInfo_ID
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffj_key_AgentInfo_Attributes, kn) {
					currentKey = ffj_t_AgentInfo_Attributes
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffj_key_AgentInfo_Resources, kn) {
					currentKey = ffj_t_AgentInfo_Resources
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.SimpleLetterEqualFold(ffj_key_AgentInfo_Port, kn) {
					currentKey = ffj_t_AgentInfo_Port
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffj_key_AgentInfo_Hostname, kn) {
					currentKey = ffj_t_AgentInfo_Hostname
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				currentKey = ffj_t_AgentInfono_such_key
				state = fflib.FFParse_want_colon
				goto mainparse
			}

		case fflib.FFParse_want_colon:
			if tok != fflib.FFTok_colon {
				wantedTok = fflib.FFTok_colon
				goto wrongtokenerror
			}
			state = fflib.FFParse_want_value
			continue
		case fflib.FFParse_want_value:

			if tok == fflib.FFTok_left_brace || tok == fflib.FFTok_left_bracket || tok == fflib.FFTok_integer || tok == fflib.FFTok_double || tok == fflib.FFTok_string || tok == fflib.FFTok_bool || tok == fflib.FFTok_null {
				switch currentKey {

				case ffj_t_AgentInfo_Hostname:
					goto handle_Hostname

				case ffj_t_AgentInfo_Port:
					goto handle_Port

				case ffj_t_AgentInfo_Resources:
					goto handle_Resources

				case ffj_t_AgentInfo_Attributes:
					goto handle_Attributes

				case ffj_t_AgentInfo_ID:
					goto handle_ID

				case ffj_t_AgentInfo_Domain:
					goto handle_Domain

				case ffj_t_AgentInfono_such_key:
					err = fs.SkipField(tok)
					if err != nil {
						return fs.WrapErr(err)
					}
					state = fflib.FFParse_after_value
					goto mainparse
				}
			} else {
				goto wantedvalue
			}
		}
	}

handle_Hostname:

	/* handler: uj.Hostname type=string kind=string quoted=false*/

	{

		{
			if tok != fflib.FFTok_string && tok != fflib.FFTok_null {
				return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for string", tok))
			}
		}

		if tok == fflib.FFTok_null {

		} else {

			outBuf := fs.Output.Bytes()

			uj.Hostname = string(string(outBuf))

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_Port:

	/* handler: uj.Port type=int32 kind=int32 quoted=false*/

	{
		if tok != fflib.FFTok_integer && tok != fflib.FFTok_null {
			return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for int32", tok))
		}
	}

	{

		if tok == fflib.FFTok_null {

			uj.Port = nil

		} else {

			tval, err := fflib.ParseInt(fs.Output.Bytes(), 10, 32)

			if err != nil {
				return fs.WrapErr(err)
			}

			ttypval := int32(tval)
			uj.Port = &ttypval

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_Resources:

	/* handler: uj.Resources type=[]mesos.Resource kind=slice quoted=false*/

	{

		{
			if tok != fflib.FFTok_left_brace && tok != fflib.FFTok_null {
				return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for ", tok))
			}
		}

		if tok == fflib.FFTok_null {
			uj.Resources = nil
		} else {

			uj.Resources = []Resource{}

			wantVal := true

			for {

				var tmp_uj__Resources Resource

				tok = fs.Scan()
				if tok == fflib.FFTok_error {
					goto tokerror
				}
				if tok == fflib.FFTok_right_brace {
					break
				}

				if tok == fflib.FFTok_comma {
					if wantVal == true {
						// TODO(pquerna): this isn't an ideal error message, this handles
						// things like [,,,] as an array value.
						return fs.WrapErr(fmt.Errorf("wanted value token, but got token: %v", tok))
					}
					continue
				} else {
					wantVal = true
				}

				/* handler: tmp_uj__Resources type=mesos.Resource kind=struct quoted=false*/

				{
					if tok == fflib.FFTok_null {

						state = fflib.FFParse_after_value
						goto mainparse
					}

					err = tmp_uj__Resources.UnmarshalJSONFFLexer(fs, fflib.FFParse_want_key)
					if err != nil {
						return err
					}
					state = fflib.FFParse_after_value
				}

				uj.Resources = append(uj.Resources, tmp_uj__Resources)

				wantVal = false
			}
		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_Attributes:

	/* handler: uj.Attributes type=[]mesos.Attribute kind=slice quoted=false*/

	{

		{
			if tok != fflib.FFTok_left_brace && tok != fflib.FFTok_null {
				return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for ", tok))
			}
		}

		if tok == fflib.FFTok_null {
			uj.Attributes = nil
		} else {

			uj.Attributes = []Attribute{}

			wantVal := true

			for {

				var tmp_uj__Attributes Attribute

				tok = fs.Scan()
				if tok == fflib.FFTok_error {
					goto tokerror
				}
				if tok == fflib.FFTok_right_brace {
					break
				}

				if tok == fflib.FFTok_comma {
					if wantVal == true {
						// TODO(pquerna): this isn't an ideal error message, this handles
						// things like [,,,] as an array value.
						return fs.WrapErr(fmt.Errorf("wanted value token, but got token: %v", tok))
					}
					continue
				} else {
					wantVal = true
				}

				/* handler: tmp_uj__Attributes type=mesos.Attribute kind=struct quoted=false*/

				{
					if tok == fflib.FFTok_null {

						state = fflib.FFParse_after_value
						goto mainparse
					}

					err = tmp_uj__Attributes.UnmarshalJSONFFLexer(fs, fflib.FFParse_want_key)
					if err != nil {
						return err
					}
					state = fflib.FFParse_after_value
				}

				uj.Attributes = append(uj.Attributes, tmp_uj__Attributes)

				wantVal = false
			}
		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_ID:

	/* handler: uj.ID type=mesos.AgentID kind=struct quoted=false*/

	{
		if tok == fflib.FFTok_null {

			uj.ID = nil

			state = fflib.FFParse_after_value
			goto mainparse
		}

		if uj.ID == nil {
			uj.ID = new(AgentID)
		}

		err = uj.ID.UnmarshalJSONFFLexer(fs, fflib.FFParse_want_key)
		if err != nil {
			return err
		}
		state = fflib.FFParse_after_value
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_Domain:

	/* handler: uj.Domain type=mesos.DomainInfo kind=struct quoted=false*/

	{
		if tok == fflib.FFTok_null {

			uj.Domain = nil

			state = fflib.FFParse_after_value
			goto mainparse
		}

		if uj.Domain == nil {
			uj.Domain = new(DomainInfo)
		}

		err = uj.Domain.UnmarshalJSONFFLexer(fs, fflib.FFParse_want_key)
		if err != nil {
			return err
		}
		state = fflib.FFParse_after_value
	}

	state = fflib.FFParse_after_value
	goto mainparse

wantedvalue:
	return fs.WrapErr(fmt.Errorf("wanted value token, but got token: %v", tok))
wrongtokenerror:
	return fs.WrapErr(fmt.Errorf("ffjson: wanted token: %v, but got token: %v output=%s", wantedTok, tok, fs.Output.String()))
tokerror:
	if fs.BigError != nil {
		return fs.WrapErr(fs.BigError)
	}
	err = fs.Error.ToError()
	if err != nil {
		return fs.WrapErr(err)
	}
	panic("ffjson-generated: unreachable, please report bug.")
done:

	return nil
}

func (mj *AgentInfo_Capability) MarshalJSON() ([]byte, error) {
	var buf fflib.Buffer
	if mj == nil {
		buf.WriteString("null")
		return buf.Bytes(), nil
	}
	err := mj.MarshalJSONBuf(&buf)
	if err != nil {
		return nil, err
	}
	return buf.Bytes(), nil
}
func (mj *AgentInfo_Capability) MarshalJSONBuf(buf fflib.EncodingBuffer) error {
	if mj == nil {
		buf.WriteString("null")
		return nil
	}
	var err error
	var obj []byte
	_ = obj
	_ = err
	buf.WriteString(`{"type":`)

	{

		obj, err = mj.Type.MarshalJSON()
		if err != nil {
			return err
		}
		buf.Write(obj)

	}
	buf.WriteByte('}')
	return nil
}

const (
	ffj_t_AgentInfo_Capabilitybase = iota
	ffj_t_AgentInfo_Capabilityno_such_key

	ffj_t_AgentInfo_Capability_Type
)

var ffj_key_AgentInfo_Capability_Type = []byte("type")

func (uj *AgentInfo_Capability) UnmarshalJSON(input []byte) error {
	fs := fflib.NewFFLexer(input)
	return uj.UnmarshalJSONFFLexer(fs, fflib.FFParse_map_start)
}

func (uj *AgentInfo_Capability) UnmarshalJSONFFLexer(fs *fflib.FFLexer, state fflib.FFParseState) error {
	var err error = nil
	currentKey := ffj_t_AgentInfo_Capabilitybase
	_ = currentKey
	tok := fflib.FFTok_init
	wantedTok := fflib.FFTok_init

mainparse:
	for {
		tok = fs.Scan()
		//	println(fmt.Sprintf("debug: tok: %v  state: %v", tok, state))
		if tok == fflib.FFTok_error {
			goto tokerror
		}

		switch state {

		case fflib.FFParse_map_start:
			if tok != fflib.FFTok_left_bracket {
				wantedTok = fflib.FFTok_left_bracket
				goto wrongtokenerror
			}
			state = fflib.FFParse_want_key
			continue

		case fflib.FFParse_after_value:
			if tok == fflib.FFTok_comma {
				state = fflib.FFParse_want_key
			} else if tok == fflib.FFTok_right_bracket {
				goto done
			} else {
				wantedTok = fflib.FFTok_comma
				goto wrongtokenerror
			}

		case fflib.FFParse_want_key:
			// json {} ended. goto exit. woo.
			if tok == fflib.FFTok_right_bracket {
				goto done
			}
			if tok != fflib.FFTok_string {
				wantedTok = fflib.FFTok_string
				goto wrongtokenerror
			}

			kn := fs.Output.Bytes()
			if len(kn) <= 0 {
				// "" case. hrm.
				currentKey = ffj_t_AgentInfo_Capabilityno_such_key
				state = fflib.FFParse_want_colon
				goto mainparse
			} else {
				switch kn[0] {

				case 't':

					if bytes.Equal(ffj_key_AgentInfo_Capability_Type, kn) {
						currentKey = ffj_t_AgentInfo_Capability_Type
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				}

				if fflib.SimpleLetterEqualFold(ffj_key_AgentInfo_Capability_Type, kn) {
					currentKey = ffj_t_AgentInfo_Capability_Type
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				currentKey = ffj_t_AgentInfo_Capabilityno_such_key
				state = fflib.FFParse_want_colon
				goto mainparse
			}

		case fflib.FFParse_want_colon:
			if tok != fflib.FFTok_colon {
				wantedTok = fflib.FFTok_colon
				goto wrongtokenerror
			}
			state = fflib.FFParse_want_value
			continue
		case fflib.FFParse_want_value:

			if tok == fflib.FFTok_left_brace || tok == fflib.FFTok_left_bracket || tok == fflib.FFTok_integer || tok == fflib.FFTok_double || tok == fflib.FFTok_string || tok == fflib.FFTok_bool || tok == fflib.FFTok_null {
				switch currentKey {

				case ffj_t_AgentInfo_Capability_Type:
					goto handle_Type

				case ffj_t_AgentInfo_Capabilityno_such_key:
					err = fs.SkipField(tok)
					if err != nil {
						return fs.WrapErr(err)
					}
					state = fflib.FFParse_after_value
					goto mainparse
				}
			} else {
				goto wantedvalue
			}
		}
	}

handle_Type:

	/* handler: uj.Type type=mesos.AgentInfo_Capability_Type kind=int32 quoted=false*/

	{
		if tok == fflib.FFTok_null {

			state = fflib.FFParse_after_value
			goto mainparse
		}

		tbuf, err := fs.CaptureField(tok)
		if err != nil {
			return fs.WrapErr(err)
		}

		err = uj.Type.UnmarshalJSON(tbuf)
		if err != nil {
			return fs.WrapErr(err)
		}
		state = fflib.FFParse_after_value
	}

	state = fflib.FFParse_after_value
	goto mainparse

wantedvalue:
	return fs.WrapErr(fmt.Errorf("wanted value token, but got token: %v", tok))
wrongtokenerror:
	return fs.WrapErr(fmt.Errorf("ffjson: wanted token: %v, but got token: %v output=%s", wantedTok, tok, fs.Output.String()))
tokerror:
	if fs.BigError != nil {
		return fs.WrapErr(fs.BigError)
	}
	err = fs.Error.ToError()
	if err != nil {
		return fs.WrapErr(err)
	}
	panic("ffjson-generated: unreachable, please report bug.")
done:

	return nil
}

func (mj *Attribute) MarshalJSON() ([]byte, error) {
	var buf fflib.Buffer
	if mj == nil {
		buf.WriteString("null")
		return buf.Bytes(), nil
	}
	err := mj.MarshalJSONBuf(&buf)
	if err != nil {
		return nil, err
	}
	return buf.Bytes(), nil
}
func (mj *Attribute) MarshalJSONBuf(buf fflib.EncodingBuffer) error {
	if mj == nil {
		buf.WriteString("null")
		return nil
	}
	var err error
	var obj []byte
	_ = obj
	_ = err
	buf.WriteString(`{ "name":`)
	fflib.WriteJsonString(buf, string(mj.Name))
	buf.WriteString(`,"type":`)

	{

		obj, err = mj.Type.MarshalJSON()
		if err != nil {
			return err
		}
		buf.Write(obj)

	}
	buf.WriteByte(',')
	if mj.Scalar != nil {
		if true {
			buf.WriteString(`"scalar":`)

			{

				err = mj.Scalar.MarshalJSONBuf(buf)
				if err != nil {
					return err
				}

			}
			buf.WriteByte(',')
		}
	}
	if mj.Ranges != nil {
		if true {
			buf.WriteString(`"ranges":`)

			{

				err = mj.Ranges.MarshalJSONBuf(buf)
				if err != nil {
					return err
				}

			}
			buf.WriteByte(',')
		}
	}
	if mj.Set != nil {
		if true {
			buf.WriteString(`"set":`)

			{

				err = mj.Set.MarshalJSONBuf(buf)
				if err != nil {
					return err
				}

			}
			buf.WriteByte(',')
		}
	}
	if mj.Text != nil {
		if true {
			buf.WriteString(`"text":`)

			{

				err = mj.Text.MarshalJSONBuf(buf)
				if err != nil {
					return err
				}

			}
			buf.WriteByte(',')
		}
	}
	buf.Rewind(1)
	buf.WriteByte('}')
	return nil
}

const (
	ffj_t_Attributebase = iota
	ffj_t_Attributeno_such_key

	ffj_t_Attribute_Name

	ffj_t_Attribute_Type

	ffj_t_Attribute_Scalar

	ffj_t_Attribute_Ranges

	ffj_t_Attribute_Set

	ffj_t_Attribute_Text
)

var ffj_key_Attribute_Name = []byte("name")

var ffj_key_Attribute_Type = []byte("type")

var ffj_key_Attribute_Scalar = []byte("scalar")

var ffj_key_Attribute_Ranges = []byte("ranges")

var ffj_key_Attribute_Set = []byte("set")

var ffj_key_Attribute_Text = []byte("text")

func (uj *Attribute) UnmarshalJSON(input []byte) error {
	fs := fflib.NewFFLexer(input)
	return uj.UnmarshalJSONFFLexer(fs, fflib.FFParse_map_start)
}

func (uj *Attribute) UnmarshalJSONFFLexer(fs *fflib.FFLexer, state fflib.FFParseState) error {
	var err error = nil
	currentKey := ffj_t_Attributebase
	_ = currentKey
	tok := fflib.FFTok_init
	wantedTok := fflib.FFTok_init

mainparse:
	for {
		tok = fs.Scan()
		//	println(fmt.Sprintf("debug: tok: %v  state: %v", tok, state))
		if tok == fflib.FFTok_error {
			goto tokerror
		}

		switch state {

		case fflib.FFParse_map_start:
			if tok != fflib.FFTok_left_bracket {
				wantedTok = fflib.FFTok_left_bracket
				goto wrongtokenerror
			}
			state = fflib.FFParse_want_key
			continue

		case fflib.FFParse_after_value:
			if tok == fflib.FFTok_comma {
				state = fflib.FFParse_want_key
			} else if tok == fflib.FFTok_right_bracket {
				goto done
			} else {
				wantedTok = fflib.FFTok_comma
				goto wrongtokenerror
			}

		case fflib.FFParse_want_key:
			// json {} ended. goto exit. woo.
			if tok == fflib.FFTok_right_bracket {
				goto done
			}
			if tok != fflib.FFTok_string {
				wantedTok = fflib.FFTok_string
				goto wrongtokenerror
			}

			kn := fs.Output.Bytes()
			if len(kn) <= 0 {
				// "" case. hrm.
				currentKey = ffj_t_Attributeno_such_key
				state = fflib.FFParse_want_colon
				goto mainparse
			} else {
				switch kn[0] {

				case 'n':

					if bytes.Equal(ffj_key_Attribute_Name, kn) {
						currentKey = ffj_t_Attribute_Name
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				case 'r':

					if bytes.Equal(ffj_key_Attribute_Ranges, kn) {
						currentKey = ffj_t_Attribute_Ranges
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				case 's':

					if bytes.Equal(ffj_key_Attribute_Scalar, kn) {
						currentKey = ffj_t_Attribute_Scalar
						state = fflib.FFParse_want_colon
						goto mainparse

					} else if bytes.Equal(ffj_key_Attribute_Set, kn) {
						currentKey = ffj_t_Attribute_Set
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				case 't':

					if bytes.Equal(ffj_key_Attribute_Type, kn) {
						currentKey = ffj_t_Attribute_Type
						state = fflib.FFParse_want_colon
						goto mainparse

					} else if bytes.Equal(ffj_key_Attribute_Text, kn) {
						currentKey = ffj_t_Attribute_Text
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				}

				if fflib.SimpleLetterEqualFold(ffj_key_Attribute_Text, kn) {
					currentKey = ffj_t_Attribute_Text
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffj_key_Attribute_Set, kn) {
					currentKey = ffj_t_Attribute_Set
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffj_key_Attribute_Ranges, kn) {
					currentKey = ffj_t_Attribute_Ranges
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffj_key_Attribute_Scalar, kn) {
					currentKey = ffj_t_Attribute_Scalar
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.SimpleLetterEqualFold(ffj_key_Attribute_Type, kn) {
					currentKey = ffj_t_Attribute_Type
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.SimpleLetterEqualFold(ffj_key_Attribute_Name, kn) {
					currentKey = ffj_t_Attribute_Name
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				currentKey = ffj_t_Attributeno_such_key
				state = fflib.FFParse_want_colon
				goto mainparse
			}

		case fflib.FFParse_want_colon:
			if tok != fflib.FFTok_colon {
				wantedTok = fflib.FFTok_colon
				goto wrongtokenerror
			}
			state = fflib.FFParse_want_value
			continue
		case fflib.FFParse_want_value:

			if tok == fflib.FFTok_left_brace || tok == fflib.FFTok_left_bracket || tok == fflib.FFTok_integer || tok == fflib.FFTok_double || tok == fflib.FFTok_string || tok == fflib.FFTok_bool || tok == fflib.FFTok_null {
				switch currentKey {

				case ffj_t_Attribute_Name:
					goto handle_Name

				case ffj_t_Attribute_Type:
					goto handle_Type

				case ffj_t_Attribute_Scalar:
					goto handle_Scalar

				case ffj_t_Attribute_Ranges:
					goto handle_Ranges

				case ffj_t_Attribute_Set:
					goto handle_Set

				case ffj_t_Attribute_Text:
					goto handle_Text

				case ffj_t_Attributeno_such_key:
					err = fs.SkipField(tok)
					if err != nil {
						return fs.WrapErr(err)
					}
					state = fflib.FFParse_after_value
					goto mainparse
				}
			} else {
				goto wantedvalue
			}
		}
	}

handle_Name:

	/* handler: uj.Name type=string kind=string quoted=false*/

	{

		{
			if tok != fflib.FFTok_string && tok != fflib.FFTok_null {
				return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for string", tok))
			}
		}

		if tok == fflib.FFTok_null {

		} else {

			outBuf := fs.Output.Bytes()

			uj.Name = string(string(outBuf))

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_Type:

	/* handler: uj.Type type=mesos.Value_Type kind=int32 quoted=false*/

	{
		if tok == fflib.FFTok_null {

			state = fflib.FFParse_after_value
			goto mainparse
		}

		tbuf, err := fs.CaptureField(tok)
		if err != nil {
			return fs.WrapErr(err)
		}

		err = uj.Type.UnmarshalJSON(tbuf)
		if err != nil {
			return fs.WrapErr(err)
		}
		state = fflib.FFParse_after_value
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_Scalar:

	/* handler: uj.Scalar type=mesos.Value_Scalar kind=struct quoted=false*/

	{
		if tok == fflib.FFTok_null {

			uj.Scalar = nil

			state = fflib.FFParse_after_value
			goto mainparse
		}

		if uj.Scalar == nil {
			uj.Scalar = new(Value_Scalar)
		}

		err = uj.Scalar.UnmarshalJSONFFLexer(fs, fflib.FFParse_want_key)
		if err != nil {
			return err
		}
		state = fflib.FFParse_after_value
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_Ranges:

	/* handler: uj.Ranges type=mesos.Value_Ranges kind=struct quoted=false*/

	{
		if tok == fflib.FFTok_null {

			uj.Ranges = nil

			state = fflib.FFParse_after_value
			goto mainparse
		}

		if uj.Ranges == nil {
			uj.Ranges = new(Value_Ranges)
		}

		err = uj.Ranges.UnmarshalJSONFFLexer(fs, fflib.FFParse_want_key)
		if err != nil {
			return err
		}
		state = fflib.FFParse_after_value
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_Set:

	/* handler: uj.Set type=mesos.Value_Set kind=struct quoted=false*/

	{
		if tok == fflib.FFTok_null {

			uj.Set = nil

			state = fflib.FFParse_after_value
			goto mainparse
		}

		if uj.Set == nil {
			uj.Set = new(Value_Set)
		}

		err = uj.Set.UnmarshalJSONFFLexer(fs, fflib.FFParse_want_key)
		if err != nil {
			return err
		}
		state = fflib.FFParse_after_value
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_Text:

	/* handler: uj.Text type=mesos.Value_Text kind=struct quoted=false*/

	{
		if tok == fflib.FFTok_null {

			uj.Text = nil

			state = fflib.FFParse_after_value
			goto mainparse
		}

		if uj.Text == nil {
			uj.Text = new(Value_Text)
		}

		err = uj.Text.UnmarshalJSONFFLexer(fs, fflib.FFParse_want_key)
		if err != nil {
			return err
		}
		state = fflib.FFParse_after_value
	}

	state = fflib.FFParse_after_value
	goto mainparse

wantedvalue:
	return fs.WrapErr(fmt.Errorf("wanted value token, but got token: %v", tok))
wrongtokenerror:
	return fs.WrapErr(fmt.Errorf("ffjson: wanted token: %v, but got token: %v output=%s", wantedTok, tok, fs.Output.String()))
tokerror:
	if fs.BigError != nil {
		return fs.WrapErr(fs.BigError)
	}
	err = fs.Error.ToError()
	if err != nil {
		return fs.WrapErr(err)
	}
	panic("ffjson-generated: unreachable, please report bug.")
done:

	return nil
}

func (mj *CSIPluginContainerInfo) MarshalJSON() ([]byte, error) {
	var buf fflib.Buffer
	if mj == nil {
		buf.WriteString("null")
		return buf.Bytes(), nil
	}
	err := mj.MarshalJSONBuf(&buf)
	if err != nil {
		return nil, err
	}
	return buf.Bytes(), nil
}
func (mj *CSIPluginContainerInfo) MarshalJSONBuf(buf fflib.EncodingBuffer) error {
	if mj == nil {
		buf.WriteString("null")
		return nil
	}
	var err error
	var obj []byte
	_ = obj
	_ = err
	buf.WriteString(`{ `)
	if len(mj.Services) != 0 {
		buf.WriteString(`"services":`)
		if mj.Services != nil {
			buf.WriteString(`[`)
			for i, v := range mj.Services {
				if i != 0 {
					buf.WriteString(`,`)
				}

				{

					obj, err = v.MarshalJSON()
					if err != nil {
						return err
					}
					buf.Write(obj)

				}
			}
			buf.WriteString(`]`)
		} else {
			buf.WriteString(`null`)
		}
		buf.WriteByte(',')
	}
	if mj.Command != nil {
		if true {
			buf.WriteString(`"command":`)

			{

				err = mj.Command.MarshalJSONBuf(buf)
				if err != nil {
					return err
				}

			}
			buf.WriteByte(',')
		}
	}
	buf.WriteString(`"resources":`)
	if mj.Resources != nil {
		buf.WriteString(`[`)
		for i, v := range mj.Resources {
			if i != 0 {
				buf.WriteString(`,`)
			}

			{

				err = v.MarshalJSONBuf(buf)
				if err != nil {
					return err
				}

			}
		}
		buf.WriteString(`]`)
	} else {
		buf.WriteString(`null`)
	}
	buf.WriteByte(',')
	if mj.Container != nil {
		if true {
			buf.WriteString(`"container":`)

			{

				err = mj.Container.MarshalJSONBuf(buf)
				if err != nil {
					return err
				}

			}
			buf.WriteByte(',')
		}
	}
	buf.Rewind(1)
	buf.WriteByte('}')
	return nil
}

const (
	ffj_t_CSIPluginContainerInfobase = iota
	ffj_t_CSIPluginContainerInfono_such_key

	ffj_t_CSIPluginContainerInfo_Services

	ffj_t_CSIPluginContainerInfo_Command

	ffj_t_CSIPluginContainerInfo_Resources

	ffj_t_CSIPluginContainerInfo_Container
)

var ffj_key_CSIPluginContainerInfo_Services = []byte("services")

var ffj_key_CSIPluginContainerInfo_Command = []byte("command")

var ffj_key_CSIPluginContainerInfo_Resources = []byte("resources")

var ffj_key_CSIPluginContainerInfo_Container = []byte("container")

func (uj *CSIPluginContainerInfo) UnmarshalJSON(input []byte) error {
	fs := fflib.NewFFLexer(input)
	return uj.UnmarshalJSONFFLexer(fs, fflib.FFParse_map_start)
}

func (uj *CSIPluginContainerInfo) UnmarshalJSONFFLexer(fs *fflib.FFLexer, state fflib.FFParseState) error {
	var err error = nil
	currentKey := ffj_t_CSIPluginContainerInfobase
	_ = currentKey
	tok := fflib.FFTok_init
	wantedTok := fflib.FFTok_init

mainparse:
	for {
		tok = fs.Scan()
		//	println(fmt.Sprintf("debug: tok: %v  state: %v", tok, state))
		if tok == fflib.FFTok_error {
			goto tokerror
		}

		switch state {

		case fflib.FFParse_map_start:
			if tok != fflib.FFTok_left_bracket {
				wantedTok = fflib.FFTok_left_bracket
				goto wrongtokenerror
			}
			state = fflib.FFParse_want_key
			continue

		case fflib.FFParse_after_value:
			if tok == fflib.FFTok_comma {
				state = fflib.FFParse_want_key
			} else if tok == fflib.FFTok_right_bracket {
				goto done
			} else {
				wantedTok = fflib.FFTok_comma
				goto wrongtokenerror
			}

		case fflib.FFParse_want_key:
			// json {} ended. goto exit. woo.
			if tok == fflib.FFTok_right_bracket {
				goto done
			}
			if tok != fflib.FFTok_string {
				wantedTok = fflib.FFTok_string
				goto wrongtokenerror
			}

			kn := fs.Output.Bytes()
			if len(kn) <= 0 {
				// "" case. hrm.
				currentKey = ffj_t_CSIPluginContainerInfono_such_key
				state = fflib.FFParse_want_colon
				goto mainparse
			} else {
				switch kn[0] {

				case 'c':

					if bytes.Equal(ffj_key_CSIPluginContainerInfo_Command, kn) {
						currentKey = ffj_t_CSIPluginContainerInfo_Command
						state = fflib.FFParse_want_colon
						goto mainparse

					} else if bytes.Equal(ffj_key_CSIPluginContainerInfo_Container, kn) {
						currentKey = ffj_t_CSIPluginContainerInfo_Container
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				case 'r':

					if bytes.Equal(ffj_key_CSIPluginContainerInfo_Resources, kn) {
						currentKey = ffj_t_CSIPluginContainerInfo_Resources
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				case 's':

					if bytes.Equal(ffj_key_CSIPluginContainerInfo_Services, kn) {
						currentKey = ffj_t_CSIPluginContainerInfo_Services
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				}

				if fflib.SimpleLetterEqualFold(ffj_key_CSIPluginContainerInfo_Container, kn) {
					currentKey = ffj_t_CSIPluginContainerInfo_Container
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffj_key_CSIPluginContainerInfo_Resources, kn) {
					currentKey = ffj_t_CSIPluginContainerInfo_Resources
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.SimpleLetterEqualFold(ffj_key_CSIPluginContainerInfo_Command, kn) {
					currentKey = ffj_t_CSIPluginContainerInfo_Command
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffj_key_CSIPluginContainerInfo_Services, kn) {
					currentKey = ffj_t_CSIPluginContainerInfo_Services
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				currentKey = ffj_t_CSIPluginContainerInfono_such_key
				state = fflib.FFParse_want_colon
				goto mainparse
			}

		case fflib.FFParse_want_colon:
			if tok != fflib.FFTok_colon {
				wantedTok = fflib.FFTok_colon
				goto wrongtokenerror
			}
			state = fflib.FFParse_want_value
			continue
		case fflib.FFParse_want_value:

			if tok == fflib.FFTok_left_brace || tok == fflib.FFTok_left_bracket || tok == fflib.FFTok_integer || tok == fflib.FFTok_double || tok == fflib.FFTok_string || tok == fflib.FFTok_bool || tok == fflib.FFTok_null {
				switch currentKey {

				case ffj_t_CSIPluginContainerInfo_Services:
					goto handle_Services

				case ffj_t_CSIPluginContainerInfo_Command:
					goto handle_Command

				case ffj_t_CSIPluginContainerInfo_Resources:
					goto handle_Resources

				case ffj_t_CSIPluginContainerInfo_Container:
					goto handle_Container

				case ffj_t_CSIPluginContainerInfono_such_key:
					err = fs.SkipField(tok)
					if err != nil {
						return fs.WrapErr(err)
					}
					state = fflib.FFParse_after_value
					goto mainparse
				}
			} else {
				goto wantedvalue
			}
		}
	}

handle_Services:

	/* handler: uj.Services type=[]mesos.CSIPluginContainerInfo_Service kind=slice quoted=false*/

	{

		{
			if tok != fflib.FFTok_left_brace && tok != fflib.FFTok_null {
				return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for ", tok))
			}
		}

		if tok == fflib.FFTok_null {
			uj.Services = nil
		} else {

			uj.Services = []CSIPluginContainerInfo_Service{}

			wantVal := true

			for {

				var tmp_uj__Services CSIPluginContainerInfo_Service

				tok = fs.Scan()
				if tok == fflib.FFTok_error {
					goto tokerror
				}
				if tok == fflib.FFTok_right_brace {
					break
				}

				if tok == fflib.FFTok_comma {
					if wantVal == true {
						// TODO(pquerna): this isn't an ideal error message, this handles
						// things like [,,,] as an array value.
						return fs.WrapErr(fmt.Errorf("wanted value token, but got token: %v", tok))
					}
					continue
				} else {
					wantVal = true
				}

				/* handler: tmp_uj__Services type=mesos.CSIPluginContainerInfo_Service kind=int32 quoted=false*/

				{
					if tok == fflib.FFTok_null {

						state = fflib.FFParse_after_value
						goto mainparse
					}

					tbuf, err := fs.CaptureField(tok)
					if err != nil {
						return fs.WrapErr(err)
					}

					err = tmp_uj__Services.UnmarshalJSON(tbuf)
					if err != nil {
						return fs.WrapErr(err)
					}
					state = fflib.FFParse_after_value
				}

				uj.Services = append(uj.Services, tmp_uj__Services)

				wantVal = false
			}
		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_Command:

	/* handler: uj.Command type=mesos.CommandInfo kind=struct quoted=false*/

	{
		if tok == fflib.FFTok_null {

			uj.Command = nil

			state = fflib.FFParse_after_value
			goto mainparse
		}

		if uj.Command == nil {
			uj.Command = new(CommandInfo)
		}

		err = uj.Command.UnmarshalJSONFFLexer(fs, fflib.FFParse_want_key)
		if err != nil {
			return err
		}
		state = fflib.FFParse_after_value
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_Resources:

	/* handler: uj.Resources type=[]mesos.Resource kind=slice quoted=false*/

	{

		{
			if tok != fflib.FFTok_left_brace && tok != fflib.FFTok_null {
				return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for ", tok))
			}
		}

		if tok == fflib.FFTok_null {
			uj.Resources = nil
		} else {

			uj.Resources = []Resource{}

			wantVal := true

			for {

				var tmp_uj__Resources Resource

				tok = fs.Scan()
				if tok == fflib.FFTok_error {
					goto tokerror
				}
				if tok == fflib.FFTok_right_brace {
					break
				}

				if tok == fflib.FFTok_comma {
					if wantVal == true {
						// TODO(pquerna): this isn't an ideal error message, this handles
						// things like [,,,] as an array value.
						return fs.WrapErr(fmt.Errorf("wanted value token, but got token: %v", tok))
					}
					continue
				} else {
					wantVal = true
				}

				/* handler: tmp_uj__Resources type=mesos.Resource kind=struct quoted=false*/

				{
					if tok == fflib.FFTok_null {

						state = fflib.FFParse_after_value
						goto mainparse
					}

					err = tmp_uj__Resources.UnmarshalJSONFFLexer(fs, fflib.FFParse_want_key)
					if err != nil {
						return err
					}
					state = fflib.FFParse_after_value
				}

				uj.Resources = append(uj.Resources, tmp_uj__Resources)

				wantVal = false
			}
		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_Container:

	/* handler: uj.Container type=mesos.ContainerInfo kind=struct quoted=false*/

	{
		if tok == fflib.FFTok_null {

			uj.Container = nil

			state = fflib.FFParse_after_value
			goto mainparse
		}

		if uj.Container == nil {
			uj.Container = new(ContainerInfo)
		}

		err = uj.Container.UnmarshalJSONFFLexer(fs, fflib.FFParse_want_key)
		if err != nil {
			return err
		}
		state = fflib.FFParse_after_value
	}

	state = fflib.FFParse_after_value
	goto mainparse

wantedvalue:
	return fs.WrapErr(fmt.Errorf("wanted value token, but got token: %v", tok))
wrongtokenerror:
	return fs.WrapErr(fmt.Errorf("ffjson: wanted token: %v, but got token: %v output=%s", wantedTok, tok, fs.Output.String()))
tokerror:
	if fs.BigError != nil {
		return fs.WrapErr(fs.BigError)
	}
	err = fs.Error.ToError()
	if err != nil {
		return fs.WrapErr(err)
	}
	panic("ffjson-generated: unreachable, please report bug.")
done:

	return nil
}

func (mj *CSIPluginInfo) MarshalJSON() ([]byte, error) {
	var buf fflib.Buffer
	if mj == nil {
		buf.WriteString("null")
		return buf.Bytes(), nil
	}
	err := mj.MarshalJSONBuf(&buf)
	if err != nil {
		return nil, err
	}
	return buf.Bytes(), nil
}
func (mj *CSIPluginInfo) MarshalJSONBuf(buf fflib.EncodingBuffer) error {
	if mj == nil {
		buf.WriteString("null")
		return nil
	}
	var err error
	var obj []byte
	_ = obj
	_ = err
	buf.WriteString(`{"type":`)
	fflib.WriteJsonString(buf, string(mj.Type))
	buf.WriteString(`,"name":`)
	fflib.WriteJsonString(buf, string(mj.Name))
	buf.WriteString(`,"containers":`)
	if mj.Containers != nil {
		buf.WriteString(`[`)
		for i, v := range mj.Containers {
			if i != 0 {
				buf.WriteString(`,`)
			}

			{

				err = v.MarshalJSONBuf(buf)
				if err != nil {
					return err
				}

			}
		}
		buf.WriteString(`]`)
	} else {
		buf.WriteString(`null`)
	}
	buf.WriteByte('}')
	return nil
}

const (
	ffj_t_CSIPluginInfobase = iota
	ffj_t_CSIPluginInfono_such_key

	ffj_t_CSIPluginInfo_Type

	ffj_t_CSIPluginInfo_Name

	ffj_t_CSIPluginInfo_Containers
)

var ffj_key_CSIPluginInfo_Type = []byte("type")

var ffj_key_CSIPluginInfo_Name = []byte("name")

var ffj_key_CSIPluginInfo_Containers = []byte("containers")

func (uj *CSIPluginInfo) UnmarshalJSON(input []byte) error {
	fs := fflib.NewFFLexer(input)
	return uj.UnmarshalJSONFFLexer(fs, fflib.FFParse_map_start)
}

func (uj *CSIPluginInfo) UnmarshalJSONFFLexer(fs *fflib.FFLexer, state fflib.FFParseState) error {
	var err error = nil
	currentKey := ffj_t_CSIPluginInfobase
	_ = currentKey
	tok := fflib.FFTok_init
	wantedTok := fflib.FFTok_init

mainparse:
	for {
		tok = fs.Scan()
		//	println(fmt.Sprintf("debug: tok: %v  state: %v", tok, state))
		if tok == fflib.FFTok_error {
			goto tokerror
		}

		switch state {

		case fflib.FFParse_map_start:
			if tok != fflib.FFTok_left_bracket {
				wantedTok = fflib.FFTok_left_bracket
				goto wrongtokenerror
			}
			state = fflib.FFParse_want_key
			continue

		case fflib.FFParse_after_value:
			if tok == fflib.FFTok_comma {
				state = fflib.FFParse_want_key
			} else if tok == fflib.FFTok_right_bracket {
				goto done
			} else {
				wantedTok = fflib.FFTok_comma
				goto wrongtokenerror
			}

		case fflib.FFParse_want_key:
			// json {} ended. goto exit. woo.
			if tok == fflib.FFTok_right_bracket {
				goto done
			}
			if tok != fflib.FFTok_string {
				wantedTok = fflib.FFTok_string
				goto wrongtokenerror
			}

			kn := fs.Output.Bytes()
			if len(kn) <= 0 {
				// "" case. hrm.
				currentKey = ffj_t_CSIPluginInfono_such_key
				state = fflib.FFParse_want_colon
				goto mainparse
			} else {
				switch kn[0] {

				case 'c':

					if bytes.Equal(ffj_key_CSIPluginInfo_Containers, kn) {
						currentKey = ffj_t_CSIPluginInfo_Containers
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				case 'n':

					if bytes.Equal(ffj_key_CSIPluginInfo_Name, kn) {
						currentKey = ffj_t_CSIPluginInfo_Name
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				case 't':

					if bytes.Equal(ffj_key_CSIPluginInfo_Type, kn) {
						currentKey = ffj_t_CSIPluginInfo_Type
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				}

				if fflib.EqualFoldRight(ffj_key_CSIPluginInfo_Containers, kn) {
					currentKey = ffj_t_CSIPluginInfo_Containers
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.SimpleLetterEqualFold(ffj_key_CSIPluginInfo_Name, kn) {
					currentKey = ffj_t_CSIPluginInfo_Name
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.SimpleLetterEqualFold(ffj_key_CSIPluginInfo_Type, kn) {
					currentKey = ffj_t_CSIPluginInfo_Type
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				currentKey = ffj_t_CSIPluginInfono_such_key
				state = fflib.FFParse_want_colon
				goto mainparse
			}

		case fflib.FFParse_want_colon:
			if tok != fflib.FFTok_colon {
				wantedTok = fflib.FFTok_colon
				goto wrongtokenerror
			}
			state = fflib.FFParse_want_value
			continue
		case fflib.FFParse_want_value:

			if tok == fflib.FFTok_left_brace || tok == fflib.FFTok_left_bracket || tok == fflib.FFTok_integer || tok == fflib.FFTok_double || tok == fflib.FFTok_string || tok == fflib.FFTok_bool || tok == fflib.FFTok_null {
				switch currentKey {

				case ffj_t_CSIPluginInfo_Type:
					goto handle_Type

				case ffj_t_CSIPluginInfo_Name:
					goto handle_Name

				case ffj_t_CSIPluginInfo_Containers:
					goto handle_Containers

				case ffj_t_CSIPluginInfono_such_key:
					err = fs.SkipField(tok)
					if err != nil {
						return fs.WrapErr(err)
					}
					state = fflib.FFParse_after_value
					goto mainparse
				}
			} else {
				goto wantedvalue
			}
		}
	}

handle_Type:

	/* handler: uj.Type type=string kind=string quoted=false*/

	{

		{
			if tok != fflib.FFTok_string && tok != fflib.FFTok_null {
				return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for string", tok))
			}
		}

		if tok == fflib.FFTok_null {

		} else {

			outBuf := fs.Output.Bytes()

			uj.Type = string(string(outBuf))

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_Name:

	/* handler: uj.Name type=string kind=string quoted=false*/

	{

		{
			if tok != fflib.FFTok_string && tok != fflib.FFTok_null {
				return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for string", tok))
			}
		}

		if tok == fflib.FFTok_null {

		} else {

			outBuf := fs.Output.Bytes()

			uj.Name = string(string(outBuf))

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_Containers:

	/* handler: uj.Containers type=[]mesos.CSIPluginContainerInfo kind=slice quoted=false*/

	{

		{
			if tok != fflib.FFTok_left_brace && tok != fflib.FFTok_null {
				return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for ", tok))
			}
		}

		if tok == fflib.FFTok_null {
			uj.Containers = nil
		} else {

			uj.Containers = []CSIPluginContainerInfo{}

			wantVal := true

			for {

				var tmp_uj__Containers CSIPluginContainerInfo

				tok = fs.Scan()
				if tok == fflib.FFTok_error {
					goto tokerror
				}
				if tok == fflib.FFTok_right_brace {
					break
				}

				if tok == fflib.FFTok_comma {
					if wantVal == true {
						// TODO(pquerna): this isn't an ideal error message, this handles
						// things like [,,,] as an array value.
						return fs.WrapErr(fmt.Errorf("wanted value token, but got token: %v", tok))
					}
					continue
				} else {
					wantVal = true
				}

				/* handler: tmp_uj__Containers type=mesos.CSIPluginContainerInfo kind=struct quoted=false*/

				{
					if tok == fflib.FFTok_null {

						state = fflib.FFParse_after_value
						goto mainparse
					}

					err = tmp_uj__Containers.UnmarshalJSONFFLexer(fs, fflib.FFParse_want_key)
					if err != nil {
						return err
					}
					state = fflib.FFParse_after_value
				}

				uj.Containers = append(uj.Containers, tmp_uj__Containers)

				wantVal = false
			}
		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

wantedvalue:
	return fs.WrapErr(fmt.Errorf("wanted value token, but got token: %v", tok))
wrongtokenerror:
	return fs.WrapErr(fmt.Errorf("ffjson: wanted token: %v, but got token: %v output=%s", wantedTok, tok, fs.Output.String()))
tokerror:
	if fs.BigError != nil {
		return fs.WrapErr(fs.BigError)
	}
	err = fs.Error.ToError()
	if err != nil {
		return fs.WrapErr(err)
	}
	panic("ffjson-generated: unreachable, please report bug.")
done:

	return nil
}

func (mj *CapabilityInfo) MarshalJSON() ([]byte, error) {
	var buf fflib.Buffer
	if mj == nil {
		buf.WriteString("null")
		return buf.Bytes(), nil
	}
	err := mj.MarshalJSONBuf(&buf)
	if err != nil {
		return nil, err
	}
	return buf.Bytes(), nil
}
func (mj *CapabilityInfo) MarshalJSONBuf(buf fflib.EncodingBuffer) error {
	if mj == nil {
		buf.WriteString("null")
		return nil
	}
	var err error
	var obj []byte
	_ = obj
	_ = err
	buf.WriteString(`{ `)
	if len(mj.Capabilities) != 0 {
		buf.WriteString(`"capabilities":`)
		if mj.Capabilities != nil {
			buf.WriteString(`[`)
			for i, v := range mj.Capabilities {
				if i != 0 {
					buf.WriteString(`,`)
				}

				{

					obj, err = v.MarshalJSON()
					if err != nil {
						return err
					}
					buf.Write(obj)

				}
			}
			buf.WriteString(`]`)
		} else {
			buf.WriteString(`null`)
		}
		buf.WriteByte(',')
	}
	buf.Rewind(1)
	buf.WriteByte('}')
	return nil
}

const (
	ffj_t_CapabilityInfobase = iota
	ffj_t_CapabilityInfono_such_key

	ffj_t_CapabilityInfo_Capabilities
)

var ffj_key_CapabilityInfo_Capabilities = []byte("capabilities")

func (uj *CapabilityInfo) UnmarshalJSON(input []byte) error {
	fs := fflib.NewFFLexer(input)
	return uj.UnmarshalJSONFFLexer(fs, fflib.FFParse_map_start)
}

func (uj *CapabilityInfo) UnmarshalJSONFFLexer(fs *fflib.FFLexer, state fflib.FFParseState) error {
	var err error = nil
	currentKey := ffj_t_CapabilityInfobase
	_ = currentKey
	tok := fflib.FFTok_init
	wantedTok := fflib.FFTok_init

mainparse:
	for {
		tok = fs.Scan()
		//	println(fmt.Sprintf("debug: tok: %v  state: %v", tok, state))
		if tok == fflib.FFTok_error {
			goto tokerror
		}

		switch state {

		case fflib.FFParse_map_start:
			if tok != fflib.FFTok_left_bracket {
				wantedTok = fflib.FFTok_left_bracket
				goto wrongtokenerror
			}
			state = fflib.FFParse_want_key
			continue

		case fflib.FFParse_after_value:
			if tok == fflib.FFTok_comma {
				state = fflib.FFParse_want_key
			} else if tok == fflib.FFTok_right_bracket {
				goto done
			} else {
				wantedTok = fflib.FFTok_comma
				goto wrongtokenerror
			}

		case fflib.FFParse_want_key:
			// json {} ended. goto exit. woo.
			if tok == fflib.FFTok_right_bracket {
				goto done
			}
			if tok != fflib.FFTok_string {
				wantedTok = fflib.FFTok_string
				goto wrongtokenerror
			}

			kn := fs.Output.Bytes()
			if len(kn) <= 0 {
				// "" case. hrm.
				currentKey = ffj_t_CapabilityInfono_such_key
				state = fflib.FFParse_want_colon
				goto mainparse
			} else {
				switch kn[0] {

				case 'c':

					if bytes.Equal(ffj_key_CapabilityInfo_Capabilities, kn) {
						currentKey = ffj_t_CapabilityInfo_Capabilities
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				}

				if fflib.EqualFoldRight(ffj_key_CapabilityInfo_Capabilities, kn) {
					currentKey = ffj_t_CapabilityInfo_Capabilities
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				currentKey = ffj_t_CapabilityInfono_such_key
				state = fflib.FFParse_want_colon
				goto mainparse
			}

		case fflib.FFParse_want_colon:
			if tok != fflib.FFTok_colon {
				wantedTok = fflib.FFTok_colon
				goto wrongtokenerror
			}
			state = fflib.FFParse_want_value
			continue
		case fflib.FFParse_want_value:

			if tok == fflib.FFTok_left_brace || tok == fflib.FFTok_left_bracket || tok == fflib.FFTok_integer || tok == fflib.FFTok_double || tok == fflib.FFTok_string || tok == fflib.FFTok_bool || tok == fflib.FFTok_null {
				switch currentKey {

				case ffj_t_CapabilityInfo_Capabilities:
					goto handle_Capabilities

				case ffj_t_CapabilityInfono_such_key:
					err = fs.SkipField(tok)
					if err != nil {
						return fs.WrapErr(err)
					}
					state = fflib.FFParse_after_value
					goto mainparse
				}
			} else {
				goto wantedvalue
			}
		}
	}

handle_Capabilities:

	/* handler: uj.Capabilities type=[]mesos.CapabilityInfo_Capability kind=slice quoted=false*/

	{

		{
			if tok != fflib.FFTok_left_brace && tok != fflib.FFTok_null {
				return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for ", tok))
			}
		}

		if tok == fflib.FFTok_null {
			uj.Capabilities = nil
		} else {

			uj.Capabilities = []CapabilityInfo_Capability{}

			wantVal := true

			for {

				var tmp_uj__Capabilities CapabilityInfo_Capability

				tok = fs.Scan()
				if tok == fflib.FFTok_error {
					goto tokerror
				}
				if tok == fflib.FFTok_right_brace {
					break
				}

				if tok == fflib.FFTok_comma {
					if wantVal == true {
						// TODO(pquerna): this isn't an ideal error message, this handles
						// things like [,,,] as an array value.
						return fs.WrapErr(fmt.Errorf("wanted value token, but got token: %v", tok))
					}
					continue
				} else {
					wantVal = true
				}

				/* handler: tmp_uj__Capabilities type=mesos.CapabilityInfo_Capability kind=int32 quoted=false*/

				{
					if tok == fflib.FFTok_null {

						state = fflib.FFParse_after_value
						goto mainparse
					}

					tbuf, err := fs.CaptureField(tok)
					if err != nil {
						return fs.WrapErr(err)
					}

					err = tmp_uj__Capabilities.UnmarshalJSON(tbuf)
					if err != nil {
						return fs.WrapErr(err)
					}
					state = fflib.FFParse_after_value
				}

				uj.Capabilities = append(uj.Capabilities, tmp_uj__Capabilities)

				wantVal = false
			}
		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

wantedvalue:
	return fs.WrapErr(fmt.Errorf("wanted value token, but got token: %v", tok))
wrongtokenerror:
	return fs.WrapErr(fmt.Errorf("ffjson: wanted token: %v, but got token: %v output=%s", wantedTok, tok, fs.Output.String()))
tokerror:
	if fs.BigError != nil {
		return fs.WrapErr(fs.BigError)
	}
	err = fs.Error.ToError()
	if err != nil {
		return fs.WrapErr(err)
	}
	panic("ffjson-generated: unreachable, please report bug.")
done:

	return nil
}

func (mj *CgroupInfo) MarshalJSON() ([]byte, error) {
	var buf fflib.Buffer
	if mj == nil {
		buf.WriteString("null")
		return buf.Bytes(), nil
	}
	err := mj.MarshalJSONBuf(&buf)
	if err != nil {
		return nil, err
	}
	return buf.Bytes(), nil
}
func (mj *CgroupInfo) MarshalJSONBuf(buf fflib.EncodingBuffer) error {
	if mj == nil {
		buf.WriteString("null")
		return nil
	}
	var err error
	var obj []byte
	_ = obj
	_ = err
	buf.WriteString(`{ `)
	if mj.NetCLS != nil {
		if true {
			buf.WriteString(`"net_cls":`)

			{

				err = mj.NetCLS.MarshalJSONBuf(buf)
				if err != nil {
					return err
				}

			}
			buf.WriteByte(',')
		}
	}
	buf.Rewind(1)
	buf.WriteByte('}')
	return nil
}

const (
	ffj_t_CgroupInfobase = iota
	ffj_t_CgroupInfono_such_key

	ffj_t_CgroupInfo_NetCLS
)

var ffj_key_CgroupInfo_NetCLS = []byte("net_cls")

func (uj *CgroupInfo) UnmarshalJSON(input []byte) error {
	fs := fflib.NewFFLexer(input)
	return uj.UnmarshalJSONFFLexer(fs, fflib.FFParse_map_start)
}

func (uj *CgroupInfo) UnmarshalJSONFFLexer(fs *fflib.FFLexer, state fflib.FFParseState) error {
	var err error = nil
	currentKey := ffj_t_CgroupInfobase
	_ = currentKey
	tok := fflib.FFTok_init
	wantedTok := fflib.FFTok_init

mainparse:
	for {
		tok = fs.Scan()
		//	println(fmt.Sprintf("debug: tok: %v  state: %v", tok, state))
		if tok == fflib.FFTok_error {
			goto tokerror
		}

		switch state {

		case fflib.FFParse_map_start:
			if tok != fflib.FFTok_left_bracket {
				wantedTok = fflib.FFTok_left_bracket
				goto wrongtokenerror
			}
			state = fflib.FFParse_want_key
			continue

		case fflib.FFParse_after_value:
			if tok == fflib.FFTok_comma {
				state = fflib.FFParse_want_key
			} else if tok == fflib.FFTok_right_bracket {
				goto done
			} else {
				wantedTok = fflib.FFTok_comma
				goto wrongtokenerror
			}

		case fflib.FFParse_want_key:
			// json {} ended. goto exit. woo.
			if tok == fflib.FFTok_right_bracket {
				goto done
			}
			if tok != fflib.FFTok_string {
				wantedTok = fflib.FFTok_string
				goto wrongtokenerror
			}

			kn := fs.Output.Bytes()
			if len(kn) <= 0 {
				// "" case. hrm.
				currentKey = ffj_t_CgroupInfono_such_key
				state = fflib.FFParse_want_colon
				goto mainparse
			} else {
				switch kn[0] {

				case 'n':

					if bytes.Equal(ffj_key_CgroupInfo_NetCLS, kn) {
						currentKey = ffj_t_CgroupInfo_NetCLS
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				}

				if fflib.EqualFoldRight(ffj_key_CgroupInfo_NetCLS, kn) {
					currentKey = ffj_t_CgroupInfo_NetCLS
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				currentKey = ffj_t_CgroupInfono_such_key
				state = fflib.FFParse_want_colon
				goto mainparse
			}

		case fflib.FFParse_want_colon:
			if tok != fflib.FFTok_colon {
				wantedTok = fflib.FFTok_colon
				goto wrongtokenerror
			}
			state = fflib.FFParse_want_value
			continue
		case fflib.FFParse_want_value:

			if tok == fflib.FFTok_left_brace || tok == fflib.FFTok_left_bracket || tok == fflib.FFTok_integer || tok == fflib.FFTok_double || tok == fflib.FFTok_string || tok == fflib.FFTok_bool || tok == fflib.FFTok_null {
				switch currentKey {

				case ffj_t_CgroupInfo_NetCLS:
					goto handle_NetCLS

				case ffj_t_CgroupInfono_such_key:
					err = fs.SkipField(tok)
					if err != nil {
						return fs.WrapErr(err)
					}
					state = fflib.FFParse_after_value
					goto mainparse
				}
			} else {
				goto wantedvalue
			}
		}
	}

handle_NetCLS:

	/* handler: uj.NetCLS type=mesos.CgroupInfo_NetCls kind=struct quoted=false*/

	{
		if tok == fflib.FFTok_null {

			uj.NetCLS = nil

			state = fflib.FFParse_after_value
			goto mainparse
		}

		if uj.NetCLS == nil {
			uj.NetCLS = new(CgroupInfo_NetCls)
		}

		err = uj.NetCLS.UnmarshalJSONFFLexer(fs, fflib.FFParse_want_key)
		if err != nil {
			return err
		}
		state = fflib.FFParse_after_value
	}

	state = fflib.FFParse_after_value
	goto mainparse

wantedvalue:
	return fs.WrapErr(fmt.Errorf("wanted value token, but got token: %v", tok))
wrongtokenerror:
	return fs.WrapErr(fmt.Errorf("ffjson: wanted token: %v, but got token: %v output=%s", wantedTok, tok, fs.Output.String()))
tokerror:
	if fs.BigError != nil {
		return fs.WrapErr(fs.BigError)
	}
	err = fs.Error.ToError()
	if err != nil {
		return fs.WrapErr(err)
	}
	panic("ffjson-generated: unreachable, please report bug.")
done:

	return nil
}

func (mj *CgroupInfo_Blkio) MarshalJSON() ([]byte, error) {
	var buf fflib.Buffer
	if mj == nil {
		buf.WriteString("null")
		return buf.Bytes(), nil
	}
	err := mj.MarshalJSONBuf(&buf)
	if err != nil {
		return nil, err
	}
	return buf.Bytes(), nil
}
func (mj *CgroupInfo_Blkio) MarshalJSONBuf(buf fflib.EncodingBuffer) error {
	if mj == nil {
		buf.WriteString("null")
		return nil
	}
	var err error
	var obj []byte
	_ = obj
	_ = err
	buf.WriteString(`{}`)
	return nil
}

const (
	ffj_t_CgroupInfo_Blkiobase = iota
	ffj_t_CgroupInfo_Blkiono_such_key
)

func (uj *CgroupInfo_Blkio) UnmarshalJSON(input []byte) error {
	fs := fflib.NewFFLexer(input)
	return uj.UnmarshalJSONFFLexer(fs, fflib.FFParse_map_start)
}

func (uj *CgroupInfo_Blkio) UnmarshalJSONFFLexer(fs *fflib.FFLexer, state fflib.FFParseState) error {
	var err error = nil
	currentKey := ffj_t_CgroupInfo_Blkiobase
	_ = currentKey
	tok := fflib.FFTok_init
	wantedTok := fflib.FFTok_init

mainparse:
	for {
		tok = fs.Scan()
		//	println(fmt.Sprintf("debug: tok: %v  state: %v", tok, state))
		if tok == fflib.FFTok_error {
			goto tokerror
		}

		switch state {

		case fflib.FFParse_map_start:
			if tok != fflib.FFTok_left_bracket {
				wantedTok = fflib.FFTok_left_bracket
				goto wrongtokenerror
			}
			state = fflib.FFParse_want_key
			continue

		case fflib.FFParse_after_value:
			if tok == fflib.FFTok_comma {
				state = fflib.FFParse_want_key
			} else if tok == fflib.FFTok_right_bracket {
				goto done
			} else {
				wantedTok = fflib.FFTok_comma
				goto wrongtokenerror
			}

		case fflib.FFParse_want_key:
			// json {} ended. goto exit. woo.
			if tok == fflib.FFTok_right_bracket {
				goto done
			}
			if tok != fflib.FFTok_string {
				wantedTok = fflib.FFTok_string
				goto wrongtokenerror
			}

			kn := fs.Output.Bytes()
			if len(kn) <= 0 {
				// "" case. hrm.
				currentKey = ffj_t_CgroupInfo_Blkiono_such_key
				state = fflib.FFParse_want_colon
				goto mainparse
			} else {
				switch kn[0] {

				}

				currentKey = ffj_t_CgroupInfo_Blkiono_such_key
				state = fflib.FFParse_want_colon
				goto mainparse
			}

		case fflib.FFParse_want_colon:
			if tok != fflib.FFTok_colon {
				wantedTok = fflib.FFTok_colon
				goto wrongtokenerror
			}
			state = fflib.FFParse_want_value
			continue
		case fflib.FFParse_want_value:

			if tok == fflib.FFTok_left_brace || tok == fflib.FFTok_left_bracket || tok == fflib.FFTok_integer || tok == fflib.FFTok_double || tok == fflib.FFTok_string || tok == fflib.FFTok_bool || tok == fflib.FFTok_null {
				switch currentKey {

				case ffj_t_CgroupInfo_Blkiono_such_key:
					err = fs.SkipField(tok)
					if err != nil {
						return fs.WrapErr(err)
					}
					state = fflib.FFParse_after_value
					goto mainparse
				}
			} else {
				goto wantedvalue
			}
		}
	}

wantedvalue:
	return fs.WrapErr(fmt.Errorf("wanted value token, but got token: %v", tok))
wrongtokenerror:
	return fs.WrapErr(fmt.Errorf("ffjson: wanted token: %v, but got token: %v output=%s", wantedTok, tok, fs.Output.String()))
tokerror:
	if fs.BigError != nil {
		return fs.WrapErr(fs.BigError)
	}
	err = fs.Error.ToError()
	if err != nil {
		return fs.WrapErr(err)
	}
	panic("ffjson-generated: unreachable, please report bug.")
done:

	return nil
}

func (mj *CgroupInfo_Blkio_CFQ) MarshalJSON() ([]byte, error) {
	var buf fflib.Buffer
	if mj == nil {
		buf.WriteString("null")
		return buf.Bytes(), nil
	}
	err := mj.MarshalJSONBuf(&buf)
	if err != nil {
		return nil, err
	}
	return buf.Bytes(), nil
}
func (mj *CgroupInfo_Blkio_CFQ) MarshalJSONBuf(buf fflib.EncodingBuffer) error {
	if mj == nil {
		buf.WriteString("null")
		return nil
	}
	var err error
	var obj []byte
	_ = obj
	_ = err
	buf.WriteString(`{}`)
	return nil
}

const (
	ffj_t_CgroupInfo_Blkio_CFQbase = iota
	ffj_t_CgroupInfo_Blkio_CFQno_such_key
)

func (uj *CgroupInfo_Blkio_CFQ) UnmarshalJSON(input []byte) error {
	fs := fflib.NewFFLexer(input)
	return uj.UnmarshalJSONFFLexer(fs, fflib.FFParse_map_start)
}

func (uj *CgroupInfo_Blkio_CFQ) UnmarshalJSONFFLexer(fs *fflib.FFLexer, state fflib.FFParseState) error {
	var err error = nil
	currentKey := ffj_t_CgroupInfo_Blkio_CFQbase
	_ = currentKey
	tok := fflib.FFTok_init
	wantedTok := fflib.FFTok_init

mainparse:
	for {
		tok = fs.Scan()
		//	println(fmt.Sprintf("debug: tok: %v  state: %v", tok, state))
		if tok == fflib.FFTok_error {
			goto tokerror
		}

		switch state {

		case fflib.FFParse_map_start:
			if tok != fflib.FFTok_left_bracket {
				wantedTok = fflib.FFTok_left_bracket
				goto wrongtokenerror
			}
			state = fflib.FFParse_want_key
			continue

		case fflib.FFParse_after_value:
			if tok == fflib.FFTok_comma {
				state = fflib.FFParse_want_key
			} else if tok == fflib.FFTok_right_bracket {
				goto done
			} else {
				wantedTok = fflib.FFTok_comma
				goto wrongtokenerror
			}

		case fflib.FFParse_want_key:
			// json {} ended. goto exit. woo.
			if tok == fflib.FFTok_right_bracket {
				goto done
			}
			if tok != fflib.FFTok_string {
				wantedTok = fflib.FFTok_string
				goto wrongtokenerror
			}

			kn := fs.Output.Bytes()
			if len(kn) <= 0 {
				// "" case. hrm.
				currentKey = ffj_t_CgroupInfo_Blkio_CFQno_such_key
				state = fflib.FFParse_want_colon
				goto mainparse
			} else {
				switch kn[0] {

				}

				currentKey = ffj_t_CgroupInfo_Blkio_CFQno_such_key
				state = fflib.FFParse_want_colon
				goto mainparse
			}

		case fflib.FFParse_want_colon:
			if tok != fflib.FFTok_colon {
				wantedTok = fflib.FFTok_colon
				goto wrongtokenerror
			}
			state = fflib.FFParse_want_value
			continue
		case fflib.FFParse_want_value:

			if tok == fflib.FFTok_left_brace || tok == fflib.FFTok_left_bracket || tok == fflib.FFTok_integer || tok == fflib.FFTok_double || tok == fflib.FFTok_string || tok == fflib.FFTok_bool || tok == fflib.FFTok_null {
				switch currentKey {

				case ffj_t_CgroupInfo_Blkio_CFQno_such_key:
					err = fs.SkipField(tok)
					if err != nil {
						return fs.WrapErr(err)
					}
					state = fflib.FFParse_after_value
					goto mainparse
				}
			} else {
				goto wantedvalue
			}
		}
	}

wantedvalue:
	return fs.WrapErr(fmt.Errorf("wanted value token, but got token: %v", tok))
wrongtokenerror:
	return fs.WrapErr(fmt.Errorf("ffjson: wanted token: %v, but got token: %v output=%s", wantedTok, tok, fs.Output.String()))
tokerror:
	if fs.BigError != nil {
		return fs.WrapErr(fs.BigError)
	}
	err = fs.Error.ToError()
	if err != nil {
		return fs.WrapErr(err)
	}
	panic("ffjson-generated: unreachable, please report bug.")
done:

	return nil
}

func (mj *CgroupInfo_Blkio_CFQ_Statistics) MarshalJSON() ([]byte, error) {
	var buf fflib.Buffer
	if mj == nil {
		buf.WriteString("null")
		return buf.Bytes(), nil
	}
	err := mj.MarshalJSONBuf(&buf)
	if err != nil {
		return nil, err
	}
	return buf.Bytes(), nil
}
func (mj *CgroupInfo_Blkio_CFQ_Statistics) MarshalJSONBuf(buf fflib.EncodingBuffer) error {
	if mj == nil {
		buf.WriteString("null")
		return nil
	}
	var err error
	var obj []byte
	_ = obj
	_ = err
	buf.WriteByte('{')
	if mj.Device != nil {
		if true {
			buf.WriteString(`"device":`)

			{

				err = mj.Device.MarshalJSONBuf(buf)
				if err != nil {
					return err
				}

			}
			buf.WriteByte(',')
		}
	}
	if mj.Sectors != nil {
		if true {
			buf.WriteString(`"sectors":`)
			fflib.FormatBits2(buf, uint64(*mj.Sectors), 10, false)
			buf.WriteByte(',')
		}
	}
	if mj.Time != nil {
		if true {
			buf.WriteString(`"time":`)
			fflib.FormatBits2(buf, uint64(*mj.Time), 10, false)
			buf.WriteByte(',')
		}
	}
	buf.WriteString(`"io_serviced":`)
	if mj.IOServiced != nil {
		buf.WriteString(`[`)
		for i, v := range mj.IOServiced {
			if i != 0 {
				buf.WriteString(`,`)
			}

			{

				err = v.MarshalJSONBuf(buf)
				if err != nil {
					return err
				}

			}
		}
		buf.WriteString(`]`)
	} else {
		buf.WriteString(`null`)
	}
	buf.WriteString(`,"io_service_bytes":`)
	if mj.IOServiceBytes != nil {
		buf.WriteString(`[`)
		for i, v := range mj.IOServiceBytes {
			if i != 0 {
				buf.WriteString(`,`)
			}

			{

				err = v.MarshalJSONBuf(buf)
				if err != nil {
					return err
				}

			}
		}
		buf.WriteString(`]`)
	} else {
		buf.WriteString(`null`)
	}
	buf.WriteString(`,"io_service_time":`)
	if mj.IOServiceTime != nil {
		buf.WriteString(`[`)
		for i, v := range mj.IOServiceTime {
			if i != 0 {
				buf.WriteString(`,`)
			}

			{

				err = v.MarshalJSONBuf(buf)
				if err != nil {
					return err
				}

			}
		}
		buf.WriteString(`]`)
	} else {
		buf.WriteString(`null`)
	}
	buf.WriteString(`,"io_wait_time":`)
	if mj.IOWaitTime != nil {
		buf.WriteString(`[`)
		for i, v := range mj.IOWaitTime {
			if i != 0 {
				buf.WriteString(`,`)
			}

			{

				err = v.MarshalJSONBuf(buf)
				if err != nil {
					return err
				}

			}
		}
		buf.WriteString(`]`)
	} else {
		buf.WriteString(`null`)
	}
	buf.WriteString(`,"io_merged":`)
	if mj.IOMerged != nil {
		buf.WriteString(`[`)
		for i, v := range mj.IOMerged {
			if i != 0 {
				buf.WriteString(`,`)
			}

			{

				err = v.MarshalJSONBuf(buf)
				if err != nil {
					return err
				}

			}
		}
		buf.WriteString(`]`)
	} else {
		buf.WriteString(`null`)
	}
	buf.WriteString(`,"io_queued":`)
	if mj.IOQueued != nil {
		buf.WriteString(`[`)
		for i, v := range mj.IOQueued {
			if i != 0 {
				buf.WriteString(`,`)
			}

			{

				err = v.MarshalJSONBuf(buf)
				if err != nil {
					return err
				}

			}
		}
		buf.WriteString(`]`)
	} else {
		buf.WriteString(`null`)
	}
	buf.WriteByte('}')
	return nil
}

const (
	ffj_t_CgroupInfo_Blkio_CFQ_Statisticsbase = iota
	ffj_t_CgroupInfo_Blkio_CFQ_Statisticsno_such_key

	ffj_t_CgroupInfo_Blkio_CFQ_Statistics_Device

	ffj_t_CgroupInfo_Blkio_CFQ_Statistics_Sectors

	ffj_t_CgroupInfo_Blkio_CFQ_Statistics_Time

	ffj_t_CgroupInfo_Blkio_CFQ_Statistics_IOServiced

	ffj_t_CgroupInfo_Blkio_CFQ_Statistics_IOServiceBytes

	ffj_t_CgroupInfo_Blkio_CFQ_Statistics_IOServiceTime

	ffj_t_CgroupInfo_Blkio_CFQ_Statistics_IOWaitTime

	ffj_t_CgroupInfo_Blkio_CFQ_Statistics_IOMerged

	ffj_t_CgroupInfo_Blkio_CFQ_Statistics_IOQueued
)

var ffj_key_CgroupInfo_Blkio_CFQ_Statistics_Device = []byte("device")

var ffj_key_CgroupInfo_Blkio_CFQ_Statistics_Sectors = []byte("sectors")

var ffj_key_CgroupInfo_Blkio_CFQ_Statistics_Time = []byte("time")

var ffj_key_CgroupInfo_Blkio_CFQ_Statistics_IOServiced = []byte("io_serviced")

var ffj_key_CgroupInfo_Blkio_CFQ_Statistics_IOServiceBytes = []byte("io_service_bytes")

var ffj_key_CgroupInfo_Blkio_CFQ_Statistics_IOServiceTime = []byte("io_service_time")

var ffj_key_CgroupInfo_Blkio_CFQ_Statistics_IOWaitTime = []byte("io_wait_time")

var ffj_key_CgroupInfo_Blkio_CFQ_Statistics_IOMerged = []byte("io_merged")

var ffj_key_CgroupInfo_Blkio_CFQ_Statistics_IOQueued = []byte("io_queued")

func (uj *CgroupInfo_Blkio_CFQ_Statistics) UnmarshalJSON(input []byte) error {
	fs := fflib.NewFFLexer(input)
	return uj.UnmarshalJSONFFLexer(fs, fflib.FFParse_map_start)
}

func (uj *CgroupInfo_Blkio_CFQ_Statistics) UnmarshalJSONFFLexer(fs *fflib.FFLexer, state fflib.FFParseState) error {
	var err error = nil
	currentKey := ffj_t_CgroupInfo_Blkio_CFQ_Statisticsbase
	_ = currentKey
	tok := fflib.FFTok_init
	wantedTok := fflib.FFTok_init

mainparse:
	for {
		tok = fs.Scan()
		//	println(fmt.Sprintf("debug: tok: %v  state: %v", tok, state))
		if tok == fflib.FFTok_error {
			goto tokerror
		}

		switch state {

		case fflib.FFParse_map_start:
			if tok != fflib.FFTok_left_bracket {
				wantedTok = fflib.FFTok_left_bracket
				goto wrongtokenerror
			}
			state = fflib.FFParse_want_key
			continue

		case fflib.FFParse_after_value:
			if tok == fflib.FFTok_comma {
				state = fflib.FFParse_want_key
			} else if tok == fflib.FFTok_right_bracket {
				goto done
			} else {
				wantedTok = fflib.FFTok_comma
				goto wrongtokenerror
			}

		case fflib.FFParse_want_key:
			// json {} ended. goto exit. woo.
			if tok == fflib.FFTok_right_bracket {
				goto done
			}
			if tok != fflib.FFTok_string {
				wantedTok = fflib.FFTok_string
				goto wrongtokenerror
			}

			kn := fs.Output.Bytes()
			if len(kn) <= 0 {
				// "" case. hrm.
				currentKey = ffj_t_CgroupInfo_Blkio_CFQ_Statisticsno_such_key
				state = fflib.FFParse_want_colon
				goto mainparse
			} else {
				switch kn[0] {

				case 'd':

					if bytes.Equal(ffj_key_CgroupInfo_Blkio_CFQ_Statistics_Device, kn) {
						currentKey = ffj_t_CgroupInfo_Blkio_CFQ_Statistics_Device
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				case 'i':

					if bytes.Equal(ffj_key_CgroupInfo_Blkio_CFQ_Statistics_IOServiced, kn) {
						currentKey = ffj_t_CgroupInfo_Blkio_CFQ_Statistics_IOServiced
						state = fflib.FFParse_want_colon
						goto mainparse

					} else if bytes.Equal(ffj_key_CgroupInfo_Blkio_CFQ_Statistics_IOServiceBytes, kn) {
						currentKey = ffj_t_CgroupInfo_Blkio_CFQ_Statistics_IOServiceBytes
						state = fflib.FFParse_want_colon
						goto mainparse

					} else if bytes.Equal(ffj_key_CgroupInfo_Blkio_CFQ_Statistics_IOServiceTime, kn) {
						currentKey = ffj_t_CgroupInfo_Blkio_CFQ_Statistics_IOServiceTime
						state = fflib.FFParse_want_colon
						goto mainparse

					} else if bytes.Equal(ffj_key_CgroupInfo_Blkio_CFQ_Statistics_IOWaitTime, kn) {
						currentKey = ffj_t_CgroupInfo_Blkio_CFQ_Statistics_IOWaitTime
						state = fflib.FFParse_want_colon
						goto mainparse

					} else if bytes.Equal(ffj_key_CgroupInfo_Blkio_CFQ_Statistics_IOMerged, kn) {
						currentKey = ffj_t_CgroupInfo_Blkio_CFQ_Statistics_IOMerged
						state = fflib.FFParse_want_colon
						goto mainparse

					} else if bytes.Equal(ffj_key_CgroupInfo_Blkio_CFQ_Statistics_IOQueued, kn) {
						currentKey = ffj_t_CgroupInfo_Blkio_CFQ_Statistics_IOQueued
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				case 's':

					if bytes.Equal(ffj_key_CgroupInfo_Blkio_CFQ_Statistics_Sectors, kn) {
						currentKey = ffj_t_CgroupInfo_Blkio_CFQ_Statistics_Sectors
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				case 't':

					if bytes.Equal(ffj_key_CgroupInfo_Blkio_CFQ_Statistics_Time, kn) {
						currentKey = ffj_t_CgroupInfo_Blkio_CFQ_Statistics_Time
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				}

				if fflib.AsciiEqualFold(ffj_key_CgroupInfo_Blkio_CFQ_Statistics_IOQueued, kn) {
					currentKey = ffj_t_CgroupInfo_Blkio_CFQ_Statistics_IOQueued
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.AsciiEqualFold(ffj_key_CgroupInfo_Blkio_CFQ_Statistics_IOMerged, kn) {
					currentKey = ffj_t_CgroupInfo_Blkio_CFQ_Statistics_IOMerged
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.AsciiEqualFold(ffj_key_CgroupInfo_Blkio_CFQ_Statistics_IOWaitTime, kn) {
					currentKey = ffj_t_CgroupInfo_Blkio_CFQ_Statistics_IOWaitTime
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffj_key_CgroupInfo_Blkio_CFQ_Statistics_IOServiceTime, kn) {
					currentKey = ffj_t_CgroupInfo_Blkio_CFQ_Statistics_IOServiceTime
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffj_key_CgroupInfo_Blkio_CFQ_Statistics_IOServiceBytes, kn) {
					currentKey = ffj_t_CgroupInfo_Blkio_CFQ_Statistics_IOServiceBytes
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffj_key_CgroupInfo_Blkio_CFQ_Statistics_IOServiced, kn) {
					currentKey = ffj_t_CgroupInfo_Blkio_CFQ_Statistics_IOServiced
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.SimpleLetterEqualFold(ffj_key_CgroupInfo_Blkio_CFQ_Statistics_Time, kn) {
					currentKey = ffj_t_CgroupInfo_Blkio_CFQ_Statistics_Time
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffj_key_CgroupInfo_Blkio_CFQ_Statistics_Sectors, kn) {
					currentKey = ffj_t_CgroupInfo_Blkio_CFQ_Statistics_Sectors
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.SimpleLetterEqualFold(ffj_key_CgroupInfo_Blkio_CFQ_Statistics_Device, kn) {
					currentKey = ffj_t_CgroupInfo_Blkio_CFQ_Statistics_Device
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				currentKey = ffj_t_CgroupInfo_Blkio_CFQ_Statisticsno_such_key
				state = fflib.FFParse_want_colon
				goto mainparse
			}

		case fflib.FFParse_want_colon:
			if tok != fflib.FFTok_colon {
				wantedTok = fflib.FFTok_colon
				goto wrongtokenerror
			}
			state = fflib.FFParse_want_value
			continue
		case fflib.FFParse_want_value:

			if tok == fflib.FFTok_left_brace || tok == fflib.FFTok_left_bracket || tok == fflib.FFTok_integer || tok == fflib.FFTok_double || tok == fflib.FFTok_string || tok == fflib.FFTok_bool || tok == fflib.FFTok_null {
				switch currentKey {

				case ffj_t_CgroupInfo_Blkio_CFQ_Statistics_Device:
					goto handle_Device

				case ffj_t_CgroupInfo_Blkio_CFQ_Statistics_Sectors:
					goto handle_Sectors

				case ffj_t_CgroupInfo_Blkio_CFQ_Statistics_Time:
					goto handle_Time

				case ffj_t_CgroupInfo_Blkio_CFQ_Statistics_IOServiced:
					goto handle_IOServiced

				case ffj_t_CgroupInfo_Blkio_CFQ_Statistics_IOServiceBytes:
					goto handle_IOServiceBytes

				case ffj_t_CgroupInfo_Blkio_CFQ_Statistics_IOServiceTime:
					goto handle_IOServiceTime

				case ffj_t_CgroupInfo_Blkio_CFQ_Statistics_IOWaitTime:
					goto handle_IOWaitTime

				case ffj_t_CgroupInfo_Blkio_CFQ_Statistics_IOMerged:
					goto handle_IOMerged

				case ffj_t_CgroupInfo_Blkio_CFQ_Statistics_IOQueued:
					goto handle_IOQueued

				case ffj_t_CgroupInfo_Blkio_CFQ_Statisticsno_such_key:
					err = fs.SkipField(tok)
					if err != nil {
						return fs.WrapErr(err)
					}
					state = fflib.FFParse_after_value
					goto mainparse
				}
			} else {
				goto wantedvalue
			}
		}
	}

handle_Device:

	/* handler: uj.Device type=mesos.Device_Number kind=struct quoted=false*/

	{
		if tok == fflib.FFTok_null {

			uj.Device = nil

			state = fflib.FFParse_after_value
			goto mainparse
		}

		if uj.Device == nil {
			uj.Device = new(Device_Number)
		}

		err = uj.Device.UnmarshalJSONFFLexer(fs, fflib.FFParse_want_key)
		if err != nil {
			return err
		}
		state = fflib.FFParse_after_value
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_Sectors:

	/* handler: uj.Sectors type=uint64 kind=uint64 quoted=false*/

	{
		if tok != fflib.FFTok_integer && tok != fflib.FFTok_null {
			return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for uint64", tok))
		}
	}

	{

		if tok == fflib.FFTok_null {

			uj.Sectors = nil

		} else {

			tval, err := fflib.ParseUint(fs.Output.Bytes(), 10, 64)

			if err != nil {
				return fs.WrapErr(err)
			}

			ttypval := uint64(tval)
			uj.Sectors = &ttypval

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_Time:

	/* handler: uj.Time type=uint64 kind=uint64 quoted=false*/

	{
		if tok != fflib.FFTok_integer && tok != fflib.FFTok_null {
			return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for uint64", tok))
		}
	}

	{

		if tok == fflib.FFTok_null {

			uj.Time = nil

		} else {

			tval, err := fflib.ParseUint(fs.Output.Bytes(), 10, 64)

			if err != nil {
				return fs.WrapErr(err)
			}

			ttypval := uint64(tval)
			uj.Time = &ttypval

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_IOServiced:

	/* handler: uj.IOServiced type=[]mesos.CgroupInfo_Blkio_Value kind=slice quoted=false*/

	{

		{
			if tok != fflib.FFTok_left_brace && tok != fflib.FFTok_null {
				return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for ", tok))
			}
		}

		if tok == fflib.FFTok_null {
			uj.IOServiced = nil
		} else {

			uj.IOServiced = []CgroupInfo_Blkio_Value{}

			wantVal := true

			for {

				var tmp_uj__IOServiced CgroupInfo_Blkio_Value

				tok = fs.Scan()
				if tok == fflib.FFTok_error {
					goto tokerror
				}
				if tok == fflib.FFTok_right_brace {
					break
				}

				if tok == fflib.FFTok_comma {
					if wantVal == true {
						// TODO(pquerna): this isn't an ideal error message, this handles
						// things like [,,,] as an array value.
						return fs.WrapErr(fmt.Errorf("wanted value token, but got token: %v", tok))
					}
					continue
				} else {
					wantVal = true
				}

				/* handler: tmp_uj__IOServiced type=mesos.CgroupInfo_Blkio_Value kind=struct quoted=false*/

				{
					if tok == fflib.FFTok_null {

						state = fflib.FFParse_after_value
						goto mainparse
					}

					err = tmp_uj__IOServiced.UnmarshalJSONFFLexer(fs, fflib.FFParse_want_key)
					if err != nil {
						return err
					}
					state = fflib.FFParse_after_value
				}

				uj.IOServiced = append(uj.IOServiced, tmp_uj__IOServiced)

				wantVal = false
			}
		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_IOServiceBytes:

	/* handler: uj.IOServiceBytes type=[]mesos.CgroupInfo_Blkio_Value kind=slice quoted=false*/

	{

		{
			if tok != fflib.FFTok_left_brace && tok != fflib.FFTok_null {
				return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for ", tok))
			}
		}

		if tok == fflib.FFTok_null {
			uj.IOServiceBytes = nil
		} else {

			uj.IOServiceBytes = []CgroupInfo_Blkio_Value{}

			wantVal := true

			for {

				var tmp_uj__IOServiceBytes CgroupInfo_Blkio_Value

				tok = fs.Scan()
				if tok == fflib.FFTok_error {
					goto tokerror
				}
				if tok == fflib.FFTok_right_brace {
					break
				}

				if tok == fflib.FFTok_comma {
					if wantVal == true {
						// TODO(pquerna): this isn't an ideal error message, this handles
						// things like [,,,] as an array value.
						return fs.WrapErr(fmt.Errorf("wanted value token, but got token: %v", tok))
					}
					continue
				} else {
					wantVal = true
				}

				/* handler: tmp_uj__IOServiceBytes type=mesos.CgroupInfo_Blkio_Value kind=struct quoted=false*/

				{
					if tok == fflib.FFTok_null {

						state = fflib.FFParse_after_value
						goto mainparse
					}

					err = tmp_uj__IOServiceBytes.UnmarshalJSONFFLexer(fs, fflib.FFParse_want_key)
					if err != nil {
						return err
					}
					state = fflib.FFParse_after_value
				}

				uj.IOServiceBytes = append(uj.IOServiceBytes, tmp_uj__IOServiceBytes)

				wantVal = false
			}
		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_IOServiceTime:

	/* handler: uj.IOServiceTime type=[]mesos.CgroupInfo_Blkio_Value kind=slice quoted=false*/

	{

		{
			if tok != fflib.FFTok_left_brace && tok != fflib.FFTok_null {
				return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for ", tok))
			}
		}

		if tok == fflib.FFTok_null {
			uj.IOServiceTime = nil
		} else {

			uj.IOServiceTime = []CgroupInfo_Blkio_Value{}

			wantVal := true

			for {

				var tmp_uj__IOServiceTime CgroupInfo_Blkio_Value

				tok = fs.Scan()
				if tok == fflib.FFTok_error {
					goto tokerror
				}
				if tok == fflib.FFTok_right_brace {
					break
				}

				if tok == fflib.FFTok_comma {
					if wantVal == true {
						// TODO(pquerna): this isn't an ideal error message, this handles
						// things like [,,,] as an array value.
						return fs.WrapErr(fmt.Errorf("wanted value token, but got token: %v", tok))
					}
					continue
				} else {
					wantVal = true
				}

				/* handler: tmp_uj__IOServiceTime type=mesos.CgroupInfo_Blkio_Value kind=struct quoted=false*/

				{
					if tok == fflib.FFTok_null {

						state = fflib.FFParse_after_value
						goto mainparse
					}

					err = tmp_uj__IOServiceTime.UnmarshalJSONFFLexer(fs, fflib.FFParse_want_key)
					if err != nil {
						return err
					}
					state = fflib.FFParse_after_value
				}

				uj.IOServiceTime = append(uj.IOServiceTime, tmp_uj__IOServiceTime)

				wantVal = false
			}
		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_IOWaitTime:

	/* handler: uj.IOWaitTime type=[]mesos.CgroupInfo_Blkio_Value kind=slice quoted=false*/

	{

		{
			if tok != fflib.FFTok_left_brace && tok != fflib.FFTok_null {
				return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for ", tok))
			}
		}

		if tok == fflib.FFTok_null {
			uj.IOWaitTime = nil
		} else {

			uj.IOWaitTime = []CgroupInfo_Blkio_Value{}

			wantVal := true

			for {

				var tmp_uj__IOWaitTime CgroupInfo_Blkio_Value

				tok = fs.Scan()
				if tok == fflib.FFTok_error {
					goto tokerror
				}
				if tok == fflib.FFTok_right_brace {
					break
				}

				if tok == fflib.FFTok_comma {
					if wantVal == true {
						// TODO(pquerna): this isn't an ideal error message, this handles
						// things like [,,,] as an array value.
						return fs.WrapErr(fmt.Errorf("wanted value token, but got token: %v", tok))
					}
					continue
				} else {
					wantVal = true
				}

				/* handler: tmp_uj__IOWaitTime type=mesos.CgroupInfo_Blkio_Value kind=struct quoted=false*/

				{
					if tok == fflib.FFTok_null {

						state = fflib.FFParse_after_value
						goto mainparse
					}

					err = tmp_uj__IOWaitTime.UnmarshalJSONFFLexer(fs, fflib.FFParse_want_key)
					if err != nil {
						return err
					}
					state = fflib.FFParse_after_value
				}

				uj.IOWaitTime = append(uj.IOWaitTime, tmp_uj__IOWaitTime)

				wantVal = false
			}
		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_IOMerged:

	/* handler: uj.IOMerged type=[]mesos.CgroupInfo_Blkio_Value kind=slice quoted=false*/

	{

		{
			if tok != fflib.FFTok_left_brace && tok != fflib.FFTok_null {
				return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for ", tok))
			}
		}

		if tok == fflib.FFTok_null {
			uj.IOMerged = nil
		} else {

			uj.IOMerged = []CgroupInfo_Blkio_Value{}

			wantVal := true

			for {

				var tmp_uj__IOMerged CgroupInfo_Blkio_Value

				tok = fs.Scan()
				if tok == fflib.FFTok_error {
					goto tokerror
				}
				if tok == fflib.FFTok_right_brace {
					break
				}

				if tok == fflib.FFTok_comma {
					if wantVal == true {
						// TODO(pquerna): this isn't an ideal error message, this handles
						// things like [,,,] as an array value.
						return fs.WrapErr(fmt.Errorf("wanted value token, but got token: %v", tok))
					}
					continue
				} else {
					wantVal = true
				}

				/* handler: tmp_uj__IOMerged type=mesos.CgroupInfo_Blkio_Value kind=struct quoted=false*/

				{
					if tok == fflib.FFTok_null {

						state = fflib.FFParse_after_value
						goto mainparse
					}

					err = tmp_uj__IOMerged.UnmarshalJSONFFLexer(fs, fflib.FFParse_want_key)
					if err != nil {
						return err
					}
					state = fflib.FFParse_after_value
				}

				uj.IOMerged = append(uj.IOMerged, tmp_uj__IOMerged)

				wantVal = false
			}
		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_IOQueued:

	/* handler: uj.IOQueued type=[]mesos.CgroupInfo_Blkio_Value kind=slice quoted=false*/

	{

		{
			if tok != fflib.FFTok_left_brace && tok != fflib.FFTok_null {
				return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for ", tok))
			}
		}

		if tok == fflib.FFTok_null {
			uj.IOQueued = nil
		} else {

			uj.IOQueued = []CgroupInfo_Blkio_Value{}

			wantVal := true

			for {

				var tmp_uj__IOQueued CgroupInfo_Blkio_Value

				tok = fs.Scan()
				if tok == fflib.FFTok_error {
					goto tokerror
				}
				if tok == fflib.FFTok_right_brace {
					break
				}

				if tok == fflib.FFTok_comma {
					if wantVal == true {
						// TODO(pquerna): this isn't an ideal error message, this handles
						// things like [,,,] as an array value.
						return fs.WrapErr(fmt.Errorf("wanted value token, but got token: %v", tok))
					}
					continue
				} else {
					wantVal = true
				}

				/* handler: tmp_uj__IOQueued type=mesos.CgroupInfo_Blkio_Value kind=struct quoted=false*/

				{
					if tok == fflib.FFTok_null {

						state = fflib.FFParse_after_value
						goto mainparse
					}

					err = tmp_uj__IOQueued.UnmarshalJSONFFLexer(fs, fflib.FFParse_want_key)
					if err != nil {
						return err
					}
					state = fflib.FFParse_after_value
				}

				uj.IOQueued = append(uj.IOQueued, tmp_uj__IOQueued)

				wantVal = false
			}
		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

wantedvalue:
	return fs.WrapErr(fmt.Errorf("wanted value token, but got token: %v", tok))
wrongtokenerror:
	return fs.WrapErr(fmt.Errorf("ffjson: wanted token: %v, but got token: %v output=%s", wantedTok, tok, fs.Output.String()))
tokerror:
	if fs.BigError != nil {
		return fs.WrapErr(fs.BigError)
	}
	err = fs.Error.ToError()
	if err != nil {
		return fs.WrapErr(err)
	}
	panic("ffjson-generated: unreachable, please report bug.")
done:

	return nil
}

func (mj *CgroupInfo_Blkio_Statistics) MarshalJSON() ([]byte, error) {
	var buf fflib.Buffer
	if mj == nil {
		buf.WriteString("null")
		return buf.Bytes(), nil
	}
	err := mj.MarshalJSONBuf(&buf)
	if err != nil {
		return nil, err
	}
	return buf.Bytes(), nil
}
func (mj *CgroupInfo_Blkio_Statistics) MarshalJSONBuf(buf fflib.EncodingBuffer) error {
	if mj == nil {
		buf.WriteString("null")
		return nil
	}
	var err error
	var obj []byte
	_ = obj
	_ = err
	buf.WriteString(`{ "cfq":`)
	if mj.CFQ != nil {
		buf.WriteString(`[`)
		for i, v := range mj.CFQ {
			if i != 0 {
				buf.WriteString(`,`)
			}

			{

				err = v.MarshalJSONBuf(buf)
				if err != nil {
					return err
				}

			}
		}
		buf.WriteString(`]`)
	} else {
		buf.WriteString(`null`)
	}
	buf.WriteString(`,"cfq_recursive":`)
	if mj.CFQRecursive != nil {
		buf.WriteString(`[`)
		for i, v := range mj.CFQRecursive {
			if i != 0 {
				buf.WriteString(`,`)
			}

			{

				err = v.MarshalJSONBuf(buf)
				if err != nil {
					return err
				}

			}
		}
		buf.WriteString(`]`)
	} else {
		buf.WriteString(`null`)
	}
	buf.WriteByte(',')
	if len(mj.Throttling) != 0 {
		buf.WriteString(`"throttling":`)
		if mj.Throttling != nil {
			buf.WriteString(`[`)
			for i, v := range mj.Throttling {
				if i != 0 {
					buf.WriteString(`,`)
				}

				{

					if v == nil {
						buf.WriteString("null")
						return nil
					}

					err = v.MarshalJSONBuf(buf)
					if err != nil {
						return err
					}

				}
			}
			buf.WriteString(`]`)
		} else {
			buf.WriteString(`null`)
		}
		buf.WriteByte(',')
	}
	buf.Rewind(1)
	buf.WriteByte('}')
	return nil
}

const (
	ffj_t_CgroupInfo_Blkio_Statisticsbase = iota
	ffj_t_CgroupInfo_Blkio_Statisticsno_such_key

	ffj_t_CgroupInfo_Blkio_Statistics_CFQ

	ffj_t_CgroupInfo_Blkio_Statistics_CFQRecursive

	ffj_t_CgroupInfo_Blkio_Statistics_Throttling
)

var ffj_key_CgroupInfo_Blkio_Statistics_CFQ = []byte("cfq")

var ffj_key_CgroupInfo_Blkio_Statistics_CFQRecursive = []byte("cfq_recursive")

var ffj_key_CgroupInfo_Blkio_Statistics_Throttling = []byte("throttling")

func (uj *CgroupInfo_Blkio_Statistics) UnmarshalJSON(input []byte) error {
	fs := fflib.NewFFLexer(input)
	return uj.UnmarshalJSONFFLexer(fs, fflib.FFParse_map_start)
}

func (uj *CgroupInfo_Blkio_Statistics) UnmarshalJSONFFLexer(fs *fflib.FFLexer, state fflib.FFParseState) error {
	var err error = nil
	currentKey := ffj_t_CgroupInfo_Blkio_Statisticsbase
	_ = currentKey
	tok := fflib.FFTok_init
	wantedTok := fflib.FFTok_init

mainparse:
	for {
		tok = fs.Scan()
		//	println(fmt.Sprintf("debug: tok: %v  state: %v", tok, state))
		if tok == fflib.FFTok_error {
			goto tokerror
		}

		switch state {

		case fflib.FFParse_map_start:
			if tok != fflib.FFTok_left_bracket {
				wantedTok = fflib.FFTok_left_bracket
				goto wrongtokenerror
			}
			state = fflib.FFParse_want_key
			continue

		case fflib.FFParse_after_value:
			if tok == fflib.FFTok_comma {
				state = fflib.FFParse_want_key
			} else if tok == fflib.FFTok_right_bracket {
				goto done
			} else {
				wantedTok = fflib.FFTok_comma
				goto wrongtokenerror
			}

		case fflib.FFParse_want_key:
			// json {} ended. goto exit. woo.
			if tok == fflib.FFTok_right_bracket {
				goto done
			}
			if tok != fflib.FFTok_string {
				wantedTok = fflib.FFTok_string
				goto wrongtokenerror
			}

			kn := fs.Output.Bytes()
			if len(kn) <= 0 {
				// "" case. hrm.
				currentKey = ffj_t_CgroupInfo_Blkio_Statisticsno_such_key
				state = fflib.FFParse_want_colon
				goto mainparse
			} else {
				switch kn[0] {

				case 'c':

					if bytes.Equal(ffj_key_CgroupInfo_Blkio_Statistics_CFQ, kn) {
						currentKey = ffj_t_CgroupInfo_Blkio_Statistics_CFQ
						state = fflib.FFParse_want_colon
						goto mainparse

					} else if bytes.Equal(ffj_key_CgroupInfo_Blkio_Statistics_CFQRecursive, kn) {
						currentKey = ffj_t_CgroupInfo_Blkio_Statistics_CFQRecursive
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				case 't':

					if bytes.Equal(ffj_key_CgroupInfo_Blkio_Statistics_Throttling, kn) {
						currentKey = ffj_t_CgroupInfo_Blkio_Statistics_Throttling
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				}

				if fflib.SimpleLetterEqualFold(ffj_key_CgroupInfo_Blkio_Statistics_Throttling, kn) {
					currentKey = ffj_t_CgroupInfo_Blkio_Statistics_Throttling
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffj_key_CgroupInfo_Blkio_Statistics_CFQRecursive, kn) {
					currentKey = ffj_t_CgroupInfo_Blkio_Statistics_CFQRecursive
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.SimpleLetterEqualFold(ffj_key_CgroupInfo_Blkio_Statistics_CFQ, kn) {
					currentKey = ffj_t_CgroupInfo_Blkio_Statistics_CFQ
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				currentKey = ffj_t_CgroupInfo_Blkio_Statisticsno_such_key
				state = fflib.FFParse_want_colon
				goto mainparse
			}

		case fflib.FFParse_want_colon:
			if tok != fflib.FFTok_colon {
				wantedTok = fflib.FFTok_colon
				goto wrongtokenerror
			}
			state = fflib.FFParse_want_value
			continue
		case fflib.FFParse_want_value:

			if tok == fflib.FFTok_left_brace || tok == fflib.FFTok_left_bracket || tok == fflib.FFTok_integer || tok == fflib.FFTok_double || tok == fflib.FFTok_string || tok == fflib.FFTok_bool || tok == fflib.FFTok_null {
				switch currentKey {

				case ffj_t_CgroupInfo_Blkio_Statistics_CFQ:
					goto handle_CFQ

				case ffj_t_CgroupInfo_Blkio_Statistics_CFQRecursive:
					goto handle_CFQRecursive

				case ffj_t_CgroupInfo_Blkio_Statistics_Throttling:
					goto handle_Throttling

				case ffj_t_CgroupInfo_Blkio_Statisticsno_such_key:
					err = fs.SkipField(tok)
					if err != nil {
						return fs.WrapErr(err)
					}
					state = fflib.FFParse_after_value
					goto mainparse
				}
			} else {
				goto wantedvalue
			}
		}
	}

handle_CFQ:

	/* handler: uj.CFQ type=[]mesos.CgroupInfo_Blkio_CFQ_Statistics kind=slice quoted=false*/

	{

		{
			if tok != fflib.FFTok_left_brace && tok != fflib.FFTok_null {
				return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for ", tok))
			}
		}

		if tok == fflib.FFTok_null {
			uj.CFQ = nil
		} else {

			uj.CFQ = []CgroupInfo_Blkio_CFQ_Statistics{}

			wantVal := true

			for {

				var tmp_uj__CFQ CgroupInfo_Blkio_CFQ_Statistics

				tok = fs.Scan()
				if tok == fflib.FFTok_error {
					goto tokerror
				}
				if tok == fflib.FFTok_right_brace {
					break
				}

				if tok == fflib.FFTok_comma {
					if wantVal == true {
						// TODO(pquerna): this isn't an ideal error message, this handles
						// things like [,,,] as an array value.
						return fs.WrapErr(fmt.Errorf("wanted value token, but got token: %v", tok))
					}
					continue
				} else {
					wantVal = true
				}

				/* handler: tmp_uj__CFQ type=mesos.CgroupInfo_Blkio_CFQ_Statistics kind=struct quoted=false*/

				{
					if tok == fflib.FFTok_null {

						state = fflib.FFParse_after_value
						goto mainparse
					}

					err = tmp_uj__CFQ.UnmarshalJSONFFLexer(fs, fflib.FFParse_want_key)
					if err != nil {
						return err
					}
					state = fflib.FFParse_after_value
				}

				uj.CFQ = append(uj.CFQ, tmp_uj__CFQ)

				wantVal = false
			}
		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_CFQRecursive:

	/* handler: uj.CFQRecursive type=[]mesos.CgroupInfo_Blkio_CFQ_Statistics kind=slice quoted=false*/

	{

		{
			if tok != fflib.FFTok_left_brace && tok != fflib.FFTok_null {
				return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for ", tok))
			}
		}

		if tok == fflib.FFTok_null {
			uj.CFQRecursive = nil
		} else {

			uj.CFQRecursive = []CgroupInfo_Blkio_CFQ_Statistics{}

			wantVal := true

			for {

				var tmp_uj__CFQRecursive CgroupInfo_Blkio_CFQ_Statistics

				tok = fs.Scan()
				if tok == fflib.FFTok_error {
					goto tokerror
				}
				if tok == fflib.FFTok_right_brace {
					break
				}

				if tok == fflib.FFTok_comma {
					if wantVal == true {
						// TODO(pquerna): this isn't an ideal error message, this handles
						// things like [,,,] as an array value.
						return fs.WrapErr(fmt.Errorf("wanted value token, but got token: %v", tok))
					}
					continue
				} else {
					wantVal = true
				}

				/* handler: tmp_uj__CFQRecursive type=mesos.CgroupInfo_Blkio_CFQ_Statistics kind=struct quoted=false*/

				{
					if tok == fflib.FFTok_null {

						state = fflib.FFParse_after_value
						goto mainparse
					}

					err = tmp_uj__CFQRecursive.UnmarshalJSONFFLexer(fs, fflib.FFParse_want_key)
					if err != nil {
						return err
					}
					state = fflib.FFParse_after_value
				}

				uj.CFQRecursive = append(uj.CFQRecursive, tmp_uj__CFQRecursive)

				wantVal = false
			}
		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_Throttling:

	/* handler: uj.Throttling type=[]*mesos.CgroupInfo_Blkio_Throttling_Statistics kind=slice quoted=false*/

	{

		{
			if tok != fflib.FFTok_left_brace && tok != fflib.FFTok_null {
				return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for ", tok))
			}
		}

		if tok == fflib.FFTok_null {
			uj.Throttling = nil
		} else {

			uj.Throttling = []*CgroupInfo_Blkio_Throttling_Statistics{}

			wantVal := true

			for {

				var tmp_uj__Throttling *CgroupInfo_Blkio_Throttling_Statistics

				tok = fs.Scan()
				if tok == fflib.FFTok_error {
					goto tokerror
				}
				if tok == fflib.FFTok_right_brace {
					break
				}

				if tok == fflib.FFTok_comma {
					if wantVal == true {
						// TODO(pquerna): this isn't an ideal error message, this handles
						// things like [,,,] as an array value.
						return fs.WrapErr(fmt.Errorf("wanted value token, but got token: %v", tok))
					}
					continue
				} else {
					wantVal = true
				}

				/* handler: tmp_uj__Throttling type=*mesos.CgroupInfo_Blkio_Throttling_Statistics kind=ptr quoted=false*/

				{
					if tok == fflib.FFTok_null {

						tmp_uj__Throttling = nil

						state = fflib.FFParse_after_value
						goto mainparse
					}

					if tmp_uj__Throttling == nil {
						tmp_uj__Throttling = new(CgroupInfo_Blkio_Throttling_Statistics)
					}

					err = tmp_uj__Throttling.UnmarshalJSONFFLexer(fs, fflib.FFParse_want_key)
					if err != nil {
						return err
					}
					state = fflib.FFParse_after_value
				}

				uj.Throttling = append(uj.Throttling, tmp_uj__Throttling)

				wantVal = false
			}
		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

wantedvalue:
	return fs.WrapErr(fmt.Errorf("wanted value token, but got token: %v", tok))
wrongtokenerror:
	return fs.WrapErr(fmt.Errorf("ffjson: wanted token: %v, but got token: %v output=%s", wantedTok, tok, fs.Output.String()))
tokerror:
	if fs.BigError != nil {
		return fs.WrapErr(fs.BigError)
	}
	err = fs.Error.ToError()
	if err != nil {
		return fs.WrapErr(err)
	}
	panic("ffjson-generated: unreachable, please report bug.")
done:

	return nil
}

func (mj *CgroupInfo_Blkio_Throttling) MarshalJSON() ([]byte, error) {
	var buf fflib.Buffer
	if mj == nil {
		buf.WriteString("null")
		return buf.Bytes(), nil
	}
	err := mj.MarshalJSONBuf(&buf)
	if err != nil {
		return nil, err
	}
	return buf.Bytes(), nil
}
func (mj *CgroupInfo_Blkio_Throttling) MarshalJSONBuf(buf fflib.EncodingBuffer) error {
	if mj == nil {
		buf.WriteString("null")
		return nil
	}
	var err error
	var obj []byte
	_ = obj
	_ = err
	buf.WriteString(`{}`)
	return nil
}

const (
	ffj_t_CgroupInfo_Blkio_Throttlingbase = iota
	ffj_t_CgroupInfo_Blkio_Throttlingno_such_key
)

func (uj *CgroupInfo_Blkio_Throttling) UnmarshalJSON(input []byte) error {
	fs := fflib.NewFFLexer(input)
	return uj.UnmarshalJSONFFLexer(fs, fflib.FFParse_map_start)
}

func (uj *CgroupInfo_Blkio_Throttling) UnmarshalJSONFFLexer(fs *fflib.FFLexer, state fflib.FFParseState) error {
	var err error = nil
	currentKey := ffj_t_CgroupInfo_Blkio_Throttlingbase
	_ = currentKey
	tok := fflib.FFTok_init
	wantedTok := fflib.FFTok_init

mainparse:
	for {
		tok = fs.Scan()
		//	println(fmt.Sprintf("debug: tok: %v  state: %v", tok, state))
		if tok == fflib.FFTok_error {
			goto tokerror
		}

		switch state {

		case fflib.FFParse_map_start:
			if tok != fflib.FFTok_left_bracket {
				wantedTok = fflib.FFTok_left_bracket
				goto wrongtokenerror
			}
			state = fflib.FFParse_want_key
			continue

		case fflib.FFParse_after_value:
			if tok == fflib.FFTok_comma {
				state = fflib.FFParse_want_key
			} else if tok == fflib.FFTok_right_bracket {
				goto done
			} else {
				wantedTok = fflib.FFTok_comma
				goto wrongtokenerror
			}

		case fflib.FFParse_want_key:
			// json {} ended. goto exit. woo.
			if tok == fflib.FFTok_right_bracket {
				goto done
			}
			if tok != fflib.FFTok_string {
				wantedTok = fflib.FFTok_string
				goto wrongtokenerror
			}

			kn := fs.Output.Bytes()
			if len(kn) <= 0 {
				// "" case. hrm.
				currentKey = ffj_t_CgroupInfo_Blkio_Throttlingno_such_key
				state = fflib.FFParse_want_colon
				goto mainparse
			} else {
				switch kn[0] {

				}

				currentKey = ffj_t_CgroupInfo_Blkio_Throttlingno_such_key
				state = fflib.FFParse_want_colon
				goto mainparse
			}

		case fflib.FFParse_want_colon:
			if tok != fflib.FFTok_colon {
				wantedTok = fflib.FFTok_colon
				goto wrongtokenerror
			}
			state = fflib.FFParse_want_value
			continue
		case fflib.FFParse_want_value:

			if tok == fflib.FFTok_left_brace || tok == fflib.FFTok_left_bracket || tok == fflib.FFTok_integer || tok == fflib.FFTok_double || tok == fflib.FFTok_string || tok == fflib.FFTok_bool || tok == fflib.FFTok_null {
				switch currentKey {

				case ffj_t_CgroupInfo_Blkio_Throttlingno_such_key:
					err = fs.SkipField(tok)
					if err != nil {
						return fs.WrapErr(err)
					}
					state = fflib.FFParse_after_value
					goto mainparse
				}
			} else {
				goto wantedvalue
			}
		}
	}

wantedvalue:
	return fs.WrapErr(fmt.Errorf("wanted value token, but got token: %v", tok))
wrongtokenerror:
	return fs.WrapErr(fmt.Errorf("ffjson: wanted token: %v, but got token: %v output=%s", wantedTok, tok, fs.Output.String()))
tokerror:
	if fs.BigError != nil {
		return fs.WrapErr(fs.BigError)
	}
	err = fs.Error.ToError()
	if err != nil {
		return fs.WrapErr(err)
	}
	panic("ffjson-generated: unreachable, please report bug.")
done:

	return nil
}

func (mj *CgroupInfo_Blkio_Throttling_Statistics) MarshalJSON() ([]byte, error) {
	var buf fflib.Buffer
	if mj == nil {
		buf.WriteString("null")
		return buf.Bytes(), nil
	}
	err := mj.MarshalJSONBuf(&buf)
	if err != nil {
		return nil, err
	}
	return buf.Bytes(), nil
}
func (mj *CgroupInfo_Blkio_Throttling_Statistics) MarshalJSONBuf(buf fflib.EncodingBuffer) error {
	if mj == nil {
		buf.WriteString("null")
		return nil
	}
	var err error
	var obj []byte
	_ = obj
	_ = err
	buf.WriteByte('{')
	if mj.Device != nil {
		if true {
			buf.WriteString(`"device":`)

			{

				err = mj.Device.MarshalJSONBuf(buf)
				if err != nil {
					return err
				}

			}
			buf.WriteByte(',')
		}
	}
	buf.WriteString(`"io_serviced":`)
	if mj.IOServiced != nil {
		buf.WriteString(`[`)
		for i, v := range mj.IOServiced {
			if i != 0 {
				buf.WriteString(`,`)
			}

			{

				err = v.MarshalJSONBuf(buf)
				if err != nil {
					return err
				}

			}
		}
		buf.WriteString(`]`)
	} else {
		buf.WriteString(`null`)
	}
	buf.WriteString(`,"io_service_bytes":`)
	if mj.IOServiceBytes != nil {
		buf.WriteString(`[`)
		for i, v := range mj.IOServiceBytes {
			if i != 0 {
				buf.WriteString(`,`)
			}

			{

				err = v.MarshalJSONBuf(buf)
				if err != nil {
					return err
				}

			}
		}
		buf.WriteString(`]`)
	} else {
		buf.WriteString(`null`)
	}
	buf.WriteByte('}')
	return nil
}

const (
	ffj_t_CgroupInfo_Blkio_Throttling_Statisticsbase = iota
	ffj_t_CgroupInfo_Blkio_Throttling_Statisticsno_such_key

	ffj_t_CgroupInfo_Blkio_Throttling_Statistics_Device

	ffj_t_CgroupInfo_Blkio_Throttling_Statistics_IOServiced

	ffj_t_CgroupInfo_Blkio_Throttling_Statistics_IOServiceBytes
)

var ffj_key_CgroupInfo_Blkio_Throttling_Statistics_Device = []byte("device")

var ffj_key_CgroupInfo_Blkio_Throttling_Statistics_IOServiced = []byte("io_serviced")

var ffj_key_CgroupInfo_Blkio_Throttling_Statistics_IOServiceBytes = []byte("io_service_bytes")

func (uj *CgroupInfo_Blkio_Throttling_Statistics) UnmarshalJSON(input []byte) error {
	fs := fflib.NewFFLexer(input)
	return uj.UnmarshalJSONFFLexer(fs, fflib.FFParse_map_start)
}

func (uj *CgroupInfo_Blkio_Throttling_Statistics) UnmarshalJSONFFLexer(fs *fflib.FFLexer, state fflib.FFParseState) error {
	var err error = nil
	currentKey := ffj_t_CgroupInfo_Blkio_Throttling_Statisticsbase
	_ = currentKey
	tok := fflib.FFTok_init
	wantedTok := fflib.FFTok_init

mainparse:
	for {
		tok = fs.Scan()
		//	println(fmt.Sprintf("debug: tok: %v  state: %v", tok, state))
		if tok == fflib.FFTok_error {
			goto tokerror
		}

		switch state {

		case fflib.FFParse_map_start:
			if tok != fflib.FFTok_left_bracket {
				wantedTok = fflib.FFTok_left_bracket
				goto wrongtokenerror
			}
			state = fflib.FFParse_want_key
			continue

		case fflib.FFParse_after_value:
			if tok == fflib.FFTok_comma {
				state = fflib.FFParse_want_key
			} else if tok == fflib.FFTok_right_bracket {
				goto done
			} else {
				wantedTok = fflib.FFTok_comma
				goto wrongtokenerror
			}

		case fflib.FFParse_want_key:
			// json {} ended. goto exit. woo.
			if tok == fflib.FFTok_right_bracket {
				goto done
			}
			if tok != fflib.FFTok_string {
				wantedTok = fflib.FFTok_string
				goto wrongtokenerror
			}

			kn := fs.Output.Bytes()
			if len(kn) <= 0 {
				// "" case. hrm.
				currentKey = ffj_t_CgroupInfo_Blkio_Throttling_Statisticsno_such_key
				state = fflib.FFParse_want_colon
				goto mainparse
			} else {
				switch kn[0] {

				case 'd':

					if bytes.Equal(ffj_key_CgroupInfo_Blkio_Throttling_Statistics_Device, kn) {
						currentKey = ffj_t_CgroupInfo_Blkio_Throttling_Statistics_Device
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				case 'i':

					if bytes.Equal(ffj_key_CgroupInfo_Blkio_Throttling_Statistics_IOServiced, kn) {
						currentKey = ffj_t_CgroupInfo_Blkio_Throttling_Statistics_IOServiced
						state = fflib.FFParse_want_colon
						goto mainparse

					} else if bytes.Equal(ffj_key_CgroupInfo_Blkio_Throttling_Statistics_IOServiceBytes, kn) {
						currentKey = ffj_t_CgroupInfo_Blkio_Throttling_Statistics_IOServiceBytes
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				}

				if fflib.EqualFoldRight(ffj_key_CgroupInfo_Blkio_Throttling_Statistics_IOServiceBytes, kn) {
					currentKey = ffj_t_CgroupInfo_Blkio_Throttling_Statistics_IOServiceBytes
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffj_key_CgroupInfo_Blkio_Throttling_Statistics_IOServiced, kn) {
					currentKey = ffj_t_CgroupInfo_Blkio_Throttling_Statistics_IOServiced
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.SimpleLetterEqualFold(ffj_key_CgroupInfo_Blkio_Throttling_Statistics_Device, kn) {
					currentKey = ffj_t_CgroupInfo_Blkio_Throttling_Statistics_Device
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				currentKey = ffj_t_CgroupInfo_Blkio_Throttling_Statisticsno_such_key
				state = fflib.FFParse_want_colon
				goto mainparse
			}

		case fflib.FFParse_want_colon:
			if tok != fflib.FFTok_colon {
				wantedTok = fflib.FFTok_colon
				goto wrongtokenerror
			}
			state = fflib.FFParse_want_value
			continue
		case fflib.FFParse_want_value:

			if tok == fflib.FFTok_left_brace || tok == fflib.FFTok_left_bracket || tok == fflib.FFTok_integer || tok == fflib.FFTok_double || tok == fflib.FFTok_string || tok == fflib.FFTok_bool || tok == fflib.FFTok_null {
				switch currentKey {

				case ffj_t_CgroupInfo_Blkio_Throttling_Statistics_Device:
					goto handle_Device

				case ffj_t_CgroupInfo_Blkio_Throttling_Statistics_IOServiced:
					goto handle_IOServiced

				case ffj_t_CgroupInfo_Blkio_Throttling_Statistics_IOServiceBytes:
					goto handle_IOServiceBytes

				case ffj_t_CgroupInfo_Blkio_Throttling_Statisticsno_such_key:
					err = fs.SkipField(tok)
					if err != nil {
						return fs.WrapErr(err)
					}
					state = fflib.FFParse_after_value
					goto mainparse
				}
			} else {
				goto wantedvalue
			}
		}
	}

handle_Device:

	/* handler: uj.Device type=mesos.Device_Number kind=struct quoted=false*/

	{
		if tok == fflib.FFTok_null {

			uj.Device = nil

			state = fflib.FFParse_after_value
			goto mainparse
		}

		if uj.Device == nil {
			uj.Device = new(Device_Number)
		}

		err = uj.Device.UnmarshalJSONFFLexer(fs, fflib.FFParse_want_key)
		if err != nil {
			return err
		}
		state = fflib.FFParse_after_value
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_IOServiced:

	/* handler: uj.IOServiced type=[]mesos.CgroupInfo_Blkio_Value kind=slice quoted=false*/

	{

		{
			if tok != fflib.FFTok_left_brace && tok != fflib.FFTok_null {
				return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for ", tok))
			}
		}

		if tok == fflib.FFTok_null {
			uj.IOServiced = nil
		} else {

			uj.IOServiced = []CgroupInfo_Blkio_Value{}

			wantVal := true

			for {

				var tmp_uj__IOServiced CgroupInfo_Blkio_Value

				tok = fs.Scan()
				if tok == fflib.FFTok_error {
					goto tokerror
				}
				if tok == fflib.FFTok_right_brace {
					break
				}

				if tok == fflib.FFTok_comma {
					if wantVal == true {
						// TODO(pquerna): this isn't an ideal error message, this handles
						// things like [,,,] as an array value.
						return fs.WrapErr(fmt.Errorf("wanted value token, but got token: %v", tok))
					}
					continue
				} else {
					wantVal = true
				}

				/* handler: tmp_uj__IOServiced type=mesos.CgroupInfo_Blkio_Value kind=struct quoted=false*/

				{
					if tok == fflib.FFTok_null {

						state = fflib.FFParse_after_value
						goto mainparse
					}

					err = tmp_uj__IOServiced.UnmarshalJSONFFLexer(fs, fflib.FFParse_want_key)
					if err != nil {
						return err
					}
					state = fflib.FFParse_after_value
				}

				uj.IOServiced = append(uj.IOServiced, tmp_uj__IOServiced)

				wantVal = false
			}
		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_IOServiceBytes:

	/* handler: uj.IOServiceBytes type=[]mesos.CgroupInfo_Blkio_Value kind=slice quoted=false*/

	{

		{
			if tok != fflib.FFTok_left_brace && tok != fflib.FFTok_null {
				return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for ", tok))
			}
		}

		if tok == fflib.FFTok_null {
			uj.IOServiceBytes = nil
		} else {

			uj.IOServiceBytes = []CgroupInfo_Blkio_Value{}

			wantVal := true

			for {

				var tmp_uj__IOServiceBytes CgroupInfo_Blkio_Value

				tok = fs.Scan()
				if tok == fflib.FFTok_error {
					goto tokerror
				}
				if tok == fflib.FFTok_right_brace {
					break
				}

				if tok == fflib.FFTok_comma {
					if wantVal == true {
						// TODO(pquerna): this isn't an ideal error message, this handles
						// things like [,,,] as an array value.
						return fs.WrapErr(fmt.Errorf("wanted value token, but got token: %v", tok))
					}
					continue
				} else {
					wantVal = true
				}

				/* handler: tmp_uj__IOServiceBytes type=mesos.CgroupInfo_Blkio_Value kind=struct quoted=false*/

				{
					if tok == fflib.FFTok_null {

						state = fflib.FFParse_after_value
						goto mainparse
					}

					err = tmp_uj__IOServiceBytes.UnmarshalJSONFFLexer(fs, fflib.FFParse_want_key)
					if err != nil {
						return err
					}
					state = fflib.FFParse_after_value
				}

				uj.IOServiceBytes = append(uj.IOServiceBytes, tmp_uj__IOServiceBytes)

				wantVal = false
			}
		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

wantedvalue:
	return fs.WrapErr(fmt.Errorf("wanted value token, but got token: %v", tok))
wrongtokenerror:
	return fs.WrapErr(fmt.Errorf("ffjson: wanted token: %v, but got token: %v output=%s", wantedTok, tok, fs.Output.String()))
tokerror:
	if fs.BigError != nil {
		return fs.WrapErr(fs.BigError)
	}
	err = fs.Error.ToError()
	if err != nil {
		return fs.WrapErr(err)
	}
	panic("ffjson-generated: unreachable, please report bug.")
done:

	return nil
}

func (mj *CgroupInfo_Blkio_Value) MarshalJSON() ([]byte, error) {
	var buf fflib.Buffer
	if mj == nil {
		buf.WriteString("null")
		return buf.Bytes(), nil
	}
	err := mj.MarshalJSONBuf(&buf)
	if err != nil {
		return nil, err
	}
	return buf.Bytes(), nil
}
func (mj *CgroupInfo_Blkio_Value) MarshalJSONBuf(buf fflib.EncodingBuffer) error {
	if mj == nil {
		buf.WriteString("null")
		return nil
	}
	var err error
	var obj []byte
	_ = obj
	_ = err
	buf.WriteString(`{ `)
	if mj.Op != nil {
		if true {
			buf.WriteString(`"op":`)

			{

				obj, err = mj.Op.MarshalJSON()
				if err != nil {
					return err
				}
				buf.Write(obj)

			}
			buf.WriteByte(',')
		}
	}
	if mj.Value != nil {
		if true {
			buf.WriteString(`"value":`)
			fflib.FormatBits2(buf, uint64(*mj.Value), 10, false)
			buf.WriteByte(',')
		}
	}
	buf.Rewind(1)
	buf.WriteByte('}')
	return nil
}

const (
	ffj_t_CgroupInfo_Blkio_Valuebase = iota
	ffj_t_CgroupInfo_Blkio_Valueno_such_key

	ffj_t_CgroupInfo_Blkio_Value_Op

	ffj_t_CgroupInfo_Blkio_Value_Value
)

var ffj_key_CgroupInfo_Blkio_Value_Op = []byte("op")

var ffj_key_CgroupInfo_Blkio_Value_Value = []byte("value")

func (uj *CgroupInfo_Blkio_Value) UnmarshalJSON(input []byte) error {
	fs := fflib.NewFFLexer(input)
	return uj.UnmarshalJSONFFLexer(fs, fflib.FFParse_map_start)
}

func (uj *CgroupInfo_Blkio_Value) UnmarshalJSONFFLexer(fs *fflib.FFLexer, state fflib.FFParseState) error {
	var err error = nil
	currentKey := ffj_t_CgroupInfo_Blkio_Valuebase
	_ = currentKey
	tok := fflib.FFTok_init
	wantedTok := fflib.FFTok_init

mainparse:
	for {
		tok = fs.Scan()
		//	println(fmt.Sprintf("debug: tok: %v  state: %v", tok, state))
		if tok == fflib.FFTok_error {
			goto tokerror
		}

		switch state {

		case fflib.FFParse_map_start:
			if tok != fflib.FFTok_left_bracket {
				wantedTok = fflib.FFTok_left_bracket
				goto wrongtokenerror
			}
			state = fflib.FFParse_want_key
			continue

		case fflib.FFParse_after_value:
			if tok == fflib.FFTok_comma {
				state = fflib.FFParse_want_key
			} else if tok == fflib.FFTok_right_bracket {
				goto done
			} else {
				wantedTok = fflib.FFTok_comma
				goto wrongtokenerror
			}

		case fflib.FFParse_want_key:
			// json {} ended. goto exit. woo.
			if tok == fflib.FFTok_right_bracket {
				goto done
			}
			if tok != fflib.FFTok_string {
				wantedTok = fflib.FFTok_string
				goto wrongtokenerror
			}

			kn := fs.Output.Bytes()
			if len(kn) <= 0 {
				// "" case. hrm.
				currentKey = ffj_t_CgroupInfo_Blkio_Valueno_such_key
				state = fflib.FFParse_want_colon
				goto mainparse
			} else {
				switch kn[0] {

				case 'o':

					if bytes.Equal(ffj_key_CgroupInfo_Blkio_Value_Op, kn) {
						currentKey = ffj_t_CgroupInfo_Blkio_Value_Op
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				case 'v':

					if bytes.Equal(ffj_key_CgroupInfo_Blkio_Value_Value, kn) {
						currentKey = ffj_t_CgroupInfo_Blkio_Value_Value
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				}

				if fflib.SimpleLetterEqualFold(ffj_key_CgroupInfo_Blkio_Value_Value, kn) {
					currentKey = ffj_t_CgroupInfo_Blkio_Value_Value
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.SimpleLetterEqualFold(ffj_key_CgroupInfo_Blkio_Value_Op, kn) {
					currentKey = ffj_t_CgroupInfo_Blkio_Value_Op
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				currentKey = ffj_t_CgroupInfo_Blkio_Valueno_such_key
				state = fflib.FFParse_want_colon
				goto mainparse
			}

		case fflib.FFParse_want_colon:
			if tok != fflib.FFTok_colon {
				wantedTok = fflib.FFTok_colon
				goto wrongtokenerror
			}
			state = fflib.FFParse_want_value
			continue
		case fflib.FFParse_want_value:

			if tok == fflib.FFTok_left_brace || tok == fflib.FFTok_left_bracket || tok == fflib.FFTok_integer || tok == fflib.FFTok_double || tok == fflib.FFTok_string || tok == fflib.FFTok_bool || tok == fflib.FFTok_null {
				switch currentKey {

				case ffj_t_CgroupInfo_Blkio_Value_Op:
					goto handle_Op

				case ffj_t_CgroupInfo_Blkio_Value_Value:
					goto handle_Value

				case ffj_t_CgroupInfo_Blkio_Valueno_such_key:
					err = fs.SkipField(tok)
					if err != nil {
						return fs.WrapErr(err)
					}
					state = fflib.FFParse_after_value
					goto mainparse
				}
			} else {
				goto wantedvalue
			}
		}
	}

handle_Op:

	/* handler: uj.Op type=mesos.CgroupInfo_Blkio_Operation kind=int32 quoted=false*/

	{
		if tok == fflib.FFTok_null {

			uj.Op = nil

			state = fflib.FFParse_after_value
			goto mainparse
		}

		tbuf, err := fs.CaptureField(tok)
		if err != nil {
			return fs.WrapErr(err)
		}

		if uj.Op == nil {
			uj.Op = new(CgroupInfo_Blkio_Operation)
		}

		err = uj.Op.UnmarshalJSON(tbuf)
		if err != nil {
			return fs.WrapErr(err)
		}
		state = fflib.FFParse_after_value
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_Value:

	/* handler: uj.Value type=uint64 kind=uint64 quoted=false*/

	{
		if tok != fflib.FFTok_integer && tok != fflib.FFTok_null {
			return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for uint64", tok))
		}
	}

	{

		if tok == fflib.FFTok_null {

			uj.Value = nil

		} else {

			tval, err := fflib.ParseUint(fs.Output.Bytes(), 10, 64)

			if err != nil {
				return fs.WrapErr(err)
			}

			ttypval := uint64(tval)
			uj.Value = &ttypval

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

wantedvalue:
	return fs.WrapErr(fmt.Errorf("wanted value token, but got token: %v", tok))
wrongtokenerror:
	return fs.WrapErr(fmt.Errorf("ffjson: wanted token: %v, but got token: %v output=%s", wantedTok, tok, fs.Output.String()))
tokerror:
	if fs.BigError != nil {
		return fs.WrapErr(fs.BigError)
	}
	err = fs.Error.ToError()
	if err != nil {
		return fs.WrapErr(err)
	}
	panic("ffjson-generated: unreachable, please report bug.")
done:

	return nil
}

func (mj *CgroupInfo_NetCls) MarshalJSON() ([]byte, error) {
	var buf fflib.Buffer
	if mj == nil {
		buf.WriteString("null")
		return buf.Bytes(), nil
	}
	err := mj.MarshalJSONBuf(&buf)
	if err != nil {
		return nil, err
	}
	return buf.Bytes(), nil
}
func (mj *CgroupInfo_NetCls) MarshalJSONBuf(buf fflib.EncodingBuffer) error {
	if mj == nil {
		buf.WriteString("null")
		return nil
	}
	var err error
	var obj []byte
	_ = obj
	_ = err
	buf.WriteString(`{ `)
	if mj.ClassID != nil {
		if true {
			buf.WriteString(`"classid":`)
			fflib.FormatBits2(buf, uint64(*mj.ClassID), 10, false)
			buf.WriteByte(',')
		}
	}
	buf.Rewind(1)
	buf.WriteByte('}')
	return nil
}

const (
	ffj_t_CgroupInfo_NetClsbase = iota
	ffj_t_CgroupInfo_NetClsno_such_key

	ffj_t_CgroupInfo_NetCls_ClassID
)

var ffj_key_CgroupInfo_NetCls_ClassID = []byte("classid")

func (uj *CgroupInfo_NetCls) UnmarshalJSON(input []byte) error {
	fs := fflib.NewFFLexer(input)
	return uj.UnmarshalJSONFFLexer(fs, fflib.FFParse_map_start)
}

func (uj *CgroupInfo_NetCls) UnmarshalJSONFFLexer(fs *fflib.FFLexer, state fflib.FFParseState) error {
	var err error = nil
	currentKey := ffj_t_CgroupInfo_NetClsbase
	_ = currentKey
	tok := fflib.FFTok_init
	wantedTok := fflib.FFTok_init

mainparse:
	for {
		tok = fs.Scan()
		//	println(fmt.Sprintf("debug: tok: %v  state: %v", tok, state))
		if tok == fflib.FFTok_error {
			goto tokerror
		}

		switch state {

		case fflib.FFParse_map_start:
			if tok != fflib.FFTok_left_bracket {
				wantedTok = fflib.FFTok_left_bracket
				goto wrongtokenerror
			}
			state = fflib.FFParse_want_key
			continue

		case fflib.FFParse_after_value:
			if tok == fflib.FFTok_comma {
				state = fflib.FFParse_want_key
			} else if tok == fflib.FFTok_right_bracket {
				goto done
			} else {
				wantedTok = fflib.FFTok_comma
				goto wrongtokenerror
			}

		case fflib.FFParse_want_key:
			// json {} ended. goto exit. woo.
			if tok == fflib.FFTok_right_bracket {
				goto done
			}
			if tok != fflib.FFTok_string {
				wantedTok = fflib.FFTok_string
				goto wrongtokenerror
			}

			kn := fs.Output.Bytes()
			if len(kn) <= 0 {
				// "" case. hrm.
				currentKey = ffj_t_CgroupInfo_NetClsno_such_key
				state = fflib.FFParse_want_colon
				goto mainparse
			} else {
				switch kn[0] {

				case 'c':

					if bytes.Equal(ffj_key_CgroupInfo_NetCls_ClassID, kn) {
						currentKey = ffj_t_CgroupInfo_NetCls_ClassID
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				}

				if fflib.EqualFoldRight(ffj_key_CgroupInfo_NetCls_ClassID, kn) {
					currentKey = ffj_t_CgroupInfo_NetCls_ClassID
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				currentKey = ffj_t_CgroupInfo_NetClsno_such_key
				state = fflib.FFParse_want_colon
				goto mainparse
			}

		case fflib.FFParse_want_colon:
			if tok != fflib.FFTok_colon {
				wantedTok = fflib.FFTok_colon
				goto wrongtokenerror
			}
			state = fflib.FFParse_want_value
			continue
		case fflib.FFParse_want_value:

			if tok == fflib.FFTok_left_brace || tok == fflib.FFTok_left_bracket || tok == fflib.FFTok_integer || tok == fflib.FFTok_double || tok == fflib.FFTok_string || tok == fflib.FFTok_bool || tok == fflib.FFTok_null {
				switch currentKey {

				case ffj_t_CgroupInfo_NetCls_ClassID:
					goto handle_ClassID

				case ffj_t_CgroupInfo_NetClsno_such_key:
					err = fs.SkipField(tok)
					if err != nil {
						return fs.WrapErr(err)
					}
					state = fflib.FFParse_after_value
					goto mainparse
				}
			} else {
				goto wantedvalue
			}
		}
	}

handle_ClassID:

	/* handler: uj.ClassID type=uint32 kind=uint32 quoted=false*/

	{
		if tok != fflib.FFTok_integer && tok != fflib.FFTok_null {
			return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for uint32", tok))
		}
	}

	{

		if tok == fflib.FFTok_null {

			uj.ClassID = nil

		} else {

			tval, err := fflib.ParseUint(fs.Output.Bytes(), 10, 32)

			if err != nil {
				return fs.WrapErr(err)
			}

			ttypval := uint32(tval)
			uj.ClassID = &ttypval

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

wantedvalue:
	return fs.WrapErr(fmt.Errorf("wanted value token, but got token: %v", tok))
wrongtokenerror:
	return fs.WrapErr(fmt.Errorf("ffjson: wanted token: %v, but got token: %v output=%s", wantedTok, tok, fs.Output.String()))
tokerror:
	if fs.BigError != nil {
		return fs.WrapErr(fs.BigError)
	}
	err = fs.Error.ToError()
	if err != nil {
		return fs.WrapErr(err)
	}
	panic("ffjson-generated: unreachable, please report bug.")
done:

	return nil
}

func (mj *CheckInfo) MarshalJSON() ([]byte, error) {
	var buf fflib.Buffer
	if mj == nil {
		buf.WriteString("null")
		return buf.Bytes(), nil
	}
	err := mj.MarshalJSONBuf(&buf)
	if err != nil {
		return nil, err
	}
	return buf.Bytes(), nil
}
func (mj *CheckInfo) MarshalJSONBuf(buf fflib.EncodingBuffer) error {
	if mj == nil {
		buf.WriteString("null")
		return nil
	}
	var err error
	var obj []byte
	_ = obj
	_ = err
	buf.WriteString(`{ "type":`)

	{

		obj, err = mj.Type.MarshalJSON()
		if err != nil {
			return err
		}
		buf.Write(obj)

	}
	buf.WriteByte(',')
	if mj.Command != nil {
		if true {
			buf.WriteString(`"command":`)

			{

				err = mj.Command.MarshalJSONBuf(buf)
				if err != nil {
					return err
				}

			}
			buf.WriteByte(',')
		}
	}
	if mj.HTTP != nil {
		if true {
			buf.WriteString(`"http":`)

			{

				err = mj.HTTP.MarshalJSONBuf(buf)
				if err != nil {
					return err
				}

			}
			buf.WriteByte(',')
		}
	}
	if mj.TCP != nil {
		if true {
			buf.WriteString(`"tcp":`)

			{

				err = mj.TCP.MarshalJSONBuf(buf)
				if err != nil {
					return err
				}

			}
			buf.WriteByte(',')
		}
	}
	if mj.DelaySeconds != nil {
		if true {
			buf.WriteString(`"delay_seconds":`)
			fflib.AppendFloat(buf, float64(*mj.DelaySeconds), 'g', -1, 64)
			buf.WriteByte(',')
		}
	}
	if mj.IntervalSeconds != nil {
		if true {
			buf.WriteString(`"interval_seconds":`)
			fflib.AppendFloat(buf, float64(*mj.IntervalSeconds), 'g', -1, 64)
			buf.WriteByte(',')
		}
	}
	if mj.TimeoutSeconds != nil {
		if true {
			buf.WriteString(`"timeout_seconds":`)
			fflib.AppendFloat(buf, float64(*mj.TimeoutSeconds), 'g', -1, 64)
			buf.WriteByte(',')
		}
	}
	buf.Rewind(1)
	buf.WriteByte('}')
	return nil
}

const (
	ffj_t_CheckInfobase = iota
	ffj_t_CheckInfono_such_key

	ffj_t_CheckInfo_Type

	ffj_t_CheckInfo_Command

	ffj_t_CheckInfo_HTTP

	ffj_t_CheckInfo_TCP

	ffj_t_CheckInfo_DelaySeconds

	ffj_t_CheckInfo_IntervalSeconds

	ffj_t_CheckInfo_TimeoutSeconds
)

var ffj_key_CheckInfo_Type = []byte("type")

var ffj_key_CheckInfo_Command = []byte("command")

var ffj_key_CheckInfo_HTTP = []byte("http")

var ffj_key_CheckInfo_TCP = []byte("tcp")

var ffj_key_CheckInfo_DelaySeconds = []byte("delay_seconds")

var ffj_key_CheckInfo_IntervalSeconds = []byte("interval_seconds")

var ffj_key_CheckInfo_TimeoutSeconds = []byte("timeout_seconds")

func (uj *CheckInfo) UnmarshalJSON(input []byte) error {
	fs := fflib.NewFFLexer(input)
	return uj.UnmarshalJSONFFLexer(fs, fflib.FFParse_map_start)
}

func (uj *CheckInfo) UnmarshalJSONFFLexer(fs *fflib.FFLexer, state fflib.FFParseState) error {
	var err error = nil
	currentKey := ffj_t_CheckInfobase
	_ = currentKey
	tok := fflib.FFTok_init
	wantedTok := fflib.FFTok_init

mainparse:
	for {
		tok = fs.Scan()
		//	println(fmt.Sprintf("debug: tok: %v  state: %v", tok, state))
		if tok == fflib.FFTok_error {
			goto tokerror
		}

		switch state {

		case fflib.FFParse_map_start:
			if tok != fflib.FFTok_left_bracket {
				wantedTok = fflib.FFTok_left_bracket
				goto wrongtokenerror
			}
			state = fflib.FFParse_want_key
			continue

		case fflib.FFParse_after_value:
			if tok == fflib.FFTok_comma {
				state = fflib.FFParse_want_key
			} else if tok == fflib.FFTok_right_bracket {
				goto done
			} else {
				wantedTok = fflib.FFTok_comma
				goto wrongtokenerror
			}

		case fflib.FFParse_want_key:
			// json {} ended. goto exit. woo.
			if tok == fflib.FFTok_right_bracket {
				goto done
			}
			if tok != fflib.FFTok_string {
				wantedTok = fflib.FFTok_string
				goto wrongtokenerror
			}

			kn := fs.Output.Bytes()
			if len(kn) <= 0 {
				// "" case. hrm.
				currentKey = ffj_t_CheckInfono_such_key
				state = fflib.FFParse_want_colon
				goto mainparse
			} else {
				switch kn[0] {

				case 'c':

					if bytes.Equal(ffj_key_CheckInfo_Command, kn) {
						currentKey = ffj_t_CheckInfo_Command
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				case 'd':

					if bytes.Equal(ffj_key_CheckInfo_DelaySeconds, kn) {
						currentKey = ffj_t_CheckInfo_DelaySeconds
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				case 'h':

					if bytes.Equal(ffj_key_CheckInfo_HTTP, kn) {
						currentKey = ffj_t_CheckInfo_HTTP
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				case 'i':

					if bytes.Equal(ffj_key_CheckInfo_IntervalSeconds, kn) {
						currentKey = ffj_t_CheckInfo_IntervalSeconds
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				case 't':

					if bytes.Equal(ffj_key_CheckInfo_Type, kn) {
						currentKey = ffj_t_CheckInfo_Type
						state = fflib.FFParse_want_colon
						goto mainparse

					} else if bytes.Equal(ffj_key_CheckInfo_TCP, kn) {
						currentKey = ffj_t_CheckInfo_TCP
						state = fflib.FFParse_want_colon
						goto mainparse

					} else if bytes.Equal(ffj_key_CheckInfo_TimeoutSeconds, kn) {
						currentKey = ffj_t_CheckInfo_TimeoutSeconds
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				}

				if fflib.EqualFoldRight(ffj_key_CheckInfo_TimeoutSeconds, kn) {
					currentKey = ffj_t_CheckInfo_TimeoutSeconds
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffj_key_CheckInfo_IntervalSeconds, kn) {
					currentKey = ffj_t_CheckInfo_IntervalSeconds
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffj_key_CheckInfo_DelaySeconds, kn) {
					currentKey = ffj_t_CheckInfo_DelaySeconds
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.SimpleLetterEqualFold(ffj_key_CheckInfo_TCP, kn) {
					currentKey = ffj_t_CheckInfo_TCP
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.SimpleLetterEqualFold(ffj_key_CheckInfo_HTTP, kn) {
					currentKey = ffj_t_CheckInfo_HTTP
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.SimpleLetterEqualFold(ffj_key_CheckInfo_Command, kn) {
					currentKey = ffj_t_CheckInfo_Command
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.SimpleLetterEqualFold(ffj_key_CheckInfo_Type, kn) {
					currentKey = ffj_t_CheckInfo_Type
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				currentKey = ffj_t_CheckInfono_such_key
				state = fflib.FFParse_want_colon
				goto mainparse
			}

		case fflib.FFParse_want_colon:
			if tok != fflib.FFTok_colon {
				wantedTok = fflib.FFTok_colon
				goto wrongtokenerror
			}
			state = fflib.FFParse_want_value
			continue
		case fflib.FFParse_want_value:

			if tok == fflib.FFTok_left_brace || tok == fflib.FFTok_left_bracket || tok == fflib.FFTok_integer || tok == fflib.FFTok_double || tok == fflib.FFTok_string || tok == fflib.FFTok_bool || tok == fflib.FFTok_null {
				switch currentKey {

				case ffj_t_CheckInfo_Type:
					goto handle_Type

				case ffj_t_CheckInfo_Command:
					goto handle_Command

				case ffj_t_CheckInfo_HTTP:
					goto handle_HTTP

				case ffj_t_CheckInfo_TCP:
					goto handle_TCP

				case ffj_t_CheckInfo_DelaySeconds:
					goto handle_DelaySeconds

				case ffj_t_CheckInfo_IntervalSeconds:
					goto handle_IntervalSeconds

				case ffj_t_CheckInfo_TimeoutSeconds:
					goto handle_TimeoutSeconds

				case ffj_t_CheckInfono_such_key:
					err = fs.SkipField(tok)
					if err != nil {
						return fs.WrapErr(err)
					}
					state = fflib.FFParse_after_value
					goto mainparse
				}
			} else {
				goto wantedvalue
			}
		}
	}

handle_Type:

	/* handler: uj.Type type=mesos.CheckInfo_Type kind=int32 quoted=false*/

	{
		if tok == fflib.FFTok_null {

			state = fflib.FFParse_after_value
			goto mainparse
		}

		tbuf, err := fs.CaptureField(tok)
		if err != nil {
			return fs.WrapErr(err)
		}

		err = uj.Type.UnmarshalJSON(tbuf)
		if err != nil {
			return fs.WrapErr(err)
		}
		state = fflib.FFParse_after_value
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_Command:

	/* handler: uj.Command type=mesos.CheckInfo_Command kind=struct quoted=false*/

	{
		if tok == fflib.FFTok_null {

			uj.Command = nil

			state = fflib.FFParse_after_value
			goto mainparse
		}

		if uj.Command == nil {
			uj.Command = new(CheckInfo_Command)
		}

		err = uj.Command.UnmarshalJSONFFLexer(fs, fflib.FFParse_want_key)
		if err != nil {
			return err
		}
		state = fflib.FFParse_after_value
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_HTTP:

	/* handler: uj.HTTP type=mesos.CheckInfo_Http kind=struct quoted=false*/

	{
		if tok == fflib.FFTok_null {

			uj.HTTP = nil

			state = fflib.FFParse_after_value
			goto mainparse
		}

		if uj.HTTP == nil {
			uj.HTTP = new(CheckInfo_Http)
		}

		err = uj.HTTP.UnmarshalJSONFFLexer(fs, fflib.FFParse_want_key)
		if err != nil {
			return err
		}
		state = fflib.FFParse_after_value
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_TCP:

	/* handler: uj.TCP type=mesos.CheckInfo_Tcp kind=struct quoted=false*/

	{
		if tok == fflib.FFTok_null {

			uj.TCP = nil

			state = fflib.FFParse_after_value
			goto mainparse
		}

		if uj.TCP == nil {
			uj.TCP = new(CheckInfo_Tcp)
		}

		err = uj.TCP.UnmarshalJSONFFLexer(fs, fflib.FFParse_want_key)
		if err != nil {
			return err
		}
		state = fflib.FFParse_after_value
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_DelaySeconds:

	/* handler: uj.DelaySeconds type=float64 kind=float64 quoted=false*/

	{
		if tok != fflib.FFTok_double && tok != fflib.FFTok_integer && tok != fflib.FFTok_null {
			return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for float64", tok))
		}
	}

	{

		if tok == fflib.FFTok_null {

			uj.DelaySeconds = nil

		} else {

			tval, err := fflib.ParseFloat(fs.Output.Bytes(), 64)

			if err != nil {
				return fs.WrapErr(err)
			}

			ttypval := float64(tval)
			uj.DelaySeconds = &ttypval

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_IntervalSeconds:

	/* handler: uj.IntervalSeconds type=float64 kind=float64 quoted=false*/

	{
		if tok != fflib.FFTok_double && tok != fflib.FFTok_integer && tok != fflib.FFTok_null {
			return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for float64", tok))
		}
	}

	{

		if tok == fflib.FFTok_null {

			uj.IntervalSeconds = nil

		} else {

			tval, err := fflib.ParseFloat(fs.Output.Bytes(), 64)

			if err != nil {
				return fs.WrapErr(err)
			}

			ttypval := float64(tval)
			uj.IntervalSeconds = &ttypval

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_TimeoutSeconds:

	/* handler: uj.TimeoutSeconds type=float64 kind=float64 quoted=false*/

	{
		if tok != fflib.FFTok_double && tok != fflib.FFTok_integer && tok != fflib.FFTok_null {
			return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for float64", tok))
		}
	}

	{

		if tok == fflib.FFTok_null {

			uj.TimeoutSeconds = nil

		} else {

			tval, err := fflib.ParseFloat(fs.Output.Bytes(), 64)

			if err != nil {
				return fs.WrapErr(err)
			}

			ttypval := float64(tval)
			uj.TimeoutSeconds = &ttypval

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

wantedvalue:
	return fs.WrapErr(fmt.Errorf("wanted value token, but got token: %v", tok))
wrongtokenerror:
	return fs.WrapErr(fmt.Errorf("ffjson: wanted token: %v, but got token: %v output=%s", wantedTok, tok, fs.Output.String()))
tokerror:
	if fs.BigError != nil {
		return fs.WrapErr(fs.BigError)
	}
	err = fs.Error.ToError()
	if err != nil {
		return fs.WrapErr(err)
	}
	panic("ffjson-generated: unreachable, please report bug.")
done:

	return nil
}

func (mj *CheckInfo_Command) MarshalJSON() ([]byte, error) {
	var buf fflib.Buffer
	if mj == nil {
		buf.WriteString("null")
		return buf.Bytes(), nil
	}
	err := mj.MarshalJSONBuf(&buf)
	if err != nil {
		return nil, err
	}
	return buf.Bytes(), nil
}
func (mj *CheckInfo_Command) MarshalJSONBuf(buf fflib.EncodingBuffer) error {
	if mj == nil {
		buf.WriteString("null")
		return nil
	}
	var err error
	var obj []byte
	_ = obj
	_ = err
	buf.WriteString(`{"command":`)

	{

		err = mj.Command.MarshalJSONBuf(buf)
		if err != nil {
			return err
		}

	}
	buf.WriteByte('}')
	return nil
}

const (
	ffj_t_CheckInfo_Commandbase = iota
	ffj_t_CheckInfo_Commandno_such_key

	ffj_t_CheckInfo_Command_Command
)

var ffj_key_CheckInfo_Command_Command = []byte("command")

func (uj *CheckInfo_Command) UnmarshalJSON(input []byte) error {
	fs := fflib.NewFFLexer(input)
	return uj.UnmarshalJSONFFLexer(fs, fflib.FFParse_map_start)
}

func (uj *CheckInfo_Command) UnmarshalJSONFFLexer(fs *fflib.FFLexer, state fflib.FFParseState) error {
	var err error = nil
	currentKey := ffj_t_CheckInfo_Commandbase
	_ = currentKey
	tok := fflib.FFTok_init
	wantedTok := fflib.FFTok_init

mainparse:
	for {
		tok = fs.Scan()
		//	println(fmt.Sprintf("debug: tok: %v  state: %v", tok, state))
		if tok == fflib.FFTok_error {
			goto tokerror
		}

		switch state {

		case fflib.FFParse_map_start:
			if tok != fflib.FFTok_left_bracket {
				wantedTok = fflib.FFTok_left_bracket
				goto wrongtokenerror
			}
			state = fflib.FFParse_want_key
			continue

		case fflib.FFParse_after_value:
			if tok == fflib.FFTok_comma {
				state = fflib.FFParse_want_key
			} else if tok == fflib.FFTok_right_bracket {
				goto done
			} else {
				wantedTok = fflib.FFTok_comma
				goto wrongtokenerror
			}

		case fflib.FFParse_want_key:
			// json {} ended. goto exit. woo.
			if tok == fflib.FFTok_right_bracket {
				goto done
			}
			if tok != fflib.FFTok_string {
				wantedTok = fflib.FFTok_string
				goto wrongtokenerror
			}

			kn := fs.Output.Bytes()
			if len(kn) <= 0 {
				// "" case. hrm.
				currentKey = ffj_t_CheckInfo_Commandno_such_key
				state = fflib.FFParse_want_colon
				goto mainparse
			} else {
				switch kn[0] {

				case 'c':

					if bytes.Equal(ffj_key_CheckInfo_Command_Command, kn) {
						currentKey = ffj_t_CheckInfo_Command_Command
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				}

				if fflib.SimpleLetterEqualFold(ffj_key_CheckInfo_Command_Command, kn) {
					currentKey = ffj_t_CheckInfo_Command_Command
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				currentKey = ffj_t_CheckInfo_Commandno_such_key
				state = fflib.FFParse_want_colon
				goto mainparse
			}

		case fflib.FFParse_want_colon:
			if tok != fflib.FFTok_colon {
				wantedTok = fflib.FFTok_colon
				goto wrongtokenerror
			}
			state = fflib.FFParse_want_value
			continue
		case fflib.FFParse_want_value:

			if tok == fflib.FFTok_left_brace || tok == fflib.FFTok_left_bracket || tok == fflib.FFTok_integer || tok == fflib.FFTok_double || tok == fflib.FFTok_string || tok == fflib.FFTok_bool || tok == fflib.FFTok_null {
				switch currentKey {

				case ffj_t_CheckInfo_Command_Command:
					goto handle_Command

				case ffj_t_CheckInfo_Commandno_such_key:
					err = fs.SkipField(tok)
					if err != nil {
						return fs.WrapErr(err)
					}
					state = fflib.FFParse_after_value
					goto mainparse
				}
			} else {
				goto wantedvalue
			}
		}
	}

handle_Command:

	/* handler: uj.Command type=mesos.CommandInfo kind=struct quoted=false*/

	{
		if tok == fflib.FFTok_null {

			state = fflib.FFParse_after_value
			goto mainparse
		}

		err = uj.Command.UnmarshalJSONFFLexer(fs, fflib.FFParse_want_key)
		if err != nil {
			return err
		}
		state = fflib.FFParse_after_value
	}

	state = fflib.FFParse_after_value
	goto mainparse

wantedvalue:
	return fs.WrapErr(fmt.Errorf("wanted value token, but got token: %v", tok))
wrongtokenerror:
	return fs.WrapErr(fmt.Errorf("ffjson: wanted token: %v, but got token: %v output=%s", wantedTok, tok, fs.Output.String()))
tokerror:
	if fs.BigError != nil {
		return fs.WrapErr(fs.BigError)
	}
	err = fs.Error.ToError()
	if err != nil {
		return fs.WrapErr(err)
	}
	panic("ffjson-generated: unreachable, please report bug.")
done:

	return nil
}

func (mj *CheckInfo_Http) MarshalJSON() ([]byte, error) {
	var buf fflib.Buffer
	if mj == nil {
		buf.WriteString("null")
		return buf.Bytes(), nil
	}
	err := mj.MarshalJSONBuf(&buf)
	if err != nil {
		return nil, err
	}
	return buf.Bytes(), nil
}
func (mj *CheckInfo_Http) MarshalJSONBuf(buf fflib.EncodingBuffer) error {
	if mj == nil {
		buf.WriteString("null")
		return nil
	}
	var err error
	var obj []byte
	_ = obj
	_ = err
	buf.WriteString(`{ "port":`)
	fflib.FormatBits2(buf, uint64(mj.Port), 10, false)
	buf.WriteByte(',')
	if mj.Path != nil {
		if true {
			buf.WriteString(`"path":`)
			fflib.WriteJsonString(buf, string(*mj.Path))
			buf.WriteByte(',')
		}
	}
	buf.Rewind(1)
	buf.WriteByte('}')
	return nil
}

const (
	ffj_t_CheckInfo_Httpbase = iota
	ffj_t_CheckInfo_Httpno_such_key

	ffj_t_CheckInfo_Http_Port

	ffj_t_CheckInfo_Http_Path
)

var ffj_key_CheckInfo_Http_Port = []byte("port")

var ffj_key_CheckInfo_Http_Path = []byte("path")

func (uj *CheckInfo_Http) UnmarshalJSON(input []byte) error {
	fs := fflib.NewFFLexer(input)
	return uj.UnmarshalJSONFFLexer(fs, fflib.FFParse_map_start)
}

func (uj *CheckInfo_Http) UnmarshalJSONFFLexer(fs *fflib.FFLexer, state fflib.FFParseState) error {
	var err error = nil
	currentKey := ffj_t_CheckInfo_Httpbase
	_ = currentKey
	tok := fflib.FFTok_init
	wantedTok := fflib.FFTok_init

mainparse:
	for {
		tok = fs.Scan()
		//	println(fmt.Sprintf("debug: tok: %v  state: %v", tok, state))
		if tok == fflib.FFTok_error {
			goto tokerror
		}

		switch state {

		case fflib.FFParse_map_start:
			if tok != fflib.FFTok_left_bracket {
				wantedTok = fflib.FFTok_left_bracket
				goto wrongtokenerror
			}
			state = fflib.FFParse_want_key
			continue

		case fflib.FFParse_after_value:
			if tok == fflib.FFTok_comma {
				state = fflib.FFParse_want_key
			} else if tok == fflib.FFTok_right_bracket {
				goto done
			} else {
				wantedTok = fflib.FFTok_comma
				goto wrongtokenerror
			}

		case fflib.FFParse_want_key:
			// json {} ended. goto exit. woo.
			if tok == fflib.FFTok_right_bracket {
				goto done
			}
			if tok != fflib.FFTok_string {
				wantedTok = fflib.FFTok_string
				goto wrongtokenerror
			}

			kn := fs.Output.Bytes()
			if len(kn) <= 0 {
				// "" case. hrm.
				currentKey = ffj_t_CheckInfo_Httpno_such_key
				state = fflib.FFParse_want_colon
				goto mainparse
			} else {
				switch kn[0] {

				case 'p':

					if bytes.Equal(ffj_key_CheckInfo_Http_Port, kn) {
						currentKey = ffj_t_CheckInfo_Http_Port
						state = fflib.FFParse_want_colon
						goto mainparse

					} else if bytes.Equal(ffj_key_CheckInfo_Http_Path, kn) {
						currentKey = ffj_t_CheckInfo_Http_Path
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				}

				if fflib.SimpleLetterEqualFold(ffj_key_CheckInfo_Http_Path, kn) {
					currentKey = ffj_t_CheckInfo_Http_Path
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.SimpleLetterEqualFold(ffj_key_CheckInfo_Http_Port, kn) {
					currentKey = ffj_t_CheckInfo_Http_Port
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				currentKey = ffj_t_CheckInfo_Httpno_such_key
				state = fflib.FFParse_want_colon
				goto mainparse
			}

		case fflib.FFParse_want_colon:
			if tok != fflib.FFTok_colon {
				wantedTok = fflib.FFTok_colon
				goto wrongtokenerror
			}
			state = fflib.FFParse_want_value
			continue
		case fflib.FFParse_want_value:

			if tok == fflib.FFTok_left_brace || tok == fflib.FFTok_left_bracket || tok == fflib.FFTok_integer || tok == fflib.FFTok_double || tok == fflib.FFTok_string || tok == fflib.FFTok_bool || tok == fflib.FFTok_null {
				switch currentKey {

				case ffj_t_CheckInfo_Http_Port:
					goto handle_Port

				case ffj_t_CheckInfo_Http_Path:
					goto handle_Path

				case ffj_t_CheckInfo_Httpno_such_key:
					err = fs.SkipField(tok)
					if err != nil {
						return fs.WrapErr(err)
					}
					state = fflib.FFParse_after_value
					goto mainparse
				}
			} else {
				goto wantedvalue
			}
		}
	}

handle_Port:

	/* handler: uj.Port type=uint32 kind=uint32 quoted=false*/

	{
		if tok != fflib.FFTok_integer && tok != fflib.FFTok_null {
			return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for uint32", tok))
		}
	}

	{

		if tok == fflib.FFTok_null {

		} else {

			tval, err := fflib.ParseUint(fs.Output.Bytes(), 10, 32)

			if err != nil {
				return fs.WrapErr(err)
			}

			uj.Port = uint32(tval)

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_Path:

	/* handler: uj.Path type=string kind=string quoted=false*/

	{

		{
			if tok != fflib.FFTok_string && tok != fflib.FFTok_null {
				return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for string", tok))
			}
		}

		if tok == fflib.FFTok_null {

			uj.Path = nil

		} else {

			var tval string
			outBuf := fs.Output.Bytes()

			tval = string(string(outBuf))
			uj.Path = &tval

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

wantedvalue:
	return fs.WrapErr(fmt.Errorf("wanted value token, but got token: %v", tok))
wrongtokenerror:
	return fs.WrapErr(fmt.Errorf("ffjson: wanted token: %v, but got token: %v output=%s", wantedTok, tok, fs.Output.String()))
tokerror:
	if fs.BigError != nil {
		return fs.WrapErr(fs.BigError)
	}
	err = fs.Error.ToError()
	if err != nil {
		return fs.WrapErr(err)
	}
	panic("ffjson-generated: unreachable, please report bug.")
done:

	return nil
}

func (mj *CheckInfo_Tcp) MarshalJSON() ([]byte, error) {
	var buf fflib.Buffer
	if mj == nil {
		buf.WriteString("null")
		return buf.Bytes(), nil
	}
	err := mj.MarshalJSONBuf(&buf)
	if err != nil {
		return nil, err
	}
	return buf.Bytes(), nil
}
func (mj *CheckInfo_Tcp) MarshalJSONBuf(buf fflib.EncodingBuffer) error {
	if mj == nil {
		buf.WriteString("null")
		return nil
	}
	var err error
	var obj []byte
	_ = obj
	_ = err
	buf.WriteString(`{"port":`)
	fflib.FormatBits2(buf, uint64(mj.Port), 10, false)
	buf.WriteByte('}')
	return nil
}

const (
	ffj_t_CheckInfo_Tcpbase = iota
	ffj_t_CheckInfo_Tcpno_such_key

	ffj_t_CheckInfo_Tcp_Port
)

var ffj_key_CheckInfo_Tcp_Port = []byte("port")

func (uj *CheckInfo_Tcp) UnmarshalJSON(input []byte) error {
	fs := fflib.NewFFLexer(input)
	return uj.UnmarshalJSONFFLexer(fs, fflib.FFParse_map_start)
}

func (uj *CheckInfo_Tcp) UnmarshalJSONFFLexer(fs *fflib.FFLexer, state fflib.FFParseState) error {
	var err error = nil
	currentKey := ffj_t_CheckInfo_Tcpbase
	_ = currentKey
	tok := fflib.FFTok_init
	wantedTok := fflib.FFTok_init

mainparse:
	for {
		tok = fs.Scan()
		//	println(fmt.Sprintf("debug: tok: %v  state: %v", tok, state))
		if tok == fflib.FFTok_error {
			goto tokerror
		}

		switch state {

		case fflib.FFParse_map_start:
			if tok != fflib.FFTok_left_bracket {
				wantedTok = fflib.FFTok_left_bracket
				goto wrongtokenerror
			}
			state = fflib.FFParse_want_key
			continue

		case fflib.FFParse_after_value:
			if tok == fflib.FFTok_comma {
				state = fflib.FFParse_want_key
			} else if tok == fflib.FFTok_right_bracket {
				goto done
			} else {
				wantedTok = fflib.FFTok_comma
				goto wrongtokenerror
			}

		case fflib.FFParse_want_key:
			// json {} ended. goto exit. woo.
			if tok == fflib.FFTok_right_bracket {
				goto done
			}
			if tok != fflib.FFTok_string {
				wantedTok = fflib.FFTok_string
				goto wrongtokenerror
			}

			kn := fs.Output.Bytes()
			if len(kn) <= 0 {
				// "" case. hrm.
				currentKey = ffj_t_CheckInfo_Tcpno_such_key
				state = fflib.FFParse_want_colon
				goto mainparse
			} else {
				switch kn[0] {

				case 'p':

					if bytes.Equal(ffj_key_CheckInfo_Tcp_Port, kn) {
						currentKey = ffj_t_CheckInfo_Tcp_Port
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				}

				if fflib.SimpleLetterEqualFold(ffj_key_CheckInfo_Tcp_Port, kn) {
					currentKey = ffj_t_CheckInfo_Tcp_Port
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				currentKey = ffj_t_CheckInfo_Tcpno_such_key
				state = fflib.FFParse_want_colon
				goto mainparse
			}

		case fflib.FFParse_want_colon:
			if tok != fflib.FFTok_colon {
				wantedTok = fflib.FFTok_colon
				goto wrongtokenerror
			}
			state = fflib.FFParse_want_value
			continue
		case fflib.FFParse_want_value:

			if tok == fflib.FFTok_left_brace || tok == fflib.FFTok_left_bracket || tok == fflib.FFTok_integer || tok == fflib.FFTok_double || tok == fflib.FFTok_string || tok == fflib.FFTok_bool || tok == fflib.FFTok_null {
				switch currentKey {

				case ffj_t_CheckInfo_Tcp_Port:
					goto handle_Port

				case ffj_t_CheckInfo_Tcpno_such_key:
					err = fs.SkipField(tok)
					if err != nil {
						return fs.WrapErr(err)
					}
					state = fflib.FFParse_after_value
					goto mainparse
				}
			} else {
				goto wantedvalue
			}
		}
	}

handle_Port:

	/* handler: uj.Port type=uint32 kind=uint32 quoted=false*/

	{
		if tok != fflib.FFTok_integer && tok != fflib.FFTok_null {
			return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for uint32", tok))
		}
	}

	{

		if tok == fflib.FFTok_null {

		} else {

			tval, err := fflib.ParseUint(fs.Output.Bytes(), 10, 32)

			if err != nil {
				return fs.WrapErr(err)
			}

			uj.Port = uint32(tval)

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

wantedvalue:
	return fs.WrapErr(fmt.Errorf("wanted value token, but got token: %v", tok))
wrongtokenerror:
	return fs.WrapErr(fmt.Errorf("ffjson: wanted token: %v, but got token: %v output=%s", wantedTok, tok, fs.Output.String()))
tokerror:
	if fs.BigError != nil {
		return fs.WrapErr(fs.BigError)
	}
	err = fs.Error.ToError()
	if err != nil {
		return fs.WrapErr(err)
	}
	panic("ffjson-generated: unreachable, please report bug.")
done:

	return nil
}

func (mj *CheckStatusInfo) MarshalJSON() ([]byte, error) {
	var buf fflib.Buffer
	if mj == nil {
		buf.WriteString("null")
		return buf.Bytes(), nil
	}
	err := mj.MarshalJSONBuf(&buf)
	if err != nil {
		return nil, err
	}
	return buf.Bytes(), nil
}
func (mj *CheckStatusInfo) MarshalJSONBuf(buf fflib.EncodingBuffer) error {
	if mj == nil {
		buf.WriteString("null")
		return nil
	}
	var err error
	var obj []byte
	_ = obj
	_ = err
	buf.WriteString(`{ `)
	if mj.Type != nil {
		if true {
			buf.WriteString(`"type":`)

			{

				obj, err = mj.Type.MarshalJSON()
				if err != nil {
					return err
				}
				buf.Write(obj)

			}
			buf.WriteByte(',')
		}
	}
	if mj.Command != nil {
		if true {
			buf.WriteString(`"command":`)

			{

				err = mj.Command.MarshalJSONBuf(buf)
				if err != nil {
					return err
				}

			}
			buf.WriteByte(',')
		}
	}
	if mj.HTTP != nil {
		if true {
			buf.WriteString(`"http":`)

			{

				err = mj.HTTP.MarshalJSONBuf(buf)
				if err != nil {
					return err
				}

			}
			buf.WriteByte(',')
		}
	}
	if mj.TCP != nil {
		if true {
			buf.WriteString(`"tcp":`)

			{

				err = mj.TCP.MarshalJSONBuf(buf)
				if err != nil {
					return err
				}

			}
			buf.WriteByte(',')
		}
	}
	buf.Rewind(1)
	buf.WriteByte('}')
	return nil
}

const (
	ffj_t_CheckStatusInfobase = iota
	ffj_t_CheckStatusInfono_such_key

	ffj_t_CheckStatusInfo_Type

	ffj_t_CheckStatusInfo_Command

	ffj_t_CheckStatusInfo_HTTP

	ffj_t_CheckStatusInfo_TCP
)

var ffj_key_CheckStatusInfo_Type = []byte("type")

var ffj_key_CheckStatusInfo_Command = []byte("command")

var ffj_key_CheckStatusInfo_HTTP = []byte("http")

var ffj_key_CheckStatusInfo_TCP = []byte("tcp")

func (uj *CheckStatusInfo) UnmarshalJSON(input []byte) error {
	fs := fflib.NewFFLexer(input)
	return uj.UnmarshalJSONFFLexer(fs, fflib.FFParse_map_start)
}

func (uj *CheckStatusInfo) UnmarshalJSONFFLexer(fs *fflib.FFLexer, state fflib.FFParseState) error {
	var err error = nil
	currentKey := ffj_t_CheckStatusInfobase
	_ = currentKey
	tok := fflib.FFTok_init
	wantedTok := fflib.FFTok_init

mainparse:
	for {
		tok = fs.Scan()
		//	println(fmt.Sprintf("debug: tok: %v  state: %v", tok, state))
		if tok == fflib.FFTok_error {
			goto tokerror
		}

		switch state {

		case fflib.FFParse_map_start:
			if tok != fflib.FFTok_left_bracket {
				wantedTok = fflib.FFTok_left_bracket
				goto wrongtokenerror
			}
			state = fflib.FFParse_want_key
			continue

		case fflib.FFParse_after_value:
			if tok == fflib.FFTok_comma {
				state = fflib.FFParse_want_key
			} else if tok == fflib.FFTok_right_bracket {
				goto done
			} else {
				wantedTok = fflib.FFTok_comma
				goto wrongtokenerror
			}

		case fflib.FFParse_want_key:
			// json {} ended. goto exit. woo.
			if tok == fflib.FFTok_right_bracket {
				goto done
			}
			if tok != fflib.FFTok_string {
				wantedTok = fflib.FFTok_string
				goto wrongtokenerror
			}

			kn := fs.Output.Bytes()
			if len(kn) <= 0 {
				// "" case. hrm.
				currentKey = ffj_t_CheckStatusInfono_such_key
				state = fflib.FFParse_want_colon
				goto mainparse
			} else {
				switch kn[0] {

				case 'c':

					if bytes.Equal(ffj_key_CheckStatusInfo_Command, kn) {
						currentKey = ffj_t_CheckStatusInfo_Command
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				case 'h':

					if bytes.Equal(ffj_key_CheckStatusInfo_HTTP, kn) {
						currentKey = ffj_t_CheckStatusInfo_HTTP
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				case 't':

					if bytes.Equal(ffj_key_CheckStatusInfo_Type, kn) {
						currentKey = ffj_t_CheckStatusInfo_Type
						state = fflib.FFParse_want_colon
						goto mainparse

					} else if bytes.Equal(ffj_key_CheckStatusInfo_TCP, kn) {
						currentKey = ffj_t_CheckStatusInfo_TCP
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				}

				if fflib.SimpleLetterEqualFold(ffj_key_CheckStatusInfo_TCP, kn) {
					currentKey = ffj_t_CheckStatusInfo_TCP
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.SimpleLetterEqualFold(ffj_key_CheckStatusInfo_HTTP, kn) {
					currentKey = ffj_t_CheckStatusInfo_HTTP
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.SimpleLetterEqualFold(ffj_key_CheckStatusInfo_Command, kn) {
					currentKey = ffj_t_CheckStatusInfo_Command
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.SimpleLetterEqualFold(ffj_key_CheckStatusInfo_Type, kn) {
					currentKey = ffj_t_CheckStatusInfo_Type
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				currentKey = ffj_t_CheckStatusInfono_such_key
				state = fflib.FFParse_want_colon
				goto mainparse
			}

		case fflib.FFParse_want_colon:
			if tok != fflib.FFTok_colon {
				wantedTok = fflib.FFTok_colon
				goto wrongtokenerror
			}
			state = fflib.FFParse_want_value
			continue
		case fflib.FFParse_want_value:

			if tok == fflib.FFTok_left_brace || tok == fflib.FFTok_left_bracket || tok == fflib.FFTok_integer || tok == fflib.FFTok_double || tok == fflib.FFTok_string || tok == fflib.FFTok_bool || tok == fflib.FFTok_null {
				switch currentKey {

				case ffj_t_CheckStatusInfo_Type:
					goto handle_Type

				case ffj_t_CheckStatusInfo_Command:
					goto handle_Command

				case ffj_t_CheckStatusInfo_HTTP:
					goto handle_HTTP

				case ffj_t_CheckStatusInfo_TCP:
					goto handle_TCP

				case ffj_t_CheckStatusInfono_such_key:
					err = fs.SkipField(tok)
					if err != nil {
						return fs.WrapErr(err)
					}
					state = fflib.FFParse_after_value
					goto mainparse
				}
			} else {
				goto wantedvalue
			}
		}
	}

handle_Type:

	/* handler: uj.Type type=mesos.CheckInfo_Type kind=int32 quoted=false*/

	{
		if tok == fflib.FFTok_null {

			uj.Type = nil

			state = fflib.FFParse_after_value
			goto mainparse
		}

		tbuf, err := fs.CaptureField(tok)
		if err != nil {
			return fs.WrapErr(err)
		}

		if uj.Type == nil {
			uj.Type = new(CheckInfo_Type)
		}

		err = uj.Type.UnmarshalJSON(tbuf)
		if err != nil {
			return fs.WrapErr(err)
		}
		state = fflib.FFParse_after_value
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_Command:

	/* handler: uj.Command type=mesos.CheckStatusInfo_Command kind=struct quoted=false*/

	{
		if tok == fflib.FFTok_null {

			uj.Command = nil

			state = fflib.FFParse_after_value
			goto mainparse
		}

		if uj.Command == nil {
			uj.Command = new(CheckStatusInfo_Command)
		}

		err = uj.Command.UnmarshalJSONFFLexer(fs, fflib.FFParse_want_key)
		if err != nil {
			return err
		}
		state = fflib.FFParse_after_value
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_HTTP:

	/* handler: uj.HTTP type=mesos.CheckStatusInfo_Http kind=struct quoted=false*/

	{
		if tok == fflib.FFTok_null {

			uj.HTTP = nil

			state = fflib.FFParse_after_value
			goto mainparse
		}

		if uj.HTTP == nil {
			uj.HTTP = new(CheckStatusInfo_Http)
		}

		err = uj.HTTP.UnmarshalJSONFFLexer(fs, fflib.FFParse_want_key)
		if err != nil {
			return err
		}
		state = fflib.FFParse_after_value
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_TCP:

	/* handler: uj.TCP type=mesos.CheckStatusInfo_Tcp kind=struct quoted=false*/

	{
		if tok == fflib.FFTok_null {

			uj.TCP = nil

			state = fflib.FFParse_after_value
			goto mainparse
		}

		if uj.TCP == nil {
			uj.TCP = new(CheckStatusInfo_Tcp)
		}

		err = uj.TCP.UnmarshalJSONFFLexer(fs, fflib.FFParse_want_key)
		if err != nil {
			return err
		}
		state = fflib.FFParse_after_value
	}

	state = fflib.FFParse_after_value
	goto mainparse

wantedvalue:
	return fs.WrapErr(fmt.Errorf("wanted value token, but got token: %v", tok))
wrongtokenerror:
	return fs.WrapErr(fmt.Errorf("ffjson: wanted token: %v, but got token: %v output=%s", wantedTok, tok, fs.Output.String()))
tokerror:
	if fs.BigError != nil {
		return fs.WrapErr(fs.BigError)
	}
	err = fs.Error.ToError()
	if err != nil {
		return fs.WrapErr(err)
	}
	panic("ffjson-generated: unreachable, please report bug.")
done:

	return nil
}

func (mj *CheckStatusInfo_Command) MarshalJSON() ([]byte, error) {
	var buf fflib.Buffer
	if mj == nil {
		buf.WriteString("null")
		return buf.Bytes(), nil
	}
	err := mj.MarshalJSONBuf(&buf)
	if err != nil {
		return nil, err
	}
	return buf.Bytes(), nil
}
func (mj *CheckStatusInfo_Command) MarshalJSONBuf(buf fflib.EncodingBuffer) error {
	if mj == nil {
		buf.WriteString("null")
		return nil
	}
	var err error
	var obj []byte
	_ = obj
	_ = err
	buf.WriteString(`{ `)
	if mj.ExitCode != nil {
		if true {
			buf.WriteString(`"exit_code":`)
			fflib.FormatBits2(buf, uint64(*mj.ExitCode), 10, *mj.ExitCode < 0)
			buf.WriteByte(',')
		}
	}
	buf.Rewind(1)
	buf.WriteByte('}')
	return nil
}

const (
	ffj_t_CheckStatusInfo_Commandbase = iota
	ffj_t_CheckStatusInfo_Commandno_such_key

	ffj_t_CheckStatusInfo_Command_ExitCode
)

var ffj_key_CheckStatusInfo_Command_ExitCode = []byte("exit_code")

func (uj *CheckStatusInfo_Command) UnmarshalJSON(input []byte) error {
	fs := fflib.NewFFLexer(input)
	return uj.UnmarshalJSONFFLexer(fs, fflib.FFParse_map_start)
}

func (uj *CheckStatusInfo_Command) UnmarshalJSONFFLexer(fs *fflib.FFLexer, state fflib.FFParseState) error {
	var err error = nil
	currentKey := ffj_t_CheckStatusInfo_Commandbase
	_ = currentKey
	tok := fflib.FFTok_init
	wantedTok := fflib.FFTok_init

mainparse:
	for {
		tok = fs.Scan()
		//	println(fmt.Sprintf("debug: tok: %v  state: %v", tok, state))
		if tok == fflib.FFTok_error {
			goto tokerror
		}

		switch state {

		case fflib.FFParse_map_start:
			if tok != fflib.FFTok_left_bracket {
				wantedTok = fflib.FFTok_left_bracket
				goto wrongtokenerror
			}
			state = fflib.FFParse_want_key
			continue

		case fflib.FFParse_after_value:
			if tok == fflib.FFTok_comma {
				state = fflib.FFParse_want_key
			} else if tok == fflib.FFTok_right_bracket {
				goto done
			} else {
				wantedTok = fflib.FFTok_comma
				goto wrongtokenerror
			}

		case fflib.FFParse_want_key:
			// json {} ended. goto exit. woo.
			if tok == fflib.FFTok_right_bracket {
				goto done
			}
			if tok != fflib.FFTok_string {
				wantedTok = fflib.FFTok_string
				goto wrongtokenerror
			}

			kn := fs.Output.Bytes()
			if len(kn) <= 0 {
				// "" case. hrm.
				currentKey = ffj_t_CheckStatusInfo_Commandno_such_key
				state = fflib.FFParse_want_colon
				goto mainparse
			} else {
				switch kn[0] {

				case 'e':

					if bytes.Equal(ffj_key_CheckStatusInfo_Command_ExitCode, kn) {
						currentKey = ffj_t_CheckStatusInfo_Command_ExitCode
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				}

				if fflib.AsciiEqualFold(ffj_key_CheckStatusInfo_Command_ExitCode, kn) {
					currentKey = ffj_t_CheckStatusInfo_Command_ExitCode
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				currentKey = ffj_t_CheckStatusInfo_Commandno_such_key
				state = fflib.FFParse_want_colon
				goto mainparse
			}

		case fflib.FFParse_want_colon:
			if tok != fflib.FFTok_colon {
				wantedTok = fflib.FFTok_colon
				goto wrongtokenerror
			}
			state = fflib.FFParse_want_value
			continue
		case fflib.FFParse_want_value:

			if tok == fflib.FFTok_left_brace || tok == fflib.FFTok_left_bracket || tok == fflib.FFTok_integer || tok == fflib.FFTok_double || tok == fflib.FFTok_string || tok == fflib.FFTok_bool || tok == fflib.FFTok_null {
				switch currentKey {

				case ffj_t_CheckStatusInfo_Command_ExitCode:
					goto handle_ExitCode

				case ffj_t_CheckStatusInfo_Commandno_such_key:
					err = fs.SkipField(tok)
					if err != nil {
						return fs.WrapErr(err)
					}
					state = fflib.FFParse_after_value
					goto mainparse
				}
			} else {
				goto wantedvalue
			}
		}
	}

handle_ExitCode:

	/* handler: uj.ExitCode type=int32 kind=int32 quoted=false*/

	{
		if tok != fflib.FFTok_integer && tok != fflib.FFTok_null {
			return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for int32", tok))
		}
	}

	{

		if tok == fflib.FFTok_null {

			uj.ExitCode = nil

		} else {

			tval, err := fflib.ParseInt(fs.Output.Bytes(), 10, 32)

			if err != nil {
				return fs.WrapErr(err)
			}

			ttypval := int32(tval)
			uj.ExitCode = &ttypval

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

wantedvalue:
	return fs.WrapErr(fmt.Errorf("wanted value token, but got token: %v", tok))
wrongtokenerror:
	return fs.WrapErr(fmt.Errorf("ffjson: wanted token: %v, but got token: %v output=%s", wantedTok, tok, fs.Output.String()))
tokerror:
	if fs.BigError != nil {
		return fs.WrapErr(fs.BigError)
	}
	err = fs.Error.ToError()
	if err != nil {
		return fs.WrapErr(err)
	}
	panic("ffjson-generated: unreachable, please report bug.")
done:

	return nil
}

func (mj *CheckStatusInfo_Http) MarshalJSON() ([]byte, error) {
	var buf fflib.Buffer
	if mj == nil {
		buf.WriteString("null")
		return buf.Bytes(), nil
	}
	err := mj.MarshalJSONBuf(&buf)
	if err != nil {
		return nil, err
	}
	return buf.Bytes(), nil
}
func (mj *CheckStatusInfo_Http) MarshalJSONBuf(buf fflib.EncodingBuffer) error {
	if mj == nil {
		buf.WriteString("null")
		return nil
	}
	var err error
	var obj []byte
	_ = obj
	_ = err
	buf.WriteString(`{ `)
	if mj.StatusCode != nil {
		if true {
			buf.WriteString(`"status_code":`)
			fflib.FormatBits2(buf, uint64(*mj.StatusCode), 10, false)
			buf.WriteByte(',')
		}
	}
	buf.Rewind(1)
	buf.WriteByte('}')
	return nil
}

const (
	ffj_t_CheckStatusInfo_Httpbase = iota
	ffj_t_CheckStatusInfo_Httpno_such_key

	ffj_t_CheckStatusInfo_Http_StatusCode
)

var ffj_key_CheckStatusInfo_Http_StatusCode = []byte("status_code")

func (uj *CheckStatusInfo_Http) UnmarshalJSON(input []byte) error {
	fs := fflib.NewFFLexer(input)
	return uj.UnmarshalJSONFFLexer(fs, fflib.FFParse_map_start)
}

func (uj *CheckStatusInfo_Http) UnmarshalJSONFFLexer(fs *fflib.FFLexer, state fflib.FFParseState) error {
	var err error = nil
	currentKey := ffj_t_CheckStatusInfo_Httpbase
	_ = currentKey
	tok := fflib.FFTok_init
	wantedTok := fflib.FFTok_init

mainparse:
	for {
		tok = fs.Scan()
		//	println(fmt.Sprintf("debug: tok: %v  state: %v", tok, state))
		if tok == fflib.FFTok_error {
			goto tokerror
		}

		switch state {

		case fflib.FFParse_map_start:
			if tok != fflib.FFTok_left_bracket {
				wantedTok = fflib.FFTok_left_bracket
				goto wrongtokenerror
			}
			state = fflib.FFParse_want_key
			continue

		case fflib.FFParse_after_value:
			if tok == fflib.FFTok_comma {
				state = fflib.FFParse_want_key
			} else if tok == fflib.FFTok_right_bracket {
				goto done
			} else {
				wantedTok = fflib.FFTok_comma
				goto wrongtokenerror
			}

		case fflib.FFParse_want_key:
			// json {} ended. goto exit. woo.
			if tok == fflib.FFTok_right_bracket {
				goto done
			}
			if tok != fflib.FFTok_string {
				wantedTok = fflib.FFTok_string
				goto wrongtokenerror
			}

			kn := fs.Output.Bytes()
			if len(kn) <= 0 {
				// "" case. hrm.
				currentKey = ffj_t_CheckStatusInfo_Httpno_such_key
				state = fflib.FFParse_want_colon
				goto mainparse
			} else {
				switch kn[0] {

				case 's':

					if bytes.Equal(ffj_key_CheckStatusInfo_Http_StatusCode, kn) {
						currentKey = ffj_t_CheckStatusInfo_Http_StatusCode
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				}

				if fflib.EqualFoldRight(ffj_key_CheckStatusInfo_Http_StatusCode, kn) {
					currentKey = ffj_t_CheckStatusInfo_Http_StatusCode
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				currentKey = ffj_t_CheckStatusInfo_Httpno_such_key
				state = fflib.FFParse_want_colon
				goto mainparse
			}

		case fflib.FFParse_want_colon:
			if tok != fflib.FFTok_colon {
				wantedTok = fflib.FFTok_colon
				goto wrongtokenerror
			}
			state = fflib.FFParse_want_value
			continue
		case fflib.FFParse_want_value:

			if tok == fflib.FFTok_left_brace || tok == fflib.FFTok_left_bracket || tok == fflib.FFTok_integer || tok == fflib.FFTok_double || tok == fflib.FFTok_string || tok == fflib.FFTok_bool || tok == fflib.FFTok_null {
				switch currentKey {

				case ffj_t_CheckStatusInfo_Http_StatusCode:
					goto handle_StatusCode

				case ffj_t_CheckStatusInfo_Httpno_such_key:
					err = fs.SkipField(tok)
					if err != nil {
						return fs.WrapErr(err)
					}
					state = fflib.FFParse_after_value
					goto mainparse
				}
			} else {
				goto wantedvalue
			}
		}
	}

handle_StatusCode:

	/* handler: uj.StatusCode type=uint32 kind=uint32 quoted=false*/

	{
		if tok != fflib.FFTok_integer && tok != fflib.FFTok_null {
			return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for uint32", tok))
		}
	}

	{

		if tok == fflib.FFTok_null {

			uj.StatusCode = nil

		} else {

			tval, err := fflib.ParseUint(fs.Output.Bytes(), 10, 32)

			if err != nil {
				return fs.WrapErr(err)
			}

			ttypval := uint32(tval)
			uj.StatusCode = &ttypval

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

wantedvalue:
	return fs.WrapErr(fmt.Errorf("wanted value token, but got token: %v", tok))
wrongtokenerror:
	return fs.WrapErr(fmt.Errorf("ffjson: wanted token: %v, but got token: %v output=%s", wantedTok, tok, fs.Output.String()))
tokerror:
	if fs.BigError != nil {
		return fs.WrapErr(fs.BigError)
	}
	err = fs.Error.ToError()
	if err != nil {
		return fs.WrapErr(err)
	}
	panic("ffjson-generated: unreachable, please report bug.")
done:

	return nil
}

func (mj *CheckStatusInfo_Tcp) MarshalJSON() ([]byte, error) {
	var buf fflib.Buffer
	if mj == nil {
		buf.WriteString("null")
		return buf.Bytes(), nil
	}
	err := mj.MarshalJSONBuf(&buf)
	if err != nil {
		return nil, err
	}
	return buf.Bytes(), nil
}
func (mj *CheckStatusInfo_Tcp) MarshalJSONBuf(buf fflib.EncodingBuffer) error {
	if mj == nil {
		buf.WriteString("null")
		return nil
	}
	var err error
	var obj []byte
	_ = obj
	_ = err
	buf.WriteString(`{ `)
	if mj.Succeeded != nil {
		if true {
			if *mj.Succeeded {
				buf.WriteString(`"succeeded":true`)
			} else {
				buf.WriteString(`"succeeded":false`)
			}
			buf.WriteByte(',')
		}
	}
	buf.Rewind(1)
	buf.WriteByte('}')
	return nil
}

const (
	ffj_t_CheckStatusInfo_Tcpbase = iota
	ffj_t_CheckStatusInfo_Tcpno_such_key

	ffj_t_CheckStatusInfo_Tcp_Succeeded
)

var ffj_key_CheckStatusInfo_Tcp_Succeeded = []byte("succeeded")

func (uj *CheckStatusInfo_Tcp) UnmarshalJSON(input []byte) error {
	fs := fflib.NewFFLexer(input)
	return uj.UnmarshalJSONFFLexer(fs, fflib.FFParse_map_start)
}

func (uj *CheckStatusInfo_Tcp) UnmarshalJSONFFLexer(fs *fflib.FFLexer, state fflib.FFParseState) error {
	var err error = nil
	currentKey := ffj_t_CheckStatusInfo_Tcpbase
	_ = currentKey
	tok := fflib.FFTok_init
	wantedTok := fflib.FFTok_init

mainparse:
	for {
		tok = fs.Scan()
		//	println(fmt.Sprintf("debug: tok: %v  state: %v", tok, state))
		if tok == fflib.FFTok_error {
			goto tokerror
		}

		switch state {

		case fflib.FFParse_map_start:
			if tok != fflib.FFTok_left_bracket {
				wantedTok = fflib.FFTok_left_bracket
				goto wrongtokenerror
			}
			state = fflib.FFParse_want_key
			continue

		case fflib.FFParse_after_value:
			if tok == fflib.FFTok_comma {
				state = fflib.FFParse_want_key
			} else if tok == fflib.FFTok_right_bracket {
				goto done
			} else {
				wantedTok = fflib.FFTok_comma
				goto wrongtokenerror
			}

		case fflib.FFParse_want_key:
			// json {} ended. goto exit. woo.
			if tok == fflib.FFTok_right_bracket {
				goto done
			}
			if tok != fflib.FFTok_string {
				wantedTok = fflib.FFTok_string
				goto wrongtokenerror
			}

			kn := fs.Output.Bytes()
			if len(kn) <= 0 {
				// "" case. hrm.
				currentKey = ffj_t_CheckStatusInfo_Tcpno_such_key
				state = fflib.FFParse_want_colon
				goto mainparse
			} else {
				switch kn[0] {

				case 's':

					if bytes.Equal(ffj_key_CheckStatusInfo_Tcp_Succeeded, kn) {
						currentKey = ffj_t_CheckStatusInfo_Tcp_Succeeded
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				}

				if fflib.EqualFoldRight(ffj_key_CheckStatusInfo_Tcp_Succeeded, kn) {
					currentKey = ffj_t_CheckStatusInfo_Tcp_Succeeded
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				currentKey = ffj_t_CheckStatusInfo_Tcpno_such_key
				state = fflib.FFParse_want_colon
				goto mainparse
			}

		case fflib.FFParse_want_colon:
			if tok != fflib.FFTok_colon {
				wantedTok = fflib.FFTok_colon
				goto wrongtokenerror
			}
			state = fflib.FFParse_want_value
			continue
		case fflib.FFParse_want_value:

			if tok == fflib.FFTok_left_brace || tok == fflib.FFTok_left_bracket || tok == fflib.FFTok_integer || tok == fflib.FFTok_double || tok == fflib.FFTok_string || tok == fflib.FFTok_bool || tok == fflib.FFTok_null {
				switch currentKey {

				case ffj_t_CheckStatusInfo_Tcp_Succeeded:
					goto handle_Succeeded

				case ffj_t_CheckStatusInfo_Tcpno_such_key:
					err = fs.SkipField(tok)
					if err != nil {
						return fs.WrapErr(err)
					}
					state = fflib.FFParse_after_value
					goto mainparse
				}
			} else {
				goto wantedvalue
			}
		}
	}

handle_Succeeded:

	/* handler: uj.Succeeded type=bool kind=bool quoted=false*/

	{
		if tok != fflib.FFTok_bool && tok != fflib.FFTok_null {
			return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for bool", tok))
		}
	}

	{
		if tok == fflib.FFTok_null {

			uj.Succeeded = nil

		} else {
			tmpb := fs.Output.Bytes()

			var tval bool

			if bytes.Compare([]byte{'t', 'r', 'u', 'e'}, tmpb) == 0 {

				tval = true

			} else if bytes.Compare([]byte{'f', 'a', 'l', 's', 'e'}, tmpb) == 0 {

				tval = false

			} else {
				err = errors.New("unexpected bytes for true/false value")
				return fs.WrapErr(err)
			}

			uj.Succeeded = &tval

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

wantedvalue:
	return fs.WrapErr(fmt.Errorf("wanted value token, but got token: %v", tok))
wrongtokenerror:
	return fs.WrapErr(fmt.Errorf("ffjson: wanted token: %v, but got token: %v output=%s", wantedTok, tok, fs.Output.String()))
tokerror:
	if fs.BigError != nil {
		return fs.WrapErr(fs.BigError)
	}
	err = fs.Error.ToError()
	if err != nil {
		return fs.WrapErr(err)
	}
	panic("ffjson-generated: unreachable, please report bug.")
done:

	return nil
}

func (mj *CommandInfo) MarshalJSON() ([]byte, error) {
	var buf fflib.Buffer
	if mj == nil {
		buf.WriteString("null")
		return buf.Bytes(), nil
	}
	err := mj.MarshalJSONBuf(&buf)
	if err != nil {
		return nil, err
	}
	return buf.Bytes(), nil
}
func (mj *CommandInfo) MarshalJSONBuf(buf fflib.EncodingBuffer) error {
	if mj == nil {
		buf.WriteString("null")
		return nil
	}
	var err error
	var obj []byte
	_ = obj
	_ = err
	buf.WriteString(`{ "uris":`)
	if mj.URIs != nil {
		buf.WriteString(`[`)
		for i, v := range mj.URIs {
			if i != 0 {
				buf.WriteString(`,`)
			}

			{

				err = v.MarshalJSONBuf(buf)
				if err != nil {
					return err
				}

			}
		}
		buf.WriteString(`]`)
	} else {
		buf.WriteString(`null`)
	}
	buf.WriteByte(',')
	if mj.Environment != nil {
		if true {
			buf.WriteString(`"environment":`)

			{

				err = mj.Environment.MarshalJSONBuf(buf)
				if err != nil {
					return err
				}

			}
			buf.WriteByte(',')
		}
	}
	if mj.Shell != nil {
		if true {
			if *mj.Shell {
				buf.WriteString(`"shell":true`)
			} else {
				buf.WriteString(`"shell":false`)
			}
			buf.WriteByte(',')
		}
	}
	if mj.Value != nil {
		if true {
			buf.WriteString(`"value":`)
			fflib.WriteJsonString(buf, string(*mj.Value))
			buf.WriteByte(',')
		}
	}
	if len(mj.Arguments) != 0 {
		buf.WriteString(`"arguments":`)
		if mj.Arguments != nil {
			buf.WriteString(`[`)
			for i, v := range mj.Arguments {
				if i != 0 {
					buf.WriteString(`,`)
				}
				fflib.WriteJsonString(buf, string(v))
			}
			buf.WriteString(`]`)
		} else {
			buf.WriteString(`null`)
		}
		buf.WriteByte(',')
	}
	if mj.User != nil {
		if true {
			buf.WriteString(`"user":`)
			fflib.WriteJsonString(buf, string(*mj.User))
			buf.WriteByte(',')
		}
	}
	buf.Rewind(1)
	buf.WriteByte('}')
	return nil
}

const (
	ffj_t_CommandInfobase = iota
	ffj_t_CommandInfono_such_key

	ffj_t_CommandInfo_URIs

	ffj_t_CommandInfo_Environment

	ffj_t_CommandInfo_Shell

	ffj_t_CommandInfo_Value

	ffj_t_CommandInfo_Arguments

	ffj_t_CommandInfo_User
)

var ffj_key_CommandInfo_URIs = []byte("uris")

var ffj_key_CommandInfo_Environment = []byte("environment")

var ffj_key_CommandInfo_Shell = []byte("shell")

var ffj_key_CommandInfo_Value = []byte("value")

var ffj_key_CommandInfo_Arguments = []byte("arguments")

var ffj_key_CommandInfo_User = []byte("user")

func (uj *CommandInfo) UnmarshalJSON(input []byte) error {
	fs := fflib.NewFFLexer(input)
	return uj.UnmarshalJSONFFLexer(fs, fflib.FFParse_map_start)
}

func (uj *CommandInfo) UnmarshalJSONFFLexer(fs *fflib.FFLexer, state fflib.FFParseState) error {
	var err error = nil
	currentKey := ffj_t_CommandInfobase
	_ = currentKey
	tok := fflib.FFTok_init
	wantedTok := fflib.FFTok_init

mainparse:
	for {
		tok = fs.Scan()
		//	println(fmt.Sprintf("debug: tok: %v  state: %v", tok, state))
		if tok == fflib.FFTok_error {
			goto tokerror
		}

		switch state {

		case fflib.FFParse_map_start:
			if tok != fflib.FFTok_left_bracket {
				wantedTok = fflib.FFTok_left_bracket
				goto wrongtokenerror
			}
			state = fflib.FFParse_want_key
			continue

		case fflib.FFParse_after_value:
			if tok == fflib.FFTok_comma {
				state = fflib.FFParse_want_key
			} else if tok == fflib.FFTok_right_bracket {
				goto done
			} else {
				wantedTok = fflib.FFTok_comma
				goto wrongtokenerror
			}

		case fflib.FFParse_want_key:
			// json {} ended. goto exit. woo.
			if tok == fflib.FFTok_right_bracket {
				goto done
			}
			if tok != fflib.FFTok_string {
				wantedTok = fflib.FFTok_string
				goto wrongtokenerror
			}

			kn := fs.Output.Bytes()
			if len(kn) <= 0 {
				// "" case. hrm.
				currentKey = ffj_t_CommandInfono_such_key
				state = fflib.FFParse_want_colon
				goto mainparse
			} else {
				switch kn[0] {

				case 'a':

					if bytes.Equal(ffj_key_CommandInfo_Arguments, kn) {
						currentKey = ffj_t_CommandInfo_Arguments
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				case 'e':

					if bytes.Equal(ffj_key_CommandInfo_Environment, kn) {
						currentKey = ffj_t_CommandInfo_Environment
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				case 's':

					if bytes.Equal(ffj_key_CommandInfo_Shell, kn) {
						currentKey = ffj_t_CommandInfo_Shell
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				case 'u':

					if bytes.Equal(ffj_key_CommandInfo_URIs, kn) {
						currentKey = ffj_t_CommandInfo_URIs
						state = fflib.FFParse_want_colon
						goto mainparse

					} else if bytes.Equal(ffj_key_CommandInfo_User, kn) {
						currentKey = ffj_t_CommandInfo_User
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				case 'v':

					if bytes.Equal(ffj_key_CommandInfo_Value, kn) {
						currentKey = ffj_t_CommandInfo_Value
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				}

				if fflib.EqualFoldRight(ffj_key_CommandInfo_User, kn) {
					currentKey = ffj_t_CommandInfo_User
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffj_key_CommandInfo_Arguments, kn) {
					currentKey = ffj_t_CommandInfo_Arguments
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.SimpleLetterEqualFold(ffj_key_CommandInfo_Value, kn) {
					currentKey = ffj_t_CommandInfo_Value
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffj_key_CommandInfo_Shell, kn) {
					currentKey = ffj_t_CommandInfo_Shell
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.SimpleLetterEqualFold(ffj_key_CommandInfo_Environment, kn) {
					currentKey = ffj_t_CommandInfo_Environment
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffj_key_CommandInfo_URIs, kn) {
					currentKey = ffj_t_CommandInfo_URIs
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				currentKey = ffj_t_CommandInfono_such_key
				state = fflib.FFParse_want_colon
				goto mainparse
			}

		case fflib.FFParse_want_colon:
			if tok != fflib.FFTok_colon {
				wantedTok = fflib.FFTok_colon
				goto wrongtokenerror
			}
			state = fflib.FFParse_want_value
			continue
		case fflib.FFParse_want_value:

			if tok == fflib.FFTok_left_brace || tok == fflib.FFTok_left_bracket || tok == fflib.FFTok_integer || tok == fflib.FFTok_double || tok == fflib.FFTok_string || tok == fflib.FFTok_bool || tok == fflib.FFTok_null {
				switch currentKey {

				case ffj_t_CommandInfo_URIs:
					goto handle_URIs

				case ffj_t_CommandInfo_Environment:
					goto handle_Environment

				case ffj_t_CommandInfo_Shell:
					goto handle_Shell

				case ffj_t_CommandInfo_Value:
					goto handle_Value

				case ffj_t_CommandInfo_Arguments:
					goto handle_Arguments

				case ffj_t_CommandInfo_User:
					goto handle_User

				case ffj_t_CommandInfono_such_key:
					err = fs.SkipField(tok)
					if err != nil {
						return fs.WrapErr(err)
					}
					state = fflib.FFParse_after_value
					goto mainparse
				}
			} else {
				goto wantedvalue
			}
		}
	}

handle_URIs:

	/* handler: uj.URIs type=[]mesos.CommandInfo_URI kind=slice quoted=false*/

	{

		{
			if tok != fflib.FFTok_left_brace && tok != fflib.FFTok_null {
				return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for ", tok))
			}
		}

		if tok == fflib.FFTok_null {
			uj.URIs = nil
		} else {

			uj.URIs = []CommandInfo_URI{}

			wantVal := true

			for {

				var tmp_uj__URIs CommandInfo_URI

				tok = fs.Scan()
				if tok == fflib.FFTok_error {
					goto tokerror
				}
				if tok == fflib.FFTok_right_brace {
					break
				}

				if tok == fflib.FFTok_comma {
					if wantVal == true {
						// TODO(pquerna): this isn't an ideal error message, this handles
						// things like [,,,] as an array value.
						return fs.WrapErr(fmt.Errorf("wanted value token, but got token: %v", tok))
					}
					continue
				} else {
					wantVal = true
				}

				/* handler: tmp_uj__URIs type=mesos.CommandInfo_URI kind=struct quoted=false*/

				{
					if tok == fflib.FFTok_null {

						state = fflib.FFParse_after_value
						goto mainparse
					}

					err = tmp_uj__URIs.UnmarshalJSONFFLexer(fs, fflib.FFParse_want_key)
					if err != nil {
						return err
					}
					state = fflib.FFParse_after_value
				}

				uj.URIs = append(uj.URIs, tmp_uj__URIs)

				wantVal = false
			}
		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_Environment:

	/* handler: uj.Environment type=mesos.Environment kind=struct quoted=false*/

	{
		if tok == fflib.FFTok_null {

			uj.Environment = nil

			state = fflib.FFParse_after_value
			goto mainparse
		}

		if uj.Environment == nil {
			uj.Environment = new(Environment)
		}

		err = uj.Environment.UnmarshalJSONFFLexer(fs, fflib.FFParse_want_key)
		if err != nil {
			return err
		}
		state = fflib.FFParse_after_value
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_Shell:

	/* handler: uj.Shell type=bool kind=bool quoted=false*/

	{
		if tok != fflib.FFTok_bool && tok != fflib.FFTok_null {
			return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for bool", tok))
		}
	}

	{
		if tok == fflib.FFTok_null {

			uj.Shell = nil

		} else {
			tmpb := fs.Output.Bytes()

			var tval bool

			if bytes.Compare([]byte{'t', 'r', 'u', 'e'}, tmpb) == 0 {

				tval = true

			} else if bytes.Compare([]byte{'f', 'a', 'l', 's', 'e'}, tmpb) == 0 {

				tval = false

			} else {
				err = errors.New("unexpected bytes for true/false value")
				return fs.WrapErr(err)
			}

			uj.Shell = &tval

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_Value:

	/* handler: uj.Value type=string kind=string quoted=false*/

	{

		{
			if tok != fflib.FFTok_string && tok != fflib.FFTok_null {
				return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for string", tok))
			}
		}

		if tok == fflib.FFTok_null {

			uj.Value = nil

		} else {

			var tval string
			outBuf := fs.Output.Bytes()

			tval = string(string(outBuf))
			uj.Value = &tval

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_Arguments:

	/* handler: uj.Arguments type=[]string kind=slice quoted=false*/

	{

		{
			if tok != fflib.FFTok_left_brace && tok != fflib.FFTok_null {
				return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for ", tok))
			}
		}

		if tok == fflib.FFTok_null {
			uj.Arguments = nil
		} else {

			uj.Arguments = []string{}

			wantVal := true

			for {

				var tmp_uj__Arguments string

				tok = fs.Scan()
				if tok == fflib.FFTok_error {
					goto tokerror
				}
				if tok == fflib.FFTok_right_brace {
					break
				}

				if tok == fflib.FFTok_comma {
					if wantVal == true {
						// TODO(pquerna): this isn't an ideal error message, this handles
						// things like [,,,] as an array value.
						return fs.WrapErr(fmt.Errorf("wanted value token, but got token: %v", tok))
					}
					continue
				} else {
					wantVal = true
				}

				/* handler: tmp_uj__Arguments type=string kind=string quoted=false*/

				{

					{
						if tok != fflib.FFTok_string && tok != fflib.FFTok_null {
							return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for string", tok))
						}
					}

					if tok == fflib.FFTok_null {

					} else {

						outBuf := fs.Output.Bytes()

						tmp_uj__Arguments = string(string(outBuf))

					}
				}

				uj.Arguments = append(uj.Arguments, tmp_uj__Arguments)

				wantVal = false
			}
		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_User:

	/* handler: uj.User type=string kind=string quoted=false*/

	{

		{
			if tok != fflib.FFTok_string && tok != fflib.FFTok_null {
				return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for string", tok))
			}
		}

		if tok == fflib.FFTok_null {

			uj.User = nil

		} else {

			var tval string
			outBuf := fs.Output.Bytes()

			tval = string(string(outBuf))
			uj.User = &tval

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

wantedvalue:
	return fs.WrapErr(fmt.Errorf("wanted value token, but got token: %v", tok))
wrongtokenerror:
	return fs.WrapErr(fmt.Errorf("ffjson: wanted token: %v, but got token: %v output=%s", wantedTok, tok, fs.Output.String()))
tokerror:
	if fs.BigError != nil {
		return fs.WrapErr(fs.BigError)
	}
	err = fs.Error.ToError()
	if err != nil {
		return fs.WrapErr(err)
	}
	panic("ffjson-generated: unreachable, please report bug.")
done:

	return nil
}

func (mj *CommandInfo_URI) MarshalJSON() ([]byte, error) {
	var buf fflib.Buffer
	if mj == nil {
		buf.WriteString("null")
		return buf.Bytes(), nil
	}
	err := mj.MarshalJSONBuf(&buf)
	if err != nil {
		return nil, err
	}
	return buf.Bytes(), nil
}
func (mj *CommandInfo_URI) MarshalJSONBuf(buf fflib.EncodingBuffer) error {
	if mj == nil {
		buf.WriteString("null")
		return nil
	}
	var err error
	var obj []byte
	_ = obj
	_ = err
	buf.WriteString(`{ "value":`)
	fflib.WriteJsonString(buf, string(mj.Value))
	buf.WriteByte(',')
	if mj.Executable != nil {
		if true {
			if *mj.Executable {
				buf.WriteString(`"executable":true`)
			} else {
				buf.WriteString(`"executable":false`)
			}
			buf.WriteByte(',')
		}
	}
	if mj.Extract != nil {
		if true {
			if *mj.Extract {
				buf.WriteString(`"extract":true`)
			} else {
				buf.WriteString(`"extract":false`)
			}
			buf.WriteByte(',')
		}
	}
	if mj.Cache != nil {
		if true {
			if *mj.Cache {
				buf.WriteString(`"cache":true`)
			} else {
				buf.WriteString(`"cache":false`)
			}
			buf.WriteByte(',')
		}
	}
	if mj.OutputFile != nil {
		if true {
			buf.WriteString(`"output_file":`)
			fflib.WriteJsonString(buf, string(*mj.OutputFile))
			buf.WriteByte(',')
		}
	}
	buf.Rewind(1)
	buf.WriteByte('}')
	return nil
}

const (
	ffj_t_CommandInfo_URIbase = iota
	ffj_t_CommandInfo_URIno_such_key

	ffj_t_CommandInfo_URI_Value

	ffj_t_CommandInfo_URI_Executable

	ffj_t_CommandInfo_URI_Extract

	ffj_t_CommandInfo_URI_Cache

	ffj_t_CommandInfo_URI_OutputFile
)

var ffj_key_CommandInfo_URI_Value = []byte("value")

var ffj_key_CommandInfo_URI_Executable = []byte("executable")

var ffj_key_CommandInfo_URI_Extract = []byte("extract")

var ffj_key_CommandInfo_URI_Cache = []byte("cache")

var ffj_key_CommandInfo_URI_OutputFile = []byte("output_file")

func (uj *CommandInfo_URI) UnmarshalJSON(input []byte) error {
	fs := fflib.NewFFLexer(input)
	return uj.UnmarshalJSONFFLexer(fs, fflib.FFParse_map_start)
}

func (uj *CommandInfo_URI) UnmarshalJSONFFLexer(fs *fflib.FFLexer, state fflib.FFParseState) error {
	var err error = nil
	currentKey := ffj_t_CommandInfo_URIbase
	_ = currentKey
	tok := fflib.FFTok_init
	wantedTok := fflib.FFTok_init

mainparse:
	for {
		tok = fs.Scan()
		//	println(fmt.Sprintf("debug: tok: %v  state: %v", tok, state))
		if tok == fflib.FFTok_error {
			goto tokerror
		}

		switch state {

		case fflib.FFParse_map_start:
			if tok != fflib.FFTok_left_bracket {
				wantedTok = fflib.FFTok_left_bracket
				goto wrongtokenerror
			}
			state = fflib.FFParse_want_key
			continue

		case fflib.FFParse_after_value:
			if tok == fflib.FFTok_comma {
				state = fflib.FFParse_want_key
			} else if tok == fflib.FFTok_right_bracket {
				goto done
			} else {
				wantedTok = fflib.FFTok_comma
				goto wrongtokenerror
			}

		case fflib.FFParse_want_key:
			// json {} ended. goto exit. woo.
			if tok == fflib.FFTok_right_bracket {
				goto done
			}
			if tok != fflib.FFTok_string {
				wantedTok = fflib.FFTok_string
				goto wrongtokenerror
			}

			kn := fs.Output.Bytes()
			if len(kn) <= 0 {
				// "" case. hrm.
				currentKey = ffj_t_CommandInfo_URIno_such_key
				state = fflib.FFParse_want_colon
				goto mainparse
			} else {
				switch kn[0] {

				case 'c':

					if bytes.Equal(ffj_key_CommandInfo_URI_Cache, kn) {
						currentKey = ffj_t_CommandInfo_URI_Cache
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				case 'e':

					if bytes.Equal(ffj_key_CommandInfo_URI_Executable, kn) {
						currentKey = ffj_t_CommandInfo_URI_Executable
						state = fflib.FFParse_want_colon
						goto mainparse

					} else if bytes.Equal(ffj_key_CommandInfo_URI_Extract, kn) {
						currentKey = ffj_t_CommandInfo_URI_Extract
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				case 'o':

					if bytes.Equal(ffj_key_CommandInfo_URI_OutputFile, kn) {
						currentKey = ffj_t_CommandInfo_URI_OutputFile
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				case 'v':

					if bytes.Equal(ffj_key_CommandInfo_URI_Value, kn) {
						currentKey = ffj_t_CommandInfo_URI_Value
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				}

				if fflib.AsciiEqualFold(ffj_key_CommandInfo_URI_OutputFile, kn) {
					currentKey = ffj_t_CommandInfo_URI_OutputFile
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.SimpleLetterEqualFold(ffj_key_CommandInfo_URI_Cache, kn) {
					currentKey = ffj_t_CommandInfo_URI_Cache
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.SimpleLetterEqualFold(ffj_key_CommandInfo_URI_Extract, kn) {
					currentKey = ffj_t_CommandInfo_URI_Extract
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.SimpleLetterEqualFold(ffj_key_CommandInfo_URI_Executable, kn) {
					currentKey = ffj_t_CommandInfo_URI_Executable
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.SimpleLetterEqualFold(ffj_key_CommandInfo_URI_Value, kn) {
					currentKey = ffj_t_CommandInfo_URI_Value
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				currentKey = ffj_t_CommandInfo_URIno_such_key
				state = fflib.FFParse_want_colon
				goto mainparse
			}

		case fflib.FFParse_want_colon:
			if tok != fflib.FFTok_colon {
				wantedTok = fflib.FFTok_colon
				goto wrongtokenerror
			}
			state = fflib.FFParse_want_value
			continue
		case fflib.FFParse_want_value:

			if tok == fflib.FFTok_left_brace || tok == fflib.FFTok_left_bracket || tok == fflib.FFTok_integer || tok == fflib.FFTok_double || tok == fflib.FFTok_string || tok == fflib.FFTok_bool || tok == fflib.FFTok_null {
				switch currentKey {

				case ffj_t_CommandInfo_URI_Value:
					goto handle_Value

				case ffj_t_CommandInfo_URI_Executable:
					goto handle_Executable

				case ffj_t_CommandInfo_URI_Extract:
					goto handle_Extract

				case ffj_t_CommandInfo_URI_Cache:
					goto handle_Cache

				case ffj_t_CommandInfo_URI_OutputFile:
					goto handle_OutputFile

				case ffj_t_CommandInfo_URIno_such_key:
					err = fs.SkipField(tok)
					if err != nil {
						return fs.WrapErr(err)
					}
					state = fflib.FFParse_after_value
					goto mainparse
				}
			} else {
				goto wantedvalue
			}
		}
	}

handle_Value:

	/* handler: uj.Value type=string kind=string quoted=false*/

	{

		{
			if tok != fflib.FFTok_string && tok != fflib.FFTok_null {
				return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for string", tok))
			}
		}

		if tok == fflib.FFTok_null {

		} else {

			outBuf := fs.Output.Bytes()

			uj.Value = string(string(outBuf))

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_Executable:

	/* handler: uj.Executable type=bool kind=bool quoted=false*/

	{
		if tok != fflib.FFTok_bool && tok != fflib.FFTok_null {
			return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for bool", tok))
		}
	}

	{
		if tok == fflib.FFTok_null {

			uj.Executable = nil

		} else {
			tmpb := fs.Output.Bytes()

			var tval bool

			if bytes.Compare([]byte{'t', 'r', 'u', 'e'}, tmpb) == 0 {

				tval = true

			} else if bytes.Compare([]byte{'f', 'a', 'l', 's', 'e'}, tmpb) == 0 {

				tval = false

			} else {
				err = errors.New("unexpected bytes for true/false value")
				return fs.WrapErr(err)
			}

			uj.Executable = &tval

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_Extract:

	/* handler: uj.Extract type=bool kind=bool quoted=false*/

	{
		if tok != fflib.FFTok_bool && tok != fflib.FFTok_null {
			return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for bool", tok))
		}
	}

	{
		if tok == fflib.FFTok_null {

			uj.Extract = nil

		} else {
			tmpb := fs.Output.Bytes()

			var tval bool

			if bytes.Compare([]byte{'t', 'r', 'u', 'e'}, tmpb) == 0 {

				tval = true

			} else if bytes.Compare([]byte{'f', 'a', 'l', 's', 'e'}, tmpb) == 0 {

				tval = false

			} else {
				err = errors.New("unexpected bytes for true/false value")
				return fs.WrapErr(err)
			}

			uj.Extract = &tval

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_Cache:

	/* handler: uj.Cache type=bool kind=bool quoted=false*/

	{
		if tok != fflib.FFTok_bool && tok != fflib.FFTok_null {
			return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for bool", tok))
		}
	}

	{
		if tok == fflib.FFTok_null {

			uj.Cache = nil

		} else {
			tmpb := fs.Output.Bytes()

			var tval bool

			if bytes.Compare([]byte{'t', 'r', 'u', 'e'}, tmpb) == 0 {

				tval = true

			} else if bytes.Compare([]byte{'f', 'a', 'l', 's', 'e'}, tmpb) == 0 {

				tval = false

			} else {
				err = errors.New("unexpected bytes for true/false value")
				return fs.WrapErr(err)
			}

			uj.Cache = &tval

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_OutputFile:

	/* handler: uj.OutputFile type=string kind=string quoted=false*/

	{

		{
			if tok != fflib.FFTok_string && tok != fflib.FFTok_null {
				return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for string", tok))
			}
		}

		if tok == fflib.FFTok_null {

			uj.OutputFile = nil

		} else {

			var tval string
			outBuf := fs.Output.Bytes()

			tval = string(string(outBuf))
			uj.OutputFile = &tval

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

wantedvalue:
	return fs.WrapErr(fmt.Errorf("wanted value token, but got token: %v", tok))
wrongtokenerror:
	return fs.WrapErr(fmt.Errorf("ffjson: wanted token: %v, but got token: %v output=%s", wantedTok, tok, fs.Output.String()))
tokerror:
	if fs.BigError != nil {
		return fs.WrapErr(fs.BigError)
	}
	err = fs.Error.ToError()
	if err != nil {
		return fs.WrapErr(err)
	}
	panic("ffjson-generated: unreachable, please report bug.")
done:

	return nil
}

func (mj *ContainerID) MarshalJSON() ([]byte, error) {
	var buf fflib.Buffer
	if mj == nil {
		buf.WriteString("null")
		return buf.Bytes(), nil
	}
	err := mj.MarshalJSONBuf(&buf)
	if err != nil {
		return nil, err
	}
	return buf.Bytes(), nil
}
func (mj *ContainerID) MarshalJSONBuf(buf fflib.EncodingBuffer) error {
	if mj == nil {
		buf.WriteString("null")
		return nil
	}
	var err error
	var obj []byte
	_ = obj
	_ = err
	buf.WriteString(`{ "value":`)
	fflib.WriteJsonString(buf, string(mj.Value))
	buf.WriteByte(',')
	if mj.Parent != nil {
		if true {
			buf.WriteString(`"parent":`)

			{

				err = mj.Parent.MarshalJSONBuf(buf)
				if err != nil {
					return err
				}

			}
			buf.WriteByte(',')
		}
	}
	buf.Rewind(1)
	buf.WriteByte('}')
	return nil
}

const (
	ffj_t_ContainerIDbase = iota
	ffj_t_ContainerIDno_such_key

	ffj_t_ContainerID_Value

	ffj_t_ContainerID_Parent
)

var ffj_key_ContainerID_Value = []byte("value")

var ffj_key_ContainerID_Parent = []byte("parent")

func (uj *ContainerID) UnmarshalJSON(input []byte) error {
	fs := fflib.NewFFLexer(input)
	return uj.UnmarshalJSONFFLexer(fs, fflib.FFParse_map_start)
}

func (uj *ContainerID) UnmarshalJSONFFLexer(fs *fflib.FFLexer, state fflib.FFParseState) error {
	var err error = nil
	currentKey := ffj_t_ContainerIDbase
	_ = currentKey
	tok := fflib.FFTok_init
	wantedTok := fflib.FFTok_init

mainparse:
	for {
		tok = fs.Scan()
		//	println(fmt.Sprintf("debug: tok: %v  state: %v", tok, state))
		if tok == fflib.FFTok_error {
			goto tokerror
		}

		switch state {

		case fflib.FFParse_map_start:
			if tok != fflib.FFTok_left_bracket {
				wantedTok = fflib.FFTok_left_bracket
				goto wrongtokenerror
			}
			state = fflib.FFParse_want_key
			continue

		case fflib.FFParse_after_value:
			if tok == fflib.FFTok_comma {
				state = fflib.FFParse_want_key
			} else if tok == fflib.FFTok_right_bracket {
				goto done
			} else {
				wantedTok = fflib.FFTok_comma
				goto wrongtokenerror
			}

		case fflib.FFParse_want_key:
			// json {} ended. goto exit. woo.
			if tok == fflib.FFTok_right_bracket {
				goto done
			}
			if tok != fflib.FFTok_string {
				wantedTok = fflib.FFTok_string
				goto wrongtokenerror
			}

			kn := fs.Output.Bytes()
			if len(kn) <= 0 {
				// "" case. hrm.
				currentKey = ffj_t_ContainerIDno_such_key
				state = fflib.FFParse_want_colon
				goto mainparse
			} else {
				switch kn[0] {

				case 'p':

					if bytes.Equal(ffj_key_ContainerID_Parent, kn) {
						currentKey = ffj_t_ContainerID_Parent
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				case 'v':

					if bytes.Equal(ffj_key_ContainerID_Value, kn) {
						currentKey = ffj_t_ContainerID_Value
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				}

				if fflib.SimpleLetterEqualFold(ffj_key_ContainerID_Parent, kn) {
					currentKey = ffj_t_ContainerID_Parent
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.SimpleLetterEqualFold(ffj_key_ContainerID_Value, kn) {
					currentKey = ffj_t_ContainerID_Value
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				currentKey = ffj_t_ContainerIDno_such_key
				state = fflib.FFParse_want_colon
				goto mainparse
			}

		case fflib.FFParse_want_colon:
			if tok != fflib.FFTok_colon {
				wantedTok = fflib.FFTok_colon
				goto wrongtokenerror
			}
			state = fflib.FFParse_want_value
			continue
		case fflib.FFParse_want_value:

			if tok == fflib.FFTok_left_brace || tok == fflib.FFTok_left_bracket || tok == fflib.FFTok_integer || tok == fflib.FFTok_double || tok == fflib.FFTok_string || tok == fflib.FFTok_bool || tok == fflib.FFTok_null {
				switch currentKey {

				case ffj_t_ContainerID_Value:
					goto handle_Value

				case ffj_t_ContainerID_Parent:
					goto handle_Parent

				case ffj_t_ContainerIDno_such_key:
					err = fs.SkipField(tok)
					if err != nil {
						return fs.WrapErr(err)
					}
					state = fflib.FFParse_after_value
					goto mainparse
				}
			} else {
				goto wantedvalue
			}
		}
	}

handle_Value:

	/* handler: uj.Value type=string kind=string quoted=false*/

	{

		{
			if tok != fflib.FFTok_string && tok != fflib.FFTok_null {
				return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for string", tok))
			}
		}

		if tok == fflib.FFTok_null {

		} else {

			outBuf := fs.Output.Bytes()

			uj.Value = string(string(outBuf))

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_Parent:

	/* handler: uj.Parent type=mesos.ContainerID kind=struct quoted=false*/

	{
		if tok == fflib.FFTok_null {

			uj.Parent = nil

			state = fflib.FFParse_after_value
			goto mainparse
		}

		if uj.Parent == nil {
			uj.Parent = new(ContainerID)
		}

		err = uj.Parent.UnmarshalJSONFFLexer(fs, fflib.FFParse_want_key)
		if err != nil {
			return err
		}
		state = fflib.FFParse_after_value
	}

	state = fflib.FFParse_after_value
	goto mainparse

wantedvalue:
	return fs.WrapErr(fmt.Errorf("wanted value token, but got token: %v", tok))
wrongtokenerror:
	return fs.WrapErr(fmt.Errorf("ffjson: wanted token: %v, but got token: %v output=%s", wantedTok, tok, fs.Output.String()))
tokerror:
	if fs.BigError != nil {
		return fs.WrapErr(fs.BigError)
	}
	err = fs.Error.ToError()
	if err != nil {
		return fs.WrapErr(err)
	}
	panic("ffjson-generated: unreachable, please report bug.")
done:

	return nil
}

func (mj *ContainerInfo) MarshalJSON() ([]byte, error) {
	var buf fflib.Buffer
	if mj == nil {
		buf.WriteString("null")
		return buf.Bytes(), nil
	}
	err := mj.MarshalJSONBuf(&buf)
	if err != nil {
		return nil, err
	}
	return buf.Bytes(), nil
}
func (mj *ContainerInfo) MarshalJSONBuf(buf fflib.EncodingBuffer) error {
	if mj == nil {
		buf.WriteString("null")
		return nil
	}
	var err error
	var obj []byte
	_ = obj
	_ = err
	buf.WriteString(`{ `)
	if mj.Type != nil {
		if true {
			buf.WriteString(`"type":`)

			{

				obj, err = mj.Type.MarshalJSON()
				if err != nil {
					return err
				}
				buf.Write(obj)

			}
			buf.WriteByte(',')
		}
	}
	buf.WriteString(`"volumes":`)
	if mj.Volumes != nil {
		buf.WriteString(`[`)
		for i, v := range mj.Volumes {
			if i != 0 {
				buf.WriteString(`,`)
			}

			{

				err = v.MarshalJSONBuf(buf)
				if err != nil {
					return err
				}

			}
		}
		buf.WriteString(`]`)
	} else {
		buf.WriteString(`null`)
	}
	buf.WriteByte(',')
	if mj.Hostname != nil {
		if true {
			buf.WriteString(`"hostname":`)
			fflib.WriteJsonString(buf, string(*mj.Hostname))
			buf.WriteByte(',')
		}
	}
	if mj.Docker != nil {
		if true {
			buf.WriteString(`"docker":`)

			{

				err = mj.Docker.MarshalJSONBuf(buf)
				if err != nil {
					return err
				}

			}
			buf.WriteByte(',')
		}
	}
	if mj.Mesos != nil {
		if true {
			buf.WriteString(`"mesos":`)

			{

				err = mj.Mesos.MarshalJSONBuf(buf)
				if err != nil {
					return err
				}

			}
			buf.WriteByte(',')
		}
	}
	buf.WriteString(`"network_infos":`)
	if mj.NetworkInfos != nil {
		buf.WriteString(`[`)
		for i, v := range mj.NetworkInfos {
			if i != 0 {
				buf.WriteString(`,`)
			}

			{

				err = v.MarshalJSONBuf(buf)
				if err != nil {
					return err
				}

			}
		}
		buf.WriteString(`]`)
	} else {
		buf.WriteString(`null`)
	}
	buf.WriteByte(',')
	if mj.LinuxInfo != nil {
		if true {
			buf.WriteString(`"linux_info":`)

			{

				err = mj.LinuxInfo.MarshalJSONBuf(buf)
				if err != nil {
					return err
				}

			}
			buf.WriteByte(',')
		}
	}
	if mj.RlimitInfo != nil {
		if true {
			buf.WriteString(`"rlimit_info":`)

			{

				err = mj.RlimitInfo.MarshalJSONBuf(buf)
				if err != nil {
					return err
				}

			}
			buf.WriteByte(',')
		}
	}
	if mj.TTYInfo != nil {
		if true {
			buf.WriteString(`"tty_info":`)

			{

				err = mj.TTYInfo.MarshalJSONBuf(buf)
				if err != nil {
					return err
				}

			}
			buf.WriteByte(',')
		}
	}
	buf.Rewind(1)
	buf.WriteByte('}')
	return nil
}

const (
	ffj_t_ContainerInfobase = iota
	ffj_t_ContainerInfono_such_key

	ffj_t_ContainerInfo_Type

	ffj_t_ContainerInfo_Volumes

	ffj_t_ContainerInfo_Hostname

	ffj_t_ContainerInfo_Docker

	ffj_t_ContainerInfo_Mesos

	ffj_t_ContainerInfo_NetworkInfos

	ffj_t_ContainerInfo_LinuxInfo

	ffj_t_ContainerInfo_RlimitInfo

	ffj_t_ContainerInfo_TTYInfo
)

var ffj_key_ContainerInfo_Type = []byte("type")

var ffj_key_ContainerInfo_Volumes = []byte("volumes")

var ffj_key_ContainerInfo_Hostname = []byte("hostname")

var ffj_key_ContainerInfo_Docker = []byte("docker")

var ffj_key_ContainerInfo_Mesos = []byte("mesos")

var ffj_key_ContainerInfo_NetworkInfos = []byte("network_infos")

var ffj_key_ContainerInfo_LinuxInfo = []byte("linux_info")

var ffj_key_ContainerInfo_RlimitInfo = []byte("rlimit_info")

var ffj_key_ContainerInfo_TTYInfo = []byte("tty_info")

func (uj *ContainerInfo) UnmarshalJSON(input []byte) error {
	fs := fflib.NewFFLexer(input)
	return uj.UnmarshalJSONFFLexer(fs, fflib.FFParse_map_start)
}

func (uj *ContainerInfo) UnmarshalJSONFFLexer(fs *fflib.FFLexer, state fflib.FFParseState) error {
	var err error = nil
	currentKey := ffj_t_ContainerInfobase
	_ = currentKey
	tok := fflib.FFTok_init
	wantedTok := fflib.FFTok_init

mainparse:
	for {
		tok = fs.Scan()
		//	println(fmt.Sprintf("debug: tok: %v  state: %v", tok, state))
		if tok == fflib.FFTok_error {
			goto tokerror
		}

		switch state {

		case fflib.FFParse_map_start:
			if tok != fflib.FFTok_left_bracket {
				wantedTok = fflib.FFTok_left_bracket
				goto wrongtokenerror
			}
			state = fflib.FFParse_want_key
			continue

		case fflib.FFParse_after_value:
			if tok == fflib.FFTok_comma {
				state = fflib.FFParse_want_key
			} else if tok == fflib.FFTok_right_bracket {
				goto done
			} else {
				wantedTok = fflib.FFTok_comma
				goto wrongtokenerror
			}

		case fflib.FFParse_want_key:
			// json {} ended. goto exit. woo.
			if tok == fflib.FFTok_right_bracket {
				goto done
			}
			if tok != fflib.FFTok_string {
				wantedTok = fflib.FFTok_string
				goto wrongtokenerror
			}

			kn := fs.Output.Bytes()
			if len(kn) <= 0 {
				// "" case. hrm.
				currentKey = ffj_t_ContainerInfono_such_key
				state = fflib.FFParse_want_colon
				goto mainparse
			} else {
				switch kn[0] {

				case 'd':

					if bytes.Equal(ffj_key_ContainerInfo_Docker, kn) {
						currentKey = ffj_t_ContainerInfo_Docker
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				case 'h':

					if bytes.Equal(ffj_key_ContainerInfo_Hostname, kn) {
						currentKey = ffj_t_ContainerInfo_Hostname
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				case 'l':

					if bytes.Equal(ffj_key_ContainerInfo_LinuxInfo, kn) {
						currentKey = ffj_t_ContainerInfo_LinuxInfo
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				case 'm':

					if bytes.Equal(ffj_key_ContainerInfo_Mesos, kn) {
						currentKey = ffj_t_ContainerInfo_Mesos
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				case 'n':

					if bytes.Equal(ffj_key_ContainerInfo_NetworkInfos, kn) {
						currentKey = ffj_t_ContainerInfo_NetworkInfos
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				case 'r':

					if bytes.Equal(ffj_key_ContainerInfo_RlimitInfo, kn) {
						currentKey = ffj_t_ContainerInfo_RlimitInfo
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				case 't':

					if bytes.Equal(ffj_key_ContainerInfo_Type, kn) {
						currentKey = ffj_t_ContainerInfo_Type
						state = fflib.FFParse_want_colon
						goto mainparse

					} else if bytes.Equal(ffj_key_ContainerInfo_TTYInfo, kn) {
						currentKey = ffj_t_ContainerInfo_TTYInfo
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				case 'v':

					if bytes.Equal(ffj_key_ContainerInfo_Volumes, kn) {
						currentKey = ffj_t_ContainerInfo_Volumes
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				}

				if fflib.AsciiEqualFold(ffj_key_ContainerInfo_TTYInfo, kn) {
					currentKey = ffj_t_ContainerInfo_TTYInfo
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.AsciiEqualFold(ffj_key_ContainerInfo_RlimitInfo, kn) {
					currentKey = ffj_t_ContainerInfo_RlimitInfo
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.AsciiEqualFold(ffj_key_ContainerInfo_LinuxInfo, kn) {
					currentKey = ffj_t_ContainerInfo_LinuxInfo
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffj_key_ContainerInfo_NetworkInfos, kn) {
					currentKey = ffj_t_ContainerInfo_NetworkInfos
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffj_key_ContainerInfo_Mesos, kn) {
					currentKey = ffj_t_ContainerInfo_Mesos
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffj_key_ContainerInfo_Docker, kn) {
					currentKey = ffj_t_ContainerInfo_Docker
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffj_key_ContainerInfo_Hostname, kn) {
					currentKey = ffj_t_ContainerInfo_Hostname
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffj_key_ContainerInfo_Volumes, kn) {
					currentKey = ffj_t_ContainerInfo_Volumes
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.SimpleLetterEqualFold(ffj_key_ContainerInfo_Type, kn) {
					currentKey = ffj_t_ContainerInfo_Type
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				currentKey = ffj_t_ContainerInfono_such_key
				state = fflib.FFParse_want_colon
				goto mainparse
			}

		case fflib.FFParse_want_colon:
			if tok != fflib.FFTok_colon {
				wantedTok = fflib.FFTok_colon
				goto wrongtokenerror
			}
			state = fflib.FFParse_want_value
			continue
		case fflib.FFParse_want_value:

			if tok == fflib.FFTok_left_brace || tok == fflib.FFTok_left_bracket || tok == fflib.FFTok_integer || tok == fflib.FFTok_double || tok == fflib.FFTok_string || tok == fflib.FFTok_bool || tok == fflib.FFTok_null {
				switch currentKey {

				case ffj_t_ContainerInfo_Type:
					goto handle_Type

				case ffj_t_ContainerInfo_Volumes:
					goto handle_Volumes

				case ffj_t_ContainerInfo_Hostname:
					goto handle_Hostname

				case ffj_t_ContainerInfo_Docker:
					goto handle_Docker

				case ffj_t_ContainerInfo_Mesos:
					goto handle_Mesos

				case ffj_t_ContainerInfo_NetworkInfos:
					goto handle_NetworkInfos

				case ffj_t_ContainerInfo_LinuxInfo:
					goto handle_LinuxInfo

				case ffj_t_ContainerInfo_RlimitInfo:
					goto handle_RlimitInfo

				case ffj_t_ContainerInfo_TTYInfo:
					goto handle_TTYInfo

				case ffj_t_ContainerInfono_such_key:
					err = fs.SkipField(tok)
					if err != nil {
						return fs.WrapErr(err)
					}
					state = fflib.FFParse_after_value
					goto mainparse
				}
			} else {
				goto wantedvalue
			}
		}
	}

handle_Type:

	/* handler: uj.Type type=mesos.ContainerInfo_Type kind=int32 quoted=false*/

	{
		if tok == fflib.FFTok_null {

			uj.Type = nil

			state = fflib.FFParse_after_value
			goto mainparse
		}

		tbuf, err := fs.CaptureField(tok)
		if err != nil {
			return fs.WrapErr(err)
		}

		if uj.Type == nil {
			uj.Type = new(ContainerInfo_Type)
		}

		err = uj.Type.UnmarshalJSON(tbuf)
		if err != nil {
			return fs.WrapErr(err)
		}
		state = fflib.FFParse_after_value
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_Volumes:

	/* handler: uj.Volumes type=[]mesos.Volume kind=slice quoted=false*/

	{

		{
			if tok != fflib.FFTok_left_brace && tok != fflib.FFTok_null {
				return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for ", tok))
			}
		}

		if tok == fflib.FFTok_null {
			uj.Volumes = nil
		} else {

			uj.Volumes = []Volume{}

			wantVal := true

			for {

				var tmp_uj__Volumes Volume

				tok = fs.Scan()
				if tok == fflib.FFTok_error {
					goto tokerror
				}
				if tok == fflib.FFTok_right_brace {
					break
				}

				if tok == fflib.FFTok_comma {
					if wantVal == true {
						// TODO(pquerna): this isn't an ideal error message, this handles
						// things like [,,,] as an array value.
						return fs.WrapErr(fmt.Errorf("wanted value token, but got token: %v", tok))
					}
					continue
				} else {
					wantVal = true
				}

				/* handler: tmp_uj__Volumes type=mesos.Volume kind=struct quoted=false*/

				{
					if tok == fflib.FFTok_null {

						state = fflib.FFParse_after_value
						goto mainparse
					}

					err = tmp_uj__Volumes.UnmarshalJSONFFLexer(fs, fflib.FFParse_want_key)
					if err != nil {
						return err
					}
					state = fflib.FFParse_after_value
				}

				uj.Volumes = append(uj.Volumes, tmp_uj__Volumes)

				wantVal = false
			}
		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_Hostname:

	/* handler: uj.Hostname type=string kind=string quoted=false*/

	{

		{
			if tok != fflib.FFTok_string && tok != fflib.FFTok_null {
				return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for string", tok))
			}
		}

		if tok == fflib.FFTok_null {

			uj.Hostname = nil

		} else {

			var tval string
			outBuf := fs.Output.Bytes()

			tval = string(string(outBuf))
			uj.Hostname = &tval

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_Docker:

	/* handler: uj.Docker type=mesos.ContainerInfo_DockerInfo kind=struct quoted=false*/

	{
		if tok == fflib.FFTok_null {

			uj.Docker = nil

			state = fflib.FFParse_after_value
			goto mainparse
		}

		if uj.Docker == nil {
			uj.Docker = new(ContainerInfo_DockerInfo)
		}

		err = uj.Docker.UnmarshalJSONFFLexer(fs, fflib.FFParse_want_key)
		if err != nil {
			return err
		}
		state = fflib.FFParse_after_value
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_Mesos:

	/* handler: uj.Mesos type=mesos.ContainerInfo_MesosInfo kind=struct quoted=false*/

	{
		if tok == fflib.FFTok_null {

			uj.Mesos = nil

			state = fflib.FFParse_after_value
			goto mainparse
		}

		if uj.Mesos == nil {
			uj.Mesos = new(ContainerInfo_MesosInfo)
		}

		err = uj.Mesos.UnmarshalJSONFFLexer(fs, fflib.FFParse_want_key)
		if err != nil {
			return err
		}
		state = fflib.FFParse_after_value
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_NetworkInfos:

	/* handler: uj.NetworkInfos type=[]mesos.NetworkInfo kind=slice quoted=false*/

	{

		{
			if tok != fflib.FFTok_left_brace && tok != fflib.FFTok_null {
				return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for ", tok))
			}
		}

		if tok == fflib.FFTok_null {
			uj.NetworkInfos = nil
		} else {

			uj.NetworkInfos = []NetworkInfo{}

			wantVal := true

			for {

				var tmp_uj__NetworkInfos NetworkInfo

				tok = fs.Scan()
				if tok == fflib.FFTok_error {
					goto tokerror
				}
				if tok == fflib.FFTok_right_brace {
					break
				}

				if tok == fflib.FFTok_comma {
					if wantVal == true {
						// TODO(pquerna): this isn't an ideal error message, this handles
						// things like [,,,] as an array value.
						return fs.WrapErr(fmt.Errorf("wanted value token, but got token: %v", tok))
					}
					continue
				} else {
					wantVal = true
				}

				/* handler: tmp_uj__NetworkInfos type=mesos.NetworkInfo kind=struct quoted=false*/

				{
					if tok == fflib.FFTok_null {

						state = fflib.FFParse_after_value
						goto mainparse
					}

					err = tmp_uj__NetworkInfos.UnmarshalJSONFFLexer(fs, fflib.FFParse_want_key)
					if err != nil {
						return err
					}
					state = fflib.FFParse_after_value
				}

				uj.NetworkInfos = append(uj.NetworkInfos, tmp_uj__NetworkInfos)

				wantVal = false
			}
		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_LinuxInfo:

	/* handler: uj.LinuxInfo type=mesos.LinuxInfo kind=struct quoted=false*/

	{
		if tok == fflib.FFTok_null {

			uj.LinuxInfo = nil

			state = fflib.FFParse_after_value
			goto mainparse
		}

		if uj.LinuxInfo == nil {
			uj.LinuxInfo = new(LinuxInfo)
		}

		err = uj.LinuxInfo.UnmarshalJSONFFLexer(fs, fflib.FFParse_want_key)
		if err != nil {
			return err
		}
		state = fflib.FFParse_after_value
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_RlimitInfo:

	/* handler: uj.RlimitInfo type=mesos.RLimitInfo kind=struct quoted=false*/

	{
		if tok == fflib.FFTok_null {

			uj.RlimitInfo = nil

			state = fflib.FFParse_after_value
			goto mainparse
		}

		if uj.RlimitInfo == nil {
			uj.RlimitInfo = new(RLimitInfo)
		}

		err = uj.RlimitInfo.UnmarshalJSONFFLexer(fs, fflib.FFParse_want_key)
		if err != nil {
			return err
		}
		state = fflib.FFParse_after_value
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_TTYInfo:

	/* handler: uj.TTYInfo type=mesos.TTYInfo kind=struct quoted=false*/

	{
		if tok == fflib.FFTok_null {

			uj.TTYInfo = nil

			state = fflib.FFParse_after_value
			goto mainparse
		}

		if uj.TTYInfo == nil {
			uj.TTYInfo = new(TTYInfo)
		}

		err = uj.TTYInfo.UnmarshalJSONFFLexer(fs, fflib.FFParse_want_key)
		if err != nil {
			return err
		}
		state = fflib.FFParse_after_value
	}

	state = fflib.FFParse_after_value
	goto mainparse

wantedvalue:
	return fs.WrapErr(fmt.Errorf("wanted value token, but got token: %v", tok))
wrongtokenerror:
	return fs.WrapErr(fmt.Errorf("ffjson: wanted token: %v, but got token: %v output=%s", wantedTok, tok, fs.Output.String()))
tokerror:
	if fs.BigError != nil {
		return fs.WrapErr(fs.BigError)
	}
	err = fs.Error.ToError()
	if err != nil {
		return fs.WrapErr(err)
	}
	panic("ffjson-generated: unreachable, please report bug.")
done:

	return nil
}

func (mj *ContainerInfo_DockerInfo) MarshalJSON() ([]byte, error) {
	var buf fflib.Buffer
	if mj == nil {
		buf.WriteString("null")
		return buf.Bytes(), nil
	}
	err := mj.MarshalJSONBuf(&buf)
	if err != nil {
		return nil, err
	}
	return buf.Bytes(), nil
}
func (mj *ContainerInfo_DockerInfo) MarshalJSONBuf(buf fflib.EncodingBuffer) error {
	if mj == nil {
		buf.WriteString("null")
		return nil
	}
	var err error
	var obj []byte
	_ = obj
	_ = err
	buf.WriteString(`{ "image":`)
	fflib.WriteJsonString(buf, string(mj.Image))
	buf.WriteByte(',')
	if mj.Network != nil {
		if true {
			buf.WriteString(`"network":`)

			{

				obj, err = mj.Network.MarshalJSON()
				if err != nil {
					return err
				}
				buf.Write(obj)

			}
			buf.WriteByte(',')
		}
	}
	buf.WriteString(`"port_mappings":`)
	if mj.PortMappings != nil {
		buf.WriteString(`[`)
		for i, v := range mj.PortMappings {
			if i != 0 {
				buf.WriteString(`,`)
			}

			{

				err = v.MarshalJSONBuf(buf)
				if err != nil {
					return err
				}

			}
		}
		buf.WriteString(`]`)
	} else {
		buf.WriteString(`null`)
	}
	buf.WriteByte(',')
	if mj.Privileged != nil {
		if true {
			if *mj.Privileged {
				buf.WriteString(`"privileged":true`)
			} else {
				buf.WriteString(`"privileged":false`)
			}
			buf.WriteByte(',')
		}
	}
	buf.WriteString(`"parameters":`)
	if mj.Parameters != nil {
		buf.WriteString(`[`)
		for i, v := range mj.Parameters {
			if i != 0 {
				buf.WriteString(`,`)
			}

			{

				err = v.MarshalJSONBuf(buf)
				if err != nil {
					return err
				}

			}
		}
		buf.WriteString(`]`)
	} else {
		buf.WriteString(`null`)
	}
	buf.WriteByte(',')
	if mj.ForcePullImage != nil {
		if true {
			if *mj.ForcePullImage {
				buf.WriteString(`"force_pull_image":true`)
			} else {
				buf.WriteString(`"force_pull_image":false`)
			}
			buf.WriteByte(',')
		}
	}
	if mj.VolumeDriver != nil {
		if true {
			buf.WriteString(`"volume_driver":`)
			fflib.WriteJsonString(buf, string(*mj.VolumeDriver))
			buf.WriteByte(',')
		}
	}
	buf.Rewind(1)
	buf.WriteByte('}')
	return nil
}

const (
	ffj_t_ContainerInfo_DockerInfobase = iota
	ffj_t_ContainerInfo_DockerInfono_such_key

	ffj_t_ContainerInfo_DockerInfo_Image

	ffj_t_ContainerInfo_DockerInfo_Network

	ffj_t_ContainerInfo_DockerInfo_PortMappings

	ffj_t_ContainerInfo_DockerInfo_Privileged

	ffj_t_ContainerInfo_DockerInfo_Parameters

	ffj_t_ContainerInfo_DockerInfo_ForcePullImage

	ffj_t_ContainerInfo_DockerInfo_VolumeDriver
)

var ffj_key_ContainerInfo_DockerInfo_Image = []byte("image")

var ffj_key_ContainerInfo_DockerInfo_Network = []byte("network")

var ffj_key_ContainerInfo_DockerInfo_PortMappings = []byte("port_mappings")

var ffj_key_ContainerInfo_DockerInfo_Privileged = []byte("privileged")

var ffj_key_ContainerInfo_DockerInfo_Parameters = []byte("parameters")

var ffj_key_ContainerInfo_DockerInfo_ForcePullImage = []byte("force_pull_image")

var ffj_key_ContainerInfo_DockerInfo_VolumeDriver = []byte("volume_driver")

func (uj *ContainerInfo_DockerInfo) UnmarshalJSON(input []byte) error {
	fs := fflib.NewFFLexer(input)
	return uj.UnmarshalJSONFFLexer(fs, fflib.FFParse_map_start)
}

func (uj *ContainerInfo_DockerInfo) UnmarshalJSONFFLexer(fs *fflib.FFLexer, state fflib.FFParseState) error {
	var err error = nil
	currentKey := ffj_t_ContainerInfo_DockerInfobase
	_ = currentKey
	tok := fflib.FFTok_init
	wantedTok := fflib.FFTok_init

mainparse:
	for {
		tok = fs.Scan()
		//	println(fmt.Sprintf("debug: tok: %v  state: %v", tok, state))
		if tok == fflib.FFTok_error {
			goto tokerror
		}

		switch state {

		case fflib.FFParse_map_start:
			if tok != fflib.FFTok_left_bracket {
				wantedTok = fflib.FFTok_left_bracket
				goto wrongtokenerror
			}
			state = fflib.FFParse_want_key
			continue

		case fflib.FFParse_after_value:
			if tok == fflib.FFTok_comma {
				state = fflib.FFParse_want_key
			} else if tok == fflib.FFTok_right_bracket {
				goto done
			} else {
				wantedTok = fflib.FFTok_comma
				goto wrongtokenerror
			}

		case fflib.FFParse_want_key:
			// json {} ended. goto exit. woo.
			if tok == fflib.FFTok_right_bracket {
				goto done
			}
			if tok != fflib.FFTok_string {
				wantedTok = fflib.FFTok_string
				goto wrongtokenerror
			}

			kn := fs.Output.Bytes()
			if len(kn) <= 0 {
				// "" case. hrm.
				currentKey = ffj_t_ContainerInfo_DockerInfono_such_key
				state = fflib.FFParse_want_colon
				goto mainparse
			} else {
				switch kn[0] {

				case 'f':

					if bytes.Equal(ffj_key_ContainerInfo_DockerInfo_ForcePullImage, kn) {
						currentKey = ffj_t_ContainerInfo_DockerInfo_ForcePullImage
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				case 'i':

					if bytes.Equal(ffj_key_ContainerInfo_DockerInfo_Image, kn) {
						currentKey = ffj_t_ContainerInfo_DockerInfo_Image
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				case 'n':

					if bytes.Equal(ffj_key_ContainerInfo_DockerInfo_Network, kn) {
						currentKey = ffj_t_ContainerInfo_DockerInfo_Network
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				case 'p':

					if bytes.Equal(ffj_key_ContainerInfo_DockerInfo_PortMappings, kn) {
						currentKey = ffj_t_ContainerInfo_DockerInfo_PortMappings
						state = fflib.FFParse_want_colon
						goto mainparse

					} else if bytes.Equal(ffj_key_ContainerInfo_DockerInfo_Privileged, kn) {
						currentKey = ffj_t_ContainerInfo_DockerInfo_Privileged
						state = fflib.FFParse_want_colon
						goto mainparse

					} else if bytes.Equal(ffj_key_ContainerInfo_DockerInfo_Parameters, kn) {
						currentKey = ffj_t_ContainerInfo_DockerInfo_Parameters
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				case 'v':

					if bytes.Equal(ffj_key_ContainerInfo_DockerInfo_VolumeDriver, kn) {
						currentKey = ffj_t_ContainerInfo_DockerInfo_VolumeDriver
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				}

				if fflib.AsciiEqualFold(ffj_key_ContainerInfo_DockerInfo_VolumeDriver, kn) {
					currentKey = ffj_t_ContainerInfo_DockerInfo_VolumeDriver
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.AsciiEqualFold(ffj_key_ContainerInfo_DockerInfo_ForcePullImage, kn) {
					currentKey = ffj_t_ContainerInfo_DockerInfo_ForcePullImage
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffj_key_ContainerInfo_DockerInfo_Parameters, kn) {
					currentKey = ffj_t_ContainerInfo_DockerInfo_Parameters
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.SimpleLetterEqualFold(ffj_key_ContainerInfo_DockerInfo_Privileged, kn) {
					currentKey = ffj_t_ContainerInfo_DockerInfo_Privileged
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffj_key_ContainerInfo_DockerInfo_PortMappings, kn) {
					currentKey = ffj_t_ContainerInfo_DockerInfo_PortMappings
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffj_key_ContainerInfo_DockerInfo_Network, kn) {
					currentKey = ffj_t_ContainerInfo_DockerInfo_Network
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.SimpleLetterEqualFold(ffj_key_ContainerInfo_DockerInfo_Image, kn) {
					currentKey = ffj_t_ContainerInfo_DockerInfo_Image
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				currentKey = ffj_t_ContainerInfo_DockerInfono_such_key
				state = fflib.FFParse_want_colon
				goto mainparse
			}

		case fflib.FFParse_want_colon:
			if tok != fflib.FFTok_colon {
				wantedTok = fflib.FFTok_colon
				goto wrongtokenerror
			}
			state = fflib.FFParse_want_value
			continue
		case fflib.FFParse_want_value:

			if tok == fflib.FFTok_left_brace || tok == fflib.FFTok_left_bracket || tok == fflib.FFTok_integer || tok == fflib.FFTok_double || tok == fflib.FFTok_string || tok == fflib.FFTok_bool || tok == fflib.FFTok_null {
				switch currentKey {

				case ffj_t_ContainerInfo_DockerInfo_Image:
					goto handle_Image

				case ffj_t_ContainerInfo_DockerInfo_Network:
					goto handle_Network

				case ffj_t_ContainerInfo_DockerInfo_PortMappings:
					goto handle_PortMappings

				case ffj_t_ContainerInfo_DockerInfo_Privileged:
					goto handle_Privileged

				case ffj_t_ContainerInfo_DockerInfo_Parameters:
					goto handle_Parameters

				case ffj_t_ContainerInfo_DockerInfo_ForcePullImage:
					goto handle_ForcePullImage

				case ffj_t_ContainerInfo_DockerInfo_VolumeDriver:
					goto handle_VolumeDriver

				case ffj_t_ContainerInfo_DockerInfono_such_key:
					err = fs.SkipField(tok)
					if err != nil {
						return fs.WrapErr(err)
					}
					state = fflib.FFParse_after_value
					goto mainparse
				}
			} else {
				goto wantedvalue
			}
		}
	}

handle_Image:

	/* handler: uj.Image type=string kind=string quoted=false*/

	{

		{
			if tok != fflib.FFTok_string && tok != fflib.FFTok_null {
				return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for string", tok))
			}
		}

		if tok == fflib.FFTok_null {

		} else {

			outBuf := fs.Output.Bytes()

			uj.Image = string(string(outBuf))

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_Network:

	/* handler: uj.Network type=mesos.ContainerInfo_DockerInfo_Network kind=int32 quoted=false*/

	{
		if tok == fflib.FFTok_null {

			uj.Network = nil

			state = fflib.FFParse_after_value
			goto mainparse
		}

		tbuf, err := fs.CaptureField(tok)
		if err != nil {
			return fs.WrapErr(err)
		}

		if uj.Network == nil {
			uj.Network = new(ContainerInfo_DockerInfo_Network)
		}

		err = uj.Network.UnmarshalJSON(tbuf)
		if err != nil {
			return fs.WrapErr(err)
		}
		state = fflib.FFParse_after_value
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_PortMappings:

	/* handler: uj.PortMappings type=[]mesos.ContainerInfo_DockerInfo_PortMapping kind=slice quoted=false*/

	{

		{
			if tok != fflib.FFTok_left_brace && tok != fflib.FFTok_null {
				return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for ", tok))
			}
		}

		if tok == fflib.FFTok_null {
			uj.PortMappings = nil
		} else {

			uj.PortMappings = []ContainerInfo_DockerInfo_PortMapping{}

			wantVal := true

			for {

				var tmp_uj__PortMappings ContainerInfo_DockerInfo_PortMapping

				tok = fs.Scan()
				if tok == fflib.FFTok_error {
					goto tokerror
				}
				if tok == fflib.FFTok_right_brace {
					break
				}

				if tok == fflib.FFTok_comma {
					if wantVal == true {
						// TODO(pquerna): this isn't an ideal error message, this handles
						// things like [,,,] as an array value.
						return fs.WrapErr(fmt.Errorf("wanted value token, but got token: %v", tok))
					}
					continue
				} else {
					wantVal = true
				}

				/* handler: tmp_uj__PortMappings type=mesos.ContainerInfo_DockerInfo_PortMapping kind=struct quoted=false*/

				{
					if tok == fflib.FFTok_null {

						state = fflib.FFParse_after_value
						goto mainparse
					}

					err = tmp_uj__PortMappings.UnmarshalJSONFFLexer(fs, fflib.FFParse_want_key)
					if err != nil {
						return err
					}
					state = fflib.FFParse_after_value
				}

				uj.PortMappings = append(uj.PortMappings, tmp_uj__PortMappings)

				wantVal = false
			}
		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_Privileged:

	/* handler: uj.Privileged type=bool kind=bool quoted=false*/

	{
		if tok != fflib.FFTok_bool && tok != fflib.FFTok_null {
			return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for bool", tok))
		}
	}

	{
		if tok == fflib.FFTok_null {

			uj.Privileged = nil

		} else {
			tmpb := fs.Output.Bytes()

			var tval bool

			if bytes.Compare([]byte{'t', 'r', 'u', 'e'}, tmpb) == 0 {

				tval = true

			} else if bytes.Compare([]byte{'f', 'a', 'l', 's', 'e'}, tmpb) == 0 {

				tval = false

			} else {
				err = errors.New("unexpected bytes for true/false value")
				return fs.WrapErr(err)
			}

			uj.Privileged = &tval

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_Parameters:

	/* handler: uj.Parameters type=[]mesos.Parameter kind=slice quoted=false*/

	{

		{
			if tok != fflib.FFTok_left_brace && tok != fflib.FFTok_null {
				return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for ", tok))
			}
		}

		if tok == fflib.FFTok_null {
			uj.Parameters = nil
		} else {

			uj.Parameters = []Parameter{}

			wantVal := true

			for {

				var tmp_uj__Parameters Parameter

				tok = fs.Scan()
				if tok == fflib.FFTok_error {
					goto tokerror
				}
				if tok == fflib.FFTok_right_brace {
					break
				}

				if tok == fflib.FFTok_comma {
					if wantVal == true {
						// TODO(pquerna): this isn't an ideal error message, this handles
						// things like [,,,] as an array value.
						return fs.WrapErr(fmt.Errorf("wanted value token, but got token: %v", tok))
					}
					continue
				} else {
					wantVal = true
				}

				/* handler: tmp_uj__Parameters type=mesos.Parameter kind=struct quoted=false*/

				{
					if tok == fflib.FFTok_null {

						state = fflib.FFParse_after_value
						goto mainparse
					}

					err = tmp_uj__Parameters.UnmarshalJSONFFLexer(fs, fflib.FFParse_want_key)
					if err != nil {
						return err
					}
					state = fflib.FFParse_after_value
				}

				uj.Parameters = append(uj.Parameters, tmp_uj__Parameters)

				wantVal = false
			}
		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_ForcePullImage:

	/* handler: uj.ForcePullImage type=bool kind=bool quoted=false*/

	{
		if tok != fflib.FFTok_bool && tok != fflib.FFTok_null {
			return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for bool", tok))
		}
	}

	{
		if tok == fflib.FFTok_null {

			uj.ForcePullImage = nil

		} else {
			tmpb := fs.Output.Bytes()

			var tval bool

			if bytes.Compare([]byte{'t', 'r', 'u', 'e'}, tmpb) == 0 {

				tval = true

			} else if bytes.Compare([]byte{'f', 'a', 'l', 's', 'e'}, tmpb) == 0 {

				tval = false

			} else {
				err = errors.New("unexpected bytes for true/false value")
				return fs.WrapErr(err)
			}

			uj.ForcePullImage = &tval

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_VolumeDriver:

	/* handler: uj.VolumeDriver type=string kind=string quoted=false*/

	{

		{
			if tok != fflib.FFTok_string && tok != fflib.FFTok_null {
				return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for string", tok))
			}
		}

		if tok == fflib.FFTok_null {

			uj.VolumeDriver = nil

		} else {

			var tval string
			outBuf := fs.Output.Bytes()

			tval = string(string(outBuf))
			uj.VolumeDriver = &tval

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

wantedvalue:
	return fs.WrapErr(fmt.Errorf("wanted value token, but got token: %v", tok))
wrongtokenerror:
	return fs.WrapErr(fmt.Errorf("ffjson: wanted token: %v, but got token: %v output=%s", wantedTok, tok, fs.Output.String()))
tokerror:
	if fs.BigError != nil {
		return fs.WrapErr(fs.BigError)
	}
	err = fs.Error.ToError()
	if err != nil {
		return fs.WrapErr(err)
	}
	panic("ffjson-generated: unreachable, please report bug.")
done:

	return nil
}

func (mj *ContainerInfo_DockerInfo_PortMapping) MarshalJSON() ([]byte, error) {
	var buf fflib.Buffer
	if mj == nil {
		buf.WriteString("null")
		return buf.Bytes(), nil
	}
	err := mj.MarshalJSONBuf(&buf)
	if err != nil {
		return nil, err
	}
	return buf.Bytes(), nil
}
func (mj *ContainerInfo_DockerInfo_PortMapping) MarshalJSONBuf(buf fflib.EncodingBuffer) error {
	if mj == nil {
		buf.WriteString("null")
		return nil
	}
	var err error
	var obj []byte
	_ = obj
	_ = err
	buf.WriteString(`{ "host_port":`)
	fflib.FormatBits2(buf, uint64(mj.HostPort), 10, false)
	buf.WriteString(`,"container_port":`)
	fflib.FormatBits2(buf, uint64(mj.ContainerPort), 10, false)
	buf.WriteByte(',')
	if mj.Protocol != nil {
		if true {
			buf.WriteString(`"protocol":`)
			fflib.WriteJsonString(buf, string(*mj.Protocol))
			buf.WriteByte(',')
		}
	}
	buf.Rewind(1)
	buf.WriteByte('}')
	return nil
}

const (
	ffj_t_ContainerInfo_DockerInfo_PortMappingbase = iota
	ffj_t_ContainerInfo_DockerInfo_PortMappingno_such_key

	ffj_t_ContainerInfo_DockerInfo_PortMapping_HostPort

	ffj_t_ContainerInfo_DockerInfo_PortMapping_ContainerPort

	ffj_t_ContainerInfo_DockerInfo_PortMapping_Protocol
)

var ffj_key_ContainerInfo_DockerInfo_PortMapping_HostPort = []byte("host_port")

var ffj_key_ContainerInfo_DockerInfo_PortMapping_ContainerPort = []byte("container_port")

var ffj_key_ContainerInfo_DockerInfo_PortMapping_Protocol = []byte("protocol")

func (uj *ContainerInfo_DockerInfo_PortMapping) UnmarshalJSON(input []byte) error {
	fs := fflib.NewFFLexer(input)
	return uj.UnmarshalJSONFFLexer(fs, fflib.FFParse_map_start)
}

func (uj *ContainerInfo_DockerInfo_PortMapping) UnmarshalJSONFFLexer(fs *fflib.FFLexer, state fflib.FFParseState) error {
	var err error = nil
	currentKey := ffj_t_ContainerInfo_DockerInfo_PortMappingbase
	_ = currentKey
	tok := fflib.FFTok_init
	wantedTok := fflib.FFTok_init

mainparse:
	for {
		tok = fs.Scan()
		//	println(fmt.Sprintf("debug: tok: %v  state: %v", tok, state))
		if tok == fflib.FFTok_error {
			goto tokerror
		}

		switch state {

		case fflib.FFParse_map_start:
			if tok != fflib.FFTok_left_bracket {
				wantedTok = fflib.FFTok_left_bracket
				goto wrongtokenerror
			}
			state = fflib.FFParse_want_key
			continue

		case fflib.FFParse_after_value:
			if tok == fflib.FFTok_comma {
				state = fflib.FFParse_want_key
			} else if tok == fflib.FFTok_right_bracket {
				goto done
			} else {
				wantedTok = fflib.FFTok_comma
				goto wrongtokenerror
			}

		case fflib.FFParse_want_key:
			// json {} ended. goto exit. woo.
			if tok == fflib.FFTok_right_bracket {
				goto done
			}
			if tok != fflib.FFTok_string {
				wantedTok = fflib.FFTok_string
				goto wrongtokenerror
			}

			kn := fs.Output.Bytes()
			if len(kn) <= 0 {
				// "" case. hrm.
				currentKey = ffj_t_ContainerInfo_DockerInfo_PortMappingno_such_key
				state = fflib.FFParse_want_colon
				goto mainparse
			} else {
				switch kn[0] {

				case 'c':

					if bytes.Equal(ffj_key_ContainerInfo_DockerInfo_PortMapping_ContainerPort, kn) {
						currentKey = ffj_t_ContainerInfo_DockerInfo_PortMapping_ContainerPort
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				case 'h':

					if bytes.Equal(ffj_key_ContainerInfo_DockerInfo_PortMapping_HostPort, kn) {
						currentKey = ffj_t_ContainerInfo_DockerInfo_PortMapping_HostPort
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				case 'p':

					if bytes.Equal(ffj_key_ContainerInfo_DockerInfo_PortMapping_Protocol, kn) {
						currentKey = ffj_t_ContainerInfo_DockerInfo_PortMapping_Protocol
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				}

				if fflib.SimpleLetterEqualFold(ffj_key_ContainerInfo_DockerInfo_PortMapping_Protocol, kn) {
					currentKey = ffj_t_ContainerInfo_DockerInfo_PortMapping_Protocol
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.AsciiEqualFold(ffj_key_ContainerInfo_DockerInfo_PortMapping_ContainerPort, kn) {
					currentKey = ffj_t_ContainerInfo_DockerInfo_PortMapping_ContainerPort
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffj_key_ContainerInfo_DockerInfo_PortMapping_HostPort, kn) {
					currentKey = ffj_t_ContainerInfo_DockerInfo_PortMapping_HostPort
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				currentKey = ffj_t_ContainerInfo_DockerInfo_PortMappingno_such_key
				state = fflib.FFParse_want_colon
				goto mainparse
			}

		case fflib.FFParse_want_colon:
			if tok != fflib.FFTok_colon {
				wantedTok = fflib.FFTok_colon
				goto wrongtokenerror
			}
			state = fflib.FFParse_want_value
			continue
		case fflib.FFParse_want_value:

			if tok == fflib.FFTok_left_brace || tok == fflib.FFTok_left_bracket || tok == fflib.FFTok_integer || tok == fflib.FFTok_double || tok == fflib.FFTok_string || tok == fflib.FFTok_bool || tok == fflib.FFTok_null {
				switch currentKey {

				case ffj_t_ContainerInfo_DockerInfo_PortMapping_HostPort:
					goto handle_HostPort

				case ffj_t_ContainerInfo_DockerInfo_PortMapping_ContainerPort:
					goto handle_ContainerPort

				case ffj_t_ContainerInfo_DockerInfo_PortMapping_Protocol:
					goto handle_Protocol

				case ffj_t_ContainerInfo_DockerInfo_PortMappingno_such_key:
					err = fs.SkipField(tok)
					if err != nil {
						return fs.WrapErr(err)
					}
					state = fflib.FFParse_after_value
					goto mainparse
				}
			} else {
				goto wantedvalue
			}
		}
	}

handle_HostPort:

	/* handler: uj.HostPort type=uint32 kind=uint32 quoted=false*/

	{
		if tok != fflib.FFTok_integer && tok != fflib.FFTok_null {
			return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for uint32", tok))
		}
	}

	{

		if tok == fflib.FFTok_null {

		} else {

			tval, err := fflib.ParseUint(fs.Output.Bytes(), 10, 32)

			if err != nil {
				return fs.WrapErr(err)
			}

			uj.HostPort = uint32(tval)

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_ContainerPort:

	/* handler: uj.ContainerPort type=uint32 kind=uint32 quoted=false*/

	{
		if tok != fflib.FFTok_integer && tok != fflib.FFTok_null {
			return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for uint32", tok))
		}
	}

	{

		if tok == fflib.FFTok_null {

		} else {

			tval, err := fflib.ParseUint(fs.Output.Bytes(), 10, 32)

			if err != nil {
				return fs.WrapErr(err)
			}

			uj.ContainerPort = uint32(tval)

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_Protocol:

	/* handler: uj.Protocol type=string kind=string quoted=false*/

	{

		{
			if tok != fflib.FFTok_string && tok != fflib.FFTok_null {
				return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for string", tok))
			}
		}

		if tok == fflib.FFTok_null {

			uj.Protocol = nil

		} else {

			var tval string
			outBuf := fs.Output.Bytes()

			tval = string(string(outBuf))
			uj.Protocol = &tval

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

wantedvalue:
	return fs.WrapErr(fmt.Errorf("wanted value token, but got token: %v", tok))
wrongtokenerror:
	return fs.WrapErr(fmt.Errorf("ffjson: wanted token: %v, but got token: %v output=%s", wantedTok, tok, fs.Output.String()))
tokerror:
	if fs.BigError != nil {
		return fs.WrapErr(fs.BigError)
	}
	err = fs.Error.ToError()
	if err != nil {
		return fs.WrapErr(err)
	}
	panic("ffjson-generated: unreachable, please report bug.")
done:

	return nil
}

func (mj *ContainerInfo_MesosInfo) MarshalJSON() ([]byte, error) {
	var buf fflib.Buffer
	if mj == nil {
		buf.WriteString("null")
		return buf.Bytes(), nil
	}
	err := mj.MarshalJSONBuf(&buf)
	if err != nil {
		return nil, err
	}
	return buf.Bytes(), nil
}
func (mj *ContainerInfo_MesosInfo) MarshalJSONBuf(buf fflib.EncodingBuffer) error {
	if mj == nil {
		buf.WriteString("null")
		return nil
	}
	var err error
	var obj []byte
	_ = obj
	_ = err
	buf.WriteString(`{ `)
	if mj.Image != nil {
		if true {
			buf.WriteString(`"image":`)

			{

				err = mj.Image.MarshalJSONBuf(buf)
				if err != nil {
					return err
				}

			}
			buf.WriteByte(',')
		}
	}
	buf.Rewind(1)
	buf.WriteByte('}')
	return nil
}

const (
	ffj_t_ContainerInfo_MesosInfobase = iota
	ffj_t_ContainerInfo_MesosInfono_such_key

	ffj_t_ContainerInfo_MesosInfo_Image
)

var ffj_key_ContainerInfo_MesosInfo_Image = []byte("image")

func (uj *ContainerInfo_MesosInfo) UnmarshalJSON(input []byte) error {
	fs := fflib.NewFFLexer(input)
	return uj.UnmarshalJSONFFLexer(fs, fflib.FFParse_map_start)
}

func (uj *ContainerInfo_MesosInfo) UnmarshalJSONFFLexer(fs *fflib.FFLexer, state fflib.FFParseState) error {
	var err error = nil
	currentKey := ffj_t_ContainerInfo_MesosInfobase
	_ = currentKey
	tok := fflib.FFTok_init
	wantedTok := fflib.FFTok_init

mainparse:
	for {
		tok = fs.Scan()
		//	println(fmt.Sprintf("debug: tok: %v  state: %v", tok, state))
		if tok == fflib.FFTok_error {
			goto tokerror
		}

		switch state {

		case fflib.FFParse_map_start:
			if tok != fflib.FFTok_left_bracket {
				wantedTok = fflib.FFTok_left_bracket
				goto wrongtokenerror
			}
			state = fflib.FFParse_want_key
			continue

		case fflib.FFParse_after_value:
			if tok == fflib.FFTok_comma {
				state = fflib.FFParse_want_key
			} else if tok == fflib.FFTok_right_bracket {
				goto done
			} else {
				wantedTok = fflib.FFTok_comma
				goto wrongtokenerror
			}

		case fflib.FFParse_want_key:
			// json {} ended. goto exit. woo.
			if tok == fflib.FFTok_right_bracket {
				goto done
			}
			if tok != fflib.FFTok_string {
				wantedTok = fflib.FFTok_string
				goto wrongtokenerror
			}

			kn := fs.Output.Bytes()
			if len(kn) <= 0 {
				// "" case. hrm.
				currentKey = ffj_t_ContainerInfo_MesosInfono_such_key
				state = fflib.FFParse_want_colon
				goto mainparse
			} else {
				switch kn[0] {

				case 'i':

					if bytes.Equal(ffj_key_ContainerInfo_MesosInfo_Image, kn) {
						currentKey = ffj_t_ContainerInfo_MesosInfo_Image
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				}

				if fflib.SimpleLetterEqualFold(ffj_key_ContainerInfo_MesosInfo_Image, kn) {
					currentKey = ffj_t_ContainerInfo_MesosInfo_Image
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				currentKey = ffj_t_ContainerInfo_MesosInfono_such_key
				state = fflib.FFParse_want_colon
				goto mainparse
			}

		case fflib.FFParse_want_colon:
			if tok != fflib.FFTok_colon {
				wantedTok = fflib.FFTok_colon
				goto wrongtokenerror
			}
			state = fflib.FFParse_want_value
			continue
		case fflib.FFParse_want_value:

			if tok == fflib.FFTok_left_brace || tok == fflib.FFTok_left_bracket || tok == fflib.FFTok_integer || tok == fflib.FFTok_double || tok == fflib.FFTok_string || tok == fflib.FFTok_bool || tok == fflib.FFTok_null {
				switch currentKey {

				case ffj_t_ContainerInfo_MesosInfo_Image:
					goto handle_Image

				case ffj_t_ContainerInfo_MesosInfono_such_key:
					err = fs.SkipField(tok)
					if err != nil {
						return fs.WrapErr(err)
					}
					state = fflib.FFParse_after_value
					goto mainparse
				}
			} else {
				goto wantedvalue
			}
		}
	}

handle_Image:

	/* handler: uj.Image type=mesos.Image kind=struct quoted=false*/

	{
		if tok == fflib.FFTok_null {

			uj.Image = nil

			state = fflib.FFParse_after_value
			goto mainparse
		}

		if uj.Image == nil {
			uj.Image = new(Image)
		}

		err = uj.Image.UnmarshalJSONFFLexer(fs, fflib.FFParse_want_key)
		if err != nil {
			return err
		}
		state = fflib.FFParse_after_value
	}

	state = fflib.FFParse_after_value
	goto mainparse

wantedvalue:
	return fs.WrapErr(fmt.Errorf("wanted value token, but got token: %v", tok))
wrongtokenerror:
	return fs.WrapErr(fmt.Errorf("ffjson: wanted token: %v, but got token: %v output=%s", wantedTok, tok, fs.Output.String()))
tokerror:
	if fs.BigError != nil {
		return fs.WrapErr(fs.BigError)
	}
	err = fs.Error.ToError()
	if err != nil {
		return fs.WrapErr(err)
	}
	panic("ffjson-generated: unreachable, please report bug.")
done:

	return nil
}

func (mj *ContainerStatus) MarshalJSON() ([]byte, error) {
	var buf fflib.Buffer
	if mj == nil {
		buf.WriteString("null")
		return buf.Bytes(), nil
	}
	err := mj.MarshalJSONBuf(&buf)
	if err != nil {
		return nil, err
	}
	return buf.Bytes(), nil
}
func (mj *ContainerStatus) MarshalJSONBuf(buf fflib.EncodingBuffer) error {
	if mj == nil {
		buf.WriteString("null")
		return nil
	}
	var err error
	var obj []byte
	_ = obj
	_ = err
	buf.WriteString(`{ `)
	if mj.ContainerID != nil {
		if true {
			buf.WriteString(`"container_id":`)

			{

				err = mj.ContainerID.MarshalJSONBuf(buf)
				if err != nil {
					return err
				}

			}
			buf.WriteByte(',')
		}
	}
	buf.WriteString(`"network_infos":`)
	if mj.NetworkInfos != nil {
		buf.WriteString(`[`)
		for i, v := range mj.NetworkInfos {
			if i != 0 {
				buf.WriteString(`,`)
			}

			{

				err = v.MarshalJSONBuf(buf)
				if err != nil {
					return err
				}

			}
		}
		buf.WriteString(`]`)
	} else {
		buf.WriteString(`null`)
	}
	buf.WriteByte(',')
	if mj.CgroupInfo != nil {
		if true {
			buf.WriteString(`"cgroup_info":`)

			{

				err = mj.CgroupInfo.MarshalJSONBuf(buf)
				if err != nil {
					return err
				}

			}
			buf.WriteByte(',')
		}
	}
	if mj.ExecutorPID != nil {
		if true {
			buf.WriteString(`"executor_pid":`)
			fflib.FormatBits2(buf, uint64(*mj.ExecutorPID), 10, false)
			buf.WriteByte(',')
		}
	}
	buf.Rewind(1)
	buf.WriteByte('}')
	return nil
}

const (
	ffj_t_ContainerStatusbase = iota
	ffj_t_ContainerStatusno_such_key

	ffj_t_ContainerStatus_ContainerID

	ffj_t_ContainerStatus_NetworkInfos

	ffj_t_ContainerStatus_CgroupInfo

	ffj_t_ContainerStatus_ExecutorPID
)

var ffj_key_ContainerStatus_ContainerID = []byte("container_id")

var ffj_key_ContainerStatus_NetworkInfos = []byte("network_infos")

var ffj_key_ContainerStatus_CgroupInfo = []byte("cgroup_info")

var ffj_key_ContainerStatus_ExecutorPID = []byte("executor_pid")

func (uj *ContainerStatus) UnmarshalJSON(input []byte) error {
	fs := fflib.NewFFLexer(input)
	return uj.UnmarshalJSONFFLexer(fs, fflib.FFParse_map_start)
}

func (uj *ContainerStatus) UnmarshalJSONFFLexer(fs *fflib.FFLexer, state fflib.FFParseState) error {
	var err error = nil
	currentKey := ffj_t_ContainerStatusbase
	_ = currentKey
	tok := fflib.FFTok_init
	wantedTok := fflib.FFTok_init

mainparse:
	for {
		tok = fs.Scan()
		//	println(fmt.Sprintf("debug: tok: %v  state: %v", tok, state))
		if tok == fflib.FFTok_error {
			goto tokerror
		}

		switch state {

		case fflib.FFParse_map_start:
			if tok != fflib.FFTok_left_bracket {
				wantedTok = fflib.FFTok_left_bracket
				goto wrongtokenerror
			}
			state = fflib.FFParse_want_key
			continue

		case fflib.FFParse_after_value:
			if tok == fflib.FFTok_comma {
				state = fflib.FFParse_want_key
			} else if tok == fflib.FFTok_right_bracket {
				goto done
			} else {
				wantedTok = fflib.FFTok_comma
				goto wrongtokenerror
			}

		case fflib.FFParse_want_key:
			// json {} ended. goto exit. woo.
			if tok == fflib.FFTok_right_bracket {
				goto done
			}
			if tok != fflib.FFTok_string {
				wantedTok = fflib.FFTok_string
				goto wrongtokenerror
			}

			kn := fs.Output.Bytes()
			if len(kn) <= 0 {
				// "" case. hrm.
				currentKey = ffj_t_ContainerStatusno_such_key
				state = fflib.FFParse_want_colon
				goto mainparse
			} else {
				switch kn[0] {

				case 'c':

					if bytes.Equal(ffj_key_ContainerStatus_ContainerID, kn) {
						currentKey = ffj_t_ContainerStatus_ContainerID
						state = fflib.FFParse_want_colon
						goto mainparse

					} else if bytes.Equal(ffj_key_ContainerStatus_CgroupInfo, kn) {
						currentKey = ffj_t_ContainerStatus_CgroupInfo
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				case 'e':

					if bytes.Equal(ffj_key_ContainerStatus_ExecutorPID, kn) {
						currentKey = ffj_t_ContainerStatus_ExecutorPID
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				case 'n':

					if bytes.Equal(ffj_key_ContainerStatus_NetworkInfos, kn) {
						currentKey = ffj_t_ContainerStatus_NetworkInfos
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				}

				if fflib.AsciiEqualFold(ffj_key_ContainerStatus_ExecutorPID, kn) {
					currentKey = ffj_t_ContainerStatus_ExecutorPID
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.AsciiEqualFold(ffj_key_ContainerStatus_CgroupInfo, kn) {
					currentKey = ffj_t_ContainerStatus_CgroupInfo
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffj_key_ContainerStatus_NetworkInfos, kn) {
					currentKey = ffj_t_ContainerStatus_NetworkInfos
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.AsciiEqualFold(ffj_key_ContainerStatus_ContainerID, kn) {
					currentKey = ffj_t_ContainerStatus_ContainerID
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				currentKey = ffj_t_ContainerStatusno_such_key
				state = fflib.FFParse_want_colon
				goto mainparse
			}

		case fflib.FFParse_want_colon:
			if tok != fflib.FFTok_colon {
				wantedTok = fflib.FFTok_colon
				goto wrongtokenerror
			}
			state = fflib.FFParse_want_value
			continue
		case fflib.FFParse_want_value:

			if tok == fflib.FFTok_left_brace || tok == fflib.FFTok_left_bracket || tok == fflib.FFTok_integer || tok == fflib.FFTok_double || tok == fflib.FFTok_string || tok == fflib.FFTok_bool || tok == fflib.FFTok_null {
				switch currentKey {

				case ffj_t_ContainerStatus_ContainerID:
					goto handle_ContainerID

				case ffj_t_ContainerStatus_NetworkInfos:
					goto handle_NetworkInfos

				case ffj_t_ContainerStatus_CgroupInfo:
					goto handle_CgroupInfo

				case ffj_t_ContainerStatus_ExecutorPID:
					goto handle_ExecutorPID

				case ffj_t_ContainerStatusno_such_key:
					err = fs.SkipField(tok)
					if err != nil {
						return fs.WrapErr(err)
					}
					state = fflib.FFParse_after_value
					goto mainparse
				}
			} else {
				goto wantedvalue
			}
		}
	}

handle_ContainerID:

	/* handler: uj.ContainerID type=mesos.ContainerID kind=struct quoted=false*/

	{
		if tok == fflib.FFTok_null {

			uj.ContainerID = nil

			state = fflib.FFParse_after_value
			goto mainparse
		}

		if uj.ContainerID == nil {
			uj.ContainerID = new(ContainerID)
		}

		err = uj.ContainerID.UnmarshalJSONFFLexer(fs, fflib.FFParse_want_key)
		if err != nil {
			return err
		}
		state = fflib.FFParse_after_value
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_NetworkInfos:

	/* handler: uj.NetworkInfos type=[]mesos.NetworkInfo kind=slice quoted=false*/

	{

		{
			if tok != fflib.FFTok_left_brace && tok != fflib.FFTok_null {
				return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for ", tok))
			}
		}

		if tok == fflib.FFTok_null {
			uj.NetworkInfos = nil
		} else {

			uj.NetworkInfos = []NetworkInfo{}

			wantVal := true

			for {

				var tmp_uj__NetworkInfos NetworkInfo

				tok = fs.Scan()
				if tok == fflib.FFTok_error {
					goto tokerror
				}
				if tok == fflib.FFTok_right_brace {
					break
				}

				if tok == fflib.FFTok_comma {
					if wantVal == true {
						// TODO(pquerna): this isn't an ideal error message, this handles
						// things like [,,,] as an array value.
						return fs.WrapErr(fmt.Errorf("wanted value token, but got token: %v", tok))
					}
					continue
				} else {
					wantVal = true
				}

				/* handler: tmp_uj__NetworkInfos type=mesos.NetworkInfo kind=struct quoted=false*/

				{
					if tok == fflib.FFTok_null {

						state = fflib.FFParse_after_value
						goto mainparse
					}

					err = tmp_uj__NetworkInfos.UnmarshalJSONFFLexer(fs, fflib.FFParse_want_key)
					if err != nil {
						return err
					}
					state = fflib.FFParse_after_value
				}

				uj.NetworkInfos = append(uj.NetworkInfos, tmp_uj__NetworkInfos)

				wantVal = false
			}
		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_CgroupInfo:

	/* handler: uj.CgroupInfo type=mesos.CgroupInfo kind=struct quoted=false*/

	{
		if tok == fflib.FFTok_null {

			uj.CgroupInfo = nil

			state = fflib.FFParse_after_value
			goto mainparse
		}

		if uj.CgroupInfo == nil {
			uj.CgroupInfo = new(CgroupInfo)
		}

		err = uj.CgroupInfo.UnmarshalJSONFFLexer(fs, fflib.FFParse_want_key)
		if err != nil {
			return err
		}
		state = fflib.FFParse_after_value
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_ExecutorPID:

	/* handler: uj.ExecutorPID type=uint32 kind=uint32 quoted=false*/

	{
		if tok != fflib.FFTok_integer && tok != fflib.FFTok_null {
			return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for uint32", tok))
		}
	}

	{

		if tok == fflib.FFTok_null {

			uj.ExecutorPID = nil

		} else {

			tval, err := fflib.ParseUint(fs.Output.Bytes(), 10, 32)

			if err != nil {
				return fs.WrapErr(err)
			}

			ttypval := uint32(tval)
			uj.ExecutorPID = &ttypval

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

wantedvalue:
	return fs.WrapErr(fmt.Errorf("wanted value token, but got token: %v", tok))
wrongtokenerror:
	return fs.WrapErr(fmt.Errorf("ffjson: wanted token: %v, but got token: %v output=%s", wantedTok, tok, fs.Output.String()))
tokerror:
	if fs.BigError != nil {
		return fs.WrapErr(fs.BigError)
	}
	err = fs.Error.ToError()
	if err != nil {
		return fs.WrapErr(err)
	}
	panic("ffjson-generated: unreachable, please report bug.")
done:

	return nil
}

func (mj *Credential) MarshalJSON() ([]byte, error) {
	var buf fflib.Buffer
	if mj == nil {
		buf.WriteString("null")
		return buf.Bytes(), nil
	}
	err := mj.MarshalJSONBuf(&buf)
	if err != nil {
		return nil, err
	}
	return buf.Bytes(), nil
}
func (mj *Credential) MarshalJSONBuf(buf fflib.EncodingBuffer) error {
	if mj == nil {
		buf.WriteString("null")
		return nil
	}
	var err error
	var obj []byte
	_ = obj
	_ = err
	buf.WriteString(`{ "principal":`)
	fflib.WriteJsonString(buf, string(mj.Principal))
	buf.WriteByte(',')
	if mj.Secret != nil {
		if true {
			buf.WriteString(`"secret":`)
			fflib.WriteJsonString(buf, string(*mj.Secret))
			buf.WriteByte(',')
		}
	}
	buf.Rewind(1)
	buf.WriteByte('}')
	return nil
}

const (
	ffj_t_Credentialbase = iota
	ffj_t_Credentialno_such_key

	ffj_t_Credential_Principal

	ffj_t_Credential_Secret
)

var ffj_key_Credential_Principal = []byte("principal")

var ffj_key_Credential_Secret = []byte("secret")

func (uj *Credential) UnmarshalJSON(input []byte) error {
	fs := fflib.NewFFLexer(input)
	return uj.UnmarshalJSONFFLexer(fs, fflib.FFParse_map_start)
}

func (uj *Credential) UnmarshalJSONFFLexer(fs *fflib.FFLexer, state fflib.FFParseState) error {
	var err error = nil
	currentKey := ffj_t_Credentialbase
	_ = currentKey
	tok := fflib.FFTok_init
	wantedTok := fflib.FFTok_init

mainparse:
	for {
		tok = fs.Scan()
		//	println(fmt.Sprintf("debug: tok: %v  state: %v", tok, state))
		if tok == fflib.FFTok_error {
			goto tokerror
		}

		switch state {

		case fflib.FFParse_map_start:
			if tok != fflib.FFTok_left_bracket {
				wantedTok = fflib.FFTok_left_bracket
				goto wrongtokenerror
			}
			state = fflib.FFParse_want_key
			continue

		case fflib.FFParse_after_value:
			if tok == fflib.FFTok_comma {
				state = fflib.FFParse_want_key
			} else if tok == fflib.FFTok_right_bracket {
				goto done
			} else {
				wantedTok = fflib.FFTok_comma
				goto wrongtokenerror
			}

		case fflib.FFParse_want_key:
			// json {} ended. goto exit. woo.
			if tok == fflib.FFTok_right_bracket {
				goto done
			}
			if tok != fflib.FFTok_string {
				wantedTok = fflib.FFTok_string
				goto wrongtokenerror
			}

			kn := fs.Output.Bytes()
			if len(kn) <= 0 {
				// "" case. hrm.
				currentKey = ffj_t_Credentialno_such_key
				state = fflib.FFParse_want_colon
				goto mainparse
			} else {
				switch kn[0] {

				case 'p':

					if bytes.Equal(ffj_key_Credential_Principal, kn) {
						currentKey = ffj_t_Credential_Principal
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				case 's':

					if bytes.Equal(ffj_key_Credential_Secret, kn) {
						currentKey = ffj_t_Credential_Secret
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				}

				if fflib.EqualFoldRight(ffj_key_Credential_Secret, kn) {
					currentKey = ffj_t_Credential_Secret
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.SimpleLetterEqualFold(ffj_key_Credential_Principal, kn) {
					currentKey = ffj_t_Credential_Principal
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				currentKey = ffj_t_Credentialno_such_key
				state = fflib.FFParse_want_colon
				goto mainparse
			}

		case fflib.FFParse_want_colon:
			if tok != fflib.FFTok_colon {
				wantedTok = fflib.FFTok_colon
				goto wrongtokenerror
			}
			state = fflib.FFParse_want_value
			continue
		case fflib.FFParse_want_value:

			if tok == fflib.FFTok_left_brace || tok == fflib.FFTok_left_bracket || tok == fflib.FFTok_integer || tok == fflib.FFTok_double || tok == fflib.FFTok_string || tok == fflib.FFTok_bool || tok == fflib.FFTok_null {
				switch currentKey {

				case ffj_t_Credential_Principal:
					goto handle_Principal

				case ffj_t_Credential_Secret:
					goto handle_Secret

				case ffj_t_Credentialno_such_key:
					err = fs.SkipField(tok)
					if err != nil {
						return fs.WrapErr(err)
					}
					state = fflib.FFParse_after_value
					goto mainparse
				}
			} else {
				goto wantedvalue
			}
		}
	}

handle_Principal:

	/* handler: uj.Principal type=string kind=string quoted=false*/

	{

		{
			if tok != fflib.FFTok_string && tok != fflib.FFTok_null {
				return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for string", tok))
			}
		}

		if tok == fflib.FFTok_null {

		} else {

			outBuf := fs.Output.Bytes()

			uj.Principal = string(string(outBuf))

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_Secret:

	/* handler: uj.Secret type=string kind=string quoted=false*/

	{

		{
			if tok != fflib.FFTok_string && tok != fflib.FFTok_null {
				return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for string", tok))
			}
		}

		if tok == fflib.FFTok_null {

			uj.Secret = nil

		} else {

			var tval string
			outBuf := fs.Output.Bytes()

			tval = string(string(outBuf))
			uj.Secret = &tval

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

wantedvalue:
	return fs.WrapErr(fmt.Errorf("wanted value token, but got token: %v", tok))
wrongtokenerror:
	return fs.WrapErr(fmt.Errorf("ffjson: wanted token: %v, but got token: %v output=%s", wantedTok, tok, fs.Output.String()))
tokerror:
	if fs.BigError != nil {
		return fs.WrapErr(fs.BigError)
	}
	err = fs.Error.ToError()
	if err != nil {
		return fs.WrapErr(err)
	}
	panic("ffjson-generated: unreachable, please report bug.")
done:

	return nil
}

func (mj *Credentials) MarshalJSON() ([]byte, error) {
	var buf fflib.Buffer
	if mj == nil {
		buf.WriteString("null")
		return buf.Bytes(), nil
	}
	err := mj.MarshalJSONBuf(&buf)
	if err != nil {
		return nil, err
	}
	return buf.Bytes(), nil
}
func (mj *Credentials) MarshalJSONBuf(buf fflib.EncodingBuffer) error {
	if mj == nil {
		buf.WriteString("null")
		return nil
	}
	var err error
	var obj []byte
	_ = obj
	_ = err
	buf.WriteString(`{"credentials":`)
	if mj.Credentials != nil {
		buf.WriteString(`[`)
		for i, v := range mj.Credentials {
			if i != 0 {
				buf.WriteString(`,`)
			}

			{

				err = v.MarshalJSONBuf(buf)
				if err != nil {
					return err
				}

			}
		}
		buf.WriteString(`]`)
	} else {
		buf.WriteString(`null`)
	}
	buf.WriteByte('}')
	return nil
}

const (
	ffj_t_Credentialsbase = iota
	ffj_t_Credentialsno_such_key

	ffj_t_Credentials_Credentials
)

var ffj_key_Credentials_Credentials = []byte("credentials")

func (uj *Credentials) UnmarshalJSON(input []byte) error {
	fs := fflib.NewFFLexer(input)
	return uj.UnmarshalJSONFFLexer(fs, fflib.FFParse_map_start)
}

func (uj *Credentials) UnmarshalJSONFFLexer(fs *fflib.FFLexer, state fflib.FFParseState) error {
	var err error = nil
	currentKey := ffj_t_Credentialsbase
	_ = currentKey
	tok := fflib.FFTok_init
	wantedTok := fflib.FFTok_init

mainparse:
	for {
		tok = fs.Scan()
		//	println(fmt.Sprintf("debug: tok: %v  state: %v", tok, state))
		if tok == fflib.FFTok_error {
			goto tokerror
		}

		switch state {

		case fflib.FFParse_map_start:
			if tok != fflib.FFTok_left_bracket {
				wantedTok = fflib.FFTok_left_bracket
				goto wrongtokenerror
			}
			state = fflib.FFParse_want_key
			continue

		case fflib.FFParse_after_value:
			if tok == fflib.FFTok_comma {
				state = fflib.FFParse_want_key
			} else if tok == fflib.FFTok_right_bracket {
				goto done
			} else {
				wantedTok = fflib.FFTok_comma
				goto wrongtokenerror
			}

		case fflib.FFParse_want_key:
			// json {} ended. goto exit. woo.
			if tok == fflib.FFTok_right_bracket {
				goto done
			}
			if tok != fflib.FFTok_string {
				wantedTok = fflib.FFTok_string
				goto wrongtokenerror
			}

			kn := fs.Output.Bytes()
			if len(kn) <= 0 {
				// "" case. hrm.
				currentKey = ffj_t_Credentialsno_such_key
				state = fflib.FFParse_want_colon
				goto mainparse
			} else {
				switch kn[0] {

				case 'c':

					if bytes.Equal(ffj_key_Credentials_Credentials, kn) {
						currentKey = ffj_t_Credentials_Credentials
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				}

				if fflib.EqualFoldRight(ffj_key_Credentials_Credentials, kn) {
					currentKey = ffj_t_Credentials_Credentials
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				currentKey = ffj_t_Credentialsno_such_key
				state = fflib.FFParse_want_colon
				goto mainparse
			}

		case fflib.FFParse_want_colon:
			if tok != fflib.FFTok_colon {
				wantedTok = fflib.FFTok_colon
				goto wrongtokenerror
			}
			state = fflib.FFParse_want_value
			continue
		case fflib.FFParse_want_value:

			if tok == fflib.FFTok_left_brace || tok == fflib.FFTok_left_bracket || tok == fflib.FFTok_integer || tok == fflib.FFTok_double || tok == fflib.FFTok_string || tok == fflib.FFTok_bool || tok == fflib.FFTok_null {
				switch currentKey {

				case ffj_t_Credentials_Credentials:
					goto handle_Credentials

				case ffj_t_Credentialsno_such_key:
					err = fs.SkipField(tok)
					if err != nil {
						return fs.WrapErr(err)
					}
					state = fflib.FFParse_after_value
					goto mainparse
				}
			} else {
				goto wantedvalue
			}
		}
	}

handle_Credentials:

	/* handler: uj.Credentials type=[]mesos.Credential kind=slice quoted=false*/

	{

		{
			if tok != fflib.FFTok_left_brace && tok != fflib.FFTok_null {
				return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for ", tok))
			}
		}

		if tok == fflib.FFTok_null {
			uj.Credentials = nil
		} else {

			uj.Credentials = []Credential{}

			wantVal := true

			for {

				var tmp_uj__Credentials Credential

				tok = fs.Scan()
				if tok == fflib.FFTok_error {
					goto tokerror
				}
				if tok == fflib.FFTok_right_brace {
					break
				}

				if tok == fflib.FFTok_comma {
					if wantVal == true {
						// TODO(pquerna): this isn't an ideal error message, this handles
						// things like [,,,] as an array value.
						return fs.WrapErr(fmt.Errorf("wanted value token, but got token: %v", tok))
					}
					continue
				} else {
					wantVal = true
				}

				/* handler: tmp_uj__Credentials type=mesos.Credential kind=struct quoted=false*/

				{
					if tok == fflib.FFTok_null {

						state = fflib.FFParse_after_value
						goto mainparse
					}

					err = tmp_uj__Credentials.UnmarshalJSONFFLexer(fs, fflib.FFParse_want_key)
					if err != nil {
						return err
					}
					state = fflib.FFParse_after_value
				}

				uj.Credentials = append(uj.Credentials, tmp_uj__Credentials)

				wantVal = false
			}
		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

wantedvalue:
	return fs.WrapErr(fmt.Errorf("wanted value token, but got token: %v", tok))
wrongtokenerror:
	return fs.WrapErr(fmt.Errorf("ffjson: wanted token: %v, but got token: %v output=%s", wantedTok, tok, fs.Output.String()))
tokerror:
	if fs.BigError != nil {
		return fs.WrapErr(fs.BigError)
	}
	err = fs.Error.ToError()
	if err != nil {
		return fs.WrapErr(err)
	}
	panic("ffjson-generated: unreachable, please report bug.")
done:

	return nil
}

func (mj *Device) MarshalJSON() ([]byte, error) {
	var buf fflib.Buffer
	if mj == nil {
		buf.WriteString("null")
		return buf.Bytes(), nil
	}
	err := mj.MarshalJSONBuf(&buf)
	if err != nil {
		return nil, err
	}
	return buf.Bytes(), nil
}
func (mj *Device) MarshalJSONBuf(buf fflib.EncodingBuffer) error {
	if mj == nil {
		buf.WriteString("null")
		return nil
	}
	var err error
	var obj []byte
	_ = obj
	_ = err
	buf.WriteString(`{ `)
	if mj.Path != nil {
		if true {
			buf.WriteString(`"path":`)
			fflib.WriteJsonString(buf, string(*mj.Path))
			buf.WriteByte(',')
		}
	}
	if mj.Number != nil {
		if true {
			buf.WriteString(`"number":`)

			{

				err = mj.Number.MarshalJSONBuf(buf)
				if err != nil {
					return err
				}

			}
			buf.WriteByte(',')
		}
	}
	buf.Rewind(1)
	buf.WriteByte('}')
	return nil
}

const (
	ffj_t_Devicebase = iota
	ffj_t_Deviceno_such_key

	ffj_t_Device_Path

	ffj_t_Device_Number
)

var ffj_key_Device_Path = []byte("path")

var ffj_key_Device_Number = []byte("number")

func (uj *Device) UnmarshalJSON(input []byte) error {
	fs := fflib.NewFFLexer(input)
	return uj.UnmarshalJSONFFLexer(fs, fflib.FFParse_map_start)
}

func (uj *Device) UnmarshalJSONFFLexer(fs *fflib.FFLexer, state fflib.FFParseState) error {
	var err error = nil
	currentKey := ffj_t_Devicebase
	_ = currentKey
	tok := fflib.FFTok_init
	wantedTok := fflib.FFTok_init

mainparse:
	for {
		tok = fs.Scan()
		//	println(fmt.Sprintf("debug: tok: %v  state: %v", tok, state))
		if tok == fflib.FFTok_error {
			goto tokerror
		}

		switch state {

		case fflib.FFParse_map_start:
			if tok != fflib.FFTok_left_bracket {
				wantedTok = fflib.FFTok_left_bracket
				goto wrongtokenerror
			}
			state = fflib.FFParse_want_key
			continue

		case fflib.FFParse_after_value:
			if tok == fflib.FFTok_comma {
				state = fflib.FFParse_want_key
			} else if tok == fflib.FFTok_right_bracket {
				goto done
			} else {
				wantedTok = fflib.FFTok_comma
				goto wrongtokenerror
			}

		case fflib.FFParse_want_key:
			// json {} ended. goto exit. woo.
			if tok == fflib.FFTok_right_bracket {
				goto done
			}
			if tok != fflib.FFTok_string {
				wantedTok = fflib.FFTok_string
				goto wrongtokenerror
			}

			kn := fs.Output.Bytes()
			if len(kn) <= 0 {
				// "" case. hrm.
				currentKey = ffj_t_Deviceno_such_key
				state = fflib.FFParse_want_colon
				goto mainparse
			} else {
				switch kn[0] {

				case 'n':

					if bytes.Equal(ffj_key_Device_Number, kn) {
						currentKey = ffj_t_Device_Number
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				case 'p':

					if bytes.Equal(ffj_key_Device_Path, kn) {
						currentKey = ffj_t_Device_Path
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				}

				if fflib.SimpleLetterEqualFold(ffj_key_Device_Number, kn) {
					currentKey = ffj_t_Device_Number
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.SimpleLetterEqualFold(ffj_key_Device_Path, kn) {
					currentKey = ffj_t_Device_Path
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				currentKey = ffj_t_Deviceno_such_key
				state = fflib.FFParse_want_colon
				goto mainparse
			}

		case fflib.FFParse_want_colon:
			if tok != fflib.FFTok_colon {
				wantedTok = fflib.FFTok_colon
				goto wrongtokenerror
			}
			state = fflib.FFParse_want_value
			continue
		case fflib.FFParse_want_value:

			if tok == fflib.FFTok_left_brace || tok == fflib.FFTok_left_bracket || tok == fflib.FFTok_integer || tok == fflib.FFTok_double || tok == fflib.FFTok_string || tok == fflib.FFTok_bool || tok == fflib.FFTok_null {
				switch currentKey {

				case ffj_t_Device_Path:
					goto handle_Path

				case ffj_t_Device_Number:
					goto handle_Number

				case ffj_t_Deviceno_such_key:
					err = fs.SkipField(tok)
					if err != nil {
						return fs.WrapErr(err)
					}
					state = fflib.FFParse_after_value
					goto mainparse
				}
			} else {
				goto wantedvalue
			}
		}
	}

handle_Path:

	/* handler: uj.Path type=string kind=string quoted=false*/

	{

		{
			if tok != fflib.FFTok_string && tok != fflib.FFTok_null {
				return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for string", tok))
			}
		}

		if tok == fflib.FFTok_null {

			uj.Path = nil

		} else {

			var tval string
			outBuf := fs.Output.Bytes()

			tval = string(string(outBuf))
			uj.Path = &tval

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_Number:

	/* handler: uj.Number type=mesos.Device_Number kind=struct quoted=false*/

	{
		if tok == fflib.FFTok_null {

			uj.Number = nil

			state = fflib.FFParse_after_value
			goto mainparse
		}

		if uj.Number == nil {
			uj.Number = new(Device_Number)
		}

		err = uj.Number.UnmarshalJSONFFLexer(fs, fflib.FFParse_want_key)
		if err != nil {
			return err
		}
		state = fflib.FFParse_after_value
	}

	state = fflib.FFParse_after_value
	goto mainparse

wantedvalue:
	return fs.WrapErr(fmt.Errorf("wanted value token, but got token: %v", tok))
wrongtokenerror:
	return fs.WrapErr(fmt.Errorf("ffjson: wanted token: %v, but got token: %v output=%s", wantedTok, tok, fs.Output.String()))
tokerror:
	if fs.BigError != nil {
		return fs.WrapErr(fs.BigError)
	}
	err = fs.Error.ToError()
	if err != nil {
		return fs.WrapErr(err)
	}
	panic("ffjson-generated: unreachable, please report bug.")
done:

	return nil
}

func (mj *DeviceAccess) MarshalJSON() ([]byte, error) {
	var buf fflib.Buffer
	if mj == nil {
		buf.WriteString("null")
		return buf.Bytes(), nil
	}
	err := mj.MarshalJSONBuf(&buf)
	if err != nil {
		return nil, err
	}
	return buf.Bytes(), nil
}
func (mj *DeviceAccess) MarshalJSONBuf(buf fflib.EncodingBuffer) error {
	if mj == nil {
		buf.WriteString("null")
		return nil
	}
	var err error
	var obj []byte
	_ = obj
	_ = err
	buf.WriteString(`{"device":`)

	{

		err = mj.Device.MarshalJSONBuf(buf)
		if err != nil {
			return err
		}

	}
	buf.WriteString(`,"access":`)

	{

		err = mj.Access.MarshalJSONBuf(buf)
		if err != nil {
			return err
		}

	}
	buf.WriteByte('}')
	return nil
}

const (
	ffj_t_DeviceAccessbase = iota
	ffj_t_DeviceAccessno_such_key

	ffj_t_DeviceAccess_Device

	ffj_t_DeviceAccess_Access
)

var ffj_key_DeviceAccess_Device = []byte("device")

var ffj_key_DeviceAccess_Access = []byte("access")

func (uj *DeviceAccess) UnmarshalJSON(input []byte) error {
	fs := fflib.NewFFLexer(input)
	return uj.UnmarshalJSONFFLexer(fs, fflib.FFParse_map_start)
}

func (uj *DeviceAccess) UnmarshalJSONFFLexer(fs *fflib.FFLexer, state fflib.FFParseState) error {
	var err error = nil
	currentKey := ffj_t_DeviceAccessbase
	_ = currentKey
	tok := fflib.FFTok_init
	wantedTok := fflib.FFTok_init

mainparse:
	for {
		tok = fs.Scan()
		//	println(fmt.Sprintf("debug: tok: %v  state: %v", tok, state))
		if tok == fflib.FFTok_error {
			goto tokerror
		}

		switch state {

		case fflib.FFParse_map_start:
			if tok != fflib.FFTok_left_bracket {
				wantedTok = fflib.FFTok_left_bracket
				goto wrongtokenerror
			}
			state = fflib.FFParse_want_key
			continue

		case fflib.FFParse_after_value:
			if tok == fflib.FFTok_comma {
				state = fflib.FFParse_want_key
			} else if tok == fflib.FFTok_right_bracket {
				goto done
			} else {
				wantedTok = fflib.FFTok_comma
				goto wrongtokenerror
			}

		case fflib.FFParse_want_key:
			// json {} ended. goto exit. woo.
			if tok == fflib.FFTok_right_bracket {
				goto done
			}
			if tok != fflib.FFTok_string {
				wantedTok = fflib.FFTok_string
				goto wrongtokenerror
			}

			kn := fs.Output.Bytes()
			if len(kn) <= 0 {
				// "" case. hrm.
				currentKey = ffj_t_DeviceAccessno_such_key
				state = fflib.FFParse_want_colon
				goto mainparse
			} else {
				switch kn[0] {

				case 'a':

					if bytes.Equal(ffj_key_DeviceAccess_Access, kn) {
						currentKey = ffj_t_DeviceAccess_Access
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				case 'd':

					if bytes.Equal(ffj_key_DeviceAccess_Device, kn) {
						currentKey = ffj_t_DeviceAccess_Device
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				}

				if fflib.EqualFoldRight(ffj_key_DeviceAccess_Access, kn) {
					currentKey = ffj_t_DeviceAccess_Access
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.SimpleLetterEqualFold(ffj_key_DeviceAccess_Device, kn) {
					currentKey = ffj_t_DeviceAccess_Device
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				currentKey = ffj_t_DeviceAccessno_such_key
				state = fflib.FFParse_want_colon
				goto mainparse
			}

		case fflib.FFParse_want_colon:
			if tok != fflib.FFTok_colon {
				wantedTok = fflib.FFTok_colon
				goto wrongtokenerror
			}
			state = fflib.FFParse_want_value
			continue
		case fflib.FFParse_want_value:

			if tok == fflib.FFTok_left_brace || tok == fflib.FFTok_left_bracket || tok == fflib.FFTok_integer || tok == fflib.FFTok_double || tok == fflib.FFTok_string || tok == fflib.FFTok_bool || tok == fflib.FFTok_null {
				switch currentKey {

				case ffj_t_DeviceAccess_Device:
					goto handle_Device

				case ffj_t_DeviceAccess_Access:
					goto handle_Access

				case ffj_t_DeviceAccessno_such_key:
					err = fs.SkipField(tok)
					if err != nil {
						return fs.WrapErr(err)
					}
					state = fflib.FFParse_after_value
					goto mainparse
				}
			} else {
				goto wantedvalue
			}
		}
	}

handle_Device:

	/* handler: uj.Device type=mesos.Device kind=struct quoted=false*/

	{
		if tok == fflib.FFTok_null {

			state = fflib.FFParse_after_value
			goto mainparse
		}

		err = uj.Device.UnmarshalJSONFFLexer(fs, fflib.FFParse_want_key)
		if err != nil {
			return err
		}
		state = fflib.FFParse_after_value
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_Access:

	/* handler: uj.Access type=mesos.DeviceAccess_Access kind=struct quoted=false*/

	{
		if tok == fflib.FFTok_null {

			state = fflib.FFParse_after_value
			goto mainparse
		}

		err = uj.Access.UnmarshalJSONFFLexer(fs, fflib.FFParse_want_key)
		if err != nil {
			return err
		}
		state = fflib.FFParse_after_value
	}

	state = fflib.FFParse_after_value
	goto mainparse

wantedvalue:
	return fs.WrapErr(fmt.Errorf("wanted value token, but got token: %v", tok))
wrongtokenerror:
	return fs.WrapErr(fmt.Errorf("ffjson: wanted token: %v, but got token: %v output=%s", wantedTok, tok, fs.Output.String()))
tokerror:
	if fs.BigError != nil {
		return fs.WrapErr(fs.BigError)
	}
	err = fs.Error.ToError()
	if err != nil {
		return fs.WrapErr(err)
	}
	panic("ffjson-generated: unreachable, please report bug.")
done:

	return nil
}

func (mj *DeviceAccess_Access) MarshalJSON() ([]byte, error) {
	var buf fflib.Buffer
	if mj == nil {
		buf.WriteString("null")
		return buf.Bytes(), nil
	}
	err := mj.MarshalJSONBuf(&buf)
	if err != nil {
		return nil, err
	}
	return buf.Bytes(), nil
}
func (mj *DeviceAccess_Access) MarshalJSONBuf(buf fflib.EncodingBuffer) error {
	if mj == nil {
		buf.WriteString("null")
		return nil
	}
	var err error
	var obj []byte
	_ = obj
	_ = err
	buf.WriteString(`{ `)
	if mj.Read != nil {
		if true {
			if *mj.Read {
				buf.WriteString(`"read":true`)
			} else {
				buf.WriteString(`"read":false`)
			}
			buf.WriteByte(',')
		}
	}
	if mj.Write != nil {
		if true {
			if *mj.Write {
				buf.WriteString(`"write":true`)
			} else {
				buf.WriteString(`"write":false`)
			}
			buf.WriteByte(',')
		}
	}
	if mj.Mknod != nil {
		if true {
			if *mj.Mknod {
				buf.WriteString(`"mknod":true`)
			} else {
				buf.WriteString(`"mknod":false`)
			}
			buf.WriteByte(',')
		}
	}
	buf.Rewind(1)
	buf.WriteByte('}')
	return nil
}

const (
	ffj_t_DeviceAccess_Accessbase = iota
	ffj_t_DeviceAccess_Accessno_such_key

	ffj_t_DeviceAccess_Access_Read

	ffj_t_DeviceAccess_Access_Write

	ffj_t_DeviceAccess_Access_Mknod
)

var ffj_key_DeviceAccess_Access_Read = []byte("read")

var ffj_key_DeviceAccess_Access_Write = []byte("write")

var ffj_key_DeviceAccess_Access_Mknod = []byte("mknod")

func (uj *DeviceAccess_Access) UnmarshalJSON(input []byte) error {
	fs := fflib.NewFFLexer(input)
	return uj.UnmarshalJSONFFLexer(fs, fflib.FFParse_map_start)
}

func (uj *DeviceAccess_Access) UnmarshalJSONFFLexer(fs *fflib.FFLexer, state fflib.FFParseState) error {
	var err error = nil
	currentKey := ffj_t_DeviceAccess_Accessbase
	_ = currentKey
	tok := fflib.FFTok_init
	wantedTok := fflib.FFTok_init

mainparse:
	for {
		tok = fs.Scan()
		//	println(fmt.Sprintf("debug: tok: %v  state: %v", tok, state))
		if tok == fflib.FFTok_error {
			goto tokerror
		}

		switch state {

		case fflib.FFParse_map_start:
			if tok != fflib.FFTok_left_bracket {
				wantedTok = fflib.FFTok_left_bracket
				goto wrongtokenerror
			}
			state = fflib.FFParse_want_key
			continue

		case fflib.FFParse_after_value:
			if tok == fflib.FFTok_comma {
				state = fflib.FFParse_want_key
			} else if tok == fflib.FFTok_right_bracket {
				goto done
			} else {
				wantedTok = fflib.FFTok_comma
				goto wrongtokenerror
			}

		case fflib.FFParse_want_key:
			// json {} ended. goto exit. woo.
			if tok == fflib.FFTok_right_bracket {
				goto done
			}
			if tok != fflib.FFTok_string {
				wantedTok = fflib.FFTok_string
				goto wrongtokenerror
			}

			kn := fs.Output.Bytes()
			if len(kn) <= 0 {
				// "" case. hrm.
				currentKey = ffj_t_DeviceAccess_Accessno_such_key
				state = fflib.FFParse_want_colon
				goto mainparse
			} else {
				switch kn[0] {

				case 'm':

					if bytes.Equal(ffj_key_DeviceAccess_Access_Mknod, kn) {
						currentKey = ffj_t_DeviceAccess_Access_Mknod
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				case 'r':

					if bytes.Equal(ffj_key_DeviceAccess_Access_Read, kn) {
						currentKey = ffj_t_DeviceAccess_Access_Read
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				case 'w':

					if bytes.Equal(ffj_key_DeviceAccess_Access_Write, kn) {
						currentKey = ffj_t_DeviceAccess_Access_Write
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				}

				if fflib.EqualFoldRight(ffj_key_DeviceAccess_Access_Mknod, kn) {
					currentKey = ffj_t_DeviceAccess_Access_Mknod
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.SimpleLetterEqualFold(ffj_key_DeviceAccess_Access_Write, kn) {
					currentKey = ffj_t_DeviceAccess_Access_Write
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.SimpleLetterEqualFold(ffj_key_DeviceAccess_Access_Read, kn) {
					currentKey = ffj_t_DeviceAccess_Access_Read
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				currentKey = ffj_t_DeviceAccess_Accessno_such_key
				state = fflib.FFParse_want_colon
				goto mainparse
			}

		case fflib.FFParse_want_colon:
			if tok != fflib.FFTok_colon {
				wantedTok = fflib.FFTok_colon
				goto wrongtokenerror
			}
			state = fflib.FFParse_want_value
			continue
		case fflib.FFParse_want_value:

			if tok == fflib.FFTok_left_brace || tok == fflib.FFTok_left_bracket || tok == fflib.FFTok_integer || tok == fflib.FFTok_double || tok == fflib.FFTok_string || tok == fflib.FFTok_bool || tok == fflib.FFTok_null {
				switch currentKey {

				case ffj_t_DeviceAccess_Access_Read:
					goto handle_Read

				case ffj_t_DeviceAccess_Access_Write:
					goto handle_Write

				case ffj_t_DeviceAccess_Access_Mknod:
					goto handle_Mknod

				case ffj_t_DeviceAccess_Accessno_such_key:
					err = fs.SkipField(tok)
					if err != nil {
						return fs.WrapErr(err)
					}
					state = fflib.FFParse_after_value
					goto mainparse
				}
			} else {
				goto wantedvalue
			}
		}
	}

handle_Read:

	/* handler: uj.Read type=bool kind=bool quoted=false*/

	{
		if tok != fflib.FFTok_bool && tok != fflib.FFTok_null {
			return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for bool", tok))
		}
	}

	{
		if tok == fflib.FFTok_null {

			uj.Read = nil

		} else {
			tmpb := fs.Output.Bytes()

			var tval bool

			if bytes.Compare([]byte{'t', 'r', 'u', 'e'}, tmpb) == 0 {

				tval = true

			} else if bytes.Compare([]byte{'f', 'a', 'l', 's', 'e'}, tmpb) == 0 {

				tval = false

			} else {
				err = errors.New("unexpected bytes for true/false value")
				return fs.WrapErr(err)
			}

			uj.Read = &tval

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_Write:

	/* handler: uj.Write type=bool kind=bool quoted=false*/

	{
		if tok != fflib.FFTok_bool && tok != fflib.FFTok_null {
			return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for bool", tok))
		}
	}

	{
		if tok == fflib.FFTok_null {

			uj.Write = nil

		} else {
			tmpb := fs.Output.Bytes()

			var tval bool

			if bytes.Compare([]byte{'t', 'r', 'u', 'e'}, tmpb) == 0 {

				tval = true

			} else if bytes.Compare([]byte{'f', 'a', 'l', 's', 'e'}, tmpb) == 0 {

				tval = false

			} else {
				err = errors.New("unexpected bytes for true/false value")
				return fs.WrapErr(err)
			}

			uj.Write = &tval

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_Mknod:

	/* handler: uj.Mknod type=bool kind=bool quoted=false*/

	{
		if tok != fflib.FFTok_bool && tok != fflib.FFTok_null {
			return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for bool", tok))
		}
	}

	{
		if tok == fflib.FFTok_null {

			uj.Mknod = nil

		} else {
			tmpb := fs.Output.Bytes()

			var tval bool

			if bytes.Compare([]byte{'t', 'r', 'u', 'e'}, tmpb) == 0 {

				tval = true

			} else if bytes.Compare([]byte{'f', 'a', 'l', 's', 'e'}, tmpb) == 0 {

				tval = false

			} else {
				err = errors.New("unexpected bytes for true/false value")
				return fs.WrapErr(err)
			}

			uj.Mknod = &tval

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

wantedvalue:
	return fs.WrapErr(fmt.Errorf("wanted value token, but got token: %v", tok))
wrongtokenerror:
	return fs.WrapErr(fmt.Errorf("ffjson: wanted token: %v, but got token: %v output=%s", wantedTok, tok, fs.Output.String()))
tokerror:
	if fs.BigError != nil {
		return fs.WrapErr(fs.BigError)
	}
	err = fs.Error.ToError()
	if err != nil {
		return fs.WrapErr(err)
	}
	panic("ffjson-generated: unreachable, please report bug.")
done:

	return nil
}

func (mj *DeviceWhitelist) MarshalJSON() ([]byte, error) {
	var buf fflib.Buffer
	if mj == nil {
		buf.WriteString("null")
		return buf.Bytes(), nil
	}
	err := mj.MarshalJSONBuf(&buf)
	if err != nil {
		return nil, err
	}
	return buf.Bytes(), nil
}
func (mj *DeviceWhitelist) MarshalJSONBuf(buf fflib.EncodingBuffer) error {
	if mj == nil {
		buf.WriteString("null")
		return nil
	}
	var err error
	var obj []byte
	_ = obj
	_ = err
	buf.WriteString(`{"allowed_devices":`)
	if mj.AllowedDevices != nil {
		buf.WriteString(`[`)
		for i, v := range mj.AllowedDevices {
			if i != 0 {
				buf.WriteString(`,`)
			}

			{

				err = v.MarshalJSONBuf(buf)
				if err != nil {
					return err
				}

			}
		}
		buf.WriteString(`]`)
	} else {
		buf.WriteString(`null`)
	}
	buf.WriteByte('}')
	return nil
}

const (
	ffj_t_DeviceWhitelistbase = iota
	ffj_t_DeviceWhitelistno_such_key

	ffj_t_DeviceWhitelist_AllowedDevices
)

var ffj_key_DeviceWhitelist_AllowedDevices = []byte("allowed_devices")

func (uj *DeviceWhitelist) UnmarshalJSON(input []byte) error {
	fs := fflib.NewFFLexer(input)
	return uj.UnmarshalJSONFFLexer(fs, fflib.FFParse_map_start)
}

func (uj *DeviceWhitelist) UnmarshalJSONFFLexer(fs *fflib.FFLexer, state fflib.FFParseState) error {
	var err error = nil
	currentKey := ffj_t_DeviceWhitelistbase
	_ = currentKey
	tok := fflib.FFTok_init
	wantedTok := fflib.FFTok_init

mainparse:
	for {
		tok = fs.Scan()
		//	println(fmt.Sprintf("debug: tok: %v  state: %v", tok, state))
		if tok == fflib.FFTok_error {
			goto tokerror
		}

		switch state {

		case fflib.FFParse_map_start:
			if tok != fflib.FFTok_left_bracket {
				wantedTok = fflib.FFTok_left_bracket
				goto wrongtokenerror
			}
			state = fflib.FFParse_want_key
			continue

		case fflib.FFParse_after_value:
			if tok == fflib.FFTok_comma {
				state = fflib.FFParse_want_key
			} else if tok == fflib.FFTok_right_bracket {
				goto done
			} else {
				wantedTok = fflib.FFTok_comma
				goto wrongtokenerror
			}

		case fflib.FFParse_want_key:
			// json {} ended. goto exit. woo.
			if tok == fflib.FFTok_right_bracket {
				goto done
			}
			if tok != fflib.FFTok_string {
				wantedTok = fflib.FFTok_string
				goto wrongtokenerror
			}

			kn := fs.Output.Bytes()
			if len(kn) <= 0 {
				// "" case. hrm.
				currentKey = ffj_t_DeviceWhitelistno_such_key
				state = fflib.FFParse_want_colon
				goto mainparse
			} else {
				switch kn[0] {

				case 'a':

					if bytes.Equal(ffj_key_DeviceWhitelist_AllowedDevices, kn) {
						currentKey = ffj_t_DeviceWhitelist_AllowedDevices
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				}

				if fflib.EqualFoldRight(ffj_key_DeviceWhitelist_AllowedDevices, kn) {
					currentKey = ffj_t_DeviceWhitelist_AllowedDevices
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				currentKey = ffj_t_DeviceWhitelistno_such_key
				state = fflib.FFParse_want_colon
				goto mainparse
			}

		case fflib.FFParse_want_colon:
			if tok != fflib.FFTok_colon {
				wantedTok = fflib.FFTok_colon
				goto wrongtokenerror
			}
			state = fflib.FFParse_want_value
			continue
		case fflib.FFParse_want_value:

			if tok == fflib.FFTok_left_brace || tok == fflib.FFTok_left_bracket || tok == fflib.FFTok_integer || tok == fflib.FFTok_double || tok == fflib.FFTok_string || tok == fflib.FFTok_bool || tok == fflib.FFTok_null {
				switch currentKey {

				case ffj_t_DeviceWhitelist_AllowedDevices:
					goto handle_AllowedDevices

				case ffj_t_DeviceWhitelistno_such_key:
					err = fs.SkipField(tok)
					if err != nil {
						return fs.WrapErr(err)
					}
					state = fflib.FFParse_after_value
					goto mainparse
				}
			} else {
				goto wantedvalue
			}
		}
	}

handle_AllowedDevices:

	/* handler: uj.AllowedDevices type=[]mesos.DeviceAccess kind=slice quoted=false*/

	{

		{
			if tok != fflib.FFTok_left_brace && tok != fflib.FFTok_null {
				return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for ", tok))
			}
		}

		if tok == fflib.FFTok_null {
			uj.AllowedDevices = nil
		} else {

			uj.AllowedDevices = []DeviceAccess{}

			wantVal := true

			for {

				var tmp_uj__AllowedDevices DeviceAccess

				tok = fs.Scan()
				if tok == fflib.FFTok_error {
					goto tokerror
				}
				if tok == fflib.FFTok_right_brace {
					break
				}

				if tok == fflib.FFTok_comma {
					if wantVal == true {
						// TODO(pquerna): this isn't an ideal error message, this handles
						// things like [,,,] as an array value.
						return fs.WrapErr(fmt.Errorf("wanted value token, but got token: %v", tok))
					}
					continue
				} else {
					wantVal = true
				}

				/* handler: tmp_uj__AllowedDevices type=mesos.DeviceAccess kind=struct quoted=false*/

				{
					if tok == fflib.FFTok_null {

						state = fflib.FFParse_after_value
						goto mainparse
					}

					err = tmp_uj__AllowedDevices.UnmarshalJSONFFLexer(fs, fflib.FFParse_want_key)
					if err != nil {
						return err
					}
					state = fflib.FFParse_after_value
				}

				uj.AllowedDevices = append(uj.AllowedDevices, tmp_uj__AllowedDevices)

				wantVal = false
			}
		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

wantedvalue:
	return fs.WrapErr(fmt.Errorf("wanted value token, but got token: %v", tok))
wrongtokenerror:
	return fs.WrapErr(fmt.Errorf("ffjson: wanted token: %v, but got token: %v output=%s", wantedTok, tok, fs.Output.String()))
tokerror:
	if fs.BigError != nil {
		return fs.WrapErr(fs.BigError)
	}
	err = fs.Error.ToError()
	if err != nil {
		return fs.WrapErr(err)
	}
	panic("ffjson-generated: unreachable, please report bug.")
done:

	return nil
}

func (mj *Device_Number) MarshalJSON() ([]byte, error) {
	var buf fflib.Buffer
	if mj == nil {
		buf.WriteString("null")
		return buf.Bytes(), nil
	}
	err := mj.MarshalJSONBuf(&buf)
	if err != nil {
		return nil, err
	}
	return buf.Bytes(), nil
}
func (mj *Device_Number) MarshalJSONBuf(buf fflib.EncodingBuffer) error {
	if mj == nil {
		buf.WriteString("null")
		return nil
	}
	var err error
	var obj []byte
	_ = obj
	_ = err
	buf.WriteString(`{ `)
	if mj.MajorNumber != nil {
		if true {
			buf.WriteString(`"major_number":`)
			fflib.FormatBits2(buf, uint64(*mj.MajorNumber), 10, false)
			buf.WriteByte(',')
		}
	}
	if mj.MinorNumber != nil {
		if true {
			buf.WriteString(`"minor_number":`)
			fflib.FormatBits2(buf, uint64(*mj.MinorNumber), 10, false)
			buf.WriteByte(',')
		}
	}
	buf.Rewind(1)
	buf.WriteByte('}')
	return nil
}

const (
	ffj_t_Device_Numberbase = iota
	ffj_t_Device_Numberno_such_key

	ffj_t_Device_Number_MajorNumber

	ffj_t_Device_Number_MinorNumber
)

var ffj_key_Device_Number_MajorNumber = []byte("major_number")

var ffj_key_Device_Number_MinorNumber = []byte("minor_number")

func (uj *Device_Number) UnmarshalJSON(input []byte) error {
	fs := fflib.NewFFLexer(input)
	return uj.UnmarshalJSONFFLexer(fs, fflib.FFParse_map_start)
}

func (uj *Device_Number) UnmarshalJSONFFLexer(fs *fflib.FFLexer, state fflib.FFParseState) error {
	var err error = nil
	currentKey := ffj_t_Device_Numberbase
	_ = currentKey
	tok := fflib.FFTok_init
	wantedTok := fflib.FFTok_init

mainparse:
	for {
		tok = fs.Scan()
		//	println(fmt.Sprintf("debug: tok: %v  state: %v", tok, state))
		if tok == fflib.FFTok_error {
			goto tokerror
		}

		switch state {

		case fflib.FFParse_map_start:
			if tok != fflib.FFTok_left_bracket {
				wantedTok = fflib.FFTok_left_bracket
				goto wrongtokenerror
			}
			state = fflib.FFParse_want_key
			continue

		case fflib.FFParse_after_value:
			if tok == fflib.FFTok_comma {
				state = fflib.FFParse_want_key
			} else if tok == fflib.FFTok_right_bracket {
				goto done
			} else {
				wantedTok = fflib.FFTok_comma
				goto wrongtokenerror
			}

		case fflib.FFParse_want_key:
			// json {} ended. goto exit. woo.
			if tok == fflib.FFTok_right_bracket {
				goto done
			}
			if tok != fflib.FFTok_string {
				wantedTok = fflib.FFTok_string
				goto wrongtokenerror
			}

			kn := fs.Output.Bytes()
			if len(kn) <= 0 {
				// "" case. hrm.
				currentKey = ffj_t_Device_Numberno_such_key
				state = fflib.FFParse_want_colon
				goto mainparse
			} else {
				switch kn[0] {

				case 'm':

					if bytes.Equal(ffj_key_Device_Number_MajorNumber, kn) {
						currentKey = ffj_t_Device_Number_MajorNumber
						state = fflib.FFParse_want_colon
						goto mainparse

					} else if bytes.Equal(ffj_key_Device_Number_MinorNumber, kn) {
						currentKey = ffj_t_Device_Number_MinorNumber
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				}

				if fflib.AsciiEqualFold(ffj_key_Device_Number_MinorNumber, kn) {
					currentKey = ffj_t_Device_Number_MinorNumber
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.AsciiEqualFold(ffj_key_Device_Number_MajorNumber, kn) {
					currentKey = ffj_t_Device_Number_MajorNumber
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				currentKey = ffj_t_Device_Numberno_such_key
				state = fflib.FFParse_want_colon
				goto mainparse
			}

		case fflib.FFParse_want_colon:
			if tok != fflib.FFTok_colon {
				wantedTok = fflib.FFTok_colon
				goto wrongtokenerror
			}
			state = fflib.FFParse_want_value
			continue
		case fflib.FFParse_want_value:

			if tok == fflib.FFTok_left_brace || tok == fflib.FFTok_left_bracket || tok == fflib.FFTok_integer || tok == fflib.FFTok_double || tok == fflib.FFTok_string || tok == fflib.FFTok_bool || tok == fflib.FFTok_null {
				switch currentKey {

				case ffj_t_Device_Number_MajorNumber:
					goto handle_MajorNumber

				case ffj_t_Device_Number_MinorNumber:
					goto handle_MinorNumber

				case ffj_t_Device_Numberno_such_key:
					err = fs.SkipField(tok)
					if err != nil {
						return fs.WrapErr(err)
					}
					state = fflib.FFParse_after_value
					goto mainparse
				}
			} else {
				goto wantedvalue
			}
		}
	}

handle_MajorNumber:

	/* handler: uj.MajorNumber type=uint64 kind=uint64 quoted=false*/

	{
		if tok != fflib.FFTok_integer && tok != fflib.FFTok_null {
			return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for uint64", tok))
		}
	}

	{

		if tok == fflib.FFTok_null {

			uj.MajorNumber = nil

		} else {

			tval, err := fflib.ParseUint(fs.Output.Bytes(), 10, 64)

			if err != nil {
				return fs.WrapErr(err)
			}

			ttypval := uint64(tval)
			uj.MajorNumber = &ttypval

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_MinorNumber:

	/* handler: uj.MinorNumber type=uint64 kind=uint64 quoted=false*/

	{
		if tok != fflib.FFTok_integer && tok != fflib.FFTok_null {
			return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for uint64", tok))
		}
	}

	{

		if tok == fflib.FFTok_null {

			uj.MinorNumber = nil

		} else {

			tval, err := fflib.ParseUint(fs.Output.Bytes(), 10, 64)

			if err != nil {
				return fs.WrapErr(err)
			}

			ttypval := uint64(tval)
			uj.MinorNumber = &ttypval

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

wantedvalue:
	return fs.WrapErr(fmt.Errorf("wanted value token, but got token: %v", tok))
wrongtokenerror:
	return fs.WrapErr(fmt.Errorf("ffjson: wanted token: %v, but got token: %v output=%s", wantedTok, tok, fs.Output.String()))
tokerror:
	if fs.BigError != nil {
		return fs.WrapErr(fs.BigError)
	}
	err = fs.Error.ToError()
	if err != nil {
		return fs.WrapErr(err)
	}
	panic("ffjson-generated: unreachable, please report bug.")
done:

	return nil
}

func (mj *DiscoveryInfo) MarshalJSON() ([]byte, error) {
	var buf fflib.Buffer
	if mj == nil {
		buf.WriteString("null")
		return buf.Bytes(), nil
	}
	err := mj.MarshalJSONBuf(&buf)
	if err != nil {
		return nil, err
	}
	return buf.Bytes(), nil
}
func (mj *DiscoveryInfo) MarshalJSONBuf(buf fflib.EncodingBuffer) error {
	if mj == nil {
		buf.WriteString("null")
		return nil
	}
	var err error
	var obj []byte
	_ = obj
	_ = err
	buf.WriteString(`{ "visibility":`)

	{

		obj, err = mj.Visibility.MarshalJSON()
		if err != nil {
			return err
		}
		buf.Write(obj)

	}
	buf.WriteByte(',')
	if mj.Name != nil {
		if true {
			buf.WriteString(`"name":`)
			fflib.WriteJsonString(buf, string(*mj.Name))
			buf.WriteByte(',')
		}
	}
	if mj.Environment != nil {
		if true {
			buf.WriteString(`"environment":`)
			fflib.WriteJsonString(buf, string(*mj.Environment))
			buf.WriteByte(',')
		}
	}
	if mj.Location != nil {
		if true {
			buf.WriteString(`"location":`)
			fflib.WriteJsonString(buf, string(*mj.Location))
			buf.WriteByte(',')
		}
	}
	if mj.Version != nil {
		if true {
			buf.WriteString(`"version":`)
			fflib.WriteJsonString(buf, string(*mj.Version))
			buf.WriteByte(',')
		}
	}
	if mj.Ports != nil {
		if true {
			buf.WriteString(`"ports":`)

			{

				err = mj.Ports.MarshalJSONBuf(buf)
				if err != nil {
					return err
				}

			}
			buf.WriteByte(',')
		}
	}
	if mj.Labels != nil {
		if true {
			buf.WriteString(`"labels":`)

			{

				err = mj.Labels.MarshalJSONBuf(buf)
				if err != nil {
					return err
				}

			}
			buf.WriteByte(',')
		}
	}
	buf.Rewind(1)
	buf.WriteByte('}')
	return nil
}

const (
	ffj_t_DiscoveryInfobase = iota
	ffj_t_DiscoveryInfono_such_key

	ffj_t_DiscoveryInfo_Visibility

	ffj_t_DiscoveryInfo_Name

	ffj_t_DiscoveryInfo_Environment

	ffj_t_DiscoveryInfo_Location

	ffj_t_DiscoveryInfo_Version

	ffj_t_DiscoveryInfo_Ports

	ffj_t_DiscoveryInfo_Labels
)

var ffj_key_DiscoveryInfo_Visibility = []byte("visibility")

var ffj_key_DiscoveryInfo_Name = []byte("name")

var ffj_key_DiscoveryInfo_Environment = []byte("environment")

var ffj_key_DiscoveryInfo_Location = []byte("location")

var ffj_key_DiscoveryInfo_Version = []byte("version")

var ffj_key_DiscoveryInfo_Ports = []byte("ports")

var ffj_key_DiscoveryInfo_Labels = []byte("labels")

func (uj *DiscoveryInfo) UnmarshalJSON(input []byte) error {
	fs := fflib.NewFFLexer(input)
	return uj.UnmarshalJSONFFLexer(fs, fflib.FFParse_map_start)
}

func (uj *DiscoveryInfo) UnmarshalJSONFFLexer(fs *fflib.FFLexer, state fflib.FFParseState) error {
	var err error = nil
	currentKey := ffj_t_DiscoveryInfobase
	_ = currentKey
	tok := fflib.FFTok_init
	wantedTok := fflib.FFTok_init

mainparse:
	for {
		tok = fs.Scan()
		//	println(fmt.Sprintf("debug: tok: %v  state: %v", tok, state))
		if tok == fflib.FFTok_error {
			goto tokerror
		}

		switch state {

		case fflib.FFParse_map_start:
			if tok != fflib.FFTok_left_bracket {
				wantedTok = fflib.FFTok_left_bracket
				goto wrongtokenerror
			}
			state = fflib.FFParse_want_key
			continue

		case fflib.FFParse_after_value:
			if tok == fflib.FFTok_comma {
				state = fflib.FFParse_want_key
			} else if tok == fflib.FFTok_right_bracket {
				goto done
			} else {
				wantedTok = fflib.FFTok_comma
				goto wrongtokenerror
			}

		case fflib.FFParse_want_key:
			// json {} ended. goto exit. woo.
			if tok == fflib.FFTok_right_bracket {
				goto done
			}
			if tok != fflib.FFTok_string {
				wantedTok = fflib.FFTok_string
				goto wrongtokenerror
			}

			kn := fs.Output.Bytes()
			if len(kn) <= 0 {
				// "" case. hrm.
				currentKey = ffj_t_DiscoveryInfono_such_key
				state = fflib.FFParse_want_colon
				goto mainparse
			} else {
				switch kn[0] {

				case 'e':

					if bytes.Equal(ffj_key_DiscoveryInfo_Environment, kn) {
						currentKey = ffj_t_DiscoveryInfo_Environment
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				case 'l':

					if bytes.Equal(ffj_key_DiscoveryInfo_Location, kn) {
						currentKey = ffj_t_DiscoveryInfo_Location
						state = fflib.FFParse_want_colon
						goto mainparse

					} else if bytes.Equal(ffj_key_DiscoveryInfo_Labels, kn) {
						currentKey = ffj_t_DiscoveryInfo_Labels
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				case 'n':

					if bytes.Equal(ffj_key_DiscoveryInfo_Name, kn) {
						currentKey = ffj_t_DiscoveryInfo_Name
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				case 'p':

					if bytes.Equal(ffj_key_DiscoveryInfo_Ports, kn) {
						currentKey = ffj_t_DiscoveryInfo_Ports
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				case 'v':

					if bytes.Equal(ffj_key_DiscoveryInfo_Visibility, kn) {
						currentKey = ffj_t_DiscoveryInfo_Visibility
						state = fflib.FFParse_want_colon
						goto mainparse

					} else if bytes.Equal(ffj_key_DiscoveryInfo_Version, kn) {
						currentKey = ffj_t_DiscoveryInfo_Version
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				}

				if fflib.EqualFoldRight(ffj_key_DiscoveryInfo_Labels, kn) {
					currentKey = ffj_t_DiscoveryInfo_Labels
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffj_key_DiscoveryInfo_Ports, kn) {
					currentKey = ffj_t_DiscoveryInfo_Ports
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffj_key_DiscoveryInfo_Version, kn) {
					currentKey = ffj_t_DiscoveryInfo_Version
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.SimpleLetterEqualFold(ffj_key_DiscoveryInfo_Location, kn) {
					currentKey = ffj_t_DiscoveryInfo_Location
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.SimpleLetterEqualFold(ffj_key_DiscoveryInfo_Environment, kn) {
					currentKey = ffj_t_DiscoveryInfo_Environment
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.SimpleLetterEqualFold(ffj_key_DiscoveryInfo_Name, kn) {
					currentKey = ffj_t_DiscoveryInfo_Name
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffj_key_DiscoveryInfo_Visibility, kn) {
					currentKey = ffj_t_DiscoveryInfo_Visibility
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				currentKey = ffj_t_DiscoveryInfono_such_key
				state = fflib.FFParse_want_colon
				goto mainparse
			}

		case fflib.FFParse_want_colon:
			if tok != fflib.FFTok_colon {
				wantedTok = fflib.FFTok_colon
				goto wrongtokenerror
			}
			state = fflib.FFParse_want_value
			continue
		case fflib.FFParse_want_value:

			if tok == fflib.FFTok_left_brace || tok == fflib.FFTok_left_bracket || tok == fflib.FFTok_integer || tok == fflib.FFTok_double || tok == fflib.FFTok_string || tok == fflib.FFTok_bool || tok == fflib.FFTok_null {
				switch currentKey {

				case ffj_t_DiscoveryInfo_Visibility:
					goto handle_Visibility

				case ffj_t_DiscoveryInfo_Name:
					goto handle_Name

				case ffj_t_DiscoveryInfo_Environment:
					goto handle_Environment

				case ffj_t_DiscoveryInfo_Location:
					goto handle_Location

				case ffj_t_DiscoveryInfo_Version:
					goto handle_Version

				case ffj_t_DiscoveryInfo_Ports:
					goto handle_Ports

				case ffj_t_DiscoveryInfo_Labels:
					goto handle_Labels

				case ffj_t_DiscoveryInfono_such_key:
					err = fs.SkipField(tok)
					if err != nil {
						return fs.WrapErr(err)
					}
					state = fflib.FFParse_after_value
					goto mainparse
				}
			} else {
				goto wantedvalue
			}
		}
	}

handle_Visibility:

	/* handler: uj.Visibility type=mesos.DiscoveryInfo_Visibility kind=int32 quoted=false*/

	{
		if tok == fflib.FFTok_null {

			state = fflib.FFParse_after_value
			goto mainparse
		}

		tbuf, err := fs.CaptureField(tok)
		if err != nil {
			return fs.WrapErr(err)
		}

		err = uj.Visibility.UnmarshalJSON(tbuf)
		if err != nil {
			return fs.WrapErr(err)
		}
		state = fflib.FFParse_after_value
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_Name:

	/* handler: uj.Name type=string kind=string quoted=false*/

	{

		{
			if tok != fflib.FFTok_string && tok != fflib.FFTok_null {
				return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for string", tok))
			}
		}

		if tok == fflib.FFTok_null {

			uj.Name = nil

		} else {

			var tval string
			outBuf := fs.Output.Bytes()

			tval = string(string(outBuf))
			uj.Name = &tval

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_Environment:

	/* handler: uj.Environment type=string kind=string quoted=false*/

	{

		{
			if tok != fflib.FFTok_string && tok != fflib.FFTok_null {
				return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for string", tok))
			}
		}

		if tok == fflib.FFTok_null {

			uj.Environment = nil

		} else {

			var tval string
			outBuf := fs.Output.Bytes()

			tval = string(string(outBuf))
			uj.Environment = &tval

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_Location:

	/* handler: uj.Location type=string kind=string quoted=false*/

	{

		{
			if tok != fflib.FFTok_string && tok != fflib.FFTok_null {
				return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for string", tok))
			}
		}

		if tok == fflib.FFTok_null {

			uj.Location = nil

		} else {

			var tval string
			outBuf := fs.Output.Bytes()

			tval = string(string(outBuf))
			uj.Location = &tval

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_Version:

	/* handler: uj.Version type=string kind=string quoted=false*/

	{

		{
			if tok != fflib.FFTok_string && tok != fflib.FFTok_null {
				return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for string", tok))
			}
		}

		if tok == fflib.FFTok_null {

			uj.Version = nil

		} else {

			var tval string
			outBuf := fs.Output.Bytes()

			tval = string(string(outBuf))
			uj.Version = &tval

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_Ports:

	/* handler: uj.Ports type=mesos.Ports kind=struct quoted=false*/

	{
		if tok == fflib.FFTok_null {

			uj.Ports = nil

			state = fflib.FFParse_after_value
			goto mainparse
		}

		if uj.Ports == nil {
			uj.Ports = new(Ports)
		}

		err = uj.Ports.UnmarshalJSONFFLexer(fs, fflib.FFParse_want_key)
		if err != nil {
			return err
		}
		state = fflib.FFParse_after_value
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_Labels:

	/* handler: uj.Labels type=mesos.Labels kind=struct quoted=false*/

	{
		if tok == fflib.FFTok_null {

			uj.Labels = nil

			state = fflib.FFParse_after_value
			goto mainparse
		}

		if uj.Labels == nil {
			uj.Labels = new(Labels)
		}

		err = uj.Labels.UnmarshalJSONFFLexer(fs, fflib.FFParse_want_key)
		if err != nil {
			return err
		}
		state = fflib.FFParse_after_value
	}

	state = fflib.FFParse_after_value
	goto mainparse

wantedvalue:
	return fs.WrapErr(fmt.Errorf("wanted value token, but got token: %v", tok))
wrongtokenerror:
	return fs.WrapErr(fmt.Errorf("ffjson: wanted token: %v, but got token: %v output=%s", wantedTok, tok, fs.Output.String()))
tokerror:
	if fs.BigError != nil {
		return fs.WrapErr(fs.BigError)
	}
	err = fs.Error.ToError()
	if err != nil {
		return fs.WrapErr(err)
	}
	panic("ffjson-generated: unreachable, please report bug.")
done:

	return nil
}

func (mj *DiskStatistics) MarshalJSON() ([]byte, error) {
	var buf fflib.Buffer
	if mj == nil {
		buf.WriteString("null")
		return buf.Bytes(), nil
	}
	err := mj.MarshalJSONBuf(&buf)
	if err != nil {
		return nil, err
	}
	return buf.Bytes(), nil
}
func (mj *DiskStatistics) MarshalJSONBuf(buf fflib.EncodingBuffer) error {
	if mj == nil {
		buf.WriteString("null")
		return nil
	}
	var err error
	var obj []byte
	_ = obj
	_ = err
	buf.WriteString(`{ `)
	if mj.Source != nil {
		if true {
			buf.WriteString(`"source":`)

			{

				err = mj.Source.MarshalJSONBuf(buf)
				if err != nil {
					return err
				}

			}
			buf.WriteByte(',')
		}
	}
	if mj.Persistence != nil {
		if true {
			buf.WriteString(`"persistence":`)

			{

				err = mj.Persistence.MarshalJSONBuf(buf)
				if err != nil {
					return err
				}

			}
			buf.WriteByte(',')
		}
	}
	if mj.LimitBytes != nil {
		if true {
			buf.WriteString(`"limit_bytes":`)
			fflib.FormatBits2(buf, uint64(*mj.LimitBytes), 10, false)
			buf.WriteByte(',')
		}
	}
	if mj.UsedBytes != nil {
		if true {
			buf.WriteString(`"used_bytes":`)
			fflib.FormatBits2(buf, uint64(*mj.UsedBytes), 10, false)
			buf.WriteByte(',')
		}
	}
	buf.Rewind(1)
	buf.WriteByte('}')
	return nil
}

const (
	ffj_t_DiskStatisticsbase = iota
	ffj_t_DiskStatisticsno_such_key

	ffj_t_DiskStatistics_Source

	ffj_t_DiskStatistics_Persistence

	ffj_t_DiskStatistics_LimitBytes

	ffj_t_DiskStatistics_UsedBytes
)

var ffj_key_DiskStatistics_Source = []byte("source")

var ffj_key_DiskStatistics_Persistence = []byte("persistence")

var ffj_key_DiskStatistics_LimitBytes = []byte("limit_bytes")

var ffj_key_DiskStatistics_UsedBytes = []byte("used_bytes")

func (uj *DiskStatistics) UnmarshalJSON(input []byte) error {
	fs := fflib.NewFFLexer(input)
	return uj.UnmarshalJSONFFLexer(fs, fflib.FFParse_map_start)
}

func (uj *DiskStatistics) UnmarshalJSONFFLexer(fs *fflib.FFLexer, state fflib.FFParseState) error {
	var err error = nil
	currentKey := ffj_t_DiskStatisticsbase
	_ = currentKey
	tok := fflib.FFTok_init
	wantedTok := fflib.FFTok_init

mainparse:
	for {
		tok = fs.Scan()
		//	println(fmt.Sprintf("debug: tok: %v  state: %v", tok, state))
		if tok == fflib.FFTok_error {
			goto tokerror
		}

		switch state {

		case fflib.FFParse_map_start:
			if tok != fflib.FFTok_left_bracket {
				wantedTok = fflib.FFTok_left_bracket
				goto wrongtokenerror
			}
			state = fflib.FFParse_want_key
			continue

		case fflib.FFParse_after_value:
			if tok == fflib.FFTok_comma {
				state = fflib.FFParse_want_key
			} else if tok == fflib.FFTok_right_bracket {
				goto done
			} else {
				wantedTok = fflib.FFTok_comma
				goto wrongtokenerror
			}

		case fflib.FFParse_want_key:
			// json {} ended. goto exit. woo.
			if tok == fflib.FFTok_right_bracket {
				goto done
			}
			if tok != fflib.FFTok_string {
				wantedTok = fflib.FFTok_string
				goto wrongtokenerror
			}

			kn := fs.Output.Bytes()
			if len(kn) <= 0 {
				// "" case. hrm.
				currentKey = ffj_t_DiskStatisticsno_such_key
				state = fflib.FFParse_want_colon
				goto mainparse
			} else {
				switch kn[0] {

				case 'l':

					if bytes.Equal(ffj_key_DiskStatistics_LimitBytes, kn) {
						currentKey = ffj_t_DiskStatistics_LimitBytes
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				case 'p':

					if bytes.Equal(ffj_key_DiskStatistics_Persistence, kn) {
						currentKey = ffj_t_DiskStatistics_Persistence
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				case 's':

					if bytes.Equal(ffj_key_DiskStatistics_Source, kn) {
						currentKey = ffj_t_DiskStatistics_Source
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				case 'u':

					if bytes.Equal(ffj_key_DiskStatistics_UsedBytes, kn) {
						currentKey = ffj_t_DiskStatistics_UsedBytes
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				}

				if fflib.EqualFoldRight(ffj_key_DiskStatistics_UsedBytes, kn) {
					currentKey = ffj_t_DiskStatistics_UsedBytes
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffj_key_DiskStatistics_LimitBytes, kn) {
					currentKey = ffj_t_DiskStatistics_LimitBytes
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffj_key_DiskStatistics_Persistence, kn) {
					currentKey = ffj_t_DiskStatistics_Persistence
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffj_key_DiskStatistics_Source, kn) {
					currentKey = ffj_t_DiskStatistics_Source
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				currentKey = ffj_t_DiskStatisticsno_such_key
				state = fflib.FFParse_want_colon
				goto mainparse
			}

		case fflib.FFParse_want_colon:
			if tok != fflib.FFTok_colon {
				wantedTok = fflib.FFTok_colon
				goto wrongtokenerror
			}
			state = fflib.FFParse_want_value
			continue
		case fflib.FFParse_want_value:

			if tok == fflib.FFTok_left_brace || tok == fflib.FFTok_left_bracket || tok == fflib.FFTok_integer || tok == fflib.FFTok_double || tok == fflib.FFTok_string || tok == fflib.FFTok_bool || tok == fflib.FFTok_null {
				switch currentKey {

				case ffj_t_DiskStatistics_Source:
					goto handle_Source

				case ffj_t_DiskStatistics_Persistence:
					goto handle_Persistence

				case ffj_t_DiskStatistics_LimitBytes:
					goto handle_LimitBytes

				case ffj_t_DiskStatistics_UsedBytes:
					goto handle_UsedBytes

				case ffj_t_DiskStatisticsno_such_key:
					err = fs.SkipField(tok)
					if err != nil {
						return fs.WrapErr(err)
					}
					state = fflib.FFParse_after_value
					goto mainparse
				}
			} else {
				goto wantedvalue
			}
		}
	}

handle_Source:

	/* handler: uj.Source type=mesos.Resource_DiskInfo_Source kind=struct quoted=false*/

	{
		if tok == fflib.FFTok_null {

			uj.Source = nil

			state = fflib.FFParse_after_value
			goto mainparse
		}

		if uj.Source == nil {
			uj.Source = new(Resource_DiskInfo_Source)
		}

		err = uj.Source.UnmarshalJSONFFLexer(fs, fflib.FFParse_want_key)
		if err != nil {
			return err
		}
		state = fflib.FFParse_after_value
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_Persistence:

	/* handler: uj.Persistence type=mesos.Resource_DiskInfo_Persistence kind=struct quoted=false*/

	{
		if tok == fflib.FFTok_null {

			uj.Persistence = nil

			state = fflib.FFParse_after_value
			goto mainparse
		}

		if uj.Persistence == nil {
			uj.Persistence = new(Resource_DiskInfo_Persistence)
		}

		err = uj.Persistence.UnmarshalJSONFFLexer(fs, fflib.FFParse_want_key)
		if err != nil {
			return err
		}
		state = fflib.FFParse_after_value
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_LimitBytes:

	/* handler: uj.LimitBytes type=uint64 kind=uint64 quoted=false*/

	{
		if tok != fflib.FFTok_integer && tok != fflib.FFTok_null {
			return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for uint64", tok))
		}
	}

	{

		if tok == fflib.FFTok_null {

			uj.LimitBytes = nil

		} else {

			tval, err := fflib.ParseUint(fs.Output.Bytes(), 10, 64)

			if err != nil {
				return fs.WrapErr(err)
			}

			ttypval := uint64(tval)
			uj.LimitBytes = &ttypval

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_UsedBytes:

	/* handler: uj.UsedBytes type=uint64 kind=uint64 quoted=false*/

	{
		if tok != fflib.FFTok_integer && tok != fflib.FFTok_null {
			return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for uint64", tok))
		}
	}

	{

		if tok == fflib.FFTok_null {

			uj.UsedBytes = nil

		} else {

			tval, err := fflib.ParseUint(fs.Output.Bytes(), 10, 64)

			if err != nil {
				return fs.WrapErr(err)
			}

			ttypval := uint64(tval)
			uj.UsedBytes = &ttypval

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

wantedvalue:
	return fs.WrapErr(fmt.Errorf("wanted value token, but got token: %v", tok))
wrongtokenerror:
	return fs.WrapErr(fmt.Errorf("ffjson: wanted token: %v, but got token: %v output=%s", wantedTok, tok, fs.Output.String()))
tokerror:
	if fs.BigError != nil {
		return fs.WrapErr(fs.BigError)
	}
	err = fs.Error.ToError()
	if err != nil {
		return fs.WrapErr(err)
	}
	panic("ffjson-generated: unreachable, please report bug.")
done:

	return nil
}

func (mj *DomainInfo) MarshalJSON() ([]byte, error) {
	var buf fflib.Buffer
	if mj == nil {
		buf.WriteString("null")
		return buf.Bytes(), nil
	}
	err := mj.MarshalJSONBuf(&buf)
	if err != nil {
		return nil, err
	}
	return buf.Bytes(), nil
}
func (mj *DomainInfo) MarshalJSONBuf(buf fflib.EncodingBuffer) error {
	if mj == nil {
		buf.WriteString("null")
		return nil
	}
	var err error
	var obj []byte
	_ = obj
	_ = err
	buf.WriteString(`{ `)
	if mj.FaultDomain != nil {
		if true {
			buf.WriteString(`"fault_domain":`)

			{

				err = mj.FaultDomain.MarshalJSONBuf(buf)
				if err != nil {
					return err
				}

			}
			buf.WriteByte(',')
		}
	}
	buf.Rewind(1)
	buf.WriteByte('}')
	return nil
}

const (
	ffj_t_DomainInfobase = iota
	ffj_t_DomainInfono_such_key

	ffj_t_DomainInfo_FaultDomain
)

var ffj_key_DomainInfo_FaultDomain = []byte("fault_domain")

func (uj *DomainInfo) UnmarshalJSON(input []byte) error {
	fs := fflib.NewFFLexer(input)
	return uj.UnmarshalJSONFFLexer(fs, fflib.FFParse_map_start)
}

func (uj *DomainInfo) UnmarshalJSONFFLexer(fs *fflib.FFLexer, state fflib.FFParseState) error {
	var err error = nil
	currentKey := ffj_t_DomainInfobase
	_ = currentKey
	tok := fflib.FFTok_init
	wantedTok := fflib.FFTok_init

mainparse:
	for {
		tok = fs.Scan()
		//	println(fmt.Sprintf("debug: tok: %v  state: %v", tok, state))
		if tok == fflib.FFTok_error {
			goto tokerror
		}

		switch state {

		case fflib.FFParse_map_start:
			if tok != fflib.FFTok_left_bracket {
				wantedTok = fflib.FFTok_left_bracket
				goto wrongtokenerror
			}
			state = fflib.FFParse_want_key
			continue

		case fflib.FFParse_after_value:
			if tok == fflib.FFTok_comma {
				state = fflib.FFParse_want_key
			} else if tok == fflib.FFTok_right_bracket {
				goto done
			} else {
				wantedTok = fflib.FFTok_comma
				goto wrongtokenerror
			}

		case fflib.FFParse_want_key:
			// json {} ended. goto exit. woo.
			if tok == fflib.FFTok_right_bracket {
				goto done
			}
			if tok != fflib.FFTok_string {
				wantedTok = fflib.FFTok_string
				goto wrongtokenerror
			}

			kn := fs.Output.Bytes()
			if len(kn) <= 0 {
				// "" case. hrm.
				currentKey = ffj_t_DomainInfono_such_key
				state = fflib.FFParse_want_colon
				goto mainparse
			} else {
				switch kn[0] {

				case 'f':

					if bytes.Equal(ffj_key_DomainInfo_FaultDomain, kn) {
						currentKey = ffj_t_DomainInfo_FaultDomain
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				}

				if fflib.AsciiEqualFold(ffj_key_DomainInfo_FaultDomain, kn) {
					currentKey = ffj_t_DomainInfo_FaultDomain
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				currentKey = ffj_t_DomainInfono_such_key
				state = fflib.FFParse_want_colon
				goto mainparse
			}

		case fflib.FFParse_want_colon:
			if tok != fflib.FFTok_colon {
				wantedTok = fflib.FFTok_colon
				goto wrongtokenerror
			}
			state = fflib.FFParse_want_value
			continue
		case fflib.FFParse_want_value:

			if tok == fflib.FFTok_left_brace || tok == fflib.FFTok_left_bracket || tok == fflib.FFTok_integer || tok == fflib.FFTok_double || tok == fflib.FFTok_string || tok == fflib.FFTok_bool || tok == fflib.FFTok_null {
				switch currentKey {

				case ffj_t_DomainInfo_FaultDomain:
					goto handle_FaultDomain

				case ffj_t_DomainInfono_such_key:
					err = fs.SkipField(tok)
					if err != nil {
						return fs.WrapErr(err)
					}
					state = fflib.FFParse_after_value
					goto mainparse
				}
			} else {
				goto wantedvalue
			}
		}
	}

handle_FaultDomain:

	/* handler: uj.FaultDomain type=mesos.DomainInfo_FaultDomain kind=struct quoted=false*/

	{
		if tok == fflib.FFTok_null {

			uj.FaultDomain = nil

			state = fflib.FFParse_after_value
			goto mainparse
		}

		if uj.FaultDomain == nil {
			uj.FaultDomain = new(DomainInfo_FaultDomain)
		}

		err = uj.FaultDomain.UnmarshalJSONFFLexer(fs, fflib.FFParse_want_key)
		if err != nil {
			return err
		}
		state = fflib.FFParse_after_value
	}

	state = fflib.FFParse_after_value
	goto mainparse

wantedvalue:
	return fs.WrapErr(fmt.Errorf("wanted value token, but got token: %v", tok))
wrongtokenerror:
	return fs.WrapErr(fmt.Errorf("ffjson: wanted token: %v, but got token: %v output=%s", wantedTok, tok, fs.Output.String()))
tokerror:
	if fs.BigError != nil {
		return fs.WrapErr(fs.BigError)
	}
	err = fs.Error.ToError()
	if err != nil {
		return fs.WrapErr(err)
	}
	panic("ffjson-generated: unreachable, please report bug.")
done:

	return nil
}

func (mj *DomainInfo_FaultDomain) MarshalJSON() ([]byte, error) {
	var buf fflib.Buffer
	if mj == nil {
		buf.WriteString("null")
		return buf.Bytes(), nil
	}
	err := mj.MarshalJSONBuf(&buf)
	if err != nil {
		return nil, err
	}
	return buf.Bytes(), nil
}
func (mj *DomainInfo_FaultDomain) MarshalJSONBuf(buf fflib.EncodingBuffer) error {
	if mj == nil {
		buf.WriteString("null")
		return nil
	}
	var err error
	var obj []byte
	_ = obj
	_ = err
	buf.WriteString(`{"region":`)

	{

		err = mj.Region.MarshalJSONBuf(buf)
		if err != nil {
			return err
		}

	}
	buf.WriteString(`,"zone":`)

	{

		err = mj.Zone.MarshalJSONBuf(buf)
		if err != nil {
			return err
		}

	}
	buf.WriteByte('}')
	return nil
}

const (
	ffj_t_DomainInfo_FaultDomainbase = iota
	ffj_t_DomainInfo_FaultDomainno_such_key

	ffj_t_DomainInfo_FaultDomain_Region

	ffj_t_DomainInfo_FaultDomain_Zone
)

var ffj_key_DomainInfo_FaultDomain_Region = []byte("region")

var ffj_key_DomainInfo_FaultDomain_Zone = []byte("zone")

func (uj *DomainInfo_FaultDomain) UnmarshalJSON(input []byte) error {
	fs := fflib.NewFFLexer(input)
	return uj.UnmarshalJSONFFLexer(fs, fflib.FFParse_map_start)
}

func (uj *DomainInfo_FaultDomain) UnmarshalJSONFFLexer(fs *fflib.FFLexer, state fflib.FFParseState) error {
	var err error = nil
	currentKey := ffj_t_DomainInfo_FaultDomainbase
	_ = currentKey
	tok := fflib.FFTok_init
	wantedTok := fflib.FFTok_init

mainparse:
	for {
		tok = fs.Scan()
		//	println(fmt.Sprintf("debug: tok: %v  state: %v", tok, state))
		if tok == fflib.FFTok_error {
			goto tokerror
		}

		switch state {

		case fflib.FFParse_map_start:
			if tok != fflib.FFTok_left_bracket {
				wantedTok = fflib.FFTok_left_bracket
				goto wrongtokenerror
			}
			state = fflib.FFParse_want_key
			continue

		case fflib.FFParse_after_value:
			if tok == fflib.FFTok_comma {
				state = fflib.FFParse_want_key
			} else if tok == fflib.FFTok_right_bracket {
				goto done
			} else {
				wantedTok = fflib.FFTok_comma
				goto wrongtokenerror
			}

		case fflib.FFParse_want_key:
			// json {} ended. goto exit. woo.
			if tok == fflib.FFTok_right_bracket {
				goto done
			}
			if tok != fflib.FFTok_string {
				wantedTok = fflib.FFTok_string
				goto wrongtokenerror
			}

			kn := fs.Output.Bytes()
			if len(kn) <= 0 {
				// "" case. hrm.
				currentKey = ffj_t_DomainInfo_FaultDomainno_such_key
				state = fflib.FFParse_want_colon
				goto mainparse
			} else {
				switch kn[0] {

				case 'r':

					if bytes.Equal(ffj_key_DomainInfo_FaultDomain_Region, kn) {
						currentKey = ffj_t_DomainInfo_FaultDomain_Region
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				case 'z':

					if bytes.Equal(ffj_key_DomainInfo_FaultDomain_Zone, kn) {
						currentKey = ffj_t_DomainInfo_FaultDomain_Zone
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				}

				if fflib.SimpleLetterEqualFold(ffj_key_DomainInfo_FaultDomain_Zone, kn) {
					currentKey = ffj_t_DomainInfo_FaultDomain_Zone
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.SimpleLetterEqualFold(ffj_key_DomainInfo_FaultDomain_Region, kn) {
					currentKey = ffj_t_DomainInfo_FaultDomain_Region
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				currentKey = ffj_t_DomainInfo_FaultDomainno_such_key
				state = fflib.FFParse_want_colon
				goto mainparse
			}

		case fflib.FFParse_want_colon:
			if tok != fflib.FFTok_colon {
				wantedTok = fflib.FFTok_colon
				goto wrongtokenerror
			}
			state = fflib.FFParse_want_value
			continue
		case fflib.FFParse_want_value:

			if tok == fflib.FFTok_left_brace || tok == fflib.FFTok_left_bracket || tok == fflib.FFTok_integer || tok == fflib.FFTok_double || tok == fflib.FFTok_string || tok == fflib.FFTok_bool || tok == fflib.FFTok_null {
				switch currentKey {

				case ffj_t_DomainInfo_FaultDomain_Region:
					goto handle_Region

				case ffj_t_DomainInfo_FaultDomain_Zone:
					goto handle_Zone

				case ffj_t_DomainInfo_FaultDomainno_such_key:
					err = fs.SkipField(tok)
					if err != nil {
						return fs.WrapErr(err)
					}
					state = fflib.FFParse_after_value
					goto mainparse
				}
			} else {
				goto wantedvalue
			}
		}
	}

handle_Region:

	/* handler: uj.Region type=mesos.DomainInfo_FaultDomain_RegionInfo kind=struct quoted=false*/

	{
		if tok == fflib.FFTok_null {

			state = fflib.FFParse_after_value
			goto mainparse
		}

		err = uj.Region.UnmarshalJSONFFLexer(fs, fflib.FFParse_want_key)
		if err != nil {
			return err
		}
		state = fflib.FFParse_after_value
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_Zone:

	/* handler: uj.Zone type=mesos.DomainInfo_FaultDomain_ZoneInfo kind=struct quoted=false*/

	{
		if tok == fflib.FFTok_null {

			state = fflib.FFParse_after_value
			goto mainparse
		}

		err = uj.Zone.UnmarshalJSONFFLexer(fs, fflib.FFParse_want_key)
		if err != nil {
			return err
		}
		state = fflib.FFParse_after_value
	}

	state = fflib.FFParse_after_value
	goto mainparse

wantedvalue:
	return fs.WrapErr(fmt.Errorf("wanted value token, but got token: %v", tok))
wrongtokenerror:
	return fs.WrapErr(fmt.Errorf("ffjson: wanted token: %v, but got token: %v output=%s", wantedTok, tok, fs.Output.String()))
tokerror:
	if fs.BigError != nil {
		return fs.WrapErr(fs.BigError)
	}
	err = fs.Error.ToError()
	if err != nil {
		return fs.WrapErr(err)
	}
	panic("ffjson-generated: unreachable, please report bug.")
done:

	return nil
}

func (mj *DomainInfo_FaultDomain_RegionInfo) MarshalJSON() ([]byte, error) {
	var buf fflib.Buffer
	if mj == nil {
		buf.WriteString("null")
		return buf.Bytes(), nil
	}
	err := mj.MarshalJSONBuf(&buf)
	if err != nil {
		return nil, err
	}
	return buf.Bytes(), nil
}
func (mj *DomainInfo_FaultDomain_RegionInfo) MarshalJSONBuf(buf fflib.EncodingBuffer) error {
	if mj == nil {
		buf.WriteString("null")
		return nil
	}
	var err error
	var obj []byte
	_ = obj
	_ = err
	buf.WriteString(`{"name":`)
	fflib.WriteJsonString(buf, string(mj.Name))
	buf.WriteByte('}')
	return nil
}

const (
	ffj_t_DomainInfo_FaultDomain_RegionInfobase = iota
	ffj_t_DomainInfo_FaultDomain_RegionInfono_such_key

	ffj_t_DomainInfo_FaultDomain_RegionInfo_Name
)

var ffj_key_DomainInfo_FaultDomain_RegionInfo_Name = []byte("name")

func (uj *DomainInfo_FaultDomain_RegionInfo) UnmarshalJSON(input []byte) error {
	fs := fflib.NewFFLexer(input)
	return uj.UnmarshalJSONFFLexer(fs, fflib.FFParse_map_start)
}

func (uj *DomainInfo_FaultDomain_RegionInfo) UnmarshalJSONFFLexer(fs *fflib.FFLexer, state fflib.FFParseState) error {
	var err error = nil
	currentKey := ffj_t_DomainInfo_FaultDomain_RegionInfobase
	_ = currentKey
	tok := fflib.FFTok_init
	wantedTok := fflib.FFTok_init

mainparse:
	for {
		tok = fs.Scan()
		//	println(fmt.Sprintf("debug: tok: %v  state: %v", tok, state))
		if tok == fflib.FFTok_error {
			goto tokerror
		}

		switch state {

		case fflib.FFParse_map_start:
			if tok != fflib.FFTok_left_bracket {
				wantedTok = fflib.FFTok_left_bracket
				goto wrongtokenerror
			}
			state = fflib.FFParse_want_key
			continue

		case fflib.FFParse_after_value:
			if tok == fflib.FFTok_comma {
				state = fflib.FFParse_want_key
			} else if tok == fflib.FFTok_right_bracket {
				goto done
			} else {
				wantedTok = fflib.FFTok_comma
				goto wrongtokenerror
			}

		case fflib.FFParse_want_key:
			// json {} ended. goto exit. woo.
			if tok == fflib.FFTok_right_bracket {
				goto done
			}
			if tok != fflib.FFTok_string {
				wantedTok = fflib.FFTok_string
				goto wrongtokenerror
			}

			kn := fs.Output.Bytes()
			if len(kn) <= 0 {
				// "" case. hrm.
				currentKey = ffj_t_DomainInfo_FaultDomain_RegionInfono_such_key
				state = fflib.FFParse_want_colon
				goto mainparse
			} else {
				switch kn[0] {

				case 'n':

					if bytes.Equal(ffj_key_DomainInfo_FaultDomain_RegionInfo_Name, kn) {
						currentKey = ffj_t_DomainInfo_FaultDomain_RegionInfo_Name
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				}

				if fflib.SimpleLetterEqualFold(ffj_key_DomainInfo_FaultDomain_RegionInfo_Name, kn) {
					currentKey = ffj_t_DomainInfo_FaultDomain_RegionInfo_Name
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				currentKey = ffj_t_DomainInfo_FaultDomain_RegionInfono_such_key
				state = fflib.FFParse_want_colon
				goto mainparse
			}

		case fflib.FFParse_want_colon:
			if tok != fflib.FFTok_colon {
				wantedTok = fflib.FFTok_colon
				goto wrongtokenerror
			}
			state = fflib.FFParse_want_value
			continue
		case fflib.FFParse_want_value:

			if tok == fflib.FFTok_left_brace || tok == fflib.FFTok_left_bracket || tok == fflib.FFTok_integer || tok == fflib.FFTok_double || tok == fflib.FFTok_string || tok == fflib.FFTok_bool || tok == fflib.FFTok_null {
				switch currentKey {

				case ffj_t_DomainInfo_FaultDomain_RegionInfo_Name:
					goto handle_Name

				case ffj_t_DomainInfo_FaultDomain_RegionInfono_such_key:
					err = fs.SkipField(tok)
					if err != nil {
						return fs.WrapErr(err)
					}
					state = fflib.FFParse_after_value
					goto mainparse
				}
			} else {
				goto wantedvalue
			}
		}
	}

handle_Name:

	/* handler: uj.Name type=string kind=string quoted=false*/

	{

		{
			if tok != fflib.FFTok_string && tok != fflib.FFTok_null {
				return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for string", tok))
			}
		}

		if tok == fflib.FFTok_null {

		} else {

			outBuf := fs.Output.Bytes()

			uj.Name = string(string(outBuf))

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

wantedvalue:
	return fs.WrapErr(fmt.Errorf("wanted value token, but got token: %v", tok))
wrongtokenerror:
	return fs.WrapErr(fmt.Errorf("ffjson: wanted token: %v, but got token: %v output=%s", wantedTok, tok, fs.Output.String()))
tokerror:
	if fs.BigError != nil {
		return fs.WrapErr(fs.BigError)
	}
	err = fs.Error.ToError()
	if err != nil {
		return fs.WrapErr(err)
	}
	panic("ffjson-generated: unreachable, please report bug.")
done:

	return nil
}

func (mj *DomainInfo_FaultDomain_ZoneInfo) MarshalJSON() ([]byte, error) {
	var buf fflib.Buffer
	if mj == nil {
		buf.WriteString("null")
		return buf.Bytes(), nil
	}
	err := mj.MarshalJSONBuf(&buf)
	if err != nil {
		return nil, err
	}
	return buf.Bytes(), nil
}
func (mj *DomainInfo_FaultDomain_ZoneInfo) MarshalJSONBuf(buf fflib.EncodingBuffer) error {
	if mj == nil {
		buf.WriteString("null")
		return nil
	}
	var err error
	var obj []byte
	_ = obj
	_ = err
	buf.WriteString(`{"name":`)
	fflib.WriteJsonString(buf, string(mj.Name))
	buf.WriteByte('}')
	return nil
}

const (
	ffj_t_DomainInfo_FaultDomain_ZoneInfobase = iota
	ffj_t_DomainInfo_FaultDomain_ZoneInfono_such_key

	ffj_t_DomainInfo_FaultDomain_ZoneInfo_Name
)

var ffj_key_DomainInfo_FaultDomain_ZoneInfo_Name = []byte("name")

func (uj *DomainInfo_FaultDomain_ZoneInfo) UnmarshalJSON(input []byte) error {
	fs := fflib.NewFFLexer(input)
	return uj.UnmarshalJSONFFLexer(fs, fflib.FFParse_map_start)
}

func (uj *DomainInfo_FaultDomain_ZoneInfo) UnmarshalJSONFFLexer(fs *fflib.FFLexer, state fflib.FFParseState) error {
	var err error = nil
	currentKey := ffj_t_DomainInfo_FaultDomain_ZoneInfobase
	_ = currentKey
	tok := fflib.FFTok_init
	wantedTok := fflib.FFTok_init

mainparse:
	for {
		tok = fs.Scan()
		//	println(fmt.Sprintf("debug: tok: %v  state: %v", tok, state))
		if tok == fflib.FFTok_error {
			goto tokerror
		}

		switch state {

		case fflib.FFParse_map_start:
			if tok != fflib.FFTok_left_bracket {
				wantedTok = fflib.FFTok_left_bracket
				goto wrongtokenerror
			}
			state = fflib.FFParse_want_key
			continue

		case fflib.FFParse_after_value:
			if tok == fflib.FFTok_comma {
				state = fflib.FFParse_want_key
			} else if tok == fflib.FFTok_right_bracket {
				goto done
			} else {
				wantedTok = fflib.FFTok_comma
				goto wrongtokenerror
			}

		case fflib.FFParse_want_key:
			// json {} ended. goto exit. woo.
			if tok == fflib.FFTok_right_bracket {
				goto done
			}
			if tok != fflib.FFTok_string {
				wantedTok = fflib.FFTok_string
				goto wrongtokenerror
			}

			kn := fs.Output.Bytes()
			if len(kn) <= 0 {
				// "" case. hrm.
				currentKey = ffj_t_DomainInfo_FaultDomain_ZoneInfono_such_key
				state = fflib.FFParse_want_colon
				goto mainparse
			} else {
				switch kn[0] {

				case 'n':

					if bytes.Equal(ffj_key_DomainInfo_FaultDomain_ZoneInfo_Name, kn) {
						currentKey = ffj_t_DomainInfo_FaultDomain_ZoneInfo_Name
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				}

				if fflib.SimpleLetterEqualFold(ffj_key_DomainInfo_FaultDomain_ZoneInfo_Name, kn) {
					currentKey = ffj_t_DomainInfo_FaultDomain_ZoneInfo_Name
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				currentKey = ffj_t_DomainInfo_FaultDomain_ZoneInfono_such_key
				state = fflib.FFParse_want_colon
				goto mainparse
			}

		case fflib.FFParse_want_colon:
			if tok != fflib.FFTok_colon {
				wantedTok = fflib.FFTok_colon
				goto wrongtokenerror
			}
			state = fflib.FFParse_want_value
			continue
		case fflib.FFParse_want_value:

			if tok == fflib.FFTok_left_brace || tok == fflib.FFTok_left_bracket || tok == fflib.FFTok_integer || tok == fflib.FFTok_double || tok == fflib.FFTok_string || tok == fflib.FFTok_bool || tok == fflib.FFTok_null {
				switch currentKey {

				case ffj_t_DomainInfo_FaultDomain_ZoneInfo_Name:
					goto handle_Name

				case ffj_t_DomainInfo_FaultDomain_ZoneInfono_such_key:
					err = fs.SkipField(tok)
					if err != nil {
						return fs.WrapErr(err)
					}
					state = fflib.FFParse_after_value
					goto mainparse
				}
			} else {
				goto wantedvalue
			}
		}
	}

handle_Name:

	/* handler: uj.Name type=string kind=string quoted=false*/

	{

		{
			if tok != fflib.FFTok_string && tok != fflib.FFTok_null {
				return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for string", tok))
			}
		}

		if tok == fflib.FFTok_null {

		} else {

			outBuf := fs.Output.Bytes()

			uj.Name = string(string(outBuf))

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

wantedvalue:
	return fs.WrapErr(fmt.Errorf("wanted value token, but got token: %v", tok))
wrongtokenerror:
	return fs.WrapErr(fmt.Errorf("ffjson: wanted token: %v, but got token: %v output=%s", wantedTok, tok, fs.Output.String()))
tokerror:
	if fs.BigError != nil {
		return fs.WrapErr(fs.BigError)
	}
	err = fs.Error.ToError()
	if err != nil {
		return fs.WrapErr(err)
	}
	panic("ffjson-generated: unreachable, please report bug.")
done:

	return nil
}

func (mj *DrainConfig) MarshalJSON() ([]byte, error) {
	var buf fflib.Buffer
	if mj == nil {
		buf.WriteString("null")
		return buf.Bytes(), nil
	}
	err := mj.MarshalJSONBuf(&buf)
	if err != nil {
		return nil, err
	}
	return buf.Bytes(), nil
}
func (mj *DrainConfig) MarshalJSONBuf(buf fflib.EncodingBuffer) error {
	if mj == nil {
		buf.WriteString("null")
		return nil
	}
	var err error
	var obj []byte
	_ = obj
	_ = err
	buf.WriteString(`{ `)
	if mj.MaxGracePeriod != nil {
		if true {
			buf.WriteString(`"max_grace_period":`)

			{

				err = mj.MaxGracePeriod.MarshalJSONBuf(buf)
				if err != nil {
					return err
				}

			}
			buf.WriteByte(',')
		}
	}
	if mj.MarkGone != nil {
		if true {
			if *mj.MarkGone {
				buf.WriteString(`"mark_gone":true`)
			} else {
				buf.WriteString(`"mark_gone":false`)
			}
			buf.WriteByte(',')
		}
	}
	buf.Rewind(1)
	buf.WriteByte('}')
	return nil
}

const (
	ffj_t_DrainConfigbase = iota
	ffj_t_DrainConfigno_such_key

	ffj_t_DrainConfig_MaxGracePeriod

	ffj_t_DrainConfig_MarkGone
)

var ffj_key_DrainConfig_MaxGracePeriod = []byte("max_grace_period")

var ffj_key_DrainConfig_MarkGone = []byte("mark_gone")

func (uj *DrainConfig) UnmarshalJSON(input []byte) error {
	fs := fflib.NewFFLexer(input)
	return uj.UnmarshalJSONFFLexer(fs, fflib.FFParse_map_start)
}

func (uj *DrainConfig) UnmarshalJSONFFLexer(fs *fflib.FFLexer, state fflib.FFParseState) error {
	var err error = nil
	currentKey := ffj_t_DrainConfigbase
	_ = currentKey
	tok := fflib.FFTok_init
	wantedTok := fflib.FFTok_init

mainparse:
	for {
		tok = fs.Scan()
		//	println(fmt.Sprintf("debug: tok: %v  state: %v", tok, state))
		if tok == fflib.FFTok_error {
			goto tokerror
		}

		switch state {

		case fflib.FFParse_map_start:
			if tok != fflib.FFTok_left_bracket {
				wantedTok = fflib.FFTok_left_bracket
				goto wrongtokenerror
			}
			state = fflib.FFParse_want_key
			continue

		case fflib.FFParse_after_value:
			if tok == fflib.FFTok_comma {
				state = fflib.FFParse_want_key
			} else if tok == fflib.FFTok_right_bracket {
				goto done
			} else {
				wantedTok = fflib.FFTok_comma
				goto wrongtokenerror
			}

		case fflib.FFParse_want_key:
			// json {} ended. goto exit. woo.
			if tok == fflib.FFTok_right_bracket {
				goto done
			}
			if tok != fflib.FFTok_string {
				wantedTok = fflib.FFTok_string
				goto wrongtokenerror
			}

			kn := fs.Output.Bytes()
			if len(kn) <= 0 {
				// "" case. hrm.
				currentKey = ffj_t_DrainConfigno_such_key
				state = fflib.FFParse_want_colon
				goto mainparse
			} else {
				switch kn[0] {

				case 'm':

					if bytes.Equal(ffj_key_DrainConfig_MaxGracePeriod, kn) {
						currentKey = ffj_t_DrainConfig_MaxGracePeriod
						state = fflib.FFParse_want_colon
						goto mainparse

					} else if bytes.Equal(ffj_key_DrainConfig_MarkGone, kn) {
						currentKey = ffj_t_DrainConfig_MarkGone
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				}

				if fflib.EqualFoldRight(ffj_key_DrainConfig_MarkGone, kn) {
					currentKey = ffj_t_DrainConfig_MarkGone
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.AsciiEqualFold(ffj_key_DrainConfig_MaxGracePeriod, kn) {
					currentKey = ffj_t_DrainConfig_MaxGracePeriod
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				currentKey = ffj_t_DrainConfigno_such_key
				state = fflib.FFParse_want_colon
				goto mainparse
			}

		case fflib.FFParse_want_colon:
			if tok != fflib.FFTok_colon {
				wantedTok = fflib.FFTok_colon
				goto wrongtokenerror
			}
			state = fflib.FFParse_want_value
			continue
		case fflib.FFParse_want_value:

			if tok == fflib.FFTok_left_brace || tok == fflib.FFTok_left_bracket || tok == fflib.FFTok_integer || tok == fflib.FFTok_double || tok == fflib.FFTok_string || tok == fflib.FFTok_bool || tok == fflib.FFTok_null {
				switch currentKey {

				case ffj_t_DrainConfig_MaxGracePeriod:
					goto handle_MaxGracePeriod

				case ffj_t_DrainConfig_MarkGone:
					goto handle_MarkGone

				case ffj_t_DrainConfigno_such_key:
					err = fs.SkipField(tok)
					if err != nil {
						return fs.WrapErr(err)
					}
					state = fflib.FFParse_after_value
					goto mainparse
				}
			} else {
				goto wantedvalue
			}
		}
	}

handle_MaxGracePeriod:

	/* handler: uj.MaxGracePeriod type=mesos.DurationInfo kind=struct quoted=false*/

	{
		if tok == fflib.FFTok_null {

			uj.MaxGracePeriod = nil

			state = fflib.FFParse_after_value
			goto mainparse
		}

		if uj.MaxGracePeriod == nil {
			uj.MaxGracePeriod = new(DurationInfo)
		}

		err = uj.MaxGracePeriod.UnmarshalJSONFFLexer(fs, fflib.FFParse_want_key)
		if err != nil {
			return err
		}
		state = fflib.FFParse_after_value
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_MarkGone:

	/* handler: uj.MarkGone type=bool kind=bool quoted=false*/

	{
		if tok != fflib.FFTok_bool && tok != fflib.FFTok_null {
			return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for bool", tok))
		}
	}

	{
		if tok == fflib.FFTok_null {

			uj.MarkGone = nil

		} else {
			tmpb := fs.Output.Bytes()

			var tval bool

			if bytes.Compare([]byte{'t', 'r', 'u', 'e'}, tmpb) == 0 {

				tval = true

			} else if bytes.Compare([]byte{'f', 'a', 'l', 's', 'e'}, tmpb) == 0 {

				tval = false

			} else {
				err = errors.New("unexpected bytes for true/false value")
				return fs.WrapErr(err)
			}

			uj.MarkGone = &tval

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

wantedvalue:
	return fs.WrapErr(fmt.Errorf("wanted value token, but got token: %v", tok))
wrongtokenerror:
	return fs.WrapErr(fmt.Errorf("ffjson: wanted token: %v, but got token: %v output=%s", wantedTok, tok, fs.Output.String()))
tokerror:
	if fs.BigError != nil {
		return fs.WrapErr(fs.BigError)
	}
	err = fs.Error.ToError()
	if err != nil {
		return fs.WrapErr(err)
	}
	panic("ffjson-generated: unreachable, please report bug.")
done:

	return nil
}

func (mj *DrainInfo) MarshalJSON() ([]byte, error) {
	var buf fflib.Buffer
	if mj == nil {
		buf.WriteString("null")
		return buf.Bytes(), nil
	}
	err := mj.MarshalJSONBuf(&buf)
	if err != nil {
		return nil, err
	}
	return buf.Bytes(), nil
}
func (mj *DrainInfo) MarshalJSONBuf(buf fflib.EncodingBuffer) error {
	if mj == nil {
		buf.WriteString("null")
		return nil
	}
	var err error
	var obj []byte
	_ = obj
	_ = err
	buf.WriteString(`{"state":`)

	{

		obj, err = mj.State.MarshalJSON()
		if err != nil {
			return err
		}
		buf.Write(obj)

	}
	buf.WriteString(`,"config":`)

	{

		err = mj.Config.MarshalJSONBuf(buf)
		if err != nil {
			return err
		}

	}
	buf.WriteByte('}')
	return nil
}

const (
	ffj_t_DrainInfobase = iota
	ffj_t_DrainInfono_such_key

	ffj_t_DrainInfo_State

	ffj_t_DrainInfo_Config
)

var ffj_key_DrainInfo_State = []byte("state")

var ffj_key_DrainInfo_Config = []byte("config")

func (uj *DrainInfo) UnmarshalJSON(input []byte) error {
	fs := fflib.NewFFLexer(input)
	return uj.UnmarshalJSONFFLexer(fs, fflib.FFParse_map_start)
}

func (uj *DrainInfo) UnmarshalJSONFFLexer(fs *fflib.FFLexer, state fflib.FFParseState) error {
	var err error = nil
	currentKey := ffj_t_DrainInfobase
	_ = currentKey
	tok := fflib.FFTok_init
	wantedTok := fflib.FFTok_init

mainparse:
	for {
		tok = fs.Scan()
		//	println(fmt.Sprintf("debug: tok: %v  state: %v", tok, state))
		if tok == fflib.FFTok_error {
			goto tokerror
		}

		switch state {

		case fflib.FFParse_map_start:
			if tok != fflib.FFTok_left_bracket {
				wantedTok = fflib.FFTok_left_bracket
				goto wrongtokenerror
			}
			state = fflib.FFParse_want_key
			continue

		case fflib.FFParse_after_value:
			if tok == fflib.FFTok_comma {
				state = fflib.FFParse_want_key
			} else if tok == fflib.FFTok_right_bracket {
				goto done
			} else {
				wantedTok = fflib.FFTok_comma
				goto wrongtokenerror
			}

		case fflib.FFParse_want_key:
			// json {} ended. goto exit. woo.
			if tok == fflib.FFTok_right_bracket {
				goto done
			}
			if tok != fflib.FFTok_string {
				wantedTok = fflib.FFTok_string
				goto wrongtokenerror
			}

			kn := fs.Output.Bytes()
			if len(kn) <= 0 {
				// "" case. hrm.
				currentKey = ffj_t_DrainInfono_such_key
				state = fflib.FFParse_want_colon
				goto mainparse
			} else {
				switch kn[0] {

				case 'c':

					if bytes.Equal(ffj_key_DrainInfo_Config, kn) {
						currentKey = ffj_t_DrainInfo_Config
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				case 's':

					if bytes.Equal(ffj_key_DrainInfo_State, kn) {
						currentKey = ffj_t_DrainInfo_State
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				}

				if fflib.SimpleLetterEqualFold(ffj_key_DrainInfo_Config, kn) {
					currentKey = ffj_t_DrainInfo_Config
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffj_key_DrainInfo_State, kn) {
					currentKey = ffj_t_DrainInfo_State
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				currentKey = ffj_t_DrainInfono_such_key
				state = fflib.FFParse_want_colon
				goto mainparse
			}

		case fflib.FFParse_want_colon:
			if tok != fflib.FFTok_colon {
				wantedTok = fflib.FFTok_colon
				goto wrongtokenerror
			}
			state = fflib.FFParse_want_value
			continue
		case fflib.FFParse_want_value:

			if tok == fflib.FFTok_left_brace || tok == fflib.FFTok_left_bracket || tok == fflib.FFTok_integer || tok == fflib.FFTok_double || tok == fflib.FFTok_string || tok == fflib.FFTok_bool || tok == fflib.FFTok_null {
				switch currentKey {

				case ffj_t_DrainInfo_State:
					goto handle_State

				case ffj_t_DrainInfo_Config:
					goto handle_Config

				case ffj_t_DrainInfono_such_key:
					err = fs.SkipField(tok)
					if err != nil {
						return fs.WrapErr(err)
					}
					state = fflib.FFParse_after_value
					goto mainparse
				}
			} else {
				goto wantedvalue
			}
		}
	}

handle_State:

	/* handler: uj.State type=mesos.DrainState kind=int32 quoted=false*/

	{
		if tok == fflib.FFTok_null {

			state = fflib.FFParse_after_value
			goto mainparse
		}

		tbuf, err := fs.CaptureField(tok)
		if err != nil {
			return fs.WrapErr(err)
		}

		err = uj.State.UnmarshalJSON(tbuf)
		if err != nil {
			return fs.WrapErr(err)
		}
		state = fflib.FFParse_after_value
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_Config:

	/* handler: uj.Config type=mesos.DrainConfig kind=struct quoted=false*/

	{
		if tok == fflib.FFTok_null {

			state = fflib.FFParse_after_value
			goto mainparse
		}

		err = uj.Config.UnmarshalJSONFFLexer(fs, fflib.FFParse_want_key)
		if err != nil {
			return err
		}
		state = fflib.FFParse_after_value
	}

	state = fflib.FFParse_after_value
	goto mainparse

wantedvalue:
	return fs.WrapErr(fmt.Errorf("wanted value token, but got token: %v", tok))
wrongtokenerror:
	return fs.WrapErr(fmt.Errorf("ffjson: wanted token: %v, but got token: %v output=%s", wantedTok, tok, fs.Output.String()))
tokerror:
	if fs.BigError != nil {
		return fs.WrapErr(fs.BigError)
	}
	err = fs.Error.ToError()
	if err != nil {
		return fs.WrapErr(err)
	}
	panic("ffjson-generated: unreachable, please report bug.")
done:

	return nil
}

func (mj *DurationInfo) MarshalJSON() ([]byte, error) {
	var buf fflib.Buffer
	if mj == nil {
		buf.WriteString("null")
		return buf.Bytes(), nil
	}
	err := mj.MarshalJSONBuf(&buf)
	if err != nil {
		return nil, err
	}
	return buf.Bytes(), nil
}
func (mj *DurationInfo) MarshalJSONBuf(buf fflib.EncodingBuffer) error {
	if mj == nil {
		buf.WriteString("null")
		return nil
	}
	var err error
	var obj []byte
	_ = obj
	_ = err
	buf.WriteString(`{"nanoseconds":`)
	fflib.FormatBits2(buf, uint64(mj.Nanoseconds), 10, mj.Nanoseconds < 0)
	buf.WriteByte('}')
	return nil
}

const (
	ffj_t_DurationInfobase = iota
	ffj_t_DurationInfono_such_key

	ffj_t_DurationInfo_Nanoseconds
)

var ffj_key_DurationInfo_Nanoseconds = []byte("nanoseconds")

func (uj *DurationInfo) UnmarshalJSON(input []byte) error {
	fs := fflib.NewFFLexer(input)
	return uj.UnmarshalJSONFFLexer(fs, fflib.FFParse_map_start)
}

func (uj *DurationInfo) UnmarshalJSONFFLexer(fs *fflib.FFLexer, state fflib.FFParseState) error {
	var err error = nil
	currentKey := ffj_t_DurationInfobase
	_ = currentKey
	tok := fflib.FFTok_init
	wantedTok := fflib.FFTok_init

mainparse:
	for {
		tok = fs.Scan()
		//	println(fmt.Sprintf("debug: tok: %v  state: %v", tok, state))
		if tok == fflib.FFTok_error {
			goto tokerror
		}

		switch state {

		case fflib.FFParse_map_start:
			if tok != fflib.FFTok_left_bracket {
				wantedTok = fflib.FFTok_left_bracket
				goto wrongtokenerror
			}
			state = fflib.FFParse_want_key
			continue

		case fflib.FFParse_after_value:
			if tok == fflib.FFTok_comma {
				state = fflib.FFParse_want_key
			} else if tok == fflib.FFTok_right_bracket {
				goto done
			} else {
				wantedTok = fflib.FFTok_comma
				goto wrongtokenerror
			}

		case fflib.FFParse_want_key:
			// json {} ended. goto exit. woo.
			if tok == fflib.FFTok_right_bracket {
				goto done
			}
			if tok != fflib.FFTok_string {
				wantedTok = fflib.FFTok_string
				goto wrongtokenerror
			}

			kn := fs.Output.Bytes()
			if len(kn) <= 0 {
				// "" case. hrm.
				currentKey = ffj_t_DurationInfono_such_key
				state = fflib.FFParse_want_colon
				goto mainparse
			} else {
				switch kn[0] {

				case 'n':

					if bytes.Equal(ffj_key_DurationInfo_Nanoseconds, kn) {
						currentKey = ffj_t_DurationInfo_Nanoseconds
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				}

				if fflib.EqualFoldRight(ffj_key_DurationInfo_Nanoseconds, kn) {
					currentKey = ffj_t_DurationInfo_Nanoseconds
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				currentKey = ffj_t_DurationInfono_such_key
				state = fflib.FFParse_want_colon
				goto mainparse
			}

		case fflib.FFParse_want_colon:
			if tok != fflib.FFTok_colon {
				wantedTok = fflib.FFTok_colon
				goto wrongtokenerror
			}
			state = fflib.FFParse_want_value
			continue
		case fflib.FFParse_want_value:

			if tok == fflib.FFTok_left_brace || tok == fflib.FFTok_left_bracket || tok == fflib.FFTok_integer || tok == fflib.FFTok_double || tok == fflib.FFTok_string || tok == fflib.FFTok_bool || tok == fflib.FFTok_null {
				switch currentKey {

				case ffj_t_DurationInfo_Nanoseconds:
					goto handle_Nanoseconds

				case ffj_t_DurationInfono_such_key:
					err = fs.SkipField(tok)
					if err != nil {
						return fs.WrapErr(err)
					}
					state = fflib.FFParse_after_value
					goto mainparse
				}
			} else {
				goto wantedvalue
			}
		}
	}

handle_Nanoseconds:

	/* handler: uj.Nanoseconds type=int64 kind=int64 quoted=false*/

	{
		if tok != fflib.FFTok_integer && tok != fflib.FFTok_null {
			return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for int64", tok))
		}
	}

	{

		if tok == fflib.FFTok_null {

		} else {

			tval, err := fflib.ParseInt(fs.Output.Bytes(), 10, 64)

			if err != nil {
				return fs.WrapErr(err)
			}

			uj.Nanoseconds = int64(tval)

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

wantedvalue:
	return fs.WrapErr(fmt.Errorf("wanted value token, but got token: %v", tok))
wrongtokenerror:
	return fs.WrapErr(fmt.Errorf("ffjson: wanted token: %v, but got token: %v output=%s", wantedTok, tok, fs.Output.String()))
tokerror:
	if fs.BigError != nil {
		return fs.WrapErr(fs.BigError)
	}
	err = fs.Error.ToError()
	if err != nil {
		return fs.WrapErr(err)
	}
	panic("ffjson-generated: unreachable, please report bug.")
done:

	return nil
}

func (mj *Environment) MarshalJSON() ([]byte, error) {
	var buf fflib.Buffer
	if mj == nil {
		buf.WriteString("null")
		return buf.Bytes(), nil
	}
	err := mj.MarshalJSONBuf(&buf)
	if err != nil {
		return nil, err
	}
	return buf.Bytes(), nil
}
func (mj *Environment) MarshalJSONBuf(buf fflib.EncodingBuffer) error {
	if mj == nil {
		buf.WriteString("null")
		return nil
	}
	var err error
	var obj []byte
	_ = obj
	_ = err
	buf.WriteString(`{"variables":`)
	if mj.Variables != nil {
		buf.WriteString(`[`)
		for i, v := range mj.Variables {
			if i != 0 {
				buf.WriteString(`,`)
			}

			{

				err = v.MarshalJSONBuf(buf)
				if err != nil {
					return err
				}

			}
		}
		buf.WriteString(`]`)
	} else {
		buf.WriteString(`null`)
	}
	buf.WriteByte('}')
	return nil
}

const (
	ffj_t_Environmentbase = iota
	ffj_t_Environmentno_such_key

	ffj_t_Environment_Variables
)

var ffj_key_Environment_Variables = []byte("variables")

func (uj *Environment) UnmarshalJSON(input []byte) error {
	fs := fflib.NewFFLexer(input)
	return uj.UnmarshalJSONFFLexer(fs, fflib.FFParse_map_start)
}

func (uj *Environment) UnmarshalJSONFFLexer(fs *fflib.FFLexer, state fflib.FFParseState) error {
	var err error = nil
	currentKey := ffj_t_Environmentbase
	_ = currentKey
	tok := fflib.FFTok_init
	wantedTok := fflib.FFTok_init

mainparse:
	for {
		tok = fs.Scan()
		//	println(fmt.Sprintf("debug: tok: %v  state: %v", tok, state))
		if tok == fflib.FFTok_error {
			goto tokerror
		}

		switch state {

		case fflib.FFParse_map_start:
			if tok != fflib.FFTok_left_bracket {
				wantedTok = fflib.FFTok_left_bracket
				goto wrongtokenerror
			}
			state = fflib.FFParse_want_key
			continue

		case fflib.FFParse_after_value:
			if tok == fflib.FFTok_comma {
				state = fflib.FFParse_want_key
			} else if tok == fflib.FFTok_right_bracket {
				goto done
			} else {
				wantedTok = fflib.FFTok_comma
				goto wrongtokenerror
			}

		case fflib.FFParse_want_key:
			// json {} ended. goto exit. woo.
			if tok == fflib.FFTok_right_bracket {
				goto done
			}
			if tok != fflib.FFTok_string {
				wantedTok = fflib.FFTok_string
				goto wrongtokenerror
			}

			kn := fs.Output.Bytes()
			if len(kn) <= 0 {
				// "" case. hrm.
				currentKey = ffj_t_Environmentno_such_key
				state = fflib.FFParse_want_colon
				goto mainparse
			} else {
				switch kn[0] {

				case 'v':

					if bytes.Equal(ffj_key_Environment_Variables, kn) {
						currentKey = ffj_t_Environment_Variables
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				}

				if fflib.EqualFoldRight(ffj_key_Environment_Variables, kn) {
					currentKey = ffj_t_Environment_Variables
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				currentKey = ffj_t_Environmentno_such_key
				state = fflib.FFParse_want_colon
				goto mainparse
			}

		case fflib.FFParse_want_colon:
			if tok != fflib.FFTok_colon {
				wantedTok = fflib.FFTok_colon
				goto wrongtokenerror
			}
			state = fflib.FFParse_want_value
			continue
		case fflib.FFParse_want_value:

			if tok == fflib.FFTok_left_brace || tok == fflib.FFTok_left_bracket || tok == fflib.FFTok_integer || tok == fflib.FFTok_double || tok == fflib.FFTok_string || tok == fflib.FFTok_bool || tok == fflib.FFTok_null {
				switch currentKey {

				case ffj_t_Environment_Variables:
					goto handle_Variables

				case ffj_t_Environmentno_such_key:
					err = fs.SkipField(tok)
					if err != nil {
						return fs.WrapErr(err)
					}
					state = fflib.FFParse_after_value
					goto mainparse
				}
			} else {
				goto wantedvalue
			}
		}
	}

handle_Variables:

	/* handler: uj.Variables type=[]mesos.Environment_Variable kind=slice quoted=false*/

	{

		{
			if tok != fflib.FFTok_left_brace && tok != fflib.FFTok_null {
				return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for ", tok))
			}
		}

		if tok == fflib.FFTok_null {
			uj.Variables = nil
		} else {

			uj.Variables = []Environment_Variable{}

			wantVal := true

			for {

				var tmp_uj__Variables Environment_Variable

				tok = fs.Scan()
				if tok == fflib.FFTok_error {
					goto tokerror
				}
				if tok == fflib.FFTok_right_brace {
					break
				}

				if tok == fflib.FFTok_comma {
					if wantVal == true {
						// TODO(pquerna): this isn't an ideal error message, this handles
						// things like [,,,] as an array value.
						return fs.WrapErr(fmt.Errorf("wanted value token, but got token: %v", tok))
					}
					continue
				} else {
					wantVal = true
				}

				/* handler: tmp_uj__Variables type=mesos.Environment_Variable kind=struct quoted=false*/

				{
					if tok == fflib.FFTok_null {

						state = fflib.FFParse_after_value
						goto mainparse
					}

					err = tmp_uj__Variables.UnmarshalJSONFFLexer(fs, fflib.FFParse_want_key)
					if err != nil {
						return err
					}
					state = fflib.FFParse_after_value
				}

				uj.Variables = append(uj.Variables, tmp_uj__Variables)

				wantVal = false
			}
		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

wantedvalue:
	return fs.WrapErr(fmt.Errorf("wanted value token, but got token: %v", tok))
wrongtokenerror:
	return fs.WrapErr(fmt.Errorf("ffjson: wanted token: %v, but got token: %v output=%s", wantedTok, tok, fs.Output.String()))
tokerror:
	if fs.BigError != nil {
		return fs.WrapErr(fs.BigError)
	}
	err = fs.Error.ToError()
	if err != nil {
		return fs.WrapErr(err)
	}
	panic("ffjson-generated: unreachable, please report bug.")
done:

	return nil
}

func (mj *Environment_Variable) MarshalJSON() ([]byte, error) {
	var buf fflib.Buffer
	if mj == nil {
		buf.WriteString("null")
		return buf.Bytes(), nil
	}
	err := mj.MarshalJSONBuf(&buf)
	if err != nil {
		return nil, err
	}
	return buf.Bytes(), nil
}
func (mj *Environment_Variable) MarshalJSONBuf(buf fflib.EncodingBuffer) error {
	if mj == nil {
		buf.WriteString("null")
		return nil
	}
	var err error
	var obj []byte
	_ = obj
	_ = err
	buf.WriteString(`{ "name":`)
	fflib.WriteJsonString(buf, string(mj.Name))
	buf.WriteByte(',')
	if mj.Type != nil {
		if true {
			buf.WriteString(`"type":`)

			{

				obj, err = mj.Type.MarshalJSON()
				if err != nil {
					return err
				}
				buf.Write(obj)

			}
			buf.WriteByte(',')
		}
	}
	if mj.Value != nil {
		if true {
			buf.WriteString(`"value":`)
			fflib.WriteJsonString(buf, string(*mj.Value))
			buf.WriteByte(',')
		}
	}
	if mj.Secret != nil {
		if true {
			buf.WriteString(`"secret":`)

			{

				err = mj.Secret.MarshalJSONBuf(buf)
				if err != nil {
					return err
				}

			}
			buf.WriteByte(',')
		}
	}
	buf.Rewind(1)
	buf.WriteByte('}')
	return nil
}

const (
	ffj_t_Environment_Variablebase = iota
	ffj_t_Environment_Variableno_such_key

	ffj_t_Environment_Variable_Name

	ffj_t_Environment_Variable_Type

	ffj_t_Environment_Variable_Value

	ffj_t_Environment_Variable_Secret
)

var ffj_key_Environment_Variable_Name = []byte("name")

var ffj_key_Environment_Variable_Type = []byte("type")

var ffj_key_Environment_Variable_Value = []byte("value")

var ffj_key_Environment_Variable_Secret = []byte("secret")

func (uj *Environment_Variable) UnmarshalJSON(input []byte) error {
	fs := fflib.NewFFLexer(input)
	return uj.UnmarshalJSONFFLexer(fs, fflib.FFParse_map_start)
}

func (uj *Environment_Variable) UnmarshalJSONFFLexer(fs *fflib.FFLexer, state fflib.FFParseState) error {
	var err error = nil
	currentKey := ffj_t_Environment_Variablebase
	_ = currentKey
	tok := fflib.FFTok_init
	wantedTok := fflib.FFTok_init

mainparse:
	for {
		tok = fs.Scan()
		//	println(fmt.Sprintf("debug: tok: %v  state: %v", tok, state))
		if tok == fflib.FFTok_error {
			goto tokerror
		}

		switch state {

		case fflib.FFParse_map_start:
			if tok != fflib.FFTok_left_bracket {
				wantedTok = fflib.FFTok_left_bracket
				goto wrongtokenerror
			}
			state = fflib.FFParse_want_key
			continue

		case fflib.FFParse_after_value:
			if tok == fflib.FFTok_comma {
				state = fflib.FFParse_want_key
			} else if tok == fflib.FFTok_right_bracket {
				goto done
			} else {
				wantedTok = fflib.FFTok_comma
				goto wrongtokenerror
			}

		case fflib.FFParse_want_key:
			// json {} ended. goto exit. woo.
			if tok == fflib.FFTok_right_bracket {
				goto done
			}
			if tok != fflib.FFTok_string {
				wantedTok = fflib.FFTok_string
				goto wrongtokenerror
			}

			kn := fs.Output.Bytes()
			if len(kn) <= 0 {
				// "" case. hrm.
				currentKey = ffj_t_Environment_Variableno_such_key
				state = fflib.FFParse_want_colon
				goto mainparse
			} else {
				switch kn[0] {

				case 'n':

					if bytes.Equal(ffj_key_Environment_Variable_Name, kn) {
						currentKey = ffj_t_Environment_Variable_Name
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				case 's':

					if bytes.Equal(ffj_key_Environment_Variable_Secret, kn) {
						currentKey = ffj_t_Environment_Variable_Secret
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				case 't':

					if bytes.Equal(ffj_key_Environment_Variable_Type, kn) {
						currentKey = ffj_t_Environment_Variable_Type
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				case 'v':

					if bytes.Equal(ffj_key_Environment_Variable_Value, kn) {
						currentKey = ffj_t_Environment_Variable_Value
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				}

				if fflib.EqualFoldRight(ffj_key_Environment_Variable_Secret, kn) {
					currentKey = ffj_t_Environment_Variable_Secret
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.SimpleLetterEqualFold(ffj_key_Environment_Variable_Value, kn) {
					currentKey = ffj_t_Environment_Variable_Value
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.SimpleLetterEqualFold(ffj_key_Environment_Variable_Type, kn) {
					currentKey = ffj_t_Environment_Variable_Type
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.SimpleLetterEqualFold(ffj_key_Environment_Variable_Name, kn) {
					currentKey = ffj_t_Environment_Variable_Name
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				currentKey = ffj_t_Environment_Variableno_such_key
				state = fflib.FFParse_want_colon
				goto mainparse
			}

		case fflib.FFParse_want_colon:
			if tok != fflib.FFTok_colon {
				wantedTok = fflib.FFTok_colon
				goto wrongtokenerror
			}
			state = fflib.FFParse_want_value
			continue
		case fflib.FFParse_want_value:

			if tok == fflib.FFTok_left_brace || tok == fflib.FFTok_left_bracket || tok == fflib.FFTok_integer || tok == fflib.FFTok_double || tok == fflib.FFTok_string || tok == fflib.FFTok_bool || tok == fflib.FFTok_null {
				switch currentKey {

				case ffj_t_Environment_Variable_Name:
					goto handle_Name

				case ffj_t_Environment_Variable_Type:
					goto handle_Type

				case ffj_t_Environment_Variable_Value:
					goto handle_Value

				case ffj_t_Environment_Variable_Secret:
					goto handle_Secret

				case ffj_t_Environment_Variableno_such_key:
					err = fs.SkipField(tok)
					if err != nil {
						return fs.WrapErr(err)
					}
					state = fflib.FFParse_after_value
					goto mainparse
				}
			} else {
				goto wantedvalue
			}
		}
	}

handle_Name:

	/* handler: uj.Name type=string kind=string quoted=false*/

	{

		{
			if tok != fflib.FFTok_string && tok != fflib.FFTok_null {
				return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for string", tok))
			}
		}

		if tok == fflib.FFTok_null {

		} else {

			outBuf := fs.Output.Bytes()

			uj.Name = string(string(outBuf))

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_Type:

	/* handler: uj.Type type=mesos.Environment_Variable_Type kind=int32 quoted=false*/

	{
		if tok == fflib.FFTok_null {

			uj.Type = nil

			state = fflib.FFParse_after_value
			goto mainparse
		}

		tbuf, err := fs.CaptureField(tok)
		if err != nil {
			return fs.WrapErr(err)
		}

		if uj.Type == nil {
			uj.Type = new(Environment_Variable_Type)
		}

		err = uj.Type.UnmarshalJSON(tbuf)
		if err != nil {
			return fs.WrapErr(err)
		}
		state = fflib.FFParse_after_value
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_Value:

	/* handler: uj.Value type=string kind=string quoted=false*/

	{

		{
			if tok != fflib.FFTok_string && tok != fflib.FFTok_null {
				return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for string", tok))
			}
		}

		if tok == fflib.FFTok_null {

			uj.Value = nil

		} else {

			var tval string
			outBuf := fs.Output.Bytes()

			tval = string(string(outBuf))
			uj.Value = &tval

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_Secret:

	/* handler: uj.Secret type=mesos.Secret kind=struct quoted=false*/

	{
		if tok == fflib.FFTok_null {

			uj.Secret = nil

			state = fflib.FFParse_after_value
			goto mainparse
		}

		if uj.Secret == nil {
			uj.Secret = new(Secret)
		}

		err = uj.Secret.UnmarshalJSONFFLexer(fs, fflib.FFParse_want_key)
		if err != nil {
			return err
		}
		state = fflib.FFParse_after_value
	}

	state = fflib.FFParse_after_value
	goto mainparse

wantedvalue:
	return fs.WrapErr(fmt.Errorf("wanted value token, but got token: %v", tok))
wrongtokenerror:
	return fs.WrapErr(fmt.Errorf("ffjson: wanted token: %v, but got token: %v output=%s", wantedTok, tok, fs.Output.String()))
tokerror:
	if fs.BigError != nil {
		return fs.WrapErr(fs.BigError)
	}
	err = fs.Error.ToError()
	if err != nil {
		return fs.WrapErr(err)
	}
	panic("ffjson-generated: unreachable, please report bug.")
done:

	return nil
}

func (mj *ExecutorID) MarshalJSON() ([]byte, error) {
	var buf fflib.Buffer
	if mj == nil {
		buf.WriteString("null")
		return buf.Bytes(), nil
	}
	err := mj.MarshalJSONBuf(&buf)
	if err != nil {
		return nil, err
	}
	return buf.Bytes(), nil
}
func (mj *ExecutorID) MarshalJSONBuf(buf fflib.EncodingBuffer) error {
	if mj == nil {
		buf.WriteString("null")
		return nil
	}
	var err error
	var obj []byte
	_ = obj
	_ = err
	buf.WriteString(`{"value":`)
	fflib.WriteJsonString(buf, string(mj.Value))
	buf.WriteByte('}')
	return nil
}

const (
	ffj_t_ExecutorIDbase = iota
	ffj_t_ExecutorIDno_such_key

	ffj_t_ExecutorID_Value
)

var ffj_key_ExecutorID_Value = []byte("value")

func (uj *ExecutorID) UnmarshalJSON(input []byte) error {
	fs := fflib.NewFFLexer(input)
	return uj.UnmarshalJSONFFLexer(fs, fflib.FFParse_map_start)
}

func (uj *ExecutorID) UnmarshalJSONFFLexer(fs *fflib.FFLexer, state fflib.FFParseState) error {
	var err error = nil
	currentKey := ffj_t_ExecutorIDbase
	_ = currentKey
	tok := fflib.FFTok_init
	wantedTok := fflib.FFTok_init

mainparse:
	for {
		tok = fs.Scan()
		//	println(fmt.Sprintf("debug: tok: %v  state: %v", tok, state))
		if tok == fflib.FFTok_error {
			goto tokerror
		}

		switch state {

		case fflib.FFParse_map_start:
			if tok != fflib.FFTok_left_bracket {
				wantedTok = fflib.FFTok_left_bracket
				goto wrongtokenerror
			}
			state = fflib.FFParse_want_key
			continue

		case fflib.FFParse_after_value:
			if tok == fflib.FFTok_comma {
				state = fflib.FFParse_want_key
			} else if tok == fflib.FFTok_right_bracket {
				goto done
			} else {
				wantedTok = fflib.FFTok_comma
				goto wrongtokenerror
			}

		case fflib.FFParse_want_key:
			// json {} ended. goto exit. woo.
			if tok == fflib.FFTok_right_bracket {
				goto done
			}
			if tok != fflib.FFTok_string {
				wantedTok = fflib.FFTok_string
				goto wrongtokenerror
			}

			kn := fs.Output.Bytes()
			if len(kn) <= 0 {
				// "" case. hrm.
				currentKey = ffj_t_ExecutorIDno_such_key
				state = fflib.FFParse_want_colon
				goto mainparse
			} else {
				switch kn[0] {

				case 'v':

					if bytes.Equal(ffj_key_ExecutorID_Value, kn) {
						currentKey = ffj_t_ExecutorID_Value
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				}

				if fflib.SimpleLetterEqualFold(ffj_key_ExecutorID_Value, kn) {
					currentKey = ffj_t_ExecutorID_Value
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				currentKey = ffj_t_ExecutorIDno_such_key
				state = fflib.FFParse_want_colon
				goto mainparse
			}

		case fflib.FFParse_want_colon:
			if tok != fflib.FFTok_colon {
				wantedTok = fflib.FFTok_colon
				goto wrongtokenerror
			}
			state = fflib.FFParse_want_value
			continue
		case fflib.FFParse_want_value:

			if tok == fflib.FFTok_left_brace || tok == fflib.FFTok_left_bracket || tok == fflib.FFTok_integer || tok == fflib.FFTok_double || tok == fflib.FFTok_string || tok == fflib.FFTok_bool || tok == fflib.FFTok_null {
				switch currentKey {

				case ffj_t_ExecutorID_Value:
					goto handle_Value

				case ffj_t_ExecutorIDno_such_key:
					err = fs.SkipField(tok)
					if err != nil {
						return fs.WrapErr(err)
					}
					state = fflib.FFParse_after_value
					goto mainparse
				}
			} else {
				goto wantedvalue
			}
		}
	}

handle_Value:

	/* handler: uj.Value type=string kind=string quoted=false*/

	{

		{
			if tok != fflib.FFTok_string && tok != fflib.FFTok_null {
				return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for string", tok))
			}
		}

		if tok == fflib.FFTok_null {

		} else {

			outBuf := fs.Output.Bytes()

			uj.Value = string(string(outBuf))

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

wantedvalue:
	return fs.WrapErr(fmt.Errorf("wanted value token, but got token: %v", tok))
wrongtokenerror:
	return fs.WrapErr(fmt.Errorf("ffjson: wanted token: %v, but got token: %v output=%s", wantedTok, tok, fs.Output.String()))
tokerror:
	if fs.BigError != nil {
		return fs.WrapErr(fs.BigError)
	}
	err = fs.Error.ToError()
	if err != nil {
		return fs.WrapErr(err)
	}
	panic("ffjson-generated: unreachable, please report bug.")
done:

	return nil
}

func (mj *ExecutorInfo) MarshalJSON() ([]byte, error) {
	var buf fflib.Buffer
	if mj == nil {
		buf.WriteString("null")
		return buf.Bytes(), nil
	}
	err := mj.MarshalJSONBuf(&buf)
	if err != nil {
		return nil, err
	}
	return buf.Bytes(), nil
}
func (mj *ExecutorInfo) MarshalJSONBuf(buf fflib.EncodingBuffer) error {
	if mj == nil {
		buf.WriteString("null")
		return nil
	}
	var err error
	var obj []byte
	_ = obj
	_ = err
	buf.WriteString(`{ "type":`)

	{

		obj, err = mj.Type.MarshalJSON()
		if err != nil {
			return err
		}
		buf.Write(obj)

	}
	buf.WriteString(`,"executor_id":`)

	{

		err = mj.ExecutorID.MarshalJSONBuf(buf)
		if err != nil {
			return err
		}

	}
	buf.WriteByte(',')
	if mj.FrameworkID != nil {
		if true {
			buf.WriteString(`"framework_id":`)

			{

				err = mj.FrameworkID.MarshalJSONBuf(buf)
				if err != nil {
					return err
				}

			}
			buf.WriteByte(',')
		}
	}
	if mj.Command != nil {
		if true {
			buf.WriteString(`"command":`)

			{

				err = mj.Command.MarshalJSONBuf(buf)
				if err != nil {
					return err
				}

			}
			buf.WriteByte(',')
		}
	}
	if mj.Container != nil {
		if true {
			buf.WriteString(`"container":`)

			{

				err = mj.Container.MarshalJSONBuf(buf)
				if err != nil {
					return err
				}

			}
			buf.WriteByte(',')
		}
	}
	buf.WriteString(`"resources":`)
	if mj.Resources != nil {
		buf.WriteString(`[`)
		for i, v := range mj.Resources {
			if i != 0 {
				buf.WriteString(`,`)
			}

			{

				err = v.MarshalJSONBuf(buf)
				if err != nil {
					return err
				}

			}
		}
		buf.WriteString(`]`)
	} else {
		buf.WriteString(`null`)
	}
	buf.WriteByte(',')
	if mj.Name != nil {
		if true {
			buf.WriteString(`"name":`)
			fflib.WriteJsonString(buf, string(*mj.Name))
			buf.WriteByte(',')
		}
	}
	if mj.Source != nil {
		if true {
			buf.WriteString(`"source":`)
			fflib.WriteJsonString(buf, string(*mj.Source))
			buf.WriteByte(',')
		}
	}
	if len(mj.Data) != 0 {
		buf.WriteString(`"data":`)
		if mj.Data != nil {
			buf.WriteString(`"`)
			{
				enc := base64.NewEncoder(base64.StdEncoding, buf)
				enc.Write(reflect.Indirect(reflect.ValueOf(mj.Data)).Bytes())
				enc.Close()
			}
			buf.WriteString(`"`)
		} else {
			buf.WriteString(`null`)
		}
		buf.WriteByte(',')
	}
	if mj.Discovery != nil {
		if true {
			buf.WriteString(`"discovery":`)

			{

				err = mj.Discovery.MarshalJSONBuf(buf)
				if err != nil {
					return err
				}

			}
			buf.WriteByte(',')
		}
	}
	if mj.ShutdownGracePeriod != nil {
		if true {
			buf.WriteString(`"shutdown_grace_period":`)

			{

				err = mj.ShutdownGracePeriod.MarshalJSONBuf(buf)
				if err != nil {
					return err
				}

			}
			buf.WriteByte(',')
		}
	}
	if mj.Labels != nil {
		if true {
			buf.WriteString(`"labels":`)

			{

				err = mj.Labels.MarshalJSONBuf(buf)
				if err != nil {
					return err
				}

			}
			buf.WriteByte(',')
		}
	}
	buf.Rewind(1)
	buf.WriteByte('}')
	return nil
}

const (
	ffj_t_ExecutorInfobase = iota
	ffj_t_ExecutorInfono_such_key

	ffj_t_ExecutorInfo_Type

	ffj_t_ExecutorInfo_ExecutorID

	ffj_t_ExecutorInfo_FrameworkID

	ffj_t_ExecutorInfo_Command

	ffj_t_ExecutorInfo_Container

	ffj_t_ExecutorInfo_Resources

	ffj_t_ExecutorInfo_Name

	ffj_t_ExecutorInfo_Source

	ffj_t_ExecutorInfo_Data

	ffj_t_ExecutorInfo_Discovery

	ffj_t_ExecutorInfo_ShutdownGracePeriod

	ffj_t_ExecutorInfo_Labels
)

var ffj_key_ExecutorInfo_Type = []byte("type")

var ffj_key_ExecutorInfo_ExecutorID = []byte("executor_id")

var ffj_key_ExecutorInfo_FrameworkID = []byte("framework_id")

var ffj_key_ExecutorInfo_Command = []byte("command")

var ffj_key_ExecutorInfo_Container = []byte("container")

var ffj_key_ExecutorInfo_Resources = []byte("resources")

var ffj_key_ExecutorInfo_Name = []byte("name")

var ffj_key_ExecutorInfo_Source = []byte("source")

var ffj_key_ExecutorInfo_Data = []byte("data")

var ffj_key_ExecutorInfo_Discovery = []byte("discovery")

var ffj_key_ExecutorInfo_ShutdownGracePeriod = []byte("shutdown_grace_period")

var ffj_key_ExecutorInfo_Labels = []byte("labels")

func (uj *ExecutorInfo) UnmarshalJSON(input []byte) error {
	fs := fflib.NewFFLexer(input)
	return uj.UnmarshalJSONFFLexer(fs, fflib.FFParse_map_start)
}

func (uj *ExecutorInfo) UnmarshalJSONFFLexer(fs *fflib.FFLexer, state fflib.FFParseState) error {
	var err error = nil
	currentKey := ffj_t_ExecutorInfobase
	_ = currentKey
	tok := fflib.FFTok_init
	wantedTok := fflib.FFTok_init

mainparse:
	for {
		tok = fs.Scan()
		//	println(fmt.Sprintf("debug: tok: %v  state: %v", tok, state))
		if tok == fflib.FFTok_error {
			goto tokerror
		}

		switch state {

		case fflib.FFParse_map_start:
			if tok != fflib.FFTok_left_bracket {
				wantedTok = fflib.FFTok_left_bracket
				goto wrongtokenerror
			}
			state = fflib.FFParse_want_key
			continue

		case fflib.FFParse_after_value:
			if tok == fflib.FFTok_comma {
				state = fflib.FFParse_want_key
			} else if tok == fflib.FFTok_right_bracket {
				goto done
			} else {
				wantedTok = fflib.FFTok_comma
				goto wrongtokenerror
			}

		case fflib.FFParse_want_key:
			// json {} ended. goto exit. woo.
			if tok == fflib.FFTok_right_bracket {
				goto done
			}
			if tok != fflib.FFTok_string {
				wantedTok = fflib.FFTok_string
				goto wrongtokenerror
			}

			kn := fs.Output.Bytes()
			if len(kn) <= 0 {
				// "" case. hrm.
				currentKey = ffj_t_ExecutorInfono_such_key
				state = fflib.FFParse_want_colon
				goto mainparse
			} else {
				switch kn[0] {

				case 'c':

					if bytes.Equal(ffj_key_ExecutorInfo_Command, kn) {
						currentKey = ffj_t_ExecutorInfo_Command
						state = fflib.FFParse_want_colon
						goto mainparse

					} else if bytes.Equal(ffj_key_ExecutorInfo_Container, kn) {
						currentKey = ffj_t_ExecutorInfo_Container
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				case 'd':

					if bytes.Equal(ffj_key_ExecutorInfo_Data, kn) {
						currentKey = ffj_t_ExecutorInfo_Data
						state = fflib.FFParse_want_colon
						goto mainparse

					} else if bytes.Equal(ffj_key_ExecutorInfo_Discovery, kn) {
						currentKey = ffj_t_ExecutorInfo_Discovery
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				case 'e':

					if bytes.Equal(ffj_key_ExecutorInfo_ExecutorID, kn) {
						currentKey = ffj_t_ExecutorInfo_ExecutorID
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				case 'f':

					if bytes.Equal(ffj_key_ExecutorInfo_FrameworkID, kn) {
						currentKey = ffj_t_ExecutorInfo_FrameworkID
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				case 'l':

					if bytes.Equal(ffj_key_ExecutorInfo_Labels, kn) {
						currentKey = ffj_t_ExecutorInfo_Labels
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				case 'n':

					if bytes.Equal(ffj_key_ExecutorInfo_Name, kn) {
						currentKey = ffj_t_ExecutorInfo_Name
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				case 'r':

					if bytes.Equal(ffj_key_ExecutorInfo_Resources, kn) {
						currentKey = ffj_t_ExecutorInfo_Resources
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				case 's':

					if bytes.Equal(ffj_key_ExecutorInfo_Source, kn) {
						currentKey = ffj_t_ExecutorInfo_Source
						state = fflib.FFParse_want_colon
						goto mainparse

					} else if bytes.Equal(ffj_key_ExecutorInfo_ShutdownGracePeriod, kn) {
						currentKey = ffj_t_ExecutorInfo_ShutdownGracePeriod
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				case 't':

					if bytes.Equal(ffj_key_ExecutorInfo_Type, kn) {
						currentKey = ffj_t_ExecutorInfo_Type
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				}

				if fflib.EqualFoldRight(ffj_key_ExecutorInfo_Labels, kn) {
					currentKey = ffj_t_ExecutorInfo_Labels
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffj_key_ExecutorInfo_ShutdownGracePeriod, kn) {
					currentKey = ffj_t_ExecutorInfo_ShutdownGracePeriod
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffj_key_ExecutorInfo_Discovery, kn) {
					currentKey = ffj_t_ExecutorInfo_Discovery
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.SimpleLetterEqualFold(ffj_key_ExecutorInfo_Data, kn) {
					currentKey = ffj_t_ExecutorInfo_Data
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffj_key_ExecutorInfo_Source, kn) {
					currentKey = ffj_t_ExecutorInfo_Source
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.SimpleLetterEqualFold(ffj_key_ExecutorInfo_Name, kn) {
					currentKey = ffj_t_ExecutorInfo_Name
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffj_key_ExecutorInfo_Resources, kn) {
					currentKey = ffj_t_ExecutorInfo_Resources
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.SimpleLetterEqualFold(ffj_key_ExecutorInfo_Container, kn) {
					currentKey = ffj_t_ExecutorInfo_Container
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.SimpleLetterEqualFold(ffj_key_ExecutorInfo_Command, kn) {
					currentKey = ffj_t_ExecutorInfo_Command
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffj_key_ExecutorInfo_FrameworkID, kn) {
					currentKey = ffj_t_ExecutorInfo_FrameworkID
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.AsciiEqualFold(ffj_key_ExecutorInfo_ExecutorID, kn) {
					currentKey = ffj_t_ExecutorInfo_ExecutorID
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.SimpleLetterEqualFold(ffj_key_ExecutorInfo_Type, kn) {
					currentKey = ffj_t_ExecutorInfo_Type
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				currentKey = ffj_t_ExecutorInfono_such_key
				state = fflib.FFParse_want_colon
				goto mainparse
			}

		case fflib.FFParse_want_colon:
			if tok != fflib.FFTok_colon {
				wantedTok = fflib.FFTok_colon
				goto wrongtokenerror
			}
			state = fflib.FFParse_want_value
			continue
		case fflib.FFParse_want_value:

			if tok == fflib.FFTok_left_brace || tok == fflib.FFTok_left_bracket || tok == fflib.FFTok_integer || tok == fflib.FFTok_double || tok == fflib.FFTok_string || tok == fflib.FFTok_bool || tok == fflib.FFTok_null {
				switch currentKey {

				case ffj_t_ExecutorInfo_Type:
					goto handle_Type

				case ffj_t_ExecutorInfo_ExecutorID:
					goto handle_ExecutorID

				case ffj_t_ExecutorInfo_FrameworkID:
					goto handle_FrameworkID

				case ffj_t_ExecutorInfo_Command:
					goto handle_Command

				case ffj_t_ExecutorInfo_Container:
					goto handle_Container

				case ffj_t_ExecutorInfo_Resources:
					goto handle_Resources

				case ffj_t_ExecutorInfo_Name:
					goto handle_Name

				case ffj_t_ExecutorInfo_Source:
					goto handle_Source

				case ffj_t_ExecutorInfo_Data:
					goto handle_Data

				case ffj_t_ExecutorInfo_Discovery:
					goto handle_Discovery

				case ffj_t_ExecutorInfo_ShutdownGracePeriod:
					goto handle_ShutdownGracePeriod

				case ffj_t_ExecutorInfo_Labels:
					goto handle_Labels

				case ffj_t_ExecutorInfono_such_key:
					err = fs.SkipField(tok)
					if err != nil {
						return fs.WrapErr(err)
					}
					state = fflib.FFParse_after_value
					goto mainparse
				}
			} else {
				goto wantedvalue
			}
		}
	}

handle_Type:

	/* handler: uj.Type type=mesos.ExecutorInfo_Type kind=int32 quoted=false*/

	{
		if tok == fflib.FFTok_null {

			state = fflib.FFParse_after_value
			goto mainparse
		}

		tbuf, err := fs.CaptureField(tok)
		if err != nil {
			return fs.WrapErr(err)
		}

		err = uj.Type.UnmarshalJSON(tbuf)
		if err != nil {
			return fs.WrapErr(err)
		}
		state = fflib.FFParse_after_value
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_ExecutorID:

	/* handler: uj.ExecutorID type=mesos.ExecutorID kind=struct quoted=false*/

	{
		if tok == fflib.FFTok_null {

			state = fflib.FFParse_after_value
			goto mainparse
		}

		err = uj.ExecutorID.UnmarshalJSONFFLexer(fs, fflib.FFParse_want_key)
		if err != nil {
			return err
		}
		state = fflib.FFParse_after_value
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_FrameworkID:

	/* handler: uj.FrameworkID type=mesos.FrameworkID kind=struct quoted=false*/

	{
		if tok == fflib.FFTok_null {

			uj.FrameworkID = nil

			state = fflib.FFParse_after_value
			goto mainparse
		}

		if uj.FrameworkID == nil {
			uj.FrameworkID = new(FrameworkID)
		}

		err = uj.FrameworkID.UnmarshalJSONFFLexer(fs, fflib.FFParse_want_key)
		if err != nil {
			return err
		}
		state = fflib.FFParse_after_value
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_Command:

	/* handler: uj.Command type=mesos.CommandInfo kind=struct quoted=false*/

	{
		if tok == fflib.FFTok_null {

			uj.Command = nil

			state = fflib.FFParse_after_value
			goto mainparse
		}

		if uj.Command == nil {
			uj.Command = new(CommandInfo)
		}

		err = uj.Command.UnmarshalJSONFFLexer(fs, fflib.FFParse_want_key)
		if err != nil {
			return err
		}
		state = fflib.FFParse_after_value
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_Container:

	/* handler: uj.Container type=mesos.ContainerInfo kind=struct quoted=false*/

	{
		if tok == fflib.FFTok_null {

			uj.Container = nil

			state = fflib.FFParse_after_value
			goto mainparse
		}

		if uj.Container == nil {
			uj.Container = new(ContainerInfo)
		}

		err = uj.Container.UnmarshalJSONFFLexer(fs, fflib.FFParse_want_key)
		if err != nil {
			return err
		}
		state = fflib.FFParse_after_value
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_Resources:

	/* handler: uj.Resources type=[]mesos.Resource kind=slice quoted=false*/

	{

		{
			if tok != fflib.FFTok_left_brace && tok != fflib.FFTok_null {
				return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for ", tok))
			}
		}

		if tok == fflib.FFTok_null {
			uj.Resources = nil
		} else {

			uj.Resources = []Resource{}

			wantVal := true

			for {

				var tmp_uj__Resources Resource

				tok = fs.Scan()
				if tok == fflib.FFTok_error {
					goto tokerror
				}
				if tok == fflib.FFTok_right_brace {
					break
				}

				if tok == fflib.FFTok_comma {
					if wantVal == true {
						// TODO(pquerna): this isn't an ideal error message, this handles
						// things like [,,,] as an array value.
						return fs.WrapErr(fmt.Errorf("wanted value token, but got token: %v", tok))
					}
					continue
				} else {
					wantVal = true
				}

				/* handler: tmp_uj__Resources type=mesos.Resource kind=struct quoted=false*/

				{
					if tok == fflib.FFTok_null {

						state = fflib.FFParse_after_value
						goto mainparse
					}

					err = tmp_uj__Resources.UnmarshalJSONFFLexer(fs, fflib.FFParse_want_key)
					if err != nil {
						return err
					}
					state = fflib.FFParse_after_value
				}

				uj.Resources = append(uj.Resources, tmp_uj__Resources)

				wantVal = false
			}
		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_Name:

	/* handler: uj.Name type=string kind=string quoted=false*/

	{

		{
			if tok != fflib.FFTok_string && tok != fflib.FFTok_null {
				return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for string", tok))
			}
		}

		if tok == fflib.FFTok_null {

			uj.Name = nil

		} else {

			var tval string
			outBuf := fs.Output.Bytes()

			tval = string(string(outBuf))
			uj.Name = &tval

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_Source:

	/* handler: uj.Source type=string kind=string quoted=false*/

	{

		{
			if tok != fflib.FFTok_string && tok != fflib.FFTok_null {
				return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for string", tok))
			}
		}

		if tok == fflib.FFTok_null {

			uj.Source = nil

		} else {

			var tval string
			outBuf := fs.Output.Bytes()

			tval = string(string(outBuf))
			uj.Source = &tval

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_Data:

	/* handler: uj.Data type=[]uint8 kind=slice quoted=false*/

	{

		{
			if tok != fflib.FFTok_string && tok != fflib.FFTok_null {
				return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for ", tok))
			}
		}

		if tok == fflib.FFTok_null {
			uj.Data = nil
		} else {
			b := make([]byte, base64.StdEncoding.DecodedLen(fs.Output.Len()))
			n, err := base64.StdEncoding.Decode(b, fs.Output.Bytes())
			if err != nil {
				return fs.WrapErr(err)
			}

			v := reflect.ValueOf(&uj.Data).Elem()
			v.SetBytes(b[0:n])

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_Discovery:

	/* handler: uj.Discovery type=mesos.DiscoveryInfo kind=struct quoted=false*/

	{
		if tok == fflib.FFTok_null {

			uj.Discovery = nil

			state = fflib.FFParse_after_value
			goto mainparse
		}

		if uj.Discovery == nil {
			uj.Discovery = new(DiscoveryInfo)
		}

		err = uj.Discovery.UnmarshalJSONFFLexer(fs, fflib.FFParse_want_key)
		if err != nil {
			return err
		}
		state = fflib.FFParse_after_value
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_ShutdownGracePeriod:

	/* handler: uj.ShutdownGracePeriod type=mesos.DurationInfo kind=struct quoted=false*/

	{
		if tok == fflib.FFTok_null {

			uj.ShutdownGracePeriod = nil

			state = fflib.FFParse_after_value
			goto mainparse
		}

		if uj.ShutdownGracePeriod == nil {
			uj.ShutdownGracePeriod = new(DurationInfo)
		}

		err = uj.ShutdownGracePeriod.UnmarshalJSONFFLexer(fs, fflib.FFParse_want_key)
		if err != nil {
			return err
		}
		state = fflib.FFParse_after_value
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_Labels:

	/* handler: uj.Labels type=mesos.Labels kind=struct quoted=false*/

	{
		if tok == fflib.FFTok_null {

			uj.Labels = nil

			state = fflib.FFParse_after_value
			goto mainparse
		}

		if uj.Labels == nil {
			uj.Labels = new(Labels)
		}

		err = uj.Labels.UnmarshalJSONFFLexer(fs, fflib.FFParse_want_key)
		if err != nil {
			return err
		}
		state = fflib.FFParse_after_value
	}

	state = fflib.FFParse_after_value
	goto mainparse

wantedvalue:
	return fs.WrapErr(fmt.Errorf("wanted value token, but got token: %v", tok))
wrongtokenerror:
	return fs.WrapErr(fmt.Errorf("ffjson: wanted token: %v, but got token: %v output=%s", wantedTok, tok, fs.Output.String()))
tokerror:
	if fs.BigError != nil {
		return fs.WrapErr(fs.BigError)
	}
	err = fs.Error.ToError()
	if err != nil {
		return fs.WrapErr(err)
	}
	panic("ffjson-generated: unreachable, please report bug.")
done:

	return nil
}

func (mj *FileInfo) MarshalJSON() ([]byte, error) {
	var buf fflib.Buffer
	if mj == nil {
		buf.WriteString("null")
		return buf.Bytes(), nil
	}
	err := mj.MarshalJSONBuf(&buf)
	if err != nil {
		return nil, err
	}
	return buf.Bytes(), nil
}
func (mj *FileInfo) MarshalJSONBuf(buf fflib.EncodingBuffer) error {
	if mj == nil {
		buf.WriteString("null")
		return nil
	}
	var err error
	var obj []byte
	_ = obj
	_ = err
	buf.WriteString(`{ "path":`)
	fflib.WriteJsonString(buf, string(mj.Path))
	buf.WriteByte(',')
	if mj.Nlink != nil {
		if true {
			buf.WriteString(`"nlink":`)
			fflib.FormatBits2(buf, uint64(*mj.Nlink), 10, *mj.Nlink < 0)
			buf.WriteByte(',')
		}
	}
	if mj.Size_ != nil {
		if true {
			buf.WriteString(`"size":`)
			fflib.FormatBits2(buf, uint64(*mj.Size_), 10, false)
			buf.WriteByte(',')
		}
	}
	if mj.Mtime != nil {
		if true {
			buf.WriteString(`"mtime":`)

			{

				err = mj.Mtime.MarshalJSONBuf(buf)
				if err != nil {
					return err
				}

			}
			buf.WriteByte(',')
		}
	}
	if mj.Mode != nil {
		if true {
			buf.WriteString(`"mode":`)
			fflib.FormatBits2(buf, uint64(*mj.Mode), 10, false)
			buf.WriteByte(',')
		}
	}
	if mj.UID != nil {
		if true {
			buf.WriteString(`"uid":`)
			fflib.WriteJsonString(buf, string(*mj.UID))
			buf.WriteByte(',')
		}
	}
	if mj.GID != nil {
		if true {
			buf.WriteString(`"gid":`)
			fflib.WriteJsonString(buf, string(*mj.GID))
			buf.WriteByte(',')
		}
	}
	buf.Rewind(1)
	buf.WriteByte('}')
	return nil
}

const (
	ffj_t_FileInfobase = iota
	ffj_t_FileInfono_such_key

	ffj_t_FileInfo_Path

	ffj_t_FileInfo_Nlink

	ffj_t_FileInfo_Size_

	ffj_t_FileInfo_Mtime

	ffj_t_FileInfo_Mode

	ffj_t_FileInfo_UID

	ffj_t_FileInfo_GID
)

var ffj_key_FileInfo_Path = []byte("path")

var ffj_key_FileInfo_Nlink = []byte("nlink")

var ffj_key_FileInfo_Size_ = []byte("size")

var ffj_key_FileInfo_Mtime = []byte("mtime")

var ffj_key_FileInfo_Mode = []byte("mode")

var ffj_key_FileInfo_UID = []byte("uid")

var ffj_key_FileInfo_GID = []byte("gid")

func (uj *FileInfo) UnmarshalJSON(input []byte) error {
	fs := fflib.NewFFLexer(input)
	return uj.UnmarshalJSONFFLexer(fs, fflib.FFParse_map_start)
}

func (uj *FileInfo) UnmarshalJSONFFLexer(fs *fflib.FFLexer, state fflib.FFParseState) error {
	var err error = nil
	currentKey := ffj_t_FileInfobase
	_ = currentKey
	tok := fflib.FFTok_init
	wantedTok := fflib.FFTok_init

mainparse:
	for {
		tok = fs.Scan()
		//	println(fmt.Sprintf("debug: tok: %v  state: %v", tok, state))
		if tok == fflib.FFTok_error {
			goto tokerror
		}

		switch state {

		case fflib.FFParse_map_start:
			if tok != fflib.FFTok_left_bracket {
				wantedTok = fflib.FFTok_left_bracket
				goto wrongtokenerror
			}
			state = fflib.FFParse_want_key
			continue

		case fflib.FFParse_after_value:
			if tok == fflib.FFTok_comma {
				state = fflib.FFParse_want_key
			} else if tok == fflib.FFTok_right_bracket {
				goto done
			} else {
				wantedTok = fflib.FFTok_comma
				goto wrongtokenerror
			}

		case fflib.FFParse_want_key:
			// json {} ended. goto exit. woo.
			if tok == fflib.FFTok_right_bracket {
				goto done
			}
			if tok != fflib.FFTok_string {
				wantedTok = fflib.FFTok_string
				goto wrongtokenerror
			}

			kn := fs.Output.Bytes()
			if len(kn) <= 0 {
				// "" case. hrm.
				currentKey = ffj_t_FileInfono_such_key
				state = fflib.FFParse_want_colon
				goto mainparse
			} else {
				switch kn[0] {

				case 'g':

					if bytes.Equal(ffj_key_FileInfo_GID, kn) {
						currentKey = ffj_t_FileInfo_GID
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				case 'm':

					if bytes.Equal(ffj_key_FileInfo_Mtime, kn) {
						currentKey = ffj_t_FileInfo_Mtime
						state = fflib.FFParse_want_colon
						goto mainparse

					} else if bytes.Equal(ffj_key_FileInfo_Mode, kn) {
						currentKey = ffj_t_FileInfo_Mode
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				case 'n':

					if bytes.Equal(ffj_key_FileInfo_Nlink, kn) {
						currentKey = ffj_t_FileInfo_Nlink
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				case 'p':

					if bytes.Equal(ffj_key_FileInfo_Path, kn) {
						currentKey = ffj_t_FileInfo_Path
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				case 's':

					if bytes.Equal(ffj_key_FileInfo_Size_, kn) {
						currentKey = ffj_t_FileInfo_Size_
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				case 'u':

					if bytes.Equal(ffj_key_FileInfo_UID, kn) {
						currentKey = ffj_t_FileInfo_UID
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				}

				if fflib.SimpleLetterEqualFold(ffj_key_FileInfo_GID, kn) {
					currentKey = ffj_t_FileInfo_GID
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.SimpleLetterEqualFold(ffj_key_FileInfo_UID, kn) {
					currentKey = ffj_t_FileInfo_UID
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.SimpleLetterEqualFold(ffj_key_FileInfo_Mode, kn) {
					currentKey = ffj_t_FileInfo_Mode
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.SimpleLetterEqualFold(ffj_key_FileInfo_Mtime, kn) {
					currentKey = ffj_t_FileInfo_Mtime
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffj_key_FileInfo_Size_, kn) {
					currentKey = ffj_t_FileInfo_Size_
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffj_key_FileInfo_Nlink, kn) {
					currentKey = ffj_t_FileInfo_Nlink
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.SimpleLetterEqualFold(ffj_key_FileInfo_Path, kn) {
					currentKey = ffj_t_FileInfo_Path
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				currentKey = ffj_t_FileInfono_such_key
				state = fflib.FFParse_want_colon
				goto mainparse
			}

		case fflib.FFParse_want_colon:
			if tok != fflib.FFTok_colon {
				wantedTok = fflib.FFTok_colon
				goto wrongtokenerror
			}
			state = fflib.FFParse_want_value
			continue
		case fflib.FFParse_want_value:

			if tok == fflib.FFTok_left_brace || tok == fflib.FFTok_left_bracket || tok == fflib.FFTok_integer || tok == fflib.FFTok_double || tok == fflib.FFTok_string || tok == fflib.FFTok_bool || tok == fflib.FFTok_null {
				switch currentKey {

				case ffj_t_FileInfo_Path:
					goto handle_Path

				case ffj_t_FileInfo_Nlink:
					goto handle_Nlink

				case ffj_t_FileInfo_Size_:
					goto handle_Size_

				case ffj_t_FileInfo_Mtime:
					goto handle_Mtime

				case ffj_t_FileInfo_Mode:
					goto handle_Mode

				case ffj_t_FileInfo_UID:
					goto handle_UID

				case ffj_t_FileInfo_GID:
					goto handle_GID

				case ffj_t_FileInfono_such_key:
					err = fs.SkipField(tok)
					if err != nil {
						return fs.WrapErr(err)
					}
					state = fflib.FFParse_after_value
					goto mainparse
				}
			} else {
				goto wantedvalue
			}
		}
	}

handle_Path:

	/* handler: uj.Path type=string kind=string quoted=false*/

	{

		{
			if tok != fflib.FFTok_string && tok != fflib.FFTok_null {
				return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for string", tok))
			}
		}

		if tok == fflib.FFTok_null {

		} else {

			outBuf := fs.Output.Bytes()

			uj.Path = string(string(outBuf))

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_Nlink:

	/* handler: uj.Nlink type=int32 kind=int32 quoted=false*/

	{
		if tok != fflib.FFTok_integer && tok != fflib.FFTok_null {
			return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for int32", tok))
		}
	}

	{

		if tok == fflib.FFTok_null {

			uj.Nlink = nil

		} else {

			tval, err := fflib.ParseInt(fs.Output.Bytes(), 10, 32)

			if err != nil {
				return fs.WrapErr(err)
			}

			ttypval := int32(tval)
			uj.Nlink = &ttypval

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_Size_:

	/* handler: uj.Size_ type=uint64 kind=uint64 quoted=false*/

	{
		if tok != fflib.FFTok_integer && tok != fflib.FFTok_null {
			return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for uint64", tok))
		}
	}

	{

		if tok == fflib.FFTok_null {

			uj.Size_ = nil

		} else {

			tval, err := fflib.ParseUint(fs.Output.Bytes(), 10, 64)

			if err != nil {
				return fs.WrapErr(err)
			}

			ttypval := uint64(tval)
			uj.Size_ = &ttypval

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_Mtime:

	/* handler: uj.Mtime type=mesos.TimeInfo kind=struct quoted=false*/

	{
		if tok == fflib.FFTok_null {

			uj.Mtime = nil

			state = fflib.FFParse_after_value
			goto mainparse
		}

		if uj.Mtime == nil {
			uj.Mtime = new(TimeInfo)
		}

		err = uj.Mtime.UnmarshalJSONFFLexer(fs, fflib.FFParse_want_key)
		if err != nil {
			return err
		}
		state = fflib.FFParse_after_value
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_Mode:

	/* handler: uj.Mode type=uint32 kind=uint32 quoted=false*/

	{
		if tok != fflib.FFTok_integer && tok != fflib.FFTok_null {
			return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for uint32", tok))
		}
	}

	{

		if tok == fflib.FFTok_null {

			uj.Mode = nil

		} else {

			tval, err := fflib.ParseUint(fs.Output.Bytes(), 10, 32)

			if err != nil {
				return fs.WrapErr(err)
			}

			ttypval := uint32(tval)
			uj.Mode = &ttypval

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_UID:

	/* handler: uj.UID type=string kind=string quoted=false*/

	{

		{
			if tok != fflib.FFTok_string && tok != fflib.FFTok_null {
				return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for string", tok))
			}
		}

		if tok == fflib.FFTok_null {

			uj.UID = nil

		} else {

			var tval string
			outBuf := fs.Output.Bytes()

			tval = string(string(outBuf))
			uj.UID = &tval

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_GID:

	/* handler: uj.GID type=string kind=string quoted=false*/

	{

		{
			if tok != fflib.FFTok_string && tok != fflib.FFTok_null {
				return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for string", tok))
			}
		}

		if tok == fflib.FFTok_null {

			uj.GID = nil

		} else {

			var tval string
			outBuf := fs.Output.Bytes()

			tval = string(string(outBuf))
			uj.GID = &tval

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

wantedvalue:
	return fs.WrapErr(fmt.Errorf("wanted value token, but got token: %v", tok))
wrongtokenerror:
	return fs.WrapErr(fmt.Errorf("ffjson: wanted token: %v, but got token: %v output=%s", wantedTok, tok, fs.Output.String()))
tokerror:
	if fs.BigError != nil {
		return fs.WrapErr(fs.BigError)
	}
	err = fs.Error.ToError()
	if err != nil {
		return fs.WrapErr(err)
	}
	panic("ffjson-generated: unreachable, please report bug.")
done:

	return nil
}

func (mj *Filters) MarshalJSON() ([]byte, error) {
	var buf fflib.Buffer
	if mj == nil {
		buf.WriteString("null")
		return buf.Bytes(), nil
	}
	err := mj.MarshalJSONBuf(&buf)
	if err != nil {
		return nil, err
	}
	return buf.Bytes(), nil
}
func (mj *Filters) MarshalJSONBuf(buf fflib.EncodingBuffer) error {
	if mj == nil {
		buf.WriteString("null")
		return nil
	}
	var err error
	var obj []byte
	_ = obj
	_ = err
	buf.WriteString(`{ `)
	if mj.RefuseSeconds != nil {
		if true {
			buf.WriteString(`"refuse_seconds":`)
			fflib.AppendFloat(buf, float64(*mj.RefuseSeconds), 'g', -1, 64)
			buf.WriteByte(',')
		}
	}
	buf.Rewind(1)
	buf.WriteByte('}')
	return nil
}

const (
	ffj_t_Filtersbase = iota
	ffj_t_Filtersno_such_key

	ffj_t_Filters_RefuseSeconds
)

var ffj_key_Filters_RefuseSeconds = []byte("refuse_seconds")

func (uj *Filters) UnmarshalJSON(input []byte) error {
	fs := fflib.NewFFLexer(input)
	return uj.UnmarshalJSONFFLexer(fs, fflib.FFParse_map_start)
}

func (uj *Filters) UnmarshalJSONFFLexer(fs *fflib.FFLexer, state fflib.FFParseState) error {
	var err error = nil
	currentKey := ffj_t_Filtersbase
	_ = currentKey
	tok := fflib.FFTok_init
	wantedTok := fflib.FFTok_init

mainparse:
	for {
		tok = fs.Scan()
		//	println(fmt.Sprintf("debug: tok: %v  state: %v", tok, state))
		if tok == fflib.FFTok_error {
			goto tokerror
		}

		switch state {

		case fflib.FFParse_map_start:
			if tok != fflib.FFTok_left_bracket {
				wantedTok = fflib.FFTok_left_bracket
				goto wrongtokenerror
			}
			state = fflib.FFParse_want_key
			continue

		case fflib.FFParse_after_value:
			if tok == fflib.FFTok_comma {
				state = fflib.FFParse_want_key
			} else if tok == fflib.FFTok_right_bracket {
				goto done
			} else {
				wantedTok = fflib.FFTok_comma
				goto wrongtokenerror
			}

		case fflib.FFParse_want_key:
			// json {} ended. goto exit. woo.
			if tok == fflib.FFTok_right_bracket {
				goto done
			}
			if tok != fflib.FFTok_string {
				wantedTok = fflib.FFTok_string
				goto wrongtokenerror
			}

			kn := fs.Output.Bytes()
			if len(kn) <= 0 {
				// "" case. hrm.
				currentKey = ffj_t_Filtersno_such_key
				state = fflib.FFParse_want_colon
				goto mainparse
			} else {
				switch kn[0] {

				case 'r':

					if bytes.Equal(ffj_key_Filters_RefuseSeconds, kn) {
						currentKey = ffj_t_Filters_RefuseSeconds
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				}

				if fflib.EqualFoldRight(ffj_key_Filters_RefuseSeconds, kn) {
					currentKey = ffj_t_Filters_RefuseSeconds
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				currentKey = ffj_t_Filtersno_such_key
				state = fflib.FFParse_want_colon
				goto mainparse
			}

		case fflib.FFParse_want_colon:
			if tok != fflib.FFTok_colon {
				wantedTok = fflib.FFTok_colon
				goto wrongtokenerror
			}
			state = fflib.FFParse_want_value
			continue
		case fflib.FFParse_want_value:

			if tok == fflib.FFTok_left_brace || tok == fflib.FFTok_left_bracket || tok == fflib.FFTok_integer || tok == fflib.FFTok_double || tok == fflib.FFTok_string || tok == fflib.FFTok_bool || tok == fflib.FFTok_null {
				switch currentKey {

				case ffj_t_Filters_RefuseSeconds:
					goto handle_RefuseSeconds

				case ffj_t_Filtersno_such_key:
					err = fs.SkipField(tok)
					if err != nil {
						return fs.WrapErr(err)
					}
					state = fflib.FFParse_after_value
					goto mainparse
				}
			} else {
				goto wantedvalue
			}
		}
	}

handle_RefuseSeconds:

	/* handler: uj.RefuseSeconds type=float64 kind=float64 quoted=false*/

	{
		if tok != fflib.FFTok_double && tok != fflib.FFTok_integer && tok != fflib.FFTok_null {
			return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for float64", tok))
		}
	}

	{

		if tok == fflib.FFTok_null {

			uj.RefuseSeconds = nil

		} else {

			tval, err := fflib.ParseFloat(fs.Output.Bytes(), 64)

			if err != nil {
				return fs.WrapErr(err)
			}

			ttypval := float64(tval)
			uj.RefuseSeconds = &ttypval

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

wantedvalue:
	return fs.WrapErr(fmt.Errorf("wanted value token, but got token: %v", tok))
wrongtokenerror:
	return fs.WrapErr(fmt.Errorf("ffjson: wanted token: %v, but got token: %v output=%s", wantedTok, tok, fs.Output.String()))
tokerror:
	if fs.BigError != nil {
		return fs.WrapErr(fs.BigError)
	}
	err = fs.Error.ToError()
	if err != nil {
		return fs.WrapErr(err)
	}
	panic("ffjson-generated: unreachable, please report bug.")
done:

	return nil
}

func (mj *Flag) MarshalJSON() ([]byte, error) {
	var buf fflib.Buffer
	if mj == nil {
		buf.WriteString("null")
		return buf.Bytes(), nil
	}
	err := mj.MarshalJSONBuf(&buf)
	if err != nil {
		return nil, err
	}
	return buf.Bytes(), nil
}
func (mj *Flag) MarshalJSONBuf(buf fflib.EncodingBuffer) error {
	if mj == nil {
		buf.WriteString("null")
		return nil
	}
	var err error
	var obj []byte
	_ = obj
	_ = err
	buf.WriteString(`{ "name":`)
	fflib.WriteJsonString(buf, string(mj.Name))
	buf.WriteByte(',')
	if mj.Value != nil {
		if true {
			buf.WriteString(`"value":`)
			fflib.WriteJsonString(buf, string(*mj.Value))
			buf.WriteByte(',')
		}
	}
	buf.Rewind(1)
	buf.WriteByte('}')
	return nil
}

const (
	ffj_t_Flagbase = iota
	ffj_t_Flagno_such_key

	ffj_t_Flag_Name

	ffj_t_Flag_Value
)

var ffj_key_Flag_Name = []byte("name")

var ffj_key_Flag_Value = []byte("value")

func (uj *Flag) UnmarshalJSON(input []byte) error {
	fs := fflib.NewFFLexer(input)
	return uj.UnmarshalJSONFFLexer(fs, fflib.FFParse_map_start)
}

func (uj *Flag) UnmarshalJSONFFLexer(fs *fflib.FFLexer, state fflib.FFParseState) error {
	var err error = nil
	currentKey := ffj_t_Flagbase
	_ = currentKey
	tok := fflib.FFTok_init
	wantedTok := fflib.FFTok_init

mainparse:
	for {
		tok = fs.Scan()
		//	println(fmt.Sprintf("debug: tok: %v  state: %v", tok, state))
		if tok == fflib.FFTok_error {
			goto tokerror
		}

		switch state {

		case fflib.FFParse_map_start:
			if tok != fflib.FFTok_left_bracket {
				wantedTok = fflib.FFTok_left_bracket
				goto wrongtokenerror
			}
			state = fflib.FFParse_want_key
			continue

		case fflib.FFParse_after_value:
			if tok == fflib.FFTok_comma {
				state = fflib.FFParse_want_key
			} else if tok == fflib.FFTok_right_bracket {
				goto done
			} else {
				wantedTok = fflib.FFTok_comma
				goto wrongtokenerror
			}

		case fflib.FFParse_want_key:
			// json {} ended. goto exit. woo.
			if tok == fflib.FFTok_right_bracket {
				goto done
			}
			if tok != fflib.FFTok_string {
				wantedTok = fflib.FFTok_string
				goto wrongtokenerror
			}

			kn := fs.Output.Bytes()
			if len(kn) <= 0 {
				// "" case. hrm.
				currentKey = ffj_t_Flagno_such_key
				state = fflib.FFParse_want_colon
				goto mainparse
			} else {
				switch kn[0] {

				case 'n':

					if bytes.Equal(ffj_key_Flag_Name, kn) {
						currentKey = ffj_t_Flag_Name
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				case 'v':

					if bytes.Equal(ffj_key_Flag_Value, kn) {
						currentKey = ffj_t_Flag_Value
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				}

				if fflib.SimpleLetterEqualFold(ffj_key_Flag_Value, kn) {
					currentKey = ffj_t_Flag_Value
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.SimpleLetterEqualFold(ffj_key_Flag_Name, kn) {
					currentKey = ffj_t_Flag_Name
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				currentKey = ffj_t_Flagno_such_key
				state = fflib.FFParse_want_colon
				goto mainparse
			}

		case fflib.FFParse_want_colon:
			if tok != fflib.FFTok_colon {
				wantedTok = fflib.FFTok_colon
				goto wrongtokenerror
			}
			state = fflib.FFParse_want_value
			continue
		case fflib.FFParse_want_value:

			if tok == fflib.FFTok_left_brace || tok == fflib.FFTok_left_bracket || tok == fflib.FFTok_integer || tok == fflib.FFTok_double || tok == fflib.FFTok_string || tok == fflib.FFTok_bool || tok == fflib.FFTok_null {
				switch currentKey {

				case ffj_t_Flag_Name:
					goto handle_Name

				case ffj_t_Flag_Value:
					goto handle_Value

				case ffj_t_Flagno_such_key:
					err = fs.SkipField(tok)
					if err != nil {
						return fs.WrapErr(err)
					}
					state = fflib.FFParse_after_value
					goto mainparse
				}
			} else {
				goto wantedvalue
			}
		}
	}

handle_Name:

	/* handler: uj.Name type=string kind=string quoted=false*/

	{

		{
			if tok != fflib.FFTok_string && tok != fflib.FFTok_null {
				return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for string", tok))
			}
		}

		if tok == fflib.FFTok_null {

		} else {

			outBuf := fs.Output.Bytes()

			uj.Name = string(string(outBuf))

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_Value:

	/* handler: uj.Value type=string kind=string quoted=false*/

	{

		{
			if tok != fflib.FFTok_string && tok != fflib.FFTok_null {
				return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for string", tok))
			}
		}

		if tok == fflib.FFTok_null {

			uj.Value = nil

		} else {

			var tval string
			outBuf := fs.Output.Bytes()

			tval = string(string(outBuf))
			uj.Value = &tval

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

wantedvalue:
	return fs.WrapErr(fmt.Errorf("wanted value token, but got token: %v", tok))
wrongtokenerror:
	return fs.WrapErr(fmt.Errorf("ffjson: wanted token: %v, but got token: %v output=%s", wantedTok, tok, fs.Output.String()))
tokerror:
	if fs.BigError != nil {
		return fs.WrapErr(fs.BigError)
	}
	err = fs.Error.ToError()
	if err != nil {
		return fs.WrapErr(err)
	}
	panic("ffjson-generated: unreachable, please report bug.")
done:

	return nil
}

func (mj *FrameworkID) MarshalJSON() ([]byte, error) {
	var buf fflib.Buffer
	if mj == nil {
		buf.WriteString("null")
		return buf.Bytes(), nil
	}
	err := mj.MarshalJSONBuf(&buf)
	if err != nil {
		return nil, err
	}
	return buf.Bytes(), nil
}
func (mj *FrameworkID) MarshalJSONBuf(buf fflib.EncodingBuffer) error {
	if mj == nil {
		buf.WriteString("null")
		return nil
	}
	var err error
	var obj []byte
	_ = obj
	_ = err
	buf.WriteString(`{"value":`)
	fflib.WriteJsonString(buf, string(mj.Value))
	buf.WriteByte('}')
	return nil
}

const (
	ffj_t_FrameworkIDbase = iota
	ffj_t_FrameworkIDno_such_key

	ffj_t_FrameworkID_Value
)

var ffj_key_FrameworkID_Value = []byte("value")

func (uj *FrameworkID) UnmarshalJSON(input []byte) error {
	fs := fflib.NewFFLexer(input)
	return uj.UnmarshalJSONFFLexer(fs, fflib.FFParse_map_start)
}

func (uj *FrameworkID) UnmarshalJSONFFLexer(fs *fflib.FFLexer, state fflib.FFParseState) error {
	var err error = nil
	currentKey := ffj_t_FrameworkIDbase
	_ = currentKey
	tok := fflib.FFTok_init
	wantedTok := fflib.FFTok_init

mainparse:
	for {
		tok = fs.Scan()
		//	println(fmt.Sprintf("debug: tok: %v  state: %v", tok, state))
		if tok == fflib.FFTok_error {
			goto tokerror
		}

		switch state {

		case fflib.FFParse_map_start:
			if tok != fflib.FFTok_left_bracket {
				wantedTok = fflib.FFTok_left_bracket
				goto wrongtokenerror
			}
			state = fflib.FFParse_want_key
			continue

		case fflib.FFParse_after_value:
			if tok == fflib.FFTok_comma {
				state = fflib.FFParse_want_key
			} else if tok == fflib.FFTok_right_bracket {
				goto done
			} else {
				wantedTok = fflib.FFTok_comma
				goto wrongtokenerror
			}

		case fflib.FFParse_want_key:
			// json {} ended. goto exit. woo.
			if tok == fflib.FFTok_right_bracket {
				goto done
			}
			if tok != fflib.FFTok_string {
				wantedTok = fflib.FFTok_string
				goto wrongtokenerror
			}

			kn := fs.Output.Bytes()
			if len(kn) <= 0 {
				// "" case. hrm.
				currentKey = ffj_t_FrameworkIDno_such_key
				state = fflib.FFParse_want_colon
				goto mainparse
			} else {
				switch kn[0] {

				case 'v':

					if bytes.Equal(ffj_key_FrameworkID_Value, kn) {
						currentKey = ffj_t_FrameworkID_Value
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				}

				if fflib.SimpleLetterEqualFold(ffj_key_FrameworkID_Value, kn) {
					currentKey = ffj_t_FrameworkID_Value
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				currentKey = ffj_t_FrameworkIDno_such_key
				state = fflib.FFParse_want_colon
				goto mainparse
			}

		case fflib.FFParse_want_colon:
			if tok != fflib.FFTok_colon {
				wantedTok = fflib.FFTok_colon
				goto wrongtokenerror
			}
			state = fflib.FFParse_want_value
			continue
		case fflib.FFParse_want_value:

			if tok == fflib.FFTok_left_brace || tok == fflib.FFTok_left_bracket || tok == fflib.FFTok_integer || tok == fflib.FFTok_double || tok == fflib.FFTok_string || tok == fflib.FFTok_bool || tok == fflib.FFTok_null {
				switch currentKey {

				case ffj_t_FrameworkID_Value:
					goto handle_Value

				case ffj_t_FrameworkIDno_such_key:
					err = fs.SkipField(tok)
					if err != nil {
						return fs.WrapErr(err)
					}
					state = fflib.FFParse_after_value
					goto mainparse
				}
			} else {
				goto wantedvalue
			}
		}
	}

handle_Value:

	/* handler: uj.Value type=string kind=string quoted=false*/

	{

		{
			if tok != fflib.FFTok_string && tok != fflib.FFTok_null {
				return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for string", tok))
			}
		}

		if tok == fflib.FFTok_null {

		} else {

			outBuf := fs.Output.Bytes()

			uj.Value = string(string(outBuf))

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

wantedvalue:
	return fs.WrapErr(fmt.Errorf("wanted value token, but got token: %v", tok))
wrongtokenerror:
	return fs.WrapErr(fmt.Errorf("ffjson: wanted token: %v, but got token: %v output=%s", wantedTok, tok, fs.Output.String()))
tokerror:
	if fs.BigError != nil {
		return fs.WrapErr(fs.BigError)
	}
	err = fs.Error.ToError()
	if err != nil {
		return fs.WrapErr(err)
	}
	panic("ffjson-generated: unreachable, please report bug.")
done:

	return nil
}

func (mj *FrameworkInfo) MarshalJSON() ([]byte, error) {
	var buf fflib.Buffer
	if mj == nil {
		buf.WriteString("null")
		return buf.Bytes(), nil
	}
	err := mj.MarshalJSONBuf(&buf)
	if err != nil {
		return nil, err
	}
	return buf.Bytes(), nil
}
func (mj *FrameworkInfo) MarshalJSONBuf(buf fflib.EncodingBuffer) error {
	if mj == nil {
		buf.WriteString("null")
		return nil
	}
	var err error
	var obj []byte
	_ = obj
	_ = err
	buf.WriteString(`{"user":`)
	fflib.WriteJsonString(buf, string(mj.User))
	buf.WriteString(`,"name":`)
	fflib.WriteJsonString(buf, string(mj.Name))
	buf.WriteByte(',')
	if mj.ID != nil {
		if true {
			buf.WriteString(`"id":`)

			{

				err = mj.ID.MarshalJSONBuf(buf)
				if err != nil {
					return err
				}

			}
			buf.WriteByte(',')
		}
	}
	if mj.FailoverTimeout != nil {
		if true {
			buf.WriteString(`"failover_timeout":`)
			fflib.AppendFloat(buf, float64(*mj.FailoverTimeout), 'g', -1, 64)
			buf.WriteByte(',')
		}
	}
	if mj.Checkpoint != nil {
		if true {
			if *mj.Checkpoint {
				buf.WriteString(`"checkpoint":true`)
			} else {
				buf.WriteString(`"checkpoint":false`)
			}
			buf.WriteByte(',')
		}
	}
	if mj.Role != nil {
		if true {
			buf.WriteString(`"role":`)
			fflib.WriteJsonString(buf, string(*mj.Role))
			buf.WriteByte(',')
		}
	}
	if len(mj.Roles) != 0 {
		buf.WriteString(`"roles":`)
		if mj.Roles != nil {
			buf.WriteString(`[`)
			for i, v := range mj.Roles {
				if i != 0 {
					buf.WriteString(`,`)
				}
				fflib.WriteJsonString(buf, string(v))
			}
			buf.WriteString(`]`)
		} else {
			buf.WriteString(`null`)
		}
		buf.WriteByte(',')
	}
	if mj.Hostname != nil {
		if true {
			buf.WriteString(`"hostname":`)
			fflib.WriteJsonString(buf, string(*mj.Hostname))
			buf.WriteByte(',')
		}
	}
	if mj.Principal != nil {
		if true {
			buf.WriteString(`"principal":`)
			fflib.WriteJsonString(buf, string(*mj.Principal))
			buf.WriteByte(',')
		}
	}
	if mj.WebUiURL != nil {
		if true {
			buf.WriteString(`"webui_url":`)
			fflib.WriteJsonString(buf, string(*mj.WebUiURL))
			buf.WriteByte(',')
		}
	}
	buf.WriteString(`"capabilities":`)
	if mj.Capabilities != nil {
		buf.WriteString(`[`)
		for i, v := range mj.Capabilities {
			if i != 0 {
				buf.WriteString(`,`)
			}

			{

				err = v.MarshalJSONBuf(buf)
				if err != nil {
					return err
				}

			}
		}
		buf.WriteString(`]`)
	} else {
		buf.WriteString(`null`)
	}
	buf.WriteByte(',')
	if mj.Labels != nil {
		if true {
			buf.WriteString(`"labels":`)

			{

				err = mj.Labels.MarshalJSONBuf(buf)
				if err != nil {
					return err
				}

			}
			buf.WriteByte(',')
		}
	}
	buf.WriteString(`"offer_filters":`)
	/* Falling back. type=map[string]mesos.OfferFilters kind=map */
	err = buf.Encode(mj.OfferFilters)
	if err != nil {
		return err
	}
	buf.WriteByte('}')
	return nil
}

const (
	ffj_t_FrameworkInfobase = iota
	ffj_t_FrameworkInfono_such_key

	ffj_t_FrameworkInfo_User

	ffj_t_FrameworkInfo_Name

	ffj_t_FrameworkInfo_ID

	ffj_t_FrameworkInfo_FailoverTimeout

	ffj_t_FrameworkInfo_Checkpoint

	ffj_t_FrameworkInfo_Role

	ffj_t_FrameworkInfo_Roles

	ffj_t_FrameworkInfo_Hostname

	ffj_t_FrameworkInfo_Principal

	ffj_t_FrameworkInfo_WebUiURL

	ffj_t_FrameworkInfo_Capabilities

	ffj_t_FrameworkInfo_Labels

	ffj_t_FrameworkInfo_OfferFilters
)

var ffj_key_FrameworkInfo_User = []byte("user")

var ffj_key_FrameworkInfo_Name = []byte("name")

var ffj_key_FrameworkInfo_ID = []byte("id")

var ffj_key_FrameworkInfo_FailoverTimeout = []byte("failover_timeout")

var ffj_key_FrameworkInfo_Checkpoint = []byte("checkpoint")

var ffj_key_FrameworkInfo_Role = []byte("role")

var ffj_key_FrameworkInfo_Roles = []byte("roles")

var ffj_key_FrameworkInfo_Hostname = []byte("hostname")

var ffj_key_FrameworkInfo_Principal = []byte("principal")

var ffj_key_FrameworkInfo_WebUiURL = []byte("webui_url")

var ffj_key_FrameworkInfo_Capabilities = []byte("capabilities")

var ffj_key_FrameworkInfo_Labels = []byte("labels")

var ffj_key_FrameworkInfo_OfferFilters = []byte("offer_filters")

func (uj *FrameworkInfo) UnmarshalJSON(input []byte) error {
	fs := fflib.NewFFLexer(input)
	return uj.UnmarshalJSONFFLexer(fs, fflib.FFParse_map_start)
}

func (uj *FrameworkInfo) UnmarshalJSONFFLexer(fs *fflib.FFLexer, state fflib.FFParseState) error {
	var err error = nil
	currentKey := ffj_t_FrameworkInfobase
	_ = currentKey
	tok := fflib.FFTok_init
	wantedTok := fflib.FFTok_init

mainparse:
	for {
		tok = fs.Scan()
		//	println(fmt.Sprintf("debug: tok: %v  state: %v", tok, state))
		if tok == fflib.FFTok_error {
			goto tokerror
		}

		switch state {

		case fflib.FFParse_map_start:
			if tok != fflib.FFTok_left_bracket {
				wantedTok = fflib.FFTok_left_bracket
				goto wrongtokenerror
			}
			state = fflib.FFParse_want_key
			continue

		case fflib.FFParse_after_value:
			if tok == fflib.FFTok_comma {
				state = fflib.FFParse_want_key
			} else if tok == fflib.FFTok_right_bracket {
				goto done
			} else {
				wantedTok = fflib.FFTok_comma
				goto wrongtokenerror
			}

		case fflib.FFParse_want_key:
			// json {} ended. goto exit. woo.
			if tok == fflib.FFTok_right_bracket {
				goto done
			}
			if tok != fflib.FFTok_string {
				wantedTok = fflib.FFTok_string
				goto wrongtokenerror
			}

			kn := fs.Output.Bytes()
			if len(kn) <= 0 {
				// "" case. hrm.
				currentKey = ffj_t_FrameworkInfono_such_key
				state = fflib.FFParse_want_colon
				goto mainparse
			} else {
				switch kn[0] {

				case 'c':

					if bytes.Equal(ffj_key_FrameworkInfo_Checkpoint, kn) {
						currentKey = ffj_t_FrameworkInfo_Checkpoint
						state = fflib.FFParse_want_colon
						goto mainparse

					} else if bytes.Equal(ffj_key_FrameworkInfo_Capabilities, kn) {
						currentKey = ffj_t_FrameworkInfo_Capabilities
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				case 'f':

					if bytes.Equal(ffj_key_FrameworkInfo_FailoverTimeout, kn) {
						currentKey = ffj_t_FrameworkInfo_FailoverTimeout
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				case 'h':

					if bytes.Equal(ffj_key_FrameworkInfo_Hostname, kn) {
						currentKey = ffj_t_FrameworkInfo_Hostname
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				case 'i':

					if bytes.Equal(ffj_key_FrameworkInfo_ID, kn) {
						currentKey = ffj_t_FrameworkInfo_ID
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				case 'l':

					if bytes.Equal(ffj_key_FrameworkInfo_Labels, kn) {
						currentKey = ffj_t_FrameworkInfo_Labels
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				case 'n':

					if bytes.Equal(ffj_key_FrameworkInfo_Name, kn) {
						currentKey = ffj_t_FrameworkInfo_Name
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				case 'o':

					if bytes.Equal(ffj_key_FrameworkInfo_OfferFilters, kn) {
						currentKey = ffj_t_FrameworkInfo_OfferFilters
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				case 'p':

					if bytes.Equal(ffj_key_FrameworkInfo_Principal, kn) {
						currentKey = ffj_t_FrameworkInfo_Principal
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				case 'r':

					if bytes.Equal(ffj_key_FrameworkInfo_Role, kn) {
						currentKey = ffj_t_FrameworkInfo_Role
						state = fflib.FFParse_want_colon
						goto mainparse

					} else if bytes.Equal(ffj_key_FrameworkInfo_Roles, kn) {
						currentKey = ffj_t_FrameworkInfo_Roles
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				case 'u':

					if bytes.Equal(ffj_key_FrameworkInfo_User, kn) {
						currentKey = ffj_t_FrameworkInfo_User
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				case 'w':

					if bytes.Equal(ffj_key_FrameworkInfo_WebUiURL, kn) {
						currentKey = ffj_t_FrameworkInfo_WebUiURL
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				}

				if fflib.EqualFoldRight(ffj_key_FrameworkInfo_OfferFilters, kn) {
					currentKey = ffj_t_FrameworkInfo_OfferFilters
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffj_key_FrameworkInfo_Labels, kn) {
					currentKey = ffj_t_FrameworkInfo_Labels
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffj_key_FrameworkInfo_Capabilities, kn) {
					currentKey = ffj_t_FrameworkInfo_Capabilities
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.AsciiEqualFold(ffj_key_FrameworkInfo_WebUiURL, kn) {
					currentKey = ffj_t_FrameworkInfo_WebUiURL
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.SimpleLetterEqualFold(ffj_key_FrameworkInfo_Principal, kn) {
					currentKey = ffj_t_FrameworkInfo_Principal
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffj_key_FrameworkInfo_Hostname, kn) {
					currentKey = ffj_t_FrameworkInfo_Hostname
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffj_key_FrameworkInfo_Roles, kn) {
					currentKey = ffj_t_FrameworkInfo_Roles
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.SimpleLetterEqualFold(ffj_key_FrameworkInfo_Role, kn) {
					currentKey = ffj_t_FrameworkInfo_Role
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffj_key_FrameworkInfo_Checkpoint, kn) {
					currentKey = ffj_t_FrameworkInfo_Checkpoint
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.AsciiEqualFold(ffj_key_FrameworkInfo_FailoverTimeout, kn) {
					currentKey = ffj_t_FrameworkInfo_FailoverTimeout
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.SimpleLetterEqualFold(ffj_key_FrameworkInfo_ID, kn) {
					currentKey = ffj_t_FrameworkInfo_ID
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.SimpleLetterEqualFold(ffj_key_FrameworkInfo_Name, kn) {
					currentKey = ffj_t_FrameworkInfo_Name
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffj_key_FrameworkInfo_User, kn) {
					currentKey = ffj_t_FrameworkInfo_User
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				currentKey = ffj_t_FrameworkInfono_such_key
				state = fflib.FFParse_want_colon
				goto mainparse
			}

		case fflib.FFParse_want_colon:
			if tok != fflib.FFTok_colon {
				wantedTok = fflib.FFTok_colon
				goto wrongtokenerror
			}
			state = fflib.FFParse_want_value
			continue
		case fflib.FFParse_want_value:

			if tok == fflib.FFTok_left_brace || tok == fflib.FFTok_left_bracket || tok == fflib.FFTok_integer || tok == fflib.FFTok_double || tok == fflib.FFTok_string || tok == fflib.FFTok_bool || tok == fflib.FFTok_null {
				switch currentKey {

				case ffj_t_FrameworkInfo_User:
					goto handle_User

				case ffj_t_FrameworkInfo_Name:
					goto handle_Name

				case ffj_t_FrameworkInfo_ID:
					goto handle_ID

				case ffj_t_FrameworkInfo_FailoverTimeout:
					goto handle_FailoverTimeout

				case ffj_t_FrameworkInfo_Checkpoint:
					goto handle_Checkpoint

				case ffj_t_FrameworkInfo_Role:
					goto handle_Role

				case ffj_t_FrameworkInfo_Roles:
					goto handle_Roles

				case ffj_t_FrameworkInfo_Hostname:
					goto handle_Hostname

				case ffj_t_FrameworkInfo_Principal:
					goto handle_Principal

				case ffj_t_FrameworkInfo_WebUiURL:
					goto handle_WebUiURL

				case ffj_t_FrameworkInfo_Capabilities:
					goto handle_Capabilities

				case ffj_t_FrameworkInfo_Labels:
					goto handle_Labels

				case ffj_t_FrameworkInfo_OfferFilters:
					goto handle_OfferFilters

				case ffj_t_FrameworkInfono_such_key:
					err = fs.SkipField(tok)
					if err != nil {
						return fs.WrapErr(err)
					}
					state = fflib.FFParse_after_value
					goto mainparse
				}
			} else {
				goto wantedvalue
			}
		}
	}

handle_User:

	/* handler: uj.User type=string kind=string quoted=false*/

	{

		{
			if tok != fflib.FFTok_string && tok != fflib.FFTok_null {
				return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for string", tok))
			}
		}

		if tok == fflib.FFTok_null {

		} else {

			outBuf := fs.Output.Bytes()

			uj.User = string(string(outBuf))

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_Name:

	/* handler: uj.Name type=string kind=string quoted=false*/

	{

		{
			if tok != fflib.FFTok_string && tok != fflib.FFTok_null {
				return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for string", tok))
			}
		}

		if tok == fflib.FFTok_null {

		} else {

			outBuf := fs.Output.Bytes()

			uj.Name = string(string(outBuf))

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_ID:

	/* handler: uj.ID type=mesos.FrameworkID kind=struct quoted=false*/

	{
		if tok == fflib.FFTok_null {

			uj.ID = nil

			state = fflib.FFParse_after_value
			goto mainparse
		}

		if uj.ID == nil {
			uj.ID = new(FrameworkID)
		}

		err = uj.ID.UnmarshalJSONFFLexer(fs, fflib.FFParse_want_key)
		if err != nil {
			return err
		}
		state = fflib.FFParse_after_value
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_FailoverTimeout:

	/* handler: uj.FailoverTimeout type=float64 kind=float64 quoted=false*/

	{
		if tok != fflib.FFTok_double && tok != fflib.FFTok_integer && tok != fflib.FFTok_null {
			return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for float64", tok))
		}
	}

	{

		if tok == fflib.FFTok_null {

			uj.FailoverTimeout = nil

		} else {

			tval, err := fflib.ParseFloat(fs.Output.Bytes(), 64)

			if err != nil {
				return fs.WrapErr(err)
			}

			ttypval := float64(tval)
			uj.FailoverTimeout = &ttypval

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_Checkpoint:

	/* handler: uj.Checkpoint type=bool kind=bool quoted=false*/

	{
		if tok != fflib.FFTok_bool && tok != fflib.FFTok_null {
			return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for bool", tok))
		}
	}

	{
		if tok == fflib.FFTok_null {

			uj.Checkpoint = nil

		} else {
			tmpb := fs.Output.Bytes()

			var tval bool

			if bytes.Compare([]byte{'t', 'r', 'u', 'e'}, tmpb) == 0 {

				tval = true

			} else if bytes.Compare([]byte{'f', 'a', 'l', 's', 'e'}, tmpb) == 0 {

				tval = false

			} else {
				err = errors.New("unexpected bytes for true/false value")
				return fs.WrapErr(err)
			}

			uj.Checkpoint = &tval

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_Role:

	/* handler: uj.Role type=string kind=string quoted=false*/

	{

		{
			if tok != fflib.FFTok_string && tok != fflib.FFTok_null {
				return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for string", tok))
			}
		}

		if tok == fflib.FFTok_null {

			uj.Role = nil

		} else {

			var tval string
			outBuf := fs.Output.Bytes()

			tval = string(string(outBuf))
			uj.Role = &tval

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_Roles:

	/* handler: uj.Roles type=[]string kind=slice quoted=false*/

	{

		{
			if tok != fflib.FFTok_left_brace && tok != fflib.FFTok_null {
				return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for ", tok))
			}
		}

		if tok == fflib.FFTok_null {
			uj.Roles = nil
		} else {

			uj.Roles = []string{}

			wantVal := true

			for {

				var tmp_uj__Roles string

				tok = fs.Scan()
				if tok == fflib.FFTok_error {
					goto tokerror
				}
				if tok == fflib.FFTok_right_brace {
					break
				}

				if tok == fflib.FFTok_comma {
					if wantVal == true {
						// TODO(pquerna): this isn't an ideal error message, this handles
						// things like [,,,] as an array value.
						return fs.WrapErr(fmt.Errorf("wanted value token, but got token: %v", tok))
					}
					continue
				} else {
					wantVal = true
				}

				/* handler: tmp_uj__Roles type=string kind=string quoted=false*/

				{

					{
						if tok != fflib.FFTok_string && tok != fflib.FFTok_null {
							return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for string", tok))
						}
					}

					if tok == fflib.FFTok_null {

					} else {

						outBuf := fs.Output.Bytes()

						tmp_uj__Roles = string(string(outBuf))

					}
				}

				uj.Roles = append(uj.Roles, tmp_uj__Roles)

				wantVal = false
			}
		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_Hostname:

	/* handler: uj.Hostname type=string kind=string quoted=false*/

	{

		{
			if tok != fflib.FFTok_string && tok != fflib.FFTok_null {
				return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for string", tok))
			}
		}

		if tok == fflib.FFTok_null {

			uj.Hostname = nil

		} else {

			var tval string
			outBuf := fs.Output.Bytes()

			tval = string(string(outBuf))
			uj.Hostname = &tval

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_Principal:

	/* handler: uj.Principal type=string kind=string quoted=false*/

	{

		{
			if tok != fflib.FFTok_string && tok != fflib.FFTok_null {
				return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for string", tok))
			}
		}

		if tok == fflib.FFTok_null {

			uj.Principal = nil

		} else {

			var tval string
			outBuf := fs.Output.Bytes()

			tval = string(string(outBuf))
			uj.Principal = &tval

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_WebUiURL:

	/* handler: uj.WebUiURL type=string kind=string quoted=false*/

	{

		{
			if tok != fflib.FFTok_string && tok != fflib.FFTok_null {
				return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for string", tok))
			}
		}

		if tok == fflib.FFTok_null {

			uj.WebUiURL = nil

		} else {

			var tval string
			outBuf := fs.Output.Bytes()

			tval = string(string(outBuf))
			uj.WebUiURL = &tval

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_Capabilities:

	/* handler: uj.Capabilities type=[]mesos.FrameworkInfo_Capability kind=slice quoted=false*/

	{

		{
			if tok != fflib.FFTok_left_brace && tok != fflib.FFTok_null {
				return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for ", tok))
			}
		}

		if tok == fflib.FFTok_null {
			uj.Capabilities = nil
		} else {

			uj.Capabilities = []FrameworkInfo_Capability{}

			wantVal := true

			for {

				var tmp_uj__Capabilities FrameworkInfo_Capability

				tok = fs.Scan()
				if tok == fflib.FFTok_error {
					goto tokerror
				}
				if tok == fflib.FFTok_right_brace {
					break
				}

				if tok == fflib.FFTok_comma {
					if wantVal == true {
						// TODO(pquerna): this isn't an ideal error message, this handles
						// things like [,,,] as an array value.
						return fs.WrapErr(fmt.Errorf("wanted value token, but got token: %v", tok))
					}
					continue
				} else {
					wantVal = true
				}

				/* handler: tmp_uj__Capabilities type=mesos.FrameworkInfo_Capability kind=struct quoted=false*/

				{
					if tok == fflib.FFTok_null {

						state = fflib.FFParse_after_value
						goto mainparse
					}

					err = tmp_uj__Capabilities.UnmarshalJSONFFLexer(fs, fflib.FFParse_want_key)
					if err != nil {
						return err
					}
					state = fflib.FFParse_after_value
				}

				uj.Capabilities = append(uj.Capabilities, tmp_uj__Capabilities)

				wantVal = false
			}
		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_Labels:

	/* handler: uj.Labels type=mesos.Labels kind=struct quoted=false*/

	{
		if tok == fflib.FFTok_null {

			uj.Labels = nil

			state = fflib.FFParse_after_value
			goto mainparse
		}

		if uj.Labels == nil {
			uj.Labels = new(Labels)
		}

		err = uj.Labels.UnmarshalJSONFFLexer(fs, fflib.FFParse_want_key)
		if err != nil {
			return err
		}
		state = fflib.FFParse_after_value
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_OfferFilters:

	/* handler: uj.OfferFilters type=map[string]mesos.OfferFilters kind=map quoted=false*/

	{

		{
			if tok != fflib.FFTok_left_bracket && tok != fflib.FFTok_null {
				return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for ", tok))
			}
		}

		if tok == fflib.FFTok_null {
			uj.OfferFilters = nil
		} else {

			uj.OfferFilters = make(map[string]OfferFilters, 0)

			wantVal := true

			for {

				var k string

				var tmp_uj__OfferFilters OfferFilters

				tok = fs.Scan()
				if tok == fflib.FFTok_error {
					goto tokerror
				}
				if tok == fflib.FFTok_right_bracket {
					break
				}

				if tok == fflib.FFTok_comma {
					if wantVal == true {
						// TODO(pquerna): this isn't an ideal error message, this handles
						// things like [,,,] as an array value.
						return fs.WrapErr(fmt.Errorf("wanted value token, but got token: %v", tok))
					}
					continue
				} else {
					wantVal = true
				}

				/* handler: k type=string kind=string quoted=false*/

				{

					{
						if tok != fflib.FFTok_string && tok != fflib.FFTok_null {
							return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for string", tok))
						}
					}

					if tok == fflib.FFTok_null {

					} else {

						outBuf := fs.Output.Bytes()

						k = string(string(outBuf))

					}
				}

				// Expect ':' after key
				tok = fs.Scan()
				if tok != fflib.FFTok_colon {
					return fs.WrapErr(fmt.Errorf("wanted colon token, but got token: %v", tok))
				}

				tok = fs.Scan()
				/* handler: tmp_uj__OfferFilters type=mesos.OfferFilters kind=struct quoted=false*/

				{
					if tok == fflib.FFTok_null {

						state = fflib.FFParse_after_value
						goto mainparse
					}

					err = tmp_uj__OfferFilters.UnmarshalJSONFFLexer(fs, fflib.FFParse_want_key)
					if err != nil {
						return err
					}
					state = fflib.FFParse_after_value
				}

				uj.OfferFilters[k] = tmp_uj__OfferFilters

				wantVal = false
			}

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

wantedvalue:
	return fs.WrapErr(fmt.Errorf("wanted value token, but got token: %v", tok))
wrongtokenerror:
	return fs.WrapErr(fmt.Errorf("ffjson: wanted token: %v, but got token: %v output=%s", wantedTok, tok, fs.Output.String()))
tokerror:
	if fs.BigError != nil {
		return fs.WrapErr(fs.BigError)
	}
	err = fs.Error.ToError()
	if err != nil {
		return fs.WrapErr(err)
	}
	panic("ffjson-generated: unreachable, please report bug.")
done:

	return nil
}

func (mj *FrameworkInfo_Capability) MarshalJSON() ([]byte, error) {
	var buf fflib.Buffer
	if mj == nil {
		buf.WriteString("null")
		return buf.Bytes(), nil
	}
	err := mj.MarshalJSONBuf(&buf)
	if err != nil {
		return nil, err
	}
	return buf.Bytes(), nil
}
func (mj *FrameworkInfo_Capability) MarshalJSONBuf(buf fflib.EncodingBuffer) error {
	if mj == nil {
		buf.WriteString("null")
		return nil
	}
	var err error
	var obj []byte
	_ = obj
	_ = err
	buf.WriteString(`{"type":`)

	{

		obj, err = mj.Type.MarshalJSON()
		if err != nil {
			return err
		}
		buf.Write(obj)

	}
	buf.WriteByte('}')
	return nil
}

const (
	ffj_t_FrameworkInfo_Capabilitybase = iota
	ffj_t_FrameworkInfo_Capabilityno_such_key

	ffj_t_FrameworkInfo_Capability_Type
)

var ffj_key_FrameworkInfo_Capability_Type = []byte("type")

func (uj *FrameworkInfo_Capability) UnmarshalJSON(input []byte) error {
	fs := fflib.NewFFLexer(input)
	return uj.UnmarshalJSONFFLexer(fs, fflib.FFParse_map_start)
}

func (uj *FrameworkInfo_Capability) UnmarshalJSONFFLexer(fs *fflib.FFLexer, state fflib.FFParseState) error {
	var err error = nil
	currentKey := ffj_t_FrameworkInfo_Capabilitybase
	_ = currentKey
	tok := fflib.FFTok_init
	wantedTok := fflib.FFTok_init

mainparse:
	for {
		tok = fs.Scan()
		//	println(fmt.Sprintf("debug: tok: %v  state: %v", tok, state))
		if tok == fflib.FFTok_error {
			goto tokerror
		}

		switch state {

		case fflib.FFParse_map_start:
			if tok != fflib.FFTok_left_bracket {
				wantedTok = fflib.FFTok_left_bracket
				goto wrongtokenerror
			}
			state = fflib.FFParse_want_key
			continue

		case fflib.FFParse_after_value:
			if tok == fflib.FFTok_comma {
				state = fflib.FFParse_want_key
			} else if tok == fflib.FFTok_right_bracket {
				goto done
			} else {
				wantedTok = fflib.FFTok_comma
				goto wrongtokenerror
			}

		case fflib.FFParse_want_key:
			// json {} ended. goto exit. woo.
			if tok == fflib.FFTok_right_bracket {
				goto done
			}
			if tok != fflib.FFTok_string {
				wantedTok = fflib.FFTok_string
				goto wrongtokenerror
			}

			kn := fs.Output.Bytes()
			if len(kn) <= 0 {
				// "" case. hrm.
				currentKey = ffj_t_FrameworkInfo_Capabilityno_such_key
				state = fflib.FFParse_want_colon
				goto mainparse
			} else {
				switch kn[0] {

				case 't':

					if bytes.Equal(ffj_key_FrameworkInfo_Capability_Type, kn) {
						currentKey = ffj_t_FrameworkInfo_Capability_Type
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				}

				if fflib.SimpleLetterEqualFold(ffj_key_FrameworkInfo_Capability_Type, kn) {
					currentKey = ffj_t_FrameworkInfo_Capability_Type
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				currentKey = ffj_t_FrameworkInfo_Capabilityno_such_key
				state = fflib.FFParse_want_colon
				goto mainparse
			}

		case fflib.FFParse_want_colon:
			if tok != fflib.FFTok_colon {
				wantedTok = fflib.FFTok_colon
				goto wrongtokenerror
			}
			state = fflib.FFParse_want_value
			continue
		case fflib.FFParse_want_value:

			if tok == fflib.FFTok_left_brace || tok == fflib.FFTok_left_bracket || tok == fflib.FFTok_integer || tok == fflib.FFTok_double || tok == fflib.FFTok_string || tok == fflib.FFTok_bool || tok == fflib.FFTok_null {
				switch currentKey {

				case ffj_t_FrameworkInfo_Capability_Type:
					goto handle_Type

				case ffj_t_FrameworkInfo_Capabilityno_such_key:
					err = fs.SkipField(tok)
					if err != nil {
						return fs.WrapErr(err)
					}
					state = fflib.FFParse_after_value
					goto mainparse
				}
			} else {
				goto wantedvalue
			}
		}
	}

handle_Type:

	/* handler: uj.Type type=mesos.FrameworkInfo_Capability_Type kind=int32 quoted=false*/

	{
		if tok == fflib.FFTok_null {

			state = fflib.FFParse_after_value
			goto mainparse
		}

		tbuf, err := fs.CaptureField(tok)
		if err != nil {
			return fs.WrapErr(err)
		}

		err = uj.Type.UnmarshalJSON(tbuf)
		if err != nil {
			return fs.WrapErr(err)
		}
		state = fflib.FFParse_after_value
	}

	state = fflib.FFParse_after_value
	goto mainparse

wantedvalue:
	return fs.WrapErr(fmt.Errorf("wanted value token, but got token: %v", tok))
wrongtokenerror:
	return fs.WrapErr(fmt.Errorf("ffjson: wanted token: %v, but got token: %v output=%s", wantedTok, tok, fs.Output.String()))
tokerror:
	if fs.BigError != nil {
		return fs.WrapErr(fs.BigError)
	}
	err = fs.Error.ToError()
	if err != nil {
		return fs.WrapErr(err)
	}
	panic("ffjson-generated: unreachable, please report bug.")
done:

	return nil
}

func (mj *HealthCheck) MarshalJSON() ([]byte, error) {
	var buf fflib.Buffer
	if mj == nil {
		buf.WriteString("null")
		return buf.Bytes(), nil
	}
	err := mj.MarshalJSONBuf(&buf)
	if err != nil {
		return nil, err
	}
	return buf.Bytes(), nil
}
func (mj *HealthCheck) MarshalJSONBuf(buf fflib.EncodingBuffer) error {
	if mj == nil {
		buf.WriteString("null")
		return nil
	}
	var err error
	var obj []byte
	_ = obj
	_ = err
	buf.WriteString(`{ `)
	if mj.DelaySeconds != nil {
		if true {
			buf.WriteString(`"delay_seconds":`)
			fflib.AppendFloat(buf, float64(*mj.DelaySeconds), 'g', -1, 64)
			buf.WriteByte(',')
		}
	}
	if mj.IntervalSeconds != nil {
		if true {
			buf.WriteString(`"interval_seconds":`)
			fflib.AppendFloat(buf, float64(*mj.IntervalSeconds), 'g', -1, 64)
			buf.WriteByte(',')
		}
	}
	if mj.TimeoutSeconds != nil {
		if true {
			buf.WriteString(`"timeout_seconds":`)
			fflib.AppendFloat(buf, float64(*mj.TimeoutSeconds), 'g', -1, 64)
			buf.WriteByte(',')
		}
	}
	if mj.ConsecutiveFailures != nil {
		if true {
			buf.WriteString(`"consecutive_failures":`)
			fflib.FormatBits2(buf, uint64(*mj.ConsecutiveFailures), 10, false)
			buf.WriteByte(',')
		}
	}
	if mj.GracePeriodSeconds != nil {
		if true {
			buf.WriteString(`"grace_period_seconds":`)
			fflib.AppendFloat(buf, float64(*mj.GracePeriodSeconds), 'g', -1, 64)
			buf.WriteByte(',')
		}
	}
	buf.WriteString(`"type":`)

	{

		obj, err = mj.Type.MarshalJSON()
		if err != nil {
			return err
		}
		buf.Write(obj)

	}
	buf.WriteByte(',')
	if mj.Command != nil {
		if true {
			buf.WriteString(`"command":`)

			{

				err = mj.Command.MarshalJSONBuf(buf)
				if err != nil {
					return err
				}

			}
			buf.WriteByte(',')
		}
	}
	if mj.HTTP != nil {
		if true {
			buf.WriteString(`"http":`)

			{

				err = mj.HTTP.MarshalJSONBuf(buf)
				if err != nil {
					return err
				}

			}
			buf.WriteByte(',')
		}
	}
	if mj.TCP != nil {
		if true {
			buf.WriteString(`"tcp":`)

			{

				err = mj.TCP.MarshalJSONBuf(buf)
				if err != nil {
					return err
				}

			}
			buf.WriteByte(',')
		}
	}
	buf.Rewind(1)
	buf.WriteByte('}')
	return nil
}

const (
	ffj_t_HealthCheckbase = iota
	ffj_t_HealthCheckno_such_key

	ffj_t_HealthCheck_DelaySeconds

	ffj_t_HealthCheck_IntervalSeconds

	ffj_t_HealthCheck_TimeoutSeconds

	ffj_t_HealthCheck_ConsecutiveFailures

	ffj_t_HealthCheck_GracePeriodSeconds

	ffj_t_HealthCheck_Type

	ffj_t_HealthCheck_Command

	ffj_t_HealthCheck_HTTP

	ffj_t_HealthCheck_TCP
)

var ffj_key_HealthCheck_DelaySeconds = []byte("delay_seconds")

var ffj_key_HealthCheck_IntervalSeconds = []byte("interval_seconds")

var ffj_key_HealthCheck_TimeoutSeconds = []byte("timeout_seconds")

var ffj_key_HealthCheck_ConsecutiveFailures = []byte("consecutive_failures")

var ffj_key_HealthCheck_GracePeriodSeconds = []byte("grace_period_seconds")

var ffj_key_HealthCheck_Type = []byte("type")

var ffj_key_HealthCheck_Command = []byte("command")

var ffj_key_HealthCheck_HTTP = []byte("http")

var ffj_key_HealthCheck_TCP = []byte("tcp")

func (uj *HealthCheck) UnmarshalJSON(input []byte) error {
	fs := fflib.NewFFLexer(input)
	return uj.UnmarshalJSONFFLexer(fs, fflib.FFParse_map_start)
}

func (uj *HealthCheck) UnmarshalJSONFFLexer(fs *fflib.FFLexer, state fflib.FFParseState) error {
	var err error = nil
	currentKey := ffj_t_HealthCheckbase
	_ = currentKey
	tok := fflib.FFTok_init
	wantedTok := fflib.FFTok_init

mainparse:
	for {
		tok = fs.Scan()
		//	println(fmt.Sprintf("debug: tok: %v  state: %v", tok, state))
		if tok == fflib.FFTok_error {
			goto tokerror
		}

		switch state {

		case fflib.FFParse_map_start:
			if tok != fflib.FFTok_left_bracket {
				wantedTok = fflib.FFTok_left_bracket
				goto wrongtokenerror
			}
			state = fflib.FFParse_want_key
			continue

		case fflib.FFParse_after_value:
			if tok == fflib.FFTok_comma {
				state = fflib.FFParse_want_key
			} else if tok == fflib.FFTok_right_bracket {
				goto done
			} else {
				wantedTok = fflib.FFTok_comma
				goto wrongtokenerror
			}

		case fflib.FFParse_want_key:
			// json {} ended. goto exit. woo.
			if tok == fflib.FFTok_right_bracket {
				goto done
			}
			if tok != fflib.FFTok_string {
				wantedTok = fflib.FFTok_string
				goto wrongtokenerror
			}

			kn := fs.Output.Bytes()
			if len(kn) <= 0 {
				// "" case. hrm.
				currentKey = ffj_t_HealthCheckno_such_key
				state = fflib.FFParse_want_colon
				goto mainparse
			} else {
				switch kn[0] {

				case 'c':

					if bytes.Equal(ffj_key_HealthCheck_ConsecutiveFailures, kn) {
						currentKey = ffj_t_HealthCheck_ConsecutiveFailures
						state = fflib.FFParse_want_colon
						goto mainparse

					} else if bytes.Equal(ffj_key_HealthCheck_Command, kn) {
						currentKey = ffj_t_HealthCheck_Command
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				case 'd':

					if bytes.Equal(ffj_key_HealthCheck_DelaySeconds, kn) {
						currentKey = ffj_t_HealthCheck_DelaySeconds
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				case 'g':

					if bytes.Equal(ffj_key_HealthCheck_GracePeriodSeconds, kn) {
						currentKey = ffj_t_HealthCheck_GracePeriodSeconds
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				case 'h':

					if bytes.Equal(ffj_key_HealthCheck_HTTP, kn) {
						currentKey = ffj_t_HealthCheck_HTTP
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				case 'i':

					if bytes.Equal(ffj_key_HealthCheck_IntervalSeconds, kn) {
						currentKey = ffj_t_HealthCheck_IntervalSeconds
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				case 't':

					if bytes.Equal(ffj_key_HealthCheck_TimeoutSeconds, kn) {
						currentKey = ffj_t_HealthCheck_TimeoutSeconds
						state = fflib.FFParse_want_colon
						goto mainparse

					} else if bytes.Equal(ffj_key_HealthCheck_Type, kn) {
						currentKey = ffj_t_HealthCheck_Type
						state = fflib.FFParse_want_colon
						goto mainparse

					} else if bytes.Equal(ffj_key_HealthCheck_TCP, kn) {
						currentKey = ffj_t_HealthCheck_TCP
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				}

				if fflib.SimpleLetterEqualFold(ffj_key_HealthCheck_TCP, kn) {
					currentKey = ffj_t_HealthCheck_TCP
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.SimpleLetterEqualFold(ffj_key_HealthCheck_HTTP, kn) {
					currentKey = ffj_t_HealthCheck_HTTP
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.SimpleLetterEqualFold(ffj_key_HealthCheck_Command, kn) {
					currentKey = ffj_t_HealthCheck_Command
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.SimpleLetterEqualFold(ffj_key_HealthCheck_Type, kn) {
					currentKey = ffj_t_HealthCheck_Type
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffj_key_HealthCheck_GracePeriodSeconds, kn) {
					currentKey = ffj_t_HealthCheck_GracePeriodSeconds
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffj_key_HealthCheck_ConsecutiveFailures, kn) {
					currentKey = ffj_t_HealthCheck_ConsecutiveFailures
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffj_key_HealthCheck_TimeoutSeconds, kn) {
					currentKey = ffj_t_HealthCheck_TimeoutSeconds
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffj_key_HealthCheck_IntervalSeconds, kn) {
					currentKey = ffj_t_HealthCheck_IntervalSeconds
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffj_key_HealthCheck_DelaySeconds, kn) {
					currentKey = ffj_t_HealthCheck_DelaySeconds
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				currentKey = ffj_t_HealthCheckno_such_key
				state = fflib.FFParse_want_colon
				goto mainparse
			}

		case fflib.FFParse_want_colon:
			if tok != fflib.FFTok_colon {
				wantedTok = fflib.FFTok_colon
				goto wrongtokenerror
			}
			state = fflib.FFParse_want_value
			continue
		case fflib.FFParse_want_value:

			if tok == fflib.FFTok_left_brace || tok == fflib.FFTok_left_bracket || tok == fflib.FFTok_integer || tok == fflib.FFTok_double || tok == fflib.FFTok_string || tok == fflib.FFTok_bool || tok == fflib.FFTok_null {
				switch currentKey {

				case ffj_t_HealthCheck_DelaySeconds:
					goto handle_DelaySeconds

				case ffj_t_HealthCheck_IntervalSeconds:
					goto handle_IntervalSeconds

				case ffj_t_HealthCheck_TimeoutSeconds:
					goto handle_TimeoutSeconds

				case ffj_t_HealthCheck_ConsecutiveFailures:
					goto handle_ConsecutiveFailures

				case ffj_t_HealthCheck_GracePeriodSeconds:
					goto handle_GracePeriodSeconds

				case ffj_t_HealthCheck_Type:
					goto handle_Type

				case ffj_t_HealthCheck_Command:
					goto handle_Command

				case ffj_t_HealthCheck_HTTP:
					goto handle_HTTP

				case ffj_t_HealthCheck_TCP:
					goto handle_TCP

				case ffj_t_HealthCheckno_such_key:
					err = fs.SkipField(tok)
					if err != nil {
						return fs.WrapErr(err)
					}
					state = fflib.FFParse_after_value
					goto mainparse
				}
			} else {
				goto wantedvalue
			}
		}
	}

handle_DelaySeconds:

	/* handler: uj.DelaySeconds type=float64 kind=float64 quoted=false*/

	{
		if tok != fflib.FFTok_double && tok != fflib.FFTok_integer && tok != fflib.FFTok_null {
			return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for float64", tok))
		}
	}

	{

		if tok == fflib.FFTok_null {

			uj.DelaySeconds = nil

		} else {

			tval, err := fflib.ParseFloat(fs.Output.Bytes(), 64)

			if err != nil {
				return fs.WrapErr(err)
			}

			ttypval := float64(tval)
			uj.DelaySeconds = &ttypval

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_IntervalSeconds:

	/* handler: uj.IntervalSeconds type=float64 kind=float64 quoted=false*/

	{
		if tok != fflib.FFTok_double && tok != fflib.FFTok_integer && tok != fflib.FFTok_null {
			return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for float64", tok))
		}
	}

	{

		if tok == fflib.FFTok_null {

			uj.IntervalSeconds = nil

		} else {

			tval, err := fflib.ParseFloat(fs.Output.Bytes(), 64)

			if err != nil {
				return fs.WrapErr(err)
			}

			ttypval := float64(tval)
			uj.IntervalSeconds = &ttypval

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_TimeoutSeconds:

	/* handler: uj.TimeoutSeconds type=float64 kind=float64 quoted=false*/

	{
		if tok != fflib.FFTok_double && tok != fflib.FFTok_integer && tok != fflib.FFTok_null {
			return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for float64", tok))
		}
	}

	{

		if tok == fflib.FFTok_null {

			uj.TimeoutSeconds = nil

		} else {

			tval, err := fflib.ParseFloat(fs.Output.Bytes(), 64)

			if err != nil {
				return fs.WrapErr(err)
			}

			ttypval := float64(tval)
			uj.TimeoutSeconds = &ttypval

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_ConsecutiveFailures:

	/* handler: uj.ConsecutiveFailures type=uint32 kind=uint32 quoted=false*/

	{
		if tok != fflib.FFTok_integer && tok != fflib.FFTok_null {
			return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for uint32", tok))
		}
	}

	{

		if tok == fflib.FFTok_null {

			uj.ConsecutiveFailures = nil

		} else {

			tval, err := fflib.ParseUint(fs.Output.Bytes(), 10, 32)

			if err != nil {
				return fs.WrapErr(err)
			}

			ttypval := uint32(tval)
			uj.ConsecutiveFailures = &ttypval

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_GracePeriodSeconds:

	/* handler: uj.GracePeriodSeconds type=float64 kind=float64 quoted=false*/

	{
		if tok != fflib.FFTok_double && tok != fflib.FFTok_integer && tok != fflib.FFTok_null {
			return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for float64", tok))
		}
	}

	{

		if tok == fflib.FFTok_null {

			uj.GracePeriodSeconds = nil

		} else {

			tval, err := fflib.ParseFloat(fs.Output.Bytes(), 64)

			if err != nil {
				return fs.WrapErr(err)
			}

			ttypval := float64(tval)
			uj.GracePeriodSeconds = &ttypval

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_Type:

	/* handler: uj.Type type=mesos.HealthCheck_Type kind=int32 quoted=false*/

	{
		if tok == fflib.FFTok_null {

			state = fflib.FFParse_after_value
			goto mainparse
		}

		tbuf, err := fs.CaptureField(tok)
		if err != nil {
			return fs.WrapErr(err)
		}

		err = uj.Type.UnmarshalJSON(tbuf)
		if err != nil {
			return fs.WrapErr(err)
		}
		state = fflib.FFParse_after_value
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_Command:

	/* handler: uj.Command type=mesos.CommandInfo kind=struct quoted=false*/

	{
		if tok == fflib.FFTok_null {

			uj.Command = nil

			state = fflib.FFParse_after_value
			goto mainparse
		}

		if uj.Command == nil {
			uj.Command = new(CommandInfo)
		}

		err = uj.Command.UnmarshalJSONFFLexer(fs, fflib.FFParse_want_key)
		if err != nil {
			return err
		}
		state = fflib.FFParse_after_value
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_HTTP:

	/* handler: uj.HTTP type=mesos.HealthCheck_HTTPCheckInfo kind=struct quoted=false*/

	{
		if tok == fflib.FFTok_null {

			uj.HTTP = nil

			state = fflib.FFParse_after_value
			goto mainparse
		}

		if uj.HTTP == nil {
			uj.HTTP = new(HealthCheck_HTTPCheckInfo)
		}

		err = uj.HTTP.UnmarshalJSONFFLexer(fs, fflib.FFParse_want_key)
		if err != nil {
			return err
		}
		state = fflib.FFParse_after_value
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_TCP:

	/* handler: uj.TCP type=mesos.HealthCheck_TCPCheckInfo kind=struct quoted=false*/

	{
		if tok == fflib.FFTok_null {

			uj.TCP = nil

			state = fflib.FFParse_after_value
			goto mainparse
		}

		if uj.TCP == nil {
			uj.TCP = new(HealthCheck_TCPCheckInfo)
		}

		err = uj.TCP.UnmarshalJSONFFLexer(fs, fflib.FFParse_want_key)
		if err != nil {
			return err
		}
		state = fflib.FFParse_after_value
	}

	state = fflib.FFParse_after_value
	goto mainparse

wantedvalue:
	return fs.WrapErr(fmt.Errorf("wanted value token, but got token: %v", tok))
wrongtokenerror:
	return fs.WrapErr(fmt.Errorf("ffjson: wanted token: %v, but got token: %v output=%s", wantedTok, tok, fs.Output.String()))
tokerror:
	if fs.BigError != nil {
		return fs.WrapErr(fs.BigError)
	}
	err = fs.Error.ToError()
	if err != nil {
		return fs.WrapErr(err)
	}
	panic("ffjson-generated: unreachable, please report bug.")
done:

	return nil
}

func (mj *HealthCheck_HTTPCheckInfo) MarshalJSON() ([]byte, error) {
	var buf fflib.Buffer
	if mj == nil {
		buf.WriteString("null")
		return buf.Bytes(), nil
	}
	err := mj.MarshalJSONBuf(&buf)
	if err != nil {
		return nil, err
	}
	return buf.Bytes(), nil
}
func (mj *HealthCheck_HTTPCheckInfo) MarshalJSONBuf(buf fflib.EncodingBuffer) error {
	if mj == nil {
		buf.WriteString("null")
		return nil
	}
	var err error
	var obj []byte
	_ = obj
	_ = err
	buf.WriteString(`{ `)
	if mj.Protocol != nil {
		if true {
			buf.WriteString(`"protocol":`)

			{

				obj, err = mj.Protocol.MarshalJSON()
				if err != nil {
					return err
				}
				buf.Write(obj)

			}
			buf.WriteByte(',')
		}
	}
	if mj.Scheme != nil {
		if true {
			buf.WriteString(`"scheme":`)
			fflib.WriteJsonString(buf, string(*mj.Scheme))
			buf.WriteByte(',')
		}
	}
	buf.WriteString(`"port":`)
	fflib.FormatBits2(buf, uint64(mj.Port), 10, false)
	buf.WriteByte(',')
	if mj.Path != nil {
		if true {
			buf.WriteString(`"path":`)
			fflib.WriteJsonString(buf, string(*mj.Path))
			buf.WriteByte(',')
		}
	}
	if len(mj.Statuses) != 0 {
		buf.WriteString(`"statuses":`)
		if mj.Statuses != nil {
			buf.WriteString(`[`)
			for i, v := range mj.Statuses {
				if i != 0 {
					buf.WriteString(`,`)
				}
				fflib.FormatBits2(buf, uint64(v), 10, false)
			}
			buf.WriteString(`]`)
		} else {
			buf.WriteString(`null`)
		}
		buf.WriteByte(',')
	}
	buf.Rewind(1)
	buf.WriteByte('}')
	return nil
}

const (
	ffj_t_HealthCheck_HTTPCheckInfobase = iota
	ffj_t_HealthCheck_HTTPCheckInfono_such_key

	ffj_t_HealthCheck_HTTPCheckInfo_Protocol

	ffj_t_HealthCheck_HTTPCheckInfo_Scheme

	ffj_t_HealthCheck_HTTPCheckInfo_Port

	ffj_t_HealthCheck_HTTPCheckInfo_Path

	ffj_t_HealthCheck_HTTPCheckInfo_Statuses
)

var ffj_key_HealthCheck_HTTPCheckInfo_Protocol = []byte("protocol")

var ffj_key_HealthCheck_HTTPCheckInfo_Scheme = []byte("scheme")

var ffj_key_HealthCheck_HTTPCheckInfo_Port = []byte("port")

var ffj_key_HealthCheck_HTTPCheckInfo_Path = []byte("path")

var ffj_key_HealthCheck_HTTPCheckInfo_Statuses = []byte("statuses")

func (uj *HealthCheck_HTTPCheckInfo) UnmarshalJSON(input []byte) error {
	fs := fflib.NewFFLexer(input)
	return uj.UnmarshalJSONFFLexer(fs, fflib.FFParse_map_start)
}

func (uj *HealthCheck_HTTPCheckInfo) UnmarshalJSONFFLexer(fs *fflib.FFLexer, state fflib.FFParseState) error {
	var err error = nil
	currentKey := ffj_t_HealthCheck_HTTPCheckInfobase
	_ = currentKey
	tok := fflib.FFTok_init
	wantedTok := fflib.FFTok_init

mainparse:
	for {
		tok = fs.Scan()
		//	println(fmt.Sprintf("debug: tok: %v  state: %v", tok, state))
		if tok == fflib.FFTok_error {
			goto tokerror
		}

		switch state {

		case fflib.FFParse_map_start:
			if tok != fflib.FFTok_left_bracket {
				wantedTok = fflib.FFTok_left_bracket
				goto wrongtokenerror
			}
			state = fflib.FFParse_want_key
			continue

		case fflib.FFParse_after_value:
			if tok == fflib.FFTok_comma {
				state = fflib.FFParse_want_key
			} else if tok == fflib.FFTok_right_bracket {
				goto done
			} else {
				wantedTok = fflib.FFTok_comma
				goto wrongtokenerror
			}

		case fflib.FFParse_want_key:
			// json {} ended. goto exit. woo.
			if tok == fflib.FFTok_right_bracket {
				goto done
			}
			if tok != fflib.FFTok_string {
				wantedTok = fflib.FFTok_string
				goto wrongtokenerror
			}

			kn := fs.Output.Bytes()
			if len(kn) <= 0 {
				// "" case. hrm.
				currentKey = ffj_t_HealthCheck_HTTPCheckInfono_such_key
				state = fflib.FFParse_want_colon
				goto mainparse
			} else {
				switch kn[0] {

				case 'p':

					if bytes.Equal(ffj_key_HealthCheck_HTTPCheckInfo_Protocol, kn) {
						currentKey = ffj_t_HealthCheck_HTTPCheckInfo_Protocol
						state = fflib.FFParse_want_colon
						goto mainparse

					} else if bytes.Equal(ffj_key_HealthCheck_HTTPCheckInfo_Port, kn) {
						currentKey = ffj_t_HealthCheck_HTTPCheckInfo_Port
						state = fflib.FFParse_want_colon
						goto mainparse

					} else if bytes.Equal(ffj_key_HealthCheck_HTTPCheckInfo_Path, kn) {
						currentKey = ffj_t_HealthCheck_HTTPCheckInfo_Path
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				case 's':

					if bytes.Equal(ffj_key_HealthCheck_HTTPCheckInfo_Scheme, kn) {
						currentKey = ffj_t_HealthCheck_HTTPCheckInfo_Scheme
						state = fflib.FFParse_want_colon
						goto mainparse

					} else if bytes.Equal(ffj_key_HealthCheck_HTTPCheckInfo_Statuses, kn) {
						currentKey = ffj_t_HealthCheck_HTTPCheckInfo_Statuses
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				}

				if fflib.EqualFoldRight(ffj_key_HealthCheck_HTTPCheckInfo_Statuses, kn) {
					currentKey = ffj_t_HealthCheck_HTTPCheckInfo_Statuses
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.SimpleLetterEqualFold(ffj_key_HealthCheck_HTTPCheckInfo_Path, kn) {
					currentKey = ffj_t_HealthCheck_HTTPCheckInfo_Path
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.SimpleLetterEqualFold(ffj_key_HealthCheck_HTTPCheckInfo_Port, kn) {
					currentKey = ffj_t_HealthCheck_HTTPCheckInfo_Port
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffj_key_HealthCheck_HTTPCheckInfo_Scheme, kn) {
					currentKey = ffj_t_HealthCheck_HTTPCheckInfo_Scheme
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.SimpleLetterEqualFold(ffj_key_HealthCheck_HTTPCheckInfo_Protocol, kn) {
					currentKey = ffj_t_HealthCheck_HTTPCheckInfo_Protocol
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				currentKey = ffj_t_HealthCheck_HTTPCheckInfono_such_key
				state = fflib.FFParse_want_colon
				goto mainparse
			}

		case fflib.FFParse_want_colon:
			if tok != fflib.FFTok_colon {
				wantedTok = fflib.FFTok_colon
				goto wrongtokenerror
			}
			state = fflib.FFParse_want_value
			continue
		case fflib.FFParse_want_value:

			if tok == fflib.FFTok_left_brace || tok == fflib.FFTok_left_bracket || tok == fflib.FFTok_integer || tok == fflib.FFTok_double || tok == fflib.FFTok_string || tok == fflib.FFTok_bool || tok == fflib.FFTok_null {
				switch currentKey {

				case ffj_t_HealthCheck_HTTPCheckInfo_Protocol:
					goto handle_Protocol

				case ffj_t_HealthCheck_HTTPCheckInfo_Scheme:
					goto handle_Scheme

				case ffj_t_HealthCheck_HTTPCheckInfo_Port:
					goto handle_Port

				case ffj_t_HealthCheck_HTTPCheckInfo_Path:
					goto handle_Path

				case ffj_t_HealthCheck_HTTPCheckInfo_Statuses:
					goto handle_Statuses

				case ffj_t_HealthCheck_HTTPCheckInfono_such_key:
					err = fs.SkipField(tok)
					if err != nil {
						return fs.WrapErr(err)
					}
					state = fflib.FFParse_after_value
					goto mainparse
				}
			} else {
				goto wantedvalue
			}
		}
	}

handle_Protocol:

	/* handler: uj.Protocol type=mesos.NetworkInfo_Protocol kind=int32 quoted=false*/

	{
		if tok == fflib.FFTok_null {

			uj.Protocol = nil

			state = fflib.FFParse_after_value
			goto mainparse
		}

		tbuf, err := fs.CaptureField(tok)
		if err != nil {
			return fs.WrapErr(err)
		}

		if uj.Protocol == nil {
			uj.Protocol = new(NetworkInfo_Protocol)
		}

		err = uj.Protocol.UnmarshalJSON(tbuf)
		if err != nil {
			return fs.WrapErr(err)
		}
		state = fflib.FFParse_after_value
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_Scheme:

	/* handler: uj.Scheme type=string kind=string quoted=false*/

	{

		{
			if tok != fflib.FFTok_string && tok != fflib.FFTok_null {
				return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for string", tok))
			}
		}

		if tok == fflib.FFTok_null {

			uj.Scheme = nil

		} else {

			var tval string
			outBuf := fs.Output.Bytes()

			tval = string(string(outBuf))
			uj.Scheme = &tval

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_Port:

	/* handler: uj.Port type=uint32 kind=uint32 quoted=false*/

	{
		if tok != fflib.FFTok_integer && tok != fflib.FFTok_null {
			return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for uint32", tok))
		}
	}

	{

		if tok == fflib.FFTok_null {

		} else {

			tval, err := fflib.ParseUint(fs.Output.Bytes(), 10, 32)

			if err != nil {
				return fs.WrapErr(err)
			}

			uj.Port = uint32(tval)

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_Path:

	/* handler: uj.Path type=string kind=string quoted=false*/

	{

		{
			if tok != fflib.FFTok_string && tok != fflib.FFTok_null {
				return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for string", tok))
			}
		}

		if tok == fflib.FFTok_null {

			uj.Path = nil

		} else {

			var tval string
			outBuf := fs.Output.Bytes()

			tval = string(string(outBuf))
			uj.Path = &tval

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_Statuses:

	/* handler: uj.Statuses type=[]uint32 kind=slice quoted=false*/

	{

		{
			if tok != fflib.FFTok_left_brace && tok != fflib.FFTok_null {
				return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for ", tok))
			}
		}

		if tok == fflib.FFTok_null {
			uj.Statuses = nil
		} else {

			uj.Statuses = []uint32{}

			wantVal := true

			for {

				var tmp_uj__Statuses uint32

				tok = fs.Scan()
				if tok == fflib.FFTok_error {
					goto tokerror
				}
				if tok == fflib.FFTok_right_brace {
					break
				}

				if tok == fflib.FFTok_comma {
					if wantVal == true {
						// TODO(pquerna): this isn't an ideal error message, this handles
						// things like [,,,] as an array value.
						return fs.WrapErr(fmt.Errorf("wanted value token, but got token: %v", tok))
					}
					continue
				} else {
					wantVal = true
				}

				/* handler: tmp_uj__Statuses type=uint32 kind=uint32 quoted=false*/

				{
					if tok != fflib.FFTok_integer && tok != fflib.FFTok_null {
						return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for uint32", tok))
					}
				}

				{

					if tok == fflib.FFTok_null {

					} else {

						tval, err := fflib.ParseUint(fs.Output.Bytes(), 10, 32)

						if err != nil {
							return fs.WrapErr(err)
						}

						tmp_uj__Statuses = uint32(tval)

					}
				}

				uj.Statuses = append(uj.Statuses, tmp_uj__Statuses)

				wantVal = false
			}
		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

wantedvalue:
	return fs.WrapErr(fmt.Errorf("wanted value token, but got token: %v", tok))
wrongtokenerror:
	return fs.WrapErr(fmt.Errorf("ffjson: wanted token: %v, but got token: %v output=%s", wantedTok, tok, fs.Output.String()))
tokerror:
	if fs.BigError != nil {
		return fs.WrapErr(fs.BigError)
	}
	err = fs.Error.ToError()
	if err != nil {
		return fs.WrapErr(err)
	}
	panic("ffjson-generated: unreachable, please report bug.")
done:

	return nil
}

func (mj *HealthCheck_TCPCheckInfo) MarshalJSON() ([]byte, error) {
	var buf fflib.Buffer
	if mj == nil {
		buf.WriteString("null")
		return buf.Bytes(), nil
	}
	err := mj.MarshalJSONBuf(&buf)
	if err != nil {
		return nil, err
	}
	return buf.Bytes(), nil
}
func (mj *HealthCheck_TCPCheckInfo) MarshalJSONBuf(buf fflib.EncodingBuffer) error {
	if mj == nil {
		buf.WriteString("null")
		return nil
	}
	var err error
	var obj []byte
	_ = obj
	_ = err
	buf.WriteByte('{')
	if mj.Protocol != nil {
		if true {
			buf.WriteString(`"protocol":`)

			{

				obj, err = mj.Protocol.MarshalJSON()
				if err != nil {
					return err
				}
				buf.Write(obj)

			}
			buf.WriteByte(',')
		}
	}
	buf.WriteString(`"port":`)
	fflib.FormatBits2(buf, uint64(mj.Port), 10, false)
	buf.WriteByte('}')
	return nil
}

const (
	ffj_t_HealthCheck_TCPCheckInfobase = iota
	ffj_t_HealthCheck_TCPCheckInfono_such_key

	ffj_t_HealthCheck_TCPCheckInfo_Protocol

	ffj_t_HealthCheck_TCPCheckInfo_Port
)

var ffj_key_HealthCheck_TCPCheckInfo_Protocol = []byte("protocol")

var ffj_key_HealthCheck_TCPCheckInfo_Port = []byte("port")

func (uj *HealthCheck_TCPCheckInfo) UnmarshalJSON(input []byte) error {
	fs := fflib.NewFFLexer(input)
	return uj.UnmarshalJSONFFLexer(fs, fflib.FFParse_map_start)
}

func (uj *HealthCheck_TCPCheckInfo) UnmarshalJSONFFLexer(fs *fflib.FFLexer, state fflib.FFParseState) error {
	var err error = nil
	currentKey := ffj_t_HealthCheck_TCPCheckInfobase
	_ = currentKey
	tok := fflib.FFTok_init
	wantedTok := fflib.FFTok_init

mainparse:
	for {
		tok = fs.Scan()
		//	println(fmt.Sprintf("debug: tok: %v  state: %v", tok, state))
		if tok == fflib.FFTok_error {
			goto tokerror
		}

		switch state {

		case fflib.FFParse_map_start:
			if tok != fflib.FFTok_left_bracket {
				wantedTok = fflib.FFTok_left_bracket
				goto wrongtokenerror
			}
			state = fflib.FFParse_want_key
			continue

		case fflib.FFParse_after_value:
			if tok == fflib.FFTok_comma {
				state = fflib.FFParse_want_key
			} else if tok == fflib.FFTok_right_bracket {
				goto done
			} else {
				wantedTok = fflib.FFTok_comma
				goto wrongtokenerror
			}

		case fflib.FFParse_want_key:
			// json {} ended. goto exit. woo.
			if tok == fflib.FFTok_right_bracket {
				goto done
			}
			if tok != fflib.FFTok_string {
				wantedTok = fflib.FFTok_string
				goto wrongtokenerror
			}

			kn := fs.Output.Bytes()
			if len(kn) <= 0 {
				// "" case. hrm.
				currentKey = ffj_t_HealthCheck_TCPCheckInfono_such_key
				state = fflib.FFParse_want_colon
				goto mainparse
			} else {
				switch kn[0] {

				case 'p':

					if bytes.Equal(ffj_key_HealthCheck_TCPCheckInfo_Protocol, kn) {
						currentKey = ffj_t_HealthCheck_TCPCheckInfo_Protocol
						state = fflib.FFParse_want_colon
						goto mainparse

					} else if bytes.Equal(ffj_key_HealthCheck_TCPCheckInfo_Port, kn) {
						currentKey = ffj_t_HealthCheck_TCPCheckInfo_Port
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				}

				if fflib.SimpleLetterEqualFold(ffj_key_HealthCheck_TCPCheckInfo_Port, kn) {
					currentKey = ffj_t_HealthCheck_TCPCheckInfo_Port
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.SimpleLetterEqualFold(ffj_key_HealthCheck_TCPCheckInfo_Protocol, kn) {
					currentKey = ffj_t_HealthCheck_TCPCheckInfo_Protocol
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				currentKey = ffj_t_HealthCheck_TCPCheckInfono_such_key
				state = fflib.FFParse_want_colon
				goto mainparse
			}

		case fflib.FFParse_want_colon:
			if tok != fflib.FFTok_colon {
				wantedTok = fflib.FFTok_colon
				goto wrongtokenerror
			}
			state = fflib.FFParse_want_value
			continue
		case fflib.FFParse_want_value:

			if tok == fflib.FFTok_left_brace || tok == fflib.FFTok_left_bracket || tok == fflib.FFTok_integer || tok == fflib.FFTok_double || tok == fflib.FFTok_string || tok == fflib.FFTok_bool || tok == fflib.FFTok_null {
				switch currentKey {

				case ffj_t_HealthCheck_TCPCheckInfo_Protocol:
					goto handle_Protocol

				case ffj_t_HealthCheck_TCPCheckInfo_Port:
					goto handle_Port

				case ffj_t_HealthCheck_TCPCheckInfono_such_key:
					err = fs.SkipField(tok)
					if err != nil {
						return fs.WrapErr(err)
					}
					state = fflib.FFParse_after_value
					goto mainparse
				}
			} else {
				goto wantedvalue
			}
		}
	}

handle_Protocol:

	/* handler: uj.Protocol type=mesos.NetworkInfo_Protocol kind=int32 quoted=false*/

	{
		if tok == fflib.FFTok_null {

			uj.Protocol = nil

			state = fflib.FFParse_after_value
			goto mainparse
		}

		tbuf, err := fs.CaptureField(tok)
		if err != nil {
			return fs.WrapErr(err)
		}

		if uj.Protocol == nil {
			uj.Protocol = new(NetworkInfo_Protocol)
		}

		err = uj.Protocol.UnmarshalJSON(tbuf)
		if err != nil {
			return fs.WrapErr(err)
		}
		state = fflib.FFParse_after_value
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_Port:

	/* handler: uj.Port type=uint32 kind=uint32 quoted=false*/

	{
		if tok != fflib.FFTok_integer && tok != fflib.FFTok_null {
			return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for uint32", tok))
		}
	}

	{

		if tok == fflib.FFTok_null {

		} else {

			tval, err := fflib.ParseUint(fs.Output.Bytes(), 10, 32)

			if err != nil {
				return fs.WrapErr(err)
			}

			uj.Port = uint32(tval)

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

wantedvalue:
	return fs.WrapErr(fmt.Errorf("wanted value token, but got token: %v", tok))
wrongtokenerror:
	return fs.WrapErr(fmt.Errorf("ffjson: wanted token: %v, but got token: %v output=%s", wantedTok, tok, fs.Output.String()))
tokerror:
	if fs.BigError != nil {
		return fs.WrapErr(fs.BigError)
	}
	err = fs.Error.ToError()
	if err != nil {
		return fs.WrapErr(err)
	}
	panic("ffjson-generated: unreachable, please report bug.")
done:

	return nil
}

func (mj *IcmpStatistics) MarshalJSON() ([]byte, error) {
	var buf fflib.Buffer
	if mj == nil {
		buf.WriteString("null")
		return buf.Bytes(), nil
	}
	err := mj.MarshalJSONBuf(&buf)
	if err != nil {
		return nil, err
	}
	return buf.Bytes(), nil
}
func (mj *IcmpStatistics) MarshalJSONBuf(buf fflib.EncodingBuffer) error {
	if mj == nil {
		buf.WriteString("null")
		return nil
	}
	var err error
	var obj []byte
	_ = obj
	_ = err
	buf.WriteString(`{ `)
	if mj.InMsgs != nil {
		if true {
			buf.WriteString(`"InMsgs":`)
			fflib.FormatBits2(buf, uint64(*mj.InMsgs), 10, *mj.InMsgs < 0)
			buf.WriteByte(',')
		}
	}
	if mj.InErrors != nil {
		if true {
			buf.WriteString(`"InErrors":`)
			fflib.FormatBits2(buf, uint64(*mj.InErrors), 10, *mj.InErrors < 0)
			buf.WriteByte(',')
		}
	}
	if mj.InCsumErrors != nil {
		if true {
			buf.WriteString(`"InCsumErrors":`)
			fflib.FormatBits2(buf, uint64(*mj.InCsumErrors), 10, *mj.InCsumErrors < 0)
			buf.WriteByte(',')
		}
	}
	if mj.InDestUnreachs != nil {
		if true {
			buf.WriteString(`"InDestUnreachs":`)
			fflib.FormatBits2(buf, uint64(*mj.InDestUnreachs), 10, *mj.InDestUnreachs < 0)
			buf.WriteByte(',')
		}
	}
	if mj.InTimeExcds != nil {
		if true {
			buf.WriteString(`"InTimeExcds":`)
			fflib.FormatBits2(buf, uint64(*mj.InTimeExcds), 10, *mj.InTimeExcds < 0)
			buf.WriteByte(',')
		}
	}
	if mj.InParmProbs != nil {
		if true {
			buf.WriteString(`"InParmProbs":`)
			fflib.FormatBits2(buf, uint64(*mj.InParmProbs), 10, *mj.InParmProbs < 0)
			buf.WriteByte(',')
		}
	}
	if mj.InSrcQuenchs != nil {
		if true {
			buf.WriteString(`"InSrcQuenchs":`)
			fflib.FormatBits2(buf, uint64(*mj.InSrcQuenchs), 10, *mj.InSrcQuenchs < 0)
			buf.WriteByte(',')
		}
	}
	if mj.InRedirects != nil {
		if true {
			buf.WriteString(`"InRedirects":`)
			fflib.FormatBits2(buf, uint64(*mj.InRedirects), 10, *mj.InRedirects < 0)
			buf.WriteByte(',')
		}
	}
	if mj.InEchos != nil {
		if true {
			buf.WriteString(`"InEchos":`)
			fflib.FormatBits2(buf, uint64(*mj.InEchos), 10, *mj.InEchos < 0)
			buf.WriteByte(',')
		}
	}
	if mj.InEchoReps != nil {
		if true {
			buf.WriteString(`"InEchoReps":`)
			fflib.FormatBits2(buf, uint64(*mj.InEchoReps), 10, *mj.InEchoReps < 0)
			buf.WriteByte(',')
		}
	}
	if mj.InTimestamps != nil {
		if true {
			buf.WriteString(`"InTimestamps":`)
			fflib.FormatBits2(buf, uint64(*mj.InTimestamps), 10, *mj.InTimestamps < 0)
			buf.WriteByte(',')
		}
	}
	if mj.InTimestampReps != nil {
		if true {
			buf.WriteString(`"InTimestampReps":`)
			fflib.FormatBits2(buf, uint64(*mj.InTimestampReps), 10, *mj.InTimestampReps < 0)
			buf.WriteByte(',')
		}
	}
	if mj.InAddrMasks != nil {
		if true {
			buf.WriteString(`"InAddrMasks":`)
			fflib.FormatBits2(buf, uint64(*mj.InAddrMasks), 10, *mj.InAddrMasks < 0)
			buf.WriteByte(',')
		}
	}
	if mj.InAddrMaskReps != nil {
		if true {
			buf.WriteString(`"InAddrMaskReps":`)
			fflib.FormatBits2(buf, uint64(*mj.InAddrMaskReps), 10, *mj.InAddrMaskReps < 0)
			buf.WriteByte(',')
		}
	}
	if mj.OutMsgs != nil {
		if true {
			buf.WriteString(`"OutMsgs":`)
			fflib.FormatBits2(buf, uint64(*mj.OutMsgs), 10, *mj.OutMsgs < 0)
			buf.WriteByte(',')
		}
	}
	if mj.OutErrors != nil {
		if true {
			buf.WriteString(`"OutErrors":`)
			fflib.FormatBits2(buf, uint64(*mj.OutErrors), 10, *mj.OutErrors < 0)
			buf.WriteByte(',')
		}
	}
	if mj.OutDestUnreachs != nil {
		if true {
			buf.WriteString(`"OutDestUnreachs":`)
			fflib.FormatBits2(buf, uint64(*mj.OutDestUnreachs), 10, *mj.OutDestUnreachs < 0)
			buf.WriteByte(',')
		}
	}
	if mj.OutTimeExcds != nil {
		if true {
			buf.WriteString(`"OutTimeExcds":`)
			fflib.FormatBits2(buf, uint64(*mj.OutTimeExcds), 10, *mj.OutTimeExcds < 0)
			buf.WriteByte(',')
		}
	}
	if mj.OutParmProbs != nil {
		if true {
			buf.WriteString(`"OutParmProbs":`)
			fflib.FormatBits2(buf, uint64(*mj.OutParmProbs), 10, *mj.OutParmProbs < 0)
			buf.WriteByte(',')
		}
	}
	if mj.OutSrcQuenchs != nil {
		if true {
			buf.WriteString(`"OutSrcQuenchs":`)
			fflib.FormatBits2(buf, uint64(*mj.OutSrcQuenchs), 10, *mj.OutSrcQuenchs < 0)
			buf.WriteByte(',')
		}
	}
	if mj.OutRedirects != nil {
		if true {
			buf.WriteString(`"OutRedirects":`)
			fflib.FormatBits2(buf, uint64(*mj.OutRedirects), 10, *mj.OutRedirects < 0)
			buf.WriteByte(',')
		}
	}
	if mj.OutEchos != nil {
		if true {
			buf.WriteString(`"OutEchos":`)
			fflib.FormatBits2(buf, uint64(*mj.OutEchos), 10, *mj.OutEchos < 0)
			buf.WriteByte(',')
		}
	}
	if mj.OutEchoReps != nil {
		if true {
			buf.WriteString(`"OutEchoReps":`)
			fflib.FormatBits2(buf, uint64(*mj.OutEchoReps), 10, *mj.OutEchoReps < 0)
			buf.WriteByte(',')
		}
	}
	if mj.OutTimestamps != nil {
		if true {
			buf.WriteString(`"OutTimestamps":`)
			fflib.FormatBits2(buf, uint64(*mj.OutTimestamps), 10, *mj.OutTimestamps < 0)
			buf.WriteByte(',')
		}
	}
	if mj.OutTimestampReps != nil {
		if true {
			buf.WriteString(`"OutTimestampReps":`)
			fflib.FormatBits2(buf, uint64(*mj.OutTimestampReps), 10, *mj.OutTimestampReps < 0)
			buf.WriteByte(',')
		}
	}
	if mj.OutAddrMasks != nil {
		if true {
			buf.WriteString(`"OutAddrMasks":`)
			fflib.FormatBits2(buf, uint64(*mj.OutAddrMasks), 10, *mj.OutAddrMasks < 0)
			buf.WriteByte(',')
		}
	}
	if mj.OutAddrMaskReps != nil {
		if true {
			buf.WriteString(`"OutAddrMaskReps":`)
			fflib.FormatBits2(buf, uint64(*mj.OutAddrMaskReps), 10, *mj.OutAddrMaskReps < 0)
			buf.WriteByte(',')
		}
	}
	buf.Rewind(1)
	buf.WriteByte('}')
	return nil
}

const (
	ffj_t_IcmpStatisticsbase = iota
	ffj_t_IcmpStatisticsno_such_key

	ffj_t_IcmpStatistics_InMsgs

	ffj_t_IcmpStatistics_InErrors

	ffj_t_IcmpStatistics_InCsumErrors

	ffj_t_IcmpStatistics_InDestUnreachs

	ffj_t_IcmpStatistics_InTimeExcds

	ffj_t_IcmpStatistics_InParmProbs

	ffj_t_IcmpStatistics_InSrcQuenchs

	ffj_t_IcmpStatistics_InRedirects

	ffj_t_IcmpStatistics_InEchos

	ffj_t_IcmpStatistics_InEchoReps

	ffj_t_IcmpStatistics_InTimestamps

	ffj_t_IcmpStatistics_InTimestampReps

	ffj_t_IcmpStatistics_InAddrMasks

	ffj_t_IcmpStatistics_InAddrMaskReps

	ffj_t_IcmpStatistics_OutMsgs

	ffj_t_IcmpStatistics_OutErrors

	ffj_t_IcmpStatistics_OutDestUnreachs

	ffj_t_IcmpStatistics_OutTimeExcds

	ffj_t_IcmpStatistics_OutParmProbs

	ffj_t_IcmpStatistics_OutSrcQuenchs

	ffj_t_IcmpStatistics_OutRedirects

	ffj_t_IcmpStatistics_OutEchos

	ffj_t_IcmpStatistics_OutEchoReps

	ffj_t_IcmpStatistics_OutTimestamps

	ffj_t_IcmpStatistics_OutTimestampReps

	ffj_t_IcmpStatistics_OutAddrMasks

	ffj_t_IcmpStatistics_OutAddrMaskReps
)

var ffj_key_IcmpStatistics_InMsgs = []byte("InMsgs")

var ffj_key_IcmpStatistics_InErrors = []byte("InErrors")

var ffj_key_IcmpStatistics_InCsumErrors = []byte("InCsumErrors")

var ffj_key_IcmpStatistics_InDestUnreachs = []byte("InDestUnreachs")

var ffj_key_IcmpStatistics_InTimeExcds = []byte("InTimeExcds")

var ffj_key_IcmpStatistics_InParmProbs = []byte("InParmProbs")

var ffj_key_IcmpStatistics_InSrcQuenchs = []byte("InSrcQuenchs")

var ffj_key_IcmpStatistics_InRedirects = []byte("InRedirects")

var ffj_key_IcmpStatistics_InEchos = []byte("InEchos")

var ffj_key_IcmpStatistics_InEchoReps = []byte("InEchoReps")

var ffj_key_IcmpStatistics_InTimestamps = []byte("InTimestamps")

var ffj_key_IcmpStatistics_InTimestampReps = []byte("InTimestampReps")

var ffj_key_IcmpStatistics_InAddrMasks = []byte("InAddrMasks")

var ffj_key_IcmpStatistics_InAddrMaskReps = []byte("InAddrMaskReps")

var ffj_key_IcmpStatistics_OutMsgs = []byte("OutMsgs")

var ffj_key_IcmpStatistics_OutErrors = []byte("OutErrors")

var ffj_key_IcmpStatistics_OutDestUnreachs = []byte("OutDestUnreachs")

var ffj_key_IcmpStatistics_OutTimeExcds = []byte("OutTimeExcds")

var ffj_key_IcmpStatistics_OutParmProbs = []byte("OutParmProbs")

var ffj_key_IcmpStatistics_OutSrcQuenchs = []byte("OutSrcQuenchs")

var ffj_key_IcmpStatistics_OutRedirects = []byte("OutRedirects")

var ffj_key_IcmpStatistics_OutEchos = []byte("OutEchos")

var ffj_key_IcmpStatistics_OutEchoReps = []byte("OutEchoReps")

var ffj_key_IcmpStatistics_OutTimestamps = []byte("OutTimestamps")

var ffj_key_IcmpStatistics_OutTimestampReps = []byte("OutTimestampReps")

var ffj_key_IcmpStatistics_OutAddrMasks = []byte("OutAddrMasks")

var ffj_key_IcmpStatistics_OutAddrMaskReps = []byte("OutAddrMaskReps")

func (uj *IcmpStatistics) UnmarshalJSON(input []byte) error {
	fs := fflib.NewFFLexer(input)
	return uj.UnmarshalJSONFFLexer(fs, fflib.FFParse_map_start)
}

func (uj *IcmpStatistics) UnmarshalJSONFFLexer(fs *fflib.FFLexer, state fflib.FFParseState) error {
	var err error = nil
	currentKey := ffj_t_IcmpStatisticsbase
	_ = currentKey
	tok := fflib.FFTok_init
	wantedTok := fflib.FFTok_init

mainparse:
	for {
		tok = fs.Scan()
		//	println(fmt.Sprintf("debug: tok: %v  state: %v", tok, state))
		if tok == fflib.FFTok_error {
			goto tokerror
		}

		switch state {

		case fflib.FFParse_map_start:
			if tok != fflib.FFTok_left_bracket {
				wantedTok = fflib.FFTok_left_bracket
				goto wrongtokenerror
			}
			state = fflib.FFParse_want_key
			continue

		case fflib.FFParse_after_value:
			if tok == fflib.FFTok_comma {
				state = fflib.FFParse_want_key
			} else if tok == fflib.FFTok_right_bracket {
				goto done
			} else {
				wantedTok = fflib.FFTok_comma
				goto wrongtokenerror
			}

		case fflib.FFParse_want_key:
			// json {} ended. goto exit. woo.
			if tok == fflib.FFTok_right_bracket {
				goto done
			}
			if tok != fflib.FFTok_string {
				wantedTok = fflib.FFTok_string
				goto wrongtokenerror
			}

			kn := fs.Output.Bytes()
			if len(kn) <= 0 {
				// "" case. hrm.
				currentKey = ffj_t_IcmpStatisticsno_such_key
				state = fflib.FFParse_want_colon
				goto mainparse
			} else {
				switch kn[0] {

				case 'I':

					if bytes.Equal(ffj_key_IcmpStatistics_InMsgs, kn) {
						currentKey = ffj_t_IcmpStatistics_InMsgs
						state = fflib.FFParse_want_colon
						goto mainparse

					} else if bytes.Equal(ffj_key_IcmpStatistics_InErrors, kn) {
						currentKey = ffj_t_IcmpStatistics_InErrors
						state = fflib.FFParse_want_colon
						goto mainparse

					} else if bytes.Equal(ffj_key_IcmpStatistics_InCsumErrors, kn) {
						currentKey = ffj_t_IcmpStatistics_InCsumErrors
						state = fflib.FFParse_want_colon
						goto mainparse

					} else if bytes.Equal(ffj_key_IcmpStatistics_InDestUnreachs, kn) {
						currentKey = ffj_t_IcmpStatistics_InDestUnreachs
						state = fflib.FFParse_want_colon
						goto mainparse

					} else if bytes.Equal(ffj_key_IcmpStatistics_InTimeExcds, kn) {
						currentKey = ffj_t_IcmpStatistics_InTimeExcds
						state = fflib.FFParse_want_colon
						goto mainparse

					} else if bytes.Equal(ffj_key_IcmpStatistics_InParmProbs, kn) {
						currentKey = ffj_t_IcmpStatistics_InParmProbs
						state = fflib.FFParse_want_colon
						goto mainparse

					} else if bytes.Equal(ffj_key_IcmpStatistics_InSrcQuenchs, kn) {
						currentKey = ffj_t_IcmpStatistics_InSrcQuenchs
						state = fflib.FFParse_want_colon
						goto mainparse

					} else if bytes.Equal(ffj_key_IcmpStatistics_InRedirects, kn) {
						currentKey = ffj_t_IcmpStatistics_InRedirects
						state = fflib.FFParse_want_colon
						goto mainparse

					} else if bytes.Equal(ffj_key_IcmpStatistics_InEchos, kn) {
						currentKey = ffj_t_IcmpStatistics_InEchos
						state = fflib.FFParse_want_colon
						goto mainparse

					} else if bytes.Equal(ffj_key_IcmpStatistics_InEchoReps, kn) {
						currentKey = ffj_t_IcmpStatistics_InEchoReps
						state = fflib.FFParse_want_colon
						goto mainparse

					} else if bytes.Equal(ffj_key_IcmpStatistics_InTimestamps, kn) {
						currentKey = ffj_t_IcmpStatistics_InTimestamps
						state = fflib.FFParse_want_colon
						goto mainparse

					} else if bytes.Equal(ffj_key_IcmpStatistics_InTimestampReps, kn) {
						currentKey = ffj_t_IcmpStatistics_InTimestampReps
						state = fflib.FFParse_want_colon
						goto mainparse

					} else if bytes.Equal(ffj_key_IcmpStatistics_InAddrMasks, kn) {
						currentKey = ffj_t_IcmpStatistics_InAddrMasks
						state = fflib.FFParse_want_colon
						goto mainparse

					} else if bytes.Equal(ffj_key_IcmpStatistics_InAddrMaskReps, kn) {
						currentKey = ffj_t_IcmpStatistics_InAddrMaskReps
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				case 'O':

					if bytes.Equal(ffj_key_IcmpStatistics_OutMsgs, kn) {
						currentKey = ffj_t_IcmpStatistics_OutMsgs
						state = fflib.FFParse_want_colon
						goto mainparse

					} else if bytes.Equal(ffj_key_IcmpStatistics_OutErrors, kn) {
						currentKey = ffj_t_IcmpStatistics_OutErrors
						state = fflib.FFParse_want_colon
						goto mainparse

					} else if bytes.Equal(ffj_key_IcmpStatistics_OutDestUnreachs, kn) {
						currentKey = ffj_t_IcmpStatistics_OutDestUnreachs
						state = fflib.FFParse_want_colon
						goto mainparse

					} else if bytes.Equal(ffj_key_IcmpStatistics_OutTimeExcds, kn) {
						currentKey = ffj_t_IcmpStatistics_OutTimeExcds
						state = fflib.FFParse_want_colon
						goto mainparse

					} else if bytes.Equal(ffj_key_IcmpStatistics_OutParmProbs, kn) {
						currentKey = ffj_t_IcmpStatistics_OutParmProbs
						state = fflib.FFParse_want_colon
						goto mainparse

					} else if bytes.Equal(ffj_key_IcmpStatistics_OutSrcQuenchs, kn) {
						currentKey = ffj_t_IcmpStatistics_OutSrcQuenchs
						state = fflib.FFParse_want_colon
						goto mainparse

					} else if bytes.Equal(ffj_key_IcmpStatistics_OutRedirects, kn) {
						currentKey = ffj_t_IcmpStatistics_OutRedirects
						state = fflib.FFParse_want_colon
						goto mainparse

					} else if bytes.Equal(ffj_key_IcmpStatistics_OutEchos, kn) {
						currentKey = ffj_t_IcmpStatistics_OutEchos
						state = fflib.FFParse_want_colon
						goto mainparse

					} else if bytes.Equal(ffj_key_IcmpStatistics_OutEchoReps, kn) {
						currentKey = ffj_t_IcmpStatistics_OutEchoReps
						state = fflib.FFParse_want_colon
						goto mainparse

					} else if bytes.Equal(ffj_key_IcmpStatistics_OutTimestamps, kn) {
						currentKey = ffj_t_IcmpStatistics_OutTimestamps
						state = fflib.FFParse_want_colon
						goto mainparse

					} else if bytes.Equal(ffj_key_IcmpStatistics_OutTimestampReps, kn) {
						currentKey = ffj_t_IcmpStatistics_OutTimestampReps
						state = fflib.FFParse_want_colon
						goto mainparse

					} else if bytes.Equal(ffj_key_IcmpStatistics_OutAddrMasks, kn) {
						currentKey = ffj_t_IcmpStatistics_OutAddrMasks
						state = fflib.FFParse_want_colon
						goto mainparse

					} else if bytes.Equal(ffj_key_IcmpStatistics_OutAddrMaskReps, kn) {
						currentKey = ffj_t_IcmpStatistics_OutAddrMaskReps
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				}

				if fflib.EqualFoldRight(ffj_key_IcmpStatistics_OutAddrMaskReps, kn) {
					currentKey = ffj_t_IcmpStatistics_OutAddrMaskReps
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffj_key_IcmpStatistics_OutAddrMasks, kn) {
					currentKey = ffj_t_IcmpStatistics_OutAddrMasks
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffj_key_IcmpStatistics_OutTimestampReps, kn) {
					currentKey = ffj_t_IcmpStatistics_OutTimestampReps
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffj_key_IcmpStatistics_OutTimestamps, kn) {
					currentKey = ffj_t_IcmpStatistics_OutTimestamps
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffj_key_IcmpStatistics_OutEchoReps, kn) {
					currentKey = ffj_t_IcmpStatistics_OutEchoReps
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffj_key_IcmpStatistics_OutEchos, kn) {
					currentKey = ffj_t_IcmpStatistics_OutEchos
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffj_key_IcmpStatistics_OutRedirects, kn) {
					currentKey = ffj_t_IcmpStatistics_OutRedirects
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffj_key_IcmpStatistics_OutSrcQuenchs, kn) {
					currentKey = ffj_t_IcmpStatistics_OutSrcQuenchs
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffj_key_IcmpStatistics_OutParmProbs, kn) {
					currentKey = ffj_t_IcmpStatistics_OutParmProbs
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffj_key_IcmpStatistics_OutTimeExcds, kn) {
					currentKey = ffj_t_IcmpStatistics_OutTimeExcds
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffj_key_IcmpStatistics_OutDestUnreachs, kn) {
					currentKey = ffj_t_IcmpStatistics_OutDestUnreachs
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffj_key_IcmpStatistics_OutErrors, kn) {
					currentKey = ffj_t_IcmpStatistics_OutErrors
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffj_key_IcmpStatistics_OutMsgs, kn) {
					currentKey = ffj_t_IcmpStatistics_OutMsgs
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffj_key_IcmpStatistics_InAddrMaskReps, kn) {
					currentKey = ffj_t_IcmpStatistics_InAddrMaskReps
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffj_key_IcmpStatistics_InAddrMasks, kn) {
					currentKey = ffj_t_IcmpStatistics_InAddrMasks
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffj_key_IcmpStatistics_InTimestampReps, kn) {
					currentKey = ffj_t_IcmpStatistics_InTimestampReps
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffj_key_IcmpStatistics_InTimestamps, kn) {
					currentKey = ffj_t_IcmpStatistics_InTimestamps
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffj_key_IcmpStatistics_InEchoReps, kn) {
					currentKey = ffj_t_IcmpStatistics_InEchoReps
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffj_key_IcmpStatistics_InEchos, kn) {
					currentKey = ffj_t_IcmpStatistics_InEchos
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffj_key_IcmpStatistics_InRedirects, kn) {
					currentKey = ffj_t_IcmpStatistics_InRedirects
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffj_key_IcmpStatistics_InSrcQuenchs, kn) {
					currentKey = ffj_t_IcmpStatistics_InSrcQuenchs
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffj_key_IcmpStatistics_InParmProbs, kn) {
					currentKey = ffj_t_IcmpStatistics_InParmProbs
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffj_key_IcmpStatistics_InTimeExcds, kn) {
					currentKey = ffj_t_IcmpStatistics_InTimeExcds
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffj_key_IcmpStatistics_InDestUnreachs, kn) {
					currentKey = ffj_t_IcmpStatistics_InDestUnreachs
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffj_key_IcmpStatistics_InCsumErrors, kn) {
					currentKey = ffj_t_IcmpStatistics_InCsumErrors
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffj_key_IcmpStatistics_InErrors, kn) {
					currentKey = ffj_t_IcmpStatistics_InErrors
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffj_key_IcmpStatistics_InMsgs, kn) {
					currentKey = ffj_t_IcmpStatistics_InMsgs
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				currentKey = ffj_t_IcmpStatisticsno_such_key
				state = fflib.FFParse_want_colon
				goto mainparse
			}

		case fflib.FFParse_want_colon:
			if tok != fflib.FFTok_colon {
				wantedTok = fflib.FFTok_colon
				goto wrongtokenerror
			}
			state = fflib.FFParse_want_value
			continue
		case fflib.FFParse_want_value:

			if tok == fflib.FFTok_left_brace || tok == fflib.FFTok_left_bracket || tok == fflib.FFTok_integer || tok == fflib.FFTok_double || tok == fflib.FFTok_string || tok == fflib.FFTok_bool || tok == fflib.FFTok_null {
				switch currentKey {

				case ffj_t_IcmpStatistics_InMsgs:
					goto handle_InMsgs

				case ffj_t_IcmpStatistics_InErrors:
					goto handle_InErrors

				case ffj_t_IcmpStatistics_InCsumErrors:
					goto handle_InCsumErrors

				case ffj_t_IcmpStatistics_InDestUnreachs:
					goto handle_InDestUnreachs

				case ffj_t_IcmpStatistics_InTimeExcds:
					goto handle_InTimeExcds

				case ffj_t_IcmpStatistics_InParmProbs:
					goto handle_InParmProbs

				case ffj_t_IcmpStatistics_InSrcQuenchs:
					goto handle_InSrcQuenchs

				case ffj_t_IcmpStatistics_InRedirects:
					goto handle_InRedirects

				case ffj_t_IcmpStatistics_InEchos:
					goto handle_InEchos

				case ffj_t_IcmpStatistics_InEchoReps:
					goto handle_InEchoReps

				case ffj_t_IcmpStatistics_InTimestamps:
					goto handle_InTimestamps

				case ffj_t_IcmpStatistics_InTimestampReps:
					goto handle_InTimestampReps

				case ffj_t_IcmpStatistics_InAddrMasks:
					goto handle_InAddrMasks

				case ffj_t_IcmpStatistics_InAddrMaskReps:
					goto handle_InAddrMaskReps

				case ffj_t_IcmpStatistics_OutMsgs:
					goto handle_OutMsgs

				case ffj_t_IcmpStatistics_OutErrors:
					goto handle_OutErrors

				case ffj_t_IcmpStatistics_OutDestUnreachs:
					goto handle_OutDestUnreachs

				case ffj_t_IcmpStatistics_OutTimeExcds:
					goto handle_OutTimeExcds

				case ffj_t_IcmpStatistics_OutParmProbs:
					goto handle_OutParmProbs

				case ffj_t_IcmpStatistics_OutSrcQuenchs:
					goto handle_OutSrcQuenchs

				case ffj_t_IcmpStatistics_OutRedirects:
					goto handle_OutRedirects

				case ffj_t_IcmpStatistics_OutEchos:
					goto handle_OutEchos

				case ffj_t_IcmpStatistics_OutEchoReps:
					goto handle_OutEchoReps

				case ffj_t_IcmpStatistics_OutTimestamps:
					goto handle_OutTimestamps

				case ffj_t_IcmpStatistics_OutTimestampReps:
					goto handle_OutTimestampReps

				case ffj_t_IcmpStatistics_OutAddrMasks:
					goto handle_OutAddrMasks

				case ffj_t_IcmpStatistics_OutAddrMaskReps:
					goto handle_OutAddrMaskReps

				case ffj_t_IcmpStatisticsno_such_key:
					err = fs.SkipField(tok)
					if err != nil {
						return fs.WrapErr(err)
					}
					state = fflib.FFParse_after_value
					goto mainparse
				}
			} else {
				goto wantedvalue
			}
		}
	}

handle_InMsgs:

	/* handler: uj.InMsgs type=int64 kind=int64 quoted=false*/

	{
		if tok != fflib.FFTok_integer && tok != fflib.FFTok_null {
			return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for int64", tok))
		}
	}

	{

		if tok == fflib.FFTok_null {

			uj.InMsgs = nil

		} else {

			tval, err := fflib.ParseInt(fs.Output.Bytes(), 10, 64)

			if err != nil {
				return fs.WrapErr(err)
			}

			ttypval := int64(tval)
			uj.InMsgs = &ttypval

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_InErrors:

	/* handler: uj.InErrors type=int64 kind=int64 quoted=false*/

	{
		if tok != fflib.FFTok_integer && tok != fflib.FFTok_null {
			return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for int64", tok))
		}
	}

	{

		if tok == fflib.FFTok_null {

			uj.InErrors = nil

		} else {

			tval, err := fflib.ParseInt(fs.Output.Bytes(), 10, 64)

			if err != nil {
				return fs.WrapErr(err)
			}

			ttypval := int64(tval)
			uj.InErrors = &ttypval

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_InCsumErrors:

	/* handler: uj.InCsumErrors type=int64 kind=int64 quoted=false*/

	{
		if tok != fflib.FFTok_integer && tok != fflib.FFTok_null {
			return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for int64", tok))
		}
	}

	{

		if tok == fflib.FFTok_null {

			uj.InCsumErrors = nil

		} else {

			tval, err := fflib.ParseInt(fs.Output.Bytes(), 10, 64)

			if err != nil {
				return fs.WrapErr(err)
			}

			ttypval := int64(tval)
			uj.InCsumErrors = &ttypval

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_InDestUnreachs:

	/* handler: uj.InDestUnreachs type=int64 kind=int64 quoted=false*/

	{
		if tok != fflib.FFTok_integer && tok != fflib.FFTok_null {
			return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for int64", tok))
		}
	}

	{

		if tok == fflib.FFTok_null {

			uj.InDestUnreachs = nil

		} else {

			tval, err := fflib.ParseInt(fs.Output.Bytes(), 10, 64)

			if err != nil {
				return fs.WrapErr(err)
			}

			ttypval := int64(tval)
			uj.InDestUnreachs = &ttypval

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_InTimeExcds:

	/* handler: uj.InTimeExcds type=int64 kind=int64 quoted=false*/

	{
		if tok != fflib.FFTok_integer && tok != fflib.FFTok_null {
			return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for int64", tok))
		}
	}

	{

		if tok == fflib.FFTok_null {

			uj.InTimeExcds = nil

		} else {

			tval, err := fflib.ParseInt(fs.Output.Bytes(), 10, 64)

			if err != nil {
				return fs.WrapErr(err)
			}

			ttypval := int64(tval)
			uj.InTimeExcds = &ttypval

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_InParmProbs:

	/* handler: uj.InParmProbs type=int64 kind=int64 quoted=false*/

	{
		if tok != fflib.FFTok_integer && tok != fflib.FFTok_null {
			return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for int64", tok))
		}
	}

	{

		if tok == fflib.FFTok_null {

			uj.InParmProbs = nil

		} else {

			tval, err := fflib.ParseInt(fs.Output.Bytes(), 10, 64)

			if err != nil {
				return fs.WrapErr(err)
			}

			ttypval := int64(tval)
			uj.InParmProbs = &ttypval

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_InSrcQuenchs:

	/* handler: uj.InSrcQuenchs type=int64 kind=int64 quoted=false*/

	{
		if tok != fflib.FFTok_integer && tok != fflib.FFTok_null {
			return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for int64", tok))
		}
	}

	{

		if tok == fflib.FFTok_null {

			uj.InSrcQuenchs = nil

		} else {

			tval, err := fflib.ParseInt(fs.Output.Bytes(), 10, 64)

			if err != nil {
				return fs.WrapErr(err)
			}

			ttypval := int64(tval)
			uj.InSrcQuenchs = &ttypval

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_InRedirects:

	/* handler: uj.InRedirects type=int64 kind=int64 quoted=false*/

	{
		if tok != fflib.FFTok_integer && tok != fflib.FFTok_null {
			return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for int64", tok))
		}
	}

	{

		if tok == fflib.FFTok_null {

			uj.InRedirects = nil

		} else {

			tval, err := fflib.ParseInt(fs.Output.Bytes(), 10, 64)

			if err != nil {
				return fs.WrapErr(err)
			}

			ttypval := int64(tval)
			uj.InRedirects = &ttypval

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_InEchos:

	/* handler: uj.InEchos type=int64 kind=int64 quoted=false*/

	{
		if tok != fflib.FFTok_integer && tok != fflib.FFTok_null {
			return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for int64", tok))
		}
	}

	{

		if tok == fflib.FFTok_null {

			uj.InEchos = nil

		} else {

			tval, err := fflib.ParseInt(fs.Output.Bytes(), 10, 64)

			if err != nil {
				return fs.WrapErr(err)
			}

			ttypval := int64(tval)
			uj.InEchos = &ttypval

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_InEchoReps:

	/* handler: uj.InEchoReps type=int64 kind=int64 quoted=false*/

	{
		if tok != fflib.FFTok_integer && tok != fflib.FFTok_null {
			return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for int64", tok))
		}
	}

	{

		if tok == fflib.FFTok_null {

			uj.InEchoReps = nil

		} else {

			tval, err := fflib.ParseInt(fs.Output.Bytes(), 10, 64)

			if err != nil {
				return fs.WrapErr(err)
			}

			ttypval := int64(tval)
			uj.InEchoReps = &ttypval

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_InTimestamps:

	/* handler: uj.InTimestamps type=int64 kind=int64 quoted=false*/

	{
		if tok != fflib.FFTok_integer && tok != fflib.FFTok_null {
			return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for int64", tok))
		}
	}

	{

		if tok == fflib.FFTok_null {

			uj.InTimestamps = nil

		} else {

			tval, err := fflib.ParseInt(fs.Output.Bytes(), 10, 64)

			if err != nil {
				return fs.WrapErr(err)
			}

			ttypval := int64(tval)
			uj.InTimestamps = &ttypval

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_InTimestampReps:

	/* handler: uj.InTimestampReps type=int64 kind=int64 quoted=false*/

	{
		if tok != fflib.FFTok_integer && tok != fflib.FFTok_null {
			return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for int64", tok))
		}
	}

	{

		if tok == fflib.FFTok_null {

			uj.InTimestampReps = nil

		} else {

			tval, err := fflib.ParseInt(fs.Output.Bytes(), 10, 64)

			if err != nil {
				return fs.WrapErr(err)
			}

			ttypval := int64(tval)
			uj.InTimestampReps = &ttypval

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_InAddrMasks:

	/* handler: uj.InAddrMasks type=int64 kind=int64 quoted=false*/

	{
		if tok != fflib.FFTok_integer && tok != fflib.FFTok_null {
			return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for int64", tok))
		}
	}

	{

		if tok == fflib.FFTok_null {

			uj.InAddrMasks = nil

		} else {

			tval, err := fflib.ParseInt(fs.Output.Bytes(), 10, 64)

			if err != nil {
				return fs.WrapErr(err)
			}

			ttypval := int64(tval)
			uj.InAddrMasks = &ttypval

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_InAddrMaskReps:

	/* handler: uj.InAddrMaskReps type=int64 kind=int64 quoted=false*/

	{
		if tok != fflib.FFTok_integer && tok != fflib.FFTok_null {
			return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for int64", tok))
		}
	}

	{

		if tok == fflib.FFTok_null {

			uj.InAddrMaskReps = nil

		} else {

			tval, err := fflib.ParseInt(fs.Output.Bytes(), 10, 64)

			if err != nil {
				return fs.WrapErr(err)
			}

			ttypval := int64(tval)
			uj.InAddrMaskReps = &ttypval

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_OutMsgs:

	/* handler: uj.OutMsgs type=int64 kind=int64 quoted=false*/

	{
		if tok != fflib.FFTok_integer && tok != fflib.FFTok_null {
			return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for int64", tok))
		}
	}

	{

		if tok == fflib.FFTok_null {

			uj.OutMsgs = nil

		} else {

			tval, err := fflib.ParseInt(fs.Output.Bytes(), 10, 64)

			if err != nil {
				return fs.WrapErr(err)
			}

			ttypval := int64(tval)
			uj.OutMsgs = &ttypval

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_OutErrors:

	/* handler: uj.OutErrors type=int64 kind=int64 quoted=false*/

	{
		if tok != fflib.FFTok_integer && tok != fflib.FFTok_null {
			return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for int64", tok))
		}
	}

	{

		if tok == fflib.FFTok_null {

			uj.OutErrors = nil

		} else {

			tval, err := fflib.ParseInt(fs.Output.Bytes(), 10, 64)

			if err != nil {
				return fs.WrapErr(err)
			}

			ttypval := int64(tval)
			uj.OutErrors = &ttypval

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_OutDestUnreachs:

	/* handler: uj.OutDestUnreachs type=int64 kind=int64 quoted=false*/

	{
		if tok != fflib.FFTok_integer && tok != fflib.FFTok_null {
			return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for int64", tok))
		}
	}

	{

		if tok == fflib.FFTok_null {

			uj.OutDestUnreachs = nil

		} else {

			tval, err := fflib.ParseInt(fs.Output.Bytes(), 10, 64)

			if err != nil {
				return fs.WrapErr(err)
			}

			ttypval := int64(tval)
			uj.OutDestUnreachs = &ttypval

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_OutTimeExcds:

	/* handler: uj.OutTimeExcds type=int64 kind=int64 quoted=false*/

	{
		if tok != fflib.FFTok_integer && tok != fflib.FFTok_null {
			return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for int64", tok))
		}
	}

	{

		if tok == fflib.FFTok_null {

			uj.OutTimeExcds = nil

		} else {

			tval, err := fflib.ParseInt(fs.Output.Bytes(), 10, 64)

			if err != nil {
				return fs.WrapErr(err)
			}

			ttypval := int64(tval)
			uj.OutTimeExcds = &ttypval

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_OutParmProbs:

	/* handler: uj.OutParmProbs type=int64 kind=int64 quoted=false*/

	{
		if tok != fflib.FFTok_integer && tok != fflib.FFTok_null {
			return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for int64", tok))
		}
	}

	{

		if tok == fflib.FFTok_null {

			uj.OutParmProbs = nil

		} else {

			tval, err := fflib.ParseInt(fs.Output.Bytes(), 10, 64)

			if err != nil {
				return fs.WrapErr(err)
			}

			ttypval := int64(tval)
			uj.OutParmProbs = &ttypval

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_OutSrcQuenchs:

	/* handler: uj.OutSrcQuenchs type=int64 kind=int64 quoted=false*/

	{
		if tok != fflib.FFTok_integer && tok != fflib.FFTok_null {
			return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for int64", tok))
		}
	}

	{

		if tok == fflib.FFTok_null {

			uj.OutSrcQuenchs = nil

		} else {

			tval, err := fflib.ParseInt(fs.Output.Bytes(), 10, 64)

			if err != nil {
				return fs.WrapErr(err)
			}

			ttypval := int64(tval)
			uj.OutSrcQuenchs = &ttypval

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_OutRedirects:

	/* handler: uj.OutRedirects type=int64 kind=int64 quoted=false*/

	{
		if tok != fflib.FFTok_integer && tok != fflib.FFTok_null {
			return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for int64", tok))
		}
	}

	{

		if tok == fflib.FFTok_null {

			uj.OutRedirects = nil

		} else {

			tval, err := fflib.ParseInt(fs.Output.Bytes(), 10, 64)

			if err != nil {
				return fs.WrapErr(err)
			}

			ttypval := int64(tval)
			uj.OutRedirects = &ttypval

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_OutEchos:

	/* handler: uj.OutEchos type=int64 kind=int64 quoted=false*/

	{
		if tok != fflib.FFTok_integer && tok != fflib.FFTok_null {
			return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for int64", tok))
		}
	}

	{

		if tok == fflib.FFTok_null {

			uj.OutEchos = nil

		} else {

			tval, err := fflib.ParseInt(fs.Output.Bytes(), 10, 64)

			if err != nil {
				return fs.WrapErr(err)
			}

			ttypval := int64(tval)
			uj.OutEchos = &ttypval

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_OutEchoReps:

	/* handler: uj.OutEchoReps type=int64 kind=int64 quoted=false*/

	{
		if tok != fflib.FFTok_integer && tok != fflib.FFTok_null {
			return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for int64", tok))
		}
	}

	{

		if tok == fflib.FFTok_null {

			uj.OutEchoReps = nil

		} else {

			tval, err := fflib.ParseInt(fs.Output.Bytes(), 10, 64)

			if err != nil {
				return fs.WrapErr(err)
			}

			ttypval := int64(tval)
			uj.OutEchoReps = &ttypval

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_OutTimestamps:

	/* handler: uj.OutTimestamps type=int64 kind=int64 quoted=false*/

	{
		if tok != fflib.FFTok_integer && tok != fflib.FFTok_null {
			return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for int64", tok))
		}
	}

	{

		if tok == fflib.FFTok_null {

			uj.OutTimestamps = nil

		} else {

			tval, err := fflib.ParseInt(fs.Output.Bytes(), 10, 64)

			if err != nil {
				return fs.WrapErr(err)
			}

			ttypval := int64(tval)
			uj.OutTimestamps = &ttypval

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_OutTimestampReps:

	/* handler: uj.OutTimestampReps type=int64 kind=int64 quoted=false*/

	{
		if tok != fflib.FFTok_integer && tok != fflib.FFTok_null {
			return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for int64", tok))
		}
	}

	{

		if tok == fflib.FFTok_null {

			uj.OutTimestampReps = nil

		} else {

			tval, err := fflib.ParseInt(fs.Output.Bytes(), 10, 64)

			if err != nil {
				return fs.WrapErr(err)
			}

			ttypval := int64(tval)
			uj.OutTimestampReps = &ttypval

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_OutAddrMasks:

	/* handler: uj.OutAddrMasks type=int64 kind=int64 quoted=false*/

	{
		if tok != fflib.FFTok_integer && tok != fflib.FFTok_null {
			return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for int64", tok))
		}
	}

	{

		if tok == fflib.FFTok_null {

			uj.OutAddrMasks = nil

		} else {

			tval, err := fflib.ParseInt(fs.Output.Bytes(), 10, 64)

			if err != nil {
				return fs.WrapErr(err)
			}

			ttypval := int64(tval)
			uj.OutAddrMasks = &ttypval

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_OutAddrMaskReps:

	/* handler: uj.OutAddrMaskReps type=int64 kind=int64 quoted=false*/

	{
		if tok != fflib.FFTok_integer && tok != fflib.FFTok_null {
			return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for int64", tok))
		}
	}

	{

		if tok == fflib.FFTok_null {

			uj.OutAddrMaskReps = nil

		} else {

			tval, err := fflib.ParseInt(fs.Output.Bytes(), 10, 64)

			if err != nil {
				return fs.WrapErr(err)
			}

			ttypval := int64(tval)
			uj.OutAddrMaskReps = &ttypval

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

wantedvalue:
	return fs.WrapErr(fmt.Errorf("wanted value token, but got token: %v", tok))
wrongtokenerror:
	return fs.WrapErr(fmt.Errorf("ffjson: wanted token: %v, but got token: %v output=%s", wantedTok, tok, fs.Output.String()))
tokerror:
	if fs.BigError != nil {
		return fs.WrapErr(fs.BigError)
	}
	err = fs.Error.ToError()
	if err != nil {
		return fs.WrapErr(err)
	}
	panic("ffjson-generated: unreachable, please report bug.")
done:

	return nil
}

func (mj *Image) MarshalJSON() ([]byte, error) {
	var buf fflib.Buffer
	if mj == nil {
		buf.WriteString("null")
		return buf.Bytes(), nil
	}
	err := mj.MarshalJSONBuf(&buf)
	if err != nil {
		return nil, err
	}
	return buf.Bytes(), nil
}
func (mj *Image) MarshalJSONBuf(buf fflib.EncodingBuffer) error {
	if mj == nil {
		buf.WriteString("null")
		return nil
	}
	var err error
	var obj []byte
	_ = obj
	_ = err
	buf.WriteString(`{ `)
	if mj.Type != nil {
		if true {
			buf.WriteString(`"type":`)

			{

				obj, err = mj.Type.MarshalJSON()
				if err != nil {
					return err
				}
				buf.Write(obj)

			}
			buf.WriteByte(',')
		}
	}
	if mj.Appc != nil {
		if true {
			buf.WriteString(`"appc":`)

			{

				err = mj.Appc.MarshalJSONBuf(buf)
				if err != nil {
					return err
				}

			}
			buf.WriteByte(',')
		}
	}
	if mj.Docker != nil {
		if true {
			buf.WriteString(`"docker":`)

			{

				err = mj.Docker.MarshalJSONBuf(buf)
				if err != nil {
					return err
				}

			}
			buf.WriteByte(',')
		}
	}
	if mj.Cached != nil {
		if true {
			if *mj.Cached {
				buf.WriteString(`"cached":true`)
			} else {
				buf.WriteString(`"cached":false`)
			}
			buf.WriteByte(',')
		}
	}
	buf.Rewind(1)
	buf.WriteByte('}')
	return nil
}

const (
	ffj_t_Imagebase = iota
	ffj_t_Imageno_such_key

	ffj_t_Image_Type

	ffj_t_Image_Appc

	ffj_t_Image_Docker

	ffj_t_Image_Cached
)

var ffj_key_Image_Type = []byte("type")

var ffj_key_Image_Appc = []byte("appc")

var ffj_key_Image_Docker = []byte("docker")

var ffj_key_Image_Cached = []byte("cached")

func (uj *Image) UnmarshalJSON(input []byte) error {
	fs := fflib.NewFFLexer(input)
	return uj.UnmarshalJSONFFLexer(fs, fflib.FFParse_map_start)
}

func (uj *Image) UnmarshalJSONFFLexer(fs *fflib.FFLexer, state fflib.FFParseState) error {
	var err error = nil
	currentKey := ffj_t_Imagebase
	_ = currentKey
	tok := fflib.FFTok_init
	wantedTok := fflib.FFTok_init

mainparse:
	for {
		tok = fs.Scan()
		//	println(fmt.Sprintf("debug: tok: %v  state: %v", tok, state))
		if tok == fflib.FFTok_error {
			goto tokerror
		}

		switch state {

		case fflib.FFParse_map_start:
			if tok != fflib.FFTok_left_bracket {
				wantedTok = fflib.FFTok_left_bracket
				goto wrongtokenerror
			}
			state = fflib.FFParse_want_key
			continue

		case fflib.FFParse_after_value:
			if tok == fflib.FFTok_comma {
				state = fflib.FFParse_want_key
			} else if tok == fflib.FFTok_right_bracket {
				goto done
			} else {
				wantedTok = fflib.FFTok_comma
				goto wrongtokenerror
			}

		case fflib.FFParse_want_key:
			// json {} ended. goto exit. woo.
			if tok == fflib.FFTok_right_bracket {
				goto done
			}
			if tok != fflib.FFTok_string {
				wantedTok = fflib.FFTok_string
				goto wrongtokenerror
			}

			kn := fs.Output.Bytes()
			if len(kn) <= 0 {
				// "" case. hrm.
				currentKey = ffj_t_Imageno_such_key
				state = fflib.FFParse_want_colon
				goto mainparse
			} else {
				switch kn[0] {

				case 'a':

					if bytes.Equal(ffj_key_Image_Appc, kn) {
						currentKey = ffj_t_Image_Appc
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				case 'c':

					if bytes.Equal(ffj_key_Image_Cached, kn) {
						currentKey = ffj_t_Image_Cached
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				case 'd':

					if bytes.Equal(ffj_key_Image_Docker, kn) {
						currentKey = ffj_t_Image_Docker
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				case 't':

					if bytes.Equal(ffj_key_Image_Type, kn) {
						currentKey = ffj_t_Image_Type
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				}

				if fflib.SimpleLetterEqualFold(ffj_key_Image_Cached, kn) {
					currentKey = ffj_t_Image_Cached
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffj_key_Image_Docker, kn) {
					currentKey = ffj_t_Image_Docker
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.SimpleLetterEqualFold(ffj_key_Image_Appc, kn) {
					currentKey = ffj_t_Image_Appc
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.SimpleLetterEqualFold(ffj_key_Image_Type, kn) {
					currentKey = ffj_t_Image_Type
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				currentKey = ffj_t_Imageno_such_key
				state = fflib.FFParse_want_colon
				goto mainparse
			}

		case fflib.FFParse_want_colon:
			if tok != fflib.FFTok_colon {
				wantedTok = fflib.FFTok_colon
				goto wrongtokenerror
			}
			state = fflib.FFParse_want_value
			continue
		case fflib.FFParse_want_value:

			if tok == fflib.FFTok_left_brace || tok == fflib.FFTok_left_bracket || tok == fflib.FFTok_integer || tok == fflib.FFTok_double || tok == fflib.FFTok_string || tok == fflib.FFTok_bool || tok == fflib.FFTok_null {
				switch currentKey {

				case ffj_t_Image_Type:
					goto handle_Type

				case ffj_t_Image_Appc:
					goto handle_Appc

				case ffj_t_Image_Docker:
					goto handle_Docker

				case ffj_t_Image_Cached:
					goto handle_Cached

				case ffj_t_Imageno_such_key:
					err = fs.SkipField(tok)
					if err != nil {
						return fs.WrapErr(err)
					}
					state = fflib.FFParse_after_value
					goto mainparse
				}
			} else {
				goto wantedvalue
			}
		}
	}

handle_Type:

	/* handler: uj.Type type=mesos.Image_Type kind=int32 quoted=false*/

	{
		if tok == fflib.FFTok_null {

			uj.Type = nil

			state = fflib.FFParse_after_value
			goto mainparse
		}

		tbuf, err := fs.CaptureField(tok)
		if err != nil {
			return fs.WrapErr(err)
		}

		if uj.Type == nil {
			uj.Type = new(Image_Type)
		}

		err = uj.Type.UnmarshalJSON(tbuf)
		if err != nil {
			return fs.WrapErr(err)
		}
		state = fflib.FFParse_after_value
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_Appc:

	/* handler: uj.Appc type=mesos.Image_Appc kind=struct quoted=false*/

	{
		if tok == fflib.FFTok_null {

			uj.Appc = nil

			state = fflib.FFParse_after_value
			goto mainparse
		}

		if uj.Appc == nil {
			uj.Appc = new(Image_Appc)
		}

		err = uj.Appc.UnmarshalJSONFFLexer(fs, fflib.FFParse_want_key)
		if err != nil {
			return err
		}
		state = fflib.FFParse_after_value
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_Docker:

	/* handler: uj.Docker type=mesos.Image_Docker kind=struct quoted=false*/

	{
		if tok == fflib.FFTok_null {

			uj.Docker = nil

			state = fflib.FFParse_after_value
			goto mainparse
		}

		if uj.Docker == nil {
			uj.Docker = new(Image_Docker)
		}

		err = uj.Docker.UnmarshalJSONFFLexer(fs, fflib.FFParse_want_key)
		if err != nil {
			return err
		}
		state = fflib.FFParse_after_value
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_Cached:

	/* handler: uj.Cached type=bool kind=bool quoted=false*/

	{
		if tok != fflib.FFTok_bool && tok != fflib.FFTok_null {
			return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for bool", tok))
		}
	}

	{
		if tok == fflib.FFTok_null {

			uj.Cached = nil

		} else {
			tmpb := fs.Output.Bytes()

			var tval bool

			if bytes.Compare([]byte{'t', 'r', 'u', 'e'}, tmpb) == 0 {

				tval = true

			} else if bytes.Compare([]byte{'f', 'a', 'l', 's', 'e'}, tmpb) == 0 {

				tval = false

			} else {
				err = errors.New("unexpected bytes for true/false value")
				return fs.WrapErr(err)
			}

			uj.Cached = &tval

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

wantedvalue:
	return fs.WrapErr(fmt.Errorf("wanted value token, but got token: %v", tok))
wrongtokenerror:
	return fs.WrapErr(fmt.Errorf("ffjson: wanted token: %v, but got token: %v output=%s", wantedTok, tok, fs.Output.String()))
tokerror:
	if fs.BigError != nil {
		return fs.WrapErr(fs.BigError)
	}
	err = fs.Error.ToError()
	if err != nil {
		return fs.WrapErr(err)
	}
	panic("ffjson-generated: unreachable, please report bug.")
done:

	return nil
}

func (mj *Image_Appc) MarshalJSON() ([]byte, error) {
	var buf fflib.Buffer
	if mj == nil {
		buf.WriteString("null")
		return buf.Bytes(), nil
	}
	err := mj.MarshalJSONBuf(&buf)
	if err != nil {
		return nil, err
	}
	return buf.Bytes(), nil
}
func (mj *Image_Appc) MarshalJSONBuf(buf fflib.EncodingBuffer) error {
	if mj == nil {
		buf.WriteString("null")
		return nil
	}
	var err error
	var obj []byte
	_ = obj
	_ = err
	buf.WriteString(`{ "name":`)
	fflib.WriteJsonString(buf, string(mj.Name))
	buf.WriteByte(',')
	if mj.ID != nil {
		if true {
			buf.WriteString(`"id":`)
			fflib.WriteJsonString(buf, string(*mj.ID))
			buf.WriteByte(',')
		}
	}
	if mj.Labels != nil {
		if true {
			buf.WriteString(`"labels":`)

			{

				err = mj.Labels.MarshalJSONBuf(buf)
				if err != nil {
					return err
				}

			}
			buf.WriteByte(',')
		}
	}
	buf.Rewind(1)
	buf.WriteByte('}')
	return nil
}

const (
	ffj_t_Image_Appcbase = iota
	ffj_t_Image_Appcno_such_key

	ffj_t_Image_Appc_Name

	ffj_t_Image_Appc_ID

	ffj_t_Image_Appc_Labels
)

var ffj_key_Image_Appc_Name = []byte("name")

var ffj_key_Image_Appc_ID = []byte("id")

var ffj_key_Image_Appc_Labels = []byte("labels")

func (uj *Image_Appc) UnmarshalJSON(input []byte) error {
	fs := fflib.NewFFLexer(input)
	return uj.UnmarshalJSONFFLexer(fs, fflib.FFParse_map_start)
}

func (uj *Image_Appc) UnmarshalJSONFFLexer(fs *fflib.FFLexer, state fflib.FFParseState) error {
	var err error = nil
	currentKey := ffj_t_Image_Appcbase
	_ = currentKey
	tok := fflib.FFTok_init
	wantedTok := fflib.FFTok_init

mainparse:
	for {
		tok = fs.Scan()
		//	println(fmt.Sprintf("debug: tok: %v  state: %v", tok, state))
		if tok == fflib.FFTok_error {
			goto tokerror
		}

		switch state {

		case fflib.FFParse_map_start:
			if tok != fflib.FFTok_left_bracket {
				wantedTok = fflib.FFTok_left_bracket
				goto wrongtokenerror
			}
			state = fflib.FFParse_want_key
			continue

		case fflib.FFParse_after_value:
			if tok == fflib.FFTok_comma {
				state = fflib.FFParse_want_key
			} else if tok == fflib.FFTok_right_bracket {
				goto done
			} else {
				wantedTok = fflib.FFTok_comma
				goto wrongtokenerror
			}

		case fflib.FFParse_want_key:
			// json {} ended. goto exit. woo.
			if tok == fflib.FFTok_right_bracket {
				goto done
			}
			if tok != fflib.FFTok_string {
				wantedTok = fflib.FFTok_string
				goto wrongtokenerror
			}

			kn := fs.Output.Bytes()
			if len(kn) <= 0 {
				// "" case. hrm.
				currentKey = ffj_t_Image_Appcno_such_key
				state = fflib.FFParse_want_colon
				goto mainparse
			} else {
				switch kn[0] {

				case 'i':

					if bytes.Equal(ffj_key_Image_Appc_ID, kn) {
						currentKey = ffj_t_Image_Appc_ID
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				case 'l':

					if bytes.Equal(ffj_key_Image_Appc_Labels, kn) {
						currentKey = ffj_t_Image_Appc_Labels
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				case 'n':

					if bytes.Equal(ffj_key_Image_Appc_Name, kn) {
						currentKey = ffj_t_Image_Appc_Name
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				}

				if fflib.EqualFoldRight(ffj_key_Image_Appc_Labels, kn) {
					currentKey = ffj_t_Image_Appc_Labels
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.SimpleLetterEqualFold(ffj_key_Image_Appc_ID, kn) {
					currentKey = ffj_t_Image_Appc_ID
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.SimpleLetterEqualFold(ffj_key_Image_Appc_Name, kn) {
					currentKey = ffj_t_Image_Appc_Name
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				currentKey = ffj_t_Image_Appcno_such_key
				state = fflib.FFParse_want_colon
				goto mainparse
			}

		case fflib.FFParse_want_colon:
			if tok != fflib.FFTok_colon {
				wantedTok = fflib.FFTok_colon
				goto wrongtokenerror
			}
			state = fflib.FFParse_want_value
			continue
		case fflib.FFParse_want_value:

			if tok == fflib.FFTok_left_brace || tok == fflib.FFTok_left_bracket || tok == fflib.FFTok_integer || tok == fflib.FFTok_double || tok == fflib.FFTok_string || tok == fflib.FFTok_bool || tok == fflib.FFTok_null {
				switch currentKey {

				case ffj_t_Image_Appc_Name:
					goto handle_Name

				case ffj_t_Image_Appc_ID:
					goto handle_ID

				case ffj_t_Image_Appc_Labels:
					goto handle_Labels

				case ffj_t_Image_Appcno_such_key:
					err = fs.SkipField(tok)
					if err != nil {
						return fs.WrapErr(err)
					}
					state = fflib.FFParse_after_value
					goto mainparse
				}
			} else {
				goto wantedvalue
			}
		}
	}

handle_Name:

	/* handler: uj.Name type=string kind=string quoted=false*/

	{

		{
			if tok != fflib.FFTok_string && tok != fflib.FFTok_null {
				return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for string", tok))
			}
		}

		if tok == fflib.FFTok_null {

		} else {

			outBuf := fs.Output.Bytes()

			uj.Name = string(string(outBuf))

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_ID:

	/* handler: uj.ID type=string kind=string quoted=false*/

	{

		{
			if tok != fflib.FFTok_string && tok != fflib.FFTok_null {
				return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for string", tok))
			}
		}

		if tok == fflib.FFTok_null {

			uj.ID = nil

		} else {

			var tval string
			outBuf := fs.Output.Bytes()

			tval = string(string(outBuf))
			uj.ID = &tval

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_Labels:

	/* handler: uj.Labels type=mesos.Labels kind=struct quoted=false*/

	{
		if tok == fflib.FFTok_null {

			uj.Labels = nil

			state = fflib.FFParse_after_value
			goto mainparse
		}

		if uj.Labels == nil {
			uj.Labels = new(Labels)
		}

		err = uj.Labels.UnmarshalJSONFFLexer(fs, fflib.FFParse_want_key)
		if err != nil {
			return err
		}
		state = fflib.FFParse_after_value
	}

	state = fflib.FFParse_after_value
	goto mainparse

wantedvalue:
	return fs.WrapErr(fmt.Errorf("wanted value token, but got token: %v", tok))
wrongtokenerror:
	return fs.WrapErr(fmt.Errorf("ffjson: wanted token: %v, but got token: %v output=%s", wantedTok, tok, fs.Output.String()))
tokerror:
	if fs.BigError != nil {
		return fs.WrapErr(fs.BigError)
	}
	err = fs.Error.ToError()
	if err != nil {
		return fs.WrapErr(err)
	}
	panic("ffjson-generated: unreachable, please report bug.")
done:

	return nil
}

func (mj *Image_Docker) MarshalJSON() ([]byte, error) {
	var buf fflib.Buffer
	if mj == nil {
		buf.WriteString("null")
		return buf.Bytes(), nil
	}
	err := mj.MarshalJSONBuf(&buf)
	if err != nil {
		return nil, err
	}
	return buf.Bytes(), nil
}
func (mj *Image_Docker) MarshalJSONBuf(buf fflib.EncodingBuffer) error {
	if mj == nil {
		buf.WriteString("null")
		return nil
	}
	var err error
	var obj []byte
	_ = obj
	_ = err
	buf.WriteString(`{ "name":`)
	fflib.WriteJsonString(buf, string(mj.Name))
	buf.WriteByte(',')
	if mj.Credential != nil {
		if true {
			buf.WriteString(`"credential":`)

			{

				err = mj.Credential.MarshalJSONBuf(buf)
				if err != nil {
					return err
				}

			}
			buf.WriteByte(',')
		}
	}
	if mj.Config != nil {
		if true {
			buf.WriteString(`"config":`)

			{

				err = mj.Config.MarshalJSONBuf(buf)
				if err != nil {
					return err
				}

			}
			buf.WriteByte(',')
		}
	}
	buf.Rewind(1)
	buf.WriteByte('}')
	return nil
}

const (
	ffj_t_Image_Dockerbase = iota
	ffj_t_Image_Dockerno_such_key

	ffj_t_Image_Docker_Name

	ffj_t_Image_Docker_Credential

	ffj_t_Image_Docker_Config
)

var ffj_key_Image_Docker_Name = []byte("name")

var ffj_key_Image_Docker_Credential = []byte("credential")

var ffj_key_Image_Docker_Config = []byte("config")

func (uj *Image_Docker) UnmarshalJSON(input []byte) error {
	fs := fflib.NewFFLexer(input)
	return uj.UnmarshalJSONFFLexer(fs, fflib.FFParse_map_start)
}

func (uj *Image_Docker) UnmarshalJSONFFLexer(fs *fflib.FFLexer, state fflib.FFParseState) error {
	var err error = nil
	currentKey := ffj_t_Image_Dockerbase
	_ = currentKey
	tok := fflib.FFTok_init
	wantedTok := fflib.FFTok_init

mainparse:
	for {
		tok = fs.Scan()
		//	println(fmt.Sprintf("debug: tok: %v  state: %v", tok, state))
		if tok == fflib.FFTok_error {
			goto tokerror
		}

		switch state {

		case fflib.FFParse_map_start:
			if tok != fflib.FFTok_left_bracket {
				wantedTok = fflib.FFTok_left_bracket
				goto wrongtokenerror
			}
			state = fflib.FFParse_want_key
			continue

		case fflib.FFParse_after_value:
			if tok == fflib.FFTok_comma {
				state = fflib.FFParse_want_key
			} else if tok == fflib.FFTok_right_bracket {
				goto done
			} else {
				wantedTok = fflib.FFTok_comma
				goto wrongtokenerror
			}

		case fflib.FFParse_want_key:
			// json {} ended. goto exit. woo.
			if tok == fflib.FFTok_right_bracket {
				goto done
			}
			if tok != fflib.FFTok_string {
				wantedTok = fflib.FFTok_string
				goto wrongtokenerror
			}

			kn := fs.Output.Bytes()
			if len(kn) <= 0 {
				// "" case. hrm.
				currentKey = ffj_t_Image_Dockerno_such_key
				state = fflib.FFParse_want_colon
				goto mainparse
			} else {
				switch kn[0] {

				case 'c':

					if bytes.Equal(ffj_key_Image_Docker_Credential, kn) {
						currentKey = ffj_t_Image_Docker_Credential
						state = fflib.FFParse_want_colon
						goto mainparse

					} else if bytes.Equal(ffj_key_Image_Docker_Config, kn) {
						currentKey = ffj_t_Image_Docker_Config
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				case 'n':

					if bytes.Equal(ffj_key_Image_Docker_Name, kn) {
						currentKey = ffj_t_Image_Docker_Name
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				}

				if fflib.SimpleLetterEqualFold(ffj_key_Image_Docker_Config, kn) {
					currentKey = ffj_t_Image_Docker_Config
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.SimpleLetterEqualFold(ffj_key_Image_Docker_Credential, kn) {
					currentKey = ffj_t_Image_Docker_Credential
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.SimpleLetterEqualFold(ffj_key_Image_Docker_Name, kn) {
					currentKey = ffj_t_Image_Docker_Name
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				currentKey = ffj_t_Image_Dockerno_such_key
				state = fflib.FFParse_want_colon
				goto mainparse
			}

		case fflib.FFParse_want_colon:
			if tok != fflib.FFTok_colon {
				wantedTok = fflib.FFTok_colon
				goto wrongtokenerror
			}
			state = fflib.FFParse_want_value
			continue
		case fflib.FFParse_want_value:

			if tok == fflib.FFTok_left_brace || tok == fflib.FFTok_left_bracket || tok == fflib.FFTok_integer || tok == fflib.FFTok_double || tok == fflib.FFTok_string || tok == fflib.FFTok_bool || tok == fflib.FFTok_null {
				switch currentKey {

				case ffj_t_Image_Docker_Name:
					goto handle_Name

				case ffj_t_Image_Docker_Credential:
					goto handle_Credential

				case ffj_t_Image_Docker_Config:
					goto handle_Config

				case ffj_t_Image_Dockerno_such_key:
					err = fs.SkipField(tok)
					if err != nil {
						return fs.WrapErr(err)
					}
					state = fflib.FFParse_after_value
					goto mainparse
				}
			} else {
				goto wantedvalue
			}
		}
	}

handle_Name:

	/* handler: uj.Name type=string kind=string quoted=false*/

	{

		{
			if tok != fflib.FFTok_string && tok != fflib.FFTok_null {
				return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for string", tok))
			}
		}

		if tok == fflib.FFTok_null {

		} else {

			outBuf := fs.Output.Bytes()

			uj.Name = string(string(outBuf))

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_Credential:

	/* handler: uj.Credential type=mesos.Credential kind=struct quoted=false*/

	{
		if tok == fflib.FFTok_null {

			uj.Credential = nil

			state = fflib.FFParse_after_value
			goto mainparse
		}

		if uj.Credential == nil {
			uj.Credential = new(Credential)
		}

		err = uj.Credential.UnmarshalJSONFFLexer(fs, fflib.FFParse_want_key)
		if err != nil {
			return err
		}
		state = fflib.FFParse_after_value
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_Config:

	/* handler: uj.Config type=mesos.Secret kind=struct quoted=false*/

	{
		if tok == fflib.FFTok_null {

			uj.Config = nil

			state = fflib.FFParse_after_value
			goto mainparse
		}

		if uj.Config == nil {
			uj.Config = new(Secret)
		}

		err = uj.Config.UnmarshalJSONFFLexer(fs, fflib.FFParse_want_key)
		if err != nil {
			return err
		}
		state = fflib.FFParse_after_value
	}

	state = fflib.FFParse_after_value
	goto mainparse

wantedvalue:
	return fs.WrapErr(fmt.Errorf("wanted value token, but got token: %v", tok))
wrongtokenerror:
	return fs.WrapErr(fmt.Errorf("ffjson: wanted token: %v, but got token: %v output=%s", wantedTok, tok, fs.Output.String()))
tokerror:
	if fs.BigError != nil {
		return fs.WrapErr(fs.BigError)
	}
	err = fs.Error.ToError()
	if err != nil {
		return fs.WrapErr(err)
	}
	panic("ffjson-generated: unreachable, please report bug.")
done:

	return nil
}

func (mj *InverseOffer) MarshalJSON() ([]byte, error) {
	var buf fflib.Buffer
	if mj == nil {
		buf.WriteString("null")
		return buf.Bytes(), nil
	}
	err := mj.MarshalJSONBuf(&buf)
	if err != nil {
		return nil, err
	}
	return buf.Bytes(), nil
}
func (mj *InverseOffer) MarshalJSONBuf(buf fflib.EncodingBuffer) error {
	if mj == nil {
		buf.WriteString("null")
		return nil
	}
	var err error
	var obj []byte
	_ = obj
	_ = err
	buf.WriteString(`{"id":`)

	{

		err = mj.OfferID.MarshalJSONBuf(buf)
		if err != nil {
			return err
		}

	}
	buf.WriteByte(',')
	if mj.URL != nil {
		if true {
			buf.WriteString(`"url":`)

			{

				err = mj.URL.MarshalJSONBuf(buf)
				if err != nil {
					return err
				}

			}
			buf.WriteByte(',')
		}
	}
	buf.WriteString(`"framework_id":`)

	{

		err = mj.FrameworkID.MarshalJSONBuf(buf)
		if err != nil {
			return err
		}

	}
	buf.WriteByte(',')
	if mj.AgentID != nil {
		if true {
			buf.WriteString(`"agent_id":`)

			{

				err = mj.AgentID.MarshalJSONBuf(buf)
				if err != nil {
					return err
				}

			}
			buf.WriteByte(',')
		}
	}
	buf.WriteString(`"unavailability":`)

	{

		err = mj.Unavailability.MarshalJSONBuf(buf)
		if err != nil {
			return err
		}

	}
	buf.WriteString(`,"resources":`)
	if mj.Resources != nil {
		buf.WriteString(`[`)
		for i, v := range mj.Resources {
			if i != 0 {
				buf.WriteString(`,`)
			}

			{

				err = v.MarshalJSONBuf(buf)
				if err != nil {
					return err
				}

			}
		}
		buf.WriteString(`]`)
	} else {
		buf.WriteString(`null`)
	}
	buf.WriteByte('}')
	return nil
}

const (
	ffj_t_InverseOfferbase = iota
	ffj_t_InverseOfferno_such_key

	ffj_t_InverseOffer_OfferID

	ffj_t_InverseOffer_URL

	ffj_t_InverseOffer_FrameworkID

	ffj_t_InverseOffer_AgentID

	ffj_t_InverseOffer_Unavailability

	ffj_t_InverseOffer_Resources
)

var ffj_key_InverseOffer_OfferID = []byte("id")

var ffj_key_InverseOffer_URL = []byte("url")

var ffj_key_InverseOffer_FrameworkID = []byte("framework_id")

var ffj_key_InverseOffer_AgentID = []byte("agent_id")

var ffj_key_InverseOffer_Unavailability = []byte("unavailability")

var ffj_key_InverseOffer_Resources = []byte("resources")

func (uj *InverseOffer) UnmarshalJSON(input []byte) error {
	fs := fflib.NewFFLexer(input)
	return uj.UnmarshalJSONFFLexer(fs, fflib.FFParse_map_start)
}

func (uj *InverseOffer) UnmarshalJSONFFLexer(fs *fflib.FFLexer, state fflib.FFParseState) error {
	var err error = nil
	currentKey := ffj_t_InverseOfferbase
	_ = currentKey
	tok := fflib.FFTok_init
	wantedTok := fflib.FFTok_init

mainparse:
	for {
		tok = fs.Scan()
		//	println(fmt.Sprintf("debug: tok: %v  state: %v", tok, state))
		if tok == fflib.FFTok_error {
			goto tokerror
		}

		switch state {

		case fflib.FFParse_map_start:
			if tok != fflib.FFTok_left_bracket {
				wantedTok = fflib.FFTok_left_bracket
				goto wrongtokenerror
			}
			state = fflib.FFParse_want_key
			continue

		case fflib.FFParse_after_value:
			if tok == fflib.FFTok_comma {
				state = fflib.FFParse_want_key
			} else if tok == fflib.FFTok_right_bracket {
				goto done
			} else {
				wantedTok = fflib.FFTok_comma
				goto wrongtokenerror
			}

		case fflib.FFParse_want_key:
			// json {} ended. goto exit. woo.
			if tok == fflib.FFTok_right_bracket {
				goto done
			}
			if tok != fflib.FFTok_string {
				wantedTok = fflib.FFTok_string
				goto wrongtokenerror
			}

			kn := fs.Output.Bytes()
			if len(kn) <= 0 {
				// "" case. hrm.
				currentKey = ffj_t_InverseOfferno_such_key
				state = fflib.FFParse_want_colon
				goto mainparse
			} else {
				switch kn[0] {

				case 'a':

					if bytes.Equal(ffj_key_InverseOffer_AgentID, kn) {
						currentKey = ffj_t_InverseOffer_AgentID
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				case 'f':

					if bytes.Equal(ffj_key_InverseOffer_FrameworkID, kn) {
						currentKey = ffj_t_InverseOffer_FrameworkID
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				case 'i':

					if bytes.Equal(ffj_key_InverseOffer_OfferID, kn) {
						currentKey = ffj_t_InverseOffer_OfferID
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				case 'r':

					if bytes.Equal(ffj_key_InverseOffer_Resources, kn) {
						currentKey = ffj_t_InverseOffer_Resources
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				case 'u':

					if bytes.Equal(ffj_key_InverseOffer_URL, kn) {
						currentKey = ffj_t_InverseOffer_URL
						state = fflib.FFParse_want_colon
						goto mainparse

					} else if bytes.Equal(ffj_key_InverseOffer_Unavailability, kn) {
						currentKey = ffj_t_InverseOffer_Unavailability
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				}

				if fflib.EqualFoldRight(ffj_key_InverseOffer_Resources, kn) {
					currentKey = ffj_t_InverseOffer_Resources
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.SimpleLetterEqualFold(ffj_key_InverseOffer_Unavailability, kn) {
					currentKey = ffj_t_InverseOffer_Unavailability
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.AsciiEqualFold(ffj_key_InverseOffer_AgentID, kn) {
					currentKey = ffj_t_InverseOffer_AgentID
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffj_key_InverseOffer_FrameworkID, kn) {
					currentKey = ffj_t_InverseOffer_FrameworkID
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.SimpleLetterEqualFold(ffj_key_InverseOffer_URL, kn) {
					currentKey = ffj_t_InverseOffer_URL
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.SimpleLetterEqualFold(ffj_key_InverseOffer_OfferID, kn) {
					currentKey = ffj_t_InverseOffer_OfferID
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				currentKey = ffj_t_InverseOfferno_such_key
				state = fflib.FFParse_want_colon
				goto mainparse
			}

		case fflib.FFParse_want_colon:
			if tok != fflib.FFTok_colon {
				wantedTok = fflib.FFTok_colon
				goto wrongtokenerror
			}
			state = fflib.FFParse_want_value
			continue
		case fflib.FFParse_want_value:

			if tok == fflib.FFTok_left_brace || tok == fflib.FFTok_left_bracket || tok == fflib.FFTok_integer || tok == fflib.FFTok_double || tok == fflib.FFTok_string || tok == fflib.FFTok_bool || tok == fflib.FFTok_null {
				switch currentKey {

				case ffj_t_InverseOffer_OfferID:
					goto handle_OfferID

				case ffj_t_InverseOffer_URL:
					goto handle_URL

				case ffj_t_InverseOffer_FrameworkID:
					goto handle_FrameworkID

				case ffj_t_InverseOffer_AgentID:
					goto handle_AgentID

				case ffj_t_InverseOffer_Unavailability:
					goto handle_Unavailability

				case ffj_t_InverseOffer_Resources:
					goto handle_Resources

				case ffj_t_InverseOfferno_such_key:
					err = fs.SkipField(tok)
					if err != nil {
						return fs.WrapErr(err)
					}
					state = fflib.FFParse_after_value
					goto mainparse
				}
			} else {
				goto wantedvalue
			}
		}
	}

handle_OfferID:

	/* handler: uj.OfferID type=mesos.OfferID kind=struct quoted=false*/

	{
		if tok == fflib.FFTok_null {

			state = fflib.FFParse_after_value
			goto mainparse
		}

		err = uj.OfferID.UnmarshalJSONFFLexer(fs, fflib.FFParse_want_key)
		if err != nil {
			return err
		}
		state = fflib.FFParse_after_value
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_URL:

	/* handler: uj.URL type=mesos.URL kind=struct quoted=false*/

	{
		if tok == fflib.FFTok_null {

			uj.URL = nil

			state = fflib.FFParse_after_value
			goto mainparse
		}

		if uj.URL == nil {
			uj.URL = new(URL)
		}

		err = uj.URL.UnmarshalJSONFFLexer(fs, fflib.FFParse_want_key)
		if err != nil {
			return err
		}
		state = fflib.FFParse_after_value
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_FrameworkID:

	/* handler: uj.FrameworkID type=mesos.FrameworkID kind=struct quoted=false*/

	{
		if tok == fflib.FFTok_null {

			state = fflib.FFParse_after_value
			goto mainparse
		}

		err = uj.FrameworkID.UnmarshalJSONFFLexer(fs, fflib.FFParse_want_key)
		if err != nil {
			return err
		}
		state = fflib.FFParse_after_value
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_AgentID:

	/* handler: uj.AgentID type=mesos.AgentID kind=struct quoted=false*/

	{
		if tok == fflib.FFTok_null {

			uj.AgentID = nil

			state = fflib.FFParse_after_value
			goto mainparse
		}

		if uj.AgentID == nil {
			uj.AgentID = new(AgentID)
		}

		err = uj.AgentID.UnmarshalJSONFFLexer(fs, fflib.FFParse_want_key)
		if err != nil {
			return err
		}
		state = fflib.FFParse_after_value
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_Unavailability:

	/* handler: uj.Unavailability type=mesos.Unavailability kind=struct quoted=false*/

	{
		if tok == fflib.FFTok_null {

			state = fflib.FFParse_after_value
			goto mainparse
		}

		err = uj.Unavailability.UnmarshalJSONFFLexer(fs, fflib.FFParse_want_key)
		if err != nil {
			return err
		}
		state = fflib.FFParse_after_value
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_Resources:

	/* handler: uj.Resources type=[]mesos.Resource kind=slice quoted=false*/

	{

		{
			if tok != fflib.FFTok_left_brace && tok != fflib.FFTok_null {
				return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for ", tok))
			}
		}

		if tok == fflib.FFTok_null {
			uj.Resources = nil
		} else {

			uj.Resources = []Resource{}

			wantVal := true

			for {

				var tmp_uj__Resources Resource

				tok = fs.Scan()
				if tok == fflib.FFTok_error {
					goto tokerror
				}
				if tok == fflib.FFTok_right_brace {
					break
				}

				if tok == fflib.FFTok_comma {
					if wantVal == true {
						// TODO(pquerna): this isn't an ideal error message, this handles
						// things like [,,,] as an array value.
						return fs.WrapErr(fmt.Errorf("wanted value token, but got token: %v", tok))
					}
					continue
				} else {
					wantVal = true
				}

				/* handler: tmp_uj__Resources type=mesos.Resource kind=struct quoted=false*/

				{
					if tok == fflib.FFTok_null {

						state = fflib.FFParse_after_value
						goto mainparse
					}

					err = tmp_uj__Resources.UnmarshalJSONFFLexer(fs, fflib.FFParse_want_key)
					if err != nil {
						return err
					}
					state = fflib.FFParse_after_value
				}

				uj.Resources = append(uj.Resources, tmp_uj__Resources)

				wantVal = false
			}
		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

wantedvalue:
	return fs.WrapErr(fmt.Errorf("wanted value token, but got token: %v", tok))
wrongtokenerror:
	return fs.WrapErr(fmt.Errorf("ffjson: wanted token: %v, but got token: %v output=%s", wantedTok, tok, fs.Output.String()))
tokerror:
	if fs.BigError != nil {
		return fs.WrapErr(fs.BigError)
	}
	err = fs.Error.ToError()
	if err != nil {
		return fs.WrapErr(err)
	}
	panic("ffjson-generated: unreachable, please report bug.")
done:

	return nil
}

func (mj *IpStatistics) MarshalJSON() ([]byte, error) {
	var buf fflib.Buffer
	if mj == nil {
		buf.WriteString("null")
		return buf.Bytes(), nil
	}
	err := mj.MarshalJSONBuf(&buf)
	if err != nil {
		return nil, err
	}
	return buf.Bytes(), nil
}
func (mj *IpStatistics) MarshalJSONBuf(buf fflib.EncodingBuffer) error {
	if mj == nil {
		buf.WriteString("null")
		return nil
	}
	var err error
	var obj []byte
	_ = obj
	_ = err
	buf.WriteString(`{ `)
	if mj.Forwarding != nil {
		if true {
			buf.WriteString(`"Forwarding":`)
			fflib.FormatBits2(buf, uint64(*mj.Forwarding), 10, *mj.Forwarding < 0)
			buf.WriteByte(',')
		}
	}
	if mj.DefaultTTL != nil {
		if true {
			buf.WriteString(`"DefaultTTL":`)
			fflib.FormatBits2(buf, uint64(*mj.DefaultTTL), 10, *mj.DefaultTTL < 0)
			buf.WriteByte(',')
		}
	}
	if mj.InReceives != nil {
		if true {
			buf.WriteString(`"InReceives":`)
			fflib.FormatBits2(buf, uint64(*mj.InReceives), 10, *mj.InReceives < 0)
			buf.WriteByte(',')
		}
	}
	if mj.InHdrErrors != nil {
		if true {
			buf.WriteString(`"InHdrErrors":`)
			fflib.FormatBits2(buf, uint64(*mj.InHdrErrors), 10, *mj.InHdrErrors < 0)
			buf.WriteByte(',')
		}
	}
	if mj.InAddrErrors != nil {
		if true {
			buf.WriteString(`"InAddrErrors":`)
			fflib.FormatBits2(buf, uint64(*mj.InAddrErrors), 10, *mj.InAddrErrors < 0)
			buf.WriteByte(',')
		}
	}
	if mj.ForwDatagrams != nil {
		if true {
			buf.WriteString(`"ForwDatagrams":`)
			fflib.FormatBits2(buf, uint64(*mj.ForwDatagrams), 10, *mj.ForwDatagrams < 0)
			buf.WriteByte(',')
		}
	}
	if mj.InUnknownProtos != nil {
		if true {
			buf.WriteString(`"InUnknownProtos":`)
			fflib.FormatBits2(buf, uint64(*mj.InUnknownProtos), 10, *mj.InUnknownProtos < 0)
			buf.WriteByte(',')
		}
	}
	if mj.InDiscards != nil {
		if true {
			buf.WriteString(`"InDiscards":`)
			fflib.FormatBits2(buf, uint64(*mj.InDiscards), 10, *mj.InDiscards < 0)
			buf.WriteByte(',')
		}
	}
	if mj.InDelivers != nil {
		if true {
			buf.WriteString(`"InDelivers":`)
			fflib.FormatBits2(buf, uint64(*mj.InDelivers), 10, *mj.InDelivers < 0)
			buf.WriteByte(',')
		}
	}
	if mj.OutRequests != nil {
		if true {
			buf.WriteString(`"OutRequests":`)
			fflib.FormatBits2(buf, uint64(*mj.OutRequests), 10, *mj.OutRequests < 0)
			buf.WriteByte(',')
		}
	}
	if mj.OutDiscards != nil {
		if true {
			buf.WriteString(`"OutDiscards":`)
			fflib.FormatBits2(buf, uint64(*mj.OutDiscards), 10, *mj.OutDiscards < 0)
			buf.WriteByte(',')
		}
	}
	if mj.OutNoRoutes != nil {
		if true {
			buf.WriteString(`"OutNoRoutes":`)
			fflib.FormatBits2(buf, uint64(*mj.OutNoRoutes), 10, *mj.OutNoRoutes < 0)
			buf.WriteByte(',')
		}
	}
	if mj.ReasmTimeout != nil {
		if true {
			buf.WriteString(`"ReasmTimeout":`)
			fflib.FormatBits2(buf, uint64(*mj.ReasmTimeout), 10, *mj.ReasmTimeout < 0)
			buf.WriteByte(',')
		}
	}
	if mj.ReasmReqds != nil {
		if true {
			buf.WriteString(`"ReasmReqds":`)
			fflib.FormatBits2(buf, uint64(*mj.ReasmReqds), 10, *mj.ReasmReqds < 0)
			buf.WriteByte(',')
		}
	}
	if mj.ReasmOKs != nil {
		if true {
			buf.WriteString(`"ReasmOKs":`)
			fflib.FormatBits2(buf, uint64(*mj.ReasmOKs), 10, *mj.ReasmOKs < 0)
			buf.WriteByte(',')
		}
	}
	if mj.ReasmFails != nil {
		if true {
			buf.WriteString(`"ReasmFails":`)
			fflib.FormatBits2(buf, uint64(*mj.ReasmFails), 10, *mj.ReasmFails < 0)
			buf.WriteByte(',')
		}
	}
	if mj.FragOKs != nil {
		if true {
			buf.WriteString(`"FragOKs":`)
			fflib.FormatBits2(buf, uint64(*mj.FragOKs), 10, *mj.FragOKs < 0)
			buf.WriteByte(',')
		}
	}
	if mj.FragFails != nil {
		if true {
			buf.WriteString(`"FragFails":`)
			fflib.FormatBits2(buf, uint64(*mj.FragFails), 10, *mj.FragFails < 0)
			buf.WriteByte(',')
		}
	}
	if mj.FragCreates != nil {
		if true {
			buf.WriteString(`"FragCreates":`)
			fflib.FormatBits2(buf, uint64(*mj.FragCreates), 10, *mj.FragCreates < 0)
			buf.WriteByte(',')
		}
	}
	buf.Rewind(1)
	buf.WriteByte('}')
	return nil
}

const (
	ffj_t_IpStatisticsbase = iota
	ffj_t_IpStatisticsno_such_key

	ffj_t_IpStatistics_Forwarding

	ffj_t_IpStatistics_DefaultTTL

	ffj_t_IpStatistics_InReceives

	ffj_t_IpStatistics_InHdrErrors

	ffj_t_IpStatistics_InAddrErrors

	ffj_t_IpStatistics_ForwDatagrams

	ffj_t_IpStatistics_InUnknownProtos

	ffj_t_IpStatistics_InDiscards

	ffj_t_IpStatistics_InDelivers

	ffj_t_IpStatistics_OutRequests

	ffj_t_IpStatistics_OutDiscards

	ffj_t_IpStatistics_OutNoRoutes

	ffj_t_IpStatistics_ReasmTimeout

	ffj_t_IpStatistics_ReasmReqds

	ffj_t_IpStatistics_ReasmOKs

	ffj_t_IpStatistics_ReasmFails

	ffj_t_IpStatistics_FragOKs

	ffj_t_IpStatistics_FragFails

	ffj_t_IpStatistics_FragCreates
)

var ffj_key_IpStatistics_Forwarding = []byte("Forwarding")

var ffj_key_IpStatistics_DefaultTTL = []byte("DefaultTTL")

var ffj_key_IpStatistics_InReceives = []byte("InReceives")

var ffj_key_IpStatistics_InHdrErrors = []byte("InHdrErrors")

var ffj_key_IpStatistics_InAddrErrors = []byte("InAddrErrors")

var ffj_key_IpStatistics_ForwDatagrams = []byte("ForwDatagrams")

var ffj_key_IpStatistics_InUnknownProtos = []byte("InUnknownProtos")

var ffj_key_IpStatistics_InDiscards = []byte("InDiscards")

var ffj_key_IpStatistics_InDelivers = []byte("InDelivers")

var ffj_key_IpStatistics_OutRequests = []byte("OutRequests")

var ffj_key_IpStatistics_OutDiscards = []byte("OutDiscards")

var ffj_key_IpStatistics_OutNoRoutes = []byte("OutNoRoutes")

var ffj_key_IpStatistics_ReasmTimeout = []byte("ReasmTimeout")

var ffj_key_IpStatistics_ReasmReqds = []byte("ReasmReqds")

var ffj_key_IpStatistics_ReasmOKs = []byte("ReasmOKs")

var ffj_key_IpStatistics_ReasmFails = []byte("ReasmFails")

var ffj_key_IpStatistics_FragOKs = []byte("FragOKs")

var ffj_key_IpStatistics_FragFails = []byte("FragFails")

var ffj_key_IpStatistics_FragCreates = []byte("FragCreates")

func (uj *IpStatistics) UnmarshalJSON(input []byte) error {
	fs := fflib.NewFFLexer(input)
	return uj.UnmarshalJSONFFLexer(fs, fflib.FFParse_map_start)
}

func (uj *IpStatistics) UnmarshalJSONFFLexer(fs *fflib.FFLexer, state fflib.FFParseState) error {
	var err error = nil
	currentKey := ffj_t_IpStatisticsbase
	_ = currentKey
	tok := fflib.FFTok_init
	wantedTok := fflib.FFTok_init

mainparse:
	for {
		tok = fs.Scan()
		//	println(fmt.Sprintf("debug: tok: %v  state: %v", tok, state))
		if tok == fflib.FFTok_error {
			goto tokerror
		}

		switch state {

		case fflib.FFParse_map_start:
			if tok != fflib.FFTok_left_bracket {
				wantedTok = fflib.FFTok_left_bracket
				goto wrongtokenerror
			}
			state = fflib.FFParse_want_key
			continue

		case fflib.FFParse_after_value:
			if tok == fflib.FFTok_comma {
				state = fflib.FFParse_want_key
			} else if tok == fflib.FFTok_right_bracket {
				goto done
			} else {
				wantedTok = fflib.FFTok_comma
				goto wrongtokenerror
			}

		case fflib.FFParse_want_key:
			// json {} ended. goto exit. woo.
			if tok == fflib.FFTok_right_bracket {
				goto done
			}
			if tok != fflib.FFTok_string {
				wantedTok = fflib.FFTok_string
				goto wrongtokenerror
			}

			kn := fs.Output.Bytes()
			if len(kn) <= 0 {
				// "" case. hrm.
				currentKey = ffj_t_IpStatisticsno_such_key
				state = fflib.FFParse_want_colon
				goto mainparse
			} else {
				switch kn[0] {

				case 'D':

					if bytes.Equal(ffj_key_IpStatistics_DefaultTTL, kn) {
						currentKey = ffj_t_IpStatistics_DefaultTTL
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				case 'F':

					if bytes.Equal(ffj_key_IpStatistics_Forwarding, kn) {
						currentKey = ffj_t_IpStatistics_Forwarding
						state = fflib.FFParse_want_colon
						goto mainparse

					} else if bytes.Equal(ffj_key_IpStatistics_ForwDatagrams, kn) {
						currentKey = ffj_t_IpStatistics_ForwDatagrams
						state = fflib.FFParse_want_colon
						goto mainparse

					} else if bytes.Equal(ffj_key_IpStatistics_FragOKs, kn) {
						currentKey = ffj_t_IpStatistics_FragOKs
						state = fflib.FFParse_want_colon
						goto mainparse

					} else if bytes.Equal(ffj_key_IpStatistics_FragFails, kn) {
						currentKey = ffj_t_IpStatistics_FragFails
						state = fflib.FFParse_want_colon
						goto mainparse

					} else if bytes.Equal(ffj_key_IpStatistics_FragCreates, kn) {
						currentKey = ffj_t_IpStatistics_FragCreates
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				case 'I':

					if bytes.Equal(ffj_key_IpStatistics_InReceives, kn) {
						currentKey = ffj_t_IpStatistics_InReceives
						state = fflib.FFParse_want_colon
						goto mainparse

					} else if bytes.Equal(ffj_key_IpStatistics_InHdrErrors, kn) {
						currentKey = ffj_t_IpStatistics_InHdrErrors
						state = fflib.FFParse_want_colon
						goto mainparse

					} else if bytes.Equal(ffj_key_IpStatistics_InAddrErrors, kn) {
						currentKey = ffj_t_IpStatistics_InAddrErrors
						state = fflib.FFParse_want_colon
						goto mainparse

					} else if bytes.Equal(ffj_key_IpStatistics_InUnknownProtos, kn) {
						currentKey = ffj_t_IpStatistics_InUnknownProtos
						state = fflib.FFParse_want_colon
						goto mainparse

					} else if bytes.Equal(ffj_key_IpStatistics_InDiscards, kn) {
						currentKey = ffj_t_IpStatistics_InDiscards
						state = fflib.FFParse_want_colon
						goto mainparse

					} else if bytes.Equal(ffj_key_IpStatistics_InDelivers, kn) {
						currentKey = ffj_t_IpStatistics_InDelivers
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				case 'O':

					if bytes.Equal(ffj_key_IpStatistics_OutRequests, kn) {
						currentKey = ffj_t_IpStatistics_OutRequests
						state = fflib.FFParse_want_colon
						goto mainparse

					} else if bytes.Equal(ffj_key_IpStatistics_OutDiscards, kn) {
						currentKey = ffj_t_IpStatistics_OutDiscards
						state = fflib.FFParse_want_colon
						goto mainparse

					} else if bytes.Equal(ffj_key_IpStatistics_OutNoRoutes, kn) {
						currentKey = ffj_t_IpStatistics_OutNoRoutes
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				case 'R':

					if bytes.Equal(ffj_key_IpStatistics_ReasmTimeout, kn) {
						currentKey = ffj_t_IpStatistics_ReasmTimeout
						state = fflib.FFParse_want_colon
						goto mainparse

					} else if bytes.Equal(ffj_key_IpStatistics_ReasmReqds, kn) {
						currentKey = ffj_t_IpStatistics_ReasmReqds
						state = fflib.FFParse_want_colon
						goto mainparse

					} else if bytes.Equal(ffj_key_IpStatistics_ReasmOKs, kn) {
						currentKey = ffj_t_IpStatistics_ReasmOKs
						state = fflib.FFParse_want_colon
						goto mainparse

					} else if bytes.Equal(ffj_key_IpStatistics_ReasmFails, kn) {
						currentKey = ffj_t_IpStatistics_ReasmFails
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				}

				if fflib.EqualFoldRight(ffj_key_IpStatistics_FragCreates, kn) {
					currentKey = ffj_t_IpStatistics_FragCreates
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffj_key_IpStatistics_FragFails, kn) {
					currentKey = ffj_t_IpStatistics_FragFails
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffj_key_IpStatistics_FragOKs, kn) {
					currentKey = ffj_t_IpStatistics_FragOKs
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffj_key_IpStatistics_ReasmFails, kn) {
					currentKey = ffj_t_IpStatistics_ReasmFails
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffj_key_IpStatistics_ReasmOKs, kn) {
					currentKey = ffj_t_IpStatistics_ReasmOKs
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffj_key_IpStatistics_ReasmReqds, kn) {
					currentKey = ffj_t_IpStatistics_ReasmReqds
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffj_key_IpStatistics_ReasmTimeout, kn) {
					currentKey = ffj_t_IpStatistics_ReasmTimeout
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffj_key_IpStatistics_OutNoRoutes, kn) {
					currentKey = ffj_t_IpStatistics_OutNoRoutes
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffj_key_IpStatistics_OutDiscards, kn) {
					currentKey = ffj_t_IpStatistics_OutDiscards
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffj_key_IpStatistics_OutRequests, kn) {
					currentKey = ffj_t_IpStatistics_OutRequests
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffj_key_IpStatistics_InDelivers, kn) {
					currentKey = ffj_t_IpStatistics_InDelivers
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffj_key_IpStatistics_InDiscards, kn) {
					currentKey = ffj_t_IpStatistics_InDiscards
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffj_key_IpStatistics_InUnknownProtos, kn) {
					currentKey = ffj_t_IpStatistics_InUnknownProtos
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffj_key_IpStatistics_ForwDatagrams, kn) {
					currentKey = ffj_t_IpStatistics_ForwDatagrams
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffj_key_IpStatistics_InAddrErrors, kn) {
					currentKey = ffj_t_IpStatistics_InAddrErrors
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffj_key_IpStatistics_InHdrErrors, kn) {
					currentKey = ffj_t_IpStatistics_InHdrErrors
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffj_key_IpStatistics_InReceives, kn) {
					currentKey = ffj_t_IpStatistics_InReceives
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.SimpleLetterEqualFold(ffj_key_IpStatistics_DefaultTTL, kn) {
					currentKey = ffj_t_IpStatistics_DefaultTTL
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.SimpleLetterEqualFold(ffj_key_IpStatistics_Forwarding, kn) {
					currentKey = ffj_t_IpStatistics_Forwarding
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				currentKey = ffj_t_IpStatisticsno_such_key
				state = fflib.FFParse_want_colon
				goto mainparse
			}

		case fflib.FFParse_want_colon:
			if tok != fflib.FFTok_colon {
				wantedTok = fflib.FFTok_colon
				goto wrongtokenerror
			}
			state = fflib.FFParse_want_value
			continue
		case fflib.FFParse_want_value:

			if tok == fflib.FFTok_left_brace || tok == fflib.FFTok_left_bracket || tok == fflib.FFTok_integer || tok == fflib.FFTok_double || tok == fflib.FFTok_string || tok == fflib.FFTok_bool || tok == fflib.FFTok_null {
				switch currentKey {

				case ffj_t_IpStatistics_Forwarding:
					goto handle_Forwarding

				case ffj_t_IpStatistics_DefaultTTL:
					goto handle_DefaultTTL

				case ffj_t_IpStatistics_InReceives:
					goto handle_InReceives

				case ffj_t_IpStatistics_InHdrErrors:
					goto handle_InHdrErrors

				case ffj_t_IpStatistics_InAddrErrors:
					goto handle_InAddrErrors

				case ffj_t_IpStatistics_ForwDatagrams:
					goto handle_ForwDatagrams

				case ffj_t_IpStatistics_InUnknownProtos:
					goto handle_InUnknownProtos

				case ffj_t_IpStatistics_InDiscards:
					goto handle_InDiscards

				case ffj_t_IpStatistics_InDelivers:
					goto handle_InDelivers

				case ffj_t_IpStatistics_OutRequests:
					goto handle_OutRequests

				case ffj_t_IpStatistics_OutDiscards:
					goto handle_OutDiscards

				case ffj_t_IpStatistics_OutNoRoutes:
					goto handle_OutNoRoutes

				case ffj_t_IpStatistics_ReasmTimeout:
					goto handle_ReasmTimeout

				case ffj_t_IpStatistics_ReasmReqds:
					goto handle_ReasmReqds

				case ffj_t_IpStatistics_ReasmOKs:
					goto handle_ReasmOKs

				case ffj_t_IpStatistics_ReasmFails:
					goto handle_ReasmFails

				case ffj_t_IpStatistics_FragOKs:
					goto handle_FragOKs

				case ffj_t_IpStatistics_FragFails:
					goto handle_FragFails

				case ffj_t_IpStatistics_FragCreates:
					goto handle_FragCreates

				case ffj_t_IpStatisticsno_such_key:
					err = fs.SkipField(tok)
					if err != nil {
						return fs.WrapErr(err)
					}
					state = fflib.FFParse_after_value
					goto mainparse
				}
			} else {
				goto wantedvalue
			}
		}
	}

handle_Forwarding:

	/* handler: uj.Forwarding type=int64 kind=int64 quoted=false*/

	{
		if tok != fflib.FFTok_integer && tok != fflib.FFTok_null {
			return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for int64", tok))
		}
	}

	{

		if tok == fflib.FFTok_null {

			uj.Forwarding = nil

		} else {

			tval, err := fflib.ParseInt(fs.Output.Bytes(), 10, 64)

			if err != nil {
				return fs.WrapErr(err)
			}

			ttypval := int64(tval)
			uj.Forwarding = &ttypval

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_DefaultTTL:

	/* handler: uj.DefaultTTL type=int64 kind=int64 quoted=false*/

	{
		if tok != fflib.FFTok_integer && tok != fflib.FFTok_null {
			return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for int64", tok))
		}
	}

	{

		if tok == fflib.FFTok_null {

			uj.DefaultTTL = nil

		} else {

			tval, err := fflib.ParseInt(fs.Output.Bytes(), 10, 64)

			if err != nil {
				return fs.WrapErr(err)
			}

			ttypval := int64(tval)
			uj.DefaultTTL = &ttypval

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_InReceives:

	/* handler: uj.InReceives type=int64 kind=int64 quoted=false*/

	{
		if tok != fflib.FFTok_integer && tok != fflib.FFTok_null {
			return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for int64", tok))
		}
	}

	{

		if tok == fflib.FFTok_null {

			uj.InReceives = nil

		} else {

			tval, err := fflib.ParseInt(fs.Output.Bytes(), 10, 64)

			if err != nil {
				return fs.WrapErr(err)
			}

			ttypval := int64(tval)
			uj.InReceives = &ttypval

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_InHdrErrors:

	/* handler: uj.InHdrErrors type=int64 kind=int64 quoted=false*/

	{
		if tok != fflib.FFTok_integer && tok != fflib.FFTok_null {
			return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for int64", tok))
		}
	}

	{

		if tok == fflib.FFTok_null {

			uj.InHdrErrors = nil

		} else {

			tval, err := fflib.ParseInt(fs.Output.Bytes(), 10, 64)

			if err != nil {
				return fs.WrapErr(err)
			}

			ttypval := int64(tval)
			uj.InHdrErrors = &ttypval

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_InAddrErrors:

	/* handler: uj.InAddrErrors type=int64 kind=int64 quoted=false*/

	{
		if tok != fflib.FFTok_integer && tok != fflib.FFTok_null {
			return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for int64", tok))
		}
	}

	{

		if tok == fflib.FFTok_null {

			uj.InAddrErrors = nil

		} else {

			tval, err := fflib.ParseInt(fs.Output.Bytes(), 10, 64)

			if err != nil {
				return fs.WrapErr(err)
			}

			ttypval := int64(tval)
			uj.InAddrErrors = &ttypval

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_ForwDatagrams:

	/* handler: uj.ForwDatagrams type=int64 kind=int64 quoted=false*/

	{
		if tok != fflib.FFTok_integer && tok != fflib.FFTok_null {
			return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for int64", tok))
		}
	}

	{

		if tok == fflib.FFTok_null {

			uj.ForwDatagrams = nil

		} else {

			tval, err := fflib.ParseInt(fs.Output.Bytes(), 10, 64)

			if err != nil {
				return fs.WrapErr(err)
			}

			ttypval := int64(tval)
			uj.ForwDatagrams = &ttypval

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_InUnknownProtos:

	/* handler: uj.InUnknownProtos type=int64 kind=int64 quoted=false*/

	{
		if tok != fflib.FFTok_integer && tok != fflib.FFTok_null {
			return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for int64", tok))
		}
	}

	{

		if tok == fflib.FFTok_null {

			uj.InUnknownProtos = nil

		} else {

			tval, err := fflib.ParseInt(fs.Output.Bytes(), 10, 64)

			if err != nil {
				return fs.WrapErr(err)
			}

			ttypval := int64(tval)
			uj.InUnknownProtos = &ttypval

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_InDiscards:

	/* handler: uj.InDiscards type=int64 kind=int64 quoted=false*/

	{
		if tok != fflib.FFTok_integer && tok != fflib.FFTok_null {
			return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for int64", tok))
		}
	}

	{

		if tok == fflib.FFTok_null {

			uj.InDiscards = nil

		} else {

			tval, err := fflib.ParseInt(fs.Output.Bytes(), 10, 64)

			if err != nil {
				return fs.WrapErr(err)
			}

			ttypval := int64(tval)
			uj.InDiscards = &ttypval

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_InDelivers:

	/* handler: uj.InDelivers type=int64 kind=int64 quoted=false*/

	{
		if tok != fflib.FFTok_integer && tok != fflib.FFTok_null {
			return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for int64", tok))
		}
	}

	{

		if tok == fflib.FFTok_null {

			uj.InDelivers = nil

		} else {

			tval, err := fflib.ParseInt(fs.Output.Bytes(), 10, 64)

			if err != nil {
				return fs.WrapErr(err)
			}

			ttypval := int64(tval)
			uj.InDelivers = &ttypval

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_OutRequests:

	/* handler: uj.OutRequests type=int64 kind=int64 quoted=false*/

	{
		if tok != fflib.FFTok_integer && tok != fflib.FFTok_null {
			return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for int64", tok))
		}
	}

	{

		if tok == fflib.FFTok_null {

			uj.OutRequests = nil

		} else {

			tval, err := fflib.ParseInt(fs.Output.Bytes(), 10, 64)

			if err != nil {
				return fs.WrapErr(err)
			}

			ttypval := int64(tval)
			uj.OutRequests = &ttypval

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_OutDiscards:

	/* handler: uj.OutDiscards type=int64 kind=int64 quoted=false*/

	{
		if tok != fflib.FFTok_integer && tok != fflib.FFTok_null {
			return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for int64", tok))
		}
	}

	{

		if tok == fflib.FFTok_null {

			uj.OutDiscards = nil

		} else {

			tval, err := fflib.ParseInt(fs.Output.Bytes(), 10, 64)

			if err != nil {
				return fs.WrapErr(err)
			}

			ttypval := int64(tval)
			uj.OutDiscards = &ttypval

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_OutNoRoutes:

	/* handler: uj.OutNoRoutes type=int64 kind=int64 quoted=false*/

	{
		if tok != fflib.FFTok_integer && tok != fflib.FFTok_null {
			return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for int64", tok))
		}
	}

	{

		if tok == fflib.FFTok_null {

			uj.OutNoRoutes = nil

		} else {

			tval, err := fflib.ParseInt(fs.Output.Bytes(), 10, 64)

			if err != nil {
				return fs.WrapErr(err)
			}

			ttypval := int64(tval)
			uj.OutNoRoutes = &ttypval

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_ReasmTimeout:

	/* handler: uj.ReasmTimeout type=int64 kind=int64 quoted=false*/

	{
		if tok != fflib.FFTok_integer && tok != fflib.FFTok_null {
			return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for int64", tok))
		}
	}

	{

		if tok == fflib.FFTok_null {

			uj.ReasmTimeout = nil

		} else {

			tval, err := fflib.ParseInt(fs.Output.Bytes(), 10, 64)

			if err != nil {
				return fs.WrapErr(err)
			}

			ttypval := int64(tval)
			uj.ReasmTimeout = &ttypval

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_ReasmReqds:

	/* handler: uj.ReasmReqds type=int64 kind=int64 quoted=false*/

	{
		if tok != fflib.FFTok_integer && tok != fflib.FFTok_null {
			return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for int64", tok))
		}
	}

	{

		if tok == fflib.FFTok_null {

			uj.ReasmReqds = nil

		} else {

			tval, err := fflib.ParseInt(fs.Output.Bytes(), 10, 64)

			if err != nil {
				return fs.WrapErr(err)
			}

			ttypval := int64(tval)
			uj.ReasmReqds = &ttypval

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_ReasmOKs:

	/* handler: uj.ReasmOKs type=int64 kind=int64 quoted=false*/

	{
		if tok != fflib.FFTok_integer && tok != fflib.FFTok_null {
			return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for int64", tok))
		}
	}

	{

		if tok == fflib.FFTok_null {

			uj.ReasmOKs = nil

		} else {

			tval, err := fflib.ParseInt(fs.Output.Bytes(), 10, 64)

			if err != nil {
				return fs.WrapErr(err)
			}

			ttypval := int64(tval)
			uj.ReasmOKs = &ttypval

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_ReasmFails:

	/* handler: uj.ReasmFails type=int64 kind=int64 quoted=false*/

	{
		if tok != fflib.FFTok_integer && tok != fflib.FFTok_null {
			return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for int64", tok))
		}
	}

	{

		if tok == fflib.FFTok_null {

			uj.ReasmFails = nil

		} else {

			tval, err := fflib.ParseInt(fs.Output.Bytes(), 10, 64)

			if err != nil {
				return fs.WrapErr(err)
			}

			ttypval := int64(tval)
			uj.ReasmFails = &ttypval

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_FragOKs:

	/* handler: uj.FragOKs type=int64 kind=int64 quoted=false*/

	{
		if tok != fflib.FFTok_integer && tok != fflib.FFTok_null {
			return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for int64", tok))
		}
	}

	{

		if tok == fflib.FFTok_null {

			uj.FragOKs = nil

		} else {

			tval, err := fflib.ParseInt(fs.Output.Bytes(), 10, 64)

			if err != nil {
				return fs.WrapErr(err)
			}

			ttypval := int64(tval)
			uj.FragOKs = &ttypval

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_FragFails:

	/* handler: uj.FragFails type=int64 kind=int64 quoted=false*/

	{
		if tok != fflib.FFTok_integer && tok != fflib.FFTok_null {
			return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for int64", tok))
		}
	}

	{

		if tok == fflib.FFTok_null {

			uj.FragFails = nil

		} else {

			tval, err := fflib.ParseInt(fs.Output.Bytes(), 10, 64)

			if err != nil {
				return fs.WrapErr(err)
			}

			ttypval := int64(tval)
			uj.FragFails = &ttypval

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_FragCreates:

	/* handler: uj.FragCreates type=int64 kind=int64 quoted=false*/

	{
		if tok != fflib.FFTok_integer && tok != fflib.FFTok_null {
			return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for int64", tok))
		}
	}

	{

		if tok == fflib.FFTok_null {

			uj.FragCreates = nil

		} else {

			tval, err := fflib.ParseInt(fs.Output.Bytes(), 10, 64)

			if err != nil {
				return fs.WrapErr(err)
			}

			ttypval := int64(tval)
			uj.FragCreates = &ttypval

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

wantedvalue:
	return fs.WrapErr(fmt.Errorf("wanted value token, but got token: %v", tok))
wrongtokenerror:
	return fs.WrapErr(fmt.Errorf("ffjson: wanted token: %v, but got token: %v output=%s", wantedTok, tok, fs.Output.String()))
tokerror:
	if fs.BigError != nil {
		return fs.WrapErr(fs.BigError)
	}
	err = fs.Error.ToError()
	if err != nil {
		return fs.WrapErr(err)
	}
	panic("ffjson-generated: unreachable, please report bug.")
done:

	return nil
}

func (mj *KillPolicy) MarshalJSON() ([]byte, error) {
	var buf fflib.Buffer
	if mj == nil {
		buf.WriteString("null")
		return buf.Bytes(), nil
	}
	err := mj.MarshalJSONBuf(&buf)
	if err != nil {
		return nil, err
	}
	return buf.Bytes(), nil
}
func (mj *KillPolicy) MarshalJSONBuf(buf fflib.EncodingBuffer) error {
	if mj == nil {
		buf.WriteString("null")
		return nil
	}
	var err error
	var obj []byte
	_ = obj
	_ = err
	buf.WriteString(`{ `)
	if mj.GracePeriod != nil {
		if true {
			buf.WriteString(`"grace_period":`)

			{

				err = mj.GracePeriod.MarshalJSONBuf(buf)
				if err != nil {
					return err
				}

			}
			buf.WriteByte(',')
		}
	}
	buf.Rewind(1)
	buf.WriteByte('}')
	return nil
}

const (
	ffj_t_KillPolicybase = iota
	ffj_t_KillPolicyno_such_key

	ffj_t_KillPolicy_GracePeriod
)

var ffj_key_KillPolicy_GracePeriod = []byte("grace_period")

func (uj *KillPolicy) UnmarshalJSON(input []byte) error {
	fs := fflib.NewFFLexer(input)
	return uj.UnmarshalJSONFFLexer(fs, fflib.FFParse_map_start)
}

func (uj *KillPolicy) UnmarshalJSONFFLexer(fs *fflib.FFLexer, state fflib.FFParseState) error {
	var err error = nil
	currentKey := ffj_t_KillPolicybase
	_ = currentKey
	tok := fflib.FFTok_init
	wantedTok := fflib.FFTok_init

mainparse:
	for {
		tok = fs.Scan()
		//	println(fmt.Sprintf("debug: tok: %v  state: %v", tok, state))
		if tok == fflib.FFTok_error {
			goto tokerror
		}

		switch state {

		case fflib.FFParse_map_start:
			if tok != fflib.FFTok_left_bracket {
				wantedTok = fflib.FFTok_left_bracket
				goto wrongtokenerror
			}
			state = fflib.FFParse_want_key
			continue

		case fflib.FFParse_after_value:
			if tok == fflib.FFTok_comma {
				state = fflib.FFParse_want_key
			} else if tok == fflib.FFTok_right_bracket {
				goto done
			} else {
				wantedTok = fflib.FFTok_comma
				goto wrongtokenerror
			}

		case fflib.FFParse_want_key:
			// json {} ended. goto exit. woo.
			if tok == fflib.FFTok_right_bracket {
				goto done
			}
			if tok != fflib.FFTok_string {
				wantedTok = fflib.FFTok_string
				goto wrongtokenerror
			}

			kn := fs.Output.Bytes()
			if len(kn) <= 0 {
				// "" case. hrm.
				currentKey = ffj_t_KillPolicyno_such_key
				state = fflib.FFParse_want_colon
				goto mainparse
			} else {
				switch kn[0] {

				case 'g':

					if bytes.Equal(ffj_key_KillPolicy_GracePeriod, kn) {
						currentKey = ffj_t_KillPolicy_GracePeriod
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				}

				if fflib.AsciiEqualFold(ffj_key_KillPolicy_GracePeriod, kn) {
					currentKey = ffj_t_KillPolicy_GracePeriod
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				currentKey = ffj_t_KillPolicyno_such_key
				state = fflib.FFParse_want_colon
				goto mainparse
			}

		case fflib.FFParse_want_colon:
			if tok != fflib.FFTok_colon {
				wantedTok = fflib.FFTok_colon
				goto wrongtokenerror
			}
			state = fflib.FFParse_want_value
			continue
		case fflib.FFParse_want_value:

			if tok == fflib.FFTok_left_brace || tok == fflib.FFTok_left_bracket || tok == fflib.FFTok_integer || tok == fflib.FFTok_double || tok == fflib.FFTok_string || tok == fflib.FFTok_bool || tok == fflib.FFTok_null {
				switch currentKey {

				case ffj_t_KillPolicy_GracePeriod:
					goto handle_GracePeriod

				case ffj_t_KillPolicyno_such_key:
					err = fs.SkipField(tok)
					if err != nil {
						return fs.WrapErr(err)
					}
					state = fflib.FFParse_after_value
					goto mainparse
				}
			} else {
				goto wantedvalue
			}
		}
	}

handle_GracePeriod:

	/* handler: uj.GracePeriod type=mesos.DurationInfo kind=struct quoted=false*/

	{
		if tok == fflib.FFTok_null {

			uj.GracePeriod = nil

			state = fflib.FFParse_after_value
			goto mainparse
		}

		if uj.GracePeriod == nil {
			uj.GracePeriod = new(DurationInfo)
		}

		err = uj.GracePeriod.UnmarshalJSONFFLexer(fs, fflib.FFParse_want_key)
		if err != nil {
			return err
		}
		state = fflib.FFParse_after_value
	}

	state = fflib.FFParse_after_value
	goto mainparse

wantedvalue:
	return fs.WrapErr(fmt.Errorf("wanted value token, but got token: %v", tok))
wrongtokenerror:
	return fs.WrapErr(fmt.Errorf("ffjson: wanted token: %v, but got token: %v output=%s", wantedTok, tok, fs.Output.String()))
tokerror:
	if fs.BigError != nil {
		return fs.WrapErr(fs.BigError)
	}
	err = fs.Error.ToError()
	if err != nil {
		return fs.WrapErr(err)
	}
	panic("ffjson-generated: unreachable, please report bug.")
done:

	return nil
}

func (mj *Label) MarshalJSON() ([]byte, error) {
	var buf fflib.Buffer
	if mj == nil {
		buf.WriteString("null")
		return buf.Bytes(), nil
	}
	err := mj.MarshalJSONBuf(&buf)
	if err != nil {
		return nil, err
	}
	return buf.Bytes(), nil
}
func (mj *Label) MarshalJSONBuf(buf fflib.EncodingBuffer) error {
	if mj == nil {
		buf.WriteString("null")
		return nil
	}
	var err error
	var obj []byte
	_ = obj
	_ = err
	buf.WriteString(`{ "key":`)
	fflib.WriteJsonString(buf, string(mj.Key))
	buf.WriteByte(',')
	if mj.Value != nil {
		if true {
			buf.WriteString(`"value":`)
			fflib.WriteJsonString(buf, string(*mj.Value))
			buf.WriteByte(',')
		}
	}
	buf.Rewind(1)
	buf.WriteByte('}')
	return nil
}

const (
	ffj_t_Labelbase = iota
	ffj_t_Labelno_such_key

	ffj_t_Label_Key

	ffj_t_Label_Value
)

var ffj_key_Label_Key = []byte("key")

var ffj_key_Label_Value = []byte("value")

func (uj *Label) UnmarshalJSON(input []byte) error {
	fs := fflib.NewFFLexer(input)
	return uj.UnmarshalJSONFFLexer(fs, fflib.FFParse_map_start)
}

func (uj *Label) UnmarshalJSONFFLexer(fs *fflib.FFLexer, state fflib.FFParseState) error {
	var err error = nil
	currentKey := ffj_t_Labelbase
	_ = currentKey
	tok := fflib.FFTok_init
	wantedTok := fflib.FFTok_init

mainparse:
	for {
		tok = fs.Scan()
		//	println(fmt.Sprintf("debug: tok: %v  state: %v", tok, state))
		if tok == fflib.FFTok_error {
			goto tokerror
		}

		switch state {

		case fflib.FFParse_map_start:
			if tok != fflib.FFTok_left_bracket {
				wantedTok = fflib.FFTok_left_bracket
				goto wrongtokenerror
			}
			state = fflib.FFParse_want_key
			continue

		case fflib.FFParse_after_value:
			if tok == fflib.FFTok_comma {
				state = fflib.FFParse_want_key
			} else if tok == fflib.FFTok_right_bracket {
				goto done
			} else {
				wantedTok = fflib.FFTok_comma
				goto wrongtokenerror
			}

		case fflib.FFParse_want_key:
			// json {} ended. goto exit. woo.
			if tok == fflib.FFTok_right_bracket {
				goto done
			}
			if tok != fflib.FFTok_string {
				wantedTok = fflib.FFTok_string
				goto wrongtokenerror
			}

			kn := fs.Output.Bytes()
			if len(kn) <= 0 {
				// "" case. hrm.
				currentKey = ffj_t_Labelno_such_key
				state = fflib.FFParse_want_colon
				goto mainparse
			} else {
				switch kn[0] {

				case 'k':

					if bytes.Equal(ffj_key_Label_Key, kn) {
						currentKey = ffj_t_Label_Key
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				case 'v':

					if bytes.Equal(ffj_key_Label_Value, kn) {
						currentKey = ffj_t_Label_Value
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				}

				if fflib.SimpleLetterEqualFold(ffj_key_Label_Value, kn) {
					currentKey = ffj_t_Label_Value
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffj_key_Label_Key, kn) {
					currentKey = ffj_t_Label_Key
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				currentKey = ffj_t_Labelno_such_key
				state = fflib.FFParse_want_colon
				goto mainparse
			}

		case fflib.FFParse_want_colon:
			if tok != fflib.FFTok_colon {
				wantedTok = fflib.FFTok_colon
				goto wrongtokenerror
			}
			state = fflib.FFParse_want_value
			continue
		case fflib.FFParse_want_value:

			if tok == fflib.FFTok_left_brace || tok == fflib.FFTok_left_bracket || tok == fflib.FFTok_integer || tok == fflib.FFTok_double || tok == fflib.FFTok_string || tok == fflib.FFTok_bool || tok == fflib.FFTok_null {
				switch currentKey {

				case ffj_t_Label_Key:
					goto handle_Key

				case ffj_t_Label_Value:
					goto handle_Value

				case ffj_t_Labelno_such_key:
					err = fs.SkipField(tok)
					if err != nil {
						return fs.WrapErr(err)
					}
					state = fflib.FFParse_after_value
					goto mainparse
				}
			} else {
				goto wantedvalue
			}
		}
	}

handle_Key:

	/* handler: uj.Key type=string kind=string quoted=false*/

	{

		{
			if tok != fflib.FFTok_string && tok != fflib.FFTok_null {
				return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for string", tok))
			}
		}

		if tok == fflib.FFTok_null {

		} else {

			outBuf := fs.Output.Bytes()

			uj.Key = string(string(outBuf))

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_Value:

	/* handler: uj.Value type=string kind=string quoted=false*/

	{

		{
			if tok != fflib.FFTok_string && tok != fflib.FFTok_null {
				return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for string", tok))
			}
		}

		if tok == fflib.FFTok_null {

			uj.Value = nil

		} else {

			var tval string
			outBuf := fs.Output.Bytes()

			tval = string(string(outBuf))
			uj.Value = &tval

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

wantedvalue:
	return fs.WrapErr(fmt.Errorf("wanted value token, but got token: %v", tok))
wrongtokenerror:
	return fs.WrapErr(fmt.Errorf("ffjson: wanted token: %v, but got token: %v output=%s", wantedTok, tok, fs.Output.String()))
tokerror:
	if fs.BigError != nil {
		return fs.WrapErr(fs.BigError)
	}
	err = fs.Error.ToError()
	if err != nil {
		return fs.WrapErr(err)
	}
	panic("ffjson-generated: unreachable, please report bug.")
done:

	return nil
}

func (mj *Labels) MarshalJSON() ([]byte, error) {
	var buf fflib.Buffer
	if mj == nil {
		buf.WriteString("null")
		return buf.Bytes(), nil
	}
	err := mj.MarshalJSONBuf(&buf)
	if err != nil {
		return nil, err
	}
	return buf.Bytes(), nil
}
func (mj *Labels) MarshalJSONBuf(buf fflib.EncodingBuffer) error {
	if mj == nil {
		buf.WriteString("null")
		return nil
	}
	var err error
	var obj []byte
	_ = obj
	_ = err
	buf.WriteString(`{"labels":`)
	if mj.Labels != nil {
		buf.WriteString(`[`)
		for i, v := range mj.Labels {
			if i != 0 {
				buf.WriteString(`,`)
			}

			{

				err = v.MarshalJSONBuf(buf)
				if err != nil {
					return err
				}

			}
		}
		buf.WriteString(`]`)
	} else {
		buf.WriteString(`null`)
	}
	buf.WriteByte('}')
	return nil
}

const (
	ffj_t_Labelsbase = iota
	ffj_t_Labelsno_such_key

	ffj_t_Labels_Labels
)

var ffj_key_Labels_Labels = []byte("labels")

func (uj *Labels) UnmarshalJSON(input []byte) error {
	fs := fflib.NewFFLexer(input)
	return uj.UnmarshalJSONFFLexer(fs, fflib.FFParse_map_start)
}

func (uj *Labels) UnmarshalJSONFFLexer(fs *fflib.FFLexer, state fflib.FFParseState) error {
	var err error = nil
	currentKey := ffj_t_Labelsbase
	_ = currentKey
	tok := fflib.FFTok_init
	wantedTok := fflib.FFTok_init

mainparse:
	for {
		tok = fs.Scan()
		//	println(fmt.Sprintf("debug: tok: %v  state: %v", tok, state))
		if tok == fflib.FFTok_error {
			goto tokerror
		}

		switch state {

		case fflib.FFParse_map_start:
			if tok != fflib.FFTok_left_bracket {
				wantedTok = fflib.FFTok_left_bracket
				goto wrongtokenerror
			}
			state = fflib.FFParse_want_key
			continue

		case fflib.FFParse_after_value:
			if tok == fflib.FFTok_comma {
				state = fflib.FFParse_want_key
			} else if tok == fflib.FFTok_right_bracket {
				goto done
			} else {
				wantedTok = fflib.FFTok_comma
				goto wrongtokenerror
			}

		case fflib.FFParse_want_key:
			// json {} ended. goto exit. woo.
			if tok == fflib.FFTok_right_bracket {
				goto done
			}
			if tok != fflib.FFTok_string {
				wantedTok = fflib.FFTok_string
				goto wrongtokenerror
			}

			kn := fs.Output.Bytes()
			if len(kn) <= 0 {
				// "" case. hrm.
				currentKey = ffj_t_Labelsno_such_key
				state = fflib.FFParse_want_colon
				goto mainparse
			} else {
				switch kn[0] {

				case 'l':

					if bytes.Equal(ffj_key_Labels_Labels, kn) {
						currentKey = ffj_t_Labels_Labels
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				}

				if fflib.EqualFoldRight(ffj_key_Labels_Labels, kn) {
					currentKey = ffj_t_Labels_Labels
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				currentKey = ffj_t_Labelsno_such_key
				state = fflib.FFParse_want_colon
				goto mainparse
			}

		case fflib.FFParse_want_colon:
			if tok != fflib.FFTok_colon {
				wantedTok = fflib.FFTok_colon
				goto wrongtokenerror
			}
			state = fflib.FFParse_want_value
			continue
		case fflib.FFParse_want_value:

			if tok == fflib.FFTok_left_brace || tok == fflib.FFTok_left_bracket || tok == fflib.FFTok_integer || tok == fflib.FFTok_double || tok == fflib.FFTok_string || tok == fflib.FFTok_bool || tok == fflib.FFTok_null {
				switch currentKey {

				case ffj_t_Labels_Labels:
					goto handle_Labels

				case ffj_t_Labelsno_such_key:
					err = fs.SkipField(tok)
					if err != nil {
						return fs.WrapErr(err)
					}
					state = fflib.FFParse_after_value
					goto mainparse
				}
			} else {
				goto wantedvalue
			}
		}
	}

handle_Labels:

	/* handler: uj.Labels type=[]mesos.Label kind=slice quoted=false*/

	{

		{
			if tok != fflib.FFTok_left_brace && tok != fflib.FFTok_null {
				return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for ", tok))
			}
		}

		if tok == fflib.FFTok_null {
			uj.Labels = nil
		} else {

			uj.Labels = []Label{}

			wantVal := true

			for {

				var tmp_uj__Labels Label

				tok = fs.Scan()
				if tok == fflib.FFTok_error {
					goto tokerror
				}
				if tok == fflib.FFTok_right_brace {
					break
				}

				if tok == fflib.FFTok_comma {
					if wantVal == true {
						// TODO(pquerna): this isn't an ideal error message, this handles
						// things like [,,,] as an array value.
						return fs.WrapErr(fmt.Errorf("wanted value token, but got token: %v", tok))
					}
					continue
				} else {
					wantVal = true
				}

				/* handler: tmp_uj__Labels type=mesos.Label kind=struct quoted=false*/

				{
					if tok == fflib.FFTok_null {

						state = fflib.FFParse_after_value
						goto mainparse
					}

					err = tmp_uj__Labels.UnmarshalJSONFFLexer(fs, fflib.FFParse_want_key)
					if err != nil {
						return err
					}
					state = fflib.FFParse_after_value
				}

				uj.Labels = append(uj.Labels, tmp_uj__Labels)

				wantVal = false
			}
		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

wantedvalue:
	return fs.WrapErr(fmt.Errorf("wanted value token, but got token: %v", tok))
wrongtokenerror:
	return fs.WrapErr(fmt.Errorf("ffjson: wanted token: %v, but got token: %v output=%s", wantedTok, tok, fs.Output.String()))
tokerror:
	if fs.BigError != nil {
		return fs.WrapErr(fs.BigError)
	}
	err = fs.Error.ToError()
	if err != nil {
		return fs.WrapErr(err)
	}
	panic("ffjson-generated: unreachable, please report bug.")
done:

	return nil
}

func (mj *LinuxInfo) MarshalJSON() ([]byte, error) {
	var buf fflib.Buffer
	if mj == nil {
		buf.WriteString("null")
		return buf.Bytes(), nil
	}
	err := mj.MarshalJSONBuf(&buf)
	if err != nil {
		return nil, err
	}
	return buf.Bytes(), nil
}
func (mj *LinuxInfo) MarshalJSONBuf(buf fflib.EncodingBuffer) error {
	if mj == nil {
		buf.WriteString("null")
		return nil
	}
	var err error
	var obj []byte
	_ = obj
	_ = err
	buf.WriteString(`{ `)
	if mj.CapabilityInfo != nil {
		if true {
			buf.WriteString(`"capability_info":`)

			{

				err = mj.CapabilityInfo.MarshalJSONBuf(buf)
				if err != nil {
					return err
				}

			}
			buf.WriteByte(',')
		}
	}
	if mj.BoundingCapabilities != nil {
		if true {
			buf.WriteString(`"bounding_capabilities":`)

			{

				err = mj.BoundingCapabilities.MarshalJSONBuf(buf)
				if err != nil {
					return err
				}

			}
			buf.WriteByte(',')
		}
	}
	if mj.EffectiveCapabilities != nil {
		if true {
			buf.WriteString(`"effective_capabilities":`)

			{

				err = mj.EffectiveCapabilities.MarshalJSONBuf(buf)
				if err != nil {
					return err
				}

			}
			buf.WriteByte(',')
		}
	}
	if mj.SharePIDNamespace != nil {
		if true {
			if *mj.SharePIDNamespace {
				buf.WriteString(`"share_pid_namespace":true`)
			} else {
				buf.WriteString(`"share_pid_namespace":false`)
			}
			buf.WriteByte(',')
		}
	}
	if mj.Seccomp != nil {
		if true {
			buf.WriteString(`"seccomp":`)

			{

				err = mj.Seccomp.MarshalJSONBuf(buf)
				if err != nil {
					return err
				}

			}
			buf.WriteByte(',')
		}
	}
	if mj.IPCMode != nil {
		if true {
			buf.WriteString(`"ipc_mode":`)

			{

				obj, err = mj.IPCMode.MarshalJSON()
				if err != nil {
					return err
				}
				buf.Write(obj)

			}
			buf.WriteByte(',')
		}
	}
	if mj.SHMSize != nil {
		if true {
			buf.WriteString(`"shm_size":`)
			fflib.FormatBits2(buf, uint64(*mj.SHMSize), 10, false)
			buf.WriteByte(',')
		}
	}
	if mj.ShareCgroups != nil {
		if true {
			if *mj.ShareCgroups {
				buf.WriteString(`"share_cgroups":true`)
			} else {
				buf.WriteString(`"share_cgroups":false`)
			}
			buf.WriteByte(',')
		}
	}
	buf.Rewind(1)
	buf.WriteByte('}')
	return nil
}

const (
	ffj_t_LinuxInfobase = iota
	ffj_t_LinuxInfono_such_key

	ffj_t_LinuxInfo_CapabilityInfo

	ffj_t_LinuxInfo_BoundingCapabilities

	ffj_t_LinuxInfo_EffectiveCapabilities

	ffj_t_LinuxInfo_SharePIDNamespace

	ffj_t_LinuxInfo_Seccomp

	ffj_t_LinuxInfo_IPCMode

	ffj_t_LinuxInfo_SHMSize

	ffj_t_LinuxInfo_ShareCgroups
)

var ffj_key_LinuxInfo_CapabilityInfo = []byte("capability_info")

var ffj_key_LinuxInfo_BoundingCapabilities = []byte("bounding_capabilities")

var ffj_key_LinuxInfo_EffectiveCapabilities = []byte("effective_capabilities")

var ffj_key_LinuxInfo_SharePIDNamespace = []byte("share_pid_namespace")

var ffj_key_LinuxInfo_Seccomp = []byte("seccomp")

var ffj_key_LinuxInfo_IPCMode = []byte("ipc_mode")

var ffj_key_LinuxInfo_SHMSize = []byte("shm_size")

var ffj_key_LinuxInfo_ShareCgroups = []byte("share_cgroups")

func (uj *LinuxInfo) UnmarshalJSON(input []byte) error {
	fs := fflib.NewFFLexer(input)
	return uj.UnmarshalJSONFFLexer(fs, fflib.FFParse_map_start)
}

func (uj *LinuxInfo) UnmarshalJSONFFLexer(fs *fflib.FFLexer, state fflib.FFParseState) error {
	var err error = nil
	currentKey := ffj_t_LinuxInfobase
	_ = currentKey
	tok := fflib.FFTok_init
	wantedTok := fflib.FFTok_init

mainparse:
	for {
		tok = fs.Scan()
		//	println(fmt.Sprintf("debug: tok: %v  state: %v", tok, state))
		if tok == fflib.FFTok_error {
			goto tokerror
		}

		switch state {

		case fflib.FFParse_map_start:
			if tok != fflib.FFTok_left_bracket {
				wantedTok = fflib.FFTok_left_bracket
				goto wrongtokenerror
			}
			state = fflib.FFParse_want_key
			continue

		case fflib.FFParse_after_value:
			if tok == fflib.FFTok_comma {
				state = fflib.FFParse_want_key
			} else if tok == fflib.FFTok_right_bracket {
				goto done
			} else {
				wantedTok = fflib.FFTok_comma
				goto wrongtokenerror
			}

		case fflib.FFParse_want_key:
			// json {} ended. goto exit. woo.
			if tok == fflib.FFTok_right_bracket {
				goto done
			}
			if tok != fflib.FFTok_string {
				wantedTok = fflib.FFTok_string
				goto wrongtokenerror
			}

			kn := fs.Output.Bytes()
			if len(kn) <= 0 {
				// "" case. hrm.
				currentKey = ffj_t_LinuxInfono_such_key
				state = fflib.FFParse_want_colon
				goto mainparse
			} else {
				switch kn[0] {

				case 'b':

					if bytes.Equal(ffj_key_LinuxInfo_BoundingCapabilities, kn) {
						currentKey = ffj_t_LinuxInfo_BoundingCapabilities
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				case 'c':

					if bytes.Equal(ffj_key_LinuxInfo_CapabilityInfo, kn) {
						currentKey = ffj_t_LinuxInfo_CapabilityInfo
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				case 'e':

					if bytes.Equal(ffj_key_LinuxInfo_EffectiveCapabilities, kn) {
						currentKey = ffj_t_LinuxInfo_EffectiveCapabilities
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				case 'i':

					if bytes.Equal(ffj_key_LinuxInfo_IPCMode, kn) {
						currentKey = ffj_t_LinuxInfo_IPCMode
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				case 's':

					if bytes.Equal(ffj_key_LinuxInfo_SharePIDNamespace, kn) {
						currentKey = ffj_t_LinuxInfo_SharePIDNamespace
						state = fflib.FFParse_want_colon
						goto mainparse

					} else if bytes.Equal(ffj_key_LinuxInfo_Seccomp, kn) {
						currentKey = ffj_t_LinuxInfo_Seccomp
						state = fflib.FFParse_want_colon
						goto mainparse

					} else if bytes.Equal(ffj_key_LinuxInfo_SHMSize, kn) {
						currentKey = ffj_t_LinuxInfo_SHMSize
						state = fflib.FFParse_want_colon
						goto mainparse

					} else if bytes.Equal(ffj_key_LinuxInfo_ShareCgroups, kn) {
						currentKey = ffj_t_LinuxInfo_ShareCgroups
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				}

				if fflib.EqualFoldRight(ffj_key_LinuxInfo_ShareCgroups, kn) {
					currentKey = ffj_t_LinuxInfo_ShareCgroups
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffj_key_LinuxInfo_SHMSize, kn) {
					currentKey = ffj_t_LinuxInfo_SHMSize
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.AsciiEqualFold(ffj_key_LinuxInfo_IPCMode, kn) {
					currentKey = ffj_t_LinuxInfo_IPCMode
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffj_key_LinuxInfo_Seccomp, kn) {
					currentKey = ffj_t_LinuxInfo_Seccomp
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffj_key_LinuxInfo_SharePIDNamespace, kn) {
					currentKey = ffj_t_LinuxInfo_SharePIDNamespace
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffj_key_LinuxInfo_EffectiveCapabilities, kn) {
					currentKey = ffj_t_LinuxInfo_EffectiveCapabilities
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffj_key_LinuxInfo_BoundingCapabilities, kn) {
					currentKey = ffj_t_LinuxInfo_BoundingCapabilities
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.AsciiEqualFold(ffj_key_LinuxInfo_CapabilityInfo, kn) {
					currentKey = ffj_t_LinuxInfo_CapabilityInfo
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				currentKey = ffj_t_LinuxInfono_such_key
				state = fflib.FFParse_want_colon
				goto mainparse
			}

		case fflib.FFParse_want_colon:
			if tok != fflib.FFTok_colon {
				wantedTok = fflib.FFTok_colon
				goto wrongtokenerror
			}
			state = fflib.FFParse_want_value
			continue
		case fflib.FFParse_want_value:

			if tok == fflib.FFTok_left_brace || tok == fflib.FFTok_left_bracket || tok == fflib.FFTok_integer || tok == fflib.FFTok_double || tok == fflib.FFTok_string || tok == fflib.FFTok_bool || tok == fflib.FFTok_null {
				switch currentKey {

				case ffj_t_LinuxInfo_CapabilityInfo:
					goto handle_CapabilityInfo

				case ffj_t_LinuxInfo_BoundingCapabilities:
					goto handle_BoundingCapabilities

				case ffj_t_LinuxInfo_EffectiveCapabilities:
					goto handle_EffectiveCapabilities

				case ffj_t_LinuxInfo_SharePIDNamespace:
					goto handle_SharePIDNamespace

				case ffj_t_LinuxInfo_Seccomp:
					goto handle_Seccomp

				case ffj_t_LinuxInfo_IPCMode:
					goto handle_IPCMode

				case ffj_t_LinuxInfo_SHMSize:
					goto handle_SHMSize

				case ffj_t_LinuxInfo_ShareCgroups:
					goto handle_ShareCgroups

				case ffj_t_LinuxInfono_such_key:
					err = fs.SkipField(tok)
					if err != nil {
						return fs.WrapErr(err)
					}
					state = fflib.FFParse_after_value
					goto mainparse
				}
			} else {
				goto wantedvalue
			}
		}
	}

handle_CapabilityInfo:

	/* handler: uj.CapabilityInfo type=mesos.CapabilityInfo kind=struct quoted=false*/

	{
		if tok == fflib.FFTok_null {

			uj.CapabilityInfo = nil

			state = fflib.FFParse_after_value
			goto mainparse
		}

		if uj.CapabilityInfo == nil {
			uj.CapabilityInfo = new(CapabilityInfo)
		}

		err = uj.CapabilityInfo.UnmarshalJSONFFLexer(fs, fflib.FFParse_want_key)
		if err != nil {
			return err
		}
		state = fflib.FFParse_after_value
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_BoundingCapabilities:

	/* handler: uj.BoundingCapabilities type=mesos.CapabilityInfo kind=struct quoted=false*/

	{
		if tok == fflib.FFTok_null {

			uj.BoundingCapabilities = nil

			state = fflib.FFParse_after_value
			goto mainparse
		}

		if uj.BoundingCapabilities == nil {
			uj.BoundingCapabilities = new(CapabilityInfo)
		}

		err = uj.BoundingCapabilities.UnmarshalJSONFFLexer(fs, fflib.FFParse_want_key)
		if err != nil {
			return err
		}
		state = fflib.FFParse_after_value
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_EffectiveCapabilities:

	/* handler: uj.EffectiveCapabilities type=mesos.CapabilityInfo kind=struct quoted=false*/

	{
		if tok == fflib.FFTok_null {

			uj.EffectiveCapabilities = nil

			state = fflib.FFParse_after_value
			goto mainparse
		}

		if uj.EffectiveCapabilities == nil {
			uj.EffectiveCapabilities = new(CapabilityInfo)
		}

		err = uj.EffectiveCapabilities.UnmarshalJSONFFLexer(fs, fflib.FFParse_want_key)
		if err != nil {
			return err
		}
		state = fflib.FFParse_after_value
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_SharePIDNamespace:

	/* handler: uj.SharePIDNamespace type=bool kind=bool quoted=false*/

	{
		if tok != fflib.FFTok_bool && tok != fflib.FFTok_null {
			return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for bool", tok))
		}
	}

	{
		if tok == fflib.FFTok_null {

			uj.SharePIDNamespace = nil

		} else {
			tmpb := fs.Output.Bytes()

			var tval bool

			if bytes.Compare([]byte{'t', 'r', 'u', 'e'}, tmpb) == 0 {

				tval = true

			} else if bytes.Compare([]byte{'f', 'a', 'l', 's', 'e'}, tmpb) == 0 {

				tval = false

			} else {
				err = errors.New("unexpected bytes for true/false value")
				return fs.WrapErr(err)
			}

			uj.SharePIDNamespace = &tval

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_Seccomp:

	/* handler: uj.Seccomp type=mesos.SeccompInfo kind=struct quoted=false*/

	{
		if tok == fflib.FFTok_null {

			uj.Seccomp = nil

			state = fflib.FFParse_after_value
			goto mainparse
		}

		if uj.Seccomp == nil {
			uj.Seccomp = new(SeccompInfo)
		}

		err = uj.Seccomp.UnmarshalJSONFFLexer(fs, fflib.FFParse_want_key)
		if err != nil {
			return err
		}
		state = fflib.FFParse_after_value
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_IPCMode:

	/* handler: uj.IPCMode type=mesos.LinuxInfo_IpcMode kind=int32 quoted=false*/

	{
		if tok == fflib.FFTok_null {

			uj.IPCMode = nil

			state = fflib.FFParse_after_value
			goto mainparse
		}

		tbuf, err := fs.CaptureField(tok)
		if err != nil {
			return fs.WrapErr(err)
		}

		if uj.IPCMode == nil {
			uj.IPCMode = new(LinuxInfo_IpcMode)
		}

		err = uj.IPCMode.UnmarshalJSON(tbuf)
		if err != nil {
			return fs.WrapErr(err)
		}
		state = fflib.FFParse_after_value
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_SHMSize:

	/* handler: uj.SHMSize type=uint32 kind=uint32 quoted=false*/

	{
		if tok != fflib.FFTok_integer && tok != fflib.FFTok_null {
			return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for uint32", tok))
		}
	}

	{

		if tok == fflib.FFTok_null {

			uj.SHMSize = nil

		} else {

			tval, err := fflib.ParseUint(fs.Output.Bytes(), 10, 32)

			if err != nil {
				return fs.WrapErr(err)
			}

			ttypval := uint32(tval)
			uj.SHMSize = &ttypval

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_ShareCgroups:

	/* handler: uj.ShareCgroups type=bool kind=bool quoted=false*/

	{
		if tok != fflib.FFTok_bool && tok != fflib.FFTok_null {
			return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for bool", tok))
		}
	}

	{
		if tok == fflib.FFTok_null {

			uj.ShareCgroups = nil

		} else {
			tmpb := fs.Output.Bytes()

			var tval bool

			if bytes.Compare([]byte{'t', 'r', 'u', 'e'}, tmpb) == 0 {

				tval = true

			} else if bytes.Compare([]byte{'f', 'a', 'l', 's', 'e'}, tmpb) == 0 {

				tval = false

			} else {
				err = errors.New("unexpected bytes for true/false value")
				return fs.WrapErr(err)
			}

			uj.ShareCgroups = &tval

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

wantedvalue:
	return fs.WrapErr(fmt.Errorf("wanted value token, but got token: %v", tok))
wrongtokenerror:
	return fs.WrapErr(fmt.Errorf("ffjson: wanted token: %v, but got token: %v output=%s", wantedTok, tok, fs.Output.String()))
tokerror:
	if fs.BigError != nil {
		return fs.WrapErr(fs.BigError)
	}
	err = fs.Error.ToError()
	if err != nil {
		return fs.WrapErr(err)
	}
	panic("ffjson-generated: unreachable, please report bug.")
done:

	return nil
}

func (mj *MachineID) MarshalJSON() ([]byte, error) {
	var buf fflib.Buffer
	if mj == nil {
		buf.WriteString("null")
		return buf.Bytes(), nil
	}
	err := mj.MarshalJSONBuf(&buf)
	if err != nil {
		return nil, err
	}
	return buf.Bytes(), nil
}
func (mj *MachineID) MarshalJSONBuf(buf fflib.EncodingBuffer) error {
	if mj == nil {
		buf.WriteString("null")
		return nil
	}
	var err error
	var obj []byte
	_ = obj
	_ = err
	buf.WriteString(`{ `)
	if mj.Hostname != nil {
		if true {
			buf.WriteString(`"hostname":`)
			fflib.WriteJsonString(buf, string(*mj.Hostname))
			buf.WriteByte(',')
		}
	}
	if mj.IP != nil {
		if true {
			buf.WriteString(`"ip":`)
			fflib.WriteJsonString(buf, string(*mj.IP))
			buf.WriteByte(',')
		}
	}
	buf.Rewind(1)
	buf.WriteByte('}')
	return nil
}

const (
	ffj_t_MachineIDbase = iota
	ffj_t_MachineIDno_such_key

	ffj_t_MachineID_Hostname

	ffj_t_MachineID_IP
)

var ffj_key_MachineID_Hostname = []byte("hostname")

var ffj_key_MachineID_IP = []byte("ip")

func (uj *MachineID) UnmarshalJSON(input []byte) error {
	fs := fflib.NewFFLexer(input)
	return uj.UnmarshalJSONFFLexer(fs, fflib.FFParse_map_start)
}

func (uj *MachineID) UnmarshalJSONFFLexer(fs *fflib.FFLexer, state fflib.FFParseState) error {
	var err error = nil
	currentKey := ffj_t_MachineIDbase
	_ = currentKey
	tok := fflib.FFTok_init
	wantedTok := fflib.FFTok_init

mainparse:
	for {
		tok = fs.Scan()
		//	println(fmt.Sprintf("debug: tok: %v  state: %v", tok, state))
		if tok == fflib.FFTok_error {
			goto tokerror
		}

		switch state {

		case fflib.FFParse_map_start:
			if tok != fflib.FFTok_left_bracket {
				wantedTok = fflib.FFTok_left_bracket
				goto wrongtokenerror
			}
			state = fflib.FFParse_want_key
			continue

		case fflib.FFParse_after_value:
			if tok == fflib.FFTok_comma {
				state = fflib.FFParse_want_key
			} else if tok == fflib.FFTok_right_bracket {
				goto done
			} else {
				wantedTok = fflib.FFTok_comma
				goto wrongtokenerror
			}

		case fflib.FFParse_want_key:
			// json {} ended. goto exit. woo.
			if tok == fflib.FFTok_right_bracket {
				goto done
			}
			if tok != fflib.FFTok_string {
				wantedTok = fflib.FFTok_string
				goto wrongtokenerror
			}

			kn := fs.Output.Bytes()
			if len(kn) <= 0 {
				// "" case. hrm.
				currentKey = ffj_t_MachineIDno_such_key
				state = fflib.FFParse_want_colon
				goto mainparse
			} else {
				switch kn[0] {

				case 'h':

					if bytes.Equal(ffj_key_MachineID_Hostname, kn) {
						currentKey = ffj_t_MachineID_Hostname
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				case 'i':

					if bytes.Equal(ffj_key_MachineID_IP, kn) {
						currentKey = ffj_t_MachineID_IP
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				}

				if fflib.SimpleLetterEqualFold(ffj_key_MachineID_IP, kn) {
					currentKey = ffj_t_MachineID_IP
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffj_key_MachineID_Hostname, kn) {
					currentKey = ffj_t_MachineID_Hostname
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				currentKey = ffj_t_MachineIDno_such_key
				state = fflib.FFParse_want_colon
				goto mainparse
			}

		case fflib.FFParse_want_colon:
			if tok != fflib.FFTok_colon {
				wantedTok = fflib.FFTok_colon
				goto wrongtokenerror
			}
			state = fflib.FFParse_want_value
			continue
		case fflib.FFParse_want_value:

			if tok == fflib.FFTok_left_brace || tok == fflib.FFTok_left_bracket || tok == fflib.FFTok_integer || tok == fflib.FFTok_double || tok == fflib.FFTok_string || tok == fflib.FFTok_bool || tok == fflib.FFTok_null {
				switch currentKey {

				case ffj_t_MachineID_Hostname:
					goto handle_Hostname

				case ffj_t_MachineID_IP:
					goto handle_IP

				case ffj_t_MachineIDno_such_key:
					err = fs.SkipField(tok)
					if err != nil {
						return fs.WrapErr(err)
					}
					state = fflib.FFParse_after_value
					goto mainparse
				}
			} else {
				goto wantedvalue
			}
		}
	}

handle_Hostname:

	/* handler: uj.Hostname type=string kind=string quoted=false*/

	{

		{
			if tok != fflib.FFTok_string && tok != fflib.FFTok_null {
				return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for string", tok))
			}
		}

		if tok == fflib.FFTok_null {

			uj.Hostname = nil

		} else {

			var tval string
			outBuf := fs.Output.Bytes()

			tval = string(string(outBuf))
			uj.Hostname = &tval

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_IP:

	/* handler: uj.IP type=string kind=string quoted=false*/

	{

		{
			if tok != fflib.FFTok_string && tok != fflib.FFTok_null {
				return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for string", tok))
			}
		}

		if tok == fflib.FFTok_null {

			uj.IP = nil

		} else {

			var tval string
			outBuf := fs.Output.Bytes()

			tval = string(string(outBuf))
			uj.IP = &tval

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

wantedvalue:
	return fs.WrapErr(fmt.Errorf("wanted value token, but got token: %v", tok))
wrongtokenerror:
	return fs.WrapErr(fmt.Errorf("ffjson: wanted token: %v, but got token: %v output=%s", wantedTok, tok, fs.Output.String()))
tokerror:
	if fs.BigError != nil {
		return fs.WrapErr(fs.BigError)
	}
	err = fs.Error.ToError()
	if err != nil {
		return fs.WrapErr(err)
	}
	panic("ffjson-generated: unreachable, please report bug.")
done:

	return nil
}

func (mj *MachineInfo) MarshalJSON() ([]byte, error) {
	var buf fflib.Buffer
	if mj == nil {
		buf.WriteString("null")
		return buf.Bytes(), nil
	}
	err := mj.MarshalJSONBuf(&buf)
	if err != nil {
		return nil, err
	}
	return buf.Bytes(), nil
}
func (mj *MachineInfo) MarshalJSONBuf(buf fflib.EncodingBuffer) error {
	if mj == nil {
		buf.WriteString("null")
		return nil
	}
	var err error
	var obj []byte
	_ = obj
	_ = err
	buf.WriteString(`{ "id":`)

	{

		err = mj.ID.MarshalJSONBuf(buf)
		if err != nil {
			return err
		}

	}
	buf.WriteByte(',')
	if mj.Mode != nil {
		if true {
			buf.WriteString(`"mode":`)

			{

				obj, err = mj.Mode.MarshalJSON()
				if err != nil {
					return err
				}
				buf.Write(obj)

			}
			buf.WriteByte(',')
		}
	}
	if mj.Unavailability != nil {
		if true {
			buf.WriteString(`"unavailability":`)

			{

				err = mj.Unavailability.MarshalJSONBuf(buf)
				if err != nil {
					return err
				}

			}
			buf.WriteByte(',')
		}
	}
	buf.Rewind(1)
	buf.WriteByte('}')
	return nil
}

const (
	ffj_t_MachineInfobase = iota
	ffj_t_MachineInfono_such_key

	ffj_t_MachineInfo_ID

	ffj_t_MachineInfo_Mode

	ffj_t_MachineInfo_Unavailability
)

var ffj_key_MachineInfo_ID = []byte("id")

var ffj_key_MachineInfo_Mode = []byte("mode")

var ffj_key_MachineInfo_Unavailability = []byte("unavailability")

func (uj *MachineInfo) UnmarshalJSON(input []byte) error {
	fs := fflib.NewFFLexer(input)
	return uj.UnmarshalJSONFFLexer(fs, fflib.FFParse_map_start)
}

func (uj *MachineInfo) UnmarshalJSONFFLexer(fs *fflib.FFLexer, state fflib.FFParseState) error {
	var err error = nil
	currentKey := ffj_t_MachineInfobase
	_ = currentKey
	tok := fflib.FFTok_init
	wantedTok := fflib.FFTok_init

mainparse:
	for {
		tok = fs.Scan()
		//	println(fmt.Sprintf("debug: tok: %v  state: %v", tok, state))
		if tok == fflib.FFTok_error {
			goto tokerror
		}

		switch state {

		case fflib.FFParse_map_start:
			if tok != fflib.FFTok_left_bracket {
				wantedTok = fflib.FFTok_left_bracket
				goto wrongtokenerror
			}
			state = fflib.FFParse_want_key
			continue

		case fflib.FFParse_after_value:
			if tok == fflib.FFTok_comma {
				state = fflib.FFParse_want_key
			} else if tok == fflib.FFTok_right_bracket {
				goto done
			} else {
				wantedTok = fflib.FFTok_comma
				goto wrongtokenerror
			}

		case fflib.FFParse_want_key:
			// json {} ended. goto exit. woo.
			if tok == fflib.FFTok_right_bracket {
				goto done
			}
			if tok != fflib.FFTok_string {
				wantedTok = fflib.FFTok_string
				goto wrongtokenerror
			}

			kn := fs.Output.Bytes()
			if len(kn) <= 0 {
				// "" case. hrm.
				currentKey = ffj_t_MachineInfono_such_key
				state = fflib.FFParse_want_colon
				goto mainparse
			} else {
				switch kn[0] {

				case 'i':

					if bytes.Equal(ffj_key_MachineInfo_ID, kn) {
						currentKey = ffj_t_MachineInfo_ID
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				case 'm':

					if bytes.Equal(ffj_key_MachineInfo_Mode, kn) {
						currentKey = ffj_t_MachineInfo_Mode
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				case 'u':

					if bytes.Equal(ffj_key_MachineInfo_Unavailability, kn) {
						currentKey = ffj_t_MachineInfo_Unavailability
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				}

				if fflib.SimpleLetterEqualFold(ffj_key_MachineInfo_Unavailability, kn) {
					currentKey = ffj_t_MachineInfo_Unavailability
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.SimpleLetterEqualFold(ffj_key_MachineInfo_Mode, kn) {
					currentKey = ffj_t_MachineInfo_Mode
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.SimpleLetterEqualFold(ffj_key_MachineInfo_ID, kn) {
					currentKey = ffj_t_MachineInfo_ID
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				currentKey = ffj_t_MachineInfono_such_key
				state = fflib.FFParse_want_colon
				goto mainparse
			}

		case fflib.FFParse_want_colon:
			if tok != fflib.FFTok_colon {
				wantedTok = fflib.FFTok_colon
				goto wrongtokenerror
			}
			state = fflib.FFParse_want_value
			continue
		case fflib.FFParse_want_value:

			if tok == fflib.FFTok_left_brace || tok == fflib.FFTok_left_bracket || tok == fflib.FFTok_integer || tok == fflib.FFTok_double || tok == fflib.FFTok_string || tok == fflib.FFTok_bool || tok == fflib.FFTok_null {
				switch currentKey {

				case ffj_t_MachineInfo_ID:
					goto handle_ID

				case ffj_t_MachineInfo_Mode:
					goto handle_Mode

				case ffj_t_MachineInfo_Unavailability:
					goto handle_Unavailability

				case ffj_t_MachineInfono_such_key:
					err = fs.SkipField(tok)
					if err != nil {
						return fs.WrapErr(err)
					}
					state = fflib.FFParse_after_value
					goto mainparse
				}
			} else {
				goto wantedvalue
			}
		}
	}

handle_ID:

	/* handler: uj.ID type=mesos.MachineID kind=struct quoted=false*/

	{
		if tok == fflib.FFTok_null {

			state = fflib.FFParse_after_value
			goto mainparse
		}

		err = uj.ID.UnmarshalJSONFFLexer(fs, fflib.FFParse_want_key)
		if err != nil {
			return err
		}
		state = fflib.FFParse_after_value
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_Mode:

	/* handler: uj.Mode type=mesos.MachineInfo_Mode kind=int32 quoted=false*/

	{
		if tok == fflib.FFTok_null {

			uj.Mode = nil

			state = fflib.FFParse_after_value
			goto mainparse
		}

		tbuf, err := fs.CaptureField(tok)
		if err != nil {
			return fs.WrapErr(err)
		}

		if uj.Mode == nil {
			uj.Mode = new(MachineInfo_Mode)
		}

		err = uj.Mode.UnmarshalJSON(tbuf)
		if err != nil {
			return fs.WrapErr(err)
		}
		state = fflib.FFParse_after_value
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_Unavailability:

	/* handler: uj.Unavailability type=mesos.Unavailability kind=struct quoted=false*/

	{
		if tok == fflib.FFTok_null {

			uj.Unavailability = nil

			state = fflib.FFParse_after_value
			goto mainparse
		}

		if uj.Unavailability == nil {
			uj.Unavailability = new(Unavailability)
		}

		err = uj.Unavailability.UnmarshalJSONFFLexer(fs, fflib.FFParse_want_key)
		if err != nil {
			return err
		}
		state = fflib.FFParse_after_value
	}

	state = fflib.FFParse_after_value
	goto mainparse

wantedvalue:
	return fs.WrapErr(fmt.Errorf("wanted value token, but got token: %v", tok))
wrongtokenerror:
	return fs.WrapErr(fmt.Errorf("ffjson: wanted token: %v, but got token: %v output=%s", wantedTok, tok, fs.Output.String()))
tokerror:
	if fs.BigError != nil {
		return fs.WrapErr(fs.BigError)
	}
	err = fs.Error.ToError()
	if err != nil {
		return fs.WrapErr(err)
	}
	panic("ffjson-generated: unreachable, please report bug.")
done:

	return nil
}

func (mj *MasterInfo) MarshalJSON() ([]byte, error) {
	var buf fflib.Buffer
	if mj == nil {
		buf.WriteString("null")
		return buf.Bytes(), nil
	}
	err := mj.MarshalJSONBuf(&buf)
	if err != nil {
		return nil, err
	}
	return buf.Bytes(), nil
}
func (mj *MasterInfo) MarshalJSONBuf(buf fflib.EncodingBuffer) error {
	if mj == nil {
		buf.WriteString("null")
		return nil
	}
	var err error
	var obj []byte
	_ = obj
	_ = err
	buf.WriteString(`{"id":`)
	fflib.WriteJsonString(buf, string(mj.ID))
	buf.WriteString(`,"ip":`)
	fflib.FormatBits2(buf, uint64(mj.IP), 10, false)
	buf.WriteByte(',')
	if mj.Port != nil {
		if true {
			buf.WriteString(`"port":`)
			fflib.FormatBits2(buf, uint64(*mj.Port), 10, false)
			buf.WriteByte(',')
		}
	}
	if mj.PID != nil {
		if true {
			buf.WriteString(`"pid":`)
			fflib.WriteJsonString(buf, string(*mj.PID))
			buf.WriteByte(',')
		}
	}
	if mj.Hostname != nil {
		if true {
			buf.WriteString(`"hostname":`)
			fflib.WriteJsonString(buf, string(*mj.Hostname))
			buf.WriteByte(',')
		}
	}
	if mj.Version != nil {
		if true {
			buf.WriteString(`"version":`)
			fflib.WriteJsonString(buf, string(*mj.Version))
			buf.WriteByte(',')
		}
	}
	if mj.Address != nil {
		if true {
			buf.WriteString(`"address":`)

			{

				err = mj.Address.MarshalJSONBuf(buf)
				if err != nil {
					return err
				}

			}
			buf.WriteByte(',')
		}
	}
	if mj.Domain != nil {
		if true {
			buf.WriteString(`"domain":`)

			{

				err = mj.Domain.MarshalJSONBuf(buf)
				if err != nil {
					return err
				}

			}
			buf.WriteByte(',')
		}
	}
	buf.WriteString(`"capabilities":`)
	if mj.Capabilities != nil {
		buf.WriteString(`[`)
		for i, v := range mj.Capabilities {
			if i != 0 {
				buf.WriteString(`,`)
			}

			{

				err = v.MarshalJSONBuf(buf)
				if err != nil {
					return err
				}

			}
		}
		buf.WriteString(`]`)
	} else {
		buf.WriteString(`null`)
	}
	buf.WriteByte('}')
	return nil
}

const (
	ffj_t_MasterInfobase = iota
	ffj_t_MasterInfono_such_key

	ffj_t_MasterInfo_ID

	ffj_t_MasterInfo_IP

	ffj_t_MasterInfo_Port

	ffj_t_MasterInfo_PID

	ffj_t_MasterInfo_Hostname

	ffj_t_MasterInfo_Version

	ffj_t_MasterInfo_Address

	ffj_t_MasterInfo_Domain

	ffj_t_MasterInfo_Capabilities
)

var ffj_key_MasterInfo_ID = []byte("id")

var ffj_key_MasterInfo_IP = []byte("ip")

var ffj_key_MasterInfo_Port = []byte("port")

var ffj_key_MasterInfo_PID = []byte("pid")

var ffj_key_MasterInfo_Hostname = []byte("hostname")

var ffj_key_MasterInfo_Version = []byte("version")

var ffj_key_MasterInfo_Address = []byte("address")

var ffj_key_MasterInfo_Domain = []byte("domain")

var ffj_key_MasterInfo_Capabilities = []byte("capabilities")

func (uj *MasterInfo) UnmarshalJSON(input []byte) error {
	fs := fflib.NewFFLexer(input)
	return uj.UnmarshalJSONFFLexer(fs, fflib.FFParse_map_start)
}

func (uj *MasterInfo) UnmarshalJSONFFLexer(fs *fflib.FFLexer, state fflib.FFParseState) error {
	var err error = nil
	currentKey := ffj_t_MasterInfobase
	_ = currentKey
	tok := fflib.FFTok_init
	wantedTok := fflib.FFTok_init

mainparse:
	for {
		tok = fs.Scan()
		//	println(fmt.Sprintf("debug: tok: %v  state: %v", tok, state))
		if tok == fflib.FFTok_error {
			goto tokerror
		}

		switch state {

		case fflib.FFParse_map_start:
			if tok != fflib.FFTok_left_bracket {
				wantedTok = fflib.FFTok_left_bracket
				goto wrongtokenerror
			}
			state = fflib.FFParse_want_key
			continue

		case fflib.FFParse_after_value:
			if tok == fflib.FFTok_comma {
				state = fflib.FFParse_want_key
			} else if tok == fflib.FFTok_right_bracket {
				goto done
			} else {
				wantedTok = fflib.FFTok_comma
				goto wrongtokenerror
			}

		case fflib.FFParse_want_key:
			// json {} ended. goto exit. woo.
			if tok == fflib.FFTok_right_bracket {
				goto done
			}
			if tok != fflib.FFTok_string {
				wantedTok = fflib.FFTok_string
				goto wrongtokenerror
			}

			kn := fs.Output.Bytes()
			if len(kn) <= 0 {
				// "" case. hrm.
				currentKey = ffj_t_MasterInfono_such_key
				state = fflib.FFParse_want_colon
				goto mainparse
			} else {
				switch kn[0] {

				case 'a':

					if bytes.Equal(ffj_key_MasterInfo_Address, kn) {
						currentKey = ffj_t_MasterInfo_Address
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				case 'c':

					if bytes.Equal(ffj_key_MasterInfo_Capabilities, kn) {
						currentKey = ffj_t_MasterInfo_Capabilities
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				case 'd':

					if bytes.Equal(ffj_key_MasterInfo_Domain, kn) {
						currentKey = ffj_t_MasterInfo_Domain
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				case 'h':

					if bytes.Equal(ffj_key_MasterInfo_Hostname, kn) {
						currentKey = ffj_t_MasterInfo_Hostname
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				case 'i':

					if bytes.Equal(ffj_key_MasterInfo_ID, kn) {
						currentKey = ffj_t_MasterInfo_ID
						state = fflib.FFParse_want_colon
						goto mainparse

					} else if bytes.Equal(ffj_key_MasterInfo_IP, kn) {
						currentKey = ffj_t_MasterInfo_IP
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				case 'p':

					if bytes.Equal(ffj_key_MasterInfo_Port, kn) {
						currentKey = ffj_t_MasterInfo_Port
						state = fflib.FFParse_want_colon
						goto mainparse

					} else if bytes.Equal(ffj_key_MasterInfo_PID, kn) {
						currentKey = ffj_t_MasterInfo_PID
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				case 'v':

					if bytes.Equal(ffj_key_MasterInfo_Version, kn) {
						currentKey = ffj_t_MasterInfo_Version
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				}

				if fflib.EqualFoldRight(ffj_key_MasterInfo_Capabilities, kn) {
					currentKey = ffj_t_MasterInfo_Capabilities
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.SimpleLetterEqualFold(ffj_key_MasterInfo_Domain, kn) {
					currentKey = ffj_t_MasterInfo_Domain
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffj_key_MasterInfo_Address, kn) {
					currentKey = ffj_t_MasterInfo_Address
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffj_key_MasterInfo_Version, kn) {
					currentKey = ffj_t_MasterInfo_Version
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffj_key_MasterInfo_Hostname, kn) {
					currentKey = ffj_t_MasterInfo_Hostname
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.SimpleLetterEqualFold(ffj_key_MasterInfo_PID, kn) {
					currentKey = ffj_t_MasterInfo_PID
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.SimpleLetterEqualFold(ffj_key_MasterInfo_Port, kn) {
					currentKey = ffj_t_MasterInfo_Port
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.SimpleLetterEqualFold(ffj_key_MasterInfo_IP, kn) {
					currentKey = ffj_t_MasterInfo_IP
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.SimpleLetterEqualFold(ffj_key_MasterInfo_ID, kn) {
					currentKey = ffj_t_MasterInfo_ID
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				currentKey = ffj_t_MasterInfono_such_key
				state = fflib.FFParse_want_colon
				goto mainparse
			}

		case fflib.FFParse_want_colon:
			if tok != fflib.FFTok_colon {
				wantedTok = fflib.FFTok_colon
				goto wrongtokenerror
			}
			state = fflib.FFParse_want_value
			continue
		case fflib.FFParse_want_value:

			if tok == fflib.FFTok_left_brace || tok == fflib.FFTok_left_bracket || tok == fflib.FFTok_integer || tok == fflib.FFTok_double || tok == fflib.FFTok_string || tok == fflib.FFTok_bool || tok == fflib.FFTok_null {
				switch currentKey {

				case ffj_t_MasterInfo_ID:
					goto handle_ID

				case ffj_t_MasterInfo_IP:
					goto handle_IP

				case ffj_t_MasterInfo_Port:
					goto handle_Port

				case ffj_t_MasterInfo_PID:
					goto handle_PID

				case ffj_t_MasterInfo_Hostname:
					goto handle_Hostname

				case ffj_t_MasterInfo_Version:
					goto handle_Version

				case ffj_t_MasterInfo_Address:
					goto handle_Address

				case ffj_t_MasterInfo_Domain:
					goto handle_Domain

				case ffj_t_MasterInfo_Capabilities:
					goto handle_Capabilities

				case ffj_t_MasterInfono_such_key:
					err = fs.SkipField(tok)
					if err != nil {
						return fs.WrapErr(err)
					}
					state = fflib.FFParse_after_value
					goto mainparse
				}
			} else {
				goto wantedvalue
			}
		}
	}

handle_ID:

	/* handler: uj.ID type=string kind=string quoted=false*/

	{

		{
			if tok != fflib.FFTok_string && tok != fflib.FFTok_null {
				return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for string", tok))
			}
		}

		if tok == fflib.FFTok_null {

		} else {

			outBuf := fs.Output.Bytes()

			uj.ID = string(string(outBuf))

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_IP:

	/* handler: uj.IP type=uint32 kind=uint32 quoted=false*/

	{
		if tok != fflib.FFTok_integer && tok != fflib.FFTok_null {
			return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for uint32", tok))
		}
	}

	{

		if tok == fflib.FFTok_null {

		} else {

			tval, err := fflib.ParseUint(fs.Output.Bytes(), 10, 32)

			if err != nil {
				return fs.WrapErr(err)
			}

			uj.IP = uint32(tval)

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_Port:

	/* handler: uj.Port type=uint32 kind=uint32 quoted=false*/

	{
		if tok != fflib.FFTok_integer && tok != fflib.FFTok_null {
			return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for uint32", tok))
		}
	}

	{

		if tok == fflib.FFTok_null {

			uj.Port = nil

		} else {

			tval, err := fflib.ParseUint(fs.Output.Bytes(), 10, 32)

			if err != nil {
				return fs.WrapErr(err)
			}

			ttypval := uint32(tval)
			uj.Port = &ttypval

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_PID:

	/* handler: uj.PID type=string kind=string quoted=false*/

	{

		{
			if tok != fflib.FFTok_string && tok != fflib.FFTok_null {
				return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for string", tok))
			}
		}

		if tok == fflib.FFTok_null {

			uj.PID = nil

		} else {

			var tval string
			outBuf := fs.Output.Bytes()

			tval = string(string(outBuf))
			uj.PID = &tval

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_Hostname:

	/* handler: uj.Hostname type=string kind=string quoted=false*/

	{

		{
			if tok != fflib.FFTok_string && tok != fflib.FFTok_null {
				return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for string", tok))
			}
		}

		if tok == fflib.FFTok_null {

			uj.Hostname = nil

		} else {

			var tval string
			outBuf := fs.Output.Bytes()

			tval = string(string(outBuf))
			uj.Hostname = &tval

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_Version:

	/* handler: uj.Version type=string kind=string quoted=false*/

	{

		{
			if tok != fflib.FFTok_string && tok != fflib.FFTok_null {
				return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for string", tok))
			}
		}

		if tok == fflib.FFTok_null {

			uj.Version = nil

		} else {

			var tval string
			outBuf := fs.Output.Bytes()

			tval = string(string(outBuf))
			uj.Version = &tval

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_Address:

	/* handler: uj.Address type=mesos.Address kind=struct quoted=false*/

	{
		if tok == fflib.FFTok_null {

			uj.Address = nil

			state = fflib.FFParse_after_value
			goto mainparse
		}

		if uj.Address == nil {
			uj.Address = new(Address)
		}

		err = uj.Address.UnmarshalJSONFFLexer(fs, fflib.FFParse_want_key)
		if err != nil {
			return err
		}
		state = fflib.FFParse_after_value
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_Domain:

	/* handler: uj.Domain type=mesos.DomainInfo kind=struct quoted=false*/

	{
		if tok == fflib.FFTok_null {

			uj.Domain = nil

			state = fflib.FFParse_after_value
			goto mainparse
		}

		if uj.Domain == nil {
			uj.Domain = new(DomainInfo)
		}

		err = uj.Domain.UnmarshalJSONFFLexer(fs, fflib.FFParse_want_key)
		if err != nil {
			return err
		}
		state = fflib.FFParse_after_value
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_Capabilities:

	/* handler: uj.Capabilities type=[]mesos.MasterInfo_Capability kind=slice quoted=false*/

	{

		{
			if tok != fflib.FFTok_left_brace && tok != fflib.FFTok_null {
				return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for ", tok))
			}
		}

		if tok == fflib.FFTok_null {
			uj.Capabilities = nil
		} else {

			uj.Capabilities = []MasterInfo_Capability{}

			wantVal := true

			for {

				var tmp_uj__Capabilities MasterInfo_Capability

				tok = fs.Scan()
				if tok == fflib.FFTok_error {
					goto tokerror
				}
				if tok == fflib.FFTok_right_brace {
					break
				}

				if tok == fflib.FFTok_comma {
					if wantVal == true {
						// TODO(pquerna): this isn't an ideal error message, this handles
						// things like [,,,] as an array value.
						return fs.WrapErr(fmt.Errorf("wanted value token, but got token: %v", tok))
					}
					continue
				} else {
					wantVal = true
				}

				/* handler: tmp_uj__Capabilities type=mesos.MasterInfo_Capability kind=struct quoted=false*/

				{
					if tok == fflib.FFTok_null {

						state = fflib.FFParse_after_value
						goto mainparse
					}

					err = tmp_uj__Capabilities.UnmarshalJSONFFLexer(fs, fflib.FFParse_want_key)
					if err != nil {
						return err
					}
					state = fflib.FFParse_after_value
				}

				uj.Capabilities = append(uj.Capabilities, tmp_uj__Capabilities)

				wantVal = false
			}
		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

wantedvalue:
	return fs.WrapErr(fmt.Errorf("wanted value token, but got token: %v", tok))
wrongtokenerror:
	return fs.WrapErr(fmt.Errorf("ffjson: wanted token: %v, but got token: %v output=%s", wantedTok, tok, fs.Output.String()))
tokerror:
	if fs.BigError != nil {
		return fs.WrapErr(fs.BigError)
	}
	err = fs.Error.ToError()
	if err != nil {
		return fs.WrapErr(err)
	}
	panic("ffjson-generated: unreachable, please report bug.")
done:

	return nil
}

func (mj *MasterInfo_Capability) MarshalJSON() ([]byte, error) {
	var buf fflib.Buffer
	if mj == nil {
		buf.WriteString("null")
		return buf.Bytes(), nil
	}
	err := mj.MarshalJSONBuf(&buf)
	if err != nil {
		return nil, err
	}
	return buf.Bytes(), nil
}
func (mj *MasterInfo_Capability) MarshalJSONBuf(buf fflib.EncodingBuffer) error {
	if mj == nil {
		buf.WriteString("null")
		return nil
	}
	var err error
	var obj []byte
	_ = obj
	_ = err
	buf.WriteString(`{"type":`)

	{

		obj, err = mj.Type.MarshalJSON()
		if err != nil {
			return err
		}
		buf.Write(obj)

	}
	buf.WriteByte('}')
	return nil
}

const (
	ffj_t_MasterInfo_Capabilitybase = iota
	ffj_t_MasterInfo_Capabilityno_such_key

	ffj_t_MasterInfo_Capability_Type
)

var ffj_key_MasterInfo_Capability_Type = []byte("type")

func (uj *MasterInfo_Capability) UnmarshalJSON(input []byte) error {
	fs := fflib.NewFFLexer(input)
	return uj.UnmarshalJSONFFLexer(fs, fflib.FFParse_map_start)
}

func (uj *MasterInfo_Capability) UnmarshalJSONFFLexer(fs *fflib.FFLexer, state fflib.FFParseState) error {
	var err error = nil
	currentKey := ffj_t_MasterInfo_Capabilitybase
	_ = currentKey
	tok := fflib.FFTok_init
	wantedTok := fflib.FFTok_init

mainparse:
	for {
		tok = fs.Scan()
		//	println(fmt.Sprintf("debug: tok: %v  state: %v", tok, state))
		if tok == fflib.FFTok_error {
			goto tokerror
		}

		switch state {

		case fflib.FFParse_map_start:
			if tok != fflib.FFTok_left_bracket {
				wantedTok = fflib.FFTok_left_bracket
				goto wrongtokenerror
			}
			state = fflib.FFParse_want_key
			continue

		case fflib.FFParse_after_value:
			if tok == fflib.FFTok_comma {
				state = fflib.FFParse_want_key
			} else if tok == fflib.FFTok_right_bracket {
				goto done
			} else {
				wantedTok = fflib.FFTok_comma
				goto wrongtokenerror
			}

		case fflib.FFParse_want_key:
			// json {} ended. goto exit. woo.
			if tok == fflib.FFTok_right_bracket {
				goto done
			}
			if tok != fflib.FFTok_string {
				wantedTok = fflib.FFTok_string
				goto wrongtokenerror
			}

			kn := fs.Output.Bytes()
			if len(kn) <= 0 {
				// "" case. hrm.
				currentKey = ffj_t_MasterInfo_Capabilityno_such_key
				state = fflib.FFParse_want_colon
				goto mainparse
			} else {
				switch kn[0] {

				case 't':

					if bytes.Equal(ffj_key_MasterInfo_Capability_Type, kn) {
						currentKey = ffj_t_MasterInfo_Capability_Type
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				}

				if fflib.SimpleLetterEqualFold(ffj_key_MasterInfo_Capability_Type, kn) {
					currentKey = ffj_t_MasterInfo_Capability_Type
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				currentKey = ffj_t_MasterInfo_Capabilityno_such_key
				state = fflib.FFParse_want_colon
				goto mainparse
			}

		case fflib.FFParse_want_colon:
			if tok != fflib.FFTok_colon {
				wantedTok = fflib.FFTok_colon
				goto wrongtokenerror
			}
			state = fflib.FFParse_want_value
			continue
		case fflib.FFParse_want_value:

			if tok == fflib.FFTok_left_brace || tok == fflib.FFTok_left_bracket || tok == fflib.FFTok_integer || tok == fflib.FFTok_double || tok == fflib.FFTok_string || tok == fflib.FFTok_bool || tok == fflib.FFTok_null {
				switch currentKey {

				case ffj_t_MasterInfo_Capability_Type:
					goto handle_Type

				case ffj_t_MasterInfo_Capabilityno_such_key:
					err = fs.SkipField(tok)
					if err != nil {
						return fs.WrapErr(err)
					}
					state = fflib.FFParse_after_value
					goto mainparse
				}
			} else {
				goto wantedvalue
			}
		}
	}

handle_Type:

	/* handler: uj.Type type=mesos.MasterInfo_Capability_Type kind=int32 quoted=false*/

	{
		if tok == fflib.FFTok_null {

			state = fflib.FFParse_after_value
			goto mainparse
		}

		tbuf, err := fs.CaptureField(tok)
		if err != nil {
			return fs.WrapErr(err)
		}

		err = uj.Type.UnmarshalJSON(tbuf)
		if err != nil {
			return fs.WrapErr(err)
		}
		state = fflib.FFParse_after_value
	}

	state = fflib.FFParse_after_value
	goto mainparse

wantedvalue:
	return fs.WrapErr(fmt.Errorf("wanted value token, but got token: %v", tok))
wrongtokenerror:
	return fs.WrapErr(fmt.Errorf("ffjson: wanted token: %v, but got token: %v output=%s", wantedTok, tok, fs.Output.String()))
tokerror:
	if fs.BigError != nil {
		return fs.WrapErr(fs.BigError)
	}
	err = fs.Error.ToError()
	if err != nil {
		return fs.WrapErr(err)
	}
	panic("ffjson-generated: unreachable, please report bug.")
done:

	return nil
}

func (mj *Metric) MarshalJSON() ([]byte, error) {
	var buf fflib.Buffer
	if mj == nil {
		buf.WriteString("null")
		return buf.Bytes(), nil
	}
	err := mj.MarshalJSONBuf(&buf)
	if err != nil {
		return nil, err
	}
	return buf.Bytes(), nil
}
func (mj *Metric) MarshalJSONBuf(buf fflib.EncodingBuffer) error {
	if mj == nil {
		buf.WriteString("null")
		return nil
	}
	var err error
	var obj []byte
	_ = obj
	_ = err
	buf.WriteString(`{ "name":`)
	fflib.WriteJsonString(buf, string(mj.Name))
	buf.WriteByte(',')
	if mj.Value != nil {
		if true {
			buf.WriteString(`"value":`)
			fflib.AppendFloat(buf, float64(*mj.Value), 'g', -1, 64)
			buf.WriteByte(',')
		}
	}
	buf.Rewind(1)
	buf.WriteByte('}')
	return nil
}

const (
	ffj_t_Metricbase = iota
	ffj_t_Metricno_such_key

	ffj_t_Metric_Name

	ffj_t_Metric_Value
)

var ffj_key_Metric_Name = []byte("name")

var ffj_key_Metric_Value = []byte("value")

func (uj *Metric) UnmarshalJSON(input []byte) error {
	fs := fflib.NewFFLexer(input)
	return uj.UnmarshalJSONFFLexer(fs, fflib.FFParse_map_start)
}

func (uj *Metric) UnmarshalJSONFFLexer(fs *fflib.FFLexer, state fflib.FFParseState) error {
	var err error = nil
	currentKey := ffj_t_Metricbase
	_ = currentKey
	tok := fflib.FFTok_init
	wantedTok := fflib.FFTok_init

mainparse:
	for {
		tok = fs.Scan()
		//	println(fmt.Sprintf("debug: tok: %v  state: %v", tok, state))
		if tok == fflib.FFTok_error {
			goto tokerror
		}

		switch state {

		case fflib.FFParse_map_start:
			if tok != fflib.FFTok_left_bracket {
				wantedTok = fflib.FFTok_left_bracket
				goto wrongtokenerror
			}
			state = fflib.FFParse_want_key
			continue

		case fflib.FFParse_after_value:
			if tok == fflib.FFTok_comma {
				state = fflib.FFParse_want_key
			} else if tok == fflib.FFTok_right_bracket {
				goto done
			} else {
				wantedTok = fflib.FFTok_comma
				goto wrongtokenerror
			}

		case fflib.FFParse_want_key:
			// json {} ended. goto exit. woo.
			if tok == fflib.FFTok_right_bracket {
				goto done
			}
			if tok != fflib.FFTok_string {
				wantedTok = fflib.FFTok_string
				goto wrongtokenerror
			}

			kn := fs.Output.Bytes()
			if len(kn) <= 0 {
				// "" case. hrm.
				currentKey = ffj_t_Metricno_such_key
				state = fflib.FFParse_want_colon
				goto mainparse
			} else {
				switch kn[0] {

				case 'n':

					if bytes.Equal(ffj_key_Metric_Name, kn) {
						currentKey = ffj_t_Metric_Name
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				case 'v':

					if bytes.Equal(ffj_key_Metric_Value, kn) {
						currentKey = ffj_t_Metric_Value
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				}

				if fflib.SimpleLetterEqualFold(ffj_key_Metric_Value, kn) {
					currentKey = ffj_t_Metric_Value
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.SimpleLetterEqualFold(ffj_key_Metric_Name, kn) {
					currentKey = ffj_t_Metric_Name
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				currentKey = ffj_t_Metricno_such_key
				state = fflib.FFParse_want_colon
				goto mainparse
			}

		case fflib.FFParse_want_colon:
			if tok != fflib.FFTok_colon {
				wantedTok = fflib.FFTok_colon
				goto wrongtokenerror
			}
			state = fflib.FFParse_want_value
			continue
		case fflib.FFParse_want_value:

			if tok == fflib.FFTok_left_brace || tok == fflib.FFTok_left_bracket || tok == fflib.FFTok_integer || tok == fflib.FFTok_double || tok == fflib.FFTok_string || tok == fflib.FFTok_bool || tok == fflib.FFTok_null {
				switch currentKey {

				case ffj_t_Metric_Name:
					goto handle_Name

				case ffj_t_Metric_Value:
					goto handle_Value

				case ffj_t_Metricno_such_key:
					err = fs.SkipField(tok)
					if err != nil {
						return fs.WrapErr(err)
					}
					state = fflib.FFParse_after_value
					goto mainparse
				}
			} else {
				goto wantedvalue
			}
		}
	}

handle_Name:

	/* handler: uj.Name type=string kind=string quoted=false*/

	{

		{
			if tok != fflib.FFTok_string && tok != fflib.FFTok_null {
				return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for string", tok))
			}
		}

		if tok == fflib.FFTok_null {

		} else {

			outBuf := fs.Output.Bytes()

			uj.Name = string(string(outBuf))

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_Value:

	/* handler: uj.Value type=float64 kind=float64 quoted=false*/

	{
		if tok != fflib.FFTok_double && tok != fflib.FFTok_integer && tok != fflib.FFTok_null {
			return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for float64", tok))
		}
	}

	{

		if tok == fflib.FFTok_null {

			uj.Value = nil

		} else {

			tval, err := fflib.ParseFloat(fs.Output.Bytes(), 64)

			if err != nil {
				return fs.WrapErr(err)
			}

			ttypval := float64(tval)
			uj.Value = &ttypval

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

wantedvalue:
	return fs.WrapErr(fmt.Errorf("wanted value token, but got token: %v", tok))
wrongtokenerror:
	return fs.WrapErr(fmt.Errorf("ffjson: wanted token: %v, but got token: %v output=%s", wantedTok, tok, fs.Output.String()))
tokerror:
	if fs.BigError != nil {
		return fs.WrapErr(fs.BigError)
	}
	err = fs.Error.ToError()
	if err != nil {
		return fs.WrapErr(err)
	}
	panic("ffjson-generated: unreachable, please report bug.")
done:

	return nil
}

func (mj *MountPropagation) MarshalJSON() ([]byte, error) {
	var buf fflib.Buffer
	if mj == nil {
		buf.WriteString("null")
		return buf.Bytes(), nil
	}
	err := mj.MarshalJSONBuf(&buf)
	if err != nil {
		return nil, err
	}
	return buf.Bytes(), nil
}
func (mj *MountPropagation) MarshalJSONBuf(buf fflib.EncodingBuffer) error {
	if mj == nil {
		buf.WriteString("null")
		return nil
	}
	var err error
	var obj []byte
	_ = obj
	_ = err
	buf.WriteString(`{ `)
	if mj.Mode != nil {
		if true {
			buf.WriteString(`"mode":`)

			{

				obj, err = mj.Mode.MarshalJSON()
				if err != nil {
					return err
				}
				buf.Write(obj)

			}
			buf.WriteByte(',')
		}
	}
	buf.Rewind(1)
	buf.WriteByte('}')
	return nil
}

const (
	ffj_t_MountPropagationbase = iota
	ffj_t_MountPropagationno_such_key

	ffj_t_MountPropagation_Mode
)

var ffj_key_MountPropagation_Mode = []byte("mode")

func (uj *MountPropagation) UnmarshalJSON(input []byte) error {
	fs := fflib.NewFFLexer(input)
	return uj.UnmarshalJSONFFLexer(fs, fflib.FFParse_map_start)
}

func (uj *MountPropagation) UnmarshalJSONFFLexer(fs *fflib.FFLexer, state fflib.FFParseState) error {
	var err error = nil
	currentKey := ffj_t_MountPropagationbase
	_ = currentKey
	tok := fflib.FFTok_init
	wantedTok := fflib.FFTok_init

mainparse:
	for {
		tok = fs.Scan()
		//	println(fmt.Sprintf("debug: tok: %v  state: %v", tok, state))
		if tok == fflib.FFTok_error {
			goto tokerror
		}

		switch state {

		case fflib.FFParse_map_start:
			if tok != fflib.FFTok_left_bracket {
				wantedTok = fflib.FFTok_left_bracket
				goto wrongtokenerror
			}
			state = fflib.FFParse_want_key
			continue

		case fflib.FFParse_after_value:
			if tok == fflib.FFTok_comma {
				state = fflib.FFParse_want_key
			} else if tok == fflib.FFTok_right_bracket {
				goto done
			} else {
				wantedTok = fflib.FFTok_comma
				goto wrongtokenerror
			}

		case fflib.FFParse_want_key:
			// json {} ended. goto exit. woo.
			if tok == fflib.FFTok_right_bracket {
				goto done
			}
			if tok != fflib.FFTok_string {
				wantedTok = fflib.FFTok_string
				goto wrongtokenerror
			}

			kn := fs.Output.Bytes()
			if len(kn) <= 0 {
				// "" case. hrm.
				currentKey = ffj_t_MountPropagationno_such_key
				state = fflib.FFParse_want_colon
				goto mainparse
			} else {
				switch kn[0] {

				case 'm':

					if bytes.Equal(ffj_key_MountPropagation_Mode, kn) {
						currentKey = ffj_t_MountPropagation_Mode
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				}

				if fflib.SimpleLetterEqualFold(ffj_key_MountPropagation_Mode, kn) {
					currentKey = ffj_t_MountPropagation_Mode
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				currentKey = ffj_t_MountPropagationno_such_key
				state = fflib.FFParse_want_colon
				goto mainparse
			}

		case fflib.FFParse_want_colon:
			if tok != fflib.FFTok_colon {
				wantedTok = fflib.FFTok_colon
				goto wrongtokenerror
			}
			state = fflib.FFParse_want_value
			continue
		case fflib.FFParse_want_value:

			if tok == fflib.FFTok_left_brace || tok == fflib.FFTok_left_bracket || tok == fflib.FFTok_integer || tok == fflib.FFTok_double || tok == fflib.FFTok_string || tok == fflib.FFTok_bool || tok == fflib.FFTok_null {
				switch currentKey {

				case ffj_t_MountPropagation_Mode:
					goto handle_Mode

				case ffj_t_MountPropagationno_such_key:
					err = fs.SkipField(tok)
					if err != nil {
						return fs.WrapErr(err)
					}
					state = fflib.FFParse_after_value
					goto mainparse
				}
			} else {
				goto wantedvalue
			}
		}
	}

handle_Mode:

	/* handler: uj.Mode type=mesos.MountPropagation_Mode kind=int32 quoted=false*/

	{
		if tok == fflib.FFTok_null {

			uj.Mode = nil

			state = fflib.FFParse_after_value
			goto mainparse
		}

		tbuf, err := fs.CaptureField(tok)
		if err != nil {
			return fs.WrapErr(err)
		}

		if uj.Mode == nil {
			uj.Mode = new(MountPropagation_Mode)
		}

		err = uj.Mode.UnmarshalJSON(tbuf)
		if err != nil {
			return fs.WrapErr(err)
		}
		state = fflib.FFParse_after_value
	}

	state = fflib.FFParse_after_value
	goto mainparse

wantedvalue:
	return fs.WrapErr(fmt.Errorf("wanted value token, but got token: %v", tok))
wrongtokenerror:
	return fs.WrapErr(fmt.Errorf("ffjson: wanted token: %v, but got token: %v output=%s", wantedTok, tok, fs.Output.String()))
tokerror:
	if fs.BigError != nil {
		return fs.WrapErr(fs.BigError)
	}
	err = fs.Error.ToError()
	if err != nil {
		return fs.WrapErr(err)
	}
	panic("ffjson-generated: unreachable, please report bug.")
done:

	return nil
}

func (mj *NetworkInfo) MarshalJSON() ([]byte, error) {
	var buf fflib.Buffer
	if mj == nil {
		buf.WriteString("null")
		return buf.Bytes(), nil
	}
	err := mj.MarshalJSONBuf(&buf)
	if err != nil {
		return nil, err
	}
	return buf.Bytes(), nil
}
func (mj *NetworkInfo) MarshalJSONBuf(buf fflib.EncodingBuffer) error {
	if mj == nil {
		buf.WriteString("null")
		return nil
	}
	var err error
	var obj []byte
	_ = obj
	_ = err
	buf.WriteString(`{"ip_addresses":`)
	if mj.IPAddresses != nil {
		buf.WriteString(`[`)
		for i, v := range mj.IPAddresses {
			if i != 0 {
				buf.WriteString(`,`)
			}

			{

				err = v.MarshalJSONBuf(buf)
				if err != nil {
					return err
				}

			}
		}
		buf.WriteString(`]`)
	} else {
		buf.WriteString(`null`)
	}
	buf.WriteByte(',')
	if mj.Name != nil {
		if true {
			buf.WriteString(`"name":`)
			fflib.WriteJsonString(buf, string(*mj.Name))
			buf.WriteByte(',')
		}
	}
	if len(mj.Groups) != 0 {
		buf.WriteString(`"groups":`)
		if mj.Groups != nil {
			buf.WriteString(`[`)
			for i, v := range mj.Groups {
				if i != 0 {
					buf.WriteString(`,`)
				}
				fflib.WriteJsonString(buf, string(v))
			}
			buf.WriteString(`]`)
		} else {
			buf.WriteString(`null`)
		}
		buf.WriteByte(',')
	}
	if mj.Labels != nil {
		if true {
			buf.WriteString(`"labels":`)

			{

				err = mj.Labels.MarshalJSONBuf(buf)
				if err != nil {
					return err
				}

			}
			buf.WriteByte(',')
		}
	}
	buf.WriteString(`"port_mappings":`)
	if mj.PortMappings != nil {
		buf.WriteString(`[`)
		for i, v := range mj.PortMappings {
			if i != 0 {
				buf.WriteString(`,`)
			}

			{

				err = v.MarshalJSONBuf(buf)
				if err != nil {
					return err
				}

			}
		}
		buf.WriteString(`]`)
	} else {
		buf.WriteString(`null`)
	}
	buf.WriteByte('}')
	return nil
}

const (
	ffj_t_NetworkInfobase = iota
	ffj_t_NetworkInfono_such_key

	ffj_t_NetworkInfo_IPAddresses

	ffj_t_NetworkInfo_Name

	ffj_t_NetworkInfo_Groups

	ffj_t_NetworkInfo_Labels

	ffj_t_NetworkInfo_PortMappings
)

var ffj_key_NetworkInfo_IPAddresses = []byte("ip_addresses")

var ffj_key_NetworkInfo_Name = []byte("name")

var ffj_key_NetworkInfo_Groups = []byte("groups")

var ffj_key_NetworkInfo_Labels = []byte("labels")

var ffj_key_NetworkInfo_PortMappings = []byte("port_mappings")

func (uj *NetworkInfo) UnmarshalJSON(input []byte) error {
	fs := fflib.NewFFLexer(input)
	return uj.UnmarshalJSONFFLexer(fs, fflib.FFParse_map_start)
}

func (uj *NetworkInfo) UnmarshalJSONFFLexer(fs *fflib.FFLexer, state fflib.FFParseState) error {
	var err error = nil
	currentKey := ffj_t_NetworkInfobase
	_ = currentKey
	tok := fflib.FFTok_init
	wantedTok := fflib.FFTok_init

mainparse:
	for {
		tok = fs.Scan()
		//	println(fmt.Sprintf("debug: tok: %v  state: %v", tok, state))
		if tok == fflib.FFTok_error {
			goto tokerror
		}

		switch state {

		case fflib.FFParse_map_start:
			if tok != fflib.FFTok_left_bracket {
				wantedTok = fflib.FFTok_left_bracket
				goto wrongtokenerror
			}
			state = fflib.FFParse_want_key
			continue

		case fflib.FFParse_after_value:
			if tok == fflib.FFTok_comma {
				state = fflib.FFParse_want_key
			} else if tok == fflib.FFTok_right_bracket {
				goto done
			} else {
				wantedTok = fflib.FFTok_comma
				goto wrongtokenerror
			}

		case fflib.FFParse_want_key:
			// json {} ended. goto exit. woo.
			if tok == fflib.FFTok_right_bracket {
				goto done
			}
			if tok != fflib.FFTok_string {
				wantedTok = fflib.FFTok_string
				goto wrongtokenerror
			}

			kn := fs.Output.Bytes()
			if len(kn) <= 0 {
				// "" case. hrm.
				currentKey = ffj_t_NetworkInfono_such_key
				state = fflib.FFParse_want_colon
				goto mainparse
			} else {
				switch kn[0] {

				case 'g':

					if bytes.Equal(ffj_key_NetworkInfo_Groups, kn) {
						currentKey = ffj_t_NetworkInfo_Groups
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				case 'i':

					if bytes.Equal(ffj_key_NetworkInfo_IPAddresses, kn) {
						currentKey = ffj_t_NetworkInfo_IPAddresses
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				case 'l':

					if bytes.Equal(ffj_key_NetworkInfo_Labels, kn) {
						currentKey = ffj_t_NetworkInfo_Labels
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				case 'n':

					if bytes.Equal(ffj_key_NetworkInfo_Name, kn) {
						currentKey = ffj_t_NetworkInfo_Name
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				case 'p':

					if bytes.Equal(ffj_key_NetworkInfo_PortMappings, kn) {
						currentKey = ffj_t_NetworkInfo_PortMappings
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				}

				if fflib.EqualFoldRight(ffj_key_NetworkInfo_PortMappings, kn) {
					currentKey = ffj_t_NetworkInfo_PortMappings
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffj_key_NetworkInfo_Labels, kn) {
					currentKey = ffj_t_NetworkInfo_Labels
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffj_key_NetworkInfo_Groups, kn) {
					currentKey = ffj_t_NetworkInfo_Groups
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.SimpleLetterEqualFold(ffj_key_NetworkInfo_Name, kn) {
					currentKey = ffj_t_NetworkInfo_Name
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffj_key_NetworkInfo_IPAddresses, kn) {
					currentKey = ffj_t_NetworkInfo_IPAddresses
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				currentKey = ffj_t_NetworkInfono_such_key
				state = fflib.FFParse_want_colon
				goto mainparse
			}

		case fflib.FFParse_want_colon:
			if tok != fflib.FFTok_colon {
				wantedTok = fflib.FFTok_colon
				goto wrongtokenerror
			}
			state = fflib.FFParse_want_value
			continue
		case fflib.FFParse_want_value:

			if tok == fflib.FFTok_left_brace || tok == fflib.FFTok_left_bracket || tok == fflib.FFTok_integer || tok == fflib.FFTok_double || tok == fflib.FFTok_string || tok == fflib.FFTok_bool || tok == fflib.FFTok_null {
				switch currentKey {

				case ffj_t_NetworkInfo_IPAddresses:
					goto handle_IPAddresses

				case ffj_t_NetworkInfo_Name:
					goto handle_Name

				case ffj_t_NetworkInfo_Groups:
					goto handle_Groups

				case ffj_t_NetworkInfo_Labels:
					goto handle_Labels

				case ffj_t_NetworkInfo_PortMappings:
					goto handle_PortMappings

				case ffj_t_NetworkInfono_such_key:
					err = fs.SkipField(tok)
					if err != nil {
						return fs.WrapErr(err)
					}
					state = fflib.FFParse_after_value
					goto mainparse
				}
			} else {
				goto wantedvalue
			}
		}
	}

handle_IPAddresses:

	/* handler: uj.IPAddresses type=[]mesos.NetworkInfo_IPAddress kind=slice quoted=false*/

	{

		{
			if tok != fflib.FFTok_left_brace && tok != fflib.FFTok_null {
				return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for ", tok))
			}
		}

		if tok == fflib.FFTok_null {
			uj.IPAddresses = nil
		} else {

			uj.IPAddresses = []NetworkInfo_IPAddress{}

			wantVal := true

			for {

				var tmp_uj__IPAddresses NetworkInfo_IPAddress

				tok = fs.Scan()
				if tok == fflib.FFTok_error {
					goto tokerror
				}
				if tok == fflib.FFTok_right_brace {
					break
				}

				if tok == fflib.FFTok_comma {
					if wantVal == true {
						// TODO(pquerna): this isn't an ideal error message, this handles
						// things like [,,,] as an array value.
						return fs.WrapErr(fmt.Errorf("wanted value token, but got token: %v", tok))
					}
					continue
				} else {
					wantVal = true
				}

				/* handler: tmp_uj__IPAddresses type=mesos.NetworkInfo_IPAddress kind=struct quoted=false*/

				{
					if tok == fflib.FFTok_null {

						state = fflib.FFParse_after_value
						goto mainparse
					}

					err = tmp_uj__IPAddresses.UnmarshalJSONFFLexer(fs, fflib.FFParse_want_key)
					if err != nil {
						return err
					}
					state = fflib.FFParse_after_value
				}

				uj.IPAddresses = append(uj.IPAddresses, tmp_uj__IPAddresses)

				wantVal = false
			}
		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_Name:

	/* handler: uj.Name type=string kind=string quoted=false*/

	{

		{
			if tok != fflib.FFTok_string && tok != fflib.FFTok_null {
				return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for string", tok))
			}
		}

		if tok == fflib.FFTok_null {

			uj.Name = nil

		} else {

			var tval string
			outBuf := fs.Output.Bytes()

			tval = string(string(outBuf))
			uj.Name = &tval

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_Groups:

	/* handler: uj.Groups type=[]string kind=slice quoted=false*/

	{

		{
			if tok != fflib.FFTok_left_brace && tok != fflib.FFTok_null {
				return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for ", tok))
			}
		}

		if tok == fflib.FFTok_null {
			uj.Groups = nil
		} else {

			uj.Groups = []string{}

			wantVal := true

			for {

				var tmp_uj__Groups string

				tok = fs.Scan()
				if tok == fflib.FFTok_error {
					goto tokerror
				}
				if tok == fflib.FFTok_right_brace {
					break
				}

				if tok == fflib.FFTok_comma {
					if wantVal == true {
						// TODO(pquerna): this isn't an ideal error message, this handles
						// things like [,,,] as an array value.
						return fs.WrapErr(fmt.Errorf("wanted value token, but got token: %v", tok))
					}
					continue
				} else {
					wantVal = true
				}

				/* handler: tmp_uj__Groups type=string kind=string quoted=false*/

				{

					{
						if tok != fflib.FFTok_string && tok != fflib.FFTok_null {
							return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for string", tok))
						}
					}

					if tok == fflib.FFTok_null {

					} else {

						outBuf := fs.Output.Bytes()

						tmp_uj__Groups = string(string(outBuf))

					}
				}

				uj.Groups = append(uj.Groups, tmp_uj__Groups)

				wantVal = false
			}
		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_Labels:

	/* handler: uj.Labels type=mesos.Labels kind=struct quoted=false*/

	{
		if tok == fflib.FFTok_null {

			uj.Labels = nil

			state = fflib.FFParse_after_value
			goto mainparse
		}

		if uj.Labels == nil {
			uj.Labels = new(Labels)
		}

		err = uj.Labels.UnmarshalJSONFFLexer(fs, fflib.FFParse_want_key)
		if err != nil {
			return err
		}
		state = fflib.FFParse_after_value
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_PortMappings:

	/* handler: uj.PortMappings type=[]mesos.NetworkInfo_PortMapping kind=slice quoted=false*/

	{

		{
			if tok != fflib.FFTok_left_brace && tok != fflib.FFTok_null {
				return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for ", tok))
			}
		}

		if tok == fflib.FFTok_null {
			uj.PortMappings = nil
		} else {

			uj.PortMappings = []NetworkInfo_PortMapping{}

			wantVal := true

			for {

				var tmp_uj__PortMappings NetworkInfo_PortMapping

				tok = fs.Scan()
				if tok == fflib.FFTok_error {
					goto tokerror
				}
				if tok == fflib.FFTok_right_brace {
					break
				}

				if tok == fflib.FFTok_comma {
					if wantVal == true {
						// TODO(pquerna): this isn't an ideal error message, this handles
						// things like [,,,] as an array value.
						return fs.WrapErr(fmt.Errorf("wanted value token, but got token: %v", tok))
					}
					continue
				} else {
					wantVal = true
				}

				/* handler: tmp_uj__PortMappings type=mesos.NetworkInfo_PortMapping kind=struct quoted=false*/

				{
					if tok == fflib.FFTok_null {

						state = fflib.FFParse_after_value
						goto mainparse
					}

					err = tmp_uj__PortMappings.UnmarshalJSONFFLexer(fs, fflib.FFParse_want_key)
					if err != nil {
						return err
					}
					state = fflib.FFParse_after_value
				}

				uj.PortMappings = append(uj.PortMappings, tmp_uj__PortMappings)

				wantVal = false
			}
		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

wantedvalue:
	return fs.WrapErr(fmt.Errorf("wanted value token, but got token: %v", tok))
wrongtokenerror:
	return fs.WrapErr(fmt.Errorf("ffjson: wanted token: %v, but got token: %v output=%s", wantedTok, tok, fs.Output.String()))
tokerror:
	if fs.BigError != nil {
		return fs.WrapErr(fs.BigError)
	}
	err = fs.Error.ToError()
	if err != nil {
		return fs.WrapErr(err)
	}
	panic("ffjson-generated: unreachable, please report bug.")
done:

	return nil
}

func (mj *NetworkInfo_IPAddress) MarshalJSON() ([]byte, error) {
	var buf fflib.Buffer
	if mj == nil {
		buf.WriteString("null")
		return buf.Bytes(), nil
	}
	err := mj.MarshalJSONBuf(&buf)
	if err != nil {
		return nil, err
	}
	return buf.Bytes(), nil
}
func (mj *NetworkInfo_IPAddress) MarshalJSONBuf(buf fflib.EncodingBuffer) error {
	if mj == nil {
		buf.WriteString("null")
		return nil
	}
	var err error
	var obj []byte
	_ = obj
	_ = err
	buf.WriteString(`{ `)
	if mj.Protocol != nil {
		if true {
			buf.WriteString(`"protocol":`)

			{

				obj, err = mj.Protocol.MarshalJSON()
				if err != nil {
					return err
				}
				buf.Write(obj)

			}
			buf.WriteByte(',')
		}
	}
	if mj.IPAddress != nil {
		if true {
			buf.WriteString(`"ip_address":`)
			fflib.WriteJsonString(buf, string(*mj.IPAddress))
			buf.WriteByte(',')
		}
	}
	buf.Rewind(1)
	buf.WriteByte('}')
	return nil
}

const (
	ffj_t_NetworkInfo_IPAddressbase = iota
	ffj_t_NetworkInfo_IPAddressno_such_key

	ffj_t_NetworkInfo_IPAddress_Protocol

	ffj_t_NetworkInfo_IPAddress_IPAddress
)

var ffj_key_NetworkInfo_IPAddress_Protocol = []byte("protocol")

var ffj_key_NetworkInfo_IPAddress_IPAddress = []byte("ip_address")

func (uj *NetworkInfo_IPAddress) UnmarshalJSON(input []byte) error {
	fs := fflib.NewFFLexer(input)
	return uj.UnmarshalJSONFFLexer(fs, fflib.FFParse_map_start)
}

func (uj *NetworkInfo_IPAddress) UnmarshalJSONFFLexer(fs *fflib.FFLexer, state fflib.FFParseState) error {
	var err error = nil
	currentKey := ffj_t_NetworkInfo_IPAddressbase
	_ = currentKey
	tok := fflib.FFTok_init
	wantedTok := fflib.FFTok_init

mainparse:
	for {
		tok = fs.Scan()
		//	println(fmt.Sprintf("debug: tok: %v  state: %v", tok, state))
		if tok == fflib.FFTok_error {
			goto tokerror
		}

		switch state {

		case fflib.FFParse_map_start:
			if tok != fflib.FFTok_left_bracket {
				wantedTok = fflib.FFTok_left_bracket
				goto wrongtokenerror
			}
			state = fflib.FFParse_want_key
			continue

		case fflib.FFParse_after_value:
			if tok == fflib.FFTok_comma {
				state = fflib.FFParse_want_key
			} else if tok == fflib.FFTok_right_bracket {
				goto done
			} else {
				wantedTok = fflib.FFTok_comma
				goto wrongtokenerror
			}

		case fflib.FFParse_want_key:
			// json {} ended. goto exit. woo.
			if tok == fflib.FFTok_right_bracket {
				goto done
			}
			if tok != fflib.FFTok_string {
				wantedTok = fflib.FFTok_string
				goto wrongtokenerror
			}

			kn := fs.Output.Bytes()
			if len(kn) <= 0 {
				// "" case. hrm.
				currentKey = ffj_t_NetworkInfo_IPAddressno_such_key
				state = fflib.FFParse_want_colon
				goto mainparse
			} else {
				switch kn[0] {

				case 'i':

					if bytes.Equal(ffj_key_NetworkInfo_IPAddress_IPAddress, kn) {
						currentKey = ffj_t_NetworkInfo_IPAddress_IPAddress
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				case 'p':

					if bytes.Equal(ffj_key_NetworkInfo_IPAddress_Protocol, kn) {
						currentKey = ffj_t_NetworkInfo_IPAddress_Protocol
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				}

				if fflib.EqualFoldRight(ffj_key_NetworkInfo_IPAddress_IPAddress, kn) {
					currentKey = ffj_t_NetworkInfo_IPAddress_IPAddress
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.SimpleLetterEqualFold(ffj_key_NetworkInfo_IPAddress_Protocol, kn) {
					currentKey = ffj_t_NetworkInfo_IPAddress_Protocol
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				currentKey = ffj_t_NetworkInfo_IPAddressno_such_key
				state = fflib.FFParse_want_colon
				goto mainparse
			}

		case fflib.FFParse_want_colon:
			if tok != fflib.FFTok_colon {
				wantedTok = fflib.FFTok_colon
				goto wrongtokenerror
			}
			state = fflib.FFParse_want_value
			continue
		case fflib.FFParse_want_value:

			if tok == fflib.FFTok_left_brace || tok == fflib.FFTok_left_bracket || tok == fflib.FFTok_integer || tok == fflib.FFTok_double || tok == fflib.FFTok_string || tok == fflib.FFTok_bool || tok == fflib.FFTok_null {
				switch currentKey {

				case ffj_t_NetworkInfo_IPAddress_Protocol:
					goto handle_Protocol

				case ffj_t_NetworkInfo_IPAddress_IPAddress:
					goto handle_IPAddress

				case ffj_t_NetworkInfo_IPAddressno_such_key:
					err = fs.SkipField(tok)
					if err != nil {
						return fs.WrapErr(err)
					}
					state = fflib.FFParse_after_value
					goto mainparse
				}
			} else {
				goto wantedvalue
			}
		}
	}

handle_Protocol:

	/* handler: uj.Protocol type=mesos.NetworkInfo_Protocol kind=int32 quoted=false*/

	{
		if tok == fflib.FFTok_null {

			uj.Protocol = nil

			state = fflib.FFParse_after_value
			goto mainparse
		}

		tbuf, err := fs.CaptureField(tok)
		if err != nil {
			return fs.WrapErr(err)
		}

		if uj.Protocol == nil {
			uj.Protocol = new(NetworkInfo_Protocol)
		}

		err = uj.Protocol.UnmarshalJSON(tbuf)
		if err != nil {
			return fs.WrapErr(err)
		}
		state = fflib.FFParse_after_value
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_IPAddress:

	/* handler: uj.IPAddress type=string kind=string quoted=false*/

	{

		{
			if tok != fflib.FFTok_string && tok != fflib.FFTok_null {
				return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for string", tok))
			}
		}

		if tok == fflib.FFTok_null {

			uj.IPAddress = nil

		} else {

			var tval string
			outBuf := fs.Output.Bytes()

			tval = string(string(outBuf))
			uj.IPAddress = &tval

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

wantedvalue:
	return fs.WrapErr(fmt.Errorf("wanted value token, but got token: %v", tok))
wrongtokenerror:
	return fs.WrapErr(fmt.Errorf("ffjson: wanted token: %v, but got token: %v output=%s", wantedTok, tok, fs.Output.String()))
tokerror:
	if fs.BigError != nil {
		return fs.WrapErr(fs.BigError)
	}
	err = fs.Error.ToError()
	if err != nil {
		return fs.WrapErr(err)
	}
	panic("ffjson-generated: unreachable, please report bug.")
done:

	return nil
}

func (mj *NetworkInfo_PortMapping) MarshalJSON() ([]byte, error) {
	var buf fflib.Buffer
	if mj == nil {
		buf.WriteString("null")
		return buf.Bytes(), nil
	}
	err := mj.MarshalJSONBuf(&buf)
	if err != nil {
		return nil, err
	}
	return buf.Bytes(), nil
}
func (mj *NetworkInfo_PortMapping) MarshalJSONBuf(buf fflib.EncodingBuffer) error {
	if mj == nil {
		buf.WriteString("null")
		return nil
	}
	var err error
	var obj []byte
	_ = obj
	_ = err
	buf.WriteString(`{ "host_port":`)
	fflib.FormatBits2(buf, uint64(mj.HostPort), 10, false)
	buf.WriteString(`,"container_port":`)
	fflib.FormatBits2(buf, uint64(mj.ContainerPort), 10, false)
	buf.WriteByte(',')
	if mj.Protocol != nil {
		if true {
			buf.WriteString(`"protocol":`)
			fflib.WriteJsonString(buf, string(*mj.Protocol))
			buf.WriteByte(',')
		}
	}
	buf.Rewind(1)
	buf.WriteByte('}')
	return nil
}

const (
	ffj_t_NetworkInfo_PortMappingbase = iota
	ffj_t_NetworkInfo_PortMappingno_such_key

	ffj_t_NetworkInfo_PortMapping_HostPort

	ffj_t_NetworkInfo_PortMapping_ContainerPort

	ffj_t_NetworkInfo_PortMapping_Protocol
)

var ffj_key_NetworkInfo_PortMapping_HostPort = []byte("host_port")

var ffj_key_NetworkInfo_PortMapping_ContainerPort = []byte("container_port")

var ffj_key_NetworkInfo_PortMapping_Protocol = []byte("protocol")

func (uj *NetworkInfo_PortMapping) UnmarshalJSON(input []byte) error {
	fs := fflib.NewFFLexer(input)
	return uj.UnmarshalJSONFFLexer(fs, fflib.FFParse_map_start)
}

func (uj *NetworkInfo_PortMapping) UnmarshalJSONFFLexer(fs *fflib.FFLexer, state fflib.FFParseState) error {
	var err error = nil
	currentKey := ffj_t_NetworkInfo_PortMappingbase
	_ = currentKey
	tok := fflib.FFTok_init
	wantedTok := fflib.FFTok_init

mainparse:
	for {
		tok = fs.Scan()
		//	println(fmt.Sprintf("debug: tok: %v  state: %v", tok, state))
		if tok == fflib.FFTok_error {
			goto tokerror
		}

		switch state {

		case fflib.FFParse_map_start:
			if tok != fflib.FFTok_left_bracket {
				wantedTok = fflib.FFTok_left_bracket
				goto wrongtokenerror
			}
			state = fflib.FFParse_want_key
			continue

		case fflib.FFParse_after_value:
			if tok == fflib.FFTok_comma {
				state = fflib.FFParse_want_key
			} else if tok == fflib.FFTok_right_bracket {
				goto done
			} else {
				wantedTok = fflib.FFTok_comma
				goto wrongtokenerror
			}

		case fflib.FFParse_want_key:
			// json {} ended. goto exit. woo.
			if tok == fflib.FFTok_right_bracket {
				goto done
			}
			if tok != fflib.FFTok_string {
				wantedTok = fflib.FFTok_string
				goto wrongtokenerror
			}

			kn := fs.Output.Bytes()
			if len(kn) <= 0 {
				// "" case. hrm.
				currentKey = ffj_t_NetworkInfo_PortMappingno_such_key
				state = fflib.FFParse_want_colon
				goto mainparse
			} else {
				switch kn[0] {

				case 'c':

					if bytes.Equal(ffj_key_NetworkInfo_PortMapping_ContainerPort, kn) {
						currentKey = ffj_t_NetworkInfo_PortMapping_ContainerPort
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				case 'h':

					if bytes.Equal(ffj_key_NetworkInfo_PortMapping_HostPort, kn) {
						currentKey = ffj_t_NetworkInfo_PortMapping_HostPort
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				case 'p':

					if bytes.Equal(ffj_key_NetworkInfo_PortMapping_Protocol, kn) {
						currentKey = ffj_t_NetworkInfo_PortMapping_Protocol
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				}

				if fflib.SimpleLetterEqualFold(ffj_key_NetworkInfo_PortMapping_Protocol, kn) {
					currentKey = ffj_t_NetworkInfo_PortMapping_Protocol
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.AsciiEqualFold(ffj_key_NetworkInfo_PortMapping_ContainerPort, kn) {
					currentKey = ffj_t_NetworkInfo_PortMapping_ContainerPort
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffj_key_NetworkInfo_PortMapping_HostPort, kn) {
					currentKey = ffj_t_NetworkInfo_PortMapping_HostPort
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				currentKey = ffj_t_NetworkInfo_PortMappingno_such_key
				state = fflib.FFParse_want_colon
				goto mainparse
			}

		case fflib.FFParse_want_colon:
			if tok != fflib.FFTok_colon {
				wantedTok = fflib.FFTok_colon
				goto wrongtokenerror
			}
			state = fflib.FFParse_want_value
			continue
		case fflib.FFParse_want_value:

			if tok == fflib.FFTok_left_brace || tok == fflib.FFTok_left_bracket || tok == fflib.FFTok_integer || tok == fflib.FFTok_double || tok == fflib.FFTok_string || tok == fflib.FFTok_bool || tok == fflib.FFTok_null {
				switch currentKey {

				case ffj_t_NetworkInfo_PortMapping_HostPort:
					goto handle_HostPort

				case ffj_t_NetworkInfo_PortMapping_ContainerPort:
					goto handle_ContainerPort

				case ffj_t_NetworkInfo_PortMapping_Protocol:
					goto handle_Protocol

				case ffj_t_NetworkInfo_PortMappingno_such_key:
					err = fs.SkipField(tok)
					if err != nil {
						return fs.WrapErr(err)
					}
					state = fflib.FFParse_after_value
					goto mainparse
				}
			} else {
				goto wantedvalue
			}
		}
	}

handle_HostPort:

	/* handler: uj.HostPort type=uint32 kind=uint32 quoted=false*/

	{
		if tok != fflib.FFTok_integer && tok != fflib.FFTok_null {
			return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for uint32", tok))
		}
	}

	{

		if tok == fflib.FFTok_null {

		} else {

			tval, err := fflib.ParseUint(fs.Output.Bytes(), 10, 32)

			if err != nil {
				return fs.WrapErr(err)
			}

			uj.HostPort = uint32(tval)

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_ContainerPort:

	/* handler: uj.ContainerPort type=uint32 kind=uint32 quoted=false*/

	{
		if tok != fflib.FFTok_integer && tok != fflib.FFTok_null {
			return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for uint32", tok))
		}
	}

	{

		if tok == fflib.FFTok_null {

		} else {

			tval, err := fflib.ParseUint(fs.Output.Bytes(), 10, 32)

			if err != nil {
				return fs.WrapErr(err)
			}

			uj.ContainerPort = uint32(tval)

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_Protocol:

	/* handler: uj.Protocol type=string kind=string quoted=false*/

	{

		{
			if tok != fflib.FFTok_string && tok != fflib.FFTok_null {
				return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for string", tok))
			}
		}

		if tok == fflib.FFTok_null {

			uj.Protocol = nil

		} else {

			var tval string
			outBuf := fs.Output.Bytes()

			tval = string(string(outBuf))
			uj.Protocol = &tval

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

wantedvalue:
	return fs.WrapErr(fmt.Errorf("wanted value token, but got token: %v", tok))
wrongtokenerror:
	return fs.WrapErr(fmt.Errorf("ffjson: wanted token: %v, but got token: %v output=%s", wantedTok, tok, fs.Output.String()))
tokerror:
	if fs.BigError != nil {
		return fs.WrapErr(fs.BigError)
	}
	err = fs.Error.ToError()
	if err != nil {
		return fs.WrapErr(err)
	}
	panic("ffjson-generated: unreachable, please report bug.")
done:

	return nil
}

func (mj *Offer) MarshalJSON() ([]byte, error) {
	var buf fflib.Buffer
	if mj == nil {
		buf.WriteString("null")
		return buf.Bytes(), nil
	}
	err := mj.MarshalJSONBuf(&buf)
	if err != nil {
		return nil, err
	}
	return buf.Bytes(), nil
}
func (mj *Offer) MarshalJSONBuf(buf fflib.EncodingBuffer) error {
	if mj == nil {
		buf.WriteString("null")
		return nil
	}
	var err error
	var obj []byte
	_ = obj
	_ = err
	buf.WriteString(`{ "id":`)

	{

		err = mj.ID.MarshalJSONBuf(buf)
		if err != nil {
			return err
		}

	}
	buf.WriteString(`,"framework_id":`)

	{

		err = mj.FrameworkID.MarshalJSONBuf(buf)
		if err != nil {
			return err
		}

	}
	buf.WriteString(`,"agent_id":`)

	{

		err = mj.AgentID.MarshalJSONBuf(buf)
		if err != nil {
			return err
		}

	}
	buf.WriteString(`,"hostname":`)
	fflib.WriteJsonString(buf, string(mj.Hostname))
	buf.WriteByte(',')
	if mj.URL != nil {
		if true {
			buf.WriteString(`"url":`)

			{

				err = mj.URL.MarshalJSONBuf(buf)
				if err != nil {
					return err
				}

			}
			buf.WriteByte(',')
		}
	}
	if mj.Domain != nil {
		if true {
			buf.WriteString(`"domain":`)

			{

				err = mj.Domain.MarshalJSONBuf(buf)
				if err != nil {
					return err
				}

			}
			buf.WriteByte(',')
		}
	}
	buf.WriteString(`"resources":`)
	if mj.Resources != nil {
		buf.WriteString(`[`)
		for i, v := range mj.Resources {
			if i != 0 {
				buf.WriteString(`,`)
			}

			{

				err = v.MarshalJSONBuf(buf)
				if err != nil {
					return err
				}

			}
		}
		buf.WriteString(`]`)
	} else {
		buf.WriteString(`null`)
	}
	buf.WriteString(`,"attributes":`)
	if mj.Attributes != nil {
		buf.WriteString(`[`)
		for i, v := range mj.Attributes {
			if i != 0 {
				buf.WriteString(`,`)
			}

			{

				err = v.MarshalJSONBuf(buf)
				if err != nil {
					return err
				}

			}
		}
		buf.WriteString(`]`)
	} else {
		buf.WriteString(`null`)
	}
	buf.WriteString(`,"executor_ids":`)
	if mj.ExecutorIDs != nil {
		buf.WriteString(`[`)
		for i, v := range mj.ExecutorIDs {
			if i != 0 {
				buf.WriteString(`,`)
			}

			{

				err = v.MarshalJSONBuf(buf)
				if err != nil {
					return err
				}

			}
		}
		buf.WriteString(`]`)
	} else {
		buf.WriteString(`null`)
	}
	buf.WriteByte(',')
	if mj.Unavailability != nil {
		if true {
			buf.WriteString(`"unavailability":`)

			{

				err = mj.Unavailability.MarshalJSONBuf(buf)
				if err != nil {
					return err
				}

			}
			buf.WriteByte(',')
		}
	}
	if mj.AllocationInfo != nil {
		if true {
			buf.WriteString(`"allocation_info":`)

			{

				err = mj.AllocationInfo.MarshalJSONBuf(buf)
				if err != nil {
					return err
				}

			}
			buf.WriteByte(',')
		}
	}
	buf.Rewind(1)
	buf.WriteByte('}')
	return nil
}

const (
	ffj_t_Offerbase = iota
	ffj_t_Offerno_such_key

	ffj_t_Offer_ID

	ffj_t_Offer_FrameworkID

	ffj_t_Offer_AgentID

	ffj_t_Offer_Hostname

	ffj_t_Offer_URL

	ffj_t_Offer_Domain

	ffj_t_Offer_Resources

	ffj_t_Offer_Attributes

	ffj_t_Offer_ExecutorIDs

	ffj_t_Offer_Unavailability

	ffj_t_Offer_AllocationInfo
)

var ffj_key_Offer_ID = []byte("id")

var ffj_key_Offer_FrameworkID = []byte("framework_id")

var ffj_key_Offer_AgentID = []byte("agent_id")

var ffj_key_Offer_Hostname = []byte("hostname")

var ffj_key_Offer_URL = []byte("url")

var ffj_key_Offer_Domain = []byte("domain")

var ffj_key_Offer_Resources = []byte("resources")

var ffj_key_Offer_Attributes = []byte("attributes")

var ffj_key_Offer_ExecutorIDs = []byte("executor_ids")

var ffj_key_Offer_Unavailability = []byte("unavailability")

var ffj_key_Offer_AllocationInfo = []byte("allocation_info")

func (uj *Offer) UnmarshalJSON(input []byte) error {
	fs := fflib.NewFFLexer(input)
	return uj.UnmarshalJSONFFLexer(fs, fflib.FFParse_map_start)
}

func (uj *Offer) UnmarshalJSONFFLexer(fs *fflib.FFLexer, state fflib.FFParseState) error {
	var err error = nil
	currentKey := ffj_t_Offerbase
	_ = currentKey
	tok := fflib.FFTok_init
	wantedTok := fflib.FFTok_init

mainparse:
	for {
		tok = fs.Scan()
		//	println(fmt.Sprintf("debug: tok: %v  state: %v", tok, state))
		if tok == fflib.FFTok_error {
			goto tokerror
		}

		switch state {

		case fflib.FFParse_map_start:
			if tok != fflib.FFTok_left_bracket {
				wantedTok = fflib.FFTok_left_bracket
				goto wrongtokenerror
			}
			state = fflib.FFParse_want_key
			continue

		case fflib.FFParse_after_value:
			if tok == fflib.FFTok_comma {
				state = fflib.FFParse_want_key
			} else if tok == fflib.FFTok_right_bracket {
				goto done
			} else {
				wantedTok = fflib.FFTok_comma
				goto wrongtokenerror
			}

		case fflib.FFParse_want_key:
			// json {} ended. goto exit. woo.
			if tok == fflib.FFTok_right_bracket {
				goto done
			}
			if tok != fflib.FFTok_string {
				wantedTok = fflib.FFTok_string
				goto wrongtokenerror
			}

			kn := fs.Output.Bytes()
			if len(kn) <= 0 {
				// "" case. hrm.
				currentKey = ffj_t_Offerno_such_key
				state = fflib.FFParse_want_colon
				goto mainparse
			} else {
				switch kn[0] {

				case 'a':

					if bytes.Equal(ffj_key_Offer_AgentID, kn) {
						currentKey = ffj_t_Offer_AgentID
						state = fflib.FFParse_want_colon
						goto mainparse

					} else if bytes.Equal(ffj_key_Offer_Attributes, kn) {
						currentKey = ffj_t_Offer_Attributes
						state = fflib.FFParse_want_colon
						goto mainparse

					} else if bytes.Equal(ffj_key_Offer_AllocationInfo, kn) {
						currentKey = ffj_t_Offer_AllocationInfo
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				case 'd':

					if bytes.Equal(ffj_key_Offer_Domain, kn) {
						currentKey = ffj_t_Offer_Domain
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				case 'e':

					if bytes.Equal(ffj_key_Offer_ExecutorIDs, kn) {
						currentKey = ffj_t_Offer_ExecutorIDs
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				case 'f':

					if bytes.Equal(ffj_key_Offer_FrameworkID, kn) {
						currentKey = ffj_t_Offer_FrameworkID
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				case 'h':

					if bytes.Equal(ffj_key_Offer_Hostname, kn) {
						currentKey = ffj_t_Offer_Hostname
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				case 'i':

					if bytes.Equal(ffj_key_Offer_ID, kn) {
						currentKey = ffj_t_Offer_ID
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				case 'r':

					if bytes.Equal(ffj_key_Offer_Resources, kn) {
						currentKey = ffj_t_Offer_Resources
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				case 'u':

					if bytes.Equal(ffj_key_Offer_URL, kn) {
						currentKey = ffj_t_Offer_URL
						state = fflib.FFParse_want_colon
						goto mainparse

					} else if bytes.Equal(ffj_key_Offer_Unavailability, kn) {
						currentKey = ffj_t_Offer_Unavailability
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				}

				if fflib.AsciiEqualFold(ffj_key_Offer_AllocationInfo, kn) {
					currentKey = ffj_t_Offer_AllocationInfo
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.SimpleLetterEqualFold(ffj_key_Offer_Unavailability, kn) {
					currentKey = ffj_t_Offer_Unavailability
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffj_key_Offer_ExecutorIDs, kn) {
					currentKey = ffj_t_Offer_ExecutorIDs
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffj_key_Offer_Attributes, kn) {
					currentKey = ffj_t_Offer_Attributes
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffj_key_Offer_Resources, kn) {
					currentKey = ffj_t_Offer_Resources
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.SimpleLetterEqualFold(ffj_key_Offer_Domain, kn) {
					currentKey = ffj_t_Offer_Domain
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.SimpleLetterEqualFold(ffj_key_Offer_URL, kn) {
					currentKey = ffj_t_Offer_URL
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffj_key_Offer_Hostname, kn) {
					currentKey = ffj_t_Offer_Hostname
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.AsciiEqualFold(ffj_key_Offer_AgentID, kn) {
					currentKey = ffj_t_Offer_AgentID
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffj_key_Offer_FrameworkID, kn) {
					currentKey = ffj_t_Offer_FrameworkID
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.SimpleLetterEqualFold(ffj_key_Offer_ID, kn) {
					currentKey = ffj_t_Offer_ID
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				currentKey = ffj_t_Offerno_such_key
				state = fflib.FFParse_want_colon
				goto mainparse
			}

		case fflib.FFParse_want_colon:
			if tok != fflib.FFTok_colon {
				wantedTok = fflib.FFTok_colon
				goto wrongtokenerror
			}
			state = fflib.FFParse_want_value
			continue
		case fflib.FFParse_want_value:

			if tok == fflib.FFTok_left_brace || tok == fflib.FFTok_left_bracket || tok == fflib.FFTok_integer || tok == fflib.FFTok_double || tok == fflib.FFTok_string || tok == fflib.FFTok_bool || tok == fflib.FFTok_null {
				switch currentKey {

				case ffj_t_Offer_ID:
					goto handle_ID

				case ffj_t_Offer_FrameworkID:
					goto handle_FrameworkID

				case ffj_t_Offer_AgentID:
					goto handle_AgentID

				case ffj_t_Offer_Hostname:
					goto handle_Hostname

				case ffj_t_Offer_URL:
					goto handle_URL

				case ffj_t_Offer_Domain:
					goto handle_Domain

				case ffj_t_Offer_Resources:
					goto handle_Resources

				case ffj_t_Offer_Attributes:
					goto handle_Attributes

				case ffj_t_Offer_ExecutorIDs:
					goto handle_ExecutorIDs

				case ffj_t_Offer_Unavailability:
					goto handle_Unavailability

				case ffj_t_Offer_AllocationInfo:
					goto handle_AllocationInfo

				case ffj_t_Offerno_such_key:
					err = fs.SkipField(tok)
					if err != nil {
						return fs.WrapErr(err)
					}
					state = fflib.FFParse_after_value
					goto mainparse
				}
			} else {
				goto wantedvalue
			}
		}
	}

handle_ID:

	/* handler: uj.ID type=mesos.OfferID kind=struct quoted=false*/

	{
		if tok == fflib.FFTok_null {

			state = fflib.FFParse_after_value
			goto mainparse
		}

		err = uj.ID.UnmarshalJSONFFLexer(fs, fflib.FFParse_want_key)
		if err != nil {
			return err
		}
		state = fflib.FFParse_after_value
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_FrameworkID:

	/* handler: uj.FrameworkID type=mesos.FrameworkID kind=struct quoted=false*/

	{
		if tok == fflib.FFTok_null {

			state = fflib.FFParse_after_value
			goto mainparse
		}

		err = uj.FrameworkID.UnmarshalJSONFFLexer(fs, fflib.FFParse_want_key)
		if err != nil {
			return err
		}
		state = fflib.FFParse_after_value
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_AgentID:

	/* handler: uj.AgentID type=mesos.AgentID kind=struct quoted=false*/

	{
		if tok == fflib.FFTok_null {

			state = fflib.FFParse_after_value
			goto mainparse
		}

		err = uj.AgentID.UnmarshalJSONFFLexer(fs, fflib.FFParse_want_key)
		if err != nil {
			return err
		}
		state = fflib.FFParse_after_value
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_Hostname:

	/* handler: uj.Hostname type=string kind=string quoted=false*/

	{

		{
			if tok != fflib.FFTok_string && tok != fflib.FFTok_null {
				return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for string", tok))
			}
		}

		if tok == fflib.FFTok_null {

		} else {

			outBuf := fs.Output.Bytes()

			uj.Hostname = string(string(outBuf))

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_URL:

	/* handler: uj.URL type=mesos.URL kind=struct quoted=false*/

	{
		if tok == fflib.FFTok_null {

			uj.URL = nil

			state = fflib.FFParse_after_value
			goto mainparse
		}

		if uj.URL == nil {
			uj.URL = new(URL)
		}

		err = uj.URL.UnmarshalJSONFFLexer(fs, fflib.FFParse_want_key)
		if err != nil {
			return err
		}
		state = fflib.FFParse_after_value
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_Domain:

	/* handler: uj.Domain type=mesos.DomainInfo kind=struct quoted=false*/

	{
		if tok == fflib.FFTok_null {

			uj.Domain = nil

			state = fflib.FFParse_after_value
			goto mainparse
		}

		if uj.Domain == nil {
			uj.Domain = new(DomainInfo)
		}

		err = uj.Domain.UnmarshalJSONFFLexer(fs, fflib.FFParse_want_key)
		if err != nil {
			return err
		}
		state = fflib.FFParse_after_value
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_Resources:

	/* handler: uj.Resources type=[]mesos.Resource kind=slice quoted=false*/

	{

		{
			if tok != fflib.FFTok_left_brace && tok != fflib.FFTok_null {
				return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for ", tok))
			}
		}

		if tok == fflib.FFTok_null {
			uj.Resources = nil
		} else {

			uj.Resources = []Resource{}

			wantVal := true

			for {

				var tmp_uj__Resources Resource

				tok = fs.Scan()
				if tok == fflib.FFTok_error {
					goto tokerror
				}
				if tok == fflib.FFTok_right_brace {
					break
				}

				if tok == fflib.FFTok_comma {
					if wantVal == true {
						// TODO(pquerna): this isn't an ideal error message, this handles
						// things like [,,,] as an array value.
						return fs.WrapErr(fmt.Errorf("wanted value token, but got token: %v", tok))
					}
					continue
				} else {
					wantVal = true
				}

				/* handler: tmp_uj__Resources type=mesos.Resource kind=struct quoted=false*/

				{
					if tok == fflib.FFTok_null {

						state = fflib.FFParse_after_value
						goto mainparse
					}

					err = tmp_uj__Resources.UnmarshalJSONFFLexer(fs, fflib.FFParse_want_key)
					if err != nil {
						return err
					}
					state = fflib.FFParse_after_value
				}

				uj.Resources = append(uj.Resources, tmp_uj__Resources)

				wantVal = false
			}
		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_Attributes:

	/* handler: uj.Attributes type=[]mesos.Attribute kind=slice quoted=false*/

	{

		{
			if tok != fflib.FFTok_left_brace && tok != fflib.FFTok_null {
				return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for ", tok))
			}
		}

		if tok == fflib.FFTok_null {
			uj.Attributes = nil
		} else {

			uj.Attributes = []Attribute{}

			wantVal := true

			for {

				var tmp_uj__Attributes Attribute

				tok = fs.Scan()
				if tok == fflib.FFTok_error {
					goto tokerror
				}
				if tok == fflib.FFTok_right_brace {
					break
				}

				if tok == fflib.FFTok_comma {
					if wantVal == true {
						// TODO(pquerna): this isn't an ideal error message, this handles
						// things like [,,,] as an array value.
						return fs.WrapErr(fmt.Errorf("wanted value token, but got token: %v", tok))
					}
					continue
				} else {
					wantVal = true
				}

				/* handler: tmp_uj__Attributes type=mesos.Attribute kind=struct quoted=false*/

				{
					if tok == fflib.FFTok_null {

						state = fflib.FFParse_after_value
						goto mainparse
					}

					err = tmp_uj__Attributes.UnmarshalJSONFFLexer(fs, fflib.FFParse_want_key)
					if err != nil {
						return err
					}
					state = fflib.FFParse_after_value
				}

				uj.Attributes = append(uj.Attributes, tmp_uj__Attributes)

				wantVal = false
			}
		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_ExecutorIDs:

	/* handler: uj.ExecutorIDs type=[]mesos.ExecutorID kind=slice quoted=false*/

	{

		{
			if tok != fflib.FFTok_left_brace && tok != fflib.FFTok_null {
				return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for ", tok))
			}
		}

		if tok == fflib.FFTok_null {
			uj.ExecutorIDs = nil
		} else {

			uj.ExecutorIDs = []ExecutorID{}

			wantVal := true

			for {

				var tmp_uj__ExecutorIDs ExecutorID

				tok = fs.Scan()
				if tok == fflib.FFTok_error {
					goto tokerror
				}
				if tok == fflib.FFTok_right_brace {
					break
				}

				if tok == fflib.FFTok_comma {
					if wantVal == true {
						// TODO(pquerna): this isn't an ideal error message, this handles
						// things like [,,,] as an array value.
						return fs.WrapErr(fmt.Errorf("wanted value token, but got token: %v", tok))
					}
					continue
				} else {
					wantVal = true
				}

				/* handler: tmp_uj__ExecutorIDs type=mesos.ExecutorID kind=struct quoted=false*/

				{
					if tok == fflib.FFTok_null {

						state = fflib.FFParse_after_value
						goto mainparse
					}

					err = tmp_uj__ExecutorIDs.UnmarshalJSONFFLexer(fs, fflib.FFParse_want_key)
					if err != nil {
						return err
					}
					state = fflib.FFParse_after_value
				}

				uj.ExecutorIDs = append(uj.ExecutorIDs, tmp_uj__ExecutorIDs)

				wantVal = false
			}
		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_Unavailability:

	/* handler: uj.Unavailability type=mesos.Unavailability kind=struct quoted=false*/

	{
		if tok == fflib.FFTok_null {

			uj.Unavailability = nil

			state = fflib.FFParse_after_value
			goto mainparse
		}

		if uj.Unavailability == nil {
			uj.Unavailability = new(Unavailability)
		}

		err = uj.Unavailability.UnmarshalJSONFFLexer(fs, fflib.FFParse_want_key)
		if err != nil {
			return err
		}
		state = fflib.FFParse_after_value
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_AllocationInfo:

	/* handler: uj.AllocationInfo type=mesos.Resource_AllocationInfo kind=struct quoted=false*/

	{
		if tok == fflib.FFTok_null {

			uj.AllocationInfo = nil

			state = fflib.FFParse_after_value
			goto mainparse
		}

		if uj.AllocationInfo == nil {
			uj.AllocationInfo = new(Resource_AllocationInfo)
		}

		err = uj.AllocationInfo.UnmarshalJSONFFLexer(fs, fflib.FFParse_want_key)
		if err != nil {
			return err
		}
		state = fflib.FFParse_after_value
	}

	state = fflib.FFParse_after_value
	goto mainparse

wantedvalue:
	return fs.WrapErr(fmt.Errorf("wanted value token, but got token: %v", tok))
wrongtokenerror:
	return fs.WrapErr(fmt.Errorf("ffjson: wanted token: %v, but got token: %v output=%s", wantedTok, tok, fs.Output.String()))
tokerror:
	if fs.BigError != nil {
		return fs.WrapErr(fs.BigError)
	}
	err = fs.Error.ToError()
	if err != nil {
		return fs.WrapErr(err)
	}
	panic("ffjson-generated: unreachable, please report bug.")
done:

	return nil
}

func (mj *OfferFilters) MarshalJSON() ([]byte, error) {
	var buf fflib.Buffer
	if mj == nil {
		buf.WriteString("null")
		return buf.Bytes(), nil
	}
	err := mj.MarshalJSONBuf(&buf)
	if err != nil {
		return nil, err
	}
	return buf.Bytes(), nil
}
func (mj *OfferFilters) MarshalJSONBuf(buf fflib.EncodingBuffer) error {
	if mj == nil {
		buf.WriteString("null")
		return nil
	}
	var err error
	var obj []byte
	_ = obj
	_ = err
	buf.WriteString(`{ `)
	if mj.MinAllocatableResources != nil {
		if true {
			buf.WriteString(`"min_allocatable_resources":`)

			{

				err = mj.MinAllocatableResources.MarshalJSONBuf(buf)
				if err != nil {
					return err
				}

			}
			buf.WriteByte(',')
		}
	}
	buf.Rewind(1)
	buf.WriteByte('}')
	return nil
}

const (
	ffj_t_OfferFiltersbase = iota
	ffj_t_OfferFiltersno_such_key

	ffj_t_OfferFilters_MinAllocatableResources
)

var ffj_key_OfferFilters_MinAllocatableResources = []byte("min_allocatable_resources")

func (uj *OfferFilters) UnmarshalJSON(input []byte) error {
	fs := fflib.NewFFLexer(input)
	return uj.UnmarshalJSONFFLexer(fs, fflib.FFParse_map_start)
}

func (uj *OfferFilters) UnmarshalJSONFFLexer(fs *fflib.FFLexer, state fflib.FFParseState) error {
	var err error = nil
	currentKey := ffj_t_OfferFiltersbase
	_ = currentKey
	tok := fflib.FFTok_init
	wantedTok := fflib.FFTok_init

mainparse:
	for {
		tok = fs.Scan()
		//	println(fmt.Sprintf("debug: tok: %v  state: %v", tok, state))
		if tok == fflib.FFTok_error {
			goto tokerror
		}

		switch state {

		case fflib.FFParse_map_start:
			if tok != fflib.FFTok_left_bracket {
				wantedTok = fflib.FFTok_left_bracket
				goto wrongtokenerror
			}
			state = fflib.FFParse_want_key
			continue

		case fflib.FFParse_after_value:
			if tok == fflib.FFTok_comma {
				state = fflib.FFParse_want_key
			} else if tok == fflib.FFTok_right_bracket {
				goto done
			} else {
				wantedTok = fflib.FFTok_comma
				goto wrongtokenerror
			}

		case fflib.FFParse_want_key:
			// json {} ended. goto exit. woo.
			if tok == fflib.FFTok_right_bracket {
				goto done
			}
			if tok != fflib.FFTok_string {
				wantedTok = fflib.FFTok_string
				goto wrongtokenerror
			}

			kn := fs.Output.Bytes()
			if len(kn) <= 0 {
				// "" case. hrm.
				currentKey = ffj_t_OfferFiltersno_such_key
				state = fflib.FFParse_want_colon
				goto mainparse
			} else {
				switch kn[0] {

				case 'm':

					if bytes.Equal(ffj_key_OfferFilters_MinAllocatableResources, kn) {
						currentKey = ffj_t_OfferFilters_MinAllocatableResources
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				}

				if fflib.EqualFoldRight(ffj_key_OfferFilters_MinAllocatableResources, kn) {
					currentKey = ffj_t_OfferFilters_MinAllocatableResources
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				currentKey = ffj_t_OfferFiltersno_such_key
				state = fflib.FFParse_want_colon
				goto mainparse
			}

		case fflib.FFParse_want_colon:
			if tok != fflib.FFTok_colon {
				wantedTok = fflib.FFTok_colon
				goto wrongtokenerror
			}
			state = fflib.FFParse_want_value
			continue
		case fflib.FFParse_want_value:

			if tok == fflib.FFTok_left_brace || tok == fflib.FFTok_left_bracket || tok == fflib.FFTok_integer || tok == fflib.FFTok_double || tok == fflib.FFTok_string || tok == fflib.FFTok_bool || tok == fflib.FFTok_null {
				switch currentKey {

				case ffj_t_OfferFilters_MinAllocatableResources:
					goto handle_MinAllocatableResources

				case ffj_t_OfferFiltersno_such_key:
					err = fs.SkipField(tok)
					if err != nil {
						return fs.WrapErr(err)
					}
					state = fflib.FFParse_after_value
					goto mainparse
				}
			} else {
				goto wantedvalue
			}
		}
	}

handle_MinAllocatableResources:

	/* handler: uj.MinAllocatableResources type=mesos.OfferFilters_MinAllocatableResources kind=struct quoted=false*/

	{
		if tok == fflib.FFTok_null {

			uj.MinAllocatableResources = nil

			state = fflib.FFParse_after_value
			goto mainparse
		}

		if uj.MinAllocatableResources == nil {
			uj.MinAllocatableResources = new(OfferFilters_MinAllocatableResources)
		}

		err = uj.MinAllocatableResources.UnmarshalJSONFFLexer(fs, fflib.FFParse_want_key)
		if err != nil {
			return err
		}
		state = fflib.FFParse_after_value
	}

	state = fflib.FFParse_after_value
	goto mainparse

wantedvalue:
	return fs.WrapErr(fmt.Errorf("wanted value token, but got token: %v", tok))
wrongtokenerror:
	return fs.WrapErr(fmt.Errorf("ffjson: wanted token: %v, but got token: %v output=%s", wantedTok, tok, fs.Output.String()))
tokerror:
	if fs.BigError != nil {
		return fs.WrapErr(fs.BigError)
	}
	err = fs.Error.ToError()
	if err != nil {
		return fs.WrapErr(err)
	}
	panic("ffjson-generated: unreachable, please report bug.")
done:

	return nil
}

func (mj *OfferFilters_MinAllocatableResources) MarshalJSON() ([]byte, error) {
	var buf fflib.Buffer
	if mj == nil {
		buf.WriteString("null")
		return buf.Bytes(), nil
	}
	err := mj.MarshalJSONBuf(&buf)
	if err != nil {
		return nil, err
	}
	return buf.Bytes(), nil
}
func (mj *OfferFilters_MinAllocatableResources) MarshalJSONBuf(buf fflib.EncodingBuffer) error {
	if mj == nil {
		buf.WriteString("null")
		return nil
	}
	var err error
	var obj []byte
	_ = obj
	_ = err
	buf.WriteString(`{"quantities":`)
	if mj.Quantities != nil {
		buf.WriteString(`[`)
		for i, v := range mj.Quantities {
			if i != 0 {
				buf.WriteString(`,`)
			}

			{

				err = v.MarshalJSONBuf(buf)
				if err != nil {
					return err
				}

			}
		}
		buf.WriteString(`]`)
	} else {
		buf.WriteString(`null`)
	}
	buf.WriteByte('}')
	return nil
}

const (
	ffj_t_OfferFilters_MinAllocatableResourcesbase = iota
	ffj_t_OfferFilters_MinAllocatableResourcesno_such_key

	ffj_t_OfferFilters_MinAllocatableResources_Quantities
)

var ffj_key_OfferFilters_MinAllocatableResources_Quantities = []byte("quantities")

func (uj *OfferFilters_MinAllocatableResources) UnmarshalJSON(input []byte) error {
	fs := fflib.NewFFLexer(input)
	return uj.UnmarshalJSONFFLexer(fs, fflib.FFParse_map_start)
}

func (uj *OfferFilters_MinAllocatableResources) UnmarshalJSONFFLexer(fs *fflib.FFLexer, state fflib.FFParseState) error {
	var err error = nil
	currentKey := ffj_t_OfferFilters_MinAllocatableResourcesbase
	_ = currentKey
	tok := fflib.FFTok_init
	wantedTok := fflib.FFTok_init

mainparse:
	for {
		tok = fs.Scan()
		//	println(fmt.Sprintf("debug: tok: %v  state: %v", tok, state))
		if tok == fflib.FFTok_error {
			goto tokerror
		}

		switch state {

		case fflib.FFParse_map_start:
			if tok != fflib.FFTok_left_bracket {
				wantedTok = fflib.FFTok_left_bracket
				goto wrongtokenerror
			}
			state = fflib.FFParse_want_key
			continue

		case fflib.FFParse_after_value:
			if tok == fflib.FFTok_comma {
				state = fflib.FFParse_want_key
			} else if tok == fflib.FFTok_right_bracket {
				goto done
			} else {
				wantedTok = fflib.FFTok_comma
				goto wrongtokenerror
			}

		case fflib.FFParse_want_key:
			// json {} ended. goto exit. woo.
			if tok == fflib.FFTok_right_bracket {
				goto done
			}
			if tok != fflib.FFTok_string {
				wantedTok = fflib.FFTok_string
				goto wrongtokenerror
			}

			kn := fs.Output.Bytes()
			if len(kn) <= 0 {
				// "" case. hrm.
				currentKey = ffj_t_OfferFilters_MinAllocatableResourcesno_such_key
				state = fflib.FFParse_want_colon
				goto mainparse
			} else {
				switch kn[0] {

				case 'q':

					if bytes.Equal(ffj_key_OfferFilters_MinAllocatableResources_Quantities, kn) {
						currentKey = ffj_t_OfferFilters_MinAllocatableResources_Quantities
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				}

				if fflib.EqualFoldRight(ffj_key_OfferFilters_MinAllocatableResources_Quantities, kn) {
					currentKey = ffj_t_OfferFilters_MinAllocatableResources_Quantities
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				currentKey = ffj_t_OfferFilters_MinAllocatableResourcesno_such_key
				state = fflib.FFParse_want_colon
				goto mainparse
			}

		case fflib.FFParse_want_colon:
			if tok != fflib.FFTok_colon {
				wantedTok = fflib.FFTok_colon
				goto wrongtokenerror
			}
			state = fflib.FFParse_want_value
			continue
		case fflib.FFParse_want_value:

			if tok == fflib.FFTok_left_brace || tok == fflib.FFTok_left_bracket || tok == fflib.FFTok_integer || tok == fflib.FFTok_double || tok == fflib.FFTok_string || tok == fflib.FFTok_bool || tok == fflib.FFTok_null {
				switch currentKey {

				case ffj_t_OfferFilters_MinAllocatableResources_Quantities:
					goto handle_Quantities

				case ffj_t_OfferFilters_MinAllocatableResourcesno_such_key:
					err = fs.SkipField(tok)
					if err != nil {
						return fs.WrapErr(err)
					}
					state = fflib.FFParse_after_value
					goto mainparse
				}
			} else {
				goto wantedvalue
			}
		}
	}

handle_Quantities:

	/* handler: uj.Quantities type=[]mesos.OfferFilters_ResourceQuantities kind=slice quoted=false*/

	{

		{
			if tok != fflib.FFTok_left_brace && tok != fflib.FFTok_null {
				return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for ", tok))
			}
		}

		if tok == fflib.FFTok_null {
			uj.Quantities = nil
		} else {

			uj.Quantities = []OfferFilters_ResourceQuantities{}

			wantVal := true

			for {

				var tmp_uj__Quantities OfferFilters_ResourceQuantities

				tok = fs.Scan()
				if tok == fflib.FFTok_error {
					goto tokerror
				}
				if tok == fflib.FFTok_right_brace {
					break
				}

				if tok == fflib.FFTok_comma {
					if wantVal == true {
						// TODO(pquerna): this isn't an ideal error message, this handles
						// things like [,,,] as an array value.
						return fs.WrapErr(fmt.Errorf("wanted value token, but got token: %v", tok))
					}
					continue
				} else {
					wantVal = true
				}

				/* handler: tmp_uj__Quantities type=mesos.OfferFilters_ResourceQuantities kind=struct quoted=false*/

				{
					if tok == fflib.FFTok_null {

						state = fflib.FFParse_after_value
						goto mainparse
					}

					err = tmp_uj__Quantities.UnmarshalJSONFFLexer(fs, fflib.FFParse_want_key)
					if err != nil {
						return err
					}
					state = fflib.FFParse_after_value
				}

				uj.Quantities = append(uj.Quantities, tmp_uj__Quantities)

				wantVal = false
			}
		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

wantedvalue:
	return fs.WrapErr(fmt.Errorf("wanted value token, but got token: %v", tok))
wrongtokenerror:
	return fs.WrapErr(fmt.Errorf("ffjson: wanted token: %v, but got token: %v output=%s", wantedTok, tok, fs.Output.String()))
tokerror:
	if fs.BigError != nil {
		return fs.WrapErr(fs.BigError)
	}
	err = fs.Error.ToError()
	if err != nil {
		return fs.WrapErr(err)
	}
	panic("ffjson-generated: unreachable, please report bug.")
done:

	return nil
}

func (mj *OfferFilters_ResourceQuantities) MarshalJSON() ([]byte, error) {
	var buf fflib.Buffer
	if mj == nil {
		buf.WriteString("null")
		return buf.Bytes(), nil
	}
	err := mj.MarshalJSONBuf(&buf)
	if err != nil {
		return nil, err
	}
	return buf.Bytes(), nil
}
func (mj *OfferFilters_ResourceQuantities) MarshalJSONBuf(buf fflib.EncodingBuffer) error {
	if mj == nil {
		buf.WriteString("null")
		return nil
	}
	var err error
	var obj []byte
	_ = obj
	_ = err
	buf.WriteString(`{"quantities":`)
	/* Falling back. type=map[string]mesos.Value_Scalar kind=map */
	err = buf.Encode(mj.Quantities)
	if err != nil {
		return err
	}
	buf.WriteByte('}')
	return nil
}

const (
	ffj_t_OfferFilters_ResourceQuantitiesbase = iota
	ffj_t_OfferFilters_ResourceQuantitiesno_such_key

	ffj_t_OfferFilters_ResourceQuantities_Quantities
)

var ffj_key_OfferFilters_ResourceQuantities_Quantities = []byte("quantities")

func (uj *OfferFilters_ResourceQuantities) UnmarshalJSON(input []byte) error {
	fs := fflib.NewFFLexer(input)
	return uj.UnmarshalJSONFFLexer(fs, fflib.FFParse_map_start)
}

func (uj *OfferFilters_ResourceQuantities) UnmarshalJSONFFLexer(fs *fflib.FFLexer, state fflib.FFParseState) error {
	var err error = nil
	currentKey := ffj_t_OfferFilters_ResourceQuantitiesbase
	_ = currentKey
	tok := fflib.FFTok_init
	wantedTok := fflib.FFTok_init

mainparse:
	for {
		tok = fs.Scan()
		//	println(fmt.Sprintf("debug: tok: %v  state: %v", tok, state))
		if tok == fflib.FFTok_error {
			goto tokerror
		}

		switch state {

		case fflib.FFParse_map_start:
			if tok != fflib.FFTok_left_bracket {
				wantedTok = fflib.FFTok_left_bracket
				goto wrongtokenerror
			}
			state = fflib.FFParse_want_key
			continue

		case fflib.FFParse_after_value:
			if tok == fflib.FFTok_comma {
				state = fflib.FFParse_want_key
			} else if tok == fflib.FFTok_right_bracket {
				goto done
			} else {
				wantedTok = fflib.FFTok_comma
				goto wrongtokenerror
			}

		case fflib.FFParse_want_key:
			// json {} ended. goto exit. woo.
			if tok == fflib.FFTok_right_bracket {
				goto done
			}
			if tok != fflib.FFTok_string {
				wantedTok = fflib.FFTok_string
				goto wrongtokenerror
			}

			kn := fs.Output.Bytes()
			if len(kn) <= 0 {
				// "" case. hrm.
				currentKey = ffj_t_OfferFilters_ResourceQuantitiesno_such_key
				state = fflib.FFParse_want_colon
				goto mainparse
			} else {
				switch kn[0] {

				case 'q':

					if bytes.Equal(ffj_key_OfferFilters_ResourceQuantities_Quantities, kn) {
						currentKey = ffj_t_OfferFilters_ResourceQuantities_Quantities
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				}

				if fflib.EqualFoldRight(ffj_key_OfferFilters_ResourceQuantities_Quantities, kn) {
					currentKey = ffj_t_OfferFilters_ResourceQuantities_Quantities
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				currentKey = ffj_t_OfferFilters_ResourceQuantitiesno_such_key
				state = fflib.FFParse_want_colon
				goto mainparse
			}

		case fflib.FFParse_want_colon:
			if tok != fflib.FFTok_colon {
				wantedTok = fflib.FFTok_colon
				goto wrongtokenerror
			}
			state = fflib.FFParse_want_value
			continue
		case fflib.FFParse_want_value:

			if tok == fflib.FFTok_left_brace || tok == fflib.FFTok_left_bracket || tok == fflib.FFTok_integer || tok == fflib.FFTok_double || tok == fflib.FFTok_string || tok == fflib.FFTok_bool || tok == fflib.FFTok_null {
				switch currentKey {

				case ffj_t_OfferFilters_ResourceQuantities_Quantities:
					goto handle_Quantities

				case ffj_t_OfferFilters_ResourceQuantitiesno_such_key:
					err = fs.SkipField(tok)
					if err != nil {
						return fs.WrapErr(err)
					}
					state = fflib.FFParse_after_value
					goto mainparse
				}
			} else {
				goto wantedvalue
			}
		}
	}

handle_Quantities:

	/* handler: uj.Quantities type=map[string]mesos.Value_Scalar kind=map quoted=false*/

	{

		{
			if tok != fflib.FFTok_left_bracket && tok != fflib.FFTok_null {
				return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for ", tok))
			}
		}

		if tok == fflib.FFTok_null {
			uj.Quantities = nil
		} else {

			uj.Quantities = make(map[string]Value_Scalar, 0)

			wantVal := true

			for {

				var k string

				var tmp_uj__Quantities Value_Scalar

				tok = fs.Scan()
				if tok == fflib.FFTok_error {
					goto tokerror
				}
				if tok == fflib.FFTok_right_bracket {
					break
				}

				if tok == fflib.FFTok_comma {
					if wantVal == true {
						// TODO(pquerna): this isn't an ideal error message, this handles
						// things like [,,,] as an array value.
						return fs.WrapErr(fmt.Errorf("wanted value token, but got token: %v", tok))
					}
					continue
				} else {
					wantVal = true
				}

				/* handler: k type=string kind=string quoted=false*/

				{

					{
						if tok != fflib.FFTok_string && tok != fflib.FFTok_null {
							return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for string", tok))
						}
					}

					if tok == fflib.FFTok_null {

					} else {

						outBuf := fs.Output.Bytes()

						k = string(string(outBuf))

					}
				}

				// Expect ':' after key
				tok = fs.Scan()
				if tok != fflib.FFTok_colon {
					return fs.WrapErr(fmt.Errorf("wanted colon token, but got token: %v", tok))
				}

				tok = fs.Scan()
				/* handler: tmp_uj__Quantities type=mesos.Value_Scalar kind=struct quoted=false*/

				{
					if tok == fflib.FFTok_null {

						state = fflib.FFParse_after_value
						goto mainparse
					}

					err = tmp_uj__Quantities.UnmarshalJSONFFLexer(fs, fflib.FFParse_want_key)
					if err != nil {
						return err
					}
					state = fflib.FFParse_after_value
				}

				uj.Quantities[k] = tmp_uj__Quantities

				wantVal = false
			}

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

wantedvalue:
	return fs.WrapErr(fmt.Errorf("wanted value token, but got token: %v", tok))
wrongtokenerror:
	return fs.WrapErr(fmt.Errorf("ffjson: wanted token: %v, but got token: %v output=%s", wantedTok, tok, fs.Output.String()))
tokerror:
	if fs.BigError != nil {
		return fs.WrapErr(fs.BigError)
	}
	err = fs.Error.ToError()
	if err != nil {
		return fs.WrapErr(err)
	}
	panic("ffjson-generated: unreachable, please report bug.")
done:

	return nil
}

func (mj *OfferID) MarshalJSON() ([]byte, error) {
	var buf fflib.Buffer
	if mj == nil {
		buf.WriteString("null")
		return buf.Bytes(), nil
	}
	err := mj.MarshalJSONBuf(&buf)
	if err != nil {
		return nil, err
	}
	return buf.Bytes(), nil
}
func (mj *OfferID) MarshalJSONBuf(buf fflib.EncodingBuffer) error {
	if mj == nil {
		buf.WriteString("null")
		return nil
	}
	var err error
	var obj []byte
	_ = obj
	_ = err
	buf.WriteString(`{"value":`)
	fflib.WriteJsonString(buf, string(mj.Value))
	buf.WriteByte('}')
	return nil
}

const (
	ffj_t_OfferIDbase = iota
	ffj_t_OfferIDno_such_key

	ffj_t_OfferID_Value
)

var ffj_key_OfferID_Value = []byte("value")

func (uj *OfferID) UnmarshalJSON(input []byte) error {
	fs := fflib.NewFFLexer(input)
	return uj.UnmarshalJSONFFLexer(fs, fflib.FFParse_map_start)
}

func (uj *OfferID) UnmarshalJSONFFLexer(fs *fflib.FFLexer, state fflib.FFParseState) error {
	var err error = nil
	currentKey := ffj_t_OfferIDbase
	_ = currentKey
	tok := fflib.FFTok_init
	wantedTok := fflib.FFTok_init

mainparse:
	for {
		tok = fs.Scan()
		//	println(fmt.Sprintf("debug: tok: %v  state: %v", tok, state))
		if tok == fflib.FFTok_error {
			goto tokerror
		}

		switch state {

		case fflib.FFParse_map_start:
			if tok != fflib.FFTok_left_bracket {
				wantedTok = fflib.FFTok_left_bracket
				goto wrongtokenerror
			}
			state = fflib.FFParse_want_key
			continue

		case fflib.FFParse_after_value:
			if tok == fflib.FFTok_comma {
				state = fflib.FFParse_want_key
			} else if tok == fflib.FFTok_right_bracket {
				goto done
			} else {
				wantedTok = fflib.FFTok_comma
				goto wrongtokenerror
			}

		case fflib.FFParse_want_key:
			// json {} ended. goto exit. woo.
			if tok == fflib.FFTok_right_bracket {
				goto done
			}
			if tok != fflib.FFTok_string {
				wantedTok = fflib.FFTok_string
				goto wrongtokenerror
			}

			kn := fs.Output.Bytes()
			if len(kn) <= 0 {
				// "" case. hrm.
				currentKey = ffj_t_OfferIDno_such_key
				state = fflib.FFParse_want_colon
				goto mainparse
			} else {
				switch kn[0] {

				case 'v':

					if bytes.Equal(ffj_key_OfferID_Value, kn) {
						currentKey = ffj_t_OfferID_Value
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				}

				if fflib.SimpleLetterEqualFold(ffj_key_OfferID_Value, kn) {
					currentKey = ffj_t_OfferID_Value
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				currentKey = ffj_t_OfferIDno_such_key
				state = fflib.FFParse_want_colon
				goto mainparse
			}

		case fflib.FFParse_want_colon:
			if tok != fflib.FFTok_colon {
				wantedTok = fflib.FFTok_colon
				goto wrongtokenerror
			}
			state = fflib.FFParse_want_value
			continue
		case fflib.FFParse_want_value:

			if tok == fflib.FFTok_left_brace || tok == fflib.FFTok_left_bracket || tok == fflib.FFTok_integer || tok == fflib.FFTok_double || tok == fflib.FFTok_string || tok == fflib.FFTok_bool || tok == fflib.FFTok_null {
				switch currentKey {

				case ffj_t_OfferID_Value:
					goto handle_Value

				case ffj_t_OfferIDno_such_key:
					err = fs.SkipField(tok)
					if err != nil {
						return fs.WrapErr(err)
					}
					state = fflib.FFParse_after_value
					goto mainparse
				}
			} else {
				goto wantedvalue
			}
		}
	}

handle_Value:

	/* handler: uj.Value type=string kind=string quoted=false*/

	{

		{
			if tok != fflib.FFTok_string && tok != fflib.FFTok_null {
				return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for string", tok))
			}
		}

		if tok == fflib.FFTok_null {

		} else {

			outBuf := fs.Output.Bytes()

			uj.Value = string(string(outBuf))

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

wantedvalue:
	return fs.WrapErr(fmt.Errorf("wanted value token, but got token: %v", tok))
wrongtokenerror:
	return fs.WrapErr(fmt.Errorf("ffjson: wanted token: %v, but got token: %v output=%s", wantedTok, tok, fs.Output.String()))
tokerror:
	if fs.BigError != nil {
		return fs.WrapErr(fs.BigError)
	}
	err = fs.Error.ToError()
	if err != nil {
		return fs.WrapErr(err)
	}
	panic("ffjson-generated: unreachable, please report bug.")
done:

	return nil
}

func (mj *Offer_Operation) MarshalJSON() ([]byte, error) {
	var buf fflib.Buffer
	if mj == nil {
		buf.WriteString("null")
		return buf.Bytes(), nil
	}
	err := mj.MarshalJSONBuf(&buf)
	if err != nil {
		return nil, err
	}
	return buf.Bytes(), nil
}
func (mj *Offer_Operation) MarshalJSONBuf(buf fflib.EncodingBuffer) error {
	if mj == nil {
		buf.WriteString("null")
		return nil
	}
	var err error
	var obj []byte
	_ = obj
	_ = err
	buf.WriteString(`{ "type":`)

	{

		obj, err = mj.Type.MarshalJSON()
		if err != nil {
			return err
		}
		buf.Write(obj)

	}
	buf.WriteByte(',')
	if mj.ID != nil {
		if true {
			buf.WriteString(`"id":`)

			{

				err = mj.ID.MarshalJSONBuf(buf)
				if err != nil {
					return err
				}

			}
			buf.WriteByte(',')
		}
	}
	if mj.Launch != nil {
		if true {
			buf.WriteString(`"launch":`)

			{

				err = mj.Launch.MarshalJSONBuf(buf)
				if err != nil {
					return err
				}

			}
			buf.WriteByte(',')
		}
	}
	if mj.LaunchGroup != nil {
		if true {
			buf.WriteString(`"launch_group":`)

			{

				err = mj.LaunchGroup.MarshalJSONBuf(buf)
				if err != nil {
					return err
				}

			}
			buf.WriteByte(',')
		}
	}
	if mj.Reserve != nil {
		if true {
			buf.WriteString(`"reserve":`)

			{

				err = mj.Reserve.MarshalJSONBuf(buf)
				if err != nil {
					return err
				}

			}
			buf.WriteByte(',')
		}
	}
	if mj.Unreserve != nil {
		if true {
			buf.WriteString(`"unreserve":`)

			{

				err = mj.Unreserve.MarshalJSONBuf(buf)
				if err != nil {
					return err
				}

			}
			buf.WriteByte(',')
		}
	}
	if mj.Create != nil {
		if true {
			buf.WriteString(`"create":`)

			{

				err = mj.Create.MarshalJSONBuf(buf)
				if err != nil {
					return err
				}

			}
			buf.WriteByte(',')
		}
	}
	if mj.Destroy != nil {
		if true {
			buf.WriteString(`"destroy":`)

			{

				err = mj.Destroy.MarshalJSONBuf(buf)
				if err != nil {
					return err
				}

			}
			buf.WriteByte(',')
		}
	}
	if mj.GrowVolume != nil {
		if true {
			buf.WriteString(`"grow_volume":`)

			{

				err = mj.GrowVolume.MarshalJSONBuf(buf)
				if err != nil {
					return err
				}

			}
			buf.WriteByte(',')
		}
	}
	if mj.ShrinkVolume != nil {
		if true {
			buf.WriteString(`"shrink_volume":`)

			{

				err = mj.ShrinkVolume.MarshalJSONBuf(buf)
				if err != nil {
					return err
				}

			}
			buf.WriteByte(',')
		}
	}
	if mj.CreateDisk != nil {
		if true {
			buf.WriteString(`"create_disk":`)

			{

				err = mj.CreateDisk.MarshalJSONBuf(buf)
				if err != nil {
					return err
				}

			}
			buf.WriteByte(',')
		}
	}
	if mj.DestroyDisk != nil {
		if true {
			buf.WriteString(`"destroy_disk":`)

			{

				err = mj.DestroyDisk.MarshalJSONBuf(buf)
				if err != nil {
					return err
				}

			}
			buf.WriteByte(',')
		}
	}
	buf.Rewind(1)
	buf.WriteByte('}')
	return nil
}

const (
	ffj_t_Offer_Operationbase = iota
	ffj_t_Offer_Operationno_such_key

	ffj_t_Offer_Operation_Type

	ffj_t_Offer_Operation_ID

	ffj_t_Offer_Operation_Launch

	ffj_t_Offer_Operation_LaunchGroup

	ffj_t_Offer_Operation_Reserve

	ffj_t_Offer_Operation_Unreserve

	ffj_t_Offer_Operation_Create

	ffj_t_Offer_Operation_Destroy

	ffj_t_Offer_Operation_GrowVolume

	ffj_t_Offer_Operation_ShrinkVolume

	ffj_t_Offer_Operation_CreateDisk

	ffj_t_Offer_Operation_DestroyDisk
)

var ffj_key_Offer_Operation_Type = []byte("type")

var ffj_key_Offer_Operation_ID = []byte("id")

var ffj_key_Offer_Operation_Launch = []byte("launch")

var ffj_key_Offer_Operation_LaunchGroup = []byte("launch_group")

var ffj_key_Offer_Operation_Reserve = []byte("reserve")

var ffj_key_Offer_Operation_Unreserve = []byte("unreserve")

var ffj_key_Offer_Operation_Create = []byte("create")

var ffj_key_Offer_Operation_Destroy = []byte("destroy")

var ffj_key_Offer_Operation_GrowVolume = []byte("grow_volume")

var ffj_key_Offer_Operation_ShrinkVolume = []byte("shrink_volume")

var ffj_key_Offer_Operation_CreateDisk = []byte("create_disk")

var ffj_key_Offer_Operation_DestroyDisk = []byte("destroy_disk")

func (uj *Offer_Operation) UnmarshalJSON(input []byte) error {
	fs := fflib.NewFFLexer(input)
	return uj.UnmarshalJSONFFLexer(fs, fflib.FFParse_map_start)
}

func (uj *Offer_Operation) UnmarshalJSONFFLexer(fs *fflib.FFLexer, state fflib.FFParseState) error {
	var err error = nil
	currentKey := ffj_t_Offer_Operationbase
	_ = currentKey
	tok := fflib.FFTok_init
	wantedTok := fflib.FFTok_init

mainparse:
	for {
		tok = fs.Scan()
		//	println(fmt.Sprintf("debug: tok: %v  state: %v", tok, state))
		if tok == fflib.FFTok_error {
			goto tokerror
		}

		switch state {

		case fflib.FFParse_map_start:
			if tok != fflib.FFTok_left_bracket {
				wantedTok = fflib.FFTok_left_bracket
				goto wrongtokenerror
			}
			state = fflib.FFParse_want_key
			continue

		case fflib.FFParse_after_value:
			if tok == fflib.FFTok_comma {
				state = fflib.FFParse_want_key
			} else if tok == fflib.FFTok_right_bracket {
				goto done
			} else {
				wantedTok = fflib.FFTok_comma
				goto wrongtokenerror
			}

		case fflib.FFParse_want_key:
			// json {} ended. goto exit. woo.
			if tok == fflib.FFTok_right_bracket {
				goto done
			}
			if tok != fflib.FFTok_string {
				wantedTok = fflib.FFTok_string
				goto wrongtokenerror
			}

			kn := fs.Output.Bytes()
			if len(kn) <= 0 {
				// "" case. hrm.
				currentKey = ffj_t_Offer_Operationno_such_key
				state = fflib.FFParse_want_colon
				goto mainparse
			} else {
				switch kn[0] {

				case 'c':

					if bytes.Equal(ffj_key_Offer_Operation_Create, kn) {
						currentKey = ffj_t_Offer_Operation_Create
						state = fflib.FFParse_want_colon
						goto mainparse

					} else if bytes.Equal(ffj_key_Offer_Operation_CreateDisk, kn) {
						currentKey = ffj_t_Offer_Operation_CreateDisk
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				case 'd':

					if bytes.Equal(ffj_key_Offer_Operation_Destroy, kn) {
						currentKey = ffj_t_Offer_Operation_Destroy
						state = fflib.FFParse_want_colon
						goto mainparse

					} else if bytes.Equal(ffj_key_Offer_Operation_DestroyDisk, kn) {
						currentKey = ffj_t_Offer_Operation_DestroyDisk
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				case 'g':

					if bytes.Equal(ffj_key_Offer_Operation_GrowVolume, kn) {
						currentKey = ffj_t_Offer_Operation_GrowVolume
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				case 'i':

					if bytes.Equal(ffj_key_Offer_Operation_ID, kn) {
						currentKey = ffj_t_Offer_Operation_ID
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				case 'l':

					if bytes.Equal(ffj_key_Offer_Operation_Launch, kn) {
						currentKey = ffj_t_Offer_Operation_Launch
						state = fflib.FFParse_want_colon
						goto mainparse

					} else if bytes.Equal(ffj_key_Offer_Operation_LaunchGroup, kn) {
						currentKey = ffj_t_Offer_Operation_LaunchGroup
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				case 'r':

					if bytes.Equal(ffj_key_Offer_Operation_Reserve, kn) {
						currentKey = ffj_t_Offer_Operation_Reserve
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				case 's':

					if bytes.Equal(ffj_key_Offer_Operation_ShrinkVolume, kn) {
						currentKey = ffj_t_Offer_Operation_ShrinkVolume
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				case 't':

					if bytes.Equal(ffj_key_Offer_Operation_Type, kn) {
						currentKey = ffj_t_Offer_Operation_Type
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				case 'u':

					if bytes.Equal(ffj_key_Offer_Operation_Unreserve, kn) {
						currentKey = ffj_t_Offer_Operation_Unreserve
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				}

				if fflib.EqualFoldRight(ffj_key_Offer_Operation_DestroyDisk, kn) {
					currentKey = ffj_t_Offer_Operation_DestroyDisk
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffj_key_Offer_Operation_CreateDisk, kn) {
					currentKey = ffj_t_Offer_Operation_CreateDisk
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffj_key_Offer_Operation_ShrinkVolume, kn) {
					currentKey = ffj_t_Offer_Operation_ShrinkVolume
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.AsciiEqualFold(ffj_key_Offer_Operation_GrowVolume, kn) {
					currentKey = ffj_t_Offer_Operation_GrowVolume
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffj_key_Offer_Operation_Destroy, kn) {
					currentKey = ffj_t_Offer_Operation_Destroy
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.SimpleLetterEqualFold(ffj_key_Offer_Operation_Create, kn) {
					currentKey = ffj_t_Offer_Operation_Create
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffj_key_Offer_Operation_Unreserve, kn) {
					currentKey = ffj_t_Offer_Operation_Unreserve
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffj_key_Offer_Operation_Reserve, kn) {
					currentKey = ffj_t_Offer_Operation_Reserve
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.AsciiEqualFold(ffj_key_Offer_Operation_LaunchGroup, kn) {
					currentKey = ffj_t_Offer_Operation_LaunchGroup
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.SimpleLetterEqualFold(ffj_key_Offer_Operation_Launch, kn) {
					currentKey = ffj_t_Offer_Operation_Launch
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.SimpleLetterEqualFold(ffj_key_Offer_Operation_ID, kn) {
					currentKey = ffj_t_Offer_Operation_ID
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.SimpleLetterEqualFold(ffj_key_Offer_Operation_Type, kn) {
					currentKey = ffj_t_Offer_Operation_Type
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				currentKey = ffj_t_Offer_Operationno_such_key
				state = fflib.FFParse_want_colon
				goto mainparse
			}

		case fflib.FFParse_want_colon:
			if tok != fflib.FFTok_colon {
				wantedTok = fflib.FFTok_colon
				goto wrongtokenerror
			}
			state = fflib.FFParse_want_value
			continue
		case fflib.FFParse_want_value:

			if tok == fflib.FFTok_left_brace || tok == fflib.FFTok_left_bracket || tok == fflib.FFTok_integer || tok == fflib.FFTok_double || tok == fflib.FFTok_string || tok == fflib.FFTok_bool || tok == fflib.FFTok_null {
				switch currentKey {

				case ffj_t_Offer_Operation_Type:
					goto handle_Type

				case ffj_t_Offer_Operation_ID:
					goto handle_ID

				case ffj_t_Offer_Operation_Launch:
					goto handle_Launch

				case ffj_t_Offer_Operation_LaunchGroup:
					goto handle_LaunchGroup

				case ffj_t_Offer_Operation_Reserve:
					goto handle_Reserve

				case ffj_t_Offer_Operation_Unreserve:
					goto handle_Unreserve

				case ffj_t_Offer_Operation_Create:
					goto handle_Create

				case ffj_t_Offer_Operation_Destroy:
					goto handle_Destroy

				case ffj_t_Offer_Operation_GrowVolume:
					goto handle_GrowVolume

				case ffj_t_Offer_Operation_ShrinkVolume:
					goto handle_ShrinkVolume

				case ffj_t_Offer_Operation_CreateDisk:
					goto handle_CreateDisk

				case ffj_t_Offer_Operation_DestroyDisk:
					goto handle_DestroyDisk

				case ffj_t_Offer_Operationno_such_key:
					err = fs.SkipField(tok)
					if err != nil {
						return fs.WrapErr(err)
					}
					state = fflib.FFParse_after_value
					goto mainparse
				}
			} else {
				goto wantedvalue
			}
		}
	}

handle_Type:

	/* handler: uj.Type type=mesos.Offer_Operation_Type kind=int32 quoted=false*/

	{
		if tok == fflib.FFTok_null {

			state = fflib.FFParse_after_value
			goto mainparse
		}

		tbuf, err := fs.CaptureField(tok)
		if err != nil {
			return fs.WrapErr(err)
		}

		err = uj.Type.UnmarshalJSON(tbuf)
		if err != nil {
			return fs.WrapErr(err)
		}
		state = fflib.FFParse_after_value
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_ID:

	/* handler: uj.ID type=mesos.OperationID kind=struct quoted=false*/

	{
		if tok == fflib.FFTok_null {

			uj.ID = nil

			state = fflib.FFParse_after_value
			goto mainparse
		}

		if uj.ID == nil {
			uj.ID = new(OperationID)
		}

		err = uj.ID.UnmarshalJSONFFLexer(fs, fflib.FFParse_want_key)
		if err != nil {
			return err
		}
		state = fflib.FFParse_after_value
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_Launch:

	/* handler: uj.Launch type=mesos.Offer_Operation_Launch kind=struct quoted=false*/

	{
		if tok == fflib.FFTok_null {

			uj.Launch = nil

			state = fflib.FFParse_after_value
			goto mainparse
		}

		if uj.Launch == nil {
			uj.Launch = new(Offer_Operation_Launch)
		}

		err = uj.Launch.UnmarshalJSONFFLexer(fs, fflib.FFParse_want_key)
		if err != nil {
			return err
		}
		state = fflib.FFParse_after_value
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_LaunchGroup:

	/* handler: uj.LaunchGroup type=mesos.Offer_Operation_LaunchGroup kind=struct quoted=false*/

	{
		if tok == fflib.FFTok_null {

			uj.LaunchGroup = nil

			state = fflib.FFParse_after_value
			goto mainparse
		}

		if uj.LaunchGroup == nil {
			uj.LaunchGroup = new(Offer_Operation_LaunchGroup)
		}

		err = uj.LaunchGroup.UnmarshalJSONFFLexer(fs, fflib.FFParse_want_key)
		if err != nil {
			return err
		}
		state = fflib.FFParse_after_value
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_Reserve:

	/* handler: uj.Reserve type=mesos.Offer_Operation_Reserve kind=struct quoted=false*/

	{
		if tok == fflib.FFTok_null {

			uj.Reserve = nil

			state = fflib.FFParse_after_value
			goto mainparse
		}

		if uj.Reserve == nil {
			uj.Reserve = new(Offer_Operation_Reserve)
		}

		err = uj.Reserve.UnmarshalJSONFFLexer(fs, fflib.FFParse_want_key)
		if err != nil {
			return err
		}
		state = fflib.FFParse_after_value
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_Unreserve:

	/* handler: uj.Unreserve type=mesos.Offer_Operation_Unreserve kind=struct quoted=false*/

	{
		if tok == fflib.FFTok_null {

			uj.Unreserve = nil

			state = fflib.FFParse_after_value
			goto mainparse
		}

		if uj.Unreserve == nil {
			uj.Unreserve = new(Offer_Operation_Unreserve)
		}

		err = uj.Unreserve.UnmarshalJSONFFLexer(fs, fflib.FFParse_want_key)
		if err != nil {
			return err
		}
		state = fflib.FFParse_after_value
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_Create:

	/* handler: uj.Create type=mesos.Offer_Operation_Create kind=struct quoted=false*/

	{
		if tok == fflib.FFTok_null {

			uj.Create = nil

			state = fflib.FFParse_after_value
			goto mainparse
		}

		if uj.Create == nil {
			uj.Create = new(Offer_Operation_Create)
		}

		err = uj.Create.UnmarshalJSONFFLexer(fs, fflib.FFParse_want_key)
		if err != nil {
			return err
		}
		state = fflib.FFParse_after_value
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_Destroy:

	/* handler: uj.Destroy type=mesos.Offer_Operation_Destroy kind=struct quoted=false*/

	{
		if tok == fflib.FFTok_null {

			uj.Destroy = nil

			state = fflib.FFParse_after_value
			goto mainparse
		}

		if uj.Destroy == nil {
			uj.Destroy = new(Offer_Operation_Destroy)
		}

		err = uj.Destroy.UnmarshalJSONFFLexer(fs, fflib.FFParse_want_key)
		if err != nil {
			return err
		}
		state = fflib.FFParse_after_value
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_GrowVolume:

	/* handler: uj.GrowVolume type=mesos.Offer_Operation_GrowVolume kind=struct quoted=false*/

	{
		if tok == fflib.FFTok_null {

			uj.GrowVolume = nil

			state = fflib.FFParse_after_value
			goto mainparse
		}

		if uj.GrowVolume == nil {
			uj.GrowVolume = new(Offer_Operation_GrowVolume)
		}

		err = uj.GrowVolume.UnmarshalJSONFFLexer(fs, fflib.FFParse_want_key)
		if err != nil {
			return err
		}
		state = fflib.FFParse_after_value
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_ShrinkVolume:

	/* handler: uj.ShrinkVolume type=mesos.Offer_Operation_ShrinkVolume kind=struct quoted=false*/

	{
		if tok == fflib.FFTok_null {

			uj.ShrinkVolume = nil

			state = fflib.FFParse_after_value
			goto mainparse
		}

		if uj.ShrinkVolume == nil {
			uj.ShrinkVolume = new(Offer_Operation_ShrinkVolume)
		}

		err = uj.ShrinkVolume.UnmarshalJSONFFLexer(fs, fflib.FFParse_want_key)
		if err != nil {
			return err
		}
		state = fflib.FFParse_after_value
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_CreateDisk:

	/* handler: uj.CreateDisk type=mesos.Offer_Operation_CreateDisk kind=struct quoted=false*/

	{
		if tok == fflib.FFTok_null {

			uj.CreateDisk = nil

			state = fflib.FFParse_after_value
			goto mainparse
		}

		if uj.CreateDisk == nil {
			uj.CreateDisk = new(Offer_Operation_CreateDisk)
		}

		err = uj.CreateDisk.UnmarshalJSONFFLexer(fs, fflib.FFParse_want_key)
		if err != nil {
			return err
		}
		state = fflib.FFParse_after_value
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_DestroyDisk:

	/* handler: uj.DestroyDisk type=mesos.Offer_Operation_DestroyDisk kind=struct quoted=false*/

	{
		if tok == fflib.FFTok_null {

			uj.DestroyDisk = nil

			state = fflib.FFParse_after_value
			goto mainparse
		}

		if uj.DestroyDisk == nil {
			uj.DestroyDisk = new(Offer_Operation_DestroyDisk)
		}

		err = uj.DestroyDisk.UnmarshalJSONFFLexer(fs, fflib.FFParse_want_key)
		if err != nil {
			return err
		}
		state = fflib.FFParse_after_value
	}

	state = fflib.FFParse_after_value
	goto mainparse

wantedvalue:
	return fs.WrapErr(fmt.Errorf("wanted value token, but got token: %v", tok))
wrongtokenerror:
	return fs.WrapErr(fmt.Errorf("ffjson: wanted token: %v, but got token: %v output=%s", wantedTok, tok, fs.Output.String()))
tokerror:
	if fs.BigError != nil {
		return fs.WrapErr(fs.BigError)
	}
	err = fs.Error.ToError()
	if err != nil {
		return fs.WrapErr(err)
	}
	panic("ffjson-generated: unreachable, please report bug.")
done:

	return nil
}

func (mj *Offer_Operation_Create) MarshalJSON() ([]byte, error) {
	var buf fflib.Buffer
	if mj == nil {
		buf.WriteString("null")
		return buf.Bytes(), nil
	}
	err := mj.MarshalJSONBuf(&buf)
	if err != nil {
		return nil, err
	}
	return buf.Bytes(), nil
}
func (mj *Offer_Operation_Create) MarshalJSONBuf(buf fflib.EncodingBuffer) error {
	if mj == nil {
		buf.WriteString("null")
		return nil
	}
	var err error
	var obj []byte
	_ = obj
	_ = err
	buf.WriteString(`{"volumes":`)
	if mj.Volumes != nil {
		buf.WriteString(`[`)
		for i, v := range mj.Volumes {
			if i != 0 {
				buf.WriteString(`,`)
			}

			{

				err = v.MarshalJSONBuf(buf)
				if err != nil {
					return err
				}

			}
		}
		buf.WriteString(`]`)
	} else {
		buf.WriteString(`null`)
	}
	buf.WriteByte('}')
	return nil
}

const (
	ffj_t_Offer_Operation_Createbase = iota
	ffj_t_Offer_Operation_Createno_such_key

	ffj_t_Offer_Operation_Create_Volumes
)

var ffj_key_Offer_Operation_Create_Volumes = []byte("volumes")

func (uj *Offer_Operation_Create) UnmarshalJSON(input []byte) error {
	fs := fflib.NewFFLexer(input)
	return uj.UnmarshalJSONFFLexer(fs, fflib.FFParse_map_start)
}

func (uj *Offer_Operation_Create) UnmarshalJSONFFLexer(fs *fflib.FFLexer, state fflib.FFParseState) error {
	var err error = nil
	currentKey := ffj_t_Offer_Operation_Createbase
	_ = currentKey
	tok := fflib.FFTok_init
	wantedTok := fflib.FFTok_init

mainparse:
	for {
		tok = fs.Scan()
		//	println(fmt.Sprintf("debug: tok: %v  state: %v", tok, state))
		if tok == fflib.FFTok_error {
			goto tokerror
		}

		switch state {

		case fflib.FFParse_map_start:
			if tok != fflib.FFTok_left_bracket {
				wantedTok = fflib.FFTok_left_bracket
				goto wrongtokenerror
			}
			state = fflib.FFParse_want_key
			continue

		case fflib.FFParse_after_value:
			if tok == fflib.FFTok_comma {
				state = fflib.FFParse_want_key
			} else if tok == fflib.FFTok_right_bracket {
				goto done
			} else {
				wantedTok = fflib.FFTok_comma
				goto wrongtokenerror
			}

		case fflib.FFParse_want_key:
			// json {} ended. goto exit. woo.
			if tok == fflib.FFTok_right_bracket {
				goto done
			}
			if tok != fflib.FFTok_string {
				wantedTok = fflib.FFTok_string
				goto wrongtokenerror
			}

			kn := fs.Output.Bytes()
			if len(kn) <= 0 {
				// "" case. hrm.
				currentKey = ffj_t_Offer_Operation_Createno_such_key
				state = fflib.FFParse_want_colon
				goto mainparse
			} else {
				switch kn[0] {

				case 'v':

					if bytes.Equal(ffj_key_Offer_Operation_Create_Volumes, kn) {
						currentKey = ffj_t_Offer_Operation_Create_Volumes
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				}

				if fflib.EqualFoldRight(ffj_key_Offer_Operation_Create_Volumes, kn) {
					currentKey = ffj_t_Offer_Operation_Create_Volumes
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				currentKey = ffj_t_Offer_Operation_Createno_such_key
				state = fflib.FFParse_want_colon
				goto mainparse
			}

		case fflib.FFParse_want_colon:
			if tok != fflib.FFTok_colon {
				wantedTok = fflib.FFTok_colon
				goto wrongtokenerror
			}
			state = fflib.FFParse_want_value
			continue
		case fflib.FFParse_want_value:

			if tok == fflib.FFTok_left_brace || tok == fflib.FFTok_left_bracket || tok == fflib.FFTok_integer || tok == fflib.FFTok_double || tok == fflib.FFTok_string || tok == fflib.FFTok_bool || tok == fflib.FFTok_null {
				switch currentKey {

				case ffj_t_Offer_Operation_Create_Volumes:
					goto handle_Volumes

				case ffj_t_Offer_Operation_Createno_such_key:
					err = fs.SkipField(tok)
					if err != nil {
						return fs.WrapErr(err)
					}
					state = fflib.FFParse_after_value
					goto mainparse
				}
			} else {
				goto wantedvalue
			}
		}
	}

handle_Volumes:

	/* handler: uj.Volumes type=[]mesos.Resource kind=slice quoted=false*/

	{

		{
			if tok != fflib.FFTok_left_brace && tok != fflib.FFTok_null {
				return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for ", tok))
			}
		}

		if tok == fflib.FFTok_null {
			uj.Volumes = nil
		} else {

			uj.Volumes = []Resource{}

			wantVal := true

			for {

				var tmp_uj__Volumes Resource

				tok = fs.Scan()
				if tok == fflib.FFTok_error {
					goto tokerror
				}
				if tok == fflib.FFTok_right_brace {
					break
				}

				if tok == fflib.FFTok_comma {
					if wantVal == true {
						// TODO(pquerna): this isn't an ideal error message, this handles
						// things like [,,,] as an array value.
						return fs.WrapErr(fmt.Errorf("wanted value token, but got token: %v", tok))
					}
					continue
				} else {
					wantVal = true
				}

				/* handler: tmp_uj__Volumes type=mesos.Resource kind=struct quoted=false*/

				{
					if tok == fflib.FFTok_null {

						state = fflib.FFParse_after_value
						goto mainparse
					}

					err = tmp_uj__Volumes.UnmarshalJSONFFLexer(fs, fflib.FFParse_want_key)
					if err != nil {
						return err
					}
					state = fflib.FFParse_after_value
				}

				uj.Volumes = append(uj.Volumes, tmp_uj__Volumes)

				wantVal = false
			}
		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

wantedvalue:
	return fs.WrapErr(fmt.Errorf("wanted value token, but got token: %v", tok))
wrongtokenerror:
	return fs.WrapErr(fmt.Errorf("ffjson: wanted token: %v, but got token: %v output=%s", wantedTok, tok, fs.Output.String()))
tokerror:
	if fs.BigError != nil {
		return fs.WrapErr(fs.BigError)
	}
	err = fs.Error.ToError()
	if err != nil {
		return fs.WrapErr(err)
	}
	panic("ffjson-generated: unreachable, please report bug.")
done:

	return nil
}

func (mj *Offer_Operation_CreateDisk) MarshalJSON() ([]byte, error) {
	var buf fflib.Buffer
	if mj == nil {
		buf.WriteString("null")
		return buf.Bytes(), nil
	}
	err := mj.MarshalJSONBuf(&buf)
	if err != nil {
		return nil, err
	}
	return buf.Bytes(), nil
}
func (mj *Offer_Operation_CreateDisk) MarshalJSONBuf(buf fflib.EncodingBuffer) error {
	if mj == nil {
		buf.WriteString("null")
		return nil
	}
	var err error
	var obj []byte
	_ = obj
	_ = err
	buf.WriteString(`{ "source":`)

	{

		err = mj.Source.MarshalJSONBuf(buf)
		if err != nil {
			return err
		}

	}
	buf.WriteString(`,"target_type":`)

	{

		obj, err = mj.TargetType.MarshalJSON()
		if err != nil {
			return err
		}
		buf.Write(obj)

	}
	buf.WriteByte(',')
	if mj.TargetProfile != nil {
		if true {
			buf.WriteString(`"target_profile":`)
			fflib.WriteJsonString(buf, string(*mj.TargetProfile))
			buf.WriteByte(',')
		}
	}
	buf.Rewind(1)
	buf.WriteByte('}')
	return nil
}

const (
	ffj_t_Offer_Operation_CreateDiskbase = iota
	ffj_t_Offer_Operation_CreateDiskno_such_key

	ffj_t_Offer_Operation_CreateDisk_Source

	ffj_t_Offer_Operation_CreateDisk_TargetType

	ffj_t_Offer_Operation_CreateDisk_TargetProfile
)

var ffj_key_Offer_Operation_CreateDisk_Source = []byte("source")

var ffj_key_Offer_Operation_CreateDisk_TargetType = []byte("target_type")

var ffj_key_Offer_Operation_CreateDisk_TargetProfile = []byte("target_profile")

func (uj *Offer_Operation_CreateDisk) UnmarshalJSON(input []byte) error {
	fs := fflib.NewFFLexer(input)
	return uj.UnmarshalJSONFFLexer(fs, fflib.FFParse_map_start)
}

func (uj *Offer_Operation_CreateDisk) UnmarshalJSONFFLexer(fs *fflib.FFLexer, state fflib.FFParseState) error {
	var err error = nil
	currentKey := ffj_t_Offer_Operation_CreateDiskbase
	_ = currentKey
	tok := fflib.FFTok_init
	wantedTok := fflib.FFTok_init

mainparse:
	for {
		tok = fs.Scan()
		//	println(fmt.Sprintf("debug: tok: %v  state: %v", tok, state))
		if tok == fflib.FFTok_error {
			goto tokerror
		}

		switch state {

		case fflib.FFParse_map_start:
			if tok != fflib.FFTok_left_bracket {
				wantedTok = fflib.FFTok_left_bracket
				goto wrongtokenerror
			}
			state = fflib.FFParse_want_key
			continue

		case fflib.FFParse_after_value:
			if tok == fflib.FFTok_comma {
				state = fflib.FFParse_want_key
			} else if tok == fflib.FFTok_right_bracket {
				goto done
			} else {
				wantedTok = fflib.FFTok_comma
				goto wrongtokenerror
			}

		case fflib.FFParse_want_key:
			// json {} ended. goto exit. woo.
			if tok == fflib.FFTok_right_bracket {
				goto done
			}
			if tok != fflib.FFTok_string {
				wantedTok = fflib.FFTok_string
				goto wrongtokenerror
			}

			kn := fs.Output.Bytes()
			if len(kn) <= 0 {
				// "" case. hrm.
				currentKey = ffj_t_Offer_Operation_CreateDiskno_such_key
				state = fflib.FFParse_want_colon
				goto mainparse
			} else {
				switch kn[0] {

				case 's':

					if bytes.Equal(ffj_key_Offer_Operation_CreateDisk_Source, kn) {
						currentKey = ffj_t_Offer_Operation_CreateDisk_Source
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				case 't':

					if bytes.Equal(ffj_key_Offer_Operation_CreateDisk_TargetType, kn) {
						currentKey = ffj_t_Offer_Operation_CreateDisk_TargetType
						state = fflib.FFParse_want_colon
						goto mainparse

					} else if bytes.Equal(ffj_key_Offer_Operation_CreateDisk_TargetProfile, kn) {
						currentKey = ffj_t_Offer_Operation_CreateDisk_TargetProfile
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				}

				if fflib.AsciiEqualFold(ffj_key_Offer_Operation_CreateDisk_TargetProfile, kn) {
					currentKey = ffj_t_Offer_Operation_CreateDisk_TargetProfile
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.AsciiEqualFold(ffj_key_Offer_Operation_CreateDisk_TargetType, kn) {
					currentKey = ffj_t_Offer_Operation_CreateDisk_TargetType
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffj_key_Offer_Operation_CreateDisk_Source, kn) {
					currentKey = ffj_t_Offer_Operation_CreateDisk_Source
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				currentKey = ffj_t_Offer_Operation_CreateDiskno_such_key
				state = fflib.FFParse_want_colon
				goto mainparse
			}

		case fflib.FFParse_want_colon:
			if tok != fflib.FFTok_colon {
				wantedTok = fflib.FFTok_colon
				goto wrongtokenerror
			}
			state = fflib.FFParse_want_value
			continue
		case fflib.FFParse_want_value:

			if tok == fflib.FFTok_left_brace || tok == fflib.FFTok_left_bracket || tok == fflib.FFTok_integer || tok == fflib.FFTok_double || tok == fflib.FFTok_string || tok == fflib.FFTok_bool || tok == fflib.FFTok_null {
				switch currentKey {

				case ffj_t_Offer_Operation_CreateDisk_Source:
					goto handle_Source

				case ffj_t_Offer_Operation_CreateDisk_TargetType:
					goto handle_TargetType

				case ffj_t_Offer_Operation_CreateDisk_TargetProfile:
					goto handle_TargetProfile

				case ffj_t_Offer_Operation_CreateDiskno_such_key:
					err = fs.SkipField(tok)
					if err != nil {
						return fs.WrapErr(err)
					}
					state = fflib.FFParse_after_value
					goto mainparse
				}
			} else {
				goto wantedvalue
			}
		}
	}

handle_Source:

	/* handler: uj.Source type=mesos.Resource kind=struct quoted=false*/

	{
		if tok == fflib.FFTok_null {

			state = fflib.FFParse_after_value
			goto mainparse
		}

		err = uj.Source.UnmarshalJSONFFLexer(fs, fflib.FFParse_want_key)
		if err != nil {
			return err
		}
		state = fflib.FFParse_after_value
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_TargetType:

	/* handler: uj.TargetType type=mesos.Resource_DiskInfo_Source_Type kind=int32 quoted=false*/

	{
		if tok == fflib.FFTok_null {

			state = fflib.FFParse_after_value
			goto mainparse
		}

		tbuf, err := fs.CaptureField(tok)
		if err != nil {
			return fs.WrapErr(err)
		}

		err = uj.TargetType.UnmarshalJSON(tbuf)
		if err != nil {
			return fs.WrapErr(err)
		}
		state = fflib.FFParse_after_value
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_TargetProfile:

	/* handler: uj.TargetProfile type=string kind=string quoted=false*/

	{

		{
			if tok != fflib.FFTok_string && tok != fflib.FFTok_null {
				return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for string", tok))
			}
		}

		if tok == fflib.FFTok_null {

			uj.TargetProfile = nil

		} else {

			var tval string
			outBuf := fs.Output.Bytes()

			tval = string(string(outBuf))
			uj.TargetProfile = &tval

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

wantedvalue:
	return fs.WrapErr(fmt.Errorf("wanted value token, but got token: %v", tok))
wrongtokenerror:
	return fs.WrapErr(fmt.Errorf("ffjson: wanted token: %v, but got token: %v output=%s", wantedTok, tok, fs.Output.String()))
tokerror:
	if fs.BigError != nil {
		return fs.WrapErr(fs.BigError)
	}
	err = fs.Error.ToError()
	if err != nil {
		return fs.WrapErr(err)
	}
	panic("ffjson-generated: unreachable, please report bug.")
done:

	return nil
}

func (mj *Offer_Operation_Destroy) MarshalJSON() ([]byte, error) {
	var buf fflib.Buffer
	if mj == nil {
		buf.WriteString("null")
		return buf.Bytes(), nil
	}
	err := mj.MarshalJSONBuf(&buf)
	if err != nil {
		return nil, err
	}
	return buf.Bytes(), nil
}
func (mj *Offer_Operation_Destroy) MarshalJSONBuf(buf fflib.EncodingBuffer) error {
	if mj == nil {
		buf.WriteString("null")
		return nil
	}
	var err error
	var obj []byte
	_ = obj
	_ = err
	buf.WriteString(`{"volumes":`)
	if mj.Volumes != nil {
		buf.WriteString(`[`)
		for i, v := range mj.Volumes {
			if i != 0 {
				buf.WriteString(`,`)
			}

			{

				err = v.MarshalJSONBuf(buf)
				if err != nil {
					return err
				}

			}
		}
		buf.WriteString(`]`)
	} else {
		buf.WriteString(`null`)
	}
	buf.WriteByte('}')
	return nil
}

const (
	ffj_t_Offer_Operation_Destroybase = iota
	ffj_t_Offer_Operation_Destroyno_such_key

	ffj_t_Offer_Operation_Destroy_Volumes
)

var ffj_key_Offer_Operation_Destroy_Volumes = []byte("volumes")

func (uj *Offer_Operation_Destroy) UnmarshalJSON(input []byte) error {
	fs := fflib.NewFFLexer(input)
	return uj.UnmarshalJSONFFLexer(fs, fflib.FFParse_map_start)
}

func (uj *Offer_Operation_Destroy) UnmarshalJSONFFLexer(fs *fflib.FFLexer, state fflib.FFParseState) error {
	var err error = nil
	currentKey := ffj_t_Offer_Operation_Destroybase
	_ = currentKey
	tok := fflib.FFTok_init
	wantedTok := fflib.FFTok_init

mainparse:
	for {
		tok = fs.Scan()
		//	println(fmt.Sprintf("debug: tok: %v  state: %v", tok, state))
		if tok == fflib.FFTok_error {
			goto tokerror
		}

		switch state {

		case fflib.FFParse_map_start:
			if tok != fflib.FFTok_left_bracket {
				wantedTok = fflib.FFTok_left_bracket
				goto wrongtokenerror
			}
			state = fflib.FFParse_want_key
			continue

		case fflib.FFParse_after_value:
			if tok == fflib.FFTok_comma {
				state = fflib.FFParse_want_key
			} else if tok == fflib.FFTok_right_bracket {
				goto done
			} else {
				wantedTok = fflib.FFTok_comma
				goto wrongtokenerror
			}

		case fflib.FFParse_want_key:
			// json {} ended. goto exit. woo.
			if tok == fflib.FFTok_right_bracket {
				goto done
			}
			if tok != fflib.FFTok_string {
				wantedTok = fflib.FFTok_string
				goto wrongtokenerror
			}

			kn := fs.Output.Bytes()
			if len(kn) <= 0 {
				// "" case. hrm.
				currentKey = ffj_t_Offer_Operation_Destroyno_such_key
				state = fflib.FFParse_want_colon
				goto mainparse
			} else {
				switch kn[0] {

				case 'v':

					if bytes.Equal(ffj_key_Offer_Operation_Destroy_Volumes, kn) {
						currentKey = ffj_t_Offer_Operation_Destroy_Volumes
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				}

				if fflib.EqualFoldRight(ffj_key_Offer_Operation_Destroy_Volumes, kn) {
					currentKey = ffj_t_Offer_Operation_Destroy_Volumes
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				currentKey = ffj_t_Offer_Operation_Destroyno_such_key
				state = fflib.FFParse_want_colon
				goto mainparse
			}

		case fflib.FFParse_want_colon:
			if tok != fflib.FFTok_colon {
				wantedTok = fflib.FFTok_colon
				goto wrongtokenerror
			}
			state = fflib.FFParse_want_value
			continue
		case fflib.FFParse_want_value:

			if tok == fflib.FFTok_left_brace || tok == fflib.FFTok_left_bracket || tok == fflib.FFTok_integer || tok == fflib.FFTok_double || tok == fflib.FFTok_string || tok == fflib.FFTok_bool || tok == fflib.FFTok_null {
				switch currentKey {

				case ffj_t_Offer_Operation_Destroy_Volumes:
					goto handle_Volumes

				case ffj_t_Offer_Operation_Destroyno_such_key:
					err = fs.SkipField(tok)
					if err != nil {
						return fs.WrapErr(err)
					}
					state = fflib.FFParse_after_value
					goto mainparse
				}
			} else {
				goto wantedvalue
			}
		}
	}

handle_Volumes:

	/* handler: uj.Volumes type=[]mesos.Resource kind=slice quoted=false*/

	{

		{
			if tok != fflib.FFTok_left_brace && tok != fflib.FFTok_null {
				return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for ", tok))
			}
		}

		if tok == fflib.FFTok_null {
			uj.Volumes = nil
		} else {

			uj.Volumes = []Resource{}

			wantVal := true

			for {

				var tmp_uj__Volumes Resource

				tok = fs.Scan()
				if tok == fflib.FFTok_error {
					goto tokerror
				}
				if tok == fflib.FFTok_right_brace {
					break
				}

				if tok == fflib.FFTok_comma {
					if wantVal == true {
						// TODO(pquerna): this isn't an ideal error message, this handles
						// things like [,,,] as an array value.
						return fs.WrapErr(fmt.Errorf("wanted value token, but got token: %v", tok))
					}
					continue
				} else {
					wantVal = true
				}

				/* handler: tmp_uj__Volumes type=mesos.Resource kind=struct quoted=false*/

				{
					if tok == fflib.FFTok_null {

						state = fflib.FFParse_after_value
						goto mainparse
					}

					err = tmp_uj__Volumes.UnmarshalJSONFFLexer(fs, fflib.FFParse_want_key)
					if err != nil {
						return err
					}
					state = fflib.FFParse_after_value
				}

				uj.Volumes = append(uj.Volumes, tmp_uj__Volumes)

				wantVal = false
			}
		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

wantedvalue:
	return fs.WrapErr(fmt.Errorf("wanted value token, but got token: %v", tok))
wrongtokenerror:
	return fs.WrapErr(fmt.Errorf("ffjson: wanted token: %v, but got token: %v output=%s", wantedTok, tok, fs.Output.String()))
tokerror:
	if fs.BigError != nil {
		return fs.WrapErr(fs.BigError)
	}
	err = fs.Error.ToError()
	if err != nil {
		return fs.WrapErr(err)
	}
	panic("ffjson-generated: unreachable, please report bug.")
done:

	return nil
}

func (mj *Offer_Operation_DestroyDisk) MarshalJSON() ([]byte, error) {
	var buf fflib.Buffer
	if mj == nil {
		buf.WriteString("null")
		return buf.Bytes(), nil
	}
	err := mj.MarshalJSONBuf(&buf)
	if err != nil {
		return nil, err
	}
	return buf.Bytes(), nil
}
func (mj *Offer_Operation_DestroyDisk) MarshalJSONBuf(buf fflib.EncodingBuffer) error {
	if mj == nil {
		buf.WriteString("null")
		return nil
	}
	var err error
	var obj []byte
	_ = obj
	_ = err
	buf.WriteString(`{"source":`)

	{

		err = mj.Source.MarshalJSONBuf(buf)
		if err != nil {
			return err
		}

	}
	buf.WriteByte('}')
	return nil
}

const (
	ffj_t_Offer_Operation_DestroyDiskbase = iota
	ffj_t_Offer_Operation_DestroyDiskno_such_key

	ffj_t_Offer_Operation_DestroyDisk_Source
)

var ffj_key_Offer_Operation_DestroyDisk_Source = []byte("source")

func (uj *Offer_Operation_DestroyDisk) UnmarshalJSON(input []byte) error {
	fs := fflib.NewFFLexer(input)
	return uj.UnmarshalJSONFFLexer(fs, fflib.FFParse_map_start)
}

func (uj *Offer_Operation_DestroyDisk) UnmarshalJSONFFLexer(fs *fflib.FFLexer, state fflib.FFParseState) error {
	var err error = nil
	currentKey := ffj_t_Offer_Operation_DestroyDiskbase
	_ = currentKey
	tok := fflib.FFTok_init
	wantedTok := fflib.FFTok_init

mainparse:
	for {
		tok = fs.Scan()
		//	println(fmt.Sprintf("debug: tok: %v  state: %v", tok, state))
		if tok == fflib.FFTok_error {
			goto tokerror
		}

		switch state {

		case fflib.FFParse_map_start:
			if tok != fflib.FFTok_left_bracket {
				wantedTok = fflib.FFTok_left_bracket
				goto wrongtokenerror
			}
			state = fflib.FFParse_want_key
			continue

		case fflib.FFParse_after_value:
			if tok == fflib.FFTok_comma {
				state = fflib.FFParse_want_key
			} else if tok == fflib.FFTok_right_bracket {
				goto done
			} else {
				wantedTok = fflib.FFTok_comma
				goto wrongtokenerror
			}

		case fflib.FFParse_want_key:
			// json {} ended. goto exit. woo.
			if tok == fflib.FFTok_right_bracket {
				goto done
			}
			if tok != fflib.FFTok_string {
				wantedTok = fflib.FFTok_string
				goto wrongtokenerror
			}

			kn := fs.Output.Bytes()
			if len(kn) <= 0 {
				// "" case. hrm.
				currentKey = ffj_t_Offer_Operation_DestroyDiskno_such_key
				state = fflib.FFParse_want_colon
				goto mainparse
			} else {
				switch kn[0] {

				case 's':

					if bytes.Equal(ffj_key_Offer_Operation_DestroyDisk_Source, kn) {
						currentKey = ffj_t_Offer_Operation_DestroyDisk_Source
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				}

				if fflib.EqualFoldRight(ffj_key_Offer_Operation_DestroyDisk_Source, kn) {
					currentKey = ffj_t_Offer_Operation_DestroyDisk_Source
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				currentKey = ffj_t_Offer_Operation_DestroyDiskno_such_key
				state = fflib.FFParse_want_colon
				goto mainparse
			}

		case fflib.FFParse_want_colon:
			if tok != fflib.FFTok_colon {
				wantedTok = fflib.FFTok_colon
				goto wrongtokenerror
			}
			state = fflib.FFParse_want_value
			continue
		case fflib.FFParse_want_value:

			if tok == fflib.FFTok_left_brace || tok == fflib.FFTok_left_bracket || tok == fflib.FFTok_integer || tok == fflib.FFTok_double || tok == fflib.FFTok_string || tok == fflib.FFTok_bool || tok == fflib.FFTok_null {
				switch currentKey {

				case ffj_t_Offer_Operation_DestroyDisk_Source:
					goto handle_Source

				case ffj_t_Offer_Operation_DestroyDiskno_such_key:
					err = fs.SkipField(tok)
					if err != nil {
						return fs.WrapErr(err)
					}
					state = fflib.FFParse_after_value
					goto mainparse
				}
			} else {
				goto wantedvalue
			}
		}
	}

handle_Source:

	/* handler: uj.Source type=mesos.Resource kind=struct quoted=false*/

	{
		if tok == fflib.FFTok_null {

			state = fflib.FFParse_after_value
			goto mainparse
		}

		err = uj.Source.UnmarshalJSONFFLexer(fs, fflib.FFParse_want_key)
		if err != nil {
			return err
		}
		state = fflib.FFParse_after_value
	}

	state = fflib.FFParse_after_value
	goto mainparse

wantedvalue:
	return fs.WrapErr(fmt.Errorf("wanted value token, but got token: %v", tok))
wrongtokenerror:
	return fs.WrapErr(fmt.Errorf("ffjson: wanted token: %v, but got token: %v output=%s", wantedTok, tok, fs.Output.String()))
tokerror:
	if fs.BigError != nil {
		return fs.WrapErr(fs.BigError)
	}
	err = fs.Error.ToError()
	if err != nil {
		return fs.WrapErr(err)
	}
	panic("ffjson-generated: unreachable, please report bug.")
done:

	return nil
}

func (mj *Offer_Operation_GrowVolume) MarshalJSON() ([]byte, error) {
	var buf fflib.Buffer
	if mj == nil {
		buf.WriteString("null")
		return buf.Bytes(), nil
	}
	err := mj.MarshalJSONBuf(&buf)
	if err != nil {
		return nil, err
	}
	return buf.Bytes(), nil
}
func (mj *Offer_Operation_GrowVolume) MarshalJSONBuf(buf fflib.EncodingBuffer) error {
	if mj == nil {
		buf.WriteString("null")
		return nil
	}
	var err error
	var obj []byte
	_ = obj
	_ = err
	buf.WriteString(`{"volume":`)

	{

		err = mj.Volume.MarshalJSONBuf(buf)
		if err != nil {
			return err
		}

	}
	buf.WriteString(`,"addition":`)

	{

		err = mj.Addition.MarshalJSONBuf(buf)
		if err != nil {
			return err
		}

	}
	buf.WriteByte('}')
	return nil
}

const (
	ffj_t_Offer_Operation_GrowVolumebase = iota
	ffj_t_Offer_Operation_GrowVolumeno_such_key

	ffj_t_Offer_Operation_GrowVolume_Volume

	ffj_t_Offer_Operation_GrowVolume_Addition
)

var ffj_key_Offer_Operation_GrowVolume_Volume = []byte("volume")

var ffj_key_Offer_Operation_GrowVolume_Addition = []byte("addition")

func (uj *Offer_Operation_GrowVolume) UnmarshalJSON(input []byte) error {
	fs := fflib.NewFFLexer(input)
	return uj.UnmarshalJSONFFLexer(fs, fflib.FFParse_map_start)
}

func (uj *Offer_Operation_GrowVolume) UnmarshalJSONFFLexer(fs *fflib.FFLexer, state fflib.FFParseState) error {
	var err error = nil
	currentKey := ffj_t_Offer_Operation_GrowVolumebase
	_ = currentKey
	tok := fflib.FFTok_init
	wantedTok := fflib.FFTok_init

mainparse:
	for {
		tok = fs.Scan()
		//	println(fmt.Sprintf("debug: tok: %v  state: %v", tok, state))
		if tok == fflib.FFTok_error {
			goto tokerror
		}

		switch state {

		case fflib.FFParse_map_start:
			if tok != fflib.FFTok_left_bracket {
				wantedTok = fflib.FFTok_left_bracket
				goto wrongtokenerror
			}
			state = fflib.FFParse_want_key
			continue

		case fflib.FFParse_after_value:
			if tok == fflib.FFTok_comma {
				state = fflib.FFParse_want_key
			} else if tok == fflib.FFTok_right_bracket {
				goto done
			} else {
				wantedTok = fflib.FFTok_comma
				goto wrongtokenerror
			}

		case fflib.FFParse_want_key:
			// json {} ended. goto exit. woo.
			if tok == fflib.FFTok_right_bracket {
				goto done
			}
			if tok != fflib.FFTok_string {
				wantedTok = fflib.FFTok_string
				goto wrongtokenerror
			}

			kn := fs.Output.Bytes()
			if len(kn) <= 0 {
				// "" case. hrm.
				currentKey = ffj_t_Offer_Operation_GrowVolumeno_such_key
				state = fflib.FFParse_want_colon
				goto mainparse
			} else {
				switch kn[0] {

				case 'a':

					if bytes.Equal(ffj_key_Offer_Operation_GrowVolume_Addition, kn) {
						currentKey = ffj_t_Offer_Operation_GrowVolume_Addition
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				case 'v':

					if bytes.Equal(ffj_key_Offer_Operation_GrowVolume_Volume, kn) {
						currentKey = ffj_t_Offer_Operation_GrowVolume_Volume
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				}

				if fflib.SimpleLetterEqualFold(ffj_key_Offer_Operation_GrowVolume_Addition, kn) {
					currentKey = ffj_t_Offer_Operation_GrowVolume_Addition
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.SimpleLetterEqualFold(ffj_key_Offer_Operation_GrowVolume_Volume, kn) {
					currentKey = ffj_t_Offer_Operation_GrowVolume_Volume
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				currentKey = ffj_t_Offer_Operation_GrowVolumeno_such_key
				state = fflib.FFParse_want_colon
				goto mainparse
			}

		case fflib.FFParse_want_colon:
			if tok != fflib.FFTok_colon {
				wantedTok = fflib.FFTok_colon
				goto wrongtokenerror
			}
			state = fflib.FFParse_want_value
			continue
		case fflib.FFParse_want_value:

			if tok == fflib.FFTok_left_brace || tok == fflib.FFTok_left_bracket || tok == fflib.FFTok_integer || tok == fflib.FFTok_double || tok == fflib.FFTok_string || tok == fflib.FFTok_bool || tok == fflib.FFTok_null {
				switch currentKey {

				case ffj_t_Offer_Operation_GrowVolume_Volume:
					goto handle_Volume

				case ffj_t_Offer_Operation_GrowVolume_Addition:
					goto handle_Addition

				case ffj_t_Offer_Operation_GrowVolumeno_such_key:
					err = fs.SkipField(tok)
					if err != nil {
						return fs.WrapErr(err)
					}
					state = fflib.FFParse_after_value
					goto mainparse
				}
			} else {
				goto wantedvalue
			}
		}
	}

handle_Volume:

	/* handler: uj.Volume type=mesos.Resource kind=struct quoted=false*/

	{
		if tok == fflib.FFTok_null {

			state = fflib.FFParse_after_value
			goto mainparse
		}

		err = uj.Volume.UnmarshalJSONFFLexer(fs, fflib.FFParse_want_key)
		if err != nil {
			return err
		}
		state = fflib.FFParse_after_value
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_Addition:

	/* handler: uj.Addition type=mesos.Resource kind=struct quoted=false*/

	{
		if tok == fflib.FFTok_null {

			state = fflib.FFParse_after_value
			goto mainparse
		}

		err = uj.Addition.UnmarshalJSONFFLexer(fs, fflib.FFParse_want_key)
		if err != nil {
			return err
		}
		state = fflib.FFParse_after_value
	}

	state = fflib.FFParse_after_value
	goto mainparse

wantedvalue:
	return fs.WrapErr(fmt.Errorf("wanted value token, but got token: %v", tok))
wrongtokenerror:
	return fs.WrapErr(fmt.Errorf("ffjson: wanted token: %v, but got token: %v output=%s", wantedTok, tok, fs.Output.String()))
tokerror:
	if fs.BigError != nil {
		return fs.WrapErr(fs.BigError)
	}
	err = fs.Error.ToError()
	if err != nil {
		return fs.WrapErr(err)
	}
	panic("ffjson-generated: unreachable, please report bug.")
done:

	return nil
}

func (mj *Offer_Operation_Launch) MarshalJSON() ([]byte, error) {
	var buf fflib.Buffer
	if mj == nil {
		buf.WriteString("null")
		return buf.Bytes(), nil
	}
	err := mj.MarshalJSONBuf(&buf)
	if err != nil {
		return nil, err
	}
	return buf.Bytes(), nil
}
func (mj *Offer_Operation_Launch) MarshalJSONBuf(buf fflib.EncodingBuffer) error {
	if mj == nil {
		buf.WriteString("null")
		return nil
	}
	var err error
	var obj []byte
	_ = obj
	_ = err
	buf.WriteString(`{"task_infos":`)
	if mj.TaskInfos != nil {
		buf.WriteString(`[`)
		for i, v := range mj.TaskInfos {
			if i != 0 {
				buf.WriteString(`,`)
			}

			{

				err = v.MarshalJSONBuf(buf)
				if err != nil {
					return err
				}

			}
		}
		buf.WriteString(`]`)
	} else {
		buf.WriteString(`null`)
	}
	buf.WriteByte('}')
	return nil
}

const (
	ffj_t_Offer_Operation_Launchbase = iota
	ffj_t_Offer_Operation_Launchno_such_key

	ffj_t_Offer_Operation_Launch_TaskInfos
)

var ffj_key_Offer_Operation_Launch_TaskInfos = []byte("task_infos")

func (uj *Offer_Operation_Launch) UnmarshalJSON(input []byte) error {
	fs := fflib.NewFFLexer(input)
	return uj.UnmarshalJSONFFLexer(fs, fflib.FFParse_map_start)
}

func (uj *Offer_Operation_Launch) UnmarshalJSONFFLexer(fs *fflib.FFLexer, state fflib.FFParseState) error {
	var err error = nil
	currentKey := ffj_t_Offer_Operation_Launchbase
	_ = currentKey
	tok := fflib.FFTok_init
	wantedTok := fflib.FFTok_init

mainparse:
	for {
		tok = fs.Scan()
		//	println(fmt.Sprintf("debug: tok: %v  state: %v", tok, state))
		if tok == fflib.FFTok_error {
			goto tokerror
		}

		switch state {

		case fflib.FFParse_map_start:
			if tok != fflib.FFTok_left_bracket {
				wantedTok = fflib.FFTok_left_bracket
				goto wrongtokenerror
			}
			state = fflib.FFParse_want_key
			continue

		case fflib.FFParse_after_value:
			if tok == fflib.FFTok_comma {
				state = fflib.FFParse_want_key
			} else if tok == fflib.FFTok_right_bracket {
				goto done
			} else {
				wantedTok = fflib.FFTok_comma
				goto wrongtokenerror
			}

		case fflib.FFParse_want_key:
			// json {} ended. goto exit. woo.
			if tok == fflib.FFTok_right_bracket {
				goto done
			}
			if tok != fflib.FFTok_string {
				wantedTok = fflib.FFTok_string
				goto wrongtokenerror
			}

			kn := fs.Output.Bytes()
			if len(kn) <= 0 {
				// "" case. hrm.
				currentKey = ffj_t_Offer_Operation_Launchno_such_key
				state = fflib.FFParse_want_colon
				goto mainparse
			} else {
				switch kn[0] {

				case 't':

					if bytes.Equal(ffj_key_Offer_Operation_Launch_TaskInfos, kn) {
						currentKey = ffj_t_Offer_Operation_Launch_TaskInfos
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				}

				if fflib.EqualFoldRight(ffj_key_Offer_Operation_Launch_TaskInfos, kn) {
					currentKey = ffj_t_Offer_Operation_Launch_TaskInfos
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				currentKey = ffj_t_Offer_Operation_Launchno_such_key
				state = fflib.FFParse_want_colon
				goto mainparse
			}

		case fflib.FFParse_want_colon:
			if tok != fflib.FFTok_colon {
				wantedTok = fflib.FFTok_colon
				goto wrongtokenerror
			}
			state = fflib.FFParse_want_value
			continue
		case fflib.FFParse_want_value:

			if tok == fflib.FFTok_left_brace || tok == fflib.FFTok_left_bracket || tok == fflib.FFTok_integer || tok == fflib.FFTok_double || tok == fflib.FFTok_string || tok == fflib.FFTok_bool || tok == fflib.FFTok_null {
				switch currentKey {

				case ffj_t_Offer_Operation_Launch_TaskInfos:
					goto handle_TaskInfos

				case ffj_t_Offer_Operation_Launchno_such_key:
					err = fs.SkipField(tok)
					if err != nil {
						return fs.WrapErr(err)
					}
					state = fflib.FFParse_after_value
					goto mainparse
				}
			} else {
				goto wantedvalue
			}
		}
	}

handle_TaskInfos:

	/* handler: uj.TaskInfos type=[]mesos.TaskInfo kind=slice quoted=false*/

	{

		{
			if tok != fflib.FFTok_left_brace && tok != fflib.FFTok_null {
				return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for ", tok))
			}
		}

		if tok == fflib.FFTok_null {
			uj.TaskInfos = nil
		} else {

			uj.TaskInfos = []TaskInfo{}

			wantVal := true

			for {

				var tmp_uj__TaskInfos TaskInfo

				tok = fs.Scan()
				if tok == fflib.FFTok_error {
					goto tokerror
				}
				if tok == fflib.FFTok_right_brace {
					break
				}

				if tok == fflib.FFTok_comma {
					if wantVal == true {
						// TODO(pquerna): this isn't an ideal error message, this handles
						// things like [,,,] as an array value.
						return fs.WrapErr(fmt.Errorf("wanted value token, but got token: %v", tok))
					}
					continue
				} else {
					wantVal = true
				}

				/* handler: tmp_uj__TaskInfos type=mesos.TaskInfo kind=struct quoted=false*/

				{
					if tok == fflib.FFTok_null {

						state = fflib.FFParse_after_value
						goto mainparse
					}

					err = tmp_uj__TaskInfos.UnmarshalJSONFFLexer(fs, fflib.FFParse_want_key)
					if err != nil {
						return err
					}
					state = fflib.FFParse_after_value
				}

				uj.TaskInfos = append(uj.TaskInfos, tmp_uj__TaskInfos)

				wantVal = false
			}
		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

wantedvalue:
	return fs.WrapErr(fmt.Errorf("wanted value token, but got token: %v", tok))
wrongtokenerror:
	return fs.WrapErr(fmt.Errorf("ffjson: wanted token: %v, but got token: %v output=%s", wantedTok, tok, fs.Output.String()))
tokerror:
	if fs.BigError != nil {
		return fs.WrapErr(fs.BigError)
	}
	err = fs.Error.ToError()
	if err != nil {
		return fs.WrapErr(err)
	}
	panic("ffjson-generated: unreachable, please report bug.")
done:

	return nil
}

func (mj *Offer_Operation_LaunchGroup) MarshalJSON() ([]byte, error) {
	var buf fflib.Buffer
	if mj == nil {
		buf.WriteString("null")
		return buf.Bytes(), nil
	}
	err := mj.MarshalJSONBuf(&buf)
	if err != nil {
		return nil, err
	}
	return buf.Bytes(), nil
}
func (mj *Offer_Operation_LaunchGroup) MarshalJSONBuf(buf fflib.EncodingBuffer) error {
	if mj == nil {
		buf.WriteString("null")
		return nil
	}
	var err error
	var obj []byte
	_ = obj
	_ = err
	buf.WriteString(`{"executor":`)

	{

		err = mj.Executor.MarshalJSONBuf(buf)
		if err != nil {
			return err
		}

	}
	buf.WriteString(`,"task_group":`)

	{

		err = mj.TaskGroup.MarshalJSONBuf(buf)
		if err != nil {
			return err
		}

	}
	buf.WriteByte('}')
	return nil
}

const (
	ffj_t_Offer_Operation_LaunchGroupbase = iota
	ffj_t_Offer_Operation_LaunchGroupno_such_key

	ffj_t_Offer_Operation_LaunchGroup_Executor

	ffj_t_Offer_Operation_LaunchGroup_TaskGroup
)

var ffj_key_Offer_Operation_LaunchGroup_Executor = []byte("executor")

var ffj_key_Offer_Operation_LaunchGroup_TaskGroup = []byte("task_group")

func (uj *Offer_Operation_LaunchGroup) UnmarshalJSON(input []byte) error {
	fs := fflib.NewFFLexer(input)
	return uj.UnmarshalJSONFFLexer(fs, fflib.FFParse_map_start)
}

func (uj *Offer_Operation_LaunchGroup) UnmarshalJSONFFLexer(fs *fflib.FFLexer, state fflib.FFParseState) error {
	var err error = nil
	currentKey := ffj_t_Offer_Operation_LaunchGroupbase
	_ = currentKey
	tok := fflib.FFTok_init
	wantedTok := fflib.FFTok_init

mainparse:
	for {
		tok = fs.Scan()
		//	println(fmt.Sprintf("debug: tok: %v  state: %v", tok, state))
		if tok == fflib.FFTok_error {
			goto tokerror
		}

		switch state {

		case fflib.FFParse_map_start:
			if tok != fflib.FFTok_left_bracket {
				wantedTok = fflib.FFTok_left_bracket
				goto wrongtokenerror
			}
			state = fflib.FFParse_want_key
			continue

		case fflib.FFParse_after_value:
			if tok == fflib.FFTok_comma {
				state = fflib.FFParse_want_key
			} else if tok == fflib.FFTok_right_bracket {
				goto done
			} else {
				wantedTok = fflib.FFTok_comma
				goto wrongtokenerror
			}

		case fflib.FFParse_want_key:
			// json {} ended. goto exit. woo.
			if tok == fflib.FFTok_right_bracket {
				goto done
			}
			if tok != fflib.FFTok_string {
				wantedTok = fflib.FFTok_string
				goto wrongtokenerror
			}

			kn := fs.Output.Bytes()
			if len(kn) <= 0 {
				// "" case. hrm.
				currentKey = ffj_t_Offer_Operation_LaunchGroupno_such_key
				state = fflib.FFParse_want_colon
				goto mainparse
			} else {
				switch kn[0] {

				case 'e':

					if bytes.Equal(ffj_key_Offer_Operation_LaunchGroup_Executor, kn) {
						currentKey = ffj_t_Offer_Operation_LaunchGroup_Executor
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				case 't':

					if bytes.Equal(ffj_key_Offer_Operation_LaunchGroup_TaskGroup, kn) {
						currentKey = ffj_t_Offer_Operation_LaunchGroup_TaskGroup
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				}

				if fflib.EqualFoldRight(ffj_key_Offer_Operation_LaunchGroup_TaskGroup, kn) {
					currentKey = ffj_t_Offer_Operation_LaunchGroup_TaskGroup
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.SimpleLetterEqualFold(ffj_key_Offer_Operation_LaunchGroup_Executor, kn) {
					currentKey = ffj_t_Offer_Operation_LaunchGroup_Executor
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				currentKey = ffj_t_Offer_Operation_LaunchGroupno_such_key
				state = fflib.FFParse_want_colon
				goto mainparse
			}

		case fflib.FFParse_want_colon:
			if tok != fflib.FFTok_colon {
				wantedTok = fflib.FFTok_colon
				goto wrongtokenerror
			}
			state = fflib.FFParse_want_value
			continue
		case fflib.FFParse_want_value:

			if tok == fflib.FFTok_left_brace || tok == fflib.FFTok_left_bracket || tok == fflib.FFTok_integer || tok == fflib.FFTok_double || tok == fflib.FFTok_string || tok == fflib.FFTok_bool || tok == fflib.FFTok_null {
				switch currentKey {

				case ffj_t_Offer_Operation_LaunchGroup_Executor:
					goto handle_Executor

				case ffj_t_Offer_Operation_LaunchGroup_TaskGroup:
					goto handle_TaskGroup

				case ffj_t_Offer_Operation_LaunchGroupno_such_key:
					err = fs.SkipField(tok)
					if err != nil {
						return fs.WrapErr(err)
					}
					state = fflib.FFParse_after_value
					goto mainparse
				}
			} else {
				goto wantedvalue
			}
		}
	}

handle_Executor:

	/* handler: uj.Executor type=mesos.ExecutorInfo kind=struct quoted=false*/

	{
		if tok == fflib.FFTok_null {

			state = fflib.FFParse_after_value
			goto mainparse
		}

		err = uj.Executor.UnmarshalJSONFFLexer(fs, fflib.FFParse_want_key)
		if err != nil {
			return err
		}
		state = fflib.FFParse_after_value
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_TaskGroup:

	/* handler: uj.TaskGroup type=mesos.TaskGroupInfo kind=struct quoted=false*/

	{
		if tok == fflib.FFTok_null {

			state = fflib.FFParse_after_value
			goto mainparse
		}

		err = uj.TaskGroup.UnmarshalJSONFFLexer(fs, fflib.FFParse_want_key)
		if err != nil {
			return err
		}
		state = fflib.FFParse_after_value
	}

	state = fflib.FFParse_after_value
	goto mainparse

wantedvalue:
	return fs.WrapErr(fmt.Errorf("wanted value token, but got token: %v", tok))
wrongtokenerror:
	return fs.WrapErr(fmt.Errorf("ffjson: wanted token: %v, but got token: %v output=%s", wantedTok, tok, fs.Output.String()))
tokerror:
	if fs.BigError != nil {
		return fs.WrapErr(fs.BigError)
	}
	err = fs.Error.ToError()
	if err != nil {
		return fs.WrapErr(err)
	}
	panic("ffjson-generated: unreachable, please report bug.")
done:

	return nil
}

func (mj *Offer_Operation_Reserve) MarshalJSON() ([]byte, error) {
	var buf fflib.Buffer
	if mj == nil {
		buf.WriteString("null")
		return buf.Bytes(), nil
	}
	err := mj.MarshalJSONBuf(&buf)
	if err != nil {
		return nil, err
	}
	return buf.Bytes(), nil
}
func (mj *Offer_Operation_Reserve) MarshalJSONBuf(buf fflib.EncodingBuffer) error {
	if mj == nil {
		buf.WriteString("null")
		return nil
	}
	var err error
	var obj []byte
	_ = obj
	_ = err
	buf.WriteString(`{"source":`)
	if mj.Source != nil {
		buf.WriteString(`[`)
		for i, v := range mj.Source {
			if i != 0 {
				buf.WriteString(`,`)
			}

			{

				err = v.MarshalJSONBuf(buf)
				if err != nil {
					return err
				}

			}
		}
		buf.WriteString(`]`)
	} else {
		buf.WriteString(`null`)
	}
	buf.WriteString(`,"resources":`)
	if mj.Resources != nil {
		buf.WriteString(`[`)
		for i, v := range mj.Resources {
			if i != 0 {
				buf.WriteString(`,`)
			}

			{

				err = v.MarshalJSONBuf(buf)
				if err != nil {
					return err
				}

			}
		}
		buf.WriteString(`]`)
	} else {
		buf.WriteString(`null`)
	}
	buf.WriteByte('}')
	return nil
}

const (
	ffj_t_Offer_Operation_Reservebase = iota
	ffj_t_Offer_Operation_Reserveno_such_key

	ffj_t_Offer_Operation_Reserve_Source

	ffj_t_Offer_Operation_Reserve_Resources
)

var ffj_key_Offer_Operation_Reserve_Source = []byte("source")

var ffj_key_Offer_Operation_Reserve_Resources = []byte("resources")

func (uj *Offer_Operation_Reserve) UnmarshalJSON(input []byte) error {
	fs := fflib.NewFFLexer(input)
	return uj.UnmarshalJSONFFLexer(fs, fflib.FFParse_map_start)
}

func (uj *Offer_Operation_Reserve) UnmarshalJSONFFLexer(fs *fflib.FFLexer, state fflib.FFParseState) error {
	var err error = nil
	currentKey := ffj_t_Offer_Operation_Reservebase
	_ = currentKey
	tok := fflib.FFTok_init
	wantedTok := fflib.FFTok_init

mainparse:
	for {
		tok = fs.Scan()
		//	println(fmt.Sprintf("debug: tok: %v  state: %v", tok, state))
		if tok == fflib.FFTok_error {
			goto tokerror
		}

		switch state {

		case fflib.FFParse_map_start:
			if tok != fflib.FFTok_left_bracket {
				wantedTok = fflib.FFTok_left_bracket
				goto wrongtokenerror
			}
			state = fflib.FFParse_want_key
			continue

		case fflib.FFParse_after_value:
			if tok == fflib.FFTok_comma {
				state = fflib.FFParse_want_key
			} else if tok == fflib.FFTok_right_bracket {
				goto done
			} else {
				wantedTok = fflib.FFTok_comma
				goto wrongtokenerror
			}

		case fflib.FFParse_want_key:
			// json {} ended. goto exit. woo.
			if tok == fflib.FFTok_right_bracket {
				goto done
			}
			if tok != fflib.FFTok_string {
				wantedTok = fflib.FFTok_string
				goto wrongtokenerror
			}

			kn := fs.Output.Bytes()
			if len(kn) <= 0 {
				// "" case. hrm.
				currentKey = ffj_t_Offer_Operation_Reserveno_such_key
				state = fflib.FFParse_want_colon
				goto mainparse
			} else {
				switch kn[0] {

				case 'r':

					if bytes.Equal(ffj_key_Offer_Operation_Reserve_Resources, kn) {
						currentKey = ffj_t_Offer_Operation_Reserve_Resources
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				case 's':

					if bytes.Equal(ffj_key_Offer_Operation_Reserve_Source, kn) {
						currentKey = ffj_t_Offer_Operation_Reserve_Source
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				}

				if fflib.EqualFoldRight(ffj_key_Offer_Operation_Reserve_Resources, kn) {
					currentKey = ffj_t_Offer_Operation_Reserve_Resources
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffj_key_Offer_Operation_Reserve_Source, kn) {
					currentKey = ffj_t_Offer_Operation_Reserve_Source
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				currentKey = ffj_t_Offer_Operation_Reserveno_such_key
				state = fflib.FFParse_want_colon
				goto mainparse
			}

		case fflib.FFParse_want_colon:
			if tok != fflib.FFTok_colon {
				wantedTok = fflib.FFTok_colon
				goto wrongtokenerror
			}
			state = fflib.FFParse_want_value
			continue
		case fflib.FFParse_want_value:

			if tok == fflib.FFTok_left_brace || tok == fflib.FFTok_left_bracket || tok == fflib.FFTok_integer || tok == fflib.FFTok_double || tok == fflib.FFTok_string || tok == fflib.FFTok_bool || tok == fflib.FFTok_null {
				switch currentKey {

				case ffj_t_Offer_Operation_Reserve_Source:
					goto handle_Source

				case ffj_t_Offer_Operation_Reserve_Resources:
					goto handle_Resources

				case ffj_t_Offer_Operation_Reserveno_such_key:
					err = fs.SkipField(tok)
					if err != nil {
						return fs.WrapErr(err)
					}
					state = fflib.FFParse_after_value
					goto mainparse
				}
			} else {
				goto wantedvalue
			}
		}
	}

handle_Source:

	/* handler: uj.Source type=[]mesos.Resource kind=slice quoted=false*/

	{

		{
			if tok != fflib.FFTok_left_brace && tok != fflib.FFTok_null {
				return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for ", tok))
			}
		}

		if tok == fflib.FFTok_null {
			uj.Source = nil
		} else {

			uj.Source = []Resource{}

			wantVal := true

			for {

				var tmp_uj__Source Resource

				tok = fs.Scan()
				if tok == fflib.FFTok_error {
					goto tokerror
				}
				if tok == fflib.FFTok_right_brace {
					break
				}

				if tok == fflib.FFTok_comma {
					if wantVal == true {
						// TODO(pquerna): this isn't an ideal error message, this handles
						// things like [,,,] as an array value.
						return fs.WrapErr(fmt.Errorf("wanted value token, but got token: %v", tok))
					}
					continue
				} else {
					wantVal = true
				}

				/* handler: tmp_uj__Source type=mesos.Resource kind=struct quoted=false*/

				{
					if tok == fflib.FFTok_null {

						state = fflib.FFParse_after_value
						goto mainparse
					}

					err = tmp_uj__Source.UnmarshalJSONFFLexer(fs, fflib.FFParse_want_key)
					if err != nil {
						return err
					}
					state = fflib.FFParse_after_value
				}

				uj.Source = append(uj.Source, tmp_uj__Source)

				wantVal = false
			}
		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_Resources:

	/* handler: uj.Resources type=[]mesos.Resource kind=slice quoted=false*/

	{

		{
			if tok != fflib.FFTok_left_brace && tok != fflib.FFTok_null {
				return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for ", tok))
			}
		}

		if tok == fflib.FFTok_null {
			uj.Resources = nil
		} else {

			uj.Resources = []Resource{}

			wantVal := true

			for {

				var tmp_uj__Resources Resource

				tok = fs.Scan()
				if tok == fflib.FFTok_error {
					goto tokerror
				}
				if tok == fflib.FFTok_right_brace {
					break
				}

				if tok == fflib.FFTok_comma {
					if wantVal == true {
						// TODO(pquerna): this isn't an ideal error message, this handles
						// things like [,,,] as an array value.
						return fs.WrapErr(fmt.Errorf("wanted value token, but got token: %v", tok))
					}
					continue
				} else {
					wantVal = true
				}

				/* handler: tmp_uj__Resources type=mesos.Resource kind=struct quoted=false*/

				{
					if tok == fflib.FFTok_null {

						state = fflib.FFParse_after_value
						goto mainparse
					}

					err = tmp_uj__Resources.UnmarshalJSONFFLexer(fs, fflib.FFParse_want_key)
					if err != nil {
						return err
					}
					state = fflib.FFParse_after_value
				}

				uj.Resources = append(uj.Resources, tmp_uj__Resources)

				wantVal = false
			}
		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

wantedvalue:
	return fs.WrapErr(fmt.Errorf("wanted value token, but got token: %v", tok))
wrongtokenerror:
	return fs.WrapErr(fmt.Errorf("ffjson: wanted token: %v, but got token: %v output=%s", wantedTok, tok, fs.Output.String()))
tokerror:
	if fs.BigError != nil {
		return fs.WrapErr(fs.BigError)
	}
	err = fs.Error.ToError()
	if err != nil {
		return fs.WrapErr(err)
	}
	panic("ffjson-generated: unreachable, please report bug.")
done:

	return nil
}

func (mj *Offer_Operation_ShrinkVolume) MarshalJSON() ([]byte, error) {
	var buf fflib.Buffer
	if mj == nil {
		buf.WriteString("null")
		return buf.Bytes(), nil
	}
	err := mj.MarshalJSONBuf(&buf)
	if err != nil {
		return nil, err
	}
	return buf.Bytes(), nil
}
func (mj *Offer_Operation_ShrinkVolume) MarshalJSONBuf(buf fflib.EncodingBuffer) error {
	if mj == nil {
		buf.WriteString("null")
		return nil
	}
	var err error
	var obj []byte
	_ = obj
	_ = err
	buf.WriteString(`{"volume":`)

	{

		err = mj.Volume.MarshalJSONBuf(buf)
		if err != nil {
			return err
		}

	}
	buf.WriteString(`,"subtract":`)

	{

		err = mj.Subtract.MarshalJSONBuf(buf)
		if err != nil {
			return err
		}

	}
	buf.WriteByte('}')
	return nil
}

const (
	ffj_t_Offer_Operation_ShrinkVolumebase = iota
	ffj_t_Offer_Operation_ShrinkVolumeno_such_key

	ffj_t_Offer_Operation_ShrinkVolume_Volume

	ffj_t_Offer_Operation_ShrinkVolume_Subtract
)

var ffj_key_Offer_Operation_ShrinkVolume_Volume = []byte("volume")

var ffj_key_Offer_Operation_ShrinkVolume_Subtract = []byte("subtract")

func (uj *Offer_Operation_ShrinkVolume) UnmarshalJSON(input []byte) error {
	fs := fflib.NewFFLexer(input)
	return uj.UnmarshalJSONFFLexer(fs, fflib.FFParse_map_start)
}

func (uj *Offer_Operation_ShrinkVolume) UnmarshalJSONFFLexer(fs *fflib.FFLexer, state fflib.FFParseState) error {
	var err error = nil
	currentKey := ffj_t_Offer_Operation_ShrinkVolumebase
	_ = currentKey
	tok := fflib.FFTok_init
	wantedTok := fflib.FFTok_init

mainparse:
	for {
		tok = fs.Scan()
		//	println(fmt.Sprintf("debug: tok: %v  state: %v", tok, state))
		if tok == fflib.FFTok_error {
			goto tokerror
		}

		switch state {

		case fflib.FFParse_map_start:
			if tok != fflib.FFTok_left_bracket {
				wantedTok = fflib.FFTok_left_bracket
				goto wrongtokenerror
			}
			state = fflib.FFParse_want_key
			continue

		case fflib.FFParse_after_value:
			if tok == fflib.FFTok_comma {
				state = fflib.FFParse_want_key
			} else if tok == fflib.FFTok_right_bracket {
				goto done
			} else {
				wantedTok = fflib.FFTok_comma
				goto wrongtokenerror
			}

		case fflib.FFParse_want_key:
			// json {} ended. goto exit. woo.
			if tok == fflib.FFTok_right_bracket {
				goto done
			}
			if tok != fflib.FFTok_string {
				wantedTok = fflib.FFTok_string
				goto wrongtokenerror
			}

			kn := fs.Output.Bytes()
			if len(kn) <= 0 {
				// "" case. hrm.
				currentKey = ffj_t_Offer_Operation_ShrinkVolumeno_such_key
				state = fflib.FFParse_want_colon
				goto mainparse
			} else {
				switch kn[0] {

				case 's':

					if bytes.Equal(ffj_key_Offer_Operation_ShrinkVolume_Subtract, kn) {
						currentKey = ffj_t_Offer_Operation_ShrinkVolume_Subtract
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				case 'v':

					if bytes.Equal(ffj_key_Offer_Operation_ShrinkVolume_Volume, kn) {
						currentKey = ffj_t_Offer_Operation_ShrinkVolume_Volume
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				}

				if fflib.EqualFoldRight(ffj_key_Offer_Operation_ShrinkVolume_Subtract, kn) {
					currentKey = ffj_t_Offer_Operation_ShrinkVolume_Subtract
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.SimpleLetterEqualFold(ffj_key_Offer_Operation_ShrinkVolume_Volume, kn) {
					currentKey = ffj_t_Offer_Operation_ShrinkVolume_Volume
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				currentKey = ffj_t_Offer_Operation_ShrinkVolumeno_such_key
				state = fflib.FFParse_want_colon
				goto mainparse
			}

		case fflib.FFParse_want_colon:
			if tok != fflib.FFTok_colon {
				wantedTok = fflib.FFTok_colon
				goto wrongtokenerror
			}
			state = fflib.FFParse_want_value
			continue
		case fflib.FFParse_want_value:

			if tok == fflib.FFTok_left_brace || tok == fflib.FFTok_left_bracket || tok == fflib.FFTok_integer || tok == fflib.FFTok_double || tok == fflib.FFTok_string || tok == fflib.FFTok_bool || tok == fflib.FFTok_null {
				switch currentKey {

				case ffj_t_Offer_Operation_ShrinkVolume_Volume:
					goto handle_Volume

				case ffj_t_Offer_Operation_ShrinkVolume_Subtract:
					goto handle_Subtract

				case ffj_t_Offer_Operation_ShrinkVolumeno_such_key:
					err = fs.SkipField(tok)
					if err != nil {
						return fs.WrapErr(err)
					}
					state = fflib.FFParse_after_value
					goto mainparse
				}
			} else {
				goto wantedvalue
			}
		}
	}

handle_Volume:

	/* handler: uj.Volume type=mesos.Resource kind=struct quoted=false*/

	{
		if tok == fflib.FFTok_null {

			state = fflib.FFParse_after_value
			goto mainparse
		}

		err = uj.Volume.UnmarshalJSONFFLexer(fs, fflib.FFParse_want_key)
		if err != nil {
			return err
		}
		state = fflib.FFParse_after_value
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_Subtract:

	/* handler: uj.Subtract type=mesos.Value_Scalar kind=struct quoted=false*/

	{
		if tok == fflib.FFTok_null {

			state = fflib.FFParse_after_value
			goto mainparse
		}

		err = uj.Subtract.UnmarshalJSONFFLexer(fs, fflib.FFParse_want_key)
		if err != nil {
			return err
		}
		state = fflib.FFParse_after_value
	}

	state = fflib.FFParse_after_value
	goto mainparse

wantedvalue:
	return fs.WrapErr(fmt.Errorf("wanted value token, but got token: %v", tok))
wrongtokenerror:
	return fs.WrapErr(fmt.Errorf("ffjson: wanted token: %v, but got token: %v output=%s", wantedTok, tok, fs.Output.String()))
tokerror:
	if fs.BigError != nil {
		return fs.WrapErr(fs.BigError)
	}
	err = fs.Error.ToError()
	if err != nil {
		return fs.WrapErr(err)
	}
	panic("ffjson-generated: unreachable, please report bug.")
done:

	return nil
}

func (mj *Offer_Operation_Unreserve) MarshalJSON() ([]byte, error) {
	var buf fflib.Buffer
	if mj == nil {
		buf.WriteString("null")
		return buf.Bytes(), nil
	}
	err := mj.MarshalJSONBuf(&buf)
	if err != nil {
		return nil, err
	}
	return buf.Bytes(), nil
}
func (mj *Offer_Operation_Unreserve) MarshalJSONBuf(buf fflib.EncodingBuffer) error {
	if mj == nil {
		buf.WriteString("null")
		return nil
	}
	var err error
	var obj []byte
	_ = obj
	_ = err
	buf.WriteString(`{"resources":`)
	if mj.Resources != nil {
		buf.WriteString(`[`)
		for i, v := range mj.Resources {
			if i != 0 {
				buf.WriteString(`,`)
			}

			{

				err = v.MarshalJSONBuf(buf)
				if err != nil {
					return err
				}

			}
		}
		buf.WriteString(`]`)
	} else {
		buf.WriteString(`null`)
	}
	buf.WriteByte('}')
	return nil
}

const (
	ffj_t_Offer_Operation_Unreservebase = iota
	ffj_t_Offer_Operation_Unreserveno_such_key

	ffj_t_Offer_Operation_Unreserve_Resources
)

var ffj_key_Offer_Operation_Unreserve_Resources = []byte("resources")

func (uj *Offer_Operation_Unreserve) UnmarshalJSON(input []byte) error {
	fs := fflib.NewFFLexer(input)
	return uj.UnmarshalJSONFFLexer(fs, fflib.FFParse_map_start)
}

func (uj *Offer_Operation_Unreserve) UnmarshalJSONFFLexer(fs *fflib.FFLexer, state fflib.FFParseState) error {
	var err error = nil
	currentKey := ffj_t_Offer_Operation_Unreservebase
	_ = currentKey
	tok := fflib.FFTok_init
	wantedTok := fflib.FFTok_init

mainparse:
	for {
		tok = fs.Scan()
		//	println(fmt.Sprintf("debug: tok: %v  state: %v", tok, state))
		if tok == fflib.FFTok_error {
			goto tokerror
		}

		switch state {

		case fflib.FFParse_map_start:
			if tok != fflib.FFTok_left_bracket {
				wantedTok = fflib.FFTok_left_bracket
				goto wrongtokenerror
			}
			state = fflib.FFParse_want_key
			continue

		case fflib.FFParse_after_value:
			if tok == fflib.FFTok_comma {
				state = fflib.FFParse_want_key
			} else if tok == fflib.FFTok_right_bracket {
				goto done
			} else {
				wantedTok = fflib.FFTok_comma
				goto wrongtokenerror
			}

		case fflib.FFParse_want_key:
			// json {} ended. goto exit. woo.
			if tok == fflib.FFTok_right_bracket {
				goto done
			}
			if tok != fflib.FFTok_string {
				wantedTok = fflib.FFTok_string
				goto wrongtokenerror
			}

			kn := fs.Output.Bytes()
			if len(kn) <= 0 {
				// "" case. hrm.
				currentKey = ffj_t_Offer_Operation_Unreserveno_such_key
				state = fflib.FFParse_want_colon
				goto mainparse
			} else {
				switch kn[0] {

				case 'r':

					if bytes.Equal(ffj_key_Offer_Operation_Unreserve_Resources, kn) {
						currentKey = ffj_t_Offer_Operation_Unreserve_Resources
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				}

				if fflib.EqualFoldRight(ffj_key_Offer_Operation_Unreserve_Resources, kn) {
					currentKey = ffj_t_Offer_Operation_Unreserve_Resources
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				currentKey = ffj_t_Offer_Operation_Unreserveno_such_key
				state = fflib.FFParse_want_colon
				goto mainparse
			}

		case fflib.FFParse_want_colon:
			if tok != fflib.FFTok_colon {
				wantedTok = fflib.FFTok_colon
				goto wrongtokenerror
			}
			state = fflib.FFParse_want_value
			continue
		case fflib.FFParse_want_value:

			if tok == fflib.FFTok_left_brace || tok == fflib.FFTok_left_bracket || tok == fflib.FFTok_integer || tok == fflib.FFTok_double || tok == fflib.FFTok_string || tok == fflib.FFTok_bool || tok == fflib.FFTok_null {
				switch currentKey {

				case ffj_t_Offer_Operation_Unreserve_Resources:
					goto handle_Resources

				case ffj_t_Offer_Operation_Unreserveno_such_key:
					err = fs.SkipField(tok)
					if err != nil {
						return fs.WrapErr(err)
					}
					state = fflib.FFParse_after_value
					goto mainparse
				}
			} else {
				goto wantedvalue
			}
		}
	}

handle_Resources:

	/* handler: uj.Resources type=[]mesos.Resource kind=slice quoted=false*/

	{

		{
			if tok != fflib.FFTok_left_brace && tok != fflib.FFTok_null {
				return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for ", tok))
			}
		}

		if tok == fflib.FFTok_null {
			uj.Resources = nil
		} else {

			uj.Resources = []Resource{}

			wantVal := true

			for {

				var tmp_uj__Resources Resource

				tok = fs.Scan()
				if tok == fflib.FFTok_error {
					goto tokerror
				}
				if tok == fflib.FFTok_right_brace {
					break
				}

				if tok == fflib.FFTok_comma {
					if wantVal == true {
						// TODO(pquerna): this isn't an ideal error message, this handles
						// things like [,,,] as an array value.
						return fs.WrapErr(fmt.Errorf("wanted value token, but got token: %v", tok))
					}
					continue
				} else {
					wantVal = true
				}

				/* handler: tmp_uj__Resources type=mesos.Resource kind=struct quoted=false*/

				{
					if tok == fflib.FFTok_null {

						state = fflib.FFParse_after_value
						goto mainparse
					}

					err = tmp_uj__Resources.UnmarshalJSONFFLexer(fs, fflib.FFParse_want_key)
					if err != nil {
						return err
					}
					state = fflib.FFParse_after_value
				}

				uj.Resources = append(uj.Resources, tmp_uj__Resources)

				wantVal = false
			}
		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

wantedvalue:
	return fs.WrapErr(fmt.Errorf("wanted value token, but got token: %v", tok))
wrongtokenerror:
	return fs.WrapErr(fmt.Errorf("ffjson: wanted token: %v, but got token: %v output=%s", wantedTok, tok, fs.Output.String()))
tokerror:
	if fs.BigError != nil {
		return fs.WrapErr(fs.BigError)
	}
	err = fs.Error.ToError()
	if err != nil {
		return fs.WrapErr(err)
	}
	panic("ffjson-generated: unreachable, please report bug.")
done:

	return nil
}

func (mj *Operation) MarshalJSON() ([]byte, error) {
	var buf fflib.Buffer
	if mj == nil {
		buf.WriteString("null")
		return buf.Bytes(), nil
	}
	err := mj.MarshalJSONBuf(&buf)
	if err != nil {
		return nil, err
	}
	return buf.Bytes(), nil
}
func (mj *Operation) MarshalJSONBuf(buf fflib.EncodingBuffer) error {
	if mj == nil {
		buf.WriteString("null")
		return nil
	}
	var err error
	var obj []byte
	_ = obj
	_ = err
	buf.WriteByte('{')
	if mj.FrameworkID != nil {
		if true {
			buf.WriteString(`"framework_id":`)

			{

				err = mj.FrameworkID.MarshalJSONBuf(buf)
				if err != nil {
					return err
				}

			}
			buf.WriteByte(',')
		}
	}
	if mj.AgentID != nil {
		if true {
			buf.WriteString(`"agent_id":`)

			{

				err = mj.AgentID.MarshalJSONBuf(buf)
				if err != nil {
					return err
				}

			}
			buf.WriteByte(',')
		}
	}
	buf.WriteString(`"info":`)

	{

		err = mj.Info.MarshalJSONBuf(buf)
		if err != nil {
			return err
		}

	}
	buf.WriteString(`,"latest_status":`)

	{

		err = mj.LatestStatus.MarshalJSONBuf(buf)
		if err != nil {
			return err
		}

	}
	buf.WriteString(`,"statuses":`)
	if mj.Statuses != nil {
		buf.WriteString(`[`)
		for i, v := range mj.Statuses {
			if i != 0 {
				buf.WriteString(`,`)
			}

			{

				err = v.MarshalJSONBuf(buf)
				if err != nil {
					return err
				}

			}
		}
		buf.WriteString(`]`)
	} else {
		buf.WriteString(`null`)
	}
	buf.WriteString(`,"uuid":`)

	{

		err = mj.UUID.MarshalJSONBuf(buf)
		if err != nil {
			return err
		}

	}
	buf.WriteByte('}')
	return nil
}

const (
	ffj_t_Operationbase = iota
	ffj_t_Operationno_such_key

	ffj_t_Operation_FrameworkID

	ffj_t_Operation_AgentID

	ffj_t_Operation_Info

	ffj_t_Operation_LatestStatus

	ffj_t_Operation_Statuses

	ffj_t_Operation_UUID
)

var ffj_key_Operation_FrameworkID = []byte("framework_id")

var ffj_key_Operation_AgentID = []byte("agent_id")

var ffj_key_Operation_Info = []byte("info")

var ffj_key_Operation_LatestStatus = []byte("latest_status")

var ffj_key_Operation_Statuses = []byte("statuses")

var ffj_key_Operation_UUID = []byte("uuid")

func (uj *Operation) UnmarshalJSON(input []byte) error {
	fs := fflib.NewFFLexer(input)
	return uj.UnmarshalJSONFFLexer(fs, fflib.FFParse_map_start)
}

func (uj *Operation) UnmarshalJSONFFLexer(fs *fflib.FFLexer, state fflib.FFParseState) error {
	var err error = nil
	currentKey := ffj_t_Operationbase
	_ = currentKey
	tok := fflib.FFTok_init
	wantedTok := fflib.FFTok_init

mainparse:
	for {
		tok = fs.Scan()
		//	println(fmt.Sprintf("debug: tok: %v  state: %v", tok, state))
		if tok == fflib.FFTok_error {
			goto tokerror
		}

		switch state {

		case fflib.FFParse_map_start:
			if tok != fflib.FFTok_left_bracket {
				wantedTok = fflib.FFTok_left_bracket
				goto wrongtokenerror
			}
			state = fflib.FFParse_want_key
			continue

		case fflib.FFParse_after_value:
			if tok == fflib.FFTok_comma {
				state = fflib.FFParse_want_key
			} else if tok == fflib.FFTok_right_bracket {
				goto done
			} else {
				wantedTok = fflib.FFTok_comma
				goto wrongtokenerror
			}

		case fflib.FFParse_want_key:
			// json {} ended. goto exit. woo.
			if tok == fflib.FFTok_right_bracket {
				goto done
			}
			if tok != fflib.FFTok_string {
				wantedTok = fflib.FFTok_string
				goto wrongtokenerror
			}

			kn := fs.Output.Bytes()
			if len(kn) <= 0 {
				// "" case. hrm.
				currentKey = ffj_t_Operationno_such_key
				state = fflib.FFParse_want_colon
				goto mainparse
			} else {
				switch kn[0] {

				case 'a':

					if bytes.Equal(ffj_key_Operation_AgentID, kn) {
						currentKey = ffj_t_Operation_AgentID
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				case 'f':

					if bytes.Equal(ffj_key_Operation_FrameworkID, kn) {
						currentKey = ffj_t_Operation_FrameworkID
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				case 'i':

					if bytes.Equal(ffj_key_Operation_Info, kn) {
						currentKey = ffj_t_Operation_Info
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				case 'l':

					if bytes.Equal(ffj_key_Operation_LatestStatus, kn) {
						currentKey = ffj_t_Operation_LatestStatus
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				case 's':

					if bytes.Equal(ffj_key_Operation_Statuses, kn) {
						currentKey = ffj_t_Operation_Statuses
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				case 'u':

					if bytes.Equal(ffj_key_Operation_UUID, kn) {
						currentKey = ffj_t_Operation_UUID
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				}

				if fflib.SimpleLetterEqualFold(ffj_key_Operation_UUID, kn) {
					currentKey = ffj_t_Operation_UUID
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffj_key_Operation_Statuses, kn) {
					currentKey = ffj_t_Operation_Statuses
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffj_key_Operation_LatestStatus, kn) {
					currentKey = ffj_t_Operation_LatestStatus
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.SimpleLetterEqualFold(ffj_key_Operation_Info, kn) {
					currentKey = ffj_t_Operation_Info
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.AsciiEqualFold(ffj_key_Operation_AgentID, kn) {
					currentKey = ffj_t_Operation_AgentID
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffj_key_Operation_FrameworkID, kn) {
					currentKey = ffj_t_Operation_FrameworkID
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				currentKey = ffj_t_Operationno_such_key
				state = fflib.FFParse_want_colon
				goto mainparse
			}

		case fflib.FFParse_want_colon:
			if tok != fflib.FFTok_colon {
				wantedTok = fflib.FFTok_colon
				goto wrongtokenerror
			}
			state = fflib.FFParse_want_value
			continue
		case fflib.FFParse_want_value:

			if tok == fflib.FFTok_left_brace || tok == fflib.FFTok_left_bracket || tok == fflib.FFTok_integer || tok == fflib.FFTok_double || tok == fflib.FFTok_string || tok == fflib.FFTok_bool || tok == fflib.FFTok_null {
				switch currentKey {

				case ffj_t_Operation_FrameworkID:
					goto handle_FrameworkID

				case ffj_t_Operation_AgentID:
					goto handle_AgentID

				case ffj_t_Operation_Info:
					goto handle_Info

				case ffj_t_Operation_LatestStatus:
					goto handle_LatestStatus

				case ffj_t_Operation_Statuses:
					goto handle_Statuses

				case ffj_t_Operation_UUID:
					goto handle_UUID

				case ffj_t_Operationno_such_key:
					err = fs.SkipField(tok)
					if err != nil {
						return fs.WrapErr(err)
					}
					state = fflib.FFParse_after_value
					goto mainparse
				}
			} else {
				goto wantedvalue
			}
		}
	}

handle_FrameworkID:

	/* handler: uj.FrameworkID type=mesos.FrameworkID kind=struct quoted=false*/

	{
		if tok == fflib.FFTok_null {

			uj.FrameworkID = nil

			state = fflib.FFParse_after_value
			goto mainparse
		}

		if uj.FrameworkID == nil {
			uj.FrameworkID = new(FrameworkID)
		}

		err = uj.FrameworkID.UnmarshalJSONFFLexer(fs, fflib.FFParse_want_key)
		if err != nil {
			return err
		}
		state = fflib.FFParse_after_value
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_AgentID:

	/* handler: uj.AgentID type=mesos.AgentID kind=struct quoted=false*/

	{
		if tok == fflib.FFTok_null {

			uj.AgentID = nil

			state = fflib.FFParse_after_value
			goto mainparse
		}

		if uj.AgentID == nil {
			uj.AgentID = new(AgentID)
		}

		err = uj.AgentID.UnmarshalJSONFFLexer(fs, fflib.FFParse_want_key)
		if err != nil {
			return err
		}
		state = fflib.FFParse_after_value
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_Info:

	/* handler: uj.Info type=mesos.Offer_Operation kind=struct quoted=false*/

	{
		if tok == fflib.FFTok_null {

			state = fflib.FFParse_after_value
			goto mainparse
		}

		err = uj.Info.UnmarshalJSONFFLexer(fs, fflib.FFParse_want_key)
		if err != nil {
			return err
		}
		state = fflib.FFParse_after_value
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_LatestStatus:

	/* handler: uj.LatestStatus type=mesos.OperationStatus kind=struct quoted=false*/

	{
		if tok == fflib.FFTok_null {

			state = fflib.FFParse_after_value
			goto mainparse
		}

		err = uj.LatestStatus.UnmarshalJSONFFLexer(fs, fflib.FFParse_want_key)
		if err != nil {
			return err
		}
		state = fflib.FFParse_after_value
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_Statuses:

	/* handler: uj.Statuses type=[]mesos.OperationStatus kind=slice quoted=false*/

	{

		{
			if tok != fflib.FFTok_left_brace && tok != fflib.FFTok_null {
				return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for ", tok))
			}
		}

		if tok == fflib.FFTok_null {
			uj.Statuses = nil
		} else {

			uj.Statuses = []OperationStatus{}

			wantVal := true

			for {

				var tmp_uj__Statuses OperationStatus

				tok = fs.Scan()
				if tok == fflib.FFTok_error {
					goto tokerror
				}
				if tok == fflib.FFTok_right_brace {
					break
				}

				if tok == fflib.FFTok_comma {
					if wantVal == true {
						// TODO(pquerna): this isn't an ideal error message, this handles
						// things like [,,,] as an array value.
						return fs.WrapErr(fmt.Errorf("wanted value token, but got token: %v", tok))
					}
					continue
				} else {
					wantVal = true
				}

				/* handler: tmp_uj__Statuses type=mesos.OperationStatus kind=struct quoted=false*/

				{
					if tok == fflib.FFTok_null {

						state = fflib.FFParse_after_value
						goto mainparse
					}

					err = tmp_uj__Statuses.UnmarshalJSONFFLexer(fs, fflib.FFParse_want_key)
					if err != nil {
						return err
					}
					state = fflib.FFParse_after_value
				}

				uj.Statuses = append(uj.Statuses, tmp_uj__Statuses)

				wantVal = false
			}
		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_UUID:

	/* handler: uj.UUID type=mesos.UUID kind=struct quoted=false*/

	{
		if tok == fflib.FFTok_null {

			state = fflib.FFParse_after_value
			goto mainparse
		}

		err = uj.UUID.UnmarshalJSONFFLexer(fs, fflib.FFParse_want_key)
		if err != nil {
			return err
		}
		state = fflib.FFParse_after_value
	}

	state = fflib.FFParse_after_value
	goto mainparse

wantedvalue:
	return fs.WrapErr(fmt.Errorf("wanted value token, but got token: %v", tok))
wrongtokenerror:
	return fs.WrapErr(fmt.Errorf("ffjson: wanted token: %v, but got token: %v output=%s", wantedTok, tok, fs.Output.String()))
tokerror:
	if fs.BigError != nil {
		return fs.WrapErr(fs.BigError)
	}
	err = fs.Error.ToError()
	if err != nil {
		return fs.WrapErr(err)
	}
	panic("ffjson-generated: unreachable, please report bug.")
done:

	return nil
}

func (mj *OperationID) MarshalJSON() ([]byte, error) {
	var buf fflib.Buffer
	if mj == nil {
		buf.WriteString("null")
		return buf.Bytes(), nil
	}
	err := mj.MarshalJSONBuf(&buf)
	if err != nil {
		return nil, err
	}
	return buf.Bytes(), nil
}
func (mj *OperationID) MarshalJSONBuf(buf fflib.EncodingBuffer) error {
	if mj == nil {
		buf.WriteString("null")
		return nil
	}
	var err error
	var obj []byte
	_ = obj
	_ = err
	buf.WriteString(`{"value":`)
	fflib.WriteJsonString(buf, string(mj.Value))
	buf.WriteByte('}')
	return nil
}

const (
	ffj_t_OperationIDbase = iota
	ffj_t_OperationIDno_such_key

	ffj_t_OperationID_Value
)

var ffj_key_OperationID_Value = []byte("value")

func (uj *OperationID) UnmarshalJSON(input []byte) error {
	fs := fflib.NewFFLexer(input)
	return uj.UnmarshalJSONFFLexer(fs, fflib.FFParse_map_start)
}

func (uj *OperationID) UnmarshalJSONFFLexer(fs *fflib.FFLexer, state fflib.FFParseState) error {
	var err error = nil
	currentKey := ffj_t_OperationIDbase
	_ = currentKey
	tok := fflib.FFTok_init
	wantedTok := fflib.FFTok_init

mainparse:
	for {
		tok = fs.Scan()
		//	println(fmt.Sprintf("debug: tok: %v  state: %v", tok, state))
		if tok == fflib.FFTok_error {
			goto tokerror
		}

		switch state {

		case fflib.FFParse_map_start:
			if tok != fflib.FFTok_left_bracket {
				wantedTok = fflib.FFTok_left_bracket
				goto wrongtokenerror
			}
			state = fflib.FFParse_want_key
			continue

		case fflib.FFParse_after_value:
			if tok == fflib.FFTok_comma {
				state = fflib.FFParse_want_key
			} else if tok == fflib.FFTok_right_bracket {
				goto done
			} else {
				wantedTok = fflib.FFTok_comma
				goto wrongtokenerror
			}

		case fflib.FFParse_want_key:
			// json {} ended. goto exit. woo.
			if tok == fflib.FFTok_right_bracket {
				goto done
			}
			if tok != fflib.FFTok_string {
				wantedTok = fflib.FFTok_string
				goto wrongtokenerror
			}

			kn := fs.Output.Bytes()
			if len(kn) <= 0 {
				// "" case. hrm.
				currentKey = ffj_t_OperationIDno_such_key
				state = fflib.FFParse_want_colon
				goto mainparse
			} else {
				switch kn[0] {

				case 'v':

					if bytes.Equal(ffj_key_OperationID_Value, kn) {
						currentKey = ffj_t_OperationID_Value
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				}

				if fflib.SimpleLetterEqualFold(ffj_key_OperationID_Value, kn) {
					currentKey = ffj_t_OperationID_Value
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				currentKey = ffj_t_OperationIDno_such_key
				state = fflib.FFParse_want_colon
				goto mainparse
			}

		case fflib.FFParse_want_colon:
			if tok != fflib.FFTok_colon {
				wantedTok = fflib.FFTok_colon
				goto wrongtokenerror
			}
			state = fflib.FFParse_want_value
			continue
		case fflib.FFParse_want_value:

			if tok == fflib.FFTok_left_brace || tok == fflib.FFTok_left_bracket || tok == fflib.FFTok_integer || tok == fflib.FFTok_double || tok == fflib.FFTok_string || tok == fflib.FFTok_bool || tok == fflib.FFTok_null {
				switch currentKey {

				case ffj_t_OperationID_Value:
					goto handle_Value

				case ffj_t_OperationIDno_such_key:
					err = fs.SkipField(tok)
					if err != nil {
						return fs.WrapErr(err)
					}
					state = fflib.FFParse_after_value
					goto mainparse
				}
			} else {
				goto wantedvalue
			}
		}
	}

handle_Value:

	/* handler: uj.Value type=string kind=string quoted=false*/

	{

		{
			if tok != fflib.FFTok_string && tok != fflib.FFTok_null {
				return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for string", tok))
			}
		}

		if tok == fflib.FFTok_null {

		} else {

			outBuf := fs.Output.Bytes()

			uj.Value = string(string(outBuf))

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

wantedvalue:
	return fs.WrapErr(fmt.Errorf("wanted value token, but got token: %v", tok))
wrongtokenerror:
	return fs.WrapErr(fmt.Errorf("ffjson: wanted token: %v, but got token: %v output=%s", wantedTok, tok, fs.Output.String()))
tokerror:
	if fs.BigError != nil {
		return fs.WrapErr(fs.BigError)
	}
	err = fs.Error.ToError()
	if err != nil {
		return fs.WrapErr(err)
	}
	panic("ffjson-generated: unreachable, please report bug.")
done:

	return nil
}

func (mj *OperationStatus) MarshalJSON() ([]byte, error) {
	var buf fflib.Buffer
	if mj == nil {
		buf.WriteString("null")
		return buf.Bytes(), nil
	}
	err := mj.MarshalJSONBuf(&buf)
	if err != nil {
		return nil, err
	}
	return buf.Bytes(), nil
}
func (mj *OperationStatus) MarshalJSONBuf(buf fflib.EncodingBuffer) error {
	if mj == nil {
		buf.WriteString("null")
		return nil
	}
	var err error
	var obj []byte
	_ = obj
	_ = err
	buf.WriteString(`{ `)
	if mj.OperationID != nil {
		if true {
			buf.WriteString(`"operation_id":`)

			{

				err = mj.OperationID.MarshalJSONBuf(buf)
				if err != nil {
					return err
				}

			}
			buf.WriteByte(',')
		}
	}
	buf.WriteString(`"state":`)

	{

		obj, err = mj.State.MarshalJSON()
		if err != nil {
			return err
		}
		buf.Write(obj)

	}
	buf.WriteByte(',')
	if mj.Message != nil {
		if true {
			buf.WriteString(`"message":`)
			fflib.WriteJsonString(buf, string(*mj.Message))
			buf.WriteByte(',')
		}
	}
	buf.WriteString(`"converted_resources":`)
	if mj.ConvertedResources != nil {
		buf.WriteString(`[`)
		for i, v := range mj.ConvertedResources {
			if i != 0 {
				buf.WriteString(`,`)
			}

			{

				err = v.MarshalJSONBuf(buf)
				if err != nil {
					return err
				}

			}
		}
		buf.WriteString(`]`)
	} else {
		buf.WriteString(`null`)
	}
	buf.WriteByte(',')
	if mj.UUID != nil {
		if true {
			buf.WriteString(`"uuid":`)

			{

				err = mj.UUID.MarshalJSONBuf(buf)
				if err != nil {
					return err
				}

			}
			buf.WriteByte(',')
		}
	}
	if mj.AgentID != nil {
		if true {
			buf.WriteString(`"agent_id":`)

			{

				err = mj.AgentID.MarshalJSONBuf(buf)
				if err != nil {
					return err
				}

			}
			buf.WriteByte(',')
		}
	}
	if mj.ResourceProviderID != nil {
		if true {
			buf.WriteString(`"resource_provider_id":`)

			{

				err = mj.ResourceProviderID.MarshalJSONBuf(buf)
				if err != nil {
					return err
				}

			}
			buf.WriteByte(',')
		}
	}
	buf.Rewind(1)
	buf.WriteByte('}')
	return nil
}

const (
	ffj_t_OperationStatusbase = iota
	ffj_t_OperationStatusno_such_key

	ffj_t_OperationStatus_OperationID

	ffj_t_OperationStatus_State

	ffj_t_OperationStatus_Message

	ffj_t_OperationStatus_ConvertedResources

	ffj_t_OperationStatus_UUID

	ffj_t_OperationStatus_AgentID

	ffj_t_OperationStatus_ResourceProviderID
)

var ffj_key_OperationStatus_OperationID = []byte("operation_id")

var ffj_key_OperationStatus_State = []byte("state")

var ffj_key_OperationStatus_Message = []byte("message")

var ffj_key_OperationStatus_ConvertedResources = []byte("converted_resources")

var ffj_key_OperationStatus_UUID = []byte("uuid")

var ffj_key_OperationStatus_AgentID = []byte("agent_id")

var ffj_key_OperationStatus_ResourceProviderID = []byte("resource_provider_id")

func (uj *OperationStatus) UnmarshalJSON(input []byte) error {
	fs := fflib.NewFFLexer(input)
	return uj.UnmarshalJSONFFLexer(fs, fflib.FFParse_map_start)
}

func (uj *OperationStatus) UnmarshalJSONFFLexer(fs *fflib.FFLexer, state fflib.FFParseState) error {
	var err error = nil
	currentKey := ffj_t_OperationStatusbase
	_ = currentKey
	tok := fflib.FFTok_init
	wantedTok := fflib.FFTok_init

mainparse:
	for {
		tok = fs.Scan()
		//	println(fmt.Sprintf("debug: tok: %v  state: %v", tok, state))
		if tok == fflib.FFTok_error {
			goto tokerror
		}

		switch state {

		case fflib.FFParse_map_start:
			if tok != fflib.FFTok_left_bracket {
				wantedTok = fflib.FFTok_left_bracket
				goto wrongtokenerror
			}
			state = fflib.FFParse_want_key
			continue

		case fflib.FFParse_after_value:
			if tok == fflib.FFTok_comma {
				state = fflib.FFParse_want_key
			} else if tok == fflib.FFTok_right_bracket {
				goto done
			} else {
				wantedTok = fflib.FFTok_comma
				goto wrongtokenerror
			}

		case fflib.FFParse_want_key:
			// json {} ended. goto exit. woo.
			if tok == fflib.FFTok_right_bracket {
				goto done
			}
			if tok != fflib.FFTok_string {
				wantedTok = fflib.FFTok_string
				goto wrongtokenerror
			}

			kn := fs.Output.Bytes()
			if len(kn) <= 0 {
				// "" case. hrm.
				currentKey = ffj_t_OperationStatusno_such_key
				state = fflib.FFParse_want_colon
				goto mainparse
			} else {
				switch kn[0] {

				case 'a':

					if bytes.Equal(ffj_key_OperationStatus_AgentID, kn) {
						currentKey = ffj_t_OperationStatus_AgentID
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				case 'c':

					if bytes.Equal(ffj_key_OperationStatus_ConvertedResources, kn) {
						currentKey = ffj_t_OperationStatus_ConvertedResources
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				case 'm':

					if bytes.Equal(ffj_key_OperationStatus_Message, kn) {
						currentKey = ffj_t_OperationStatus_Message
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				case 'o':

					if bytes.Equal(ffj_key_OperationStatus_OperationID, kn) {
						currentKey = ffj_t_OperationStatus_OperationID
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				case 'r':

					if bytes.Equal(ffj_key_OperationStatus_ResourceProviderID, kn) {
						currentKey = ffj_t_OperationStatus_ResourceProviderID
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				case 's':

					if bytes.Equal(ffj_key_OperationStatus_State, kn) {
						currentKey = ffj_t_OperationStatus_State
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				case 'u':

					if bytes.Equal(ffj_key_OperationStatus_UUID, kn) {
						currentKey = ffj_t_OperationStatus_UUID
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				}

				if fflib.EqualFoldRight(ffj_key_OperationStatus_ResourceProviderID, kn) {
					currentKey = ffj_t_OperationStatus_ResourceProviderID
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.AsciiEqualFold(ffj_key_OperationStatus_AgentID, kn) {
					currentKey = ffj_t_OperationStatus_AgentID
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.SimpleLetterEqualFold(ffj_key_OperationStatus_UUID, kn) {
					currentKey = ffj_t_OperationStatus_UUID
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffj_key_OperationStatus_ConvertedResources, kn) {
					currentKey = ffj_t_OperationStatus_ConvertedResources
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffj_key_OperationStatus_Message, kn) {
					currentKey = ffj_t_OperationStatus_Message
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffj_key_OperationStatus_State, kn) {
					currentKey = ffj_t_OperationStatus_State
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.AsciiEqualFold(ffj_key_OperationStatus_OperationID, kn) {
					currentKey = ffj_t_OperationStatus_OperationID
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				currentKey = ffj_t_OperationStatusno_such_key
				state = fflib.FFParse_want_colon
				goto mainparse
			}

		case fflib.FFParse_want_colon:
			if tok != fflib.FFTok_colon {
				wantedTok = fflib.FFTok_colon
				goto wrongtokenerror
			}
			state = fflib.FFParse_want_value
			continue
		case fflib.FFParse_want_value:

			if tok == fflib.FFTok_left_brace || tok == fflib.FFTok_left_bracket || tok == fflib.FFTok_integer || tok == fflib.FFTok_double || tok == fflib.FFTok_string || tok == fflib.FFTok_bool || tok == fflib.FFTok_null {
				switch currentKey {

				case ffj_t_OperationStatus_OperationID:
					goto handle_OperationID

				case ffj_t_OperationStatus_State:
					goto handle_State

				case ffj_t_OperationStatus_Message:
					goto handle_Message

				case ffj_t_OperationStatus_ConvertedResources:
					goto handle_ConvertedResources

				case ffj_t_OperationStatus_UUID:
					goto handle_UUID

				case ffj_t_OperationStatus_AgentID:
					goto handle_AgentID

				case ffj_t_OperationStatus_ResourceProviderID:
					goto handle_ResourceProviderID

				case ffj_t_OperationStatusno_such_key:
					err = fs.SkipField(tok)
					if err != nil {
						return fs.WrapErr(err)
					}
					state = fflib.FFParse_after_value
					goto mainparse
				}
			} else {
				goto wantedvalue
			}
		}
	}

handle_OperationID:

	/* handler: uj.OperationID type=mesos.OperationID kind=struct quoted=false*/

	{
		if tok == fflib.FFTok_null {

			uj.OperationID = nil

			state = fflib.FFParse_after_value
			goto mainparse
		}

		if uj.OperationID == nil {
			uj.OperationID = new(OperationID)
		}

		err = uj.OperationID.UnmarshalJSONFFLexer(fs, fflib.FFParse_want_key)
		if err != nil {
			return err
		}
		state = fflib.FFParse_after_value
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_State:

	/* handler: uj.State type=mesos.OperationState kind=int32 quoted=false*/

	{
		if tok == fflib.FFTok_null {

			state = fflib.FFParse_after_value
			goto mainparse
		}

		tbuf, err := fs.CaptureField(tok)
		if err != nil {
			return fs.WrapErr(err)
		}

		err = uj.State.UnmarshalJSON(tbuf)
		if err != nil {
			return fs.WrapErr(err)
		}
		state = fflib.FFParse_after_value
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_Message:

	/* handler: uj.Message type=string kind=string quoted=false*/

	{

		{
			if tok != fflib.FFTok_string && tok != fflib.FFTok_null {
				return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for string", tok))
			}
		}

		if tok == fflib.FFTok_null {

			uj.Message = nil

		} else {

			var tval string
			outBuf := fs.Output.Bytes()

			tval = string(string(outBuf))
			uj.Message = &tval

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_ConvertedResources:

	/* handler: uj.ConvertedResources type=[]mesos.Resource kind=slice quoted=false*/

	{

		{
			if tok != fflib.FFTok_left_brace && tok != fflib.FFTok_null {
				return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for ", tok))
			}
		}

		if tok == fflib.FFTok_null {
			uj.ConvertedResources = nil
		} else {

			uj.ConvertedResources = []Resource{}

			wantVal := true

			for {

				var tmp_uj__ConvertedResources Resource

				tok = fs.Scan()
				if tok == fflib.FFTok_error {
					goto tokerror
				}
				if tok == fflib.FFTok_right_brace {
					break
				}

				if tok == fflib.FFTok_comma {
					if wantVal == true {
						// TODO(pquerna): this isn't an ideal error message, this handles
						// things like [,,,] as an array value.
						return fs.WrapErr(fmt.Errorf("wanted value token, but got token: %v", tok))
					}
					continue
				} else {
					wantVal = true
				}

				/* handler: tmp_uj__ConvertedResources type=mesos.Resource kind=struct quoted=false*/

				{
					if tok == fflib.FFTok_null {

						state = fflib.FFParse_after_value
						goto mainparse
					}

					err = tmp_uj__ConvertedResources.UnmarshalJSONFFLexer(fs, fflib.FFParse_want_key)
					if err != nil {
						return err
					}
					state = fflib.FFParse_after_value
				}

				uj.ConvertedResources = append(uj.ConvertedResources, tmp_uj__ConvertedResources)

				wantVal = false
			}
		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_UUID:

	/* handler: uj.UUID type=mesos.UUID kind=struct quoted=false*/

	{
		if tok == fflib.FFTok_null {

			uj.UUID = nil

			state = fflib.FFParse_after_value
			goto mainparse
		}

		if uj.UUID == nil {
			uj.UUID = new(UUID)
		}

		err = uj.UUID.UnmarshalJSONFFLexer(fs, fflib.FFParse_want_key)
		if err != nil {
			return err
		}
		state = fflib.FFParse_after_value
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_AgentID:

	/* handler: uj.AgentID type=mesos.AgentID kind=struct quoted=false*/

	{
		if tok == fflib.FFTok_null {

			uj.AgentID = nil

			state = fflib.FFParse_after_value
			goto mainparse
		}

		if uj.AgentID == nil {
			uj.AgentID = new(AgentID)
		}

		err = uj.AgentID.UnmarshalJSONFFLexer(fs, fflib.FFParse_want_key)
		if err != nil {
			return err
		}
		state = fflib.FFParse_after_value
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_ResourceProviderID:

	/* handler: uj.ResourceProviderID type=mesos.ResourceProviderID kind=struct quoted=false*/

	{
		if tok == fflib.FFTok_null {

			uj.ResourceProviderID = nil

			state = fflib.FFParse_after_value
			goto mainparse
		}

		if uj.ResourceProviderID == nil {
			uj.ResourceProviderID = new(ResourceProviderID)
		}

		err = uj.ResourceProviderID.UnmarshalJSONFFLexer(fs, fflib.FFParse_want_key)
		if err != nil {
			return err
		}
		state = fflib.FFParse_after_value
	}

	state = fflib.FFParse_after_value
	goto mainparse

wantedvalue:
	return fs.WrapErr(fmt.Errorf("wanted value token, but got token: %v", tok))
wrongtokenerror:
	return fs.WrapErr(fmt.Errorf("ffjson: wanted token: %v, but got token: %v output=%s", wantedTok, tok, fs.Output.String()))
tokerror:
	if fs.BigError != nil {
		return fs.WrapErr(fs.BigError)
	}
	err = fs.Error.ToError()
	if err != nil {
		return fs.WrapErr(err)
	}
	panic("ffjson-generated: unreachable, please report bug.")
done:

	return nil
}

func (mj *Parameter) MarshalJSON() ([]byte, error) {
	var buf fflib.Buffer
	if mj == nil {
		buf.WriteString("null")
		return buf.Bytes(), nil
	}
	err := mj.MarshalJSONBuf(&buf)
	if err != nil {
		return nil, err
	}
	return buf.Bytes(), nil
}
func (mj *Parameter) MarshalJSONBuf(buf fflib.EncodingBuffer) error {
	if mj == nil {
		buf.WriteString("null")
		return nil
	}
	var err error
	var obj []byte
	_ = obj
	_ = err
	buf.WriteString(`{"key":`)
	fflib.WriteJsonString(buf, string(mj.Key))
	buf.WriteString(`,"value":`)
	fflib.WriteJsonString(buf, string(mj.Value))
	buf.WriteByte('}')
	return nil
}

const (
	ffj_t_Parameterbase = iota
	ffj_t_Parameterno_such_key

	ffj_t_Parameter_Key

	ffj_t_Parameter_Value
)

var ffj_key_Parameter_Key = []byte("key")

var ffj_key_Parameter_Value = []byte("value")

func (uj *Parameter) UnmarshalJSON(input []byte) error {
	fs := fflib.NewFFLexer(input)
	return uj.UnmarshalJSONFFLexer(fs, fflib.FFParse_map_start)
}

func (uj *Parameter) UnmarshalJSONFFLexer(fs *fflib.FFLexer, state fflib.FFParseState) error {
	var err error = nil
	currentKey := ffj_t_Parameterbase
	_ = currentKey
	tok := fflib.FFTok_init
	wantedTok := fflib.FFTok_init

mainparse:
	for {
		tok = fs.Scan()
		//	println(fmt.Sprintf("debug: tok: %v  state: %v", tok, state))
		if tok == fflib.FFTok_error {
			goto tokerror
		}

		switch state {

		case fflib.FFParse_map_start:
			if tok != fflib.FFTok_left_bracket {
				wantedTok = fflib.FFTok_left_bracket
				goto wrongtokenerror
			}
			state = fflib.FFParse_want_key
			continue

		case fflib.FFParse_after_value:
			if tok == fflib.FFTok_comma {
				state = fflib.FFParse_want_key
			} else if tok == fflib.FFTok_right_bracket {
				goto done
			} else {
				wantedTok = fflib.FFTok_comma
				goto wrongtokenerror
			}

		case fflib.FFParse_want_key:
			// json {} ended. goto exit. woo.
			if tok == fflib.FFTok_right_bracket {
				goto done
			}
			if tok != fflib.FFTok_string {
				wantedTok = fflib.FFTok_string
				goto wrongtokenerror
			}

			kn := fs.Output.Bytes()
			if len(kn) <= 0 {
				// "" case. hrm.
				currentKey = ffj_t_Parameterno_such_key
				state = fflib.FFParse_want_colon
				goto mainparse
			} else {
				switch kn[0] {

				case 'k':

					if bytes.Equal(ffj_key_Parameter_Key, kn) {
						currentKey = ffj_t_Parameter_Key
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				case 'v':

					if bytes.Equal(ffj_key_Parameter_Value, kn) {
						currentKey = ffj_t_Parameter_Value
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				}

				if fflib.SimpleLetterEqualFold(ffj_key_Parameter_Value, kn) {
					currentKey = ffj_t_Parameter_Value
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffj_key_Parameter_Key, kn) {
					currentKey = ffj_t_Parameter_Key
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				currentKey = ffj_t_Parameterno_such_key
				state = fflib.FFParse_want_colon
				goto mainparse
			}

		case fflib.FFParse_want_colon:
			if tok != fflib.FFTok_colon {
				wantedTok = fflib.FFTok_colon
				goto wrongtokenerror
			}
			state = fflib.FFParse_want_value
			continue
		case fflib.FFParse_want_value:

			if tok == fflib.FFTok_left_brace || tok == fflib.FFTok_left_bracket || tok == fflib.FFTok_integer || tok == fflib.FFTok_double || tok == fflib.FFTok_string || tok == fflib.FFTok_bool || tok == fflib.FFTok_null {
				switch currentKey {

				case ffj_t_Parameter_Key:
					goto handle_Key

				case ffj_t_Parameter_Value:
					goto handle_Value

				case ffj_t_Parameterno_such_key:
					err = fs.SkipField(tok)
					if err != nil {
						return fs.WrapErr(err)
					}
					state = fflib.FFParse_after_value
					goto mainparse
				}
			} else {
				goto wantedvalue
			}
		}
	}

handle_Key:

	/* handler: uj.Key type=string kind=string quoted=false*/

	{

		{
			if tok != fflib.FFTok_string && tok != fflib.FFTok_null {
				return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for string", tok))
			}
		}

		if tok == fflib.FFTok_null {

		} else {

			outBuf := fs.Output.Bytes()

			uj.Key = string(string(outBuf))

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_Value:

	/* handler: uj.Value type=string kind=string quoted=false*/

	{

		{
			if tok != fflib.FFTok_string && tok != fflib.FFTok_null {
				return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for string", tok))
			}
		}

		if tok == fflib.FFTok_null {

		} else {

			outBuf := fs.Output.Bytes()

			uj.Value = string(string(outBuf))

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

wantedvalue:
	return fs.WrapErr(fmt.Errorf("wanted value token, but got token: %v", tok))
wrongtokenerror:
	return fs.WrapErr(fmt.Errorf("ffjson: wanted token: %v, but got token: %v output=%s", wantedTok, tok, fs.Output.String()))
tokerror:
	if fs.BigError != nil {
		return fs.WrapErr(fs.BigError)
	}
	err = fs.Error.ToError()
	if err != nil {
		return fs.WrapErr(err)
	}
	panic("ffjson-generated: unreachable, please report bug.")
done:

	return nil
}

func (mj *Parameters) MarshalJSON() ([]byte, error) {
	var buf fflib.Buffer
	if mj == nil {
		buf.WriteString("null")
		return buf.Bytes(), nil
	}
	err := mj.MarshalJSONBuf(&buf)
	if err != nil {
		return nil, err
	}
	return buf.Bytes(), nil
}
func (mj *Parameters) MarshalJSONBuf(buf fflib.EncodingBuffer) error {
	if mj == nil {
		buf.WriteString("null")
		return nil
	}
	var err error
	var obj []byte
	_ = obj
	_ = err
	buf.WriteString(`{"parameter":`)
	if mj.Parameter != nil {
		buf.WriteString(`[`)
		for i, v := range mj.Parameter {
			if i != 0 {
				buf.WriteString(`,`)
			}

			{

				err = v.MarshalJSONBuf(buf)
				if err != nil {
					return err
				}

			}
		}
		buf.WriteString(`]`)
	} else {
		buf.WriteString(`null`)
	}
	buf.WriteByte('}')
	return nil
}

const (
	ffj_t_Parametersbase = iota
	ffj_t_Parametersno_such_key

	ffj_t_Parameters_Parameter
)

var ffj_key_Parameters_Parameter = []byte("parameter")

func (uj *Parameters) UnmarshalJSON(input []byte) error {
	fs := fflib.NewFFLexer(input)
	return uj.UnmarshalJSONFFLexer(fs, fflib.FFParse_map_start)
}

func (uj *Parameters) UnmarshalJSONFFLexer(fs *fflib.FFLexer, state fflib.FFParseState) error {
	var err error = nil
	currentKey := ffj_t_Parametersbase
	_ = currentKey
	tok := fflib.FFTok_init
	wantedTok := fflib.FFTok_init

mainparse:
	for {
		tok = fs.Scan()
		//	println(fmt.Sprintf("debug: tok: %v  state: %v", tok, state))
		if tok == fflib.FFTok_error {
			goto tokerror
		}

		switch state {

		case fflib.FFParse_map_start:
			if tok != fflib.FFTok_left_bracket {
				wantedTok = fflib.FFTok_left_bracket
				goto wrongtokenerror
			}
			state = fflib.FFParse_want_key
			continue

		case fflib.FFParse_after_value:
			if tok == fflib.FFTok_comma {
				state = fflib.FFParse_want_key
			} else if tok == fflib.FFTok_right_bracket {
				goto done
			} else {
				wantedTok = fflib.FFTok_comma
				goto wrongtokenerror
			}

		case fflib.FFParse_want_key:
			// json {} ended. goto exit. woo.
			if tok == fflib.FFTok_right_bracket {
				goto done
			}
			if tok != fflib.FFTok_string {
				wantedTok = fflib.FFTok_string
				goto wrongtokenerror
			}

			kn := fs.Output.Bytes()
			if len(kn) <= 0 {
				// "" case. hrm.
				currentKey = ffj_t_Parametersno_such_key
				state = fflib.FFParse_want_colon
				goto mainparse
			} else {
				switch kn[0] {

				case 'p':

					if bytes.Equal(ffj_key_Parameters_Parameter, kn) {
						currentKey = ffj_t_Parameters_Parameter
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				}

				if fflib.SimpleLetterEqualFold(ffj_key_Parameters_Parameter, kn) {
					currentKey = ffj_t_Parameters_Parameter
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				currentKey = ffj_t_Parametersno_such_key
				state = fflib.FFParse_want_colon
				goto mainparse
			}

		case fflib.FFParse_want_colon:
			if tok != fflib.FFTok_colon {
				wantedTok = fflib.FFTok_colon
				goto wrongtokenerror
			}
			state = fflib.FFParse_want_value
			continue
		case fflib.FFParse_want_value:

			if tok == fflib.FFTok_left_brace || tok == fflib.FFTok_left_bracket || tok == fflib.FFTok_integer || tok == fflib.FFTok_double || tok == fflib.FFTok_string || tok == fflib.FFTok_bool || tok == fflib.FFTok_null {
				switch currentKey {

				case ffj_t_Parameters_Parameter:
					goto handle_Parameter

				case ffj_t_Parametersno_such_key:
					err = fs.SkipField(tok)
					if err != nil {
						return fs.WrapErr(err)
					}
					state = fflib.FFParse_after_value
					goto mainparse
				}
			} else {
				goto wantedvalue
			}
		}
	}

handle_Parameter:

	/* handler: uj.Parameter type=[]mesos.Parameter kind=slice quoted=false*/

	{

		{
			if tok != fflib.FFTok_left_brace && tok != fflib.FFTok_null {
				return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for ", tok))
			}
		}

		if tok == fflib.FFTok_null {
			uj.Parameter = nil
		} else {

			uj.Parameter = []Parameter{}

			wantVal := true

			for {

				var tmp_uj__Parameter Parameter

				tok = fs.Scan()
				if tok == fflib.FFTok_error {
					goto tokerror
				}
				if tok == fflib.FFTok_right_brace {
					break
				}

				if tok == fflib.FFTok_comma {
					if wantVal == true {
						// TODO(pquerna): this isn't an ideal error message, this handles
						// things like [,,,] as an array value.
						return fs.WrapErr(fmt.Errorf("wanted value token, but got token: %v", tok))
					}
					continue
				} else {
					wantVal = true
				}

				/* handler: tmp_uj__Parameter type=mesos.Parameter kind=struct quoted=false*/

				{
					if tok == fflib.FFTok_null {

						state = fflib.FFParse_after_value
						goto mainparse
					}

					err = tmp_uj__Parameter.UnmarshalJSONFFLexer(fs, fflib.FFParse_want_key)
					if err != nil {
						return err
					}
					state = fflib.FFParse_after_value
				}

				uj.Parameter = append(uj.Parameter, tmp_uj__Parameter)

				wantVal = false
			}
		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

wantedvalue:
	return fs.WrapErr(fmt.Errorf("wanted value token, but got token: %v", tok))
wrongtokenerror:
	return fs.WrapErr(fmt.Errorf("ffjson: wanted token: %v, but got token: %v output=%s", wantedTok, tok, fs.Output.String()))
tokerror:
	if fs.BigError != nil {
		return fs.WrapErr(fs.BigError)
	}
	err = fs.Error.ToError()
	if err != nil {
		return fs.WrapErr(err)
	}
	panic("ffjson-generated: unreachable, please report bug.")
done:

	return nil
}

func (mj *PerfStatistics) MarshalJSON() ([]byte, error) {
	var buf fflib.Buffer
	if mj == nil {
		buf.WriteString("null")
		return buf.Bytes(), nil
	}
	err := mj.MarshalJSONBuf(&buf)
	if err != nil {
		return nil, err
	}
	return buf.Bytes(), nil
}
func (mj *PerfStatistics) MarshalJSONBuf(buf fflib.EncodingBuffer) error {
	if mj == nil {
		buf.WriteString("null")
		return nil
	}
	var err error
	var obj []byte
	_ = obj
	_ = err
	buf.WriteString(`{ "timestamp":`)
	fflib.AppendFloat(buf, float64(mj.Timestamp), 'g', -1, 64)
	buf.WriteString(`,"duration":`)
	fflib.AppendFloat(buf, float64(mj.Duration), 'g', -1, 64)
	buf.WriteByte(',')
	if mj.Cycles != nil {
		if true {
			buf.WriteString(`"cycles":`)
			fflib.FormatBits2(buf, uint64(*mj.Cycles), 10, false)
			buf.WriteByte(',')
		}
	}
	if mj.StalledCyclesFrontend != nil {
		if true {
			buf.WriteString(`"stalled_cycles_frontend":`)
			fflib.FormatBits2(buf, uint64(*mj.StalledCyclesFrontend), 10, false)
			buf.WriteByte(',')
		}
	}
	if mj.StalledCyclesBackend != nil {
		if true {
			buf.WriteString(`"stalled_cycles_backend":`)
			fflib.FormatBits2(buf, uint64(*mj.StalledCyclesBackend), 10, false)
			buf.WriteByte(',')
		}
	}
	if mj.Instructions != nil {
		if true {
			buf.WriteString(`"instructions":`)
			fflib.FormatBits2(buf, uint64(*mj.Instructions), 10, false)
			buf.WriteByte(',')
		}
	}
	if mj.CacheReferences != nil {
		if true {
			buf.WriteString(`"cache_references":`)
			fflib.FormatBits2(buf, uint64(*mj.CacheReferences), 10, false)
			buf.WriteByte(',')
		}
	}
	if mj.CacheMisses != nil {
		if true {
			buf.WriteString(`"cache_misses":`)
			fflib.FormatBits2(buf, uint64(*mj.CacheMisses), 10, false)
			buf.WriteByte(',')
		}
	}
	if mj.Branches != nil {
		if true {
			buf.WriteString(`"branches":`)
			fflib.FormatBits2(buf, uint64(*mj.Branches), 10, false)
			buf.WriteByte(',')
		}
	}
	if mj.BranchMisses != nil {
		if true {
			buf.WriteString(`"branch_misses":`)
			fflib.FormatBits2(buf, uint64(*mj.BranchMisses), 10, false)
			buf.WriteByte(',')
		}
	}
	if mj.BusCycles != nil {
		if true {
			buf.WriteString(`"bus_cycles":`)
			fflib.FormatBits2(buf, uint64(*mj.BusCycles), 10, false)
			buf.WriteByte(',')
		}
	}
	if mj.RefCycles != nil {
		if true {
			buf.WriteString(`"ref_cycles":`)
			fflib.FormatBits2(buf, uint64(*mj.RefCycles), 10, false)
			buf.WriteByte(',')
		}
	}
	if mj.CPUClock != nil {
		if true {
			buf.WriteString(`"cpu_clock":`)
			fflib.AppendFloat(buf, float64(*mj.CPUClock), 'g', -1, 64)
			buf.WriteByte(',')
		}
	}
	if mj.TaskClock != nil {
		if true {
			buf.WriteString(`"task_clock":`)
			fflib.AppendFloat(buf, float64(*mj.TaskClock), 'g', -1, 64)
			buf.WriteByte(',')
		}
	}
	if mj.PageFaults != nil {
		if true {
			buf.WriteString(`"page_faults":`)
			fflib.FormatBits2(buf, uint64(*mj.PageFaults), 10, false)
			buf.WriteByte(',')
		}
	}
	if mj.MinorFaults != nil {
		if true {
			buf.WriteString(`"minor_faults":`)
			fflib.FormatBits2(buf, uint64(*mj.MinorFaults), 10, false)
			buf.WriteByte(',')
		}
	}
	if mj.MajorFaults != nil {
		if true {
			buf.WriteString(`"major_faults":`)
			fflib.FormatBits2(buf, uint64(*mj.MajorFaults), 10, false)
			buf.WriteByte(',')
		}
	}
	if mj.ContextSwitches != nil {
		if true {
			buf.WriteString(`"context_switches":`)
			fflib.FormatBits2(buf, uint64(*mj.ContextSwitches), 10, false)
			buf.WriteByte(',')
		}
	}
	if mj.CPUMigrations != nil {
		if true {
			buf.WriteString(`"cpu_migrations":`)
			fflib.FormatBits2(buf, uint64(*mj.CPUMigrations), 10, false)
			buf.WriteByte(',')
		}
	}
	if mj.AlignmentFaults != nil {
		if true {
			buf.WriteString(`"alignment_faults":`)
			fflib.FormatBits2(buf, uint64(*mj.AlignmentFaults), 10, false)
			buf.WriteByte(',')
		}
	}
	if mj.EmulationFaults != nil {
		if true {
			buf.WriteString(`"emulation_faults":`)
			fflib.FormatBits2(buf, uint64(*mj.EmulationFaults), 10, false)
			buf.WriteByte(',')
		}
	}
	if mj.L1DcacheLoads != nil {
		if true {
			buf.WriteString(`"l1_dcache_loads":`)
			fflib.FormatBits2(buf, uint64(*mj.L1DcacheLoads), 10, false)
			buf.WriteByte(',')
		}
	}
	if mj.L1DcacheLoadMisses != nil {
		if true {
			buf.WriteString(`"l1_dcache_load_misses":`)
			fflib.FormatBits2(buf, uint64(*mj.L1DcacheLoadMisses), 10, false)
			buf.WriteByte(',')
		}
	}
	if mj.L1DcacheStores != nil {
		if true {
			buf.WriteString(`"l1_dcache_stores":`)
			fflib.FormatBits2(buf, uint64(*mj.L1DcacheStores), 10, false)
			buf.WriteByte(',')
		}
	}
	if mj.L1DcacheStoreMisses != nil {
		if true {
			buf.WriteString(`"l1_dcache_store_misses":`)
			fflib.FormatBits2(buf, uint64(*mj.L1DcacheStoreMisses), 10, false)
			buf.WriteByte(',')
		}
	}
	if mj.L1DcachePrefetches != nil {
		if true {
			buf.WriteString(`"l1_dcache_prefetches":`)
			fflib.FormatBits2(buf, uint64(*mj.L1DcachePrefetches), 10, false)
			buf.WriteByte(',')
		}
	}
	if mj.L1DcachePrefetchMisses != nil {
		if true {
			buf.WriteString(`"l1_dcache_prefetch_misses":`)
			fflib.FormatBits2(buf, uint64(*mj.L1DcachePrefetchMisses), 10, false)
			buf.WriteByte(',')
		}
	}
	if mj.L1IcacheLoads != nil {
		if true {
			buf.WriteString(`"l1_icache_loads":`)
			fflib.FormatBits2(buf, uint64(*mj.L1IcacheLoads), 10, false)
			buf.WriteByte(',')
		}
	}
	if mj.L1IcacheLoadMisses != nil {
		if true {
			buf.WriteString(`"l1_icache_load_misses":`)
			fflib.FormatBits2(buf, uint64(*mj.L1IcacheLoadMisses), 10, false)
			buf.WriteByte(',')
		}
	}
	if mj.L1IcachePrefetches != nil {
		if true {
			buf.WriteString(`"l1_icache_prefetches":`)
			fflib.FormatBits2(buf, uint64(*mj.L1IcachePrefetches), 10, false)
			buf.WriteByte(',')
		}
	}
	if mj.L1IcachePrefetchMisses != nil {
		if true {
			buf.WriteString(`"l1_icache_prefetch_misses":`)
			fflib.FormatBits2(buf, uint64(*mj.L1IcachePrefetchMisses), 10, false)
			buf.WriteByte(',')
		}
	}
	if mj.LLCLoads != nil {
		if true {
			buf.WriteString(`"llc_loads":`)
			fflib.FormatBits2(buf, uint64(*mj.LLCLoads), 10, false)
			buf.WriteByte(',')
		}
	}
	if mj.LLCLoadMisses != nil {
		if true {
			buf.WriteString(`"llc_load_misses":`)
			fflib.FormatBits2(buf, uint64(*mj.LLCLoadMisses), 10, false)
			buf.WriteByte(',')
		}
	}
	if mj.LLCStores != nil {
		if true {
			buf.WriteString(`"llc_stores":`)
			fflib.FormatBits2(buf, uint64(*mj.LLCStores), 10, false)
			buf.WriteByte(',')
		}
	}
	if mj.LLCStoreMisses != nil {
		if true {
			buf.WriteString(`"llc_store_misses":`)
			fflib.FormatBits2(buf, uint64(*mj.LLCStoreMisses), 10, false)
			buf.WriteByte(',')
		}
	}
	if mj.LLCPrefetches != nil {
		if true {
			buf.WriteString(`"llc_prefetches":`)
			fflib.FormatBits2(buf, uint64(*mj.LLCPrefetches), 10, false)
			buf.WriteByte(',')
		}
	}
	if mj.LLCPrefetchMisses != nil {
		if true {
			buf.WriteString(`"llc_prefetch_misses":`)
			fflib.FormatBits2(buf, uint64(*mj.LLCPrefetchMisses), 10, false)
			buf.WriteByte(',')
		}
	}
	if mj.DTLBLoads != nil {
		if true {
			buf.WriteString(`"dtlb_loads":`)
			fflib.FormatBits2(buf, uint64(*mj.DTLBLoads), 10, false)
			buf.WriteByte(',')
		}
	}
	if mj.DTLBLoadMisses != nil {
		if true {
			buf.WriteString(`"dtlb_load_misses":`)
			fflib.FormatBits2(buf, uint64(*mj.DTLBLoadMisses), 10, false)
			buf.WriteByte(',')
		}
	}
	if mj.DTLBStores != nil {
		if true {
			buf.WriteString(`"dtlb_stores":`)
			fflib.FormatBits2(buf, uint64(*mj.DTLBStores), 10, false)
			buf.WriteByte(',')
		}
	}
	if mj.DTLBStoreMisses != nil {
		if true {
			buf.WriteString(`"dtlb_store_misses":`)
			fflib.FormatBits2(buf, uint64(*mj.DTLBStoreMisses), 10, false)
			buf.WriteByte(',')
		}
	}
	if mj.DTLBPrefetches != nil {
		if true {
			buf.WriteString(`"dtlb_prefetches":`)
			fflib.FormatBits2(buf, uint64(*mj.DTLBPrefetches), 10, false)
			buf.WriteByte(',')
		}
	}
	if mj.DTLBPrefetchMisses != nil {
		if true {
			buf.WriteString(`"dtlb_prefetch_misses":`)
			fflib.FormatBits2(buf, uint64(*mj.DTLBPrefetchMisses), 10, false)
			buf.WriteByte(',')
		}
	}
	if mj.ITLBLoads != nil {
		if true {
			buf.WriteString(`"itlb_loads":`)
			fflib.FormatBits2(buf, uint64(*mj.ITLBLoads), 10, false)
			buf.WriteByte(',')
		}
	}
	if mj.ITLBLoadMisses != nil {
		if true {
			buf.WriteString(`"itlb_load_misses":`)
			fflib.FormatBits2(buf, uint64(*mj.ITLBLoadMisses), 10, false)
			buf.WriteByte(',')
		}
	}
	if mj.BranchLoads != nil {
		if true {
			buf.WriteString(`"branch_loads":`)
			fflib.FormatBits2(buf, uint64(*mj.BranchLoads), 10, false)
			buf.WriteByte(',')
		}
	}
	if mj.BranchLoadMisses != nil {
		if true {
			buf.WriteString(`"branch_load_misses":`)
			fflib.FormatBits2(buf, uint64(*mj.BranchLoadMisses), 10, false)
			buf.WriteByte(',')
		}
	}
	if mj.NodeLoads != nil {
		if true {
			buf.WriteString(`"node_loads":`)
			fflib.FormatBits2(buf, uint64(*mj.NodeLoads), 10, false)
			buf.WriteByte(',')
		}
	}
	if mj.NodeLoadMisses != nil {
		if true {
			buf.WriteString(`"node_load_misses":`)
			fflib.FormatBits2(buf, uint64(*mj.NodeLoadMisses), 10, false)
			buf.WriteByte(',')
		}
	}
	if mj.NodeStores != nil {
		if true {
			buf.WriteString(`"node_stores":`)
			fflib.FormatBits2(buf, uint64(*mj.NodeStores), 10, false)
			buf.WriteByte(',')
		}
	}
	if mj.NodeStoreMisses != nil {
		if true {
			buf.WriteString(`"node_store_misses":`)
			fflib.FormatBits2(buf, uint64(*mj.NodeStoreMisses), 10, false)
			buf.WriteByte(',')
		}
	}
	if mj.NodePrefetches != nil {
		if true {
			buf.WriteString(`"node_prefetches":`)
			fflib.FormatBits2(buf, uint64(*mj.NodePrefetches), 10, false)
			buf.WriteByte(',')
		}
	}
	if mj.NodePrefetchMisses != nil {
		if true {
			buf.WriteString(`"node_prefetch_misses":`)
			fflib.FormatBits2(buf, uint64(*mj.NodePrefetchMisses), 10, false)
			buf.WriteByte(',')
		}
	}
	buf.Rewind(1)
	buf.WriteByte('}')
	return nil
}

const (
	ffj_t_PerfStatisticsbase = iota
	ffj_t_PerfStatisticsno_such_key

	ffj_t_PerfStatistics_Timestamp

	ffj_t_PerfStatistics_Duration

	ffj_t_PerfStatistics_Cycles

	ffj_t_PerfStatistics_StalledCyclesFrontend

	ffj_t_PerfStatistics_StalledCyclesBackend

	ffj_t_PerfStatistics_Instructions

	ffj_t_PerfStatistics_CacheReferences

	ffj_t_PerfStatistics_CacheMisses

	ffj_t_PerfStatistics_Branches

	ffj_t_PerfStatistics_BranchMisses

	ffj_t_PerfStatistics_BusCycles

	ffj_t_PerfStatistics_RefCycles

	ffj_t_PerfStatistics_CPUClock

	ffj_t_PerfStatistics_TaskClock

	ffj_t_PerfStatistics_PageFaults

	ffj_t_PerfStatistics_MinorFaults

	ffj_t_PerfStatistics_MajorFaults

	ffj_t_PerfStatistics_ContextSwitches

	ffj_t_PerfStatistics_CPUMigrations

	ffj_t_PerfStatistics_AlignmentFaults

	ffj_t_PerfStatistics_EmulationFaults

	ffj_t_PerfStatistics_L1DcacheLoads

	ffj_t_PerfStatistics_L1DcacheLoadMisses

	ffj_t_PerfStatistics_L1DcacheStores

	ffj_t_PerfStatistics_L1DcacheStoreMisses

	ffj_t_PerfStatistics_L1DcachePrefetches

	ffj_t_PerfStatistics_L1DcachePrefetchMisses

	ffj_t_PerfStatistics_L1IcacheLoads

	ffj_t_PerfStatistics_L1IcacheLoadMisses

	ffj_t_PerfStatistics_L1IcachePrefetches

	ffj_t_PerfStatistics_L1IcachePrefetchMisses

	ffj_t_PerfStatistics_LLCLoads

	ffj_t_PerfStatistics_LLCLoadMisses

	ffj_t_PerfStatistics_LLCStores

	ffj_t_PerfStatistics_LLCStoreMisses

	ffj_t_PerfStatistics_LLCPrefetches

	ffj_t_PerfStatistics_LLCPrefetchMisses

	ffj_t_PerfStatistics_DTLBLoads

	ffj_t_PerfStatistics_DTLBLoadMisses

	ffj_t_PerfStatistics_DTLBStores

	ffj_t_PerfStatistics_DTLBStoreMisses

	ffj_t_PerfStatistics_DTLBPrefetches

	ffj_t_PerfStatistics_DTLBPrefetchMisses

	ffj_t_PerfStatistics_ITLBLoads

	ffj_t_PerfStatistics_ITLBLoadMisses

	ffj_t_PerfStatistics_BranchLoads

	ffj_t_PerfStatistics_BranchLoadMisses

	ffj_t_PerfStatistics_NodeLoads

	ffj_t_PerfStatistics_NodeLoadMisses

	ffj_t_PerfStatistics_NodeStores

	ffj_t_PerfStatistics_NodeStoreMisses

	ffj_t_PerfStatistics_NodePrefetches

	ffj_t_PerfStatistics_NodePrefetchMisses
)

var ffj_key_PerfStatistics_Timestamp = []byte("timestamp")

var ffj_key_PerfStatistics_Duration = []byte("duration")

var ffj_key_PerfStatistics_Cycles = []byte("cycles")

var ffj_key_PerfStatistics_StalledCyclesFrontend = []byte("stalled_cycles_frontend")

var ffj_key_PerfStatistics_StalledCyclesBackend = []byte("stalled_cycles_backend")

var ffj_key_PerfStatistics_Instructions = []byte("instructions")

var ffj_key_PerfStatistics_CacheReferences = []byte("cache_references")

var ffj_key_PerfStatistics_CacheMisses = []byte("cache_misses")

var ffj_key_PerfStatistics_Branches = []byte("branches")

var ffj_key_PerfStatistics_BranchMisses = []byte("branch_misses")

var ffj_key_PerfStatistics_BusCycles = []byte("bus_cycles")

var ffj_key_PerfStatistics_RefCycles = []byte("ref_cycles")

var ffj_key_PerfStatistics_CPUClock = []byte("cpu_clock")

var ffj_key_PerfStatistics_TaskClock = []byte("task_clock")

var ffj_key_PerfStatistics_PageFaults = []byte("page_faults")

var ffj_key_PerfStatistics_MinorFaults = []byte("minor_faults")

var ffj_key_PerfStatistics_MajorFaults = []byte("major_faults")

var ffj_key_PerfStatistics_ContextSwitches = []byte("context_switches")

var ffj_key_PerfStatistics_CPUMigrations = []byte("cpu_migrations")

var ffj_key_PerfStatistics_AlignmentFaults = []byte("alignment_faults")

var ffj_key_PerfStatistics_EmulationFaults = []byte("emulation_faults")

var ffj_key_PerfStatistics_L1DcacheLoads = []byte("l1_dcache_loads")

var ffj_key_PerfStatistics_L1DcacheLoadMisses = []byte("l1_dcache_load_misses")

var ffj_key_PerfStatistics_L1DcacheStores = []byte("l1_dcache_stores")

var ffj_key_PerfStatistics_L1DcacheStoreMisses = []byte("l1_dcache_store_misses")

var ffj_key_PerfStatistics_L1DcachePrefetches = []byte("l1_dcache_prefetches")

var ffj_key_PerfStatistics_L1DcachePrefetchMisses = []byte("l1_dcache_prefetch_misses")

var ffj_key_PerfStatistics_L1IcacheLoads = []byte("l1_icache_loads")

var ffj_key_PerfStatistics_L1IcacheLoadMisses = []byte("l1_icache_load_misses")

var ffj_key_PerfStatistics_L1IcachePrefetches = []byte("l1_icache_prefetches")

var ffj_key_PerfStatistics_L1IcachePrefetchMisses = []byte("l1_icache_prefetch_misses")

var ffj_key_PerfStatistics_LLCLoads = []byte("llc_loads")

var ffj_key_PerfStatistics_LLCLoadMisses = []byte("llc_load_misses")

var ffj_key_PerfStatistics_LLCStores = []byte("llc_stores")

var ffj_key_PerfStatistics_LLCStoreMisses = []byte("llc_store_misses")

var ffj_key_PerfStatistics_LLCPrefetches = []byte("llc_prefetches")

var ffj_key_PerfStatistics_LLCPrefetchMisses = []byte("llc_prefetch_misses")

var ffj_key_PerfStatistics_DTLBLoads = []byte("dtlb_loads")

var ffj_key_PerfStatistics_DTLBLoadMisses = []byte("dtlb_load_misses")

var ffj_key_PerfStatistics_DTLBStores = []byte("dtlb_stores")

var ffj_key_PerfStatistics_DTLBStoreMisses = []byte("dtlb_store_misses")

var ffj_key_PerfStatistics_DTLBPrefetches = []byte("dtlb_prefetches")

var ffj_key_PerfStatistics_DTLBPrefetchMisses = []byte("dtlb_prefetch_misses")

var ffj_key_PerfStatistics_ITLBLoads = []byte("itlb_loads")

var ffj_key_PerfStatistics_ITLBLoadMisses = []byte("itlb_load_misses")

var ffj_key_PerfStatistics_BranchLoads = []byte("branch_loads")

var ffj_key_PerfStatistics_BranchLoadMisses = []byte("branch_load_misses")

var ffj_key_PerfStatistics_NodeLoads = []byte("node_loads")

var ffj_key_PerfStatistics_NodeLoadMisses = []byte("node_load_misses")

var ffj_key_PerfStatistics_NodeStores = []byte("node_stores")

var ffj_key_PerfStatistics_NodeStoreMisses = []byte("node_store_misses")

var ffj_key_PerfStatistics_NodePrefetches = []byte("node_prefetches")

var ffj_key_PerfStatistics_NodePrefetchMisses = []byte("node_prefetch_misses")

func (uj *PerfStatistics) UnmarshalJSON(input []byte) error {
	fs := fflib.NewFFLexer(input)
	return uj.UnmarshalJSONFFLexer(fs, fflib.FFParse_map_start)
}

func (uj *PerfStatistics) UnmarshalJSONFFLexer(fs *fflib.FFLexer, state fflib.FFParseState) error {
	var err error = nil
	currentKey := ffj_t_PerfStatisticsbase
	_ = currentKey
	tok := fflib.FFTok_init
	wantedTok := fflib.FFTok_init

mainparse:
	for {
		tok = fs.Scan()
		//	println(fmt.Sprintf("debug: tok: %v  state: %v", tok, state))
		if tok == fflib.FFTok_error {
			goto tokerror
		}

		switch state {

		case fflib.FFParse_map_start:
			if tok != fflib.FFTok_left_bracket {
				wantedTok = fflib.FFTok_left_bracket
				goto wrongtokenerror
			}
			state = fflib.FFParse_want_key
			continue

		case fflib.FFParse_after_value:
			if tok == fflib.FFTok_comma {
				state = fflib.FFParse_want_key
			} else if tok == fflib.FFTok_right_bracket {
				goto done
			} else {
				wantedTok = fflib.FFTok_comma
				goto wrongtokenerror
			}

		case fflib.FFParse_want_key:
			// json {} ended. goto exit. woo.
			if tok == fflib.FFTok_right_bracket {
				goto done
			}
			if tok != fflib.FFTok_string {
				wantedTok = fflib.FFTok_string
				goto wrongtokenerror
			}

			kn := fs.Output.Bytes()
			if len(kn) <= 0 {
				// "" case. hrm.
				currentKey = ffj_t_PerfStatisticsno_such_key
				state = fflib.FFParse_want_colon
				goto mainparse
			} else {
				switch kn[0] {

				case 'a':

					if bytes.Equal(ffj_key_PerfStatistics_AlignmentFaults, kn) {
						currentKey = ffj_t_PerfStatistics_AlignmentFaults
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				case 'b':

					if bytes.Equal(ffj_key_PerfStatistics_Branches, kn) {
						currentKey = ffj_t_PerfStatistics_Branches
						state = fflib.FFParse_want_colon
						goto mainparse

					} else if bytes.Equal(ffj_key_PerfStatistics_BranchMisses, kn) {
						currentKey = ffj_t_PerfStatistics_BranchMisses
						state = fflib.FFParse_want_colon
						goto mainparse

					} else if bytes.Equal(ffj_key_PerfStatistics_BusCycles, kn) {
						currentKey = ffj_t_PerfStatistics_BusCycles
						state = fflib.FFParse_want_colon
						goto mainparse

					} else if bytes.Equal(ffj_key_PerfStatistics_BranchLoads, kn) {
						currentKey = ffj_t_PerfStatistics_BranchLoads
						state = fflib.FFParse_want_colon
						goto mainparse

					} else if bytes.Equal(ffj_key_PerfStatistics_BranchLoadMisses, kn) {
						currentKey = ffj_t_PerfStatistics_BranchLoadMisses
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				case 'c':

					if bytes.Equal(ffj_key_PerfStatistics_Cycles, kn) {
						currentKey = ffj_t_PerfStatistics_Cycles
						state = fflib.FFParse_want_colon
						goto mainparse

					} else if bytes.Equal(ffj_key_PerfStatistics_CacheReferences, kn) {
						currentKey = ffj_t_PerfStatistics_CacheReferences
						state = fflib.FFParse_want_colon
						goto mainparse

					} else if bytes.Equal(ffj_key_PerfStatistics_CacheMisses, kn) {
						currentKey = ffj_t_PerfStatistics_CacheMisses
						state = fflib.FFParse_want_colon
						goto mainparse

					} else if bytes.Equal(ffj_key_PerfStatistics_CPUClock, kn) {
						currentKey = ffj_t_PerfStatistics_CPUClock
						state = fflib.FFParse_want_colon
						goto mainparse

					} else if bytes.Equal(ffj_key_PerfStatistics_ContextSwitches, kn) {
						currentKey = ffj_t_PerfStatistics_ContextSwitches
						state = fflib.FFParse_want_colon
						goto mainparse

					} else if bytes.Equal(ffj_key_PerfStatistics_CPUMigrations, kn) {
						currentKey = ffj_t_PerfStatistics_CPUMigrations
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				case 'd':

					if bytes.Equal(ffj_key_PerfStatistics_Duration, kn) {
						currentKey = ffj_t_PerfStatistics_Duration
						state = fflib.FFParse_want_colon
						goto mainparse

					} else if bytes.Equal(ffj_key_PerfStatistics_DTLBLoads, kn) {
						currentKey = ffj_t_PerfStatistics_DTLBLoads
						state = fflib.FFParse_want_colon
						goto mainparse

					} else if bytes.Equal(ffj_key_PerfStatistics_DTLBLoadMisses, kn) {
						currentKey = ffj_t_PerfStatistics_DTLBLoadMisses
						state = fflib.FFParse_want_colon
						goto mainparse

					} else if bytes.Equal(ffj_key_PerfStatistics_DTLBStores, kn) {
						currentKey = ffj_t_PerfStatistics_DTLBStores
						state = fflib.FFParse_want_colon
						goto mainparse

					} else if bytes.Equal(ffj_key_PerfStatistics_DTLBStoreMisses, kn) {
						currentKey = ffj_t_PerfStatistics_DTLBStoreMisses
						state = fflib.FFParse_want_colon
						goto mainparse

					} else if bytes.Equal(ffj_key_PerfStatistics_DTLBPrefetches, kn) {
						currentKey = ffj_t_PerfStatistics_DTLBPrefetches
						state = fflib.FFParse_want_colon
						goto mainparse

					} else if bytes.Equal(ffj_key_PerfStatistics_DTLBPrefetchMisses, kn) {
						currentKey = ffj_t_PerfStatistics_DTLBPrefetchMisses
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				case 'e':

					if bytes.Equal(ffj_key_PerfStatistics_EmulationFaults, kn) {
						currentKey = ffj_t_PerfStatistics_EmulationFaults
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				case 'i':

					if bytes.Equal(ffj_key_PerfStatistics_Instructions, kn) {
						currentKey = ffj_t_PerfStatistics_Instructions
						state = fflib.FFParse_want_colon
						goto mainparse

					} else if bytes.Equal(ffj_key_PerfStatistics_ITLBLoads, kn) {
						currentKey = ffj_t_PerfStatistics_ITLBLoads
						state = fflib.FFParse_want_colon
						goto mainparse

					} else if bytes.Equal(ffj_key_PerfStatistics_ITLBLoadMisses, kn) {
						currentKey = ffj_t_PerfStatistics_ITLBLoadMisses
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				case 'l':

					if bytes.Equal(ffj_key_PerfStatistics_L1DcacheLoads, kn) {
						currentKey = ffj_t_PerfStatistics_L1DcacheLoads
						state = fflib.FFParse_want_colon
						goto mainparse

					} else if bytes.Equal(ffj_key_PerfStatistics_L1DcacheLoadMisses, kn) {
						currentKey = ffj_t_PerfStatistics_L1DcacheLoadMisses
						state = fflib.FFParse_want_colon
						goto mainparse

					} else if bytes.Equal(ffj_key_PerfStatistics_L1DcacheStores, kn) {
						currentKey = ffj_t_PerfStatistics_L1DcacheStores
						state = fflib.FFParse_want_colon
						goto mainparse

					} else if bytes.Equal(ffj_key_PerfStatistics_L1DcacheStoreMisses, kn) {
						currentKey = ffj_t_PerfStatistics_L1DcacheStoreMisses
						state = fflib.FFParse_want_colon
						goto mainparse

					} else if bytes.Equal(ffj_key_PerfStatistics_L1DcachePrefetches, kn) {
						currentKey = ffj_t_PerfStatistics_L1DcachePrefetches
						state = fflib.FFParse_want_colon
						goto mainparse

					} else if bytes.Equal(ffj_key_PerfStatistics_L1DcachePrefetchMisses, kn) {
						currentKey = ffj_t_PerfStatistics_L1DcachePrefetchMisses
						state = fflib.FFParse_want_colon
						goto mainparse

					} else if bytes.Equal(ffj_key_PerfStatistics_L1IcacheLoads, kn) {
						currentKey = ffj_t_PerfStatistics_L1IcacheLoads
						state = fflib.FFParse_want_colon
						goto mainparse

					} else if bytes.Equal(ffj_key_PerfStatistics_L1IcacheLoadMisses, kn) {
						currentKey = ffj_t_PerfStatistics_L1IcacheLoadMisses
						state = fflib.FFParse_want_colon
						goto mainparse

					} else if bytes.Equal(ffj_key_PerfStatistics_L1IcachePrefetches, kn) {
						currentKey = ffj_t_PerfStatistics_L1IcachePrefetches
						state = fflib.FFParse_want_colon
						goto mainparse

					} else if bytes.Equal(ffj_key_PerfStatistics_L1IcachePrefetchMisses, kn) {
						currentKey = ffj_t_PerfStatistics_L1IcachePrefetchMisses
						state = fflib.FFParse_want_colon
						goto mainparse

					} else if bytes.Equal(ffj_key_PerfStatistics_LLCLoads, kn) {
						currentKey = ffj_t_PerfStatistics_LLCLoads
						state = fflib.FFParse_want_colon
						goto mainparse

					} else if bytes.Equal(ffj_key_PerfStatistics_LLCLoadMisses, kn) {
						currentKey = ffj_t_PerfStatistics_LLCLoadMisses
						state = fflib.FFParse_want_colon
						goto mainparse

					} else if bytes.Equal(ffj_key_PerfStatistics_LLCStores, kn) {
						currentKey = ffj_t_PerfStatistics_LLCStores
						state = fflib.FFParse_want_colon
						goto mainparse

					} else if bytes.Equal(ffj_key_PerfStatistics_LLCStoreMisses, kn) {
						currentKey = ffj_t_PerfStatistics_LLCStoreMisses
						state = fflib.FFParse_want_colon
						goto mainparse

					} else if bytes.Equal(ffj_key_PerfStatistics_LLCPrefetches, kn) {
						currentKey = ffj_t_PerfStatistics_LLCPrefetches
						state = fflib.FFParse_want_colon
						goto mainparse

					} else if bytes.Equal(ffj_key_PerfStatistics_LLCPrefetchMisses, kn) {
						currentKey = ffj_t_PerfStatistics_LLCPrefetchMisses
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				case 'm':

					if bytes.Equal(ffj_key_PerfStatistics_MinorFaults, kn) {
						currentKey = ffj_t_PerfStatistics_MinorFaults
						state = fflib.FFParse_want_colon
						goto mainparse

					} else if bytes.Equal(ffj_key_PerfStatistics_MajorFaults, kn) {
						currentKey = ffj_t_PerfStatistics_MajorFaults
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				case 'n':

					if bytes.Equal(ffj_key_PerfStatistics_NodeLoads, kn) {
						currentKey = ffj_t_PerfStatistics_NodeLoads
						state = fflib.FFParse_want_colon
						goto mainparse

					} else if bytes.Equal(ffj_key_PerfStatistics_NodeLoadMisses, kn) {
						currentKey = ffj_t_PerfStatistics_NodeLoadMisses
						state = fflib.FFParse_want_colon
						goto mainparse

					} else if bytes.Equal(ffj_key_PerfStatistics_NodeStores, kn) {
						currentKey = ffj_t_PerfStatistics_NodeStores
						state = fflib.FFParse_want_colon
						goto mainparse

					} else if bytes.Equal(ffj_key_PerfStatistics_NodeStoreMisses, kn) {
						currentKey = ffj_t_PerfStatistics_NodeStoreMisses
						state = fflib.FFParse_want_colon
						goto mainparse

					} else if bytes.Equal(ffj_key_PerfStatistics_NodePrefetches, kn) {
						currentKey = ffj_t_PerfStatistics_NodePrefetches
						state = fflib.FFParse_want_colon
						goto mainparse

					} else if bytes.Equal(ffj_key_PerfStatistics_NodePrefetchMisses, kn) {
						currentKey = ffj_t_PerfStatistics_NodePrefetchMisses
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				case 'p':

					if bytes.Equal(ffj_key_PerfStatistics_PageFaults, kn) {
						currentKey = ffj_t_PerfStatistics_PageFaults
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				case 'r':

					if bytes.Equal(ffj_key_PerfStatistics_RefCycles, kn) {
						currentKey = ffj_t_PerfStatistics_RefCycles
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				case 's':

					if bytes.Equal(ffj_key_PerfStatistics_StalledCyclesFrontend, kn) {
						currentKey = ffj_t_PerfStatistics_StalledCyclesFrontend
						state = fflib.FFParse_want_colon
						goto mainparse

					} else if bytes.Equal(ffj_key_PerfStatistics_StalledCyclesBackend, kn) {
						currentKey = ffj_t_PerfStatistics_StalledCyclesBackend
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				case 't':

					if bytes.Equal(ffj_key_PerfStatistics_Timestamp, kn) {
						currentKey = ffj_t_PerfStatistics_Timestamp
						state = fflib.FFParse_want_colon
						goto mainparse

					} else if bytes.Equal(ffj_key_PerfStatistics_TaskClock, kn) {
						currentKey = ffj_t_PerfStatistics_TaskClock
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				}

				if fflib.EqualFoldRight(ffj_key_PerfStatistics_NodePrefetchMisses, kn) {
					currentKey = ffj_t_PerfStatistics_NodePrefetchMisses
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffj_key_PerfStatistics_NodePrefetches, kn) {
					currentKey = ffj_t_PerfStatistics_NodePrefetches
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffj_key_PerfStatistics_NodeStoreMisses, kn) {
					currentKey = ffj_t_PerfStatistics_NodeStoreMisses
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffj_key_PerfStatistics_NodeStores, kn) {
					currentKey = ffj_t_PerfStatistics_NodeStores
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffj_key_PerfStatistics_NodeLoadMisses, kn) {
					currentKey = ffj_t_PerfStatistics_NodeLoadMisses
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffj_key_PerfStatistics_NodeLoads, kn) {
					currentKey = ffj_t_PerfStatistics_NodeLoads
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffj_key_PerfStatistics_BranchLoadMisses, kn) {
					currentKey = ffj_t_PerfStatistics_BranchLoadMisses
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffj_key_PerfStatistics_BranchLoads, kn) {
					currentKey = ffj_t_PerfStatistics_BranchLoads
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffj_key_PerfStatistics_ITLBLoadMisses, kn) {
					currentKey = ffj_t_PerfStatistics_ITLBLoadMisses
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffj_key_PerfStatistics_ITLBLoads, kn) {
					currentKey = ffj_t_PerfStatistics_ITLBLoads
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffj_key_PerfStatistics_DTLBPrefetchMisses, kn) {
					currentKey = ffj_t_PerfStatistics_DTLBPrefetchMisses
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffj_key_PerfStatistics_DTLBPrefetches, kn) {
					currentKey = ffj_t_PerfStatistics_DTLBPrefetches
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffj_key_PerfStatistics_DTLBStoreMisses, kn) {
					currentKey = ffj_t_PerfStatistics_DTLBStoreMisses
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffj_key_PerfStatistics_DTLBStores, kn) {
					currentKey = ffj_t_PerfStatistics_DTLBStores
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffj_key_PerfStatistics_DTLBLoadMisses, kn) {
					currentKey = ffj_t_PerfStatistics_DTLBLoadMisses
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffj_key_PerfStatistics_DTLBLoads, kn) {
					currentKey = ffj_t_PerfStatistics_DTLBLoads
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffj_key_PerfStatistics_LLCPrefetchMisses, kn) {
					currentKey = ffj_t_PerfStatistics_LLCPrefetchMisses
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffj_key_PerfStatistics_LLCPrefetches, kn) {
					currentKey = ffj_t_PerfStatistics_LLCPrefetches
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffj_key_PerfStatistics_LLCStoreMisses, kn) {
					currentKey = ffj_t_PerfStatistics_LLCStoreMisses
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffj_key_PerfStatistics_LLCStores, kn) {
					currentKey = ffj_t_PerfStatistics_LLCStores
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffj_key_PerfStatistics_LLCLoadMisses, kn) {
					currentKey = ffj_t_PerfStatistics_LLCLoadMisses
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffj_key_PerfStatistics_LLCLoads, kn) {
					currentKey = ffj_t_PerfStatistics_LLCLoads
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffj_key_PerfStatistics_L1IcachePrefetchMisses, kn) {
					currentKey = ffj_t_PerfStatistics_L1IcachePrefetchMisses
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffj_key_PerfStatistics_L1IcachePrefetches, kn) {
					currentKey = ffj_t_PerfStatistics_L1IcachePrefetches
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffj_key_PerfStatistics_L1IcacheLoadMisses, kn) {
					currentKey = ffj_t_PerfStatistics_L1IcacheLoadMisses
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffj_key_PerfStatistics_L1IcacheLoads, kn) {
					currentKey = ffj_t_PerfStatistics_L1IcacheLoads
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffj_key_PerfStatistics_L1DcachePrefetchMisses, kn) {
					currentKey = ffj_t_PerfStatistics_L1DcachePrefetchMisses
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffj_key_PerfStatistics_L1DcachePrefetches, kn) {
					currentKey = ffj_t_PerfStatistics_L1DcachePrefetches
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffj_key_PerfStatistics_L1DcacheStoreMisses, kn) {
					currentKey = ffj_t_PerfStatistics_L1DcacheStoreMisses
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffj_key_PerfStatistics_L1DcacheStores, kn) {
					currentKey = ffj_t_PerfStatistics_L1DcacheStores
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffj_key_PerfStatistics_L1DcacheLoadMisses, kn) {
					currentKey = ffj_t_PerfStatistics_L1DcacheLoadMisses
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffj_key_PerfStatistics_L1DcacheLoads, kn) {
					currentKey = ffj_t_PerfStatistics_L1DcacheLoads
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffj_key_PerfStatistics_EmulationFaults, kn) {
					currentKey = ffj_t_PerfStatistics_EmulationFaults
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffj_key_PerfStatistics_AlignmentFaults, kn) {
					currentKey = ffj_t_PerfStatistics_AlignmentFaults
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffj_key_PerfStatistics_CPUMigrations, kn) {
					currentKey = ffj_t_PerfStatistics_CPUMigrations
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffj_key_PerfStatistics_ContextSwitches, kn) {
					currentKey = ffj_t_PerfStatistics_ContextSwitches
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffj_key_PerfStatistics_MajorFaults, kn) {
					currentKey = ffj_t_PerfStatistics_MajorFaults
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffj_key_PerfStatistics_MinorFaults, kn) {
					currentKey = ffj_t_PerfStatistics_MinorFaults
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffj_key_PerfStatistics_PageFaults, kn) {
					currentKey = ffj_t_PerfStatistics_PageFaults
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffj_key_PerfStatistics_TaskClock, kn) {
					currentKey = ffj_t_PerfStatistics_TaskClock
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffj_key_PerfStatistics_CPUClock, kn) {
					currentKey = ffj_t_PerfStatistics_CPUClock
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffj_key_PerfStatistics_RefCycles, kn) {
					currentKey = ffj_t_PerfStatistics_RefCycles
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffj_key_PerfStatistics_BusCycles, kn) {
					currentKey = ffj_t_PerfStatistics_BusCycles
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffj_key_PerfStatistics_BranchMisses, kn) {
					currentKey = ffj_t_PerfStatistics_BranchMisses
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffj_key_PerfStatistics_Branches, kn) {
					currentKey = ffj_t_PerfStatistics_Branches
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffj_key_PerfStatistics_CacheMisses, kn) {
					currentKey = ffj_t_PerfStatistics_CacheMisses
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffj_key_PerfStatistics_CacheReferences, kn) {
					currentKey = ffj_t_PerfStatistics_CacheReferences
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffj_key_PerfStatistics_Instructions, kn) {
					currentKey = ffj_t_PerfStatistics_Instructions
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffj_key_PerfStatistics_StalledCyclesBackend, kn) {
					currentKey = ffj_t_PerfStatistics_StalledCyclesBackend
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffj_key_PerfStatistics_StalledCyclesFrontend, kn) {
					currentKey = ffj_t_PerfStatistics_StalledCyclesFrontend
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffj_key_PerfStatistics_Cycles, kn) {
					currentKey = ffj_t_PerfStatistics_Cycles
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.SimpleLetterEqualFold(ffj_key_PerfStatistics_Duration, kn) {
					currentKey = ffj_t_PerfStatistics_Duration
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffj_key_PerfStatistics_Timestamp, kn) {
					currentKey = ffj_t_PerfStatistics_Timestamp
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				currentKey = ffj_t_PerfStatisticsno_such_key
				state = fflib.FFParse_want_colon
				goto mainparse
			}

		case fflib.FFParse_want_colon:
			if tok != fflib.FFTok_colon {
				wantedTok = fflib.FFTok_colon
				goto wrongtokenerror
			}
			state = fflib.FFParse_want_value
			continue
		case fflib.FFParse_want_value:

			if tok == fflib.FFTok_left_brace || tok == fflib.FFTok_left_bracket || tok == fflib.FFTok_integer || tok == fflib.FFTok_double || tok == fflib.FFTok_string || tok == fflib.FFTok_bool || tok == fflib.FFTok_null {
				switch currentKey {

				case ffj_t_PerfStatistics_Timestamp:
					goto handle_Timestamp

				case ffj_t_PerfStatistics_Duration:
					goto handle_Duration

				case ffj_t_PerfStatistics_Cycles:
					goto handle_Cycles

				case ffj_t_PerfStatistics_StalledCyclesFrontend:
					goto handle_StalledCyclesFrontend

				case ffj_t_PerfStatistics_StalledCyclesBackend:
					goto handle_StalledCyclesBackend

				case ffj_t_PerfStatistics_Instructions:
					goto handle_Instructions

				case ffj_t_PerfStatistics_CacheReferences:
					goto handle_CacheReferences

				case ffj_t_PerfStatistics_CacheMisses:
					goto handle_CacheMisses

				case ffj_t_PerfStatistics_Branches:
					goto handle_Branches

				case ffj_t_PerfStatistics_BranchMisses:
					goto handle_BranchMisses

				case ffj_t_PerfStatistics_BusCycles:
					goto handle_BusCycles

				case ffj_t_PerfStatistics_RefCycles:
					goto handle_RefCycles

				case ffj_t_PerfStatistics_CPUClock:
					goto handle_CPUClock

				case ffj_t_PerfStatistics_TaskClock:
					goto handle_TaskClock

				case ffj_t_PerfStatistics_PageFaults:
					goto handle_PageFaults

				case ffj_t_PerfStatistics_MinorFaults:
					goto handle_MinorFaults

				case ffj_t_PerfStatistics_MajorFaults:
					goto handle_MajorFaults

				case ffj_t_PerfStatistics_ContextSwitches:
					goto handle_ContextSwitches

				case ffj_t_PerfStatistics_CPUMigrations:
					goto handle_CPUMigrations

				case ffj_t_PerfStatistics_AlignmentFaults:
					goto handle_AlignmentFaults

				case ffj_t_PerfStatistics_EmulationFaults:
					goto handle_EmulationFaults

				case ffj_t_PerfStatistics_L1DcacheLoads:
					goto handle_L1DcacheLoads

				case ffj_t_PerfStatistics_L1DcacheLoadMisses:
					goto handle_L1DcacheLoadMisses

				case ffj_t_PerfStatistics_L1DcacheStores:
					goto handle_L1DcacheStores

				case ffj_t_PerfStatistics_L1DcacheStoreMisses:
					goto handle_L1DcacheStoreMisses

				case ffj_t_PerfStatistics_L1DcachePrefetches:
					goto handle_L1DcachePrefetches

				case ffj_t_PerfStatistics_L1DcachePrefetchMisses:
					goto handle_L1DcachePrefetchMisses

				case ffj_t_PerfStatistics_L1IcacheLoads:
					goto handle_L1IcacheLoads

				case ffj_t_PerfStatistics_L1IcacheLoadMisses:
					goto handle_L1IcacheLoadMisses

				case ffj_t_PerfStatistics_L1IcachePrefetches:
					goto handle_L1IcachePrefetches

				case ffj_t_PerfStatistics_L1IcachePrefetchMisses:
					goto handle_L1IcachePrefetchMisses

				case ffj_t_PerfStatistics_LLCLoads:
					goto handle_LLCLoads

				case ffj_t_PerfStatistics_LLCLoadMisses:
					goto handle_LLCLoadMisses

				case ffj_t_PerfStatistics_LLCStores:
					goto handle_LLCStores

				case ffj_t_PerfStatistics_LLCStoreMisses:
					goto handle_LLCStoreMisses

				case ffj_t_PerfStatistics_LLCPrefetches:
					goto handle_LLCPrefetches

				case ffj_t_PerfStatistics_LLCPrefetchMisses:
					goto handle_LLCPrefetchMisses

				case ffj_t_PerfStatistics_DTLBLoads:
					goto handle_DTLBLoads

				case ffj_t_PerfStatistics_DTLBLoadMisses:
					goto handle_DTLBLoadMisses

				case ffj_t_PerfStatistics_DTLBStores:
					goto handle_DTLBStores

				case ffj_t_PerfStatistics_DTLBStoreMisses:
					goto handle_DTLBStoreMisses

				case ffj_t_PerfStatistics_DTLBPrefetches:
					goto handle_DTLBPrefetches

				case ffj_t_PerfStatistics_DTLBPrefetchMisses:
					goto handle_DTLBPrefetchMisses

				case ffj_t_PerfStatistics_ITLBLoads:
					goto handle_ITLBLoads

				case ffj_t_PerfStatistics_ITLBLoadMisses:
					goto handle_ITLBLoadMisses

				case ffj_t_PerfStatistics_BranchLoads:
					goto handle_BranchLoads

				case ffj_t_PerfStatistics_BranchLoadMisses:
					goto handle_BranchLoadMisses

				case ffj_t_PerfStatistics_NodeLoads:
					goto handle_NodeLoads

				case ffj_t_PerfStatistics_NodeLoadMisses:
					goto handle_NodeLoadMisses

				case ffj_t_PerfStatistics_NodeStores:
					goto handle_NodeStores

				case ffj_t_PerfStatistics_NodeStoreMisses:
					goto handle_NodeStoreMisses

				case ffj_t_PerfStatistics_NodePrefetches:
					goto handle_NodePrefetches

				case ffj_t_PerfStatistics_NodePrefetchMisses:
					goto handle_NodePrefetchMisses

				case ffj_t_PerfStatisticsno_such_key:
					err = fs.SkipField(tok)
					if err != nil {
						return fs.WrapErr(err)
					}
					state = fflib.FFParse_after_value
					goto mainparse
				}
			} else {
				goto wantedvalue
			}
		}
	}

handle_Timestamp:

	/* handler: uj.Timestamp type=float64 kind=float64 quoted=false*/

	{
		if tok != fflib.FFTok_double && tok != fflib.FFTok_integer && tok != fflib.FFTok_null {
			return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for float64", tok))
		}
	}

	{

		if tok == fflib.FFTok_null {

		} else {

			tval, err := fflib.ParseFloat(fs.Output.Bytes(), 64)

			if err != nil {
				return fs.WrapErr(err)
			}

			uj.Timestamp = float64(tval)

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_Duration:

	/* handler: uj.Duration type=float64 kind=float64 quoted=false*/

	{
		if tok != fflib.FFTok_double && tok != fflib.FFTok_integer && tok != fflib.FFTok_null {
			return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for float64", tok))
		}
	}

	{

		if tok == fflib.FFTok_null {

		} else {

			tval, err := fflib.ParseFloat(fs.Output.Bytes(), 64)

			if err != nil {
				return fs.WrapErr(err)
			}

			uj.Duration = float64(tval)

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_Cycles:

	/* handler: uj.Cycles type=uint64 kind=uint64 quoted=false*/

	{
		if tok != fflib.FFTok_integer && tok != fflib.FFTok_null {
			return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for uint64", tok))
		}
	}

	{

		if tok == fflib.FFTok_null {

			uj.Cycles = nil

		} else {

			tval, err := fflib.ParseUint(fs.Output.Bytes(), 10, 64)

			if err != nil {
				return fs.WrapErr(err)
			}

			ttypval := uint64(tval)
			uj.Cycles = &ttypval

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_StalledCyclesFrontend:

	/* handler: uj.StalledCyclesFrontend type=uint64 kind=uint64 quoted=false*/

	{
		if tok != fflib.FFTok_integer && tok != fflib.FFTok_null {
			return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for uint64", tok))
		}
	}

	{

		if tok == fflib.FFTok_null {

			uj.StalledCyclesFrontend = nil

		} else {

			tval, err := fflib.ParseUint(fs.Output.Bytes(), 10, 64)

			if err != nil {
				return fs.WrapErr(err)
			}

			ttypval := uint64(tval)
			uj.StalledCyclesFrontend = &ttypval

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_StalledCyclesBackend:

	/* handler: uj.StalledCyclesBackend type=uint64 kind=uint64 quoted=false*/

	{
		if tok != fflib.FFTok_integer && tok != fflib.FFTok_null {
			return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for uint64", tok))
		}
	}

	{

		if tok == fflib.FFTok_null {

			uj.StalledCyclesBackend = nil

		} else {

			tval, err := fflib.ParseUint(fs.Output.Bytes(), 10, 64)

			if err != nil {
				return fs.WrapErr(err)
			}

			ttypval := uint64(tval)
			uj.StalledCyclesBackend = &ttypval

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_Instructions:

	/* handler: uj.Instructions type=uint64 kind=uint64 quoted=false*/

	{
		if tok != fflib.FFTok_integer && tok != fflib.FFTok_null {
			return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for uint64", tok))
		}
	}

	{

		if tok == fflib.FFTok_null {

			uj.Instructions = nil

		} else {

			tval, err := fflib.ParseUint(fs.Output.Bytes(), 10, 64)

			if err != nil {
				return fs.WrapErr(err)
			}

			ttypval := uint64(tval)
			uj.Instructions = &ttypval

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_CacheReferences:

	/* handler: uj.CacheReferences type=uint64 kind=uint64 quoted=false*/

	{
		if tok != fflib.FFTok_integer && tok != fflib.FFTok_null {
			return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for uint64", tok))
		}
	}

	{

		if tok == fflib.FFTok_null {

			uj.CacheReferences = nil

		} else {

			tval, err := fflib.ParseUint(fs.Output.Bytes(), 10, 64)

			if err != nil {
				return fs.WrapErr(err)
			}

			ttypval := uint64(tval)
			uj.CacheReferences = &ttypval

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_CacheMisses:

	/* handler: uj.CacheMisses type=uint64 kind=uint64 quoted=false*/

	{
		if tok != fflib.FFTok_integer && tok != fflib.FFTok_null {
			return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for uint64", tok))
		}
	}

	{

		if tok == fflib.FFTok_null {

			uj.CacheMisses = nil

		} else {

			tval, err := fflib.ParseUint(fs.Output.Bytes(), 10, 64)

			if err != nil {
				return fs.WrapErr(err)
			}

			ttypval := uint64(tval)
			uj.CacheMisses = &ttypval

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_Branches:

	/* handler: uj.Branches type=uint64 kind=uint64 quoted=false*/

	{
		if tok != fflib.FFTok_integer && tok != fflib.FFTok_null {
			return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for uint64", tok))
		}
	}

	{

		if tok == fflib.FFTok_null {

			uj.Branches = nil

		} else {

			tval, err := fflib.ParseUint(fs.Output.Bytes(), 10, 64)

			if err != nil {
				return fs.WrapErr(err)
			}

			ttypval := uint64(tval)
			uj.Branches = &ttypval

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_BranchMisses:

	/* handler: uj.BranchMisses type=uint64 kind=uint64 quoted=false*/

	{
		if tok != fflib.FFTok_integer && tok != fflib.FFTok_null {
			return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for uint64", tok))
		}
	}

	{

		if tok == fflib.FFTok_null {

			uj.BranchMisses = nil

		} else {

			tval, err := fflib.ParseUint(fs.Output.Bytes(), 10, 64)

			if err != nil {
				return fs.WrapErr(err)
			}

			ttypval := uint64(tval)
			uj.BranchMisses = &ttypval

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_BusCycles:

	/* handler: uj.BusCycles type=uint64 kind=uint64 quoted=false*/

	{
		if tok != fflib.FFTok_integer && tok != fflib.FFTok_null {
			return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for uint64", tok))
		}
	}

	{

		if tok == fflib.FFTok_null {

			uj.BusCycles = nil

		} else {

			tval, err := fflib.ParseUint(fs.Output.Bytes(), 10, 64)

			if err != nil {
				return fs.WrapErr(err)
			}

			ttypval := uint64(tval)
			uj.BusCycles = &ttypval

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_RefCycles:

	/* handler: uj.RefCycles type=uint64 kind=uint64 quoted=false*/

	{
		if tok != fflib.FFTok_integer && tok != fflib.FFTok_null {
			return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for uint64", tok))
		}
	}

	{

		if tok == fflib.FFTok_null {

			uj.RefCycles = nil

		} else {

			tval, err := fflib.ParseUint(fs.Output.Bytes(), 10, 64)

			if err != nil {
				return fs.WrapErr(err)
			}

			ttypval := uint64(tval)
			uj.RefCycles = &ttypval

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_CPUClock:

	/* handler: uj.CPUClock type=float64 kind=float64 quoted=false*/

	{
		if tok != fflib.FFTok_double && tok != fflib.FFTok_integer && tok != fflib.FFTok_null {
			return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for float64", tok))
		}
	}

	{

		if tok == fflib.FFTok_null {

			uj.CPUClock = nil

		} else {

			tval, err := fflib.ParseFloat(fs.Output.Bytes(), 64)

			if err != nil {
				return fs.WrapErr(err)
			}

			ttypval := float64(tval)
			uj.CPUClock = &ttypval

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_TaskClock:

	/* handler: uj.TaskClock type=float64 kind=float64 quoted=false*/

	{
		if tok != fflib.FFTok_double && tok != fflib.FFTok_integer && tok != fflib.FFTok_null {
			return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for float64", tok))
		}
	}

	{

		if tok == fflib.FFTok_null {

			uj.TaskClock = nil

		} else {

			tval, err := fflib.ParseFloat(fs.Output.Bytes(), 64)

			if err != nil {
				return fs.WrapErr(err)
			}

			ttypval := float64(tval)
			uj.TaskClock = &ttypval

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_PageFaults:

	/* handler: uj.PageFaults type=uint64 kind=uint64 quoted=false*/

	{
		if tok != fflib.FFTok_integer && tok != fflib.FFTok_null {
			return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for uint64", tok))
		}
	}

	{

		if tok == fflib.FFTok_null {

			uj.PageFaults = nil

		} else {

			tval, err := fflib.ParseUint(fs.Output.Bytes(), 10, 64)

			if err != nil {
				return fs.WrapErr(err)
			}

			ttypval := uint64(tval)
			uj.PageFaults = &ttypval

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_MinorFaults:

	/* handler: uj.MinorFaults type=uint64 kind=uint64 quoted=false*/

	{
		if tok != fflib.FFTok_integer && tok != fflib.FFTok_null {
			return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for uint64", tok))
		}
	}

	{

		if tok == fflib.FFTok_null {

			uj.MinorFaults = nil

		} else {

			tval, err := fflib.ParseUint(fs.Output.Bytes(), 10, 64)

			if err != nil {
				return fs.WrapErr(err)
			}

			ttypval := uint64(tval)
			uj.MinorFaults = &ttypval

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_MajorFaults:

	/* handler: uj.MajorFaults type=uint64 kind=uint64 quoted=false*/

	{
		if tok != fflib.FFTok_integer && tok != fflib.FFTok_null {
			return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for uint64", tok))
		}
	}

	{

		if tok == fflib.FFTok_null {

			uj.MajorFaults = nil

		} else {

			tval, err := fflib.ParseUint(fs.Output.Bytes(), 10, 64)

			if err != nil {
				return fs.WrapErr(err)
			}

			ttypval := uint64(tval)
			uj.MajorFaults = &ttypval

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_ContextSwitches:

	/* handler: uj.ContextSwitches type=uint64 kind=uint64 quoted=false*/

	{
		if tok != fflib.FFTok_integer && tok != fflib.FFTok_null {
			return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for uint64", tok))
		}
	}

	{

		if tok == fflib.FFTok_null {

			uj.ContextSwitches = nil

		} else {

			tval, err := fflib.ParseUint(fs.Output.Bytes(), 10, 64)

			if err != nil {
				return fs.WrapErr(err)
			}

			ttypval := uint64(tval)
			uj.ContextSwitches = &ttypval

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_CPUMigrations:

	/* handler: uj.CPUMigrations type=uint64 kind=uint64 quoted=false*/

	{
		if tok != fflib.FFTok_integer && tok != fflib.FFTok_null {
			return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for uint64", tok))
		}
	}

	{

		if tok == fflib.FFTok_null {

			uj.CPUMigrations = nil

		} else {

			tval, err := fflib.ParseUint(fs.Output.Bytes(), 10, 64)

			if err != nil {
				return fs.WrapErr(err)
			}

			ttypval := uint64(tval)
			uj.CPUMigrations = &ttypval

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_AlignmentFaults:

	/* handler: uj.AlignmentFaults type=uint64 kind=uint64 quoted=false*/

	{
		if tok != fflib.FFTok_integer && tok != fflib.FFTok_null {
			return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for uint64", tok))
		}
	}

	{

		if tok == fflib.FFTok_null {

			uj.AlignmentFaults = nil

		} else {

			tval, err := fflib.ParseUint(fs.Output.Bytes(), 10, 64)

			if err != nil {
				return fs.WrapErr(err)
			}

			ttypval := uint64(tval)
			uj.AlignmentFaults = &ttypval

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_EmulationFaults:

	/* handler: uj.EmulationFaults type=uint64 kind=uint64 quoted=false*/

	{
		if tok != fflib.FFTok_integer && tok != fflib.FFTok_null {
			return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for uint64", tok))
		}
	}

	{

		if tok == fflib.FFTok_null {

			uj.EmulationFaults = nil

		} else {

			tval, err := fflib.ParseUint(fs.Output.Bytes(), 10, 64)

			if err != nil {
				return fs.WrapErr(err)
			}

			ttypval := uint64(tval)
			uj.EmulationFaults = &ttypval

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_L1DcacheLoads:

	/* handler: uj.L1DcacheLoads type=uint64 kind=uint64 quoted=false*/

	{
		if tok != fflib.FFTok_integer && tok != fflib.FFTok_null {
			return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for uint64", tok))
		}
	}

	{

		if tok == fflib.FFTok_null {

			uj.L1DcacheLoads = nil

		} else {

			tval, err := fflib.ParseUint(fs.Output.Bytes(), 10, 64)

			if err != nil {
				return fs.WrapErr(err)
			}

			ttypval := uint64(tval)
			uj.L1DcacheLoads = &ttypval

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_L1DcacheLoadMisses:

	/* handler: uj.L1DcacheLoadMisses type=uint64 kind=uint64 quoted=false*/

	{
		if tok != fflib.FFTok_integer && tok != fflib.FFTok_null {
			return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for uint64", tok))
		}
	}

	{

		if tok == fflib.FFTok_null {

			uj.L1DcacheLoadMisses = nil

		} else {

			tval, err := fflib.ParseUint(fs.Output.Bytes(), 10, 64)

			if err != nil {
				return fs.WrapErr(err)
			}

			ttypval := uint64(tval)
			uj.L1DcacheLoadMisses = &ttypval

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_L1DcacheStores:

	/* handler: uj.L1DcacheStores type=uint64 kind=uint64 quoted=false*/

	{
		if tok != fflib.FFTok_integer && tok != fflib.FFTok_null {
			return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for uint64", tok))
		}
	}

	{

		if tok == fflib.FFTok_null {

			uj.L1DcacheStores = nil

		} else {

			tval, err := fflib.ParseUint(fs.Output.Bytes(), 10, 64)

			if err != nil {
				return fs.WrapErr(err)
			}

			ttypval := uint64(tval)
			uj.L1DcacheStores = &ttypval

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_L1DcacheStoreMisses:

	/* handler: uj.L1DcacheStoreMisses type=uint64 kind=uint64 quoted=false*/

	{
		if tok != fflib.FFTok_integer && tok != fflib.FFTok_null {
			return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for uint64", tok))
		}
	}

	{

		if tok == fflib.FFTok_null {

			uj.L1DcacheStoreMisses = nil

		} else {

			tval, err := fflib.ParseUint(fs.Output.Bytes(), 10, 64)

			if err != nil {
				return fs.WrapErr(err)
			}

			ttypval := uint64(tval)
			uj.L1DcacheStoreMisses = &ttypval

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_L1DcachePrefetches:

	/* handler: uj.L1DcachePrefetches type=uint64 kind=uint64 quoted=false*/

	{
		if tok != fflib.FFTok_integer && tok != fflib.FFTok_null {
			return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for uint64", tok))
		}
	}

	{

		if tok == fflib.FFTok_null {

			uj.L1DcachePrefetches = nil

		} else {

			tval, err := fflib.ParseUint(fs.Output.Bytes(), 10, 64)

			if err != nil {
				return fs.WrapErr(err)
			}

			ttypval := uint64(tval)
			uj.L1DcachePrefetches = &ttypval

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_L1DcachePrefetchMisses:

	/* handler: uj.L1DcachePrefetchMisses type=uint64 kind=uint64 quoted=false*/

	{
		if tok != fflib.FFTok_integer && tok != fflib.FFTok_null {
			return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for uint64", tok))
		}
	}

	{

		if tok == fflib.FFTok_null {

			uj.L1DcachePrefetchMisses = nil

		} else {

			tval, err := fflib.ParseUint(fs.Output.Bytes(), 10, 64)

			if err != nil {
				return fs.WrapErr(err)
			}

			ttypval := uint64(tval)
			uj.L1DcachePrefetchMisses = &ttypval

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_L1IcacheLoads:

	/* handler: uj.L1IcacheLoads type=uint64 kind=uint64 quoted=false*/

	{
		if tok != fflib.FFTok_integer && tok != fflib.FFTok_null {
			return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for uint64", tok))
		}
	}

	{

		if tok == fflib.FFTok_null {

			uj.L1IcacheLoads = nil

		} else {

			tval, err := fflib.ParseUint(fs.Output.Bytes(), 10, 64)

			if err != nil {
				return fs.WrapErr(err)
			}

			ttypval := uint64(tval)
			uj.L1IcacheLoads = &ttypval

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_L1IcacheLoadMisses:

	/* handler: uj.L1IcacheLoadMisses type=uint64 kind=uint64 quoted=false*/

	{
		if tok != fflib.FFTok_integer && tok != fflib.FFTok_null {
			return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for uint64", tok))
		}
	}

	{

		if tok == fflib.FFTok_null {

			uj.L1IcacheLoadMisses = nil

		} else {

			tval, err := fflib.ParseUint(fs.Output.Bytes(), 10, 64)

			if err != nil {
				return fs.WrapErr(err)
			}

			ttypval := uint64(tval)
			uj.L1IcacheLoadMisses = &ttypval

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_L1IcachePrefetches:

	/* handler: uj.L1IcachePrefetches type=uint64 kind=uint64 quoted=false*/

	{
		if tok != fflib.FFTok_integer && tok != fflib.FFTok_null {
			return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for uint64", tok))
		}
	}

	{

		if tok == fflib.FFTok_null {

			uj.L1IcachePrefetches = nil

		} else {

			tval, err := fflib.ParseUint(fs.Output.Bytes(), 10, 64)

			if err != nil {
				return fs.WrapErr(err)
			}

			ttypval := uint64(tval)
			uj.L1IcachePrefetches = &ttypval

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_L1IcachePrefetchMisses:

	/* handler: uj.L1IcachePrefetchMisses type=uint64 kind=uint64 quoted=false*/

	{
		if tok != fflib.FFTok_integer && tok != fflib.FFTok_null {
			return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for uint64", tok))
		}
	}

	{

		if tok == fflib.FFTok_null {

			uj.L1IcachePrefetchMisses = nil

		} else {

			tval, err := fflib.ParseUint(fs.Output.Bytes(), 10, 64)

			if err != nil {
				return fs.WrapErr(err)
			}

			ttypval := uint64(tval)
			uj.L1IcachePrefetchMisses = &ttypval

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_LLCLoads:

	/* handler: uj.LLCLoads type=uint64 kind=uint64 quoted=false*/

	{
		if tok != fflib.FFTok_integer && tok != fflib.FFTok_null {
			return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for uint64", tok))
		}
	}

	{

		if tok == fflib.FFTok_null {

			uj.LLCLoads = nil

		} else {

			tval, err := fflib.ParseUint(fs.Output.Bytes(), 10, 64)

			if err != nil {
				return fs.WrapErr(err)
			}

			ttypval := uint64(tval)
			uj.LLCLoads = &ttypval

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_LLCLoadMisses:

	/* handler: uj.LLCLoadMisses type=uint64 kind=uint64 quoted=false*/

	{
		if tok != fflib.FFTok_integer && tok != fflib.FFTok_null {
			return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for uint64", tok))
		}
	}

	{

		if tok == fflib.FFTok_null {

			uj.LLCLoadMisses = nil

		} else {

			tval, err := fflib.ParseUint(fs.Output.Bytes(), 10, 64)

			if err != nil {
				return fs.WrapErr(err)
			}

			ttypval := uint64(tval)
			uj.LLCLoadMisses = &ttypval

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_LLCStores:

	/* handler: uj.LLCStores type=uint64 kind=uint64 quoted=false*/

	{
		if tok != fflib.FFTok_integer && tok != fflib.FFTok_null {
			return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for uint64", tok))
		}
	}

	{

		if tok == fflib.FFTok_null {

			uj.LLCStores = nil

		} else {

			tval, err := fflib.ParseUint(fs.Output.Bytes(), 10, 64)

			if err != nil {
				return fs.WrapErr(err)
			}

			ttypval := uint64(tval)
			uj.LLCStores = &ttypval

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_LLCStoreMisses:

	/* handler: uj.LLCStoreMisses type=uint64 kind=uint64 quoted=false*/

	{
		if tok != fflib.FFTok_integer && tok != fflib.FFTok_null {
			return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for uint64", tok))
		}
	}

	{

		if tok == fflib.FFTok_null {

			uj.LLCStoreMisses = nil

		} else {

			tval, err := fflib.ParseUint(fs.Output.Bytes(), 10, 64)

			if err != nil {
				return fs.WrapErr(err)
			}

			ttypval := uint64(tval)
			uj.LLCStoreMisses = &ttypval

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_LLCPrefetches:

	/* handler: uj.LLCPrefetches type=uint64 kind=uint64 quoted=false*/

	{
		if tok != fflib.FFTok_integer && tok != fflib.FFTok_null {
			return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for uint64", tok))
		}
	}

	{

		if tok == fflib.FFTok_null {

			uj.LLCPrefetches = nil

		} else {

			tval, err := fflib.ParseUint(fs.Output.Bytes(), 10, 64)

			if err != nil {
				return fs.WrapErr(err)
			}

			ttypval := uint64(tval)
			uj.LLCPrefetches = &ttypval

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_LLCPrefetchMisses:

	/* handler: uj.LLCPrefetchMisses type=uint64 kind=uint64 quoted=false*/

	{
		if tok != fflib.FFTok_integer && tok != fflib.FFTok_null {
			return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for uint64", tok))
		}
	}

	{

		if tok == fflib.FFTok_null {

			uj.LLCPrefetchMisses = nil

		} else {

			tval, err := fflib.ParseUint(fs.Output.Bytes(), 10, 64)

			if err != nil {
				return fs.WrapErr(err)
			}

			ttypval := uint64(tval)
			uj.LLCPrefetchMisses = &ttypval

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_DTLBLoads:

	/* handler: uj.DTLBLoads type=uint64 kind=uint64 quoted=false*/

	{
		if tok != fflib.FFTok_integer && tok != fflib.FFTok_null {
			return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for uint64", tok))
		}
	}

	{

		if tok == fflib.FFTok_null {

			uj.DTLBLoads = nil

		} else {

			tval, err := fflib.ParseUint(fs.Output.Bytes(), 10, 64)

			if err != nil {
				return fs.WrapErr(err)
			}

			ttypval := uint64(tval)
			uj.DTLBLoads = &ttypval

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_DTLBLoadMisses:

	/* handler: uj.DTLBLoadMisses type=uint64 kind=uint64 quoted=false*/

	{
		if tok != fflib.FFTok_integer && tok != fflib.FFTok_null {
			return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for uint64", tok))
		}
	}

	{

		if tok == fflib.FFTok_null {

			uj.DTLBLoadMisses = nil

		} else {

			tval, err := fflib.ParseUint(fs.Output.Bytes(), 10, 64)

			if err != nil {
				return fs.WrapErr(err)
			}

			ttypval := uint64(tval)
			uj.DTLBLoadMisses = &ttypval

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_DTLBStores:

	/* handler: uj.DTLBStores type=uint64 kind=uint64 quoted=false*/

	{
		if tok != fflib.FFTok_integer && tok != fflib.FFTok_null {
			return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for uint64", tok))
		}
	}

	{

		if tok == fflib.FFTok_null {

			uj.DTLBStores = nil

		} else {

			tval, err := fflib.ParseUint(fs.Output.Bytes(), 10, 64)

			if err != nil {
				return fs.WrapErr(err)
			}

			ttypval := uint64(tval)
			uj.DTLBStores = &ttypval

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_DTLBStoreMisses:

	/* handler: uj.DTLBStoreMisses type=uint64 kind=uint64 quoted=false*/

	{
		if tok != fflib.FFTok_integer && tok != fflib.FFTok_null {
			return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for uint64", tok))
		}
	}

	{

		if tok == fflib.FFTok_null {

			uj.DTLBStoreMisses = nil

		} else {

			tval, err := fflib.ParseUint(fs.Output.Bytes(), 10, 64)

			if err != nil {
				return fs.WrapErr(err)
			}

			ttypval := uint64(tval)
			uj.DTLBStoreMisses = &ttypval

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_DTLBPrefetches:

	/* handler: uj.DTLBPrefetches type=uint64 kind=uint64 quoted=false*/

	{
		if tok != fflib.FFTok_integer && tok != fflib.FFTok_null {
			return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for uint64", tok))
		}
	}

	{

		if tok == fflib.FFTok_null {

			uj.DTLBPrefetches = nil

		} else {

			tval, err := fflib.ParseUint(fs.Output.Bytes(), 10, 64)

			if err != nil {
				return fs.WrapErr(err)
			}

			ttypval := uint64(tval)
			uj.DTLBPrefetches = &ttypval

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_DTLBPrefetchMisses:

	/* handler: uj.DTLBPrefetchMisses type=uint64 kind=uint64 quoted=false*/

	{
		if tok != fflib.FFTok_integer && tok != fflib.FFTok_null {
			return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for uint64", tok))
		}
	}

	{

		if tok == fflib.FFTok_null {

			uj.DTLBPrefetchMisses = nil

		} else {

			tval, err := fflib.ParseUint(fs.Output.Bytes(), 10, 64)

			if err != nil {
				return fs.WrapErr(err)
			}

			ttypval := uint64(tval)
			uj.DTLBPrefetchMisses = &ttypval

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_ITLBLoads:

	/* handler: uj.ITLBLoads type=uint64 kind=uint64 quoted=false*/

	{
		if tok != fflib.FFTok_integer && tok != fflib.FFTok_null {
			return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for uint64", tok))
		}
	}

	{

		if tok == fflib.FFTok_null {

			uj.ITLBLoads = nil

		} else {

			tval, err := fflib.ParseUint(fs.Output.Bytes(), 10, 64)

			if err != nil {
				return fs.WrapErr(err)
			}

			ttypval := uint64(tval)
			uj.ITLBLoads = &ttypval

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_ITLBLoadMisses:

	/* handler: uj.ITLBLoadMisses type=uint64 kind=uint64 quoted=false*/

	{
		if tok != fflib.FFTok_integer && tok != fflib.FFTok_null {
			return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for uint64", tok))
		}
	}

	{

		if tok == fflib.FFTok_null {

			uj.ITLBLoadMisses = nil

		} else {

			tval, err := fflib.ParseUint(fs.Output.Bytes(), 10, 64)

			if err != nil {
				return fs.WrapErr(err)
			}

			ttypval := uint64(tval)
			uj.ITLBLoadMisses = &ttypval

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_BranchLoads:

	/* handler: uj.BranchLoads type=uint64 kind=uint64 quoted=false*/

	{
		if tok != fflib.FFTok_integer && tok != fflib.FFTok_null {
			return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for uint64", tok))
		}
	}

	{

		if tok == fflib.FFTok_null {

			uj.BranchLoads = nil

		} else {

			tval, err := fflib.ParseUint(fs.Output.Bytes(), 10, 64)

			if err != nil {
				return fs.WrapErr(err)
			}

			ttypval := uint64(tval)
			uj.BranchLoads = &ttypval

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_BranchLoadMisses:

	/* handler: uj.BranchLoadMisses type=uint64 kind=uint64 quoted=false*/

	{
		if tok != fflib.FFTok_integer && tok != fflib.FFTok_null {
			return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for uint64", tok))
		}
	}

	{

		if tok == fflib.FFTok_null {

			uj.BranchLoadMisses = nil

		} else {

			tval, err := fflib.ParseUint(fs.Output.Bytes(), 10, 64)

			if err != nil {
				return fs.WrapErr(err)
			}

			ttypval := uint64(tval)
			uj.BranchLoadMisses = &ttypval

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_NodeLoads:

	/* handler: uj.NodeLoads type=uint64 kind=uint64 quoted=false*/

	{
		if tok != fflib.FFTok_integer && tok != fflib.FFTok_null {
			return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for uint64", tok))
		}
	}

	{

		if tok == fflib.FFTok_null {

			uj.NodeLoads = nil

		} else {

			tval, err := fflib.ParseUint(fs.Output.Bytes(), 10, 64)

			if err != nil {
				return fs.WrapErr(err)
			}

			ttypval := uint64(tval)
			uj.NodeLoads = &ttypval

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_NodeLoadMisses:

	/* handler: uj.NodeLoadMisses type=uint64 kind=uint64 quoted=false*/

	{
		if tok != fflib.FFTok_integer && tok != fflib.FFTok_null {
			return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for uint64", tok))
		}
	}

	{

		if tok == fflib.FFTok_null {

			uj.NodeLoadMisses = nil

		} else {

			tval, err := fflib.ParseUint(fs.Output.Bytes(), 10, 64)

			if err != nil {
				return fs.WrapErr(err)
			}

			ttypval := uint64(tval)
			uj.NodeLoadMisses = &ttypval

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_NodeStores:

	/* handler: uj.NodeStores type=uint64 kind=uint64 quoted=false*/

	{
		if tok != fflib.FFTok_integer && tok != fflib.FFTok_null {
			return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for uint64", tok))
		}
	}

	{

		if tok == fflib.FFTok_null {

			uj.NodeStores = nil

		} else {

			tval, err := fflib.ParseUint(fs.Output.Bytes(), 10, 64)

			if err != nil {
				return fs.WrapErr(err)
			}

			ttypval := uint64(tval)
			uj.NodeStores = &ttypval

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_NodeStoreMisses:

	/* handler: uj.NodeStoreMisses type=uint64 kind=uint64 quoted=false*/

	{
		if tok != fflib.FFTok_integer && tok != fflib.FFTok_null {
			return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for uint64", tok))
		}
	}

	{

		if tok == fflib.FFTok_null {

			uj.NodeStoreMisses = nil

		} else {

			tval, err := fflib.ParseUint(fs.Output.Bytes(), 10, 64)

			if err != nil {
				return fs.WrapErr(err)
			}

			ttypval := uint64(tval)
			uj.NodeStoreMisses = &ttypval

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_NodePrefetches:

	/* handler: uj.NodePrefetches type=uint64 kind=uint64 quoted=false*/

	{
		if tok != fflib.FFTok_integer && tok != fflib.FFTok_null {
			return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for uint64", tok))
		}
	}

	{

		if tok == fflib.FFTok_null {

			uj.NodePrefetches = nil

		} else {

			tval, err := fflib.ParseUint(fs.Output.Bytes(), 10, 64)

			if err != nil {
				return fs.WrapErr(err)
			}

			ttypval := uint64(tval)
			uj.NodePrefetches = &ttypval

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_NodePrefetchMisses:

	/* handler: uj.NodePrefetchMisses type=uint64 kind=uint64 quoted=false*/

	{
		if tok != fflib.FFTok_integer && tok != fflib.FFTok_null {
			return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for uint64", tok))
		}
	}

	{

		if tok == fflib.FFTok_null {

			uj.NodePrefetchMisses = nil

		} else {

			tval, err := fflib.ParseUint(fs.Output.Bytes(), 10, 64)

			if err != nil {
				return fs.WrapErr(err)
			}

			ttypval := uint64(tval)
			uj.NodePrefetchMisses = &ttypval

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

wantedvalue:
	return fs.WrapErr(fmt.Errorf("wanted value token, but got token: %v", tok))
wrongtokenerror:
	return fs.WrapErr(fmt.Errorf("ffjson: wanted token: %v, but got token: %v output=%s", wantedTok, tok, fs.Output.String()))
tokerror:
	if fs.BigError != nil {
		return fs.WrapErr(fs.BigError)
	}
	err = fs.Error.ToError()
	if err != nil {
		return fs.WrapErr(err)
	}
	panic("ffjson-generated: unreachable, please report bug.")
done:

	return nil
}

func (mj *Port) MarshalJSON() ([]byte, error) {
	var buf fflib.Buffer
	if mj == nil {
		buf.WriteString("null")
		return buf.Bytes(), nil
	}
	err := mj.MarshalJSONBuf(&buf)
	if err != nil {
		return nil, err
	}
	return buf.Bytes(), nil
}
func (mj *Port) MarshalJSONBuf(buf fflib.EncodingBuffer) error {
	if mj == nil {
		buf.WriteString("null")
		return nil
	}
	var err error
	var obj []byte
	_ = obj
	_ = err
	buf.WriteString(`{ "number":`)
	fflib.FormatBits2(buf, uint64(mj.Number), 10, false)
	buf.WriteByte(',')
	if mj.Name != nil {
		if true {
			buf.WriteString(`"name":`)
			fflib.WriteJsonString(buf, string(*mj.Name))
			buf.WriteByte(',')
		}
	}
	if mj.Protocol != nil {
		if true {
			buf.WriteString(`"protocol":`)
			fflib.WriteJsonString(buf, string(*mj.Protocol))
			buf.WriteByte(',')
		}
	}
	if mj.Visibility != nil {
		if true {
			buf.WriteString(`"visibility":`)

			{

				obj, err = mj.Visibility.MarshalJSON()
				if err != nil {
					return err
				}
				buf.Write(obj)

			}
			buf.WriteByte(',')
		}
	}
	if mj.Labels != nil {
		if true {
			buf.WriteString(`"labels":`)

			{

				err = mj.Labels.MarshalJSONBuf(buf)
				if err != nil {
					return err
				}

			}
			buf.WriteByte(',')
		}
	}
	buf.Rewind(1)
	buf.WriteByte('}')
	return nil
}

const (
	ffj_t_Portbase = iota
	ffj_t_Portno_such_key

	ffj_t_Port_Number

	ffj_t_Port_Name

	ffj_t_Port_Protocol

	ffj_t_Port_Visibility

	ffj_t_Port_Labels
)

var ffj_key_Port_Number = []byte("number")

var ffj_key_Port_Name = []byte("name")

var ffj_key_Port_Protocol = []byte("protocol")

var ffj_key_Port_Visibility = []byte("visibility")

var ffj_key_Port_Labels = []byte("labels")

func (uj *Port) UnmarshalJSON(input []byte) error {
	fs := fflib.NewFFLexer(input)
	return uj.UnmarshalJSONFFLexer(fs, fflib.FFParse_map_start)
}

func (uj *Port) UnmarshalJSONFFLexer(fs *fflib.FFLexer, state fflib.FFParseState) error {
	var err error = nil
	currentKey := ffj_t_Portbase
	_ = currentKey
	tok := fflib.FFTok_init
	wantedTok := fflib.FFTok_init

mainparse:
	for {
		tok = fs.Scan()
		//	println(fmt.Sprintf("debug: tok: %v  state: %v", tok, state))
		if tok == fflib.FFTok_error {
			goto tokerror
		}

		switch state {

		case fflib.FFParse_map_start:
			if tok != fflib.FFTok_left_bracket {
				wantedTok = fflib.FFTok_left_bracket
				goto wrongtokenerror
			}
			state = fflib.FFParse_want_key
			continue

		case fflib.FFParse_after_value:
			if tok == fflib.FFTok_comma {
				state = fflib.FFParse_want_key
			} else if tok == fflib.FFTok_right_bracket {
				goto done
			} else {
				wantedTok = fflib.FFTok_comma
				goto wrongtokenerror
			}

		case fflib.FFParse_want_key:
			// json {} ended. goto exit. woo.
			if tok == fflib.FFTok_right_bracket {
				goto done
			}
			if tok != fflib.FFTok_string {
				wantedTok = fflib.FFTok_string
				goto wrongtokenerror
			}

			kn := fs.Output.Bytes()
			if len(kn) <= 0 {
				// "" case. hrm.
				currentKey = ffj_t_Portno_such_key
				state = fflib.FFParse_want_colon
				goto mainparse
			} else {
				switch kn[0] {

				case 'l':

					if bytes.Equal(ffj_key_Port_Labels, kn) {
						currentKey = ffj_t_Port_Labels
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				case 'n':

					if bytes.Equal(ffj_key_Port_Number, kn) {
						currentKey = ffj_t_Port_Number
						state = fflib.FFParse_want_colon
						goto mainparse

					} else if bytes.Equal(ffj_key_Port_Name, kn) {
						currentKey = ffj_t_Port_Name
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				case 'p':

					if bytes.Equal(ffj_key_Port_Protocol, kn) {
						currentKey = ffj_t_Port_Protocol
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				case 'v':

					if bytes.Equal(ffj_key_Port_Visibility, kn) {
						currentKey = ffj_t_Port_Visibility
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				}

				if fflib.EqualFoldRight(ffj_key_Port_Labels, kn) {
					currentKey = ffj_t_Port_Labels
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffj_key_Port_Visibility, kn) {
					currentKey = ffj_t_Port_Visibility
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.SimpleLetterEqualFold(ffj_key_Port_Protocol, kn) {
					currentKey = ffj_t_Port_Protocol
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.SimpleLetterEqualFold(ffj_key_Port_Name, kn) {
					currentKey = ffj_t_Port_Name
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.SimpleLetterEqualFold(ffj_key_Port_Number, kn) {
					currentKey = ffj_t_Port_Number
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				currentKey = ffj_t_Portno_such_key
				state = fflib.FFParse_want_colon
				goto mainparse
			}

		case fflib.FFParse_want_colon:
			if tok != fflib.FFTok_colon {
				wantedTok = fflib.FFTok_colon
				goto wrongtokenerror
			}
			state = fflib.FFParse_want_value
			continue
		case fflib.FFParse_want_value:

			if tok == fflib.FFTok_left_brace || tok == fflib.FFTok_left_bracket || tok == fflib.FFTok_integer || tok == fflib.FFTok_double || tok == fflib.FFTok_string || tok == fflib.FFTok_bool || tok == fflib.FFTok_null {
				switch currentKey {

				case ffj_t_Port_Number:
					goto handle_Number

				case ffj_t_Port_Name:
					goto handle_Name

				case ffj_t_Port_Protocol:
					goto handle_Protocol

				case ffj_t_Port_Visibility:
					goto handle_Visibility

				case ffj_t_Port_Labels:
					goto handle_Labels

				case ffj_t_Portno_such_key:
					err = fs.SkipField(tok)
					if err != nil {
						return fs.WrapErr(err)
					}
					state = fflib.FFParse_after_value
					goto mainparse
				}
			} else {
				goto wantedvalue
			}
		}
	}

handle_Number:

	/* handler: uj.Number type=uint32 kind=uint32 quoted=false*/

	{
		if tok != fflib.FFTok_integer && tok != fflib.FFTok_null {
			return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for uint32", tok))
		}
	}

	{

		if tok == fflib.FFTok_null {

		} else {

			tval, err := fflib.ParseUint(fs.Output.Bytes(), 10, 32)

			if err != nil {
				return fs.WrapErr(err)
			}

			uj.Number = uint32(tval)

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_Name:

	/* handler: uj.Name type=string kind=string quoted=false*/

	{

		{
			if tok != fflib.FFTok_string && tok != fflib.FFTok_null {
				return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for string", tok))
			}
		}

		if tok == fflib.FFTok_null {

			uj.Name = nil

		} else {

			var tval string
			outBuf := fs.Output.Bytes()

			tval = string(string(outBuf))
			uj.Name = &tval

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_Protocol:

	/* handler: uj.Protocol type=string kind=string quoted=false*/

	{

		{
			if tok != fflib.FFTok_string && tok != fflib.FFTok_null {
				return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for string", tok))
			}
		}

		if tok == fflib.FFTok_null {

			uj.Protocol = nil

		} else {

			var tval string
			outBuf := fs.Output.Bytes()

			tval = string(string(outBuf))
			uj.Protocol = &tval

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_Visibility:

	/* handler: uj.Visibility type=mesos.DiscoveryInfo_Visibility kind=int32 quoted=false*/

	{
		if tok == fflib.FFTok_null {

			uj.Visibility = nil

			state = fflib.FFParse_after_value
			goto mainparse
		}

		tbuf, err := fs.CaptureField(tok)
		if err != nil {
			return fs.WrapErr(err)
		}

		if uj.Visibility == nil {
			uj.Visibility = new(DiscoveryInfo_Visibility)
		}

		err = uj.Visibility.UnmarshalJSON(tbuf)
		if err != nil {
			return fs.WrapErr(err)
		}
		state = fflib.FFParse_after_value
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_Labels:

	/* handler: uj.Labels type=mesos.Labels kind=struct quoted=false*/

	{
		if tok == fflib.FFTok_null {

			uj.Labels = nil

			state = fflib.FFParse_after_value
			goto mainparse
		}

		if uj.Labels == nil {
			uj.Labels = new(Labels)
		}

		err = uj.Labels.UnmarshalJSONFFLexer(fs, fflib.FFParse_want_key)
		if err != nil {
			return err
		}
		state = fflib.FFParse_after_value
	}

	state = fflib.FFParse_after_value
	goto mainparse

wantedvalue:
	return fs.WrapErr(fmt.Errorf("wanted value token, but got token: %v", tok))
wrongtokenerror:
	return fs.WrapErr(fmt.Errorf("ffjson: wanted token: %v, but got token: %v output=%s", wantedTok, tok, fs.Output.String()))
tokerror:
	if fs.BigError != nil {
		return fs.WrapErr(fs.BigError)
	}
	err = fs.Error.ToError()
	if err != nil {
		return fs.WrapErr(err)
	}
	panic("ffjson-generated: unreachable, please report bug.")
done:

	return nil
}

func (mj *Ports) MarshalJSON() ([]byte, error) {
	var buf fflib.Buffer
	if mj == nil {
		buf.WriteString("null")
		return buf.Bytes(), nil
	}
	err := mj.MarshalJSONBuf(&buf)
	if err != nil {
		return nil, err
	}
	return buf.Bytes(), nil
}
func (mj *Ports) MarshalJSONBuf(buf fflib.EncodingBuffer) error {
	if mj == nil {
		buf.WriteString("null")
		return nil
	}
	var err error
	var obj []byte
	_ = obj
	_ = err
	buf.WriteString(`{"ports":`)
	if mj.Ports != nil {
		buf.WriteString(`[`)
		for i, v := range mj.Ports {
			if i != 0 {
				buf.WriteString(`,`)
			}

			{

				err = v.MarshalJSONBuf(buf)
				if err != nil {
					return err
				}

			}
		}
		buf.WriteString(`]`)
	} else {
		buf.WriteString(`null`)
	}
	buf.WriteByte('}')
	return nil
}

const (
	ffj_t_Portsbase = iota
	ffj_t_Portsno_such_key

	ffj_t_Ports_Ports
)

var ffj_key_Ports_Ports = []byte("ports")

func (uj *Ports) UnmarshalJSON(input []byte) error {
	fs := fflib.NewFFLexer(input)
	return uj.UnmarshalJSONFFLexer(fs, fflib.FFParse_map_start)
}

func (uj *Ports) UnmarshalJSONFFLexer(fs *fflib.FFLexer, state fflib.FFParseState) error {
	var err error = nil
	currentKey := ffj_t_Portsbase
	_ = currentKey
	tok := fflib.FFTok_init
	wantedTok := fflib.FFTok_init

mainparse:
	for {
		tok = fs.Scan()
		//	println(fmt.Sprintf("debug: tok: %v  state: %v", tok, state))
		if tok == fflib.FFTok_error {
			goto tokerror
		}

		switch state {

		case fflib.FFParse_map_start:
			if tok != fflib.FFTok_left_bracket {
				wantedTok = fflib.FFTok_left_bracket
				goto wrongtokenerror
			}
			state = fflib.FFParse_want_key
			continue

		case fflib.FFParse_after_value:
			if tok == fflib.FFTok_comma {
				state = fflib.FFParse_want_key
			} else if tok == fflib.FFTok_right_bracket {
				goto done
			} else {
				wantedTok = fflib.FFTok_comma
				goto wrongtokenerror
			}

		case fflib.FFParse_want_key:
			// json {} ended. goto exit. woo.
			if tok == fflib.FFTok_right_bracket {
				goto done
			}
			if tok != fflib.FFTok_string {
				wantedTok = fflib.FFTok_string
				goto wrongtokenerror
			}

			kn := fs.Output.Bytes()
			if len(kn) <= 0 {
				// "" case. hrm.
				currentKey = ffj_t_Portsno_such_key
				state = fflib.FFParse_want_colon
				goto mainparse
			} else {
				switch kn[0] {

				case 'p':

					if bytes.Equal(ffj_key_Ports_Ports, kn) {
						currentKey = ffj_t_Ports_Ports
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				}

				if fflib.EqualFoldRight(ffj_key_Ports_Ports, kn) {
					currentKey = ffj_t_Ports_Ports
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				currentKey = ffj_t_Portsno_such_key
				state = fflib.FFParse_want_colon
				goto mainparse
			}

		case fflib.FFParse_want_colon:
			if tok != fflib.FFTok_colon {
				wantedTok = fflib.FFTok_colon
				goto wrongtokenerror
			}
			state = fflib.FFParse_want_value
			continue
		case fflib.FFParse_want_value:

			if tok == fflib.FFTok_left_brace || tok == fflib.FFTok_left_bracket || tok == fflib.FFTok_integer || tok == fflib.FFTok_double || tok == fflib.FFTok_string || tok == fflib.FFTok_bool || tok == fflib.FFTok_null {
				switch currentKey {

				case ffj_t_Ports_Ports:
					goto handle_Ports

				case ffj_t_Portsno_such_key:
					err = fs.SkipField(tok)
					if err != nil {
						return fs.WrapErr(err)
					}
					state = fflib.FFParse_after_value
					goto mainparse
				}
			} else {
				goto wantedvalue
			}
		}
	}

handle_Ports:

	/* handler: uj.Ports type=[]mesos.Port kind=slice quoted=false*/

	{

		{
			if tok != fflib.FFTok_left_brace && tok != fflib.FFTok_null {
				return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for ", tok))
			}
		}

		if tok == fflib.FFTok_null {
			uj.Ports = nil
		} else {

			uj.Ports = []Port{}

			wantVal := true

			for {

				var tmp_uj__Ports Port

				tok = fs.Scan()
				if tok == fflib.FFTok_error {
					goto tokerror
				}
				if tok == fflib.FFTok_right_brace {
					break
				}

				if tok == fflib.FFTok_comma {
					if wantVal == true {
						// TODO(pquerna): this isn't an ideal error message, this handles
						// things like [,,,] as an array value.
						return fs.WrapErr(fmt.Errorf("wanted value token, but got token: %v", tok))
					}
					continue
				} else {
					wantVal = true
				}

				/* handler: tmp_uj__Ports type=mesos.Port kind=struct quoted=false*/

				{
					if tok == fflib.FFTok_null {

						state = fflib.FFParse_after_value
						goto mainparse
					}

					err = tmp_uj__Ports.UnmarshalJSONFFLexer(fs, fflib.FFParse_want_key)
					if err != nil {
						return err
					}
					state = fflib.FFParse_after_value
				}

				uj.Ports = append(uj.Ports, tmp_uj__Ports)

				wantVal = false
			}
		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

wantedvalue:
	return fs.WrapErr(fmt.Errorf("wanted value token, but got token: %v", tok))
wrongtokenerror:
	return fs.WrapErr(fmt.Errorf("ffjson: wanted token: %v, but got token: %v output=%s", wantedTok, tok, fs.Output.String()))
tokerror:
	if fs.BigError != nil {
		return fs.WrapErr(fs.BigError)
	}
	err = fs.Error.ToError()
	if err != nil {
		return fs.WrapErr(err)
	}
	panic("ffjson-generated: unreachable, please report bug.")
done:

	return nil
}

func (mj *RLimitInfo) MarshalJSON() ([]byte, error) {
	var buf fflib.Buffer
	if mj == nil {
		buf.WriteString("null")
		return buf.Bytes(), nil
	}
	err := mj.MarshalJSONBuf(&buf)
	if err != nil {
		return nil, err
	}
	return buf.Bytes(), nil
}
func (mj *RLimitInfo) MarshalJSONBuf(buf fflib.EncodingBuffer) error {
	if mj == nil {
		buf.WriteString("null")
		return nil
	}
	var err error
	var obj []byte
	_ = obj
	_ = err
	buf.WriteString(`{"rlimits":`)
	if mj.Rlimits != nil {
		buf.WriteString(`[`)
		for i, v := range mj.Rlimits {
			if i != 0 {
				buf.WriteString(`,`)
			}

			{

				err = v.MarshalJSONBuf(buf)
				if err != nil {
					return err
				}

			}
		}
		buf.WriteString(`]`)
	} else {
		buf.WriteString(`null`)
	}
	buf.WriteByte('}')
	return nil
}

const (
	ffj_t_RLimitInfobase = iota
	ffj_t_RLimitInfono_such_key

	ffj_t_RLimitInfo_Rlimits
)

var ffj_key_RLimitInfo_Rlimits = []byte("rlimits")

func (uj *RLimitInfo) UnmarshalJSON(input []byte) error {
	fs := fflib.NewFFLexer(input)
	return uj.UnmarshalJSONFFLexer(fs, fflib.FFParse_map_start)
}

func (uj *RLimitInfo) UnmarshalJSONFFLexer(fs *fflib.FFLexer, state fflib.FFParseState) error {
	var err error = nil
	currentKey := ffj_t_RLimitInfobase
	_ = currentKey
	tok := fflib.FFTok_init
	wantedTok := fflib.FFTok_init

mainparse:
	for {
		tok = fs.Scan()
		//	println(fmt.Sprintf("debug: tok: %v  state: %v", tok, state))
		if tok == fflib.FFTok_error {
			goto tokerror
		}

		switch state {

		case fflib.FFParse_map_start:
			if tok != fflib.FFTok_left_bracket {
				wantedTok = fflib.FFTok_left_bracket
				goto wrongtokenerror
			}
			state = fflib.FFParse_want_key
			continue

		case fflib.FFParse_after_value:
			if tok == fflib.FFTok_comma {
				state = fflib.FFParse_want_key
			} else if tok == fflib.FFTok_right_bracket {
				goto done
			} else {
				wantedTok = fflib.FFTok_comma
				goto wrongtokenerror
			}

		case fflib.FFParse_want_key:
			// json {} ended. goto exit. woo.
			if tok == fflib.FFTok_right_bracket {
				goto done
			}
			if tok != fflib.FFTok_string {
				wantedTok = fflib.FFTok_string
				goto wrongtokenerror
			}

			kn := fs.Output.Bytes()
			if len(kn) <= 0 {
				// "" case. hrm.
				currentKey = ffj_t_RLimitInfono_such_key
				state = fflib.FFParse_want_colon
				goto mainparse
			} else {
				switch kn[0] {

				case 'r':

					if bytes.Equal(ffj_key_RLimitInfo_Rlimits, kn) {
						currentKey = ffj_t_RLimitInfo_Rlimits
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				}

				if fflib.EqualFoldRight(ffj_key_RLimitInfo_Rlimits, kn) {
					currentKey = ffj_t_RLimitInfo_Rlimits
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				currentKey = ffj_t_RLimitInfono_such_key
				state = fflib.FFParse_want_colon
				goto mainparse
			}

		case fflib.FFParse_want_colon:
			if tok != fflib.FFTok_colon {
				wantedTok = fflib.FFTok_colon
				goto wrongtokenerror
			}
			state = fflib.FFParse_want_value
			continue
		case fflib.FFParse_want_value:

			if tok == fflib.FFTok_left_brace || tok == fflib.FFTok_left_bracket || tok == fflib.FFTok_integer || tok == fflib.FFTok_double || tok == fflib.FFTok_string || tok == fflib.FFTok_bool || tok == fflib.FFTok_null {
				switch currentKey {

				case ffj_t_RLimitInfo_Rlimits:
					goto handle_Rlimits

				case ffj_t_RLimitInfono_such_key:
					err = fs.SkipField(tok)
					if err != nil {
						return fs.WrapErr(err)
					}
					state = fflib.FFParse_after_value
					goto mainparse
				}
			} else {
				goto wantedvalue
			}
		}
	}

handle_Rlimits:

	/* handler: uj.Rlimits type=[]mesos.RLimitInfo_RLimit kind=slice quoted=false*/

	{

		{
			if tok != fflib.FFTok_left_brace && tok != fflib.FFTok_null {
				return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for ", tok))
			}
		}

		if tok == fflib.FFTok_null {
			uj.Rlimits = nil
		} else {

			uj.Rlimits = []RLimitInfo_RLimit{}

			wantVal := true

			for {

				var tmp_uj__Rlimits RLimitInfo_RLimit

				tok = fs.Scan()
				if tok == fflib.FFTok_error {
					goto tokerror
				}
				if tok == fflib.FFTok_right_brace {
					break
				}

				if tok == fflib.FFTok_comma {
					if wantVal == true {
						// TODO(pquerna): this isn't an ideal error message, this handles
						// things like [,,,] as an array value.
						return fs.WrapErr(fmt.Errorf("wanted value token, but got token: %v", tok))
					}
					continue
				} else {
					wantVal = true
				}

				/* handler: tmp_uj__Rlimits type=mesos.RLimitInfo_RLimit kind=struct quoted=false*/

				{
					if tok == fflib.FFTok_null {

						state = fflib.FFParse_after_value
						goto mainparse
					}

					err = tmp_uj__Rlimits.UnmarshalJSONFFLexer(fs, fflib.FFParse_want_key)
					if err != nil {
						return err
					}
					state = fflib.FFParse_after_value
				}

				uj.Rlimits = append(uj.Rlimits, tmp_uj__Rlimits)

				wantVal = false
			}
		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

wantedvalue:
	return fs.WrapErr(fmt.Errorf("wanted value token, but got token: %v", tok))
wrongtokenerror:
	return fs.WrapErr(fmt.Errorf("ffjson: wanted token: %v, but got token: %v output=%s", wantedTok, tok, fs.Output.String()))
tokerror:
	if fs.BigError != nil {
		return fs.WrapErr(fs.BigError)
	}
	err = fs.Error.ToError()
	if err != nil {
		return fs.WrapErr(err)
	}
	panic("ffjson-generated: unreachable, please report bug.")
done:

	return nil
}

func (mj *RLimitInfo_RLimit) MarshalJSON() ([]byte, error) {
	var buf fflib.Buffer
	if mj == nil {
		buf.WriteString("null")
		return buf.Bytes(), nil
	}
	err := mj.MarshalJSONBuf(&buf)
	if err != nil {
		return nil, err
	}
	return buf.Bytes(), nil
}
func (mj *RLimitInfo_RLimit) MarshalJSONBuf(buf fflib.EncodingBuffer) error {
	if mj == nil {
		buf.WriteString("null")
		return nil
	}
	var err error
	var obj []byte
	_ = obj
	_ = err
	buf.WriteString(`{ "type":`)

	{

		obj, err = mj.Type.MarshalJSON()
		if err != nil {
			return err
		}
		buf.Write(obj)

	}
	buf.WriteByte(',')
	if mj.Hard != nil {
		if true {
			buf.WriteString(`"hard":`)
			fflib.FormatBits2(buf, uint64(*mj.Hard), 10, false)
			buf.WriteByte(',')
		}
	}
	if mj.Soft != nil {
		if true {
			buf.WriteString(`"soft":`)
			fflib.FormatBits2(buf, uint64(*mj.Soft), 10, false)
			buf.WriteByte(',')
		}
	}
	buf.Rewind(1)
	buf.WriteByte('}')
	return nil
}

const (
	ffj_t_RLimitInfo_RLimitbase = iota
	ffj_t_RLimitInfo_RLimitno_such_key

	ffj_t_RLimitInfo_RLimit_Type

	ffj_t_RLimitInfo_RLimit_Hard

	ffj_t_RLimitInfo_RLimit_Soft
)

var ffj_key_RLimitInfo_RLimit_Type = []byte("type")

var ffj_key_RLimitInfo_RLimit_Hard = []byte("hard")

var ffj_key_RLimitInfo_RLimit_Soft = []byte("soft")

func (uj *RLimitInfo_RLimit) UnmarshalJSON(input []byte) error {
	fs := fflib.NewFFLexer(input)
	return uj.UnmarshalJSONFFLexer(fs, fflib.FFParse_map_start)
}

func (uj *RLimitInfo_RLimit) UnmarshalJSONFFLexer(fs *fflib.FFLexer, state fflib.FFParseState) error {
	var err error = nil
	currentKey := ffj_t_RLimitInfo_RLimitbase
	_ = currentKey
	tok := fflib.FFTok_init
	wantedTok := fflib.FFTok_init

mainparse:
	for {
		tok = fs.Scan()
		//	println(fmt.Sprintf("debug: tok: %v  state: %v", tok, state))
		if tok == fflib.FFTok_error {
			goto tokerror
		}

		switch state {

		case fflib.FFParse_map_start:
			if tok != fflib.FFTok_left_bracket {
				wantedTok = fflib.FFTok_left_bracket
				goto wrongtokenerror
			}
			state = fflib.FFParse_want_key
			continue

		case fflib.FFParse_after_value:
			if tok == fflib.FFTok_comma {
				state = fflib.FFParse_want_key
			} else if tok == fflib.FFTok_right_bracket {
				goto done
			} else {
				wantedTok = fflib.FFTok_comma
				goto wrongtokenerror
			}

		case fflib.FFParse_want_key:
			// json {} ended. goto exit. woo.
			if tok == fflib.FFTok_right_bracket {
				goto done
			}
			if tok != fflib.FFTok_string {
				wantedTok = fflib.FFTok_string
				goto wrongtokenerror
			}

			kn := fs.Output.Bytes()
			if len(kn) <= 0 {
				// "" case. hrm.
				currentKey = ffj_t_RLimitInfo_RLimitno_such_key
				state = fflib.FFParse_want_colon
				goto mainparse
			} else {
				switch kn[0] {

				case 'h':

					if bytes.Equal(ffj_key_RLimitInfo_RLimit_Hard, kn) {
						currentKey = ffj_t_RLimitInfo_RLimit_Hard
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				case 's':

					if bytes.Equal(ffj_key_RLimitInfo_RLimit_Soft, kn) {
						currentKey = ffj_t_RLimitInfo_RLimit_Soft
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				case 't':

					if bytes.Equal(ffj_key_RLimitInfo_RLimit_Type, kn) {
						currentKey = ffj_t_RLimitInfo_RLimit_Type
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				}

				if fflib.EqualFoldRight(ffj_key_RLimitInfo_RLimit_Soft, kn) {
					currentKey = ffj_t_RLimitInfo_RLimit_Soft
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.SimpleLetterEqualFold(ffj_key_RLimitInfo_RLimit_Hard, kn) {
					currentKey = ffj_t_RLimitInfo_RLimit_Hard
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.SimpleLetterEqualFold(ffj_key_RLimitInfo_RLimit_Type, kn) {
					currentKey = ffj_t_RLimitInfo_RLimit_Type
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				currentKey = ffj_t_RLimitInfo_RLimitno_such_key
				state = fflib.FFParse_want_colon
				goto mainparse
			}

		case fflib.FFParse_want_colon:
			if tok != fflib.FFTok_colon {
				wantedTok = fflib.FFTok_colon
				goto wrongtokenerror
			}
			state = fflib.FFParse_want_value
			continue
		case fflib.FFParse_want_value:

			if tok == fflib.FFTok_left_brace || tok == fflib.FFTok_left_bracket || tok == fflib.FFTok_integer || tok == fflib.FFTok_double || tok == fflib.FFTok_string || tok == fflib.FFTok_bool || tok == fflib.FFTok_null {
				switch currentKey {

				case ffj_t_RLimitInfo_RLimit_Type:
					goto handle_Type

				case ffj_t_RLimitInfo_RLimit_Hard:
					goto handle_Hard

				case ffj_t_RLimitInfo_RLimit_Soft:
					goto handle_Soft

				case ffj_t_RLimitInfo_RLimitno_such_key:
					err = fs.SkipField(tok)
					if err != nil {
						return fs.WrapErr(err)
					}
					state = fflib.FFParse_after_value
					goto mainparse
				}
			} else {
				goto wantedvalue
			}
		}
	}

handle_Type:

	/* handler: uj.Type type=mesos.RLimitInfo_RLimit_Type kind=int32 quoted=false*/

	{
		if tok == fflib.FFTok_null {

			state = fflib.FFParse_after_value
			goto mainparse
		}

		tbuf, err := fs.CaptureField(tok)
		if err != nil {
			return fs.WrapErr(err)
		}

		err = uj.Type.UnmarshalJSON(tbuf)
		if err != nil {
			return fs.WrapErr(err)
		}
		state = fflib.FFParse_after_value
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_Hard:

	/* handler: uj.Hard type=uint64 kind=uint64 quoted=false*/

	{
		if tok != fflib.FFTok_integer && tok != fflib.FFTok_null {
			return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for uint64", tok))
		}
	}

	{

		if tok == fflib.FFTok_null {

			uj.Hard = nil

		} else {

			tval, err := fflib.ParseUint(fs.Output.Bytes(), 10, 64)

			if err != nil {
				return fs.WrapErr(err)
			}

			ttypval := uint64(tval)
			uj.Hard = &ttypval

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_Soft:

	/* handler: uj.Soft type=uint64 kind=uint64 quoted=false*/

	{
		if tok != fflib.FFTok_integer && tok != fflib.FFTok_null {
			return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for uint64", tok))
		}
	}

	{

		if tok == fflib.FFTok_null {

			uj.Soft = nil

		} else {

			tval, err := fflib.ParseUint(fs.Output.Bytes(), 10, 64)

			if err != nil {
				return fs.WrapErr(err)
			}

			ttypval := uint64(tval)
			uj.Soft = &ttypval

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

wantedvalue:
	return fs.WrapErr(fmt.Errorf("wanted value token, but got token: %v", tok))
wrongtokenerror:
	return fs.WrapErr(fmt.Errorf("ffjson: wanted token: %v, but got token: %v output=%s", wantedTok, tok, fs.Output.String()))
tokerror:
	if fs.BigError != nil {
		return fs.WrapErr(fs.BigError)
	}
	err = fs.Error.ToError()
	if err != nil {
		return fs.WrapErr(err)
	}
	panic("ffjson-generated: unreachable, please report bug.")
done:

	return nil
}

func (mj *RateLimit) MarshalJSON() ([]byte, error) {
	var buf fflib.Buffer
	if mj == nil {
		buf.WriteString("null")
		return buf.Bytes(), nil
	}
	err := mj.MarshalJSONBuf(&buf)
	if err != nil {
		return nil, err
	}
	return buf.Bytes(), nil
}
func (mj *RateLimit) MarshalJSONBuf(buf fflib.EncodingBuffer) error {
	if mj == nil {
		buf.WriteString("null")
		return nil
	}
	var err error
	var obj []byte
	_ = obj
	_ = err
	buf.WriteString(`{ `)
	if mj.QPS != nil {
		if true {
			buf.WriteString(`"qps":`)
			fflib.AppendFloat(buf, float64(*mj.QPS), 'g', -1, 64)
			buf.WriteByte(',')
		}
	}
	buf.WriteString(`"principal":`)
	fflib.WriteJsonString(buf, string(mj.Principal))
	buf.WriteByte(',')
	if mj.Capacity != nil {
		if true {
			buf.WriteString(`"capacity":`)
			fflib.FormatBits2(buf, uint64(*mj.Capacity), 10, false)
			buf.WriteByte(',')
		}
	}
	buf.Rewind(1)
	buf.WriteByte('}')
	return nil
}

const (
	ffj_t_RateLimitbase = iota
	ffj_t_RateLimitno_such_key

	ffj_t_RateLimit_QPS

	ffj_t_RateLimit_Principal

	ffj_t_RateLimit_Capacity
)

var ffj_key_RateLimit_QPS = []byte("qps")

var ffj_key_RateLimit_Principal = []byte("principal")

var ffj_key_RateLimit_Capacity = []byte("capacity")

func (uj *RateLimit) UnmarshalJSON(input []byte) error {
	fs := fflib.NewFFLexer(input)
	return uj.UnmarshalJSONFFLexer(fs, fflib.FFParse_map_start)
}

func (uj *RateLimit) UnmarshalJSONFFLexer(fs *fflib.FFLexer, state fflib.FFParseState) error {
	var err error = nil
	currentKey := ffj_t_RateLimitbase
	_ = currentKey
	tok := fflib.FFTok_init
	wantedTok := fflib.FFTok_init

mainparse:
	for {
		tok = fs.Scan()
		//	println(fmt.Sprintf("debug: tok: %v  state: %v", tok, state))
		if tok == fflib.FFTok_error {
			goto tokerror
		}

		switch state {

		case fflib.FFParse_map_start:
			if tok != fflib.FFTok_left_bracket {
				wantedTok = fflib.FFTok_left_bracket
				goto wrongtokenerror
			}
			state = fflib.FFParse_want_key
			continue

		case fflib.FFParse_after_value:
			if tok == fflib.FFTok_comma {
				state = fflib.FFParse_want_key
			} else if tok == fflib.FFTok_right_bracket {
				goto done
			} else {
				wantedTok = fflib.FFTok_comma
				goto wrongtokenerror
			}

		case fflib.FFParse_want_key:
			// json {} ended. goto exit. woo.
			if tok == fflib.FFTok_right_bracket {
				goto done
			}
			if tok != fflib.FFTok_string {
				wantedTok = fflib.FFTok_string
				goto wrongtokenerror
			}

			kn := fs.Output.Bytes()
			if len(kn) <= 0 {
				// "" case. hrm.
				currentKey = ffj_t_RateLimitno_such_key
				state = fflib.FFParse_want_colon
				goto mainparse
			} else {
				switch kn[0] {

				case 'c':

					if bytes.Equal(ffj_key_RateLimit_Capacity, kn) {
						currentKey = ffj_t_RateLimit_Capacity
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				case 'p':

					if bytes.Equal(ffj_key_RateLimit_Principal, kn) {
						currentKey = ffj_t_RateLimit_Principal
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				case 'q':

					if bytes.Equal(ffj_key_RateLimit_QPS, kn) {
						currentKey = ffj_t_RateLimit_QPS
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				}

				if fflib.SimpleLetterEqualFold(ffj_key_RateLimit_Capacity, kn) {
					currentKey = ffj_t_RateLimit_Capacity
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.SimpleLetterEqualFold(ffj_key_RateLimit_Principal, kn) {
					currentKey = ffj_t_RateLimit_Principal
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffj_key_RateLimit_QPS, kn) {
					currentKey = ffj_t_RateLimit_QPS
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				currentKey = ffj_t_RateLimitno_such_key
				state = fflib.FFParse_want_colon
				goto mainparse
			}

		case fflib.FFParse_want_colon:
			if tok != fflib.FFTok_colon {
				wantedTok = fflib.FFTok_colon
				goto wrongtokenerror
			}
			state = fflib.FFParse_want_value
			continue
		case fflib.FFParse_want_value:

			if tok == fflib.FFTok_left_brace || tok == fflib.FFTok_left_bracket || tok == fflib.FFTok_integer || tok == fflib.FFTok_double || tok == fflib.FFTok_string || tok == fflib.FFTok_bool || tok == fflib.FFTok_null {
				switch currentKey {

				case ffj_t_RateLimit_QPS:
					goto handle_QPS

				case ffj_t_RateLimit_Principal:
					goto handle_Principal

				case ffj_t_RateLimit_Capacity:
					goto handle_Capacity

				case ffj_t_RateLimitno_such_key:
					err = fs.SkipField(tok)
					if err != nil {
						return fs.WrapErr(err)
					}
					state = fflib.FFParse_after_value
					goto mainparse
				}
			} else {
				goto wantedvalue
			}
		}
	}

handle_QPS:

	/* handler: uj.QPS type=float64 kind=float64 quoted=false*/

	{
		if tok != fflib.FFTok_double && tok != fflib.FFTok_integer && tok != fflib.FFTok_null {
			return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for float64", tok))
		}
	}

	{

		if tok == fflib.FFTok_null {

			uj.QPS = nil

		} else {

			tval, err := fflib.ParseFloat(fs.Output.Bytes(), 64)

			if err != nil {
				return fs.WrapErr(err)
			}

			ttypval := float64(tval)
			uj.QPS = &ttypval

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_Principal:

	/* handler: uj.Principal type=string kind=string quoted=false*/

	{

		{
			if tok != fflib.FFTok_string && tok != fflib.FFTok_null {
				return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for string", tok))
			}
		}

		if tok == fflib.FFTok_null {

		} else {

			outBuf := fs.Output.Bytes()

			uj.Principal = string(string(outBuf))

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_Capacity:

	/* handler: uj.Capacity type=uint64 kind=uint64 quoted=false*/

	{
		if tok != fflib.FFTok_integer && tok != fflib.FFTok_null {
			return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for uint64", tok))
		}
	}

	{

		if tok == fflib.FFTok_null {

			uj.Capacity = nil

		} else {

			tval, err := fflib.ParseUint(fs.Output.Bytes(), 10, 64)

			if err != nil {
				return fs.WrapErr(err)
			}

			ttypval := uint64(tval)
			uj.Capacity = &ttypval

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

wantedvalue:
	return fs.WrapErr(fmt.Errorf("wanted value token, but got token: %v", tok))
wrongtokenerror:
	return fs.WrapErr(fmt.Errorf("ffjson: wanted token: %v, but got token: %v output=%s", wantedTok, tok, fs.Output.String()))
tokerror:
	if fs.BigError != nil {
		return fs.WrapErr(fs.BigError)
	}
	err = fs.Error.ToError()
	if err != nil {
		return fs.WrapErr(err)
	}
	panic("ffjson-generated: unreachable, please report bug.")
done:

	return nil
}

func (mj *RateLimits) MarshalJSON() ([]byte, error) {
	var buf fflib.Buffer
	if mj == nil {
		buf.WriteString("null")
		return buf.Bytes(), nil
	}
	err := mj.MarshalJSONBuf(&buf)
	if err != nil {
		return nil, err
	}
	return buf.Bytes(), nil
}
func (mj *RateLimits) MarshalJSONBuf(buf fflib.EncodingBuffer) error {
	if mj == nil {
		buf.WriteString("null")
		return nil
	}
	var err error
	var obj []byte
	_ = obj
	_ = err
	buf.WriteString(`{ "limits":`)
	if mj.Limits != nil {
		buf.WriteString(`[`)
		for i, v := range mj.Limits {
			if i != 0 {
				buf.WriteString(`,`)
			}

			{

				err = v.MarshalJSONBuf(buf)
				if err != nil {
					return err
				}

			}
		}
		buf.WriteString(`]`)
	} else {
		buf.WriteString(`null`)
	}
	buf.WriteByte(',')
	if mj.AggregateDefaultQPS != nil {
		if true {
			buf.WriteString(`"aggregate_default_qps":`)
			fflib.AppendFloat(buf, float64(*mj.AggregateDefaultQPS), 'g', -1, 64)
			buf.WriteByte(',')
		}
	}
	if mj.AggregateDefaultCapacity != nil {
		if true {
			buf.WriteString(`"aggregate_default_capacity":`)
			fflib.FormatBits2(buf, uint64(*mj.AggregateDefaultCapacity), 10, false)
			buf.WriteByte(',')
		}
	}
	buf.Rewind(1)
	buf.WriteByte('}')
	return nil
}

const (
	ffj_t_RateLimitsbase = iota
	ffj_t_RateLimitsno_such_key

	ffj_t_RateLimits_Limits

	ffj_t_RateLimits_AggregateDefaultQPS

	ffj_t_RateLimits_AggregateDefaultCapacity
)

var ffj_key_RateLimits_Limits = []byte("limits")

var ffj_key_RateLimits_AggregateDefaultQPS = []byte("aggregate_default_qps")

var ffj_key_RateLimits_AggregateDefaultCapacity = []byte("aggregate_default_capacity")

func (uj *RateLimits) UnmarshalJSON(input []byte) error {
	fs := fflib.NewFFLexer(input)
	return uj.UnmarshalJSONFFLexer(fs, fflib.FFParse_map_start)
}

func (uj *RateLimits) UnmarshalJSONFFLexer(fs *fflib.FFLexer, state fflib.FFParseState) error {
	var err error = nil
	currentKey := ffj_t_RateLimitsbase
	_ = currentKey
	tok := fflib.FFTok_init
	wantedTok := fflib.FFTok_init

mainparse:
	for {
		tok = fs.Scan()
		//	println(fmt.Sprintf("debug: tok: %v  state: %v", tok, state))
		if tok == fflib.FFTok_error {
			goto tokerror
		}

		switch state {

		case fflib.FFParse_map_start:
			if tok != fflib.FFTok_left_bracket {
				wantedTok = fflib.FFTok_left_bracket
				goto wrongtokenerror
			}
			state = fflib.FFParse_want_key
			continue

		case fflib.FFParse_after_value:
			if tok == fflib.FFTok_comma {
				state = fflib.FFParse_want_key
			} else if tok == fflib.FFTok_right_bracket {
				goto done
			} else {
				wantedTok = fflib.FFTok_comma
				goto wrongtokenerror
			}

		case fflib.FFParse_want_key:
			// json {} ended. goto exit. woo.
			if tok == fflib.FFTok_right_bracket {
				goto done
			}
			if tok != fflib.FFTok_string {
				wantedTok = fflib.FFTok_string
				goto wrongtokenerror
			}

			kn := fs.Output.Bytes()
			if len(kn) <= 0 {
				// "" case. hrm.
				currentKey = ffj_t_RateLimitsno_such_key
				state = fflib.FFParse_want_colon
				goto mainparse
			} else {
				switch kn[0] {

				case 'a':

					if bytes.Equal(ffj_key_RateLimits_AggregateDefaultQPS, kn) {
						currentKey = ffj_t_RateLimits_AggregateDefaultQPS
						state = fflib.FFParse_want_colon
						goto mainparse

					} else if bytes.Equal(ffj_key_RateLimits_AggregateDefaultCapacity, kn) {
						currentKey = ffj_t_RateLimits_AggregateDefaultCapacity
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				case 'l':

					if bytes.Equal(ffj_key_RateLimits_Limits, kn) {
						currentKey = ffj_t_RateLimits_Limits
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				}

				if fflib.AsciiEqualFold(ffj_key_RateLimits_AggregateDefaultCapacity, kn) {
					currentKey = ffj_t_RateLimits_AggregateDefaultCapacity
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffj_key_RateLimits_AggregateDefaultQPS, kn) {
					currentKey = ffj_t_RateLimits_AggregateDefaultQPS
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffj_key_RateLimits_Limits, kn) {
					currentKey = ffj_t_RateLimits_Limits
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				currentKey = ffj_t_RateLimitsno_such_key
				state = fflib.FFParse_want_colon
				goto mainparse
			}

		case fflib.FFParse_want_colon:
			if tok != fflib.FFTok_colon {
				wantedTok = fflib.FFTok_colon
				goto wrongtokenerror
			}
			state = fflib.FFParse_want_value
			continue
		case fflib.FFParse_want_value:

			if tok == fflib.FFTok_left_brace || tok == fflib.FFTok_left_bracket || tok == fflib.FFTok_integer || tok == fflib.FFTok_double || tok == fflib.FFTok_string || tok == fflib.FFTok_bool || tok == fflib.FFTok_null {
				switch currentKey {

				case ffj_t_RateLimits_Limits:
					goto handle_Limits

				case ffj_t_RateLimits_AggregateDefaultQPS:
					goto handle_AggregateDefaultQPS

				case ffj_t_RateLimits_AggregateDefaultCapacity:
					goto handle_AggregateDefaultCapacity

				case ffj_t_RateLimitsno_such_key:
					err = fs.SkipField(tok)
					if err != nil {
						return fs.WrapErr(err)
					}
					state = fflib.FFParse_after_value
					goto mainparse
				}
			} else {
				goto wantedvalue
			}
		}
	}

handle_Limits:

	/* handler: uj.Limits type=[]mesos.RateLimit kind=slice quoted=false*/

	{

		{
			if tok != fflib.FFTok_left_brace && tok != fflib.FFTok_null {
				return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for ", tok))
			}
		}

		if tok == fflib.FFTok_null {
			uj.Limits = nil
		} else {

			uj.Limits = []RateLimit{}

			wantVal := true

			for {

				var tmp_uj__Limits RateLimit

				tok = fs.Scan()
				if tok == fflib.FFTok_error {
					goto tokerror
				}
				if tok == fflib.FFTok_right_brace {
					break
				}

				if tok == fflib.FFTok_comma {
					if wantVal == true {
						// TODO(pquerna): this isn't an ideal error message, this handles
						// things like [,,,] as an array value.
						return fs.WrapErr(fmt.Errorf("wanted value token, but got token: %v", tok))
					}
					continue
				} else {
					wantVal = true
				}

				/* handler: tmp_uj__Limits type=mesos.RateLimit kind=struct quoted=false*/

				{
					if tok == fflib.FFTok_null {

						state = fflib.FFParse_after_value
						goto mainparse
					}

					err = tmp_uj__Limits.UnmarshalJSONFFLexer(fs, fflib.FFParse_want_key)
					if err != nil {
						return err
					}
					state = fflib.FFParse_after_value
				}

				uj.Limits = append(uj.Limits, tmp_uj__Limits)

				wantVal = false
			}
		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_AggregateDefaultQPS:

	/* handler: uj.AggregateDefaultQPS type=float64 kind=float64 quoted=false*/

	{
		if tok != fflib.FFTok_double && tok != fflib.FFTok_integer && tok != fflib.FFTok_null {
			return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for float64", tok))
		}
	}

	{

		if tok == fflib.FFTok_null {

			uj.AggregateDefaultQPS = nil

		} else {

			tval, err := fflib.ParseFloat(fs.Output.Bytes(), 64)

			if err != nil {
				return fs.WrapErr(err)
			}

			ttypval := float64(tval)
			uj.AggregateDefaultQPS = &ttypval

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_AggregateDefaultCapacity:

	/* handler: uj.AggregateDefaultCapacity type=uint64 kind=uint64 quoted=false*/

	{
		if tok != fflib.FFTok_integer && tok != fflib.FFTok_null {
			return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for uint64", tok))
		}
	}

	{

		if tok == fflib.FFTok_null {

			uj.AggregateDefaultCapacity = nil

		} else {

			tval, err := fflib.ParseUint(fs.Output.Bytes(), 10, 64)

			if err != nil {
				return fs.WrapErr(err)
			}

			ttypval := uint64(tval)
			uj.AggregateDefaultCapacity = &ttypval

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

wantedvalue:
	return fs.WrapErr(fmt.Errorf("wanted value token, but got token: %v", tok))
wrongtokenerror:
	return fs.WrapErr(fmt.Errorf("ffjson: wanted token: %v, but got token: %v output=%s", wantedTok, tok, fs.Output.String()))
tokerror:
	if fs.BigError != nil {
		return fs.WrapErr(fs.BigError)
	}
	err = fs.Error.ToError()
	if err != nil {
		return fs.WrapErr(err)
	}
	panic("ffjson-generated: unreachable, please report bug.")
done:

	return nil
}

func (mj *Request) MarshalJSON() ([]byte, error) {
	var buf fflib.Buffer
	if mj == nil {
		buf.WriteString("null")
		return buf.Bytes(), nil
	}
	err := mj.MarshalJSONBuf(&buf)
	if err != nil {
		return nil, err
	}
	return buf.Bytes(), nil
}
func (mj *Request) MarshalJSONBuf(buf fflib.EncodingBuffer) error {
	if mj == nil {
		buf.WriteString("null")
		return nil
	}
	var err error
	var obj []byte
	_ = obj
	_ = err
	buf.WriteByte('{')
	if mj.AgentID != nil {
		if true {
			buf.WriteString(`"agent_id":`)

			{

				err = mj.AgentID.MarshalJSONBuf(buf)
				if err != nil {
					return err
				}

			}
			buf.WriteByte(',')
		}
	}
	buf.WriteString(`"resources":`)
	if mj.Resources != nil {
		buf.WriteString(`[`)
		for i, v := range mj.Resources {
			if i != 0 {
				buf.WriteString(`,`)
			}

			{

				err = v.MarshalJSONBuf(buf)
				if err != nil {
					return err
				}

			}
		}
		buf.WriteString(`]`)
	} else {
		buf.WriteString(`null`)
	}
	buf.WriteByte('}')
	return nil
}

const (
	ffj_t_Requestbase = iota
	ffj_t_Requestno_such_key

	ffj_t_Request_AgentID

	ffj_t_Request_Resources
)

var ffj_key_Request_AgentID = []byte("agent_id")

var ffj_key_Request_Resources = []byte("resources")

func (uj *Request) UnmarshalJSON(input []byte) error {
	fs := fflib.NewFFLexer(input)
	return uj.UnmarshalJSONFFLexer(fs, fflib.FFParse_map_start)
}

func (uj *Request) UnmarshalJSONFFLexer(fs *fflib.FFLexer, state fflib.FFParseState) error {
	var err error = nil
	currentKey := ffj_t_Requestbase
	_ = currentKey
	tok := fflib.FFTok_init
	wantedTok := fflib.FFTok_init

mainparse:
	for {
		tok = fs.Scan()
		//	println(fmt.Sprintf("debug: tok: %v  state: %v", tok, state))
		if tok == fflib.FFTok_error {
			goto tokerror
		}

		switch state {

		case fflib.FFParse_map_start:
			if tok != fflib.FFTok_left_bracket {
				wantedTok = fflib.FFTok_left_bracket
				goto wrongtokenerror
			}
			state = fflib.FFParse_want_key
			continue

		case fflib.FFParse_after_value:
			if tok == fflib.FFTok_comma {
				state = fflib.FFParse_want_key
			} else if tok == fflib.FFTok_right_bracket {
				goto done
			} else {
				wantedTok = fflib.FFTok_comma
				goto wrongtokenerror
			}

		case fflib.FFParse_want_key:
			// json {} ended. goto exit. woo.
			if tok == fflib.FFTok_right_bracket {
				goto done
			}
			if tok != fflib.FFTok_string {
				wantedTok = fflib.FFTok_string
				goto wrongtokenerror
			}

			kn := fs.Output.Bytes()
			if len(kn) <= 0 {
				// "" case. hrm.
				currentKey = ffj_t_Requestno_such_key
				state = fflib.FFParse_want_colon
				goto mainparse
			} else {
				switch kn[0] {

				case 'a':

					if bytes.Equal(ffj_key_Request_AgentID, kn) {
						currentKey = ffj_t_Request_AgentID
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				case 'r':

					if bytes.Equal(ffj_key_Request_Resources, kn) {
						currentKey = ffj_t_Request_Resources
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				}

				if fflib.EqualFoldRight(ffj_key_Request_Resources, kn) {
					currentKey = ffj_t_Request_Resources
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.AsciiEqualFold(ffj_key_Request_AgentID, kn) {
					currentKey = ffj_t_Request_AgentID
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				currentKey = ffj_t_Requestno_such_key
				state = fflib.FFParse_want_colon
				goto mainparse
			}

		case fflib.FFParse_want_colon:
			if tok != fflib.FFTok_colon {
				wantedTok = fflib.FFTok_colon
				goto wrongtokenerror
			}
			state = fflib.FFParse_want_value
			continue
		case fflib.FFParse_want_value:

			if tok == fflib.FFTok_left_brace || tok == fflib.FFTok_left_bracket || tok == fflib.FFTok_integer || tok == fflib.FFTok_double || tok == fflib.FFTok_string || tok == fflib.FFTok_bool || tok == fflib.FFTok_null {
				switch currentKey {

				case ffj_t_Request_AgentID:
					goto handle_AgentID

				case ffj_t_Request_Resources:
					goto handle_Resources

				case ffj_t_Requestno_such_key:
					err = fs.SkipField(tok)
					if err != nil {
						return fs.WrapErr(err)
					}
					state = fflib.FFParse_after_value
					goto mainparse
				}
			} else {
				goto wantedvalue
			}
		}
	}

handle_AgentID:

	/* handler: uj.AgentID type=mesos.AgentID kind=struct quoted=false*/

	{
		if tok == fflib.FFTok_null {

			uj.AgentID = nil

			state = fflib.FFParse_after_value
			goto mainparse
		}

		if uj.AgentID == nil {
			uj.AgentID = new(AgentID)
		}

		err = uj.AgentID.UnmarshalJSONFFLexer(fs, fflib.FFParse_want_key)
		if err != nil {
			return err
		}
		state = fflib.FFParse_after_value
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_Resources:

	/* handler: uj.Resources type=[]mesos.Resource kind=slice quoted=false*/

	{

		{
			if tok != fflib.FFTok_left_brace && tok != fflib.FFTok_null {
				return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for ", tok))
			}
		}

		if tok == fflib.FFTok_null {
			uj.Resources = nil
		} else {

			uj.Resources = []Resource{}

			wantVal := true

			for {

				var tmp_uj__Resources Resource

				tok = fs.Scan()
				if tok == fflib.FFTok_error {
					goto tokerror
				}
				if tok == fflib.FFTok_right_brace {
					break
				}

				if tok == fflib.FFTok_comma {
					if wantVal == true {
						// TODO(pquerna): this isn't an ideal error message, this handles
						// things like [,,,] as an array value.
						return fs.WrapErr(fmt.Errorf("wanted value token, but got token: %v", tok))
					}
					continue
				} else {
					wantVal = true
				}

				/* handler: tmp_uj__Resources type=mesos.Resource kind=struct quoted=false*/

				{
					if tok == fflib.FFTok_null {

						state = fflib.FFParse_after_value
						goto mainparse
					}

					err = tmp_uj__Resources.UnmarshalJSONFFLexer(fs, fflib.FFParse_want_key)
					if err != nil {
						return err
					}
					state = fflib.FFParse_after_value
				}

				uj.Resources = append(uj.Resources, tmp_uj__Resources)

				wantVal = false
			}
		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

wantedvalue:
	return fs.WrapErr(fmt.Errorf("wanted value token, but got token: %v", tok))
wrongtokenerror:
	return fs.WrapErr(fmt.Errorf("ffjson: wanted token: %v, but got token: %v output=%s", wantedTok, tok, fs.Output.String()))
tokerror:
	if fs.BigError != nil {
		return fs.WrapErr(fs.BigError)
	}
	err = fs.Error.ToError()
	if err != nil {
		return fs.WrapErr(err)
	}
	panic("ffjson-generated: unreachable, please report bug.")
done:

	return nil
}

func (mj *Resource) MarshalJSON() ([]byte, error) {
	var buf fflib.Buffer
	if mj == nil {
		buf.WriteString("null")
		return buf.Bytes(), nil
	}
	err := mj.MarshalJSONBuf(&buf)
	if err != nil {
		return nil, err
	}
	return buf.Bytes(), nil
}
func (mj *Resource) MarshalJSONBuf(buf fflib.EncodingBuffer) error {
	if mj == nil {
		buf.WriteString("null")
		return nil
	}
	var err error
	var obj []byte
	_ = obj
	_ = err
	buf.WriteString(`{ `)
	if mj.ProviderID != nil {
		if true {
			buf.WriteString(`"provider_id":`)

			{

				err = mj.ProviderID.MarshalJSONBuf(buf)
				if err != nil {
					return err
				}

			}
			buf.WriteByte(',')
		}
	}
	buf.WriteString(`"name":`)
	fflib.WriteJsonString(buf, string(mj.Name))
	buf.WriteByte(',')
	if mj.Type != nil {
		if true {
			buf.WriteString(`"type":`)

			{

				obj, err = mj.Type.MarshalJSON()
				if err != nil {
					return err
				}
				buf.Write(obj)

			}
			buf.WriteByte(',')
		}
	}
	if mj.Scalar != nil {
		if true {
			buf.WriteString(`"scalar":`)

			{

				err = mj.Scalar.MarshalJSONBuf(buf)
				if err != nil {
					return err
				}

			}
			buf.WriteByte(',')
		}
	}
	if mj.Ranges != nil {
		if true {
			buf.WriteString(`"ranges":`)

			{

				err = mj.Ranges.MarshalJSONBuf(buf)
				if err != nil {
					return err
				}

			}
			buf.WriteByte(',')
		}
	}
	if mj.Set != nil {
		if true {
			buf.WriteString(`"set":`)

			{

				err = mj.Set.MarshalJSONBuf(buf)
				if err != nil {
					return err
				}

			}
			buf.WriteByte(',')
		}
	}
	if mj.Role != nil {
		if true {
			buf.WriteString(`"role":`)
			fflib.WriteJsonString(buf, string(*mj.Role))
			buf.WriteByte(',')
		}
	}
	if mj.AllocationInfo != nil {
		if true {
			buf.WriteString(`"allocation_info":`)

			{

				err = mj.AllocationInfo.MarshalJSONBuf(buf)
				if err != nil {
					return err
				}

			}
			buf.WriteByte(',')
		}
	}
	if mj.Reservation != nil {
		if true {
			buf.WriteString(`"reservation":`)

			{

				err = mj.Reservation.MarshalJSONBuf(buf)
				if err != nil {
					return err
				}

			}
			buf.WriteByte(',')
		}
	}
	buf.WriteString(`"reservations":`)
	if mj.Reservations != nil {
		buf.WriteString(`[`)
		for i, v := range mj.Reservations {
			if i != 0 {
				buf.WriteString(`,`)
			}

			{

				err = v.MarshalJSONBuf(buf)
				if err != nil {
					return err
				}

			}
		}
		buf.WriteString(`]`)
	} else {
		buf.WriteString(`null`)
	}
	buf.WriteByte(',')
	if mj.Disk != nil {
		if true {
			buf.WriteString(`"disk":`)

			{

				err = mj.Disk.MarshalJSONBuf(buf)
				if err != nil {
					return err
				}

			}
			buf.WriteByte(',')
		}
	}
	if mj.Revocable != nil {
		if true {
			buf.WriteString(`"revocable":`)

			{

				err = mj.Revocable.MarshalJSONBuf(buf)
				if err != nil {
					return err
				}

			}
			buf.WriteByte(',')
		}
	}
	if mj.Shared != nil {
		if true {
			buf.WriteString(`"shared":`)

			{

				err = mj.Shared.MarshalJSONBuf(buf)
				if err != nil {
					return err
				}

			}
			buf.WriteByte(',')
		}
	}
	buf.Rewind(1)
	buf.WriteByte('}')
	return nil
}

const (
	ffj_t_Resourcebase = iota
	ffj_t_Resourceno_such_key

	ffj_t_Resource_ProviderID

	ffj_t_Resource_Name

	ffj_t_Resource_Type

	ffj_t_Resource_Scalar

	ffj_t_Resource_Ranges

	ffj_t_Resource_Set

	ffj_t_Resource_Role

	ffj_t_Resource_AllocationInfo

	ffj_t_Resource_Reservation

	ffj_t_Resource_Reservations

	ffj_t_Resource_Disk

	ffj_t_Resource_Revocable

	ffj_t_Resource_Shared
)

var ffj_key_Resource_ProviderID = []byte("provider_id")

var ffj_key_Resource_Name = []byte("name")

var ffj_key_Resource_Type = []byte("type")

var ffj_key_Resource_Scalar = []byte("scalar")

var ffj_key_Resource_Ranges = []byte("ranges")

var ffj_key_Resource_Set = []byte("set")

var ffj_key_Resource_Role = []byte("role")

var ffj_key_Resource_AllocationInfo = []byte("allocation_info")

var ffj_key_Resource_Reservation = []byte("reservation")

var ffj_key_Resource_Reservations = []byte("reservations")

var ffj_key_Resource_Disk = []byte("disk")

var ffj_key_Resource_Revocable = []byte("revocable")

var ffj_key_Resource_Shared = []byte("shared")

func (uj *Resource) UnmarshalJSON(input []byte) error {
	fs := fflib.NewFFLexer(input)
	return uj.UnmarshalJSONFFLexer(fs, fflib.FFParse_map_start)
}

func (uj *Resource) UnmarshalJSONFFLexer(fs *fflib.FFLexer, state fflib.FFParseState) error {
	var err error = nil
	currentKey := ffj_t_Resourcebase
	_ = currentKey
	tok := fflib.FFTok_init
	wantedTok := fflib.FFTok_init

mainparse:
	for {
		tok = fs.Scan()
		//	println(fmt.Sprintf("debug: tok: %v  state: %v", tok, state))
		if tok == fflib.FFTok_error {
			goto tokerror
		}

		switch state {

		case fflib.FFParse_map_start:
			if tok != fflib.FFTok_left_bracket {
				wantedTok = fflib.FFTok_left_bracket
				goto wrongtokenerror
			}
			state = fflib.FFParse_want_key
			continue

		case fflib.FFParse_after_value:
			if tok == fflib.FFTok_comma {
				state = fflib.FFParse_want_key
			} else if tok == fflib.FFTok_right_bracket {
				goto done
			} else {
				wantedTok = fflib.FFTok_comma
				goto wrongtokenerror
			}

		case fflib.FFParse_want_key:
			// json {} ended. goto exit. woo.
			if tok == fflib.FFTok_right_bracket {
				goto done
			}
			if tok != fflib.FFTok_string {
				wantedTok = fflib.FFTok_string
				goto wrongtokenerror
			}

			kn := fs.Output.Bytes()
			if len(kn) <= 0 {
				// "" case. hrm.
				currentKey = ffj_t_Resourceno_such_key
				state = fflib.FFParse_want_colon
				goto mainparse
			} else {
				switch kn[0] {

				case 'a':

					if bytes.Equal(ffj_key_Resource_AllocationInfo, kn) {
						currentKey = ffj_t_Resource_AllocationInfo
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				case 'd':

					if bytes.Equal(ffj_key_Resource_Disk, kn) {
						currentKey = ffj_t_Resource_Disk
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				case 'n':

					if bytes.Equal(ffj_key_Resource_Name, kn) {
						currentKey = ffj_t_Resource_Name
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				case 'p':

					if bytes.Equal(ffj_key_Resource_ProviderID, kn) {
						currentKey = ffj_t_Resource_ProviderID
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				case 'r':

					if bytes.Equal(ffj_key_Resource_Ranges, kn) {
						currentKey = ffj_t_Resource_Ranges
						state = fflib.FFParse_want_colon
						goto mainparse

					} else if bytes.Equal(ffj_key_Resource_Role, kn) {
						currentKey = ffj_t_Resource_Role
						state = fflib.FFParse_want_colon
						goto mainparse

					} else if bytes.Equal(ffj_key_Resource_Reservation, kn) {
						currentKey = ffj_t_Resource_Reservation
						state = fflib.FFParse_want_colon
						goto mainparse

					} else if bytes.Equal(ffj_key_Resource_Reservations, kn) {
						currentKey = ffj_t_Resource_Reservations
						state = fflib.FFParse_want_colon
						goto mainparse

					} else if bytes.Equal(ffj_key_Resource_Revocable, kn) {
						currentKey = ffj_t_Resource_Revocable
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				case 's':

					if bytes.Equal(ffj_key_Resource_Scalar, kn) {
						currentKey = ffj_t_Resource_Scalar
						state = fflib.FFParse_want_colon
						goto mainparse

					} else if bytes.Equal(ffj_key_Resource_Set, kn) {
						currentKey = ffj_t_Resource_Set
						state = fflib.FFParse_want_colon
						goto mainparse

					} else if bytes.Equal(ffj_key_Resource_Shared, kn) {
						currentKey = ffj_t_Resource_Shared
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				case 't':

					if bytes.Equal(ffj_key_Resource_Type, kn) {
						currentKey = ffj_t_Resource_Type
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				}

				if fflib.EqualFoldRight(ffj_key_Resource_Shared, kn) {
					currentKey = ffj_t_Resource_Shared
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.SimpleLetterEqualFold(ffj_key_Resource_Revocable, kn) {
					currentKey = ffj_t_Resource_Revocable
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffj_key_Resource_Disk, kn) {
					currentKey = ffj_t_Resource_Disk
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffj_key_Resource_Reservations, kn) {
					currentKey = ffj_t_Resource_Reservations
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffj_key_Resource_Reservation, kn) {
					currentKey = ffj_t_Resource_Reservation
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.AsciiEqualFold(ffj_key_Resource_AllocationInfo, kn) {
					currentKey = ffj_t_Resource_AllocationInfo
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.SimpleLetterEqualFold(ffj_key_Resource_Role, kn) {
					currentKey = ffj_t_Resource_Role
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffj_key_Resource_Set, kn) {
					currentKey = ffj_t_Resource_Set
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffj_key_Resource_Ranges, kn) {
					currentKey = ffj_t_Resource_Ranges
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffj_key_Resource_Scalar, kn) {
					currentKey = ffj_t_Resource_Scalar
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.SimpleLetterEqualFold(ffj_key_Resource_Type, kn) {
					currentKey = ffj_t_Resource_Type
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.SimpleLetterEqualFold(ffj_key_Resource_Name, kn) {
					currentKey = ffj_t_Resource_Name
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.AsciiEqualFold(ffj_key_Resource_ProviderID, kn) {
					currentKey = ffj_t_Resource_ProviderID
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				currentKey = ffj_t_Resourceno_such_key
				state = fflib.FFParse_want_colon
				goto mainparse
			}

		case fflib.FFParse_want_colon:
			if tok != fflib.FFTok_colon {
				wantedTok = fflib.FFTok_colon
				goto wrongtokenerror
			}
			state = fflib.FFParse_want_value
			continue
		case fflib.FFParse_want_value:

			if tok == fflib.FFTok_left_brace || tok == fflib.FFTok_left_bracket || tok == fflib.FFTok_integer || tok == fflib.FFTok_double || tok == fflib.FFTok_string || tok == fflib.FFTok_bool || tok == fflib.FFTok_null {
				switch currentKey {

				case ffj_t_Resource_ProviderID:
					goto handle_ProviderID

				case ffj_t_Resource_Name:
					goto handle_Name

				case ffj_t_Resource_Type:
					goto handle_Type

				case ffj_t_Resource_Scalar:
					goto handle_Scalar

				case ffj_t_Resource_Ranges:
					goto handle_Ranges

				case ffj_t_Resource_Set:
					goto handle_Set

				case ffj_t_Resource_Role:
					goto handle_Role

				case ffj_t_Resource_AllocationInfo:
					goto handle_AllocationInfo

				case ffj_t_Resource_Reservation:
					goto handle_Reservation

				case ffj_t_Resource_Reservations:
					goto handle_Reservations

				case ffj_t_Resource_Disk:
					goto handle_Disk

				case ffj_t_Resource_Revocable:
					goto handle_Revocable

				case ffj_t_Resource_Shared:
					goto handle_Shared

				case ffj_t_Resourceno_such_key:
					err = fs.SkipField(tok)
					if err != nil {
						return fs.WrapErr(err)
					}
					state = fflib.FFParse_after_value
					goto mainparse
				}
			} else {
				goto wantedvalue
			}
		}
	}

handle_ProviderID:

	/* handler: uj.ProviderID type=mesos.ResourceProviderID kind=struct quoted=false*/

	{
		if tok == fflib.FFTok_null {

			uj.ProviderID = nil

			state = fflib.FFParse_after_value
			goto mainparse
		}

		if uj.ProviderID == nil {
			uj.ProviderID = new(ResourceProviderID)
		}

		err = uj.ProviderID.UnmarshalJSONFFLexer(fs, fflib.FFParse_want_key)
		if err != nil {
			return err
		}
		state = fflib.FFParse_after_value
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_Name:

	/* handler: uj.Name type=string kind=string quoted=false*/

	{

		{
			if tok != fflib.FFTok_string && tok != fflib.FFTok_null {
				return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for string", tok))
			}
		}

		if tok == fflib.FFTok_null {

		} else {

			outBuf := fs.Output.Bytes()

			uj.Name = string(string(outBuf))

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_Type:

	/* handler: uj.Type type=mesos.Value_Type kind=int32 quoted=false*/

	{
		if tok == fflib.FFTok_null {

			uj.Type = nil

			state = fflib.FFParse_after_value
			goto mainparse
		}

		tbuf, err := fs.CaptureField(tok)
		if err != nil {
			return fs.WrapErr(err)
		}

		if uj.Type == nil {
			uj.Type = new(Value_Type)
		}

		err = uj.Type.UnmarshalJSON(tbuf)
		if err != nil {
			return fs.WrapErr(err)
		}
		state = fflib.FFParse_after_value
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_Scalar:

	/* handler: uj.Scalar type=mesos.Value_Scalar kind=struct quoted=false*/

	{
		if tok == fflib.FFTok_null {

			uj.Scalar = nil

			state = fflib.FFParse_after_value
			goto mainparse
		}

		if uj.Scalar == nil {
			uj.Scalar = new(Value_Scalar)
		}

		err = uj.Scalar.UnmarshalJSONFFLexer(fs, fflib.FFParse_want_key)
		if err != nil {
			return err
		}
		state = fflib.FFParse_after_value
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_Ranges:

	/* handler: uj.Ranges type=mesos.Value_Ranges kind=struct quoted=false*/

	{
		if tok == fflib.FFTok_null {

			uj.Ranges = nil

			state = fflib.FFParse_after_value
			goto mainparse
		}

		if uj.Ranges == nil {
			uj.Ranges = new(Value_Ranges)
		}

		err = uj.Ranges.UnmarshalJSONFFLexer(fs, fflib.FFParse_want_key)
		if err != nil {
			return err
		}
		state = fflib.FFParse_after_value
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_Set:

	/* handler: uj.Set type=mesos.Value_Set kind=struct quoted=false*/

	{
		if tok == fflib.FFTok_null {

			uj.Set = nil

			state = fflib.FFParse_after_value
			goto mainparse
		}

		if uj.Set == nil {
			uj.Set = new(Value_Set)
		}

		err = uj.Set.UnmarshalJSONFFLexer(fs, fflib.FFParse_want_key)
		if err != nil {
			return err
		}
		state = fflib.FFParse_after_value
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_Role:

	/* handler: uj.Role type=string kind=string quoted=false*/

	{

		{
			if tok != fflib.FFTok_string && tok != fflib.FFTok_null {
				return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for string", tok))
			}
		}

		if tok == fflib.FFTok_null {

			uj.Role = nil

		} else {

			var tval string
			outBuf := fs.Output.Bytes()

			tval = string(string(outBuf))
			uj.Role = &tval

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_AllocationInfo:

	/* handler: uj.AllocationInfo type=mesos.Resource_AllocationInfo kind=struct quoted=false*/

	{
		if tok == fflib.FFTok_null {

			uj.AllocationInfo = nil

			state = fflib.FFParse_after_value
			goto mainparse
		}

		if uj.AllocationInfo == nil {
			uj.AllocationInfo = new(Resource_AllocationInfo)
		}

		err = uj.AllocationInfo.UnmarshalJSONFFLexer(fs, fflib.FFParse_want_key)
		if err != nil {
			return err
		}
		state = fflib.FFParse_after_value
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_Reservation:

	/* handler: uj.Reservation type=mesos.Resource_ReservationInfo kind=struct quoted=false*/

	{
		if tok == fflib.FFTok_null {

			uj.Reservation = nil

			state = fflib.FFParse_after_value
			goto mainparse
		}

		if uj.Reservation == nil {
			uj.Reservation = new(Resource_ReservationInfo)
		}

		err = uj.Reservation.UnmarshalJSONFFLexer(fs, fflib.FFParse_want_key)
		if err != nil {
			return err
		}
		state = fflib.FFParse_after_value
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_Reservations:

	/* handler: uj.Reservations type=[]mesos.Resource_ReservationInfo kind=slice quoted=false*/

	{

		{
			if tok != fflib.FFTok_left_brace && tok != fflib.FFTok_null {
				return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for ", tok))
			}
		}

		if tok == fflib.FFTok_null {
			uj.Reservations = nil
		} else {

			uj.Reservations = []Resource_ReservationInfo{}

			wantVal := true

			for {

				var tmp_uj__Reservations Resource_ReservationInfo

				tok = fs.Scan()
				if tok == fflib.FFTok_error {
					goto tokerror
				}
				if tok == fflib.FFTok_right_brace {
					break
				}

				if tok == fflib.FFTok_comma {
					if wantVal == true {
						// TODO(pquerna): this isn't an ideal error message, this handles
						// things like [,,,] as an array value.
						return fs.WrapErr(fmt.Errorf("wanted value token, but got token: %v", tok))
					}
					continue
				} else {
					wantVal = true
				}

				/* handler: tmp_uj__Reservations type=mesos.Resource_ReservationInfo kind=struct quoted=false*/

				{
					if tok == fflib.FFTok_null {

						state = fflib.FFParse_after_value
						goto mainparse
					}

					err = tmp_uj__Reservations.UnmarshalJSONFFLexer(fs, fflib.FFParse_want_key)
					if err != nil {
						return err
					}
					state = fflib.FFParse_after_value
				}

				uj.Reservations = append(uj.Reservations, tmp_uj__Reservations)

				wantVal = false
			}
		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_Disk:

	/* handler: uj.Disk type=mesos.Resource_DiskInfo kind=struct quoted=false*/

	{
		if tok == fflib.FFTok_null {

			uj.Disk = nil

			state = fflib.FFParse_after_value
			goto mainparse
		}

		if uj.Disk == nil {
			uj.Disk = new(Resource_DiskInfo)
		}

		err = uj.Disk.UnmarshalJSONFFLexer(fs, fflib.FFParse_want_key)
		if err != nil {
			return err
		}
		state = fflib.FFParse_after_value
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_Revocable:

	/* handler: uj.Revocable type=mesos.Resource_RevocableInfo kind=struct quoted=false*/

	{
		if tok == fflib.FFTok_null {

			uj.Revocable = nil

			state = fflib.FFParse_after_value
			goto mainparse
		}

		if uj.Revocable == nil {
			uj.Revocable = new(Resource_RevocableInfo)
		}

		err = uj.Revocable.UnmarshalJSONFFLexer(fs, fflib.FFParse_want_key)
		if err != nil {
			return err
		}
		state = fflib.FFParse_after_value
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_Shared:

	/* handler: uj.Shared type=mesos.Resource_SharedInfo kind=struct quoted=false*/

	{
		if tok == fflib.FFTok_null {

			uj.Shared = nil

			state = fflib.FFParse_after_value
			goto mainparse
		}

		if uj.Shared == nil {
			uj.Shared = new(Resource_SharedInfo)
		}

		err = uj.Shared.UnmarshalJSONFFLexer(fs, fflib.FFParse_want_key)
		if err != nil {
			return err
		}
		state = fflib.FFParse_after_value
	}

	state = fflib.FFParse_after_value
	goto mainparse

wantedvalue:
	return fs.WrapErr(fmt.Errorf("wanted value token, but got token: %v", tok))
wrongtokenerror:
	return fs.WrapErr(fmt.Errorf("ffjson: wanted token: %v, but got token: %v output=%s", wantedTok, tok, fs.Output.String()))
tokerror:
	if fs.BigError != nil {
		return fs.WrapErr(fs.BigError)
	}
	err = fs.Error.ToError()
	if err != nil {
		return fs.WrapErr(err)
	}
	panic("ffjson-generated: unreachable, please report bug.")
done:

	return nil
}

func (mj *ResourceProviderID) MarshalJSON() ([]byte, error) {
	var buf fflib.Buffer
	if mj == nil {
		buf.WriteString("null")
		return buf.Bytes(), nil
	}
	err := mj.MarshalJSONBuf(&buf)
	if err != nil {
		return nil, err
	}
	return buf.Bytes(), nil
}
func (mj *ResourceProviderID) MarshalJSONBuf(buf fflib.EncodingBuffer) error {
	if mj == nil {
		buf.WriteString("null")
		return nil
	}
	var err error
	var obj []byte
	_ = obj
	_ = err
	buf.WriteString(`{"value":`)
	fflib.WriteJsonString(buf, string(mj.Value))
	buf.WriteByte('}')
	return nil
}

const (
	ffj_t_ResourceProviderIDbase = iota
	ffj_t_ResourceProviderIDno_such_key

	ffj_t_ResourceProviderID_Value
)

var ffj_key_ResourceProviderID_Value = []byte("value")

func (uj *ResourceProviderID) UnmarshalJSON(input []byte) error {
	fs := fflib.NewFFLexer(input)
	return uj.UnmarshalJSONFFLexer(fs, fflib.FFParse_map_start)
}

func (uj *ResourceProviderID) UnmarshalJSONFFLexer(fs *fflib.FFLexer, state fflib.FFParseState) error {
	var err error = nil
	currentKey := ffj_t_ResourceProviderIDbase
	_ = currentKey
	tok := fflib.FFTok_init
	wantedTok := fflib.FFTok_init

mainparse:
	for {
		tok = fs.Scan()
		//	println(fmt.Sprintf("debug: tok: %v  state: %v", tok, state))
		if tok == fflib.FFTok_error {
			goto tokerror
		}

		switch state {

		case fflib.FFParse_map_start:
			if tok != fflib.FFTok_left_bracket {
				wantedTok = fflib.FFTok_left_bracket
				goto wrongtokenerror
			}
			state = fflib.FFParse_want_key
			continue

		case fflib.FFParse_after_value:
			if tok == fflib.FFTok_comma {
				state = fflib.FFParse_want_key
			} else if tok == fflib.FFTok_right_bracket {
				goto done
			} else {
				wantedTok = fflib.FFTok_comma
				goto wrongtokenerror
			}

		case fflib.FFParse_want_key:
			// json {} ended. goto exit. woo.
			if tok == fflib.FFTok_right_bracket {
				goto done
			}
			if tok != fflib.FFTok_string {
				wantedTok = fflib.FFTok_string
				goto wrongtokenerror
			}

			kn := fs.Output.Bytes()
			if len(kn) <= 0 {
				// "" case. hrm.
				currentKey = ffj_t_ResourceProviderIDno_such_key
				state = fflib.FFParse_want_colon
				goto mainparse
			} else {
				switch kn[0] {

				case 'v':

					if bytes.Equal(ffj_key_ResourceProviderID_Value, kn) {
						currentKey = ffj_t_ResourceProviderID_Value
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				}

				if fflib.SimpleLetterEqualFold(ffj_key_ResourceProviderID_Value, kn) {
					currentKey = ffj_t_ResourceProviderID_Value
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				currentKey = ffj_t_ResourceProviderIDno_such_key
				state = fflib.FFParse_want_colon
				goto mainparse
			}

		case fflib.FFParse_want_colon:
			if tok != fflib.FFTok_colon {
				wantedTok = fflib.FFTok_colon
				goto wrongtokenerror
			}
			state = fflib.FFParse_want_value
			continue
		case fflib.FFParse_want_value:

			if tok == fflib.FFTok_left_brace || tok == fflib.FFTok_left_bracket || tok == fflib.FFTok_integer || tok == fflib.FFTok_double || tok == fflib.FFTok_string || tok == fflib.FFTok_bool || tok == fflib.FFTok_null {
				switch currentKey {

				case ffj_t_ResourceProviderID_Value:
					goto handle_Value

				case ffj_t_ResourceProviderIDno_such_key:
					err = fs.SkipField(tok)
					if err != nil {
						return fs.WrapErr(err)
					}
					state = fflib.FFParse_after_value
					goto mainparse
				}
			} else {
				goto wantedvalue
			}
		}
	}

handle_Value:

	/* handler: uj.Value type=string kind=string quoted=false*/

	{

		{
			if tok != fflib.FFTok_string && tok != fflib.FFTok_null {
				return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for string", tok))
			}
		}

		if tok == fflib.FFTok_null {

		} else {

			outBuf := fs.Output.Bytes()

			uj.Value = string(string(outBuf))

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

wantedvalue:
	return fs.WrapErr(fmt.Errorf("wanted value token, but got token: %v", tok))
wrongtokenerror:
	return fs.WrapErr(fmt.Errorf("ffjson: wanted token: %v, but got token: %v output=%s", wantedTok, tok, fs.Output.String()))
tokerror:
	if fs.BigError != nil {
		return fs.WrapErr(fs.BigError)
	}
	err = fs.Error.ToError()
	if err != nil {
		return fs.WrapErr(err)
	}
	panic("ffjson-generated: unreachable, please report bug.")
done:

	return nil
}

func (mj *ResourceProviderInfo) MarshalJSON() ([]byte, error) {
	var buf fflib.Buffer
	if mj == nil {
		buf.WriteString("null")
		return buf.Bytes(), nil
	}
	err := mj.MarshalJSONBuf(&buf)
	if err != nil {
		return nil, err
	}
	return buf.Bytes(), nil
}
func (mj *ResourceProviderInfo) MarshalJSONBuf(buf fflib.EncodingBuffer) error {
	if mj == nil {
		buf.WriteString("null")
		return nil
	}
	var err error
	var obj []byte
	_ = obj
	_ = err
	buf.WriteString(`{ `)
	if mj.ID != nil {
		if true {
			buf.WriteString(`"id":`)

			{

				err = mj.ID.MarshalJSONBuf(buf)
				if err != nil {
					return err
				}

			}
			buf.WriteByte(',')
		}
	}
	buf.WriteString(`"attributes":`)
	if mj.Attributes != nil {
		buf.WriteString(`[`)
		for i, v := range mj.Attributes {
			if i != 0 {
				buf.WriteString(`,`)
			}

			{

				err = v.MarshalJSONBuf(buf)
				if err != nil {
					return err
				}

			}
		}
		buf.WriteString(`]`)
	} else {
		buf.WriteString(`null`)
	}
	buf.WriteString(`,"type":`)
	fflib.WriteJsonString(buf, string(mj.Type))
	buf.WriteString(`,"name":`)
	fflib.WriteJsonString(buf, string(mj.Name))
	buf.WriteString(`,"default_reservations":`)
	if mj.DefaultReservations != nil {
		buf.WriteString(`[`)
		for i, v := range mj.DefaultReservations {
			if i != 0 {
				buf.WriteString(`,`)
			}

			{

				err = v.MarshalJSONBuf(buf)
				if err != nil {
					return err
				}

			}
		}
		buf.WriteString(`]`)
	} else {
		buf.WriteString(`null`)
	}
	buf.WriteByte(',')
	if mj.Storage != nil {
		if true {
			buf.WriteString(`"storage":`)

			{

				err = mj.Storage.MarshalJSONBuf(buf)
				if err != nil {
					return err
				}

			}
			buf.WriteByte(',')
		}
	}
	buf.Rewind(1)
	buf.WriteByte('}')
	return nil
}

const (
	ffj_t_ResourceProviderInfobase = iota
	ffj_t_ResourceProviderInfono_such_key

	ffj_t_ResourceProviderInfo_ID

	ffj_t_ResourceProviderInfo_Attributes

	ffj_t_ResourceProviderInfo_Type

	ffj_t_ResourceProviderInfo_Name

	ffj_t_ResourceProviderInfo_DefaultReservations

	ffj_t_ResourceProviderInfo_Storage
)

var ffj_key_ResourceProviderInfo_ID = []byte("id")

var ffj_key_ResourceProviderInfo_Attributes = []byte("attributes")

var ffj_key_ResourceProviderInfo_Type = []byte("type")

var ffj_key_ResourceProviderInfo_Name = []byte("name")

var ffj_key_ResourceProviderInfo_DefaultReservations = []byte("default_reservations")

var ffj_key_ResourceProviderInfo_Storage = []byte("storage")

func (uj *ResourceProviderInfo) UnmarshalJSON(input []byte) error {
	fs := fflib.NewFFLexer(input)
	return uj.UnmarshalJSONFFLexer(fs, fflib.FFParse_map_start)
}

func (uj *ResourceProviderInfo) UnmarshalJSONFFLexer(fs *fflib.FFLexer, state fflib.FFParseState) error {
	var err error = nil
	currentKey := ffj_t_ResourceProviderInfobase
	_ = currentKey
	tok := fflib.FFTok_init
	wantedTok := fflib.FFTok_init

mainparse:
	for {
		tok = fs.Scan()
		//	println(fmt.Sprintf("debug: tok: %v  state: %v", tok, state))
		if tok == fflib.FFTok_error {
			goto tokerror
		}

		switch state {

		case fflib.FFParse_map_start:
			if tok != fflib.FFTok_left_bracket {
				wantedTok = fflib.FFTok_left_bracket
				goto wrongtokenerror
			}
			state = fflib.FFParse_want_key
			continue

		case fflib.FFParse_after_value:
			if tok == fflib.FFTok_comma {
				state = fflib.FFParse_want_key
			} else if tok == fflib.FFTok_right_bracket {
				goto done
			} else {
				wantedTok = fflib.FFTok_comma
				goto wrongtokenerror
			}

		case fflib.FFParse_want_key:
			// json {} ended. goto exit. woo.
			if tok == fflib.FFTok_right_bracket {
				goto done
			}
			if tok != fflib.FFTok_string {
				wantedTok = fflib.FFTok_string
				goto wrongtokenerror
			}

			kn := fs.Output.Bytes()
			if len(kn) <= 0 {
				// "" case. hrm.
				currentKey = ffj_t_ResourceProviderInfono_such_key
				state = fflib.FFParse_want_colon
				goto mainparse
			} else {
				switch kn[0] {

				case 'a':

					if bytes.Equal(ffj_key_ResourceProviderInfo_Attributes, kn) {
						currentKey = ffj_t_ResourceProviderInfo_Attributes
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				case 'd':

					if bytes.Equal(ffj_key_ResourceProviderInfo_DefaultReservations, kn) {
						currentKey = ffj_t_ResourceProviderInfo_DefaultReservations
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				case 'i':

					if bytes.Equal(ffj_key_ResourceProviderInfo_ID, kn) {
						currentKey = ffj_t_ResourceProviderInfo_ID
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				case 'n':

					if bytes.Equal(ffj_key_ResourceProviderInfo_Name, kn) {
						currentKey = ffj_t_ResourceProviderInfo_Name
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				case 's':

					if bytes.Equal(ffj_key_ResourceProviderInfo_Storage, kn) {
						currentKey = ffj_t_ResourceProviderInfo_Storage
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				case 't':

					if bytes.Equal(ffj_key_ResourceProviderInfo_Type, kn) {
						currentKey = ffj_t_ResourceProviderInfo_Type
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				}

				if fflib.EqualFoldRight(ffj_key_ResourceProviderInfo_Storage, kn) {
					currentKey = ffj_t_ResourceProviderInfo_Storage
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffj_key_ResourceProviderInfo_DefaultReservations, kn) {
					currentKey = ffj_t_ResourceProviderInfo_DefaultReservations
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.SimpleLetterEqualFold(ffj_key_ResourceProviderInfo_Name, kn) {
					currentKey = ffj_t_ResourceProviderInfo_Name
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.SimpleLetterEqualFold(ffj_key_ResourceProviderInfo_Type, kn) {
					currentKey = ffj_t_ResourceProviderInfo_Type
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.EqualFoldRight(ffj_key_ResourceProviderInfo_Attributes, kn) {
					currentKey = ffj_t_ResourceProviderInfo_Attributes
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.SimpleLetterEqualFold(ffj_key_ResourceProviderInfo_ID, kn) {
					currentKey = ffj_t_ResourceProviderInfo_ID
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				currentKey = ffj_t_ResourceProviderInfono_such_key
				state = fflib.FFParse_want_colon
				goto mainparse
			}

		case fflib.FFParse_want_colon:
			if tok != fflib.FFTok_colon {
				wantedTok = fflib.FFTok_colon
				goto wrongtokenerror
			}
			state = fflib.FFParse_want_value
			continue
		case fflib.FFParse_want_value:

			if tok == fflib.FFTok_left_brace || tok == fflib.FFTok_left_bracket || tok == fflib.FFTok_integer || tok == fflib.FFTok_double || tok == fflib.FFTok_string || tok == fflib.FFTok_bool || tok == fflib.FFTok_null {
				switch currentKey {

				case ffj_t_ResourceProviderInfo_ID:
					goto handle_ID

				case ffj_t_ResourceProviderInfo_Attributes:
					goto handle_Attributes

				case ffj_t_ResourceProviderInfo_Type:
					goto handle_Type

				case ffj_t_ResourceProviderInfo_Name:
					goto handle_Name

				case ffj_t_ResourceProviderInfo_DefaultReservations:
					goto handle_DefaultReservations

				case ffj_t_ResourceProviderInfo_Storage:
					goto handle_Storage

				case ffj_t_ResourceProviderInfono_such_key:
					err = fs.SkipField(tok)
					if err != nil {
						return fs.WrapErr(err)
					}
					state = fflib.FFParse_after_value
					goto mainparse
				}
			} else {
				goto wantedvalue
			}
		}
	}

handle_ID:

	/* handler: uj.ID type=mesos.ResourceProviderID kind=struct quoted=false*/

	{
		if tok == fflib.FFTok_null {

			uj.ID = nil

			state = fflib.FFParse_after_value
			goto mainparse
		}

		if uj.ID == nil {
			uj.ID = new(ResourceProviderID)
		}

		err = uj.ID.UnmarshalJSONFFLexer(fs, fflib.FFParse_want_key)
		if err != nil {
			return err
		}
		state = fflib.FFParse_after_value
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_Attributes:

	/* handler: uj.Attributes type=[]mesos.Attribute kind=slice quoted=false*/

	{

		{
			if tok != fflib.FFTok_left_brace && tok != fflib.FFTok_null {
				return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for ", tok))
			}
		}

		if tok == fflib.FFTok_null {
			uj.Attributes = nil
		} else {

			uj.Attributes = []Attribute{}

			wantVal := true

			for {

				var tmp_uj__Attributes Attribute

				tok = fs.Scan()
				if tok == fflib.FFTok_error {
					goto tokerror
				}
				if tok == fflib.FFTok_right_brace {
					break
				}

				if tok == fflib.FFTok_comma {
					if wantVal == true {
						// TODO(pquerna): this isn't an ideal error message, this handles
						// things like [,,,] as an array value.
						return fs.WrapErr(fmt.Errorf("wanted value token, but got token: %v", tok))
					}
					continue
				} else {
					wantVal = true
				}

				/* handler: tmp_uj__Attributes type=mesos.Attribute kind=struct quoted=false*/

				{
					if tok == fflib.FFTok_null {

						state = fflib.FFParse_after_value
						goto mainparse
					}

					err = tmp_uj__Attributes.UnmarshalJSONFFLexer(fs, fflib.FFParse_want_key)
					if err != nil {
						return err
					}
					state = fflib.FFParse_after_value
				}

				uj.Attributes = append(uj.Attributes, tmp_uj__Attributes)

				wantVal = false
			}
		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_Type:

	/* handler: uj.Type type=string kind=string quoted=false*/

	{

		{
			if tok != fflib.FFTok_string && tok != fflib.FFTok_null {
				return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for string", tok))
			}
		}

		if tok == fflib.FFTok_null {

		} else {

			outBuf := fs.Output.Bytes()

			uj.Type = string(string(outBuf))

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_Name:

	/* handler: uj.Name type=string kind=string quoted=false*/

	{

		{
			if tok != fflib.FFTok_string && tok != fflib.FFTok_null {
				return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for string", tok))
			}
		}

		if tok == fflib.FFTok_null {

		} else {

			outBuf := fs.Output.Bytes()

			uj.Name = string(string(outBuf))

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_DefaultReservations:

	/* handler: uj.DefaultReservations type=[]mesos.Resource_ReservationInfo kind=slice quoted=false*/

	{

		{
			if tok != fflib.FFTok_left_brace && tok != fflib.FFTok_null {
				return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for ", tok))
			}
		}

		if tok == fflib.FFTok_null {
			uj.DefaultReservations = nil
		} else {

			uj.DefaultReservations = []Resource_ReservationInfo{}

			wantVal := true

			for {

				var tmp_uj__DefaultReservations Resource_ReservationInfo

				tok = fs.Scan()
				if tok == fflib.FFTok_error {
					goto tokerror
				}
				if tok == fflib.FFTok_right_brace {
					break
				}

				if tok == fflib.FFTok_comma {
					if wantVal == true {
						// TODO(pquerna): this isn't an ideal error message, this handles
						// things like [,,,] as an array value.
						return fs.WrapErr(fmt.Errorf("wanted value token, but got token: %v", tok))
					}
					continue
				} else {
					wantVal = true
				}

				/* handler: tmp_uj__DefaultReservations type=mesos.Resource_ReservationInfo kind=struct quoted=false*/

				{
					if tok == fflib.FFTok_null {

						state = fflib.FFParse_after_value
						goto mainparse
					}

					err = tmp_uj__DefaultReservations.UnmarshalJSONFFLexer(fs, fflib.FFParse_want_key)
					if err != nil {
						return err
					}
					state = fflib.FFParse_after_value
				}

				uj.DefaultReservations = append(uj.DefaultReservations, tmp_uj__DefaultReservations)

				wantVal = false
			}
		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_Storage:

	/* handler: uj.Storage type=mesos.ResourceProviderInfo_Storage kind=struct quoted=false*/

	{
		if tok == fflib.FFTok_null {

			uj.Storage = nil

			state = fflib.FFParse_after_value
			goto mainparse
		}

		if uj.Storage == nil {
			uj.Storage = new(ResourceProviderInfo_Storage)
		}

		err = uj.Storage.UnmarshalJSONFFLexer(fs, fflib.FFParse_want_key)
		if err != nil {
			return err
		}
		state = fflib.FFParse_after_value
	}

	state = fflib.FFParse_after_value
	goto mainparse

wantedvalue:
	return fs.WrapErr(fmt.Errorf("wanted value token, but got token: %v", tok))
wrongtokenerror:
	return fs.WrapErr(fmt.Errorf("ffjson: wanted token: %v, but got token: %v output=%s", wantedTok, tok, fs.Output.String()))
tokerror:
	if fs.BigError != nil {
		return fs.WrapErr(fs.BigError)
	}
	err = fs.Error.ToError()
	if err != nil {
		return fs.WrapErr(err)
	}
	panic("ffjson-generated: unreachable, please report bug.")
done:

	return nil
}

func (mj *ResourceProviderInfo_Storage) MarshalJSON() ([]byte, error) {
	var buf fflib.Buffer
	if mj == nil {
		buf.WriteString("null")
		return buf.Bytes(), nil
	}
	err := mj.MarshalJSONBuf(&buf)
	if err != nil {
		return nil, err
	}
	return buf.Bytes(), nil
}
func (mj *ResourceProviderInfo_Storage) MarshalJSONBuf(buf fflib.EncodingBuffer) error {
	if mj == nil {
		buf.WriteString("null")
		return nil
	}
	var err error
	var obj []byte
	_ = obj
	_ = err
	buf.WriteString(`{ "plugin":`)

	{

		err = mj.Plugin.MarshalJSONBuf(buf)
		if err != nil {
			return err
		}

	}
	buf.WriteByte(',')
	if mj.ReconciliationIntervalSeconds != nil {
		if true {
			buf.WriteString(`"reconciliation_interval_seconds":`)
			fflib.AppendFloat(buf, float64(*mj.ReconciliationIntervalSeconds), 'g', -1, 64)
			buf.WriteByte(',')
		}
	}
	buf.Rewind(1)
	buf.WriteByte('}')
	return nil
}

const (
	ffj_t_ResourceProviderInfo_Storagebase = iota
	ffj_t_ResourceProviderInfo_Storageno_such_key

	ffj_t_ResourceProviderInfo_Storage_Plugin

	ffj_t_ResourceProviderInfo_Storage_ReconciliationIntervalSeconds
)

var ffj_key_ResourceProviderInfo_Storage_Plugin = []byte("plugin")

var ffj_key_ResourceProviderInfo_Storage_ReconciliationIntervalSeconds = []byte("reconciliation_interval_seconds")

func (uj *ResourceProviderInfo_Storage) UnmarshalJSON(input []byte) error {
	fs := fflib.NewFFLexer(input)
	return uj.UnmarshalJSONFFLexer(fs, fflib.FFParse_map_start)
}

func (uj *ResourceProviderInfo_Storage) UnmarshalJSONFFLexer(fs *fflib.FFLexer, state fflib.FFParseState) error {
	var err error = nil
	currentKey := ffj_t_ResourceProviderInfo_Storagebase
	_ = currentKey
	tok := fflib.FFTok_init
	wantedTok := fflib.FFTok_init

mainparse:
	for {
		tok = fs.Scan()
		//	println(fmt.Sprintf("debug: tok: %v  state: %v", tok, state))
		if tok == fflib.FFTok_error {
			goto tokerror
		}

		switch state {

		case fflib.FFParse_map_start:
			if tok != fflib.FFTok_left_bracket {
				wantedTok = fflib.FFTok_left_bracket
				goto wrongtokenerror
			}
			state = fflib.FFParse_want_key
			continue

		case fflib.FFParse_after_value:
			if tok == fflib.FFTok_comma {
				state = fflib.FFParse_want_key
			} else if tok == fflib.FFTok_right_bracket {
				goto done
			} else {
				wantedTok = fflib.FFTok_comma
				goto wrongtokenerror
			}

		case fflib.FFParse_want_key:
			// json {} ended. goto exit. woo.
			if tok == fflib.FFTok_right_bracket {
				goto done
			}
			if tok != fflib.FFTok_string {
				wantedTok = fflib.FFTok_string
				goto wrongtokenerror
			}

			kn := fs.Output.Bytes()
			if len(kn) <= 0 {
				// "" case. hrm.
				currentKey = ffj_t_ResourceProviderInfo_Storageno_such_key
				state = fflib.FFParse_want_colon
				goto mainparse
			} else {
				switch kn[0] {

				case 'p':

					if bytes.Equal(ffj_key_ResourceProviderInfo_Storage_Plugin, kn) {
						currentKey = ffj_t_ResourceProviderInfo_Storage_Plugin
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				case 'r':

					if bytes.Equal(ffj_key_ResourceProviderInfo_Storage_ReconciliationIntervalSeconds, kn) {
						currentKey = ffj_t_ResourceProviderInfo_Storage_ReconciliationIntervalSeconds
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				}

				if fflib.EqualFoldRight(ffj_key_ResourceProviderInfo_Storage_ReconciliationIntervalSeconds, kn) {
					currentKey = ffj_t_ResourceProviderInfo_Storage_ReconciliationIntervalSeconds
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				if fflib.SimpleLetterEqualFold(ffj_key_ResourceProviderInfo_Storage_Plugin, kn) {
					currentKey = ffj_t_ResourceProviderInfo_Storage_Plugin
					state = fflib.FFParse_want_colon
					goto mainparse
				}

				currentKey = ffj_t_ResourceProviderInfo_Storageno_such_key
				state = fflib.FFParse_want_colon
				goto mainparse
			}

		case fflib.FFParse_want_colon:
			if tok != fflib.FFTok_colon {
				wantedTok = fflib.FFTok_colon
				goto wrongtokenerror
			}
			state = fflib.FFParse_want_value
			continue
		case fflib.FFParse_want_value:

			if tok == fflib.FFTok_left_brace || tok == fflib.FFTok_left_bracket || tok == fflib.FFTok_integer || tok == fflib.FFTok_double || tok == fflib.FFTok_string || tok == fflib.FFTok_bool || tok == fflib.FFTok_null {
				switch currentKey {

				case ffj_t_ResourceProviderInfo_Storage_Plugin:
					goto handle_Plugin

				case ffj_t_ResourceProviderInfo_Storage_ReconciliationIntervalSeconds:
					goto handle_ReconciliationIntervalSeconds

				case ffj_t_ResourceProviderInfo_Storageno_such_key:
					err = fs.SkipField(tok)
					if err != nil {
						return fs.WrapErr(err)
					}
					state = fflib.FFParse_after_value
					goto mainparse
				}
			} else {
				goto wantedvalue
			}
		}
	}

handle_Plugin:

	/* handler: uj.Plugin type=mesos.CSIPluginInfo kind=struct quoted=false*/

	{
		if tok == fflib.FFTok_null {

			state = fflib.FFParse_after_value
			goto mainparse
		}

		err = uj.Plugin.UnmarshalJSONFFLexer(fs, fflib.FFParse_want_key)
		if err != nil {
			return err
		}
		state = fflib.FFParse_after_value
	}

	state = fflib.FFParse_after_value
	goto mainparse

handle_ReconciliationIntervalSeconds:

	/* handler: uj.ReconciliationIntervalSeconds type=float64 kind=float64 quoted=false*/

	{
		if tok != fflib.FFTok_double && tok != fflib.FFTok_integer && tok != fflib.FFTok_null {
			return fs.WrapErr(fmt.Errorf("cannot unmarshal %s into Go value for float64", tok))
		}
	}

	{

		if tok == fflib.FFTok_null {

			uj.ReconciliationIntervalSeconds = nil

		} else {

			tval, err := fflib.ParseFloat(fs.Output.Bytes(), 64)

			if err != nil {
				return fs.WrapErr(err)
			}

			ttypval := float64(tval)
			uj.ReconciliationIntervalSeconds = &ttypval

		}
	}

	state = fflib.FFParse_after_value
	goto mainparse

wantedvalue:
	return fs.WrapErr(fmt.Errorf("wanted value token, but got token: %v", tok))
wrongtokenerror:
	return fs.WrapErr(fmt.Errorf("ffjson: wanted token: %v, but got token: %v output=%s", wantedTok, tok, fs.Output.String()))
tokerror:
	if fs.BigError != nil {
		return fs.WrapErr(fs.BigError)
	}
	err = fs.Error.ToError()
	if err != nil {
		return fs.WrapErr(err)
	}
	panic("ffjson-generated: unreachable, please report bug.")
done:

	return nil
}

func (mj *ResourceStatistics) MarshalJSON() ([]byte, error) {
	var buf fflib.Buffer
	if mj == nil {
		buf.WriteString("null")
		return buf.Bytes(), nil
	}
	err := mj.MarshalJSONBuf(&buf)
	if err != nil {
		return nil, err
	}
	return buf.Bytes(), nil
}
func (mj *ResourceStatistics) MarshalJSONBuf(buf fflib.EncodingBuffer) error {
	if mj == nil {
		buf.WriteString("null")
		return nil
	}
	var err error
	var obj []byte
	_ = obj
	_ = err
	buf.WriteString(`{ "timestamp":`)
	fflib.AppendFloat(buf, float64(mj.Timestamp), 'g', -1, 64)
	buf.WriteByte(',')
	if mj.Processes != nil {
		if true {
			buf.WriteString(`"processes":`)
			fflib.FormatBits2(buf, uint64(*mj.Processes), 10, false)
			buf.WriteByte(',')
		}
	}
	if mj.Threads != nil {
		if true {
			buf.WriteString(`"threads":`)
			fflib.FormatBits2(buf, uint64(*mj.Threads), 10, false)
			buf.WriteByte(',')
		}
	}
	if mj.CPUsUserTimeSecs != nil {
		if true {
			buf.WriteString(`"cpus_user_time_secs":`)
			fflib.AppendFloat(buf, float64(*mj.CPUsUserTimeSecs), 'g', -1, 64)
			buf.WriteByte(',')
		}
	}
	if mj.CPUsSystemTimeSecs != nil {
		if true {
			buf.WriteString(`"cpus_system_time_secs":`)
			fflib.AppendFloat(buf, float64(*mj.CPUsSystemTimeSecs), 'g', -1, 64)
			buf.WriteByte(',')
		}
	}
	if mj.CPUsLimit != nil {
		if true {
			buf.WriteString(`"cpus_limit":`)
			fflib.AppendFloat(buf, float64(*mj.CPUsLimit), 'g', -1, 64)
			buf.WriteByte(',')
		}
	}
	if mj.CPUsSoftLimit != nil {
		if true {
			buf.WriteString(`"cpus_soft_limit":`)
			fflib.AppendFloat(buf, float64(*mj.CPUsSoftLimit), 'g', -1, 64)
			buf.WriteByte(',')
		}
	}
	if mj.CPUsNrPeriods != nil {
		if true {
			buf.WriteString(`"cpus_nr_periods":`)
			fflib.FormatBits2(buf, uint64(*mj.CPUsNrPeriods), 10, false)
			buf.WriteByte(',')
		}
	}
	if mj.CPUsNrThrottled != nil {
		if true {
			buf.WriteString(`"cpus_nr_throttled":`)
			fflib.FormatBits2(buf, uint64(*mj.CPUsNrThrottled), 10, false)
			buf.WriteByte(',')
		}
	}
	if mj.CPUsThrottledTimeSecs != nil {
		if true {
			buf.WriteString(`"cpus_throttled_time_secs":`)
			fflib.AppendFloat(buf, float64(*mj.CPUsThrottledTimeSecs), 'g', -1, 64)
			buf.WriteByte(',')
		}
	}
	if mj.MemTotalBytes != nil {
		if true {
			buf.WriteString(`"mem_total_bytes":`)
			fflib.FormatBits2(buf, uint64(*mj.MemTotalBytes), 10, false)
			buf.WriteByte(',')
		}
	}
	if mj.MemTotalMemswBytes != nil {
		if true {
			buf.WriteString(`"mem_total_memsw_bytes":`)
			fflib.FormatBits2(buf, uint64(*mj.MemTotalMemswBytes), 10, false)
			buf.WriteByte(',')
		}
	}
	if mj.MemLimitBytes != nil {
		if true {
			buf.WriteString(`"mem_limit_bytes":`)
			fflib.FormatBits2(buf, uint64(*mj.MemLimitBytes), 10, false)
			buf.WriteByte(',')
		}
	}
	if mj.MemSoftLimitBytes != nil {
		if true {
			buf.WriteString(`"mem_soft_limit_bytes":`)
			fflib.FormatBits2(buf, uint64(*mj.MemSoftLimitBytes), 10, false)
			buf.WriteByte(',')
		}
	}
	if mj.MemFileBytes != nil {
		if true {
			buf.WriteString(`"mem_file_bytes":`)
			fflib.FormatBits2(buf, uint64(*mj.MemFileBytes), 10, false)
			buf.WriteByte(',')
		}
	}
	if mj.MemAnonBytes != nil {
		if true {
			buf.WriteString(`"mem_anon_bytes":`)
			fflib.FormatBits2(buf, uint64(*mj.MemAnonBytes), 10, false)
			buf.WriteByte(',')
		}
	}
	if mj.MemCacheBytes != nil {
		if true {
			buf.WriteString(`"mem_cache_bytes":`)
			fflib.FormatBits2(buf, uint64(*mj.MemCacheBytes), 10, false)
			buf.WriteByte(',')
		}
	}
	if mj.MemRSSBytes != nil {
		if true {
			buf.WriteString(`"mem_rss_bytes":`)
			fflib.FormatBits2(buf, uint64(*mj.MemRSSBytes), 10, false)
			buf.WriteByte(',')
		}
	}
	if mj.MemMappedFileBytes != nil {
		if true {
			buf.WriteString(`"mem_mapped_file_bytes":`)
			fflib.FormatBits2(buf, uint64(*mj.MemMappedFileBytes), 10, false)
			buf.WriteByte(',')
		}
	}
	if mj.MemSwapBytes != nil {
		if true {
			buf.WriteString(`"mem_swap_bytes":`)
			fflib.FormatBits2(buf, uint64(*mj.MemSwapBytes), 10, false)
			buf.WriteByte(',')
		}
	}
	if mj.MemUnevictableBytes != nil {
		if true {
			buf.WriteString(`"mem_unevictable_bytes":`)
			fflib.FormatBits2(buf, uint64(*mj.MemUnevictableBytes), 10, false)
			buf.WriteByte(',')
		}
	}
	if mj.MemLowPressureCounter != nil {
		if true {
			buf.WriteString(`"mem_low_pressure_counter":`)
			fflib.FormatBits2(buf, uint64(*mj.MemLowPressureCounter), 10, false)
			buf.WriteByte(',')
		}
	}
	if mj.MemMediumPressureCounter != nil {
		if true {
			buf.WriteString(`"mem_medium_pressure_counter":`)
			fflib.FormatBits2(buf, uint64(*mj.MemMediumPressureCounter), 10, false)
			buf.WriteByte(',')
		}
	}
	if mj.MemCriticalPressureCounter != nil {
		if true {
			buf.WriteString(`"mem_critical_pressure_counter":`)
			fflib.FormatBits2(buf, uint64(*mj.MemCriticalPressureCounter), 10, false)
			buf.WriteByte(',')
		}
	}
	if mj.DiskLimitBytes != nil {
		if true {
			buf.WriteString(`"disk_limit_bytes":`)
			fflib.FormatBits2(buf, uint64(*mj.DiskLimitBytes), 10, false)
			buf.WriteByte(',')
		}
	}
	if mj.DiskUsedBytes != nil {
		if true {
			buf.WriteString(`"disk_used_bytes":`)
			fflib.FormatBits2(buf, uint64(*mj.DiskUsedBytes), 10, false)
			buf.WriteByte(',')
		}
	}
	buf.WriteString(`"disk_statistics":`)
	if mj.DiskStatistics != nil {
		buf.WriteString(`[`)
		for i, v := range mj.DiskStatistics {
			if i != 0 {
				buf.WriteString(`,`)
			}

			{

				err = v.MarshalJSONBuf(buf)
				if err != nil {
					return err
				}

			}
		}
		buf.WriteString(`]`)
	} else {
		buf.WriteString(`null`)
	}
	buf.WriteByte(',')
	if mj.BlkioStatistics != nil {
		if true {
			buf.WriteString(`"blkio_statistics":`)

			{

				err = mj.BlkioStatistics.MarshalJSONBuf(buf)
				if err != nil {
					return err
				}

			}
			buf.WriteByte(',')
		}
	}
	if mj.Perf != nil {
		if true {
			buf.WriteString(`"perf":`)

			{

				err = mj.Perf.MarshalJSONBuf(buf)
				if err != nil {
					return err
				}

			}
			buf.WriteByte(',')
		}
	}
	if mj.NetRxPackets != nil {
		if true {
			buf.WriteString(`"net_rx_packets":`)
			fflib.FormatBits2(buf, uint64(*mj.NetRxPackets), 10, false)
			buf.WriteByte(',')
		}
	}
	if mj.NetRxBytes != nil {
		if true {
			buf.WriteString(`"net_rx_bytes":`)
			fflib.FormatBits2(buf, uint64(*mj.NetRxBytes), 10, false)
			buf.WriteByte(',')
		}
	}
	if mj.NetRxErrors != nil {
		if true {
			buf.WriteString(`"net_rx_errors":`)
			fflib.FormatBits2(buf, uint64(*mj.NetRxErrors), 10, false)
			buf.WriteByte(',')
		}
	}
	if mj.NetRxDropped != nil {
		if true {
			buf.WriteString(`"net_rx_dropped":`)
			fflib.FormatBits2(buf, uint64(*mj.NetRxDropped), 10, false)
			buf.WriteByte(',')
		}
	}
	if mj.NetTxPackets != nil {
		if true {
			buf.WriteString(`"net_tx_packets":`)
			fflib.FormatBits2(buf, uint64(*mj.NetTxPackets), 10, false)
			buf.WriteByte(',')
		}
	}
	if mj.NetTxBytes != nil {
		if true {
			buf.WriteString(`"net_tx_bytes":`)
			fflib.FormatBits2(buf, uint64(*mj.NetTxBytes), 10, false)
			buf.WriteByte(',')
		}
	}
	if mj.NetTxErrors != nil {
		if true {
			buf.WriteString(`"net_tx_errors":`)
			fflib.FormatBits2(buf, uint64(*mj.NetTxErrors), 10, false)
			buf.WriteByte(',')
		}
	}
	if mj.NetTxDropped != nil {
		if true {
			buf.WriteString(`"net_tx_dropped":`)
			fflib.FormatBits2(buf, uint64(*mj.NetTxDropped), 10, false)
			buf.WriteByte(',')
		}
	}
	if mj.NetTCPRttMicrosecsP50 != nil {
		if true {
			buf.WriteString(`"net_tcp_rtt_microsecs_p50":`)
			fflib.AppendFloat(buf, float64(*mj.NetTCPRttMicrosecsP50), 'g', -1, 64)
			buf.WriteByte(',')
		}
	}
	if mj.NetTCPRttMicrosecsP90 != nil {
		if true {
			buf.WriteString(`"net_tcp_rtt_microsecs_p90":`)
			fflib.AppendFloat(buf, float64(*mj.NetTCPRttMicrosecsP90), 'g', -1, 64)
			buf.WriteByte(',')
		}
	}
	if mj.NetTCPRttMicrosecsP95 != nil {
		if true {
			buf.WriteString(`"net_tcp_rtt_microsecs_p95":`)
			fflib.AppendFloat(buf, float64(*mj.NetTCPRttMicrosecsP95), 'g', -1, 64)
			buf.WriteByte(',')
		}
	}
	if mj.NetTCPRttMicrosecsP99 != nil {
		if true {
			buf.WriteString(`"net_tcp_rtt_microsecs_p99":`)
			fflib.AppendFloat(buf, float64(*mj.NetTCPRttMicrosecsP99), 'g', -1, 64)
			buf.WriteByte(',')
		}
	}
	if mj.NetTCPActiveConnections != nil {
		if true {
			buf.WriteString(`"net_tcp_active_connections":`)
			fflib.AppendFloat(buf, float64(*mj.NetTCPActiveConnections), 'g', -1, 64)
			buf.WriteByte(',')
		}
	}
	if mj.NetTCPTimeWaitConnections != nil {
		if true {
			buf.WriteString(`"net_tcp_time_wait_connections":`)
			fflib.AppendFloat(buf, float64(*mj.NetTCPTimeWaitConnections), 'g', -1, 64)
			buf.WriteByte(',')
		}
	}
	buf.WriteString(`"net_traffic_control_statistics":`)
	if mj.NetTrafficControlStatistics != nil {
		buf.WriteString(`[`)
		for i, v := range mj.NetTrafficControlStatistics {
			if i != 0 {
				buf.WriteString(`,`)
			}

			{

				err = v.MarshalJSONBuf(buf)
				if err != nil {
					return err
				}

			}
		}
		buf.WriteString(`]`)
	} else {
		buf.WriteString(`null`)
	}
	buf.WriteByte(',')
	if mj.NetSNMPStatistics != nil {
		if true {
			buf.WriteString(`"net_snmp_statistics":`)

			{

				err = mj.NetSNMPStatistics.MarshalJSONBuf(buf)
				if err != nil {
					return err
				}

			}
			buf.WriteByte(',')
		}
	}
	buf.Rewind(1)
	buf.WriteByte('}')
	return nil
}

const (
	ffj_t_ResourceStatisticsbase = iota
	ffj_t_ResourceStatisticsno_such_key

	ffj_t_ResourceStatistics_Timestamp

	ffj_t_ResourceStatistics_Processes

	ffj_t_ResourceStatistics_Threads

	ffj_t_ResourceStatistics_CPUsUserTimeSecs

	ffj_t_ResourceStatistics_CPUsSystemTimeSecs

	ffj_t_ResourceStatistics_CPUsLimit

	ffj_t_ResourceStatistics_CPUsSoftLimit

	ffj_t_ResourceStatistics_CPUsNrPeriods

	ffj_t_ResourceStatistics_CPUsNrThrottled

	ffj_t_ResourceStatistics_CPUsThrottledTimeSecs

	ffj_t_ResourceStatistics_MemTotalBytes

	ffj_t_ResourceStatistics_MemTotalMemswBytes

	ffj_t_ResourceStatistics_MemLimitBytes

	ffj_t_ResourceStatistics_MemSoftLimitBytes

	ffj_t_ResourceStatistics_MemFileBytes

	ffj_t_ResourceStatistics_MemAnonBytes

	ffj_t_ResourceStatistics_MemCacheBytes

	ffj_t_ResourceStatistics_MemRSSBytes

	ffj_t_ResourceStatistics_MemMappedFileBytes

	ffj_t_ResourceStatistics_MemSwapBytes

	ffj_t_ResourceStatistics_MemUnevictableBytes

	ffj_t_ResourceStatistics_MemLowPressureCounter

	ffj_t_ResourceStatistics_MemMediumPressureCounter

	ffj_t_ResourceStatistics_MemCriticalPressureCounter

	ffj_t_ResourceStatistics_DiskLimitBytes

	ffj_t_ResourceStatistics_DiskUsedBytes

	ffj_t_ResourceStatistics_DiskStatistics

	ffj_t_ResourceStatistics_BlkioStatistics

	ffj_t_ResourceStatistics_Perf

	ffj_t_ResourceStatistics_NetRxPackets

	ffj_t_ResourceStatistics_NetRxBytes

	ffj_t_ResourceStatistics_NetRxErrors

	ffj_t_ResourceStatistics_NetRxDropped

	ffj_t_ResourceStatistics_NetTxPackets

	ffj_t_ResourceStatistics_NetTxBytes

	ffj_t_ResourceStatistics_NetTxErrors

	ffj_t_ResourceStatistics_NetTxDropped

	ffj_t_ResourceStatistics_NetTCPRttMicrosecsP50

	ffj_t_ResourceStatistics_NetTCPRttMicrosecsP90

	ffj_t_ResourceStatistics_NetTCPRttMicrosecsP95

	ffj_t_ResourceStatistics_NetTCPRttMicrosecsP99

	ffj_t_ResourceStatistics_NetTCPActiveConnections

	ffj_t_ResourceStatistics_NetTCPTimeWaitConnections

	ffj_t_ResourceStatistics_NetTrafficControlStatistics

	ffj_t_ResourceStatistics_NetSNMPStatistics
)

var ffj_key_ResourceStatistics_Timestamp = []byte("timestamp")

var ffj_key_ResourceStatistics_Processes = []byte("processes")

var ffj_key_ResourceStatistics_Threads = []byte("threads")

var ffj_key_ResourceStatistics_CPUsUserTimeSecs = []byte("cpus_user_time_secs")

var ffj_key_ResourceStatistics_CPUsSystemTimeSecs = []byte("cpus_system_time_secs")

var ffj_key_ResourceStatistics_CPUsLimit = []byte("cpus_limit")

var ffj_key_ResourceStatistics_CPUsSoftLimit = []byte("cpus_soft_limit")

var ffj_key_ResourceStatistics_CPUsNrPeriods = []byte("cpus_nr_periods")

var ffj_key_ResourceStatistics_CPUsNrThrottled = []byte("cpus_nr_throttled")

var ffj_key_ResourceStatistics_CPUsThrottledTimeSecs = []byte("cpus_throttled_time_secs")

var ffj_key_ResourceStatistics_MemTotalBytes = []byte("mem_total_bytes")

var ffj_key_ResourceStatistics_MemTotalMemswBytes = []byte("mem_total_memsw_bytes")

var ffj_key_ResourceStatistics_MemLimitBytes = []byte("mem_limit_bytes")

var ffj_key_ResourceStatistics_MemSoftLimitBytes = []byte("mem_soft_limit_bytes")

var ffj_key_ResourceStatistics_MemFileBytes = []byte("mem_file_bytes")

var ffj_key_ResourceStatistics_MemAnonBytes = []byte("mem_anon_bytes")

var ffj_key_ResourceStatistics_MemCacheBytes = []byte("mem_cache_bytes")

var ffj_key_ResourceStatistics_MemRSSBytes = []byte("mem_rss_bytes")

var ffj_key_ResourceStatistics_MemMappedFileBytes = []byte("mem_mapped_file_bytes")

var ffj_key_ResourceStatistics_MemSwapBytes = []byte("mem_swap_bytes")

var ffj_key_ResourceStatistics_MemUnevictableBytes = []byte("mem_unevictable_bytes")

var ffj_key_ResourceStatistics_MemLowPressureCounter = []byte("mem_low_pressure_counter")

var ffj_key_ResourceStatistics_MemMediumPressureCounter = []byte("mem_medium_pressure_counter")

var ffj_key_ResourceStatistics_MemCriticalPressureCounter = []byte("mem_critical_pressure_counter")

var ffj_key_ResourceStatistics_DiskLimitBytes = []byte("disk_limit_bytes")

var ffj_key_ResourceStatistics_DiskUsedBytes = []byte("disk_used_bytes")

var ffj_key_ResourceStatistics_DiskStatistics = []byte("disk_statistics")

var ffj_key_ResourceStatistics_BlkioStatistics = []byte("blkio_statistics")

var ffj_key_ResourceStatistics_Perf = []byte("perf")

var ffj_key_ResourceStatistics_NetRxPackets = []byte("net_rx_packets")

var ffj_key_ResourceStatistics_NetRxBytes = []byte("net_rx_bytes")

var ffj_key_ResourceStatistics_NetRxErrors = []byte("net_rx_errors")

var ffj_key_ResourceStatistics_NetRxDropped = []byte("net_rx_dropped")

var ffj_key_ResourceStatistics_NetTxPackets = []byte("net_tx_packets")

var ffj_key_ResourceStatistics_NetTxBytes = []byte("net_tx_bytes")

var ffj_key_ResourceStatistics_NetTxErrors = []byte("net_tx_errors")

var ffj_key_ResourceStatistics_NetTxDropped = []byte("net_tx_dropped")

var ffj_key_ResourceStatistics_NetTCPRttMicrosecsP50 = []byte("net_tcp_rtt_microsecs_p50")

var ffj_key_ResourceStatistics_NetTCPRttMicrosecsP90 = []byte("net_tcp_rtt_microsecs_p90")

var ffj_key_ResourceStatistics_NetTCPRttMicrosecsP95 = []byte("net_tcp_rtt_microsecs_p95")

var ffj_key_ResourceStatistics_NetTCPRttMicrosecsP99 = []byte("net_tcp_rtt_microsecs_p99")

var ffj_key_ResourceStatistics_NetTCPActiveConnections = []byte("net_tcp_active_connections")

var ffj_key_ResourceStatistics_NetTCPTimeWaitConnections = []byte("net_tcp_time_wait_connections")

var ffj_key_ResourceStatistics_NetTrafficControlStatistics = []byte("net_traffic_control_statistics")

var ffj_key_ResourceStatistics_NetSNMPStatistics = []byte("net_snmp_statistics")

func (uj *ResourceStatistics) UnmarshalJSON(input []byte) error {
	fs := fflib.NewFFLexer(input)
	return uj.UnmarshalJSONFFLexer(fs, fflib.FFParse_map_start)
}

func (uj *ResourceStatistics) UnmarshalJSONFFLexer(fs *fflib.FFLexer, state fflib.FFParseState) error {
	var err error = nil
	currentKey := ffj_t_ResourceStatisticsbase
	_ = currentKey
	tok := fflib.FFTok_init
	wantedTok := fflib.FFTok_init

mainparse:
	for {
		tok = fs.Scan()
		//	println(fmt.Sprintf("debug: tok: %v  state: %v", tok, state))
		if tok == fflib.FFTok_error {
			goto tokerror
		}

		switch state {

		case fflib.FFParse_map_start:
			if tok != fflib.FFTok_left_bracket {
				wantedTok = fflib.FFTok_left_bracket
				goto wrongtokenerror
			}
			state = fflib.FFParse_want_key
			continue

		case fflib.FFParse_after_value:
			if tok == fflib.FFTok_comma {
				state = fflib.FFParse_want_key
			} else if tok == fflib.FFTok_right_bracket {
				goto done
			} else {
				wantedTok = fflib.FFTok_comma
				goto wrongtokenerror
			}

		case fflib.FFParse_want_key:
			// json {} ended. goto exit. woo.
			if tok == fflib.FFTok_right_bracket {
				goto done
			}
			if tok != fflib.FFTok_string {
				wantedTok = fflib.FFTok_string
				goto wrongtokenerror
			}

			kn := fs.Output.Bytes()
			if len(kn) <= 0 {
				// "" case. hrm.
				currentKey = ffj_t_ResourceStatisticsno_such_key
				state = fflib.FFParse_want_colon
				goto mainparse
			} else {
				switch kn[0] {

				case 'b':

					if bytes.Equal(ffj_key_ResourceStatistics_BlkioStatistics, kn) {
						currentKey = ffj_t_ResourceStatistics_BlkioStatistics
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				case 'c':

					if bytes.Equal(ffj_key_ResourceStatistics_CPUsUserTimeSecs, kn) {
						currentKey = ffj_t_ResourceStatistics_CPUsUserTimeSecs
						state = fflib.FFParse_want_colon
						goto mainparse

					} else if bytes.Equal(ffj_key_ResourceStatistics_CPUsSystemTimeSecs, kn) {
						currentKey = ffj_t_ResourceStatistics_CPUsSystemTimeSecs
						state = fflib.FFParse_want_colon
						goto mainparse

					} else if bytes.Equal(ffj_key_ResourceStatistics_CPUsLimit, kn) {
						currentKey = ffj_t_ResourceStatistics_CPUsLimit
						state = fflib.FFParse_want_colon
						goto mainparse

					} else if bytes.Equal(ffj_key_ResourceStatistics_CPUsSoftLimit, kn) {
						currentKey = ffj_t_ResourceStatistics_CPUsSoftLimit
						state = fflib.FFParse_want_colon
						goto mainparse

					} else if bytes.Equal(ffj_key_ResourceStatistics_CPUsNrPeriods, kn) {
						currentKey = ffj_t_ResourceStatistics_CPUsNrPeriods
						state = fflib.FFParse_want_colon
						goto mainparse

					} else if bytes.Equal(ffj_key_ResourceStatistics_CPUsNrThrottled, kn) {
						currentKey = ffj_t_ResourceStatistics_CPUsNrThrottled
						state = fflib.FFParse_want_colon
						goto mainparse

					} else if bytes.Equal(ffj_key_ResourceStatistics_CPUsThrottledTimeSecs, kn) {
						currentKey = ffj_t_ResourceStatistics_CPUsThrottledTimeSecs
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				case 'd':

					if bytes.Equal(ffj_key_ResourceStatistics_DiskLimitBytes, kn) {
						currentKey = ffj_t_ResourceStatistics_DiskLimitBytes
						state = fflib.FFParse_want_colon
						goto mainparse

					} else if bytes.Equal(ffj_key_ResourceStatistics_DiskUsedBytes, kn) {
						currentKey = ffj_t_ResourceStatistics_DiskUsedBytes
						state = fflib.FFParse_want_colon
						goto mainparse

					} else if bytes.Equal(ffj_key_ResourceStatistics_DiskStatistics, kn) {
						currentKey = ffj_t_ResourceStatistics_DiskStatistics
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				case 'm':

					if bytes.Equal(ffj_key_ResourceStatistics_MemTotalBytes, kn) {
						currentKey = ffj_t_ResourceStatistics_MemTotalBytes
						state = fflib.FFParse_want_colon
						goto mainparse

					} else if bytes.Equal(ffj_key_ResourceStatistics_MemTotalMemswBytes, kn) {
						currentKey = ffj_t_ResourceStatistics_MemTotalMemswBytes
						state = fflib.FFParse_want_colon
						goto mainparse

					} else if bytes.Equal(ffj_key_ResourceStatistics_MemLimitBytes, kn) {
						currentKey = ffj_t_ResourceStatistics_MemLimitBytes
						state = fflib.FFParse_want_colon
						goto mainparse

					} else if bytes.Equal(ffj_key_ResourceStatistics_MemSoftLimitBytes, kn) {
						currentKey = ffj_t_ResourceStatistics_MemSoftLimitBytes
						state = fflib.FFParse_want_colon
						goto mainparse

					} else if bytes.Equal(ffj_key_ResourceStatistics_MemFileBytes, kn) {
						currentKey = ffj_t_ResourceStatistics_MemFileBytes
						state = fflib.FFParse_want_colon
						goto mainparse

					} else if bytes.Equal(ffj_key_ResourceStatistics_MemAnonBytes, kn) {
						currentKey = ffj_t_ResourceStatistics_MemAnonBytes
						state = fflib.FFParse_want_colon
						goto mainparse

					} else if bytes.Equal(ffj_key_ResourceStatistics_MemCacheBytes, kn) {
						currentKey = ffj_t_ResourceStatistics_MemCacheBytes
						state = fflib.FFParse_want_colon
						goto mainparse

					} else if bytes.Equal(ffj_key_ResourceStatistics_MemRSSBytes, kn) {
						currentKey = ffj_t_ResourceStatistics_MemRSSBytes
						state = fflib.FFParse_want_colon
						goto mainparse

					} else if bytes.Equal(ffj_key_ResourceStatistics_MemMappedFileBytes, kn) {
						currentKey = ffj_t_ResourceStatistics_MemMappedFileBytes
						state = fflib.FFParse_want_colon
						goto mainparse

					} else if bytes.Equal(ffj_key_ResourceStatistics_MemSwapBytes, kn) {
						currentKey = ffj_t_ResourceStatistics_MemSwapBytes
						state = fflib.FFParse_want_colon
						goto mainparse

					} else if bytes.Equal(ffj_key_ResourceStatistics_MemUnevictableBytes, kn) {
						currentKey = ffj_t_ResourceStatistics_MemUnevictableBytes
						state = fflib.FFParse_want_colon
						goto mainparse

					} else if bytes.Equal(ffj_key_ResourceStatistics_MemLowPressureCounter, kn) {
						currentKey = ffj_t_ResourceStatistics_MemLowPressureCounter
						state = fflib.FFParse_want_colon
						goto mainparse

					} else if bytes.Equal(ffj_key_ResourceStatistics_MemMediumPressureCounter, kn) {
						currentKey = ffj_t_ResourceStatistics_MemMediumPressureCounter
						state = fflib.FFParse_want_colon
						goto mainparse

					} else if bytes.Equal(ffj_key_ResourceStatistics_MemCriticalPressureCounter, kn) {
						currentKey = ffj_t_ResourceStatistics_MemCriticalPressureCounter
						state = fflib.FFParse_want_colon
						goto mainparse
					}

				case 'n':

					if bytes.Equal(ffj_key_ResourceStatistics_NetRxPackets, kn) {
						currentKey = ffj_t_ResourceStatistics_NetRxPackets
						state = fflib.FFParse_want_colon
						goto mainparse

					} else if bytes.Equal(ffj_key_ResourceStatistics_NetRxBytes, kn) {
						currentKey = ffj_t_ResourceStatistics_NetRxBytes
						state = fflib.FFParse_want_colon
						goto mainparse

					} else if bytes.Equal(ffj_key_ResourceStatistics_NetRxErrors, kn) {
						currentKey = ffj_t_ResourceStatistics_NetRxErrors
						state = fflib.FFParse_want_colon
						goto mainparse

					} else if bytes.Equal(ffj_key_ResourceStatistics_NetRxDropped, kn) {
						currentKey = ffj_t_ResourceStatistics_NetRxDropped
						state = fflib.FFParse_want_colon
						goto mainparse

					} else if bytes.Equal(ffj_key_ResourceStatistics_NetTxPackets, kn) {
						currentKey = ffj_t_ResourceStatistics_NetTxPackets
						state = fflib.FFParse_want_colon
						goto mainparse

					} else if bytes.Equal(ffj_key_ResourceStatistics_NetTxBytes, kn) {
						currentKey = ffj_t_ResourceStatistics_NetTxBytes
						state = fflib.FFParse_want_colon
						goto mainparse

					} else if bytes.Equal(ffj_key_ResourceStatistics_NetTxErrors, kn) {
						currentKey = ffj_t_ResourceStatistics_NetTxErrors
						state = fflib.FFParse_want_colon
						goto mainparse

					} else if bytes.Equal(ffj_key_ResourceStatistics_NetTxDropped, kn) {
						currentKey = ffj_t_ResourceStatistics_NetTxDropped
						state = fflib.FFParse_want_colon
						goto mainparse

					} else if bytes.Equal(ffj_key_ResourceStatistics_NetTCPRttMicrosecsP50, kn) {
						currentKey = ffj_t_ResourceStatistics_NetTCPRttMicrosecsP50
						state = fflib.FFParse_want_colon
						goto mainparse

					} else if bytes.Equal(ffj_key_ResourceStatistics_NetTCPRttMicrosecsP90, kn) {
						currentKey = ffj_t_ResourceStatistics_NetTCPRttMicrosecsP90
						state = fflib.FFParse_want_colon
						goto mainparse

					} else if bytes.Equal(ffj_key_ResourceStatistics_NetTCPRttMicrosecsP95, kn) {
						currentKey = ffj_t_ResourceStatistics_NetTCPRttMicrosecsP95
						state = fflib.FFParse_want_colon
						goto mainparse

					} else if bytes.Equal(ffj_key_ResourceStatistics_NetTCPRttMicrosecsP99, kn) {
						currentKey = ffj_t_ResourceStatistics_NetTCPRttMicrosecsP99
						state = fflib.FFParse_want_colon
						goto mainparse

					} else if bytes.Equal(ffj_key_ResourceStatistics_NetTCPActiveConnections, kn) {
						currentKey = ffj_t_ResourceStatistics_NetTCPActiveConnections
						state = fflib.FFParse_want_colon
						goto mainparse

					} else if bytes.Equal(ffj_key_ResourceStatistics_NetTCPTimeWaitConnections, kn) {
						currentKey = ffj_t_ResourceStatistics_NetTCPTimeWaitConnections
						state = fflib.FFParse_want_colon
						goto mainparse

					} else if bytes.Equal(ffj_key_ResourceStatistics_NetTrafficControlStatistics, kn) {
						currentKey = ffj_t_ResourceStatistics_NetTrafficControlStatistics
						state = fflib.FFParse_want_colon
						goto mainparse

					} else if bytes.Equal(ffj_key_ResourceStatistics_NetSNMPStatistics, kn) {
						currentKey 