// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package proton

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/jsonrpc"
)

const opAcceptEnvironmentAccountConnection = "AcceptEnvironmentAccountConnection"

// AcceptEnvironmentAccountConnectionRequest generates a "aws/request.Request" representing the
// client's request for the AcceptEnvironmentAccountConnection operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AcceptEnvironmentAccountConnection for more information on using the AcceptEnvironmentAccountConnection
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the AcceptEnvironmentAccountConnectionRequest method.
//	req, resp := client.AcceptEnvironmentAccountConnectionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/AcceptEnvironmentAccountConnection
func (c *Proton) AcceptEnvironmentAccountConnectionRequest(input *AcceptEnvironmentAccountConnectionInput) (req *request.Request, output *AcceptEnvironmentAccountConnectionOutput) {
	op := &request.Operation{
		Name:       opAcceptEnvironmentAccountConnection,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AcceptEnvironmentAccountConnectionInput{}
	}

	output = &AcceptEnvironmentAccountConnectionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AcceptEnvironmentAccountConnection API operation for AWS Proton.
//
// In a management account, an environment account connection request is accepted.
// When the environment account connection request is accepted, Proton can use
// the associated IAM role to provision environment infrastructure resources
// in the associated environment account.
//
// For more information, see Environment account connections (https://docs.aws.amazon.com/proton/latest/userguide/ag-env-account-connections.html)
// in the Proton User guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Proton's
// API operation AcceptEnvironmentAccountConnection for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The input is invalid or an out-of-range value was supplied for the input
//     parameter.
//
//   - AccessDeniedException
//     There isn't sufficient access for performing this action.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ConflictException
//     The request couldn't be made due to a conflicting operation or resource.
//
//   - ResourceNotFoundException
//     The requested resource wasn't found.
//
//   - InternalServerException
//     The request failed to register with the service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/AcceptEnvironmentAccountConnection
func (c *Proton) AcceptEnvironmentAccountConnection(input *AcceptEnvironmentAccountConnectionInput) (*AcceptEnvironmentAccountConnectionOutput, error) {
	req, out := c.AcceptEnvironmentAccountConnectionRequest(input)
	return out, req.Send()
}

// AcceptEnvironmentAccountConnectionWithContext is the same as AcceptEnvironmentAccountConnection with the addition of
// the ability to pass a context and additional request options.
//
// See AcceptEnvironmentAccountConnection for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Proton) AcceptEnvironmentAccountConnectionWithContext(ctx aws.Context, input *AcceptEnvironmentAccountConnectionInput, opts ...request.Option) (*AcceptEnvironmentAccountConnectionOutput, error) {
	req, out := c.AcceptEnvironmentAccountConnectionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCancelComponentDeployment = "CancelComponentDeployment"

// CancelComponentDeploymentRequest generates a "aws/request.Request" representing the
// client's request for the CancelComponentDeployment operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CancelComponentDeployment for more information on using the CancelComponentDeployment
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CancelComponentDeploymentRequest method.
//	req, resp := client.CancelComponentDeploymentRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/CancelComponentDeployment
func (c *Proton) CancelComponentDeploymentRequest(input *CancelComponentDeploymentInput) (req *request.Request, output *CancelComponentDeploymentOutput) {
	op := &request.Operation{
		Name:       opCancelComponentDeployment,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CancelComponentDeploymentInput{}
	}

	output = &CancelComponentDeploymentOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CancelComponentDeployment API operation for AWS Proton.
//
// Attempts to cancel a component deployment (for a component that is in the
// IN_PROGRESS deployment status).
//
// For more information about components, see Proton components (https://docs.aws.amazon.com/proton/latest/userguide/ag-components.html)
// in the Proton User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Proton's
// API operation CancelComponentDeployment for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The input is invalid or an out-of-range value was supplied for the input
//     parameter.
//
//   - AccessDeniedException
//     There isn't sufficient access for performing this action.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ConflictException
//     The request couldn't be made due to a conflicting operation or resource.
//
//   - ResourceNotFoundException
//     The requested resource wasn't found.
//
//   - InternalServerException
//     The request failed to register with the service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/CancelComponentDeployment
func (c *Proton) CancelComponentDeployment(input *CancelComponentDeploymentInput) (*CancelComponentDeploymentOutput, error) {
	req, out := c.CancelComponentDeploymentRequest(input)
	return out, req.Send()
}

// CancelComponentDeploymentWithContext is the same as CancelComponentDeployment with the addition of
// the ability to pass a context and additional request options.
//
// See CancelComponentDeployment for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Proton) CancelComponentDeploymentWithContext(ctx aws.Context, input *CancelComponentDeploymentInput, opts ...request.Option) (*CancelComponentDeploymentOutput, error) {
	req, out := c.CancelComponentDeploymentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCancelEnvironmentDeployment = "CancelEnvironmentDeployment"

// CancelEnvironmentDeploymentRequest generates a "aws/request.Request" representing the
// client's request for the CancelEnvironmentDeployment operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CancelEnvironmentDeployment for more information on using the CancelEnvironmentDeployment
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CancelEnvironmentDeploymentRequest method.
//	req, resp := client.CancelEnvironmentDeploymentRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/CancelEnvironmentDeployment
func (c *Proton) CancelEnvironmentDeploymentRequest(input *CancelEnvironmentDeploymentInput) (req *request.Request, output *CancelEnvironmentDeploymentOutput) {
	op := &request.Operation{
		Name:       opCancelEnvironmentDeployment,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CancelEnvironmentDeploymentInput{}
	}

	output = &CancelEnvironmentDeploymentOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CancelEnvironmentDeployment API operation for AWS Proton.
//
// Attempts to cancel an environment deployment on an UpdateEnvironment action,
// if the deployment is IN_PROGRESS. For more information, see Update an environment
// (https://docs.aws.amazon.com/proton/latest/userguide/ag-env-update.html)
// in the Proton User guide.
//
// The following list includes potential cancellation scenarios.
//
//   - If the cancellation attempt succeeds, the resulting deployment state
//     is CANCELLED.
//
//   - If the cancellation attempt fails, the resulting deployment state is
//     FAILED.
//
//   - If the current UpdateEnvironment action succeeds before the cancellation
//     attempt starts, the resulting deployment state is SUCCEEDED and the cancellation
//     attempt has no effect.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Proton's
// API operation CancelEnvironmentDeployment for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The input is invalid or an out-of-range value was supplied for the input
//     parameter.
//
//   - AccessDeniedException
//     There isn't sufficient access for performing this action.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ConflictException
//     The request couldn't be made due to a conflicting operation or resource.
//
//   - ResourceNotFoundException
//     The requested resource wasn't found.
//
//   - InternalServerException
//     The request failed to register with the service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/CancelEnvironmentDeployment
func (c *Proton) CancelEnvironmentDeployment(input *CancelEnvironmentDeploymentInput) (*CancelEnvironmentDeploymentOutput, error) {
	req, out := c.CancelEnvironmentDeploymentRequest(input)
	return out, req.Send()
}

// CancelEnvironmentDeploymentWithContext is the same as CancelEnvironmentDeployment with the addition of
// the ability to pass a context and additional request options.
//
// See CancelEnvironmentDeployment for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Proton) CancelEnvironmentDeploymentWithContext(ctx aws.Context, input *CancelEnvironmentDeploymentInput, opts ...request.Option) (*CancelEnvironmentDeploymentOutput, error) {
	req, out := c.CancelEnvironmentDeploymentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCancelServiceInstanceDeployment = "CancelServiceInstanceDeployment"

// CancelServiceInstanceDeploymentRequest generates a "aws/request.Request" representing the
// client's request for the CancelServiceInstanceDeployment operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CancelServiceInstanceDeployment for more information on using the CancelServiceInstanceDeployment
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CancelServiceInstanceDeploymentRequest method.
//	req, resp := client.CancelServiceInstanceDeploymentRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/CancelServiceInstanceDeployment
func (c *Proton) CancelServiceInstanceDeploymentRequest(input *CancelServiceInstanceDeploymentInput) (req *request.Request, output *CancelServiceInstanceDeploymentOutput) {
	op := &request.Operation{
		Name:       opCancelServiceInstanceDeployment,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CancelServiceInstanceDeploymentInput{}
	}

	output = &CancelServiceInstanceDeploymentOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CancelServiceInstanceDeployment API operation for AWS Proton.
//
// Attempts to cancel a service instance deployment on an UpdateServiceInstance
// action, if the deployment is IN_PROGRESS. For more information, see Update
// a service instance (https://docs.aws.amazon.com/proton/latest/userguide/ag-svc-instance-update.html)
// in the Proton User guide.
//
// The following list includes potential cancellation scenarios.
//
//   - If the cancellation attempt succeeds, the resulting deployment state
//     is CANCELLED.
//
//   - If the cancellation attempt fails, the resulting deployment state is
//     FAILED.
//
//   - If the current UpdateServiceInstance action succeeds before the cancellation
//     attempt starts, the resulting deployment state is SUCCEEDED and the cancellation
//     attempt has no effect.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Proton's
// API operation CancelServiceInstanceDeployment for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The input is invalid or an out-of-range value was supplied for the input
//     parameter.
//
//   - AccessDeniedException
//     There isn't sufficient access for performing this action.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ConflictException
//     The request couldn't be made due to a conflicting operation or resource.
//
//   - ResourceNotFoundException
//     The requested resource wasn't found.
//
//   - InternalServerException
//     The request failed to register with the service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/CancelServiceInstanceDeployment
func (c *Proton) CancelServiceInstanceDeployment(input *CancelServiceInstanceDeploymentInput) (*CancelServiceInstanceDeploymentOutput, error) {
	req, out := c.CancelServiceInstanceDeploymentRequest(input)
	return out, req.Send()
}

// CancelServiceInstanceDeploymentWithContext is the same as CancelServiceInstanceDeployment with the addition of
// the ability to pass a context and additional request options.
//
// See CancelServiceInstanceDeployment for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Proton) CancelServiceInstanceDeploymentWithContext(ctx aws.Context, input *CancelServiceInstanceDeploymentInput, opts ...request.Option) (*CancelServiceInstanceDeploymentOutput, error) {
	req, out := c.CancelServiceInstanceDeploymentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCancelServicePipelineDeployment = "CancelServicePipelineDeployment"

// CancelServicePipelineDeploymentRequest generates a "aws/request.Request" representing the
// client's request for the CancelServicePipelineDeployment operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CancelServicePipelineDeployment for more information on using the CancelServicePipelineDeployment
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CancelServicePipelineDeploymentRequest method.
//	req, resp := client.CancelServicePipelineDeploymentRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/CancelServicePipelineDeployment
func (c *Proton) CancelServicePipelineDeploymentRequest(input *CancelServicePipelineDeploymentInput) (req *request.Request, output *CancelServicePipelineDeploymentOutput) {
	op := &request.Operation{
		Name:       opCancelServicePipelineDeployment,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CancelServicePipelineDeploymentInput{}
	}

	output = &CancelServicePipelineDeploymentOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CancelServicePipelineDeployment API operation for AWS Proton.
//
// Attempts to cancel a service pipeline deployment on an UpdateServicePipeline
// action, if the deployment is IN_PROGRESS. For more information, see Update
// a service pipeline (https://docs.aws.amazon.com/proton/latest/userguide/ag-svc-pipeline-update.html)
// in the Proton User guide.
//
// The following list includes potential cancellation scenarios.
//
//   - If the cancellation attempt succeeds, the resulting deployment state
//     is CANCELLED.
//
//   - If the cancellation attempt fails, the resulting deployment state is
//     FAILED.
//
//   - If the current UpdateServicePipeline action succeeds before the cancellation
//     attempt starts, the resulting deployment state is SUCCEEDED and the cancellation
//     attempt has no effect.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Proton's
// API operation CancelServicePipelineDeployment for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The input is invalid or an out-of-range value was supplied for the input
//     parameter.
//
//   - AccessDeniedException
//     There isn't sufficient access for performing this action.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ConflictException
//     The request couldn't be made due to a conflicting operation or resource.
//
//   - ResourceNotFoundException
//     The requested resource wasn't found.
//
//   - InternalServerException
//     The request failed to register with the service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/CancelServicePipelineDeployment
func (c *Proton) CancelServicePipelineDeployment(input *CancelServicePipelineDeploymentInput) (*CancelServicePipelineDeploymentOutput, error) {
	req, out := c.CancelServicePipelineDeploymentRequest(input)
	return out, req.Send()
}

// CancelServicePipelineDeploymentWithContext is the same as CancelServicePipelineDeployment with the addition of
// the ability to pass a context and additional request options.
//
// See CancelServicePipelineDeployment for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Proton) CancelServicePipelineDeploymentWithContext(ctx aws.Context, input *CancelServicePipelineDeploymentInput, opts ...request.Option) (*CancelServicePipelineDeploymentOutput, error) {
	req, out := c.CancelServicePipelineDeploymentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateComponent = "CreateComponent"

// CreateComponentRequest generates a "aws/request.Request" representing the
// client's request for the CreateComponent operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateComponent for more information on using the CreateComponent
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateComponentRequest method.
//	req, resp := client.CreateComponentRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/CreateComponent
func (c *Proton) CreateComponentRequest(input *CreateComponentInput) (req *request.Request, output *CreateComponentOutput) {
	op := &request.Operation{
		Name:       opCreateComponent,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateComponentInput{}
	}

	output = &CreateComponentOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateComponent API operation for AWS Proton.
//
// Create an Proton component. A component is an infrastructure extension for
// a service instance.
//
// For more information about components, see Proton components (https://docs.aws.amazon.com/proton/latest/userguide/ag-components.html)
// in the Proton User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Proton's
// API operation CreateComponent for usage and error information.
//
// Returned Error Types:
//
//   - ServiceQuotaExceededException
//     A quota was exceeded. For more information, see Proton Quotas (https://docs.aws.amazon.com/proton/latest/userguide/ag-limits.html)
//     in the Proton User Guide.
//
//   - ValidationException
//     The input is invalid or an out-of-range value was supplied for the input
//     parameter.
//
//   - AccessDeniedException
//     There isn't sufficient access for performing this action.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ConflictException
//     The request couldn't be made due to a conflicting operation or resource.
//
//   - ResourceNotFoundException
//     The requested resource wasn't found.
//
//   - InternalServerException
//     The request failed to register with the service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/CreateComponent
func (c *Proton) CreateComponent(input *CreateComponentInput) (*CreateComponentOutput, error) {
	req, out := c.CreateComponentRequest(input)
	return out, req.Send()
}

// CreateComponentWithContext is the same as CreateComponent with the addition of
// the ability to pass a context and additional request options.
//
// See CreateComponent for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Proton) CreateComponentWithContext(ctx aws.Context, input *CreateComponentInput, opts ...request.Option) (*CreateComponentOutput, error) {
	req, out := c.CreateComponentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateEnvironment = "CreateEnvironment"

// CreateEnvironmentRequest generates a "aws/request.Request" representing the
// client's request for the CreateEnvironment operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateEnvironment for more information on using the CreateEnvironment
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateEnvironmentRequest method.
//	req, resp := client.CreateEnvironmentRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/CreateEnvironment
func (c *Proton) CreateEnvironmentRequest(input *CreateEnvironmentInput) (req *request.Request, output *CreateEnvironmentOutput) {
	op := &request.Operation{
		Name:       opCreateEnvironment,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateEnvironmentInput{}
	}

	output = &CreateEnvironmentOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateEnvironment API operation for AWS Proton.
//
// Deploy a new environment. An Proton environment is created from an environment
// template that defines infrastructure and resources that can be shared across
// services.
//
// You can provision environments using the following methods:
//
//   - Amazon Web Services-managed provisioning: Proton makes direct calls
//     to provision your resources.
//
//   - Self-managed provisioning: Proton makes pull requests on your repository
//     to provide compiled infrastructure as code (IaC) files that your IaC engine
//     uses to provision resources.
//
// For more information, see Environments (https://docs.aws.amazon.com/proton/latest/userguide/ag-environments.html)
// and Provisioning methods (https://docs.aws.amazon.com/proton/latest/userguide/ag-works-prov-methods.html)
// in the Proton User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Proton's
// API operation CreateEnvironment for usage and error information.
//
// Returned Error Types:
//
//   - ServiceQuotaExceededException
//     A quota was exceeded. For more information, see Proton Quotas (https://docs.aws.amazon.com/proton/latest/userguide/ag-limits.html)
//     in the Proton User Guide.
//
//   - ValidationException
//     The input is invalid or an out-of-range value was supplied for the input
//     parameter.
//
//   - AccessDeniedException
//     There isn't sufficient access for performing this action.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ConflictException
//     The request couldn't be made due to a conflicting operation or resource.
//
//   - ResourceNotFoundException
//     The requested resource wasn't found.
//
//   - InternalServerException
//     The request failed to register with the service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/CreateEnvironment
func (c *Proton) CreateEnvironment(input *CreateEnvironmentInput) (*CreateEnvironmentOutput, error) {
	req, out := c.CreateEnvironmentRequest(input)
	return out, req.Send()
}

// CreateEnvironmentWithContext is the same as CreateEnvironment with the addition of
// the ability to pass a context and additional request options.
//
// See CreateEnvironment for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Proton) CreateEnvironmentWithContext(ctx aws.Context, input *CreateEnvironmentInput, opts ...request.Option) (*CreateEnvironmentOutput, error) {
	req, out := c.CreateEnvironmentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateEnvironmentAccountConnection = "CreateEnvironmentAccountConnection"

// CreateEnvironmentAccountConnectionRequest generates a "aws/request.Request" representing the
// client's request for the CreateEnvironmentAccountConnection operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateEnvironmentAccountConnection for more information on using the CreateEnvironmentAccountConnection
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateEnvironmentAccountConnectionRequest method.
//	req, resp := client.CreateEnvironmentAccountConnectionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/CreateEnvironmentAccountConnection
func (c *Proton) CreateEnvironmentAccountConnectionRequest(input *CreateEnvironmentAccountConnectionInput) (req *request.Request, output *CreateEnvironmentAccountConnectionOutput) {
	op := &request.Operation{
		Name:       opCreateEnvironmentAccountConnection,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateEnvironmentAccountConnectionInput{}
	}

	output = &CreateEnvironmentAccountConnectionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateEnvironmentAccountConnection API operation for AWS Proton.
//
// Create an environment account connection in an environment account so that
// environment infrastructure resources can be provisioned in the environment
// account from a management account.
//
// An environment account connection is a secure bi-directional connection between
// a management account and an environment account that maintains authorization
// and permissions. For more information, see Environment account connections
// (https://docs.aws.amazon.com/proton/latest/userguide/ag-env-account-connections.html)
// in the Proton User guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Proton's
// API operation CreateEnvironmentAccountConnection for usage and error information.
//
// Returned Error Types:
//
//   - ServiceQuotaExceededException
//     A quota was exceeded. For more information, see Proton Quotas (https://docs.aws.amazon.com/proton/latest/userguide/ag-limits.html)
//     in the Proton User Guide.
//
//   - ValidationException
//     The input is invalid or an out-of-range value was supplied for the input
//     parameter.
//
//   - AccessDeniedException
//     There isn't sufficient access for performing this action.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ConflictException
//     The request couldn't be made due to a conflicting operation or resource.
//
//   - InternalServerException
//     The request failed to register with the service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/CreateEnvironmentAccountConnection
func (c *Proton) CreateEnvironmentAccountConnection(input *CreateEnvironmentAccountConnectionInput) (*CreateEnvironmentAccountConnectionOutput, error) {
	req, out := c.CreateEnvironmentAccountConnectionRequest(input)
	return out, req.Send()
}

// CreateEnvironmentAccountConnectionWithContext is the same as CreateEnvironmentAccountConnection with the addition of
// the ability to pass a context and additional request options.
//
// See CreateEnvironmentAccountConnection for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Proton) CreateEnvironmentAccountConnectionWithContext(ctx aws.Context, input *CreateEnvironmentAccountConnectionInput, opts ...request.Option) (*CreateEnvironmentAccountConnectionOutput, error) {
	req, out := c.CreateEnvironmentAccountConnectionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateEnvironmentTemplate = "CreateEnvironmentTemplate"

// CreateEnvironmentTemplateRequest generates a "aws/request.Request" representing the
// client's request for the CreateEnvironmentTemplate operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateEnvironmentTemplate for more information on using the CreateEnvironmentTemplate
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateEnvironmentTemplateRequest method.
//	req, resp := client.CreateEnvironmentTemplateRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/CreateEnvironmentTemplate
func (c *Proton) CreateEnvironmentTemplateRequest(input *CreateEnvironmentTemplateInput) (req *request.Request, output *CreateEnvironmentTemplateOutput) {
	op := &request.Operation{
		Name:       opCreateEnvironmentTemplate,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateEnvironmentTemplateInput{}
	}

	output = &CreateEnvironmentTemplateOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateEnvironmentTemplate API operation for AWS Proton.
//
// Create an environment template for Proton. For more information, see Environment
// Templates (https://docs.aws.amazon.com/proton/latest/userguide/ag-templates.html)
// in the Proton User Guide.
//
// You can create an environment template in one of the two following ways:
//
//   - Register and publish a standard environment template that instructs
//     Proton to deploy and manage environment infrastructure.
//
//   - Register and publish a customer managed environment template that connects
//     Proton to your existing provisioned infrastructure that you manage. Proton
//     doesn't manage your existing provisioned infrastructure. To create an
//     environment template for customer provisioned and managed infrastructure,
//     include the provisioning parameter and set the value to CUSTOMER_MANAGED.
//     For more information, see Register and publish an environment template
//     (https://docs.aws.amazon.com/proton/latest/userguide/template-create.html)
//     in the Proton User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Proton's
// API operation CreateEnvironmentTemplate for usage and error information.
//
// Returned Error Types:
//
//   - ServiceQuotaExceededException
//     A quota was exceeded. For more information, see Proton Quotas (https://docs.aws.amazon.com/proton/latest/userguide/ag-limits.html)
//     in the Proton User Guide.
//
//   - ValidationException
//     The input is invalid or an out-of-range value was supplied for the input
//     parameter.
//
//   - AccessDeniedException
//     There isn't sufficient access for performing this action.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ConflictException
//     The request couldn't be made due to a conflicting operation or resource.
//
//   - InternalServerException
//     The request failed to register with the service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/CreateEnvironmentTemplate
func (c *Proton) CreateEnvironmentTemplate(input *CreateEnvironmentTemplateInput) (*CreateEnvironmentTemplateOutput, error) {
	req, out := c.CreateEnvironmentTemplateRequest(input)
	return out, req.Send()
}

// CreateEnvironmentTemplateWithContext is the same as CreateEnvironmentTemplate with the addition of
// the ability to pass a context and additional request options.
//
// See CreateEnvironmentTemplate for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Proton) CreateEnvironmentTemplateWithContext(ctx aws.Context, input *CreateEnvironmentTemplateInput, opts ...request.Option) (*CreateEnvironmentTemplateOutput, error) {
	req, out := c.CreateEnvironmentTemplateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateEnvironmentTemplateVersion = "CreateEnvironmentTemplateVersion"

// CreateEnvironmentTemplateVersionRequest generates a "aws/request.Request" representing the
// client's request for the CreateEnvironmentTemplateVersion operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateEnvironmentTemplateVersion for more information on using the CreateEnvironmentTemplateVersion
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateEnvironmentTemplateVersionRequest method.
//	req, resp := client.CreateEnvironmentTemplateVersionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/CreateEnvironmentTemplateVersion
func (c *Proton) CreateEnvironmentTemplateVersionRequest(input *CreateEnvironmentTemplateVersionInput) (req *request.Request, output *CreateEnvironmentTemplateVersionOutput) {
	op := &request.Operation{
		Name:       opCreateEnvironmentTemplateVersion,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateEnvironmentTemplateVersionInput{}
	}

	output = &CreateEnvironmentTemplateVersionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateEnvironmentTemplateVersion API operation for AWS Proton.
//
// Create a new major or minor version of an environment template. A major version
// of an environment template is a version that isn't backwards compatible.
// A minor version of an environment template is a version that's backwards
// compatible within its major version.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Proton's
// API operation CreateEnvironmentTemplateVersion for usage and error information.
//
// Returned Error Types:
//
//   - ServiceQuotaExceededException
//     A quota was exceeded. For more information, see Proton Quotas (https://docs.aws.amazon.com/proton/latest/userguide/ag-limits.html)
//     in the Proton User Guide.
//
//   - ValidationException
//     The input is invalid or an out-of-range value was supplied for the input
//     parameter.
//
//   - AccessDeniedException
//     There isn't sufficient access for performing this action.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ConflictException
//     The request couldn't be made due to a conflicting operation or resource.
//
//   - ResourceNotFoundException
//     The requested resource wasn't found.
//
//   - InternalServerException
//     The request failed to register with the service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/CreateEnvironmentTemplateVersion
func (c *Proton) CreateEnvironmentTemplateVersion(input *CreateEnvironmentTemplateVersionInput) (*CreateEnvironmentTemplateVersionOutput, error) {
	req, out := c.CreateEnvironmentTemplateVersionRequest(input)
	return out, req.Send()
}

// CreateEnvironmentTemplateVersionWithContext is the same as CreateEnvironmentTemplateVersion with the addition of
// the ability to pass a context and additional request options.
//
// See CreateEnvironmentTemplateVersion for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Proton) CreateEnvironmentTemplateVersionWithContext(ctx aws.Context, input *CreateEnvironmentTemplateVersionInput, opts ...request.Option) (*CreateEnvironmentTemplateVersionOutput, error) {
	req, out := c.CreateEnvironmentTemplateVersionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateRepository = "CreateRepository"

// CreateRepositoryRequest generates a "aws/request.Request" representing the
// client's request for the CreateRepository operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateRepository for more information on using the CreateRepository
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateRepositoryRequest method.
//	req, resp := client.CreateRepositoryRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/CreateRepository
func (c *Proton) CreateRepositoryRequest(input *CreateRepositoryInput) (req *request.Request, output *CreateRepositoryOutput) {
	op := &request.Operation{
		Name:       opCreateRepository,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateRepositoryInput{}
	}

	output = &CreateRepositoryOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateRepository API operation for AWS Proton.
//
// Create and register a link to a repository. Proton uses the link to repeatedly
// access the repository, to either push to it (self-managed provisioning) or
// pull from it (template sync). You can share a linked repository across multiple
// resources (like environments using self-managed provisioning, or synced templates).
// When you create a repository link, Proton creates a service-linked role (https://docs.aws.amazon.com/proton/latest/userguide/using-service-linked-roles.html)
// for you.
//
// For more information, see Self-managed provisioning (https://docs.aws.amazon.com/proton/latest/userguide/ag-works-prov-methods.html#ag-works-prov-methods-self),
// Template bundles (https://docs.aws.amazon.com/proton/latest/userguide/ag-template-authoring.html#ag-template-bundles),
// and Template sync configurations (https://docs.aws.amazon.com/proton/latest/userguide/ag-template-sync-configs.html)
// in the Proton User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Proton's
// API operation CreateRepository for usage and error information.
//
// Returned Error Types:
//
//   - ServiceQuotaExceededException
//     A quota was exceeded. For more information, see Proton Quotas (https://docs.aws.amazon.com/proton/latest/userguide/ag-limits.html)
//     in the Proton User Guide.
//
//   - ValidationException
//     The input is invalid or an out-of-range value was supplied for the input
//     parameter.
//
//   - AccessDeniedException
//     There isn't sufficient access for performing this action.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ConflictException
//     The request couldn't be made due to a conflicting operation or resource.
//
//   - InternalServerException
//     The request failed to register with the service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/CreateRepository
func (c *Proton) CreateRepository(input *CreateRepositoryInput) (*CreateRepositoryOutput, error) {
	req, out := c.CreateRepositoryRequest(input)
	return out, req.Send()
}

// CreateRepositoryWithContext is the same as CreateRepository with the addition of
// the ability to pass a context and additional request options.
//
// See CreateRepository for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Proton) CreateRepositoryWithContext(ctx aws.Context, input *CreateRepositoryInput, opts ...request.Option) (*CreateRepositoryOutput, error) {
	req, out := c.CreateRepositoryRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateService = "CreateService"

// CreateServiceRequest generates a "aws/request.Request" representing the
// client's request for the CreateService operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateService for more information on using the CreateService
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateServiceRequest method.
//	req, resp := client.CreateServiceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/CreateService
func (c *Proton) CreateServiceRequest(input *CreateServiceInput) (req *request.Request, output *CreateServiceOutput) {
	op := &request.Operation{
		Name:       opCreateService,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateServiceInput{}
	}

	output = &CreateServiceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateService API operation for AWS Proton.
//
// Create an Proton service. An Proton service is an instantiation of a service
// template and often includes several service instances and pipeline. For more
// information, see Services (https://docs.aws.amazon.com/proton/latest/userguide/ag-services.html)
// in the Proton User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Proton's
// API operation CreateService for usage and error information.
//
// Returned Error Types:
//
//   - ServiceQuotaExceededException
//     A quota was exceeded. For more information, see Proton Quotas (https://docs.aws.amazon.com/proton/latest/userguide/ag-limits.html)
//     in the Proton User Guide.
//
//   - ValidationException
//     The input is invalid or an out-of-range value was supplied for the input
//     parameter.
//
//   - AccessDeniedException
//     There isn't sufficient access for performing this action.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ConflictException
//     The request couldn't be made due to a conflicting operation or resource.
//
//   - ResourceNotFoundException
//     The requested resource wasn't found.
//
//   - InternalServerException
//     The request failed to register with the service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/CreateService
func (c *Proton) CreateService(input *CreateServiceInput) (*CreateServiceOutput, error) {
	req, out := c.CreateServiceRequest(input)
	return out, req.Send()
}

// CreateServiceWithContext is the same as CreateService with the addition of
// the ability to pass a context and additional request options.
//
// See CreateService for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Proton) CreateServiceWithContext(ctx aws.Context, input *CreateServiceInput, opts ...request.Option) (*CreateServiceOutput, error) {
	req, out := c.CreateServiceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateServiceInstance = "CreateServiceInstance"

// CreateServiceInstanceRequest generates a "aws/request.Request" representing the
// client's request for the CreateServiceInstance operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateServiceInstance for more information on using the CreateServiceInstance
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateServiceInstanceRequest method.
//	req, resp := client.CreateServiceInstanceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/CreateServiceInstance
func (c *Proton) CreateServiceInstanceRequest(input *CreateServiceInstanceInput) (req *request.Request, output *CreateServiceInstanceOutput) {
	op := &request.Operation{
		Name:       opCreateServiceInstance,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateServiceInstanceInput{}
	}

	output = &CreateServiceInstanceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateServiceInstance API operation for AWS Proton.
//
// Create a service instance.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Proton's
// API operation CreateServiceInstance for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The input is invalid or an out-of-range value was supplied for the input
//     parameter.
//
//   - AccessDeniedException
//     There isn't sufficient access for performing this action.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ConflictException
//     The request couldn't be made due to a conflicting operation or resource.
//
//   - ResourceNotFoundException
//     The requested resource wasn't found.
//
//   - InternalServerException
//     The request failed to register with the service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/CreateServiceInstance
func (c *Proton) CreateServiceInstance(input *CreateServiceInstanceInput) (*CreateServiceInstanceOutput, error) {
	req, out := c.CreateServiceInstanceRequest(input)
	return out, req.Send()
}

// CreateServiceInstanceWithContext is the same as CreateServiceInstance with the addition of
// the ability to pass a context and additional request options.
//
// See CreateServiceInstance for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Proton) CreateServiceInstanceWithContext(ctx aws.Context, input *CreateServiceInstanceInput, opts ...request.Option) (*CreateServiceInstanceOutput, error) {
	req, out := c.CreateServiceInstanceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateServiceSyncConfig = "CreateServiceSyncConfig"

// CreateServiceSyncConfigRequest generates a "aws/request.Request" representing the
// client's request for the CreateServiceSyncConfig operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateServiceSyncConfig for more information on using the CreateServiceSyncConfig
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateServiceSyncConfigRequest method.
//	req, resp := client.CreateServiceSyncConfigRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/CreateServiceSyncConfig
func (c *Proton) CreateServiceSyncConfigRequest(input *CreateServiceSyncConfigInput) (req *request.Request, output *CreateServiceSyncConfigOutput) {
	op := &request.Operation{
		Name:       opCreateServiceSyncConfig,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateServiceSyncConfigInput{}
	}

	output = &CreateServiceSyncConfigOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateServiceSyncConfig API operation for AWS Proton.
//
// Create the Proton Ops configuration file.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Proton's
// API operation CreateServiceSyncConfig for usage and error information.
//
// Returned Error Types:
//
//   - ServiceQuotaExceededException
//     A quota was exceeded. For more information, see Proton Quotas (https://docs.aws.amazon.com/proton/latest/userguide/ag-limits.html)
//     in the Proton User Guide.
//
//   - ValidationException
//     The input is invalid or an out-of-range value was supplied for the input
//     parameter.
//
//   - AccessDeniedException
//     There isn't sufficient access for performing this action.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ConflictException
//     The request couldn't be made due to a conflicting operation or resource.
//
//   - InternalServerException
//     The request failed to register with the service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/CreateServiceSyncConfig
func (c *Proton) CreateServiceSyncConfig(input *CreateServiceSyncConfigInput) (*CreateServiceSyncConfigOutput, error) {
	req, out := c.CreateServiceSyncConfigRequest(input)
	return out, req.Send()
}

// CreateServiceSyncConfigWithContext is the same as CreateServiceSyncConfig with the addition of
// the ability to pass a context and additional request options.
//
// See CreateServiceSyncConfig for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Proton) CreateServiceSyncConfigWithContext(ctx aws.Context, input *CreateServiceSyncConfigInput, opts ...request.Option) (*CreateServiceSyncConfigOutput, error) {
	req, out := c.CreateServiceSyncConfigRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateServiceTemplate = "CreateServiceTemplate"

// CreateServiceTemplateRequest generates a "aws/request.Request" representing the
// client's request for the CreateServiceTemplate operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateServiceTemplate for more information on using the CreateServiceTemplate
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateServiceTemplateRequest method.
//	req, resp := client.CreateServiceTemplateRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/CreateServiceTemplate
func (c *Proton) CreateServiceTemplateRequest(input *CreateServiceTemplateInput) (req *request.Request, output *CreateServiceTemplateOutput) {
	op := &request.Operation{
		Name:       opCreateServiceTemplate,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateServiceTemplateInput{}
	}

	output = &CreateServiceTemplateOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateServiceTemplate API operation for AWS Proton.
//
// Create a service template. The administrator creates a service template to
// define standardized infrastructure and an optional CI/CD service pipeline.
// Developers, in turn, select the service template from Proton. If the selected
// service template includes a service pipeline definition, they provide a link
// to their source code repository. Proton then deploys and manages the infrastructure
// defined by the selected service template. For more information, see Proton
// templates (https://docs.aws.amazon.com/proton/latest/userguide/ag-templates.html)
// in the Proton User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Proton's
// API operation CreateServiceTemplate for usage and error information.
//
// Returned Error Types:
//
//   - ServiceQuotaExceededException
//     A quota was exceeded. For more information, see Proton Quotas (https://docs.aws.amazon.com/proton/latest/userguide/ag-limits.html)
//     in the Proton User Guide.
//
//   - ValidationException
//     The input is invalid or an out-of-range value was supplied for the input
//     parameter.
//
//   - AccessDeniedException
//     There isn't sufficient access for performing this action.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ConflictException
//     The request couldn't be made due to a conflicting operation or resource.
//
//   - InternalServerException
//     The request failed to register with the service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/CreateServiceTemplate
func (c *Proton) CreateServiceTemplate(input *CreateServiceTemplateInput) (*CreateServiceTemplateOutput, error) {
	req, out := c.CreateServiceTemplateRequest(input)
	return out, req.Send()
}

// CreateServiceTemplateWithContext is the same as CreateServiceTemplate with the addition of
// the ability to pass a context and additional request options.
//
// See CreateServiceTemplate for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Proton) CreateServiceTemplateWithContext(ctx aws.Context, input *CreateServiceTemplateInput, opts ...request.Option) (*CreateServiceTemplateOutput, error) {
	req, out := c.CreateServiceTemplateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateServiceTemplateVersion = "CreateServiceTemplateVersion"

// CreateServiceTemplateVersionRequest generates a "aws/request.Request" representing the
// client's request for the CreateServiceTemplateVersion operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateServiceTemplateVersion for more information on using the CreateServiceTemplateVersion
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateServiceTemplateVersionRequest method.
//	req, resp := client.CreateServiceTemplateVersionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/CreateServiceTemplateVersion
func (c *Proton) CreateServiceTemplateVersionRequest(input *CreateServiceTemplateVersionInput) (req *request.Request, output *CreateServiceTemplateVersionOutput) {
	op := &request.Operation{
		Name:       opCreateServiceTemplateVersion,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateServiceTemplateVersionInput{}
	}

	output = &CreateServiceTemplateVersionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateServiceTemplateVersion API operation for AWS Proton.
//
// Create a new major or minor version of a service template. A major version
// of a service template is a version that isn't backward compatible. A minor
// version of a service template is a version that's backward compatible within
// its major version.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Proton's
// API operation CreateServiceTemplateVersion for usage and error information.
//
// Returned Error Types:
//
//   - ServiceQuotaExceededException
//     A quota was exceeded. For more information, see Proton Quotas (https://docs.aws.amazon.com/proton/latest/userguide/ag-limits.html)
//     in the Proton User Guide.
//
//   - ValidationException
//     The input is invalid or an out-of-range value was supplied for the input
//     parameter.
//
//   - AccessDeniedException
//     There isn't sufficient access for performing this action.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ConflictException
//     The request couldn't be made due to a conflicting operation or resource.
//
//   - ResourceNotFoundException
//     The requested resource wasn't found.
//
//   - InternalServerException
//     The request failed to register with the service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/CreateServiceTemplateVersion
func (c *Proton) CreateServiceTemplateVersion(input *CreateServiceTemplateVersionInput) (*CreateServiceTemplateVersionOutput, error) {
	req, out := c.CreateServiceTemplateVersionRequest(input)
	return out, req.Send()
}

// CreateServiceTemplateVersionWithContext is the same as CreateServiceTemplateVersion with the addition of
// the ability to pass a context and additional request options.
//
// See CreateServiceTemplateVersion for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Proton) CreateServiceTemplateVersionWithContext(ctx aws.Context, input *CreateServiceTemplateVersionInput, opts ...request.Option) (*CreateServiceTemplateVersionOutput, error) {
	req, out := c.CreateServiceTemplateVersionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateTemplateSyncConfig = "CreateTemplateSyncConfig"

// CreateTemplateSyncConfigRequest generates a "aws/request.Request" representing the
// client's request for the CreateTemplateSyncConfig operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateTemplateSyncConfig for more information on using the CreateTemplateSyncConfig
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateTemplateSyncConfigRequest method.
//	req, resp := client.CreateTemplateSyncConfigRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/CreateTemplateSyncConfig
func (c *Proton) CreateTemplateSyncConfigRequest(input *CreateTemplateSyncConfigInput) (req *request.Request, output *CreateTemplateSyncConfigOutput) {
	op := &request.Operation{
		Name:       opCreateTemplateSyncConfig,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateTemplateSyncConfigInput{}
	}

	output = &CreateTemplateSyncConfigOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateTemplateSyncConfig API operation for AWS Proton.
//
// Set up a template to create new template versions automatically by tracking
// a linked repository. A linked repository is a repository that has been registered
// with Proton. For more information, see CreateRepository.
//
// When a commit is pushed to your linked repository, Proton checks for changes
// to your repository template bundles. If it detects a template bundle change,
// a new major or minor version of its template is created, if the version doesn’t
// already exist. For more information, see Template sync configurations (https://docs.aws.amazon.com/proton/latest/userguide/ag-template-sync-configs.html)
// in the Proton User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Proton's
// API operation CreateTemplateSyncConfig for usage and error information.
//
// Returned Error Types:
//
//   - ServiceQuotaExceededException
//     A quota was exceeded. For more information, see Proton Quotas (https://docs.aws.amazon.com/proton/latest/userguide/ag-limits.html)
//     in the Proton User Guide.
//
//   - ValidationException
//     The input is invalid or an out-of-range value was supplied for the input
//     parameter.
//
//   - AccessDeniedException
//     There isn't sufficient access for performing this action.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ConflictException
//     The request couldn't be made due to a conflicting operation or resource.
//
//   - InternalServerException
//     The request failed to register with the service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/CreateTemplateSyncConfig
func (c *Proton) CreateTemplateSyncConfig(input *CreateTemplateSyncConfigInput) (*CreateTemplateSyncConfigOutput, error) {
	req, out := c.CreateTemplateSyncConfigRequest(input)
	return out, req.Send()
}

// CreateTemplateSyncConfigWithContext is the same as CreateTemplateSyncConfig with the addition of
// the ability to pass a context and additional request options.
//
// See CreateTemplateSyncConfig for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Proton) CreateTemplateSyncConfigWithContext(ctx aws.Context, input *CreateTemplateSyncConfigInput, opts ...request.Option) (*CreateTemplateSyncConfigOutput, error) {
	req, out := c.CreateTemplateSyncConfigRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteComponent = "DeleteComponent"

// DeleteComponentRequest generates a "aws/request.Request" representing the
// client's request for the DeleteComponent operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteComponent for more information on using the DeleteComponent
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteComponentRequest method.
//	req, resp := client.DeleteComponentRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/DeleteComponent
func (c *Proton) DeleteComponentRequest(input *DeleteComponentInput) (req *request.Request, output *DeleteComponentOutput) {
	op := &request.Operation{
		Name:       opDeleteComponent,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteComponentInput{}
	}

	output = &DeleteComponentOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteComponent API operation for AWS Proton.
//
// Delete an Proton component resource.
//
// For more information about components, see Proton components (https://docs.aws.amazon.com/proton/latest/userguide/ag-components.html)
// in the Proton User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Proton's
// API operation DeleteComponent for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The input is invalid or an out-of-range value was supplied for the input
//     parameter.
//
//   - AccessDeniedException
//     There isn't sufficient access for performing this action.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ConflictException
//     The request couldn't be made due to a conflicting operation or resource.
//
//   - ResourceNotFoundException
//     The requested resource wasn't found.
//
//   - InternalServerException
//     The request failed to register with the service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/DeleteComponent
func (c *Proton) DeleteComponent(input *DeleteComponentInput) (*DeleteComponentOutput, error) {
	req, out := c.DeleteComponentRequest(input)
	return out, req.Send()
}

// DeleteComponentWithContext is the same as DeleteComponent with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteComponent for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Proton) DeleteComponentWithContext(ctx aws.Context, input *DeleteComponentInput, opts ...request.Option) (*DeleteComponentOutput, error) {
	req, out := c.DeleteComponentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteDeployment = "DeleteDeployment"

// DeleteDeploymentRequest generates a "aws/request.Request" representing the
// client's request for the DeleteDeployment operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteDeployment for more information on using the DeleteDeployment
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteDeploymentRequest method.
//	req, resp := client.DeleteDeploymentRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/DeleteDeployment
func (c *Proton) DeleteDeploymentRequest(input *DeleteDeploymentInput) (req *request.Request, output *DeleteDeploymentOutput) {
	op := &request.Operation{
		Name:       opDeleteDeployment,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteDeploymentInput{}
	}

	output = &DeleteDeploymentOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteDeployment API operation for AWS Proton.
//
// Delete the deployment.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Proton's
// API operation DeleteDeployment for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The input is invalid or an out-of-range value was supplied for the input
//     parameter.
//
//   - AccessDeniedException
//     There isn't sufficient access for performing this action.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ResourceNotFoundException
//     The requested resource wasn't found.
//
//   - InternalServerException
//     The request failed to register with the service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/DeleteDeployment
func (c *Proton) DeleteDeployment(input *DeleteDeploymentInput) (*DeleteDeploymentOutput, error) {
	req, out := c.DeleteDeploymentRequest(input)
	return out, req.Send()
}

// DeleteDeploymentWithContext is the same as DeleteDeployment with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteDeployment for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Proton) DeleteDeploymentWithContext(ctx aws.Context, input *DeleteDeploymentInput, opts ...request.Option) (*DeleteDeploymentOutput, error) {
	req, out := c.DeleteDeploymentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteEnvironment = "DeleteEnvironment"

// DeleteEnvironmentRequest generates a "aws/request.Request" representing the
// client's request for the DeleteEnvironment operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteEnvironment for more information on using the DeleteEnvironment
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteEnvironmentRequest method.
//	req, resp := client.DeleteEnvironmentRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/DeleteEnvironment
func (c *Proton) DeleteEnvironmentRequest(input *DeleteEnvironmentInput) (req *request.Request, output *DeleteEnvironmentOutput) {
	op := &request.Operation{
		Name:       opDeleteEnvironment,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteEnvironmentInput{}
	}

	output = &DeleteEnvironmentOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteEnvironment API operation for AWS Proton.
//
// Delete an environment.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Proton's
// API operation DeleteEnvironment for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The input is invalid or an out-of-range value was supplied for the input
//     parameter.
//
//   - AccessDeniedException
//     There isn't sufficient access for performing this action.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ConflictException
//     The request couldn't be made due to a conflicting operation or resource.
//
//   - ResourceNotFoundException
//     The requested resource wasn't found.
//
//   - InternalServerException
//     The request failed to register with the service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/DeleteEnvironment
func (c *Proton) DeleteEnvironment(input *DeleteEnvironmentInput) (*DeleteEnvironmentOutput, error) {
	req, out := c.DeleteEnvironmentRequest(input)
	return out, req.Send()
}

// DeleteEnvironmentWithContext is the same as DeleteEnvironment with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteEnvironment for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Proton) DeleteEnvironmentWithContext(ctx aws.Context, input *DeleteEnvironmentInput, opts ...request.Option) (*DeleteEnvironmentOutput, error) {
	req, out := c.DeleteEnvironmentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteEnvironmentAccountConnection = "DeleteEnvironmentAccountConnection"

// DeleteEnvironmentAccountConnectionRequest generates a "aws/request.Request" representing the
// client's request for the DeleteEnvironmentAccountConnection operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteEnvironmentAccountConnection for more information on using the DeleteEnvironmentAccountConnection
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteEnvironmentAccountConnectionRequest method.
//	req, resp := client.DeleteEnvironmentAccountConnectionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/DeleteEnvironmentAccountConnection
func (c *Proton) DeleteEnvironmentAccountConnectionRequest(input *DeleteEnvironmentAccountConnectionInput) (req *request.Request, output *DeleteEnvironmentAccountConnectionOutput) {
	op := &request.Operation{
		Name:       opDeleteEnvironmentAccountConnection,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteEnvironmentAccountConnectionInput{}
	}

	output = &DeleteEnvironmentAccountConnectionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteEnvironmentAccountConnection API operation for AWS Proton.
//
// In an environment account, delete an environment account connection.
//
// After you delete an environment account connection that’s in use by an
// Proton environment, Proton can’t manage the environment infrastructure
// resources until a new environment account connection is accepted for the
// environment account and associated environment. You're responsible for cleaning
// up provisioned resources that remain without an environment connection.
//
// For more information, see Environment account connections (https://docs.aws.amazon.com/proton/latest/userguide/ag-env-account-connections.html)
// in the Proton User guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Proton's
// API operation DeleteEnvironmentAccountConnection for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The input is invalid or an out-of-range value was supplied for the input
//     parameter.
//
//   - AccessDeniedException
//     There isn't sufficient access for performing this action.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ConflictException
//     The request couldn't be made due to a conflicting operation or resource.
//
//   - ResourceNotFoundException
//     The requested resource wasn't found.
//
//   - InternalServerException
//     The request failed to register with the service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/DeleteEnvironmentAccountConnection
func (c *Proton) DeleteEnvironmentAccountConnection(input *DeleteEnvironmentAccountConnectionInput) (*DeleteEnvironmentAccountConnectionOutput, error) {
	req, out := c.DeleteEnvironmentAccountConnectionRequest(input)
	return out, req.Send()
}

// DeleteEnvironmentAccountConnectionWithContext is the same as DeleteEnvironmentAccountConnection with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteEnvironmentAccountConnection for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Proton) DeleteEnvironmentAccountConnectionWithContext(ctx aws.Context, input *DeleteEnvironmentAccountConnectionInput, opts ...request.Option) (*DeleteEnvironmentAccountConnectionOutput, error) {
	req, out := c.DeleteEnvironmentAccountConnectionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteEnvironmentTemplate = "DeleteEnvironmentTemplate"

// DeleteEnvironmentTemplateRequest generates a "aws/request.Request" representing the
// client's request for the DeleteEnvironmentTemplate operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteEnvironmentTemplate for more information on using the DeleteEnvironmentTemplate
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteEnvironmentTemplateRequest method.
//	req, resp := client.DeleteEnvironmentTemplateRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/DeleteEnvironmentTemplate
func (c *Proton) DeleteEnvironmentTemplateRequest(input *DeleteEnvironmentTemplateInput) (req *request.Request, output *DeleteEnvironmentTemplateOutput) {
	op := &request.Operation{
		Name:       opDeleteEnvironmentTemplate,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteEnvironmentTemplateInput{}
	}

	output = &DeleteEnvironmentTemplateOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteEnvironmentTemplate API operation for AWS Proton.
//
// If no other major or minor versions of an environment template exist, delete
// the environment template.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Proton's
// API operation DeleteEnvironmentTemplate for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The input is invalid or an out-of-range value was supplied for the input
//     parameter.
//
//   - AccessDeniedException
//     There isn't sufficient access for performing this action.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ConflictException
//     The request couldn't be made due to a conflicting operation or resource.
//
//   - ResourceNotFoundException
//     The requested resource wasn't found.
//
//   - InternalServerException
//     The request failed to register with the service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/DeleteEnvironmentTemplate
func (c *Proton) DeleteEnvironmentTemplate(input *DeleteEnvironmentTemplateInput) (*DeleteEnvironmentTemplateOutput, error) {
	req, out := c.DeleteEnvironmentTemplateRequest(input)
	return out, req.Send()
}

// DeleteEnvironmentTemplateWithContext is the same as DeleteEnvironmentTemplate with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteEnvironmentTemplate for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Proton) DeleteEnvironmentTemplateWithContext(ctx aws.Context, input *DeleteEnvironmentTemplateInput, opts ...request.Option) (*DeleteEnvironmentTemplateOutput, error) {
	req, out := c.DeleteEnvironmentTemplateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteEnvironmentTemplateVersion = "DeleteEnvironmentTemplateVersion"

// DeleteEnvironmentTemplateVersionRequest generates a "aws/request.Request" representing the
// client's request for the DeleteEnvironmentTemplateVersion operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteEnvironmentTemplateVersion for more information on using the DeleteEnvironmentTemplateVersion
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteEnvironmentTemplateVersionRequest method.
//	req, resp := client.DeleteEnvironmentTemplateVersionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/DeleteEnvironmentTemplateVersion
func (c *Proton) DeleteEnvironmentTemplateVersionRequest(input *DeleteEnvironmentTemplateVersionInput) (req *request.Request, output *DeleteEnvironmentTemplateVersionOutput) {
	op := &request.Operation{
		Name:       opDeleteEnvironmentTemplateVersion,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteEnvironmentTemplateVersionInput{}
	}

	output = &DeleteEnvironmentTemplateVersionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteEnvironmentTemplateVersion API operation for AWS Proton.
//
// If no other minor versions of an environment template exist, delete a major
// version of the environment template if it's not the Recommended version.
// Delete the Recommended version of the environment template if no other major
// versions or minor versions of the environment template exist. A major version
// of an environment template is a version that's not backward compatible.
//
// Delete a minor version of an environment template if it isn't the Recommended
// version. Delete a Recommended minor version of the environment template if
// no other minor versions of the environment template exist. A minor version
// of an environment template is a version that's backward compatible.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Proton's
// API operation DeleteEnvironmentTemplateVersion for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The input is invalid or an out-of-range value was supplied for the input
//     parameter.
//
//   - AccessDeniedException
//     There isn't sufficient access for performing this action.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ConflictException
//     The request couldn't be made due to a conflicting operation or resource.
//
//   - ResourceNotFoundException
//     The requested resource wasn't found.
//
//   - InternalServerException
//     The request failed to register with the service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/DeleteEnvironmentTemplateVersion
func (c *Proton) DeleteEnvironmentTemplateVersion(input *DeleteEnvironmentTemplateVersionInput) (*DeleteEnvironmentTemplateVersionOutput, error) {
	req, out := c.DeleteEnvironmentTemplateVersionRequest(input)
	return out, req.Send()
}

// DeleteEnvironmentTemplateVersionWithContext is the same as DeleteEnvironmentTemplateVersion with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteEnvironmentTemplateVersion for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Proton) DeleteEnvironmentTemplateVersionWithContext(ctx aws.Context, input *DeleteEnvironmentTemplateVersionInput, opts ...request.Option) (*DeleteEnvironmentTemplateVersionOutput, error) {
	req, out := c.DeleteEnvironmentTemplateVersionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteRepository = "DeleteRepository"

// DeleteRepositoryRequest generates a "aws/request.Request" representing the
// client's request for the DeleteRepository operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteRepository for more information on using the DeleteRepository
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteRepositoryRequest method.
//	req, resp := client.DeleteRepositoryRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/DeleteRepository
func (c *Proton) DeleteRepositoryRequest(input *DeleteRepositoryInput) (req *request.Request, output *DeleteRepositoryOutput) {
	op := &request.Operation{
		Name:       opDeleteRepository,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteRepositoryInput{}
	}

	output = &DeleteRepositoryOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteRepository API operation for AWS Proton.
//
// De-register and unlink your repository.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Proton's
// API operation DeleteRepository for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The input is invalid or an out-of-range value was supplied for the input
//     parameter.
//
//   - AccessDeniedException
//     There isn't sufficient access for performing this action.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ConflictException
//     The request couldn't be made due to a conflicting operation or resource.
//
//   - ResourceNotFoundException
//     The requested resource wasn't found.
//
//   - InternalServerException
//     The request failed to register with the service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/DeleteRepository
func (c *Proton) DeleteRepository(input *DeleteRepositoryInput) (*DeleteRepositoryOutput, error) {
	req, out := c.DeleteRepositoryRequest(input)
	return out, req.Send()
}

// DeleteRepositoryWithContext is the same as DeleteRepository with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteRepository for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Proton) DeleteRepositoryWithContext(ctx aws.Context, input *DeleteRepositoryInput, opts ...request.Option) (*DeleteRepositoryOutput, error) {
	req, out := c.DeleteRepositoryRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteService = "DeleteService"

// DeleteServiceRequest generates a "aws/request.Request" representing the
// client's request for the DeleteService operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteService for more information on using the DeleteService
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteServiceRequest method.
//	req, resp := client.DeleteServiceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/DeleteService
func (c *Proton) DeleteServiceRequest(input *DeleteServiceInput) (req *request.Request, output *DeleteServiceOutput) {
	op := &request.Operation{
		Name:       opDeleteService,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteServiceInput{}
	}

	output = &DeleteServiceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteService API operation for AWS Proton.
//
// Delete a service, with its instances and pipeline.
//
// You can't delete a service if it has any service instances that have components
// attached to them.
//
// For more information about components, see Proton components (https://docs.aws.amazon.com/proton/latest/userguide/ag-components.html)
// in the Proton User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Proton's
// API operation DeleteService for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The input is invalid or an out-of-range value was supplied for the input
//     parameter.
//
//   - AccessDeniedException
//     There isn't sufficient access for performing this action.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ConflictException
//     The request couldn't be made due to a conflicting operation or resource.
//
//   - ResourceNotFoundException
//     The requested resource wasn't found.
//
//   - InternalServerException
//     The request failed to register with the service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/DeleteService
func (c *Proton) DeleteService(input *DeleteServiceInput) (*DeleteServiceOutput, error) {
	req, out := c.DeleteServiceRequest(input)
	return out, req.Send()
}

// DeleteServiceWithContext is the same as DeleteService with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteService for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Proton) DeleteServiceWithContext(ctx aws.Context, input *DeleteServiceInput, opts ...request.Option) (*DeleteServiceOutput, error) {
	req, out := c.DeleteServiceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteServiceSyncConfig = "DeleteServiceSyncConfig"

// DeleteServiceSyncConfigRequest generates a "aws/request.Request" representing the
// client's request for the DeleteServiceSyncConfig operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteServiceSyncConfig for more information on using the DeleteServiceSyncConfig
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteServiceSyncConfigRequest method.
//	req, resp := client.DeleteServiceSyncConfigRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/DeleteServiceSyncConfig
func (c *Proton) DeleteServiceSyncConfigRequest(input *DeleteServiceSyncConfigInput) (req *request.Request, output *DeleteServiceSyncConfigOutput) {
	op := &request.Operation{
		Name:       opDeleteServiceSyncConfig,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteServiceSyncConfigInput{}
	}

	output = &DeleteServiceSyncConfigOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteServiceSyncConfig API operation for AWS Proton.
//
// Delete the Proton Ops file.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Proton's
// API operation DeleteServiceSyncConfig for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The input is invalid or an out-of-range value was supplied for the input
//     parameter.
//
//   - AccessDeniedException
//     There isn't sufficient access for performing this action.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ConflictException
//     The request couldn't be made due to a conflicting operation or resource.
//
//   - ResourceNotFoundException
//     The requested resource wasn't found.
//
//   - InternalServerException
//     The request failed to register with the service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/DeleteServiceSyncConfig
func (c *Proton) DeleteServiceSyncConfig(input *DeleteServiceSyncConfigInput) (*DeleteServiceSyncConfigOutput, error) {
	req, out := c.DeleteServiceSyncConfigRequest(input)
	return out, req.Send()
}

// DeleteServiceSyncConfigWithContext is the same as DeleteServiceSyncConfig with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteServiceSyncConfig for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Proton) DeleteServiceSyncConfigWithContext(ctx aws.Context, input *DeleteServiceSyncConfigInput, opts ...request.Option) (*DeleteServiceSyncConfigOutput, error) {
	req, out := c.DeleteServiceSyncConfigRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteServiceTemplate = "DeleteServiceTemplate"

// DeleteServiceTemplateRequest generates a "aws/request.Request" representing the
// client's request for the DeleteServiceTemplate operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteServiceTemplate for more information on using the DeleteServiceTemplate
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteServiceTemplateRequest method.
//	req, resp := client.DeleteServiceTemplateRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/DeleteServiceTemplate
func (c *Proton) DeleteServiceTemplateRequest(input *DeleteServiceTemplateInput) (req *request.Request, output *DeleteServiceTemplateOutput) {
	op := &request.Operation{
		Name:       opDeleteServiceTemplate,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteServiceTemplateInput{}
	}

	output = &DeleteServiceTemplateOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteServiceTemplate API operation for AWS Proton.
//
// If no other major or minor versions of the service template exist, delete
// the service template.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Proton's
// API operation DeleteServiceTemplate for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The input is invalid or an out-of-range value was supplied for the input
//     parameter.
//
//   - AccessDeniedException
//     There isn't sufficient access for performing this action.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ConflictException
//     The request couldn't be made due to a conflicting operation or resource.
//
//   - ResourceNotFoundException
//     The requested resource wasn't found.
//
//   - InternalServerException
//     The request failed to register with the service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/DeleteServiceTemplate
func (c *Proton) DeleteServiceTemplate(input *DeleteServiceTemplateInput) (*DeleteServiceTemplateOutput, error) {
	req, out := c.DeleteServiceTemplateRequest(input)
	return out, req.Send()
}

// DeleteServiceTemplateWithContext is the same as DeleteServiceTemplate with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteServiceTemplate for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Proton) DeleteServiceTemplateWithContext(ctx aws.Context, input *DeleteServiceTemplateInput, opts ...request.Option) (*DeleteServiceTemplateOutput, error) {
	req, out := c.DeleteServiceTemplateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteServiceTemplateVersion = "DeleteServiceTemplateVersion"

// DeleteServiceTemplateVersionRequest generates a "aws/request.Request" representing the
// client's request for the DeleteServiceTemplateVersion operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteServiceTemplateVersion for more information on using the DeleteServiceTemplateVersion
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteServiceTemplateVersionRequest method.
//	req, resp := client.DeleteServiceTemplateVersionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/DeleteServiceTemplateVersion
func (c *Proton) DeleteServiceTemplateVersionRequest(input *DeleteServiceTemplateVersionInput) (req *request.Request, output *DeleteServiceTemplateVersionOutput) {
	op := &request.Operation{
		Name:       opDeleteServiceTemplateVersion,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteServiceTemplateVersionInput{}
	}

	output = &DeleteServiceTemplateVersionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteServiceTemplateVersion API operation for AWS Proton.
//
// If no other minor versions of a service template exist, delete a major version
// of the service template if it's not the Recommended version. Delete the Recommended
// version of the service template if no other major versions or minor versions
// of the service template exist. A major version of a service template is a
// version that isn't backwards compatible.
//
// Delete a minor version of a service template if it's not the Recommended
// version. Delete a Recommended minor version of the service template if no
// other minor versions of the service template exist. A minor version of a
// service template is a version that's backwards compatible.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Proton's
// API operation DeleteServiceTemplateVersion for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The input is invalid or an out-of-range value was supplied for the input
//     parameter.
//
//   - AccessDeniedException
//     There isn't sufficient access for performing this action.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ConflictException
//     The request couldn't be made due to a conflicting operation or resource.
//
//   - ResourceNotFoundException
//     The requested resource wasn't found.
//
//   - InternalServerException
//     The request failed to register with the service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/DeleteServiceTemplateVersion
func (c *Proton) DeleteServiceTemplateVersion(input *DeleteServiceTemplateVersionInput) (*DeleteServiceTemplateVersionOutput, error) {
	req, out := c.DeleteServiceTemplateVersionRequest(input)
	return out, req.Send()
}

// DeleteServiceTemplateVersionWithContext is the same as DeleteServiceTemplateVersion with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteServiceTemplateVersion for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Proton) DeleteServiceTemplateVersionWithContext(ctx aws.Context, input *DeleteServiceTemplateVersionInput, opts ...request.Option) (*DeleteServiceTemplateVersionOutput, error) {
	req, out := c.DeleteServiceTemplateVersionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteTemplateSyncConfig = "DeleteTemplateSyncConfig"

// DeleteTemplateSyncConfigRequest generates a "aws/request.Request" representing the
// client's request for the DeleteTemplateSyncConfig operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteTemplateSyncConfig for more information on using the DeleteTemplateSyncConfig
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteTemplateSyncConfigRequest method.
//	req, resp := client.DeleteTemplateSyncConfigRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/DeleteTemplateSyncConfig
func (c *Proton) DeleteTemplateSyncConfigRequest(input *DeleteTemplateSyncConfigInput) (req *request.Request, output *DeleteTemplateSyncConfigOutput) {
	op := &request.Operation{
		Name:       opDeleteTemplateSyncConfig,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteTemplateSyncConfigInput{}
	}

	output = &DeleteTemplateSyncConfigOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteTemplateSyncConfig API operation for AWS Proton.
//
// Delete a template sync configuration.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Proton's
// API operation DeleteTemplateSyncConfig for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The input is invalid or an out-of-range value was supplied for the input
//     parameter.
//
//   - AccessDeniedException
//     There isn't sufficient access for performing this action.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ConflictException
//     The request couldn't be made due to a conflicting operation or resource.
//
//   - ResourceNotFoundException
//     The requested resource wasn't found.
//
//   - InternalServerException
//     The request failed to register with the service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/DeleteTemplateSyncConfig
func (c *Proton) DeleteTemplateSyncConfig(input *DeleteTemplateSyncConfigInput) (*DeleteTemplateSyncConfigOutput, error) {
	req, out := c.DeleteTemplateSyncConfigRequest(input)
	return out, req.Send()
}

// DeleteTemplateSyncConfigWithContext is the same as DeleteTemplateSyncConfig with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteTemplateSyncConfig for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Proton) DeleteTemplateSyncConfigWithContext(ctx aws.Context, input *DeleteTemplateSyncConfigInput, opts ...request.Option) (*DeleteTemplateSyncConfigOutput, error) {
	req, out := c.DeleteTemplateSyncConfigRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetAccountSettings = "GetAccountSettings"

// GetAccountSettingsRequest generates a "aws/request.Request" representing the
// client's request for the GetAccountSettings operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetAccountSettings for more information on using the GetAccountSettings
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetAccountSettingsRequest method.
//	req, resp := client.GetAccountSettingsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/GetAccountSettings
func (c *Proton) GetAccountSettingsRequest(input *GetAccountSettingsInput) (req *request.Request, output *GetAccountSettingsOutput) {
	op := &request.Operation{
		Name:       opGetAccountSettings,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetAccountSettingsInput{}
	}

	output = &GetAccountSettingsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetAccountSettings API operation for AWS Proton.
//
// Get detail data for Proton account-wide settings.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Proton's
// API operation GetAccountSettings for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The input is invalid or an out-of-range value was supplied for the input
//     parameter.
//
//   - AccessDeniedException
//     There isn't sufficient access for performing this action.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ResourceNotFoundException
//     The requested resource wasn't found.
//
//   - InternalServerException
//     The request failed to register with the service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/GetAccountSettings
func (c *Proton) GetAccountSettings(input *GetAccountSettingsInput) (*GetAccountSettingsOutput, error) {
	req, out := c.GetAccountSettingsRequest(input)
	return out, req.Send()
}

// GetAccountSettingsWithContext is the same as GetAccountSettings with the addition of
// the ability to pass a context and additional request options.
//
// See GetAccountSettings for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Proton) GetAccountSettingsWithContext(ctx aws.Context, input *GetAccountSettingsInput, opts ...request.Option) (*GetAccountSettingsOutput, error) {
	req, out := c.GetAccountSettingsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetComponent = "GetComponent"

// GetComponentRequest generates a "aws/request.Request" representing the
// client's request for the GetComponent operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetComponent for more information on using the GetComponent
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetComponentRequest method.
//	req, resp := client.GetComponentRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/GetComponent
func (c *Proton) GetComponentRequest(input *GetComponentInput) (req *request.Request, output *GetComponentOutput) {
	op := &request.Operation{
		Name:       opGetComponent,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetComponentInput{}
	}

	output = &GetComponentOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetComponent API operation for AWS Proton.
//
// Get detailed data for a component.
//
// For more information about components, see Proton components (https://docs.aws.amazon.com/proton/latest/userguide/ag-components.html)
// in the Proton User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Proton's
// API operation GetComponent for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The input is invalid or an out-of-range value was supplied for the input
//     parameter.
//
//   - AccessDeniedException
//     There isn't sufficient access for performing this action.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ResourceNotFoundException
//     The requested resource wasn't found.
//
//   - InternalServerException
//     The request failed to register with the service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/GetComponent
func (c *Proton) GetComponent(input *GetComponentInput) (*GetComponentOutput, error) {
	req, out := c.GetComponentRequest(input)
	return out, req.Send()
}

// GetComponentWithContext is the same as GetComponent with the addition of
// the ability to pass a context and additional request options.
//
// See GetComponent for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Proton) GetComponentWithContext(ctx aws.Context, input *GetComponentInput, opts ...request.Option) (*GetComponentOutput, error) {
	req, out := c.GetComponentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetDeployment = "GetDeployment"

// GetDeploymentRequest generates a "aws/request.Request" representing the
// client's request for the GetDeployment operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetDeployment for more information on using the GetDeployment
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetDeploymentRequest method.
//	req, resp := client.GetDeploymentRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/GetDeployment
func (c *Proton) GetDeploymentRequest(input *GetDeploymentInput) (req *request.Request, output *GetDeploymentOutput) {
	op := &request.Operation{
		Name:       opGetDeployment,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetDeploymentInput{}
	}

	output = &GetDeploymentOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetDeployment API operation for AWS Proton.
//
// Get detailed data for a deployment.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Proton's
// API operation GetDeployment for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The input is invalid or an out-of-range value was supplied for the input
//     parameter.
//
//   - AccessDeniedException
//     There isn't sufficient access for performing this action.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ResourceNotFoundException
//     The requested resource wasn't found.
//
//   - InternalServerException
//     The request failed to register with the service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/GetDeployment
func (c *Proton) GetDeployment(input *GetDeploymentInput) (*GetDeploymentOutput, error) {
	req, out := c.GetDeploymentRequest(input)
	return out, req.Send()
}

// GetDeploymentWithContext is the same as GetDeployment with the addition of
// the ability to pass a context and additional request options.
//
// See GetDeployment for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Proton) GetDeploymentWithContext(ctx aws.Context, input *GetDeploymentInput, opts ...request.Option) (*GetDeploymentOutput, error) {
	req, out := c.GetDeploymentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetEnvironment = "GetEnvironment"

// GetEnvironmentRequest generates a "aws/request.Request" representing the
// client's request for the GetEnvironment operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetEnvironment for more information on using the GetEnvironment
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetEnvironmentRequest method.
//	req, resp := client.GetEnvironmentRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/GetEnvironment
func (c *Proton) GetEnvironmentRequest(input *GetEnvironmentInput) (req *request.Request, output *GetEnvironmentOutput) {
	op := &request.Operation{
		Name:       opGetEnvironment,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetEnvironmentInput{}
	}

	output = &GetEnvironmentOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetEnvironment API operation for AWS Proton.
//
// Get detailed data for an environment.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Proton's
// API operation GetEnvironment for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The input is invalid or an out-of-range value was supplied for the input
//     parameter.
//
//   - AccessDeniedException
//     There isn't sufficient access for performing this action.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ResourceNotFoundException
//     The requested resource wasn't found.
//
//   - InternalServerException
//     The request failed to register with the service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/GetEnvironment
func (c *Proton) GetEnvironment(input *GetEnvironmentInput) (*GetEnvironmentOutput, error) {
	req, out := c.GetEnvironmentRequest(input)
	return out, req.Send()
}

// GetEnvironmentWithContext is the same as GetEnvironment with the addition of
// the ability to pass a context and additional request options.
//
// See GetEnvironment for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Proton) GetEnvironmentWithContext(ctx aws.Context, input *GetEnvironmentInput, opts ...request.Option) (*GetEnvironmentOutput, error) {
	req, out := c.GetEnvironmentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetEnvironmentAccountConnection = "GetEnvironmentAccountConnection"

// GetEnvironmentAccountConnectionRequest generates a "aws/request.Request" representing the
// client's request for the GetEnvironmentAccountConnection operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetEnvironmentAccountConnection for more information on using the GetEnvironmentAccountConnection
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetEnvironmentAccountConnectionRequest method.
//	req, resp := client.GetEnvironmentAccountConnectionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/GetEnvironmentAccountConnection
func (c *Proton) GetEnvironmentAccountConnectionRequest(input *GetEnvironmentAccountConnectionInput) (req *request.Request, output *GetEnvironmentAccountConnectionOutput) {
	op := &request.Operation{
		Name:       opGetEnvironmentAccountConnection,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetEnvironmentAccountConnectionInput{}
	}

	output = &GetEnvironmentAccountConnectionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetEnvironmentAccountConnection API operation for AWS Proton.
//
// In an environment account, get the detailed data for an environment account
// connection.
//
// For more information, see Environment account connections (https://docs.aws.amazon.com/proton/latest/userguide/ag-env-account-connections.html)
// in the Proton User guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Proton's
// API operation GetEnvironmentAccountConnection for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The input is invalid or an out-of-range value was supplied for the input
//     parameter.
//
//   - AccessDeniedException
//     There isn't sufficient access for performing this action.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ResourceNotFoundException
//     The requested resource wasn't found.
//
//   - InternalServerException
//     The request failed to register with the service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/GetEnvironmentAccountConnection
func (c *Proton) GetEnvironmentAccountConnection(input *GetEnvironmentAccountConnectionInput) (*GetEnvironmentAccountConnectionOutput, error) {
	req, out := c.GetEnvironmentAccountConnectionRequest(input)
	return out, req.Send()
}

// GetEnvironmentAccountConnectionWithContext is the same as GetEnvironmentAccountConnection with the addition of
// the ability to pass a context and additional request options.
//
// See GetEnvironmentAccountConnection for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Proton) GetEnvironmentAccountConnectionWithContext(ctx aws.Context, input *GetEnvironmentAccountConnectionInput, opts ...request.Option) (*GetEnvironmentAccountConnectionOutput, error) {
	req, out := c.GetEnvironmentAccountConnectionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetEnvironmentTemplate = "GetEnvironmentTemplate"

// GetEnvironmentTemplateRequest generates a "aws/request.Request" representing the
// client's request for the GetEnvironmentTemplate operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetEnvironmentTemplate for more information on using the GetEnvironmentTemplate
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetEnvironmentTemplateRequest method.
//	req, resp := client.GetEnvironmentTemplateRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/GetEnvironmentTemplate
func (c *Proton) GetEnvironmentTemplateRequest(input *GetEnvironmentTemplateInput) (req *request.Request, output *GetEnvironmentTemplateOutput) {
	op := &request.Operation{
		Name:       opGetEnvironmentTemplate,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetEnvironmentTemplateInput{}
	}

	output = &GetEnvironmentTemplateOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetEnvironmentTemplate API operation for AWS Proton.
//
// Get detailed data for an environment template.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Proton's
// API operation GetEnvironmentTemplate for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The input is invalid or an out-of-range value was supplied for the input
//     parameter.
//
//   - AccessDeniedException
//     There isn't sufficient access for performing this action.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ResourceNotFoundException
//     The requested resource wasn't found.
//
//   - InternalServerException
//     The request failed to register with the service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/GetEnvironmentTemplate
func (c *Proton) GetEnvironmentTemplate(input *GetEnvironmentTemplateInput) (*GetEnvironmentTemplateOutput, error) {
	req, out := c.GetEnvironmentTemplateRequest(input)
	return out, req.Send()
}

// GetEnvironmentTemplateWithContext is the same as GetEnvironmentTemplate with the addition of
// the ability to pass a context and additional request options.
//
// See GetEnvironmentTemplate for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Proton) GetEnvironmentTemplateWithContext(ctx aws.Context, input *GetEnvironmentTemplateInput, opts ...request.Option) (*GetEnvironmentTemplateOutput, error) {
	req, out := c.GetEnvironmentTemplateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetEnvironmentTemplateVersion = "GetEnvironmentTemplateVersion"

// GetEnvironmentTemplateVersionRequest generates a "aws/request.Request" representing the
// client's request for the GetEnvironmentTemplateVersion operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetEnvironmentTemplateVersion for more information on using the GetEnvironmentTemplateVersion
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetEnvironmentTemplateVersionRequest method.
//	req, resp := client.GetEnvironmentTemplateVersionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/GetEnvironmentTemplateVersion
func (c *Proton) GetEnvironmentTemplateVersionRequest(input *GetEnvironmentTemplateVersionInput) (req *request.Request, output *GetEnvironmentTemplateVersionOutput) {
	op := &request.Operation{
		Name:       opGetEnvironmentTemplateVersion,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetEnvironmentTemplateVersionInput{}
	}

	output = &GetEnvironmentTemplateVersionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetEnvironmentTemplateVersion API operation for AWS Proton.
//
// Get detailed data for a major or minor version of an environment template.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Proton's
// API operation GetEnvironmentTemplateVersion for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The input is invalid or an out-of-range value was supplied for the input
//     parameter.
//
//   - AccessDeniedException
//     There isn't sufficient access for performing this action.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ResourceNotFoundException
//     The requested resource wasn't found.
//
//   - InternalServerException
//     The request failed to register with the service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/GetEnvironmentTemplateVersion
func (c *Proton) GetEnvironmentTemplateVersion(input *GetEnvironmentTemplateVersionInput) (*GetEnvironmentTemplateVersionOutput, error) {
	req, out := c.GetEnvironmentTemplateVersionRequest(input)
	return out, req.Send()
}

// GetEnvironmentTemplateVersionWithContext is the same as GetEnvironmentTemplateVersion with the addition of
// the ability to pass a context and additional request options.
//
// See GetEnvironmentTemplateVersion for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Proton) GetEnvironmentTemplateVersionWithContext(ctx aws.Context, input *GetEnvironmentTemplateVersionInput, opts ...request.Option) (*GetEnvironmentTemplateVersionOutput, error) {
	req, out := c.GetEnvironmentTemplateVersionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetRepository = "GetRepository"

// GetRepositoryRequest generates a "aws/request.Request" representing the
// client's request for the GetRepository operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetRepository for more information on using the GetRepository
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetRepositoryRequest method.
//	req, resp := client.GetRepositoryRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/GetRepository
func (c *Proton) GetRepositoryRequest(input *GetRepositoryInput) (req *request.Request, output *GetRepositoryOutput) {
	op := &request.Operation{
		Name:       opGetRepository,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetRepositoryInput{}
	}

	output = &GetRepositoryOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetRepository API operation for AWS Proton.
//
// Get detail data for a linked repository.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Proton's
// API operation GetRepository for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The input is invalid or an out-of-range value was supplied for the input
//     parameter.
//
//   - AccessDeniedException
//     There isn't sufficient access for performing this action.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ResourceNotFoundException
//     The requested resource wasn't found.
//
//   - InternalServerException
//     The request failed to register with the service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/GetRepository
func (c *Proton) GetRepository(input *GetRepositoryInput) (*GetRepositoryOutput, error) {
	req, out := c.GetRepositoryRequest(input)
	return out, req.Send()
}

// GetRepositoryWithContext is the same as GetRepository with the addition of
// the ability to pass a context and additional request options.
//
// See GetRepository for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Proton) GetRepositoryWithContext(ctx aws.Context, input *GetRepositoryInput, opts ...request.Option) (*GetRepositoryOutput, error) {
	req, out := c.GetRepositoryRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetRepositorySyncStatus = "GetRepositorySyncStatus"

// GetRepositorySyncStatusRequest generates a "aws/request.Request" representing the
// client's request for the GetRepositorySyncStatus operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetRepositorySyncStatus for more information on using the GetRepositorySyncStatus
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetRepositorySyncStatusRequest method.
//	req, resp := client.GetRepositorySyncStatusRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/GetRepositorySyncStatus
func (c *Proton) GetRepositorySyncStatusRequest(input *GetRepositorySyncStatusInput) (req *request.Request, output *GetRepositorySyncStatusOutput) {
	op := &request.Operation{
		Name:       opGetRepositorySyncStatus,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetRepositorySyncStatusInput{}
	}

	output = &GetRepositorySyncStatusOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetRepositorySyncStatus API operation for AWS Proton.
//
// Get the sync status of a repository used for Proton template sync. For more
// information about template sync, see .
//
// A repository sync status isn't tied to the Proton Repository resource (or
// any other Proton resource). Therefore, tags on an Proton Repository resource
// have no effect on this action. Specifically, you can't use these tags to
// control access to this action using Attribute-based access control (ABAC).
//
// For more information about ABAC, see ABAC (https://docs.aws.amazon.com/proton/latest/userguide/security_iam_service-with-iam.html#security_iam_service-with-iam-tags)
// in the Proton User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Proton's
// API operation GetRepositorySyncStatus for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The input is invalid or an out-of-range value was supplied for the input
//     parameter.
//
//   - AccessDeniedException
//     There isn't sufficient access for performing this action.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ResourceNotFoundException
//     The requested resource wasn't found.
//
//   - InternalServerException
//     The request failed to register with the service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/GetRepositorySyncStatus
func (c *Proton) GetRepositorySyncStatus(input *GetRepositorySyncStatusInput) (*GetRepositorySyncStatusOutput, error) {
	req, out := c.GetRepositorySyncStatusRequest(input)
	return out, req.Send()
}

// GetRepositorySyncStatusWithContext is the same as GetRepositorySyncStatus with the addition of
// the ability to pass a context and additional request options.
//
// See GetRepositorySyncStatus for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Proton) GetRepositorySyncStatusWithContext(ctx aws.Context, input *GetRepositorySyncStatusInput, opts ...request.Option) (*GetRepositorySyncStatusOutput, error) {
	req, out := c.GetRepositorySyncStatusRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetResourcesSummary = "GetResourcesSummary"

// GetResourcesSummaryRequest generates a "aws/request.Request" representing the
// client's request for the GetResourcesSummary operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetResourcesSummary for more information on using the GetResourcesSummary
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetResourcesSummaryRequest method.
//	req, resp := client.GetResourcesSummaryRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/GetResourcesSummary
func (c *Proton) GetResourcesSummaryRequest(input *GetResourcesSummaryInput) (req *request.Request, output *GetResourcesSummaryOutput) {
	op := &request.Operation{
		Name:       opGetResourcesSummary,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetResourcesSummaryInput{}
	}

	output = &GetResourcesSummaryOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetResourcesSummary API operation for AWS Proton.
//
// Get counts of Proton resources.
//
// For infrastructure-provisioning resources (environments, services, service
// instances, pipelines), the action returns staleness counts. A resource is
// stale when it's behind the recommended version of the Proton template that
// it uses and it needs an update to become current.
//
// The action returns staleness counts (counts of resources that are up-to-date,
// behind a template major version, or behind a template minor version), the
// total number of resources, and the number of resources that are in a failed
// state, grouped by resource type. Components, environments, and service templates
// return less information - see the components, environments, and serviceTemplates
// field descriptions.
//
// For context, the action also returns the total number of each type of Proton
// template in the Amazon Web Services account.
//
// For more information, see Proton dashboard (https://docs.aws.amazon.com/proton/latest/userguide/monitoring-dashboard.html)
// in the Proton User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Proton's
// API operation GetResourcesSummary for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The input is invalid or an out-of-range value was supplied for the input
//     parameter.
//
//   - AccessDeniedException
//     There isn't sufficient access for performing this action.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - InternalServerException
//     The request failed to register with the service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/GetResourcesSummary
func (c *Proton) GetResourcesSummary(input *GetResourcesSummaryInput) (*GetResourcesSummaryOutput, error) {
	req, out := c.GetResourcesSummaryRequest(input)
	return out, req.Send()
}

// GetResourcesSummaryWithContext is the same as GetResourcesSummary with the addition of
// the ability to pass a context and additional request options.
//
// See GetResourcesSummary for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Proton) GetResourcesSummaryWithContext(ctx aws.Context, input *GetResourcesSummaryInput, opts ...request.Option) (*GetResourcesSummaryOutput, error) {
	req, out := c.GetResourcesSummaryRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetService = "GetService"

// GetServiceRequest generates a "aws/request.Request" representing the
// client's request for the GetService operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetService for more information on using the GetService
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetServiceRequest method.
//	req, resp := client.GetServiceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/GetService
func (c *Proton) GetServiceRequest(input *GetServiceInput) (req *request.Request, output *GetServiceOutput) {
	op := &request.Operation{
		Name:       opGetService,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetServiceInput{}
	}

	output = &GetServiceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetService API operation for AWS Proton.
//
// Get detailed data for a service.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Proton's
// API operation GetService for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The input is invalid or an out-of-range value was supplied for the input
//     parameter.
//
//   - AccessDeniedException
//     There isn't sufficient access for performing this action.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ResourceNotFoundException
//     The requested resource wasn't found.
//
//   - InternalServerException
//     The request failed to register with the service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/GetService
func (c *Proton) GetService(input *GetServiceInput) (*GetServiceOutput, error) {
	req, out := c.GetServiceRequest(input)
	return out, req.Send()
}

// GetServiceWithContext is the same as GetService with the addition of
// the ability to pass a context and additional request options.
//
// See GetService for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Proton) GetServiceWithContext(ctx aws.Context, input *GetServiceInput, opts ...request.Option) (*GetServiceOutput, error) {
	req, out := c.GetServiceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetServiceInstance = "GetServiceInstance"

// GetServiceInstanceRequest generates a "aws/request.Request" representing the
// client's request for the GetServiceInstance operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetServiceInstance for more information on using the GetServiceInstance
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetServiceInstanceRequest method.
//	req, resp := client.GetServiceInstanceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/GetServiceInstance
func (c *Proton) GetServiceInstanceRequest(input *GetServiceInstanceInput) (req *request.Request, output *GetServiceInstanceOutput) {
	op := &request.Operation{
		Name:       opGetServiceInstance,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetServiceInstanceInput{}
	}

	output = &GetServiceInstanceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetServiceInstance API operation for AWS Proton.
//
// Get detailed data for a service instance. A service instance is an instantiation
// of service template and it runs in a specific environment.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Proton's
// API operation GetServiceInstance for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The input is invalid or an out-of-range value was supplied for the input
//     parameter.
//
//   - AccessDeniedException
//     There isn't sufficient access for performing this action.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ResourceNotFoundException
//     The requested resource wasn't found.
//
//   - InternalServerException
//     The request failed to register with the service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/GetServiceInstance
func (c *Proton) GetServiceInstance(input *GetServiceInstanceInput) (*GetServiceInstanceOutput, error) {
	req, out := c.GetServiceInstanceRequest(input)
	return out, req.Send()
}

// GetServiceInstanceWithContext is the same as GetServiceInstance with the addition of
// the ability to pass a context and additional request options.
//
// See GetServiceInstance for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Proton) GetServiceInstanceWithContext(ctx aws.Context, input *GetServiceInstanceInput, opts ...request.Option) (*GetServiceInstanceOutput, error) {
	req, out := c.GetServiceInstanceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetServiceInstanceSyncStatus = "GetServiceInstanceSyncStatus"

// GetServiceInstanceSyncStatusRequest generates a "aws/request.Request" representing the
// client's request for the GetServiceInstanceSyncStatus operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetServiceInstanceSyncStatus for more information on using the GetServiceInstanceSyncStatus
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetServiceInstanceSyncStatusRequest method.
//	req, resp := client.GetServiceInstanceSyncStatusRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/GetServiceInstanceSyncStatus
func (c *Proton) GetServiceInstanceSyncStatusRequest(input *GetServiceInstanceSyncStatusInput) (req *request.Request, output *GetServiceInstanceSyncStatusOutput) {
	op := &request.Operation{
		Name:       opGetServiceInstanceSyncStatus,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetServiceInstanceSyncStatusInput{}
	}

	output = &GetServiceInstanceSyncStatusOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetServiceInstanceSyncStatus API operation for AWS Proton.
//
// Get the status of the synced service instance.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Proton's
// API operation GetServiceInstanceSyncStatus for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The input is invalid or an out-of-range value was supplied for the input
//     parameter.
//
//   - AccessDeniedException
//     There isn't sufficient access for performing this action.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ResourceNotFoundException
//     The requested resource wasn't found.
//
//   - InternalServerException
//     The request failed to register with the service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/GetServiceInstanceSyncStatus
func (c *Proton) GetServiceInstanceSyncStatus(input *GetServiceInstanceSyncStatusInput) (*GetServiceInstanceSyncStatusOutput, error) {
	req, out := c.GetServiceInstanceSyncStatusRequest(input)
	return out, req.Send()
}

// GetServiceInstanceSyncStatusWithContext is the same as GetServiceInstanceSyncStatus with the addition of
// the ability to pass a context and additional request options.
//
// See GetServiceInstanceSyncStatus for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Proton) GetServiceInstanceSyncStatusWithContext(ctx aws.Context, input *GetServiceInstanceSyncStatusInput, opts ...request.Option) (*GetServiceInstanceSyncStatusOutput, error) {
	req, out := c.GetServiceInstanceSyncStatusRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetServiceSyncBlockerSummary = "GetServiceSyncBlockerSummary"

// GetServiceSyncBlockerSummaryRequest generates a "aws/request.Request" representing the
// client's request for the GetServiceSyncBlockerSummary operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetServiceSyncBlockerSummary for more information on using the GetServiceSyncBlockerSummary
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetServiceSyncBlockerSummaryRequest method.
//	req, resp := client.GetServiceSyncBlockerSummaryRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/GetServiceSyncBlockerSummary
func (c *Proton) GetServiceSyncBlockerSummaryRequest(input *GetServiceSyncBlockerSummaryInput) (req *request.Request, output *GetServiceSyncBlockerSummaryOutput) {
	op := &request.Operation{
		Name:       opGetServiceSyncBlockerSummary,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetServiceSyncBlockerSummaryInput{}
	}

	output = &GetServiceSyncBlockerSummaryOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetServiceSyncBlockerSummary API operation for AWS Proton.
//
// Get detailed data for the service sync blocker summary.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Proton's
// API operation GetServiceSyncBlockerSummary for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The input is invalid or an out-of-range value was supplied for the input
//     parameter.
//
//   - AccessDeniedException
//     There isn't sufficient access for performing this action.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ResourceNotFoundException
//     The requested resource wasn't found.
//
//   - InternalServerException
//     The request failed to register with the service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/GetServiceSyncBlockerSummary
func (c *Proton) GetServiceSyncBlockerSummary(input *GetServiceSyncBlockerSummaryInput) (*GetServiceSyncBlockerSummaryOutput, error) {
	req, out := c.GetServiceSyncBlockerSummaryRequest(input)
	return out, req.Send()
}

// GetServiceSyncBlockerSummaryWithContext is the same as GetServiceSyncBlockerSummary with the addition of
// the ability to pass a context and additional request options.
//
// See GetServiceSyncBlockerSummary for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Proton) GetServiceSyncBlockerSummaryWithContext(ctx aws.Context, input *GetServiceSyncBlockerSummaryInput, opts ...request.Option) (*GetServiceSyncBlockerSummaryOutput, error) {
	req, out := c.GetServiceSyncBlockerSummaryRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetServiceSyncConfig = "GetServiceSyncConfig"

// GetServiceSyncConfigRequest generates a "aws/request.Request" representing the
// client's request for the GetServiceSyncConfig operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetServiceSyncConfig for more information on using the GetServiceSyncConfig
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetServiceSyncConfigRequest method.
//	req, resp := client.GetServiceSyncConfigRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/GetServiceSyncConfig
func (c *Proton) GetServiceSyncConfigRequest(input *GetServiceSyncConfigInput) (req *request.Request, output *GetServiceSyncConfigOutput) {
	op := &request.Operation{
		Name:       opGetServiceSyncConfig,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetServiceSyncConfigInput{}
	}

	output = &GetServiceSyncConfigOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetServiceSyncConfig API operation for AWS Proton.
//
// Get detailed information for the service sync configuration.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Proton's
// API operation GetServiceSyncConfig for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The input is invalid or an out-of-range value was supplied for the input
//     parameter.
//
//   - AccessDeniedException
//     There isn't sufficient access for performing this action.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ResourceNotFoundException
//     The requested resource wasn't found.
//
//   - InternalServerException
//     The request failed to register with the service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/GetServiceSyncConfig
func (c *Proton) GetServiceSyncConfig(input *GetServiceSyncConfigInput) (*GetServiceSyncConfigOutput, error) {
	req, out := c.GetServiceSyncConfigRequest(input)
	return out, req.Send()
}

// GetServiceSyncConfigWithContext is the same as GetServiceSyncConfig with the addition of
// the ability to pass a context and additional request options.
//
// See GetServiceSyncConfig for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Proton) GetServiceSyncConfigWithContext(ctx aws.Context, input *GetServiceSyncConfigInput, opts ...request.Option) (*GetServiceSyncConfigOutput, error) {
	req, out := c.GetServiceSyncConfigRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetServiceTemplate = "GetServiceTemplate"

// GetServiceTemplateRequest generates a "aws/request.Request" representing the
// client's request for the GetServiceTemplate operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetServiceTemplate for more information on using the GetServiceTemplate
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetServiceTemplateRequest method.
//	req, resp := client.GetServiceTemplateRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/GetServiceTemplate
func (c *Proton) GetServiceTemplateRequest(input *GetServiceTemplateInput) (req *request.Request, output *GetServiceTemplateOutput) {
	op := &request.Operation{
		Name:       opGetServiceTemplate,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetServiceTemplateInput{}
	}

	output = &GetServiceTemplateOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetServiceTemplate API operation for AWS Proton.
//
// Get detailed data for a service template.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Proton's
// API operation GetServiceTemplate for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The input is invalid or an out-of-range value was supplied for the input
//     parameter.
//
//   - AccessDeniedException
//     There isn't sufficient access for performing this action.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ResourceNotFoundException
//     The requested resource wasn't found.
//
//   - InternalServerException
//     The request failed to register with the service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/GetServiceTemplate
func (c *Proton) GetServiceTemplate(input *GetServiceTemplateInput) (*GetServiceTemplateOutput, error) {
	req, out := c.GetServiceTemplateRequest(input)
	return out, req.Send()
}

// GetServiceTemplateWithContext is the same as GetServiceTemplate with the addition of
// the ability to pass a context and additional request options.
//
// See GetServiceTemplate for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Proton) GetServiceTemplateWithContext(ctx aws.Context, input *GetServiceTemplateInput, opts ...request.Option) (*GetServiceTemplateOutput, error) {
	req, out := c.GetServiceTemplateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetServiceTemplateVersion = "GetServiceTemplateVersion"

// GetServiceTemplateVersionRequest generates a "aws/request.Request" representing the
// client's request for the GetServiceTemplateVersion operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetServiceTemplateVersion for more information on using the GetServiceTemplateVersion
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetServiceTemplateVersionRequest method.
//	req, resp := client.GetServiceTemplateVersionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/GetServiceTemplateVersion
func (c *Proton) GetServiceTemplateVersionRequest(input *GetServiceTemplateVersionInput) (req *request.Request, output *GetServiceTemplateVersionOutput) {
	op := &request.Operation{
		Name:       opGetServiceTemplateVersion,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetServiceTemplateVersionInput{}
	}

	output = &GetServiceTemplateVersionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetServiceTemplateVersion API operation for AWS Proton.
//
// Get detailed data for a major or minor version of a service template.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Proton's
// API operation GetServiceTemplateVersion for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The input is invalid or an out-of-range value was supplied for the input
//     parameter.
//
//   - AccessDeniedException
//     There isn't sufficient access for performing this action.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ResourceNotFoundException
//     The requested resource wasn't found.
//
//   - InternalServerException
//     The request failed to register with the service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/GetServiceTemplateVersion
func (c *Proton) GetServiceTemplateVersion(input *GetServiceTemplateVersionInput) (*GetServiceTemplateVersionOutput, error) {
	req, out := c.GetServiceTemplateVersionRequest(input)
	return out, req.Send()
}

// GetServiceTemplateVersionWithContext is the same as GetServiceTemplateVersion with the addition of
// the ability to pass a context and additional request options.
//
// See GetServiceTemplateVersion for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Proton) GetServiceTemplateVersionWithContext(ctx aws.Context, input *GetServiceTemplateVersionInput, opts ...request.Option) (*GetServiceTemplateVersionOutput, error) {
	req, out := c.GetServiceTemplateVersionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetTemplateSyncConfig = "GetTemplateSyncConfig"

// GetTemplateSyncConfigRequest generates a "aws/request.Request" representing the
// client's request for the GetTemplateSyncConfig operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetTemplateSyncConfig for more information on using the GetTemplateSyncConfig
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetTemplateSyncConfigRequest method.
//	req, resp := client.GetTemplateSyncConfigRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/GetTemplateSyncConfig
func (c *Proton) GetTemplateSyncConfigRequest(input *GetTemplateSyncConfigInput) (req *request.Request, output *GetTemplateSyncConfigOutput) {
	op := &request.Operation{
		Name:       opGetTemplateSyncConfig,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetTemplateSyncConfigInput{}
	}

	output = &GetTemplateSyncConfigOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetTemplateSyncConfig API operation for AWS Proton.
//
// Get detail data for a template sync configuration.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Proton's
// API operation GetTemplateSyncConfig for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The input is invalid or an out-of-range value was supplied for the input
//     parameter.
//
//   - AccessDeniedException
//     There isn't sufficient access for performing this action.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ResourceNotFoundException
//     The requested resource wasn't found.
//
//   - InternalServerException
//     The request failed to register with the service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/GetTemplateSyncConfig
func (c *Proton) GetTemplateSyncConfig(input *GetTemplateSyncConfigInput) (*GetTemplateSyncConfigOutput, error) {
	req, out := c.GetTemplateSyncConfigRequest(input)
	return out, req.Send()
}

// GetTemplateSyncConfigWithContext is the same as GetTemplateSyncConfig with the addition of
// the ability to pass a context and additional request options.
//
// See GetTemplateSyncConfig for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Proton) GetTemplateSyncConfigWithContext(ctx aws.Context, input *GetTemplateSyncConfigInput, opts ...request.Option) (*GetTemplateSyncConfigOutput, error) {
	req, out := c.GetTemplateSyncConfigRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetTemplateSyncStatus = "GetTemplateSyncStatus"

// GetTemplateSyncStatusRequest generates a "aws/request.Request" representing the
// client's request for the GetTemplateSyncStatus operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetTemplateSyncStatus for more information on using the GetTemplateSyncStatus
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetTemplateSyncStatusRequest method.
//	req, resp := client.GetTemplateSyncStatusRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/GetTemplateSyncStatus
func (c *Proton) GetTemplateSyncStatusRequest(input *GetTemplateSyncStatusInput) (req *request.Request, output *GetTemplateSyncStatusOutput) {
	op := &request.Operation{
		Name:       opGetTemplateSyncStatus,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetTemplateSyncStatusInput{}
	}

	output = &GetTemplateSyncStatusOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetTemplateSyncStatus API operation for AWS Proton.
//
// Get the status of a template sync.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Proton's
// API operation GetTemplateSyncStatus for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The input is invalid or an out-of-range value was supplied for the input
//     parameter.
//
//   - AccessDeniedException
//     There isn't sufficient access for performing this action.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ResourceNotFoundException
//     The requested resource wasn't found.
//
//   - InternalServerException
//     The request failed to register with the service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/GetTemplateSyncStatus
func (c *Proton) GetTemplateSyncStatus(input *GetTemplateSyncStatusInput) (*GetTemplateSyncStatusOutput, error) {
	req, out := c.GetTemplateSyncStatusRequest(input)
	return out, req.Send()
}

// GetTemplateSyncStatusWithContext is the same as GetTemplateSyncStatus with the addition of
// the ability to pass a context and additional request options.
//
// See GetTemplateSyncStatus for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Proton) GetTemplateSyncStatusWithContext(ctx aws.Context, input *GetTemplateSyncStatusInput, opts ...request.Option) (*GetTemplateSyncStatusOutput, error) {
	req, out := c.GetTemplateSyncStatusRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListComponentOutputs = "ListComponentOutputs"

// ListComponentOutputsRequest generates a "aws/request.Request" representing the
// client's request for the ListComponentOutputs operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListComponentOutputs for more information on using the ListComponentOutputs
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListComponentOutputsRequest method.
//	req, resp := client.ListComponentOutputsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/ListComponentOutputs
func (c *Proton) ListComponentOutputsRequest(input *ListComponentOutputsInput) (req *request.Request, output *ListComponentOutputsOutput) {
	op := &request.Operation{
		Name:       opListComponentOutputs,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListComponentOutputsInput{}
	}

	output = &ListComponentOutputsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListComponentOutputs API operation for AWS Proton.
//
// Get a list of component Infrastructure as Code (IaC) outputs.
//
// For more information about components, see Proton components (https://docs.aws.amazon.com/proton/latest/userguide/ag-components.html)
// in the Proton User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Proton's
// API operation ListComponentOutputs for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The input is invalid or an out-of-range value was supplied for the input
//     parameter.
//
//   - AccessDeniedException
//     There isn't sufficient access for performing this action.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ResourceNotFoundException
//     The requested resource wasn't found.
//
//   - InternalServerException
//     The request failed to register with the service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/ListComponentOutputs
func (c *Proton) ListComponentOutputs(input *ListComponentOutputsInput) (*ListComponentOutputsOutput, error) {
	req, out := c.ListComponentOutputsRequest(input)
	return out, req.Send()
}

// ListComponentOutputsWithContext is the same as ListComponentOutputs with the addition of
// the ability to pass a context and additional request options.
//
// See ListComponentOutputs for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Proton) ListComponentOutputsWithContext(ctx aws.Context, input *ListComponentOutputsInput, opts ...request.Option) (*ListComponentOutputsOutput, error) {
	req, out := c.ListComponentOutputsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListComponentOutputsPages iterates over the pages of a ListComponentOutputs operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListComponentOutputs method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListComponentOutputs operation.
//	pageNum := 0
//	err := client.ListComponentOutputsPages(params,
//	    func(page *proton.ListComponentOutputsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Proton) ListComponentOutputsPages(input *ListComponentOutputsInput, fn func(*ListComponentOutputsOutput, bool) bool) error {
	return c.ListComponentOutputsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListComponentOutputsPagesWithContext same as ListComponentOutputsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Proton) ListComponentOutputsPagesWithContext(ctx aws.Context, input *ListComponentOutputsInput, fn func(*ListComponentOutputsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListComponentOutputsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListComponentOutputsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListComponentOutputsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListComponentProvisionedResources = "ListComponentProvisionedResources"

// ListComponentProvisionedResourcesRequest generates a "aws/request.Request" representing the
// client's request for the ListComponentProvisionedResources operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListComponentProvisionedResources for more information on using the ListComponentProvisionedResources
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListComponentProvisionedResourcesRequest method.
//	req, resp := client.ListComponentProvisionedResourcesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/ListComponentProvisionedResources
func (c *Proton) ListComponentProvisionedResourcesRequest(input *ListComponentProvisionedResourcesInput) (req *request.Request, output *ListComponentProvisionedResourcesOutput) {
	op := &request.Operation{
		Name:       opListComponentProvisionedResources,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListComponentProvisionedResourcesInput{}
	}

	output = &ListComponentProvisionedResourcesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListComponentProvisionedResources API operation for AWS Proton.
//
// List provisioned resources for a component with details.
//
// For more information about components, see Proton components (https://docs.aws.amazon.com/proton/latest/userguide/ag-components.html)
// in the Proton User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Proton's
// API operation ListComponentProvisionedResources for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The input is invalid or an out-of-range value was supplied for the input
//     parameter.
//
//   - AccessDeniedException
//     There isn't sufficient access for performing this action.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ResourceNotFoundException
//     The requested resource wasn't found.
//
//   - InternalServerException
//     The request failed to register with the service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/ListComponentProvisionedResources
func (c *Proton) ListComponentProvisionedResources(input *ListComponentProvisionedResourcesInput) (*ListComponentProvisionedResourcesOutput, error) {
	req, out := c.ListComponentProvisionedResourcesRequest(input)
	return out, req.Send()
}

// ListComponentProvisionedResourcesWithContext is the same as ListComponentProvisionedResources with the addition of
// the ability to pass a context and additional request options.
//
// See ListComponentProvisionedResources for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Proton) ListComponentProvisionedResourcesWithContext(ctx aws.Context, input *ListComponentProvisionedResourcesInput, opts ...request.Option) (*ListComponentProvisionedResourcesOutput, error) {
	req, out := c.ListComponentProvisionedResourcesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListComponentProvisionedResourcesPages iterates over the pages of a ListComponentProvisionedResources operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListComponentProvisionedResources method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListComponentProvisionedResources operation.
//	pageNum := 0
//	err := client.ListComponentProvisionedResourcesPages(params,
//	    func(page *proton.ListComponentProvisionedResourcesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Proton) ListComponentProvisionedResourcesPages(input *ListComponentProvisionedResourcesInput, fn func(*ListComponentProvisionedResourcesOutput, bool) bool) error {
	return c.ListComponentProvisionedResourcesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListComponentProvisionedResourcesPagesWithContext same as ListComponentProvisionedResourcesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Proton) ListComponentProvisionedResourcesPagesWithContext(ctx aws.Context, input *ListComponentProvisionedResourcesInput, fn func(*ListComponentProvisionedResourcesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListComponentProvisionedResourcesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListComponentProvisionedResourcesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListComponentProvisionedResourcesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListComponents = "ListComponents"

// ListComponentsRequest generates a "aws/request.Request" representing the
// client's request for the ListComponents operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListComponents for more information on using the ListComponents
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListComponentsRequest method.
//	req, resp := client.ListComponentsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/ListComponents
func (c *Proton) ListComponentsRequest(input *ListComponentsInput) (req *request.Request, output *ListComponentsOutput) {
	op := &request.Operation{
		Name:       opListComponents,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListComponentsInput{}
	}

	output = &ListComponentsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListComponents API operation for AWS Proton.
//
// List components with summary data. You can filter the result list by environment,
// service, or a single service instance.
//
// For more information about components, see Proton components (https://docs.aws.amazon.com/proton/latest/userguide/ag-components.html)
// in the Proton User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Proton's
// API operation ListComponents for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The input is invalid or an out-of-range value was supplied for the input
//     parameter.
//
//   - AccessDeniedException
//     There isn't sufficient access for performing this action.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - InternalServerException
//     The request failed to register with the service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/ListComponents
func (c *Proton) ListComponents(input *ListComponentsInput) (*ListComponentsOutput, error) {
	req, out := c.ListComponentsRequest(input)
	return out, req.Send()
}

// ListComponentsWithContext is the same as ListComponents with the addition of
// the ability to pass a context and additional request options.
//
// See ListComponents for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Proton) ListComponentsWithContext(ctx aws.Context, input *ListComponentsInput, opts ...request.Option) (*ListComponentsOutput, error) {
	req, out := c.ListComponentsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListComponentsPages iterates over the pages of a ListComponents operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListComponents method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListComponents operation.
//	pageNum := 0
//	err := client.ListComponentsPages(params,
//	    func(page *proton.ListComponentsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Proton) ListComponentsPages(input *ListComponentsInput, fn func(*ListComponentsOutput, bool) bool) error {
	return c.ListComponentsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListComponentsPagesWithContext same as ListComponentsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Proton) ListComponentsPagesWithContext(ctx aws.Context, input *ListComponentsInput, fn func(*ListComponentsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListComponentsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListComponentsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListComponentsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListDeployments = "ListDeployments"

// ListDeploymentsRequest generates a "aws/request.Request" representing the
// client's request for the ListDeployments operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListDeployments for more information on using the ListDeployments
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListDeploymentsRequest method.
//	req, resp := client.ListDeploymentsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/ListDeployments
func (c *Proton) ListDeploymentsRequest(input *ListDeploymentsInput) (req *request.Request, output *ListDeploymentsOutput) {
	op := &request.Operation{
		Name:       opListDeployments,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListDeploymentsInput{}
	}

	output = &ListDeploymentsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListDeployments API operation for AWS Proton.
//
// List deployments. You can filter the result list by environment, service,
// or a single service instance.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Proton's
// API operation ListDeployments for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The input is invalid or an out-of-range value was supplied for the input
//     parameter.
//
//   - AccessDeniedException
//     There isn't sufficient access for performing this action.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ResourceNotFoundException
//     The requested resource wasn't found.
//
//   - InternalServerException
//     The request failed to register with the service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/ListDeployments
func (c *Proton) ListDeployments(input *ListDeploymentsInput) (*ListDeploymentsOutput, error) {
	req, out := c.ListDeploymentsRequest(input)
	return out, req.Send()
}

// ListDeploymentsWithContext is the same as ListDeployments with the addition of
// the ability to pass a context and additional request options.
//
// See ListDeployments for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Proton) ListDeploymentsWithContext(ctx aws.Context, input *ListDeploymentsInput, opts ...request.Option) (*ListDeploymentsOutput, error) {
	req, out := c.ListDeploymentsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListDeploymentsPages iterates over the pages of a ListDeployments operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListDeployments method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListDeployments operation.
//	pageNum := 0
//	err := client.ListDeploymentsPages(params,
//	    func(page *proton.ListDeploymentsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Proton) ListDeploymentsPages(input *ListDeploymentsInput, fn func(*ListDeploymentsOutput, bool) bool) error {
	return c.ListDeploymentsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListDeploymentsPagesWithContext same as ListDeploymentsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Proton) ListDeploymentsPagesWithContext(ctx aws.Context, input *ListDeploymentsInput, fn func(*ListDeploymentsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListDeploymentsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListDeploymentsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListDeploymentsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListEnvironmentAccountConnections = "ListEnvironmentAccountConnections"

// ListEnvironmentAccountConnectionsRequest generates a "aws/request.Request" representing the
// client's request for the ListEnvironmentAccountConnections operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListEnvironmentAccountConnections for more information on using the ListEnvironmentAccountConnections
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListEnvironmentAccountConnectionsRequest method.
//	req, resp := client.ListEnvironmentAccountConnectionsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/ListEnvironmentAccountConnections
func (c *Proton) ListEnvironmentAccountConnectionsRequest(input *ListEnvironmentAccountConnectionsInput) (req *request.Request, output *ListEnvironmentAccountConnectionsOutput) {
	op := &request.Operation{
		Name:       opListEnvironmentAccountConnections,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListEnvironmentAccountConnectionsInput{}
	}

	output = &ListEnvironmentAccountConnectionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListEnvironmentAccountConnections API operation for AWS Proton.
//
// View a list of environment account connections.
//
// For more information, see Environment account connections (https://docs.aws.amazon.com/proton/latest/userguide/ag-env-account-connections.html)
// in the Proton User guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Proton's
// API operation ListEnvironmentAccountConnections for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The input is invalid or an out-of-range value was supplied for the input
//     parameter.
//
//   - AccessDeniedException
//     There isn't sufficient access for performing this action.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - InternalServerException
//     The request failed to register with the service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/ListEnvironmentAccountConnections
func (c *Proton) ListEnvironmentAccountConnections(input *ListEnvironmentAccountConnectionsInput) (*ListEnvironmentAccountConnectionsOutput, error) {
	req, out := c.ListEnvironmentAccountConnectionsRequest(input)
	return out, req.Send()
}

// ListEnvironmentAccountConnectionsWithContext is the same as ListEnvironmentAccountConnections with the addition of
// the ability to pass a context and additional request options.
//
// See ListEnvironmentAccountConnections for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Proton) ListEnvironmentAccountConnectionsWithContext(ctx aws.Context, input *ListEnvironmentAccountConnectionsInput, opts ...request.Option) (*ListEnvironmentAccountConnectionsOutput, error) {
	req, out := c.ListEnvironmentAccountConnectionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListEnvironmentAccountConnectionsPages iterates over the pages of a ListEnvironmentAccountConnections operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListEnvironmentAccountConnections method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListEnvironmentAccountConnections operation.
//	pageNum := 0
//	err := client.ListEnvironmentAccountConnectionsPages(params,
//	    func(page *proton.ListEnvironmentAccountConnectionsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Proton) ListEnvironmentAccountConnectionsPages(input *ListEnvironmentAccountConnectionsInput, fn func(*ListEnvironmentAccountConnectionsOutput, bool) bool) error {
	return c.ListEnvironmentAccountConnectionsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListEnvironmentAccountConnectionsPagesWithContext same as ListEnvironmentAccountConnectionsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Proton) ListEnvironmentAccountConnectionsPagesWithContext(ctx aws.Context, input *ListEnvironmentAccountConnectionsInput, fn func(*ListEnvironmentAccountConnectionsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListEnvironmentAccountConnectionsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListEnvironmentAccountConnectionsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListEnvironmentAccountConnectionsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListEnvironmentOutputs = "ListEnvironmentOutputs"

// ListEnvironmentOutputsRequest generates a "aws/request.Request" representing the
// client's request for the ListEnvironmentOutputs operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListEnvironmentOutputs for more information on using the ListEnvironmentOutputs
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListEnvironmentOutputsRequest method.
//	req, resp := client.ListEnvironmentOutputsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/ListEnvironmentOutputs
func (c *Proton) ListEnvironmentOutputsRequest(input *ListEnvironmentOutputsInput) (req *request.Request, output *ListEnvironmentOutputsOutput) {
	op := &request.Operation{
		Name:       opListEnvironmentOutputs,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListEnvironmentOutputsInput{}
	}

	output = &ListEnvironmentOutputsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListEnvironmentOutputs API operation for AWS Proton.
//
// List the infrastructure as code outputs for your environment.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Proton's
// API operation ListEnvironmentOutputs for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The input is invalid or an out-of-range value was supplied for the input
//     parameter.
//
//   - AccessDeniedException
//     There isn't sufficient access for performing this action.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ResourceNotFoundException
//     The requested resource wasn't found.
//
//   - InternalServerException
//     The request failed to register with the service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/ListEnvironmentOutputs
func (c *Proton) ListEnvironmentOutputs(input *ListEnvironmentOutputsInput) (*ListEnvironmentOutputsOutput, error) {
	req, out := c.ListEnvironmentOutputsRequest(input)
	return out, req.Send()
}

// ListEnvironmentOutputsWithContext is the same as ListEnvironmentOutputs with the addition of
// the ability to pass a context and additional request options.
//
// See ListEnvironmentOutputs for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Proton) ListEnvironmentOutputsWithContext(ctx aws.Context, input *ListEnvironmentOutputsInput, opts ...request.Option) (*ListEnvironmentOutputsOutput, error) {
	req, out := c.ListEnvironmentOutputsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListEnvironmentOutputsPages iterates over the pages of a ListEnvironmentOutputs operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListEnvironmentOutputs method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListEnvironmentOutputs operation.
//	pageNum := 0
//	err := client.ListEnvironmentOutputsPages(params,
//	    func(page *proton.ListEnvironmentOutputsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Proton) ListEnvironmentOutputsPages(input *ListEnvironmentOutputsInput, fn func(*ListEnvironmentOutputsOutput, bool) bool) error {
	return c.ListEnvironmentOutputsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListEnvironmentOutputsPagesWithContext same as ListEnvironmentOutputsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Proton) ListEnvironmentOutputsPagesWithContext(ctx aws.Context, input *ListEnvironmentOutputsInput, fn func(*ListEnvironmentOutputsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListEnvironmentOutputsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListEnvironmentOutputsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListEnvironmentOutputsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListEnvironmentProvisionedResources = "ListEnvironmentProvisionedResources"

// ListEnvironmentProvisionedResourcesRequest generates a "aws/request.Request" representing the
// client's request for the ListEnvironmentProvisionedResources operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListEnvironmentProvisionedResources for more information on using the ListEnvironmentProvisionedResources
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListEnvironmentProvisionedResourcesRequest method.
//	req, resp := client.ListEnvironmentProvisionedResourcesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/ListEnvironmentProvisionedResources
func (c *Proton) ListEnvironmentProvisionedResourcesRequest(input *ListEnvironmentProvisionedResourcesInput) (req *request.Request, output *ListEnvironmentProvisionedResourcesOutput) {
	op := &request.Operation{
		Name:       opListEnvironmentProvisionedResources,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListEnvironmentProvisionedResourcesInput{}
	}

	output = &ListEnvironmentProvisionedResourcesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListEnvironmentProvisionedResources API operation for AWS Proton.
//
// List the provisioned resources for your environment.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Proton's
// API operation ListEnvironmentProvisionedResources for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The input is invalid or an out-of-range value was supplied for the input
//     parameter.
//
//   - AccessDeniedException
//     There isn't sufficient access for performing this action.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ResourceNotFoundException
//     The requested resource wasn't found.
//
//   - InternalServerException
//     The request failed to register with the service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/ListEnvironmentProvisionedResources
func (c *Proton) ListEnvironmentProvisionedResources(input *ListEnvironmentProvisionedResourcesInput) (*ListEnvironmentProvisionedResourcesOutput, error) {
	req, out := c.ListEnvironmentProvisionedResourcesRequest(input)
	return out, req.Send()
}

// ListEnvironmentProvisionedResourcesWithContext is the same as ListEnvironmentProvisionedResources with the addition of
// the ability to pass a context and additional request options.
//
// See ListEnvironmentProvisionedResources for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Proton) ListEnvironmentProvisionedResourcesWithContext(ctx aws.Context, input *ListEnvironmentProvisionedResourcesInput, opts ...request.Option) (*ListEnvironmentProvisionedResourcesOutput, error) {
	req, out := c.ListEnvironmentProvisionedResourcesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListEnvironmentProvisionedResourcesPages iterates over the pages of a ListEnvironmentProvisionedResources operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListEnvironmentProvisionedResources method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListEnvironmentProvisionedResources operation.
//	pageNum := 0
//	err := client.ListEnvironmentProvisionedResourcesPages(params,
//	    func(page *proton.ListEnvironmentProvisionedResourcesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Proton) ListEnvironmentProvisionedResourcesPages(input *ListEnvironmentProvisionedResourcesInput, fn func(*ListEnvironmentProvisionedResourcesOutput, bool) bool) error {
	return c.ListEnvironmentProvisionedResourcesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListEnvironmentProvisionedResourcesPagesWithContext same as ListEnvironmentProvisionedResourcesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Proton) ListEnvironmentProvisionedResourcesPagesWithContext(ctx aws.Context, input *ListEnvironmentProvisionedResourcesInput, fn func(*ListEnvironmentProvisionedResourcesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListEnvironmentProvisionedResourcesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListEnvironmentProvisionedResourcesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListEnvironmentProvisionedResourcesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListEnvironmentTemplateVersions = "ListEnvironmentTemplateVersions"

// ListEnvironmentTemplateVersionsRequest generates a "aws/request.Request" representing the
// client's request for the ListEnvironmentTemplateVersions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListEnvironmentTemplateVersions for more information on using the ListEnvironmentTemplateVersions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListEnvironmentTemplateVersionsRequest method.
//	req, resp := client.ListEnvironmentTemplateVersionsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/ListEnvironmentTemplateVersions
func (c *Proton) ListEnvironmentTemplateVersionsRequest(input *ListEnvironmentTemplateVersionsInput) (req *request.Request, output *ListEnvironmentTemplateVersionsOutput) {
	op := &request.Operation{
		Name:       opListEnvironmentTemplateVersions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListEnvironmentTemplateVersionsInput{}
	}

	output = &ListEnvironmentTemplateVersionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListEnvironmentTemplateVersions API operation for AWS Proton.
//
// List major or minor versions of an environment template with detail data.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Proton's
// API operation ListEnvironmentTemplateVersions for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The input is invalid or an out-of-range value was supplied for the input
//     parameter.
//
//   - AccessDeniedException
//     There isn't sufficient access for performing this action.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ResourceNotFoundException
//     The requested resource wasn't found.
//
//   - InternalServerException
//     The request failed to register with the service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/ListEnvironmentTemplateVersions
func (c *Proton) ListEnvironmentTemplateVersions(input *ListEnvironmentTemplateVersionsInput) (*ListEnvironmentTemplateVersionsOutput, error) {
	req, out := c.ListEnvironmentTemplateVersionsRequest(input)
	return out, req.Send()
}

// ListEnvironmentTemplateVersionsWithContext is the same as ListEnvironmentTemplateVersions with the addition of
// the ability to pass a context and additional request options.
//
// See ListEnvironmentTemplateVersions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Proton) ListEnvironmentTemplateVersionsWithContext(ctx aws.Context, input *ListEnvironmentTemplateVersionsInput, opts ...request.Option) (*ListEnvironmentTemplateVersionsOutput, error) {
	req, out := c.ListEnvironmentTemplateVersionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListEnvironmentTemplateVersionsPages iterates over the pages of a ListEnvironmentTemplateVersions operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListEnvironmentTemplateVersions method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListEnvironmentTemplateVersions operation.
//	pageNum := 0
//	err := client.ListEnvironmentTemplateVersionsPages(params,
//	    func(page *proton.ListEnvironmentTemplateVersionsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Proton) ListEnvironmentTemplateVersionsPages(input *ListEnvironmentTemplateVersionsInput, fn func(*ListEnvironmentTemplateVersionsOutput, bool) bool) error {
	return c.ListEnvironmentTemplateVersionsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListEnvironmentTemplateVersionsPagesWithContext same as ListEnvironmentTemplateVersionsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Proton) ListEnvironmentTemplateVersionsPagesWithContext(ctx aws.Context, input *ListEnvironmentTemplateVersionsInput, fn func(*ListEnvironmentTemplateVersionsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListEnvironmentTemplateVersionsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListEnvironmentTemplateVersionsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListEnvironmentTemplateVersionsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListEnvironmentTemplates = "ListEnvironmentTemplates"

// ListEnvironmentTemplatesRequest generates a "aws/request.Request" representing the
// client's request for the ListEnvironmentTemplates operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListEnvironmentTemplates for more information on using the ListEnvironmentTemplates
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListEnvironmentTemplatesRequest method.
//	req, resp := client.ListEnvironmentTemplatesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/ListEnvironmentTemplates
func (c *Proton) ListEnvironmentTemplatesRequest(input *ListEnvironmentTemplatesInput) (req *request.Request, output *ListEnvironmentTemplatesOutput) {
	op := &request.Operation{
		Name:       opListEnvironmentTemplates,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListEnvironmentTemplatesInput{}
	}

	output = &ListEnvironmentTemplatesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListEnvironmentTemplates API operation for AWS Proton.
//
// List environment templates.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Proton's
// API operation ListEnvironmentTemplates for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The input is invalid or an out-of-range value was supplied for the input
//     parameter.
//
//   - AccessDeniedException
//     There isn't sufficient access for performing this action.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - InternalServerException
//     The request failed to register with the service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/ListEnvironmentTemplates
func (c *Proton) ListEnvironmentTemplates(input *ListEnvironmentTemplatesInput) (*ListEnvironmentTemplatesOutput, error) {
	req, out := c.ListEnvironmentTemplatesRequest(input)
	return out, req.Send()
}

// ListEnvironmentTemplatesWithContext is the same as ListEnvironmentTemplates with the addition of
// the ability to pass a context and additional request options.
//
// See ListEnvironmentTemplates for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Proton) ListEnvironmentTemplatesWithContext(ctx aws.Context, input *ListEnvironmentTemplatesInput, opts ...request.Option) (*ListEnvironmentTemplatesOutput, error) {
	req, out := c.ListEnvironmentTemplatesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListEnvironmentTemplatesPages iterates over the pages of a ListEnvironmentTemplates operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListEnvironmentTemplates method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListEnvironmentTemplates operation.
//	pageNum := 0
//	err := client.ListEnvironmentTemplatesPages(params,
//	    func(page *proton.ListEnvironmentTemplatesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Proton) ListEnvironmentTemplatesPages(input *ListEnvironmentTemplatesInput, fn func(*ListEnvironmentTemplatesOutput, bool) bool) error {
	return c.ListEnvironmentTemplatesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListEnvironmentTemplatesPagesWithContext same as ListEnvironmentTemplatesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Proton) ListEnvironmentTemplatesPagesWithContext(ctx aws.Context, input *ListEnvironmentTemplatesInput, fn func(*ListEnvironmentTemplatesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListEnvironmentTemplatesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListEnvironmentTemplatesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListEnvironmentTemplatesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListEnvironments = "ListEnvironments"

// ListEnvironmentsRequest generates a "aws/request.Request" representing the
// client's request for the ListEnvironments operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListEnvironments for more information on using the ListEnvironments
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListEnvironmentsRequest method.
//	req, resp := client.ListEnvironmentsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/ListEnvironments
func (c *Proton) ListEnvironmentsRequest(input *ListEnvironmentsInput) (req *request.Request, output *ListEnvironmentsOutput) {
	op := &request.Operation{
		Name:       opListEnvironments,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListEnvironmentsInput{}
	}

	output = &ListEnvironmentsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListEnvironments API operation for AWS Proton.
//
// List environments with detail data summaries.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Proton's
// API operation ListEnvironments for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The input is invalid or an out-of-range value was supplied for the input
//     parameter.
//
//   - AccessDeniedException
//     There isn't sufficient access for performing this action.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ResourceNotFoundException
//     The requested resource wasn't found.
//
//   - InternalServerException
//     The request failed to register with the service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/ListEnvironments
func (c *Proton) ListEnvironments(input *ListEnvironmentsInput) (*ListEnvironmentsOutput, error) {
	req, out := c.ListEnvironmentsRequest(input)
	return out, req.Send()
}

// ListEnvironmentsWithContext is the same as ListEnvironments with the addition of
// the ability to pass a context and additional request options.
//
// See ListEnvironments for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Proton) ListEnvironmentsWithContext(ctx aws.Context, input *ListEnvironmentsInput, opts ...request.Option) (*ListEnvironmentsOutput, error) {
	req, out := c.ListEnvironmentsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListEnvironmentsPages iterates over the pages of a ListEnvironments operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListEnvironments method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListEnvironments operation.
//	pageNum := 0
//	err := client.ListEnvironmentsPages(params,
//	    func(page *proton.ListEnvironmentsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Proton) ListEnvironmentsPages(input *ListEnvironmentsInput, fn func(*ListEnvironmentsOutput, bool) bool) error {
	return c.ListEnvironmentsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListEnvironmentsPagesWithContext same as ListEnvironmentsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Proton) ListEnvironmentsPagesWithContext(ctx aws.Context, input *ListEnvironmentsInput, fn func(*ListEnvironmentsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListEnvironmentsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListEnvironmentsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListEnvironmentsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListRepositories = "ListRepositories"

// ListRepositoriesRequest generates a "aws/request.Request" representing the
// client's request for the ListRepositories operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListRepositories for more information on using the ListRepositories
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListRepositoriesRequest method.
//	req, resp := client.ListRepositoriesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/ListRepositories
func (c *Proton) ListRepositoriesRequest(input *ListRepositoriesInput) (req *request.Request, output *ListRepositoriesOutput) {
	op := &request.Operation{
		Name:       opListRepositories,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListRepositoriesInput{}
	}

	output = &ListRepositoriesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListRepositories API operation for AWS Proton.
//
// List linked repositories with detail data.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Proton's
// API operation ListRepositories for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The input is invalid or an out-of-range value was supplied for the input
//     parameter.
//
//   - AccessDeniedException
//     There isn't sufficient access for performing this action.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ResourceNotFoundException
//     The requested resource wasn't found.
//
//   - InternalServerException
//     The request failed to register with the service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/ListRepositories
func (c *Proton) ListRepositories(input *ListRepositoriesInput) (*ListRepositoriesOutput, error) {
	req, out := c.ListRepositoriesRequest(input)
	return out, req.Send()
}

// ListRepositoriesWithContext is the same as ListRepositories with the addition of
// the ability to pass a context and additional request options.
//
// See ListRepositories for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Proton) ListRepositoriesWithContext(ctx aws.Context, input *ListRepositoriesInput, opts ...request.Option) (*ListRepositoriesOutput, error) {
	req, out := c.ListRepositoriesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListRepositoriesPages iterates over the pages of a ListRepositories operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListRepositories method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListRepositories operation.
//	pageNum := 0
//	err := client.ListRepositoriesPages(params,
//	    func(page *proton.ListRepositoriesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Proton) ListRepositoriesPages(input *ListRepositoriesInput, fn func(*ListRepositoriesOutput, bool) bool) error {
	return c.ListRepositoriesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListRepositoriesPagesWithContext same as ListRepositoriesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Proton) ListRepositoriesPagesWithContext(ctx aws.Context, input *ListRepositoriesInput, fn func(*ListRepositoriesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListRepositoriesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListRepositoriesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListRepositoriesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListRepositorySyncDefinitions = "ListRepositorySyncDefinitions"

// ListRepositorySyncDefinitionsRequest generates a "aws/request.Request" representing the
// client's request for the ListRepositorySyncDefinitions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListRepositorySyncDefinitions for more information on using the ListRepositorySyncDefinitions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListRepositorySyncDefinitionsRequest method.
//	req, resp := client.ListRepositorySyncDefinitionsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/ListRepositorySyncDefinitions
func (c *Proton) ListRepositorySyncDefinitionsRequest(input *ListRepositorySyncDefinitionsInput) (req *request.Request, output *ListRepositorySyncDefinitionsOutput) {
	op := &request.Operation{
		Name:       opListRepositorySyncDefinitions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListRepositorySyncDefinitionsInput{}
	}

	output = &ListRepositorySyncDefinitionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListRepositorySyncDefinitions API operation for AWS Proton.
//
// List repository sync definitions with detail data.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Proton's
// API operation ListRepositorySyncDefinitions for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The input is invalid or an out-of-range value was supplied for the input
//     parameter.
//
//   - AccessDeniedException
//     There isn't sufficient access for performing this action.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - InternalServerException
//     The request failed to register with the service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/ListRepositorySyncDefinitions
func (c *Proton) ListRepositorySyncDefinitions(input *ListRepositorySyncDefinitionsInput) (*ListRepositorySyncDefinitionsOutput, error) {
	req, out := c.ListRepositorySyncDefinitionsRequest(input)
	return out, req.Send()
}

// ListRepositorySyncDefinitionsWithContext is the same as ListRepositorySyncDefinitions with the addition of
// the ability to pass a context and additional request options.
//
// See ListRepositorySyncDefinitions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Proton) ListRepositorySyncDefinitionsWithContext(ctx aws.Context, input *ListRepositorySyncDefinitionsInput, opts ...request.Option) (*ListRepositorySyncDefinitionsOutput, error) {
	req, out := c.ListRepositorySyncDefinitionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListRepositorySyncDefinitionsPages iterates over the pages of a ListRepositorySyncDefinitions operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListRepositorySyncDefinitions method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListRepositorySyncDefinitions operation.
//	pageNum := 0
//	err := client.ListRepositorySyncDefinitionsPages(params,
//	    func(page *proton.ListRepositorySyncDefinitionsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Proton) ListRepositorySyncDefinitionsPages(input *ListRepositorySyncDefinitionsInput, fn func(*ListRepositorySyncDefinitionsOutput, bool) bool) error {
	return c.ListRepositorySyncDefinitionsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListRepositorySyncDefinitionsPagesWithContext same as ListRepositorySyncDefinitionsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Proton) ListRepositorySyncDefinitionsPagesWithContext(ctx aws.Context, input *ListRepositorySyncDefinitionsInput, fn func(*ListRepositorySyncDefinitionsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListRepositorySyncDefinitionsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListRepositorySyncDefinitionsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListRepositorySyncDefinitionsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListServiceInstanceOutputs = "ListServiceInstanceOutputs"

// ListServiceInstanceOutputsRequest generates a "aws/request.Request" representing the
// client's request for the ListServiceInstanceOutputs operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListServiceInstanceOutputs for more information on using the ListServiceInstanceOutputs
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListServiceInstanceOutputsRequest method.
//	req, resp := client.ListServiceInstanceOutputsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/ListServiceInstanceOutputs
func (c *Proton) ListServiceInstanceOutputsRequest(input *ListServiceInstanceOutputsInput) (req *request.Request, output *ListServiceInstanceOutputsOutput) {
	op := &request.Operation{
		Name:       opListServiceInstanceOutputs,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListServiceInstanceOutputsInput{}
	}

	output = &ListServiceInstanceOutputsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListServiceInstanceOutputs API operation for AWS Proton.
//
// Get a list service of instance Infrastructure as Code (IaC) outputs.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Proton's
// API operation ListServiceInstanceOutputs for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The input is invalid or an out-of-range value was supplied for the input
//     parameter.
//
//   - AccessDeniedException
//     There isn't sufficient access for performing this action.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ResourceNotFoundException
//     The requested resource wasn't found.
//
//   - InternalServerException
//     The request failed to register with the service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/ListServiceInstanceOutputs
func (c *Proton) ListServiceInstanceOutputs(input *ListServiceInstanceOutputsInput) (*ListServiceInstanceOutputsOutput, error) {
	req, out := c.ListServiceInstanceOutputsRequest(input)
	return out, req.Send()
}

// ListServiceInstanceOutputsWithContext is the same as ListServiceInstanceOutputs with the addition of
// the ability to pass a context and additional request options.
//
// See ListServiceInstanceOutputs for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Proton) ListServiceInstanceOutputsWithContext(ctx aws.Context, input *ListServiceInstanceOutputsInput, opts ...request.Option) (*ListServiceInstanceOutputsOutput, error) {
	req, out := c.ListServiceInstanceOutputsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListServiceInstanceOutputsPages iterates over the pages of a ListServiceInstanceOutputs operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListServiceInstanceOutputs method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListServiceInstanceOutputs operation.
//	pageNum := 0
//	err := client.ListServiceInstanceOutputsPages(params,
//	    func(page *proton.ListServiceInstanceOutputsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Proton) ListServiceInstanceOutputsPages(input *ListServiceInstanceOutputsInput, fn func(*ListServiceInstanceOutputsOutput, bool) bool) error {
	return c.ListServiceInstanceOutputsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListServiceInstanceOutputsPagesWithContext same as ListServiceInstanceOutputsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Proton) ListServiceInstanceOutputsPagesWithContext(ctx aws.Context, input *ListServiceInstanceOutputsInput, fn func(*ListServiceInstanceOutputsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListServiceInstanceOutputsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListServiceInstanceOutputsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListServiceInstanceOutputsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListServiceInstanceProvisionedResources = "ListServiceInstanceProvisionedResources"

// ListServiceInstanceProvisionedResourcesRequest generates a "aws/request.Request" representing the
// client's request for the ListServiceInstanceProvisionedResources operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListServiceInstanceProvisionedResources for more information on using the ListServiceInstanceProvisionedResources
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListServiceInstanceProvisionedResourcesRequest method.
//	req, resp := client.ListServiceInstanceProvisionedResourcesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/ListServiceInstanceProvisionedResources
func (c *Proton) ListServiceInstanceProvisionedResourcesRequest(input *ListServiceInstanceProvisionedResourcesInput) (req *request.Request, output *ListServiceInstanceProvisionedResourcesOutput) {
	op := &request.Operation{
		Name:       opListServiceInstanceProvisionedResources,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListServiceInstanceProvisionedResourcesInput{}
	}

	output = &ListServiceInstanceProvisionedResourcesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListServiceInstanceProvisionedResources API operation for AWS Proton.
//
// List provisioned resources for a service instance with details.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Proton's
// API operation ListServiceInstanceProvisionedResources for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The input is invalid or an out-of-range value was supplied for the input
//     parameter.
//
//   - AccessDeniedException
//     There isn't sufficient access for performing this action.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ResourceNotFoundException
//     The requested resource wasn't found.
//
//   - InternalServerException
//     The request failed to register with the service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/ListServiceInstanceProvisionedResources
func (c *Proton) ListServiceInstanceProvisionedResources(input *ListServiceInstanceProvisionedResourcesInput) (*ListServiceInstanceProvisionedResourcesOutput, error) {
	req, out := c.ListServiceInstanceProvisionedResourcesRequest(input)
	return out, req.Send()
}

// ListServiceInstanceProvisionedResourcesWithContext is the same as ListServiceInstanceProvisionedResources with the addition of
// the ability to pass a context and additional request options.
//
// See ListServiceInstanceProvisionedResources for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Proton) ListServiceInstanceProvisionedResourcesWithContext(ctx aws.Context, input *ListServiceInstanceProvisionedResourcesInput, opts ...request.Option) (*ListServiceInstanceProvisionedResourcesOutput, error) {
	req, out := c.ListServiceInstanceProvisionedResourcesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListServiceInstanceProvisionedResourcesPages iterates over the pages of a ListServiceInstanceProvisionedResources operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListServiceInstanceProvisionedResources method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListServiceInstanceProvisionedResources operation.
//	pageNum := 0
//	err := client.ListServiceInstanceProvisionedResourcesPages(params,
//	    func(page *proton.ListServiceInstanceProvisionedResourcesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Proton) ListServiceInstanceProvisionedResourcesPages(input *ListServiceInstanceProvisionedResourcesInput, fn func(*ListServiceInstanceProvisionedResourcesOutput, bool) bool) error {
	return c.ListServiceInstanceProvisionedResourcesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListServiceInstanceProvisionedResourcesPagesWithContext same as ListServiceInstanceProvisionedResourcesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Proton) ListServiceInstanceProvisionedResourcesPagesWithContext(ctx aws.Context, input *ListServiceInstanceProvisionedResourcesInput, fn func(*ListServiceInstanceProvisionedResourcesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListServiceInstanceProvisionedResourcesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListServiceInstanceProvisionedResourcesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListServiceInstanceProvisionedResourcesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListServiceInstances = "ListServiceInstances"

// ListServiceInstancesRequest generates a "aws/request.Request" representing the
// client's request for the ListServiceInstances operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListServiceInstances for more information on using the ListServiceInstances
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListServiceInstancesRequest method.
//	req, resp := client.ListServiceInstancesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/ListServiceInstances
func (c *Proton) ListServiceInstancesRequest(input *ListServiceInstancesInput) (req *request.Request, output *ListServiceInstancesOutput) {
	op := &request.Operation{
		Name:       opListServiceInstances,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListServiceInstancesInput{}
	}

	output = &ListServiceInstancesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListServiceInstances API operation for AWS Proton.
//
// List service instances with summary data. This action lists service instances
// of all services in the Amazon Web Services account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Proton's
// API operation ListServiceInstances for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The input is invalid or an out-of-range value was supplied for the input
//     parameter.
//
//   - AccessDeniedException
//     There isn't sufficient access for performing this action.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ResourceNotFoundException
//     The requested resource wasn't found.
//
//   - InternalServerException
//     The request failed to register with the service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/ListServiceInstances
func (c *Proton) ListServiceInstances(input *ListServiceInstancesInput) (*ListServiceInstancesOutput, error) {
	req, out := c.ListServiceInstancesRequest(input)
	return out, req.Send()
}

// ListServiceInstancesWithContext is the same as ListServiceInstances with the addition of
// the ability to pass a context and additional request options.
//
// See ListServiceInstances for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Proton) ListServiceInstancesWithContext(ctx aws.Context, input *ListServiceInstancesInput, opts ...request.Option) (*ListServiceInstancesOutput, error) {
	req, out := c.ListServiceInstancesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListServiceInstancesPages iterates over the pages of a ListServiceInstances operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListServiceInstances method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListServiceInstances operation.
//	pageNum := 0
//	err := client.ListServiceInstancesPages(params,
//	    func(page *proton.ListServiceInstancesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Proton) ListServiceInstancesPages(input *ListServiceInstancesInput, fn func(*ListServiceInstancesOutput, bool) bool) error {
	return c.ListServiceInstancesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListServiceInstancesPagesWithContext same as ListServiceInstancesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Proton) ListServiceInstancesPagesWithContext(ctx aws.Context, input *ListServiceInstancesInput, fn func(*ListServiceInstancesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListServiceInstancesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListServiceInstancesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListServiceInstancesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListServicePipelineOutputs = "ListServicePipelineOutputs"

// ListServicePipelineOutputsRequest generates a "aws/request.Request" representing the
// client's request for the ListServicePipelineOutputs operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListServicePipelineOutputs for more information on using the ListServicePipelineOutputs
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListServicePipelineOutputsRequest method.
//	req, resp := client.ListServicePipelineOutputsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/ListServicePipelineOutputs
func (c *Proton) ListServicePipelineOutputsRequest(input *ListServicePipelineOutputsInput) (req *request.Request, output *ListServicePipelineOutputsOutput) {
	op := &request.Operation{
		Name:       opListServicePipelineOutputs,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListServicePipelineOutputsInput{}
	}

	output = &ListServicePipelineOutputsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListServicePipelineOutputs API operation for AWS Proton.
//
// Get a list of service pipeline Infrastructure as Code (IaC) outputs.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Proton's
// API operation ListServicePipelineOutputs for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The input is invalid or an out-of-range value was supplied for the input
//     parameter.
//
//   - AccessDeniedException
//     There isn't sufficient access for performing this action.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ResourceNotFoundException
//     The requested resource wasn't found.
//
//   - InternalServerException
//     The request failed to register with the service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/ListServicePipelineOutputs
func (c *Proton) ListServicePipelineOutputs(input *ListServicePipelineOutputsInput) (*ListServicePipelineOutputsOutput, error) {
	req, out := c.ListServicePipelineOutputsRequest(input)
	return out, req.Send()
}

// ListServicePipelineOutputsWithContext is the same as ListServicePipelineOutputs with the addition of
// the ability to pass a context and additional request options.
//
// See ListServicePipelineOutputs for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Proton) ListServicePipelineOutputsWithContext(ctx aws.Context, input *ListServicePipelineOutputsInput, opts ...request.Option) (*ListServicePipelineOutputsOutput, error) {
	req, out := c.ListServicePipelineOutputsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListServicePipelineOutputsPages iterates over the pages of a ListServicePipelineOutputs operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListServicePipelineOutputs method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListServicePipelineOutputs operation.
//	pageNum := 0
//	err := client.ListServicePipelineOutputsPages(params,
//	    func(page *proton.ListServicePipelineOutputsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Proton) ListServicePipelineOutputsPages(input *ListServicePipelineOutputsInput, fn func(*ListServicePipelineOutputsOutput, bool) bool) error {
	return c.ListServicePipelineOutputsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListServicePipelineOutputsPagesWithContext same as ListServicePipelineOutputsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Proton) ListServicePipelineOutputsPagesWithContext(ctx aws.Context, input *ListServicePipelineOutputsInput, fn func(*ListServicePipelineOutputsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListServicePipelineOutputsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListServicePipelineOutputsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListServicePipelineOutputsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListServicePipelineProvisionedResources = "ListServicePipelineProvisionedResources"

// ListServicePipelineProvisionedResourcesRequest generates a "aws/request.Request" representing the
// client's request for the ListServicePipelineProvisionedResources operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListServicePipelineProvisionedResources for more information on using the ListServicePipelineProvisionedResources
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListServicePipelineProvisionedResourcesRequest method.
//	req, resp := client.ListServicePipelineProvisionedResourcesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/ListServicePipelineProvisionedResources
func (c *Proton) ListServicePipelineProvisionedResourcesRequest(input *ListServicePipelineProvisionedResourcesInput) (req *request.Request, output *ListServicePipelineProvisionedResourcesOutput) {
	op := &request.Operation{
		Name:       opListServicePipelineProvisionedResources,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListServicePipelineProvisionedResourcesInput{}
	}

	output = &ListServicePipelineProvisionedResourcesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListServicePipelineProvisionedResources API operation for AWS Proton.
//
// List provisioned resources for a service and pipeline with details.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Proton's
// API operation ListServicePipelineProvisionedResources for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The input is invalid or an out-of-range value was supplied for the input
//     parameter.
//
//   - AccessDeniedException
//     There isn't sufficient access for performing this action.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ResourceNotFoundException
//     The requested resource wasn't found.
//
//   - InternalServerException
//     The request failed to register with the service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/ListServicePipelineProvisionedResources
func (c *Proton) ListServicePipelineProvisionedResources(input *ListServicePipelineProvisionedResourcesInput) (*ListServicePipelineProvisionedResourcesOutput, error) {
	req, out := c.ListServicePipelineProvisionedResourcesRequest(input)
	return out, req.Send()
}

// ListServicePipelineProvisionedResourcesWithContext is the same as ListServicePipelineProvisionedResources with the addition of
// the ability to pass a context and additional request options.
//
// See ListServicePipelineProvisionedResources for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Proton) ListServicePipelineProvisionedResourcesWithContext(ctx aws.Context, input *ListServicePipelineProvisionedResourcesInput, opts ...request.Option) (*ListServicePipelineProvisionedResourcesOutput, error) {
	req, out := c.ListServicePipelineProvisionedResourcesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListServicePipelineProvisionedResourcesPages iterates over the pages of a ListServicePipelineProvisionedResources operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListServicePipelineProvisionedResources method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListServicePipelineProvisionedResources operation.
//	pageNum := 0
//	err := client.ListServicePipelineProvisionedResourcesPages(params,
//	    func(page *proton.ListServicePipelineProvisionedResourcesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Proton) ListServicePipelineProvisionedResourcesPages(input *ListServicePipelineProvisionedResourcesInput, fn func(*ListServicePipelineProvisionedResourcesOutput, bool) bool) error {
	return c.ListServicePipelineProvisionedResourcesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListServicePipelineProvisionedResourcesPagesWithContext same as ListServicePipelineProvisionedResourcesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Proton) ListServicePipelineProvisionedResourcesPagesWithContext(ctx aws.Context, input *ListServicePipelineProvisionedResourcesInput, fn func(*ListServicePipelineProvisionedResourcesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListServicePipelineProvisionedResourcesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListServicePipelineProvisionedResourcesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListServicePipelineProvisionedResourcesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListServiceTemplateVersions = "ListServiceTemplateVersions"

// ListServiceTemplateVersionsRequest generates a "aws/request.Request" representing the
// client's request for the ListServiceTemplateVersions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListServiceTemplateVersions for more information on using the ListServiceTemplateVersions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListServiceTemplateVersionsRequest method.
//	req, resp := client.ListServiceTemplateVersionsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/ListServiceTemplateVersions
func (c *Proton) ListServiceTemplateVersionsRequest(input *ListServiceTemplateVersionsInput) (req *request.Request, output *ListServiceTemplateVersionsOutput) {
	op := &request.Operation{
		Name:       opListServiceTemplateVersions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListServiceTemplateVersionsInput{}
	}

	output = &ListServiceTemplateVersionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListServiceTemplateVersions API operation for AWS Proton.
//
// List major or minor versions of a service template with detail data.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Proton's
// API operation ListServiceTemplateVersions for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The input is invalid or an out-of-range value was supplied for the input
//     parameter.
//
//   - AccessDeniedException
//     There isn't sufficient access for performing this action.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ResourceNotFoundException
//     The requested resource wasn't found.
//
//   - InternalServerException
//     The request failed to register with the service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/ListServiceTemplateVersions
func (c *Proton) ListServiceTemplateVersions(input *ListServiceTemplateVersionsInput) (*ListServiceTemplateVersionsOutput, error) {
	req, out := c.ListServiceTemplateVersionsRequest(input)
	return out, req.Send()
}

// ListServiceTemplateVersionsWithContext is the same as ListServiceTemplateVersions with the addition of
// the ability to pass a context and additional request options.
//
// See ListServiceTemplateVersions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Proton) ListServiceTemplateVersionsWithContext(ctx aws.Context, input *ListServiceTemplateVersionsInput, opts ...request.Option) (*ListServiceTemplateVersionsOutput, error) {
	req, out := c.ListServiceTemplateVersionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListServiceTemplateVersionsPages iterates over the pages of a ListServiceTemplateVersions operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListServiceTemplateVersions method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListServiceTemplateVersions operation.
//	pageNum := 0
//	err := client.ListServiceTemplateVersionsPages(params,
//	    func(page *proton.ListServiceTemplateVersionsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Proton) ListServiceTemplateVersionsPages(input *ListServiceTemplateVersionsInput, fn func(*ListServiceTemplateVersionsOutput, bool) bool) error {
	return c.ListServiceTemplateVersionsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListServiceTemplateVersionsPagesWithContext same as ListServiceTemplateVersionsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Proton) ListServiceTemplateVersionsPagesWithContext(ctx aws.Context, input *ListServiceTemplateVersionsInput, fn func(*ListServiceTemplateVersionsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListServiceTemplateVersionsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListServiceTemplateVersionsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListServiceTemplateVersionsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListServiceTemplates = "ListServiceTemplates"

// ListServiceTemplatesRequest generates a "aws/request.Request" representing the
// client's request for the ListServiceTemplates operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListServiceTemplates for more information on using the ListServiceTemplates
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListServiceTemplatesRequest method.
//	req, resp := client.ListServiceTemplatesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/ListServiceTemplates
func (c *Proton) ListServiceTemplatesRequest(input *ListServiceTemplatesInput) (req *request.Request, output *ListServiceTemplatesOutput) {
	op := &request.Operation{
		Name:       opListServiceTemplates,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListServiceTemplatesInput{}
	}

	output = &ListServiceTemplatesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListServiceTemplates API operation for AWS Proton.
//
// List service templates with detail data.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Proton's
// API operation ListServiceTemplates for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The input is invalid or an out-of-range value was supplied for the input
//     parameter.
//
//   - AccessDeniedException
//     There isn't sufficient access for performing this action.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - InternalServerException
//     The request failed to register with the service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/ListServiceTemplates
func (c *Proton) ListServiceTemplates(input *ListServiceTemplatesInput) (*ListServiceTemplatesOutput, error) {
	req, out := c.ListServiceTemplatesRequest(input)
	return out, req.Send()
}

// ListServiceTemplatesWithContext is the same as ListServiceTemplates with the addition of
// the ability to pass a context and additional request options.
//
// See ListServiceTemplates for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Proton) ListServiceTemplatesWithContext(ctx aws.Context, input *ListServiceTemplatesInput, opts ...request.Option) (*ListServiceTemplatesOutput, error) {
	req, out := c.ListServiceTemplatesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListServiceTemplatesPages iterates over the pages of a ListServiceTemplates operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListServiceTemplates method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListServiceTemplates operation.
//	pageNum := 0
//	err := client.ListServiceTemplatesPages(params,
//	    func(page *proton.ListServiceTemplatesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Proton) ListServiceTemplatesPages(input *ListServiceTemplatesInput, fn func(*ListServiceTemplatesOutput, bool) bool) error {
	return c.ListServiceTemplatesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListServiceTemplatesPagesWithContext same as ListServiceTemplatesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Proton) ListServiceTemplatesPagesWithContext(ctx aws.Context, input *ListServiceTemplatesInput, fn func(*ListServiceTemplatesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListServiceTemplatesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListServiceTemplatesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListServiceTemplatesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListServices = "ListServices"

// ListServicesRequest generates a "aws/request.Request" representing the
// client's request for the ListServices operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListServices for more information on using the ListServices
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListServicesRequest method.
//	req, resp := client.ListServicesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/ListServices
func (c *Proton) ListServicesRequest(input *ListServicesInput) (req *request.Request, output *ListServicesOutput) {
	op := &request.Operation{
		Name:       opListServices,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListServicesInput{}
	}

	output = &ListServicesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListServices API operation for AWS Proton.
//
// List services with summaries of detail data.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Proton's
// API operation ListServices for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The input is invalid or an out-of-range value was supplied for the input
//     parameter.
//
//   - AccessDeniedException
//     There isn't sufficient access for performing this action.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - InternalServerException
//     The request failed to register with the service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/ListServices
func (c *Proton) ListServices(input *ListServicesInput) (*ListServicesOutput, error) {
	req, out := c.ListServicesRequest(input)
	return out, req.Send()
}

// ListServicesWithContext is the same as ListServices with the addition of
// the ability to pass a context and additional request options.
//
// See ListServices for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Proton) ListServicesWithContext(ctx aws.Context, input *ListServicesInput, opts ...request.Option) (*ListServicesOutput, error) {
	req, out := c.ListServicesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListServicesPages iterates over the pages of a ListServices operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListServices method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListServices operation.
//	pageNum := 0
//	err := client.ListServicesPages(params,
//	    func(page *proton.ListServicesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Proton) ListServicesPages(input *ListServicesInput, fn func(*ListServicesOutput, bool) bool) error {
	return c.ListServicesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListServicesPagesWithContext same as ListServicesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Proton) ListServicesPagesWithContext(ctx aws.Context, input *ListServicesInput, fn func(*ListServicesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListServicesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListServicesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListServicesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTagsForResource = "ListTagsForResource"

// ListTagsForResourceRequest generates a "aws/request.Request" representing the
// client's request for the ListTagsForResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTagsForResource for more information on using the ListTagsForResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListTagsForResourceRequest method.
//	req, resp := client.ListTagsForResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/ListTagsForResource
func (c *Proton) ListTagsForResourceRequest(input *ListTagsForResourceInput) (req *request.Request, output *ListTagsForResourceOutput) {
	op := &request.Operation{
		Name:       opListTagsForResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListTagsForResourceInput{}
	}

	output = &ListTagsForResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTagsForResource API operation for AWS Proton.
//
// List tags for a resource. For more information, see Proton resources and
// tagging (https://docs.aws.amazon.com/proton/latest/userguide/resources.html)
// in the Proton User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Proton's
// API operation ListTagsForResource for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The input is invalid or an out-of-range value was supplied for the input
//     parameter.
//
//   - AccessDeniedException
//     There isn't sufficient access for performing this action.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ResourceNotFoundException
//     The requested resource wasn't found.
//
//   - InternalServerException
//     The request failed to register with the service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/ListTagsForResource
func (c *Proton) ListTagsForResource(input *ListTagsForResourceInput) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	return out, req.Send()
}

// ListTagsForResourceWithContext is the same as ListTagsForResource with the addition of
// the ability to pass a context and additional request options.
//
// See ListTagsForResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Proton) ListTagsForResourceWithContext(ctx aws.Context, input *ListTagsForResourceInput, opts ...request.Option) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListTagsForResourcePages iterates over the pages of a ListTagsForResource operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListTagsForResource method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListTagsForResource operation.
//	pageNum := 0
//	err := client.ListTagsForResourcePages(params,
//	    func(page *proton.ListTagsForResourceOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Proton) ListTagsForResourcePages(input *ListTagsForResourceInput, fn func(*ListTagsForResourceOutput, bool) bool) error {
	return c.ListTagsForResourcePagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListTagsForResourcePagesWithContext same as ListTagsForResourcePages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Proton) ListTagsForResourcePagesWithContext(ctx aws.Context, input *ListTagsForResourceInput, fn func(*ListTagsForResourceOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListTagsForResourceInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListTagsForResourceRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListTagsForResourceOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opNotifyResourceDeploymentStatusChange = "NotifyResourceDeploymentStatusChange"

// NotifyResourceDeploymentStatusChangeRequest generates a "aws/request.Request" representing the
// client's request for the NotifyResourceDeploymentStatusChange operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See NotifyResourceDeploymentStatusChange for more information on using the NotifyResourceDeploymentStatusChange
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the NotifyResourceDeploymentStatusChangeRequest method.
//	req, resp := client.NotifyResourceDeploymentStatusChangeRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/NotifyResourceDeploymentStatusChange
func (c *Proton) NotifyResourceDeploymentStatusChangeRequest(input *NotifyResourceDeploymentStatusChangeInput) (req *request.Request, output *NotifyResourceDeploymentStatusChangeOutput) {
	op := &request.Operation{
		Name:       opNotifyResourceDeploymentStatusChange,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &NotifyResourceDeploymentStatusChangeInput{}
	}

	output = &NotifyResourceDeploymentStatusChangeOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// NotifyResourceDeploymentStatusChange API operation for AWS Proton.
//
// Notify Proton of status changes to a provisioned resource when you use self-managed
// provisioning.
//
// For more information, see Self-managed provisioning (https://docs.aws.amazon.com/proton/latest/userguide/ag-works-prov-methods.html#ag-works-prov-methods-self)
// in the Proton User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Proton's
// API operation NotifyResourceDeploymentStatusChange for usage and error information.
//
// Returned Error Types:
//
//   - ServiceQuotaExceededException
//     A quota was exceeded. For more information, see Proton Quotas (https://docs.aws.amazon.com/proton/latest/userguide/ag-limits.html)
//     in the Proton User Guide.
//
//   - ValidationException
//     The input is invalid or an out-of-range value was supplied for the input
//     parameter.
//
//   - AccessDeniedException
//     There isn't sufficient access for performing this action.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ConflictException
//     The request couldn't be made due to a conflicting operation or resource.
//
//   - ResourceNotFoundException
//     The requested resource wasn't found.
//
//   - InternalServerException
//     The request failed to register with the service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/NotifyResourceDeploymentStatusChange
func (c *Proton) NotifyResourceDeploymentStatusChange(input *NotifyResourceDeploymentStatusChangeInput) (*NotifyResourceDeploymentStatusChangeOutput, error) {
	req, out := c.NotifyResourceDeploymentStatusChangeRequest(input)
	return out, req.Send()
}

// NotifyResourceDeploymentStatusChangeWithContext is the same as NotifyResourceDeploymentStatusChange with the addition of
// the ability to pass a context and additional request options.
//
// See NotifyResourceDeploymentStatusChange for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Proton) NotifyResourceDeploymentStatusChangeWithContext(ctx aws.Context, input *NotifyResourceDeploymentStatusChangeInput, opts ...request.Option) (*NotifyResourceDeploymentStatusChangeOutput, error) {
	req, out := c.NotifyResourceDeploymentStatusChangeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRejectEnvironmentAccountConnection = "RejectEnvironmentAccountConnection"

// RejectEnvironmentAccountConnectionRequest generates a "aws/request.Request" representing the
// client's request for the RejectEnvironmentAccountConnection operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RejectEnvironmentAccountConnection for more information on using the RejectEnvironmentAccountConnection
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the RejectEnvironmentAccountConnectionRequest method.
//	req, resp := client.RejectEnvironmentAccountConnectionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/RejectEnvironmentAccountConnection
func (c *Proton) RejectEnvironmentAccountConnectionRequest(input *RejectEnvironmentAccountConnectionInput) (req *request.Request, output *RejectEnvironmentAccountConnectionOutput) {
	op := &request.Operation{
		Name:       opRejectEnvironmentAccountConnection,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RejectEnvironmentAccountConnectionInput{}
	}

	output = &RejectEnvironmentAccountConnectionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// RejectEnvironmentAccountConnection API operation for AWS Proton.
//
// In a management account, reject an environment account connection from another
// environment account.
//
// After you reject an environment account connection request, you can't accept
// or use the rejected environment account connection.
//
// You can’t reject an environment account connection that's connected to
// an environment.
//
// For more information, see Environment account connections (https://docs.aws.amazon.com/proton/latest/userguide/ag-env-account-connections.html)
// in the Proton User guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Proton's
// API operation RejectEnvironmentAccountConnection for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The input is invalid or an out-of-range value was supplied for the input
//     parameter.
//
//   - AccessDeniedException
//     There isn't sufficient access for performing this action.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ConflictException
//     The request couldn't be made due to a conflicting operation or resource.
//
//   - ResourceNotFoundException
//     The requested resource wasn't found.
//
//   - InternalServerException
//     The request failed to register with the service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/RejectEnvironmentAccountConnection
func (c *Proton) RejectEnvironmentAccountConnection(input *RejectEnvironmentAccountConnectionInput) (*RejectEnvironmentAccountConnectionOutput, error) {
	req, out := c.RejectEnvironmentAccountConnectionRequest(input)
	return out, req.Send()
}

// RejectEnvironmentAccountConnectionWithContext is the same as RejectEnvironmentAccountConnection with the addition of
// the ability to pass a context and additional request options.
//
// See RejectEnvironmentAccountConnection for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Proton) RejectEnvironmentAccountConnectionWithContext(ctx aws.Context, input *RejectEnvironmentAccountConnectionInput, opts ...request.Option) (*RejectEnvironmentAccountConnectionOutput, error) {
	req, out := c.RejectEnvironmentAccountConnectionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTagResource = "TagResource"

// TagResourceRequest generates a "aws/request.Request" representing the
// client's request for the TagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TagResource for more information on using the TagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the TagResourceRequest method.
//	req, resp := client.TagResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/TagResource
func (c *Proton) TagResourceRequest(input *TagResourceInput) (req *request.Request, output *TagResourceOutput) {
	op := &request.Operation{
		Name:       opTagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &TagResourceInput{}
	}

	output = &TagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// TagResource API operation for AWS Proton.
//
// Tag a resource. A tag is a key-value pair of metadata that you associate
// with an Proton resource.
//
// For more information, see Proton resources and tagging (https://docs.aws.amazon.com/proton/latest/userguide/resources.html)
// in the Proton User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Proton's
// API operation TagResource for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The input is invalid or an out-of-range value was supplied for the input
//     parameter.
//
//   - AccessDeniedException
//     There isn't sufficient access for performing this action.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ConflictException
//     The request couldn't be made due to a conflicting operation or resource.
//
//   - ResourceNotFoundException
//     The requested resource wasn't found.
//
//   - InternalServerException
//     The request failed to register with the service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/TagResource
func (c *Proton) TagResource(input *TagResourceInput) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	return out, req.Send()
}

// TagResourceWithContext is the same as TagResource with the addition of
// the ability to pass a context and additional request options.
//
// See TagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Proton) TagResourceWithContext(ctx aws.Context, input *TagResourceInput, opts ...request.Option) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUntagResource = "UntagResource"

// UntagResourceRequest generates a "aws/request.Request" representing the
// client's request for the UntagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UntagResource for more information on using the UntagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UntagResourceRequest method.
//	req, resp := client.UntagResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/UntagResource
func (c *Proton) UntagResourceRequest(input *UntagResourceInput) (req *request.Request, output *UntagResourceOutput) {
	op := &request.Operation{
		Name:       opUntagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UntagResourceInput{}
	}

	output = &UntagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UntagResource API operation for AWS Proton.
//
// Remove a customer tag from a resource. A tag is a key-value pair of metadata
// associated with an Proton resource.
//
// For more information, see Proton resources and tagging (https://docs.aws.amazon.com/proton/latest/userguide/resources.html)
// in the Proton User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Proton's
// API operation UntagResource for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The input is invalid or an out-of-range value was supplied for the input
//     parameter.
//
//   - AccessDeniedException
//     There isn't sufficient access for performing this action.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ConflictException
//     The request couldn't be made due to a conflicting operation or resource.
//
//   - ResourceNotFoundException
//     The requested resource wasn't found.
//
//   - InternalServerException
//     The request failed to register with the service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/UntagResource
func (c *Proton) UntagResource(input *UntagResourceInput) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	return out, req.Send()
}

// UntagResourceWithContext is the same as UntagResource with the addition of
// the ability to pass a context and additional request options.
//
// See UntagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Proton) UntagResourceWithContext(ctx aws.Context, input *UntagResourceInput, opts ...request.Option) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateAccountSettings = "UpdateAccountSettings"

// UpdateAccountSettingsRequest generates a "aws/request.Request" representing the
// client's request for the UpdateAccountSettings operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateAccountSettings for more information on using the UpdateAccountSettings
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateAccountSettingsRequest method.
//	req, resp := client.UpdateAccountSettingsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/UpdateAccountSettings
func (c *Proton) UpdateAccountSettingsRequest(input *UpdateAccountSettingsInput) (req *request.Request, output *UpdateAccountSettingsOutput) {
	op := &request.Operation{
		Name:       opUpdateAccountSettings,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateAccountSettingsInput{}
	}

	output = &UpdateAccountSettingsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateAccountSettings API operation for AWS Proton.
//
// Update Proton settings that are used for multiple services in the Amazon
// Web Services account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Proton's
// API operation UpdateAccountSettings for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The input is invalid or an out-of-range value was supplied for the input
//     parameter.
//
//   - AccessDeniedException
//     There isn't sufficient access for performing this action.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ConflictException
//     The request couldn't be made due to a conflicting operation or resource.
//
//   - InternalServerException
//     The request failed to register with the service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/UpdateAccountSettings
func (c *Proton) UpdateAccountSettings(input *UpdateAccountSettingsInput) (*UpdateAccountSettingsOutput, error) {
	req, out := c.UpdateAccountSettingsRequest(input)
	return out, req.Send()
}

// UpdateAccountSettingsWithContext is the same as UpdateAccountSettings with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateAccountSettings for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Proton) UpdateAccountSettingsWithContext(ctx aws.Context, input *UpdateAccountSettingsInput, opts ...request.Option) (*UpdateAccountSettingsOutput, error) {
	req, out := c.UpdateAccountSettingsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateComponent = "UpdateComponent"

// UpdateComponentRequest generates a "aws/request.Request" representing the
// client's request for the UpdateComponent operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateComponent for more information on using the UpdateComponent
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateComponentRequest method.
//	req, resp := client.UpdateComponentRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/UpdateComponent
func (c *Proton) UpdateComponentRequest(input *UpdateComponentInput) (req *request.Request, output *UpdateComponentOutput) {
	op := &request.Operation{
		Name:       opUpdateComponent,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateComponentInput{}
	}

	output = &UpdateComponentOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateComponent API operation for AWS Proton.
//
// Update a component.
//
// There are a few modes for updating a component. The deploymentType field
// defines the mode.
//
// You can't update a component while its deployment status, or the deployment
// status of a service instance attached to it, is IN_PROGRESS.
//
// For more information about components, see Proton components (https://docs.aws.amazon.com/proton/latest/userguide/ag-components.html)
// in the Proton User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Proton's
// API operation UpdateComponent for usage and error information.
//
// Returned Error Types:
//
//   - ServiceQuotaExceededException
//     A quota was exceeded. For more information, see Proton Quotas (https://docs.aws.amazon.com/proton/latest/userguide/ag-limits.html)
//     in the Proton User Guide.
//
//   - ValidationException
//     The input is invalid or an out-of-range value was supplied for the input
//     parameter.
//
//   - AccessDeniedException
//     There isn't sufficient access for performing this action.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ConflictException
//     The request couldn't be made due to a conflicting operation or resource.
//
//   - ResourceNotFoundException
//     The requested resource wasn't found.
//
//   - InternalServerException
//     The request failed to register with the service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/UpdateComponent
func (c *Proton) UpdateComponent(input *UpdateComponentInput) (*UpdateComponentOutput, error) {
	req, out := c.UpdateComponentRequest(input)
	return out, req.Send()
}

// UpdateComponentWithContext is the same as UpdateComponent with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateComponent for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Proton) UpdateComponentWithContext(ctx aws.Context, input *UpdateComponentInput, opts ...request.Option) (*UpdateComponentOutput, error) {
	req, out := c.UpdateComponentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateEnvironment = "UpdateEnvironment"

// UpdateEnvironmentRequest generates a "aws/request.Request" representing the
// client's request for the UpdateEnvironment operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateEnvironment for more information on using the UpdateEnvironment
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateEnvironmentRequest method.
//	req, resp := client.UpdateEnvironmentRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/UpdateEnvironment
func (c *Proton) UpdateEnvironmentRequest(input *UpdateEnvironmentInput) (req *request.Request, output *UpdateEnvironmentOutput) {
	op := &request.Operation{
		Name:       opUpdateEnvironment,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateEnvironmentInput{}
	}

	output = &UpdateEnvironmentOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateEnvironment API operation for AWS Proton.
//
// Update an environment.
//
// If the environment is associated with an environment account connection,
// don't update or include the protonServiceRoleArn and provisioningRepository
// parameter to update or connect to an environment account connection.
//
// You can only update to a new environment account connection if that connection
// was created in the same environment account that the current environment
// account connection was created in. The account connection must also be associated
// with the current environment.
//
// If the environment isn't associated with an environment account connection,
// don't update or include the environmentAccountConnectionId parameter. You
// can't update or connect the environment to an environment account connection
// if it isn't already associated with an environment connection.
//
// You can update either the environmentAccountConnectionId or protonServiceRoleArn
// parameter and value. You can’t update both.
//
// If the environment was configured for Amazon Web Services-managed provisioning,
// omit the provisioningRepository parameter.
//
// If the environment was configured for self-managed provisioning, specify
// the provisioningRepository parameter and omit the protonServiceRoleArn and
// environmentAccountConnectionId parameters.
//
// For more information, see Environments (https://docs.aws.amazon.com/proton/latest/userguide/ag-environments.html)
// and Provisioning methods (https://docs.aws.amazon.com/proton/latest/userguide/ag-works-prov-methods.html)
// in the Proton User Guide.
//
// There are four modes for updating an environment. The deploymentType field
// defines the mode.
//
// # NONE
//
// In this mode, a deployment doesn't occur. Only the requested metadata parameters
// are updated.
//
// CURRENT_VERSION
//
// In this mode, the environment is deployed and updated with the new spec that
// you provide. Only requested parameters are updated. Don’t include minor
// or major version parameters when you use this deployment-type.
//
// MINOR_VERSION
//
// In this mode, the environment is deployed and updated with the published,
// recommended (latest) minor version of the current major version in use, by
// default. You can also specify a different minor version of the current major
// version in use.
//
// MAJOR_VERSION
//
// In this mode, the environment is deployed and updated with the published,
// recommended (latest) major and minor version of the current template, by
// default. You can also specify a different major version that's higher than
// the major version in use and a minor version.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Proton's
// API operation UpdateEnvironment for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The input is invalid or an out-of-range value was supplied for the input
//     parameter.
//
//   - AccessDeniedException
//     There isn't sufficient access for performing this action.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ConflictException
//     The request couldn't be made due to a conflicting operation or resource.
//
//   - ResourceNotFoundException
//     The requested resource wasn't found.
//
//   - InternalServerException
//     The request failed to register with the service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/UpdateEnvironment
func (c *Proton) UpdateEnvironment(input *UpdateEnvironmentInput) (*UpdateEnvironmentOutput, error) {
	req, out := c.UpdateEnvironmentRequest(input)
	return out, req.Send()
}

// UpdateEnvironmentWithContext is the same as UpdateEnvironment with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateEnvironment for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Proton) UpdateEnvironmentWithContext(ctx aws.Context, input *UpdateEnvironmentInput, opts ...request.Option) (*UpdateEnvironmentOutput, error) {
	req, out := c.UpdateEnvironmentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateEnvironmentAccountConnection = "UpdateEnvironmentAccountConnection"

// UpdateEnvironmentAccountConnectionRequest generates a "aws/request.Request" representing the
// client's request for the UpdateEnvironmentAccountConnection operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateEnvironmentAccountConnection for more information on using the UpdateEnvironmentAccountConnection
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateEnvironmentAccountConnectionRequest method.
//	req, resp := client.UpdateEnvironmentAccountConnectionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/UpdateEnvironmentAccountConnection
func (c *Proton) UpdateEnvironmentAccountConnectionRequest(input *UpdateEnvironmentAccountConnectionInput) (req *request.Request, output *UpdateEnvironmentAccountConnectionOutput) {
	op := &request.Operation{
		Name:       opUpdateEnvironmentAccountConnection,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateEnvironmentAccountConnectionInput{}
	}

	output = &UpdateEnvironmentAccountConnectionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateEnvironmentAccountConnection API operation for AWS Proton.
//
// In an environment account, update an environment account connection to use
// a new IAM role.
//
// For more information, see Environment account connections (https://docs.aws.amazon.com/proton/latest/userguide/ag-env-account-connections.html)
// in the Proton User guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Proton's
// API operation UpdateEnvironmentAccountConnection for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The input is invalid or an out-of-range value was supplied for the input
//     parameter.
//
//   - AccessDeniedException
//     There isn't sufficient access for performing this action.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ConflictException
//     The request couldn't be made due to a conflicting operation or resource.
//
//   - ResourceNotFoundException
//     The requested resource wasn't found.
//
//   - InternalServerException
//     The request failed to register with the service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/UpdateEnvironmentAccountConnection
func (c *Proton) UpdateEnvironmentAccountConnection(input *UpdateEnvironmentAccountConnectionInput) (*UpdateEnvironmentAccountConnectionOutput, error) {
	req, out := c.UpdateEnvironmentAccountConnectionRequest(input)
	return out, req.Send()
}

// UpdateEnvironmentAccountConnectionWithContext is the same as UpdateEnvironmentAccountConnection with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateEnvironmentAccountConnection for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Proton) UpdateEnvironmentAccountConnectionWithContext(ctx aws.Context, input *UpdateEnvironmentAccountConnectionInput, opts ...request.Option) (*UpdateEnvironmentAccountConnectionOutput, error) {
	req, out := c.UpdateEnvironmentAccountConnectionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateEnvironmentTemplate = "UpdateEnvironmentTemplate"

// UpdateEnvironmentTemplateRequest generates a "aws/request.Request" representing the
// client's request for the UpdateEnvironmentTemplate operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateEnvironmentTemplate for more information on using the UpdateEnvironmentTemplate
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateEnvironmentTemplateRequest method.
//	req, resp := client.UpdateEnvironmentTemplateRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/UpdateEnvironmentTemplate
func (c *Proton) UpdateEnvironmentTemplateRequest(input *UpdateEnvironmentTemplateInput) (req *request.Request, output *UpdateEnvironmentTemplateOutput) {
	op := &request.Operation{
		Name:       opUpdateEnvironmentTemplate,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateEnvironmentTemplateInput{}
	}

	output = &UpdateEnvironmentTemplateOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateEnvironmentTemplate API operation for AWS Proton.
//
// Update an environment template.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Proton's
// API operation UpdateEnvironmentTemplate for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The input is invalid or an out-of-range value was supplied for the input
//     parameter.
//
//   - AccessDeniedException
//     There isn't sufficient access for performing this action.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ConflictException
//     The request couldn't be made due to a conflicting operation or resource.
//
//   - ResourceNotFoundException
//     The requested resource wasn't found.
//
//   - InternalServerException
//     The request failed to register with the service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/UpdateEnvironmentTemplate
func (c *Proton) UpdateEnvironmentTemplate(input *UpdateEnvironmentTemplateInput) (*UpdateEnvironmentTemplateOutput, error) {
	req, out := c.UpdateEnvironmentTemplateRequest(input)
	return out, req.Send()
}

// UpdateEnvironmentTemplateWithContext is the same as UpdateEnvironmentTemplate with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateEnvironmentTemplate for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Proton) UpdateEnvironmentTemplateWithContext(ctx aws.Context, input *UpdateEnvironmentTemplateInput, opts ...request.Option) (*UpdateEnvironmentTemplateOutput, error) {
	req, out := c.UpdateEnvironmentTemplateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateEnvironmentTemplateVersion = "UpdateEnvironmentTemplateVersion"

// UpdateEnvironmentTemplateVersionRequest generates a "aws/request.Request" representing the
// client's request for the UpdateEnvironmentTemplateVersion operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateEnvironmentTemplateVersion for more information on using the UpdateEnvironmentTemplateVersion
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateEnvironmentTemplateVersionRequest method.
//	req, resp := client.UpdateEnvironmentTemplateVersionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/UpdateEnvironmentTemplateVersion
func (c *Proton) UpdateEnvironmentTemplateVersionRequest(input *UpdateEnvironmentTemplateVersionInput) (req *request.Request, output *UpdateEnvironmentTemplateVersionOutput) {
	op := &request.Operation{
		Name:       opUpdateEnvironmentTemplateVersion,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateEnvironmentTemplateVersionInput{}
	}

	output = &UpdateEnvironmentTemplateVersionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateEnvironmentTemplateVersion API operation for AWS Proton.
//
// Update a major or minor version of an environment template.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Proton's
// API operation UpdateEnvironmentTemplateVersion for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The input is invalid or an out-of-range value was supplied for the input
//     parameter.
//
//   - AccessDeniedException
//     There isn't sufficient access for performing this action.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ConflictException
//     The request couldn't be made due to a conflicting operation or resource.
//
//   - ResourceNotFoundException
//     The requested resource wasn't found.
//
//   - InternalServerException
//     The request failed to register with the service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/UpdateEnvironmentTemplateVersion
func (c *Proton) UpdateEnvironmentTemplateVersion(input *UpdateEnvironmentTemplateVersionInput) (*UpdateEnvironmentTemplateVersionOutput, error) {
	req, out := c.UpdateEnvironmentTemplateVersionRequest(input)
	return out, req.Send()
}

// UpdateEnvironmentTemplateVersionWithContext is the same as UpdateEnvironmentTemplateVersion with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateEnvironmentTemplateVersion for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Proton) UpdateEnvironmentTemplateVersionWithContext(ctx aws.Context, input *UpdateEnvironmentTemplateVersionInput, opts ...request.Option) (*UpdateEnvironmentTemplateVersionOutput, error) {
	req, out := c.UpdateEnvironmentTemplateVersionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateService = "UpdateService"

// UpdateServiceRequest generates a "aws/request.Request" representing the
// client's request for the UpdateService operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateService for more information on using the UpdateService
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateServiceRequest method.
//	req, resp := client.UpdateServiceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/UpdateService
func (c *Proton) UpdateServiceRequest(input *UpdateServiceInput) (req *request.Request, output *UpdateServiceOutput) {
	op := &request.Operation{
		Name:       opUpdateService,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateServiceInput{}
	}

	output = &UpdateServiceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateService API operation for AWS Proton.
//
// Edit a service description or use a spec to add and delete service instances.
//
// Existing service instances and the service pipeline can't be edited using
// this API. They can only be deleted.
//
// Use the description parameter to modify the description.
//
// Edit the spec parameter to add or delete instances.
//
// You can't delete a service instance (remove it from the spec) if it has an
// attached component.
//
// For more information about components, see Proton components (https://docs.aws.amazon.com/proton/latest/userguide/ag-components.html)
// in the Proton User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Proton's
// API operation UpdateService for usage and error information.
//
// Returned Error Types:
//
//   - ServiceQuotaExceededException
//     A quota was exceeded. For more information, see Proton Quotas (https://docs.aws.amazon.com/proton/latest/userguide/ag-limits.html)
//     in the Proton User Guide.
//
//   - ValidationException
//     The input is invalid or an out-of-range value was supplied for the input
//     parameter.
//
//   - AccessDeniedException
//     There isn't sufficient access for performing this action.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ConflictException
//     The request couldn't be made due to a conflicting operation or resource.
//
//   - ResourceNotFoundException
//     The requested resource wasn't found.
//
//   - InternalServerException
//     The request failed to register with the service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/UpdateService
func (c *Proton) UpdateService(input *UpdateServiceInput) (*UpdateServiceOutput, error) {
	req, out := c.UpdateServiceRequest(input)
	return out, req.Send()
}

// UpdateServiceWithContext is the same as UpdateService with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateService for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Proton) UpdateServiceWithContext(ctx aws.Context, input *UpdateServiceInput, opts ...request.Option) (*UpdateServiceOutput, error) {
	req, out := c.UpdateServiceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateServiceInstance = "UpdateServiceInstance"

// UpdateServiceInstanceRequest generates a "aws/request.Request" representing the
// client's request for the UpdateServiceInstance operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateServiceInstance for more information on using the UpdateServiceInstance
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateServiceInstanceRequest method.
//	req, resp := client.UpdateServiceInstanceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/UpdateServiceInstance
func (c *Proton) UpdateServiceInstanceRequest(input *UpdateServiceInstanceInput) (req *request.Request, output *UpdateServiceInstanceOutput) {
	op := &request.Operation{
		Name:       opUpdateServiceInstance,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateServiceInstanceInput{}
	}

	output = &UpdateServiceInstanceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateServiceInstance API operation for AWS Proton.
//
// Update a service instance.
//
// There are a few modes for updating a service instance. The deploymentType
// field defines the mode.
//
// You can't update a service instance while its deployment status, or the deployment
// status of a component attached to it, is IN_PROGRESS.
//
// For more information about components, see Proton components (https://docs.aws.amazon.com/proton/latest/userguide/ag-components.html)
// in the Proton User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Proton's
// API operation UpdateServiceInstance for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The input is invalid or an out-of-range value was supplied for the input
//     parameter.
//
//   - AccessDeniedException
//     There isn't sufficient access for performing this action.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ConflictException
//     The request couldn't be made due to a conflicting operation or resource.
//
//   - ResourceNotFoundException
//     The requested resource wasn't found.
//
//   - InternalServerException
//     The request failed to register with the service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/UpdateServiceInstance
func (c *Proton) UpdateServiceInstance(input *UpdateServiceInstanceInput) (*UpdateServiceInstanceOutput, error) {
	req, out := c.UpdateServiceInstanceRequest(input)
	return out, req.Send()
}

// UpdateServiceInstanceWithContext is the same as UpdateServiceInstance with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateServiceInstance for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Proton) UpdateServiceInstanceWithContext(ctx aws.Context, input *UpdateServiceInstanceInput, opts ...request.Option) (*UpdateServiceInstanceOutput, error) {
	req, out := c.UpdateServiceInstanceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateServicePipeline = "UpdateServicePipeline"

// UpdateServicePipelineRequest generates a "aws/request.Request" representing the
// client's request for the UpdateServicePipeline operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateServicePipeline for more information on using the UpdateServicePipeline
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateServicePipelineRequest method.
//	req, resp := client.UpdateServicePipelineRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/UpdateServicePipeline
func (c *Proton) UpdateServicePipelineRequest(input *UpdateServicePipelineInput) (req *request.Request, output *UpdateServicePipelineOutput) {
	op := &request.Operation{
		Name:       opUpdateServicePipeline,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateServicePipelineInput{}
	}

	output = &UpdateServicePipelineOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateServicePipeline API operation for AWS Proton.
//
// Update the service pipeline.
//
// There are four modes for updating a service pipeline. The deploymentType
// field defines the mode.
//
// # NONE
//
// In this mode, a deployment doesn't occur. Only the requested metadata parameters
// are updated.
//
// CURRENT_VERSION
//
// In this mode, the service pipeline is deployed and updated with the new spec
// that you provide. Only requested parameters are updated. Don’t include
// major or minor version parameters when you use this deployment-type.
//
// MINOR_VERSION
//
// In this mode, the service pipeline is deployed and updated with the published,
// recommended (latest) minor version of the current major version in use, by
// default. You can specify a different minor version of the current major version
// in use.
//
// MAJOR_VERSION
//
// In this mode, the service pipeline is deployed and updated with the published,
// recommended (latest) major and minor version of the current template by default.
// You can specify a different major version that's higher than the major version
// in use and a minor version.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Proton's
// API operation UpdateServicePipeline for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The input is invalid or an out-of-range value was supplied for the input
//     parameter.
//
//   - AccessDeniedException
//     There isn't sufficient access for performing this action.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ConflictException
//     The request couldn't be made due to a conflicting operation or resource.
//
//   - ResourceNotFoundException
//     The requested resource wasn't found.
//
//   - InternalServerException
//     The request failed to register with the service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/UpdateServicePipeline
func (c *Proton) UpdateServicePipeline(input *UpdateServicePipelineInput) (*UpdateServicePipelineOutput, error) {
	req, out := c.UpdateServicePipelineRequest(input)
	return out, req.Send()
}

// UpdateServicePipelineWithContext is the same as UpdateServicePipeline with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateServicePipeline for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Proton) UpdateServicePipelineWithContext(ctx aws.Context, input *UpdateServicePipelineInput, opts ...request.Option) (*UpdateServicePipelineOutput, error) {
	req, out := c.UpdateServicePipelineRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateServiceSyncBlocker = "UpdateServiceSyncBlocker"

// UpdateServiceSyncBlockerRequest generates a "aws/request.Request" representing the
// client's request for the UpdateServiceSyncBlocker operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateServiceSyncBlocker for more information on using the UpdateServiceSyncBlocker
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateServiceSyncBlockerRequest method.
//	req, resp := client.UpdateServiceSyncBlockerRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/UpdateServiceSyncBlocker
func (c *Proton) UpdateServiceSyncBlockerRequest(input *UpdateServiceSyncBlockerInput) (req *request.Request, output *UpdateServiceSyncBlockerOutput) {
	op := &request.Operation{
		Name:       opUpdateServiceSyncBlocker,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateServiceSyncBlockerInput{}
	}

	output = &UpdateServiceSyncBlockerOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateServiceSyncBlocker API operation for AWS Proton.
//
// Update the service sync blocker by resolving it.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Proton's
// API operation UpdateServiceSyncBlocker for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The input is invalid or an out-of-range value was supplied for the input
//     parameter.
//
//   - AccessDeniedException
//     There isn't sufficient access for performing this action.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ConflictException
//     The request couldn't be made due to a conflicting operation or resource.
//
//   - ResourceNotFoundException
//     The requested resource wasn't found.
//
//   - InternalServerException
//     The request failed to register with the service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/UpdateServiceSyncBlocker
func (c *Proton) UpdateServiceSyncBlocker(input *UpdateServiceSyncBlockerInput) (*UpdateServiceSyncBlockerOutput, error) {
	req, out := c.UpdateServiceSyncBlockerRequest(input)
	return out, req.Send()
}

// UpdateServiceSyncBlockerWithContext is the same as UpdateServiceSyncBlocker with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateServiceSyncBlocker for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Proton) UpdateServiceSyncBlockerWithContext(ctx aws.Context, input *UpdateServiceSyncBlockerInput, opts ...request.Option) (*UpdateServiceSyncBlockerOutput, error) {
	req, out := c.UpdateServiceSyncBlockerRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateServiceSyncConfig = "UpdateServiceSyncConfig"

// UpdateServiceSyncConfigRequest generates a "aws/request.Request" representing the
// client's request for the UpdateServiceSyncConfig operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateServiceSyncConfig for more information on using the UpdateServiceSyncConfig
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateServiceSyncConfigRequest method.
//	req, resp := client.UpdateServiceSyncConfigRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/UpdateServiceSyncConfig
func (c *Proton) UpdateServiceSyncConfigRequest(input *UpdateServiceSyncConfigInput) (req *request.Request, output *UpdateServiceSyncConfigOutput) {
	op := &request.Operation{
		Name:       opUpdateServiceSyncConfig,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateServiceSyncConfigInput{}
	}

	output = &UpdateServiceSyncConfigOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateServiceSyncConfig API operation for AWS Proton.
//
// Update the Proton Ops config file.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Proton's
// API operation UpdateServiceSyncConfig for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The input is invalid or an out-of-range value was supplied for the input
//     parameter.
//
//   - AccessDeniedException
//     There isn't sufficient access for performing this action.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ConflictException
//     The request couldn't be made due to a conflicting operation or resource.
//
//   - ResourceNotFoundException
//     The requested resource wasn't found.
//
//   - InternalServerException
//     The request failed to register with the service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/UpdateServiceSyncConfig
func (c *Proton) UpdateServiceSyncConfig(input *UpdateServiceSyncConfigInput) (*UpdateServiceSyncConfigOutput, error) {
	req, out := c.UpdateServiceSyncConfigRequest(input)
	return out, req.Send()
}

// UpdateServiceSyncConfigWithContext is the same as UpdateServiceSyncConfig with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateServiceSyncConfig for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Proton) UpdateServiceSyncConfigWithContext(ctx aws.Context, input *UpdateServiceSyncConfigInput, opts ...request.Option) (*UpdateServiceSyncConfigOutput, error) {
	req, out := c.UpdateServiceSyncConfigRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateServiceTemplate = "UpdateServiceTemplate"

// UpdateServiceTemplateRequest generates a "aws/request.Request" representing the
// client's request for the UpdateServiceTemplate operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateServiceTemplate for more information on using the UpdateServiceTemplate
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateServiceTemplateRequest method.
//	req, resp := client.UpdateServiceTemplateRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/UpdateServiceTemplate
func (c *Proton) UpdateServiceTemplateRequest(input *UpdateServiceTemplateInput) (req *request.Request, output *UpdateServiceTemplateOutput) {
	op := &request.Operation{
		Name:       opUpdateServiceTemplate,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateServiceTemplateInput{}
	}

	output = &UpdateServiceTemplateOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateServiceTemplate API operation for AWS Proton.
//
// Update a service template.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Proton's
// API operation UpdateServiceTemplate for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The input is invalid or an out-of-range value was supplied for the input
//     parameter.
//
//   - AccessDeniedException
//     There isn't sufficient access for performing this action.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ConflictException
//     The request couldn't be made due to a conflicting operation or resource.
//
//   - ResourceNotFoundException
//     The requested resource wasn't found.
//
//   - InternalServerException
//     The request failed to register with the service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/UpdateServiceTemplate
func (c *Proton) UpdateServiceTemplate(input *UpdateServiceTemplateInput) (*UpdateServiceTemplateOutput, error) {
	req, out := c.UpdateServiceTemplateRequest(input)
	return out, req.Send()
}

// UpdateServiceTemplateWithContext is the same as UpdateServiceTemplate with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateServiceTemplate for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Proton) UpdateServiceTemplateWithContext(ctx aws.Context, input *UpdateServiceTemplateInput, opts ...request.Option) (*UpdateServiceTemplateOutput, error) {
	req, out := c.UpdateServiceTemplateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateServiceTemplateVersion = "UpdateServiceTemplateVersion"

// UpdateServiceTemplateVersionRequest generates a "aws/request.Request" representing the
// client's request for the UpdateServiceTemplateVersion operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateServiceTemplateVersion for more information on using the UpdateServiceTemplateVersion
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateServiceTemplateVersionRequest method.
//	req, resp := client.UpdateServiceTemplateVersionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/UpdateServiceTemplateVersion
func (c *Proton) UpdateServiceTemplateVersionRequest(input *UpdateServiceTemplateVersionInput) (req *request.Request, output *UpdateServiceTemplateVersionOutput) {
	op := &request.Operation{
		Name:       opUpdateServiceTemplateVersion,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateServiceTemplateVersionInput{}
	}

	output = &UpdateServiceTemplateVersionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateServiceTemplateVersion API operation for AWS Proton.
//
// Update a major or minor version of a service template.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Proton's
// API operation UpdateServiceTemplateVersion for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The input is invalid or an out-of-range value was supplied for the input
//     parameter.
//
//   - AccessDeniedException
//     There isn't sufficient access for performing this action.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ConflictException
//     The request couldn't be made due to a conflicting operation or resource.
//
//   - ResourceNotFoundException
//     The requested resource wasn't found.
//
//   - InternalServerException
//     The request failed to register with the service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/UpdateServiceTemplateVersion
func (c *Proton) UpdateServiceTemplateVersion(input *UpdateServiceTemplateVersionInput) (*UpdateServiceTemplateVersionOutput, error) {
	req, out := c.UpdateServiceTemplateVersionRequest(input)
	return out, req.Send()
}

// UpdateServiceTemplateVersionWithContext is the same as UpdateServiceTemplateVersion with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateServiceTemplateVersion for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Proton) UpdateServiceTemplateVersionWithContext(ctx aws.Context, input *UpdateServiceTemplateVersionInput, opts ...request.Option) (*UpdateServiceTemplateVersionOutput, error) {
	req, out := c.UpdateServiceTemplateVersionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateTemplateSyncConfig = "UpdateTemplateSyncConfig"

// UpdateTemplateSyncConfigRequest generates a "aws/request.Request" representing the
// client's request for the UpdateTemplateSyncConfig operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateTemplateSyncConfig for more information on using the UpdateTemplateSyncConfig
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateTemplateSyncConfigRequest method.
//	req, resp := client.UpdateTemplateSyncConfigRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/UpdateTemplateSyncConfig
func (c *Proton) UpdateTemplateSyncConfigRequest(input *UpdateTemplateSyncConfigInput) (req *request.Request, output *UpdateTemplateSyncConfigOutput) {
	op := &request.Operation{
		Name:       opUpdateTemplateSyncConfig,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateTemplateSyncConfigInput{}
	}

	output = &UpdateTemplateSyncConfigOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateTemplateSyncConfig API operation for AWS Proton.
//
// Update template sync configuration parameters, except for the templateName
// and templateType. Repository details (branch, name, and provider) should
// be of a linked repository. A linked repository is a repository that has been
// registered with Proton. For more information, see CreateRepository.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Proton's
// API operation UpdateTemplateSyncConfig for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The input is invalid or an out-of-range value was supplied for the input
//     parameter.
//
//   - AccessDeniedException
//     There isn't sufficient access for performing this action.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
//   - ConflictException
//     The request couldn't be made due to a conflicting operation or resource.
//
//   - ResourceNotFoundException
//     The requested resource wasn't found.
//
//   - InternalServerException
//     The request failed to register with the service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/UpdateTemplateSyncConfig
func (c *Proton) UpdateTemplateSyncConfig(input *UpdateTemplateSyncConfigInput) (*UpdateTemplateSyncConfigOutput, error) {
	req, out := c.UpdateTemplateSyncConfigRequest(input)
	return out, req.Send()
}

// UpdateTemplateSyncConfigWithContext is the same as UpdateTemplateSyncConfig with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateTemplateSyncConfig for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Proton) UpdateTemplateSyncConfigWithContext(ctx aws.Context, input *UpdateTemplateSyncConfigInput, opts ...request.Option) (*UpdateTemplateSyncConfigOutput, error) {
	req, out := c.UpdateTemplateSyncConfigRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type AcceptEnvironmentAccountConnectionInput struct {
	_ struct{} `type:"structure"`

	// The ID of the environment account connection.
	//
	// Id is a required field
	Id *string `locationName:"id" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AcceptEnvironmentAccountConnectionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AcceptEnvironmentAccountConnectionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AcceptEnvironmentAccountConnectionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AcceptEnvironmentAccountConnectionInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *AcceptEnvironmentAccountConnectionInput) SetId(v string) *AcceptEnvironmentAccountConnectionInput {
	s.Id = &v
	return s
}

type AcceptEnvironmentAccountConnectionOutput struct {
	_ struct{} `type:"structure"`

	// The environment account connection data that's returned by Proton.
	//
	// EnvironmentAccountConnection is a required field
	EnvironmentAccountConnection *EnvironmentAccountConnection `locationName:"environmentAccountConnection" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AcceptEnvironmentAccountConnectionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AcceptEnvironmentAccountConnectionOutput) GoString() string {
	return s.String()
}

// SetEnvironmentAccountConnection sets the EnvironmentAccountConnection field's value.
func (s *AcceptEnvironmentAccountConnectionOutput) SetEnvironmentAccountConnection(v *EnvironmentAccountConnection) *AcceptEnvironmentAccountConnectionOutput {
	s.EnvironmentAccountConnection = v
	return s
}

// There isn't sufficient access for performing this action.
type AccessDeniedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// Message_ is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by AccessDeniedException's
	// String and GoString methods.
	Message_ *string `locationName:"message" type:"string" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) GoString() string {
	return s.String()
}

func newErrorAccessDeniedException(v protocol.ResponseMetadata) error {
	return &AccessDeniedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *AccessDeniedException) Code() string {
	return "AccessDeniedException"
}

// Message returns the exception's message.
func (s *AccessDeniedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *AccessDeniedException) OrigErr() error {
	return nil
}

func (s *AccessDeniedException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *AccessDeniedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *AccessDeniedException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Proton settings that are used for multiple services in the Amazon Web Services
// account.
type AccountSettings struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the service role that Proton uses for provisioning
	// pipelines. Proton assumes this role for CodeBuild-based provisioning.
	PipelineCodebuildRoleArn *string `locationName:"pipelineCodebuildRoleArn" type:"string"`

	// The linked repository for pipeline provisioning. Required if you have environments
	// configured for self-managed provisioning with services that include pipelines.
	// A linked repository is a repository that has been registered with Proton.
	// For more information, see CreateRepository.
	PipelineProvisioningRepository *RepositoryBranch `locationName:"pipelineProvisioningRepository" type:"structure"`

	// The Amazon Resource Name (ARN) of the service role you want to use for provisioning
	// pipelines. Assumed by Proton for Amazon Web Services-managed provisioning,
	// and by customer-owned automation for self-managed provisioning.
	PipelineServiceRoleArn *string `locationName:"pipelineServiceRoleArn" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccountSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccountSettings) GoString() string {
	return s.String()
}

// SetPipelineCodebuildRoleArn sets the PipelineCodebuildRoleArn field's value.
func (s *AccountSettings) SetPipelineCodebuildRoleArn(v string) *AccountSettings {
	s.PipelineCodebuildRoleArn = &v
	return s
}

// SetPipelineProvisioningRepository sets the PipelineProvisioningRepository field's value.
func (s *AccountSettings) SetPipelineProvisioningRepository(v *RepositoryBranch) *AccountSettings {
	s.PipelineProvisioningRepository = v
	return s
}

// SetPipelineServiceRoleArn sets the PipelineServiceRoleArn field's value.
func (s *AccountSettings) SetPipelineServiceRoleArn(v string) *AccountSettings {
	s.PipelineServiceRoleArn = &v
	return s
}

type CancelComponentDeploymentInput struct {
	_ struct{} `type:"structure"`

	// The name of the component with the deployment to cancel.
	//
	// ComponentName is a required field
	ComponentName *string `locationName:"componentName" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CancelComponentDeploymentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CancelComponentDeploymentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CancelComponentDeploymentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CancelComponentDeploymentInput"}
	if s.ComponentName == nil {
		invalidParams.Add(request.NewErrParamRequired("ComponentName"))
	}
	if s.ComponentName != nil && len(*s.ComponentName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ComponentName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetComponentName sets the ComponentName field's value.
func (s *CancelComponentDeploymentInput) SetComponentName(v string) *CancelComponentDeploymentInput {
	s.ComponentName = &v
	return s
}

type CancelComponentDeploymentOutput struct {
	_ struct{} `type:"structure"`

	// The detailed data of the component with the deployment that is being canceled.
	//
	// Component is a required field
	Component *Component `locationName:"component" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CancelComponentDeploymentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CancelComponentDeploymentOutput) GoString() string {
	return s.String()
}

// SetComponent sets the Component field's value.
func (s *CancelComponentDeploymentOutput) SetComponent(v *Component) *CancelComponentDeploymentOutput {
	s.Component = v
	return s
}

type CancelEnvironmentDeploymentInput struct {
	_ struct{} `type:"structure"`

	// The name of the environment with the deployment to cancel.
	//
	// EnvironmentName is a required field
	EnvironmentName *string `locationName:"environmentName" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CancelEnvironmentDeploymentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CancelEnvironmentDeploymentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CancelEnvironmentDeploymentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CancelEnvironmentDeploymentInput"}
	if s.EnvironmentName == nil {
		invalidParams.Add(request.NewErrParamRequired("EnvironmentName"))
	}
	if s.EnvironmentName != nil && len(*s.EnvironmentName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EnvironmentName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEnvironmentName sets the EnvironmentName field's value.
func (s *CancelEnvironmentDeploymentInput) SetEnvironmentName(v string) *CancelEnvironmentDeploymentInput {
	s.EnvironmentName = &v
	return s
}

type CancelEnvironmentDeploymentOutput struct {
	_ struct{} `type:"structure"`

	// The environment summary data that's returned by Proton.
	//
	// Environment is a required field
	Environment *Environment `locationName:"environment" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CancelEnvironmentDeploymentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CancelEnvironmentDeploymentOutput) GoString() string {
	return s.String()
}

// SetEnvironment sets the Environment field's value.
func (s *CancelEnvironmentDeploymentOutput) SetEnvironment(v *Environment) *CancelEnvironmentDeploymentOutput {
	s.Environment = v
	return s
}

type CancelServiceInstanceDeploymentInput struct {
	_ struct{} `type:"structure"`

	// The name of the service instance with the deployment to cancel.
	//
	// ServiceInstanceName is a required field
	ServiceInstanceName *string `locationName:"serviceInstanceName" min:"1" type:"string" required:"true"`

	// The name of the service with the service instance deployment to cancel.
	//
	// ServiceName is a required field
	ServiceName *string `locationName:"serviceName" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CancelServiceInstanceDeploymentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CancelServiceInstanceDeploymentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CancelServiceInstanceDeploymentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CancelServiceInstanceDeploymentInput"}
	if s.ServiceInstanceName == nil {
		invalidParams.Add(request.NewErrParamRequired("ServiceInstanceName"))
	}
	if s.ServiceInstanceName != nil && len(*s.ServiceInstanceName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ServiceInstanceName", 1))
	}
	if s.ServiceName == nil {
		invalidParams.Add(request.NewErrParamRequired("ServiceName"))
	}
	if s.ServiceName != nil && len(*s.ServiceName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ServiceName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetServiceInstanceName sets the ServiceInstanceName field's value.
func (s *CancelServiceInstanceDeploymentInput) SetServiceInstanceName(v string) *CancelServiceInstanceDeploymentInput {
	s.ServiceInstanceName = &v
	return s
}

// SetServiceName sets the ServiceName field's value.
func (s *CancelServiceInstanceDeploymentInput) SetServiceName(v string) *CancelServiceInstanceDeploymentInput {
	s.ServiceName = &v
	return s
}

type CancelServiceInstanceDeploymentOutput struct {
	_ struct{} `type:"structure"`

	// The service instance summary data that's returned by Proton.
	//
	// ServiceInstance is a required field
	ServiceInstance *ServiceInstance `locationName:"serviceInstance" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CancelServiceInstanceDeploymentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CancelServiceInstanceDeploymentOutput) GoString() string {
	return s.String()
}

// SetServiceInstance sets the ServiceInstance field's value.
func (s *CancelServiceInstanceDeploymentOutput) SetServiceInstance(v *ServiceInstance) *CancelServiceInstanceDeploymentOutput {
	s.ServiceInstance = v
	return s
}

type CancelServicePipelineDeploymentInput struct {
	_ struct{} `type:"structure"`

	// The name of the service with the service pipeline deployment to cancel.
	//
	// ServiceName is a required field
	ServiceName *string `locationName:"serviceName" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CancelServicePipelineDeploymentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CancelServicePipelineDeploymentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CancelServicePipelineDeploymentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CancelServicePipelineDeploymentInput"}
	if s.ServiceName == nil {
		invalidParams.Add(request.NewErrParamRequired("ServiceName"))
	}
	if s.ServiceName != nil && len(*s.ServiceName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ServiceName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetServiceName sets the ServiceName field's value.
func (s *CancelServicePipelineDeploymentInput) SetServiceName(v string) *CancelServicePipelineDeploymentInput {
	s.ServiceName = &v
	return s
}

type CancelServicePipelineDeploymentOutput struct {
	_ struct{} `type:"structure"`

	// The service pipeline detail data that's returned by Proton.
	//
	// Pipeline is a required field
	Pipeline *ServicePipeline `locationName:"pipeline" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CancelServicePipelineDeploymentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CancelServicePipelineDeploymentOutput) GoString() string {
	return s.String()
}

// SetPipeline sets the Pipeline field's value.
func (s *CancelServicePipelineDeploymentOutput) SetPipeline(v *ServicePipeline) *CancelServicePipelineDeploymentOutput {
	s.Pipeline = v
	return s
}

// Compatible environment template data.
type CompatibleEnvironmentTemplate struct {
	_ struct{} `type:"structure"`

	// The major version of the compatible environment template.
	//
	// MajorVersion is a required field
	MajorVersion *string `locationName:"majorVersion" min:"1" type:"string" required:"true"`

	// The compatible environment template name.
	//
	// TemplateName is a required field
	TemplateName *string `locationName:"templateName" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CompatibleEnvironmentTemplate) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CompatibleEnvironmentTemplate) GoString() string {
	return s.String()
}

// SetMajorVersion sets the MajorVersion field's value.
func (s *CompatibleEnvironmentTemplate) SetMajorVersion(v string) *CompatibleEnvironmentTemplate {
	s.MajorVersion = &v
	return s
}

// SetTemplateName sets the TemplateName field's value.
func (s *CompatibleEnvironmentTemplate) SetTemplateName(v string) *CompatibleEnvironmentTemplate {
	s.TemplateName = &v
	return s
}

// Compatible environment template data.
type CompatibleEnvironmentTemplateInput struct {
	_ struct{} `type:"structure"`

	// The major version of the compatible environment template.
	//
	// MajorVersion is a required field
	MajorVersion *string `locationName:"majorVersion" min:"1" type:"string" required:"true"`

	// The compatible environment template name.
	//
	// TemplateName is a required field
	TemplateName *string `locationName:"templateName" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CompatibleEnvironmentTemplateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CompatibleEnvironmentTemplateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CompatibleEnvironmentTemplateInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CompatibleEnvironmentTemplateInput"}
	if s.MajorVersion == nil {
		invalidParams.Add(request.NewErrParamRequired("MajorVersion"))
	}
	if s.MajorVersion != nil && len(*s.MajorVersion) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MajorVersion", 1))
	}
	if s.TemplateName == nil {
		invalidParams.Add(request.NewErrParamRequired("TemplateName"))
	}
	if s.TemplateName != nil && len(*s.TemplateName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TemplateName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMajorVersion sets the MajorVersion field's value.
func (s *CompatibleEnvironmentTemplateInput) SetMajorVersion(v string) *CompatibleEnvironmentTemplateInput {
	s.MajorVersion = &v
	return s
}

// SetTemplateName sets the TemplateName field's value.
func (s *CompatibleEnvironmentTemplateInput) SetTemplateName(v string) *CompatibleEnvironmentTemplateInput {
	s.TemplateName = &v
	return s
}

// Detailed data of an Proton component resource.
//
// For more information about components, see Proton components (https://docs.aws.amazon.com/proton/latest/userguide/ag-components.html)
// in the Proton User Guide.
type Component struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the component.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" type:"string" required:"true"`

	// The time when the component was created.
	//
	// CreatedAt is a required field
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" required:"true"`

	// The component deployment status.
	//
	// DeploymentStatus is a required field
	DeploymentStatus *string `locationName:"deploymentStatus" type:"string" required:"true" enum:"DeploymentStatus"`

	// The message associated with the component deployment status.
	//
	// DeploymentStatusMessage is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by Component's
	// String and GoString methods.
	DeploymentStatusMessage *string `locationName:"deploymentStatusMessage" type:"string" sensitive:"true"`

	// A description of the component.
	//
	// Description is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by Component's
	// String and GoString methods.
	Description *string `locationName:"description" type:"string" sensitive:"true"`

	// The name of the Proton environment that this component is associated with.
	//
	// EnvironmentName is a required field
	EnvironmentName *string `locationName:"environmentName" min:"1" type:"string" required:"true"`

	// The ID of the last attempted deployment of this component.
	LastAttemptedDeploymentId *string `locationName:"lastAttemptedDeploymentId" type:"string"`

	// The last token the client requested.
	LastClientRequestToken *string `locationName:"lastClientRequestToken" type:"string"`

	// The time when a deployment of the component was last attempted.
	LastDeploymentAttemptedAt *time.Time `locationName:"lastDeploymentAttemptedAt" type:"timestamp"`

	// The time when the component was last deployed successfully.
	LastDeploymentSucceededAt *time.Time `locationName:"lastDeploymentSucceededAt" type:"timestamp"`

	// The time when the component was last modified.
	//
	// LastModifiedAt is a required field
	LastModifiedAt *time.Time `locationName:"lastModifiedAt" type:"timestamp" required:"true"`

	// The ID of the last successful deployment of this component.
	LastSucceededDeploymentId *string `locationName:"lastSucceededDeploymentId" type:"string"`

	// The name of the component.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// The name of the service instance that this component is attached to. Provided
	// when a component is attached to a service instance.
	ServiceInstanceName *string `locationName:"serviceInstanceName" min:"1" type:"string"`

	// The name of the service that serviceInstanceName is associated with. Provided
	// when a component is attached to a service instance.
	ServiceName *string `locationName:"serviceName" min:"1" type:"string"`

	// The service spec that the component uses to access service inputs. Provided
	// when a component is attached to a service instance.
	//
	// ServiceSpec is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by Component's
	// String and GoString methods.
	ServiceSpec *string `locationName:"serviceSpec" min:"1" type:"string" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Component) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Component) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *Component) SetArn(v string) *Component {
	s.Arn = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *Component) SetCreatedAt(v time.Time) *Component {
	s.CreatedAt = &v
	return s
}

// SetDeploymentStatus sets the DeploymentStatus field's value.
func (s *Component) SetDeploymentStatus(v string) *Component {
	s.DeploymentStatus = &v
	return s
}

// SetDeploymentStatusMessage sets the DeploymentStatusMessage field's value.
func (s *Component) SetDeploymentStatusMessage(v string) *Component {
	s.DeploymentStatusMessage = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *Component) SetDescription(v string) *Component {
	s.Description = &v
	return s
}

// SetEnvironmentName sets the EnvironmentName field's value.
func (s *Component) SetEnvironmentName(v string) *Component {
	s.EnvironmentName = &v
	return s
}

// SetLastAttemptedDeploymentId sets the LastAttemptedDeploymentId field's value.
func (s *Component) SetLastAttemptedDeploymentId(v string) *Component {
	s.LastAttemptedDeploymentId = &v
	return s
}

// SetLastClientRequestToken sets the LastClientRequestToken field's value.
func (s *Component) SetLastClientRequestToken(v string) *Component {
	s.LastClientRequestToken = &v
	return s
}

// SetLastDeploymentAttemptedAt sets the LastDeploymentAttemptedAt field's value.
func (s *Component) SetLastDeploymentAttemptedAt(v time.Time) *Component {
	s.LastDeploymentAttemptedAt = &v
	return s
}

// SetLastDeploymentSucceededAt sets the LastDeploymentSucceededAt field's value.
func (s *Component) SetLastDeploymentSucceededAt(v time.Time) *Component {
	s.LastDeploymentSucceededAt = &v
	return s
}

// SetLastModifiedAt sets the LastModifiedAt field's value.
func (s *Component) SetLastModifiedAt(v time.Time) *Component {
	s.LastModifiedAt = &v
	return s
}

// SetLastSucceededDeploymentId sets the LastSucceededDeploymentId field's value.
func (s *Component) SetLastSucceededDeploymentId(v string) *Component {
	s.LastSucceededDeploymentId = &v
	return s
}

// SetName sets the Name field's value.
func (s *Component) SetName(v string) *Component {
	s.Name = &v
	return s
}

// SetServiceInstanceName sets the ServiceInstanceName field's value.
func (s *Component) SetServiceInstanceName(v string) *Component {
	s.ServiceInstanceName = &v
	return s
}

// SetServiceName sets the ServiceName field's value.
func (s *Component) SetServiceName(v string) *Component {
	s.ServiceName = &v
	return s
}

// SetServiceSpec sets the ServiceSpec field's value.
func (s *Component) SetServiceSpec(v string) *Component {
	s.ServiceSpec = &v
	return s
}

// The detailed data about the current state of the component.
type ComponentState struct {
	_ struct{} `type:"structure"`

	// The name of the service instance that this component is attached to. Provided
	// when a component is attached to a service instance.
	ServiceInstanceName *string `locationName:"serviceInstanceName" type:"string"`

	// The name of the service that serviceInstanceName is associated with. Provided
	// when a component is attached to a service instance.
	ServiceName *string `locationName:"serviceName" type:"string"`

	// The service spec that the component uses to access service inputs. Provided
	// when a component is attached to a service instance.
	//
	// ServiceSpec is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by ComponentState's
	// String and GoString methods.
	ServiceSpec *string `locationName:"serviceSpec" min:"1" type:"string" sensitive:"true"`

	// The template file used.
	//
	// TemplateFile is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by ComponentState's
	// String and GoString methods.
	TemplateFile *string `locationName:"templateFile" min:"1" type:"string" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ComponentState) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ComponentState) GoString() string {
	return s.String()
}

// SetServiceInstanceName sets the ServiceInstanceName field's value.
func (s *ComponentState) SetServiceInstanceName(v string) *ComponentState {
	s.ServiceInstanceName = &v
	return s
}

// SetServiceName sets the ServiceName field's value.
func (s *ComponentState) SetServiceName(v string) *ComponentState {
	s.ServiceName = &v
	return s
}

// SetServiceSpec sets the ServiceSpec field's value.
func (s *ComponentState) SetServiceSpec(v string) *ComponentState {
	s.ServiceSpec = &v
	return s
}

// SetTemplateFile sets the TemplateFile field's value.
func (s *ComponentState) SetTemplateFile(v string) *ComponentState {
	s.TemplateFile = &v
	return s
}

// Summary data of an Proton component resource.
//
// For more information about components, see Proton components (https://docs.aws.amazon.com/proton/latest/userguide/ag-components.html)
// in the Proton User Guide.
type ComponentSummary struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the component.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" type:"string" required:"true"`

	// The time when the component was created.
	//
	// CreatedAt is a required field
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" required:"true"`

	// The component deployment status.
	//
	// DeploymentStatus is a required field
	DeploymentStatus *string `locationName:"deploymentStatus" type:"string" required:"true" enum:"DeploymentStatus"`

	// The message associated with the component deployment status.
	//
	// DeploymentStatusMessage is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by ComponentSummary's
	// String and GoString methods.
	DeploymentStatusMessage *string `locationName:"deploymentStatusMessage" type:"string" sensitive:"true"`

	// The name of the Proton environment that this component is associated with.
	//
	// EnvironmentName is a required field
	EnvironmentName *string `locationName:"environmentName" min:"1" type:"string" required:"true"`

	// The ID of the last attempted deployment of this component.
	LastAttemptedDeploymentId *string `locationName:"lastAttemptedDeploymentId" type:"string"`

	// The time when a deployment of the component was last attempted.
	LastDeploymentAttemptedAt *time.Time `locationName:"lastDeploymentAttemptedAt" type:"timestamp"`

	// The time when the component was last deployed successfully.
	LastDeploymentSucceededAt *time.Time `locationName:"lastDeploymentSucceededAt" type:"timestamp"`

	// The time when the component was last modified.
	//
	// LastModifiedAt is a required field
	LastModifiedAt *time.Time `locationName:"lastModifiedAt" type:"timestamp" required:"true"`

	// The ID of the last successful deployment of this component.
	LastSucceededDeploymentId *string `locationName:"lastSucceededDeploymentId" type:"string"`

	// The name of the component.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// The name of the service instance that this component is attached to. Provided
	// when a component is attached to a service instance.
	ServiceInstanceName *string `locationName:"serviceInstanceName" min:"1" type:"string"`

	// The name of the service that serviceInstanceName is associated with. Provided
	// when a component is attached to a service instance.
	ServiceName *string `locationName:"serviceName" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ComponentSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ComponentSummary) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *ComponentSummary) SetArn(v string) *ComponentSummary {
	s.Arn = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *ComponentSummary) SetCreatedAt(v time.Time) *ComponentSummary {
	s.CreatedAt = &v
	return s
}

// SetDeploymentStatus sets the DeploymentStatus field's value.
func (s *ComponentSummary) SetDeploymentStatus(v string) *ComponentSummary {
	s.DeploymentStatus = &v
	return s
}

// SetDeploymentStatusMessage sets the DeploymentStatusMessage field's value.
func (s *ComponentSummary) SetDeploymentStatusMessage(v string) *ComponentSummary {
	s.DeploymentStatusMessage = &v
	return s
}

// SetEnvironmentName sets the EnvironmentName field's value.
func (s *ComponentSummary) SetEnvironmentName(v string) *ComponentSummary {
	s.EnvironmentName = &v
	return s
}

// SetLastAttemptedDeploymentId sets the LastAttemptedDeploymentId field's value.
func (s *ComponentSummary) SetLastAttemptedDeploymentId(v string) *ComponentSummary {
	s.LastAttemptedDeploymentId = &v
	return s
}

// SetLastDeploymentAttemptedAt sets the LastDeploymentAttemptedAt field's value.
func (s *ComponentSummary) SetLastDeploymentAttemptedAt(v time.Time) *ComponentSummary {
	s.LastDeploymentAttemptedAt = &v
	return s
}

// SetLastDeploymentSucceededAt sets the LastDeploymentSucceededAt field's value.
func (s *ComponentSummary) SetLastDeploymentSucceededAt(v time.Time) *ComponentSummary {
	s.LastDeploymentSucceededAt = &v
	return s
}

// SetLastModifiedAt sets the LastModifiedAt field's value.
func (s *ComponentSummary) SetLastModifiedAt(v time.Time) *ComponentSummary {
	s.LastModifiedAt = &v
	return s
}

// SetLastSucceededDeploymentId sets the LastSucceededDeploymentId field's value.
func (s *ComponentSummary) SetLastSucceededDeploymentId(v string) *ComponentSummary {
	s.LastSucceededDeploymentId = &v
	return s
}

// SetName sets the Name field's value.
func (s *ComponentSummary) SetName(v string) *ComponentSummary {
	s.Name = &v
	return s
}

// SetServiceInstanceName sets the ServiceInstanceName field's value.
func (s *ComponentSummary) SetServiceInstanceName(v string) *ComponentSummary {
	s.ServiceInstanceName = &v
	return s
}

// SetServiceName sets the ServiceName field's value.
func (s *ComponentSummary) SetServiceName(v string) *ComponentSummary {
	s.ServiceName = &v
	return s
}

// The request couldn't be made due to a conflicting operation or resource.
type ConflictException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// Message_ is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by ConflictException's
	// String and GoString methods.
	Message_ *string `locationName:"message" type:"string" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) GoString() string {
	return s.String()
}

func newErrorConflictException(v protocol.ResponseMetadata) error {
	return &ConflictException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ConflictException) Code() string {
	return "ConflictException"
}

// Message returns the exception's message.
func (s *ConflictException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ConflictException) OrigErr() error {
	return nil
}

func (s *ConflictException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ConflictException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ConflictException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Summary counts of each Proton resource type.
type CountsSummary struct {
	_ struct{} `type:"structure"`

	// The total number of components in the Amazon Web Services account.
	//
	// The semantics of the components field are different from the semantics of
	// results for other infrastructure-provisioning resources. That's because at
	// this time components don't have associated templates, therefore they don't
	// have the concept of staleness. The components object will only contain total
	// and failed members.
	Components *ResourceCountsSummary `locationName:"components" type:"structure"`

	// The total number of environment templates in the Amazon Web Services account.
	// The environmentTemplates object will only contain total members.
	EnvironmentTemplates *ResourceCountsSummary `locationName:"environmentTemplates" type:"structure"`

	// The staleness counts for Proton environments in the Amazon Web Services account.
	// The environments object will only contain total members.
	Environments *ResourceCountsSummary `locationName:"environments" type:"structure"`

	// The staleness counts for Proton pipelines in the Amazon Web Services account.
	Pipelines *ResourceCountsSummary `locationName:"pipelines" type:"structure"`

	// The staleness counts for Proton service instances in the Amazon Web Services
	// account.
	ServiceInstances *ResourceCountsSummary `locationName:"serviceInstances" type:"structure"`

	// The total number of service templates in the Amazon Web Services account.
	// The serviceTemplates object will only contain total members.
	ServiceTemplates *ResourceCountsSummary `locationName:"serviceTemplates" type:"structure"`

	// The staleness counts for Proton services in the Amazon Web Services account.
	Services *ResourceCountsSummary `locationName:"services" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CountsSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CountsSummary) GoString() string {
	return s.String()
}

// SetComponents sets the Components field's value.
func (s *CountsSummary) SetComponents(v *ResourceCountsSummary) *CountsSummary {
	s.Components = v
	return s
}

// SetEnvironmentTemplates sets the EnvironmentTemplates field's value.
func (s *CountsSummary) SetEnvironmentTemplates(v *ResourceCountsSummary) *CountsSummary {
	s.EnvironmentTemplates = v
	return s
}

// SetEnvironments sets the Environments field's value.
func (s *CountsSummary) SetEnvironments(v *ResourceCountsSummary) *CountsSummary {
	s.Environments = v
	return s
}

// SetPipelines sets the Pipelines field's value.
func (s *CountsSummary) SetPipelines(v *ResourceCountsSummary) *CountsSummary {
	s.Pipelines = v
	return s
}

// SetServiceInstances sets the ServiceInstances field's value.
func (s *CountsSummary) SetServiceInstances(v *ResourceCountsSummary) *CountsSummary {
	s.ServiceInstances = v
	return s
}

// SetServiceTemplates sets the ServiceTemplates field's value.
func (s *CountsSummary) SetServiceTemplates(v *ResourceCountsSummary) *CountsSummary {
	s.ServiceTemplates = v
	return s
}

// SetServices sets the Services field's value.
func (s *CountsSummary) SetServices(v *ResourceCountsSummary) *CountsSummary {
	s.Services = v
	return s
}

type CreateComponentInput struct {
	_ struct{} `type:"structure"`

	// The client token for the created component.
	ClientToken *string `locationName:"clientToken" type:"string" idempotencyToken:"true"`

	// An optional customer-provided description of the component.
	//
	// Description is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CreateComponentInput's
	// String and GoString methods.
	Description *string `locationName:"description" type:"string" sensitive:"true"`

	// The name of the Proton environment that you want to associate this component
	// with. You must specify this when you don't specify serviceInstanceName and
	// serviceName.
	EnvironmentName *string `locationName:"environmentName" min:"1" type:"string"`

	// A path to a manifest file that lists the Infrastructure as Code (IaC) file,
	// template language, and rendering engine for infrastructure that a custom
	// component provisions.
	//
	// Manifest is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CreateComponentInput's
	// String and GoString methods.
	//
	// Manifest is a required field
	Manifest *string `locationName:"manifest" min:"1" type:"string" required:"true" sensitive:"true"`

	// The customer-provided name of the component.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// The name of the service instance that you want to attach this component to.
	// If you don't specify this, the component isn't attached to any service instance.
	// Specify both serviceInstanceName and serviceName or neither of them.
	ServiceInstanceName *string `locationName:"serviceInstanceName" min:"1" type:"string"`

	// The name of the service that serviceInstanceName is associated with. If you
	// don't specify this, the component isn't attached to any service instance.
	// Specify both serviceInstanceName and serviceName or neither of them.
	ServiceName *string `locationName:"serviceName" min:"1" type:"string"`

	// The service spec that you want the component to use to access service inputs.
	// Set this only when you attach the component to a service instance.
	//
	// ServiceSpec is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CreateComponentInput's
	// String and GoString methods.
	ServiceSpec *string `locationName:"serviceSpec" min:"1" type:"string" sensitive:"true"`

	// An optional list of metadata items that you can associate with the Proton
	// component. A tag is a key-value pair.
	//
	// For more information, see Proton resources and tagging (https://docs.aws.amazon.com/proton/latest/userguide/resources.html)
	// in the Proton User Guide.
	Tags []*Tag `locationName:"tags" type:"list"`

	// A path to the Infrastructure as Code (IaC) file describing infrastructure
	// that a custom component provisions.
	//
	// Components support a single IaC file, even if you use Terraform as your template
	// language.
	//
	// TemplateFile is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CreateComponentInput's
	// String and GoString methods.
	//
	// TemplateFile is a required field
	TemplateFile *string `locationName:"templateFile" min:"1" type:"string" required:"true" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateComponentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateComponentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateComponentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateComponentInput"}
	if s.EnvironmentName != nil && len(*s.EnvironmentName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EnvironmentName", 1))
	}
	if s.Manifest == nil {
		invalidParams.Add(request.NewErrParamRequired("Manifest"))
	}
	if s.Manifest != nil && len(*s.Manifest) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Manifest", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.ServiceInstanceName != nil && len(*s.ServiceInstanceName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ServiceInstanceName", 1))
	}
	if s.ServiceName != nil && len(*s.ServiceName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ServiceName", 1))
	}
	if s.ServiceSpec != nil && len(*s.ServiceSpec) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ServiceSpec", 1))
	}
	if s.TemplateFile == nil {
		invalidParams.Add(request.NewErrParamRequired("TemplateFile"))
	}
	if s.TemplateFile != nil && len(*s.TemplateFile) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TemplateFile", 1))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateComponentInput) SetClientToken(v string) *CreateComponentInput {
	s.ClientToken = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateComponentInput) SetDescription(v string) *CreateComponentInput {
	s.Description = &v
	return s
}

// SetEnvironmentName sets the EnvironmentName field's value.
func (s *CreateComponentInput) SetEnvironmentName(v string) *CreateComponentInput {
	s.EnvironmentName = &v
	return s
}

// SetManifest sets the Manifest field's value.
func (s *CreateComponentInput) SetManifest(v string) *CreateComponentInput {
	s.Manifest = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateComponentInput) SetName(v string) *CreateComponentInput {
	s.Name = &v
	return s
}

// SetServiceInstanceName sets the ServiceInstanceName field's value.
func (s *CreateComponentInput) SetServiceInstanceName(v string) *CreateComponentInput {
	s.ServiceInstanceName = &v
	return s
}

// SetServiceName sets the ServiceName field's value.
func (s *CreateComponentInput) SetServiceName(v string) *CreateComponentInput {
	s.ServiceName = &v
	return s
}

// SetServiceSpec sets the ServiceSpec field's value.
func (s *CreateComponentInput) SetServiceSpec(v string) *CreateComponentInput {
	s.ServiceSpec = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateComponentInput) SetTags(v []*Tag) *CreateComponentInput {
	s.Tags = v
	return s
}

// SetTemplateFile sets the TemplateFile field's value.
func (s *CreateComponentInput) SetTemplateFile(v string) *CreateComponentInput {
	s.TemplateFile = &v
	return s
}

type CreateComponentOutput struct {
	_ struct{} `type:"structure"`

	// The detailed data of the created component.
	//
	// Component is a required field
	Component *Component `locationName:"component" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateComponentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateComponentOutput) GoString() string {
	return s.String()
}

// SetComponent sets the Component field's value.
func (s *CreateComponentOutput) SetComponent(v *Component) *CreateComponentOutput {
	s.Component = v
	return s
}

type CreateEnvironmentAccountConnectionInput struct {
	_ struct{} `type:"structure"`

	// When included, if two identical requests are made with the same client token,
	// Proton returns the environment account connection that the first request
	// created.
	ClientToken *string `locationName:"clientToken" type:"string" idempotencyToken:"true"`

	// The Amazon Resource Name (ARN) of an IAM service role in the environment
	// account. Proton uses this role to provision infrastructure resources using
	// CodeBuild-based provisioning in the associated environment account.
	CodebuildRoleArn *string `locationName:"codebuildRoleArn" min:"1" type:"string"`

	// The Amazon Resource Name (ARN) of the IAM service role that Proton uses when
	// provisioning directly defined components in the associated environment account.
	// It determines the scope of infrastructure that a component can provision
	// in the account.
	//
	// You must specify componentRoleArn to allow directly defined components to
	// be associated with any environments running in this account.
	//
	// For more information about components, see Proton components (https://docs.aws.amazon.com/proton/latest/userguide/ag-components.html)
	// in the Proton User Guide.
	ComponentRoleArn *string `locationName:"componentRoleArn" min:"1" type:"string"`

	// The name of the Proton environment that's created in the associated management
	// account.
	//
	// EnvironmentName is a required field
	EnvironmentName *string `locationName:"environmentName" min:"1" type:"string" required:"true"`

	// The ID of the management account that accepts or rejects the environment
	// account connection. You create and manage the Proton environment in this
	// account. If the management account accepts the environment account connection,
	// Proton can use the associated IAM role to provision environment infrastructure
	// resources in the associated environment account.
	//
	// ManagementAccountId is a required field
	ManagementAccountId *string `locationName:"managementAccountId" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the IAM service role that's created in
	// the environment account. Proton uses this role to provision infrastructure
	// resources in the associated environment account.
	RoleArn *string `locationName:"roleArn" min:"1" type:"string"`

	// An optional list of metadata items that you can associate with the Proton
	// environment account connection. A tag is a key-value pair.
	//
	// For more information, see Proton resources and tagging (https://docs.aws.amazon.com/proton/latest/userguide/resources.html)
	// in the Proton User Guide.
	Tags []*Tag `locationName:"tags" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateEnvironmentAccountConnectionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateEnvironmentAccountConnectionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateEnvironmentAccountConnectionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateEnvironmentAccountConnectionInput"}
	if s.CodebuildRoleArn != nil && len(*s.CodebuildRoleArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CodebuildRoleArn", 1))
	}
	if s.ComponentRoleArn != nil && len(*s.ComponentRoleArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ComponentRoleArn", 1))
	}
	if s.EnvironmentName == nil {
		invalidParams.Add(request.NewErrParamRequired("EnvironmentName"))
	}
	if s.EnvironmentName != nil && len(*s.EnvironmentName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EnvironmentName", 1))
	}
	if s.ManagementAccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("ManagementAccountId"))
	}
	if s.RoleArn != nil && len(*s.RoleArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RoleArn", 1))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateEnvironmentAccountConnectionInput) SetClientToken(v string) *CreateEnvironmentAccountConnectionInput {
	s.ClientToken = &v
	return s
}

// SetCodebuildRoleArn sets the CodebuildRoleArn field's value.
func (s *CreateEnvironmentAccountConnectionInput) SetCodebuildRoleArn(v string) *CreateEnvironmentAccountConnectionInput {
	s.CodebuildRoleArn = &v
	return s
}

// SetComponentRoleArn sets the ComponentRoleArn field's value.
func (s *CreateEnvironmentAccountConnectionInput) SetComponentRoleArn(v string) *CreateEnvironmentAccountConnectionInput {
	s.ComponentRoleArn = &v
	return s
}

// SetEnvironmentName sets the EnvironmentName field's value.
func (s *CreateEnvironmentAccountConnectionInput) SetEnvironmentName(v string) *CreateEnvironmentAccountConnectionInput {
	s.EnvironmentName = &v
	return s
}

// SetManagementAccountId sets the ManagementAccountId field's value.
func (s *CreateEnvironmentAccountConnectionInput) SetManagementAccountId(v string) *CreateEnvironmentAccountConnectionInput {
	s.ManagementAccountId = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *CreateEnvironmentAccountConnectionInput) SetRoleArn(v string) *CreateEnvironmentAccountConnectionInput {
	s.RoleArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateEnvironmentAccountConnectionInput) SetTags(v []*Tag) *CreateEnvironmentAccountConnectionInput {
	s.Tags = v
	return s
}

type CreateEnvironmentAccountConnectionOutput struct {
	_ struct{} `type:"structure"`

	// The environment account connection detail data that's returned by Proton.
	//
	// EnvironmentAccountConnection is a required field
	EnvironmentAccountConnection *EnvironmentAccountConnection `locationName:"environmentAccountConnection" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateEnvironmentAccountConnectionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateEnvironmentAccountConnectionOutput) GoString() string {
	return s.String()
}

// SetEnvironmentAccountConnection sets the EnvironmentAccountConnection field's value.
func (s *CreateEnvironmentAccountConnectionOutput) SetEnvironmentAccountConnection(v *EnvironmentAccountConnection) *CreateEnvironmentAccountConnectionOutput {
	s.EnvironmentAccountConnection = v
	return s
}

type CreateEnvironmentInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the IAM service role that allows Proton
	// to provision infrastructure using CodeBuild-based provisioning on your behalf.
	//
	// To use CodeBuild-based provisioning for the environment or for any service
	// instance running in the environment, specify either the environmentAccountConnectionId
	// or codebuildRoleArn parameter.
	CodebuildRoleArn *string `locationName:"codebuildRoleArn" min:"1" type:"string"`

	// The Amazon Resource Name (ARN) of the IAM service role that Proton uses when
	// provisioning directly defined components in this environment. It determines
	// the scope of infrastructure that a component can provision.
	//
	// You must specify componentRoleArn to allow directly defined components to
	// be associated with this environment.
	//
	// For more information about components, see Proton components (https://docs.aws.amazon.com/proton/latest/userguide/ag-components.html)
	// in the Proton User Guide.
	ComponentRoleArn *string `locationName:"componentRoleArn" min:"1" type:"string"`

	// A description of the environment that's being created and deployed.
	//
	// Description is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CreateEnvironmentInput's
	// String and GoString methods.
	Description *string `locationName:"description" type:"string" sensitive:"true"`

	// The ID of the environment account connection that you provide if you're provisioning
	// your environment infrastructure resources to an environment account. For
	// more information, see Environment account connections (https://docs.aws.amazon.com/proton/latest/userguide/ag-env-account-connections.html)
	// in the Proton User guide.
	//
	// To use Amazon Web Services-managed provisioning for the environment, specify
	// either the environmentAccountConnectionId or protonServiceRoleArn parameter
	// and omit the provisioningRepository parameter.
	EnvironmentAccountConnectionId *string `locationName:"environmentAccountConnectionId" type:"string"`

	// The name of the environment.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the Proton service role that allows Proton
	// to make calls to other services on your behalf.
	//
	// To use Amazon Web Services-managed provisioning for the environment, specify
	// either the environmentAccountConnectionId or protonServiceRoleArn parameter
	// and omit the provisioningRepository parameter.
	ProtonServiceRoleArn *string `locationName:"protonServiceRoleArn" min:"1" type:"string"`

	// The linked repository that you use to host your rendered infrastructure templates
	// for self-managed provisioning. A linked repository is a repository that has
	// been registered with Proton. For more information, see CreateRepository.
	//
	// To use self-managed provisioning for the environment, specify this parameter
	// and omit the environmentAccountConnectionId and protonServiceRoleArn parameters.
	ProvisioningRepository *RepositoryBranchInput_ `locationName:"provisioningRepository" type:"structure"`

	// A YAML formatted string that provides inputs as defined in the environment
	// template bundle schema file. For more information, see Environments (https://docs.aws.amazon.com/proton/latest/userguide/ag-environments.html)
	// in the Proton User Guide.
	//
	// Spec is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CreateEnvironmentInput's
	// String and GoString methods.
	//
	// Spec is a required field
	Spec *string `locationName:"spec" min:"1" type:"string" required:"true" sensitive:"true"`

	// An optional list of metadata items that you can associate with the Proton
	// environment. A tag is a key-value pair.
	//
	// For more information, see Proton resources and tagging (https://docs.aws.amazon.com/proton/latest/userguide/resources.html)
	// in the Proton User Guide.
	Tags []*Tag `locationName:"tags" type:"list"`

	// The major version of the environment template.
	//
	// TemplateMajorVersion is a required field
	TemplateMajorVersion *string `locationName:"templateMajorVersion" min:"1" type:"string" required:"true"`

	// The minor version of the environment template.
	TemplateMinorVersion *string `locationName:"templateMinorVersion" min:"1" type:"string"`

	// The name of the environment template. For more information, see Environment
	// Templates (https://docs.aws.amazon.com/proton/latest/userguide/ag-templates.html)
	// in the Proton User Guide.
	//
	// TemplateName is a required field
	TemplateName *string `locationName:"templateName" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateEnvironmentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateEnvironmentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateEnvironmentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateEnvironmentInput"}
	if s.CodebuildRoleArn != nil && len(*s.CodebuildRoleArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CodebuildRoleArn", 1))
	}
	if s.ComponentRoleArn != nil && len(*s.ComponentRoleArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ComponentRoleArn", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.ProtonServiceRoleArn != nil && len(*s.ProtonServiceRoleArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ProtonServiceRoleArn", 1))
	}
	if s.Spec == nil {
		invalidParams.Add(request.NewErrParamRequired("Spec"))
	}
	if s.Spec != nil && len(*s.Spec) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Spec", 1))
	}
	if s.TemplateMajorVersion == nil {
		invalidParams.Add(request.NewErrParamRequired("TemplateMajorVersion"))
	}
	if s.TemplateMajorVersion != nil && len(*s.TemplateMajorVersion) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TemplateMajorVersion", 1))
	}
	if s.TemplateMinorVersion != nil && len(*s.TemplateMinorVersion) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TemplateMinorVersion", 1))
	}
	if s.TemplateName == nil {
		invalidParams.Add(request.NewErrParamRequired("TemplateName"))
	}
	if s.TemplateName != nil && len(*s.TemplateName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TemplateName", 1))
	}
	if s.ProvisioningRepository != nil {
		if err := s.ProvisioningRepository.Validate(); err != nil {
			invalidParams.AddNested("ProvisioningRepository", err.(request.ErrInvalidParams))
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCodebuildRoleArn sets the CodebuildRoleArn field's value.
func (s *CreateEnvironmentInput) SetCodebuildRoleArn(v string) *CreateEnvironmentInput {
	s.CodebuildRoleArn = &v
	return s
}

// SetComponentRoleArn sets the ComponentRoleArn field's value.
func (s *CreateEnvironmentInput) SetComponentRoleArn(v string) *CreateEnvironmentInput {
	s.ComponentRoleArn = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateEnvironmentInput) SetDescription(v string) *CreateEnvironmentInput {
	s.Description = &v
	return s
}

// SetEnvironmentAccountConnectionId sets the EnvironmentAccountConnectionId field's value.
func (s *CreateEnvironmentInput) SetEnvironmentAccountConnectionId(v string) *CreateEnvironmentInput {
	s.EnvironmentAccountConnectionId = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateEnvironmentInput) SetName(v string) *CreateEnvironmentInput {
	s.Name = &v
	return s
}

// SetProtonServiceRoleArn sets the ProtonServiceRoleArn field's value.
func (s *CreateEnvironmentInput) SetProtonServiceRoleArn(v string) *CreateEnvironmentInput {
	s.ProtonServiceRoleArn = &v
	return s
}

// SetProvisioningRepository sets the ProvisioningRepository field's value.
func (s *CreateEnvironmentInput) SetProvisioningRepository(v *RepositoryBranchInput_) *CreateEnvironmentInput {
	s.ProvisioningRepository = v
	return s
}

// SetSpec sets the Spec field's value.
func (s *CreateEnvironmentInput) SetSpec(v string) *CreateEnvironmentInput {
	s.Spec = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateEnvironmentInput) SetTags(v []*Tag) *CreateEnvironmentInput {
	s.Tags = v
	return s
}

// SetTemplateMajorVersion sets the TemplateMajorVersion field's value.
func (s *CreateEnvironmentInput) SetTemplateMajorVersion(v string) *CreateEnvironmentInput {
	s.TemplateMajorVersion = &v
	return s
}

// SetTemplateMinorVersion sets the TemplateMinorVersion field's value.
func (s *CreateEnvironmentInput) SetTemplateMinorVersion(v string) *CreateEnvironmentInput {
	s.TemplateMinorVersion = &v
	return s
}

// SetTemplateName sets the TemplateName field's value.
func (s *CreateEnvironmentInput) SetTemplateName(v string) *CreateEnvironmentInput {
	s.TemplateName = &v
	return s
}

type CreateEnvironmentOutput struct {
	_ struct{} `type:"structure"`

	// The environment detail data that's returned by Proton.
	//
	// Environment is a required field
	Environment *Environment `locationName:"environment" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateEnvironmentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateEnvironmentOutput) GoString() string {
	return s.String()
}

// SetEnvironment sets the Environment field's value.
func (s *CreateEnvironmentOutput) SetEnvironment(v *Environment) *CreateEnvironmentOutput {
	s.Environment = v
	return s
}

type CreateEnvironmentTemplateInput struct {
	_ struct{} `type:"structure"`

	// A description of the environment template.
	//
	// Description is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CreateEnvironmentTemplateInput's
	// String and GoString methods.
	Description *string `locationName:"description" type:"string" sensitive:"true"`

	// The environment template name as displayed in the developer interface.
	//
	// DisplayName is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CreateEnvironmentTemplateInput's
	// String and GoString methods.
	DisplayName *string `locationName:"displayName" min:"1" type:"string" sensitive:"true"`

	// A customer provided encryption key that Proton uses to encrypt data.
	EncryptionKey *string `locationName:"encryptionKey" min:"1" type:"string"`

	// The name of the environment template.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// When included, indicates that the environment template is for customer provisioned
	// and managed infrastructure.
	Provisioning *string `locationName:"provisioning" type:"string" enum:"Provisioning"`

	// An optional list of metadata items that you can associate with the Proton
	// environment template. A tag is a key-value pair.
	//
	// For more information, see Proton resources and tagging (https://docs.aws.amazon.com/proton/latest/userguide/resources.html)
	// in the Proton User Guide.
	Tags []*Tag `locationName:"tags" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateEnvironmentTemplateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateEnvironmentTemplateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateEnvironmentTemplateInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateEnvironmentTemplateInput"}
	if s.DisplayName != nil && len(*s.DisplayName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DisplayName", 1))
	}
	if s.EncryptionKey != nil && len(*s.EncryptionKey) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EncryptionKey", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *CreateEnvironmentTemplateInput) SetDescription(v string) *CreateEnvironmentTemplateInput {
	s.Description = &v
	return s
}

// SetDisplayName sets the DisplayName field's value.
func (s *CreateEnvironmentTemplateInput) SetDisplayName(v string) *CreateEnvironmentTemplateInput {
	s.DisplayName = &v
	return s
}

// SetEncryptionKey sets the EncryptionKey field's value.
func (s *CreateEnvironmentTemplateInput) SetEncryptionKey(v string) *CreateEnvironmentTemplateInput {
	s.EncryptionKey = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateEnvironmentTemplateInput) SetName(v string) *CreateEnvironmentTemplateInput {
	s.Name = &v
	return s
}

// SetProvisioning sets the Provisioning field's value.
func (s *CreateEnvironmentTemplateInput) SetProvisioning(v string) *CreateEnvironmentTemplateInput {
	s.Provisioning = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateEnvironmentTemplateInput) SetTags(v []*Tag) *CreateEnvironmentTemplateInput {
	s.Tags = v
	return s
}

type CreateEnvironmentTemplateOutput struct {
	_ struct{} `type:"structure"`

	// The environment template detail data that's returned by Proton.
	//
	// EnvironmentTemplate is a required field
	EnvironmentTemplate *EnvironmentTemplate `locationName:"environmentTemplate" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateEnvironmentTemplateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateEnvironmentTemplateOutput) GoString() string {
	return s.String()
}

// SetEnvironmentTemplate sets the EnvironmentTemplate field's value.
func (s *CreateEnvironmentTemplateOutput) SetEnvironmentTemplate(v *EnvironmentTemplate) *CreateEnvironmentTemplateOutput {
	s.EnvironmentTemplate = v
	return s
}

type CreateEnvironmentTemplateVersionInput struct {
	_ struct{} `type:"structure"`

	// When included, if two identical requests are made with the same client token,
	// Proton returns the environment template version that the first request created.
	ClientToken *string `locationName:"clientToken" type:"string" idempotencyToken:"true"`

	// A description of the new version of an environment template.
	//
	// Description is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CreateEnvironmentTemplateVersionInput's
	// String and GoString methods.
	Description *string `locationName:"description" type:"string" sensitive:"true"`

	// To create a new minor version of the environment template, include major
	// Version.
	//
	// To create a new major and minor version of the environment template, exclude
	// major Version.
	MajorVersion *string `locationName:"majorVersion" min:"1" type:"string"`

	// An object that includes the template bundle S3 bucket path and name for the
	// new version of an template.
	//
	// Source is a required field
	Source *TemplateVersionSourceInput `locationName:"source" type:"structure" required:"true"`

	// An optional list of metadata items that you can associate with the Proton
	// environment template version. A tag is a key-value pair.
	//
	// For more information, see Proton resources and tagging (https://docs.aws.amazon.com/proton/latest/userguide/resources.html)
	// in the Proton User Guide.
	Tags []*Tag `locationName:"tags" type:"list"`

	// The name of the environment template.
	//
	// TemplateName is a required field
	TemplateName *string `locationName:"templateName" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateEnvironmentTemplateVersionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateEnvironmentTemplateVersionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateEnvironmentTemplateVersionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateEnvironmentTemplateVersionInput"}
	if s.MajorVersion != nil && len(*s.MajorVersion) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MajorVersion", 1))
	}
	if s.Source == nil {
		invalidParams.Add(request.NewErrParamRequired("Source"))
	}
	if s.TemplateName == nil {
		invalidParams.Add(request.NewErrParamRequired("TemplateName"))
	}
	if s.TemplateName != nil && len(*s.TemplateName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TemplateName", 1))
	}
	if s.Source != nil {
		if err := s.Source.Validate(); err != nil {
			invalidParams.AddNested("Source", err.(request.ErrInvalidParams))
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateEnvironmentTemplateVersionInput) SetClientToken(v string) *CreateEnvironmentTemplateVersionInput {
	s.ClientToken = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateEnvironmentTemplateVersionInput) SetDescription(v string) *CreateEnvironmentTemplateVersionInput {
	s.Description = &v
	return s
}

// SetMajorVersion sets the MajorVersion field's value.
func (s *CreateEnvironmentTemplateVersionInput) SetMajorVersion(v string) *CreateEnvironmentTemplateVersionInput {
	s.MajorVersion = &v
	return s
}

// SetSource sets the Source field's value.
func (s *CreateEnvironmentTemplateVersionInput) SetSource(v *TemplateVersionSourceInput) *CreateEnvironmentTemplateVersionInput {
	s.Source = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateEnvironmentTemplateVersionInput) SetTags(v []*Tag) *CreateEnvironmentTemplateVersionInput {
	s.Tags = v
	return s
}

// SetTemplateName sets the TemplateName field's value.
func (s *CreateEnvironmentTemplateVersionInput) SetTemplateName(v string) *CreateEnvironmentTemplateVersionInput {
	s.TemplateName = &v
	return s
}

type CreateEnvironmentTemplateVersionOutput struct {
	_ struct{} `type:"structure"`

	// The environment template detail data that's returned by Proton.
	//
	// EnvironmentTemplateVersion is a required field
	EnvironmentTemplateVersion *EnvironmentTemplateVersion `locationName:"environmentTemplateVersion" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateEnvironmentTemplateVersionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateEnvironmentTemplateVersionOutput) GoString() string {
	return s.String()
}

// SetEnvironmentTemplateVersion sets the EnvironmentTemplateVersion field's value.
func (s *CreateEnvironmentTemplateVersionOutput) SetEnvironmentTemplateVersion(v *EnvironmentTemplateVersion) *CreateEnvironmentTemplateVersionOutput {
	s.EnvironmentTemplateVersion = v
	return s
}

type CreateRepositoryInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of your AWS CodeStar connection that connects
	// Proton to your repository provider account. For more information, see Setting
	// up for Proton (https://docs.aws.amazon.com/proton/latest/userguide/setting-up-for-service.html)
	// in the Proton User Guide.
	//
	// ConnectionArn is a required field
	ConnectionArn *string `locationName:"connectionArn" min:"1" type:"string" required:"true"`

	// The ARN of your customer Amazon Web Services Key Management Service (Amazon
	// Web Services KMS) key.
	EncryptionKey *string `locationName:"encryptionKey" min:"1" type:"string"`

	// The repository name (for example, myrepos/myrepo).
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// The repository provider.
	//
	// Provider is a required field
	Provider *string `locationName:"provider" type:"string" required:"true" enum:"RepositoryProvider"`

	// An optional list of metadata items that you can associate with the Proton
	// repository. A tag is a key-value pair.
	//
	// For more information, see Proton resources and tagging (https://docs.aws.amazon.com/proton/latest/userguide/resources.html)
	// in the Proton User Guide.
	Tags []*Tag `locationName:"tags" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateRepositoryInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateRepositoryInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateRepositoryInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateRepositoryInput"}
	if s.ConnectionArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ConnectionArn"))
	}
	if s.ConnectionArn != nil && len(*s.ConnectionArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ConnectionArn", 1))
	}
	if s.EncryptionKey != nil && len(*s.EncryptionKey) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EncryptionKey", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Provider == nil {
		invalidParams.Add(request.NewErrParamRequired("Provider"))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConnectionArn sets the ConnectionArn field's value.
func (s *CreateRepositoryInput) SetConnectionArn(v string) *CreateRepositoryInput {
	s.ConnectionArn = &v
	return s
}

// SetEncryptionKey sets the EncryptionKey field's value.
func (s *CreateRepositoryInput) SetEncryptionKey(v string) *CreateRepositoryInput {
	s.EncryptionKey = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateRepositoryInput) SetName(v string) *CreateRepositoryInput {
	s.Name = &v
	return s
}

// SetProvider sets the Provider field's value.
func (s *CreateRepositoryInput) SetProvider(v string) *CreateRepositoryInput {
	s.Provider = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateRepositoryInput) SetTags(v []*Tag) *CreateRepositoryInput {
	s.Tags = v
	return s
}

type CreateRepositoryOutput struct {
	_ struct{} `type:"structure"`

	// The repository link's detail data that's returned by Proton.
	//
	// Repository is a required field
	Repository *Repository `locationName:"repository" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateRepositoryOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateRepositoryOutput) GoString() string {
	return s.String()
}

// SetRepository sets the Repository field's value.
func (s *CreateRepositoryOutput) SetRepository(v *Repository) *CreateRepositoryOutput {
	s.Repository = v
	return s
}

type CreateServiceInput struct {
	_ struct{} `type:"structure"`

	// The name of the code repository branch that holds the code that's deployed
	// in Proton. Don't include this parameter if your service template doesn't
	// include a service pipeline.
	BranchName *string `locationName:"branchName" min:"1" type:"string"`

	// A description of the Proton service.
	//
	// Description is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CreateServiceInput's
	// String and GoString methods.
	Description *string `locationName:"description" type:"string" sensitive:"true"`

	// The service name.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the repository connection. For more information,
	// see Setting up an AWS CodeStar connection (https://docs.aws.amazon.com/proton/latest/userguide/setting-up-for-service.html#setting-up-vcontrol)
	// in the Proton User Guide. Don't include this parameter if your service template
	// doesn't include a service pipeline.
	RepositoryConnectionArn *string `locationName:"repositoryConnectionArn" min:"1" type:"string"`

	// The ID of the code repository. Don't include this parameter if your service
	// template doesn't include a service pipeline.
	RepositoryId *string `locationName:"repositoryId" min:"1" type:"string"`

	// A link to a spec file that provides inputs as defined in the service template
	// bundle schema file. The spec file is in YAML format. Don’t include pipeline
	// inputs in the spec if your service template doesn’t include a service pipeline.
	// For more information, see Create a service (https://docs.aws.amazon.com/proton/latest/userguide/ag-create-svc.html)
	// in the Proton User Guide.
	//
	// Spec is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CreateServiceInput's
	// String and GoString methods.
	//
	// Spec is a required field
	Spec *string `locationName:"spec" min:"1" type:"string" required:"true" sensitive:"true"`

	// An optional list of metadata items that you can associate with the Proton
	// service. A tag is a key-value pair.
	//
	// For more information, see Proton resources and tagging (https://docs.aws.amazon.com/proton/latest/userguide/resources.html)
	// in the Proton User Guide.
	Tags []*Tag `locationName:"tags" type:"list"`

	// The major version of the service template that was used to create the service.
	//
	// TemplateMajorVersion is a required field
	TemplateMajorVersion *string `locationName:"templateMajorVersion" min:"1" type:"string" required:"true"`

	// The minor version of the service template that was used to create the service.
	TemplateMinorVersion *string `locationName:"templateMinorVersion" min:"1" type:"string"`

	// The name of the service template that's used to create the service.
	//
	// TemplateName is a required field
	TemplateName *string `locationName:"templateName" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateServiceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateServiceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateServiceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateServiceInput"}
	if s.BranchName != nil && len(*s.BranchName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("BranchName", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.RepositoryConnectionArn != nil && len(*s.RepositoryConnectionArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RepositoryConnectionArn", 1))
	}
	if s.RepositoryId != nil && len(*s.RepositoryId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RepositoryId", 1))
	}
	if s.Spec == nil {
		invalidParams.Add(request.NewErrParamRequired("Spec"))
	}
	if s.Spec != nil && len(*s.Spec) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Spec", 1))
	}
	if s.TemplateMajorVersion == nil {
		invalidParams.Add(request.NewErrParamRequired("TemplateMajorVersion"))
	}
	if s.TemplateMajorVersion != nil && len(*s.TemplateMajorVersion) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TemplateMajorVersion", 1))
	}
	if s.TemplateMinorVersion != nil && len(*s.TemplateMinorVersion) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TemplateMinorVersion", 1))
	}
	if s.TemplateName == nil {
		invalidParams.Add(request.NewErrParamRequired("TemplateName"))
	}
	if s.TemplateName != nil && len(*s.TemplateName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TemplateName", 1))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBranchName sets the BranchName field's value.
func (s *CreateServiceInput) SetBranchName(v string) *CreateServiceInput {
	s.BranchName = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateServiceInput) SetDescription(v string) *CreateServiceInput {
	s.Description = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateServiceInput) SetName(v string) *CreateServiceInput {
	s.Name = &v
	return s
}

// SetRepositoryConnectionArn sets the RepositoryConnectionArn field's value.
func (s *CreateServiceInput) SetRepositoryConnectionArn(v string) *CreateServiceInput {
	s.RepositoryConnectionArn = &v
	return s
}

// SetRepositoryId sets the RepositoryId field's value.
func (s *CreateServiceInput) SetRepositoryId(v string) *CreateServiceInput {
	s.RepositoryId = &v
	return s
}

// SetSpec sets the Spec field's value.
func (s *CreateServiceInput) SetSpec(v string) *CreateServiceInput {
	s.Spec = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateServiceInput) SetTags(v []*Tag) *CreateServiceInput {
	s.Tags = v
	return s
}

// SetTemplateMajorVersion sets the TemplateMajorVersion field's value.
func (s *CreateServiceInput) SetTemplateMajorVersion(v string) *CreateServiceInput {
	s.TemplateMajorVersion = &v
	return s
}

// SetTemplateMinorVersion sets the TemplateMinorVersion field's value.
func (s *CreateServiceInput) SetTemplateMinorVersion(v string) *CreateServiceInput {
	s.TemplateMinorVersion = &v
	return s
}

// SetTemplateName sets the TemplateName field's value.
func (s *CreateServiceInput) SetTemplateName(v string) *CreateServiceInput {
	s.TemplateName = &v
	return s
}

type CreateServiceInstanceInput struct {
	_ struct{} `type:"structure"`

	// The client token of the service instance to create.
	ClientToken *string `locationName:"clientToken" type:"string" idempotencyToken:"true"`

	// The name of the service instance to create.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// The name of the service the service instance is added to.
	//
	// ServiceName is a required field
	ServiceName *string `locationName:"serviceName" min:"1" type:"string" required:"true"`

	// The spec for the service instance you want to create.
	//
	// Spec is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CreateServiceInstanceInput's
	// String and GoString methods.
	//
	// Spec is a required field
	Spec *string `locationName:"spec" min:"1" type:"string" required:"true" sensitive:"true"`

	// An optional list of metadata items that you can associate with the Proton
	// service instance. A tag is a key-value pair.
	//
	// For more information, see Proton resources and tagging (https://docs.aws.amazon.com/proton/latest/userguide/resources.html)
	// in the Proton User Guide.
	Tags []*Tag `locationName:"tags" type:"list"`

	// To create a new major and minor version of the service template, exclude
	// major Version.
	TemplateMajorVersion *string `locationName:"templateMajorVersion" min:"1" type:"string"`

	// To create a new minor version of the service template, include a major Version.
	TemplateMinorVersion *string `locationName:"templateMinorVersion" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateServiceInstanceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateServiceInstanceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateServiceInstanceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateServiceInstanceInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.ServiceName == nil {
		invalidParams.Add(request.NewErrParamRequired("ServiceName"))
	}
	if s.ServiceName != nil && len(*s.ServiceName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ServiceName", 1))
	}
	if s.Spec == nil {
		invalidParams.Add(request.NewErrParamRequired("Spec"))
	}
	if s.Spec != nil && len(*s.Spec) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Spec", 1))
	}
	if s.TemplateMajorVersion != nil && len(*s.TemplateMajorVersion) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TemplateMajorVersion", 1))
	}
	if s.TemplateMinorVersion != nil && len(*s.TemplateMinorVersion) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TemplateMinorVersion", 1))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateServiceInstanceInput) SetClientToken(v string) *CreateServiceInstanceInput {
	s.ClientToken = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateServiceInstanceInput) SetName(v string) *CreateServiceInstanceInput {
	s.Name = &v
	return s
}

// SetServiceName sets the ServiceName field's value.
func (s *CreateServiceInstanceInput) SetServiceName(v string) *CreateServiceInstanceInput {
	s.ServiceName = &v
	return s
}

// SetSpec sets the Spec field's value.
func (s *CreateServiceInstanceInput) SetSpec(v string) *CreateServiceInstanceInput {
	s.Spec = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateServiceInstanceInput) SetTags(v []*Tag) *CreateServiceInstanceInput {
	s.Tags = v
	return s
}

// SetTemplateMajorVersion sets the TemplateMajorVersion field's value.
func (s *CreateServiceInstanceInput) SetTemplateMajorVersion(v string) *CreateServiceInstanceInput {
	s.TemplateMajorVersion = &v
	return s
}

// SetTemplateMinorVersion sets the TemplateMinorVersion field's value.
func (s *CreateServiceInstanceInput) SetTemplateMinorVersion(v string) *CreateServiceInstanceInput {
	s.TemplateMinorVersion = &v
	return s
}

type CreateServiceInstanceOutput struct {
	_ struct{} `type:"structure"`

	// The detailed data of the service instance being created.
	//
	// ServiceInstance is a required field
	ServiceInstance *ServiceInstance `locationName:"serviceInstance" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateServiceInstanceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateServiceInstanceOutput) GoString() string {
	return s.String()
}

// SetServiceInstance sets the ServiceInstance field's value.
func (s *CreateServiceInstanceOutput) SetServiceInstance(v *ServiceInstance) *CreateServiceInstanceOutput {
	s.ServiceInstance = v
	return s
}

type CreateServiceOutput struct {
	_ struct{} `type:"structure"`

	// The service detail data that's returned by Proton.
	//
	// Service is a required field
	Service *Service `locationName:"service" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateServiceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateServiceOutput) GoString() string {
	return s.String()
}

// SetService sets the Service field's value.
func (s *CreateServiceOutput) SetService(v *Service) *CreateServiceOutput {
	s.Service = v
	return s
}

type CreateServiceSyncConfigInput struct {
	_ struct{} `type:"structure"`

	// The repository branch for your Proton Ops file.
	//
	// Branch is a required field
	Branch *string `locationName:"branch" min:"1" type:"string" required:"true"`

	// The path to the Proton Ops file.
	//
	// FilePath is a required field
	FilePath *string `locationName:"filePath" min:"1" type:"string" required:"true"`

	// The repository name.
	//
	// RepositoryName is a required field
	RepositoryName *string `locationName:"repositoryName" min:"1" type:"string" required:"true"`

	// The provider type for your repository.
	//
	// RepositoryProvider is a required field
	RepositoryProvider *string `locationName:"repositoryProvider" type:"string" required:"true" enum:"RepositoryProvider"`

	// The name of the service the Proton Ops file is for.
	//
	// ServiceName is a required field
	ServiceName *string `locationName:"serviceName" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateServiceSyncConfigInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateServiceSyncConfigInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateServiceSyncConfigInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateServiceSyncConfigInput"}
	if s.Branch == nil {
		invalidParams.Add(request.NewErrParamRequired("Branch"))
	}
	if s.Branch != nil && len(*s.Branch) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Branch", 1))
	}
	if s.FilePath == nil {
		invalidParams.Add(request.NewErrParamRequired("FilePath"))
	}
	if s.FilePath != nil && len(*s.FilePath) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FilePath", 1))
	}
	if s.RepositoryName == nil {
		invalidParams.Add(request.NewErrParamRequired("RepositoryName"))
	}
	if s.RepositoryName != nil && len(*s.RepositoryName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RepositoryName", 1))
	}
	if s.RepositoryProvider == nil {
		invalidParams.Add(request.NewErrParamRequired("RepositoryProvider"))
	}
	if s.ServiceName == nil {
		invalidParams.Add(request.NewErrParamRequired("ServiceName"))
	}
	if s.ServiceName != nil && len(*s.ServiceName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ServiceName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBranch sets the Branch field's value.
func (s *CreateServiceSyncConfigInput) SetBranch(v string) *CreateServiceSyncConfigInput {
	s.Branch = &v
	return s
}

// SetFilePath sets the FilePath field's value.
func (s *CreateServiceSyncConfigInput) SetFilePath(v string) *CreateServiceSyncConfigInput {
	s.FilePath = &v
	return s
}

// SetRepositoryName sets the RepositoryName field's value.
func (s *CreateServiceSyncConfigInput) SetRepositoryName(v string) *CreateServiceSyncConfigInput {
	s.RepositoryName = &v
	return s
}

// SetRepositoryProvider sets the RepositoryProvider field's value.
func (s *CreateServiceSyncConfigInput) SetRepositoryProvider(v string) *CreateServiceSyncConfigInput {
	s.RepositoryProvider = &v
	return s
}

// SetServiceName sets the ServiceName field's value.
func (s *CreateServiceSyncConfigInput) SetServiceName(v string) *CreateServiceSyncConfigInput {
	s.ServiceName = &v
	return s
}

type CreateServiceSyncConfigOutput struct {
	_ struct{} `type:"structure"`

	// The detailed data of the Proton Ops file.
	ServiceSyncConfig *ServiceSyncConfig `locationName:"serviceSyncConfig" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateServiceSyncConfigOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateServiceSyncConfigOutput) GoString() string {
	return s.String()
}

// SetServiceSyncConfig sets the ServiceSyncConfig field's value.
func (s *CreateServiceSyncConfigOutput) SetServiceSyncConfig(v *ServiceSyncConfig) *CreateServiceSyncConfigOutput {
	s.ServiceSyncConfig = v
	return s
}

type CreateServiceTemplateInput struct {
	_ struct{} `type:"structure"`

	// A description of the service template.
	//
	// Description is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CreateServiceTemplateInput's
	// String and GoString methods.
	Description *string `locationName:"description" type:"string" sensitive:"true"`

	// The name of the service template as displayed in the developer interface.
	//
	// DisplayName is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CreateServiceTemplateInput's
	// String and GoString methods.
	DisplayName *string `locationName:"displayName" min:"1" type:"string" sensitive:"true"`

	// A customer provided encryption key that's used to encrypt data.
	EncryptionKey *string `locationName:"encryptionKey" min:"1" type:"string"`

	// The name of the service template.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// By default, Proton provides a service pipeline for your service. When this
	// parameter is included, it indicates that an Proton service pipeline isn't
	// provided for your service. After it's included, it can't be changed. For
	// more information, see Template bundles (https://docs.aws.amazon.com/proton/latest/userguide/ag-template-authoring.html#ag-template-bundles)
	// in the Proton User Guide.
	PipelineProvisioning *string `locationName:"pipelineProvisioning" type:"string" enum:"Provisioning"`

	// An optional list of metadata items that you can associate with the Proton
	// service template. A tag is a key-value pair.
	//
	// For more information, see Proton resources and tagging (https://docs.aws.amazon.com/proton/latest/userguide/resources.html)
	// in the Proton User Guide.
	Tags []*Tag `locationName:"tags" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateServiceTemplateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateServiceTemplateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateServiceTemplateInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateServiceTemplateInput"}
	if s.DisplayName != nil && len(*s.DisplayName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DisplayName", 1))
	}
	if s.EncryptionKey != nil && len(*s.EncryptionKey) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EncryptionKey", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *CreateServiceTemplateInput) SetDescription(v string) *CreateServiceTemplateInput {
	s.Description = &v
	return s
}

// SetDisplayName sets the DisplayName field's value.
func (s *CreateServiceTemplateInput) SetDisplayName(v string) *CreateServiceTemplateInput {
	s.DisplayName = &v
	return s
}

// SetEncryptionKey sets the EncryptionKey field's value.
func (s *CreateServiceTemplateInput) SetEncryptionKey(v string) *CreateServiceTemplateInput {
	s.EncryptionKey = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateServiceTemplateInput) SetName(v string) *CreateServiceTemplateInput {
	s.Name = &v
	return s
}

// SetPipelineProvisioning sets the PipelineProvisioning field's value.
func (s *CreateServiceTemplateInput) SetPipelineProvisioning(v string) *CreateServiceTemplateInput {
	s.PipelineProvisioning = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateServiceTemplateInput) SetTags(v []*Tag) *CreateServiceTemplateInput {
	s.Tags = v
	return s
}

type CreateServiceTemplateOutput struct {
	_ struct{} `type:"structure"`

	// The service template detail data that's returned by Proton.
	//
	// ServiceTemplate is a required field
	ServiceTemplate *ServiceTemplate `locationName:"serviceTemplate" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateServiceTemplateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateServiceTemplateOutput) GoString() string {
	return s.String()
}

// SetServiceTemplate sets the ServiceTemplate field's value.
func (s *CreateServiceTemplateOutput) SetServiceTemplate(v *ServiceTemplate) *CreateServiceTemplateOutput {
	s.ServiceTemplate = v
	return s
}

type CreateServiceTemplateVersionInput struct {
	_ struct{} `type:"structure"`

	// When included, if two identical requests are made with the same client token,
	// Proton returns the service template version that the first request created.
	ClientToken *string `locationName:"clientToken" type:"string" idempotencyToken:"true"`

	// An array of environment template objects that are compatible with the new
	// service template version. A service instance based on this service template
	// version can run in environments based on compatible templates.
	//
	// CompatibleEnvironmentTemplates is a required field
	CompatibleEnvironmentTemplates []*CompatibleEnvironmentTemplateInput `locationName:"compatibleEnvironmentTemplates" min:"1" type:"list" required:"true"`

	// A description of the new version of a service template.
	//
	// Description is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CreateServiceTemplateVersionInput's
	// String and GoString methods.
	Description *string `locationName:"description" type:"string" sensitive:"true"`

	// To create a new minor version of the service template, include a major Version.
	//
	// To create a new major and minor version of the service template, exclude
	// major Version.
	MajorVersion *string `locationName:"majorVersion" min:"1" type:"string"`

	// An object that includes the template bundle S3 bucket path and name for the
	// new version of a service template.
	//
	// Source is a required field
	Source *TemplateVersionSourceInput `locationName:"source" type:"structure" required:"true"`

	// An array of supported component sources. Components with supported sources
	// can be attached to service instances based on this service template version.
	//
	// For more information about components, see Proton components (https://docs.aws.amazon.com/proton/latest/userguide/ag-components.html)
	// in the Proton User Guide.
	SupportedComponentSources []*string `locationName:"supportedComponentSources" type:"list" enum:"ServiceTemplateSupportedComponentSourceType"`

	// An optional list of metadata items that you can associate with the Proton
	// service template version. A tag is a key-value pair.
	//
	// For more information, see Proton resources and tagging (https://docs.aws.amazon.com/proton/latest/userguide/resources.html)
	// in the Proton User Guide.
	Tags []*Tag `locationName:"tags" type:"list"`

	// The name of the service template.
	//
	// TemplateName is a required field
	TemplateName *string `locationName:"templateName" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateServiceTemplateVersionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateServiceTemplateVersionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateServiceTemplateVersionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateServiceTemplateVersionInput"}
	if s.CompatibleEnvironmentTemplates == nil {
		invalidParams.Add(request.NewErrParamRequired("CompatibleEnvironmentTemplates"))
	}
	if s.CompatibleEnvironmentTemplates != nil && len(s.CompatibleEnvironmentTemplates) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CompatibleEnvironmentTemplates", 1))
	}
	if s.MajorVersion != nil && len(*s.MajorVersion) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MajorVersion", 1))
	}
	if s.Source == nil {
		invalidParams.Add(request.NewErrParamRequired("Source"))
	}
	if s.TemplateName == nil {
		invalidParams.Add(request.NewErrParamRequired("TemplateName"))
	}
	if s.TemplateName != nil && len(*s.TemplateName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TemplateName", 1))
	}
	if s.CompatibleEnvironmentTemplates != nil {
		for i, v := range s.CompatibleEnvironmentTemplates {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "CompatibleEnvironmentTemplates", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.Source != nil {
		if err := s.Source.Validate(); err != nil {
			invalidParams.AddNested("Source", err.(request.ErrInvalidParams))
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateServiceTemplateVersionInput) SetClientToken(v string) *CreateServiceTemplateVersionInput {
	s.ClientToken = &v
	return s
}

// SetCompatibleEnvironmentTemplates sets the CompatibleEnvironmentTemplates field's value.
func (s *CreateServiceTemplateVersionInput) SetCompatibleEnvironmentTemplates(v []*CompatibleEnvironmentTemplateInput) *CreateServiceTemplateVersionInput {
	s.CompatibleEnvironmentTemplates = v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateServiceTemplateVersionInput) SetDescription(v string) *CreateServiceTemplateVersionInput {
	s.Description = &v
	return s
}

// SetMajorVersion sets the MajorVersion field's value.
func (s *CreateServiceTemplateVersionInput) SetMajorVersion(v string) *CreateServiceTemplateVersionInput {
	s.MajorVersion = &v
	return s
}

// SetSource sets the Source field's value.
func (s *CreateServiceTemplateVersionInput) SetSource(v *TemplateVersionSourceInput) *CreateServiceTemplateVersionInput {
	s.Source = v
	return s
}

// SetSupportedComponentSources sets the SupportedComponentSources field's value.
func (s *CreateServiceTemplateVersionInput) SetSupportedComponentSources(v []*string) *CreateServiceTemplateVersionInput {
	s.SupportedComponentSources = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateServiceTemplateVersionInput) SetTags(v []*Tag) *CreateServiceTemplateVersionInput {
	s.Tags = v
	return s
}

// SetTemplateName sets the TemplateName field's value.
func (s *CreateServiceTemplateVersionInput) SetTemplateName(v string) *CreateServiceTemplateVersionInput {
	s.TemplateName = &v
	return s
}

type CreateServiceTemplateVersionOutput struct {
	_ struct{} `type:"structure"`

	// The service template version summary of detail data that's returned by Proton.
	//
	// ServiceTemplateVersion is a required field
	ServiceTemplateVersion *ServiceTemplateVersion `locationName:"serviceTemplateVersion" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateServiceTemplateVersionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateServiceTemplateVersionOutput) GoString() string {
	return s.String()
}

// SetServiceTemplateVersion sets the ServiceTemplateVersion field's value.
func (s *CreateServiceTemplateVersionOutput) SetServiceTemplateVersion(v *ServiceTemplateVersion) *CreateServiceTemplateVersionOutput {
	s.ServiceTemplateVersion = v
	return s
}

type CreateTemplateSyncConfigInput struct {
	_ struct{} `type:"structure"`

	// The repository branch for your template.
	//
	// Branch is a required field
	Branch *string `locationName:"branch" min:"1" type:"string" required:"true"`

	// The repository name (for example, myrepos/myrepo).
	//
	// RepositoryName is a required field
	RepositoryName *string `locationName:"repositoryName" min:"1" type:"string" required:"true"`

	// The provider type for your repository.
	//
	// RepositoryProvider is a required field
	RepositoryProvider *string `locationName:"repositoryProvider" type:"string" required:"true" enum:"RepositoryProvider"`

	// A repository subdirectory path to your template bundle directory. When included,
	// Proton limits the template bundle search to this repository directory.
	Subdirectory *string `locationName:"subdirectory" min:"1" type:"string"`

	// The name of your registered template.
	//
	// TemplateName is a required field
	TemplateName *string `locationName:"templateName" min:"1" type:"string" required:"true"`

	// The type of the registered template.
	//
	// TemplateType is a required field
	TemplateType *string `locationName:"templateType" type:"string" required:"true" enum:"TemplateType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateTemplateSyncConfigInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateTemplateSyncConfigInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateTemplateSyncConfigInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateTemplateSyncConfigInput"}
	if s.Branch == nil {
		invalidParams.Add(request.NewErrParamRequired("Branch"))
	}
	if s.Branch != nil && len(*s.Branch) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Branch", 1))
	}
	if s.RepositoryName == nil {
		invalidParams.Add(request.NewErrParamRequired("RepositoryName"))
	}
	if s.RepositoryName != nil && len(*s.RepositoryName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RepositoryName", 1))
	}
	if s.RepositoryProvider == nil {
		invalidParams.Add(request.NewErrParamRequired("RepositoryProvider"))
	}
	if s.Subdirectory != nil && len(*s.Subdirectory) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Subdirectory", 1))
	}
	if s.TemplateName == nil {
		invalidParams.Add(request.NewErrParamRequired("TemplateName"))
	}
	if s.TemplateName != nil && len(*s.TemplateName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TemplateName", 1))
	}
	if s.TemplateType == nil {
		invalidParams.Add(request.NewErrParamRequired("TemplateType"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBranch sets the Branch field's value.
func (s *CreateTemplateSyncConfigInput) SetBranch(v string) *CreateTemplateSyncConfigInput {
	s.Branch = &v
	return s
}

// SetRepositoryName sets the RepositoryName field's value.
func (s *CreateTemplateSyncConfigInput) SetRepositoryName(v string) *CreateTemplateSyncConfigInput {
	s.RepositoryName = &v
	return s
}

// SetRepositoryProvider sets the RepositoryProvider field's value.
func (s *CreateTemplateSyncConfigInput) SetRepositoryProvider(v string) *CreateTemplateSyncConfigInput {
	s.RepositoryProvider = &v
	return s
}

// SetSubdirectory sets the Subdirectory field's value.
func (s *CreateTemplateSyncConfigInput) SetSubdirectory(v string) *CreateTemplateSyncConfigInput {
	s.Subdirectory = &v
	return s
}

// SetTemplateName sets the TemplateName field's value.
func (s *CreateTemplateSyncConfigInput) SetTemplateName(v string) *CreateTemplateSyncConfigInput {
	s.TemplateName = &v
	return s
}

// SetTemplateType sets the TemplateType field's value.
func (s *CreateTemplateSyncConfigInput) SetTemplateType(v string) *CreateTemplateSyncConfigInput {
	s.TemplateType = &v
	return s
}

type CreateTemplateSyncConfigOutput struct {
	_ struct{} `type:"structure"`

	// The template sync configuration detail data that's returned by Proton.
	TemplateSyncConfig *TemplateSyncConfig `locationName:"templateSyncConfig" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateTemplateSyncConfigOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateTemplateSyncConfigOutput) GoString() string {
	return s.String()
}

// SetTemplateSyncConfig sets the TemplateSyncConfig field's value.
func (s *CreateTemplateSyncConfigOutput) SetTemplateSyncConfig(v *TemplateSyncConfig) *CreateTemplateSyncConfigOutput {
	s.TemplateSyncConfig = v
	return s
}

type DeleteComponentInput struct {
	_ struct{} `type:"structure"`

	// The name of the component to delete.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteComponentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteComponentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteComponentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteComponentInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *DeleteComponentInput) SetName(v string) *DeleteComponentInput {
	s.Name = &v
	return s
}

type DeleteComponentOutput struct {
	_ struct{} `type:"structure"`

	// The detailed data of the component being deleted.
	Component *Component `locationName:"component" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteComponentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteComponentOutput) GoString() string {
	return s.String()
}

// SetComponent sets the Component field's value.
func (s *DeleteComponentOutput) SetComponent(v *Component) *DeleteComponentOutput {
	s.Component = v
	return s
}

type DeleteDeploymentInput struct {
	_ struct{} `type:"structure"`

	// The ID of the deployment to delete.
	//
	// Id is a required field
	Id *string `locationName:"id" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteDeploymentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteDeploymentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteDeploymentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteDeploymentInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *DeleteDeploymentInput) SetId(v string) *DeleteDeploymentInput {
	s.Id = &v
	return s
}

type DeleteDeploymentOutput struct {
	_ struct{} `type:"structure"`

	// The detailed data of the deployment being deleted.
	Deployment *Deployment `locationName:"deployment" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteDeploymentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteDeploymentOutput) GoString() string {
	return s.String()
}

// SetDeployment sets the Deployment field's value.
func (s *DeleteDeploymentOutput) SetDeployment(v *Deployment) *DeleteDeploymentOutput {
	s.Deployment = v
	return s
}

type DeleteEnvironmentAccountConnectionInput struct {
	_ struct{} `type:"structure"`

	// The ID of the environment account connection to delete.
	//
	// Id is a required field
	Id *string `locationName:"id" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteEnvironmentAccountConnectionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteEnvironmentAccountConnectionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteEnvironmentAccountConnectionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteEnvironmentAccountConnectionInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *DeleteEnvironmentAccountConnectionInput) SetId(v string) *DeleteEnvironmentAccountConnectionInput {
	s.Id = &v
	return s
}

type DeleteEnvironmentAccountConnectionOutput struct {
	_ struct{} `type:"structure"`

	// The detailed data of the environment account connection being deleted.
	EnvironmentAccountConnection *EnvironmentAccountConnection `locationName:"environmentAccountConnection" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteEnvironmentAccountConnectionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteEnvironmentAccountConnectionOutput) GoString() string {
	return s.String()
}

// SetEnvironmentAccountConnection sets the EnvironmentAccountConnection field's value.
func (s *DeleteEnvironmentAccountConnectionOutput) SetEnvironmentAccountConnection(v *EnvironmentAccountConnection) *DeleteEnvironmentAccountConnectionOutput {
	s.EnvironmentAccountConnection = v
	return s
}

type DeleteEnvironmentInput struct {
	_ struct{} `type:"structure"`

	// The name of the environment to delete.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteEnvironmentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteEnvironmentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteEnvironmentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteEnvironmentInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *DeleteEnvironmentInput) SetName(v string) *DeleteEnvironmentInput {
	s.Name = &v
	return s
}

type DeleteEnvironmentOutput struct {
	_ struct{} `type:"structure"`

	// The detailed data of the environment being deleted.
	Environment *Environment `locationName:"environment" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteEnvironmentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteEnvironmentOutput) GoString() string {
	return s.String()
}

// SetEnvironment sets the Environment field's value.
func (s *DeleteEnvironmentOutput) SetEnvironment(v *Environment) *DeleteEnvironmentOutput {
	s.Environment = v
	return s
}

type DeleteEnvironmentTemplateInput struct {
	_ struct{} `type:"structure"`

	// The name of the environment template to delete.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteEnvironmentTemplateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteEnvironmentTemplateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteEnvironmentTemplateInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteEnvironmentTemplateInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *DeleteEnvironmentTemplateInput) SetName(v string) *DeleteEnvironmentTemplateInput {
	s.Name = &v
	return s
}

type DeleteEnvironmentTemplateOutput struct {
	_ struct{} `type:"structure"`

	// The detailed data of the environment template being deleted.
	EnvironmentTemplate *EnvironmentTemplate `locationName:"environmentTemplate" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteEnvironmentTemplateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteEnvironmentTemplateOutput) GoString() string {
	return s.String()
}

// SetEnvironmentTemplate sets the EnvironmentTemplate field's value.
func (s *DeleteEnvironmentTemplateOutput) SetEnvironmentTemplate(v *EnvironmentTemplate) *DeleteEnvironmentTemplateOutput {
	s.EnvironmentTemplate = v
	return s
}

type DeleteEnvironmentTemplateVersionInput struct {
	_ struct{} `type:"structure"`

	// The environment template major version to delete.
	//
	// MajorVersion is a required field
	MajorVersion *string `locationName:"majorVersion" min:"1" type:"string" required:"true"`

	// The environment template minor version to delete.
	//
	// MinorVersion is a required field
	MinorVersion *string `locationName:"minorVersion" min:"1" type:"string" required:"true"`

	// The name of the environment template.
	//
	// TemplateName is a required field
	TemplateName *string `locationName:"templateName" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteEnvironmentTemplateVersionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteEnvironmentTemplateVersionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteEnvironmentTemplateVersionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteEnvironmentTemplateVersionInput"}
	if s.MajorVersion == nil {
		invalidParams.Add(request.NewErrParamRequired("MajorVersion"))
	}
	if s.MajorVersion != nil && len(*s.MajorVersion) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MajorVersion", 1))
	}
	if s.MinorVersion == nil {
		invalidParams.Add(request.NewErrParamRequired("MinorVersion"))
	}
	if s.MinorVersion != nil && len(*s.MinorVersion) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MinorVersion", 1))
	}
	if s.TemplateName == nil {
		invalidParams.Add(request.NewErrParamRequired("TemplateName"))
	}
	if s.TemplateName != nil && len(*s.TemplateName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TemplateName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMajorVersion sets the MajorVersion field's value.
func (s *DeleteEnvironmentTemplateVersionInput) SetMajorVersion(v string) *DeleteEnvironmentTemplateVersionInput {
	s.MajorVersion = &v
	return s
}

// SetMinorVersion sets the MinorVersion field's value.
func (s *DeleteEnvironmentTemplateVersionInput) SetMinorVersion(v string) *DeleteEnvironmentTemplateVersionInput {
	s.MinorVersion = &v
	return s
}

// SetTemplateName sets the TemplateName field's value.
func (s *DeleteEnvironmentTemplateVersionInput) SetTemplateName(v string) *DeleteEnvironmentTemplateVersionInput {
	s.TemplateName = &v
	return s
}

type DeleteEnvironmentTemplateVersionOutput struct {
	_ struct{} `type:"structure"`

	// The detailed data of the environment template version being deleted.
	EnvironmentTemplateVersion *EnvironmentTemplateVersion `locationName:"environmentTemplateVersion" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteEnvironmentTemplateVersionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteEnvironmentTemplateVersionOutput) GoString() string {
	return s.String()
}

// SetEnvironmentTemplateVersion sets the EnvironmentTemplateVersion field's value.
func (s *DeleteEnvironmentTemplateVersionOutput) SetEnvironmentTemplateVersion(v *EnvironmentTemplateVersion) *DeleteEnvironmentTemplateVersionOutput {
	s.EnvironmentTemplateVersion = v
	return s
}

type DeleteRepositoryInput struct {
	_ struct{} `type:"structure"`

	// The repository name.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// The repository provider.
	//
	// Provider is a required field
	Provider *string `locationName:"provider" type:"string" required:"true" enum:"RepositoryProvider"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteRepositoryInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteRepositoryInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteRepositoryInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteRepositoryInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Provider == nil {
		invalidParams.Add(request.NewErrParamRequired("Provider"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *DeleteRepositoryInput) SetName(v string) *DeleteRepositoryInput {
	s.Name = &v
	return s
}

// SetProvider sets the Provider field's value.
func (s *DeleteRepositoryInput) SetProvider(v string) *DeleteRepositoryInput {
	s.Provider = &v
	return s
}

type DeleteRepositoryOutput struct {
	_ struct{} `type:"structure"`

	// The deleted repository link's detail data that's returned by Proton.
	Repository *Repository `locationName:"repository" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteRepositoryOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteRepositoryOutput) GoString() string {
	return s.String()
}

// SetRepository sets the Repository field's value.
func (s *DeleteRepositoryOutput) SetRepository(v *Repository) *DeleteRepositoryOutput {
	s.Repository = v
	return s
}

type DeleteServiceInput struct {
	_ struct{} `type:"structure"`

	// The name of the service to delete.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteServiceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteServiceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteServiceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteServiceInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *DeleteServiceInput) SetName(v string) *DeleteServiceInput {
	s.Name = &v
	return s
}

type DeleteServiceOutput struct {
	_ struct{} `type:"structure"`

	// The detailed data of the service being deleted.
	Service *Service `locationName:"service" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteServiceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteServiceOutput) GoString() string {
	return s.String()
}

// SetService sets the Service field's value.
func (s *DeleteServiceOutput) SetService(v *Service) *DeleteServiceOutput {
	s.Service = v
	return s
}

type DeleteServiceSyncConfigInput struct {
	_ struct{} `type:"structure"`

	// The name of the service that you want to delete the service sync configuration
	// for.
	//
	// ServiceName is a required field
	ServiceName *string `locationName:"serviceName" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteServiceSyncConfigInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteServiceSyncConfigInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteServiceSyncConfigInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteServiceSyncConfigInput"}
	if s.ServiceName == nil {
		invalidParams.Add(request.NewErrParamRequired("ServiceName"))
	}
	if s.ServiceName != nil && len(*s.ServiceName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ServiceName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetServiceName sets the ServiceName field's value.
func (s *DeleteServiceSyncConfigInput) SetServiceName(v string) *DeleteServiceSyncConfigInput {
	s.ServiceName = &v
	return s
}

type DeleteServiceSyncConfigOutput struct {
	_ struct{} `type:"structure"`

	// The detailed data for the service sync config.
	ServiceSyncConfig *ServiceSyncConfig `locationName:"serviceSyncConfig" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteServiceSyncConfigOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteServiceSyncConfigOutput) GoString() string {
	return s.String()
}

// SetServiceSyncConfig sets the ServiceSyncConfig field's value.
func (s *DeleteServiceSyncConfigOutput) SetServiceSyncConfig(v *ServiceSyncConfig) *DeleteServiceSyncConfigOutput {
	s.ServiceSyncConfig = v
	return s
}

type DeleteServiceTemplateInput struct {
	_ struct{} `type:"structure"`

	// The name of the service template to delete.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteServiceTemplateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteServiceTemplateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteServiceTemplateInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteServiceTemplateInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *DeleteServiceTemplateInput) SetName(v string) *DeleteServiceTemplateInput {
	s.Name = &v
	return s
}

type DeleteServiceTemplateOutput struct {
	_ struct{} `type:"structure"`

	// The detailed data of the service template being deleted.
	ServiceTemplate *ServiceTemplate `locationName:"serviceTemplate" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteServiceTemplateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteServiceTemplateOutput) GoString() string {
	return s.String()
}

// SetServiceTemplate sets the ServiceTemplate field's value.
func (s *DeleteServiceTemplateOutput) SetServiceTemplate(v *ServiceTemplate) *DeleteServiceTemplateOutput {
	s.ServiceTemplate = v
	return s
}

type DeleteServiceTemplateVersionInput struct {
	_ struct{} `type:"structure"`

	// The service template major version to delete.
	//
	// MajorVersion is a required field
	MajorVersion *string `locationName:"majorVersion" min:"1" type:"string" required:"true"`

	// The service template minor version to delete.
	//
	// MinorVersion is a required field
	MinorVersion *string `locationName:"minorVersion" min:"1" type:"string" required:"true"`

	// The name of the service template.
	//
	// TemplateName is a required field
	TemplateName *string `locationName:"templateName" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteServiceTemplateVersionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteServiceTemplateVersionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteServiceTemplateVersionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteServiceTemplateVersionInput"}
	if s.MajorVersion == nil {
		invalidParams.Add(request.NewErrParamRequired("MajorVersion"))
	}
	if s.MajorVersion != nil && len(*s.MajorVersion) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MajorVersion", 1))
	}
	if s.MinorVersion == nil {
		invalidParams.Add(request.NewErrParamRequired("MinorVersion"))
	}
	if s.MinorVersion != nil && len(*s.MinorVersion) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MinorVersion", 1))
	}
	if s.TemplateName == nil {
		invalidParams.Add(request.NewErrParamRequired("TemplateName"))
	}
	if s.TemplateName != nil && len(*s.TemplateName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TemplateName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMajorVersion sets the MajorVersion field's value.
func (s *DeleteServiceTemplateVersionInput) SetMajorVersion(v string) *DeleteServiceTemplateVersionInput {
	s.MajorVersion = &v
	return s
}

// SetMinorVersion sets the MinorVersion field's value.
func (s *DeleteServiceTemplateVersionInput) SetMinorVersion(v string) *DeleteServiceTemplateVersionInput {
	s.MinorVersion = &v
	return s
}

// SetTemplateName sets the TemplateName field's value.
func (s *DeleteServiceTemplateVersionInput) SetTemplateName(v string) *DeleteServiceTemplateVersionInput {
	s.TemplateName = &v
	return s
}

type DeleteServiceTemplateVersionOutput struct {
	_ struct{} `type:"structure"`

	// The detailed data of the service template version being deleted.
	ServiceTemplateVersion *ServiceTemplateVersion `locationName:"serviceTemplateVersion" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteServiceTemplateVersionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteServiceTemplateVersionOutput) GoString() string {
	return s.String()
}

// SetServiceTemplateVersion sets the ServiceTemplateVersion field's value.
func (s *DeleteServiceTemplateVersionOutput) SetServiceTemplateVersion(v *ServiceTemplateVersion) *DeleteServiceTemplateVersionOutput {
	s.ServiceTemplateVersion = v
	return s
}

type DeleteTemplateSyncConfigInput struct {
	_ struct{} `type:"structure"`

	// The template name.
	//
	// TemplateName is a required field
	TemplateName *string `locationName:"templateName" min:"1" type:"string" required:"true"`

	// The template type.
	//
	// TemplateType is a required field
	TemplateType *string `locationName:"templateType" type:"string" required:"true" enum:"TemplateType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteTemplateSyncConfigInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteTemplateSyncConfigInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteTemplateSyncConfigInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteTemplateSyncConfigInput"}
	if s.TemplateName == nil {
		invalidParams.Add(request.NewErrParamRequired("TemplateName"))
	}
	if s.TemplateName != nil && len(*s.TemplateName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TemplateName", 1))
	}
	if s.TemplateType == nil {
		invalidParams.Add(request.NewErrParamRequired("TemplateType"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetTemplateName sets the TemplateName field's value.
func (s *DeleteTemplateSyncConfigInput) SetTemplateName(v string) *DeleteTemplateSyncConfigInput {
	s.TemplateName = &v
	return s
}

// SetTemplateType sets the TemplateType field's value.
func (s *DeleteTemplateSyncConfigInput) SetTemplateType(v string) *DeleteTemplateSyncConfigInput {
	s.TemplateType = &v
	return s
}

type DeleteTemplateSyncConfigOutput struct {
	_ struct{} `type:"structure"`

	// The template sync configuration detail data that's returned by Proton.
	TemplateSyncConfig *TemplateSyncConfig `locationName:"templateSyncConfig" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteTemplateSyncConfigOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteTemplateSyncConfigOutput) GoString() string {
	return s.String()
}

// SetTemplateSyncConfig sets the TemplateSyncConfig field's value.
func (s *DeleteTemplateSyncConfigOutput) SetTemplateSyncConfig(v *TemplateSyncConfig) *DeleteTemplateSyncConfigOutput {
	s.TemplateSyncConfig = v
	return s
}

// The detailed information about a deployment.
type Deployment struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the deployment.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" type:"string" required:"true"`

	// The date and time the deployment was completed.
	CompletedAt *time.Time `locationName:"completedAt" type:"timestamp"`

	// The name of the component associated with this deployment.
	ComponentName *string `locationName:"componentName" min:"1" type:"string"`

	// The date and time the deployment was created.
	//
	// CreatedAt is a required field
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" required:"true"`

	// The status of the deployment.
	//
	// DeploymentStatus is a required field
	DeploymentStatus *string `locationName:"deploymentStatus" type:"string" required:"true" enum:"DeploymentStatus"`

	// The deployment status message.
	//
	// DeploymentStatusMessage is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by Deployment's
	// String and GoString methods.
	DeploymentStatusMessage *string `locationName:"deploymentStatusMessage" type:"string" sensitive:"true"`

	// The name of the environment associated with this deployment.
	//
	// EnvironmentName is a required field
	EnvironmentName *string `locationName:"environmentName" min:"1" type:"string" required:"true"`

	// The ID of the deployment.
	//
	// Id is a required field
	Id *string `locationName:"id" type:"string" required:"true"`

	// The initial state of the target resource at the time of the deployment.
	InitialState *DeploymentState `locationName:"initialState" type:"structure"`

	// The ID of the last attempted deployment.
	LastAttemptedDeploymentId *string `locationName:"lastAttemptedDeploymentId" type:"string"`

	// The date and time the deployment was last modified.
	//
	// LastModifiedAt is a required field
	LastModifiedAt *time.Time `locationName:"lastModifiedAt" type:"timestamp" required:"true"`

	// The ID of the last successful deployment.
	LastSucceededDeploymentId *string `locationName:"lastSucceededDeploymentId" type:"string"`

	// The name of the deployment's service instance.
	ServiceInstanceName *string `locationName:"serviceInstanceName" min:"1" type:"string"`

	// The name of the service in this deployment.
	ServiceName *string `locationName:"serviceName" min:"1" type:"string"`

	// The Amazon Resource Name (ARN) of the target of the deployment.
	//
	// TargetArn is a required field
	TargetArn *string `locationName:"targetArn" min:"1" type:"string" required:"true"`

	// The date and time the depoyment target was created.
	//
	// TargetResourceCreatedAt is a required field
	TargetResourceCreatedAt *time.Time `locationName:"targetResourceCreatedAt" type:"timestamp" required:"true"`

	// The resource type of the deployment target. It can be an environment, service,
	// service instance, or component.
	//
	// TargetResourceType is a required field
	TargetResourceType *string `locationName:"targetResourceType" type:"string" required:"true" enum:"DeploymentTargetResourceType"`

	// The target state of the target resource at the time of the deployment.
	TargetState *DeploymentState `locationName:"targetState" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Deployment) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Deployment) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *Deployment) SetArn(v string) *Deployment {
	s.Arn = &v
	return s
}

// SetCompletedAt sets the CompletedAt field's value.
func (s *Deployment) SetCompletedAt(v time.Time) *Deployment {
	s.CompletedAt = &v
	return s
}

// SetComponentName sets the ComponentName field's value.
func (s *Deployment) SetComponentName(v string) *Deployment {
	s.ComponentName = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *Deployment) SetCreatedAt(v time.Time) *Deployment {
	s.CreatedAt = &v
	return s
}

// SetDeploymentStatus sets the DeploymentStatus field's value.
func (s *Deployment) SetDeploymentStatus(v string) *Deployment {
	s.DeploymentStatus = &v
	return s
}

// SetDeploymentStatusMessage sets the DeploymentStatusMessage field's value.
func (s *Deployment) SetDeploymentStatusMessage(v string) *Deployment {
	s.DeploymentStatusMessage = &v
	return s
}

// SetEnvironmentName sets the EnvironmentName field's value.
func (s *Deployment) SetEnvironmentName(v string) *Deployment {
	s.EnvironmentName = &v
	return s
}

// SetId sets the Id field's value.
func (s *Deployment) SetId(v string) *Deployment {
	s.Id = &v
	return s
}

// SetInitialState sets the InitialState field's value.
func (s *Deployment) SetInitialState(v *DeploymentState) *Deployment {
	s.InitialState = v
	return s
}

// SetLastAttemptedDeploymentId sets the LastAttemptedDeploymentId field's value.
func (s *Deployment) SetLastAttemptedDeploymentId(v string) *Deployment {
	s.LastAttemptedDeploymentId = &v
	return s
}

// SetLastModifiedAt sets the LastModifiedAt field's value.
func (s *Deployment) SetLastModifiedAt(v time.Time) *Deployment {
	s.LastModifiedAt = &v
	return s
}

// SetLastSucceededDeploymentId sets the LastSucceededDeploymentId field's value.
func (s *Deployment) SetLastSucceededDeploymentId(v string) *Deployment {
	s.LastSucceededDeploymentId = &v
	return s
}

// SetServiceInstanceName sets the ServiceInstanceName field's value.
func (s *Deployment) SetServiceInstanceName(v string) *Deployment {
	s.ServiceInstanceName = &v
	return s
}

// SetServiceName sets the ServiceName field's value.
func (s *Deployment) SetServiceName(v string) *Deployment {
	s.ServiceName = &v
	return s
}

// SetTargetArn sets the TargetArn field's value.
func (s *Deployment) SetTargetArn(v string) *Deployment {
	s.TargetArn = &v
	return s
}

// SetTargetResourceCreatedAt sets the TargetResourceCreatedAt field's value.
func (s *Deployment) SetTargetResourceCreatedAt(v time.Time) *Deployment {
	s.TargetResourceCreatedAt = &v
	return s
}

// SetTargetResourceType sets the TargetResourceType field's value.
func (s *Deployment) SetTargetResourceType(v string) *Deployment {
	s.TargetResourceType = &v
	return s
}

// SetTargetState sets the TargetState field's value.
func (s *Deployment) SetTargetState(v *DeploymentState) *Deployment {
	s.TargetState = v
	return s
}

// The detailed data about the current state of the deployment.
type DeploymentState struct {
	_ struct{} `type:"structure"`

	// The state of the component associated with the deployment.
	Component *ComponentState `locationName:"component" type:"structure"`

	// The state of the environment associated with the deployment.
	Environment *EnvironmentState `locationName:"environment" type:"structure"`

	// The state of the service instance associated with the deployment.
	ServiceInstance *ServiceInstanceState `locationName:"serviceInstance" type:"structure"`

	// The state of the service pipeline associated with the deployment.
	ServicePipeline *ServicePipelineState `locationName:"servicePipeline" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeploymentState) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeploymentState) GoString() string {
	return s.String()
}

// SetComponent sets the Component field's value.
func (s *DeploymentState) SetComponent(v *ComponentState) *DeploymentState {
	s.Component = v
	return s
}

// SetEnvironment sets the Environment field's value.
func (s *DeploymentState) SetEnvironment(v *EnvironmentState) *DeploymentState {
	s.Environment = v
	return s
}

// SetServiceInstance sets the ServiceInstance field's value.
func (s *DeploymentState) SetServiceInstance(v *ServiceInstanceState) *DeploymentState {
	s.ServiceInstance = v
	return s
}

// SetServicePipeline sets the ServicePipeline field's value.
func (s *DeploymentState) SetServicePipeline(v *ServicePipelineState) *DeploymentState {
	s.ServicePipeline = v
	return s
}

// Summary data of the deployment.
type DeploymentSummary struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the deployment.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" type:"string" required:"true"`

	// The date and time the deployment was completed.
	CompletedAt *time.Time `locationName:"completedAt" type:"timestamp"`

	// The name of the component associated with the deployment.
	ComponentName *string `locationName:"componentName" min:"1" type:"string"`

	// The date and time the deployment was created.
	//
	// CreatedAt is a required field
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" required:"true"`

	// The current status of the deployment.
	//
	// DeploymentStatus is a required field
	DeploymentStatus *string `locationName:"deploymentStatus" type:"string" required:"true" enum:"DeploymentStatus"`

	// The name of the environment associated with the deployment.
	//
	// EnvironmentName is a required field
	EnvironmentName *string `locationName:"environmentName" min:"1" type:"string" required:"true"`

	// The ID of the deployment.
	//
	// Id is a required field
	Id *string `locationName:"id" type:"string" required:"true"`

	// The ID of the last attempted deployment.
	LastAttemptedDeploymentId *string `locationName:"lastAttemptedDeploymentId" type:"string"`

	// The date and time the deployment was last modified.
	//
	// LastModifiedAt is a required field
	LastModifiedAt *time.Time `locationName:"lastModifiedAt" type:"timestamp" required:"true"`

	// The ID of the last successful deployment.
	LastSucceededDeploymentId *string `locationName:"lastSucceededDeploymentId" type:"string"`

	// The name of the service instance associated with the deployment.
	ServiceInstanceName *string `locationName:"serviceInstanceName" min:"1" type:"string"`

	// The name of the service associated with the deployment.
	ServiceName *string `locationName:"serviceName" min:"1" type:"string"`

	// The Amazon Resource Name (ARN) of the target of the deployment.
	//
	// TargetArn is a required field
	TargetArn *string `locationName:"targetArn" min:"1" type:"string" required:"true"`

	// The date and time the target resource was created.
	//
	// TargetResourceCreatedAt is a required field
	TargetResourceCreatedAt *time.Time `locationName:"targetResourceCreatedAt" type:"timestamp" required:"true"`

	// The resource type of the deployment target. It can be an environment, service,
	// service instance, or component.
	//
	// TargetResourceType is a required field
	TargetResourceType *string `locationName:"targetResourceType" type:"string" required:"true" enum:"DeploymentTargetResourceType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeploymentSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeploymentSummary) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *DeploymentSummary) SetArn(v string) *DeploymentSummary {
	s.Arn = &v
	return s
}

// SetCompletedAt sets the CompletedAt field's value.
func (s *DeploymentSummary) SetCompletedAt(v time.Time) *DeploymentSummary {
	s.CompletedAt = &v
	return s
}

// SetComponentName sets the ComponentName field's value.
func (s *DeploymentSummary) SetComponentName(v string) *DeploymentSummary {
	s.ComponentName = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *DeploymentSummary) SetCreatedAt(v time.Time) *DeploymentSummary {
	s.CreatedAt = &v
	return s
}

// SetDeploymentStatus sets the DeploymentStatus field's value.
func (s *DeploymentSummary) SetDeploymentStatus(v string) *DeploymentSummary {
	s.DeploymentStatus = &v
	return s
}

// SetEnvironmentName sets the EnvironmentName field's value.
func (s *DeploymentSummary) SetEnvironmentName(v string) *DeploymentSummary {
	s.EnvironmentName = &v
	return s
}

// SetId sets the Id field's value.
func (s *DeploymentSummary) SetId(v string) *DeploymentSummary {
	s.Id = &v
	return s
}

// SetLastAttemptedDeploymentId sets the LastAttemptedDeploymentId field's value.
func (s *DeploymentSummary) SetLastAttemptedDeploymentId(v string) *DeploymentSummary {
	s.LastAttemptedDeploymentId = &v
	return s
}

// SetLastModifiedAt sets the LastModifiedAt field's value.
func (s *DeploymentSummary) SetLastModifiedAt(v time.Time) *DeploymentSummary {
	s.LastModifiedAt = &v
	return s
}

// SetLastSucceededDeploymentId sets the LastSucceededDeploymentId field's value.
func (s *DeploymentSummary) SetLastSucceededDeploymentId(v string) *DeploymentSummary {
	s.LastSucceededDeploymentId = &v
	return s
}

// SetServiceInstanceName sets the ServiceInstanceName field's value.
func (s *DeploymentSummary) SetServiceInstanceName(v string) *DeploymentSummary {
	s.ServiceInstanceName = &v
	return s
}

// SetServiceName sets the ServiceName field's value.
func (s *DeploymentSummary) SetServiceName(v string) *DeploymentSummary {
	s.ServiceName = &v
	return s
}

// SetTargetArn sets the TargetArn field's value.
func (s *DeploymentSummary) SetTargetArn(v string) *DeploymentSummary {
	s.TargetArn = &v
	return s
}

// SetTargetResourceCreatedAt sets the TargetResourceCreatedAt field's value.
func (s *DeploymentSummary) SetTargetResourceCreatedAt(v time.Time) *DeploymentSummary {
	s.TargetResourceCreatedAt = &v
	return s
}

// SetTargetResourceType sets the TargetResourceType field's value.
func (s *DeploymentSummary) SetTargetResourceType(v string) *DeploymentSummary {
	s.TargetResourceType = &v
	return s
}

// Detailed data of an Proton environment resource. An Proton environment is
// a set of resources shared across Proton services.
type Environment struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the environment.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the IAM service role that allows Proton
	// to provision infrastructure using CodeBuild-based provisioning on your behalf.
	CodebuildRoleArn *string `locationName:"codebuildRoleArn" min:"1" type:"string"`

	// The Amazon Resource Name (ARN) of the IAM service role that Proton uses when
	// provisioning directly defined components in this environment. It determines
	// the scope of infrastructure that a component can provision.
	//
	// The environment must have a componentRoleArn to allow directly defined components
	// to be associated with the environment.
	//
	// For more information about components, see Proton components (https://docs.aws.amazon.com/proton/latest/userguide/ag-components.html)
	// in the Proton User Guide.
	ComponentRoleArn *string `locationName:"componentRoleArn" min:"1" type:"string"`

	// The time when the environment was created.
	//
	// CreatedAt is a required field
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" required:"true"`

	// The environment deployment status.
	//
	// DeploymentStatus is a required field
	DeploymentStatus *string `locationName:"deploymentStatus" type:"string" required:"true" enum:"DeploymentStatus"`

	// An environment deployment status message.
	//
	// DeploymentStatusMessage is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by Environment's
	// String and GoString methods.
	DeploymentStatusMessage *string `locationName:"deploymentStatusMessage" type:"string" sensitive:"true"`

	// The description of the environment.
	//
	// Description is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by Environment's
	// String and GoString methods.
	Description *string `locationName:"description" type:"string" sensitive:"true"`

	// The ID of the environment account connection that's used to provision infrastructure
	// resources in an environment account.
	EnvironmentAccountConnectionId *string `locationName:"environmentAccountConnectionId" type:"string"`

	// The ID of the environment account that the environment infrastructure resources
	// are provisioned in.
	EnvironmentAccountId *string `locationName:"environmentAccountId" type:"string"`

	// The ID of the last attempted deployment of this environment.
	LastAttemptedDeploymentId *string `locationName:"lastAttemptedDeploymentId" type:"string"`

	// The time when a deployment of the environment was last attempted.
	//
	// LastDeploymentAttemptedAt is a required field
	LastDeploymentAttemptedAt *time.Time `locationName:"lastDeploymentAttemptedAt" type:"timestamp" required:"true"`

	// The time when the environment was last deployed successfully.
	//
	// LastDeploymentSucceededAt is a required field
	LastDeploymentSucceededAt *time.Time `locationName:"lastDeploymentSucceededAt" type:"timestamp" required:"true"`

	// The ID of the last successful deployment of this environment.
	LastSucceededDeploymentId *string `locationName:"lastSucceededDeploymentId" type:"string"`

	// The name of the environment.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the Proton service role that allows Proton
	// to make calls to other services on your behalf.
	ProtonServiceRoleArn *string `locationName:"protonServiceRoleArn" min:"1" type:"string"`

	// When included, indicates that the environment template is for customer provisioned
	// and managed infrastructure.
	Provisioning *string `locationName:"provisioning" type:"string" enum:"Provisioning"`

	// The linked repository that you use to host your rendered infrastructure templates
	// for self-managed provisioning. A linked repository is a repository that has
	// been registered with Proton. For more information, see CreateRepository (https://docs.aws.amazon.com/proton/latest/APIReference/API_CreateRepository.html).
	ProvisioningRepository *RepositoryBranch `locationName:"provisioningRepository" type:"structure"`

	// The environment spec.
	//
	// Spec is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by Environment's
	// String and GoString methods.
	Spec *string `locationName:"spec" min:"1" type:"string" sensitive:"true"`

	// The major version of the environment template.
	//
	// TemplateMajorVersion is a required field
	TemplateMajorVersion *string `locationName:"templateMajorVersion" min:"1" type:"string" required:"true"`

	// The minor version of the environment template.
	//
	// TemplateMinorVersion is a required field
	TemplateMinorVersion *string `locationName:"templateMinorVersion" min:"1" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the environment template.
	//
	// TemplateName is a required field
	TemplateName *string `locationName:"templateName" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Environment) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Environment) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *Environment) SetArn(v string) *Environment {
	s.Arn = &v
	return s
}

// SetCodebuildRoleArn sets the CodebuildRoleArn field's value.
func (s *Environment) SetCodebuildRoleArn(v string) *Environment {
	s.CodebuildRoleArn = &v
	return s
}

// SetComponentRoleArn sets the ComponentRoleArn field's value.
func (s *Environment) SetComponentRoleArn(v string) *Environment {
	s.ComponentRoleArn = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *Environment) SetCreatedAt(v time.Time) *Environment {
	s.CreatedAt = &v
	return s
}

// SetDeploymentStatus sets the DeploymentStatus field's value.
func (s *Environment) SetDeploymentStatus(v string) *Environment {
	s.DeploymentStatus = &v
	return s
}

// SetDeploymentStatusMessage sets the DeploymentStatusMessage field's value.
func (s *Environment) SetDeploymentStatusMessage(v string) *Environment {
	s.DeploymentStatusMessage = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *Environment) SetDescription(v string) *Environment {
	s.Description = &v
	return s
}

// SetEnvironmentAccountConnectionId sets the EnvironmentAccountConnectionId field's value.
func (s *Environment) SetEnvironmentAccountConnectionId(v string) *Environment {
	s.EnvironmentAccountConnectionId = &v
	return s
}

// SetEnvironmentAccountId sets the EnvironmentAccountId field's value.
func (s *Environment) SetEnvironmentAccountId(v string) *Environment {
	s.EnvironmentAccountId = &v
	return s
}

// SetLastAttemptedDeploymentId sets the LastAttemptedDeploymentId field's value.
func (s *Environment) SetLastAttemptedDeploymentId(v string) *Environment {
	s.LastAttemptedDeploymentId = &v
	return s
}

// SetLastDeploymentAttemptedAt sets the LastDeploymentAttemptedAt field's value.
func (s *Environment) SetLastDeploymentAttemptedAt(v time.Time) *Environment {
	s.LastDeploymentAttemptedAt = &v
	return s
}

// SetLastDeploymentSucceededAt sets the LastDeploymentSucceededAt field's value.
func (s *Environment) SetLastDeploymentSucceededAt(v time.Time) *Environment {
	s.LastDeploymentSucceededAt = &v
	return s
}

// SetLastSucceededDeploymentId sets the LastSucceededDeploymentId field's value.
func (s *Environment) SetLastSucceededDeploymentId(v string) *Environment {
	s.LastSucceededDeploymentId = &v
	return s
}

// SetName sets the Name field's value.
func (s *Environment) SetName(v string) *Environment {
	s.Name = &v
	return s
}

// SetProtonServiceRoleArn sets the ProtonServiceRoleArn field's value.
func (s *Environment) SetProtonServiceRoleArn(v string) *Environment {
	s.ProtonServiceRoleArn = &v
	return s
}

// SetProvisioning sets the Provisioning field's value.
func (s *Environment) SetProvisioning(v string) *Environment {
	s.Provisioning = &v
	return s
}

// SetProvisioningRepository sets the ProvisioningRepository field's value.
func (s *Environment) SetProvisioningRepository(v *RepositoryBranch) *Environment {
	s.ProvisioningRepository = v
	return s
}

// SetSpec sets the Spec field's value.
func (s *Environment) SetSpec(v string) *Environment {
	s.Spec = &v
	return s
}

// SetTemplateMajorVersion sets the TemplateMajorVersion field's value.
func (s *Environment) SetTemplateMajorVersion(v string) *Environment {
	s.TemplateMajorVersion = &v
	return s
}

// SetTemplateMinorVersion sets the TemplateMinorVersion field's value.
func (s *Environment) SetTemplateMinorVersion(v string) *Environment {
	s.TemplateMinorVersion = &v
	return s
}

// SetTemplateName sets the TemplateName field's value.
func (s *Environment) SetTemplateName(v string) *Environment {
	s.TemplateName = &v
	return s
}

// Detailed data of an Proton environment account connection resource.
type EnvironmentAccountConnection struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the environment account connection.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of an IAM service role in the environment
	// account. Proton uses this role to provision infrastructure resources using
	// CodeBuild-based provisioning in the associated environment account.
	CodebuildRoleArn *string `locationName:"codebuildRoleArn" min:"1" type:"string"`

	// The Amazon Resource Name (ARN) of the IAM service role that Proton uses when
	// provisioning directly defined components in the associated environment account.
	// It determines the scope of infrastructure that a component can provision
	// in the account.
	//
	// The environment account connection must have a componentRoleArn to allow
	// directly defined components to be associated with any environments running
	// in the account.
	//
	// For more information about components, see Proton components (https://docs.aws.amazon.com/proton/latest/userguide/ag-components.html)
	// in the Proton User Guide.
	ComponentRoleArn *string `locationName:"componentRoleArn" min:"1" type:"string"`

	// The environment account that's connected to the environment account connection.
	//
	// EnvironmentAccountId is a required field
	EnvironmentAccountId *string `locationName:"environmentAccountId" type:"string" required:"true"`

	// The name of the environment that's associated with the environment account
	// connection.
	//
	// EnvironmentName is a required field
	EnvironmentName *string `locationName:"environmentName" min:"1" type:"string" required:"true"`

	// The ID of the environment account connection.
	//
	// Id is a required field
	Id *string `locationName:"id" type:"string" required:"true"`

	// The time when the environment account connection was last modified.
	//
	// LastModifiedAt is a required field
	LastModifiedAt *time.Time `locationName:"lastModifiedAt" type:"timestamp" required:"true"`

	// The ID of the management account that's connected to the environment account
	// connection.
	//
	// ManagementAccountId is a required field
	ManagementAccountId *string `locationName:"managementAccountId" type:"string" required:"true"`

	// The time when the environment account connection request was made.
	//
	// RequestedAt is a required field
	RequestedAt *time.Time `locationName:"requestedAt" type:"timestamp" required:"true"`

	// The IAM service role that's associated with the environment account connection.
	//
	// RoleArn is a required field
	RoleArn *string `locationName:"roleArn" min:"1" type:"string" required:"true"`

	// The status of the environment account connection.
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true" enum:"EnvironmentAccountConnectionStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EnvironmentAccountConnection) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EnvironmentAccountConnection) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *EnvironmentAccountConnection) SetArn(v string) *EnvironmentAccountConnection {
	s.Arn = &v
	return s
}

// SetCodebuildRoleArn sets the CodebuildRoleArn field's value.
func (s *EnvironmentAccountConnection) SetCodebuildRoleArn(v string) *EnvironmentAccountConnection {
	s.CodebuildRoleArn = &v
	return s
}

// SetComponentRoleArn sets the ComponentRoleArn field's value.
func (s *EnvironmentAccountConnection) SetComponentRoleArn(v string) *EnvironmentAccountConnection {
	s.ComponentRoleArn = &v
	return s
}

// SetEnvironmentAccountId sets the EnvironmentAccountId field's value.
func (s *EnvironmentAccountConnection) SetEnvironmentAccountId(v string) *EnvironmentAccountConnection {
	s.EnvironmentAccountId = &v
	return s
}

// SetEnvironmentName sets the EnvironmentName field's value.
func (s *EnvironmentAccountConnection) SetEnvironmentName(v string) *EnvironmentAccountConnection {
	s.EnvironmentName = &v
	return s
}

// SetId sets the Id field's value.
func (s *EnvironmentAccountConnection) SetId(v string) *EnvironmentAccountConnection {
	s.Id = &v
	return s
}

// SetLastModifiedAt sets the LastModifiedAt field's value.
func (s *EnvironmentAccountConnection) SetLastModifiedAt(v time.Time) *EnvironmentAccountConnection {
	s.LastModifiedAt = &v
	return s
}

// SetManagementAccountId sets the ManagementAccountId field's value.
func (s *EnvironmentAccountConnection) SetManagementAccountId(v string) *EnvironmentAccountConnection {
	s.ManagementAccountId = &v
	return s
}

// SetRequestedAt sets the RequestedAt field's value.
func (s *EnvironmentAccountConnection) SetRequestedAt(v time.Time) *EnvironmentAccountConnection {
	s.RequestedAt = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *EnvironmentAccountConnection) SetRoleArn(v string) *EnvironmentAccountConnection {
	s.RoleArn = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *EnvironmentAccountConnection) SetStatus(v string) *EnvironmentAccountConnection {
	s.Status = &v
	return s
}

// Summary data of an Proton environment account connection resource.
type EnvironmentAccountConnectionSummary struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the environment account connection.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the IAM service role that Proton uses when
	// provisioning directly defined components in the associated environment account.
	// It determines the scope of infrastructure that a component can provision
	// in the account.
	//
	// The environment account connection must have a componentRoleArn to allow
	// directly defined components to be associated with any environments running
	// in the account.
	//
	// For more information about components, see Proton components (https://docs.aws.amazon.com/proton/latest/userguide/ag-components.html)
	// in the Proton User Guide.
	ComponentRoleArn *string `locationName:"componentRoleArn" min:"1" type:"string"`

	// The ID of the environment account that's connected to the environment account
	// connection.
	//
	// EnvironmentAccountId is a required field
	EnvironmentAccountId *string `locationName:"environmentAccountId" type:"string" required:"true"`

	// The name of the environment that's associated with the environment account
	// connection.
	//
	// EnvironmentName is a required field
	EnvironmentName *string `locationName:"environmentName" min:"1" type:"string" required:"true"`

	// The ID of the environment account connection.
	//
	// Id is a required field
	Id *string `locationName:"id" type:"string" required:"true"`

	// The time when the environment account connection was last modified.
	//
	// LastModifiedAt is a required field
	LastModifiedAt *time.Time `locationName:"lastModifiedAt" type:"timestamp" required:"true"`

	// The ID of the management account that's connected to the environment account
	// connection.
	//
	// ManagementAccountId is a required field
	ManagementAccountId *string `locationName:"managementAccountId" type:"string" required:"true"`

	// The time when the environment account connection request was made.
	//
	// RequestedAt is a required field
	RequestedAt *time.Time `locationName:"requestedAt" type:"timestamp" required:"true"`

	// The IAM service role that's associated with the environment account connection.
	//
	// RoleArn is a required field
	RoleArn *string `locationName:"roleArn" min:"1" type:"string" required:"true"`

	// The status of the environment account connection.
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true" enum:"EnvironmentAccountConnectionStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EnvironmentAccountConnectionSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EnvironmentAccountConnectionSummary) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *EnvironmentAccountConnectionSummary) SetArn(v string) *EnvironmentAccountConnectionSummary {
	s.Arn = &v
	return s
}

// SetComponentRoleArn sets the ComponentRoleArn field's value.
func (s *EnvironmentAccountConnectionSummary) SetComponentRoleArn(v string) *EnvironmentAccountConnectionSummary {
	s.ComponentRoleArn = &v
	return s
}

// SetEnvironmentAccountId sets the EnvironmentAccountId field's value.
func (s *EnvironmentAccountConnectionSummary) SetEnvironmentAccountId(v string) *EnvironmentAccountConnectionSummary {
	s.EnvironmentAccountId = &v
	return s
}

// SetEnvironmentName sets the EnvironmentName field's value.
func (s *EnvironmentAccountConnectionSummary) SetEnvironmentName(v string) *EnvironmentAccountConnectionSummary {
	s.EnvironmentName = &v
	return s
}

// SetId sets the Id field's value.
func (s *EnvironmentAccountConnectionSummary) SetId(v string) *EnvironmentAccountConnectionSummary {
	s.Id = &v
	return s
}

// SetLastModifiedAt sets the LastModifiedAt field's value.
func (s *EnvironmentAccountConnectionSummary) SetLastModifiedAt(v time.Time) *EnvironmentAccountConnectionSummary {
	s.LastModifiedAt = &v
	return s
}

// SetManagementAccountId sets the ManagementAccountId field's value.
func (s *EnvironmentAccountConnectionSummary) SetManagementAccountId(v string) *EnvironmentAccountConnectionSummary {
	s.ManagementAccountId = &v
	return s
}

// SetRequestedAt sets the RequestedAt field's value.
func (s *EnvironmentAccountConnectionSummary) SetRequestedAt(v time.Time) *EnvironmentAccountConnectionSummary {
	s.RequestedAt = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *EnvironmentAccountConnectionSummary) SetRoleArn(v string) *EnvironmentAccountConnectionSummary {
	s.RoleArn = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *EnvironmentAccountConnectionSummary) SetStatus(v string) *EnvironmentAccountConnectionSummary {
	s.Status = &v
	return s
}

// The detailed data about the current state of the environment.
type EnvironmentState struct {
	_ struct{} `type:"structure"`

	// The environment spec that was used to create the environment.
	//
	// Spec is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by EnvironmentState's
	// String and GoString methods.
	Spec *string `locationName:"spec" min:"1" type:"string" sensitive:"true"`

	// The major version of the environment template that was used to create the
	// environment.
	//
	// TemplateMajorVersion is a required field
	TemplateMajorVersion *string `locationName:"templateMajorVersion" min:"1" type:"string" required:"true"`

	// The minor version of the environment template that was used to create the
	// environment.
	//
	// TemplateMinorVersion is a required field
	TemplateMinorVersion *string `locationName:"templateMinorVersion" min:"1" type:"string" required:"true"`

	// The name of the environment template that was used to create the environment.
	//
	// TemplateName is a required field
	TemplateName *string `locationName:"templateName" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EnvironmentState) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EnvironmentState) GoString() string {
	return s.String()
}

// SetSpec sets the Spec field's value.
func (s *EnvironmentState) SetSpec(v string) *EnvironmentState {
	s.Spec = &v
	return s
}

// SetTemplateMajorVersion sets the TemplateMajorVersion field's value.
func (s *EnvironmentState) SetTemplateMajorVersion(v string) *EnvironmentState {
	s.TemplateMajorVersion = &v
	return s
}

// SetTemplateMinorVersion sets the TemplateMinorVersion field's value.
func (s *EnvironmentState) SetTemplateMinorVersion(v string) *EnvironmentState {
	s.TemplateMinorVersion = &v
	return s
}

// SetTemplateName sets the TemplateName field's value.
func (s *EnvironmentState) SetTemplateName(v string) *EnvironmentState {
	s.TemplateName = &v
	return s
}

// Summary data of an Proton environment resource. An Proton environment is
// a set of resources shared across Proton services.
type EnvironmentSummary struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the environment.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the IAM service role that Proton uses when
	// provisioning directly defined components in this environment. It determines
	// the scope of infrastructure that a component can provision.
	//
	// The environment must have a componentRoleArn to allow directly defined components
	// to be associated with the environment.
	//
	// For more information about components, see Proton components (https://docs.aws.amazon.com/proton/latest/userguide/ag-components.html)
	// in the Proton User Guide.
	ComponentRoleArn *string `locationName:"componentRoleArn" min:"1" type:"string"`

	// The time when the environment was created.
	//
	// CreatedAt is a required field
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" required:"true"`

	// The environment deployment status.
	//
	// DeploymentStatus is a required field
	DeploymentStatus *string `locationName:"deploymentStatus" type:"string" required:"true" enum:"DeploymentStatus"`

	// An environment deployment status message.
	//
	// DeploymentStatusMessage is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by EnvironmentSummary's
	// String and GoString methods.
	DeploymentStatusMessage *string `locationName:"deploymentStatusMessage" type:"string" sensitive:"true"`

	// The description of the environment.
	//
	// Description is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by EnvironmentSummary's
	// String and GoString methods.
	Description *string `locationName:"description" type:"string" sensitive:"true"`

	// The ID of the environment account connection that the environment is associated
	// with.
	EnvironmentAccountConnectionId *string `locationName:"environmentAccountConnectionId" type:"string"`

	// The ID of the environment account that the environment infrastructure resources
	// are provisioned in.
	EnvironmentAccountId *string `locationName:"environmentAccountId" type:"string"`

	// The ID of the last attempted deployment of this environment.
	LastAttemptedDeploymentId *string `locationName:"lastAttemptedDeploymentId" type:"string"`

	// The time when a deployment of the environment was last attempted.
	//
	// LastDeploymentAttemptedAt is a required field
	LastDeploymentAttemptedAt *time.Time `locationName:"lastDeploymentAttemptedAt" type:"timestamp" required:"true"`

	// The time when the environment was last deployed successfully.
	//
	// LastDeploymentSucceededAt is a required field
	LastDeploymentSucceededAt *time.Time `locationName:"lastDeploymentSucceededAt" type:"timestamp" required:"true"`

	// The ID of the last successful deployment of this environment.
	LastSucceededDeploymentId *string `locationName:"lastSucceededDeploymentId" type:"string"`

	// The name of the environment.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the Proton service role that allows Proton
	// to make calls to other services on your behalf.
	ProtonServiceRoleArn *string `locationName:"protonServiceRoleArn" min:"1" type:"string"`

	// When included, indicates that the environment template is for customer provisioned
	// and managed infrastructure.
	Provisioning *string `locationName:"provisioning" type:"string" enum:"Provisioning"`

	// The major version of the environment template.
	//
	// TemplateMajorVersion is a required field
	TemplateMajorVersion *string `locationName:"templateMajorVersion" min:"1" type:"string" required:"true"`

	// The minor version of the environment template.
	//
	// TemplateMinorVersion is a required field
	TemplateMinorVersion *string `locationName:"templateMinorVersion" min:"1" type:"string" required:"true"`

	// The name of the environment template.
	//
	// TemplateName is a required field
	TemplateName *string `locationName:"templateName" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EnvironmentSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EnvironmentSummary) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *EnvironmentSummary) SetArn(v string) *EnvironmentSummary {
	s.Arn = &v
	return s
}

// SetComponentRoleArn sets the ComponentRoleArn field's value.
func (s *EnvironmentSummary) SetComponentRoleArn(v string) *EnvironmentSummary {
	s.ComponentRoleArn = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *EnvironmentSummary) SetCreatedAt(v time.Time) *EnvironmentSummary {
	s.CreatedAt = &v
	return s
}

// SetDeploymentStatus sets the DeploymentStatus field's value.
func (s *EnvironmentSummary) SetDeploymentStatus(v string) *EnvironmentSummary {
	s.DeploymentStatus = &v
	return s
}

// SetDeploymentStatusMessage sets the DeploymentStatusMessage field's value.
func (s *EnvironmentSummary) SetDeploymentStatusMessage(v string) *EnvironmentSummary {
	s.DeploymentStatusMessage = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *EnvironmentSummary) SetDescription(v string) *EnvironmentSummary {
	s.Description = &v
	return s
}

// SetEnvironmentAccountConnectionId sets the EnvironmentAccountConnectionId field's value.
func (s *EnvironmentSummary) SetEnvironmentAccountConnectionId(v string) *EnvironmentSummary {
	s.EnvironmentAccountConnectionId = &v
	return s
}

// SetEnvironmentAccountId sets the EnvironmentAccountId field's value.
func (s *EnvironmentSummary) SetEnvironmentAccountId(v string) *EnvironmentSummary {
	s.EnvironmentAccountId = &v
	return s
}

// SetLastAttemptedDeploymentId sets the LastAttemptedDeploymentId field's value.
func (s *EnvironmentSummary) SetLastAttemptedDeploymentId(v string) *EnvironmentSummary {
	s.LastAttemptedDeploymentId = &v
	return s
}

// SetLastDeploymentAttemptedAt sets the LastDeploymentAttemptedAt field's value.
func (s *EnvironmentSummary) SetLastDeploymentAttemptedAt(v time.Time) *EnvironmentSummary {
	s.LastDeploymentAttemptedAt = &v
	return s
}

// SetLastDeploymentSucceededAt sets the LastDeploymentSucceededAt field's value.
func (s *EnvironmentSummary) SetLastDeploymentSucceededAt(v time.Time) *EnvironmentSummary {
	s.LastDeploymentSucceededAt = &v
	return s
}

// SetLastSucceededDeploymentId sets the LastSucceededDeploymentId field's value.
func (s *EnvironmentSummary) SetLastSucceededDeploymentId(v string) *EnvironmentSummary {
	s.LastSucceededDeploymentId = &v
	return s
}

// SetName sets the Name field's value.
func (s *EnvironmentSummary) SetName(v string) *EnvironmentSummary {
	s.Name = &v
	return s
}

// SetProtonServiceRoleArn sets the ProtonServiceRoleArn field's value.
func (s *EnvironmentSummary) SetProtonServiceRoleArn(v string) *EnvironmentSummary {
	s.ProtonServiceRoleArn = &v
	return s
}

// SetProvisioning sets the Provisioning field's value.
func (s *EnvironmentSummary) SetProvisioning(v string) *EnvironmentSummary {
	s.Provisioning = &v
	return s
}

// SetTemplateMajorVersion sets the TemplateMajorVersion field's value.
func (s *EnvironmentSummary) SetTemplateMajorVersion(v string) *EnvironmentSummary {
	s.TemplateMajorVersion = &v
	return s
}

// SetTemplateMinorVersion sets the TemplateMinorVersion field's value.
func (s *EnvironmentSummary) SetTemplateMinorVersion(v string) *EnvironmentSummary {
	s.TemplateMinorVersion = &v
	return s
}

// SetTemplateName sets the TemplateName field's value.
func (s *EnvironmentSummary) SetTemplateName(v string) *EnvironmentSummary {
	s.TemplateName = &v
	return s
}

// The environment template data.
type EnvironmentTemplate struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the environment template.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" type:"string" required:"true"`

	// The time when the environment template was created.
	//
	// CreatedAt is a required field
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" required:"true"`

	// A description of the environment template.
	//
	// Description is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by EnvironmentTemplate's
	// String and GoString methods.
	Description *string `locationName:"description" type:"string" sensitive:"true"`

	// The name of the environment template as displayed in the developer interface.
	//
	// DisplayName is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by EnvironmentTemplate's
	// String and GoString methods.
	DisplayName *string `locationName:"displayName" min:"1" type:"string" sensitive:"true"`

	// The customer provided encryption key for the environment template.
	EncryptionKey *string `locationName:"encryptionKey" min:"1" type:"string"`

	// The time when the environment template was last modified.
	//
	// LastModifiedAt is a required field
	LastModifiedAt *time.Time `locationName:"lastModifiedAt" type:"timestamp" required:"true"`

	// The name of the environment template.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// When included, indicates that the environment template is for customer provisioned
	// and managed infrastructure.
	Provisioning *string `locationName:"provisioning" type:"string" enum:"Provisioning"`

	// The ID of the recommended version of the environment template.
	RecommendedVersion *string `locationName:"recommendedVersion" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EnvironmentTemplate) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EnvironmentTemplate) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *EnvironmentTemplate) SetArn(v string) *EnvironmentTemplate {
	s.Arn = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *EnvironmentTemplate) SetCreatedAt(v time.Time) *EnvironmentTemplate {
	s.CreatedAt = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *EnvironmentTemplate) SetDescription(v string) *EnvironmentTemplate {
	s.Description = &v
	return s
}

// SetDisplayName sets the DisplayName field's value.
func (s *EnvironmentTemplate) SetDisplayName(v string) *EnvironmentTemplate {
	s.DisplayName = &v
	return s
}

// SetEncryptionKey sets the EncryptionKey field's value.
func (s *EnvironmentTemplate) SetEncryptionKey(v string) *EnvironmentTemplate {
	s.EncryptionKey = &v
	return s
}

// SetLastModifiedAt sets the LastModifiedAt field's value.
func (s *EnvironmentTemplate) SetLastModifiedAt(v time.Time) *EnvironmentTemplate {
	s.LastModifiedAt = &v
	return s
}

// SetName sets the Name field's value.
func (s *EnvironmentTemplate) SetName(v string) *EnvironmentTemplate {
	s.Name = &v
	return s
}

// SetProvisioning sets the Provisioning field's value.
func (s *EnvironmentTemplate) SetProvisioning(v string) *EnvironmentTemplate {
	s.Provisioning = &v
	return s
}

// SetRecommendedVersion sets the RecommendedVersion field's value.
func (s *EnvironmentTemplate) SetRecommendedVersion(v string) *EnvironmentTemplate {
	s.RecommendedVersion = &v
	return s
}

// A search filter for environment templates.
type EnvironmentTemplateFilter struct {
	_ struct{} `type:"structure"`

	// Include majorVersion to filter search for a major version.
	//
	// MajorVersion is a required field
	MajorVersion *string `locationName:"majorVersion" min:"1" type:"string" required:"true"`

	// Include templateName to filter search for a template name.
	//
	// TemplateName is a required field
	TemplateName *string `locationName:"templateName" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EnvironmentTemplateFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EnvironmentTemplateFilter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EnvironmentTemplateFilter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "EnvironmentTemplateFilter"}
	if s.MajorVersion == nil {
		invalidParams.Add(request.NewErrParamRequired("MajorVersion"))
	}
	if s.MajorVersion != nil && len(*s.MajorVersion) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MajorVersion", 1))
	}
	if s.TemplateName == nil {
		invalidParams.Add(request.NewErrParamRequired("TemplateName"))
	}
	if s.TemplateName != nil && len(*s.TemplateName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TemplateName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMajorVersion sets the MajorVersion field's value.
func (s *EnvironmentTemplateFilter) SetMajorVersion(v string) *EnvironmentTemplateFilter {
	s.MajorVersion = &v
	return s
}

// SetTemplateName sets the TemplateName field's value.
func (s *EnvironmentTemplateFilter) SetTemplateName(v string) *EnvironmentTemplateFilter {
	s.TemplateName = &v
	return s
}

// The environment template data.
type EnvironmentTemplateSummary struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the environment template.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" type:"string" required:"true"`

	// The time when the environment template was created.
	//
	// CreatedAt is a required field
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" required:"true"`

	// A description of the environment template.
	//
	// Description is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by EnvironmentTemplateSummary's
	// String and GoString methods.
	Description *string `locationName:"description" type:"string" sensitive:"true"`

	// The name of the environment template as displayed in the developer interface.
	//
	// DisplayName is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by EnvironmentTemplateSummary's
	// String and GoString methods.
	DisplayName *string `locationName:"displayName" min:"1" type:"string" sensitive:"true"`

	// The time when the environment template was last modified.
	//
	// LastModifiedAt is a required field
	LastModifiedAt *time.Time `locationName:"lastModifiedAt" type:"timestamp" required:"true"`

	// The name of the environment template.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// When included, indicates that the environment template is for customer provisioned
	// and managed infrastructure.
	Provisioning *string `locationName:"provisioning" type:"string" enum:"Provisioning"`

	// The recommended version of the environment template.
	RecommendedVersion *string `locationName:"recommendedVersion" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EnvironmentTemplateSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EnvironmentTemplateSummary) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *EnvironmentTemplateSummary) SetArn(v string) *EnvironmentTemplateSummary {
	s.Arn = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *EnvironmentTemplateSummary) SetCreatedAt(v time.Time) *EnvironmentTemplateSummary {
	s.CreatedAt = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *EnvironmentTemplateSummary) SetDescription(v string) *EnvironmentTemplateSummary {
	s.Description = &v
	return s
}

// SetDisplayName sets the DisplayName field's value.
func (s *EnvironmentTemplateSummary) SetDisplayName(v string) *EnvironmentTemplateSummary {
	s.DisplayName = &v
	return s
}

// SetLastModifiedAt sets the LastModifiedAt field's value.
func (s *EnvironmentTemplateSummary) SetLastModifiedAt(v time.Time) *EnvironmentTemplateSummary {
	s.LastModifiedAt = &v
	return s
}

// SetName sets the Name field's value.
func (s *EnvironmentTemplateSummary) SetName(v string) *EnvironmentTemplateSummary {
	s.Name = &v
	return s
}

// SetProvisioning sets the Provisioning field's value.
func (s *EnvironmentTemplateSummary) SetProvisioning(v string) *EnvironmentTemplateSummary {
	s.Provisioning = &v
	return s
}

// SetRecommendedVersion sets the RecommendedVersion field's value.
func (s *EnvironmentTemplateSummary) SetRecommendedVersion(v string) *EnvironmentTemplateSummary {
	s.RecommendedVersion = &v
	return s
}

// The environment template version data.
type EnvironmentTemplateVersion struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the version of an environment template.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" type:"string" required:"true"`

	// The time when the version of an environment template was created.
	//
	// CreatedAt is a required field
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" required:"true"`

	// A description of the minor version of an environment template.
	//
	// Description is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by EnvironmentTemplateVersion's
	// String and GoString methods.
	Description *string `locationName:"description" type:"string" sensitive:"true"`

	// The time when the version of an environment template was last modified.
	//
	// LastModifiedAt is a required field
	LastModifiedAt *time.Time `locationName:"lastModifiedAt" type:"timestamp" required:"true"`

	// The latest major version that's associated with the version of an environment
	// template.
	//
	// MajorVersion is a required field
	MajorVersion *string `locationName:"majorVersion" min:"1" type:"string" required:"true"`

	// The minor version of an environment template.
	//
	// MinorVersion is a required field
	MinorVersion *string `locationName:"minorVersion" min:"1" type:"string" required:"true"`

	// The recommended minor version of the environment template.
	RecommendedMinorVersion *string `locationName:"recommendedMinorVersion" min:"1" type:"string"`

	// The schema of the version of an environment template.
	//
	// Schema is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by EnvironmentTemplateVersion's
	// String and GoString methods.
	Schema *string `locationName:"schema" min:"1" type:"string" sensitive:"true"`

	// The status of the version of an environment template.
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true" enum:"TemplateVersionStatus"`

	// The status message of the version of an environment template.
	//
	// StatusMessage is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by EnvironmentTemplateVersion's
	// String and GoString methods.
	StatusMessage *string `locationName:"statusMessage" type:"string" sensitive:"true"`

	// The name of the version of an environment template.
	//
	// TemplateName is a required field
	TemplateName *string `locationName:"templateName" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EnvironmentTemplateVersion) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EnvironmentTemplateVersion) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *EnvironmentTemplateVersion) SetArn(v string) *EnvironmentTemplateVersion {
	s.Arn = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *EnvironmentTemplateVersion) SetCreatedAt(v time.Time) *EnvironmentTemplateVersion {
	s.CreatedAt = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *EnvironmentTemplateVersion) SetDescription(v string) *EnvironmentTemplateVersion {
	s.Description = &v
	return s
}

// SetLastModifiedAt sets the LastModifiedAt field's value.
func (s *EnvironmentTemplateVersion) SetLastModifiedAt(v time.Time) *EnvironmentTemplateVersion {
	s.LastModifiedAt = &v
	return s
}

// SetMajorVersion sets the MajorVersion field's value.
func (s *EnvironmentTemplateVersion) SetMajorVersion(v string) *EnvironmentTemplateVersion {
	s.MajorVersion = &v
	return s
}

// SetMinorVersion sets the MinorVersion field's value.
func (s *EnvironmentTemplateVersion) SetMinorVersion(v string) *EnvironmentTemplateVersion {
	s.MinorVersion = &v
	return s
}

// SetRecommendedMinorVersion sets the RecommendedMinorVersion field's value.
func (s *EnvironmentTemplateVersion) SetRecommendedMinorVersion(v string) *EnvironmentTemplateVersion {
	s.RecommendedMinorVersion = &v
	return s
}

// SetSchema sets the Schema field's value.
func (s *EnvironmentTemplateVersion) SetSchema(v string) *EnvironmentTemplateVersion {
	s.Schema = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *EnvironmentTemplateVersion) SetStatus(v string) *EnvironmentTemplateVersion {
	s.Status = &v
	return s
}

// SetStatusMessage sets the StatusMessage field's value.
func (s *EnvironmentTemplateVersion) SetStatusMessage(v string) *EnvironmentTemplateVersion {
	s.StatusMessage = &v
	return s
}

// SetTemplateName sets the TemplateName field's value.
func (s *EnvironmentTemplateVersion) SetTemplateName(v string) *EnvironmentTemplateVersion {
	s.TemplateName = &v
	return s
}

// A summary of the version of an environment template detail data.
type EnvironmentTemplateVersionSummary struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the version of an environment template.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" type:"string" required:"true"`

	// The time when the version of an environment template was created.
	//
	// CreatedAt is a required field
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" required:"true"`

	// A description of the version of an environment template.
	//
	// Description is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by EnvironmentTemplateVersionSummary's
	// String and GoString methods.
	Description *string `locationName:"description" type:"string" sensitive:"true"`

	// The time when the version of an environment template was last modified.
	//
	// LastModifiedAt is a required field
	LastModifiedAt *time.Time `locationName:"lastModifiedAt" type:"timestamp" required:"true"`

	// The latest major version that's associated with the version of an environment
	// template.
	//
	// MajorVersion is a required field
	MajorVersion *string `locationName:"majorVersion" min:"1" type:"string" required:"true"`

	// The version of an environment template.
	//
	// MinorVersion is a required field
	MinorVersion *string `locationName:"minorVersion" min:"1" type:"string" required:"true"`

	// The recommended minor version of the environment template.
	RecommendedMinorVersion *string `locationName:"recommendedMinorVersion" min:"1" type:"string"`

	// The status of the version of an environment template.
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true" enum:"TemplateVersionStatus"`

	// The status message of the version of an environment template.
	//
	// StatusMessage is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by EnvironmentTemplateVersionSummary's
	// String and GoString methods.
	StatusMessage *string `locationName:"statusMessage" type:"string" sensitive:"true"`

	// The name of the environment template.
	//
	// TemplateName is a required field
	TemplateName *string `locationName:"templateName" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EnvironmentTemplateVersionSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EnvironmentTemplateVersionSummary) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *EnvironmentTemplateVersionSummary) SetArn(v string) *EnvironmentTemplateVersionSummary {
	s.Arn = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *EnvironmentTemplateVersionSummary) SetCreatedAt(v time.Time) *EnvironmentTemplateVersionSummary {
	s.CreatedAt = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *EnvironmentTemplateVersionSummary) SetDescription(v string) *EnvironmentTemplateVersionSummary {
	s.Description = &v
	return s
}

// SetLastModifiedAt sets the LastModifiedAt field's value.
func (s *EnvironmentTemplateVersionSummary) SetLastModifiedAt(v time.Time) *EnvironmentTemplateVersionSummary {
	s.LastModifiedAt = &v
	return s
}

// SetMajorVersion sets the MajorVersion field's value.
func (s *EnvironmentTemplateVersionSummary) SetMajorVersion(v string) *EnvironmentTemplateVersionSummary {
	s.MajorVersion = &v
	return s
}

// SetMinorVersion sets the MinorVersion field's value.
func (s *EnvironmentTemplateVersionSummary) SetMinorVersion(v string) *EnvironmentTemplateVersionSummary {
	s.MinorVersion = &v
	return s
}

// SetRecommendedMinorVersion sets the RecommendedMinorVersion field's value.
func (s *EnvironmentTemplateVersionSummary) SetRecommendedMinorVersion(v string) *EnvironmentTemplateVersionSummary {
	s.RecommendedMinorVersion = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *EnvironmentTemplateVersionSummary) SetStatus(v string) *EnvironmentTemplateVersionSummary {
	s.Status = &v
	return s
}

// SetStatusMessage sets the StatusMessage field's value.
func (s *EnvironmentTemplateVersionSummary) SetStatusMessage(v string) *EnvironmentTemplateVersionSummary {
	s.StatusMessage = &v
	return s
}

// SetTemplateName sets the TemplateName field's value.
func (s *EnvironmentTemplateVersionSummary) SetTemplateName(v string) *EnvironmentTemplateVersionSummary {
	s.TemplateName = &v
	return s
}

type GetAccountSettingsInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAccountSettingsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAccountSettingsInput) GoString() string {
	return s.String()
}

type GetAccountSettingsOutput struct {
	_ struct{} `type:"structure"`

	// The Proton pipeline service role detail data that's returned by Proton.
	AccountSettings *AccountSettings `locationName:"accountSettings" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAccountSettingsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAccountSettingsOutput) GoString() string {
	return s.String()
}

// SetAccountSettings sets the AccountSettings field's value.
func (s *GetAccountSettingsOutput) SetAccountSettings(v *AccountSettings) *GetAccountSettingsOutput {
	s.AccountSettings = v
	return s
}

type GetComponentInput struct {
	_ struct{} `type:"structure"`

	// The name of the component that you want to get the detailed data for.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetComponentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetComponentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetComponentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetComponentInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *GetComponentInput) SetName(v string) *GetComponentInput {
	s.Name = &v
	return s
}

type GetComponentOutput struct {
	_ struct{} `type:"structure"`

	// The detailed data of the requested component.
	Component *Component `locationName:"component" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetComponentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetComponentOutput) GoString() string {
	return s.String()
}

// SetComponent sets the Component field's value.
func (s *GetComponentOutput) SetComponent(v *Component) *GetComponentOutput {
	s.Component = v
	return s
}

type GetDeploymentInput struct {
	_ struct{} `type:"structure"`

	// The name of a component that you want to get the detailed data for.
	ComponentName *string `locationName:"componentName" min:"1" type:"string"`

	// The name of a environment that you want to get the detailed data for.
	EnvironmentName *string `locationName:"environmentName" min:"1" type:"string"`

	// The ID of the deployment that you want to get the detailed data for.
	//
	// Id is a required field
	Id *string `locationName:"id" type:"string" required:"true"`

	// The name of the service instance associated with the given deployment ID.
	// serviceName must be specified to identify the service instance.
	ServiceInstanceName *string `locationName:"serviceInstanceName" min:"1" type:"string"`

	// The name of the service associated with the given deployment ID.
	ServiceName *string `locationName:"serviceName" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDeploymentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDeploymentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetDeploymentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetDeploymentInput"}
	if s.ComponentName != nil && len(*s.ComponentName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ComponentName", 1))
	}
	if s.EnvironmentName != nil && len(*s.EnvironmentName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EnvironmentName", 1))
	}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.ServiceInstanceName != nil && len(*s.ServiceInstanceName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ServiceInstanceName", 1))
	}
	if s.ServiceName != nil && len(*s.ServiceName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ServiceName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetComponentName sets the ComponentName field's value.
func (s *GetDeploymentInput) SetComponentName(v string) *GetDeploymentInput {
	s.ComponentName = &v
	return s
}

// SetEnvironmentName sets the EnvironmentName field's value.
func (s *GetDeploymentInput) SetEnvironmentName(v string) *GetDeploymentInput {
	s.EnvironmentName = &v
	return s
}

// SetId sets the Id field's value.
func (s *GetDeploymentInput) SetId(v string) *GetDeploymentInput {
	s.Id = &v
	return s
}

// SetServiceInstanceName sets the ServiceInstanceName field's value.
func (s *GetDeploymentInput) SetServiceInstanceName(v string) *GetDeploymentInput {
	s.ServiceInstanceName = &v
	return s
}

// SetServiceName sets the ServiceName field's value.
func (s *GetDeploymentInput) SetServiceName(v string) *GetDeploymentInput {
	s.ServiceName = &v
	return s
}

type GetDeploymentOutput struct {
	_ struct{} `type:"structure"`

	// The detailed data of the requested deployment.
	Deployment *Deployment `locationName:"deployment" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDeploymentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDeploymentOutput) GoString() string {
	return s.String()
}

// SetDeployment sets the Deployment field's value.
func (s *GetDeploymentOutput) SetDeployment(v *Deployment) *GetDeploymentOutput {
	s.Deployment = v
	return s
}

type GetEnvironmentAccountConnectionInput struct {
	_ struct{} `type:"structure"`

	// The ID of the environment account connection that you want to get the detailed
	// data for.
	//
	// Id is a required field
	Id *string `locationName:"id" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetEnvironmentAccountConnectionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetEnvironmentAccountConnectionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetEnvironmentAccountConnectionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetEnvironmentAccountConnectionInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *GetEnvironmentAccountConnectionInput) SetId(v string) *GetEnvironmentAccountConnectionInput {
	s.Id = &v
	return s
}

type GetEnvironmentAccountConnectionOutput struct {
	_ struct{} `type:"structure"`

	// The detailed data of the requested environment account connection.
	//
	// EnvironmentAccountConnection is a required field
	EnvironmentAccountConnection *EnvironmentAccountConnection `locationName:"environmentAccountConnection" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetEnvironmentAccountConnectionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetEnvironmentAccountConnectionOutput) GoString() string {
	return s.String()
}

// SetEnvironmentAccountConnection sets the EnvironmentAccountConnection field's value.
func (s *GetEnvironmentAccountConnectionOutput) SetEnvironmentAccountConnection(v *EnvironmentAccountConnection) *GetEnvironmentAccountConnectionOutput {
	s.EnvironmentAccountConnection = v
	return s
}

type GetEnvironmentInput struct {
	_ struct{} `type:"structure"`

	// The name of the environment that you want to get the detailed data for.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetEnvironmentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetEnvironmentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetEnvironmentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetEnvironmentInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *GetEnvironmentInput) SetName(v string) *GetEnvironmentInput {
	s.Name = &v
	return s
}

type GetEnvironmentOutput struct {
	_ struct{} `type:"structure"`

	// The detailed data of the requested environment.
	//
	// Environment is a required field
	Environment *Environment `locationName:"environment" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetEnvironmentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetEnvironmentOutput) GoString() string {
	return s.String()
}

// SetEnvironment sets the Environment field's value.
func (s *GetEnvironmentOutput) SetEnvironment(v *Environment) *GetEnvironmentOutput {
	s.Environment = v
	return s
}

type GetEnvironmentTemplateInput struct {
	_ struct{} `type:"structure"`

	// The name of the environment template that you want to get the detailed data
	// for.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetEnvironmentTemplateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetEnvironmentTemplateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetEnvironmentTemplateInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetEnvironmentTemplateInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *GetEnvironmentTemplateInput) SetName(v string) *GetEnvironmentTemplateInput {
	s.Name = &v
	return s
}

type GetEnvironmentTemplateOutput struct {
	_ struct{} `type:"structure"`

	// The detailed data of the requested environment template.
	//
	// EnvironmentTemplate is a required field
	EnvironmentTemplate *EnvironmentTemplate `locationName:"environmentTemplate" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetEnvironmentTemplateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetEnvironmentTemplateOutput) GoString() string {
	return s.String()
}

// SetEnvironmentTemplate sets the EnvironmentTemplate field's value.
func (s *GetEnvironmentTemplateOutput) SetEnvironmentTemplate(v *EnvironmentTemplate) *GetEnvironmentTemplateOutput {
	s.EnvironmentTemplate = v
	return s
}

type GetEnvironmentTemplateVersionInput struct {
	_ struct{} `type:"structure"`

	// To get environment template major version detail data, include major Version.
	//
	// MajorVersion is a required field
	MajorVersion *string `locationName:"majorVersion" min:"1" type:"string" required:"true"`

	// To get environment template minor version detail data, include minorVersion.
	//
	// MinorVersion is a required field
	MinorVersion *string `locationName:"minorVersion" min:"1" type:"string" required:"true"`

	// The name of the environment template a version of which you want to get detailed
	// data for.
	//
	// TemplateName is a required field
	TemplateName *string `locationName:"templateName" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetEnvironmentTemplateVersionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetEnvironmentTemplateVersionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetEnvironmentTemplateVersionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetEnvironmentTemplateVersionInput"}
	if s.MajorVersion == nil {
		invalidParams.Add(request.NewErrParamRequired("MajorVersion"))
	}
	if s.MajorVersion != nil && len(*s.MajorVersion) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MajorVersion", 1))
	}
	if s.MinorVersion == nil {
		invalidParams.Add(request.NewErrParamRequired("MinorVersion"))
	}
	if s.MinorVersion != nil && len(*s.MinorVersion) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MinorVersion", 1))
	}
	if s.TemplateName == nil {
		invalidParams.Add(request.NewErrParamRequired("TemplateName"))
	}
	if s.TemplateName != nil && len(*s.TemplateName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TemplateName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMajorVersion sets the MajorVersion field's value.
func (s *GetEnvironmentTemplateVersionInput) SetMajorVersion(v string) *GetEnvironmentTemplateVersionInput {
	s.MajorVersion = &v
	return s
}

// SetMinorVersion sets the MinorVersion field's value.
func (s *GetEnvironmentTemplateVersionInput) SetMinorVersion(v string) *GetEnvironmentTemplateVersionInput {
	s.MinorVersion = &v
	return s
}

// SetTemplateName sets the TemplateName field's value.
func (s *GetEnvironmentTemplateVersionInput) SetTemplateName(v string) *GetEnvironmentTemplateVersionInput {
	s.TemplateName = &v
	return s
}

type GetEnvironmentTemplateVersionOutput struct {
	_ struct{} `type:"structure"`

	// The detailed data of the requested environment template version.
	//
	// EnvironmentTemplateVersion is a required field
	EnvironmentTemplateVersion *EnvironmentTemplateVersion `locationName:"environmentTemplateVersion" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetEnvironmentTemplateVersionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetEnvironmentTemplateVersionOutput) GoString() string {
	return s.String()
}

// SetEnvironmentTemplateVersion sets the EnvironmentTemplateVersion field's value.
func (s *GetEnvironmentTemplateVersionOutput) SetEnvironmentTemplateVersion(v *EnvironmentTemplateVersion) *GetEnvironmentTemplateVersionOutput {
	s.EnvironmentTemplateVersion = v
	return s
}

type GetRepositoryInput struct {
	_ struct{} `type:"structure"`

	// The repository name, for example myrepos/myrepo.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// The repository provider.
	//
	// Provider is a required field
	Provider *string `locationName:"provider" type:"string" required:"true" enum:"RepositoryProvider"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetRepositoryInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetRepositoryInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetRepositoryInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetRepositoryInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Provider == nil {
		invalidParams.Add(request.NewErrParamRequired("Provider"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *GetRepositoryInput) SetName(v string) *GetRepositoryInput {
	s.Name = &v
	return s
}

// SetProvider sets the Provider field's value.
func (s *GetRepositoryInput) SetProvider(v string) *GetRepositoryInput {
	s.Provider = &v
	return s
}

type GetRepositoryOutput struct {
	_ struct{} `type:"structure"`

	// The repository link's detail data that's returned by Proton.
	//
	// Repository is a required field
	Repository *Repository `locationName:"repository" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetRepositoryOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetRepositoryOutput) GoString() string {
	return s.String()
}

// SetRepository sets the Repository field's value.
func (s *GetRepositoryOutput) SetRepository(v *Repository) *GetRepositoryOutput {
	s.Repository = v
	return s
}

type GetRepositorySyncStatusInput struct {
	_ struct{} `type:"structure"`

	// The repository branch.
	//
	// Branch is a required field
	Branch *string `locationName:"branch" min:"1" type:"string" required:"true"`

	// The repository name.
	//
	// RepositoryName is a required field
	RepositoryName *string `locationName:"repositoryName" min:"1" type:"string" required:"true"`

	// The repository provider.
	//
	// RepositoryProvider is a required field
	RepositoryProvider *string `locationName:"repositoryProvider" type:"string" required:"true" enum:"RepositoryProvider"`

	// The repository sync type.
	//
	// SyncType is a required field
	SyncType *string `locationName:"syncType" type:"string" required:"true" enum:"SyncType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetRepositorySyncStatusInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetRepositorySyncStatusInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetRepositorySyncStatusInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetRepositorySyncStatusInput"}
	if s.Branch == nil {
		invalidParams.Add(request.NewErrParamRequired("Branch"))
	}
	if s.Branch != nil && len(*s.Branch) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Branch", 1))
	}
	if s.RepositoryName == nil {
		invalidParams.Add(request.NewErrParamRequired("RepositoryName"))
	}
	if s.RepositoryName != nil && len(*s.RepositoryName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RepositoryName", 1))
	}
	if s.RepositoryProvider == nil {
		invalidParams.Add(request.NewErrParamRequired("RepositoryProvider"))
	}
	if s.SyncType == nil {
		invalidParams.Add(request.NewErrParamRequired("SyncType"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBranch sets the Branch field's value.
func (s *GetRepositorySyncStatusInput) SetBranch(v string) *GetRepositorySyncStatusInput {
	s.Branch = &v
	return s
}

// SetRepositoryName sets the RepositoryName field's value.
func (s *GetRepositorySyncStatusInput) SetRepositoryName(v string) *GetRepositorySyncStatusInput {
	s.RepositoryName = &v
	return s
}

// SetRepositoryProvider sets the RepositoryProvider field's value.
func (s *GetRepositorySyncStatusInput) SetRepositoryProvider(v string) *GetRepositorySyncStatusInput {
	s.RepositoryProvider = &v
	return s
}

// SetSyncType sets the SyncType field's value.
func (s *GetRepositorySyncStatusInput) SetSyncType(v string) *GetRepositorySyncStatusInput {
	s.SyncType = &v
	return s
}

type GetRepositorySyncStatusOutput struct {
	_ struct{} `type:"structure"`

	// The repository sync status detail data that's returned by Proton.
	LatestSync *RepositorySyncAttempt `locationName:"latestSync" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetRepositorySyncStatusOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetRepositorySyncStatusOutput) GoString() string {
	return s.String()
}

// SetLatestSync sets the LatestSync field's value.
func (s *GetRepositorySyncStatusOutput) SetLatestSync(v *RepositorySyncAttempt) *GetRepositorySyncStatusOutput {
	s.LatestSync = v
	return s
}

type GetResourcesSummaryInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetResourcesSummaryInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetResourcesSummaryInput) GoString() string {
	return s.String()
}

type GetResourcesSummaryOutput struct {
	_ struct{} `type:"structure"`

	// Summary counts of each Proton resource type.
	//
	// Counts is a required field
	Counts *CountsSummary `locationName:"counts" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetResourcesSummaryOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetResourcesSummaryOutput) GoString() string {
	return s.String()
}

// SetCounts sets the Counts field's value.
func (s *GetResourcesSummaryOutput) SetCounts(v *CountsSummary) *GetResourcesSummaryOutput {
	s.Counts = v
	return s
}

type GetServiceInput struct {
	_ struct{} `type:"structure"`

	// The name of the service that you want to get the detailed data for.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetServiceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetServiceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetServiceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetServiceInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *GetServiceInput) SetName(v string) *GetServiceInput {
	s.Name = &v
	return s
}

type GetServiceInstanceInput struct {
	_ struct{} `type:"structure"`

	// The name of a service instance that you want to get the detailed data for.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// The name of the service that you want the service instance input for.
	//
	// ServiceName is a required field
	ServiceName *string `locationName:"serviceName" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetServiceInstanceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetServiceInstanceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetServiceInstanceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetServiceInstanceInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.ServiceName == nil {
		invalidParams.Add(request.NewErrParamRequired("ServiceName"))
	}
	if s.ServiceName != nil && len(*s.ServiceName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ServiceName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *GetServiceInstanceInput) SetName(v string) *GetServiceInstanceInput {
	s.Name = &v
	return s
}

// SetServiceName sets the ServiceName field's value.
func (s *GetServiceInstanceInput) SetServiceName(v string) *GetServiceInstanceInput {
	s.ServiceName = &v
	return s
}

type GetServiceInstanceOutput struct {
	_ struct{} `type:"structure"`

	// The detailed data of the requested service instance.
	//
	// ServiceInstance is a required field
	ServiceInstance *ServiceInstance `locationName:"serviceInstance" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetServiceInstanceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetServiceInstanceOutput) GoString() string {
	return s.String()
}

// SetServiceInstance sets the ServiceInstance field's value.
func (s *GetServiceInstanceOutput) SetServiceInstance(v *ServiceInstance) *GetServiceInstanceOutput {
	s.ServiceInstance = v
	return s
}

type GetServiceInstanceSyncStatusInput struct {
	_ struct{} `type:"structure"`

	// The name of the service instance that you want the sync status input for.
	//
	// ServiceInstanceName is a required field
	ServiceInstanceName *string `locationName:"serviceInstanceName" min:"1" type:"string" required:"true"`

	// The name of the service that the service instance belongs to.
	//
	// ServiceName is a required field
	ServiceName *string `locationName:"serviceName" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetServiceInstanceSyncStatusInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetServiceInstanceSyncStatusInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetServiceInstanceSyncStatusInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetServiceInstanceSyncStatusInput"}
	if s.ServiceInstanceName == nil {
		invalidParams.Add(request.NewErrParamRequired("ServiceInstanceName"))
	}
	if s.ServiceInstanceName != nil && len(*s.ServiceInstanceName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ServiceInstanceName", 1))
	}
	if s.ServiceName == nil {
		invalidParams.Add(request.NewErrParamRequired("ServiceName"))
	}
	if s.ServiceName != nil && len(*s.ServiceName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ServiceName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetServiceInstanceName sets the ServiceInstanceName field's value.
func (s *GetServiceInstanceSyncStatusInput) SetServiceInstanceName(v string) *GetServiceInstanceSyncStatusInput {
	s.ServiceInstanceName = &v
	return s
}

// SetServiceName sets the ServiceName field's value.
func (s *GetServiceInstanceSyncStatusInput) SetServiceName(v string) *GetServiceInstanceSyncStatusInput {
	s.ServiceName = &v
	return s
}

type GetServiceInstanceSyncStatusOutput struct {
	_ struct{} `type:"structure"`

	// The service instance sync desired state that's returned by Proton
	DesiredState *Revision `locationName:"desiredState" type:"structure"`

	// The detailed data of the latest successful sync with the service instance.
	LatestSuccessfulSync *ResourceSyncAttempt `locationName:"latestSuccessfulSync" type:"structure"`

	// The detailed data of the latest sync with the service instance.
	LatestSync *ResourceSyncAttempt `locationName:"latestSync" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetServiceInstanceSyncStatusOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetServiceInstanceSyncStatusOutput) GoString() string {
	return s.String()
}

// SetDesiredState sets the DesiredState field's value.
func (s *GetServiceInstanceSyncStatusOutput) SetDesiredState(v *Revision) *GetServiceInstanceSyncStatusOutput {
	s.DesiredState = v
	return s
}

// SetLatestSuccessfulSync sets the LatestSuccessfulSync field's value.
func (s *GetServiceInstanceSyncStatusOutput) SetLatestSuccessfulSync(v *ResourceSyncAttempt) *GetServiceInstanceSyncStatusOutput {
	s.LatestSuccessfulSync = v
	return s
}

// SetLatestSync sets the LatestSync field's value.
func (s *GetServiceInstanceSyncStatusOutput) SetLatestSync(v *ResourceSyncAttempt) *GetServiceInstanceSyncStatusOutput {
	s.LatestSync = v
	return s
}

type GetServiceOutput struct {
	_ struct{} `type:"structure"`

	// The detailed data of the requested service.
	Service *Service `locationName:"service" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetServiceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetServiceOutput) GoString() string {
	return s.String()
}

// SetService sets the Service field's value.
func (s *GetServiceOutput) SetService(v *Service) *GetServiceOutput {
	s.Service = v
	return s
}

type GetServiceSyncBlockerSummaryInput struct {
	_ struct{} `type:"structure"`

	// The name of the service instance that you want to get the service sync blocker
	// summary for. If given bothe the instance name and the service name, only
	// the instance is blocked.
	ServiceInstanceName *string `locationName:"serviceInstanceName" min:"1" type:"string"`

	// The name of the service that you want to get the service sync blocker summary
	// for. If given only the service name, all instances are blocked.
	//
	// ServiceName is a required field
	ServiceName *string `locationName:"serviceName" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetServiceSyncBlockerSummaryInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetServiceSyncBlockerSummaryInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetServiceSyncBlockerSummaryInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetServiceSyncBlockerSummaryInput"}
	if s.ServiceInstanceName != nil && len(*s.ServiceInstanceName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ServiceInstanceName", 1))
	}
	if s.ServiceName == nil {
		invalidParams.Add(request.NewErrParamRequired("ServiceName"))
	}
	if s.ServiceName != nil && len(*s.ServiceName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ServiceName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetServiceInstanceName sets the ServiceInstanceName field's value.
func (s *GetServiceSyncBlockerSummaryInput) SetServiceInstanceName(v string) *GetServiceSyncBlockerSummaryInput {
	s.ServiceInstanceName = &v
	return s
}

// SetServiceName sets the ServiceName field's value.
func (s *GetServiceSyncBlockerSummaryInput) SetServiceName(v string) *GetServiceSyncBlockerSummaryInput {
	s.ServiceName = &v
	return s
}

type GetServiceSyncBlockerSummaryOutput struct {
	_ struct{} `type:"structure"`

	// The detailed data of the requested service sync blocker summary.
	ServiceSyncBlockerSummary *ServiceSyncBlockerSummary `locationName:"serviceSyncBlockerSummary" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetServiceSyncBlockerSummaryOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetServiceSyncBlockerSummaryOutput) GoString() string {
	return s.String()
}

// SetServiceSyncBlockerSummary sets the ServiceSyncBlockerSummary field's value.
func (s *GetServiceSyncBlockerSummaryOutput) SetServiceSyncBlockerSummary(v *ServiceSyncBlockerSummary) *GetServiceSyncBlockerSummaryOutput {
	s.ServiceSyncBlockerSummary = v
	return s
}

type GetServiceSyncConfigInput struct {
	_ struct{} `type:"structure"`

	// The name of the service that you want to get the service sync configuration
	// for.
	//
	// ServiceName is a required field
	ServiceName *string `locationName:"serviceName" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetServiceSyncConfigInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetServiceSyncConfigInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetServiceSyncConfigInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetServiceSyncConfigInput"}
	if s.ServiceName == nil {
		invalidParams.Add(request.NewErrParamRequired("ServiceName"))
	}
	if s.ServiceName != nil && len(*s.ServiceName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ServiceName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetServiceName sets the ServiceName field's value.
func (s *GetServiceSyncConfigInput) SetServiceName(v string) *GetServiceSyncConfigInput {
	s.ServiceName = &v
	return s
}

type GetServiceSyncConfigOutput struct {
	_ struct{} `type:"structure"`

	// The detailed data of the requested service sync configuration.
	ServiceSyncConfig *ServiceSyncConfig `locationName:"serviceSyncConfig" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetServiceSyncConfigOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetServiceSyncConfigOutput) GoString() string {
	return s.String()
}

// SetServiceSyncConfig sets the ServiceSyncConfig field's value.
func (s *GetServiceSyncConfigOutput) SetServiceSyncConfig(v *ServiceSyncConfig) *GetServiceSyncConfigOutput {
	s.ServiceSyncConfig = v
	return s
}

type GetServiceTemplateInput struct {
	_ struct{} `type:"structure"`

	// The name of the service template that you want to get detailed data for.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetServiceTemplateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetServiceTemplateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetServiceTemplateInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetServiceTemplateInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *GetServiceTemplateInput) SetName(v string) *GetServiceTemplateInput {
	s.Name = &v
	return s
}

type GetServiceTemplateOutput struct {
	_ struct{} `type:"structure"`

	// The detailed data of the requested service template.
	//
	// ServiceTemplate is a required field
	ServiceTemplate *ServiceTemplate `locationName:"serviceTemplate" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetServiceTemplateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetServiceTemplateOutput) GoString() string {
	return s.String()
}

// SetServiceTemplate sets the ServiceTemplate field's value.
func (s *GetServiceTemplateOutput) SetServiceTemplate(v *ServiceTemplate) *GetServiceTemplateOutput {
	s.ServiceTemplate = v
	return s
}

type GetServiceTemplateVersionInput struct {
	_ struct{} `type:"structure"`

	// To get service template major version detail data, include major Version.
	//
	// MajorVersion is a required field
	MajorVersion *string `locationName:"majorVersion" min:"1" type:"string" required:"true"`

	// To get service template minor version detail data, include minorVersion.
	//
	// MinorVersion is a required field
	MinorVersion *string `locationName:"minorVersion" min:"1" type:"string" required:"true"`

	// The name of the service template a version of which you want to get detailed
	// data for.
	//
	// TemplateName is a required field
	TemplateName *string `locationName:"templateName" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetServiceTemplateVersionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetServiceTemplateVersionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetServiceTemplateVersionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetServiceTemplateVersionInput"}
	if s.MajorVersion == nil {
		invalidParams.Add(request.NewErrParamRequired("MajorVersion"))
	}
	if s.MajorVersion != nil && len(*s.MajorVersion) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MajorVersion", 1))
	}
	if s.MinorVersion == nil {
		invalidParams.Add(request.NewErrParamRequired("MinorVersion"))
	}
	if s.MinorVersion != nil && len(*s.MinorVersion) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MinorVersion", 1))
	}
	if s.TemplateName == nil {
		invalidParams.Add(request.NewErrParamRequired("TemplateName"))
	}
	if s.TemplateName != nil && len(*s.TemplateName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TemplateName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMajorVersion sets the MajorVersion field's value.
func (s *GetServiceTemplateVersionInput) SetMajorVersion(v string) *GetServiceTemplateVersionInput {
	s.MajorVersion = &v
	return s
}

// SetMinorVersion sets the MinorVersion field's value.
func (s *GetServiceTemplateVersionInput) SetMinorVersion(v string) *GetServiceTemplateVersionInput {
	s.MinorVersion = &v
	return s
}

// SetTemplateName sets the TemplateName field's value.
func (s *GetServiceTemplateVersionInput) SetTemplateName(v string) *GetServiceTemplateVersionInput {
	s.TemplateName = &v
	return s
}

type GetServiceTemplateVersionOutput struct {
	_ struct{} `type:"structure"`

	// The detailed data of the requested service template version.
	//
	// ServiceTemplateVersion is a required field
	ServiceTemplateVersion *ServiceTemplateVersion `locationName:"serviceTemplateVersion" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetServiceTemplateVersionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetServiceTemplateVersionOutput) GoString() string {
	return s.String()
}

// SetServiceTemplateVersion sets the ServiceTemplateVersion field's value.
func (s *GetServiceTemplateVersionOutput) SetServiceTemplateVersion(v *ServiceTemplateVersion) *GetServiceTemplateVersionOutput {
	s.ServiceTemplateVersion = v
	return s
}

type GetTemplateSyncConfigInput struct {
	_ struct{} `type:"structure"`

	// The template name.
	//
	// TemplateName is a required field
	TemplateName *string `locationName:"templateName" min:"1" type:"string" required:"true"`

	// The template type.
	//
	// TemplateType is a required field
	TemplateType *string `locationName:"templateType" type:"string" required:"true" enum:"TemplateType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetTemplateSyncConfigInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetTemplateSyncConfigInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetTemplateSyncConfigInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetTemplateSyncConfigInput"}
	if s.TemplateName == nil {
		invalidParams.Add(request.NewErrParamRequired("TemplateName"))
	}
	if s.TemplateName != nil && len(*s.TemplateName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TemplateName", 1))
	}
	if s.TemplateType == nil {
		invalidParams.Add(request.NewErrParamRequired("TemplateType"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetTemplateName sets the TemplateName field's value.
func (s *GetTemplateSyncConfigInput) SetTemplateName(v string) *GetTemplateSyncConfigInput {
	s.TemplateName = &v
	return s
}

// SetTemplateType sets the TemplateType field's value.
func (s *GetTemplateSyncConfigInput) SetTemplateType(v string) *GetTemplateSyncConfigInput {
	s.TemplateType = &v
	return s
}

type GetTemplateSyncConfigOutput struct {
	_ struct{} `type:"structure"`

	// The template sync configuration detail data that's returned by Proton.
	TemplateSyncConfig *TemplateSyncConfig `locationName:"templateSyncConfig" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetTemplateSyncConfigOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetTemplateSyncConfigOutput) GoString() string {
	return s.String()
}

// SetTemplateSyncConfig sets the TemplateSyncConfig field's value.
func (s *GetTemplateSyncConfigOutput) SetTemplateSyncConfig(v *TemplateSyncConfig) *GetTemplateSyncConfigOutput {
	s.TemplateSyncConfig = v
	return s
}

type GetTemplateSyncStatusInput struct {
	_ struct{} `type:"structure"`

	// The template name.
	//
	// TemplateName is a required field
	TemplateName *string `locationName:"templateName" min:"1" type:"string" required:"true"`

	// The template type.
	//
	// TemplateType is a required field
	TemplateType *string `locationName:"templateType" type:"string" required:"true" enum:"TemplateType"`

	// The template major version.
	//
	// TemplateVersion is a required field
	TemplateVersion *string `locationName:"templateVersion" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetTemplateSyncStatusInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetTemplateSyncStatusInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetTemplateSyncStatusInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetTemplateSyncStatusInput"}
	if s.TemplateName == nil {
		invalidParams.Add(request.NewErrParamRequired("TemplateName"))
	}
	if s.TemplateName != nil && len(*s.TemplateName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TemplateName", 1))
	}
	if s.TemplateType == nil {
		invalidParams.Add(request.NewErrParamRequired("TemplateType"))
	}
	if s.TemplateVersion == nil {
		invalidParams.Add(request.NewErrParamRequired("TemplateVersion"))
	}
	if s.TemplateVersion != nil && len(*s.TemplateVersion) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TemplateVersion", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetTemplateName sets the TemplateName field's value.
func (s *GetTemplateSyncStatusInput) SetTemplateName(v string) *GetTemplateSyncStatusInput {
	s.TemplateName = &v
	return s
}

// SetTemplateType sets the TemplateType field's value.
func (s *GetTemplateSyncStatusInput) SetTemplateType(v string) *GetTemplateSyncStatusInput {
	s.TemplateType = &v
	return s
}

// SetTemplateVersion sets the TemplateVersion field's value.
func (s *GetTemplateSyncStatusInput) SetTemplateVersion(v string) *GetTemplateSyncStatusInput {
	s.TemplateVersion = &v
	return s
}

type GetTemplateSyncStatusOutput struct {
	_ struct{} `type:"structure"`

	// The template sync desired state that's returned by Proton.
	DesiredState *Revision `locationName:"desiredState" type:"structure"`

	// The details of the last successful sync that's returned by Proton.
	LatestSuccessfulSync *ResourceSyncAttempt `locationName:"latestSuccessfulSync" type:"structure"`

	// The details of the last sync that's returned by Proton.
	LatestSync *ResourceSyncAttempt `locationName:"latestSync" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetTemplateSyncStatusOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetTemplateSyncStatusOutput) GoString() string {
	return s.String()
}

// SetDesiredState sets the DesiredState field's value.
func (s *GetTemplateSyncStatusOutput) SetDesiredState(v *Revision) *GetTemplateSyncStatusOutput {
	s.DesiredState = v
	return s
}

// SetLatestSuccessfulSync sets the LatestSuccessfulSync field's value.
func (s *GetTemplateSyncStatusOutput) SetLatestSuccessfulSync(v *ResourceSyncAttempt) *GetTemplateSyncStatusOutput {
	s.LatestSuccessfulSync = v
	return s
}

// SetLatestSync sets the LatestSync field's value.
func (s *GetTemplateSyncStatusOutput) SetLatestSync(v *ResourceSyncAttempt) *GetTemplateSyncStatusOutput {
	s.LatestSync = v
	return s
}

// The request failed to register with the service.
type InternalServerException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// Message_ is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by InternalServerException's
	// String and GoString methods.
	Message_ *string `locationName:"message" type:"string" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerException) GoString() string {
	return s.String()
}

func newErrorInternalServerException(v protocol.ResponseMetadata) error {
	return &InternalServerException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InternalServerException) Code() string {
	return "InternalServerException"
}

// Message returns the exception's message.
func (s *InternalServerException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InternalServerException) OrigErr() error {
	return nil
}

func (s *InternalServerException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InternalServerException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InternalServerException) RequestID() string {
	return s.RespMetadata.RequestID
}

type ListComponentOutputsInput struct {
	_ struct{} `type:"structure"`

	// The name of the component whose outputs you want.
	//
	// ComponentName is a required field
	ComponentName *string `locationName:"componentName" min:"1" type:"string" required:"true"`

	// The ID of the deployment whose outputs you want.
	DeploymentId *string `locationName:"deploymentId" type:"string"`

	// A token that indicates the location of the next output in the array of outputs,
	// after the list of outputs that was previously requested.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListComponentOutputsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListComponentOutputsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListComponentOutputsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListComponentOutputsInput"}
	if s.ComponentName == nil {
		invalidParams.Add(request.NewErrParamRequired("ComponentName"))
	}
	if s.ComponentName != nil && len(*s.ComponentName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ComponentName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetComponentName sets the ComponentName field's value.
func (s *ListComponentOutputsInput) SetComponentName(v string) *ListComponentOutputsInput {
	s.ComponentName = &v
	return s
}

// SetDeploymentId sets the DeploymentId field's value.
func (s *ListComponentOutputsInput) SetDeploymentId(v string) *ListComponentOutputsInput {
	s.DeploymentId = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListComponentOutputsInput) SetNextToken(v string) *ListComponentOutputsInput {
	s.NextToken = &v
	return s
}

type ListComponentOutputsOutput struct {
	_ struct{} `type:"structure"`

	// A token that indicates the location of the next output in the array of outputs,
	// after the list of outputs that was previously requested.
	NextToken *string `locationName:"nextToken" type:"string"`

	// An array of component Infrastructure as Code (IaC) outputs.
	//
	// Outputs is a required field
	Outputs []*Output_ `locationName:"outputs" type:"list" required:"true" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListComponentOutputsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListComponentOutputsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListComponentOutputsOutput) SetNextToken(v string) *ListComponentOutputsOutput {
	s.NextToken = &v
	return s
}

// SetOutputs sets the Outputs field's value.
func (s *ListComponentOutputsOutput) SetOutputs(v []*Output_) *ListComponentOutputsOutput {
	s.Outputs = v
	return s
}

type ListComponentProvisionedResourcesInput struct {
	_ struct{} `type:"structure"`

	// The name of the component whose provisioned resources you want.
	//
	// ComponentName is a required field
	ComponentName *string `locationName:"componentName" min:"1" type:"string" required:"true"`

	// A token that indicates the location of the next provisioned resource in the
	// array of provisioned resources, after the list of provisioned resources that
	// was previously requested.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListComponentProvisionedResourcesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListComponentProvisionedResourcesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListComponentProvisionedResourcesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListComponentProvisionedResourcesInput"}
	if s.ComponentName == nil {
		invalidParams.Add(request.NewErrParamRequired("ComponentName"))
	}
	if s.ComponentName != nil && len(*s.ComponentName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ComponentName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetComponentName sets the ComponentName field's value.
func (s *ListComponentProvisionedResourcesInput) SetComponentName(v string) *ListComponentProvisionedResourcesInput {
	s.ComponentName = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListComponentProvisionedResourcesInput) SetNextToken(v string) *ListComponentProvisionedResourcesInput {
	s.NextToken = &v
	return s
}

type ListComponentProvisionedResourcesOutput struct {
	_ struct{} `type:"structure"`

	// A token that indicates the location of the next provisioned resource in the
	// array of provisioned resources, after the current requested list of provisioned
	// resources.
	NextToken *string `locationName:"nextToken" type:"string"`

	// An array of provisioned resources for a component.
	//
	// ProvisionedResources is a required field
	ProvisionedResources []*ProvisionedResource `locationName:"provisionedResources" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListComponentProvisionedResourcesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListComponentProvisionedResourcesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListComponentProvisionedResourcesOutput) SetNextToken(v string) *ListComponentProvisionedResourcesOutput {
	s.NextToken = &v
	return s
}

// SetProvisionedResources sets the ProvisionedResources field's value.
func (s *ListComponentProvisionedResourcesOutput) SetProvisionedResources(v []*ProvisionedResource) *ListComponentProvisionedResourcesOutput {
	s.ProvisionedResources = v
	return s
}

type ListComponentsInput struct {
	_ struct{} `type:"structure"`

	// The name of an environment for result list filtering. Proton returns components
	// associated with the environment or attached to service instances running
	// in it.
	EnvironmentName *string `locationName:"environmentName" min:"1" type:"string"`

	// The maximum number of components to list.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// A token that indicates the location of the next component in the array of
	// components, after the list of components that was previously requested.
	NextToken *string `locationName:"nextToken" type:"string"`

	// The name of a service instance for result list filtering. Proton returns
	// the component attached to the service instance, if any.
	ServiceInstanceName *string `locationName:"serviceInstanceName" min:"1" type:"string"`

	// The name of a service for result list filtering. Proton returns components
	// attached to service instances of the service.
	ServiceName *string `locationName:"serviceName" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListComponentsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListComponentsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListComponentsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListComponentsInput"}
	if s.EnvironmentName != nil && len(*s.EnvironmentName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EnvironmentName", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.ServiceInstanceName != nil && len(*s.ServiceInstanceName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ServiceInstanceName", 1))
	}
	if s.ServiceName != nil && len(*s.ServiceName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ServiceName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEnvironmentName sets the EnvironmentName field's value.
func (s *ListComponentsInput) SetEnvironmentName(v string) *ListComponentsInput {
	s.EnvironmentName = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListComponentsInput) SetMaxResults(v int64) *ListComponentsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListComponentsInput) SetNextToken(v string) *ListComponentsInput {
	s.NextToken = &v
	return s
}

// SetServiceInstanceName sets the ServiceInstanceName field's value.
func (s *ListComponentsInput) SetServiceInstanceName(v string) *ListComponentsInput {
	s.ServiceInstanceName = &v
	return s
}

// SetServiceName sets the ServiceName field's value.
func (s *ListComponentsInput) SetServiceName(v string) *ListComponentsInput {
	s.ServiceName = &v
	return s
}

type ListComponentsOutput struct {
	_ struct{} `type:"structure"`

	// An array of components with summary data.
	//
	// Components is a required field
	Components []*ComponentSummary `locationName:"components" type:"list" required:"true"`

	// A token that indicates the location of the next component in the array of
	// components, after the current requested list of components.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListComponentsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListComponentsOutput) GoString() string {
	return s.String()
}

// SetComponents sets the Components field's value.
func (s *ListComponentsOutput) SetComponents(v []*ComponentSummary) *ListComponentsOutput {
	s.Components = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListComponentsOutput) SetNextToken(v string) *ListComponentsOutput {
	s.NextToken = &v
	return s
}

type ListDeploymentsInput struct {
	_ struct{} `type:"structure"`

	// The name of a component for result list filtering. Proton returns deployments
	// associated with that component.
	ComponentName *string `locationName:"componentName" min:"1" type:"string"`

	// The name of an environment for result list filtering. Proton returns deployments
	// associated with the environment.
	EnvironmentName *string `locationName:"environmentName" min:"1" type:"string"`

	// The maximum number of deployments to list.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// A token that indicates the location of the next deployment in the array of
	// deployment, after the list of deployment that was previously requested.
	NextToken *string `locationName:"nextToken" type:"string"`

	// The name of a service instance for result list filtering. Proton returns
	// the deployments associated with the service instance.
	ServiceInstanceName *string `locationName:"serviceInstanceName" min:"1" type:"string"`

	// The name of a service for result list filtering. Proton returns deployments
	// associated with service instances of the service.
	ServiceName *string `locationName:"serviceName" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDeploymentsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDeploymentsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListDeploymentsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListDeploymentsInput"}
	if s.ComponentName != nil && len(*s.ComponentName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ComponentName", 1))
	}
	if s.EnvironmentName != nil && len(*s.EnvironmentName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EnvironmentName", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.ServiceInstanceName != nil && len(*s.ServiceInstanceName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ServiceInstanceName", 1))
	}
	if s.ServiceName != nil && len(*s.ServiceName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ServiceName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetComponentName sets the ComponentName field's value.
func (s *ListDeploymentsInput) SetComponentName(v string) *ListDeploymentsInput {
	s.ComponentName = &v
	return s
}

// SetEnvironmentName sets the EnvironmentName field's value.
func (s *ListDeploymentsInput) SetEnvironmentName(v string) *ListDeploymentsInput {
	s.EnvironmentName = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListDeploymentsInput) SetMaxResults(v int64) *ListDeploymentsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListDeploymentsInput) SetNextToken(v string) *ListDeploymentsInput {
	s.NextToken = &v
	return s
}

// SetServiceInstanceName sets the ServiceInstanceName field's value.
func (s *ListDeploymentsInput) SetServiceInstanceName(v string) *ListDeploymentsInput {
	s.ServiceInstanceName = &v
	return s
}

// SetServiceName sets the ServiceName field's value.
func (s *ListDeploymentsInput) SetServiceName(v string) *ListDeploymentsInput {
	s.ServiceName = &v
	return s
}

type ListDeploymentsOutput struct {
	_ struct{} `type:"structure"`

	// An array of deployment with summary data.
	//
	// Deployments is a required field
	Deployments []*DeploymentSummary `locationName:"deployments" type:"list" required:"true"`

	// A token that indicates the location of the next deployment in the array of
	// deployment, after the current requested list of deployment.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDeploymentsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDeploymentsOutput) GoString() string {
	return s.String()
}

// SetDeployments sets the Deployments field's value.
func (s *ListDeploymentsOutput) SetDeployments(v []*DeploymentSummary) *ListDeploymentsOutput {
	s.Deployments = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListDeploymentsOutput) SetNextToken(v string) *ListDeploymentsOutput {
	s.NextToken = &v
	return s
}

type ListEnvironmentAccountConnectionsInput struct {
	_ struct{} `type:"structure"`

	// The environment name that's associated with each listed environment account
	// connection.
	EnvironmentName *string `locationName:"environmentName" min:"1" type:"string"`

	// The maximum number of environment account connections to list.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// A token that indicates the location of the next environment account connection
	// in the array of environment account connections, after the list of environment
	// account connections that was previously requested.
	NextToken *string `locationName:"nextToken" type:"string"`

	// The type of account making the ListEnvironmentAccountConnections request.
	//
	// RequestedBy is a required field
	RequestedBy *string `locationName:"requestedBy" type:"string" required:"true" enum:"EnvironmentAccountConnectionRequesterAccountType"`

	// The status details for each listed environment account connection.
	Statuses []*string `locationName:"statuses" type:"list" enum:"EnvironmentAccountConnectionStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListEnvironmentAccountConnectionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListEnvironmentAccountConnectionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListEnvironmentAccountConnectionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListEnvironmentAccountConnectionsInput"}
	if s.EnvironmentName != nil && len(*s.EnvironmentName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EnvironmentName", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.RequestedBy == nil {
		invalidParams.Add(request.NewErrParamRequired("RequestedBy"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEnvironmentName sets the EnvironmentName field's value.
func (s *ListEnvironmentAccountConnectionsInput) SetEnvironmentName(v string) *ListEnvironmentAccountConnectionsInput {
	s.EnvironmentName = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListEnvironmentAccountConnectionsInput) SetMaxResults(v int64) *ListEnvironmentAccountConnectionsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListEnvironmentAccountConnectionsInput) SetNextToken(v string) *ListEnvironmentAccountConnectionsInput {
	s.NextToken = &v
	return s
}

// SetRequestedBy sets the RequestedBy field's value.
func (s *ListEnvironmentAccountConnectionsInput) SetRequestedBy(v string) *ListEnvironmentAccountConnectionsInput {
	s.RequestedBy = &v
	return s
}

// SetStatuses sets the Statuses field's value.
func (s *ListEnvironmentAccountConnectionsInput) SetStatuses(v []*string) *ListEnvironmentAccountConnectionsInput {
	s.Statuses = v
	return s
}

type ListEnvironmentAccountConnectionsOutput struct {
	_ struct{} `type:"structure"`

	// An array of environment account connections with details that's returned
	// by Proton.
	//
	// EnvironmentAccountConnections is a required field
	EnvironmentAccountConnections []*EnvironmentAccountConnectionSummary `locationName:"environmentAccountConnections" type:"list" required:"true"`

	// A token that indicates the location of the next environment account connection
	// in the array of environment account connections, after the current requested
	// list of environment account connections.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListEnvironmentAccountConnectionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListEnvironmentAccountConnectionsOutput) GoString() string {
	return s.String()
}

// SetEnvironmentAccountConnections sets the EnvironmentAccountConnections field's value.
func (s *ListEnvironmentAccountConnectionsOutput) SetEnvironmentAccountConnections(v []*EnvironmentAccountConnectionSummary) *ListEnvironmentAccountConnectionsOutput {
	s.EnvironmentAccountConnections = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListEnvironmentAccountConnectionsOutput) SetNextToken(v string) *ListEnvironmentAccountConnectionsOutput {
	s.NextToken = &v
	return s
}

type ListEnvironmentOutputsInput struct {
	_ struct{} `type:"structure"`

	// The ID of the deployment whose outputs you want.
	DeploymentId *string `locationName:"deploymentId" type:"string"`

	// The environment name.
	//
	// EnvironmentName is a required field
	EnvironmentName *string `locationName:"environmentName" min:"1" type:"string" required:"true"`

	// A token that indicates the location of the next environment output in the
	// array of environment outputs, after the list of environment outputs that
	// was previously requested.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListEnvironmentOutputsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListEnvironmentOutputsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListEnvironmentOutputsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListEnvironmentOutputsInput"}
	if s.EnvironmentName == nil {
		invalidParams.Add(request.NewErrParamRequired("EnvironmentName"))
	}
	if s.EnvironmentName != nil && len(*s.EnvironmentName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EnvironmentName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDeploymentId sets the DeploymentId field's value.
func (s *ListEnvironmentOutputsInput) SetDeploymentId(v string) *ListEnvironmentOutputsInput {
	s.DeploymentId = &v
	return s
}

// SetEnvironmentName sets the EnvironmentName field's value.
func (s *ListEnvironmentOutputsInput) SetEnvironmentName(v string) *ListEnvironmentOutputsInput {
	s.EnvironmentName = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListEnvironmentOutputsInput) SetNextToken(v string) *ListEnvironmentOutputsInput {
	s.NextToken = &v
	return s
}

type ListEnvironmentOutputsOutput struct {
	_ struct{} `type:"structure"`

	// A token that indicates the location of the next environment output in the
	// array of environment outputs, after the current requested list of environment
	// outputs.
	NextToken *string `locationName:"nextToken" type:"string"`

	// An array of environment outputs with detail data.
	//
	// Outputs is a required field
	Outputs []*Output_ `locationName:"outputs" type:"list" required:"true" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListEnvironmentOutputsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListEnvironmentOutputsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListEnvironmentOutputsOutput) SetNextToken(v string) *ListEnvironmentOutputsOutput {
	s.NextToken = &v
	return s
}

// SetOutputs sets the Outputs field's value.
func (s *ListEnvironmentOutputsOutput) SetOutputs(v []*Output_) *ListEnvironmentOutputsOutput {
	s.Outputs = v
	return s
}

type ListEnvironmentProvisionedResourcesInput struct {
	_ struct{} `type:"structure"`

	// The environment name.
	//
	// EnvironmentName is a required field
	EnvironmentName *string `locationName:"environmentName" min:"1" type:"string" required:"true"`

	// A token that indicates the location of the next environment provisioned resource
	// in the array of environment provisioned resources, after the list of environment
	// provisioned resources that was previously requested.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListEnvironmentProvisionedResourcesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListEnvironmentProvisionedResourcesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListEnvironmentProvisionedResourcesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListEnvironmentProvisionedResourcesInput"}
	if s.EnvironmentName == nil {
		invalidParams.Add(request.NewErrParamRequired("EnvironmentName"))
	}
	if s.EnvironmentName != nil && len(*s.EnvironmentName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EnvironmentName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEnvironmentName sets the EnvironmentName field's value.
func (s *ListEnvironmentProvisionedResourcesInput) SetEnvironmentName(v string) *ListEnvironmentProvisionedResourcesInput {
	s.EnvironmentName = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListEnvironmentProvisionedResourcesInput) SetNextToken(v string) *ListEnvironmentProvisionedResourcesInput {
	s.NextToken = &v
	return s
}

type ListEnvironmentProvisionedResourcesOutput struct {
	_ struct{} `type:"structure"`

	// A token that indicates the location of the next environment provisioned resource
	// in the array of provisioned resources, after the current requested list of
	// environment provisioned resources.
	NextToken *string `locationName:"nextToken" type:"string"`

	// An array of environment provisioned resources.
	//
	// ProvisionedResources is a required field
	ProvisionedResources []*ProvisionedResource `locationName:"provisionedResources" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListEnvironmentProvisionedResourcesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListEnvironmentProvisionedResourcesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListEnvironmentProvisionedResourcesOutput) SetNextToken(v string) *ListEnvironmentProvisionedResourcesOutput {
	s.NextToken = &v
	return s
}

// SetProvisionedResources sets the ProvisionedResources field's value.
func (s *ListEnvironmentProvisionedResourcesOutput) SetProvisionedResources(v []*ProvisionedResource) *ListEnvironmentProvisionedResourcesOutput {
	s.ProvisionedResources = v
	return s
}

type ListEnvironmentTemplateVersionsInput struct {
	_ struct{} `type:"structure"`

	// To view a list of minor of versions under a major version of an environment
	// template, include major Version.
	//
	// To view a list of major versions of an environment template, exclude major
	// Version.
	MajorVersion *string `locationName:"majorVersion" min:"1" type:"string"`

	// The maximum number of major or minor versions of an environment template
	// to list.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// A token that indicates the location of the next major or minor version in
	// the array of major or minor versions of an environment template, after the
	// list of major or minor versions that was previously requested.
	NextToken *string `locationName:"nextToken" type:"string"`

	// The name of the environment template.
	//
	// TemplateName is a required field
	TemplateName *string `locationName:"templateName" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListEnvironmentTemplateVersionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListEnvironmentTemplateVersionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListEnvironmentTemplateVersionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListEnvironmentTemplateVersionsInput"}
	if s.MajorVersion != nil && len(*s.MajorVersion) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MajorVersion", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.TemplateName == nil {
		invalidParams.Add(request.NewErrParamRequired("TemplateName"))
	}
	if s.TemplateName != nil && len(*s.TemplateName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TemplateName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMajorVersion sets the MajorVersion field's value.
func (s *ListEnvironmentTemplateVersionsInput) SetMajorVersion(v string) *ListEnvironmentTemplateVersionsInput {
	s.MajorVersion = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListEnvironmentTemplateVersionsInput) SetMaxResults(v int64) *ListEnvironmentTemplateVersionsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListEnvironmentTemplateVersionsInput) SetNextToken(v string) *ListEnvironmentTemplateVersionsInput {
	s.NextToken = &v
	return s
}

// SetTemplateName sets the TemplateName field's value.
func (s *ListEnvironmentTemplateVersionsInput) SetTemplateName(v string) *ListEnvironmentTemplateVersionsInput {
	s.TemplateName = &v
	return s
}

type ListEnvironmentTemplateVersionsOutput struct {
	_ struct{} `type:"structure"`

	// A token that indicates the location of the next major or minor version in
	// the array of major or minor versions of an environment template, after the
	// list of major or minor versions that was previously requested.
	NextToken *string `locationName:"nextToken" type:"string"`

	// An array of major or minor versions of an environment template detail data.
	//
	// TemplateVersions is a required field
	TemplateVersions []*EnvironmentTemplateVersionSummary `locationName:"templateVersions" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListEnvironmentTemplateVersionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListEnvironmentTemplateVersionsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListEnvironmentTemplateVersionsOutput) SetNextToken(v string) *ListEnvironmentTemplateVersionsOutput {
	s.NextToken = &v
	return s
}

// SetTemplateVersions sets the TemplateVersions field's value.
func (s *ListEnvironmentTemplateVersionsOutput) SetTemplateVersions(v []*EnvironmentTemplateVersionSummary) *ListEnvironmentTemplateVersionsOutput {
	s.TemplateVersions = v
	return s
}

type ListEnvironmentTemplatesInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of environment templates to list.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// A token that indicates the location of the next environment template in the
	// array of environment templates, after the list of environment templates that
	// was previously requested.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListEnvironmentTemplatesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListEnvironmentTemplatesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListEnvironmentTemplatesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListEnvironmentTemplatesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListEnvironmentTemplatesInput) SetMaxResults(v int64) *ListEnvironmentTemplatesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListEnvironmentTemplatesInput) SetNextToken(v string) *ListEnvironmentTemplatesInput {
	s.NextToken = &v
	return s
}

type ListEnvironmentTemplatesOutput struct {
	_ struct{} `type:"structure"`

	// A token that indicates the location of the next environment template in the
	// array of environment templates, after the current requested list of environment
	// templates.
	NextToken *string `locationName:"nextToken" type:"string"`

	// An array of environment templates with detail data.
	//
	// Templates is a required field
	Templates []*EnvironmentTemplateSummary `locationName:"templates" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListEnvironmentTemplatesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListEnvironmentTemplatesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListEnvironmentTemplatesOutput) SetNextToken(v string) *ListEnvironmentTemplatesOutput {
	s.NextToken = &v
	return s
}

// SetTemplates sets the Templates field's value.
func (s *ListEnvironmentTemplatesOutput) SetTemplates(v []*EnvironmentTemplateSummary) *ListEnvironmentTemplatesOutput {
	s.Templates = v
	return s
}

type ListEnvironmentsInput struct {
	_ struct{} `type:"structure"`

	// An array of the versions of the environment template.
	EnvironmentTemplates []*EnvironmentTemplateFilter `locationName:"environmentTemplates" type:"list"`

	// The maximum number of environments to list.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// A token that indicates the location of the next environment in the array
	// of environments, after the list of environments that was previously requested.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListEnvironmentsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListEnvironmentsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListEnvironmentsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListEnvironmentsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.EnvironmentTemplates != nil {
		for i, v := range s.EnvironmentTemplates {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "EnvironmentTemplates", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEnvironmentTemplates sets the EnvironmentTemplates field's value.
func (s *ListEnvironmentsInput) SetEnvironmentTemplates(v []*EnvironmentTemplateFilter) *ListEnvironmentsInput {
	s.EnvironmentTemplates = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListEnvironmentsInput) SetMaxResults(v int64) *ListEnvironmentsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListEnvironmentsInput) SetNextToken(v string) *ListEnvironmentsInput {
	s.NextToken = &v
	return s
}

type ListEnvironmentsOutput struct {
	_ struct{} `type:"structure"`

	// An array of environment detail data summaries.
	//
	// Environments is a required field
	Environments []*EnvironmentSummary `locationName:"environments" type:"list" required:"true"`

	// A token that indicates the location of the next environment in the array
	// of environments, after the current requested list of environments.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListEnvironmentsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListEnvironmentsOutput) GoString() string {
	return s.String()
}

// SetEnvironments sets the Environments field's value.
func (s *ListEnvironmentsOutput) SetEnvironments(v []*EnvironmentSummary) *ListEnvironmentsOutput {
	s.Environments = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListEnvironmentsOutput) SetNextToken(v string) *ListEnvironmentsOutput {
	s.NextToken = &v
	return s
}

type ListRepositoriesInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of repositories to list.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// A token that indicates the location of the next repository in the array of
	// repositories, after the list of repositories previously requested.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListRepositoriesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListRepositoriesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListRepositoriesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListRepositoriesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListRepositoriesInput) SetMaxResults(v int64) *ListRepositoriesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListRepositoriesInput) SetNextToken(v string) *ListRepositoriesInput {
	s.NextToken = &v
	return s
}

type ListRepositoriesOutput struct {
	_ struct{} `type:"structure"`

	// A token that indicates the location of the next repository in the array of
	// repositories, after the current requested list of repositories.
	NextToken *string `locationName:"nextToken" type:"string"`

	// An array of repository links.
	//
	// Repositories is a required field
	Repositories []*RepositorySummary `locationName:"repositories" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListRepositoriesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListRepositoriesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListRepositoriesOutput) SetNextToken(v string) *ListRepositoriesOutput {
	s.NextToken = &v
	return s
}

// SetRepositories sets the Repositories field's value.
func (s *ListRepositoriesOutput) SetRepositories(v []*RepositorySummary) *ListRepositoriesOutput {
	s.Repositories = v
	return s
}

type ListRepositorySyncDefinitionsInput struct {
	_ struct{} `type:"structure"`

	// A token that indicates the location of the next repository sync definition
	// in the array of repository sync definitions, after the list of repository
	// sync definitions previously requested.
	NextToken *string `locationName:"nextToken" type:"string"`

	// The repository name.
	//
	// RepositoryName is a required field
	RepositoryName *string `locationName:"repositoryName" min:"1" type:"string" required:"true"`

	// The repository provider.
	//
	// RepositoryProvider is a required field
	RepositoryProvider *string `locationName:"repositoryProvider" type:"string" required:"true" enum:"RepositoryProvider"`

	// The sync type. The only supported value is TEMPLATE_SYNC.
	//
	// SyncType is a required field
	SyncType *string `locationName:"syncType" type:"string" required:"true" enum:"SyncType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListRepositorySyncDefinitionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListRepositorySyncDefinitionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListRepositorySyncDefinitionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListRepositorySyncDefinitionsInput"}
	if s.RepositoryName == nil {
		invalidParams.Add(request.NewErrParamRequired("RepositoryName"))
	}
	if s.RepositoryName != nil && len(*s.RepositoryName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RepositoryName", 1))
	}
	if s.RepositoryProvider == nil {
		invalidParams.Add(request.NewErrParamRequired("RepositoryProvider"))
	}
	if s.SyncType == nil {
		invalidParams.Add(request.NewErrParamRequired("SyncType"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetNextToken sets the NextToken field's value.
func (s *ListRepositorySyncDefinitionsInput) SetNextToken(v string) *ListRepositorySyncDefinitionsInput {
	s.NextToken = &v
	return s
}

// SetRepositoryName sets the RepositoryName field's value.
func (s *ListRepositorySyncDefinitionsInput) SetRepositoryName(v string) *ListRepositorySyncDefinitionsInput {
	s.RepositoryName = &v
	return s
}

// SetRepositoryProvider sets the RepositoryProvider field's value.
func (s *ListRepositorySyncDefinitionsInput) SetRepositoryProvider(v string) *ListRepositorySyncDefinitionsInput {
	s.RepositoryProvider = &v
	return s
}

// SetSyncType sets the SyncType field's value.
func (s *ListRepositorySyncDefinitionsInput) SetSyncType(v string) *ListRepositorySyncDefinitionsInput {
	s.SyncType = &v
	return s
}

type ListRepositorySyncDefinitionsOutput struct {
	_ struct{} `type:"structure"`

	// A token that indicates the location of the next repository sync definition
	// in the array of repository sync definitions, after the current requested
	// list of repository sync definitions.
	NextToken *string `locationName:"nextToken" type:"string"`

	// An array of repository sync definitions.
	//
	// SyncDefinitions is a required field
	SyncDefinitions []*RepositorySyncDefinition `locationName:"syncDefinitions" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListRepositorySyncDefinitionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListRepositorySyncDefinitionsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListRepositorySyncDefinitionsOutput) SetNextToken(v string) *ListRepositorySyncDefinitionsOutput {
	s.NextToken = &v
	return s
}

// SetSyncDefinitions sets the SyncDefinitions field's value.
func (s *ListRepositorySyncDefinitionsOutput) SetSyncDefinitions(v []*RepositorySyncDefinition) *ListRepositorySyncDefinitionsOutput {
	s.SyncDefinitions = v
	return s
}

type ListServiceInstanceOutputsInput struct {
	_ struct{} `type:"structure"`

	// The ID of the deployment whose outputs you want.
	DeploymentId *string `locationName:"deploymentId" type:"string"`

	// A token that indicates the location of the next output in the array of outputs,
	// after the list of outputs that was previously requested.
	NextToken *string `locationName:"nextToken" type:"string"`

	// The name of the service instance whose outputs you want.
	//
	// ServiceInstanceName is a required field
	ServiceInstanceName *string `locationName:"serviceInstanceName" min:"1" type:"string" required:"true"`

	// The name of the service that serviceInstanceName is associated to.
	//
	// ServiceName is a required field
	ServiceName *string `locationName:"serviceName" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListServiceInstanceOutputsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListServiceInstanceOutputsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListServiceInstanceOutputsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListServiceInstanceOutputsInput"}
	if s.ServiceInstanceName == nil {
		invalidParams.Add(request.NewErrParamRequired("ServiceInstanceName"))
	}
	if s.ServiceInstanceName != nil && len(*s.ServiceInstanceName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ServiceInstanceName", 1))
	}
	if s.ServiceName == nil {
		invalidParams.Add(request.NewErrParamRequired("ServiceName"))
	}
	if s.ServiceName != nil && len(*s.ServiceName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ServiceName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDeploymentId sets the DeploymentId field's value.
func (s *ListServiceInstanceOutputsInput) SetDeploymentId(v string) *ListServiceInstanceOutputsInput {
	s.DeploymentId = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListServiceInstanceOutputsInput) SetNextToken(v string) *ListServiceInstanceOutputsInput {
	s.NextToken = &v
	return s
}

// SetServiceInstanceName sets the ServiceInstanceName field's value.
func (s *ListServiceInstanceOutputsInput) SetServiceInstanceName(v string) *ListServiceInstanceOutputsInput {
	s.ServiceInstanceName = &v
	return s
}

// SetServiceName sets the ServiceName field's value.
func (s *ListServiceInstanceOutputsInput) SetServiceName(v string) *ListServiceInstanceOutputsInput {
	s.ServiceName = &v
	return s
}

type ListServiceInstanceOutputsOutput struct {
	_ struct{} `type:"structure"`

	// A token that indicates the location of the next output in the array of outputs,
	// after the current requested list of outputs.
	NextToken *string `locationName:"nextToken" type:"string"`

	// An array of service instance Infrastructure as Code (IaC) outputs.
	//
	// Outputs is a required field
	Outputs []*Output_ `locationName:"outputs" type:"list" required:"true" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListServiceInstanceOutputsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListServiceInstanceOutputsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListServiceInstanceOutputsOutput) SetNextToken(v string) *ListServiceInstanceOutputsOutput {
	s.NextToken = &v
	return s
}

// SetOutputs sets the Outputs field's value.
func (s *ListServiceInstanceOutputsOutput) SetOutputs(v []*Output_) *ListServiceInstanceOutputsOutput {
	s.Outputs = v
	return s
}

type ListServiceInstanceProvisionedResourcesInput struct {
	_ struct{} `type:"structure"`

	// A token that indicates the location of the next provisioned resource in the
	// array of provisioned resources, after the list of provisioned resources that
	// was previously requested.
	NextToken *string `locationName:"nextToken" type:"string"`

	// The name of the service instance whose provisioned resources you want.
	//
	// ServiceInstanceName is a required field
	ServiceInstanceName *string `locationName:"serviceInstanceName" min:"1" type:"string" required:"true"`

	// The name of the service that serviceInstanceName is associated to.
	//
	// ServiceName is a required field
	ServiceName *string `locationName:"serviceName" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListServiceInstanceProvisionedResourcesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListServiceInstanceProvisionedResourcesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListServiceInstanceProvisionedResourcesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListServiceInstanceProvisionedResourcesInput"}
	if s.ServiceInstanceName == nil {
		invalidParams.Add(request.NewErrParamRequired("ServiceInstanceName"))
	}
	if s.ServiceInstanceName != nil && len(*s.ServiceInstanceName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ServiceInstanceName", 1))
	}
	if s.ServiceName == nil {
		invalidParams.Add(request.NewErrParamRequired("ServiceName"))
	}
	if s.ServiceName != nil && len(*s.ServiceName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ServiceName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetNextToken sets the NextToken field's value.
func (s *ListServiceInstanceProvisionedResourcesInput) SetNextToken(v string) *ListServiceInstanceProvisionedResourcesInput {
	s.NextToken = &v
	return s
}

// SetServiceInstanceName sets the ServiceInstanceName field's value.
func (s *ListServiceInstanceProvisionedResourcesInput) SetServiceInstanceName(v string) *ListServiceInstanceProvisionedResourcesInput {
	s.ServiceInstanceName = &v
	return s
}

// SetServiceName sets the ServiceName field's value.
func (s *ListServiceInstanceProvisionedResourcesInput) SetServiceName(v string) *ListServiceInstanceProvisionedResourcesInput {
	s.ServiceName = &v
	return s
}

type ListServiceInstanceProvisionedResourcesOutput struct {
	_ struct{} `type:"structure"`

	// A token that indicates the location of the next provisioned resource in the
	// array of provisioned resources, after the current requested list of provisioned
	// resources.
	NextToken *string `locationName:"nextToken" type:"string"`

	// An array of provisioned resources for a service instance.
	//
	// ProvisionedResources is a required field
	ProvisionedResources []*ProvisionedResource `locationName:"provisionedResources" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListServiceInstanceProvisionedResourcesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListServiceInstanceProvisionedResourcesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListServiceInstanceProvisionedResourcesOutput) SetNextToken(v string) *ListServiceInstanceProvisionedResourcesOutput {
	s.NextToken = &v
	return s
}

// SetProvisionedResources sets the ProvisionedResources field's value.
func (s *ListServiceInstanceProvisionedResourcesOutput) SetProvisionedResources(v []*ProvisionedResource) *ListServiceInstanceProvisionedResourcesOutput {
	s.ProvisionedResources = v
	return s
}

// A filtering criterion to scope down the result list of the ListServiceInstances
// action.
type ListServiceInstancesFilter struct {
	_ struct{} `type:"structure"`

	// The name of a filtering criterion.
	Key *string `locationName:"key" type:"string" enum:"ListServiceInstancesFilterBy"`

	// A value to filter by.
	//
	// With the date/time keys (*At{Before,After}), the value is a valid RFC 3339
	// (https://datatracker.ietf.org/doc/html/rfc3339.html) string with no UTC offset
	// and with an optional fractional precision (for example, 1985-04-12T23:20:50.52Z).
	Value *string `locationName:"value" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListServiceInstancesFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListServiceInstancesFilter) GoString() string {
	return s.String()
}

// SetKey sets the Key field's value.
func (s *ListServiceInstancesFilter) SetKey(v string) *ListServiceInstancesFilter {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *ListServiceInstancesFilter) SetValue(v string) *ListServiceInstancesFilter {
	s.Value = &v
	return s
}

type ListServiceInstancesInput struct {
	_ struct{} `type:"structure"`

	// An array of filtering criteria that scope down the result list. By default,
	// all service instances in the Amazon Web Services account are returned.
	Filters []*ListServiceInstancesFilter `locationName:"filters" type:"list"`

	// The maximum number of service instances to list.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// A token that indicates the location of the next service in the array of service
	// instances, after the list of service instances that was previously requested.
	NextToken *string `locationName:"nextToken" type:"string"`

	// The name of the service that the service instance belongs to.
	ServiceName *string `locationName:"serviceName" min:"1" type:"string"`

	// The field that the result list is sorted by.
	//
	// When you choose to sort by serviceName, service instances within each service
	// are sorted by service instance name.
	//
	// Default: serviceName
	SortBy *string `locationName:"sortBy" type:"string" enum:"ListServiceInstancesSortBy"`

	// Result list sort order.
	//
	// Default: ASCENDING
	SortOrder *string `locationName:"sortOrder" type:"string" enum:"SortOrder"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListServiceInstancesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListServiceInstancesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListServiceInstancesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListServiceInstancesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.ServiceName != nil && len(*s.ServiceName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ServiceName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilters sets the Filters field's value.
func (s *ListServiceInstancesInput) SetFilters(v []*ListServiceInstancesFilter) *ListServiceInstancesInput {
	s.Filters = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListServiceInstancesInput) SetMaxResults(v int64) *ListServiceInstancesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListServiceInstancesInput) SetNextToken(v string) *ListServiceInstancesInput {
	s.NextToken = &v
	return s
}

// SetServiceName sets the ServiceName field's value.
func (s *ListServiceInstancesInput) SetServiceName(v string) *ListServiceInstancesInput {
	s.ServiceName = &v
	return s
}

// SetSortBy sets the SortBy field's value.
func (s *ListServiceInstancesInput) SetSortBy(v string) *ListServiceInstancesInput {
	s.SortBy = &v
	return s
}

// SetSortOrder sets the SortOrder field's value.
func (s *ListServiceInstancesInput) SetSortOrder(v string) *ListServiceInstancesInput {
	s.SortOrder = &v
	return s
}

type ListServiceInstancesOutput struct {
	_ struct{} `type:"structure"`

	// A token that indicates the location of the next service instance in the array
	// of service instances, after the current requested list of service instances.
	NextToken *string `locationName:"nextToken" type:"string"`

	// An array of service instances with summary data.
	//
	// ServiceInstances is a required field
	ServiceInstances []*ServiceInstanceSummary `locationName:"serviceInstances" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListServiceInstancesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListServiceInstancesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListServiceInstancesOutput) SetNextToken(v string) *ListServiceInstancesOutput {
	s.NextToken = &v
	return s
}

// SetServiceInstances sets the ServiceInstances field's value.
func (s *ListServiceInstancesOutput) SetServiceInstances(v []*ServiceInstanceSummary) *ListServiceInstancesOutput {
	s.ServiceInstances = v
	return s
}

type ListServicePipelineOutputsInput struct {
	_ struct{} `type:"structure"`

	// The ID of the deployment you want the outputs for.
	DeploymentId *string `locationName:"deploymentId" type:"string"`

	// A token that indicates the location of the next output in the array of outputs,
	// after the list of outputs that was previously requested.
	NextToken *string `locationName:"nextToken" type:"string"`

	// The name of the service whose pipeline's outputs you want.
	//
	// ServiceName is a required field
	ServiceName *string `locationName:"serviceName" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListServicePipelineOutputsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListServicePipelineOutputsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListServicePipelineOutputsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListServicePipelineOutputsInput"}
	if s.ServiceName == nil {
		invalidParams.Add(request.NewErrParamRequired("ServiceName"))
	}
	if s.ServiceName != nil && len(*s.ServiceName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ServiceName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDeploymentId sets the DeploymentId field's value.
func (s *ListServicePipelineOutputsInput) SetDeploymentId(v string) *ListServicePipelineOutputsInput {
	s.DeploymentId = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListServicePipelineOutputsInput) SetNextToken(v string) *ListServicePipelineOutputsInput {
	s.NextToken = &v
	return s
}

// SetServiceName sets the ServiceName field's value.
func (s *ListServicePipelineOutputsInput) SetServiceName(v string) *ListServicePipelineOutputsInput {
	s.ServiceName = &v
	return s
}

type ListServicePipelineOutputsOutput struct {
	_ struct{} `type:"structure"`

	// A token that indicates the location of the next output in the array of outputs,
	// after the current requested list of outputs.
	NextToken *string `locationName:"nextToken" type:"string"`

	// An array of service pipeline Infrastructure as Code (IaC) outputs.
	//
	// Outputs is a required field
	Outputs []*Output_ `locationName:"outputs" type:"list" required:"true" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListServicePipelineOutputsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListServicePipelineOutputsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListServicePipelineOutputsOutput) SetNextToken(v string) *ListServicePipelineOutputsOutput {
	s.NextToken = &v
	return s
}

// SetOutputs sets the Outputs field's value.
func (s *ListServicePipelineOutputsOutput) SetOutputs(v []*Output_) *ListServicePipelineOutputsOutput {
	s.Outputs = v
	return s
}

type ListServicePipelineProvisionedResourcesInput struct {
	_ struct{} `type:"structure"`

	// A token that indicates the location of the next provisioned resource in the
	// array of provisioned resources, after the list of provisioned resources that
	// was previously requested.
	NextToken *string `locationName:"nextToken" type:"string"`

	// The name of the service whose pipeline's provisioned resources you want.
	//
	// ServiceName is a required field
	ServiceName *string `locationName:"serviceName" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListServicePipelineProvisionedResourcesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListServicePipelineProvisionedResourcesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListServicePipelineProvisionedResourcesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListServicePipelineProvisionedResourcesInput"}
	if s.ServiceName == nil {
		invalidParams.Add(request.NewErrParamRequired("ServiceName"))
	}
	if s.ServiceName != nil && len(*s.ServiceName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ServiceName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetNextToken sets the NextToken field's value.
func (s *ListServicePipelineProvisionedResourcesInput) SetNextToken(v string) *ListServicePipelineProvisionedResourcesInput {
	s.NextToken = &v
	return s
}

// SetServiceName sets the ServiceName field's value.
func (s *ListServicePipelineProvisionedResourcesInput) SetServiceName(v string) *ListServicePipelineProvisionedResourcesInput {
	s.ServiceName = &v
	return s
}

type ListServicePipelineProvisionedResourcesOutput struct {
	_ struct{} `type:"structure"`

	// A token that indicates the location of the next provisioned resource in the
	// array of provisioned resources, after the current requested list of provisioned
	// resources.
	NextToken *string `locationName:"nextToken" type:"string"`

	// An array of provisioned resources for a service and pipeline.
	//
	// ProvisionedResources is a required field
	ProvisionedResources []*ProvisionedResource `locationName:"provisionedResources" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListServicePipelineProvisionedResourcesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListServicePipelineProvisionedResourcesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListServicePipelineProvisionedResourcesOutput) SetNextToken(v string) *ListServicePipelineProvisionedResourcesOutput {
	s.NextToken = &v
	return s
}

// SetProvisionedResources sets the ProvisionedResources field's value.
func (s *ListServicePipelineProvisionedResourcesOutput) SetProvisionedResources(v []*ProvisionedResource) *ListServicePipelineProvisionedResourcesOutput {
	s.ProvisionedResources = v
	return s
}

type ListServiceTemplateVersionsInput struct {
	_ struct{} `type:"structure"`

	// To view a list of minor of versions under a major version of a service template,
	// include major Version.
	//
	// To view a list of major versions of a service template, exclude major Version.
	MajorVersion *string `locationName:"majorVersion" min:"1" type:"string"`

	// The maximum number of major or minor versions of a service template to list.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// A token that indicates the location of the next major or minor version in
	// the array of major or minor versions of a service template, after the list
	// of major or minor versions that was previously requested.
	NextToken *string `locationName:"nextToken" type:"string"`

	// The name of the service template.
	//
	// TemplateName is a required field
	TemplateName *string `locationName:"templateName" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListServiceTemplateVersionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListServiceTemplateVersionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListServiceTemplateVersionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListServiceTemplateVersionsInput"}
	if s.MajorVersion != nil && len(*s.MajorVersion) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MajorVersion", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.TemplateName == nil {
		invalidParams.Add(request.NewErrParamRequired("TemplateName"))
	}
	if s.TemplateName != nil && len(*s.TemplateName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TemplateName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMajorVersion sets the MajorVersion field's value.
func (s *ListServiceTemplateVersionsInput) SetMajorVersion(v string) *ListServiceTemplateVersionsInput {
	s.MajorVersion = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListServiceTemplateVersionsInput) SetMaxResults(v int64) *ListServiceTemplateVersionsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListServiceTemplateVersionsInput) SetNextToken(v string) *ListServiceTemplateVersionsInput {
	s.NextToken = &v
	return s
}

// SetTemplateName sets the TemplateName field's value.
func (s *ListServiceTemplateVersionsInput) SetTemplateName(v string) *ListServiceTemplateVersionsInput {
	s.TemplateName = &v
	return s
}

type ListServiceTemplateVersionsOutput struct {
	_ struct{} `type:"structure"`

	// A token that indicates the location of the next major or minor version in
	// the array of major or minor versions of a service template, after the current
	// requested list of service major or minor versions.
	NextToken *string `locationName:"nextToken" type:"string"`

	// An array of major or minor versions of a service template with detail data.
	//
	// TemplateVersions is a required field
	TemplateVersions []*ServiceTemplateVersionSummary `locationName:"templateVersions" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListServiceTemplateVersionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListServiceTemplateVersionsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListServiceTemplateVersionsOutput) SetNextToken(v string) *ListServiceTemplateVersionsOutput {
	s.NextToken = &v
	return s
}

// SetTemplateVersions sets the TemplateVersions field's value.
func (s *ListServiceTemplateVersionsOutput) SetTemplateVersions(v []*ServiceTemplateVersionSummary) *ListServiceTemplateVersionsOutput {
	s.TemplateVersions = v
	return s
}

type ListServiceTemplatesInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of service templates to list.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// A token that indicates the location of the next service template in the array
	// of service templates, after the list of service templates previously requested.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListServiceTemplatesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListServiceTemplatesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListServiceTemplatesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListServiceTemplatesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListServiceTemplatesInput) SetMaxResults(v int64) *ListServiceTemplatesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListServiceTemplatesInput) SetNextToken(v string) *ListServiceTemplatesInput {
	s.NextToken = &v
	return s
}

type ListServiceTemplatesOutput struct {
	_ struct{} `type:"structure"`

	// A token that indicates the location of the next service template in the array
	// of service templates, after the current requested list of service templates.
	NextToken *string `locationName:"nextToken" type:"string"`

	// An array of service templates with detail data.
	//
	// Templates is a required field
	Templates []*ServiceTemplateSummary `locationName:"templates" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListServiceTemplatesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListServiceTemplatesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListServiceTemplatesOutput) SetNextToken(v string) *ListServiceTemplatesOutput {
	s.NextToken = &v
	return s
}

// SetTemplates sets the Templates field's value.
func (s *ListServiceTemplatesOutput) SetTemplates(v []*ServiceTemplateSummary) *ListServiceTemplatesOutput {
	s.Templates = v
	return s
}

type ListServicesInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of services to list.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// A token that indicates the location of the next service in the array of services,
	// after the list of services that was previously requested.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListServicesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListServicesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListServicesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListServicesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListServicesInput) SetMaxResults(v int64) *ListServicesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListServicesInput) SetNextToken(v string) *ListServicesInput {
	s.NextToken = &v
	return s
}

type ListServicesOutput struct {
	_ struct{} `type:"structure"`

	// A token that indicates the location of the next service in the array of services,
	// after the current requested list of services.
	NextToken *string `locationName:"nextToken" type:"string"`

	// An array of services with summaries of detail data.
	//
	// Services is a required field
	Services []*ServiceSummary `locationName:"services" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListServicesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListServicesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListServicesOutput) SetNextToken(v string) *ListServicesOutput {
	s.NextToken = &v
	return s
}

// SetServices sets the Services field's value.
func (s *ListServicesOutput) SetServices(v []*ServiceSummary) *ListServicesOutput {
	s.Services = v
	return s
}

type ListTagsForResourceInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of tags to list.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// A token that indicates the location of the next resource tag in the array
	// of resource tags, after the list of resource tags that was previously requested.
	NextToken *string `locationName:"nextToken" type:"string"`

	// The Amazon Resource Name (ARN) of the resource for the listed tags.
	//
	// ResourceArn is a required field
	ResourceArn *string `locationName:"resourceArn" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsForResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTagsForResourceInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListTagsForResourceInput) SetMaxResults(v int64) *ListTagsForResourceInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListTagsForResourceInput) SetNextToken(v string) *ListTagsForResourceInput {
	s.NextToken = &v
	return s
}

// SetResourceArn sets the ResourceArn field's value.
func (s *ListTagsForResourceInput) SetResourceArn(v string) *ListTagsForResourceInput {
	s.ResourceArn = &v
	return s
}

type ListTagsForResourceOutput struct {
	_ struct{} `type:"structure"`

	// A token that indicates the location of the next resource tag in the array
	// of resource tags, after the current requested list of resource tags.
	NextToken *string `locationName:"nextToken" type:"string"`

	// A list of resource tags with detail data.
	//
	// Tags is a required field
	Tags []*Tag `locationName:"tags" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListTagsForResourceOutput) SetNextToken(v string) *ListTagsForResourceOutput {
	s.NextToken = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *ListTagsForResourceOutput) SetTags(v []*Tag) *ListTagsForResourceOutput {
	s.Tags = v
	return s
}

type NotifyResourceDeploymentStatusChangeInput struct {
	_ struct{} `type:"structure"`

	// The deployment ID for your provisioned resource.
	DeploymentId *string `locationName:"deploymentId" type:"string"`

	// The provisioned resource state change detail data that's returned by Proton.
	Outputs []*Output_ `locationName:"outputs" type:"list" sensitive:"true"`

	// The provisioned resource Amazon Resource Name (ARN).
	//
	// ResourceArn is a required field
	ResourceArn *string `locationName:"resourceArn" min:"1" type:"string" required:"true"`

	// The status of your provisioned resource.
	Status *string `locationName:"status" type:"string" enum:"ResourceDeploymentStatus"`

	// The deployment status message for your provisioned resource.
	//
	// StatusMessage is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by NotifyResourceDeploymentStatusChangeInput's
	// String and GoString methods.
	StatusMessage *string `locationName:"statusMessage" type:"string" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NotifyResourceDeploymentStatusChangeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NotifyResourceDeploymentStatusChangeInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *NotifyResourceDeploymentStatusChangeInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "NotifyResourceDeploymentStatusChangeInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}
	if s.Outputs != nil {
		for i, v := range s.Outputs {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Outputs", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDeploymentId sets the DeploymentId field's value.
func (s *NotifyResourceDeploymentStatusChangeInput) SetDeploymentId(v string) *NotifyResourceDeploymentStatusChangeInput {
	s.DeploymentId = &v
	return s
}

// SetOutputs sets the Outputs field's value.
func (s *NotifyResourceDeploymentStatusChangeInput) SetOutputs(v []*Output_) *NotifyResourceDeploymentStatusChangeInput {
	s.Outputs = v
	return s
}

// SetResourceArn sets the ResourceArn field's value.
func (s *NotifyResourceDeploymentStatusChangeInput) SetResourceArn(v string) *NotifyResourceDeploymentStatusChangeInput {
	s.ResourceArn = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *NotifyResourceDeploymentStatusChangeInput) SetStatus(v string) *NotifyResourceDeploymentStatusChangeInput {
	s.Status = &v
	return s
}

// SetStatusMessage sets the StatusMessage field's value.
func (s *NotifyResourceDeploymentStatusChangeInput) SetStatusMessage(v string) *NotifyResourceDeploymentStatusChangeInput {
	s.StatusMessage = &v
	return s
}

type NotifyResourceDeploymentStatusChangeOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NotifyResourceDeploymentStatusChangeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NotifyResourceDeploymentStatusChangeOutput) GoString() string {
	return s.String()
}

// An infrastructure as code defined resource output.
type Output_ struct {
	_ struct{} `type:"structure" sensitive:"true"`

	// The output key.
	Key *string `locationName:"key" min:"1" type:"string"`

	// The output value.
	ValueString *string `locationName:"valueString" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Output_) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Output_) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Output_) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Output_"}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}
	if s.ValueString != nil && len(*s.ValueString) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ValueString", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKey sets the Key field's value.
func (s *Output_) SetKey(v string) *Output_ {
	s.Key = &v
	return s
}

// SetValueString sets the ValueString field's value.
func (s *Output_) SetValueString(v string) *Output_ {
	s.ValueString = &v
	return s
}

// Detail data for a provisioned resource.
type ProvisionedResource struct {
	_ struct{} `type:"structure"`

	// The provisioned resource identifier.
	Identifier *string `locationName:"identifier" min:"1" type:"string"`

	// The provisioned resource name.
	Name *string `locationName:"name" min:"1" type:"string"`

	// The resource provisioning engine. At this time, CLOUDFORMATION can be used
	// for Amazon Web Services-managed provisioning, and TERRAFORM can be used for
	// self-managed provisioning.
	//
	// For more information, see Self-managed provisioning (https://docs.aws.amazon.com/proton/latest/userguide/ag-works-prov-methods.html#ag-works-prov-methods-self)
	// in the Proton User Guide.
	ProvisioningEngine *string `locationName:"provisioningEngine" type:"string" enum:"ProvisionedResourceEngine"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ProvisionedResource) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ProvisionedResource) GoString() string {
	return s.String()
}

// SetIdentifier sets the Identifier field's value.
func (s *ProvisionedResource) SetIdentifier(v string) *ProvisionedResource {
	s.Identifier = &v
	return s
}

// SetName sets the Name field's value.
func (s *ProvisionedResource) SetName(v string) *ProvisionedResource {
	s.Name = &v
	return s
}

// SetProvisioningEngine sets the ProvisioningEngine field's value.
func (s *ProvisionedResource) SetProvisioningEngine(v string) *ProvisionedResource {
	s.ProvisioningEngine = &v
	return s
}

type RejectEnvironmentAccountConnectionInput struct {
	_ struct{} `type:"structure"`

	// The ID of the environment account connection to reject.
	//
	// Id is a required field
	Id *string `locationName:"id" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RejectEnvironmentAccountConnectionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RejectEnvironmentAccountConnectionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RejectEnvironmentAccountConnectionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RejectEnvironmentAccountConnectionInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *RejectEnvironmentAccountConnectionInput) SetId(v string) *RejectEnvironmentAccountConnectionInput {
	s.Id = &v
	return s
}

type RejectEnvironmentAccountConnectionOutput struct {
	_ struct{} `type:"structure"`

	// The environment connection account detail data that's returned by Proton.
	//
	// EnvironmentAccountConnection is a required field
	EnvironmentAccountConnection *EnvironmentAccountConnection `locationName:"environmentAccountConnection" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RejectEnvironmentAccountConnectionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RejectEnvironmentAccountConnectionOutput) GoString() string {
	return s.String()
}

// SetEnvironmentAccountConnection sets the EnvironmentAccountConnection field's value.
func (s *RejectEnvironmentAccountConnectionOutput) SetEnvironmentAccountConnection(v *EnvironmentAccountConnection) *RejectEnvironmentAccountConnectionOutput {
	s.EnvironmentAccountConnection = v
	return s
}

// Detailed data of a linked repository—a repository that has been registered
// with Proton.
type Repository struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the linked repository.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of your AWS CodeStar connection that connects
	// Proton to your repository provider account.
	//
	// ConnectionArn is a required field
	ConnectionArn *string `locationName:"connectionArn" min:"1" type:"string" required:"true"`

	// Your customer Amazon Web Services KMS encryption key.
	EncryptionKey *string `locationName:"encryptionKey" min:"1" type:"string"`

	// The repository name.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// The repository provider.
	//
	// Provider is a required field
	Provider *string `locationName:"provider" type:"string" required:"true" enum:"RepositoryProvider"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Repository) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Repository) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *Repository) SetArn(v string) *Repository {
	s.Arn = &v
	return s
}

// SetConnectionArn sets the ConnectionArn field's value.
func (s *Repository) SetConnectionArn(v string) *Repository {
	s.ConnectionArn = &v
	return s
}

// SetEncryptionKey sets the EncryptionKey field's value.
func (s *Repository) SetEncryptionKey(v string) *Repository {
	s.EncryptionKey = &v
	return s
}

// SetName sets the Name field's value.
func (s *Repository) SetName(v string) *Repository {
	s.Name = &v
	return s
}

// SetProvider sets the Provider field's value.
func (s *Repository) SetProvider(v string) *Repository {
	s.Provider = &v
	return s
}

// Detail data for a linked repository branch.
type RepositoryBranch struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the linked repository.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" type:"string" required:"true"`

	// The repository branch.
	//
	// Branch is a required field
	Branch *string `locationName:"branch" min:"1" type:"string" required:"true"`

	// The repository name.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// The repository provider.
	//
	// Provider is a required field
	Provider *string `locationName:"provider" type:"string" required:"true" enum:"RepositoryProvider"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RepositoryBranch) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RepositoryBranch) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *RepositoryBranch) SetArn(v string) *RepositoryBranch {
	s.Arn = &v
	return s
}

// SetBranch sets the Branch field's value.
func (s *RepositoryBranch) SetBranch(v string) *RepositoryBranch {
	s.Branch = &v
	return s
}

// SetName sets the Name field's value.
func (s *RepositoryBranch) SetName(v string) *RepositoryBranch {
	s.Name = &v
	return s
}

// SetProvider sets the Provider field's value.
func (s *RepositoryBranch) SetProvider(v string) *RepositoryBranch {
	s.Provider = &v
	return s
}

// Detail input data for a linked repository branch.
type RepositoryBranchInput_ struct {
	_ struct{} `type:"structure"`

	// The repository branch.
	//
	// Branch is a required field
	Branch *string `locationName:"branch" min:"1" type:"string" required:"true"`

	// The repository name.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// The repository provider.
	//
	// Provider is a required field
	Provider *string `locationName:"provider" type:"string" required:"true" enum:"RepositoryProvider"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RepositoryBranchInput_) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RepositoryBranchInput_) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RepositoryBranchInput_) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RepositoryBranchInput_"}
	if s.Branch == nil {
		invalidParams.Add(request.NewErrParamRequired("Branch"))
	}
	if s.Branch != nil && len(*s.Branch) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Branch", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Provider == nil {
		invalidParams.Add(request.NewErrParamRequired("Provider"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBranch sets the Branch field's value.
func (s *RepositoryBranchInput_) SetBranch(v string) *RepositoryBranchInput_ {
	s.Branch = &v
	return s
}

// SetName sets the Name field's value.
func (s *RepositoryBranchInput_) SetName(v string) *RepositoryBranchInput_ {
	s.Name = &v
	return s
}

// SetProvider sets the Provider field's value.
func (s *RepositoryBranchInput_) SetProvider(v string) *RepositoryBranchInput_ {
	s.Provider = &v
	return s
}

// Summary data of a linked repository—a repository that has been registered
// with Proton.
type RepositorySummary struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the linked repository.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the of your connection that connects Proton
	// to your repository.
	//
	// ConnectionArn is a required field
	ConnectionArn *string `locationName:"connectionArn" min:"1" type:"string" required:"true"`

	// The repository name.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// The repository provider.
	//
	// Provider is a required field
	Provider *string `locationName:"provider" type:"string" required:"true" enum:"RepositoryProvider"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RepositorySummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RepositorySummary) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *RepositorySummary) SetArn(v string) *RepositorySummary {
	s.Arn = &v
	return s
}

// SetConnectionArn sets the ConnectionArn field's value.
func (s *RepositorySummary) SetConnectionArn(v string) *RepositorySummary {
	s.ConnectionArn = &v
	return s
}

// SetName sets the Name field's value.
func (s *RepositorySummary) SetName(v string) *RepositorySummary {
	s.Name = &v
	return s
}

// SetProvider sets the Provider field's value.
func (s *RepositorySummary) SetProvider(v string) *RepositorySummary {
	s.Provider = &v
	return s
}

// Detail data for a repository sync attempt activated by a push to a repository.
type RepositorySyncAttempt struct {
	_ struct{} `type:"structure"`

	// Detail data for sync attempt events.
	//
	// Events is a required field
	Events []*RepositorySyncEvent `locationName:"events" type:"list" required:"true"`

	// The time when the sync attempt started.
	//
	// StartedAt is a required field
	StartedAt *time.Time `locationName:"startedAt" type:"timestamp" required:"true"`

	// The sync attempt status.
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true" enum:"RepositorySyncStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RepositorySyncAttempt) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RepositorySyncAttempt) GoString() string {
	return s.String()
}

// SetEvents sets the Events field's value.
func (s *RepositorySyncAttempt) SetEvents(v []*RepositorySyncEvent) *RepositorySyncAttempt {
	s.Events = v
	return s
}

// SetStartedAt sets the StartedAt field's value.
func (s *RepositorySyncAttempt) SetStartedAt(v time.Time) *RepositorySyncAttempt {
	s.StartedAt = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *RepositorySyncAttempt) SetStatus(v string) *RepositorySyncAttempt {
	s.Status = &v
	return s
}

// A repository sync definition.
type RepositorySyncDefinition struct {
	_ struct{} `type:"structure"`

	// The repository branch.
	//
	// Branch is a required field
	Branch *string `locationName:"branch" min:"1" type:"string" required:"true"`

	// The directory in the repository.
	//
	// Directory is a required field
	Directory *string `locationName:"directory" type:"string" required:"true"`

	// The resource that is synced from.
	//
	// Parent is a required field
	Parent *string `locationName:"parent" type:"string" required:"true"`

	// The resource that is synced to.
	//
	// Target is a required field
	Target *string `locationName:"target" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RepositorySyncDefinition) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RepositorySyncDefinition) GoString() string {
	return s.String()
}

// SetBranch sets the Branch field's value.
func (s *RepositorySyncDefinition) SetBranch(v string) *RepositorySyncDefinition {
	s.Branch = &v
	return s
}

// SetDirectory sets the Directory field's value.
func (s *RepositorySyncDefinition) SetDirectory(v string) *RepositorySyncDefinition {
	s.Directory = &v
	return s
}

// SetParent sets the Parent field's value.
func (s *RepositorySyncDefinition) SetParent(v string) *RepositorySyncDefinition {
	s.Parent = &v
	return s
}

// SetTarget sets the Target field's value.
func (s *RepositorySyncDefinition) SetTarget(v string) *RepositorySyncDefinition {
	s.Target = &v
	return s
}

// Repository sync event detail data for a sync attempt.
type RepositorySyncEvent struct {
	_ struct{} `type:"structure"`

	// Event detail for a repository sync attempt.
	//
	// Event is a required field
	Event *string `locationName:"event" type:"string" required:"true"`

	// The external ID of the sync event.
	ExternalId *string `locationName:"externalId" type:"string"`

	// The time that the sync event occurred.
	//
	// Time is a required field
	Time *time.Time `locationName:"time" type:"timestamp" required:"true"`

	// The type of event.
	//
	// Type is a required field
	Type *string `locationName:"type" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RepositorySyncEvent) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RepositorySyncEvent) GoString() string {
	return s.String()
}

// SetEvent sets the Event field's value.
func (s *RepositorySyncEvent) SetEvent(v string) *RepositorySyncEvent {
	s.Event = &v
	return s
}

// SetExternalId sets the ExternalId field's value.
func (s *RepositorySyncEvent) SetExternalId(v string) *RepositorySyncEvent {
	s.ExternalId = &v
	return s
}

// SetTime sets the Time field's value.
func (s *RepositorySyncEvent) SetTime(v time.Time) *RepositorySyncEvent {
	s.Time = &v
	return s
}

// SetType sets the Type field's value.
func (s *RepositorySyncEvent) SetType(v string) *RepositorySyncEvent {
	s.Type = &v
	return s
}

// Summary counts of each Proton resource types.
type ResourceCountsSummary struct {
	_ struct{} `type:"structure"`

	// The number of resources of this type in the Amazon Web Services account that
	// need a major template version update.
	BehindMajor *int64 `locationName:"behindMajor" type:"integer"`

	// The number of resources of this type in the Amazon Web Services account that
	// need a minor template version update.
	BehindMinor *int64 `locationName:"behindMinor" type:"integer"`

	// The number of resources of this type in the Amazon Web Services account that
	// failed to deploy.
	Failed *int64 `locationName:"failed" type:"integer"`

	// The total number of resources of this type in the Amazon Web Services account.
	//
	// Total is a required field
	Total *int64 `locationName:"total" type:"integer" required:"true"`

	// The number of resources of this type in the Amazon Web Services account that
	// are up-to-date with their template.
	UpToDate *int64 `locationName:"upToDate" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceCountsSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceCountsSummary) GoString() string {
	return s.String()
}

// SetBehindMajor sets the BehindMajor field's value.
func (s *ResourceCountsSummary) SetBehindMajor(v int64) *ResourceCountsSummary {
	s.BehindMajor = &v
	return s
}

// SetBehindMinor sets the BehindMinor field's value.
func (s *ResourceCountsSummary) SetBehindMinor(v int64) *ResourceCountsSummary {
	s.BehindMinor = &v
	return s
}

// SetFailed sets the Failed field's value.
func (s *ResourceCountsSummary) SetFailed(v int64) *ResourceCountsSummary {
	s.Failed = &v
	return s
}

// SetTotal sets the Total field's value.
func (s *ResourceCountsSummary) SetTotal(v int64) *ResourceCountsSummary {
	s.Total = &v
	return s
}

// SetUpToDate sets the UpToDate field's value.
func (s *ResourceCountsSummary) SetUpToDate(v int64) *ResourceCountsSummary {
	s.UpToDate = &v
	return s
}

// The requested resource wasn't found.
type ResourceNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// Message_ is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by ResourceNotFoundException's
	// String and GoString methods.
	Message_ *string `locationName:"message" type:"string" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) GoString() string {
	return s.String()
}

func newErrorResourceNotFoundException(v protocol.ResponseMetadata) error {
	return &ResourceNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceNotFoundException) Code() string {
	return "ResourceNotFoundException"
}

// Message returns the exception's message.
func (s *ResourceNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceNotFoundException) OrigErr() error {
	return nil
}

func (s *ResourceNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Detail data for a resource sync attempt activated by a push to a repository.
type ResourceSyncAttempt struct {
	_ struct{} `type:"structure"`

	// An array of events with detail data.
	//
	// Events is a required field
	Events []*ResourceSyncEvent `locationName:"events" type:"list" required:"true"`

	// Detail data for the initial repository commit, path and push.
	//
	// InitialRevision is a required field
	InitialRevision *Revision `locationName:"initialRevision" type:"structure" required:"true"`

	// The time when the sync attempt started.
	//
	// StartedAt is a required field
	StartedAt *time.Time `locationName:"startedAt" type:"timestamp" required:"true"`

	// The status of the sync attempt.
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true" enum:"ResourceSyncStatus"`

	// The resource that is synced to.
	//
	// Target is a required field
	Target *string `locationName:"target" type:"string" required:"true"`

	// Detail data for the target revision.
	//
	// TargetRevision is a required field
	TargetRevision *Revision `locationName:"targetRevision" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceSyncAttempt) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceSyncAttempt) GoString() string {
	return s.String()
}

// SetEvents sets the Events field's value.
func (s *ResourceSyncAttempt) SetEvents(v []*ResourceSyncEvent) *ResourceSyncAttempt {
	s.Events = v
	return s
}

// SetInitialRevision sets the InitialRevision field's value.
func (s *ResourceSyncAttempt) SetInitialRevision(v *Revision) *ResourceSyncAttempt {
	s.InitialRevision = v
	return s
}

// SetStartedAt sets the StartedAt field's value.
func (s *ResourceSyncAttempt) SetStartedAt(v time.Time) *ResourceSyncAttempt {
	s.StartedAt = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ResourceSyncAttempt) SetStatus(v string) *ResourceSyncAttempt {
	s.Status = &v
	return s
}

// SetTarget sets the Target field's value.
func (s *ResourceSyncAttempt) SetTarget(v string) *ResourceSyncAttempt {
	s.Target = &v
	return s
}

// SetTargetRevision sets the TargetRevision field's value.
func (s *ResourceSyncAttempt) SetTargetRevision(v *Revision) *ResourceSyncAttempt {
	s.TargetRevision = v
	return s
}

// Detail data for a resource sync event.
type ResourceSyncEvent struct {
	_ struct{} `type:"structure"`

	// A resource sync event.
	//
	// Event is a required field
	Event *string `locationName:"event" type:"string" required:"true"`

	// The external ID for the event.
	ExternalId *string `locationName:"externalId" type:"string"`

	// The time when the event occurred.
	//
	// Time is a required field
	Time *time.Time `locationName:"time" type:"timestamp" required:"true"`

	// The type of event.
	//
	// Type is a required field
	Type *string `locationName:"type" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceSyncEvent) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceSyncEvent) GoString() string {
	return s.String()
}

// SetEvent sets the Event field's value.
func (s *ResourceSyncEvent) SetEvent(v string) *ResourceSyncEvent {
	s.Event = &v
	return s
}

// SetExternalId sets the ExternalId field's value.
func (s *ResourceSyncEvent) SetExternalId(v string) *ResourceSyncEvent {
	s.ExternalId = &v
	return s
}

// SetTime sets the Time field's value.
func (s *ResourceSyncEvent) SetTime(v time.Time) *ResourceSyncEvent {
	s.Time = &v
	return s
}

// SetType sets the Type field's value.
func (s *ResourceSyncEvent) SetType(v string) *ResourceSyncEvent {
	s.Type = &v
	return s
}

// Revision detail data for a commit and push that activates a sync attempt
type Revision struct {
	_ struct{} `type:"structure"`

	// The repository branch.
	//
	// Branch is a required field
	Branch *string `locationName:"branch" min:"1" type:"string" required:"true"`

	// The repository directory changed by a commit and push that activated the
	// sync attempt.
	//
	// Directory is a required field
	Directory *string `locationName:"directory" type:"string" required:"true"`

	// The repository name.
	//
	// RepositoryName is a required field
	RepositoryName *string `locationName:"repositoryName" min:"1" type:"string" required:"true"`

	// The repository provider.
	//
	// RepositoryProvider is a required field
	RepositoryProvider *string `locationName:"repositoryProvider" type:"string" required:"true" enum:"RepositoryProvider"`

	// The secure hash algorithm (SHA) hash for the revision.
	//
	// Sha is a required field
	Sha *string `locationName:"sha" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Revision) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Revision) GoString() string {
	return s.String()
}

// SetBranch sets the Branch field's value.
func (s *Revision) SetBranch(v string) *Revision {
	s.Branch = &v
	return s
}

// SetDirectory sets the Directory field's value.
func (s *Revision) SetDirectory(v string) *Revision {
	s.Directory = &v
	return s
}

// SetRepositoryName sets the RepositoryName field's value.
func (s *Revision) SetRepositoryName(v string) *Revision {
	s.RepositoryName = &v
	return s
}

// SetRepositoryProvider sets the RepositoryProvider field's value.
func (s *Revision) SetRepositoryProvider(v string) *Revision {
	s.RepositoryProvider = &v
	return s
}

// SetSha sets the Sha field's value.
func (s *Revision) SetSha(v string) *Revision {
	s.Sha = &v
	return s
}

// Template bundle S3 bucket data.
type S3ObjectSource struct {
	_ struct{} `type:"structure"`

	// The name of the S3 bucket that contains a template bundle.
	//
	// Bucket is a required field
	Bucket *string `locationName:"bucket" min:"3" type:"string" required:"true"`

	// The path to the S3 bucket that contains a template bundle.
	//
	// Key is a required field
	Key *string `locationName:"key" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s S3ObjectSource) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s S3ObjectSource) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *S3ObjectSource) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "S3ObjectSource"}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}
	if s.Bucket != nil && len(*s.Bucket) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("Bucket", 3))
	}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucket sets the Bucket field's value.
func (s *S3ObjectSource) SetBucket(v string) *S3ObjectSource {
	s.Bucket = &v
	return s
}

// SetKey sets the Key field's value.
func (s *S3ObjectSource) SetKey(v string) *S3ObjectSource {
	s.Key = &v
	return s
}

// Detailed data of an Proton service resource.
type Service struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the service.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" type:"string" required:"true"`

	// The name of the code repository branch that holds the code that's deployed
	// in Proton.
	BranchName *string `locationName:"branchName" min:"1" type:"string"`

	// The time when the service was created.
	//
	// CreatedAt is a required field
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" required:"true"`

	// A description of the service.
	//
	// Description is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by Service's
	// String and GoString methods.
	Description *string `locationName:"description" type:"string" sensitive:"true"`

	// The time when the service was last modified.
	//
	// LastModifiedAt is a required field
	LastModifiedAt *time.Time `locationName:"lastModifiedAt" type:"timestamp" required:"true"`

	// The name of the service.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// The service pipeline detail data.
	Pipeline *ServicePipeline `locationName:"pipeline" type:"structure"`

	// The Amazon Resource Name (ARN) of the repository connection. For more information,
	// see Setting up an AWS CodeStar connection (https://docs.aws.amazon.com/proton/latest/userguide/setting-up-for-service.html#setting-up-vcontrol)
	// in the Proton User Guide.
	RepositoryConnectionArn *string `locationName:"repositoryConnectionArn" min:"1" type:"string"`

	// The ID of the source code repository.
	RepositoryId *string `locationName:"repositoryId" min:"1" type:"string"`

	// The formatted specification that defines the service.
	//
	// Spec is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by Service's
	// String and GoString methods.
	//
	// Spec is a required field
	Spec *string `locationName:"spec" min:"1" type:"string" required:"true" sensitive:"true"`

	// The status of the service.
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true" enum:"ServiceStatus"`

	// A service status message.
	//
	// StatusMessage is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by Service's
	// String and GoString methods.
	StatusMessage *string `locationName:"statusMessage" type:"string" sensitive:"true"`

	// The name of the service template.
	//
	// TemplateName is a required field
	TemplateName *string `locationName:"templateName" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Service) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Service) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *Service) SetArn(v string) *Service {
	s.Arn = &v
	return s
}

// SetBranchName sets the BranchName field's value.
func (s *Service) SetBranchName(v string) *Service {
	s.BranchName = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *Service) SetCreatedAt(v time.Time) *Service {
	s.CreatedAt = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *Service) SetDescription(v string) *Service {
	s.Description = &v
	return s
}

// SetLastModifiedAt sets the LastModifiedAt field's value.
func (s *Service) SetLastModifiedAt(v time.Time) *Service {
	s.LastModifiedAt = &v
	return s
}

// SetName sets the Name field's value.
func (s *Service) SetName(v string) *Service {
	s.Name = &v
	return s
}

// SetPipeline sets the Pipeline field's value.
func (s *Service) SetPipeline(v *ServicePipeline) *Service {
	s.Pipeline = v
	return s
}

// SetRepositoryConnectionArn sets the RepositoryConnectionArn field's value.
func (s *Service) SetRepositoryConnectionArn(v string) *Service {
	s.RepositoryConnectionArn = &v
	return s
}

// SetRepositoryId sets the RepositoryId field's value.
func (s *Service) SetRepositoryId(v string) *Service {
	s.RepositoryId = &v
	return s
}

// SetSpec sets the Spec field's value.
func (s *Service) SetSpec(v string) *Service {
	s.Spec = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *Service) SetStatus(v string) *Service {
	s.Status = &v
	return s
}

// SetStatusMessage sets the StatusMessage field's value.
func (s *Service) SetStatusMessage(v string) *Service {
	s.StatusMessage = &v
	return s
}

// SetTemplateName sets the TemplateName field's value.
func (s *Service) SetTemplateName(v string) *Service {
	s.TemplateName = &v
	return s
}

// Detailed data of an Proton service instance resource.
type ServiceInstance struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the service instance.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" type:"string" required:"true"`

	// The time when the service instance was created.
	//
	// CreatedAt is a required field
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" required:"true"`

	// The service instance deployment status.
	//
	// DeploymentStatus is a required field
	DeploymentStatus *string `locationName:"deploymentStatus" type:"string" required:"true" enum:"DeploymentStatus"`

	// The message associated with the service instance deployment status.
	//
	// DeploymentStatusMessage is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by ServiceInstance's
	// String and GoString methods.
	DeploymentStatusMessage *string `locationName:"deploymentStatusMessage" type:"string" sensitive:"true"`

	// The name of the environment that the service instance was deployed into.
	//
	// EnvironmentName is a required field
	EnvironmentName *string `locationName:"environmentName" min:"1" type:"string" required:"true"`

	// The ID of the last attempted deployment of this service instance.
	LastAttemptedDeploymentId *string `locationName:"lastAttemptedDeploymentId" type:"string"`

	// The last client request token received.
	LastClientRequestToken *string `locationName:"lastClientRequestToken" type:"string"`

	// The time when a deployment of the service instance was last attempted.
	//
	// LastDeploymentAttemptedAt is a required field
	LastDeploymentAttemptedAt *time.Time `locationName:"lastDeploymentAttemptedAt" type:"timestamp" required:"true"`

	// The time when the service instance was last deployed successfully.
	//
	// LastDeploymentSucceededAt is a required field
	LastDeploymentSucceededAt *time.Time `locationName:"lastDeploymentSucceededAt" type:"timestamp" required:"true"`

	// The ID of the last successful deployment of this service instance.
	LastSucceededDeploymentId *string `locationName:"lastSucceededDeploymentId" type:"string"`

	// The name of the service instance.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// The name of the service that the service instance belongs to.
	//
	// ServiceName is a required field
	ServiceName *string `locationName:"serviceName" min:"1" type:"string" required:"true"`

	// The service spec that was used to create the service instance.
	//
	// Spec is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by ServiceInstance's
	// String and GoString methods.
	Spec *string `locationName:"spec" min:"1" type:"string" sensitive:"true"`

	// The major version of the service template that was used to create the service
	// instance.
	//
	// TemplateMajorVersion is a required field
	TemplateMajorVersion *string `locationName:"templateMajorVersion" min:"1" type:"string" required:"true"`

	// The minor version of the service template that was used to create the service
	// instance.
	//
	// TemplateMinorVersion is a required field
	TemplateMinorVersion *string `locationName:"templateMinorVersion" min:"1" type:"string" required:"true"`

	// The name of the service template that was used to create the service instance.
	//
	// TemplateName is a required field
	TemplateName *string `locationName:"templateName" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceInstance) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceInstance) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *ServiceInstance) SetArn(v string) *ServiceInstance {
	s.Arn = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *ServiceInstance) SetCreatedAt(v time.Time) *ServiceInstance {
	s.CreatedAt = &v
	return s
}

// SetDeploymentStatus sets the DeploymentStatus field's value.
func (s *ServiceInstance) SetDeploymentStatus(v string) *ServiceInstance {
	s.DeploymentStatus = &v
	return s
}

// SetDeploymentStatusMessage sets the DeploymentStatusMessage field's value.
func (s *ServiceInstance) SetDeploymentStatusMessage(v string) *ServiceInstance {
	s.DeploymentStatusMessage = &v
	return s
}

// SetEnvironmentName sets the EnvironmentName field's value.
func (s *ServiceInstance) SetEnvironmentName(v string) *ServiceInstance {
	s.EnvironmentName = &v
	return s
}

// SetLastAttemptedDeploymentId sets the LastAttemptedDeploymentId field's value.
func (s *ServiceInstance) SetLastAttemptedDeploymentId(v string) *ServiceInstance {
	s.LastAttemptedDeploymentId = &v
	return s
}

// SetLastClientRequestToken sets the LastClientRequestToken field's value.
func (s *ServiceInstance) SetLastClientRequestToken(v string) *ServiceInstance {
	s.LastClientRequestToken = &v
	return s
}

// SetLastDeploymentAttemptedAt sets the LastDeploymentAttemptedAt field's value.
func (s *ServiceInstance) SetLastDeploymentAttemptedAt(v time.Time) *ServiceInstance {
	s.LastDeploymentAttemptedAt = &v
	return s
}

// SetLastDeploymentSucceededAt sets the LastDeploymentSucceededAt field's value.
func (s *ServiceInstance) SetLastDeploymentSucceededAt(v time.Time) *ServiceInstance {
	s.LastDeploymentSucceededAt = &v
	return s
}

// SetLastSucceededDeploymentId sets the LastSucceededDeploymentId field's value.
func (s *ServiceInstance) SetLastSucceededDeploymentId(v string) *ServiceInstance {
	s.LastSucceededDeploymentId = &v
	return s
}

// SetName sets the Name field's value.
func (s *ServiceInstance) SetName(v string) *ServiceInstance {
	s.Name = &v
	return s
}

// SetServiceName sets the ServiceName field's value.
func (s *ServiceInstance) SetServiceName(v string) *ServiceInstance {
	s.ServiceName = &v
	return s
}

// SetSpec sets the Spec field's value.
func (s *ServiceInstance) SetSpec(v string) *ServiceInstance {
	s.Spec = &v
	return s
}

// SetTemplateMajorVersion sets the TemplateMajorVersion field's value.
func (s *ServiceInstance) SetTemplateMajorVersion(v string) *ServiceInstance {
	s.TemplateMajorVersion = &v
	return s
}

// SetTemplateMinorVersion sets the TemplateMinorVersion field's value.
func (s *ServiceInstance) SetTemplateMinorVersion(v string) *ServiceInstance {
	s.TemplateMinorVersion = &v
	return s
}

// SetTemplateName sets the TemplateName field's value.
func (s *ServiceInstance) SetTemplateName(v string) *ServiceInstance {
	s.TemplateName = &v
	return s
}

// The detailed data about the current state of this service instance.
type ServiceInstanceState struct {
	_ struct{} `type:"structure"`

	// The IDs for the last successful components deployed for this service instance.
	LastSuccessfulComponentDeploymentIds []*string `locationName:"lastSuccessfulComponentDeploymentIds" type:"list"`

	// The ID for the last successful environment deployed for this service instance.
	LastSuccessfulEnvironmentDeploymentId *string `locationName:"lastSuccessfulEnvironmentDeploymentId" type:"string"`

	// The ID for the last successful service pipeline deployed for this service
	// instance.
	LastSuccessfulServicePipelineDeploymentId *string `locationName:"lastSuccessfulServicePipelineDeploymentId" type:"string"`

	// The service spec that was used to create the service instance.
	//
	// Spec is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by ServiceInstanceState's
	// String and GoString methods.
	//
	// Spec is a required field
	Spec *string `locationName:"spec" min:"1" type:"string" required:"true" sensitive:"true"`

	// The major version of the service template that was used to create the service
	// pipeline.
	//
	// TemplateMajorVersion is a required field
	TemplateMajorVersion *string `locationName:"templateMajorVersion" min:"1" type:"string" required:"true"`

	// The minor version of the service template that was used to create the service
	// pipeline.
	//
	// TemplateMinorVersion is a required field
	TemplateMinorVersion *string `locationName:"templateMinorVersion" min:"1" type:"string" required:"true"`

	// The name of the service template that was used to create the service instance.
	//
	// TemplateName is a required field
	TemplateName *string `locationName:"templateName" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceInstanceState) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceInstanceState) GoString() string {
	return s.String()
}

// SetLastSuccessfulComponentDeploymentIds sets the LastSuccessfulComponentDeploymentIds field's value.
func (s *ServiceInstanceState) SetLastSuccessfulComponentDeploymentIds(v []*string) *ServiceInstanceState {
	s.LastSuccessfulComponentDeploymentIds = v
	return s
}

// SetLastSuccessfulEnvironmentDeploymentId sets the LastSuccessfulEnvironmentDeploymentId field's value.
func (s *ServiceInstanceState) SetLastSuccessfulEnvironmentDeploymentId(v string) *ServiceInstanceState {
	s.LastSuccessfulEnvironmentDeploymentId = &v
	return s
}

// SetLastSuccessfulServicePipelineDeploymentId sets the LastSuccessfulServicePipelineDeploymentId field's value.
func (s *ServiceInstanceState) SetLastSuccessfulServicePipelineDeploymentId(v string) *ServiceInstanceState {
	s.LastSuccessfulServicePipelineDeploymentId = &v
	return s
}

// SetSpec sets the Spec field's value.
func (s *ServiceInstanceState) SetSpec(v string) *ServiceInstanceState {
	s.Spec = &v
	return s
}

// SetTemplateMajorVersion sets the TemplateMajorVersion field's value.
func (s *ServiceInstanceState) SetTemplateMajorVersion(v string) *ServiceInstanceState {
	s.TemplateMajorVersion = &v
	return s
}

// SetTemplateMinorVersion sets the TemplateMinorVersion field's value.
func (s *ServiceInstanceState) SetTemplateMinorVersion(v string) *ServiceInstanceState {
	s.TemplateMinorVersion = &v
	return s
}

// SetTemplateName sets the TemplateName field's value.
func (s *ServiceInstanceState) SetTemplateName(v string) *ServiceInstanceState {
	s.TemplateName = &v
	return s
}

// Summary data of an Proton service instance resource.
type ServiceInstanceSummary struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the service instance.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" type:"string" required:"true"`

	// The time when the service instance was created.
	//
	// CreatedAt is a required field
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" required:"true"`

	// The service instance deployment status.
	//
	// DeploymentStatus is a required field
	DeploymentStatus *string `locationName:"deploymentStatus" type:"string" required:"true" enum:"DeploymentStatus"`

	// A service instance deployment status message.
	//
	// DeploymentStatusMessage is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by ServiceInstanceSummary's
	// String and GoString methods.
	DeploymentStatusMessage *string `locationName:"deploymentStatusMessage" type:"string" sensitive:"true"`

	// The name of the environment that the service instance was deployed into.
	//
	// EnvironmentName is a required field
	EnvironmentName *string `locationName:"environmentName" min:"1" type:"string" required:"true"`

	// The ID of the last attempted deployment of this service instance.
	LastAttemptedDeploymentId *string `locationName:"lastAttemptedDeploymentId" type:"string"`

	// The time when a deployment of the service was last attempted.
	//
	// LastDeploymentAttemptedAt is a required field
	LastDeploymentAttemptedAt *time.Time `locationName:"lastDeploymentAttemptedAt" type:"timestamp" required:"true"`

	// The time when the service was last deployed successfully.
	//
	// LastDeploymentSucceededAt is a required field
	LastDeploymentSucceededAt *time.Time `locationName:"lastDeploymentSucceededAt" type:"timestamp" required:"true"`

	// The ID of the last successful deployment of this service instance.
	LastSucceededDeploymentId *string `locationName:"lastSucceededDeploymentId" type:"string"`

	// The name of the service instance.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// The name of the service that the service instance belongs to.
	//
	// ServiceName is a required field
	ServiceName *string `locationName:"serviceName" min:"1" type:"string" required:"true"`

	// The service instance template major version.
	//
	// TemplateMajorVersion is a required field
	TemplateMajorVersion *string `locationName:"templateMajorVersion" min:"1" type:"string" required:"true"`

	// The service instance template minor version.
	//
	// TemplateMinorVersion is a required field
	TemplateMinorVersion *string `locationName:"templateMinorVersion" min:"1" type:"string" required:"true"`

	// The name of the service template.
	//
	// TemplateName is a required field
	TemplateName *string `locationName:"templateName" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceInstanceSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceInstanceSummary) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *ServiceInstanceSummary) SetArn(v string) *ServiceInstanceSummary {
	s.Arn = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *ServiceInstanceSummary) SetCreatedAt(v time.Time) *ServiceInstanceSummary {
	s.CreatedAt = &v
	return s
}

// SetDeploymentStatus sets the DeploymentStatus field's value.
func (s *ServiceInstanceSummary) SetDeploymentStatus(v string) *ServiceInstanceSummary {
	s.DeploymentStatus = &v
	return s
}

// SetDeploymentStatusMessage sets the DeploymentStatusMessage field's value.
func (s *ServiceInstanceSummary) SetDeploymentStatusMessage(v string) *ServiceInstanceSummary {
	s.DeploymentStatusMessage = &v
	return s
}

// SetEnvironmentName sets the EnvironmentName field's value.
func (s *ServiceInstanceSummary) SetEnvironmentName(v string) *ServiceInstanceSummary {
	s.EnvironmentName = &v
	return s
}

// SetLastAttemptedDeploymentId sets the LastAttemptedDeploymentId field's value.
func (s *ServiceInstanceSummary) SetLastAttemptedDeploymentId(v string) *ServiceInstanceSummary {
	s.LastAttemptedDeploymentId = &v
	return s
}

// SetLastDeploymentAttemptedAt sets the LastDeploymentAttemptedAt field's value.
func (s *ServiceInstanceSummary) SetLastDeploymentAttemptedAt(v time.Time) *ServiceInstanceSummary {
	s.LastDeploymentAttemptedAt = &v
	return s
}

// SetLastDeploymentSucceededAt sets the LastDeploymentSucceededAt field's value.
func (s *ServiceInstanceSummary) SetLastDeploymentSucceededAt(v time.Time) *ServiceInstanceSummary {
	s.LastDeploymentSucceededAt = &v
	return s
}

// SetLastSucceededDeploymentId sets the LastSucceededDeploymentId field's value.
func (s *ServiceInstanceSummary) SetLastSucceededDeploymentId(v string) *ServiceInstanceSummary {
	s.LastSucceededDeploymentId = &v
	return s
}

// SetName sets the Name field's value.
func (s *ServiceInstanceSummary) SetName(v string) *ServiceInstanceSummary {
	s.Name = &v
	return s
}

// SetServiceName sets the ServiceName field's value.
func (s *ServiceInstanceSummary) SetServiceName(v string) *ServiceInstanceSummary {
	s.ServiceName = &v
	return s
}

// SetTemplateMajorVersion sets the TemplateMajorVersion field's value.
func (s *ServiceInstanceSummary) SetTemplateMajorVersion(v string) *ServiceInstanceSummary {
	s.TemplateMajorVersion = &v
	return s
}

// SetTemplateMinorVersion sets the TemplateMinorVersion field's value.
func (s *ServiceInstanceSummary) SetTemplateMinorVersion(v string) *ServiceInstanceSummary {
	s.TemplateMinorVersion = &v
	return s
}

// SetTemplateName sets the TemplateName field's value.
func (s *ServiceInstanceSummary) SetTemplateName(v string) *ServiceInstanceSummary {
	s.TemplateName = &v
	return s
}

// Detailed data of an Proton service instance pipeline resource.
type ServicePipeline struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the service pipeline.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" min:"1" type:"string" required:"true"`

	// The time when the service pipeline was created.
	//
	// CreatedAt is a required field
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" required:"true"`

	// The deployment status of the service pipeline.
	//
	// DeploymentStatus is a required field
	DeploymentStatus *string `locationName:"deploymentStatus" type:"string" required:"true" enum:"DeploymentStatus"`

	// A service pipeline deployment status message.
	//
	// DeploymentStatusMessage is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by ServicePipeline's
	// String and GoString methods.
	DeploymentStatusMessage *string `locationName:"deploymentStatusMessage" type:"string" sensitive:"true"`

	// The ID of the last attempted deployment of this service pipeline.
	LastAttemptedDeploymentId *string `locationName:"lastAttemptedDeploymentId" type:"string"`

	// The time when a deployment of the service pipeline was last attempted.
	//
	// LastDeploymentAttemptedAt is a required field
	LastDeploymentAttemptedAt *time.Time `locationName:"lastDeploymentAttemptedAt" type:"timestamp" required:"true"`

	// The time when the service pipeline was last deployed successfully.
	//
	// LastDeploymentSucceededAt is a required field
	LastDeploymentSucceededAt *time.Time `locationName:"lastDeploymentSucceededAt" type:"timestamp" required:"true"`

	// The ID of the last successful deployment of this service pipeline.
	LastSucceededDeploymentId *string `locationName:"lastSucceededDeploymentId" type:"string"`

	// The service spec that was used to create the service pipeline.
	//
	// Spec is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by ServicePipeline's
	// String and GoString methods.
	Spec *string `locationName:"spec" min:"1" type:"string" sensitive:"true"`

	// The major version of the service template that was used to create the service
	// pipeline.
	//
	// TemplateMajorVersion is a required field
	TemplateMajorVersion *string `locationName:"templateMajorVersion" min:"1" type:"string" required:"true"`

	// The minor version of the service template that was used to create the service
	// pipeline.
	//
	// TemplateMinorVersion is a required field
	TemplateMinorVersion *string `locationName:"templateMinorVersion" min:"1" type:"string" required:"true"`

	// The name of the service template that was used to create the service pipeline.
	//
	// TemplateName is a required field
	TemplateName *string `locationName:"templateName" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServicePipeline) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServicePipeline) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *ServicePipeline) SetArn(v string) *ServicePipeline {
	s.Arn = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *ServicePipeline) SetCreatedAt(v time.Time) *ServicePipeline {
	s.CreatedAt = &v
	return s
}

// SetDeploymentStatus sets the DeploymentStatus field's value.
func (s *ServicePipeline) SetDeploymentStatus(v string) *ServicePipeline {
	s.DeploymentStatus = &v
	return s
}

// SetDeploymentStatusMessage sets the DeploymentStatusMessage field's value.
func (s *ServicePipeline) SetDeploymentStatusMessage(v string) *ServicePipeline {
	s.DeploymentStatusMessage = &v
	return s
}

// SetLastAttemptedDeploymentId sets the LastAttemptedDeploymentId field's value.
func (s *ServicePipeline) SetLastAttemptedDeploymentId(v string) *ServicePipeline {
	s.LastAttemptedDeploymentId = &v
	return s
}

// SetLastDeploymentAttemptedAt sets the LastDeploymentAttemptedAt field's value.
func (s *ServicePipeline) SetLastDeploymentAttemptedAt(v time.Time) *ServicePipeline {
	s.LastDeploymentAttemptedAt = &v
	return s
}

// SetLastDeploymentSucceededAt sets the LastDeploymentSucceededAt field's value.
func (s *ServicePipeline) SetLastDeploymentSucceededAt(v time.Time) *ServicePipeline {
	s.LastDeploymentSucceededAt = &v
	return s
}

// SetLastSucceededDeploymentId sets the LastSucceededDeploymentId field's value.
func (s *ServicePipeline) SetLastSucceededDeploymentId(v string) *ServicePipeline {
	s.LastSucceededDeploymentId = &v
	return s
}

// SetSpec sets the Spec field's value.
func (s *ServicePipeline) SetSpec(v string) *ServicePipeline {
	s.Spec = &v
	return s
}

// SetTemplateMajorVersion sets the TemplateMajorVersion field's value.
func (s *ServicePipeline) SetTemplateMajorVersion(v string) *ServicePipeline {
	s.TemplateMajorVersion = &v
	return s
}

// SetTemplateMinorVersion sets the TemplateMinorVersion field's value.
func (s *ServicePipeline) SetTemplateMinorVersion(v string) *ServicePipeline {
	s.TemplateMinorVersion = &v
	return s
}

// SetTemplateName sets the TemplateName field's value.
func (s *ServicePipeline) SetTemplateName(v string) *ServicePipeline {
	s.TemplateName = &v
	return s
}

// The detailed data about the current state of the service pipeline.
type ServicePipelineState struct {
	_ struct{} `type:"structure"`

	// The service spec that was used to create the service pipeline.
	//
	// Spec is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by ServicePipelineState's
	// String and GoString methods.
	Spec *string `locationName:"spec" min:"1" type:"string" sensitive:"true"`

	// The major version of the service template that was used to create the service
	// pipeline.
	//
	// TemplateMajorVersion is a required field
	TemplateMajorVersion *string `locationName:"templateMajorVersion" min:"1" type:"string" required:"true"`

	// The minor version of the service template that was used to create the service
	// pipeline.
	//
	// TemplateMinorVersion is a required field
	TemplateMinorVersion *string `locationName:"templateMinorVersion" min:"1" type:"string" required:"true"`

	// The name of the service template that was used to create the service pipeline.
	//
	// TemplateName is a required field
	TemplateName *string `locationName:"templateName" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServicePipelineState) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServicePipelineState) GoString() string {
	return s.String()
}

// SetSpec sets the Spec field's value.
func (s *ServicePipelineState) SetSpec(v string) *ServicePipelineState {
	s.Spec = &v
	return s
}

// SetTemplateMajorVersion sets the TemplateMajorVersion field's value.
func (s *ServicePipelineState) SetTemplateMajorVersion(v string) *ServicePipelineState {
	s.TemplateMajorVersion = &v
	return s
}

// SetTemplateMinorVersion sets the TemplateMinorVersion field's value.
func (s *ServicePipelineState) SetTemplateMinorVersion(v string) *ServicePipelineState {
	s.TemplateMinorVersion = &v
	return s
}

// SetTemplateName sets the TemplateName field's value.
func (s *ServicePipelineState) SetTemplateName(v string) *ServicePipelineState {
	s.TemplateName = &v
	return s
}

// A quota was exceeded. For more information, see Proton Quotas (https://docs.aws.amazon.com/proton/latest/userguide/ag-limits.html)
// in the Proton User Guide.
type ServiceQuotaExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// Message_ is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by ServiceQuotaExceededException's
	// String and GoString methods.
	Message_ *string `locationName:"message" type:"string" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceQuotaExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceQuotaExceededException) GoString() string {
	return s.String()
}

func newErrorServiceQuotaExceededException(v protocol.ResponseMetadata) error {
	return &ServiceQuotaExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ServiceQuotaExceededException) Code() string {
	return "ServiceQuotaExceededException"
}

// Message returns the exception's message.
func (s *ServiceQuotaExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ServiceQuotaExceededException) OrigErr() error {
	return nil
}

func (s *ServiceQuotaExceededException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ServiceQuotaExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ServiceQuotaExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Summary data of an Proton service resource.
type ServiceSummary struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the service.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" type:"string" required:"true"`

	// The time when the service was created.
	//
	// CreatedAt is a required field
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" required:"true"`

	// A description of the service.
	//
	// Description is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by ServiceSummary's
	// String and GoString methods.
	Description *string `locationName:"description" type:"string" sensitive:"true"`

	// The time when the service was last modified.
	//
	// LastModifiedAt is a required field
	LastModifiedAt *time.Time `locationName:"lastModifiedAt" type:"timestamp" required:"true"`

	// The name of the service.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// The status of the service.
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true" enum:"ServiceStatus"`

	// A service status message.
	//
	// StatusMessage is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by ServiceSummary's
	// String and GoString methods.
	StatusMessage *string `locationName:"statusMessage" type:"string" sensitive:"true"`

	// The name of the service template.
	//
	// TemplateName is a required field
	TemplateName *string `locationName:"templateName" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceSummary) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *ServiceSummary) SetArn(v string) *ServiceSummary {
	s.Arn = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *ServiceSummary) SetCreatedAt(v time.Time) *ServiceSummary {
	s.CreatedAt = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *ServiceSummary) SetDescription(v string) *ServiceSummary {
	s.Description = &v
	return s
}

// SetLastModifiedAt sets the LastModifiedAt field's value.
func (s *ServiceSummary) SetLastModifiedAt(v time.Time) *ServiceSummary {
	s.LastModifiedAt = &v
	return s
}

// SetName sets the Name field's value.
func (s *ServiceSummary) SetName(v string) *ServiceSummary {
	s.Name = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ServiceSummary) SetStatus(v string) *ServiceSummary {
	s.Status = &v
	return s
}

// SetStatusMessage sets the StatusMessage field's value.
func (s *ServiceSummary) SetStatusMessage(v string) *ServiceSummary {
	s.StatusMessage = &v
	return s
}

// SetTemplateName sets the TemplateName field's value.
func (s *ServiceSummary) SetTemplateName(v string) *ServiceSummary {
	s.TemplateName = &v
	return s
}

// If a service instance is manually updated, Proton wants to prevent accidentally
// overriding a manual change.
//
// A blocker is created because of the manual update or deletion of a service
// instance. The summary describes the blocker as being active or resolved.
type ServiceSyncBlockerSummary struct {
	_ struct{} `type:"structure"`

	// The latest active blockers for the synced service.
	LatestBlockers []*SyncBlocker `locationName:"latestBlockers" type:"list"`

	// The name of the service instance that you want sync your service configuration
	// with.
	ServiceInstanceName *string `locationName:"serviceInstanceName" type:"string"`

	// The name of the service that you want to get the sync blocker summary for.
	// If given a service instance name and a service name, it will return the blockers
	// only applying to the instance that is blocked.
	//
	// If given only a service name, it will return the blockers that apply to all
	// of the instances. In order to get the blockers for a single instance, you
	// will need to make two distinct calls, one to get the sync blocker summary
	// for the service and the other to get the sync blocker for the service instance.
	//
	// ServiceName is a required field
	ServiceName *string `locationName:"serviceName" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceSyncBlockerSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceSyncBlockerSummary) GoString() string {
	return s.String()
}

// SetLatestBlockers sets the LatestBlockers field's value.
func (s *ServiceSyncBlockerSummary) SetLatestBlockers(v []*SyncBlocker) *ServiceSyncBlockerSummary {
	s.LatestBlockers = v
	return s
}

// SetServiceInstanceName sets the ServiceInstanceName field's value.
func (s *ServiceSyncBlockerSummary) SetServiceInstanceName(v string) *ServiceSyncBlockerSummary {
	s.ServiceInstanceName = &v
	return s
}

// SetServiceName sets the ServiceName field's value.
func (s *ServiceSyncBlockerSummary) SetServiceName(v string) *ServiceSyncBlockerSummary {
	s.ServiceName = &v
	return s
}

// Detailed data of the service sync configuration.
type ServiceSyncConfig struct {
	_ struct{} `type:"structure"`

	// The name of the code repository branch that holds the service code Proton
	// will sync with.
	//
	// Branch is a required field
	Branch *string `locationName:"branch" min:"1" type:"string" required:"true"`

	// The file path to the service sync configuration file.
	//
	// FilePath is a required field
	FilePath *string `locationName:"filePath" min:"1" type:"string" required:"true"`

	// The name of the code repository that holds the service code Proton will sync
	// with.
	//
	// RepositoryName is a required field
	RepositoryName *string `locationName:"repositoryName" min:"1" type:"string" required:"true"`

	// The name of the repository provider that holds the repository Proton will
	// sync with.
	//
	// RepositoryProvider is a required field
	RepositoryProvider *string `locationName:"repositoryProvider" type:"string" required:"true" enum:"RepositoryProvider"`

	// The name of the service that the service instance is added to.
	//
	// ServiceName is a required field
	ServiceName *string `locationName:"serviceName" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceSyncConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceSyncConfig) GoString() string {
	return s.String()
}

// SetBranch sets the Branch field's value.
func (s *ServiceSyncConfig) SetBranch(v string) *ServiceSyncConfig {
	s.Branch = &v
	return s
}

// SetFilePath sets the FilePath field's value.
func (s *ServiceSyncConfig) SetFilePath(v string) *ServiceSyncConfig {
	s.FilePath = &v
	return s
}

// SetRepositoryName sets the RepositoryName field's value.
func (s *ServiceSyncConfig) SetRepositoryName(v string) *ServiceSyncConfig {
	s.RepositoryName = &v
	return s
}

// SetRepositoryProvider sets the RepositoryProvider field's value.
func (s *ServiceSyncConfig) SetRepositoryProvider(v string) *ServiceSyncConfig {
	s.RepositoryProvider = &v
	return s
}

// SetServiceName sets the ServiceName field's value.
func (s *ServiceSyncConfig) SetServiceName(v string) *ServiceSyncConfig {
	s.ServiceName = &v
	return s
}

// Detailed data of an Proton service template resource.
type ServiceTemplate struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the service template.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" type:"string" required:"true"`

	// The time when the service template was created.
	//
	// CreatedAt is a required field
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" required:"true"`

	// A description of the service template.
	//
	// Description is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by ServiceTemplate's
	// String and GoString methods.
	Description *string `locationName:"description" type:"string" sensitive:"true"`

	// The service template name as displayed in the developer interface.
	//
	// DisplayName is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by ServiceTemplate's
	// String and GoString methods.
	DisplayName *string `locationName:"displayName" min:"1" type:"string" sensitive:"true"`

	// The customer provided service template encryption key that's used to encrypt
	// data.
	EncryptionKey *string `locationName:"encryptionKey" min:"1" type:"string"`

	// The time when the service template was last modified.
	//
	// LastModifiedAt is a required field
	LastModifiedAt *time.Time `locationName:"lastModifiedAt" type:"timestamp" required:"true"`

	// The name of the service template.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// If pipelineProvisioning is true, a service pipeline is included in the service
	// template. Otherwise, a service pipeline isn't included in the service template.
	PipelineProvisioning *string `locationName:"pipelineProvisioning" type:"string" enum:"Provisioning"`

	// The recommended version of the service template.
	RecommendedVersion *string `locationName:"recommendedVersion" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceTemplate) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceTemplate) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *ServiceTemplate) SetArn(v string) *ServiceTemplate {
	s.Arn = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *ServiceTemplate) SetCreatedAt(v time.Time) *ServiceTemplate {
	s.CreatedAt = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *ServiceTemplate) SetDescription(v string) *ServiceTemplate {
	s.Description = &v
	return s
}

// SetDisplayName sets the DisplayName field's value.
func (s *ServiceTemplate) SetDisplayName(v string) *ServiceTemplate {
	s.DisplayName = &v
	return s
}

// SetEncryptionKey sets the EncryptionKey field's value.
func (s *ServiceTemplate) SetEncryptionKey(v string) *ServiceTemplate {
	s.EncryptionKey = &v
	return s
}

// SetLastModifiedAt sets the LastModifiedAt field's value.
func (s *ServiceTemplate) SetLastModifiedAt(v time.Time) *ServiceTemplate {
	s.LastModifiedAt = &v
	return s
}

// SetName sets the Name field's value.
func (s *ServiceTemplate) SetName(v string) *ServiceTemplate {
	s.Name = &v
	return s
}

// SetPipelineProvisioning sets the PipelineProvisioning field's value.
func (s *ServiceTemplate) SetPipelineProvisioning(v string) *ServiceTemplate {
	s.PipelineProvisioning = &v
	return s
}

// SetRecommendedVersion sets the RecommendedVersion field's value.
func (s *ServiceTemplate) SetRecommendedVersion(v string) *ServiceTemplate {
	s.RecommendedVersion = &v
	return s
}

// Summary data of an Proton service template resource.
type ServiceTemplateSummary struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the service template.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" type:"string" required:"true"`

	// The time when the service template was created.
	//
	// CreatedAt is a required field
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" required:"true"`

	// A description of the service template.
	//
	// Description is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by ServiceTemplateSummary's
	// String and GoString methods.
	Description *string `locationName:"description" type:"string" sensitive:"true"`

	// The service template name as displayed in the developer interface.
	//
	// DisplayName is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by ServiceTemplateSummary's
	// String and GoString methods.
	DisplayName *string `locationName:"displayName" min:"1" type:"string" sensitive:"true"`

	// The time when the service template was last modified.
	//
	// LastModifiedAt is a required field
	LastModifiedAt *time.Time `locationName:"lastModifiedAt" type:"timestamp" required:"true"`

	// The name of the service template.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// If pipelineProvisioning is true, a service pipeline is included in the service
	// template, otherwise a service pipeline isn't included in the service template.
	PipelineProvisioning *string `locationName:"pipelineProvisioning" type:"string" enum:"Provisioning"`

	// The recommended version of the service template.
	RecommendedVersion *string `locationName:"recommendedVersion" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceTemplateSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceTemplateSummary) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *ServiceTemplateSummary) SetArn(v string) *ServiceTemplateSummary {
	s.Arn = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *ServiceTemplateSummary) SetCreatedAt(v time.Time) *ServiceTemplateSummary {
	s.CreatedAt = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *ServiceTemplateSummary) SetDescription(v string) *ServiceTemplateSummary {
	s.Description = &v
	return s
}

// SetDisplayName sets the DisplayName field's value.
func (s *ServiceTemplateSummary) SetDisplayName(v string) *ServiceTemplateSummary {
	s.DisplayName = &v
	return s
}

// SetLastModifiedAt sets the LastModifiedAt field's value.
func (s *ServiceTemplateSummary) SetLastModifiedAt(v time.Time) *ServiceTemplateSummary {
	s.LastModifiedAt = &v
	return s
}

// SetName sets the Name field's value.
func (s *ServiceTemplateSummary) SetName(v string) *ServiceTemplateSummary {
	s.Name = &v
	return s
}

// SetPipelineProvisioning sets the PipelineProvisioning field's value.
func (s *ServiceTemplateSummary) SetPipelineProvisioning(v string) *ServiceTemplateSummary {
	s.PipelineProvisioning = &v
	return s
}

// SetRecommendedVersion sets the RecommendedVersion field's value.
func (s *ServiceTemplateSummary) SetRecommendedVersion(v string) *ServiceTemplateSummary {
	s.RecommendedVersion = &v
	return s
}

// Detailed data of an Proton service template version resource.
type ServiceTemplateVersion struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the version of a service template.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" type:"string" required:"true"`

	// An array of compatible environment template names for the major version of
	// a service template.
	//
	// CompatibleEnvironmentTemplates is a required field
	CompatibleEnvironmentTemplates []*CompatibleEnvironmentTemplate `locationName:"compatibleEnvironmentTemplates" type:"list" required:"true"`

	// The time when the version of a service template was created.
	//
	// CreatedAt is a required field
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" required:"true"`

	// A description of the version of a service template.
	//
	// Description is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by ServiceTemplateVersion's
	// String and GoString methods.
	Description *string `locationName:"description" type:"string" sensitive:"true"`

	// The time when the version of a service template was last modified.
	//
	// LastModifiedAt is a required field
	LastModifiedAt *time.Time `locationName:"lastModifiedAt" type:"timestamp" required:"true"`

	// The latest major version that's associated with the version of a service
	// template.
	//
	// MajorVersion is a required field
	MajorVersion *string `locationName:"majorVersion" min:"1" type:"string" required:"true"`

	// The minor version of a service template.
	//
	// MinorVersion is a required field
	MinorVersion *string `locationName:"minorVersion" min:"1" type:"string" required:"true"`

	// The recommended minor version of the service template.
	RecommendedMinorVersion *string `locationName:"recommendedMinorVersion" min:"1" type:"string"`

	// The schema of the version of a service template.
	//
	// Schema is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by ServiceTemplateVersion's
	// String and GoString methods.
	Schema *string `locationName:"schema" min:"1" type:"string" sensitive:"true"`

	// The service template version status.
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true" enum:"TemplateVersionStatus"`

	// A service template version status message.
	//
	// StatusMessage is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by ServiceTemplateVersion's
	// String and GoString methods.
	StatusMessage *string `locationName:"statusMessage" type:"string" sensitive:"true"`

	// An array of supported component sources. Components with supported sources
	// can be attached to service instances based on this service template version.
	//
	// For more information about components, see Proton components (https://docs.aws.amazon.com/proton/latest/userguide/ag-components.html)
	// in the Proton User Guide.
	SupportedComponentSources []*string `locationName:"supportedComponentSources" type:"list" enum:"ServiceTemplateSupportedComponentSourceType"`

	// The name of the version of a service template.
	//
	// TemplateName is a required field
	TemplateName *string `locationName:"templateName" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceTemplateVersion) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceTemplateVersion) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *ServiceTemplateVersion) SetArn(v string) *ServiceTemplateVersion {
	s.Arn = &v
	return s
}

// SetCompatibleEnvironmentTemplates sets the CompatibleEnvironmentTemplates field's value.
func (s *ServiceTemplateVersion) SetCompatibleEnvironmentTemplates(v []*CompatibleEnvironmentTemplate) *ServiceTemplateVersion {
	s.CompatibleEnvironmentTemplates = v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *ServiceTemplateVersion) SetCreatedAt(v time.Time) *ServiceTemplateVersion {
	s.CreatedAt = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *ServiceTemplateVersion) SetDescription(v string) *ServiceTemplateVersion {
	s.Description = &v
	return s
}

// SetLastModifiedAt sets the LastModifiedAt field's value.
func (s *ServiceTemplateVersion) SetLastModifiedAt(v time.Time) *ServiceTemplateVersion {
	s.LastModifiedAt = &v
	return s
}

// SetMajorVersion sets the MajorVersion field's value.
func (s *ServiceTemplateVersion) SetMajorVersion(v string) *ServiceTemplateVersion {
	s.MajorVersion = &v
	return s
}

// SetMinorVersion sets the MinorVersion field's value.
func (s *ServiceTemplateVersion) SetMinorVersion(v string) *ServiceTemplateVersion {
	s.MinorVersion = &v
	return s
}

// SetRecommendedMinorVersion sets the RecommendedMinorVersion field's value.
func (s *ServiceTemplateVersion) SetRecommendedMinorVersion(v string) *ServiceTemplateVersion {
	s.RecommendedMinorVersion = &v
	return s
}

// SetSchema sets the Schema field's value.
func (s *ServiceTemplateVersion) SetSchema(v string) *ServiceTemplateVersion {
	s.Schema = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ServiceTemplateVersion) SetStatus(v string) *ServiceTemplateVersion {
	s.Status = &v
	return s
}

// SetStatusMessage sets the StatusMessage field's value.
func (s *ServiceTemplateVersion) SetStatusMessage(v string) *ServiceTemplateVersion {
	s.StatusMessage = &v
	return s
}

// SetSupportedComponentSources sets the SupportedComponentSources field's value.
func (s *ServiceTemplateVersion) SetSupportedComponentSources(v []*string) *ServiceTemplateVersion {
	s.SupportedComponentSources = v
	return s
}

// SetTemplateName sets the TemplateName field's value.
func (s *ServiceTemplateVersion) SetTemplateName(v string) *ServiceTemplateVersion {
	s.TemplateName = &v
	return s
}

// Summary data of an Proton service template version resource.
type ServiceTemplateVersionSummary struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the version of a service template.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" type:"string" required:"true"`

	// The time when the version of a service template was created.
	//
	// CreatedAt is a required field
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" required:"true"`

	// A description of the version of a service template.
	//
	// Description is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by ServiceTemplateVersionSummary's
	// String and GoString methods.
	Description *string `locationName:"description" type:"string" sensitive:"true"`

	// The time when the version of a service template was last modified.
	//
	// LastModifiedAt is a required field
	LastModifiedAt *time.Time `locationName:"lastModifiedAt" type:"timestamp" required:"true"`

	// The latest major version that's associated with the version of a service
	// template.
	//
	// MajorVersion is a required field
	MajorVersion *string `locationName:"majorVersion" min:"1" type:"string" required:"true"`

	// The minor version of a service template.
	//
	// MinorVersion is a required field
	MinorVersion *string `locationName:"minorVersion" min:"1" type:"string" required:"true"`

	// The recommended minor version of the service template.
	RecommendedMinorVersion *string `locationName:"recommendedMinorVersion" min:"1" type:"string"`

	// The service template minor version status.
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true" enum:"TemplateVersionStatus"`

	// A service template minor version status message.
	//
	// StatusMessage is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by ServiceTemplateVersionSummary's
	// String and GoString methods.
	StatusMessage *string `locationName:"statusMessage" type:"string" sensitive:"true"`

	// The name of the service template.
	//
	// TemplateName is a required field
	TemplateName *string `locationName:"templateName" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceTemplateVersionSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceTemplateVersionSummary) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *ServiceTemplateVersionSummary) SetArn(v string) *ServiceTemplateVersionSummary {
	s.Arn = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *ServiceTemplateVersionSummary) SetCreatedAt(v time.Time) *ServiceTemplateVersionSummary {
	s.CreatedAt = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *ServiceTemplateVersionSummary) SetDescription(v string) *ServiceTemplateVersionSummary {
	s.Description = &v
	return s
}

// SetLastModifiedAt sets the LastModifiedAt field's value.
func (s *ServiceTemplateVersionSummary) SetLastModifiedAt(v time.Time) *ServiceTemplateVersionSummary {
	s.LastModifiedAt = &v
	return s
}

// SetMajorVersion sets the MajorVersion field's value.
func (s *ServiceTemplateVersionSummary) SetMajorVersion(v string) *ServiceTemplateVersionSummary {
	s.MajorVersion = &v
	return s
}

// SetMinorVersion sets the MinorVersion field's value.
func (s *ServiceTemplateVersionSummary) SetMinorVersion(v string) *ServiceTemplateVersionSummary {
	s.MinorVersion = &v
	return s
}

// SetRecommendedMinorVersion sets the RecommendedMinorVersion field's value.
func (s *ServiceTemplateVersionSummary) SetRecommendedMinorVersion(v string) *ServiceTemplateVersionSummary {
	s.RecommendedMinorVersion = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ServiceTemplateVersionSummary) SetStatus(v string) *ServiceTemplateVersionSummary {
	s.Status = &v
	return s
}

// SetStatusMessage sets the StatusMessage field's value.
func (s *ServiceTemplateVersionSummary) SetStatusMessage(v string) *ServiceTemplateVersionSummary {
	s.StatusMessage = &v
	return s
}

// SetTemplateName sets the TemplateName field's value.
func (s *ServiceTemplateVersionSummary) SetTemplateName(v string) *ServiceTemplateVersionSummary {
	s.TemplateName = &v
	return s
}

// Detailed data of the sync blocker.
type SyncBlocker struct {
	_ struct{} `type:"structure"`

	// The contexts for the sync blocker.
	Contexts []*SyncBlockerContext `locationName:"contexts" type:"list"`

	// The time when the sync blocker was created.
	//
	// CreatedAt is a required field
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" required:"true"`

	// The reason why the sync blocker was created.
	//
	// CreatedReason is a required field
	CreatedReason *string `locationName:"createdReason" type:"string" required:"true"`

	// The ID of the sync blocker.
	//
	// Id is a required field
	Id *string `locationName:"id" type:"string" required:"true"`

	// The time the sync blocker was resolved.
	ResolvedAt *time.Time `locationName:"resolvedAt" type:"timestamp"`

	// The reason the sync blocker was resolved.
	ResolvedReason *string `locationName:"resolvedReason" type:"string"`

	// The status of the sync blocker.
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true" enum:"BlockerStatus"`

	// The type of the sync blocker.
	//
	// Type is a required field
	Type *string `locationName:"type" type:"string" required:"true" enum:"BlockerType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SyncBlocker) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SyncBlocker) GoString() string {
	return s.String()
}

// SetContexts sets the Contexts field's value.
func (s *SyncBlocker) SetContexts(v []*SyncBlockerContext) *SyncBlocker {
	s.Contexts = v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *SyncBlocker) SetCreatedAt(v time.Time) *SyncBlocker {
	s.CreatedAt = &v
	return s
}

// SetCreatedReason sets the CreatedReason field's value.
func (s *SyncBlocker) SetCreatedReason(v string) *SyncBlocker {
	s.CreatedReason = &v
	return s
}

// SetId sets the Id field's value.
func (s *SyncBlocker) SetId(v string) *SyncBlocker {
	s.Id = &v
	return s
}

// SetResolvedAt sets the ResolvedAt field's value.
func (s *SyncBlocker) SetResolvedAt(v time.Time) *SyncBlocker {
	s.ResolvedAt = &v
	return s
}

// SetResolvedReason sets the ResolvedReason field's value.
func (s *SyncBlocker) SetResolvedReason(v string) *SyncBlocker {
	s.ResolvedReason = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *SyncBlocker) SetStatus(v string) *SyncBlocker {
	s.Status = &v
	return s
}

// SetType sets the Type field's value.
func (s *SyncBlocker) SetType(v string) *SyncBlocker {
	s.Type = &v
	return s
}

// Detailed data of the context of the sync blocker.
type SyncBlockerContext struct {
	_ struct{} `type:"structure"`

	// The key for the sync blocker context.
	//
	// Key is a required field
	Key *string `locationName:"key" type:"string" required:"true"`

	// The value of the sync blocker context.
	//
	// Value is a required field
	Value *string `locationName:"value" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SyncBlockerContext) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SyncBlockerContext) GoString() string {
	return s.String()
}

// SetKey sets the Key field's value.
func (s *SyncBlockerContext) SetKey(v string) *SyncBlockerContext {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *SyncBlockerContext) SetValue(v string) *SyncBlockerContext {
	s.Value = &v
	return s
}

// A description of a resource tag.
type Tag struct {
	_ struct{} `type:"structure"`

	// The key of the resource tag.
	//
	// Key is a required field
	Key *string `locationName:"key" min:"1" type:"string" required:"true"`

	// The value of the resource tag.
	//
	// Value is a required field
	Value *string `locationName:"value" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Tag) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Tag) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Tag) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Tag"}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}
	if s.Value == nil {
		invalidParams.Add(request.NewErrParamRequired("Value"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKey sets the Key field's value.
func (s *Tag) SetKey(v string) *Tag {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *Tag) SetValue(v string) *Tag {
	s.Value = &v
	return s
}

type TagResourceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the Proton resource to apply customer tags
	// to.
	//
	// ResourceArn is a required field
	ResourceArn *string `locationName:"resourceArn" min:"1" type:"string" required:"true"`

	// A list of customer tags to apply to the Proton resource.
	//
	// Tags is a required field
	Tags []*Tag `locationName:"tags" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *TagResourceInput) SetResourceArn(v string) *TagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *TagResourceInput) SetTags(v []*Tag) *TagResourceInput {
	s.Tags = v
	return s
}

type TagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) GoString() string {
	return s.String()
}

// The detail data for a template sync configuration.
type TemplateSyncConfig struct {
	_ struct{} `type:"structure"`

	// The repository branch.
	//
	// Branch is a required field
	Branch *string `locationName:"branch" min:"1" type:"string" required:"true"`

	// The repository name (for example, myrepos/myrepo).
	//
	// RepositoryName is a required field
	RepositoryName *string `locationName:"repositoryName" min:"1" type:"string" required:"true"`

	// The repository provider.
	//
	// RepositoryProvider is a required field
	RepositoryProvider *string `locationName:"repositoryProvider" type:"string" required:"true" enum:"RepositoryProvider"`

	// A subdirectory path to your template bundle version.
	Subdirectory *string `locationName:"subdirectory" min:"1" type:"string"`

	// The template name.
	//
	// TemplateName is a required field
	TemplateName *string `locationName:"templateName" min:"1" type:"string" required:"true"`

	// The template type.
	//
	// TemplateType is a required field
	TemplateType *string `locationName:"templateType" type:"string" required:"true" enum:"TemplateType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TemplateSyncConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TemplateSyncConfig) GoString() string {
	return s.String()
}

// SetBranch sets the Branch field's value.
func (s *TemplateSyncConfig) SetBranch(v string) *TemplateSyncConfig {
	s.Branch = &v
	return s
}

// SetRepositoryName sets the RepositoryName field's value.
func (s *TemplateSyncConfig) SetRepositoryName(v string) *TemplateSyncConfig {
	s.RepositoryName = &v
	return s
}

// SetRepositoryProvider sets the RepositoryProvider field's value.
func (s *TemplateSyncConfig) SetRepositoryProvider(v string) *TemplateSyncConfig {
	s.RepositoryProvider = &v
	return s
}

// SetSubdirectory sets the Subdirectory field's value.
func (s *TemplateSyncConfig) SetSubdirectory(v string) *TemplateSyncConfig {
	s.Subdirectory = &v
	return s
}

// SetTemplateName sets the TemplateName field's value.
func (s *TemplateSyncConfig) SetTemplateName(v string) *TemplateSyncConfig {
	s.TemplateName = &v
	return s
}

// SetTemplateType sets the TemplateType field's value.
func (s *TemplateSyncConfig) SetTemplateType(v string) *TemplateSyncConfig {
	s.TemplateType = &v
	return s
}

// Template version source data.
type TemplateVersionSourceInput struct {
	_ struct{} `type:"structure"`

	// An S3 source object that includes the template bundle S3 path and name for
	// a template minor version.
	S3 *S3ObjectSource `locationName:"s3" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TemplateVersionSourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TemplateVersionSourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TemplateVersionSourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TemplateVersionSourceInput"}
	if s.S3 != nil {
		if err := s.S3.Validate(); err != nil {
			invalidParams.AddNested("S3", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetS3 sets the S3 field's value.
func (s *TemplateVersionSourceInput) SetS3(v *S3ObjectSource) *TemplateVersionSourceInput {
	s.S3 = v
	return s
}

// The request was denied due to request throttling.
type ThrottlingException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// Message_ is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by ThrottlingException's
	// String and GoString methods.
	Message_ *string `locationName:"message" type:"string" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThrottlingException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThrottlingException) GoString() string {
	return s.String()
}

func newErrorThrottlingException(v protocol.ResponseMetadata) error {
	return &ThrottlingException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ThrottlingException) Code() string {
	return "ThrottlingException"
}

// Message returns the exception's message.
func (s *ThrottlingException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ThrottlingException) OrigErr() error {
	return nil
}

func (s *ThrottlingException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ThrottlingException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ThrottlingException) RequestID() string {
	return s.RespMetadata.RequestID
}

type UntagResourceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the resource to remove customer tags from.
	//
	// ResourceArn is a required field
	ResourceArn *string `locationName:"resourceArn" min:"1" type:"string" required:"true"`

	// A list of customer tag keys that indicate the customer tags to be removed
	// from the resource.
	//
	// TagKeys is a required field
	TagKeys []*string `locationName:"tagKeys" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UntagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UntagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}
	if s.TagKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKeys"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *UntagResourceInput) SetResourceArn(v string) *UntagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *UntagResourceInput) SetTagKeys(v []*string) *UntagResourceInput {
	s.TagKeys = v
	return s
}

type UntagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) GoString() string {
	return s.String()
}

type UpdateAccountSettingsInput struct {
	_ struct{} `type:"structure"`

	// Set to true to remove a configured pipeline repository from the account settings.
	// Don't set this field if you are updating the configured pipeline repository.
	DeletePipelineProvisioningRepository *bool `locationName:"deletePipelineProvisioningRepository" type:"boolean"`

	// The Amazon Resource Name (ARN) of the service role you want to use for provisioning
	// pipelines. Proton assumes this role for CodeBuild-based provisioning.
	PipelineCodebuildRoleArn *string `locationName:"pipelineCodebuildRoleArn" type:"string"`

	// A linked repository for pipeline provisioning. Specify it if you have environments
	// configured for self-managed provisioning with services that include pipelines.
	// A linked repository is a repository that has been registered with Proton.
	// For more information, see CreateRepository.
	//
	// To remove a previously configured repository, set deletePipelineProvisioningRepository
	// to true, and don't set pipelineProvisioningRepository.
	PipelineProvisioningRepository *RepositoryBranchInput_ `locationName:"pipelineProvisioningRepository" type:"structure"`

	// The Amazon Resource Name (ARN) of the service role you want to use for provisioning
	// pipelines. Assumed by Proton for Amazon Web Services-managed provisioning,
	// and by customer-owned automation for self-managed provisioning.
	//
	// To remove a previously configured ARN, specify an empty string.
	PipelineServiceRoleArn *string `locationName:"pipelineServiceRoleArn" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateAccountSettingsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateAccountSettingsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateAccountSettingsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateAccountSettingsInput"}
	if s.PipelineProvisioningRepository != nil {
		if err := s.PipelineProvisioningRepository.Validate(); err != nil {
			invalidParams.AddNested("PipelineProvisioningRepository", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDeletePipelineProvisioningRepository sets the DeletePipelineProvisioningRepository field's value.
func (s *UpdateAccountSettingsInput) SetDeletePipelineProvisioningRepository(v bool) *UpdateAccountSettingsInput {
	s.DeletePipelineProvisioningRepository = &v
	return s
}

// SetPipelineCodebuildRoleArn sets the PipelineCodebuildRoleArn field's value.
func (s *UpdateAccountSettingsInput) SetPipelineCodebuildRoleArn(v string) *UpdateAccountSettingsInput {
	s.PipelineCodebuildRoleArn = &v
	return s
}

// SetPipelineProvisioningRepository sets the PipelineProvisioningRepository field's value.
func (s *UpdateAccountSettingsInput) SetPipelineProvisioningRepository(v *RepositoryBranchInput_) *UpdateAccountSettingsInput {
	s.PipelineProvisioningRepository = v
	return s
}

// SetPipelineServiceRoleArn sets the PipelineServiceRoleArn field's value.
func (s *UpdateAccountSettingsInput) SetPipelineServiceRoleArn(v string) *UpdateAccountSettingsInput {
	s.PipelineServiceRoleArn = &v
	return s
}

type UpdateAccountSettingsOutput struct {
	_ struct{} `type:"structure"`

	// The Proton pipeline service role and repository data shared across the Amazon
	// Web Services account.
	//
	// AccountSettings is a required field
	AccountSettings *AccountSettings `locationName:"accountSettings" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateAccountSettingsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateAccountSettingsOutput) GoString() string {
	return s.String()
}

// SetAccountSettings sets the AccountSettings field's value.
func (s *UpdateAccountSettingsOutput) SetAccountSettings(v *AccountSettings) *UpdateAccountSettingsOutput {
	s.AccountSettings = v
	return s
}

type UpdateComponentInput struct {
	_ struct{} `type:"structure"`

	// The client token for the updated component.
	ClientToken *string `locationName:"clientToken" type:"string" idempotencyToken:"true"`

	// The deployment type. It defines the mode for updating a component, as follows:
	//
	// NONE
	//
	// In this mode, a deployment doesn't occur. Only the requested metadata parameters
	// are updated. You can only specify description in this mode.
	//
	// CURRENT_VERSION
	//
	// In this mode, the component is deployed and updated with the new serviceSpec,
	// templateSource, and/or type that you provide. Only requested parameters are
	// updated.
	//
	// DeploymentType is a required field
	DeploymentType *string `locationName:"deploymentType" type:"string" required:"true" enum:"ComponentDeploymentUpdateType"`

	// An optional customer-provided description of the component.
	//
	// Description is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by UpdateComponentInput's
	// String and GoString methods.
	Description *string `locationName:"description" type:"string" sensitive:"true"`

	// The name of the component to update.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// The name of the service instance that you want to attach this component to.
	// Don't specify to keep the component's current service instance attachment.
	// Specify an empty string to detach the component from the service instance
	// it's attached to. Specify non-empty values for both serviceInstanceName and
	// serviceName or for neither of them.
	ServiceInstanceName *string `locationName:"serviceInstanceName" type:"string"`

	// The name of the service that serviceInstanceName is associated with. Don't
	// specify to keep the component's current service instance attachment. Specify
	// an empty string to detach the component from the service instance it's attached
	// to. Specify non-empty values for both serviceInstanceName and serviceName
	// or for neither of them.
	ServiceName *string `locationName:"serviceName" type:"string"`

	// The service spec that you want the component to use to access service inputs.
	// Set this only when the component is attached to a service instance.
	//
	// ServiceSpec is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by UpdateComponentInput's
	// String and GoString methods.
	ServiceSpec *string `locationName:"serviceSpec" min:"1" type:"string" sensitive:"true"`

	// A path to the Infrastructure as Code (IaC) file describing infrastructure
	// that a custom component provisions.
	//
	// Components support a single IaC file, even if you use Terraform as your template
	// language.
	//
	// TemplateFile is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by UpdateComponentInput's
	// String and GoString methods.
	TemplateFile *string `locationName:"templateFile" min:"1" type:"string" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateComponentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateComponentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateComponentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateComponentInput"}
	if s.DeploymentType == nil {
		invalidParams.Add(request.NewErrParamRequired("DeploymentType"))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.ServiceSpec != nil && len(*s.ServiceSpec) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ServiceSpec", 1))
	}
	if s.TemplateFile != nil && len(*s.TemplateFile) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TemplateFile", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *UpdateComponentInput) SetClientToken(v string) *UpdateComponentInput {
	s.ClientToken = &v
	return s
}

// SetDeploymentType sets the DeploymentType field's value.
func (s *UpdateComponentInput) SetDeploymentType(v string) *UpdateComponentInput {
	s.DeploymentType = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *UpdateComponentInput) SetDescription(v string) *UpdateComponentInput {
	s.Description = &v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateComponentInput) SetName(v string) *UpdateComponentInput {
	s.Name = &v
	return s
}

// SetServiceInstanceName sets the ServiceInstanceName field's value.
func (s *UpdateComponentInput) SetServiceInstanceName(v string) *UpdateComponentInput {
	s.ServiceInstanceName = &v
	return s
}

// SetServiceName sets the ServiceName field's value.
func (s *UpdateComponentInput) SetServiceName(v string) *UpdateComponentInput {
	s.ServiceName = &v
	return s
}

// SetServiceSpec sets the ServiceSpec field's value.
func (s *UpdateComponentInput) SetServiceSpec(v string) *UpdateComponentInput {
	s.ServiceSpec = &v
	return s
}

// SetTemplateFile sets the TemplateFile field's value.
func (s *UpdateComponentInput) SetTemplateFile(v string) *UpdateComponentInput {
	s.TemplateFile = &v
	return s
}

type UpdateComponentOutput struct {
	_ struct{} `type:"structure"`

	// The detailed data of the updated component.
	//
	// Component is a required field
	Component *Component `locationName:"component" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateComponentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateComponentOutput) GoString() string {
	return s.String()
}

// SetComponent sets the Component field's value.
func (s *UpdateComponentOutput) SetComponent(v *Component) *UpdateComponentOutput {
	s.Component = v
	return s
}

type UpdateEnvironmentAccountConnectionInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of an IAM service role in the environment
	// account. Proton uses this role to provision infrastructure resources using
	// CodeBuild-based provisioning in the associated environment account.
	CodebuildRoleArn *string `locationName:"codebuildRoleArn" min:"1" type:"string"`

	// The Amazon Resource Name (ARN) of the IAM service role that Proton uses when
	// provisioning directly defined components in the associated environment account.
	// It determines the scope of infrastructure that a component can provision
	// in the account.
	//
	// The environment account connection must have a componentRoleArn to allow
	// directly defined components to be associated with any environments running
	// in the account.
	//
	// For more information about components, see Proton components (https://docs.aws.amazon.com/proton/latest/userguide/ag-components.html)
	// in the Proton User Guide.
	ComponentRoleArn *string `locationName:"componentRoleArn" min:"1" type:"string"`

	// The ID of the environment account connection to update.
	//
	// Id is a required field
	Id *string `locationName:"id" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the IAM service role that's associated
	// with the environment account connection to update.
	RoleArn *string `locationName:"roleArn" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateEnvironmentAccountConnectionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateEnvironmentAccountConnectionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateEnvironmentAccountConnectionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateEnvironmentAccountConnectionInput"}
	if s.CodebuildRoleArn != nil && len(*s.CodebuildRoleArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CodebuildRoleArn", 1))
	}
	if s.ComponentRoleArn != nil && len(*s.ComponentRoleArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ComponentRoleArn", 1))
	}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.RoleArn != nil && len(*s.RoleArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RoleArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCodebuildRoleArn sets the CodebuildRoleArn field's value.
func (s *UpdateEnvironmentAccountConnectionInput) SetCodebuildRoleArn(v string) *UpdateEnvironmentAccountConnectionInput {
	s.CodebuildRoleArn = &v
	return s
}

// SetComponentRoleArn sets the ComponentRoleArn field's value.
func (s *UpdateEnvironmentAccountConnectionInput) SetComponentRoleArn(v string) *UpdateEnvironmentAccountConnectionInput {
	s.ComponentRoleArn = &v
	return s
}

// SetId sets the Id field's value.
func (s *UpdateEnvironmentAccountConnectionInput) SetId(v string) *UpdateEnvironmentAccountConnectionInput {
	s.Id = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *UpdateEnvironmentAccountConnectionInput) SetRoleArn(v string) *UpdateEnvironmentAccountConnectionInput {
	s.RoleArn = &v
	return s
}

type UpdateEnvironmentAccountConnectionOutput struct {
	_ struct{} `type:"structure"`

	// The environment account connection detail data that's returned by Proton.
	//
	// EnvironmentAccountConnection is a required field
	EnvironmentAccountConnection *EnvironmentAccountConnection `locationName:"environmentAccountConnection" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateEnvironmentAccountConnectionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateEnvironmentAccountConnectionOutput) GoString() string {
	return s.String()
}

// SetEnvironmentAccountConnection sets the EnvironmentAccountConnection field's value.
func (s *UpdateEnvironmentAccountConnectionOutput) SetEnvironmentAccountConnection(v *EnvironmentAccountConnection) *UpdateEnvironmentAccountConnectionOutput {
	s.EnvironmentAccountConnection = v
	return s
}

type UpdateEnvironmentInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the IAM service role that allows Proton
	// to provision infrastructure using CodeBuild-based provisioning on your behalf.
	CodebuildRoleArn *string `locationName:"codebuildRoleArn" min:"1" type:"string"`

	// The Amazon Resource Name (ARN) of the IAM service role that Proton uses when
	// provisioning directly defined components in this environment. It determines
	// the scope of infrastructure that a component can provision.
	//
	// The environment must have a componentRoleArn to allow directly defined components
	// to be associated with the environment.
	//
	// For more information about components, see Proton components (https://docs.aws.amazon.com/proton/latest/userguide/ag-components.html)
	// in the Proton User Guide.
	ComponentRoleArn *string `locationName:"componentRoleArn" min:"1" type:"string"`

	// There are four modes for updating an environment. The deploymentType field
	// defines the mode.
	//
	// NONE
	//
	// In this mode, a deployment doesn't occur. Only the requested metadata parameters
	// are updated.
	//
	// CURRENT_VERSION
	//
	// In this mode, the environment is deployed and updated with the new spec that
	// you provide. Only requested parameters are updated. Don’t include major
	// or minor version parameters when you use this deployment-type.
	//
	// MINOR_VERSION
	//
	// In this mode, the environment is deployed and updated with the published,
	// recommended (latest) minor version of the current major version in use, by
	// default. You can also specify a different minor version of the current major
	// version in use.
	//
	// MAJOR_VERSION
	//
	// In this mode, the environment is deployed and updated with the published,
	// recommended (latest) major and minor version of the current template, by
	// default. You can also specify a different major version that is higher than
	// the major version in use and a minor version (optional).
	//
	// DeploymentType is a required field
	DeploymentType *string `locationName:"deploymentType" type:"string" required:"true" enum:"DeploymentUpdateType"`

	// A description of the environment update.
	//
	// Description is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by UpdateEnvironmentInput's
	// String and GoString methods.
	Description *string `locationName:"description" type:"string" sensitive:"true"`

	// The ID of the environment account connection.
	//
	// You can only update to a new environment account connection if it was created
	// in the same environment account that the current environment account connection
	// was created in and is associated with the current environment.
	EnvironmentAccountConnectionId *string `locationName:"environmentAccountConnectionId" type:"string"`

	// The name of the environment to update.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the Proton service role that allows Proton
	// to make API calls to other services your behalf.
	ProtonServiceRoleArn *string `locationName:"protonServiceRoleArn" min:"1" type:"string"`

	// The linked repository that you use to host your rendered infrastructure templates
	// for self-managed provisioning. A linked repository is a repository that has
	// been registered with Proton. For more information, see CreateRepository.
	ProvisioningRepository *RepositoryBranchInput_ `locationName:"provisioningRepository" type:"structure"`

	// The formatted specification that defines the update.
	//
	// Spec is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by UpdateEnvironmentInput's
	// String and GoString methods.
	Spec *string `locationName:"spec" min:"1" type:"string" sensitive:"true"`

	// The major version of the environment to update.
	TemplateMajorVersion *string `locationName:"templateMajorVersion" min:"1" type:"string"`

	// The minor version of the environment to update.
	TemplateMinorVersion *string `locationName:"templateMinorVersion" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateEnvironmentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateEnvironmentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateEnvironmentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateEnvironmentInput"}
	if s.CodebuildRoleArn != nil && len(*s.CodebuildRoleArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CodebuildRoleArn", 1))
	}
	if s.ComponentRoleArn != nil && len(*s.ComponentRoleArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ComponentRoleArn", 1))
	}
	if s.DeploymentType == nil {
		invalidParams.Add(request.NewErrParamRequired("DeploymentType"))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.ProtonServiceRoleArn != nil && len(*s.ProtonServiceRoleArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ProtonServiceRoleArn", 1))
	}
	if s.Spec != nil && len(*s.Spec) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Spec", 1))
	}
	if s.TemplateMajorVersion != nil && len(*s.TemplateMajorVersion) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TemplateMajorVersion", 1))
	}
	if s.TemplateMinorVersion != nil && len(*s.TemplateMinorVersion) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TemplateMinorVersion", 1))
	}
	if s.ProvisioningRepository != nil {
		if err := s.ProvisioningRepository.Validate(); err != nil {
			invalidParams.AddNested("ProvisioningRepository", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCodebuildRoleArn sets the CodebuildRoleArn field's value.
func (s *UpdateEnvironmentInput) SetCodebuildRoleArn(v string) *UpdateEnvironmentInput {
	s.CodebuildRoleArn = &v
	return s
}

// SetComponentRoleArn sets the ComponentRoleArn field's value.
func (s *UpdateEnvironmentInput) SetComponentRoleArn(v string) *UpdateEnvironmentInput {
	s.ComponentRoleArn = &v
	return s
}

// SetDeploymentType sets the DeploymentType field's value.
func (s *UpdateEnvironmentInput) SetDeploymentType(v string) *UpdateEnvironmentInput {
	s.DeploymentType = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *UpdateEnvironmentInput) SetDescription(v string) *UpdateEnvironmentInput {
	s.Description = &v
	return s
}

// SetEnvironmentAccountConnectionId sets the EnvironmentAccountConnectionId field's value.
func (s *UpdateEnvironmentInput) SetEnvironmentAccountConnectionId(v string) *UpdateEnvironmentInput {
	s.EnvironmentAccountConnectionId = &v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateEnvironmentInput) SetName(v string) *UpdateEnvironmentInput {
	s.Name = &v
	return s
}

// SetProtonServiceRoleArn sets the ProtonServiceRoleArn field's value.
func (s *UpdateEnvironmentInput) SetProtonServiceRoleArn(v string) *UpdateEnvironmentInput {
	s.ProtonServiceRoleArn = &v
	return s
}

// SetProvisioningRepository sets the ProvisioningRepository field's value.
func (s *UpdateEnvironmentInput) SetProvisioningRepository(v *RepositoryBranchInput_) *UpdateEnvironmentInput {
	s.ProvisioningRepository = v
	return s
}

// SetSpec sets the Spec field's value.
func (s *UpdateEnvironmentInput) SetSpec(v string) *UpdateEnvironmentInput {
	s.Spec = &v
	return s
}

// SetTemplateMajorVersion sets the TemplateMajorVersion field's value.
func (s *UpdateEnvironmentInput) SetTemplateMajorVersion(v string) *UpdateEnvironmentInput {
	s.TemplateMajorVersion = &v
	return s
}

// SetTemplateMinorVersion sets the TemplateMinorVersion field's value.
func (s *UpdateEnvironmentInput) SetTemplateMinorVersion(v string) *UpdateEnvironmentInput {
	s.TemplateMinorVersion = &v
	return s
}

type UpdateEnvironmentOutput struct {
	_ struct{} `type:"structure"`

	// The environment detail data that's returned by Proton.
	//
	// Environment is a required field
	Environment *Environment `locationName:"environment" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateEnvironmentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateEnvironmentOutput) GoString() string {
	return s.String()
}

// SetEnvironment sets the Environment field's value.
func (s *UpdateEnvironmentOutput) SetEnvironment(v *Environment) *UpdateEnvironmentOutput {
	s.Environment = v
	return s
}

type UpdateEnvironmentTemplateInput struct {
	_ struct{} `type:"structure"`

	// A description of the environment template update.
	//
	// Description is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by UpdateEnvironmentTemplateInput's
	// String and GoString methods.
	Description *string `locationName:"description" type:"string" sensitive:"true"`

	// The name of the environment template to update as displayed in the developer
	// interface.
	//
	// DisplayName is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by UpdateEnvironmentTemplateInput's
	// String and GoString methods.
	DisplayName *string `locationName:"displayName" min:"1" type:"string" sensitive:"true"`

	// The name of the environment template to update.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateEnvironmentTemplateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateEnvironmentTemplateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateEnvironmentTemplateInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateEnvironmentTemplateInput"}
	if s.DisplayName != nil && len(*s.DisplayName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DisplayName", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *UpdateEnvironmentTemplateInput) SetDescription(v string) *UpdateEnvironmentTemplateInput {
	s.Description = &v
	return s
}

// SetDisplayName sets the DisplayName field's value.
func (s *UpdateEnvironmentTemplateInput) SetDisplayName(v string) *UpdateEnvironmentTemplateInput {
	s.DisplayName = &v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateEnvironmentTemplateInput) SetName(v string) *UpdateEnvironmentTemplateInput {
	s.Name = &v
	return s
}

type UpdateEnvironmentTemplateOutput struct {
	_ struct{} `type:"structure"`

	// The environment template detail data that's returned by Proton.
	//
	// EnvironmentTemplate is a required field
	EnvironmentTemplate *EnvironmentTemplate `locationName:"environmentTemplate" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateEnvironmentTemplateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateEnvironmentTemplateOutput) GoString() string {
	return s.String()
}

// SetEnvironmentTemplate sets the EnvironmentTemplate field's value.
func (s *UpdateEnvironmentTemplateOutput) SetEnvironmentTemplate(v *EnvironmentTemplate) *UpdateEnvironmentTemplateOutput {
	s.EnvironmentTemplate = v
	return s
}

type UpdateEnvironmentTemplateVersionInput struct {
	_ struct{} `type:"structure"`

	// A description of environment template version to update.
	//
	// Description is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by UpdateEnvironmentTemplateVersionInput's
	// String and GoString methods.
	Description *string `locationName:"description" type:"string" sensitive:"true"`

	// To update a major version of an environment template, include major Version.
	//
	// MajorVersion is a required field
	MajorVersion *string `locationName:"majorVersion" min:"1" type:"string" required:"true"`

	// To update a minor version of an environment template, include minorVersion.
	//
	// MinorVersion is a required field
	MinorVersion *string `locationName:"minorVersion" min:"1" type:"string" required:"true"`

	// The status of the environment template minor version to update.
	Status *string `locationName:"status" type:"string" enum:"TemplateVersionStatus"`

	// The name of the environment template.
	//
	// TemplateName is a required field
	TemplateName *string `locationName:"templateName" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateEnvironmentTemplateVersionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateEnvironmentTemplateVersionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateEnvironmentTemplateVersionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateEnvironmentTemplateVersionInput"}
	if s.MajorVersion == nil {
		invalidParams.Add(request.NewErrParamRequired("MajorVersion"))
	}
	if s.MajorVersion != nil && len(*s.MajorVersion) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MajorVersion", 1))
	}
	if s.MinorVersion == nil {
		invalidParams.Add(request.NewErrParamRequired("MinorVersion"))
	}
	if s.MinorVersion != nil && len(*s.MinorVersion) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MinorVersion", 1))
	}
	if s.TemplateName == nil {
		invalidParams.Add(request.NewErrParamRequired("TemplateName"))
	}
	if s.TemplateName != nil && len(*s.TemplateName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TemplateName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *UpdateEnvironmentTemplateVersionInput) SetDescription(v string) *UpdateEnvironmentTemplateVersionInput {
	s.Description = &v
	return s
}

// SetMajorVersion sets the MajorVersion field's value.
func (s *UpdateEnvironmentTemplateVersionInput) SetMajorVersion(v string) *UpdateEnvironmentTemplateVersionInput {
	s.MajorVersion = &v
	return s
}

// SetMinorVersion sets the MinorVersion field's value.
func (s *UpdateEnvironmentTemplateVersionInput) SetMinorVersion(v string) *UpdateEnvironmentTemplateVersionInput {
	s.MinorVersion = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *UpdateEnvironmentTemplateVersionInput) SetStatus(v string) *UpdateEnvironmentTemplateVersionInput {
	s.Status = &v
	return s
}

// SetTemplateName sets the TemplateName field's value.
func (s *UpdateEnvironmentTemplateVersionInput) SetTemplateName(v string) *UpdateEnvironmentTemplateVersionInput {
	s.TemplateName = &v
	return s
}

type UpdateEnvironmentTemplateVersionOutput struct {
	_ struct{} `type:"structure"`

	// The environment template version detail data that's returned by Proton.
	//
	// EnvironmentTemplateVersion is a required field
	EnvironmentTemplateVersion *EnvironmentTemplateVersion `locationName:"environmentTemplateVersion" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateEnvironmentTemplateVersionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateEnvironmentTemplateVersionOutput) GoString() string {
	return s.String()
}

// SetEnvironmentTemplateVersion sets the EnvironmentTemplateVersion field's value.
func (s *UpdateEnvironmentTemplateVersionOutput) SetEnvironmentTemplateVersion(v *EnvironmentTemplateVersion) *UpdateEnvironmentTemplateVersionOutput {
	s.EnvironmentTemplateVersion = v
	return s
}

type UpdateServiceInput struct {
	_ struct{} `type:"structure"`

	// The edited service description.
	//
	// Description is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by UpdateServiceInput's
	// String and GoString methods.
	Description *string `locationName:"description" type:"string" sensitive:"true"`

	// The name of the service to edit.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// Lists the service instances to add and the existing service instances to
	// remain. Omit the existing service instances to delete from the list. Don't
	// include edits to the existing service instances or pipeline. For more information,
	// see Edit a service (https://docs.aws.amazon.com/proton/latest/userguide/ag-svc-update.html)
	// in the Proton User Guide.
	//
	// Spec is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by UpdateServiceInput's
	// String and GoString methods.
	Spec *string `locationName:"spec" min:"1" type:"string" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateServiceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateServiceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateServiceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateServiceInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Spec != nil && len(*s.Spec) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Spec", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *UpdateServiceInput) SetDescription(v string) *UpdateServiceInput {
	s.Description = &v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateServiceInput) SetName(v string) *UpdateServiceInput {
	s.Name = &v
	return s
}

// SetSpec sets the Spec field's value.
func (s *UpdateServiceInput) SetSpec(v string) *UpdateServiceInput {
	s.Spec = &v
	return s
}

type UpdateServiceInstanceInput struct {
	_ struct{} `type:"structure"`

	// The client token of the service instance to update.
	ClientToken *string `locationName:"clientToken" type:"string" idempotencyToken:"true"`

	// The deployment type. It defines the mode for updating a service instance,
	// as follows:
	//
	// NONE
	//
	// In this mode, a deployment doesn't occur. Only the requested metadata parameters
	// are updated.
	//
	// CURRENT_VERSION
	//
	// In this mode, the service instance is deployed and updated with the new spec
	// that you provide. Only requested parameters are updated. Don’t include
	// major or minor version parameters when you use this deployment type.
	//
	// MINOR_VERSION
	//
	// In this mode, the service instance is deployed and updated with the published,
	// recommended (latest) minor version of the current major version in use, by
	// default. You can also specify a different minor version of the current major
	// version in use.
	//
	// MAJOR_VERSION
	//
	// In this mode, the service instance is deployed and updated with the published,
	// recommended (latest) major and minor version of the current template, by
	// default. You can specify a different major version that's higher than the
	// major version in use and a minor version.
	//
	// DeploymentType is a required field
	DeploymentType *string `locationName:"deploymentType" type:"string" required:"true" enum:"DeploymentUpdateType"`

	// The name of the service instance to update.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// The name of the service that the service instance belongs to.
	//
	// ServiceName is a required field
	ServiceName *string `locationName:"serviceName" min:"1" type:"string" required:"true"`

	// The formatted specification that defines the service instance update.
	//
	// Spec is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by UpdateServiceInstanceInput's
	// String and GoString methods.
	Spec *string `locationName:"spec" min:"1" type:"string" sensitive:"true"`

	// The major version of the service template to update.
	TemplateMajorVersion *string `locationName:"templateMajorVersion" min:"1" type:"string"`

	// The minor version of the service template to update.
	TemplateMinorVersion *string `locationName:"templateMinorVersion" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateServiceInstanceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateServiceInstanceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateServiceInstanceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateServiceInstanceInput"}
	if s.DeploymentType == nil {
		invalidParams.Add(request.NewErrParamRequired("DeploymentType"))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.ServiceName == nil {
		invalidParams.Add(request.NewErrParamRequired("ServiceName"))
	}
	if s.ServiceName != nil && len(*s.ServiceName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ServiceName", 1))
	}
	if s.Spec != nil && len(*s.Spec) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Spec", 1))
	}
	if s.TemplateMajorVersion != nil && len(*s.TemplateMajorVersion) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TemplateMajorVersion", 1))
	}
	if s.TemplateMinorVersion != nil && len(*s.TemplateMinorVersion) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TemplateMinorVersion", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *UpdateServiceInstanceInput) SetClientToken(v string) *UpdateServiceInstanceInput {
	s.ClientToken = &v
	return s
}

// SetDeploymentType sets the DeploymentType field's value.
func (s *UpdateServiceInstanceInput) SetDeploymentType(v string) *UpdateServiceInstanceInput {
	s.DeploymentType = &v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateServiceInstanceInput) SetName(v string) *UpdateServiceInstanceInput {
	s.Name = &v
	return s
}

// SetServiceName sets the ServiceName field's value.
func (s *UpdateServiceInstanceInput) SetServiceName(v string) *UpdateServiceInstanceInput {
	s.ServiceName = &v
	return s
}

// SetSpec sets the Spec field's value.
func (s *UpdateServiceInstanceInput) SetSpec(v string) *UpdateServiceInstanceInput {
	s.Spec = &v
	return s
}

// SetTemplateMajorVersion sets the TemplateMajorVersion field's value.
func (s *UpdateServiceInstanceInput) SetTemplateMajorVersion(v string) *UpdateServiceInstanceInput {
	s.TemplateMajorVersion = &v
	return s
}

// SetTemplateMinorVersion sets the TemplateMinorVersion field's value.
func (s *UpdateServiceInstanceInput) SetTemplateMinorVersion(v string) *UpdateServiceInstanceInput {
	s.TemplateMinorVersion = &v
	return s
}

type UpdateServiceInstanceOutput struct {
	_ struct{} `type:"structure"`

	// The service instance summary data that's returned by Proton.
	//
	// ServiceInstance is a required field
	ServiceInstance *ServiceInstance `locationName:"serviceInstance" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateServiceInstanceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateServiceInstanceOutput) GoString() string {
	return s.String()
}

// SetServiceInstance sets the ServiceInstance field's value.
func (s *UpdateServiceInstanceOutput) SetServiceInstance(v *ServiceInstance) *UpdateServiceInstanceOutput {
	s.ServiceInstance = v
	return s
}

type UpdateServiceOutput struct {
	_ struct{} `type:"structure"`

	// The service detail data that's returned by Proton.
	//
	// Service is a required field
	Service *Service `locationName:"service" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateServiceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateServiceOutput) GoString() string {
	return s.String()
}

// SetService sets the Service field's value.
func (s *UpdateServiceOutput) SetService(v *Service) *UpdateServiceOutput {
	s.Service = v
	return s
}

type UpdateServicePipelineInput struct {
	_ struct{} `type:"structure"`

	// The deployment type.
	//
	// There are four modes for updating a service pipeline. The deploymentType
	// field defines the mode.
	//
	// NONE
	//
	// In this mode, a deployment doesn't occur. Only the requested metadata parameters
	// are updated.
	//
	// CURRENT_VERSION
	//
	// In this mode, the service pipeline is deployed and updated with the new spec
	// that you provide. Only requested parameters are updated. Don’t include
	// major or minor version parameters when you use this deployment-type.
	//
	// MINOR_VERSION
	//
	// In this mode, the service pipeline is deployed and updated with the published,
	// recommended (latest) minor version of the current major version in use, by
	// default. You can specify a different minor version of the current major version
	// in use.
	//
	// MAJOR_VERSION
	//
	// In this mode, the service pipeline is deployed and updated with the published,
	// recommended (latest) major and minor version of the current template, by
	// default. You can specify a different major version that's higher than the
	// major version in use and a minor version.
	//
	// DeploymentType is a required field
	DeploymentType *string `locationName:"deploymentType" type:"string" required:"true" enum:"DeploymentUpdateType"`

	// The name of the service to that the pipeline is associated with.
	//
	// ServiceName is a required field
	ServiceName *string `locationName:"serviceName" min:"1" type:"string" required:"true"`

	// The spec for the service pipeline to update.
	//
	// Spec is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by UpdateServicePipelineInput's
	// String and GoString methods.
	//
	// Spec is a required field
	Spec *string `locationName:"spec" min:"1" type:"string" required:"true" sensitive:"true"`

	// The major version of the service template that was used to create the service
	// that the pipeline is associated with.
	TemplateMajorVersion *string `locationName:"templateMajorVersion" min:"1" type:"string"`

	// The minor version of the service template that was used to create the service
	// that the pipeline is associated with.
	TemplateMinorVersion *string `locationName:"templateMinorVersion" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateServicePipelineInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateServicePipelineInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateServicePipelineInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateServicePipelineInput"}
	if s.DeploymentType == nil {
		invalidParams.Add(request.NewErrParamRequired("DeploymentType"))
	}
	if s.ServiceName == nil {
		invalidParams.Add(request.NewErrParamRequired("ServiceName"))
	}
	if s.ServiceName != nil && len(*s.ServiceName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ServiceName", 1))
	}
	if s.Spec == nil {
		invalidParams.Add(request.NewErrParamRequired("Spec"))
	}
	if s.Spec != nil && len(*s.Spec) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Spec", 1))
	}
	if s.TemplateMajorVersion != nil && len(*s.TemplateMajorVersion) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TemplateMajorVersion", 1))
	}
	if s.TemplateMinorVersion != nil && len(*s.TemplateMinorVersion) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TemplateMinorVersion", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDeploymentType sets the DeploymentType field's value.
func (s *UpdateServicePipelineInput) SetDeploymentType(v string) *UpdateServicePipelineInput {
	s.DeploymentType = &v
	return s
}

// SetServiceName sets the ServiceName field's value.
func (s *UpdateServicePipelineInput) SetServiceName(v string) *UpdateServicePipelineInput {
	s.ServiceName = &v
	return s
}

// SetSpec sets the Spec field's value.
func (s *UpdateServicePipelineInput) SetSpec(v string) *UpdateServicePipelineInput {
	s.Spec = &v
	return s
}

// SetTemplateMajorVersion sets the TemplateMajorVersion field's value.
func (s *UpdateServicePipelineInput) SetTemplateMajorVersion(v string) *UpdateServicePipelineInput {
	s.TemplateMajorVersion = &v
	return s
}

// SetTemplateMinorVersion sets the TemplateMinorVersion field's value.
func (s *UpdateServicePipelineInput) SetTemplateMinorVersion(v string) *UpdateServicePipelineInput {
	s.TemplateMinorVersion = &v
	return s
}

type UpdateServicePipelineOutput struct {
	_ struct{} `type:"structure"`

	// The pipeline details that are returned by Proton.
	//
	// Pipeline is a required field
	Pipeline *ServicePipeline `locationName:"pipeline" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateServicePipelineOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateServicePipelineOutput) GoString() string {
	return s.String()
}

// SetPipeline sets the Pipeline field's value.
func (s *UpdateServicePipelineOutput) SetPipeline(v *ServicePipeline) *UpdateServicePipelineOutput {
	s.Pipeline = v
	return s
}

type UpdateServiceSyncBlockerInput struct {
	_ struct{} `type:"structure"`

	// The ID of the service sync blocker.
	//
	// Id is a required field
	Id *string `locationName:"id" type:"string" required:"true"`

	// The reason the service sync blocker was resolved.
	//
	// ResolvedReason is a required field
	ResolvedReason *string `locationName:"resolvedReason" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateServiceSyncBlockerInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateServiceSyncBlockerInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateServiceSyncBlockerInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateServiceSyncBlockerInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.ResolvedReason == nil {
		invalidParams.Add(request.NewErrParamRequired("ResolvedReason"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *UpdateServiceSyncBlockerInput) SetId(v string) *UpdateServiceSyncBlockerInput {
	s.Id = &v
	return s
}

// SetResolvedReason sets the ResolvedReason field's value.
func (s *UpdateServiceSyncBlockerInput) SetResolvedReason(v string) *UpdateServiceSyncBlockerInput {
	s.ResolvedReason = &v
	return s
}

type UpdateServiceSyncBlockerOutput struct {
	_ struct{} `type:"structure"`

	// The name of the service instance that you want to update the service sync
	// blocker for.
	ServiceInstanceName *string `locationName:"serviceInstanceName" min:"1" type:"string"`

	// The name of the service that you want to update the service sync blocker
	// for.
	//
	// ServiceName is a required field
	ServiceName *string `locationName:"serviceName" min:"1" type:"string" required:"true"`

	// The detailed data on the service sync blocker that was updated.
	//
	// ServiceSyncBlocker is a required field
	ServiceSyncBlocker *SyncBlocker `locationName:"serviceSyncBlocker" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateServiceSyncBlockerOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateServiceSyncBlockerOutput) GoString() string {
	return s.String()
}

// SetServiceInstanceName sets the ServiceInstanceName field's value.
func (s *UpdateServiceSyncBlockerOutput) SetServiceInstanceName(v string) *UpdateServiceSyncBlockerOutput {
	s.ServiceInstanceName = &v
	return s
}

// SetServiceName sets the ServiceName field's value.
func (s *UpdateServiceSyncBlockerOutput) SetServiceName(v string) *UpdateServiceSyncBlockerOutput {
	s.ServiceName = &v
	return s
}

// SetServiceSyncBlocker sets the ServiceSyncBlocker field's value.
func (s *UpdateServiceSyncBlockerOutput) SetServiceSyncBlocker(v *SyncBlocker) *UpdateServiceSyncBlockerOutput {
	s.ServiceSyncBlocker = v
	return s
}

type UpdateServiceSyncConfigInput struct {
	_ struct{} `type:"structure"`

	// The name of the code repository branch where the Proton Ops file is found.
	//
	// Branch is a required field
	Branch *string `locationName:"branch" min:"1" type:"string" required:"true"`

	// The path to the Proton Ops file.
	//
	// FilePath is a required field
	FilePath *string `locationName:"filePath" min:"1" type:"string" required:"true"`

	// The name of the repository where the Proton Ops file is found.
	//
	// RepositoryName is a required field
	RepositoryName *string `locationName:"repositoryName" min:"1" type:"string" required:"true"`

	// The name of the repository provider where the Proton Ops file is found.
	//
	// RepositoryProvider is a required field
	RepositoryProvider *string `locationName:"repositoryProvider" type:"string" required:"true" enum:"RepositoryProvider"`

	// The name of the service the Proton Ops file is for.
	//
	// ServiceName is a required field
	ServiceName *string `locationName:"serviceName" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateServiceSyncConfigInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateServiceSyncConfigInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateServiceSyncConfigInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateServiceSyncConfigInput"}
	if s.Branch == nil {
		invalidParams.Add(request.NewErrParamRequired("Branch"))
	}
	if s.Branch != nil && len(*s.Branch) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Branch", 1))
	}
	if s.FilePath == nil {
		invalidParams.Add(request.NewErrParamRequired("FilePath"))
	}
	if s.FilePath != nil && len(*s.FilePath) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FilePath", 1))
	}
	if s.RepositoryName == nil {
		invalidParams.Add(request.NewErrParamRequired("RepositoryName"))
	}
	if s.RepositoryName != nil && len(*s.RepositoryName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RepositoryName", 1))
	}
	if s.RepositoryProvider == nil {
		invalidParams.Add(request.NewErrParamRequired("RepositoryProvider"))
	}
	if s.ServiceName == nil {
		invalidParams.Add(request.NewErrParamRequired("ServiceName"))
	}
	if s.ServiceName != nil && len(*s.ServiceName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ServiceName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBranch sets the Branch field's value.
func (s *UpdateServiceSyncConfigInput) SetBranch(v string) *UpdateServiceSyncConfigInput {
	s.Branch = &v
	return s
}

// SetFilePath sets the FilePath field's value.
func (s *UpdateServiceSyncConfigInput) SetFilePath(v string) *UpdateServiceSyncConfigInput {
	s.FilePath = &v
	return s
}

// SetRepositoryName sets the RepositoryName field's value.
func (s *UpdateServiceSyncConfigInput) SetRepositoryName(v string) *UpdateServiceSyncConfigInput {
	s.RepositoryName = &v
	return s
}

// SetRepositoryProvider sets the RepositoryProvider field's value.
func (s *UpdateServiceSyncConfigInput) SetRepositoryProvider(v string) *UpdateServiceSyncConfigInput {
	s.RepositoryProvider = &v
	return s
}

// SetServiceName sets the ServiceName field's value.
func (s *UpdateServiceSyncConfigInput) SetServiceName(v string) *UpdateServiceSyncConfigInput {
	s.ServiceName = &v
	return s
}

type UpdateServiceSyncConfigOutput struct {
	_ struct{} `type:"structure"`

	// The detailed data of the Proton Ops file.
	ServiceSyncConfig *ServiceSyncConfig `locationName:"serviceSyncConfig" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateServiceSyncConfigOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateServiceSyncConfigOutput) GoString() string {
	return s.String()
}

// SetServiceSyncConfig sets the ServiceSyncConfig field's value.
func (s *UpdateServiceSyncConfigOutput) SetServiceSyncConfig(v *ServiceSyncConfig) *UpdateServiceSyncConfigOutput {
	s.ServiceSyncConfig = v
	return s
}

type UpdateServiceTemplateInput struct {
	_ struct{} `type:"structure"`

	// A description of the service template update.
	//
	// Description is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by UpdateServiceTemplateInput's
	// String and GoString methods.
	Description *string `locationName:"description" type:"string" sensitive:"true"`

	// The name of the service template to update that's displayed in the developer
	// interface.
	//
	// DisplayName is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by UpdateServiceTemplateInput's
	// String and GoString methods.
	DisplayName *string `locationName:"displayName" min:"1" type:"string" sensitive:"true"`

	// The name of the service template to update.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateServiceTemplateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateServiceTemplateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateServiceTemplateInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateServiceTemplateInput"}
	if s.DisplayName != nil && len(*s.DisplayName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DisplayName", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *UpdateServiceTemplateInput) SetDescription(v string) *UpdateServiceTemplateInput {
	s.Description = &v
	return s
}

// SetDisplayName sets the DisplayName field's value.
func (s *UpdateServiceTemplateInput) SetDisplayName(v string) *UpdateServiceTemplateInput {
	s.DisplayName = &v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateServiceTemplateInput) SetName(v string) *UpdateServiceTemplateInput {
	s.Name = &v
	return s
}

type UpdateServiceTemplateOutput struct {
	_ struct{} `type:"structure"`

	// The service template detail data that's returned by Proton.
	//
	// ServiceTemplate is a required field
	ServiceTemplate *ServiceTemplate `locationName:"serviceTemplate" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateServiceTemplateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateServiceTemplateOutput) GoString() string {
	return s.String()
}

// SetServiceTemplate sets the ServiceTemplate field's value.
func (s *UpdateServiceTemplateOutput) SetServiceTemplate(v *ServiceTemplate) *UpdateServiceTemplateOutput {
	s.ServiceTemplate = v
	return s
}

type UpdateServiceTemplateVersionInput struct {
	_ struct{} `type:"structure"`

	// An array of environment template objects that are compatible with this service
	// template version. A service instance based on this service template version
	// can run in environments based on compatible templates.
	CompatibleEnvironmentTemplates []*CompatibleEnvironmentTemplateInput `locationName:"compatibleEnvironmentTemplates" min:"1" type:"list"`

	// A description of a service template version to update.
	//
	// Description is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by UpdateServiceTemplateVersionInput's
	// String and GoString methods.
	Description *string `locationName:"description" type:"string" sensitive:"true"`

	// To update a major version of a service template, include major Version.
	//
	// MajorVersion is a required field
	MajorVersion *string `locationName:"majorVersion" min:"1" type:"string" required:"true"`

	// To update a minor version of a service template, include minorVersion.
	//
	// MinorVersion is a required field
	MinorVersion *string `locationName:"minorVersion" min:"1" type:"string" required:"true"`

	// The status of the service template minor version to update.
	Status *string `locationName:"status" type:"string" enum:"TemplateVersionStatus"`

	// An array of supported component sources. Components with supported sources
	// can be attached to service instances based on this service template version.
	//
	// A change to supportedComponentSources doesn't impact existing component attachments
	// to instances based on this template version. A change only affects later
	// associations.
	//
	// For more information about components, see Proton components (https://docs.aws.amazon.com/proton/latest/userguide/ag-components.html)
	// in the Proton User Guide.
	SupportedComponentSources []*string `locationName:"supportedComponentSources" type:"list" enum:"ServiceTemplateSupportedComponentSourceType"`

	// The name of the service template.
	//
	// TemplateName is a required field
	TemplateName *string `locationName:"templateName" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateServiceTemplateVersionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateServiceTemplateVersionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateServiceTemplateVersionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateServiceTemplateVersionInput"}
	if s.CompatibleEnvironmentTemplates != nil && len(s.CompatibleEnvironmentTemplates) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CompatibleEnvironmentTemplates", 1))
	}
	if s.MajorVersion == nil {
		invalidParams.Add(request.NewErrParamRequired("MajorVersion"))
	}
	if s.MajorVersion != nil && len(*s.MajorVersion) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MajorVersion", 1))
	}
	if s.MinorVersion == nil {
		invalidParams.Add(request.NewErrParamRequired("MinorVersion"))
	}
	if s.MinorVersion != nil && len(*s.MinorVersion) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MinorVersion", 1))
	}
	if s.TemplateName == nil {
		invalidParams.Add(request.NewErrParamRequired("TemplateName"))
	}
	if s.TemplateName != nil && len(*s.TemplateName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TemplateName", 1))
	}
	if s.CompatibleEnvironmentTemplates != nil {
		for i, v := range s.CompatibleEnvironmentTemplates {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "CompatibleEnvironmentTemplates", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCompatibleEnvironmentTemplates sets the CompatibleEnvironmentTemplates field's value.
func (s *UpdateServiceTemplateVersionInput) SetCompatibleEnvironmentTemplates(v []*CompatibleEnvironmentTemplateInput) *UpdateServiceTemplateVersionInput {
	s.CompatibleEnvironmentTemplates = v
	return s
}

// SetDescription sets the Description field's value.
func (s *UpdateServiceTemplateVersionInput) SetDescription(v string) *UpdateServiceTemplateVersionInput {
	s.Description = &v
	return s
}

// SetMajorVersion sets the MajorVersion field's value.
func (s *UpdateServiceTemplateVersionInput) SetMajorVersion(v string) *UpdateServiceTemplateVersionInput {
	s.MajorVersion = &v
	return s
}

// SetMinorVersion sets the MinorVersion field's value.
func (s *UpdateServiceTemplateVersionInput) SetMinorVersion(v string) *UpdateServiceTemplateVersionInput {
	s.MinorVersion = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *UpdateServiceTemplateVersionInput) SetStatus(v string) *UpdateServiceTemplateVersionInput {
	s.Status = &v
	return s
}

// SetSupportedComponentSources sets the SupportedComponentSources field's value.
func (s *UpdateServiceTemplateVersionInput) SetSupportedComponentSources(v []*string) *UpdateServiceTemplateVersionInput {
	s.SupportedComponentSources = v
	return s
}

// SetTemplateName sets the TemplateName field's value.
func (s *UpdateServiceTemplateVersionInput) SetTemplateName(v string) *UpdateServiceTemplateVersionInput {
	s.TemplateName = &v
	return s
}

type UpdateServiceTemplateVersionOutput struct {
	_ struct{} `type:"structure"`

	// The service template version detail data that's returned by Proton.
	//
	// ServiceTemplateVersion is a required field
	ServiceTemplateVersion *ServiceTemplateVersion `locationName:"serviceTemplateVersion" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateServiceTemplateVersionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateServiceTemplateVersionOutput) GoString() string {
	return s.String()
}

// SetServiceTemplateVersion sets the ServiceTemplateVersion field's value.
func (s *UpdateServiceTemplateVersionOutput) SetServiceTemplateVersion(v *ServiceTemplateVersion) *UpdateServiceTemplateVersionOutput {
	s.ServiceTemplateVersion = v
	return s
}

type UpdateTemplateSyncConfigInput struct {
	_ struct{} `type:"structure"`

	// The repository branch for your template.
	//
	// Branch is a required field
	Branch *string `locationName:"branch" min:"1" type:"string" required:"true"`

	// The repository name (for example, myrepos/myrepo).
	//
	// RepositoryName is a required field
	RepositoryName *string `locationName:"repositoryName" min:"1" type:"string" required:"true"`

	// The repository provider.
	//
	// RepositoryProvider is a required field
	RepositoryProvider *string `locationName:"repositoryProvider" type:"string" required:"true" enum:"RepositoryProvider"`

	// A subdirectory path to your template bundle version. When included, limits
	// the template bundle search to this repository directory.
	Subdirectory *string `locationName:"subdirectory" min:"1" type:"string"`

	// The synced template name.
	//
	// TemplateName is a required field
	TemplateName *string `locationName:"templateName" min:"1" type:"string" required:"true"`

	// The synced template type.
	//
	// TemplateType is a required field
	TemplateType *string `locationName:"templateType" type:"string" required:"true" enum:"TemplateType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateTemplateSyncConfigInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateTemplateSyncConfigInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateTemplateSyncConfigInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateTemplateSyncConfigInput"}
	if s.Branch == nil {
		invalidParams.Add(request.NewErrParamRequired("Branch"))
	}
	if s.Branch != nil && len(*s.Branch) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Branch", 1))
	}
	if s.RepositoryName == nil {
		invalidParams.Add(request.NewErrParamRequired("RepositoryName"))
	}
	if s.RepositoryName != nil && len(*s.RepositoryName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RepositoryName", 1))
	}
	if s.RepositoryProvider == nil {
		invalidParams.Add(request.NewErrParamRequired("RepositoryProvider"))
	}
	if s.Subdirectory != nil && len(*s.Subdirectory) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Subdirectory", 1))
	}
	if s.TemplateName == nil {
		invalidParams.Add(request.NewErrParamRequired("TemplateName"))
	}
	if s.TemplateName != nil && len(*s.TemplateName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TemplateName", 1))
	}
	if s.TemplateType == nil {
		invalidParams.Add(request.NewErrParamRequired("TemplateType"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBranch sets the Branch field's value.
func (s *UpdateTemplateSyncConfigInput) SetBranch(v string) *UpdateTemplateSyncConfigInput {
	s.Branch = &v
	return s
}

// SetRepositoryName sets the RepositoryName field's value.
func (s *UpdateTemplateSyncConfigInput) SetRepositoryName(v string) *UpdateTemplateSyncConfigInput {
	s.RepositoryName = &v
	return s
}

// SetRepositoryProvider sets the RepositoryProvider field's value.
func (s *UpdateTemplateSyncConfigInput) SetRepositoryProvider(v string) *UpdateTemplateSyncConfigInput {
	s.RepositoryProvider = &v
	return s
}

// SetSubdirectory sets the Subdirectory field's value.
func (s *UpdateTemplateSyncConfigInput) SetSubdirectory(v string) *UpdateTemplateSyncConfigInput {
	s.Subdirectory = &v
	return s
}

// SetTemplateName sets the TemplateName field's value.
func (s *UpdateTemplateSyncConfigInput) SetTemplateName(v string) *UpdateTemplateSyncConfigInput {
	s.TemplateName = &v
	return s
}

// SetTemplateType sets the TemplateType field's value.
func (s *UpdateTemplateSyncConfigInput) SetTemplateType(v string) *UpdateTemplateSyncConfigInput {
	s.TemplateType = &v
	return s
}

type UpdateTemplateSyncConfigOutput struct {
	_ struct{} `type:"structure"`

	// The template sync configuration detail data that's returned by Proton.
	TemplateSyncConfig *TemplateSyncConfig `locationName:"templateSyncConfig" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateTemplateSyncConfigOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateTemplateSyncConfigOutput) GoString() string {
	return s.String()
}

// SetTemplateSyncConfig sets the TemplateSyncConfig field's value.
func (s *UpdateTemplateSyncConfigOutput) SetTemplateSyncConfig(v *TemplateSyncConfig) *UpdateTemplateSyncConfigOutput {
	s.TemplateSyncConfig = v
	return s
}

// The input is invalid or an out-of-range value was supplied for the input
// parameter.
type ValidationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// Message_ is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by ValidationException's
	// String and GoString methods.
	Message_ *string `locationName:"message" type:"string" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) GoString() string {
	return s.String()
}

func newErrorValidationException(v protocol.ResponseMetadata) error {
	return &ValidationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ValidationException) Code() string {
	return "ValidationException"
}

// Message returns the exception's message.
func (s *ValidationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ValidationException) OrigErr() error {
	return nil
}

func (s *ValidationException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ValidationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ValidationException) RequestID() string {
	return s.RespMetadata.RequestID
}

const (
	// BlockerStatusActive is a BlockerStatus enum value
	BlockerStatusActive = "ACTIVE"

	// BlockerStatusResolved is a BlockerStatus enum value
	BlockerStatusResolved = "RESOLVED"
)

// BlockerStatus_Values returns all elements of the BlockerStatus enum
func BlockerStatus_Values() []string {
	return []string{
		BlockerStatusActive,
		BlockerStatusResolved,
	}
}

const (
	// BlockerTypeAutomated is a BlockerType enum value
	BlockerTypeAutomated = "AUTOMATED"
)

// BlockerType_Values returns all elements of the BlockerType enum
func BlockerType_Values() []string {
	return []string{
		BlockerTypeAutomated,
	}
}

const (
	// ComponentDeploymentUpdateTypeNone is a ComponentDeploymentUpdateType enum value
	ComponentDeploymentUpdateTypeNone = "NONE"

	// ComponentDeploymentUpdateTypeCurrentVersion is a ComponentDeploymentUpdateType enum value
	ComponentDeploymentUpdateTypeCurrentVersion = "CURRENT_VERSION"
)

// ComponentDeploymentUpdateType_Values returns all elements of the ComponentDeploymentUpdateType enum
func ComponentDeploymentUpdateType_Values() []string {
	return []string{
		ComponentDeploymentUpdateTypeNone,
		ComponentDeploymentUpdateTypeCurrentVersion,
	}
}

const (
	// DeploymentStatusInProgress is a DeploymentStatus enum value
	DeploymentStatusInProgress = "IN_PROGRESS"

	// DeploymentStatusFailed is a DeploymentStatus enum value
	DeploymentStatusFailed = "FAILED"

	// DeploymentStatusSucceeded is a DeploymentStatus enum value
	DeploymentStatusSucceeded = "SUCCEEDED"

	// DeploymentStatusDeleteInProgress is a DeploymentStatus enum value
	DeploymentStatusDeleteInProgress = "DELETE_IN_PROGRESS"

	// DeploymentStatusDeleteFailed is a DeploymentStatus enum value
	DeploymentStatusDeleteFailed = "DELETE_FAILED"

	// DeploymentStatusDeleteComplete is a DeploymentStatus enum value
	DeploymentStatusDeleteComplete = "DELETE_COMPLETE"

	// DeploymentStatusCancelling is a DeploymentStatus enum value
	DeploymentStatusCancelling = "CANCELLING"

	// DeploymentStatusCancelled is a DeploymentStatus enum value
	DeploymentStatusCancelled = "CANCELLED"
)

// DeploymentStatus_Values returns all elements of the DeploymentStatus enum
func DeploymentStatus_Values() []string {
	return []string{
		DeploymentStatusInProgress,
		DeploymentStatusFailed,
		DeploymentStatusSucceeded,
		DeploymentStatusDeleteInProgress,
		DeploymentStatusDeleteFailed,
		DeploymentStatusDeleteComplete,
		DeploymentStatusCancelling,
		DeploymentStatusCancelled,
	}
}

const (
	// DeploymentTargetResourceTypeEnvironment is a DeploymentTargetResourceType enum value
	DeploymentTargetResourceTypeEnvironment = "ENVIRONMENT"

	// DeploymentTargetResourceTypeServicePipeline is a DeploymentTargetResourceType enum value
	DeploymentTargetResourceTypeServicePipeline = "SERVICE_PIPELINE"

	// DeploymentTargetResourceTypeServiceInstance is a DeploymentTargetResourceType enum value
	DeploymentTargetResourceTypeServiceInstance = "SERVICE_INSTANCE"

	// DeploymentTargetResourceTypeComponent is a DeploymentTargetResourceType enum value
	DeploymentTargetResourceTypeComponent = "COMPONENT"
)

// DeploymentTargetResourceType_Values returns all elements of the DeploymentTargetResourceType enum
func DeploymentTargetResourceType_Values() []string {
	return []string{
		DeploymentTargetResourceTypeEnvironment,
		DeploymentTargetResourceTypeServicePipeline,
		DeploymentTargetResourceTypeServiceInstance,
		DeploymentTargetResourceTypeComponent,
	}
}

const (
	// DeploymentUpdateTypeNone is a DeploymentUpdateType enum value
	DeploymentUpdateTypeNone = "NONE"

	// DeploymentUpdateTypeCurrentVersion is a DeploymentUpdateType enum value
	DeploymentUpdateTypeCurrentVersion = "CURRENT_VERSION"

	// DeploymentUpdateTypeMinorVersion is a DeploymentUpdateType enum value
	DeploymentUpdateTypeMinorVersion = "MINOR_VERSION"

	// DeploymentUpdateTypeMajorVersion is a DeploymentUpdateType enum value
	DeploymentUpdateTypeMajorVersion = "MAJOR_VERSION"
)

// DeploymentUpdateType_Values returns all elements of the DeploymentUpdateType enum
func DeploymentUpdateType_Values() []string {
	return []string{
		DeploymentUpdateTypeNone,
		DeploymentUpdateTypeCurrentVersion,
		DeploymentUpdateTypeMinorVersion,
		DeploymentUpdateTypeMajorVersion,
	}
}

const (
	// EnvironmentAccountConnectionRequesterAccountTypeManagementAccount is a EnvironmentAccountConnectionRequesterAccountType enum value
	EnvironmentAccountConnectionRequesterAccountTypeManagementAccount = "MANAGEMENT_ACCOUNT"

	// EnvironmentAccountConnectionRequesterAccountTypeEnvironmentAccount is a EnvironmentAccountConnectionRequesterAccountType enum value
	EnvironmentAccountConnectionRequesterAccountTypeEnvironmentAccount = "ENVIRONMENT_ACCOUNT"
)

// EnvironmentAccountConnectionRequesterAccountType_Values returns all elements of the EnvironmentAccountConnectionRequesterAccountType enum
func EnvironmentAccountConnectionRequesterAccountType_Values() []string {
	return []string{
		EnvironmentAccountConnectionRequesterAccountTypeManagementAccount,
		EnvironmentAccountConnectionRequesterAccountTypeEnvironmentAccount,
	}
}

const (
	// EnvironmentAccountConnectionStatusPending is a EnvironmentAccountConnectionStatus enum value
	EnvironmentAccountConnectionStatusPending = "PENDING"

	// EnvironmentAccountConnectionStatusConnected is a EnvironmentAccountConnectionStatus enum value
	EnvironmentAccountConnectionStatusConnected = "CONNECTED"

	// EnvironmentAccountConnectionStatusRejected is a EnvironmentAccountConnectionStatus enum value
	EnvironmentAccountConnectionStatusRejected = "REJECTED"
)

// EnvironmentAccountConnectionStatus_Values returns all elements of the EnvironmentAccountConnectionStatus enum
func EnvironmentAccountConnectionStatus_Values() []string {
	return []string{
		EnvironmentAccountConnectionStatusPending,
		EnvironmentAccountConnectionStatusConnected,
		EnvironmentAccountConnectionStatusRejected,
	}
}

const (
	// ListServiceInstancesFilterByName is a ListServiceInstancesFilterBy enum value
	ListServiceInstancesFilterByName = "name"

	// ListServiceInstancesFilterByDeploymentStatus is a ListServiceInstancesFilterBy enum value
	ListServiceInstancesFilterByDeploymentStatus = "deploymentStatus"

	// ListServiceInstancesFilterByTemplateName is a ListServiceInstancesFilterBy enum value
	ListServiceInstancesFilterByTemplateName = "templateName"

	// ListServiceInstancesFilterByServiceName is a ListServiceInstancesFilterBy enum value
	ListServiceInstancesFilterByServiceName = "serviceName"

	// ListServiceInstancesFilterByDeployedTemplateVersionStatus is a ListServiceInstancesFilterBy enum value
	ListServiceInstancesFilterByDeployedTemplateVersionStatus = "deployedTemplateVersionStatus"

	// ListServiceInstancesFilterByEnvironmentName is a ListServiceInstancesFilterBy enum value
	ListServiceInstancesFilterByEnvironmentName = "environmentName"

	// ListServiceInstancesFilterByLastDeploymentAttemptedAtBefore is a ListServiceInstancesFilterBy enum value
	ListServiceInstancesFilterByLastDeploymentAttemptedAtBefore = "lastDeploymentAttemptedAtBefore"

	// ListServiceInstancesFilterByLastDeploymentAttemptedAtAfter is a ListServiceInstancesFilterBy enum value
	ListServiceInstancesFilterByLastDeploymentAttemptedAtAfter = "lastDeploymentAttemptedAtAfter"

	// ListServiceInstancesFilterByCreatedAtBefore is a ListServiceInstancesFilterBy enum value
	ListServiceInstancesFilterByCreatedAtBefore = "createdAtBefore"

	// ListServiceInstancesFilterByCreatedAtAfter is a ListServiceInstancesFilterBy enum value
	ListServiceInstancesFilterByCreatedAtAfter = "createdAtAfter"
)

// ListServiceInstancesFilterBy_Values returns all elements of the ListServiceInstancesFilterBy enum
func ListServiceInstancesFilterBy_Values() []string {
	return []string{
		ListServiceInstancesFilterByName,
		ListServiceInstancesFilterByDeploymentStatus,
		ListServiceInstancesFilterByTemplateName,
		ListServiceInstancesFilterByServiceName,
		ListServiceInstancesFilterByDeployedTemplateVersionStatus,
		ListServiceInstancesFilterByEnvironmentName,
		ListServiceInstancesFilterByLastDeploymentAttemptedAtBefore,
		ListServiceInstancesFilterByLastDeploymentAttemptedAtAfter,
		ListServiceInstancesFilterByCreatedAtBefore,
		ListServiceInstancesFilterByCreatedAtAfter,
	}
}

const (
	// ListServiceInstancesSortByName is a ListServiceInstancesSortBy enum value
	ListServiceInstancesSortByName = "name"

	// ListServiceInstancesSortByDeploymentStatus is a ListServiceInstancesSortBy enum value
	ListServiceInstancesSortByDeploymentStatus = "deploymentStatus"

	// ListServiceInstancesSortByTemplateName is a ListServiceInstancesSortBy enum value
	ListServiceInstancesSortByTemplateName = "templateName"

	// ListServiceInstancesSortByServiceName is a ListServiceInstancesSortBy enum value
	ListServiceInstancesSortByServiceName = "serviceName"

	// ListServiceInstancesSortByEnvironmentName is a ListServiceInstancesSortBy enum value
	ListServiceInstancesSortByEnvironmentName = "environmentName"

	// ListServiceInstancesSortByLastDeploymentAttemptedAt is a ListServiceInstancesSortBy enum value
	ListServiceInstancesSortByLastDeploymentAttemptedAt = "lastDeploymentAttemptedAt"

	// ListServiceInstancesSortByCreatedAt is a ListServiceInstancesSortBy enum value
	ListServiceInstancesSortByCreatedAt = "createdAt"
)

// ListServiceInstancesSortBy_Values returns all elements of the ListServiceInstancesSortBy enum
func ListServiceInstancesSortBy_Values() []string {
	return []string{
		ListServiceInstancesSortByName,
		ListServiceInstancesSortByDeploymentStatus,
		ListServiceInstancesSortByTemplateName,
		ListServiceInstancesSortByServiceName,
		ListServiceInstancesSortByEnvironmentName,
		ListServiceInstancesSortByLastDeploymentAttemptedAt,
		ListServiceInstancesSortByCreatedAt,
	}
}

// List of provisioning engines
const (
	// ProvisionedResourceEngineCloudformation is a ProvisionedResourceEngine enum value
	ProvisionedResourceEngineCloudformation = "CLOUDFORMATION"

	// ProvisionedResourceEngineTerraform is a ProvisionedResourceEngine enum value
	ProvisionedResourceEngineTerraform = "TERRAFORM"
)

// ProvisionedResourceEngine_Values returns all elements of the ProvisionedResourceEngine enum
func ProvisionedResourceEngine_Values() []string {
	return []string{
		ProvisionedResourceEngineCloudformation,
		ProvisionedResourceEngineTerraform,
	}
}

const (
	// ProvisioningCustomerManaged is a Provisioning enum value
	ProvisioningCustomerManaged = "CUSTOMER_MANAGED"
)

// Provisioning_Values returns all elements of the Provisioning enum
func Provisioning_Values() []string {
	return []string{
		ProvisioningCustomerManaged,
	}
}

const (
	// RepositoryProviderGithub is a RepositoryProvider enum value
	RepositoryProviderGithub = "GITHUB"

	// RepositoryProviderGithubEnterprise is a RepositoryProvider enum value
	RepositoryProviderGithubEnterprise = "GITHUB_ENTERPRISE"

	// RepositoryProviderBitbucket is a RepositoryProvider enum value
	RepositoryProviderBitbucket = "BITBUCKET"
)

// RepositoryProvider_Values returns all elements of the RepositoryProvider enum
func RepositoryProvider_Values() []string {
	return []string{
		RepositoryProviderGithub,
		RepositoryProviderGithubEnterprise,
		RepositoryProviderBitbucket,
	}
}

const (
	// RepositorySyncStatusInitiated is a RepositorySyncStatus enum value
	RepositorySyncStatusInitiated = "INITIATED"

	// RepositorySyncStatusInProgress is a RepositorySyncStatus enum value
	RepositorySyncStatusInProgress = "IN_PROGRESS"

	// RepositorySyncStatusSucceeded is a RepositorySyncStatus enum value
	RepositorySyncStatusSucceeded = "SUCCEEDED"

	// RepositorySyncStatusFailed is a RepositorySyncStatus enum value
	RepositorySyncStatusFailed = "FAILED"

	// RepositorySyncStatusQueued is a RepositorySyncStatus enum value
	RepositorySyncStatusQueued = "QUEUED"
)

// RepositorySyncStatus_Values returns all elements of the RepositorySyncStatus enum
func RepositorySyncStatus_Values() []string {
	return []string{
		RepositorySyncStatusInitiated,
		RepositorySyncStatusInProgress,
		RepositorySyncStatusSucceeded,
		RepositorySyncStatusFailed,
		RepositorySyncStatusQueued,
	}
}

// The state that a PR-based deployment can be updated to.
const (
	// ResourceDeploymentStatusInProgress is a ResourceDeploymentStatus enum value
	ResourceDeploymentStatusInProgress = "IN_PROGRESS"

	// ResourceDeploymentStatusFailed is a ResourceDeploymentStatus enum value
	ResourceDeploymentStatusFailed = "FAILED"

	// ResourceDeploymentStatusSucceeded is a ResourceDeploymentStatus enum value
	ResourceDeploymentStatusSucceeded = "SUCCEEDED"
)

// ResourceDeploymentStatus_Values returns all elements of the ResourceDeploymentStatus enum
func ResourceDeploymentStatus_Values() []string {
	return []string{
		ResourceDeploymentStatusInProgress,
		ResourceDeploymentStatusFailed,
		ResourceDeploymentStatusSucceeded,
	}
}

const (
	// ResourceSyncStatusInitiated is a ResourceSyncStatus enum value
	ResourceSyncStatusInitiated = "INITIATED"

	// ResourceSyncStatusInProgress is a ResourceSyncStatus enum value
	ResourceSyncStatusInProgress = "IN_PROGRESS"

	// ResourceSyncStatusSucceeded is a ResourceSyncStatus enum value
	ResourceSyncStatusSucceeded = "SUCCEEDED"

	// ResourceSyncStatusFailed is a ResourceSyncStatus enum value
	ResourceSyncStatusFailed = "FAILED"
)

// ResourceSyncStatus_Values returns all elements of the ResourceSyncStatus enum
func ResourceSyncStatus_Values() []string {
	return []string{
		ResourceSyncStatusInitiated,
		ResourceSyncStatusInProgress,
		ResourceSyncStatusSucceeded,
		ResourceSyncStatusFailed,
	}
}

const (
	// ServiceStatusCreateInProgress is a ServiceStatus enum value
	ServiceStatusCreateInProgress = "CREATE_IN_PROGRESS"

	// ServiceStatusCreateFailedCleanupInProgress is a ServiceStatus enum value
	ServiceStatusCreateFailedCleanupInProgress = "CREATE_FAILED_CLEANUP_IN_PROGRESS"

	// ServiceStatusCreateFailedCleanupComplete is a ServiceStatus enum value
	ServiceStatusCreateFailedCleanupComplete = "CREATE_FAILED_CLEANUP_COMPLETE"

	// ServiceStatusCreateFailedCleanupFailed is a ServiceStatus enum value
	ServiceStatusCreateFailedCleanupFailed = "CREATE_FAILED_CLEANUP_FAILED"

	// ServiceStatusCreateFailed is a ServiceStatus enum value
	ServiceStatusCreateFailed = "CREATE_FAILED"

	// ServiceStatusActive is a ServiceStatus enum value
	ServiceStatusActive = "ACTIVE"

	// ServiceStatusDeleteInProgress is a ServiceStatus enum value
	ServiceStatusDeleteInProgress = "DELETE_IN_PROGRESS"

	// ServiceStatusDeleteFailed is a ServiceStatus enum value
	ServiceStatusDeleteFailed = "DELETE_FAILED"

	// ServiceStatusUpdateInProgress is a ServiceStatus enum value
	ServiceStatusUpdateInProgress = "UPDATE_IN_PROGRESS"

	// ServiceStatusUpdateFailedCleanupInProgress is a ServiceStatus enum value
	ServiceStatusUpdateFailedCleanupInProgress = "UPDATE_FAILED_CLEANUP_IN_PROGRESS"

	// ServiceStatusUpdateFailedCleanupComplete is a ServiceStatus enum value
	ServiceStatusUpdateFailedCleanupComplete = "UPDATE_FAILED_CLEANUP_COMPLETE"

	// ServiceStatusUpdateFailedCleanupFailed is a ServiceStatus enum value
	ServiceStatusUpdateFailedCleanupFailed = "UPDATE_FAILED_CLEANUP_FAILED"

	// ServiceStatusUpdateFailed is a ServiceStatus enum value
	ServiceStatusUpdateFailed = "UPDATE_FAILED"

	// ServiceStatusUpdateCompleteCleanupFailed is a ServiceStatus enum value
	ServiceStatusUpdateCompleteCleanupFailed = "UPDATE_COMPLETE_CLEANUP_FAILED"
)

// ServiceStatus_Values returns all elements of the ServiceStatus enum
func ServiceStatus_Values() []string {
	return []string{
		ServiceStatusCreateInProgress,
		ServiceStatusCreateFailedCleanupInProgress,
		ServiceStatusCreateFailedCleanupComplete,
		ServiceStatusCreateFailedCleanupFailed,
		ServiceStatusCreateFailed,
		ServiceStatusActive,
		ServiceStatusDeleteInProgress,
		ServiceStatusDeleteFailed,
		ServiceStatusUpdateInProgress,
		ServiceStatusUpdateFailedCleanupInProgress,
		ServiceStatusUpdateFailedCleanupComplete,
		ServiceStatusUpdateFailedCleanupFailed,
		ServiceStatusUpdateFailed,
		ServiceStatusUpdateCompleteCleanupFailed,
	}
}

const (
	// ServiceTemplateSupportedComponentSourceTypeDirectlyDefined is a ServiceTemplateSupportedComponentSourceType enum value
	ServiceTemplateSupportedComponentSourceTypeDirectlyDefined = "DIRECTLY_DEFINED"
)

// ServiceTemplateSupportedComponentSourceType_Values returns all elements of the ServiceTemplateSupportedComponentSourceType enum
func ServiceTemplateSupportedComponentSourceType_Values() []string {
	return []string{
		ServiceTemplateSupportedComponentSourceTypeDirectlyDefined,
	}
}

const (
	// SortOrderAscending is a SortOrder enum value
	SortOrderAscending = "ASCENDING"

	// SortOrderDescending is a SortOrder enum value
	SortOrderDescending = "DESCENDING"
)

// SortOrder_Values returns all elements of the SortOrder enum
func SortOrder_Values() []string {
	return []string{
		SortOrderAscending,
		SortOrderDescending,
	}
}

const (
	// SyncTypeTemplateSync is a SyncType enum value
	SyncTypeTemplateSync = "TEMPLATE_SYNC"

	// SyncTypeServiceSync is a SyncType enum value
	SyncTypeServiceSync = "SERVICE_SYNC"
)

// SyncType_Values returns all elements of the SyncType enum
func SyncType_Values() []string {
	return []string{
		SyncTypeTemplateSync,
		SyncTypeServiceSync,
	}
}

const (
	// TemplateTypeEnvironment is a TemplateType enum value
	TemplateTypeEnvironment = "ENVIRONMENT"

	// TemplateTypeService is a TemplateType enum value
	TemplateTypeService = "SERVICE"
)

// TemplateType_Values returns all elements of the TemplateType enum
func TemplateType_Values() []string {
	return []string{
		TemplateTypeEnvironment,
		TemplateTypeService,
	}
}

const (
	// TemplateVersionStatusRegistrationInProgress is a TemplateVersionStatus enum value
	TemplateVersionStatusRegistrationInProgress = "REGISTRATION_IN_PROGRESS"

	// TemplateVersionStatusRegistrationFailed is a TemplateVersionStatus enum value
	TemplateVersionStatusRegistrationFailed = "REGISTRATION_FAILED"

	// TemplateVersionStatusDraft is a TemplateVersionStatus enum value
	TemplateVersionStatusDraft = "DRAFT"

	// TemplateVersionStatusPublished is a TemplateVersionStatus enum value
	TemplateVersionStatusPublished = "PUBLISHED"
)

// TemplateVersionStatus_Values returns all elements of the TemplateVersionStatus enum
func TemplateVersionStatus_Values() []string {
	return []string{
		TemplateVersionStatusRegistrationInProgress,
		TemplateVersionStatusRegistrationFailed,
		TemplateVersionStatusDraft,
		TemplateVersionStatusPublished,
	}
}
