//go:build !ignore_autogenerated
// +build !ignore_autogenerated

/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by conversion-gen. DO NOT EDIT.

package v1alpha1

import (
	unsafe "unsafe"

	certificatesv1alpha1 "k8s.io/api/certificates/v1alpha1"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	conversion "k8s.io/apimachinery/pkg/conversion"
	runtime "k8s.io/apimachinery/pkg/runtime"
	types "k8s.io/apimachinery/pkg/types"
	certificates "k8s.io/kubernetes/pkg/apis/certificates"
)

func init() {
	localSchemeBuilder.Register(RegisterConversions)
}

// RegisterConversions adds conversion functions to the given scheme.
// Public to allow building arbitrary schemes.
func RegisterConversions(s *runtime.Scheme) error {
	if err := s.AddGeneratedConversionFunc((*certificatesv1alpha1.ClusterTrustBundle)(nil), (*certificates.ClusterTrustBundle)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_ClusterTrustBundle_To_certificates_ClusterTrustBundle(a.(*certificatesv1alpha1.ClusterTrustBundle), b.(*certificates.ClusterTrustBundle), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*certificates.ClusterTrustBundle)(nil), (*certificatesv1alpha1.ClusterTrustBundle)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_certificates_ClusterTrustBundle_To_v1alpha1_ClusterTrustBundle(a.(*certificates.ClusterTrustBundle), b.(*certificatesv1alpha1.ClusterTrustBundle), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*certificatesv1alpha1.ClusterTrustBundleList)(nil), (*certificates.ClusterTrustBundleList)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_ClusterTrustBundleList_To_certificates_ClusterTrustBundleList(a.(*certificatesv1alpha1.ClusterTrustBundleList), b.(*certificates.ClusterTrustBundleList), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*certificates.ClusterTrustBundleList)(nil), (*certificatesv1alpha1.ClusterTrustBundleList)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_certificates_ClusterTrustBundleList_To_v1alpha1_ClusterTrustBundleList(a.(*certificates.ClusterTrustBundleList), b.(*certificatesv1alpha1.ClusterTrustBundleList), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*certificatesv1alpha1.ClusterTrustBundleSpec)(nil), (*certificates.ClusterTrustBundleSpec)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_ClusterTrustBundleSpec_To_certificates_ClusterTrustBundleSpec(a.(*certificatesv1alpha1.ClusterTrustBundleSpec), b.(*certificates.ClusterTrustBundleSpec), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*certificates.ClusterTrustBundleSpec)(nil), (*certificatesv1alpha1.ClusterTrustBundleSpec)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_certificates_ClusterTrustBundleSpec_To_v1alpha1_ClusterTrustBundleSpec(a.(*certificates.ClusterTrustBundleSpec), b.(*certificatesv1alpha1.ClusterTrustBundleSpec), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*certificatesv1alpha1.PodCertificateRequest)(nil), (*certificates.PodCertificateRequest)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_PodCertificateRequest_To_certificates_PodCertificateRequest(a.(*certificatesv1alpha1.PodCertificateRequest), b.(*certificates.PodCertificateRequest), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*certificates.PodCertificateRequest)(nil), (*certificatesv1alpha1.PodCertificateRequest)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_certificates_PodCertificateRequest_To_v1alpha1_PodCertificateRequest(a.(*certificates.PodCertificateRequest), b.(*certificatesv1alpha1.PodCertificateRequest), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*certificatesv1alpha1.PodCertificateRequestList)(nil), (*certificates.PodCertificateRequestList)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_PodCertificateRequestList_To_certificates_PodCertificateRequestList(a.(*certificatesv1alpha1.PodCertificateRequestList), b.(*certificates.PodCertificateRequestList), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*certificates.PodCertificateRequestList)(nil), (*certificatesv1alpha1.PodCertificateRequestList)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_certificates_PodCertificateRequestList_To_v1alpha1_PodCertificateRequestList(a.(*certificates.PodCertificateRequestList), b.(*certificatesv1alpha1.PodCertificateRequestList), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*certificatesv1alpha1.PodCertificateRequestSpec)(nil), (*certificates.PodCertificateRequestSpec)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_PodCertificateRequestSpec_To_certificates_PodCertificateRequestSpec(a.(*certificatesv1alpha1.PodCertificateRequestSpec), b.(*certificates.PodCertificateRequestSpec), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*certificates.PodCertificateRequestSpec)(nil), (*certificatesv1alpha1.PodCertificateRequestSpec)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_certificates_PodCertificateRequestSpec_To_v1alpha1_PodCertificateRequestSpec(a.(*certificates.PodCertificateRequestSpec), b.(*certificatesv1alpha1.PodCertificateRequestSpec), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*certificatesv1alpha1.PodCertificateRequestStatus)(nil), (*certificates.PodCertificateRequestStatus)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha1_PodCertificateRequestStatus_To_certificates_PodCertificateRequestStatus(a.(*certificatesv1alpha1.PodCertificateRequestStatus), b.(*certificates.PodCertificateRequestStatus), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*certificates.PodCertificateRequestStatus)(nil), (*certificatesv1alpha1.PodCertificateRequestStatus)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_certificates_PodCertificateRequestStatus_To_v1alpha1_PodCertificateRequestStatus(a.(*certificates.PodCertificateRequestStatus), b.(*certificatesv1alpha1.PodCertificateRequestStatus), scope)
	}); err != nil {
		return err
	}
	return nil
}

func autoConvert_v1alpha1_ClusterTrustBundle_To_certificates_ClusterTrustBundle(in *certificatesv1alpha1.ClusterTrustBundle, out *certificates.ClusterTrustBundle, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if err := Convert_v1alpha1_ClusterTrustBundleSpec_To_certificates_ClusterTrustBundleSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	return nil
}

// Convert_v1alpha1_ClusterTrustBundle_To_certificates_ClusterTrustBundle is an autogenerated conversion function.
func Convert_v1alpha1_ClusterTrustBundle_To_certificates_ClusterTrustBundle(in *certificatesv1alpha1.ClusterTrustBundle, out *certificates.ClusterTrustBundle, s conversion.Scope) error {
	return autoConvert_v1alpha1_ClusterTrustBundle_To_certificates_ClusterTrustBundle(in, out, s)
}

func autoConvert_certificates_ClusterTrustBundle_To_v1alpha1_ClusterTrustBundle(in *certificates.ClusterTrustBundle, out *certificatesv1alpha1.ClusterTrustBundle, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if err := Convert_certificates_ClusterTrustBundleSpec_To_v1alpha1_ClusterTrustBundleSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	return nil
}

// Convert_certificates_ClusterTrustBundle_To_v1alpha1_ClusterTrustBundle is an autogenerated conversion function.
func Convert_certificates_ClusterTrustBundle_To_v1alpha1_ClusterTrustBundle(in *certificates.ClusterTrustBundle, out *certificatesv1alpha1.ClusterTrustBundle, s conversion.Scope) error {
	return autoConvert_certificates_ClusterTrustBundle_To_v1alpha1_ClusterTrustBundle(in, out, s)
}

func autoConvert_v1alpha1_ClusterTrustBundleList_To_certificates_ClusterTrustBundleList(in *certificatesv1alpha1.ClusterTrustBundleList, out *certificates.ClusterTrustBundleList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	out.Items = *(*[]certificates.ClusterTrustBundle)(unsafe.Pointer(&in.Items))
	return nil
}

// Convert_v1alpha1_ClusterTrustBundleList_To_certificates_ClusterTrustBundleList is an autogenerated conversion function.
func Convert_v1alpha1_ClusterTrustBundleList_To_certificates_ClusterTrustBundleList(in *certificatesv1alpha1.ClusterTrustBundleList, out *certificates.ClusterTrustBundleList, s conversion.Scope) error {
	return autoConvert_v1alpha1_ClusterTrustBundleList_To_certificates_ClusterTrustBundleList(in, out, s)
}

func autoConvert_certificates_ClusterTrustBundleList_To_v1alpha1_ClusterTrustBundleList(in *certificates.ClusterTrustBundleList, out *certificatesv1alpha1.ClusterTrustBundleList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	out.Items = *(*[]certificatesv1alpha1.ClusterTrustBundle)(unsafe.Pointer(&in.Items))
	return nil
}

// Convert_certificates_ClusterTrustBundleList_To_v1alpha1_ClusterTrustBundleList is an autogenerated conversion function.
func Convert_certificates_ClusterTrustBundleList_To_v1alpha1_ClusterTrustBundleList(in *certificates.ClusterTrustBundleList, out *certificatesv1alpha1.ClusterTrustBundleList, s conversion.Scope) error {
	return autoConvert_certificates_ClusterTrustBundleList_To_v1alpha1_ClusterTrustBundleList(in, out, s)
}

func autoConvert_v1alpha1_ClusterTrustBundleSpec_To_certificates_ClusterTrustBundleSpec(in *certificatesv1alpha1.ClusterTrustBundleSpec, out *certificates.ClusterTrustBundleSpec, s conversion.Scope) error {
	out.SignerName = in.SignerName
	out.TrustBundle = in.TrustBundle
	return nil
}

// Convert_v1alpha1_ClusterTrustBundleSpec_To_certificates_ClusterTrustBundleSpec is an autogenerated conversion function.
func Convert_v1alpha1_ClusterTrustBundleSpec_To_certificates_ClusterTrustBundleSpec(in *certificatesv1alpha1.ClusterTrustBundleSpec, out *certificates.ClusterTrustBundleSpec, s conversion.Scope) error {
	return autoConvert_v1alpha1_ClusterTrustBundleSpec_To_certificates_ClusterTrustBundleSpec(in, out, s)
}

func autoConvert_certificates_ClusterTrustBundleSpec_To_v1alpha1_ClusterTrustBundleSpec(in *certificates.ClusterTrustBundleSpec, out *certificatesv1alpha1.ClusterTrustBundleSpec, s conversion.Scope) error {
	out.SignerName = in.SignerName
	out.TrustBundle = in.TrustBundle
	return nil
}

// Convert_certificates_ClusterTrustBundleSpec_To_v1alpha1_ClusterTrustBundleSpec is an autogenerated conversion function.
func Convert_certificates_ClusterTrustBundleSpec_To_v1alpha1_ClusterTrustBundleSpec(in *certificates.ClusterTrustBundleSpec, out *certificatesv1alpha1.ClusterTrustBundleSpec, s conversion.Scope) error {
	return autoConvert_certificates_ClusterTrustBundleSpec_To_v1alpha1_ClusterTrustBundleSpec(in, out, s)
}

func autoConvert_v1alpha1_PodCertificateRequest_To_certificates_PodCertificateRequest(in *certificatesv1alpha1.PodCertificateRequest, out *certificates.PodCertificateRequest, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if err := Convert_v1alpha1_PodCertificateRequestSpec_To_certificates_PodCertificateRequestSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	if err := Convert_v1alpha1_PodCertificateRequestStatus_To_certificates_PodCertificateRequestStatus(&in.Status, &out.Status, s); err != nil {
		return err
	}
	return nil
}

// Convert_v1alpha1_PodCertificateRequest_To_certificates_PodCertificateRequest is an autogenerated conversion function.
func Convert_v1alpha1_PodCertificateRequest_To_certificates_PodCertificateRequest(in *certificatesv1alpha1.PodCertificateRequest, out *certificates.PodCertificateRequest, s conversion.Scope) error {
	return autoConvert_v1alpha1_PodCertificateRequest_To_certificates_PodCertificateRequest(in, out, s)
}

func autoConvert_certificates_PodCertificateRequest_To_v1alpha1_PodCertificateRequest(in *certificates.PodCertificateRequest, out *certificatesv1alpha1.PodCertificateRequest, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if err := Convert_certificates_PodCertificateRequestSpec_To_v1alpha1_PodCertificateRequestSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	if err := Convert_certificates_PodCertificateRequestStatus_To_v1alpha1_PodCertificateRequestStatus(&in.Status, &out.Status, s); err != nil {
		return err
	}
	return nil
}

// Convert_certificates_PodCertificateRequest_To_v1alpha1_PodCertificateRequest is an autogenerated conversion function.
func Convert_certificates_PodCertificateRequest_To_v1alpha1_PodCertificateRequest(in *certificates.PodCertificateRequest, out *certificatesv1alpha1.PodCertificateRequest, s conversion.Scope) error {
	return autoConvert_certificates_PodCertificateRequest_To_v1alpha1_PodCertificateRequest(in, out, s)
}

func autoConvert_v1alpha1_PodCertificateRequestList_To_certificates_PodCertificateRequestList(in *certificatesv1alpha1.PodCertificateRequestList, out *certificates.PodCertificateRequestList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	out.Items = *(*[]certificates.PodCertificateRequest)(unsafe.Pointer(&in.Items))
	return nil
}

// Convert_v1alpha1_PodCertificateRequestList_To_certificates_PodCertificateRequestList is an autogenerated conversion function.
func Convert_v1alpha1_PodCertificateRequestList_To_certificates_PodCertificateRequestList(in *certificatesv1alpha1.PodCertificateRequestList, out *certificates.PodCertificateRequestList, s conversion.Scope) error {
	return autoConvert_v1alpha1_PodCertificateRequestList_To_certificates_PodCertificateRequestList(in, out, s)
}

func autoConvert_certificates_PodCertificateRequestList_To_v1alpha1_PodCertificateRequestList(in *certificates.PodCertificateRequestList, out *certificatesv1alpha1.PodCertificateRequestList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	out.Items = *(*[]certificatesv1alpha1.PodCertificateRequest)(unsafe.Pointer(&in.Items))
	return nil
}

// Convert_certificates_PodCertificateRequestList_To_v1alpha1_PodCertificateRequestList is an autogenerated conversion function.
func Convert_certificates_PodCertificateRequestList_To_v1alpha1_PodCertificateRequestList(in *certificates.PodCertificateRequestList, out *certificatesv1alpha1.PodCertificateRequestList, s conversion.Scope) error {
	return autoConvert_certificates_PodCertificateRequestList_To_v1alpha1_PodCertificateRequestList(in, out, s)
}

func autoConvert_v1alpha1_PodCertificateRequestSpec_To_certificates_PodCertificateRequestSpec(in *certificatesv1alpha1.PodCertificateRequestSpec, out *certificates.PodCertificateRequestSpec, s conversion.Scope) error {
	out.SignerName = in.SignerName
	out.PodName = in.PodName
	out.PodUID = types.UID(in.PodUID)
	out.ServiceAccountName = in.ServiceAccountName
	out.ServiceAccountUID = types.UID(in.ServiceAccountUID)
	out.NodeName = types.NodeName(in.NodeName)
	out.NodeUID = types.UID(in.NodeUID)
	out.MaxExpirationSeconds = (*int32)(unsafe.Pointer(in.MaxExpirationSeconds))
	out.PKIXPublicKey = *(*[]byte)(unsafe.Pointer(&in.PKIXPublicKey))
	out.ProofOfPossession = *(*[]byte)(unsafe.Pointer(&in.ProofOfPossession))
	return nil
}

// Convert_v1alpha1_PodCertificateRequestSpec_To_certificates_PodCertificateRequestSpec is an autogenerated conversion function.
func Convert_v1alpha1_PodCertificateRequestSpec_To_certificates_PodCertificateRequestSpec(in *certificatesv1alpha1.PodCertificateRequestSpec, out *certificates.PodCertificateRequestSpec, s conversion.Scope) error {
	return autoConvert_v1alpha1_PodCertificateRequestSpec_To_certificates_PodCertificateRequestSpec(in, out, s)
}

func autoConvert_certificates_PodCertificateRequestSpec_To_v1alpha1_PodCertificateRequestSpec(in *certificates.PodCertificateRequestSpec, out *certificatesv1alpha1.PodCertificateRequestSpec, s conversion.Scope) error {
	out.SignerName = in.SignerName
	out.PodName = in.PodName
	out.PodUID = types.UID(in.PodUID)
	out.ServiceAccountName = in.ServiceAccountName
	out.ServiceAccountUID = types.UID(in.ServiceAccountUID)
	out.NodeName = types.NodeName(in.NodeName)
	out.NodeUID = types.UID(in.NodeUID)
	out.MaxExpirationSeconds = (*int32)(unsafe.Pointer(in.MaxExpirationSeconds))
	out.PKIXPublicKey = *(*[]byte)(unsafe.Pointer(&in.PKIXPublicKey))
	out.ProofOfPossession = *(*[]byte)(unsafe.Pointer(&in.ProofOfPossession))
	return nil
}

// Convert_certificates_PodCertificateRequestSpec_To_v1alpha1_PodCertificateRequestSpec is an autogenerated conversion function.
func Convert_certificates_PodCertificateRequestSpec_To_v1alpha1_PodCertificateRequestSpec(in *certificates.PodCertificateRequestSpec, out *certificatesv1alpha1.PodCertificateRequestSpec, s conversion.Scope) error {
	return autoConvert_certificates_PodCertificateRequestSpec_To_v1alpha1_PodCertificateRequestSpec(in, out, s)
}

func autoConvert_v1alpha1_PodCertificateRequestStatus_To_certificates_PodCertificateRequestStatus(in *certificatesv1alpha1.PodCertificateRequestStatus, out *certificates.PodCertificateRequestStatus, s conversion.Scope) error {
	out.Conditions = *(*[]v1.Condition)(unsafe.Pointer(&in.Conditions))
	out.CertificateChain = in.CertificateChain
	out.NotBefore = (*v1.Time)(unsafe.Pointer(in.NotBefore))
	out.BeginRefreshAt = (*v1.Time)(unsafe.Pointer(in.BeginRefreshAt))
	out.NotAfter = (*v1.Time)(unsafe.Pointer(in.NotAfter))
	return nil
}

// Convert_v1alpha1_PodCertificateRequestStatus_To_certificates_PodCertificateRequestStatus is an autogenerated conversion function.
func Convert_v1alpha1_PodCertificateRequestStatus_To_certificates_PodCertificateRequestStatus(in *certificatesv1alpha1.PodCertificateRequestStatus, out *certificates.PodCertificateRequestStatus, s conversion.Scope) error {
	return autoConvert_v1alpha1_PodCertificateRequestStatus_To_certificates_PodCertificateRequestStatus(in, out, s)
}

func autoConvert_certificates_PodCertificateRequestStatus_To_v1alpha1_PodCertificateRequestStatus(in *certificates.PodCertificateRequestStatus, out *certificatesv1alpha1.PodCertificateRequestStatus, s conversion.Scope) error {
	out.Conditions = *(*[]v1.Condition)(unsafe.Pointer(&in.Conditions))
	out.CertificateChain = in.CertificateChain
	out.NotBefore = (*v1.Time)(unsafe.Pointer(in.NotBefore))
	out.BeginRefreshAt = (*v1.Time)(unsafe.Pointer(in.BeginRefreshAt))
	out.NotAfter = (*v1.Time)(unsafe.Pointer(in.NotAfter))
	return nil
}

// Convert_certificates_PodCertificateRequestStatus_To_v1alpha1_PodCertificateRequestStatus is an autogenerated conversion function.
func Convert_certificates_PodCertificateRequestStatus_To_v1alpha1_PodCertificateRequestStatus(in *certificates.PodCertificateRequestStatus, out *certificatesv1alpha1.PodCertificateRequestStatus, s conversion.Scope) error {
	return autoConvert_certificates_PodCertificateRequestStatus_To_v1alpha1_PodCertificateRequestStatus(in, out, s)
}
