//simple tool to read the particle configs and generate a header file for inclusion in the engine.
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

struct
{
	char filename[64];
	char *ifdef;
} effects[] =
{
	{"spikeset.cfg"},
	{"faithful.cfg"},
	{"highfps.cfg"},
	{"high.cfg"},
	{"minimal.cfg"},
	{"h2part.cfg", "#ifdef HEXEN2\n"},
	{"q2part.cfg", "#ifdef Q2CLIENT\n"},
	{"tsshaft.cfg"},
	{""}
};

int main(void)
{
	FILE *c, *h, *s;
	char line[1024], *f;
	int i, j;
	c = fopen("../client/r_partset.c", "wt");
	h = fopen("../client/r_partset.h", "wt");

	if (!c || !h)
	{
		printf("unable to open a file\n");
		return EXIT_FAILURE;
	}

	fprintf(h, "/*\nWARNING: THIS FILE IS GENERATED BY '"__FILE__"'.\nYOU SHOULD NOT EDIT THIS FILE BY HAND\n*/\n\n");
	fprintf(c, "/*\nWARNING: THIS FILE IS GENERATED BY '"__FILE__"'.\nYOU SHOULD NOT EDIT THIS FILE BY HAND\n*/\n\n");
	fprintf(c, "#include \"bothdefs.h\"\n");
	fprintf(c, "#ifndef QUAKETC\n");
	fprintf(h, "#ifndef QUAKETC\n");
	fprintf(c, "#include \"r_partset.h\"\n\n\n");

	for (i = 0; *effects[i].filename; i++)
	{
		s = fopen(effects[i].filename, "rt");
		if (!s)
		{
			printf("unable to open %s\n", effects[i].filename);
			return EXIT_FAILURE;
		}
		*strchr(effects[i].filename, '.') = 0;

		if (effects[i].ifdef)
			fprintf(h, "%s", effects[i].ifdef);

		fprintf(h, "extern char *particle_set_%s;\n", effects[i].filename);
		fprintf(h, "#define R_PARTSET_BUILTINS_%s {\"%s\", &particle_set_%s},\n", effects[i].filename, effects[i].filename, effects[i].filename);
		if (effects[i].ifdef)
		{
			fputs("#else\n", h);
			fprintf(h, "#define R_PARTSET_BUILTINS_%s\n", effects[i].filename);
			fputs("#endif\n", h);
		}

		if (i)
			fprintf(c, "\n\n\n//////////////////////////////////////////////////////\n\n\n");
		if (effects[i].ifdef)
			fprintf(c, "%s", effects[i].ifdef);
		fprintf(c, "char *particle_set_%s =\n", effects[i].filename);
		while(fgets(line, sizeof(line), s))
		{
			j = 0;
			while (line[j] == ' ' || line[j] == '\t')
				j++;
			if ((line[j] == '/' && line[j+1] == '/') || line[j] == '\r' || line[j] == '\n')
			{
				while (line[j])
					fputc(line[j++], c);
			}
			else
			{
				fputc('\"', c);				
				while (line[j] && line[j] != '\r' && line[j] != '\n')
				{
					if (line[j] == '\t')
						fputc(' ', c);
					else if (line[j] == '\"')
					{
						fputc('\\', c);
						fputc(line[j], c);
					}
					else
						fputc(line[j], c);
					j++;
				}
				fputs("\\n\"\n", c);
			}
		}
		fputs(";\n", c);
		if (effects[i].ifdef)
			fputs("#endif\n", c);
		fclose(s);
	}

	fputs("#define R_PARTSET_BUILTINS ", h);
	for (i = 0; *effects[i].filename; i++)
	{
		fprintf(h, "R_PARTSET_BUILTINS_%s ", effects[i].filename);
	}
	fputs("\n", h);

	fprintf(c, "#endif\n");
	fprintf(h, "#endif\n");

	fclose(h);
	fclose(c);

	return EXIT_SUCCESS;
}
