/*
**  Copyright (c) 2005-2008 Sendmail, Inc. and its suppliers.
**    All rights reserved.
**
**  Copyright (c) 2009, 2011, 2012, The Trusted Domain Project.
**    All rights reserved.
*/

#include "build-config.h"

/* system includes */
#include <sys/types.h>
#include <assert.h>
#include <string.h>
#include <stdio.h>


/* libopendkim includes */
#include "../dkim.h"

#define	MAXHEADER	4096

/*
**  MAIN -- program mainline
**
**  Parameters:
**  	The usual.
**
**  Return value:
**  	Exit status.
*/

int
main(void)
{
#ifdef TEST_KEEP_FILES
	u_int flags;
#endif /* TEST_KEEP_FILES */
	DKIM_STAT status;
	DKIM_LIB *lib;

	printf("*** check \"skip\" header and \"sign\" header lists\n");

	/* instantiate the library */
	lib = dkim_init(1, NULL, NULL);
	assert(lib != NULL);

	status = dkim_tobesigned(lib, "Received");
	assert(status == 1);

	status = dkim_tobesigned(lib, "From");
	assert(status == 1);

	status = dkim_tobesigned(lib, "To");
	assert(status == 1);

	status = dkim_tobesigned(lib, "Date");
	assert(status == 1);

	status = dkim_tobesigned(lib, "Subject");
	assert(status == 1);

	status = dkim_tobesigned(lib, "Message-ID");
	assert(status == 1);

	status = dkim_tobesigned(lib, "Cc");
	assert(status == 1);


	status = dkim_options(lib, DKIM_OP_SETOPT, DKIM_OPTS_SIGNHDRS,
		dkim_should_signhdrs, sizeof(char*)) != DKIM_STAT_OK;
	assert(status == 0);

	status = dkim_tobesigned(lib, "Received");
	assert(status == 0);

	status = dkim_tobesigned(lib, "From");
	assert(status == 1);

	status = dkim_tobesigned(lib, "To");
	assert(status == 1);

	status = dkim_tobesigned(lib, "Date");
	assert(status == 1);

	status = dkim_tobesigned(lib, "Subject");
	assert(status == 1);

	status = dkim_tobesigned(lib, "Message-ID");
	assert(status == 0);

	status = dkim_tobesigned(lib, "Cc");
	assert(status == 1);

	status = dkim_options(lib, DKIM_OP_SETOPT, DKIM_OPTS_SKIPHDRS,
		dkim_should_not_signhdrs, sizeof(char*)) != DKIM_STAT_OK;
	assert(status == 0);

	status = dkim_tobesigned(lib, "Received");
	assert(status == 0);

	status = dkim_tobesigned(lib, "From");
	assert(status == 1);

	status = dkim_tobesigned(lib, "To");
	assert(status == 1);

	status = dkim_tobesigned(lib, "Date");
	assert(status == 1);

	status = dkim_tobesigned(lib, "Subject");
	assert(status == 1);

	status = dkim_tobesigned(lib, "Message-ID");
	assert(status == 0);

	status = dkim_tobesigned(lib, "Cc");
	assert(status == 1);

	dkim_close(lib);

	return 0;
}
