/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.automation.internal.module.handler;

import java.math.BigDecimal;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.openhab.core.automation.ModuleHandlerCallback;
import org.openhab.core.automation.Trigger;
import org.openhab.core.automation.handler.BaseTriggerModuleHandler;
import org.openhab.core.automation.handler.TriggerHandlerCallback;
import org.openhab.core.events.Event;
import org.openhab.core.events.EventSubscriber;
import org.openhab.core.events.system.StartlevelEvent;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
public class SystemTriggerHandler
extends BaseTriggerModuleHandler
implements EventSubscriber {
    public static final String STARTLEVEL_MODULE_TYPE_ID = "core.SystemStartlevelTrigger";
    public static final String CFG_STARTLEVEL = "startlevel";
    public static final String OUT_STARTLEVEL = "startlevel";
    private final Logger logger = LoggerFactory.getLogger(SystemTriggerHandler.class);
    private final Integer startlevel;
    private final Set<String> types;
    private boolean triggered = false;
    private final ServiceRegistration<?> eventSubscriberRegistration;

    public SystemTriggerHandler(Trigger module, BundleContext bundleContext) {
        super(module);
        this.startlevel = ((BigDecimal)module.getConfiguration().get("startlevel")).intValue();
        if (!STARTLEVEL_MODULE_TYPE_ID.equals(module.getTypeUID())) {
            this.logger.warn("Module type '{}' is not (yet) handled by this class.", (Object)module.getTypeUID());
            throw new IllegalArgumentException(module.getTypeUID() + " is no valid module type.");
        }
        this.types = Set.of(StartlevelEvent.TYPE);
        this.eventSubscriberRegistration = bundleContext.registerService(EventSubscriber.class.getName(), (Object)this, null);
    }

    @Override
    public void setCallback(ModuleHandlerCallback callback) {
        super.setCallback(callback);
    }

    public Set<String> getSubscribedEventTypes() {
        return this.types;
    }

    public void receive(Event event) {
        if (this.triggered) {
            return;
        }
        this.logger.trace("Received Event: Source: {} Topic: {} Type: {}  Payload: {}", new Object[]{event.getSource(), event.getTopic(), event.getType(), event.getPayload()});
        if (event instanceof StartlevelEvent) {
            StartlevelEvent startlevelEvent = (StartlevelEvent)event;
            if (STARTLEVEL_MODULE_TYPE_ID.equals(((Trigger)this.module).getTypeUID())) {
                Integer sl = startlevelEvent.getStartlevel();
                if (this.startlevel <= sl && this.startlevel > 50) {
                    this.trigger(event);
                }
            }
        }
    }

    @Override
    public void dispose() {
        this.eventSubscriberRegistration.unregister();
        super.dispose();
    }

    private void trigger(Event event) {
        ModuleHandlerCallback callback = this.callback;
        if (!(callback instanceof TriggerHandlerCallback)) {
            return;
        }
        TriggerHandlerCallback thCallback = (TriggerHandlerCallback)callback;
        Map<String, Event> values = Map.of("startlevel", this.startlevel, "event", event);
        thCallback.triggered((Trigger)this.module, values);
        this.triggered = true;
    }
}

