package githubapi

import (
	"encoding/json"
	"fmt"
)

var mockTreeUrl = `{"sha":"e03c6e27ef88e1bd30902b7a6258f0a54e01c2c7","url":"https://api.github.com/repos/kubescape/go-git-url/git/trees/e03c6e27ef88e1bd30902b7a6258f0a54e01c2c7","tree":[{"path":".vscode","mode":"040000","type":"tree","sha":"d58bd8e47da3a8fb24ffd678916563e1cdf1ebaa","url":"https://api.github.com/repos/kubescape/go-git-url/git/trees/d58bd8e47da3a8fb24ffd678916563e1cdf1ebaa"},{"path":".vscode/settings.json","mode":"100644","type":"blob","sha":"a7e16169143195e2a711f051bdbfcfb08088db2e","size":54,"url":"https://api.github.com/repos/kubescape/go-git-url/git/blobs/a7e16169143195e2a711f051bdbfcfb08088db2e"},{"path":"LICENSE","mode":"100644","type":"blob","sha":"261eeb9e9f8b2b4b0d119366dda99c6fd7d35c64","size":11357,"url":"https://api.github.com/repos/kubescape/go-git-url/git/blobs/261eeb9e9f8b2b4b0d119366dda99c6fd7d35c64"},{"path":"README.md","mode":"100644","type":"blob","sha":"ea1a34a54f88f528e6864bc7cbf32cf2d794b964","size":1033,"url":"https://api.github.com/repos/kubescape/go-git-url/git/blobs/ea1a34a54f88f528e6864bc7cbf32cf2d794b964"},{"path":"apis","mode":"040000","type":"tree","sha":"702eeb95f9ed5b124ce84a96a9205f49b7c7379c","url":"https://api.github.com/repos/kubescape/go-git-url/git/trees/702eeb95f9ed5b124ce84a96a9205f49b7c7379c"},{"path":"apis/githubapi","mode":"040000","type":"tree","sha":"eebffec78929c432e2c7f63d9c53e5ef3de9d54c","url":"https://api.github.com/repos/kubescape/go-git-url/git/trees/eebffec78929c432e2c7f63d9c53e5ef3de9d54c"},{"path":"apis/githubapi/apis.go","mode":"100644","type":"blob","sha":"ba744632d38f23a3e8813ea1a9ab55c58f2ca450","size":1360,"url":"https://api.github.com/repos/kubescape/go-git-url/git/blobs/ba744632d38f23a3e8813ea1a9ab55c58f2ca450"},{"path":"apis/githubapi/datastructures.go","mode":"100644","type":"blob","sha":"57286350dd1cc21f9074c566c685046005299d35","size":256,"url":"https://api.github.com/repos/kubescape/go-git-url/git/blobs/57286350dd1cc21f9074c566c685046005299d35"},{"path":"apis/githubapi/methods.go","mode":"100644","type":"blob","sha":"c71f7fe3f62757473aef30a7613fbb2052bbe7ef","size":426,"url":"https://api.github.com/repos/kubescape/go-git-url/git/blobs/c71f7fe3f62757473aef30a7613fbb2052bbe7ef"},{"path":"apis/http.go","mode":"100644","type":"blob","sha":"e65dcd117797fd02fa7b02a7d4813a15cc6e7289","size":1869,"url":"https://api.github.com/repos/kubescape/go-git-url/git/blobs/e65dcd117797fd02fa7b02a7d4813a15cc6e7289"},{"path":"files","mode":"040000","type":"tree","sha":"57c59318121a8918f6ff259cdd3306c249215fdc","url":"https://api.github.com/repos/kubescape/go-git-url/git/trees/57c59318121a8918f6ff259cdd3306c249215fdc"},{"path":"files/file0.json","mode":"100644","type":"blob","sha":"ae85c07ec156f563e2d4184ce292219321f415ec","size":17,"url":"https://api.github.com/repos/kubescape/go-git-url/git/blobs/ae85c07ec156f563e2d4184ce292219321f415ec"},{"path":"files/file0.text","mode":"100644","type":"blob","sha":"e25bb064ec2d827c3a4a3a93797642e6d9b9b1f3","size":10,"url":"https://api.github.com/repos/kubescape/go-git-url/git/blobs/e25bb064ec2d827c3a4a3a93797642e6d9b9b1f3"},{"path":"files/file0.yaml","mode":"100644","type":"blob","sha":"31358e0ec5b5136961e0795962cdd1a0b51307ce","size":11,"url":"https://api.github.com/repos/kubescape/go-git-url/git/blobs/31358e0ec5b5136961e0795962cdd1a0b51307ce"},{"path":"files/file1.json","mode":"100644","type":"blob","sha":"41a0cb5ad5cadd8d12df5c8f493a41f370cab03d","size":17,"url":"https://api.github.com/repos/kubescape/go-git-url/git/blobs/41a0cb5ad5cadd8d12df5c8f493a41f370cab03d"},{"path":"files/file1.yaml","mode":"100644","type":"blob","sha":"cda23e65facdc68d2ea60a94715053085bacf97f","size":11,"url":"https://api.github.com/repos/kubescape/go-git-url/git/blobs/cda23e65facdc68d2ea60a94715053085bacf97f"},{"path":"files/file2.yaml","mode":"100644","type":"blob","sha":"177289fb9bc6aa7b19336111e902f92c8b4d28e7","size":11,"url":"https://api.github.com/repos/kubescape/go-git-url/git/blobs/177289fb9bc6aa7b19336111e902f92c8b4d28e7"},{"path":"githubparser","mode":"040000","type":"tree","sha":"7ca01c978d838116cca40c2fbe2a3743219abd43","url":"https://api.github.com/repos/kubescape/go-git-url/git/trees/7ca01c978d838116cca40c2fbe2a3743219abd43"},{"path":"githubparser/v1","mode":"040000","type":"tree","sha":"f7498c41927bb478faa94294ced8ad0eb0022448","url":"https://api.github.com/repos/kubescape/go-git-url/git/trees/f7498c41927bb478faa94294ced8ad0eb0022448"},{"path":"githubparser/v1/datastructures.go","mode":"100644","type":"blob","sha":"3567877260d4cdad12eeb9facac72e5e4597348b","size":250,"url":"https://api.github.com/repos/kubescape/go-git-url/git/blobs/3567877260d4cdad12eeb9facac72e5e4597348b"},{"path":"githubparser/v1/parser.go","mode":"100644","type":"blob","sha":"bafc7b5cba10cf094ebdd054158b3cfdaa4389cc","size":3997,"url":"https://api.github.com/repos/kubescape/go-git-url/git/blobs/bafc7b5cba10cf094ebdd054158b3cfdaa4389cc"},{"path":"go.mod","mode":"100644","type":"blob","sha":"f5832d5bdf68408a5a8e21f51f6f3d1bf5b8e956","size":103,"url":"https://api.github.com/repos/kubescape/go-git-url/git/blobs/f5832d5bdf68408a5a8e21f51f6f3d1bf5b8e956"},{"path":"go.sum","mode":"100644","type":"blob","sha":"207ee15dca443269452c6c96d4b4df62c48e7e5e","size":974,"url":"https://api.github.com/repos/kubescape/go-git-url/git/blobs/207ee15dca443269452c6c96d4b4df62c48e7e5e"},{"path":"init.go","mode":"100644","type":"blob","sha":"6b0a179812d9df99602f2563bcd759af1920b809","size":638,"url":"https://api.github.com/repos/kubescape/go-git-url/git/blobs/6b0a179812d9df99602f2563bcd759af1920b809"},{"path":"interface.go","mode":"100644","type":"blob","sha":"9ccf2806ef1f897d0ebf5278b3353ca25d7d1288","size":401,"url":"https://api.github.com/repos/kubescape/go-git-url/git/blobs/9ccf2806ef1f897d0ebf5278b3353ca25d7d1288"}],"truncated":false}`
var mockLastCommit = `{"sha":"e7d287e491b4002bc59d67ad7423d8119fc89e6c","node_id":"C_kwDOHK4XZ9oAKGU3ZDI4N2U0OTFiNDAwMmJjNTlkNjdhZDc0MjNkODExOWZjODllNmM","commit":{"author":{"name":"David Wertenteil","email":"dwertent@armosec.io","date":"2022-04-13T11:51:06Z"},"committer":{"name":"David Wertenteil","email":"dwertent@armosec.io","date":"2022-04-13T11:51:06Z"},"message":"updated interface","tree":{"sha":"fa28de192d078a748266ca0faf2ec0663ec40748","url":"https://api.github.com/repos/kubescape/go-git-url/git/trees/fa28de192d078a748266ca0faf2ec0663ec40748"},"url":"https://api.github.com/repos/kubescape/go-git-url/git/commits/e7d287e491b4002bc59d67ad7423d8119fc89e6c","comment_count":0,"verification":{"verified":false,"reason":"unsigned","signature":null,"payload":null}},"url":"https://api.github.com/repos/kubescape/go-git-url/commits/e7d287e491b4002bc59d67ad7423d8119fc89e6c","html_url":"https://github.com/kubescape/go-git-url/commit/e7d287e491b4002bc59d67ad7423d8119fc89e6c","comments_url":"https://api.github.com/repos/kubescape/go-git-url/commits/e7d287e491b4002bc59d67ad7423d8119fc89e6c/comments","author":{"login":"dwertent","id":64066841,"node_id":"MDQ6VXNlcjY0MDY2ODQx","avatar_url":"https://avatars.githubusercontent.com/u/64066841?v=4","gravatar_id":"","url":"https://api.github.com/users/dwertent","html_url":"https://github.com/dwertent","followers_url":"https://api.github.com/users/dwertent/followers","following_url":"https://api.github.com/users/dwertent/following{/other_user}","gists_url":"https://api.github.com/users/dwertent/gists{/gist_id}","starred_url":"https://api.github.com/users/dwertent/starred{/owner}{/repo}","subscriptions_url":"https://api.github.com/users/dwertent/subscriptions","organizations_url":"https://api.github.com/users/dwertent/orgs","repos_url":"https://api.github.com/users/dwertent/repos","events_url":"https://api.github.com/users/dwertent/events{/privacy}","received_events_url":"https://api.github.com/users/dwertent/received_events","type":"User","site_admin":false},"committer":{"login":"dwertent","id":64066841,"node_id":"MDQ6VXNlcjY0MDY2ODQx","avatar_url":"https://avatars.githubusercontent.com/u/64066841?v=4","gravatar_id":"","url":"https://api.github.com/users/dwertent","html_url":"https://github.com/dwertent","followers_url":"https://api.github.com/users/dwertent/followers","following_url":"https://api.github.com/users/dwertent/following{/other_user}","gists_url":"https://api.github.com/users/dwertent/gists{/gist_id}","starred_url":"https://api.github.com/users/dwertent/starred{/owner}{/repo}","subscriptions_url":"https://api.github.com/users/dwertent/subscriptions","organizations_url":"https://api.github.com/users/dwertent/orgs","repos_url":"https://api.github.com/users/dwertent/repos","events_url":"https://api.github.com/users/dwertent/events{/privacy}","received_events_url":"https://api.github.com/users/dwertent/received_events","type":"User","site_admin":false},"parents":[{"sha":"f7ffc4f4dc6b2793f12e4dd708a2fe1ac95fbe8f","url":"https://api.github.com/repos/kubescape/go-git-url/commits/f7ffc4f4dc6b2793f12e4dd708a2fe1ac95fbe8f","html_url":"https://github.com/kubescape/go-git-url/commit/f7ffc4f4dc6b2793f12e4dd708a2fe1ac95fbe8f"}],"stats":{"total":24,"additions":15,"deletions":9},"files":[{"sha":"f0c7b60d418d66a1a724afd5471b7eeb9bcb5900","filename":"init_test.go","status":"modified","additions":7,"deletions":5,"changes":12,"blob_url":"https://github.com/kubescape/go-git-url/blob/e7d287e491b4002bc59d67ad7423d8119fc89e6c/init_test.go","raw_url":"https://github.com/kubescape/go-git-url/raw/e7d287e491b4002bc59d67ad7423d8119fc89e6c/init_test.go","contents_url":"https://api.github.com/repos/kubescape/go-git-url/contents/init_test.go?ref=e7d287e491b4002bc59d67ad7423d8119fc89e6c","patch":"@@ -8,8 +8,10 @@ import (\n \n func TestNewGitURL(t *testing.T) {\n \tfileText := \"https://raw.githubusercontent.com/kubescape/go-git-url/master/files/file0.text\"\n+\tvar gitURL IGitURL\n+\tvar err error\n \t{\n-\t\tgitURL, err := NewGitURL(\"https://github.com/kubescape/go-git-url\")\n+\t\tgitURL, err = NewGitURL(\"https://github.com/kubescape/go-git-url\")\n \t\tassert.NoError(t, err)\n \n \t\tfiles, err := gitURL.ListFilesNamesWithExtension([]string{\"yaml\", \"json\"})\n@@ -18,7 +20,7 @@ func TestNewGitURL(t *testing.T) {\n \t}\n \n \t{\n-\t\tgitURL, err := NewGitURL(\"https://github.com/kubescape/go-git-url\")\n+\t\tgitURL, err = NewGitURL(\"https://github.com/kubescape/go-git-url\")\n \t\tassert.NoError(t, err)\n \n \t\tfiles, errM := gitURL.DownloadFilesWithExtension([]string{\"text\"})\n@@ -29,7 +31,7 @@ func TestNewGitURL(t *testing.T) {\n \t}\n \n \t{\n-\t\tgitURL, err := NewGitURL(fileText)\n+\t\tgitURL, err = NewGitURL(fileText)\n \t\tassert.NoError(t, err)\n \n \t\tfiles, errM := gitURL.DownloadFilesWithExtension([]string{\"text\"})\n@@ -39,7 +41,7 @@ func TestNewGitURL(t *testing.T) {\n \t}\n \n \t{\n-\t\tgitURL, err := NewGitURL(fileText)\n+\t\tgitURL, err = NewGitURL(fileText)\n \t\tassert.NoError(t, err)\n \n \t\tfiles, errM := gitURL.DownloadAllFiles()\n@@ -60,7 +62,7 @@ func TestNewGitURL(t *testing.T) {\n \t}\n \n \t{\n-\t\tgitURL, err := NewGitURL(\"https://github.com/kubescape/go-git-url/blob/master/files/file0.text\")\n+\t\tgitURL, err = NewGitURL(\"https://github.com/kubescape/go-git-url/blob/master/files/file0.text\")\n \t\tassert.NoError(t, err)\n \n \t\tfiles, errM := gitURL.DownloadFilesWithExtension([]string{\"text\"})"},{"sha":"e3a8ec5fee6cf2c0450eb5466380a9afed8212d2","filename":"interface.go","status":"modified","additions":8,"deletions":4,"changes":12,"blob_url":"https://github.com/kubescape/go-git-url/blob/e7d287e491b4002bc59d67ad7423d8119fc89e6c/interface.go","raw_url":"https://github.com/kubescape/go-git-url/raw/e7d287e491b4002bc59d67ad7423d8119fc89e6c/interface.go","contents_url":"https://api.github.com/repos/kubescape/go-git-url/contents/interface.go?ref=e7d287e491b4002bc59d67ad7423d8119fc89e6c","patch":"@@ -4,19 +4,23 @@ import \"net/url\"\n \n // IGitURL parse git urls\n type IGitURL interface {\n-\n-\t// parse url\n-\tParse(fullURL string) error\n-\n \tSetBranch(string)\n \tSetOwner(string)\n \tSetPath(string)\n \tSetToken(string)\n+\tSetRepo(string)\n \n \tGetBranch() string\n \tGetOwner() string\n \tGetPath() string\n \tGetToken() string\n+\tGetRepo() string\n+\n+\t// parse url\n+\tParse(fullURL string) error\n+\n+\t// set default branch from the API\n+\tSetDefaultBranch() error\n \n \t// GetURL git url\n \tGetURL() *url.URL"}]}`

type MockGitHubAPI struct {
}

func NewMockGitHubAPI() *MockGitHubAPI { return &MockGitHubAPI{} }

func (gh *MockGitHubAPI) GetRepoTree(owner, repo, branch string, headers *Headers) (*Tree, error) {
	t := &Tree{}
	switch fmt.Sprintf("%s/%s", owner, repo) {
	case "kubescape/go-git-url":
		json.Unmarshal([]byte(mockTreeUrl), t)
	}
	return t, nil
}

func (gh MockGitHubAPI) GetDefaultBranchName(owner, repo string, headers *Headers) (string, error) {
	return "master", nil
}

func (gh MockGitHubAPI) GetLatestCommit(owner, repo, branch string, headers *Headers) (*Commit, error) {

	var data Commit

	if err := json.Unmarshal([]byte(mockLastCommit), &data); err != nil {
		return &data, err
	}
	return &data, nil
}
