// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.

/// <p>Configuration settings for enabling and controlling document citations in Converse API responses. When enabled, the model can include citation information that links generated content back to specific source documents.</p>
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::fmt::Debug)]
pub struct CitationsConfig {
    /// <p>Specifies whether document citations should be included in the model's response. When set to true, the model can generate citations that reference the source documents used to inform the response.</p>
    pub enabled: bool,
}
impl CitationsConfig {
    /// <p>Specifies whether document citations should be included in the model's response. When set to true, the model can generate citations that reference the source documents used to inform the response.</p>
    pub fn enabled(&self) -> bool {
        self.enabled
    }
}
impl CitationsConfig {
    /// Creates a new builder-style object to manufacture [`CitationsConfig`](crate::types::CitationsConfig).
    pub fn builder() -> crate::types::builders::CitationsConfigBuilder {
        crate::types::builders::CitationsConfigBuilder::default()
    }
}

/// A builder for [`CitationsConfig`](crate::types::CitationsConfig).
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::default::Default, ::std::fmt::Debug)]
#[non_exhaustive]
pub struct CitationsConfigBuilder {
    pub(crate) enabled: ::std::option::Option<bool>,
}
impl CitationsConfigBuilder {
    /// <p>Specifies whether document citations should be included in the model's response. When set to true, the model can generate citations that reference the source documents used to inform the response.</p>
    /// This field is required.
    pub fn enabled(mut self, input: bool) -> Self {
        self.enabled = ::std::option::Option::Some(input);
        self
    }
    /// <p>Specifies whether document citations should be included in the model's response. When set to true, the model can generate citations that reference the source documents used to inform the response.</p>
    pub fn set_enabled(mut self, input: ::std::option::Option<bool>) -> Self {
        self.enabled = input;
        self
    }
    /// <p>Specifies whether document citations should be included in the model's response. When set to true, the model can generate citations that reference the source documents used to inform the response.</p>
    pub fn get_enabled(&self) -> &::std::option::Option<bool> {
        &self.enabled
    }
    /// Consumes the builder and constructs a [`CitationsConfig`](crate::types::CitationsConfig).
    /// This method will fail if any of the following fields are not set:
    /// - [`enabled`](crate::types::builders::CitationsConfigBuilder::enabled)
    pub fn build(self) -> ::std::result::Result<crate::types::CitationsConfig, ::aws_smithy_types::error::operation::BuildError> {
        ::std::result::Result::Ok(crate::types::CitationsConfig {
            enabled: self.enabled.ok_or_else(|| {
                ::aws_smithy_types::error::operation::BuildError::missing_field(
                    "enabled",
                    "enabled was not specified but it is required when building CitationsConfig",
                )
            })?,
        })
    }
}
