//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::ffi::*;
use core::ptr::NonNull;
use objc2::__framework_prelude::*;
use objc2_foundation::*;

use crate::*;

extern_protocol!(
    /// Encapsulates access and mutation for a menu hierarchy.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/uikit/uimenubuilder?language=objc)
    pub unsafe trait UIMenuBuilder: MainThreadOnly {
        #[cfg(feature = "UIMenuSystem")]
        /// Which system we are building for.
        #[unsafe(method(system))]
        #[unsafe(method_family = none)]
        unsafe fn system(&self) -> Retained<UIMenuSystem>;

        #[cfg(all(feature = "UIMenu", feature = "UIMenuElement"))]
        /// Fetch the identified menu.
        ///
        ///
        /// Parameter `identifier`: The identifier of the menu to fetch.
        ///
        /// Returns: The menu with the given identifier, or `nil` if no such menu.
        #[unsafe(method(menuForIdentifier:))]
        #[unsafe(method_family = none)]
        unsafe fn menuForIdentifier(
            &self,
            identifier: &UIMenuIdentifier,
        ) -> Option<Retained<UIMenu>>;

        #[cfg(all(feature = "UIAction", feature = "UIMenuElement"))]
        /// Fetch the identified action.
        ///
        ///
        /// Parameter `identifier`: The identifier of the action to fetch.
        ///
        /// Returns: The action with the given identifier, or `nil` if no such action.
        #[unsafe(method(actionForIdentifier:))]
        #[unsafe(method_family = none)]
        unsafe fn actionForIdentifier(
            &self,
            identifier: &UIActionIdentifier,
        ) -> Option<Retained<UIAction>>;

        #[cfg(all(feature = "UICommand", feature = "UIMenuElement"))]
        /// Fetch the identified command.
        ///
        ///
        /// Parameter `action`: The action of the command to fetch.
        ///
        /// Parameter `propertyList`: Property list object to distinguish commands, if needed.
        ///
        /// Returns: The command with the given action and property list, or `nil` if no such command.
        #[unsafe(method(commandForAction:propertyList:))]
        #[unsafe(method_family = none)]
        unsafe fn commandForAction_propertyList(
            &self,
            action: Sel,
            property_list: Option<&AnyObject>,
        ) -> Option<Retained<UICommand>>;

        #[cfg(all(feature = "UIMenu", feature = "UIMenuElement"))]
        /// Replace an identified menu with a menu.
        ///
        ///
        /// Parameter `replacedIdentifier`: The identifier of the menu to be replaced.
        ///
        /// Parameter `replacementGroup`: The replacement menu.
        #[unsafe(method(replaceMenuForIdentifier:withMenu:))]
        #[unsafe(method_family = none)]
        unsafe fn replaceMenuForIdentifier_withMenu(
            &self,
            replaced_identifier: &UIMenuIdentifier,
            replacement_menu: &UIMenu,
        );

        #[cfg(all(feature = "UIMenu", feature = "UIMenuElement", feature = "block2"))]
        /// Replace the children of an identified parent menu.
        ///
        ///
        /// Parameter `parentIdentifier`: The identifier of the parent menu.
        ///
        /// Parameter `childrenBlock`: A block that returns the new children, given the old children.
        #[unsafe(method(replaceChildrenOfMenuForIdentifier:fromChildrenBlock:))]
        #[unsafe(method_family = none)]
        unsafe fn replaceChildrenOfMenuForIdentifier_fromChildrenBlock(
            &self,
            parent_identifier: &UIMenuIdentifier,
            children_block: &block2::DynBlock<
                dyn Fn(NonNull<NSArray<UIMenuElement>>) -> NonNull<NSArray<UIMenuElement>> + '_,
            >,
        );

        #[cfg(all(feature = "UIMenu", feature = "UIMenuElement"))]
        /// Insert a sibling menu before an identified sibling menu.
        ///
        ///
        /// Parameter `siblingGroup`: The sibling menu to insert.
        ///
        /// Parameter `siblingIdentifier`: The identifier of the sibling menu to insert before.
        #[unsafe(method(insertSiblingMenu:beforeMenuForIdentifier:))]
        #[unsafe(method_family = none)]
        unsafe fn insertSiblingMenu_beforeMenuForIdentifier(
            &self,
            sibling_menu: &UIMenu,
            sibling_identifier: &UIMenuIdentifier,
        );

        #[cfg(all(feature = "UIMenu", feature = "UIMenuElement"))]
        /// Insert a sibling menu after an identified sibling menu.
        ///
        ///
        /// Parameter `siblingGroup`: The sibling menu to insert.
        ///
        /// Parameter `siblingIdentifier`: The identifier of the sibling menu to insert after.
        #[unsafe(method(insertSiblingMenu:afterMenuForIdentifier:))]
        #[unsafe(method_family = none)]
        unsafe fn insertSiblingMenu_afterMenuForIdentifier(
            &self,
            sibling_menu: &UIMenu,
            sibling_identifier: &UIMenuIdentifier,
        );

        #[cfg(all(feature = "UIMenu", feature = "UIMenuElement"))]
        /// Insert a child menu at the start of an identified parent menu.
        ///
        ///
        /// Parameter `childGroup`: The child menu to insert.
        ///
        /// Parameter `parentIdentifier`: The identifier of the parent menu to insert at the start of.
        #[unsafe(method(insertChildMenu:atStartOfMenuForIdentifier:))]
        #[unsafe(method_family = none)]
        unsafe fn insertChildMenu_atStartOfMenuForIdentifier(
            &self,
            child_menu: &UIMenu,
            parent_identifier: &UIMenuIdentifier,
        );

        #[cfg(all(feature = "UIMenu", feature = "UIMenuElement"))]
        /// Insert a child menu at the end of an identified parent menu.
        ///
        ///
        /// Parameter `childGroup`: The child menu to insert.
        ///
        /// Parameter `parentIdentifier`: The identifier of the parent menu to insert at the end of.
        #[unsafe(method(insertChildMenu:atEndOfMenuForIdentifier:))]
        #[unsafe(method_family = none)]
        unsafe fn insertChildMenu_atEndOfMenuForIdentifier(
            &self,
            child_menu: &UIMenu,
            parent_identifier: &UIMenuIdentifier,
        );

        #[cfg(feature = "UIMenu")]
        /// Remove an identified menu.
        ///
        ///
        /// Parameter `removedIdentifier`: The menu to remove.
        #[unsafe(method(removeMenuForIdentifier:))]
        #[unsafe(method_family = none)]
        unsafe fn removeMenuForIdentifier(&self, removed_identifier: &UIMenuIdentifier);
    }
);
