/*
 * Decompiled with CFR 0.152.
 */
package net.gcalc.calc.math.functions;

import java.util.Vector;
import net.gcalc.calc.main.SymbolTable;
import net.gcalc.calc.main.ValueTable;
import net.gcalc.calc.math.functions.BinaryOperation;
import net.gcalc.calc.math.functions.Constant;
import net.gcalc.calc.math.functions.Function;
import net.gcalc.calc.math.functions.FunctionFactory;
import net.gcalc.calc.parser.ParseTree;

public class Multiplication
extends BinaryOperation {
    public Multiplication(ParseTree pt) {
        super(pt);
    }

    public double evaluate(SymbolTable st, ValueTable vt) {
        return this.L.evaluate(st, vt) * this.R.evaluate(st, vt);
    }

    public Function derivative(Vector vars) {
        Vector<Function> left = new Vector<Function>(2);
        Vector<Function> right = new Vector<Function>(2);
        left.add(this.L.derivative(vars));
        left.add(this.R);
        right.add(this.L);
        right.add(this.R.derivative(vars));
        Vector<Function> args = new Vector<Function>(2);
        args.add(FunctionFactory.getFunction(this.getRoot(), left));
        args.add(FunctionFactory.getFunction(this.getRoot(), right));
        return FunctionFactory.getFunction(PLUS_TOKEN, args).simplify();
    }

    public Function simplify() {
        if (this.simpleVersion != null) {
            return this.simpleVersion;
        }
        if (this.isConstant()) {
            this.simpleVersion = new Constant(this.L.evaluate() * this.R.evaluate());
            return this.simpleVersion;
        }
        if (this.isZero()) {
            return ZERO;
        }
        if (this.L.isOne()) {
            this.simpleVersion = this.R.simplify();
            return this.simpleVersion;
        }
        if (this.R.isOne()) {
            this.simpleVersion = this.L.simplify();
            return this.simpleVersion;
        }
        if (this.R.isConstant()) {
            return FunctionFactory.getFunction(this.getRoot(), this.R, this.L).simplify();
        }
        return super.simplify();
    }

    public boolean isZero() {
        return this.L.isZero() || this.R.isZero();
    }
}

