/*
 * Decompiled with CFR 0.152.
 */
package net.gcalc.plugin.plane.graph;

import java.awt.Cursor;
import java.awt.Dimension;
import java.util.Observer;
import net.gcalc.calc.models.Model;
import net.gcalc.calc.models.ModelList;
import net.gcalc.calc.models.RenderableModel;
import net.gcalc.plugin.gui.ExtendedBufferedCanvas;
import net.gcalc.plugin.plane.gui.CoordinatePanel;
import net.gcalc.plugin.properties.GraphProperties;

public abstract class GraphCanvas
extends ExtendedBufferedCanvas
implements Observer {
    protected GraphProperties properties;
    protected CoordinatePanel coordinatePanel;

    public GraphCanvas(GraphProperties gp) {
        this.properties = gp;
        this.setDefaultProperties();
        this.properties.addObserver(this);
        this.resetSize();
        this.setCursor(this.defaultCursor());
    }

    public GraphProperties getProperties() {
        return this.properties;
    }

    private void setDefaultProperties() {
        this.properties.put(GraphProperties.MODEL_LIST, new ModelList());
        this.setDefaultScreenDimension();
        this.setDefaultView();
        this.setDefaultGraphElements();
        this.setDefaultColors();
        this.setDefaultFonts();
        this.properties.revertToDefault();
    }

    protected void setDefaultScreenDimension() {
        this.properties.put(GraphProperties.SCREEN_DIMENSION, new Dimension(325, 325));
    }

    abstract void setDefaultFonts();

    abstract void setDefaultView();

    abstract void setDefaultGraphElements();

    abstract void setDefaultColors();

    protected ModelList getModelList() {
        return (ModelList)this.properties.get(GraphProperties.MODEL_LIST);
    }

    public Cursor defaultCursor() {
        return new Cursor(1);
    }

    public void resetSize() {
        this.properties.revertToDefault(GraphProperties.SCREEN_DIMENSION);
        this.resetSize((Dimension)this.properties.get(GraphProperties.SCREEN_DIMENSION));
    }

    public void clear() {
        ModelList ml = (ModelList)this.properties.get(GraphProperties.MODEL_LIST);
        ml.removeAllModels();
        this.redrawAll();
    }

    public boolean isOnScreen(int x, int y) {
        return x >= 0 && x <= this.getWidth() && y >= 0 && y <= this.getHeight();
    }

    protected void drawBackgroundComponents() {
        this.drawGrid();
        this.drawAxes();
        this.drawScale();
        this.drawLabel();
        this.drawAxesTitle();
    }

    protected void drawGraphComponents() {
        this.drawBackgroundComponents();
        this.getModelList().flagAll(false);
        this.drawModelList();
        this.draw();
    }

    protected void draw() {
    }

    public void redrawAll() {
        this.redrawAll(true);
    }

    public void redrawAll(boolean useCache) {
        super.clear();
        if (!useCache) {
            this.getModelList().deleteCache();
        }
        this.drawGraphComponents();
        this.repaint();
    }

    protected abstract void drawAxes();

    protected abstract void drawGrid();

    protected abstract void drawScale();

    protected abstract void drawLabel();

    protected abstract void drawAxesTitle();

    public void draw(Model fg) {
        this.getModelList().add(fg);
        this.drawModelList();
        this.properties.setPropertyChanged(GraphProperties.MODEL_LIST);
        this.repaint();
    }

    protected abstract void draw(RenderableModel var1);

    protected void drawModelList() {
        ModelList modelList = this.getModelList();
        int i = 0;
        while (i < modelList.getSize()) {
            RenderableModel model = (RenderableModel)modelList.getModelAt(i);
            if (model != null && !model.isDrawn()) {
                this.draw(model);
                model.setDrawn(true);
            }
            ++i;
        }
        modelList.poke();
    }

    public void clearModelList() {
        this.getModelList().removeAllModels();
    }
}

