/*
 * Decompiled with CFR 0.152.
 */
package com.google.jstestdriver.output;

import com.google.common.base.Supplier;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.inject.Singleton;
import com.google.jstestdriver.BrowserInfo;
import com.google.jstestdriver.FileResult;
import com.google.jstestdriver.TestResult;
import com.google.jstestdriver.output.TestResultListener;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public class TestResultHolder
implements TestResultListener {
    private final Multimap<BrowserInfo, TestResult> results;

    public TestResultHolder() {
        LinkedHashMap<BrowserInfo, Collection<TestResult>> map = Maps.newLinkedHashMap();
        this.results = Multimaps.synchronizedMultimap(this.createMultiMap(map));
    }

    private Multimap<BrowserInfo, TestResult> createMultiMap(Map<BrowserInfo, Collection<TestResult>> map) {
        LinkListSupplier collectionSupplier = new LinkListSupplier();
        Multimap<BrowserInfo, TestResult> resultMultimap = Multimaps.newMultimap(map, collectionSupplier);
        return resultMultimap;
    }

    public Multimap<BrowserInfo, TestResult> getResults() {
        return this.results;
    }

    @Override
    public void onTestComplete(TestResult testResult) {
        this.results.put(testResult.getBrowserInfo(), testResult);
    }

    @Override
    public void finish() {
    }

    @Override
    public void onFileLoad(String browser, FileResult fileResult) {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class LinkListSupplier
    implements Supplier<Collection<TestResult>> {
        private LinkListSupplier() {
        }

        @Override
        public Collection<TestResult> get() {
            return Lists.newLinkedList();
        }
    }
}

