# snp125Coding.sql was originally generated by the autoSql program, which also 
# generated snp125Coding.c and snp125Coding.h.  This creates the database representation of
# an object which can be loaded and saved from RAM in a fairly 
# automatic way.

#Annotations of the effects of SNPs on translated protein sequence.
CREATE TABLE snp125Coding (
    bin smallint not null,      # Bin number for browser speedup
    chrom varchar(255) not null,	# Reference sequence chromosome or scaffold
    chromStart int unsigned not null,	# Start position in chromosome
    chromEnd int unsigned not null,	# End position in chromosome
    name varchar(255) not null,	# Reference SNP identifier
    transcript varchar(255) not null,	# Accession of the transcript modified by SNP
    frame enum("1", "2", "3")  not null,	# Frame of transcript's codon modified by SNP
    alleleCount int not null,	# Number of annotated alleles for SNP
    funcCodes longblob not null,	# dbSNP function codes (e.g. 42=missense)
    alleles longblob not null,	# Observed nucleotide alleles corresponding to funcCodes
    codons longblob not null,	# Codons corresponding to funcCodes
    peptides longblob not null,	# Amino acid sequence corresponding to funcCodes
              #Indices
    INDEX(chrom(8),bin),
    INDEX(name(20))
);
