/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.jclasslib.bytecode;

import java.io.IOException;
import org.gjt.jclasslib.bytecode.PaddedInstruction;
import org.gjt.jclasslib.io.ByteCodeInput;
import org.gjt.jclasslib.io.ByteCodeOutput;

public class TableSwitchInstruction
extends PaddedInstruction {
    private int defaultOffset;
    private int lowByte;
    private int highByte;
    private int[] jumpOffsets;

    public TableSwitchInstruction(int n) {
        super(n);
    }

    public int getSize() {
        return super.getSize() + 12 + 4 * this.jumpOffsets.length;
    }

    public int getDefaultOffset() {
        return this.defaultOffset;
    }

    public void setDefaultOffset(int n) {
        this.defaultOffset = n;
    }

    public int getLowByte() {
        return this.lowByte;
    }

    public void setLowByte(int n) {
        this.lowByte = n;
    }

    public int getHighByte() {
        return this.highByte;
    }

    public void setHighByte(int n) {
        this.highByte = n;
    }

    public int[] getJumpOffsets() {
        return this.jumpOffsets;
    }

    public void setJumpOffsets(int[] nArray) {
        this.jumpOffsets = nArray;
    }

    public void read(ByteCodeInput byteCodeInput) throws IOException {
        super.read(byteCodeInput);
        this.defaultOffset = byteCodeInput.readInt();
        this.lowByte = byteCodeInput.readInt();
        this.highByte = byteCodeInput.readInt();
        int n = this.highByte - this.lowByte + 1;
        this.jumpOffsets = new int[n];
        for (int i = 0; i < n; ++i) {
            this.jumpOffsets[i] = byteCodeInput.readInt();
        }
    }

    public void write(ByteCodeOutput byteCodeOutput) throws IOException {
        super.write(byteCodeOutput);
        byteCodeOutput.writeInt(this.defaultOffset);
        byteCodeOutput.writeInt(this.lowByte);
        byteCodeOutput.writeInt(this.highByte);
        int n = this.jumpOffsets.length;
        for (int i = 0; i < n; ++i) {
            byteCodeOutput.writeInt(this.jumpOffsets[i]);
        }
    }
}

