/*
 * This file is part of the Yices SMT Solver.
 * Copyright (C) 2017 SRI International.
 *
 * Yices is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Yices is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Yices.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * Tables for parsing the SMT-LIB 2.0 language
 */

#ifndef __SMT2_PARSE_TABLES_H
#define __SMT2_PARSE_TABLES_H

#include <stdint.h>

/*
 * States
 */
typedef enum state_s {
  c0, c1, c3, c4, c5, c6, c6a, c8, c9, c9a, c9b,
  c10, c10a, c10b, c11, c11a, c11b, c11d, c11f, c12, c12b,
  c13, c14, c15, c16, c16a, c16b, c16c, c16d, c17, c17a, c17b, c17c,
  a0, a1, v0,
  s0, s1, s2, s3, s4, s5, s6, s7, s8, s10,
  t0, t1, t2, t2a, t2b, t2d, t2e,
  t3, t3a, t3b, t3d, t3e,
  t4a, t4b, t4c, t4d, t4e, t4g,
  t5, t5a, t5b, t5c, t5d,
  t6, t6a, t6b, t6c, t6d, t6e, t6g, t6h, t6i, t6j,
  t7, t7a, t7b, t8a,
  r0,
} state_t;


/*
 * Action codes
 */
typedef enum actions {
  // commands
  next_goto_c1,
  empty_command_return,

  assert_next_push_r0_goto_t0,
  check_sat_next_goto_r0,
  check_sat_assuming_next_goto_c16,
  declare_sort_next_goto_c8,
  declare_const_next_goto_c14,
  declare_fun_next_goto_c10,
  define_sort_next_goto_c9,
  define_const_next_goto_c15,
  define_fun_next_goto_c11,
  echo_next_goto_c13,
  exit_next_goto_r0,
  get_assertions_next_goto_r0,
  get_assignment_next_goto_r0,
  get_info_next_goto_c4,
  get_model_next_goto_r0,
  get_option_next_goto_c4,
  get_proof_next_goto_r0,
  get_unsat_assumptions_next_goto_r0,
  get_unsat_core_next_goto_r0,
  get_unsat_model_interpolant_next_goto_r0,
  get_value_next_goto_c12,
  pop_next_goto_c3,
  push_next_goto_c3,
  set_logic_next_goto_c5,
  set_info_next_goto_c6,
  set_option_next_goto_c6,
  reset_next_goto_r0,
  reset_assertions_next_goto_r0,
  check_sat_assuming_model_next_goto_c17,

  // arguments to the commands
  numeral_next_goto_r0,
  keyword_next_goto_r0,
  symbol_next_goto_r0,
  keyword_next_goto_c6a,
  next_return,
  push_r0_goto_a0,
  symbol_next_goto_c3,
  symbol_next_goto_c9a,
  next_goto_c9b,
  next_push_r0_goto_s0,
  symbol_next_goto_c9b,
  symbol_next_goto_c10a,
  next_goto_c10b,
  push_c10b_goto_s0,
  symbol_next_goto_c11a,
  next_goto_c11b,
  next_push_r0_push_t0_goto_s0,
  next_goto_c11d,
  symbol_next_push_c11f_goto_s0,
  eval_next_goto_c11b,
  next_push_c12b_goto_t0,
  next_goto_r0,
  push_c12b_goto_t0,
  string_next_goto_r0,
  symbol_next_push_r0_goto_s0,
  symbol_next_push_r0_push_t0_goto_s0,
  next_goto_c16a,
  symbol_next_goto_c16a,
  next_goto_c16b,
  not_next_goto_c16c,
  symbol_next_goto_c16d,

  next_goto_c17a,
  symbol_next_goto_c17a,
  next_goto_c17b,
  next_push_c17c_goto_t0,
  push_c17c_goto_t0,

  // attribute values + s-expressions
  numeral_next_return,
  decimal_next_return,
  hexadecimal_next_return,
  binary_next_return,
  string_next_return,
  symbol_next_return,
  next_goto_a1,
  push_a1_goto_v0,
  keyword_next_return,

  // sorts
  sort_symbol_next_return,
  next_goto_s1,
  next_goto_s2,
  next_goto_s5,
  symbol_next_push_s10_goto_s0,
  symbol_next_goto_s3,
  numeral_next_goto_s4,
  next_goto_s6,
  symbol_next_goto_s7,
  numeral_next_goto_s8,
  next_push_s10_goto_s0,
  push_s10_goto_s0,

  // terms
  term_symbol_next_return,
  next_goto_t1,
  next_goto_t2,           // (let
  forall_next_goto_t3,    // (forall
  exists_next_goto_t3,    // (exists
  next_push_t4a_goto_t0,  // (!
  next_goto_t5,           // (as
  next_goto_t6,           // ((
  next_goto_t7,           // (_

  // simple function application (<symbol> <term> ... <term>)
  symbol_next_push_t8a_goto_t0,

  // (let ...
  bind_next_goto_t2a,
  next_goto_t2b,
  symbol_next_push_t2d_goto_t0,
  next_goto_t2e,
  close_next_push_r0_goto_t0,

  // (exists ... and (forall ...
  next_goto_t3a,
  next_goto_t3b,
  symbol_next_push_t3d_goto_s0,
  next_goto_t3e,
  next_push_r0_goto_t0,

  // (! <term> ...
  check_keyword_then_branch,
  push_t4c_goto_a0,
  symbol_next_goto_t4c,
  next_push_t4g_goto_t0,
  next_goto_t4c,
  push_t4g_goto_t0,

  // (as ...
  next_goto_t5a,
  asymbol_next_push_r0_goto_s0,
  next_goto_t5b,
  symbol_next_goto_t5c,
  numeral_next_goto_t5d,

  // (( ...
  next_goto_t6a,
  next_goto_t6h,

  // ((as ...
  next_goto_t6b,
  symbol_next_push_t6g_goto_s0,
  next_goto_t6c,
  symbol_next_goto_t6d,
  numeral_next_goto_t6e,
  next_push_t6g_goto_s0,
  next_push_t8a_goto_t0,

  // ((_ ...
  symbol_next_goto_t6i,
  numeral_next_goto_t6j,

  // (_ ...
  symbol_next_goto_t7a,
  numeral_next_goto_t7b,

  // after <term> in a function application
  push_t8a_goto_t0,

  // errors
  error_lp_expected,
  error_string_expected,
  error_symbol_expected,
  error_numeral_expected,
  error_keyword_expected,
  error_rp_expected,
  error_underscore_expected,
  error_command_expected,
  error_literal_expected,
  error_not_expected,
  error,
} smt2_action_t;


/*
 * Tables generated by table_builder
 * see utils/table_builder.c
 */

// Table sizes
#define NSTATES 84
#define BSIZE 298

// Default values for each state
static const uint8_t default_value[NSTATES] = {
  error_lp_expected,
  error_command_expected,
  error_numeral_expected,
  error_keyword_expected,
  error_symbol_expected,
  error_keyword_expected,
  push_r0_goto_a0,
  error_symbol_expected,
  error_symbol_expected,
  error_lp_expected,
  error,
  error_symbol_expected,
  error_lp_expected,
  push_c10b_goto_s0,
  error_symbol_expected,
  error_lp_expected,
  error,
  error_symbol_expected,
  error_rp_expected,
  error_lp_expected,
  push_c12b_goto_t0,
  error,
  error_symbol_expected,
  error_symbol_expected,
  error_lp_expected,
  error_literal_expected,
  error_not_expected,
  error_symbol_expected,
  error_rp_expected,
  error_lp_expected,
  error,
  error_lp_expected,
  push_c17c_goto_t0,
  error,
  push_a1_goto_v0,
  error,
  error,
  error,
  error_symbol_expected,
  error_numeral_expected,
  error,
  error_underscore_expected,
  error_symbol_expected,
  error_numeral_expected,
  error,
  push_s10_goto_s0,
  error,
  error,
  error_lp_expected,
  error_lp_expected,
  error_symbol_expected,
  error_rp_expected,
  error,
  error_lp_expected,
  error_lp_expected,
  error_symbol_expected,
  error_rp_expected,
  error,
  error_keyword_expected,
  push_t4c_goto_a0,
  error,
  error_symbol_expected,
  error_lp_expected,
  push_t4g_goto_t0,
  error,
  error_underscore_expected,
  error_symbol_expected,
  error_numeral_expected,
  error,
  error,
  error,
  error_underscore_expected,
  error_symbol_expected,
  error_numeral_expected,
  error,
  error_rp_expected,
  error_symbol_expected,
  error_numeral_expected,
  error,
  error_symbol_expected,
  error_numeral_expected,
  error,
  push_t8a_goto_t0,
  error_rp_expected,
};

// Base values for each state
static const uint8_t base[NSTATES] = {
     0,   0,   0,   0,  42,   1,   0,   0,  44,   4,
    53,  50,   5,   5,  57,   7,  12,  60,  13,  15,
    15,  10,  10,  47,  20,  63,  49,  68,  59,  67,
    86,  70,  73, 106,  78, 116, 127, 130, 120,  79,
    82,  80, 124,  94,  99,  98, 176, 186, 103, 104,
   161, 106, 117, 131, 134, 179, 139, 143, 131, 147,
   149, 182, 146, 148, 211, 138, 190, 159, 164, 156,
   231, 159, 220, 174, 213, 188, 224, 190, 222, 227,
   193, 240, 199, 207,
};

// Check table
static const uint8_t check[BSIZE] = {
     0,   6,   0,   2,   9,  12,  13,  15,   7,   7,
     3,   5,  16,  16,  18,  19,  20,  21,  22,  22,
    24,   1,   1,   1,   1,   1,   1,   1,   1,   1,
     1,   1,   1,   1,   1,   1,   1,   1,   1,   1,
     1,   1,   1,   1,   1,   1,   1,   1,   1,   1,
     4,   4,   8,   8,  10,  23,  23,  26,  11,  11,
    28,  10,  10,  25,  25,  14,  14,  29,  17,  17,
    31,  25,  25,   4,  32,   8,  27,  27,   4,  34,
     8,  11,  39,  40,  10,  40,  11,  30,  14,  10,
     4,  17,   8,  14,  30,  41,  17,  43,  11,  45,
    44,  10,  44,  48,  49,  14,  33,  51,  17,  33,
    33,  33,  33,  33,  33,  33,  35,  52,  52,  35,
    35,  35,  35,  35,  35,  35,  35,  36,  38,  38,
    37,  53,  42,  42,  54,  36,  36,  33,  37,  37,
    56,  58,  33,  57,  57,  37,  62,  35,  59,  63,
    60,  38,  35,  65,  33,  42,  38,  59,  36,  60,
    42,  37,  67,  36,  35,  68,  37,  68,  38,  50,
    50,  69,  42,  69,  71,  36,  46,  73,  37,  46,
    46,  46,  46,  46,  46,  46,  47,  55,  55,  75,
    61,  61,  50,  77,  47,  47,  80,  50,  66,  66,
    82,  47,  47,  47,  47,  47,  47,  46,  83,  50,
    55,  64,  46,  61,  74,  55,  74,  47,  61,  64,
    64,  66,  47,  78,  46,  78,  66,  55,  72,  72,
    61,  70,  76,  76,  47,  79,  79,  84,  66,  70,
    70,  81,  64,  81,  84,  84,  84,  64,  84,  84,
    84,  72,  84,  84,  84,  76,  72,  84,  79,  64,
    76,  84,  70,  79,  84,  84,  84,  70,  72,  84,
    84,  84,  76,  84,  84,  79,  84,  84,  84,  70,
    84,  84,  84,  84,  84,  84,  84,  84,  84,  84,
    84,  84,  84,  84,  84,  84,  84,  84,
};

// Value table
static const uint8_t value[BSIZE] = {
  next_goto_c1,
  next_return,
  empty_command_return,
  numeral_next_goto_r0,
  next_goto_c9b,
  next_goto_c10b,
  next_push_r0_goto_s0,
  next_goto_c11b,
  symbol_next_goto_c3,
  symbol_next_goto_c3,
  keyword_next_goto_r0,
  keyword_next_goto_c6a,
  next_goto_c11d,
  next_push_r0_push_t0_goto_s0,
  eval_next_goto_c11b,
  next_push_c12b_goto_t0,
  next_goto_r0,
  string_next_goto_r0,
  symbol_next_push_r0_goto_s0,
  symbol_next_push_r0_goto_s0,
  next_goto_c16a,
  assert_next_push_r0_goto_t0,
  check_sat_next_goto_r0,
  check_sat_assuming_next_goto_c16,
  check_sat_assuming_model_next_goto_c17,
  declare_sort_next_goto_c8,
  declare_const_next_goto_c14,
  declare_fun_next_goto_c10,
  define_sort_next_goto_c9,
  define_const_next_goto_c15,
  define_fun_next_goto_c11,
  echo_next_goto_c13,
  exit_next_goto_r0,
  get_assertions_next_goto_r0,
  get_assignment_next_goto_r0,
  get_info_next_goto_c4,
  get_model_next_goto_r0,
  get_option_next_goto_c4,
  get_proof_next_goto_r0,
  get_unsat_assumptions_next_goto_r0,
  get_unsat_core_next_goto_r0,
  get_unsat_model_interpolant_next_goto_r0,
  get_value_next_goto_c12,
  pop_next_goto_c3,
  push_next_goto_c3,
  set_logic_next_goto_c5,
  set_info_next_goto_c6,
  set_option_next_goto_c6,
  reset_next_goto_r0,
  reset_assertions_next_goto_r0,
  symbol_next_goto_r0,
  symbol_next_goto_r0,
  symbol_next_goto_c9a,
  symbol_next_goto_c9a,
  next_push_r0_goto_s0,
  symbol_next_push_r0_push_t0_goto_s0,
  symbol_next_push_r0_push_t0_goto_s0,
  not_next_goto_c16c,
  symbol_next_goto_c10a,
  symbol_next_goto_c10a,
  next_goto_c16a,
  symbol_next_goto_c9b,
  symbol_next_goto_c9b,
  next_goto_c16b,
  next_goto_r0,
  symbol_next_goto_c11a,
  symbol_next_goto_c11a,
  next_goto_c17a,
  symbol_next_push_c11f_goto_s0,
  symbol_next_push_c11f_goto_s0,
  next_push_c17c_goto_t0,
  symbol_next_goto_c16a,
  symbol_next_goto_c16a,
  symbol_next_goto_r0,
  next_goto_r0,
  symbol_next_goto_c9a,
  symbol_next_goto_c16d,
  symbol_next_goto_c16d,
  symbol_next_goto_r0,
  next_return,
  symbol_next_goto_c9a,
  symbol_next_goto_c10a,
  numeral_next_goto_s4,
  next_return,
  symbol_next_goto_c9b,
  numeral_next_goto_s4,
  symbol_next_goto_c10a,
  next_goto_c17b,
  symbol_next_goto_c11a,
  symbol_next_goto_c9b,
  symbol_next_goto_r0,
  symbol_next_push_c11f_goto_s0,
  symbol_next_goto_c9a,
  symbol_next_goto_c11a,
  symbol_next_goto_c17a,
  next_goto_s6,
  symbol_next_push_c11f_goto_s0,
  numeral_next_goto_s8,
  symbol_next_goto_c10a,
  next_return,
  next_push_s10_goto_s0,
  symbol_next_goto_c9b,
  numeral_next_goto_s8,
  bind_next_goto_t2a,
  next_goto_t2b,
  symbol_next_goto_c11a,
  next_goto_a1,
  next_goto_t2e,
  symbol_next_push_c11f_goto_s0,
  numeral_next_return,
  decimal_next_return,
  hexadecimal_next_return,
  binary_next_return,
  string_next_return,
  symbol_next_return,
  symbol_next_return,
  next_goto_a1,
  next_goto_t2b,
  close_next_push_r0_goto_t0,
  numeral_next_return,
  decimal_next_return,
  hexadecimal_next_return,
  binary_next_return,
  string_next_return,
  symbol_next_return,
  symbol_next_return,
  keyword_next_return,
  next_goto_s1,
  symbol_next_goto_s3,
  symbol_next_goto_s3,
  next_goto_s5,
  next_goto_t3a,
  symbol_next_goto_s7,
  symbol_next_goto_s7,
  next_goto_t3b,
  sort_symbol_next_return,
  sort_symbol_next_return,
  symbol_next_return,
  symbol_next_push_s10_goto_s0,
  symbol_next_push_s10_goto_s0,
  next_goto_t3e,
  check_keyword_then_branch,
  symbol_next_return,
  next_goto_t3b,
  next_push_r0_goto_t0,
  next_goto_s2,
  next_push_t4g_goto_t0,
  symbol_next_return,
  next_return,
  next_goto_t4c,
  next_return,
  symbol_next_goto_s3,
  symbol_next_return,
  next_goto_t5b,
  symbol_next_return,
  symbol_next_goto_s7,
  symbol_next_goto_s3,
  check_keyword_then_branch,
  sort_symbol_next_return,
  check_keyword_then_branch,
  symbol_next_goto_s7,
  symbol_next_push_s10_goto_s0,
  numeral_next_goto_t5d,
  sort_symbol_next_return,
  symbol_next_return,
  next_push_r0_goto_s0,
  symbol_next_push_s10_goto_s0,
  numeral_next_goto_t5d,
  symbol_next_goto_s3,
  symbol_next_push_t2d_goto_t0,
  symbol_next_push_t2d_goto_t0,
  next_goto_t6h,
  symbol_next_goto_s7,
  next_goto_t6a,
  next_goto_t6c,
  sort_symbol_next_return,
  next_goto_t1,
  numeral_next_goto_t6e,
  symbol_next_push_s10_goto_s0,
  numeral_next_return,
  decimal_next_return,
  hexadecimal_next_return,
  binary_next_return,
  string_next_return,
  term_symbol_next_return,
  term_symbol_next_return,
  next_goto_t6,
  symbol_next_push_t3d_goto_s0,
  symbol_next_push_t3d_goto_s0,
  next_push_t8a_goto_t0,
  symbol_next_goto_t4c,
  symbol_next_goto_t4c,
  symbol_next_push_t2d_goto_t0,
  numeral_next_goto_t6j,
  symbol_next_push_t8a_goto_t0,
  symbol_next_push_t8a_goto_t0,
  numeral_next_goto_t7b,
  symbol_next_push_t2d_goto_t0,
  symbol_next_goto_t5c,
  symbol_next_goto_t5c,
  next_return,
  next_goto_t7,
  next_push_t4a_goto_t0,
  next_goto_t5,
  next_goto_t2,
  exists_next_goto_t3,
  forall_next_goto_t3,
  term_symbol_next_return,
  next_return,
  symbol_next_push_t2d_goto_t0,
  symbol_next_push_t3d_goto_s0,
  next_goto_t5a,
  term_symbol_next_return,
  symbol_next_goto_t4c,
  next_push_t6g_goto_s0,
  symbol_next_push_t3d_goto_s0,
  numeral_next_goto_t6e,
  symbol_next_push_t8a_goto_t0,
  symbol_next_goto_t4c,
  asymbol_next_push_r0_goto_s0,
  asymbol_next_push_r0_goto_s0,
  symbol_next_goto_t5c,
  symbol_next_push_t8a_goto_t0,
  next_push_t8a_goto_t0,
  term_symbol_next_return,
  numeral_next_goto_t6j,
  symbol_next_goto_t5c,
  symbol_next_push_t3d_goto_s0,
  symbol_next_goto_t6d,
  symbol_next_goto_t6d,
  symbol_next_goto_t4c,
  next_goto_t6b,
  symbol_next_goto_t6i,
  symbol_next_goto_t6i,
  symbol_next_push_t8a_goto_t0,
  symbol_next_goto_t7a,
  symbol_next_goto_t7a,
  error,
  symbol_next_goto_t5c,
  symbol_next_push_t6g_goto_s0,
  symbol_next_push_t6g_goto_s0,
  next_return,
  asymbol_next_push_r0_goto_s0,
  numeral_next_goto_t7b,
  error,
  error,
  error,
  asymbol_next_push_r0_goto_s0,
  error,
  error,
  error,
  symbol_next_goto_t6d,
  error,
  error,
  error,
  symbol_next_goto_t6i,
  symbol_next_goto_t6d,
  error,
  symbol_next_goto_t7a,
  asymbol_next_push_r0_goto_s0,
  symbol_next_goto_t6i,
  error,
  symbol_next_push_t6g_goto_s0,
  symbol_next_goto_t7a,
  error,
  error,
  error,
  symbol_next_push_t6g_goto_s0,
  symbol_next_goto_t6d,
  error,
  error,
  error,
  symbol_next_goto_t6i,
  error,
  error,
  symbol_next_goto_t7a,
  error,
  error,
  error,
  symbol_next_push_t6g_goto_s0,
  error,
  error,
  error,
  error,
  error,
  error,
  error,
  error,
  error,
  error,
  error,
  error,
  error,
  error,
  error,
  error,
  error,
  error,
};


#endif /* __SMT2_PARSE_TABLES_H */
