/*
Copyright The KubeVirt Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package v1

import (
	"context"

	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	gentype "k8s.io/client-go/gentype"
	v1 "kubevirt.io/api/core/v1"
	scheme "kubevirt.io/client-go/kubevirt/scheme"
)

// VirtualMachineInstanceReplicaSetsGetter has a method to return a VirtualMachineInstanceReplicaSetInterface.
// A group's client should implement this interface.
type VirtualMachineInstanceReplicaSetsGetter interface {
	VirtualMachineInstanceReplicaSets(namespace string) VirtualMachineInstanceReplicaSetInterface
}

// VirtualMachineInstanceReplicaSetInterface has methods to work with VirtualMachineInstanceReplicaSet resources.
type VirtualMachineInstanceReplicaSetInterface interface {
	Create(ctx context.Context, virtualMachineInstanceReplicaSet *v1.VirtualMachineInstanceReplicaSet, opts metav1.CreateOptions) (*v1.VirtualMachineInstanceReplicaSet, error)
	Update(ctx context.Context, virtualMachineInstanceReplicaSet *v1.VirtualMachineInstanceReplicaSet, opts metav1.UpdateOptions) (*v1.VirtualMachineInstanceReplicaSet, error)
	// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().
	UpdateStatus(ctx context.Context, virtualMachineInstanceReplicaSet *v1.VirtualMachineInstanceReplicaSet, opts metav1.UpdateOptions) (*v1.VirtualMachineInstanceReplicaSet, error)
	Delete(ctx context.Context, name string, opts metav1.DeleteOptions) error
	DeleteCollection(ctx context.Context, opts metav1.DeleteOptions, listOpts metav1.ListOptions) error
	Get(ctx context.Context, name string, opts metav1.GetOptions) (*v1.VirtualMachineInstanceReplicaSet, error)
	List(ctx context.Context, opts metav1.ListOptions) (*v1.VirtualMachineInstanceReplicaSetList, error)
	Watch(ctx context.Context, opts metav1.ListOptions) (watch.Interface, error)
	Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts metav1.PatchOptions, subresources ...string) (result *v1.VirtualMachineInstanceReplicaSet, err error)
	VirtualMachineInstanceReplicaSetExpansion
}

// virtualMachineInstanceReplicaSets implements VirtualMachineInstanceReplicaSetInterface
type virtualMachineInstanceReplicaSets struct {
	*gentype.ClientWithList[*v1.VirtualMachineInstanceReplicaSet, *v1.VirtualMachineInstanceReplicaSetList]
}

// newVirtualMachineInstanceReplicaSets returns a VirtualMachineInstanceReplicaSets
func newVirtualMachineInstanceReplicaSets(c *KubevirtV1Client, namespace string) *virtualMachineInstanceReplicaSets {
	return &virtualMachineInstanceReplicaSets{
		gentype.NewClientWithList[*v1.VirtualMachineInstanceReplicaSet, *v1.VirtualMachineInstanceReplicaSetList](
			"virtualmachineinstancereplicasets",
			c.RESTClient(),
			scheme.ParameterCodec,
			namespace,
			func() *v1.VirtualMachineInstanceReplicaSet { return &v1.VirtualMachineInstanceReplicaSet{} },
			func() *v1.VirtualMachineInstanceReplicaSetList { return &v1.VirtualMachineInstanceReplicaSetList{} }),
	}
}
