"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getValueFromDistance = void 0;
var _config = _interopRequireDefault(require("../../config"));
var _constants = require("../../constants");
var _getPercentage = require("../../get-percentage");
// Source: https://github.com/atlassian/react-beautiful-dnd

var getValueFromDistance = exports.getValueFromDistance = function getValueFromDistance(distanceToEdge, thresholds) {
  /*
   // This function only looks at the distance to one edge
   // Example: looking at bottom edge
   |----------------------------------|
   |                                  |
   |                                  |
   |                                  |
   |                                  |
   |                                  | => no scroll in this range
   |                                  |
   |                                  |
   |  startScrollingFrom (eg 100px)   |
   |                                  |
   |                                  | => increased scroll value the closer to maxScrollValueAt
   |  maxScrollValueAt (eg 10px)      |
   |                                  | => max scroll value in this range
   |----------------------------------|
   */

  // too far away to auto scroll
  if (distanceToEdge > thresholds.startScrollingFrom) {
    return 0;
  }

  // use max speed when on or over boundary
  if (distanceToEdge <= thresholds.maxScrollValueAt) {
    return _config.default.maxPixelScroll;
  }

  // when just going on the boundary return the minimum integer
  if (distanceToEdge === thresholds.startScrollingFrom) {
    return _constants.minScroll;
  }

  // to get the % past startScrollingFrom we will calculate
  // the % the value is from maxScrollValueAt and then invert it
  var percentageFromMaxScrollValueAt = (0, _getPercentage.getPercentage)({
    startOfRange: thresholds.maxScrollValueAt,
    endOfRange: thresholds.startScrollingFrom,
    current: distanceToEdge
  });
  var percentageFromStartScrollingFrom = 1 - percentageFromMaxScrollValueAt;
  var scroll = _config.default.maxPixelScroll * _config.default.ease(percentageFromStartScrollingFrom);

  // scroll will always be a positive integer
  return Math.ceil(scroll);
};