/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.query;

import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.SequenceReceiver;
import net.sf.saxon.om.FunctionItem;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.query.QueryResult;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.ObjectValue;

public class SequenceWrapper
extends SequenceReceiver {
    public static final String RESULT_NS = QueryResult.RESULT_NS;
    private Receiver out;
    private int depth = 0;
    private int resultSequence;
    private int resultDocument;
    private int resultElement;
    private int resultAttribute;
    private int resultText;
    private int resultComment;
    private int resultPI;
    private int resultNamespace;
    private int resultAtomicValue;
    private int xsiType;

    public SequenceWrapper(Receiver destination) {
        this.out = destination;
        this.setPipelineConfiguration(destination.getPipelineConfiguration());
    }

    public void open() throws XPathException {
        NamePool pool = this.getNamePool();
        this.resultSequence = pool.allocate("result", RESULT_NS, "sequence");
        this.resultDocument = pool.allocate("result", RESULT_NS, "document");
        this.resultElement = pool.allocate("result", RESULT_NS, "element");
        this.resultAttribute = pool.allocate("result", RESULT_NS, "attribute");
        this.resultText = pool.allocate("result", RESULT_NS, "text");
        this.resultComment = pool.allocate("result", RESULT_NS, "comment");
        this.resultPI = pool.allocate("result", RESULT_NS, "processing-instruction");
        this.resultNamespace = pool.allocate("result", RESULT_NS, "namespace");
        this.resultAtomicValue = pool.allocate("result", RESULT_NS, "atomic-value");
        this.xsiType = pool.allocate("xsi", "http://www.w3.org/2001/XMLSchema-instance", "type");
        this.out.open();
        this.out.startDocument(0);
        this.out.startElement(this.resultSequence, 630, 0, 0);
        this.out.namespace(pool.allocateNamespaceCode("result", RESULT_NS), 0);
        this.out.namespace(pool.allocateNamespaceCode("xs", "http://www.w3.org/2001/XMLSchema"), 0);
        this.out.namespace(pool.allocateNamespaceCode("xsi", "http://www.w3.org/2001/XMLSchema-instance"), 0);
        this.out.startContent();
    }

    public void startDocument(int properties) throws XPathException {
        this.out.startElement(this.resultDocument, 630, 0, 0);
        this.out.startContent();
        ++this.depth;
    }

    public void endDocument() throws XPathException {
        this.out.endElement();
        --this.depth;
    }

    public void startElement(int nameCode, int typeCode, int locationId, int properties) throws XPathException {
        if (this.depth++ == 0) {
            this.out.startElement(this.resultElement, 630, 0, 0);
            this.out.startContent();
        }
        this.out.startElement(nameCode, typeCode, locationId, properties);
    }

    public void endElement() throws XPathException {
        this.out.endElement();
        if (--this.depth == 0) {
            this.out.endElement();
        }
    }

    public void attribute(int nameCode, int typeCode, CharSequence value, int locationId, int properties) throws XPathException {
        if (this.depth == 0) {
            this.out.startElement(this.resultAttribute, 630, 0, 0);
            if ((nameCode & 0xFFF00000) != 0) {
                this.out.namespace(this.getNamePool().getNamespaceCode(nameCode), 0);
            }
            this.out.attribute(nameCode, typeCode, value, locationId, properties);
            this.out.startContent();
            this.out.endElement();
        } else {
            this.out.attribute(nameCode, typeCode, value, locationId, properties);
        }
    }

    public void namespace(int namespaceCode, int properties) throws XPathException {
        if (this.depth == 0) {
            this.out.startElement(this.resultNamespace, 630, 0, 0);
            this.out.namespace(namespaceCode, properties);
            this.out.startContent();
            this.out.endElement();
        } else {
            this.out.namespace(namespaceCode, properties);
        }
    }

    public void characters(CharSequence chars, int locationId, int properties) throws XPathException {
        if (this.depth == 0) {
            this.out.startElement(this.resultText, 630, 0, 0);
            this.out.startContent();
            this.out.characters(chars, locationId, properties);
            this.out.endElement();
        } else {
            this.out.characters(chars, locationId, properties);
        }
    }

    public void comment(CharSequence chars, int locationId, int properties) throws XPathException {
        if (this.depth == 0) {
            this.out.startElement(this.resultComment, 630, 0, 0);
            this.out.startContent();
            this.out.comment(chars, locationId, properties);
            this.out.endElement();
        } else {
            this.out.comment(chars, locationId, properties);
        }
    }

    public void processingInstruction(String target, CharSequence data, int locationId, int properties) throws XPathException {
        if (this.depth == 0) {
            this.out.startElement(this.resultPI, 630, 0, 0);
            this.out.startContent();
            this.out.processingInstruction(target, data, locationId, properties);
            this.out.endElement();
        } else {
            this.out.processingInstruction(target, data, locationId, properties);
        }
    }

    public void append(Item item, int locationId, int copyNamespaces) throws XPathException {
        if (item instanceof FunctionItem) {
            throw new XPathException("Wrapped output: cannot display a function item");
        }
        if (item instanceof ObjectValue) {
            throw new XPathException("Wrapped output: cannot display an external Java object");
        }
        if (item instanceof AtomicValue) {
            NamePool pool = this.getNamePool();
            this.out.startElement(this.resultAtomicValue, 630, 0, 0);
            AtomicType type = (AtomicType)((AtomicValue)item).getItemType(this.getConfiguration().getTypeHierarchy());
            int nameCode = type.getNameCode();
            String prefix = pool.getPrefix(nameCode);
            String localName = pool.getLocalName(nameCode);
            String uri = pool.getURI(nameCode);
            if (prefix.length() == 0 && (prefix = pool.suggestPrefixForURI(uri)) == null) {
                prefix = "p" + uri.hashCode();
            }
            int nscode = pool.allocateNamespaceCode(prefix, uri);
            String displayName = prefix + ':' + localName;
            this.out.namespace(nscode, 0);
            this.out.attribute(this.xsiType, 631, displayName, 0, 0);
            this.out.startContent();
            this.out.characters(item.getStringValue(), 0, 0);
            this.out.endElement();
        } else {
            ((NodeInfo)item).copy(this, 6, locationId);
        }
    }

    public void startContent() throws XPathException {
        this.out.startContent();
    }

    public void close() throws XPathException {
        this.out.endElement();
        this.out.endDocument();
        this.out.close();
    }

    public boolean usesTypeAnnotations() {
        return true;
    }
}

