/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.functions;

import com.icl.saxon.Context;
import com.icl.saxon.expr.Expression;
import com.icl.saxon.expr.Function;
import com.icl.saxon.expr.StringValue;
import com.icl.saxon.expr.Value;
import com.icl.saxon.expr.XPathException;
import com.icl.saxon.om.NodeEnumeration;

public class NamespaceURI
extends Function {
    public String getName() {
        return "namespace-uri";
    }

    public int getDataType() {
        return 3;
    }

    public Expression simplify() throws XPathException {
        int n = this.checkArgumentCount(0, 1);
        if (n == 1) {
            this.argument[0] = this.argument[0].simplify();
        }
        return this;
    }

    public String evaluateAsString(Context context) throws XPathException {
        NodeEnumeration nodeEnumeration;
        String string = this.getNumberOfArguments() == 1 ? ((nodeEnumeration = this.argument[0].enumerate(context, true)).hasMoreElements() ? nodeEnumeration.nextElement().getURI() : null) : context.getContextNodeInfo().getURI();
        return string == null ? "" : string;
    }

    public Value evaluate(Context context) throws XPathException {
        return new StringValue(this.evaluateAsString(context));
    }

    public int getDependencies() {
        if (this.getNumberOfArguments() == 1) {
            return this.argument[0].getDependencies();
        }
        return 8;
    }

    public Expression reduce(int n, Context context) throws XPathException {
        if (this.getNumberOfArguments() == 1) {
            NamespaceURI namespaceURI = new NamespaceURI();
            namespaceURI.addArgument(this.argument[0].reduce(n, context));
            namespaceURI.setStaticContext(this.getStaticContext());
            return namespaceURI.simplify();
        }
        if ((n & 8) != 0) {
            return this.evaluate(context);
        }
        return this;
    }
}

