[@@@warning "-9-27"]
include Ctypes
let lift x = x
open Ctypes_static

let rec field : type t a. t typ -> string -> a typ -> (a, t) field =
  fun s fname ftype -> match s, fname with
  | Struct ({ tag = "`Env_item"; _} as s'), "value" ->
    let f = {ftype; fname; foffset = 8} in 
    (s'.fields <- BoxedField f :: s'.fields; f)
  | Struct ({ tag = "`Env_item"; _} as s'), "name" ->
    let f = {ftype; fname; foffset = 0} in 
    (s'.fields <- BoxedField f :: s'.fields; f)
  | Struct ({ tag = "`Timespec64"; _} as s'), "tv_nsec" ->
    let f = {ftype; fname; foffset = 8} in 
    (s'.fields <- BoxedField f :: s'.fields; f)
  | Struct ({ tag = "`Timespec64"; _} as s'), "tv_sec" ->
    let f = {ftype; fname; foffset = 0} in 
    (s'.fields <- BoxedField f :: s'.fields; f)
  | Struct ({ tag = "`Timeval64"; _} as s'), "tv_usec" ->
    let f = {ftype; fname; foffset = 8} in 
    (s'.fields <- BoxedField f :: s'.fields; f)
  | Struct ({ tag = "`Timeval64"; _} as s'), "tv_sec" ->
    let f = {ftype; fname; foffset = 0} in 
    (s'.fields <- BoxedField f :: s'.fields; f)
  | Struct ({ tag = "`Group"; _} as s'), "members" ->
    let f = {ftype; fname; foffset = 16} in 
    (s'.fields <- BoxedField f :: s'.fields; f)
  | Struct ({ tag = "`Group"; _} as s'), "gid" ->
    let f = {ftype; fname; foffset = 8} in 
    (s'.fields <- BoxedField f :: s'.fields; f)
  | Struct ({ tag = "`Group"; _} as s'), "groupname" ->
    let f = {ftype; fname; foffset = 0} in 
    (s'.fields <- BoxedField f :: s'.fields; f)
  | Struct ({ tag = "`Passwd"; _} as s'), "homedir" ->
    let f = {ftype; fname; foffset = 32} in 
    (s'.fields <- BoxedField f :: s'.fields; f)
  | Struct ({ tag = "`Passwd"; _} as s'), "shell" ->
    let f = {ftype; fname; foffset = 24} in 
    (s'.fields <- BoxedField f :: s'.fields; f)
  | Struct ({ tag = "`Passwd"; _} as s'), "gid" ->
    let f = {ftype; fname; foffset = 16} in 
    (s'.fields <- BoxedField f :: s'.fields; f)
  | Struct ({ tag = "`Passwd"; _} as s'), "uid" ->
    let f = {ftype; fname; foffset = 8} in 
    (s'.fields <- BoxedField f :: s'.fields; f)
  | Struct ({ tag = "`Passwd"; _} as s'), "username" ->
    let f = {ftype; fname; foffset = 0} in 
    (s'.fields <- BoxedField f :: s'.fields; f)
  | Struct ({ tag = "uv_interface_address_s"; _} as s'), "netmask.netmask6" ->
    let f = {ftype; fname; foffset = 48} in 
    (s'.fields <- BoxedField f :: s'.fields; f)
  | Struct ({ tag = "uv_interface_address_s"; _} as s'), "netmask.netmask4" ->
    let f = {ftype; fname; foffset = 48} in 
    (s'.fields <- BoxedField f :: s'.fields; f)
  | Struct ({ tag = "uv_interface_address_s"; _} as s'), "address.address6" ->
    let f = {ftype; fname; foffset = 20} in 
    (s'.fields <- BoxedField f :: s'.fields; f)
  | Struct ({ tag = "uv_interface_address_s"; _} as s'), "address.address4" ->
    let f = {ftype; fname; foffset = 20} in 
    (s'.fields <- BoxedField f :: s'.fields; f)
  | Struct ({ tag = "uv_interface_address_s"; _} as s'), "is_internal" ->
    let f = {ftype; fname; foffset = 16} in 
    (s'.fields <- BoxedField f :: s'.fields; f)
  | Struct ({ tag = "uv_interface_address_s"; _} as s'), "phys_addr" ->
    let f = {ftype; fname; foffset = 8} in 
    (s'.fields <- BoxedField f :: s'.fields; f)
  | Struct ({ tag = "uv_interface_address_s"; _} as s'), "name" ->
    let f = {ftype; fname; foffset = 0} in 
    (s'.fields <- BoxedField f :: s'.fields; f)
  | Struct ({ tag = "`CPU_info"; _} as s'), "cpu_times" ->
    let f = {ftype; fname; foffset = 16} in 
    (s'.fields <- BoxedField f :: s'.fields; f)
  | Struct ({ tag = "`CPU_info"; _} as s'), "speed" ->
    let f = {ftype; fname; foffset = 8} in 
    (s'.fields <- BoxedField f :: s'.fields; f)
  | Struct ({ tag = "`CPU_info"; _} as s'), "model" ->
    let f = {ftype; fname; foffset = 0} in 
    (s'.fields <- BoxedField f :: s'.fields; f)
  | Struct ({ tag = "uv_cpu_times_s"; _} as s'), "irq" ->
    let f = {ftype; fname; foffset = 32} in 
    (s'.fields <- BoxedField f :: s'.fields; f)
  | Struct ({ tag = "uv_cpu_times_s"; _} as s'), "idle" ->
    let f = {ftype; fname; foffset = 24} in 
    (s'.fields <- BoxedField f :: s'.fields; f)
  | Struct ({ tag = "uv_cpu_times_s"; _} as s'), "sys" ->
    let f = {ftype; fname; foffset = 16} in 
    (s'.fields <- BoxedField f :: s'.fields; f)
  | Struct ({ tag = "uv_cpu_times_s"; _} as s'), "nice" ->
    let f = {ftype; fname; foffset = 8} in 
    (s'.fields <- BoxedField f :: s'.fields; f)
  | Struct ({ tag = "uv_cpu_times_s"; _} as s'), "user" ->
    let f = {ftype; fname; foffset = 0} in 
    (s'.fields <- BoxedField f :: s'.fields; f)
  | Struct ({ tag = "`Rusage"; _} as s'), "ru_nivcsw" ->
    let f = {ftype; fname; foffset = 136} in 
    (s'.fields <- BoxedField f :: s'.fields; f)
  | Struct ({ tag = "`Rusage"; _} as s'), "ru_nvcsw" ->
    let f = {ftype; fname; foffset = 128} in 
    (s'.fields <- BoxedField f :: s'.fields; f)
  | Struct ({ tag = "`Rusage"; _} as s'), "ru_nsignals" ->
    let f = {ftype; fname; foffset = 120} in 
    (s'.fields <- BoxedField f :: s'.fields; f)
  | Struct ({ tag = "`Rusage"; _} as s'), "ru_msgrcv" ->
    let f = {ftype; fname; foffset = 112} in 
    (s'.fields <- BoxedField f :: s'.fields; f)
  | Struct ({ tag = "`Rusage"; _} as s'), "ru_msgsnd" ->
    let f = {ftype; fname; foffset = 104} in 
    (s'.fields <- BoxedField f :: s'.fields; f)
  | Struct ({ tag = "`Rusage"; _} as s'), "ru_oublock" ->
    let f = {ftype; fname; foffset = 96} in 
    (s'.fields <- BoxedField f :: s'.fields; f)
  | Struct ({ tag = "`Rusage"; _} as s'), "ru_inblock" ->
    let f = {ftype; fname; foffset = 88} in 
    (s'.fields <- BoxedField f :: s'.fields; f)
  | Struct ({ tag = "`Rusage"; _} as s'), "ru_nswap" ->
    let f = {ftype; fname; foffset = 80} in 
    (s'.fields <- BoxedField f :: s'.fields; f)
  | Struct ({ tag = "`Rusage"; _} as s'), "ru_majflt" ->
    let f = {ftype; fname; foffset = 72} in 
    (s'.fields <- BoxedField f :: s'.fields; f)
  | Struct ({ tag = "`Rusage"; _} as s'), "ru_minflt" ->
    let f = {ftype; fname; foffset = 64} in 
    (s'.fields <- BoxedField f :: s'.fields; f)
  | Struct ({ tag = "`Rusage"; _} as s'), "ru_isrss" ->
    let f = {ftype; fname; foffset = 56} in 
    (s'.fields <- BoxedField f :: s'.fields; f)
  | Struct ({ tag = "`Rusage"; _} as s'), "ru_idrss" ->
    let f = {ftype; fname; foffset = 48} in 
    (s'.fields <- BoxedField f :: s'.fields; f)
  | Struct ({ tag = "`Rusage"; _} as s'), "ru_ixrss" ->
    let f = {ftype; fname; foffset = 40} in 
    (s'.fields <- BoxedField f :: s'.fields; f)
  | Struct ({ tag = "`Rusage"; _} as s'), "ru_maxrss" ->
    let f = {ftype; fname; foffset = 32} in 
    (s'.fields <- BoxedField f :: s'.fields; f)
  | Struct ({ tag = "`Rusage"; _} as s'), "ru_stime" ->
    let f = {ftype; fname; foffset = 16} in 
    (s'.fields <- BoxedField f :: s'.fields; f)
  | Struct ({ tag = "`Rusage"; _} as s'), "ru_utime" ->
    let f = {ftype; fname; foffset = 0} in 
    (s'.fields <- BoxedField f :: s'.fields; f)
  | Struct ({ tag = "`Timeval"; _} as s'), "tv_usec" ->
    let f = {ftype; fname; foffset = 8} in 
    (s'.fields <- BoxedField f :: s'.fields; f)
  | Struct ({ tag = "`Timeval"; _} as s'), "tv_sec" ->
    let f = {ftype; fname; foffset = 0} in 
    (s'.fields <- BoxedField f :: s'.fields; f)
  | Struct ({ tag = "`Thread_options"; _} as s'), "stack_size" ->
    let f = {ftype; fname; foffset = 8} in 
    (s'.fields <- BoxedField f :: s'.fields; f)
  | Struct ({ tag = "`Thread_options"; _} as s'), "flags" ->
    let f = {ftype; fname; foffset = 0} in 
    (s'.fields <- BoxedField f :: s'.fields; f)
  | Struct ({ tag = "`Name_info"; _} as s'), "service" ->
    let f = {ftype; fname; foffset = 1277} in 
    (s'.fields <- BoxedField f :: s'.fields; f)
  | Struct ({ tag = "`Name_info"; _} as s'), "host" ->
    let f = {ftype; fname; foffset = 252} in 
    (s'.fields <- BoxedField f :: s'.fields; f)
  | Struct ({ tag = "`Addr_info"; _} as s'), "addrinfo" ->
    let f = {ftype; fname; foffset = 144} in 
    (s'.fields <- BoxedField f :: s'.fields; f)
  | Struct ({ tag = "addrinfo"; _} as s'), "ai_next" ->
    let f = {ftype; fname; foffset = 40} in 
    (s'.fields <- BoxedField f :: s'.fields; f)
  | Struct ({ tag = "addrinfo"; _} as s'), "ai_canonname" ->
    let f = {ftype; fname; foffset = 32} in 
    (s'.fields <- BoxedField f :: s'.fields; f)
  | Struct ({ tag = "addrinfo"; _} as s'), "ai_addr" ->
    let f = {ftype; fname; foffset = 24} in 
    (s'.fields <- BoxedField f :: s'.fields; f)
  | Struct ({ tag = "addrinfo"; _} as s'), "ai_addrlen" ->
    let f = {ftype; fname; foffset = 16} in 
    (s'.fields <- BoxedField f :: s'.fields; f)
  | Struct ({ tag = "addrinfo"; _} as s'), "ai_protocol" ->
    let f = {ftype; fname; foffset = 12} in 
    (s'.fields <- BoxedField f :: s'.fields; f)
  | Struct ({ tag = "addrinfo"; _} as s'), "ai_socktype" ->
    let f = {ftype; fname; foffset = 8} in 
    (s'.fields <- BoxedField f :: s'.fields; f)
  | Struct ({ tag = "addrinfo"; _} as s'), "ai_family" ->
    let f = {ftype; fname; foffset = 4} in 
    (s'.fields <- BoxedField f :: s'.fields; f)
  | Struct ({ tag = "addrinfo"; _} as s'), "ai_flags" ->
    let f = {ftype; fname; foffset = 0} in 
    (s'.fields <- BoxedField f :: s'.fields; f)
  | Struct ({ tag = "`Redirection"; _} as s'), "data.fd" ->
    let f = {ftype; fname; foffset = 8} in 
    (s'.fields <- BoxedField f :: s'.fields; f)
  | Struct ({ tag = "`Redirection"; _} as s'), "data.stream" ->
    let f = {ftype; fname; foffset = 8} in 
    (s'.fields <- BoxedField f :: s'.fields; f)
  | Struct ({ tag = "`Redirection"; _} as s'), "flags" ->
    let f = {ftype; fname; foffset = 0} in 
    (s'.fields <- BoxedField f :: s'.fields; f)
  | Struct ({ tag = "`Statfs"; _} as s'), "f_spare" ->
    let f = {ftype; fname; foffset = 56} in 
    (s'.fields <- BoxedField f :: s'.fields; f)
  | Struct ({ tag = "`Statfs"; _} as s'), "f_ffree" ->
    let f = {ftype; fname; foffset = 48} in 
    (s'.fields <- BoxedField f :: s'.fields; f)
  | Struct ({ tag = "`Statfs"; _} as s'), "f_files" ->
    let f = {ftype; fname; foffset = 40} in 
    (s'.fields <- BoxedField f :: s'.fields; f)
  | Struct ({ tag = "`Statfs"; _} as s'), "f_bavail" ->
    let f = {ftype; fname; foffset = 32} in 
    (s'.fields <- BoxedField f :: s'.fields; f)
  | Struct ({ tag = "`Statfs"; _} as s'), "f_bfree" ->
    let f = {ftype; fname; foffset = 24} in 
    (s'.fields <- BoxedField f :: s'.fields; f)
  | Struct ({ tag = "`Statfs"; _} as s'), "f_blocks" ->
    let f = {ftype; fname; foffset = 16} in 
    (s'.fields <- BoxedField f :: s'.fields; f)
  | Struct ({ tag = "`Statfs"; _} as s'), "f_bsize" ->
    let f = {ftype; fname; foffset = 8} in 
    (s'.fields <- BoxedField f :: s'.fields; f)
  | Struct ({ tag = "`Statfs"; _} as s'), "f_type" ->
    let f = {ftype; fname; foffset = 0} in 
    (s'.fields <- BoxedField f :: s'.fields; f)
  | Struct ({ tag = "`Stat"; _} as s'), "st_birthtim" ->
    let f = {ftype; fname; foffset = 144} in 
    (s'.fields <- BoxedField f :: s'.fields; f)
  | Struct ({ tag = "`Stat"; _} as s'), "st_ctim" ->
    let f = {ftype; fname; foffset = 128} in 
    (s'.fields <- BoxedField f :: s'.fields; f)
  | Struct ({ tag = "`Stat"; _} as s'), "st_mtim" ->
    let f = {ftype; fname; foffset = 112} in 
    (s'.fields <- BoxedField f :: s'.fields; f)
  | Struct ({ tag = "`Stat"; _} as s'), "st_atim" ->
    let f = {ftype; fname; foffset = 96} in 
    (s'.fields <- BoxedField f :: s'.fields; f)
  | Struct ({ tag = "`Stat"; _} as s'), "st_gen" ->
    let f = {ftype; fname; foffset = 88} in 
    (s'.fields <- BoxedField f :: s'.fields; f)
  | Struct ({ tag = "`Stat"; _} as s'), "st_flags" ->
    let f = {ftype; fname; foffset = 80} in 
    (s'.fields <- BoxedField f :: s'.fields; f)
  | Struct ({ tag = "`Stat"; _} as s'), "st_blocks" ->
    let f = {ftype; fname; foffset = 72} in 
    (s'.fields <- BoxedField f :: s'.fields; f)
  | Struct ({ tag = "`Stat"; _} as s'), "st_blksize" ->
    let f = {ftype; fname; foffset = 64} in 
    (s'.fields <- BoxedField f :: s'.fields; f)
  | Struct ({ tag = "`Stat"; _} as s'), "st_size" ->
    let f = {ftype; fname; foffset = 56} in 
    (s'.fields <- BoxedField f :: s'.fields; f)
  | Struct ({ tag = "`Stat"; _} as s'), "st_ino" ->
    let f = {ftype; fname; foffset = 48} in 
    (s'.fields <- BoxedField f :: s'.fields; f)
  | Struct ({ tag = "`Stat"; _} as s'), "st_rdev" ->
    let f = {ftype; fname; foffset = 40} in 
    (s'.fields <- BoxedField f :: s'.fields; f)
  | Struct ({ tag = "`Stat"; _} as s'), "st_gid" ->
    let f = {ftype; fname; foffset = 32} in 
    (s'.fields <- BoxedField f :: s'.fields; f)
  | Struct ({ tag = "`Stat"; _} as s'), "st_uid" ->
    let f = {ftype; fname; foffset = 24} in 
    (s'.fields <- BoxedField f :: s'.fields; f)
  | Struct ({ tag = "`Stat"; _} as s'), "st_nlink" ->
    let f = {ftype; fname; foffset = 16} in 
    (s'.fields <- BoxedField f :: s'.fields; f)
  | Struct ({ tag = "`Stat"; _} as s'), "st_mode" ->
    let f = {ftype; fname; foffset = 8} in 
    (s'.fields <- BoxedField f :: s'.fields; f)
  | Struct ({ tag = "`Stat"; _} as s'), "st_dev" ->
    let f = {ftype; fname; foffset = 0} in 
    (s'.fields <- BoxedField f :: s'.fields; f)
  | Struct ({ tag = "`Timespec"; _} as s'), "tv_nsec" ->
    let f = {ftype; fname; foffset = 8} in 
    (s'.fields <- BoxedField f :: s'.fields; f)
  | Struct ({ tag = "`Timespec"; _} as s'), "tv_sec" ->
    let f = {ftype; fname; foffset = 0} in 
    (s'.fields <- BoxedField f :: s'.fields; f)
  | Struct ({ tag = "`Dir"; _} as s'), "nentries" ->
    let f = {ftype; fname; foffset = 8} in 
    (s'.fields <- BoxedField f :: s'.fields; f)
  | Struct ({ tag = "`Dir"; _} as s'), "dirents" ->
    let f = {ftype; fname; foffset = 0} in 
    (s'.fields <- BoxedField f :: s'.fields; f)
  | Struct ({ tag = "`Dirent"; _} as s'), "type" ->
    let f = {ftype; fname; foffset = 8} in 
    (s'.fields <- BoxedField f :: s'.fields; f)
  | Struct ({ tag = "`Dirent"; _} as s'), "name" ->
    let f = {ftype; fname; foffset = 0} in 
    (s'.fields <- BoxedField f :: s'.fields; f)
  | Struct ({ tag = "sockaddr_storage"; _} as s'), "ss_family" ->
    let f = {ftype; fname; foffset = 0} in 
    (s'.fields <- BoxedField f :: s'.fields; f)
  | Struct ({ tag = "sockaddr_in6"; _} as s'), "sin6_port" ->
    let f = {ftype; fname; foffset = 2} in 
    (s'.fields <- BoxedField f :: s'.fields; f)
  | Struct ({ tag = "sockaddr_in"; _} as s'), "sin_port" ->
    let f = {ftype; fname; foffset = 2} in 
    (s'.fields <- BoxedField f :: s'.fields; f)
  | Struct ({ tag = "`Connect"; _} as s'), "handle" ->
    let f = {ftype; fname; foffset = 72} in 
    (s'.fields <- BoxedField f :: s'.fields; f)
  | Struct ({ tag = "`Signal"; _} as s'), "signum" ->
    let f = {ftype; fname; foffset = 104} in 
    (s'.fields <- BoxedField f :: s'.fields; f)
  | Struct ({ tag = "`Buf"; _} as s'), "len" ->
    let f = {ftype; fname; foffset = 8} in 
    (s'.fields <- BoxedField f :: s'.fields; f)
  | Struct ({ tag = "`Buf"; _} as s'), "base" ->
    let f = {ftype; fname; foffset = 0} in 
    (s'.fields <- BoxedField f :: s'.fields; f)
  | Struct ({ tag = "`Metrics"; _} as s'), "events_waiting" ->
    let f = {ftype; fname; foffset = 16} in 
    (s'.fields <- BoxedField f :: s'.fields; f)
  | Struct ({ tag = "`Metrics"; _} as s'), "events" ->
    let f = {ftype; fname; foffset = 8} in 
    (s'.fields <- BoxedField f :: s'.fields; f)
  | Struct ({ tag = "`Metrics"; _} as s'), "loop_count" ->
    let f = {ftype; fname; foffset = 0} in 
    (s'.fields <- BoxedField f :: s'.fields; f)
  | View { ty; _ }, _ ->
    let { ftype; foffset; fname } = field ty fname ftype in
    { ftype; foffset; fname }
  | _ -> failwith ("Unexpected field "^ fname)

let rec seal : type a. a typ -> unit = function
  | Struct ({ tag = "`Random"; spec = Incomplete _; _ } as s') ->
    s'.spec <- Complete { size = 144; align = 8 }
  | Struct ({ tag = "`Env_item"; spec = Incomplete _; _ } as s') ->
    s'.spec <- Complete { size = 16; align = 8 }
  | Struct ({ tag = "`Timespec64"; spec = Incomplete _; _ } as s') ->
    s'.spec <- Complete { size = 16; align = 8 }
  | Struct ({ tag = "`Timeval64"; spec = Incomplete _; _ } as s') ->
    s'.spec <- Complete { size = 16; align = 8 }
  | Struct ({ tag = "`Group"; spec = Incomplete _; _ } as s') ->
    s'.spec <- Complete { size = 24; align = 8 }
  | Struct ({ tag = "`Passwd"; spec = Incomplete _; _ } as s') ->
    s'.spec <- Complete { size = 40; align = 8 }
  | Struct ({ tag = "uv_interface_address_s"; spec = Incomplete _; _ } as s') ->
    s'.spec <- Complete { size = 80; align = 8 }
  | Struct ({ tag = "`CPU_info"; spec = Incomplete _; _ } as s') ->
    s'.spec <- Complete { size = 56; align = 8 }
  | Struct ({ tag = "uv_cpu_times_s"; spec = Incomplete _; _ } as s') ->
    s'.spec <- Complete { size = 40; align = 8 }
  | Struct ({ tag = "`Rusage"; spec = Incomplete _; _ } as s') ->
    s'.spec <- Complete { size = 144; align = 8 }
  | Struct ({ tag = "`Timeval"; spec = Incomplete _; _ } as s') ->
    s'.spec <- Complete { size = 16; align = 8 }
  | Struct ({ tag = "`Barrier"; spec = Incomplete _; _ } as s') ->
    s'.spec <- Complete { size = 32; align = 8 }
  | Struct ({ tag = "`Condition"; spec = Incomplete _; _ } as s') ->
    s'.spec <- Complete { size = 48; align = 8 }
  | Struct ({ tag = "`Semaphore"; spec = Incomplete _; _ } as s') ->
    s'.spec <- Complete { size = 32; align = 8 }
  | Struct ({ tag = "`Rwlock"; spec = Incomplete _; _ } as s') ->
    s'.spec <- Complete { size = 56; align = 8 }
  | Struct ({ tag = "`Mutex"; spec = Incomplete _; _ } as s') ->
    s'.spec <- Complete { size = 40; align = 8 }
  | Struct ({ tag = "`Once"; spec = Incomplete _; _ } as s') ->
    s'.spec <- Complete { size = 4; align = 4 }
  | Struct ({ tag = "`TLS"; spec = Incomplete _; _ } as s') ->
    s'.spec <- Complete { size = 4; align = 4 }
  | Struct ({ tag = "`Thread_options"; spec = Incomplete _; _ } as s') ->
    s'.spec <- Complete { size = 16; align = 8 }
  | Struct ({ tag = "`Thread"; spec = Incomplete _; _ } as s') ->
    s'.spec <- Complete { size = 8; align = 8 }
  | Struct ({ tag = "`Thread_pool"; spec = Incomplete _; _ } as s') ->
    s'.spec <- Complete { size = 128; align = 8 }
  | Struct ({ tag = "`Lib"; spec = Incomplete _; _ } as s') ->
    s'.spec <- Complete { size = 16; align = 8 }
  | Struct ({ tag = "`Name_info"; spec = Incomplete _; _ } as s') ->
    s'.spec <- Complete { size = 1320; align = 8 }
  | Struct ({ tag = "`Addr_info"; spec = Incomplete _; _ } as s') ->
    s'.spec <- Complete { size = 160; align = 8 }
  | Struct ({ tag = "addrinfo"; spec = Incomplete _; _ } as s') ->
    s'.spec <- Complete { size = 48; align = 8 }
  | Struct ({ tag = "`FS_poll"; spec = Incomplete _; _ } as s') ->
    s'.spec <- Complete { size = 104; align = 8 }
  | Struct ({ tag = "`FS_event"; spec = Incomplete _; _ } as s') ->
    s'.spec <- Complete { size = 136; align = 8 }
  | Struct ({ tag = "`Redirection"; spec = Incomplete _; _ } as s') ->
    s'.spec <- Complete { size = 16; align = 8 }
  | Struct ({ tag = "`Process"; spec = Incomplete _; _ } as s') ->
    s'.spec <- Complete { size = 136; align = 8 }
  | Struct ({ tag = "`Send"; spec = Incomplete _; _ } as s') ->
    s'.spec <- Complete { size = 320; align = 8 }
  | Struct ({ tag = "`UDP"; spec = Incomplete _; _ } as s') ->
    s'.spec <- Complete { size = 216; align = 8 }
  | Struct ({ tag = "`TTY"; spec = Incomplete _; _ } as s') ->
    s'.spec <- Complete { size = 312; align = 8 }
  | Struct ({ tag = "`Pipe"; spec = Incomplete _; _ } as s') ->
    s'.spec <- Complete { size = 264; align = 8 }
  | Struct ({ tag = "`Statfs"; spec = Incomplete _; _ } as s') ->
    s'.spec <- Complete { size = 88; align = 8 }
  | Struct ({ tag = "`Stat"; spec = Incomplete _; _ } as s') ->
    s'.spec <- Complete { size = 160; align = 8 }
  | Struct ({ tag = "`Timespec"; spec = Incomplete _; _ } as s') ->
    s'.spec <- Complete { size = 16; align = 8 }
  | Struct ({ tag = "`Dir"; spec = Incomplete _; _ } as s') ->
    s'.spec <- Complete { size = 56; align = 8 }
  | Struct ({ tag = "`Dirent"; spec = Incomplete _; _ } as s') ->
    s'.spec <- Complete { size = 16; align = 8 }
  | Struct ({ tag = "`File"; spec = Incomplete _; _ } as s') ->
    s'.spec <- Complete { size = 440; align = 8 }
  | Struct ({ tag = "`TCP"; spec = Incomplete _; _ } as s') ->
    s'.spec <- Complete { size = 248; align = 8 }
  | Struct ({ tag = "sockaddr_storage"; spec = Incomplete _; _ } as s') ->
    s'.spec <- Complete { size = 128; align = 8 }
  | Struct ({ tag = "sockaddr_in6"; spec = Incomplete _; _ } as s') ->
    s'.spec <- Complete { size = 28; align = 4 }
  | Struct ({ tag = "sockaddr_in"; spec = Incomplete _; _ } as s') ->
    s'.spec <- Complete { size = 16; align = 4 }
  | Struct ({ tag = "sockaddr"; spec = Incomplete _; _ } as s') ->
    s'.spec <- Complete { size = 16; align = 2 }
  | Struct ({ tag = "`Address_family"; spec = Incomplete _; _ } as s') ->
    s'.spec <- Complete { size = 2; align = 2 }
  | Struct ({ tag = "`Write"; spec = Incomplete _; _ } as s') ->
    s'.spec <- Complete { size = 192; align = 8 }
  | Struct ({ tag = "`Shutdown"; spec = Incomplete _; _ } as s') ->
    s'.spec <- Complete { size = 80; align = 8 }
  | Struct ({ tag = "`Connect"; spec = Incomplete _; _ } as s') ->
    s'.spec <- Complete { size = 96; align = 8 }
  | Struct ({ tag = "`Stream"; spec = Incomplete _; _ } as s') ->
    s'.spec <- Complete { size = 248; align = 8 }
  | Struct ({ tag = "`Signal"; spec = Incomplete _; _ } as s') ->
    s'.spec <- Complete { size = 152; align = 8 }
  | Struct ({ tag = "`Poll"; spec = Incomplete _; _ } as s') ->
    s'.spec <- Complete { size = 160; align = 8 }
  | Struct ({ tag = "`Async"; spec = Incomplete _; _ } as s') ->
    s'.spec <- Complete { size = 128; align = 8 }
  | Struct ({ tag = "`Idle"; spec = Incomplete _; _ } as s') ->
    s'.spec <- Complete { size = 120; align = 8 }
  | Struct ({ tag = "`Check"; spec = Incomplete _; _ } as s') ->
    s'.spec <- Complete { size = 120; align = 8 }
  | Struct ({ tag = "`Prepare"; spec = Incomplete _; _ } as s') ->
    s'.spec <- Complete { size = 120; align = 8 }
  | Struct ({ tag = "`Timer"; spec = Incomplete _; _ } as s') ->
    s'.spec <- Complete { size = 152; align = 8 }
  | Struct ({ tag = "`Request"; spec = Incomplete _; _ } as s') ->
    s'.spec <- Complete { size = 64; align = 8 }
  | Struct ({ tag = "`Handle`"; spec = Incomplete _; _ } as s') ->
    s'.spec <- Complete { size = 96; align = 8 }
  | Struct ({ tag = "`Os_socket"; spec = Incomplete _; _ } as s') ->
    s'.spec <- Complete { size = 4; align = 4 }
  | Struct ({ tag = "`Os_fd"; spec = Incomplete _; _ } as s') ->
    s'.spec <- Complete { size = 4; align = 4 }
  | Struct ({ tag = "`Buf"; spec = Incomplete _; _ } as s') ->
    s'.spec <- Complete { size = 16; align = 8 }
  | Struct ({ tag = "`Metrics"; spec = Incomplete _; _ } as s') ->
    s'.spec <- Complete { size = 128; align = 8 }
  | Struct ({ tag = "`Loop"; spec = Incomplete _; _ } as s') ->
    s'.spec <- Complete { size = 848; align = 8 }
  | Struct { tag; spec = Complete _; _ } ->
    raise (ModifyingSealedType tag)
  | Union { utag; uspec = Some _; _ } ->
    raise (ModifyingSealedType utag)
  | View { ty; _ } -> seal ty
  | _ ->
    raise (Unsupported "Sealing a non-structured type")

type 'a const = 'a
let constant (type t) name (t : t typ) : t = match t, name with
  | Ctypes_static.Primitive Cstubs_internals.Int, "UV_CLOCK_REALTIME" ->
    1
  | Ctypes_static.Primitive Cstubs_internals.Int, "UV_CLOCK_MONOTONIC" ->
    0
  | Ctypes_static.Primitive Cstubs_internals.Int, "UV_MAXHOSTNAMESIZE" ->
    65
  | Ctypes_static.Primitive Cstubs_internals.Int, "UV_IF_NAMESIZE" ->
    17
  | Ctypes_static.Primitive Cstubs_internals.Int, "UV_PRIORITY_HIGHEST" ->
    -20
  | Ctypes_static.Primitive Cstubs_internals.Int, "UV_PRIORITY_HIGH" ->
    -14
  | Ctypes_static.Primitive Cstubs_internals.Int, "UV_PRIORITY_ABOVE_NORMAL" ->
    -7
  | Ctypes_static.Primitive Cstubs_internals.Int, "UV_PRIORITY_NORMAL" ->
    0
  | Ctypes_static.Primitive Cstubs_internals.Int, "UV_PRIORITY_BELOW_NORMAL" ->
    10
  | Ctypes_static.Primitive Cstubs_internals.Int, "UV_PRIORITY_LOW" ->
    19
  | Ctypes_static.Primitive Cstubs_internals.Int, "UV_THREAD_PRIORITY_LOWEST" ->
    -2
  | Ctypes_static.Primitive Cstubs_internals.Int, "UV_THREAD_PRIORITY_BELOW_NORMAL" ->
    -1
  | Ctypes_static.Primitive Cstubs_internals.Int, "UV_THREAD_PRIORITY_NORMAL" ->
    0
  | Ctypes_static.Primitive Cstubs_internals.Int, "UV_THREAD_PRIORITY_ABOVE_NORMAL" ->
    1
  | Ctypes_static.Primitive Cstubs_internals.Int, "UV_THREAD_PRIORITY_HIGHEST" ->
    2
  | Ctypes_static.Primitive Cstubs_internals.Int, "UV_THREAD_HAS_STACK_SIZE" ->
    1
  | Ctypes_static.Primitive Cstubs_internals.Int, "UV_THREAD_NO_FLAGS" ->
    0
  | Ctypes_static.Primitive Cstubs_internals.Int, "LUV_WORK_FUNCTION" ->
    2
  | Ctypes_static.Primitive Cstubs_internals.Int, "LUV_WORK_REFERENCE_COUNT" ->
    3
  | Ctypes_static.Primitive Cstubs_internals.Int, "NI_NUMERICSERV" ->
    2
  | Ctypes_static.Primitive Cstubs_internals.Int, "NI_NUMERICHOST" ->
    1
  | Ctypes_static.Primitive Cstubs_internals.Int, "NI_NOFQDN" ->
    4
  | Ctypes_static.Primitive Cstubs_internals.Int, "NI_DGRAM" ->
    16
  | Ctypes_static.Primitive Cstubs_internals.Int, "NI_NAMEREQD" ->
    8
  | Ctypes_static.Primitive Cstubs_internals.Int, "NI_MAXSERV" ->
    32
  | Ctypes_static.Primitive Cstubs_internals.Int, "NI_MAXHOST" ->
    1025
  | Ctypes_static.Primitive Cstubs_internals.Int, "AI_ADDRCONFIG" ->
    32
  | Ctypes_static.Primitive Cstubs_internals.Int, "AI_ALL" ->
    16
  | Ctypes_static.Primitive Cstubs_internals.Int, "AI_V4MAPPED" ->
    8
  | Ctypes_static.Primitive Cstubs_internals.Int, "AI_NUMERICSERV" ->
    1024
  | Ctypes_static.Primitive Cstubs_internals.Int, "AI_NUMERICHOST" ->
    4
  | Ctypes_static.Primitive Cstubs_internals.Int, "AI_CANONNAME" ->
    2
  | Ctypes_static.Primitive Cstubs_internals.Int, "AI_PASSIVE" ->
    1
  | Ctypes_static.Primitive Cstubs_internals.Int, "UV_FS_EVENT_RECURSIVE" ->
    4
  | Ctypes_static.Primitive Cstubs_internals.Int, "UV_FS_EVENT_STAT" ->
    2
  | Ctypes_static.Primitive Cstubs_internals.Int, "UV_FS_EVENT_WATCH_ENTRY" ->
    1
  | Ctypes_static.Primitive Cstubs_internals.Int, "UV_CHANGE" ->
    2
  | Ctypes_static.Primitive Cstubs_internals.Int, "UV_RENAME" ->
    1
  | Ctypes_static.Primitive Cstubs_internals.Int, "UV_OVERLAPPED_PIPE" ->
    64
  | Ctypes_static.Primitive Cstubs_internals.Int, "UV_WRITABLE_PIPE" ->
    32
  | Ctypes_static.Primitive Cstubs_internals.Int, "UV_READABLE_PIPE" ->
    16
  | Ctypes_static.Primitive Cstubs_internals.Int, "UV_INHERIT_STREAM" ->
    4
  | Ctypes_static.Primitive Cstubs_internals.Int, "UV_INHERIT_FD" ->
    2
  | Ctypes_static.Primitive Cstubs_internals.Int, "UV_CREATE_PIPE" ->
    1
  | Ctypes_static.Primitive Cstubs_internals.Int, "UV_IGNORE" ->
    0
  | Ctypes_static.Primitive Cstubs_internals.Int, "UV_PROCESS_WINDOWS_FILE_PATH_EXACT_NAME" ->
    128
  | Ctypes_static.Primitive Cstubs_internals.Int, "UV_PROCESS_WINDOWS_HIDE_GUI" ->
    64
  | Ctypes_static.Primitive Cstubs_internals.Int, "UV_PROCESS_WINDOWS_HIDE_CONSOLE" ->
    32
  | Ctypes_static.Primitive Cstubs_internals.Int, "UV_PROCESS_WINDOWS_HIDE" ->
    16
  | Ctypes_static.Primitive Cstubs_internals.Int, "UV_PROCESS_DETACHED" ->
    8
  | Ctypes_static.Primitive Cstubs_internals.Int, "UV_PROCESS_WINDOWS_VERBATIM_ARGUMENTS" ->
    4
  | Ctypes_static.Primitive Cstubs_internals.Int, "UV_PROCESS_SETGID" ->
    2
  | Ctypes_static.Primitive Cstubs_internals.Int, "UV_PROCESS_SETUID" ->
    1
  | Ctypes_static.Primitive Cstubs_internals.Int64_t, "UV_JOIN_GROUP" ->
    1L
  | Ctypes_static.Primitive Cstubs_internals.Int64_t, "UV_LEAVE_GROUP" ->
    0L
  | Ctypes_static.Primitive Cstubs_internals.Int, "UV_UDP_RECVMMSG" ->
    256
  | Ctypes_static.Primitive Cstubs_internals.Int, "UV_UDP_MMSG_FREE" ->
    16
  | Ctypes_static.Primitive Cstubs_internals.Int, "UV_UDP_MMSG_CHUNK" ->
    8
  | Ctypes_static.Primitive Cstubs_internals.Int, "UV_UDP_REUSEADDR" ->
    4
  | Ctypes_static.Primitive Cstubs_internals.Int, "UV_UDP_PARTIAL" ->
    2
  | Ctypes_static.Primitive Cstubs_internals.Int, "UV_UDP_IPV6ONLY" ->
    1
  | Ctypes_static.Primitive Cstubs_internals.Int, "LUV_UDP_ALLOCATE_CALLBACK" ->
    3
  | Ctypes_static.Primitive Cstubs_internals.Int, "LUV_UDP_REFERENCE_COUNT" ->
    4
  | Ctypes_static.Primitive Cstubs_internals.Int64_t, "UV_TTY_UNSUPPORTED" ->
    1L
  | Ctypes_static.Primitive Cstubs_internals.Int64_t, "UV_TTY_SUPPORTED" ->
    0L
  | Ctypes_static.Primitive Cstubs_internals.Int64_t, "UV_TTY_MODE_IO" ->
    2L
  | Ctypes_static.Primitive Cstubs_internals.Int64_t, "UV_TTY_MODE_RAW" ->
    1L
  | Ctypes_static.Primitive Cstubs_internals.Int64_t, "UV_TTY_MODE_NORMAL" ->
    0L
  | Ctypes_static.Primitive Cstubs_internals.Int, "UV_PIPE_NO_TRUNCATE" ->
    1
  | Ctypes_static.Primitive Cstubs_internals.Int, "UV_FS_SYMLINK_JUNCTION" ->
    2
  | Ctypes_static.Primitive Cstubs_internals.Int, "UV_FS_SYMLINK_DIR" ->
    1
  | Ctypes_static.Primitive Cstubs_internals.Int, "X_OK" ->
    1
  | Ctypes_static.Primitive Cstubs_internals.Int, "W_OK" ->
    2
  | Ctypes_static.Primitive Cstubs_internals.Int, "R_OK" ->
    4
  | Ctypes_static.Primitive Cstubs_internals.Int, "F_OK" ->
    0
  | Ctypes_static.Primitive Cstubs_internals.Int, "UV_FS_COPYFILE_FICLONE_FORCE" ->
    4
  | Ctypes_static.Primitive Cstubs_internals.Int, "UV_FS_COPYFILE_FICLONE" ->
    2
  | Ctypes_static.Primitive Cstubs_internals.Int, "UV_FS_COPYFILE_EXCL" ->
    1
  | Ctypes_static.Primitive Cstubs_internals.Int64_t, "UV_DIRENT_BLOCK" ->
    7L
  | Ctypes_static.Primitive Cstubs_internals.Int64_t, "UV_DIRENT_CHAR" ->
    6L
  | Ctypes_static.Primitive Cstubs_internals.Int64_t, "UV_DIRENT_SOCKET" ->
    5L
  | Ctypes_static.Primitive Cstubs_internals.Int64_t, "UV_DIRENT_FIFO" ->
    4L
  | Ctypes_static.Primitive Cstubs_internals.Int64_t, "UV_DIRENT_LINK" ->
    3L
  | Ctypes_static.Primitive Cstubs_internals.Int64_t, "UV_DIRENT_DIR" ->
    2L
  | Ctypes_static.Primitive Cstubs_internals.Int64_t, "UV_DIRENT_FILE" ->
    1L
  | Ctypes_static.Primitive Cstubs_internals.Int64_t, "UV_DIRENT_UNKNOWN" ->
    0L
  | Ctypes_static.Primitive Cstubs_internals.Int, "S_IFIFO" ->
    4096
  | Ctypes_static.Primitive Cstubs_internals.Int, "S_IFLNK" ->
    40960
  | Ctypes_static.Primitive Cstubs_internals.Int, "S_IFCHR" ->
    8192
  | Ctypes_static.Primitive Cstubs_internals.Int, "S_IFBLK" ->
    24576
  | Ctypes_static.Primitive Cstubs_internals.Int, "S_IFDIR" ->
    16384
  | Ctypes_static.Primitive Cstubs_internals.Int, "S_IFREG" ->
    32768
  | Ctypes_static.Primitive Cstubs_internals.Int, "S_IFMT" ->
    61440
  | Ctypes_static.Primitive Cstubs_internals.Int, "S_ISVTX" ->
    512
  | Ctypes_static.Primitive Cstubs_internals.Int, "S_ISGID" ->
    1024
  | Ctypes_static.Primitive Cstubs_internals.Int, "S_ISUID" ->
    2048
  | Ctypes_static.Primitive Cstubs_internals.Int, "S_IXOTH" ->
    1
  | Ctypes_static.Primitive Cstubs_internals.Int, "S_IWOTH" ->
    2
  | Ctypes_static.Primitive Cstubs_internals.Int, "S_IROTH" ->
    4
  | Ctypes_static.Primitive Cstubs_internals.Int, "S_IRWXO" ->
    7
  | Ctypes_static.Primitive Cstubs_internals.Int, "S_IXGRP" ->
    8
  | Ctypes_static.Primitive Cstubs_internals.Int, "S_IWGRP" ->
    16
  | Ctypes_static.Primitive Cstubs_internals.Int, "S_IRGRP" ->
    32
  | Ctypes_static.Primitive Cstubs_internals.Int, "S_IRWXG" ->
    56
  | Ctypes_static.Primitive Cstubs_internals.Int, "S_IXUSR" ->
    64
  | Ctypes_static.Primitive Cstubs_internals.Int, "S_IWUSR" ->
    128
  | Ctypes_static.Primitive Cstubs_internals.Int, "S_IRUSR" ->
    256
  | Ctypes_static.Primitive Cstubs_internals.Int, "S_IRWXU" ->
    448
  | Ctypes_static.Primitive Cstubs_internals.Int, "UV_FS_O_SYNC" ->
    1052672
  | Ctypes_static.Primitive Cstubs_internals.Int, "UV_FS_O_SYMLINK" ->
    0
  | Ctypes_static.Primitive Cstubs_internals.Int, "UV_FS_O_SHORT_LIVED" ->
    0
  | Ctypes_static.Primitive Cstubs_internals.Int, "UV_FS_O_SEQUENTIAL" ->
    0
  | Ctypes_static.Primitive Cstubs_internals.Int, "UV_FS_O_RANDOM" ->
    0
  | Ctypes_static.Primitive Cstubs_internals.Int, "UV_FS_O_NONBLOCK" ->
    2048
  | Ctypes_static.Primitive Cstubs_internals.Int, "UV_FS_O_NOATIME" ->
    0
  | Ctypes_static.Primitive Cstubs_internals.Int, "UV_FS_O_FILEMAP" ->
    0
  | Ctypes_static.Primitive Cstubs_internals.Int, "UV_FS_O_DSYNC" ->
    4096
  | Ctypes_static.Primitive Cstubs_internals.Int, "UV_FS_O_DIRECT" ->
    16384
  | Ctypes_static.Primitive Cstubs_internals.Int, "UV_FS_O_APPEND" ->
    1024
  | Ctypes_static.Primitive Cstubs_internals.Int, "UV_FS_O_TRUNC" ->
    512
  | Ctypes_static.Primitive Cstubs_internals.Int, "UV_FS_O_TEMPORARY" ->
    0
  | Ctypes_static.Primitive Cstubs_internals.Int, "UV_FS_O_NOFOLLOW" ->
    131072
  | Ctypes_static.Primitive Cstubs_internals.Int, "UV_FS_O_NOCTTY" ->
    256
  | Ctypes_static.Primitive Cstubs_internals.Int, "UV_FS_O_EXLOCK" ->
    0
  | Ctypes_static.Primitive Cstubs_internals.Int, "UV_FS_O_EXCL" ->
    128
  | Ctypes_static.Primitive Cstubs_internals.Int, "UV_FS_O_CREAT" ->
    64
  | Ctypes_static.Primitive Cstubs_internals.Int, "UV_FS_O_RDWR" ->
    2
  | Ctypes_static.Primitive Cstubs_internals.Int, "UV_FS_O_WRONLY" ->
    1
  | Ctypes_static.Primitive Cstubs_internals.Int, "UV_FS_O_RDONLY" ->
    0
  | Ctypes_static.Primitive Cstubs_internals.Int, "UV_TCP_IPV6ONLY" ->
    1
  | Ctypes_static.Primitive Cstubs_internals.Int, "SOCK_RAW" ->
    3
  | Ctypes_static.Primitive Cstubs_internals.Int, "SOCK_DGRAM" ->
    2
  | Ctypes_static.Primitive Cstubs_internals.Int, "SOCK_STREAM" ->
    1
  | Ctypes_static.Primitive Cstubs_internals.Int, "AF_INET6" ->
    10
  | Ctypes_static.Primitive Cstubs_internals.Int, "AF_INET" ->
    2
  | Ctypes_static.Primitive Cstubs_internals.Int, "AF_UNSPEC" ->
    0
  | Ctypes_static.Primitive Cstubs_internals.Int, "LUV_ALLOCATE_CALLBACK" ->
    3
  | Ctypes_static.Primitive Cstubs_internals.Int, "LUV_CONNECTION_CALLBACK" ->
    4
  | Ctypes_static.Primitive Cstubs_internals.Int, "LUV_STREAM_REFERENCE_COUNT" ->
    5
  | Ctypes_static.Primitive Cstubs_internals.Nativeint, "SOMAXCONN" ->
    4096n
  | Ctypes_static.Primitive Cstubs_internals.Int, "SIGWINCH" ->
    28
  | Ctypes_static.Primitive Cstubs_internals.Int, "SIGTERM" ->
    15
  | Ctypes_static.Primitive Cstubs_internals.Int, "SIGSEGV" ->
    11
  | Ctypes_static.Primitive Cstubs_internals.Int, "SIGKILL" ->
    9
  | Ctypes_static.Primitive Cstubs_internals.Int, "SIGINT" ->
    2
  | Ctypes_static.Primitive Cstubs_internals.Int, "SIGILL" ->
    4
  | Ctypes_static.Primitive Cstubs_internals.Int, "SIGHUP" ->
    1
  | Ctypes_static.Primitive Cstubs_internals.Int, "SIGFPE" ->
    8
  | Ctypes_static.Primitive Cstubs_internals.Int, "SIGABRT" ->
    6
  | Ctypes_static.Primitive Cstubs_internals.Int, "UV_PRIORITIZED" ->
    8
  | Ctypes_static.Primitive Cstubs_internals.Int, "UV_DISCONNECT" ->
    4
  | Ctypes_static.Primitive Cstubs_internals.Int, "UV_WRITABLE" ->
    2
  | Ctypes_static.Primitive Cstubs_internals.Int, "UV_READABLE" ->
    1
  | Ctypes_static.Primitive Cstubs_internals.Int, "LUV_MINIMUM_REFERENCE_COUNT" ->
    2
  | Ctypes_static.Primitive Cstubs_internals.Int, "LUV_HANDLE_REFERENCE_COUNT" ->
    3
  | Ctypes_static.Primitive Cstubs_internals.Int, "LUV_CLOSE_CALLBACK" ->
    2
  | Ctypes_static.Primitive Cstubs_internals.Int, "LUV_GENERIC_CALLBACK" ->
    1
  | Ctypes_static.Primitive Cstubs_internals.Int, "LUV_SELF_REFERENCE" ->
    0
  | Ctypes_static.Primitive Cstubs_internals.Int, "UV_NAMED_PIPE" ->
    7
  | Ctypes_static.Primitive Cstubs_internals.Int, "UV_TCP" ->
    12
  | Ctypes_static.Primitive Cstubs_internals.Int, "UV_METRICS_IDLE_TIME" ->
    1
  | Ctypes_static.Primitive Cstubs_internals.Int, "SIGPROF" ->
    27
  | Ctypes_static.Primitive Cstubs_internals.Int, "UV_LOOP_BLOCK_SIGNAL" ->
    0
  | Ctypes_static.Primitive Cstubs_internals.Int64_t, "UV_RUN_NOWAIT" ->
    2L
  | Ctypes_static.Primitive Cstubs_internals.Int64_t, "UV_RUN_ONCE" ->
    1L
  | Ctypes_static.Primitive Cstubs_internals.Int64_t, "UV_RUN_DEFAULT" ->
    0L
  | Ctypes_static.Primitive Cstubs_internals.Int, "UV_VERSION_HEX" ->
    78082
  | Ctypes_static.Primitive Cstubs_internals.Bool, "UV_VERSION_IS_RELEASE" ->
    ((1) <> 0)
  | Ctypes_static.Primitive Cstubs_internals.Int, "UV_VERSION_PATCH" ->
    2
  | Ctypes_static.Primitive Cstubs_internals.Int, "UV_VERSION_MINOR" ->
    49
  | Ctypes_static.Primitive Cstubs_internals.Int, "UV_VERSION_MAJOR" ->
    1
  | Ctypes_static.Primitive Cstubs_internals.Int, "UV_EMLINK" ->
    -31
  | Ctypes_static.Primitive Cstubs_internals.Int, "UV_ENXIO" ->
    -6
  | Ctypes_static.Primitive Cstubs_internals.Int, "UV_EOF" ->
    -4095
  | Ctypes_static.Primitive Cstubs_internals.Int, "UV_UNKNOWN" ->
    -4094
  | Ctypes_static.Primitive Cstubs_internals.Int, "UV_EXDEV" ->
    -18
  | Ctypes_static.Primitive Cstubs_internals.Int, "UV_EUNATCH" ->
    -49
  | Ctypes_static.Primitive Cstubs_internals.Int, "UV_ETXTBSY" ->
    -26
  | Ctypes_static.Primitive Cstubs_internals.Int, "UV_ETIMEDOUT" ->
    -110
  | Ctypes_static.Primitive Cstubs_internals.Int, "UV_ESRCH" ->
    -3
  | Ctypes_static.Primitive Cstubs_internals.Int, "UV_ESPIPE" ->
    -29
  | Ctypes_static.Primitive Cstubs_internals.Int, "UV_ESOCKTNOSUPPORT" ->
    -94
  | Ctypes_static.Primitive Cstubs_internals.Int, "UV_ESHUTDOWN" ->
    -108
  | Ctypes_static.Primitive Cstubs_internals.Int, "UV_EROFS" ->
    -30
  | Ctypes_static.Primitive Cstubs_internals.Int, "UV_ERANGE" ->
    -34
  | Ctypes_static.Primitive Cstubs_internals.Int, "UV_EPROTOTYPE" ->
    -91
  | Ctypes_static.Primitive Cstubs_internals.Int, "UV_EPROTONOSUPPORT" ->
    -93
  | Ctypes_static.Primitive Cstubs_internals.Int, "UV_EPROTO" ->
    -71
  | Ctypes_static.Primitive Cstubs_internals.Int, "UV_EPIPE" ->
    -32
  | Ctypes_static.Primitive Cstubs_internals.Int, "UV_EPERM" ->
    -1
  | Ctypes_static.Primitive Cstubs_internals.Int, "UV_EOVERFLOW" ->
    -75
  | Ctypes_static.Primitive Cstubs_internals.Int, "UV_ENOTTY" ->
    -25
  | Ctypes_static.Primitive Cstubs_internals.Int, "UV_ENOTSUP" ->
    -95
  | Ctypes_static.Primitive Cstubs_internals.Int, "UV_ENOTSOCK" ->
    -88
  | Ctypes_static.Primitive Cstubs_internals.Int, "UV_ENOTEMPTY" ->
    -39
  | Ctypes_static.Primitive Cstubs_internals.Int, "UV_ENOTDIR" ->
    -20
  | Ctypes_static.Primitive Cstubs_internals.Int, "UV_ENOTCONN" ->
    -107
  | Ctypes_static.Primitive Cstubs_internals.Int, "UV_ENOSYS" ->
    -38
  | Ctypes_static.Primitive Cstubs_internals.Int, "UV_ENOSPC" ->
    -28
  | Ctypes_static.Primitive Cstubs_internals.Int, "UV_ENOPROTOOPT" ->
    -92
  | Ctypes_static.Primitive Cstubs_internals.Int, "UV_ENONET" ->
    -64
  | Ctypes_static.Primitive Cstubs_internals.Int, "UV_ENOMEM" ->
    -12
  | Ctypes_static.Primitive Cstubs_internals.Int, "UV_ENOENT" ->
    -2
  | Ctypes_static.Primitive Cstubs_internals.Int, "UV_ENODEV" ->
    -19
  | Ctypes_static.Primitive Cstubs_internals.Int, "UV_ENODATA" ->
    -61
  | Ctypes_static.Primitive Cstubs_internals.Int, "UV_ENOBUFS" ->
    -105
  | Ctypes_static.Primitive Cstubs_internals.Int, "UV_ENFILE" ->
    -23
  | Ctypes_static.Primitive Cstubs_internals.Int, "UV_ENETUNREACH" ->
    -101
  | Ctypes_static.Primitive Cstubs_internals.Int, "UV_ENETDOWN" ->
    -100
  | Ctypes_static.Primitive Cstubs_internals.Int, "UV_ENAMETOOLONG" ->
    -36
  | Ctypes_static.Primitive Cstubs_internals.Int, "UV_EMSGSIZE" ->
    -90
  | Ctypes_static.Primitive Cstubs_internals.Int, "UV_EMFILE" ->
    -24
  | Ctypes_static.Primitive Cstubs_internals.Int, "UV_ELOOP" ->
    -40
  | Ctypes_static.Primitive Cstubs_internals.Int, "UV_EISDIR" ->
    -21
  | Ctypes_static.Primitive Cstubs_internals.Int, "UV_EISCONN" ->
    -106
  | Ctypes_static.Primitive Cstubs_internals.Int, "UV_EIO" ->
    -5
  | Ctypes_static.Primitive Cstubs_internals.Int, "UV_EINVAL" ->
    -22
  | Ctypes_static.Primitive Cstubs_internals.Int, "UV_EINTR" ->
    -4
  | Ctypes_static.Primitive Cstubs_internals.Int, "UV_EILSEQ" ->
    -84
  | Ctypes_static.Primitive Cstubs_internals.Int, "UV_EHOSTUNREACH" ->
    -113
  | Ctypes_static.Primitive Cstubs_internals.Int, "UV_EFTYPE" ->
    -4028
  | Ctypes_static.Primitive Cstubs_internals.Int, "UV_EFBIG" ->
    -27
  | Ctypes_static.Primitive Cstubs_internals.Int, "UV_EFAULT" ->
    -14
  | Ctypes_static.Primitive Cstubs_internals.Int, "UV_EEXIST" ->
    -17
  | Ctypes_static.Primitive Cstubs_internals.Int, "UV_EDESTADDRREQ" ->
    -89
  | Ctypes_static.Primitive Cstubs_internals.Int, "UV_ECONNRESET" ->
    -104
  | Ctypes_static.Primitive Cstubs_internals.Int, "UV_ECONNREFUSED" ->
    -111
  | Ctypes_static.Primitive Cstubs_internals.Int, "UV_ECONNABORTED" ->
    -103
  | Ctypes_static.Primitive Cstubs_internals.Int, "UV_ECANCELED" ->
    -125
  | Ctypes_static.Primitive Cstubs_internals.Int, "UV_EBUSY" ->
    -16
  | Ctypes_static.Primitive Cstubs_internals.Int, "UV_EBADF" ->
    -9
  | Ctypes_static.Primitive Cstubs_internals.Int, "UV_EALREADY" ->
    -114
  | Ctypes_static.Primitive Cstubs_internals.Int, "UV_EAI_SOCKTYPE" ->
    -3011
  | Ctypes_static.Primitive Cstubs_internals.Int, "UV_EAI_SERVICE" ->
    -3010
  | Ctypes_static.Primitive Cstubs_internals.Int, "UV_EAI_PROTOCOL" ->
    -3014
  | Ctypes_static.Primitive Cstubs_internals.Int, "UV_EAI_OVERFLOW" ->
    -3009
  | Ctypes_static.Primitive Cstubs_internals.Int, "UV_EAI_NONAME" ->
    -3008
  | Ctypes_static.Primitive Cstubs_internals.Int, "UV_EAI_NODATA" ->
    -3007
  | Ctypes_static.Primitive Cstubs_internals.Int, "UV_EAI_MEMORY" ->
    -3006
  | Ctypes_static.Primitive Cstubs_internals.Int, "UV_EAI_FAMILY" ->
    -3005
  | Ctypes_static.Primitive Cstubs_internals.Int, "UV_EAI_FAIL" ->
    -3004
  | Ctypes_static.Primitive Cstubs_internals.Int, "UV_EAI_CANCELED" ->
    -3003
  | Ctypes_static.Primitive Cstubs_internals.Int, "UV_EAI_BADHINTS" ->
    -3013
  | Ctypes_static.Primitive Cstubs_internals.Int, "UV_EAI_BADFLAGS" ->
    -3002
  | Ctypes_static.Primitive Cstubs_internals.Int, "UV_EAI_AGAIN" ->
    -3001
  | Ctypes_static.Primitive Cstubs_internals.Int, "UV_EAI_ADDRFAMILY" ->
    -3000
  | Ctypes_static.Primitive Cstubs_internals.Int, "UV_EAGAIN" ->
    -11
  | Ctypes_static.Primitive Cstubs_internals.Int, "UV_EAFNOSUPPORT" ->
    -97
  | Ctypes_static.Primitive Cstubs_internals.Int, "UV_EADDRNOTAVAIL" ->
    -99
  | Ctypes_static.Primitive Cstubs_internals.Int, "UV_EADDRINUSE" ->
    -98
  | Ctypes_static.Primitive Cstubs_internals.Int, "UV_EACCES" ->
    -13
  | Ctypes_static.Primitive Cstubs_internals.Int, "UV_E2BIG" ->
    -7
  | _, s -> failwith ("unmatched constant: "^ s)

let enum (type a) name ?typedef ?unexpected (alist : (a * int64) list) =
  match name with
  | "uv_membership" -> 
    Cstubs_internals.build_enum_type "uv_membership" Ctypes_static.Uint32 ?typedef ?unexpected alist
  | "uv_tty_vtermstate_t" -> 
    Cstubs_internals.build_enum_type "uv_tty_vtermstate_t" Ctypes_static.Uint32 ?typedef ?unexpected alist
  | "uv_tty_mode_t" -> 
    Cstubs_internals.build_enum_type "uv_tty_mode_t" Ctypes_static.Uint32 ?typedef ?unexpected alist
  | "uv_dirent_type_t" -> 
    Cstubs_internals.build_enum_type "uv_dirent_type_t" Ctypes_static.Uint32 ?typedef ?unexpected alist
  | "uv_run_mode" -> 
    Cstubs_internals.build_enum_type "uv_run_mode" Ctypes_static.Uint32 ?typedef ?unexpected alist
  | s ->
    failwith ("unmatched enum: "^ s)
