/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.resolver;

import com.thaiopensource.resolver.Identifier;
import com.thaiopensource.resolver.Input;
import com.thaiopensource.resolver.Resolver;
import com.thaiopensource.resolver.ResolverException;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;

public class BasicResolver
implements Resolver {
    private static final BasicResolver theInstance = new BasicResolver();

    protected BasicResolver() {
    }

    public static BasicResolver getInstance() {
        return theInstance;
    }

    public void resolve(Identifier identifier, Input input) throws IOException, ResolverException {
        if (!input.isResolved()) {
            input.setUri(BasicResolver.resolveUri(identifier));
        }
    }

    public void open(Input input) throws IOException, ResolverException {
        URI uRI;
        if (!input.isUriDefinitive()) {
            return;
        }
        try {
            uRI = new URI(input.getUri());
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new ResolverException(uRISyntaxException);
        }
        if (!uRI.isAbsolute()) {
            throw new ResolverException("cannot open relative URI: " + uRI);
        }
        URL uRL = new URL(uRI.toASCIIString());
        input.setByteStream(uRL.openStream());
    }

    public static String resolveUri(Identifier identifier) throws ResolverException {
        try {
            String string;
            String string2 = identifier.getUriReference();
            URI uRI = new URI(string2);
            if (!uRI.isAbsolute() && (string = identifier.getBase()) != null) {
                return new URI(string).resolve(uRI).toString();
            }
            return string2;
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new ResolverException(uRISyntaxException);
        }
    }
}

