/*
 * Decompiled with CFR 0.152.
 */
package org.python.core.io;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import org.python.core.Py;
import org.python.core.io.SocketIOBase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SocketIO
extends SocketIOBase<SocketChannel> {
    public SocketIO(SocketChannel socketChannel, String mode) {
        super(socketChannel, mode);
    }

    @Override
    public int readinto(ByteBuffer buf) {
        this.checkClosed();
        this.checkReadable();
        try {
            return ((SocketChannel)this.socketChannel).read(buf);
        }
        catch (IOException ioe) {
            throw Py.IOError(ioe);
        }
    }

    @Override
    public long readinto(ByteBuffer[] bufs) {
        this.checkClosed();
        this.checkReadable();
        try {
            return ((SocketChannel)this.socketChannel).read(bufs);
        }
        catch (IOException ioe) {
            throw Py.IOError(ioe);
        }
    }

    @Override
    public int write(ByteBuffer buf) {
        this.checkClosed();
        this.checkWritable();
        try {
            return ((SocketChannel)this.socketChannel).write(buf);
        }
        catch (IOException ioe) {
            throw Py.IOError(ioe);
        }
    }

    @Override
    public long write(ByteBuffer[] bufs) {
        this.checkClosed();
        this.checkWritable();
        try {
            return ((SocketChannel)this.socketChannel).write(bufs);
        }
        catch (IOException ioe) {
            throw Py.IOError(ioe);
        }
    }
}

