/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.library;

import com.xmlcalabash.core.XProcConstants;
import com.xmlcalabash.core.XProcException;
import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.io.ReadablePipe;
import com.xmlcalabash.io.WritablePipe;
import com.xmlcalabash.library.DefaultStep;
import com.xmlcalabash.model.RuntimeValue;
import com.xmlcalabash.runtime.XAtomicStep;
import com.xmlcalabash.util.Base64;
import com.xmlcalabash.util.S9apiUtils;
import com.xmlcalabash.util.TreeWriter;
import com.xmlcalabash.util.XMLtoJSON;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.URI;
import java.net.URLConnection;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.Serializer;
import net.sf.saxon.s9api.XdmNode;

public class Store
extends DefaultStep {
    private static final QName _href = new QName("href");
    private static final QName _encoding = new QName("encoding");
    private static final QName _content_type = new QName("content-type");
    private static final QName c_encoding = new QName("c", "http://www.w3.org/ns/xproc-step", "encoding");
    private static final QName c_body = new QName("c", "http://www.w3.org/ns/xproc-step", "body");
    private static final QName c_json = new QName("c", "http://www.w3.org/ns/xproc-step", "json");
    private static final QName cx_decode = new QName("cx", "http://xmlcalabash.com/ns/extensions", "decode");
    private ReadablePipe source = null;
    private WritablePipe result = null;

    public Store(XProcRuntime xProcRuntime, XAtomicStep xAtomicStep) {
        super(xProcRuntime, xAtomicStep);
    }

    @Override
    public void setInput(String string, ReadablePipe readablePipe) {
        this.source = readablePipe;
    }

    @Override
    public void setOutput(String string, WritablePipe writablePipe) {
        this.result = writablePipe;
    }

    @Override
    public void reset() {
        this.source.resetReader();
        this.result.resetWriter();
    }

    @Override
    public void run() throws SaxonApiException {
        super.run();
        if (this.runtime.getSafeMode()) {
            throw XProcException.dynamicError(21);
        }
        URI uRI = null;
        RuntimeValue runtimeValue = this.getOption(_href);
        XdmNode xdmNode = this.source.read();
        if (xdmNode == null || this.source.moreDocuments()) {
            throw XProcException.dynamicError(6);
        }
        uRI = runtimeValue != null ? runtimeValue.getBaseURI().resolve(runtimeValue.getString()) : xdmNode.getBaseURI();
        this.finer(runtimeValue.getNode(), "Storing to \"" + uRI + "\".");
        String string = this.step.getExtensionAttribute(cx_decode);
        XdmNode xdmNode2 = S9apiUtils.getDocumentElement(xdmNode);
        if (("true".equals(string) || "1".equals(string)) && ("http://www.w3.org/ns/xproc-step".equals(xdmNode2.getNodeName().getNamespaceURI()) && "base64".equals(xdmNode2.getAttributeValue(_encoding)) || "".equals(xdmNode2.getNodeName().getNamespaceURI()) && "base64".equals(xdmNode2.getAttributeValue(c_encoding)))) {
            this.storeBinary(xdmNode, uRI);
        } else if (this.runtime.transparentJSON() && (c_body.equals((Object)xdmNode2.getNodeName()) && ("application/json".equals(xdmNode2.getAttributeValue(_content_type)) || "text/json".equals(xdmNode2.getAttributeValue(_content_type))) || c_json.equals((Object)xdmNode2.getNodeName()) || "http://www.ibm.com/xmlns/prod/2009/jsonx".equals(xdmNode2.getNodeName().getNamespaceURI()) || "http://www.xmlsh.org/jxml".equals(xdmNode2.getNodeName().getNamespaceURI()) || "http://marklogic.com/json".equals(xdmNode2.getNodeName().getNamespaceURI()))) {
            this.storeJSON(xdmNode, uRI);
        } else {
            this.storeXML(xdmNode, uRI);
        }
        TreeWriter treeWriter = new TreeWriter(this.runtime);
        treeWriter.startDocument(this.step.getNode().getBaseURI());
        treeWriter.addStartElement(XProcConstants.c_result);
        treeWriter.startContent();
        treeWriter.addText(uRI.toString());
        treeWriter.addEndElement();
        treeWriter.endDocument();
        this.result.write(treeWriter.getResult());
    }

    private void storeXML(XdmNode xdmNode, URI uRI) throws SaxonApiException {
        Serializer serializer = this.makeSerializer();
        try {
            OutputStream outputStream;
            if (uRI.getScheme().equals("file")) {
                File file = new File(uRI);
                File file2 = new File(file.getParent());
                if (!file2.isDirectory() && !file2.mkdirs()) {
                    throw XProcException.stepError(50);
                }
                outputStream = new FileOutputStream(file);
            } else {
                URLConnection uRLConnection = uRI.toURL().openConnection();
                uRLConnection.setDoOutput(true);
                outputStream = uRLConnection.getOutputStream();
            }
            serializer.setOutputStream(outputStream);
            S9apiUtils.serialize(this.runtime, xdmNode, serializer);
            outputStream.close();
        }
        catch (IOException iOException) {
            throw XProcException.stepError(50, iOException);
        }
    }

    private void storeBinary(XdmNode xdmNode, URI uRI) {
        try {
            byte[] byArray = Base64.decode(xdmNode.getStringValue());
            File file = new File(uRI);
            File file2 = new File(file.getParent());
            if (!file2.isDirectory() && !file2.mkdirs()) {
                throw XProcException.stepError(50);
            }
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            fileOutputStream.write(byArray);
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            throw new XProcException(iOException);
        }
    }

    private void storeJSON(XdmNode xdmNode, URI uRI) throws SaxonApiException {
        try {
            OutputStream outputStream;
            Object object;
            Object object2;
            if (uRI.getScheme().equals("file")) {
                object2 = new File(uRI);
                object = new File(((File)object2).getParent());
                if (!((File)object).isDirectory() && !((File)object).mkdirs()) {
                    throw XProcException.stepError(50);
                }
                outputStream = new FileOutputStream((File)object2);
            } else {
                object2 = uRI.toURL().openConnection();
                ((URLConnection)object2).setDoOutput(true);
                outputStream = ((URLConnection)object2).getOutputStream();
            }
            object2 = new PrintWriter(outputStream);
            object = XMLtoJSON.convert(xdmNode);
            ((PrintWriter)object2).print((String)object);
            ((PrintWriter)object2).close();
            outputStream.close();
        }
        catch (IOException iOException) {
            throw XProcException.stepError(50, iOException);
        }
    }
}

