# Copyright 1999-2023 Gentoo Authors
# Distributed under the terms of the GNU General Public License v2

EAPI=8

# ebuild generated by hackport 0.7.2.1.9999

CABAL_HACKAGE_REVISION=5

CABAL_FEATURES="lib profile haddock hoogle hscolour"
inherit ghc-package haskell-cabal

DESCRIPTION="Knowledge of GHC's installation directories"
HOMEPAGE="https://hackage.haskell.org/package/ghc-paths"

LICENSE="BSD"
SLOT="0/${PV}"
KEYWORDS="~amd64 ~arm64 ~ppc64 ~riscv ~x86"

RDEPEND=">=dev-lang/ghc-8.4.3:=
"
DEPEND="${RDEPEND}
	>=dev-haskell/cabal-2.2.0.1 <dev-haskell/cabal-3.11
"

src_prepare() {
	haskell-cabal_src_prepare

	# ghc-patch it has awfully unportable (across cabal versions) ghc detection code
	# but in gentoo we install it to fixed patch, so remove Setup.hs detection code
	cabal-mksetup

	# and use gentoo's hardcoded one:
	# a few things we need to replace, and example values
	# GHC_PATHS_LIBDIR /usr/lib64/ghc-6.12.0.20091010
	# GHC_PATHS_DOCDIR /usr/share/doc/ghc-6.12.0.20091010/html
	# GHC_PATHS_GHC_PKG /usr/bin/ghc-pkg
	# GHC_PATHS_GHC /usr/bin/ghc (be careful: GHC_PATHS_GHC is a substring of GHC_PATHS_GHC_PKG)

	cat >"${S}/GHC/Paths.hs" <<-EOF
	module GHC.Paths ( ghc, ghc_pkg, libdir, docdir ) where

	libdir, docdir, ghc, ghc_pkg :: FilePath

	libdir  = "$(ghc-libdir)"
	docdir  = "/usr/share/doc/ghc-$(ghc-version)/html"

	ghc     = "$(ghc-getghc)"
	ghc_pkg = "$(ghc-getghcpkg)"
	EOF
}
