/*
 * Author: MontaVista Software, Inc.
 *         source@mvista.com
 *
 * Copyright 2001-2002 MontaVista Software Inc.
 *
 *  This program is free software; you can redistribute it and/or modify it
 *  under the terms of the GNU General Public License as published by the
 *  Free Software Foundation; either version 2 of the License, or (at your
 *  option) any later version.
 *
 *  THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESS OR IMPLIED
 *  WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 *  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *  IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 *  INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 *  BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS
 *  OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 *  ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR
 *  TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE
 *  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  675 Mass Ave, Cambridge, MA 02139, USA.
 */
#ifndef __ASM_TX4927_TX4927_MIPS_H
#define __ASM_TX4927_TX4927_MIPS_H

#ifndef __ASSEMBLY__

static inline void asm_wait(void)
{
	__asm__(".set\tmips3\n\t"
		"wait\n\t"
		".set\tmips0");
}

#define reg_rd08(r)    ((u8 )(*((vu8 *)(r))))
#define reg_rd16(r)    ((u16)(*((vu16*)(r))))
#define reg_rd32(r)    ((u32)(*((vu32*)(r))))
#define reg_rd64(r)    ((u64)(*((vu64*)(r))))

#define reg_wr08(r,v)  ((*((vu8 *)(r)))=((u8 )(v)))
#define reg_wr16(r,v)  ((*((vu16*)(r)))=((u16)(v)))
#define reg_wr32(r,v)  ((*((vu32*)(r)))=((u32)(v)))
#define reg_wr64(r,v)  ((*((vu64*)(r)))=((u64)(v)))

typedef volatile __signed char vs8;
typedef volatile unsigned char vu8;

typedef volatile __signed short vs16;
typedef volatile unsigned short vu16;

typedef volatile __signed int vs32;
typedef volatile unsigned int vu32;

typedef  s8  s08;
typedef vs8 vs08;

typedef  u8  u08;
typedef vu8 vu08;


#if (_MIPS_SZLONG == 64)

typedef volatile __signed__ long vs64;
typedef volatile unsigned long vu64;

#else

typedef volatile __signed__ long long vs64;
typedef volatile unsigned long long vu64;

#endif


#define BM_00_00 0x0000000000000001
#define BM_01_00 0x0000000000000003
#define BM_00_01 BM_01_00
#define BM_02_00 0x0000000000000007
#define BM_00_02 BM_02_00
#define BM_03_00 0x000000000000000f
#define BM_00_03 BM_03_00
#define BM_04_00 0x000000000000001f
#define BM_00_04 BM_04_00
#define BM_05_00 0x000000000000003f
#define BM_00_05 BM_05_00
#define BM_06_00 0x000000000000007f
#define BM_00_06 BM_06_00
#define BM_07_00 0x00000000000000ff
#define BM_00_07 BM_07_00
#define BM_08_00 0x00000000000001ff
#define BM_00_08 BM_08_00
#define BM_09_00 0x00000000000003ff
#define BM_00_09 BM_09_00
#define BM_10_00 0x00000000000007ff
#define BM_00_10 BM_10_00
#define BM_11_00 0x0000000000000fff
#define BM_00_11 BM_11_00
#define BM_12_00 0x0000000000001fff
#define BM_00_12 BM_12_00
#define BM_13_00 0x0000000000003fff
#define BM_00_13 BM_13_00
#define BM_14_00 0x0000000000007fff
#define BM_00_14 BM_14_00
#define BM_15_00 0x000000000000ffff
#define BM_00_15 BM_15_00
#define BM_16_00 0x000000000001ffff
#define BM_00_16 BM_16_00
#define BM_17_00 0x000000000003ffff
#define BM_00_17 BM_17_00
#define BM_18_00 0x000000000007ffff
#define BM_00_18 BM_18_00
#define BM_19_00 0x00000000000fffff
#define BM_00_19 BM_19_00
#define BM_20_00 0x00000000001fffff
#define BM_00_20 BM_20_00
#define BM_21_00 0x00000000003fffff
#define BM_00_21 BM_21_00
#define BM_22_00 0x00000000007fffff
#define BM_00_22 BM_22_00
#define BM_23_00 0x0000000000ffffff
#define BM_00_23 BM_23_00
#define BM_24_00 0x0000000001ffffff
#define BM_00_24 BM_24_00
#define BM_25_00 0x0000000003ffffff
#define BM_00_25 BM_25_00
#define BM_26_00 0x0000000007ffffff
#define BM_00_26 BM_26_00
#define BM_27_00 0x000000000fffffff
#define BM_00_27 BM_27_00
#define BM_28_00 0x000000001fffffff
#define BM_00_28 BM_28_00
#define BM_29_00 0x000000003fffffff
#define BM_00_29 BM_29_00
#define BM_30_00 0x000000007fffffff
#define BM_00_30 BM_30_00
#define BM_31_00 0x00000000ffffffff
#define BM_00_31 BM_31_00
#define BM_32_00 0x00000001ffffffff
#define BM_00_32 BM_32_00
#define BM_33_00 0x00000003ffffffff
#define BM_00_33 BM_33_00
#define BM_34_00 0x00000007ffffffff
#define BM_00_34 BM_34_00
#define BM_35_00 0x0000000fffffffff
#define BM_00_35 BM_35_00
#define BM_36_00 0x0000001fffffffff
#define BM_00_36 BM_36_00
#define BM_37_00 0x0000003fffffffff
#define BM_00_37 BM_37_00
#define BM_38_00 0x0000007fffffffff
#define BM_00_38 BM_38_00
#define BM_39_00 0x000000ffffffffff
#define BM_00_39 BM_39_00
#define BM_40_00 0x000001ffffffffff
#define BM_00_40 BM_40_00
#define BM_41_00 0x000003ffffffffff
#define BM_00_41 BM_41_00
#define BM_42_00 0x000007ffffffffff
#define BM_00_42 BM_42_00
#define BM_43_00 0x00000fffffffffff
#define BM_00_43 BM_43_00
#define BM_44_00 0x00001fffffffffff
#define BM_00_44 BM_44_00
#define BM_45_00 0x00003fffffffffff
#define BM_00_45 BM_45_00
#define BM_46_00 0x00007fffffffffff
#define BM_00_46 BM_46_00
#define BM_47_00 0x0000ffffffffffff
#define BM_00_47 BM_47_00
#define BM_48_00 0x0001ffffffffffff
#define BM_00_48 BM_48_00
#define BM_49_00 0x0003ffffffffffff
#define BM_00_49 BM_49_00
#define BM_50_00 0x0007ffffffffffff
#define BM_00_50 BM_50_00
#define BM_51_00 0x000fffffffffffff
#define BM_00_51 BM_51_00
#define BM_52_00 0x001fffffffffffff
#define BM_00_52 BM_52_00
#define BM_53_00 0x003fffffffffffff
#define BM_00_53 BM_53_00
#define BM_54_00 0x007fffffffffffff
#define BM_00_54 BM_54_00
#define BM_55_00 0x00ffffffffffffff
#define BM_00_55 BM_55_00
#define BM_56_00 0x01ffffffffffffff
#define BM_00_56 BM_56_00
#define BM_57_00 0x03ffffffffffffff
#define BM_00_57 BM_57_00
#define BM_58_00 0x07ffffffffffffff
#define BM_00_58 BM_58_00
#define BM_59_00 0x0fffffffffffffff
#define BM_00_59 BM_59_00
#define BM_60_00 0x1fffffffffffffff
#define BM_00_60 BM_60_00
#define BM_61_00 0x3fffffffffffffff
#define BM_00_61 BM_61_00
#define BM_62_00 0x7fffffffffffffff
#define BM_00_62 BM_62_00
#define BM_63_00 0xffffffffffffffff
#define BM_00_63 BM_63_00
#define BM_01_01 0x0000000000000002
#define BM_02_01 0x0000000000000006
#define BM_01_02 BM_02_01
#define BM_03_01 0x000000000000000e
#define BM_01_03 BM_03_01
#define BM_04_01 0x000000000000001e
#define BM_01_04 BM_04_01
#define BM_05_01 0x000000000000003e
#define BM_01_05 BM_05_01
#define BM_06_01 0x000000000000007e
#define BM_01_06 BM_06_01
#define BM_07_01 0x00000000000000fe
#define BM_01_07 BM_07_01
#define BM_08_01 0x00000000000001fe
#define BM_01_08 BM_08_01
#define BM_09_01 0x00000000000003fe
#define BM_01_09 BM_09_01
#define BM_10_01 0x00000000000007fe
#define BM_01_10 BM_10_01
#define BM_11_01 0x0000000000000ffe
#define BM_01_11 BM_11_01
#define BM_12_01 0x0000000000001ffe
#define BM_01_12 BM_12_01
#define BM_13_01 0x0000000000003ffe
#define BM_01_13 BM_13_01
#define BM_14_01 0x0000000000007ffe
#define BM_01_14 BM_14_01
#define BM_15_01 0x000000000000fffe
#define BM_01_15 BM_15_01
#define BM_16_01 0x000000000001fffe
#define BM_01_16 BM_16_01
#define BM_17_01 0x000000000003fffe
#define BM_01_17 BM_17_01
#define BM_18_01 0x000000000007fffe
#define BM_01_18 BM_18_01
#define BM_19_01 0x00000000000ffffe
#define BM_01_19 BM_19_01
#define BM_20_01 0x00000000001ffffe
#define BM_01_20 BM_20_01
#define BM_21_01 0x00000000003ffffe
#define BM_01_21 BM_21_01
#define BM_22_01 0x00000000007ffffe
#define BM_01_22 BM_22_01
#define BM_23_01 0x0000000000fffffe
#define BM_01_23 BM_23_01
#define BM_24_01 0x0000000001fffffe
#define BM_01_24 BM_24_01
#define BM_25_01 0x0000000003fffffe
#define BM_01_25 BM_25_01
#define BM_26_01 0x0000000007fffffe
#define BM_01_26 BM_26_01
#define BM_27_01 0x000000000ffffffe
#define BM_01_27 BM_27_01
#define BM_28_01 0x000000001ffffffe
#define BM_01_28 BM_28_01
#define BM_29_01 0x000000003ffffffe
#define BM_01_29 BM_29_01
#define BM_30_01 0x000000007ffffffe
#define BM_01_30 BM_30_01
#define BM_31_01 0x00000000fffffffe
#define BM_01_31 BM_31_01
#define BM_32_01 0x00000001fffffffe
#define BM_01_32 BM_32_01
#define BM_33_01 0x00000003fffffffe
#define BM_01_33 BM_33_01
#define BM_34_01 0x00000007fffffffe
#define BM_01_34 BM_34_01
#define BM_35_01 0x0000000ffffffffe
#define BM_01_35 BM_35_01
#define BM_36_01 0x0000001ffffffffe
#define BM_01_36 BM_36_01
#define BM_37_01 0x0000003ffffffffe
#define BM_01_37 BM_37_01
#define BM_38_01 0x0000007ffffffffe
#define BM_01_38 BM_38_01
#define BM_39_01 0x000000fffffffffe
#define BM_01_39 BM_39_01
#define BM_40_01 0x000001fffffffffe
#define BM_01_40 BM_40_01
#define BM_41_01 0x000003fffffffffe
#define BM_01_41 BM_41_01
#define BM_42_01 0x000007fffffffffe
#define BM_01_42 BM_42_01
#define BM_43_01 0x00000ffffffffffe
#define BM_01_43 BM_43_01
#define BM_44_01 0x00001ffffffffffe
#define BM_01_44 BM_44_01
#define BM_45_01 0x00003ffffffffffe
#define BM_01_45 BM_45_01
#define BM_46_01 0x00007ffffffffffe
#define BM_01_46 BM_46_01
#define BM_47_01 0x0000fffffffffffe
#define BM_01_47 BM_47_01
#define BM_48_01 0x0001fffffffffffe
#define BM_01_48 BM_48_01
#define BM_49_01 0x0003fffffffffffe
#define BM_01_49 BM_49_01
#define BM_50_01 0x0007fffffffffffe
#define BM_01_50 BM_50_01
#define BM_51_01 0x000ffffffffffffe
#define BM_01_51 BM_51_01
#define BM_52_01 0x001ffffffffffffe
#define BM_01_52 BM_52_01
#define BM_53_01 0x003ffffffffffffe
#define BM_01_53 BM_53_01
#define BM_54_01 0x007ffffffffffffe
#define BM_01_54 BM_54_01
#define BM_55_01 0x00fffffffffffffe
#define BM_01_55 BM_55_01
#define BM_56_01 0x01fffffffffffffe
#define BM_01_56 BM_56_01
#define BM_57_01 0x03fffffffffffffe
#define BM_01_57 BM_57_01
#define BM_58_01 0x07fffffffffffffe
#define BM_01_58 BM_58_01
#define BM_59_01 0x0ffffffffffffffe
#define BM_01_59 BM_59_01
#define BM_60_01 0x1ffffffffffffffe
#define BM_01_60 BM_60_01
#define BM_61_01 0x3ffffffffffffffe
#define BM_01_61 BM_61_01
#define BM_62_01 0x7ffffffffffffffe
#define BM_01_62 BM_62_01
#define BM_63_01 0xfffffffffffffffe
#define BM_01_63 BM_63_01
#define BM_02_02 0x0000000000000004
#define BM_03_02 0x000000000000000c
#define BM_02_03 BM_03_02
#define BM_04_02 0x000000000000001c
#define BM_02_04 BM_04_02
#define BM_05_02 0x000000000000003c
#define BM_02_05 BM_05_02
#define BM_06_02 0x000000000000007c
#define BM_02_06 BM_06_02
#define BM_07_02 0x00000000000000fc
#define BM_02_07 BM_07_02
#define BM_08_02 0x00000000000001fc
#define BM_02_08 BM_08_02
#define BM_09_02 0x00000000000003fc
#define BM_02_09 BM_09_02
#define BM_10_02 0x00000000000007fc
#define BM_02_10 BM_10_02
#define BM_11_02 0x0000000000000ffc
#define BM_02_11 BM_11_02
#define BM_12_02 0x0000000000001ffc
#define BM_02_12 BM_12_02
#define BM_13_02 0x0000000000003ffc
#define BM_02_13 BM_13_02
#define BM_14_02 0x0000000000007ffc
#define BM_02_14 BM_14_02
#define BM_15_02 0x000000000000fffc
#define BM_02_15 BM_15_02
#define BM_16_02 0x000000000001fffc
#define BM_02_16 BM_16_02
#define BM_17_02 0x000000000003fffc
#define BM_02_17 BM_17_02
#define BM_18_02 0x000000000007fffc
#define BM_02_18 BM_18_02
#define BM_19_02 0x00000000000ffffc
#define BM_02_19 BM_19_02
#define BM_20_02 0x00000000001ffffc
#define BM_02_20 BM_20_02
#define BM_21_02 0x00000000003ffffc
#define BM_02_21 BM_21_02
#define BM_22_02 0x00000000007ffffc
#define BM_02_22 BM_22_02
#define BM_23_02 0x0000000000fffffc
#define BM_02_23 BM_23_02
#define BM_24_02 0x0000000001fffffc
#define BM_02_24 BM_24_02
#define BM_25_02 0x0000000003fffffc
#define BM_02_25 BM_25_02
#define BM_26_02 0x0000000007fffffc
#define BM_02_26 BM_26_02
#define BM_27_02 0x000000000ffffffc
#define BM_02_27 BM_27_02
#define BM_28_02 0x000000001ffffffc
#define BM_02_28 BM_28_02
#define BM_29_02 0x000000003ffffffc
#define BM_02_29 BM_29_02
#define BM_30_02 0x000000007ffffffc
#define BM_02_30 BM_30_02
#define BM_31_02 0x00000000fffffffc
#define BM_02_31 BM_31_02
#define BM_32_02 0x00000001fffffffc
#define BM_02_32 BM_32_02
#define BM_33_02 0x00000003fffffffc
#define BM_02_33 BM_33_02
#define BM_34_02 0x00000007fffffffc
#define BM_02_34 BM_34_02
#define BM_35_02 0x0000000ffffffffc
#define BM_02_35 BM_35_02
#define BM_36_02 0x0000001ffffffffc
#define BM_02_36 BM_36_02
#define BM_37_02 0x0000003ffffffffc
#define BM_02_37 BM_37_02
#define BM_38_02 0x0000007ffffffffc
#define BM_02_38 BM_38_02
#define BM_39_02 0x000000fffffffffc
#define BM_02_39 BM_39_02
#define BM_40_02 0x000001fffffffffc
#define BM_02_40 BM_40_02
#define BM_41_02 0x000003fffffffffc
#define BM_02_41 BM_41_02
#define BM_42_02 0x000007fffffffffc
#define BM_02_42 BM_42_02
#define BM_43_02 0x00000ffffffffffc
#define BM_02_43 BM_43_02
#define BM_44_02 0x00001ffffffffffc
#define BM_02_44 BM_44_02
#define BM_45_02 0x00003ffffffffffc
#define BM_02_45 BM_45_02
#define BM_46_02 0x00007ffffffffffc
#define BM_02_46 BM_46_02
#define BM_47_02 0x0000fffffffffffc
#define BM_02_47 BM_47_02
#define BM_48_02 0x0001fffffffffffc
#define BM_02_48 BM_48_02
#define BM_49_02 0x0003fffffffffffc
#define BM_02_49 BM_49_02
#define BM_50_02 0x0007fffffffffffc
#define BM_02_50 BM_50_02
#define BM_51_02 0x000ffffffffffffc
#define BM_02_51 BM_51_02
#define BM_52_02 0x001ffffffffffffc
#define BM_02_52 BM_52_02
#define BM_53_02 0x003ffffffffffffc
#define BM_02_53 BM_53_02
#define BM_54_02 0x007ffffffffffffc
#define BM_02_54 BM_54_02
#define BM_55_02 0x00fffffffffffffc
#define BM_02_55 BM_55_02
#define BM_56_02 0x01fffffffffffffc
#define BM_02_56 BM_56_02
#define BM_57_02 0x03fffffffffffffc
#define BM_02_57 BM_57_02
#define BM_58_02 0x07fffffffffffffc
#define BM_02_58 BM_58_02
#define BM_59_02 0x0ffffffffffffffc
#define BM_02_59 BM_59_02
#define BM_60_02 0x1ffffffffffffffc
#define BM_02_60 BM_60_02
#define BM_61_02 0x3ffffffffffffffc
#define BM_02_61 BM_61_02
#define BM_62_02 0x7ffffffffffffffc
#define BM_02_62 BM_62_02
#define BM_63_02 0xfffffffffffffffc
#define BM_02_63 BM_63_02
#define BM_03_03 0x0000000000000008
#define BM_04_03 0x0000000000000018
#define BM_03_04 BM_04_03
#define BM_05_03 0x0000000000000038
#define BM_03_05 BM_05_03
#define BM_06_03 0x0000000000000078
#define BM_03_06 BM_06_03
#define BM_07_03 0x00000000000000f8
#define BM_03_07 BM_07_03
#define BM_08_03 0x00000000000001f8
#define BM_03_08 BM_08_03
#define BM_09_03 0x00000000000003f8
#define BM_03_09 BM_09_03
#define BM_10_03 0x00000000000007f8
#define BM_03_10 BM_10_03
#define BM_11_03 0x0000000000000ff8
#define BM_03_11 BM_11_03
#define BM_12_03 0x0000000000001ff8
#define BM_03_12 BM_12_03
#define BM_13_03 0x0000000000003ff8
#define BM_03_13 BM_13_03
#define BM_14_03 0x0000000000007ff8
#define BM_03_14 BM_14_03
#define BM_15_03 0x000000000000fff8
#define BM_03_15 BM_15_03
#define BM_16_03 0x000000000001fff8
#define BM_03_16 BM_16_03
#define BM_17_03 0x000000000003fff8
#define BM_03_17 BM_17_03
#define BM_18_03 0x000000000007fff8
#define BM_03_18 BM_18_03
#define BM_19_03 0x00000000000ffff8
#define BM_03_19 BM_19_03
#define BM_20_03 0x00000000001ffff8
#define BM_03_20 BM_20_03
#define BM_21_03 0x00000000003ffff8
#define BM_03_21 BM_21_03
#define BM_22_03 0x00000000007ffff8
#define BM_03_22 BM_22_03
#define BM_23_03 0x0000000000fffff8
#define BM_03_23 BM_23_03
#define BM_24_03 0x0000000001fffff8
#define BM_03_24 BM_24_03
#define BM_25_03 0x0000000003fffff8
#define BM_03_25 BM_25_03
#define BM_26_03 0x0000000007fffff8
#define BM_03_26 BM_26_03
#define BM_27_03 0x000000000ffffff8
#define BM_03_27 BM_27_03
#define BM_28_03 0x000000001ffffff8
#define BM_03_28 BM_28_03
#define BM_29_03 0x000000003ffffff8
#define BM_03_29 BM_29_03
#define BM_30_03 0x000000007ffffff8
#define BM_03_30 BM_30_03
#define BM_31_03 0x00000000fffffff8
#define BM_03_31 BM_31_03
#define BM_32_03 0x00000001fffffff8
#define BM_03_32 BM_32_03
#define BM_33_03 0x00000003fffffff8
#define BM_03_33 BM_33_03
#define BM_34_03 0x00000007fffffff8
#define BM_03_34 BM_34_03
#define BM_35_03 0x0000000ffffffff8
#define BM_03_35 BM_35_03
#define BM_36_03 0x0000001ffffffff8
#define BM_03_36 BM_36_03
#define BM_37_03 0x0000003ffffffff8
#define BM_03_37 BM_37_03
#define BM_38_03 0x0000007ffffffff8
#define BM_03_38 BM_38_03
#define BM_39_03 0x000000fffffffff8
#define BM_03_39 BM_39_03
#define BM_40_03 0x000001fffffffff8
#define BM_03_40 BM_40_03
#define BM_41_03 0x000003fffffffff8
#define BM_03_41 BM_41_03
#define BM_42_03 0x000007fffffffff8
#define BM_03_42 BM_42_03
#define BM_43_03 0x00000ffffffffff8
#define BM_03_43 BM_43_03
#define BM_44_03 0x00001ffffffffff8
#define BM_03_44 BM_44_03
#define BM_45_03 0x00003ffffffffff8
#define BM_03_45 BM_45_03
#define BM_46_03 0x00007ffffffffff8
#define BM_03_46 BM_46_03
#define BM_47_03 0x0000fffffffffff8
#define BM_03_47 BM_47_03
#define BM_48_03 0x0001fffffffffff8
#define BM_03_48 BM_48_03
#define BM_49_03 0x0003fffffffffff8
#define BM_03_49 BM_49_03
#define BM_50_03 0x0007fffffffffff8
#define BM_03_50 BM_50_03
#define BM_51_03 0x000ffffffffffff8
#define BM_03_51 BM_51_03
#define BM_52_03 0x001ffffffffffff8
#define BM_03_52 BM_52_03
#define BM_53_03 0x003ffffffffffff8
#define BM_03_53 BM_53_03
#define BM_54_03 0x007ffffffffffff8
#define BM_03_54 BM_54_03
#define BM_55_03 0x00fffffffffffff8
#define BM_03_55 BM_55_03
#define BM_56_03 0x01fffffffffffff8
#define BM_03_56 BM_56_03
#define BM_57_03 0x03fffffffffffff8
#define BM_03_57 BM_57_03
#define BM_58_03 0x07fffffffffffff8
#define BM_03_58 BM_58_03
#define BM_59_03 0x0ffffffffffffff8
#define BM_03_59 BM_59_03
#define BM_60_03 0x1ffffffffffffff8
#define BM_03_60 BM_60_03
#define BM_61_03 0x3ffffffffffffff8
#define BM_03_61 BM_61_03
#define BM_62_03 0x7ffffffffffffff8
#define BM_03_62 BM_62_03
#define BM_63_03 0xfffffffffffffff8
#define BM_03_63 BM_63_03
#define BM_04_04 0x0000000000000010
#define BM_05_04 0x0000000000000030
#define BM_04_05 BM_05_04
#define BM_06_04 0x0000000000000070
#define BM_04_06 BM_06_04
#define BM_07_04 0x00000000000000f0
#define BM_04_07 BM_07_04
#define BM_08_04 0x00000000000001f0
#define BM_04_08 BM_08_04
#define BM_09_04 0x00000000000003f0
#define BM_04_09 BM_09_04
#define BM_10_04 0x00000000000007f0
#define BM_04_10 BM_10_04
#define BM_11_04 0x0000000000000ff0
#define BM_04_11 BM_11_04
#define BM_12_04 0x0000000000001ff0
#define BM_04_12 BM_12_04
#define BM_13_04 0x0000000000003ff0
#define BM_04_13 BM_13_04
#define BM_14_04 0x0000000000007ff0
#define BM_04_14 BM_14_04
#define BM_15_04 0x000000000000fff0
#define BM_04_15 BM_15_04
#define BM_16_04 0x000000000001fff0
#define BM_04_16 BM_16_04
#define BM_17_04 0x000000000003fff0
#define BM_04_17 BM_17_04
#define BM_18_04 0x000000000007fff0
#define BM_04_18 BM_18_04
#define BM_19_04 0x00000000000ffff0
#define BM_04_19 BM_19_04
#define BM_20_04 0x00000000001ffff0
#define BM_04_20 BM_20_04
#define BM_21_04 0x00000000003ffff0
#define BM_04_21 BM_21_04
#define BM_22_04 0x00000000007ffff0
#define BM_04_22 BM_22_04
#define BM_23_04 0x0000000000fffff0
#define BM_04_23 BM_23_04
#define BM_24_04 0x0000000001fffff0
#define BM_04_24 BM_24_04
#define BM_25_04 0x0000000003fffff0
#define BM_04_25 BM_25_04
#define BM_26_04 0x0000000007fffff0
#define BM_04_26 BM_26_04
#define BM_27_04 0x000000000ffffff0
#define BM_04_27 BM_27_04
#define BM_28_04 0x000000001ffffff0
#define BM_04_28 BM_28_04
#define BM_29_04 0x000000003ffffff0
#define BM_04_29 BM_29_04
#define BM_30_04 0x000000007ffffff0
#define BM_04_30 BM_30_04
#define BM_31_04 0x00000000fffffff0
#define BM_04_31 BM_31_04
#define BM_32_04 0x00000001fffffff0
#define BM_04_32 BM_32_04
#define BM_33_04 0x00000003fffffff0
#define BM_04_33 BM_33_04
#define BM_34_04 0x00000007fffffff0
#define BM_04_34 BM_34_04
#define BM_35_04 0x0000000ffffffff0
#define BM_04_35 BM_35_04
#define BM_36_04 0x0000001ffffffff0
#define BM_04_36 BM_36_04
#define BM_37_04 0x0000003ffffffff0
#define BM_04_37 BM_37_04
#define BM_38_04 0x0000007ffffffff0
#define BM_04_38 BM_38_04
#define BM_39_04 0x000000fffffffff0
#define BM_04_39 BM_39_04
#define BM_40_04 0x000001fffffffff0
#define BM_04_40 BM_40_04
#define BM_41_04 0x000003fffffffff0
#define BM_04_41 BM_41_04
#define BM_42_04 0x000007fffffffff0
#define BM_04_42 BM_42_04
#define BM_43_04 0x00000ffffffffff0
#define BM_04_43 BM_43_04
#define BM_44_04 0x00001ffffffffff0
#define BM_04_44 BM_44_04
#define BM_45_04 0x00003ffffffffff0
#define BM_04_45 BM_45_04
#define BM_46_04 0x00007ffffffffff0
#define BM_04_46 BM_46_04
#define BM_47_04 0x0000fffffffffff0
#define BM_04_47 BM_47_04
#define BM_48_04 0x0001fffffffffff0
#define BM_04_48 BM_48_04
#define BM_49_04 0x0003fffffffffff0
#define BM_04_49 BM_49_04
#define BM_50_04 0x0007fffffffffff0
#define BM_04_50 BM_50_04
#define BM_51_04 0x000ffffffffffff0
#define BM_04_51 BM_51_04
#define BM_52_04 0x001ffffffffffff0
#define BM_04_52 BM_52_04
#define BM_53_04 0x003ffffffffffff0
#define BM_04_53 BM_53_04
#define BM_54_04 0x007ffffffffffff0
#define BM_04_54 BM_54_04
#define BM_55_04 0x00fffffffffffff0
#define BM_04_55 BM_55_04
#define BM_56_04 0x01fffffffffffff0
#define BM_04_56 BM_56_04
#define BM_57_04 0x03fffffffffffff0
#define BM_04_57 BM_57_04
#define BM_58_04 0x07fffffffffffff0
#define BM_04_58 BM_58_04
#define BM_59_04 0x0ffffffffffffff0
#define BM_04_59 BM_59_04
#define BM_60_04 0x1ffffffffffffff0
#define BM_04_60 BM_60_04
#define BM_61_04 0x3ffffffffffffff0
#define BM_04_61 BM_61_04
#define BM_62_04 0x7ffffffffffffff0
#define BM_04_62 BM_62_04
#define BM_63_04 0xfffffffffffffff0
#define BM_04_63 BM_63_04
#define BM_05_05 0x0000000000000020
#define BM_06_05 0x0000000000000060
#define BM_05_06 BM_06_05
#define BM_07_05 0x00000000000000e0
#define BM_05_07 BM_07_05
#define BM_08_05 0x00000000000001e0
#define BM_05_08 BM_08_05
#define BM_09_05 0x00000000000003e0
#define BM_05_09 BM_09_05
#define BM_10_05 0x00000000000007e0
#define BM_05_10 BM_10_05
#define BM_11_05 0x0000000000000fe0
#define BM_05_11 BM_11_05
#define BM_12_05 0x0000000000001fe0
#define BM_05_12 BM_12_05
#define BM_13_05 0x0000000000003fe0
#define BM_05_13 BM_13_05
#define BM_14_05 0x0000000000007fe0
#define BM_05_14 BM_14_05
#define BM_15_05 0x000000000000ffe0
#define BM_05_15 BM_15_05
#define BM_16_05 0x000000000001ffe0
#define BM_05_16 BM_16_05
#define BM_17_05 0x000000000003ffe0
#define BM_05_17 BM_17_05
#define BM_18_05 0x000000000007ffe0
#define BM_05_18 BM_18_05
#define BM_19_05 0x00000000000fffe0
#define BM_05_19 BM_19_05
#define BM_20_05 0x00000000001fffe0
#define BM_05_20 BM_20_05
#define BM_21_05 0x00000000003fffe0
#define BM_05_21 BM_21_05
#define BM_22_05 0x00000000007fffe0
#define BM_05_22 BM_22_05
#define BM_23_05 0x0000000000ffffe0
#define BM_05_23 BM_23_05
#define BM_24_05 0x0000000001ffffe0
#define BM_05_24 BM_24_05
#define BM_25_05 0x0000000003ffffe0
#define BM_05_25 BM_25_05
#define BM_26_05 0x0000000007ffffe0
#define BM_05_26 BM_26_05
#define BM_27_05 0x000000000fffffe0
#define BM_05_27 BM_27_05
#define BM_28_05 0x000000001fffffe0
#define BM_05_28 BM_28_05
#define BM_29_05 0x000000003fffffe0
#define BM_05_29 BM_29_05
#define BM_30_05 0x000000007fffffe0
#define BM_05_30 BM_30_05
#define BM_31_05 0x00000000ffffffe0
#define BM_05_31 BM_31_05
#define BM_32_05 0x00000001ffffffe0
#define BM_05_32 BM_32_05
#define BM_33_05 0x00000003ffffffe0
#define BM_05_33 BM_33_05
#define BM_34_05 0x00000007ffffffe0
#define BM_05_34 BM_34_05
#define BM_35_05 0x0000000fffffffe0
#define BM_05_35 BM_35_05
#define BM_36_05 0x0000001fffffffe0
#define BM_05_36 BM_36_05
#define BM_37_05 0x0000003fffffffe0
#define BM_05_37 BM_37_05
#define BM_38_05 0x0000007fffffffe0
#define BM_05_38 BM_38_05
#define BM_39_05 0x000000ffffffffe0
#define BM_05_39 BM_39_05
#define BM_40_05 0x000001ffffffffe0
#define BM_05_40 BM_40_05
#define BM_41_05 0x000003ffffffffe0
#define BM_05_41 BM_41_05
#define BM_42_05 0x000007ffffffffe0
#define BM_05_42 BM_42_05
#define BM_43_05 0x00000fffffffffe0
#define BM_05_43 BM_43_05
#define BM_44_05 0x00001fffffffffe0
#define BM_05_44 BM_44_05
#define BM_45_05 0x00003fffffffffe0
#define BM_05_45 BM_45_05
#define BM_46_05 0x00007fffffffffe0
#define BM_05_46 BM_46_05
#define BM_47_05 0x0000ffffffffffe0
#define BM_05_47 BM_47_05
#define BM_48_05 0x0001ffffffffffe0
#define BM_05_48 BM_48_05
#define BM_49_05 0x0003ffffffffffe0
#define BM_05_49 BM_49_05
#define BM_50_05 0x0007ffffffffffe0
#define BM_05_50 BM_50_05
#define BM_51_05 0x000fffffffffffe0
#define BM_05_51 BM_51_05
#define BM_52_05 0x001fffffffffffe0
#define BM_05_52 BM_52_05
#define BM_53_05 0x003fffffffffffe0
#define BM_05_53 BM_53_05
#define BM_54_05 0x007fffffffffffe0
#define BM_05_54 BM_54_05
#define BM_55_05 0x00ffffffffffffe0
#define BM_05_55 BM_55_05
#define BM_56_05 0x01ffffffffffffe0
#define BM_05_56 BM_56_05
#define BM_57_05 0x03ffffffffffffe0
#define BM_05_57 BM_57_05
#define BM_58_05 0x07ffffffffffffe0
#define BM_05_58 BM_58_05
#define BM_59_05 0x0fffffffffffffe0
#define BM_05_59 BM_59_05
#define BM_60_05 0x1fffffffffffffe0
#define BM_05_60 BM_60_05
#define BM_61_05 0x3fffffffffffffe0
#define BM_05_61 BM_61_05
#define BM_62_05 0x7fffffffffffffe0
#define BM_05_62 BM_62_05
#define BM_63_05 0xffffffffffffffe0
#define BM_05_63 BM_63_05
#define BM_06_06 0x0000000000000040
#define BM_07_06 0x00000000000000c0
#define BM_06_07 BM_07_06
#define BM_08_06 0x00000000000001c0
#define BM_06_08 BM_08_06
#define BM_09_06 0x00000000000003c0
#define BM_06_09 BM_09_06
#define BM_10_06 0x00000000000007c0
#define BM_06_10 BM_10_06
#define BM_11_06 0x0000000000000fc0
#define BM_06_11 BM_11_06
#define BM_12_06 0x0000000000001fc0
#define BM_06_12 BM_12_06
#define BM_13_06 0x0000000000003fc0
#define BM_06_13 BM_13_06
#define BM_14_06 0x0000000000007fc0
#define BM_06_14 BM_14_06
#define BM_15_06 0x000000000000ffc0
#define BM_06_15 BM_15_06
#define BM_16_06 0x000000000001ffc0
#define BM_06_16 BM_16_06
#define BM_17_06 0x000000000003ffc0
#define BM_06_17 BM_17_06
#define BM_18_06 0x000000000007ffc0
#define BM_06_18 BM_18_06
#define BM_19_06 0x00000000000fffc0
#define BM_06_19 BM_19_06
#define BM_20_06 0x00000000001fffc0
#define BM_06_20 BM_20_06
#define BM_21_06 0x00000000003fffc0
#define BM_06_21 BM_21_06
#define BM_22_06 0x00000000007fffc0
#define BM_06_22 BM_22_06
#define BM_23_06 0x0000000000ffffc0
#define BM_06_23 BM_23_06
#define BM_24_06 0x0000000001ffffc0
#define BM_06_24 BM_24_06
#define BM_25_06 0x0000000003ffffc0
#define BM_06_25 BM_25_06
#define BM_26_06 0x0000000007ffffc0
#define BM_06_26 BM_26_06
#define BM_27_06 0x000000000fffffc0
#define BM_06_27 BM_27_06
#define BM_28_06 0x000000001fffffc0
#define BM_06_28 BM_28_06
#define BM_29_06 0x000000003fffffc0
#define BM_06_29 BM_29_06
#define BM_30_06 0x000000007fffffc0
#define BM_06_30 BM_30_06
#define BM_31_06 0x00000000ffffffc0
#define BM_06_31 BM_31_06
#define BM_32_06 0x00000001ffffffc0
#define BM_06_32 BM_32_06
#define BM_33_06 0x00000003ffffffc0
#define BM_06_33 BM_33_06
#define BM_34_06 0x00000007ffffffc0
#define BM_06_34 BM_34_06
#define BM_35_06 0x0000000fffffffc0
#define BM_06_35 BM_35_06
#define BM_36_06 0x0000001fffffffc0
#define BM_06_36 BM_36_06
#define BM_37_06 0x0000003fffffffc0
#define BM_06_37 BM_37_06
#define BM_38_06 0x0000007fffffffc0
#define BM_06_38 BM_38_06
#define BM_39_06 0x000000ffffffffc0
#define BM_06_39 BM_39_06
#define BM_40_06 0x000001ffffffffc0
#define BM_06_40 BM_40_06
#define BM_41_06 0x000003ffffffffc0
#define BM_06_41 BM_41_06
#define BM_42_06 0x000007ffffffffc0
#define BM_06_42 BM_42_06
#define BM_43_06 0x00000fffffffffc0
#define BM_06_43 BM_43_06
#define BM_44_06 0x00001fffffffffc0
#define BM_06_44 BM_44_06
#define BM_45_06 0x00003fffffffffc0
#define BM_06_45 BM_45_06
#define BM_46_06 0x00007fffffffffc0
#define BM_06_46 BM_46_06
#define BM_47_06 0x0000ffffffffffc0
#define BM_06_47 BM_47_06
#define BM_48_06 0x0001ffffffffffc0
#define BM_06_48 BM_48_06
#define BM_49_06 0x0003ffffffffffc0
#define BM_06_49 BM_49_06
#define BM_50_06 0x0007ffffffffffc0
#define BM_06_50 BM_50_06
#define BM_51_06 0x000fffffffffffc0
#define BM_06_51 BM_51_06
#define BM_52_06 0x001fffffffffffc0
#define BM_06_52 BM_52_06
#define BM_53_06 0x003fffffffffffc0
#define BM_06_53 BM_53_06
#define BM_54_06 0x007fffffffffffc0
#define BM_06_54 BM_54_06
#define BM_55_06 0x00ffffffffffffc0
#define BM_06_55 BM_55_06
#define BM_56_06 0x01ffffffffffffc0
#define BM_06_56 BM_56_06
#define BM_57_06 0x03ffffffffffffc0
#define BM_06_57 BM_57_06
#define BM_58_06 0x07ffffffffffffc0
#define BM_06_58 BM_58_06
#define BM_59_06 0x0fffffffffffffc0
#define BM_06_59 BM_59_06
#define BM_60_06 0x1fffffffffffffc0
#define BM_06_60 BM_60_06
#define BM_61_06 0x3fffffffffffffc0
#define BM_06_61 BM_61_06
#define BM_62_06 0x7fffffffffffffc0
#define BM_06_62 BM_62_06
#define BM_63_06 0xffffffffffffffc0
#define BM_06_63 BM_63_06
#define BM_07_07 0x0000000000000080
#define BM_08_07 0x0000000000000180
#define BM_07_08 BM_08_07
#define BM_09_07 0x0000000000000380
#define BM_07_09 BM_09_07
#define BM_10_07 0x0000000000000780
#define BM_07_10 BM_10_07
#define BM_11_07 0x0000000000000f80
#define BM_07_11 BM_11_07
#define BM_12_07 0x0000000000001f80
#define BM_07_12 BM_12_07
#define BM_13_07 0x0000000000003f80
#define BM_07_13 BM_13_07
#define BM_14_07 0x0000000000007f80
#define BM_07_14 BM_14_07
#define BM_15_07 0x000000000000ff80
#define BM_07_15 BM_15_07
#define BM_16_07 0x000000000001ff80
#define BM_07_16 BM_16_07
#define BM_17_07 0x000000000003ff80
#define BM_07_17 BM_17_07
#define BM_18_07 0x000000000007ff80
#define BM_07_18 BM_18_07
#define BM_19_07 0x00000000000fff80
#define BM_07_19 BM_19_07
#define BM_20_07 0x00000000001fff80
#define BM_07_20 BM_20_07
#define BM_21_07 0x00000000003fff80
#define BM_07_21 BM_21_07
#define BM_22_07 0x00000000007fff80
#define BM_07_22 BM_22_07
#define BM_23_07 0x0000000000ffff80
#define BM_07_23 BM_23_07
#define BM_24_07 0x0000000001ffff80
#define BM_07_24 BM_24_07
#define BM_25_07 0x0000000003ffff80
#define BM_07_25 BM_25_07
#define BM_26_07 0x0000000007ffff80
#define BM_07_26 BM_26_07
#define BM_27_07 0x000000000fffff80
#define BM_07_27 BM_27_07
#define BM_28_07 0x000000001fffff80
#define BM_07_28 BM_28_07
#define BM_29_07 0x000000003fffff80
#define BM_07_29 BM_29_07
#define BM_30_07 0x000000007fffff80
#define BM_07_30 BM_30_07
#define BM_31_07 0x00000000ffffff80
#define BM_07_31 BM_31_07
#define BM_32_07 0x00000001ffffff80
#define BM_07_32 BM_32_07
#define BM_33_07 0x00000003ffffff80
#define BM_07_33 BM_33_07
#define BM_34_07 0x00000007ffffff80
#define BM_07_34 BM_34_07
#define BM_35_07 0x0000000fffffff80
#define BM_07_35 BM_35_07
#define BM_36_07 0x0000001fffffff80
#define BM_07_36 BM_36_07
#define BM_37_07 0x0000003fffffff80
#define BM_07_37 BM_37_07
#define BM_38_07 0x0000007fffffff80
#define BM_07_38 BM_38_07
#define BM_39_07 0x000000ffffffff80
#define BM_07_39 BM_39_07
#define BM_40_07 0x000001ffffffff80
#define BM_07_40 BM_40_07
#define BM_41_07 0x000003ffffffff80
#define BM_07_41 BM_41_07
#define BM_42_07 0x000007ffffffff80
#define BM_07_42 BM_42_07
#define BM_43_07 0x00000fffffffff80
#define BM_07_43 BM_43_07
#define BM_44_07 0x00001fffffffff80
#define BM_07_44 BM_44_07
#define BM_45_07 0x00003fffffffff80
#define BM_07_45 BM_45_07
#define BM_46_07 0x00007fffffffff80
#define BM_07_46 BM_46_07
#define BM_47_07 0x0000ffffffffff80
#define BM_07_47 BM_47_07
#define BM_48_07 0x0001ffffffffff80
#define BM_07_48 BM_48_07
#define BM_49_07 0x0003ffffffffff80
#define BM_07_49 BM_49_07
#define BM_50_07 0x0007ffffffffff80
#define BM_07_50 BM_50_07
#define BM_51_07 0x000fffffffffff80
#define BM_07_51 BM_51_07
#define BM_52_07 0x001fffffffffff80
#define BM_07_52 BM_52_07
#define BM_53_07 0x003fffffffffff80
#define BM_07_53 BM_53_07
#define BM_54_07 0x007fffffffffff80
#define BM_07_54 BM_54_07
#define BM_55_07 0x00ffffffffffff80
#define BM_07_55 BM_55_07
#define BM_56_07 0x01ffffffffffff80
#define BM_07_56 BM_56_07
#define BM_57_07 0x03ffffffffffff80
#define BM_07_57 BM_57_07
#define BM_58_07 0x07ffffffffffff80
#define BM_07_58 BM_58_07
#define BM_59_07 0x0fffffffffffff80
#define BM_07_59 BM_59_07
#define BM_60_07 0x1fffffffffffff80
#define BM_07_60 BM_60_07
#define BM_61_07 0x3fffffffffffff80
#define BM_07_61 BM_61_07
#define BM_62_07 0x7fffffffffffff80
#define BM_07_62 BM_62_07
#define BM_63_07 0xffffffffffffff80
#define BM_07_63 BM_63_07
#define BM_08_08 0x0000000000000100
#define BM_09_08 0x0000000000000300
#define BM_08_09 BM_09_08
#define BM_10_08 0x0000000000000700
#define BM_08_10 BM_10_08
#define BM_11_08 0x0000000000000f00
#define BM_08_11 BM_11_08
#define BM_12_08 0x0000000000001f00
#define BM_08_12 BM_12_08
#define BM_13_08 0x0000000000003f00
#define BM_08_13 BM_13_08
#define BM_14_08 0x0000000000007f00
#define BM_08_14 BM_14_08
#define BM_15_08 0x000000000000ff00
#define BM_08_15 BM_15_08
#define BM_16_08 0x000000000001ff00
#define BM_08_16 BM_16_08
#define BM_17_08 0x000000000003ff00
#define BM_08_17 BM_17_08
#define BM_18_08 0x000000000007ff00
#define BM_08_18 BM_18_08
#define BM_19_08 0x00000000000fff00
#define BM_08_19 BM_19_08
#define BM_20_08 0x00000000001fff00
#define BM_08_20 BM_20_08
#define BM_21_08 0x00000000003fff00
#define BM_08_21 BM_21_08
#define BM_22_08 0x00000000007fff00
#define BM_08_22 BM_22_08
#define BM_23_08 0x0000000000ffff00
#define BM_08_23 BM_23_08
#define BM_24_08 0x0000000001ffff00
#define BM_08_24 BM_24_08
#define BM_25_08 0x0000000003ffff00
#define BM_08_25 BM_25_08
#define BM_26_08 0x0000000007ffff00
#define BM_08_26 BM_26_08
#define BM_27_08 0x000000000fffff00
#define BM_08_27 BM_27_08
#define BM_28_08 0x000000001fffff00
#define BM_08_28 BM_28_08
#define BM_29_08 0x000000003fffff00
#define BM_08_29 BM_29_08
#define BM_30_08 0x000000007fffff00
#define BM_08_30 BM_30_08
#define BM_31_08 0x00000000ffffff00
#define BM_08_31 BM_31_08
#define BM_32_08 0x00000001ffffff00
#define BM_08_32 BM_32_08
#define BM_33_08 0x00000003ffffff00
#define BM_08_33 BM_33_08
#define BM_34_08 0x00000007ffffff00
#define BM_08_34 BM_34_08
#define BM_35_08 0x0000000fffffff00
#define BM_08_35 BM_35_08
#define BM_36_08 0x0000001fffffff00
#define BM_08_36 BM_36_08
#define BM_37_08 0x0000003fffffff00
#define BM_08_37 BM_37_08
#define BM_38_08 0x0000007fffffff00
#define BM_08_38 BM_38_08
#define BM_39_08 0x000000ffffffff00
#define BM_08_39 BM_39_08
#define BM_40_08 0x000001ffffffff00
#define BM_08_40 BM_40_08
#define BM_41_08 0x000003ffffffff00
#define BM_08_41 BM_41_08
#define BM_42_08 0x000007ffffffff00
#define BM_08_42 BM_42_08
#define BM_43_08 0x00000fffffffff00
#define BM_08_43 BM_43_08
#define BM_44_08 0x00001fffffffff00
#define BM_08_44 BM_44_08
#define BM_45_08 0x00003fffffffff00
#define BM_08_45 BM_45_08
#define BM_46_08 0x00007fffffffff00
#define BM_08_46 BM_46_08
#define BM_47_08 0x0000ffffffffff00
#define BM_08_47 BM_47_08
#define BM_48_08 0x0001ffffffffff00
#define BM_08_48 BM_48_08
#define BM_49_08 0x0003ffffffffff00
#define BM_08_49 BM_49_08
#define BM_50_08 0x0007ffffffffff00
#define BM_08_50 BM_50_08
#define BM_51_08 0x000fffffffffff00
#define BM_08_51 BM_51_08
#define BM_52_08 0x001fffffffffff00
#define BM_08_52 BM_52_08
#define BM_53_08 0x003fffffffffff00
#define BM_08_53 BM_53_08
#define BM_54_08 0x007fffffffffff00
#define BM_08_54 BM_54_08
#define BM_55_08 0x00ffffffffffff00
#define BM_08_55 BM_55_08
#define BM_56_08 0x01ffffffffffff00
#define BM_08_56 BM_56_08
#define BM_57_08 0x03ffffffffffff00
#define BM_08_57 BM_57_08
#define BM_58_08 0x07ffffffffffff00
#define BM_08_58 BM_58_08
#define BM_59_08 0x0fffffffffffff00
#define BM_08_59 BM_59_08
#define BM_60_08 0x1fffffffffffff00
#define BM_08_60 BM_60_08
#define BM_61_08 0x3fffffffffffff00
#define BM_08_61 BM_61_08
#define BM_62_08 0x7fffffffffffff00
#define BM_08_62 BM_62_08
#define BM_63_08 0xffffffffffffff00
#define BM_08_63 BM_63_08
#define BM_09_09 0x0000000000000200
#define BM_10_09 0x0000000000000600
#define BM_09_10 BM_10_09
#define BM_11_09 0x0000000000000e00
#define BM_09_11 BM_11_09
#define BM_12_09 0x0000000000001e00
#define BM_09_12 BM_12_09
#define BM_13_09 0x0000000000003e00
#define BM_09_13 BM_13_09
#define BM_14_09 0x0000000000007e00
#define BM_09_14 BM_14_09
#define BM_15_09 0x000000000000fe00
#define BM_09_15 BM_15_09
#define BM_16_09 0x000000000001fe00
#define BM_09_16 BM_16_09
#define BM_17_09 0x000000000003fe00
#define BM_09_17 BM_17_09
#define BM_18_09 0x000000000007fe00
#define BM_09_18 BM_18_09
#define BM_19_09 0x00000000000ffe00
#define BM_09_19 BM_19_09
#define BM_20_09 0x00000000001ffe00
#define BM_09_20 BM_20_09
#define BM_21_09 0x00000000003ffe00
#define BM_09_21 BM_21_09
#define BM_22_09 0x00000000007ffe00
#define BM_09_22 BM_22_09
#define BM_23_09 0x0000000000fffe00
#define BM_09_23 BM_23_09
#define BM_24_09 0x0000000001fffe00
#define BM_09_24 BM_24_09
#define BM_25_09 0x0000000003fffe00
#define BM_09_25 BM_25_09
#define BM_26_09 0x0000000007fffe00
#define BM_09_26 BM_26_09
#define BM_27_09 0x000000000ffffe00
#define BM_09_27 BM_27_09
#define BM_28_09 0x000000001ffffe00
#define BM_09_28 BM_28_09
#define BM_29_09 0x000000003ffffe00
#define BM_09_29 BM_29_09
#define BM_30_09 0x000000007ffffe00
#define BM_09_30 BM_30_09
#define BM_31_09 0x00000000fffffe00
#define BM_09_31 BM_31_09
#define BM_32_09 0x00000001fffffe00
#define BM_09_32 BM_32_09
#define BM_33_09 0x00000003fffffe00
#define BM_09_33 BM_33_09
#define BM_34_09 0x00000007fffffe00
#define BM_09_34 BM_34_09
#define BM_35_09 0x0000000ffffffe00
#define BM_09_35 BM_35_09
#define BM_36_09 0x0000001ffffffe00
#define BM_09_36 BM_36_09
#define BM_37_09 0x0000003ffffffe00
#define BM_09_37 BM_37_09
#define BM_38_09 0x0000007ffffffe00
#define BM_09_38 BM_38_09
#define BM_39_09 0x000000fffffffe00
#define BM_09_39 BM_39_09
#define BM_40_09 0x000001fffffffe00
#define BM_09_40 BM_40_09
#define BM_41_09 0x000003fffffffe00
#define BM_09_41 BM_41_09
#define BM_42_09 0x000007fffffffe00
#define BM_09_42 BM_42_09
#define BM_43_09 0x00000ffffffffe00
#define BM_09_43 BM_43_09
#define BM_44_09 0x00001ffffffffe00
#define BM_09_44 BM_44_09
#define BM_45_09 0x00003ffffffffe00
#define BM_09_45 BM_45_09
#define BM_46_09 0x00007ffffffffe00
#define BM_09_46 BM_46_09
#define BM_47_09 0x0000fffffffffe00
#define BM_09_47 BM_47_09
#define BM_48_09 0x0001fffffffffe00
#define BM_09_48 BM_48_09
#define BM_49_09 0x0003fffffffffe00
#define BM_09_49 BM_49_09
#define BM_50_09 0x0007fffffffffe00
#define BM_09_50 BM_50_09
#define BM_51_09 0x000ffffffffffe00
#define BM_09_51 BM_51_09
#define BM_52_09 0x001ffffffffffe00
#define BM_09_52 BM_52_09
#define BM_53_09 0x003ffffffffffe00
#define BM_09_53 BM_53_09
#define BM_54_09 0x007ffffffffffe00
#define BM_09_54 BM_54_09
#define BM_55_09 0x00fffffffffffe00
#define BM_09_55 BM_55_09
#define BM_56_09 0x01fffffffffffe00
#define BM_09_56 BM_56_09
#define BM_57_09 0x03fffffffffffe00
#define BM_09_57 BM_57_09
#define BM_58_09 0x07fffffffffffe00
#define BM_09_58 BM_58_09
#define BM_59_09 0x0ffffffffffffe00
#define BM_09_59 BM_59_09
#define BM_60_09 0x1ffffffffffffe00
#define BM_09_60 BM_60_09
#define BM_61_09 0x3ffffffffffffe00
#define BM_09_61 BM_61_09
#define BM_62_09 0x7ffffffffffffe00
#define BM_09_62 BM_62_09
#define BM_63_09 0xfffffffffffffe00
#define BM_09_63 BM_63_09
#define BM_10_10 0x0000000000000400
#define BM_11_10 0x0000000000000c00
#define BM_10_11 BM_11_10
#define BM_12_10 0x0000000000001c00
#define BM_10_12 BM_12_10
#define BM_13_10 0x0000000000003c00
#define BM_10_13 BM_13_10
#define BM_14_10 0x0000000000007c00
#define BM_10_14 BM_14_10
#define BM_15_10 0x000000000000fc00
#define BM_10_15 BM_15_10
#define BM_16_10 0x000000000001fc00
#define BM_10_16 BM_16_10
#define BM_17_10 0x000000000003fc00
#define BM_10_17 BM_17_10
#define BM_18_10 0x000000000007fc00
#define BM_10_18 BM_18_10
#define BM_19_10 0x00000000000ffc00
#define BM_10_19 BM_19_10
#define BM_20_10 0x00000000001ffc00
#define BM_10_20 BM_20_10
#define BM_21_10 0x00000000003ffc00
#define BM_10_21 BM_21_10
#define BM_22_10 0x00000000007ffc00
#define BM_10_22 BM_22_10
#define BM_23_10 0x0000000000fffc00
#define BM_10_23 BM_23_10
#define BM_24_10 0x0000000001fffc00
#define BM_10_24 BM_24_10
#define BM_25_10 0x0000000003fffc00
#define BM_10_25 BM_25_10
#define BM_26_10 0x0000000007fffc00
#define BM_10_26 BM_26_10
#define BM_27_10 0x000000000ffffc00
#define BM_10_27 BM_27_10
#define BM_28_10 0x000000001ffffc00
#define BM_10_28 BM_28_10
#define BM_29_10 0x000000003ffffc00
#define BM_10_29 BM_29_10
#define BM_30_10 0x000000007ffffc00
#define BM_10_30 BM_30_10
#define BM_31_10 0x00000000fffffc00
#define BM_10_31 BM_31_10
#define BM_32_10 0x00000001fffffc00
#define BM_10_32 BM_32_10
#define BM_33_10 0x00000003fffffc00
#define BM_10_33 BM_33_10
#define BM_34_10 0x00000007fffffc00
#define BM_10_34 BM_34_10
#define BM_35_10 0x0000000ffffffc00
#define BM_10_35 BM_35_10
#define BM_36_10 0x0000001ffffffc00
#define BM_10_36 BM_36_10
#define BM_37_10 0x0000003ffffffc00
#define BM_10_37 BM_37_10
#define BM_38_10 0x0000007ffffffc00
#define BM_10_38 BM_38_10
#define BM_39_10 0x000000fffffffc00
#define BM_10_39 BM_39_10
#define BM_40_10 0x000001fffffffc00
#define BM_10_40 BM_40_10
#define BM_41_10 0x000003fffffffc00
#define BM_10_41 BM_41_10
#define BM_42_10 0x000007fffffffc00
#define BM_10_42 BM_42_10
#define BM_43_10 0x00000ffffffffc00
#define BM_10_43 BM_43_10
#define BM_44_10 0x00001ffffffffc00
#define BM_10_44 BM_44_10
#define BM_45_10 0x00003ffffffffc00
#define BM_10_45 BM_45_10
#define BM_46_10 0x00007ffffffffc00
#define BM_10_46 BM_46_10
#define BM_47_10 0x0000fffffffffc00
#define BM_10_47 BM_47_10
#define BM_48_10 0x0001fffffffffc00
#define BM_10_48 BM_48_10
#define BM_49_10 0x0003fffffffffc00
#define BM_10_49 BM_49_10
#define BM_50_10 0x0007fffffffffc00
#define BM_10_50 BM_50_10
#define BM_51_10 0x000ffffffffffc00
#define BM_10_51 BM_51_10
#define BM_52_10 0x001ffffffffffc00
#define BM_10_52 BM_52_10
#define BM_53_10 0x003ffffffffffc00
#define BM_10_53 BM_53_10
#define BM_54_10 0x007ffffffffffc00
#define BM_10_54 BM_54_10
#define BM_55_10 0x00fffffffffffc00
#define BM_10_55 BM_55_10
#define BM_56_10 0x01fffffffffffc00
#define BM_10_56 BM_56_10
#define BM_57_10 0x03fffffffffffc00
#define BM_10_57 BM_57_10
#define BM_58_10 0x07fffffffffffc00
#define BM_10_58 BM_58_10
#define BM_59_10 0x0ffffffffffffc00
#define BM_10_59 BM_59_10
#define BM_60_10 0x1ffffffffffffc00
#define BM_10_60 BM_60_10
#define BM_61_10 0x3ffffffffffffc00
#define BM_10_61 BM_61_10
#define BM_62_10 0x7ffffffffffffc00
#define BM_10_62 BM_62_10
#define BM_63_10 0xfffffffffffffc00
#define BM_10_63 BM_63_10
#define BM_11_11 0x0000000000000800
#define BM_12_11 0x0000000000001800
#define BM_11_12 BM_12_11
#define BM_13_11 0x0000000000003800
#define BM_11_13 BM_13_11
#define BM_14_11 0x0000000000007800
#define BM_11_14 BM_14_11
#define BM_15_11 0x000000000000f800
#define BM_11_15 BM_15_11
#define BM_16_11 0x000000000001f800
#define BM_11_16 BM_16_11
#define BM_17_11 0x000000000003f800
#define BM_11_17 BM_17_11
#define BM_18_11 0x000000000007f800
#define BM_11_18 BM_18_11
#define BM_19_11 0x00000000000ff800
#define BM_11_19 BM_19_11
#define BM_20_11 0x00000000001ff800
#define BM_11_20 BM_20_11
#define BM_21_11 0x00000000003ff800
#define BM_11_21 BM_21_11
#define BM_22_11 0x00000000007ff800
#define BM_11_22 BM_22_11
#define BM_23_11 0x0000000000fff800
#define BM_11_23 BM_23_11
#define BM_24_11 0x0000000001fff800
#define BM_11_24 BM_24_11
#define BM_25_11 0x0000000003fff800
#define BM_11_25 BM_25_11
#define BM_26_11 0x0000000007fff800
#define BM_11_26 BM_26_11
#define BM_27_11 0x000000000ffff800
#define BM_11_27 BM_27_11
#define BM_28_11 0x000000001ffff800
#define BM_11_28 BM_28_11
#define BM_29_11 0x000000003ffff800
#define BM_11_29 BM_29_11
#define BM_30_11 0x000000007ffff800
#define BM_11_30 BM_30_11
#define BM_31_11 0x00000000fffff800
#define BM_11_31 BM_31_11
#define BM_32_11 0x00000001fffff800
#define BM_11_32 BM_32_11
#define BM_33_11 0x00000003fffff800
#define BM_11_33 BM_33_11
#define BM_34_11 0x00000007fffff800
#define BM_11_34 BM_34_11
#define BM_35_11 0x0000000ffffff800
#define BM_11_35 BM_35_11
#define BM_36_11 0x0000001ffffff800
#define BM_11_36 BM_36_11
#define BM_37_11 0x0000003ffffff800
#define BM_11_37 BM_37_11
#define BM_38_11 0x0000007ffffff800
#define BM_11_38 BM_38_11
#define BM_39_11 0x000000fffffff800
#define BM_11_39 BM_39_11
#define BM_40_11 0x000001fffffff800
#define BM_11_40 BM_40_11
#define BM_41_11 0x000003fffffff800
#define BM_11_41 BM_41_11
#define BM_42_11 0x000007fffffff800
#define BM_11_42 BM_42_11
#define BM_43_11 0x00000ffffffff800
#define BM_11_43 BM_43_11
#define BM_44_11 0x00001ffffffff800
#define BM_11_44 BM_44_11
#define BM_45_11 0x00003ffffffff800
#define BM_11_45 BM_45_11
#define BM_46_11 0x00007ffffffff800
#define BM_11_46 BM_46_11
#define BM_47_11 0x0000fffffffff800
#define BM_11_47 BM_47_11
#define BM_48_11 0x0001fffffffff800
#define BM_11_48 BM_48_11
#define BM_49_11 0x0003fffffffff800
#define BM_11_49 BM_49_11
#define BM_50_11 0x0007fffffffff800
#define BM_11_50 BM_50_11
#define BM_51_11 0x000ffffffffff800
#define BM_11_51 BM_51_11
#define BM_52_11 0x001ffffffffff800
#define BM_11_52 BM_52_11
#define BM_53_11 0x003ffffffffff800
#define BM_11_53 BM_53_11
#define BM_54_11 0x007ffffffffff800
#define BM_11_54 BM_54_11
#define BM_55_11 0x00fffffffffff800
#define BM_11_55 BM_55_11
#define BM_56_11 0x01fffffffffff800
#define BM_11_56 BM_56_11
#define BM_57_11 0x03fffffffffff800
#define BM_11_57 BM_57_11
#define BM_58_11 0x07fffffffffff800
#define BM_11_58 BM_58_11
#define BM_59_11 0x0ffffffffffff800
#define BM_11_59 BM_59_11
#define BM_60_11 0x1ffffffffffff800
#define BM_11_60 BM_60_11
#define BM_61_11 0x3ffffffffffff800
#define BM_11_61 BM_61_11
#define BM_62_11 0x7ffffffffffff800
#define BM_11_62 BM_62_11
#define BM_63_11 0xfffffffffffff800
#define BM_11_63 BM_63_11
#define BM_12_12 0x0000000000001000
#define BM_13_12 0x0000000000003000
#define BM_12_13 BM_13_12
#define BM_14_12 0x0000000000007000
#define BM_12_14 BM_14_12
#define BM_15_12 0x000000000000f000
#define BM_12_15 BM_15_12
#define BM_16_12 0x000000000001f000
#define BM_12_16 BM_16_12
#define BM_17_12 0x000000000003f000
#define BM_12_17 BM_17_12
#define BM_18_12 0x000000000007f000
#define BM_12_18 BM_18_12
#define BM_19_12 0x00000000000ff000
#define BM_12_19 BM_19_12
#define BM_20_12 0x00000000001ff000
#define BM_12_20 BM_20_12
#define BM_21_12 0x00000000003ff000
#define BM_12_21 BM_21_12
#define BM_22_12 0x00000000007ff000
#define BM_12_22 BM_22_12
#define BM_23_12 0x0000000000fff000
#define BM_12_23 BM_23_12
#define BM_24_12 0x0000000001fff000
#define BM_12_24 BM_24_12
#define BM_25_12 0x0000000003fff000
#define BM_12_25 BM_25_12
#define BM_26_12 0x0000000007fff000
#define BM_12_26 BM_26_12
#define BM_27_12 0x000000000ffff000
#define BM_12_27 BM_27_12
#define BM_28_12 0x000000001ffff000
#define BM_12_28 BM_28_12
#define BM_29_12 0x000000003ffff000
#define BM_12_29 BM_29_12
#define BM_30_12 0x000000007ffff000
#define BM_12_30 BM_30_12
#define BM_31_12 0x00000000fffff000
#define BM_12_31 BM_31_12
#define BM_32_12 0x00000001fffff000
#define BM_12_32 BM_32_12
#define BM_33_12 0x00000003fffff000
#define BM_12_33 BM_33_12
#define BM_34_12 0x00000007fffff000
#define BM_12_34 BM_34_12
#define BM_35_12 0x0000000ffffff000
#define BM_12_35 BM_35_12
#define BM_36_12 0x0000001ffffff000
#define BM_12_36 BM_36_12
#define BM_37_12 0x0000003ffffff000
#define BM_12_37 BM_37_12
#define BM_38_12 0x0000007ffffff000
#define BM_12_38 BM_38_12
#define BM_39_12 0x000000fffffff000
#define BM_12_39 BM_39_12
#define BM_40_12 0x000001fffffff000
#define BM_12_40 BM_40_12
#define BM_41_12 0x000003fffffff000
#define BM_12_41 BM_41_12
#define BM_42_12 0x000007fffffff000
#define BM_12_42 BM_42_12
#define BM_43_12 0x00000ffffffff000
#define BM_12_43 BM_43_12
#define BM_44_12 0x00001ffffffff000
#define BM_12_44 BM_44_12
#define BM_45_12 0x00003ffffffff000
#define BM_12_45 BM_45_12
#define BM_46_12 0x00007ffffffff000
#define BM_12_46 BM_46_12
#define BM_47_12 0x0000fffffffff000
#define BM_12_47 BM_47_12
#define BM_48_12 0x0001fffffffff000
#define BM_12_48 BM_48_12
#define BM_49_12 0x0003fffffffff000
#define BM_12_49 BM_49_12
#define BM_50_12 0x0007fffffffff000
#define BM_12_50 BM_50_12
#define BM_51_12 0x000ffffffffff000
#define BM_12_51 BM_51_12
#define BM_52_12 0x001ffffffffff000
#define BM_12_52 BM_52_12
#define BM_53_12 0x003ffffffffff000
#define BM_12_53 BM_53_12
#define BM_54_12 0x007ffffffffff000
#define BM_12_54 BM_54_12
#define BM_55_12 0x00fffffffffff000
#define BM_12_55 BM_55_12
#define BM_56_12 0x01fffffffffff000
#define BM_12_56 BM_56_12
#define BM_57_12 0x03fffffffffff000
#define BM_12_57 BM_57_12
#define BM_58_12 0x07fffffffffff000
#define BM_12_58 BM_58_12
#define BM_59_12 0x0ffffffffffff000
#define BM_12_59 BM_59_12
#define BM_60_12 0x1ffffffffffff000
#define BM_12_60 BM_60_12
#define BM_61_12 0x3ffffffffffff000
#define BM_12_61 BM_61_12
#define BM_62_12 0x7ffffffffffff000
#define BM_12_62 BM_62_12
#define BM_63_12 0xfffffffffffff000
#define BM_12_63 BM_63_12
#define BM_13_13 0x0000000000002000
#define BM_14_13 0x0000000000006000
#define BM_13_14 BM_14_13
#define BM_15_13 0x000000000000e000
#define BM_13_15 BM_15_13
#define BM_16_13 0x000000000001e000
#define BM_13_16 BM_16_13
#define BM_17_13 0x000000000003e000
#define BM_13_17 BM_17_13
#define BM_18_13 0x000000000007e000
#define BM_13_18 BM_18_13
#define BM_19_13 0x00000000000fe000
#define BM_13_19 BM_19_13
#define BM_20_13 0x00000000001fe000
#define BM_13_20 BM_20_13
#define BM_21_13 0x00000000003fe000
#define BM_13_21 BM_21_13
#define BM_22_13 0x00000000007fe000
#define BM_13_22 BM_22_13
#define BM_23_13 0x0000000000ffe000
#define BM_13_23 BM_23_13
#define BM_24_13 0x0000000001ffe000
#define BM_13_24 BM_24_13
#define BM_25_13 0x0000000003ffe000
#define BM_13_25 BM_25_13
#define BM_26_13 0x0000000007ffe000
#define BM_13_26 BM_26_13
#define BM_27_13 0x000000000fffe000
#define BM_13_27 BM_27_13
#define BM_28_13 0x000000001fffe000
#define BM_13_28 BM_28_13
#define BM_29_13 0x000000003fffe000
#define BM_13_29 BM_29_13
#define BM_30_13 0x000000007fffe000
#define BM_13_30 BM_30_13
#define BM_31_13 0x00000000ffffe000
#define BM_13_31 BM_31_13
#define BM_32_13 0x00000001ffffe000
#define BM_13_32 BM_32_13
#define BM_33_13 0x00000003ffffe000
#define BM_13_33 BM_33_13
#define BM_34_13 0x00000007ffffe000
#define BM_13_34 BM_34_13
#define BM_35_13 0x0000000fffffe000
#define BM_13_35 BM_35_13
#define BM_36_13 0x0000001fffffe000
#define BM_13_36 BM_36_13
#define BM_37_13 0x0000003fffffe000
#define BM_13_37 BM_37_13
#define BM_38_13 0x0000007fffffe000
#define BM_13_38 BM_38_13
#define BM_39_13 0x000000ffffffe000
#define BM_13_39 BM_39_13
#define BM_40_13 0x000001ffffffe000
#define BM_13_40 BM_40_13
#define BM_41_13 0x000003ffffffe000
#define BM_13_41 BM_41_13
#define BM_42_13 0x000007ffffffe000
#define BM_13_42 BM_42_13
#define BM_43_13 0x00000fffffffe000
#define BM_13_43 BM_43_13
#define BM_44_13 0x00001fffffffe000
#define BM_13_44 BM_44_13
#define BM_45_13 0x00003fffffffe000
#define BM_13_45 BM_45_13
#define BM_46_13 0x00007fffffffe000
#define BM_13_46 BM_46_13
#define BM_47_13 0x0000ffffffffe000
#define BM_13_47 BM_47_13
#define BM_48_13 0x0001ffffffffe000
#define BM_13_48 BM_48_13
#define BM_49_13 0x0003ffffffffe000
#define BM_13_49 BM_49_13
#define BM_50_13 0x0007ffffffffe000
#define BM_13_50 BM_50_13
#define BM_51_13 0x000fffffffffe000
#define BM_13_51 BM_51_13
#define BM_52_13 0x001fffffffffe000
#define BM_13_52 BM_52_13
#define BM_53_13 0x003fffffffffe000
#define BM_13_53 BM_53_13
#define BM_54_13 0x007fffffffffe000
#define BM_13_54 BM_54_13
#define BM_55_13 0x00ffffffffffe000
#define BM_13_55 BM_55_13
#define BM_56_13 0x01ffffffffffe000
#define BM_13_56 BM_56_13
#define BM_57_13 0x03ffffffffffe000
#define BM_13_57 BM_57_13
#define BM_58_13 0x07ffffffffffe000
#define BM_13_58 BM_58_13
#define BM_59_13 0x0fffffffffffe000
#define BM_13_59 BM_59_13
#define BM_60_13 0x1fffffffffffe000
#define BM_13_60 BM_60_13
#define BM_61_13 0x3fffffffffffe000
#define BM_13_61 BM_61_13
#define BM_62_13 0x7fffffffffffe000
#define BM_13_62 BM_62_13
#define BM_63_13 0xffffffffffffe000
#define BM_13_63 BM_63_13
#define BM_14_14 0x0000000000004000
#define BM_15_14 0x000000000000c000
#define BM_14_15 BM_15_14
#define BM_16_14 0x000000000001c000
#define BM_14_16 BM_16_14
#define BM_17_14 0x000000000003c000
#define BM_14_17 BM_17_14
#define BM_18_14 0x000000000007c000
#define BM_14_18 BM_18_14
#define BM_19_14 0x00000000000fc000
#define BM_14_19 BM_19_14
#define BM_20_14 0x00000000001fc000
#define BM_14_20 BM_20_14
#define BM_21_14 0x00000000003fc000
#define BM_14_21 BM_21_14
#define BM_22_14 0x00000000007fc000
#define BM_14_22 BM_22_14
#define BM_23_14 0x0000000000ffc000
#define BM_14_23 BM_23_14
#define BM_24_14 0x0000000001ffc000
#define BM_14_24 BM_24_14
#define BM_25_14 0x0000000003ffc000
#define BM_14_25 BM_25_14
#define BM_26_14 0x0000000007ffc000
#define BM_14_26 BM_26_14
#define BM_27_14 0x000000000fffc000
#define BM_14_27 BM_27_14
#define BM_28_14 0x000000001fffc000
#define BM_14_28 BM_28_14
#define BM_29_14 0x000000003fffc000
#define BM_14_29 BM_29_14
#define BM_30_14 0x000000007fffc000
#define BM_14_30 BM_30_14
#define BM_31_14 0x00000000ffffc000
#define BM_14_31 BM_31_14
#define BM_32_14 0x00000001ffffc000
#define BM_14_32 BM_32_14
#define BM_33_14 0x00000003ffffc000
#define BM_14_33 BM_33_14
#define BM_34_14 0x00000007ffffc000
#define BM_14_34 BM_34_14
#define BM_35_14 0x0000000fffffc000
#define BM_14_35 BM_35_14
#define BM_36_14 0x0000001fffffc000
#define BM_14_36 BM_36_14
#define BM_37_14 0x0000003fffffc000
#define BM_14_37 BM_37_14
#define BM_38_14 0x0000007fffffc000
#define BM_14_38 BM_38_14
#define BM_39_14 0x000000ffffffc000
#define BM_14_39 BM_39_14
#define BM_40_14 0x000001ffffffc000
#define BM_14_40 BM_40_14
#define BM_41_14 0x000003ffffffc000
#define BM_14_41 BM_41_14
#define BM_42_14 0x000007ffffffc000
#define BM_14_42 BM_42_14
#define BM_43_14 0x00000fffffffc000
#define BM_14_43 BM_43_14
#define BM_44_14 0x00001fffffffc000
#define BM_14_44 BM_44_14
#define BM_45_14 0x00003fffffffc000
#define BM_14_45 BM_45_14
#define BM_46_14 0x00007fffffffc000
#define BM_14_46 BM_46_14
#define BM_47_14 0x0000ffffffffc000
#define BM_14_47 BM_47_14
#define BM_48_14 0x0001ffffffffc000
#define BM_14_48 BM_48_14
#define BM_49_14 0x0003ffffffffc000
#define BM_14_49 BM_49_14
#define BM_50_14 0x0007ffffffffc000
#define BM_14_50 BM_50_14
#define BM_51_14 0x000fffffffffc000
#define BM_14_51 BM_51_14
#define BM_52_14 0x001fffffffffc000
#define BM_14_52 BM_52_14
#define BM_53_14 0x003fffffffffc000
#define BM_14_53 BM_53_14
#define BM_54_14 0x007fffffffffc000
#define BM_14_54 BM_54_14
#define BM_55_14 0x00ffffffffffc000
#define BM_14_55 BM_55_14
#define BM_56_14 0x01ffffffffffc000
#define BM_14_56 BM_56_14
#define BM_57_14 0x03ffffffffffc000
#define BM_14_57 BM_57_14
#define BM_58_14 0x07ffffffffffc000
#define BM_14_58 BM_58_14
#define BM_59_14 0x0fffffffffffc000
#define BM_14_59 BM_59_14
#define BM_60_14 0x1fffffffffffc000
#define BM_14_60 BM_60_14
#define BM_61_14 0x3fffffffffffc000
#define BM_14_61 BM_61_14
#define BM_62_14 0x7fffffffffffc000
#define BM_14_62 BM_62_14
#define BM_63_14 0xffffffffffffc000
#define BM_14_63 BM_63_14
#define BM_15_15 0x0000000000008000
#define BM_16_15 0x0000000000018000
#define BM_15_16 BM_16_15
#define BM_17_15 0x0000000000038000
#define BM_15_17 BM_17_15
#define BM_18_15 0x0000000000078000
#define BM_15_18 BM_18_15
#define BM_19_15 0x00000000000f8000
#define BM_15_19 BM_19_15
#define BM_20_15 0x00000000001f8000
#define BM_15_20 BM_20_15
#define BM_21_15 0x00000000003f8000
#define BM_15_21 BM_21_15
#define BM_22_15 0x00000000007f8000
#define BM_15_22 BM_22_15
#define BM_23_15 0x0000000000ff8000
#define BM_15_23 BM_23_15
#define BM_24_15 0x0000000001ff8000
#define BM_15_24 BM_24_15
#define BM_25_15 0x0000000003ff8000
#define BM_15_25 BM_25_15
#define BM_26_15 0x0000000007ff8000
#define BM_15_26 BM_26_15
#define BM_27_15 0x000000000fff8000
#define BM_15_27 BM_27_15
#define BM_28_15 0x000000001fff8000
#define BM_15_28 BM_28_15
#define BM_29_15 0x000000003fff8000
#define BM_15_29 BM_29_15
#define BM_30_15 0x000000007fff8000
#define BM_15_30 BM_30_15
#define BM_31_15 0x00000000ffff8000
#define BM_15_31 BM_31_15
#define BM_32_15 0x00000001ffff8000
#define BM_15_32 BM_32_15
#define BM_33_15 0x00000003ffff8000
#define BM_15_33 BM_33_15
#define BM_34_15 0x00000007ffff8000
#define BM_15_34 BM_34_15
#define BM_35_15 0x0000000fffff8000
#define BM_15_35 BM_35_15
#define BM_36_15 0x0000001fffff8000
#define BM_15_36 BM_36_15
#define BM_37_15 0x0000003fffff8000
#define BM_15_37 BM_37_15
#define BM_38_15 0x0000007fffff8000
#define BM_15_38 BM_38_15
#define BM_39_15 0x000000ffffff8000
#define BM_15_39 BM_39_15
#define BM_40_15 0x000001ffffff8000
#define BM_15_40 BM_40_15
#define BM_41_15 0x000003ffffff8000
#define BM_15_41 BM_41_15
#define BM_42_15 0x000007ffffff8000
#define BM_15_42 BM_42_15
#define BM_43_15 0x00000fffffff8000
#define BM_15_43 BM_43_15
#define BM_44_15 0x00001fffffff8000
#define BM_15_44 BM_44_15
#define BM_45_15 0x00003fffffff8000
#define BM_15_45 BM_45_15
#define BM_46_15 0x00007fffffff8000
#define BM_15_46 BM_46_15
#define BM_47_15 0x0000ffffffff8000
#define BM_15_47 BM_47_15
#define BM_48_15 0x0001ffffffff8000
#define BM_15_48 BM_48_15
#define BM_49_15 0x0003ffffffff8000
#define BM_15_49 BM_49_15
#define BM_50_15 0x0007ffffffff8000
#define BM_15_50 BM_50_15
#define BM_51_15 0x000fffffffff8000
#define BM_15_51 BM_51_15
#define BM_52_15 0x001fffffffff8000
#define BM_15_52 BM_52_15
#define BM_53_15 0x003fffffffff8000
#define BM_15_53 BM_53_15
#define BM_54_15 0x007fffffffff8000
#define BM_15_54 BM_54_15
#define BM_55_15 0x00ffffffffff8000
#define BM_15_55 BM_55_15
#define BM_56_15 0x01ffffffffff8000
#define BM_15_56 BM_56_15
#define BM_57_15 0x03ffffffffff8000
#define BM_15_57 BM_57_15
#define BM_58_15 0x07ffffffffff8000
#define BM_15_58 BM_58_15
#define BM_59_15 0x0fffffffffff8000
#define BM_15_59 BM_59_15
#define BM_60_15 0x1fffffffffff8000
#define BM_15_60 BM_60_15
#define BM_61_15 0x3fffffffffff8000
#define BM_15_61 BM_61_15
#define BM_62_15 0x7fffffffffff8000
#define BM_15_62 BM_62_15
#define BM_63_15 0xffffffffffff8000
#define BM_15_63 BM_63_15
#define BM_16_16 0x0000000000010000
#define BM_17_16 0x0000000000030000
#define BM_16_17 BM_17_16
#define BM_18_16 0x0000000000070000
#define BM_16_18 BM_18_16
#define BM_19_16 0x00000000000f0000
#define BM_16_19 BM_19_16
#define BM_20_16 0x00000000001f0000
#define BM_16_20 BM_20_16
#define BM_21_16 0x00000000003f0000
#define BM_16_21 BM_21_16
#define BM_22_16 0x00000000007f0000
#define BM_16_22 BM_22_16
#define BM_23_16 0x0000000000ff0000
#define BM_16_23 BM_23_16
#define BM_24_16 0x0000000001ff0000
#define BM_16_24 BM_24_16
#define BM_25_16 0x0000000003ff0000
#define BM_16_25 BM_25_16
#define BM_26_16 0x0000000007ff0000
#define BM_16_26 BM_26_16
#define BM_27_16 0x000000000fff0000
#define BM_16_27 BM_27_16
#define BM_28_16 0x000000001fff0000
#define BM_16_28 BM_28_16
#define BM_29_16 0x000000003fff0000
#define BM_16_29 BM_29_16
#define BM_30_16 0x000000007fff0000
#define BM_16_30 BM_30_16
#define BM_31_16 0x00000000ffff0000
#define BM_16_31 BM_31_16
#define BM_32_16 0x00000001ffff0000
#define BM_16_32 BM_32_16
#define BM_33_16 0x00000003ffff0000
#define BM_16_33 BM_33_16
#define BM_34_16 0x00000007ffff0000
#define BM_16_34 BM_34_16
#define BM_35_16 0x0000000fffff0000
#define BM_16_35 BM_35_16
#define BM_36_16 0x0000001fffff0000
#define BM_16_36 BM_36_16
#define BM_37_16 0x0000003fffff0000
#define BM_16_37 BM_37_16
#define BM_38_16 0x0000007fffff0000
#define BM_16_38 BM_38_16
#define BM_39_16 0x000000ffffff0000
#define BM_16_39 BM_39_16
#define BM_40_16 0x000001ffffff0000
#define BM_16_40 BM_40_16
#define BM_41_16 0x000003ffffff0000
#define BM_16_41 BM_41_16
#define BM_42_16 0x000007ffffff0000
#define BM_16_42 BM_42_16
#define BM_43_16 0x00000fffffff0000
#define BM_16_43 BM_43_16
#define BM_44_16 0x00001fffffff0000
#define BM_16_44 BM_44_16
#define BM_45_16 0x00003fffffff0000
#define BM_16_45 BM_45_16
#define BM_46_16 0x00007fffffff0000
#define BM_16_46 BM_46_16
#define BM_47_16 0x0000ffffffff0000
#define BM_16_47 BM_47_16
#define BM_48_16 0x0001ffffffff0000
#define BM_16_48 BM_48_16
#define BM_49_16 0x0003ffffffff0000
#define BM_16_49 BM_49_16
#define BM_50_16 0x0007ffffffff0000
#define BM_16_50 BM_50_16
#define BM_51_16 0x000fffffffff0000
#define BM_16_51 BM_51_16
#define BM_52_16 0x001fffffffff0000
#define BM_16_52 BM_52_16
#define BM_53_16 0x003fffffffff0000
#define BM_16_53 BM_53_16
#define BM_54_16 0x007fffffffff0000
#define BM_16_54 BM_54_16
#define BM_55_16 0x00ffffffffff0000
#define BM_16_55 BM_55_16
#define BM_56_16 0x01ffffffffff0000
#define BM_16_56 BM_56_16
#define BM_57_16 0x03ffffffffff0000
#define BM_16_57 BM_57_16
#define BM_58_16 0x07ffffffffff0000
#define BM_16_58 BM_58_16
#define BM_59_16 0x0fffffffffff0000
#define BM_16_59 BM_59_16
#define BM_60_16 0x1fffffffffff0000
#define BM_16_60 BM_60_16
#define BM_61_16 0x3fffffffffff0000
#define BM_16_61 BM_61_16
#define BM_62_16 0x7fffffffffff0000
#define BM_16_62 BM_62_16
#define BM_63_16 0xffffffffffff0000
#define BM_16_63 BM_63_16
#define BM_17_17 0x0000000000020000
#define BM_18_17 0x0000000000060000
#define BM_17_18 BM_18_17
#define BM_19_17 0x00000000000e0000
#define BM_17_19 BM_19_17
#define BM_20_17 0x00000000001e0000
#define BM_17_20 BM_20_17
#define BM_21_17 0x00000000003e0000
#define BM_17_21 BM_21_17
#define BM_22_17 0x00000000007e0000
#define BM_17_22 BM_22_17
#define BM_23_17 0x0000000000fe0000
#define BM_17_23 BM_23_17
#define BM_24_17 0x0000000001fe0000
#define BM_17_24 BM_24_17
#define BM_25_17 0x0000000003fe0000
#define BM_17_25 BM_25_17
#define BM_26_17 0x0000000007fe0000
#define BM_17_26 BM_26_17
#define BM_27_17 0x000000000ffe0000
#define BM_17_27 BM_27_17
#define BM_28_17 0x000000001ffe0000
#define BM_17_28 BM_28_17
#define BM_29_17 0x000000003ffe0000
#define BM_17_29 BM_29_17
#define BM_30_17 0x000000007ffe0000
#define BM_17_30 BM_30_17
#define BM_31_17 0x00000000fffe0000
#define BM_17_31 BM_31_17
#define BM_32_17 0x00000001fffe0000
#define BM_17_32 BM_32_17
#define BM_33_17 0x00000003fffe0000
#define BM_17_33 BM_33_17
#define BM_34_17 0x00000007fffe0000
#define BM_17_34 BM_34_17
#define BM_35_17 0x0000000ffffe0000
#define BM_17_35 BM_35_17
#define BM_36_17 0x0000001ffffe0000
#define BM_17_36 BM_36_17
#define BM_37_17 0x0000003ffffe0000
#define BM_17_37 BM_37_17
#define BM_38_17 0x0000007ffffe0000
#define BM_17_38 BM_38_17
#define BM_39_17 0x000000fffffe0000
#define BM_17_39 BM_39_17
#define BM_40_17 0x000001fffffe0000
#define BM_17_40 BM_40_17
#define BM_41_17 0x000003fffffe0000
#define BM_17_41 BM_41_17
#define BM_42_17 0x000007fffffe0000
#define BM_17_42 BM_42_17
#define BM_43_17 0x00000ffffffe0000
#define BM_17_43 BM_43_17
#define BM_44_17 0x00001ffffffe0000
#define BM_17_44 BM_44_17
#define BM_45_17 0x00003ffffffe0000
#define BM_17_45 BM_45_17
#define BM_46_17 0x00007ffffffe0000
#define BM_17_46 BM_46_17
#define BM_47_17 0x0000fffffffe0000
#define BM_17_47 BM_47_17
#define BM_48_17 0x0001fffffffe0000
#define BM_17_48 BM_48_17
#define BM_49_17 0x0003fffffffe0000
#define BM_17_49 BM_49_17
#define BM_50_17 0x0007fffffffe0000
#define BM_17_50 BM_50_17
#define BM_51_17 0x000ffffffffe0000
#define BM_17_51 BM_51_17
#define BM_52_17 0x001ffffffffe0000
#define BM_17_52 BM_52_17
#define BM_53_17 0x003ffffffffe0000
#define BM_17_53 BM_53_17
#define BM_54_17 0x007ffffffffe0000
#define BM_17_54 BM_54_17
#define BM_55_17 0x00fffffffffe0000
#define BM_17_55 BM_55_17
#define BM_56_17 0x01fffffffffe0000
#define BM_17_56 BM_56_17
#define BM_57_17 0x03fffffffffe0000
#define BM_17_57 BM_57_17
#define BM_58_17 0x07fffffffffe0000
#define BM_17_58 BM_58_17
#define BM_59_17 0x0ffffffffffe0000
#define BM_17_59 BM_59_17
#define BM_60_17 0x1ffffffffffe0000
#define BM_17_60 BM_60_17
#define BM_61_17 0x3ffffffffffe0000
#define BM_17_61 BM_61_17
#define BM_62_17 0x7ffffffffffe0000
#define BM_17_62 BM_62_17
#define BM_63_17 0xfffffffffffe0000
#define BM_17_63 BM_63_17
#define BM_18_18 0x0000000000040000
#define BM_19_18 0x00000000000c0000
#define BM_18_19 BM_19_18
#define BM_20_18 0x00000000001c0000
#define BM_18_20 BM_20_18
#define BM_21_18 0x00000000003c0000
#define BM_18_21 BM_21_18
#define BM_22_18 0x00000000007c0000
#define BM_18_22 BM_22_18
#define BM_23_18 0x0000000000fc0000
#define BM_18_23 BM_23_18
#define BM_24_18 0x0000000001fc0000
#define BM_18_24 BM_24_18
#define BM_25_18 0x0000000003fc0000
#define BM_18_25 BM_25_18
#define BM_26_18 0x0000000007fc0000
#define BM_18_26 BM_26_18
#define BM_27_18 0x000000000ffc0000
#define BM_18_27 BM_27_18
#define BM_28_18 0x000000001ffc0000
#define BM_18_28 BM_28_18
#define BM_29_18 0x000000003ffc0000
#define BM_18_29 BM_29_18
#define BM_30_18 0x000000007ffc0000
#define BM_18_30 BM_30_18
#define BM_31_18 0x00000000fffc0000
#define BM_18_31 BM_31_18
#define BM_32_18 0x00000001fffc0000
#define BM_18_32 BM_32_18
#define BM_33_18 0x00000003fffc0000
#define BM_18_33 BM_33_18
#define BM_34_18 0x00000007fffc0000
#define BM_18_34 BM_34_18
#define BM_35_18 0x0000000ffffc0000
#define BM_18_35 BM_35_18
#define BM_36_18 0x0000001ffffc0000
#define BM_18_36 BM_36_18
#define BM_37_18 0x0000003ffffc0000
#define BM_18_37 BM_37_18
#define BM_38_18 0x0000007ffffc0000
#define BM_18_38 BM_38_18
#define BM_39_18 0x000000fffffc0000
#define BM_18_39 BM_39_18
#define BM_40_18 0x000001fffffc0000
#define BM_18_40 BM_40_18
#define BM_41_18 0x000003fffffc0000
#define BM_18_41 BM_41_18
#define BM_42_18 0x000007fffffc0000
#define BM_18_42 BM_42_18
#define BM_43_18 0x00000ffffffc0000
#define BM_18_43 BM_43_18
#define BM_44_18 0x00001ffffffc0000
#define BM_18_44 BM_44_18
#define BM_45_18 0x00003ffffffc0000
#define BM_18_45 BM_45_18
#define BM_46_18 0x00007ffffffc0000
#define BM_18_46 BM_46_18
#define BM_47_18 0x0000fffffffc0000
#define BM_18_47 BM_47_18
#define BM_48_18 0x0001fffffffc0000
#define BM_18_48 BM_48_18
#define BM_49_18 0x0003fffffffc0000
#define BM_18_49 BM_49_18
#define BM_50_18 0x0007fffffffc0000
#define BM_18_50 BM_50_18
#define BM_51_18 0x000ffffffffc0000
#define BM_18_51 BM_51_18
#define BM_52_18 0x001ffffffffc0000
#define BM_18_52 BM_52_18
#define BM_53_18 0x003ffffffffc0000
#define BM_18_53 BM_53_18
#define BM_54_18 0x007ffffffffc0000
#define BM_18_54 BM_54_18
#define BM_55_18 0x00fffffffffc0000
#define BM_18_55 BM_55_18
#define BM_56_18 0x01fffffffffc0000
#define BM_18_56 BM_56_18
#define BM_57_18 0x03fffffffffc0000
#define BM_18_57 BM_57_18
#define BM_58_18 0x07fffffffffc0000
#define BM_18_58 BM_58_18
#define BM_59_18 0x0ffffffffffc0000
#define BM_18_59 BM_59_18
#define BM_60_18 0x1ffffffffffc0000
#define BM_18_60 BM_60_18
#define BM_61_18 0x3ffffffffffc0000
#define BM_18_61 BM_61_18
#define BM_62_18 0x7ffffffffffc0000
#define BM_18_62 BM_62_18
#define BM_63_18 0xfffffffffffc0000
#define BM_18_63 BM_63_18
#define BM_19_19 0x0000000000080000
#define BM_20_19 0x0000000000180000
#define BM_19_20 BM_20_19
#define BM_21_19 0x0000000000380000
#define BM_19_21 BM_21_19
#define BM_22_19 0x0000000000780000
#define BM_19_22 BM_22_19
#define BM_23_19 0x0000000000f80000
#define BM_19_23 BM_23_19
#define BM_24_19 0x0000000001f80000
#define BM_19_24 BM_24_19
#define BM_25_19 0x0000000003f80000
#define BM_19_25 BM_25_19
#define BM_26_19 0x0000000007f80000
#define BM_19_26 BM_26_19
#define BM_27_19 0x000000000ff80000
#define BM_19_27 BM_27_19
#define BM_28_19 0x000000001ff80000
#define BM_19_28 BM_28_19
#define BM_29_19 0x000000003ff80000
#define BM_19_29 BM_29_19
#define BM_30_19 0x000000007ff80000
#define BM_19_30 BM_30_19
#define BM_31_19 0x00000000fff80000
#define BM_19_31 BM_31_19
#define BM_32_19 0x00000001fff80000
#define BM_19_32 BM_32_19
#define BM_33_19 0x00000003fff80000
#define BM_19_33 BM_33_19
#define BM_34_19 0x00000007fff80000
#define BM_19_34 BM_34_19
#define BM_35_19 0x0000000ffff80000
#define BM_19_35 BM_35_19
#define BM_36_19 0x0000001ffff80000
#define BM_19_36 BM_36_19
#define BM_37_19 0x0000003ffff80000
#define BM_19_37 BM_37_19
#define BM_38_19 0x0000007ffff80000
#define BM_19_38 BM_38_19
#define BM_39_19 0x000000fffff80000
#define BM_19_39 BM_39_19
#define BM_40_19 0x000001fffff80000
#define BM_19_40 BM_40_19
#define BM_41_19 0x000003fffff80000
#define BM_19_41 BM_41_19
#define BM_42_19 0x000007fffff80000
#define BM_19_42 BM_42_19
#define BM_43_19 0x00000ffffff80000
#define BM_19_43 BM_43_19
#define BM_44_19 0x00001ffffff80000
#define BM_19_44 BM_44_19
#define BM_45_19 0x00003ffffff80000
#define BM_19_45 BM_45_19
#define BM_46_19 0x00007ffffff80000
#define BM_19_46 BM_46_19
#define BM_47_19 0x0000fffffff80000
#define BM_19_47 BM_47_19
#define BM_48_19 0x0001fffffff80000
#define BM_19_48 BM_48_19
#define BM_49_19 0x0003fffffff80000
#define BM_19_49 BM_49_19
#define BM_50_19 0x0007fffffff80000
#define BM_19_50 BM_50_19
#define BM_51_19 0x000ffffffff80000
#define BM_19_51 BM_51_19
#define BM_52_19 0x001ffffffff80000
#define BM_19_52 BM_52_19
#define BM_53_19 0x003ffffffff80000
#define BM_19_53 BM_53_19
#define BM_54_19 0x007ffffffff80000
#define BM_19_54 BM_54_19
#define BM_55_19 0x00fffffffff80000
#define BM_19_55 BM_55_19
#define BM_56_19 0x01fffffffff80000
#define BM_19_56 BM_56_19
#define BM_57_19 0x03fffffffff80000
#define BM_19_57 BM_57_19
#define BM_58_19 0x07fffffffff80000
#define BM_19_58 BM_58_19
#define BM_59_19 0x0ffffffffff80000
#define BM_19_59 BM_59_19
#define BM_60_19 0x1ffffffffff80000
#define BM_19_60 BM_60_19
#define BM_61_19 0x3ffffffffff80000
#define BM_19_61 BM_61_19
#define BM_62_19 0x7ffffffffff80000
#define BM_19_62 BM_62_19
#define BM_63_19 0xfffffffffff80000
#define BM_19_63 BM_63_19
#define BM_20_20 0x0000000000100000
#define BM_21_20 0x0000000000300000
#define BM_20_21 BM_21_20
#define BM_22_20 0x0000000000700000
#define BM_20_22 BM_22_20
#define BM_23_20 0x0000000000f00000
#define BM_20_23 BM_23_20
#define BM_24_20 0x0000000001f00000
#define BM_20_24 BM_24_20
#define BM_25_20 0x0000000003f00000
#define BM_20_25 BM_25_20
#define BM_26_20 0x0000000007f00000
#define BM_20_26 BM_26_20
#define BM_27_20 0x000000000ff00000
#define BM_20_27 BM_27_20
#define BM_28_20 0x000000001ff00000
#define BM_20_28 BM_28_20
#define BM_29_20 0x000000003ff00000
#define BM_20_29 BM_29_20
#define BM_30_20 0x000000007ff00000
#define BM_20_30 BM_30_20
#define BM_31_20 0x00000000fff00000
#define BM_20_31 BM_31_20
#define BM_32_20 0x00000001fff00000
#define BM_20_32 BM_32_20
#define BM_33_20 0x00000003fff00000
#define BM_20_33 BM_33_20
#define BM_34_20 0x00000007fff00000
#define BM_20_34 BM_34_20
#define BM_35_20 0x0000000ffff00000
#define BM_20_35 BM_35_20
#define BM_36_20 0x0000001ffff00000
#define BM_20_36 BM_36_20
#define BM_37_20 0x0000003ffff00000
#define BM_20_37 BM_37_20
#define BM_38_20 0x0000007ffff00000
#define BM_20_38 BM_38_20
#define BM_39_20 0x000000fffff00000
#define BM_20_39 BM_39_20
#define BM_40_20 0x000001fffff00000
#define BM_20_40 BM_40_20
#define BM_41_20 0x000003fffff00000
#define BM_20_41 BM_41_20
#define BM_42_20 0x000007fffff00000
#define BM_20_42 BM_42_20
#define BM_43_20 0x00000ffffff00000
#define BM_20_43 BM_43_20
#define BM_44_20 0x00001ffffff00000
#define BM_20_44 BM_44_20
#define BM_45_20 0x00003ffffff00000
#define BM_20_45 BM_45_20
#define BM_46_20 0x00007ffffff00000
#define BM_20_46 BM_46_20
#define BM_47_20 0x0000fffffff00000
#define BM_20_47 BM_47_20
#define BM_48_20 0x0001fffffff00000
#define BM_20_48 BM_48_20
#define BM_49_20 0x0003fffffff00000
#define BM_20_49 BM_49_20
#define BM_50_20 0x0007fffffff00000
#define BM_20_50 BM_50_20
#define BM_51_20 0x000ffffffff00000
#define BM_20_51 BM_51_20
#define BM_52_20 0x001ffffffff00000
#define BM_20_52 BM_52_20
#define BM_53_20 0x003ffffffff00000
#define BM_20_53 BM_53_20
#define BM_54_20 0x007ffffffff00000
#define BM_20_54 BM_54_20
#define BM_55_20 0x00fffffffff00000
#define BM_20_55 BM_55_20
#define BM_56_20 0x01fffffffff00000
#define BM_20_56 BM_56_20
#define BM_57_20 0x03fffffffff00000
#define BM_20_57 BM_57_20
#define BM_58_20 0x07fffffffff00000
#define BM_20_58 BM_58_20
#define BM_59_20 0x0ffffffffff00000
#define BM_20_59 BM_59_20
#define BM_60_20 0x1ffffffffff00000
#define BM_20_60 BM_60_20
#define BM_61_20 0x3ffffffffff00000
#define BM_20_61 BM_61_20
#define BM_62_20 0x7ffffffffff00000
#define BM_20_62 BM_62_20
#define BM_63_20 0xfffffffffff00000
#define BM_20_63 BM_63_20
#define BM_21_21 0x0000000000200000
#define BM_22_21 0x0000000000600000
#define BM_21_22 BM_22_21
#define BM_23_21 0x0000000000e00000
#define BM_21_23 BM_23_21
#define BM_24_21 0x0000000001e00000
#define BM_21_24 BM_24_21
#define BM_25_21 0x0000000003e00000
#define BM_21_25 BM_25_21
#define BM_26_21 0x0000000007e00000
#define BM_21_26 BM_26_21
#define BM_27_21 0x000000000fe00000
#define BM_21_27 BM_27_21
#define BM_28_21 0x000000001fe00000
#define BM_21_28 BM_28_21
#define BM_29_21 0x000000003fe00000
#define BM_21_29 BM_29_21
#define BM_30_21 0x000000007fe00000
#define BM_21_30 BM_30_21
#define BM_31_21 0x00000000ffe00000
#define BM_21_31 BM_31_21
#define BM_32_21 0x00000001ffe00000
#define BM_21_32 BM_32_21
#define BM_33_21 0x00000003ffe00000
#define BM_21_33 BM_33_21
#define BM_34_21 0x00000007ffe00000
#define BM_21_34 BM_34_21
#define BM_35_21 0x0000000fffe00000
#define BM_21_35 BM_35_21
#define BM_36_21 0x0000001fffe00000
#define BM_21_36 BM_36_21
#define BM_37_21 0x0000003fffe00000
#define BM_21_37 BM_37_21
#define BM_38_21 0x0000007fffe00000
#define BM_21_38 BM_38_21
#define BM_39_21 0x000000ffffe00000
#define BM_21_39 BM_39_21
#define BM_40_21 0x000001ffffe00000
#define BM_21_40 BM_40_21
#define BM_41_21 0x000003ffffe00000
#define BM_21_41 BM_41_21
#define BM_42_21 0x000007ffffe00000
#define BM_21_42 BM_42_21
#define BM_43_21 0x00000fffffe00000
#define BM_21_43 BM_43_21
#define BM_44_21 0x00001fffffe00000
#define BM_21_44 BM_44_21
#define BM_45_21 0x00003fffffe00000
#define BM_21_45 BM_45_21
#define BM_46_21 0x00007fffffe00000
#define BM_21_46 BM_46_21
#define BM_47_21 0x0000ffffffe00000
#define BM_21_47 BM_47_21
#define BM_48_21 0x0001ffffffe00000
#define BM_21_48 BM_48_21
#define BM_49_21 0x0003ffffffe00000
#define BM_21_49 BM_49_21
#define BM_50_21 0x0007ffffffe00000
#define BM_21_50 BM_50_21
#define BM_51_21 0x000fffffffe00000
#define BM_21_51 BM_51_21
#define BM_52_21 0x001fffffffe00000
#define BM_21_52 BM_52_21
#define BM_53_21 0x003fffffffe00000
#define BM_21_53 BM_53_21
#define BM_54_21 0x007fffffffe00000
#define BM_21_54 BM_54_21
#define BM_55_21 0x00ffffffffe00000
#define BM_21_55 BM_55_21
#define BM_56_21 0x01ffffffffe00000
#define BM_21_56 BM_56_21
#define BM_57_21 0x03ffffffffe00000
#define BM_21_57 BM_57_21
#define BM_58_21 0x07ffffffffe00000
#define BM_21_58 BM_58_21
#define BM_59_21 0x0fffffffffe00000
#define BM_21_59 BM_59_21
#define BM_60_21 0x1fffffffffe00000
#define BM_21_60 BM_60_21
#define BM_61_21 0x3fffffffffe00000
#define BM_21_61 BM_61_21
#define BM_62_21 0x7fffffffffe00000
#define BM_21_62 BM_62_21
#define BM_63_21 0xffffffffffe00000
#define BM_21_63 BM_63_21
#define BM_22_22 0x0000000000400000
#define BM_23_22 0x0000000000c00000
#define BM_22_23 BM_23_22
#define BM_24_22 0x0000000001c00000
#define BM_22_24 BM_24_22
#define BM_25_22 0x0000000003c00000
#define BM_22_25 BM_25_22
#define BM_26_22 0x0000000007c00000
#define BM_22_26 BM_26_22
#define BM_27_22 0x000000000fc00000
#define BM_22_27 BM_27_22
#define BM_28_22 0x000000001fc00000
#define BM_22_28 BM_28_22
#define BM_29_22 0x000000003fc00000
#define BM_22_29 BM_29_22
#define BM_30_22 0x000000007fc00000
#define BM_22_30 BM_30_22
#define BM_31_22 0x00000000ffc00000
#define BM_22_31 BM_31_22
#define BM_32_22 0x00000001ffc00000
#define BM_22_32 BM_32_22
#define BM_33_22 0x00000003ffc00000
#define BM_22_33 BM_33_22
#define BM_34_22 0x00000007ffc00000
#define BM_22_34 BM_34_22
#define BM_35_22 0x0000000fffc00000
#define BM_22_35 BM_35_22
#define BM_36_22 0x0000001fffc00000
#define BM_22_36 BM_36_22
#define BM_37_22 0x0000003fffc00000
#define BM_22_37 BM_37_22
#define BM_38_22 0x0000007fffc00000
#define BM_22_38 BM_38_22
#define BM_39_22 0x000000ffffc00000
#define BM_22_39 BM_39_22
#define BM_40_22 0x000001ffffc00000
#define BM_22_40 BM_40_22
#define BM_41_22 0x000003ffffc00000
#define BM_22_41 BM_41_22
#define BM_42_22 0x000007ffffc00000
#define BM_22_42 BM_42_22
#define BM_43_22 0x00000fffffc00000
#define BM_22_43 BM_43_22
#define BM_44_22 0x00001fffffc00000
#define BM_22_44 BM_44_22
#define BM_45_22 0x00003fffffc00000
#define BM_22_45 BM_45_22
#define BM_46_22 0x00007fffffc00000
#define BM_22_46 BM_46_22
#define BM_47_22 0x0000ffffffc00000
#define BM_22_47 BM_47_22
#define BM_48_22 0x0001ffffffc00000
#define BM_22_48 BM_48_22
#define BM_49_22 0x0003ffffffc00000
#define BM_22_49 BM_49_22
#define BM_50_22 0x0007ffffffc00000
#define BM_22_50 BM_50_22
#define BM_51_22 0x000fffffffc00000
#define BM_22_51 BM_51_22
#define BM_52_22 0x001fffffffc00000
#define BM_22_52 BM_52_22
#define BM_53_22 0x003fffffffc00000
#define BM_22_53 BM_53_22
#define BM_54_22 0x007fffffffc00000
#define BM_22_54 BM_54_22
#define BM_55_22 0x00ffffffffc00000
#define BM_22_55 BM_55_22
#define BM_56_22 0x01ffffffffc00000
#define BM_22_56 BM_56_22
#define BM_57_22 0x03ffffffffc00000
#define BM_22_57 BM_57_22
#define BM_58_22 0x07ffffffffc00000
#define BM_22_58 BM_58_22
#define BM_59_22 0x0fffffffffc00000
#define BM_22_59 BM_59_22
#define BM_60_22 0x1fffffffffc00000
#define BM_22_60 BM_60_22
#define BM_61_22 0x3fffffffffc00000
#define BM_22_61 BM_61_22
#define BM_62_22 0x7fffffffffc00000
#define BM_22_62 BM_62_22
#define BM_63_22 0xffffffffffc00000
#define BM_22_63 BM_63_22
#define BM_23_23 0x0000000000800000
#define BM_24_23 0x0000000001800000
#define BM_23_24 BM_24_23
#define BM_25_23 0x0000000003800000
#define BM_23_25 BM_25_23
#define BM_26_23 0x0000000007800000
#define BM_23_26 BM_26_23
#define BM_27_23 0x000000000f800000
#define BM_23_27 BM_27_23
#define BM_28_23 0x000000001f800000
#define BM_23_28 BM_28_23
#define BM_29_23 0x000000003f800000
#define BM_23_29 BM_29_23
#define BM_30_23 0x000000007f800000
#define BM_23_30 BM_30_23
#define BM_31_23 0x00000000ff800000
#define BM_23_31 BM_31_23
#define BM_32_23 0x00000001ff800000
#define BM_23_32 BM_32_23
#define BM_33_23 0x00000003ff800000
#define BM_23_33 BM_33_23
#define BM_34_23 0x00000007ff800000
#define BM_23_34 BM_34_23
#define BM_35_23 0x0000000fff800000
#define BM_23_35 BM_35_23
#define BM_36_23 0x0000001fff800000
#define BM_23_36 BM_36_23
#define BM_37_23 0x0000003fff800000
#define BM_23_37 BM_37_23
#define BM_38_23 0x0000007fff800000
#define BM_23_38 BM_38_23
#define BM_39_23 0x000000ffff800000
#define BM_23_39 BM_39_23
#define BM_40_23 0x000001ffff800000
#define BM_23_40 BM_40_23
#define BM_41_23 0x000003ffff800000
#define BM_23_41 BM_41_23
#define BM_42_23 0x000007ffff800000
#define BM_23_42 BM_42_23
#define BM_43_23 0x00000fffff800000
#define BM_23_43 BM_43_23
#define BM_44_23 0x00001fffff800000
#define BM_23_44 BM_44_23
#define BM_45_23 0x00003fffff800000
#define BM_23_45 BM_45_23
#define BM_46_23 0x00007fffff800000
#define BM_23_46 BM_46_23
#define BM_47_23 0x0000ffffff800000
#define BM_23_47 BM_47_23
#define BM_48_23 0x0001ffffff800000
#define BM_23_48 BM_48_23
#define BM_49_23 0x0003ffffff800000
#define BM_23_49 BM_49_23
#define BM_50_23 0x0007ffffff800000
#define BM_23_50 BM_50_23
#define BM_51_23 0x000fffffff800000
#define BM_23_51 BM_51_23
#define BM_52_23 0x001fffffff800000
#define BM_23_52 BM_52_23
#define BM_53_23 0x003fffffff800000
#define BM_23_53 BM_53_23
#define BM_54_23 0x007fffffff800000
#define BM_23_54 BM_54_23
#define BM_55_23 0x00ffffffff800000
#define BM_23_55 BM_55_23
#define BM_56_23 0x01ffffffff800000
#define BM_23_56 BM_56_23
#define BM_57_23 0x03ffffffff800000
#define BM_23_57 BM_57_23
#define BM_58_23 0x07ffffffff800000
#define BM_23_58 BM_58_23
#define BM_59_23 0x0fffffffff800000
#define BM_23_59 BM_59_23
#define BM_60_23 0x1fffffffff800000
#define BM_23_60 BM_60_23
#define BM_61_23 0x3fffffffff800000
#define BM_23_61 BM_61_23
#define BM_62_23 0x7fffffffff800000
#define BM_23_62 BM_62_23
#define BM_63_23 0xffffffffff800000
#define BM_23_63 BM_63_23
#define BM_24_24 0x0000000001000000
#define BM_25_24 0x0000000003000000
#define BM_24_25 BM_25_24
#define BM_26_24 0x0000000007000000
#define BM_24_26 BM_26_24
#define BM_27_24 0x000000000f000000
#define BM_24_27 BM_27_24
#define BM_28_24 0x000000001f000000
#define BM_24_28 BM_28_24
#define BM_29_24 0x000000003f000000
#define BM_24_29 BM_29_24
#define BM_30_24 0x000000007f000000
#define BM_24_30 BM_30_24
#define BM_31_24 0x00000000ff000000
#define BM_24_31 BM_31_24
#define BM_32_24 0x00000001ff000000
#define BM_24_32 BM_32_24
#define BM_33_24 0x00000003ff000000
#define BM_24_33 BM_33_24
#define BM_34_24 0x00000007ff000000
#define BM_24_34 BM_34_24
#define BM_35_24 0x0000000fff000000
#define BM_24_35 BM_35_24
#define BM_36_24 0x0000001fff000000
#define BM_24_36 BM_36_24
#define BM_37_24 0x0000003fff000000
#define BM_24_37 BM_37_24
#define BM_38_24 0x0000007fff000000
#define BM_24_38 BM_38_24
#define BM_39_24 0x000000ffff000000
#define BM_24_39 BM_39_24
#define BM_40_24 0x000001ffff000000
#define BM_24_40 BM_40_24
#define BM_41_24 0x000003ffff000000
#define BM_24_41 BM_41_24
#define BM_42_24 0x000007ffff000000
#define BM_24_42 BM_42_24
#define BM_43_24 0x00000fffff000000
#define BM_24_43 BM_43_24
#define BM_44_24 0x00001fffff000000
#define BM_24_44 BM_44_24
#define BM_45_24 0x00003fffff000000
#define BM_24_45 BM_45_24
#define BM_46_24 0x00007fffff000000
#define BM_24_46 BM_46_24
#define BM_47_24 0x0000ffffff000000
#define BM_24_47 BM_47_24
#define BM_48_24 0x0001ffffff000000
#define BM_24_48 BM_48_24
#define BM_49_24 0x0003ffffff000000
#define BM_24_49 BM_49_24
#define BM_50_24 0x0007ffffff000000
#define BM_24_50 BM_50_24
#define BM_51_24 0x000fffffff000000
#define BM_24_51 BM_51_24
#define BM_52_24 0x001fffffff000000
#define BM_24_52 BM_52_24
#define BM_53_24 0x003fffffff000000
#define BM_24_53 BM_53_24
#define BM_54_24 0x007fffffff000000
#define BM_24_54 BM_54_24
#define BM_55_24 0x00ffffffff000000
#define BM_24_55 BM_55_24
#define BM_56_24 0x01ffffffff000000
#define BM_24_56 BM_56_24
#define BM_57_24 0x03ffffffff000000
#define BM_24_57 BM_57_24
#define BM_58_24 0x07ffffffff000000
#define BM_24_58 BM_58_24
#define BM_59_24 0x0fffffffff000000
#define BM_24_59 BM_59_24
#define BM_60_24 0x1fffffffff000000
#define BM_24_60 BM_60_24
#define BM_61_24 0x3fffffffff000000
#define BM_24_61 BM_61_24
#define BM_62_24 0x7fffffffff000000
#define BM_24_62 BM_62_24
#define BM_63_24 0xffffffffff000000
#define BM_24_63 BM_63_24
#define BM_25_25 0x0000000002000000
#define BM_26_25 0x0000000006000000
#define BM_25_26 BM_26_25
#define BM_27_25 0x000000000e000000
#define BM_25_27 BM_27_25
#define BM_28_25 0x000000001e000000
#define BM_25_28 BM_28_25
#define BM_29_25 0x000000003e000000
#define BM_25_29 BM_29_25
#define BM_30_25 0x000000007e000000
#define BM_25_30 BM_30_25
#define BM_31_25 0x00000000fe000000
#define BM_25_31 BM_31_25
#define BM_32_25 0x00000001fe000000
#define BM_25_32 BM_32_25
#define BM_33_25 0x00000003fe000000
#define BM_25_33 BM_33_25
#define BM_34_25 0x00000007fe000000
#define BM_25_34 BM_34_25
#define BM_35_25 0x0000000ffe000000
#define BM_25_35 BM_35_25
#define BM_36_25 0x0000001ffe000000
#define BM_25_36 BM_36_25
#define BM_37_25 0x0000003ffe000000
#define BM_25_37 BM_37_25
#define BM_38_25 0x0000007ffe000000
#define BM_25_38 BM_38_25
#define BM_39_25 0x000000fffe000000
#define BM_25_39 BM_39_25
#define BM_40_25 0x000001fffe000000
#define BM_25_40 BM_40_25
#define BM_41_25 0x000003fffe000000
#define BM_25_41 BM_41_25
#define BM_42_25 0x000007fffe000000
#define BM_25_42 BM_42_25
#define BM_43_25 0x00000ffffe000000
#define BM_25_43 BM_43_25
#define BM_44_25 0x00001ffffe000000
#define BM_25_44 BM_44_25
#define BM_45_25 0x00003ffffe000000
#define BM_25_45 BM_45_25
#define BM_46_25 0x00007ffffe000000
#define BM_25_46 BM_46_25
#define BM_47_25 0x0000fffffe000000
#define BM_25_47 BM_47_25
#define BM_48_25 0x0001fffffe000000
#define BM_25_48 BM_48_25
#define BM_49_25 0x0003fffffe000000
#define BM_25_49 BM_49_25
#define BM_50_25 0x0007fffffe000000
#define BM_25_50 BM_50_25
#define BM_51_25 0x000ffffffe000000
#define BM_25_51 BM_51_25
#define BM_52_25 0x001ffffffe000000
#define BM_25_52 BM_52_25
#define BM_53_25 0x003ffffffe000000
#define BM_25_53 BM_53_25
#define BM_54_25 0x007ffffffe000000
#define BM_25_54 BM_54_25
#define BM_55_25 0x00fffffffe000000
#define BM_25_55 BM_55_25
#define BM_56_25 0x01fffffffe000000
#define BM_25_56 BM_56_25
#define BM_57_25 0x03fffffffe000000
#define BM_25_57 BM_57_25
#define BM_58_25 0x07fffffffe000000
#define BM_25_58 BM_58_25
#define BM_59_25 0x0ffffffffe000000
#define BM_25_59 BM_59_25
#define BM_60_25 0x1ffffffffe000000
#define BM_25_60 BM_60_25
#define BM_61_25 0x3ffffffffe000000
#define BM_25_61 BM_61_25
#define BM_62_25 0x7ffffffffe000000
#define BM_25_62 BM_62_25
#define BM_63_25 0xfffffffffe000000
#define BM_25_63 BM_63_25
#define BM_26_26 0x0000000004000000
#define BM_27_26 0x000000000c000000
#define BM_26_27 BM_27_26
#define BM_28_26 0x000000001c000000
#define BM_26_28 BM_28_26
#define BM_29_26 0x000000003c000000
#define BM_26_29 BM_29_26
#define BM_30_26 0x000000007c000000
#define BM_26_30 BM_30_26
#define BM_31_26 0x00000000fc000000
#define BM_26_31 BM_31_26
#define BM_32_26 0x00000001fc000000
#define BM_26_32 BM_32_26
#define BM_33_26 0x00000003fc000000
#define BM_26_33 BM_33_26
#define BM_34_26 0x00000007fc000000
#define BM_26_34 BM_34_26
#define BM_35_26 0x0000000ffc000000
#define BM_26_35 BM_35_26
#define BM_36_26 0x0000001ffc000000
#define BM_26_36 BM_36_26
#define BM_37_26 0x0000003ffc000000
#define BM_26_37 BM_37_26
#define BM_38_26 0x0000007ffc000000
#define BM_26_38 BM_38_26
#define BM_39_26 0x000000fffc000000
#define BM_26_39 BM_39_26
#define BM_40_26 0x000001fffc000000
#define BM_26_40 BM_40_26
#define BM_41_26 0x000003fffc000000
#define BM_26_41 BM_41_26
#define BM_42_26 0x000007fffc000000
#define BM_26_42 BM_42_26
#define BM_43_26 0x00000ffffc000000
#define BM_26_43 BM_43_26
#define BM_44_26 0x00001ffffc000000
#define BM_26_44 BM_44_26
#define BM_45_26 0x00003ffffc000000
#define BM_26_45 BM_45_26
#define BM_46_26 0x00007ffffc000000
#define BM_26_46 BM_46_26
#define BM_47_26 0x0000fffffc000000
#define BM_26_47 BM_47_26
#define BM_48_26 0x0001fffffc000000
#define BM_26_48 BM_48_26
#define BM_49_26 0x0003fffffc000000
#define BM_26_49 BM_49_26
#define BM_50_26 0x0007fffffc000000
#define BM_26_50 BM_50_26
#define BM_51_26 0x000ffffffc000000
#define BM_26_51 BM_51_26
#define BM_52_26 0x001ffffffc000000
#define BM_26_52 BM_52_26
#define BM_53_26 0x003ffffffc000000
#define BM_26_53 BM_53_26
#define BM_54_26 0x007ffffffc000000
#define BM_26_54 BM_54_26
#define BM_55_26 0x00fffffffc000000
#define BM_26_55 BM_55_26
#define BM_56_26 0x01fffffffc000000
#define BM_26_56 BM_56_26
#define BM_57_26 0x03fffffffc000000
#define BM_26_57 BM_57_26
#define BM_58_26 0x07fffffffc000000
#define BM_26_58 BM_58_26
#define BM_59_26 0x0ffffffffc000000
#define BM_26_59 BM_59_26
#define BM_60_26 0x1ffffffffc000000
#define BM_26_60 BM_60_26
#define BM_61_26 0x3ffffffffc000000
#define BM_26_61 BM_61_26
#define BM_62_26 0x7ffffffffc000000
#define BM_26_62 BM_62_26
#define BM_63_26 0xfffffffffc000000
#define BM_26_63 BM_63_26
#define BM_27_27 0x0000000008000000
#define BM_28_27 0x0000000018000000
#define BM_27_28 BM_28_27
#define BM_29_27 0x0000000038000000
#define BM_27_29 BM_29_27
#define BM_30_27 0x0000000078000000
#define BM_27_30 BM_30_27
#define BM_31_27 0x00000000f8000000
#define BM_27_31 BM_31_27
#define BM_32_27 0x00000001f8000000
#define BM_27_32 BM_32_27
#define BM_33_27 0x00000003f8000000
#define BM_27_33 BM_33_27
#define BM_34_27 0x00000007f8000000
#define BM_27_34 BM_34_27
#define BM_35_27 0x0000000ff8000000
#define BM_27_35 BM_35_27
#define BM_36_27 0x0000001ff8000000
#define BM_27_36 BM_36_27
#define BM_37_27 0x0000003ff8000000
#define BM_27_37 BM_37_27
#define BM_38_27 0x0000007ff8000000
#define BM_27_38 BM_38_27
#define BM_39_27 0x000000fff8000000
#define BM_27_39 BM_39_27
#define BM_40_27 0x000001fff8000000
#define BM_27_40 BM_40_27
#define BM_41_27 0x000003fff8000000
#define BM_27_41 BM_41_27
#define BM_42_27 0x000007fff8000000
#define BM_27_42 BM_42_27
#define BM_43_27 0x00000ffff8000000
#define BM_27_43 BM_43_27
#define BM_44_27 0x00001ffff8000000
#define BM_27_44 BM_44_27
#define BM_45_27 0x00003ffff8000000
#define BM_27_45 BM_45_27
#define BM_46_27 0x00007ffff8000000
#define BM_27_46 BM_46_27
#define BM_47_27 0x0000fffff8000000
#define BM_27_47 BM_47_27
#define BM_48_27 0x0001fffff8000000
#define BM_27_48 BM_48_27
#define BM_49_27 0x0003fffff8000000
#define BM_27_49 BM_49_27
#define BM_50_27 0x0007fffff8000000
#define BM_27_50 BM_50_27
#define BM_51_27 0x000ffffff8000000
#define BM_27_51 BM_51_27
#define BM_52_27 0x001ffffff8000000
#define BM_27_52 BM_52_27
#define BM_53_27 0x003ffffff8000000
#define BM_27_53 BM_53_27
#define BM_54_27 0x007ffffff8000000
#define BM_27_54 BM_54_27
#define BM_55_27 0x00fffffff8000000
#define BM_27_55 BM_55_27
#define BM_56_27 0x01fffffff8000000
#define BM_27_56 BM_56_27
#define BM_57_27 0x03fffffff8000000
#define BM_27_57 BM_57_27
#define BM_58_27 0x07fffffff8000000
#define BM_27_58 BM_58_27
#define BM_59_27 0x0ffffffff8000000
#define BM_27_59 BM_59_27
#define BM_60_27 0x1ffffffff8000000
#define BM_27_60 BM_60_27
#define BM_61_27 0x3ffffffff8000000
#define BM_27_61 BM_61_27
#define BM_62_27 0x7ffffffff8000000
#define BM_27_62 BM_62_27
#define BM_63_27 0xfffffffff8000000
#define BM_27_63 BM_63_27
#define BM_28_28 0x0000000010000000
#define BM_29_28 0x0000000030000000
#define BM_28_29 BM_29_28
#define BM_30_28 0x0000000070000000
#define BM_28_30 BM_30_28
#define BM_31_28 0x00000000f0000000
#define BM_28_31 BM_31_28
#define BM_32_28 0x00000001f0000000
#define BM_28_32 BM_32_28
#define BM_33_28 0x00000003f0000000
#define BM_28_33 BM_33_28
#define BM_34_28 0x00000007f0000000
#define BM_28_34 BM_34_28
#define BM_35_28 0x0000000ff0000000
#define BM_28_35 BM_35_28
#define BM_36_28 0x0000001ff0000000
#define BM_28_36 BM_36_28
#define BM_37_28 0x0000003ff0000000
#define BM_28_37 BM_37_28
#define BM_38_28 0x0000007ff0000000
#define BM_28_38 BM_38_28
#define BM_39_28 0x000000fff0000000
#define BM_28_39 BM_39_28
#define BM_40_28 0x000001fff0000000
#define BM_28_40 BM_40_28
#define BM_41_28 0x000003fff0000000
#define BM_28_41 BM_41_28
#define BM_42_28 0x000007fff0000000
#define BM_28_42 BM_42_28
#define BM_43_28 0x00000ffff0000000
#define BM_28_43 BM_43_28
#define BM_44_28 0x00001ffff0000000
#define BM_28_44 BM_44_28
#define BM_45_28 0x00003ffff0000000
#define BM_28_45 BM_45_28
#define BM_46_28 0x00007ffff0000000
#define BM_28_46 BM_46_28
#define BM_47_28 0x0000fffff0000000
#define BM_28_47 BM_47_28
#define BM_48_28 0x0001fffff0000000
#define BM_28_48 BM_48_28
#define BM_49_28 0x0003fffff0000000
#define BM_28_49 BM_49_28
#define BM_50_28 0x0007fffff0000000
#define BM_28_50 BM_50_28
#define BM_51_28 0x000ffffff0000000
#define BM_28_51 BM_51_28
#define BM_52_28 0x001ffffff0000000
#define BM_28_52 BM_52_28
#define BM_53_28 0x003ffffff0000000
#define BM_28_53 BM_53_28
#define BM_54_28 0x007ffffff0000000
#define BM_28_54 BM_54_28
#define BM_55_28 0x00fffffff0000000
#define BM_28_55 BM_55_28
#define BM_56_28 0x01fffffff0000000
#define BM_28_56 BM_56_28
#define BM_57_28 0x03fffffff0000000
#define BM_28_57 BM_57_28
#define BM_58_28 0x07fffffff0000000
#define BM_28_58 BM_58_28
#define BM_59_28 0x0ffffffff0000000
#define BM_28_59 BM_59_28
#define BM_60_28 0x1ffffffff0000000
#define BM_28_60 BM_60_28
#define BM_61_28 0x3ffffffff0000000
#define BM_28_61 BM_61_28
#define BM_62_28 0x7ffffffff0000000
#define BM_28_62 BM_62_28
#define BM_63_28 0xfffffffff0000000
#define BM_28_63 BM_63_28
#define BM_29_29 0x0000000020000000
#define BM_30_29 0x0000000060000000
#define BM_29_30 BM_30_29
#define BM_31_29 0x00000000e0000000
#define BM_29_31 BM_31_29
#define BM_32_29 0x00000001e0000000
#define BM_29_32 BM_32_29
#define BM_33_29 0x00000003e0000000
#define BM_29_33 BM_33_29
#define BM_34_29 0x00000007e0000000
#define BM_29_34 BM_34_29
#define BM_35_29 0x0000000fe0000000
#define BM_29_35 BM_35_29
#define BM_36_29 0x0000001fe0000000
#define BM_29_36 BM_36_29
#define BM_37_29 0x0000003fe0000000
#define BM_29_37 BM_37_29
#define BM_38_29 0x0000007fe0000000
#define BM_29_38 BM_38_29
#define BM_39_29 0x000000ffe0000000
#define BM_29_39 BM_39_29
#define BM_40_29 0x000001ffe0000000
#define BM_29_40 BM_40_29
#define BM_41_29 0x000003ffe0000000
#define BM_29_41 BM_41_29
#define BM_42_29 0x000007ffe0000000
#define BM_29_42 BM_42_29
#define BM_43_29 0x00000fffe0000000
#define BM_29_43 BM_43_29
#define BM_44_29 0x00001fffe0000000
#define BM_29_44 BM_44_29
#define BM_45_29 0x00003fffe0000000
#define BM_29_45 BM_45_29
#define BM_46_29 0x00007fffe0000000
#define BM_29_46 BM_46_29
#define BM_47_29 0x0000ffffe0000000
#define BM_29_47 BM_47_29
#define BM_48_29 0x0001ffffe0000000
#define BM_29_48 BM_48_29
#define BM_49_29 0x0003ffffe0000000
#define BM_29_49 BM_49_29
#define BM_50_29 0x0007ffffe0000000
#define BM_29_50 BM_50_29
#define BM_51_29 0x000fffffe0000000
#define BM_29_51 BM_51_29
#define BM_52_29 0x001fffffe0000000
#define BM_29_52 BM_52_29
#define BM_53_29 0x003fffffe0000000
#define BM_29_53 BM_53_29
#define BM_54_29 0x007fffffe0000000
#define BM_29_54 BM_54_29
#define BM_55_29 0x00ffffffe0000000
#define BM_29_55 BM_55_29
#define BM_56_29 0x01ffffffe0000000
#define BM_29_56 BM_56_29
#define BM_57_29 0x03ffffffe0000000
#define BM_29_57 BM_57_29
#define BM_58_29 0x07ffffffe0000000
#define BM_29_58 BM_58_29
#define BM_59_29 0x0fffffffe0000000
#define BM_29_59 BM_59_29
#define BM_60_29 0x1fffffffe0000000
#define BM_29_60 BM_60_29
#define BM_61_29 0x3fffffffe0000000
#define BM_29_61 BM_61_29
#define BM_62_29 0x7fffffffe0000000
#define BM_29_62 BM_62_29
#define BM_63_29 0xffffffffe0000000
#define BM_29_63 BM_63_29
#define BM_30_30 0x0000000040000000
#define BM_31_30 0x00000000c0000000
#define BM_30_31 BM_31_30
#define BM_32_30 0x00000001c0000000
#define BM_30_32 BM_32_30
#define BM_33_30 0x00000003c0000000
#define BM_30_33 BM_33_30
#define BM_34_30 0x00000007c0000000
#define BM_30_34 BM_34_30
#define BM_35_30 0x0000000fc0000000
#define BM_30_35 BM_35_30
#define BM_36_30 0x0000001fc0000000
#define BM_30_36 BM_36_30
#define BM_37_30 0x0000003fc0000000
#define BM_30_37 BM_37_30
#define BM_38_30 0x0000007fc0000000
#define BM_30_38 BM_38_30
#define BM_39_30 0x000000ffc0000000
#define BM_30_39 BM_39_30
#define BM_40_30 0x000001ffc0000000
#define BM_30_40 BM_40_30
#define BM_41_30 0x000003ffc0000000
#define BM_30_41 BM_41_30
#define BM_42_30 0x000007ffc0000000
#define BM_30_42 BM_42_30
#define BM_43_30 0x00000fffc0000000
#define BM_30_43 BM_43_30
#define BM_44_30 0x00001fffc0000000
#define BM_30_44 BM_44_30
#define BM_45_30 0x00003fffc0000000
#define BM_30_45 BM_45_30
#define BM_46_30 0x00007fffc0000000
#define BM_30_46 BM_46_30
#define BM_47_30 0x0000ffffc0000000
#define BM_30_47 BM_47_30
#define BM_48_30 0x0001ffffc0000000
#define BM_30_48 BM_48_30
#define BM_49_30 0x0003ffffc0000000
#define BM_30_49 BM_49_30
#define BM_50_30 0x0007ffffc0000000
#define BM_30_50 BM_50_30
#define BM_51_30 0x000fffffc0000000
#define BM_30_51 BM_51_30
#define BM_52_30 0x001fffffc0000000
#define BM_30_52 BM_52_30
#define BM_53_30 0x003fffffc0000000
#define BM_30_53 BM_53_30
#define BM_54_30 0x007fffffc0000000
#define BM_30_54 BM_54_30
#define BM_55_30 0x00ffffffc0000000
#define BM_30_55 BM_55_30
#define BM_56_30 0x01ffffffc0000000
#define BM_30_56 BM_56_30
#define BM_57_30 0x03ffffffc0000000
#define BM_30_57 BM_57_30
#define BM_58_30 0x07ffffffc0000000
#define BM_30_58 BM_58_30
#define BM_59_30 0x0fffffffc0000000
#define BM_30_59 BM_59_30
#define BM_60_30 0x1fffffffc0000000
#define BM_30_60 BM_60_30
#define BM_61_30 0x3fffffffc0000000
#define BM_30_61 BM_61_30
#define BM_62_30 0x7fffffffc0000000
#define BM_30_62 BM_62_30
#define BM_63_30 0xffffffffc0000000
#define BM_30_63 BM_63_30
#define BM_31_31 0x0000000080000000
#define BM_32_31 0x0000000180000000
#define BM_31_32 BM_32_31
#define BM_33_31 0x0000000380000000
#define BM_31_33 BM_33_31
#define BM_34_31 0x0000000780000000
#define BM_31_34 BM_34_31
#define BM_35_31 0x0000000f80000000
#define BM_31_35 BM_35_31
#define BM_36_31 0x0000001f80000000
#define BM_31_36 BM_36_31
#define BM_37_31 0x0000003f80000000
#define BM_31_37 BM_37_31
#define BM_38_31 0x0000007f80000000
#define BM_31_38 BM_38_31
#define BM_39_31 0x000000ff80000000
#define BM_31_39 BM_39_31
#define BM_40_31 0x000001ff80000000
#define BM_31_40 BM_40_31
#define BM_41_31 0x000003ff80000000
#define BM_31_41 BM_41_31
#define BM_42_31 0x000007ff80000000
#define BM_31_42 BM_42_31
#define BM_43_31 0x00000fff80000000
#define BM_31_43 BM_43_31
#define BM_44_31 0x00001fff80000000
#define BM_31_44 BM_44_31
#define BM_45_31 0x00003fff80000000
#define BM_31_45 BM_45_31
#define BM_46_31 0x00007fff80000000
#define BM_31_46 BM_46_31
#define BM_47_31 0x0000ffff80000000
#define BM_31_47 BM_47_31
#define BM_48_31 0x0001ffff80000000
#define BM_31_48 BM_48_31
#define BM_49_31 0x0003ffff80000000
#define BM_31_49 BM_49_31
#define BM_50_31 0x0007ffff80000000
#define BM_31_50 BM_50_31
#define BM_51_31 0x000fffff80000000
#define BM_31_51 BM_51_31
#define BM_52_31 0x001fffff80000000
#define BM_31_52 BM_52_31
#define BM_53_31 0x003fffff80000000
#define BM_31_53 BM_53_31
#define BM_54_31 0x007fffff80000000
#define BM_31_54 BM_54_31
#define BM_55_31 0x00ffffff80000000
#define BM_31_55 BM_55_31
#define BM_56_31 0x01ffffff80000000
#define BM_31_56 BM_56_31
#define BM_57_31 0x03ffffff80000000
#define BM_31_57 BM_57_31
#define BM_58_31 0x07ffffff80000000
#define BM_31_58 BM_58_31
#define BM_59_31 0x0fffffff80000000
#define BM_31_59 BM_59_31
#define BM_60_31 0x1fffffff80000000
#define BM_31_60 BM_60_31
#define BM_61_31 0x3fffffff80000000
#define BM_31_61 BM_61_31
#define BM_62_31 0x7fffffff80000000
#define BM_31_62 BM_62_31
#define BM_63_31 0xffffffff80000000
#define BM_31_63 BM_63_31
#define BM_32_32 0x0000000100000000
#define BM_33_32 0x0000000300000000
#define BM_32_33 BM_33_32
#define BM_34_32 0x0000000700000000
#define BM_32_34 BM_34_32
#define BM_35_32 0x0000000f00000000
#define BM_32_35 BM_35_32
#define BM_36_32 0x0000001f00000000
#define BM_32_36 BM_36_32
#define BM_37_32 0x0000003f00000000
#define BM_32_37 BM_37_32
#define BM_38_32 0x0000007f00000000
#define BM_32_38 BM_38_32
#define BM_39_32 0x000000ff00000000
#define BM_32_39 BM_39_32
#define BM_40_32 0x000001ff00000000
#define BM_32_40 BM_40_32
#define BM_41_32 0x000003ff00000000
#define BM_32_41 BM_41_32
#define BM_42_32 0x000007ff00000000
#define BM_32_42 BM_42_32
#define BM_43_32 0x00000fff00000000
#define BM_32_43 BM_43_32
#define BM_44_32 0x00001fff00000000
#define BM_32_44 BM_44_32
#define BM_45_32 0x00003fff00000000
#define BM_32_45 BM_45_32
#define BM_46_32 0x00007fff00000000
#define BM_32_46 BM_46_32
#define BM_47_32 0x0000ffff00000000
#define BM_32_47 BM_47_32
#define BM_48_32 0x0001ffff00000000
#define BM_32_48 BM_48_32
#define BM_49_32 0x0003ffff00000000
#define BM_32_49 BM_49_32
#define BM_50_32 0x0007ffff00000000
#define BM_32_50 BM_50_32
#define BM_51_32 0x000fffff00000000
#define BM_32_51 BM_51_32
#define BM_52_32 0x001fffff00000000
#define BM_32_52 BM_52_32
#define BM_53_32 0x003fffff00000000
#define BM_32_53 BM_53_32
#define BM_54_32 0x007fffff00000000
#define BM_32_54 BM_54_32
#define BM_55_32 0x00ffffff00000000
#define BM_32_55 BM_55_32
#define BM_56_32 0x01ffffff00000000
#define BM_32_56 BM_56_32
#define BM_57_32 0x03ffffff00000000
#define BM_32_57 BM_57_32
#define BM_58_32 0x07ffffff00000000
#define BM_32_58 BM_58_32
#define BM_59_32 0x0fffffff00000000
#define BM_32_59 BM_59_32
#define BM_60_32 0x1fffffff00000000
#define BM_32_60 BM_60_32
#define BM_61_32 0x3fffffff00000000
#define BM_32_61 BM_61_32
#define BM_62_32 0x7fffffff00000000
#define BM_32_62 BM_62_32
#define BM_63_32 0xffffffff00000000
#define BM_32_63 BM_63_32
#define BM_33_33 0x0000000200000000
#define BM_34_33 0x0000000600000000
#define BM_33_34 BM_34_33
#define BM_35_33 0x0000000e00000000
#define BM_33_35 BM_35_33
#define BM_36_33 0x0000001e00000000
#define BM_33_36 BM_36_33
#define BM_37_33 0x0000003e00000000
#define BM_33_37 BM_37_33
#define BM_38_33 0x0000007e00000000
#define BM_33_38 BM_38_33
#define BM_39_33 0x000000fe00000000
#define BM_33_39 BM_39_33
#define BM_40_33 0x000001fe00000000
#define BM_33_40 BM_40_33
#define BM_41_33 0x000003fe00000000
#define BM_33_41 BM_41_33
#define BM_42_33 0x000007fe00000000
#define BM_33_42 BM_42_33
#define BM_43_33 0x00000ffe00000000
#define BM_33_43 BM_43_33
#define BM_44_33 0x00001ffe00000000
#define BM_33_44 BM_44_33
#define BM_45_33 0x00003ffe00000000
#define BM_33_45 BM_45_33
#define BM_46_33 0x00007ffe00000000
#define BM_33_46 BM_46_33
#define BM_47_33 0x0000fffe00000000
#define BM_33_47 BM_47_33
#define BM_48_33 0x0001fffe00000000
#define BM_33_48 BM_48_33
#define BM_49_33 0x0003fffe00000000
#define BM_33_49 BM_49_33
#define BM_50_33 0x0007fffe00000000
#define BM_33_50 BM_50_33
#define BM_51_33 0x000ffffe00000000
#define BM_33_51 BM_51_33
#define BM_52_33 0x001ffffe00000000
#define BM_33_52 BM_52_33
#define BM_53_33 0x003ffffe00000000
#define BM_33_53 BM_53_33
#define BM_54_33 0x007ffffe00000000
#define BM_33_54 BM_54_33
#define BM_55_33 0x00fffffe00000000
#define BM_33_55 BM_55_33
#define BM_56_33 0x01fffffe00000000
#define BM_33_56 BM_56_33
#define BM_57_33 0x03fffffe00000000
#define BM_33_57 BM_57_33
#define BM_58_33 0x07fffffe00000000
#define BM_33_58 BM_58_33
#define BM_59_33 0x0ffffffe00000000
#define BM_33_59 BM_59_33
#define BM_60_33 0x1ffffffe00000000
#define BM_33_60 BM_60_33
#define BM_61_33 0x3ffffffe00000000
#define BM_33_61 BM_61_33
#define BM_62_33 0x7ffffffe00000000
#define BM_33_62 BM_62_33
#define BM_63_33 0xfffffffe00000000
#define BM_33_63 BM_63_33
#define BM_34_34 0x0000000400000000
#define BM_35_34 0x0000000c00000000
#define BM_34_35 BM_35_34
#define BM_36_34 0x0000001c00000000
#define BM_34_36 BM_36_34
#define BM_37_34 0x0000003c00000000
#define BM_34_37 BM_37_34
#define BM_38_34 0x0000007c00000000
#define BM_34_38 BM_38_34
#define BM_39_34 0x000000fc00000000
#define BM_34_39 BM_39_34
#define BM_40_34 0x000001fc00000000
#define BM_34_40 BM_40_34
#define BM_41_34 0x000003fc00000000
#define BM_34_41 BM_41_34
#define BM_42_34 0x000007fc00000000
#define BM_34_42 BM_42_34
#define BM_43_34 0x00000ffc00000000
#define BM_34_43 BM_43_34
#define BM_44_34 0x00001ffc00000000
#define BM_34_44 BM_44_34
#define BM_45_34 0x00003ffc00000000
#define BM_34_45 BM_45_34
#define BM_46_34 0x00007ffc00000000
#define BM_34_46 BM_46_34
#define BM_47_34 0x0000fffc00000000
#define BM_34_47 BM_47_34
#define BM_48_34 0x0001fffc00000000
#define BM_34_48 BM_48_34
#define BM_49_34 0x0003fffc00000000
#define BM_34_49 BM_49_34
#define BM_50_34 0x0007fffc00000000
#define BM_34_50 BM_50_34
#define BM_51_34 0x000ffffc00000000
#define BM_34_51 BM_51_34
#define BM_52_34 0x001ffffc00000000
#define BM_34_52 BM_52_34
#define BM_53_34 0x003ffffc00000000
#define BM_34_53 BM_53_34
#define BM_54_34 0x007ffffc00000000
#define BM_34_54 BM_54_34
#define BM_55_34 0x00fffffc00000000
#define BM_34_55 BM_55_34
#define BM_56_34 0x01fffffc00000000
#define BM_34_56 BM_56_34
#define BM_57_34 0x03fffffc00000000
#define BM_34_57 BM_57_34
#define BM_58_34 0x07fffffc00000000
#define BM_34_58 BM_58_34
#define BM_59_34 0x0ffffffc00000000
#define BM_34_59 BM_59_34
#define BM_60_34 0x1ffffffc00000000
#define BM_34_60 BM_60_34
#define BM_61_34 0x3ffffffc00000000
#define BM_34_61 BM_61_34
#define BM_62_34 0x7ffffffc00000000
#define BM_34_62 BM_62_34
#define BM_63_34 0xfffffffc00000000
#define BM_34_63 BM_63_34
#define BM_35_35 0x0000000800000000
#define BM_36_35 0x0000001800000000
#define BM_35_36 BM_36_35
#define BM_37_35 0x0000003800000000
#define BM_35_37 BM_37_35
#define BM_38_35 0x0000007800000000
#define BM_35_38 BM_38_35
#define BM_39_35 0x000000f800000000
#define BM_35_39 BM_39_35
#define BM_40_35 0x000001f800000000
#define BM_35_40 BM_40_35
#define BM_41_35 0x000003f800000000
#define BM_35_41 BM_41_35
#define BM_42_35 0x000007f800000000
#define BM_35_42 BM_42_35
#define BM_43_35 0x00000ff800000000
#define BM_35_43 BM_43_35
#define BM_44_35 0x00001ff800000000
#define BM_35_44 BM_44_35
#define BM_45_35 0x00003ff800000000
#define BM_35_45 BM_45_35
#define BM_46_35 0x00007ff800000000
#define BM_35_46 BM_46_35
#define BM_47_35 0x0000fff800000000
#define BM_35_47 BM_47_35
#define BM_48_35 0x0001fff800000000
#define BM_35_48 BM_48_35
#define BM_49_35 0x0003fff800000000
#define BM_35_49 BM_49_35
#define BM_50_35 0x0007fff800000000
#define BM_35_50 BM_50_35
#define BM_51_35 0x000ffff800000000
#define BM_35_51 BM_51_35
#define BM_52_35 0x001ffff800000000
#define BM_35_52 BM_52_35
#define BM_53_35 0x003ffff800000000
#define BM_35_53 BM_53_35
#define BM_54_35 0x007ffff800000000
#define BM_35_54 BM_54_35
#define BM_55_35 0x00fffff800000000
#define BM_35_55 BM_55_35
#define BM_56_35 0x01fffff800000000
#define BM_35_56 BM_56_35
#define BM_57_35 0x03fffff800000000
#define BM_35_57 BM_57_35
#define BM_58_35 0x07fffff800000000
#define BM_35_58 BM_58_35
#define BM_59_35 0x0ffffff800000000
#define BM_35_59 BM_59_35
#define BM_60_35 0x1ffffff800000000
#define BM_35_60 BM_60_35
#define BM_61_35 0x3ffffff800000000
#define BM_35_61 BM_61_35
#define BM_62_35 0x7ffffff800000000
#define BM_35_62 BM_62_35
#define BM_63_35 0xfffffff800000000
#define BM_35_63 BM_63_35
#define BM_36_36 0x0000001000000000
#define BM_37_36 0x0000003000000000
#define BM_36_37 BM_37_36
#define BM_38_36 0x0000007000000000
#define BM_36_38 BM_38_36
#define BM_39_36 0x000000f000000000
#define BM_36_39 BM_39_36
#define BM_40_36 0x000001f000000000
#define BM_36_40 BM_40_36
#define BM_41_36 0x000003f000000000
#define BM_36_41 BM_41_36
#define BM_42_36 0x000007f000000000
#define BM_36_42 BM_42_36
#define BM_43_36 0x00000ff000000000
#define BM_36_43 BM_43_36
#define BM_44_36 0x00001ff000000000
#define BM_36_44 BM_44_36
#define BM_45_36 0x00003ff000000000
#define BM_36_45 BM_45_36
#define BM_46_36 0x00007ff000000000
#define BM_36_46 BM_46_36
#define BM_47_36 0x0000fff000000000
#define BM_36_47 BM_47_36
#define BM_48_36 0x0001fff000000000
#define BM_36_48 BM_48_36
#define BM_49_36 0x0003fff000000000
#define BM_36_49 BM_49_36
#define BM_50_36 0x0007fff000000000
#define BM_36_50 BM_50_36
#define BM_51_36 0x000ffff000000000
#define BM_36_51 BM_51_36
#define BM_52_36 0x001ffff000000000
#define BM_36_52 BM_52_36
#define BM_53_36 0x003ffff000000000
#define BM_36_53 BM_53_36
#define BM_54_36 0x007ffff000000000
#define BM_36_54 BM_54_36
#define BM_55_36 0x00fffff000000000
#define BM_36_55 BM_55_36
#define BM_56_36 0x01fffff000000000
#define BM_36_56 BM_56_36
#define BM_57_36 0x03fffff000000000
#define BM_36_57 BM_57_36
#define BM_58_36 0x07fffff000000000
#define BM_36_58 BM_58_36
#define BM_59_36 0x0ffffff000000000
#define BM_36_59 BM_59_36
#define BM_60_36 0x1ffffff000000000
#define BM_36_60 BM_60_36
#define BM_61_36 0x3ffffff000000000
#define BM_36_61 BM_61_36
#define BM_62_36 0x7ffffff000000000
#define BM_36_62 BM_62_36
#define BM_63_36 0xfffffff000000000
#define BM_36_63 BM_63_36
#define BM_37_37 0x0000002000000000
#define BM_38_37 0x0000006000000000
#define BM_37_38 BM_38_37
#define BM_39_37 0x000000e000000000
#define BM_37_39 BM_39_37
#define BM_40_37 0x000001e000000000
#define BM_37_40 BM_40_37
#define BM_41_37 0x000003e000000000
#define BM_37_41 BM_41_37
#define BM_42_37 0x000007e000000000
#define BM_37_42 BM_42_37
#define BM_43_37 0x00000fe000000000
#define BM_37_43 BM_43_37
#define BM_44_37 0x00001fe000000000
#define BM_37_44 BM_44_37
#define BM_45_37 0x00003fe000000000
#define BM_37_45 BM_45_37
#define BM_46_37 0x00007fe000000000
#define BM_37_46 BM_46_37
#define BM_47_37 0x0000ffe000000000
#define BM_37_47 BM_47_37
#define BM_48_37 0x0001ffe000000000
#define BM_37_48 BM_48_37
#define BM_49_37 0x0003ffe000000000
#define BM_37_49 BM_49_37
#define BM_50_37 0x0007ffe000000000
#define BM_37_50 BM_50_37
#define BM_51_37 0x000fffe000000000
#define BM_37_51 BM_51_37
#define BM_52_37 0x001fffe000000000
#define BM_37_52 BM_52_37
#define BM_53_37 0x003fffe000000000
#define BM_37_53 BM_53_37
#define BM_54_37 0x007fffe000000000
#define BM_37_54 BM_54_37
#define BM_55_37 0x00ffffe000000000
#define BM_37_55 BM_55_37
#define BM_56_37 0x01ffffe000000000
#define BM_37_56 BM_56_37
#define BM_57_37 0x03ffffe000000000
#define BM_37_57 BM_57_37
#define BM_58_37 0x07ffffe000000000
#define BM_37_58 BM_58_37
#define BM_59_37 0x0fffffe000000000
#define BM_37_59 BM_59_37
#define BM_60_37 0x1fffffe000000000
#define BM_37_60 BM_60_37
#define BM_61_37 0x3fffffe000000000
#define BM_37_61 BM_61_37
#define BM_62_37 0x7fffffe000000000
#define BM_37_62 BM_62_37
#define BM_63_37 0xffffffe000000000
#define BM_37_63 BM_63_37
#define BM_38_38 0x0000004000000000
#define BM_39_38 0x000000c000000000
#define BM_38_39 BM_39_38
#define BM_40_38 0x000001c000000000
#define BM_38_40 BM_40_38
#define BM_41_38 0x000003c000000000
#define BM_38_41 BM_41_38
#define BM_42_38 0x000007c000000000
#define BM_38_42 BM_42_38
#define BM_43_38 0x00000fc000000000
#define BM_38_43 BM_43_38
#define BM_44_38 0x00001fc000000000
#define BM_38_44 BM_44_38
#define BM_45_38 0x00003fc000000000
#define BM_38_45 BM_45_38
#define BM_46_38 0x00007fc000000000
#define BM_38_46 BM_46_38
#define BM_47_38 0x0000ffc000000000
#define BM_38_47 BM_47_38
#define BM_48_38 0x0001ffc000000000
#define BM_38_48 BM_48_38
#define BM_49_38 0x0003ffc000000000
#define BM_38_49 BM_49_38
#define BM_50_38 0x0007ffc000000000
#define BM_38_50 BM_50_38
#define BM_51_38 0x000fffc000000000
#define BM_38_51 BM_51_38
#define BM_52_38 0x001fffc000000000
#define BM_38_52 BM_52_38
#define BM_53_38 0x003fffc000000000
#define BM_38_53 BM_53_38
#define BM_54_38 0x007fffc000000000
#define BM_38_54 BM_54_38
#define BM_55_38 0x00ffffc000000000
#define BM_38_55 BM_55_38
#define BM_56_38 0x01ffffc000000000
#define BM_38_56 BM_56_38
#define BM_57_38 0x03ffffc000000000
#define BM_38_57 BM_57_38
#define BM_58_38 0x07ffffc000000000
#define BM_38_58 BM_58_38
#define BM_59_38 0x0fffffc000000000
#define BM_38_59 BM_59_38
#define BM_60_38 0x1fffffc000000000
#define BM_38_60 BM_60_38
#define BM_61_38 0x3fffffc000000000
#define BM_38_61 BM_61_38
#define BM_62_38 0x7fffffc000000000
#define BM_38_62 BM_62_38
#define BM_63_38 0xffffffc000000000
#define BM_38_63 BM_63_38
#define BM_39_39 0x0000008000000000
#define BM_40_39 0x0000018000000000
#define BM_39_40 BM_40_39
#define BM_41_39 0x0000038000000000
#define BM_39_41 BM_41_39
#define BM_42_39 0x0000078000000000
#define BM_39_42 BM_42_39
#define BM_43_39 0x00000f8000000000
#define BM_39_43 BM_43_39
#define BM_44_39 0x00001f8000000000
#define BM_39_44 BM_44_39
#define BM_45_39 0x00003f8000000000
#define BM_39_45 BM_45_39
#define BM_46_39 0x00007f8000000000
#define BM_39_46 BM_46_39
#define BM_47_39 0x0000ff8000000000
#define BM_39_47 BM_47_39
#define BM_48_39 0x0001ff8000000000
#define BM_39_48 BM_48_39
#define BM_49_39 0x0003ff8000000000
#define BM_39_49 BM_49_39
#define BM_50_39 0x0007ff8000000000
#define BM_39_50 BM_50_39
#define BM_51_39 0x000fff8000000000
#define BM_39_51 BM_51_39
#define BM_52_39 0x001fff8000000000
#define BM_39_52 BM_52_39
#define BM_53_39 0x003fff8000000000
#define BM_39_53 BM_53_39
#define BM_54_39 0x007fff8000000000
#define BM_39_54 BM_54_39
#define BM_55_39 0x00ffff8000000000
#define BM_39_55 BM_55_39
#define BM_56_39 0x01ffff8000000000
#define BM_39_56 BM_56_39
#define BM_57_39 0x03ffff8000000000
#define BM_39_57 BM_57_39
#define BM_58_39 0x07ffff8000000000
#define BM_39_58 BM_58_39
#define BM_59_39 0x0fffff8000000000
#define BM_39_59 BM_59_39
#define BM_60_39 0x1fffff8000000000
#define BM_39_60 BM_60_39
#define BM_61_39 0x3fffff8000000000
#define BM_39_61 BM_61_39
#define BM_62_39 0x7fffff8000000000
#define BM_39_62 BM_62_39
#define BM_63_39 0xffffff8000000000
#define BM_39_63 BM_63_39
#define BM_40_40 0x0000010000000000
#define BM_41_40 0x0000030000000000
#define BM_40_41 BM_41_40
#define BM_42_40 0x0000070000000000
#define BM_40_42 BM_42_40
#define BM_43_40 0x00000f0000000000
#define BM_40_43 BM_43_40
#define BM_44_40 0x00001f0000000000
#define BM_40_44 BM_44_40
#define BM_45_40 0x00003f0000000000
#define BM_40_45 BM_45_40
#define BM_46_40 0x00007f0000000000
#define BM_40_46 BM_46_40
#define BM_47_40 0x0000ff0000000000
#define BM_40_47 BM_47_40
#define BM_48_40 0x0001ff0000000000
#define BM_40_48 BM_48_40
#define BM_49_40 0x0003ff0000000000
#define BM_40_49 BM_49_40
#define BM_50_40 0x0007ff0000000000
#define BM_40_50 BM_50_40
#define BM_51_40 0x000fff0000000000
#define BM_40_51 BM_51_40
#define BM_52_40 0x001fff0000000000
#define BM_40_52 BM_52_40
#define BM_53_40 0x003fff0000000000
#define BM_40_53 BM_53_40
#define BM_54_40 0x007fff0000000000
#define BM_40_54 BM_54_40
#define BM_55_40 0x00ffff0000000000
#define BM_40_55 BM_55_40
#define BM_56_40 0x01ffff0000000000
#define BM_40_56 BM_56_40
#define BM_57_40 0x03ffff0000000000
#define BM_40_57 BM_57_40
#define BM_58_40 0x07ffff0000000000
#define BM_40_58 BM_58_40
#define BM_59_40 0x0fffff0000000000
#define BM_40_59 BM_59_40
#define BM_60_40 0x1fffff0000000000
#define BM_40_60 BM_60_40
#define BM_61_40 0x3fffff0000000000
#define BM_40_61 BM_61_40
#define BM_62_40 0x7fffff0000000000
#define BM_40_62 BM_62_40
#define BM_63_40 0xffffff0000000000
#define BM_40_63 BM_63_40
#define BM_41_41 0x0000020000000000
#define BM_42_41 0x0000060000000000
#define BM_41_42 BM_42_41
#define BM_43_41 0x00000e0000000000
#define BM_41_43 BM_43_41
#define BM_44_41 0x00001e0000000000
#define BM_41_44 BM_44_41
#define BM_45_41 0x00003e0000000000
#define BM_41_45 BM_45_41
#define BM_46_41 0x00007e0000000000
#define BM_41_46 BM_46_41
#define BM_47_41 0x0000fe0000000000
#define BM_41_47 BM_47_41
#define BM_48_41 0x0001fe0000000000
#define BM_41_48 BM_48_41
#define BM_49_41 0x0003fe0000000000
#define BM_41_49 BM_49_41
#define BM_50_41 0x0007fe0000000000
#define BM_41_50 BM_50_41
#define BM_51_41 0x000ffe0000000000
#define BM_41_51 BM_51_41
#define BM_52_41 0x001ffe0000000000
#define BM_41_52 BM_52_41
#define BM_53_41 0x003ffe0000000000
#define BM_41_53 BM_53_41
#define BM_54_41 0x007ffe0000000000
#define BM_41_54 BM_54_41
#define BM_55_41 0x00fffe0000000000
#define BM_41_55 BM_55_41
#define BM_56_41 0x01fffe0000000000
#define BM_41_56 BM_56_41
#define BM_57_41 0x03fffe0000000000
#define BM_41_57 BM_57_41
#define BM_58_41 0x07fffe0000000000
#define BM_41_58 BM_58_41
#define BM_59_41 0x0ffffe0000000000
#define BM_41_59 BM_59_41
#define BM_60_41 0x1ffffe0000000000
#define BM_41_60 BM_60_41
#define BM_61_41 0x3ffffe0000000000
#define BM_41_61 BM_61_41
#define BM_62_41 0x7ffffe0000000000
#define BM_41_62 BM_62_41
#define BM_63_41 0xfffffe0000000000
#define BM_41_63 BM_63_41
#define BM_42_42 0x0000040000000000
#define BM_43_42 0x00000c0000000000
#define BM_42_43 BM_43_42
#define BM_44_42 0x00001c0000000000
#define BM_42_44 BM_44_42
#define BM_45_42 0x00003c0000000000
#define BM_42_45 BM_45_42
#define BM_46_42 0x00007c0000000000
#define BM_42_46 BM_46_42
#define BM_47_42 0x0000fc0000000000
#define BM_42_47 BM_47_42
#define BM_48_42 0x0001fc0000000000
#define BM_42_48 BM_48_42
#define BM_49_42 0x0003fc0000000000
#define BM_42_49 BM_49_42
#define BM_50_42 0x0007fc0000000000
#define BM_42_50 BM_50_42
#define BM_51_42 0x000ffc0000000000
#define BM_42_51 BM_51_42
#define BM_52_42 0x001ffc0000000000
#define BM_42_52 BM_52_42
#define BM_53_42 0x003ffc0000000000
#define BM_42_53 BM_53_42
#define BM_54_42 0x007ffc0000000000
#define BM_42_54 BM_54_42
#define BM_55_42 0x00fffc0000000000
#define BM_42_55 BM_55_42
#define BM_56_42 0x01fffc0000000000
#define BM_42_56 BM_56_42
#define BM_57_42 0x03fffc0000000000
#define BM_42_57 BM_57_42
#define BM_58_42 0x07fffc0000000000
#define BM_42_58 BM_58_42
#define BM_59_42 0x0ffffc0000000000
#define BM_42_59 BM_59_42
#define BM_60_42 0x1ffffc0000000000
#define BM_42_60 BM_60_42
#define BM_61_42 0x3ffffc0000000000
#define BM_42_61 BM_61_42
#define BM_62_42 0x7ffffc0000000000
#define BM_42_62 BM_62_42
#define BM_63_42 0xfffffc0000000000
#define BM_42_63 BM_63_42
#define BM_43_43 0x0000080000000000
#define BM_44_43 0x0000180000000000
#define BM_43_44 BM_44_43
#define BM_45_43 0x0000380000000000
#define BM_43_45 BM_45_43
#define BM_46_43 0x0000780000000000
#define BM_43_46 BM_46_43
#define BM_47_43 0x0000f80000000000
#define BM_43_47 BM_47_43
#define BM_48_43 0x0001f80000000000
#define BM_43_48 BM_48_43
#define BM_49_43 0x0003f80000000000
#define BM_43_49 BM_49_43
#define BM_50_43 0x0007f80000000000
#define BM_43_50 BM_50_43
#define BM_51_43 0x000ff80000000000
#define BM_43_51 BM_51_43
#define BM_52_43 0x001ff80000000000
#define BM_43_52 BM_52_43
#define BM_53_43 0x003ff80000000000
#define BM_43_53 BM_53_43
#define BM_54_43 0x007ff80000000000
#define BM_43_54 BM_54_43
#define BM_55_43 0x00fff80000000000
#define BM_43_55 BM_55_43
#define BM_56_43 0x01fff80000000000
#define BM_43_56 BM_56_43
#define BM_57_43 0x03fff80000000000
#define BM_43_57 BM_57_43
#define BM_58_43 0x07fff80000000000
#define BM_43_58 BM_58_43
#define BM_59_43 0x0ffff80000000000
#define BM_43_59 BM_59_43
#define BM_60_43 0x1ffff80000000000
#define BM_43_60 BM_60_43
#define BM_61_43 0x3ffff80000000000
#define BM_43_61 BM_61_43
#define BM_62_43 0x7ffff80000000000
#define BM_43_62 BM_62_43
#define BM_63_43 0xfffff80000000000
#define BM_43_63 BM_63_43
#define BM_44_44 0x0000100000000000
#define BM_45_44 0x0000300000000000
#define BM_44_45 BM_45_44
#define BM_46_44 0x0000700000000000
#define BM_44_46 BM_46_44
#define BM_47_44 0x0000f00000000000
#define BM_44_47 BM_47_44
#define BM_48_44 0x0001f00000000000
#define BM_44_48 BM_48_44
#define BM_49_44 0x0003f00000000000
#define BM_44_49 BM_49_44
#define BM_50_44 0x0007f00000000000
#define BM_44_50 BM_50_44
#define BM_51_44 0x000ff00000000000
#define BM_44_51 BM_51_44
#define BM_52_44 0x001ff00000000000
#define BM_44_52 BM_52_44
#define BM_53_44 0x003ff00000000000
#define BM_44_53 BM_53_44
#define BM_54_44 0x007ff00000000000
#define BM_44_54 BM_54_44
#define BM_55_44 0x00fff00000000000
#define BM_44_55 BM_55_44
#define BM_56_44 0x01fff00000000000
#define BM_44_56 BM_56_44
#define BM_57_44 0x03fff00000000000
#define BM_44_57 BM_57_44
#define BM_58_44 0x07fff00000000000
#define BM_44_58 BM_58_44
#define BM_59_44 0x0ffff00000000000
#define BM_44_59 BM_59_44
#define BM_60_44 0x1ffff00000000000
#define BM_44_60 BM_60_44
#define BM_61_44 0x3ffff00000000000
#define BM_44_61 BM_61_44
#define BM_62_44 0x7ffff00000000000
#define BM_44_62 BM_62_44
#define BM_63_44 0xfffff00000000000
#define BM_44_63 BM_63_44
#define BM_45_45 0x0000200000000000
#define BM_46_45 0x0000600000000000
#define BM_45_46 BM_46_45
#define BM_47_45 0x0000e00000000000
#define BM_45_47 BM_47_45
#define BM_48_45 0x0001e00000000000
#define BM_45_48 BM_48_45
#define BM_49_45 0x0003e00000000000
#define BM_45_49 BM_49_45
#define BM_50_45 0x0007e00000000000
#define BM_45_50 BM_50_45
#define BM_51_45 0x000fe00000000000
#define BM_45_51 BM_51_45
#define BM_52_45 0x001fe00000000000
#define BM_45_52 BM_52_45
#define BM_53_45 0x003fe00000000000
#define BM_45_53 BM_53_45
#define BM_54_45 0x007fe00000000000
#define BM_45_54 BM_54_45
#define BM_55_45 0x00ffe00000000000
#define BM_45_55 BM_55_45
#define BM_56_45 0x01ffe00000000000
#define BM_45_56 BM_56_45
#define BM_57_45 0x03ffe00000000000
#define BM_45_57 BM_57_45
#define BM_58_45 0x07ffe00000000000
#define BM_45_58 BM_58_45
#define BM_59_45 0x0fffe00000000000
#define BM_45_59 BM_59_45
#define BM_60_45 0x1fffe00000000000
#define BM_45_60 BM_60_45
#define BM_61_45 0x3fffe00000000000
#define BM_45_61 BM_61_45
#define BM_62_45 0x7fffe00000000000
#define BM_45_62 BM_62_45
#define BM_63_45 0xffffe00000000000
#define BM_45_63 BM_63_45
#define BM_46_46 0x0000400000000000
#define BM_47_46 0x0000c00000000000
#define BM_46_47 BM_47_46
#define BM_48_46 0x0001c00000000000
#define BM_46_48 BM_48_46
#define BM_49_46 0x0003c00000000000
#define BM_46_49 BM_49_46
#define BM_50_46 0x0007c00000000000
#define BM_46_50 BM_50_46
#define BM_51_46 0x000fc00000000000
#define BM_46_51 BM_51_46
#define BM_52_46 0x001fc00000000000
#define BM_46_52 BM_52_46
#define BM_53_46 0x003fc00000000000
#define BM_46_53 BM_53_46
#define BM_54_46 0x007fc00000000000
#define BM_46_54 BM_54_46
#define BM_55_46 0x00ffc00000000000
#define BM_46_55 BM_55_46
#define BM_56_46 0x01ffc00000000000
#define BM_46_56 BM_56_46
#define BM_57_46 0x03ffc00000000000
#define BM_46_57 BM_57_46
#define BM_58_46 0x07ffc00000000000
#define BM_46_58 BM_58_46
#define BM_59_46 0x0fffc00000000000
#define BM_46_59 BM_59_46
#define BM_60_46 0x1fffc00000000000
#define BM_46_60 BM_60_46
#define BM_61_46 0x3fffc00000000000
#define BM_46_61 BM_61_46
#define BM_62_46 0x7fffc00000000000
#define BM_46_62 BM_62_46
#define BM_63_46 0xffffc00000000000
#define BM_46_63 BM_63_46
#define BM_47_47 0x0000800000000000
#define BM_48_47 0x0001800000000000
#define BM_47_48 BM_48_47
#define BM_49_47 0x0003800000000000
#define BM_47_49 BM_49_47
#define BM_50_47 0x0007800000000000
#define BM_47_50 BM_50_47
#define BM_51_47 0x000f800000000000
#define BM_47_51 BM_51_47
#define BM_52_47 0x001f800000000000
#define BM_47_52 BM_52_47
#define BM_53_47 0x003f800000000000
#define BM_47_53 BM_53_47
#define BM_54_47 0x007f800000000000
#define BM_47_54 BM_54_47
#define BM_55_47 0x00ff800000000000
#define BM_47_55 BM_55_47
#define BM_56_47 0x01ff800000000000
#define BM_47_56 BM_56_47
#define BM_57_47 0x03ff800000000000
#define BM_47_57 BM_57_47
#define BM_58_47 0x07ff800000000000
#define BM_47_58 BM_58_47
#define BM_59_47 0x0fff800000000000
#define BM_47_59 BM_59_47
#define BM_60_47 0x1fff800000000000
#define BM_47_60 BM_60_47
#define BM_61_47 0x3fff800000000000
#define BM_47_61 BM_61_47
#define BM_62_47 0x7fff800000000000
#define BM_47_62 BM_62_47
#define BM_63_47 0xffff800000000000
#define BM_47_63 BM_63_47
#define BM_48_48 0x0001000000000000
#define BM_49_48 0x0003000000000000
#define BM_48_49 BM_49_48
#define BM_50_48 0x0007000000000000
#define BM_48_50 BM_50_48
#define BM_51_48 0x000f000000000000
#define BM_48_51 BM_51_48
#define BM_52_48 0x001f000000000000
#define BM_48_52 BM_52_48
#define BM_53_48 0x003f000000000000
#define BM_48_53 BM_53_48
#define BM_54_48 0x007f000000000000
#define BM_48_54 BM_54_48
#define BM_55_48 0x00ff000000000000
#define BM_48_55 BM_55_48
#define BM_56_48 0x01ff000000000000
#define BM_48_56 BM_56_48
#define BM_57_48 0x03ff000000000000
#define BM_48_57 BM_57_48
#define BM_58_48 0x07ff000000000000
#define BM_48_58 BM_58_48
#define BM_59_48 0x0fff000000000000
#define BM_48_59 BM_59_48
#define BM_60_48 0x1fff000000000000
#define BM_48_60 BM_60_48
#define BM_61_48 0x3fff000000000000
#define BM_48_61 BM_61_48
#define BM_62_48 0x7fff000000000000
#define BM_48_62 BM_62_48
#define BM_63_48 0xffff000000000000
#define BM_48_63 BM_63_48
#define BM_49_49 0x0002000000000000
#define BM_50_49 0x0006000000000000
#define BM_49_50 BM_50_49
#define BM_51_49 0x000e000000000000
#define BM_49_51 BM_51_49
#define BM_52_49 0x001e000000000000
#define BM_49_52 BM_52_49
#define BM_53_49 0x003e000000000000
#define BM_49_53 BM_53_49
#define BM_54_49 0x007e000000000000
#define BM_49_54 BM_54_49
#define BM_55_49 0x00fe000000000000
#define BM_49_55 BM_55_49
#define BM_56_49 0x01fe000000000000
#define BM_49_56 BM_56_49
#define BM_57_49 0x03fe000000000000
#define BM_49_57 BM_57_49
#define BM_58_49 0x07fe000000000000
#define BM_49_58 BM_58_49
#define BM_59_49 0x0ffe000000000000
#define BM_49_59 BM_59_49
#define BM_60_49 0x1ffe000000000000
#define BM_49_60 BM_60_49
#define BM_61_49 0x3ffe000000000000
#define BM_49_61 BM_61_49
#define BM_62_49 0x7ffe000000000000
#define BM_49_62 BM_62_49
#define BM_63_49 0xfffe000000000000
#define BM_49_63 BM_63_49
#define BM_50_50 0x0004000000000000
#define BM_51_50 0x000c000000000000
#define BM_50_51 BM_51_50
#define BM_52_50 0x001c000000000000
#define BM_50_52 BM_52_50
#define BM_53_50 0x003c000000000000
#define BM_50_53 BM_53_50
#define BM_54_50 0x007c000000000000
#define BM_50_54 BM_54_50
#define BM_55_50 0x00fc000000000000
#define BM_50_55 BM_55_50
#define BM_56_50 0x01fc000000000000
#define BM_50_56 BM_56_50
#define BM_57_50 0x03fc000000000000
#define BM_50_57 BM_57_50
#define BM_58_50 0x07fc000000000000
#define BM_50_58 BM_58_50
#define BM_59_50 0x0ffc000000000000
#define BM_50_59 BM_59_50
#define BM_60_50 0x1ffc000000000000
#define BM_50_60 BM_60_50
#define BM_61_50 0x3ffc000000000000
#define BM_50_61 BM_61_50
#define BM_62_50 0x7ffc000000000000
#define BM_50_62 BM_62_50
#define BM_63_50 0xfffc000000000000
#define BM_50_63 BM_63_50
#define BM_51_51 0x0008000000000000
#define BM_52_51 0x0018000000000000
#define BM_51_52 BM_52_51
#define BM_53_51 0x0038000000000000
#define BM_51_53 BM_53_51
#define BM_54_51 0x0078000000000000
#define BM_51_54 BM_54_51
#define BM_55_51 0x00f8000000000000
#define BM_51_55 BM_55_51
#define BM_56_51 0x01f8000000000000
#define BM_51_56 BM_56_51
#define BM_57_51 0x03f8000000000000
#define BM_51_57 BM_57_51
#define BM_58_51 0x07f8000000000000
#define BM_51_58 BM_58_51
#define BM_59_51 0x0ff8000000000000
#define BM_51_59 BM_59_51
#define BM_60_51 0x1ff8000000000000
#define BM_51_60 BM_60_51
#define BM_61_51 0x3ff8000000000000
#define BM_51_61 BM_61_51
#define BM_62_51 0x7ff8000000000000
#define BM_51_62 BM_62_51
#define BM_63_51 0xfff8000000000000
#define BM_51_63 BM_63_51
#define BM_52_52 0x0010000000000000
#define BM_53_52 0x0030000000000000
#define BM_52_53 BM_53_52
#define BM_54_52 0x0070000000000000
#define BM_52_54 BM_54_52
#define BM_55_52 0x00f0000000000000
#define BM_52_55 BM_55_52
#define BM_56_52 0x01f0000000000000
#define BM_52_56 BM_56_52
#define BM_57_52 0x03f0000000000000
#define BM_52_57 BM_57_52
#define BM_58_52 0x07f0000000000000
#define BM_52_58 BM_58_52
#define BM_59_52 0x0ff0000000000000
#define BM_52_59 BM_59_52
#define BM_60_52 0x1ff0000000000000
#define BM_52_60 BM_60_52
#define BM_61_52 0x3ff0000000000000
#define BM_52_61 BM_61_52
#define BM_62_52 0x7ff0000000000000
#define BM_52_62 BM_62_52
#define BM_63_52 0xfff0000000000000
#define BM_52_63 BM_63_52
#define BM_53_53 0x0020000000000000
#define BM_54_53 0x0060000000000000
#define BM_53_54 BM_54_53
#define BM_55_53 0x00e0000000000000
#define BM_53_55 BM_55_53
#define BM_56_53 0x01e0000000000000
#define BM_53_56 BM_56_53
#define BM_57_53 0x03e0000000000000
#define BM_53_57 BM_57_53
#define BM_58_53 0x07e0000000000000
#define BM_53_58 BM_58_53
#define BM_59_53 0x0fe0000000000000
#define BM_53_59 BM_59_53
#define BM_60_53 0x1fe0000000000000
#define BM_53_60 BM_60_53
#define BM_61_53 0x3fe0000000000000
#define BM_53_61 BM_61_53
#define BM_62_53 0x7fe0000000000000
#define BM_53_62 BM_62_53
#define BM_63_53 0xffe0000000000000
#define BM_53_63 BM_63_53
#define BM_54_54 0x0040000000000000
#define BM_55_54 0x00c0000000000000
#define BM_54_55 BM_55_54
#define BM_56_54 0x01c0000000000000
#define BM_54_56 BM_56_54
#define BM_57_54 0x03c0000000000000
#define BM_54_57 BM_57_54
#define BM_58_54 0x07c0000000000000
#define BM_54_58 BM_58_54
#define BM_59_54 0x0fc0000000000000
#define BM_54_59 BM_59_54
#define BM_60_54 0x1fc0000000000000
#define BM_54_60 BM_60_54
#define BM_61_54 0x3fc0000000000000
#define BM_54_61 BM_61_54
#define BM_62_54 0x7fc0000000000000
#define BM_54_62 BM_62_54
#define BM_63_54 0xffc0000000000000
#define BM_54_63 BM_63_54
#define BM_55_55 0x0080000000000000
#define BM_56_55 0x0180000000000000
#define BM_55_56 BM_56_55
#define BM_57_55 0x0380000000000000
#define BM_55_57 BM_57_55
#define BM_58_55 0x0780000000000000
#define BM_55_58 BM_58_55
#define BM_59_55 0x0f80000000000000
#define BM_55_59 BM_59_55
#define BM_60_55 0x1f80000000000000
#define BM_55_60 BM_60_55
#define BM_61_55 0x3f80000000000000
#define BM_55_61 BM_61_55
#define BM_62_55 0x7f80000000000000
#define BM_55_62 BM_62_55
#define BM_63_55 0xff80000000000000
#define BM_55_63 BM_63_55
#define BM_56_56 0x0100000000000000
#define BM_57_56 0x0300000000000000
#define BM_56_57 BM_57_56
#define BM_58_56 0x0700000000000000
#define BM_56_58 BM_58_56
#define BM_59_56 0x0f00000000000000
#define BM_56_59 BM_59_56
#define BM_60_56 0x1f00000000000000
#define BM_56_60 BM_60_56
#define BM_61_56 0x3f00000000000000
#define BM_56_61 BM_61_56
#define BM_62_56 0x7f00000000000000
#define BM_56_62 BM_62_56
#define BM_63_56 0xff00000000000000
#define BM_56_63 BM_63_56
#define BM_57_57 0x0200000000000000
#define BM_58_57 0x0600000000000000
#define BM_57_58 BM_58_57
#define BM_59_57 0x0e00000000000000
#define BM_57_59 BM_59_57
#define BM_60_57 0x1e00000000000000
#define BM_57_60 BM_60_57
#define BM_61_57 0x3e00000000000000
#define BM_57_61 BM_61_57
#define BM_62_57 0x7e00000000000000
#define BM_57_62 BM_62_57
#define BM_63_57 0xfe00000000000000
#define BM_57_63 BM_63_57
#define BM_58_58 0x0400000000000000
#define BM_59_58 0x0c00000000000000
#define BM_58_59 BM_59_58
#define BM_60_58 0x1c00000000000000
#define BM_58_60 BM_60_58
#define BM_61_58 0x3c00000000000000
#define BM_58_61 BM_61_58
#define BM_62_58 0x7c00000000000000
#define BM_58_62 BM_62_58
#define BM_63_58 0xfc00000000000000
#define BM_58_63 BM_63_58
#define BM_59_59 0x0800000000000000
#define BM_60_59 0x1800000000000000
#define BM_59_60 BM_60_59
#define BM_61_59 0x3800000000000000
#define BM_59_61 BM_61_59
#define BM_62_59 0x7800000000000000
#define BM_59_62 BM_62_59
#define BM_63_59 0xf800000000000000
#define BM_59_63 BM_63_59
#define BM_60_60 0x1000000000000000
#define BM_61_60 0x3000000000000000
#define BM_60_61 BM_61_60
#define BM_62_60 0x7000000000000000
#define BM_60_62 BM_62_60
#define BM_63_60 0xf000000000000000
#define BM_60_63 BM_63_60
#define BM_61_61 0x2000000000000000
#define BM_62_61 0x6000000000000000
#define BM_61_62 BM_62_61
#define BM_63_61 0xe000000000000000
#define BM_61_63 BM_63_61
#define BM_62_62 0x4000000000000000
#define BM_63_62 0xc000000000000000
#define BM_62_63 BM_63_62
#define BM_63_63 0x8000000000000000

#endif

#endif /* __ASM_TX4927_TX4927_MIPS_H */
