/*
 * SMU_8_0 Register documentation
 *
 * Copyright (C) 2014  Advanced Micro Devices, Inc.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE COPYRIGHT HOLDER(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
 * AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

#ifndef SMU_8_0_SH_MASK_H
#define SMU_8_0_SH_MASK_H

#define THM_TCON_CSR_CONFIG__TCC_ADDR_MASK 0x3ff
#define THM_TCON_CSR_CONFIG__TCC_ADDR__SHIFT 0x0
#define THM_TCON_CSR_CONFIG__TCC_READ_OP_MASK 0x400
#define THM_TCON_CSR_CONFIG__TCC_READ_OP__SHIFT 0xa
#define THM_TCON_CSR_DATA__TCC_DATA_MASK 0xfff
#define THM_TCON_CSR_DATA__TCC_DATA__SHIFT 0x0
#define THM_TCON_CSR_DATA__TCC_REQ_DONE_MASK 0x1000
#define THM_TCON_CSR_DATA__TCC_REQ_DONE__SHIFT 0xc
#define THM_TCON_HTC__HTC_EN_MASK 0x1
#define THM_TCON_HTC__HTC_EN__SHIFT 0x0
#define THM_TCON_HTC__RSVD0_MASK 0x2
#define THM_TCON_HTC__RSVD0__SHIFT 0x1
#define THM_TCON_HTC__HTC_P_STATE_EN_MASK 0x4
#define THM_TCON_HTC__HTC_P_STATE_EN__SHIFT 0x2
#define THM_TCON_HTC__RSVD1_MASK 0x8
#define THM_TCON_HTC__RSVD1__SHIFT 0x3
#define THM_TCON_HTC__HTC_ACTIVE_MASK 0x10
#define THM_TCON_HTC__HTC_ACTIVE__SHIFT 0x4
#define THM_TCON_HTC__HTC_ACTIVE_LOG_MASK 0x20
#define THM_TCON_HTC__HTC_ACTIVE_LOG__SHIFT 0x5
#define THM_TCON_HTC__HTC_APIC_HI_EN_MASK 0x40
#define THM_TCON_HTC__HTC_APIC_HI_EN__SHIFT 0x6
#define THM_TCON_HTC__HTC_APIC_LO_EN_MASK 0x80
#define THM_TCON_HTC__HTC_APIC_LO_EN__SHIFT 0x7
#define THM_TCON_HTC__HTC_DIAG_MASK 0x100
#define THM_TCON_HTC__HTC_DIAG__SHIFT 0x8
#define THM_TCON_HTC__DIS_PROCHOT_PIN_MASK 0x200
#define THM_TCON_HTC__DIS_PROCHOT_PIN__SHIFT 0x9
#define THM_TCON_HTC__HTC_TO_GNB_EN_MASK 0x400
#define THM_TCON_HTC__HTC_TO_GNB_EN__SHIFT 0xa
#define THM_TCON_HTC__PROCHOT_TO_GNB_EN_MASK 0x800
#define THM_TCON_HTC__PROCHOT_TO_GNB_EN__SHIFT 0xb
#define THM_TCON_HTC__RSVD2_MASK 0xf000
#define THM_TCON_HTC__RSVD2__SHIFT 0xc
#define THM_TCON_HTC__HTC_TMP_LMT_MASK 0x7f0000
#define THM_TCON_HTC__HTC_TMP_LMT__SHIFT 0x10
#define THM_TCON_HTC__HTC_SLEW_SEL_MASK 0x800000
#define THM_TCON_HTC__HTC_SLEW_SEL__SHIFT 0x17
#define THM_TCON_HTC__HTC_HYST_LMT_MASK 0xf000000
#define THM_TCON_HTC__HTC_HYST_LMT__SHIFT 0x18
#define THM_TCON_HTC__HTC_PSTATE_LIMIT_MASK 0x70000000
#define THM_TCON_HTC__HTC_PSTATE_LIMIT__SHIFT 0x1c
#define THM_TCON_CUR_TMP__PER_STEP_TIME_UP_MASK 0x1f
#define THM_TCON_CUR_TMP__PER_STEP_TIME_UP__SHIFT 0x0
#define THM_TCON_CUR_TMP__TMP_MAX_DIFF_UP_MASK 0x60
#define THM_TCON_CUR_TMP__TMP_MAX_DIFF_UP__SHIFT 0x5
#define THM_TCON_CUR_TMP__TMP_SLEW_DN_EN_MASK 0x80
#define THM_TCON_CUR_TMP__TMP_SLEW_DN_EN__SHIFT 0x7
#define THM_TCON_CUR_TMP__PER_STEP_TIME_DN_MASK 0x1f00
#define THM_TCON_CUR_TMP__PER_STEP_TIME_DN__SHIFT 0x8
#define THM_TCON_CUR_TMP__CUR_TEMP_TJ_SEL_MASK 0x30000
#define THM_TCON_CUR_TMP__CUR_TEMP_TJ_SEL__SHIFT 0x10
#define THM_TCON_CUR_TMP__CUR_TEMP_TJ_SLEW_SEL_MASK 0x40000
#define THM_TCON_CUR_TMP__CUR_TEMP_TJ_SLEW_SEL__SHIFT 0x12
#define THM_TCON_CUR_TMP__CUR_TEMP_RANGE_SEL_MASK 0x80000
#define THM_TCON_CUR_TMP__CUR_TEMP_RANGE_SEL__SHIFT 0x13
#define THM_TCON_CUR_TMP__CUR_TEMP_MASK 0xffe00000
#define THM_TCON_CUR_TMP__CUR_TEMP__SHIFT 0x15
#define THM_TCON_THERM_TRIP__RSVD0_MASK 0x1
#define THM_TCON_THERM_TRIP__RSVD0__SHIFT 0x0
#define THM_TCON_THERM_TRIP__THERM_TP_MASK 0x2
#define THM_TCON_THERM_TRIP__THERM_TP__SHIFT 0x1
#define THM_TCON_THERM_TRIP__RSVD1_MASK 0x4
#define THM_TCON_THERM_TRIP__RSVD1__SHIFT 0x2
#define THM_TCON_THERM_TRIP__THERM_TP_SENSE_MASK 0x8
#define THM_TCON_THERM_TRIP__THERM_TP_SENSE__SHIFT 0x3
#define THM_TCON_THERM_TRIP__RSVD2_MASK 0x10
#define THM_TCON_THERM_TRIP__RSVD2__SHIFT 0x4
#define THM_TCON_THERM_TRIP__THERM_TP_EN_MASK 0x20
#define THM_TCON_THERM_TRIP__THERM_TP_EN__SHIFT 0x5
#define THM_TCON_THERM_TRIP__RSVD3_MASK 0x7fffffc0
#define THM_TCON_THERM_TRIP__RSVD3__SHIFT 0x6
#define THM_TCON_THERM_TRIP__SW_THERM_TP_MASK 0x80000000
#define THM_TCON_THERM_TRIP__SW_THERM_TP__SHIFT 0x1f
#define THM_GPIO_PROCHOT_CTRL__TX12_EN_MASK 0x1
#define THM_GPIO_PROCHOT_CTRL__TX12_EN__SHIFT 0x0
#define THM_GPIO_PROCHOT_CTRL__PD_MASK 0x2
#define THM_GPIO_PROCHOT_CTRL__PD__SHIFT 0x1
#define THM_GPIO_PROCHOT_CTRL__PU_MASK 0x4
#define THM_GPIO_PROCHOT_CTRL__PU__SHIFT 0x2
#define THM_GPIO_PROCHOT_CTRL__SCHMEN_MASK 0x8
#define THM_GPIO_PROCHOT_CTRL__SCHMEN__SHIFT 0x3
#define THM_GPIO_PROCHOT_CTRL__SN_MASK 0x10
#define THM_GPIO_PROCHOT_CTRL__SN__SHIFT 0x4
#define THM_GPIO_PROCHOT_CTRL__OE_OVERRIDE_MASK 0x100
#define THM_GPIO_PROCHOT_CTRL__OE_OVERRIDE__SHIFT 0x8
#define THM_GPIO_PROCHOT_CTRL__OE_MASK 0x200
#define THM_GPIO_PROCHOT_CTRL__OE__SHIFT 0x9
#define THM_GPIO_PROCHOT_CTRL__A_OVERRIDE_MASK 0x400
#define THM_GPIO_PROCHOT_CTRL__A_OVERRIDE__SHIFT 0xa
#define THM_GPIO_PROCHOT_CTRL__A_MASK 0x800
#define THM_GPIO_PROCHOT_CTRL__A__SHIFT 0xb
#define THM_GPIO_PROCHOT_CTRL__Y_MASK 0x1000
#define THM_GPIO_PROCHOT_CTRL__Y__SHIFT 0xc
#define THM_GPIO_THERMTRIP_CTRL__TX12_EN_MASK 0x1
#define THM_GPIO_THERMTRIP_CTRL__TX12_EN__SHIFT 0x0
#define THM_GPIO_THERMTRIP_CTRL__PD_MASK 0x2
#define THM_GPIO_THERMTRIP_CTRL__PD__SHIFT 0x1
#define THM_GPIO_THERMTRIP_CTRL__PU_MASK 0x4
#define THM_GPIO_THERMTRIP_CTRL__PU__SHIFT 0x2
#define THM_GPIO_THERMTRIP_CTRL__SCHMEN_MASK 0x8
#define THM_GPIO_THERMTRIP_CTRL__SCHMEN__SHIFT 0x3
#define THM_GPIO_THERMTRIP_CTRL__SN_MASK 0x10
#define THM_GPIO_THERMTRIP_CTRL__SN__SHIFT 0x4
#define THM_GPIO_THERMTRIP_CTRL__OE_OVERRIDE_MASK 0x100
#define THM_GPIO_THERMTRIP_CTRL__OE_OVERRIDE__SHIFT 0x8
#define THM_GPIO_THERMTRIP_CTRL__OE_MASK 0x200
#define THM_GPIO_THERMTRIP_CTRL__OE__SHIFT 0x9
#define THM_GPIO_THERMTRIP_CTRL__A_OVERRIDE_MASK 0x400
#define THM_GPIO_THERMTRIP_CTRL__A_OVERRIDE__SHIFT 0xa
#define THM_GPIO_THERMTRIP_CTRL__A_MASK 0x800
#define THM_GPIO_THERMTRIP_CTRL__A__SHIFT 0xb
#define THM_GPIO_THERMTRIP_CTRL__Y_MASK 0x1000
#define THM_GPIO_THERMTRIP_CTRL__Y__SHIFT 0xc
#define THM_THERMAL_INT_ENA__THERM_INTH_SET_MASK 0x1
#define THM_THERMAL_INT_ENA__THERM_INTH_SET__SHIFT 0x0
#define THM_THERMAL_INT_ENA__THERM_INTL_SET_MASK 0x2
#define THM_THERMAL_INT_ENA__THERM_INTL_SET__SHIFT 0x1
#define THM_THERMAL_INT_ENA__THERM_TRIGGER_SET_MASK 0x4
#define THM_THERMAL_INT_ENA__THERM_TRIGGER_SET__SHIFT 0x2
#define THM_THERMAL_INT_ENA__THERM_INTH_CLR_MASK 0x8
#define THM_THERMAL_INT_ENA__THERM_INTH_CLR__SHIFT 0x3
#define THM_THERMAL_INT_ENA__THERM_INTL_CLR_MASK 0x10
#define THM_THERMAL_INT_ENA__THERM_INTL_CLR__SHIFT 0x4
#define THM_THERMAL_INT_ENA__THERM_TRIGGER_CLR_MASK 0x20
#define THM_THERMAL_INT_ENA__THERM_TRIGGER_CLR__SHIFT 0x5
#define THM_THERMAL_INT_CTRL__DIG_THERM_INTH_MASK 0xff
#define THM_THERMAL_INT_CTRL__DIG_THERM_INTH__SHIFT 0x0
#define THM_THERMAL_INT_CTRL__DIG_THERM_INTL_MASK 0xff00
#define THM_THERMAL_INT_CTRL__DIG_THERM_INTL__SHIFT 0x8
#define THM_THERMAL_INT_CTRL__GNB_TEMP_THRESHOLD_MASK 0xff0000
#define THM_THERMAL_INT_CTRL__GNB_TEMP_THRESHOLD__SHIFT 0x10
#define THM_THERMAL_INT_CTRL__THERM_INTH_MASK_MASK 0x1000000
#define THM_THERMAL_INT_CTRL__THERM_INTH_MASK__SHIFT 0x18
#define THM_THERMAL_INT_CTRL__THERM_INTL_MASK_MASK 0x2000000
#define THM_THERMAL_INT_CTRL__THERM_INTL_MASK__SHIFT 0x19
#define THM_THERMAL_INT_CTRL__THERM_TRIGGER_MASK_MASK 0x4000000
#define THM_THERMAL_INT_CTRL__THERM_TRIGGER_MASK__SHIFT 0x1a
#define THM_THERMAL_INT_CTRL__THERM_TRIGGER_CNB_MASK_MASK 0x8000000
#define THM_THERMAL_INT_CTRL__THERM_TRIGGER_CNB_MASK__SHIFT 0x1b
#define THM_THERMAL_INT_CTRL__THERM_GNB_HW_ENA_MASK 0x10000000
#define THM_THERMAL_INT_CTRL__THERM_GNB_HW_ENA__SHIFT 0x1c
#define THM_THERMAL_INT_STATUS__THERM_INTH_DETECT_MASK 0x1
#define THM_THERMAL_INT_STATUS__THERM_INTH_DETECT__SHIFT 0x0
#define THM_THERMAL_INT_STATUS__THERM_INTL_DETECT_MASK 0x2
#define THM_THERMAL_INT_STATUS__THERM_INTL_DETECT__SHIFT 0x1
#define THM_THERMAL_INT_STATUS__THERM_TRIGGER_DETECT_MASK 0x4
#define THM_THERMAL_INT_STATUS__THERM_TRIGGER_DETECT__SHIFT 0x2
#define THM_THERMAL_INT_STATUS__THERM_TRIGGER_CNB_DETECT_MASK 0x8
#define THM_THERMAL_INT_STATUS__THERM_TRIGGER_CNB_DETECT__SHIFT 0x3
#define TMON0_RDIL0_DATA__TEMP_Z_DATA_MASK 0xfff
#define TMON0_RDIL0_DATA__TEMP_Z_DATA__SHIFT 0x0
#define TMON0_RDIL1_DATA__TEMP_Z_DATA_MASK 0xfff
#define TMON0_RDIL1_DATA__TEMP_Z_DATA__SHIFT 0x0
#define TMON0_RDIL2_DATA__TEMP_Z_DATA_MASK 0xfff
#define TMON0_RDIL2_DATA__TEMP_Z_DATA__SHIFT 0x0
#define TMON0_RDIL3_DATA__TEMP_Z_DATA_MASK 0xfff
#define TMON0_RDIL3_DATA__TEMP_Z_DATA__SHIFT 0x0
#define TMON0_RDIL4_DATA__TEMP_Z_DATA_MASK 0xfff
#define TMON0_RDIL4_DATA__TEMP_Z_DATA__SHIFT 0x0
#define TMON0_RDIL5_DATA__TEMP_Z_DATA_MASK 0xfff
#define TMON0_RDIL5_DATA__TEMP_Z_DATA__SHIFT 0x0
#define TMON0_RDIL6_DATA__TEMP_Z_DATA_MASK 0xfff
#define TMON0_RDIL6_DATA__TEMP_Z_DATA__SHIFT 0x0
#define TMON0_RDIL7_DATA__TEMP_Z_DATA_MASK 0xfff
#define TMON0_RDIL7_DATA__TEMP_Z_DATA__SHIFT 0x0
#define TMON0_RDIL8_DATA__TEMP_Z_DATA_MASK 0xfff
#define TMON0_RDIL8_DATA__TEMP_Z_DATA__SHIFT 0x0
#define TMON0_RDIL9_DATA__TEMP_Z_DATA_MASK 0xfff
#define TMON0_RDIL9_DATA__TEMP_Z_DATA__SHIFT 0x0
#define TMON0_RDIL10_DATA__TEMP_Z_DATA_MASK 0xfff
#define TMON0_RDIL10_DATA__TEMP_Z_DATA__SHIFT 0x0
#define TMON0_RDIL11_DATA__TEMP_Z_DATA_MASK 0xfff
#define TMON0_RDIL11_DATA__TEMP_Z_DATA__SHIFT 0x0
#define TMON0_RDIL12_DATA__TEMP_Z_DATA_MASK 0xfff
#define TMON0_RDIL12_DATA__TEMP_Z_DATA__SHIFT 0x0
#define TMON0_RDIL13_DATA__TEMP_Z_DATA_MASK 0xfff
#define TMON0_RDIL13_DATA__TEMP_Z_DATA__SHIFT 0x0
#define TMON0_RDIL14_DATA__TEMP_Z_DATA_MASK 0xfff
#define TMON0_RDIL14_DATA__TEMP_Z_DATA__SHIFT 0x0
#define TMON0_RDIL15_DATA__TEMP_Z_DATA_MASK 0xfff
#define TMON0_RDIL15_DATA__TEMP_Z_DATA__SHIFT 0x0
#define TMON0_RDIR0_DATA__TEMP_Z_DATA_MASK 0xfff
#define TMON0_RDIR0_DATA__TEMP_Z_DATA__SHIFT 0x0
#define TMON0_RDIR1_DATA__TEMP_Z_DATA_MASK 0xfff
#define TMON0_RDIR1_DATA__TEMP_Z_DATA__SHIFT 0x0
#define TMON0_RDIR2_DATA__TEMP_Z_DATA_MASK 0xfff
#define TMON0_RDIR2_DATA__TEMP_Z_DATA__SHIFT 0x0
#define TMON0_RDIR3_DATA__TEMP_Z_DATA_MASK 0xfff
#define TMON0_RDIR3_DATA__TEMP_Z_DATA__SHIFT 0x0
#define TMON0_RDIR4_DATA__TEMP_Z_DATA_MASK 0xfff
#define TMON0_RDIR4_DATA__TEMP_Z_DATA__SHIFT 0x0
#define TMON0_RDIR5_DATA__TEMP_Z_DATA_MASK 0xfff
#define TMON0_RDIR5_DATA__TEMP_Z_DATA__SHIFT 0x0
#define TMON0_RDIR6_DATA__TEMP_Z_DATA_MASK 0xfff
#define TMON0_RDIR6_DATA__TEMP_Z_DATA__SHIFT 0x0
#define TMON0_RDIR7_DATA__TEMP_Z_DATA_MASK 0xfff
#define TMON0_RDIR7_DATA__TEMP_Z_DATA__SHIFT 0x0
#define TMON0_RDIR8_DATA__TEMP_Z_DATA_MASK 0xfff
#define TMON0_RDIR8_DATA__TEMP_Z_DATA__SHIFT 0x0
#define TMON0_RDIR9_DATA__TEMP_Z_DATA_MASK 0xfff
#define TMON0_RDIR9_DATA__TEMP_Z_DATA__SHIFT 0x0
#define TMON0_RDIR10_DATA__TEMP_Z_DATA_MASK 0xfff
#define TMON0_RDIR10_DATA__TEMP_Z_DATA__SHIFT 0x0
#define TMON0_RDIR11_DATA__TEMP_Z_DATA_MASK 0xfff
#define TMON0_RDIR11_DATA__TEMP_Z_DATA__SHIFT 0x0
#define TMON0_RDIR12_DATA__TEMP_Z_DATA_MASK 0xfff
#define TMON0_RDIR12_DATA__TEMP_Z_DATA__SHIFT 0x0
#define TMON0_RDIR13_DATA__TEMP_Z_DATA_MASK 0xfff
#define TMON0_RDIR13_DATA__TEMP_Z_DATA__SHIFT 0x0
#define TMON0_RDIR14_DATA__TEMP_Z_DATA_MASK 0xfff
#define TMON0_RDIR14_DATA__TEMP_Z_DATA__SHIFT 0x0
#define TMON0_RDIR15_DATA__TEMP_Z_DATA_MASK 0xfff
#define TMON0_RDIR15_DATA__TEMP_Z_DATA__SHIFT 0x0
#define TMON0_INT_DATA__TEMP_Z_DATA_MASK 0xfff
#define TMON0_INT_DATA__TEMP_Z_DATA__SHIFT 0x0
#define TMON0_RDIL_PRESENT0__RDIL_PRESENT_7_0_MASK 0xff
#define TMON0_RDIL_PRESENT0__RDIL_PRESENT_7_0__SHIFT 0x0
#define TMON0_RDIL_PRESENT1__RDIL_PRESENT_15_8_MASK 0xff
#define TMON0_RDIL_PRESENT1__RDIL_PRESENT_15_8__SHIFT 0x0
#define TMON0_RDIR_PRESENT0__RDIR_PRESENT_7_0_MASK 0xff
#define TMON0_RDIR_PRESENT0__RDIR_PRESENT_7_0__SHIFT 0x0
#define TMON0_RDIR_PRESENT1__RDIR_PRESENT_15_8_MASK 0xff
#define TMON0_RDIR_PRESENT1__RDIR_PRESENT_15_8__SHIFT 0x0
#define TMON0_CONFIG__NUM_ACQ_MASK 0x7
#define TMON0_CONFIG__NUM_ACQ__SHIFT 0x0
#define TMON0_CONFIG__FORCE_MAX_ACQ_MASK 0x8
#define TMON0_CONFIG__FORCE_MAX_ACQ__SHIFT 0x3
#define TMON0_CONFIG__RDI_INTERLEAVE_MASK 0x10
#define TMON0_CONFIG__RDI_INTERLEAVE__SHIFT 0x4
#define TMON0_CONFIG__RE_CALIB_EN_MASK 0x40
#define TMON0_CONFIG__RE_CALIB_EN__SHIFT 0x6
#define TMON0_TEMP_CALC_COEFF0__Z_MASK 0x7ff
#define TMON0_TEMP_CALC_COEFF0__Z__SHIFT 0x0
#define TMON0_TEMP_CALC_COEFF1__A_MASK 0xfff
#define TMON0_TEMP_CALC_COEFF1__A__SHIFT 0x0
#define TMON0_TEMP_CALC_COEFF2__B_MASK 0x3f
#define TMON0_TEMP_CALC_COEFF2__B__SHIFT 0x0
#define TMON0_TEMP_CALC_COEFF3__C_MASK 0x7ff
#define TMON0_TEMP_CALC_COEFF3__C__SHIFT 0x0
#define TMON0_TEMP_CALC_COEFF4__K_MASK 0x1
#define TMON0_TEMP_CALC_COEFF4__K__SHIFT 0x0
#define TMON0_DEBUG0__DEBUG_Z_MASK 0x7ff
#define TMON0_DEBUG0__DEBUG_Z__SHIFT 0x0
#define TMON0_DEBUG0__DEBUG_Z_EN_MASK 0x800
#define TMON0_DEBUG0__DEBUG_Z_EN__SHIFT 0xb
#define TMON0_DEBUG1__DEBUG_RDI_MASK 0x1f
#define TMON0_DEBUG1__DEBUG_RDI__SHIFT 0x0
#define TMON1_RDIL0_DATA__TEMP_Z_DATA_MASK 0xfff
#define TMON1_RDIL0_DATA__TEMP_Z_DATA__SHIFT 0x0
#define TMON1_RDIL1_DATA__TEMP_Z_DATA_MASK 0xfff
#define TMON1_RDIL1_DATA__TEMP_Z_DATA__SHIFT 0x0
#define TMON1_RDIL2_DATA__TEMP_Z_DATA_MASK 0xfff
#define TMON1_RDIL2_DATA__TEMP_Z_DATA__SHIFT 0x0
#define TMON1_RDIL3_DATA__TEMP_Z_DATA_MASK 0xfff
#define TMON1_RDIL3_DATA__TEMP_Z_DATA__SHIFT 0x0
#define TMON1_RDIL4_DATA__TEMP_Z_DATA_MASK 0xfff
#define TMON1_RDIL4_DATA__TEMP_Z_DATA__SHIFT 0x0
#define TMON1_RDIL5_DATA__TEMP_Z_DATA_MASK 0xfff
#define TMON1_RDIL5_DATA__TEMP_Z_DATA__SHIFT 0x0
#define TMON1_RDIL6_DATA__TEMP_Z_DATA_MASK 0xfff
#define TMON1_RDIL6_DATA__TEMP_Z_DATA__SHIFT 0x0
#define TMON1_RDIL7_DATA__TEMP_Z_DATA_MASK 0xfff
#define TMON1_RDIL7_DATA__TEMP_Z_DATA__SHIFT 0x0
#define TMON1_RDIL8_DATA__TEMP_Z_DATA_MASK 0xfff
#define TMON1_RDIL8_DATA__TEMP_Z_DATA__SHIFT 0x0
#define TMON1_RDIL9_DATA__TEMP_Z_DATA_MASK 0xfff
#define TMON1_RDIL9_DATA__TEMP_Z_DATA__SHIFT 0x0
#define TMON1_RDIL10_DATA__TEMP_Z_DATA_MASK 0xfff
#define TMON1_RDIL10_DATA__TEMP_Z_DATA__SHIFT 0x0
#define TMON1_RDIL11_DATA__TEMP_Z_DATA_MASK 0xfff
#define TMON1_RDIL11_DATA__TEMP_Z_DATA__SHIFT 0x0
#define TMON1_RDIL12_DATA__TEMP_Z_DATA_MASK 0xfff
#define TMON1_RDIL12_DATA__TEMP_Z_DATA__SHIFT 0x0
#define TMON1_RDIL13_DATA__TEMP_Z_DATA_MASK 0xfff
#define TMON1_RDIL13_DATA__TEMP_Z_DATA__SHIFT 0x0
#define TMON1_RDIL14_DATA__TEMP_Z_DATA_MASK 0xfff
#define TMON1_RDIL14_DATA__TEMP_Z_DATA__SHIFT 0x0
#define TMON1_RDIL15_DATA__TEMP_Z_DATA_MASK 0xfff
#define TMON1_RDIL15_DATA__TEMP_Z_DATA__SHIFT 0x0
#define TMON1_RDIR0_DATA__TEMP_Z_DATA_MASK 0xfff
#define TMON1_RDIR0_DATA__TEMP_Z_DATA__SHIFT 0x0
#define TMON1_RDIR1_DATA__TEMP_Z_DATA_MASK 0xfff
#define TMON1_RDIR1_DATA__TEMP_Z_DATA__SHIFT 0x0
#define TMON1_RDIR2_DATA__TEMP_Z_DATA_MASK 0xfff
#define TMON1_RDIR2_DATA__TEMP_Z_DATA__SHIFT 0x0
#define TMON1_RDIR3_DATA__TEMP_Z_DATA_MASK 0xfff
#define TMON1_RDIR3_DATA__TEMP_Z_DATA__SHIFT 0x0
#define TMON1_RDIR4_DATA__TEMP_Z_DATA_MASK 0xfff
#define TMON1_RDIR4_DATA__TEMP_Z_DATA__SHIFT 0x0
#define TMON1_RDIR5_DATA__TEMP_Z_DATA_MASK 0xfff
#define TMON1_RDIR5_DATA__TEMP_Z_DATA__SHIFT 0x0
#define TMON1_RDIR6_DATA__TEMP_Z_DATA_MASK 0xfff
#define TMON1_RDIR6_DATA__TEMP_Z_DATA__SHIFT 0x0
#define TMON1_RDIR7_DATA__TEMP_Z_DATA_MASK 0xfff
#define TMON1_RDIR7_DATA__TEMP_Z_DATA__SHIFT 0x0
#define TMON1_RDIR8_DATA__TEMP_Z_DATA_MASK 0xfff
#define TMON1_RDIR8_DATA__TEMP_Z_DATA__SHIFT 0x0
#define TMON1_RDIR9_DATA__TEMP_Z_DATA_MASK 0xfff
#define TMON1_RDIR9_DATA__TEMP_Z_DATA__SHIFT 0x0
#define TMON1_RDIR10_DATA__TEMP_Z_DATA_MASK 0xfff
#define TMON1_RDIR10_DATA__TEMP_Z_DATA__SHIFT 0x0
#define TMON1_RDIR11_DATA__TEMP_Z_DATA_MASK 0xfff
#define TMON1_RDIR11_DATA__TEMP_Z_DATA__SHIFT 0x0
#define TMON1_RDIR12_DATA__TEMP_Z_DATA_MASK 0xfff
#define TMON1_RDIR12_DATA__TEMP_Z_DATA__SHIFT 0x0
#define TMON1_RDIR13_DATA__TEMP_Z_DATA_MASK 0xfff
#define TMON1_RDIR13_DATA__TEMP_Z_DATA__SHIFT 0x0
#define TMON1_RDIR14_DATA__TEMP_Z_DATA_MASK 0xfff
#define TMON1_RDIR14_DATA__TEMP_Z_DATA__SHIFT 0x0
#define TMON1_RDIR15_DATA__TEMP_Z_DATA_MASK 0xfff
#define TMON1_RDIR15_DATA__TEMP_Z_DATA__SHIFT 0x0
#define TMON1_INT_DATA__TEMP_Z_DATA_MASK 0xfff
#define TMON1_INT_DATA__TEMP_Z_DATA__SHIFT 0x0
#define TMON1_RDIL_PRESENT0__RDIL_PRESENT_7_0_MASK 0xff
#define TMON1_RDIL_PRESENT0__RDIL_PRESENT_7_0__SHIFT 0x0
#define TMON1_RDIL_PRESENT1__RDIL_PRESENT_15_8_MASK 0xff
#define TMON1_RDIL_PRESENT1__RDIL_PRESENT_15_8__SHIFT 0x0
#define TMON1_RDIR_PRESENT0__RDIR_PRESENT_7_0_MASK 0xff
#define TMON1_RDIR_PRESENT0__RDIR_PRESENT_7_0__SHIFT 0x0
#define TMON1_RDIR_PRESENT1__RDIR_PRESENT_15_8_MASK 0xff
#define TMON1_RDIR_PRESENT1__RDIR_PRESENT_15_8__SHIFT 0x0
#define TMON1_CONFIG__NUM_ACQ_MASK 0x7
#define TMON1_CONFIG__NUM_ACQ__SHIFT 0x0
#define TMON1_CONFIG__FORCE_MAX_ACQ_MASK 0x8
#define TMON1_CONFIG__FORCE_MAX_ACQ__SHIFT 0x3
#define TMON1_CONFIG__RDI_INTERLEAVE_MASK 0x10
#define TMON1_CONFIG__RDI_INTERLEAVE__SHIFT 0x4
#define TMON1_CONFIG__RE_CALIB_EN_MASK 0x40
#define TMON1_CONFIG__RE_CALIB_EN__SHIFT 0x6
#define TMON1_TEMP_CALC_COEFF0__Z_MASK 0x7ff
#define TMON1_TEMP_CALC_COEFF0__Z__SHIFT 0x0
#define TMON1_TEMP_CALC_COEFF1__A_MASK 0xfff
#define TMON1_TEMP_CALC_COEFF1__A__SHIFT 0x0
#define TMON1_TEMP_CALC_COEFF2__B_MASK 0x3f
#define TMON1_TEMP_CALC_COEFF2__B__SHIFT 0x0
#define TMON1_TEMP_CALC_COEFF3__C_MASK 0x7ff
#define TMON1_TEMP_CALC_COEFF3__C__SHIFT 0x0
#define TMON1_TEMP_CALC_COEFF4__K_MASK 0x1
#define TMON1_TEMP_CALC_COEFF4__K__SHIFT 0x0
#define TMON1_DEBUG0__DEBUG_Z_MASK 0x7ff
#define TMON1_DEBUG0__DEBUG_Z__SHIFT 0x0
#define TMON1_DEBUG0__DEBUG_Z_EN_MASK 0x800
#define TMON1_DEBUG0__DEBUG_Z_EN__SHIFT 0xb
#define TMON1_DEBUG1__DEBUG_RDI_MASK 0x1f
#define TMON1_DEBUG1__DEBUG_RDI__SHIFT 0x0
#define THM_TMON0_REMOTE_START__DATA_MASK 0xffffffff
#define THM_TMON0_REMOTE_START__DATA__SHIFT 0x0
#define THM_TMON0_REMOTE_END__DATA_MASK 0xffffffff
#define THM_TMON0_REMOTE_END__DATA__SHIFT 0x0
#define THM_TMON1_REMOTE_START__DATA_MASK 0xffffffff
#define THM_TMON1_REMOTE_START__DATA__SHIFT 0x0
#define THM_TMON1_REMOTE_END__DATA_MASK 0xffffffff
#define THM_TMON1_REMOTE_END__DATA__SHIFT 0x0
#define THM_TCON_LOCAL0__HaltPolling_MASK 0x1
#define THM_TCON_LOCAL0__HaltPolling__SHIFT 0x0
#define THM_TCON_LOCAL0__TMON0_PwrDn_Dis_MASK 0x2
#define THM_TCON_LOCAL0__TMON0_PwrDn_Dis__SHIFT 0x1
#define THM_TCON_LOCAL0__TMON1_PwrDn_Dis_MASK 0x4
#define THM_TCON_LOCAL0__TMON1_PwrDn_Dis__SHIFT 0x2
#define THM_TCON_LOCAL1__PwrDn_Limit_Temp_MASK 0x7
#define THM_TCON_LOCAL1__PwrDn_Limit_Temp__SHIFT 0x0
#define THM_TCON_LOCAL1__PwrDn_DelaySlope_MASK 0x38
#define THM_TCON_LOCAL1__PwrDn_DelaySlope__SHIFT 0x3
#define THM_TCON_LOCAL1__PwrDn_MinDelay_MASK 0x1c0
#define THM_TCON_LOCAL1__PwrDn_MinDelay__SHIFT 0x6
#define THM_TCON_LOCAL2__PwrDn_MaxDlyMult_MASK 0x3
#define THM_TCON_LOCAL2__PwrDn_MaxDlyMult__SHIFT 0x0
#define THM_TCON_LOCAL2__PwrDn_NumSensors_MASK 0xc
#define THM_TCON_LOCAL2__PwrDn_NumSensors__SHIFT 0x2
#define THM_TCON_LOCAL2__start_mission_polling_MASK 0x10
#define THM_TCON_LOCAL2__start_mission_polling__SHIFT 0x4
#define THM_TCON_LOCAL2__short_stagger_count_MASK 0x20
#define THM_TCON_LOCAL2__short_stagger_count__SHIFT 0x5
#define THM_TCON_LOCAL2__sbtsi_use_corrected_MASK 0x40
#define THM_TCON_LOCAL2__sbtsi_use_corrected__SHIFT 0x6
#define THM_TCON_LOCAL2__csrslave_use_corrected_MASK 0x80
#define THM_TCON_LOCAL2__csrslave_use_corrected__SHIFT 0x7
#define THM_TCON_LOCAL2__smu_use_corrected_MASK 0x100
#define THM_TCON_LOCAL2__smu_use_corrected__SHIFT 0x8
#define THM_TCON_LOCAL2__skip_scale_correction_MASK 0x800
#define THM_TCON_LOCAL2__skip_scale_correction__SHIFT 0xb
#define THM_TCON_LOCAL3__Global_TMAX_MASK 0x7ff
#define THM_TCON_LOCAL3__Global_TMAX__SHIFT 0x0
#define THM_TCON_LOCAL4__Global_TMAX_ID_MASK 0xff
#define THM_TCON_LOCAL4__Global_TMAX_ID__SHIFT 0x0
#define THM_TCON_LOCAL5__Global_TMIN_MASK 0x7ff
#define THM_TCON_LOCAL5__Global_TMIN__SHIFT 0x0
#define THM_TCON_LOCAL6__Global_TMIN_ID_MASK 0xff
#define THM_TCON_LOCAL6__Global_TMIN_ID__SHIFT 0x0
#define THM_TCON_LOCAL7__THERMID_MASK 0xff
#define THM_TCON_LOCAL7__THERMID__SHIFT 0x0
#define THM_TCON_LOCAL8__THERMMAX_MASK 0x7ff
#define THM_TCON_LOCAL8__THERMMAX__SHIFT 0x0
#define THM_TCON_LOCAL9__Tj_Max_TMON0_MASK 0x7ff
#define THM_TCON_LOCAL9__Tj_Max_TMON0__SHIFT 0x0
#define THM_TCON_LOCAL10__TMON0_Tj_Max_RS_ID_MASK 0xf
#define THM_TCON_LOCAL10__TMON0_Tj_Max_RS_ID__SHIFT 0x0
#define THM_TCON_LOCAL11__Tj_Max_TMON1_MASK 0x7ff
#define THM_TCON_LOCAL11__Tj_Max_TMON1__SHIFT 0x0
#define THM_TCON_LOCAL12__TMON1_Tj_Max_RS_ID_MASK 0xf
#define THM_TCON_LOCAL12__TMON1_Tj_Max_RS_ID__SHIFT 0x0
#define THM_TCON_LOCAL13__PowerDownTmon0_MASK 0x1
#define THM_TCON_LOCAL13__PowerDownTmon0__SHIFT 0x0
#define THM_TCON_LOCAL13__PowerDownTmon1_MASK 0x2
#define THM_TCON_LOCAL13__PowerDownTmon1__SHIFT 0x1
#define THM_TCON_LOCAL14__boot_done_MASK 0x1
#define THM_TCON_LOCAL14__boot_done__SHIFT 0x0
#define THM_FUSE0__FUSE_TmonRsInterleave_MASK 0x1
#define THM_FUSE0__FUSE_TmonRsInterleave__SHIFT 0x0
#define THM_FUSE0__FUSE_TmonNumAcq_MASK 0xe
#define THM_FUSE0__FUSE_TmonNumAcq__SHIFT 0x1
#define THM_FUSE0__FUSE_TmonForceMaxAcq_MASK 0x10
#define THM_FUSE0__FUSE_TmonForceMaxAcq__SHIFT 0x4
#define THM_FUSE0__FUSE_TmonClkDiv_MASK 0x60
#define THM_FUSE0__FUSE_TmonClkDiv__SHIFT 0x5
#define THM_FUSE0__FUSE_TmonBGAdj1_MASK 0x7f80
#define THM_FUSE0__FUSE_TmonBGAdj1__SHIFT 0x7
#define THM_FUSE0__FUSE_TmonBGAdj0_MASK 0x7f8000
#define THM_FUSE0__FUSE_TmonBGAdj0__SHIFT 0xf
#define THM_FUSE0__FUSE_TconZtValue_MASK 0xff800000
#define THM_FUSE0__FUSE_TconZtValue__SHIFT 0x17
#define THM_FUSE1__FUSE_TconZtValue_MASK 0x3
#define THM_FUSE1__FUSE_TconZtValue__SHIFT 0x0
#define THM_FUSE1__FUSE_TconUseSecondary_MASK 0xc
#define THM_FUSE1__FUSE_TconUseSecondary__SHIFT 0x2
#define THM_FUSE1__FUSE_TconTmpAdjLoRes_MASK 0x10
#define THM_FUSE1__FUSE_TconTmpAdjLoRes__SHIFT 0x4
#define THM_FUSE1__FUSE_TconPwrUpStaggerTime_MASK 0x60
#define THM_FUSE1__FUSE_TconPwrUpStaggerTime__SHIFT 0x5
#define THM_FUSE1__FUSE_TconPwrDnTmpLmt_MASK 0x380
#define THM_FUSE1__FUSE_TconPwrDnTmpLmt__SHIFT 0x7
#define THM_FUSE1__FUSE_TconPwrDnNumSensors_MASK 0xc00
#define THM_FUSE1__FUSE_TconPwrDnNumSensors__SHIFT 0xa
#define THM_FUSE1__FUSE_TconPwrDnMinDelay_MASK 0x7000
#define THM_FUSE1__FUSE_TconPwrDnMinDelay__SHIFT 0xc
#define THM_FUSE1__FUSE_TconPwrDnMaxDelayMult_MASK 0x18000
#define THM_FUSE1__FUSE_TconPwrDnMaxDelayMult__SHIFT 0xf
#define THM_FUSE1__FUSE_TconPwrDnDelaySlope_MASK 0xe0000
#define THM_FUSE1__FUSE_TconPwrDnDelaySlope__SHIFT 0x11
#define THM_FUSE1__FUSE_TconKValue_MASK 0x100000
#define THM_FUSE1__FUSE_TconKValue__SHIFT 0x14
#define THM_FUSE1__FUSE_TconDtValue31_MASK 0x7e00000
#define THM_FUSE1__FUSE_TconDtValue31__SHIFT 0x15
#define THM_FUSE1__FUSE_TconDtValue30_MASK 0xf8000000
#define THM_FUSE1__FUSE_TconDtValue30__SHIFT 0x1b
#define THM_FUSE2__FUSE_TconDtValue30_MASK 0x1
#define THM_FUSE2__FUSE_TconDtValue30__SHIFT 0x0
#define THM_FUSE2__FUSE_TconDtValue29_MASK 0x7e
#define THM_FUSE2__FUSE_TconDtValue29__SHIFT 0x1
#define THM_FUSE2__FUSE_TconDtValue28_MASK 0x1f80
#define THM_FUSE2__FUSE_TconDtValue28__SHIFT 0x7
#define THM_FUSE2__FUSE_TconDtValue27_MASK 0x7e000
#define THM_FUSE2__FUSE_TconDtValue27__SHIFT 0xd
#define THM_FUSE2__FUSE_TconDtValue26_MASK 0x1f80000
#define THM_FUSE2__FUSE_TconDtValue26__SHIFT 0x13
#define THM_FUSE2__FUSE_TconDtValue25_MASK 0x7e000000
#define THM_FUSE2__FUSE_TconDtValue25__SHIFT 0x19
#define THM_FUSE2__FUSE_TconDtValue24_MASK 0x80000000
#define THM_FUSE2__FUSE_TconDtValue24__SHIFT 0x1f
#define THM_FUSE3__FUSE_TconDtValue24_MASK 0x1f
#define THM_FUSE3__FUSE_TconDtValue24__SHIFT 0x0
#define THM_FUSE3__FUSE_TconDtValue23_MASK 0x7e0
#define THM_FUSE3__FUSE_TconDtValue23__SHIFT 0x5
#define THM_FUSE3__FUSE_TconDtValue22_MASK 0x1f800
#define THM_FUSE3__FUSE_TconDtValue22__SHIFT 0xb
#define THM_FUSE3__FUSE_TconDtValue21_MASK 0x7e0000
#define THM_FUSE3__FUSE_TconDtValue21__SHIFT 0x11
#define THM_FUSE3__FUSE_TconDtValue20_MASK 0x1f800000
#define THM_FUSE3__FUSE_TconDtValue20__SHIFT 0x17
#define THM_FUSE3__FUSE_TconDtValue19_MASK 0xe0000000
#define THM_FUSE3__FUSE_TconDtValue19__SHIFT 0x1d
#define THM_FUSE4__FUSE_TconDtValue19_MASK 0x7
#define THM_FUSE4__FUSE_TconDtValue19__SHIFT 0x0
#define THM_FUSE4__FUSE_TconDtValue18_MASK 0x1f8
#define THM_FUSE4__FUSE_TconDtValue18__SHIFT 0x3
#define THM_FUSE4__FUSE_TconDtValue17_MASK 0x7e00
#define THM_FUSE4__FUSE_TconDtValue17__SHIFT 0x9
#define THM_FUSE4__FUSE_TconDtValue16_MASK 0x1f8000
#define THM_FUSE4__FUSE_TconDtValue16__SHIFT 0xf
#define THM_FUSE4__FUSE_TconDtValue15_MASK 0x7e00000
#define THM_FUSE4__FUSE_TconDtValue15__SHIFT 0x15
#define THM_FUSE4__FUSE_TconDtValue14_MASK 0xf8000000
#define THM_FUSE4__FUSE_TconDtValue14__SHIFT 0x1b
#define THM_FUSE5__FUSE_TconDtValue14_MASK 0x1
#define THM_FUSE5__FUSE_TconDtValue14__SHIFT 0x0
#define THM_FUSE5__FUSE_TconDtValue13_MASK 0x7e
#define THM_FUSE5__FUSE_TconDtValue13__SHIFT 0x1
#define THM_FUSE5__FUSE_TconDtValue12_MASK 0x1f80
#define THM_FUSE5__FUSE_TconDtValue12__SHIFT 0x7
#define THM_FUSE5__FUSE_TconDtValue11_MASK 0x7e000
#define THM_FUSE5__FUSE_TconDtValue11__SHIFT 0xd
#define THM_FUSE5__FUSE_TconDtValue10_MASK 0x1f80000
#define THM_FUSE5__FUSE_TconDtValue10__SHIFT 0x13
#define THM_FUSE5__FUSE_TconDtValue9_MASK 0x7e000000
#define THM_FUSE5__FUSE_TconDtValue9__SHIFT 0x19
#define THM_FUSE5__FUSE_TconDtValue8_MASK 0x80000000
#define THM_FUSE5__FUSE_TconDtValue8__SHIFT 0x1f
#define THM_FUSE6__FUSE_TconDtValue8_MASK 0x1f
#define THM_FUSE6__FUSE_TconDtValue8__SHIFT 0x0
#define THM_FUSE6__FUSE_TconDtValue7_MASK 0x7e0
#define THM_FUSE6__FUSE_TconDtValue7__SHIFT 0x5
#define THM_FUSE6__FUSE_TconDtValue6_MASK 0x1f800
#define THM_FUSE6__FUSE_TconDtValue6__SHIFT 0xb
#define THM_FUSE6__FUSE_TconDtValue5_MASK 0x7e0000
#define THM_FUSE6__FUSE_TconDtValue5__SHIFT 0x11
#define THM_FUSE6__FUSE_TconDtValue4_MASK 0x1f800000
#define THM_FUSE6__FUSE_TconDtValue4__SHIFT 0x17
#define THM_FUSE6__FUSE_TconDtValue3_MASK 0xe0000000
#define THM_FUSE6__FUSE_TconDtValue3__SHIFT 0x1d
#define THM_FUSE7__FUSE_TconDtValue3_MASK 0x7
#define THM_FUSE7__FUSE_TconDtValue3__SHIFT 0x0
#define THM_FUSE7__FUSE_TconDtValue2_MASK 0x1f8
#define THM_FUSE7__FUSE_TconDtValue2__SHIFT 0x3
#define THM_FUSE7__FUSE_TconDtValue1_MASK 0x7e00
#define THM_FUSE7__FUSE_TconDtValue1__SHIFT 0x9
#define THM_FUSE7__FUSE_TconDtValue0_MASK 0x1f8000
#define THM_FUSE7__FUSE_TconDtValue0__SHIFT 0xf
#define THM_FUSE7__FUSE_TconCtValue1_MASK 0xffe00000
#define THM_FUSE7__FUSE_TconCtValue1__SHIFT 0x15
#define THM_FUSE8__FUSE_TconCtValue0_MASK 0x7ff
#define THM_FUSE8__FUSE_TconCtValue0__SHIFT 0x0
#define THM_FUSE8__FUSE_TconBtValue_MASK 0x1f800
#define THM_FUSE8__FUSE_TconBtValue__SHIFT 0xb
#define THM_FUSE8__FUSE_TconBootDelay_MASK 0x60000
#define THM_FUSE8__FUSE_TconBootDelay__SHIFT 0x11
#define THM_FUSE8__FUSE_TconAtValue1_MASK 0x7ff80000
#define THM_FUSE8__FUSE_TconAtValue1__SHIFT 0x13
#define THM_FUSE8__FUSE_TconAtValue0_MASK 0x80000000
#define THM_FUSE8__FUSE_TconAtValue0__SHIFT 0x1f
#define THM_FUSE9__FUSE_TconAtValue0_MASK 0x7ff
#define THM_FUSE9__FUSE_TconAtValue0__SHIFT 0x0
#define THM_FUSE9__FUSE_ThermTripLimit_MASK 0x7f800
#define THM_FUSE9__FUSE_ThermTripLimit__SHIFT 0xb
#define THM_FUSE9__FUSE_ThermTripEn_MASK 0x80000
#define THM_FUSE9__FUSE_ThermTripEn__SHIFT 0x13
#define THM_FUSE9__FUSE_HtcTmpLmt_MASK 0x7f00000
#define THM_FUSE9__FUSE_HtcTmpLmt__SHIFT 0x14
#define THM_FUSE9__FUSE_HtcMsrLock_MASK 0x8000000
#define THM_FUSE9__FUSE_HtcMsrLock__SHIFT 0x1b
#define THM_FUSE9__FUSE_HtcHystLmt_MASK 0xf0000000
#define THM_FUSE9__FUSE_HtcHystLmt__SHIFT 0x1c
#define THM_FUSE10__FUSE_HtcDis_MASK 0x1
#define THM_FUSE10__FUSE_HtcDis__SHIFT 0x0
#define THM_FUSE10__FUSE_HtcClkInact_MASK 0xe
#define THM_FUSE10__FUSE_HtcClkInact__SHIFT 0x1
#define THM_FUSE10__FUSE_HtcClkAct_MASK 0x70
#define THM_FUSE10__FUSE_HtcClkAct__SHIFT 0x4
#define THM_FUSE10__FUSE_UnusedBits_MASK 0xffffff80
#define THM_FUSE10__FUSE_UnusedBits__SHIFT 0x7
#define THM_FUSE11__PA_SPARE_MASK 0xff
#define THM_FUSE11__PA_SPARE__SHIFT 0x0
#define THM_FUSE12__FusesValid_MASK 0x1
#define THM_FUSE12__FusesValid__SHIFT 0x0
#define MP0PUB_IND_INDEX__MP0PUB_IND_ADDR_MASK 0xffffffff
#define MP0PUB_IND_INDEX__MP0PUB_IND_ADDR__SHIFT 0x0
#define MP0PUB_IND_DATA__MP0PUB_IND_DATA_MASK 0xffffffff
#define MP0PUB_IND_DATA__MP0PUB_IND_DATA__SHIFT 0x0
#define MP0PUB_IND_INDEX_0__MP0PUB_IND_ADDR_MASK 0xffffffff
#define MP0PUB_IND_INDEX_0__MP0PUB_IND_ADDR__SHIFT 0x0
#define MP0PUB_IND_DATA_0__MP0PUB_IND_DATA_MASK 0xffffffff
#define MP0PUB_IND_DATA_0__MP0PUB_IND_DATA__SHIFT 0x0
#define MP0PUB_IND_INDEX_1__MP0PUB_IND_ADDR_MASK 0xffffffff
#define MP0PUB_IND_INDEX_1__MP0PUB_IND_ADDR__SHIFT 0x0
#define MP0PUB_IND_DATA_1__MP0PUB_IND_DATA_MASK 0xffffffff
#define MP0PUB_IND_DATA_1__MP0PUB_IND_DATA__SHIFT 0x0
#define MP0PUB_IND_INDEX_2__MP0PUB_IND_ADDR_MASK 0xffffffff
#define MP0PUB_IND_INDEX_2__MP0PUB_IND_ADDR__SHIFT 0x0
#define MP0PUB_IND_DATA_2__MP0PUB_IND_DATA_MASK 0xffffffff
#define MP0PUB_IND_DATA_2__MP0PUB_IND_DATA__SHIFT 0x0
#define MP0PUB_IND_INDEX_3__MP0PUB_IND_ADDR_MASK 0xffffffff
#define MP0PUB_IND_INDEX_3__MP0PUB_IND_ADDR__SHIFT 0x0
#define MP0PUB_IND_DATA_3__MP0PUB_IND_DATA_MASK 0xffffffff
#define MP0PUB_IND_DATA_3__MP0PUB_IND_DATA__SHIFT 0x0
#define MP0PUB_IND_INDEX_4__MP0PUB_IND_ADDR_MASK 0xffffffff
#define MP0PUB_IND_INDEX_4__MP0PUB_IND_ADDR__SHIFT 0x0
#define MP0PUB_IND_DATA_4__MP0PUB_IND_DATA_MASK 0xffffffff
#define MP0PUB_IND_DATA_4__MP0PUB_IND_DATA__SHIFT 0x0
#define MP0PUB_IND_INDEX_5__MP0PUB_IND_ADDR_MASK 0xffffffff
#define MP0PUB_IND_INDEX_5__MP0PUB_IND_ADDR__SHIFT 0x0
#define MP0PUB_IND_DATA_5__MP0PUB_IND_DATA_MASK 0xffffffff
#define MP0PUB_IND_DATA_5__MP0PUB_IND_DATA__SHIFT 0x0
#define MP0PUB_IND_INDEX_6__MP0PUB_IND_ADDR_MASK 0xffffffff
#define MP0PUB_IND_INDEX_6__MP0PUB_IND_ADDR__SHIFT 0x0
#define MP0PUB_IND_DATA_6__MP0PUB_IND_DATA_MASK 0xffffffff
#define MP0PUB_IND_DATA_6__MP0PUB_IND_DATA__SHIFT 0x0
#define MP0PUB_IND_INDEX_7__MP0PUB_IND_ADDR_MASK 0xffffffff
#define MP0PUB_IND_INDEX_7__MP0PUB_IND_ADDR__SHIFT 0x0
#define MP0PUB_IND_DATA_7__MP0PUB_IND_DATA_MASK 0xffffffff
#define MP0PUB_IND_DATA_7__MP0PUB_IND_DATA__SHIFT 0x0
#define MP0PUB_IND_INDEX_8__MP0PUB_IND_ADDR_MASK 0xffffffff
#define MP0PUB_IND_INDEX_8__MP0PUB_IND_ADDR__SHIFT 0x0
#define MP0PUB_IND_DATA_8__MP0PUB_IND_DATA_MASK 0xffffffff
#define MP0PUB_IND_DATA_8__MP0PUB_IND_DATA__SHIFT 0x0
#define MP0PUB_IND_INDEX_9__MP0PUB_IND_ADDR_MASK 0xffffffff
#define MP0PUB_IND_INDEX_9__MP0PUB_IND_ADDR__SHIFT 0x0
#define MP0PUB_IND_DATA_9__MP0PUB_IND_DATA_MASK 0xffffffff
#define MP0PUB_IND_DATA_9__MP0PUB_IND_DATA__SHIFT 0x0
#define MP0PUB_IND_INDEX_10__MP0PUB_IND_ADDR_MASK 0xffffffff
#define MP0PUB_IND_INDEX_10__MP0PUB_IND_ADDR__SHIFT 0x0
#define MP0PUB_IND_DATA_10__MP0PUB_IND_DATA_MASK 0xffffffff
#define MP0PUB_IND_DATA_10__MP0PUB_IND_DATA__SHIFT 0x0
#define MP0PUB_IND_INDEX_11__MP0PUB_IND_ADDR_MASK 0xffffffff
#define MP0PUB_IND_INDEX_11__MP0PUB_IND_ADDR__SHIFT 0x0
#define MP0PUB_IND_DATA_11__MP0PUB_IND_DATA_MASK 0xffffffff
#define MP0PUB_IND_DATA_11__MP0PUB_IND_DATA__SHIFT 0x0
#define MP0PUB_IND_INDEX_12__MP0PUB_IND_ADDR_MASK 0xffffffff
#define MP0PUB_IND_INDEX_12__MP0PUB_IND_ADDR__SHIFT 0x0
#define MP0PUB_IND_DATA_12__MP0PUB_IND_DATA_MASK 0xffffffff
#define MP0PUB_IND_DATA_12__MP0PUB_IND_DATA__SHIFT 0x0
#define MP0PUB_IND_INDEX_13__MP0PUB_IND_ADDR_MASK 0xffffffff
#define MP0PUB_IND_INDEX_13__MP0PUB_IND_ADDR__SHIFT 0x0
#define MP0PUB_IND_DATA_13__MP0PUB_IND_DATA_MASK 0xffffffff
#define MP0PUB_IND_DATA_13__MP0PUB_IND_DATA__SHIFT 0x0
#define MP0PUB_IND_INDEX_14__MP0PUB_IND_ADDR_MASK 0xffffffff
#define MP0PUB_IND_INDEX_14__MP0PUB_IND_ADDR__SHIFT 0x0
#define MP0PUB_IND_DATA_14__MP0PUB_IND_DATA_MASK 0xffffffff
#define MP0PUB_IND_DATA_14__MP0PUB_IND_DATA__SHIFT 0x0
#define MP0PUB_IND_INDEX_15__MP0PUB_IND_ADDR_MASK 0xffffffff
#define MP0PUB_IND_INDEX_15__MP0PUB_IND_ADDR__SHIFT 0x0
#define MP0PUB_IND_DATA_15__MP0PUB_IND_DATA_MASK 0xffffffff
#define MP0PUB_IND_DATA_15__MP0PUB_IND_DATA__SHIFT 0x0
#define MP0_IND_ACCESS_CNTL__AUTO_INCREMENT_IND_0_MASK 0x1
#define MP0_IND_ACCESS_CNTL__AUTO_INCREMENT_IND_0__SHIFT 0x0
#define MP0_IND_ACCESS_CNTL__AUTO_INCREMENT_IND_1_MASK 0x2
#define MP0_IND_ACCESS_CNTL__AUTO_INCREMENT_IND_1__SHIFT 0x1
#define MP0_IND_ACCESS_CNTL__AUTO_INCREMENT_IND_2_MASK 0x4
#define MP0_IND_ACCESS_CNTL__AUTO_INCREMENT_IND_2__SHIFT 0x2
#define MP0_IND_ACCESS_CNTL__AUTO_INCREMENT_IND_3_MASK 0x8
#define MP0_IND_ACCESS_CNTL__AUTO_INCREMENT_IND_3__SHIFT 0x3
#define MP0_IND_ACCESS_CNTL__AUTO_INCREMENT_IND_4_MASK 0x10
#define MP0_IND_ACCESS_CNTL__AUTO_INCREMENT_IND_4__SHIFT 0x4
#define MP0_IND_ACCESS_CNTL__AUTO_INCREMENT_IND_5_MASK 0x20
#define MP0_IND_ACCESS_CNTL__AUTO_INCREMENT_IND_5__SHIFT 0x5
#define MP0_IND_ACCESS_CNTL__AUTO_INCREMENT_IND_6_MASK 0x40
#define MP0_IND_ACCESS_CNTL__AUTO_INCREMENT_IND_6__SHIFT 0x6
#define MP0_IND_ACCESS_CNTL__AUTO_INCREMENT_IND_7_MASK 0x80
#define MP0_IND_ACCESS_CNTL__AUTO_INCREMENT_IND_7__SHIFT 0x7
#define MP0_IND_ACCESS_CNTL__AUTO_INCREMENT_IND_8_MASK 0x100
#define MP0_IND_ACCESS_CNTL__AUTO_INCREMENT_IND_8__SHIFT 0x8
#define MP0_IND_ACCESS_CNTL__AUTO_INCREMENT_IND_9_MASK 0x200
#define MP0_IND_ACCESS_CNTL__AUTO_INCREMENT_IND_9__SHIFT 0x9
#define MP0_IND_ACCESS_CNTL__AUTO_INCREMENT_IND_10_MASK 0x400
#define MP0_IND_ACCESS_CNTL__AUTO_INCREMENT_IND_10__SHIFT 0xa
#define MP0_IND_ACCESS_CNTL__AUTO_INCREMENT_IND_11_MASK 0x800
#define MP0_IND_ACCESS_CNTL__AUTO_INCREMENT_IND_11__SHIFT 0xb
#define MP0_IND_ACCESS_CNTL__AUTO_INCREMENT_IND_12_MASK 0x1000
#define MP0_IND_ACCESS_CNTL__AUTO_INCREMENT_IND_12__SHIFT 0xc
#define MP0_IND_ACCESS_CNTL__AUTO_INCREMENT_IND_13_MASK 0x2000
#define MP0_IND_ACCESS_CNTL__AUTO_INCREMENT_IND_13__SHIFT 0xd
#define MP0_IND_ACCESS_CNTL__AUTO_INCREMENT_IND_14_MASK 0x4000
#define MP0_IND_ACCESS_CNTL__AUTO_INCREMENT_IND_14__SHIFT 0xe
#define MP0_IND_ACCESS_CNTL__AUTO_INCREMENT_IND_15_MASK 0x8000
#define MP0_IND_ACCESS_CNTL__AUTO_INCREMENT_IND_15__SHIFT 0xf
#define MP0_MSP_MESSAGE_0__MP0_MSP_MSG_MASK 0xffffffff
#define MP0_MSP_MESSAGE_0__MP0_MSP_MSG__SHIFT 0x0
#define MP0_MSP_MESSAGE_1__MP0_MSP_MSG_MASK 0xffffffff
#define MP0_MSP_MESSAGE_1__MP0_MSP_MSG__SHIFT 0x0
#define MP0_MSP_MESSAGE_2__MP0_MSP_MSG_MASK 0xffffffff
#define MP0_MSP_MESSAGE_2__MP0_MSP_MSG__SHIFT 0x0
#define MP0_MSP_MESSAGE_3__MP0_MSP_MSG_MASK 0xffffffff
#define MP0_MSP_MESSAGE_3__MP0_MSP_MSG__SHIFT 0x0
#define MP0_MSP_MESSAGE_4__MP0_MSP_MSG_MASK 0xffffffff
#define MP0_MSP_MESSAGE_4__MP0_MSP_MSG__SHIFT 0x0
#define MP0_MSP_MESSAGE_5__MP0_MSP_MSG_MASK 0xffffffff
#define MP0_MSP_MESSAGE_5__MP0_MSP_MSG__SHIFT 0x0
#define MP0_MSP_MESSAGE_6__MP0_MSP_MSG_MASK 0xffffffff
#define MP0_MSP_MESSAGE_6__MP0_MSP_MSG__SHIFT 0x0
#define MP0_MSP_MESSAGE_7__MP0_MSP_MSG_MASK 0xffffffff
#define MP0_MSP_MESSAGE_7__MP0_MSP_MSG__SHIFT 0x0
#define SAM_IH_EXT_ERR_INTR__UVD_MASK 0x1
#define SAM_IH_EXT_ERR_INTR__UVD__SHIFT 0x0
#define SAM_IH_EXT_ERR_INTR__VCE_MASK 0x2
#define SAM_IH_EXT_ERR_INTR__VCE__SHIFT 0x1
#define SAM_IH_EXT_ERR_INTR__ISP_MASK 0x4
#define SAM_IH_EXT_ERR_INTR__ISP__SHIFT 0x2
#define SAM_IH_EXT_ERR_INTR__RESERVED_MASK 0xfffffff8
#define SAM_IH_EXT_ERR_INTR__RESERVED__SHIFT 0x3
#define SAM_IH_EXT_ERR_INTR_STATUS__UVD_MASK 0x1
#define SAM_IH_EXT_ERR_INTR_STATUS__UVD__SHIFT 0x0
#define SAM_IH_EXT_ERR_INTR_STATUS__VCE_MASK 0x2
#define SAM_IH_EXT_ERR_INTR_STATUS__VCE__SHIFT 0x1
#define SAM_IH_EXT_ERR_INTR_STATUS__ISP_MASK 0x4
#define SAM_IH_EXT_ERR_INTR_STATUS__ISP__SHIFT 0x2
#define SAM_IH_EXT_ERR_INTR_STATUS__RESERVED_MASK 0xfffffff8
#define SAM_IH_EXT_ERR_INTR_STATUS__RESERVED__SHIFT 0x3
#define MP0_DISP_TIMER0_CTRL0__START_MASK 0x1
#define MP0_DISP_TIMER0_CTRL0__START__SHIFT 0x0
#define MP0_DISP_TIMER0_CTRL0__CLEAR_MASK 0x100
#define MP0_DISP_TIMER0_CTRL0__CLEAR__SHIFT 0x8
#define MP0_DISP_TIMER0_CTRL0__DEC_MASK 0x10000
#define MP0_DISP_TIMER0_CTRL0__DEC__SHIFT 0x10
#define MP0_DISP_TIMER0_CTRL0__PULSE_COUNT_MODE_MASK 0x1000000
#define MP0_DISP_TIMER0_CTRL0__PULSE_COUNT_MODE__SHIFT 0x18
#define MP0_DISP_TIMER0_CTRL1__PWM_OUTPUT_EN_MASK 0x1
#define MP0_DISP_TIMER0_CTRL1__PWM_OUTPUT_EN__SHIFT 0x0
#define MP0_DISP_TIMER0_CTRL1__TIME_SLICE_MODE_EN_MASK 0x100
#define MP0_DISP_TIMER0_CTRL1__TIME_SLICE_MODE_EN__SHIFT 0x8
#define MP0_DISP_TIMER0_CTRL1__TIMER_SATURATION_EN_MASK 0x10000
#define MP0_DISP_TIMER0_CTRL1__TIMER_SATURATION_EN__SHIFT 0x10
#define MP0_DISP_TIMER0_CTRL1__RESERVED_MASK 0xff000000
#define MP0_DISP_TIMER0_CTRL1__RESERVED__SHIFT 0x18
#define MP0_DISP_TIMER0_CMP_AUTOINC__AUTOINC_MASK 0xf
#define MP0_DISP_TIMER0_CMP_AUTOINC__AUTOINC__SHIFT 0x0
#define MP0_DISP_TIMER0_CMP_AUTOINC__RESERVED_MASK 0xfffffff0
#define MP0_DISP_TIMER0_CMP_AUTOINC__RESERVED__SHIFT 0x4
#define MP0_DISP_TIMER0_INTEN__INTEN_MASK 0xf
#define MP0_DISP_TIMER0_INTEN__INTEN__SHIFT 0x0
#define MP0_DISP_TIMER0_INTEN__RESERVED_MASK 0xfffffff0
#define MP0_DISP_TIMER0_INTEN__RESERVED__SHIFT 0x4
#define MP0_DISP_TIMER0_OCMP_0_0__OCMP_MASK 0xffffffff
#define MP0_DISP_TIMER0_OCMP_0_0__OCMP__SHIFT 0x0
#define MP0_DISP_TIMER0_OCMP_0_1__OCMP_MASK 0xffffffff
#define MP0_DISP_TIMER0_OCMP_0_1__OCMP__SHIFT 0x0
#define MP0_DISP_TIMER0_CNT__COUNT_MASK 0xffffffff
#define MP0_DISP_TIMER0_CNT__COUNT__SHIFT 0x0
#define MP0_DISP_TIMER1_CTRL0__START_MASK 0x1
#define MP0_DISP_TIMER1_CTRL0__START__SHIFT 0x0
#define MP0_DISP_TIMER1_CTRL0__CLEAR_MASK 0x100
#define MP0_DISP_TIMER1_CTRL0__CLEAR__SHIFT 0x8
#define MP0_DISP_TIMER1_CTRL0__DEC_MASK 0x10000
#define MP0_DISP_TIMER1_CTRL0__DEC__SHIFT 0x10
#define MP0_DISP_TIMER1_CTRL0__PULSE_COUNT_MODE_MASK 0x1000000
#define MP0_DISP_TIMER1_CTRL0__PULSE_COUNT_MODE__SHIFT 0x18
#define MP0_DISP_TIMER1_CTRL1__PWM_OUTPUT_EN_MASK 0x1
#define MP0_DISP_TIMER1_CTRL1__PWM_OUTPUT_EN__SHIFT 0x0
#define MP0_DISP_TIMER1_CTRL1__TIME_SLICE_MODE_EN_MASK 0x100
#define MP0_DISP_TIMER1_CTRL1__TIME_SLICE_MODE_EN__SHIFT 0x8
#define MP0_DISP_TIMER1_CTRL1__TIMER_SATURATION_EN_MASK 0x10000
#define MP0_DISP_TIMER1_CTRL1__TIMER_SATURATION_EN__SHIFT 0x10
#define MP0_DISP_TIMER1_CTRL1__RESERVED_MASK 0xff000000
#define MP0_DISP_TIMER1_CTRL1__RESERVED__SHIFT 0x18
#define MP0_DISP_TIMER1_CMP_AUTOINC__AUTOINC_MASK 0xf
#define MP0_DISP_TIMER1_CMP_AUTOINC__AUTOINC__SHIFT 0x0
#define MP0_DISP_TIMER1_CMP_AUTOINC__RESERVED_MASK 0xfffffff0
#define MP0_DISP_TIMER1_CMP_AUTOINC__RESERVED__SHIFT 0x4
#define MP0_DISP_TIMER1_INTEN__INTEN_MASK 0xf
#define MP0_DISP_TIMER1_INTEN__INTEN__SHIFT 0x0
#define MP0_DISP_TIMER1_INTEN__RESERVED_MASK 0xfffffff0
#define MP0_DISP_TIMER1_INTEN__RESERVED__SHIFT 0x4
#define MP0_DISP_TIMER1_OCMP_0_0__OCMP_MASK 0xffffffff
#define MP0_DISP_TIMER1_OCMP_0_0__OCMP__SHIFT 0x0
#define MP0_DISP_TIMER1_OCMP_0_1__OCMP_MASK 0xffffffff
#define MP0_DISP_TIMER1_OCMP_0_1__OCMP__SHIFT 0x0
#define MP0_DISP_TIMER1_CNT__COUNT_MASK 0xffffffff
#define MP0_DISP_TIMER1_CNT__COUNT__SHIFT 0x0
#define SMU_MP1_SRBM2P_MSG_0__CONTENT_MASK 0xffffffff
#define SMU_MP1_SRBM2P_MSG_0__CONTENT__SHIFT 0x0
#define SMU_MP1_SRBM2P_MSG_1__CONTENT_MASK 0xffffffff
#define SMU_MP1_SRBM2P_MSG_1__CONTENT__SHIFT 0x0
#define SMU_MP1_SRBM2P_MSG_2__CONTENT_MASK 0xffffffff
#define SMU_MP1_SRBM2P_MSG_2__CONTENT__SHIFT 0x0
#define SMU_MP1_SRBM2P_MSG_3__CONTENT_MASK 0xffffffff
#define SMU_MP1_SRBM2P_MSG_3__CONTENT__SHIFT 0x0
#define SMU_MP1_SRBM2P_MSG_4__CONTENT_MASK 0xffffffff
#define SMU_MP1_SRBM2P_MSG_4__CONTENT__SHIFT 0x0
#define SMU_MP1_SRBM2P_MSG_5__CONTENT_MASK 0xffffffff
#define SMU_MP1_SRBM2P_MSG_5__CONTENT__SHIFT 0x0
#define SMU_MP1_SRBM2P_MSG_6__CONTENT_MASK 0xffffffff
#define SMU_MP1_SRBM2P_MSG_6__CONTENT__SHIFT 0x0
#define SMU_MP1_SRBM2P_MSG_7__CONTENT_MASK 0xffffffff
#define SMU_MP1_SRBM2P_MSG_7__CONTENT__SHIFT 0x0
#define SMU_MP1_SRBM2P_MSG_8__CONTENT_MASK 0xffffffff
#define SMU_MP1_SRBM2P_MSG_8__CONTENT__SHIFT 0x0
#define SMU_MP1_SRBM2P_MSG_9__CONTENT_MASK 0xffffffff
#define SMU_MP1_SRBM2P_MSG_9__CONTENT__SHIFT 0x0
#define SMU_MP1_SRBM2P_MSG_10__CONTENT_MASK 0xffffffff
#define SMU_MP1_SRBM2P_MSG_10__CONTENT__SHIFT 0x0
#define SMU_MP1_SRBM2P_MSG_11__CONTENT_MASK 0xffffffff
#define SMU_MP1_SRBM2P_MSG_11__CONTENT__SHIFT 0x0
#define SMU_MP1_SRBM2P_MSG_12__CONTENT_MASK 0xffffffff
#define SMU_MP1_SRBM2P_MSG_12__CONTENT__SHIFT 0x0
#define SMU_MP1_SRBM2P_MSG_13__CONTENT_MASK 0xffffffff
#define SMU_MP1_SRBM2P_MSG_13__CONTENT__SHIFT 0x0
#define SMU_MP1_SRBM2P_MSG_14__CONTENT_MASK 0xffffffff
#define SMU_MP1_SRBM2P_MSG_14__CONTENT__SHIFT 0x0
#define SMU_MP1_SRBM2P_MSG_15__CONTENT_MASK 0xffffffff
#define SMU_MP1_SRBM2P_MSG_15__CONTENT__SHIFT 0x0
#define SMU_MP1_SRBM2P_RESP_0__CONTENT_MASK 0xffffffff
#define SMU_MP1_SRBM2P_RESP_0__CONTENT__SHIFT 0x0
#define SMU_MP1_SRBM2P_RESP_1__CONTENT_MASK 0xffffffff
#define SMU_MP1_SRBM2P_RESP_1__CONTENT__SHIFT 0x0
#define SMU_MP1_SRBM2P_RESP_2__CONTENT_MASK 0xffffffff
#define SMU_MP1_SRBM2P_RESP_2__CONTENT__SHIFT 0x0
#define SMU_MP1_SRBM2P_RESP_3__CONTENT_MASK 0xffffffff
#define SMU_MP1_SRBM2P_RESP_3__CONTENT__SHIFT 0x0
#define SMU_MP1_SRBM2P_RESP_4__CONTENT_MASK 0xffffffff
#define SMU_MP1_SRBM2P_RESP_4__CONTENT__SHIFT 0x0
#define SMU_MP1_SRBM2P_RESP_5__CONTENT_MASK 0xffffffff
#define SMU_MP1_SRBM2P_RESP_5__CONTENT__SHIFT 0x0
#define SMU_MP1_SRBM2P_RESP_6__CONTENT_MASK 0xffffffff
#define SMU_MP1_SRBM2P_RESP_6__CONTENT__SHIFT 0x0
#define SMU_MP1_SRBM2P_RESP_7__CONTENT_MASK 0xffffffff
#define SMU_MP1_SRBM2P_RESP_7__CONTENT__SHIFT 0x0
#define SMU_MP1_SRBM2P_RESP_8__CONTENT_MASK 0xffffffff
#define SMU_MP1_SRBM2P_RESP_8__CONTENT__SHIFT 0x0
#define SMU_MP1_SRBM2P_RESP_9__CONTENT_MASK 0xffffffff
#define SMU_MP1_SRBM2P_RESP_9__CONTENT__SHIFT 0x0
#define SMU_MP1_SRBM2P_RESP_10__CONTENT_MASK 0xffffffff
#define SMU_MP1_SRBM2P_RESP_10__CONTENT__SHIFT 0x0
#define SMU_MP1_SRBM2P_RESP_11__CONTENT_MASK 0xffffffff
#define SMU_MP1_SRBM2P_RESP_11__CONTENT__SHIFT 0x0
#define SMU_MP1_SRBM2P_RESP_12__CONTENT_MASK 0xffffffff
#define SMU_MP1_SRBM2P_RESP_12__CONTENT__SHIFT 0x0
#define SMU_MP1_SRBM2P_RESP_13__CONTENT_MASK 0xffffffff
#define SMU_MP1_SRBM2P_RESP_13__CONTENT__SHIFT 0x0
#define SMU_MP1_SRBM2P_RESP_14__CONTENT_MASK 0xffffffff
#define SMU_MP1_SRBM2P_RESP_14__CONTENT__SHIFT 0x0
#define SMU_MP1_SRBM2P_RESP_15__CONTENT_MASK 0xffffffff
#define SMU_MP1_SRBM2P_RESP_15__CONTENT__SHIFT 0x0
#define SMU_MP1_SRBM2P_ARG_0__CONTENT_MASK 0xffffffff
#define SMU_MP1_SRBM2P_ARG_0__CONTENT__SHIFT 0x0
#define SMU_MP1_SRBM2P_ARG_1__CONTENT_MASK 0xffffffff
#define SMU_MP1_SRBM2P_ARG_1__CONTENT__SHIFT 0x0
#define SMU_MP1_SRBM2P_ARG_2__CONTENT_MASK 0xffffffff
#define SMU_MP1_SRBM2P_ARG_2__CONTENT__SHIFT 0x0
#define SMU_MP1_SRBM2P_ARG_3__CONTENT_MASK 0xffffffff
#define SMU_MP1_SRBM2P_ARG_3__CONTENT__SHIFT 0x0
#define SMU_MP1_SRBM2P_ARG_4__CONTENT_MASK 0xffffffff
#define SMU_MP1_SRBM2P_ARG_4__CONTENT__SHIFT 0x0
#define SMU_MP1_SRBM2P_ARG_5__CONTENT_MASK 0xffffffff
#define SMU_MP1_SRBM2P_ARG_5__CONTENT__SHIFT 0x0
#define SMU_MP1_SRBM2P_ARG_6__CONTENT_MASK 0xffffffff
#define SMU_MP1_SRBM2P_ARG_6__CONTENT__SHIFT 0x0
#define SMU_MP1_SRBM2P_ARG_7__CONTENT_MASK 0xffffffff
#define SMU_MP1_SRBM2P_ARG_7__CONTENT__SHIFT 0x0
#define SMU_MP1_SRBM2P_ARG_8__CONTENT_MASK 0xffffffff
#define SMU_MP1_SRBM2P_ARG_8__CONTENT__SHIFT 0x0
#define SMU_MP1_SRBM2P_ARG_9__CONTENT_MASK 0xffffffff
#define SMU_MP1_SRBM2P_ARG_9__CONTENT__SHIFT 0x0
#define SMU_MP1_SRBM2P_ARG_10__CONTENT_MASK 0xffffffff
#define SMU_MP1_SRBM2P_ARG_10__CONTENT__SHIFT 0x0
#define SMU_MP1_SRBM2P_ARG_11__CONTENT_MASK 0xffffffff
#define SMU_MP1_SRBM2P_ARG_11__CONTENT__SHIFT 0x0
#define SMU_MP1_SRBM2P_ARG_12__CONTENT_MASK 0xffffffff
#define SMU_MP1_SRBM2P_ARG_12__CONTENT__SHIFT 0x0
#define SMU_MP1_SRBM2P_ARG_13__CONTENT_MASK 0xffffffff
#define SMU_MP1_SRBM2P_ARG_13__CONTENT__SHIFT 0x0
#define SMU_MP1_SRBM2P_ARG_14__CONTENT_MASK 0xffffffff
#define SMU_MP1_SRBM2P_ARG_14__CONTENT__SHIFT 0x0
#define SMU_MP1_SRBM2P_ARG_15__CONTENT_MASK 0xffffffff
#define SMU_MP1_SRBM2P_ARG_15__CONTENT__SHIFT 0x0
#define SMU_MP1_ACP2MP_RESP__CONTENT_MASK 0xffffffff
#define SMU_MP1_ACP2MP_RESP__CONTENT__SHIFT 0x0
#define SMU_MP1_DC2MP_RESP__CONTENT_MASK 0xffffffff
#define SMU_MP1_DC2MP_RESP__CONTENT__SHIFT 0x0
#define SMU_MP1_UVD2MP_RESP__CONTENT_MASK 0xffffffff
#define SMU_MP1_UVD2MP_RESP__CONTENT__SHIFT 0x0
#define SMU_MP1_VCE2MP_RESP__CONTENT_MASK 0xffffffff
#define SMU_MP1_VCE2MP_RESP__CONTENT__SHIFT 0x0
#define SMU_MP1_RLC2MP_RESP__CONTENT_MASK 0xffffffff
#define SMU_MP1_RLC2MP_RESP__CONTENT__SHIFT 0x0
#define MP_FPS_CNT__FPS_CNT_MASK 0xffffffff
#define MP_FPS_CNT__FPS_CNT__SHIFT 0x0
#define SMU_DISP0_TIMER_INT_CONTROL__INT_STAT_MASK 0x1
#define SMU_DISP0_TIMER_INT_CONTROL__INT_STAT__SHIFT 0x0
#define SMU_DISP0_TIMER_INT_CONTROL__INT_UNMASK_MASK 0x2
#define SMU_DISP0_TIMER_INT_CONTROL__INT_UNMASK__SHIFT 0x1
#define SMU_DISP0_TIMER_INT_CONTROL__INT_TYPE_MASK 0x4
#define SMU_DISP0_TIMER_INT_CONTROL__INT_TYPE__SHIFT 0x2
#define SMU_DISP0_TIMER_INT_CONTROL__INT_ACK_MASK 0x8
#define SMU_DISP0_TIMER_INT_CONTROL__INT_ACK__SHIFT 0x3
#define SMU_DISP0_TIMER_INT_CONTROL__MASK_MASK 0x10
#define SMU_DISP0_TIMER_INT_CONTROL__MASK__SHIFT 0x4
#define SMU_DISP1_TIMER_INT_CONTROL__INT_STAT_MASK 0x1
#define SMU_DISP1_TIMER_INT_CONTROL__INT_STAT__SHIFT 0x0
#define SMU_DISP1_TIMER_INT_CONTROL__INT_UNMASK_MASK 0x2
#define SMU_DISP1_TIMER_INT_CONTROL__INT_UNMASK__SHIFT 0x1
#define SMU_DISP1_TIMER_INT_CONTROL__INT_TYPE_MASK 0x4
#define SMU_DISP1_TIMER_INT_CONTROL__INT_TYPE__SHIFT 0x2
#define SMU_DISP1_TIMER_INT_CONTROL__INT_ACK_MASK 0x8
#define SMU_DISP1_TIMER_INT_CONTROL__INT_ACK__SHIFT 0x3
#define SMU_DISP1_TIMER_INT_CONTROL__MASK_MASK 0x10
#define SMU_DISP1_TIMER_INT_CONTROL__MASK__SHIFT 0x4
#define SMU_SRBM_CONFIG__MSTR_CREDITS_MASK 0x1f
#define SMU_SRBM_CONFIG__MSTR_CREDITS__SHIFT 0x0
#define MP_FPS_CNT_XBAR__FPS_CNT_MASK 0xffffffff
#define MP_FPS_CNT_XBAR__FPS_CNT__SHIFT 0x0
#define MP_SRBM_CONFIG_XBAR__MSTR_CREDITS_MASK 0x1f
#define MP_SRBM_CONFIG_XBAR__MSTR_CREDITS__SHIFT 0x0
#define MP_SRBM_CONTROL__ACC_VIO_EN_MASK 0x1
#define MP_SRBM_CONTROL__ACC_VIO_EN__SHIFT 0x0
#define MP_SRBM_CONTROL__ALLOW_NS_ACC_MASK 0x2
#define MP_SRBM_CONTROL__ALLOW_NS_ACC__SHIFT 0x1
#define MP_SRBM_CONTROL__SOFT_RST_MASK_MASK 0x4
#define MP_SRBM_CONTROL__SOFT_RST_MASK__SHIFT 0x2
#define MP_SRBM_CONTROL__SOFT_RST_STS_MASK 0x8
#define MP_SRBM_CONTROL__SOFT_RST_STS__SHIFT 0x3
#define MP_SRBM_ACCVIO_LOG__ACC_VIO_OP_MASK 0x1
#define MP_SRBM_ACCVIO_LOG__ACC_VIO_OP__SHIFT 0x0
#define MP_SRBM_ACCVIO_LOG__ACC_VIO_SRCID_MASK 0xe
#define MP_SRBM_ACCVIO_LOG__ACC_VIO_SRCID__SHIFT 0x1
#define MP_SRBM_ACCVIO_LOG__ACC_VIO_VALID_MASK 0x80000000
#define MP_SRBM_ACCVIO_LOG__ACC_VIO_VALID__SHIFT 0x1f
#define MP_SRBM_ACCVIO_ADDR__ACC_VIO_ADDR_MASK 0xffffffff
#define MP_SRBM_ACCVIO_ADDR__ACC_VIO_ADDR__SHIFT 0x0
#define MP_CRBBM_CONTROL__ACC_VIO_EN_MASK 0x1
#define MP_CRBBM_CONTROL__ACC_VIO_EN__SHIFT 0x0
#define MP_CRBBM_CONTROL__MP0_ACCESS_MASK 0x2
#define MP_CRBBM_CONTROL__MP0_ACCESS__SHIFT 0x1
#define MP_CRBBM_CONTROL__ALLOW_NS_ACC_MASK 0x4
#define MP_CRBBM_CONTROL__ALLOW_NS_ACC__SHIFT 0x2
#define MP_CRBBM_ACCVIO_LOG__ACC_VIO_OP_MASK 0x1
#define MP_CRBBM_ACCVIO_LOG__ACC_VIO_OP__SHIFT 0x0
#define MP_CRBBM_ACCVIO_LOG__ACC_VIO_INTF_MASK 0x2
#define MP_CRBBM_ACCVIO_LOG__ACC_VIO_INTF__SHIFT 0x1
#define MP_CRBBM_ACCVIO_LOG__ACC_VIO_VALID_MASK 0x80000000
#define MP_CRBBM_ACCVIO_LOG__ACC_VIO_VALID__SHIFT 0x1f
#define MP_CRBBM_ACCVIO_ADDR__ACC_VIO_ADDR_MASK 0xffffffff
#define MP_CRBBM_ACCVIO_ADDR__ACC_VIO_ADDR__SHIFT 0x0
#define MP_DRAM_CNTL_WRREQ_CNTL__tag_MASK 0x1ffff
#define MP_DRAM_CNTL_WRREQ_CNTL__tag__SHIFT 0x0
#define MP_DRAM_CNTL_WRREQ_CNTL__urg_MASK 0x1e0000
#define MP_DRAM_CNTL_WRREQ_CNTL__urg__SHIFT 0x11
#define MP_DRAM_CNTL_WRREQ_CNTL__stall_MASK 0x200000
#define MP_DRAM_CNTL_WRREQ_CNTL__stall__SHIFT 0x15
#define MP_DRAM_CNTL_WRREQ_CNTL__priv_MASK 0x400000
#define MP_DRAM_CNTL_WRREQ_CNTL__priv__SHIFT 0x16
#define MP_DRAM_CNTL_WRREQ_CNTL__cid_MASK 0xff800000
#define MP_DRAM_CNTL_WRREQ_CNTL__cid__SHIFT 0x17
#define MP_DRAM_CNTL_WRREQ_CNTL_1__vf_MASK 0x1
#define MP_DRAM_CNTL_WRREQ_CNTL_1__vf__SHIFT 0x0
#define MP_DRAM_CNTL_WRREQ_CNTL_1__vfid_MASK 0xfe
#define MP_DRAM_CNTL_WRREQ_CNTL_1__vfid__SHIFT 0x1
#define MP_DRAM_CNTL_WRREQ_CNTL_1__physical_MASK 0x100
#define MP_DRAM_CNTL_WRREQ_CNTL_1__physical__SHIFT 0x8
#define MP_DRAM_CNTL_WRREQ_CNTL_1__snoop_MASK 0x200
#define MP_DRAM_CNTL_WRREQ_CNTL_1__snoop__SHIFT 0x9
#define MP_DRAM_CNTL_WRREQ_CNTL_1__inval_MASK 0x400
#define MP_DRAM_CNTL_WRREQ_CNTL_1__inval__SHIFT 0xa
#define MP_DRAM_CNTL_WRREQ_CNTL_1__op_MASK 0x3f800
#define MP_DRAM_CNTL_WRREQ_CNTL_1__op__SHIFT 0xb
#define MP_DRAM_CNTL_WRREQ_CNTL_1__swap_MASK 0x300000
#define MP_DRAM_CNTL_WRREQ_CNTL_1__swap__SHIFT 0x14
#define MP_DRAM_CNTL_WRREQ_CNTL_1__vmid_MASK 0x3c00000
#define MP_DRAM_CNTL_WRREQ_CNTL_1__vmid__SHIFT 0x16
#define MP_DRAM_CNTL_WRREQ_CNTL_1__atc_MASK 0x4000000
#define MP_DRAM_CNTL_WRREQ_CNTL_1__atc__SHIFT 0x1a
#define MP_DRAM_CNTL_WRREQ_CNTL_1__fed_MASK 0x8000000
#define MP_DRAM_CNTL_WRREQ_CNTL_1__fed__SHIFT 0x1b
#define MP_DRAM_CNTL_WRREQ_LOW_ADDR__addr_MASK 0xffffffff
#define MP_DRAM_CNTL_WRREQ_LOW_ADDR__addr__SHIFT 0x0
#define MP_DRAM_CNTL_WRREQ_HIGH_ADDR__addr_47_37_MASK 0x7ff
#define MP_DRAM_CNTL_WRREQ_HIGH_ADDR__addr_47_37__SHIFT 0x0
#define MP_DRAM_CNTL_WRREQ_HIGH_ADDR__reserved_MASK 0xfffff800
#define MP_DRAM_CNTL_WRREQ_HIGH_ADDR__reserved__SHIFT 0xb
#define MP_DRAM_CNTL_WRREQ_MASK__mask_MASK 0xffffffff
#define MP_DRAM_CNTL_WRREQ_MASK__mask__SHIFT 0x0
#define MP_DRAM_CNTL_WRREQ_DATA_0__data_MASK 0xffffffff
#define MP_DRAM_CNTL_WRREQ_DATA_0__data__SHIFT 0x0
#define MP_DRAM_CNTL_WRREQ_DATA_1__data_MASK 0xffffffff
#define MP_DRAM_CNTL_WRREQ_DATA_1__data__SHIFT 0x0
#define MP_DRAM_CNTL_WRREQ_DATA_2__data_MASK 0xffffffff
#define MP_DRAM_CNTL_WRREQ_DATA_2__data__SHIFT 0x0
#define MP_DRAM_CNTL_WRREQ_DATA_3__data_MASK 0xffffffff
#define MP_DRAM_CNTL_WRREQ_DATA_3__data__SHIFT 0x0
#define MP_DRAM_CNTL_WRREQ_DATA_4__data_MASK 0xffffffff
#define MP_DRAM_CNTL_WRREQ_DATA_4__data__SHIFT 0x0
#define MP_DRAM_CNTL_WRREQ_DATA_5__data_MASK 0xffffffff
#define MP_DRAM_CNTL_WRREQ_DATA_5__data__SHIFT 0x0
#define MP_DRAM_CNTL_WRREQ_DATA_6__data_MASK 0xffffffff
#define MP_DRAM_CNTL_WRREQ_DATA_6__data__SHIFT 0x0
#define MP_DRAM_CNTL_WRREQ_DATA_7__data_MASK 0xffffffff
#define MP_DRAM_CNTL_WRREQ_DATA_7__data__SHIFT 0x0
#define MP_DRAM_CNTL_WRREQ_STATUS__credit_counter_MASK 0x1f
#define MP_DRAM_CNTL_WRREQ_STATUS__credit_counter__SHIFT 0x0
#define MP_DRAM_CNTL_WRREQ_STATUS__reserved0_MASK 0xe0
#define MP_DRAM_CNTL_WRREQ_STATUS__reserved0__SHIFT 0x5
#define MP_DRAM_CNTL_WRREQ_STATUS__fifo_not_empty_MASK 0x100
#define MP_DRAM_CNTL_WRREQ_STATUS__fifo_not_empty__SHIFT 0x8
#define MP_DRAM_CNTL_WRREQ_STATUS__reserved1_MASK 0xfe00
#define MP_DRAM_CNTL_WRREQ_STATUS__reserved1__SHIFT 0x9
#define MP_DRAM_CNTL_WRREQ_STATUS__tag_pointer_MASK 0xf0000
#define MP_DRAM_CNTL_WRREQ_STATUS__tag_pointer__SHIFT 0x10
#define MP_DRAM_CNTL_WRREQ_STATUS__reserved2_MASK 0xfff00000
#define MP_DRAM_CNTL_WRREQ_STATUS__reserved2__SHIFT 0x14
#define MP_DRAM_CNTL_WRRET_STATUS_0__valid_MASK 0x1
#define MP_DRAM_CNTL_WRRET_STATUS_0__valid__SHIFT 0x0
#define MP_DRAM_CNTL_WRRET_STATUS_0__nack_MASK 0x6
#define MP_DRAM_CNTL_WRRET_STATUS_0__nack__SHIFT 0x1
#define MP_DRAM_CNTL_WRRET_STATUS_0__reserved_MASK 0xfff8
#define MP_DRAM_CNTL_WRRET_STATUS_0__reserved__SHIFT 0x3
#define MP_DRAM_CNTL_WRRET_STATUS_0__tag_MASK 0xffff0000
#define MP_DRAM_CNTL_WRRET_STATUS_0__tag__SHIFT 0x10
#define MP_DRAM_CNTL_RDREQ_ADDR__addr_MASK 0xffffffff
#define MP_DRAM_CNTL_RDREQ_ADDR__addr__SHIFT 0x0
#define MP_DRAM_CNTL_RDREQ_CNTL__tag_MASK 0xffff
#define MP_DRAM_CNTL_RDREQ_CNTL__tag__SHIFT 0x0
#define MP_DRAM_CNTL_RDREQ_CNTL__mask_MASK 0xff0000
#define MP_DRAM_CNTL_RDREQ_CNTL__mask__SHIFT 0x10
#define MP_DRAM_CNTL_RDREQ_CNTL__addr_47_40_MASK 0xff000000
#define MP_DRAM_CNTL_RDREQ_CNTL__addr_47_40__SHIFT 0x18
#define MP_DRAM_CNTL_RDREQ_CNTL_1__urg_MASK 0xf
#define MP_DRAM_CNTL_RDREQ_CNTL_1__urg__SHIFT 0x0
#define MP_DRAM_CNTL_RDREQ_CNTL_1__stall_MASK 0x10
#define MP_DRAM_CNTL_RDREQ_CNTL_1__stall__SHIFT 0x4
#define MP_DRAM_CNTL_RDREQ_CNTL_1__priv_MASK 0x20
#define MP_DRAM_CNTL_RDREQ_CNTL_1__priv__SHIFT 0x5
#define MP_DRAM_CNTL_RDREQ_CNTL_1__swap_MASK 0xc0
#define MP_DRAM_CNTL_RDREQ_CNTL_1__swap__SHIFT 0x6
#define MP_DRAM_CNTL_RDREQ_CNTL_1__cid_MASK 0x1ff00
#define MP_DRAM_CNTL_RDREQ_CNTL_1__cid__SHIFT 0x8
#define MP_DRAM_CNTL_RDREQ_CNTL_1__vmid_MASK 0x1e0000
#define MP_DRAM_CNTL_RDREQ_CNTL_1__vmid__SHIFT 0x11
#define MP_DRAM_CNTL_RDREQ_CNTL_1__atc_MASK 0x200000
#define MP_DRAM_CNTL_RDREQ_CNTL_1__atc__SHIFT 0x15
#define MP_DRAM_CNTL_RDREQ_CNTL_1__physical_MASK 0x400000
#define MP_DRAM_CNTL_RDREQ_CNTL_1__physical__SHIFT 0x16
#define MP_DRAM_CNTL_RDREQ_CNTL_1__exe_MASK 0x800000
#define MP_DRAM_CNTL_RDREQ_CNTL_1__exe__SHIFT 0x17
#define MP_DRAM_CNTL_RDREQ_CNTL_1__snoop_MASK 0x1000000
#define MP_DRAM_CNTL_RDREQ_CNTL_1__snoop__SHIFT 0x18
#define MP_DRAM_CNTL_RDREQ_CNTL_1__shared_MASK 0x2000000
#define MP_DRAM_CNTL_RDREQ_CNTL_1__shared__SHIFT 0x19
#define MP_DRAM_CNTL_RDREQ_CNTL_1__vf_MASK 0x4000000
#define MP_DRAM_CNTL_RDREQ_CNTL_1__vf__SHIFT 0x1a
#define MP_DRAM_CNTL_RDREQ_CNTL_1__vfid_MASK 0xf8000000
#define MP_DRAM_CNTL_RDREQ_CNTL_1__vfid__SHIFT 0x1b
#define MP_DRAM_CNTL_RDRET_VALID__vld_0_MASK 0x1
#define MP_DRAM_CNTL_RDRET_VALID__vld_0__SHIFT 0x0
#define MP_DRAM_CNTL_RDRET_VALID__vld_1_MASK 0x2
#define MP_DRAM_CNTL_RDRET_VALID__vld_1__SHIFT 0x1
#define MP_DRAM_CNTL_RDRET_VALID__vld_2_MASK 0x4
#define MP_DRAM_CNTL_RDRET_VALID__vld_2__SHIFT 0x2
#define MP_DRAM_CNTL_RDRET_VALID__vld_3_MASK 0x8
#define MP_DRAM_CNTL_RDRET_VALID__vld_3__SHIFT 0x3
#define MP_DRAM_CNTL_RDRET_VALID__vld_4_MASK 0x10
#define MP_DRAM_CNTL_RDRET_VALID__vld_4__SHIFT 0x4
#define MP_DRAM_CNTL_RDRET_VALID__vld_5_MASK 0x20
#define MP_DRAM_CNTL_RDRET_VALID__vld_5__SHIFT 0x5
#define MP_DRAM_CNTL_RDRET_VALID__vld_6_MASK 0x40
#define MP_DRAM_CNTL_RDRET_VALID__vld_6__SHIFT 0x6
#define MP_DRAM_CNTL_RDRET_VALID__vld_7_MASK 0x80
#define MP_DRAM_CNTL_RDRET_VALID__vld_7__SHIFT 0x7
#define MP_DRAM_CNTL_RDRET_VALID__reserved_MASK 0xffff00
#define MP_DRAM_CNTL_RDRET_VALID__reserved__SHIFT 0x8
#define MP_DRAM_CNTL_RDRET_VALID__atomic_MASK 0xff000000
#define MP_DRAM_CNTL_RDRET_VALID__atomic__SHIFT 0x18
#define MP_DRAM_CNTL_RDRET_NACK__nack_0_MASK 0x3
#define MP_DRAM_CNTL_RDRET_NACK__nack_0__SHIFT 0x0
#define MP_DRAM_CNTL_RDRET_NACK__nack_1_MASK 0xc
#define MP_DRAM_CNTL_RDRET_NACK__nack_1__SHIFT 0x2
#define MP_DRAM_CNTL_RDRET_NACK__nack_2_MASK 0x30
#define MP_DRAM_CNTL_RDRET_NACK__nack_2__SHIFT 0x4
#define MP_DRAM_CNTL_RDRET_NACK__nack_3_MASK 0xc0
#define MP_DRAM_CNTL_RDRET_NACK__nack_3__SHIFT 0x6
#define MP_DRAM_CNTL_RDRET_NACK__nack_4_MASK 0x300
#define MP_DRAM_CNTL_RDRET_NACK__nack_4__SHIFT 0x8
#define MP_DRAM_CNTL_RDRET_NACK__nack_5_MASK 0xc00
#define MP_DRAM_CNTL_RDRET_NACK__nack_5__SHIFT 0xa
#define MP_DRAM_CNTL_RDRET_NACK__nack_6_MASK 0x3000
#define MP_DRAM_CNTL_RDRET_NACK__nack_6__SHIFT 0xc
#define MP_DRAM_CNTL_RDRET_NACK__nack_7_MASK 0xc000
#define MP_DRAM_CNTL_RDRET_NACK__nack_7__SHIFT 0xe
#define MP_DRAM_CNTL_RDRET_NACK__reserved_MASK 0xffff0000
#define MP_DRAM_CNTL_RDRET_NACK__reserved__SHIFT 0x10
#define MP_DRAM_CNTL_RDRET_DATA_0__DATA_MASK 0xffffffff
#define MP_DRAM_CNTL_RDRET_DATA_0__DATA__SHIFT 0x0
#define MP_DRAM_CNTL_RDRET_DATA_1__DATA_MASK 0xffffffff
#define MP_DRAM_CNTL_RDRET_DATA_1__DATA__SHIFT 0x0
#define MP_DRAM_CNTL_RDRET_DATA_2__DATA_MASK 0xffffffff
#define MP_DRAM_CNTL_RDRET_DATA_2__DATA__SHIFT 0x0
#define MP_DRAM_CNTL_RDRET_DATA_3__DATA_MASK 0xffffffff
#define MP_DRAM_CNTL_RDRET_DATA_3__DATA__SHIFT 0x0
#define MP_DRAM_CNTL_RDRET_DATA_4__DATA_MASK 0xffffffff
#define MP_DRAM_CNTL_RDRET_DATA_4__DATA__SHIFT 0x0
#define MP_DRAM_CNTL_RDRET_DATA_5__DATA_MASK 0xffffffff
#define MP_DRAM_CNTL_RDRET_DATA_5__DATA__SHIFT 0x0
#define MP_DRAM_CNTL_RDRET_DATA_6__DATA_MASK 0xffffffff
#define MP_DRAM_CNTL_RDRET_DATA_6__DATA__SHIFT 0x0
#define MP_DRAM_CNTL_RDRET_DATA_7__DATA_MASK 0xffffffff
#define MP_DRAM_CNTL_RDRET_DATA_7__DATA__SHIFT 0x0
#define MP_DRAM_CNTL_RDRET_DATA_8__DATA_MASK 0xffffffff
#define MP_DRAM_CNTL_RDRET_DATA_8__DATA__SHIFT 0x0
#define MP_DRAM_CNTL_RDRET_DATA_9__DATA_MASK 0xffffffff
#define MP_DRAM_CNTL_RDRET_DATA_9__DATA__SHIFT 0x0
#define MP_DRAM_CNTL_RDRET_DATA_10__DATA_MASK 0xffffffff
#define MP_DRAM_CNTL_RDRET_DATA_10__DATA__SHIFT 0x0
#define MP_DRAM_CNTL_RDRET_DATA_11__DATA_MASK 0xffffffff
#define MP_DRAM_CNTL_RDRET_DATA_11__DATA__SHIFT 0x0
#define MP_DRAM_CNTL_RDRET_DATA_12__DATA_MASK 0xffffffff
#define MP_DRAM_CNTL_RDRET_DATA_12__DATA__SHIFT 0x0
#define MP_DRAM_CNTL_RDRET_DATA_13__DATA_MASK 0xffffffff
#define MP_DRAM_CNTL_RDRET_DATA_13__DATA__SHIFT 0x0
#define MP_DRAM_CNTL_RDRET_DATA_14__DATA_MASK 0xffffffff
#define MP_DRAM_CNTL_RDRET_DATA_14__DATA__SHIFT 0x0
#define MP_DRAM_CNTL_RDRET_DATA_15__DATA_MASK 0xffffffff
#define MP_DRAM_CNTL_RDRET_DATA_15__DATA__SHIFT 0x0
#define MP_DRAM_CNTL_RDRET_DATA_16__DATA_MASK 0xffffffff
#define MP_DRAM_CNTL_RDRET_DATA_16__DATA__SHIFT 0x0
#define MP_DRAM_CNTL_RDRET_DATA_17__DATA_MASK 0xffffffff
#define MP_DRAM_CNTL_RDRET_DATA_17__DATA__SHIFT 0x0
#define MP_DRAM_CNTL_RDRET_DATA_18__DATA_MASK 0xffffffff
#define MP_DRAM_CNTL_RDRET_DATA_18__DATA__SHIFT 0x0
#define MP_DRAM_CNTL_RDRET_DATA_19__DATA_MASK 0xffffffff
#define MP_DRAM_CNTL_RDRET_DATA_19__DATA__SHIFT 0x0
#define MP_DRAM_CNTL_RDRET_DATA_20__DATA_MASK 0xffffffff
#define MP_DRAM_CNTL_RDRET_DATA_20__DATA__SHIFT 0x0
#define MP_DRAM_CNTL_RDRET_DATA_21__DATA_MASK 0xffffffff
#define MP_DRAM_CNTL_RDRET_DATA_21__DATA__SHIFT 0x0
#define MP_DRAM_CNTL_RDRET_DATA_22__DATA_MASK 0xffffffff
#define MP_DRAM_CNTL_RDRET_DATA_22__DATA__SHIFT 0x0
#define MP_DRAM_CNTL_RDRET_DATA_23__DATA_MASK 0xffffffff
#define MP_DRAM_CNTL_RDRET_DATA_23__DATA__SHIFT 0x0
#define MP_DRAM_CNTL_RDRET_DATA_24__DATA_MASK 0xffffffff
#define MP_DRAM_CNTL_RDRET_DATA_24__DATA__SHIFT 0x0
#define MP_DRAM_CNTL_RDRET_DATA_25__DATA_MASK 0xffffffff
#define MP_DRAM_CNTL_RDRET_DATA_25__DATA__SHIFT 0x0
#define MP_DRAM_CNTL_RDRET_DATA_26__DATA_MASK 0xffffffff
#define MP_DRAM_CNTL_RDRET_DATA_26__DATA__SHIFT 0x0
#define MP_DRAM_CNTL_RDRET_DATA_27__DATA_MASK 0xffffffff
#define MP_DRAM_CNTL_RDRET_DATA_27__DATA__SHIFT 0x0
#define MP_DRAM_CNTL_RDRET_DATA_28__DATA_MASK 0xffffffff
#define MP_DRAM_CNTL_RDRET_DATA_28__DATA__SHIFT 0x0
#define MP_DRAM_CNTL_RDRET_DATA_29__DATA_MASK 0xffffffff
#define MP_DRAM_CNTL_RDRET_DATA_29__DATA__SHIFT 0x0
#define MP_DRAM_CNTL_RDRET_DATA_30__DATA_MASK 0xffffffff
#define MP_DRAM_CNTL_RDRET_DATA_30__DATA__SHIFT 0x0
#define MP_DRAM_CNTL_RDRET_DATA_31__DATA_MASK 0xffffffff
#define MP_DRAM_CNTL_RDRET_DATA_31__DATA__SHIFT 0x0
#define MP_DRAM_CNTL_RDRET_DATA_32__DATA_MASK 0xffffffff
#define MP_DRAM_CNTL_RDRET_DATA_32__DATA__SHIFT 0x0
#define MP_DRAM_CNTL_RDRET_DATA_33__DATA_MASK 0xffffffff
#define MP_DRAM_CNTL_RDRET_DATA_33__DATA__SHIFT 0x0
#define MP_DRAM_CNTL_RDRET_DATA_34__DATA_MASK 0xffffffff
#define MP_DRAM_CNTL_RDRET_DATA_34__DATA__SHIFT 0x0
#define MP_DRAM_CNTL_RDRET_DATA_35__DATA_MASK 0xffffffff
#define MP_DRAM_CNTL_RDRET_DATA_35__DATA__SHIFT 0x0
#define MP_DRAM_CNTL_RDRET_DATA_36__DATA_MASK 0xffffffff
#define MP_DRAM_CNTL_RDRET_DATA_36__DATA__SHIFT 0x0
#define MP_DRAM_CNTL_RDRET_DATA_37__DATA_MASK 0xffffffff
#define MP_DRAM_CNTL_RDRET_DATA_37__DATA__SHIFT 0x0
#define MP_DRAM_CNTL_RDRET_DATA_38__DATA_MASK 0xffffffff
#define MP_DRAM_CNTL_RDRET_DATA_38__DATA__SHIFT 0x0
#define MP_DRAM_CNTL_RDRET_DATA_39__DATA_MASK 0xffffffff
#define MP_DRAM_CNTL_RDRET_DATA_39__DATA__SHIFT 0x0
#define MP_DRAM_CNTL_RDRET_DATA_40__DATA_MASK 0xffffffff
#define MP_DRAM_CNTL_RDRET_DATA_40__DATA__SHIFT 0x0
#define MP_DRAM_CNTL_RDRET_DATA_41__DATA_MASK 0xffffffff
#define MP_DRAM_CNTL_RDRET_DATA_41__DATA__SHIFT 0x0
#define MP_DRAM_CNTL_RDRET_DATA_42__DATA_MASK 0xffffffff
#define MP_DRAM_CNTL_RDRET_DATA_42__DATA__SHIFT 0x0
#define MP_DRAM_CNTL_RDRET_DATA_43__DATA_MASK 0xffffffff
#define MP_DRAM_CNTL_RDRET_DATA_43__DATA__SHIFT 0x0
#define MP_DRAM_CNTL_RDRET_DATA_44__DATA_MASK 0xffffffff
#define MP_DRAM_CNTL_RDRET_DATA_44__DATA__SHIFT 0x0
#define MP_DRAM_CNTL_RDRET_DATA_45__DATA_MASK 0xffffffff
#define MP_DRAM_CNTL_RDRET_DATA_45__DATA__SHIFT 0x0
#define MP_DRAM_CNTL_RDRET_DATA_46__DATA_MASK 0xffffffff
#define MP_DRAM_CNTL_RDRET_DATA_46__DATA__SHIFT 0x0
#define MP_DRAM_CNTL_RDRET_DATA_47__DATA_MASK 0xffffffff
#define MP_DRAM_CNTL_RDRET_DATA_47__DATA__SHIFT 0x0
#define MP_DRAM_CNTL_RDRET_DATA_48__DATA_MASK 0xffffffff
#define MP_DRAM_CNTL_RDRET_DATA_48__DATA__SHIFT 0x0
#define MP_DRAM_CNTL_RDRET_DATA_49__DATA_MASK 0xffffffff
#define MP_DRAM_CNTL_RDRET_DATA_49__DATA__SHIFT 0x0
#define MP_DRAM_CNTL_RDRET_DATA_50__DATA_MASK 0xffffffff
#define MP_DRAM_CNTL_RDRET_DATA_50__DATA__SHIFT 0x0
#define MP_DRAM_CNTL_RDRET_DATA_51__DATA_MASK 0xffffffff
#define MP_DRAM_CNTL_RDRET_DATA_51__DATA__SHIFT 0x0
#define MP_DRAM_CNTL_RDRET_DATA_52__DATA_MASK 0xffffffff
#define MP_DRAM_CNTL_RDRET_DATA_52__DATA__SHIFT 0x0
#define MP_DRAM_CNTL_RDRET_DATA_53__DATA_MASK 0xffffffff
#define MP_DRAM_CNTL_RDRET_DATA_53__DATA__SHIFT 0x0
#define MP_DRAM_CNTL_RDRET_DATA_54__DATA_MASK 0xffffffff
#define MP_DRAM_CNTL_RDRET_DATA_54__DATA__SHIFT 0x0
#define MP_DRAM_CNTL_RDRET_DATA_55__DATA_MASK 0xffffffff
#define MP_DRAM_CNTL_RDRET_DATA_55__DATA__SHIFT 0x0
#define MP_DRAM_CNTL_RDRET_DATA_56__DATA_MASK 0xffffffff
#define MP_DRAM_CNTL_RDRET_DATA_56__DATA__SHIFT 0x0
#define MP_DRAM_CNTL_RDRET_DATA_57__DATA_MASK 0xffffffff
#define MP_DRAM_CNTL_RDRET_DATA_57__DATA__SHIFT 0x0
#define MP_DRAM_CNTL_RDRET_DATA_58__DATA_MASK 0xffffffff
#define MP_DRAM_CNTL_RDRET_DATA_58__DATA__SHIFT 0x0
#define MP_DRAM_CNTL_RDRET_DATA_59__DATA_MASK 0xffffffff
#define MP_DRAM_CNTL_RDRET_DATA_59__DATA__SHIFT 0x0
#define MP_DRAM_CNTL_RDRET_DATA_60__DATA_MASK 0xffffffff
#define MP_DRAM_CNTL_RDRET_DATA_60__DATA__SHIFT 0x0
#define MP_DRAM_CNTL_RDRET_DATA_61__DATA_MASK 0xffffffff
#define MP_DRAM_CNTL_RDRET_DATA_61__DATA__SHIFT 0x0
#define MP_DRAM_CNTL_RDRET_DATA_62__DATA_MASK 0xffffffff
#define MP_DRAM_CNTL_RDRET_DATA_62__DATA__SHIFT 0x0
#define MP_DRAM_CNTL_RDRET_DATA_63__DATA_MASK 0xffffffff
#define MP_DRAM_CNTL_RDRET_DATA_63__DATA__SHIFT 0x0
#define MP_IOC_CTRL__IOC_mst_send_MASK 0x1
#define MP_IOC_CTRL__IOC_mst_send__SHIFT 0x0
#define MP_IOC_CTRL__IOC_mst_stop_MASK 0x2
#define MP_IOC_CTRL__IOC_mst_stop__SHIFT 0x1
#define MP_IOC_CTRL__IOC_mst_force_active_MASK 0x4
#define MP_IOC_CTRL__IOC_mst_force_active__SHIFT 0x2
#define MP_IOC_CTRL__IOC_mst_rdValid_MASK 0x8
#define MP_IOC_CTRL__IOC_mst_rdValid__SHIFT 0x3
#define MP_IOC_CTRL__IOC_mst_busy_MASK 0x10
#define MP_IOC_CTRL__IOC_mst_busy__SHIFT 0x4
#define MP_IOC_CTRL__IOC_mst_disabled_MASK 0x20
#define MP_IOC_CTRL__IOC_mst_disabled__SHIFT 0x5
#define MP_IOC_CTRL__IOC_mst_debug_rst_MASK 0x40
#define MP_IOC_CTRL__IOC_mst_debug_rst__SHIFT 0x6
#define MP_IOC_CTRL__IOC_mst_stop_ack_MASK 0x80
#define MP_IOC_CTRL__IOC_mst_stop_ack__SHIFT 0x7
#define MP_IOC_CTRL__IOC_mst_rderr_MASK 0x300
#define MP_IOC_CTRL__IOC_mst_rderr__SHIFT 0x8
#define MP_IOC_RDDATA__IOC_mst_rdData_MASK 0xffffffff
#define MP_IOC_RDDATA__IOC_mst_rdData__SHIFT 0x0
#define MP_IOC_PHASE1__BiuCqfC_AwqReqCommit_MASK 0x2
#define MP_IOC_PHASE1__BiuCqfC_AwqReqCommit__SHIFT 0x1
#define MP_IOC_PHASE1__BiuCqfC_AltReqRdCmd_MASK 0x4
#define MP_IOC_PHASE1__BiuCqfC_AltReqRdCmd__SHIFT 0x2
#define MP_IOC_PHASE1__BiuCqfC_AltReqAddrLo_MASK 0xfffffff8
#define MP_IOC_PHASE1__BiuCqfC_AltReqAddrLo__SHIFT 0x3
#define MP_IOC_PHASE2__BiuCqfC_AltReqAddrMid_MASK 0xff
#define MP_IOC_PHASE2__BiuCqfC_AltReqAddrMid__SHIFT 0x0
#define MP_IOC_PHASE2__BiuCqfC_AltReqMask_MASK 0xff00
#define MP_IOC_PHASE2__BiuCqfC_AltReqMask__SHIFT 0x8
#define MP_IOC_PHASE2__BiuCqfC_AltReqSize_MASK 0x30000
#define MP_IOC_PHASE2__BiuCqfC_AltReqSize__SHIFT 0x10
#define MP_IOC_PHASE2__BiuCqfC_AltReqAddrHi_MASK 0xff000000
#define MP_IOC_PHASE2__BiuCqfC_AltReqAddrHi__SHIFT 0x18
#define MP_IOC_PHASE3__BiuDbfC_C2aDataOut_MASK 0xffffffff
#define MP_IOC_PHASE3__BiuDbfC_C2aDataOut__SHIFT 0x0
#define MP_IOC_READ_0__data_MASK 0xffffffff
#define MP_IOC_READ_0__data__SHIFT 0x0
#define MP_IOC_READ_1__data_MASK 0xffffffff
#define MP_IOC_READ_1__data__SHIFT 0x0
#define MP_IOC_READ_2__data_MASK 0xffffffff
#define MP_IOC_READ_2__data__SHIFT 0x0
#define MP_IOC_READ_3__data_MASK 0xffffffff
#define MP_IOC_READ_3__data__SHIFT 0x0
#define MP_IOC_READ_4__data_MASK 0xffffffff
#define MP_IOC_READ_4__data__SHIFT 0x0
#define MP_IOC_READ_5__data_MASK 0xffffffff
#define MP_IOC_READ_5__data__SHIFT 0x0
#define MP_IOC_READ_6__data_MASK 0xffffffff
#define MP_IOC_READ_6__data__SHIFT 0x0
#define MP_IOC_READ_7__data_MASK 0xffffffff
#define MP_IOC_READ_7__data__SHIFT 0x0
#define MP_IOC_READ_8__data_MASK 0xffffffff
#define MP_IOC_READ_8__data__SHIFT 0x0
#define MP_IOC_READ_9__data_MASK 0xffffffff
#define MP_IOC_READ_9__data__SHIFT 0x0
#define MP_IOC_READ_10__data_MASK 0xffffffff
#define MP_IOC_READ_10__data__SHIFT 0x0
#define MP_IOC_READ_11__data_MASK 0xffffffff
#define MP_IOC_READ_11__data__SHIFT 0x0
#define MP_IOC_READ_12__data_MASK 0xffffffff
#define MP_IOC_READ_12__data__SHIFT 0x0
#define MP_IOC_READ_13__data_MASK 0xffffffff
#define MP_IOC_READ_13__data__SHIFT 0x0
#define MP_IOC_READ_14__data_MASK 0xffffffff
#define MP_IOC_READ_14__data__SHIFT 0x0
#define MP_IOC_READ_15__data_MASK 0xffffffff
#define MP_IOC_READ_15__data__SHIFT 0x0
#define MP_IOC_WRITE_0__data_MASK 0xffffffff
#define MP_IOC_WRITE_0__data__SHIFT 0x0
#define MP_IOC_WRITE_1__data_MASK 0xffffffff
#define MP_IOC_WRITE_1__data__SHIFT 0x0
#define MP_IOC_WRITE_2__data_MASK 0xffffffff
#define MP_IOC_WRITE_2__data__SHIFT 0x0
#define MP_IOC_WRITE_3__data_MASK 0xffffffff
#define MP_IOC_WRITE_3__data__SHIFT 0x0
#define MP_IOC_WRITE_4__data_MASK 0xffffffff
#define MP_IOC_WRITE_4__data__SHIFT 0x0
#define MP_IOC_WRITE_5__data_MASK 0xffffffff
#define MP_IOC_WRITE_5__data__SHIFT 0x0
#define MP_IOC_WRITE_6__data_MASK 0xffffffff
#define MP_IOC_WRITE_6__data__SHIFT 0x0
#define MP_IOC_WRITE_7__data_MASK 0xffffffff
#define MP_IOC_WRITE_7__data__SHIFT 0x0
#define MP_IOC_WRITE_8__data_MASK 0xffffffff
#define MP_IOC_WRITE_8__data__SHIFT 0x0
#define MP_IOC_WRITE_9__data_MASK 0xffffffff
#define MP_IOC_WRITE_9__data__SHIFT 0x0
#define MP_IOC_WRITE_10__data_MASK 0xffffffff
#define MP_IOC_WRITE_10__data__SHIFT 0x0
#define MP_IOC_WRITE_11__data_MASK 0xffffffff
#define MP_IOC_WRITE_11__data__SHIFT 0x0
#define MP_IOC_WRITE_12__data_MASK 0xffffffff
#define MP_IOC_WRITE_12__data__SHIFT 0x0
#define MP_IOC_WRITE_13__data_MASK 0xffffffff
#define MP_IOC_WRITE_13__data__SHIFT 0x0
#define MP_IOC_WRITE_14__data_MASK 0xffffffff
#define MP_IOC_WRITE_14__data__SHIFT 0x0
#define MP_IOC_WRITE_15__data_MASK 0xffffffff
#define MP_IOC_WRITE_15__data__SHIFT 0x0
#define MP_INTERRUPT_CONTROL__MAX_CREDIT_VALUE_MASK 0x1f
#define MP_INTERRUPT_CONTROL__MAX_CREDIT_VALUE__SHIFT 0x0
#define MP_INTERRUPT_CONTROL__MP0_SW_TRIG_MASK_MASK 0x20
#define MP_INTERRUPT_CONTROL__MP0_SW_TRIG_MASK__SHIFT 0x5
#define MP_INTERRUPT_CONTROL__MP0_SW_INT_ACK_MASK 0x40
#define MP_INTERRUPT_CONTROL__MP0_SW_INT_ACK__SHIFT 0x6
#define MP_INTERRUPT_CONTROL__MP1_SW_TRIG_MASK_MASK 0x80
#define MP_INTERRUPT_CONTROL__MP1_SW_TRIG_MASK__SHIFT 0x7
#define MP_INTERRUPT_CONTROL__MP1_SW_INT_ACK_MASK 0x100
#define MP_INTERRUPT_CONTROL__MP1_SW_INT_ACK__SHIFT 0x8
#define MP0_SW_INT__VALID_MASK 0x1
#define MP0_SW_INT__VALID__SHIFT 0x0
#define MP0_SW_INT__INT_ID_MASK 0x1fe
#define MP0_SW_INT__INT_ID__SHIFT 0x1
#define MP0_SW_INT_CTXID__CTXID_MASK 0xfffffff
#define MP0_SW_INT_CTXID__CTXID__SHIFT 0x0
#define MP1_SW_INT__VALID_MASK 0x1
#define MP1_SW_INT__VALID__SHIFT 0x0
#define MP1_SW_INT__INT_ID_MASK 0x1fe
#define MP1_SW_INT__INT_ID__SHIFT 0x1
#define MP1_SW_INT_CTXID__CTXID_MASK 0xfffffff
#define MP1_SW_INT_CTXID__CTXID__SHIFT 0x0
#define DISP_TIMER_ID__DISP_T0_INT_ID_MASK 0xff
#define DISP_TIMER_ID__DISP_T0_INT_ID__SHIFT 0x0
#define DISP_TIMER_ID__DISP_T1_INT_ID_MASK 0xff00
#define DISP_TIMER_ID__DISP_T1_INT_ID__SHIFT 0x8
#define PWRHW_SMC_IND_INDEX__SMC_IND_ADDR_MASK 0xffffffff
#define PWRHW_SMC_IND_INDEX__SMC_IND_ADDR__SHIFT 0x0
#define PWRHW_SMC_IND_DATA__SMC_IND_DATA_MASK 0xffffffff
#define PWRHW_SMC_IND_DATA__SMC_IND_DATA__SHIFT 0x0
#define CURRENT_STATE_CPU0__CURRENT_PSTATE_ID_MASK 0x7
#define CURRENT_STATE_CPU0__CURRENT_PSTATE_ID__SHIFT 0x0
#define CURRENT_STATE_CPU0__CURRENT_DID_MASK 0x38
#define CURRENT_STATE_CPU0__CURRENT_DID__SHIFT 0x3
#define CURRENT_STATE_CPU0__CURRENT_FID_MASK 0xfc0
#define CURRENT_STATE_CPU0__CURRENT_FID__SHIFT 0x6
#define CURRENT_STATE_CPU0__CPU_COF_MASK 0xfff000
#define CURRENT_STATE_CPU0__CPU_COF__SHIFT 0xc
#define CURRENT_STATE_CPU0__CPU_COF_IND_PROG_MASK 0x7f000000
#define CURRENT_STATE_CPU0__CPU_COF_IND_PROG__SHIFT 0x18
#define CURRENT_STATE_CPU1__CURRENT_PSTATE_ID_MASK 0x7
#define CURRENT_STATE_CPU1__CURRENT_PSTATE_ID__SHIFT 0x0
#define CURRENT_STATE_CPU1__CURRENT_DID_MASK 0x38
#define CURRENT_STATE_CPU1__CURRENT_DID__SHIFT 0x3
#define CURRENT_STATE_CPU1__CURRENT_FID_MASK 0xfc0
#define CURRENT_STATE_CPU1__CURRENT_FID__SHIFT 0x6
#define CURRENT_STATE_CPU1__CPU_COF_MASK 0xfff000
#define CURRENT_STATE_CPU1__CPU_COF__SHIFT 0xc
#define CURRENT_STATE_CPU1__CPU_COF_IND_PROG_MASK 0x7f000000
#define CURRENT_STATE_CPU1__CPU_COF_IND_PROG__SHIFT 0x18
#define CPU_REDUN_DONE0__CPU_REDUN_DONE_MASK 0x1
#define CPU_REDUN_DONE0__CPU_REDUN_DONE__SHIFT 0x0
#define CPU_REDUN_DONE1__CPU_REDUN_DONE_MASK 0x1
#define CPU_REDUN_DONE1__CPU_REDUN_DONE__SHIFT 0x0
#define CURRENT_VID_CPU0__CURRENT_VID_MASK 0xff
#define CURRENT_VID_CPU0__CURRENT_VID__SHIFT 0x0
#define CURRENT_VID_CPU1__CURRENT_VID_MASK 0xff
#define CURRENT_VID_CPU1__CURRENT_VID__SHIFT 0x0
#define UNBPM_PWRMGT_ACK__REQUESTOR_CODE_MASK 0x1f
#define UNBPM_PWRMGT_ACK__REQUESTOR_CODE__SHIFT 0x0
#define UNBPM_PWRMGT_ACK__REQUEST_ACK_MASK 0x100
#define UNBPM_PWRMGT_ACK__REQUEST_ACK__SHIFT 0x8
#define UNBPM_PWRMGT_ACK__REQUEST_NACK_MASK 0x10000
#define UNBPM_PWRMGT_ACK__REQUEST_NACK__SHIFT 0x10
#define UNBPM_PWRMGT_ACK__ERROR_CODE_MASK 0xff000000
#define UNBPM_PWRMGT_ACK__ERROR_CODE__SHIFT 0x18
#define CURRENT_FREQ_STATE_NB__CURRENT_FID_MASK 0xff
#define CURRENT_FREQ_STATE_NB__CURRENT_FID__SHIFT 0x0
#define CURRENT_FREQ_STATE_NB__CURRENT_DID_MASK 0xff00
#define CURRENT_FREQ_STATE_NB__CURRENT_DID__SHIFT 0x8
#define CURRENT_FREQ_STATE_NB__NB_LOW_POWER_MASK 0xff0000
#define CURRENT_FREQ_STATE_NB__NB_LOW_POWER__SHIFT 0x10
#define CURRENT_FREQ_STATE_NB__NB_STUTTER_MODE_MASK 0xff000000
#define CURRENT_FREQ_STATE_NB__NB_STUTTER_MODE__SHIFT 0x18
#define CURRENT_PSTATE_NB__CURRENT_PSTATE_ID_MASK 0xff
#define CURRENT_PSTATE_NB__CURRENT_PSTATE_ID__SHIFT 0x0
#define CURRENT_PSTATE_NB__CURRENT_PSTATE_LO_MASK 0x100
#define CURRENT_PSTATE_NB__CURRENT_PSTATE_LO__SHIFT 0x8
#define CURRENT_PSTATE_NB__CURRENT_MEM_PSTATE_ID_MASK 0x200
#define CURRENT_PSTATE_NB__CURRENT_MEM_PSTATE_ID__SHIFT 0x9
#define UNBPM_MSG_INT_CONFIG__MSG_REG_TARGET_ADDR_MASK 0xffffffff
#define UNBPM_MSG_INT_CONFIG__MSG_REG_TARGET_ADDR__SHIFT 0x0
#define UNBPM_NBPWRMGT_CMD__TARGET_BLOCK_MASK 0x3
#define UNBPM_NBPWRMGT_CMD__TARGET_BLOCK__SHIFT 0x0
#define UNBPM_NBPWRMGT_CMD__TARGET_CMD_MASK 0x100
#define UNBPM_NBPWRMGT_CMD__TARGET_CMD__SHIFT 0x8
#define UNBPM_NBPWRMGT_CMD__DCT_SR_MAP_MASK 0xff0000
#define UNBPM_NBPWRMGT_CMD__DCT_SR_MAP__SHIFT 0x10
#define UNBPM_NBPWRMGT_CMD__RETURN_NB_ACK_MASK 0x1000000
#define UNBPM_NBPWRMGT_CMD__RETURN_NB_ACK__SHIFT 0x18
#define UNBPM_NBPWRMGT_CMD__OVERRIDE_PARAMS_MASK 0x2000000
#define UNBPM_NBPWRMGT_CMD__OVERRIDE_PARAMS__SHIFT 0x19
#define UNBPM_NBPWRMGT_CMD__SET_NB_LOW_POWER_MASK 0x4000000
#define UNBPM_NBPWRMGT_CMD__SET_NB_LOW_POWER__SHIFT 0x1a
#define UNBPM_NBPWRMGT_CMD__SET_NB_STUTTER_MODE_MASK 0x8000000
#define UNBPM_NBPWRMGT_CMD__SET_NB_STUTTER_MODE__SHIFT 0x1b
#define UNBPM_NBPWRMGT_FSM_CFG__DIS_AUTO_PWRGATE_ON_EXIT_MASK 0x2
#define UNBPM_NBPWRMGT_FSM_CFG__DIS_AUTO_PWRGATE_ON_EXIT__SHIFT 0x1
#define DDR0_FUSE_SSB_XFER__START_STATUS_XFER_MASK 0x1
#define DDR0_FUSE_SSB_XFER__START_STATUS_XFER__SHIFT 0x0
#define DDR0_FUSE_SSB_XFER_CFG__FUSE_DDR0_LAST_ADDR_MASK 0x7ff
#define DDR0_FUSE_SSB_XFER_CFG__FUSE_DDR0_LAST_ADDR__SHIFT 0x0
#define DDR1_FUSE_SSB_XFER__START_STATUS_XFER_MASK 0x1
#define DDR1_FUSE_SSB_XFER__START_STATUS_XFER__SHIFT 0x0
#define DDR1_FUSE_SSB_XFER_CFG__FUSE_DDR1_LAST_ADDR_MASK 0x7ff
#define DDR1_FUSE_SSB_XFER_CFG__FUSE_DDR1_LAST_ADDR__SHIFT 0x0
#define UNBPM_FUSES_VAL_PWROK__CK_FUSES_VAL_PWROK_MASK 0x1
#define UNBPM_FUSES_VAL_PWROK__CK_FUSES_VAL_PWROK__SHIFT 0x0
#define SYNFIFO_CLK_RATIO__CK_CCLK_IS_FASTER0_MASK 0x1
#define SYNFIFO_CLK_RATIO__CK_CCLK_IS_FASTER0__SHIFT 0x0
#define SYNFIFO_CLK_RATIO__CK_CCLK_IS_FASTER1_MASK 0x2
#define SYNFIFO_CLK_RATIO__CK_CCLK_IS_FASTER1__SHIFT 0x1
#define SYNFIFO_CLK_RATIO__CK_NCLK_IS_FASTER0_MASK 0x4
#define SYNFIFO_CLK_RATIO__CK_NCLK_IS_FASTER0__SHIFT 0x2
#define SYNFIFO_CLK_RATIO__CK_NCLK_IS_FASTER1_MASK 0x8
#define SYNFIFO_CLK_RATIO__CK_NCLK_IS_FASTER1__SHIFT 0x3
#define SYNFIFO_CLK_RATIO__CK_SYNFIFO_ASYNC_EN0_MASK 0x10
#define SYNFIFO_CLK_RATIO__CK_SYNFIFO_ASYNC_EN0__SHIFT 0x4
#define SYNFIFO_CLK_RATIO__CK_SYNFIFO_ASYNC_EN1_MASK 0x20
#define SYNFIFO_CLK_RATIO__CK_SYNFIFO_ASYNC_EN1__SHIFT 0x5
#define MISC_SMU_PWRMGT_CFG0__TARGET_ADDR_MASK 0xffffffff
#define MISC_SMU_PWRMGT_CFG0__TARGET_ADDR__SHIFT 0x0
#define MISC_GNB_PWRMGT_CFG1__TIMER_EN_MASK 0x1
#define MISC_GNB_PWRMGT_CFG1__TIMER_EN__SHIFT 0x0
#define MISC_GNB_PWRMGT_CFG1__TIMER_INTERVAL_MASK 0x1fffe
#define MISC_GNB_PWRMGT_CFG1__TIMER_INTERVAL__SHIFT 0x1
#define MISC_GNB_PWRMGT_CFG1__INT_GEN_EN_MASK 0x20000
#define MISC_GNB_PWRMGT_CFG1__INT_GEN_EN__SHIFT 0x11
#define MISC_SMU_PWRMGT_CFG1__TIMER_EN_MASK 0x1
#define MISC_SMU_PWRMGT_CFG1__TIMER_EN__SHIFT 0x0
#define MISC_SMU_PWRMGT_CFG1__TIMER_INTERVAL_MASK 0x1fffe
#define MISC_SMU_PWRMGT_CFG1__TIMER_INTERVAL__SHIFT 0x1
#define MISC_SMU_PWRMGT_CFG1__INT_GEN_EN_MASK 0x20000
#define MISC_SMU_PWRMGT_CFG1__INT_GEN_EN__SHIFT 0x11
#define MISC_GNB_PWRMGT_DATA__GN_ON_INB_WAKE_MASK 0x1
#define MISC_GNB_PWRMGT_DATA__GN_ON_INB_WAKE__SHIFT 0x0
#define MISC_GNB_PWRMGT_DATA__GN_ALLOW_NB_PSTATES_MASK 0x2
#define MISC_GNB_PWRMGT_DATA__GN_ALLOW_NB_PSTATES__SHIFT 0x1
#define MISC_GNB_PWRMGT_DATA__GN_FLUSH_REQ_TOGGLE_MASK 0x4
#define MISC_GNB_PWRMGT_DATA__GN_FLUSH_REQ_TOGGLE__SHIFT 0x2
#define MISC_GNB_PWRMGT_DATA__GN_CROSS_TRIGGER_MASK 0x78
#define MISC_GNB_PWRMGT_DATA__GN_CROSS_TRIGGER__SHIFT 0x3
#define MISC_GNB_PWRMGT_DATA__GN_STOP_CLOCKS_MASK 0x80
#define MISC_GNB_PWRMGT_DATA__GN_STOP_CLOCKS__SHIFT 0x7
#define MISC_GNB_PWRMGT_DATA__GN_ON3_CH0LINK_WAKE_MASK 0x100
#define MISC_GNB_PWRMGT_DATA__GN_ON3_CH0LINK_WAKE__SHIFT 0x8
#define MISC_GNB_PWRMGT_DATA__GN_ON3_CH1LINK_WAKE_MASK 0x200
#define MISC_GNB_PWRMGT_DATA__GN_ON3_CH1LINK_WAKE__SHIFT 0x9
#define GN_GNB_SLOW__GN_GNB_SLOW_DATA_MASK 0x1
#define GN_GNB_SLOW__GN_GNB_SLOW_DATA__SHIFT 0x0
#define GN_FORCE_NBPS1__GN_FORCE_NBPS1_DATA_MASK 0x1
#define GN_FORCE_NBPS1__GN_FORCE_NBPS1_DATA__SHIFT 0x0
#define MISC_SMU_PWRMGT_DATA__NB_NBPS_MASK 0x1
#define MISC_SMU_PWRMGT_DATA__NB_NBPS__SHIFT 0x0
#define MISC_SMU_PWRMGT_DATA__NB_MEMPS_MASK 0x2
#define MISC_SMU_PWRMGT_DATA__NB_MEMPS__SHIFT 0x1
#define NB_COF__NB_COF_MASK 0xffff
#define NB_COF__NB_COF__SHIFT 0x0
#define UNBPM_CK_IRESET__CK_IRESET_LOCAL_MASK 0x1
#define UNBPM_CK_IRESET__CK_IRESET_LOCAL__SHIFT 0x0
#define CURRENT_VID_NB__CURRENT_VID_MASK 0xff
#define CURRENT_VID_NB__CURRENT_VID__SHIFT 0x0
#define SPR_FUSE_PSTATEPWR1__PwrValue0_MASK 0xff
#define SPR_FUSE_PSTATEPWR1__PwrValue0__SHIFT 0x0
#define SPR_FUSE_PSTATEPWR1__PwrValue1_MASK 0xff00
#define SPR_FUSE_PSTATEPWR1__PwrValue1__SHIFT 0x8
#define SPR_FUSE_PSTATEPWR1__PwrValue2_MASK 0xff0000
#define SPR_FUSE_PSTATEPWR1__PwrValue2__SHIFT 0x10
#define SPR_FUSE_PSTATEPWR1__PwrValue3_MASK 0xff000000
#define SPR_FUSE_PSTATEPWR1__PwrValue3__SHIFT 0x18
#define SPR_FUSE_PSTATEPWR2__PwrValue4_MASK 0xff
#define SPR_FUSE_PSTATEPWR2__PwrValue4__SHIFT 0x0
#define SPR_FUSE_PSTATEPWR2__PwrDiv0_MASK 0x300
#define SPR_FUSE_PSTATEPWR2__PwrDiv0__SHIFT 0x8
#define SPR_FUSE_PSTATEPWR2__PwrDiv1_MASK 0xc00
#define SPR_FUSE_PSTATEPWR2__PwrDiv1__SHIFT 0xa
#define SPR_FUSE_PSTATEPWR2__PwrDiv2_MASK 0x3000
#define SPR_FUSE_PSTATEPWR2__PwrDiv2__SHIFT 0xc
#define SPR_FUSE_PSTATEPWR2__PwrDiv3_MASK 0xc000
#define SPR_FUSE_PSTATEPWR2__PwrDiv3__SHIFT 0xe
#define SPR_FUSE_PSTATEPWR2__PwrDiv4_MASK 0x30000
#define SPR_FUSE_PSTATEPWR2__PwrDiv4__SHIFT 0x10
#define SPR_FUSE_PSTATEPWR2__PwrDiv5_MASK 0xc0000
#define SPR_FUSE_PSTATEPWR2__PwrDiv5__SHIFT 0x12
#define SPR_FUSE_PSTATEPWR2__PwrDiv6_MASK 0x300000
#define SPR_FUSE_PSTATEPWR2__PwrDiv6__SHIFT 0x14
#define SPR_FUSE_PSTATEPWR2__PwrDiv7_MASK 0xc00000
#define SPR_FUSE_PSTATEPWR2__PwrDiv7__SHIFT 0x16
#define SPR_FUSE_PSTATEPWR2__Reserved_MASK 0xff000000
#define SPR_FUSE_PSTATEPWR2__Reserved__SHIFT 0x18
#define SPR_FUSE_PSTATEPWR3__PwrValue5_MASK 0xff
#define SPR_FUSE_PSTATEPWR3__PwrValue5__SHIFT 0x0
#define SPR_FUSE_PSTATEPWR3__PwrValue6_MASK 0xff00
#define SPR_FUSE_PSTATEPWR3__PwrValue6__SHIFT 0x8
#define SPR_FUSE_PSTATEPWR3__PwrValue7_MASK 0xff0000
#define SPR_FUSE_PSTATEPWR3__PwrValue7__SHIFT 0x10
#define SPR_FUSE_PSTATEPWR3__Reserved_MASK 0xff000000
#define SPR_FUSE_PSTATEPWR3__Reserved__SHIFT 0x18
#define SPR_FUSE_THERMAL_SCRATCH__ThermalScratch_MASK 0xffffffff
#define SPR_FUSE_THERMAL_SCRATCH__ThermalScratch__SHIFT 0x0
#define SPR_PRODUCT_INFO0__BrandId_MASK 0xffff
#define SPR_PRODUCT_INFO0__BrandId__SHIFT 0x0
#define SPR_PRODUCT_INFO0__Reserved0_MASK 0x70000
#define SPR_PRODUCT_INFO0__Reserved0__SHIFT 0x10
#define SPR_PRODUCT_INFO0__SerialNumRdDis_MASK 0x80000
#define SPR_PRODUCT_INFO0__SerialNumRdDis__SHIFT 0x13
#define SPR_PRODUCT_INFO0__Reserved1_MASK 0xfff00000
#define SPR_PRODUCT_INFO0__Reserved1__SHIFT 0x14
#define SPR_SERIALNUM_REG1__SPR_SERIALNUM_REG1_MASK 0xffffffff
#define SPR_SERIALNUM_REG1__SPR_SERIALNUM_REG1__SHIFT 0x0
#define SPR_SERIALNUM_REG2__SPR_SERIALNUM_REG2_MASK 0xffffffff
#define SPR_SERIALNUM_REG2__SPR_SERIALNUM_REG2__SHIFT 0x0
#define SPR_PRODUCT_INFO1__DiDtMode_MASK 0x1
#define SPR_PRODUCT_INFO1__DiDtMode__SHIFT 0x0
#define SPR_PRODUCT_INFO1__DiDtCfg0_MASK 0x3e
#define SPR_PRODUCT_INFO1__DiDtCfg0__SHIFT 0x1
#define SPR_PRODUCT_INFO1__DiDtCfg1_MASK 0x3fc0
#define SPR_PRODUCT_INFO1__DiDtCfg1__SHIFT 0x6
#define SPR_PRODUCT_INFO1__DiDtCfg2_MASK 0xc000
#define SPR_PRODUCT_INFO1__DiDtCfg2__SHIFT 0xe
#define SPR_PRODUCT_INFO1__DiDtCfg3_MASK 0x10000
#define SPR_PRODUCT_INFO1__DiDtCfg3__SHIFT 0x10
#define SPR_PRODUCT_INFO1__DiDtCfg4_MASK 0x1e0000
#define SPR_PRODUCT_INFO1__DiDtCfg4__SHIFT 0x11
#define SPR_PRODUCT_INFO1__Reserved_MASK 0xffe00000
#define SPR_PRODUCT_INFO1__Reserved__SHIFT 0x15
#define SPR_EXT_PRODUCT_INFO__Reserved_MASK 0xffffffff
#define SPR_EXT_PRODUCT_INFO__Reserved__SHIFT 0x0
#define SPR_MSIDFUSE__MSID_MASK 0xffffff
#define SPR_MSIDFUSE__MSID__SHIFT 0x0
#define SPR_MSIDFUSE__Reserved_MASK 0xff000000
#define SPR_MSIDFUSE__Reserved__SHIFT 0x18
#define SPR_LINK_PRODUCT_INFO__Reserved_MASK 0xffffffff
#define SPR_LINK_PRODUCT_INFO__Reserved__SHIFT 0x0
#define SPR_BRAND_NAME_ADDR__Index_MASK 0xf
#define SPR_BRAND_NAME_ADDR__Index__SHIFT 0x0
#define SPR_BRAND_NAME_ADDR__Reserved_MASK 0xfffffff0
#define SPR_BRAND_NAME_ADDR__Reserved__SHIFT 0x4
#define SPR_BRAND_NAME_DATA__DATA_MASK 0xffffffff
#define SPR_BRAND_NAME_DATA__DATA__SHIFT 0x0
#define SPR_COMBO_PHY_PRODUCT_INFO__SPR_COMBO_PHY_PRODUCT_INFO_MASK 0xffffffff
#define SPR_COMBO_PHY_PRODUCT_INFO__SPR_COMBO_PHY_PRODUCT_INFO__SHIFT 0x0
#define MISC_GNB_PWRMGT_CFG0__TARGET_ADDR_MASK 0xffffffff
#define MISC_GNB_PWRMGT_CFG0__TARGET_ADDR__SHIFT 0x0
#define UNBPM_EXIT_TO_PSTATE__EXIT_TO_PSTATE_MASK 0x1
#define UNBPM_EXIT_TO_PSTATE__EXIT_TO_PSTATE__SHIFT 0x0
#define UNBPM_WARM_RESET_HS_STATUS__NB_CSTATE_ACTIVE_MASK 0x1
#define UNBPM_WARM_RESET_HS_STATUS__NB_CSTATE_ACTIVE__SHIFT 0x0
#define UNBPM_WARM_RESET_HS_STATUS__WARM_RESET_HS_DONE_MASK 0x2
#define UNBPM_WARM_RESET_HS_STATUS__WARM_RESET_HS_DONE__SHIFT 0x1
#define UNBPM_VOLTAGE_CNTL__VOLTAGE_EN_MASK 0x1
#define UNBPM_VOLTAGE_CNTL__VOLTAGE_EN__SHIFT 0x0
#define UNBPM_VOLTAGE_CNTL__VOLTAGE_LEVEL_MASK 0x1fe
#define UNBPM_VOLTAGE_CNTL__VOLTAGE_LEVEL__SHIFT 0x1
#define UNBPM_VOLTAGE_STATUS__VOLTAGE_STATUS_MASK 0x1
#define UNBPM_VOLTAGE_STATUS__VOLTAGE_STATUS__SHIFT 0x0
#define UNBPM_VOLTAGE_STATUS__VOLTAGE_CURRENT_LEVEL_MASK 0x1fe
#define UNBPM_VOLTAGE_STATUS__VOLTAGE_CURRENT_LEVEL__SHIFT 0x1
#define NUM_BOOST_STATES__NUM_BOOST_STATES_MASK 0x7
#define NUM_BOOST_STATES__NUM_BOOST_STATES__SHIFT 0x0
#define WARM_RESET_NB_CONTROL__WARM_RESET_CPU_VID_MASK 0xff
#define WARM_RESET_NB_CONTROL__WARM_RESET_CPU_VID__SHIFT 0x0
#define WARM_RESET_NB_CONTROL__NB_DISABLE_CORE_MASK 0xff00
#define WARM_RESET_NB_CONTROL__NB_DISABLE_CORE__SHIFT 0x8
#define ONION_NO_STREAMS_PEND__ONION_NO_STREAMS_PEND_MASK 0x1
#define ONION_NO_STREAMS_PEND__ONION_NO_STREAMS_PEND__SHIFT 0x0
#define ONION_NO_STREAMS_PEND__ONION3_NO_STREAMS_PEND_0_MASK 0x2
#define ONION_NO_STREAMS_PEND__ONION3_NO_STREAMS_PEND_0__SHIFT 0x1
#define ONION_NO_STREAMS_PEND__ONION3_NO_STREAMS_PEND_1_MASK 0x4
#define ONION_NO_STREAMS_PEND__ONION3_NO_STREAMS_PEND_1__SHIFT 0x2
#define SPR_PROGRAMMABLE_CTRL__PllRegUpTime_MASK 0x3
#define SPR_PROGRAMMABLE_CTRL__PllRegUpTime__SHIFT 0x0
#define SPR_PROGRAMMABLE_CTRL__PllVddOutUpTime_MASK 0xc
#define SPR_PROGRAMMABLE_CTRL__PllVddOutUpTime__SHIFT 0x2
#define SPR_PROGRAMMABLE_CTRL__ResonanceTime_MASK 0x30
#define SPR_PROGRAMMABLE_CTRL__ResonanceTime__SHIFT 0x4
#define SPR_PROGRAMMABLE_CTRL__C6PLLPwrDnReg_MASK 0x40
#define SPR_PROGRAMMABLE_CTRL__C6PLLPwrDnReg__SHIFT 0x6
#define SPR_PROGRAMMABLE_CTRL__CC6PLLPwrDnVCO_MASK 0x80
#define SPR_PROGRAMMABLE_CTRL__CC6PLLPwrDnVCO__SHIFT 0x7
#define SPR_PROGRAMMABLE_CTRL__CC6PLLPwrDnReg_MASK 0x100
#define SPR_PROGRAMMABLE_CTRL__CC6PLLPwrDnReg__SHIFT 0x8
#define SPR_PROGRAMMABLE_CTRL__NbPLLPwrDnReg_MASK 0x200
#define SPR_PROGRAMMABLE_CTRL__NbPLLPwrDnReg__SHIFT 0x9
#define SPR_PROGRAMMABLE_CTRL__SOIWait_MASK 0x3c00
#define SPR_PROGRAMMABLE_CTRL__SOIWait__SHIFT 0xa
#define PHN_FUSERX_MISC_FUSES__Spare_MASK 0xff
#define PHN_FUSERX_MISC_FUSES__Spare__SHIFT 0x0
#define PHN_FUSERX_MISC_FUSES__OverClockRefClkDis_MASK 0x100
#define PHN_FUSERX_MISC_FUSES__OverClockRefClkDis__SHIFT 0x8
#define PHN_FUSERX_MISC_FUSES__MemPstate_MASK 0x1e00
#define PHN_FUSERX_MISC_FUSES__MemPstate__SHIFT 0x9
#define PHN_FUSERX_MISC_FUSES__NbPstateHi_MASK 0x6000
#define PHN_FUSERX_MISC_FUSES__NbPstateHi__SHIFT 0xd
#define PHN_FUSERX_MISC_FUSES__NbPstateLo_MASK 0x18000
#define PHN_FUSERX_MISC_FUSES__NbPstateLo__SHIFT 0xf
#define PHN_FUSERX_MISC_FUSES__ScanCLK400MHz_MASK 0x20000
#define PHN_FUSERX_MISC_FUSES__ScanCLK400MHz__SHIFT 0x11
#define PHN_FUSERX_MISC_FUSES__CoreDis_MASK 0x3c0000
#define PHN_FUSERX_MISC_FUSES__CoreDis__SHIFT 0x12
#define PHN_FUSERX_MISC_FUSES__PHN_FusesValid_MASK 0x80000000
#define PHN_FUSERX_MISC_FUSES__PHN_FusesValid__SHIFT 0x1f
#define UNBPM_PWRCTRL_MISC__PWRGATEMASTERDIS_MASK 0x1
#define UNBPM_PWRCTRL_MISC__PWRGATEMASTERDIS__SHIFT 0x0
#define CSTATE_ACTIVE_SAMPLER__SAMPLE_TIME_MASK 0x1f
#define CSTATE_ACTIVE_SAMPLER__SAMPLE_TIME__SHIFT 0x0
#define UNBPM_DEBUG_CONFIG_STATUS__AXI_MASTER_QOS_MASK 0xf
#define UNBPM_DEBUG_CONFIG_STATUS__AXI_MASTER_QOS__SHIFT 0x0
#define UNBPM_DEBUG_CONFIG_STATUS__FIFO_BUFF_FLUSH_MASK 0x10
#define UNBPM_DEBUG_CONFIG_STATUS__FIFO_BUFF_FLUSH__SHIFT 0x4
#define UNBPM_DEBUG_CONFIG_STATUS__MASTER_DEBUG_EN_MASK 0x20
#define UNBPM_DEBUG_CONFIG_STATUS__MASTER_DEBUG_EN__SHIFT 0x5
#define UNBPM_DEBUG_CONFIG_STATUS__AXI_MASTER_ACTIVE_MASK 0x100
#define UNBPM_DEBUG_CONFIG_STATUS__AXI_MASTER_ACTIVE__SHIFT 0x8
#define UNBPM_DEBUG_CONFIG_STATUS__AXI_MASTER_BUSY_MASK 0x200
#define UNBPM_DEBUG_CONFIG_STATUS__AXI_MASTER_BUSY__SHIFT 0x9
#define UNBPM_DEBUG_CONFIG_STATUS__FIFO_DATA_COUNT_MASK 0x3c00
#define UNBPM_DEBUG_CONFIG_STATUS__FIFO_DATA_COUNT__SHIFT 0xa
#define UNBPM_DEBUG_CONFIG_STATUS__MST_OUTSTANDING_TRANS_MASK 0xff0000
#define UNBPM_DEBUG_CONFIG_STATUS__MST_OUTSTANDING_TRANS__SHIFT 0x10
#define UNBPM_AXIMST_LAST_CMD__AXI_MASTER_LAST_CMD_MASK 0xffffffff
#define UNBPM_AXIMST_LAST_CMD__AXI_MASTER_LAST_CMD__SHIFT 0x0
#define UNB_IF_INTRGEN_LAST_SENT__GNBPM_LAST_DATA_SENT_MASK 0xffff
#define UNB_IF_INTRGEN_LAST_SENT__GNBPM_LAST_DATA_SENT__SHIFT 0x0
#define UNB_IF_INTRGEN_LAST_SENT__SMUPM_LAST_DATA_SENT_MASK 0xffff0000
#define UNB_IF_INTRGEN_LAST_SENT__SMUPM_LAST_DATA_SENT__SHIFT 0x10
#define UNBPM_DEBUG_BUS_CNTL__DEBUG_BUS_LOGGING_EN_MASK 0x1
#define UNBPM_DEBUG_BUS_CNTL__DEBUG_BUS_LOGGING_EN__SHIFT 0x0
#define UNBPM_DEBUG_BUS_CNTL__DEBUG_BUS_CYCLE_NUM_MASK 0x1fe
#define UNBPM_DEBUG_BUS_CNTL__DEBUG_BUS_CYCLE_NUM__SHIFT 0x1
#define UNBPM_PWRMGT_REQ_DBG_STATUS__NB_PwrMgtReqNb_MASK 0x1
#define UNBPM_PWRMGT_REQ_DBG_STATUS__NB_PwrMgtReqNb__SHIFT 0x0
#define UNBPM_PWRMGT_REQ_DBG_STATUS__NB_PwrMgtReqDct_MASK 0x6
#define UNBPM_PWRMGT_REQ_DBG_STATUS__NB_PwrMgtReqDct__SHIFT 0x1
#define UNBPM_PWRMGT_REQ_DBG_STATUS__NB_PwrMgtReqCpu_MASK 0x38
#define UNBPM_PWRMGT_REQ_DBG_STATUS__NB_PwrMgtReqCpu__SHIFT 0x3
#define UNBPM_PWRMGT_REQ_DBG_STATUS__NB_PwrMgtReqCpuPwrTog_MASK 0x40
#define UNBPM_PWRMGT_REQ_DBG_STATUS__NB_PwrMgtReqCpuPwrTog__SHIFT 0x6
#define UNBPM_PWRMGT_REQ_DBG_STATUS__NB_PwrMgtReqNbPstateLo_MASK 0x80
#define UNBPM_PWRMGT_REQ_DBG_STATUS__NB_PwrMgtReqNbPstateLo__SHIFT 0x7
#define UNBPM_PWRMGT_REQ_DBG_STATUS__NB_PwrMgtReqNbMemPstate_MASK 0x100
#define UNBPM_PWRMGT_REQ_DBG_STATUS__NB_PwrMgtReqNbMemPstate__SHIFT 0x8
#define UNBPM_PWRMGT_REQ_DBG_STATUS__NB_PwrMgtReqCpuNbFid_MASK 0x7e00
#define UNBPM_PWRMGT_REQ_DBG_STATUS__NB_PwrMgtReqCpuNbFid__SHIFT 0x9
#define UNBPM_PWRMGT_REQ_DBG_STATUS__NB_PwrMgtReqDid_MASK 0x38000
#define UNBPM_PWRMGT_REQ_DBG_STATUS__NB_PwrMgtReqDid__SHIFT 0xf
#define UNBPM_PWRMGT_REQ_DBG_STATUS__NB_PwrMgtReqPstate_MASK 0x40000
#define UNBPM_PWRMGT_REQ_DBG_STATUS__NB_PwrMgtReqPstate__SHIFT 0x12
#define UNBPM_PWRMGT_REQ_DBG_STATUS__NB_PwrMgtReqPstateId_MASK 0x380000
#define UNBPM_PWRMGT_REQ_DBG_STATUS__NB_PwrMgtReqPstateId__SHIFT 0x13
#define UNBPM_PWRMGT_REQ_DBG_STATUS__NB_PwrMgtReqGateEn_MASK 0x400000
#define UNBPM_PWRMGT_REQ_DBG_STATUS__NB_PwrMgtReqGateEn__SHIFT 0x16
#define UNBPM_PWRMGT_REQ_DBG_STATUS__NB_PwrMgtReqCpuPrbEn_MASK 0x800000
#define UNBPM_PWRMGT_REQ_DBG_STATUS__NB_PwrMgtReqCpuPrbEn__SHIFT 0x17
#define UNBPM_PWRMGT_REQ_DBG_STATUS__NbPwrMgtReqOutstanding_MASK 0x7000000
#define UNBPM_PWRMGT_REQ_DBG_STATUS__NbPwrMgtReqOutstanding__SHIFT 0x18
#define UNBPM_VIDCHG_REQ_DBG_STATUS__NB_VidChgZeroVid_MASK 0x1
#define UNBPM_VIDCHG_REQ_DBG_STATUS__NB_VidChgZeroVid__SHIFT 0x0
#define UNBPM_VIDCHG_REQ_DBG_STATUS__NB_VidPlane_MASK 0x6
#define UNBPM_VIDCHG_REQ_DBG_STATUS__NB_VidPlane__SHIFT 0x1
#define UNBPM_VIDCHG_REQ_DBG_STATUS__NB_VidChgRamp_MASK 0x8
#define UNBPM_VIDCHG_REQ_DBG_STATUS__NB_VidChgRamp__SHIFT 0x3
#define UNBPM_VIDCHG_REQ_DBG_STATUS__NB_Vid_MASK 0xff0
#define UNBPM_VIDCHG_REQ_DBG_STATUS__NB_Vid__SHIFT 0x4
#define UNBPM_VIDCHG_REQ_DBG_STATUS__NB_VSTime_MASK 0x7000
#define UNBPM_VIDCHG_REQ_DBG_STATUS__NB_VSTime__SHIFT 0xc
#define UNBPM_VIDCHG_REQ_DBG_STATUS__CK_VidChgBusy_MASK 0x10000
#define UNBPM_VIDCHG_REQ_DBG_STATUS__CK_VidChgBusy__SHIFT 0x10
#define UNBPM_SCRATCH_0__DATA_MASK 0xffffffff
#define UNBPM_SCRATCH_0__DATA__SHIFT 0x0
#define UNBPM_SCRATCH_1__DATA_MASK 0xffffffff
#define UNBPM_SCRATCH_1__DATA__SHIFT 0x0
#define POWERON_CPU_0__POWERON_MASK 0x1
#define POWERON_CPU_0__POWERON__SHIFT 0x0
#define POWERREADY_CPU_0__POWERREADY_MASK 0x1
#define POWERREADY_CPU_0__POWERREADY__SHIFT 0x0
#define PGRUNFEEDBACK_CPU_0__PG_RUNFEEDBACK_MASK 0x1
#define PGRUNFEEDBACK_CPU_0__PG_RUNFEEDBACK__SHIFT 0x0
#define RCC3ON_CPU_0__CK_RCC3ON_MASK 0x1
#define RCC3ON_CPU_0__CK_RCC3ON__SHIFT 0x0
#define RCC3ON_CPU_0__RCC3_PSM_EN_MASK 0x2
#define RCC3ON_CPU_0__RCC3_PSM_EN__SHIFT 0x1
#define RCC3ON_CPU_0__RCC3_PSM_CLK_DIV_MASK 0xc
#define RCC3ON_CPU_0__RCC3_PSM_CLK_DIV__SHIFT 0x2
#define RCC3ON_CPU_0__RCC3_AVG_EN_MASK 0x10
#define RCC3ON_CPU_0__RCC3_AVG_EN__SHIFT 0x4
#define RCC3ON_CPU_0__RCC3_AVG_DIV_MASK 0x7e0
#define RCC3ON_CPU_0__RCC3_AVG_DIV__SHIFT 0x5
#define RCC3ON_CPU_0__RCC3_DIDT_TIMER_MASK 0x1f800
#define RCC3ON_CPU_0__RCC3_DIDT_TIMER__SHIFT 0xb
#define RCC3ON_CPU_0__RCC3_WAKE_MIN_14_0_MASK 0xfffe0000
#define RCC3ON_CPU_0__RCC3_WAKE_MIN_14_0__SHIFT 0x11
#define RCC3EXITDONE_CPU_0__RCC3EXITDONE_MASK 0x1
#define RCC3EXITDONE_CPU_0__RCC3EXITDONE__SHIFT 0x0
#define CORE_FUNC_LATE_SSB_XFER_0__START_STATUS_XFER_MASK 0x1
#define CORE_FUNC_LATE_SSB_XFER_0__START_STATUS_XFER__SHIFT 0x0
#define CORE_FUNC_LATE_SSB_XFER_CFG_0__FUSE_FUNC_LAST_ADDR_MASK 0x7ff
#define CORE_FUNC_LATE_SSB_XFER_CFG_0__FUSE_FUNC_LAST_ADDR__SHIFT 0x0
#define CORE_FUNC_LATE_SSB_XFER_CFG_0__FUSE_LATE_LAST_ADDR_MASK 0x7ff0000
#define CORE_FUNC_LATE_SSB_XFER_CFG_0__FUSE_LATE_LAST_ADDR__SHIFT 0x10
#define CORE_REDUN_SSB_XFER_0__START_STATUS_XFER_MASK 0x1
#define CORE_REDUN_SSB_XFER_0__START_STATUS_XFER__SHIFT 0x0
#define CORE_REDUN_SSB_XFER_CFG_0__FUSE_REDUN_LAST_ADDR_MASK 0x7ff
#define CORE_REDUN_SSB_XFER_CFG_0__FUSE_REDUN_LAST_ADDR__SHIFT 0x0
#define CORE_APM_SSB_XFER_0__START_STATUS_XFER_MASK 0x1
#define CORE_APM_SSB_XFER_0__START_STATUS_XFER__SHIFT 0x0
#define CORE_APM_SSB_XFER_CFG_0__FUSE_APM_LAST_ADDR_MASK 0x7ff
#define CORE_APM_SSB_XFER_CFG_0__FUSE_APM_LAST_ADDR__SHIFT 0x0
#define COREPM_PWRCTRL_MISC_0__PWRGATEMASTERDIS_MASK 0x1
#define COREPM_PWRCTRL_MISC_0__PWRGATEMASTERDIS__SHIFT 0x0
#define LDOIVRON_CPU_0__CK_LDOIVRON_MASK 0x1
#define LDOIVRON_CPU_0__CK_LDOIVRON__SHIFT 0x0
#define LDOIVREXITDONE_CPU_0__LDOIVREXITDONE_MASK 0x1
#define LDOIVREXITDONE_CPU_0__LDOIVREXITDONE__SHIFT 0x0
#define RCC3_TARGETPSMREF_CPU_0__RCC3_TARGETPSMREF_MASK 0x3fff
#define RCC3_TARGETPSMREF_CPU_0__RCC3_TARGETPSMREF__SHIFT 0x0
#define IVR_TARGETPSMREF_CPU_0__IVR_TARGETPSMREF_MASK 0x3fff
#define IVR_TARGETPSMREF_CPU_0__IVR_TARGETPSMREF__SHIFT 0x0
#define CK_JTCOOLRESET_LATCHED_CPU_0__CK_JTCOOLRESET_LATCHED_MASK 0x1
#define CK_JTCOOLRESET_LATCHED_CPU_0__CK_JTCOOLRESET_LATCHED__SHIFT 0x0
#define CK_DISABLECORE_CPU_0__CK_DISABLECORE_MASK 0x1
#define CK_DISABLECORE_CPU_0__CK_DISABLECORE__SHIFT 0x0
#define COREPM_ID_0__COREPM_INDEX_MASK 0x1
#define COREPM_ID_0__COREPM_INDEX__SHIFT 0x0
#define COREPM_SCRATCH_0__SCRATCH_DATA_MASK 0xffffffff
#define COREPM_SCRATCH_0__SCRATCH_DATA__SHIFT 0x0
#define RCC3_WAKEMIN_CPU_0__RCC3_WAKE_MIN_46_15_MASK 0xffffffff
#define RCC3_WAKEMIN_CPU_0__RCC3_WAKE_MIN_46_15__SHIFT 0x0
#define SPMI_CONFIG0_0__SPMI_ENABLE_MASK 0x1
#define SPMI_CONFIG0_0__SPMI_ENABLE__SHIFT 0x0
#define SPMI_CONFIG0_0__SPMI_PATH_NUM_TIMING_FLOPS_MASK 0x7c
#define SPMI_CONFIG0_0__SPMI_PATH_NUM_TIMING_FLOPS__SHIFT 0x2
#define SPMI_CONFIG0_0__SPMI_SIGNALING_DELAY_CYCLES_MASK 0xf80
#define SPMI_CONFIG0_0__SPMI_SIGNALING_DELAY_CYCLES__SHIFT 0x7
#define SPMI_CONFIG0_0__SPMI_SIGNALING_HOLD_CYCLES_MASK 0x1f000
#define SPMI_CONFIG0_0__SPMI_SIGNALING_HOLD_CYCLES__SHIFT 0xc
#define SPMI_CONFIG0_0__SPMI_PATH_ENABLE_DELAY_CYCLES_MASK 0x3e0000
#define SPMI_CONFIG0_0__SPMI_PATH_ENABLE_DELAY_CYCLES__SHIFT 0x11
#define SPMI_CONFIG0_0__SPMI_PATH_DISABLE_DELAY_CYCLES_MASK 0x7c00000
#define SPMI_CONFIG0_0__SPMI_PATH_DISABLE_DELAY_CYCLES__SHIFT 0x16
#define SPMI_CONFIG1_0__SPMI_SIGNALING_RESET_HOLD_CYCLES_MASK 0x1f
#define SPMI_CONFIG1_0__SPMI_SIGNALING_RESET_HOLD_CYCLES__SHIFT 0x0
#define SPMI_CONFIG1_0__SPMI_CHAIN_SIZE_MASK 0xffe0
#define SPMI_CONFIG1_0__SPMI_CHAIN_SIZE__SHIFT 0x5
#define SPMI_FSM_READ_TRIGGER_0__FSM_READ_TRIGGER_MASK 0x1
#define SPMI_FSM_READ_TRIGGER_0__FSM_READ_TRIGGER__SHIFT 0x0
#define SPMI_FSM_WRITE_TRIGGER_0__FSM_WRITE_TRIGGER_MASK 0x1
#define SPMI_FSM_WRITE_TRIGGER_0__FSM_WRITE_TRIGGER__SHIFT 0x0
#define SPMI_FSM_RESET_TRIGGER_0__FSM_RESET_TRIGGER_MASK 0x1
#define SPMI_FSM_RESET_TRIGGER_0__FSM_RESET_TRIGGER__SHIFT 0x0
#define SPMI_FSM_BUSY_0__FSM_BUSY_MASK 0x1
#define SPMI_FSM_BUSY_0__FSM_BUSY__SHIFT 0x0
#define SPMI_PATH_0__PATH_ENABLE_REQ_MASK 0x1
#define SPMI_PATH_0__PATH_ENABLE_REQ__SHIFT 0x0
#define SPMI_PATH_0__PATH_ENABLE_ACK_MASK 0x2
#define SPMI_PATH_0__PATH_ENABLE_ACK__SHIFT 0x1
#define SPMI_PATH_0__PATH_ENABLE_REQ_auto_clear_MASK 0x10
#define SPMI_PATH_0__PATH_ENABLE_REQ_auto_clear__SHIFT 0x4
#define SPMI_C6_STATE_0__SPMI_IF_C6_STATE_ENTERED_MASK 0x1
#define SPMI_C6_STATE_0__SPMI_IF_C6_STATE_ENTERED__SHIFT 0x0
#define SPMI_C6_STATE_0__SPMI_IF_C6_STATE_ENTERED_WHEN_FSM_BUSY_MASK 0x2
#define SPMI_C6_STATE_0__SPMI_IF_C6_STATE_ENTERED_WHEN_FSM_BUSY__SHIFT 0x1
#define SPMI_C6_STATE_0__SPMI_IF_COUNTER_ADDRESS_C6_MASK 0xfffc
#define SPMI_C6_STATE_0__SPMI_IF_COUNTER_ADDRESS_C6__SHIFT 0x2
#define SPMI_JTAG_OVER_0__SPMI_IF_JTAG_OVER_HAPPENED_MASK 0x1
#define SPMI_JTAG_OVER_0__SPMI_IF_JTAG_OVER_HAPPENED__SHIFT 0x0
#define SPMI_SRAM_ADDRESS_0__SRAM_ADDRESS_MASK 0xffffffff
#define SPMI_SRAM_ADDRESS_0__SRAM_ADDRESS__SHIFT 0x0
#define SPMI_SRAM_DATA_0__SRAM_DATA_MASK 0xffffffff
#define SPMI_SRAM_DATA_0__SRAM_DATA__SHIFT 0x0
#define SPMI_RESET_0__ASYNC_RESET_0_MASK 0x1
#define SPMI_RESET_0__ASYNC_RESET_0__SHIFT 0x0
#define SPMI_RESET_0__SYNC_RESET_MASK 0x80000000
#define SPMI_RESET_0__SYNC_RESET__SHIFT 0x1f
#define SPMI_FORCE_CLOCK_GATERS_0__CLOCK_GATER_0_FORCE_MASK 0x1
#define SPMI_FORCE_CLOCK_GATERS_0__CLOCK_GATER_0_FORCE__SHIFT 0x0
#define SPMI_FORCE_CLOCK_GATERS_0__SRAM_CLOCK_GATER_FORCE_MASK 0x100
#define SPMI_FORCE_CLOCK_GATERS_0__SRAM_CLOCK_GATER_FORCE__SHIFT 0x8
#define SPMI_SPARE_0__SPARE_DATA_MASK 0xffffffff
#define SPMI_SPARE_0__SPARE_DATA__SHIFT 0x0
#define SPMI_SPARE_EX_0__SPARE_DATA_EX_MASK 0xffffffff
#define SPMI_SPARE_EX_0__SPARE_DATA_EX__SHIFT 0x0
#define SPMI_SRAM_CLK_GATER_0__SRAM_CLK_GATER_EN_MASK 0x1
#define SPMI_SRAM_CLK_GATER_0__SRAM_CLK_GATER_EN__SHIFT 0x0
#define SPMI_SRAM_CLK_GATER_0__SRAM_CLK_GATER_TIMER_MASK 0x7fe
#define SPMI_SRAM_CLK_GATER_0__SRAM_CLK_GATER_TIMER__SHIFT 0x1
#define POWERON_CPU_1__POWERON_MASK 0x1
#define POWERON_CPU_1__POWERON__SHIFT 0x0
#define POWERREADY_CPU_1__POWERREADY_MASK 0x1
#define POWERREADY_CPU_1__POWERREADY__SHIFT 0x0
#define PGRUNFEEDBACK_CPU_1__PG_RUNFEEDBACK_MASK 0x1
#define PGRUNFEEDBACK_CPU_1__PG_RUNFEEDBACK__SHIFT 0x0
#define RCC3ON_CPU_1__CK_RCC3ON_MASK 0x1
#define RCC3ON_CPU_1__CK_RCC3ON__SHIFT 0x0
#define RCC3ON_CPU_1__RCC3_PSM_EN_MASK 0x2
#define RCC3ON_CPU_1__RCC3_PSM_EN__SHIFT 0x1
#define RCC3ON_CPU_1__RCC3_PSM_CLK_DIV_MASK 0xc
#define RCC3ON_CPU_1__RCC3_PSM_CLK_DIV__SHIFT 0x2
#define RCC3ON_CPU_1__RCC3_AVG_EN_MASK 0x10
#define RCC3ON_CPU_1__RCC3_AVG_EN__SHIFT 0x4
#define RCC3ON_CPU_1__RCC3_AVG_DIV_MASK 0x7e0
#define RCC3ON_CPU_1__RCC3_AVG_DIV__SHIFT 0x5
#define RCC3ON_CPU_1__RCC3_DIDT_TIMER_MASK 0x1f800
#define RCC3ON_CPU_1__RCC3_DIDT_TIMER__SHIFT 0xb
#define RCC3ON_CPU_1__RCC3_WAKE_MIN_14_0_MASK 0xfffe0000
#define RCC3ON_CPU_1__RCC3_WAKE_MIN_14_0__SHIFT 0x11
#define RCC3EXITDONE_CPU_1__RCC3EXITDONE_MASK 0x1
#define RCC3EXITDONE_CPU_1__RCC3EXITDONE__SHIFT 0x0
#define CORE_FUNC_LATE_SSB_XFER_1__START_STATUS_XFER_MASK 0x1
#define CORE_FUNC_LATE_SSB_XFER_1__START_STATUS_XFER__SHIFT 0x0
#define CORE_FUNC_LATE_SSB_XFER_CFG_1__FUSE_FUNC_LAST_ADDR_MASK 0x7ff
#define CORE_FUNC_LATE_SSB_XFER_CFG_1__FUSE_FUNC_LAST_ADDR__SHIFT 0x0
#define CORE_FUNC_LATE_SSB_XFER_CFG_1__FUSE_LATE_LAST_ADDR_MASK 0x7ff0000
#define CORE_FUNC_LATE_SSB_XFER_CFG_1__FUSE_LATE_LAST_ADDR__SHIFT 0x10
#define CORE_REDUN_SSB_XFER_1__START_STATUS_XFER_MASK 0x1
#define CORE_REDUN_SSB_XFER_1__START_STATUS_XFER__SHIFT 0x0
#define CORE_REDUN_SSB_XFER_CFG_1__FUSE_REDUN_LAST_ADDR_MASK 0x7ff
#define CORE_REDUN_SSB_XFER_CFG_1__FUSE_REDUN_LAST_ADDR__SHIFT 0x0
#define CORE_APM_SSB_XFER_1__START_STATUS_XFER_MASK 0x1
#define CORE_APM_SSB_XFER_1__START_STATUS_XFER__SHIFT 0x0
#define CORE_APM_SSB_XFER_CFG_1__FUSE_APM_LAST_ADDR_MASK 0x7ff
#define CORE_APM_SSB_XFER_CFG_1__FUSE_APM_LAST_ADDR__SHIFT 0x0
#define COREPM_PWRCTRL_MISC_1__PWRGATEMASTERDIS_MASK 0x1
#define COREPM_PWRCTRL_MISC_1__PWRGATEMASTERDIS__SHIFT 0x0
#define LDOIVRON_CPU_1__CK_LDOIVRON_MASK 0x1
#define LDOIVRON_CPU_1__CK_LDOIVRON__SHIFT 0x0
#define LDOIVREXITDONE_CPU_1__LDOIVREXITDONE_MASK 0x1
#define LDOIVREXITDONE_CPU_1__LDOIVREXITDONE__SHIFT 0x0
#define RCC3_TARGETPSMREF_CPU_1__RCC3_TARGETPSMREF_MASK 0x3fff
#define RCC3_TARGETPSMREF_CPU_1__RCC3_TARGETPSMREF__SHIFT 0x0
#define IVR_TARGETPSMREF_CPU_1__IVR_TARGETPSMREF_MASK 0x3fff
#define IVR_TARGETPSMREF_CPU_1__IVR_TARGETPSMREF__SHIFT 0x0
#define CK_JTCOOLRESET_LATCHED_CPU_1__CK_JTCOOLRESET_LATCHED_MASK 0x1
#define CK_JTCOOLRESET_LATCHED_CPU_1__CK_JTCOOLRESET_LATCHED__SHIFT 0x0
#define CK_DISABLECORE_CPU_1__CK_DISABLECORE_MASK 0x1
#define CK_DISABLECORE_CPU_1__CK_DISABLECORE__SHIFT 0x0
#define COREPM_ID_1__COREPM_INDEX_MASK 0x1
#define COREPM_ID_1__COREPM_INDEX__SHIFT 0x0
#define COREPM_SCRATCH_1__SCRATCH_DATA_MASK 0xffffffff
#define COREPM_SCRATCH_1__SCRATCH_DATA__SHIFT 0x0
#define RCC3_WAKEMIN_CPU_1__RCC3_WAKE_MIN_46_15_MASK 0xffffffff
#define RCC3_WAKEMIN_CPU_1__RCC3_WAKE_MIN_46_15__SHIFT 0x0
#define SPMI_CONFIG0_1__SPMI_ENABLE_MASK 0x1
#define SPMI_CONFIG0_1__SPMI_ENABLE__SHIFT 0x0
#define SPMI_CONFIG0_1__SPMI_PATH_NUM_TIMING_FLOPS_MASK 0x7c
#define SPMI_CONFIG0_1__SPMI_PATH_NUM_TIMING_FLOPS__SHIFT 0x2
#define SPMI_CONFIG0_1__SPMI_SIGNALING_DELAY_CYCLES_MASK 0xf80
#define SPMI_CONFIG0_1__SPMI_SIGNALING_DELAY_CYCLES__SHIFT 0x7
#define SPMI_CONFIG0_1__SPMI_SIGNALING_HOLD_CYCLES_MASK 0x1f000
#define SPMI_CONFIG0_1__SPMI_SIGNALING_HOLD_CYCLES__SHIFT 0xc
#define SPMI_CONFIG0_1__SPMI_PATH_ENABLE_DELAY_CYCLES_MASK 0x3e0000
#define SPMI_CONFIG0_1__SPMI_PATH_ENABLE_DELAY_CYCLES__SHIFT 0x11
#define SPMI_CONFIG0_1__SPMI_PATH_DISABLE_DELAY_CYCLES_MASK 0x7c00000
#define SPMI_CONFIG0_1__SPMI_PATH_DISABLE_DELAY_CYCLES__SHIFT 0x16
#define SPMI_CONFIG1_1__SPMI_SIGNALING_RESET_HOLD_CYCLES_MASK 0x1f
#define SPMI_CONFIG1_1__SPMI_SIGNALING_RESET_HOLD_CYCLES__SHIFT 0x0
#define SPMI_CONFIG1_1__SPMI_CHAIN_SIZE_MASK 0xffe0
#define SPMI_CONFIG1_1__SPMI_CHAIN_SIZE__SHIFT 0x5
#define SPMI_FSM_READ_TRIGGER_1__FSM_READ_TRIGGER_MASK 0x1
#define SPMI_FSM_READ_TRIGGER_1__FSM_READ_TRIGGER__SHIFT 0x0
#define SPMI_FSM_WRITE_TRIGGER_1__FSM_WRITE_TRIGGER_MASK 0x1
#define SPMI_FSM_WRITE_TRIGGER_1__FSM_WRITE_TRIGGER__SHIFT 0x0
#define SPMI_FSM_RESET_TRIGGER_1__FSM_RESET_TRIGGER_MASK 0x1
#define SPMI_FSM_RESET_TRIGGER_1__FSM_RESET_TRIGGER__SHIFT 0x0
#define SPMI_FSM_BUSY_1__FSM_BUSY_MASK 0x1
#define SPMI_FSM_BUSY_1__FSM_BUSY__SHIFT 0x0
#define SPMI_PATH_1__PATH_ENABLE_REQ_MASK 0x1
#define SPMI_PATH_1__PATH_ENABLE_REQ__SHIFT 0x0
#define SPMI_PATH_1__PATH_ENABLE_ACK_MASK 0x2
#define SPMI_PATH_1__PATH_ENABLE_ACK__SHIFT 0x1
#define SPMI_PATH_1__PATH_ENABLE_REQ_auto_clear_MASK 0x10
#define SPMI_PATH_1__PATH_ENABLE_REQ_auto_clear__SHIFT 0x4
#define SPMI_C6_STATE_1__SPMI_IF_C6_STATE_ENTERED_MASK 0x1
#define SPMI_C6_STATE_1__SPMI_IF_C6_STATE_ENTERED__SHIFT 0x0
#define SPMI_C6_STATE_1__SPMI_IF_C6_STATE_ENTERED_WHEN_FSM_BUSY_MASK 0x2
#define SPMI_C6_STATE_1__SPMI_IF_C6_STATE_ENTERED_WHEN_FSM_BUSY__SHIFT 0x1
#define SPMI_C6_STATE_1__SPMI_IF_COUNTER_ADDRESS_C6_MASK 0xfffc
#define SPMI_C6_STATE_1__SPMI_IF_COUNTER_ADDRESS_C6__SHIFT 0x2
#define SPMI_JTAG_OVER_1__SPMI_IF_JTAG_OVER_HAPPENED_MASK 0x1
#define SPMI_JTAG_OVER_1__SPMI_IF_JTAG_OVER_HAPPENED__SHIFT 0x0
#define SPMI_SRAM_ADDRESS_1__SRAM_ADDRESS_MASK 0xffffffff
#define SPMI_SRAM_ADDRESS_1__SRAM_ADDRESS__SHIFT 0x0
#define SPMI_SRAM_DATA_1__SRAM_DATA_MASK 0xffffffff
#define SPMI_SRAM_DATA_1__SRAM_DATA__SHIFT 0x0
#define SPMI_RESET_1__ASYNC_RESET_0_MASK 0x1
#define SPMI_RESET_1__ASYNC_RESET_0__SHIFT 0x0
#define SPMI_RESET_1__SYNC_RESET_MASK 0x80000000
#define SPMI_RESET_1__SYNC_RESET__SHIFT 0x1f
#define SPMI_FORCE_CLOCK_GATERS_1__CLOCK_GATER_0_FORCE_MASK 0x1
#define SPMI_FORCE_CLOCK_GATERS_1__CLOCK_GATER_0_FORCE__SHIFT 0x0
#define SPMI_FORCE_CLOCK_GATERS_1__SRAM_CLOCK_GATER_FORCE_MASK 0x100
#define SPMI_FORCE_CLOCK_GATERS_1__SRAM_CLOCK_GATER_FORCE__SHIFT 0x8
#define SPMI_SPARE_1__SPARE_DATA_MASK 0xffffffff
#define SPMI_SPARE_1__SPARE_DATA__SHIFT 0x0
#define SPMI_SPARE_EX_1__SPARE_DATA_EX_MASK 0xffffffff
#define SPMI_SPARE_EX_1__SPARE_DATA_EX__SHIFT 0x0
#define SPMI_SRAM_CLK_GATER_1__SRAM_CLK_GATER_EN_MASK 0x1
#define SPMI_SRAM_CLK_GATER_1__SRAM_CLK_GATER_EN__SHIFT 0x0
#define SPMI_SRAM_CLK_GATER_1__SRAM_CLK_GATER_TIMER_MASK 0x7fe
#define SPMI_SRAM_CLK_GATER_1__SRAM_CLK_GATER_TIMER__SHIFT 0x1
#define GENERAL_PWRMGT__GLOBAL_PWRMGT_EN_MASK 0x1
#define GENERAL_PWRMGT__GLOBAL_PWRMGT_EN__SHIFT 0x0
#define GENERAL_PWRMGT__STATIC_PM_EN_MASK 0x2
#define GENERAL_PWRMGT__STATIC_PM_EN__SHIFT 0x1
#define GENERAL_PWRMGT__THERMAL_PROTECTION_DIS_MASK 0x4
#define GENERAL_PWRMGT__THERMAL_PROTECTION_DIS__SHIFT 0x2
#define GENERAL_PWRMGT__THERMAL_PROTECTION_TYPE_MASK 0x8
#define GENERAL_PWRMGT__THERMAL_PROTECTION_TYPE__SHIFT 0x3
#define GENERAL_PWRMGT__SW_SMIO_INDEX_MASK 0x40
#define GENERAL_PWRMGT__SW_SMIO_INDEX__SHIFT 0x6
#define GENERAL_PWRMGT__LOW_VOLT_D2_ACPI_MASK 0x100
#define GENERAL_PWRMGT__LOW_VOLT_D2_ACPI__SHIFT 0x8
#define GENERAL_PWRMGT__LOW_VOLT_D3_ACPI_MASK 0x200
#define GENERAL_PWRMGT__LOW_VOLT_D3_ACPI__SHIFT 0x9
#define GENERAL_PWRMGT__VOLT_PWRMGT_EN_MASK 0x400
#define GENERAL_PWRMGT__VOLT_PWRMGT_EN__SHIFT 0xa
#define GENERAL_PWRMGT__SPARE11_MASK 0x800
#define GENERAL_PWRMGT__SPARE11__SHIFT 0xb
#define GENERAL_PWRMGT__GPU_COUNTER_ACPI_MASK 0x4000
#define GENERAL_PWRMGT__GPU_COUNTER_ACPI__SHIFT 0xe
#define GENERAL_PWRMGT__GPU_COUNTER_CLK_MASK 0x8000
#define GENERAL_PWRMGT__GPU_COUNTER_CLK__SHIFT 0xf
#define GENERAL_PWRMGT__GPU_COUNTER_OFF_MASK 0x10000
#define GENERAL_PWRMGT__GPU_COUNTER_OFF__SHIFT 0x10
#define GENERAL_PWRMGT__GPU_COUNTER_INTF_OFF_MASK 0x20000
#define GENERAL_PWRMGT__GPU_COUNTER_INTF_OFF__SHIFT 0x11
#define GENERAL_PWRMGT__SPARE18_MASK 0x40000
#define GENERAL_PWRMGT__SPARE18__SHIFT 0x12
#define GENERAL_PWRMGT__ACPI_D3_VID_MASK 0x180000
#define GENERAL_PWRMGT__ACPI_D3_VID__SHIFT 0x13
#define GENERAL_PWRMGT__DYN_SPREAD_SPECTRUM_EN_MASK 0x800000
#define GENERAL_PWRMGT__DYN_SPREAD_SPECTRUM_EN__SHIFT 0x17
#define GENERAL_PWRMGT__SPARE27_MASK 0x8000000
#define GENERAL_PWRMGT__SPARE27__SHIFT 0x1b
#define GENERAL_PWRMGT__SPARE_MASK 0xf0000000
#define GENERAL_PWRMGT__SPARE__SHIFT 0x1c
#define CNB_PWRMGT_CNTL__GNB_SLOW_MODE_MASK 0x3
#define CNB_PWRMGT_CNTL__GNB_SLOW_MODE__SHIFT 0x0
#define CNB_PWRMGT_CNTL__GNB_SLOW_MASK 0x4
#define CNB_PWRMGT_CNTL__GNB_SLOW__SHIFT 0x2
#define CNB_PWRMGT_CNTL__FORCE_NB_PS1_MASK 0x8
#define CNB_PWRMGT_CNTL__FORCE_NB_PS1__SHIFT 0x3
#define CNB_PWRMGT_CNTL__DPM_ENABLED_MASK 0x10
#define CNB_PWRMGT_CNTL__DPM_ENABLED__SHIFT 0x4
#define CNB_PWRMGT_CNTL__SPARE_MASK 0xffffffe0
#define CNB_PWRMGT_CNTL__SPARE__SHIFT 0x5
#define SCLK_PWRMGT_CNTL__RESET_BUSY_CNT_MASK 0x10
#define SCLK_PWRMGT_CNTL__RESET_BUSY_CNT__SHIFT 0x4
#define SCLK_PWRMGT_CNTL__RESET_SCLK_CNT_MASK 0x20
#define SCLK_PWRMGT_CNTL__RESET_SCLK_CNT__SHIFT 0x5
#define SCLK_PWRMGT_CNTL__RESERVED_0_MASK 0x40
#define SCLK_PWRMGT_CNTL__RESERVED_0__SHIFT 0x6
#define SCLK_PWRMGT_CNTL__RESERVED_3_MASK 0x1000000
#define SCLK_PWRMGT_CNTL__RESERVED_3__SHIFT 0x18
#define TARGET_AND_CURRENT_PROFILE_INDEX__TARG_ACPI_INDEX_MASK 0xf
#define TARGET_AND_CURRENT_PROFILE_INDEX__TARG_ACPI_INDEX__SHIFT 0x0
#define TARGET_AND_CURRENT_PROFILE_INDEX__CURR_ACPI_INDEX_MASK 0xf0
#define TARGET_AND_CURRENT_PROFILE_INDEX__CURR_ACPI_INDEX__SHIFT 0x4
#define TARGET_AND_CURRENT_PROFILE_INDEX__CURR_MCLK_INDEX_MASK 0xf00
#define TARGET_AND_CURRENT_PROFILE_INDEX__CURR_MCLK_INDEX__SHIFT 0x8
#define TARGET_AND_CURRENT_PROFILE_INDEX__TARG_MCLK_INDEX_MASK 0xf000
#define TARGET_AND_CURRENT_PROFILE_INDEX__TARG_MCLK_INDEX__SHIFT 0xc
#define TARGET_AND_CURRENT_PROFILE_INDEX__CURR_SCLK_INDEX_MASK 0x1f0000
#define TARGET_AND_CURRENT_PROFILE_INDEX__CURR_SCLK_INDEX__SHIFT 0x10
#define TARGET_AND_CURRENT_PROFILE_INDEX__TARG_SCLK_INDEX_MASK 0x3e00000
#define TARGET_AND_CURRENT_PROFILE_INDEX__TARG_SCLK_INDEX__SHIFT 0x15
#define TARGET_AND_CURRENT_PROFILE_INDEX__CURR_LCLK_INDEX_MASK 0x1c000000
#define TARGET_AND_CURRENT_PROFILE_INDEX__CURR_LCLK_INDEX__SHIFT 0x1a
#define TARGET_AND_CURRENT_PROFILE_INDEX__TARG_LCLK_INDEX_MASK 0xe0000000
#define TARGET_AND_CURRENT_PROFILE_INDEX__TARG_LCLK_INDEX__SHIFT 0x1d
#define TARGET_AND_CURRENT_PROFILE_INDEX_1__CURR_VDDCI_INDEX_MASK 0xf
#define TARGET_AND_CURRENT_PROFILE_INDEX_1__CURR_VDDCI_INDEX__SHIFT 0x0
#define TARGET_AND_CURRENT_PROFILE_INDEX_1__TARG_VDDCI_INDEX_MASK 0xf0
#define TARGET_AND_CURRENT_PROFILE_INDEX_1__TARG_VDDCI_INDEX__SHIFT 0x4
#define TARGET_AND_CURRENT_PROFILE_INDEX_1__CURR_MVDD_INDEX_MASK 0xf00
#define TARGET_AND_CURRENT_PROFILE_INDEX_1__CURR_MVDD_INDEX__SHIFT 0x8
#define TARGET_AND_CURRENT_PROFILE_INDEX_1__TARG_MVDD_INDEX_MASK 0xf000
#define TARGET_AND_CURRENT_PROFILE_INDEX_1__TARG_MVDD_INDEX__SHIFT 0xc
#define TARGET_AND_CURRENT_PROFILE_INDEX_1__CURR_VDDC_INDEX_MASK 0xf0000
#define TARGET_AND_CURRENT_PROFILE_INDEX_1__CURR_VDDC_INDEX__SHIFT 0x10
#define TARGET_AND_CURRENT_PROFILE_INDEX_1__TARG_VDDC_INDEX_MASK 0xf00000
#define TARGET_AND_CURRENT_PROFILE_INDEX_1__TARG_VDDC_INDEX__SHIFT 0x14
#define TARGET_AND_CURRENT_PROFILE_INDEX_1__CURR_PCIE_INDEX_MASK 0xf000000
#define TARGET_AND_CURRENT_PROFILE_INDEX_1__CURR_PCIE_INDEX__SHIFT 0x18
#define TARGET_AND_CURRENT_PROFILE_INDEX_1__TARG_PCIE_INDEX_MASK 0xf0000000
#define TARGET_AND_CURRENT_PROFILE_INDEX_1__TARG_PCIE_INDEX__SHIFT 0x1c
#define TARGET_AND_CURRENT_PROFILE_INDEX_2__CURR_UVD_INDEX_MASK 0xf
#define TARGET_AND_CURRENT_PROFILE_INDEX_2__CURR_UVD_INDEX__SHIFT 0x0
#define TARGET_AND_CURRENT_PROFILE_INDEX_2__TARG_UVD_INDEX_MASK 0xf0
#define TARGET_AND_CURRENT_PROFILE_INDEX_2__TARG_UVD_INDEX__SHIFT 0x4
#define TARGET_AND_CURRENT_PROFILE_INDEX_2__CURR_VCE_INDEX_MASK 0xf00
#define TARGET_AND_CURRENT_PROFILE_INDEX_2__CURR_VCE_INDEX__SHIFT 0x8
#define TARGET_AND_CURRENT_PROFILE_INDEX_2__TARG_VCE_INDEX_MASK 0xf000
#define TARGET_AND_CURRENT_PROFILE_INDEX_2__TARG_VCE_INDEX__SHIFT 0xc
#define TARGET_AND_CURRENT_PROFILE_INDEX_2__CURR_ACP_INDEX_MASK 0xf0000
#define TARGET_AND_CURRENT_PROFILE_INDEX_2__CURR_ACP_INDEX__SHIFT 0x10
#define TARGET_AND_CURRENT_PROFILE_INDEX_2__TARG_ACP_INDEX_MASK 0xf00000
#define TARGET_AND_CURRENT_PROFILE_INDEX_2__TARG_ACP_INDEX__SHIFT 0x14
#define TARGET_AND_CURRENT_PROFILE_INDEX_2__CURR_SAMU_INDEX_MASK 0xf000000
#define TARGET_AND_CURRENT_PROFILE_INDEX_2__CURR_SAMU_INDEX__SHIFT 0x18
#define TARGET_AND_CURRENT_PROFILE_INDEX_2__TARG_SAMU_INDEX_MASK 0xf0000000
#define TARGET_AND_CURRENT_PROFILE_INDEX_2__TARG_SAMU_INDEX__SHIFT 0x1c
#define CG_FREQ_TRAN_VOTING_0__BIF_FREQ_THROTTLING_VOTE_EN_MASK 0x1
#define CG_FREQ_TRAN_VOTING_0__BIF_FREQ_THROTTLING_VOTE_EN__SHIFT 0x0
#define CG_FREQ_TRAN_VOTING_0__HDP_FREQ_THROTTLING_VOTE_EN_MASK 0x2
#define CG_FREQ_TRAN_VOTING_0__HDP_FREQ_THROTTLING_VOTE_EN__SHIFT 0x1
#define CG_FREQ_TRAN_VOTING_0__ROM_FREQ_THROTTLING_VOTE_EN_MASK 0x4
#define CG_FREQ_TRAN_VOTING_0__ROM_FREQ_THROTTLING_VOTE_EN__SHIFT 0x2
#define CG_FREQ_TRAN_VOTING_0__IH_SEM_FREQ_THROTTLING_VOTE_EN_MASK 0x8
#define CG_FREQ_TRAN_VOTING_0__IH_SEM_FREQ_THROTTLING_VOTE_EN__SHIFT 0x3
#define CG_FREQ_TRAN_VOTING_0__PDMA_FREQ_THROTTLING_VOTE_EN_MASK 0x10
#define CG_FREQ_TRAN_VOTING_0__PDMA_FREQ_THROTTLING_VOTE_EN__SHIFT 0x4
#define CG_FREQ_TRAN_VOTING_0__DRM_FREQ_THROTTLING_VOTE_EN_MASK 0x20
#define CG_FREQ_TRAN_VOTING_0__DRM_FREQ_THROTTLING_VOTE_EN__SHIFT 0x5
#define CG_FREQ_TRAN_VOTING_0__IDCT_FREQ_THROTTLING_VOTE_EN_MASK 0x40
#define CG_FREQ_TRAN_VOTING_0__IDCT_FREQ_THROTTLING_VOTE_EN__SHIFT 0x6
#define CG_FREQ_TRAN_VOTING_0__ACP_FREQ_THROTTLING_VOTE_EN_MASK 0x80
#define CG_FREQ_TRAN_VOTING_0__ACP_FREQ_THROTTLING_VOTE_EN__SHIFT 0x7
#define CG_FREQ_TRAN_VOTING_0__SDMA_FREQ_THROTTLING_VOTE_EN_MASK 0x100
#define CG_FREQ_TRAN_VOTING_0__SDMA_FREQ_THROTTLING_VOTE_EN__SHIFT 0x8
#define CG_FREQ_TRAN_VOTING_0__UVD_FREQ_THROTTLING_VOTE_EN_MASK 0x200
#define CG_FREQ_TRAN_VOTING_0__UVD_FREQ_THROTTLING_VOTE_EN__SHIFT 0x9
#define CG_FREQ_TRAN_VOTING_0__VCE_0_FREQ_THROTTLING_VOTE_EN_MASK 0x400
#define CG_FREQ_TRAN_VOTING_0__VCE_0_FREQ_THROTTLING_VOTE_EN__SHIFT 0xa
#define CG_FREQ_TRAN_VOTING_0__DC_AZ_FREQ_THROTTLING_VOTE_EN_MASK 0x800
#define CG_FREQ_TRAN_VOTING_0__DC_AZ_FREQ_THROTTLING_VOTE_EN__SHIFT 0xb
#define CG_FREQ_TRAN_VOTING_0__AVP_FREQ_THROTTLING_VOTE_EN_MASK 0x2000
#define CG_FREQ_TRAN_VOTING_0__AVP_FREQ_THROTTLING_VOTE_EN__SHIFT 0xd
#define CG_FREQ_TRAN_VOTING_0__GRBM_0_FREQ_THROTTLING_VOTE_EN_MASK 0x4000
#define CG_FREQ_TRAN_VOTING_0__GRBM_0_FREQ_THROTTLING_VOTE_EN__SHIFT 0xe
#define CG_FREQ_TRAN_VOTING_0__GRBM_1_FREQ_THROTTLING_VOTE_EN_MASK 0x8000
#define CG_FREQ_TRAN_VOTING_0__GRBM_1_FREQ_THROTTLING_VOTE_EN__SHIFT 0xf
#define CG_FREQ_TRAN_VOTING_0__GRBM_2_FREQ_THROTTLING_VOTE_EN_MASK 0x10000
#define CG_FREQ_TRAN_VOTING_0__GRBM_2_FREQ_THROTTLING_VOTE_EN__SHIFT 0x10
#define CG_FREQ_TRAN_VOTING_0__GRBM_3_FREQ_THROTTLING_VOTE_EN_MASK 0x20000
#define CG_FREQ_TRAN_VOTING_0__GRBM_3_FREQ_THROTTLING_VOTE_EN__SHIFT 0x11
#define CG_FREQ_TRAN_VOTING_0__GRBM_4_FREQ_THROTTLING_VOTE_EN_MASK 0x40000
#define CG_FREQ_TRAN_VOTING_0__GRBM_4_FREQ_THROTTLING_VOTE_EN__SHIFT 0x12
#define CG_FREQ_TRAN_VOTING_0__GRBM_5_FREQ_THROTTLING_VOTE_EN_MASK 0x80000
#define CG_FREQ_TRAN_VOTING_0__GRBM_5_FREQ_THROTTLING_VOTE_EN__SHIFT 0x13
#define CG_FREQ_TRAN_VOTING_0__GRBM_6_FREQ_THROTTLING_VOTE_EN_MASK 0x100000
#define CG_FREQ_TRAN_VOTING_0__GRBM_6_FREQ_THROTTLING_VOTE_EN__SHIFT 0x14
#define CG_FREQ_TRAN_VOTING_0__GRBM_7_FREQ_THROTTLING_VOTE_EN_MASK 0x200000
#define CG_FREQ_TRAN_VOTING_0__GRBM_7_FREQ_THROTTLING_VOTE_EN__SHIFT 0x15
#define CG_FREQ_TRAN_VOTING_0__GRBM_8_FREQ_THROTTLING_VOTE_EN_MASK 0x400000
#define CG_FREQ_TRAN_VOTING_0__GRBM_8_FREQ_THROTTLING_VOTE_EN__SHIFT 0x16
#define CG_FREQ_TRAN_VOTING_0__GRBM_9_FREQ_THROTTLING_VOTE_EN_MASK 0x800000
#define CG_FREQ_TRAN_VOTING_0__GRBM_9_FREQ_THROTTLING_VOTE_EN__SHIFT 0x17
#define CG_FREQ_TRAN_VOTING_0__GRBM_10_FREQ_THROTTLING_VOTE_EN_MASK 0x1000000
#define CG_FREQ_TRAN_VOTING_0__GRBM_10_FREQ_THROTTLING_VOTE_EN__SHIFT 0x18
#define CG_FREQ_TRAN_VOTING_0__GRBM_11_FREQ_THROTTLING_VOTE_EN_MASK 0x2000000
#define CG_FREQ_TRAN_VOTING_0__GRBM_11_FREQ_THROTTLING_VOTE_EN__SHIFT 0x19
#define CG_FREQ_TRAN_VOTING_0__GRBM_12_FREQ_THROTTLING_VOTE_EN_MASK 0x4000000
#define CG_FREQ_TRAN_VOTING_0__GRBM_12_FREQ_THROTTLING_VOTE_EN__SHIFT 0x1a
#define CG_FREQ_TRAN_VOTING_0__GRBM_13_FREQ_THROTTLING_VOTE_EN_MASK 0x8000000
#define CG_FREQ_TRAN_VOTING_0__GRBM_13_FREQ_THROTTLING_VOTE_EN__SHIFT 0x1b
#define CG_FREQ_TRAN_VOTING_0__GRBM_14_FREQ_THROTTLING_VOTE_EN_MASK 0x10000000
#define CG_FREQ_TRAN_VOTING_0__GRBM_14_FREQ_THROTTLING_VOTE_EN__SHIFT 0x1c
#define CG_FREQ_TRAN_VOTING_0__GRBM_15_FREQ_THROTTLING_VOTE_EN_MASK 0x20000000
#define CG_FREQ_TRAN_VOTING_0__GRBM_15_FREQ_THROTTLING_VOTE_EN__SHIFT 0x1d
#define CG_FREQ_TRAN_VOTING_0__RLC_FREQ_THROTTLING_VOTE_EN_MASK 0x40000000
#define CG_FREQ_TRAN_VOTING_0__RLC_FREQ_THROTTLING_VOTE_EN__SHIFT 0x1e
#define CG_FREQ_TRAN_VOTING_0__VCE_1_FREQ_THROTTLING_VOTE_EN_MASK 0x80000000
#define CG_FREQ_TRAN_VOTING_0__VCE_1_FREQ_THROTTLING_VOTE_EN__SHIFT 0x1f
#define CG_FREQ_TRAN_VOTING_1__BIF_FREQ_THROTTLING_VOTE_EN_MASK 0x1
#define CG_FREQ_TRAN_VOTING_1__BIF_FREQ_THROTTLING_VOTE_EN__SHIFT 0x0
#define CG_FREQ_TRAN_VOTING_1__HDP_FREQ_THROTTLING_VOTE_EN_MASK 0x2
#define CG_FREQ_TRAN_VOTING_1__HDP_FREQ_THROTTLING_VOTE_EN__SHIFT 0x1
#define CG_FREQ_TRAN_VOTING_1__ROM_FREQ_THROTTLING_VOTE_EN_MASK 0x4
#define CG_FREQ_TRAN_VOTING_1__ROM_FREQ_THROTTLING_VOTE_EN__SHIFT 0x2
#define CG_FREQ_TRAN_VOTING_1__IH_SEM_FREQ_THROTTLING_VOTE_EN_MASK 0x8
#define CG_FREQ_TRAN_VOTING_1__IH_SEM_FREQ_THROTTLING_VOTE_EN__SHIFT 0x3
#define CG_FREQ_TRAN_VOTING_1__PDMA_FREQ_THROTTLING_VOTE_EN_MASK 0x10
#define CG_FREQ_TRAN_VOTING_1__PDMA_FREQ_THROTTLING_VOTE_EN__SHIFT 0x4
#define CG_FREQ_TRAN_VOTING_1__DRM_FREQ_THROTTLING_VOTE_EN_MASK 0x20
#define CG_FREQ_TRAN_VOTING_1__DRM_FREQ_THROTTLING_VOTE_EN__SHIFT 0x5
#define CG_FREQ_TRAN_VOTING_1__IDCT_FREQ_THROTTLING_VOTE_EN_MASK 0x40
#define CG_FREQ_TRAN_VOTING_1__IDCT_FREQ_THROTTLING_VOTE_EN__SHIFT 0x6
#define CG_FREQ_TRAN_VOTING_1__ACP_FREQ_THROTTLING_VOTE_EN_MASK 0x80
#define CG_FREQ_TRAN_VOTING_1__ACP_FREQ_THROTTLING_VOTE_EN__SHIFT 0x7
#define CG_FREQ_TRAN_VOTING_1__SDMA_FREQ_THROTTLING_VOTE_EN_MASK 0x100
#define CG_FREQ_TRAN_VOTING_1__SDMA_FREQ_THROTTLING_VOTE_EN__SHIFT 0x8
#define CG_FREQ_TRAN_VOTING_1__UVD_FREQ_THROTTLING_VOTE_EN_MASK 0x200
#define CG_FREQ_TRAN_VOTING_1__UVD_FREQ_THROTTLING_VOTE_EN__SHIFT 0x9
#define CG_FREQ_TRAN_VOTING_1__VCE_0_FREQ_THROTTLING_VOTE_EN_MASK 0x400
#define CG_FREQ_TRAN_VOTING_1__VCE_0_FREQ_THROTTLING_VOTE_EN__SHIFT 0xa
#define CG_FREQ_TRAN_VOTING_1__DC_AZ_FREQ_THROTTLING_VOTE_EN_MASK 0x800
#define CG_FREQ_TRAN_VOTING_1__DC_AZ_FREQ_THROTTLING_VOTE_EN__SHIFT 0xb
#define CG_FREQ_TRAN_VOTING_1__AVP_FREQ_THROTTLING_VOTE_EN_MASK 0x2000
#define CG_FREQ_TRAN_VOTING_1__AVP_FREQ_THROTTLING_VOTE_EN__SHIFT 0xd
#define CG_FREQ_TRAN_VOTING_1__GRBM_0_FREQ_THROTTLING_VOTE_EN_MASK 0x4000
#define CG_FREQ_TRAN_VOTING_1__GRBM_0_FREQ_THROTTLING_VOTE_EN__SHIFT 0xe
#define CG_FREQ_TRAN_VOTING_1__GRBM_1_FREQ_THROTTLING_VOTE_EN_MASK 0x8000
#define CG_FREQ_TRAN_VOTING_1__GRBM_1_FREQ_THROTTLING_VOTE_EN__SHIFT 0xf
#define CG_FREQ_TRAN_VOTING_1__GRBM_2_FREQ_THROTTLING_VOTE_EN_MASK 0x10000
#define CG_FREQ_TRAN_VOTING_1__GRBM_2_FREQ_THROTTLING_VOTE_EN__SHIFT 0x10
#define CG_FREQ_TRAN_VOTING_1__GRBM_3_FREQ_THROTTLING_VOTE_EN_MASK 0x20000
#define CG_FREQ_TRAN_VOTING_1__GRBM_3_FREQ_THROTTLING_VOTE_EN__SHIFT 0x11
#define CG_FREQ_TRAN_VOTING_1__GRBM_4_FREQ_THROTTLING_VOTE_EN_MASK 0x40000
#define CG_FREQ_TRAN_VOTING_1__GRBM_4_FREQ_THROTTLING_VOTE_EN__SHIFT 0x12
#define CG_FREQ_TRAN_VOTING_1__GRBM_5_FREQ_THROTTLING_VOTE_EN_MASK 0x80000
#define CG_FREQ_TRAN_VOTING_1__GRBM_5_FREQ_THROTTLING_VOTE_EN__SHIFT 0x13
#define CG_FREQ_TRAN_VOTING_1__GRBM_6_FREQ_THROTTLING_VOTE_EN_MASK 0x100000
#define CG_FREQ_TRAN_VOTING_1__GRBM_6_FREQ_THROTTLING_VOTE_EN__SHIFT 0x14
#define CG_FREQ_TRAN_VOTING_1__GRBM_7_FREQ_THROTTLING_VOTE_EN_MASK 0x200000
#define CG_FREQ_TRAN_VOTING_1__GRBM_7_FREQ_THROTTLING_VOTE_EN__SHIFT 0x15
#define CG_FREQ_TRAN_VOTING_1__GRBM_8_FREQ_THROTTLING_VOTE_EN_MASK 0x400000
#define CG_FREQ_TRAN_VOTING_1__GRBM_8_FREQ_THROTTLING_VOTE_EN__SHIFT 0x16
#define CG_FREQ_TRAN_VOTING_1__GRBM_9_FREQ_THROTTLING_VOTE_EN_MASK 0x800000
#define CG_FREQ_TRAN_VOTING_1__GRBM_9_FREQ_THROTTLING_VOTE_EN__SHIFT 0x17
#define CG_FREQ_TRAN_VOTING_1__GRBM_10_FREQ_THROTTLING_VOTE_EN_MASK 0x1000000
#define CG_FREQ_TRAN_VOTING_1__GRBM_10_FREQ_THROTTLING_VOTE_EN__SHIFT 0x18
#define CG_FREQ_TRAN_VOTING_1__GRBM_11_FREQ_THROTTLING_VOTE_EN_MASK 0x2000000
#define CG_FREQ_TRAN_VOTING_1__GRBM_11_FREQ_THROTTLING_VOTE_EN__SHIFT 0x19
#define CG_FREQ_TRAN_VOTING_1__GRBM_12_FREQ_THROTTLING_VOTE_EN_MASK 0x4000000
#define CG_FREQ_TRAN_VOTING_1__GRBM_12_FREQ_THROTTLING_VOTE_EN__SHIFT 0x1a
#define CG_FREQ_TRAN_VOTING_1__GRBM_13_FREQ_THROTTLING_VOTE_EN_MASK 0x8000000
#define CG_FREQ_TRAN_VOTING_1__GRBM_13_FREQ_THROTTLING_VOTE_EN__SHIFT 0x1b
#define CG_FREQ_TRAN_VOTING_1__GRBM_14_FREQ_THROTTLING_VOTE_EN_MASK 0x10000000
#define CG_FREQ_TRAN_VOTING_1__GRBM_14_FREQ_THROTTLING_VOTE_EN__SHIFT 0x1c
#define CG_FREQ_TRAN_VOTING_1__GRBM_15_FREQ_THROTTLING_VOTE_EN_MASK 0x20000000
#define CG_FREQ_TRAN_VOTING_1__GRBM_15_FREQ_THROTTLING_VOTE_EN__SHIFT 0x1d
#define CG_FREQ_TRAN_VOTING_1__RLC_FREQ_THROTTLING_VOTE_EN_MASK 0x40000000
#define CG_FREQ_TRAN_VOTING_1__RLC_FREQ_THROTTLING_VOTE_EN__SHIFT 0x1e
#define CG_FREQ_TRAN_VOTING_1__VCE_1_FREQ_THROTTLING_VOTE_EN_MASK 0x80000000
#define CG_FREQ_TRAN_VOTING_1__VCE_1_FREQ_THROTTLING_VOTE_EN__SHIFT 0x1f
#define CG_FREQ_TRAN_VOTING_2__BIF_FREQ_THROTTLING_VOTE_EN_MASK 0x1
#define CG_FREQ_TRAN_VOTING_2__BIF_FREQ_THROTTLING_VOTE_EN__SHIFT 0x0
#define CG_FREQ_TRAN_VOTING_2__HDP_FREQ_THROTTLING_VOTE_EN_MASK 0x2
#define CG_FREQ_TRAN_VOTING_2__HDP_FREQ_THROTTLING_VOTE_EN__SHIFT 0x1
#define CG_FREQ_TRAN_VOTING_2__ROM_FREQ_THROTTLING_VOTE_EN_MASK 0x4
#define CG_FREQ_TRAN_VOTING_2__ROM_FREQ_THROTTLING_VOTE_EN__SHIFT 0x2
#define CG_FREQ_TRAN_VOTING_2__IH_SEM_FREQ_THROTTLING_VOTE_EN_MASK 0x8
#define CG_FREQ_TRAN_VOTING_2__IH_SEM_FREQ_THROTTLING_VOTE_EN__SHIFT 0x3
#define CG_FREQ_TRAN_VOTING_2__PDMA_FREQ_THROTTLING_VOTE_EN_MASK 0x10
#define CG_FREQ_TRAN_VOTING_2__PDMA_FREQ_THROTTLING_VOTE_EN__SHIFT 0x4
#define CG_FREQ_TRAN_VOTING_2__DRM_FREQ_THROTTLING_VOTE_EN_MASK 0x20
#define CG_FREQ_TRAN_VOTING_2__DRM_FREQ_THROTTLING_VOTE_EN__SHIFT 0x5
#define CG_FREQ_TRAN_VOTING_2__IDCT_FREQ_THROTTLING_VOTE_EN_MASK 0x40
#define CG_FREQ_TRAN_VOTING_2__IDCT_FREQ_THROTTLING_VOTE_EN__SHIFT 0x6
#define CG_FREQ_TRAN_VOTING_2__ACP_FREQ_THROTTLING_VOTE_EN_MASK 0x80
#define CG_FREQ_TRAN_VOTING_2__ACP_FREQ_THROTTLING_VOTE_EN__SHIFT 0x7
#define CG_FREQ_TRAN_VOTING_2__SDMA_FREQ_THROTTLING_VOTE_EN_MASK 0x100
#define CG_FREQ_TRAN_VOTING_2__SDMA_FREQ_THROTTLING_VOTE_EN__SHIFT 0x8
#define CG_FREQ_TRAN_VOTING_2__UVD_FREQ_THROTTLING_VOTE_EN_MASK 0x200
#define CG_FREQ_TRAN_VOTING_2__UVD_FREQ_THROTTLING_VOTE_EN__SHIFT 0x9
#define CG_FREQ_TRAN_VOTING_2__VCE_0_FREQ_THROTTLING_VOTE_EN_MASK 0x400
#define CG_FREQ_TRAN_VOTING_2__VCE_0_FREQ_THROTTLING_VOTE_EN__SHIFT 0xa
#define CG_FREQ_TRAN_VOTING_2__DC_AZ_FREQ_THROTTLING_VOTE_EN_MASK 0x800
#define CG_FREQ_TRAN_VOTING_2__DC_AZ_FREQ_THROTTLING_VOTE_EN__SHIFT 0xb
#define CG_FREQ_TRAN_VOTING_2__AVP_FREQ_THROTTLING_VOTE_EN_MASK 0x2000
#define CG_FREQ_TRAN_VOTING_2__AVP_FREQ_THROTTLING_VOTE_EN__SHIFT 0xd
#define CG_FREQ_TRAN_VOTING_2__GRBM_0_FREQ_THROTTLING_VOTE_EN_MASK 0x4000
#define CG_FREQ_TRAN_VOTING_2__GRBM_0_FREQ_THROTTLING_VOTE_EN__SHIFT 0xe
#define CG_FREQ_TRAN_VOTING_2__GRBM_1_FREQ_THROTTLING_VOTE_EN_MASK 0x8000
#define CG_FREQ_TRAN_VOTING_2__GRBM_1_FREQ_THROTTLING_VOTE_EN__SHIFT 0xf
#define CG_FREQ_TRAN_VOTING_2__GRBM_2_FREQ_THROTTLING_VOTE_EN_MASK 0x10000
#define CG_FREQ_TRAN_VOTING_2__GRBM_2_FREQ_THROTTLING_VOTE_EN__SHIFT 0x10
#define CG_FREQ_TRAN_VOTING_2__GRBM_3_FREQ_THROTTLING_VOTE_EN_MASK 0x20000
#define CG_FREQ_TRAN_VOTING_2__GRBM_3_FREQ_THROTTLING_VOTE_EN__SHIFT 0x11
#define CG_FREQ_TRAN_VOTING_2__GRBM_4_FREQ_THROTTLING_VOTE_EN_MASK 0x40000
#define CG_FREQ_TRAN_VOTING_2__GRBM_4_FREQ_THROTTLING_VOTE_EN__SHIFT 0x12
#define CG_FREQ_TRAN_VOTING_2__GRBM_5_FREQ_THROTTLING_VOTE_EN_MASK 0x80000
#define CG_FREQ_TRAN_VOTING_2__GRBM_5_FREQ_THROTTLING_VOTE_EN__SHIFT 0x13
#define CG_FREQ_TRAN_VOTING_2__GRBM_6_FREQ_THROTTLING_VOTE_EN_MASK 0x100000
#define CG_FREQ_TRAN_VOTING_2__GRBM_6_FREQ_THROTTLING_VOTE_EN__SHIFT 0x14
#define CG_FREQ_TRAN_VOTING_2__GRBM_7_FREQ_THROTTLING_VOTE_EN_MASK 0x200000
#define CG_FREQ_TRAN_VOTING_2__GRBM_7_FREQ_THROTTLING_VOTE_EN__SHIFT 0x15
#define CG_FREQ_TRAN_VOTING_2__GRBM_8_FREQ_THROTTLING_VOTE_EN_MASK 0x400000
#define CG_FREQ_TRAN_VOTING_2__GRBM_8_FREQ_THROTTLING_VOTE_EN__SHIFT 0x16
#define CG_FREQ_TRAN_VOTING_2__GRBM_9_FREQ_THROTTLING_VOTE_EN_MASK 0x800000
#define CG_FREQ_TRAN_VOTING_2__GRBM_9_FREQ_THROTTLING_VOTE_EN__SHIFT 0x17
#define CG_FREQ_TRAN_VOTING_2__GRBM_10_FREQ_THROTTLING_VOTE_EN_MASK 0x1000000
#define CG_FREQ_TRAN_VOTING_2__GRBM_10_FREQ_THROTTLING_VOTE_EN__SHIFT 0x18
#define CG_FREQ_TRAN_VOTING_2__GRBM_11_FREQ_THROTTLING_VOTE_EN_MASK 0x2000000
#define CG_FREQ_TRAN_VOTING_2__GRBM_11_FREQ_THROTTLING_VOTE_EN__SHIFT 0x19
#define CG_FREQ_TRAN_VOTING_2__GRBM_12_FREQ_THROTTLING_VOTE_EN_MASK 0x4000000
#define CG_FREQ_TRAN_VOTING_2__GRBM_12_FREQ_THROTTLING_VOTE_EN__SHIFT 0x1a
#define CG_FREQ_TRAN_VOTING_2__GRBM_13_FREQ_THROTTLING_VOTE_EN_MASK 0x8000000
#define CG_FREQ_TRAN_VOTING_2__GRBM_13_FREQ_THROTTLING_VOTE_EN__SHIFT 0x1b
#define CG_FREQ_TRAN_VOTING_2__GRBM_14_FREQ_THROTTLING_VOTE_EN_MASK 0x10000000
#define CG_FREQ_TRAN_VOTING_2__GRBM_14_FREQ_THROTTLING_VOTE_EN__SHIFT 0x1c
#define CG_FREQ_TRAN_VOTING_2__GRBM_15_FREQ_THROTTLING_VOTE_EN_MASK 0x20000000
#define CG_FREQ_TRAN_VOTING_2__GRBM_15_FREQ_THROTTLING_VOTE_EN__SHIFT 0x1d
#define CG_FREQ_TRAN_VOTING_2__RLC_FREQ_THROTTLING_VOTE_EN_MASK 0x40000000
#define CG_FREQ_TRAN_VOTING_2__RLC_FREQ_THROTTLING_VOTE_EN__SHIFT 0x1e
#define CG_FREQ_TRAN_VOTING_2__VCE_1_FREQ_THROTTLING_VOTE_EN_MASK 0x80000000
#define CG_FREQ_TRAN_VOTING_2__VCE_1_FREQ_THROTTLING_VOTE_EN__SHIFT 0x1f
#define CG_FREQ_TRAN_VOTING_3__BIF_FREQ_THROTTLING_VOTE_EN_MASK 0x1
#define CG_FREQ_TRAN_VOTING_3__BIF_FREQ_THROTTLING_VOTE_EN__SHIFT 0x0
#define CG_FREQ_TRAN_VOTING_3__HDP_FREQ_THROTTLING_VOTE_EN_MASK 0x2
#define CG_FREQ_TRAN_VOTING_3__HDP_FREQ_THROTTLING_VOTE_EN__SHIFT 0x1
#define CG_FREQ_TRAN_VOTING_3__ROM_FREQ_THROTTLING_VOTE_EN_MASK 0x4
#define CG_FREQ_TRAN_VOTING_3__ROM_FREQ_THROTTLING_VOTE_EN__SHIFT 0x2
#define CG_FREQ_TRAN_VOTING_3__IH_SEM_FREQ_THROTTLING_VOTE_EN_MASK 0x8
#define CG_FREQ_TRAN_VOTING_3__IH_SEM_FREQ_THROTTLING_VOTE_EN__SHIFT 0x3
#define CG_FREQ_TRAN_VOTING_3__PDMA_FREQ_THROTTLING_VOTE_EN_MASK 0x10
#define CG_FREQ_TRAN_VOTING_3__PDMA_FREQ_THROTTLING_VOTE_EN__SHIFT 0x4
#define CG_FREQ_TRAN_VOTING_3__DRM_FREQ_THROTTLING_VOTE_EN_MASK 0x20
#define CG_FREQ_TRAN_VOTING_3__DRM_FREQ_THROTTLING_VOTE_EN__SHIFT 0x5
#define CG_FREQ_TRAN_VOTING_3__IDCT_FREQ_THROTTLING_VOTE_EN_MASK 0x40
#define CG_FREQ_TRAN_VOTING_3__IDCT_FREQ_THROTTLING_VOTE_EN__SHIFT 0x6
#define CG_FREQ_TRAN_VOTING_3__ACP_FREQ_THROTTLING_VOTE_EN_MASK 0x80
#define CG_FREQ_TRAN_VOTING_3__ACP_FREQ_THROTTLING_VOTE_EN__SHIFT 0x7
#define CG_FREQ_TRAN_VOTING_3__SDMA_FREQ_THROTTLING_VOTE_EN_MASK 0x100
#define CG_FREQ_TRAN_VOTING_3__SDMA_FREQ_THROTTLING_VOTE_EN__SHIFT 0x8
#define CG_FREQ_TRAN_VOTING_3__UVD_FREQ_THROTTLING_VOTE_EN_MASK 0x200
#define CG_FREQ_TRAN_VOTING_3__UVD_FREQ_THROTTLING_VOTE_EN__SHIFT 0x9
#define CG_FREQ_TRAN_VOTING_3__VCE_0_FREQ_THROTTLING_VOTE_EN_MASK 0x400
#define CG_FREQ_TRAN_VOTING_3__VCE_0_FREQ_THROTTLING_VOTE_EN__SHIFT 0xa
#define CG_FREQ_TRAN_VOTING_3__DC_AZ_FREQ_THROTTLING_VOTE_EN_MASK 0x800
#define CG_FREQ_TRAN_VOTING_3__DC_AZ_FREQ_THROTTLING_VOTE_EN__SHIFT 0xb
#define CG_FREQ_TRAN_VOTING_3__AVP_FREQ_THROTTLING_VOTE_EN_MASK 0x2000
#define CG_FREQ_TRAN_VOTING_3__AVP_FREQ_THROTTLING_VOTE_EN__SHIFT 0xd
#define CG_FREQ_TRAN_VOTING_3__GRBM_0_FREQ_THROTTLING_VOTE_EN_MASK 0x4000
#define CG_FREQ_TRAN_VOTING_3__GRBM_0_FREQ_THROTTLING_VOTE_EN__SHIFT 0xe
#define CG_FREQ_TRAN_VOTING_3__GRBM_1_FREQ_THROTTLING_VOTE_EN_MASK 0x8000
#define CG_FREQ_TRAN_VOTING_3__GRBM_1_FREQ_THROTTLING_VOTE_EN__SHIFT 0xf
#define CG_FREQ_TRAN_VOTING_3__GRBM_2_FREQ_THROTTLING_VOTE_EN_MASK 0x10000
#define CG_FREQ_TRAN_VOTING_3__GRBM_2_FREQ_THROTTLING_VOTE_EN__SHIFT 0x10
#define CG_FREQ_TRAN_VOTING_3__GRBM_3_FREQ_THROTTLING_VOTE_EN_MASK 0x20000
#define CG_FREQ_TRAN_VOTING_3__GRBM_3_FREQ_THROTTLING_VOTE_EN__SHIFT 0x11
#define CG_FREQ_TRAN_VOTING_3__GRBM_4_FREQ_THROTTLING_VOTE_EN_MASK 0x40000
#define CG_FREQ_TRAN_VOTING_3__GRBM_4_FREQ_THROTTLING_VOTE_EN__SHIFT 0x12
#define CG_FREQ_TRAN_VOTING_3__GRBM_5_FREQ_THROTTLING_VOTE_EN_MASK 0x80000
#define CG_FREQ_TRAN_VOTING_3__GRBM_5_FREQ_THROTTLING_VOTE_EN__SHIFT 0x13
#define CG_FREQ_TRAN_VOTING_3__GRBM_6_FREQ_THROTTLING_VOTE_EN_MASK 0x100000
#define CG_FREQ_TRAN_VOTING_3__GRBM_6_FREQ_THROTTLING_VOTE_EN__SHIFT 0x14
#define CG_FREQ_TRAN_VOTING_3__GRBM_7_FREQ_THROTTLING_VOTE_EN_MASK 0x200000
#define CG_FREQ_TRAN_VOTING_3__GRBM_7_FREQ_THROTTLING_VOTE_EN__SHIFT 0x15
#define CG_FREQ_TRAN_VOTING_3__GRBM_8_FREQ_THROTTLING_VOTE_EN_MASK 0x400000
#define CG_FREQ_TRAN_VOTING_3__GRBM_8_FREQ_THROTTLING_VOTE_EN__SHIFT 0x16
#define CG_FREQ_TRAN_VOTING_3__GRBM_9_FREQ_THROTTLING_VOTE_EN_MASK 0x800000
#define CG_FREQ_TRAN_VOTING_3__GRBM_9_FREQ_THROTTLING_VOTE_EN__SHIFT 0x17
#define CG_FREQ_TRAN_VOTING_3__GRBM_10_FREQ_THROTTLING_VOTE_EN_MASK 0x1000000
#define CG_FREQ_TRAN_VOTING_3__GRBM_10_FREQ_THROTTLING_VOTE_EN__SHIFT 0x18
#define CG_FREQ_TRAN_VOTING_3__GRBM_11_FREQ_THROTTLING_VOTE_EN_MASK 0x2000000
#define CG_FREQ_TRAN_VOTING_3__GRBM_11_FREQ_THROTTLING_VOTE_EN__SHIFT 0x19
#define CG_FREQ_TRAN_VOTING_3__GRBM_12_FREQ_THROTTLING_VOTE_EN_MASK 0x4000000
#define CG_FREQ_TRAN_VOTING_3__GRBM_12_FREQ_THROTTLING_VOTE_EN__SHIFT 0x1a
#define CG_FREQ_TRAN_VOTING_3__GRBM_13_FREQ_THROTTLING_VOTE_EN_MASK 0x8000000
#define CG_FREQ_TRAN_VOTING_3__GRBM_13_FREQ_THROTTLING_VOTE_EN__SHIFT 0x1b
#define CG_FREQ_TRAN_VOTING_3__GRBM_14_FREQ_THROTTLING_VOTE_EN_MASK 0x10000000
#define CG_FREQ_TRAN_VOTING_3__GRBM_14_FREQ_THROTTLING_VOTE_EN__SHIFT 0x1c
#define CG_FREQ_TRAN_VOTING_3__GRBM_15_FREQ_THROTTLING_VOTE_EN_MASK 0x20000000
#define CG_FREQ_TRAN_VOTING_3__GRBM_15_FREQ_THROTTLING_VOTE_EN__SHIFT 0x1d
#define CG_FREQ_TRAN_VOTING_3__RLC_FREQ_THROTTLING_VOTE_EN_MASK 0x40000000
#define CG_FREQ_TRAN_VOTING_3__RLC_FREQ_THROTTLING_VOTE_EN__SHIFT 0x1e
#define CG_FREQ_TRAN_VOTING_3__VCE_1_FREQ_THROTTLING_VOTE_EN_MASK 0x80000000
#define CG_FREQ_TRAN_VOTING_3__VCE_1_FREQ_THROTTLING_VOTE_EN__SHIFT 0x1f
#define CG_FREQ_TRAN_VOTING_4__BIF_FREQ_THROTTLING_VOTE_EN_MASK 0x1
#define CG_FREQ_TRAN_VOTING_4__BIF_FREQ_THROTTLING_VOTE_EN__SHIFT 0x0
#define CG_FREQ_TRAN_VOTING_4__HDP_FREQ_THROTTLING_VOTE_EN_MASK 0x2
#define CG_FREQ_TRAN_VOTING_4__HDP_FREQ_THROTTLING_VOTE_EN__SHIFT 0x1
#define CG_FREQ_TRAN_VOTING_4__ROM_FREQ_THROTTLING_VOTE_EN_MASK 0x4
#define CG_FREQ_TRAN_VOTING_4__ROM_FREQ_THROTTLING_VOTE_EN__SHIFT 0x2
#define CG_FREQ_TRAN_VOTING_4__IH_SEM_FREQ_THROTTLING_VOTE_EN_MASK 0x8
#define CG_FREQ_TRAN_VOTING_4__IH_SEM_FREQ_THROTTLING_VOTE_EN__SHIFT 0x3
#define CG_FREQ_TRAN_VOTING_4__PDMA_FREQ_THROTTLING_VOTE_EN_MASK 0x10
#define CG_FREQ_TRAN_VOTING_4__PDMA_FREQ_THROTTLING_VOTE_EN__SHIFT 0x4
#define CG_FREQ_TRAN_VOTING_4__DRM_FREQ_THROTTLING_VOTE_EN_MASK 0x20
#define CG_FREQ_TRAN_VOTING_4__DRM_FREQ_THROTTLING_VOTE_EN__SHIFT 0x5
#define CG_FREQ_TRAN_VOTING_4__IDCT_FREQ_THROTTLING_VOTE_EN_MASK 0x40
#define CG_FREQ_TRAN_VOTING_4__IDCT_FREQ_THROTTLING_VOTE_EN__SHIFT 0x6
#define CG_FREQ_TRAN_VOTING_4__ACP_FREQ_THROTTLING_VOTE_EN_MASK 0x80
#define CG_FREQ_TRAN_VOTING_4__ACP_FREQ_THROTTLING_VOTE_EN__SHIFT 0x7
#define CG_FREQ_TRAN_VOTING_4__SDMA_FREQ_THROTTLING_VOTE_EN_MASK 0x100
#define CG_FREQ_TRAN_VOTING_4__SDMA_FREQ_THROTTLING_VOTE_EN__SHIFT 0x8
#define CG_FREQ_TRAN_VOTING_4__UVD_FREQ_THROTTLING_VOTE_EN_MASK 0x200
#define CG_FREQ_TRAN_VOTING_4__UVD_FREQ_THROTTLING_VOTE_EN__SHIFT 0x9
#define CG_FREQ_TRAN_VOTING_4__VCE_0_FREQ_THROTTLING_VOTE_EN_MASK 0x400
#define CG_FREQ_TRAN_VOTING_4__VCE_0_FREQ_THROTTLING_VOTE_EN__SHIFT 0xa
#define CG_FREQ_TRAN_VOTING_4__DC_AZ_FREQ_THROTTLING_VOTE_EN_MASK 0x800
#define CG_FREQ_TRAN_VOTING_4__DC_AZ_FREQ_THROTTLING_VOTE_EN__SHIFT 0xb
#define CG_FREQ_TRAN_VOTING_4__AVP_FREQ_THROTTLING_VOTE_EN_MASK 0x2000
#define CG_FREQ_TRAN_VOTING_4__AVP_FREQ_THROTTLING_VOTE_EN__SHIFT 0xd
#define CG_FREQ_TRAN_VOTING_4__GRBM_0_FREQ_THROTTLING_VOTE_EN_MASK 0x4000
#define CG_FREQ_TRAN_VOTING_4__GRBM_0_FREQ_THROTTLING_VOTE_EN__SHIFT 0xe
#define CG_FREQ_TRAN_VOTING_4__GRBM_1_FREQ_THROTTLING_VOTE_EN_MASK 0x8000
#define CG_FREQ_TRAN_VOTING_4__GRBM_1_FREQ_THROTTLING_VOTE_EN__SHIFT 0xf
#define CG_FREQ_TRAN_VOTING_4__GRBM_2_FREQ_THROTTLING_VOTE_EN_MASK 0x10000
#define CG_FREQ_TRAN_VOTING_4__GRBM_2_FREQ_THROTTLING_VOTE_EN__SHIFT 0x10
#define CG_FREQ_TRAN_VOTING_4__GRBM_3_FREQ_THROTTLING_VOTE_EN_MASK 0x20000
#define CG_FREQ_TRAN_VOTING_4__GRBM_3_FREQ_THROTTLING_VOTE_EN__SHIFT 0x11
#define CG_FREQ_TRAN_VOTING_4__GRBM_4_FREQ_THROTTLING_VOTE_EN_MASK 0x40000
#define CG_FREQ_TRAN_VOTING_4__GRBM_4_FREQ_THROTTLING_VOTE_EN__SHIFT 0x12
#define CG_FREQ_TRAN_VOTING_4__GRBM_5_FREQ_THROTTLING_VOTE_EN_MASK 0x80000
#define CG_FREQ_TRAN_VOTING_4__GRBM_5_FREQ_THROTTLING_VOTE_EN__SHIFT 0x13
#define CG_FREQ_TRAN_VOTING_4__GRBM_6_FREQ_THROTTLING_VOTE_EN_MASK 0x100000
#define CG_FREQ_TRAN_VOTING_4__GRBM_6_FREQ_THROTTLING_VOTE_EN__SHIFT 0x14
#define CG_FREQ_TRAN_VOTING_4__GRBM_7_FREQ_THROTTLING_VOTE_EN_MASK 0x200000
#define CG_FREQ_TRAN_VOTING_4__GRBM_7_FREQ_THROTTLING_VOTE_EN__SHIFT 0x15
#define CG_FREQ_TRAN_VOTING_4__GRBM_8_FREQ_THROTTLING_VOTE_EN_MASK 0x400000
#define CG_FREQ_TRAN_VOTING_4__GRBM_8_FREQ_THROTTLING_VOTE_EN__SHIFT 0x16
#define CG_FREQ_TRAN_VOTING_4__GRBM_9_FREQ_THROTTLING_VOTE_EN_MASK 0x800000
#define CG_FREQ_TRAN_VOTING_4__GRBM_9_FREQ_THROTTLING_VOTE_EN__SHIFT 0x17
#define CG_FREQ_TRAN_VOTING_4__GRBM_10_FREQ_THROTTLING_VOTE_EN_MASK 0x1000000
#define CG_FREQ_TRAN_VOTING_4__GRBM_10_FREQ_THROTTLING_VOTE_EN__SHIFT 0x18
#define CG_FREQ_TRAN_VOTING_4__GRBM_11_FREQ_THROTTLING_VOTE_EN_MASK 0x2000000
#define CG_FREQ_TRAN_VOTING_4__GRBM_11_FREQ_THROTTLING_VOTE_EN__SHIFT 0x19
#define CG_FREQ_TRAN_VOTING_4__GRBM_12_FREQ_THROTTLING_VOTE_EN_MASK 0x4000000
#define CG_FREQ_TRAN_VOTING_4__GRBM_12_FREQ_THROTTLING_VOTE_EN__SHIFT 0x1a
#define CG_FREQ_TRAN_VOTING_4__GRBM_13_FREQ_THROTTLING_VOTE_EN_MASK 0x8000000
#define CG_FREQ_TRAN_VOTING_4__GRBM_13_FREQ_THROTTLING_VOTE_EN__SHIFT 0x1b
#define CG_FREQ_TRAN_VOTING_4__GRBM_14_FREQ_THROTTLING_VOTE_EN_MASK 0x10000000
#define CG_FREQ_TRAN_VOTING_4__GRBM_14_FREQ_THROTTLING_VOTE_EN__SHIFT 0x1c
#define CG_FREQ_TRAN_VOTING_4__GRBM_15_FREQ_THROTTLING_VOTE_EN_MASK 0x20000000
#define CG_FREQ_TRAN_VOTING_4__GRBM_15_FREQ_THROTTLING_VOTE_EN__SHIFT 0x1d
#define CG_FREQ_TRAN_VOTING_4__RLC_FREQ_THROTTLING_VOTE_EN_MASK 0x40000000
#define CG_FREQ_TRAN_VOTING_4__RLC_FREQ_THROTTLING_VOTE_EN__SHIFT 0x1e
#define CG_FREQ_TRAN_VOTING_4__VCE_1_FREQ_THROTTLING_VOTE_EN_MASK 0x80000000
#define CG_FREQ_TRAN_VOTING_4__VCE_1_FREQ_THROTTLING_VOTE_EN__SHIFT 0x1f
#define CG_FREQ_TRAN_VOTING_5__BIF_FREQ_THROTTLING_VOTE_EN_MASK 0x1
#define CG_FREQ_TRAN_VOTING_5__BIF_FREQ_THROTTLING_VOTE_EN__SHIFT 0x0
#define CG_FREQ_TRAN_VOTING_5__HDP_FREQ_THROTTLING_VOTE_EN_MASK 0x2
#define CG_FREQ_TRAN_VOTING_5__HDP_FREQ_THROTTLING_VOTE_EN__SHIFT 0x1
#define CG_FREQ_TRAN_VOTING_5__ROM_FREQ_THROTTLING_VOTE_EN_MASK 0x4
#define CG_FREQ_TRAN_VOTING_5__ROM_FREQ_THROTTLING_VOTE_EN__SHIFT 0x2
#define CG_FREQ_TRAN_VOTING_5__IH_SEM_FREQ_THROTTLING_VOTE_EN_MASK 0x8
#define CG_FREQ_TRAN_VOTING_5__IH_SEM_FREQ_THROTTLING_VOTE_EN__SHIFT 0x3
#define CG_FREQ_TRAN_VOTING_5__PDMA_FREQ_THROTTLING_VOTE_EN_MASK 0x10
#define CG_FREQ_TRAN_VOTING_5__PDMA_FREQ_THROTTLING_VOTE_EN__SHIFT 0x4
#define CG_FREQ_TRAN_VOTING_5__DRM_FREQ_THROTTLING_VOTE_EN_MASK 0x20
#define CG_FREQ_TRAN_VOTING_5__DRM_FREQ_THROTTLING_VOTE_EN__SHIFT 0x5
#define CG_FREQ_TRAN_VOTING_5__IDCT_FREQ_THROTTLING_VOTE_EN_MASK 0x40
#define CG_FREQ_TRAN_VOTING_5__IDCT_FREQ_THROTTLING_VOTE_EN__SHIFT 0x6
#define CG_FREQ_TRAN_VOTING_5__ACP_FREQ_THROTTLING_VOTE_EN_MASK 0x80
#define CG_FREQ_TRAN_VOTING_5__ACP_FREQ_THROTTLING_VOTE_EN__SHIFT 0x7
#define CG_FREQ_TRAN_VOTING_5__SDMA_FREQ_THROTTLING_VOTE_EN_MASK 0x100
#define CG_FREQ_TRAN_VOTING_5__SDMA_FREQ_THROTTLING_VOTE_EN__SHIFT 0x8
#define CG_FREQ_TRAN_VOTING_5__UVD_FREQ_THROTTLING_VOTE_EN_MASK 0x200
#define CG_FREQ_TRAN_VOTING_5__UVD_FREQ_THROTTLING_VOTE_EN__SHIFT 0x9
#define CG_FREQ_TRAN_VOTING_5__VCE_0_FREQ_THROTTLING_VOTE_EN_MASK 0x400
#define CG_FREQ_TRAN_VOTING_5__VCE_0_FREQ_THROTTLING_VOTE_EN__SHIFT 0xa
#define CG_FREQ_TRAN_VOTING_5__DC_AZ_FREQ_THROTTLING_VOTE_EN_MASK 0x800
#define CG_FREQ_TRAN_VOTING_5__DC_AZ_FREQ_THROTTLING_VOTE_EN__SHIFT 0xb
#define CG_FREQ_TRAN_VOTING_5__AVP_FREQ_THROTTLING_VOTE_EN_MASK 0x2000
#define CG_FREQ_TRAN_VOTING_5__AVP_FREQ_THROTTLING_VOTE_EN__SHIFT 0xd
#define CG_FREQ_TRAN_VOTING_5__GRBM_0_FREQ_THROTTLING_VOTE_EN_MASK 0x4000
#define CG_FREQ_TRAN_VOTING_5__GRBM_0_FREQ_THROTTLING_VOTE_EN__SHIFT 0xe
#define CG_FREQ_TRAN_VOTING_5__GRBM_1_FREQ_THROTTLING_VOTE_EN_MASK 0x8000
#define CG_FREQ_TRAN_VOTING_5__GRBM_1_FREQ_THROTTLING_VOTE_EN__SHIFT 0xf
#define CG_FREQ_TRAN_VOTING_5__GRBM_2_FREQ_THROTTLING_VOTE_EN_MASK 0x10000
#define CG_FREQ_TRAN_VOTING_5__GRBM_2_FREQ_THROTTLING_VOTE_EN__SHIFT 0x10
#define CG_FREQ_TRAN_VOTING_5__GRBM_3_FREQ_THROTTLING_VOTE_EN_MASK 0x20000
#define CG_FREQ_TRAN_VOTING_5__GRBM_3_FREQ_THROTTLING_VOTE_EN__SHIFT 0x11
#define CG_FREQ_TRAN_VOTING_5__GRBM_4_FREQ_THROTTLING_VOTE_EN_MASK 0x40000
#define CG_FREQ_TRAN_VOTING_5__GRBM_4_FREQ_THROTTLING_VOTE_EN__SHIFT 0x12
#define CG_FREQ_TRAN_VOTING_5__GRBM_5_FREQ_THROTTLING_VOTE_EN_MASK 0x80000
#define CG_FREQ_TRAN_VOTING_5__GRBM_5_FREQ_THROTTLING_VOTE_EN__SHIFT 0x13
#define CG_FREQ_TRAN_VOTING_5__GRBM_6_FREQ_THROTTLING_VOTE_EN_MASK 0x100000
#define CG_FREQ_TRAN_VOTING_5__GRBM_6_FREQ_THROTTLING_VOTE_EN__SHIFT 0x14
#define CG_FREQ_TRAN_VOTING_5__GRBM_7_FREQ_THROTTLING_VOTE_EN_MASK 0x200000
#define CG_FREQ_TRAN_VOTING_5__GRBM_7_FREQ_THROTTLING_VOTE_EN__SHIFT 0x15
#define CG_FREQ_TRAN_VOTING_5__GRBM_8_FREQ_THROTTLING_VOTE_EN_MASK 0x400000
#define CG_FREQ_TRAN_VOTING_5__GRBM_8_FREQ_THROTTLING_VOTE_EN__SHIFT 0x16
#define CG_FREQ_TRAN_VOTING_5__GRBM_9_FREQ_THROTTLING_VOTE_EN_MASK 0x800000
#define CG_FREQ_TRAN_VOTING_5__GRBM_9_FREQ_THROTTLING_VOTE_EN__SHIFT 0x17
#define CG_FREQ_TRAN_VOTING_5__GRBM_10_FREQ_THROTTLING_VOTE_EN_MASK 0x1000000
#define CG_FREQ_TRAN_VOTING_5__GRBM_10_FREQ_THROTTLING_VOTE_EN__SHIFT 0x18
#define CG_FREQ_TRAN_VOTING_5__GRBM_11_FREQ_THROTTLING_VOTE_EN_MASK 0x2000000
#define CG_FREQ_TRAN_VOTING_5__GRBM_11_FREQ_THROTTLING_VOTE_EN__SHIFT 0x19
#define CG_FREQ_TRAN_VOTING_5__GRBM_12_FREQ_THROTTLING_VOTE_EN_MASK 0x4000000
#define CG_FREQ_TRAN_VOTING_5__GRBM_12_FREQ_THROTTLING_VOTE_EN__SHIFT 0x1a
#define CG_FREQ_TRAN_VOTING_5__GRBM_13_FREQ_THROTTLING_VOTE_EN_MASK 0x8000000
#define CG_FREQ_TRAN_VOTING_5__GRBM_13_FREQ_THROTTLING_VOTE_EN__SHIFT 0x1b
#define CG_FREQ_TRAN_VOTING_5__GRBM_14_FREQ_THROTTLING_VOTE_EN_MASK 0x10000000
#define CG_FREQ_TRAN_VOTING_5__GRBM_14_FREQ_THROTTLING_VOTE_EN__SHIFT 0x1c
#define CG_FREQ_TRAN_VOTING_5__GRBM_15_FREQ_THROTTLING_VOTE_EN_MASK 0x20000000
#define CG_FREQ_TRAN_VOTING_5__GRBM_15_FREQ_THROTTLING_VOTE_EN__SHIFT 0x1d
#define CG_FREQ_TRAN_VOTING_5__RLC_FREQ_THROTTLING_VOTE_EN_MASK 0x40000000
#define CG_FREQ_TRAN_VOTING_5__RLC_FREQ_THROTTLING_VOTE_EN__SHIFT 0x1e
#define CG_FREQ_TRAN_VOTING_5__VCE_1_FREQ_THROTTLING_VOTE_EN_MASK 0x80000000
#define CG_FREQ_TRAN_VOTING_5__VCE_1_FREQ_THROTTLING_VOTE_EN__SHIFT 0x1f
#define CG_FREQ_TRAN_VOTING_6__BIF_FREQ_THROTTLING_VOTE_EN_MASK 0x1
#define CG_FREQ_TRAN_VOTING_6__BIF_FREQ_THROTTLING_VOTE_EN__SHIFT 0x0
#define CG_FREQ_TRAN_VOTING_6__HDP_FREQ_THROTTLING_VOTE_EN_MASK 0x2
#define CG_FREQ_TRAN_VOTING_6__HDP_FREQ_THROTTLING_VOTE_EN__SHIFT 0x1
#define CG_FREQ_TRAN_VOTING_6__ROM_FREQ_THROTTLING_VOTE_EN_MASK 0x4
#define CG_FREQ_TRAN_VOTING_6__ROM_FREQ_THROTTLING_VOTE_EN__SHIFT 0x2
#define CG_FREQ_TRAN_VOTING_6__IH_SEM_FREQ_THROTTLING_VOTE_EN_MASK 0x8
#define CG_FREQ_TRAN_VOTING_6__IH_SEM_FREQ_THROTTLING_VOTE_EN__SHIFT 0x3
#define CG_FREQ_TRAN_VOTING_6__PDMA_FREQ_THROTTLING_VOTE_EN_MASK 0x10
#define CG_FREQ_TRAN_VOTING_6__PDMA_FREQ_THROTTLING_VOTE_EN__SHIFT 0x4
#define CG_FREQ_TRAN_VOTING_6__DRM_FREQ_THROTTLING_VOTE_EN_MASK 0x20
#define CG_FREQ_TRAN_VOTING_6__DRM_FREQ_THROTTLING_VOTE_EN__SHIFT 0x5
#define CG_FREQ_TRAN_VOTING_6__IDCT_FREQ_THROTTLING_VOTE_EN_MASK 0x40
#define CG_FREQ_TRAN_VOTING_6__IDCT_FREQ_THROTTLING_VOTE_EN__SHIFT 0x6
#define CG_FREQ_TRAN_VOTING_6__ACP_FREQ_THROTTLING_VOTE_EN_MASK 0x80
#define CG_FREQ_TRAN_VOTING_6__ACP_FREQ_THROTTLING_VOTE_EN__SHIFT 0x7
#define CG_FREQ_TRAN_VOTING_6__SDMA_FREQ_THROTTLING_VOTE_EN_MASK 0x100
#define CG_FREQ_TRAN_VOTING_6__SDMA_FREQ_THROTTLING_VOTE_EN__SHIFT 0x8
#define CG_FREQ_TRAN_VOTING_6__UVD_FREQ_THROTTLING_VOTE_EN_MASK 0x200
#define CG_FREQ_TRAN_VOTING_6__UVD_FREQ_THROTTLING_VOTE_EN__SHIFT 0x9
#define CG_FREQ_TRAN_VOTING_6__VCE_0_FREQ_THROTTLING_VOTE_EN_MASK 0x400
#define CG_FREQ_TRAN_VOTING_6__VCE_0_FREQ_THROTTLING_VOTE_EN__SHIFT 0xa
#define CG_FREQ_TRAN_VOTING_6__DC_AZ_FREQ_THROTTLING_VOTE_EN_MASK 0x800
#define CG_FREQ_TRAN_VOTING_6__DC_AZ_FREQ_THROTTLING_VOTE_EN__SHIFT 0xb
#define CG_FREQ_TRAN_VOTING_6__AVP_FREQ_THROTTLING_VOTE_EN_MASK 0x2000
#define CG_FREQ_TRAN_VOTING_6__AVP_FREQ_THROTTLING_VOTE_EN__SHIFT 0xd
#define CG_FREQ_TRAN_VOTING_6__GRBM_0_FREQ_THROTTLING_VOTE_EN_MASK 0x4000
#define CG_FREQ_TRAN_VOTING_6__GRBM_0_FREQ_THROTTLING_VOTE_EN__SHIFT 0xe
#define CG_FREQ_TRAN_VOTING_6__GRBM_1_FREQ_THROTTLING_VOTE_EN_MASK 0x8000
#define CG_FREQ_TRAN_VOTING_6__GRBM_1_FREQ_THROTTLING_VOTE_EN__SHIFT 0xf
#define CG_FREQ_TRAN_VOTING_6__GRBM_2_FREQ_THROTTLING_VOTE_EN_MASK 0x10000
#define CG_FREQ_TRAN_VOTING_6__GRBM_2_FREQ_THROTTLING_VOTE_EN__SHIFT 0x10
#define CG_FREQ_TRAN_VOTING_6__GRBM_3_FREQ_THROTTLING_VOTE_EN_MASK 0x20000
#define CG_FREQ_TRAN_VOTING_6__GRBM_3_FREQ_THROTTLING_VOTE_EN__SHIFT 0x11
#define CG_FREQ_TRAN_VOTING_6__GRBM_4_FREQ_THROTTLING_VOTE_EN_MASK 0x40000
#define CG_FREQ_TRAN_VOTING_6__GRBM_4_FREQ_THROTTLING_VOTE_EN__SHIFT 0x12
#define CG_FREQ_TRAN_VOTING_6__GRBM_5_FREQ_THROTTLING_VOTE_EN_MASK 0x80000
#define CG_FREQ_TRAN_VOTING_6__GRBM_5_FREQ_THROTTLING_VOTE_EN__SHIFT 0x13
#define CG_FREQ_TRAN_VOTING_6__GRBM_6_FREQ_THROTTLING_VOTE_EN_MASK 0x100000
#define CG_FREQ_TRAN_VOTING_6__GRBM_6_FREQ_THROTTLING_VOTE_EN__SHIFT 0x14
#define CG_FREQ_TRAN_VOTING_6__GRBM_7_FREQ_THROTTLING_VOTE_EN_MASK 0x200000
#define CG_FREQ_TRAN_VOTING_6__GRBM_7_FREQ_THROTTLING_VOTE_EN__SHIFT 0x15
#define CG_FREQ_TRAN_VOTING_6__GRBM_8_FREQ_THROTTLING_VOTE_EN_MASK 0x400000
#define CG_FREQ_TRAN_VOTING_6__GRBM_8_FREQ_THROTTLING_VOTE_EN__SHIFT 0x16
#define CG_FREQ_TRAN_VOTING_6__GRBM_9_FREQ_THROTTLING_VOTE_EN_MASK 0x800000
#define CG_FREQ_TRAN_VOTING_6__GRBM_9_FREQ_THROTTLING_VOTE_EN__SHIFT 0x17
#define CG_FREQ_TRAN_VOTING_6__GRBM_10_FREQ_THROTTLING_VOTE_EN_MASK 0x1000000
#define CG_FREQ_TRAN_VOTING_6__GRBM_10_FREQ_THROTTLING_VOTE_EN__SHIFT 0x18
#define CG_FREQ_TRAN_VOTING_6__GRBM_11_FREQ_THROTTLING_VOTE_EN_MASK 0x2000000
#define CG_FREQ_TRAN_VOTING_6__GRBM_11_FREQ_THROTTLING_VOTE_EN__SHIFT 0x19
#define CG_FREQ_TRAN_VOTING_6__GRBM_12_FREQ_THROTTLING_VOTE_EN_MASK 0x4000000
#define CG_FREQ_TRAN_VOTING_6__GRBM_12_FREQ_THROTTLING_VOTE_EN__SHIFT 0x1a
#define CG_FREQ_TRAN_VOTING_6__GRBM_13_FREQ_THROTTLING_VOTE_EN_MASK 0x8000000
#define CG_FREQ_TRAN_VOTING_6__GRBM_13_FREQ_THROTTLING_VOTE_EN__SHIFT 0x1b
#define CG_FREQ_TRAN_VOTING_6__GRBM_14_FREQ_THROTTLING_VOTE_EN_MASK 0x10000000
#define CG_FREQ_TRAN_VOTING_6__GRBM_14_FREQ_THROTTLING_VOTE_EN__SHIFT 0x1c
#define CG_FREQ_TRAN_VOTING_6__GRBM_15_FREQ_THROTTLING_VOTE_EN_MASK 0x20000000
#define CG_FREQ_TRAN_VOTING_6__GRBM_15_FREQ_THROTTLING_VOTE_EN__SHIFT 0x1d
#define CG_FREQ_TRAN_VOTING_6__RLC_FREQ_THROTTLING_VOTE_EN_MASK 0x40000000
#define CG_FREQ_TRAN_VOTING_6__RLC_FREQ_THROTTLING_VOTE_EN__SHIFT 0x1e
#define CG_FREQ_TRAN_VOTING_6__VCE_1_FREQ_THROTTLING_VOTE_EN_MASK 0x80000000
#define CG_FREQ_TRAN_VOTING_6__VCE_1_FREQ_THROTTLING_VOTE_EN__SHIFT 0x1f
#define CG_FREQ_TRAN_VOTING_7__BIF_FREQ_THROTTLING_VOTE_EN_MASK 0x1
#define CG_FREQ_TRAN_VOTING_7__BIF_FREQ_THROTTLING_VOTE_EN__SHIFT 0x0
#define CG_FREQ_TRAN_VOTING_7__HDP_FREQ_THROTTLING_VOTE_EN_MASK 0x2
#define CG_FREQ_TRAN_VOTING_7__HDP_FREQ_THROTTLING_VOTE_EN__SHIFT 0x1
#define CG_FREQ_TRAN_VOTING_7__ROM_FREQ_THROTTLING_VOTE_EN_MASK 0x4
#define CG_FREQ_TRAN_VOTING_7__ROM_FREQ_THROTTLING_VOTE_EN__SHIFT 0x2
#define CG_FREQ_TRAN_VOTING_7__IH_SEM_FREQ_THROTTLING_VOTE_EN_MASK 0x8
#define CG_FREQ_TRAN_VOTING_7__IH_SEM_FREQ_THROTTLING_VOTE_EN__SHIFT 0x3
#define CG_FREQ_TRAN_VOTING_7__PDMA_FREQ_THROTTLING_VOTE_EN_MASK 0x10
#define CG_FREQ_TRAN_VOTING_7__PDMA_FREQ_THROTTLING_VOTE_EN__SHIFT 0x4
#define CG_FREQ_TRAN_VOTING_7__DRM_FREQ_THROTTLING_VOTE_EN_MASK 0x20
#define CG_FREQ_TRAN_VOTING_7__DRM_FREQ_THROTTLING_VOTE_EN__SHIFT 0x5
#define CG_FREQ_TRAN_VOTING_7__IDCT_FREQ_THROTTLING_VOTE_EN_MASK 0x40
#define CG_FREQ_TRAN_VOTING_7__IDCT_FREQ_THROTTLING_VOTE_EN__SHIFT 0x6
#define CG_FREQ_TRAN_VOTING_7__ACP_FREQ_THROTTLING_VOTE_EN_MASK 0x80
#define CG_FREQ_TRAN_VOTING_7__ACP_FREQ_THROTTLING_VOTE_EN__SHIFT 0x7
#define CG_FREQ_TRAN_VOTING_7__SDMA_FREQ_THROTTLING_VOTE_EN_MASK 0x100
#define CG_FREQ_TRAN_VOTING_7__SDMA_FREQ_THROTTLING_VOTE_EN__SHIFT 0x8
#define CG_FREQ_TRAN_VOTING_7__UVD_FREQ_THROTTLING_VOTE_EN_MASK 0x200
#define CG_FREQ_TRAN_VOTING_7__UVD_FREQ_THROTTLING_VOTE_EN__SHIFT 0x9
#define CG_FREQ_TRAN_VOTING_7__VCE_0_FREQ_THROTTLING_VOTE_EN_MASK 0x400
#define CG_FREQ_TRAN_VOTING_7__VCE_0_FREQ_THROTTLING_VOTE_EN__SHIFT 0xa
#define CG_FREQ_TRAN_VOTING_7__DC_AZ_FREQ_THROTTLING_VOTE_EN_MASK 0x800
#define CG_FREQ_TRAN_VOTING_7__DC_AZ_FREQ_THROTTLING_VOTE_EN__SHIFT 0xb
#define CG_FREQ_TRAN_VOTING_7__AVP_FREQ_THROTTLING_VOTE_EN_MASK 0x2000
#define CG_FREQ_TRAN_VOTING_7__AVP_FREQ_THROTTLING_VOTE_EN__SHIFT 0xd
#define CG_FREQ_TRAN_VOTING_7__GRBM_0_FREQ_THROTTLING_VOTE_EN_MASK 0x4000
#define CG_FREQ_TRAN_VOTING_7__GRBM_0_FREQ_THROTTLING_VOTE_EN__SHIFT 0xe
#define CG_FREQ_TRAN_VOTING_7__GRBM_1_FREQ_THROTTLING_VOTE_EN_MASK 0x8000
#define CG_FREQ_TRAN_VOTING_7__GRBM_1_FREQ_THROTTLING_VOTE_EN__SHIFT 0xf
#define CG_FREQ_TRAN_VOTING_7__GRBM_2_FREQ_THROTTLING_VOTE_EN_MASK 0x10000
#define CG_FREQ_TRAN_VOTING_7__GRBM_2_FREQ_THROTTLING_VOTE_EN__SHIFT 0x10
#define CG_FREQ_TRAN_VOTING_7__GRBM_3_FREQ_THROTTLING_VOTE_EN_MASK 0x20000
#define CG_FREQ_TRAN_VOTING_7__GRBM_3_FREQ_THROTTLING_VOTE_EN__SHIFT 0x11
#define CG_FREQ_TRAN_VOTING_7__GRBM_4_FREQ_THROTTLING_VOTE_EN_MASK 0x40000
#define CG_FREQ_TRAN_VOTING_7__GRBM_4_FREQ_THROTTLING_VOTE_EN__SHIFT 0x12
#define CG_FREQ_TRAN_VOTING_7__GRBM_5_FREQ_THROTTLING_VOTE_EN_MASK 0x80000
#define CG_FREQ_TRAN_VOTING_7__GRBM_5_FREQ_THROTTLING_VOTE_EN__SHIFT 0x13
#define CG_FREQ_TRAN_VOTING_7__GRBM_6_FREQ_THROTTLING_VOTE_EN_MASK 0x100000
#define CG_FREQ_TRAN_VOTING_7__GRBM_6_FREQ_THROTTLING_VOTE_EN__SHIFT 0x14
#define CG_FREQ_TRAN_VOTING_7__GRBM_7_FREQ_THROTTLING_VOTE_EN_MASK 0x200000
#define CG_FREQ_TRAN_VOTING_7__GRBM_7_FREQ_THROTTLING_VOTE_EN__SHIFT 0x15
#define CG_FREQ_TRAN_VOTING_7__GRBM_8_FREQ_THROTTLING_VOTE_EN_MASK 0x400000
#define CG_FREQ_TRAN_VOTING_7__GRBM_8_FREQ_THROTTLING_VOTE_EN__SHIFT 0x16
#define CG_FREQ_TRAN_VOTING_7__GRBM_9_FREQ_THROTTLING_VOTE_EN_MASK 0x800000
#define CG_FREQ_TRAN_VOTING_7__GRBM_9_FREQ_THROTTLING_VOTE_EN__SHIFT 0x17
#define CG_FREQ_TRAN_VOTING_7__GRBM_10_FREQ_THROTTLING_VOTE_EN_MASK 0x1000000
#define CG_FREQ_TRAN_VOTING_7__GRBM_10_FREQ_THROTTLING_VOTE_EN__SHIFT 0x18
#define CG_FREQ_TRAN_VOTING_7__GRBM_11_FREQ_THROTTLING_VOTE_EN_MASK 0x2000000
#define CG_FREQ_TRAN_VOTING_7__GRBM_11_FREQ_THROTTLING_VOTE_EN__SHIFT 0x19
#define CG_FREQ_TRAN_VOTING_7__GRBM_12_FREQ_THROTTLING_VOTE_EN_MASK 0x4000000
#define CG_FREQ_TRAN_VOTING_7__GRBM_12_FREQ_THROTTLING_VOTE_EN__SHIFT 0x1a
#define CG_FREQ_TRAN_VOTING_7__GRBM_13_FREQ_THROTTLING_VOTE_EN_MASK 0x8000000
#define CG_FREQ_TRAN_VOTING_7__GRBM_13_FREQ_THROTTLING_VOTE_EN__SHIFT 0x1b
#define CG_FREQ_TRAN_VOTING_7__GRBM_14_FREQ_THROTTLING_VOTE_EN_MASK 0x10000000
#define CG_FREQ_TRAN_VOTING_7__GRBM_14_FREQ_THROTTLING_VOTE_EN__SHIFT 0x1c
#define CG_FREQ_TRAN_VOTING_7__GRBM_15_FREQ_THROTTLING_VOTE_EN_MASK 0x20000000
#define CG_FREQ_TRAN_VOTING_7__GRBM_15_FREQ_THROTTLING_VOTE_EN__SHIFT 0x1d
#define CG_FREQ_TRAN_VOTING_7__RLC_FREQ_THROTTLING_VOTE_EN_MASK 0x40000000
#define CG_FREQ_TRAN_VOTING_7__RLC_FREQ_THROTTLING_VOTE_EN__SHIFT 0x1e
#define CG_FREQ_TRAN_VOTING_7__VCE_1_FREQ_THROTTLING_VOTE_EN_MASK 0x80000000
#define CG_FREQ_TRAN_VOTING_7__VCE_1_FREQ_THROTTLING_VOTE_EN__SHIFT 0x1f
#define CG_STATIC_SCREEN_PARAMETER__STATIC_SCREEN_THRESHOLD_MASK 0xffff
#define CG_STATIC_SCREEN_PARAMETER__STATIC_SCREEN_THRESHOLD__SHIFT 0x0
#define CG_STATIC_SCREEN_PARAMETER__STATIC_SCREEN_THRESHOLD_UNIT_MASK 0xf0000
#define CG_STATIC_SCREEN_PARAMETER__STATIC_SCREEN_THRESHOLD_UNIT__SHIFT 0x10
#define CG_ACPI_CNTL__SCLK_ACPI_DIV_MASK 0x7f
#define CG_ACPI_CNTL__SCLK_ACPI_DIV__SHIFT 0x0
#define CG_ACPI_CNTL__SCLK_CHANGE_SKIP_MASK 0x80
#define CG_ACPI_CNTL__SCLK_CHANGE_SKIP__SHIFT 0x7
#define SCLK_DEEP_SLEEP_CNTL__DIV_ID_MASK 0x7
#define SCLK_DEEP_SLEEP_CNTL__DIV_ID__SHIFT 0x0
#define SCLK_DEEP_SLEEP_CNTL__RAMP_DIS_MASK 0x8
#define SCLK_DEEP_SLEEP_CNTL__RAMP_DIS__SHIFT 0x3
#define SCLK_DEEP_SLEEP_CNTL__HYSTERESIS_MASK 0xfff0
#define SCLK_DEEP_SLEEP_CNTL__HYSTERESIS__SHIFT 0x4
#define SCLK_DEEP_SLEEP_CNTL__SCLK_RUNNING_MASK_MASK 0x10000
#define SCLK_DEEP_SLEEP_CNTL__SCLK_RUNNING_MASK__SHIFT 0x10
#define SCLK_DEEP_SLEEP_CNTL__SELF_REFRESH_MASK_MASK 0x20000
#define SCLK_DEEP_SLEEP_CNTL__SELF_REFRESH_MASK__SHIFT 0x11
#define SCLK_DEEP_SLEEP_CNTL__ALLOW_NBPSTATE_MASK_MASK 0x40000
#define SCLK_DEEP_SLEEP_CNTL__ALLOW_NBPSTATE_MASK__SHIFT 0x12
#define SCLK_DEEP_SLEEP_CNTL__BIF_BUSY_MASK_MASK 0x80000
#define SCLK_DEEP_SLEEP_CNTL__BIF_BUSY_MASK__SHIFT 0x13
#define SCLK_DEEP_SLEEP_CNTL__UVD_BUSY_MASK_MASK 0x100000
#define SCLK_DEEP_SLEEP_CNTL__UVD_BUSY_MASK__SHIFT 0x14
#define SCLK_DEEP_SLEEP_CNTL__MC0SRBM_BUSY_MASK_MASK 0x200000
#define SCLK_DEEP_SLEEP_CNTL__MC0SRBM_BUSY_MASK__SHIFT 0x15
#define SCLK_DEEP_SLEEP_CNTL__MC1SRBM_BUSY_MASK_MASK 0x400000
#define SCLK_DEEP_SLEEP_CNTL__MC1SRBM_BUSY_MASK__SHIFT 0x16
#define SCLK_DEEP_SLEEP_CNTL__MC_ALLOW_MASK_MASK 0x800000
#define SCLK_DEEP_SLEEP_CNTL__MC_ALLOW_MASK__SHIFT 0x17
#define SCLK_DEEP_SLEEP_CNTL__SMU_BUSY_MASK_MASK 0x1000000
#define SCLK_DEEP_SLEEP_CNTL__SMU_BUSY_MASK__SHIFT 0x18
#define SCLK_DEEP_SLEEP_CNTL__SELF_REFRESH_NLC_MASK_MASK 0x2000000
#define SCLK_DEEP_SLEEP_CNTL__SELF_REFRESH_NLC_MASK__SHIFT 0x19
#define SCLK_DEEP_SLEEP_CNTL__FAST_EXIT_REQ_NBPSTATE_MASK 0x4000000
#define SCLK_DEEP_SLEEP_CNTL__FAST_EXIT_REQ_NBPSTATE__SHIFT 0x1a
#define SCLK_DEEP_SLEEP_CNTL__DEEP_SLEEP_ENTRY_MODE_MASK 0x8000000
#define SCLK_DEEP_SLEEP_CNTL__DEEP_SLEEP_ENTRY_MODE__SHIFT 0x1b
#define SCLK_DEEP_SLEEP_CNTL__MBUS2_ACTIVE_MASK_MASK 0x10000000
#define SCLK_DEEP_SLEEP_CNTL__MBUS2_ACTIVE_MASK__SHIFT 0x1c
#define SCLK_DEEP_SLEEP_CNTL__VCE_0_BUSY_MASK_MASK 0x20000000
#define SCLK_DEEP_SLEEP_CNTL__VCE_0_BUSY_MASK__SHIFT 0x1d
#define SCLK_DEEP_SLEEP_CNTL__AZ_BUSY_MASK_MASK 0x40000000
#define SCLK_DEEP_SLEEP_CNTL__AZ_BUSY_MASK__SHIFT 0x1e
#define SCLK_DEEP_SLEEP_CNTL__ENABLE_DS_MASK 0x80000000
#define SCLK_DEEP_SLEEP_CNTL__ENABLE_DS__SHIFT 0x1f
#define SCLK_DEEP_SLEEP_CNTL2__RLC_BUSY_MASK_MASK 0x1
#define SCLK_DEEP_SLEEP_CNTL2__RLC_BUSY_MASK__SHIFT 0x0
#define SCLK_DEEP_SLEEP_CNTL2__HDP_BUSY_MASK_MASK 0x2
#define SCLK_DEEP_SLEEP_CNTL2__HDP_BUSY_MASK__SHIFT 0x1
#define SCLK_DEEP_SLEEP_CNTL2__ROM_BUSY_MASK_MASK 0x4
#define SCLK_DEEP_SLEEP_CNTL2__ROM_BUSY_MASK__SHIFT 0x2
#define SCLK_DEEP_SLEEP_CNTL2__IH_SEM_BUSY_MASK_MASK 0x8
#define SCLK_DEEP_SLEEP_CNTL2__IH_SEM_BUSY_MASK__SHIFT 0x3
#define SCLK_DEEP_SLEEP_CNTL2__PDMA_BUSY_MASK_MASK 0x10
#define SCLK_DEEP_SLEEP_CNTL2__PDMA_BUSY_MASK__SHIFT 0x4
#define SCLK_DEEP_SLEEP_CNTL2__IDCT_BUSY_MASK_MASK 0x40
#define SCLK_DEEP_SLEEP_CNTL2__IDCT_BUSY_MASK__SHIFT 0x6
#define SCLK_DEEP_SLEEP_CNTL2__SDMA_BUSY_MASK_MASK 0x80
#define SCLK_DEEP_SLEEP_CNTL2__SDMA_BUSY_MASK__SHIFT 0x7
#define SCLK_DEEP_SLEEP_CNTL2__DC_AZ_BUSY_MASK_MASK 0x100
#define SCLK_DEEP_SLEEP_CNTL2__DC_AZ_BUSY_MASK__SHIFT 0x8
#define SCLK_DEEP_SLEEP_CNTL2__ACP_SMU_ALLOW_DSLEEP_STUTTER_MASK_MASK 0x200
#define SCLK_DEEP_SLEEP_CNTL2__ACP_SMU_ALLOW_DSLEEP_STUTTER_MASK__SHIFT 0x9
#define SCLK_DEEP_SLEEP_CNTL2__UVD_CG_MC_STAT_BUSY_MASK_MASK 0x400
#define SCLK_DEEP_SLEEP_CNTL2__UVD_CG_MC_STAT_BUSY_MASK__SHIFT 0xa
#define SCLK_DEEP_SLEEP_CNTL2__VCE_0_CG_MC_STAT_BUSY_MASK_MASK 0x800
#define SCLK_DEEP_SLEEP_CNTL2__VCE_0_CG_MC_STAT_BUSY_MASK__SHIFT 0xb
#define SCLK_DEEP_SLEEP_CNTL2__VCE_1_BUSY_MASK_MASK 0x200000
#define SCLK_DEEP_SLEEP_CNTL2__VCE_1_BUSY_MASK__SHIFT 0x15
#define SCLK_DEEP_SLEEP_CNTL2__VCE_1_CG_MC_STAT_BUSY_MASK_MASK 0x400000
#define SCLK_DEEP_SLEEP_CNTL2__VCE_1_CG_MC_STAT_BUSY_MASK__SHIFT 0x16
#define SCLK_DEEP_SLEEP_CNTL2__REG_SCLK_DEEP_SLEEP_MASK_MASK 0x800000
#define SCLK_DEEP_SLEEP_CNTL2__REG_SCLK_DEEP_SLEEP_MASK__SHIFT 0x17
#define SCLK_DEEP_SLEEP_CNTL2__INOUT_CUSHION_MASK 0xff000000
#define SCLK_DEEP_SLEEP_CNTL2__INOUT_CUSHION__SHIFT 0x18
#define SCLK_DEEP_SLEEP_CNTL3__GRBM_0_SMU_BUSY_MASK_MASK 0x1
#define SCLK_DEEP_SLEEP_CNTL3__GRBM_0_SMU_BUSY_MASK__SHIFT 0x0
#define SCLK_DEEP_SLEEP_CNTL3__GRBM_1_SMU_BUSY_MASK_MASK 0x2
#define SCLK_DEEP_SLEEP_CNTL3__GRBM_1_SMU_BUSY_MASK__SHIFT 0x1
#define SCLK_DEEP_SLEEP_CNTL3__GRBM_2_SMU_BUSY_MASK_MASK 0x4
#define SCLK_DEEP_SLEEP_CNTL3__GRBM_2_SMU_BUSY_MASK__SHIFT 0x2
#define SCLK_DEEP_SLEEP_CNTL3__GRBM_3_SMU_BUSY_MASK_MASK 0x8
#define SCLK_DEEP_SLEEP_CNTL3__GRBM_3_SMU_BUSY_MASK__SHIFT 0x3
#define SCLK_DEEP_SLEEP_CNTL3__GRBM_4_SMU_BUSY_MASK_MASK 0x10
#define SCLK_DEEP_SLEEP_CNTL3__GRBM_4_SMU_BUSY_MASK__SHIFT 0x4
#define SCLK_DEEP_SLEEP_CNTL3__GRBM_5_SMU_BUSY_MASK_MASK 0x20
#define SCLK_DEEP_SLEEP_CNTL3__GRBM_5_SMU_BUSY_MASK__SHIFT 0x5
#define SCLK_DEEP_SLEEP_CNTL3__GRBM_6_SMU_BUSY_MASK_MASK 0x40
#define SCLK_DEEP_SLEEP_CNTL3__GRBM_6_SMU_BUSY_MASK__SHIFT 0x6
#define SCLK_DEEP_SLEEP_CNTL3__GRBM_7_SMU_BUSY_MASK_MASK 0x80
#define SCLK_DEEP_SLEEP_CNTL3__GRBM_7_SMU_BUSY_MASK__SHIFT 0x7
#define SCLK_DEEP_SLEEP_CNTL3__GRBM_8_SMU_BUSY_MASK_MASK 0x100
#define SCLK_DEEP_SLEEP_CNTL3__GRBM_8_SMU_BUSY_MASK__SHIFT 0x8
#define SCLK_DEEP_SLEEP_CNTL3__GRBM_9_SMU_BUSY_MASK_MASK 0x200
#define SCLK_DEEP_SLEEP_CNTL3__GRBM_9_SMU_BUSY_MASK__SHIFT 0x9
#define SCLK_DEEP_SLEEP_CNTL3__GRBM_10_SMU_BUSY_MASK_MASK 0x400
#define SCLK_DEEP_SLEEP_CNTL3__GRBM_10_SMU_BUSY_MASK__SHIFT 0xa
#define SCLK_DEEP_SLEEP_CNTL3__GRBM_11_SMU_BUSY_MASK_MASK 0x800
#define SCLK_DEEP_SLEEP_CNTL3__GRBM_11_SMU_BUSY_MASK__SHIFT 0xb
#define SCLK_DEEP_SLEEP_CNTL3__GRBM_12_SMU_BUSY_MASK_MASK 0x1000
#define SCLK_DEEP_SLEEP_CNTL3__GRBM_12_SMU_BUSY_MASK__SHIFT 0xc
#define SCLK_DEEP_SLEEP_CNTL3__GRBM_13_SMU_BUSY_MASK_MASK 0x2000
#define SCLK_DEEP_SLEEP_CNTL3__GRBM_13_SMU_BUSY_MASK__SHIFT 0xd
#define SCLK_DEEP_SLEEP_CNTL3__GRBM_14_SMU_BUSY_MASK_MASK 0x4000
#define SCLK_DEEP_SLEEP_CNTL3__GRBM_14_SMU_BUSY_MASK__SHIFT 0xe
#define SCLK_DEEP_SLEEP_CNTL3__GRBM_15_SMU_BUSY_MASK_MASK 0x8000
#define SCLK_DEEP_SLEEP_CNTL3__GRBM_15_SMU_BUSY_MASK__SHIFT 0xf
#define SCLK_DEEP_SLEEP_CNTL3__SMUIF_SLAVE_SCLK_BUSY_MASK_MASK 0x10000
#define SCLK_DEEP_SLEEP_CNTL3__SMUIF_SLAVE_SCLK_BUSY_MASK__SHIFT 0x10
#define SCLK_DEEP_SLEEP_CNTL3__SMUIF_MASTER_SCLK_BUSY_MASK_MASK 0x20000
#define SCLK_DEEP_SLEEP_CNTL3__SMUIF_MASTER_SCLK_BUSY_MASK__SHIFT 0x11
#define SCLK_DEEP_SLEEP_MISC_CNTL__DPM_DS_DIV_ID_MASK 0x7
#define SCLK_DEEP_SLEEP_MISC_CNTL__DPM_DS_DIV_ID__SHIFT 0x0
#define SCLK_DEEP_SLEEP_MISC_CNTL__DPM_SS_DIV_ID_MASK 0x38
#define SCLK_DEEP_SLEEP_MISC_CNTL__DPM_SS_DIV_ID__SHIFT 0x3
#define SCLK_DEEP_SLEEP_MISC_CNTL__OCP_ENABLE_MASK 0x10000
#define SCLK_DEEP_SLEEP_MISC_CNTL__OCP_ENABLE__SHIFT 0x10
#define SCLK_DEEP_SLEEP_MISC_CNTL__OCP_DS_DIV_ID_MASK 0xe0000
#define SCLK_DEEP_SLEEP_MISC_CNTL__OCP_DS_DIV_ID__SHIFT 0x11
#define SCLK_DEEP_SLEEP_MISC_CNTL__OCP_SS_DIV_ID_MASK 0x700000
#define SCLK_DEEP_SLEEP_MISC_CNTL__OCP_SS_DIV_ID__SHIFT 0x14
#define LCLK_DEEP_SLEEP_CNTL__DIV_ID_MASK 0x7
#define LCLK_DEEP_SLEEP_CNTL__DIV_ID__SHIFT 0x0
#define LCLK_DEEP_SLEEP_CNTL__RAMP_DIS_MASK 0x8
#define LCLK_DEEP_SLEEP_CNTL__RAMP_DIS__SHIFT 0x3
#define LCLK_DEEP_SLEEP_CNTL__HYSTERESIS_MASK 0xfff0
#define LCLK_DEEP_SLEEP_CNTL__HYSTERESIS__SHIFT 0x4
#define LCLK_DEEP_SLEEP_CNTL__RESERVED_MASK 0x7fff0000
#define LCLK_DEEP_SLEEP_CNTL__RESERVED__SHIFT 0x10
#define LCLK_DEEP_SLEEP_CNTL__ENABLE_DS_MASK 0x80000000
#define LCLK_DEEP_SLEEP_CNTL__ENABLE_DS__SHIFT 0x1f
#define LCLK_DEEP_SLEEP_CNTL2__RFE_BUSY_MASK_MASK 0x1
#define LCLK_DEEP_SLEEP_CNTL2__RFE_BUSY_MASK__SHIFT 0x0
#define LCLK_DEEP_SLEEP_CNTL2__BIF_CG_LCLK_BUSY_MASK_MASK 0x2
#define LCLK_DEEP_SLEEP_CNTL2__BIF_CG_LCLK_BUSY_MASK__SHIFT 0x1
#define LCLK_DEEP_SLEEP_CNTL2__L1IMU_SMU_IDLE_MASK_MASK 0x4
#define LCLK_DEEP_SLEEP_CNTL2__L1IMU_SMU_IDLE_MASK__SHIFT 0x2
#define LCLK_DEEP_SLEEP_CNTL2__RESERVED_BIT3_MASK 0x8
#define LCLK_DEEP_SLEEP_CNTL2__RESERVED_BIT3__SHIFT 0x3
#define LCLK_DEEP_SLEEP_CNTL2__SCLK_RUNNING_MASK_MASK 0x10
#define LCLK_DEEP_SLEEP_CNTL2__SCLK_RUNNING_MASK__SHIFT 0x4
#define LCLK_DEEP_SLEEP_CNTL2__SMU_BUSY_MASK_MASK 0x20
#define LCLK_DEEP_SLEEP_CNTL2__SMU_BUSY_MASK__SHIFT 0x5
#define LCLK_DEEP_SLEEP_CNTL2__PCIE_LCLK_IDLE1_MASK_MASK 0x40
#define LCLK_DEEP_SLEEP_CNTL2__PCIE_LCLK_IDLE1_MASK__SHIFT 0x6
#define LCLK_DEEP_SLEEP_CNTL2__PCIE_LCLK_IDLE2_MASK_MASK 0x80
#define LCLK_DEEP_SLEEP_CNTL2__PCIE_LCLK_IDLE2_MASK__SHIFT 0x7
#define LCLK_DEEP_SLEEP_CNTL2__PCIE_LCLK_IDLE3_MASK_MASK 0x100
#define LCLK_DEEP_SLEEP_CNTL2__PCIE_LCLK_IDLE3_MASK__SHIFT 0x8
#define LCLK_DEEP_SLEEP_CNTL2__PCIE_LCLK_IDLE4_MASK_MASK 0x200
#define LCLK_DEEP_SLEEP_CNTL2__PCIE_LCLK_IDLE4_MASK__SHIFT 0x9
#define LCLK_DEEP_SLEEP_CNTL2__L1IMUGPP_IDLE_MASK_MASK 0x400
#define LCLK_DEEP_SLEEP_CNTL2__L1IMUGPP_IDLE_MASK__SHIFT 0xa
#define LCLK_DEEP_SLEEP_CNTL2__L1IMUGPPSB_IDLE_MASK_MASK 0x800
#define LCLK_DEEP_SLEEP_CNTL2__L1IMUGPPSB_IDLE_MASK__SHIFT 0xb
#define LCLK_DEEP_SLEEP_CNTL2__L1IMUBIF_IDLE_MASK_MASK 0x1000
#define LCLK_DEEP_SLEEP_CNTL2__L1IMUBIF_IDLE_MASK__SHIFT 0xc
#define LCLK_DEEP_SLEEP_CNTL2__L1IMUINTGEN_IDLE_MASK_MASK 0x2000
#define LCLK_DEEP_SLEEP_CNTL2__L1IMUINTGEN_IDLE_MASK__SHIFT 0xd
#define LCLK_DEEP_SLEEP_CNTL2__L2IMU_IDLE_MASK_MASK 0x4000
#define LCLK_DEEP_SLEEP_CNTL2__L2IMU_IDLE_MASK__SHIFT 0xe
#define LCLK_DEEP_SLEEP_CNTL2__ORB_IDLE_MASK_MASK 0x8000
#define LCLK_DEEP_SLEEP_CNTL2__ORB_IDLE_MASK__SHIFT 0xf
#define LCLK_DEEP_SLEEP_CNTL2__ON_INB_WAKE_MASK_MASK 0x10000
#define LCLK_DEEP_SLEEP_CNTL2__ON_INB_WAKE_MASK__SHIFT 0x10
#define LCLK_DEEP_SLEEP_CNTL2__ON_INB_WAKE_ACK_MASK_MASK 0x20000
#define LCLK_DEEP_SLEEP_CNTL2__ON_INB_WAKE_ACK_MASK__SHIFT 0x11
#define LCLK_DEEP_SLEEP_CNTL2__ON_OUTB_WAKE_MASK_MASK 0x40000
#define LCLK_DEEP_SLEEP_CNTL2__ON_OUTB_WAKE_MASK__SHIFT 0x12
#define LCLK_DEEP_SLEEP_CNTL2__ON_OUTB_WAKE_ACK_MASK_MASK 0x80000
#define LCLK_DEEP_SLEEP_CNTL2__ON_OUTB_WAKE_ACK_MASK__SHIFT 0x13
#define LCLK_DEEP_SLEEP_CNTL2__DMAACTIVE_MASK_MASK 0x100000
#define LCLK_DEEP_SLEEP_CNTL2__DMAACTIVE_MASK__SHIFT 0x14
#define LCLK_DEEP_SLEEP_CNTL2__L1IMUPCIE0_IDLE_MASK_MASK 0x200000
#define LCLK_DEEP_SLEEP_CNTL2__L1IMUPCIE0_IDLE_MASK__SHIFT 0x15
#define LCLK_DEEP_SLEEP_CNTL2__L1IMUPCIE1_IDLE_MASK_MASK 0x400000
#define LCLK_DEEP_SLEEP_CNTL2__L1IMUPCIE1_IDLE_MASK__SHIFT 0x16
#define LCLK_DEEP_SLEEP_CNTL2__L1IMUIOAGR_IDLE_MASK_MASK 0x800000
#define LCLK_DEEP_SLEEP_CNTL2__L1IMUIOAGR_IDLE_MASK__SHIFT 0x17
#define LCLK_DEEP_SLEEP_CNTL2__SPG_SMU_IDLE_MASK_MASK 0x1000000
#define LCLK_DEEP_SLEEP_CNTL2__SPG_SMU_IDLE_MASK__SHIFT 0x18
#define LCLK_DEEP_SLEEP_CNTL2__APG_SMU_IDLE_MASK_MASK 0x2000000
#define LCLK_DEEP_SLEEP_CNTL2__APG_SMU_IDLE_MASK__SHIFT 0x19
#define LCLK_DEEP_SLEEP_CNTL2__IP_SMU_IDLE0_MASK_MASK 0x4000000
#define LCLK_DEEP_SLEEP_CNTL2__IP_SMU_IDLE0_MASK__SHIFT 0x1a
#define LCLK_DEEP_SLEEP_CNTL2__IP_SMU_IDLE1_MASK_MASK 0x8000000
#define LCLK_DEEP_SLEEP_CNTL2__IP_SMU_IDLE1_MASK__SHIFT 0x1b
#define LCLK_DEEP_SLEEP_CNTL2__IP_SMU_IDLE2_MASK_MASK 0x10000000
#define LCLK_DEEP_SLEEP_CNTL2__IP_SMU_IDLE2_MASK__SHIFT 0x1c
#define LCLK_DEEP_SLEEP_CNTL2__IP_SMU_IDLE3_MASK_MASK 0x20000000
#define LCLK_DEEP_SLEEP_CNTL2__IP_SMU_IDLE3_MASK__SHIFT 0x1d
#define LCLK_DEEP_SLEEP_CNTL2__RESERVED_MASK 0xc0000000
#define LCLK_DEEP_SLEEP_CNTL2__RESERVED__SHIFT 0x1e
#define SMU_VOLTAGE_STATUS__SMU_VOLTAGE_STATUS_MASK 0x1
#define SMU_VOLTAGE_STATUS__SMU_VOLTAGE_STATUS__SHIFT 0x0
#define SMU_VOLTAGE_STATUS__SMU_VOLTAGE_CURRENT_LEVEL_MASK 0x1fe
#define SMU_VOLTAGE_STATUS__SMU_VOLTAGE_CURRENT_LEVEL__SHIFT 0x1
#define CG_ULV_PARAMETER__ULV_THRESHOLD_MASK 0xffff
#define CG_ULV_PARAMETER__ULV_THRESHOLD__SHIFT 0x0
#define CG_ULV_PARAMETER__ULV_THRESHOLD_UNIT_MASK 0xf0000
#define CG_ULV_PARAMETER__ULV_THRESHOLD_UNIT__SHIFT 0x10
#define PWR_DC_RESP__RESPONSE_MASK 0x1
#define PWR_DC_RESP__RESPONSE__SHIFT 0x0
#define PWR_VCE_RESP__RESPONSE_MASK 0xffffffff
#define PWR_VCE_RESP__RESPONSE__SHIFT 0x0
#define PWR_UVD_RESP__RESPONSE_MASK 0xffffffff
#define PWR_UVD_RESP__RESPONSE__SHIFT 0x0
#define PWR_ACP_RESP__RESPONSE_MASK 0xffffffff
#define PWR_ACP_RESP__RESPONSE__SHIFT 0x0
#define PWR_DC_REQ__REQUEST_MASK 0x1
#define PWR_DC_REQ__REQUEST__SHIFT 0x0
#define SCLK_MIN_DIV__FRACV_MASK 0xfff
#define SCLK_MIN_DIV__FRACV__SHIFT 0x0
#define SCLK_MIN_DIV__INTV_MASK 0x7f000
#define SCLK_MIN_DIV__INTV__SHIFT 0xc
#define PCIE_PGFSM_CONFIG__FSM_ADDR_MASK 0xff
#define PCIE_PGFSM_CONFIG__FSM_ADDR__SHIFT 0x0
#define PCIE_PGFSM_CONFIG__Power_Down_MASK 0x100
#define PCIE_PGFSM_CONFIG__Power_Down__SHIFT 0x8
#define PCIE_PGFSM_CONFIG__Power_Up_MASK 0x200
#define PCIE_PGFSM_CONFIG__Power_Up__SHIFT 0x9
#define PCIE_PGFSM_CONFIG__P1_Select_MASK 0x400
#define PCIE_PGFSM_CONFIG__P1_Select__SHIFT 0xa
#define PCIE_PGFSM_CONFIG__P2_Select_MASK 0x800
#define PCIE_PGFSM_CONFIG__P2_Select__SHIFT 0xb
#define PCIE_PGFSM_CONFIG__Write_Op_MASK 0x1000
#define PCIE_PGFSM_CONFIG__Write_Op__SHIFT 0xc
#define PCIE_PGFSM_CONFIG__Read_Op_MASK 0x2000
#define PCIE_PGFSM_CONFIG__Read_Op__SHIFT 0xd
#define PCIE_PGFSM_CONFIG__Reserved_MASK 0xfffc000
#define PCIE_PGFSM_CONFIG__Reserved__SHIFT 0xe
#define PCIE_PGFSM_CONFIG__REG_ADDR_MASK 0xf0000000
#define PCIE_PGFSM_CONFIG__REG_ADDR__SHIFT 0x1c
#define PCIE_PGFSM_WRITE__Write_value_MASK 0xffffffff
#define PCIE_PGFSM_WRITE__Write_value__SHIFT 0x0
#define SERDES_BUSY__PCIE_SERDES_BUSY_MASK 0x1
#define SERDES_BUSY__PCIE_SERDES_BUSY__SHIFT 0x0
#define PCIE_PGFSM2_CONFIG__FSM_ADDR_MASK 0xff
#define PCIE_PGFSM2_CONFIG__FSM_ADDR__SHIFT 0x0
#define PCIE_PGFSM2_CONFIG__Power_Down_MASK 0x100
#define PCIE_PGFSM2_CONFIG__Power_Down__SHIFT 0x8
#define PCIE_PGFSM2_CONFIG__Power_Up_MASK 0x200
#define PCIE_PGFSM2_CONFIG__Power_Up__SHIFT 0x9
#define PCIE_PGFSM2_CONFIG__P1_Select_MASK 0x400
#define PCIE_PGFSM2_CONFIG__P1_Select__SHIFT 0xa
#define PCIE_PGFSM2_CONFIG__P2_Select_MASK 0x800
#define PCIE_PGFSM2_CONFIG__P2_Select__SHIFT 0xb
#define PCIE_PGFSM2_CONFIG__Write_Op_MASK 0x1000
#define PCIE_PGFSM2_CONFIG__Write_Op__SHIFT 0xc
#define PCIE_PGFSM2_CONFIG__Read_Op_MASK 0x2000
#define PCIE_PGFSM2_CONFIG__Read_Op__SHIFT 0xd
#define PCIE_PGFSM2_CONFIG__Reserved_MASK 0xfffc000
#define PCIE_PGFSM2_CONFIG__Reserved__SHIFT 0xe
#define PCIE_PGFSM2_CONFIG__REG_ADDR_MASK 0xf0000000
#define PCIE_PGFSM2_CONFIG__REG_ADDR__SHIFT 0x1c
#define PCIE_PGFSM2_WRITE__Write_value_MASK 0xffffffff
#define PCIE_PGFSM2_WRITE__Write_value__SHIFT 0x0
#define SERDES2_BUSY__PCIE_SERDES_BUSY_MASK 0x1
#define SERDES2_BUSY__PCIE_SERDES_BUSY__SHIFT 0x0
#define PCIE_PGFSM_0_READ__Read_value_MASK 0xffffff
#define PCIE_PGFSM_0_READ__Read_value__SHIFT 0x0
#define PCIE_PGFSM_0_READ__Read_valid_MASK 0x1000000
#define PCIE_PGFSM_0_READ__Read_valid__SHIFT 0x18
#define PCIE_PGFSM_1_READ__Read_value_MASK 0xffffff
#define PCIE_PGFSM_1_READ__Read_value__SHIFT 0x0
#define PCIE_PGFSM_1_READ__Read_valid_MASK 0x1000000
#define PCIE_PGFSM_1_READ__Read_valid__SHIFT 0x18
#define PWR_ACPI_INTERRUPT__BIF_CG_req_MASK 0x1
#define PWR_ACPI_INTERRUPT__BIF_CG_req__SHIFT 0x0
#define PWR_ACPI_INTERRUPT__AZ_CG_req_MASK 0x2
#define PWR_ACPI_INTERRUPT__AZ_CG_req__SHIFT 0x1
#define PWR_ACPI_INTERRUPT__AZ_CG_resp_MASK 0x4
#define PWR_ACPI_INTERRUPT__AZ_CG_resp__SHIFT 0x2
#define VDDGFX_IDLE_PARAMETER__VDDGFX_IDLE_THRESHOLD_MASK 0xffff
#define VDDGFX_IDLE_PARAMETER__VDDGFX_IDLE_THRESHOLD__SHIFT 0x0
#define VDDGFX_IDLE_PARAMETER__VDDGFX_IDLE_THRESHOLD_UNIT_MASK 0xf0000
#define VDDGFX_IDLE_PARAMETER__VDDGFX_IDLE_THRESHOLD_UNIT__SHIFT 0x10
#define VDDGFX_IDLE_CONTROL__VDDGFX_IDLE_EN_MASK 0x1
#define VDDGFX_IDLE_CONTROL__VDDGFX_IDLE_EN__SHIFT 0x0
#define VDDGFX_IDLE_CONTROL__VDDGFX_IDLE_DETECT_MASK 0x2
#define VDDGFX_IDLE_CONTROL__VDDGFX_IDLE_DETECT__SHIFT 0x1
#define VDDGFX_IDLE_CONTROL__FORCE_VDDGFX_IDLE_EXIT_MASK 0x4
#define VDDGFX_IDLE_CONTROL__FORCE_VDDGFX_IDLE_EXIT__SHIFT 0x2
#define VDDGFX_IDLE_CONTROL__SMC_VDDGFX_IDLE_STATE_MASK 0x8
#define VDDGFX_IDLE_CONTROL__SMC_VDDGFX_IDLE_STATE__SHIFT 0x3
#define VDDGFX_IDLE_EXIT__BIF_EXIT_REQ_MASK 0x1
#define VDDGFX_IDLE_EXIT__BIF_EXIT_REQ__SHIFT 0x0
#define REG_SCLK_DEEP_SLEEP_EXIT__REG_sclk_deep_sleep_exit_MASK 0x1
#define REG_SCLK_DEEP_SLEEP_EXIT__REG_sclk_deep_sleep_exit__SHIFT 0x0
#define CAC_WEIGHT_LKG_DC_3__WEIGHT_LKG_DC_SIG4_MASK 0xffff
#define CAC_WEIGHT_LKG_DC_3__WEIGHT_LKG_DC_SIG4__SHIFT 0x0
#define CAC_WEIGHT_LKG_DC_3__WEIGHT_LKG_DC_SIG5_MASK 0xffff0000
#define CAC_WEIGHT_LKG_DC_3__WEIGHT_LKG_DC_SIG5__SHIFT 0x10
#define LCAC_MC0_CNTL__MC0_ENABLE_MASK 0x1
#define LCAC_MC0_CNTL__MC0_ENABLE__SHIFT 0x0
#define LCAC_MC0_CNTL__MC0_THRESHOLD_MASK 0x1fffe
#define LCAC_MC0_CNTL__MC0_THRESHOLD__SHIFT 0x1
#define LCAC_MC0_CNTL__MC0_BLOCK_ID_MASK 0x3e0000
#define LCAC_MC0_CNTL__MC0_BLOCK_ID__SHIFT 0x11
#define LCAC_MC0_CNTL__MC0_SIGNAL_ID_MASK 0x3fc00000
#define LCAC_MC0_CNTL__MC0_SIGNAL_ID__SHIFT 0x16
#define LCAC_MC0_OVR_SEL__MC0_OVR_SEL_MASK 0xffffffff
#define LCAC_MC0_OVR_SEL__MC0_OVR_SEL__SHIFT 0x0
#define LCAC_MC0_OVR_VAL__MC0_OVR_VAL_MASK 0xffffffff
#define LCAC_MC0_OVR_VAL__MC0_OVR_VAL__SHIFT 0x0
#define LCAC_MC1_CNTL__MC1_ENABLE_MASK 0x1
#define LCAC_MC1_CNTL__MC1_ENABLE__SHIFT 0x0
#define LCAC_MC1_CNTL__MC1_THRESHOLD_MASK 0x1fffe
#define LCAC_MC1_CNTL__MC1_THRESHOLD__SHIFT 0x1
#define LCAC_MC1_CNTL__MC1_BLOCK_ID_MASK 0x3e0000
#define LCAC_MC1_CNTL__MC1_BLOCK_ID__SHIFT 0x11
#define LCAC_MC1_CNTL__MC1_SIGNAL_ID_MASK 0x3fc00000
#define LCAC_MC1_CNTL__MC1_SIGNAL_ID__SHIFT 0x16
#define LCAC_MC1_OVR_SEL__MC1_OVR_SEL_MASK 0xffffffff
#define LCAC_MC1_OVR_SEL__MC1_OVR_SEL__SHIFT 0x0
#define LCAC_MC1_OVR_VAL__MC1_OVR_VAL_MASK 0xffffffff
#define LCAC_MC1_OVR_VAL__MC1_OVR_VAL__SHIFT 0x0
#define LCAC_MC2_CNTL__MC2_ENABLE_MASK 0x1
#define LCAC_MC2_CNTL__MC2_ENABLE__SHIFT 0x0
#define LCAC_MC2_CNTL__MC2_THRESHOLD_MASK 0x1fffe
#define LCAC_MC2_CNTL__MC2_THRESHOLD__SHIFT 0x1
#define LCAC_MC2_CNTL__MC2_BLOCK_ID_MASK 0x3e0000
#define LCAC_MC2_CNTL__MC2_BLOCK_ID__SHIFT 0x11
#define LCAC_MC2_CNTL__MC2_SIGNAL_ID_MASK 0x3fc00000
#define LCAC_MC2_CNTL__MC2_SIGNAL_ID__SHIFT 0x16
#define LCAC_MC2_OVR_SEL__MC2_OVR_SEL_MASK 0xffffffff
#define LCAC_MC2_OVR_SEL__MC2_OVR_SEL__SHIFT 0x0
#define LCAC_MC2_OVR_VAL__MC2_OVR_VAL_MASK 0xffffffff
#define LCAC_MC2_OVR_VAL__MC2_OVR_VAL__SHIFT 0x0
#define LCAC_MC3_CNTL__MC3_ENABLE_MASK 0x1
#define LCAC_MC3_CNTL__MC3_ENABLE__SHIFT 0x0
#define LCAC_MC3_CNTL__MC3_THRESHOLD_MASK 0x1fffe
#define LCAC_MC3_CNTL__MC3_THRESHOLD__SHIFT 0x1
#define LCAC_MC3_CNTL__MC3_BLOCK_ID_MASK 0x3e0000
#define LCAC_MC3_CNTL__MC3_BLOCK_ID__SHIFT 0x11
#define LCAC_MC3_CNTL__MC3_SIGNAL_ID_MASK 0x3fc00000
#define LCAC_MC3_CNTL__MC3_SIGNAL_ID__SHIFT 0x16
#define LCAC_MC3_OVR_SEL__MC3_OVR_SEL_MASK 0xffffffff
#define LCAC_MC3_OVR_SEL__MC3_OVR_SEL__SHIFT 0x0
#define LCAC_MC3_OVR_VAL__MC3_OVR_VAL_MASK 0xffffffff
#define LCAC_MC3_OVR_VAL__MC3_OVR_VAL__SHIFT 0x0
#define LCAC_CPL_CNTL__CPL_ENABLE_MASK 0x1
#define LCAC_CPL_CNTL__CPL_ENABLE__SHIFT 0x0
#define LCAC_CPL_CNTL__CPL_THRESHOLD_MASK 0x1fffe
#define LCAC_CPL_CNTL__CPL_THRESHOLD__SHIFT 0x1
#define LCAC_CPL_CNTL__CPL_BLOCK_ID_MASK 0x3e0000
#define LCAC_CPL_CNTL__CPL_BLOCK_ID__SHIFT 0x11
#define LCAC_CPL_CNTL__CPL_SIGNAL_ID_MASK 0x3fc00000
#define LCAC_CPL_CNTL__CPL_SIGNAL_ID__SHIFT 0x16
#define LCAC_CPL_OVR_SEL__CPL_OVR_SEL_MASK 0xffffffff
#define LCAC_CPL_OVR_SEL__CPL_OVR_SEL__SHIFT 0x0
#define LCAC_CPL_OVR_VAL__CPL_OVR_VAL_MASK 0xffffffff
#define LCAC_CPL_OVR_VAL__CPL_OVR_VAL__SHIFT 0x0
#define MISC_UNB_PWRMGT_CFG0__TARGET_ADDR_MASK 0xffffffff
#define MISC_UNB_PWRMGT_CFG0__TARGET_ADDR__SHIFT 0x0
#define MISC_UNB_PWRMGT_CFG1__TIMER_EN_MASK 0x1
#define MISC_UNB_PWRMGT_CFG1__TIMER_EN__SHIFT 0x0
#define MISC_UNB_PWRMGT_CFG1__TIMER_INTERVAL_MASK 0x1fffe
#define MISC_UNB_PWRMGT_CFG1__TIMER_INTERVAL__SHIFT 0x1
#define MISC_UNB_PWRMGT_CFG1__INT_GEN_EN_MASK 0x20000
#define MISC_UNB_PWRMGT_CFG1__INT_GEN_EN__SHIFT 0x11
#define MISC_UNB_PWRMGT_DATA__NB_CROSS_TRIGGER_MASK 0xf
#define MISC_UNB_PWRMGT_DATA__NB_CROSS_TRIGGER__SHIFT 0x0
#define MISC_UNB_PWRMGT_DATA__NB_PRE_SELF_REFRESH_MASK 0x10
#define MISC_UNB_PWRMGT_DATA__NB_PRE_SELF_REFRESH__SHIFT 0x4
#define MISC_UNB_PWRMGT_DATA__NB_REQ_NB_PSTATE_MASK 0x20
#define MISC_UNB_PWRMGT_DATA__NB_REQ_NB_PSTATE__SHIFT 0x5
#define MISC_UNB_PWRMGT_DATA__NB_FLUSH_ACK_TOGGLE_MASK 0x40
#define MISC_UNB_PWRMGT_DATA__NB_FLUSH_ACK_TOGGLE__SHIFT 0x6
#define MISC_UNB_PWRMGT_DATA__NB_ON_INB_WAKE_ACK_MASK 0x80
#define MISC_UNB_PWRMGT_DATA__NB_ON_INB_WAKE_ACK__SHIFT 0x7
#define MISC_UNB_PWRMGT_DATA__NB_ON3_CH0LINK_WAKE_ACK_MASK 0x100
#define MISC_UNB_PWRMGT_DATA__NB_ON3_CH0LINK_WAKE_ACK__SHIFT 0x8
#define MISC_UNB_PWRMGT_DATA__NB_ON3_CH1LINK_WAKE_ACK_MASK 0x200
#define MISC_UNB_PWRMGT_DATA__NB_ON3_CH1LINK_WAKE_ACK__SHIFT 0x9
#define GNBPM_SMU_PWRMGT_DATA__UNBPM_AllCpusInCC6_MASK 0x1
#define GNBPM_SMU_PWRMGT_DATA__UNBPM_AllCpusInCC6__SHIFT 0x0
#define GNBPM_SMU_PWRMGT_DATA__UNBPM_HtcActive_MASK 0x2
#define GNBPM_SMU_PWRMGT_DATA__UNBPM_HtcActive__SHIFT 0x1
#define GNBPM_SMU_PWRMGT_DATA__UNBPM_SmuInt_MASK 0x4
#define GNBPM_SMU_PWRMGT_DATA__UNBPM_SmuInt__SHIFT 0x2
#define GNBPM_SMU_PWRMGT_DATA__UNBPM_SPARE_MASK 0xf8
#define GNBPM_SMU_PWRMGT_DATA__UNBPM_SPARE__SHIFT 0x3
#define DMA_ACTIVE_SAMPLER_CFG__SAMPLING_TIMER_EN_MASK 0x1
#define DMA_ACTIVE_SAMPLER_CFG__SAMPLING_TIMER_EN__SHIFT 0x0
#define DMA_ACTIVE_SAMPLER_CFG__SAMPLING_TIMER_PERIOD_MASK 0x1fffe
#define DMA_ACTIVE_SAMPLER_CFG__SAMPLING_TIMER_PERIOD__SHIFT 0x1
#define DMA_ACTIVE_SAMPLER_CFG__DMA_ACTIVE_TRANS_CNT_MASK 0x60000
#define DMA_ACTIVE_SAMPLER_CFG__DMA_ACTIVE_TRANS_CNT__SHIFT 0x11
#define SOUTHBRIDGE_TYPE__DISCRETE_SB_MASK 0x1
#define SOUTHBRIDGE_TYPE__DISCRETE_SB__SHIFT 0x0
#define GNBPM_SMU_PWRMGT_STATUS__PM_AllCpusInCC6_MASK 0x1
#define GNBPM_SMU_PWRMGT_STATUS__PM_AllCpusInCC6__SHIFT 0x0
#define GNBPM_SMU_PWRMGT_STATUS__PM_HtcActive_MASK 0x2
#define GNBPM_SMU_PWRMGT_STATUS__PM_HtcActive__SHIFT 0x1
#define GNBPM_SMU_PWRMGT_STATUS__PM_SmuInt_MASK 0x4
#define GNBPM_SMU_PWRMGT_STATUS__PM_SmuInt__SHIFT 0x2
#define GNBPM_SMU_PWRMGT_STATUS__PM_SmuIntSuperVminExit_MASK 0x8
#define GNBPM_SMU_PWRMGT_STATUS__PM_SmuIntSuperVminExit__SHIFT 0x3
#define GNBPM_SMU_PWRMGT_STATUS__PM_PreSelfRefresh_MASK 0x10
#define GNBPM_SMU_PWRMGT_STATUS__PM_PreSelfRefresh__SHIFT 0x4
#define GNBPM_SMU_PWRMGT_STATUS__PM_ReqNbPstate_MASK 0x20
#define GNBPM_SMU_PWRMGT_STATUS__PM_ReqNbPstate__SHIFT 0x5
#define GNBPM_SMU_PWRMGT_STATUS__PM_AllowNbPstate_MASK 0x40
#define GNBPM_SMU_PWRMGT_STATUS__PM_AllowNbPstate__SHIFT 0x6
#define GNBPM_SMU_PWRMGT_STATUS__PM_AllowSelfRefresh_MASK 0x80
#define GNBPM_SMU_PWRMGT_STATUS__PM_AllowSelfRefresh__SHIFT 0x7
#define GNBPM_SMU_PWRMGT_STATUS__PM_IntrWake_MASK 0x100
#define GNBPM_SMU_PWRMGT_STATUS__PM_IntrWake__SHIFT 0x8
#define GNBPM_SMU_PWRMGT_STATUS__SPARE_MASK 0xfe00
#define GNBPM_SMU_PWRMGT_STATUS__SPARE__SHIFT 0x9
#define ALLOW_SR_INTR_CTRL__ALLOW_SR_INTR_CTRL_MASK 0x3
#define ALLOW_SR_INTR_CTRL__ALLOW_SR_INTR_CTRL__SHIFT 0x0
#define GC_CAC_LKG_AGGR_LOWER__LKG_AGGR_31_0_MASK 0xffffffff
#define GC_CAC_LKG_AGGR_LOWER__LKG_AGGR_31_0__SHIFT 0x0
#define GC_CAC_LKG_AGGR_UPPER__LKG_AGGR_63_32_MASK 0xffffffff
#define GC_CAC_LKG_AGGR_UPPER__LKG_AGGR_63_32__SHIFT 0x0
#define GC_CAC_WEIGHT_CU_0__WEIGHT_CU_SIG0_MASK 0xffff
#define GC_CAC_WEIGHT_CU_0__WEIGHT_CU_SIG0__SHIFT 0x0
#define GC_CAC_WEIGHT_CU_0__WEIGHT_CU_SIG1_MASK 0xffff0000
#define GC_CAC_WEIGHT_CU_0__WEIGHT_CU_SIG1__SHIFT 0x10
#define GC_CAC_WEIGHT_CU_1__WEIGHT_CU_SIG2_MASK 0xffff
#define GC_CAC_WEIGHT_CU_1__WEIGHT_CU_SIG2__SHIFT 0x0
#define GC_CAC_WEIGHT_CU_1__WEIGHT_CU_SIG3_MASK 0xffff0000
#define GC_CAC_WEIGHT_CU_1__WEIGHT_CU_SIG3__SHIFT 0x10
#define GC_CAC_WEIGHT_CU_2__WEIGHT_CU_SIG4_MASK 0xffff
#define GC_CAC_WEIGHT_CU_2__WEIGHT_CU_SIG4__SHIFT 0x0
#define GC_CAC_WEIGHT_CU_2__WEIGHT_CU_SIG5_MASK 0xffff0000
#define GC_CAC_WEIGHT_CU_2__WEIGHT_CU_SIG5__SHIFT 0x10
#define GC_CAC_WEIGHT_CU_3__WEIGHT_CU_SIG6_MASK 0xffff
#define GC_CAC_WEIGHT_CU_3__WEIGHT_CU_SIG6__SHIFT 0x0
#define GC_CAC_WEIGHT_CU_3__WEIGHT_CU_SIG7_MASK 0xffff0000
#define GC_CAC_WEIGHT_CU_3__WEIGHT_CU_SIG7__SHIFT 0x10
#define GC_CAC_ACC_CU0__ACCUMULATOR_31_0_MASK 0xffffffff
#define GC_CAC_ACC_CU0__ACCUMULATOR_31_0__SHIFT 0x0
#define GC_CAC_ACC_CU1__ACCUMULATOR_31_0_MASK 0xffffffff
#define GC_CAC_ACC_CU1__ACCUMULATOR_31_0__SHIFT 0x0
#define GC_CAC_ACC_CU2__ACCUMULATOR_31_0_MASK 0xffffffff
#define GC_CAC_ACC_CU2__ACCUMULATOR_31_0__SHIFT 0x0
#define GC_CAC_ACC_CU3__ACCUMULATOR_31_0_MASK 0xffffffff
#define GC_CAC_ACC_CU3__ACCUMULATOR_31_0__SHIFT 0x0
#define GC_CAC_ACC_CU4__ACCUMULATOR_31_0_MASK 0xffffffff
#define GC_CAC_ACC_CU4__ACCUMULATOR_31_0__SHIFT 0x0
#define GC_CAC_ACC_CU5__ACCUMULATOR_31_0_MASK 0xffffffff
#define GC_CAC_ACC_CU5__ACCUMULATOR_31_0__SHIFT 0x0
#define GC_CAC_ACC_CU6__ACCUMULATOR_31_0_MASK 0xffffffff
#define GC_CAC_ACC_CU6__ACCUMULATOR_31_0__SHIFT 0x0
#define GC_CAC_ACC_CU7__ACCUMULATOR_31_0_MASK 0xffffffff
#define GC_CAC_ACC_CU7__ACCUMULATOR_31_0__SHIFT 0x0
#define GC_CAC_OVRD_CU__OVRRD_SELECT_MASK 0xffff
#define GC_CAC_OVRD_CU__OVRRD_SELECT__SHIFT 0x0
#define GC_CAC_OVRD_CU__OVRRD_VALUE_MASK 0xffff0000
#define GC_CAC_OVRD_CU__OVRRD_VALUE__SHIFT 0x10

#endif /* SMU_8_0_SH_MASK_H */
