// SPDX-License-Identifier: GPL-2.0+
/* vim: set ts=8 sw=8 noet tw=80 nowrap: */
/*
 *  comedi/drivers/ni_routing/ni_device_routes/pci-6602.c
 *  List of valid routes for specific NI boards.
 *
 *  COMEDI - Linux Control and Measurement Device Interface
 *  Copyright (C) 2016 Spencer E. Olson <olsonse@umich.edu>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 */

/*
 * The contents of this file are generated using the tools in
 * comedi/drivers/ni_routing/tools
 *
 * Please use those tools to help maintain the contents of this file.
 */

#include "../ni_device_routes.h"
#include "all.h"

struct ni_device_routes ni_pci_6602_device_routes = {
	.device = "pci-6602",
	.routes = (struct ni_route_set[]){
		{
			.dest = NI_PFI(2),
			.src = (int[]){
				NI_80MHzTimebase,
				0, /* Termination */
			}
		},
		{
			.dest = NI_PFI(3),
			.src = (int[]){
				NI_100kHzTimebase,
				0, /* Termination */
			}
		},
		{
			.dest = NI_PFI(4),
			.src = (int[]){
				NI_20MHzTimebase,
				0, /* Termination */
			}
		},
		{
			.dest = NI_PFI(6),
			.src = (int[]){
				NI_80MHzTimebase,
				0, /* Termination */
			}
		},
		{
			.dest = NI_PFI(7),
			.src = (int[]){
				TRIGGER_LINE(7),
				0, /* Termination */
			}
		},
		{
			.dest = NI_PFI(8),
			.src = (int[]){
				NI_PFI(7),
				NI_PFI(15),
				NI_PFI(23),
				NI_PFI(31),
				NI_PFI(39),
				TRIGGER_LINE(0),
				TRIGGER_LINE(1),
				TRIGGER_LINE(2),
				TRIGGER_LINE(3),
				TRIGGER_LINE(4),
				TRIGGER_LINE(5),
				TRIGGER_LINE(6),
				TRIGGER_LINE(7),
				NI_CtrInternalOutput(0),
				NI_CtrInternalOutput(1),
				NI_CtrInternalOutput(2),
				NI_CtrInternalOutput(3),
				NI_CtrInternalOutput(4),
				NI_CtrInternalOutput(5),
				NI_CtrInternalOutput(6),
				NI_CtrInternalOutput(7),
				NI_LogicLow,
				NI_LogicHigh,
				0, /* Termination */
			}
		},
		{
			.dest = NI_PFI(9),
			.src = (int[]){
				NI_PFI(7),
				NI_PFI(15),
				NI_PFI(23),
				NI_PFI(31),
				NI_PFI(39),
				TRIGGER_LINE(0),
				TRIGGER_LINE(1),
				TRIGGER_LINE(2),
				TRIGGER_LINE(3),
				TRIGGER_LINE(4),
				TRIGGER_LINE(5),
				TRIGGER_LINE(6),
				TRIGGER_LINE(7),
				NI_CtrInternalOutput(0),
				NI_CtrInternalOutput(1),
				NI_CtrInternalOutput(2),
				NI_CtrInternalOutput(3),
				NI_CtrInternalOutput(4),
				NI_CtrInternalOutput(5),
				NI_CtrInternalOutput(6),
				NI_CtrInternalOutput(7),
				NI_LogicLow,
				NI_LogicHigh,
				0, /* Termination */
			}
		},
		{
			.dest = NI_PFI(10),
			.src = (int[]){
				NI_CtrGate(7),
				NI_LogicLow,
				0, /* Termination */
			}
		},
		{
			.dest = NI_PFI(11),
			.src = (int[]){
				NI_CtrSource(7),
				NI_LogicLow,
				0, /* Termination */
			}
		},
		{
			.dest = NI_PFI(12),
			.src = (int[]){
				NI_PFI(6),
				NI_PFI(14),
				NI_PFI(22),
				NI_PFI(30),
				NI_PFI(38),
				TRIGGER_LINE(0),
				TRIGGER_LINE(1),
				TRIGGER_LINE(2),
				TRIGGER_LINE(3),
				TRIGGER_LINE(4),
				TRIGGER_LINE(5),
				TRIGGER_LINE(6),
				TRIGGER_LINE(7),
				NI_CtrInternalOutput(0),
				NI_CtrInternalOutput(1),
				NI_CtrInternalOutput(2),
				NI_CtrInternalOutput(3),
				NI_CtrInternalOutput(4),
				NI_CtrInternalOutput(5),
				NI_CtrInternalOutput(6),
				NI_CtrInternalOutput(7),
				NI_LogicLow,
				NI_LogicHigh,
				0, /* Termination */
			}
		},
		{
			.dest = NI_PFI(13),
			.src = (int[]){
				NI_PFI(6),
				NI_PFI(14),
				NI_PFI(22),
				NI_PFI(30),
				NI_PFI(38),
				TRIGGER_LINE(0),
				TRIGGER_LINE(1),
				TRIGGER_LINE(2),
				TRIGGER_LINE(3),
				TRIGGER_LINE(4),
				TRIGGER_LINE(5),
				TRIGGER_LINE(6),
				TRIGGER_LINE(7),
				NI_CtrInternalOutput(0),
				NI_CtrInternalOutput(1),
				NI_CtrInternalOutput(2),
				NI_CtrInternalOutput(3),
				NI_CtrInternalOutput(4),
				NI_CtrInternalOutput(5),
				NI_CtrInternalOutput(6),
				NI_CtrInternalOutput(7),
				NI_LogicLow,
				NI_LogicHigh,
				0, /* Termination */
			}
		},
		{
			.dest = NI_PFI(14),
			.src = (int[]){
				NI_CtrGate(6),
				NI_LogicLow,
				0, /* Termination */
			}
		},
		{
			.dest = NI_PFI(15),
			.src = (int[]){
				NI_CtrSource(6),
				NI_LogicLow,
				0, /* Termination */
			}
		},
		{
			.dest = NI_PFI(16),
			.src = (int[]){
				NI_PFI(5),
				NI_PFI(13),
				NI_PFI(21),
				NI_PFI(29),
				NI_PFI(37),
				TRIGGER_LINE(0),
				TRIGGER_LINE(1),
				TRIGGER_LINE(2),
				TRIGGER_LINE(3),
				TRIGGER_LINE(4),
				TRIGGER_LINE(5),
				TRIGGER_LINE(6),
				TRIGGER_LINE(7),
				NI_CtrInternalOutput(0),
				NI_CtrInternalOutput(1),
				NI_CtrInternalOutput(2),
				NI_CtrInternalOutput(3),
				NI_CtrInternalOutput(4),
				NI_CtrInternalOutput(5),
				NI_CtrInternalOutput(6),
				NI_CtrInternalOutput(7),
				NI_LogicLow,
				NI_LogicHigh,
				0, /* Termination */
			}
		},
		{
			.dest = NI_PFI(17),
			.src = (int[]){
				NI_PFI(5),
				NI_PFI(13),
				NI_PFI(21),
				NI_PFI(29),
				NI_PFI(37),
				TRIGGER_LINE(0),
				TRIGGER_LINE(1),
				TRIGGER_LINE(2),
				TRIGGER_LINE(3),
				TRIGGER_LINE(4),
				TRIGGER_LINE(5),
				TRIGGER_LINE(6),
				TRIGGER_LINE(7),
				NI_CtrInternalOutput(0),
				NI_CtrInternalOutput(1),
				NI_CtrInternalOutput(2),
				NI_CtrInternalOutput(3),
				NI_CtrInternalOutput(4),
				NI_CtrInternalOutput(5),
				NI_CtrInternalOutput(6),
				NI_CtrInternalOutput(7),
				NI_LogicLow,
				NI_LogicHigh,
				0, /* Termination */
			}
		},
		{
			.dest = NI_PFI(18),
			.src = (int[]){
				NI_CtrGate(5),
				NI_LogicLow,
				0, /* Termination */
			}
		},
		{
			.dest = NI_PFI(19),
			.src = (int[]){
				NI_CtrSource(5),
				0, /* Termination */
			}
		},
		{
			.dest = NI_PFI(20),
			.src = (int[]){
				NI_PFI(4),
				NI_PFI(12),
				NI_PFI(28),
				NI_PFI(36),
				TRIGGER_LINE(0),
				TRIGGER_LINE(1),
				TRIGGER_LINE(2),
				TRIGGER_LINE(3),
				TRIGGER_LINE(4),
				TRIGGER_LINE(5),
				TRIGGER_LINE(6),
				TRIGGER_LINE(7),
				NI_CtrInternalOutput(0),
				NI_CtrInternalOutput(1),
				NI_CtrInternalOutput(2),
				NI_CtrInternalOutput(3),
				NI_CtrInternalOutput(4),
				NI_CtrInternalOutput(5),
				NI_CtrInternalOutput(6),
				NI_CtrInternalOutput(7),
				NI_LogicLow,
				NI_LogicHigh,
				0, /* Termination */
			}
		},
		{
			.dest = NI_PFI(21),
			.src = (int[]){
				NI_PFI(4),
				NI_PFI(12),
				NI_PFI(20),
				NI_PFI(28),
				NI_PFI(36),
				TRIGGER_LINE(0),
				TRIGGER_LINE(1),
				TRIGGER_LINE(2),
				TRIGGER_LINE(3),
				TRIGGER_LINE(4),
				TRIGGER_LINE(5),
				TRIGGER_LINE(6),
				TRIGGER_LINE(7),
				NI_CtrInternalOutput(0),
				NI_CtrInternalOutput(1),
				NI_CtrInternalOutput(2),
				NI_CtrInternalOutput(3),
				NI_CtrInternalOutput(4),
				NI_CtrInternalOutput(5),
				NI_CtrInternalOutput(6),
				NI_CtrInternalOutput(7),
				NI_LogicLow,
				NI_LogicHigh,
				0, /* Termination */
			}
		},
		{
			.dest = NI_PFI(22),
			.src = (int[]){
				NI_CtrGate(4),
				0, /* Termination */
			}
		},
		{
			.dest = NI_PFI(23),
			.src = (int[]){
				NI_CtrSource(4),
				NI_LogicLow,
				0, /* Termination */
			}
		},
		{
			.dest = NI_PFI(24),
			.src = (int[]){
				NI_PFI(3),
				NI_PFI(11),
				NI_PFI(19),
				NI_PFI(27),
				NI_PFI(35),
				TRIGGER_LINE(0),
				TRIGGER_LINE(1),
				TRIGGER_LINE(2),
				TRIGGER_LINE(3),
				TRIGGER_LINE(4),
				TRIGGER_LINE(5),
				TRIGGER_LINE(6),
				TRIGGER_LINE(7),
				NI_CtrSource(3),
				NI_CtrSource(7),
				NI_CtrGate(3),
				NI_CtrGate(7),
				NI_CtrInternalOutput(0),
				NI_CtrInternalOutput(1),
				NI_CtrInternalOutput(2),
				NI_CtrInternalOutput(3),
				NI_CtrInternalOutput(4),
				NI_CtrInternalOutput(5),
				NI_CtrInternalOutput(6),
				NI_CtrInternalOutput(7),
				NI_LogicLow,
				NI_LogicHigh,
				0, /* Termination */
			}
		},
		{
			.dest = NI_PFI(25),
			.src = (int[]){
				NI_PFI(3),
				NI_PFI(11),
				NI_PFI(19),
				NI_PFI(27),
				NI_PFI(35),
				TRIGGER_LINE(0),
				TRIGGER_LINE(1),
				TRIGGER_LINE(2),
				TRIGGER_LINE(3),
				TRIGGER_LINE(4),
				TRIGGER_LINE(5),
				TRIGGER_LINE(6),
				TRIGGER_LINE(7),
				NI_CtrSource(3),
				NI_CtrSource(7),
				NI_CtrGate(3),
				NI_CtrGate(7),
				NI_CtrInternalOutput(0),
				NI_CtrInternalOutput(1),
				NI_CtrInternalOutput(2),
				NI_CtrInternalOutput(3),
				NI_CtrInternalOutput(4),
				NI_CtrInternalOutput(5),
				NI_CtrInternalOutput(6),
				NI_CtrInternalOutput(7),
				NI_LogicLow,
				NI_LogicHigh,
				0, /* Termination */
			}
		},
		{
			.dest = NI_PFI(26),
			.src = (int[]){
				NI_CtrGate(3),
				0, /* Termination */
			}
		},
		{
			.dest = NI_PFI(27),
			.src = (int[]){
				NI_CtrSource(3),
				0, /* Termination */
			}
		},
		{
			.dest = NI_PFI(28),
			.src = (int[]){
				NI_PFI(2),
				NI_PFI(10),
				NI_PFI(18),
				NI_PFI(26),
				NI_PFI(34),
				TRIGGER_LINE(0),
				TRIGGER_LINE(1),
				TRIGGER_LINE(2),
				TRIGGER_LINE(3),
				TRIGGER_LINE(4),
				TRIGGER_LINE(5),
				TRIGGER_LINE(6),
				TRIGGER_LINE(7),
				NI_CtrSource(2),
				NI_CtrSource(6),
				NI_CtrGate(2),
				NI_CtrInternalOutput(0),
				NI_CtrInternalOutput(1),
				NI_CtrInternalOutput(2),
				NI_CtrInternalOutput(3),
				NI_CtrInternalOutput(4),
				NI_CtrInternalOutput(5),
				NI_CtrInternalOutput(6),
				NI_CtrInternalOutput(7),
				NI_LogicLow,
				NI_LogicHigh,
				0, /* Termination */
			}
		},
		{
			.dest = NI_PFI(29),
			.src = (int[]){
				NI_PFI(2),
				NI_PFI(10),
				NI_PFI(18),
				NI_PFI(26),
				NI_PFI(34),
				TRIGGER_LINE(0),
				TRIGGER_LINE(1),
				TRIGGER_LINE(2),
				TRIGGER_LINE(3),
				TRIGGER_LINE(4),
				TRIGGER_LINE(5),
				TRIGGER_LINE(6),
				TRIGGER_LINE(7),
				NI_CtrSource(2),
				NI_CtrSource(6),
				NI_CtrGate(2),
				NI_CtrInternalOutput(0),
				NI_CtrInternalOutput(1),
				NI_CtrInternalOutput(2),
				NI_CtrInternalOutput(3),
				NI_CtrInternalOutput(4),
				NI_CtrInternalOutput(5),
				NI_CtrInternalOutput(6),
				NI_CtrInternalOutput(7),
				NI_LogicLow,
				NI_LogicHigh,
				0, /* Termination */
			}
		},
		{
			.dest = NI_PFI(30),
			.src = (int[]){
				NI_CtrGate(2),
				0, /* Termination */
			}
		},
		{
			.dest = NI_PFI(31),
			.src = (int[]){
				NI_CtrSource(2),
				0, /* Termination */
			}
		},
		{
			.dest = NI_PFI(32),
			.src = (int[]){
				NI_PFI(1),
				NI_PFI(9),
				NI_PFI(17),
				NI_PFI(25),
				NI_PFI(33),
				TRIGGER_LINE(0),
				TRIGGER_LINE(1),
				TRIGGER_LINE(2),
				TRIGGER_LINE(3),
				TRIGGER_LINE(4),
				TRIGGER_LINE(5),
				TRIGGER_LINE(6),
				TRIGGER_LINE(7),
				NI_CtrSource(1),
				NI_CtrSource(5),
				NI_CtrGate(1),
				NI_CtrInternalOutput(0),
				NI_CtrInternalOutput(1),
				NI_CtrInternalOutput(2),
				NI_CtrInternalOutput(3),
				NI_CtrInternalOutput(4),
				NI_CtrInternalOutput(5),
				NI_CtrInternalOutput(6),
				NI_CtrInternalOutput(7),
				NI_LogicLow,
				NI_LogicHigh,
				0, /* Termination */
			}
		},
		{
			.dest = NI_PFI(33),
			.src = (int[]){
				NI_PFI(1),
				NI_PFI(9),
				NI_PFI(17),
				NI_PFI(25),
				TRIGGER_LINE(0),
				TRIGGER_LINE(1),
				TRIGGER_LINE(2),
				TRIGGER_LINE(3),
				TRIGGER_LINE(4),
				TRIGGER_LINE(5),
				TRIGGER_LINE(6),
				TRIGGER_LINE(7),
				NI_CtrSource(1),
				NI_CtrSource(5),
				NI_CtrGate(1),
				NI_CtrInternalOutput(0),
				NI_CtrInternalOutput(1),
				NI_CtrInternalOutput(2),
				NI_CtrInternalOutput(3),
				NI_CtrInternalOutput(4),
				NI_CtrInternalOutput(5),
				NI_CtrInternalOutput(6),
				NI_CtrInternalOutput(7),
				NI_LogicLow,
				NI_LogicHigh,
				0, /* Termination */
			}
		},
		{
			.dest = NI_PFI(34),
			.src = (int[]){
				NI_CtrGate(1),
				0, /* Termination */
			}
		},
		{
			.dest = NI_PFI(35),
			.src = (int[]){
				NI_CtrSource(1),
				0, /* Termination */
			}
		},
		{
			.dest = NI_PFI(36),
			.src = (int[]){
				NI_PFI(0),
				NI_PFI(1),
				NI_PFI(2),
				NI_PFI(3),
				NI_PFI(4),
				NI_PFI(5),
				NI_PFI(6),
				NI_PFI(7),
				NI_PFI(8),
				NI_PFI(9),
				NI_PFI(10),
				NI_PFI(11),
				NI_PFI(12),
				NI_PFI(13),
				NI_PFI(14),
				NI_PFI(15),
				NI_PFI(16),
				NI_PFI(17),
				NI_PFI(18),
				NI_PFI(19),
				NI_PFI(20),
				NI_PFI(21),
				NI_PFI(22),
				NI_PFI(23),
				NI_PFI(24),
				NI_PFI(25),
				NI_PFI(26),
				NI_PFI(27),
				NI_PFI(28),
				NI_PFI(29),
				NI_PFI(30),
				NI_PFI(31),
				NI_PFI(32),
				NI_PFI(33),
				NI_PFI(34),
				NI_PFI(35),
				NI_PFI(37),
				NI_PFI(38),
				NI_PFI(39),
				TRIGGER_LINE(0),
				TRIGGER_LINE(1),
				TRIGGER_LINE(2),
				TRIGGER_LINE(3),
				TRIGGER_LINE(4),
				TRIGGER_LINE(5),
				TRIGGER_LINE(6),
				TRIGGER_LINE(7),
				NI_CtrSource(0),
				NI_CtrSource(5),
				NI_CtrGate(0),
				NI_CtrInternalOutput(0),
				NI_CtrInternalOutput(1),
				NI_CtrInternalOutput(2),
				NI_CtrInternalOutput(3),
				NI_CtrInternalOutput(4),
				NI_CtrInternalOutput(5),
				NI_CtrInternalOutput(6),
				NI_CtrInternalOutput(7),
				NI_LogicLow,
				NI_LogicHigh,
				0, /* Termination */
			}
		},
		{
			.dest = NI_PFI(37),
			.src = (int[]){
				NI_PFI(0),
				NI_PFI(1),
				NI_PFI(2),
				NI_PFI(3),
				NI_PFI(4),
				NI_PFI(5),
				NI_PFI(6),
				NI_PFI(7),
				NI_PFI(8),
				NI_PFI(9),
				NI_PFI(10),
				NI_PFI(11),
				NI_PFI(12),
				NI_PFI(13),
				NI_PFI(14),
				NI_PFI(15),
				NI_PFI(16),
				NI_PFI(17),
				NI_PFI(18),
				NI_PFI(19),
				NI_PFI(20),
				NI_PFI(21),
				NI_PFI(22),
				NI_PFI(23),
				NI_PFI(24),
				NI_PFI(25),
				NI_PFI(26),
				NI_PFI(27),
				NI_PFI(28),
				NI_PFI(29),
				NI_PFI(30),
				NI_PFI(31),
				NI_PFI(32),
				NI_PFI(33),
				NI_PFI(34),
				NI_PFI(35),
				NI_PFI(36),
				NI_PFI(38),
				NI_PFI(39),
				TRIGGER_LINE(0),
				TRIGGER_LINE(1),
				TRIGGER_LINE(2),
				TRIGGER_LINE(3),
				TRIGGER_LINE(4),
				TRIGGER_LINE(5),
				TRIGGER_LINE(6),
				TRIGGER_LINE(7),
				NI_CtrSource(0),
				NI_CtrSource(5),
				NI_CtrGate(0),
				NI_CtrInternalOutput(0),
				NI_CtrInternalOutput(1),
				NI_CtrInternalOutput(2),
				NI_CtrInternalOutput(3),
				NI_CtrInternalOutput(4),
				NI_CtrInternalOutput(5),
				NI_CtrInternalOutput(6),
				NI_CtrInternalOutput(7),
				NI_LogicLow,
				NI_LogicHigh,
				0, /* Termination */
			}
		},
		{
			.dest = NI_PFI(38),
			.src = (int[]){
				NI_CtrGate(0),
				0, /* Termination */
			}
		},
		{
			.dest = NI_PFI(39),
			.src = (int[]){
				NI_CtrSource(0),
				0, /* Termination */
			}
		},
		{
			.dest = TRIGGER_LINE(0),
			.src = (int[]){
				NI_PFI(0),
				NI_PFI(1),
				NI_PFI(2),
				NI_PFI(3),
				NI_PFI(4),
				NI_PFI(5),
				NI_PFI(6),
				NI_PFI(7),
				NI_PFI(8),
				NI_PFI(9),
				NI_PFI(10),
				NI_PFI(11),
				NI_PFI(12),
				NI_PFI(13),
				NI_PFI(14),
				NI_PFI(15),
				NI_PFI(16),
				NI_PFI(17),
				NI_PFI(18),
				NI_PFI(19),
				NI_PFI(20),
				NI_PFI(21),
				NI_PFI(22),
				NI_PFI(23),
				NI_PFI(24),
				NI_PFI(25),
				NI_PFI(26),
				NI_PFI(27),
				NI_PFI(28),
				NI_PFI(29),
				NI_PFI(30),
				NI_PFI(31),
				NI_PFI(32),
				NI_PFI(33),
				NI_PFI(34),
				NI_PFI(35),
				NI_PFI(36),
				NI_PFI(37),
				NI_PFI(38),
				NI_PFI(39),
				NI_CtrSource(0),
				NI_CtrSource(1),
				NI_CtrSource(2),
				NI_CtrSource(3),
				NI_CtrSource(4),
				NI_CtrSource(5),
				NI_CtrSource(6),
				NI_CtrSource(7),
				NI_CtrGate(0),
				NI_CtrGate(1),
				NI_CtrGate(2),
				NI_CtrGate(3),
				NI_CtrGate(4),
				NI_CtrGate(5),
				NI_CtrGate(6),
				NI_CtrGate(7),
				NI_CtrInternalOutput(0),
				NI_CtrInternalOutput(1),
				NI_CtrInternalOutput(2),
				NI_CtrInternalOutput(3),
				NI_CtrInternalOutput(4),
				NI_CtrInternalOutput(5),
				NI_CtrInternalOutput(6),
				NI_CtrInternalOutput(7),
				NI_LogicLow,
				NI_LogicHigh,
				0, /* Termination */
			}
		},
		{
			.dest = TRIGGER_LINE(1),
			.src = (int[]){
				NI_PFI(0),
				NI_PFI(1),
				NI_PFI(2),
				NI_PFI(3),
				NI_PFI(4),
				NI_PFI(5),
				NI_PFI(6),
				NI_PFI(7),
				NI_PFI(8),
				NI_PFI(9),
				NI_PFI(10),
				NI_PFI(11),
				NI_PFI(12),
				NI_PFI(13),
				NI_PFI(14),
				NI_PFI(15),
				NI_PFI(16),
				NI_PFI(17),
				NI_PFI(18),
				NI_PFI(19),
				NI_PFI(20),
				NI_PFI(21),
				NI_PFI(22),
				NI_PFI(23),
				NI_PFI(24),
				NI_PFI(25),
				NI_PFI(26),
				NI_PFI(27),
				NI_PFI(28),
				NI_PFI(29),
				NI_PFI(30),
				NI_PFI(31),
				NI_PFI(32),
				NI_PFI(33),
				NI_PFI(34),
				NI_PFI(35),
				NI_PFI(36),
				NI_PFI(37),
				NI_PFI(38),
				NI_PFI(39),
				NI_CtrSource(0),
				NI_CtrSource(1),
				NI_CtrSource(2),
				NI_CtrSource(3),
				NI_CtrSource(4),
				NI_CtrSource(5),
				NI_CtrSource(6),
				NI_CtrSource(7),
				NI_CtrGate(0),
				NI_CtrGate(1),
				NI_CtrGate(2),
				NI_CtrGate(3),
				NI_CtrGate(4),
				NI_CtrGate(5),
				NI_CtrGate(6),
				NI_CtrGate(7),
				NI_CtrInternalOutput(0),
				NI_CtrInternalOutput(1),
				NI_CtrInternalOutput(2),
				NI_CtrInternalOutput(3),
				NI_CtrInternalOutput(4),
				NI_CtrInternalOutput(5),
				NI_CtrInternalOutput(6),
				NI_CtrInternalOutput(7),
				NI_LogicLow,
				NI_LogicHigh,
				0, /* Termination */
			}
		},
		{
			.dest = TRIGGER_LINE(2),
			.src = (int[]){
				NI_PFI(0),
				NI_PFI(1),
				NI_PFI(2),
				NI_PFI(3),
				NI_PFI(4),
				NI_PFI(5),
				NI_PFI(6),
				NI_PFI(7),
				NI_PFI(8),
				NI_PFI(9),
				NI_PFI(10),
				NI_PFI(11),
				NI_PFI(12),
				NI_PFI(13),
				NI_PFI(14),
				NI_PFI(15),
				NI_PFI(16),
				NI_PFI(17),
				NI_PFI(18),
				NI_PFI(19),
				NI_PFI(20),
				NI_PFI(21),
				NI_PFI(22),
				NI_PFI(23),
				NI_PFI(24),
				NI_PFI(25),
				NI_PFI(26),
				NI_PFI(27),
				NI_PFI(28),
				NI_PFI(29),
				NI_PFI(30),
				NI_PFI(31),
				NI_PFI(32),
				NI_PFI(33),
				NI_PFI(34),
				NI_PFI(35),
				NI_PFI(36),
				NI_PFI(37),
				NI_PFI(38),
				NI_PFI(39),
				NI_CtrSource(0),
				NI_CtrSource(1),
				NI_CtrSource(2),
				NI_CtrSource(3),
				NI_CtrSource(4),
				NI_CtrSource(5),
				NI_CtrSource(6),
				NI_CtrSource(7),
				NI_CtrGate(0),
				NI_CtrGate(1),
				NI_CtrGate(2),
				NI_CtrGate(3),
				NI_CtrGate(4),
				NI_CtrGate(5),
				NI_CtrGate(6),
				NI_CtrGate(7),
				NI_CtrInternalOutput(0),
				NI_CtrInternalOutput(1),
				NI_CtrInternalOutput(2),
				NI_CtrInternalOutput(3),
				NI_CtrInternalOutput(4),
				NI_CtrInternalOutput(5),
				NI_CtrInternalOutput(6),
				NI_CtrInternalOutput(7),
				NI_LogicLow,
				NI_LogicHigh,
				0, /* Termination */
			}
		},
		{
			.dest = TRIGGER_LINE(3),
			.src = (int[]){
				NI_PFI(0),
				NI_PFI(1),
				NI_PFI(2),
				NI_PFI(3),
				NI_PFI(4),
				NI_PFI(5),
				NI_PFI(6),
				NI_PFI(7),
				NI_PFI(8),
				NI_PFI(9),
				NI_PFI(10),
				NI_PFI(11),
				NI_PFI(12),
				NI_PFI(13),
				NI_PFI(14),
				NI_PFI(15),
				NI_PFI(16),
				NI_PFI(17),
				NI_PFI(18),
				NI_PFI(19),
				NI_PFI(20),
				NI_PFI(21),
				NI_PFI(22),
				NI_PFI(23),
				NI_PFI(24),
				NI_PFI(25),
				NI_PFI(26),
				NI_PFI(27),
				NI_PFI(28),
				NI_PFI(29),
				NI_PFI(30),
				NI_PFI(31),
				NI_PFI(32),
				NI_PFI(33),
				NI_PFI(34),
				NI_PFI(35),
				NI_PFI(36),
				NI_PFI(37),
				NI_PFI(38),
				NI_PFI(39),
				NI_CtrSource(0),
				NI_CtrSource(1),
				NI_CtrSource(2),
				NI_CtrSource(3),
				NI_CtrSource(4),
				NI_CtrSource(5),
				NI_CtrSource(6),
				NI_CtrSource(7),
				NI_CtrGate(0),
				NI_CtrGate(1),
				NI_CtrGate(2),
				NI_CtrGate(3),
				NI_CtrGate(4),
				NI_CtrGate(5),
				NI_CtrGate(6),
				NI_CtrGate(7),
				NI_CtrInternalOutput(0),
				NI_CtrInternalOutput(1),
				NI_CtrInternalOutput(2),
				NI_CtrInternalOutput(3),
				NI_CtrInternalOutput(4),
				NI_CtrInternalOutput(5),
				NI_CtrInternalOutput(6),
				NI_CtrInternalOutput(7),
				NI_LogicLow,
				NI_LogicHigh,
				0, /* Termination */
			}
		},
		{
			.dest = TRIGGER_LINE(4),
			.src = (int[]){
				NI_PFI(0),
				NI_PFI(1),
				NI_PFI(2),
				NI_PFI(3),
				NI_PFI(4),
				NI_PFI(5),
				NI_PFI(6),
				NI_PFI(7),
				NI_PFI(8),
				NI_PFI(9),
				NI_PFI(10),
				NI_PFI(11),
				NI_PFI(12),
				NI_PFI(13),
				NI_PFI(14),
				NI_PFI(15),
				NI_PFI(16),
				NI_PFI(17),
				NI_PFI(18),
				NI_PFI(19),
				NI_PFI(20),
				NI_PFI(21),
				NI_PFI(22),
				NI_PFI(23),
				NI_PFI(24),
				NI_PFI(25),
				NI_PFI(26),
				NI_PFI(27),
				NI_PFI(28),
				NI_PFI(29),
				NI_PFI(30),
				NI_PFI(31),
				NI_PFI(32),
				NI_PFI(33),
				NI_PFI(34),
				NI_PFI(35),
				NI_PFI(36),
				NI_PFI(37),
				NI_PFI(38),
				NI_PFI(39),
				NI_CtrSource(0),
				NI_CtrSource(1),
				NI_CtrSource(2),
				NI_CtrSource(3),
				NI_CtrSource(4),
				NI_CtrSource(5),
				NI_CtrSource(6),
				NI_CtrSource(7),
				NI_CtrGate(0),
				NI_CtrGate(1),
				NI_CtrGate(2),
				NI_CtrGate(3),
				NI_CtrGate(4),
				NI_CtrGate(5),
				NI_CtrGate(6),
				NI_CtrGate(7),
				NI_CtrInternalOutput(0),
				NI_CtrInternalOutput(1),
				NI_CtrInternalOutput(2),
				NI_CtrInternalOutput(3),
				NI_CtrInternalOutput(4),
				NI_CtrInternalOutput(5),
				NI_CtrInternalOutput(6),
				NI_CtrInternalOutput(7),
				NI_LogicLow,
				NI_LogicHigh,
				0, /* Termination */
			}
		},
		{
			.dest = TRIGGER_LINE(5),
			.src = (int[]){
				NI_PFI(0),
				NI_PFI(1),
				NI_PFI(2),
				NI_PFI(3),
				NI_PFI(4),
				NI_PFI(5),
				NI_PFI(6),
				NI_PFI(7),
				NI_PFI(8),
				NI_PFI(9),
				NI_PFI(10),
				NI_PFI(11),
				NI_PFI(12),
				NI_PFI(13),
				NI_PFI(14),
				NI_PFI(15),
				NI_PFI(16),
				NI_PFI(17),
				NI_PFI(18),
				NI_PFI(19),
				NI_PFI(20),
				NI_PFI(21),
				NI_PFI(22),
				NI_PFI(23),
				NI_PFI(24),
				NI_PFI(25),
				NI_PFI(26),
				NI_PFI(27),
				NI_PFI(28),
				NI_PFI(29),
				NI_PFI(30),
				NI_PFI(31),
				NI_PFI(32),
				NI_PFI(33),
				NI_PFI(34),
				NI_PFI(35),
				NI_PFI(36),
				NI_PFI(37),
				NI_PFI(38),
				NI_PFI(39),
				NI_CtrSource(0),
				NI_CtrSource(1),
				NI_CtrSource(2),
				NI_CtrSource(3),
				NI_CtrSource(4),
				NI_CtrSource(5),
				NI_CtrSource(6),
				NI_CtrSource(7),
				NI_CtrGate(0),
				NI_CtrGate(1),
				NI_CtrGate(2),
				NI_CtrGate(3),
				NI_CtrGate(4),
				NI_CtrGate(5),
				NI_CtrGate(6),
				NI_CtrGate(7),
				NI_CtrInternalOutput(0),
				NI_CtrInternalOutput(1),
				NI_CtrInternalOutput(2),
				NI_CtrInternalOutput(3),
				NI_CtrInternalOutput(4),
				NI_CtrInternalOutput(5),
				NI_CtrInternalOutput(6),
				NI_CtrInternalOutput(7),
				NI_LogicLow,
				NI_LogicHigh,
				0, /* Termination */
			}
		},
		{
			.dest = TRIGGER_LINE(6),
			.src = (int[]){
				NI_PFI(0),
				NI_PFI(1),
				NI_PFI(2),
				NI_PFI(3),
				NI_PFI(4),
				NI_PFI(5),
				NI_PFI(6),
				NI_PFI(7),
				NI_PFI(8),
				NI_PFI(9),
				NI_PFI(10),
				NI_PFI(11),
				NI_PFI(12),
				NI_PFI(13),
				NI_PFI(14),
				NI_PFI(15),
				NI_PFI(16),
				NI_PFI(17),
				NI_PFI(18),
				NI_PFI(19),
				NI_PFI(20),
				NI_PFI(21),
				NI_PFI(22),
				NI_PFI(23),
				NI_PFI(24),
				NI_PFI(25),
				NI_PFI(26),
				NI_PFI(27),
				NI_PFI(28),
				NI_PFI(29),
				NI_PFI(30),
				NI_PFI(31),
				NI_PFI(32),
				NI_PFI(33),
				NI_PFI(34),
				NI_PFI(35),
				NI_PFI(36),
				NI_PFI(37),
				NI_PFI(38),
				NI_PFI(39),
				NI_CtrSource(0),
				NI_CtrSource(1),
				NI_CtrSource(2),
				NI_CtrSource(3),
				NI_CtrSource(4),
				NI_CtrSource(5),
				NI_CtrSource(6),
				NI_CtrSource(7),
				NI_CtrGate(0),
				NI_CtrGate(1),
				NI_CtrGate(2),
				NI_CtrGate(3),
				NI_CtrGate(4),
				NI_CtrGate(5),
				NI_CtrGate(6),
				NI_CtrGate(7),
				NI_CtrInternalOutput(0),
				NI_CtrInternalOutput(1),
				NI_CtrInternalOutput(2),
				NI_CtrInternalOutput(3),
				NI_CtrInternalOutput(4),
				NI_CtrInternalOutput(5),
				NI_CtrInternalOutput(6),
				NI_CtrInternalOutput(7),
				NI_LogicLow,
				NI_LogicHigh,
				0, /* Termination */
			}
		},
		{
			.dest = TRIGGER_LINE(7),
			.src = (int[]){
				NI_20MHzTimebase,
				0, /* Termination */
			}
		},
		{
			.dest = NI_CtrSource(0),
			.src = (int[]){
				NI_PFI(0),
				NI_PFI(1),
				NI_PFI(2),
				NI_PFI(3),
				NI_PFI(4),
				NI_PFI(5),
				NI_PFI(6),
				NI_PFI(7),
				NI_PFI(8),
				NI_PFI(9),
				NI_PFI(10),
				NI_PFI(11),
				NI_PFI(12),
				NI_PFI(13),
				NI_PFI(14),
				NI_PFI(15),
				NI_PFI(16),
				NI_PFI(17),
				NI_PFI(18),
				NI_PFI(19),
				NI_PFI(20),
				NI_PFI(21),
				NI_PFI(22),
				NI_PFI(23),
				NI_PFI(24),
				NI_PFI(25),
				NI_PFI(26),
				NI_PFI(27),
				NI_PFI(28),
				NI_PFI(29),
				NI_PFI(30),
				NI_PFI(31),
				NI_PFI(32),
				NI_PFI(33),
				NI_PFI(34),
				NI_PFI(35),
				NI_PFI(36),
				NI_PFI(37),
				NI_PFI(38),
				NI_PFI(39),
				TRIGGER_LINE(0),
				TRIGGER_LINE(1),
				TRIGGER_LINE(2),
				TRIGGER_LINE(3),
				TRIGGER_LINE(4),
				TRIGGER_LINE(5),
				TRIGGER_LINE(6),
				TRIGGER_LINE(7),
				NI_CtrSource(1),
				NI_CtrSource(2),
				NI_CtrSource(3),
				NI_CtrGate(1),
				NI_CtrGate(2),
				NI_CtrGate(3),
				NI_CtrInternalOutput(1),
				NI_CtrInternalOutput(2),
				NI_CtrInternalOutput(3),
				NI_20MHzTimebase,
				NI_80MHzTimebase,
				NI_100kHzTimebase,
				NI_LogicLow,
				NI_LogicHigh,
				0, /* Termination */
			}
		},
		{
			.dest = NI_CtrSource(1),
			.src = (int[]){
				NI_PFI(0),
				NI_PFI(1),
				NI_PFI(2),
				NI_PFI(3),
				NI_PFI(4),
				NI_PFI(5),
				NI_PFI(6),
				NI_PFI(7),
				NI_PFI(8),
				NI_PFI(9),
				NI_PFI(10),
				NI_PFI(11),
				NI_PFI(12),
				NI_PFI(13),
				NI_PFI(14),
				NI_PFI(15),
				NI_PFI(16),
				NI_PFI(17),
				NI_PFI(18),
				NI_PFI(19),
				NI_PFI(20),
				NI_PFI(21),
				NI_PFI(22),
				NI_PFI(23),
				NI_PFI(24),
				NI_PFI(25),
				NI_PFI(26),
				NI_PFI(27),
				NI_PFI(28),
				NI_PFI(29),
				NI_PFI(30),
				NI_PFI(31),
				NI_PFI(32),
				NI_PFI(33),
				NI_PFI(34),
				NI_PFI(35),
				NI_PFI(36),
				NI_PFI(37),
				NI_PFI(38),
				NI_PFI(39),
				TRIGGER_LINE(0),
				TRIGGER_LINE(1),
				TRIGGER_LINE(2),
				TRIGGER_LINE(3),
				TRIGGER_LINE(4),
				TRIGGER_LINE(5),
				TRIGGER_LINE(6),
				TRIGGER_LINE(7),
				NI_CtrSource(0),
				NI_CtrSource(2),
				NI_CtrSource(3),
				NI_CtrGate(0),
				NI_CtrGate(2),
				NI_CtrGate(3),
				NI_CtrInternalOutput(0),
				NI_CtrInternalOutput(2),
				NI_CtrInternalOutput(3),
				NI_20MHzTimebase,
				NI_80MHzTimebase,
				NI_100kHzTimebase,
				NI_LogicLow,
				NI_LogicHigh,
				0, /* Termination */
			}
		},
		{
			.dest = NI_CtrSource(2),
			.src = (int[]){
				NI_PFI(0),
				NI_PFI(1),
				NI_PFI(2),
				NI_PFI(3),
				NI_PFI(4),
				NI_PFI(5),
				NI_PFI(6),
				NI_PFI(7),
				NI_PFI(8),
				NI_PFI(9),
				NI_PFI(10),
				NI_PFI(11),
				NI_PFI(12),
				NI_PFI(13),
				NI_PFI(14),
				NI_PFI(15),
				NI_PFI(16),
				NI_PFI(17),
				NI_PFI(18),
				NI_PFI(19),
				NI_PFI(20),
				NI_PFI(21),
				NI_PFI(22),
				NI_PFI(23),
				NI_PFI(24),
				NI_PFI(25),
				NI_PFI(26),
				NI_PFI(27),
				NI_PFI(28),
				NI_PFI(29),
				NI_PFI(30),
				NI_PFI(31),
				NI_PFI(32),
				NI_PFI(33),
				NI_PFI(34),
				NI_PFI(35),
				NI_PFI(36),
				NI_PFI(37),
				NI_PFI(38),
				NI_PFI(39),
				TRIGGER_LINE(0),
				TRIGGER_LINE(1),
				TRIGGER_LINE(2),
				TRIGGER_LINE(3),
				TRIGGER_LINE(4),
				TRIGGER_LINE(5),
				TRIGGER_LINE(6),
				TRIGGER_LINE(7),
				NI_CtrSource(0),
				NI_CtrSource(1),
				NI_CtrSource(3),
				NI_CtrGate(0),
				NI_CtrGate(1),
				NI_CtrGate(3),
				NI_CtrInternalOutput(0),
				NI_CtrInternalOutput(1),
				NI_CtrInternalOutput(3),
				NI_20MHzTimebase,
				NI_80MHzTimebase,
				NI_100kHzTimebase,
				NI_LogicLow,
				NI_LogicHigh,
				0, /* Termination */
			}
		},
		{
			.dest = NI_CtrSource(3),
			.src = (int[]){
				NI_PFI(0),
				NI_PFI(1),
				NI_PFI(2),
				NI_PFI(3),
				NI_PFI(4),
				NI_PFI(5),
				NI_PFI(6),
				NI_PFI(7),
				NI_PFI(8),
				NI_PFI(9),
				NI_PFI(10),
				NI_PFI(11),
				NI_PFI(12),
				NI_PFI(13),
				NI_PFI(14),
				NI_PFI(15),
				NI_PFI(16),
				NI_PFI(17),
				NI_PFI(18),
				NI_PFI(19),
				NI_PFI(20),
				NI_PFI(21),
				NI_PFI(22),
				NI_PFI(23),
				NI_PFI(24),
				NI_PFI(25),
				NI_PFI(26),
				NI_PFI(27),
				NI_PFI(28),
				NI_PFI(29),
				NI_PFI(30),
				NI_PFI(31),
				NI_PFI(32),
				NI_PFI(33),
				NI_PFI(34),
				NI_PFI(35),
				NI_PFI(36),
				NI_PFI(37),
				NI_PFI(38),
				NI_PFI(39),
				TRIGGER_LINE(0),
				TRIGGER_LINE(1),
				TRIGGER_LINE(2),
				TRIGGER_LINE(3),
				TRIGGER_LINE(4),
				TRIGGER_LINE(5),
				TRIGGER_LINE(6),
				TRIGGER_LINE(7),
				NI_CtrSource(0),
				NI_CtrSource(1),
				NI_CtrSource(2),
				NI_CtrGate(0),
				NI_CtrGate(1),
				NI_CtrGate(2),
				NI_CtrInternalOutput(0),
				NI_CtrInternalOutput(1),
				NI_CtrInternalOutput(2),
				NI_20MHzTimebase,
				NI_80MHzTimebase,
				NI_100kHzTimebase,
				NI_LogicLow,
				NI_LogicHigh,
				0, /* Termination */
			}
		},
		{
			.dest = NI_CtrSource(4),
			.src = (int[]){
				NI_PFI(0),
				NI_PFI(1),
				NI_PFI(2),
				NI_PFI(3),
				NI_PFI(4),
				NI_PFI(5),
				NI_PFI(6),
				NI_PFI(7),
				NI_PFI(8),
				NI_PFI(9),
				NI_PFI(10),
				NI_PFI(11),
				NI_PFI(12),
				NI_PFI(13),
				NI_PFI(14),
				NI_PFI(15),
				NI_PFI(16),
				NI_PFI(17),
				NI_PFI(18),
				NI_PFI(19),
				NI_PFI(20),
				NI_PFI(21),
				NI_PFI(22),
				NI_PFI(23),
				NI_PFI(24),
				NI_PFI(25),
				NI_PFI(26),
				NI_PFI(27),
				NI_PFI(28),
				NI_PFI(29),
				NI_PFI(30),
				NI_PFI(31),
				NI_PFI(32),
				NI_PFI(33),
				NI_PFI(34),
				NI_PFI(35),
				NI_PFI(36),
				NI_PFI(37),
				NI_PFI(38),
				NI_PFI(39),
				TRIGGER_LINE(0),
				TRIGGER_LINE(1),
				TRIGGER_LINE(2),
				TRIGGER_LINE(3),
				TRIGGER_LINE(4),
				TRIGGER_LINE(5),
				TRIGGER_LINE(6),
				TRIGGER_LINE(7),
				NI_CtrSource(5),
				NI_CtrSource(6),
				NI_CtrSource(7),
				NI_CtrGate(5),
				NI_CtrGate(6),
				NI_CtrGate(7),
				NI_CtrInternalOutput(5),
				NI_CtrInternalOutput(6),
				NI_CtrInternalOutput(7),
				NI_20MHzTimebase,
				NI_80MHzTimebase,
				NI_100kHzTimebase,
				NI_LogicLow,
				NI_LogicHigh,
				0, /* Termination */
			}
		},
		{
			.dest = NI_CtrSource(5),
			.src = (int[]){
				NI_PFI(0),
				NI_PFI(1),
				NI_PFI(2),
				NI_PFI(3),
				NI_PFI(4),
				NI_PFI(5),
				NI_PFI(6),
				NI_PFI(7),
				NI_PFI(8),
				NI_PFI(9),
				NI_PFI(10),
				NI_PFI(11),
				NI_PFI(12),
				NI_PFI(13),
				NI_PFI(14),
				NI_PFI(15),
				NI_PFI(16),
				NI_PFI(17),
				NI_PFI(18),
				NI_PFI(19),
				NI_PFI(20),
				NI_PFI(21),
				NI_PFI(22),
				NI_PFI(23),
				NI_PFI(24),
				NI_PFI(25),
				NI_PFI(26),
				NI_PFI(27),
				NI_PFI(28),
				NI_PFI(29),
				NI_PFI(30),
				NI_PFI(31),
				NI_PFI(32),
				NI_PFI(33),
				NI_PFI(34),
				NI_PFI(35),
				NI_PFI(36),
				NI_PFI(37),
				NI_PFI(38),
				NI_PFI(39),
				TRIGGER_LINE(0),
				TRIGGER_LINE(1),
				TRIGGER_LINE(2),
				TRIGGER_LINE(3),
				TRIGGER_LINE(4),
				TRIGGER_LINE(5),
				TRIGGER_LINE(6),
				TRIGGER_LINE(7),
				NI_CtrSource(4),
				NI_CtrSource(6),
				NI_CtrSource(7),
				NI_CtrGate(4),
				NI_CtrGate(6),
				NI_CtrGate(7),
				NI_CtrInternalOutput(4),
				NI_CtrInternalOutput(6),
				NI_CtrInternalOutput(7),
				NI_20MHzTimebase,
				NI_80MHzTimebase,
				NI_100kHzTimebase,
				NI_LogicLow,
				NI_LogicHigh,
				0, /* Termination */
			}
		},
		{
			.dest = NI_CtrSource(6),
			.src = (int[]){
				NI_PFI(0),
				NI_PFI(1),
				NI_PFI(2),
				NI_PFI(3),
				NI_PFI(4),
				NI_PFI(5),
				NI_PFI(6),
				NI_PFI(7),
				NI_PFI(8),
				NI_PFI(9),
				NI_PFI(10),
				NI_PFI(11),
				NI_PFI(12),
				NI_PFI(13),
				NI_PFI(14),
				NI_PFI(15),
				NI_PFI(16),
				NI_PFI(17),
				NI_PFI(18),
				NI_PFI(19),
				NI_PFI(20),
				NI_PFI(21),
				NI_PFI(22),
				NI_PFI(23),
				NI_PFI(24),
				NI_PFI(25),
				NI_PFI(26),
				NI_PFI(27),
				NI_PFI(28),
				NI_PFI(29),
				NI_PFI(30),
				NI_PFI(31),
				NI_PFI(32),
				NI_PFI(33),
				NI_PFI(34),
				NI_PFI(35),
				NI_PFI(36),
				NI_PFI(37),
				NI_PFI(38),
				NI_PFI(39),
				TRIGGER_LINE(0),
				TRIGGER_LINE(1),
				TRIGGER_LINE(2),
				TRIGGER_LINE(3),
				TRIGGER_LINE(4),
				TRIGGER_LINE(5),
				TRIGGER_LINE(6),
				TRIGGER_LINE(7),
				NI_CtrSource(4),
				NI_CtrSource(5),
				NI_CtrSource(7),
				NI_CtrGate(4),
				NI_CtrGate(5),
				NI_CtrGate(7),
				NI_CtrInternalOutput(4),
				NI_CtrInternalOutput(5),
				NI_CtrInternalOutput(7),
				NI_20MHzTimebase,
				NI_80MHzTimebase,
				NI_100kHzTimebase,
				NI_LogicLow,
				NI_LogicHigh,
				0, /* Termination */
			}
		},
		{
			.dest = NI_CtrSource(7),
			.src = (int[]){
				NI_PFI(0),
				NI_PFI(1),
				NI_PFI(2),
				NI_PFI(3),
				NI_PFI(4),
				NI_PFI(5),
				NI_PFI(6),
				NI_PFI(7),
				NI_PFI(8),
				NI_PFI(9),
				NI_PFI(10),
				NI_PFI(11),
				NI_PFI(12),
				NI_PFI(13),
				NI_PFI(14),
				NI_PFI(15),
				NI_PFI(16),
				NI_PFI(17),
				NI_PFI(18),
				NI_PFI(19),
				NI_PFI(20),
				NI_PFI(21),
				NI_PFI(22),
				NI_PFI(23),
				NI_PFI(24),
				NI_PFI(25),
				NI_PFI(26),
				NI_PFI(27),
				NI_PFI(28),
				NI_PFI(29),
				NI_PFI(30),
				NI_PFI(31),
				NI_PFI(32),
				NI_PFI(33),
				NI_PFI(34),
				NI_PFI(35),
				NI_PFI(36),
				NI_PFI(37),
				NI_PFI(38),
				NI_PFI(39),
				TRIGGER_LINE(0),
				TRIGGER_LINE(1),
				TRIGGER_LINE(2),
				TRIGGER_LINE(3),
				TRIGGER_LINE(4),
				TRIGGER_LINE(5),
				TRIGGER_LINE(6),
				TRIGGER_LINE(7),
				NI_CtrSource(4),
				NI_CtrSource(5),
				NI_CtrSource(6),
				NI_CtrGate(4),
				NI_CtrGate(5),
				NI_CtrGate(6),
				NI_CtrInternalOutput(4),
				NI_CtrInternalOutput(5),
				NI_CtrInternalOutput(6),
				NI_20MHzTimebase,
				NI_80MHzTimebase,
				NI_100kHzTimebase,
				NI_LogicLow,
				NI_LogicHigh,
				0, /* Termination */
			}
		},
		{
			.dest = NI_CtrGate(0),
			.src = (int[]){
				NI_PFI(0),
				NI_PFI(1),
				NI_PFI(2),
				NI_PFI(3),
				NI_PFI(4),
				NI_PFI(5),
				NI_PFI(6),
				NI_PFI(7),
				NI_PFI(8),
				NI_PFI(9),
				NI_PFI(10),
				NI_PFI(11),
				NI_PFI(12),
				NI_PFI(13),
				NI_PFI(14),
				NI_PFI(15),
				NI_PFI(16),
				NI_PFI(17),
				NI_PFI(18),
				NI_PFI(19),
				NI_PFI(20),
				NI_PFI(21),
				NI_PFI(22),
				NI_PFI(23),
				NI_PFI(24),
				NI_PFI(25),
				NI_PFI(26),
				NI_PFI(27),
				NI_PFI(28),
				NI_PFI(29),
				NI_PFI(30),
				NI_PFI(31),
				NI_PFI(32),
				NI_PFI(33),
				NI_PFI(34),
				NI_PFI(35),
				NI_PFI(36),
				NI_PFI(37),
				NI_PFI(38),
				NI_PFI(39),
				TRIGGER_LINE(0),
				TRIGGER_LINE(1),
				TRIGGER_LINE(2),
				TRIGGER_LINE(3),
				TRIGGER_LINE(4),
				TRIGGER_LINE(5),
				TRIGGER_LINE(6),
				TRIGGER_LINE(7),
				NI_CtrSource(1),
				NI_CtrSource(2),
				NI_CtrSource(3),
				NI_CtrGate(1),
				NI_CtrGate(2),
				NI_CtrGate(3),
				NI_CtrInternalOutput(1),
				NI_CtrInternalOutput(2),
				NI_CtrInternalOutput(3),
				NI_LogicLow,
				NI_LogicHigh,
				0, /* Termination */
			}
		},
		{
			.dest = NI_CtrGate(1),
			.src = (int[]){
				NI_PFI(0),
				NI_PFI(1),
				NI_PFI(2),
				NI_PFI(3),
				NI_PFI(4),
				NI_PFI(5),
				NI_PFI(6),
				NI_PFI(7),
				NI_PFI(8),
				NI_PFI(9),
				NI_PFI(10),
				NI_PFI(11),
				NI_PFI(12),
				NI_PFI(13),
				NI_PFI(14),
				NI_PFI(15),
				NI_PFI(16),
				NI_PFI(17),
				NI_PFI(18),
				NI_PFI(19),
				NI_PFI(20),
				NI_PFI(21),
				NI_PFI(22),
				NI_PFI(23),
				NI_PFI(24),
				NI_PFI(25),
				NI_PFI(26),
				NI_PFI(27),
				NI_PFI(28),
				NI_PFI(29),
				NI_PFI(30),
				NI_PFI(31),
				NI_PFI(32),
				NI_PFI(33),
				NI_PFI(34),
				NI_PFI(35),
				NI_PFI(36),
				NI_PFI(37),
				NI_PFI(38),
				NI_PFI(39),
				TRIGGER_LINE(0),
				TRIGGER_LINE(1),
				TRIGGER_LINE(2),
				TRIGGER_LINE(3),
				TRIGGER_LINE(4),
				TRIGGER_LINE(5),
				TRIGGER_LINE(6),
				TRIGGER_LINE(7),
				NI_CtrSource(0),
				NI_CtrSource(2),
				NI_CtrSource(3),
				NI_CtrGate(0),
				NI_CtrGate(2),
				NI_CtrGate(3),
				NI_CtrInternalOutput(0),
				NI_CtrInternalOutput(2),
				NI_CtrInternalOutput(3),
				NI_LogicLow,
				NI_LogicHigh,
				0, /* Termination */
			}
		},
		{
			.dest = NI_CtrGate(2),
			.src = (int[]){
				NI_PFI(0),
				NI_PFI(1),
				NI_PFI(2),
				NI_PFI(3),
				NI_PFI(4),
				NI_PFI(5),
				NI_PFI(6),
				NI_PFI(7),
				NI_PFI(8),
				NI_PFI(9),
				NI_PFI(10),
				NI_PFI(11),
				NI_PFI(12),
				NI_PFI(13),
				NI_PFI(14),
				NI_PFI(15),
				NI_PFI(16),
				NI_PFI(17),
				NI_PFI(18),
				NI_PFI(19),
				NI_PFI(20),
				NI_PFI(21),
				NI_PFI(22),
				NI_PFI(23),
				NI_PFI(24),
				NI_PFI(25),
				NI_PFI(26),
				NI_PFI(27),
				NI_PFI(28),
				NI_PFI(29),
				NI_PFI(30),
				NI_PFI(31),
				NI_PFI(32),
				NI_PFI(33),
				NI_PFI(34),
				NI_PFI(35),
				NI_PFI(36),
				NI_PFI(37),
				NI_PFI(38),
				NI_PFI(39),
				TRIGGER_LINE(0),
				TRIGGER_LINE(1),
				TRIGGER_LINE(2),
				TRIGGER_LINE(3),
				TRIGGER_LINE(4),
				TRIGGER_LINE(5),
				TRIGGER_LINE(6),
				TRIGGER_LINE(7),
				NI_CtrSource(0),
				NI_CtrSource(1),
				NI_CtrSource(3),
				NI_CtrGate(0),
				NI_CtrGate(1),
				NI_CtrGate(3),
				NI_CtrInternalOutput(0),
				NI_CtrInternalOutput(1),
				NI_CtrInternalOutput(3),
				NI_LogicLow,
				NI_LogicHigh,
				0, /* Termination */
			}
		},
		{
			.dest = NI_CtrGate(3),
			.src = (int[]){
				NI_PFI(0),
				NI_PFI(1),
				NI_PFI(2),
				NI_PFI(3),
				NI_PFI(4),
				NI_PFI(5),
				NI_PFI(6),
				NI_PFI(7),
				NI_PFI(8),
				NI_PFI(9),
				NI_PFI(10),
				NI_PFI(11),
				NI_PFI(12),
				NI_PFI(13),
				NI_PFI(14),
				NI_PFI(15),
				NI_PFI(16),
				NI_PFI(17),
				NI_PFI(18),
				NI_PFI(19),
				NI_PFI(20),
				NI_PFI(21),
				NI_PFI(22),
				NI_PFI(23),
				NI_PFI(24),
				NI_PFI(25),
				NI_PFI(26),
				NI_PFI(27),
				NI_PFI(28),
				NI_PFI(29),
				NI_PFI(30),
				NI_PFI(31),
				NI_PFI(32),
				NI_PFI(33),
				NI_PFI(34),
				NI_PFI(35),
				NI_PFI(36),
				NI_PFI(37),
				NI_PFI(38),
				NI_PFI(39),
				TRIGGER_LINE(0),
				TRIGGER_LINE(1),
				TRIGGER_LINE(2),
				TRIGGER_LINE(3),
				TRIGGER_LINE(4),
				TRIGGER_LINE(5),
				TRIGGER_LINE(6),
				TRIGGER_LINE(7),
				NI_CtrSource(0),
				NI_CtrSource(1),
				NI_CtrSource(2),
				NI_CtrGate(0),
				NI_CtrGate(1),
				NI_CtrGate(2),
				NI_CtrInternalOutput(0),
				NI_CtrInternalOutput(1),
				NI_CtrInternalOutput(2),
				NI_LogicLow,
				NI_LogicHigh,
				0, /* Termination */
			}
		},
		{
			.dest = NI_CtrGate(4),
			.src = (int[]){
				NI_PFI(0),
				NI_PFI(1),
				NI_PFI(2),
				NI_PFI(3),
				NI_PFI(4),
				NI_PFI(5),
				NI_PFI(6),
				NI_PFI(7),
				NI_PFI(8),
				NI_PFI(9),
				NI_PFI(10),
				NI_PFI(11),
				NI_PFI(12),
				NI_PFI(13),
				NI_PFI(14),
				NI_PFI(15),
				NI_PFI(16),
				NI_PFI(17),
				NI_PFI(18),
				NI_PFI(19),
				NI_PFI(20),
				NI_PFI(21),
				NI_PFI(22),
				NI_PFI(23),
				NI_PFI(24),
				NI_PFI(25),
				NI_PFI(26),
				NI_PFI(27),
				NI_PFI(28),
				NI_PFI(29),
				NI_PFI(30),
				NI_PFI(31),
				NI_PFI(32),
				NI_PFI(33),
				NI_PFI(34),
				NI_PFI(35),
				NI_PFI(36),
				NI_PFI(37),
				NI_PFI(38),
				NI_PFI(39),
				TRIGGER_LINE(0),
				TRIGGER_LINE(1),
				TRIGGER_LINE(2),
				TRIGGER_LINE(3),
				TRIGGER_LINE(4),
				TRIGGER_LINE(5),
				TRIGGER_LINE(6),
				TRIGGER_LINE(7),
				NI_CtrSource(5),
				NI_CtrSource(6),
				NI_CtrSource(7),
				NI_CtrGate(5),
				NI_CtrGate(6),
				NI_CtrGate(7),
				NI_CtrInternalOutput(5),
				NI_CtrInternalOutput(6),
				NI_CtrInternalOutput(7),
				NI_LogicLow,
				NI_LogicHigh,
				0, /* Termination */
			}
		},
		{
			.dest = NI_CtrGate(5),
			.src = (int[]){
				NI_PFI(0),
				NI_PFI(1),
				NI_PFI(2),
				NI_PFI(3),
				NI_PFI(4),
				NI_PFI(5),
				NI_PFI(6),
				NI_PFI(7),
				NI_PFI(8),
				NI_PFI(9),
				NI_PFI(10),
				NI_PFI(11),
				NI_PFI(12),
				NI_PFI(13),
				NI_PFI(14),
				NI_PFI(15),
				NI_PFI(16),
				NI_PFI(17),
				NI_PFI(18),
				NI_PFI(19),
				NI_PFI(20),
				NI_PFI(21),
				NI_PFI(22),
				NI_PFI(23),
				NI_PFI(24),
				NI_PFI(25),
				NI_PFI(26),
				NI_PFI(27),
				NI_PFI(28),
				NI_PFI(29),
				NI_PFI(30),
				NI_PFI(31),
				NI_PFI(32),
				NI_PFI(33),
				NI_PFI(34),
				NI_PFI(35),
				NI_PFI(36),
				NI_PFI(37),
				NI_PFI(38),
				NI_PFI(39),
				TRIGGER_LINE(0),
				TRIGGER_LINE(1),
				TRIGGER_LINE(2),
				TRIGGER_LINE(3),
				TRIGGER_LINE(4),
				TRIGGER_LINE(5),
				TRIGGER_LINE(6),
				TRIGGER_LINE(7),
				NI_CtrSource(4),
				NI_CtrSource(6),
				NI_CtrSource(7),
				NI_CtrGate(4),
				NI_CtrGate(6),
				NI_CtrGate(7),
				NI_CtrInternalOutput(4),
				NI_CtrInternalOutput(6),
				NI_CtrInternalOutput(7),
				NI_LogicLow,
				NI_LogicHigh,
				0, /* Termination */
			}
		},
		{
			.dest = NI_CtrGate(6),
			.src = (int[]){
				NI_PFI(0),
				NI_PFI(1),
				NI_PFI(2),
				NI_PFI(3),
				NI_PFI(4),
				NI_PFI(5),
				NI_PFI(6),
				NI_PFI(7),
				NI_PFI(8),
				NI_PFI(9),
				NI_PFI(10),
				NI_PFI(11),
				NI_PFI(12),
				NI_PFI(13),
				NI_PFI(14),
				NI_PFI(15),
				NI_PFI(16),
				NI_PFI(17),
				NI_PFI(18),
				NI_PFI(19),
				NI_PFI(20),
				NI_PFI(21),
				NI_PFI(22),
				NI_PFI(23),
				NI_PFI(24),
				NI_PFI(25),
				NI_PFI(26),
				NI_PFI(27),
				NI_PFI(28),
				NI_PFI(29),
				NI_PFI(30),
				NI_PFI(31),
				NI_PFI(32),
				NI_PFI(33),
				NI_PFI(34),
				NI_PFI(35),
				NI_PFI(36),
				NI_PFI(37),
				NI_PFI(38),
				NI_PFI(39),
				TRIGGER_LINE(0),
				TRIGGER_LINE(1),
				TRIGGER_LINE(2),
				TRIGGER_LINE(3),
				TRIGGER_LINE(4),
				TRIGGER_LINE(5),
				TRIGGER_LINE(6),
				TRIGGER_LINE(7),
				NI_CtrSource(4),
				NI_CtrSource(5),
				NI_CtrSource(7),
				NI_CtrGate(4),
				NI_CtrGate(5),
				NI_CtrGate(7),
				NI_CtrInternalOutput(4),
				NI_CtrInternalOutput(5),
				NI_CtrInternalOutput(7),
				NI_LogicLow,
				NI_LogicHigh,
				0, /* Termination */
			}
		},
		{
			.dest = NI_CtrGate(7),
			.src = (int[]){
				NI_PFI(0),
				NI_PFI(1),
				NI_PFI(2),
				NI_PFI(3),
				NI_PFI(4),
				NI_PFI(5),
				NI_PFI(6),
				NI_PFI(7),
				NI_PFI(8),
				NI_PFI(9),
				NI_PFI(10),
				NI_PFI(11),
				NI_PFI(12),
				NI_PFI(13),
				NI_PFI(14),
				NI_PFI(15),
				NI_PFI(16),
				NI_PFI(17),
				NI_PFI(18),
				NI_PFI(19),
				NI_PFI(20),
				NI_PFI(21),
				NI_PFI(22),
				NI_PFI(23),
				NI_PFI(24),
				NI_PFI(25),
				NI_PFI(26),
				NI_PFI(27),
				NI_PFI(28),
				NI_PFI(29),
				NI_PFI(30),
				NI_PFI(31),
				NI_PFI(32),
				NI_PFI(33),
				NI_PFI(34),
				NI_PFI(35),
				NI_PFI(36),
				NI_PFI(37),
				NI_PFI(38),
				NI_PFI(39),
				TRIGGER_LINE(0),
				TRIGGER_LINE(1),
				TRIGGER_LINE(2),
				TRIGGER_LINE(3),
				TRIGGER_LINE(4),
				TRIGGER_LINE(5),
				TRIGGER_LINE(6),
				TRIGGER_LINE(7),
				NI_CtrSource(4),
				NI_CtrSource(5),
				NI_CtrSource(6),
				NI_CtrGate(4),
				NI_CtrGate(5),
				NI_CtrGate(6),
				NI_CtrInternalOutput(4),
				NI_CtrInternalOutput(5),
				NI_CtrInternalOutput(6),
				NI_LogicLow,
				NI_LogicHigh,
				0, /* Termination */
			}
		},
		{
			.dest = NI_CtrAux(0),
			.src = (int[]){
				NI_PFI(0),
				NI_PFI(1),
				NI_PFI(2),
				NI_PFI(3),
				NI_PFI(4),
				NI_PFI(5),
				NI_PFI(6),
				NI_PFI(7),
				NI_PFI(8),
				NI_PFI(9),
				NI_PFI(10),
				NI_PFI(11),
				NI_PFI(12),
				NI_PFI(13),
				NI_PFI(14),
				NI_PFI(15),
				NI_PFI(16),
				NI_PFI(17),
				NI_PFI(18),
				NI_PFI(19),
				NI_PFI(20),
				NI_PFI(21),
				NI_PFI(22),
				NI_PFI(23),
				NI_PFI(24),
				NI_PFI(25),
				NI_PFI(26),
				NI_PFI(27),
				NI_PFI(28),
				NI_PFI(29),
				NI_PFI(30),
				NI_PFI(31),
				NI_PFI(32),
				NI_PFI(33),
				NI_PFI(34),
				NI_PFI(35),
				NI_PFI(36),
				NI_PFI(37),
				NI_PFI(38),
				NI_PFI(39),
				TRIGGER_LINE(0),
				TRIGGER_LINE(1),
				TRIGGER_LINE(2),
				TRIGGER_LINE(3),
				TRIGGER_LINE(4),
				TRIGGER_LINE(5),
				TRIGGER_LINE(6),
				TRIGGER_LINE(7),
				NI_CtrSource(1),
				NI_CtrSource(2),
				NI_CtrSource(3),
				NI_CtrGate(0),
				NI_CtrGate(1),
				NI_CtrGate(2),
				NI_CtrGate(3),
				NI_CtrInternalOutput(1),
				NI_CtrInternalOutput(2),
				NI_CtrInternalOutput(3),
				NI_LogicLow,
				NI_LogicHigh,
				0, /* Termination */
			}
		},
		{
			.dest = NI_CtrAux(1),
			.src = (int[]){
				NI_PFI(0),
				NI_PFI(1),
				NI_PFI(2),
				NI_PFI(3),
				NI_PFI(4),
				NI_PFI(5),
				NI_PFI(6),
				NI_PFI(7),
				NI_PFI(8),
				NI_PFI(9),
				NI_PFI(10),
				NI_PFI(11),
				NI_PFI(12),
				NI_PFI(13),
				NI_PFI(14),
				NI_PFI(15),
				NI_PFI(16),
				NI_PFI(17),
				NI_PFI(18),
				NI_PFI(19),
				NI_PFI(20),
				NI_PFI(21),
				NI_PFI(22),
				NI_PFI(23),
				NI_PFI(24),
				NI_PFI(25),
				NI_PFI(26),
				NI_PFI(27),
				NI_PFI(28),
				NI_PFI(29),
				NI_PFI(30),
				NI_PFI(31),
				NI_PFI(32),
				NI_PFI(33),
				NI_PFI(34),
				NI_PFI(35),
				NI_PFI(36),
				NI_PFI(37),
				NI_PFI(38),
				NI_PFI(39),
				TRIGGER_LINE(0),
				TRIGGER_LINE(1),
				TRIGGER_LINE(2),
				TRIGGER_LINE(3),
				TRIGGER_LINE(4),
				TRIGGER_LINE(5),
				TRIGGER_LINE(6),
				TRIGGER_LINE(7),
				NI_CtrSource(0),
				NI_CtrSource(2),
				NI_CtrSource(3),
				NI_CtrGate(0),
				NI_CtrGate(1),
				NI_CtrGate(2),
				NI_CtrGate(3),
				NI_CtrInternalOutput(0),
				NI_CtrInternalOutput(2),
				NI_CtrInternalOutput(3),
				NI_LogicLow,
				NI_LogicHigh,
				0, /* Termination */
			}
		},
		{
			.dest = NI_CtrAux(2),
			.src = (int[]){
				NI_PFI(0),
				NI_PFI(1),
				NI_PFI(2),
				NI_PFI(3),
				NI_PFI(4),
				NI_PFI(5),
				NI_PFI(6),
				NI_PFI(7),
				NI_PFI(8),
				NI_PFI(9),
				NI_PFI(10),
				NI_PFI(11),
				NI_PFI(12),
				NI_PFI(13),
				NI_PFI(14),
				NI_PFI(15),
				NI_PFI(16),
				NI_PFI(17),
				NI_PFI(18),
				NI_PFI(19),
				NI_PFI(20),
				NI_PFI(21),
				NI_PFI(22),
				NI_PFI(23),
				NI_PFI(24),
				NI_PFI(25),
				NI_PFI(26),
				NI_PFI(27),
				NI_PFI(28),
				NI_PFI(29),
				NI_PFI(30),
				NI_PFI(31),
				NI_PFI(32),
				NI_PFI(33),
				NI_PFI(34),
				NI_PFI(35),
				NI_PFI(36),
				NI_PFI(37),
				NI_PFI(38),
				NI_PFI(39),
				TRIGGER_LINE(0),
				TRIGGER_LINE(1),
				TRIGGER_LINE(2),
				TRIGGER_LINE(3),
				TRIGGER_LINE(4),
				TRIGGER_LINE(5),
				TRIGGER_LINE(6),
				TRIGGER_LINE(7),
				NI_CtrSource(0),
				NI_CtrSource(1),
				NI_CtrSource(3),
				NI_CtrGate(0),
				NI_CtrGate(1),
				NI_CtrGate(2),
				NI_CtrGate(3),
				NI_CtrInternalOutput(0),
				NI_CtrInternalOutput(1),
				NI_CtrInternalOutput(3),
				NI_LogicLow,
				NI_LogicHigh,
				0, /* Termination */
			}
		},
		{
			.dest = NI_CtrAux(3),
			.src = (int[]){
				NI_PFI(0),
				NI_PFI(1),
				NI_PFI(2),
				NI_PFI(3),
				NI_PFI(4),
				NI_PFI(5),
				NI_PFI(6),
				NI_PFI(7),
				NI_PFI(8),
				NI_PFI(9),
				NI_PFI(10),
				NI_PFI(11),
				NI_PFI(12),
				NI_PFI(13),
				NI_PFI(14),
				NI_PFI(15),
				NI_PFI(16),
				NI_PFI(17),
				NI_PFI(18),
				NI_PFI(19),
				NI_PFI(20),
				NI_PFI(21),
				NI_PFI(22),
				NI_PFI(23),
				NI_PFI(24),
				NI_PFI(25),
				NI_PFI(26),
				NI_PFI(27),
				NI_PFI(28),
				NI_PFI(29),
				NI_PFI(30),
				NI_PFI(31),
				NI_PFI(32),
				NI_PFI(33),
				NI_PFI(34),
				NI_PFI(35),
				NI_PFI(36),
				NI_PFI(37),
				NI_PFI(38),
				NI_PFI(39),
				TRIGGER_LINE(0),
				TRIGGER_LINE(1),
				TRIGGER_LINE(2),
				TRIGGER_LINE(3),
				TRIGGER_LINE(4),
				TRIGGER_LINE(5),
				TRIGGER_LINE(6),
				TRIGGER_LINE(7),
				NI_CtrSource(0),
				NI_CtrSource(1),
				NI_CtrSource(2),
				NI_CtrGate(0),
				NI_CtrGate(1),
				NI_CtrGate(2),
				NI_CtrGate(3),
				NI_CtrInternalOutput(0),
				NI_CtrInternalOutput(1),
				NI_CtrInternalOutput(2),
				NI_LogicLow,
				NI_LogicHigh,
				0, /* Termination */
			}
		},
		{
			.dest = NI_CtrAux(4),
			.src = (int[]){
				NI_PFI(0),
				NI_PFI(1),
				NI_PFI(2),
				NI_PFI(3),
				NI_PFI(4),
				NI_PFI(5),
				NI_PFI(6),
				NI_PFI(7),
				NI_PFI(8),
				NI_PFI(9),
				NI_PFI(10),
				NI_PFI(11),
				NI_PFI(12),
				NI_PFI(13),
				NI_PFI(14),
				NI_PFI(15),
				NI_PFI(16),
				NI_PFI(17),
				NI_PFI(18),
				NI_PFI(19),
				NI_PFI(20),
				NI_PFI(21),
				NI_PFI(22),
				NI_PFI(23),
				NI_PFI(24),
				NI_PFI(25),
				NI_PFI(26),
				NI_PFI(27),
				NI_PFI(28),
				NI_PFI(29),
				NI_PFI(30),
				NI_PFI(31),
				NI_PFI(32),
				NI_PFI(33),
				NI_PFI(34),
				NI_PFI(35),
				NI_PFI(36),
				NI_PFI(37),
				NI_PFI(38),
				NI_PFI(39),
				TRIGGER_LINE(0),
				TRIGGER_LINE(1),
				TRIGGER_LINE(2),
				TRIGGER_LINE(3),
				TRIGGER_LINE(4),
				TRIGGER_LINE(5),
				TRIGGER_LINE(6),
				TRIGGER_LINE(7),
				NI_CtrSource(5),
				NI_CtrSource(6),
				NI_CtrSource(7),
				NI_CtrGate(4),
				NI_CtrGate(5),
				NI_CtrGate(6),
				NI_CtrGate(7),
				NI_CtrInternalOutput(5),
				NI_CtrInternalOutput(6),
				NI_CtrInternalOutput(7),
				NI_LogicLow,
				NI_LogicHigh,
				0, /* Termination */
			}
		},
		{
			.dest = NI_CtrAux(5),
			.src = (int[]){
				NI_PFI(0),
				NI_PFI(1),
				NI_PFI(2),
				NI_PFI(3),
				NI_PFI(4),
				NI_PFI(5),
				NI_PFI(6),
				NI_PFI(7),
				NI_PFI(8),
				NI_PFI(9),
				NI_PFI(10),
				NI_PFI(11),
				NI_PFI(12),
				NI_PFI(13),
				NI_PFI(14),
				NI_PFI(15),
				NI_PFI(16),
				NI_PFI(17),
				NI_PFI(18),
				NI_PFI(19),
				NI_PFI(20),
				NI_PFI(21),
				NI_PFI(22),
				NI_PFI(23),
				NI_PFI(24),
				NI_PFI(25),
				NI_PFI(26),
				NI_PFI(27),
				NI_PFI(28),
				NI_PFI(29),
				NI_PFI(30),
				NI_PFI(31),
				NI_PFI(32),
				NI_PFI(33),
				NI_PFI(34),
				NI_PFI(35),
				NI_PFI(36),
				NI_PFI(37),
				NI_PFI(38),
				NI_PFI(39),
				TRIGGER_LINE(0),
				TRIGGER_LINE(1),
				TRIGGER_LINE(2),
				TRIGGER_LINE(3),
				TRIGGER_LINE(4),
				TRIGGER_LINE(5),
				TRIGGER_LINE(6),
				TRIGGER_LINE(7),
				NI_CtrSource(4),
				NI_CtrSource(6),
				NI_CtrSource(7),
				NI_CtrGate(4),
				NI_CtrGate(5),
				NI_CtrGate(6),
				NI_CtrGate(7),
				NI_CtrInternalOutput(4),
				NI_CtrInternalOutput(6),
				NI_CtrInternalOutput(7),
				NI_LogicLow,
				NI_LogicHigh,
				0, /* Termination */
			}
		},
		{
			.dest = NI_CtrAux(6),
			.src = (int[]){
				NI_PFI(0),
				NI_PFI(1),
				NI_PFI(2),
				NI_PFI(3),
				NI_PFI(4),
				NI_PFI(5),
				NI_PFI(6),
				NI_PFI(7),
				NI_PFI(8),
				NI_PFI(9),
				NI_PFI(10),
				NI_PFI(11),
				NI_PFI(12),
				NI_PFI(13),
				NI_PFI(14),
				NI_PFI(15),
				NI_PFI(16),
				NI_PFI(17),
				NI_PFI(18),
				NI_PFI(19),
				NI_PFI(20),
				NI_PFI(21),
				NI_PFI(22),
				NI_PFI(23),
				NI_PFI(24),
				NI_PFI(25),
				NI_PFI(26),
				NI_PFI(27),
				NI_PFI(28),
				NI_PFI(29),
				NI_PFI(30),
				NI_PFI(31),
				NI_PFI(32),
				NI_PFI(33),
				NI_PFI(34),
				NI_PFI(35),
				NI_PFI(36),
				NI_PFI(37),
				NI_PFI(38),
				NI_PFI(39),
				TRIGGER_LINE(0),
				TRIGGER_LINE(1),
				TRIGGER_LINE(2),
				TRIGGER_LINE(3),
				TRIGGER_LINE(4),
				TRIGGER_LINE(5),
				TRIGGER_LINE(6),
				TRIGGER_LINE(7),
				NI_CtrSource(4),
				NI_CtrSource(5),
				NI_CtrSource(7),
				NI_CtrGate(4),
				NI_CtrGate(5),
				NI_CtrGate(6),
				NI_CtrGate(7),
				NI_CtrInternalOutput(4),
				NI_CtrInternalOutput(5),
				NI_CtrInternalOutput(7),
				NI_LogicLow,
				NI_LogicHigh,
				0, /* Termination */
			}
		},
		{
			.dest = NI_CtrAux(7),
			.src = (int[]){
				NI_PFI(0),
				NI_PFI(1),
				NI_PFI(2),
				NI_PFI(3),
				NI_PFI(4),
				NI_PFI(5),
				NI_PFI(6),
				NI_PFI(7),
				NI_PFI(8),
				NI_PFI(9),
				NI_PFI(10),
				NI_PFI(11),
				NI_PFI(12),
				NI_PFI(13),
				NI_PFI(14),
				NI_PFI(15),
				NI_PFI(16),
				NI_PFI(17),
				NI_PFI(18),
				NI_PFI(19),
				NI_PFI(20),
				NI_PFI(21),
				NI_PFI(22),
				NI_PFI(23),
				NI_PFI(24),
				NI_PFI(25),
				NI_PFI(26),
				NI_PFI(27),
				NI_PFI(28),
				NI_PFI(29),
				NI_PFI(30),
				NI_PFI(31),
				NI_PFI(32),
				NI_PFI(33),
				NI_PFI(34),
				NI_PFI(35),
				NI_PFI(36),
				NI_PFI(37),
				NI_PFI(38),
				NI_PFI(39),
				TRIGGER_LINE(0),
				TRIGGER_LINE(1),
				TRIGGER_LINE(2),
				TRIGGER_LINE(3),
				TRIGGER_LINE(4),
				TRIGGER_LINE(5),
				TRIGGER_LINE(6),
				TRIGGER_LINE(7),
				NI_CtrSource(4),
				NI_CtrSource(5),
				NI_CtrSource(6),
				NI_CtrGate(4),
				NI_CtrGate(5),
				NI_CtrGate(6),
				NI_CtrGate(7),
				NI_CtrInternalOutput(4),
				NI_CtrInternalOutput(5),
				NI_CtrInternalOutput(6),
				NI_LogicLow,
				NI_LogicHigh,
				0, /* Termination */
			}
		},
		{
			.dest = NI_CtrArmStartTrigger(0),
			.src = (int[]){
				NI_PFI(0),
				NI_PFI(1),
				NI_PFI(2),
				NI_PFI(3),
				NI_PFI(4),
				NI_PFI(5),
				NI_PFI(6),
				NI_PFI(7),
				NI_PFI(8),
				NI_PFI(9),
				NI_PFI(10),
				NI_PFI(11),
				NI_PFI(12),
				NI_PFI(13),
				NI_PFI(14),
				NI_PFI(15),
				NI_PFI(16),
				NI_PFI(17),
				NI_PFI(18),
				NI_PFI(19),
				NI_PFI(20),
				NI_PFI(21),
				NI_PFI(22),
				NI_PFI(23),
				NI_PFI(24),
				NI_PFI(25),
				NI_PFI(26),
				NI_PFI(27),
				NI_PFI(28),
				NI_PFI(29),
				NI_PFI(30),
				NI_PFI(31),
				NI_PFI(32),
				NI_PFI(33),
				NI_PFI(34),
				NI_PFI(35),
				NI_PFI(36),
				NI_PFI(37),
				NI_PFI(38),
				NI_PFI(39),
				TRIGGER_LINE(0),
				TRIGGER_LINE(1),
				TRIGGER_LINE(2),
				TRIGGER_LINE(3),
				TRIGGER_LINE(4),
				TRIGGER_LINE(5),
				TRIGGER_LINE(6),
				TRIGGER_LINE(7),
				NI_CtrSource(1),
				NI_CtrSource(2),
				NI_CtrSource(3),
				NI_CtrGate(1),
				NI_CtrGate(2),
				NI_CtrGate(3),
				NI_CtrInternalOutput(1),
				NI_CtrInternalOutput(2),
				NI_CtrInternalOutput(3),
				NI_LogicLow,
				NI_LogicHigh,
				0, /* Termination */
			}
		},
		{
			.dest = NI_CtrArmStartTrigger(1),
			.src = (int[]){
				NI_PFI(0),
				NI_PFI(1),
				NI_PFI(2),
				NI_PFI(3),
				NI_PFI(4),
				NI_PFI(5),
				NI_PFI(6),
				NI_PFI(7),
				NI_PFI(8),
				NI_PFI(9),
				NI_PFI(10),
				NI_PFI(11),
				NI_PFI(12),
				NI_PFI(13),
				NI_PFI(14),
				NI_PFI(15),
				NI_PFI(16),
				NI_PFI(17),
				NI_PFI(18),
				NI_PFI(19),
				NI_PFI(20),
				NI_PFI(21),
				NI_PFI(22),
				NI_PFI(23),
				NI_PFI(24),
				NI_PFI(25),
				NI_PFI(26),
				NI_PFI(27),
				NI_PFI(28),
				NI_PFI(29),
				NI_PFI(30),
				NI_PFI(31),
				NI_PFI(32),
				NI_PFI(33),
				NI_PFI(34),
				NI_PFI(35),
				NI_PFI(36),
				NI_PFI(37),
				NI_PFI(38),
				NI_PFI(39),
				TRIGGER_LINE(0),
				TRIGGER_LINE(1),
				TRIGGER_LINE(2),
				TRIGGER_LINE(3),
				TRIGGER_LINE(4),
				TRIGGER_LINE(5),
				TRIGGER_LINE(6),
				TRIGGER_LINE(7),
				NI_CtrSource(0),
				NI_CtrSource(2),
				NI_CtrSource(3),
				NI_CtrGate(0),
				NI_CtrGate(2),
				NI_CtrGate(3),
				NI_CtrInternalOutput(0),
				NI_CtrInternalOutput(2),
				NI_CtrInternalOutput(3),
				NI_LogicLow,
				NI_LogicHigh,
				0, /* Termination */
			}
		},
		{
			.dest = NI_CtrArmStartTrigger(2),
			.src = (int[]){
				NI_PFI(0),
				NI_PFI(1),
				NI_PFI(2),
				NI_PFI(3),
				NI_PFI(4),
				NI_PFI(5),
				NI_PFI(6),
				NI_PFI(7),
				NI_PFI(8),
				NI_PFI(9),
				NI_PFI(10),
				NI_PFI(11),
				NI_PFI(12),
				NI_PFI(13),
				NI_PFI(14),
				NI_PFI(15),
				NI_PFI(16),
				NI_PFI(17),
				NI_PFI(18),
				NI_PFI(19),
				NI_PFI(20),
				NI_PFI(21),
				NI_PFI(22),
				NI_PFI(23),
				NI_PFI(24),
				NI_PFI(25),
				NI_PFI(26),
				NI_PFI(27),
				NI_PFI(28),
				NI_PFI(29),
				NI_PFI(30),
				NI_PFI(31),
				NI_PFI(32),
				NI_PFI(33),
				NI_PFI(34),
				NI_PFI(35),
				NI_PFI(36),
				NI_PFI(37),
				NI_PFI(38),
				NI_PFI(39),
				TRIGGER_LINE(0),
				TRIGGER_LINE(1),
				TRIGGER_LINE(2),
				TRIGGER_LINE(3),
				TRIGGER_LINE(4),
				TRIGGER_LINE(5),
				TRIGGER_LINE(6),
				TRIGGER_LINE(7),
				NI_CtrSource(0),
				NI_CtrSource(1),
				NI_CtrSource(3),
				NI_CtrGate(0),
				NI_CtrGate(1),
				NI_CtrGate(3),
				NI_CtrInternalOutput(0),
				NI_CtrInternalOutput(1),
				NI_CtrInternalOutput(3),
				NI_LogicLow,
				NI_LogicHigh,
				0, /* Termination */
			}
		},
		{
			.dest = NI_CtrArmStartTrigger(3),
			.src = (int[]){
				NI_PFI(0),
				NI_PFI(1),
				NI_PFI(2),
				NI_PFI(3),
				NI_PFI(4),
				NI_PFI(5),
				NI_PFI(6),
				NI_PFI(7),
				NI_PFI(8),
				NI_PFI(9),
				NI_PFI(10),
				NI_PFI(11),
				NI_PFI(12),
				NI_PFI(13),
				NI_PFI(14),
				NI_PFI(15),
				NI_PFI(16),
				NI_PFI(17),
				NI_PFI(18),
				NI_PFI(19),
				NI_PFI(20),
				NI_PFI(21),
				NI_PFI(22),
				NI_PFI(23),
				NI_PFI(24),
				NI_PFI(25),
				NI_PFI(26),
				NI_PFI(27),
				NI_PFI(28),
				NI_PFI(29),
				NI_PFI(30),
				NI_PFI(31),
				NI_PFI(32),
				NI_PFI(33),
				NI_PFI(34),
				NI_PFI(35),
				NI_PFI(36),
				NI_PFI(37),
				NI_PFI(38),
				NI_PFI(39),
				TRIGGER_LINE(0),
				TRIGGER_LINE(1),
				TRIGGER_LINE(2),
				TRIGGER_LINE(3),
				TRIGGER_LINE(4),
				TRIGGER_LINE(5),
				TRIGGER_LINE(6),
				TRIGGER_LINE(7),
				NI_CtrSource(0),
				NI_CtrSource(1),
				NI_CtrSource(2),
				NI_CtrGate(0),
				NI_CtrGate(1),
				NI_CtrGate(2),
				NI_CtrInternalOutput(0),
				NI_CtrInternalOutput(1),
				NI_CtrInternalOutput(2),
				NI_LogicLow,
				NI_LogicHigh,
				0, /* Termination */
			}
		},
		{
			.dest = NI_CtrArmStartTrigger(4),
			.src = (int[]){
				NI_PFI(0),
				NI_PFI(1),
				NI_PFI(2),
				NI_PFI(3),
				NI_PFI(4),
				NI_PFI(5),
				NI_PFI(6),
				NI_PFI(7),
				NI_PFI(8),
				NI_PFI(9),
				NI_PFI(10),
				NI_PFI(11),
				NI_PFI(12),
				NI_PFI(13),
				NI_PFI(14),
				NI_PFI(15),
				NI_PFI(16),
				NI_PFI(17),
				NI_PFI(18),
				NI_PFI(19),
				NI_PFI(20),
				NI_PFI(21),
				NI_PFI(22),
				NI_PFI(23),
				NI_PFI(24),
				NI_PFI(25),
				NI_PFI(26),
				NI_PFI(27),
				NI_PFI(28),
				NI_PFI(29),
				NI_PFI(30),
				NI_PFI(31),
				NI_PFI(32),
				NI_PFI(33),
				NI_PFI(34),
				NI_PFI(35),
				NI_PFI(36),
				NI_PFI(37),
				NI_PFI(38),
				NI_PFI(39),
				TRIGGER_LINE(0),
				TRIGGER_LINE(1),
				TRIGGER_LINE(2),
				TRIGGER_LINE(3),
				TRIGGER_LINE(4),
				TRIGGER_LINE(5),
				TRIGGER_LINE(6),
				TRIGGER_LINE(7),
				NI_CtrSource(5),
				NI_CtrSource(6),
				NI_CtrSource(7),
				NI_CtrGate(5),
				NI_CtrGate(6),
				NI_CtrGate(7),
				NI_CtrInternalOutput(5),
				NI_CtrInternalOutput(6),
				NI_CtrInternalOutput(7),
				NI_LogicLow,
				NI_LogicHigh,
				0, /* Termination */
			}
		},
		{
			.dest = NI_CtrArmStartTrigger(5),
			.src = (int[]){
				NI_PFI(0),
				NI_PFI(1),
				NI_PFI(2),
				NI_PFI(3),
				NI_PFI(4),
				NI_PFI(5),
				NI_PFI(6),
				NI_PFI(7),
				NI_PFI(8),
				NI_PFI(9),
				NI_PFI(10),
				NI_PFI(11),
				NI_PFI(12),
				NI_PFI(13),
				NI_PFI(14),
				NI_PFI(15),
				NI_PFI(16),
				NI_PFI(17),
				NI_PFI(18),
				NI_PFI(19),
				NI_PFI(20),
				NI_PFI(21),
				NI_PFI(22),
				NI_PFI(23),
				NI_PFI(24),
				NI_PFI(25),
				NI_PFI(26),
				NI_PFI(27),
				NI_PFI(28),
				NI_PFI(29),
				NI_PFI(30),
				NI_PFI(31),
				NI_PFI(32),
				NI_PFI(33),
				NI_PFI(34),
				NI_PFI(35),
				NI_PFI(36),
				NI_PFI(37),
				NI_PFI(38),
				NI_PFI(39),
				TRIGGER_LINE(0),
				TRIGGER_LINE(1),
				TRIGGER_LINE(2),
				TRIGGER_LINE(3),
				TRIGGER_LINE(4),
				TRIGGER_LINE(5),
				TRIGGER_LINE(6),
				TRIGGER_LINE(7),
				NI_CtrSource(4),
				NI_CtrSource(6),
				NI_CtrSource(7),
				NI_CtrGate(4),
				NI_CtrGate(6),
				NI_CtrGate(7),
				NI_CtrInternalOutput(4),
				NI_CtrInternalOutput(6),
				NI_CtrInternalOutput(7),
				NI_LogicLow,
				NI_LogicHigh,
				0, /* Termination */
			}
		},
		{
			.dest = NI_CtrArmStartTrigger(6),
			.src = (int[]){
				NI_PFI(0),
				NI_PFI(1),
				NI_PFI(2),
				NI_PFI(3),
				NI_PFI(4),
				NI_PFI(5),
				NI_PFI(6),
				NI_PFI(7),
				NI_PFI(8),
				NI_PFI(9),
				NI_PFI(10),
				NI_PFI(11),
				NI_PFI(12),
				NI_PFI(13),
				NI_PFI(14),
				NI_PFI(15),
				NI_PFI(16),
				NI_PFI(17),
				NI_PFI(18),
				NI_PFI(19),
				NI_PFI(20),
				NI_PFI(21),
				NI_PFI(22),
				NI_PFI(23),
				NI_PFI(24),
				NI_PFI(25),
				NI_PFI(26),
				NI_PFI(27),
				NI_PFI(28),
				NI_PFI(29),
				NI_PFI(30),
				NI_PFI(31),
				NI_PFI(32),
				NI_PFI(33),
				NI_PFI(34),
				NI_PFI(35),
				NI_PFI(36),
				NI_PFI(37),
				NI_PFI(38),
				NI_PFI(39),
				TRIGGER_LINE(0),
				TRIGGER_LINE(1),
				TRIGGER_LINE(2),
				TRIGGER_LINE(3),
				TRIGGER_LINE(4),
				TRIGGER_LINE(5),
				TRIGGER_LINE(6),
				TRIGGER_LINE(7),
				NI_CtrSource(4),
				NI_CtrSource(5),
				NI_CtrSource(7),
				NI_CtrGate(4),
				NI_CtrGate(5),
				NI_CtrGate(7),
				NI_CtrInternalOutput(4),
				NI_CtrInternalOutput(5),
				NI_CtrInternalOutput(7),
				NI_LogicLow,
				NI_LogicHigh,
				0, /* Termination */
			}
		},
		{
			.dest = NI_CtrArmStartTrigger(7),
			.src = (int[]){
				NI_PFI(0),
				NI_PFI(1),
				NI_PFI(2),
				NI_PFI(3),
				NI_PFI(4),
				NI_PFI(5),
				NI_PFI(6),
				NI_PFI(7),
				NI_PFI(8),
				NI_PFI(9),
				NI_PFI(10),
				NI_PFI(11),
				NI_PFI(12),
				NI_PFI(13),
				NI_PFI(14),
				NI_PFI(15),
				NI_PFI(16),
				NI_PFI(17),
				NI_PFI(18),
				NI_PFI(19),
				NI_PFI(20),
				NI_PFI(21),
				NI_PFI(22),
				NI_PFI(23),
				NI_PFI(24),
				NI_PFI(25),
				NI_PFI(26),
				NI_PFI(27),
				NI_PFI(28),
				NI_PFI(29),
				NI_PFI(30),
				NI_PFI(31),
				NI_PFI(32),
				NI_PFI(33),
				NI_PFI(34),
				NI_PFI(35),
				NI_PFI(36),
				NI_PFI(37),
				NI_PFI(38),
				NI_PFI(39),
				TRIGGER_LINE(0),
				TRIGGER_LINE(1),
				TRIGGER_LINE(2),
				TRIGGER_LINE(3),
				TRIGGER_LINE(4),
				TRIGGER_LINE(5),
				TRIGGER_LINE(6),
				TRIGGER_LINE(7),
				NI_CtrSource(4),
				NI_CtrSource(5),
				NI_CtrSource(6),
				NI_CtrGate(4),
				NI_CtrGate(5),
				NI_CtrGate(6),
				NI_CtrInternalOutput(4),
				NI_CtrInternalOutput(5),
				NI_CtrInternalOutput(6),
				NI_LogicLow,
				NI_LogicHigh,
				0, /* Termination */
			}
		},
		{
			.dest = NI_MasterTimebase,
			.src = (int[]){
				TRIGGER_LINE(7),
				NI_20MHzTimebase,
				0, /* Termination */
			}
		},
		{ /* Termination of list */
			.dest = 0,
		},
	},
};
