/*
 * Copyright (C) 2019  Advanced Micro Devices, Inc.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE COPYRIGHT HOLDER(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
 * AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

#ifndef _gc_10_3_0_SH_MASK_HEADER
#define _gc_10_3_0_SH_MASK_HEADER


// addressBlock: gc_sdma0_sdma0dec
//SDMA0_DEC_START
#define SDMA0_DEC_START__START__SHIFT                                                                         0x0
#define SDMA0_DEC_START__START_MASK                                                                           0xFFFFFFFFL
//SDMA0_GLOBAL_TIMESTAMP_LO
#define SDMA0_GLOBAL_TIMESTAMP_LO__DATA__SHIFT                                                                0x0
#define SDMA0_GLOBAL_TIMESTAMP_LO__DATA_MASK                                                                  0xFFFFFFFFL
//SDMA0_GLOBAL_TIMESTAMP_HI
#define SDMA0_GLOBAL_TIMESTAMP_HI__DATA__SHIFT                                                                0x0
#define SDMA0_GLOBAL_TIMESTAMP_HI__DATA_MASK                                                                  0xFFFFFFFFL
//SDMA0_PG_CNTL
#define SDMA0_PG_CNTL__CMD__SHIFT                                                                             0x0
#define SDMA0_PG_CNTL__STATUS__SHIFT                                                                          0x10
#define SDMA0_PG_CNTL__CMD_MASK                                                                               0x0000000FL
#define SDMA0_PG_CNTL__STATUS_MASK                                                                            0x000F0000L
//SDMA0_PG_CTX_LO
#define SDMA0_PG_CTX_LO__ADDR__SHIFT                                                                          0x0
#define SDMA0_PG_CTX_LO__ADDR_MASK                                                                            0xFFFFFFFFL
//SDMA0_PG_CTX_HI
#define SDMA0_PG_CTX_HI__ADDR__SHIFT                                                                          0x0
#define SDMA0_PG_CTX_HI__ADDR_MASK                                                                            0xFFFFFFFFL
//SDMA0_PG_CTX_CNTL
#define SDMA0_PG_CTX_CNTL__VMID__SHIFT                                                                        0x0
#define SDMA0_PG_CTX_CNTL__VMID_MASK                                                                          0x0000000FL
//SDMA0_POWER_CNTL
#define SDMA0_POWER_CNTL__PG_CNTL_ENABLE__SHIFT                                                               0x0
#define SDMA0_POWER_CNTL__EXT_PG_POWER_ON_REQ__SHIFT                                                          0x1
#define SDMA0_POWER_CNTL__EXT_PG_POWER_OFF_REQ__SHIFT                                                         0x2
#define SDMA0_POWER_CNTL__ON_OFF_CONDITION_HOLD_TIME__SHIFT                                                   0x3
#define SDMA0_POWER_CNTL__MEM_POWER_OVERRIDE__SHIFT                                                           0x8
#define SDMA0_POWER_CNTL__ON_OFF_STATUS_DURATION_TIME__SHIFT                                                  0x1a
#define SDMA0_POWER_CNTL__PG_CNTL_ENABLE_MASK                                                                 0x00000001L
#define SDMA0_POWER_CNTL__EXT_PG_POWER_ON_REQ_MASK                                                            0x00000002L
#define SDMA0_POWER_CNTL__EXT_PG_POWER_OFF_REQ_MASK                                                           0x00000004L
#define SDMA0_POWER_CNTL__ON_OFF_CONDITION_HOLD_TIME_MASK                                                     0x000000F8L
#define SDMA0_POWER_CNTL__MEM_POWER_OVERRIDE_MASK                                                             0x00000100L
#define SDMA0_POWER_CNTL__ON_OFF_STATUS_DURATION_TIME_MASK                                                    0xFC000000L
//SDMA0_CLK_CTRL
#define SDMA0_CLK_CTRL__ON_DELAY__SHIFT                                                                       0x0
#define SDMA0_CLK_CTRL__OFF_HYSTERESIS__SHIFT                                                                 0x4
#define SDMA0_CLK_CTRL__RESERVED_24_12__SHIFT                                                                 0xc
#define SDMA0_CLK_CTRL__CGCG_EN_OVERRIDE__SHIFT                                                               0x19
#define SDMA0_CLK_CTRL__SOFT_OVERRIDE4__SHIFT                                                                 0x1a
#define SDMA0_CLK_CTRL__SOFT_OVERRIDE3__SHIFT                                                                 0x1b
#define SDMA0_CLK_CTRL__SOFT_OVERRIDE2__SHIFT                                                                 0x1c
#define SDMA0_CLK_CTRL__SOFT_OVERRIDE1__SHIFT                                                                 0x1d
#define SDMA0_CLK_CTRL__SOFT_OVERRIDE0__SHIFT                                                                 0x1e
#define SDMA0_CLK_CTRL__SOFT_OVERRIDER_REG__SHIFT                                                             0x1f
#define SDMA0_CLK_CTRL__ON_DELAY_MASK                                                                         0x0000000FL
#define SDMA0_CLK_CTRL__OFF_HYSTERESIS_MASK                                                                   0x00000FF0L
#define SDMA0_CLK_CTRL__RESERVED_24_12_MASK                                                                   0x01FFF000L
#define SDMA0_CLK_CTRL__CGCG_EN_OVERRIDE_MASK                                                                 0x02000000L
#define SDMA0_CLK_CTRL__SOFT_OVERRIDE4_MASK                                                                   0x04000000L
#define SDMA0_CLK_CTRL__SOFT_OVERRIDE3_MASK                                                                   0x08000000L
#define SDMA0_CLK_CTRL__SOFT_OVERRIDE2_MASK                                                                   0x10000000L
#define SDMA0_CLK_CTRL__SOFT_OVERRIDE1_MASK                                                                   0x20000000L
#define SDMA0_CLK_CTRL__SOFT_OVERRIDE0_MASK                                                                   0x40000000L
#define SDMA0_CLK_CTRL__SOFT_OVERRIDER_REG_MASK                                                               0x80000000L
//SDMA0_CNTL
#define SDMA0_CNTL__TRAP_ENABLE__SHIFT                                                                        0x0
#define SDMA0_CNTL__UTC_L1_ENABLE__SHIFT                                                                      0x1
#define SDMA0_CNTL__SEM_WAIT_INT_ENABLE__SHIFT                                                                0x2
#define SDMA0_CNTL__DATA_SWAP_ENABLE__SHIFT                                                                   0x3
#define SDMA0_CNTL__FENCE_SWAP_ENABLE__SHIFT                                                                  0x4
#define SDMA0_CNTL__MIDCMD_PREEMPT_ENABLE__SHIFT                                                              0x5
#define SDMA0_CNTL__PAGE_INT_ENABLE__SHIFT                                                                    0x7
#define SDMA0_CNTL__CH_PERFCNT_ENABLE__SHIFT                                                                  0x10
#define SDMA0_CNTL__MIDCMD_WORLDSWITCH_ENABLE__SHIFT                                                          0x11
#define SDMA0_CNTL__AUTO_CTXSW_ENABLE__SHIFT                                                                  0x12
#define SDMA0_CNTL__CTXEMPTY_INT_ENABLE__SHIFT                                                                0x1c
#define SDMA0_CNTL__FROZEN_INT_ENABLE__SHIFT                                                                  0x1d
#define SDMA0_CNTL__IB_PREEMPT_INT_ENABLE__SHIFT                                                              0x1e
#define SDMA0_CNTL__TRAP_ENABLE_MASK                                                                          0x00000001L
#define SDMA0_CNTL__UTC_L1_ENABLE_MASK                                                                        0x00000002L
#define SDMA0_CNTL__SEM_WAIT_INT_ENABLE_MASK                                                                  0x00000004L
#define SDMA0_CNTL__DATA_SWAP_ENABLE_MASK                                                                     0x00000008L
#define SDMA0_CNTL__FENCE_SWAP_ENABLE_MASK                                                                    0x00000010L
#define SDMA0_CNTL__MIDCMD_PREEMPT_ENABLE_MASK                                                                0x00000020L
#define SDMA0_CNTL__PAGE_INT_ENABLE_MASK                                                                      0x00000080L
#define SDMA0_CNTL__CH_PERFCNT_ENABLE_MASK                                                                    0x00010000L
#define SDMA0_CNTL__MIDCMD_WORLDSWITCH_ENABLE_MASK                                                            0x00020000L
#define SDMA0_CNTL__AUTO_CTXSW_ENABLE_MASK                                                                    0x00040000L
#define SDMA0_CNTL__CTXEMPTY_INT_ENABLE_MASK                                                                  0x10000000L
#define SDMA0_CNTL__FROZEN_INT_ENABLE_MASK                                                                    0x20000000L
#define SDMA0_CNTL__IB_PREEMPT_INT_ENABLE_MASK                                                                0x40000000L
//SDMA0_CHICKEN_BITS
#define SDMA0_CHICKEN_BITS__COPY_EFFICIENCY_ENABLE__SHIFT                                                     0x0
#define SDMA0_CHICKEN_BITS__STALL_ON_TRANS_FULL_ENABLE__SHIFT                                                 0x1
#define SDMA0_CHICKEN_BITS__STALL_ON_NO_FREE_DATA_BUFFER_ENABLE__SHIFT                                        0x2
#define SDMA0_CHICKEN_BITS__SOFT_OVERRIDE_DCGE__SHIFT                                                         0x4
#define SDMA0_CHICKEN_BITS__SOFT_OVERRIDE_SDMA_GRBM_FGCG__SHIFT                                               0x5
#define SDMA0_CHICKEN_BITS__WRITE_BURST_LENGTH__SHIFT                                                         0x8
#define SDMA0_CHICKEN_BITS__WRITE_BURST_WAIT_CYCLE__SHIFT                                                     0xa
#define SDMA0_CHICKEN_BITS__COPY_OVERLAP_ENABLE__SHIFT                                                        0x10
#define SDMA0_CHICKEN_BITS__RAW_CHECK_ENABLE__SHIFT                                                           0x11
#define SDMA0_CHICKEN_BITS__T2L_256B_ENABLE__SHIFT                                                            0x12
#define SDMA0_CHICKEN_BITS__GCR_FGCG_ENABLE__SHIFT                                                            0x13
#define SDMA0_CHICKEN_BITS__SRBM_POLL_RETRYING__SHIFT                                                         0x14
#define SDMA0_CHICKEN_BITS__CH_FGCG_ENABLE__SHIFT                                                             0x15
#define SDMA0_CHICKEN_BITS__UTCL2_INVREQ_FGCG_ENABLE__SHIFT                                                   0x16
#define SDMA0_CHICKEN_BITS__CG_STATUS_OUTPUT__SHIFT                                                           0x17
#define SDMA0_CHICKEN_BITS__UTCL1_FGCG_ENABLE__SHIFT                                                          0x18
#define SDMA0_CHICKEN_BITS__TIME_BASED_QOS__SHIFT                                                             0x19
#define SDMA0_CHICKEN_BITS__CE_AFIFO_WATERMARK__SHIFT                                                         0x1a
#define SDMA0_CHICKEN_BITS__CE_DFIFO_WATERMARK__SHIFT                                                         0x1c
#define SDMA0_CHICKEN_BITS__CE_LFIFO_WATERMARK__SHIFT                                                         0x1e
#define SDMA0_CHICKEN_BITS__COPY_EFFICIENCY_ENABLE_MASK                                                       0x00000001L
#define SDMA0_CHICKEN_BITS__STALL_ON_TRANS_FULL_ENABLE_MASK                                                   0x00000002L
#define SDMA0_CHICKEN_BITS__STALL_ON_NO_FREE_DATA_BUFFER_ENABLE_MASK                                          0x00000004L
#define SDMA0_CHICKEN_BITS__SOFT_OVERRIDE_DCGE_MASK                                                           0x00000010L
#define SDMA0_CHICKEN_BITS__SOFT_OVERRIDE_SDMA_GRBM_FGCG_MASK                                                 0x00000020L
#define SDMA0_CHICKEN_BITS__WRITE_BURST_LENGTH_MASK                                                           0x00000300L
#define SDMA0_CHICKEN_BITS__WRITE_BURST_WAIT_CYCLE_MASK                                                       0x00001C00L
#define SDMA0_CHICKEN_BITS__COPY_OVERLAP_ENABLE_MASK                                                          0x00010000L
#define SDMA0_CHICKEN_BITS__RAW_CHECK_ENABLE_MASK                                                             0x00020000L
#define SDMA0_CHICKEN_BITS__T2L_256B_ENABLE_MASK                                                              0x00040000L
#define SDMA0_CHICKEN_BITS__GCR_FGCG_ENABLE_MASK                                                              0x00080000L
#define SDMA0_CHICKEN_BITS__SRBM_POLL_RETRYING_MASK                                                           0x00100000L
#define SDMA0_CHICKEN_BITS__CH_FGCG_ENABLE_MASK                                                               0x00200000L
#define SDMA0_CHICKEN_BITS__UTCL2_INVREQ_FGCG_ENABLE_MASK                                                     0x00400000L
#define SDMA0_CHICKEN_BITS__CG_STATUS_OUTPUT_MASK                                                             0x00800000L
#define SDMA0_CHICKEN_BITS__UTCL1_FGCG_ENABLE_MASK                                                            0x01000000L
#define SDMA0_CHICKEN_BITS__TIME_BASED_QOS_MASK                                                               0x02000000L
#define SDMA0_CHICKEN_BITS__CE_AFIFO_WATERMARK_MASK                                                           0x0C000000L
#define SDMA0_CHICKEN_BITS__CE_DFIFO_WATERMARK_MASK                                                           0x30000000L
#define SDMA0_CHICKEN_BITS__CE_LFIFO_WATERMARK_MASK                                                           0xC0000000L
//SDMA0_GB_ADDR_CONFIG
#define SDMA0_GB_ADDR_CONFIG__NUM_PIPES__SHIFT                                                                0x0
#define SDMA0_GB_ADDR_CONFIG__PIPE_INTERLEAVE_SIZE__SHIFT                                                     0x3
#define SDMA0_GB_ADDR_CONFIG__MAX_COMPRESSED_FRAGS__SHIFT                                                     0x6
#define SDMA0_GB_ADDR_CONFIG__NUM_PKRS__SHIFT                                                                 0x8
#define SDMA0_GB_ADDR_CONFIG__NUM_SHADER_ENGINES__SHIFT                                                       0x13
#define SDMA0_GB_ADDR_CONFIG__NUM_RB_PER_SE__SHIFT                                                            0x1a
#define SDMA0_GB_ADDR_CONFIG__NUM_PIPES_MASK                                                                  0x00000007L
#define SDMA0_GB_ADDR_CONFIG__PIPE_INTERLEAVE_SIZE_MASK                                                       0x00000038L
#define SDMA0_GB_ADDR_CONFIG__MAX_COMPRESSED_FRAGS_MASK                                                       0x000000C0L
#define SDMA0_GB_ADDR_CONFIG__NUM_PKRS_MASK                                                                   0x00000700L
#define SDMA0_GB_ADDR_CONFIG__NUM_SHADER_ENGINES_MASK                                                         0x00180000L
#define SDMA0_GB_ADDR_CONFIG__NUM_RB_PER_SE_MASK                                                              0x0C000000L
//SDMA0_GB_ADDR_CONFIG_READ
#define SDMA0_GB_ADDR_CONFIG_READ__NUM_PIPES__SHIFT                                                           0x0
#define SDMA0_GB_ADDR_CONFIG_READ__PIPE_INTERLEAVE_SIZE__SHIFT                                                0x3
#define SDMA0_GB_ADDR_CONFIG_READ__MAX_COMPRESSED_FRAGS__SHIFT                                                0x6
#define SDMA0_GB_ADDR_CONFIG_READ__NUM_PKRS__SHIFT                                                            0x8
#define SDMA0_GB_ADDR_CONFIG_READ__NUM_SHADER_ENGINES__SHIFT                                                  0x13
#define SDMA0_GB_ADDR_CONFIG_READ__NUM_RB_PER_SE__SHIFT                                                       0x1a
#define SDMA0_GB_ADDR_CONFIG_READ__NUM_PIPES_MASK                                                             0x00000007L
#define SDMA0_GB_ADDR_CONFIG_READ__PIPE_INTERLEAVE_SIZE_MASK                                                  0x00000038L
#define SDMA0_GB_ADDR_CONFIG_READ__MAX_COMPRESSED_FRAGS_MASK                                                  0x000000C0L
#define SDMA0_GB_ADDR_CONFIG_READ__NUM_PKRS_MASK                                                              0x00000700L
#define SDMA0_GB_ADDR_CONFIG_READ__NUM_SHADER_ENGINES_MASK                                                    0x00180000L
#define SDMA0_GB_ADDR_CONFIG_READ__NUM_RB_PER_SE_MASK                                                         0x0C000000L
//SDMA0_RB_RPTR_FETCH_HI
#define SDMA0_RB_RPTR_FETCH_HI__OFFSET__SHIFT                                                                 0x0
#define SDMA0_RB_RPTR_FETCH_HI__OFFSET_MASK                                                                   0xFFFFFFFFL
//SDMA0_SEM_WAIT_FAIL_TIMER_CNTL
#define SDMA0_SEM_WAIT_FAIL_TIMER_CNTL__TIMER__SHIFT                                                          0x0
#define SDMA0_SEM_WAIT_FAIL_TIMER_CNTL__TIMER_MASK                                                            0xFFFFFFFFL
//SDMA0_RB_RPTR_FETCH
#define SDMA0_RB_RPTR_FETCH__OFFSET__SHIFT                                                                    0x2
#define SDMA0_RB_RPTR_FETCH__OFFSET_MASK                                                                      0xFFFFFFFCL
//SDMA0_IB_OFFSET_FETCH
#define SDMA0_IB_OFFSET_FETCH__OFFSET__SHIFT                                                                  0x2
#define SDMA0_IB_OFFSET_FETCH__OFFSET_MASK                                                                    0x003FFFFCL
//SDMA0_PROGRAM
#define SDMA0_PROGRAM__STREAM__SHIFT                                                                          0x0
#define SDMA0_PROGRAM__STREAM_MASK                                                                            0xFFFFFFFFL
//SDMA0_STATUS_REG
#define SDMA0_STATUS_REG__IDLE__SHIFT                                                                         0x0
#define SDMA0_STATUS_REG__REG_IDLE__SHIFT                                                                     0x1
#define SDMA0_STATUS_REG__RB_EMPTY__SHIFT                                                                     0x2
#define SDMA0_STATUS_REG__RB_FULL__SHIFT                                                                      0x3
#define SDMA0_STATUS_REG__RB_CMD_IDLE__SHIFT                                                                  0x4
#define SDMA0_STATUS_REG__RB_CMD_FULL__SHIFT                                                                  0x5
#define SDMA0_STATUS_REG__IB_CMD_IDLE__SHIFT                                                                  0x6
#define SDMA0_STATUS_REG__IB_CMD_FULL__SHIFT                                                                  0x7
#define SDMA0_STATUS_REG__BLOCK_IDLE__SHIFT                                                                   0x8
#define SDMA0_STATUS_REG__INSIDE_IB__SHIFT                                                                    0x9
#define SDMA0_STATUS_REG__EX_IDLE__SHIFT                                                                      0xa
#define SDMA0_STATUS_REG__EX_IDLE_POLL_TIMER_EXPIRE__SHIFT                                                    0xb
#define SDMA0_STATUS_REG__PACKET_READY__SHIFT                                                                 0xc
#define SDMA0_STATUS_REG__MC_WR_IDLE__SHIFT                                                                   0xd
#define SDMA0_STATUS_REG__SRBM_IDLE__SHIFT                                                                    0xe
#define SDMA0_STATUS_REG__CONTEXT_EMPTY__SHIFT                                                                0xf
#define SDMA0_STATUS_REG__DELTA_RPTR_FULL__SHIFT                                                              0x10
#define SDMA0_STATUS_REG__RB_MC_RREQ_IDLE__SHIFT                                                              0x11
#define SDMA0_STATUS_REG__IB_MC_RREQ_IDLE__SHIFT                                                              0x12
#define SDMA0_STATUS_REG__MC_RD_IDLE__SHIFT                                                                   0x13
#define SDMA0_STATUS_REG__DELTA_RPTR_EMPTY__SHIFT                                                             0x14
#define SDMA0_STATUS_REG__MC_RD_RET_STALL__SHIFT                                                              0x15
#define SDMA0_STATUS_REG__MC_RD_NO_POLL_IDLE__SHIFT                                                           0x16
#define SDMA0_STATUS_REG__PREV_CMD_IDLE__SHIFT                                                                0x19
#define SDMA0_STATUS_REG__SEM_IDLE__SHIFT                                                                     0x1a
#define SDMA0_STATUS_REG__SEM_REQ_STALL__SHIFT                                                                0x1b
#define SDMA0_STATUS_REG__SEM_RESP_STATE__SHIFT                                                               0x1c
#define SDMA0_STATUS_REG__INT_IDLE__SHIFT                                                                     0x1e
#define SDMA0_STATUS_REG__INT_REQ_STALL__SHIFT                                                                0x1f
#define SDMA0_STATUS_REG__IDLE_MASK                                                                           0x00000001L
#define SDMA0_STATUS_REG__REG_IDLE_MASK                                                                       0x00000002L
#define SDMA0_STATUS_REG__RB_EMPTY_MASK                                                                       0x00000004L
#define SDMA0_STATUS_REG__RB_FULL_MASK                                                                        0x00000008L
#define SDMA0_STATUS_REG__RB_CMD_IDLE_MASK                                                                    0x00000010L
#define SDMA0_STATUS_REG__RB_CMD_FULL_MASK                                                                    0x00000020L
#define SDMA0_STATUS_REG__IB_CMD_IDLE_MASK                                                                    0x00000040L
#define SDMA0_STATUS_REG__IB_CMD_FULL_MASK                                                                    0x00000080L
#define SDMA0_STATUS_REG__BLOCK_IDLE_MASK                                                                     0x00000100L
#define SDMA0_STATUS_REG__INSIDE_IB_MASK                                                                      0x00000200L
#define SDMA0_STATUS_REG__EX_IDLE_MASK                                                                        0x00000400L
#define SDMA0_STATUS_REG__EX_IDLE_POLL_TIMER_EXPIRE_MASK                                                      0x00000800L
#define SDMA0_STATUS_REG__PACKET_READY_MASK                                                                   0x00001000L
#define SDMA0_STATUS_REG__MC_WR_IDLE_MASK                                                                     0x00002000L
#define SDMA0_STATUS_REG__SRBM_IDLE_MASK                                                                      0x00004000L
#define SDMA0_STATUS_REG__CONTEXT_EMPTY_MASK                                                                  0x00008000L
#define SDMA0_STATUS_REG__DELTA_RPTR_FULL_MASK                                                                0x00010000L
#define SDMA0_STATUS_REG__RB_MC_RREQ_IDLE_MASK                                                                0x00020000L
#define SDMA0_STATUS_REG__IB_MC_RREQ_IDLE_MASK                                                                0x00040000L
#define SDMA0_STATUS_REG__MC_RD_IDLE_MASK                                                                     0x00080000L
#define SDMA0_STATUS_REG__DELTA_RPTR_EMPTY_MASK                                                               0x00100000L
#define SDMA0_STATUS_REG__MC_RD_RET_STALL_MASK                                                                0x00200000L
#define SDMA0_STATUS_REG__MC_RD_NO_POLL_IDLE_MASK                                                             0x00400000L
#define SDMA0_STATUS_REG__PREV_CMD_IDLE_MASK                                                                  0x02000000L
#define SDMA0_STATUS_REG__SEM_IDLE_MASK                                                                       0x04000000L
#define SDMA0_STATUS_REG__SEM_REQ_STALL_MASK                                                                  0x08000000L
#define SDMA0_STATUS_REG__SEM_RESP_STATE_MASK                                                                 0x30000000L
#define SDMA0_STATUS_REG__INT_IDLE_MASK                                                                       0x40000000L
#define SDMA0_STATUS_REG__INT_REQ_STALL_MASK                                                                  0x80000000L
//SDMA0_STATUS1_REG
#define SDMA0_STATUS1_REG__CE_WREQ_IDLE__SHIFT                                                                0x0
#define SDMA0_STATUS1_REG__CE_WR_IDLE__SHIFT                                                                  0x1
#define SDMA0_STATUS1_REG__CE_SPLIT_IDLE__SHIFT                                                               0x2
#define SDMA0_STATUS1_REG__CE_RREQ_IDLE__SHIFT                                                                0x3
#define SDMA0_STATUS1_REG__CE_OUT_IDLE__SHIFT                                                                 0x4
#define SDMA0_STATUS1_REG__CE_IN_IDLE__SHIFT                                                                  0x5
#define SDMA0_STATUS1_REG__CE_DST_IDLE__SHIFT                                                                 0x6
#define SDMA0_STATUS1_REG__CE_CMD_IDLE__SHIFT                                                                 0x9
#define SDMA0_STATUS1_REG__CE_AFIFO_FULL__SHIFT                                                               0xa
#define SDMA0_STATUS1_REG__CE_INFO_FULL__SHIFT                                                                0xd
#define SDMA0_STATUS1_REG__CE_INFO1_FULL__SHIFT                                                               0xe
#define SDMA0_STATUS1_REG__EX_START__SHIFT                                                                    0xf
#define SDMA0_STATUS1_REG__CE_RD_STALL__SHIFT                                                                 0x11
#define SDMA0_STATUS1_REG__CE_WR_STALL__SHIFT                                                                 0x12
#define SDMA0_STATUS1_REG__CE_WREQ_IDLE_MASK                                                                  0x00000001L
#define SDMA0_STATUS1_REG__CE_WR_IDLE_MASK                                                                    0x00000002L
#define SDMA0_STATUS1_REG__CE_SPLIT_IDLE_MASK                                                                 0x00000004L
#define SDMA0_STATUS1_REG__CE_RREQ_IDLE_MASK                                                                  0x00000008L
#define SDMA0_STATUS1_REG__CE_OUT_IDLE_MASK                                                                   0x00000010L
#define SDMA0_STATUS1_REG__CE_IN_IDLE_MASK                                                                    0x00000020L
#define SDMA0_STATUS1_REG__CE_DST_IDLE_MASK                                                                   0x00000040L
#define SDMA0_STATUS1_REG__CE_CMD_IDLE_MASK                                                                   0x00000200L
#define SDMA0_STATUS1_REG__CE_AFIFO_FULL_MASK                                                                 0x00000400L
#define SDMA0_STATUS1_REG__CE_INFO_FULL_MASK                                                                  0x00002000L
#define SDMA0_STATUS1_REG__CE_INFO1_FULL_MASK                                                                 0x00004000L
#define SDMA0_STATUS1_REG__EX_START_MASK                                                                      0x00008000L
#define SDMA0_STATUS1_REG__CE_RD_STALL_MASK                                                                   0x00020000L
#define SDMA0_STATUS1_REG__CE_WR_STALL_MASK                                                                   0x00040000L
//SDMA0_RD_BURST_CNTL
#define SDMA0_RD_BURST_CNTL__RD_BURST__SHIFT                                                                  0x0
#define SDMA0_RD_BURST_CNTL__RD_BURST_MASK                                                                    0x00000003L
//SDMA0_HBM_PAGE_CONFIG
#define SDMA0_HBM_PAGE_CONFIG__PAGE_SIZE_EXPONENT__SHIFT                                                      0x0
#define SDMA0_HBM_PAGE_CONFIG__PAGE_SIZE_EXPONENT_MASK                                                        0x00000003L
//SDMA0_UCODE_CHECKSUM
#define SDMA0_UCODE_CHECKSUM__DATA__SHIFT                                                                     0x0
#define SDMA0_UCODE_CHECKSUM__DATA_MASK                                                                       0xFFFFFFFFL
//SDMA0_F32_CNTL
#define SDMA0_F32_CNTL__HALT__SHIFT                                                                           0x0
#define SDMA0_F32_CNTL__STEP__SHIFT                                                                           0x1
#define SDMA0_F32_CNTL__CHECKSUM_CLR__SHIFT                                                                   0x8
#define SDMA0_F32_CNTL__RESET__SHIFT                                                                          0x9
#define SDMA0_F32_CNTL__HALT_MASK                                                                             0x00000001L
#define SDMA0_F32_CNTL__STEP_MASK                                                                             0x00000002L
#define SDMA0_F32_CNTL__CHECKSUM_CLR_MASK                                                                     0x00000100L
#define SDMA0_F32_CNTL__RESET_MASK                                                                            0x00000200L
//SDMA0_FREEZE
#define SDMA0_FREEZE__PREEMPT__SHIFT                                                                          0x0
#define SDMA0_FREEZE__FORCE_PREEMPT__SHIFT                                                                    0x1
#define SDMA0_FREEZE__FREEZE__SHIFT                                                                           0x4
#define SDMA0_FREEZE__FROZEN__SHIFT                                                                           0x5
#define SDMA0_FREEZE__F32_FREEZE__SHIFT                                                                       0x6
#define SDMA0_FREEZE__PREEMPT_MASK                                                                            0x00000001L
#define SDMA0_FREEZE__FORCE_PREEMPT_MASK                                                                      0x00000002L
#define SDMA0_FREEZE__FREEZE_MASK                                                                             0x00000010L
#define SDMA0_FREEZE__FROZEN_MASK                                                                             0x00000020L
#define SDMA0_FREEZE__F32_FREEZE_MASK                                                                         0x00000040L
//SDMA0_PHASE0_QUANTUM
#define SDMA0_PHASE0_QUANTUM__UNIT__SHIFT                                                                     0x0
#define SDMA0_PHASE0_QUANTUM__VALUE__SHIFT                                                                    0x8
#define SDMA0_PHASE0_QUANTUM__PREFER__SHIFT                                                                   0x1e
#define SDMA0_PHASE0_QUANTUM__UNIT_MASK                                                                       0x0000000FL
#define SDMA0_PHASE0_QUANTUM__VALUE_MASK                                                                      0x00FFFF00L
#define SDMA0_PHASE0_QUANTUM__PREFER_MASK                                                                     0x40000000L
//SDMA0_PHASE1_QUANTUM
#define SDMA0_PHASE1_QUANTUM__UNIT__SHIFT                                                                     0x0
#define SDMA0_PHASE1_QUANTUM__VALUE__SHIFT                                                                    0x8
#define SDMA0_PHASE1_QUANTUM__PREFER__SHIFT                                                                   0x1e
#define SDMA0_PHASE1_QUANTUM__UNIT_MASK                                                                       0x0000000FL
#define SDMA0_PHASE1_QUANTUM__VALUE_MASK                                                                      0x00FFFF00L
#define SDMA0_PHASE1_QUANTUM__PREFER_MASK                                                                     0x40000000L
//SDMA0_EDC_CONFIG
#define SDMA0_EDC_CONFIG__DIS_EDC__SHIFT                                                                      0x1
#define SDMA0_EDC_CONFIG__ECC_INT_ENABLE__SHIFT                                                               0x2
#define SDMA0_EDC_CONFIG__DIS_EDC_MASK                                                                        0x00000002L
#define SDMA0_EDC_CONFIG__ECC_INT_ENABLE_MASK                                                                 0x00000004L
//SDMA0_BA_THRESHOLD
#define SDMA0_BA_THRESHOLD__READ_THRES__SHIFT                                                                 0x0
#define SDMA0_BA_THRESHOLD__WRITE_THRES__SHIFT                                                                0x10
#define SDMA0_BA_THRESHOLD__READ_THRES_MASK                                                                   0x000003FFL
#define SDMA0_BA_THRESHOLD__WRITE_THRES_MASK                                                                  0x03FF0000L
//SDMA0_ID
#define SDMA0_ID__DEVICE_ID__SHIFT                                                                            0x0
#define SDMA0_ID__DEVICE_ID_MASK                                                                              0x000000FFL
//SDMA0_VERSION
#define SDMA0_VERSION__MINVER__SHIFT                                                                          0x0
#define SDMA0_VERSION__MAJVER__SHIFT                                                                          0x8
#define SDMA0_VERSION__REV__SHIFT                                                                             0x10
#define SDMA0_VERSION__MINVER_MASK                                                                            0x0000007FL
#define SDMA0_VERSION__MAJVER_MASK                                                                            0x00007F00L
#define SDMA0_VERSION__REV_MASK                                                                               0x003F0000L
//SDMA0_EDC_COUNTER
#define SDMA0_EDC_COUNTER__SDMA_UCODE_BUF_DED__SHIFT                                                          0x0
#define SDMA0_EDC_COUNTER__SDMA_UCODE_BUF_SEC__SHIFT                                                          0x1
#define SDMA0_EDC_COUNTER__SDMA_RB_CMD_BUF_SED__SHIFT                                                         0x2
#define SDMA0_EDC_COUNTER__SDMA_IB_CMD_BUF_SED__SHIFT                                                         0x3
#define SDMA0_EDC_COUNTER__SDMA_UTCL1_RD_FIFO_SED__SHIFT                                                      0x4
#define SDMA0_EDC_COUNTER__SDMA_UTCL1_RDBST_FIFO_SED__SHIFT                                                   0x5
#define SDMA0_EDC_COUNTER__SDMA_DATA_LUT_FIFO_SED__SHIFT                                                      0x6
#define SDMA0_EDC_COUNTER__SDMA_MBANK_DATA_BUF0_SED__SHIFT                                                    0x7
#define SDMA0_EDC_COUNTER__SDMA_MBANK_DATA_BUF1_SED__SHIFT                                                    0x8
#define SDMA0_EDC_COUNTER__SDMA_MBANK_DATA_BUF2_SED__SHIFT                                                    0x9
#define SDMA0_EDC_COUNTER__SDMA_MBANK_DATA_BUF3_SED__SHIFT                                                    0xa
#define SDMA0_EDC_COUNTER__SDMA_MBANK_DATA_BUF4_SED__SHIFT                                                    0xb
#define SDMA0_EDC_COUNTER__SDMA_MBANK_DATA_BUF5_SED__SHIFT                                                    0xc
#define SDMA0_EDC_COUNTER__SDMA_MBANK_DATA_BUF6_SED__SHIFT                                                    0xd
#define SDMA0_EDC_COUNTER__SDMA_MBANK_DATA_BUF7_SED__SHIFT                                                    0xe
#define SDMA0_EDC_COUNTER__SDMA_SPLIT_DAT_BUF_SED__SHIFT                                                      0xf
#define SDMA0_EDC_COUNTER__SDMA_MC_WR_ADDR_FIFO_SED__SHIFT                                                    0x10
#define SDMA0_EDC_COUNTER__SDMA_UCODE_BUF_DED_MASK                                                            0x00000001L
#define SDMA0_EDC_COUNTER__SDMA_UCODE_BUF_SEC_MASK                                                            0x00000002L
#define SDMA0_EDC_COUNTER__SDMA_RB_CMD_BUF_SED_MASK                                                           0x00000004L
#define SDMA0_EDC_COUNTER__SDMA_IB_CMD_BUF_SED_MASK                                                           0x00000008L
#define SDMA0_EDC_COUNTER__SDMA_UTCL1_RD_FIFO_SED_MASK                                                        0x00000010L
#define SDMA0_EDC_COUNTER__SDMA_UTCL1_RDBST_FIFO_SED_MASK                                                     0x00000020L
#define SDMA0_EDC_COUNTER__SDMA_DATA_LUT_FIFO_SED_MASK                                                        0x00000040L
#define SDMA0_EDC_COUNTER__SDMA_MBANK_DATA_BUF0_SED_MASK                                                      0x00000080L
#define SDMA0_EDC_COUNTER__SDMA_MBANK_DATA_BUF1_SED_MASK                                                      0x00000100L
#define SDMA0_EDC_COUNTER__SDMA_MBANK_DATA_BUF2_SED_MASK                                                      0x00000200L
#define SDMA0_EDC_COUNTER__SDMA_MBANK_DATA_BUF3_SED_MASK                                                      0x00000400L
#define SDMA0_EDC_COUNTER__SDMA_MBANK_DATA_BUF4_SED_MASK                                                      0x00000800L
#define SDMA0_EDC_COUNTER__SDMA_MBANK_DATA_BUF5_SED_MASK                                                      0x00001000L
#define SDMA0_EDC_COUNTER__SDMA_MBANK_DATA_BUF6_SED_MASK                                                      0x00002000L
#define SDMA0_EDC_COUNTER__SDMA_MBANK_DATA_BUF7_SED_MASK                                                      0x00004000L
#define SDMA0_EDC_COUNTER__SDMA_SPLIT_DAT_BUF_SED_MASK                                                        0x00008000L
#define SDMA0_EDC_COUNTER__SDMA_MC_WR_ADDR_FIFO_SED_MASK                                                      0x00010000L
//SDMA0_EDC_COUNTER_CLEAR
#define SDMA0_EDC_COUNTER_CLEAR__DUMMY__SHIFT                                                                 0x0
#define SDMA0_EDC_COUNTER_CLEAR__DUMMY_MASK                                                                   0x00000001L
//SDMA0_STATUS2_REG
#define SDMA0_STATUS2_REG__ID__SHIFT                                                                          0x0
#define SDMA0_STATUS2_REG__F32_INSTR_PTR__SHIFT                                                               0x2
#define SDMA0_STATUS2_REG__CMD_OP__SHIFT                                                                      0x10
#define SDMA0_STATUS2_REG__ID_MASK                                                                            0x00000003L
#define SDMA0_STATUS2_REG__F32_INSTR_PTR_MASK                                                                 0x0000FFFCL
#define SDMA0_STATUS2_REG__CMD_OP_MASK                                                                        0xFFFF0000L
//SDMA0_ATOMIC_CNTL
#define SDMA0_ATOMIC_CNTL__LOOP_TIMER__SHIFT                                                                  0x0
#define SDMA0_ATOMIC_CNTL__ATOMIC_RTN_INT_ENABLE__SHIFT                                                       0x1f
#define SDMA0_ATOMIC_CNTL__LOOP_TIMER_MASK                                                                    0x7FFFFFFFL
#define SDMA0_ATOMIC_CNTL__ATOMIC_RTN_INT_ENABLE_MASK                                                         0x80000000L
//SDMA0_ATOMIC_PREOP_LO
#define SDMA0_ATOMIC_PREOP_LO__DATA__SHIFT                                                                    0x0
#define SDMA0_ATOMIC_PREOP_LO__DATA_MASK                                                                      0xFFFFFFFFL
//SDMA0_ATOMIC_PREOP_HI
#define SDMA0_ATOMIC_PREOP_HI__DATA__SHIFT                                                                    0x0
#define SDMA0_ATOMIC_PREOP_HI__DATA_MASK                                                                      0xFFFFFFFFL
//SDMA0_UTCL1_CNTL
#define SDMA0_UTCL1_CNTL__REDO_ENABLE__SHIFT                                                                  0x0
#define SDMA0_UTCL1_CNTL__REDO_DELAY__SHIFT                                                                   0x1
#define SDMA0_UTCL1_CNTL__REDO_WATERMK__SHIFT                                                                 0x6
#define SDMA0_UTCL1_CNTL__RESP_MODE__SHIFT                                                                    0x9
#define SDMA0_UTCL1_CNTL__FORCE_INVALIDATION__SHIFT                                                           0xe
#define SDMA0_UTCL1_CNTL__FORCE_INVREQ_HEAVY__SHIFT                                                           0xf
#define SDMA0_UTCL1_CNTL__INVACK_DELAY__SHIFT                                                                 0x10
#define SDMA0_UTCL1_CNTL__REQL2_CREDIT__SHIFT                                                                 0x18
#define SDMA0_UTCL1_CNTL__VADDR_WATERMK__SHIFT                                                                0x1d
#define SDMA0_UTCL1_CNTL__REDO_ENABLE_MASK                                                                    0x00000001L
#define SDMA0_UTCL1_CNTL__REDO_DELAY_MASK                                                                     0x0000003EL
#define SDMA0_UTCL1_CNTL__REDO_WATERMK_MASK                                                                   0x000001C0L
#define SDMA0_UTCL1_CNTL__RESP_MODE_MASK                                                                      0x00000E00L
#define SDMA0_UTCL1_CNTL__FORCE_INVALIDATION_MASK                                                             0x00004000L
#define SDMA0_UTCL1_CNTL__FORCE_INVREQ_HEAVY_MASK                                                             0x00008000L
#define SDMA0_UTCL1_CNTL__INVACK_DELAY_MASK                                                                   0x00FF0000L
#define SDMA0_UTCL1_CNTL__REQL2_CREDIT_MASK                                                                   0x1F000000L
#define SDMA0_UTCL1_CNTL__VADDR_WATERMK_MASK                                                                  0xE0000000L
//SDMA0_UTCL1_WATERMK
#define SDMA0_UTCL1_WATERMK__REQMC_WATERMK__SHIFT                                                             0x0
#define SDMA0_UTCL1_WATERMK__REQPG_WATERMK__SHIFT                                                             0xa
#define SDMA0_UTCL1_WATERMK__INVREQ_WATERMK__SHIFT                                                            0x12
#define SDMA0_UTCL1_WATERMK__XNACK_WATERMK__SHIFT                                                             0x1a
#define SDMA0_UTCL1_WATERMK__REQMC_WATERMK_MASK                                                               0x000003FFL
#define SDMA0_UTCL1_WATERMK__REQPG_WATERMK_MASK                                                               0x0003FC00L
#define SDMA0_UTCL1_WATERMK__INVREQ_WATERMK_MASK                                                              0x03FC0000L
#define SDMA0_UTCL1_WATERMK__XNACK_WATERMK_MASK                                                               0xFC000000L
//SDMA0_UTCL1_RD_STATUS
#define SDMA0_UTCL1_RD_STATUS__RQMC_RET_ADDR_FIFO_EMPTY__SHIFT                                                0x0
#define SDMA0_UTCL1_RD_STATUS__RQMC_RET_ADDR_FIFO_FULL__SHIFT                                                 0x1
#define SDMA0_UTCL1_RD_STATUS__RQMC_REQ_FIFO_EMPTY__SHIFT                                                     0x2
#define SDMA0_UTCL1_RD_STATUS__RQMC_REQ_FIFO_FULL__SHIFT                                                      0x3
#define SDMA0_UTCL1_RD_STATUS__RTPG_RET_BUF_EMPTY__SHIFT                                                      0x4
#define SDMA0_UTCL1_RD_STATUS__RTPG_RET_BUF_FULL__SHIFT                                                       0x5
#define SDMA0_UTCL1_RD_STATUS__RTPG_VADDR_FIFO_EMPTY__SHIFT                                                   0x6
#define SDMA0_UTCL1_RD_STATUS__RTPG_VADDR_FIFO_FULL__SHIFT                                                    0x7
#define SDMA0_UTCL1_RD_STATUS__RQPG_REDO_FIFO_EMPTY__SHIFT                                                    0x8
#define SDMA0_UTCL1_RD_STATUS__RQPG_REDO_FIFO_FULL__SHIFT                                                     0x9
#define SDMA0_UTCL1_RD_STATUS__RQPG_REQPAGE_FIFO_EMPTY__SHIFT                                                 0xa
#define SDMA0_UTCL1_RD_STATUS__RQPG_REQPAGE_FIFO_FULL__SHIFT                                                  0xb
#define SDMA0_UTCL1_RD_STATUS__REDO_ARR_EMPTY__SHIFT                                                          0xc
#define SDMA0_UTCL1_RD_STATUS__REDO_ARR_FULL__SHIFT                                                           0xd
#define SDMA0_UTCL1_RD_STATUS__PAGE_FAULT__SHIFT                                                              0xe
#define SDMA0_UTCL1_RD_STATUS__PAGE_NULL__SHIFT                                                               0xf
#define SDMA0_UTCL1_RD_STATUS__REQL2_IDLE__SHIFT                                                              0x10
#define SDMA0_UTCL1_RD_STATUS__NEXT_RD_VECTOR__SHIFT                                                          0x11
#define SDMA0_UTCL1_RD_STATUS__MERGE_STATE__SHIFT                                                             0x15
#define SDMA0_UTCL1_RD_STATUS__ADDR_RD_RTR__SHIFT                                                             0x18
#define SDMA0_UTCL1_RD_STATUS__RD_XNACK_TIMEOUT__SHIFT                                                        0x19
#define SDMA0_UTCL1_RD_STATUS__PAGE_NULL_SW__SHIFT                                                            0x1a
#define SDMA0_UTCL1_RD_STATUS__HIT_CACHE__SHIFT                                                               0x1b
#define SDMA0_UTCL1_RD_STATUS__RD_DCC_ENABLE__SHIFT                                                           0x1c
#define SDMA0_UTCL1_RD_STATUS__NACK_TIMEOUT_SW__SHIFT                                                         0x1d
#define SDMA0_UTCL1_RD_STATUS__DCC_PAGE_FAULT__SHIFT                                                          0x1e
#define SDMA0_UTCL1_RD_STATUS__DCC_PAGE_NULL__SHIFT                                                           0x1f
#define SDMA0_UTCL1_RD_STATUS__RQMC_RET_ADDR_FIFO_EMPTY_MASK                                                  0x00000001L
#define SDMA0_UTCL1_RD_STATUS__RQMC_RET_ADDR_FIFO_FULL_MASK                                                   0x00000002L
#define SDMA0_UTCL1_RD_STATUS__RQMC_REQ_FIFO_EMPTY_MASK                                                       0x00000004L
#define SDMA0_UTCL1_RD_STATUS__RQMC_REQ_FIFO_FULL_MASK                                                        0x00000008L
#define SDMA0_UTCL1_RD_STATUS__RTPG_RET_BUF_EMPTY_MASK                                                        0x00000010L
#define SDMA0_UTCL1_RD_STATUS__RTPG_RET_BUF_FULL_MASK                                                         0x00000020L
#define SDMA0_UTCL1_RD_STATUS__RTPG_VADDR_FIFO_EMPTY_MASK                                                     0x00000040L
#define SDMA0_UTCL1_RD_STATUS__RTPG_VADDR_FIFO_FULL_MASK                                                      0x00000080L
#define SDMA0_UTCL1_RD_STATUS__RQPG_REDO_FIFO_EMPTY_MASK                                                      0x00000100L
#define SDMA0_UTCL1_RD_STATUS__RQPG_REDO_FIFO_FULL_MASK                                                       0x00000200L
#define SDMA0_UTCL1_RD_STATUS__RQPG_REQPAGE_FIFO_EMPTY_MASK                                                   0x00000400L
#define SDMA0_UTCL1_RD_STATUS__RQPG_REQPAGE_FIFO_FULL_MASK                                                    0x00000800L
#define SDMA0_UTCL1_RD_STATUS__REDO_ARR_EMPTY_MASK                                                            0x00001000L
#define SDMA0_UTCL1_RD_STATUS__REDO_ARR_FULL_MASK                                                             0x00002000L
#define SDMA0_UTCL1_RD_STATUS__PAGE_FAULT_MASK                                                                0x00004000L
#define SDMA0_UTCL1_RD_STATUS__PAGE_NULL_MASK                                                                 0x00008000L
#define SDMA0_UTCL1_RD_STATUS__REQL2_IDLE_MASK                                                                0x00010000L
#define SDMA0_UTCL1_RD_STATUS__NEXT_RD_VECTOR_MASK                                                            0x001E0000L
#define SDMA0_UTCL1_RD_STATUS__MERGE_STATE_MASK                                                               0x00E00000L
#define SDMA0_UTCL1_RD_STATUS__ADDR_RD_RTR_MASK                                                               0x01000000L
#define SDMA0_UTCL1_RD_STATUS__RD_XNACK_TIMEOUT_MASK                                                          0x02000000L
#define SDMA0_UTCL1_RD_STATUS__PAGE_NULL_SW_MASK                                                              0x04000000L
#define SDMA0_UTCL1_RD_STATUS__HIT_CACHE_MASK                                                                 0x08000000L
#define SDMA0_UTCL1_RD_STATUS__RD_DCC_ENABLE_MASK                                                             0x10000000L
#define SDMA0_UTCL1_RD_STATUS__NACK_TIMEOUT_SW_MASK                                                           0x20000000L
#define SDMA0_UTCL1_RD_STATUS__DCC_PAGE_FAULT_MASK                                                            0x40000000L
#define SDMA0_UTCL1_RD_STATUS__DCC_PAGE_NULL_MASK                                                             0x80000000L
//SDMA0_UTCL1_WR_STATUS
#define SDMA0_UTCL1_WR_STATUS__RQMC_RET_ADDR_FIFO_EMPTY__SHIFT                                                0x0
#define SDMA0_UTCL1_WR_STATUS__RQMC_RET_ADDR_FIFO_FULL__SHIFT                                                 0x1
#define SDMA0_UTCL1_WR_STATUS__RQMC_REQ_FIFO_EMPTY__SHIFT                                                     0x2
#define SDMA0_UTCL1_WR_STATUS__RQMC_REQ_FIFO_FULL__SHIFT                                                      0x3
#define SDMA0_UTCL1_WR_STATUS__RTPG_RET_BUF_EMPTY__SHIFT                                                      0x4
#define SDMA0_UTCL1_WR_STATUS__RTPG_RET_BUF_FULL__SHIFT                                                       0x5
#define SDMA0_UTCL1_WR_STATUS__RTPG_VADDR_FIFO_EMPTY__SHIFT                                                   0x6
#define SDMA0_UTCL1_WR_STATUS__RTPG_VADDR_FIFO_FULL__SHIFT                                                    0x7
#define SDMA0_UTCL1_WR_STATUS__RQPG_REDO_FIFO_EMPTY__SHIFT                                                    0x8
#define SDMA0_UTCL1_WR_STATUS__RQPG_REDO_FIFO_FULL__SHIFT                                                     0x9
#define SDMA0_UTCL1_WR_STATUS__RQPG_REQPAGE_FIFO_EMPTY__SHIFT                                                 0xa
#define SDMA0_UTCL1_WR_STATUS__RQPG_REQPAGE_FIFO_FULL__SHIFT                                                  0xb
#define SDMA0_UTCL1_WR_STATUS__REDO_ARR_EMPTY__SHIFT                                                          0xc
#define SDMA0_UTCL1_WR_STATUS__REDO_ARR_FULL__SHIFT                                                           0xd
#define SDMA0_UTCL1_WR_STATUS__PAGE_FAULT__SHIFT                                                              0xe
#define SDMA0_UTCL1_WR_STATUS__PAGE_NULL__SHIFT                                                               0xf
#define SDMA0_UTCL1_WR_STATUS__REQL2_IDLE__SHIFT                                                              0x10
#define SDMA0_UTCL1_WR_STATUS__NEXT_WR_VECTOR__SHIFT                                                          0x11
#define SDMA0_UTCL1_WR_STATUS__MERGE_STATE__SHIFT                                                             0x15
#define SDMA0_UTCL1_WR_STATUS__F32_WR_RTR__SHIFT                                                              0x18
#define SDMA0_UTCL1_WR_STATUS__WR_XNACK_TIMEOUT__SHIFT                                                        0x19
#define SDMA0_UTCL1_WR_STATUS__PAGE_NULL_SW__SHIFT                                                            0x1a
#define SDMA0_UTCL1_WR_STATUS__ATOMIC_OP__SHIFT                                                               0x1b
#define SDMA0_UTCL1_WR_STATUS__RPTR_DATA_FIFO_EMPTY__SHIFT                                                    0x1c
#define SDMA0_UTCL1_WR_STATUS__RPTR_DATA_FIFO_FULL__SHIFT                                                     0x1d
#define SDMA0_UTCL1_WR_STATUS__WRREQ_DATA_FIFO_EMPTY__SHIFT                                                   0x1e
#define SDMA0_UTCL1_WR_STATUS__WRREQ_DATA_FIFO_FULL__SHIFT                                                    0x1f
#define SDMA0_UTCL1_WR_STATUS__RQMC_RET_ADDR_FIFO_EMPTY_MASK                                                  0x00000001L
#define SDMA0_UTCL1_WR_STATUS__RQMC_RET_ADDR_FIFO_FULL_MASK                                                   0x00000002L
#define SDMA0_UTCL1_WR_STATUS__RQMC_REQ_FIFO_EMPTY_MASK                                                       0x00000004L
#define SDMA0_UTCL1_WR_STATUS__RQMC_REQ_FIFO_FULL_MASK                                                        0x00000008L
#define SDMA0_UTCL1_WR_STATUS__RTPG_RET_BUF_EMPTY_MASK                                                        0x00000010L
#define SDMA0_UTCL1_WR_STATUS__RTPG_RET_BUF_FULL_MASK                                                         0x00000020L
#define SDMA0_UTCL1_WR_STATUS__RTPG_VADDR_FIFO_EMPTY_MASK                                                     0x00000040L
#define SDMA0_UTCL1_WR_STATUS__RTPG_VADDR_FIFO_FULL_MASK                                                      0x00000080L
#define SDMA0_UTCL1_WR_STATUS__RQPG_REDO_FIFO_EMPTY_MASK                                                      0x00000100L
#define SDMA0_UTCL1_WR_STATUS__RQPG_REDO_FIFO_FULL_MASK                                                       0x00000200L
#define SDMA0_UTCL1_WR_STATUS__RQPG_REQPAGE_FIFO_EMPTY_MASK                                                   0x00000400L
#define SDMA0_UTCL1_WR_STATUS__RQPG_REQPAGE_FIFO_FULL_MASK                                                    0x00000800L
#define SDMA0_UTCL1_WR_STATUS__REDO_ARR_EMPTY_MASK                                                            0x00001000L
#define SDMA0_UTCL1_WR_STATUS__REDO_ARR_FULL_MASK                                                             0x00002000L
#define SDMA0_UTCL1_WR_STATUS__PAGE_FAULT_MASK                                                                0x00004000L
#define SDMA0_UTCL1_WR_STATUS__PAGE_NULL_MASK                                                                 0x00008000L
#define SDMA0_UTCL1_WR_STATUS__REQL2_IDLE_MASK                                                                0x00010000L
#define SDMA0_UTCL1_WR_STATUS__NEXT_WR_VECTOR_MASK                                                            0x001E0000L
#define SDMA0_UTCL1_WR_STATUS__MERGE_STATE_MASK                                                               0x00E00000L
#define SDMA0_UTCL1_WR_STATUS__F32_WR_RTR_MASK                                                                0x01000000L
#define SDMA0_UTCL1_WR_STATUS__WR_XNACK_TIMEOUT_MASK                                                          0x02000000L
#define SDMA0_UTCL1_WR_STATUS__PAGE_NULL_SW_MASK                                                              0x04000000L
#define SDMA0_UTCL1_WR_STATUS__ATOMIC_OP_MASK                                                                 0x08000000L
#define SDMA0_UTCL1_WR_STATUS__RPTR_DATA_FIFO_EMPTY_MASK                                                      0x10000000L
#define SDMA0_UTCL1_WR_STATUS__RPTR_DATA_FIFO_FULL_MASK                                                       0x20000000L
#define SDMA0_UTCL1_WR_STATUS__WRREQ_DATA_FIFO_EMPTY_MASK                                                     0x40000000L
#define SDMA0_UTCL1_WR_STATUS__WRREQ_DATA_FIFO_FULL_MASK                                                      0x80000000L
//SDMA0_UTCL1_INV0
#define SDMA0_UTCL1_INV0__CPF_INVREQ_EN__SHIFT                                                                0x0
#define SDMA0_UTCL1_INV0__GPUVM_INVREQ_EN__SHIFT                                                              0x1
#define SDMA0_UTCL1_INV0__CPF_GPA_INVREQ__SHIFT                                                               0x2
#define SDMA0_UTCL1_INV0__GPUVM_INVREQ_LOW__SHIFT                                                             0x3
#define SDMA0_UTCL1_INV0__GPUVM_INVREQ_HIGH__SHIFT                                                            0x4
#define SDMA0_UTCL1_INV0__INVREQ_SIZE__SHIFT                                                                  0x5
#define SDMA0_UTCL1_INV0__INVREQ_IDLE__SHIFT                                                                  0xb
#define SDMA0_UTCL1_INV0__VMINV_PEND_CNT__SHIFT                                                               0xc
#define SDMA0_UTCL1_INV0__GPUVM_LO_INV_VMID__SHIFT                                                            0x10
#define SDMA0_UTCL1_INV0__GPUVM_HI_INV_VMID__SHIFT                                                            0x14
#define SDMA0_UTCL1_INV0__GPUVM_INV_MODE__SHIFT                                                               0x18
#define SDMA0_UTCL1_INV0__INVREQ_IS_HEAVY__SHIFT                                                              0x1a
#define SDMA0_UTCL1_INV0__INVREQ_FROM_CPF__SHIFT                                                              0x1b
#define SDMA0_UTCL1_INV0__GPUVM_INVREQ_TAG__SHIFT                                                             0x1c
#define SDMA0_UTCL1_INV0__CPF_INVREQ_EN_MASK                                                                  0x00000001L
#define SDMA0_UTCL1_INV0__GPUVM_INVREQ_EN_MASK                                                                0x00000002L
#define SDMA0_UTCL1_INV0__CPF_GPA_INVREQ_MASK                                                                 0x00000004L
#define SDMA0_UTCL1_INV0__GPUVM_INVREQ_LOW_MASK                                                               0x00000008L
#define SDMA0_UTCL1_INV0__GPUVM_INVREQ_HIGH_MASK                                                              0x00000010L
#define SDMA0_UTCL1_INV0__INVREQ_SIZE_MASK                                                                    0x000007E0L
#define SDMA0_UTCL1_INV0__INVREQ_IDLE_MASK                                                                    0x00000800L
#define SDMA0_UTCL1_INV0__VMINV_PEND_CNT_MASK                                                                 0x0000F000L
#define SDMA0_UTCL1_INV0__GPUVM_LO_INV_VMID_MASK                                                              0x000F0000L
#define SDMA0_UTCL1_INV0__GPUVM_HI_INV_VMID_MASK                                                              0x00F00000L
#define SDMA0_UTCL1_INV0__GPUVM_INV_MODE_MASK                                                                 0x03000000L
#define SDMA0_UTCL1_INV0__INVREQ_IS_HEAVY_MASK                                                                0x04000000L
#define SDMA0_UTCL1_INV0__INVREQ_FROM_CPF_MASK                                                                0x08000000L
#define SDMA0_UTCL1_INV0__GPUVM_INVREQ_TAG_MASK                                                               0xF0000000L
//SDMA0_UTCL1_INV1
#define SDMA0_UTCL1_INV1__INV_ADDR_LO__SHIFT                                                                  0x0
#define SDMA0_UTCL1_INV1__INV_ADDR_LO_MASK                                                                    0xFFFFFFFFL
//SDMA0_UTCL1_INV2
#define SDMA0_UTCL1_INV2__INV_VMID_VEC__SHIFT                                                                 0x0
#define SDMA0_UTCL1_INV2__RESERVED__SHIFT                                                                     0x10
#define SDMA0_UTCL1_INV2__INV_VMID_VEC_MASK                                                                   0x0000FFFFL
#define SDMA0_UTCL1_INV2__RESERVED_MASK                                                                       0xFFFF0000L
//SDMA0_UTCL1_RD_XNACK0
#define SDMA0_UTCL1_RD_XNACK0__XNACK_ADDR_LO__SHIFT                                                           0x0
#define SDMA0_UTCL1_RD_XNACK0__XNACK_ADDR_LO_MASK                                                             0xFFFFFFFFL
//SDMA0_UTCL1_RD_XNACK1
#define SDMA0_UTCL1_RD_XNACK1__XNACK_ADDR_HI__SHIFT                                                           0x0
#define SDMA0_UTCL1_RD_XNACK1__XNACK_VMID__SHIFT                                                              0x4
#define SDMA0_UTCL1_RD_XNACK1__XNACK_VECTOR__SHIFT                                                            0x8
#define SDMA0_UTCL1_RD_XNACK1__IS_XNACK__SHIFT                                                                0x1a
#define SDMA0_UTCL1_RD_XNACK1__XNACK_ADDR_HI_MASK                                                             0x0000000FL
#define SDMA0_UTCL1_RD_XNACK1__XNACK_VMID_MASK                                                                0x000000F0L
#define SDMA0_UTCL1_RD_XNACK1__XNACK_VECTOR_MASK                                                              0x03FFFF00L
#define SDMA0_UTCL1_RD_XNACK1__IS_XNACK_MASK                                                                  0x0C000000L
//SDMA0_UTCL1_WR_XNACK0
#define SDMA0_UTCL1_WR_XNACK0__XNACK_ADDR_LO__SHIFT                                                           0x0
#define SDMA0_UTCL1_WR_XNACK0__XNACK_ADDR_LO_MASK                                                             0xFFFFFFFFL
//SDMA0_UTCL1_WR_XNACK1
#define SDMA0_UTCL1_WR_XNACK1__XNACK_ADDR_HI__SHIFT                                                           0x0
#define SDMA0_UTCL1_WR_XNACK1__XNACK_VMID__SHIFT                                                              0x4
#define SDMA0_UTCL1_WR_XNACK1__XNACK_VECTOR__SHIFT                                                            0x8
#define SDMA0_UTCL1_WR_XNACK1__IS_XNACK__SHIFT                                                                0x1a
#define SDMA0_UTCL1_WR_XNACK1__XNACK_ADDR_HI_MASK                                                             0x0000000FL
#define SDMA0_UTCL1_WR_XNACK1__XNACK_VMID_MASK                                                                0x000000F0L
#define SDMA0_UTCL1_WR_XNACK1__XNACK_VECTOR_MASK                                                              0x03FFFF00L
#define SDMA0_UTCL1_WR_XNACK1__IS_XNACK_MASK                                                                  0x0C000000L
//SDMA0_UTCL1_TIMEOUT
#define SDMA0_UTCL1_TIMEOUT__RD_XNACK_LIMIT__SHIFT                                                            0x0
#define SDMA0_UTCL1_TIMEOUT__WR_XNACK_LIMIT__SHIFT                                                            0x10
#define SDMA0_UTCL1_TIMEOUT__RD_XNACK_LIMIT_MASK                                                              0x0000FFFFL
#define SDMA0_UTCL1_TIMEOUT__WR_XNACK_LIMIT_MASK                                                              0xFFFF0000L
//SDMA0_UTCL1_PAGE
#define SDMA0_UTCL1_PAGE__VM_HOLE__SHIFT                                                                      0x0
#define SDMA0_UTCL1_PAGE__REQ_TYPE__SHIFT                                                                     0x1
#define SDMA0_UTCL1_PAGE__USE_MTYPE__SHIFT                                                                    0x6
#define SDMA0_UTCL1_PAGE__USE_PT_SNOOP__SHIFT                                                                 0xa
#define SDMA0_UTCL1_PAGE__USE_IO__SHIFT                                                                       0xb
#define SDMA0_UTCL1_PAGE__RD_L2_POLICY__SHIFT                                                                 0xc
#define SDMA0_UTCL1_PAGE__WR_L2_POLICY__SHIFT                                                                 0xe
#define SDMA0_UTCL1_PAGE__DMA_PAGE_SIZE__SHIFT                                                                0x10
#define SDMA0_UTCL1_PAGE__USE_BC__SHIFT                                                                       0x16
#define SDMA0_UTCL1_PAGE__ADDR_IS_PA__SHIFT                                                                   0x17
#define SDMA0_UTCL1_PAGE__LLC_NOALLOC__SHIFT                                                                  0x18
#define SDMA0_UTCL1_PAGE__VM_HOLE_MASK                                                                        0x00000001L
#define SDMA0_UTCL1_PAGE__REQ_TYPE_MASK                                                                       0x0000001EL
#define SDMA0_UTCL1_PAGE__USE_MTYPE_MASK                                                                      0x000003C0L
#define SDMA0_UTCL1_PAGE__USE_PT_SNOOP_MASK                                                                   0x00000400L
#define SDMA0_UTCL1_PAGE__USE_IO_MASK                                                                         0x00000800L
#define SDMA0_UTCL1_PAGE__RD_L2_POLICY_MASK                                                                   0x00003000L
#define SDMA0_UTCL1_PAGE__WR_L2_POLICY_MASK                                                                   0x0000C000L
#define SDMA0_UTCL1_PAGE__DMA_PAGE_SIZE_MASK                                                                  0x003F0000L
#define SDMA0_UTCL1_PAGE__USE_BC_MASK                                                                         0x00400000L
#define SDMA0_UTCL1_PAGE__ADDR_IS_PA_MASK                                                                     0x00800000L
#define SDMA0_UTCL1_PAGE__LLC_NOALLOC_MASK                                                                    0x01000000L
//SDMA0_RELAX_ORDERING_LUT
#define SDMA0_RELAX_ORDERING_LUT__RESERVED0__SHIFT                                                            0x0
#define SDMA0_RELAX_ORDERING_LUT__COPY__SHIFT                                                                 0x1
#define SDMA0_RELAX_ORDERING_LUT__WRITE__SHIFT                                                                0x2
#define SDMA0_RELAX_ORDERING_LUT__RESERVED3__SHIFT                                                            0x3
#define SDMA0_RELAX_ORDERING_LUT__RESERVED4__SHIFT                                                            0x4
#define SDMA0_RELAX_ORDERING_LUT__FENCE__SHIFT                                                                0x5
#define SDMA0_RELAX_ORDERING_LUT__RESERVED76__SHIFT                                                           0x6
#define SDMA0_RELAX_ORDERING_LUT__POLL_MEM__SHIFT                                                             0x8
#define SDMA0_RELAX_ORDERING_LUT__COND_EXE__SHIFT                                                             0x9
#define SDMA0_RELAX_ORDERING_LUT__ATOMIC__SHIFT                                                               0xa
#define SDMA0_RELAX_ORDERING_LUT__CONST_FILL__SHIFT                                                           0xb
#define SDMA0_RELAX_ORDERING_LUT__PTEPDE__SHIFT                                                               0xc
#define SDMA0_RELAX_ORDERING_LUT__TIMESTAMP__SHIFT                                                            0xd
#define SDMA0_RELAX_ORDERING_LUT__RESERVED__SHIFT                                                             0xe
#define SDMA0_RELAX_ORDERING_LUT__WORLD_SWITCH__SHIFT                                                         0x1b
#define SDMA0_RELAX_ORDERING_LUT__RPTR_WRB__SHIFT                                                             0x1c
#define SDMA0_RELAX_ORDERING_LUT__WPTR_POLL__SHIFT                                                            0x1d
#define SDMA0_RELAX_ORDERING_LUT__IB_FETCH__SHIFT                                                             0x1e
#define SDMA0_RELAX_ORDERING_LUT__RB_FETCH__SHIFT                                                             0x1f
#define SDMA0_RELAX_ORDERING_LUT__RESERVED0_MASK                                                              0x00000001L
#define SDMA0_RELAX_ORDERING_LUT__COPY_MASK                                                                   0x00000002L
#define SDMA0_RELAX_ORDERING_LUT__WRITE_MASK                                                                  0x00000004L
#define SDMA0_RELAX_ORDERING_LUT__RESERVED3_MASK                                                              0x00000008L
#define SDMA0_RELAX_ORDERING_LUT__RESERVED4_MASK                                                              0x00000010L
#define SDMA0_RELAX_ORDERING_LUT__FENCE_MASK                                                                  0x00000020L
#define SDMA0_RELAX_ORDERING_LUT__RESERVED76_MASK                                                             0x000000C0L
#define SDMA0_RELAX_ORDERING_LUT__POLL_MEM_MASK                                                               0x00000100L
#define SDMA0_RELAX_ORDERING_LUT__COND_EXE_MASK                                                               0x00000200L
#define SDMA0_RELAX_ORDERING_LUT__ATOMIC_MASK                                                                 0x00000400L
#define SDMA0_RELAX_ORDERING_LUT__CONST_FILL_MASK                                                             0x00000800L
#define SDMA0_RELAX_ORDERING_LUT__PTEPDE_MASK                                                                 0x00001000L
#define SDMA0_RELAX_ORDERING_LUT__TIMESTAMP_MASK                                                              0x00002000L
#define SDMA0_RELAX_ORDERING_LUT__RESERVED_MASK                                                               0x07FFC000L
#define SDMA0_RELAX_ORDERING_LUT__WORLD_SWITCH_MASK                                                           0x08000000L
#define SDMA0_RELAX_ORDERING_LUT__RPTR_WRB_MASK                                                               0x10000000L
#define SDMA0_RELAX_ORDERING_LUT__WPTR_POLL_MASK                                                              0x20000000L
#define SDMA0_RELAX_ORDERING_LUT__IB_FETCH_MASK                                                               0x40000000L
#define SDMA0_RELAX_ORDERING_LUT__RB_FETCH_MASK                                                               0x80000000L
//SDMA0_CHICKEN_BITS_2
#define SDMA0_CHICKEN_BITS_2__F32_CMD_PROC_DELAY__SHIFT                                                       0x0
#define SDMA0_CHICKEN_BITS_2__CE_BACKWARDS_SIZE_SEL__SHIFT                                                    0x4
#define SDMA0_CHICKEN_BITS_2__CE_DCC_READ_128B_ENABLE__SHIFT                                                  0x5
#define SDMA0_CHICKEN_BITS_2__UTCL1_FORCE_INV_RET_FIFO_FULL_EN__SHIFT                                         0x6
#define SDMA0_CHICKEN_BITS_2__RESERVED0__SHIFT                                                                0x7
#define SDMA0_CHICKEN_BITS_2__LUT_FIFO_AFULL_MARGIN__SHIFT                                                    0xb
#define SDMA0_CHICKEN_BITS_2__LEGACY_WPTR_POLL_BEHAVIOR__SHIFT                                                0xf
#define SDMA0_CHICKEN_BITS_2__RB_FIFO_WATERMARK__SHIFT                                                        0x10
#define SDMA0_CHICKEN_BITS_2__IB_FIFO_WATERMARK__SHIFT                                                        0x12
#define SDMA0_CHICKEN_BITS_2__REPEATER_FGCG_EN__SHIFT                                                         0x14
#define SDMA0_CHICKEN_BITS_2__F32_SEND_POSTCODE_EN__SHIFT                                                     0x15
#define SDMA0_CHICKEN_BITS_2__RESERVED__SHIFT                                                                 0x16
#define SDMA0_CHICKEN_BITS_2__F32_CMD_PROC_DELAY_MASK                                                         0x0000000FL
#define SDMA0_CHICKEN_BITS_2__CE_BACKWARDS_SIZE_SEL_MASK                                                      0x00000010L
#define SDMA0_CHICKEN_BITS_2__CE_DCC_READ_128B_ENABLE_MASK                                                    0x00000020L
#define SDMA0_CHICKEN_BITS_2__UTCL1_FORCE_INV_RET_FIFO_FULL_EN_MASK                                           0x00000040L
#define SDMA0_CHICKEN_BITS_2__RESERVED0_MASK                                                                  0x00000780L
#define SDMA0_CHICKEN_BITS_2__LUT_FIFO_AFULL_MARGIN_MASK                                                      0x00007800L
#define SDMA0_CHICKEN_BITS_2__LEGACY_WPTR_POLL_BEHAVIOR_MASK                                                  0x00008000L
#define SDMA0_CHICKEN_BITS_2__RB_FIFO_WATERMARK_MASK                                                          0x00030000L
#define SDMA0_CHICKEN_BITS_2__IB_FIFO_WATERMARK_MASK                                                          0x000C0000L
#define SDMA0_CHICKEN_BITS_2__REPEATER_FGCG_EN_MASK                                                           0x00100000L
#define SDMA0_CHICKEN_BITS_2__F32_SEND_POSTCODE_EN_MASK                                                       0x00200000L
#define SDMA0_CHICKEN_BITS_2__RESERVED_MASK                                                                   0xFFC00000L
//SDMA0_STATUS3_REG
#define SDMA0_STATUS3_REG__CMD_OP_STATUS__SHIFT                                                               0x0
#define SDMA0_STATUS3_REG__PREV_VM_CMD__SHIFT                                                                 0x10
#define SDMA0_STATUS3_REG__EXCEPTION_IDLE__SHIFT                                                              0x14
#define SDMA0_STATUS3_REG__AQL_PREV_CMD_IDLE__SHIFT                                                           0x15
#define SDMA0_STATUS3_REG__TLBI_IDLE__SHIFT                                                                   0x16
#define SDMA0_STATUS3_REG__GCR_IDLE__SHIFT                                                                    0x17
#define SDMA0_STATUS3_REG__INVREQ_IDLE__SHIFT                                                                 0x18
#define SDMA0_STATUS3_REG__QUEUE_ID_MATCH__SHIFT                                                              0x19
#define SDMA0_STATUS3_REG__INT_QUEUE_ID__SHIFT                                                                0x1a
#define SDMA0_STATUS3_REG__CMD_OP_STATUS_MASK                                                                 0x0000FFFFL
#define SDMA0_STATUS3_REG__PREV_VM_CMD_MASK                                                                   0x000F0000L
#define SDMA0_STATUS3_REG__EXCEPTION_IDLE_MASK                                                                0x00100000L
#define SDMA0_STATUS3_REG__AQL_PREV_CMD_IDLE_MASK                                                             0x00200000L
#define SDMA0_STATUS3_REG__TLBI_IDLE_MASK                                                                     0x00400000L
#define SDMA0_STATUS3_REG__GCR_IDLE_MASK                                                                      0x00800000L
#define SDMA0_STATUS3_REG__INVREQ_IDLE_MASK                                                                   0x01000000L
#define SDMA0_STATUS3_REG__QUEUE_ID_MATCH_MASK                                                                0x02000000L
#define SDMA0_STATUS3_REG__INT_QUEUE_ID_MASK                                                                  0x3C000000L
//SDMA0_PHYSICAL_ADDR_LO
#define SDMA0_PHYSICAL_ADDR_LO__D_VALID__SHIFT                                                                0x0
#define SDMA0_PHYSICAL_ADDR_LO__DIRTY__SHIFT                                                                  0x1
#define SDMA0_PHYSICAL_ADDR_LO__PHY_VALID__SHIFT                                                              0x2
#define SDMA0_PHYSICAL_ADDR_LO__ADDR__SHIFT                                                                   0xc
#define SDMA0_PHYSICAL_ADDR_LO__D_VALID_MASK                                                                  0x00000001L
#define SDMA0_PHYSICAL_ADDR_LO__DIRTY_MASK                                                                    0x00000002L
#define SDMA0_PHYSICAL_ADDR_LO__PHY_VALID_MASK                                                                0x00000004L
#define SDMA0_PHYSICAL_ADDR_LO__ADDR_MASK                                                                     0xFFFFF000L
//SDMA0_PHYSICAL_ADDR_HI
#define SDMA0_PHYSICAL_ADDR_HI__ADDR__SHIFT                                                                   0x0
#define SDMA0_PHYSICAL_ADDR_HI__ADDR_MASK                                                                     0x0000FFFFL
//SDMA0_PHASE2_QUANTUM
#define SDMA0_PHASE2_QUANTUM__UNIT__SHIFT                                                                     0x0
#define SDMA0_PHASE2_QUANTUM__VALUE__SHIFT                                                                    0x8
#define SDMA0_PHASE2_QUANTUM__PREFER__SHIFT                                                                   0x1e
#define SDMA0_PHASE2_QUANTUM__UNIT_MASK                                                                       0x0000000FL
#define SDMA0_PHASE2_QUANTUM__VALUE_MASK                                                                      0x00FFFF00L
#define SDMA0_PHASE2_QUANTUM__PREFER_MASK                                                                     0x40000000L
//SDMA0_ERROR_LOG
#define SDMA0_ERROR_LOG__OVERRIDE__SHIFT                                                                      0x0
#define SDMA0_ERROR_LOG__STATUS__SHIFT                                                                        0x10
#define SDMA0_ERROR_LOG__OVERRIDE_MASK                                                                        0x0000FFFFL
#define SDMA0_ERROR_LOG__STATUS_MASK                                                                          0xFFFF0000L
//SDMA0_PUB_DUMMY_REG0
#define SDMA0_PUB_DUMMY_REG0__VALUE__SHIFT                                                                    0x0
#define SDMA0_PUB_DUMMY_REG0__VALUE_MASK                                                                      0xFFFFFFFFL
//SDMA0_PUB_DUMMY_REG1
#define SDMA0_PUB_DUMMY_REG1__VALUE__SHIFT                                                                    0x0
#define SDMA0_PUB_DUMMY_REG1__VALUE_MASK                                                                      0xFFFFFFFFL
//SDMA0_PUB_DUMMY_REG2
#define SDMA0_PUB_DUMMY_REG2__VALUE__SHIFT                                                                    0x0
#define SDMA0_PUB_DUMMY_REG2__VALUE_MASK                                                                      0xFFFFFFFFL
//SDMA0_PUB_DUMMY_REG3
#define SDMA0_PUB_DUMMY_REG3__VALUE__SHIFT                                                                    0x0
#define SDMA0_PUB_DUMMY_REG3__VALUE_MASK                                                                      0xFFFFFFFFL
//SDMA0_F32_COUNTER
#define SDMA0_F32_COUNTER__VALUE__SHIFT                                                                       0x0
#define SDMA0_F32_COUNTER__VALUE_MASK                                                                         0xFFFFFFFFL
//SDMA0_CRD_CNTL
#define SDMA0_CRD_CNTL__MC_WRREQ_CREDIT__SHIFT                                                                0x7
#define SDMA0_CRD_CNTL__MC_RDREQ_CREDIT__SHIFT                                                                0xd
#define SDMA0_CRD_CNTL__CH_WRREQ_CREDIT__SHIFT                                                                0x13
#define SDMA0_CRD_CNTL__CH_RDREQ_CREDIT__SHIFT                                                                0x19
#define SDMA0_CRD_CNTL__MC_WRREQ_CREDIT_MASK                                                                  0x00001F80L
#define SDMA0_CRD_CNTL__MC_RDREQ_CREDIT_MASK                                                                  0x0007E000L
#define SDMA0_CRD_CNTL__CH_WRREQ_CREDIT_MASK                                                                  0x01F80000L
#define SDMA0_CRD_CNTL__CH_RDREQ_CREDIT_MASK                                                                  0x7E000000L
//SDMA0_AQL_STATUS
#define SDMA0_AQL_STATUS__COMPLETE_SIGNAL_EMPTY__SHIFT                                                        0x0
#define SDMA0_AQL_STATUS__INVALID_CMD_EMPTY__SHIFT                                                            0x1
#define SDMA0_AQL_STATUS__COMPLETE_SIGNAL_EMPTY_MASK                                                          0x00000001L
#define SDMA0_AQL_STATUS__INVALID_CMD_EMPTY_MASK                                                              0x00000002L
//SDMA0_EA_DBIT_ADDR_DATA
#define SDMA0_EA_DBIT_ADDR_DATA__VALUE__SHIFT                                                                 0x0
#define SDMA0_EA_DBIT_ADDR_DATA__VALUE_MASK                                                                   0xFFFFFFFFL
//SDMA0_EA_DBIT_ADDR_INDEX
#define SDMA0_EA_DBIT_ADDR_INDEX__VALUE__SHIFT                                                                0x0
#define SDMA0_EA_DBIT_ADDR_INDEX__VALUE_MASK                                                                  0x00000007L
//SDMA0_TLBI_GCR_CNTL
#define SDMA0_TLBI_GCR_CNTL__TLBI_CMD_DW__SHIFT                                                               0x0
#define SDMA0_TLBI_GCR_CNTL__GCR_CMD_DW__SHIFT                                                                0x4
#define SDMA0_TLBI_GCR_CNTL__GCR_CLKEN_CYCLE__SHIFT                                                           0x8
#define SDMA0_TLBI_GCR_CNTL__TLBI_CREDIT__SHIFT                                                               0x10
#define SDMA0_TLBI_GCR_CNTL__GCR_CREDIT__SHIFT                                                                0x18
#define SDMA0_TLBI_GCR_CNTL__TLBI_CMD_DW_MASK                                                                 0x0000000FL
#define SDMA0_TLBI_GCR_CNTL__GCR_CMD_DW_MASK                                                                  0x000000F0L
#define SDMA0_TLBI_GCR_CNTL__GCR_CLKEN_CYCLE_MASK                                                             0x00000F00L
#define SDMA0_TLBI_GCR_CNTL__TLBI_CREDIT_MASK                                                                 0x00FF0000L
#define SDMA0_TLBI_GCR_CNTL__GCR_CREDIT_MASK                                                                  0xFF000000L
//SDMA0_TILING_CONFIG
#define SDMA0_TILING_CONFIG__PIPE_INTERLEAVE_SIZE__SHIFT                                                      0x4
#define SDMA0_TILING_CONFIG__PIPE_INTERLEAVE_SIZE_MASK                                                        0x00000070L
//SDMA0_INT_STATUS
#define SDMA0_INT_STATUS__DATA__SHIFT                                                                         0x0
#define SDMA0_INT_STATUS__DATA_MASK                                                                           0xFFFFFFFFL
//SDMA0_HOLE_ADDR_LO
#define SDMA0_HOLE_ADDR_LO__VALUE__SHIFT                                                                      0x0
#define SDMA0_HOLE_ADDR_LO__VALUE_MASK                                                                        0xFFFFFFFFL
//SDMA0_HOLE_ADDR_HI
#define SDMA0_HOLE_ADDR_HI__VALUE__SHIFT                                                                      0x0
#define SDMA0_HOLE_ADDR_HI__VALUE_MASK                                                                        0xFFFFFFFFL
//SDMA0_CLOCK_GATING_REG
#define SDMA0_CLOCK_GATING_REG__DYN_CLK_GATE_STATUS__SHIFT                                                    0x0
#define SDMA0_CLOCK_GATING_REG__PTR_CLK_GATE_STATUS__SHIFT                                                    0x1
#define SDMA0_CLOCK_GATING_REG__CE_CLK_GATE_STATUS__SHIFT                                                     0x2
#define SDMA0_CLOCK_GATING_REG__CE_BC_CLK_GATE_STATUS__SHIFT                                                  0x3
#define SDMA0_CLOCK_GATING_REG__CE_NBC_CLK_GATE_STATUS__SHIFT                                                 0x4
#define SDMA0_CLOCK_GATING_REG__REG_CLK_GATE_STATUS__SHIFT                                                    0x5
#define SDMA0_CLOCK_GATING_REG__DYN_CLK_GATE_STATUS_MASK                                                      0x00000001L
#define SDMA0_CLOCK_GATING_REG__PTR_CLK_GATE_STATUS_MASK                                                      0x00000002L
#define SDMA0_CLOCK_GATING_REG__CE_CLK_GATE_STATUS_MASK                                                       0x00000004L
#define SDMA0_CLOCK_GATING_REG__CE_BC_CLK_GATE_STATUS_MASK                                                    0x00000008L
#define SDMA0_CLOCK_GATING_REG__CE_NBC_CLK_GATE_STATUS_MASK                                                   0x00000010L
#define SDMA0_CLOCK_GATING_REG__REG_CLK_GATE_STATUS_MASK                                                      0x00000020L
//SDMA0_STATUS4_REG
#define SDMA0_STATUS4_REG__IDLE__SHIFT                                                                        0x0
#define SDMA0_STATUS4_REG__IH_OUTSTANDING__SHIFT                                                              0x2
#define SDMA0_STATUS4_REG__SEM_OUTSTANDING__SHIFT                                                             0x3
#define SDMA0_STATUS4_REG__CH_RD_OUTSTANDING__SHIFT                                                           0x4
#define SDMA0_STATUS4_REG__CH_WR_OUTSTANDING__SHIFT                                                           0x5
#define SDMA0_STATUS4_REG__GCR_OUTSTANDING__SHIFT                                                             0x6
#define SDMA0_STATUS4_REG__TLBI_OUTSTANDING__SHIFT                                                            0x7
#define SDMA0_STATUS4_REG__UTCL2_RD_OUTSTANDING__SHIFT                                                        0x8
#define SDMA0_STATUS4_REG__UTCL2_WR_OUTSTANDING__SHIFT                                                        0x9
#define SDMA0_STATUS4_REG__REG_POLLING__SHIFT                                                                 0xa
#define SDMA0_STATUS4_REG__MEM_POLLING__SHIFT                                                                 0xb
#define SDMA0_STATUS4_REG__UTCL2_RD_XNACK__SHIFT                                                              0xc
#define SDMA0_STATUS4_REG__UTCL2_WR_XNACK__SHIFT                                                              0xe
#define SDMA0_STATUS4_REG__ACTIVE_QUEUE_ID__SHIFT                                                             0x10
#define SDMA0_STATUS4_REG__SRIOV_WATING_RLCV_CMD__SHIFT                                                       0x14
#define SDMA0_STATUS4_REG__SRIOV_SDMA_EXECUTING_CMD__SHIFT                                                    0x15
#define SDMA0_STATUS4_REG__IDLE_MASK                                                                          0x00000001L
#define SDMA0_STATUS4_REG__IH_OUTSTANDING_MASK                                                                0x00000004L
#define SDMA0_STATUS4_REG__SEM_OUTSTANDING_MASK                                                               0x00000008L
#define SDMA0_STATUS4_REG__CH_RD_OUTSTANDING_MASK                                                             0x00000010L
#define SDMA0_STATUS4_REG__CH_WR_OUTSTANDING_MASK                                                             0x00000020L
#define SDMA0_STATUS4_REG__GCR_OUTSTANDING_MASK                                                               0x00000040L
#define SDMA0_STATUS4_REG__TLBI_OUTSTANDING_MASK                                                              0x00000080L
#define SDMA0_STATUS4_REG__UTCL2_RD_OUTSTANDING_MASK                                                          0x00000100L
#define SDMA0_STATUS4_REG__UTCL2_WR_OUTSTANDING_MASK                                                          0x00000200L
#define SDMA0_STATUS4_REG__REG_POLLING_MASK                                                                   0x00000400L
#define SDMA0_STATUS4_REG__MEM_POLLING_MASK                                                                   0x00000800L
#define SDMA0_STATUS4_REG__UTCL2_RD_XNACK_MASK                                                                0x00003000L
#define SDMA0_STATUS4_REG__UTCL2_WR_XNACK_MASK                                                                0x0000C000L
#define SDMA0_STATUS4_REG__ACTIVE_QUEUE_ID_MASK                                                               0x000F0000L
#define SDMA0_STATUS4_REG__SRIOV_WATING_RLCV_CMD_MASK                                                         0x00100000L
#define SDMA0_STATUS4_REG__SRIOV_SDMA_EXECUTING_CMD_MASK                                                      0x00200000L
//SDMA0_SCRATCH_RAM_DATA
#define SDMA0_SCRATCH_RAM_DATA__DATA__SHIFT                                                                   0x0
#define SDMA0_SCRATCH_RAM_DATA__DATA_MASK                                                                     0xFFFFFFFFL
//SDMA0_SCRATCH_RAM_ADDR
#define SDMA0_SCRATCH_RAM_ADDR__ADDR__SHIFT                                                                   0x0
#define SDMA0_SCRATCH_RAM_ADDR__ADDR_MASK                                                                     0x000003FFL
//SDMA0_TIMESTAMP_CNTL
#define SDMA0_TIMESTAMP_CNTL__CAPTURE__SHIFT                                                                  0x0
#define SDMA0_TIMESTAMP_CNTL__CAPTURE_MASK                                                                    0x00000001L
//SDMA0_STATUS5_REG
#define SDMA0_STATUS5_REG__GFX_RB_ENABLE_STATUS__SHIFT                                                        0x0
#define SDMA0_STATUS5_REG__PAGE_RB_ENABLE_STATUS__SHIFT                                                       0x1
#define SDMA0_STATUS5_REG__RLC0_RB_ENABLE_STATUS__SHIFT                                                       0x2
#define SDMA0_STATUS5_REG__RLC1_RB_ENABLE_STATUS__SHIFT                                                       0x3
#define SDMA0_STATUS5_REG__RLC2_RB_ENABLE_STATUS__SHIFT                                                       0x4
#define SDMA0_STATUS5_REG__RLC3_RB_ENABLE_STATUS__SHIFT                                                       0x5
#define SDMA0_STATUS5_REG__RLC4_RB_ENABLE_STATUS__SHIFT                                                       0x6
#define SDMA0_STATUS5_REG__RLC5_RB_ENABLE_STATUS__SHIFT                                                       0x7
#define SDMA0_STATUS5_REG__RLC6_RB_ENABLE_STATUS__SHIFT                                                       0x8
#define SDMA0_STATUS5_REG__RLC7_RB_ENABLE_STATUS__SHIFT                                                       0x9
#define SDMA0_STATUS5_REG__ACTIVE_QUEUE_ID__SHIFT                                                             0x10
#define SDMA0_STATUS5_REG__GFX_RB_ENABLE_STATUS_MASK                                                          0x00000001L
#define SDMA0_STATUS5_REG__PAGE_RB_ENABLE_STATUS_MASK                                                         0x00000002L
#define SDMA0_STATUS5_REG__RLC0_RB_ENABLE_STATUS_MASK                                                         0x00000004L
#define SDMA0_STATUS5_REG__RLC1_RB_ENABLE_STATUS_MASK                                                         0x00000008L
#define SDMA0_STATUS5_REG__RLC2_RB_ENABLE_STATUS_MASK                                                         0x00000010L
#define SDMA0_STATUS5_REG__RLC3_RB_ENABLE_STATUS_MASK                                                         0x00000020L
#define SDMA0_STATUS5_REG__RLC4_RB_ENABLE_STATUS_MASK                                                         0x00000040L
#define SDMA0_STATUS5_REG__RLC5_RB_ENABLE_STATUS_MASK                                                         0x00000080L
#define SDMA0_STATUS5_REG__RLC6_RB_ENABLE_STATUS_MASK                                                         0x00000100L
#define SDMA0_STATUS5_REG__RLC7_RB_ENABLE_STATUS_MASK                                                         0x00000200L
#define SDMA0_STATUS5_REG__ACTIVE_QUEUE_ID_MASK                                                               0x000F0000L
//SDMA0_QUEUE_RESET_REQ
#define SDMA0_QUEUE_RESET_REQ__GFX_QUEUE_RESET__SHIFT                                                         0x0
#define SDMA0_QUEUE_RESET_REQ__PAGE_QUEUE_RESET__SHIFT                                                        0x1
#define SDMA0_QUEUE_RESET_REQ__RLC0_QUEUE_RESET__SHIFT                                                        0x2
#define SDMA0_QUEUE_RESET_REQ__RLC1_QUEUE_RESET__SHIFT                                                        0x3
#define SDMA0_QUEUE_RESET_REQ__RLC2_QUEUE_RESET__SHIFT                                                        0x4
#define SDMA0_QUEUE_RESET_REQ__RLC3_QUEUE_RESET__SHIFT                                                        0x5
#define SDMA0_QUEUE_RESET_REQ__RLC4_QUEUE_RESET__SHIFT                                                        0x6
#define SDMA0_QUEUE_RESET_REQ__RLC5_QUEUE_RESET__SHIFT                                                        0x7
#define SDMA0_QUEUE_RESET_REQ__RLC6_QUEUE_RESET__SHIFT                                                        0x8
#define SDMA0_QUEUE_RESET_REQ__RLC7_QUEUE_RESET__SHIFT                                                        0x9
#define SDMA0_QUEUE_RESET_REQ__RESERVED__SHIFT                                                                0xa
#define SDMA0_QUEUE_RESET_REQ__GFX_QUEUE_RESET_MASK                                                           0x00000001L
#define SDMA0_QUEUE_RESET_REQ__PAGE_QUEUE_RESET_MASK                                                          0x00000002L
#define SDMA0_QUEUE_RESET_REQ__RLC0_QUEUE_RESET_MASK                                                          0x00000004L
#define SDMA0_QUEUE_RESET_REQ__RLC1_QUEUE_RESET_MASK                                                          0x00000008L
#define SDMA0_QUEUE_RESET_REQ__RLC2_QUEUE_RESET_MASK                                                          0x00000010L
#define SDMA0_QUEUE_RESET_REQ__RLC3_QUEUE_RESET_MASK                                                          0x00000020L
#define SDMA0_QUEUE_RESET_REQ__RLC4_QUEUE_RESET_MASK                                                          0x00000040L
#define SDMA0_QUEUE_RESET_REQ__RLC5_QUEUE_RESET_MASK                                                          0x00000080L
#define SDMA0_QUEUE_RESET_REQ__RLC6_QUEUE_RESET_MASK                                                          0x00000100L
#define SDMA0_QUEUE_RESET_REQ__RLC7_QUEUE_RESET_MASK                                                          0x00000200L
#define SDMA0_QUEUE_RESET_REQ__RESERVED_MASK                                                                  0xFFFFFC00L
//SDMA0_GFX_RB_CNTL
#define SDMA0_GFX_RB_CNTL__RB_ENABLE__SHIFT                                                                   0x0
#define SDMA0_GFX_RB_CNTL__RB_SIZE__SHIFT                                                                     0x1
#define SDMA0_GFX_RB_CNTL__RB_SWAP_ENABLE__SHIFT                                                              0x9
#define SDMA0_GFX_RB_CNTL__RPTR_WRITEBACK_ENABLE__SHIFT                                                       0xc
#define SDMA0_GFX_RB_CNTL__RPTR_WRITEBACK_SWAP_ENABLE__SHIFT                                                  0xd
#define SDMA0_GFX_RB_CNTL__RPTR_WRITEBACK_TIMER__SHIFT                                                        0x10
#define SDMA0_GFX_RB_CNTL__RB_PRIV__SHIFT                                                                     0x17
#define SDMA0_GFX_RB_CNTL__RB_VMID__SHIFT                                                                     0x18
#define SDMA0_GFX_RB_CNTL__RPTR_WB_IDLE__SHIFT                                                                0x1f
#define SDMA0_GFX_RB_CNTL__RB_ENABLE_MASK                                                                     0x00000001L
#define SDMA0_GFX_RB_CNTL__RB_SIZE_MASK                                                                       0x0000003EL
#define SDMA0_GFX_RB_CNTL__RB_SWAP_ENABLE_MASK                                                                0x00000200L
#define SDMA0_GFX_RB_CNTL__RPTR_WRITEBACK_ENABLE_MASK                                                         0x00001000L
#define SDMA0_GFX_RB_CNTL__RPTR_WRITEBACK_SWAP_ENABLE_MASK                                                    0x00002000L
#define SDMA0_GFX_RB_CNTL__RPTR_WRITEBACK_TIMER_MASK                                                          0x001F0000L
#define SDMA0_GFX_RB_CNTL__RB_PRIV_MASK                                                                       0x00800000L
#define SDMA0_GFX_RB_CNTL__RB_VMID_MASK                                                                       0x0F000000L
#define SDMA0_GFX_RB_CNTL__RPTR_WB_IDLE_MASK                                                                  0x80000000L
//SDMA0_GFX_RB_BASE
#define SDMA0_GFX_RB_BASE__ADDR__SHIFT                                                                        0x0
#define SDMA0_GFX_RB_BASE__ADDR_MASK                                                                          0xFFFFFFFFL
//SDMA0_GFX_RB_BASE_HI
#define SDMA0_GFX_RB_BASE_HI__ADDR__SHIFT                                                                     0x0
#define SDMA0_GFX_RB_BASE_HI__ADDR_MASK                                                                       0x00FFFFFFL
//SDMA0_GFX_RB_RPTR
#define SDMA0_GFX_RB_RPTR__OFFSET__SHIFT                                                                      0x0
#define SDMA0_GFX_RB_RPTR__OFFSET_MASK                                                                        0xFFFFFFFFL
//SDMA0_GFX_RB_RPTR_HI
#define SDMA0_GFX_RB_RPTR_HI__OFFSET__SHIFT                                                                   0x0
#define SDMA0_GFX_RB_RPTR_HI__OFFSET_MASK                                                                     0xFFFFFFFFL
//SDMA0_GFX_RB_WPTR
#define SDMA0_GFX_RB_WPTR__OFFSET__SHIFT                                                                      0x0
#define SDMA0_GFX_RB_WPTR__OFFSET_MASK                                                                        0xFFFFFFFFL
//SDMA0_GFX_RB_WPTR_HI
#define SDMA0_GFX_RB_WPTR_HI__OFFSET__SHIFT                                                                   0x0
#define SDMA0_GFX_RB_WPTR_HI__OFFSET_MASK                                                                     0xFFFFFFFFL
//SDMA0_GFX_RB_WPTR_POLL_CNTL
#define SDMA0_GFX_RB_WPTR_POLL_CNTL__ENABLE__SHIFT                                                            0x0
#define SDMA0_GFX_RB_WPTR_POLL_CNTL__SWAP_ENABLE__SHIFT                                                       0x1
#define SDMA0_GFX_RB_WPTR_POLL_CNTL__F32_POLL_ENABLE__SHIFT                                                   0x2
#define SDMA0_GFX_RB_WPTR_POLL_CNTL__FREQUENCY__SHIFT                                                         0x4
#define SDMA0_GFX_RB_WPTR_POLL_CNTL__IDLE_POLL_COUNT__SHIFT                                                   0x10
#define SDMA0_GFX_RB_WPTR_POLL_CNTL__ENABLE_MASK                                                              0x00000001L
#define SDMA0_GFX_RB_WPTR_POLL_CNTL__SWAP_ENABLE_MASK                                                         0x00000002L
#define SDMA0_GFX_RB_WPTR_POLL_CNTL__F32_POLL_ENABLE_MASK                                                     0x00000004L
#define SDMA0_GFX_RB_WPTR_POLL_CNTL__FREQUENCY_MASK                                                           0x0000FFF0L
#define SDMA0_GFX_RB_WPTR_POLL_CNTL__IDLE_POLL_COUNT_MASK                                                     0xFFFF0000L
//SDMA0_GFX_RB_RPTR_ADDR_HI
#define SDMA0_GFX_RB_RPTR_ADDR_HI__ADDR__SHIFT                                                                0x0
#define SDMA0_GFX_RB_RPTR_ADDR_HI__ADDR_MASK                                                                  0xFFFFFFFFL
//SDMA0_GFX_RB_RPTR_ADDR_LO
#define SDMA0_GFX_RB_RPTR_ADDR_LO__ADDR__SHIFT                                                                0x2
#define SDMA0_GFX_RB_RPTR_ADDR_LO__ADDR_MASK                                                                  0xFFFFFFFCL
//SDMA0_GFX_IB_CNTL
#define SDMA0_GFX_IB_CNTL__IB_ENABLE__SHIFT                                                                   0x0
#define SDMA0_GFX_IB_CNTL__IB_SWAP_ENABLE__SHIFT                                                              0x4
#define SDMA0_GFX_IB_CNTL__SWITCH_INSIDE_IB__SHIFT                                                            0x8
#define SDMA0_GFX_IB_CNTL__CMD_VMID__SHIFT                                                                    0x10
#define SDMA0_GFX_IB_CNTL__IB_ENABLE_MASK                                                                     0x00000001L
#define SDMA0_GFX_IB_CNTL__IB_SWAP_ENABLE_MASK                                                                0x00000010L
#define SDMA0_GFX_IB_CNTL__SWITCH_INSIDE_IB_MASK                                                              0x00000100L
#define SDMA0_GFX_IB_CNTL__CMD_VMID_MASK                                                                      0x000F0000L
//SDMA0_GFX_IB_RPTR
#define SDMA0_GFX_IB_RPTR__OFFSET__SHIFT                                                                      0x2
#define SDMA0_GFX_IB_RPTR__OFFSET_MASK                                                                        0x003FFFFCL
//SDMA0_GFX_IB_OFFSET
#define SDMA0_GFX_IB_OFFSET__OFFSET__SHIFT                                                                    0x2
#define SDMA0_GFX_IB_OFFSET__OFFSET_MASK                                                                      0x003FFFFCL
//SDMA0_GFX_IB_BASE_LO
#define SDMA0_GFX_IB_BASE_LO__ADDR__SHIFT                                                                     0x5
#define SDMA0_GFX_IB_BASE_LO__ADDR_MASK                                                                       0xFFFFFFE0L
//SDMA0_GFX_IB_BASE_HI
#define SDMA0_GFX_IB_BASE_HI__ADDR__SHIFT                                                                     0x0
#define SDMA0_GFX_IB_BASE_HI__ADDR_MASK                                                                       0xFFFFFFFFL
//SDMA0_GFX_IB_SIZE
#define SDMA0_GFX_IB_SIZE__SIZE__SHIFT                                                                        0x0
#define SDMA0_GFX_IB_SIZE__SIZE_MASK                                                                          0x000FFFFFL
//SDMA0_GFX_SKIP_CNTL
#define SDMA0_GFX_SKIP_CNTL__SKIP_COUNT__SHIFT                                                                0x0
#define SDMA0_GFX_SKIP_CNTL__SKIP_COUNT_MASK                                                                  0x000FFFFFL
//SDMA0_GFX_CONTEXT_STATUS
#define SDMA0_GFX_CONTEXT_STATUS__SELECTED__SHIFT                                                             0x0
#define SDMA0_GFX_CONTEXT_STATUS__IDLE__SHIFT                                                                 0x2
#define SDMA0_GFX_CONTEXT_STATUS__EXPIRED__SHIFT                                                              0x3
#define SDMA0_GFX_CONTEXT_STATUS__EXCEPTION__SHIFT                                                            0x4
#define SDMA0_GFX_CONTEXT_STATUS__CTXSW_ABLE__SHIFT                                                           0x7
#define SDMA0_GFX_CONTEXT_STATUS__CTXSW_READY__SHIFT                                                          0x8
#define SDMA0_GFX_CONTEXT_STATUS__PREEMPTED__SHIFT                                                            0x9
#define SDMA0_GFX_CONTEXT_STATUS__PREEMPT_DISABLE__SHIFT                                                      0xa
#define SDMA0_GFX_CONTEXT_STATUS__SELECTED_MASK                                                               0x00000001L
#define SDMA0_GFX_CONTEXT_STATUS__IDLE_MASK                                                                   0x00000004L
#define SDMA0_GFX_CONTEXT_STATUS__EXPIRED_MASK                                                                0x00000008L
#define SDMA0_GFX_CONTEXT_STATUS__EXCEPTION_MASK                                                              0x00000070L
#define SDMA0_GFX_CONTEXT_STATUS__CTXSW_ABLE_MASK                                                             0x00000080L
#define SDMA0_GFX_CONTEXT_STATUS__CTXSW_READY_MASK                                                            0x00000100L
#define SDMA0_GFX_CONTEXT_STATUS__PREEMPTED_MASK                                                              0x00000200L
#define SDMA0_GFX_CONTEXT_STATUS__PREEMPT_DISABLE_MASK                                                        0x00000400L
//SDMA0_GFX_DOORBELL
#define SDMA0_GFX_DOORBELL__ENABLE__SHIFT                                                                     0x1c
#define SDMA0_GFX_DOORBELL__CAPTURED__SHIFT                                                                   0x1e
#define SDMA0_GFX_DOORBELL__ENABLE_MASK                                                                       0x10000000L
#define SDMA0_GFX_DOORBELL__CAPTURED_MASK                                                                     0x40000000L
//SDMA0_GFX_CONTEXT_CNTL
#define SDMA0_GFX_CONTEXT_CNTL__RESUME_CTX__SHIFT                                                             0x10
#define SDMA0_GFX_CONTEXT_CNTL__SESSION_SEL__SHIFT                                                            0x18
#define SDMA0_GFX_CONTEXT_CNTL__RESUME_CTX_MASK                                                               0x00010000L
#define SDMA0_GFX_CONTEXT_CNTL__SESSION_SEL_MASK                                                              0x0F000000L
//SDMA0_GFX_STATUS
#define SDMA0_GFX_STATUS__WPTR_UPDATE_FAIL_COUNT__SHIFT                                                       0x0
#define SDMA0_GFX_STATUS__WPTR_UPDATE_PENDING__SHIFT                                                          0x8
#define SDMA0_GFX_STATUS__WPTR_UPDATE_FAIL_COUNT_MASK                                                         0x000000FFL
#define SDMA0_GFX_STATUS__WPTR_UPDATE_PENDING_MASK                                                            0x00000100L
//SDMA0_GFX_DOORBELL_LOG
#define SDMA0_GFX_DOORBELL_LOG__BE_ERROR__SHIFT                                                               0x0
#define SDMA0_GFX_DOORBELL_LOG__DATA__SHIFT                                                                   0x2
#define SDMA0_GFX_DOORBELL_LOG__BE_ERROR_MASK                                                                 0x00000001L
#define SDMA0_GFX_DOORBELL_LOG__DATA_MASK                                                                     0xFFFFFFFCL
//SDMA0_GFX_WATERMARK
#define SDMA0_GFX_WATERMARK__RD_OUTSTANDING__SHIFT                                                            0x0
#define SDMA0_GFX_WATERMARK__WR_OUTSTANDING__SHIFT                                                            0x10
#define SDMA0_GFX_WATERMARK__RD_OUTSTANDING_MASK                                                              0x00000FFFL
#define SDMA0_GFX_WATERMARK__WR_OUTSTANDING_MASK                                                              0x03FF0000L
//SDMA0_GFX_DOORBELL_OFFSET
#define SDMA0_GFX_DOORBELL_OFFSET__OFFSET__SHIFT                                                              0x2
#define SDMA0_GFX_DOORBELL_OFFSET__OFFSET_MASK                                                                0x0FFFFFFCL
//SDMA0_GFX_CSA_ADDR_LO
#define SDMA0_GFX_CSA_ADDR_LO__ADDR__SHIFT                                                                    0x2
#define SDMA0_GFX_CSA_ADDR_LO__ADDR_MASK                                                                      0xFFFFFFFCL
//SDMA0_GFX_CSA_ADDR_HI
#define SDMA0_GFX_CSA_ADDR_HI__ADDR__SHIFT                                                                    0x0
#define SDMA0_GFX_CSA_ADDR_HI__ADDR_MASK                                                                      0xFFFFFFFFL
//SDMA0_GFX_IB_SUB_REMAIN
#define SDMA0_GFX_IB_SUB_REMAIN__SIZE__SHIFT                                                                  0x0
#define SDMA0_GFX_IB_SUB_REMAIN__SIZE_MASK                                                                    0x00003FFFL
//SDMA0_GFX_PREEMPT
#define SDMA0_GFX_PREEMPT__IB_PREEMPT__SHIFT                                                                  0x0
#define SDMA0_GFX_PREEMPT__IB_PREEMPT_MASK                                                                    0x00000001L
//SDMA0_GFX_DUMMY_REG
#define SDMA0_GFX_DUMMY_REG__DUMMY__SHIFT                                                                     0x0
#define SDMA0_GFX_DUMMY_REG__DUMMY_MASK                                                                       0xFFFFFFFFL
//SDMA0_GFX_RB_WPTR_POLL_ADDR_HI
#define SDMA0_GFX_RB_WPTR_POLL_ADDR_HI__ADDR__SHIFT                                                           0x0
#define SDMA0_GFX_RB_WPTR_POLL_ADDR_HI__ADDR_MASK                                                             0xFFFFFFFFL
//SDMA0_GFX_RB_WPTR_POLL_ADDR_LO
#define SDMA0_GFX_RB_WPTR_POLL_ADDR_LO__ADDR__SHIFT                                                           0x2
#define SDMA0_GFX_RB_WPTR_POLL_ADDR_LO__ADDR_MASK                                                             0xFFFFFFFCL
//SDMA0_GFX_RB_AQL_CNTL
#define SDMA0_GFX_RB_AQL_CNTL__AQL_ENABLE__SHIFT                                                              0x0
#define SDMA0_GFX_RB_AQL_CNTL__AQL_PACKET_SIZE__SHIFT                                                         0x1
#define SDMA0_GFX_RB_AQL_CNTL__PACKET_STEP__SHIFT                                                             0x8
#define SDMA0_GFX_RB_AQL_CNTL__MIDCMD_PREEMPT_ENABLE__SHIFT                                                   0x10
#define SDMA0_GFX_RB_AQL_CNTL__MIDCMD_PREEMPT_DATA_RESTORE__SHIFT                                             0x11
#define SDMA0_GFX_RB_AQL_CNTL__OVERLAP_ENABLE__SHIFT                                                          0x12
#define SDMA0_GFX_RB_AQL_CNTL__AQL_ENABLE_MASK                                                                0x00000001L
#define SDMA0_GFX_RB_AQL_CNTL__AQL_PACKET_SIZE_MASK                                                           0x000000FEL
#define SDMA0_GFX_RB_AQL_CNTL__PACKET_STEP_MASK                                                               0x0000FF00L
#define SDMA0_GFX_RB_AQL_CNTL__MIDCMD_PREEMPT_ENABLE_MASK                                                     0x00010000L
#define SDMA0_GFX_RB_AQL_CNTL__MIDCMD_PREEMPT_DATA_RESTORE_MASK                                               0x00020000L
#define SDMA0_GFX_RB_AQL_CNTL__OVERLAP_ENABLE_MASK                                                            0x00040000L
//SDMA0_GFX_MINOR_PTR_UPDATE
#define SDMA0_GFX_MINOR_PTR_UPDATE__ENABLE__SHIFT                                                             0x0
#define SDMA0_GFX_MINOR_PTR_UPDATE__ENABLE_MASK                                                               0x00000001L
//SDMA0_GFX_MIDCMD_DATA0
#define SDMA0_GFX_MIDCMD_DATA0__DATA0__SHIFT                                                                  0x0
#define SDMA0_GFX_MIDCMD_DATA0__DATA0_MASK                                                                    0xFFFFFFFFL
//SDMA0_GFX_MIDCMD_DATA1
#define SDMA0_GFX_MIDCMD_DATA1__DATA1__SHIFT                                                                  0x0
#define SDMA0_GFX_MIDCMD_DATA1__DATA1_MASK                                                                    0xFFFFFFFFL
//SDMA0_GFX_MIDCMD_DATA2
#define SDMA0_GFX_MIDCMD_DATA2__DATA2__SHIFT                                                                  0x0
#define SDMA0_GFX_MIDCMD_DATA2__DATA2_MASK                                                                    0xFFFFFFFFL
//SDMA0_GFX_MIDCMD_DATA3
#define SDMA0_GFX_MIDCMD_DATA3__DATA3__SHIFT                                                                  0x0
#define SDMA0_GFX_MIDCMD_DATA3__DATA3_MASK                                                                    0xFFFFFFFFL
//SDMA0_GFX_MIDCMD_DATA4
#define SDMA0_GFX_MIDCMD_DATA4__DATA4__SHIFT                                                                  0x0
#define SDMA0_GFX_MIDCMD_DATA4__DATA4_MASK                                                                    0xFFFFFFFFL
//SDMA0_GFX_MIDCMD_DATA5
#define SDMA0_GFX_MIDCMD_DATA5__DATA5__SHIFT                                                                  0x0
#define SDMA0_GFX_MIDCMD_DATA5__DATA5_MASK                                                                    0xFFFFFFFFL
//SDMA0_GFX_MIDCMD_DATA6
#define SDMA0_GFX_MIDCMD_DATA6__DATA6__SHIFT                                                                  0x0
#define SDMA0_GFX_MIDCMD_DATA6__DATA6_MASK                                                                    0xFFFFFFFFL
//SDMA0_GFX_MIDCMD_DATA7
#define SDMA0_GFX_MIDCMD_DATA7__DATA7__SHIFT                                                                  0x0
#define SDMA0_GFX_MIDCMD_DATA7__DATA7_MASK                                                                    0xFFFFFFFFL
//SDMA0_GFX_MIDCMD_DATA8
#define SDMA0_GFX_MIDCMD_DATA8__DATA8__SHIFT                                                                  0x0
#define SDMA0_GFX_MIDCMD_DATA8__DATA8_MASK                                                                    0xFFFFFFFFL
//SDMA0_GFX_MIDCMD_DATA9
#define SDMA0_GFX_MIDCMD_DATA9__DATA9__SHIFT                                                                  0x0
#define SDMA0_GFX_MIDCMD_DATA9__DATA9_MASK                                                                    0xFFFFFFFFL
//SDMA0_GFX_MIDCMD_DATA10
#define SDMA0_GFX_MIDCMD_DATA10__DATA10__SHIFT                                                                0x0
#define SDMA0_GFX_MIDCMD_DATA10__DATA10_MASK                                                                  0xFFFFFFFFL
//SDMA0_GFX_MIDCMD_CNTL
#define SDMA0_GFX_MIDCMD_CNTL__DATA_VALID__SHIFT                                                              0x0
#define SDMA0_GFX_MIDCMD_CNTL__COPY_MODE__SHIFT                                                               0x1
#define SDMA0_GFX_MIDCMD_CNTL__SPLIT_STATE__SHIFT                                                             0x4
#define SDMA0_GFX_MIDCMD_CNTL__ALLOW_PREEMPT__SHIFT                                                           0x8
#define SDMA0_GFX_MIDCMD_CNTL__DATA_VALID_MASK                                                                0x00000001L
#define SDMA0_GFX_MIDCMD_CNTL__COPY_MODE_MASK                                                                 0x00000002L
#define SDMA0_GFX_MIDCMD_CNTL__SPLIT_STATE_MASK                                                               0x000000F0L
#define SDMA0_GFX_MIDCMD_CNTL__ALLOW_PREEMPT_MASK                                                             0x00000100L
//SDMA0_PAGE_RB_CNTL
#define SDMA0_PAGE_RB_CNTL__RB_ENABLE__SHIFT                                                                  0x0
#define SDMA0_PAGE_RB_CNTL__RB_SIZE__SHIFT                                                                    0x1
#define SDMA0_PAGE_RB_CNTL__RB_SWAP_ENABLE__SHIFT                                                             0x9
#define SDMA0_PAGE_RB_CNTL__RPTR_WRITEBACK_ENABLE__SHIFT                                                      0xc
#define SDMA0_PAGE_RB_CNTL__RPTR_WRITEBACK_SWAP_ENABLE__SHIFT                                                 0xd
#define SDMA0_PAGE_RB_CNTL__RPTR_WRITEBACK_TIMER__SHIFT                                                       0x10
#define SDMA0_PAGE_RB_CNTL__RB_PRIV__SHIFT                                                                    0x17
#define SDMA0_PAGE_RB_CNTL__RB_VMID__SHIFT                                                                    0x18
#define SDMA0_PAGE_RB_CNTL__RPTR_WB_IDLE__SHIFT                                                               0x1f
#define SDMA0_PAGE_RB_CNTL__RB_ENABLE_MASK                                                                    0x00000001L
#define SDMA0_PAGE_RB_CNTL__RB_SIZE_MASK                                                                      0x0000003EL
#define SDMA0_PAGE_RB_CNTL__RB_SWAP_ENABLE_MASK                                                               0x00000200L
#define SDMA0_PAGE_RB_CNTL__RPTR_WRITEBACK_ENABLE_MASK                                                        0x00001000L
#define SDMA0_PAGE_RB_CNTL__RPTR_WRITEBACK_SWAP_ENABLE_MASK                                                   0x00002000L
#define SDMA0_PAGE_RB_CNTL__RPTR_WRITEBACK_TIMER_MASK                                                         0x001F0000L
#define SDMA0_PAGE_RB_CNTL__RB_PRIV_MASK                                                                      0x00800000L
#define SDMA0_PAGE_RB_CNTL__RB_VMID_MASK                                                                      0x0F000000L
#define SDMA0_PAGE_RB_CNTL__RPTR_WB_IDLE_MASK                                                                 0x80000000L
//SDMA0_PAGE_RB_BASE
#define SDMA0_PAGE_RB_BASE__ADDR__SHIFT                                                                       0x0
#define SDMA0_PAGE_RB_BASE__ADDR_MASK                                                                         0xFFFFFFFFL
//SDMA0_PAGE_RB_BASE_HI
#define SDMA0_PAGE_RB_BASE_HI__ADDR__SHIFT                                                                    0x0
#define SDMA0_PAGE_RB_BASE_HI__ADDR_MASK                                                                      0x00FFFFFFL
//SDMA0_PAGE_RB_RPTR
#define SDMA0_PAGE_RB_RPTR__OFFSET__SHIFT                                                                     0x0
#define SDMA0_PAGE_RB_RPTR__OFFSET_MASK                                                                       0xFFFFFFFFL
//SDMA0_PAGE_RB_RPTR_HI
#define SDMA0_PAGE_RB_RPTR_HI__OFFSET__SHIFT                                                                  0x0
#define SDMA0_PAGE_RB_RPTR_HI__OFFSET_MASK                                                                    0xFFFFFFFFL
//SDMA0_PAGE_RB_WPTR
#define SDMA0_PAGE_RB_WPTR__OFFSET__SHIFT                                                                     0x0
#define SDMA0_PAGE_RB_WPTR__OFFSET_MASK                                                                       0xFFFFFFFFL
//SDMA0_PAGE_RB_WPTR_HI
#define SDMA0_PAGE_RB_WPTR_HI__OFFSET__SHIFT                                                                  0x0
#define SDMA0_PAGE_RB_WPTR_HI__OFFSET_MASK                                                                    0xFFFFFFFFL
//SDMA0_PAGE_RB_WPTR_POLL_CNTL
#define SDMA0_PAGE_RB_WPTR_POLL_CNTL__ENABLE__SHIFT                                                           0x0
#define SDMA0_PAGE_RB_WPTR_POLL_CNTL__SWAP_ENABLE__SHIFT                                                      0x1
#define SDMA0_PAGE_RB_WPTR_POLL_CNTL__F32_POLL_ENABLE__SHIFT                                                  0x2
#define SDMA0_PAGE_RB_WPTR_POLL_CNTL__FREQUENCY__SHIFT                                                        0x4
#define SDMA0_PAGE_RB_WPTR_POLL_CNTL__IDLE_POLL_COUNT__SHIFT                                                  0x10
#define SDMA0_PAGE_RB_WPTR_POLL_CNTL__ENABLE_MASK                                                             0x00000001L
#define SDMA0_PAGE_RB_WPTR_POLL_CNTL__SWAP_ENABLE_MASK                                                        0x00000002L
#define SDMA0_PAGE_RB_WPTR_POLL_CNTL__F32_POLL_ENABLE_MASK                                                    0x00000004L
#define SDMA0_PAGE_RB_WPTR_POLL_CNTL__FREQUENCY_MASK                                                          0x0000FFF0L
#define SDMA0_PAGE_RB_WPTR_POLL_CNTL__IDLE_POLL_COUNT_MASK                                                    0xFFFF0000L
//SDMA0_PAGE_RB_RPTR_ADDR_HI
#define SDMA0_PAGE_RB_RPTR_ADDR_HI__ADDR__SHIFT                                                               0x0
#define SDMA0_PAGE_RB_RPTR_ADDR_HI__ADDR_MASK                                                                 0xFFFFFFFFL
//SDMA0_PAGE_RB_RPTR_ADDR_LO
#define SDMA0_PAGE_RB_RPTR_ADDR_LO__ADDR__SHIFT                                                               0x2
#define SDMA0_PAGE_RB_RPTR_ADDR_LO__ADDR_MASK                                                                 0xFFFFFFFCL
//SDMA0_PAGE_IB_CNTL
#define SDMA0_PAGE_IB_CNTL__IB_ENABLE__SHIFT                                                                  0x0
#define SDMA0_PAGE_IB_CNTL__IB_SWAP_ENABLE__SHIFT                                                             0x4
#define SDMA0_PAGE_IB_CNTL__SWITCH_INSIDE_IB__SHIFT                                                           0x8
#define SDMA0_PAGE_IB_CNTL__CMD_VMID__SHIFT                                                                   0x10
#define SDMA0_PAGE_IB_CNTL__IB_ENABLE_MASK                                                                    0x00000001L
#define SDMA0_PAGE_IB_CNTL__IB_SWAP_ENABLE_MASK                                                               0x00000010L
#define SDMA0_PAGE_IB_CNTL__SWITCH_INSIDE_IB_MASK                                                             0x00000100L
#define SDMA0_PAGE_IB_CNTL__CMD_VMID_MASK                                                                     0x000F0000L
//SDMA0_PAGE_IB_RPTR
#define SDMA0_PAGE_IB_RPTR__OFFSET__SHIFT                                                                     0x2
#define SDMA0_PAGE_IB_RPTR__OFFSET_MASK                                                                       0x003FFFFCL
//SDMA0_PAGE_IB_OFFSET
#define SDMA0_PAGE_IB_OFFSET__OFFSET__SHIFT                                                                   0x2
#define SDMA0_PAGE_IB_OFFSET__OFFSET_MASK                                                                     0x003FFFFCL
//SDMA0_PAGE_IB_BASE_LO
#define SDMA0_PAGE_IB_BASE_LO__ADDR__SHIFT                                                                    0x5
#define SDMA0_PAGE_IB_BASE_LO__ADDR_MASK                                                                      0xFFFFFFE0L
//SDMA0_PAGE_IB_BASE_HI
#define SDMA0_PAGE_IB_BASE_HI__ADDR__SHIFT                                                                    0x0
#define SDMA0_PAGE_IB_BASE_HI__ADDR_MASK                                                                      0xFFFFFFFFL
//SDMA0_PAGE_IB_SIZE
#define SDMA0_PAGE_IB_SIZE__SIZE__SHIFT                                                                       0x0
#define SDMA0_PAGE_IB_SIZE__SIZE_MASK                                                                         0x000FFFFFL
//SDMA0_PAGE_SKIP_CNTL
#define SDMA0_PAGE_SKIP_CNTL__SKIP_COUNT__SHIFT                                                               0x0
#define SDMA0_PAGE_SKIP_CNTL__SKIP_COUNT_MASK                                                                 0x000FFFFFL
//SDMA0_PAGE_CONTEXT_STATUS
#define SDMA0_PAGE_CONTEXT_STATUS__SELECTED__SHIFT                                                            0x0
#define SDMA0_PAGE_CONTEXT_STATUS__IDLE__SHIFT                                                                0x2
#define SDMA0_PAGE_CONTEXT_STATUS__EXPIRED__SHIFT                                                             0x3
#define SDMA0_PAGE_CONTEXT_STATUS__EXCEPTION__SHIFT                                                           0x4
#define SDMA0_PAGE_CONTEXT_STATUS__CTXSW_ABLE__SHIFT                                                          0x7
#define SDMA0_PAGE_CONTEXT_STATUS__CTXSW_READY__SHIFT                                                         0x8
#define SDMA0_PAGE_CONTEXT_STATUS__PREEMPTED__SHIFT                                                           0x9
#define SDMA0_PAGE_CONTEXT_STATUS__PREEMPT_DISABLE__SHIFT                                                     0xa
#define SDMA0_PAGE_CONTEXT_STATUS__SELECTED_MASK                                                              0x00000001L
#define SDMA0_PAGE_CONTEXT_STATUS__IDLE_MASK                                                                  0x00000004L
#define SDMA0_PAGE_CONTEXT_STATUS__EXPIRED_MASK                                                               0x00000008L
#define SDMA0_PAGE_CONTEXT_STATUS__EXCEPTION_MASK                                                             0x00000070L
#define SDMA0_PAGE_CONTEXT_STATUS__CTXSW_ABLE_MASK                                                            0x00000080L
#define SDMA0_PAGE_CONTEXT_STATUS__CTXSW_READY_MASK                                                           0x00000100L
#define SDMA0_PAGE_CONTEXT_STATUS__PREEMPTED_MASK                                                             0x00000200L
#define SDMA0_PAGE_CONTEXT_STATUS__PREEMPT_DISABLE_MASK                                                       0x00000400L
//SDMA0_PAGE_DOORBELL
#define SDMA0_PAGE_DOORBELL__ENABLE__SHIFT                                                                    0x1c
#define SDMA0_PAGE_DOORBELL__CAPTURED__SHIFT                                                                  0x1e
#define SDMA0_PAGE_DOORBELL__ENABLE_MASK                                                                      0x10000000L
#define SDMA0_PAGE_DOORBELL__CAPTURED_MASK                                                                    0x40000000L
//SDMA0_PAGE_STATUS
#define SDMA0_PAGE_STATUS__WPTR_UPDATE_FAIL_COUNT__SHIFT                                                      0x0
#define SDMA0_PAGE_STATUS__WPTR_UPDATE_PENDING__SHIFT                                                         0x8
#define SDMA0_PAGE_STATUS__WPTR_UPDATE_FAIL_COUNT_MASK                                                        0x000000FFL
#define SDMA0_PAGE_STATUS__WPTR_UPDATE_PENDING_MASK                                                           0x00000100L
//SDMA0_PAGE_DOORBELL_LOG
#define SDMA0_PAGE_DOORBELL_LOG__BE_ERROR__SHIFT                                                              0x0
#define SDMA0_PAGE_DOORBELL_LOG__DATA__SHIFT                                                                  0x2
#define SDMA0_PAGE_DOORBELL_LOG__BE_ERROR_MASK                                                                0x00000001L
#define SDMA0_PAGE_DOORBELL_LOG__DATA_MASK                                                                    0xFFFFFFFCL
//SDMA0_PAGE_WATERMARK
#define SDMA0_PAGE_WATERMARK__RD_OUTSTANDING__SHIFT                                                           0x0
#define SDMA0_PAGE_WATERMARK__WR_OUTSTANDING__SHIFT                                                           0x10
#define SDMA0_PAGE_WATERMARK__RD_OUTSTANDING_MASK                                                             0x00000FFFL
#define SDMA0_PAGE_WATERMARK__WR_OUTSTANDING_MASK                                                             0x03FF0000L
//SDMA0_PAGE_DOORBELL_OFFSET
#define SDMA0_PAGE_DOORBELL_OFFSET__OFFSET__SHIFT                                                             0x2
#define SDMA0_PAGE_DOORBELL_OFFSET__OFFSET_MASK                                                               0x0FFFFFFCL
//SDMA0_PAGE_CSA_ADDR_LO
#define SDMA0_PAGE_CSA_ADDR_LO__ADDR__SHIFT                                                                   0x2
#define SDMA0_PAGE_CSA_ADDR_LO__ADDR_MASK                                                                     0xFFFFFFFCL
//SDMA0_PAGE_CSA_ADDR_HI
#define SDMA0_PAGE_CSA_ADDR_HI__ADDR__SHIFT                                                                   0x0
#define SDMA0_PAGE_CSA_ADDR_HI__ADDR_MASK                                                                     0xFFFFFFFFL
//SDMA0_PAGE_IB_SUB_REMAIN
#define SDMA0_PAGE_IB_SUB_REMAIN__SIZE__SHIFT                                                                 0x0
#define SDMA0_PAGE_IB_SUB_REMAIN__SIZE_MASK                                                                   0x00003FFFL
//SDMA0_PAGE_PREEMPT
#define SDMA0_PAGE_PREEMPT__IB_PREEMPT__SHIFT                                                                 0x0
#define SDMA0_PAGE_PREEMPT__IB_PREEMPT_MASK                                                                   0x00000001L
//SDMA0_PAGE_DUMMY_REG
#define SDMA0_PAGE_DUMMY_REG__DUMMY__SHIFT                                                                    0x0
#define SDMA0_PAGE_DUMMY_REG__DUMMY_MASK                                                                      0xFFFFFFFFL
//SDMA0_PAGE_RB_WPTR_POLL_ADDR_HI
#define SDMA0_PAGE_RB_WPTR_POLL_ADDR_HI__ADDR__SHIFT                                                          0x0
#define SDMA0_PAGE_RB_WPTR_POLL_ADDR_HI__ADDR_MASK                                                            0xFFFFFFFFL
//SDMA0_PAGE_RB_WPTR_POLL_ADDR_LO
#define SDMA0_PAGE_RB_WPTR_POLL_ADDR_LO__ADDR__SHIFT                                                          0x2
#define SDMA0_PAGE_RB_WPTR_POLL_ADDR_LO__ADDR_MASK                                                            0xFFFFFFFCL
//SDMA0_PAGE_RB_AQL_CNTL
#define SDMA0_PAGE_RB_AQL_CNTL__AQL_ENABLE__SHIFT                                                             0x0
#define SDMA0_PAGE_RB_AQL_CNTL__AQL_PACKET_SIZE__SHIFT                                                        0x1
#define SDMA0_PAGE_RB_AQL_CNTL__PACKET_STEP__SHIFT                                                            0x8
#define SDMA0_PAGE_RB_AQL_CNTL__MIDCMD_PREEMPT_ENABLE__SHIFT                                                  0x10
#define SDMA0_PAGE_RB_AQL_CNTL__MIDCMD_PREEMPT_DATA_RESTORE__SHIFT                                            0x11
#define SDMA0_PAGE_RB_AQL_CNTL__OVERLAP_ENABLE__SHIFT                                                         0x12
#define SDMA0_PAGE_RB_AQL_CNTL__AQL_ENABLE_MASK                                                               0x00000001L
#define SDMA0_PAGE_RB_AQL_CNTL__AQL_PACKET_SIZE_MASK                                                          0x000000FEL
#define SDMA0_PAGE_RB_AQL_CNTL__PACKET_STEP_MASK                                                              0x0000FF00L
#define SDMA0_PAGE_RB_AQL_CNTL__MIDCMD_PREEMPT_ENABLE_MASK                                                    0x00010000L
#define SDMA0_PAGE_RB_AQL_CNTL__MIDCMD_PREEMPT_DATA_RESTORE_MASK                                              0x00020000L
#define SDMA0_PAGE_RB_AQL_CNTL__OVERLAP_ENABLE_MASK                                                           0x00040000L
//SDMA0_PAGE_MINOR_PTR_UPDATE
#define SDMA0_PAGE_MINOR_PTR_UPDATE__ENABLE__SHIFT                                                            0x0
#define SDMA0_PAGE_MINOR_PTR_UPDATE__ENABLE_MASK                                                              0x00000001L
//SDMA0_PAGE_MIDCMD_DATA0
#define SDMA0_PAGE_MIDCMD_DATA0__DATA0__SHIFT                                                                 0x0
#define SDMA0_PAGE_MIDCMD_DATA0__DATA0_MASK                                                                   0xFFFFFFFFL
//SDMA0_PAGE_MIDCMD_DATA1
#define SDMA0_PAGE_MIDCMD_DATA1__DATA1__SHIFT                                                                 0x0
#define SDMA0_PAGE_MIDCMD_DATA1__DATA1_MASK                                                                   0xFFFFFFFFL
//SDMA0_PAGE_MIDCMD_DATA2
#define SDMA0_PAGE_MIDCMD_DATA2__DATA2__SHIFT                                                                 0x0
#define SDMA0_PAGE_MIDCMD_DATA2__DATA2_MASK                                                                   0xFFFFFFFFL
//SDMA0_PAGE_MIDCMD_DATA3
#define SDMA0_PAGE_MIDCMD_DATA3__DATA3__SHIFT                                                                 0x0
#define SDMA0_PAGE_MIDCMD_DATA3__DATA3_MASK                                                                   0xFFFFFFFFL
//SDMA0_PAGE_MIDCMD_DATA4
#define SDMA0_PAGE_MIDCMD_DATA4__DATA4__SHIFT                                                                 0x0
#define SDMA0_PAGE_MIDCMD_DATA4__DATA4_MASK                                                                   0xFFFFFFFFL
//SDMA0_PAGE_MIDCMD_DATA5
#define SDMA0_PAGE_MIDCMD_DATA5__DATA5__SHIFT                                                                 0x0
#define SDMA0_PAGE_MIDCMD_DATA5__DATA5_MASK                                                                   0xFFFFFFFFL
//SDMA0_PAGE_MIDCMD_DATA6
#define SDMA0_PAGE_MIDCMD_DATA6__DATA6__SHIFT                                                                 0x0
#define SDMA0_PAGE_MIDCMD_DATA6__DATA6_MASK                                                                   0xFFFFFFFFL
//SDMA0_PAGE_MIDCMD_DATA7
#define SDMA0_PAGE_MIDCMD_DATA7__DATA7__SHIFT                                                                 0x0
#define SDMA0_PAGE_MIDCMD_DATA7__DATA7_MASK                                                                   0xFFFFFFFFL
//SDMA0_PAGE_MIDCMD_DATA8
#define SDMA0_PAGE_MIDCMD_DATA8__DATA8__SHIFT                                                                 0x0
#define SDMA0_PAGE_MIDCMD_DATA8__DATA8_MASK                                                                   0xFFFFFFFFL
//SDMA0_PAGE_MIDCMD_DATA9
#define SDMA0_PAGE_MIDCMD_DATA9__DATA9__SHIFT                                                                 0x0
#define SDMA0_PAGE_MIDCMD_DATA9__DATA9_MASK                                                                   0xFFFFFFFFL
//SDMA0_PAGE_MIDCMD_DATA10
#define SDMA0_PAGE_MIDCMD_DATA10__DATA10__SHIFT                                                               0x0
#define SDMA0_PAGE_MIDCMD_DATA10__DATA10_MASK                                                                 0xFFFFFFFFL
//SDMA0_PAGE_MIDCMD_CNTL
#define SDMA0_PAGE_MIDCMD_CNTL__DATA_VALID__SHIFT                                                             0x0
#define SDMA0_PAGE_MIDCMD_CNTL__COPY_MODE__SHIFT                                                              0x1
#define SDMA0_PAGE_MIDCMD_CNTL__SPLIT_STATE__SHIFT                                                            0x4
#define SDMA0_PAGE_MIDCMD_CNTL__ALLOW_PREEMPT__SHIFT                                                          0x8
#define SDMA0_PAGE_MIDCMD_CNTL__DATA_VALID_MASK                                                               0x00000001L
#define SDMA0_PAGE_MIDCMD_CNTL__COPY_MODE_MASK                                                                0x00000002L
#define SDMA0_PAGE_MIDCMD_CNTL__SPLIT_STATE_MASK                                                              0x000000F0L
#define SDMA0_PAGE_MIDCMD_CNTL__ALLOW_PREEMPT_MASK                                                            0x00000100L
//SDMA0_RLC0_RB_CNTL
#define SDMA0_RLC0_RB_CNTL__RB_ENABLE__SHIFT                                                                  0x0
#define SDMA0_RLC0_RB_CNTL__RB_SIZE__SHIFT                                                                    0x1
#define SDMA0_RLC0_RB_CNTL__RB_SWAP_ENABLE__SHIFT                                                             0x9
#define SDMA0_RLC0_RB_CNTL__RPTR_WRITEBACK_ENABLE__SHIFT                                                      0xc
#define SDMA0_RLC0_RB_CNTL__RPTR_WRITEBACK_SWAP_ENABLE__SHIFT                                                 0xd
#define SDMA0_RLC0_RB_CNTL__RPTR_WRITEBACK_TIMER__SHIFT                                                       0x10
#define SDMA0_RLC0_RB_CNTL__RB_PRIV__SHIFT                                                                    0x17
#define SDMA0_RLC0_RB_CNTL__RB_VMID__SHIFT                                                                    0x18
#define SDMA0_RLC0_RB_CNTL__RPTR_WB_IDLE__SHIFT                                                               0x1f
#define SDMA0_RLC0_RB_CNTL__RB_ENABLE_MASK                                                                    0x00000001L
#define SDMA0_RLC0_RB_CNTL__RB_SIZE_MASK                                                                      0x0000003EL
#define SDMA0_RLC0_RB_CNTL__RB_SWAP_ENABLE_MASK                                                               0x00000200L
#define SDMA0_RLC0_RB_CNTL__RPTR_WRITEBACK_ENABLE_MASK                                                        0x00001000L
#define SDMA0_RLC0_RB_CNTL__RPTR_WRITEBACK_SWAP_ENABLE_MASK                                                   0x00002000L
#define SDMA0_RLC0_RB_CNTL__RPTR_WRITEBACK_TIMER_MASK                                                         0x001F0000L
#define SDMA0_RLC0_RB_CNTL__RB_PRIV_MASK                                                                      0x00800000L
#define SDMA0_RLC0_RB_CNTL__RB_VMID_MASK                                                                      0x0F000000L
#define SDMA0_RLC0_RB_CNTL__RPTR_WB_IDLE_MASK                                                                 0x80000000L
//SDMA0_RLC0_RB_BASE
#define SDMA0_RLC0_RB_BASE__ADDR__SHIFT                                                                       0x0
#define SDMA0_RLC0_RB_BASE__ADDR_MASK                                                                         0xFFFFFFFFL
//SDMA0_RLC0_RB_BASE_HI
#define SDMA0_RLC0_RB_BASE_HI__ADDR__SHIFT                                                                    0x0
#define SDMA0_RLC0_RB_BASE_HI__ADDR_MASK                                                                      0x00FFFFFFL
//SDMA0_RLC0_RB_RPTR
#define SDMA0_RLC0_RB_RPTR__OFFSET__SHIFT                                                                     0x0
#define SDMA0_RLC0_RB_RPTR__OFFSET_MASK                                                                       0xFFFFFFFFL
//SDMA0_RLC0_RB_RPTR_HI
#define SDMA0_RLC0_RB_RPTR_HI__OFFSET__SHIFT                                                                  0x0
#define SDMA0_RLC0_RB_RPTR_HI__OFFSET_MASK                                                                    0xFFFFFFFFL
//SDMA0_RLC0_RB_WPTR
#define SDMA0_RLC0_RB_WPTR__OFFSET__SHIFT                                                                     0x0
#define SDMA0_RLC0_RB_WPTR__OFFSET_MASK                                                                       0xFFFFFFFFL
//SDMA0_RLC0_RB_WPTR_HI
#define SDMA0_RLC0_RB_WPTR_HI__OFFSET__SHIFT                                                                  0x0
#define SDMA0_RLC0_RB_WPTR_HI__OFFSET_MASK                                                                    0xFFFFFFFFL
//SDMA0_RLC0_RB_WPTR_POLL_CNTL
#define SDMA0_RLC0_RB_WPTR_POLL_CNTL__ENABLE__SHIFT                                                           0x0
#define SDMA0_RLC0_RB_WPTR_POLL_CNTL__SWAP_ENABLE__SHIFT                                                      0x1
#define SDMA0_RLC0_RB_WPTR_POLL_CNTL__F32_POLL_ENABLE__SHIFT                                                  0x2
#define SDMA0_RLC0_RB_WPTR_POLL_CNTL__FREQUENCY__SHIFT                                                        0x4
#define SDMA0_RLC0_RB_WPTR_POLL_CNTL__IDLE_POLL_COUNT__SHIFT                                                  0x10
#define SDMA0_RLC0_RB_WPTR_POLL_CNTL__ENABLE_MASK                                                             0x00000001L
#define SDMA0_RLC0_RB_WPTR_POLL_CNTL__SWAP_ENABLE_MASK                                                        0x00000002L
#define SDMA0_RLC0_RB_WPTR_POLL_CNTL__F32_POLL_ENABLE_MASK                                                    0x00000004L
#define SDMA0_RLC0_RB_WPTR_POLL_CNTL__FREQUENCY_MASK                                                          0x0000FFF0L
#define SDMA0_RLC0_RB_WPTR_POLL_CNTL__IDLE_POLL_COUNT_MASK                                                    0xFFFF0000L
//SDMA0_RLC0_RB_RPTR_ADDR_HI
#define SDMA0_RLC0_RB_RPTR_ADDR_HI__ADDR__SHIFT                                                               0x0
#define SDMA0_RLC0_RB_RPTR_ADDR_HI__ADDR_MASK                                                                 0xFFFFFFFFL
//SDMA0_RLC0_RB_RPTR_ADDR_LO
#define SDMA0_RLC0_RB_RPTR_ADDR_LO__ADDR__SHIFT                                                               0x2
#define SDMA0_RLC0_RB_RPTR_ADDR_LO__ADDR_MASK                                                                 0xFFFFFFFCL
//SDMA0_RLC0_IB_CNTL
#define SDMA0_RLC0_IB_CNTL__IB_ENABLE__SHIFT                                                                  0x0
#define SDMA0_RLC0_IB_CNTL__IB_SWAP_ENABLE__SHIFT                                                             0x4
#define SDMA0_RLC0_IB_CNTL__SWITCH_INSIDE_IB__SHIFT                                                           0x8
#define SDMA0_RLC0_IB_CNTL__CMD_VMID__SHIFT                                                                   0x10
#define SDMA0_RLC0_IB_CNTL__IB_ENABLE_MASK                                                                    0x00000001L
#define SDMA0_RLC0_IB_CNTL__IB_SWAP_ENABLE_MASK                                                               0x00000010L
#define SDMA0_RLC0_IB_CNTL__SWITCH_INSIDE_IB_MASK                                                             0x00000100L
#define SDMA0_RLC0_IB_CNTL__CMD_VMID_MASK                                                                     0x000F0000L
//SDMA0_RLC0_IB_RPTR
#define SDMA0_RLC0_IB_RPTR__OFFSET__SHIFT                                                                     0x2
#define SDMA0_RLC0_IB_RPTR__OFFSET_MASK                                                                       0x003FFFFCL
//SDMA0_RLC0_IB_OFFSET
#define SDMA0_RLC0_IB_OFFSET__OFFSET__SHIFT                                                                   0x2
#define SDMA0_RLC0_IB_OFFSET__OFFSET_MASK                                                                     0x003FFFFCL
//SDMA0_RLC0_IB_BASE_LO
#define SDMA0_RLC0_IB_BASE_LO__ADDR__SHIFT                                                                    0x5
#define SDMA0_RLC0_IB_BASE_LO__ADDR_MASK                                                                      0xFFFFFFE0L
//SDMA0_RLC0_IB_BASE_HI
#define SDMA0_RLC0_IB_BASE_HI__ADDR__SHIFT                                                                    0x0
#define SDMA0_RLC0_IB_BASE_HI__ADDR_MASK                                                                      0xFFFFFFFFL
//SDMA0_RLC0_IB_SIZE
#define SDMA0_RLC0_IB_SIZE__SIZE__SHIFT                                                                       0x0
#define SDMA0_RLC0_IB_SIZE__SIZE_MASK                                                                         0x000FFFFFL
//SDMA0_RLC0_SKIP_CNTL
#define SDMA0_RLC0_SKIP_CNTL__SKIP_COUNT__SHIFT                                                               0x0
#define SDMA0_RLC0_SKIP_CNTL__SKIP_COUNT_MASK                                                                 0x000FFFFFL
//SDMA0_RLC0_CONTEXT_STATUS
#define SDMA0_RLC0_CONTEXT_STATUS__SELECTED__SHIFT                                                            0x0
#define SDMA0_RLC0_CONTEXT_STATUS__IDLE__SHIFT                                                                0x2
#define SDMA0_RLC0_CONTEXT_STATUS__EXPIRED__SHIFT                                                             0x3
#define SDMA0_RLC0_CONTEXT_STATUS__EXCEPTION__SHIFT                                                           0x4
#define SDMA0_RLC0_CONTEXT_STATUS__CTXSW_ABLE__SHIFT                                                          0x7
#define SDMA0_RLC0_CONTEXT_STATUS__CTXSW_READY__SHIFT                                                         0x8
#define SDMA0_RLC0_CONTEXT_STATUS__PREEMPTED__SHIFT                                                           0x9
#define SDMA0_RLC0_CONTEXT_STATUS__PREEMPT_DISABLE__SHIFT                                                     0xa
#define SDMA0_RLC0_CONTEXT_STATUS__SELECTED_MASK                                                              0x00000001L
#define SDMA0_RLC0_CONTEXT_STATUS__IDLE_MASK                                                                  0x00000004L
#define SDMA0_RLC0_CONTEXT_STATUS__EXPIRED_MASK                                                               0x00000008L
#define SDMA0_RLC0_CONTEXT_STATUS__EXCEPTION_MASK                                                             0x00000070L
#define SDMA0_RLC0_CONTEXT_STATUS__CTXSW_ABLE_MASK                                                            0x00000080L
#define SDMA0_RLC0_CONTEXT_STATUS__CTXSW_READY_MASK                                                           0x00000100L
#define SDMA0_RLC0_CONTEXT_STATUS__PREEMPTED_MASK                                                             0x00000200L
#define SDMA0_RLC0_CONTEXT_STATUS__PREEMPT_DISABLE_MASK                                                       0x00000400L
//SDMA0_RLC0_DOORBELL
#define SDMA0_RLC0_DOORBELL__ENABLE__SHIFT                                                                    0x1c
#define SDMA0_RLC0_DOORBELL__CAPTURED__SHIFT                                                                  0x1e
#define SDMA0_RLC0_DOORBELL__ENABLE_MASK                                                                      0x10000000L
#define SDMA0_RLC0_DOORBELL__CAPTURED_MASK                                                                    0x40000000L
//SDMA0_RLC0_STATUS
#define SDMA0_RLC0_STATUS__WPTR_UPDATE_FAIL_COUNT__SHIFT                                                      0x0
#define SDMA0_RLC0_STATUS__WPTR_UPDATE_PENDING__SHIFT                                                         0x8
#define SDMA0_RLC0_STATUS__WPTR_UPDATE_FAIL_COUNT_MASK                                                        0x000000FFL
#define SDMA0_RLC0_STATUS__WPTR_UPDATE_PENDING_MASK                                                           0x00000100L
//SDMA0_RLC0_DOORBELL_LOG
#define SDMA0_RLC0_DOORBELL_LOG__BE_ERROR__SHIFT                                                              0x0
#define SDMA0_RLC0_DOORBELL_LOG__DATA__SHIFT                                                                  0x2
#define SDMA0_RLC0_DOORBELL_LOG__BE_ERROR_MASK                                                                0x00000001L
#define SDMA0_RLC0_DOORBELL_LOG__DATA_MASK                                                                    0xFFFFFFFCL
//SDMA0_RLC0_WATERMARK
#define SDMA0_RLC0_WATERMARK__RD_OUTSTANDING__SHIFT                                                           0x0
#define SDMA0_RLC0_WATERMARK__WR_OUTSTANDING__SHIFT                                                           0x10
#define SDMA0_RLC0_WATERMARK__RD_OUTSTANDING_MASK                                                             0x00000FFFL
#define SDMA0_RLC0_WATERMARK__WR_OUTSTANDING_MASK                                                             0x03FF0000L
//SDMA0_RLC0_DOORBELL_OFFSET
#define SDMA0_RLC0_DOORBELL_OFFSET__OFFSET__SHIFT                                                             0x2
#define SDMA0_RLC0_DOORBELL_OFFSET__OFFSET_MASK                                                               0x0FFFFFFCL
//SDMA0_RLC0_CSA_ADDR_LO
#define SDMA0_RLC0_CSA_ADDR_LO__ADDR__SHIFT                                                                   0x2
#define SDMA0_RLC0_CSA_ADDR_LO__ADDR_MASK                                                                     0xFFFFFFFCL
//SDMA0_RLC0_CSA_ADDR_HI
#define SDMA0_RLC0_CSA_ADDR_HI__ADDR__SHIFT                                                                   0x0
#define SDMA0_RLC0_CSA_ADDR_HI__ADDR_MASK                                                                     0xFFFFFFFFL
//SDMA0_RLC0_IB_SUB_REMAIN
#define SDMA0_RLC0_IB_SUB_REMAIN__SIZE__SHIFT                                                                 0x0
#define SDMA0_RLC0_IB_SUB_REMAIN__SIZE_MASK                                                                   0x00003FFFL
//SDMA0_RLC0_PREEMPT
#define SDMA0_RLC0_PREEMPT__IB_PREEMPT__SHIFT                                                                 0x0
#define SDMA0_RLC0_PREEMPT__IB_PREEMPT_MASK                                                                   0x00000001L
//SDMA0_RLC0_DUMMY_REG
#define SDMA0_RLC0_DUMMY_REG__DUMMY__SHIFT                                                                    0x0
#define SDMA0_RLC0_DUMMY_REG__DUMMY_MASK                                                                      0xFFFFFFFFL
//SDMA0_RLC0_RB_WPTR_POLL_ADDR_HI
#define SDMA0_RLC0_RB_WPTR_POLL_ADDR_HI__ADDR__SHIFT                                                          0x0
#define SDMA0_RLC0_RB_WPTR_POLL_ADDR_HI__ADDR_MASK                                                            0xFFFFFFFFL
//SDMA0_RLC0_RB_WPTR_POLL_ADDR_LO
#define SDMA0_RLC0_RB_WPTR_POLL_ADDR_LO__ADDR__SHIFT                                                          0x2
#define SDMA0_RLC0_RB_WPTR_POLL_ADDR_LO__ADDR_MASK                                                            0xFFFFFFFCL
//SDMA0_RLC0_RB_AQL_CNTL
#define SDMA0_RLC0_RB_AQL_CNTL__AQL_ENABLE__SHIFT                                                             0x0
#define SDMA0_RLC0_RB_AQL_CNTL__AQL_PACKET_SIZE__SHIFT                                                        0x1
#define SDMA0_RLC0_RB_AQL_CNTL__PACKET_STEP__SHIFT                                                            0x8
#define SDMA0_RLC0_RB_AQL_CNTL__MIDCMD_PREEMPT_ENABLE__SHIFT                                                  0x10
#define SDMA0_RLC0_RB_AQL_CNTL__MIDCMD_PREEMPT_DATA_RESTORE__SHIFT                                            0x11
#define SDMA0_RLC0_RB_AQL_CNTL__OVERLAP_ENABLE__SHIFT                                                         0x12
#define SDMA0_RLC0_RB_AQL_CNTL__AQL_ENABLE_MASK                                                               0x00000001L
#define SDMA0_RLC0_RB_AQL_CNTL__AQL_PACKET_SIZE_MASK                                                          0x000000FEL
#define SDMA0_RLC0_RB_AQL_CNTL__PACKET_STEP_MASK                                                              0x0000FF00L
#define SDMA0_RLC0_RB_AQL_CNTL__MIDCMD_PREEMPT_ENABLE_MASK                                                    0x00010000L
#define SDMA0_RLC0_RB_AQL_CNTL__MIDCMD_PREEMPT_DATA_RESTORE_MASK                                              0x00020000L
#define SDMA0_RLC0_RB_AQL_CNTL__OVERLAP_ENABLE_MASK                                                           0x00040000L
//SDMA0_RLC0_MINOR_PTR_UPDATE
#define SDMA0_RLC0_MINOR_PTR_UPDATE__ENABLE__SHIFT                                                            0x0
#define SDMA0_RLC0_MINOR_PTR_UPDATE__ENABLE_MASK                                                              0x00000001L
//SDMA0_RLC0_MIDCMD_DATA0
#define SDMA0_RLC0_MIDCMD_DATA0__DATA0__SHIFT                                                                 0x0
#define SDMA0_RLC0_MIDCMD_DATA0__DATA0_MASK                                                                   0xFFFFFFFFL
//SDMA0_RLC0_MIDCMD_DATA1
#define SDMA0_RLC0_MIDCMD_DATA1__DATA1__SHIFT                                                                 0x0
#define SDMA0_RLC0_MIDCMD_DATA1__DATA1_MASK                                                                   0xFFFFFFFFL
//SDMA0_RLC0_MIDCMD_DATA2
#define SDMA0_RLC0_MIDCMD_DATA2__DATA2__SHIFT                                                                 0x0
#define SDMA0_RLC0_MIDCMD_DATA2__DATA2_MASK                                                                   0xFFFFFFFFL
//SDMA0_RLC0_MIDCMD_DATA3
#define SDMA0_RLC0_MIDCMD_DATA3__DATA3__SHIFT                                                                 0x0
#define SDMA0_RLC0_MIDCMD_DATA3__DATA3_MASK                                                                   0xFFFFFFFFL
//SDMA0_RLC0_MIDCMD_DATA4
#define SDMA0_RLC0_MIDCMD_DATA4__DATA4__SHIFT                                                                 0x0
#define SDMA0_RLC0_MIDCMD_DATA4__DATA4_MASK                                                                   0xFFFFFFFFL
//SDMA0_RLC0_MIDCMD_DATA5
#define SDMA0_RLC0_MIDCMD_DATA5__DATA5__SHIFT                                                                 0x0
#define SDMA0_RLC0_MIDCMD_DATA5__DATA5_MASK                                                                   0xFFFFFFFFL
//SDMA0_RLC0_MIDCMD_DATA6
#define SDMA0_RLC0_MIDCMD_DATA6__DATA6__SHIFT                                                                 0x0
#define SDMA0_RLC0_MIDCMD_DATA6__DATA6_MASK                                                                   0xFFFFFFFFL
//SDMA0_RLC0_MIDCMD_DATA7
#define SDMA0_RLC0_MIDCMD_DATA7__DATA7__SHIFT                                                                 0x0
#define SDMA0_RLC0_MIDCMD_DATA7__DATA7_MASK                                                                   0xFFFFFFFFL
//SDMA0_RLC0_MIDCMD_DATA8
#define SDMA0_RLC0_MIDCMD_DATA8__DATA8__SHIFT                                                                 0x0
#define SDMA0_RLC0_MIDCMD_DATA8__DATA8_MASK                                                                   0xFFFFFFFFL
//SDMA0_RLC0_MIDCMD_DATA9
#define SDMA0_RLC0_MIDCMD_DATA9__DATA9__SHIFT                                                                 0x0
#define SDMA0_RLC0_MIDCMD_DATA9__DATA9_MASK                                                                   0xFFFFFFFFL
//SDMA0_RLC0_MIDCMD_DATA10
#define SDMA0_RLC0_MIDCMD_DATA10__DATA10__SHIFT                                                               0x0
#define SDMA0_RLC0_MIDCMD_DATA10__DATA10_MASK                                                                 0xFFFFFFFFL
//SDMA0_RLC0_MIDCMD_CNTL
#define SDMA0_RLC0_MIDCMD_CNTL__DATA_VALID__SHIFT                                                             0x0
#define SDMA0_RLC0_MIDCMD_CNTL__COPY_MODE__SHIFT                                                              0x1
#define SDMA0_RLC0_MIDCMD_CNTL__SPLIT_STATE__SHIFT                                                            0x4
#define SDMA0_RLC0_MIDCMD_CNTL__ALLOW_PREEMPT__SHIFT                                                          0x8
#define SDMA0_RLC0_MIDCMD_CNTL__DATA_VALID_MASK                                                               0x00000001L
#define SDMA0_RLC0_MIDCMD_CNTL__COPY_MODE_MASK                                                                0x00000002L
#define SDMA0_RLC0_MIDCMD_CNTL__SPLIT_STATE_MASK                                                              0x000000F0L
#define SDMA0_RLC0_MIDCMD_CNTL__ALLOW_PREEMPT_MASK                                                            0x00000100L
//SDMA0_RLC1_RB_CNTL
#define SDMA0_RLC1_RB_CNTL__RB_ENABLE__SHIFT                                                                  0x0
#define SDMA0_RLC1_RB_CNTL__RB_SIZE__SHIFT                                                                    0x1
#define SDMA0_RLC1_RB_CNTL__RB_SWAP_ENABLE__SHIFT                                                             0x9
#define SDMA0_RLC1_RB_CNTL__RPTR_WRITEBACK_ENABLE__SHIFT                                                      0xc
#define SDMA0_RLC1_RB_CNTL__RPTR_WRITEBACK_SWAP_ENABLE__SHIFT                                                 0xd
#define SDMA0_RLC1_RB_CNTL__RPTR_WRITEBACK_TIMER__SHIFT                                                       0x10
#define SDMA0_RLC1_RB_CNTL__RB_PRIV__SHIFT                                                                    0x17
#define SDMA0_RLC1_RB_CNTL__RB_VMID__SHIFT                                                                    0x18
#define SDMA0_RLC1_RB_CNTL__RPTR_WB_IDLE__SHIFT                                                               0x1f
#define SDMA0_RLC1_RB_CNTL__RB_ENABLE_MASK                                                                    0x00000001L
#define SDMA0_RLC1_RB_CNTL__RB_SIZE_MASK                                                                      0x0000003EL
#define SDMA0_RLC1_RB_CNTL__RB_SWAP_ENABLE_MASK                                                               0x00000200L
#define SDMA0_RLC1_RB_CNTL__RPTR_WRITEBACK_ENABLE_MASK                                                        0x00001000L
#define SDMA0_RLC1_RB_CNTL__RPTR_WRITEBACK_SWAP_ENABLE_MASK                                                   0x00002000L
#define SDMA0_RLC1_RB_CNTL__RPTR_WRITEBACK_TIMER_MASK                                                         0x001F0000L
#define SDMA0_RLC1_RB_CNTL__RB_PRIV_MASK                                                                      0x00800000L
#define SDMA0_RLC1_RB_CNTL__RB_VMID_MASK                                                                      0x0F000000L
#define SDMA0_RLC1_RB_CNTL__RPTR_WB_IDLE_MASK                                                                 0x80000000L
//SDMA0_RLC1_RB_BASE
#define SDMA0_RLC1_RB_BASE__ADDR__SHIFT                                                                       0x0
#define SDMA0_RLC1_RB_BASE__ADDR_MASK                                                                         0xFFFFFFFFL
//SDMA0_RLC1_RB_BASE_HI
#define SDMA0_RLC1_RB_BASE_HI__ADDR__SHIFT                                                                    0x0
#define SDMA0_RLC1_RB_BASE_HI__ADDR_MASK                                                                      0x00FFFFFFL
//SDMA0_RLC1_RB_RPTR
#define SDMA0_RLC1_RB_RPTR__OFFSET__SHIFT                                                                     0x0
#define SDMA0_RLC1_RB_RPTR__OFFSET_MASK                                                                       0xFFFFFFFFL
//SDMA0_RLC1_RB_RPTR_HI
#define SDMA0_RLC1_RB_RPTR_HI__OFFSET__SHIFT                                                                  0x0
#define SDMA0_RLC1_RB_RPTR_HI__OFFSET_MASK                                                                    0xFFFFFFFFL
//SDMA0_RLC1_RB_WPTR
#define SDMA0_RLC1_RB_WPTR__OFFSET__SHIFT                                                                     0x0
#define SDMA0_RLC1_RB_WPTR__OFFSET_MASK                                                                       0xFFFFFFFFL
//SDMA0_RLC1_RB_WPTR_HI
#define SDMA0_RLC1_RB_WPTR_HI__OFFSET__SHIFT                                                                  0x0
#define SDMA0_RLC1_RB_WPTR_HI__OFFSET_MASK                                                                    0xFFFFFFFFL
//SDMA0_RLC1_RB_WPTR_POLL_CNTL
#define SDMA0_RLC1_RB_WPTR_POLL_CNTL__ENABLE__SHIFT                                                           0x0
#define SDMA0_RLC1_RB_WPTR_POLL_CNTL__SWAP_ENABLE__SHIFT                                                      0x1
#define SDMA0_RLC1_RB_WPTR_POLL_CNTL__F32_POLL_ENABLE__SHIFT                                                  0x2
#define SDMA0_RLC1_RB_WPTR_POLL_CNTL__FREQUENCY__SHIFT                                                        0x4
#define SDMA0_RLC1_RB_WPTR_POLL_CNTL__IDLE_POLL_COUNT__SHIFT                                                  0x10
#define SDMA0_RLC1_RB_WPTR_POLL_CNTL__ENABLE_MASK                                                             0x00000001L
#define SDMA0_RLC1_RB_WPTR_POLL_CNTL__SWAP_ENABLE_MASK                                                        0x00000002L
#define SDMA0_RLC1_RB_WPTR_POLL_CNTL__F32_POLL_ENABLE_MASK                                                    0x00000004L
#define SDMA0_RLC1_RB_WPTR_POLL_CNTL__FREQUENCY_MASK                                                          0x0000FFF0L
#define SDMA0_RLC1_RB_WPTR_POLL_CNTL__IDLE_POLL_COUNT_MASK                                                    0xFFFF0000L
//SDMA0_RLC1_RB_RPTR_ADDR_HI
#define SDMA0_RLC1_RB_RPTR_ADDR_HI__ADDR__SHIFT                                                               0x0
#define SDMA0_RLC1_RB_RPTR_ADDR_HI__ADDR_MASK                                                                 0xFFFFFFFFL
//SDMA0_RLC1_RB_RPTR_ADDR_LO
#define SDMA0_RLC1_RB_RPTR_ADDR_LO__ADDR__SHIFT                                                               0x2
#define SDMA0_RLC1_RB_RPTR_ADDR_LO__ADDR_MASK                                                                 0xFFFFFFFCL
//SDMA0_RLC1_IB_CNTL
#define SDMA0_RLC1_IB_CNTL__IB_ENABLE__SHIFT                                                                  0x0
#define SDMA0_RLC1_IB_CNTL__IB_SWAP_ENABLE__SHIFT                                                             0x4
#define SDMA0_RLC1_IB_CNTL__SWITCH_INSIDE_IB__SHIFT                                                           0x8
#define SDMA0_RLC1_IB_CNTL__CMD_VMID__SHIFT                                                                   0x10
#define SDMA0_RLC1_IB_CNTL__IB_ENABLE_MASK                                                                    0x00000001L
#define SDMA0_RLC1_IB_CNTL__IB_SWAP_ENABLE_MASK                                                               0x00000010L
#define SDMA0_RLC1_IB_CNTL__SWITCH_INSIDE_IB_MASK                                                             0x00000100L
#define SDMA0_RLC1_IB_CNTL__CMD_VMID_MASK                                                                     0x000F0000L
//SDMA0_RLC1_IB_RPTR
#define SDMA0_RLC1_IB_RPTR__OFFSET__SHIFT                                                                     0x2
#define SDMA0_RLC1_IB_RPTR__OFFSET_MASK                                                                       0x003FFFFCL
//SDMA0_RLC1_IB_OFFSET
#define SDMA0_RLC1_IB_OFFSET__OFFSET__SHIFT                                                                   0x2
#define SDMA0_RLC1_IB_OFFSET__OFFSET_MASK                                                                     0x003FFFFCL
//SDMA0_RLC1_IB_BASE_LO
#define SDMA0_RLC1_IB_BASE_LO__ADDR__SHIFT                                                                    0x5
#define SDMA0_RLC1_IB_BASE_LO__ADDR_MASK                                                                      0xFFFFFFE0L
//SDMA0_RLC1_IB_BASE_HI
#define SDMA0_RLC1_IB_BASE_HI__ADDR__SHIFT                                                                    0x0
#define SDMA0_RLC1_IB_BASE_HI__ADDR_MASK                                                                      0xFFFFFFFFL
//SDMA0_RLC1_IB_SIZE
#define SDMA0_RLC1_IB_SIZE__SIZE__SHIFT                                                                       0x0
#define SDMA0_RLC1_IB_SIZE__SIZE_MASK                                                                         0x000FFFFFL
//SDMA0_RLC1_SKIP_CNTL
#define SDMA0_RLC1_SKIP_CNTL__SKIP_COUNT__SHIFT                                                               0x0
#define SDMA0_RLC1_SKIP_CNTL__SKIP_COUNT_MASK                                                                 0x000FFFFFL
//SDMA0_RLC1_CONTEXT_STATUS
#define SDMA0_RLC1_CONTEXT_STATUS__SELECTED__SHIFT                                                            0x0
#define SDMA0_RLC1_CONTEXT_STATUS__IDLE__SHIFT                                                                0x2
#define SDMA0_RLC1_CONTEXT_STATUS__EXPIRED__SHIFT                                                             0x3
#define SDMA0_RLC1_CONTEXT_STATUS__EXCEPTION__SHIFT                                                           0x4
#define SDMA0_RLC1_CONTEXT_STATUS__CTXSW_ABLE__SHIFT                                                          0x7
#define SDMA0_RLC1_CONTEXT_STATUS__CTXSW_READY__SHIFT                                                         0x8
#define SDMA0_RLC1_CONTEXT_STATUS__PREEMPTED__SHIFT                                                           0x9
#define SDMA0_RLC1_CONTEXT_STATUS__PREEMPT_DISABLE__SHIFT                                                     0xa
#define SDMA0_RLC1_CONTEXT_STATUS__SELECTED_MASK                                                              0x00000001L
#define SDMA0_RLC1_CONTEXT_STATUS__IDLE_MASK                                                                  0x00000004L
#define SDMA0_RLC1_CONTEXT_STATUS__EXPIRED_MASK                                                               0x00000008L
#define SDMA0_RLC1_CONTEXT_STATUS__EXCEPTION_MASK                                                             0x00000070L
#define SDMA0_RLC1_CONTEXT_STATUS__CTXSW_ABLE_MASK                                                            0x00000080L
#define SDMA0_RLC1_CONTEXT_STATUS__CTXSW_READY_MASK                                                           0x00000100L
#define SDMA0_RLC1_CONTEXT_STATUS__PREEMPTED_MASK                                                             0x00000200L
#define SDMA0_RLC1_CONTEXT_STATUS__PREEMPT_DISABLE_MASK                                                       0x00000400L
//SDMA0_RLC1_DOORBELL
#define SDMA0_RLC1_DOORBELL__ENABLE__SHIFT                                                                    0x1c
#define SDMA0_RLC1_DOORBELL__CAPTURED__SHIFT                                                                  0x1e
#define SDMA0_RLC1_DOORBELL__ENABLE_MASK                                                                      0x10000000L
#define SDMA0_RLC1_DOORBELL__CAPTURED_MASK                                                                    0x40000000L
//SDMA0_RLC1_STATUS
#define SDMA0_RLC1_STATUS__WPTR_UPDATE_FAIL_COUNT__SHIFT                                                      0x0
#define SDMA0_RLC1_STATUS__WPTR_UPDATE_PENDING__SHIFT                                                         0x8
#define SDMA0_RLC1_STATUS__WPTR_UPDATE_FAIL_COUNT_MASK                                                        0x000000FFL
#define SDMA0_RLC1_STATUS__WPTR_UPDATE_PENDING_MASK                                                           0x00000100L
//SDMA0_RLC1_DOORBELL_LOG
#define SDMA0_RLC1_DOORBELL_LOG__BE_ERROR__SHIFT                                                              0x0
#define SDMA0_RLC1_DOORBELL_LOG__DATA__SHIFT                                                                  0x2
#define SDMA0_RLC1_DOORBELL_LOG__BE_ERROR_MASK                                                                0x00000001L
#define SDMA0_RLC1_DOORBELL_LOG__DATA_MASK                                                                    0xFFFFFFFCL
//SDMA0_RLC1_WATERMARK
#define SDMA0_RLC1_WATERMARK__RD_OUTSTANDING__SHIFT                                                           0x0
#define SDMA0_RLC1_WATERMARK__WR_OUTSTANDING__SHIFT                                                           0x10
#define SDMA0_RLC1_WATERMARK__RD_OUTSTANDING_MASK                                                             0x00000FFFL
#define SDMA0_RLC1_WATERMARK__WR_OUTSTANDING_MASK                                                             0x03FF0000L
//SDMA0_RLC1_DOORBELL_OFFSET
#define SDMA0_RLC1_DOORBELL_OFFSET__OFFSET__SHIFT                                                             0x2
#define SDMA0_RLC1_DOORBELL_OFFSET__OFFSET_MASK                                                               0x0FFFFFFCL
//SDMA0_RLC1_CSA_ADDR_LO
#define SDMA0_RLC1_CSA_ADDR_LO__ADDR__SHIFT                                                                   0x2
#define SDMA0_RLC1_CSA_ADDR_LO__ADDR_MASK                                                                     0xFFFFFFFCL
//SDMA0_RLC1_CSA_ADDR_HI
#define SDMA0_RLC1_CSA_ADDR_HI__ADDR__SHIFT                                                                   0x0
#define SDMA0_RLC1_CSA_ADDR_HI__ADDR_MASK                                                                     0xFFFFFFFFL
//SDMA0_RLC1_IB_SUB_REMAIN
#define SDMA0_RLC1_IB_SUB_REMAIN__SIZE__SHIFT                                                                 0x0
#define SDMA0_RLC1_IB_SUB_REMAIN__SIZE_MASK                                                                   0x00003FFFL
//SDMA0_RLC1_PREEMPT
#define SDMA0_RLC1_PREEMPT__IB_PREEMPT__SHIFT                                                                 0x0
#define SDMA0_RLC1_PREEMPT__IB_PREEMPT_MASK                                                                   0x00000001L
//SDMA0_RLC1_DUMMY_REG
#define SDMA0_RLC1_DUMMY_REG__DUMMY__SHIFT                                                                    0x0
#define SDMA0_RLC1_DUMMY_REG__DUMMY_MASK                                                                      0xFFFFFFFFL
//SDMA0_RLC1_RB_WPTR_POLL_ADDR_HI
#define SDMA0_RLC1_RB_WPTR_POLL_ADDR_HI__ADDR__SHIFT                                                          0x0
#define SDMA0_RLC1_RB_WPTR_POLL_ADDR_HI__ADDR_MASK                                                            0xFFFFFFFFL
//SDMA0_RLC1_RB_WPTR_POLL_ADDR_LO
#define SDMA0_RLC1_RB_WPTR_POLL_ADDR_LO__ADDR__SHIFT                                                          0x2
#define SDMA0_RLC1_RB_WPTR_POLL_ADDR_LO__ADDR_MASK                                                            0xFFFFFFFCL
//SDMA0_RLC1_RB_AQL_CNTL
#define SDMA0_RLC1_RB_AQL_CNTL__AQL_ENABLE__SHIFT                                                             0x0
#define SDMA0_RLC1_RB_AQL_CNTL__AQL_PACKET_SIZE__SHIFT                                                        0x1
#define SDMA0_RLC1_RB_AQL_CNTL__PACKET_STEP__SHIFT                                                            0x8
#define SDMA0_RLC1_RB_AQL_CNTL__MIDCMD_PREEMPT_ENABLE__SHIFT                                                  0x10
#define SDMA0_RLC1_RB_AQL_CNTL__MIDCMD_PREEMPT_DATA_RESTORE__SHIFT                                            0x11
#define SDMA0_RLC1_RB_AQL_CNTL__OVERLAP_ENABLE__SHIFT                                                         0x12
#define SDMA0_RLC1_RB_AQL_CNTL__AQL_ENABLE_MASK                                                               0x00000001L
#define SDMA0_RLC1_RB_AQL_CNTL__AQL_PACKET_SIZE_MASK                                                          0x000000FEL
#define SDMA0_RLC1_RB_AQL_CNTL__PACKET_STEP_MASK                                                              0x0000FF00L
#define SDMA0_RLC1_RB_AQL_CNTL__MIDCMD_PREEMPT_ENABLE_MASK                                                    0x00010000L
#define SDMA0_RLC1_RB_AQL_CNTL__MIDCMD_PREEMPT_DATA_RESTORE_MASK                                              0x00020000L
#define SDMA0_RLC1_RB_AQL_CNTL__OVERLAP_ENABLE_MASK                                                           0x00040000L
//SDMA0_RLC1_MINOR_PTR_UPDATE
#define SDMA0_RLC1_MINOR_PTR_UPDATE__ENABLE__SHIFT                                                            0x0
#define SDMA0_RLC1_MINOR_PTR_UPDATE__ENABLE_MASK                                                              0x00000001L
//SDMA0_RLC1_MIDCMD_DATA0
#define SDMA0_RLC1_MIDCMD_DATA0__DATA0__SHIFT                                                                 0x0
#define SDMA0_RLC1_MIDCMD_DATA0__DATA0_MASK                                                                   0xFFFFFFFFL
//SDMA0_RLC1_MIDCMD_DATA1
#define SDMA0_RLC1_MIDCMD_DATA1__DATA1__SHIFT                                                                 0x0
#define SDMA0_RLC1_MIDCMD_DATA1__DATA1_MASK                                                                   0xFFFFFFFFL
//SDMA0_RLC1_MIDCMD_DATA2
#define SDMA0_RLC1_MIDCMD_DATA2__DATA2__SHIFT                                                                 0x0
#define SDMA0_RLC1_MIDCMD_DATA2__DATA2_MASK                                                                   0xFFFFFFFFL
//SDMA0_RLC1_MIDCMD_DATA3
#define SDMA0_RLC1_MIDCMD_DATA3__DATA3__SHIFT                                                                 0x0
#define SDMA0_RLC1_MIDCMD_DATA3__DATA3_MASK                                                                   0xFFFFFFFFL
//SDMA0_RLC1_MIDCMD_DATA4
#define SDMA0_RLC1_MIDCMD_DATA4__DATA4__SHIFT                                                                 0x0
#define SDMA0_RLC1_MIDCMD_DATA4__DATA4_MASK                                                                   0xFFFFFFFFL
//SDMA0_RLC1_MIDCMD_DATA5
#define SDMA0_RLC1_MIDCMD_DATA5__DATA5__SHIFT                                                                 0x0
#define SDMA0_RLC1_MIDCMD_DATA5__DATA5_MASK                                                                   0xFFFFFFFFL
//SDMA0_RLC1_MIDCMD_DATA6
#define SDMA0_RLC1_MIDCMD_DATA6__DATA6__SHIFT                                                                 0x0
#define SDMA0_RLC1_MIDCMD_DATA6__DATA6_MASK                                                                   0xFFFFFFFFL
//SDMA0_RLC1_MIDCMD_DATA7
#define SDMA0_RLC1_MIDCMD_DATA7__DATA7__SHIFT                                                                 0x0
#define SDMA0_RLC1_MIDCMD_DATA7__DATA7_MASK                                                                   0xFFFFFFFFL
//SDMA0_RLC1_MIDCMD_DATA8
#define SDMA0_RLC1_MIDCMD_DATA8__DATA8__SHIFT                                                                 0x0
#define SDMA0_RLC1_MIDCMD_DATA8__DATA8_MASK                                                                   0xFFFFFFFFL
//SDMA0_RLC1_MIDCMD_DATA9
#define SDMA0_RLC1_MIDCMD_DATA9__DATA9__SHIFT                                                                 0x0
#define SDMA0_RLC1_MIDCMD_DATA9__DATA9_MASK                                                                   0xFFFFFFFFL
//SDMA0_RLC1_MIDCMD_DATA10
#define SDMA0_RLC1_MIDCMD_DATA10__DATA10__SHIFT                                                               0x0
#define SDMA0_RLC1_MIDCMD_DATA10__DATA10_MASK                                                                 0xFFFFFFFFL
//SDMA0_RLC1_MIDCMD_CNTL
#define SDMA0_RLC1_MIDCMD_CNTL__DATA_VALID__SHIFT                                                             0x0
#define SDMA0_RLC1_MIDCMD_CNTL__COPY_MODE__SHIFT                                                              0x1
#define SDMA0_RLC1_MIDCMD_CNTL__SPLIT_STATE__SHIFT                                                            0x4
#define SDMA0_RLC1_MIDCMD_CNTL__ALLOW_PREEMPT__SHIFT                                                          0x8
#define SDMA0_RLC1_MIDCMD_CNTL__DATA_VALID_MASK                                                               0x00000001L
#define SDMA0_RLC1_MIDCMD_CNTL__COPY_MODE_MASK                                                                0x00000002L
#define SDMA0_RLC1_MIDCMD_CNTL__SPLIT_STATE_MASK                                                              0x000000F0L
#define SDMA0_RLC1_MIDCMD_CNTL__ALLOW_PREEMPT_MASK                                                            0x00000100L
//SDMA0_RLC2_RB_CNTL
#define SDMA0_RLC2_RB_CNTL__RB_ENABLE__SHIFT                                                                  0x0
#define SDMA0_RLC2_RB_CNTL__RB_SIZE__SHIFT                                                                    0x1
#define SDMA0_RLC2_RB_CNTL__RB_SWAP_ENABLE__SHIFT                                                             0x9
#define SDMA0_RLC2_RB_CNTL__RPTR_WRITEBACK_ENABLE__SHIFT                                                      0xc
#define SDMA0_RLC2_RB_CNTL__RPTR_WRITEBACK_SWAP_ENABLE__SHIFT                                                 0xd
#define SDMA0_RLC2_RB_CNTL__RPTR_WRITEBACK_TIMER__SHIFT                                                       0x10
#define SDMA0_RLC2_RB_CNTL__RB_PRIV__SHIFT                                                                    0x17
#define SDMA0_RLC2_RB_CNTL__RB_VMID__SHIFT                                                                    0x18
#define SDMA0_RLC2_RB_CNTL__RPTR_WB_IDLE__SHIFT                                                               0x1f
#define SDMA0_RLC2_RB_CNTL__RB_ENABLE_MASK                                                                    0x00000001L
#define SDMA0_RLC2_RB_CNTL__RB_SIZE_MASK                                                                      0x0000003EL
#define SDMA0_RLC2_RB_CNTL__RB_SWAP_ENABLE_MASK                                                               0x00000200L
#define SDMA0_RLC2_RB_CNTL__RPTR_WRITEBACK_ENABLE_MASK                                                        0x00001000L
#define SDMA0_RLC2_RB_CNTL__RPTR_WRITEBACK_SWAP_ENABLE_MASK                                                   0x00002000L
#define SDMA0_RLC2_RB_CNTL__RPTR_WRITEBACK_TIMER_MASK                                                         0x001F0000L
#define SDMA0_RLC2_RB_CNTL__RB_PRIV_MASK                                                                      0x00800000L
#define SDMA0_RLC2_RB_CNTL__RB_VMID_MASK                                                                      0x0F000000L
#define SDMA0_RLC2_RB_CNTL__RPTR_WB_IDLE_MASK                                                                 0x80000000L
//SDMA0_RLC2_RB_BASE
#define SDMA0_RLC2_RB_BASE__ADDR__SHIFT                                                                       0x0
#define SDMA0_RLC2_RB_BASE__ADDR_MASK                                                                         0xFFFFFFFFL
//SDMA0_RLC2_RB_BASE_HI
#define SDMA0_RLC2_RB_BASE_HI__ADDR__SHIFT                                                                    0x0
#define SDMA0_RLC2_RB_BASE_HI__ADDR_MASK                                                                      0x00FFFFFFL
//SDMA0_RLC2_RB_RPTR
#define SDMA0_RLC2_RB_RPTR__OFFSET__SHIFT                                                                     0x0
#define SDMA0_RLC2_RB_RPTR__OFFSET_MASK                                                                       0xFFFFFFFFL
//SDMA0_RLC2_RB_RPTR_HI
#define SDMA0_RLC2_RB_RPTR_HI__OFFSET__SHIFT                                                                  0x0
#define SDMA0_RLC2_RB_RPTR_HI__OFFSET_MASK                                                                    0xFFFFFFFFL
//SDMA0_RLC2_RB_WPTR
#define SDMA0_RLC2_RB_WPTR__OFFSET__SHIFT                                                                     0x0
#define SDMA0_RLC2_RB_WPTR__OFFSET_MASK                                                                       0xFFFFFFFFL
//SDMA0_RLC2_RB_WPTR_HI
#define SDMA0_RLC2_RB_WPTR_HI__OFFSET__SHIFT                                                                  0x0
#define SDMA0_RLC2_RB_WPTR_HI__OFFSET_MASK                                                                    0xFFFFFFFFL
//SDMA0_RLC2_RB_WPTR_POLL_CNTL
#define SDMA0_RLC2_RB_WPTR_POLL_CNTL__ENABLE__SHIFT                                                           0x0
#define SDMA0_RLC2_RB_WPTR_POLL_CNTL__SWAP_ENABLE__SHIFT                                                      0x1
#define SDMA0_RLC2_RB_WPTR_POLL_CNTL__F32_POLL_ENABLE__SHIFT                                                  0x2
#define SDMA0_RLC2_RB_WPTR_POLL_CNTL__FREQUENCY__SHIFT                                                        0x4
#define SDMA0_RLC2_RB_WPTR_POLL_CNTL__IDLE_POLL_COUNT__SHIFT                                                  0x10
#define SDMA0_RLC2_RB_WPTR_POLL_CNTL__ENABLE_MASK                                                             0x00000001L
#define SDMA0_RLC2_RB_WPTR_POLL_CNTL__SWAP_ENABLE_MASK                                                        0x00000002L
#define SDMA0_RLC2_RB_WPTR_POLL_CNTL__F32_POLL_ENABLE_MASK                                                    0x00000004L
#define SDMA0_RLC2_RB_WPTR_POLL_CNTL__FREQUENCY_MASK                                                          0x0000FFF0L
#define SDMA0_RLC2_RB_WPTR_POLL_CNTL__IDLE_POLL_COUNT_MASK                                                    0xFFFF0000L
//SDMA0_RLC2_RB_RPTR_ADDR_HI
#define SDMA0_RLC2_RB_RPTR_ADDR_HI__ADDR__SHIFT                                                               0x0
#define SDMA0_RLC2_RB_RPTR_ADDR_HI__ADDR_MASK                                                                 0xFFFFFFFFL
//SDMA0_RLC2_RB_RPTR_ADDR_LO
#define SDMA0_RLC2_RB_RPTR_ADDR_LO__ADDR__SHIFT                                                               0x2
#define SDMA0_RLC2_RB_RPTR_ADDR_LO__ADDR_MASK                                                                 0xFFFFFFFCL
//SDMA0_RLC2_IB_CNTL
#define SDMA0_RLC2_IB_CNTL__IB_ENABLE__SHIFT                                                                  0x0
#define SDMA0_RLC2_IB_CNTL__IB_SWAP_ENABLE__SHIFT                                                             0x4
#define SDMA0_RLC2_IB_CNTL__SWITCH_INSIDE_IB__SHIFT                                                           0x8
#define SDMA0_RLC2_IB_CNTL__CMD_VMID__SHIFT                                                                   0x10
#define SDMA0_RLC2_IB_CNTL__IB_ENABLE_MASK                                                                    0x00000001L
#define SDMA0_RLC2_IB_CNTL__IB_SWAP_ENABLE_MASK                                                               0x00000010L
#define SDMA0_RLC2_IB_CNTL__SWITCH_INSIDE_IB_MASK                                                             0x00000100L
#define SDMA0_RLC2_IB_CNTL__CMD_VMID_MASK                                                                     0x000F0000L
//SDMA0_RLC2_IB_RPTR
#define SDMA0_RLC2_IB_RPTR__OFFSET__SHIFT                                                                     0x2
#define SDMA0_RLC2_IB_RPTR__OFFSET_MASK                                                                       0x003FFFFCL
//SDMA0_RLC2_IB_OFFSET
#define SDMA0_RLC2_IB_OFFSET__OFFSET__SHIFT                                                                   0x2
#define SDMA0_RLC2_IB_OFFSET__OFFSET_MASK                                                                     0x003FFFFCL
//SDMA0_RLC2_IB_BASE_LO
#define SDMA0_RLC2_IB_BASE_LO__ADDR__SHIFT                                                                    0x5
#define SDMA0_RLC2_IB_BASE_LO__ADDR_MASK                                                                      0xFFFFFFE0L
//SDMA0_RLC2_IB_BASE_HI
#define SDMA0_RLC2_IB_BASE_HI__ADDR__SHIFT                                                                    0x0
#define SDMA0_RLC2_IB_BASE_HI__ADDR_MASK                                                                      0xFFFFFFFFL
//SDMA0_RLC2_IB_SIZE
#define SDMA0_RLC2_IB_SIZE__SIZE__SHIFT                                                                       0x0
#define SDMA0_RLC2_IB_SIZE__SIZE_MASK                                                                         0x000FFFFFL
//SDMA0_RLC2_SKIP_CNTL
#define SDMA0_RLC2_SKIP_CNTL__SKIP_COUNT__SHIFT                                                               0x0
#define SDMA0_RLC2_SKIP_CNTL__SKIP_COUNT_MASK                                                                 0x000FFFFFL
//SDMA0_RLC2_CONTEXT_STATUS
#define SDMA0_RLC2_CONTEXT_STATUS__SELECTED__SHIFT                                                            0x0
#define SDMA0_RLC2_CONTEXT_STATUS__IDLE__SHIFT                                                                0x2
#define SDMA0_RLC2_CONTEXT_STATUS__EXPIRED__SHIFT                                                             0x3
#define SDMA0_RLC2_CONTEXT_STATUS__EXCEPTION__SHIFT                                                           0x4
#define SDMA0_RLC2_CONTEXT_STATUS__CTXSW_ABLE__SHIFT                                                          0x7
#define SDMA0_RLC2_CONTEXT_STATUS__CTXSW_READY__SHIFT                                                         0x8
#define SDMA0_RLC2_CONTEXT_STATUS__PREEMPTED__SHIFT                                                           0x9
#define SDMA0_RLC2_CONTEXT_STATUS__PREEMPT_DISABLE__SHIFT                                                     0xa
#define SDMA0_RLC2_CONTEXT_STATUS__SELECTED_MASK                                                              0x00000001L
#define SDMA0_RLC2_CONTEXT_STATUS__IDLE_MASK                                                                  0x00000004L
#define SDMA0_RLC2_CONTEXT_STATUS__EXPIRED_MASK                                                               0x00000008L
#define SDMA0_RLC2_CONTEXT_STATUS__EXCEPTION_MASK                                                             0x00000070L
#define SDMA0_RLC2_CONTEXT_STATUS__CTXSW_ABLE_MASK                                                            0x00000080L
#define SDMA0_RLC2_CONTEXT_STATUS__CTXSW_READY_MASK                                                           0x00000100L
#define SDMA0_RLC2_CONTEXT_STATUS__PREEMPTED_MASK                                                             0x00000200L
#define SDMA0_RLC2_CONTEXT_STATUS__PREEMPT_DISABLE_MASK                                                       0x00000400L
//SDMA0_RLC2_DOORBELL
#define SDMA0_RLC2_DOORBELL__ENABLE__SHIFT                                                                    0x1c
#define SDMA0_RLC2_DOORBELL__CAPTURED__SHIFT                                                                  0x1e
#define SDMA0_RLC2_DOORBELL__ENABLE_MASK                                                                      0x10000000L
#define SDMA0_RLC2_DOORBELL__CAPTURED_MASK                                                                    0x40000000L
//SDMA0_RLC2_STATUS
#define SDMA0_RLC2_STATUS__WPTR_UPDATE_FAIL_COUNT__SHIFT                                                      0x0
#define SDMA0_RLC2_STATUS__WPTR_UPDATE_PENDING__SHIFT                                                         0x8
#define SDMA0_RLC2_STATUS__WPTR_UPDATE_FAIL_COUNT_MASK                                                        0x000000FFL
#define SDMA0_RLC2_STATUS__WPTR_UPDATE_PENDING_MASK                                                           0x00000100L
//SDMA0_RLC2_DOORBELL_LOG
#define SDMA0_RLC2_DOORBELL_LOG__BE_ERROR__SHIFT                                                              0x0
#define SDMA0_RLC2_DOORBELL_LOG__DATA__SHIFT                                                                  0x2
#define SDMA0_RLC2_DOORBELL_LOG__BE_ERROR_MASK                                                                0x00000001L
#define SDMA0_RLC2_DOORBELL_LOG__DATA_MASK                                                                    0xFFFFFFFCL
//SDMA0_RLC2_WATERMARK
#define SDMA0_RLC2_WATERMARK__RD_OUTSTANDING__SHIFT                                                           0x0
#define SDMA0_RLC2_WATERMARK__WR_OUTSTANDING__SHIFT                                                           0x10
#define SDMA0_RLC2_WATERMARK__RD_OUTSTANDING_MASK                                                             0x00000FFFL
#define SDMA0_RLC2_WATERMARK__WR_OUTSTANDING_MASK                                                             0x03FF0000L
//SDMA0_RLC2_DOORBELL_OFFSET
#define SDMA0_RLC2_DOORBELL_OFFSET__OFFSET__SHIFT                                                             0x2
#define SDMA0_RLC2_DOORBELL_OFFSET__OFFSET_MASK                                                               0x0FFFFFFCL
//SDMA0_RLC2_CSA_ADDR_LO
#define SDMA0_RLC2_CSA_ADDR_LO__ADDR__SHIFT                                                                   0x2
#define SDMA0_RLC2_CSA_ADDR_LO__ADDR_MASK                                                                     0xFFFFFFFCL
//SDMA0_RLC2_CSA_ADDR_HI
#define SDMA0_RLC2_CSA_ADDR_HI__ADDR__SHIFT                                                                   0x0
#define SDMA0_RLC2_CSA_ADDR_HI__ADDR_MASK                                                                     0xFFFFFFFFL
//SDMA0_RLC2_IB_SUB_REMAIN
#define SDMA0_RLC2_IB_SUB_REMAIN__SIZE__SHIFT                                                                 0x0
#define SDMA0_RLC2_IB_SUB_REMAIN__SIZE_MASK                                                                   0x00003FFFL
//SDMA0_RLC2_PREEMPT
#define SDMA0_RLC2_PREEMPT__IB_PREEMPT__SHIFT                                                                 0x0
#define SDMA0_RLC2_PREEMPT__IB_PREEMPT_MASK                                                                   0x00000001L
//SDMA0_RLC2_DUMMY_REG
#define SDMA0_RLC2_DUMMY_REG__DUMMY__SHIFT                                                                    0x0
#define SDMA0_RLC2_DUMMY_REG__DUMMY_MASK                                                                      0xFFFFFFFFL
//SDMA0_RLC2_RB_WPTR_POLL_ADDR_HI
#define SDMA0_RLC2_RB_WPTR_POLL_ADDR_HI__ADDR__SHIFT                                                          0x0
#define SDMA0_RLC2_RB_WPTR_POLL_ADDR_HI__ADDR_MASK                                                            0xFFFFFFFFL
//SDMA0_RLC2_RB_WPTR_POLL_ADDR_LO
#define SDMA0_RLC2_RB_WPTR_POLL_ADDR_LO__ADDR__SHIFT                                                          0x2
#define SDMA0_RLC2_RB_WPTR_POLL_ADDR_LO__ADDR_MASK                                                            0xFFFFFFFCL
//SDMA0_RLC2_RB_AQL_CNTL
#define SDMA0_RLC2_RB_AQL_CNTL__AQL_ENABLE__SHIFT                                                             0x0
#define SDMA0_RLC2_RB_AQL_CNTL__AQL_PACKET_SIZE__SHIFT                                                        0x1
#define SDMA0_RLC2_RB_AQL_CNTL__PACKET_STEP__SHIFT                                                            0x8
#define SDMA0_RLC2_RB_AQL_CNTL__MIDCMD_PREEMPT_ENABLE__SHIFT                                                  0x10
#define SDMA0_RLC2_RB_AQL_CNTL__MIDCMD_PREEMPT_DATA_RESTORE__SHIFT                                            0x11
#define SDMA0_RLC2_RB_AQL_CNTL__OVERLAP_ENABLE__SHIFT                                                         0x12
#define SDMA0_RLC2_RB_AQL_CNTL__AQL_ENABLE_MASK                                                               0x00000001L
#define SDMA0_RLC2_RB_AQL_CNTL__AQL_PACKET_SIZE_MASK                                                          0x000000FEL
#define SDMA0_RLC2_RB_AQL_CNTL__PACKET_STEP_MASK                                                              0x0000FF00L
#define SDMA0_RLC2_RB_AQL_CNTL__MIDCMD_PREEMPT_ENABLE_MASK                                                    0x00010000L
#define SDMA0_RLC2_RB_AQL_CNTL__MIDCMD_PREEMPT_DATA_RESTORE_MASK                                              0x00020000L
#define SDMA0_RLC2_RB_AQL_CNTL__OVERLAP_ENABLE_MASK                                                           0x00040000L
//SDMA0_RLC2_MINOR_PTR_UPDATE
#define SDMA0_RLC2_MINOR_PTR_UPDATE__ENABLE__SHIFT                                                            0x0
#define SDMA0_RLC2_MINOR_PTR_UPDATE__ENABLE_MASK                                                              0x00000001L
//SDMA0_RLC2_MIDCMD_DATA0
#define SDMA0_RLC2_MIDCMD_DATA0__DATA0__SHIFT                                                                 0x0
#define SDMA0_RLC2_MIDCMD_DATA0__DATA0_MASK                                                                   0xFFFFFFFFL
//SDMA0_RLC2_MIDCMD_DATA1
#define SDMA0_RLC2_MIDCMD_DATA1__DATA1__SHIFT                                                                 0x0
#define SDMA0_RLC2_MIDCMD_DATA1__DATA1_MASK                                                                   0xFFFFFFFFL
//SDMA0_RLC2_MIDCMD_DATA2
#define SDMA0_RLC2_MIDCMD_DATA2__DATA2__SHIFT                                                                 0x0
#define SDMA0_RLC2_MIDCMD_DATA2__DATA2_MASK                                                                   0xFFFFFFFFL
//SDMA0_RLC2_MIDCMD_DATA3
#define SDMA0_RLC2_MIDCMD_DATA3__DATA3__SHIFT                                                                 0x0
#define SDMA0_RLC2_MIDCMD_DATA3__DATA3_MASK                                                                   0xFFFFFFFFL
//SDMA0_RLC2_MIDCMD_DATA4
#define SDMA0_RLC2_MIDCMD_DATA4__DATA4__SHIFT                                                                 0x0
#define SDMA0_RLC2_MIDCMD_DATA4__DATA4_MASK                                                                   0xFFFFFFFFL
//SDMA0_RLC2_MIDCMD_DATA5
#define SDMA0_RLC2_MIDCMD_DATA5__DATA5__SHIFT                                                                 0x0
#define SDMA0_RLC2_MIDCMD_DATA5__DATA5_MASK                                                                   0xFFFFFFFFL
//SDMA0_RLC2_MIDCMD_DATA6
#define SDMA0_RLC2_MIDCMD_DATA6__DATA6__SHIFT                                                                 0x0
#define SDMA0_RLC2_MIDCMD_DATA6__DATA6_MASK                                                                   0xFFFFFFFFL
//SDMA0_RLC2_MIDCMD_DATA7
#define SDMA0_RLC2_MIDCMD_DATA7__DATA7__SHIFT                                                                 0x0
#define SDMA0_RLC2_MIDCMD_DATA7__DATA7_MASK                                                                   0xFFFFFFFFL
//SDMA0_RLC2_MIDCMD_DATA8
#define SDMA0_RLC2_MIDCMD_DATA8__DATA8__SHIFT                                                                 0x0
#define SDMA0_RLC2_MIDCMD_DATA8__DATA8_MASK                                                                   0xFFFFFFFFL
//SDMA0_RLC2_MIDCMD_DATA9
#define SDMA0_RLC2_MIDCMD_DATA9__DATA9__SHIFT                                                                 0x0
#define SDMA0_RLC2_MIDCMD_DATA9__DATA9_MASK                                                                   0xFFFFFFFFL
//SDMA0_RLC2_MIDCMD_DATA10
#define SDMA0_RLC2_MIDCMD_DATA10__DATA10__SHIFT                                                               0x0
#define SDMA0_RLC2_MIDCMD_DATA10__DATA10_MASK                                                                 0xFFFFFFFFL
//SDMA0_RLC2_MIDCMD_CNTL
#define SDMA0_RLC2_MIDCMD_CNTL__DATA_VALID__SHIFT                                                             0x0
#define SDMA0_RLC2_MIDCMD_CNTL__COPY_MODE__SHIFT                                                              0x1
#define SDMA0_RLC2_MIDCMD_CNTL__SPLIT_STATE__SHIFT                                                            0x4
#define SDMA0_RLC2_MIDCMD_CNTL__ALLOW_PREEMPT__SHIFT                                                          0x8
#define SDMA0_RLC2_MIDCMD_CNTL__DATA_VALID_MASK                                                               0x00000001L
#define SDMA0_RLC2_MIDCMD_CNTL__COPY_MODE_MASK                                                                0x00000002L
#define SDMA0_RLC2_MIDCMD_CNTL__SPLIT_STATE_MASK                                                              0x000000F0L
#define SDMA0_RLC2_MIDCMD_CNTL__ALLOW_PREEMPT_MASK                                                            0x00000100L
//SDMA0_RLC3_RB_CNTL
#define SDMA0_RLC3_RB_CNTL__RB_ENABLE__SHIFT                                                                  0x0
#define SDMA0_RLC3_RB_CNTL__RB_SIZE__SHIFT                                                                    0x1
#define SDMA0_RLC3_RB_CNTL__RB_SWAP_ENABLE__SHIFT                                                             0x9
#define SDMA0_RLC3_RB_CNTL__RPTR_WRITEBACK_ENABLE__SHIFT                                                      0xc
#define SDMA0_RLC3_RB_CNTL__RPTR_WRITEBACK_SWAP_ENABLE__SHIFT                                                 0xd
#define SDMA0_RLC3_RB_CNTL__RPTR_WRITEBACK_TIMER__SHIFT                                                       0x10
#define SDMA0_RLC3_RB_CNTL__RB_PRIV__SHIFT                                                                    0x17
#define SDMA0_RLC3_RB_CNTL__RB_VMID__SHIFT                                                                    0x18
#define SDMA0_RLC3_RB_CNTL__RPTR_WB_IDLE__SHIFT                                                               0x1f
#define SDMA0_RLC3_RB_CNTL__RB_ENABLE_MASK                                                                    0x00000001L
#define SDMA0_RLC3_RB_CNTL__RB_SIZE_MASK                                                                      0x0000003EL
#define SDMA0_RLC3_RB_CNTL__RB_SWAP_ENABLE_MASK                                                               0x00000200L
#define SDMA0_RLC3_RB_CNTL__RPTR_WRITEBACK_ENABLE_MASK                                                        0x00001000L
#define SDMA0_RLC3_RB_CNTL__RPTR_WRITEBACK_SWAP_ENABLE_MASK                                                   0x00002000L
#define SDMA0_RLC3_RB_CNTL__RPTR_WRITEBACK_TIMER_MASK                                                         0x001F0000L
#define SDMA0_RLC3_RB_CNTL__RB_PRIV_MASK                                                                      0x00800000L
#define SDMA0_RLC3_RB_CNTL__RB_VMID_MASK                                                                      0x0F000000L
#define SDMA0_RLC3_RB_CNTL__RPTR_WB_IDLE_MASK                                                                 0x80000000L
//SDMA0_RLC3_RB_BASE
#define SDMA0_RLC3_RB_BASE__ADDR__SHIFT                                                                       0x0
#define SDMA0_RLC3_RB_BASE__ADDR_MASK                                                                         0xFFFFFFFFL
//SDMA0_RLC3_RB_BASE_HI
#define SDMA0_RLC3_RB_BASE_HI__ADDR__SHIFT                                                                    0x0
#define SDMA0_RLC3_RB_BASE_HI__ADDR_MASK                                                                      0x00FFFFFFL
//SDMA0_RLC3_RB_RPTR
#define SDMA0_RLC3_RB_RPTR__OFFSET__SHIFT                                                                     0x0
#define SDMA0_RLC3_RB_RPTR__OFFSET_MASK                                                                       0xFFFFFFFFL
//SDMA0_RLC3_RB_RPTR_HI
#define SDMA0_RLC3_RB_RPTR_HI__OFFSET__SHIFT                                                                  0x0
#define SDMA0_RLC3_RB_RPTR_HI__OFFSET_MASK                                                                    0xFFFFFFFFL
//SDMA0_RLC3_RB_WPTR
#define SDMA0_RLC3_RB_WPTR__OFFSET__SHIFT                                                                     0x0
#define SDMA0_RLC3_RB_WPTR__OFFSET_MASK                                                                       0xFFFFFFFFL
//SDMA0_RLC3_RB_WPTR_HI
#define SDMA0_RLC3_RB_WPTR_HI__OFFSET__SHIFT                                                                  0x0
#define SDMA0_RLC3_RB_WPTR_HI__OFFSET_MASK                                                                    0xFFFFFFFFL
//SDMA0_RLC3_RB_WPTR_POLL_CNTL
#define SDMA0_RLC3_RB_WPTR_POLL_CNTL__ENABLE__SHIFT                                                           0x0
#define SDMA0_RLC3_RB_WPTR_POLL_CNTL__SWAP_ENABLE__SHIFT                                                      0x1
#define SDMA0_RLC3_RB_WPTR_POLL_CNTL__F32_POLL_ENABLE__SHIFT                                                  0x2
#define SDMA0_RLC3_RB_WPTR_POLL_CNTL__FREQUENCY__SHIFT                                                        0x4
#define SDMA0_RLC3_RB_WPTR_POLL_CNTL__IDLE_POLL_COUNT__SHIFT                                                  0x10
#define SDMA0_RLC3_RB_WPTR_POLL_CNTL__ENABLE_MASK                                                             0x00000001L
#define SDMA0_RLC3_RB_WPTR_POLL_CNTL__SWAP_ENABLE_MASK                                                        0x00000002L
#define SDMA0_RLC3_RB_WPTR_POLL_CNTL__F32_POLL_ENABLE_MASK                                                    0x00000004L
#define SDMA0_RLC3_RB_WPTR_POLL_CNTL__FREQUENCY_MASK                                                          0x0000FFF0L
#define SDMA0_RLC3_RB_WPTR_POLL_CNTL__IDLE_POLL_COUNT_MASK                                                    0xFFFF0000L
//SDMA0_RLC3_RB_RPTR_ADDR_HI
#define SDMA0_RLC3_RB_RPTR_ADDR_HI__ADDR__SHIFT                                                               0x0
#define SDMA0_RLC3_RB_RPTR_ADDR_HI__ADDR_MASK                                                                 0xFFFFFFFFL
//SDMA0_RLC3_RB_RPTR_ADDR_LO
#define SDMA0_RLC3_RB_RPTR_ADDR_LO__ADDR__SHIFT                                                               0x2
#define SDMA0_RLC3_RB_RPTR_ADDR_LO__ADDR_MASK                                                                 0xFFFFFFFCL
//SDMA0_RLC3_IB_CNTL
#define SDMA0_RLC3_IB_CNTL__IB_ENABLE__SHIFT                                                                  0x0
#define SDMA0_RLC3_IB_CNTL__IB_SWAP_ENABLE__SHIFT                                                             0x4
#define SDMA0_RLC3_IB_CNTL__SWITCH_INSIDE_IB__SHIFT                                                           0x8
#define SDMA0_RLC3_IB_CNTL__CMD_VMID__SHIFT                                                                   0x10
#define SDMA0_RLC3_IB_CNTL__IB_ENABLE_MASK                                                                    0x00000001L
#define SDMA0_RLC3_IB_CNTL__IB_SWAP_ENABLE_MASK                                                               0x00000010L
#define SDMA0_RLC3_IB_CNTL__SWITCH_INSIDE_IB_MASK                                                             0x00000100L
#define SDMA0_RLC3_IB_CNTL__CMD_VMID_MASK                                                                     0x000F0000L
//SDMA0_RLC3_IB_RPTR
#define SDMA0_RLC3_IB_RPTR__OFFSET__SHIFT                                                                     0x2
#define SDMA0_RLC3_IB_RPTR__OFFSET_MASK                                                                       0x003FFFFCL
//SDMA0_RLC3_IB_OFFSET
#define SDMA0_RLC3_IB_OFFSET__OFFSET__SHIFT                                                                   0x2
#define SDMA0_RLC3_IB_OFFSET__OFFSET_MASK                                                                     0x003FFFFCL
//SDMA0_RLC3_IB_BASE_LO
#define SDMA0_RLC3_IB_BASE_LO__ADDR__SHIFT                                                                    0x5
#define SDMA0_RLC3_IB_BASE_LO__ADDR_MASK                                                                      0xFFFFFFE0L
//SDMA0_RLC3_IB_BASE_HI
#define SDMA0_RLC3_IB_BASE_HI__ADDR__SHIFT                                                                    0x0
#define SDMA0_RLC3_IB_BASE_HI__ADDR_MASK                                                                      0xFFFFFFFFL
//SDMA0_RLC3_IB_SIZE
#define SDMA0_RLC3_IB_SIZE__SIZE__SHIFT                                                                       0x0
#define SDMA0_RLC3_IB_SIZE__SIZE_MASK                                                                         0x000FFFFFL
//SDMA0_RLC3_SKIP_CNTL
#define SDMA0_RLC3_SKIP_CNTL__SKIP_COUNT__SHIFT                                                               0x0
#define SDMA0_RLC3_SKIP_CNTL__SKIP_COUNT_MASK                                                                 0x000FFFFFL
//SDMA0_RLC3_CONTEXT_STATUS
#define SDMA0_RLC3_CONTEXT_STATUS__SELECTED__SHIFT                                                            0x0
#define SDMA0_RLC3_CONTEXT_STATUS__IDLE__SHIFT                                                                0x2
#define SDMA0_RLC3_CONTEXT_STATUS__EXPIRED__SHIFT                                                             0x3
#define SDMA0_RLC3_CONTEXT_STATUS__EXCEPTION__SHIFT                                                           0x4
#define SDMA0_RLC3_CONTEXT_STATUS__CTXSW_ABLE__SHIFT                                                          0x7
#define SDMA0_RLC3_CONTEXT_STATUS__CTXSW_READY__SHIFT                                                         0x8
#define SDMA0_RLC3_CONTEXT_STATUS__PREEMPTED__SHIFT                                                           0x9
#define SDMA0_RLC3_CONTEXT_STATUS__PREEMPT_DISABLE__SHIFT                                                     0xa
#define SDMA0_RLC3_CONTEXT_STATUS__SELECTED_MASK                                                              0x00000001L
#define SDMA0_RLC3_CONTEXT_STATUS__IDLE_MASK                                                                  0x00000004L
#define SDMA0_RLC3_CONTEXT_STATUS__EXPIRED_MASK                                                               0x00000008L
#define SDMA0_RLC3_CONTEXT_STATUS__EXCEPTION_MASK                                                             0x00000070L
#define SDMA0_RLC3_CONTEXT_STATUS__CTXSW_ABLE_MASK                                                            0x00000080L
#define SDMA0_RLC3_CONTEXT_STATUS__CTXSW_READY_MASK                                                           0x00000100L
#define SDMA0_RLC3_CONTEXT_STATUS__PREEMPTED_MASK                                                             0x00000200L
#define SDMA0_RLC3_CONTEXT_STATUS__PREEMPT_DISABLE_MASK                                                       0x00000400L
//SDMA0_RLC3_DOORBELL
#define SDMA0_RLC3_DOORBELL__ENABLE__SHIFT                                                                    0x1c
#define SDMA0_RLC3_DOORBELL__CAPTURED__SHIFT                                                                  0x1e
#define SDMA0_RLC3_DOORBELL__ENABLE_MASK                                                                      0x10000000L
#define SDMA0_RLC3_DOORBELL__CAPTURED_MASK                                                                    0x40000000L
//SDMA0_RLC3_STATUS
#define SDMA0_RLC3_STATUS__WPTR_UPDATE_FAIL_COUNT__SHIFT                                                      0x0
#define SDMA0_RLC3_STATUS__WPTR_UPDATE_PENDING__SHIFT                                                         0x8
#define SDMA0_RLC3_STATUS__WPTR_UPDATE_FAIL_COUNT_MASK                                                        0x000000FFL
#define SDMA0_RLC3_STATUS__WPTR_UPDATE_PENDING_MASK                                                           0x00000100L
//SDMA0_RLC3_DOORBELL_LOG
#define SDMA0_RLC3_DOORBELL_LOG__BE_ERROR__SHIFT                                                              0x0
#define SDMA0_RLC3_DOORBELL_LOG__DATA__SHIFT                                                                  0x2
#define SDMA0_RLC3_DOORBELL_LOG__BE_ERROR_MASK                                                                0x00000001L
#define SDMA0_RLC3_DOORBELL_LOG__DATA_MASK                                                                    0xFFFFFFFCL
//SDMA0_RLC3_WATERMARK
#define SDMA0_RLC3_WATERMARK__RD_OUTSTANDING__SHIFT                                                           0x0
#define SDMA0_RLC3_WATERMARK__WR_OUTSTANDING__SHIFT                                                           0x10
#define SDMA0_RLC3_WATERMARK__RD_OUTSTANDING_MASK                                                             0x00000FFFL
#define SDMA0_RLC3_WATERMARK__WR_OUTSTANDING_MASK                                                             0x03FF0000L
//SDMA0_RLC3_DOORBELL_OFFSET
#define SDMA0_RLC3_DOORBELL_OFFSET__OFFSET__SHIFT                                                             0x2
#define SDMA0_RLC3_DOORBELL_OFFSET__OFFSET_MASK                                                               0x0FFFFFFCL
//SDMA0_RLC3_CSA_ADDR_LO
#define SDMA0_RLC3_CSA_ADDR_LO__ADDR__SHIFT                                                                   0x2
#define SDMA0_RLC3_CSA_ADDR_LO__ADDR_MASK                                                                     0xFFFFFFFCL
//SDMA0_RLC3_CSA_ADDR_HI
#define SDMA0_RLC3_CSA_ADDR_HI__ADDR__SHIFT                                                                   0x0
#define SDMA0_RLC3_CSA_ADDR_HI__ADDR_MASK                                                                     0xFFFFFFFFL
//SDMA0_RLC3_IB_SUB_REMAIN
#define SDMA0_RLC3_IB_SUB_REMAIN__SIZE__SHIFT                                                                 0x0
#define SDMA0_RLC3_IB_SUB_REMAIN__SIZE_MASK                                                                   0x00003FFFL
//SDMA0_RLC3_PREEMPT
#define SDMA0_RLC3_PREEMPT__IB_PREEMPT__SHIFT                                                                 0x0
#define SDMA0_RLC3_PREEMPT__IB_PREEMPT_MASK                                                                   0x00000001L
//SDMA0_RLC3_DUMMY_REG
#define SDMA0_RLC3_DUMMY_REG__DUMMY__SHIFT                                                                    0x0
#define SDMA0_RLC3_DUMMY_REG__DUMMY_MASK                                                                      0xFFFFFFFFL
//SDMA0_RLC3_RB_WPTR_POLL_ADDR_HI
#define SDMA0_RLC3_RB_WPTR_POLL_ADDR_HI__ADDR__SHIFT                                                          0x0
#define SDMA0_RLC3_RB_WPTR_POLL_ADDR_HI__ADDR_MASK                                                            0xFFFFFFFFL
//SDMA0_RLC3_RB_WPTR_POLL_ADDR_LO
#define SDMA0_RLC3_RB_WPTR_POLL_ADDR_LO__ADDR__SHIFT                                                          0x2
#define SDMA0_RLC3_RB_WPTR_POLL_ADDR_LO__ADDR_MASK                                                            0xFFFFFFFCL
//SDMA0_RLC3_RB_AQL_CNTL
#define SDMA0_RLC3_RB_AQL_CNTL__AQL_ENABLE__SHIFT                                                             0x0
#define SDMA0_RLC3_RB_AQL_CNTL__AQL_PACKET_SIZE__SHIFT                                                        0x1
#define SDMA0_RLC3_RB_AQL_CNTL__PACKET_STEP__SHIFT                                                            0x8
#define SDMA0_RLC3_RB_AQL_CNTL__MIDCMD_PREEMPT_ENABLE__SHIFT                                                  0x10
#define SDMA0_RLC3_RB_AQL_CNTL__MIDCMD_PREEMPT_DATA_RESTORE__SHIFT                                            0x11
#define SDMA0_RLC3_RB_AQL_CNTL__OVERLAP_ENABLE__SHIFT                                                         0x12
#define SDMA0_RLC3_RB_AQL_CNTL__AQL_ENABLE_MASK                                                               0x00000001L
#define SDMA0_RLC3_RB_AQL_CNTL__AQL_PACKET_SIZE_MASK                                                          0x000000FEL
#define SDMA0_RLC3_RB_AQL_CNTL__PACKET_STEP_MASK                                                              0x0000FF00L
#define SDMA0_RLC3_RB_AQL_CNTL__MIDCMD_PREEMPT_ENABLE_MASK                                                    0x00010000L
#define SDMA0_RLC3_RB_AQL_CNTL__MIDCMD_PREEMPT_DATA_RESTORE_MASK                                              0x00020000L
#define SDMA0_RLC3_RB_AQL_CNTL__OVERLAP_ENABLE_MASK                                                           0x00040000L
//SDMA0_RLC3_MINOR_PTR_UPDATE
#define SDMA0_RLC3_MINOR_PTR_UPDATE__ENABLE__SHIFT                                                            0x0
#define SDMA0_RLC3_MINOR_PTR_UPDATE__ENABLE_MASK                                                              0x00000001L
//SDMA0_RLC3_MIDCMD_DATA0
#define SDMA0_RLC3_MIDCMD_DATA0__DATA0__SHIFT                                                                 0x0
#define SDMA0_RLC3_MIDCMD_DATA0__DATA0_MASK                                                                   0xFFFFFFFFL
//SDMA0_RLC3_MIDCMD_DATA1
#define SDMA0_RLC3_MIDCMD_DATA1__DATA1__SHIFT                                                                 0x0
#define SDMA0_RLC3_MIDCMD_DATA1__DATA1_MASK                                                                   0xFFFFFFFFL
//SDMA0_RLC3_MIDCMD_DATA2
#define SDMA0_RLC3_MIDCMD_DATA2__DATA2__SHIFT                                                                 0x0
#define SDMA0_RLC3_MIDCMD_DATA2__DATA2_MASK                                                                   0xFFFFFFFFL
//SDMA0_RLC3_MIDCMD_DATA3
#define SDMA0_RLC3_MIDCMD_DATA3__DATA3__SHIFT                                                                 0x0
#define SDMA0_RLC3_MIDCMD_DATA3__DATA3_MASK                                                                   0xFFFFFFFFL
//SDMA0_RLC3_MIDCMD_DATA4
#define SDMA0_RLC3_MIDCMD_DATA4__DATA4__SHIFT                                                                 0x0
#define SDMA0_RLC3_MIDCMD_DATA4__DATA4_MASK                                                                   0xFFFFFFFFL
//SDMA0_RLC3_MIDCMD_DATA5
#define SDMA0_RLC3_MIDCMD_DATA5__DATA5__SHIFT                                                                 0x0
#define SDMA0_RLC3_MIDCMD_DATA5__DATA5_MASK                                                                   0xFFFFFFFFL
//SDMA0_RLC3_MIDCMD_DATA6
#define SDMA0_RLC3_MIDCMD_DATA6__DATA6__SHIFT                                                                 0x0
#define SDMA0_RLC3_MIDCMD_DATA6__DATA6_MASK                                                                   0xFFFFFFFFL
//SDMA0_RLC3_MIDCMD_DATA7
#define SDMA0_RLC3_MIDCMD_DATA7__DATA7__SHIFT                                                                 0x0
#define SDMA0_RLC3_MIDCMD_DATA7__DATA7_MASK                                                                   0xFFFFFFFFL
//SDMA0_RLC3_MIDCMD_DATA8
#define SDMA0_RLC3_MIDCMD_DATA8__DATA8__SHIFT                                                                 0x0
#define SDMA0_RLC3_MIDCMD_DATA8__DATA8_MASK                                                                   0xFFFFFFFFL
//SDMA0_RLC3_MIDCMD_DATA9
#define SDMA0_RLC3_MIDCMD_DATA9__DATA9__SHIFT                                                                 0x0
#define SDMA0_RLC3_MIDCMD_DATA9__DATA9_MASK                                                                   0xFFFFFFFFL
//SDMA0_RLC3_MIDCMD_DATA10
#define SDMA0_RLC3_MIDCMD_DATA10__DATA10__SHIFT                                                               0x0
#define SDMA0_RLC3_MIDCMD_DATA10__DATA10_MASK                                                                 0xFFFFFFFFL
//SDMA0_RLC3_MIDCMD_CNTL
#define SDMA0_RLC3_MIDCMD_CNTL__DATA_VALID__SHIFT                                                             0x0
#define SDMA0_RLC3_MIDCMD_CNTL__COPY_MODE__SHIFT                                                              0x1
#define SDMA0_RLC3_MIDCMD_CNTL__SPLIT_STATE__SHIFT                                                            0x4
#define SDMA0_RLC3_MIDCMD_CNTL__ALLOW_PREEMPT__SHIFT                                                          0x8
#define SDMA0_RLC3_MIDCMD_CNTL__DATA_VALID_MASK                                                               0x00000001L
#define SDMA0_RLC3_MIDCMD_CNTL__COPY_MODE_MASK                                                                0x00000002L
#define SDMA0_RLC3_MIDCMD_CNTL__SPLIT_STATE_MASK                                                              0x000000F0L
#define SDMA0_RLC3_MIDCMD_CNTL__ALLOW_PREEMPT_MASK                                                            0x00000100L
//SDMA0_RLC4_RB_CNTL
#define SDMA0_RLC4_RB_CNTL__RB_ENABLE__SHIFT                                                                  0x0
#define SDMA0_RLC4_RB_CNTL__RB_SIZE__SHIFT                                                                    0x1
#define SDMA0_RLC4_RB_CNTL__RB_SWAP_ENABLE__SHIFT                                                             0x9
#define SDMA0_RLC4_RB_CNTL__RPTR_WRITEBACK_ENABLE__SHIFT                                                      0xc
#define SDMA0_RLC4_RB_CNTL__RPTR_WRITEBACK_SWAP_ENABLE__SHIFT                                                 0xd
#define SDMA0_RLC4_RB_CNTL__RPTR_WRITEBACK_TIMER__SHIFT                                                       0x10
#define SDMA0_RLC4_RB_CNTL__RB_PRIV__SHIFT                                                                    0x17
#define SDMA0_RLC4_RB_CNTL__RB_VMID__SHIFT                                                                    0x18
#define SDMA0_RLC4_RB_CNTL__RPTR_WB_IDLE__SHIFT                                                               0x1f
#define SDMA0_RLC4_RB_CNTL__RB_ENABLE_MASK                                                                    0x00000001L
#define SDMA0_RLC4_RB_CNTL__RB_SIZE_MASK                                                                      0x0000003EL
#define SDMA0_RLC4_RB_CNTL__RB_SWAP_ENABLE_MASK                                                               0x00000200L
#define SDMA0_RLC4_RB_CNTL__RPTR_WRITEBACK_ENABLE_MASK                                                        0x00001000L
#define SDMA0_RLC4_RB_CNTL__RPTR_WRITEBACK_SWAP_ENABLE_MASK                                                   0x00002000L
#define SDMA0_RLC4_RB_CNTL__RPTR_WRITEBACK_TIMER_MASK                                                         0x001F0000L
#define SDMA0_RLC4_RB_CNTL__RB_PRIV_MASK                                                                      0x00800000L
#define SDMA0_RLC4_RB_CNTL__RB_VMID_MASK                                                                      0x0F000000L
#define SDMA0_RLC4_RB_CNTL__RPTR_WB_IDLE_MASK                                                                 0x80000000L
//SDMA0_RLC4_RB_BASE
#define SDMA0_RLC4_RB_BASE__ADDR__SHIFT                                                                       0x0
#define SDMA0_RLC4_RB_BASE__ADDR_MASK                                                                         0xFFFFFFFFL
//SDMA0_RLC4_RB_BASE_HI
#define SDMA0_RLC4_RB_BASE_HI__ADDR__SHIFT                                                                    0x0
#define SDMA0_RLC4_RB_BASE_HI__ADDR_MASK                                                                      0x00FFFFFFL
//SDMA0_RLC4_RB_RPTR
#define SDMA0_RLC4_RB_RPTR__OFFSET__SHIFT                                                                     0x0
#define SDMA0_RLC4_RB_RPTR__OFFSET_MASK                                                                       0xFFFFFFFFL
//SDMA0_RLC4_RB_RPTR_HI
#define SDMA0_RLC4_RB_RPTR_HI__OFFSET__SHIFT                                                                  0x0
#define SDMA0_RLC4_RB_RPTR_HI__OFFSET_MASK                                                                    0xFFFFFFFFL
//SDMA0_RLC4_RB_WPTR
#define SDMA0_RLC4_RB_WPTR__OFFSET__SHIFT                                                                     0x0
#define SDMA0_RLC4_RB_WPTR__OFFSET_MASK                                                                       0xFFFFFFFFL
//SDMA0_RLC4_RB_WPTR_HI
#define SDMA0_RLC4_RB_WPTR_HI__OFFSET__SHIFT                                                                  0x0
#define SDMA0_RLC4_RB_WPTR_HI__OFFSET_MASK                                                                    0xFFFFFFFFL
//SDMA0_RLC4_RB_WPTR_POLL_CNTL
#define SDMA0_RLC4_RB_WPTR_POLL_CNTL__ENABLE__SHIFT                                                           0x0
#define SDMA0_RLC4_RB_WPTR_POLL_CNTL__SWAP_ENABLE__SHIFT                                                      0x1
#define SDMA0_RLC4_RB_WPTR_POLL_CNTL__F32_POLL_ENABLE__SHIFT                                                  0x2
#define SDMA0_RLC4_RB_WPTR_POLL_CNTL__FREQUENCY__SHIFT                                                        0x4
#define SDMA0_RLC4_RB_WPTR_POLL_CNTL__IDLE_POLL_COUNT__SHIFT                                                  0x10
#define SDMA0_RLC4_RB_WPTR_POLL_CNTL__ENABLE_MASK                                                             0x00000001L
#define SDMA0_RLC4_RB_WPTR_POLL_CNTL__SWAP_ENABLE_MASK                                                        0x00000002L
#define SDMA0_RLC4_RB_WPTR_POLL_CNTL__F32_POLL_ENABLE_MASK                                                    0x00000004L
#define SDMA0_RLC4_RB_WPTR_POLL_CNTL__FREQUENCY_MASK                                                          0x0000FFF0L
#define SDMA0_RLC4_RB_WPTR_POLL_CNTL__IDLE_POLL_COUNT_MASK                                                    0xFFFF0000L
//SDMA0_RLC4_RB_RPTR_ADDR_HI
#define SDMA0_RLC4_RB_RPTR_ADDR_HI__ADDR__SHIFT                                                               0x0
#define SDMA0_RLC4_RB_RPTR_ADDR_HI__ADDR_MASK                                                                 0xFFFFFFFFL
//SDMA0_RLC4_RB_RPTR_ADDR_LO
#define SDMA0_RLC4_RB_RPTR_ADDR_LO__ADDR__SHIFT                                                               0x2
#define SDMA0_RLC4_RB_RPTR_ADDR_LO__ADDR_MASK                                                                 0xFFFFFFFCL
//SDMA0_RLC4_IB_CNTL
#define SDMA0_RLC4_IB_CNTL__IB_ENABLE__SHIFT                                                                  0x0
#define SDMA0_RLC4_IB_CNTL__IB_SWAP_ENABLE__SHIFT                                                             0x4
#define SDMA0_RLC4_IB_CNTL__SWITCH_INSIDE_IB__SHIFT                                                           0x8
#define SDMA0_RLC4_IB_CNTL__CMD_VMID__SHIFT                                                                   0x10
#define SDMA0_RLC4_IB_CNTL__IB_ENABLE_MASK                                                                    0x00000001L
#define SDMA0_RLC4_IB_CNTL__IB_SWAP_ENABLE_MASK                                                               0x00000010L
#define SDMA0_RLC4_IB_CNTL__SWITCH_INSIDE_IB_MASK                                                             0x00000100L
#define SDMA0_RLC4_IB_CNTL__CMD_VMID_MASK                                                                     0x000F0000L
//SDMA0_RLC4_IB_RPTR
#define SDMA0_RLC4_IB_RPTR__OFFSET__SHIFT                                                                     0x2
#define SDMA0_RLC4_IB_RPTR__OFFSET_MASK                                                                       0x003FFFFCL
//SDMA0_RLC4_IB_OFFSET
#define SDMA0_RLC4_IB_OFFSET__OFFSET__SHIFT                                                                   0x2
#define SDMA0_RLC4_IB_OFFSET__OFFSET_MASK                                                                     0x003FFFFCL
//SDMA0_RLC4_IB_BASE_LO
#define SDMA0_RLC4_IB_BASE_LO__ADDR__SHIFT                                                                    0x5
#define SDMA0_RLC4_IB_BASE_LO__ADDR_MASK                                                                      0xFFFFFFE0L
//SDMA0_RLC4_IB_BASE_HI
#define SDMA0_RLC4_IB_BASE_HI__ADDR__SHIFT                                                                    0x0
#define SDMA0_RLC4_IB_BASE_HI__ADDR_MASK                                                                      0xFFFFFFFFL
//SDMA0_RLC4_IB_SIZE
#define SDMA0_RLC4_IB_SIZE__SIZE__SHIFT                                                                       0x0
#define SDMA0_RLC4_IB_SIZE__SIZE_MASK                                                                         0x000FFFFFL
//SDMA0_RLC4_SKIP_CNTL
#define SDMA0_RLC4_SKIP_CNTL__SKIP_COUNT__SHIFT                                                               0x0
#define SDMA0_RLC4_SKIP_CNTL__SKIP_COUNT_MASK                                                                 0x000FFFFFL
//SDMA0_RLC4_CONTEXT_STATUS
#define SDMA0_RLC4_CONTEXT_STATUS__SELECTED__SHIFT                                                            0x0
#define SDMA0_RLC4_CONTEXT_STATUS__IDLE__SHIFT                                                                0x2
#define SDMA0_RLC4_CONTEXT_STATUS__EXPIRED__SHIFT                                                             0x3
#define SDMA0_RLC4_CONTEXT_STATUS__EXCEPTION__SHIFT                                                           0x4
#define SDMA0_RLC4_CONTEXT_STATUS__CTXSW_ABLE__SHIFT                                                          0x7
#define SDMA0_RLC4_CONTEXT_STATUS__CTXSW_READY__SHIFT                                                         0x8
#define SDMA0_RLC4_CONTEXT_STATUS__PREEMPTED__SHIFT                                                           0x9
#define SDMA0_RLC4_CONTEXT_STATUS__PREEMPT_DISABLE__SHIFT                                                     0xa
#define SDMA0_RLC4_CONTEXT_STATUS__SELECTED_MASK                                                              0x00000001L
#define SDMA0_RLC4_CONTEXT_STATUS__IDLE_MASK                                                                  0x00000004L
#define SDMA0_RLC4_CONTEXT_STATUS__EXPIRED_MASK                                                               0x00000008L
#define SDMA0_RLC4_CONTEXT_STATUS__EXCEPTION_MASK                                                             0x00000070L
#define SDMA0_RLC4_CONTEXT_STATUS__CTXSW_ABLE_MASK                                                            0x00000080L
#define SDMA0_RLC4_CONTEXT_STATUS__CTXSW_READY_MASK                                                           0x00000100L
#define SDMA0_RLC4_CONTEXT_STATUS__PREEMPTED_MASK                                                             0x00000200L
#define SDMA0_RLC4_CONTEXT_STATUS__PREEMPT_DISABLE_MASK                                                       0x00000400L
//SDMA0_RLC4_DOORBELL
#define SDMA0_RLC4_DOORBELL__ENABLE__SHIFT                                                                    0x1c
#define SDMA0_RLC4_DOORBELL__CAPTURED__SHIFT                                                                  0x1e
#define SDMA0_RLC4_DOORBELL__ENABLE_MASK                                                                      0x10000000L
#define SDMA0_RLC4_DOORBELL__CAPTURED_MASK                                                                    0x40000000L
//SDMA0_RLC4_STATUS
#define SDMA0_RLC4_STATUS__WPTR_UPDATE_FAIL_COUNT__SHIFT                                                      0x0
#define SDMA0_RLC4_STATUS__WPTR_UPDATE_PENDING__SHIFT                                                         0x8
#define SDMA0_RLC4_STATUS__WPTR_UPDATE_FAIL_COUNT_MASK                                                        0x000000FFL
#define SDMA0_RLC4_STATUS__WPTR_UPDATE_PENDING_MASK                                                           0x00000100L
//SDMA0_RLC4_DOORBELL_LOG
#define SDMA0_RLC4_DOORBELL_LOG__BE_ERROR__SHIFT                                                              0x0
#define SDMA0_RLC4_DOORBELL_LOG__DATA__SHIFT                                                                  0x2
#define SDMA0_RLC4_DOORBELL_LOG__BE_ERROR_MASK                                                                0x00000001L
#define SDMA0_RLC4_DOORBELL_LOG__DATA_MASK                                                                    0xFFFFFFFCL
//SDMA0_RLC4_WATERMARK
#define SDMA0_RLC4_WATERMARK__RD_OUTSTANDING__SHIFT                                                           0x0
#define SDMA0_RLC4_WATERMARK__WR_OUTSTANDING__SHIFT                                                           0x10
#define SDMA0_RLC4_WATERMARK__RD_OUTSTANDING_MASK                                                             0x00000FFFL
#define SDMA0_RLC4_WATERMARK__WR_OUTSTANDING_MASK                                                             0x03FF0000L
//SDMA0_RLC4_DOORBELL_OFFSET
#define SDMA0_RLC4_DOORBELL_OFFSET__OFFSET__SHIFT                                                             0x2
#define SDMA0_RLC4_DOORBELL_OFFSET__OFFSET_MASK                                                               0x0FFFFFFCL
//SDMA0_RLC4_CSA_ADDR_LO
#define SDMA0_RLC4_CSA_ADDR_LO__ADDR__SHIFT                                                                   0x2
#define SDMA0_RLC4_CSA_ADDR_LO__ADDR_MASK                                                                     0xFFFFFFFCL
//SDMA0_RLC4_CSA_ADDR_HI
#define SDMA0_RLC4_CSA_ADDR_HI__ADDR__SHIFT                                                                   0x0
#define SDMA0_RLC4_CSA_ADDR_HI__ADDR_MASK                                                                     0xFFFFFFFFL
//SDMA0_RLC4_IB_SUB_REMAIN
#define SDMA0_RLC4_IB_SUB_REMAIN__SIZE__SHIFT                                                                 0x0
#define SDMA0_RLC4_IB_SUB_REMAIN__SIZE_MASK                                                                   0x00003FFFL
//SDMA0_RLC4_PREEMPT
#define SDMA0_RLC4_PREEMPT__IB_PREEMPT__SHIFT                                                                 0x0
#define SDMA0_RLC4_PREEMPT__IB_PREEMPT_MASK                                                                   0x00000001L
//SDMA0_RLC4_DUMMY_REG
#define SDMA0_RLC4_DUMMY_REG__DUMMY__SHIFT                                                                    0x0
#define SDMA0_RLC4_DUMMY_REG__DUMMY_MASK                                                                      0xFFFFFFFFL
//SDMA0_RLC4_RB_WPTR_POLL_ADDR_HI
#define SDMA0_RLC4_RB_WPTR_POLL_ADDR_HI__ADDR__SHIFT                                                          0x0
#define SDMA0_RLC4_RB_WPTR_POLL_ADDR_HI__ADDR_MASK                                                            0xFFFFFFFFL
//SDMA0_RLC4_RB_WPTR_POLL_ADDR_LO
#define SDMA0_RLC4_RB_WPTR_POLL_ADDR_LO__ADDR__SHIFT                                                          0x2
#define SDMA0_RLC4_RB_WPTR_POLL_ADDR_LO__ADDR_MASK                                                            0xFFFFFFFCL
//SDMA0_RLC4_RB_AQL_CNTL
#define SDMA0_RLC4_RB_AQL_CNTL__AQL_ENABLE__SHIFT                                                             0x0
#define SDMA0_RLC4_RB_AQL_CNTL__AQL_PACKET_SIZE__SHIFT                                                        0x1
#define SDMA0_RLC4_RB_AQL_CNTL__PACKET_STEP__SHIFT                                                            0x8
#define SDMA0_RLC4_RB_AQL_CNTL__MIDCMD_PREEMPT_ENABLE__SHIFT                                                  0x10
#define SDMA0_RLC4_RB_AQL_CNTL__MIDCMD_PREEMPT_DATA_RESTORE__SHIFT                                            0x11
#define SDMA0_RLC4_RB_AQL_CNTL__OVERLAP_ENABLE__SHIFT                                                         0x12
#define SDMA0_RLC4_RB_AQL_CNTL__AQL_ENABLE_MASK                                                               0x00000001L
#define SDMA0_RLC4_RB_AQL_CNTL__AQL_PACKET_SIZE_MASK                                                          0x000000FEL
#define SDMA0_RLC4_RB_AQL_CNTL__PACKET_STEP_MASK                                                              0x0000FF00L
#define SDMA0_RLC4_RB_AQL_CNTL__MIDCMD_PREEMPT_ENABLE_MASK                                                    0x00010000L
#define SDMA0_RLC4_RB_AQL_CNTL__MIDCMD_PREEMPT_DATA_RESTORE_MASK                                              0x00020000L
#define SDMA0_RLC4_RB_AQL_CNTL__OVERLAP_ENABLE_MASK                                                           0x00040000L
//SDMA0_RLC4_MINOR_PTR_UPDATE
#define SDMA0_RLC4_MINOR_PTR_UPDATE__ENABLE__SHIFT                                                            0x0
#define SDMA0_RLC4_MINOR_PTR_UPDATE__ENABLE_MASK                                                              0x00000001L
//SDMA0_RLC4_MIDCMD_DATA0
#define SDMA0_RLC4_MIDCMD_DATA0__DATA0__SHIFT                                                                 0x0
#define SDMA0_RLC4_MIDCMD_DATA0__DATA0_MASK                                                                   0xFFFFFFFFL
//SDMA0_RLC4_MIDCMD_DATA1
#define SDMA0_RLC4_MIDCMD_DATA1__DATA1__SHIFT                                                                 0x0
#define SDMA0_RLC4_MIDCMD_DATA1__DATA1_MASK                                                                   0xFFFFFFFFL
//SDMA0_RLC4_MIDCMD_DATA2
#define SDMA0_RLC4_MIDCMD_DATA2__DATA2__SHIFT                                                                 0x0
#define SDMA0_RLC4_MIDCMD_DATA2__DATA2_MASK                                                                   0xFFFFFFFFL
//SDMA0_RLC4_MIDCMD_DATA3
#define SDMA0_RLC4_MIDCMD_DATA3__DATA3__SHIFT                                                                 0x0
#define SDMA0_RLC4_MIDCMD_DATA3__DATA3_MASK                                                                   0xFFFFFFFFL
//SDMA0_RLC4_MIDCMD_DATA4
#define SDMA0_RLC4_MIDCMD_DATA4__DATA4__SHIFT                                                                 0x0
#define SDMA0_RLC4_MIDCMD_DATA4__DATA4_MASK                                                                   0xFFFFFFFFL
//SDMA0_RLC4_MIDCMD_DATA5
#define SDMA0_RLC4_MIDCMD_DATA5__DATA5__SHIFT                                                                 0x0
#define SDMA0_RLC4_MIDCMD_DATA5__DATA5_MASK                                                                   0xFFFFFFFFL
//SDMA0_RLC4_MIDCMD_DATA6
#define SDMA0_RLC4_MIDCMD_DATA6__DATA6__SHIFT                                                                 0x0
#define SDMA0_RLC4_MIDCMD_DATA6__DATA6_MASK                                                                   0xFFFFFFFFL
//SDMA0_RLC4_MIDCMD_DATA7
#define SDMA0_RLC4_MIDCMD_DATA7__DATA7__SHIFT                                                                 0x0
#define SDMA0_RLC4_MIDCMD_DATA7__DATA7_MASK                                                                   0xFFFFFFFFL
//SDMA0_RLC4_MIDCMD_DATA8
#define SDMA0_RLC4_MIDCMD_DATA8__DATA8__SHIFT                                                                 0x0
#define SDMA0_RLC4_MIDCMD_DATA8__DATA8_MASK                                                                   0xFFFFFFFFL
//SDMA0_RLC4_MIDCMD_DATA9
#define SDMA0_RLC4_MIDCMD_DATA9__DATA9__SHIFT                                                                 0x0
#define SDMA0_RLC4_MIDCMD_DATA9__DATA9_MASK                                                                   0xFFFFFFFFL
//SDMA0_RLC4_MIDCMD_DATA10
#define SDMA0_RLC4_MIDCMD_DATA10__DATA10__SHIFT                                                               0x0
#define SDMA0_RLC4_MIDCMD_DATA10__DATA10_MASK                                                                 0xFFFFFFFFL
//SDMA0_RLC4_MIDCMD_CNTL
#define SDMA0_RLC4_MIDCMD_CNTL__DATA_VALID__SHIFT                                                             0x0
#define SDMA0_RLC4_MIDCMD_CNTL__COPY_MODE__SHIFT                                                              0x1
#define SDMA0_RLC4_MIDCMD_CNTL__SPLIT_STATE__SHIFT                                                            0x4
#define SDMA0_RLC4_MIDCMD_CNTL__ALLOW_PREEMPT__SHIFT                                                          0x8
#define SDMA0_RLC4_MIDCMD_CNTL__DATA_VALID_MASK                                                               0x00000001L
#define SDMA0_RLC4_MIDCMD_CNTL__COPY_MODE_MASK                                                                0x00000002L
#define SDMA0_RLC4_MIDCMD_CNTL__SPLIT_STATE_MASK                                                              0x000000F0L
#define SDMA0_RLC4_MIDCMD_CNTL__ALLOW_PREEMPT_MASK                                                            0x00000100L
//SDMA0_RLC5_RB_CNTL
#define SDMA0_RLC5_RB_CNTL__RB_ENABLE__SHIFT                                                                  0x0
#define SDMA0_RLC5_RB_CNTL__RB_SIZE__SHIFT                                                                    0x1
#define SDMA0_RLC5_RB_CNTL__RB_SWAP_ENABLE__SHIFT                                                             0x9
#define SDMA0_RLC5_RB_CNTL__RPTR_WRITEBACK_ENABLE__SHIFT                                                      0xc
#define SDMA0_RLC5_RB_CNTL__RPTR_WRITEBACK_SWAP_ENABLE__SHIFT                                                 0xd
#define SDMA0_RLC5_RB_CNTL__RPTR_WRITEBACK_TIMER__SHIFT                                                       0x10
#define SDMA0_RLC5_RB_CNTL__RB_PRIV__SHIFT                                                                    0x17
#define SDMA0_RLC5_RB_CNTL__RB_VMID__SHIFT                                                                    0x18
#define SDMA0_RLC5_RB_CNTL__RPTR_WB_IDLE__SHIFT                                                               0x1f
#define SDMA0_RLC5_RB_CNTL__RB_ENABLE_MASK                                                                    0x00000001L
#define SDMA0_RLC5_RB_CNTL__RB_SIZE_MASK                                                                      0x0000003EL
#define SDMA0_RLC5_RB_CNTL__RB_SWAP_ENABLE_MASK                                                               0x00000200L
#define SDMA0_RLC5_RB_CNTL__RPTR_WRITEBACK_ENABLE_MASK                                                        0x00001000L
#define SDMA0_RLC5_RB_CNTL__RPTR_WRITEBACK_SWAP_ENABLE_MASK                                                   0x00002000L
#define SDMA0_RLC5_RB_CNTL__RPTR_WRITEBACK_TIMER_MASK                                                         0x001F0000L
#define SDMA0_RLC5_RB_CNTL__RB_PRIV_MASK                                                                      0x00800000L
#define SDMA0_RLC5_RB_CNTL__RB_VMID_MASK                                                                      0x0F000000L
#define SDMA0_RLC5_RB_CNTL__RPTR_WB_IDLE_MASK                                                                 0x80000000L
//SDMA0_RLC5_RB_BASE
#define SDMA0_RLC5_RB_BASE__ADDR__SHIFT                                                                       0x0
#define SDMA0_RLC5_RB_BASE__ADDR_MASK                                                                         0xFFFFFFFFL
//SDMA0_RLC5_RB_BASE_HI
#define SDMA0_RLC5_RB_BASE_HI__ADDR__SHIFT                                                                    0x0
#define SDMA0_RLC5_RB_BASE_HI__ADDR_MASK                                                                      0x00FFFFFFL
//SDMA0_RLC5_RB_RPTR
#define SDMA0_RLC5_RB_RPTR__OFFSET__SHIFT                                                                     0x0
#define SDMA0_RLC5_RB_RPTR__OFFSET_MASK                                                                       0xFFFFFFFFL
//SDMA0_RLC5_RB_RPTR_HI
#define SDMA0_RLC5_RB_RPTR_HI__OFFSET__SHIFT                                                                  0x0
#define SDMA0_RLC5_RB_RPTR_HI__OFFSET_MASK                                                                    0xFFFFFFFFL
//SDMA0_RLC5_RB_WPTR
#define SDMA0_RLC5_RB_WPTR__OFFSET__SHIFT                                                                     0x0
#define SDMA0_RLC5_RB_WPTR__OFFSET_MASK                                                                       0xFFFFFFFFL
//SDMA0_RLC5_RB_WPTR_HI
#define SDMA0_RLC5_RB_WPTR_HI__OFFSET__SHIFT                                                                  0x0
#define SDMA0_RLC5_RB_WPTR_HI__OFFSET_MASK                                                                    0xFFFFFFFFL
//SDMA0_RLC5_RB_WPTR_POLL_CNTL
#define SDMA0_RLC5_RB_WPTR_POLL_CNTL__ENABLE__SHIFT                                                           0x0
#define SDMA0_RLC5_RB_WPTR_POLL_CNTL__SWAP_ENABLE__SHIFT                                                      0x1
#define SDMA0_RLC5_RB_WPTR_POLL_CNTL__F32_POLL_ENABLE__SHIFT                                                  0x2
#define SDMA0_RLC5_RB_WPTR_POLL_CNTL__FREQUENCY__SHIFT                                                        0x4
#define SDMA0_RLC5_RB_WPTR_POLL_CNTL__IDLE_POLL_COUNT__SHIFT                                                  0x10
#define SDMA0_RLC5_RB_WPTR_POLL_CNTL__ENABLE_MASK                                                             0x00000001L
#define SDMA0_RLC5_RB_WPTR_POLL_CNTL__SWAP_ENABLE_MASK                                                        0x00000002L
#define SDMA0_RLC5_RB_WPTR_POLL_CNTL__F32_POLL_ENABLE_MASK                                                    0x00000004L
#define SDMA0_RLC5_RB_WPTR_POLL_CNTL__FREQUENCY_MASK                                                          0x0000FFF0L
#define SDMA0_RLC5_RB_WPTR_POLL_CNTL__IDLE_POLL_COUNT_MASK                                                    0xFFFF0000L
//SDMA0_RLC5_RB_RPTR_ADDR_HI
#define SDMA0_RLC5_RB_RPTR_ADDR_HI__ADDR__SHIFT                                                               0x0
#define SDMA0_RLC5_RB_RPTR_ADDR_HI__ADDR_MASK                                                                 0xFFFFFFFFL
//SDMA0_RLC5_RB_RPTR_ADDR_LO
#define SDMA0_RLC5_RB_RPTR_ADDR_LO__ADDR__SHIFT                                                               0x2
#define SDMA0_RLC5_RB_RPTR_ADDR_LO__ADDR_MASK                                                                 0xFFFFFFFCL
//SDMA0_RLC5_IB_CNTL
#define SDMA0_RLC5_IB_CNTL__IB_ENABLE__SHIFT                                                                  0x0
#define SDMA0_RLC5_IB_CNTL__IB_SWAP_ENABLE__SHIFT                                                             0x4
#define SDMA0_RLC5_IB_CNTL__SWITCH_INSIDE_IB__SHIFT                                                           0x8
#define SDMA0_RLC5_IB_CNTL__CMD_VMID__SHIFT                                                                   0x10
#define SDMA0_RLC5_IB_CNTL__IB_ENABLE_MASK                                                                    0x00000001L
#define SDMA0_RLC5_IB_CNTL__IB_SWAP_ENABLE_MASK                                                               0x00000010L
#define SDMA0_RLC5_IB_CNTL__SWITCH_INSIDE_IB_MASK                                                             0x00000100L
#define SDMA0_RLC5_IB_CNTL__CMD_VMID_MASK                                                                     0x000F0000L
//SDMA0_RLC5_IB_RPTR
#define SDMA0_RLC5_IB_RPTR__OFFSET__SHIFT                                                                     0x2
#define SDMA0_RLC5_IB_RPTR__OFFSET_MASK                                                                       0x003FFFFCL
//SDMA0_RLC5_IB_OFFSET
#define SDMA0_RLC5_IB_OFFSET__OFFSET__SHIFT                                                                   0x2
#define SDMA0_RLC5_IB_OFFSET__OFFSET_MASK                                                                     0x003FFFFCL
//SDMA0_RLC5_IB_BASE_LO
#define SDMA0_RLC5_IB_BASE_LO__ADDR__SHIFT                                                                    0x5
#define SDMA0_RLC5_IB_BASE_LO__ADDR_MASK                                                                      0xFFFFFFE0L
//SDMA0_RLC5_IB_BASE_HI
#define SDMA0_RLC5_IB_BASE_HI__ADDR__SHIFT                                                                    0x0
#define SDMA0_RLC5_IB_BASE_HI__ADDR_MASK                                                                      0xFFFFFFFFL
//SDMA0_RLC5_IB_SIZE
#define SDMA0_RLC5_IB_SIZE__SIZE__SHIFT                                                                       0x0
#define SDMA0_RLC5_IB_SIZE__SIZE_MASK                                                                         0x000FFFFFL
//SDMA0_RLC5_SKIP_CNTL
#define SDMA0_RLC5_SKIP_CNTL__SKIP_COUNT__SHIFT                                                               0x0
#define SDMA0_RLC5_SKIP_CNTL__SKIP_COUNT_MASK                                                                 0x000FFFFFL
//SDMA0_RLC5_CONTEXT_STATUS
#define SDMA0_RLC5_CONTEXT_STATUS__SELECTED__SHIFT                                                            0x0
#define SDMA0_RLC5_CONTEXT_STATUS__IDLE__SHIFT                                                                0x2
#define SDMA0_RLC5_CONTEXT_STATUS__EXPIRED__SHIFT                                                             0x3
#define SDMA0_RLC5_CONTEXT_STATUS__EXCEPTION__SHIFT                                                           0x4
#define SDMA0_RLC5_CONTEXT_STATUS__CTXSW_ABLE__SHIFT                                                          0x7
#define SDMA0_RLC5_CONTEXT_STATUS__CTXSW_READY__SHIFT                                                         0x8
#define SDMA0_RLC5_CONTEXT_STATUS__PREEMPTED__SHIFT                                                           0x9
#define SDMA0_RLC5_CONTEXT_STATUS__PREEMPT_DISABLE__SHIFT                                                     0xa
#define SDMA0_RLC5_CONTEXT_STATUS__SELECTED_MASK                                                              0x00000001L
#define SDMA0_RLC5_CONTEXT_STATUS__IDLE_MASK                                                                  0x00000004L
#define SDMA0_RLC5_CONTEXT_STATUS__EXPIRED_MASK                                                               0x00000008L
#define SDMA0_RLC5_CONTEXT_STATUS__EXCEPTION_MASK                                                             0x00000070L
#define SDMA0_RLC5_CONTEXT_STATUS__CTXSW_ABLE_MASK                                                            0x00000080L
#define SDMA0_RLC5_CONTEXT_STATUS__CTXSW_READY_MASK                                                           0x00000100L
#define SDMA0_RLC5_CONTEXT_STATUS__PREEMPTED_MASK                                                             0x00000200L
#define SDMA0_RLC5_CONTEXT_STATUS__PREEMPT_DISABLE_MASK                                                       0x00000400L
//SDMA0_RLC5_DOORBELL
#define SDMA0_RLC5_DOORBELL__ENABLE__SHIFT                                                                    0x1c
#define SDMA0_RLC5_DOORBELL__CAPTURED__SHIFT                                                                  0x1e
#define SDMA0_RLC5_DOORBELL__ENABLE_MASK                                                                      0x10000000L
#define SDMA0_RLC5_DOORBELL__CAPTURED_MASK                                                                    0x40000000L
//SDMA0_RLC5_STATUS
#define SDMA0_RLC5_STATUS__WPTR_UPDATE_FAIL_COUNT__SHIFT                                                      0x0
#define SDMA0_RLC5_STATUS__WPTR_UPDATE_PENDING__SHIFT                                                         0x8
#define SDMA0_RLC5_STATUS__WPTR_UPDATE_FAIL_COUNT_MASK                                                        0x000000FFL
#define SDMA0_RLC5_STATUS__WPTR_UPDATE_PENDING_MASK                                                           0x00000100L
//SDMA0_RLC5_DOORBELL_LOG
#define SDMA0_RLC5_DOORBELL_LOG__BE_ERROR__SHIFT                                                              0x0
#define SDMA0_RLC5_DOORBELL_LOG__DATA__SHIFT                                                                  0x2
#define SDMA0_RLC5_DOORBELL_LOG__BE_ERROR_MASK                                                                0x00000001L
#define SDMA0_RLC5_DOORBELL_LOG__DATA_MASK                                                                    0xFFFFFFFCL
//SDMA0_RLC5_WATERMARK
#define SDMA0_RLC5_WATERMARK__RD_OUTSTANDING__SHIFT                                                           0x0
#define SDMA0_RLC5_WATERMARK__WR_OUTSTANDING__SHIFT                                                           0x10
#define SDMA0_RLC5_WATERMARK__RD_OUTSTANDING_MASK                                                             0x00000FFFL
#define SDMA0_RLC5_WATERMARK__WR_OUTSTANDING_MASK                                                             0x03FF0000L
//SDMA0_RLC5_DOORBELL_OFFSET
#define SDMA0_RLC5_DOORBELL_OFFSET__OFFSET__SHIFT                                                             0x2
#define SDMA0_RLC5_DOORBELL_OFFSET__OFFSET_MASK                                                               0x0FFFFFFCL
//SDMA0_RLC5_CSA_ADDR_LO
#define SDMA0_RLC5_CSA_ADDR_LO__ADDR__SHIFT                                                                   0x2
#define SDMA0_RLC5_CSA_ADDR_LO__ADDR_MASK                                                                     0xFFFFFFFCL
//SDMA0_RLC5_CSA_ADDR_HI
#define SDMA0_RLC5_CSA_ADDR_HI__ADDR__SHIFT                                                                   0x0
#define SDMA0_RLC5_CSA_ADDR_HI__ADDR_MASK                                                                     0xFFFFFFFFL
//SDMA0_RLC5_IB_SUB_REMAIN
#define SDMA0_RLC5_IB_SUB_REMAIN__SIZE__SHIFT                                                                 0x0
#define SDMA0_RLC5_IB_SUB_REMAIN__SIZE_MASK                                                                   0x00003FFFL
//SDMA0_RLC5_PREEMPT
#define SDMA0_RLC5_PREEMPT__IB_PREEMPT__SHIFT                                                                 0x0
#define SDMA0_RLC5_PREEMPT__IB_PREEMPT_MASK                                                                   0x00000001L
//SDMA0_RLC5_DUMMY_REG
#define SDMA0_RLC5_DUMMY_REG__DUMMY__SHIFT                                                                    0x0
#define SDMA0_RLC5_DUMMY_REG__DUMMY_MASK                                                                      0xFFFFFFFFL
//SDMA0_RLC5_RB_WPTR_POLL_ADDR_HI
#define SDMA0_RLC5_RB_WPTR_POLL_ADDR_HI__ADDR__SHIFT                                                          0x0
#define SDMA0_RLC5_RB_WPTR_POLL_ADDR_HI__ADDR_MASK                                                            0xFFFFFFFFL
//SDMA0_RLC5_RB_WPTR_POLL_ADDR_LO
#define SDMA0_RLC5_RB_WPTR_POLL_ADDR_LO__ADDR__SHIFT                                                          0x2
#define SDMA0_RLC5_RB_WPTR_POLL_ADDR_LO__ADDR_MASK                                                            0xFFFFFFFCL
//SDMA0_RLC5_RB_AQL_CNTL
#define SDMA0_RLC5_RB_AQL_CNTL__AQL_ENABLE__SHIFT                                                             0x0
#define SDMA0_RLC5_RB_AQL_CNTL__AQL_PACKET_SIZE__SHIFT                                                        0x1
#define SDMA0_RLC5_RB_AQL_CNTL__PACKET_STEP__SHIFT                                                            0x8
#define SDMA0_RLC5_RB_AQL_CNTL__MIDCMD_PREEMPT_ENABLE__SHIFT                                                  0x10
#define SDMA0_RLC5_RB_AQL_CNTL__MIDCMD_PREEMPT_DATA_RESTORE__SHIFT                                            0x11
#define SDMA0_RLC5_RB_AQL_CNTL__OVERLAP_ENABLE__SHIFT                                                         0x12
#define SDMA0_RLC5_RB_AQL_CNTL__AQL_ENABLE_MASK                                                               0x00000001L
#define SDMA0_RLC5_RB_AQL_CNTL__AQL_PACKET_SIZE_MASK                                                          0x000000FEL
#define SDMA0_RLC5_RB_AQL_CNTL__PACKET_STEP_MASK                                                              0x0000FF00L
#define SDMA0_RLC5_RB_AQL_CNTL__MIDCMD_PREEMPT_ENABLE_MASK                                                    0x00010000L
#define SDMA0_RLC5_RB_AQL_CNTL__MIDCMD_PREEMPT_DATA_RESTORE_MASK                                              0x00020000L
#define SDMA0_RLC5_RB_AQL_CNTL__OVERLAP_ENABLE_MASK                                                           0x00040000L
//SDMA0_RLC5_MINOR_PTR_UPDATE
#define SDMA0_RLC5_MINOR_PTR_UPDATE__ENABLE__SHIFT                                                            0x0
#define SDMA0_RLC5_MINOR_PTR_UPDATE__ENABLE_MASK                                                              0x00000001L
//SDMA0_RLC5_MIDCMD_DATA0
#define SDMA0_RLC5_MIDCMD_DATA0__DATA0__SHIFT                                                                 0x0
#define SDMA0_RLC5_MIDCMD_DATA0__DATA0_MASK                                                                   0xFFFFFFFFL
//SDMA0_RLC5_MIDCMD_DATA1
#define SDMA0_RLC5_MIDCMD_DATA1__DATA1__SHIFT                                                                 0x0
#define SDMA0_RLC5_MIDCMD_DATA1__DATA1_MASK                                                                   0xFFFFFFFFL
//SDMA0_RLC5_MIDCMD_DATA2
#define SDMA0_RLC5_MIDCMD_DATA2__DATA2__SHIFT                                                                 0x0
#define SDMA0_RLC5_MIDCMD_DATA2__DATA2_MASK                                                                   0xFFFFFFFFL
//SDMA0_RLC5_MIDCMD_DATA3
#define SDMA0_RLC5_MIDCMD_DATA3__DATA3__SHIFT                                                                 0x0
#define SDMA0_RLC5_MIDCMD_DATA3__DATA3_MASK                                                                   0xFFFFFFFFL
//SDMA0_RLC5_MIDCMD_DATA4
#define SDMA0_RLC5_MIDCMD_DATA4__DATA4__SHIFT                                                                 0x0
#define SDMA0_RLC5_MIDCMD_DATA4__DATA4_MASK                                                                   0xFFFFFFFFL
//SDMA0_RLC5_MIDCMD_DATA5
#define SDMA0_RLC5_MIDCMD_DATA5__DATA5__SHIFT                                                                 0x0
#define SDMA0_RLC5_MIDCMD_DATA5__DATA5_MASK                                                                   0xFFFFFFFFL
//SDMA0_RLC5_MIDCMD_DATA6
#define SDMA0_RLC5_MIDCMD_DATA6__DATA6__SHIFT                                                                 0x0
#define SDMA0_RLC5_MIDCMD_DATA6__DATA6_MASK                                                                   0xFFFFFFFFL
//SDMA0_RLC5_MIDCMD_DATA7
#define SDMA0_RLC5_MIDCMD_DATA7__DATA7__SHIFT                                                                 0x0
#define SDMA0_RLC5_MIDCMD_DATA7__DATA7_MASK                                                                   0xFFFFFFFFL
//SDMA0_RLC5_MIDCMD_DATA8
#define SDMA0_RLC5_MIDCMD_DATA8__DATA8__SHIFT                                                                 0x0
#define SDMA0_RLC5_MIDCMD_DATA8__DATA8_MASK                                                                   0xFFFFFFFFL
//SDMA0_RLC5_MIDCMD_DATA9
#define SDMA0_RLC5_MIDCMD_DATA9__DATA9__SHIFT                                                                 0x0
#define SDMA0_RLC5_MIDCMD_DATA9__DATA9_MASK                                                                   0xFFFFFFFFL
//SDMA0_RLC5_MIDCMD_DATA10
#define SDMA0_RLC5_MIDCMD_DATA10__DATA10__SHIFT                                                               0x0
#define SDMA0_RLC5_MIDCMD_DATA10__DATA10_MASK                                                                 0xFFFFFFFFL
//SDMA0_RLC5_MIDCMD_CNTL
#define SDMA0_RLC5_MIDCMD_CNTL__DATA_VALID__SHIFT                                                             0x0
#define SDMA0_RLC5_MIDCMD_CNTL__COPY_MODE__SHIFT                                                              0x1
#define SDMA0_RLC5_MIDCMD_CNTL__SPLIT_STATE__SHIFT                                                            0x4
#define SDMA0_RLC5_MIDCMD_CNTL__ALLOW_PREEMPT__SHIFT                                                          0x8
#define SDMA0_RLC5_MIDCMD_CNTL__DATA_VALID_MASK                                                               0x00000001L
#define SDMA0_RLC5_MIDCMD_CNTL__COPY_MODE_MASK                                                                0x00000002L
#define SDMA0_RLC5_MIDCMD_CNTL__SPLIT_STATE_MASK                                                              0x000000F0L
#define SDMA0_RLC5_MIDCMD_CNTL__ALLOW_PREEMPT_MASK                                                            0x00000100L
//SDMA0_RLC6_RB_CNTL
#define SDMA0_RLC6_RB_CNTL__RB_ENABLE__SHIFT                                                                  0x0
#define SDMA0_RLC6_RB_CNTL__RB_SIZE__SHIFT                                                                    0x1
#define SDMA0_RLC6_RB_CNTL__RB_SWAP_ENABLE__SHIFT                                                             0x9
#define SDMA0_RLC6_RB_CNTL__RPTR_WRITEBACK_ENABLE__SHIFT                                                      0xc
#define SDMA0_RLC6_RB_CNTL__RPTR_WRITEBACK_SWAP_ENABLE__SHIFT                                                 0xd
#define SDMA0_RLC6_RB_CNTL__RPTR_WRITEBACK_TIMER__SHIFT                                                       0x10
#define SDMA0_RLC6_RB_CNTL__RB_PRIV__SHIFT                                                                    0x17
#define SDMA0_RLC6_RB_CNTL__RB_VMID__SHIFT                                                                    0x18
#define SDMA0_RLC6_RB_CNTL__RPTR_WB_IDLE__SHIFT                                                               0x1f
#define SDMA0_RLC6_RB_CNTL__RB_ENABLE_MASK                                                                    0x00000001L
#define SDMA0_RLC6_RB_CNTL__RB_SIZE_MASK                                                                      0x0000003EL
#define SDMA0_RLC6_RB_CNTL__RB_SWAP_ENABLE_MASK                                                               0x00000200L
#define SDMA0_RLC6_RB_CNTL__RPTR_WRITEBACK_ENABLE_MASK                                                        0x00001000L
#define SDMA0_RLC6_RB_CNTL__RPTR_WRITEBACK_SWAP_ENABLE_MASK                                                   0x00002000L
#define SDMA0_RLC6_RB_CNTL__RPTR_WRITEBACK_TIMER_MASK                                                         0x001F0000L
#define SDMA0_RLC6_RB_CNTL__RB_PRIV_MASK                                                                      0x00800000L
#define SDMA0_RLC6_RB_CNTL__RB_VMID_MASK                                                                      0x0F000000L
#define SDMA0_RLC6_RB_CNTL__RPTR_WB_IDLE_MASK                                                                 0x80000000L
//SDMA0_RLC6_RB_BASE
#define SDMA0_RLC6_RB_BASE__ADDR__SHIFT                                                                       0x0
#define SDMA0_RLC6_RB_BASE__ADDR_MASK                                                                         0xFFFFFFFFL
//SDMA0_RLC6_RB_BASE_HI
#define SDMA0_RLC6_RB_BASE_HI__ADDR__SHIFT                                                                    0x0
#define SDMA0_RLC6_RB_BASE_HI__ADDR_MASK                                                                      0x00FFFFFFL
//SDMA0_RLC6_RB_RPTR
#define SDMA0_RLC6_RB_RPTR__OFFSET__SHIFT                                                                     0x0
#define SDMA0_RLC6_RB_RPTR__OFFSET_MASK                                                                       0xFFFFFFFFL
//SDMA0_RLC6_RB_RPTR_HI
#define SDMA0_RLC6_RB_RPTR_HI__OFFSET__SHIFT                                                                  0x0
#define SDMA0_RLC6_RB_RPTR_HI__OFFSET_MASK                                                                    0xFFFFFFFFL
//SDMA0_RLC6_RB_WPTR
#define SDMA0_RLC6_RB_WPTR__OFFSET__SHIFT                                                                     0x0
#define SDMA0_RLC6_RB_WPTR__OFFSET_MASK                                                                       0xFFFFFFFFL
//SDMA0_RLC6_RB_WPTR_HI
#define SDMA0_RLC6_RB_WPTR_HI__OFFSET__SHIFT                                                                  0x0
#define SDMA0_RLC6_RB_WPTR_HI__OFFSET_MASK                                                                    0xFFFFFFFFL
//SDMA0_RLC6_RB_WPTR_POLL_CNTL
#define SDMA0_RLC6_RB_WPTR_POLL_CNTL__ENABLE__SHIFT                                                           0x0
#define SDMA0_RLC6_RB_WPTR_POLL_CNTL__SWAP_ENABLE__SHIFT                                                      0x1
#define SDMA0_RLC6_RB_WPTR_POLL_CNTL__F32_POLL_ENABLE__SHIFT                                                  0x2
#define SDMA0_RLC6_RB_WPTR_POLL_CNTL__FREQUENCY__SHIFT                                                        0x4
#define SDMA0_RLC6_RB_WPTR_POLL_CNTL__IDLE_POLL_COUNT__SHIFT                                                  0x10
#define SDMA0_RLC6_RB_WPTR_POLL_CNTL__ENABLE_MASK                                                             0x00000001L
#define SDMA0_RLC6_RB_WPTR_POLL_CNTL__SWAP_ENABLE_MASK                                                        0x00000002L
#define SDMA0_RLC6_RB_WPTR_POLL_CNTL__F32_POLL_ENABLE_MASK                                                    0x00000004L
#define SDMA0_RLC6_RB_WPTR_POLL_CNTL__FREQUENCY_MASK                                                          0x0000FFF0L
#define SDMA0_RLC6_RB_WPTR_POLL_CNTL__IDLE_POLL_COUNT_MASK                                                    0xFFFF0000L
//SDMA0_RLC6_RB_RPTR_ADDR_HI
#define SDMA0_RLC6_RB_RPTR_ADDR_HI__ADDR__SHIFT                                                               0x0
#define SDMA0_RLC6_RB_RPTR_ADDR_HI__ADDR_MASK                                                                 0xFFFFFFFFL
//SDMA0_RLC6_RB_RPTR_ADDR_LO
#define SDMA0_RLC6_RB_RPTR_ADDR_LO__ADDR__SHIFT                                                               0x2
#define SDMA0_RLC6_RB_RPTR_ADDR_LO__ADDR_MASK                                                                 0xFFFFFFFCL
//SDMA0_RLC6_IB_CNTL
#define SDMA0_RLC6_IB_CNTL__IB_ENABLE__SHIFT                                                                  0x0
#define SDMA0_RLC6_IB_CNTL__IB_SWAP_ENABLE__SHIFT                                                             0x4
#define SDMA0_RLC6_IB_CNTL__SWITCH_INSIDE_IB__SHIFT                                                           0x8
#define SDMA0_RLC6_IB_CNTL__CMD_VMID__SHIFT                                                                   0x10
#define SDMA0_RLC6_IB_CNTL__IB_ENABLE_MASK                                                                    0x00000001L
#define SDMA0_RLC6_IB_CNTL__IB_SWAP_ENABLE_MASK                                                               0x00000010L
#define SDMA0_RLC6_IB_CNTL__SWITCH_INSIDE_IB_MASK                                                             0x00000100L
#define SDMA0_RLC6_IB_CNTL__CMD_VMID_MASK                                                                     0x000F0000L
//SDMA0_RLC6_IB_RPTR
#define SDMA0_RLC6_IB_RPTR__OFFSET__SHIFT                                                                     0x2
#define SDMA0_RLC6_IB_RPTR__OFFSET_MASK                                                                       0x003FFFFCL
//SDMA0_RLC6_IB_OFFSET
#define SDMA0_RLC6_IB_OFFSET__OFFSET__SHIFT                                                                   0x2
#define SDMA0_RLC6_IB_OFFSET__OFFSET_MASK                                                                     0x003FFFFCL
//SDMA0_RLC6_IB_BASE_LO
#define SDMA0_RLC6_IB_BASE_LO__ADDR__SHIFT                                                                    0x5
#define SDMA0_RLC6_IB_BASE_LO__ADDR_MASK                                                                      0xFFFFFFE0L
//SDMA0_RLC6_IB_BASE_HI
#define SDMA0_RLC6_IB_BASE_HI__ADDR__SHIFT                                                                    0x0
#define SDMA0_RLC6_IB_BASE_HI__ADDR_MASK                                                                      0xFFFFFFFFL
//SDMA0_RLC6_IB_SIZE
#define SDMA0_RLC6_IB_SIZE__SIZE__SHIFT                                                                       0x0
#define SDMA0_RLC6_IB_SIZE__SIZE_MASK                                                                         0x000FFFFFL
//SDMA0_RLC6_SKIP_CNTL
#define SDMA0_RLC6_SKIP_CNTL__SKIP_COUNT__SHIFT                                                               0x0
#define SDMA0_RLC6_SKIP_CNTL__SKIP_COUNT_MASK                                                                 0x000FFFFFL
//SDMA0_RLC6_CONTEXT_STATUS
#define SDMA0_RLC6_CONTEXT_STATUS__SELECTED__SHIFT                                                            0x0
#define SDMA0_RLC6_CONTEXT_STATUS__IDLE__SHIFT                                                                0x2
#define SDMA0_RLC6_CONTEXT_STATUS__EXPIRED__SHIFT                                                             0x3
#define SDMA0_RLC6_CONTEXT_STATUS__EXCEPTION__SHIFT                                                           0x4
#define SDMA0_RLC6_CONTEXT_STATUS__CTXSW_ABLE__SHIFT                                                          0x7
#define SDMA0_RLC6_CONTEXT_STATUS__CTXSW_READY__SHIFT                                                         0x8
#define SDMA0_RLC6_CONTEXT_STATUS__PREEMPTED__SHIFT                                                           0x9
#define SDMA0_RLC6_CONTEXT_STATUS__PREEMPT_DISABLE__SHIFT                                                     0xa
#define SDMA0_RLC6_CONTEXT_STATUS__SELECTED_MASK                                                              0x00000001L
#define SDMA0_RLC6_CONTEXT_STATUS__IDLE_MASK                                                                  0x00000004L
#define SDMA0_RLC6_CONTEXT_STATUS__EXPIRED_MASK                                                               0x00000008L
#define SDMA0_RLC6_CONTEXT_STATUS__EXCEPTION_MASK                                                             0x00000070L
#define SDMA0_RLC6_CONTEXT_STATUS__CTXSW_ABLE_MASK                                                            0x00000080L
#define SDMA0_RLC6_CONTEXT_STATUS__CTXSW_READY_MASK                                                           0x00000100L
#define SDMA0_RLC6_CONTEXT_STATUS__PREEMPTED_MASK                                                             0x00000200L
#define SDMA0_RLC6_CONTEXT_STATUS__PREEMPT_DISABLE_MASK                                                       0x00000400L
//SDMA0_RLC6_DOORBELL
#define SDMA0_RLC6_DOORBELL__ENABLE__SHIFT                                                                    0x1c
#define SDMA0_RLC6_DOORBELL__CAPTURED__SHIFT                                                                  0x1e
#define SDMA0_RLC6_DOORBELL__ENABLE_MASK                                                                      0x10000000L
#define SDMA0_RLC6_DOORBELL__CAPTURED_MASK                                                                    0x40000000L
//SDMA0_RLC6_STATUS
#define SDMA0_RLC6_STATUS__WPTR_UPDATE_FAIL_COUNT__SHIFT                                                      0x0
#define SDMA0_RLC6_STATUS__WPTR_UPDATE_PENDING__SHIFT                                                         0x8
#define SDMA0_RLC6_STATUS__WPTR_UPDATE_FAIL_COUNT_MASK                                                        0x000000FFL
#define SDMA0_RLC6_STATUS__WPTR_UPDATE_PENDING_MASK                                                           0x00000100L
//SDMA0_RLC6_DOORBELL_LOG
#define SDMA0_RLC6_DOORBELL_LOG__BE_ERROR__SHIFT                                                              0x0
#define SDMA0_RLC6_DOORBELL_LOG__DATA__SHIFT                                                                  0x2
#define SDMA0_RLC6_DOORBELL_LOG__BE_ERROR_MASK                                                                0x00000001L
#define SDMA0_RLC6_DOORBELL_LOG__DATA_MASK                                                                    0xFFFFFFFCL
//SDMA0_RLC6_WATERMARK
#define SDMA0_RLC6_WATERMARK__RD_OUTSTANDING__SHIFT                                                           0x0
#define SDMA0_RLC6_WATERMARK__WR_OUTSTANDING__SHIFT                                                           0x10
#define SDMA0_RLC6_WATERMARK__RD_OUTSTANDING_MASK                                                             0x00000FFFL
#define SDMA0_RLC6_WATERMARK__WR_OUTSTANDING_MASK                                                             0x03FF0000L
//SDMA0_RLC6_DOORBELL_OFFSET
#define SDMA0_RLC6_DOORBELL_OFFSET__OFFSET__SHIFT                                                             0x2
#define SDMA0_RLC6_DOORBELL_OFFSET__OFFSET_MASK                                                               0x0FFFFFFCL
//SDMA0_RLC6_CSA_ADDR_LO
#define SDMA0_RLC6_CSA_ADDR_LO__ADDR__SHIFT                                                                   0x2
#define SDMA0_RLC6_CSA_ADDR_LO__ADDR_MASK                                                                     0xFFFFFFFCL
//SDMA0_RLC6_CSA_ADDR_HI
#define SDMA0_RLC6_CSA_ADDR_HI__ADDR__SHIFT                                                                   0x0
#define SDMA0_RLC6_CSA_ADDR_HI__ADDR_MASK                                                                     0xFFFFFFFFL
//SDMA0_RLC6_IB_SUB_REMAIN
#define SDMA0_RLC6_IB_SUB_REMAIN__SIZE__SHIFT                                                                 0x0
#define SDMA0_RLC6_IB_SUB_REMAIN__SIZE_MASK                                                                   0x00003FFFL
//SDMA0_RLC6_PREEMPT
#define SDMA0_RLC6_PREEMPT__IB_PREEMPT__SHIFT                                                                 0x0
#define SDMA0_RLC6_PREEMPT__IB_PREEMPT_MASK                                                                   0x00000001L
//SDMA0_RLC6_DUMMY_REG
#define SDMA0_RLC6_DUMMY_REG__DUMMY__SHIFT                                                                    0x0
#define SDMA0_RLC6_DUMMY_REG__DUMMY_MASK                                                                      0xFFFFFFFFL
//SDMA0_RLC6_RB_WPTR_POLL_ADDR_HI
#define SDMA0_RLC6_RB_WPTR_POLL_ADDR_HI__ADDR__SHIFT                                                          0x0
#define SDMA0_RLC6_RB_WPTR_POLL_ADDR_HI__ADDR_MASK                                                            0xFFFFFFFFL
//SDMA0_RLC6_RB_WPTR_POLL_ADDR_LO
#define SDMA0_RLC6_RB_WPTR_POLL_ADDR_LO__ADDR__SHIFT                                                          0x2
#define SDMA0_RLC6_RB_WPTR_POLL_ADDR_LO__ADDR_MASK                                                            0xFFFFFFFCL
//SDMA0_RLC6_RB_AQL_CNTL
#define SDMA0_RLC6_RB_AQL_CNTL__AQL_ENABLE__SHIFT                                                             0x0
#define SDMA0_RLC6_RB_AQL_CNTL__AQL_PACKET_SIZE__SHIFT                                                        0x1
#define SDMA0_RLC6_RB_AQL_CNTL__PACKET_STEP__SHIFT                                                            0x8
#define SDMA0_RLC6_RB_AQL_CNTL__MIDCMD_PREEMPT_ENABLE__SHIFT                                                  0x10
#define SDMA0_RLC6_RB_AQL_CNTL__MIDCMD_PREEMPT_DATA_RESTORE__SHIFT                                            0x11
#define SDMA0_RLC6_RB_AQL_CNTL__OVERLAP_ENABLE__SHIFT                                                         0x12
#define SDMA0_RLC6_RB_AQL_CNTL__AQL_ENABLE_MASK                                                               0x00000001L
#define SDMA0_RLC6_RB_AQL_CNTL__AQL_PACKET_SIZE_MASK                                                          0x000000FEL
#define SDMA0_RLC6_RB_AQL_CNTL__PACKET_STEP_MASK                                                              0x0000FF00L
#define SDMA0_RLC6_RB_AQL_CNTL__MIDCMD_PREEMPT_ENABLE_MASK                                                    0x00010000L
#define SDMA0_RLC6_RB_AQL_CNTL__MIDCMD_PREEMPT_DATA_RESTORE_MASK                                              0x00020000L
#define SDMA0_RLC6_RB_AQL_CNTL__OVERLAP_ENABLE_MASK                                                           0x00040000L
//SDMA0_RLC6_MINOR_PTR_UPDATE
#define SDMA0_RLC6_MINOR_PTR_UPDATE__ENABLE__SHIFT                                                            0x0
#define SDMA0_RLC6_MINOR_PTR_UPDATE__ENABLE_MASK                                                              0x00000001L
//SDMA0_RLC6_MIDCMD_DATA0
#define SDMA0_RLC6_MIDCMD_DATA0__DATA0__SHIFT                                                                 0x0
#define SDMA0_RLC6_MIDCMD_DATA0__DATA0_MASK                                                                   0xFFFFFFFFL
//SDMA0_RLC6_MIDCMD_DATA1
#define SDMA0_RLC6_MIDCMD_DATA1__DATA1__SHIFT                                                                 0x0
#define SDMA0_RLC6_MIDCMD_DATA1__DATA1_MASK                                                                   0xFFFFFFFFL
//SDMA0_RLC6_MIDCMD_DATA2
#define SDMA0_RLC6_MIDCMD_DATA2__DATA2__SHIFT                                                                 0x0
#define SDMA0_RLC6_MIDCMD_DATA2__DATA2_MASK                                                                   0xFFFFFFFFL
//SDMA0_RLC6_MIDCMD_DATA3
#define SDMA0_RLC6_MIDCMD_DATA3__DATA3__SHIFT                                                                 0x0
#define SDMA0_RLC6_MIDCMD_DATA3__DATA3_MASK                                                                   0xFFFFFFFFL
//SDMA0_RLC6_MIDCMD_DATA4
#define SDMA0_RLC6_MIDCMD_DATA4__DATA4__SHIFT                                                                 0x0
#define SDMA0_RLC6_MIDCMD_DATA4__DATA4_MASK                                                                   0xFFFFFFFFL
//SDMA0_RLC6_MIDCMD_DATA5
#define SDMA0_RLC6_MIDCMD_DATA5__DATA5__SHIFT                                                                 0x0
#define SDMA0_RLC6_MIDCMD_DATA5__DATA5_MASK                                                                   0xFFFFFFFFL
//SDMA0_RLC6_MIDCMD_DATA6
#define SDMA0_RLC6_MIDCMD_DATA6__DATA6__SHIFT                                                                 0x0
#define SDMA0_RLC6_MIDCMD_DATA6__DATA6_MASK                                                                   0xFFFFFFFFL
//SDMA0_RLC6_MIDCMD_DATA7
#define SDMA0_RLC6_MIDCMD_DATA7__DATA7__SHIFT                                                                 0x0
#define SDMA0_RLC6_MIDCMD_DATA7__DATA7_MASK                                                                   0xFFFFFFFFL
//SDMA0_RLC6_MIDCMD_DATA8
#define SDMA0_RLC6_MIDCMD_DATA8__DATA8__SHIFT                                                                 0x0
#define SDMA0_RLC6_MIDCMD_DATA8__DATA8_MASK                                                                   0xFFFFFFFFL
//SDMA0_RLC6_MIDCMD_DATA9
#define SDMA0_RLC6_MIDCMD_DATA9__DATA9__SHIFT                                                                 0x0
#define SDMA0_RLC6_MIDCMD_DATA9__DATA9_MASK                                                                   0xFFFFFFFFL
//SDMA0_RLC6_MIDCMD_DATA10
#define SDMA0_RLC6_MIDCMD_DATA10__DATA10__SHIFT                                                               0x0
#define SDMA0_RLC6_MIDCMD_DATA10__DATA10_MASK                                                                 0xFFFFFFFFL
//SDMA0_RLC6_MIDCMD_CNTL
#define SDMA0_RLC6_MIDCMD_CNTL__DATA_VALID__SHIFT                                                             0x0
#define SDMA0_RLC6_MIDCMD_CNTL__COPY_MODE__SHIFT                                                              0x1
#define SDMA0_RLC6_MIDCMD_CNTL__SPLIT_STATE__SHIFT                                                            0x4
#define SDMA0_RLC6_MIDCMD_CNTL__ALLOW_PREEMPT__SHIFT                                                          0x8
#define SDMA0_RLC6_MIDCMD_CNTL__DATA_VALID_MASK                                                               0x00000001L
#define SDMA0_RLC6_MIDCMD_CNTL__COPY_MODE_MASK                                                                0x00000002L
#define SDMA0_RLC6_MIDCMD_CNTL__SPLIT_STATE_MASK                                                              0x000000F0L
#define SDMA0_RLC6_MIDCMD_CNTL__ALLOW_PREEMPT_MASK                                                            0x00000100L
//SDMA0_RLC7_RB_CNTL
#define SDMA0_RLC7_RB_CNTL__RB_ENABLE__SHIFT                                                                  0x0
#define SDMA0_RLC7_RB_CNTL__RB_SIZE__SHIFT                                                                    0x1
#define SDMA0_RLC7_RB_CNTL__RB_SWAP_ENABLE__SHIFT                                                             0x9
#define SDMA0_RLC7_RB_CNTL__RPTR_WRITEBACK_ENABLE__SHIFT                                                      0xc
#define SDMA0_RLC7_RB_CNTL__RPTR_WRITEBACK_SWAP_ENABLE__SHIFT                                                 0xd
#define SDMA0_RLC7_RB_CNTL__RPTR_WRITEBACK_TIMER__SHIFT                                                       0x10
#define SDMA0_RLC7_RB_CNTL__RB_PRIV__SHIFT                                                                    0x17
#define SDMA0_RLC7_RB_CNTL__RB_VMID__SHIFT                                                                    0x18
#define SDMA0_RLC7_RB_CNTL__RPTR_WB_IDLE__SHIFT                                                               0x1f
#define SDMA0_RLC7_RB_CNTL__RB_ENABLE_MASK                                                                    0x00000001L
#define SDMA0_RLC7_RB_CNTL__RB_SIZE_MASK                                                                      0x0000003EL
#define SDMA0_RLC7_RB_CNTL__RB_SWAP_ENABLE_MASK                                                               0x00000200L
#define SDMA0_RLC7_RB_CNTL__RPTR_WRITEBACK_ENABLE_MASK                                                        0x00001000L
#define SDMA0_RLC7_RB_CNTL__RPTR_WRITEBACK_SWAP_ENABLE_MASK                                                   0x00002000L
#define SDMA0_RLC7_RB_CNTL__RPTR_WRITEBACK_TIMER_MASK                                                         0x001F0000L
#define SDMA0_RLC7_RB_CNTL__RB_PRIV_MASK                                                                      0x00800000L
#define SDMA0_RLC7_RB_CNTL__RB_VMID_MASK                                                                      0x0F000000L
#define SDMA0_RLC7_RB_CNTL__RPTR_WB_IDLE_MASK                                                                 0x80000000L
//SDMA0_RLC7_RB_BASE
#define SDMA0_RLC7_RB_BASE__ADDR__SHIFT                                                                       0x0
#define SDMA0_RLC7_RB_BASE__ADDR_MASK                                                                         0xFFFFFFFFL
//SDMA0_RLC7_RB_BASE_HI
#define SDMA0_RLC7_RB_BASE_HI__ADDR__SHIFT                                                                    0x0
#define SDMA0_RLC7_RB_BASE_HI__ADDR_MASK                                                                      0x00FFFFFFL
//SDMA0_RLC7_RB_RPTR
#define SDMA0_RLC7_RB_RPTR__OFFSET__SHIFT                                                                     0x0
#define SDMA0_RLC7_RB_RPTR__OFFSET_MASK                                                                       0xFFFFFFFFL
//SDMA0_RLC7_RB_RPTR_HI
#define SDMA0_RLC7_RB_RPTR_HI__OFFSET__SHIFT                                                                  0x0
#define SDMA0_RLC7_RB_RPTR_HI__OFFSET_MASK                                                                    0xFFFFFFFFL
//SDMA0_RLC7_RB_WPTR
#define SDMA0_RLC7_RB_WPTR__OFFSET__SHIFT                                                                     0x0
#define SDMA0_RLC7_RB_WPTR__OFFSET_MASK                                                                       0xFFFFFFFFL
//SDMA0_RLC7_RB_WPTR_HI
#define SDMA0_RLC7_RB_WPTR_HI__OFFSET__SHIFT                                                                  0x0
#define SDMA0_RLC7_RB_WPTR_HI__OFFSET_MASK                                                                    0xFFFFFFFFL
//SDMA0_RLC7_RB_WPTR_POLL_CNTL
#define SDMA0_RLC7_RB_WPTR_POLL_CNTL__ENABLE__SHIFT                                                           0x0
#define SDMA0_RLC7_RB_WPTR_POLL_CNTL__SWAP_ENABLE__SHIFT                                                      0x1
#define SDMA0_RLC7_RB_WPTR_POLL_CNTL__F32_POLL_ENABLE__SHIFT                                                  0x2
#define SDMA0_RLC7_RB_WPTR_POLL_CNTL__FREQUENCY__SHIFT                                                        0x4
#define SDMA0_RLC7_RB_WPTR_POLL_CNTL__IDLE_POLL_COUNT__SHIFT                                                  0x10
#define SDMA0_RLC7_RB_WPTR_POLL_CNTL__ENABLE_MASK                                                             0x00000001L
#define SDMA0_RLC7_RB_WPTR_POLL_CNTL__SWAP_ENABLE_MASK                                                        0x00000002L
#define SDMA0_RLC7_RB_WPTR_POLL_CNTL__F32_POLL_ENABLE_MASK                                                    0x00000004L
#define SDMA0_RLC7_RB_WPTR_POLL_CNTL__FREQUENCY_MASK                                                          0x0000FFF0L
#define SDMA0_RLC7_RB_WPTR_POLL_CNTL__IDLE_POLL_COUNT_MASK                                                    0xFFFF0000L
//SDMA0_RLC7_RB_RPTR_ADDR_HI
#define SDMA0_RLC7_RB_RPTR_ADDR_HI__ADDR__SHIFT                                                               0x0
#define SDMA0_RLC7_RB_RPTR_ADDR_HI__ADDR_MASK                                                                 0xFFFFFFFFL
//SDMA0_RLC7_RB_RPTR_ADDR_LO
#define SDMA0_RLC7_RB_RPTR_ADDR_LO__ADDR__SHIFT                                                               0x2
#define SDMA0_RLC7_RB_RPTR_ADDR_LO__ADDR_MASK                                                                 0xFFFFFFFCL
//SDMA0_RLC7_IB_CNTL
#define SDMA0_RLC7_IB_CNTL__IB_ENABLE__SHIFT                                                                  0x0
#define SDMA0_RLC7_IB_CNTL__IB_SWAP_ENABLE__SHIFT                                                             0x4
#define SDMA0_RLC7_IB_CNTL__SWITCH_INSIDE_IB__SHIFT                                                           0x8
#define SDMA0_RLC7_IB_CNTL__CMD_VMID__SHIFT                                                                   0x10
#define SDMA0_RLC7_IB_CNTL__IB_ENABLE_MASK                                                                    0x00000001L
#define SDMA0_RLC7_IB_CNTL__IB_SWAP_ENABLE_MASK                                                               0x00000010L
#define SDMA0_RLC7_IB_CNTL__SWITCH_INSIDE_IB_MASK                                                             0x00000100L
#define SDMA0_RLC7_IB_CNTL__CMD_VMID_MASK                                                                     0x000F0000L
//SDMA0_RLC7_IB_RPTR
#define SDMA0_RLC7_IB_RPTR__OFFSET__SHIFT                                                                     0x2
#define SDMA0_RLC7_IB_RPTR__OFFSET_MASK                                                                       0x003FFFFCL
//SDMA0_RLC7_IB_OFFSET
#define SDMA0_RLC7_IB_OFFSET__OFFSET__SHIFT                                                                   0x2
#define SDMA0_RLC7_IB_OFFSET__OFFSET_MASK                                                                     0x003FFFFCL
//SDMA0_RLC7_IB_BASE_LO
#define SDMA0_RLC7_IB_BASE_LO__ADDR__SHIFT                                                                    0x5
#define SDMA0_RLC7_IB_BASE_LO__ADDR_MASK                                                                      0xFFFFFFE0L
//SDMA0_RLC7_IB_BASE_HI
#define SDMA0_RLC7_IB_BASE_HI__ADDR__SHIFT                                                                    0x0
#define SDMA0_RLC7_IB_BASE_HI__ADDR_MASK                                                                      0xFFFFFFFFL
//SDMA0_RLC7_IB_SIZE
#define SDMA0_RLC7_IB_SIZE__SIZE__SHIFT                                                                       0x0
#define SDMA0_RLC7_IB_SIZE__SIZE_MASK                                                                         0x000FFFFFL
//SDMA0_RLC7_SKIP_CNTL
#define SDMA0_RLC7_SKIP_CNTL__SKIP_COUNT__SHIFT                                                               0x0
#define SDMA0_RLC7_SKIP_CNTL__SKIP_COUNT_MASK                                                                 0x000FFFFFL
//SDMA0_RLC7_CONTEXT_STATUS
#define SDMA0_RLC7_CONTEXT_STATUS__SELECTED__SHIFT                                                            0x0
#define SDMA0_RLC7_CONTEXT_STATUS__IDLE__SHIFT                                                                0x2
#define SDMA0_RLC7_CONTEXT_STATUS__EXPIRED__SHIFT                                                             0x3
#define SDMA0_RLC7_CONTEXT_STATUS__EXCEPTION__SHIFT                                                           0x4
#define SDMA0_RLC7_CONTEXT_STATUS__CTXSW_ABLE__SHIFT                                                          0x7
#define SDMA0_RLC7_CONTEXT_STATUS__CTXSW_READY__SHIFT                                                         0x8
#define SDMA0_RLC7_CONTEXT_STATUS__PREEMPTED__SHIFT                                                           0x9
#define SDMA0_RLC7_CONTEXT_STATUS__PREEMPT_DISABLE__SHIFT                                                     0xa
#define SDMA0_RLC7_CONTEXT_STATUS__SELECTED_MASK                                                              0x00000001L
#define SDMA0_RLC7_CONTEXT_STATUS__IDLE_MASK                                                                  0x00000004L
#define SDMA0_RLC7_CONTEXT_STATUS__EXPIRED_MASK                                                               0x00000008L
#define SDMA0_RLC7_CONTEXT_STATUS__EXCEPTION_MASK                                                             0x00000070L
#define SDMA0_RLC7_CONTEXT_STATUS__CTXSW_ABLE_MASK                                                            0x00000080L
#define SDMA0_RLC7_CONTEXT_STATUS__CTXSW_READY_MASK                                                           0x00000100L
#define SDMA0_RLC7_CONTEXT_STATUS__PREEMPTED_MASK                                                             0x00000200L
#define SDMA0_RLC7_CONTEXT_STATUS__PREEMPT_DISABLE_MASK                                                       0x00000400L
//SDMA0_RLC7_DOORBELL
#define SDMA0_RLC7_DOORBELL__ENABLE__SHIFT                                                                    0x1c
#define SDMA0_RLC7_DOORBELL__CAPTURED__SHIFT                                                                  0x1e
#define SDMA0_RLC7_DOORBELL__ENABLE_MASK                                                                      0x10000000L
#define SDMA0_RLC7_DOORBELL__CAPTURED_MASK                                                                    0x40000000L
//SDMA0_RLC7_STATUS
#define SDMA0_RLC7_STATUS__WPTR_UPDATE_FAIL_COUNT__SHIFT                                                      0x0
#define SDMA0_RLC7_STATUS__WPTR_UPDATE_PENDING__SHIFT                                                         0x8
#define SDMA0_RLC7_STATUS__WPTR_UPDATE_FAIL_COUNT_MASK                                                        0x000000FFL
#define SDMA0_RLC7_STATUS__WPTR_UPDATE_PENDING_MASK                                                           0x00000100L
//SDMA0_RLC7_DOORBELL_LOG
#define SDMA0_RLC7_DOORBELL_LOG__BE_ERROR__SHIFT                                                              0x0
#define SDMA0_RLC7_DOORBELL_LOG__DATA__SHIFT                                                                  0x2
#define SDMA0_RLC7_DOORBELL_LOG__BE_ERROR_MASK                                                                0x00000001L
#define SDMA0_RLC7_DOORBELL_LOG__DATA_MASK                                                                    0xFFFFFFFCL
//SDMA0_RLC7_WATERMARK
#define SDMA0_RLC7_WATERMARK__RD_OUTSTANDING__SHIFT                                                           0x0
#define SDMA0_RLC7_WATERMARK__WR_OUTSTANDING__SHIFT                                                           0x10
#define SDMA0_RLC7_WATERMARK__RD_OUTSTANDING_MASK                                                             0x00000FFFL
#define SDMA0_RLC7_WATERMARK__WR_OUTSTANDING_MASK                                                             0x03FF0000L
//SDMA0_RLC7_DOORBELL_OFFSET
#define SDMA0_RLC7_DOORBELL_OFFSET__OFFSET__SHIFT                                                             0x2
#define SDMA0_RLC7_DOORBELL_OFFSET__OFFSET_MASK                                                               0x0FFFFFFCL
//SDMA0_RLC7_CSA_ADDR_LO
#define SDMA0_RLC7_CSA_ADDR_LO__ADDR__SHIFT                                                                   0x2
#define SDMA0_RLC7_CSA_ADDR_LO__ADDR_MASK                                                                     0xFFFFFFFCL
//SDMA0_RLC7_CSA_ADDR_HI
#define SDMA0_RLC7_CSA_ADDR_HI__ADDR__SHIFT                                                                   0x0
#define SDMA0_RLC7_CSA_ADDR_HI__ADDR_MASK                                                                     0xFFFFFFFFL
//SDMA0_RLC7_IB_SUB_REMAIN
#define SDMA0_RLC7_IB_SUB_REMAIN__SIZE__SHIFT                                                                 0x0
#define SDMA0_RLC7_IB_SUB_REMAIN__SIZE_MASK                                                                   0x00003FFFL
//SDMA0_RLC7_PREEMPT
#define SDMA0_RLC7_PREEMPT__IB_PREEMPT__SHIFT                                                                 0x0
#define SDMA0_RLC7_PREEMPT__IB_PREEMPT_MASK                                                                   0x00000001L
//SDMA0_RLC7_DUMMY_REG
#define SDMA0_RLC7_DUMMY_REG__DUMMY__SHIFT                                                                    0x0
#define SDMA0_RLC7_DUMMY_REG__DUMMY_MASK                                                                      0xFFFFFFFFL
//SDMA0_RLC7_RB_WPTR_POLL_ADDR_HI
#define SDMA0_RLC7_RB_WPTR_POLL_ADDR_HI__ADDR__SHIFT                                                          0x0
#define SDMA0_RLC7_RB_WPTR_POLL_ADDR_HI__ADDR_MASK                                                            0xFFFFFFFFL
//SDMA0_RLC7_RB_WPTR_POLL_ADDR_LO
#define SDMA0_RLC7_RB_WPTR_POLL_ADDR_LO__ADDR__SHIFT                                                          0x2
#define SDMA0_RLC7_RB_WPTR_POLL_ADDR_LO__ADDR_MASK                                                            0xFFFFFFFCL
//SDMA0_RLC7_RB_AQL_CNTL
#define SDMA0_RLC7_RB_AQL_CNTL__AQL_ENABLE__SHIFT                                                             0x0
#define SDMA0_RLC7_RB_AQL_CNTL__AQL_PACKET_SIZE__SHIFT                                                        0x1
#define SDMA0_RLC7_RB_AQL_CNTL__PACKET_STEP__SHIFT                                                            0x8
#define SDMA0_RLC7_RB_AQL_CNTL__MIDCMD_PREEMPT_ENABLE__SHIFT                                                  0x10
#define SDMA0_RLC7_RB_AQL_CNTL__MIDCMD_PREEMPT_DATA_RESTORE__SHIFT                                            0x11
#define SDMA0_RLC7_RB_AQL_CNTL__OVERLAP_ENABLE__SHIFT                                                         0x12
#define SDMA0_RLC7_RB_AQL_CNTL__AQL_ENABLE_MASK                                                               0x00000001L
#define SDMA0_RLC7_RB_AQL_CNTL__AQL_PACKET_SIZE_MASK                                                          0x000000FEL
#define SDMA0_RLC7_RB_AQL_CNTL__PACKET_STEP_MASK                                                              0x0000FF00L
#define SDMA0_RLC7_RB_AQL_CNTL__MIDCMD_PREEMPT_ENABLE_MASK                                                    0x00010000L
#define SDMA0_RLC7_RB_AQL_CNTL__MIDCMD_PREEMPT_DATA_RESTORE_MASK                                              0x00020000L
#define SDMA0_RLC7_RB_AQL_CNTL__OVERLAP_ENABLE_MASK                                                           0x00040000L
//SDMA0_RLC7_MINOR_PTR_UPDATE
#define SDMA0_RLC7_MINOR_PTR_UPDATE__ENABLE__SHIFT                                                            0x0
#define SDMA0_RLC7_MINOR_PTR_UPDATE__ENABLE_MASK                                                              0x00000001L
//SDMA0_RLC7_MIDCMD_DATA0
#define SDMA0_RLC7_MIDCMD_DATA0__DATA0__SHIFT                                                                 0x0
#define SDMA0_RLC7_MIDCMD_DATA0__DATA0_MASK                                                                   0xFFFFFFFFL
//SDMA0_RLC7_MIDCMD_DATA1
#define SDMA0_RLC7_MIDCMD_DATA1__DATA1__SHIFT                                                                 0x0
#define SDMA0_RLC7_MIDCMD_DATA1__DATA1_MASK                                                                   0xFFFFFFFFL
//SDMA0_RLC7_MIDCMD_DATA2
#define SDMA0_RLC7_MIDCMD_DATA2__DATA2__SHIFT                                                                 0x0
#define SDMA0_RLC7_MIDCMD_DATA2__DATA2_MASK                                                                   0xFFFFFFFFL
//SDMA0_RLC7_MIDCMD_DATA3
#define SDMA0_RLC7_MIDCMD_DATA3__DATA3__SHIFT                                                                 0x0
#define SDMA0_RLC7_MIDCMD_DATA3__DATA3_MASK                                                                   0xFFFFFFFFL
//SDMA0_RLC7_MIDCMD_DATA4
#define SDMA0_RLC7_MIDCMD_DATA4__DATA4__SHIFT                                                                 0x0
#define SDMA0_RLC7_MIDCMD_DATA4__DATA4_MASK                                                                   0xFFFFFFFFL
//SDMA0_RLC7_MIDCMD_DATA5
#define SDMA0_RLC7_MIDCMD_DATA5__DATA5__SHIFT                                                                 0x0
#define SDMA0_RLC7_MIDCMD_DATA5__DATA5_MASK                                                                   0xFFFFFFFFL
//SDMA0_RLC7_MIDCMD_DATA6
#define SDMA0_RLC7_MIDCMD_DATA6__DATA6__SHIFT                                                                 0x0
#define SDMA0_RLC7_MIDCMD_DATA6__DATA6_MASK                                                                   0xFFFFFFFFL
//SDMA0_RLC7_MIDCMD_DATA7
#define SDMA0_RLC7_MIDCMD_DATA7__DATA7__SHIFT                                                                 0x0
#define SDMA0_RLC7_MIDCMD_DATA7__DATA7_MASK                                                                   0xFFFFFFFFL
//SDMA0_RLC7_MIDCMD_DATA8
#define SDMA0_RLC7_MIDCMD_DATA8__DATA8__SHIFT                                                                 0x0
#define SDMA0_RLC7_MIDCMD_DATA8__DATA8_MASK                                                                   0xFFFFFFFFL
//SDMA0_RLC7_MIDCMD_DATA9
#define SDMA0_RLC7_MIDCMD_DATA9__DATA9__SHIFT                                                                 0x0
#define SDMA0_RLC7_MIDCMD_DATA9__DATA9_MASK                                                                   0xFFFFFFFFL
//SDMA0_RLC7_MIDCMD_DATA10
#define SDMA0_RLC7_MIDCMD_DATA10__DATA10__SHIFT                                                               0x0
#define SDMA0_RLC7_MIDCMD_DATA10__DATA10_MASK                                                                 0xFFFFFFFFL
//SDMA0_RLC7_MIDCMD_CNTL
#define SDMA0_RLC7_MIDCMD_CNTL__DATA_VALID__SHIFT                                                             0x0
#define SDMA0_RLC7_MIDCMD_CNTL__COPY_MODE__SHIFT                                                              0x1
#define SDMA0_RLC7_MIDCMD_CNTL__SPLIT_STATE__SHIFT                                                            0x4
#define SDMA0_RLC7_MIDCMD_CNTL__ALLOW_PREEMPT__SHIFT                                                          0x8
#define SDMA0_RLC7_MIDCMD_CNTL__DATA_VALID_MASK                                                               0x00000001L
#define SDMA0_RLC7_MIDCMD_CNTL__COPY_MODE_MASK                                                                0x00000002L
#define SDMA0_RLC7_MIDCMD_CNTL__SPLIT_STATE_MASK                                                              0x000000F0L
#define SDMA0_RLC7_MIDCMD_CNTL__ALLOW_PREEMPT_MASK                                                            0x00000100L


// addressBlock: gc_sdma1_sdma1dec
//SDMA1_DEC_START
#define SDMA1_DEC_START__START__SHIFT                                                                         0x0
#define SDMA1_DEC_START__START_MASK                                                                           0xFFFFFFFFL
//SDMA1_GLOBAL_TIMESTAMP_LO
#define SDMA1_GLOBAL_TIMESTAMP_LO__DATA__SHIFT                                                                0x0
#define SDMA1_GLOBAL_TIMESTAMP_LO__DATA_MASK                                                                  0xFFFFFFFFL
//SDMA1_GLOBAL_TIMESTAMP_HI
#define SDMA1_GLOBAL_TIMESTAMP_HI__DATA__SHIFT                                                                0x0
#define SDMA1_GLOBAL_TIMESTAMP_HI__DATA_MASK                                                                  0xFFFFFFFFL
//SDMA1_PG_CNTL
#define SDMA1_PG_CNTL__CMD__SHIFT                                                                             0x0
#define SDMA1_PG_CNTL__STATUS__SHIFT                                                                          0x10
#define SDMA1_PG_CNTL__CMD_MASK                                                                               0x0000000FL
#define SDMA1_PG_CNTL__STATUS_MASK                                                                            0x000F0000L
//SDMA1_PG_CTX_LO
#define SDMA1_PG_CTX_LO__ADDR__SHIFT                                                                          0x0
#define SDMA1_PG_CTX_LO__ADDR_MASK                                                                            0xFFFFFFFFL
//SDMA1_PG_CTX_HI
#define SDMA1_PG_CTX_HI__ADDR__SHIFT                                                                          0x0
#define SDMA1_PG_CTX_HI__ADDR_MASK                                                                            0xFFFFFFFFL
//SDMA1_PG_CTX_CNTL
#define SDMA1_PG_CTX_CNTL__VMID__SHIFT                                                                        0x4
#define SDMA1_PG_CTX_CNTL__VMID_MASK                                                                          0x000000F0L
//SDMA1_POWER_CNTL
#define SDMA1_POWER_CNTL__PG_CNTL_ENABLE__SHIFT                                                               0x0
#define SDMA1_POWER_CNTL__EXT_PG_POWER_ON_REQ__SHIFT                                                          0x1
#define SDMA1_POWER_CNTL__EXT_PG_POWER_OFF_REQ__SHIFT                                                         0x2
#define SDMA1_POWER_CNTL__ON_OFF_CONDITION_HOLD_TIME__SHIFT                                                   0x3
#define SDMA1_POWER_CNTL__MEM_POWER_OVERRIDE__SHIFT                                                           0x8
#define SDMA1_POWER_CNTL__ON_OFF_STATUS_DURATION_TIME__SHIFT                                                  0x1a
#define SDMA1_POWER_CNTL__PG_CNTL_ENABLE_MASK                                                                 0x00000001L
#define SDMA1_POWER_CNTL__EXT_PG_POWER_ON_REQ_MASK                                                            0x00000002L
#define SDMA1_POWER_CNTL__EXT_PG_POWER_OFF_REQ_MASK                                                           0x00000004L
#define SDMA1_POWER_CNTL__ON_OFF_CONDITION_HOLD_TIME_MASK                                                     0x000000F8L
#define SDMA1_POWER_CNTL__MEM_POWER_OVERRIDE_MASK                                                             0x00000100L
#define SDMA1_POWER_CNTL__ON_OFF_STATUS_DURATION_TIME_MASK                                                    0xFC000000L
//SDMA1_CLK_CTRL
#define SDMA1_CLK_CTRL__ON_DELAY__SHIFT                                                                       0x0
#define SDMA1_CLK_CTRL__OFF_HYSTERESIS__SHIFT                                                                 0x4
#define SDMA1_CLK_CTRL__RESERVED_24_12__SHIFT                                                                 0xc
#define SDMA1_CLK_CTRL__CGCG_EN_OVERRIDE__SHIFT                                                               0x19
#define SDMA1_CLK_CTRL__SOFT_OVERRIDE4__SHIFT                                                                 0x1a
#define SDMA1_CLK_CTRL__SOFT_OVERRIDE3__SHIFT                                                                 0x1b
#define SDMA1_CLK_CTRL__SOFT_OVERRIDE2__SHIFT                                                                 0x1c
#define SDMA1_CLK_CTRL__SOFT_OVERRIDE1__SHIFT                                                                 0x1d
#define SDMA1_CLK_CTRL__SOFT_OVERRIDE0__SHIFT                                                                 0x1e
#define SDMA1_CLK_CTRL__SOFT_OVERRIDER_REG__SHIFT                                                             0x1f
#define SDMA1_CLK_CTRL__ON_DELAY_MASK                                                                         0x0000000FL
#define SDMA1_CLK_CTRL__OFF_HYSTERESIS_MASK                                                                   0x00000FF0L
#define SDMA1_CLK_CTRL__RESERVED_24_12_MASK                                                                   0x01FFF000L
#define SDMA1_CLK_CTRL__CGCG_EN_OVERRIDE_MASK                                                                 0x02000000L
#define SDMA1_CLK_CTRL__SOFT_OVERRIDE4_MASK                                                                   0x04000000L
#define SDMA1_CLK_CTRL__SOFT_OVERRIDE3_MASK                                                                   0x08000000L
#define SDMA1_CLK_CTRL__SOFT_OVERRIDE2_MASK                                                                   0x10000000L
#define SDMA1_CLK_CTRL__SOFT_OVERRIDE1_MASK                                                                   0x20000000L
#define SDMA1_CLK_CTRL__SOFT_OVERRIDE0_MASK                                                                   0x40000000L
#define SDMA1_CLK_CTRL__SOFT_OVERRIDER_REG_MASK                                                               0x80000000L
//SDMA1_CNTL
#define SDMA1_CNTL__TRAP_ENABLE__SHIFT                                                                        0x0
#define SDMA1_CNTL__UTC_L1_ENABLE__SHIFT                                                                      0x1
#define SDMA1_CNTL__SEM_WAIT_INT_ENABLE__SHIFT                                                                0x2
#define SDMA1_CNTL__DATA_SWAP_ENABLE__SHIFT                                                                   0x3
#define SDMA1_CNTL__FENCE_SWAP_ENABLE__SHIFT                                                                  0x4
#define SDMA1_CNTL__MIDCMD_PREEMPT_ENABLE__SHIFT                                                              0x5
#define SDMA1_CNTL__PAGE_INT_ENABLE__SHIFT                                                                    0x7
#define SDMA1_CNTL__CH_PERFCNT_ENABLE__SHIFT                                                                  0x10
#define SDMA1_CNTL__MIDCMD_WORLDSWITCH_ENABLE__SHIFT                                                          0x11
#define SDMA1_CNTL__AUTO_CTXSW_ENABLE__SHIFT                                                                  0x12
#define SDMA1_CNTL__CTXEMPTY_INT_ENABLE__SHIFT                                                                0x1c
#define SDMA1_CNTL__FROZEN_INT_ENABLE__SHIFT                                                                  0x1d
#define SDMA1_CNTL__IB_PREEMPT_INT_ENABLE__SHIFT                                                              0x1e
#define SDMA1_CNTL__TRAP_ENABLE_MASK                                                                          0x00000001L
#define SDMA1_CNTL__UTC_L1_ENABLE_MASK                                                                        0x00000002L
#define SDMA1_CNTL__SEM_WAIT_INT_ENABLE_MASK                                                                  0x00000004L
#define SDMA1_CNTL__DATA_SWAP_ENABLE_MASK                                                                     0x00000008L
#define SDMA1_CNTL__FENCE_SWAP_ENABLE_MASK                                                                    0x00000010L
#define SDMA1_CNTL__MIDCMD_PREEMPT_ENABLE_MASK                                                                0x00000020L
#define SDMA1_CNTL__PAGE_INT_ENABLE_MASK                                                                      0x00000080L
#define SDMA1_CNTL__CH_PERFCNT_ENABLE_MASK                                                                    0x00010000L
#define SDMA1_CNTL__MIDCMD_WORLDSWITCH_ENABLE_MASK                                                            0x00020000L
#define SDMA1_CNTL__AUTO_CTXSW_ENABLE_MASK                                                                    0x00040000L
#define SDMA1_CNTL__CTXEMPTY_INT_ENABLE_MASK                                                                  0x10000000L
#define SDMA1_CNTL__FROZEN_INT_ENABLE_MASK                                                                    0x20000000L
#define SDMA1_CNTL__IB_PREEMPT_INT_ENABLE_MASK                                                                0x40000000L
//SDMA1_CHICKEN_BITS
#define SDMA1_CHICKEN_BITS__COPY_EFFICIENCY_ENABLE__SHIFT                                                     0x0
#define SDMA1_CHICKEN_BITS__STALL_ON_TRANS_FULL_ENABLE__SHIFT                                                 0x1
#define SDMA1_CHICKEN_BITS__STALL_ON_NO_FREE_DATA_BUFFER_ENABLE__SHIFT                                        0x2
#define SDMA1_CHICKEN_BITS__SOFT_OVERRIDE_DCGE__SHIFT                                                         0x4
#define SDMA1_CHICKEN_BITS__SOFT_OVERRIDE_SDMA_GRBM_FGCG__SHIFT                                               0x5
#define SDMA1_CHICKEN_BITS__WRITE_BURST_LENGTH__SHIFT                                                         0x8
#define SDMA1_CHICKEN_BITS__WRITE_BURST_WAIT_CYCLE__SHIFT                                                     0xa
#define SDMA1_CHICKEN_BITS__COPY_OVERLAP_ENABLE__SHIFT                                                        0x10
#define SDMA1_CHICKEN_BITS__RAW_CHECK_ENABLE__SHIFT                                                           0x11
#define SDMA1_CHICKEN_BITS__T2L_256B_ENABLE__SHIFT                                                            0x12
#define SDMA1_CHICKEN_BITS__GCR_FGCG_ENABLE__SHIFT                                                            0x13
#define SDMA1_CHICKEN_BITS__SRBM_POLL_RETRYING__SHIFT                                                         0x14
#define SDMA1_CHICKEN_BITS__CH_FGCG_ENABLE__SHIFT                                                             0x15
#define SDMA1_CHICKEN_BITS__UTCL2_INVREQ_FGCG_ENABLE__SHIFT                                                   0x16
#define SDMA1_CHICKEN_BITS__CG_STATUS_OUTPUT__SHIFT                                                           0x17
#define SDMA1_CHICKEN_BITS__UTCL1_FGCG_ENABLE__SHIFT                                                          0x18
#define SDMA1_CHICKEN_BITS__TIME_BASED_QOS__SHIFT                                                             0x19
#define SDMA1_CHICKEN_BITS__CE_AFIFO_WATERMARK__SHIFT                                                         0x1a
#define SDMA1_CHICKEN_BITS__CE_DFIFO_WATERMARK__SHIFT                                                         0x1c
#define SDMA1_CHICKEN_BITS__CE_LFIFO_WATERMARK__SHIFT                                                         0x1e
#define SDMA1_CHICKEN_BITS__COPY_EFFICIENCY_ENABLE_MASK                                                       0x00000001L
#define SDMA1_CHICKEN_BITS__STALL_ON_TRANS_FULL_ENABLE_MASK                                                   0x00000002L
#define SDMA1_CHICKEN_BITS__STALL_ON_NO_FREE_DATA_BUFFER_ENABLE_MASK                                          0x00000004L
#define SDMA1_CHICKEN_BITS__SOFT_OVERRIDE_DCGE_MASK                                                           0x00000010L
#define SDMA1_CHICKEN_BITS__SOFT_OVERRIDE_SDMA_GRBM_FGCG_MASK                                                 0x00000020L
#define SDMA1_CHICKEN_BITS__WRITE_BURST_LENGTH_MASK                                                           0x00000300L
#define SDMA1_CHICKEN_BITS__WRITE_BURST_WAIT_CYCLE_MASK                                                       0x00001C00L
#define SDMA1_CHICKEN_BITS__COPY_OVERLAP_ENABLE_MASK                                                          0x00010000L
#define SDMA1_CHICKEN_BITS__RAW_CHECK_ENABLE_MASK                                                             0x00020000L
#define SDMA1_CHICKEN_BITS__T2L_256B_ENABLE_MASK                                                              0x00040000L
#define SDMA1_CHICKEN_BITS__GCR_FGCG_ENABLE_MASK                                                              0x00080000L
#define SDMA1_CHICKEN_BITS__SRBM_POLL_RETRYING_MASK                                                           0x00100000L
#define SDMA1_CHICKEN_BITS__CH_FGCG_ENABLE_MASK                                                               0x00200000L
#define SDMA1_CHICKEN_BITS__UTCL2_INVREQ_FGCG_ENABLE_MASK                                                     0x00400000L
#define SDMA1_CHICKEN_BITS__CG_STATUS_OUTPUT_MASK                                                             0x00800000L
#define SDMA1_CHICKEN_BITS__UTCL1_FGCG_ENABLE_MASK                                                            0x01000000L
#define SDMA1_CHICKEN_BITS__TIME_BASED_QOS_MASK                                                               0x02000000L
#define SDMA1_CHICKEN_BITS__CE_AFIFO_WATERMARK_MASK                                                           0x0C000000L
#define SDMA1_CHICKEN_BITS__CE_DFIFO_WATERMARK_MASK                                                           0x30000000L
#define SDMA1_CHICKEN_BITS__CE_LFIFO_WATERMARK_MASK                                                           0xC0000000L
//SDMA1_GB_ADDR_CONFIG
#define SDMA1_GB_ADDR_CONFIG__NUM_PIPES__SHIFT                                                                0x0
#define SDMA1_GB_ADDR_CONFIG__PIPE_INTERLEAVE_SIZE__SHIFT                                                     0x3
#define SDMA1_GB_ADDR_CONFIG__MAX_COMPRESSED_FRAGS__SHIFT                                                     0x6
#define SDMA1_GB_ADDR_CONFIG__NUM_PKRS__SHIFT                                                                 0x8
#define SDMA1_GB_ADDR_CONFIG__NUM_SHADER_ENGINES__SHIFT                                                       0x13
#define SDMA1_GB_ADDR_CONFIG__NUM_RB_PER_SE__SHIFT                                                            0x1a
#define SDMA1_GB_ADDR_CONFIG__NUM_PIPES_MASK                                                                  0x00000007L
#define SDMA1_GB_ADDR_CONFIG__PIPE_INTERLEAVE_SIZE_MASK                                                       0x00000038L
#define SDMA1_GB_ADDR_CONFIG__MAX_COMPRESSED_FRAGS_MASK                                                       0x000000C0L
#define SDMA1_GB_ADDR_CONFIG__NUM_PKRS_MASK                                                                   0x00000700L
#define SDMA1_GB_ADDR_CONFIG__NUM_SHADER_ENGINES_MASK                                                         0x00180000L
#define SDMA1_GB_ADDR_CONFIG__NUM_RB_PER_SE_MASK                                                              0x0C000000L
//SDMA1_GB_ADDR_CONFIG_READ
#define SDMA1_GB_ADDR_CONFIG_READ__NUM_PIPES__SHIFT                                                           0x0
#define SDMA1_GB_ADDR_CONFIG_READ__PIPE_INTERLEAVE_SIZE__SHIFT                                                0x3
#define SDMA1_GB_ADDR_CONFIG_READ__MAX_COMPRESSED_FRAGS__SHIFT                                                0x6
#define SDMA1_GB_ADDR_CONFIG_READ__NUM_PKRS__SHIFT                                                            0x8
#define SDMA1_GB_ADDR_CONFIG_READ__NUM_SHADER_ENGINES__SHIFT                                                  0x13
#define SDMA1_GB_ADDR_CONFIG_READ__NUM_RB_PER_SE__SHIFT                                                       0x1a
#define SDMA1_GB_ADDR_CONFIG_READ__NUM_PIPES_MASK                                                             0x00000007L
#define SDMA1_GB_ADDR_CONFIG_READ__PIPE_INTERLEAVE_SIZE_MASK                                                  0x00000038L
#define SDMA1_GB_ADDR_CONFIG_READ__MAX_COMPRESSED_FRAGS_MASK                                                  0x000000C0L
#define SDMA1_GB_ADDR_CONFIG_READ__NUM_PKRS_MASK                                                              0x00000700L
#define SDMA1_GB_ADDR_CONFIG_READ__NUM_SHADER_ENGINES_MASK                                                    0x00180000L
#define SDMA1_GB_ADDR_CONFIG_READ__NUM_RB_PER_SE_MASK                                                         0x0C000000L
//SDMA1_RB_RPTR_FETCH_HI
#define SDMA1_RB_RPTR_FETCH_HI__OFFSET__SHIFT                                                                 0x0
#define SDMA1_RB_RPTR_FETCH_HI__OFFSET_MASK                                                                   0xFFFFFFFFL
//SDMA1_SEM_WAIT_FAIL_TIMER_CNTL
#define SDMA1_SEM_WAIT_FAIL_TIMER_CNTL__TIMER__SHIFT                                                          0x0
#define SDMA1_SEM_WAIT_FAIL_TIMER_CNTL__TIMER_MASK                                                            0xFFFFFFFFL
//SDMA1_RB_RPTR_FETCH
#define SDMA1_RB_RPTR_FETCH__OFFSET__SHIFT                                                                    0x2
#define SDMA1_RB_RPTR_FETCH__OFFSET_MASK                                                                      0xFFFFFFFCL
//SDMA1_IB_OFFSET_FETCH
#define SDMA1_IB_OFFSET_FETCH__OFFSET__SHIFT                                                                  0x2
#define SDMA1_IB_OFFSET_FETCH__OFFSET_MASK                                                                    0x003FFFFCL
//SDMA1_PROGRAM
#define SDMA1_PROGRAM__STREAM__SHIFT                                                                          0x0
#define SDMA1_PROGRAM__STREAM_MASK                                                                            0xFFFFFFFFL
//SDMA1_STATUS_REG
#define SDMA1_STATUS_REG__IDLE__SHIFT                                                                         0x0
#define SDMA1_STATUS_REG__REG_IDLE__SHIFT                                                                     0x1
#define SDMA1_STATUS_REG__RB_EMPTY__SHIFT                                                                     0x2
#define SDMA1_STATUS_REG__RB_FULL__SHIFT                                                                      0x3
#define SDMA1_STATUS_REG__RB_CMD_IDLE__SHIFT                                                                  0x4
#define SDMA1_STATUS_REG__RB_CMD_FULL__SHIFT                                                                  0x5
#define SDMA1_STATUS_REG__IB_CMD_IDLE__SHIFT                                                                  0x6
#define SDMA1_STATUS_REG__IB_CMD_FULL__SHIFT                                                                  0x7
#define SDMA1_STATUS_REG__BLOCK_IDLE__SHIFT                                                                   0x8
#define SDMA1_STATUS_REG__INSIDE_IB__SHIFT                                                                    0x9
#define SDMA1_STATUS_REG__EX_IDLE__SHIFT                                                                      0xa
#define SDMA1_STATUS_REG__EX_IDLE_POLL_TIMER_EXPIRE__SHIFT                                                    0xb
#define SDMA1_STATUS_REG__PACKET_READY__SHIFT                                                                 0xc
#define SDMA1_STATUS_REG__MC_WR_IDLE__SHIFT                                                                   0xd
#define SDMA1_STATUS_REG__SRBM_IDLE__SHIFT                                                                    0xe
#define SDMA1_STATUS_REG__CONTEXT_EMPTY__SHIFT                                                                0xf
#define SDMA1_STATUS_REG__DELTA_RPTR_FULL__SHIFT                                                              0x10
#define SDMA1_STATUS_REG__RB_MC_RREQ_IDLE__SHIFT                                                              0x11
#define SDMA1_STATUS_REG__IB_MC_RREQ_IDLE__SHIFT                                                              0x12
#define SDMA1_STATUS_REG__MC_RD_IDLE__SHIFT                                                                   0x13
#define SDMA1_STATUS_REG__DELTA_RPTR_EMPTY__SHIFT                                                             0x14
#define SDMA1_STATUS_REG__MC_RD_RET_STALL__SHIFT                                                              0x15
#define SDMA1_STATUS_REG__MC_RD_NO_POLL_IDLE__SHIFT                                                           0x16
#define SDMA1_STATUS_REG__PREV_CMD_IDLE__SHIFT                                                                0x19
#define SDMA1_STATUS_REG__SEM_IDLE__SHIFT                                                                     0x1a
#define SDMA1_STATUS_REG__SEM_REQ_STALL__SHIFT                                                                0x1b
#define SDMA1_STATUS_REG__SEM_RESP_STATE__SHIFT                                                               0x1c
#define SDMA1_STATUS_REG__INT_IDLE__SHIFT                                                                     0x1e
#define SDMA1_STATUS_REG__INT_REQ_STALL__SHIFT                                                                0x1f
#define SDMA1_STATUS_REG__IDLE_MASK                                                                           0x00000001L
#define SDMA1_STATUS_REG__REG_IDLE_MASK                                                                       0x00000002L
#define SDMA1_STATUS_REG__RB_EMPTY_MASK                                                                       0x00000004L
#define SDMA1_STATUS_REG__RB_FULL_MASK                                                                        0x00000008L
#define SDMA1_STATUS_REG__RB_CMD_IDLE_MASK                                                                    0x00000010L
#define SDMA1_STATUS_REG__RB_CMD_FULL_MASK                                                                    0x00000020L
#define SDMA1_STATUS_REG__IB_CMD_IDLE_MASK                                                                    0x00000040L
#define SDMA1_STATUS_REG__IB_CMD_FULL_MASK                                                                    0x00000080L
#define SDMA1_STATUS_REG__BLOCK_IDLE_MASK                                                                     0x00000100L
#define SDMA1_STATUS_REG__INSIDE_IB_MASK                                                                      0x00000200L
#define SDMA1_STATUS_REG__EX_IDLE_MASK                                                                        0x00000400L
#define SDMA1_STATUS_REG__EX_IDLE_POLL_TIMER_EXPIRE_MASK                                                      0x00000800L
#define SDMA1_STATUS_REG__PACKET_READY_MASK                                                                   0x00001000L
#define SDMA1_STATUS_REG__MC_WR_IDLE_MASK                                                                     0x00002000L
#define SDMA1_STATUS_REG__SRBM_IDLE_MASK                                                                      0x00004000L
#define SDMA1_STATUS_REG__CONTEXT_EMPTY_MASK                                                                  0x00008000L
#define SDMA1_STATUS_REG__DELTA_RPTR_FULL_MASK                                                                0x00010000L
#define SDMA1_STATUS_REG__RB_MC_RREQ_IDLE_MASK                                                                0x00020000L
#define SDMA1_STATUS_REG__IB_MC_RREQ_IDLE_MASK                                                                0x00040000L
#define SDMA1_STATUS_REG__MC_RD_IDLE_MASK                                                                     0x00080000L
#define SDMA1_STATUS_REG__DELTA_RPTR_EMPTY_MASK                                                               0x00100000L
#define SDMA1_STATUS_REG__MC_RD_RET_STALL_MASK                                                                0x00200000L
#define SDMA1_STATUS_REG__MC_RD_NO_POLL_IDLE_MASK                                                             0x00400000L
#define SDMA1_STATUS_REG__PREV_CMD_IDLE_MASK                                                                  0x02000000L
#define SDMA1_STATUS_REG__SEM_IDLE_MASK                                                                       0x04000000L
#define SDMA1_STATUS_REG__SEM_REQ_STALL_MASK                                                                  0x08000000L
#define SDMA1_STATUS_REG__SEM_RESP_STATE_MASK                                                                 0x30000000L
#define SDMA1_STATUS_REG__INT_IDLE_MASK                                                                       0x40000000L
#define SDMA1_STATUS_REG__INT_REQ_STALL_MASK                                                                  0x80000000L
//SDMA1_STATUS1_REG
#define SDMA1_STATUS1_REG__CE_WREQ_IDLE__SHIFT                                                                0x0
#define SDMA1_STATUS1_REG__CE_WR_IDLE__SHIFT                                                                  0x1
#define SDMA1_STATUS1_REG__CE_SPLIT_IDLE__SHIFT                                                               0x2
#define SDMA1_STATUS1_REG__CE_RREQ_IDLE__SHIFT                                                                0x3
#define SDMA1_STATUS1_REG__CE_OUT_IDLE__SHIFT                                                                 0x4
#define SDMA1_STATUS1_REG__CE_IN_IDLE__SHIFT                                                                  0x5
#define SDMA1_STATUS1_REG__CE_DST_IDLE__SHIFT                                                                 0x6
#define SDMA1_STATUS1_REG__CE_CMD_IDLE__SHIFT                                                                 0x9
#define SDMA1_STATUS1_REG__CE_AFIFO_FULL__SHIFT                                                               0xa
#define SDMA1_STATUS1_REG__CE_INFO_FULL__SHIFT                                                                0xd
#define SDMA1_STATUS1_REG__CE_INFO1_FULL__SHIFT                                                               0xe
#define SDMA1_STATUS1_REG__EX_START__SHIFT                                                                    0xf
#define SDMA1_STATUS1_REG__CE_RD_STALL__SHIFT                                                                 0x11
#define SDMA1_STATUS1_REG__CE_WR_STALL__SHIFT                                                                 0x12
#define SDMA1_STATUS1_REG__CE_WREQ_IDLE_MASK                                                                  0x00000001L
#define SDMA1_STATUS1_REG__CE_WR_IDLE_MASK                                                                    0x00000002L
#define SDMA1_STATUS1_REG__CE_SPLIT_IDLE_MASK                                                                 0x00000004L
#define SDMA1_STATUS1_REG__CE_RREQ_IDLE_MASK                                                                  0x00000008L
#define SDMA1_STATUS1_REG__CE_OUT_IDLE_MASK                                                                   0x00000010L
#define SDMA1_STATUS1_REG__CE_IN_IDLE_MASK                                                                    0x00000020L
#define SDMA1_STATUS1_REG__CE_DST_IDLE_MASK                                                                   0x00000040L
#define SDMA1_STATUS1_REG__CE_CMD_IDLE_MASK                                                                   0x00000200L
#define SDMA1_STATUS1_REG__CE_AFIFO_FULL_MASK                                                                 0x00000400L
#define SDMA1_STATUS1_REG__CE_INFO_FULL_MASK                                                                  0x00002000L
#define SDMA1_STATUS1_REG__CE_INFO1_FULL_MASK                                                                 0x00004000L
#define SDMA1_STATUS1_REG__EX_START_MASK                                                                      0x00008000L
#define SDMA1_STATUS1_REG__CE_RD_STALL_MASK                                                                   0x00020000L
#define SDMA1_STATUS1_REG__CE_WR_STALL_MASK                                                                   0x00040000L
//SDMA1_RD_BURST_CNTL
#define SDMA1_RD_BURST_CNTL__RD_BURST__SHIFT                                                                  0x0
#define SDMA1_RD_BURST_CNTL__RD_BURST_MASK                                                                    0x00000003L
//SDMA1_HBM_PAGE_CONFIG
#define SDMA1_HBM_PAGE_CONFIG__PAGE_SIZE_EXPONENT__SHIFT                                                      0x0
#define SDMA1_HBM_PAGE_CONFIG__PAGE_SIZE_EXPONENT_MASK                                                        0x00000001L
//SDMA1_UCODE_CHECKSUM
#define SDMA1_UCODE_CHECKSUM__DATA__SHIFT                                                                     0x0
#define SDMA1_UCODE_CHECKSUM__DATA_MASK                                                                       0xFFFFFFFFL
//SDMA1_F32_CNTL
#define SDMA1_F32_CNTL__HALT__SHIFT                                                                           0x0
#define SDMA1_F32_CNTL__STEP__SHIFT                                                                           0x1
#define SDMA1_F32_CNTL__CHECKSUM_CLR__SHIFT                                                                   0x8
#define SDMA1_F32_CNTL__RESET__SHIFT                                                                          0x9
#define SDMA1_F32_CNTL__HALT_MASK                                                                             0x00000001L
#define SDMA1_F32_CNTL__STEP_MASK                                                                             0x00000002L
#define SDMA1_F32_CNTL__CHECKSUM_CLR_MASK                                                                     0x00000100L
#define SDMA1_F32_CNTL__RESET_MASK                                                                            0x00000200L
//SDMA1_FREEZE
#define SDMA1_FREEZE__PREEMPT__SHIFT                                                                          0x0
#define SDMA1_FREEZE__FORCE_PREEMPT__SHIFT                                                                    0x1
#define SDMA1_FREEZE__FREEZE__SHIFT                                                                           0x4
#define SDMA1_FREEZE__FROZEN__SHIFT                                                                           0x5
#define SDMA1_FREEZE__F32_FREEZE__SHIFT                                                                       0x6
#define SDMA1_FREEZE__PREEMPT_MASK                                                                            0x00000001L
#define SDMA1_FREEZE__FORCE_PREEMPT_MASK                                                                      0x00000002L
#define SDMA1_FREEZE__FREEZE_MASK                                                                             0x00000010L
#define SDMA1_FREEZE__FROZEN_MASK                                                                             0x00000020L
#define SDMA1_FREEZE__F32_FREEZE_MASK                                                                         0x00000040L
//SDMA1_PHASE0_QUANTUM
#define SDMA1_PHASE0_QUANTUM__UNIT__SHIFT                                                                     0x0
#define SDMA1_PHASE0_QUANTUM__VALUE__SHIFT                                                                    0x8
#define SDMA1_PHASE0_QUANTUM__PREFER__SHIFT                                                                   0x1e
#define SDMA1_PHASE0_QUANTUM__UNIT_MASK                                                                       0x0000000FL
#define SDMA1_PHASE0_QUANTUM__VALUE_MASK                                                                      0x00FFFF00L
#define SDMA1_PHASE0_QUANTUM__PREFER_MASK                                                                     0x40000000L
//SDMA1_PHASE1_QUANTUM
#define SDMA1_PHASE1_QUANTUM__UNIT__SHIFT                                                                     0x0
#define SDMA1_PHASE1_QUANTUM__VALUE__SHIFT                                                                    0x8
#define SDMA1_PHASE1_QUANTUM__PREFER__SHIFT                                                                   0x1e
#define SDMA1_PHASE1_QUANTUM__UNIT_MASK                                                                       0x0000000FL
#define SDMA1_PHASE1_QUANTUM__VALUE_MASK                                                                      0x00FFFF00L
#define SDMA1_PHASE1_QUANTUM__PREFER_MASK                                                                     0x40000000L
//SDMA1_EDC_CONFIG
#define SDMA1_EDC_CONFIG__DIS_EDC__SHIFT                                                                      0x1
#define SDMA1_EDC_CONFIG__ECC_INT_ENABLE__SHIFT                                                               0x2
#define SDMA1_EDC_CONFIG__DIS_EDC_MASK                                                                        0x00000002L
#define SDMA1_EDC_CONFIG__ECC_INT_ENABLE_MASK                                                                 0x00000004L
//SDMA1_BA_THRESHOLD
#define SDMA1_BA_THRESHOLD__READ_THRES__SHIFT                                                                 0x0
#define SDMA1_BA_THRESHOLD__WRITE_THRES__SHIFT                                                                0x10
#define SDMA1_BA_THRESHOLD__READ_THRES_MASK                                                                   0x000003FFL
#define SDMA1_BA_THRESHOLD__WRITE_THRES_MASK                                                                  0x03FF0000L
//SDMA1_ID
#define SDMA1_ID__DEVICE_ID__SHIFT                                                                            0x0
#define SDMA1_ID__DEVICE_ID_MASK                                                                              0x000000FFL
//SDMA1_VERSION
#define SDMA1_VERSION__MINVER__SHIFT                                                                          0x0
#define SDMA1_VERSION__MAJVER__SHIFT                                                                          0x8
#define SDMA1_VERSION__REV__SHIFT                                                                             0x10
#define SDMA1_VERSION__MINVER_MASK                                                                            0x0000007FL
#define SDMA1_VERSION__MAJVER_MASK                                                                            0x00007F00L
#define SDMA1_VERSION__REV_MASK                                                                               0x003F0000L
//SDMA1_EDC_COUNTER
#define SDMA1_EDC_COUNTER__SDMA_UCODE_BUF_DED__SHIFT                                                          0x0
#define SDMA1_EDC_COUNTER__SDMA_UCODE_BUF_SEC__SHIFT                                                          0x1
#define SDMA1_EDC_COUNTER__SDMA_RB_CMD_BUF_SED__SHIFT                                                         0x2
#define SDMA1_EDC_COUNTER__SDMA_IB_CMD_BUF_SED__SHIFT                                                         0x3
#define SDMA1_EDC_COUNTER__SDMA_UTCL1_RD_FIFO_SED__SHIFT                                                      0x4
#define SDMA1_EDC_COUNTER__SDMA_UTCL1_RDBST_FIFO_SED__SHIFT                                                   0x5
#define SDMA1_EDC_COUNTER__SDMA_DATA_LUT_FIFO_SED__SHIFT                                                      0x6
#define SDMA1_EDC_COUNTER__SDMA_MBANK_DATA_BUF0_SED__SHIFT                                                    0x7
#define SDMA1_EDC_COUNTER__SDMA_MBANK_DATA_BUF1_SED__SHIFT                                                    0x8
#define SDMA1_EDC_COUNTER__SDMA_MBANK_DATA_BUF2_SED__SHIFT                                                    0x9
#define SDMA1_EDC_COUNTER__SDMA_MBANK_DATA_BUF3_SED__SHIFT                                                    0xa
#define SDMA1_EDC_COUNTER__SDMA_MBANK_DATA_BUF4_SED__SHIFT                                                    0xb
#define SDMA1_EDC_COUNTER__SDMA_MBANK_DATA_BUF5_SED__SHIFT                                                    0xc
#define SDMA1_EDC_COUNTER__SDMA_MBANK_DATA_BUF6_SED__SHIFT                                                    0xd
#define SDMA1_EDC_COUNTER__SDMA_MBANK_DATA_BUF7_SED__SHIFT                                                    0xe
#define SDMA1_EDC_COUNTER__SDMA_SPLIT_DAT_BUF_SED__SHIFT                                                      0xf
#define SDMA1_EDC_COUNTER__SDMA_MC_WR_ADDR_FIFO_SED__SHIFT                                                    0x10
#define SDMA1_EDC_COUNTER__SDMA_UCODE_BUF_DED_MASK                                                            0x00000001L
#define SDMA1_EDC_COUNTER__SDMA_UCODE_BUF_SEC_MASK                                                            0x00000002L
#define SDMA1_EDC_COUNTER__SDMA_RB_CMD_BUF_SED_MASK                                                           0x00000004L
#define SDMA1_EDC_COUNTER__SDMA_IB_CMD_BUF_SED_MASK                                                           0x00000008L
#define SDMA1_EDC_COUNTER__SDMA_UTCL1_RD_FIFO_SED_MASK                                                        0x00000010L
#define SDMA1_EDC_COUNTER__SDMA_UTCL1_RDBST_FIFO_SED_MASK                                                     0x00000020L
#define SDMA1_EDC_COUNTER__SDMA_DATA_LUT_FIFO_SED_MASK                                                        0x00000040L
#define SDMA1_EDC_COUNTER__SDMA_MBANK_DATA_BUF0_SED_MASK                                                      0x00000080L
#define SDMA1_EDC_COUNTER__SDMA_MBANK_DATA_BUF1_SED_MASK                                                      0x00000100L
#define SDMA1_EDC_COUNTER__SDMA_MBANK_DATA_BUF2_SED_MASK                                                      0x00000200L
#define SDMA1_EDC_COUNTER__SDMA_MBANK_DATA_BUF3_SED_MASK                                                      0x00000400L
#define SDMA1_EDC_COUNTER__SDMA_MBANK_DATA_BUF4_SED_MASK                                                      0x00000800L
#define SDMA1_EDC_COUNTER__SDMA_MBANK_DATA_BUF5_SED_MASK                                                      0x00001000L
#define SDMA1_EDC_COUNTER__SDMA_MBANK_DATA_BUF6_SED_MASK                                                      0x00002000L
#define SDMA1_EDC_COUNTER__SDMA_MBANK_DATA_BUF7_SED_MASK                                                      0x00004000L
#define SDMA1_EDC_COUNTER__SDMA_SPLIT_DAT_BUF_SED_MASK                                                        0x00008000L
#define SDMA1_EDC_COUNTER__SDMA_MC_WR_ADDR_FIFO_SED_MASK                                                      0x00010000L
//SDMA1_EDC_COUNTER_CLEAR
#define SDMA1_EDC_COUNTER_CLEAR__DUMMY__SHIFT                                                                 0x0
#define SDMA1_EDC_COUNTER_CLEAR__DUMMY_MASK                                                                   0x00000001L
//SDMA1_STATUS2_REG
#define SDMA1_STATUS2_REG__ID__SHIFT                                                                          0x0
#define SDMA1_STATUS2_REG__F32_INSTR_PTR__SHIFT                                                               0x2
#define SDMA1_STATUS2_REG__CMD_OP__SHIFT                                                                      0x10
#define SDMA1_STATUS2_REG__ID_MASK                                                                            0x00000003L
#define SDMA1_STATUS2_REG__F32_INSTR_PTR_MASK                                                                 0x0000FFFCL
#define SDMA1_STATUS2_REG__CMD_OP_MASK                                                                        0xFFFF0000L
//SDMA1_ATOMIC_CNTL
#define SDMA1_ATOMIC_CNTL__LOOP_TIMER__SHIFT                                                                  0x0
#define SDMA1_ATOMIC_CNTL__ATOMIC_RTN_INT_ENABLE__SHIFT                                                       0x1f
#define SDMA1_ATOMIC_CNTL__LOOP_TIMER_MASK                                                                    0x7FFFFFFFL
#define SDMA1_ATOMIC_CNTL__ATOMIC_RTN_INT_ENABLE_MASK                                                         0x80000000L
//SDMA1_ATOMIC_PREOP_LO
#define SDMA1_ATOMIC_PREOP_LO__DATA__SHIFT                                                                    0x0
#define SDMA1_ATOMIC_PREOP_LO__DATA_MASK                                                                      0xFFFFFFFFL
//SDMA1_ATOMIC_PREOP_HI
#define SDMA1_ATOMIC_PREOP_HI__DATA__SHIFT                                                                    0x0
#define SDMA1_ATOMIC_PREOP_HI__DATA_MASK                                                                      0xFFFFFFFFL
//SDMA1_UTCL1_CNTL
#define SDMA1_UTCL1_CNTL__REDO_ENABLE__SHIFT                                                                  0x0
#define SDMA1_UTCL1_CNTL__REDO_DELAY__SHIFT                                                                   0x1
#define SDMA1_UTCL1_CNTL__REDO_WATERMK__SHIFT                                                                 0x6
#define SDMA1_UTCL1_CNTL__RESP_MODE__SHIFT                                                                    0x9
#define SDMA1_UTCL1_CNTL__FORCE_INVALIDATION__SHIFT                                                           0xe
#define SDMA1_UTCL1_CNTL__FORCE_INVREQ_HEAVY__SHIFT                                                           0xf
#define SDMA1_UTCL1_CNTL__INVACK_DELAY__SHIFT                                                                 0x10
#define SDMA1_UTCL1_CNTL__REQL2_CREDIT__SHIFT                                                                 0x18
#define SDMA1_UTCL1_CNTL__VADDR_WATERMK__SHIFT                                                                0x1d
#define SDMA1_UTCL1_CNTL__REDO_ENABLE_MASK                                                                    0x00000001L
#define SDMA1_UTCL1_CNTL__REDO_DELAY_MASK                                                                     0x0000003EL
#define SDMA1_UTCL1_CNTL__REDO_WATERMK_MASK                                                                   0x000001C0L
#define SDMA1_UTCL1_CNTL__RESP_MODE_MASK                                                                      0x00000E00L
#define SDMA1_UTCL1_CNTL__FORCE_INVALIDATION_MASK                                                             0x00004000L
#define SDMA1_UTCL1_CNTL__FORCE_INVREQ_HEAVY_MASK                                                             0x00008000L
#define SDMA1_UTCL1_CNTL__INVACK_DELAY_MASK                                                                   0x00FF0000L
#define SDMA1_UTCL1_CNTL__REQL2_CREDIT_MASK                                                                   0x1F000000L
#define SDMA1_UTCL1_CNTL__VADDR_WATERMK_MASK                                                                  0xE0000000L
//SDMA1_UTCL1_WATERMK
#define SDMA1_UTCL1_WATERMK__REQMC_WATERMK__SHIFT                                                             0x0
#define SDMA1_UTCL1_WATERMK__REQPG_WATERMK__SHIFT                                                             0xa
#define SDMA1_UTCL1_WATERMK__INVREQ_WATERMK__SHIFT                                                            0x12
#define SDMA1_UTCL1_WATERMK__XNACK_WATERMK__SHIFT                                                             0x1a
#define SDMA1_UTCL1_WATERMK__REQMC_WATERMK_MASK                                                               0x000003FFL
#define SDMA1_UTCL1_WATERMK__REQPG_WATERMK_MASK                                                               0x0003FC00L
#define SDMA1_UTCL1_WATERMK__INVREQ_WATERMK_MASK                                                              0x03FC0000L
#define SDMA1_UTCL1_WATERMK__XNACK_WATERMK_MASK                                                               0xFC000000L
//SDMA1_UTCL1_RD_STATUS
#define SDMA1_UTCL1_RD_STATUS__RQMC_RET_ADDR_FIFO_EMPTY__SHIFT                                                0x0
#define SDMA1_UTCL1_RD_STATUS__RQMC_RET_ADDR_FIFO_FULL__SHIFT                                                 0x1
#define SDMA1_UTCL1_RD_STATUS__RQMC_REQ_FIFO_EMPTY__SHIFT                                                     0x2
#define SDMA1_UTCL1_RD_STATUS__RQMC_REQ_FIFO_FULL__SHIFT                                                      0x3
#define SDMA1_UTCL1_RD_STATUS__RTPG_RET_BUF_EMPTY__SHIFT                                                      0x4
#define SDMA1_UTCL1_RD_STATUS__RTPG_RET_BUF_FULL__SHIFT                                                       0x5
#define SDMA1_UTCL1_RD_STATUS__RTPG_VADDR_FIFO_EMPTY__SHIFT                                                   0x6
#define SDMA1_UTCL1_RD_STATUS__RTPG_VADDR_FIFO_FULL__SHIFT                                                    0x7
#define SDMA1_UTCL1_RD_STATUS__RQPG_REDO_FIFO_EMPTY__SHIFT                                                    0x8
#define SDMA1_UTCL1_RD_STATUS__RQPG_REDO_FIFO_FULL__SHIFT                                                     0x9
#define SDMA1_UTCL1_RD_STATUS__RQPG_REQPAGE_FIFO_EMPTY__SHIFT                                                 0xa
#define SDMA1_UTCL1_RD_STATUS__RQPG_REQPAGE_FIFO_FULL__SHIFT                                                  0xb
#define SDMA1_UTCL1_RD_STATUS__REDO_ARR_EMPTY__SHIFT                                                          0xc
#define SDMA1_UTCL1_RD_STATUS__REDO_ARR_FULL__SHIFT                                                           0xd
#define SDMA1_UTCL1_RD_STATUS__PAGE_FAULT__SHIFT                                                              0xe
#define SDMA1_UTCL1_RD_STATUS__PAGE_NULL__SHIFT                                                               0xf
#define SDMA1_UTCL1_RD_STATUS__REQL2_IDLE__SHIFT                                                              0x10
#define SDMA1_UTCL1_RD_STATUS__NEXT_RD_VECTOR__SHIFT                                                          0x11
#define SDMA1_UTCL1_RD_STATUS__MERGE_STATE__SHIFT                                                             0x15
#define SDMA1_UTCL1_RD_STATUS__ADDR_RD_RTR__SHIFT                                                             0x18
#define SDMA1_UTCL1_RD_STATUS__RD_XNACK_TIMEOUT__SHIFT                                                        0x19
#define SDMA1_UTCL1_RD_STATUS__PAGE_NULL_SW__SHIFT                                                            0x1a
#define SDMA1_UTCL1_RD_STATUS__HIT_CACHE__SHIFT                                                               0x1b
#define SDMA1_UTCL1_RD_STATUS__RD_DCC_ENABLE__SHIFT                                                           0x1c
#define SDMA1_UTCL1_RD_STATUS__NACK_TIMEOUT_SW__SHIFT                                                         0x1d
#define SDMA1_UTCL1_RD_STATUS__DCC_PAGE_FAULT__SHIFT                                                          0x1e
#define SDMA1_UTCL1_RD_STATUS__DCC_PAGE_NULL__SHIFT                                                           0x1f
#define SDMA1_UTCL1_RD_STATUS__RQMC_RET_ADDR_FIFO_EMPTY_MASK                                                  0x00000001L
#define SDMA1_UTCL1_RD_STATUS__RQMC_RET_ADDR_FIFO_FULL_MASK                                                   0x00000002L
#define SDMA1_UTCL1_RD_STATUS__RQMC_REQ_FIFO_EMPTY_MASK                                                       0x00000004L
#define SDMA1_UTCL1_RD_STATUS__RQMC_REQ_FIFO_FULL_MASK                                                        0x00000008L
#define SDMA1_UTCL1_RD_STATUS__RTPG_RET_BUF_EMPTY_MASK                                                        0x00000010L
#define SDMA1_UTCL1_RD_STATUS__RTPG_RET_BUF_FULL_MASK                                                         0x00000020L
#define SDMA1_UTCL1_RD_STATUS__RTPG_VADDR_FIFO_EMPTY_MASK                                                     0x00000040L
#define SDMA1_UTCL1_RD_STATUS__RTPG_VADDR_FIFO_FULL_MASK                                                      0x00000080L
#define SDMA1_UTCL1_RD_STATUS__RQPG_REDO_FIFO_EMPTY_MASK                                                      0x00000100L
#define SDMA1_UTCL1_RD_STATUS__RQPG_REDO_FIFO_FULL_MASK                                                       0x00000200L
#define SDMA1_UTCL1_RD_STATUS__RQPG_REQPAGE_FIFO_EMPTY_MASK                                                   0x00000400L
#define SDMA1_UTCL1_RD_STATUS__RQPG_REQPAGE_FIFO_FULL_MASK                                                    0x00000800L
#define SDMA1_UTCL1_RD_STATUS__REDO_ARR_EMPTY_MASK                                                            0x00001000L
#define SDMA1_UTCL1_RD_STATUS__REDO_ARR_FULL_MASK                                                             0x00002000L
#define SDMA1_UTCL1_RD_STATUS__PAGE_FAULT_MASK                                                                0x00004000L
#define SDMA1_UTCL1_RD_STATUS__PAGE_NULL_MASK                                                                 0x00008000L
#define SDMA1_UTCL1_RD_STATUS__REQL2_IDLE_MASK                                                                0x00010000L
#define SDMA1_UTCL1_RD_STATUS__NEXT_RD_VECTOR_MASK                                                            0x001E0000L
#define SDMA1_UTCL1_RD_STATUS__MERGE_STATE_MASK                                                               0x00E00000L
#define SDMA1_UTCL1_RD_STATUS__ADDR_RD_RTR_MASK                                                               0x01000000L
#define SDMA1_UTCL1_RD_STATUS__RD_XNACK_TIMEOUT_MASK                                                          0x02000000L
#define SDMA1_UTCL1_RD_STATUS__PAGE_NULL_SW_MASK                                                              0x04000000L
#define SDMA1_UTCL1_RD_STATUS__HIT_CACHE_MASK                                                                 0x08000000L
#define SDMA1_UTCL1_RD_STATUS__RD_DCC_ENABLE_MASK                                                             0x10000000L
#define SDMA1_UTCL1_RD_STATUS__NACK_TIMEOUT_SW_MASK                                                           0x20000000L
#define SDMA1_UTCL1_RD_STATUS__DCC_PAGE_FAULT_MASK                                                            0x40000000L
#define SDMA1_UTCL1_RD_STATUS__DCC_PAGE_NULL_MASK                                                             0x80000000L
//SDMA1_UTCL1_WR_STATUS
#define SDMA1_UTCL1_WR_STATUS__RQMC_RET_ADDR_FIFO_EMPTY__SHIFT                                                0x0
#define SDMA1_UTCL1_WR_STATUS__RQMC_RET_ADDR_FIFO_FULL__SHIFT                                                 0x1
#define SDMA1_UTCL1_WR_STATUS__RQMC_REQ_FIFO_EMPTY__SHIFT                                                     0x2
#define SDMA1_UTCL1_WR_STATUS__RQMC_REQ_FIFO_FULL__SHIFT                                                      0x3
#define SDMA1_UTCL1_WR_STATUS__RTPG_RET_BUF_EMPTY__SHIFT                                                      0x4
#define SDMA1_UTCL1_WR_STATUS__RTPG_RET_BUF_FULL__SHIFT                                                       0x5
#define SDMA1_UTCL1_WR_STATUS__RTPG_VADDR_FIFO_EMPTY__SHIFT                                                   0x6
#define SDMA1_UTCL1_WR_STATUS__RTPG_VADDR_FIFO_FULL__SHIFT                                                    0x7
#define SDMA1_UTCL1_WR_STATUS__RQPG_REDO_FIFO_EMPTY__SHIFT                                                    0x8
#define SDMA1_UTCL1_WR_STATUS__RQPG_REDO_FIFO_FULL__SHIFT                                                     0x9
#define SDMA1_UTCL1_WR_STATUS__RQPG_REQPAGE_FIFO_EMPTY__SHIFT                                                 0xa
#define SDMA1_UTCL1_WR_STATUS__RQPG_REQPAGE_FIFO_FULL__SHIFT                                                  0xb
#define SDMA1_UTCL1_WR_STATUS__REDO_ARR_EMPTY__SHIFT                                                          0xc
#define SDMA1_UTCL1_WR_STATUS__REDO_ARR_FULL__SHIFT                                                           0xd
#define SDMA1_UTCL1_WR_STATUS__PAGE_FAULT__SHIFT                                                              0xe
#define SDMA1_UTCL1_WR_STATUS__PAGE_NULL__SHIFT                                                               0xf
#define SDMA1_UTCL1_WR_STATUS__REQL2_IDLE__SHIFT                                                              0x10
#define SDMA1_UTCL1_WR_STATUS__NEXT_WR_VECTOR__SHIFT                                                          0x11
#define SDMA1_UTCL1_WR_STATUS__MERGE_STATE__SHIFT                                                             0x15
#define SDMA1_UTCL1_WR_STATUS__F32_WR_RTR__SHIFT                                                              0x18
#define SDMA1_UTCL1_WR_STATUS__WR_XNACK_TIMEOUT__SHIFT                                                        0x19
#define SDMA1_UTCL1_WR_STATUS__PAGE_NULL_SW__SHIFT                                                            0x1a
#define SDMA1_UTCL1_WR_STATUS__ATOMIC_OP__SHIFT                                                               0x1b
#define SDMA1_UTCL1_WR_STATUS__RPTR_DATA_FIFO_EMPTY__SHIFT                                                    0x1c
#define SDMA1_UTCL1_WR_STATUS__RPTR_DATA_FIFO_FULL__SHIFT                                                     0x1d
#define SDMA1_UTCL1_WR_STATUS__WRREQ_DATA_FIFO_EMPTY__SHIFT                                                   0x1e
#define SDMA1_UTCL1_WR_STATUS__WRREQ_DATA_FIFO_FULL__SHIFT                                                    0x1f
#define SDMA1_UTCL1_WR_STATUS__RQMC_RET_ADDR_FIFO_EMPTY_MASK                                                  0x00000001L
#define SDMA1_UTCL1_WR_STATUS__RQMC_RET_ADDR_FIFO_FULL_MASK                                                   0x00000002L
#define SDMA1_UTCL1_WR_STATUS__RQMC_REQ_FIFO_EMPTY_MASK                                                       0x00000004L
#define SDMA1_UTCL1_WR_STATUS__RQMC_REQ_FIFO_FULL_MASK                                                        0x00000008L
#define SDMA1_UTCL1_WR_STATUS__RTPG_RET_BUF_EMPTY_MASK                                                        0x00000010L
#define SDMA1_UTCL1_WR_STATUS__RTPG_RET_BUF_FULL_MASK                                                         0x00000020L
#define SDMA1_UTCL1_WR_STATUS__RTPG_VADDR_FIFO_EMPTY_MASK                                                     0x00000040L
#define SDMA1_UTCL1_WR_STATUS__RTPG_VADDR_FIFO_FULL_MASK                                                      0x00000080L
#define SDMA1_UTCL1_WR_STATUS__RQPG_REDO_FIFO_EMPTY_MASK                                                      0x00000100L
#define SDMA1_UTCL1_WR_STATUS__RQPG_REDO_FIFO_FULL_MASK                                                       0x00000200L
#define SDMA1_UTCL1_WR_STATUS__RQPG_REQPAGE_FIFO_EMPTY_MASK                                                   0x00000400L
#define SDMA1_UTCL1_WR_STATUS__RQPG_REQPAGE_FIFO_FULL_MASK                                                    0x00000800L
#define SDMA1_UTCL1_WR_STATUS__REDO_ARR_EMPTY_MASK                                                            0x00001000L
#define SDMA1_UTCL1_WR_STATUS__REDO_ARR_FULL_MASK                                                             0x00002000L
#define SDMA1_UTCL1_WR_STATUS__PAGE_FAULT_MASK                                                                0x00004000L
#define SDMA1_UTCL1_WR_STATUS__PAGE_NULL_MASK                                                                 0x00008000L
#define SDMA1_UTCL1_WR_STATUS__REQL2_IDLE_MASK                                                                0x00010000L
#define SDMA1_UTCL1_WR_STATUS__NEXT_WR_VECTOR_MASK                                                            0x001E0000L
#define SDMA1_UTCL1_WR_STATUS__MERGE_STATE_MASK                                                               0x00E00000L
#define SDMA1_UTCL1_WR_STATUS__F32_WR_RTR_MASK                                                                0x01000000L
#define SDMA1_UTCL1_WR_STATUS__WR_XNACK_TIMEOUT_MASK                                                          0x02000000L
#define SDMA1_UTCL1_WR_STATUS__PAGE_NULL_SW_MASK                                                              0x04000000L
#define SDMA1_UTCL1_WR_STATUS__ATOMIC_OP_MASK                                                                 0x08000000L
#define SDMA1_UTCL1_WR_STATUS__RPTR_DATA_FIFO_EMPTY_MASK                                                      0x10000000L
#define SDMA1_UTCL1_WR_STATUS__RPTR_DATA_FIFO_FULL_MASK                                                       0x20000000L
#define SDMA1_UTCL1_WR_STATUS__WRREQ_DATA_FIFO_EMPTY_MASK                                                     0x40000000L
#define SDMA1_UTCL1_WR_STATUS__WRREQ_DATA_FIFO_FULL_MASK                                                      0x80000000L
//SDMA1_UTCL1_INV0
#define SDMA1_UTCL1_INV0__CPF_INVREQ_EN__SHIFT                                                                0x0
#define SDMA1_UTCL1_INV0__GPUVM_INVREQ_EN__SHIFT                                                              0x1
#define SDMA1_UTCL1_INV0__CPF_GPA_INVREQ__SHIFT                                                               0x2
#define SDMA1_UTCL1_INV0__GPUVM_INVREQ_LOW__SHIFT                                                             0x3
#define SDMA1_UTCL1_INV0__GPUVM_INVREQ_HIGH__SHIFT                                                            0x4
#define SDMA1_UTCL1_INV0__INVREQ_SIZE__SHIFT                                                                  0x5
#define SDMA1_UTCL1_INV0__INVREQ_IDLE__SHIFT                                                                  0xb
#define SDMA1_UTCL1_INV0__VMINV_PEND_CNT__SHIFT                                                               0xc
#define SDMA1_UTCL1_INV0__GPUVM_LO_INV_VMID__SHIFT                                                            0x10
#define SDMA1_UTCL1_INV0__GPUVM_HI_INV_VMID__SHIFT                                                            0x14
#define SDMA1_UTCL1_INV0__GPUVM_INV_MODE__SHIFT                                                               0x18
#define SDMA1_UTCL1_INV0__INVREQ_IS_HEAVY__SHIFT                                                              0x1a
#define SDMA1_UTCL1_INV0__INVREQ_FROM_CPF__SHIFT                                                              0x1b
#define SDMA1_UTCL1_INV0__GPUVM_INVREQ_TAG__SHIFT                                                             0x1c
#define SDMA1_UTCL1_INV0__CPF_INVREQ_EN_MASK                                                                  0x00000001L
#define SDMA1_UTCL1_INV0__GPUVM_INVREQ_EN_MASK                                                                0x00000002L
#define SDMA1_UTCL1_INV0__CPF_GPA_INVREQ_MASK                                                                 0x00000004L
#define SDMA1_UTCL1_INV0__GPUVM_INVREQ_LOW_MASK                                                               0x00000008L
#define SDMA1_UTCL1_INV0__GPUVM_INVREQ_HIGH_MASK                                                              0x00000010L
#define SDMA1_UTCL1_INV0__INVREQ_SIZE_MASK                                                                    0x000007E0L
#define SDMA1_UTCL1_INV0__INVREQ_IDLE_MASK                                                                    0x00000800L
#define SDMA1_UTCL1_INV0__VMINV_PEND_CNT_MASK                                                                 0x0000F000L
#define SDMA1_UTCL1_INV0__GPUVM_LO_INV_VMID_MASK                                                              0x000F0000L
#define SDMA1_UTCL1_INV0__GPUVM_HI_INV_VMID_MASK                                                              0x00F00000L
#define SDMA1_UTCL1_INV0__GPUVM_INV_MODE_MASK                                                                 0x03000000L
#define SDMA1_UTCL1_INV0__INVREQ_IS_HEAVY_MASK                                                                0x04000000L
#define SDMA1_UTCL1_INV0__INVREQ_FROM_CPF_MASK                                                                0x08000000L
#define SDMA1_UTCL1_INV0__GPUVM_INVREQ_TAG_MASK                                                               0xF0000000L
//SDMA1_UTCL1_INV1
#define SDMA1_UTCL1_INV1__INV_ADDR_LO__SHIFT                                                                  0x0
#define SDMA1_UTCL1_INV1__INV_ADDR_LO_MASK                                                                    0xFFFFFFFFL
//SDMA1_UTCL1_INV2
#define SDMA1_UTCL1_INV2__INV_VMID_VEC__SHIFT                                                                 0x0
#define SDMA1_UTCL1_INV2__RESERVED__SHIFT                                                                     0x10
#define SDMA1_UTCL1_INV2__INV_VMID_VEC_MASK                                                                   0x0000FFFFL
#define SDMA1_UTCL1_INV2__RESERVED_MASK                                                                       0xFFFF0000L
//SDMA1_UTCL1_RD_XNACK0
#define SDMA1_UTCL1_RD_XNACK0__XNACK_ADDR_LO__SHIFT                                                           0x0
#define SDMA1_UTCL1_RD_XNACK0__XNACK_ADDR_LO_MASK                                                             0xFFFFFFFFL
//SDMA1_UTCL1_RD_XNACK1
#define SDMA1_UTCL1_RD_XNACK1__XNACK_ADDR_HI__SHIFT                                                           0x0
#define SDMA1_UTCL1_RD_XNACK1__XNACK_VMID__SHIFT                                                              0x4
#define SDMA1_UTCL1_RD_XNACK1__XNACK_VECTOR__SHIFT                                                            0x8
#define SDMA1_UTCL1_RD_XNACK1__IS_XNACK__SHIFT                                                                0x1a
#define SDMA1_UTCL1_RD_XNACK1__XNACK_ADDR_HI_MASK                                                             0x0000000FL
#define SDMA1_UTCL1_RD_XNACK1__XNACK_VMID_MASK                                                                0x000000F0L
#define SDMA1_UTCL1_RD_XNACK1__XNACK_VECTOR_MASK                                                              0x03FFFF00L
#define SDMA1_UTCL1_RD_XNACK1__IS_XNACK_MASK                                                                  0x0C000000L
//SDMA1_UTCL1_WR_XNACK0
#define SDMA1_UTCL1_WR_XNACK0__XNACK_ADDR_LO__SHIFT                                                           0x0
#define SDMA1_UTCL1_WR_XNACK0__XNACK_ADDR_LO_MASK                                                             0xFFFFFFFFL
//SDMA1_UTCL1_WR_XNACK1
#define SDMA1_UTCL1_WR_XNACK1__XNACK_ADDR_HI__SHIFT                                                           0x0
#define SDMA1_UTCL1_WR_XNACK1__XNACK_VMID__SHIFT                                                              0x4
#define SDMA1_UTCL1_WR_XNACK1__XNACK_VECTOR__SHIFT                                                            0x8
#define SDMA1_UTCL1_WR_XNACK1__IS_XNACK__SHIFT                                                                0x1a
#define SDMA1_UTCL1_WR_XNACK1__XNACK_ADDR_HI_MASK                                                             0x0000000FL
#define SDMA1_UTCL1_WR_XNACK1__XNACK_VMID_MASK                                                                0x000000F0L
#define SDMA1_UTCL1_WR_XNACK1__XNACK_VECTOR_MASK                                                              0x03FFFF00L
#define SDMA1_UTCL1_WR_XNACK1__IS_XNACK_MASK                                                                  0x0C000000L
//SDMA1_UTCL1_TIMEOUT
#define SDMA1_UTCL1_TIMEOUT__RD_XNACK_LIMIT__SHIFT                                                            0x0
#define SDMA1_UTCL1_TIMEOUT__WR_XNACK_LIMIT__SHIFT                                                            0x10
#define SDMA1_UTCL1_TIMEOUT__RD_XNACK_LIMIT_MASK                                                              0x0000FFFFL
#define SDMA1_UTCL1_TIMEOUT__WR_XNACK_LIMIT_MASK                                                              0xFFFF0000L
//SDMA1_UTCL1_PAGE
#define SDMA1_UTCL1_PAGE__VM_HOLE__SHIFT                                                                      0x0
#define SDMA1_UTCL1_PAGE__REQ_TYPE__SHIFT                                                                     0x1
#define SDMA1_UTCL1_PAGE__USE_MTYPE__SHIFT                                                                    0x6
#define SDMA1_UTCL1_PAGE__USE_PT_SNOOP__SHIFT                                                                 0xa
#define SDMA1_UTCL1_PAGE__USE_IO__SHIFT                                                                       0xb
#define SDMA1_UTCL1_PAGE__RD_L2_POLICY__SHIFT                                                                 0xc
#define SDMA1_UTCL1_PAGE__WR_L2_POLICY__SHIFT                                                                 0xe
#define SDMA1_UTCL1_PAGE__DMA_PAGE_SIZE__SHIFT                                                                0x10
#define SDMA1_UTCL1_PAGE__USE_BC__SHIFT                                                                       0x16
#define SDMA1_UTCL1_PAGE__ADDR_IS_PA__SHIFT                                                                   0x17
#define SDMA1_UTCL1_PAGE__LLC_NOALLOC__SHIFT                                                                  0x18
#define SDMA1_UTCL1_PAGE__VM_HOLE_MASK                                                                        0x00000001L
#define SDMA1_UTCL1_PAGE__REQ_TYPE_MASK                                                                       0x0000001EL
#define SDMA1_UTCL1_PAGE__USE_MTYPE_MASK                                                                      0x000003C0L
#define SDMA1_UTCL1_PAGE__USE_PT_SNOOP_MASK                                                                   0x00000400L
#define SDMA1_UTCL1_PAGE__USE_IO_MASK                                                                         0x00000800L
#define SDMA1_UTCL1_PAGE__RD_L2_POLICY_MASK                                                                   0x00003000L
#define SDMA1_UTCL1_PAGE__WR_L2_POLICY_MASK                                                                   0x0000C000L
#define SDMA1_UTCL1_PAGE__DMA_PAGE_SIZE_MASK                                                                  0x003F0000L
#define SDMA1_UTCL1_PAGE__USE_BC_MASK                                                                         0x00400000L
#define SDMA1_UTCL1_PAGE__ADDR_IS_PA_MASK                                                                     0x00800000L
#define SDMA1_UTCL1_PAGE__LLC_NOALLOC_MASK                                                                    0x01000000L
//SDMA1_RELAX_ORDERING_LUT
#define SDMA1_RELAX_ORDERING_LUT__RESERVED0__SHIFT                                                            0x0
#define SDMA1_RELAX_ORDERING_LUT__COPY__SHIFT                                                                 0x1
#define SDMA1_RELAX_ORDERING_LUT__WRITE__SHIFT                                                                0x2
#define SDMA1_RELAX_ORDERING_LUT__RESERVED3__SHIFT                                                            0x3
#define SDMA1_RELAX_ORDERING_LUT__RESERVED4__SHIFT                                                            0x4
#define SDMA1_RELAX_ORDERING_LUT__FENCE__SHIFT                                                                0x5
#define SDMA1_RELAX_ORDERING_LUT__RESERVED76__SHIFT                                                           0x6
#define SDMA1_RELAX_ORDERING_LUT__POLL_MEM__SHIFT                                                             0x8
#define SDMA1_RELAX_ORDERING_LUT__COND_EXE__SHIFT                                                             0x9
#define SDMA1_RELAX_ORDERING_LUT__ATOMIC__SHIFT                                                               0xa
#define SDMA1_RELAX_ORDERING_LUT__CONST_FILL__SHIFT                                                           0xb
#define SDMA1_RELAX_ORDERING_LUT__PTEPDE__SHIFT                                                               0xc
#define SDMA1_RELAX_ORDERING_LUT__TIMESTAMP__SHIFT                                                            0xd
#define SDMA1_RELAX_ORDERING_LUT__RESERVED__SHIFT                                                             0xe
#define SDMA1_RELAX_ORDERING_LUT__WORLD_SWITCH__SHIFT                                                         0x1b
#define SDMA1_RELAX_ORDERING_LUT__RPTR_WRB__SHIFT                                                             0x1c
#define SDMA1_RELAX_ORDERING_LUT__WPTR_POLL__SHIFT                                                            0x1d
#define SDMA1_RELAX_ORDERING_LUT__IB_FETCH__SHIFT                                                             0x1e
#define SDMA1_RELAX_ORDERING_LUT__RB_FETCH__SHIFT                                                             0x1f
#define SDMA1_RELAX_ORDERING_LUT__RESERVED0_MASK                                                              0x00000001L
#define SDMA1_RELAX_ORDERING_LUT__COPY_MASK                                                                   0x00000002L
#define SDMA1_RELAX_ORDERING_LUT__WRITE_MASK                                                                  0x00000004L
#define SDMA1_RELAX_ORDERING_LUT__RESERVED3_MASK                                                              0x00000008L
#define SDMA1_RELAX_ORDERING_LUT__RESERVED4_MASK                                                              0x00000010L
#define SDMA1_RELAX_ORDERING_LUT__FENCE_MASK                                                                  0x00000020L
#define SDMA1_RELAX_ORDERING_LUT__RESERVED76_MASK                                                             0x000000C0L
#define SDMA1_RELAX_ORDERING_LUT__POLL_MEM_MASK                                                               0x00000100L
#define SDMA1_RELAX_ORDERING_LUT__COND_EXE_MASK                                                               0x00000200L
#define SDMA1_RELAX_ORDERING_LUT__ATOMIC_MASK                                                                 0x00000400L
#define SDMA1_RELAX_ORDERING_LUT__CONST_FILL_MASK                                                             0x00000800L
#define SDMA1_RELAX_ORDERING_LUT__PTEPDE_MASK                                                                 0x00001000L
#define SDMA1_RELAX_ORDERING_LUT__TIMESTAMP_MASK                                                              0x00002000L
#define SDMA1_RELAX_ORDERING_LUT__RESERVED_MASK                                                               0x07FFC000L
#define SDMA1_RELAX_ORDERING_LUT__WORLD_SWITCH_MASK                                                           0x08000000L
#define SDMA1_RELAX_ORDERING_LUT__RPTR_WRB_MASK                                                               0x10000000L
#define SDMA1_RELAX_ORDERING_LUT__WPTR_POLL_MASK                                                              0x20000000L
#define SDMA1_RELAX_ORDERING_LUT__IB_FETCH_MASK                                                               0x40000000L
#define SDMA1_RELAX_ORDERING_LUT__RB_FETCH_MASK                                                               0x80000000L
//SDMA1_CHICKEN_BITS_2
#define SDMA1_CHICKEN_BITS_2__F32_CMD_PROC_DELAY__SHIFT                                                       0x0
#define SDMA1_CHICKEN_BITS_2__CE_BACKWARDS_SIZE_SEL__SHIFT                                                    0x4
#define SDMA1_CHICKEN_BITS_2__CE_DCC_READ_128B_ENABLE__SHIFT                                                  0x5
#define SDMA1_CHICKEN_BITS_2__UTCL1_FORCE_INV_RET_FIFO_FULL_EN__SHIFT                                         0x6
#define SDMA1_CHICKEN_BITS_2__RESERVED0__SHIFT                                                                0x7
#define SDMA1_CHICKEN_BITS_2__LUT_FIFO_AFULL_MARGIN__SHIFT                                                    0xb
#define SDMA1_CHICKEN_BITS_2__LEGACY_WPTR_POLL_BEHAVIOR__SHIFT                                                0xf
#define SDMA1_CHICKEN_BITS_2__RB_FIFO_WATERMARK__SHIFT                                                        0x10
#define SDMA1_CHICKEN_BITS_2__IB_FIFO_WATERMARK__SHIFT                                                        0x12
#define SDMA1_CHICKEN_BITS_2__REPEATER_FGCG_EN__SHIFT                                                         0x14
#define SDMA1_CHICKEN_BITS_2__F32_SEND_POSTCODE_EN__SHIFT                                                     0x15
#define SDMA1_CHICKEN_BITS_2__RESERVED__SHIFT                                                                 0x16
#define SDMA1_CHICKEN_BITS_2__F32_CMD_PROC_DELAY_MASK                                                         0x0000000FL
#define SDMA1_CHICKEN_BITS_2__CE_BACKWARDS_SIZE_SEL_MASK                                                      0x00000010L
#define SDMA1_CHICKEN_BITS_2__CE_DCC_READ_128B_ENABLE_MASK                                                    0x00000020L
#define SDMA1_CHICKEN_BITS_2__UTCL1_FORCE_INV_RET_FIFO_FULL_EN_MASK                                           0x00000040L
#define SDMA1_CHICKEN_BITS_2__RESERVED0_MASK                                                                  0x00000780L
#define SDMA1_CHICKEN_BITS_2__LUT_FIFO_AFULL_MARGIN_MASK                                                      0x00007800L
#define SDMA1_CHICKEN_BITS_2__LEGACY_WPTR_POLL_BEHAVIOR_MASK                                                  0x00008000L
#define SDMA1_CHICKEN_BITS_2__RB_FIFO_WATERMARK_MASK                                                          0x00030000L
#define SDMA1_CHICKEN_BITS_2__IB_FIFO_WATERMARK_MASK                                                          0x000C0000L
#define SDMA1_CHICKEN_BITS_2__REPEATER_FGCG_EN_MASK                                                           0x00100000L
#define SDMA1_CHICKEN_BITS_2__F32_SEND_POSTCODE_EN_MASK                                                       0x00200000L
#define SDMA1_CHICKEN_BITS_2__RESERVED_MASK                                                                   0xFFC00000L
//SDMA1_STATUS3_REG
#define SDMA1_STATUS3_REG__CMD_OP_STATUS__SHIFT                                                               0x0
#define SDMA1_STATUS3_REG__PREV_VM_CMD__SHIFT                                                                 0x10
#define SDMA1_STATUS3_REG__EXCEPTION_IDLE__SHIFT                                                              0x14
#define SDMA1_STATUS3_REG__AQL_PREV_CMD_IDLE__SHIFT                                                           0x15
#define SDMA1_STATUS3_REG__TLBI_IDLE__SHIFT                                                                   0x16
#define SDMA1_STATUS3_REG__GCR_IDLE__SHIFT                                                                    0x17
#define SDMA1_STATUS3_REG__INVREQ_IDLE__SHIFT                                                                 0x18
#define SDMA1_STATUS3_REG__QUEUE_ID_MATCH__SHIFT                                                              0x19
#define SDMA1_STATUS3_REG__INT_QUEUE_ID__SHIFT                                                                0x1a
#define SDMA1_STATUS3_REG__CMD_OP_STATUS_MASK                                                                 0x0000FFFFL
#define SDMA1_STATUS3_REG__PREV_VM_CMD_MASK                                                                   0x000F0000L
#define SDMA1_STATUS3_REG__EXCEPTION_IDLE_MASK                                                                0x00100000L
#define SDMA1_STATUS3_REG__AQL_PREV_CMD_IDLE_MASK                                                             0x00200000L
#define SDMA1_STATUS3_REG__TLBI_IDLE_MASK                                                                     0x00400000L
#define SDMA1_STATUS3_REG__GCR_IDLE_MASK                                                                      0x00800000L
#define SDMA1_STATUS3_REG__INVREQ_IDLE_MASK                                                                   0x01000000L
#define SDMA1_STATUS3_REG__QUEUE_ID_MATCH_MASK                                                                0x02000000L
#define SDMA1_STATUS3_REG__INT_QUEUE_ID_MASK                                                                  0x3C000000L
//SDMA1_PHYSICAL_ADDR_LO
#define SDMA1_PHYSICAL_ADDR_LO__D_VALID__SHIFT                                                                0x0
#define SDMA1_PHYSICAL_ADDR_LO__DIRTY__SHIFT                                                                  0x1
#define SDMA1_PHYSICAL_ADDR_LO__PHY_VALID__SHIFT                                                              0x2
#define SDMA1_PHYSICAL_ADDR_LO__ADDR__SHIFT                                                                   0xc
#define SDMA1_PHYSICAL_ADDR_LO__D_VALID_MASK                                                                  0x00000001L
#define SDMA1_PHYSICAL_ADDR_LO__DIRTY_MASK                                                                    0x00000002L
#define SDMA1_PHYSICAL_ADDR_LO__PHY_VALID_MASK                                                                0x00000004L
#define SDMA1_PHYSICAL_ADDR_LO__ADDR_MASK                                                                     0xFFFFF000L
//SDMA1_PHYSICAL_ADDR_HI
#define SDMA1_PHYSICAL_ADDR_HI__ADDR__SHIFT                                                                   0x0
#define SDMA1_PHYSICAL_ADDR_HI__ADDR_MASK                                                                     0x0000FFFFL
//SDMA1_PHASE2_QUANTUM
#define SDMA1_PHASE2_QUANTUM__UNIT__SHIFT                                                                     0x0
#define SDMA1_PHASE2_QUANTUM__VALUE__SHIFT                                                                    0x8
#define SDMA1_PHASE2_QUANTUM__PREFER__SHIFT                                                                   0x1e
#define SDMA1_PHASE2_QUANTUM__UNIT_MASK                                                                       0x0000000FL
#define SDMA1_PHASE2_QUANTUM__VALUE_MASK                                                                      0x00FFFF00L
#define SDMA1_PHASE2_QUANTUM__PREFER_MASK                                                                     0x40000000L
//SDMA1_ERROR_LOG
#define SDMA1_ERROR_LOG__OVERRIDE__SHIFT                                                                      0x0
#define SDMA1_ERROR_LOG__STATUS__SHIFT                                                                        0x10
#define SDMA1_ERROR_LOG__OVERRIDE_MASK                                                                        0x0000FFFFL
#define SDMA1_ERROR_LOG__STATUS_MASK                                                                          0xFFFF0000L
//SDMA1_PUB_DUMMY_REG0
#define SDMA1_PUB_DUMMY_REG0__VALUE__SHIFT                                                                    0x0
#define SDMA1_PUB_DUMMY_REG0__VALUE_MASK                                                                      0xFFFFFFFFL
//SDMA1_PUB_DUMMY_REG1
#define SDMA1_PUB_DUMMY_REG1__VALUE__SHIFT                                                                    0x0
#define SDMA1_PUB_DUMMY_REG1__VALUE_MASK                                                                      0xFFFFFFFFL
//SDMA1_PUB_DUMMY_REG2
#define SDMA1_PUB_DUMMY_REG2__VALUE__SHIFT                                                                    0x0
#define SDMA1_PUB_DUMMY_REG2__VALUE_MASK                                                                      0xFFFFFFFFL
//SDMA1_PUB_DUMMY_REG3
#define SDMA1_PUB_DUMMY_REG3__VALUE__SHIFT                                                                    0x0
#define SDMA1_PUB_DUMMY_REG3__VALUE_MASK                                                                      0xFFFFFFFFL
//SDMA1_F32_COUNTER
#define SDMA1_F32_COUNTER__VALUE__SHIFT                                                                       0x0
#define SDMA1_F32_COUNTER__VALUE_MASK                                                                         0xFFFFFFFFL
//SDMA1_CRD_CNTL
#define SDMA1_CRD_CNTL__MC_WRREQ_CREDIT__SHIFT                                                                0x7
#define SDMA1_CRD_CNTL__MC_RDREQ_CREDIT__SHIFT                                                                0xd
#define SDMA1_CRD_CNTL__CH_WRREQ_CREDIT__SHIFT                                                                0x13
#define SDMA1_CRD_CNTL__CH_RDREQ_CREDIT__SHIFT                                                                0x19
#define SDMA1_CRD_CNTL__MC_WRREQ_CREDIT_MASK                                                                  0x00001F80L
#define SDMA1_CRD_CNTL__MC_RDREQ_CREDIT_MASK                                                                  0x0007E000L
#define SDMA1_CRD_CNTL__CH_WRREQ_CREDIT_MASK                                                                  0x01F80000L
#define SDMA1_CRD_CNTL__CH_RDREQ_CREDIT_MASK                                                                  0x7E000000L
//SDMA1_AQL_STATUS
#define SDMA1_AQL_STATUS__COMPLETE_SIGNAL_EMPTY__SHIFT                                                        0x0
#define SDMA1_AQL_STATUS__INVALID_CMD_EMPTY__SHIFT                                                            0x1
#define SDMA1_AQL_STATUS__COMPLETE_SIGNAL_EMPTY_MASK                                                          0x00000001L
#define SDMA1_AQL_STATUS__INVALID_CMD_EMPTY_MASK                                                              0x00000002L
//SDMA1_EA_DBIT_ADDR_DATA
#define SDMA1_EA_DBIT_ADDR_DATA__VALUE__SHIFT                                                                 0x0
#define SDMA1_EA_DBIT_ADDR_DATA__VALUE_MASK                                                                   0xFFFFFFFFL
//SDMA1_EA_DBIT_ADDR_INDEX
#define SDMA1_EA_DBIT_ADDR_INDEX__VALUE__SHIFT                                                                0x0
#define SDMA1_EA_DBIT_ADDR_INDEX__VALUE_MASK                                                                  0x00000007L
//SDMA1_TLBI_GCR_CNTL
#define SDMA1_TLBI_GCR_CNTL__TLBI_CMD_DW__SHIFT                                                               0x0
#define SDMA1_TLBI_GCR_CNTL__GCR_CMD_DW__SHIFT                                                                0x4
#define SDMA1_TLBI_GCR_CNTL__GCR_CLKEN_CYCLE__SHIFT                                                           0x8
#define SDMA1_TLBI_GCR_CNTL__TLBI_CREDIT__SHIFT                                                               0x10
#define SDMA1_TLBI_GCR_CNTL__GCR_CREDIT__SHIFT                                                                0x18
#define SDMA1_TLBI_GCR_CNTL__TLBI_CMD_DW_MASK                                                                 0x0000000FL
#define SDMA1_TLBI_GCR_CNTL__GCR_CMD_DW_MASK                                                                  0x000000F0L
#define SDMA1_TLBI_GCR_CNTL__GCR_CLKEN_CYCLE_MASK                                                             0x00000F00L
#define SDMA1_TLBI_GCR_CNTL__TLBI_CREDIT_MASK                                                                 0x00FF0000L
#define SDMA1_TLBI_GCR_CNTL__GCR_CREDIT_MASK                                                                  0xFF000000L
//SDMA1_TILING_CONFIG
#define SDMA1_TILING_CONFIG__PIPE_INTERLEAVE_SIZE__SHIFT                                                      0x4
#define SDMA1_TILING_CONFIG__PIPE_INTERLEAVE_SIZE_MASK                                                        0x00000070L
//SDMA1_INT_STATUS
#define SDMA1_INT_STATUS__DATA__SHIFT                                                                         0x0
#define SDMA1_INT_STATUS__DATA_MASK                                                                           0xFFFFFFFFL
//SDMA1_HOLE_ADDR_LO
#define SDMA1_HOLE_ADDR_LO__VALUE__SHIFT                                                                      0x0
#define SDMA1_HOLE_ADDR_LO__VALUE_MASK                                                                        0xFFFFFFFFL
//SDMA1_HOLE_ADDR_HI
#define SDMA1_HOLE_ADDR_HI__VALUE__SHIFT                                                                      0x0
#define SDMA1_HOLE_ADDR_HI__VALUE_MASK                                                                        0xFFFFFFFFL
//SDMA1_CLOCK_GATING_REG
#define SDMA1_CLOCK_GATING_REG__DYN_CLK_GATE_STATUS__SHIFT                                                    0x0
#define SDMA1_CLOCK_GATING_REG__PTR_CLK_GATE_STATUS__SHIFT                                                    0x1
#define SDMA1_CLOCK_GATING_REG__CE_CLK_GATE_STATUS__SHIFT                                                     0x2
#define SDMA1_CLOCK_GATING_REG__CE_BC_CLK_GATE_STATUS__SHIFT                                                  0x3
#define SDMA1_CLOCK_GATING_REG__CE_NBC_CLK_GATE_STATUS__SHIFT                                                 0x4
#define SDMA1_CLOCK_GATING_REG__REG_CLK_GATE_STATUS__SHIFT                                                    0x5
#define SDMA1_CLOCK_GATING_REG__DYN_CLK_GATE_STATUS_MASK                                                      0x00000001L
#define SDMA1_CLOCK_GATING_REG__PTR_CLK_GATE_STATUS_MASK                                                      0x00000002L
#define SDMA1_CLOCK_GATING_REG__CE_CLK_GATE_STATUS_MASK                                                       0x00000004L
#define SDMA1_CLOCK_GATING_REG__CE_BC_CLK_GATE_STATUS_MASK                                                    0x00000008L
#define SDMA1_CLOCK_GATING_REG__CE_NBC_CLK_GATE_STATUS_MASK                                                   0x00000010L
#define SDMA1_CLOCK_GATING_REG__REG_CLK_GATE_STATUS_MASK                                                      0x00000020L
//SDMA1_STATUS4_REG
#define SDMA1_STATUS4_REG__IDLE__SHIFT                                                                        0x0
#define SDMA1_STATUS4_REG__IH_OUTSTANDING__SHIFT                                                              0x2
#define SDMA1_STATUS4_REG__SEM_OUTSTANDING__SHIFT                                                             0x3
#define SDMA1_STATUS4_REG__CH_RD_OUTSTANDING__SHIFT                                                           0x4
#define SDMA1_STATUS4_REG__CH_WR_OUTSTANDING__SHIFT                                                           0x5
#define SDMA1_STATUS4_REG__GCR_OUTSTANDING__SHIFT                                                             0x6
#define SDMA1_STATUS4_REG__TLBI_OUTSTANDING__SHIFT                                                            0x7
#define SDMA1_STATUS4_REG__UTCL2_RD_OUTSTANDING__SHIFT                                                        0x8
#define SDMA1_STATUS4_REG__UTCL2_WR_OUTSTANDING__SHIFT                                                        0x9
#define SDMA1_STATUS4_REG__REG_POLLING__SHIFT                                                                 0xa
#define SDMA1_STATUS4_REG__MEM_POLLING__SHIFT                                                                 0xb
#define SDMA1_STATUS4_REG__UTCL2_RD_XNACK__SHIFT                                                              0xc
#define SDMA1_STATUS4_REG__UTCL2_WR_XNACK__SHIFT                                                              0xe
#define SDMA1_STATUS4_REG__ACTIVE_QUEUE_ID__SHIFT                                                             0x10
#define SDMA1_STATUS4_REG__SRIOV_WATING_RLCV_CMD__SHIFT                                                       0x14
#define SDMA1_STATUS4_REG__SRIOV_SDMA_EXECUTING_CMD__SHIFT                                                    0x15
#define SDMA1_STATUS4_REG__IDLE_MASK                                                                          0x00000001L
#define SDMA1_STATUS4_REG__IH_OUTSTANDING_MASK                                                                0x00000004L
#define SDMA1_STATUS4_REG__SEM_OUTSTANDING_MASK                                                               0x00000008L
#define SDMA1_STATUS4_REG__CH_RD_OUTSTANDING_MASK                                                             0x00000010L
#define SDMA1_STATUS4_REG__CH_WR_OUTSTANDING_MASK                                                             0x00000020L
#define SDMA1_STATUS4_REG__GCR_OUTSTANDING_MASK                                                               0x00000040L
#define SDMA1_STATUS4_REG__TLBI_OUTSTANDING_MASK                                                              0x00000080L
#define SDMA1_STATUS4_REG__UTCL2_RD_OUTSTANDING_MASK                                                          0x00000100L
#define SDMA1_STATUS4_REG__UTCL2_WR_OUTSTANDING_MASK                                                          0x00000200L
#define SDMA1_STATUS4_REG__REG_POLLING_MASK                                                                   0x00000400L
#define SDMA1_STATUS4_REG__MEM_POLLING_MASK                                                                   0x00000800L
#define SDMA1_STATUS4_REG__UTCL2_RD_XNACK_MASK                                                                0x00003000L
#define SDMA1_STATUS4_REG__UTCL2_WR_XNACK_MASK                                                                0x0000C000L
#define SDMA1_STATUS4_REG__ACTIVE_QUEUE_ID_MASK                                                               0x000F0000L
#define SDMA1_STATUS4_REG__SRIOV_WATING_RLCV_CMD_MASK                                                         0x00100000L
#define SDMA1_STATUS4_REG__SRIOV_SDMA_EXECUTING_CMD_MASK                                                      0x00200000L
//SDMA1_SCRATCH_RAM_DATA
#define SDMA1_SCRATCH_RAM_DATA__DATA__SHIFT                                                                   0x0
#define SDMA1_SCRATCH_RAM_DATA__DATA_MASK                                                                     0xFFFFFFFFL
//SDMA1_SCRATCH_RAM_ADDR
#define SDMA1_SCRATCH_RAM_ADDR__ADDR__SHIFT                                                                   0x0
#define SDMA1_SCRATCH_RAM_ADDR__ADDR_MASK                                                                     0x000003FFL
//SDMA1_TIMESTAMP_CNTL
#define SDMA1_TIMESTAMP_CNTL__CAPTURE__SHIFT                                                                  0x0
#define SDMA1_TIMESTAMP_CNTL__CAPTURE_MASK                                                                    0x00000001L
//SDMA1_STATUS5_REG
#define SDMA1_STATUS5_REG__GFX_RB_ENABLE_STATUS__SHIFT                                                        0x0
#define SDMA1_STATUS5_REG__PAGE_RB_ENABLE_STATUS__SHIFT                                                       0x1
#define SDMA1_STATUS5_REG__RLC0_RB_ENABLE_STATUS__SHIFT                                                       0x2
#define SDMA1_STATUS5_REG__RLC1_RB_ENABLE_STATUS__SHIFT                                                       0x3
#define SDMA1_STATUS5_REG__RLC2_RB_ENABLE_STATUS__SHIFT                                                       0x4
#define SDMA1_STATUS5_REG__RLC3_RB_ENABLE_STATUS__SHIFT                                                       0x5
#define SDMA1_STATUS5_REG__RLC4_RB_ENABLE_STATUS__SHIFT                                                       0x6
#define SDMA1_STATUS5_REG__RLC5_RB_ENABLE_STATUS__SHIFT                                                       0x7
#define SDMA1_STATUS5_REG__RLC6_RB_ENABLE_STATUS__SHIFT                                                       0x8
#define SDMA1_STATUS5_REG__RLC7_RB_ENABLE_STATUS__SHIFT                                                       0x9
#define SDMA1_STATUS5_REG__ACTIVE_QUEUE_ID__SHIFT                                                             0x10
#define SDMA1_STATUS5_REG__GFX_RB_ENABLE_STATUS_MASK                                                          0x00000001L
#define SDMA1_STATUS5_REG__PAGE_RB_ENABLE_STATUS_MASK                                                         0x00000002L
#define SDMA1_STATUS5_REG__RLC0_RB_ENABLE_STATUS_MASK                                                         0x00000004L
#define SDMA1_STATUS5_REG__RLC1_RB_ENABLE_STATUS_MASK                                                         0x00000008L
#define SDMA1_STATUS5_REG__RLC2_RB_ENABLE_STATUS_MASK                                                         0x00000010L
#define SDMA1_STATUS5_REG__RLC3_RB_ENABLE_STATUS_MASK                                                         0x00000020L
#define SDMA1_STATUS5_REG__RLC4_RB_ENABLE_STATUS_MASK                                                         0x00000040L
#define SDMA1_STATUS5_REG__RLC5_RB_ENABLE_STATUS_MASK                                                         0x00000080L
#define SDMA1_STATUS5_REG__RLC6_RB_ENABLE_STATUS_MASK                                                         0x00000100L
#define SDMA1_STATUS5_REG__RLC7_RB_ENABLE_STATUS_MASK                                                         0x00000200L
#define SDMA1_STATUS5_REG__ACTIVE_QUEUE_ID_MASK                                                               0x000F0000L
//SDMA1_QUEUE_RESET_REQ
#define SDMA1_QUEUE_RESET_REQ__GFX_QUEUE_RESET__SHIFT                                                         0x0
#define SDMA1_QUEUE_RESET_REQ__PAGE_QUEUE_RESET__SHIFT                                                        0x1
#define SDMA1_QUEUE_RESET_REQ__RLC0_QUEUE_RESET__SHIFT                                                        0x2
#define SDMA1_QUEUE_RESET_REQ__RLC1_QUEUE_RESET__SHIFT                                                        0x3
#define SDMA1_QUEUE_RESET_REQ__RLC2_QUEUE_RESET__SHIFT                                                        0x4
#define SDMA1_QUEUE_RESET_REQ__RLC3_QUEUE_RESET__SHIFT                                                        0x5
#define SDMA1_QUEUE_RESET_REQ__RLC4_QUEUE_RESET__SHIFT                                                        0x6
#define SDMA1_QUEUE_RESET_REQ__RLC5_QUEUE_RESET__SHIFT                                                        0x7
#define SDMA1_QUEUE_RESET_REQ__RLC6_QUEUE_RESET__SHIFT                                                        0x8
#define SDMA1_QUEUE_RESET_REQ__RLC7_QUEUE_RESET__SHIFT                                                        0x9
#define SDMA1_QUEUE_RESET_REQ__RESERVED__SHIFT                                                                0xa
#define SDMA1_QUEUE_RESET_REQ__GFX_QUEUE_RESET_MASK                                                           0x00000001L
#define SDMA1_QUEUE_RESET_REQ__PAGE_QUEUE_RESET_MASK                                                          0x00000002L
#define SDMA1_QUEUE_RESET_REQ__RLC0_QUEUE_RESET_MASK                                                          0x00000004L
#define SDMA1_QUEUE_RESET_REQ__RLC1_QUEUE_RESET_MASK                                                          0x00000008L
#define SDMA1_QUEUE_RESET_REQ__RLC2_QUEUE_RESET_MASK                                                          0x00000010L
#define SDMA1_QUEUE_RESET_REQ__RLC3_QUEUE_RESET_MASK                                                          0x00000020L
#define SDMA1_QUEUE_RESET_REQ__RLC4_QUEUE_RESET_MASK                                                          0x00000040L
#define SDMA1_QUEUE_RESET_REQ__RLC5_QUEUE_RESET_MASK                                                          0x00000080L
#define SDMA1_QUEUE_RESET_REQ__RLC6_QUEUE_RESET_MASK                                                          0x00000100L
#define SDMA1_QUEUE_RESET_REQ__RLC7_QUEUE_RESET_MASK                                                          0x00000200L
#define SDMA1_QUEUE_RESET_REQ__RESERVED_MASK                                                                  0xFFFFFC00L
//SDMA1_GFX_RB_CNTL
#define SDMA1_GFX_RB_CNTL__RB_ENABLE__SHIFT                                                                   0x0
#define SDMA1_GFX_RB_CNTL__RB_SIZE__SHIFT                                                                     0x1
#define SDMA1_GFX_RB_CNTL__RB_SWAP_ENABLE__SHIFT                                                              0x9
#define SDMA1_GFX_RB_CNTL__RPTR_WRITEBACK_ENABLE__SHIFT                                                       0xc
#define SDMA1_GFX_RB_CNTL__RPTR_WRITEBACK_SWAP_ENABLE__SHIFT                                                  0xd
#define SDMA1_GFX_RB_CNTL__RPTR_WRITEBACK_TIMER__SHIFT                                                        0x10
#define SDMA1_GFX_RB_CNTL__RB_PRIV__SHIFT                                                                     0x17
#define SDMA1_GFX_RB_CNTL__RB_VMID__SHIFT                                                                     0x18
#define SDMA1_GFX_RB_CNTL__RPTR_WB_IDLE__SHIFT                                                                0x1f
#define SDMA1_GFX_RB_CNTL__RB_ENABLE_MASK                                                                     0x00000001L
#define SDMA1_GFX_RB_CNTL__RB_SIZE_MASK                                                                       0x0000003EL
#define SDMA1_GFX_RB_CNTL__RB_SWAP_ENABLE_MASK                                                                0x00000200L
#define SDMA1_GFX_RB_CNTL__RPTR_WRITEBACK_ENABLE_MASK                                                         0x00001000L
#define SDMA1_GFX_RB_CNTL__RPTR_WRITEBACK_SWAP_ENABLE_MASK                                                    0x00002000L
#define SDMA1_GFX_RB_CNTL__RPTR_WRITEBACK_TIMER_MASK                                                          0x001F0000L
#define SDMA1_GFX_RB_CNTL__RB_PRIV_MASK                                                                       0x00800000L
#define SDMA1_GFX_RB_CNTL__RB_VMID_MASK                                                                       0x0F000000L
#define SDMA1_GFX_RB_CNTL__RPTR_WB_IDLE_MASK                                                                  0x80000000L
//SDMA1_GFX_RB_BASE
#define SDMA1_GFX_RB_BASE__ADDR__SHIFT                                                                        0x0
#define SDMA1_GFX_RB_BASE__ADDR_MASK                                                                          0xFFFFFFFFL
//SDMA1_GFX_RB_BASE_HI
#define SDMA1_GFX_RB_BASE_HI__ADDR__SHIFT                                                                     0x0
#define SDMA1_GFX_RB_BASE_HI__ADDR_MASK                                                                       0x00FFFFFFL
//SDMA1_GFX_RB_RPTR
#define SDMA1_GFX_RB_RPTR__OFFSET__SHIFT                                                                      0x0
#define SDMA1_GFX_RB_RPTR__OFFSET_MASK                                                                        0xFFFFFFFFL
//SDMA1_GFX_RB_RPTR_HI
#define SDMA1_GFX_RB_RPTR_HI__OFFSET__SHIFT                                                                   0x0
#define SDMA1_GFX_RB_RPTR_HI__OFFSET_MASK                                                                     0xFFFFFFFFL
//SDMA1_GFX_RB_WPTR
#define SDMA1_GFX_RB_WPTR__OFFSET__SHIFT                                                                      0x0
#define SDMA1_GFX_RB_WPTR__OFFSET_MASK                                                                        0xFFFFFFFFL
//SDMA1_GFX_RB_WPTR_HI
#define SDMA1_GFX_RB_WPTR_HI__OFFSET__SHIFT                                                                   0x0
#define SDMA1_GFX_RB_WPTR_HI__OFFSET_MASK                                                                     0xFFFFFFFFL
//SDMA1_GFX_RB_WPTR_POLL_CNTL
#define SDMA1_GFX_RB_WPTR_POLL_CNTL__ENABLE__SHIFT                                                            0x0
#define SDMA1_GFX_RB_WPTR_POLL_CNTL__SWAP_ENABLE__SHIFT                                                       0x1
#define SDMA1_GFX_RB_WPTR_POLL_CNTL__F32_POLL_ENABLE__SHIFT                                                   0x2
#define SDMA1_GFX_RB_WPTR_POLL_CNTL__FREQUENCY__SHIFT                                                         0x4
#define SDMA1_GFX_RB_WPTR_POLL_CNTL__IDLE_POLL_COUNT__SHIFT                                                   0x10
#define SDMA1_GFX_RB_WPTR_POLL_CNTL__ENABLE_MASK                                                              0x00000001L
#define SDMA1_GFX_RB_WPTR_POLL_CNTL__SWAP_ENABLE_MASK                                                         0x00000002L
#define SDMA1_GFX_RB_WPTR_POLL_CNTL__F32_POLL_ENABLE_MASK                                                     0x00000004L
#define SDMA1_GFX_RB_WPTR_POLL_CNTL__FREQUENCY_MASK                                                           0x0000FFF0L
#define SDMA1_GFX_RB_WPTR_POLL_CNTL__IDLE_POLL_COUNT_MASK                                                     0xFFFF0000L
//SDMA1_GFX_RB_RPTR_ADDR_HI
#define SDMA1_GFX_RB_RPTR_ADDR_HI__ADDR__SHIFT                                                                0x0
#define SDMA1_GFX_RB_RPTR_ADDR_HI__ADDR_MASK                                                                  0xFFFFFFFFL
//SDMA1_GFX_RB_RPTR_ADDR_LO
#define SDMA1_GFX_RB_RPTR_ADDR_LO__ADDR__SHIFT                                                                0x2
#define SDMA1_GFX_RB_RPTR_ADDR_LO__ADDR_MASK                                                                  0xFFFFFFFCL
//SDMA1_GFX_IB_CNTL
#define SDMA1_GFX_IB_CNTL__IB_ENABLE__SHIFT                                                                   0x0
#define SDMA1_GFX_IB_CNTL__IB_SWAP_ENABLE__SHIFT                                                              0x4
#define SDMA1_GFX_IB_CNTL__SWITCH_INSIDE_IB__SHIFT                                                            0x8
#define SDMA1_GFX_IB_CNTL__CMD_VMID__SHIFT                                                                    0x10
#define SDMA1_GFX_IB_CNTL__IB_ENABLE_MASK                                                                     0x00000001L
#define SDMA1_GFX_IB_CNTL__IB_SWAP_ENABLE_MASK                                                                0x00000010L
#define SDMA1_GFX_IB_CNTL__SWITCH_INSIDE_IB_MASK                                                              0x00000100L
#define SDMA1_GFX_IB_CNTL__CMD_VMID_MASK                                                                      0x000F0000L
//SDMA1_GFX_IB_RPTR
#define SDMA1_GFX_IB_RPTR__OFFSET__SHIFT                                                                      0x2
#define SDMA1_GFX_IB_RPTR__OFFSET_MASK                                                                        0x003FFFFCL
//SDMA1_GFX_IB_OFFSET
#define SDMA1_GFX_IB_OFFSET__OFFSET__SHIFT                                                                    0x2
#define SDMA1_GFX_IB_OFFSET__OFFSET_MASK                                                                      0x003FFFFCL
//SDMA1_GFX_IB_BASE_LO
#define SDMA1_GFX_IB_BASE_LO__ADDR__SHIFT                                                                     0x5
#define SDMA1_GFX_IB_BASE_LO__ADDR_MASK                                                                       0xFFFFFFE0L
//SDMA1_GFX_IB_BASE_HI
#define SDMA1_GFX_IB_BASE_HI__ADDR__SHIFT                                                                     0x0
#define SDMA1_GFX_IB_BASE_HI__ADDR_MASK                                                                       0xFFFFFFFFL
//SDMA1_GFX_IB_SIZE
#define SDMA1_GFX_IB_SIZE__SIZE__SHIFT                                                                        0x0
#define SDMA1_GFX_IB_SIZE__SIZE_MASK                                                                          0x000FFFFFL
//SDMA1_GFX_SKIP_CNTL
#define SDMA1_GFX_SKIP_CNTL__SKIP_COUNT__SHIFT                                                                0x0
#define SDMA1_GFX_SKIP_CNTL__SKIP_COUNT_MASK                                                                  0x000FFFFFL
//SDMA1_GFX_CONTEXT_STATUS
#define SDMA1_GFX_CONTEXT_STATUS__SELECTED__SHIFT                                                             0x0
#define SDMA1_GFX_CONTEXT_STATUS__IDLE__SHIFT                                                                 0x2
#define SDMA1_GFX_CONTEXT_STATUS__EXPIRED__SHIFT                                                              0x3
#define SDMA1_GFX_CONTEXT_STATUS__EXCEPTION__SHIFT                                                            0x4
#define SDMA1_GFX_CONTEXT_STATUS__CTXSW_ABLE__SHIFT                                                           0x7
#define SDMA1_GFX_CONTEXT_STATUS__CTXSW_READY__SHIFT                                                          0x8
#define SDMA1_GFX_CONTEXT_STATUS__PREEMPTED__SHIFT                                                            0x9
#define SDMA1_GFX_CONTEXT_STATUS__PREEMPT_DISABLE__SHIFT                                                      0xa
#define SDMA1_GFX_CONTEXT_STATUS__SELECTED_MASK                                                               0x00000001L
#define SDMA1_GFX_CONTEXT_STATUS__IDLE_MASK                                                                   0x00000004L
#define SDMA1_GFX_CONTEXT_STATUS__EXPIRED_MASK                                                                0x00000008L
#define SDMA1_GFX_CONTEXT_STATUS__EXCEPTION_MASK                                                              0x00000070L
#define SDMA1_GFX_CONTEXT_STATUS__CTXSW_ABLE_MASK                                                             0x00000080L
#define SDMA1_GFX_CONTEXT_STATUS__CTXSW_READY_MASK                                                            0x00000100L
#define SDMA1_GFX_CONTEXT_STATUS__PREEMPTED_MASK                                                              0x00000200L
#define SDMA1_GFX_CONTEXT_STATUS__PREEMPT_DISABLE_MASK                                                        0x00000400L
//SDMA1_GFX_DOORBELL
#define SDMA1_GFX_DOORBELL__ENABLE__SHIFT                                                                     0x1c
#define SDMA1_GFX_DOORBELL__CAPTURED__SHIFT                                                                   0x1e
#define SDMA1_GFX_DOORBELL__ENABLE_MASK                                                                       0x10000000L
#define SDMA1_GFX_DOORBELL__CAPTURED_MASK                                                                     0x40000000L
//SDMA1_GFX_CONTEXT_CNTL
#define SDMA1_GFX_CONTEXT_CNTL__RESUME_CTX__SHIFT                                                             0x10
#define SDMA1_GFX_CONTEXT_CNTL__SESSION_SEL__SHIFT                                                            0x18
#define SDMA1_GFX_CONTEXT_CNTL__RESUME_CTX_MASK                                                               0x00010000L
#define SDMA1_GFX_CONTEXT_CNTL__SESSION_SEL_MASK                                                              0x0F000000L
//SDMA1_GFX_STATUS
#define SDMA1_GFX_STATUS__WPTR_UPDATE_FAIL_COUNT__SHIFT                                                       0x0
#define SDMA1_GFX_STATUS__WPTR_UPDATE_PENDING__SHIFT                                                          0x8
#define SDMA1_GFX_STATUS__WPTR_UPDATE_FAIL_COUNT_MASK                                                         0x000000FFL
#define SDMA1_GFX_STATUS__WPTR_UPDATE_PENDING_MASK                                                            0x00000100L
//SDMA1_GFX_DOORBELL_LOG
#define SDMA1_GFX_DOORBELL_LOG__BE_ERROR__SHIFT                                                               0x0
#define SDMA1_GFX_DOORBELL_LOG__DATA__SHIFT                                                                   0x2
#define SDMA1_GFX_DOORBELL_LOG__BE_ERROR_MASK                                                                 0x00000001L
#define SDMA1_GFX_DOORBELL_LOG__DATA_MASK                                                                     0xFFFFFFFCL
//SDMA1_GFX_WATERMARK
#define SDMA1_GFX_WATERMARK__RD_OUTSTANDING__SHIFT                                                            0x0
#define SDMA1_GFX_WATERMARK__WR_OUTSTANDING__SHIFT                                                            0x10
#define SDMA1_GFX_WATERMARK__RD_OUTSTANDING_MASK                                                              0x00000FFFL
#define SDMA1_GFX_WATERMARK__WR_OUTSTANDING_MASK                                                              0x03FF0000L
//SDMA1_GFX_DOORBELL_OFFSET
#define SDMA1_GFX_DOORBELL_OFFSET__OFFSET__SHIFT                                                              0x2
#define SDMA1_GFX_DOORBELL_OFFSET__OFFSET_MASK                                                                0x0FFFFFFCL
//SDMA1_GFX_CSA_ADDR_LO
#define SDMA1_GFX_CSA_ADDR_LO__ADDR__SHIFT                                                                    0x2
#define SDMA1_GFX_CSA_ADDR_LO__ADDR_MASK                                                                      0xFFFFFFFCL
//SDMA1_GFX_CSA_ADDR_HI
#define SDMA1_GFX_CSA_ADDR_HI__ADDR__SHIFT                                                                    0x0
#define SDMA1_GFX_CSA_ADDR_HI__ADDR_MASK                                                                      0xFFFFFFFFL
//SDMA1_GFX_IB_SUB_REMAIN
#define SDMA1_GFX_IB_SUB_REMAIN__SIZE__SHIFT                                                                  0x0
#define SDMA1_GFX_IB_SUB_REMAIN__SIZE_MASK                                                                    0x00003FFFL
//SDMA1_GFX_PREEMPT
#define SDMA1_GFX_PREEMPT__IB_PREEMPT__SHIFT                                                                  0x0
#define SDMA1_GFX_PREEMPT__IB_PREEMPT_MASK                                                                    0x00000001L
//SDMA1_GFX_DUMMY_REG
#define SDMA1_GFX_DUMMY_REG__DUMMY__SHIFT                                                                     0x0
#define SDMA1_GFX_DUMMY_REG__DUMMY_MASK                                                                       0xFFFFFFFFL
//SDMA1_GFX_RB_WPTR_POLL_ADDR_HI
#define SDMA1_GFX_RB_WPTR_POLL_ADDR_HI__ADDR__SHIFT                                                           0x0
#define SDMA1_GFX_RB_WPTR_POLL_ADDR_HI__ADDR_MASK                                                             0xFFFFFFFFL
//SDMA1_GFX_RB_WPTR_POLL_ADDR_LO
#define SDMA1_GFX_RB_WPTR_POLL_ADDR_LO__ADDR__SHIFT                                                           0x2
#define SDMA1_GFX_RB_WPTR_POLL_ADDR_LO__ADDR_MASK                                                             0xFFFFFFFCL
//SDMA1_GFX_RB_AQL_CNTL
#define SDMA1_GFX_RB_AQL_CNTL__AQL_ENABLE__SHIFT                                                              0x0
#define SDMA1_GFX_RB_AQL_CNTL__AQL_PACKET_SIZE__SHIFT                                                         0x1
#define SDMA1_GFX_RB_AQL_CNTL__PACKET_STEP__SHIFT                                                             0x8
#define SDMA1_GFX_RB_AQL_CNTL__MIDCMD_PREEMPT_ENABLE__SHIFT                                                   0x10
#define SDMA1_GFX_RB_AQL_CNTL__MIDCMD_PREEMPT_DATA_RESTORE__SHIFT                                             0x11
#define SDMA1_GFX_RB_AQL_CNTL__OVERLAP_ENABLE__SHIFT                                                          0x12
#define SDMA1_GFX_RB_AQL_CNTL__AQL_ENABLE_MASK                                                                0x00000001L
#define SDMA1_GFX_RB_AQL_CNTL__AQL_PACKET_SIZE_MASK                                                           0x000000FEL
#define SDMA1_GFX_RB_AQL_CNTL__PACKET_STEP_MASK                                                               0x0000FF00L
#define SDMA1_GFX_RB_AQL_CNTL__MIDCMD_PREEMPT_ENABLE_MASK                                                     0x00010000L
#define SDMA1_GFX_RB_AQL_CNTL__MIDCMD_PREEMPT_DATA_RESTORE_MASK                                               0x00020000L
#define SDMA1_GFX_RB_AQL_CNTL__OVERLAP_ENABLE_MASK                                                            0x00040000L
//SDMA1_GFX_MINOR_PTR_UPDATE
#define SDMA1_GFX_MINOR_PTR_UPDATE__ENABLE__SHIFT                                                             0x0
#define SDMA1_GFX_MINOR_PTR_UPDATE__ENABLE_MASK                                                               0x00000001L
//SDMA1_GFX_MIDCMD_DATA0
#define SDMA1_GFX_MIDCMD_DATA0__DATA0__SHIFT                                                                  0x0
#define SDMA1_GFX_MIDCMD_DATA0__DATA0_MASK                                                                    0xFFFFFFFFL
//SDMA1_GFX_MIDCMD_DATA1
#define SDMA1_GFX_MIDCMD_DATA1__DATA1__SHIFT                                                                  0x0
#define SDMA1_GFX_MIDCMD_DATA1__DATA1_MASK                                                                    0xFFFFFFFFL
//SDMA1_GFX_MIDCMD_DATA2
#define SDMA1_GFX_MIDCMD_DATA2__DATA2__SHIFT                                                                  0x0
#define SDMA1_GFX_MIDCMD_DATA2__DATA2_MASK                                                                    0xFFFFFFFFL
//SDMA1_GFX_MIDCMD_DATA3
#define SDMA1_GFX_MIDCMD_DATA3__DATA3__SHIFT                                                                  0x0
#define SDMA1_GFX_MIDCMD_DATA3__DATA3_MASK                                                                    0xFFFFFFFFL
//SDMA1_GFX_MIDCMD_DATA4
#define SDMA1_GFX_MIDCMD_DATA4__DATA4__SHIFT                                                                  0x0
#define SDMA1_GFX_MIDCMD_DATA4__DATA4_MASK                                                                    0xFFFFFFFFL
//SDMA1_GFX_MIDCMD_DATA5
#define SDMA1_GFX_MIDCMD_DATA5__DATA5__SHIFT                                                                  0x0
#define SDMA1_GFX_MIDCMD_DATA5__DATA5_MASK                                                                    0xFFFFFFFFL
//SDMA1_GFX_MIDCMD_DATA6
#define SDMA1_GFX_MIDCMD_DATA6__DATA6__SHIFT                                                                  0x0
#define SDMA1_GFX_MIDCMD_DATA6__DATA6_MASK                                                                    0xFFFFFFFFL
//SDMA1_GFX_MIDCMD_DATA7
#define SDMA1_GFX_MIDCMD_DATA7__DATA7__SHIFT                                                                  0x0
#define SDMA1_GFX_MIDCMD_DATA7__DATA7_MASK                                                                    0xFFFFFFFFL
//SDMA1_GFX_MIDCMD_DATA8
#define SDMA1_GFX_MIDCMD_DATA8__DATA8__SHIFT                                                                  0x0
#define SDMA1_GFX_MIDCMD_DATA8__DATA8_MASK                                                                    0xFFFFFFFFL
//SDMA1_GFX_MIDCMD_DATA9
#define SDMA1_GFX_MIDCMD_DATA9__DATA9__SHIFT                                                                  0x0
#define SDMA1_GFX_MIDCMD_DATA9__DATA9_MASK                                                                    0xFFFFFFFFL
//SDMA1_GFX_MIDCMD_DATA10
#define SDMA1_GFX_MIDCMD_DATA10__DATA10__SHIFT                                                                0x0
#define SDMA1_GFX_MIDCMD_DATA10__DATA10_MASK                                                                  0xFFFFFFFFL
//SDMA1_GFX_MIDCMD_CNTL
#define SDMA1_GFX_MIDCMD_CNTL__DATA_VALID__SHIFT                                                              0x0
#define SDMA1_GFX_MIDCMD_CNTL__COPY_MODE__SHIFT                                                               0x1
#define SDMA1_GFX_MIDCMD_CNTL__SPLIT_STATE__SHIFT                                                             0x4
#define SDMA1_GFX_MIDCMD_CNTL__ALLOW_PREEMPT__SHIFT                                                           0x8
#define SDMA1_GFX_MIDCMD_CNTL__DATA_VALID_MASK                                                                0x00000001L
#define SDMA1_GFX_MIDCMD_CNTL__COPY_MODE_MASK                                                                 0x00000002L
#define SDMA1_GFX_MIDCMD_CNTL__SPLIT_STATE_MASK                                                               0x000000F0L
#define SDMA1_GFX_MIDCMD_CNTL__ALLOW_PREEMPT_MASK                                                             0x00000100L
//SDMA1_PAGE_RB_CNTL
#define SDMA1_PAGE_RB_CNTL__RB_ENABLE__SHIFT                                                                  0x0
#define SDMA1_PAGE_RB_CNTL__RB_SIZE__SHIFT                                                                    0x1
#define SDMA1_PAGE_RB_CNTL__RB_SWAP_ENABLE__SHIFT                                                             0x9
#define SDMA1_PAGE_RB_CNTL__RPTR_WRITEBACK_ENABLE__SHIFT                                                      0xc
#define SDMA1_PAGE_RB_CNTL__RPTR_WRITEBACK_SWAP_ENABLE__SHIFT                                                 0xd
#define SDMA1_PAGE_RB_CNTL__RPTR_WRITEBACK_TIMER__SHIFT                                                       0x10
#define SDMA1_PAGE_RB_CNTL__RB_PRIV__SHIFT                                                                    0x17
#define SDMA1_PAGE_RB_CNTL__RB_VMID__SHIFT                                                                    0x18
#define SDMA1_PAGE_RB_CNTL__RPTR_WB_IDLE__SHIFT                                                               0x1f
#define SDMA1_PAGE_RB_CNTL__RB_ENABLE_MASK                                                                    0x00000001L
#define SDMA1_PAGE_RB_CNTL__RB_SIZE_MASK                                                                      0x0000003EL
#define SDMA1_PAGE_RB_CNTL__RB_SWAP_ENABLE_MASK                                                               0x00000200L
#define SDMA1_PAGE_RB_CNTL__RPTR_WRITEBACK_ENABLE_MASK                                                        0x00001000L
#define SDMA1_PAGE_RB_CNTL__RPTR_WRITEBACK_SWAP_ENABLE_MASK                                                   0x00002000L
#define SDMA1_PAGE_RB_CNTL__RPTR_WRITEBACK_TIMER_MASK                                                         0x001F0000L
#define SDMA1_PAGE_RB_CNTL__RB_PRIV_MASK                                                                      0x00800000L
#define SDMA1_PAGE_RB_CNTL__RB_VMID_MASK                                                                      0x0F000000L
#define SDMA1_PAGE_RB_CNTL__RPTR_WB_IDLE_MASK                                                                 0x80000000L
//SDMA1_PAGE_RB_BASE
#define SDMA1_PAGE_RB_BASE__ADDR__SHIFT                                                                       0x0
#define SDMA1_PAGE_RB_BASE__ADDR_MASK                                                                         0xFFFFFFFFL
//SDMA1_PAGE_RB_BASE_HI
#define SDMA1_PAGE_RB_BASE_HI__ADDR__SHIFT                                                                    0x0
#define SDMA1_PAGE_RB_BASE_HI__ADDR_MASK                                                                      0x00FFFFFFL
//SDMA1_PAGE_RB_RPTR
#define SDMA1_PAGE_RB_RPTR__OFFSET__SHIFT                                                                     0x0
#define SDMA1_PAGE_RB_RPTR__OFFSET_MASK                                                                       0xFFFFFFFFL
//SDMA1_PAGE_RB_RPTR_HI
#define SDMA1_PAGE_RB_RPTR_HI__OFFSET__SHIFT                                                                  0x0
#define SDMA1_PAGE_RB_RPTR_HI__OFFSET_MASK                                                                    0xFFFFFFFFL
//SDMA1_PAGE_RB_WPTR
#define SDMA1_PAGE_RB_WPTR__OFFSET__SHIFT                                                                     0x0
#define SDMA1_PAGE_RB_WPTR__OFFSET_MASK                                                                       0xFFFFFFFFL
//SDMA1_PAGE_RB_WPTR_HI
#define SDMA1_PAGE_RB_WPTR_HI__OFFSET__SHIFT                                                                  0x0
#define SDMA1_PAGE_RB_WPTR_HI__OFFSET_MASK                                                                    0xFFFFFFFFL
//SDMA1_PAGE_RB_WPTR_POLL_CNTL
#define SDMA1_PAGE_RB_WPTR_POLL_CNTL__ENABLE__SHIFT                                                           0x0
#define SDMA1_PAGE_RB_WPTR_POLL_CNTL__SWAP_ENABLE__SHIFT                                                      0x1
#define SDMA1_PAGE_RB_WPTR_POLL_CNTL__F32_POLL_ENABLE__SHIFT                                                  0x2
#define SDMA1_PAGE_RB_WPTR_POLL_CNTL__FREQUENCY__SHIFT                                                        0x4
#define SDMA1_PAGE_RB_WPTR_POLL_CNTL__IDLE_POLL_COUNT__SHIFT                                                  0x10
#define SDMA1_PAGE_RB_WPTR_POLL_CNTL__ENABLE_MASK                                                             0x00000001L
#define SDMA1_PAGE_RB_WPTR_POLL_CNTL__SWAP_ENABLE_MASK                                                        0x00000002L
#define SDMA1_PAGE_RB_WPTR_POLL_CNTL__F32_POLL_ENABLE_MASK                                                    0x00000004L
#define SDMA1_PAGE_RB_WPTR_POLL_CNTL__FREQUENCY_MASK                                                          0x0000FFF0L
#define SDMA1_PAGE_RB_WPTR_POLL_CNTL__IDLE_POLL_COUNT_MASK                                                    0xFFFF0000L
//SDMA1_PAGE_RB_RPTR_ADDR_HI
#define SDMA1_PAGE_RB_RPTR_ADDR_HI__ADDR__SHIFT                                                               0x0
#define SDMA1_PAGE_RB_RPTR_ADDR_HI__ADDR_MASK                                                                 0xFFFFFFFFL
//SDMA1_PAGE_RB_RPTR_ADDR_LO
#define SDMA1_PAGE_RB_RPTR_ADDR_LO__ADDR__SHIFT                                                               0x2
#define SDMA1_PAGE_RB_RPTR_ADDR_LO__ADDR_MASK                                                                 0xFFFFFFFCL
//SDMA1_PAGE_IB_CNTL
#define SDMA1_PAGE_IB_CNTL__IB_ENABLE__SHIFT                                                                  0x0
#define SDMA1_PAGE_IB_CNTL__IB_SWAP_ENABLE__SHIFT                                                             0x4
#define SDMA1_PAGE_IB_CNTL__SWITCH_INSIDE_IB__SHIFT                                                           0x8
#define SDMA1_PAGE_IB_CNTL__CMD_VMID__SHIFT                                                                   0x10
#define SDMA1_PAGE_IB_CNTL__IB_ENABLE_MASK                                                                    0x00000001L
#define SDMA1_PAGE_IB_CNTL__IB_SWAP_ENABLE_MASK                                                               0x00000010L
#define SDMA1_PAGE_IB_CNTL__SWITCH_INSIDE_IB_MASK                                                             0x00000100L
#define SDMA1_PAGE_IB_CNTL__CMD_VMID_MASK                                                                     0x000F0000L
//SDMA1_PAGE_IB_RPTR
#define SDMA1_PAGE_IB_RPTR__OFFSET__SHIFT                                                                     0x2
#define SDMA1_PAGE_IB_RPTR__OFFSET_MASK                                                                       0x003FFFFCL
//SDMA1_PAGE_IB_OFFSET
#define SDMA1_PAGE_IB_OFFSET__OFFSET__SHIFT                                                                   0x2
#define SDMA1_PAGE_IB_OFFSET__OFFSET_MASK                                                                     0x003FFFFCL
//SDMA1_PAGE_IB_BASE_LO
#define SDMA1_PAGE_IB_BASE_LO__ADDR__SHIFT                                                                    0x5
#define SDMA1_PAGE_IB_BASE_LO__ADDR_MASK                                                                      0xFFFFFFE0L
//SDMA1_PAGE_IB_BASE_HI
#define SDMA1_PAGE_IB_BASE_HI__ADDR__SHIFT                                                                    0x0
#define SDMA1_PAGE_IB_BASE_HI__ADDR_MASK                                                                      0xFFFFFFFFL
//SDMA1_PAGE_IB_SIZE
#define SDMA1_PAGE_IB_SIZE__SIZE__SHIFT                                                                       0x0
#define SDMA1_PAGE_IB_SIZE__SIZE_MASK                                                                         0x000FFFFFL
//SDMA1_PAGE_SKIP_CNTL
#define SDMA1_PAGE_SKIP_CNTL__SKIP_COUNT__SHIFT                                                               0x0
#define SDMA1_PAGE_SKIP_CNTL__SKIP_COUNT_MASK                                                                 0x000FFFFFL
//SDMA1_PAGE_CONTEXT_STATUS
#define SDMA1_PAGE_CONTEXT_STATUS__SELECTED__SHIFT                                                            0x0
#define SDMA1_PAGE_CONTEXT_STATUS__IDLE__SHIFT                                                                0x2
#define SDMA1_PAGE_CONTEXT_STATUS__EXPIRED__SHIFT                                                             0x3
#define SDMA1_PAGE_CONTEXT_STATUS__EXCEPTION__SHIFT                                                           0x4
#define SDMA1_PAGE_CONTEXT_STATUS__CTXSW_ABLE__SHIFT                                                          0x7
#define SDMA1_PAGE_CONTEXT_STATUS__CTXSW_READY__SHIFT                                                         0x8
#define SDMA1_PAGE_CONTEXT_STATUS__PREEMPTED__SHIFT                                                           0x9
#define SDMA1_PAGE_CONTEXT_STATUS__PREEMPT_DISABLE__SHIFT                                                     0xa
#define SDMA1_PAGE_CONTEXT_STATUS__SELECTED_MASK                                                              0x00000001L
#define SDMA1_PAGE_CONTEXT_STATUS__IDLE_MASK                                                                  0x00000004L
#define SDMA1_PAGE_CONTEXT_STATUS__EXPIRED_MASK                                                               0x00000008L
#define SDMA1_PAGE_CONTEXT_STATUS__EXCEPTION_MASK                                                             0x00000070L
#define SDMA1_PAGE_CONTEXT_STATUS__CTXSW_ABLE_MASK                                                            0x00000080L
#define SDMA1_PAGE_CONTEXT_STATUS__CTXSW_READY_MASK                                                           0x00000100L
#define SDMA1_PAGE_CONTEXT_STATUS__PREEMPTED_MASK                                                             0x00000200L
#define SDMA1_PAGE_CONTEXT_STATUS__PREEMPT_DISABLE_MASK                                                       0x00000400L
//SDMA1_PAGE_DOORBELL
#define SDMA1_PAGE_DOORBELL__ENABLE__SHIFT                                                                    0x1c
#define SDMA1_PAGE_DOORBELL__CAPTURED__SHIFT                                                                  0x1e
#define SDMA1_PAGE_DOORBELL__ENABLE_MASK                                                                      0x10000000L
#define SDMA1_PAGE_DOORBELL__CAPTURED_MASK                                                                    0x40000000L
//SDMA1_PAGE_STATUS
#define SDMA1_PAGE_STATUS__WPTR_UPDATE_FAIL_COUNT__SHIFT                                                      0x0
#define SDMA1_PAGE_STATUS__WPTR_UPDATE_PENDING__SHIFT                                                         0x8
#define SDMA1_PAGE_STATUS__WPTR_UPDATE_FAIL_COUNT_MASK                                                        0x000000FFL
#define SDMA1_PAGE_STATUS__WPTR_UPDATE_PENDING_MASK                                                           0x00000100L
//SDMA1_PAGE_DOORBELL_LOG
#define SDMA1_PAGE_DOORBELL_LOG__BE_ERROR__SHIFT                                                              0x0
#define SDMA1_PAGE_DOORBELL_LOG__DATA__SHIFT                                                                  0x2
#define SDMA1_PAGE_DOORBELL_LOG__BE_ERROR_MASK                                                                0x00000001L
#define SDMA1_PAGE_DOORBELL_LOG__DATA_MASK                                                                    0xFFFFFFFCL
//SDMA1_PAGE_WATERMARK
#define SDMA1_PAGE_WATERMARK__RD_OUTSTANDING__SHIFT                                                           0x0
#define SDMA1_PAGE_WATERMARK__WR_OUTSTANDING__SHIFT                                                           0x10
#define SDMA1_PAGE_WATERMARK__RD_OUTSTANDING_MASK                                                             0x00000FFFL
#define SDMA1_PAGE_WATERMARK__WR_OUTSTANDING_MASK                                                             0x03FF0000L
//SDMA1_PAGE_DOORBELL_OFFSET
#define SDMA1_PAGE_DOORBELL_OFFSET__OFFSET__SHIFT                                                             0x2
#define SDMA1_PAGE_DOORBELL_OFFSET__OFFSET_MASK                                                               0x0FFFFFFCL
//SDMA1_PAGE_CSA_ADDR_LO
#define SDMA1_PAGE_CSA_ADDR_LO__ADDR__SHIFT                                                                   0x2
#define SDMA1_PAGE_CSA_ADDR_LO__ADDR_MASK                                                                     0xFFFFFFFCL
//SDMA1_PAGE_CSA_ADDR_HI
#define SDMA1_PAGE_CSA_ADDR_HI__ADDR__SHIFT                                                                   0x0
#define SDMA1_PAGE_CSA_ADDR_HI__ADDR_MASK                                                                     0xFFFFFFFFL
//SDMA1_PAGE_IB_SUB_REMAIN
#define SDMA1_PAGE_IB_SUB_REMAIN__SIZE__SHIFT                                                                 0x0
#define SDMA1_PAGE_IB_SUB_REMAIN__SIZE_MASK                                                                   0x00003FFFL
//SDMA1_PAGE_PREEMPT
#define SDMA1_PAGE_PREEMPT__IB_PREEMPT__SHIFT                                                                 0x0
#define SDMA1_PAGE_PREEMPT__IB_PREEMPT_MASK                                                                   0x00000001L
//SDMA1_PAGE_DUMMY_REG
#define SDMA1_PAGE_DUMMY_REG__DUMMY__SHIFT                                                                    0x0
#define SDMA1_PAGE_DUMMY_REG__DUMMY_MASK                                                                      0xFFFFFFFFL
//SDMA1_PAGE_RB_WPTR_POLL_ADDR_HI
#define SDMA1_PAGE_RB_WPTR_POLL_ADDR_HI__ADDR__SHIFT                                                          0x0
#define SDMA1_PAGE_RB_WPTR_POLL_ADDR_HI__ADDR_MASK                                                            0xFFFFFFFFL
//SDMA1_PAGE_RB_WPTR_POLL_ADDR_LO
#define SDMA1_PAGE_RB_WPTR_POLL_ADDR_LO__ADDR__SHIFT                                                          0x2
#define SDMA1_PAGE_RB_WPTR_POLL_ADDR_LO__ADDR_MASK                                                            0xFFFFFFFCL
//SDMA1_PAGE_RB_AQL_CNTL
#define SDMA1_PAGE_RB_AQL_CNTL__AQL_ENABLE__SHIFT                                                             0x0
#define SDMA1_PAGE_RB_AQL_CNTL__AQL_PACKET_SIZE__SHIFT                                                        0x1
#define SDMA1_PAGE_RB_AQL_CNTL__PACKET_STEP__SHIFT                                                            0x8
#define SDMA1_PAGE_RB_AQL_CNTL__MIDCMD_PREEMPT_ENABLE__SHIFT                                                  0x10
#define SDMA1_PAGE_RB_AQL_CNTL__MIDCMD_PREEMPT_DATA_RESTORE__SHIFT                                            0x11
#define SDMA1_PAGE_RB_AQL_CNTL__OVERLAP_ENABLE__SHIFT                                                         0x12
#define SDMA1_PAGE_RB_AQL_CNTL__AQL_ENABLE_MASK                                                               0x00000001L
#define SDMA1_PAGE_RB_AQL_CNTL__AQL_PACKET_SIZE_MASK                                                          0x000000FEL
#define SDMA1_PAGE_RB_AQL_CNTL__PACKET_STEP_MASK                                                              0x0000FF00L
#define SDMA1_PAGE_RB_AQL_CNTL__MIDCMD_PREEMPT_ENABLE_MASK                                                    0x00010000L
#define SDMA1_PAGE_RB_AQL_CNTL__MIDCMD_PREEMPT_DATA_RESTORE_MASK                                              0x00020000L
#define SDMA1_PAGE_RB_AQL_CNTL__OVERLAP_ENABLE_MASK                                                           0x00040000L
//SDMA1_PAGE_MINOR_PTR_UPDATE
#define SDMA1_PAGE_MINOR_PTR_UPDATE__ENABLE__SHIFT                                                            0x0
#define SDMA1_PAGE_MINOR_PTR_UPDATE__ENABLE_MASK                                                              0x00000001L
//SDMA1_PAGE_MIDCMD_DATA0
#define SDMA1_PAGE_MIDCMD_DATA0__DATA0__SHIFT                                                                 0x0
#define SDMA1_PAGE_MIDCMD_DATA0__DATA0_MASK                                                                   0xFFFFFFFFL
//SDMA1_PAGE_MIDCMD_DATA1
#define SDMA1_PAGE_MIDCMD_DATA1__DATA1__SHIFT                                                                 0x0
#define SDMA1_PAGE_MIDCMD_DATA1__DATA1_MASK                                                                   0xFFFFFFFFL
//SDMA1_PAGE_MIDCMD_DATA2
#define SDMA1_PAGE_MIDCMD_DATA2__DATA2__SHIFT                                                                 0x0
#define SDMA1_PAGE_MIDCMD_DATA2__DATA2_MASK                                                                   0xFFFFFFFFL
//SDMA1_PAGE_MIDCMD_DATA3
#define SDMA1_PAGE_MIDCMD_DATA3__DATA3__SHIFT                                                                 0x0
#define SDMA1_PAGE_MIDCMD_DATA3__DATA3_MASK                                                                   0xFFFFFFFFL
//SDMA1_PAGE_MIDCMD_DATA4
#define SDMA1_PAGE_MIDCMD_DATA4__DATA4__SHIFT                                                                 0x0
#define SDMA1_PAGE_MIDCMD_DATA4__DATA4_MASK                                                                   0xFFFFFFFFL
//SDMA1_PAGE_MIDCMD_DATA5
#define SDMA1_PAGE_MIDCMD_DATA5__DATA5__SHIFT                                                                 0x0
#define SDMA1_PAGE_MIDCMD_DATA5__DATA5_MASK                                                                   0xFFFFFFFFL
//SDMA1_PAGE_MIDCMD_DATA6
#define SDMA1_PAGE_MIDCMD_DATA6__DATA6__SHIFT                                                                 0x0
#define SDMA1_PAGE_MIDCMD_DATA6__DATA6_MASK                                                                   0xFFFFFFFFL
//SDMA1_PAGE_MIDCMD_DATA7
#define SDMA1_PAGE_MIDCMD_DATA7__DATA7__SHIFT                                                                 0x0
#define SDMA1_PAGE_MIDCMD_DATA7__DATA7_MASK                                                                   0xFFFFFFFFL
//SDMA1_PAGE_MIDCMD_DATA8
#define SDMA1_PAGE_MIDCMD_DATA8__DATA8__SHIFT                                                                 0x0
#define SDMA1_PAGE_MIDCMD_DATA8__DATA8_MASK                                                                   0xFFFFFFFFL
//SDMA1_PAGE_MIDCMD_DATA9
#define SDMA1_PAGE_MIDCMD_DATA9__DATA9__SHIFT                                                                 0x0
#define SDMA1_PAGE_MIDCMD_DATA9__DATA9_MASK                                                                   0xFFFFFFFFL
//SDMA1_PAGE_MIDCMD_DATA10
#define SDMA1_PAGE_MIDCMD_DATA10__DATA10__SHIFT                                                               0x0
#define SDMA1_PAGE_MIDCMD_DATA10__DATA10_MASK                                                                 0xFFFFFFFFL
//SDMA1_PAGE_MIDCMD_CNTL
#define SDMA1_PAGE_MIDCMD_CNTL__DATA_VALID__SHIFT                                                             0x0
#define SDMA1_PAGE_MIDCMD_CNTL__COPY_MODE__SHIFT                                                              0x1
#define SDMA1_PAGE_MIDCMD_CNTL__SPLIT_STATE__SHIFT                                                            0x4
#define SDMA1_PAGE_MIDCMD_CNTL__ALLOW_PREEMPT__SHIFT                                                          0x8
#define SDMA1_PAGE_MIDCMD_CNTL__DATA_VALID_MASK                                                               0x00000001L
#define SDMA1_PAGE_MIDCMD_CNTL__COPY_MODE_MASK                                                                0x00000002L
#define SDMA1_PAGE_MIDCMD_CNTL__SPLIT_STATE_MASK                                                              0x000000F0L
#define SDMA1_PAGE_MIDCMD_CNTL__ALLOW_PREEMPT_MASK                                                            0x00000100L
//SDMA1_RLC0_RB_CNTL
#define SDMA1_RLC0_RB_CNTL__RB_ENABLE__SHIFT                                                                  0x0
#define SDMA1_RLC0_RB_CNTL__RB_SIZE__SHIFT                                                                    0x1
#define SDMA1_RLC0_RB_CNTL__RB_SWAP_ENABLE__SHIFT                                                             0x9
#define SDMA1_RLC0_RB_CNTL__RPTR_WRITEBACK_ENABLE__SHIFT                                                      0xc
#define SDMA1_RLC0_RB_CNTL__RPTR_WRITEBACK_SWAP_ENABLE__SHIFT                                                 0xd
#define SDMA1_RLC0_RB_CNTL__RPTR_WRITEBACK_TIMER__SHIFT                                                       0x10
#define SDMA1_RLC0_RB_CNTL__RB_PRIV__SHIFT                                                                    0x17
#define SDMA1_RLC0_RB_CNTL__RB_VMID__SHIFT                                                                    0x18
#define SDMA1_RLC0_RB_CNTL__RPTR_WB_IDLE__SHIFT                                                               0x1f
#define SDMA1_RLC0_RB_CNTL__RB_ENABLE_MASK                                                                    0x00000001L
#define SDMA1_RLC0_RB_CNTL__RB_SIZE_MASK                                                                      0x0000003EL
#define SDMA1_RLC0_RB_CNTL__RB_SWAP_ENABLE_MASK                                                               0x00000200L
#define SDMA1_RLC0_RB_CNTL__RPTR_WRITEBACK_ENABLE_MASK                                                        0x00001000L
#define SDMA1_RLC0_RB_CNTL__RPTR_WRITEBACK_SWAP_ENABLE_MASK                                                   0x00002000L
#define SDMA1_RLC0_RB_CNTL__RPTR_WRITEBACK_TIMER_MASK                                                         0x001F0000L
#define SDMA1_RLC0_RB_CNTL__RB_PRIV_MASK                                                                      0x00800000L
#define SDMA1_RLC0_RB_CNTL__RB_VMID_MASK                                                                      0x0F000000L
#define SDMA1_RLC0_RB_CNTL__RPTR_WB_IDLE_MASK                                                                 0x80000000L
//SDMA1_RLC0_RB_BASE
#define SDMA1_RLC0_RB_BASE__ADDR__SHIFT                                                                       0x0
#define SDMA1_RLC0_RB_BASE__ADDR_MASK                                                                         0xFFFFFFFFL
//SDMA1_RLC0_RB_BASE_HI
#define SDMA1_RLC0_RB_BASE_HI__ADDR__SHIFT                                                                    0x0
#define SDMA1_RLC0_RB_BASE_HI__ADDR_MASK                                                                      0x00FFFFFFL
//SDMA1_RLC0_RB_RPTR
#define SDMA1_RLC0_RB_RPTR__OFFSET__SHIFT                                                                     0x0
#define SDMA1_RLC0_RB_RPTR__OFFSET_MASK                                                                       0xFFFFFFFFL
//SDMA1_RLC0_RB_RPTR_HI
#define SDMA1_RLC0_RB_RPTR_HI__OFFSET__SHIFT                                                                  0x0
#define SDMA1_RLC0_RB_RPTR_HI__OFFSET_MASK                                                                    0xFFFFFFFFL
//SDMA1_RLC0_RB_WPTR
#define SDMA1_RLC0_RB_WPTR__OFFSET__SHIFT                                                                     0x0
#define SDMA1_RLC0_RB_WPTR__OFFSET_MASK                                                                       0xFFFFFFFFL
//SDMA1_RLC0_RB_WPTR_HI
#define SDMA1_RLC0_RB_WPTR_HI__OFFSET__SHIFT                                                                  0x0
#define SDMA1_RLC0_RB_WPTR_HI__OFFSET_MASK                                                                    0xFFFFFFFFL
//SDMA1_RLC0_RB_WPTR_POLL_CNTL
#define SDMA1_RLC0_RB_WPTR_POLL_CNTL__ENABLE__SHIFT                                                           0x0
#define SDMA1_RLC0_RB_WPTR_POLL_CNTL__SWAP_ENABLE__SHIFT                                                      0x1
#define SDMA1_RLC0_RB_WPTR_POLL_CNTL__F32_POLL_ENABLE__SHIFT                                                  0x2
#define SDMA1_RLC0_RB_WPTR_POLL_CNTL__FREQUENCY__SHIFT                                                        0x4
#define SDMA1_RLC0_RB_WPTR_POLL_CNTL__IDLE_POLL_COUNT__SHIFT                                                  0x10
#define SDMA1_RLC0_RB_WPTR_POLL_CNTL__ENABLE_MASK                                                             0x00000001L
#define SDMA1_RLC0_RB_WPTR_POLL_CNTL__SWAP_ENABLE_MASK                                                        0x00000002L
#define SDMA1_RLC0_RB_WPTR_POLL_CNTL__F32_POLL_ENABLE_MASK                                                    0x00000004L
#define SDMA1_RLC0_RB_WPTR_POLL_CNTL__FREQUENCY_MASK                                                          0x0000FFF0L
#define SDMA1_RLC0_RB_WPTR_POLL_CNTL__IDLE_POLL_COUNT_MASK                                                    0xFFFF0000L
//SDMA1_RLC0_RB_RPTR_ADDR_HI
#define SDMA1_RLC0_RB_RPTR_ADDR_HI__ADDR__SHIFT                                                               0x0
#define SDMA1_RLC0_RB_RPTR_ADDR_HI__ADDR_MASK                                                                 0xFFFFFFFFL
//SDMA1_RLC0_RB_RPTR_ADDR_LO
#define SDMA1_RLC0_RB_RPTR_ADDR_LO__ADDR__SHIFT                                                               0x2
#define SDMA1_RLC0_RB_RPTR_ADDR_LO__ADDR_MASK                                                                 0xFFFFFFFCL
//SDMA1_RLC0_IB_CNTL
#define SDMA1_RLC0_IB_CNTL__IB_ENABLE__SHIFT                                                                  0x0
#define SDMA1_RLC0_IB_CNTL__IB_SWAP_ENABLE__SHIFT                                                             0x4
#define SDMA1_RLC0_IB_CNTL__SWITCH_INSIDE_IB__SHIFT                                                           0x8
#define SDMA1_RLC0_IB_CNTL__CMD_VMID__SHIFT                                                                   0x10
#define SDMA1_RLC0_IB_CNTL__IB_ENABLE_MASK                                                                    0x00000001L
#define SDMA1_RLC0_IB_CNTL__IB_SWAP_ENABLE_MASK                                                               0x00000010L
#define SDMA1_RLC0_IB_CNTL__SWITCH_INSIDE_IB_MASK                                                             0x00000100L
#define SDMA1_RLC0_IB_CNTL__CMD_VMID_MASK                                                                     0x000F0000L
//SDMA1_RLC0_IB_RPTR
#define SDMA1_RLC0_IB_RPTR__OFFSET__SHIFT                                                                     0x2
#define SDMA1_RLC0_IB_RPTR__OFFSET_MASK                                                                       0x003FFFFCL
//SDMA1_RLC0_IB_OFFSET
#define SDMA1_RLC0_IB_OFFSET__OFFSET__SHIFT                                                                   0x2
#define SDMA1_RLC0_IB_OFFSET__OFFSET_MASK                                                                     0x003FFFFCL
//SDMA1_RLC0_IB_BASE_LO
#define SDMA1_RLC0_IB_BASE_LO__ADDR__SHIFT                                                                    0x5
#define SDMA1_RLC0_IB_BASE_LO__ADDR_MASK                                                                      0xFFFFFFE0L
//SDMA1_RLC0_IB_BASE_HI
#define SDMA1_RLC0_IB_BASE_HI__ADDR__SHIFT                                                                    0x0
#define SDMA1_RLC0_IB_BASE_HI__ADDR_MASK                                                                      0xFFFFFFFFL
//SDMA1_RLC0_IB_SIZE
#define SDMA1_RLC0_IB_SIZE__SIZE__SHIFT                                                                       0x0
#define SDMA1_RLC0_IB_SIZE__SIZE_MASK                                                                         0x000FFFFFL
//SDMA1_RLC0_SKIP_CNTL
#define SDMA1_RLC0_SKIP_CNTL__SKIP_COUNT__SHIFT                                                               0x0
#define SDMA1_RLC0_SKIP_CNTL__SKIP_COUNT_MASK                                                                 0x000FFFFFL
//SDMA1_RLC0_CONTEXT_STATUS
#define SDMA1_RLC0_CONTEXT_STATUS__SELECTED__SHIFT                                                            0x0
#define SDMA1_RLC0_CONTEXT_STATUS__IDLE__SHIFT                                                                0x2
#define SDMA1_RLC0_CONTEXT_STATUS__EXPIRED__SHIFT                                                             0x3
#define SDMA1_RLC0_CONTEXT_STATUS__EXCEPTION__SHIFT                                                           0x4
#define SDMA1_RLC0_CONTEXT_STATUS__CTXSW_ABLE__SHIFT                                                          0x7
#define SDMA1_RLC0_CONTEXT_STATUS__CTXSW_READY__SHIFT                                                         0x8
#define SDMA1_RLC0_CONTEXT_STATUS__PREEMPTED__SHIFT                                                           0x9
#define SDMA1_RLC0_CONTEXT_STATUS__PREEMPT_DISABLE__SHIFT                                                     0xa
#define SDMA1_RLC0_CONTEXT_STATUS__SELECTED_MASK                                                              0x00000001L
#define SDMA1_RLC0_CONTEXT_STATUS__IDLE_MASK                                                                  0x00000004L
#define SDMA1_RLC0_CONTEXT_STATUS__EXPIRED_MASK                                                               0x00000008L
#define SDMA1_RLC0_CONTEXT_STATUS__EXCEPTION_MASK                                                             0x00000070L
#define SDMA1_RLC0_CONTEXT_STATUS__CTXSW_ABLE_MASK                                                            0x00000080L
#define SDMA1_RLC0_CONTEXT_STATUS__CTXSW_READY_MASK                                                           0x00000100L
#define SDMA1_RLC0_CONTEXT_STATUS__PREEMPTED_MASK                                                             0x00000200L
#define SDMA1_RLC0_CONTEXT_STATUS__PREEMPT_DISABLE_MASK                                                       0x00000400L
//SDMA1_RLC0_DOORBELL
#define SDMA1_RLC0_DOORBELL__ENABLE__SHIFT                                                                    0x1c
#define SDMA1_RLC0_DOORBELL__CAPTURED__SHIFT                                                                  0x1e
#define SDMA1_RLC0_DOORBELL__ENABLE_MASK                                                                      0x10000000L
#define SDMA1_RLC0_DOORBELL__CAPTURED_MASK                                                                    0x40000000L
//SDMA1_RLC0_STATUS
#define SDMA1_RLC0_STATUS__WPTR_UPDATE_FAIL_COUNT__SHIFT                                                      0x0
#define SDMA1_RLC0_STATUS__WPTR_UPDATE_PENDING__SHIFT                                                         0x8
#define SDMA1_RLC0_STATUS__WPTR_UPDATE_FAIL_COUNT_MASK                                                        0x000000FFL
#define SDMA1_RLC0_STATUS__WPTR_UPDATE_PENDING_MASK                                                           0x00000100L
//SDMA1_RLC0_DOORBELL_LOG
#define SDMA1_RLC0_DOORBELL_LOG__BE_ERROR__SHIFT                                                              0x0
#define SDMA1_RLC0_DOORBELL_LOG__DATA__SHIFT                                                                  0x2
#define SDMA1_RLC0_DOORBELL_LOG__BE_ERROR_MASK                                                                0x00000001L
#define SDMA1_RLC0_DOORBELL_LOG__DATA_MASK                                                                    0xFFFFFFFCL
//SDMA1_RLC0_WATERMARK
#define SDMA1_RLC0_WATERMARK__RD_OUTSTANDING__SHIFT                                                           0x0
#define SDMA1_RLC0_WATERMARK__WR_OUTSTANDING__SHIFT                                                           0x10
#define SDMA1_RLC0_WATERMARK__RD_OUTSTANDING_MASK                                                             0x00000FFFL
#define SDMA1_RLC0_WATERMARK__WR_OUTSTANDING_MASK                                                             0x03FF0000L
//SDMA1_RLC0_DOORBELL_OFFSET
#define SDMA1_RLC0_DOORBELL_OFFSET__OFFSET__SHIFT                                                             0x2
#define SDMA1_RLC0_DOORBELL_OFFSET__OFFSET_MASK                                                               0x0FFFFFFCL
//SDMA1_RLC0_CSA_ADDR_LO
#define SDMA1_RLC0_CSA_ADDR_LO__ADDR__SHIFT                                                                   0x2
#define SDMA1_RLC0_CSA_ADDR_LO__ADDR_MASK                                                                     0xFFFFFFFCL
//SDMA1_RLC0_CSA_ADDR_HI
#define SDMA1_RLC0_CSA_ADDR_HI__ADDR__SHIFT                                                                   0x0
#define SDMA1_RLC0_CSA_ADDR_HI__ADDR_MASK                                                                     0xFFFFFFFFL
//SDMA1_RLC0_IB_SUB_REMAIN
#define SDMA1_RLC0_IB_SUB_REMAIN__SIZE__SHIFT                                                                 0x0
#define SDMA1_RLC0_IB_SUB_REMAIN__SIZE_MASK                                                                   0x00003FFFL
//SDMA1_RLC0_PREEMPT
#define SDMA1_RLC0_PREEMPT__IB_PREEMPT__SHIFT                                                                 0x0
#define SDMA1_RLC0_PREEMPT__IB_PREEMPT_MASK                                                                   0x00000001L
//SDMA1_RLC0_DUMMY_REG
#define SDMA1_RLC0_DUMMY_REG__DUMMY__SHIFT                                                                    0x0
#define SDMA1_RLC0_DUMMY_REG__DUMMY_MASK                                                                      0xFFFFFFFFL
//SDMA1_RLC0_RB_WPTR_POLL_ADDR_HI
#define SDMA1_RLC0_RB_WPTR_POLL_ADDR_HI__ADDR__SHIFT                                                          0x0
#define SDMA1_RLC0_RB_WPTR_POLL_ADDR_HI__ADDR_MASK                                                            0xFFFFFFFFL
//SDMA1_RLC0_RB_WPTR_POLL_ADDR_LO
#define SDMA1_RLC0_RB_WPTR_POLL_ADDR_LO__ADDR__SHIFT                                                          0x2
#define SDMA1_RLC0_RB_WPTR_POLL_ADDR_LO__ADDR_MASK                                                            0xFFFFFFFCL
//SDMA1_RLC0_RB_AQL_CNTL
#define SDMA1_RLC0_RB_AQL_CNTL__AQL_ENABLE__SHIFT                                                             0x0
#define SDMA1_RLC0_RB_AQL_CNTL__AQL_PACKET_SIZE__SHIFT                                                        0x1
#define SDMA1_RLC0_RB_AQL_CNTL__PACKET_STEP__SHIFT                                                            0x8
#define SDMA1_RLC0_RB_AQL_CNTL__MIDCMD_PREEMPT_ENABLE__SHIFT                                                  0x10
#define SDMA1_RLC0_RB_AQL_CNTL__MIDCMD_PREEMPT_DATA_RESTORE__SHIFT                                            0x11
#define SDMA1_RLC0_RB_AQL_CNTL__OVERLAP_ENABLE__SHIFT                                                         0x12
#define SDMA1_RLC0_RB_AQL_CNTL__AQL_ENABLE_MASK                                                               0x00000001L
#define SDMA1_RLC0_RB_AQL_CNTL__AQL_PACKET_SIZE_MASK                                                          0x000000FEL
#define SDMA1_RLC0_RB_AQL_CNTL__PACKET_STEP_MASK                                                              0x0000FF00L
#define SDMA1_RLC0_RB_AQL_CNTL__MIDCMD_PREEMPT_ENABLE_MASK                                                    0x00010000L
#define SDMA1_RLC0_RB_AQL_CNTL__MIDCMD_PREEMPT_DATA_RESTORE_MASK                                              0x00020000L
#define SDMA1_RLC0_RB_AQL_CNTL__OVERLAP_ENABLE_MASK                                                           0x00040000L
//SDMA1_RLC0_MINOR_PTR_UPDATE
#define SDMA1_RLC0_MINOR_PTR_UPDATE__ENABLE__SHIFT                                                            0x0
#define SDMA1_RLC0_MINOR_PTR_UPDATE__ENABLE_MASK                                                              0x00000001L
//SDMA1_RLC0_MIDCMD_DATA0
#define SDMA1_RLC0_MIDCMD_DATA0__DATA0__SHIFT                                                                 0x0
#define SDMA1_RLC0_MIDCMD_DATA0__DATA0_MASK                                                                   0xFFFFFFFFL
//SDMA1_RLC0_MIDCMD_DATA1
#define SDMA1_RLC0_MIDCMD_DATA1__DATA1__SHIFT                                                                 0x0
#define SDMA1_RLC0_MIDCMD_DATA1__DATA1_MASK                                                                   0xFFFFFFFFL
//SDMA1_RLC0_MIDCMD_DATA2
#define SDMA1_RLC0_MIDCMD_DATA2__DATA2__SHIFT                                                                 0x0
#define SDMA1_RLC0_MIDCMD_DATA2__DATA2_MASK                                                                   0xFFFFFFFFL
//SDMA1_RLC0_MIDCMD_DATA3
#define SDMA1_RLC0_MIDCMD_DATA3__DATA3__SHIFT                                                                 0x0
#define SDMA1_RLC0_MIDCMD_DATA3__DATA3_MASK                                                                   0xFFFFFFFFL
//SDMA1_RLC0_MIDCMD_DATA4
#define SDMA1_RLC0_MIDCMD_DATA4__DATA4__SHIFT                                                                 0x0
#define SDMA1_RLC0_MIDCMD_DATA4__DATA4_MASK                                                                   0xFFFFFFFFL
//SDMA1_RLC0_MIDCMD_DATA5
#define SDMA1_RLC0_MIDCMD_DATA5__DATA5__SHIFT                                                                 0x0
#define SDMA1_RLC0_MIDCMD_DATA5__DATA5_MASK                                                                   0xFFFFFFFFL
//SDMA1_RLC0_MIDCMD_DATA6
#define SDMA1_RLC0_MIDCMD_DATA6__DATA6__SHIFT                                                                 0x0
#define SDMA1_RLC0_MIDCMD_DATA6__DATA6_MASK                                                                   0xFFFFFFFFL
//SDMA1_RLC0_MIDCMD_DATA7
#define SDMA1_RLC0_MIDCMD_DATA7__DATA7__SHIFT                                                                 0x0
#define SDMA1_RLC0_MIDCMD_DATA7__DATA7_MASK                                                                   0xFFFFFFFFL
//SDMA1_RLC0_MIDCMD_DATA8
#define SDMA1_RLC0_MIDCMD_DATA8__DATA8__SHIFT                                                                 0x0
#define SDMA1_RLC0_MIDCMD_DATA8__DATA8_MASK                                                                   0xFFFFFFFFL
//SDMA1_RLC0_MIDCMD_DATA9
#define SDMA1_RLC0_MIDCMD_DATA9__DATA9__SHIFT                                                                 0x0
#define SDMA1_RLC0_MIDCMD_DATA9__DATA9_MASK                                                                   0xFFFFFFFFL
//SDMA1_RLC0_MIDCMD_DATA10
#define SDMA1_RLC0_MIDCMD_DATA10__DATA10__SHIFT                                                               0x0
#define SDMA1_RLC0_MIDCMD_DATA10__DATA10_MASK                                                                 0xFFFFFFFFL
//SDMA1_RLC0_MIDCMD_CNTL
#define SDMA1_RLC0_MIDCMD_CNTL__DATA_VALID__SHIFT                                                             0x0
#define SDMA1_RLC0_MIDCMD_CNTL__COPY_MODE__SHIFT                                                              0x1
#define SDMA1_RLC0_MIDCMD_CNTL__SPLIT_STATE__SHIFT                                                            0x4
#define SDMA1_RLC0_MIDCMD_CNTL__ALLOW_PREEMPT__SHIFT                                                          0x8
#define SDMA1_RLC0_MIDCMD_CNTL__DATA_VALID_MASK                                                               0x00000001L
#define SDMA1_RLC0_MIDCMD_CNTL__COPY_MODE_MASK                                                                0x00000002L
#define SDMA1_RLC0_MIDCMD_CNTL__SPLIT_STATE_MASK                                                              0x000000F0L
#define SDMA1_RLC0_MIDCMD_CNTL__ALLOW_PREEMPT_MASK                                                            0x00000100L
//SDMA1_RLC1_RB_CNTL
#define SDMA1_RLC1_RB_CNTL__RB_ENABLE__SHIFT                                                                  0x0
#define SDMA1_RLC1_RB_CNTL__RB_SIZE__SHIFT                                                                    0x1
#define SDMA1_RLC1_RB_CNTL__RB_SWAP_ENABLE__SHIFT                                                             0x9
#define SDMA1_RLC1_RB_CNTL__RPTR_WRITEBACK_ENABLE__SHIFT                                                      0xc
#define SDMA1_RLC1_RB_CNTL__RPTR_WRITEBACK_SWAP_ENABLE__SHIFT                                                 0xd
#define SDMA1_RLC1_RB_CNTL__RPTR_WRITEBACK_TIMER__SHIFT                                                       0x10
#define SDMA1_RLC1_RB_CNTL__RB_PRIV__SHIFT                                                                    0x17
#define SDMA1_RLC1_RB_CNTL__RB_VMID__SHIFT                                                                    0x18
#define SDMA1_RLC1_RB_CNTL__RPTR_WB_IDLE__SHIFT                                                               0x1f
#define SDMA1_RLC1_RB_CNTL__RB_ENABLE_MASK                                                                    0x00000001L
#define SDMA1_RLC1_RB_CNTL__RB_SIZE_MASK                                                                      0x0000003EL
#define SDMA1_RLC1_RB_CNTL__RB_SWAP_ENABLE_MASK                                                               0x00000200L
#define SDMA1_RLC1_RB_CNTL__RPTR_WRITEBACK_ENABLE_MASK                                                        0x00001000L
#define SDMA1_RLC1_RB_CNTL__RPTR_WRITEBACK_SWAP_ENABLE_MASK                                                   0x00002000L
#define SDMA1_RLC1_RB_CNTL__RPTR_WRITEBACK_TIMER_MASK                                                         0x001F0000L
#define SDMA1_RLC1_RB_CNTL__RB_PRIV_MASK                                                                      0x00800000L
#define SDMA1_RLC1_RB_CNTL__RB_VMID_MASK                                                                      0x0F000000L
#define SDMA1_RLC1_RB_CNTL__RPTR_WB_IDLE_MASK                                                                 0x80000000L
//SDMA1_RLC1_RB_BASE
#define SDMA1_RLC1_RB_BASE__ADDR__SHIFT                                                                       0x0
#define SDMA1_RLC1_RB_BASE__ADDR_MASK                                                                         0xFFFFFFFFL
//SDMA1_RLC1_RB_BASE_HI
#define SDMA1_RLC1_RB_BASE_HI__ADDR__SHIFT                                                                    0x0
#define SDMA1_RLC1_RB_BASE_HI__ADDR_MASK                                                                      0x00FFFFFFL
//SDMA1_RLC1_RB_RPTR
#define SDMA1_RLC1_RB_RPTR__OFFSET__SHIFT                                                                     0x0
#define SDMA1_RLC1_RB_RPTR__OFFSET_MASK                                                                       0xFFFFFFFFL
//SDMA1_RLC1_RB_RPTR_HI
#define SDMA1_RLC1_RB_RPTR_HI__OFFSET__SHIFT                                                                  0x0
#define SDMA1_RLC1_RB_RPTR_HI__OFFSET_MASK                                                                    0xFFFFFFFFL
//SDMA1_RLC1_RB_WPTR
#define SDMA1_RLC1_RB_WPTR__OFFSET__SHIFT                                                                     0x0
#define SDMA1_RLC1_RB_WPTR__OFFSET_MASK                                                                       0xFFFFFFFFL
//SDMA1_RLC1_RB_WPTR_HI
#define SDMA1_RLC1_RB_WPTR_HI__OFFSET__SHIFT                                                                  0x0
#define SDMA1_RLC1_RB_WPTR_HI__OFFSET_MASK                                                                    0xFFFFFFFFL
//SDMA1_RLC1_RB_WPTR_POLL_CNTL
#define SDMA1_RLC1_RB_WPTR_POLL_CNTL__ENABLE__SHIFT                                                           0x0
#define SDMA1_RLC1_RB_WPTR_POLL_CNTL__SWAP_ENABLE__SHIFT                                                      0x1
#define SDMA1_RLC1_RB_WPTR_POLL_CNTL__F32_POLL_ENABLE__SHIFT                                                  0x2
#define SDMA1_RLC1_RB_WPTR_POLL_CNTL__FREQUENCY__SHIFT                                                        0x4
#define SDMA1_RLC1_RB_WPTR_POLL_CNTL__IDLE_POLL_COUNT__SHIFT                                                  0x10
#define SDMA1_RLC1_RB_WPTR_POLL_CNTL__ENABLE_MASK                                                             0x00000001L
#define SDMA1_RLC1_RB_WPTR_POLL_CNTL__SWAP_ENABLE_MASK                                                        0x00000002L
#define SDMA1_RLC1_RB_WPTR_POLL_CNTL__F32_POLL_ENABLE_MASK                                                    0x00000004L
#define SDMA1_RLC1_RB_WPTR_POLL_CNTL__FREQUENCY_MASK                                                          0x0000FFF0L
#define SDMA1_RLC1_RB_WPTR_POLL_CNTL__IDLE_POLL_COUNT_MASK                                                    0xFFFF0000L
//SDMA1_RLC1_RB_RPTR_ADDR_HI
#define SDMA1_RLC1_RB_RPTR_ADDR_HI__ADDR__SHIFT                                                               0x0
#define SDMA1_RLC1_RB_RPTR_ADDR_HI__ADDR_MASK                                                                 0xFFFFFFFFL
//SDMA1_RLC1_RB_RPTR_ADDR_LO
#define SDMA1_RLC1_RB_RPTR_ADDR_LO__ADDR__SHIFT                                                               0x2
#define SDMA1_RLC1_RB_RPTR_ADDR_LO__ADDR_MASK                                                                 0xFFFFFFFCL
//SDMA1_RLC1_IB_CNTL
#define SDMA1_RLC1_IB_CNTL__IB_ENABLE__SHIFT                                                                  0x0
#define SDMA1_RLC1_IB_CNTL__IB_SWAP_ENABLE__SHIFT                                                             0x4
#define SDMA1_RLC1_IB_CNTL__SWITCH_INSIDE_IB__SHIFT                                                           0x8
#define SDMA1_RLC1_IB_CNTL__CMD_VMID__SHIFT                                                                   0x10
#define SDMA1_RLC1_IB_CNTL__IB_ENABLE_MASK                                                                    0x00000001L
#define SDMA1_RLC1_IB_CNTL__IB_SWAP_ENABLE_MASK                                                               0x00000010L
#define SDMA1_RLC1_IB_CNTL__SWITCH_INSIDE_IB_MASK                                                             0x00000100L
#define SDMA1_RLC1_IB_CNTL__CMD_VMID_MASK                                                                     0x000F0000L
//SDMA1_RLC1_IB_RPTR
#define SDMA1_RLC1_IB_RPTR__OFFSET__SHIFT                                                                     0x2
#define SDMA1_RLC1_IB_RPTR__OFFSET_MASK                                                                       0x003FFFFCL
//SDMA1_RLC1_IB_OFFSET
#define SDMA1_RLC1_IB_OFFSET__OFFSET__SHIFT                                                                   0x2
#define SDMA1_RLC1_IB_OFFSET__OFFSET_MASK                                                                     0x003FFFFCL
//SDMA1_RLC1_IB_BASE_LO
#define SDMA1_RLC1_IB_BASE_LO__ADDR__SHIFT                                                                    0x5
#define SDMA1_RLC1_IB_BASE_LO__ADDR_MASK                                                                      0xFFFFFFE0L
//SDMA1_RLC1_IB_BASE_HI
#define SDMA1_RLC1_IB_BASE_HI__ADDR__SHIFT                                                                    0x0
#define SDMA1_RLC1_IB_BASE_HI__ADDR_MASK                                                                      0xFFFFFFFFL
//SDMA1_RLC1_IB_SIZE
#define SDMA1_RLC1_IB_SIZE__SIZE__SHIFT                                                                       0x0
#define SDMA1_RLC1_IB_SIZE__SIZE_MASK                                                                         0x000FFFFFL
//SDMA1_RLC1_SKIP_CNTL
#define SDMA1_RLC1_SKIP_CNTL__SKIP_COUNT__SHIFT                                                               0x0
#define SDMA1_RLC1_SKIP_CNTL__SKIP_COUNT_MASK                                                                 0x000FFFFFL
//SDMA1_RLC1_CONTEXT_STATUS
#define SDMA1_RLC1_CONTEXT_STATUS__SELECTED__SHIFT                                                            0x0
#define SDMA1_RLC1_CONTEXT_STATUS__IDLE__SHIFT                                                                0x2
#define SDMA1_RLC1_CONTEXT_STATUS__EXPIRED__SHIFT                                                             0x3
#define SDMA1_RLC1_CONTEXT_STATUS__EXCEPTION__SHIFT                                                           0x4
#define SDMA1_RLC1_CONTEXT_STATUS__CTXSW_ABLE__SHIFT                                                          0x7
#define SDMA1_RLC1_CONTEXT_STATUS__CTXSW_READY__SHIFT                                                         0x8
#define SDMA1_RLC1_CONTEXT_STATUS__PREEMPTED__SHIFT                                                           0x9
#define SDMA1_RLC1_CONTEXT_STATUS__PREEMPT_DISABLE__SHIFT                                                     0xa
#define SDMA1_RLC1_CONTEXT_STATUS__SELECTED_MASK                                                              0x00000001L
#define SDMA1_RLC1_CONTEXT_STATUS__IDLE_MASK                                                                  0x00000004L
#define SDMA1_RLC1_CONTEXT_STATUS__EXPIRED_MASK                                                               0x00000008L
#define SDMA1_RLC1_CONTEXT_STATUS__EXCEPTION_MASK                                                             0x00000070L
#define SDMA1_RLC1_CONTEXT_STATUS__CTXSW_ABLE_MASK                                                            0x00000080L
#define SDMA1_RLC1_CONTEXT_STATUS__CTXSW_READY_MASK                                                           0x00000100L
#define SDMA1_RLC1_CONTEXT_STATUS__PREEMPTED_MASK                                                             0x00000200L
#define SDMA1_RLC1_CONTEXT_STATUS__PREEMPT_DISABLE_MASK                                                       0x00000400L
//SDMA1_RLC1_DOORBELL
#define SDMA1_RLC1_DOORBELL__ENABLE__SHIFT                                                                    0x1c
#define SDMA1_RLC1_DOORBELL__CAPTURED__SHIFT                                                                  0x1e
#define SDMA1_RLC1_DOORBELL__ENABLE_MASK                                                                      0x10000000L
#define SDMA1_RLC1_DOORBELL__CAPTURED_MASK                                                                    0x40000000L
//SDMA1_RLC1_STATUS
#define SDMA1_RLC1_STATUS__WPTR_UPDATE_FAIL_COUNT__SHIFT                                                      0x0
#define SDMA1_RLC1_STATUS__WPTR_UPDATE_PENDING__SHIFT                                                         0x8
#define SDMA1_RLC1_STATUS__WPTR_UPDATE_FAIL_COUNT_MASK                                                        0x000000FFL
#define SDMA1_RLC1_STATUS__WPTR_UPDATE_PENDING_MASK                                                           0x00000100L
//SDMA1_RLC1_DOORBELL_LOG
#define SDMA1_RLC1_DOORBELL_LOG__BE_ERROR__SHIFT                                                              0x0
#define SDMA1_RLC1_DOORBELL_LOG__DATA__SHIFT                                                                  0x2
#define SDMA1_RLC1_DOORBELL_LOG__BE_ERROR_MASK                                                                0x00000001L
#define SDMA1_RLC1_DOORBELL_LOG__DATA_MASK                                                                    0xFFFFFFFCL
//SDMA1_RLC1_WATERMARK
#define SDMA1_RLC1_WATERMARK__RD_OUTSTANDING__SHIFT                                                           0x0
#define SDMA1_RLC1_WATERMARK__WR_OUTSTANDING__SHIFT                                                           0x10
#define SDMA1_RLC1_WATERMARK__RD_OUTSTANDING_MASK                                                             0x00000FFFL
#define SDMA1_RLC1_WATERMARK__WR_OUTSTANDING_MASK                                                             0x03FF0000L
//SDMA1_RLC1_DOORBELL_OFFSET
#define SDMA1_RLC1_DOORBELL_OFFSET__OFFSET__SHIFT                                                             0x2
#define SDMA1_RLC1_DOORBELL_OFFSET__OFFSET_MASK                                                               0x0FFFFFFCL
//SDMA1_RLC1_CSA_ADDR_LO
#define SDMA1_RLC1_CSA_ADDR_LO__ADDR__SHIFT                                                                   0x2
#define SDMA1_RLC1_CSA_ADDR_LO__ADDR_MASK                                                                     0xFFFFFFFCL
//SDMA1_RLC1_CSA_ADDR_HI
#define SDMA1_RLC1_CSA_ADDR_HI__ADDR__SHIFT                                                                   0x0
#define SDMA1_RLC1_CSA_ADDR_HI__ADDR_MASK                                                                     0xFFFFFFFFL
//SDMA1_RLC1_IB_SUB_REMAIN
#define SDMA1_RLC1_IB_SUB_REMAIN__SIZE__SHIFT                                                                 0x0
#define SDMA1_RLC1_IB_SUB_REMAIN__SIZE_MASK                                                                   0x00003FFFL
//SDMA1_RLC1_PREEMPT
#define SDMA1_RLC1_PREEMPT__IB_PREEMPT__SHIFT                                                                 0x0
#define SDMA1_RLC1_PREEMPT__IB_PREEMPT_MASK                                                                   0x00000001L
//SDMA1_RLC1_DUMMY_REG
#define SDMA1_RLC1_DUMMY_REG__DUMMY__SHIFT                                                                    0x0
#define SDMA1_RLC1_DUMMY_REG__DUMMY_MASK                                                                      0xFFFFFFFFL
//SDMA1_RLC1_RB_WPTR_POLL_ADDR_HI
#define SDMA1_RLC1_RB_WPTR_POLL_ADDR_HI__ADDR__SHIFT                                                          0x0
#define SDMA1_RLC1_RB_WPTR_POLL_ADDR_HI__ADDR_MASK                                                            0xFFFFFFFFL
//SDMA1_RLC1_RB_WPTR_POLL_ADDR_LO
#define SDMA1_RLC1_RB_WPTR_POLL_ADDR_LO__ADDR__SHIFT                                                          0x2
#define SDMA1_RLC1_RB_WPTR_POLL_ADDR_LO__ADDR_MASK                                                            0xFFFFFFFCL
//SDMA1_RLC1_RB_AQL_CNTL
#define SDMA1_RLC1_RB_AQL_CNTL__AQL_ENABLE__SHIFT                                                             0x0
#define SDMA1_RLC1_RB_AQL_CNTL__AQL_PACKET_SIZE__SHIFT                                                        0x1
#define SDMA1_RLC1_RB_AQL_CNTL__PACKET_STEP__SHIFT                                                            0x8
#define SDMA1_RLC1_RB_AQL_CNTL__MIDCMD_PREEMPT_ENABLE__SHIFT                                                  0x10
#define SDMA1_RLC1_RB_AQL_CNTL__MIDCMD_PREEMPT_DATA_RESTORE__SHIFT                                            0x11
#define SDMA1_RLC1_RB_AQL_CNTL__OVERLAP_ENABLE__SHIFT                                                         0x12
#define SDMA1_RLC1_RB_AQL_CNTL__AQL_ENABLE_MASK                                                               0x00000001L
#define SDMA1_RLC1_RB_AQL_CNTL__AQL_PACKET_SIZE_MASK                                                          0x000000FEL
#define SDMA1_RLC1_RB_AQL_CNTL__PACKET_STEP_MASK                                                              0x0000FF00L
#define SDMA1_RLC1_RB_AQL_CNTL__MIDCMD_PREEMPT_ENABLE_MASK                                                    0x00010000L
#define SDMA1_RLC1_RB_AQL_CNTL__MIDCMD_PREEMPT_DATA_RESTORE_MASK                                              0x00020000L
#define SDMA1_RLC1_RB_AQL_CNTL__OVERLAP_ENABLE_MASK                                                           0x00040000L
//SDMA1_RLC1_MINOR_PTR_UPDATE
#define SDMA1_RLC1_MINOR_PTR_UPDATE__ENABLE__SHIFT                                                            0x0
#define SDMA1_RLC1_MINOR_PTR_UPDATE__ENABLE_MASK                                                              0x00000001L
//SDMA1_RLC1_MIDCMD_DATA0
#define SDMA1_RLC1_MIDCMD_DATA0__DATA0__SHIFT                                                                 0x0
#define SDMA1_RLC1_MIDCMD_DATA0__DATA0_MASK                                                                   0xFFFFFFFFL
//SDMA1_RLC1_MIDCMD_DATA1
#define SDMA1_RLC1_MIDCMD_DATA1__DATA1__SHIFT                                                                 0x0
#define SDMA1_RLC1_MIDCMD_DATA1__DATA1_MASK                                                                   0xFFFFFFFFL
//SDMA1_RLC1_MIDCMD_DATA2
#define SDMA1_RLC1_MIDCMD_DATA2__DATA2__SHIFT                                                                 0x0
#define SDMA1_RLC1_MIDCMD_DATA2__DATA2_MASK                                                                   0xFFFFFFFFL
//SDMA1_RLC1_MIDCMD_DATA3
#define SDMA1_RLC1_MIDCMD_DATA3__DATA3__SHIFT                                                                 0x0
#define SDMA1_RLC1_MIDCMD_DATA3__DATA3_MASK                                                                   0xFFFFFFFFL
//SDMA1_RLC1_MIDCMD_DATA4
#define SDMA1_RLC1_MIDCMD_DATA4__DATA4__SHIFT                                                                 0x0
#define SDMA1_RLC1_MIDCMD_DATA4__DATA4_MASK                                                                   0xFFFFFFFFL
//SDMA1_RLC1_MIDCMD_DATA5
#define SDMA1_RLC1_MIDCMD_DATA5__DATA5__SHIFT                                                                 0x0
#define SDMA1_RLC1_MIDCMD_DATA5__DATA5_MASK                                                                   0xFFFFFFFFL
//SDMA1_RLC1_MIDCMD_DATA6
#define SDMA1_RLC1_MIDCMD_DATA6__DATA6__SHIFT                                                                 0x0
#define SDMA1_RLC1_MIDCMD_DATA6__DATA6_MASK                                                                   0xFFFFFFFFL
//SDMA1_RLC1_MIDCMD_DATA7
#define SDMA1_RLC1_MIDCMD_DATA7__DATA7__SHIFT                                                                 0x0
#define SDMA1_RLC1_MIDCMD_DATA7__DATA7_MASK                                                                   0xFFFFFFFFL
//SDMA1_RLC1_MIDCMD_DATA8
#define SDMA1_RLC1_MIDCMD_DATA8__DATA8__SHIFT                                                                 0x0
#define SDMA1_RLC1_MIDCMD_DATA8__DATA8_MASK                                                                   0xFFFFFFFFL
//SDMA1_RLC1_MIDCMD_DATA9
#define SDMA1_RLC1_MIDCMD_DATA9__DATA9__SHIFT                                                                 0x0
#define SDMA1_RLC1_MIDCMD_DATA9__DATA9_MASK                                                                   0xFFFFFFFFL
//SDMA1_RLC1_MIDCMD_DATA10
#define SDMA1_RLC1_MIDCMD_DATA10__DATA10__SHIFT                                                               0x0
#define SDMA1_RLC1_MIDCMD_DATA10__DATA10_MASK                                                                 0xFFFFFFFFL
//SDMA1_RLC1_MIDCMD_CNTL
#define SDMA1_RLC1_MIDCMD_CNTL__DATA_VALID__SHIFT                                                             0x0
#define SDMA1_RLC1_MIDCMD_CNTL__COPY_MODE__SHIFT                                                              0x1
#define SDMA1_RLC1_MIDCMD_CNTL__SPLIT_STATE__SHIFT                                                            0x4
#define SDMA1_RLC1_MIDCMD_CNTL__ALLOW_PREEMPT__SHIFT                                                          0x8
#define SDMA1_RLC1_MIDCMD_CNTL__DATA_VALID_MASK                                                               0x00000001L
#define SDMA1_RLC1_MIDCMD_CNTL__COPY_MODE_MASK                                                                0x00000002L
#define SDMA1_RLC1_MIDCMD_CNTL__SPLIT_STATE_MASK                                                              0x000000F0L
#define SDMA1_RLC1_MIDCMD_CNTL__ALLOW_PREEMPT_MASK                                                            0x00000100L
//SDMA1_RLC2_RB_CNTL
#define SDMA1_RLC2_RB_CNTL__RB_ENABLE__SHIFT                                                                  0x0
#define SDMA1_RLC2_RB_CNTL__RB_SIZE__SHIFT                                                                    0x1
#define SDMA1_RLC2_RB_CNTL__RB_SWAP_ENABLE__SHIFT                                                             0x9
#define SDMA1_RLC2_RB_CNTL__RPTR_WRITEBACK_ENABLE__SHIFT                                                      0xc
#define SDMA1_RLC2_RB_CNTL__RPTR_WRITEBACK_SWAP_ENABLE__SHIFT                                                 0xd
#define SDMA1_RLC2_RB_CNTL__RPTR_WRITEBACK_TIMER__SHIFT                                                       0x10
#define SDMA1_RLC2_RB_CNTL__RB_PRIV__SHIFT                                                                    0x17
#define SDMA1_RLC2_RB_CNTL__RB_VMID__SHIFT                                                                    0x18
#define SDMA1_RLC2_RB_CNTL__RPTR_WB_IDLE__SHIFT                                                               0x1f
#define SDMA1_RLC2_RB_CNTL__RB_ENABLE_MASK                                                                    0x00000001L
#define SDMA1_RLC2_RB_CNTL__RB_SIZE_MASK                                                                      0x0000003EL
#define SDMA1_RLC2_RB_CNTL__RB_SWAP_ENABLE_MASK                                                               0x00000200L
#define SDMA1_RLC2_RB_CNTL__RPTR_WRITEBACK_ENABLE_MASK                                                        0x00001000L
#define SDMA1_RLC2_RB_CNTL__RPTR_WRITEBACK_SWAP_ENABLE_MASK                                                   0x00002000L
#define SDMA1_RLC2_RB_CNTL__RPTR_WRITEBACK_TIMER_MASK                                                         0x001F0000L
#define SDMA1_RLC2_RB_CNTL__RB_PRIV_MASK                                                                      0x00800000L
#define SDMA1_RLC2_RB_CNTL__RB_VMID_MASK                                                                      0x0F000000L
#define SDMA1_RLC2_RB_CNTL__RPTR_WB_IDLE_MASK                                                                 0x80000000L
//SDMA1_RLC2_RB_BASE
#define SDMA1_RLC2_RB_BASE__ADDR__SHIFT                                                                       0x0
#define SDMA1_RLC2_RB_BASE__ADDR_MASK                                                                         0xFFFFFFFFL
//SDMA1_RLC2_RB_BASE_HI
#define SDMA1_RLC2_RB_BASE_HI__ADDR__SHIFT                                                                    0x0
#define SDMA1_RLC2_RB_BASE_HI__ADDR_MASK                                                                      0x00FFFFFFL
//SDMA1_RLC2_RB_RPTR
#define SDMA1_RLC2_RB_RPTR__OFFSET__SHIFT                                                                     0x0
#define SDMA1_RLC2_RB_RPTR__OFFSET_MASK                                                                       0xFFFFFFFFL
//SDMA1_RLC2_RB_RPTR_HI
#define SDMA1_RLC2_RB_RPTR_HI__OFFSET__SHIFT                                                                  0x0
#define SDMA1_RLC2_RB_RPTR_HI__OFFSET_MASK                                                                    0xFFFFFFFFL
//SDMA1_RLC2_RB_WPTR
#define SDMA1_RLC2_RB_WPTR__OFFSET__SHIFT                                                                     0x0
#define SDMA1_RLC2_RB_WPTR__OFFSET_MASK                                                                       0xFFFFFFFFL
//SDMA1_RLC2_RB_WPTR_HI
#define SDMA1_RLC2_RB_WPTR_HI__OFFSET__SHIFT                                                                  0x0
#define SDMA1_RLC2_RB_WPTR_HI__OFFSET_MASK                                                                    0xFFFFFFFFL
//SDMA1_RLC2_RB_WPTR_POLL_CNTL
#define SDMA1_RLC2_RB_WPTR_POLL_CNTL__ENABLE__SHIFT                                                           0x0
#define SDMA1_RLC2_RB_WPTR_POLL_CNTL__SWAP_ENABLE__SHIFT                                                      0x1
#define SDMA1_RLC2_RB_WPTR_POLL_CNTL__F32_POLL_ENABLE__SHIFT                                                  0x2
#define SDMA1_RLC2_RB_WPTR_POLL_CNTL__FREQUENCY__SHIFT                                                        0x4
#define SDMA1_RLC2_RB_WPTR_POLL_CNTL__IDLE_POLL_COUNT__SHIFT                                                  0x10
#define SDMA1_RLC2_RB_WPTR_POLL_CNTL__ENABLE_MASK                                                             0x00000001L
#define SDMA1_RLC2_RB_WPTR_POLL_CNTL__SWAP_ENABLE_MASK                                                        0x00000002L
#define SDMA1_RLC2_RB_WPTR_POLL_CNTL__F32_POLL_ENABLE_MASK                                                    0x00000004L
#define SDMA1_RLC2_RB_WPTR_POLL_CNTL__FREQUENCY_MASK                                                          0x0000FFF0L
#define SDMA1_RLC2_RB_WPTR_POLL_CNTL__IDLE_POLL_COUNT_MASK                                                    0xFFFF0000L
//SDMA1_RLC2_RB_RPTR_ADDR_HI
#define SDMA1_RLC2_RB_RPTR_ADDR_HI__ADDR__SHIFT                                                               0x0
#define SDMA1_RLC2_RB_RPTR_ADDR_HI__ADDR_MASK                                                                 0xFFFFFFFFL
//SDMA1_RLC2_RB_RPTR_ADDR_LO
#define SDMA1_RLC2_RB_RPTR_ADDR_LO__ADDR__SHIFT                                                               0x2
#define SDMA1_RLC2_RB_RPTR_ADDR_LO__ADDR_MASK                                                                 0xFFFFFFFCL
//SDMA1_RLC2_IB_CNTL
#define SDMA1_RLC2_IB_CNTL__IB_ENABLE__SHIFT                                                                  0x0
#define SDMA1_RLC2_IB_CNTL__IB_SWAP_ENABLE__SHIFT                                                             0x4
#define SDMA1_RLC2_IB_CNTL__SWITCH_INSIDE_IB__SHIFT                                                           0x8
#define SDMA1_RLC2_IB_CNTL__CMD_VMID__SHIFT                                                                   0x10
#define SDMA1_RLC2_IB_CNTL__IB_ENABLE_MASK                                                                    0x00000001L
#define SDMA1_RLC2_IB_CNTL__IB_SWAP_ENABLE_MASK                                                               0x00000010L
#define SDMA1_RLC2_IB_CNTL__SWITCH_INSIDE_IB_MASK                                                             0x00000100L
#define SDMA1_RLC2_IB_CNTL__CMD_VMID_MASK                                                                     0x000F0000L
//SDMA1_RLC2_IB_RPTR
#define SDMA1_RLC2_IB_RPTR__OFFSET__SHIFT                                                                     0x2
#define SDMA1_RLC2_IB_RPTR__OFFSET_MASK                                                                       0x003FFFFCL
//SDMA1_RLC2_IB_OFFSET
#define SDMA1_RLC2_IB_OFFSET__OFFSET__SHIFT                                                                   0x2
#define SDMA1_RLC2_IB_OFFSET__OFFSET_MASK                                                                     0x003FFFFCL
//SDMA1_RLC2_IB_BASE_LO
#define SDMA1_RLC2_IB_BASE_LO__ADDR__SHIFT                                                                    0x5
#define SDMA1_RLC2_IB_BASE_LO__ADDR_MASK                                                                      0xFFFFFFE0L
//SDMA1_RLC2_IB_BASE_HI
#define SDMA1_RLC2_IB_BASE_HI__ADDR__SHIFT                                                                    0x0
#define SDMA1_RLC2_IB_BASE_HI__ADDR_MASK                                                                      0xFFFFFFFFL
//SDMA1_RLC2_IB_SIZE
#define SDMA1_RLC2_IB_SIZE__SIZE__SHIFT                                                                       0x0
#define SDMA1_RLC2_IB_SIZE__SIZE_MASK                                                                         0x000FFFFFL
//SDMA1_RLC2_SKIP_CNTL
#define SDMA1_RLC2_SKIP_CNTL__SKIP_COUNT__SHIFT                                                               0x0
#define SDMA1_RLC2_SKIP_CNTL__SKIP_COUNT_MASK                                                                 0x000FFFFFL
//SDMA1_RLC2_CONTEXT_STATUS
#define SDMA1_RLC2_CONTEXT_STATUS__SELECTED__SHIFT                                                            0x0
#define SDMA1_RLC2_CONTEXT_STATUS__IDLE__SHIFT                                                                0x2
#define SDMA1_RLC2_CONTEXT_STATUS__EXPIRED__SHIFT                                                             0x3
#define SDMA1_RLC2_CONTEXT_STATUS__EXCEPTION__SHIFT                                                           0x4
#define SDMA1_RLC2_CONTEXT_STATUS__CTXSW_ABLE__SHIFT                                                          0x7
#define SDMA1_RLC2_CONTEXT_STATUS__CTXSW_READY__SHIFT                                                         0x8
#define SDMA1_RLC2_CONTEXT_STATUS__PREEMPTED__SHIFT                                                           0x9
#define SDMA1_RLC2_CONTEXT_STATUS__PREEMPT_DISABLE__SHIFT                                                     0xa
#define SDMA1_RLC2_CONTEXT_STATUS__SELECTED_MASK                                                              0x00000001L
#define SDMA1_RLC2_CONTEXT_STATUS__IDLE_MASK                                                                  0x00000004L
#define SDMA1_RLC2_CONTEXT_STATUS__EXPIRED_MASK                                                               0x00000008L
#define SDMA1_RLC2_CONTEXT_STATUS__EXCEPTION_MASK                                                             0x00000070L
#define SDMA1_RLC2_CONTEXT_STATUS__CTXSW_ABLE_MASK                                                            0x00000080L
#define SDMA1_RLC2_CONTEXT_STATUS__CTXSW_READY_MASK                                                           0x00000100L
#define SDMA1_RLC2_CONTEXT_STATUS__PREEMPTED_MASK                                                             0x00000200L
#define SDMA1_RLC2_CONTEXT_STATUS__PREEMPT_DISABLE_MASK                                                       0x00000400L
//SDMA1_RLC2_DOORBELL
#define SDMA1_RLC2_DOORBELL__ENABLE__SHIFT                                                                    0x1c
#define SDMA1_RLC2_DOORBELL__CAPTURED__SHIFT                                                                  0x1e
#define SDMA1_RLC2_DOORBELL__ENABLE_MASK                                                                      0x10000000L
#define SDMA1_RLC2_DOORBELL__CAPTURED_MASK                                                                    0x40000000L
//SDMA1_RLC2_STATUS
#define SDMA1_RLC2_STATUS__WPTR_UPDATE_FAIL_COUNT__SHIFT                                                      0x0
#define SDMA1_RLC2_STATUS__WPTR_UPDATE_PENDING__SHIFT                                                         0x8
#define SDMA1_RLC2_STATUS__WPTR_UPDATE_FAIL_COUNT_MASK                                                        0x000000FFL
#define SDMA1_RLC2_STATUS__WPTR_UPDATE_PENDING_MASK                                                           0x00000100L
//SDMA1_RLC2_DOORBELL_LOG
#define SDMA1_RLC2_DOORBELL_LOG__BE_ERROR__SHIFT                                                              0x0
#define SDMA1_RLC2_DOORBELL_LOG__DATA__SHIFT                                                                  0x2
#define SDMA1_RLC2_DOORBELL_LOG__BE_ERROR_MASK                                                                0x00000001L
#define SDMA1_RLC2_DOORBELL_LOG__DATA_MASK                                                                    0xFFFFFFFCL
//SDMA1_RLC2_WATERMARK
#define SDMA1_RLC2_WATERMARK__RD_OUTSTANDING__SHIFT                                                           0x0
#define SDMA1_RLC2_WATERMARK__WR_OUTSTANDING__SHIFT                                                           0x10
#define SDMA1_RLC2_WATERMARK__RD_OUTSTANDING_MASK                                                             0x00000FFFL
#define SDMA1_RLC2_WATERMARK__WR_OUTSTANDING_MASK                                                             0x03FF0000L
//SDMA1_RLC2_DOORBELL_OFFSET
#define SDMA1_RLC2_DOORBELL_OFFSET__OFFSET__SHIFT                                                             0x2
#define SDMA1_RLC2_DOORBELL_OFFSET__OFFSET_MASK                                                               0x0FFFFFFCL
//SDMA1_RLC2_CSA_ADDR_LO
#define SDMA1_RLC2_CSA_ADDR_LO__ADDR__SHIFT                                                                   0x2
#define SDMA1_RLC2_CSA_ADDR_LO__ADDR_MASK                                                                     0xFFFFFFFCL
//SDMA1_RLC2_CSA_ADDR_HI
#define SDMA1_RLC2_CSA_ADDR_HI__ADDR__SHIFT                                                                   0x0
#define SDMA1_RLC2_CSA_ADDR_HI__ADDR_MASK                                                                     0xFFFFFFFFL
//SDMA1_RLC2_IB_SUB_REMAIN
#define SDMA1_RLC2_IB_SUB_REMAIN__SIZE__SHIFT                                                                 0x0
#define SDMA1_RLC2_IB_SUB_REMAIN__SIZE_MASK                                                                   0x00003FFFL
//SDMA1_RLC2_PREEMPT
#define SDMA1_RLC2_PREEMPT__IB_PREEMPT__SHIFT                                                                 0x0
#define SDMA1_RLC2_PREEMPT__IB_PREEMPT_MASK                                                                   0x00000001L
//SDMA1_RLC2_DUMMY_REG
#define SDMA1_RLC2_DUMMY_REG__DUMMY__SHIFT                                                                    0x0
#define SDMA1_RLC2_DUMMY_REG__DUMMY_MASK                                                                      0xFFFFFFFFL
//SDMA1_RLC2_RB_WPTR_POLL_ADDR_HI
#define SDMA1_RLC2_RB_WPTR_POLL_ADDR_HI__ADDR__SHIFT                                                          0x0
#define SDMA1_RLC2_RB_WPTR_POLL_ADDR_HI__ADDR_MASK                                                            0xFFFFFFFFL
//SDMA1_RLC2_RB_WPTR_POLL_ADDR_LO
#define SDMA1_RLC2_RB_WPTR_POLL_ADDR_LO__ADDR__SHIFT                                                          0x2
#define SDMA1_RLC2_RB_WPTR_POLL_ADDR_LO__ADDR_MASK                                                            0xFFFFFFFCL
//SDMA1_RLC2_RB_AQL_CNTL
#define SDMA1_RLC2_RB_AQL_CNTL__AQL_ENABLE__SHIFT                                                             0x0
#define SDMA1_RLC2_RB_AQL_CNTL__AQL_PACKET_SIZE__SHIFT                                                        0x1
#define SDMA1_RLC2_RB_AQL_CNTL__PACKET_STEP__SHIFT                                                            0x8
#define SDMA1_RLC2_RB_AQL_CNTL__MIDCMD_PREEMPT_ENABLE__SHIFT                                                  0x10
#define SDMA1_RLC2_RB_AQL_CNTL__MIDCMD_PREEMPT_DATA_RESTORE__SHIFT                                            0x11
#define SDMA1_RLC2_RB_AQL_CNTL__OVERLAP_ENABLE__SHIFT                                                         0x12
#define SDMA1_RLC2_RB_AQL_CNTL__AQL_ENABLE_MASK                                                               0x00000001L
#define SDMA1_RLC2_RB_AQL_CNTL__AQL_PACKET_SIZE_MASK                                                          0x000000FEL
#define SDMA1_RLC2_RB_AQL_CNTL__PACKET_STEP_MASK                                                              0x0000FF00L
#define SDMA1_RLC2_RB_AQL_CNTL__MIDCMD_PREEMPT_ENABLE_MASK                                                    0x00010000L
#define SDMA1_RLC2_RB_AQL_CNTL__MIDCMD_PREEMPT_DATA_RESTORE_MASK                                              0x00020000L
#define SDMA1_RLC2_RB_AQL_CNTL__OVERLAP_ENABLE_MASK                                                           0x00040000L
//SDMA1_RLC2_MINOR_PTR_UPDATE
#define SDMA1_RLC2_MINOR_PTR_UPDATE__ENABLE__SHIFT                                                            0x0
#define SDMA1_RLC2_MINOR_PTR_UPDATE__ENABLE_MASK                                                              0x00000001L
//SDMA1_RLC2_MIDCMD_DATA0
#define SDMA1_RLC2_MIDCMD_DATA0__DATA0__SHIFT                                                                 0x0
#define SDMA1_RLC2_MIDCMD_DATA0__DATA0_MASK                                                                   0xFFFFFFFFL
//SDMA1_RLC2_MIDCMD_DATA1
#define SDMA1_RLC2_MIDCMD_DATA1__DATA1__SHIFT                                                                 0x0
#define SDMA1_RLC2_MIDCMD_DATA1__DATA1_MASK                                                                   0xFFFFFFFFL
//SDMA1_RLC2_MIDCMD_DATA2
#define SDMA1_RLC2_MIDCMD_DATA2__DATA2__SHIFT                                                                 0x0
#define SDMA1_RLC2_MIDCMD_DATA2__DATA2_MASK                                                                   0xFFFFFFFFL
//SDMA1_RLC2_MIDCMD_DATA3
#define SDMA1_RLC2_MIDCMD_DATA3__DATA3__SHIFT                                                                 0x0
#define SDMA1_RLC2_MIDCMD_DATA3__DATA3_MASK                                                                   0xFFFFFFFFL
//SDMA1_RLC2_MIDCMD_DATA4
#define SDMA1_RLC2_MIDCMD_DATA4__DATA4__SHIFT                                                                 0x0
#define SDMA1_RLC2_MIDCMD_DATA4__DATA4_MASK                                                                   0xFFFFFFFFL
//SDMA1_RLC2_MIDCMD_DATA5
#define SDMA1_RLC2_MIDCMD_DATA5__DATA5__SHIFT                                                                 0x0
#define SDMA1_RLC2_MIDCMD_DATA5__DATA5_MASK                                                                   0xFFFFFFFFL
//SDMA1_RLC2_MIDCMD_DATA6
#define SDMA1_RLC2_MIDCMD_DATA6__DATA6__SHIFT                                                                 0x0
#define SDMA1_RLC2_MIDCMD_DATA6__DATA6_MASK                                                                   0xFFFFFFFFL
//SDMA1_RLC2_MIDCMD_DATA7
#define SDMA1_RLC2_MIDCMD_DATA7__DATA7__SHIFT                                                                 0x0
#define SDMA1_RLC2_MIDCMD_DATA7__DATA7_MASK                                                                   0xFFFFFFFFL
//SDMA1_RLC2_MIDCMD_DATA8
#define SDMA1_RLC2_MIDCMD_DATA8__DATA8__SHIFT                                                                 0x0
#define SDMA1_RLC2_MIDCMD_DATA8__DATA8_MASK                                                                   0xFFFFFFFFL
//SDMA1_RLC2_MIDCMD_DATA9
#define SDMA1_RLC2_MIDCMD_DATA9__DATA9__SHIFT                                                                 0x0
#define SDMA1_RLC2_MIDCMD_DATA9__DATA9_MASK                                                                   0xFFFFFFFFL
//SDMA1_RLC2_MIDCMD_DATA10
#define SDMA1_RLC2_MIDCMD_DATA10__DATA10__SHIFT                                                               0x0
#define SDMA1_RLC2_MIDCMD_DATA10__DATA10_MASK                                                                 0xFFFFFFFFL
//SDMA1_RLC2_MIDCMD_CNTL
#define SDMA1_RLC2_MIDCMD_CNTL__DATA_VALID__SHIFT                                                             0x0
#define SDMA1_RLC2_MIDCMD_CNTL__COPY_MODE__SHIFT                                                              0x1
#define SDMA1_RLC2_MIDCMD_CNTL__SPLIT_STATE__SHIFT                                                            0x4
#define SDMA1_RLC2_MIDCMD_CNTL__ALLOW_PREEMPT__SHIFT                                                          0x8
#define SDMA1_RLC2_MIDCMD_CNTL__DATA_VALID_MASK                                                               0x00000001L
#define SDMA1_RLC2_MIDCMD_CNTL__COPY_MODE_MASK                                                                0x00000002L
#define SDMA1_RLC2_MIDCMD_CNTL__SPLIT_STATE_MASK                                                              0x000000F0L
#define SDMA1_RLC2_MIDCMD_CNTL__ALLOW_PREEMPT_MASK                                                            0x00000100L
//SDMA1_RLC3_RB_CNTL
#define SDMA1_RLC3_RB_CNTL__RB_ENABLE__SHIFT                                                                  0x0
#define SDMA1_RLC3_RB_CNTL__RB_SIZE__SHIFT                                                                    0x1
#define SDMA1_RLC3_RB_CNTL__RB_SWAP_ENABLE__SHIFT                                                             0x9
#define SDMA1_RLC3_RB_CNTL__RPTR_WRITEBACK_ENABLE__SHIFT                                                      0xc
#define SDMA1_RLC3_RB_CNTL__RPTR_WRITEBACK_SWAP_ENABLE__SHIFT                                                 0xd
#define SDMA1_RLC3_RB_CNTL__RPTR_WRITEBACK_TIMER__SHIFT                                                       0x10
#define SDMA1_RLC3_RB_CNTL__RB_PRIV__SHIFT                                                                    0x17
#define SDMA1_RLC3_RB_CNTL__RB_VMID__SHIFT                                                                    0x18
#define SDMA1_RLC3_RB_CNTL__RPTR_WB_IDLE__SHIFT                                                               0x1f
#define SDMA1_RLC3_RB_CNTL__RB_ENABLE_MASK                                                                    0x00000001L
#define SDMA1_RLC3_RB_CNTL__RB_SIZE_MASK                                                                      0x0000003EL
#define SDMA1_RLC3_RB_CNTL__RB_SWAP_ENABLE_MASK                                                               0x00000200L
#define SDMA1_RLC3_RB_CNTL__RPTR_WRITEBACK_ENABLE_MASK                                                        0x00001000L
#define SDMA1_RLC3_RB_CNTL__RPTR_WRITEBACK_SWAP_ENABLE_MASK                                                   0x00002000L
#define SDMA1_RLC3_RB_CNTL__RPTR_WRITEBACK_TIMER_MASK                                                         0x001F0000L
#define SDMA1_RLC3_RB_CNTL__RB_PRIV_MASK                                                                      0x00800000L
#define SDMA1_RLC3_RB_CNTL__RB_VMID_MASK                                                                      0x0F000000L
#define SDMA1_RLC3_RB_CNTL__RPTR_WB_IDLE_MASK                                                                 0x80000000L
//SDMA1_RLC3_RB_BASE
#define SDMA1_RLC3_RB_BASE__ADDR__SHIFT                                                                       0x0
#define SDMA1_RLC3_RB_BASE__ADDR_MASK                                                                         0xFFFFFFFFL
//SDMA1_RLC3_RB_BASE_HI
#define SDMA1_RLC3_RB_BASE_HI__ADDR__SHIFT                                                                    0x0
#define SDMA1_RLC3_RB_BASE_HI__ADDR_MASK                                                                      0x00FFFFFFL
//SDMA1_RLC3_RB_RPTR
#define SDMA1_RLC3_RB_RPTR__OFFSET__SHIFT                                                                     0x0
#define SDMA1_RLC3_RB_RPTR__OFFSET_MASK                                                                       0xFFFFFFFFL
//SDMA1_RLC3_RB_RPTR_HI
#define SDMA1_RLC3_RB_RPTR_HI__OFFSET__SHIFT                                                                  0x0
#define SDMA1_RLC3_RB_RPTR_HI__OFFSET_MASK                                                                    0xFFFFFFFFL
//SDMA1_RLC3_RB_WPTR
#define SDMA1_RLC3_RB_WPTR__OFFSET__SHIFT                                                                     0x0
#define SDMA1_RLC3_RB_WPTR__OFFSET_MASK                                                                       0xFFFFFFFFL
//SDMA1_RLC3_RB_WPTR_HI
#define SDMA1_RLC3_RB_WPTR_HI__OFFSET__SHIFT                                                                  0x0
#define SDMA1_RLC3_RB_WPTR_HI__OFFSET_MASK                                                                    0xFFFFFFFFL
//SDMA1_RLC3_RB_WPTR_POLL_CNTL
#define SDMA1_RLC3_RB_WPTR_POLL_CNTL__ENABLE__SHIFT                                                           0x0
#define SDMA1_RLC3_RB_WPTR_POLL_CNTL__SWAP_ENABLE__SHIFT                                                      0x1
#define SDMA1_RLC3_RB_WPTR_POLL_CNTL__F32_POLL_ENABLE__SHIFT                                                  0x2
#define SDMA1_RLC3_RB_WPTR_POLL_CNTL__FREQUENCY__SHIFT                                                        0x4
#define SDMA1_RLC3_RB_WPTR_POLL_CNTL__IDLE_POLL_COUNT__SHIFT                                                  0x10
#define SDMA1_RLC3_RB_WPTR_POLL_CNTL__ENABLE_MASK                                                             0x00000001L
#define SDMA1_RLC3_RB_WPTR_POLL_CNTL__SWAP_ENABLE_MASK                                                        0x00000002L
#define SDMA1_RLC3_RB_WPTR_POLL_CNTL__F32_POLL_ENABLE_MASK                                                    0x00000004L
#define SDMA1_RLC3_RB_WPTR_POLL_CNTL__FREQUENCY_MASK                                                          0x0000FFF0L
#define SDMA1_RLC3_RB_WPTR_POLL_CNTL__IDLE_POLL_COUNT_MASK                                                    0xFFFF0000L
//SDMA1_RLC3_RB_RPTR_ADDR_HI
#define SDMA1_RLC3_RB_RPTR_ADDR_HI__ADDR__SHIFT                                                               0x0
#define SDMA1_RLC3_RB_RPTR_ADDR_HI__ADDR_MASK                                                                 0xFFFFFFFFL
//SDMA1_RLC3_RB_RPTR_ADDR_LO
#define SDMA1_RLC3_RB_RPTR_ADDR_LO__ADDR__SHIFT                                                               0x2
#define SDMA1_RLC3_RB_RPTR_ADDR_LO__ADDR_MASK                                                                 0xFFFFFFFCL
//SDMA1_RLC3_IB_CNTL
#define SDMA1_RLC3_IB_CNTL__IB_ENABLE__SHIFT                                                                  0x0
#define SDMA1_RLC3_IB_CNTL__IB_SWAP_ENABLE__SHIFT                                                             0x4
#define SDMA1_RLC3_IB_CNTL__SWITCH_INSIDE_IB__SHIFT                                                           0x8
#define SDMA1_RLC3_IB_CNTL__CMD_VMID__SHIFT                                                                   0x10
#define SDMA1_RLC3_IB_CNTL__IB_ENABLE_MASK                                                                    0x00000001L
#define SDMA1_RLC3_IB_CNTL__IB_SWAP_ENABLE_MASK                                                               0x00000010L
#define SDMA1_RLC3_IB_CNTL__SWITCH_INSIDE_IB_MASK                                                             0x00000100L
#define SDMA1_RLC3_IB_CNTL__CMD_VMID_MASK                                                                     0x000F0000L
//SDMA1_RLC3_IB_RPTR
#define SDMA1_RLC3_IB_RPTR__OFFSET__SHIFT                                                                     0x2
#define SDMA1_RLC3_IB_RPTR__OFFSET_MASK                                                                       0x003FFFFCL
//SDMA1_RLC3_IB_OFFSET
#define SDMA1_RLC3_IB_OFFSET__OFFSET__SHIFT                                                                   0x2
#define SDMA1_RLC3_IB_OFFSET__OFFSET_MASK                                                                     0x003FFFFCL
//SDMA1_RLC3_IB_BASE_LO
#define SDMA1_RLC3_IB_BASE_LO__ADDR__SHIFT                                                                    0x5
#define SDMA1_RLC3_IB_BASE_LO__ADDR_MASK                                                                      0xFFFFFFE0L
//SDMA1_RLC3_IB_BASE_HI
#define SDMA1_RLC3_IB_BASE_HI__ADDR__SHIFT                                                                    0x0
#define SDMA1_RLC3_IB_BASE_HI__ADDR_MASK                                                                      0xFFFFFFFFL
//SDMA1_RLC3_IB_SIZE
#define SDMA1_RLC3_IB_SIZE__SIZE__SHIFT                                                                       0x0
#define SDMA1_RLC3_IB_SIZE__SIZE_MASK                                                                         0x000FFFFFL
//SDMA1_RLC3_SKIP_CNTL
#define SDMA1_RLC3_SKIP_CNTL__SKIP_COUNT__SHIFT                                                               0x0
#define SDMA1_RLC3_SKIP_CNTL__SKIP_COUNT_MASK                                                                 0x000FFFFFL
//SDMA1_RLC3_CONTEXT_STATUS
#define SDMA1_RLC3_CONTEXT_STATUS__SELECTED__SHIFT                                                            0x0
#define SDMA1_RLC3_CONTEXT_STATUS__IDLE__SHIFT                                                                0x2
#define SDMA1_RLC3_CONTEXT_STATUS__EXPIRED__SHIFT                                                             0x3
#define SDMA1_RLC3_CONTEXT_STATUS__EXCEPTION__SHIFT                                                           0x4
#define SDMA1_RLC3_CONTEXT_STATUS__CTXSW_ABLE__SHIFT                                                          0x7
#define SDMA1_RLC3_CONTEXT_STATUS__CTXSW_READY__SHIFT                                                         0x8
#define SDMA1_RLC3_CONTEXT_STATUS__PREEMPTED__SHIFT                                                           0x9
#define SDMA1_RLC3_CONTEXT_STATUS__PREEMPT_DISABLE__SHIFT                                                     0xa
#define SDMA1_RLC3_CONTEXT_STATUS__SELECTED_MASK                                                              0x00000001L
#define SDMA1_RLC3_CONTEXT_STATUS__IDLE_MASK                                                                  0x00000004L
#define SDMA1_RLC3_CONTEXT_STATUS__EXPIRED_MASK                                                               0x00000008L
#define SDMA1_RLC3_CONTEXT_STATUS__EXCEPTION_MASK                                                             0x00000070L
#define SDMA1_RLC3_CONTEXT_STATUS__CTXSW_ABLE_MASK                                                            0x00000080L
#define SDMA1_RLC3_CONTEXT_STATUS__CTXSW_READY_MASK                                                           0x00000100L
#define SDMA1_RLC3_CONTEXT_STATUS__PREEMPTED_MASK                                                             0x00000200L
#define SDMA1_RLC3_CONTEXT_STATUS__PREEMPT_DISABLE_MASK                                                       0x00000400L
//SDMA1_RLC3_DOORBELL
#define SDMA1_RLC3_DOORBELL__ENABLE__SHIFT                                                                    0x1c
#define SDMA1_RLC3_DOORBELL__CAPTURED__SHIFT                                                                  0x1e
#define SDMA1_RLC3_DOORBELL__ENABLE_MASK                                                                      0x10000000L
#define SDMA1_RLC3_DOORBELL__CAPTURED_MASK                                                                    0x40000000L
//SDMA1_RLC3_STATUS
#define SDMA1_RLC3_STATUS__WPTR_UPDATE_FAIL_COUNT__SHIFT                                                      0x0
#define SDMA1_RLC3_STATUS__WPTR_UPDATE_PENDING__SHIFT                                                         0x8
#define SDMA1_RLC3_STATUS__WPTR_UPDATE_FAIL_COUNT_MASK                                                        0x000000FFL
#define SDMA1_RLC3_STATUS__WPTR_UPDATE_PENDING_MASK                                                           0x00000100L
//SDMA1_RLC3_DOORBELL_LOG
#define SDMA1_RLC3_DOORBELL_LOG__BE_ERROR__SHIFT                                                              0x0
#define SDMA1_RLC3_DOORBELL_LOG__DATA__SHIFT                                                                  0x2
#define SDMA1_RLC3_DOORBELL_LOG__BE_ERROR_MASK                                                                0x00000001L
#define SDMA1_RLC3_DOORBELL_LOG__DATA_MASK                                                                    0xFFFFFFFCL
//SDMA1_RLC3_WATERMARK
#define SDMA1_RLC3_WATERMARK__RD_OUTSTANDING__SHIFT                                                           0x0
#define SDMA1_RLC3_WATERMARK__WR_OUTSTANDING__SHIFT                                                           0x10
#define SDMA1_RLC3_WATERMARK__RD_OUTSTANDING_MASK                                                             0x00000FFFL
#define SDMA1_RLC3_WATERMARK__WR_OUTSTANDING_MASK                                                             0x03FF0000L
//SDMA1_RLC3_DOORBELL_OFFSET
#define SDMA1_RLC3_DOORBELL_OFFSET__OFFSET__SHIFT                                                             0x2
#define SDMA1_RLC3_DOORBELL_OFFSET__OFFSET_MASK                                                               0x0FFFFFFCL
//SDMA1_RLC3_CSA_ADDR_LO
#define SDMA1_RLC3_CSA_ADDR_LO__ADDR__SHIFT                                                                   0x2
#define SDMA1_RLC3_CSA_ADDR_LO__ADDR_MASK                                                                     0xFFFFFFFCL
//SDMA1_RLC3_CSA_ADDR_HI
#define SDMA1_RLC3_CSA_ADDR_HI__ADDR__SHIFT                                                                   0x0
#define SDMA1_RLC3_CSA_ADDR_HI__ADDR_MASK                                                                     0xFFFFFFFFL
//SDMA1_RLC3_IB_SUB_REMAIN
#define SDMA1_RLC3_IB_SUB_REMAIN__SIZE__SHIFT                                                                 0x0
#define SDMA1_RLC3_IB_SUB_REMAIN__SIZE_MASK                                                                   0x00003FFFL
//SDMA1_RLC3_PREEMPT
#define SDMA1_RLC3_PREEMPT__IB_PREEMPT__SHIFT                                                                 0x0
#define SDMA1_RLC3_PREEMPT__IB_PREEMPT_MASK                                                                   0x00000001L
//SDMA1_RLC3_DUMMY_REG
#define SDMA1_RLC3_DUMMY_REG__DUMMY__SHIFT                                                                    0x0
#define SDMA1_RLC3_DUMMY_REG__DUMMY_MASK                                                                      0xFFFFFFFFL
//SDMA1_RLC3_RB_WPTR_POLL_ADDR_HI
#define SDMA1_RLC3_RB_WPTR_POLL_ADDR_HI__ADDR__SHIFT                                                          0x0
#define SDMA1_RLC3_RB_WPTR_POLL_ADDR_HI__ADDR_MASK                                                            0xFFFFFFFFL
//SDMA1_RLC3_RB_WPTR_POLL_ADDR_LO
#define SDMA1_RLC3_RB_WPTR_POLL_ADDR_LO__ADDR__SHIFT                                                          0x2
#define SDMA1_RLC3_RB_WPTR_POLL_ADDR_LO__ADDR_MASK                                                            0xFFFFFFFCL
//SDMA1_RLC3_RB_AQL_CNTL
#define SDMA1_RLC3_RB_AQL_CNTL__AQL_ENABLE__SHIFT                                                             0x0
#define SDMA1_RLC3_RB_AQL_CNTL__AQL_PACKET_SIZE__SHIFT                                                        0x1
#define SDMA1_RLC3_RB_AQL_CNTL__PACKET_STEP__SHIFT                                                            0x8
#define SDMA1_RLC3_RB_AQL_CNTL__MIDCMD_PREEMPT_ENABLE__SHIFT                                                  0x10
#define SDMA1_RLC3_RB_AQL_CNTL__MIDCMD_PREEMPT_DATA_RESTORE__SHIFT                                            0x11
#define SDMA1_RLC3_RB_AQL_CNTL__OVERLAP_ENABLE__SHIFT                                                         0x12
#define SDMA1_RLC3_RB_AQL_CNTL__AQL_ENABLE_MASK                                                               0x00000001L
#define SDMA1_RLC3_RB_AQL_CNTL__AQL_PACKET_SIZE_MASK                                                          0x000000FEL
#define SDMA1_RLC3_RB_AQL_CNTL__PACKET_STEP_MASK                                                              0x0000FF00L
#define SDMA1_RLC3_RB_AQL_CNTL__MIDCMD_PREEMPT_ENABLE_MASK                                                    0x00010000L
#define SDMA1_RLC3_RB_AQL_CNTL__MIDCMD_PREEMPT_DATA_RESTORE_MASK                                              0x00020000L
#define SDMA1_RLC3_RB_AQL_CNTL__OVERLAP_ENABLE_MASK                                                           0x00040000L
//SDMA1_RLC3_MINOR_PTR_UPDATE
#define SDMA1_RLC3_MINOR_PTR_UPDATE__ENABLE__SHIFT                                                            0x0
#define SDMA1_RLC3_MINOR_PTR_UPDATE__ENABLE_MASK                                                              0x00000001L
//SDMA1_RLC3_MIDCMD_DATA0
#define SDMA1_RLC3_MIDCMD_DATA0__DATA0__SHIFT                                                                 0x0
#define SDMA1_RLC3_MIDCMD_DATA0__DATA0_MASK                                                                   0xFFFFFFFFL
//SDMA1_RLC3_MIDCMD_DATA1
#define SDMA1_RLC3_MIDCMD_DATA1__DATA1__SHIFT                                                                 0x0
#define SDMA1_RLC3_MIDCMD_DATA1__DATA1_MASK                                                                   0xFFFFFFFFL
//SDMA1_RLC3_MIDCMD_DATA2
#define SDMA1_RLC3_MIDCMD_DATA2__DATA2__SHIFT                                                                 0x0
#define SDMA1_RLC3_MIDCMD_DATA2__DATA2_MASK                                                                   0xFFFFFFFFL
//SDMA1_RLC3_MIDCMD_DATA3
#define SDMA1_RLC3_MIDCMD_DATA3__DATA3__SHIFT                                                                 0x0
#define SDMA1_RLC3_MIDCMD_DATA3__DATA3_MASK                                                                   0xFFFFFFFFL
//SDMA1_RLC3_MIDCMD_DATA4
#define SDMA1_RLC3_MIDCMD_DATA4__DATA4__SHIFT                                                                 0x0
#define SDMA1_RLC3_MIDCMD_DATA4__DATA4_MASK                                                                   0xFFFFFFFFL
//SDMA1_RLC3_MIDCMD_DATA5
#define SDMA1_RLC3_MIDCMD_DATA5__DATA5__SHIFT                                                                 0x0
#define SDMA1_RLC3_MIDCMD_DATA5__DATA5_MASK                                                                   0xFFFFFFFFL
//SDMA1_RLC3_MIDCMD_DATA6
#define SDMA1_RLC3_MIDCMD_DATA6__DATA6__SHIFT                                                                 0x0
#define SDMA1_RLC3_MIDCMD_DATA6__DATA6_MASK                                                                   0xFFFFFFFFL
//SDMA1_RLC3_MIDCMD_DATA7
#define SDMA1_RLC3_MIDCMD_DATA7__DATA7__SHIFT                                                                 0x0
#define SDMA1_RLC3_MIDCMD_DATA7__DATA7_MASK                                                                   0xFFFFFFFFL
//SDMA1_RLC3_MIDCMD_DATA8
#define SDMA1_RLC3_MIDCMD_DATA8__DATA8__SHIFT                                                                 0x0
#define SDMA1_RLC3_MIDCMD_DATA8__DATA8_MASK                                                                   0xFFFFFFFFL
//SDMA1_RLC3_MIDCMD_DATA9
#define SDMA1_RLC3_MIDCMD_DATA9__DATA9__SHIFT                                                                 0x0
#define SDMA1_RLC3_MIDCMD_DATA9__DATA9_MASK                                                                   0xFFFFFFFFL
//SDMA1_RLC3_MIDCMD_DATA10
#define SDMA1_RLC3_MIDCMD_DATA10__DATA10__SHIFT                                                               0x0
#define SDMA1_RLC3_MIDCMD_DATA10__DATA10_MASK                                                                 0xFFFFFFFFL
//SDMA1_RLC3_MIDCMD_CNTL
#define SDMA1_RLC3_MIDCMD_CNTL__DATA_VALID__SHIFT                                                             0x0
#define SDMA1_RLC3_MIDCMD_CNTL__COPY_MODE__SHIFT                                                              0x1
#define SDMA1_RLC3_MIDCMD_CNTL__SPLIT_STATE__SHIFT                                                            0x4
#define SDMA1_RLC3_MIDCMD_CNTL__ALLOW_PREEMPT__SHIFT                                                          0x8
#define SDMA1_RLC3_MIDCMD_CNTL__DATA_VALID_MASK                                                               0x00000001L
#define SDMA1_RLC3_MIDCMD_CNTL__COPY_MODE_MASK                                                                0x00000002L
#define SDMA1_RLC3_MIDCMD_CNTL__SPLIT_STATE_MASK                                                              0x000000F0L
#define SDMA1_RLC3_MIDCMD_CNTL__ALLOW_PREEMPT_MASK                                                            0x00000100L
//SDMA1_RLC4_RB_CNTL
#define SDMA1_RLC4_RB_CNTL__RB_ENABLE__SHIFT                                                                  0x0
#define SDMA1_RLC4_RB_CNTL__RB_SIZE__SHIFT                                                                    0x1
#define SDMA1_RLC4_RB_CNTL__RB_SWAP_ENABLE__SHIFT                                                             0x9
#define SDMA1_RLC4_RB_CNTL__RPTR_WRITEBACK_ENABLE__SHIFT                                                      0xc
#define SDMA1_RLC4_RB_CNTL__RPTR_WRITEBACK_SWAP_ENABLE__SHIFT                                                 0xd
#define SDMA1_RLC4_RB_CNTL__RPTR_WRITEBACK_TIMER__SHIFT                                                       0x10
#define SDMA1_RLC4_RB_CNTL__RB_PRIV__SHIFT                                                                    0x17
#define SDMA1_RLC4_RB_CNTL__RB_VMID__SHIFT                                                                    0x18
#define SDMA1_RLC4_RB_CNTL__RPTR_WB_IDLE__SHIFT                                                               0x1f
#define SDMA1_RLC4_RB_CNTL__RB_ENABLE_MASK                                                                    0x00000001L
#define SDMA1_RLC4_RB_CNTL__RB_SIZE_MASK                                                                      0x0000003EL
#define SDMA1_RLC4_RB_CNTL__RB_SWAP_ENABLE_MASK                                                               0x00000200L
#define SDMA1_RLC4_RB_CNTL__RPTR_WRITEBACK_ENABLE_MASK                                                        0x00001000L
#define SDMA1_RLC4_RB_CNTL__RPTR_WRITEBACK_SWAP_ENABLE_MASK                                                   0x00002000L
#define SDMA1_RLC4_RB_CNTL__RPTR_WRITEBACK_TIMER_MASK                                                         0x001F0000L
#define SDMA1_RLC4_RB_CNTL__RB_PRIV_MASK                                                                      0x00800000L
#define SDMA1_RLC4_RB_CNTL__RB_VMID_MASK                                                                      0x0F000000L
#define SDMA1_RLC4_RB_CNTL__RPTR_WB_IDLE_MASK                                                                 0x80000000L
//SDMA1_RLC4_RB_BASE
#define SDMA1_RLC4_RB_BASE__ADDR__SHIFT                                                                       0x0
#define SDMA1_RLC4_RB_BASE__ADDR_MASK                                                                         0xFFFFFFFFL
//SDMA1_RLC4_RB_BASE_HI
#define SDMA1_RLC4_RB_BASE_HI__ADDR__SHIFT                                                                    0x0
#define SDMA1_RLC4_RB_BASE_HI__ADDR_MASK                                                                      0x00FFFFFFL
//SDMA1_RLC4_RB_RPTR
#define SDMA1_RLC4_RB_RPTR__OFFSET__SHIFT                                                                     0x0
#define SDMA1_RLC4_RB_RPTR__OFFSET_MASK                                                                       0xFFFFFFFFL
//SDMA1_RLC4_RB_RPTR_HI
#define SDMA1_RLC4_RB_RPTR_HI__OFFSET__SHIFT                                                                  0x0
#define SDMA1_RLC4_RB_RPTR_HI__OFFSET_MASK                                                                    0xFFFFFFFFL
//SDMA1_RLC4_RB_WPTR
#define SDMA1_RLC4_RB_WPTR__OFFSET__SHIFT                                                                     0x0
#define SDMA1_RLC4_RB_WPTR__OFFSET_MASK                                                                       0xFFFFFFFFL
//SDMA1_RLC4_RB_WPTR_HI
#define SDMA1_RLC4_RB_WPTR_HI__OFFSET__SHIFT                                                                  0x0
#define SDMA1_RLC4_RB_WPTR_HI__OFFSET_MASK                                                                    0xFFFFFFFFL
//SDMA1_RLC4_RB_WPTR_POLL_CNTL
#define SDMA1_RLC4_RB_WPTR_POLL_CNTL__ENABLE__SHIFT                                                           0x0
#define SDMA1_RLC4_RB_WPTR_POLL_CNTL__SWAP_ENABLE__SHIFT                                                      0x1
#define SDMA1_RLC4_RB_WPTR_POLL_CNTL__F32_POLL_ENABLE__SHIFT                                                  0x2
#define SDMA1_RLC4_RB_WPTR_POLL_CNTL__FREQUENCY__SHIFT                                                        0x4
#define SDMA1_RLC4_RB_WPTR_POLL_CNTL__IDLE_POLL_COUNT__SHIFT                                                  0x10
#define SDMA1_RLC4_RB_WPTR_POLL_CNTL__ENABLE_MASK                                                             0x00000001L
#define SDMA1_RLC4_RB_WPTR_POLL_CNTL__SWAP_ENABLE_MASK                                                        0x00000002L
#define SDMA1_RLC4_RB_WPTR_POLL_CNTL__F32_POLL_ENABLE_MASK                                                    0x00000004L
#define SDMA1_RLC4_RB_WPTR_POLL_CNTL__FREQUENCY_MASK                                                          0x0000FFF0L
#define SDMA1_RLC4_RB_WPTR_POLL_CNTL__IDLE_POLL_COUNT_MASK                                                    0xFFFF0000L
//SDMA1_RLC4_RB_RPTR_ADDR_HI
#define SDMA1_RLC4_RB_RPTR_ADDR_HI__ADDR__SHIFT                                                               0x0
#define SDMA1_RLC4_RB_RPTR_ADDR_HI__ADDR_MASK                                                                 0xFFFFFFFFL
//SDMA1_RLC4_RB_RPTR_ADDR_LO
#define SDMA1_RLC4_RB_RPTR_ADDR_LO__ADDR__SHIFT                                                               0x2
#define SDMA1_RLC4_RB_RPTR_ADDR_LO__ADDR_MASK                                                                 0xFFFFFFFCL
//SDMA1_RLC4_IB_CNTL
#define SDMA1_RLC4_IB_CNTL__IB_ENABLE__SHIFT                                                                  0x0
#define SDMA1_RLC4_IB_CNTL__IB_SWAP_ENABLE__SHIFT                                                             0x4
#define SDMA1_RLC4_IB_CNTL__SWITCH_INSIDE_IB__SHIFT                                                           0x8
#define SDMA1_RLC4_IB_CNTL__CMD_VMID__SHIFT                                                                   0x10
#define SDMA1_RLC4_IB_CNTL__IB_ENABLE_MASK                                                                    0x00000001L
#define SDMA1_RLC4_IB_CNTL__IB_SWAP_ENABLE_MASK                                                               0x00000010L
#define SDMA1_RLC4_IB_CNTL__SWITCH_INSIDE_IB_MASK                                                             0x00000100L
#define SDMA1_RLC4_IB_CNTL__CMD_VMID_MASK                                                                     0x000F0000L
//SDMA1_RLC4_IB_RPTR
#define SDMA1_RLC4_IB_RPTR__OFFSET__SHIFT                                                                     0x2
#define SDMA1_RLC4_IB_RPTR__OFFSET_MASK                                                                       0x003FFFFCL
//SDMA1_RLC4_IB_OFFSET
#define SDMA1_RLC4_IB_OFFSET__OFFSET__SHIFT                                                                   0x2
#define SDMA1_RLC4_IB_OFFSET__OFFSET_MASK                                                                     0x003FFFFCL
//SDMA1_RLC4_IB_BASE_LO
#define SDMA1_RLC4_IB_BASE_LO__ADDR__SHIFT                                                                    0x5
#define SDMA1_RLC4_IB_BASE_LO__ADDR_MASK                                                                      0xFFFFFFE0L
//SDMA1_RLC4_IB_BASE_HI
#define SDMA1_RLC4_IB_BASE_HI__ADDR__SHIFT                                                                    0x0
#define SDMA1_RLC4_IB_BASE_HI__ADDR_MASK                                                                      0xFFFFFFFFL
//SDMA1_RLC4_IB_SIZE
#define SDMA1_RLC4_IB_SIZE__SIZE__SHIFT                                                                       0x0
#define SDMA1_RLC4_IB_SIZE__SIZE_MASK                                                                         0x000FFFFFL
//SDMA1_RLC4_SKIP_CNTL
#define SDMA1_RLC4_SKIP_CNTL__SKIP_COUNT__SHIFT                                                               0x0
#define SDMA1_RLC4_SKIP_CNTL__SKIP_COUNT_MASK                                                                 0x000FFFFFL
//SDMA1_RLC4_CONTEXT_STATUS
#define SDMA1_RLC4_CONTEXT_STATUS__SELECTED__SHIFT                                                            0x0
#define SDMA1_RLC4_CONTEXT_STATUS__IDLE__SHIFT                                                                0x2
#define SDMA1_RLC4_CONTEXT_STATUS__EXPIRED__SHIFT                                                             0x3
#define SDMA1_RLC4_CONTEXT_STATUS__EXCEPTION__SHIFT                                                           0x4
#define SDMA1_RLC4_CONTEXT_STATUS__CTXSW_ABLE__SHIFT                                                          0x7
#define SDMA1_RLC4_CONTEXT_STATUS__CTXSW_READY__SHIFT                                                         0x8
#define SDMA1_RLC4_CONTEXT_STATUS__PREEMPTED__SHIFT                                                           0x9
#define SDMA1_RLC4_CONTEXT_STATUS__PREEMPT_DISABLE__SHIFT                                                     0xa
#define SDMA1_RLC4_CONTEXT_STATUS__SELECTED_MASK                                                              0x00000001L
#define SDMA1_RLC4_CONTEXT_STATUS__IDLE_MASK                                                                  0x00000004L
#define SDMA1_RLC4_CONTEXT_STATUS__EXPIRED_MASK                                                               0x00000008L
#define SDMA1_RLC4_CONTEXT_STATUS__EXCEPTION_MASK                                                             0x00000070L
#define SDMA1_RLC4_CONTEXT_STATUS__CTXSW_ABLE_MASK                                                            0x00000080L
#define SDMA1_RLC4_CONTEXT_STATUS__CTXSW_READY_MASK                                                           0x00000100L
#define SDMA1_RLC4_CONTEXT_STATUS__PREEMPTED_MASK                                                             0x00000200L
#define SDMA1_RLC4_CONTEXT_STATUS__PREEMPT_DISABLE_MASK                                                       0x00000400L
//SDMA1_RLC4_DOORBELL
#define SDMA1_RLC4_DOORBELL__ENABLE__SHIFT                                                                    0x1c
#define SDMA1_RLC4_DOORBELL__CAPTURED__SHIFT                                                                  0x1e
#define SDMA1_RLC4_DOORBELL__ENABLE_MASK                                                                      0x10000000L
#define SDMA1_RLC4_DOORBELL__CAPTURED_MASK                                                                    0x40000000L
//SDMA1_RLC4_STATUS
#define SDMA1_RLC4_STATUS__WPTR_UPDATE_FAIL_COUNT__SHIFT                                                      0x0
#define SDMA1_RLC4_STATUS__WPTR_UPDATE_PENDING__SHIFT                                                         0x8
#define SDMA1_RLC4_STATUS__WPTR_UPDATE_FAIL_COUNT_MASK                                                        0x000000FFL
#define SDMA1_RLC4_STATUS__WPTR_UPDATE_PENDING_MASK                                                           0x00000100L
//SDMA1_RLC4_DOORBELL_LOG
#define SDMA1_RLC4_DOORBELL_LOG__BE_ERROR__SHIFT                                                              0x0
#define SDMA1_RLC4_DOORBELL_LOG__DATA__SHIFT                                                                  0x2
#define SDMA1_RLC4_DOORBELL_LOG__BE_ERROR_MASK                                                                0x00000001L
#define SDMA1_RLC4_DOORBELL_LOG__DATA_MASK                                                                    0xFFFFFFFCL
//SDMA1_RLC4_WATERMARK
#define SDMA1_RLC4_WATERMARK__RD_OUTSTANDING__SHIFT                                                           0x0
#define SDMA1_RLC4_WATERMARK__WR_OUTSTANDING__SHIFT                                                           0x10
#define SDMA1_RLC4_WATERMARK__RD_OUTSTANDING_MASK                                                             0x00000FFFL
#define SDMA1_RLC4_WATERMARK__WR_OUTSTANDING_MASK                                                             0x03FF0000L
//SDMA1_RLC4_DOORBELL_OFFSET
#define SDMA1_RLC4_DOORBELL_OFFSET__OFFSET__SHIFT                                                             0x2
#define SDMA1_RLC4_DOORBELL_OFFSET__OFFSET_MASK                                                               0x0FFFFFFCL
//SDMA1_RLC4_CSA_ADDR_LO
#define SDMA1_RLC4_CSA_ADDR_LO__ADDR__SHIFT                                                                   0x2
#define SDMA1_RLC4_CSA_ADDR_LO__ADDR_MASK                                                                     0xFFFFFFFCL
//SDMA1_RLC4_CSA_ADDR_HI
#define SDMA1_RLC4_CSA_ADDR_HI__ADDR__SHIFT                                                                   0x0
#define SDMA1_RLC4_CSA_ADDR_HI__ADDR_MASK                                                                     0xFFFFFFFFL
//SDMA1_RLC4_IB_SUB_REMAIN
#define SDMA1_RLC4_IB_SUB_REMAIN__SIZE__SHIFT                                                                 0x0
#define SDMA1_RLC4_IB_SUB_REMAIN__SIZE_MASK                                                                   0x00003FFFL
//SDMA1_RLC4_PREEMPT
#define SDMA1_RLC4_PREEMPT__IB_PREEMPT__SHIFT                                                                 0x0
#define SDMA1_RLC4_PREEMPT__IB_PREEMPT_MASK                                                                   0x00000001L
//SDMA1_RLC4_DUMMY_REG
#define SDMA1_RLC4_DUMMY_REG__DUMMY__SHIFT                                                                    0x0
#define SDMA1_RLC4_DUMMY_REG__DUMMY_MASK                                                                      0xFFFFFFFFL
//SDMA1_RLC4_RB_WPTR_POLL_ADDR_HI
#define SDMA1_RLC4_RB_WPTR_POLL_ADDR_HI__ADDR__SHIFT                                                          0x0
#define SDMA1_RLC4_RB_WPTR_POLL_ADDR_HI__ADDR_MASK                                                            0xFFFFFFFFL
//SDMA1_RLC4_RB_WPTR_POLL_ADDR_LO
#define SDMA1_RLC4_RB_WPTR_POLL_ADDR_LO__ADDR__SHIFT                                                          0x2
#define SDMA1_RLC4_RB_WPTR_POLL_ADDR_LO__ADDR_MASK                                                            0xFFFFFFFCL
//SDMA1_RLC4_RB_AQL_CNTL
#define SDMA1_RLC4_RB_AQL_CNTL__AQL_ENABLE__SHIFT                                                             0x0
#define SDMA1_RLC4_RB_AQL_CNTL__AQL_PACKET_SIZE__SHIFT                                                        0x1
#define SDMA1_RLC4_RB_AQL_CNTL__PACKET_STEP__SHIFT                                                            0x8
#define SDMA1_RLC4_RB_AQL_CNTL__MIDCMD_PREEMPT_ENABLE__SHIFT                                                  0x10
#define SDMA1_RLC4_RB_AQL_CNTL__MIDCMD_PREEMPT_DATA_RESTORE__SHIFT                                            0x11
#define SDMA1_RLC4_RB_AQL_CNTL__OVERLAP_ENABLE__SHIFT                                                         0x12
#define SDMA1_RLC4_RB_AQL_CNTL__AQL_ENABLE_MASK                                                               0x00000001L
#define SDMA1_RLC4_RB_AQL_CNTL__AQL_PACKET_SIZE_MASK                                                          0x000000FEL
#define SDMA1_RLC4_RB_AQL_CNTL__PACKET_STEP_MASK                                                              0x0000FF00L
#define SDMA1_RLC4_RB_AQL_CNTL__MIDCMD_PREEMPT_ENABLE_MASK                                                    0x00010000L
#define SDMA1_RLC4_RB_AQL_CNTL__MIDCMD_PREEMPT_DATA_RESTORE_MASK                                              0x00020000L
#define SDMA1_RLC4_RB_AQL_CNTL__OVERLAP_ENABLE_MASK                                                           0x00040000L
//SDMA1_RLC4_MINOR_PTR_UPDATE
#define SDMA1_RLC4_MINOR_PTR_UPDATE__ENABLE__SHIFT                                                            0x0
#define SDMA1_RLC4_MINOR_PTR_UPDATE__ENABLE_MASK                                                              0x00000001L
//SDMA1_RLC4_MIDCMD_DATA0
#define SDMA1_RLC4_MIDCMD_DATA0__DATA0__SHIFT                                                                 0x0
#define SDMA1_RLC4_MIDCMD_DATA0__DATA0_MASK                                                                   0xFFFFFFFFL
//SDMA1_RLC4_MIDCMD_DATA1
#define SDMA1_RLC4_MIDCMD_DATA1__DATA1__SHIFT                                                                 0x0
#define SDMA1_RLC4_MIDCMD_DATA1__DATA1_MASK                                                                   0xFFFFFFFFL
//SDMA1_RLC4_MIDCMD_DATA2
#define SDMA1_RLC4_MIDCMD_DATA2__DATA2__SHIFT                                                                 0x0
#define SDMA1_RLC4_MIDCMD_DATA2__DATA2_MASK                                                                   0xFFFFFFFFL
//SDMA1_RLC4_MIDCMD_DATA3
#define SDMA1_RLC4_MIDCMD_DATA3__DATA3__SHIFT                                                                 0x0
#define SDMA1_RLC4_MIDCMD_DATA3__DATA3_MASK                                                                   0xFFFFFFFFL
//SDMA1_RLC4_MIDCMD_DATA4
#define SDMA1_RLC4_MIDCMD_DATA4__DATA4__SHIFT                                                                 0x0
#define SDMA1_RLC4_MIDCMD_DATA4__DATA4_MASK                                                                   0xFFFFFFFFL
//SDMA1_RLC4_MIDCMD_DATA5
#define SDMA1_RLC4_MIDCMD_DATA5__DATA5__SHIFT                                                                 0x0
#define SDMA1_RLC4_MIDCMD_DATA5__DATA5_MASK                                                                   0xFFFFFFFFL
//SDMA1_RLC4_MIDCMD_DATA6
#define SDMA1_RLC4_MIDCMD_DATA6__DATA6__SHIFT                                                                 0x0
#define SDMA1_RLC4_MIDCMD_DATA6__DATA6_MASK                                                                   0xFFFFFFFFL
//SDMA1_RLC4_MIDCMD_DATA7
#define SDMA1_RLC4_MIDCMD_DATA7__DATA7__SHIFT                                                                 0x0
#define SDMA1_RLC4_MIDCMD_DATA7__DATA7_MASK                                                                   0xFFFFFFFFL
//SDMA1_RLC4_MIDCMD_DATA8
#define SDMA1_RLC4_MIDCMD_DATA8__DATA8__SHIFT                                                                 0x0
#define SDMA1_RLC4_MIDCMD_DATA8__DATA8_MASK                                                                   0xFFFFFFFFL
//SDMA1_RLC4_MIDCMD_DATA9
#define SDMA1_RLC4_MIDCMD_DATA9__DATA9__SHIFT                                                                 0x0
#define SDMA1_RLC4_MIDCMD_DATA9__DATA9_MASK                                                                   0xFFFFFFFFL
//SDMA1_RLC4_MIDCMD_DATA10
#define SDMA1_RLC4_MIDCMD_DATA10__DATA10__SHIFT                                                               0x0
#define SDMA1_RLC4_MIDCMD_DATA10__DATA10_MASK                                                                 0xFFFFFFFFL
//SDMA1_RLC4_MIDCMD_CNTL
#define SDMA1_RLC4_MIDCMD_CNTL__DATA_VALID__SHIFT                                                             0x0
#define SDMA1_RLC4_MIDCMD_CNTL__COPY_MODE__SHIFT                                                              0x1
#define SDMA1_RLC4_MIDCMD_CNTL__SPLIT_STATE__SHIFT                                                            0x4
#define SDMA1_RLC4_MIDCMD_CNTL__ALLOW_PREEMPT__SHIFT                                                          0x8
#define SDMA1_RLC4_MIDCMD_CNTL__DATA_VALID_MASK                                                               0x00000001L
#define SDMA1_RLC4_MIDCMD_CNTL__COPY_MODE_MASK                                                                0x00000002L
#define SDMA1_RLC4_MIDCMD_CNTL__SPLIT_STATE_MASK                                                              0x000000F0L
#define SDMA1_RLC4_MIDCMD_CNTL__ALLOW_PREEMPT_MASK                                                            0x00000100L
//SDMA1_RLC5_RB_CNTL
#define SDMA1_RLC5_RB_CNTL__RB_ENABLE__SHIFT                                                                  0x0
#define SDMA1_RLC5_RB_CNTL__RB_SIZE__SHIFT                                                                    0x1
#define SDMA1_RLC5_RB_CNTL__RB_SWAP_ENABLE__SHIFT                                                             0x9
#define SDMA1_RLC5_RB_CNTL__RPTR_WRITEBACK_ENABLE__SHIFT                                                      0xc
#define SDMA1_RLC5_RB_CNTL__RPTR_WRITEBACK_SWAP_ENABLE__SHIFT                                                 0xd
#define SDMA1_RLC5_RB_CNTL__RPTR_WRITEBACK_TIMER__SHIFT                                                       0x10
#define SDMA1_RLC5_RB_CNTL__RB_PRIV__SHIFT                                                                    0x17
#define SDMA1_RLC5_RB_CNTL__RB_VMID__SHIFT                                                                    0x18
#define SDMA1_RLC5_RB_CNTL__RPTR_WB_IDLE__SHIFT                                                               0x1f
#define SDMA1_RLC5_RB_CNTL__RB_ENABLE_MASK                                                                    0x00000001L
#define SDMA1_RLC5_RB_CNTL__RB_SIZE_MASK                                                                      0x0000003EL
#define SDMA1_RLC5_RB_CNTL__RB_SWAP_ENABLE_MASK                                                               0x00000200L
#define SDMA1_RLC5_RB_CNTL__RPTR_WRITEBACK_ENABLE_MASK                                                        0x00001000L
#define SDMA1_RLC5_RB_CNTL__RPTR_WRITEBACK_SWAP_ENABLE_MASK                                                   0x00002000L
#define SDMA1_RLC5_RB_CNTL__RPTR_WRITEBACK_TIMER_MASK                                                         0x001F0000L
#define SDMA1_RLC5_RB_CNTL__RB_PRIV_MASK                                                                      0x00800000L
#define SDMA1_RLC5_RB_CNTL__RB_VMID_MASK                                                                      0x0F000000L
#define SDMA1_RLC5_RB_CNTL__RPTR_WB_IDLE_MASK                                                                 0x80000000L
//SDMA1_RLC5_RB_BASE
#define SDMA1_RLC5_RB_BASE__ADDR__SHIFT                                                                       0x0
#define SDMA1_RLC5_RB_BASE__ADDR_MASK                                                                         0xFFFFFFFFL
//SDMA1_RLC5_RB_BASE_HI
#define SDMA1_RLC5_RB_BASE_HI__ADDR__SHIFT                                                                    0x0
#define SDMA1_RLC5_RB_BASE_HI__ADDR_MASK                                                                      0x00FFFFFFL
//SDMA1_RLC5_RB_RPTR
#define SDMA1_RLC5_RB_RPTR__OFFSET__SHIFT                                                                     0x0
#define SDMA1_RLC5_RB_RPTR__OFFSET_MASK                                                                       0xFFFFFFFFL
//SDMA1_RLC5_RB_RPTR_HI
#define SDMA1_RLC5_RB_RPTR_HI__OFFSET__SHIFT                                                                  0x0
#define SDMA1_RLC5_RB_RPTR_HI__OFFSET_MASK                                                                    0xFFFFFFFFL
//SDMA1_RLC5_RB_WPTR
#define SDMA1_RLC5_RB_WPTR__OFFSET__SHIFT                                                                     0x0
#define SDMA1_RLC5_RB_WPTR__OFFSET_MASK                                                                       0xFFFFFFFFL
//SDMA1_RLC5_RB_WPTR_HI
#define SDMA1_RLC5_RB_WPTR_HI__OFFSET__SHIFT                                                                  0x0
#define SDMA1_RLC5_RB_WPTR_HI__OFFSET_MASK                                                                    0xFFFFFFFFL
//SDMA1_RLC5_RB_WPTR_POLL_CNTL
#define SDMA1_RLC5_RB_WPTR_POLL_CNTL__ENABLE__SHIFT                                                           0x0
#define SDMA1_RLC5_RB_WPTR_POLL_CNTL__SWAP_ENABLE__SHIFT                                                      0x1
#define SDMA1_RLC5_RB_WPTR_POLL_CNTL__F32_POLL_ENABLE__SHIFT                                                  0x2
#define SDMA1_RLC5_RB_WPTR_POLL_CNTL__FREQUENCY__SHIFT                                                        0x4
#define SDMA1_RLC5_RB_WPTR_POLL_CNTL__IDLE_POLL_COUNT__SHIFT                                                  0x10
#define SDMA1_RLC5_RB_WPTR_POLL_CNTL__ENABLE_MASK                                                             0x00000001L
#define SDMA1_RLC5_RB_WPTR_POLL_CNTL__SWAP_ENABLE_MASK                                                        0x00000002L
#define SDMA1_RLC5_RB_WPTR_POLL_CNTL__F32_POLL_ENABLE_MASK                                                    0x00000004L
#define SDMA1_RLC5_RB_WPTR_POLL_CNTL__FREQUENCY_MASK                                                          0x0000FFF0L
#define SDMA1_RLC5_RB_WPTR_POLL_CNTL__IDLE_POLL_COUNT_MASK                                                    0xFFFF0000L
//SDMA1_RLC5_RB_RPTR_ADDR_HI
#define SDMA1_RLC5_RB_RPTR_ADDR_HI__ADDR__SHIFT                                                               0x0
#define SDMA1_RLC5_RB_RPTR_ADDR_HI__ADDR_MASK                                                                 0xFFFFFFFFL
//SDMA1_RLC5_RB_RPTR_ADDR_LO
#define SDMA1_RLC5_RB_RPTR_ADDR_LO__ADDR__SHIFT                                                               0x2
#define SDMA1_RLC5_RB_RPTR_ADDR_LO__ADDR_MASK                                                                 0xFFFFFFFCL
//SDMA1_RLC5_IB_CNTL
#define SDMA1_RLC5_IB_CNTL__IB_ENABLE__SHIFT                                                                  0x0
#define SDMA1_RLC5_IB_CNTL__IB_SWAP_ENABLE__SHIFT                                                             0x4
#define SDMA1_RLC5_IB_CNTL__SWITCH_INSIDE_IB__SHIFT                                                           0x8
#define SDMA1_RLC5_IB_CNTL__CMD_VMID__SHIFT                                                                   0x10
#define SDMA1_RLC5_IB_CNTL__IB_ENABLE_MASK                                                                    0x00000001L
#define SDMA1_RLC5_IB_CNTL__IB_SWAP_ENABLE_MASK                                                               0x00000010L
#define SDMA1_RLC5_IB_CNTL__SWITCH_INSIDE_IB_MASK                                                             0x00000100L
#define SDMA1_RLC5_IB_CNTL__CMD_VMID_MASK                                                                     0x000F0000L
//SDMA1_RLC5_IB_RPTR
#define SDMA1_RLC5_IB_RPTR__OFFSET__SHIFT                                                                     0x2
#define SDMA1_RLC5_IB_RPTR__OFFSET_MASK                                                                       0x003FFFFCL
//SDMA1_RLC5_IB_OFFSET
#define SDMA1_RLC5_IB_OFFSET__OFFSET__SHIFT                                                                   0x2
#define SDMA1_RLC5_IB_OFFSET__OFFSET_MASK                                                                     0x003FFFFCL
//SDMA1_RLC5_IB_BASE_LO
#define SDMA1_RLC5_IB_BASE_LO__ADDR__SHIFT                                                                    0x5
#define SDMA1_RLC5_IB_BASE_LO__ADDR_MASK                                                                      0xFFFFFFE0L
//SDMA1_RLC5_IB_BASE_HI
#define SDMA1_RLC5_IB_BASE_HI__ADDR__SHIFT                                                                    0x0
#define SDMA1_RLC5_IB_BASE_HI__ADDR_MASK                                                                      0xFFFFFFFFL
//SDMA1_RLC5_IB_SIZE
#define SDMA1_RLC5_IB_SIZE__SIZE__SHIFT                                                                       0x0
#define SDMA1_RLC5_IB_SIZE__SIZE_MASK                                                                         0x000FFFFFL
//SDMA1_RLC5_SKIP_CNTL
#define SDMA1_RLC5_SKIP_CNTL__SKIP_COUNT__SHIFT                                                               0x0
#define SDMA1_RLC5_SKIP_CNTL__SKIP_COUNT_MASK                                                                 0x000FFFFFL
//SDMA1_RLC5_CONTEXT_STATUS
#define SDMA1_RLC5_CONTEXT_STATUS__SELECTED__SHIFT                                                            0x0
#define SDMA1_RLC5_CONTEXT_STATUS__IDLE__SHIFT                                                                0x2
#define SDMA1_RLC5_CONTEXT_STATUS__EXPIRED__SHIFT                                                             0x3
#define SDMA1_RLC5_CONTEXT_STATUS__EXCEPTION__SHIFT                                                           0x4
#define SDMA1_RLC5_CONTEXT_STATUS__CTXSW_ABLE__SHIFT                                                          0x7
#define SDMA1_RLC5_CONTEXT_STATUS__CTXSW_READY__SHIFT                                                         0x8
#define SDMA1_RLC5_CONTEXT_STATUS__PREEMPTED__SHIFT                                                           0x9
#define SDMA1_RLC5_CONTEXT_STATUS__PREEMPT_DISABLE__SHIFT                                                     0xa
#define SDMA1_RLC5_CONTEXT_STATUS__SELECTED_MASK                                                              0x00000001L
#define SDMA1_RLC5_CONTEXT_STATUS__IDLE_MASK                                                                  0x00000004L
#define SDMA1_RLC5_CONTEXT_STATUS__EXPIRED_MASK                                                               0x00000008L
#define SDMA1_RLC5_CONTEXT_STATUS__EXCEPTION_MASK                                                             0x00000070L
#define SDMA1_RLC5_CONTEXT_STATUS__CTXSW_ABLE_MASK                                                            0x00000080L
#define SDMA1_RLC5_CONTEXT_STATUS__CTXSW_READY_MASK                                                           0x00000100L
#define SDMA1_RLC5_CONTEXT_STATUS__PREEMPTED_MASK                                                             0x00000200L
#define SDMA1_RLC5_CONTEXT_STATUS__PREEMPT_DISABLE_MASK                                                       0x00000400L
//SDMA1_RLC5_DOORBELL
#define SDMA1_RLC5_DOORBELL__ENABLE__SHIFT                                                                    0x1c
#define SDMA1_RLC5_DOORBELL__CAPTURED__SHIFT                                                                  0x1e
#define SDMA1_RLC5_DOORBELL__ENABLE_MASK                                                                      0x10000000L
#define SDMA1_RLC5_DOORBELL__CAPTURED_MASK                                                                    0x40000000L
//SDMA1_RLC5_STATUS
#define SDMA1_RLC5_STATUS__WPTR_UPDATE_FAIL_COUNT__SHIFT                                                      0x0
#define SDMA1_RLC5_STATUS__WPTR_UPDATE_PENDING__SHIFT                                                         0x8
#define SDMA1_RLC5_STATUS__WPTR_UPDATE_FAIL_COUNT_MASK                                                        0x000000FFL
#define SDMA1_RLC5_STATUS__WPTR_UPDATE_PENDING_MASK                                                           0x00000100L
//SDMA1_RLC5_DOORBELL_LOG
#define SDMA1_RLC5_DOORBELL_LOG__BE_ERROR__SHIFT                                                              0x0
#define SDMA1_RLC5_DOORBELL_LOG__DATA__SHIFT                                                                  0x2
#define SDMA1_RLC5_DOORBELL_LOG__BE_ERROR_MASK                                                                0x00000001L
#define SDMA1_RLC5_DOORBELL_LOG__DATA_MASK                                                                    0xFFFFFFFCL
//SDMA1_RLC5_WATERMARK
#define SDMA1_RLC5_WATERMARK__RD_OUTSTANDING__SHIFT                                                           0x0
#define SDMA1_RLC5_WATERMARK__WR_OUTSTANDING__SHIFT                                                           0x10
#define SDMA1_RLC5_WATERMARK__RD_OUTSTANDING_MASK                                                             0x00000FFFL
#define SDMA1_RLC5_WATERMARK__WR_OUTSTANDING_MASK                                                             0x03FF0000L
//SDMA1_RLC5_DOORBELL_OFFSET
#define SDMA1_RLC5_DOORBELL_OFFSET__OFFSET__SHIFT                                                             0x2
#define SDMA1_RLC5_DOORBELL_OFFSET__OFFSET_MASK                                                               0x0FFFFFFCL
//SDMA1_RLC5_CSA_ADDR_LO
#define SDMA1_RLC5_CSA_ADDR_LO__ADDR__SHIFT                                                                   0x2
#define SDMA1_RLC5_CSA_ADDR_LO__ADDR_MASK                                                                     0xFFFFFFFCL
//SDMA1_RLC5_CSA_ADDR_HI
#define SDMA1_RLC5_CSA_ADDR_HI__ADDR__SHIFT                                                                   0x0
#define SDMA1_RLC5_CSA_ADDR_HI__ADDR_MASK                                                                     0xFFFFFFFFL
//SDMA1_RLC5_IB_SUB_REMAIN
#define SDMA1_RLC5_IB_SUB_REMAIN__SIZE__SHIFT                                                                 0x0
#define SDMA1_RLC5_IB_SUB_REMAIN__SIZE_MASK                                                                   0x00003FFFL
//SDMA1_RLC5_PREEMPT
#define SDMA1_RLC5_PREEMPT__IB_PREEMPT__SHIFT                                                                 0x0
#define SDMA1_RLC5_PREEMPT__IB_PREEMPT_MASK                                                                   0x00000001L
//SDMA1_RLC5_DUMMY_REG
#define SDMA1_RLC5_DUMMY_REG__DUMMY__SHIFT                                                                    0x0
#define SDMA1_RLC5_DUMMY_REG__DUMMY_MASK                                                                      0xFFFFFFFFL
//SDMA1_RLC5_RB_WPTR_POLL_ADDR_HI
#define SDMA1_RLC5_RB_WPTR_POLL_ADDR_HI__ADDR__SHIFT                                                          0x0
#define SDMA1_RLC5_RB_WPTR_POLL_ADDR_HI__ADDR_MASK                                                            0xFFFFFFFFL
//SDMA1_RLC5_RB_WPTR_POLL_ADDR_LO
#define SDMA1_RLC5_RB_WPTR_POLL_ADDR_LO__ADDR__SHIFT                                                          0x2
#define SDMA1_RLC5_RB_WPTR_POLL_ADDR_LO__ADDR_MASK                                                            0xFFFFFFFCL
//SDMA1_RLC5_RB_AQL_CNTL
#define SDMA1_RLC5_RB_AQL_CNTL__AQL_ENABLE__SHIFT                                                             0x0
#define SDMA1_RLC5_RB_AQL_CNTL__AQL_PACKET_SIZE__SHIFT                                                        0x1
#define SDMA1_RLC5_RB_AQL_CNTL__PACKET_STEP__SHIFT                                                            0x8
#define SDMA1_RLC5_RB_AQL_CNTL__MIDCMD_PREEMPT_ENABLE__SHIFT                                                  0x10
#define SDMA1_RLC5_RB_AQL_CNTL__MIDCMD_PREEMPT_DATA_RESTORE__SHIFT                                            0x11
#define SDMA1_RLC5_RB_AQL_CNTL__OVERLAP_ENABLE__SHIFT                                                         0x12
#define SDMA1_RLC5_RB_AQL_CNTL__AQL_ENABLE_MASK                                                               0x00000001L
#define SDMA1_RLC5_RB_AQL_CNTL__AQL_PACKET_SIZE_MASK                                                          0x000000FEL
#define SDMA1_RLC5_RB_AQL_CNTL__PACKET_STEP_MASK                                                              0x0000FF00L
#define SDMA1_RLC5_RB_AQL_CNTL__MIDCMD_PREEMPT_ENABLE_MASK                                                    0x00010000L
#define SDMA1_RLC5_RB_AQL_CNTL__MIDCMD_PREEMPT_DATA_RESTORE_MASK                                              0x00020000L
#define SDMA1_RLC5_RB_AQL_CNTL__OVERLAP_ENABLE_MASK                                                           0x00040000L
//SDMA1_RLC5_MINOR_PTR_UPDATE
#define SDMA1_RLC5_MINOR_PTR_UPDATE__ENABLE__SHIFT                                                            0x0
#define SDMA1_RLC5_MINOR_PTR_UPDATE__ENABLE_MASK                                                              0x00000001L
//SDMA1_RLC5_MIDCMD_DATA0
#define SDMA1_RLC5_MIDCMD_DATA0__DATA0__SHIFT                                                                 0x0
#define SDMA1_RLC5_MIDCMD_DATA0__DATA0_MASK                                                                   0xFFFFFFFFL
//SDMA1_RLC5_MIDCMD_DATA1
#define SDMA1_RLC5_MIDCMD_DATA1__DATA1__SHIFT                                                                 0x0
#define SDMA1_RLC5_MIDCMD_DATA1__DATA1_MASK                                                                   0xFFFFFFFFL
//SDMA1_RLC5_MIDCMD_DATA2
#define SDMA1_RLC5_MIDCMD_DATA2__DATA2__SHIFT                                                                 0x0
#define SDMA1_RLC5_MIDCMD_DATA2__DATA2_MASK                                                                   0xFFFFFFFFL
//SDMA1_RLC5_MIDCMD_DATA3
#define SDMA1_RLC5_MIDCMD_DATA3__DATA3__SHIFT                                                                 0x0
#define SDMA1_RLC5_MIDCMD_DATA3__DATA3_MASK                                                                   0xFFFFFFFFL
//SDMA1_RLC5_MIDCMD_DATA4
#define SDMA1_RLC5_MIDCMD_DATA4__DATA4__SHIFT                                                                 0x0
#define SDMA1_RLC5_MIDCMD_DATA4__DATA4_MASK                                                                   0xFFFFFFFFL
//SDMA1_RLC5_MIDCMD_DATA5
#define SDMA1_RLC5_MIDCMD_DATA5__DATA5__SHIFT                                                                 0x0
#define SDMA1_RLC5_MIDCMD_DATA5__DATA5_MASK                                                                   0xFFFFFFFFL
//SDMA1_RLC5_MIDCMD_DATA6
#define SDMA1_RLC5_MIDCMD_DATA6__DATA6__SHIFT                                                                 0x0
#define SDMA1_RLC5_MIDCMD_DATA6__DATA6_MASK                                                                   0xFFFFFFFFL
//SDMA1_RLC5_MIDCMD_DATA7
#define SDMA1_RLC5_MIDCMD_DATA7__DATA7__SHIFT                                                                 0x0
#define SDMA1_RLC5_MIDCMD_DATA7__DATA7_MASK                                                                   0xFFFFFFFFL
//SDMA1_RLC5_MIDCMD_DATA8
#define SDMA1_RLC5_MIDCMD_DATA8__DATA8__SHIFT                                                                 0x0
#define SDMA1_RLC5_MIDCMD_DATA8__DATA8_MASK                                                                   0xFFFFFFFFL
//SDMA1_RLC5_MIDCMD_DATA9
#define SDMA1_RLC5_MIDCMD_DATA9__DATA9__SHIFT                                                                 0x0
#define SDMA1_RLC5_MIDCMD_DATA9__DATA9_MASK                                                                   0xFFFFFFFFL
//SDMA1_RLC5_MIDCMD_DATA10
#define SDMA1_RLC5_MIDCMD_DATA10__DATA10__SHIFT                                                               0x0
#define SDMA1_RLC5_MIDCMD_DATA10__DATA10_MASK                                                                 0xFFFFFFFFL
//SDMA1_RLC5_MIDCMD_CNTL
#define SDMA1_RLC5_MIDCMD_CNTL__DATA_VALID__SHIFT                                                             0x0
#define SDMA1_RLC5_MIDCMD_CNTL__COPY_MODE__SHIFT                                                              0x1
#define SDMA1_RLC5_MIDCMD_CNTL__SPLIT_STATE__SHIFT                                                            0x4
#define SDMA1_RLC5_MIDCMD_CNTL__ALLOW_PREEMPT__SHIFT                                                          0x8
#define SDMA1_RLC5_MIDCMD_CNTL__DATA_VALID_MASK                                                               0x00000001L
#define SDMA1_RLC5_MIDCMD_CNTL__COPY_MODE_MASK                                                                0x00000002L
#define SDMA1_RLC5_MIDCMD_CNTL__SPLIT_STATE_MASK                                                              0x000000F0L
#define SDMA1_RLC5_MIDCMD_CNTL__ALLOW_PREEMPT_MASK                                                            0x00000100L
//SDMA1_RLC6_RB_CNTL
#define SDMA1_RLC6_RB_CNTL__RB_ENABLE__SHIFT                                                                  0x0
#define SDMA1_RLC6_RB_CNTL__RB_SIZE__SHIFT                                                                    0x1
#define SDMA1_RLC6_RB_CNTL__RB_SWAP_ENABLE__SHIFT                                                             0x9
#define SDMA1_RLC6_RB_CNTL__RPTR_WRITEBACK_ENABLE__SHIFT                                                      0xc
#define SDMA1_RLC6_RB_CNTL__RPTR_WRITEBACK_SWAP_ENABLE__SHIFT                                                 0xd
#define SDMA1_RLC6_RB_CNTL__RPTR_WRITEBACK_TIMER__SHIFT                                                       0x10
#define SDMA1_RLC6_RB_CNTL__RB_PRIV__SHIFT                                                                    0x17
#define SDMA1_RLC6_RB_CNTL__RB_VMID__SHIFT                                                                    0x18
#define SDMA1_RLC6_RB_CNTL__RPTR_WB_IDLE__SHIFT                                                               0x1f
#define SDMA1_RLC6_RB_CNTL__RB_ENABLE_MASK                                                                    0x00000001L
#define SDMA1_RLC6_RB_CNTL__RB_SIZE_MASK                                                                      0x0000003EL
#define SDMA1_RLC6_RB_CNTL__RB_SWAP_ENABLE_MASK                                                               0x00000200L
#define SDMA1_RLC6_RB_CNTL__RPTR_WRITEBACK_ENABLE_MASK                                                        0x00001000L
#define SDMA1_RLC6_RB_CNTL__RPTR_WRITEBACK_SWAP_ENABLE_MASK                                                   0x00002000L
#define SDMA1_RLC6_RB_CNTL__RPTR_WRITEBACK_TIMER_MASK                                                         0x001F0000L
#define SDMA1_RLC6_RB_CNTL__RB_PRIV_MASK                                                                      0x00800000L
#define SDMA1_RLC6_RB_CNTL__RB_VMID_MASK                                                                      0x0F000000L
#define SDMA1_RLC6_RB_CNTL__RPTR_WB_IDLE_MASK                                                                 0x80000000L
//SDMA1_RLC6_RB_BASE
#define SDMA1_RLC6_RB_BASE__ADDR__SHIFT                                                                       0x0
#define SDMA1_RLC6_RB_BASE__ADDR_MASK                                                                         0xFFFFFFFFL
//SDMA1_RLC6_RB_BASE_HI
#define SDMA1_RLC6_RB_BASE_HI__ADDR__SHIFT                                                                    0x0
#define SDMA1_RLC6_RB_BASE_HI__ADDR_MASK                                                                      0x00FFFFFFL
//SDMA1_RLC6_RB_RPTR
#define SDMA1_RLC6_RB_RPTR__OFFSET__SHIFT                                                                     0x0
#define SDMA1_RLC6_RB_RPTR__OFFSET_MASK                                                                       0xFFFFFFFFL
//SDMA1_RLC6_RB_RPTR_HI
#define SDMA1_RLC6_RB_RPTR_HI__OFFSET__SHIFT                                                                  0x0
#define SDMA1_RLC6_RB_RPTR_HI__OFFSET_MASK                                                                    0xFFFFFFFFL
//SDMA1_RLC6_RB_WPTR
#define SDMA1_RLC6_RB_WPTR__OFFSET__SHIFT                                                                     0x0
#define SDMA1_RLC6_RB_WPTR__OFFSET_MASK                                                                       0xFFFFFFFFL
//SDMA1_RLC6_RB_WPTR_HI
#define SDMA1_RLC6_RB_WPTR_HI__OFFSET__SHIFT                                                                  0x0
#define SDMA1_RLC6_RB_WPTR_HI__OFFSET_MASK                                                                    0xFFFFFFFFL
//SDMA1_RLC6_RB_WPTR_POLL_CNTL
#define SDMA1_RLC6_RB_WPTR_POLL_CNTL__ENABLE__SHIFT                                                           0x0
#define SDMA1_RLC6_RB_WPTR_POLL_CNTL__SWAP_ENABLE__SHIFT                                                      0x1
#define SDMA1_RLC6_RB_WPTR_POLL_CNTL__F32_POLL_ENABLE__SHIFT                                                  0x2
#define SDMA1_RLC6_RB_WPTR_POLL_CNTL__FREQUENCY__SHIFT                                                        0x4
#define SDMA1_RLC6_RB_WPTR_POLL_CNTL__IDLE_POLL_COUNT__SHIFT                                                  0x10
#define SDMA1_RLC6_RB_WPTR_POLL_CNTL__ENABLE_MASK                                                             0x00000001L
#define SDMA1_RLC6_RB_WPTR_POLL_CNTL__SWAP_ENABLE_MASK                                                        0x00000002L
#define SDMA1_RLC6_RB_WPTR_POLL_CNTL__F32_POLL_ENABLE_MASK                                                    0x00000004L
#define SDMA1_RLC6_RB_WPTR_POLL_CNTL__FREQUENCY_MASK                                                          0x0000FFF0L
#define SDMA1_RLC6_RB_WPTR_POLL_CNTL__IDLE_POLL_COUNT_MASK                                                    0xFFFF0000L
//SDMA1_RLC6_RB_RPTR_ADDR_HI
#define SDMA1_RLC6_RB_RPTR_ADDR_HI__ADDR__SHIFT                                                               0x0
#define SDMA1_RLC6_RB_RPTR_ADDR_HI__ADDR_MASK                                                                 0xFFFFFFFFL
//SDMA1_RLC6_RB_RPTR_ADDR_LO
#define SDMA1_RLC6_RB_RPTR_ADDR_LO__ADDR__SHIFT                                                               0x2
#define SDMA1_RLC6_RB_RPTR_ADDR_LO__ADDR_MASK                                                                 0xFFFFFFFCL
//SDMA1_RLC6_IB_CNTL
#define SDMA1_RLC6_IB_CNTL__IB_ENABLE__SHIFT                                                                  0x0
#define SDMA1_RLC6_IB_CNTL__IB_SWAP_ENABLE__SHIFT                                                             0x4
#define SDMA1_RLC6_IB_CNTL__SWITCH_INSIDE_IB__SHIFT                                                           0x8
#define SDMA1_RLC6_IB_CNTL__CMD_VMID__SHIFT                                                                   0x10
#define SDMA1_RLC6_IB_CNTL__IB_ENABLE_MASK                                                                    0x00000001L
#define SDMA1_RLC6_IB_CNTL__IB_SWAP_ENABLE_MASK                                                               0x00000010L
#define SDMA1_RLC6_IB_CNTL__SWITCH_INSIDE_IB_MASK                                                             0x00000100L
#define SDMA1_RLC6_IB_CNTL__CMD_VMID_MASK                                                                     0x000F0000L
//SDMA1_RLC6_IB_RPTR
#define SDMA1_RLC6_IB_RPTR__OFFSET__SHIFT                                                                     0x2
#define SDMA1_RLC6_IB_RPTR__OFFSET_MASK                                                                       0x003FFFFCL
//SDMA1_RLC6_IB_OFFSET
#define SDMA1_RLC6_IB_OFFSET__OFFSET__SHIFT                                                                   0x2
#define SDMA1_RLC6_IB_OFFSET__OFFSET_MASK                                                                     0x003FFFFCL
//SDMA1_RLC6_IB_BASE_LO
#define SDMA1_RLC6_IB_BASE_LO__ADDR__SHIFT                                                                    0x5
#define SDMA1_RLC6_IB_BASE_LO__ADDR_MASK                                                                      0xFFFFFFE0L
//SDMA1_RLC6_IB_BASE_HI
#define SDMA1_RLC6_IB_BASE_HI__ADDR__SHIFT                                                                    0x0
#define SDMA1_RLC6_IB_BASE_HI__ADDR_MASK                                                                      0xFFFFFFFFL
//SDMA1_RLC6_IB_SIZE
#define SDMA1_RLC6_IB_SIZE__SIZE__SHIFT                                                                       0x0
#define SDMA1_RLC6_IB_SIZE__SIZE_MASK                                                                         0x000FFFFFL
//SDMA1_RLC6_SKIP_CNTL
#define SDMA1_RLC6_SKIP_CNTL__SKIP_COUNT__SHIFT                                                               0x0
#define SDMA1_RLC6_SKIP_CNTL__SKIP_COUNT_MASK                                                                 0x000FFFFFL
//SDMA1_RLC6_CONTEXT_STATUS
#define SDMA1_RLC6_CONTEXT_STATUS__SELECTED__SHIFT                                                            0x0
#define SDMA1_RLC6_CONTEXT_STATUS__IDLE__SHIFT                                                                0x2
#define SDMA1_RLC6_CONTEXT_STATUS__EXPIRED__SHIFT                                                             0x3
#define SDMA1_RLC6_CONTEXT_STATUS__EXCEPTION__SHIFT                                                           0x4
#define SDMA1_RLC6_CONTEXT_STATUS__CTXSW_ABLE__SHIFT                                                          0x7
#define SDMA1_RLC6_CONTEXT_STATUS__CTXSW_READY__SHIFT                                                         0x8
#define SDMA1_RLC6_CONTEXT_STATUS__PREEMPTED__SHIFT                                                           0x9
#define SDMA1_RLC6_CONTEXT_STATUS__PREEMPT_DISABLE__SHIFT                                                     0xa
#define SDMA1_RLC6_CONTEXT_STATUS__SELECTED_MASK                                                              0x00000001L
#define SDMA1_RLC6_CONTEXT_STATUS__IDLE_MASK                                                                  0x00000004L
#define SDMA1_RLC6_CONTEXT_STATUS__EXPIRED_MASK                                                               0x00000008L
#define SDMA1_RLC6_CONTEXT_STATUS__EXCEPTION_MASK                                                             0x00000070L
#define SDMA1_RLC6_CONTEXT_STATUS__CTXSW_ABLE_MASK                                                            0x00000080L
#define SDMA1_RLC6_CONTEXT_STATUS__CTXSW_READY_MASK                                                           0x00000100L
#define SDMA1_RLC6_CONTEXT_STATUS__PREEMPTED_MASK                                                             0x00000200L
#define SDMA1_RLC6_CONTEXT_STATUS__PREEMPT_DISABLE_MASK                                                       0x00000400L
//SDMA1_RLC6_DOORBELL
#define SDMA1_RLC6_DOORBELL__ENABLE__SHIFT                                                                    0x1c
#define SDMA1_RLC6_DOORBELL__CAPTURED__SHIFT                                                                  0x1e
#define SDMA1_RLC6_DOORBELL__ENABLE_MASK                                                                      0x10000000L
#define SDMA1_RLC6_DOORBELL__CAPTURED_MASK                                                                    0x40000000L
//SDMA1_RLC6_STATUS
#define SDMA1_RLC6_STATUS__WPTR_UPDATE_FAIL_COUNT__SHIFT                                                      0x0
#define SDMA1_RLC6_STATUS__WPTR_UPDATE_PENDING__SHIFT                                                         0x8
#define SDMA1_RLC6_STATUS__WPTR_UPDATE_FAIL_COUNT_MASK                                                        0x000000FFL
#define SDMA1_RLC6_STATUS__WPTR_UPDATE_PENDING_MASK                                                           0x00000100L
//SDMA1_RLC6_DOORBELL_LOG
#define SDMA1_RLC6_DOORBELL_LOG__BE_ERROR__SHIFT                                                              0x0
#define SDMA1_RLC6_DOORBELL_LOG__DATA__SHIFT                                                                  0x2
#define SDMA1_RLC6_DOORBELL_LOG__BE_ERROR_MASK                                                                0x00000001L
#define SDMA1_RLC6_DOORBELL_LOG__DATA_MASK                                                                    0xFFFFFFFCL
//SDMA1_RLC6_WATERMARK
#define SDMA1_RLC6_WATERMARK__RD_OUTSTANDING__SHIFT                                                           0x0
#define SDMA1_RLC6_WATERMARK__WR_OUTSTANDING__SHIFT                                                           0x10
#define SDMA1_RLC6_WATERMARK__RD_OUTSTANDING_MASK                                                             0x00000FFFL
#define SDMA1_RLC6_WATERMARK__WR_OUTSTANDING_MASK                                                             0x03FF0000L
//SDMA1_RLC6_DOORBELL_OFFSET
#define SDMA1_RLC6_DOORBELL_OFFSET__OFFSET__SHIFT                                                             0x2
#define SDMA1_RLC6_DOORBELL_OFFSET__OFFSET_MASK                                                               0x0FFFFFFCL
//SDMA1_RLC6_CSA_ADDR_LO
#define SDMA1_RLC6_CSA_ADDR_LO__ADDR__SHIFT                                                                   0x2
#define SDMA1_RLC6_CSA_ADDR_LO__ADDR_MASK                                                                     0xFFFFFFFCL
//SDMA1_RLC6_CSA_ADDR_HI
#define SDMA1_RLC6_CSA_ADDR_HI__ADDR__SHIFT                                                                   0x0
#define SDMA1_RLC6_CSA_ADDR_HI__ADDR_MASK                                                                     0xFFFFFFFFL
//SDMA1_RLC6_IB_SUB_REMAIN
#define SDMA1_RLC6_IB_SUB_REMAIN__SIZE__SHIFT                                                                 0x0
#define SDMA1_RLC6_IB_SUB_REMAIN__SIZE_MASK                                                                   0x00003FFFL
//SDMA1_RLC6_PREEMPT
#define SDMA1_RLC6_PREEMPT__IB_PREEMPT__SHIFT                                                                 0x0
#define SDMA1_RLC6_PREEMPT__IB_PREEMPT_MASK                                                                   0x00000001L
//SDMA1_RLC6_DUMMY_REG
#define SDMA1_RLC6_DUMMY_REG__DUMMY__SHIFT                                                                    0x0
#define SDMA1_RLC6_DUMMY_REG__DUMMY_MASK                                                                      0xFFFFFFFFL
//SDMA1_RLC6_RB_WPTR_POLL_ADDR_HI
#define SDMA1_RLC6_RB_WPTR_POLL_ADDR_HI__ADDR__SHIFT                                                          0x0
#define SDMA1_RLC6_RB_WPTR_POLL_ADDR_HI__ADDR_MASK                                                            0xFFFFFFFFL
//SDMA1_RLC6_RB_WPTR_POLL_ADDR_LO
#define SDMA1_RLC6_RB_WPTR_POLL_ADDR_LO__ADDR__SHIFT                                                          0x2
#define SDMA1_RLC6_RB_WPTR_POLL_ADDR_LO__ADDR_MASK                                                            0xFFFFFFFCL
//SDMA1_RLC6_RB_AQL_CNTL
#define SDMA1_RLC6_RB_AQL_CNTL__AQL_ENABLE__SHIFT                                                             0x0
#define SDMA1_RLC6_RB_AQL_CNTL__AQL_PACKET_SIZE__SHIFT                                                        0x1
#define SDMA1_RLC6_RB_AQL_CNTL__PACKET_STEP__SHIFT                                                            0x8
#define SDMA1_RLC6_RB_AQL_CNTL__MIDCMD_PREEMPT_ENABLE__SHIFT                                                  0x10
#define SDMA1_RLC6_RB_AQL_CNTL__MIDCMD_PREEMPT_DATA_RESTORE__SHIFT                                            0x11
#define SDMA1_RLC6_RB_AQL_CNTL__OVERLAP_ENABLE__SHIFT                                                         0x12
#define SDMA1_RLC6_RB_AQL_CNTL__AQL_ENABLE_MASK                                                               0x00000001L
#define SDMA1_RLC6_RB_AQL_CNTL__AQL_PACKET_SIZE_MASK                                                          0x000000FEL
#define SDMA1_RLC6_RB_AQL_CNTL__PACKET_STEP_MASK                                                              0x0000FF00L
#define SDMA1_RLC6_RB_AQL_CNTL__MIDCMD_PREEMPT_ENABLE_MASK                                                    0x00010000L
#define SDMA1_RLC6_RB_AQL_CNTL__MIDCMD_PREEMPT_DATA_RESTORE_MASK                                              0x00020000L
#define SDMA1_RLC6_RB_AQL_CNTL__OVERLAP_ENABLE_MASK                                                           0x00040000L
//SDMA1_RLC6_MINOR_PTR_UPDATE
#define SDMA1_RLC6_MINOR_PTR_UPDATE__ENABLE__SHIFT                                                            0x0
#define SDMA1_RLC6_MINOR_PTR_UPDATE__ENABLE_MASK                                                              0x00000001L
//SDMA1_RLC6_MIDCMD_DATA0
#define SDMA1_RLC6_MIDCMD_DATA0__DATA0__SHIFT                                                                 0x0
#define SDMA1_RLC6_MIDCMD_DATA0__DATA0_MASK                                                                   0xFFFFFFFFL
//SDMA1_RLC6_MIDCMD_DATA1
#define SDMA1_RLC6_MIDCMD_DATA1__DATA1__SHIFT                                                                 0x0
#define SDMA1_RLC6_MIDCMD_DATA1__DATA1_MASK                                                                   0xFFFFFFFFL
//SDMA1_RLC6_MIDCMD_DATA2
#define SDMA1_RLC6_MIDCMD_DATA2__DATA2__SHIFT                                                                 0x0
#define SDMA1_RLC6_MIDCMD_DATA2__DATA2_MASK                                                                   0xFFFFFFFFL
//SDMA1_RLC6_MIDCMD_DATA3
#define SDMA1_RLC6_MIDCMD_DATA3__DATA3__SHIFT                                                                 0x0
#define SDMA1_RLC6_MIDCMD_DATA3__DATA3_MASK                                                                   0xFFFFFFFFL
//SDMA1_RLC6_MIDCMD_DATA4
#define SDMA1_RLC6_MIDCMD_DATA4__DATA4__SHIFT                                                                 0x0
#define SDMA1_RLC6_MIDCMD_DATA4__DATA4_MASK                                                                   0xFFFFFFFFL
//SDMA1_RLC6_MIDCMD_DATA5
#define SDMA1_RLC6_MIDCMD_DATA5__DATA5__SHIFT                                                                 0x0
#define SDMA1_RLC6_MIDCMD_DATA5__DATA5_MASK                                                                   0xFFFFFFFFL
//SDMA1_RLC6_MIDCMD_DATA6
#define SDMA1_RLC6_MIDCMD_DATA6__DATA6__SHIFT                                                                 0x0
#define SDMA1_RLC6_MIDCMD_DATA6__DATA6_MASK                                                                   0xFFFFFFFFL
//SDMA1_RLC6_MIDCMD_DATA7
#define SDMA1_RLC6_MIDCMD_DATA7__DATA7__SHIFT                                                                 0x0
#define SDMA1_RLC6_MIDCMD_DATA7__DATA7_MASK                                                                   0xFFFFFFFFL
//SDMA1_RLC6_MIDCMD_DATA8
#define SDMA1_RLC6_MIDCMD_DATA8__DATA8__SHIFT                                                                 0x0
#define SDMA1_RLC6_MIDCMD_DATA8__DATA8_MASK                                                                   0xFFFFFFFFL
//SDMA1_RLC6_MIDCMD_DATA9
#define SDMA1_RLC6_MIDCMD_DATA9__DATA9__SHIFT                                                                 0x0
#define SDMA1_RLC6_MIDCMD_DATA9__DATA9_MASK                                                                   0xFFFFFFFFL
//SDMA1_RLC6_MIDCMD_DATA10
#define SDMA1_RLC6_MIDCMD_DATA10__DATA10__SHIFT                                                               0x0
#define SDMA1_RLC6_MIDCMD_DATA10__DATA10_MASK                                                                 0xFFFFFFFFL
//SDMA1_RLC6_MIDCMD_CNTL
#define SDMA1_RLC6_MIDCMD_CNTL__DATA_VALID__SHIFT                                                             0x0
#define SDMA1_RLC6_MIDCMD_CNTL__COPY_MODE__SHIFT                                                              0x1
#define SDMA1_RLC6_MIDCMD_CNTL__SPLIT_STATE__SHIFT                                                            0x4
#define SDMA1_RLC6_MIDCMD_CNTL__ALLOW_PREEMPT__SHIFT                                                          0x8
#define SDMA1_RLC6_MIDCMD_CNTL__DATA_VALID_MASK                                                               0x00000001L
#define SDMA1_RLC6_MIDCMD_CNTL__COPY_MODE_MASK                                                                0x00000002L
#define SDMA1_RLC6_MIDCMD_CNTL__SPLIT_STATE_MASK                                                              0x000000F0L
#define SDMA1_RLC6_MIDCMD_CNTL__ALLOW_PREEMPT_MASK                                                            0x00000100L
//SDMA1_RLC7_RB_CNTL
#define SDMA1_RLC7_RB_CNTL__RB_ENABLE__SHIFT                                                                  0x0
#define SDMA1_RLC7_RB_CNTL__RB_SIZE__SHIFT                                                                    0x1
#define SDMA1_RLC7_RB_CNTL__RB_SWAP_ENABLE__SHIFT                                                             0x9
#define SDMA1_RLC7_RB_CNTL__RPTR_WRITEBACK_ENABLE__SHIFT                                                      0xc
#define SDMA1_RLC7_RB_CNTL__RPTR_WRITEBACK_SWAP_ENABLE__SHIFT                                                 0xd
#define SDMA1_RLC7_RB_CNTL__RPTR_WRITEBACK_TIMER__SHIFT                                                       0x10
#define SDMA1_RLC7_RB_CNTL__RB_PRIV__SHIFT                                                                    0x17
#define SDMA1_RLC7_RB_CNTL__RB_VMID__SHIFT                                                                    0x18
#define SDMA1_RLC7_RB_CNTL__RPTR_WB_IDLE__SHIFT                                                               0x1f
#define SDMA1_RLC7_RB_CNTL__RB_ENABLE_MASK                                                                    0x00000001L
#define SDMA1_RLC7_RB_CNTL__RB_SIZE_MASK                                                                      0x0000003EL
#define SDMA1_RLC7_RB_CNTL__RB_SWAP_ENABLE_MASK                                                               0x00000200L
#define SDMA1_RLC7_RB_CNTL__RPTR_WRITEBACK_ENABLE_MASK                                                        0x00001000L
#define SDMA1_RLC7_RB_CNTL__RPTR_WRITEBACK_SWAP_ENABLE_MASK                                                   0x00002000L
#define SDMA1_RLC7_RB_CNTL__RPTR_WRITEBACK_TIMER_MASK                                                         0x001F0000L
#define SDMA1_RLC7_RB_CNTL__RB_PRIV_MASK                                                                      0x00800000L
#define SDMA1_RLC7_RB_CNTL__RB_VMID_MASK                                                                      0x0F000000L
#define SDMA1_RLC7_RB_CNTL__RPTR_WB_IDLE_MASK                                                                 0x80000000L
//SDMA1_RLC7_RB_BASE
#define SDMA1_RLC7_RB_BASE__ADDR__SHIFT                                                                       0x0
#define SDMA1_RLC7_RB_BASE__ADDR_MASK                                                                         0xFFFFFFFFL
//SDMA1_RLC7_RB_BASE_HI
#define SDMA1_RLC7_RB_BASE_HI__ADDR__SHIFT                                                                    0x0
#define SDMA1_RLC7_RB_BASE_HI__ADDR_MASK                                                                      0x00FFFFFFL
//SDMA1_RLC7_RB_RPTR
#define SDMA1_RLC7_RB_RPTR__OFFSET__SHIFT                                                                     0x0
#define SDMA1_RLC7_RB_RPTR__OFFSET_MASK                                                                       0xFFFFFFFFL
//SDMA1_RLC7_RB_RPTR_HI
#define SDMA1_RLC7_RB_RPTR_HI__OFFSET__SHIFT                                                                  0x0
#define SDMA1_RLC7_RB_RPTR_HI__OFFSET_MASK                                                                    0xFFFFFFFFL
//SDMA1_RLC7_RB_WPTR
#define SDMA1_RLC7_RB_WPTR__OFFSET__SHIFT                                                                     0x0
#define SDMA1_RLC7_RB_WPTR__OFFSET_MASK                                                                       0xFFFFFFFFL
//SDMA1_RLC7_RB_WPTR_HI
#define SDMA1_RLC7_RB_WPTR_HI__OFFSET__SHIFT                                                                  0x0
#define SDMA1_RLC7_RB_WPTR_HI__OFFSET_MASK                                                                    0xFFFFFFFFL
//SDMA1_RLC7_RB_WPTR_POLL_CNTL
#define SDMA1_RLC7_RB_WPTR_POLL_CNTL__ENABLE__SHIFT                                                           0x0
#define SDMA1_RLC7_RB_WPTR_POLL_CNTL__SWAP_ENABLE__SHIFT                                                      0x1
#define SDMA1_RLC7_RB_WPTR_POLL_CNTL__F32_POLL_ENABLE__SHIFT                                                  0x2
#define SDMA1_RLC7_RB_WPTR_POLL_CNTL__FREQUENCY__SHIFT                                                        0x4
#define SDMA1_RLC7_RB_WPTR_POLL_CNTL__IDLE_POLL_COUNT__SHIFT                                                  0x10
#define SDMA1_RLC7_RB_WPTR_POLL_CNTL__ENABLE_MASK                                                             0x00000001L
#define SDMA1_RLC7_RB_WPTR_POLL_CNTL__SWAP_ENABLE_MASK                                                        0x00000002L
#define SDMA1_RLC7_RB_WPTR_POLL_CNTL__F32_POLL_ENABLE_MASK                                                    0x00000004L
#define SDMA1_RLC7_RB_WPTR_POLL_CNTL__FREQUENCY_MASK                                                          0x0000FFF0L
#define SDMA1_RLC7_RB_WPTR_POLL_CNTL__IDLE_POLL_COUNT_MASK                                                    0xFFFF0000L
//SDMA1_RLC7_RB_RPTR_ADDR_HI
#define SDMA1_RLC7_RB_RPTR_ADDR_HI__ADDR__SHIFT                                                               0x0
#define SDMA1_RLC7_RB_RPTR_ADDR_HI__ADDR_MASK                                                                 0xFFFFFFFFL
//SDMA1_RLC7_RB_RPTR_ADDR_LO
#define SDMA1_RLC7_RB_RPTR_ADDR_LO__ADDR__SHIFT                                                               0x2
#define SDMA1_RLC7_RB_RPTR_ADDR_LO__ADDR_MASK                                                                 0xFFFFFFFCL
//SDMA1_RLC7_IB_CNTL
#define SDMA1_RLC7_IB_CNTL__IB_ENABLE__SHIFT                                                                  0x0
#define SDMA1_RLC7_IB_CNTL__IB_SWAP_ENABLE__SHIFT                                                             0x4
#define SDMA1_RLC7_IB_CNTL__SWITCH_INSIDE_IB__SHIFT                                                           0x8
#define SDMA1_RLC7_IB_CNTL__CMD_VMID__SHIFT                                                                   0x10
#define SDMA1_RLC7_IB_CNTL__IB_ENABLE_MASK                                                                    0x00000001L
#define SDMA1_RLC7_IB_CNTL__IB_SWAP_ENABLE_MASK                                                               0x00000010L
#define SDMA1_RLC7_IB_CNTL__SWITCH_INSIDE_IB_MASK                                                             0x00000100L
#define SDMA1_RLC7_IB_CNTL__CMD_VMID_MASK                                                                     0x000F0000L
//SDMA1_RLC7_IB_RPTR
#define SDMA1_RLC7_IB_RPTR__OFFSET__SHIFT                                                                     0x2
#define SDMA1_RLC7_IB_RPTR__OFFSET_MASK                                                                       0x003FFFFCL
//SDMA1_RLC7_IB_OFFSET
#define SDMA1_RLC7_IB_OFFSET__OFFSET__SHIFT                                                                   0x2
#define SDMA1_RLC7_IB_OFFSET__OFFSET_MASK                                                                     0x003FFFFCL
//SDMA1_RLC7_IB_BASE_LO
#define SDMA1_RLC7_IB_BASE_LO__ADDR__SHIFT                                                                    0x5
#define SDMA1_RLC7_IB_BASE_LO__ADDR_MASK                                                                      0xFFFFFFE0L
//SDMA1_RLC7_IB_BASE_HI
#define SDMA1_RLC7_IB_BASE_HI__ADDR__SHIFT                                                                    0x0
#define SDMA1_RLC7_IB_BASE_HI__ADDR_MASK                                                                      0xFFFFFFFFL
//SDMA1_RLC7_IB_SIZE
#define SDMA1_RLC7_IB_SIZE__SIZE__SHIFT                                                                       0x0
#define SDMA1_RLC7_IB_SIZE__SIZE_MASK                                                                         0x000FFFFFL
//SDMA1_RLC7_SKIP_CNTL
#define SDMA1_RLC7_SKIP_CNTL__SKIP_COUNT__SHIFT                                                               0x0
#define SDMA1_RLC7_SKIP_CNTL__SKIP_COUNT_MASK                                                                 0x000FFFFFL
//SDMA1_RLC7_CONTEXT_STATUS
#define SDMA1_RLC7_CONTEXT_STATUS__SELECTED__SHIFT                                                            0x0
#define SDMA1_RLC7_CONTEXT_STATUS__IDLE__SHIFT                                                                0x2
#define SDMA1_RLC7_CONTEXT_STATUS__EXPIRED__SHIFT                                                             0x3
#define SDMA1_RLC7_CONTEXT_STATUS__EXCEPTION__SHIFT                                                           0x4
#define SDMA1_RLC7_CONTEXT_STATUS__CTXSW_ABLE__SHIFT                                                          0x7
#define SDMA1_RLC7_CONTEXT_STATUS__CTXSW_READY__SHIFT                                                         0x8
#define SDMA1_RLC7_CONTEXT_STATUS__PREEMPTED__SHIFT                                                           0x9
#define SDMA1_RLC7_CONTEXT_STATUS__PREEMPT_DISABLE__SHIFT                                                     0xa
#define SDMA1_RLC7_CONTEXT_STATUS__SELECTED_MASK                                                              0x00000001L
#define SDMA1_RLC7_CONTEXT_STATUS__IDLE_MASK                                                                  0x00000004L
#define SDMA1_RLC7_CONTEXT_STATUS__EXPIRED_MASK                                                               0x00000008L
#define SDMA1_RLC7_CONTEXT_STATUS__EXCEPTION_MASK                                                             0x00000070L
#define SDMA1_RLC7_CONTEXT_STATUS__CTXSW_ABLE_MASK                                                            0x00000080L
#define SDMA1_RLC7_CONTEXT_STATUS__CTXSW_READY_MASK                                                           0x00000100L
#define SDMA1_RLC7_CONTEXT_STATUS__PREEMPTED_MASK                                                             0x00000200L
#define SDMA1_RLC7_CONTEXT_STATUS__PREEMPT_DISABLE_MASK                                                       0x00000400L
//SDMA1_RLC7_DOORBELL
#define SDMA1_RLC7_DOORBELL__ENABLE__SHIFT                                                                    0x1c
#define SDMA1_RLC7_DOORBELL__CAPTURED__SHIFT                                                                  0x1e
#define SDMA1_RLC7_DOORBELL__ENABLE_MASK                                                                      0x10000000L
#define SDMA1_RLC7_DOORBELL__CAPTURED_MASK                                                                    0x40000000L
//SDMA1_RLC7_STATUS
#define SDMA1_RLC7_STATUS__WPTR_UPDATE_FAIL_COUNT__SHIFT                                                      0x0
#define SDMA1_RLC7_STATUS__WPTR_UPDATE_PENDING__SHIFT                                                         0x8
#define SDMA1_RLC7_STATUS__WPTR_UPDATE_FAIL_COUNT_MASK                                                        0x000000FFL
#define SDMA1_RLC7_STATUS__WPTR_UPDATE_PENDING_MASK                                                           0x00000100L
//SDMA1_RLC7_DOORBELL_LOG
#define SDMA1_RLC7_DOORBELL_LOG__BE_ERROR__SHIFT                                                              0x0
#define SDMA1_RLC7_DOORBELL_LOG__DATA__SHIFT                                                                  0x2
#define SDMA1_RLC7_DOORBELL_LOG__BE_ERROR_MASK                                                                0x00000001L
#define SDMA1_RLC7_DOORBELL_LOG__DATA_MASK                                                                    0xFFFFFFFCL
//SDMA1_RLC7_WATERMARK
#define SDMA1_RLC7_WATERMARK__RD_OUTSTANDING__SHIFT                                                           0x0
#define SDMA1_RLC7_WATERMARK__WR_OUTSTANDING__SHIFT                                                           0x10
#define SDMA1_RLC7_WATERMARK__RD_OUTSTANDING_MASK                                                             0x00000FFFL
#define SDMA1_RLC7_WATERMARK__WR_OUTSTANDING_MASK                                                             0x03FF0000L
//SDMA1_RLC7_DOORBELL_OFFSET
#define SDMA1_RLC7_DOORBELL_OFFSET__OFFSET__SHIFT                                                             0x2
#define SDMA1_RLC7_DOORBELL_OFFSET__OFFSET_MASK                                                               0x0FFFFFFCL
//SDMA1_RLC7_CSA_ADDR_LO
#define SDMA1_RLC7_CSA_ADDR_LO__ADDR__SHIFT                                                                   0x2
#define SDMA1_RLC7_CSA_ADDR_LO__ADDR_MASK                                                                     0xFFFFFFFCL
//SDMA1_RLC7_CSA_ADDR_HI
#define SDMA1_RLC7_CSA_ADDR_HI__ADDR__SHIFT                                                                   0x0
#define SDMA1_RLC7_CSA_ADDR_HI__ADDR_MASK                                                                     0xFFFFFFFFL
//SDMA1_RLC7_IB_SUB_REMAIN
#define SDMA1_RLC7_IB_SUB_REMAIN__SIZE__SHIFT                                                                 0x0
#define SDMA1_RLC7_IB_SUB_REMAIN__SIZE_MASK                                                                   0x00003FFFL
//SDMA1_RLC7_PREEMPT
#define SDMA1_RLC7_PREEMPT__IB_PREEMPT__SHIFT                                                                 0x0
#define SDMA1_RLC7_PREEMPT__IB_PREEMPT_MASK                                                                   0x00000001L
//SDMA1_RLC7_DUMMY_REG
#define SDMA1_RLC7_DUMMY_REG__DUMMY__SHIFT                                                                    0x0
#define SDMA1_RLC7_DUMMY_REG__DUMMY_MASK                                                                      0xFFFFFFFFL
//SDMA1_RLC7_RB_WPTR_POLL_ADDR_HI
#define SDMA1_RLC7_RB_WPTR_POLL_ADDR_HI__ADDR__SHIFT                                                          0x0
#define SDMA1_RLC7_RB_WPTR_POLL_ADDR_HI__ADDR_MASK                                                            0xFFFFFFFFL
//SDMA1_RLC7_RB_WPTR_POLL_ADDR_LO
#define SDMA1_RLC7_RB_WPTR_POLL_ADDR_LO__ADDR__SHIFT                                                          0x2
#define SDMA1_RLC7_RB_WPTR_POLL_ADDR_LO__ADDR_MASK                                                            0xFFFFFFFCL
//SDMA1_RLC7_RB_AQL_CNTL
#define SDMA1_RLC7_RB_AQL_CNTL__AQL_ENABLE__SHIFT                                                             0x0
#define SDMA1_RLC7_RB_AQL_CNTL__AQL_PACKET_SIZE__SHIFT                                                        0x1
#define SDMA1_RLC7_RB_AQL_CNTL__PACKET_STEP__SHIFT                                                            0x8
#define SDMA1_RLC7_RB_AQL_CNTL__MIDCMD_PREEMPT_ENABLE__SHIFT                                                  0x10
#define SDMA1_RLC7_RB_AQL_CNTL__MIDCMD_PREEMPT_DATA_RESTORE__SHIFT                                            0x11
#define SDMA1_RLC7_RB_AQL_CNTL__OVERLAP_ENABLE__SHIFT                                                         0x12
#define SDMA1_RLC7_RB_AQL_CNTL__AQL_ENABLE_MASK                                                               0x00000001L
#define SDMA1_RLC7_RB_AQL_CNTL__AQL_PACKET_SIZE_MASK                                                          0x000000FEL
#define SDMA1_RLC7_RB_AQL_CNTL__PACKET_STEP_MASK                                                              0x0000FF00L
#define SDMA1_RLC7_RB_AQL_CNTL__MIDCMD_PREEMPT_ENABLE_MASK                                                    0x00010000L
#define SDMA1_RLC7_RB_AQL_CNTL__MIDCMD_PREEMPT_DATA_RESTORE_MASK                                              0x00020000L
#define SDMA1_RLC7_RB_AQL_CNTL__OVERLAP_ENABLE_MASK                                                           0x00040000L
//SDMA1_RLC7_MINOR_PTR_UPDATE
#define SDMA1_RLC7_MINOR_PTR_UPDATE__ENABLE__SHIFT                                                            0x0
#define SDMA1_RLC7_MINOR_PTR_UPDATE__ENABLE_MASK                                                              0x00000001L
//SDMA1_RLC7_MIDCMD_DATA0
#define SDMA1_RLC7_MIDCMD_DATA0__DATA0__SHIFT                                                                 0x0
#define SDMA1_RLC7_MIDCMD_DATA0__DATA0_MASK                                                                   0xFFFFFFFFL
//SDMA1_RLC7_MIDCMD_DATA1
#define SDMA1_RLC7_MIDCMD_DATA1__DATA1__SHIFT                                                                 0x0
#define SDMA1_RLC7_MIDCMD_DATA1__DATA1_MASK                                                                   0xFFFFFFFFL
//SDMA1_RLC7_MIDCMD_DATA2
#define SDMA1_RLC7_MIDCMD_DATA2__DATA2__SHIFT                                                                 0x0
#define SDMA1_RLC7_MIDCMD_DATA2__DATA2_MASK                                                                   0xFFFFFFFFL
//SDMA1_RLC7_MIDCMD_DATA3
#define SDMA1_RLC7_MIDCMD_DATA3__DATA3__SHIFT                                                                 0x0
#define SDMA1_RLC7_MIDCMD_DATA3__DATA3_MASK                                                                   0xFFFFFFFFL
//SDMA1_RLC7_MIDCMD_DATA4
#define SDMA1_RLC7_MIDCMD_DATA4__DATA4__SHIFT                                                                 0x0
#define SDMA1_RLC7_MIDCMD_DATA4__DATA4_MASK                                                                   0xFFFFFFFFL
//SDMA1_RLC7_MIDCMD_DATA5
#define SDMA1_RLC7_MIDCMD_DATA5__DATA5__SHIFT                                                                 0x0
#define SDMA1_RLC7_MIDCMD_DATA5__DATA5_MASK                                                                   0xFFFFFFFFL
//SDMA1_RLC7_MIDCMD_DATA6
#define SDMA1_RLC7_MIDCMD_DATA6__DATA6__SHIFT                                                                 0x0
#define SDMA1_RLC7_MIDCMD_DATA6__DATA6_MASK                                                                   0xFFFFFFFFL
//SDMA1_RLC7_MIDCMD_DATA7
#define SDMA1_RLC7_MIDCMD_DATA7__DATA7__SHIFT                                                                 0x0
#define SDMA1_RLC7_MIDCMD_DATA7__DATA7_MASK                                                                   0xFFFFFFFFL
//SDMA1_RLC7_MIDCMD_DATA8
#define SDMA1_RLC7_MIDCMD_DATA8__DATA8__SHIFT                                                                 0x0
#define SDMA1_RLC7_MIDCMD_DATA8__DATA8_MASK                                                                   0xFFFFFFFFL
//SDMA1_RLC7_MIDCMD_DATA9
#define SDMA1_RLC7_MIDCMD_DATA9__DATA9__SHIFT                                                                 0x0
#define SDMA1_RLC7_MIDCMD_DATA9__DATA9_MASK                                                                   0xFFFFFFFFL
//SDMA1_RLC7_MIDCMD_DATA10
#define SDMA1_RLC7_MIDCMD_DATA10__DATA10__SHIFT                                                               0x0
#define SDMA1_RLC7_MIDCMD_DATA10__DATA10_MASK                                                                 0xFFFFFFFFL
//SDMA1_RLC7_MIDCMD_CNTL
#define SDMA1_RLC7_MIDCMD_CNTL__DATA_VALID__SHIFT                                                             0x0
#define SDMA1_RLC7_MIDCMD_CNTL__COPY_MODE__SHIFT                                                              0x1
#define SDMA1_RLC7_MIDCMD_CNTL__SPLIT_STATE__SHIFT                                                            0x4
#define SDMA1_RLC7_MIDCMD_CNTL__ALLOW_PREEMPT__SHIFT                                                          0x8
#define SDMA1_RLC7_MIDCMD_CNTL__DATA_VALID_MASK                                                               0x00000001L
#define SDMA1_RLC7_MIDCMD_CNTL__COPY_MODE_MASK                                                                0x00000002L
#define SDMA1_RLC7_MIDCMD_CNTL__SPLIT_STATE_MASK                                                              0x000000F0L
#define SDMA1_RLC7_MIDCMD_CNTL__ALLOW_PREEMPT_MASK                                                            0x00000100L


// addressBlock: gc_grbmdec
//GRBM_CNTL
#define GRBM_CNTL__READ_TIMEOUT__SHIFT                                                                        0x0
#define GRBM_CNTL__REPORT_LAST_RDERR__SHIFT                                                                   0x1f
#define GRBM_CNTL__READ_TIMEOUT_MASK                                                                          0x000000FFL
#define GRBM_CNTL__REPORT_LAST_RDERR_MASK                                                                     0x80000000L
//GRBM_SKEW_CNTL
#define GRBM_SKEW_CNTL__SKEW_TOP_THRESHOLD__SHIFT                                                             0x0
#define GRBM_SKEW_CNTL__SKEW_COUNT__SHIFT                                                                     0x6
#define GRBM_SKEW_CNTL__SKEW_TOP_THRESHOLD_MASK                                                               0x0000003FL
#define GRBM_SKEW_CNTL__SKEW_COUNT_MASK                                                                       0x00000FC0L
//GRBM_STATUS2
#define GRBM_STATUS2__ME0PIPE1_CMDFIFO_AVAIL__SHIFT                                                           0x0
#define GRBM_STATUS2__ME0PIPE1_CF_RQ_PENDING__SHIFT                                                           0x4
#define GRBM_STATUS2__ME0PIPE1_PF_RQ_PENDING__SHIFT                                                           0x5
#define GRBM_STATUS2__ME1PIPE0_RQ_PENDING__SHIFT                                                              0x6
#define GRBM_STATUS2__ME1PIPE1_RQ_PENDING__SHIFT                                                              0x7
#define GRBM_STATUS2__ME1PIPE2_RQ_PENDING__SHIFT                                                              0x8
#define GRBM_STATUS2__ME1PIPE3_RQ_PENDING__SHIFT                                                              0x9
#define GRBM_STATUS2__ME2PIPE0_RQ_PENDING__SHIFT                                                              0xa
#define GRBM_STATUS2__ME2PIPE1_RQ_PENDING__SHIFT                                                              0xb
#define GRBM_STATUS2__ME2PIPE2_RQ_PENDING__SHIFT                                                              0xc
#define GRBM_STATUS2__ME2PIPE3_RQ_PENDING__SHIFT                                                              0xd
#define GRBM_STATUS2__RLC_RQ_PENDING__SHIFT                                                                   0xe
#define GRBM_STATUS2__UTCL2_BUSY__SHIFT                                                                       0xf
#define GRBM_STATUS2__EA_BUSY__SHIFT                                                                          0x10
#define GRBM_STATUS2__RMI_BUSY__SHIFT                                                                         0x11
#define GRBM_STATUS2__UTCL2_RQ_PENDING__SHIFT                                                                 0x12
#define GRBM_STATUS2__SDMA_SCH_RQ_PENDING__SHIFT                                                              0x13
#define GRBM_STATUS2__EA_LINK_BUSY__SHIFT                                                                     0x14
#define GRBM_STATUS2__SDMA_BUSY__SHIFT                                                                        0x15
#define GRBM_STATUS2__SDMA0_RQ_PENDING__SHIFT                                                                 0x16
#define GRBM_STATUS2__SDMA1_RQ_PENDING__SHIFT                                                                 0x17
#define GRBM_STATUS2__SDMA2_RQ_PENDING__SHIFT                                                                 0x18
#define GRBM_STATUS2__SDMA3_RQ_PENDING__SHIFT                                                                 0x19
#define GRBM_STATUS2__RLC_BUSY__SHIFT                                                                         0x1a
#define GRBM_STATUS2__TCP_BUSY__SHIFT                                                                         0x1b
#define GRBM_STATUS2__CPF_BUSY__SHIFT                                                                         0x1c
#define GRBM_STATUS2__CPC_BUSY__SHIFT                                                                         0x1d
#define GRBM_STATUS2__CPG_BUSY__SHIFT                                                                         0x1e
#define GRBM_STATUS2__CPAXI_BUSY__SHIFT                                                                       0x1f
#define GRBM_STATUS2__ME0PIPE1_CMDFIFO_AVAIL_MASK                                                             0x0000000FL
#define GRBM_STATUS2__ME0PIPE1_CF_RQ_PENDING_MASK                                                             0x00000010L
#define GRBM_STATUS2__ME0PIPE1_PF_RQ_PENDING_MASK                                                             0x00000020L
#define GRBM_STATUS2__ME1PIPE0_RQ_PENDING_MASK                                                                0x00000040L
#define GRBM_STATUS2__ME1PIPE1_RQ_PENDING_MASK                                                                0x00000080L
#define GRBM_STATUS2__ME1PIPE2_RQ_PENDING_MASK                                                                0x00000100L
#define GRBM_STATUS2__ME1PIPE3_RQ_PENDING_MASK                                                                0x00000200L
#define GRBM_STATUS2__ME2PIPE0_RQ_PENDING_MASK                                                                0x00000400L
#define GRBM_STATUS2__ME2PIPE1_RQ_PENDING_MASK                                                                0x00000800L
#define GRBM_STATUS2__ME2PIPE2_RQ_PENDING_MASK                                                                0x00001000L
#define GRBM_STATUS2__ME2PIPE3_RQ_PENDING_MASK                                                                0x00002000L
#define GRBM_STATUS2__RLC_RQ_PENDING_MASK                                                                     0x00004000L
#define GRBM_STATUS2__UTCL2_BUSY_MASK                                                                         0x00008000L
#define GRBM_STATUS2__EA_BUSY_MASK                                                                            0x00010000L
#define GRBM_STATUS2__RMI_BUSY_MASK                                                                           0x00020000L
#define GRBM_STATUS2__UTCL2_RQ_PENDING_MASK                                                                   0x00040000L
#define GRBM_STATUS2__SDMA_SCH_RQ_PENDING_MASK                                                                0x00080000L
#define GRBM_STATUS2__EA_LINK_BUSY_MASK                                                                       0x00100000L
#define GRBM_STATUS2__SDMA_BUSY_MASK                                                                          0x00200000L
#define GRBM_STATUS2__SDMA0_RQ_PENDING_MASK                                                                   0x00400000L
#define GRBM_STATUS2__SDMA1_RQ_PENDING_MASK                                                                   0x00800000L
#define GRBM_STATUS2__SDMA2_RQ_PENDING_MASK                                                                   0x01000000L
#define GRBM_STATUS2__SDMA3_RQ_PENDING_MASK                                                                   0x02000000L
#define GRBM_STATUS2__RLC_BUSY_MASK                                                                           0x04000000L
#define GRBM_STATUS2__TCP_BUSY_MASK                                                                           0x08000000L
#define GRBM_STATUS2__CPF_BUSY_MASK                                                                           0x10000000L
#define GRBM_STATUS2__CPC_BUSY_MASK                                                                           0x20000000L
#define GRBM_STATUS2__CPG_BUSY_MASK                                                                           0x40000000L
#define GRBM_STATUS2__CPAXI_BUSY_MASK                                                                         0x80000000L
//GRBM_PWR_CNTL
#define GRBM_PWR_CNTL__ALL_REQ_TYPE__SHIFT                                                                    0x0
#define GRBM_PWR_CNTL__GFX_REQ_TYPE__SHIFT                                                                    0x2
#define GRBM_PWR_CNTL__ALL_RSP_TYPE__SHIFT                                                                    0x4
#define GRBM_PWR_CNTL__GFX_RSP_TYPE__SHIFT                                                                    0x6
#define GRBM_PWR_CNTL__GFX_REQ_EN__SHIFT                                                                      0xe
#define GRBM_PWR_CNTL__ALL_REQ_EN__SHIFT                                                                      0xf
#define GRBM_PWR_CNTL__ALL_REQ_TYPE_MASK                                                                      0x00000003L
#define GRBM_PWR_CNTL__GFX_REQ_TYPE_MASK                                                                      0x0000000CL
#define GRBM_PWR_CNTL__ALL_RSP_TYPE_MASK                                                                      0x00000030L
#define GRBM_PWR_CNTL__GFX_RSP_TYPE_MASK                                                                      0x000000C0L
#define GRBM_PWR_CNTL__GFX_REQ_EN_MASK                                                                        0x00004000L
#define GRBM_PWR_CNTL__ALL_REQ_EN_MASK                                                                        0x00008000L
//GRBM_STATUS
#define GRBM_STATUS__ME0PIPE0_CMDFIFO_AVAIL__SHIFT                                                            0x0
#define GRBM_STATUS__ME0PIPE0_CF_RQ_PENDING__SHIFT                                                            0x7
#define GRBM_STATUS__ME0PIPE0_PF_RQ_PENDING__SHIFT                                                            0x8
#define GRBM_STATUS__GDS_DMA_RQ_PENDING__SHIFT                                                                0x9
#define GRBM_STATUS__DB_CLEAN__SHIFT                                                                          0xc
#define GRBM_STATUS__CB_CLEAN__SHIFT                                                                          0xd
#define GRBM_STATUS__TA_BUSY__SHIFT                                                                           0xe
#define GRBM_STATUS__GDS_BUSY__SHIFT                                                                          0xf
#define GRBM_STATUS__GE_BUSY_NO_DMA__SHIFT                                                                    0x10
#define GRBM_STATUS__SX_BUSY__SHIFT                                                                           0x14
#define GRBM_STATUS__GE_BUSY__SHIFT                                                                           0x15
#define GRBM_STATUS__SPI_BUSY__SHIFT                                                                          0x16
#define GRBM_STATUS__BCI_BUSY__SHIFT                                                                          0x17
#define GRBM_STATUS__SC_BUSY__SHIFT                                                                           0x18
#define GRBM_STATUS__PA_BUSY__SHIFT                                                                           0x19
#define GRBM_STATUS__DB_BUSY__SHIFT                                                                           0x1a
#define GRBM_STATUS__CP_COHERENCY_BUSY__SHIFT                                                                 0x1c
#define GRBM_STATUS__CP_BUSY__SHIFT                                                                           0x1d
#define GRBM_STATUS__CB_BUSY__SHIFT                                                                           0x1e
#define GRBM_STATUS__GUI_ACTIVE__SHIFT                                                                        0x1f
#define GRBM_STATUS__ME0PIPE0_CMDFIFO_AVAIL_MASK                                                              0x0000000FL
#define GRBM_STATUS__ME0PIPE0_CF_RQ_PENDING_MASK                                                              0x00000080L
#define GRBM_STATUS__ME0PIPE0_PF_RQ_PENDING_MASK                                                              0x00000100L
#define GRBM_STATUS__GDS_DMA_RQ_PENDING_MASK                                                                  0x00000200L
#define GRBM_STATUS__DB_CLEAN_MASK                                                                            0x00001000L
#define GRBM_STATUS__CB_CLEAN_MASK                                                                            0x00002000L
#define GRBM_STATUS__TA_BUSY_MASK                                                                             0x00004000L
#define GRBM_STATUS__GDS_BUSY_MASK                                                                            0x00008000L
#define GRBM_STATUS__GE_BUSY_NO_DMA_MASK                                                                      0x00010000L
#define GRBM_STATUS__SX_BUSY_MASK                                                                             0x00100000L
#define GRBM_STATUS__GE_BUSY_MASK                                                                             0x00200000L
#define GRBM_STATUS__SPI_BUSY_MASK                                                                            0x00400000L
#define GRBM_STATUS__BCI_BUSY_MASK                                                                            0x00800000L
#define GRBM_STATUS__SC_BUSY_MASK                                                                             0x01000000L
#define GRBM_STATUS__PA_BUSY_MASK                                                                             0x02000000L
#define GRBM_STATUS__DB_BUSY_MASK                                                                             0x04000000L
#define GRBM_STATUS__CP_COHERENCY_BUSY_MASK                                                                   0x10000000L
#define GRBM_STATUS__CP_BUSY_MASK                                                                             0x20000000L
#define GRBM_STATUS__CB_BUSY_MASK                                                                             0x40000000L
#define GRBM_STATUS__GUI_ACTIVE_MASK                                                                          0x80000000L
//GRBM_STATUS_SE0
#define GRBM_STATUS_SE0__DB_CLEAN__SHIFT                                                                      0x1
#define GRBM_STATUS_SE0__CB_CLEAN__SHIFT                                                                      0x2
#define GRBM_STATUS_SE0__UTCL1_BUSY__SHIFT                                                                    0x3
#define GRBM_STATUS_SE0__TCP_BUSY__SHIFT                                                                      0x4
#define GRBM_STATUS_SE0__GL1CC_BUSY__SHIFT                                                                    0x5
#define GRBM_STATUS_SE0__RMI_BUSY__SHIFT                                                                      0x15
#define GRBM_STATUS_SE0__BCI_BUSY__SHIFT                                                                      0x16
#define GRBM_STATUS_SE0__PA_BUSY__SHIFT                                                                       0x18
#define GRBM_STATUS_SE0__TA_BUSY__SHIFT                                                                       0x19
#define GRBM_STATUS_SE0__SX_BUSY__SHIFT                                                                       0x1a
#define GRBM_STATUS_SE0__SPI_BUSY__SHIFT                                                                      0x1b
#define GRBM_STATUS_SE0__SC_BUSY__SHIFT                                                                       0x1d
#define GRBM_STATUS_SE0__DB_BUSY__SHIFT                                                                       0x1e
#define GRBM_STATUS_SE0__CB_BUSY__SHIFT                                                                       0x1f
#define GRBM_STATUS_SE0__DB_CLEAN_MASK                                                                        0x00000002L
#define GRBM_STATUS_SE0__CB_CLEAN_MASK                                                                        0x00000004L
#define GRBM_STATUS_SE0__UTCL1_BUSY_MASK                                                                      0x00000008L
#define GRBM_STATUS_SE0__TCP_BUSY_MASK                                                                        0x00000010L
#define GRBM_STATUS_SE0__GL1CC_BUSY_MASK                                                                      0x00000020L
#define GRBM_STATUS_SE0__RMI_BUSY_MASK                                                                        0x00200000L
#define GRBM_STATUS_SE0__BCI_BUSY_MASK                                                                        0x00400000L
#define GRBM_STATUS_SE0__PA_BUSY_MASK                                                                         0x01000000L
#define GRBM_STATUS_SE0__TA_BUSY_MASK                                                                         0x02000000L
#define GRBM_STATUS_SE0__SX_BUSY_MASK                                                                         0x04000000L
#define GRBM_STATUS_SE0__SPI_BUSY_MASK                                                                        0x08000000L
#define GRBM_STATUS_SE0__SC_BUSY_MASK                                                                         0x20000000L
#define GRBM_STATUS_SE0__DB_BUSY_MASK                                                                         0x40000000L
#define GRBM_STATUS_SE0__CB_BUSY_MASK                                                                         0x80000000L
//GRBM_STATUS_SE1
#define GRBM_STATUS_SE1__DB_CLEAN__SHIFT                                                                      0x1
#define GRBM_STATUS_SE1__CB_CLEAN__SHIFT                                                                      0x2
#define GRBM_STATUS_SE1__UTCL1_BUSY__SHIFT                                                                    0x3
#define GRBM_STATUS_SE1__TCP_BUSY__SHIFT                                                                      0x4
#define GRBM_STATUS_SE1__GL1CC_BUSY__SHIFT                                                                    0x5
#define GRBM_STATUS_SE1__RMI_BUSY__SHIFT                                                                      0x15
#define GRBM_STATUS_SE1__BCI_BUSY__SHIFT                                                                      0x16
#define GRBM_STATUS_SE1__PA_BUSY__SHIFT                                                                       0x18
#define GRBM_STATUS_SE1__TA_BUSY__SHIFT                                                                       0x19
#define GRBM_STATUS_SE1__SX_BUSY__SHIFT                                                                       0x1a
#define GRBM_STATUS_SE1__SPI_BUSY__SHIFT                                                                      0x1b
#define GRBM_STATUS_SE1__SC_BUSY__SHIFT                                                                       0x1d
#define GRBM_STATUS_SE1__DB_BUSY__SHIFT                                                                       0x1e
#define GRBM_STATUS_SE1__CB_BUSY__SHIFT                                                                       0x1f
#define GRBM_STATUS_SE1__DB_CLEAN_MASK                                                                        0x00000002L
#define GRBM_STATUS_SE1__CB_CLEAN_MASK                                                                        0x00000004L
#define GRBM_STATUS_SE1__UTCL1_BUSY_MASK                                                                      0x00000008L
#define GRBM_STATUS_SE1__TCP_BUSY_MASK                                                                        0x00000010L
#define GRBM_STATUS_SE1__GL1CC_BUSY_MASK                                                                      0x00000020L
#define GRBM_STATUS_SE1__RMI_BUSY_MASK                                                                        0x00200000L
#define GRBM_STATUS_SE1__BCI_BUSY_MASK                                                                        0x00400000L
#define GRBM_STATUS_SE1__PA_BUSY_MASK                                                                         0x01000000L
#define GRBM_STATUS_SE1__TA_BUSY_MASK                                                                         0x02000000L
#define GRBM_STATUS_SE1__SX_BUSY_MASK                                                                         0x04000000L
#define GRBM_STATUS_SE1__SPI_BUSY_MASK                                                                        0x08000000L
#define GRBM_STATUS_SE1__SC_BUSY_MASK                                                                         0x20000000L
#define GRBM_STATUS_SE1__DB_BUSY_MASK                                                                         0x40000000L
#define GRBM_STATUS_SE1__CB_BUSY_MASK                                                                         0x80000000L
//GRBM_STATUS3
#define GRBM_STATUS3__GRBM_RLC_INTR_CREDIT_PENDING__SHIFT                                                     0x5
#define GRBM_STATUS3__GRBM_UTCL2_INTR_CREDIT_PENDING__SHIFT                                                   0x6
#define GRBM_STATUS3__GRBM_CPF_INTR_CREDIT_PENDING__SHIFT                                                     0x7
#define GRBM_STATUS3__MESPIPE0_RQ_PENDING__SHIFT                                                              0x8
#define GRBM_STATUS3__MESPIPE1_RQ_PENDING__SHIFT                                                              0x9
#define GRBM_STATUS3__MESPIPE2_RQ_PENDING__SHIFT                                                              0xa
#define GRBM_STATUS3__MESPIPE3_RQ_PENDING__SHIFT                                                              0xb
#define GRBM_STATUS3__PH_BUSY__SHIFT                                                                          0xd
#define GRBM_STATUS3__CH_BUSY__SHIFT                                                                          0xe
#define GRBM_STATUS3__GL2CC_BUSY__SHIFT                                                                       0xf
#define GRBM_STATUS3__GL1CC_BUSY__SHIFT                                                                       0x10
#define GRBM_STATUS3__GUS_LINK_BUSY__SHIFT                                                                    0x1c
#define GRBM_STATUS3__GUS_BUSY__SHIFT                                                                         0x1d
#define GRBM_STATUS3__UTCL1_BUSY__SHIFT                                                                       0x1e
#define GRBM_STATUS3__PMM_BUSY__SHIFT                                                                         0x1f
#define GRBM_STATUS3__GRBM_RLC_INTR_CREDIT_PENDING_MASK                                                       0x00000020L
#define GRBM_STATUS3__GRBM_UTCL2_INTR_CREDIT_PENDING_MASK                                                     0x00000040L
#define GRBM_STATUS3__GRBM_CPF_INTR_CREDIT_PENDING_MASK                                                       0x00000080L
#define GRBM_STATUS3__MESPIPE0_RQ_PENDING_MASK                                                                0x00000100L
#define GRBM_STATUS3__MESPIPE1_RQ_PENDING_MASK                                                                0x00000200L
#define GRBM_STATUS3__MESPIPE2_RQ_PENDING_MASK                                                                0x00000400L
#define GRBM_STATUS3__MESPIPE3_RQ_PENDING_MASK                                                                0x00000800L
#define GRBM_STATUS3__PH_BUSY_MASK                                                                            0x00002000L
#define GRBM_STATUS3__CH_BUSY_MASK                                                                            0x00004000L
#define GRBM_STATUS3__GL2CC_BUSY_MASK                                                                         0x00008000L
#define GRBM_STATUS3__GL1CC_BUSY_MASK                                                                         0x00010000L
#define GRBM_STATUS3__GUS_LINK_BUSY_MASK                                                                      0x10000000L
#define GRBM_STATUS3__GUS_BUSY_MASK                                                                           0x20000000L
#define GRBM_STATUS3__UTCL1_BUSY_MASK                                                                         0x40000000L
#define GRBM_STATUS3__PMM_BUSY_MASK                                                                           0x80000000L
//GRBM_SOFT_RESET
#define GRBM_SOFT_RESET__SOFT_RESET_CP__SHIFT                                                                 0x0
#define GRBM_SOFT_RESET__SOFT_RESET_RLC__SHIFT                                                                0x2
#define GRBM_SOFT_RESET__SOFT_RESET_GFX__SHIFT                                                                0x10
#define GRBM_SOFT_RESET__SOFT_RESET_CPF__SHIFT                                                                0x11
#define GRBM_SOFT_RESET__SOFT_RESET_CPC__SHIFT                                                                0x12
#define GRBM_SOFT_RESET__SOFT_RESET_CPG__SHIFT                                                                0x13
#define GRBM_SOFT_RESET__SOFT_RESET_CAC__SHIFT                                                                0x14
#define GRBM_SOFT_RESET__SOFT_RESET_CPAXI__SHIFT                                                              0x15
#define GRBM_SOFT_RESET__SOFT_RESET_EA__SHIFT                                                                 0x16
#define GRBM_SOFT_RESET__SOFT_RESET_SDMA0__SHIFT                                                              0x17
#define GRBM_SOFT_RESET__SOFT_RESET_SDMA1__SHIFT                                                              0x18
#define GRBM_SOFT_RESET__SOFT_RESET_SDMA2__SHIFT                                                              0x19
#define GRBM_SOFT_RESET__SOFT_RESET_SDMA3__SHIFT                                                              0x1a
#define GRBM_SOFT_RESET__SOFT_RESET_CP_MASK                                                                   0x00000001L
#define GRBM_SOFT_RESET__SOFT_RESET_RLC_MASK                                                                  0x00000004L
#define GRBM_SOFT_RESET__SOFT_RESET_GFX_MASK                                                                  0x00010000L
#define GRBM_SOFT_RESET__SOFT_RESET_CPF_MASK                                                                  0x00020000L
#define GRBM_SOFT_RESET__SOFT_RESET_CPC_MASK                                                                  0x00040000L
#define GRBM_SOFT_RESET__SOFT_RESET_CPG_MASK                                                                  0x00080000L
#define GRBM_SOFT_RESET__SOFT_RESET_CAC_MASK                                                                  0x00100000L
#define GRBM_SOFT_RESET__SOFT_RESET_CPAXI_MASK                                                                0x00200000L
#define GRBM_SOFT_RESET__SOFT_RESET_EA_MASK                                                                   0x00400000L
#define GRBM_SOFT_RESET__SOFT_RESET_SDMA0_MASK                                                                0x00800000L
#define GRBM_SOFT_RESET__SOFT_RESET_SDMA1_MASK                                                                0x01000000L
#define GRBM_SOFT_RESET__SOFT_RESET_SDMA2_MASK                                                                0x02000000L
#define GRBM_SOFT_RESET__SOFT_RESET_SDMA3_MASK                                                                0x04000000L
//GRBM_GFX_CLKEN_CNTL
#define GRBM_GFX_CLKEN_CNTL__PREFIX_DELAY_CNT__SHIFT                                                          0x0
#define GRBM_GFX_CLKEN_CNTL__POST_DELAY_CNT__SHIFT                                                            0x8
#define GRBM_GFX_CLKEN_CNTL__PREFIX_DELAY_CNT_MASK                                                            0x0000000FL
#define GRBM_GFX_CLKEN_CNTL__POST_DELAY_CNT_MASK                                                              0x00001F00L
//GRBM_WAIT_IDLE_CLOCKS
#define GRBM_WAIT_IDLE_CLOCKS__WAIT_IDLE_CLOCKS__SHIFT                                                        0x0
#define GRBM_WAIT_IDLE_CLOCKS__WAIT_IDLE_CLOCKS_MASK                                                          0x000000FFL
//GRBM_STATUS_SE2
#define GRBM_STATUS_SE2__DB_CLEAN__SHIFT                                                                      0x1
#define GRBM_STATUS_SE2__CB_CLEAN__SHIFT                                                                      0x2
#define GRBM_STATUS_SE2__UTCL1_BUSY__SHIFT                                                                    0x3
#define GRBM_STATUS_SE2__TCP_BUSY__SHIFT                                                                      0x4
#define GRBM_STATUS_SE2__GL1CC_BUSY__SHIFT                                                                    0x5
#define GRBM_STATUS_SE2__RMI_BUSY__SHIFT                                                                      0x15
#define GRBM_STATUS_SE2__BCI_BUSY__SHIFT                                                                      0x16
#define GRBM_STATUS_SE2__PA_BUSY__SHIFT                                                                       0x18
#define GRBM_STATUS_SE2__TA_BUSY__SHIFT                                                                       0x19
#define GRBM_STATUS_SE2__SX_BUSY__SHIFT                                                                       0x1a
#define GRBM_STATUS_SE2__SPI_BUSY__SHIFT                                                                      0x1b
#define GRBM_STATUS_SE2__SC_BUSY__SHIFT                                                                       0x1d
#define GRBM_STATUS_SE2__DB_BUSY__SHIFT                                                                       0x1e
#define GRBM_STATUS_SE2__CB_BUSY__SHIFT                                                                       0x1f
#define GRBM_STATUS_SE2__DB_CLEAN_MASK                                                                        0x00000002L
#define GRBM_STATUS_SE2__CB_CLEAN_MASK                                                                        0x00000004L
#define GRBM_STATUS_SE2__UTCL1_BUSY_MASK                                                                      0x00000008L
#define GRBM_STATUS_SE2__TCP_BUSY_MASK                                                                        0x00000010L
#define GRBM_STATUS_SE2__GL1CC_BUSY_MASK                                                                      0x00000020L
#define GRBM_STATUS_SE2__RMI_BUSY_MASK                                                                        0x00200000L
#define GRBM_STATUS_SE2__BCI_BUSY_MASK                                                                        0x00400000L
#define GRBM_STATUS_SE2__PA_BUSY_MASK                                                                         0x01000000L
#define GRBM_STATUS_SE2__TA_BUSY_MASK                                                                         0x02000000L
#define GRBM_STATUS_SE2__SX_BUSY_MASK                                                                         0x04000000L
#define GRBM_STATUS_SE2__SPI_BUSY_MASK                                                                        0x08000000L
#define GRBM_STATUS_SE2__SC_BUSY_MASK                                                                         0x20000000L
#define GRBM_STATUS_SE2__DB_BUSY_MASK                                                                         0x40000000L
#define GRBM_STATUS_SE2__CB_BUSY_MASK                                                                         0x80000000L
//GRBM_STATUS_SE3
#define GRBM_STATUS_SE3__DB_CLEAN__SHIFT                                                                      0x1
#define GRBM_STATUS_SE3__CB_CLEAN__SHIFT                                                                      0x2
#define GRBM_STATUS_SE3__UTCL1_BUSY__SHIFT                                                                    0x3
#define GRBM_STATUS_SE3__TCP_BUSY__SHIFT                                                                      0x4
#define GRBM_STATUS_SE3__GL1CC_BUSY__SHIFT                                                                    0x5
#define GRBM_STATUS_SE3__RMI_BUSY__SHIFT                                                                      0x15
#define GRBM_STATUS_SE3__BCI_BUSY__SHIFT                                                                      0x16
#define GRBM_STATUS_SE3__PA_BUSY__SHIFT                                                                       0x18
#define GRBM_STATUS_SE3__TA_BUSY__SHIFT                                                                       0x19
#define GRBM_STATUS_SE3__SX_BUSY__SHIFT                                                                       0x1a
#define GRBM_STATUS_SE3__SPI_BUSY__SHIFT                                                                      0x1b
#define GRBM_STATUS_SE3__SC_BUSY__SHIFT                                                                       0x1d
#define GRBM_STATUS_SE3__DB_BUSY__SHIFT                                                                       0x1e
#define GRBM_STATUS_SE3__CB_BUSY__SHIFT                                                                       0x1f
#define GRBM_STATUS_SE3__DB_CLEAN_MASK                                                                        0x00000002L
#define GRBM_STATUS_SE3__CB_CLEAN_MASK                                                                        0x00000004L
#define GRBM_STATUS_SE3__UTCL1_BUSY_MASK                                                                      0x00000008L
#define GRBM_STATUS_SE3__TCP_BUSY_MASK                                                                        0x00000010L
#define GRBM_STATUS_SE3__GL1CC_BUSY_MASK                                                                      0x00000020L
#define GRBM_STATUS_SE3__RMI_BUSY_MASK                                                                        0x00200000L
#define GRBM_STATUS_SE3__BCI_BUSY_MASK                                                                        0x00400000L
#define GRBM_STATUS_SE3__PA_BUSY_MASK                                                                         0x01000000L
#define GRBM_STATUS_SE3__TA_BUSY_MASK                                                                         0x02000000L
#define GRBM_STATUS_SE3__SX_BUSY_MASK                                                                         0x04000000L
#define GRBM_STATUS_SE3__SPI_BUSY_MASK                                                                        0x08000000L
#define GRBM_STATUS_SE3__SC_BUSY_MASK                                                                         0x20000000L
#define GRBM_STATUS_SE3__DB_BUSY_MASK                                                                         0x40000000L
#define GRBM_STATUS_SE3__CB_BUSY_MASK                                                                         0x80000000L
//GRBM_READ_ERROR
#define GRBM_READ_ERROR__READ_ADDRESS__SHIFT                                                                  0x2
#define GRBM_READ_ERROR__READ_PIPEID__SHIFT                                                                   0x14
#define GRBM_READ_ERROR__READ_MEID__SHIFT                                                                     0x16
#define GRBM_READ_ERROR__READ_ERROR__SHIFT                                                                    0x1f
#define GRBM_READ_ERROR__READ_ADDRESS_MASK                                                                    0x0003FFFCL
#define GRBM_READ_ERROR__READ_PIPEID_MASK                                                                     0x00300000L
#define GRBM_READ_ERROR__READ_MEID_MASK                                                                       0x00C00000L
#define GRBM_READ_ERROR__READ_ERROR_MASK                                                                      0x80000000L
//GRBM_READ_ERROR2
#define GRBM_READ_ERROR2__READ_REQUESTER_MESPIPE0__SHIFT                                                      0x9
#define GRBM_READ_ERROR2__READ_REQUESTER_MESPIPE1__SHIFT                                                      0xa
#define GRBM_READ_ERROR2__READ_REQUESTER_MESPIPE2__SHIFT                                                      0xb
#define GRBM_READ_ERROR2__READ_REQUESTER_MESPIPE3__SHIFT                                                      0xc
#define GRBM_READ_ERROR2__READ_REQUESTER_SDMA0__SHIFT                                                         0xd
#define GRBM_READ_ERROR2__READ_REQUESTER_SDMA1__SHIFT                                                         0xe
#define GRBM_READ_ERROR2__READ_REQUESTER_SDMA2__SHIFT                                                         0xf
#define GRBM_READ_ERROR2__READ_REQUESTER_SDMA3__SHIFT                                                         0x10
#define GRBM_READ_ERROR2__READ_REQUESTER_RLC__SHIFT                                                           0x12
#define GRBM_READ_ERROR2__READ_REQUESTER_GDS_DMA__SHIFT                                                       0x13
#define GRBM_READ_ERROR2__READ_REQUESTER_ME0PIPE0_CF__SHIFT                                                   0x14
#define GRBM_READ_ERROR2__READ_REQUESTER_ME0PIPE0_PF__SHIFT                                                   0x15
#define GRBM_READ_ERROR2__READ_REQUESTER_ME0PIPE1_CF__SHIFT                                                   0x16
#define GRBM_READ_ERROR2__READ_REQUESTER_ME0PIPE1_PF__SHIFT                                                   0x17
#define GRBM_READ_ERROR2__READ_REQUESTER_ME1PIPE0__SHIFT                                                      0x18
#define GRBM_READ_ERROR2__READ_REQUESTER_ME1PIPE1__SHIFT                                                      0x19
#define GRBM_READ_ERROR2__READ_REQUESTER_ME1PIPE2__SHIFT                                                      0x1a
#define GRBM_READ_ERROR2__READ_REQUESTER_ME1PIPE3__SHIFT                                                      0x1b
#define GRBM_READ_ERROR2__READ_REQUESTER_ME2PIPE0__SHIFT                                                      0x1c
#define GRBM_READ_ERROR2__READ_REQUESTER_ME2PIPE1__SHIFT                                                      0x1d
#define GRBM_READ_ERROR2__READ_REQUESTER_ME2PIPE2__SHIFT                                                      0x1e
#define GRBM_READ_ERROR2__READ_REQUESTER_ME2PIPE3__SHIFT                                                      0x1f
#define GRBM_READ_ERROR2__READ_REQUESTER_MESPIPE0_MASK                                                        0x00000200L
#define GRBM_READ_ERROR2__READ_REQUESTER_MESPIPE1_MASK                                                        0x00000400L
#define GRBM_READ_ERROR2__READ_REQUESTER_MESPIPE2_MASK                                                        0x00000800L
#define GRBM_READ_ERROR2__READ_REQUESTER_MESPIPE3_MASK                                                        0x00001000L
#define GRBM_READ_ERROR2__READ_REQUESTER_SDMA0_MASK                                                           0x00002000L
#define GRBM_READ_ERROR2__READ_REQUESTER_SDMA1_MASK                                                           0x00004000L
#define GRBM_READ_ERROR2__READ_REQUESTER_SDMA2_MASK                                                           0x00008000L
#define GRBM_READ_ERROR2__READ_REQUESTER_SDMA3_MASK                                                           0x00010000L
#define GRBM_READ_ERROR2__READ_REQUESTER_RLC_MASK                                                             0x00040000L
#define GRBM_READ_ERROR2__READ_REQUESTER_GDS_DMA_MASK                                                         0x00080000L
#define GRBM_READ_ERROR2__READ_REQUESTER_ME0PIPE0_CF_MASK                                                     0x00100000L
#define GRBM_READ_ERROR2__READ_REQUESTER_ME0PIPE0_PF_MASK                                                     0x00200000L
#define GRBM_READ_ERROR2__READ_REQUESTER_ME0PIPE1_CF_MASK                                                     0x00400000L
#define GRBM_READ_ERROR2__READ_REQUESTER_ME0PIPE1_PF_MASK                                                     0x00800000L
#define GRBM_READ_ERROR2__READ_REQUESTER_ME1PIPE0_MASK                                                        0x01000000L
#define GRBM_READ_ERROR2__READ_REQUESTER_ME1PIPE1_MASK                                                        0x02000000L
#define GRBM_READ_ERROR2__READ_REQUESTER_ME1PIPE2_MASK                                                        0x04000000L
#define GRBM_READ_ERROR2__READ_REQUESTER_ME1PIPE3_MASK                                                        0x08000000L
#define GRBM_READ_ERROR2__READ_REQUESTER_ME2PIPE0_MASK                                                        0x10000000L
#define GRBM_READ_ERROR2__READ_REQUESTER_ME2PIPE1_MASK                                                        0x20000000L
#define GRBM_READ_ERROR2__READ_REQUESTER_ME2PIPE2_MASK                                                        0x40000000L
#define GRBM_READ_ERROR2__READ_REQUESTER_ME2PIPE3_MASK                                                        0x80000000L
//GRBM_INT_CNTL
#define GRBM_INT_CNTL__RDERR_INT_ENABLE__SHIFT                                                                0x0
#define GRBM_INT_CNTL__GUI_IDLE_INT_ENABLE__SHIFT                                                             0x13
#define GRBM_INT_CNTL__RDERR_INT_ENABLE_MASK                                                                  0x00000001L
#define GRBM_INT_CNTL__GUI_IDLE_INT_ENABLE_MASK                                                               0x00080000L
//GRBM_TRAP_OP
#define GRBM_TRAP_OP__RW__SHIFT                                                                               0x0
#define GRBM_TRAP_OP__RW_MASK                                                                                 0x00000001L
//GRBM_TRAP_ADDR
#define GRBM_TRAP_ADDR__DATA__SHIFT                                                                           0x0
#define GRBM_TRAP_ADDR__DATA_MASK                                                                             0x0003FFFFL
//GRBM_TRAP_ADDR_MSK
#define GRBM_TRAP_ADDR_MSK__DATA__SHIFT                                                                       0x0
#define GRBM_TRAP_ADDR_MSK__DATA_MASK                                                                         0x0003FFFFL
//GRBM_TRAP_WD
#define GRBM_TRAP_WD__DATA__SHIFT                                                                             0x0
#define GRBM_TRAP_WD__DATA_MASK                                                                               0xFFFFFFFFL
//GRBM_TRAP_WD_MSK
#define GRBM_TRAP_WD_MSK__DATA__SHIFT                                                                         0x0
#define GRBM_TRAP_WD_MSK__DATA_MASK                                                                           0xFFFFFFFFL
//GRBM_DSM_BYPASS
#define GRBM_DSM_BYPASS__BYPASS_BITS__SHIFT                                                                   0x0
#define GRBM_DSM_BYPASS__BYPASS_EN__SHIFT                                                                     0x2
#define GRBM_DSM_BYPASS__BYPASS_BITS_MASK                                                                     0x00000003L
#define GRBM_DSM_BYPASS__BYPASS_EN_MASK                                                                       0x00000004L
//GRBM_WRITE_ERROR
#define GRBM_WRITE_ERROR__WRITE_REQUESTER_RLC__SHIFT                                                          0x0
#define GRBM_WRITE_ERROR__WRITE_SSRCID__SHIFT                                                                 0x2
#define GRBM_WRITE_ERROR__WRITE_VFID__SHIFT                                                                   0x5
#define GRBM_WRITE_ERROR__WRITE_VF__SHIFT                                                                     0xc
#define GRBM_WRITE_ERROR__WRITE_VMID__SHIFT                                                                   0xd
#define GRBM_WRITE_ERROR__CP_SECURE_WR_ILLEGAL__SHIFT                                                         0x12
#define GRBM_WRITE_ERROR__WRITE_PIPEID__SHIFT                                                                 0x14
#define GRBM_WRITE_ERROR__WRITE_MEID__SHIFT                                                                   0x16
#define GRBM_WRITE_ERROR__WRITE_ERROR__SHIFT                                                                  0x1f
#define GRBM_WRITE_ERROR__WRITE_REQUESTER_RLC_MASK                                                            0x00000001L
#define GRBM_WRITE_ERROR__WRITE_SSRCID_MASK                                                                   0x0000001CL
#define GRBM_WRITE_ERROR__WRITE_VFID_MASK                                                                     0x000007E0L
#define GRBM_WRITE_ERROR__WRITE_VF_MASK                                                                       0x00001000L
#define GRBM_WRITE_ERROR__WRITE_VMID_MASK                                                                     0x0001E000L
#define GRBM_WRITE_ERROR__CP_SECURE_WR_ILLEGAL_MASK                                                           0x00040000L
#define GRBM_WRITE_ERROR__WRITE_PIPEID_MASK                                                                   0x00300000L
#define GRBM_WRITE_ERROR__WRITE_MEID_MASK                                                                     0x00C00000L
#define GRBM_WRITE_ERROR__WRITE_ERROR_MASK                                                                    0x80000000L
//GRBM_CHIP_REVISION
#define GRBM_CHIP_REVISION__CHIP_REVISION__SHIFT                                                              0x0
#define GRBM_CHIP_REVISION__CHIP_REVISION_MASK                                                                0x000000FFL
//GRBM_GFX_CNTL
#define GRBM_GFX_CNTL__PIPEID__SHIFT                                                                          0x0
#define GRBM_GFX_CNTL__MEID__SHIFT                                                                            0x2
#define GRBM_GFX_CNTL__VMID__SHIFT                                                                            0x4
#define GRBM_GFX_CNTL__QUEUEID__SHIFT                                                                         0x8
#define GRBM_GFX_CNTL__PIPEID_MASK                                                                            0x00000003L
#define GRBM_GFX_CNTL__MEID_MASK                                                                              0x0000000CL
#define GRBM_GFX_CNTL__VMID_MASK                                                                              0x000000F0L
#define GRBM_GFX_CNTL__QUEUEID_MASK                                                                           0x00000700L
//GRBM_IH_CREDIT
#define GRBM_IH_CREDIT__CREDIT_VALUE__SHIFT                                                                   0x0
#define GRBM_IH_CREDIT__IH_CLIENT_ID__SHIFT                                                                   0x10
#define GRBM_IH_CREDIT__CREDIT_VALUE_MASK                                                                     0x00000003L
#define GRBM_IH_CREDIT__IH_CLIENT_ID_MASK                                                                     0x00FF0000L
//GRBM_PWR_CNTL2
#define GRBM_PWR_CNTL2__PWR_REQUEST_HALT__SHIFT                                                               0x10
#define GRBM_PWR_CNTL2__PWR_GFX3D_REQUEST_HALT__SHIFT                                                         0x14
#define GRBM_PWR_CNTL2__PWR_REQUEST_HALT_MASK                                                                 0x00010000L
#define GRBM_PWR_CNTL2__PWR_GFX3D_REQUEST_HALT_MASK                                                           0x00100000L
//GRBM_UTCL2_INVAL_RANGE_START
#define GRBM_UTCL2_INVAL_RANGE_START__DATA__SHIFT                                                             0x0
#define GRBM_UTCL2_INVAL_RANGE_START__DATA_MASK                                                               0x0003FFFFL
//GRBM_UTCL2_INVAL_RANGE_END
#define GRBM_UTCL2_INVAL_RANGE_END__DATA__SHIFT                                                               0x0
#define GRBM_UTCL2_INVAL_RANGE_END__DATA_MASK                                                                 0x0003FFFFL
//GRBM_FENCE_RANGE0
#define GRBM_FENCE_RANGE0__START__SHIFT                                                                       0x0
#define GRBM_FENCE_RANGE0__END__SHIFT                                                                         0x10
#define GRBM_FENCE_RANGE0__START_MASK                                                                         0x0000FFFFL
#define GRBM_FENCE_RANGE0__END_MASK                                                                           0xFFFF0000L
//GRBM_FENCE_RANGE1
#define GRBM_FENCE_RANGE1__START__SHIFT                                                                       0x0
#define GRBM_FENCE_RANGE1__END__SHIFT                                                                         0x10
#define GRBM_FENCE_RANGE1__START_MASK                                                                         0x0000FFFFL
#define GRBM_FENCE_RANGE1__END_MASK                                                                           0xFFFF0000L
//GRBM_NOWHERE
#define GRBM_NOWHERE__DATA__SHIFT                                                                             0x0
#define GRBM_NOWHERE__DATA_MASK                                                                               0xFFFFFFFFL
//GRBM_SCRATCH_REG0
#define GRBM_SCRATCH_REG0__SCRATCH_REG0__SHIFT                                                                0x0
#define GRBM_SCRATCH_REG0__SCRATCH_REG0_MASK                                                                  0xFFFFFFFFL
//GRBM_SCRATCH_REG1
#define GRBM_SCRATCH_REG1__SCRATCH_REG1__SHIFT                                                                0x0
#define GRBM_SCRATCH_REG1__SCRATCH_REG1_MASK                                                                  0xFFFFFFFFL
//GRBM_SCRATCH_REG2
#define GRBM_SCRATCH_REG2__SCRATCH_REG2__SHIFT                                                                0x0
#define GRBM_SCRATCH_REG2__SCRATCH_REG2_MASK                                                                  0xFFFFFFFFL
//GRBM_SCRATCH_REG3
#define GRBM_SCRATCH_REG3__SCRATCH_REG3__SHIFT                                                                0x0
#define GRBM_SCRATCH_REG3__SCRATCH_REG3_MASK                                                                  0xFFFFFFFFL
//GRBM_SCRATCH_REG4
#define GRBM_SCRATCH_REG4__SCRATCH_REG4__SHIFT                                                                0x0
#define GRBM_SCRATCH_REG4__SCRATCH_REG4_MASK                                                                  0xFFFFFFFFL
//GRBM_SCRATCH_REG5
#define GRBM_SCRATCH_REG5__SCRATCH_REG5__SHIFT                                                                0x0
#define GRBM_SCRATCH_REG5__SCRATCH_REG5_MASK                                                                  0xFFFFFFFFL
//GRBM_SCRATCH_REG6
#define GRBM_SCRATCH_REG6__SCRATCH_REG6__SHIFT                                                                0x0
#define GRBM_SCRATCH_REG6__SCRATCH_REG6_MASK                                                                  0xFFFFFFFFL
//GRBM_SCRATCH_REG7
#define GRBM_SCRATCH_REG7__SCRATCH_REG7__SHIFT                                                                0x0
#define GRBM_SCRATCH_REG7__SCRATCH_REG7_MASK                                                                  0xFFFFFFFFL
//VIOLATION_DATA_ASYNC_VF_PROG
#define VIOLATION_DATA_ASYNC_VF_PROG__SSRCID__SHIFT                                                           0x0
#define VIOLATION_DATA_ASYNC_VF_PROG__VFID__SHIFT                                                             0x4
#define VIOLATION_DATA_ASYNC_VF_PROG__VIOLATION_ERROR__SHIFT                                                  0x1f
#define VIOLATION_DATA_ASYNC_VF_PROG__SSRCID_MASK                                                             0x0000000FL
#define VIOLATION_DATA_ASYNC_VF_PROG__VFID_MASK                                                               0x000003F0L
#define VIOLATION_DATA_ASYNC_VF_PROG__VIOLATION_ERROR_MASK                                                    0x80000000L


// addressBlock: gc_cpdec
//CP_CPC_STATUS
#define CP_CPC_STATUS__MEC1_BUSY__SHIFT                                                                       0x0
#define CP_CPC_STATUS__MEC2_BUSY__SHIFT                                                                       0x1
#define CP_CPC_STATUS__DC0_BUSY__SHIFT                                                                        0x2
#define CP_CPC_STATUS__DC1_BUSY__SHIFT                                                                        0x3
#define CP_CPC_STATUS__RCIU1_BUSY__SHIFT                                                                      0x4
#define CP_CPC_STATUS__RCIU2_BUSY__SHIFT                                                                      0x5
#define CP_CPC_STATUS__ROQ1_BUSY__SHIFT                                                                       0x6
#define CP_CPC_STATUS__ROQ2_BUSY__SHIFT                                                                       0x7
#define CP_CPC_STATUS__TCIU_BUSY__SHIFT                                                                       0xa
#define CP_CPC_STATUS__SCRATCH_RAM_BUSY__SHIFT                                                                0xb
#define CP_CPC_STATUS__QU_BUSY__SHIFT                                                                         0xc
#define CP_CPC_STATUS__UTCL2IU_BUSY__SHIFT                                                                    0xd
#define CP_CPC_STATUS__SAVE_RESTORE_BUSY__SHIFT                                                               0xe
#define CP_CPC_STATUS__GCRIU_BUSY__SHIFT                                                                      0xf
#define CP_CPC_STATUS__MES_BUSY__SHIFT                                                                        0x10
#define CP_CPC_STATUS__MES_SCRATCH_RAM_BUSY__SHIFT                                                            0x11
#define CP_CPC_STATUS__RCIU3_BUSY__SHIFT                                                                      0x12
#define CP_CPC_STATUS__MES_INSTRUCTION_CACHE_BUSY__SHIFT                                                      0x13
#define CP_CPC_STATUS__CPG_CPC_BUSY__SHIFT                                                                    0x1d
#define CP_CPC_STATUS__CPF_CPC_BUSY__SHIFT                                                                    0x1e
#define CP_CPC_STATUS__CPC_BUSY__SHIFT                                                                        0x1f
#define CP_CPC_STATUS__MEC1_BUSY_MASK                                                                         0x00000001L
#define CP_CPC_STATUS__MEC2_BUSY_MASK                                                                         0x00000002L
#define CP_CPC_STATUS__DC0_BUSY_MASK                                                                          0x00000004L
#define CP_CPC_STATUS__DC1_BUSY_MASK                                                                          0x00000008L
#define CP_CPC_STATUS__RCIU1_BUSY_MASK                                                                        0x00000010L
#define CP_CPC_STATUS__RCIU2_BUSY_MASK                                                                        0x00000020L
#define CP_CPC_STATUS__ROQ1_BUSY_MASK                                                                         0x00000040L
#define CP_CPC_STATUS__ROQ2_BUSY_MASK                                                                         0x00000080L
#define CP_CPC_STATUS__TCIU_BUSY_MASK                                                                         0x00000400L
#define CP_CPC_STATUS__SCRATCH_RAM_BUSY_MASK                                                                  0x00000800L
#define CP_CPC_STATUS__QU_BUSY_MASK                                                                           0x00001000L
#define CP_CPC_STATUS__UTCL2IU_BUSY_MASK                                                                      0x00002000L
#define CP_CPC_STATUS__SAVE_RESTORE_BUSY_MASK                                                                 0x00004000L
#define CP_CPC_STATUS__GCRIU_BUSY_MASK                                                                        0x00008000L
#define CP_CPC_STATUS__MES_BUSY_MASK                                                                          0x00010000L
#define CP_CPC_STATUS__MES_SCRATCH_RAM_BUSY_MASK                                                              0x00020000L
#define CP_CPC_STATUS__RCIU3_BUSY_MASK                                                                        0x00040000L
#define CP_CPC_STATUS__MES_INSTRUCTION_CACHE_BUSY_MASK                                                        0x00080000L
#define CP_CPC_STATUS__CPG_CPC_BUSY_MASK                                                                      0x20000000L
#define CP_CPC_STATUS__CPF_CPC_BUSY_MASK                                                                      0x40000000L
#define CP_CPC_STATUS__CPC_BUSY_MASK                                                                          0x80000000L
//CP_CPC_BUSY_STAT
#define CP_CPC_BUSY_STAT__MEC1_LOAD_BUSY__SHIFT                                                               0x0
#define CP_CPC_BUSY_STAT__MEC1_SEMAPOHRE_BUSY__SHIFT                                                          0x1
#define CP_CPC_BUSY_STAT__MEC1_MUTEX_BUSY__SHIFT                                                              0x2
#define CP_CPC_BUSY_STAT__MEC1_MESSAGE_BUSY__SHIFT                                                            0x3
#define CP_CPC_BUSY_STAT__MEC1_EOP_QUEUE_BUSY__SHIFT                                                          0x4
#define CP_CPC_BUSY_STAT__MEC1_IQ_QUEUE_BUSY__SHIFT                                                           0x5
#define CP_CPC_BUSY_STAT__MEC1_IB_QUEUE_BUSY__SHIFT                                                           0x6
#define CP_CPC_BUSY_STAT__MEC1_TC_BUSY__SHIFT                                                                 0x7
#define CP_CPC_BUSY_STAT__MEC1_DMA_BUSY__SHIFT                                                                0x8
#define CP_CPC_BUSY_STAT__MEC1_PARTIAL_FLUSH_BUSY__SHIFT                                                      0x9
#define CP_CPC_BUSY_STAT__MEC1_PIPE0_BUSY__SHIFT                                                              0xa
#define CP_CPC_BUSY_STAT__MEC1_PIPE1_BUSY__SHIFT                                                              0xb
#define CP_CPC_BUSY_STAT__MEC1_PIPE2_BUSY__SHIFT                                                              0xc
#define CP_CPC_BUSY_STAT__MEC1_PIPE3_BUSY__SHIFT                                                              0xd
#define CP_CPC_BUSY_STAT__MEC2_LOAD_BUSY__SHIFT                                                               0x10
#define CP_CPC_BUSY_STAT__MEC2_SEMAPOHRE_BUSY__SHIFT                                                          0x11
#define CP_CPC_BUSY_STAT__MEC2_MUTEX_BUSY__SHIFT                                                              0x12
#define CP_CPC_BUSY_STAT__MEC2_MESSAGE_BUSY__SHIFT                                                            0x13
#define CP_CPC_BUSY_STAT__MEC2_EOP_QUEUE_BUSY__SHIFT                                                          0x14
#define CP_CPC_BUSY_STAT__MEC2_IQ_QUEUE_BUSY__SHIFT                                                           0x15
#define CP_CPC_BUSY_STAT__MEC2_IB_QUEUE_BUSY__SHIFT                                                           0x16
#define CP_CPC_BUSY_STAT__MEC2_TC_BUSY__SHIFT                                                                 0x17
#define CP_CPC_BUSY_STAT__MEC2_DMA_BUSY__SHIFT                                                                0x18
#define CP_CPC_BUSY_STAT__MEC2_PARTIAL_FLUSH_BUSY__SHIFT                                                      0x19
#define CP_CPC_BUSY_STAT__MEC2_PIPE0_BUSY__SHIFT                                                              0x1a
#define CP_CPC_BUSY_STAT__MEC2_PIPE1_BUSY__SHIFT                                                              0x1b
#define CP_CPC_BUSY_STAT__MEC2_PIPE2_BUSY__SHIFT                                                              0x1c
#define CP_CPC_BUSY_STAT__MEC2_PIPE3_BUSY__SHIFT                                                              0x1d
#define CP_CPC_BUSY_STAT__MEC1_LOAD_BUSY_MASK                                                                 0x00000001L
#define CP_CPC_BUSY_STAT__MEC1_SEMAPOHRE_BUSY_MASK                                                            0x00000002L
#define CP_CPC_BUSY_STAT__MEC1_MUTEX_BUSY_MASK                                                                0x00000004L
#define CP_CPC_BUSY_STAT__MEC1_MESSAGE_BUSY_MASK                                                              0x00000008L
#define CP_CPC_BUSY_STAT__MEC1_EOP_QUEUE_BUSY_MASK                                                            0x00000010L
#define CP_CPC_BUSY_STAT__MEC1_IQ_QUEUE_BUSY_MASK                                                             0x00000020L
#define CP_CPC_BUSY_STAT__MEC1_IB_QUEUE_BUSY_MASK                                                             0x00000040L
#define CP_CPC_BUSY_STAT__MEC1_TC_BUSY_MASK                                                                   0x00000080L
#define CP_CPC_BUSY_STAT__MEC1_DMA_BUSY_MASK                                                                  0x00000100L
#define CP_CPC_BUSY_STAT__MEC1_PARTIAL_FLUSH_BUSY_MASK                                                        0x00000200L
#define CP_CPC_BUSY_STAT__MEC1_PIPE0_BUSY_MASK                                                                0x00000400L
#define CP_CPC_BUSY_STAT__MEC1_PIPE1_BUSY_MASK                                                                0x00000800L
#define CP_CPC_BUSY_STAT__MEC1_PIPE2_BUSY_MASK                                                                0x00001000L
#define CP_CPC_BUSY_STAT__MEC1_PIPE3_BUSY_MASK                                                                0x00002000L
#define CP_CPC_BUSY_STAT__MEC2_LOAD_BUSY_MASK                                                                 0x00010000L
#define CP_CPC_BUSY_STAT__MEC2_SEMAPOHRE_BUSY_MASK                                                            0x00020000L
#define CP_CPC_BUSY_STAT__MEC2_MUTEX_BUSY_MASK                                                                0x00040000L
#define CP_CPC_BUSY_STAT__MEC2_MESSAGE_BUSY_MASK                                                              0x00080000L
#define CP_CPC_BUSY_STAT__MEC2_EOP_QUEUE_BUSY_MASK                                                            0x00100000L
#define CP_CPC_BUSY_STAT__MEC2_IQ_QUEUE_BUSY_MASK                                                             0x00200000L
#define CP_CPC_BUSY_STAT__MEC2_IB_QUEUE_BUSY_MASK                                                             0x00400000L
#define CP_CPC_BUSY_STAT__MEC2_TC_BUSY_MASK                                                                   0x00800000L
#define CP_CPC_BUSY_STAT__MEC2_DMA_BUSY_MASK                                                                  0x01000000L
#define CP_CPC_BUSY_STAT__MEC2_PARTIAL_FLUSH_BUSY_MASK                                                        0x02000000L
#define CP_CPC_BUSY_STAT__MEC2_PIPE0_BUSY_MASK                                                                0x04000000L
#define CP_CPC_BUSY_STAT__MEC2_PIPE1_BUSY_MASK                                                                0x08000000L
#define CP_CPC_BUSY_STAT__MEC2_PIPE2_BUSY_MASK                                                                0x10000000L
#define CP_CPC_BUSY_STAT__MEC2_PIPE3_BUSY_MASK                                                                0x20000000L
//CP_CPC_STALLED_STAT1
#define CP_CPC_STALLED_STAT1__RCIU_TX_FREE_STALL__SHIFT                                                       0x3
#define CP_CPC_STALLED_STAT1__RCIU_PRIV_VIOLATION__SHIFT                                                      0x4
#define CP_CPC_STALLED_STAT1__TCIU_TX_FREE_STALL__SHIFT                                                       0x6
#define CP_CPC_STALLED_STAT1__MEC1_DECODING_PACKET__SHIFT                                                     0x8
#define CP_CPC_STALLED_STAT1__MEC1_WAIT_ON_RCIU__SHIFT                                                        0x9
#define CP_CPC_STALLED_STAT1__MEC1_WAIT_ON_RCIU_READ__SHIFT                                                   0xa
#define CP_CPC_STALLED_STAT1__MEC1_WAIT_ON_ROQ_DATA__SHIFT                                                    0xd
#define CP_CPC_STALLED_STAT1__MEC2_DECODING_PACKET__SHIFT                                                     0x10
#define CP_CPC_STALLED_STAT1__MEC2_WAIT_ON_RCIU__SHIFT                                                        0x11
#define CP_CPC_STALLED_STAT1__MEC2_WAIT_ON_RCIU_READ__SHIFT                                                   0x12
#define CP_CPC_STALLED_STAT1__MEC2_WAIT_ON_ROQ_DATA__SHIFT                                                    0x15
#define CP_CPC_STALLED_STAT1__UTCL2IU_WAITING_ON_FREE__SHIFT                                                  0x16
#define CP_CPC_STALLED_STAT1__UTCL2IU_WAITING_ON_TAGS__SHIFT                                                  0x17
#define CP_CPC_STALLED_STAT1__UTCL1_WAITING_ON_TRANS__SHIFT                                                   0x18
#define CP_CPC_STALLED_STAT1__GCRIU_WAITING_ON_FREE__SHIFT                                                    0x19
#define CP_CPC_STALLED_STAT1__RCIU_TX_FREE_STALL_MASK                                                         0x00000008L
#define CP_CPC_STALLED_STAT1__RCIU_PRIV_VIOLATION_MASK                                                        0x00000010L
#define CP_CPC_STALLED_STAT1__TCIU_TX_FREE_STALL_MASK                                                         0x00000040L
#define CP_CPC_STALLED_STAT1__MEC1_DECODING_PACKET_MASK                                                       0x00000100L
#define CP_CPC_STALLED_STAT1__MEC1_WAIT_ON_RCIU_MASK                                                          0x00000200L
#define CP_CPC_STALLED_STAT1__MEC1_WAIT_ON_RCIU_READ_MASK                                                     0x00000400L
#define CP_CPC_STALLED_STAT1__MEC1_WAIT_ON_ROQ_DATA_MASK                                                      0x00002000L
#define CP_CPC_STALLED_STAT1__MEC2_DECODING_PACKET_MASK                                                       0x00010000L
#define CP_CPC_STALLED_STAT1__MEC2_WAIT_ON_RCIU_MASK                                                          0x00020000L
#define CP_CPC_STALLED_STAT1__MEC2_WAIT_ON_RCIU_READ_MASK                                                     0x00040000L
#define CP_CPC_STALLED_STAT1__MEC2_WAIT_ON_ROQ_DATA_MASK                                                      0x00200000L
#define CP_CPC_STALLED_STAT1__UTCL2IU_WAITING_ON_FREE_MASK                                                    0x00400000L
#define CP_CPC_STALLED_STAT1__UTCL2IU_WAITING_ON_TAGS_MASK                                                    0x00800000L
#define CP_CPC_STALLED_STAT1__UTCL1_WAITING_ON_TRANS_MASK                                                     0x01000000L
#define CP_CPC_STALLED_STAT1__GCRIU_WAITING_ON_FREE_MASK                                                      0x02000000L
//CP_CPF_STATUS
#define CP_CPF_STATUS__POST_WPTR_GFX_BUSY__SHIFT                                                              0x0
#define CP_CPF_STATUS__CSF_BUSY__SHIFT                                                                        0x1
#define CP_CPF_STATUS__ROQ_ALIGN_BUSY__SHIFT                                                                  0x4
#define CP_CPF_STATUS__ROQ_RING_BUSY__SHIFT                                                                   0x5
#define CP_CPF_STATUS__ROQ_INDIRECT1_BUSY__SHIFT                                                              0x6
#define CP_CPF_STATUS__ROQ_INDIRECT2_BUSY__SHIFT                                                              0x7
#define CP_CPF_STATUS__ROQ_STATE_BUSY__SHIFT                                                                  0x8
#define CP_CPF_STATUS__ROQ_CE_RING_BUSY__SHIFT                                                                0x9
#define CP_CPF_STATUS__ROQ_CE_INDIRECT1_BUSY__SHIFT                                                           0xa
#define CP_CPF_STATUS__ROQ_CE_INDIRECT2_BUSY__SHIFT                                                           0xb
#define CP_CPF_STATUS__SEMAPHORE_BUSY__SHIFT                                                                  0xc
#define CP_CPF_STATUS__INTERRUPT_BUSY__SHIFT                                                                  0xd
#define CP_CPF_STATUS__TCIU_BUSY__SHIFT                                                                       0xe
#define CP_CPF_STATUS__HQD_BUSY__SHIFT                                                                        0xf
#define CP_CPF_STATUS__PRT_BUSY__SHIFT                                                                        0x10
#define CP_CPF_STATUS__UTCL2IU_BUSY__SHIFT                                                                    0x11
#define CP_CPF_STATUS__RCIU_BUSY__SHIFT                                                                       0x12
#define CP_CPF_STATUS__RCIU_GFX_BUSY__SHIFT                                                                   0x13
#define CP_CPF_STATUS__RCIU_CMP_BUSY__SHIFT                                                                   0x14
#define CP_CPF_STATUS__ROQ_DATA_BUSY__SHIFT                                                                   0x15
#define CP_CPF_STATUS__ROQ_CE_DATA_BUSY__SHIFT                                                                0x16
#define CP_CPF_STATUS__GCRIU_BUSY__SHIFT                                                                      0x17
#define CP_CPF_STATUS__MES_HQD_BUSY__SHIFT                                                                    0x18
#define CP_CPF_STATUS__CPF_GFX_BUSY__SHIFT                                                                    0x1a
#define CP_CPF_STATUS__CPF_CMP_BUSY__SHIFT                                                                    0x1b
#define CP_CPF_STATUS__GRBM_CPF_STAT_BUSY__SHIFT                                                              0x1c
#define CP_CPF_STATUS__CPC_CPF_BUSY__SHIFT                                                                    0x1e
#define CP_CPF_STATUS__CPF_BUSY__SHIFT                                                                        0x1f
#define CP_CPF_STATUS__POST_WPTR_GFX_BUSY_MASK                                                                0x00000001L
#define CP_CPF_STATUS__CSF_BUSY_MASK                                                                          0x00000002L
#define CP_CPF_STATUS__ROQ_ALIGN_BUSY_MASK                                                                    0x00000010L
#define CP_CPF_STATUS__ROQ_RING_BUSY_MASK                                                                     0x00000020L
#define CP_CPF_STATUS__ROQ_INDIRECT1_BUSY_MASK                                                                0x00000040L
#define CP_CPF_STATUS__ROQ_INDIRECT2_BUSY_MASK                                                                0x00000080L
#define CP_CPF_STATUS__ROQ_STATE_BUSY_MASK                                                                    0x00000100L
#define CP_CPF_STATUS__ROQ_CE_RING_BUSY_MASK                                                                  0x00000200L
#define CP_CPF_STATUS__ROQ_CE_INDIRECT1_BUSY_MASK                                                             0x00000400L
#define CP_CPF_STATUS__ROQ_CE_INDIRECT2_BUSY_MASK                                                             0x00000800L
#define CP_CPF_STATUS__SEMAPHORE_BUSY_MASK                                                                    0x00001000L
#define CP_CPF_STATUS__INTERRUPT_BUSY_MASK                                                                    0x00002000L
#define CP_CPF_STATUS__TCIU_BUSY_MASK                                                                         0x00004000L
#define CP_CPF_STATUS__HQD_BUSY_MASK                                                                          0x00008000L
#define CP_CPF_STATUS__PRT_BUSY_MASK                                                                          0x00010000L
#define CP_CPF_STATUS__UTCL2IU_BUSY_MASK                                                                      0x00020000L
#define CP_CPF_STATUS__RCIU_BUSY_MASK                                                                         0x00040000L
#define CP_CPF_STATUS__RCIU_GFX_BUSY_MASK                                                                     0x00080000L
#define CP_CPF_STATUS__RCIU_CMP_BUSY_MASK                                                                     0x00100000L
#define CP_CPF_STATUS__ROQ_DATA_BUSY_MASK                                                                     0x00200000L
#define CP_CPF_STATUS__ROQ_CE_DATA_BUSY_MASK                                                                  0x00400000L
#define CP_CPF_STATUS__GCRIU_BUSY_MASK                                                                        0x00800000L
#define CP_CPF_STATUS__MES_HQD_BUSY_MASK                                                                      0x01000000L
#define CP_CPF_STATUS__CPF_GFX_BUSY_MASK                                                                      0x04000000L
#define CP_CPF_STATUS__CPF_CMP_BUSY_MASK                                                                      0x08000000L
#define CP_CPF_STATUS__GRBM_CPF_STAT_BUSY_MASK                                                                0x30000000L
#define CP_CPF_STATUS__CPC_CPF_BUSY_MASK                                                                      0x40000000L
#define CP_CPF_STATUS__CPF_BUSY_MASK                                                                          0x80000000L
//CP_CPF_BUSY_STAT
#define CP_CPF_BUSY_STAT__REG_BUS_FIFO_BUSY__SHIFT                                                            0x0
#define CP_CPF_BUSY_STAT__CSF_RING_BUSY__SHIFT                                                                0x1
#define CP_CPF_BUSY_STAT__CSF_INDIRECT1_BUSY__SHIFT                                                           0x2
#define CP_CPF_BUSY_STAT__CSF_INDIRECT2_BUSY__SHIFT                                                           0x3
#define CP_CPF_BUSY_STAT__CSF_STATE_BUSY__SHIFT                                                               0x4
#define CP_CPF_BUSY_STAT__CSF_CE_INDR1_BUSY__SHIFT                                                            0x5
#define CP_CPF_BUSY_STAT__CSF_CE_INDR2_BUSY__SHIFT                                                            0x6
#define CP_CPF_BUSY_STAT__CSF_ARBITER_BUSY__SHIFT                                                             0x7
#define CP_CPF_BUSY_STAT__CSF_INPUT_BUSY__SHIFT                                                               0x8
#define CP_CPF_BUSY_STAT__CSF_DATA_BUSY__SHIFT                                                                0x9
#define CP_CPF_BUSY_STAT__CSF_CE_DATA_BUSY__SHIFT                                                             0xa
#define CP_CPF_BUSY_STAT__HPD_PROCESSING_EOP_BUSY__SHIFT                                                      0xb
#define CP_CPF_BUSY_STAT__HQD_DISPATCH_BUSY__SHIFT                                                            0xc
#define CP_CPF_BUSY_STAT__HQD_IQ_TIMER_BUSY__SHIFT                                                            0xd
#define CP_CPF_BUSY_STAT__HQD_DMA_OFFLOAD_BUSY__SHIFT                                                         0xe
#define CP_CPF_BUSY_STAT__HQD_WAIT_SEMAPHORE_BUSY__SHIFT                                                      0xf
#define CP_CPF_BUSY_STAT__HQD_SIGNAL_SEMAPHORE_BUSY__SHIFT                                                    0x10
#define CP_CPF_BUSY_STAT__HQD_MESSAGE_BUSY__SHIFT                                                             0x11
#define CP_CPF_BUSY_STAT__HQD_PQ_FETCHER_BUSY__SHIFT                                                          0x12
#define CP_CPF_BUSY_STAT__HQD_IB_FETCHER_BUSY__SHIFT                                                          0x13
#define CP_CPF_BUSY_STAT__HQD_IQ_FETCHER_BUSY__SHIFT                                                          0x14
#define CP_CPF_BUSY_STAT__HQD_EOP_FETCHER_BUSY__SHIFT                                                         0x15
#define CP_CPF_BUSY_STAT__HQD_CONSUMED_RPTR_BUSY__SHIFT                                                       0x16
#define CP_CPF_BUSY_STAT__HQD_FETCHER_ARB_BUSY__SHIFT                                                         0x17
#define CP_CPF_BUSY_STAT__HQD_ROQ_ALIGN_BUSY__SHIFT                                                           0x18
#define CP_CPF_BUSY_STAT__HQD_ROQ_EOP_BUSY__SHIFT                                                             0x19
#define CP_CPF_BUSY_STAT__HQD_ROQ_IQ_BUSY__SHIFT                                                              0x1a
#define CP_CPF_BUSY_STAT__HQD_ROQ_PQ_BUSY__SHIFT                                                              0x1b
#define CP_CPF_BUSY_STAT__HQD_ROQ_IB_BUSY__SHIFT                                                              0x1c
#define CP_CPF_BUSY_STAT__HQD_WPTR_POLL_BUSY__SHIFT                                                           0x1d
#define CP_CPF_BUSY_STAT__HQD_PQ_BUSY__SHIFT                                                                  0x1e
#define CP_CPF_BUSY_STAT__HQD_IB_BUSY__SHIFT                                                                  0x1f
#define CP_CPF_BUSY_STAT__REG_BUS_FIFO_BUSY_MASK                                                              0x00000001L
#define CP_CPF_BUSY_STAT__CSF_RING_BUSY_MASK                                                                  0x00000002L
#define CP_CPF_BUSY_STAT__CSF_INDIRECT1_BUSY_MASK                                                             0x00000004L
#define CP_CPF_BUSY_STAT__CSF_INDIRECT2_BUSY_MASK                                                             0x00000008L
#define CP_CPF_BUSY_STAT__CSF_STATE_BUSY_MASK                                                                 0x00000010L
#define CP_CPF_BUSY_STAT__CSF_CE_INDR1_BUSY_MASK                                                              0x00000020L
#define CP_CPF_BUSY_STAT__CSF_CE_INDR2_BUSY_MASK                                                              0x00000040L
#define CP_CPF_BUSY_STAT__CSF_ARBITER_BUSY_MASK                                                               0x00000080L
#define CP_CPF_BUSY_STAT__CSF_INPUT_BUSY_MASK                                                                 0x00000100L
#define CP_CPF_BUSY_STAT__CSF_DATA_BUSY_MASK                                                                  0x00000200L
#define CP_CPF_BUSY_STAT__CSF_CE_DATA_BUSY_MASK                                                               0x00000400L
#define CP_CPF_BUSY_STAT__HPD_PROCESSING_EOP_BUSY_MASK                                                        0x00000800L
#define CP_CPF_BUSY_STAT__HQD_DISPATCH_BUSY_MASK                                                              0x00001000L
#define CP_CPF_BUSY_STAT__HQD_IQ_TIMER_BUSY_MASK                                                              0x00002000L
#define CP_CPF_BUSY_STAT__HQD_DMA_OFFLOAD_BUSY_MASK                                                           0x00004000L
#define CP_CPF_BUSY_STAT__HQD_WAIT_SEMAPHORE_BUSY_MASK                                                        0x00008000L
#define CP_CPF_BUSY_STAT__HQD_SIGNAL_SEMAPHORE_BUSY_MASK                                                      0x00010000L
#define CP_CPF_BUSY_STAT__HQD_MESSAGE_BUSY_MASK                                                               0x00020000L
#define CP_CPF_BUSY_STAT__HQD_PQ_FETCHER_BUSY_MASK                                                            0x00040000L
#define CP_CPF_BUSY_STAT__HQD_IB_FETCHER_BUSY_MASK                                                            0x00080000L
#define CP_CPF_BUSY_STAT__HQD_IQ_FETCHER_BUSY_MASK                                                            0x00100000L
#define CP_CPF_BUSY_STAT__HQD_EOP_FETCHER_BUSY_MASK                                                           0x00200000L
#define CP_CPF_BUSY_STAT__HQD_CONSUMED_RPTR_BUSY_MASK                                                         0x00400000L
#define CP_CPF_BUSY_STAT__HQD_FETCHER_ARB_BUSY_MASK                                                           0x00800000L
#define CP_CPF_BUSY_STAT__HQD_ROQ_ALIGN_BUSY_MASK                                                             0x01000000L
#define CP_CPF_BUSY_STAT__HQD_ROQ_EOP_BUSY_MASK                                                               0x02000000L
#define CP_CPF_BUSY_STAT__HQD_ROQ_IQ_BUSY_MASK                                                                0x04000000L
#define CP_CPF_BUSY_STAT__HQD_ROQ_PQ_BUSY_MASK                                                                0x08000000L
#define CP_CPF_BUSY_STAT__HQD_ROQ_IB_BUSY_MASK                                                                0x10000000L
#define CP_CPF_BUSY_STAT__HQD_WPTR_POLL_BUSY_MASK                                                             0x20000000L
#define CP_CPF_BUSY_STAT__HQD_PQ_BUSY_MASK                                                                    0x40000000L
#define CP_CPF_BUSY_STAT__HQD_IB_BUSY_MASK                                                                    0x80000000L
//CP_CPF_STALLED_STAT1
#define CP_CPF_STALLED_STAT1__RING_FETCHING_DATA__SHIFT                                                       0x0
#define CP_CPF_STALLED_STAT1__INDR1_FETCHING_DATA__SHIFT                                                      0x1
#define CP_CPF_STALLED_STAT1__INDR2_FETCHING_DATA__SHIFT                                                      0x2
#define CP_CPF_STALLED_STAT1__STATE_FETCHING_DATA__SHIFT                                                      0x3
#define CP_CPF_STALLED_STAT1__TCIU_WAITING_ON_FREE__SHIFT                                                     0x5
#define CP_CPF_STALLED_STAT1__TCIU_WAITING_ON_TAGS__SHIFT                                                     0x6
#define CP_CPF_STALLED_STAT1__UTCL2IU_WAITING_ON_FREE__SHIFT                                                  0x7
#define CP_CPF_STALLED_STAT1__UTCL2IU_WAITING_ON_TAGS__SHIFT                                                  0x8
#define CP_CPF_STALLED_STAT1__GFX_UTCL1_WAITING_ON_TRANS__SHIFT                                               0x9
#define CP_CPF_STALLED_STAT1__CMP_UTCL1_WAITING_ON_TRANS__SHIFT                                               0xa
#define CP_CPF_STALLED_STAT1__RCIU_WAITING_ON_FREE__SHIFT                                                     0xb
#define CP_CPF_STALLED_STAT1__DATA_FETCHING_DATA__SHIFT                                                       0xc
#define CP_CPF_STALLED_STAT1__GCRIU_WAIT_ON_FREE__SHIFT                                                       0xd
#define CP_CPF_STALLED_STAT1__RING_FETCHING_DATA_MASK                                                         0x00000001L
#define CP_CPF_STALLED_STAT1__INDR1_FETCHING_DATA_MASK                                                        0x00000002L
#define CP_CPF_STALLED_STAT1__INDR2_FETCHING_DATA_MASK                                                        0x00000004L
#define CP_CPF_STALLED_STAT1__STATE_FETCHING_DATA_MASK                                                        0x00000008L
#define CP_CPF_STALLED_STAT1__TCIU_WAITING_ON_FREE_MASK                                                       0x00000020L
#define CP_CPF_STALLED_STAT1__TCIU_WAITING_ON_TAGS_MASK                                                       0x00000040L
#define CP_CPF_STALLED_STAT1__UTCL2IU_WAITING_ON_FREE_MASK                                                    0x00000080L
#define CP_CPF_STALLED_STAT1__UTCL2IU_WAITING_ON_TAGS_MASK                                                    0x00000100L
#define CP_CPF_STALLED_STAT1__GFX_UTCL1_WAITING_ON_TRANS_MASK                                                 0x00000200L
#define CP_CPF_STALLED_STAT1__CMP_UTCL1_WAITING_ON_TRANS_MASK                                                 0x00000400L
#define CP_CPF_STALLED_STAT1__RCIU_WAITING_ON_FREE_MASK                                                       0x00000800L
#define CP_CPF_STALLED_STAT1__DATA_FETCHING_DATA_MASK                                                         0x00001000L
#define CP_CPF_STALLED_STAT1__GCRIU_WAIT_ON_FREE_MASK                                                         0x00002000L
//CP_CPC_BUSY_STAT2
#define CP_CPC_BUSY_STAT2__MES_LOAD_BUSY__SHIFT                                                               0x0
#define CP_CPC_BUSY_STAT2__MES_MUTEX_BUSY__SHIFT                                                              0x2
#define CP_CPC_BUSY_STAT2__MES_MESSAGE_BUSY__SHIFT                                                            0x3
#define CP_CPC_BUSY_STAT2__MES_TC_BUSY__SHIFT                                                                 0x7
#define CP_CPC_BUSY_STAT2__MES_DMA_BUSY__SHIFT                                                                0x8
#define CP_CPC_BUSY_STAT2__MES_PIPE0_BUSY__SHIFT                                                              0xa
#define CP_CPC_BUSY_STAT2__MES_PIPE1_BUSY__SHIFT                                                              0xb
#define CP_CPC_BUSY_STAT2__MES_PIPE2_BUSY__SHIFT                                                              0xc
#define CP_CPC_BUSY_STAT2__MES_PIPE3_BUSY__SHIFT                                                              0xd
#define CP_CPC_BUSY_STAT2__MES_LOAD_BUSY_MASK                                                                 0x00000001L
#define CP_CPC_BUSY_STAT2__MES_MUTEX_BUSY_MASK                                                                0x00000004L
#define CP_CPC_BUSY_STAT2__MES_MESSAGE_BUSY_MASK                                                              0x00000008L
#define CP_CPC_BUSY_STAT2__MES_TC_BUSY_MASK                                                                   0x00000080L
#define CP_CPC_BUSY_STAT2__MES_DMA_BUSY_MASK                                                                  0x00000100L
#define CP_CPC_BUSY_STAT2__MES_PIPE0_BUSY_MASK                                                                0x00000400L
#define CP_CPC_BUSY_STAT2__MES_PIPE1_BUSY_MASK                                                                0x00000800L
#define CP_CPC_BUSY_STAT2__MES_PIPE2_BUSY_MASK                                                                0x00001000L
#define CP_CPC_BUSY_STAT2__MES_PIPE3_BUSY_MASK                                                                0x00002000L
//CP_CPC_GRBM_FREE_COUNT
#define CP_CPC_GRBM_FREE_COUNT__FREE_COUNT__SHIFT                                                             0x0
#define CP_CPC_GRBM_FREE_COUNT__FREE_COUNT_MASK                                                               0x0000003FL
//CP_CPC_PRIV_VIOLATION_ADDR
#define CP_CPC_PRIV_VIOLATION_ADDR__PRIV_VIOLATION_ADDR__SHIFT                                                0x0
#define CP_CPC_PRIV_VIOLATION_ADDR__PRIV_VIOLATION_ADDR_MASK                                                  0x0000FFFFL
//CP_MEC_ME1_HEADER_DUMP
#define CP_MEC_ME1_HEADER_DUMP__HEADER_DUMP__SHIFT                                                            0x0
#define CP_MEC_ME1_HEADER_DUMP__HEADER_DUMP_MASK                                                              0xFFFFFFFFL
//CP_MEC_ME2_HEADER_DUMP
#define CP_MEC_ME2_HEADER_DUMP__HEADER_DUMP__SHIFT                                                            0x0
#define CP_MEC_ME2_HEADER_DUMP__HEADER_DUMP_MASK                                                              0xFFFFFFFFL
//CP_CPC_SCRATCH_INDEX
#define CP_CPC_SCRATCH_INDEX__SCRATCH_INDEX__SHIFT                                                            0x0
#define CP_CPC_SCRATCH_INDEX__SCRATCH_INDEX_64BIT_MODE__SHIFT                                                 0x1f
#define CP_CPC_SCRATCH_INDEX__SCRATCH_INDEX_MASK                                                              0x000001FFL
#define CP_CPC_SCRATCH_INDEX__SCRATCH_INDEX_64BIT_MODE_MASK                                                   0x80000000L
//CP_CPC_SCRATCH_DATA
#define CP_CPC_SCRATCH_DATA__SCRATCH_DATA__SHIFT                                                              0x0
#define CP_CPC_SCRATCH_DATA__SCRATCH_DATA_MASK                                                                0xFFFFFFFFL
//CP_CPF_GRBM_FREE_COUNT
#define CP_CPF_GRBM_FREE_COUNT__FREE_COUNT__SHIFT                                                             0x0
#define CP_CPF_GRBM_FREE_COUNT__FREE_COUNT_MASK                                                               0x00000007L
//CP_CPF_BUSY_STAT2
#define CP_CPF_BUSY_STAT2__MES_HQD_DISPATCH_BUSY__SHIFT                                                       0xc
#define CP_CPF_BUSY_STAT2__MES_HQD_DMA_OFFLOAD_BUSY__SHIFT                                                    0xe
#define CP_CPF_BUSY_STAT2__MES_HQD_MESSAGE_BUSY__SHIFT                                                        0x11
#define CP_CPF_BUSY_STAT2__MES_HQD_PQ_FETCHER_BUSY__SHIFT                                                     0x12
#define CP_CPF_BUSY_STAT2__MES_HQD_CONSUMED_RPTR_BUSY__SHIFT                                                  0x16
#define CP_CPF_BUSY_STAT2__MES_HQD_FETCHER_ARB_BUSY__SHIFT                                                    0x17
#define CP_CPF_BUSY_STAT2__MES_HQD_ROQ_ALIGN_BUSY__SHIFT                                                      0x18
#define CP_CPF_BUSY_STAT2__MES_HQD_ROQ_PQ_BUSY__SHIFT                                                         0x1b
#define CP_CPF_BUSY_STAT2__MES_HQD_PQ_BUSY__SHIFT                                                             0x1e
#define CP_CPF_BUSY_STAT2__MES_HQD_DISPATCH_BUSY_MASK                                                         0x00001000L
#define CP_CPF_BUSY_STAT2__MES_HQD_DMA_OFFLOAD_BUSY_MASK                                                      0x00004000L
#define CP_CPF_BUSY_STAT2__MES_HQD_MESSAGE_BUSY_MASK                                                          0x00020000L
#define CP_CPF_BUSY_STAT2__MES_HQD_PQ_FETCHER_BUSY_MASK                                                       0x00040000L
#define CP_CPF_BUSY_STAT2__MES_HQD_CONSUMED_RPTR_BUSY_MASK                                                    0x00400000L
#define CP_CPF_BUSY_STAT2__MES_HQD_FETCHER_ARB_BUSY_MASK                                                      0x00800000L
#define CP_CPF_BUSY_STAT2__MES_HQD_ROQ_ALIGN_BUSY_MASK                                                        0x01000000L
#define CP_CPF_BUSY_STAT2__MES_HQD_ROQ_PQ_BUSY_MASK                                                           0x08000000L
#define CP_CPF_BUSY_STAT2__MES_HQD_PQ_BUSY_MASK                                                               0x40000000L
//CONFIG_RESERVED_REG0
#define CONFIG_RESERVED_REG0__DATA__SHIFT                                                                     0x0
#define CONFIG_RESERVED_REG0__DATA_MASK                                                                       0xFFFFFFFFL
//CONFIG_RESERVED_REG1
#define CONFIG_RESERVED_REG1__DATA__SHIFT                                                                     0x0
#define CONFIG_RESERVED_REG1__DATA_MASK                                                                       0xFFFFFFFFL
//CP_CPC_HALT_HYST_COUNT
#define CP_CPC_HALT_HYST_COUNT__COUNT__SHIFT                                                                  0x0
#define CP_CPC_HALT_HYST_COUNT__COUNT_MASK                                                                    0x0000000FL
//CP_CE_COMPARE_COUNT
#define CP_CE_COMPARE_COUNT__COMPARE_COUNT__SHIFT                                                             0x0
#define CP_CE_COMPARE_COUNT__COMPARE_COUNT_MASK                                                               0xFFFFFFFFL
//CP_CE_DE_COUNT
#define CP_CE_DE_COUNT__DRAW_ENGINE_COUNT__SHIFT                                                              0x0
#define CP_CE_DE_COUNT__DRAW_ENGINE_COUNT_MASK                                                                0xFFFFFFFFL
//CP_DE_CE_COUNT
#define CP_DE_CE_COUNT__CONST_ENGINE_COUNT__SHIFT                                                             0x0
#define CP_DE_CE_COUNT__CONST_ENGINE_COUNT_MASK                                                               0xFFFFFFFFL
//CP_DE_LAST_INVAL_COUNT
#define CP_DE_LAST_INVAL_COUNT__LAST_INVAL_COUNT__SHIFT                                                       0x0
#define CP_DE_LAST_INVAL_COUNT__LAST_INVAL_COUNT_MASK                                                         0xFFFFFFFFL
//CP_DE_DE_COUNT
#define CP_DE_DE_COUNT__DRAW_ENGINE_COUNT__SHIFT                                                              0x0
#define CP_DE_DE_COUNT__DRAW_ENGINE_COUNT_MASK                                                                0xFFFFFFFFL
//CP_STALLED_STAT3
#define CP_STALLED_STAT3__CE_TO_CSF_NOT_RDY_TO_RCV__SHIFT                                                     0x0
#define CP_STALLED_STAT3__CE_TO_RAM_INIT_FETCHER_NOT_RDY_TO_RCV__SHIFT                                        0x1
#define CP_STALLED_STAT3__CE_WAITING_ON_DATA_FROM_RAM_INIT_FETCHER__SHIFT                                     0x2
#define CP_STALLED_STAT3__CE_TO_RAM_INIT_NOT_RDY__SHIFT                                                       0x3
#define CP_STALLED_STAT3__CE_TO_RAM_DUMP_NOT_RDY__SHIFT                                                       0x4
#define CP_STALLED_STAT3__CE_TO_RAM_WRITE_NOT_RDY__SHIFT                                                      0x5
#define CP_STALLED_STAT3__CE_TO_INC_FIFO_NOT_RDY_TO_RCV__SHIFT                                                0x6
#define CP_STALLED_STAT3__CE_TO_WR_FIFO_NOT_RDY_TO_RCV__SHIFT                                                 0x7
#define CP_STALLED_STAT3__CE_WAITING_ON_BUFFER_DATA__SHIFT                                                    0xa
#define CP_STALLED_STAT3__CE_WAITING_ON_CE_BUFFER_FLAG__SHIFT                                                 0xb
#define CP_STALLED_STAT3__CE_WAITING_ON_DE_COUNTER__SHIFT                                                     0xc
#define CP_STALLED_STAT3__CE_WAITING_ON_DE_COUNTER_UNDERFLOW__SHIFT                                           0xd
#define CP_STALLED_STAT3__TCIU_WAITING_ON_FREE__SHIFT                                                         0xe
#define CP_STALLED_STAT3__TCIU_WAITING_ON_TAGS__SHIFT                                                         0xf
#define CP_STALLED_STAT3__CE_STALLED_ON_TC_WR_CONFIRM__SHIFT                                                  0x10
#define CP_STALLED_STAT3__CE_STALLED_ON_ATOMIC_RTN_DATA__SHIFT                                                0x11
#define CP_STALLED_STAT3__UTCL2IU_WAITING_ON_FREE__SHIFT                                                      0x12
#define CP_STALLED_STAT3__UTCL2IU_WAITING_ON_TAGS__SHIFT                                                      0x13
#define CP_STALLED_STAT3__UTCL1_WAITING_ON_TRANS__SHIFT                                                       0x14
#define CP_STALLED_STAT3__GCRIU_WAITING_ON_FREE__SHIFT                                                        0x15
#define CP_STALLED_STAT3__CE_TO_CSF_NOT_RDY_TO_RCV_MASK                                                       0x00000001L
#define CP_STALLED_STAT3__CE_TO_RAM_INIT_FETCHER_NOT_RDY_TO_RCV_MASK                                          0x00000002L
#define CP_STALLED_STAT3__CE_WAITING_ON_DATA_FROM_RAM_INIT_FETCHER_MASK                                       0x00000004L
#define CP_STALLED_STAT3__CE_TO_RAM_INIT_NOT_RDY_MASK                                                         0x00000008L
#define CP_STALLED_STAT3__CE_TO_RAM_DUMP_NOT_RDY_MASK                                                         0x00000010L
#define CP_STALLED_STAT3__CE_TO_RAM_WRITE_NOT_RDY_MASK                                                        0x00000020L
#define CP_STALLED_STAT3__CE_TO_INC_FIFO_NOT_RDY_TO_RCV_MASK                                                  0x00000040L
#define CP_STALLED_STAT3__CE_TO_WR_FIFO_NOT_RDY_TO_RCV_MASK                                                   0x00000080L
#define CP_STALLED_STAT3__CE_WAITING_ON_BUFFER_DATA_MASK                                                      0x00000400L
#define CP_STALLED_STAT3__CE_WAITING_ON_CE_BUFFER_FLAG_MASK                                                   0x00000800L
#define CP_STALLED_STAT3__CE_WAITING_ON_DE_COUNTER_MASK                                                       0x00001000L
#define CP_STALLED_STAT3__CE_WAITING_ON_DE_COUNTER_UNDERFLOW_MASK                                             0x00002000L
#define CP_STALLED_STAT3__TCIU_WAITING_ON_FREE_MASK                                                           0x00004000L
#define CP_STALLED_STAT3__TCIU_WAITING_ON_TAGS_MASK                                                           0x00008000L
#define CP_STALLED_STAT3__CE_STALLED_ON_TC_WR_CONFIRM_MASK                                                    0x00010000L
#define CP_STALLED_STAT3__CE_STALLED_ON_ATOMIC_RTN_DATA_MASK                                                  0x00020000L
#define CP_STALLED_STAT3__UTCL2IU_WAITING_ON_FREE_MASK                                                        0x00040000L
#define CP_STALLED_STAT3__UTCL2IU_WAITING_ON_TAGS_MASK                                                        0x00080000L
#define CP_STALLED_STAT3__UTCL1_WAITING_ON_TRANS_MASK                                                         0x00100000L
#define CP_STALLED_STAT3__GCRIU_WAITING_ON_FREE_MASK                                                          0x00200000L
//CP_STALLED_STAT1
#define CP_STALLED_STAT1__RBIU_TO_DMA_NOT_RDY_TO_RCV__SHIFT                                                   0x0
#define CP_STALLED_STAT1__RBIU_TO_SEM_NOT_RDY_TO_RCV_R0__SHIFT                                                0x2
#define CP_STALLED_STAT1__RBIU_TO_SEM_NOT_RDY_TO_RCV_R1__SHIFT                                                0x3
#define CP_STALLED_STAT1__RBIU_TO_MEMWR_NOT_RDY_TO_RCV_R0__SHIFT                                              0x4
#define CP_STALLED_STAT1__RBIU_TO_MEMWR_NOT_RDY_TO_RCV_R1__SHIFT                                              0x5
#define CP_STALLED_STAT1__ME_HAS_ACTIVE_CE_BUFFER_FLAG__SHIFT                                                 0xa
#define CP_STALLED_STAT1__ME_HAS_ACTIVE_DE_BUFFER_FLAG__SHIFT                                                 0xb
#define CP_STALLED_STAT1__ME_STALLED_ON_TC_WR_CONFIRM__SHIFT                                                  0xc
#define CP_STALLED_STAT1__ME_STALLED_ON_ATOMIC_RTN_DATA__SHIFT                                                0xd
#define CP_STALLED_STAT1__ME_WAITING_ON_TC_READ_DATA__SHIFT                                                   0xe
#define CP_STALLED_STAT1__ME_WAITING_ON_REG_READ_DATA__SHIFT                                                  0xf
#define CP_STALLED_STAT1__RCIU_WAITING_ON_GDS_FREE__SHIFT                                                     0x17
#define CP_STALLED_STAT1__RCIU_WAITING_ON_GRBM_FREE__SHIFT                                                    0x18
#define CP_STALLED_STAT1__RCIU_WAITING_ON_VGT_FREE__SHIFT                                                     0x19
#define CP_STALLED_STAT1__RCIU_STALLED_ON_ME_READ__SHIFT                                                      0x1a
#define CP_STALLED_STAT1__RCIU_STALLED_ON_DMA_READ__SHIFT                                                     0x1b
#define CP_STALLED_STAT1__RCIU_STALLED_ON_APPEND_READ__SHIFT                                                  0x1c
#define CP_STALLED_STAT1__RCIU_HALTED_BY_REG_VIOLATION__SHIFT                                                 0x1d
#define CP_STALLED_STAT1__RBIU_TO_DMA_NOT_RDY_TO_RCV_MASK                                                     0x00000001L
#define CP_STALLED_STAT1__RBIU_TO_SEM_NOT_RDY_TO_RCV_R0_MASK                                                  0x00000004L
#define CP_STALLED_STAT1__RBIU_TO_SEM_NOT_RDY_TO_RCV_R1_MASK                                                  0x00000008L
#define CP_STALLED_STAT1__RBIU_TO_MEMWR_NOT_RDY_TO_RCV_R0_MASK                                                0x00000010L
#define CP_STALLED_STAT1__RBIU_TO_MEMWR_NOT_RDY_TO_RCV_R1_MASK                                                0x00000020L
#define CP_STALLED_STAT1__ME_HAS_ACTIVE_CE_BUFFER_FLAG_MASK                                                   0x00000400L
#define CP_STALLED_STAT1__ME_HAS_ACTIVE_DE_BUFFER_FLAG_MASK                                                   0x00000800L
#define CP_STALLED_STAT1__ME_STALLED_ON_TC_WR_CONFIRM_MASK                                                    0x00001000L
#define CP_STALLED_STAT1__ME_STALLED_ON_ATOMIC_RTN_DATA_MASK                                                  0x00002000L
#define CP_STALLED_STAT1__ME_WAITING_ON_TC_READ_DATA_MASK                                                     0x00004000L
#define CP_STALLED_STAT1__ME_WAITING_ON_REG_READ_DATA_MASK                                                    0x00008000L
#define CP_STALLED_STAT1__RCIU_WAITING_ON_GDS_FREE_MASK                                                       0x00800000L
#define CP_STALLED_STAT1__RCIU_WAITING_ON_GRBM_FREE_MASK                                                      0x01000000L
#define CP_STALLED_STAT1__RCIU_WAITING_ON_VGT_FREE_MASK                                                       0x02000000L
#define CP_STALLED_STAT1__RCIU_STALLED_ON_ME_READ_MASK                                                        0x04000000L
#define CP_STALLED_STAT1__RCIU_STALLED_ON_DMA_READ_MASK                                                       0x08000000L
#define CP_STALLED_STAT1__RCIU_STALLED_ON_APPEND_READ_MASK                                                    0x10000000L
#define CP_STALLED_STAT1__RCIU_HALTED_BY_REG_VIOLATION_MASK                                                   0x20000000L
//CP_STALLED_STAT2
#define CP_STALLED_STAT2__PFP_TO_CSF_NOT_RDY_TO_RCV__SHIFT                                                    0x0
#define CP_STALLED_STAT2__PFP_TO_MEQ_NOT_RDY_TO_RCV__SHIFT                                                    0x1
#define CP_STALLED_STAT2__PFP_TO_RCIU_NOT_RDY_TO_RCV__SHIFT                                                   0x2
#define CP_STALLED_STAT2__PFP_TO_VGT_WRITES_PENDING__SHIFT                                                    0x4
#define CP_STALLED_STAT2__PFP_RCIU_READ_PENDING__SHIFT                                                        0x5
#define CP_STALLED_STAT2__PFP_TO_MEQ_DDID_NOT_RDY_TO_RCV__SHIFT                                               0x6
#define CP_STALLED_STAT2__PFP_WAITING_ON_BUFFER_DATA__SHIFT                                                   0x8
#define CP_STALLED_STAT2__ME_WAIT_ON_CE_COUNTER__SHIFT                                                        0x9
#define CP_STALLED_STAT2__ME_WAIT_ON_AVAIL_BUFFER__SHIFT                                                      0xa
#define CP_STALLED_STAT2__GFX_CNTX_NOT_AVAIL_TO_ME__SHIFT                                                     0xb
#define CP_STALLED_STAT2__ME_RCIU_NOT_RDY_TO_RCV__SHIFT                                                       0xc
#define CP_STALLED_STAT2__ME_TO_CONST_NOT_RDY_TO_RCV__SHIFT                                                   0xd
#define CP_STALLED_STAT2__ME_WAITING_DATA_FROM_PFP__SHIFT                                                     0xe
#define CP_STALLED_STAT2__ME_WAITING_ON_PARTIAL_FLUSH__SHIFT                                                  0xf
#define CP_STALLED_STAT2__MEQ_TO_ME_NOT_RDY_TO_RCV__SHIFT                                                     0x10
#define CP_STALLED_STAT2__STQ_TO_ME_NOT_RDY_TO_RCV__SHIFT                                                     0x11
#define CP_STALLED_STAT2__ME_WAITING_DATA_FROM_STQ__SHIFT                                                     0x12
#define CP_STALLED_STAT2__PFP_STALLED_ON_TC_WR_CONFIRM__SHIFT                                                 0x13
#define CP_STALLED_STAT2__PFP_STALLED_ON_ATOMIC_RTN_DATA__SHIFT                                               0x14
#define CP_STALLED_STAT2__QU_STALLED_ON_EOP_DONE_PULSE__SHIFT                                                 0x15
#define CP_STALLED_STAT2__QU_STALLED_ON_EOP_DONE_WR_CONFIRM__SHIFT                                            0x16
#define CP_STALLED_STAT2__STRMO_WR_OF_PRIM_DATA_PENDING__SHIFT                                                0x17
#define CP_STALLED_STAT2__PIPE_STATS_WR_DATA_PENDING__SHIFT                                                   0x18
#define CP_STALLED_STAT2__APPEND_RDY_WAIT_ON_CS_DONE__SHIFT                                                   0x19
#define CP_STALLED_STAT2__APPEND_RDY_WAIT_ON_PS_DONE__SHIFT                                                   0x1a
#define CP_STALLED_STAT2__APPEND_WAIT_ON_WR_CONFIRM__SHIFT                                                    0x1b
#define CP_STALLED_STAT2__APPEND_ACTIVE_PARTITION__SHIFT                                                      0x1c
#define CP_STALLED_STAT2__APPEND_WAITING_TO_SEND_MEMWRITE__SHIFT                                              0x1d
#define CP_STALLED_STAT2__SURF_SYNC_NEEDS_IDLE_CNTXS__SHIFT                                                   0x1e
#define CP_STALLED_STAT2__SURF_SYNC_NEEDS_ALL_CLEAN__SHIFT                                                    0x1f
#define CP_STALLED_STAT2__PFP_TO_CSF_NOT_RDY_TO_RCV_MASK                                                      0x00000001L
#define CP_STALLED_STAT2__PFP_TO_MEQ_NOT_RDY_TO_RCV_MASK                                                      0x00000002L
#define CP_STALLED_STAT2__PFP_TO_RCIU_NOT_RDY_TO_RCV_MASK                                                     0x00000004L
#define CP_STALLED_STAT2__PFP_TO_VGT_WRITES_PENDING_MASK                                                      0x00000010L
#define CP_STALLED_STAT2__PFP_RCIU_READ_PENDING_MASK                                                          0x00000020L
#define CP_STALLED_STAT2__PFP_TO_MEQ_DDID_NOT_RDY_TO_RCV_MASK                                                 0x00000040L
#define CP_STALLED_STAT2__PFP_WAITING_ON_BUFFER_DATA_MASK                                                     0x00000100L
#define CP_STALLED_STAT2__ME_WAIT_ON_CE_COUNTER_MASK                                                          0x00000200L
#define CP_STALLED_STAT2__ME_WAIT_ON_AVAIL_BUFFER_MASK                                                        0x00000400L
#define CP_STALLED_STAT2__GFX_CNTX_NOT_AVAIL_TO_ME_MASK                                                       0x00000800L
#define CP_STALLED_STAT2__ME_RCIU_NOT_RDY_TO_RCV_MASK                                                         0x00001000L
#define CP_STALLED_STAT2__ME_TO_CONST_NOT_RDY_TO_RCV_MASK                                                     0x00002000L
#define CP_STALLED_STAT2__ME_WAITING_DATA_FROM_PFP_MASK                                                       0x00004000L
#define CP_STALLED_STAT2__ME_WAITING_ON_PARTIAL_FLUSH_MASK                                                    0x00008000L
#define CP_STALLED_STAT2__MEQ_TO_ME_NOT_RDY_TO_RCV_MASK                                                       0x00010000L
#define CP_STALLED_STAT2__STQ_TO_ME_NOT_RDY_TO_RCV_MASK                                                       0x00020000L
#define CP_STALLED_STAT2__ME_WAITING_DATA_FROM_STQ_MASK                                                       0x00040000L
#define CP_STALLED_STAT2__PFP_STALLED_ON_TC_WR_CONFIRM_MASK                                                   0x00080000L
#define CP_STALLED_STAT2__PFP_STALLED_ON_ATOMIC_RTN_DATA_MASK                                                 0x00100000L
#define CP_STALLED_STAT2__QU_STALLED_ON_EOP_DONE_PULSE_MASK                                                   0x00200000L
#define CP_STALLED_STAT2__QU_STALLED_ON_EOP_DONE_WR_CONFIRM_MASK                                              0x00400000L
#define CP_STALLED_STAT2__STRMO_WR_OF_PRIM_DATA_PENDING_MASK                                                  0x00800000L
#define CP_STALLED_STAT2__PIPE_STATS_WR_DATA_PENDING_MASK                                                     0x01000000L
#define CP_STALLED_STAT2__APPEND_RDY_WAIT_ON_CS_DONE_MASK                                                     0x02000000L
#define CP_STALLED_STAT2__APPEND_RDY_WAIT_ON_PS_DONE_MASK                                                     0x04000000L
#define CP_STALLED_STAT2__APPEND_WAIT_ON_WR_CONFIRM_MASK                                                      0x08000000L
#define CP_STALLED_STAT2__APPEND_ACTIVE_PARTITION_MASK                                                        0x10000000L
#define CP_STALLED_STAT2__APPEND_WAITING_TO_SEND_MEMWRITE_MASK                                                0x20000000L
#define CP_STALLED_STAT2__SURF_SYNC_NEEDS_IDLE_CNTXS_MASK                                                     0x40000000L
#define CP_STALLED_STAT2__SURF_SYNC_NEEDS_ALL_CLEAN_MASK                                                      0x80000000L
//CP_BUSY_STAT
#define CP_BUSY_STAT__REG_BUS_FIFO_BUSY__SHIFT                                                                0x0
#define CP_BUSY_STAT__COHER_CNT_NEQ_ZERO__SHIFT                                                               0x6
#define CP_BUSY_STAT__PFP_PARSING_PACKETS__SHIFT                                                              0x7
#define CP_BUSY_STAT__ME_PARSING_PACKETS__SHIFT                                                               0x8
#define CP_BUSY_STAT__RCIU_PFP_BUSY__SHIFT                                                                    0x9
#define CP_BUSY_STAT__RCIU_ME_BUSY__SHIFT                                                                     0xa
#define CP_BUSY_STAT__SEM_CMDFIFO_NOT_EMPTY__SHIFT                                                            0xc
#define CP_BUSY_STAT__SEM_FAILED_AND_HOLDING__SHIFT                                                           0xd
#define CP_BUSY_STAT__SEM_POLLING_FOR_PASS__SHIFT                                                             0xe
#define CP_BUSY_STAT__GFX_CONTEXT_BUSY__SHIFT                                                                 0xf
#define CP_BUSY_STAT__ME_PARSER_BUSY__SHIFT                                                                   0x11
#define CP_BUSY_STAT__EOP_DONE_BUSY__SHIFT                                                                    0x12
#define CP_BUSY_STAT__STRM_OUT_BUSY__SHIFT                                                                    0x13
#define CP_BUSY_STAT__PIPE_STATS_BUSY__SHIFT                                                                  0x14
#define CP_BUSY_STAT__RCIU_CE_BUSY__SHIFT                                                                     0x15
#define CP_BUSY_STAT__CE_PARSING_PACKETS__SHIFT                                                               0x16
#define CP_BUSY_STAT__REG_BUS_FIFO_BUSY_MASK                                                                  0x00000001L
#define CP_BUSY_STAT__COHER_CNT_NEQ_ZERO_MASK                                                                 0x00000040L
#define CP_BUSY_STAT__PFP_PARSING_PACKETS_MASK                                                                0x00000080L
#define CP_BUSY_STAT__ME_PARSING_PACKETS_MASK                                                                 0x00000100L
#define CP_BUSY_STAT__RCIU_PFP_BUSY_MASK                                                                      0x00000200L
#define CP_BUSY_STAT__RCIU_ME_BUSY_MASK                                                                       0x00000400L
#define CP_BUSY_STAT__SEM_CMDFIFO_NOT_EMPTY_MASK                                                              0x00001000L
#define CP_BUSY_STAT__SEM_FAILED_AND_HOLDING_MASK                                                             0x00002000L
#define CP_BUSY_STAT__SEM_POLLING_FOR_PASS_MASK                                                               0x00004000L
#define CP_BUSY_STAT__GFX_CONTEXT_BUSY_MASK                                                                   0x00008000L
#define CP_BUSY_STAT__ME_PARSER_BUSY_MASK                                                                     0x00020000L
#define CP_BUSY_STAT__EOP_DONE_BUSY_MASK                                                                      0x00040000L
#define CP_BUSY_STAT__STRM_OUT_BUSY_MASK                                                                      0x00080000L
#define CP_BUSY_STAT__PIPE_STATS_BUSY_MASK                                                                    0x00100000L
#define CP_BUSY_STAT__RCIU_CE_BUSY_MASK                                                                       0x00200000L
#define CP_BUSY_STAT__CE_PARSING_PACKETS_MASK                                                                 0x00400000L
//CP_STAT
#define CP_STAT__ROQ_DB_BUSY__SHIFT                                                                           0x5
#define CP_STAT__ROQ_CE_DB_BUSY__SHIFT                                                                        0x6
#define CP_STAT__ROQ_RING_BUSY__SHIFT                                                                         0x9
#define CP_STAT__ROQ_INDIRECT1_BUSY__SHIFT                                                                    0xa
#define CP_STAT__ROQ_INDIRECT2_BUSY__SHIFT                                                                    0xb
#define CP_STAT__ROQ_STATE_BUSY__SHIFT                                                                        0xc
#define CP_STAT__DC_BUSY__SHIFT                                                                               0xd
#define CP_STAT__UTCL2IU_BUSY__SHIFT                                                                          0xe
#define CP_STAT__PFP_BUSY__SHIFT                                                                              0xf
#define CP_STAT__MEQ_BUSY__SHIFT                                                                              0x10
#define CP_STAT__ME_BUSY__SHIFT                                                                               0x11
#define CP_STAT__QUERY_BUSY__SHIFT                                                                            0x12
#define CP_STAT__SEMAPHORE_BUSY__SHIFT                                                                        0x13
#define CP_STAT__INTERRUPT_BUSY__SHIFT                                                                        0x14
#define CP_STAT__SURFACE_SYNC_BUSY__SHIFT                                                                     0x15
#define CP_STAT__DMA_BUSY__SHIFT                                                                              0x16
#define CP_STAT__RCIU_BUSY__SHIFT                                                                             0x17
#define CP_STAT__SCRATCH_RAM_BUSY__SHIFT                                                                      0x18
#define CP_STAT__GCRIU_BUSY__SHIFT                                                                            0x19
#define CP_STAT__CE_BUSY__SHIFT                                                                               0x1a
#define CP_STAT__TCIU_BUSY__SHIFT                                                                             0x1b
#define CP_STAT__ROQ_CE_RING_BUSY__SHIFT                                                                      0x1c
#define CP_STAT__ROQ_CE_INDIRECT1_BUSY__SHIFT                                                                 0x1d
#define CP_STAT__ROQ_CE_INDIRECT2_BUSY__SHIFT                                                                 0x1e
#define CP_STAT__CP_BUSY__SHIFT                                                                               0x1f
#define CP_STAT__ROQ_DB_BUSY_MASK                                                                             0x00000020L
#define CP_STAT__ROQ_CE_DB_BUSY_MASK                                                                          0x00000040L
#define CP_STAT__ROQ_RING_BUSY_MASK                                                                           0x00000200L
#define CP_STAT__ROQ_INDIRECT1_BUSY_MASK                                                                      0x00000400L
#define CP_STAT__ROQ_INDIRECT2_BUSY_MASK                                                                      0x00000800L
#define CP_STAT__ROQ_STATE_BUSY_MASK                                                                          0x00001000L
#define CP_STAT__DC_BUSY_MASK                                                                                 0x00002000L
#define CP_STAT__UTCL2IU_BUSY_MASK                                                                            0x00004000L
#define CP_STAT__PFP_BUSY_MASK                                                                                0x00008000L
#define CP_STAT__MEQ_BUSY_MASK                                                                                0x00010000L
#define CP_STAT__ME_BUSY_MASK                                                                                 0x00020000L
#define CP_STAT__QUERY_BUSY_MASK                                                                              0x00040000L
#define CP_STAT__SEMAPHORE_BUSY_MASK                                                                          0x00080000L
#define CP_STAT__INTERRUPT_BUSY_MASK                                                                          0x00100000L
#define CP_STAT__SURFACE_SYNC_BUSY_MASK                                                                       0x00200000L
#define CP_STAT__DMA_BUSY_MASK                                                                                0x00400000L
#define CP_STAT__RCIU_BUSY_MASK                                                                               0x00800000L
#define CP_STAT__SCRATCH_RAM_BUSY_MASK                                                                        0x01000000L
#define CP_STAT__GCRIU_BUSY_MASK                                                                              0x02000000L
#define CP_STAT__CE_BUSY_MASK                                                                                 0x04000000L
#define CP_STAT__TCIU_BUSY_MASK                                                                               0x08000000L
#define CP_STAT__ROQ_CE_RING_BUSY_MASK                                                                        0x10000000L
#define CP_STAT__ROQ_CE_INDIRECT1_BUSY_MASK                                                                   0x20000000L
#define CP_STAT__ROQ_CE_INDIRECT2_BUSY_MASK                                                                   0x40000000L
#define CP_STAT__CP_BUSY_MASK                                                                                 0x80000000L
//CP_ME_HEADER_DUMP
#define CP_ME_HEADER_DUMP__ME_HEADER_DUMP__SHIFT                                                              0x0
#define CP_ME_HEADER_DUMP__ME_HEADER_DUMP_MASK                                                                0xFFFFFFFFL
//CP_PFP_HEADER_DUMP
#define CP_PFP_HEADER_DUMP__PFP_HEADER_DUMP__SHIFT                                                            0x0
#define CP_PFP_HEADER_DUMP__PFP_HEADER_DUMP_MASK                                                              0xFFFFFFFFL
//CP_GRBM_FREE_COUNT
#define CP_GRBM_FREE_COUNT__FREE_COUNT__SHIFT                                                                 0x0
#define CP_GRBM_FREE_COUNT__FREE_COUNT_GDS__SHIFT                                                             0x8
#define CP_GRBM_FREE_COUNT__FREE_COUNT_PFP__SHIFT                                                             0x10
#define CP_GRBM_FREE_COUNT__FREE_COUNT_MASK                                                                   0x0000003FL
#define CP_GRBM_FREE_COUNT__FREE_COUNT_GDS_MASK                                                               0x00003F00L
#define CP_GRBM_FREE_COUNT__FREE_COUNT_PFP_MASK                                                               0x003F0000L
//CP_CE_HEADER_DUMP
#define CP_CE_HEADER_DUMP__CE_HEADER_DUMP__SHIFT                                                              0x0
#define CP_CE_HEADER_DUMP__CE_HEADER_DUMP_MASK                                                                0xFFFFFFFFL
//CP_PFP_INSTR_PNTR
#define CP_PFP_INSTR_PNTR__INSTR_PNTR__SHIFT                                                                  0x0
#define CP_PFP_INSTR_PNTR__INSTR_PNTR_MASK                                                                    0x0000FFFFL
//CP_ME_INSTR_PNTR
#define CP_ME_INSTR_PNTR__INSTR_PNTR__SHIFT                                                                   0x0
#define CP_ME_INSTR_PNTR__INSTR_PNTR_MASK                                                                     0x0000FFFFL
//CP_CE_INSTR_PNTR
#define CP_CE_INSTR_PNTR__INSTR_PNTR__SHIFT                                                                   0x0
#define CP_CE_INSTR_PNTR__INSTR_PNTR_MASK                                                                     0x0000FFFFL
//CP_MEC1_INSTR_PNTR
#define CP_MEC1_INSTR_PNTR__INSTR_PNTR__SHIFT                                                                 0x0
#define CP_MEC1_INSTR_PNTR__INSTR_PNTR_MASK                                                                   0x0000FFFFL
//CP_MEC2_INSTR_PNTR
#define CP_MEC2_INSTR_PNTR__INSTR_PNTR__SHIFT                                                                 0x0
#define CP_MEC2_INSTR_PNTR__INSTR_PNTR_MASK                                                                   0x0000FFFFL
//CP_CSF_STAT
#define CP_CSF_STAT__BUFFER_REQUEST_COUNT__SHIFT                                                              0x8
#define CP_CSF_STAT__BUFFER_REQUEST_COUNT_MASK                                                                0x0001FF00L
//CP_MEC_CNTL
#define CP_MEC_CNTL__MEC_ME1_PIPE0_RESET__SHIFT                                                               0x10
#define CP_MEC_CNTL__MEC_ME1_PIPE1_RESET__SHIFT                                                               0x11
#define CP_MEC_CNTL__MEC_ME1_PIPE2_RESET__SHIFT                                                               0x12
#define CP_MEC_CNTL__MEC_ME1_PIPE3_RESET__SHIFT                                                               0x13
#define CP_MEC_CNTL__MEC_ME2_PIPE0_RESET__SHIFT                                                               0x14
#define CP_MEC_CNTL__MEC_ME2_PIPE1_RESET__SHIFT                                                               0x15
#define CP_MEC_CNTL__MEC_ME2_PIPE2_RESET__SHIFT                                                               0x16
#define CP_MEC_CNTL__MEC_ME2_PIPE3_RESET__SHIFT                                                               0x17
#define CP_MEC_CNTL__MEC_INVALIDATE_ICACHE__SHIFT                                                             0x1b
#define CP_MEC_CNTL__MEC_ME2_HALT__SHIFT                                                                      0x1c
#define CP_MEC_CNTL__MEC_ME2_STEP__SHIFT                                                                      0x1d
#define CP_MEC_CNTL__MEC_ME1_HALT__SHIFT                                                                      0x1e
#define CP_MEC_CNTL__MEC_ME1_STEP__SHIFT                                                                      0x1f
#define CP_MEC_CNTL__MEC_ME1_PIPE0_RESET_MASK                                                                 0x00010000L
#define CP_MEC_CNTL__MEC_ME1_PIPE1_RESET_MASK                                                                 0x00020000L
#define CP_MEC_CNTL__MEC_ME1_PIPE2_RESET_MASK                                                                 0x00040000L
#define CP_MEC_CNTL__MEC_ME1_PIPE3_RESET_MASK                                                                 0x00080000L
#define CP_MEC_CNTL__MEC_ME2_PIPE0_RESET_MASK                                                                 0x00100000L
#define CP_MEC_CNTL__MEC_ME2_PIPE1_RESET_MASK                                                                 0x00200000L
#define CP_MEC_CNTL__MEC_ME2_PIPE2_RESET_MASK                                                                 0x00400000L
#define CP_MEC_CNTL__MEC_ME2_PIPE3_RESET_MASK                                                                 0x00800000L
#define CP_MEC_CNTL__MEC_INVALIDATE_ICACHE_MASK                                                               0x08000000L
#define CP_MEC_CNTL__MEC_ME2_HALT_MASK                                                                        0x10000000L
#define CP_MEC_CNTL__MEC_ME2_STEP_MASK                                                                        0x20000000L
#define CP_MEC_CNTL__MEC_ME1_HALT_MASK                                                                        0x40000000L
#define CP_MEC_CNTL__MEC_ME1_STEP_MASK                                                                        0x80000000L
//CP_ME_CNTL
#define CP_ME_CNTL__CE_INVALIDATE_ICACHE__SHIFT                                                               0x4
#define CP_ME_CNTL__PFP_INVALIDATE_ICACHE__SHIFT                                                              0x6
#define CP_ME_CNTL__ME_INVALIDATE_ICACHE__SHIFT                                                               0x8
#define CP_ME_CNTL__CE_PIPE0_RESET__SHIFT                                                                     0x10
#define CP_ME_CNTL__CE_PIPE1_RESET__SHIFT                                                                     0x11
#define CP_ME_CNTL__PFP_PIPE0_RESET__SHIFT                                                                    0x12
#define CP_ME_CNTL__PFP_PIPE1_RESET__SHIFT                                                                    0x13
#define CP_ME_CNTL__ME_PIPE0_RESET__SHIFT                                                                     0x14
#define CP_ME_CNTL__ME_PIPE1_RESET__SHIFT                                                                     0x15
#define CP_ME_CNTL__CE_HALT__SHIFT                                                                            0x18
#define CP_ME_CNTL__CE_STEP__SHIFT                                                                            0x19
#define CP_ME_CNTL__PFP_HALT__SHIFT                                                                           0x1a
#define CP_ME_CNTL__PFP_STEP__SHIFT                                                                           0x1b
#define CP_ME_CNTL__ME_HALT__SHIFT                                                                            0x1c
#define CP_ME_CNTL__ME_STEP__SHIFT                                                                            0x1d
#define CP_ME_CNTL__CE_INVALIDATE_ICACHE_MASK                                                                 0x00000010L
#define CP_ME_CNTL__PFP_INVALIDATE_ICACHE_MASK                                                                0x00000040L
#define CP_ME_CNTL__ME_INVALIDATE_ICACHE_MASK                                                                 0x00000100L
#define CP_ME_CNTL__CE_PIPE0_RESET_MASK                                                                       0x00010000L
#define CP_ME_CNTL__CE_PIPE1_RESET_MASK                                                                       0x00020000L
#define CP_ME_CNTL__PFP_PIPE0_RESET_MASK                                                                      0x00040000L
#define CP_ME_CNTL__PFP_PIPE1_RESET_MASK                                                                      0x00080000L
#define CP_ME_CNTL__ME_PIPE0_RESET_MASK                                                                       0x00100000L
#define CP_ME_CNTL__ME_PIPE1_RESET_MASK                                                                       0x00200000L
#define CP_ME_CNTL__CE_HALT_MASK                                                                              0x01000000L
#define CP_ME_CNTL__CE_STEP_MASK                                                                              0x02000000L
#define CP_ME_CNTL__PFP_HALT_MASK                                                                             0x04000000L
#define CP_ME_CNTL__PFP_STEP_MASK                                                                             0x08000000L
#define CP_ME_CNTL__ME_HALT_MASK                                                                              0x10000000L
#define CP_ME_CNTL__ME_STEP_MASK                                                                              0x20000000L
//CP_CNTX_STAT
#define CP_CNTX_STAT__ACTIVE_HP3D_CONTEXTS__SHIFT                                                             0x0
#define CP_CNTX_STAT__CURRENT_HP3D_CONTEXT__SHIFT                                                             0x8
#define CP_CNTX_STAT__ACTIVE_GFX_CONTEXTS__SHIFT                                                              0x14
#define CP_CNTX_STAT__CURRENT_GFX_CONTEXT__SHIFT                                                              0x1c
#define CP_CNTX_STAT__ACTIVE_HP3D_CONTEXTS_MASK                                                               0x000000FFL
#define CP_CNTX_STAT__CURRENT_HP3D_CONTEXT_MASK                                                               0x00000700L
#define CP_CNTX_STAT__ACTIVE_GFX_CONTEXTS_MASK                                                                0x0FF00000L
#define CP_CNTX_STAT__CURRENT_GFX_CONTEXT_MASK                                                                0x70000000L
//CP_ME_PREEMPTION
#define CP_ME_PREEMPTION__OBSOLETE__SHIFT                                                                     0x0
#define CP_ME_PREEMPTION__OBSOLETE_MASK                                                                       0x00000001L
//CP_ROQ_THRESHOLDS
#define CP_ROQ_THRESHOLDS__IB1_START__SHIFT                                                                   0x0
#define CP_ROQ_THRESHOLDS__IB2_START__SHIFT                                                                   0x8
#define CP_ROQ_THRESHOLDS__IB1_START_MASK                                                                     0x000000FFL
#define CP_ROQ_THRESHOLDS__IB2_START_MASK                                                                     0x0000FF00L
//CP_MEQ_STQ_THRESHOLD
#define CP_MEQ_STQ_THRESHOLD__STQ_START__SHIFT                                                                0x0
#define CP_MEQ_STQ_THRESHOLD__STQ_START_MASK                                                                  0x000000FFL
//CP_RB2_RPTR
#define CP_RB2_RPTR__RB_RPTR__SHIFT                                                                           0x0
#define CP_RB2_RPTR__RB_RPTR_MASK                                                                             0x000FFFFFL
//CP_RB1_RPTR
#define CP_RB1_RPTR__RB_RPTR__SHIFT                                                                           0x0
#define CP_RB1_RPTR__RB_RPTR_MASK                                                                             0x000FFFFFL
//CP_RB0_RPTR
#define CP_RB0_RPTR__RB_RPTR__SHIFT                                                                           0x0
#define CP_RB0_RPTR__RB_RPTR_MASK                                                                             0x000FFFFFL
//CP_RB_RPTR
#define CP_RB_RPTR__RB_RPTR__SHIFT                                                                            0x0
#define CP_RB_RPTR__RB_RPTR_MASK                                                                              0x000FFFFFL
//CP_RB_WPTR_DELAY
#define CP_RB_WPTR_DELAY__PRE_WRITE_TIMER__SHIFT                                                              0x0
#define CP_RB_WPTR_DELAY__PRE_WRITE_LIMIT__SHIFT                                                              0x1c
#define CP_RB_WPTR_DELAY__PRE_WRITE_TIMER_MASK                                                                0x0FFFFFFFL
#define CP_RB_WPTR_DELAY__PRE_WRITE_LIMIT_MASK                                                                0xF0000000L
//CP_RB_WPTR_POLL_CNTL
#define CP_RB_WPTR_POLL_CNTL__POLL_FREQUENCY__SHIFT                                                           0x0
#define CP_RB_WPTR_POLL_CNTL__IDLE_POLL_COUNT__SHIFT                                                          0x10
#define CP_RB_WPTR_POLL_CNTL__POLL_FREQUENCY_MASK                                                             0x0000FFFFL
#define CP_RB_WPTR_POLL_CNTL__IDLE_POLL_COUNT_MASK                                                            0xFFFF0000L
//CP_ROQ1_THRESHOLDS
#define CP_ROQ1_THRESHOLDS__RB1_START__SHIFT                                                                  0x0
#define CP_ROQ1_THRESHOLDS__R0_IB1_START__SHIFT                                                               0xa
#define CP_ROQ1_THRESHOLDS__R1_IB1_START__SHIFT                                                               0x14
#define CP_ROQ1_THRESHOLDS__RB1_START_MASK                                                                    0x000003FFL
#define CP_ROQ1_THRESHOLDS__R0_IB1_START_MASK                                                                 0x000FFC00L
#define CP_ROQ1_THRESHOLDS__R1_IB1_START_MASK                                                                 0x3FF00000L
//CP_ROQ2_THRESHOLDS
#define CP_ROQ2_THRESHOLDS__R0_IB2_START__SHIFT                                                               0x0
#define CP_ROQ2_THRESHOLDS__R1_IB2_START__SHIFT                                                               0xa
#define CP_ROQ2_THRESHOLDS__R0_IB2_START_MASK                                                                 0x000003FFL
#define CP_ROQ2_THRESHOLDS__R1_IB2_START_MASK                                                                 0x000FFC00L
//CP_STQ_THRESHOLDS
#define CP_STQ_THRESHOLDS__STQ0_START__SHIFT                                                                  0x0
#define CP_STQ_THRESHOLDS__STQ1_START__SHIFT                                                                  0x8
#define CP_STQ_THRESHOLDS__STQ2_START__SHIFT                                                                  0x10
#define CP_STQ_THRESHOLDS__STQ0_START_MASK                                                                    0x000000FFL
#define CP_STQ_THRESHOLDS__STQ1_START_MASK                                                                    0x0000FF00L
#define CP_STQ_THRESHOLDS__STQ2_START_MASK                                                                    0x00FF0000L
//CP_QUEUE_THRESHOLDS
#define CP_QUEUE_THRESHOLDS__ROQ_IB1_START__SHIFT                                                             0x0
#define CP_QUEUE_THRESHOLDS__ROQ_IB2_START__SHIFT                                                             0x8
#define CP_QUEUE_THRESHOLDS__ROQ_IB1_START_MASK                                                               0x0000003FL
#define CP_QUEUE_THRESHOLDS__ROQ_IB2_START_MASK                                                               0x00003F00L
//CP_MEQ_THRESHOLDS
#define CP_MEQ_THRESHOLDS__MEQ1_START__SHIFT                                                                  0x0
#define CP_MEQ_THRESHOLDS__MEQ2_START__SHIFT                                                                  0x8
#define CP_MEQ_THRESHOLDS__MEQ1_START_MASK                                                                    0x000000FFL
#define CP_MEQ_THRESHOLDS__MEQ2_START_MASK                                                                    0x0000FF00L
//CP_ROQ_AVAIL
#define CP_ROQ_AVAIL__ROQ_CNT_RING__SHIFT                                                                     0x0
#define CP_ROQ_AVAIL__ROQ_CNT_IB1__SHIFT                                                                      0x10
#define CP_ROQ_AVAIL__ROQ_CNT_RING_MASK                                                                       0x00000FFFL
#define CP_ROQ_AVAIL__ROQ_CNT_IB1_MASK                                                                        0x0FFF0000L
//CP_STQ_AVAIL
#define CP_STQ_AVAIL__STQ_CNT__SHIFT                                                                          0x0
#define CP_STQ_AVAIL__STQ_CNT_MASK                                                                            0x000001FFL
//CP_ROQ2_AVAIL
#define CP_ROQ2_AVAIL__ROQ_CNT_IB2__SHIFT                                                                     0x0
#define CP_ROQ2_AVAIL__ROQ_CNT_DB__SHIFT                                                                      0x10
#define CP_ROQ2_AVAIL__ROQ_CNT_IB2_MASK                                                                       0x00000FFFL
#define CP_ROQ2_AVAIL__ROQ_CNT_DB_MASK                                                                        0x0FFF0000L
//CP_MEQ_AVAIL
#define CP_MEQ_AVAIL__MEQ_CNT__SHIFT                                                                          0x0
#define CP_MEQ_AVAIL__MEQ_CNT_MASK                                                                            0x000003FFL
//CP_CMD_INDEX
#define CP_CMD_INDEX__CMD_INDEX__SHIFT                                                                        0x0
#define CP_CMD_INDEX__CMD_ME_SEL__SHIFT                                                                       0xc
#define CP_CMD_INDEX__CMD_QUEUE_SEL__SHIFT                                                                    0x10
#define CP_CMD_INDEX__CMD_INDEX_MASK                                                                          0x000007FFL
#define CP_CMD_INDEX__CMD_ME_SEL_MASK                                                                         0x00003000L
#define CP_CMD_INDEX__CMD_QUEUE_SEL_MASK                                                                      0x00070000L
//CP_CMD_DATA
#define CP_CMD_DATA__CMD_DATA__SHIFT                                                                          0x0
#define CP_CMD_DATA__CMD_DATA_MASK                                                                            0xFFFFFFFFL
//CP_ROQ_RB_STAT
#define CP_ROQ_RB_STAT__ROQ_RPTR_PRIMARY__SHIFT                                                               0x0
#define CP_ROQ_RB_STAT__ROQ_WPTR_PRIMARY__SHIFT                                                               0x10
#define CP_ROQ_RB_STAT__ROQ_RPTR_PRIMARY_MASK                                                                 0x00000FFFL
#define CP_ROQ_RB_STAT__ROQ_WPTR_PRIMARY_MASK                                                                 0x0FFF0000L
//CP_ROQ_IB1_STAT
#define CP_ROQ_IB1_STAT__ROQ_RPTR_INDIRECT1__SHIFT                                                            0x0
#define CP_ROQ_IB1_STAT__ROQ_WPTR_INDIRECT1__SHIFT                                                            0x10
#define CP_ROQ_IB1_STAT__ROQ_RPTR_INDIRECT1_MASK                                                              0x00000FFFL
#define CP_ROQ_IB1_STAT__ROQ_WPTR_INDIRECT1_MASK                                                              0x0FFF0000L
//CP_ROQ_IB2_STAT
#define CP_ROQ_IB2_STAT__ROQ_RPTR_INDIRECT2__SHIFT                                                            0x0
#define CP_ROQ_IB2_STAT__ROQ_WPTR_INDIRECT2__SHIFT                                                            0x10
#define CP_ROQ_IB2_STAT__ROQ_RPTR_INDIRECT2_MASK                                                              0x00000FFFL
#define CP_ROQ_IB2_STAT__ROQ_WPTR_INDIRECT2_MASK                                                              0x0FFF0000L
//CP_STQ_STAT
#define CP_STQ_STAT__STQ_RPTR__SHIFT                                                                          0x0
#define CP_STQ_STAT__STQ_RPTR_MASK                                                                            0x000003FFL
//CP_STQ_WR_STAT
#define CP_STQ_WR_STAT__STQ_WPTR__SHIFT                                                                       0x0
#define CP_STQ_WR_STAT__STQ_WPTR_MASK                                                                         0x000003FFL
//CP_MEQ_STAT
#define CP_MEQ_STAT__MEQ_RPTR__SHIFT                                                                          0x0
#define CP_MEQ_STAT__MEQ_WPTR__SHIFT                                                                          0x10
#define CP_MEQ_STAT__MEQ_RPTR_MASK                                                                            0x000003FFL
#define CP_MEQ_STAT__MEQ_WPTR_MASK                                                                            0x03FF0000L
//CP_CEQ1_AVAIL
#define CP_CEQ1_AVAIL__CEQ_CNT_RING__SHIFT                                                                    0x0
#define CP_CEQ1_AVAIL__CEQ_CNT_IB1__SHIFT                                                                     0x10
#define CP_CEQ1_AVAIL__CEQ_CNT_RING_MASK                                                                      0x00000FFFL
#define CP_CEQ1_AVAIL__CEQ_CNT_IB1_MASK                                                                       0x0FFF0000L
//CP_CEQ2_AVAIL
#define CP_CEQ2_AVAIL__CEQ_CNT_IB2__SHIFT                                                                     0x0
#define CP_CEQ2_AVAIL__CEQ_CNT_DB__SHIFT                                                                      0x10
#define CP_CEQ2_AVAIL__CEQ_CNT_IB2_MASK                                                                       0x00000FFFL
#define CP_CEQ2_AVAIL__CEQ_CNT_DB_MASK                                                                        0x0FFF0000L
//CP_CE_ROQ_RB_STAT
#define CP_CE_ROQ_RB_STAT__CEQ_RPTR_PRIMARY__SHIFT                                                            0x0
#define CP_CE_ROQ_RB_STAT__CEQ_WPTR_PRIMARY__SHIFT                                                            0x10
#define CP_CE_ROQ_RB_STAT__CEQ_RPTR_PRIMARY_MASK                                                              0x00000FFFL
#define CP_CE_ROQ_RB_STAT__CEQ_WPTR_PRIMARY_MASK                                                              0x0FFF0000L
//CP_CE_ROQ_IB1_STAT
#define CP_CE_ROQ_IB1_STAT__CEQ_RPTR_INDIRECT1__SHIFT                                                         0x0
#define CP_CE_ROQ_IB1_STAT__CEQ_WPTR_INDIRECT1__SHIFT                                                         0x10
#define CP_CE_ROQ_IB1_STAT__CEQ_RPTR_INDIRECT1_MASK                                                           0x00000FFFL
#define CP_CE_ROQ_IB1_STAT__CEQ_WPTR_INDIRECT1_MASK                                                           0x0FFF0000L
//CP_CE_ROQ_IB2_STAT
#define CP_CE_ROQ_IB2_STAT__CEQ_RPTR_INDIRECT2__SHIFT                                                         0x0
#define CP_CE_ROQ_IB2_STAT__CEQ_WPTR_INDIRECT2__SHIFT                                                         0x10
#define CP_CE_ROQ_IB2_STAT__CEQ_RPTR_INDIRECT2_MASK                                                           0x00000FFFL
#define CP_CE_ROQ_IB2_STAT__CEQ_WPTR_INDIRECT2_MASK                                                           0x0FFF0000L
//CP_CE_ROQ_DB_STAT
#define CP_CE_ROQ_DB_STAT__CEQ_RPTR_DB__SHIFT                                                                 0x0
#define CP_CE_ROQ_DB_STAT__CEQ_WPTR_DB__SHIFT                                                                 0x10
#define CP_CE_ROQ_DB_STAT__CEQ_RPTR_DB_MASK                                                                   0x00000FFFL
#define CP_CE_ROQ_DB_STAT__CEQ_WPTR_DB_MASK                                                                   0x0FFF0000L
//CP_ROQ3_THRESHOLDS
#define CP_ROQ3_THRESHOLDS__R0_DB_START__SHIFT                                                                0x0
#define CP_ROQ3_THRESHOLDS__R1_DB_START__SHIFT                                                                0xa
#define CP_ROQ3_THRESHOLDS__R0_DB_START_MASK                                                                  0x000003FFL
#define CP_ROQ3_THRESHOLDS__R1_DB_START_MASK                                                                  0x000FFC00L
//CP_ROQ_DB_STAT
#define CP_ROQ_DB_STAT__ROQ_RPTR_DB__SHIFT                                                                    0x0
#define CP_ROQ_DB_STAT__ROQ_WPTR_DB__SHIFT                                                                    0x10
#define CP_ROQ_DB_STAT__ROQ_RPTR_DB_MASK                                                                      0x00000FFFL
#define CP_ROQ_DB_STAT__ROQ_WPTR_DB_MASK                                                                      0x0FFF0000L
#define CP_INT_STAT_DEBUG__PRIV_INSTR_INT_ASSERTED__SHIFT                                                     0x16
#define CP_INT_STAT_DEBUG__PRIV_REG_INT_ASSERTED__SHIFT                                                       0x17
#define CP_INT_STAT_DEBUG__PRIV_INSTR_INT_ASSERTED_MASK                                                       0x00400000L
#define CP_INT_STAT_DEBUG__PRIV_REG_INT_ASSERTED_MASK                                                         0x00800000L
//CP_PRIV_VIOLATION_ADDR
#define CP_PRIV_VIOLATION_ADDR__PRIV_VIOLATION_ADDR__SHIFT                                                    0x0
#define CP_PRIV_VIOLATION_ADDR__PRIV_VIOLATION_ADDR_MASK                                                      0x0000FFFFL


// addressBlock: gc_padec
//VGT_CACHE_INVALIDATION
#define VGT_CACHE_INVALIDATION__CACHE_INVALIDATION__SHIFT                                                     0x0
#define VGT_CACHE_INVALIDATION__DIS_INSTANCING_OPT__SHIFT                                                     0x4
#define VGT_CACHE_INVALIDATION__VS_NO_EXTRA_BUFFER__SHIFT                                                     0x5
#define VGT_CACHE_INVALIDATION__AUTO_INVLD_EN__SHIFT                                                          0x6
#define VGT_CACHE_INVALIDATION__USE_GS_DONE__SHIFT                                                            0x9
#define VGT_CACHE_INVALIDATION__DIS_RANGE_FULL_INVLD__SHIFT                                                   0xb
#define VGT_CACHE_INVALIDATION__GS_LATE_ALLOC_EN__SHIFT                                                       0xc
#define VGT_CACHE_INVALIDATION__STREAMOUT_FULL_FLUSH__SHIFT                                                   0xd
#define VGT_CACHE_INVALIDATION__ES_LIMIT__SHIFT                                                               0x10
#define VGT_CACHE_INVALIDATION__ENABLE_PING_PONG__SHIFT                                                       0x15
#define VGT_CACHE_INVALIDATION__OPT_FLOW_CNTL_1__SHIFT                                                        0x16
#define VGT_CACHE_INVALIDATION__OPT_FLOW_CNTL_2__SHIFT                                                        0x19
#define VGT_CACHE_INVALIDATION__EN_WAVE_MERGE__SHIFT                                                          0x1c
#define VGT_CACHE_INVALIDATION__ENABLE_PING_PONG_EOI__SHIFT                                                   0x1d
#define VGT_CACHE_INVALIDATION__CACHE_INVALIDATION_MASK                                                       0x00000003L
#define VGT_CACHE_INVALIDATION__DIS_INSTANCING_OPT_MASK                                                       0x00000010L
#define VGT_CACHE_INVALIDATION__VS_NO_EXTRA_BUFFER_MASK                                                       0x00000020L
#define VGT_CACHE_INVALIDATION__AUTO_INVLD_EN_MASK                                                            0x000000C0L
#define VGT_CACHE_INVALIDATION__USE_GS_DONE_MASK                                                              0x00000200L
#define VGT_CACHE_INVALIDATION__DIS_RANGE_FULL_INVLD_MASK                                                     0x00000800L
#define VGT_CACHE_INVALIDATION__GS_LATE_ALLOC_EN_MASK                                                         0x00001000L
#define VGT_CACHE_INVALIDATION__STREAMOUT_FULL_FLUSH_MASK                                                     0x00002000L
#define VGT_CACHE_INVALIDATION__ES_LIMIT_MASK                                                                 0x001F0000L
#define VGT_CACHE_INVALIDATION__ENABLE_PING_PONG_MASK                                                         0x00200000L
#define VGT_CACHE_INVALIDATION__OPT_FLOW_CNTL_1_MASK                                                          0x01C00000L
#define VGT_CACHE_INVALIDATION__OPT_FLOW_CNTL_2_MASK                                                          0x0E000000L
#define VGT_CACHE_INVALIDATION__EN_WAVE_MERGE_MASK                                                            0x10000000L
#define VGT_CACHE_INVALIDATION__ENABLE_PING_PONG_EOI_MASK                                                     0x20000000L
//VGT_ESGS_RING_SIZE
#define VGT_ESGS_RING_SIZE__MEM_SIZE__SHIFT                                                                   0x0
#define VGT_ESGS_RING_SIZE__MEM_SIZE_MASK                                                                     0xFFFFFFFFL
//VGT_GSVS_RING_SIZE
#define VGT_GSVS_RING_SIZE__MEM_SIZE__SHIFT                                                                   0x0
#define VGT_GSVS_RING_SIZE__MEM_SIZE_MASK                                                                     0xFFFFFFFFL
//VGT_TF_RING_SIZE
#define VGT_TF_RING_SIZE__SIZE__SHIFT                                                                         0x0
#define VGT_TF_RING_SIZE__SIZE_MASK                                                                           0x0000FFFFL
//VGT_HS_OFFCHIP_PARAM
#define VGT_HS_OFFCHIP_PARAM__OFFCHIP_BUFFERING__SHIFT                                                        0x0
#define VGT_HS_OFFCHIP_PARAM__OFFCHIP_GRANULARITY__SHIFT                                                      0xa
#define VGT_HS_OFFCHIP_PARAM__OFFCHIP_BUFFERING_MASK                                                          0x000003FFL
#define VGT_HS_OFFCHIP_PARAM__OFFCHIP_GRANULARITY_MASK                                                        0x00000C00L
//VGT_TF_MEMORY_BASE
#define VGT_TF_MEMORY_BASE__BASE__SHIFT                                                                       0x0
#define VGT_TF_MEMORY_BASE__BASE_MASK                                                                         0xFFFFFFFFL
//VGT_TF_MEMORY_BASE_HI
#define VGT_TF_MEMORY_BASE_HI__BASE_HI__SHIFT                                                                 0x0
#define VGT_TF_MEMORY_BASE_HI__BASE_HI_MASK                                                                   0x000000FFL
//VGT_VTX_VECT_EJECT_REG
#define VGT_VTX_VECT_EJECT_REG__PRIM_COUNT__SHIFT                                                             0x0
#define VGT_VTX_VECT_EJECT_REG__PRIM_COUNT_MASK                                                               0x000003FFL
//VGT_DMA_DATA_FIFO_DEPTH
#define VGT_DMA_DATA_FIFO_DEPTH__DMA_DATA_FIFO_DEPTH__SHIFT                                                   0x0
#define VGT_DMA_DATA_FIFO_DEPTH__DMA_DATA_FIFO_DEPTH_MASK                                                     0x000003FFL
//VGT_DMA_REQ_FIFO_DEPTH
#define VGT_DMA_REQ_FIFO_DEPTH__DMA_REQ_FIFO_DEPTH__SHIFT                                                     0x0
#define VGT_DMA_REQ_FIFO_DEPTH__DMA_REQ_FIFO_DEPTH_MASK                                                       0x0000003FL
//VGT_DRAW_INIT_FIFO_DEPTH
#define VGT_DRAW_INIT_FIFO_DEPTH__DRAW_INIT_FIFO_DEPTH__SHIFT                                                 0x0
#define VGT_DRAW_INIT_FIFO_DEPTH__DRAW_INIT_FIFO_DEPTH_MASK                                                   0x0000003FL
//VGT_LAST_COPY_STATE
#define VGT_LAST_COPY_STATE__SRC_STATE_ID__SHIFT                                                              0x0
#define VGT_LAST_COPY_STATE__DST_STATE_ID__SHIFT                                                              0x10
#define VGT_LAST_COPY_STATE__SRC_STATE_ID_MASK                                                                0x00000007L
#define VGT_LAST_COPY_STATE__DST_STATE_ID_MASK                                                                0x00070000L
//VGT_FIFO_DEPTHS
#define VGT_FIFO_DEPTHS__VS_DEALLOC_TBL_DEPTH__SHIFT                                                          0x0
#define VGT_FIFO_DEPTHS__RESERVED_0__SHIFT                                                                    0x7
#define VGT_FIFO_DEPTHS__CLIPP_FIFO_DEPTH__SHIFT                                                              0x8
#define VGT_FIFO_DEPTHS__RESERVED_1__SHIFT                                                                    0x16
#define VGT_FIFO_DEPTHS__HSINPUT_FIFO_DEPTH__SHIFT                                                            0x17
#define VGT_FIFO_DEPTHS__VS_DEALLOC_TBL_DEPTH_MASK                                                            0x0000007FL
#define VGT_FIFO_DEPTHS__RESERVED_0_MASK                                                                      0x00000080L
#define VGT_FIFO_DEPTHS__CLIPP_FIFO_DEPTH_MASK                                                                0x003FFF00L
#define VGT_FIFO_DEPTHS__RESERVED_1_MASK                                                                      0x00400000L
#define VGT_FIFO_DEPTHS__HSINPUT_FIFO_DEPTH_MASK                                                              0x1F800000L
//VGT_GS_VERTEX_REUSE
#define VGT_GS_VERTEX_REUSE__VERT_REUSE__SHIFT                                                                0x0
#define VGT_GS_VERTEX_REUSE__VERT_REUSE_MASK                                                                  0x0000001FL
//VGT_MC_LAT_CNTL
#define VGT_MC_LAT_CNTL__MC_TIME_STAMP_RES__SHIFT                                                             0x0
#define VGT_MC_LAT_CNTL__MC_TIME_STAMP_RES_MASK                                                               0x0000000FL
//IA_UTCL1_STATUS_2
#define IA_UTCL1_STATUS_2__IA_BUSY__SHIFT                                                                     0x0
#define IA_UTCL1_STATUS_2__IA_DMA_BUSY__SHIFT                                                                 0x1
#define IA_UTCL1_STATUS_2__IA_DMA_REQ_BUSY__SHIFT                                                             0x2
#define IA_UTCL1_STATUS_2__IA_GRP_BUSY__SHIFT                                                                 0x3
#define IA_UTCL1_STATUS_2__IA_ADC_BUSY__SHIFT                                                                 0x4
#define IA_UTCL1_STATUS_2__FAULT_DETECTED__SHIFT                                                              0x5
#define IA_UTCL1_STATUS_2__RETRY_DETECTED__SHIFT                                                              0x6
#define IA_UTCL1_STATUS_2__PRT_DETECTED__SHIFT                                                                0x7
#define IA_UTCL1_STATUS_2__FAULT_UTCL1ID__SHIFT                                                               0x8
#define IA_UTCL1_STATUS_2__RETRY_UTCL1ID__SHIFT                                                               0x10
#define IA_UTCL1_STATUS_2__PRT_UTCL1ID__SHIFT                                                                 0x18
#define IA_UTCL1_STATUS_2__IA_BUSY_MASK                                                                       0x00000001L
#define IA_UTCL1_STATUS_2__IA_DMA_BUSY_MASK                                                                   0x00000002L
#define IA_UTCL1_STATUS_2__IA_DMA_REQ_BUSY_MASK                                                               0x00000004L
#define IA_UTCL1_STATUS_2__IA_GRP_BUSY_MASK                                                                   0x00000008L
#define IA_UTCL1_STATUS_2__IA_ADC_BUSY_MASK                                                                   0x00000010L
#define IA_UTCL1_STATUS_2__FAULT_DETECTED_MASK                                                                0x00000020L
#define IA_UTCL1_STATUS_2__RETRY_DETECTED_MASK                                                                0x00000040L
#define IA_UTCL1_STATUS_2__PRT_DETECTED_MASK                                                                  0x00000080L
#define IA_UTCL1_STATUS_2__FAULT_UTCL1ID_MASK                                                                 0x00003F00L
#define IA_UTCL1_STATUS_2__RETRY_UTCL1ID_MASK                                                                 0x003F0000L
#define IA_UTCL1_STATUS_2__PRT_UTCL1ID_MASK                                                                   0x3F000000L
//WD_CNTL_STATUS
#define WD_CNTL_STATUS__VR3_BUSY__SHIFT                                                                       0x0
#define WD_CNTL_STATUS__VR2_BUSY__SHIFT                                                                       0x1
#define WD_CNTL_STATUS__VR1_BUSY__SHIFT                                                                       0x2
#define WD_CNTL_STATUS__VR0_BUSY__SHIFT                                                                       0x3
#define WD_CNTL_STATUS__HS3_BUSY__SHIFT                                                                       0x4
#define WD_CNTL_STATUS__HS2_BUSY__SHIFT                                                                       0x5
#define WD_CNTL_STATUS__HS1_BUSY__SHIFT                                                                       0x6
#define WD_CNTL_STATUS__HS0_BUSY__SHIFT                                                                       0x7
#define WD_CNTL_STATUS__GS3_BUSY__SHIFT                                                                       0x8
#define WD_CNTL_STATUS__GS2_BUSY__SHIFT                                                                       0x9
#define WD_CNTL_STATUS__GS1_BUSY__SHIFT                                                                       0xa
#define WD_CNTL_STATUS__GS0_BUSY__SHIFT                                                                       0xb
#define WD_CNTL_STATUS__NGG3_BUSY__SHIFT                                                                      0xc
#define WD_CNTL_STATUS__NGG2_BUSY__SHIFT                                                                      0xd
#define WD_CNTL_STATUS__NGG1_BUSY__SHIFT                                                                      0xe
#define WD_CNTL_STATUS__NGG0_BUSY__SHIFT                                                                      0xf
#define WD_CNTL_STATUS__DIST_BUSY__SHIFT                                                                      0x10
#define WD_CNTL_STATUS__DIST_BE_BUSY__SHIFT                                                                   0x11
#define WD_CNTL_STATUS__WD_TE11_BUSY__SHIFT                                                                   0x12
#define WD_CNTL_STATUS__SA3_OUTPUT_BLOCK_BUSY__SHIFT                                                          0x13
#define WD_CNTL_STATUS__SA2_OUTPUT_BLOCK_BUSY__SHIFT                                                          0x14
#define WD_CNTL_STATUS__SA1_OUTPUT_BLOCK_BUSY__SHIFT                                                          0x15
#define WD_CNTL_STATUS__SA0_OUTPUT_BLOCK_BUSY__SHIFT                                                          0x16
#define WD_CNTL_STATUS__GE_UTCL1_BUSY__SHIFT                                                                  0x17
#define WD_CNTL_STATUS__TE3_BUSY__SHIFT                                                                       0x18
#define WD_CNTL_STATUS__TE2_BUSY__SHIFT                                                                       0x19
#define WD_CNTL_STATUS__TE1_BUSY__SHIFT                                                                       0x1a
#define WD_CNTL_STATUS__TE0_BUSY__SHIFT                                                                       0x1b
#define WD_CNTL_STATUS__WLC_BUSY__SHIFT                                                                       0x1c
#define WD_CNTL_STATUS__PC_MANAGER_BUSY__SHIFT                                                                0x1d
#define WD_CNTL_STATUS__VR3_BUSY_MASK                                                                         0x00000001L
#define WD_CNTL_STATUS__VR2_BUSY_MASK                                                                         0x00000002L
#define WD_CNTL_STATUS__VR1_BUSY_MASK                                                                         0x00000004L
#define WD_CNTL_STATUS__VR0_BUSY_MASK                                                                         0x00000008L
#define WD_CNTL_STATUS__HS3_BUSY_MASK                                                                         0x00000010L
#define WD_CNTL_STATUS__HS2_BUSY_MASK                                                                         0x00000020L
#define WD_CNTL_STATUS__HS1_BUSY_MASK                                                                         0x00000040L
#define WD_CNTL_STATUS__HS0_BUSY_MASK                                                                         0x00000080L
#define WD_CNTL_STATUS__GS3_BUSY_MASK                                                                         0x00000100L
#define WD_CNTL_STATUS__GS2_BUSY_MASK                                                                         0x00000200L
#define WD_CNTL_STATUS__GS1_BUSY_MASK                                                                         0x00000400L
#define WD_CNTL_STATUS__GS0_BUSY_MASK                                                                         0x00000800L
#define WD_CNTL_STATUS__NGG3_BUSY_MASK                                                                        0x00001000L
#define WD_CNTL_STATUS__NGG2_BUSY_MASK                                                                        0x00002000L
#define WD_CNTL_STATUS__NGG1_BUSY_MASK                                                                        0x00004000L
#define WD_CNTL_STATUS__NGG0_BUSY_MASK                                                                        0x00008000L
#define WD_CNTL_STATUS__DIST_BUSY_MASK                                                                        0x00010000L
#define WD_CNTL_STATUS__DIST_BE_BUSY_MASK                                                                     0x00020000L
#define WD_CNTL_STATUS__WD_TE11_BUSY_MASK                                                                     0x00040000L
#define WD_CNTL_STATUS__SA3_OUTPUT_BLOCK_BUSY_MASK                                                            0x00080000L
#define WD_CNTL_STATUS__SA2_OUTPUT_BLOCK_BUSY_MASK                                                            0x00100000L
#define WD_CNTL_STATUS__SA1_OUTPUT_BLOCK_BUSY_MASK                                                            0x00200000L
#define WD_CNTL_STATUS__SA0_OUTPUT_BLOCK_BUSY_MASK                                                            0x00400000L
#define WD_CNTL_STATUS__GE_UTCL1_BUSY_MASK                                                                    0x00800000L
#define WD_CNTL_STATUS__TE3_BUSY_MASK                                                                         0x01000000L
#define WD_CNTL_STATUS__TE2_BUSY_MASK                                                                         0x02000000L
#define WD_CNTL_STATUS__TE1_BUSY_MASK                                                                         0x04000000L
#define WD_CNTL_STATUS__TE0_BUSY_MASK                                                                         0x08000000L
#define WD_CNTL_STATUS__WLC_BUSY_MASK                                                                         0x10000000L
#define WD_CNTL_STATUS__PC_MANAGER_BUSY_MASK                                                                  0x20000000L
//CC_GC_PRIM_CONFIG
#define CC_GC_PRIM_CONFIG__INACTIVE_PA__SHIFT                                                                 0x4
#define CC_GC_PRIM_CONFIG__INACTIVE_PA_MASK                                                                   0x000FFFF0L
//GC_USER_PRIM_CONFIG
#define GC_USER_PRIM_CONFIG__INACTIVE_PA__SHIFT                                                               0x4
#define GC_USER_PRIM_CONFIG__INACTIVE_PA_MASK                                                                 0x000FFFF0L
//WD_QOS
#define WD_QOS__DRAW_STALL__SHIFT                                                                             0x0
#define WD_QOS__DRAW_STALL_MASK                                                                               0x00000001L
//WD_UTCL1_CNTL
#define WD_UTCL1_CNTL__XNACK_REDO_TIMER_CNT__SHIFT                                                            0x0
#define WD_UTCL1_CNTL__VMID_RESET_MODE__SHIFT                                                                 0x17
#define WD_UTCL1_CNTL__DROP_MODE__SHIFT                                                                       0x18
#define WD_UTCL1_CNTL__BYPASS__SHIFT                                                                          0x19
#define WD_UTCL1_CNTL__INVALIDATE__SHIFT                                                                      0x1a
#define WD_UTCL1_CNTL__FRAG_LIMIT_MODE__SHIFT                                                                 0x1b
#define WD_UTCL1_CNTL__FORCE_SNOOP__SHIFT                                                                     0x1c
#define WD_UTCL1_CNTL__MTYPE_OVERRIDE__SHIFT                                                                  0x1d
#define WD_UTCL1_CNTL__LLC_NOALLOC_OVERRIDE__SHIFT                                                            0x1e
#define WD_UTCL1_CNTL__XNACK_REDO_TIMER_CNT_MASK                                                              0x000FFFFFL
#define WD_UTCL1_CNTL__VMID_RESET_MODE_MASK                                                                   0x00800000L
#define WD_UTCL1_CNTL__DROP_MODE_MASK                                                                         0x01000000L
#define WD_UTCL1_CNTL__BYPASS_MASK                                                                            0x02000000L
#define WD_UTCL1_CNTL__INVALIDATE_MASK                                                                        0x04000000L
#define WD_UTCL1_CNTL__FRAG_LIMIT_MODE_MASK                                                                   0x08000000L
#define WD_UTCL1_CNTL__FORCE_SNOOP_MASK                                                                       0x10000000L
#define WD_UTCL1_CNTL__MTYPE_OVERRIDE_MASK                                                                    0x20000000L
#define WD_UTCL1_CNTL__LLC_NOALLOC_OVERRIDE_MASK                                                              0x40000000L
//WD_UTCL1_STATUS
#define WD_UTCL1_STATUS__FAULT_DETECTED__SHIFT                                                                0x0
#define WD_UTCL1_STATUS__RETRY_DETECTED__SHIFT                                                                0x1
#define WD_UTCL1_STATUS__PRT_DETECTED__SHIFT                                                                  0x2
#define WD_UTCL1_STATUS__FAULT_UTCL1ID__SHIFT                                                                 0x8
#define WD_UTCL1_STATUS__RETRY_UTCL1ID__SHIFT                                                                 0x10
#define WD_UTCL1_STATUS__PRT_UTCL1ID__SHIFT                                                                   0x18
#define WD_UTCL1_STATUS__FAULT_DETECTED_MASK                                                                  0x00000001L
#define WD_UTCL1_STATUS__RETRY_DETECTED_MASK                                                                  0x00000002L
#define WD_UTCL1_STATUS__PRT_DETECTED_MASK                                                                    0x00000004L
#define WD_UTCL1_STATUS__FAULT_UTCL1ID_MASK                                                                   0x00003F00L
#define WD_UTCL1_STATUS__RETRY_UTCL1ID_MASK                                                                   0x003F0000L
#define WD_UTCL1_STATUS__PRT_UTCL1ID_MASK                                                                     0x3F000000L
//GE_PC_CNTL
#define GE_PC_CNTL__PC_SIZE__SHIFT                                                                            0x0
#define GE_PC_CNTL__NO_RESERVATION_EN__SHIFT                                                                  0x11
#define GE_PC_CNTL__WAVES_WITH_NO_GRANT__SHIFT                                                                0x12
#define GE_PC_CNTL__PC_SIZE_MASK                                                                              0x0000FFFFL
#define GE_PC_CNTL__NO_RESERVATION_EN_MASK                                                                    0x00020000L
#define GE_PC_CNTL__WAVES_WITH_NO_GRANT_MASK                                                                  0x003C0000L
//IA_UTCL1_CNTL
#define IA_UTCL1_CNTL__XNACK_REDO_TIMER_CNT__SHIFT                                                            0x0
#define IA_UTCL1_CNTL__VMID_RESET_MODE__SHIFT                                                                 0x17
#define IA_UTCL1_CNTL__DROP_MODE__SHIFT                                                                       0x18
#define IA_UTCL1_CNTL__BYPASS__SHIFT                                                                          0x19
#define IA_UTCL1_CNTL__INVALIDATE__SHIFT                                                                      0x1a
#define IA_UTCL1_CNTL__FRAG_LIMIT_MODE__SHIFT                                                                 0x1b
#define IA_UTCL1_CNTL__FORCE_SNOOP__SHIFT                                                                     0x1c
#define IA_UTCL1_CNTL__MTYPE_OVERRIDE__SHIFT                                                                  0x1d
#define IA_UTCL1_CNTL__LLC_NOALLOC_OVERRIDE__SHIFT                                                            0x1e
#define IA_UTCL1_CNTL__XNACK_REDO_TIMER_CNT_MASK                                                              0x000FFFFFL
#define IA_UTCL1_CNTL__VMID_RESET_MODE_MASK                                                                   0x00800000L
#define IA_UTCL1_CNTL__DROP_MODE_MASK                                                                         0x01000000L
#define IA_UTCL1_CNTL__BYPASS_MASK                                                                            0x02000000L
#define IA_UTCL1_CNTL__INVALIDATE_MASK                                                                        0x04000000L
#define IA_UTCL1_CNTL__FRAG_LIMIT_MODE_MASK                                                                   0x08000000L
#define IA_UTCL1_CNTL__FORCE_SNOOP_MASK                                                                       0x10000000L
#define IA_UTCL1_CNTL__MTYPE_OVERRIDE_MASK                                                                    0x20000000L
#define IA_UTCL1_CNTL__LLC_NOALLOC_OVERRIDE_MASK                                                              0x40000000L
//IA_UTCL1_STATUS
#define IA_UTCL1_STATUS__FAULT_DETECTED__SHIFT                                                                0x0
#define IA_UTCL1_STATUS__RETRY_DETECTED__SHIFT                                                                0x1
#define IA_UTCL1_STATUS__PRT_DETECTED__SHIFT                                                                  0x2
#define IA_UTCL1_STATUS__FAULT_UTCL1ID__SHIFT                                                                 0x8
#define IA_UTCL1_STATUS__RETRY_UTCL1ID__SHIFT                                                                 0x10
#define IA_UTCL1_STATUS__PRT_UTCL1ID__SHIFT                                                                   0x18
#define IA_UTCL1_STATUS__FAULT_DETECTED_MASK                                                                  0x00000001L
#define IA_UTCL1_STATUS__RETRY_DETECTED_MASK                                                                  0x00000002L
#define IA_UTCL1_STATUS__PRT_DETECTED_MASK                                                                    0x00000004L
#define IA_UTCL1_STATUS__FAULT_UTCL1ID_MASK                                                                   0x00003F00L
#define IA_UTCL1_STATUS__RETRY_UTCL1ID_MASK                                                                   0x003F0000L
#define IA_UTCL1_STATUS__PRT_UTCL1ID_MASK                                                                     0x3F000000L
//CC_GC_SA_UNIT_DISABLE
#define CC_GC_SA_UNIT_DISABLE__SA_DISABLE__SHIFT                                                              0x8
#define CC_GC_SA_UNIT_DISABLE__SA_DISABLE_MASK                                                                0x0000FF00L
//GC_USER_SA_UNIT_DISABLE
#define GC_USER_SA_UNIT_DISABLE__SA_DISABLE__SHIFT                                                            0x8
#define GC_USER_SA_UNIT_DISABLE__SA_DISABLE_MASK                                                              0x0000FF00L
//VGT_SYS_CONFIG
#define VGT_SYS_CONFIG__DUAL_CORE_EN__SHIFT                                                                   0x0
#define VGT_SYS_CONFIG__MAX_LS_HS_THDGRP__SHIFT                                                               0x1
#define VGT_SYS_CONFIG__ADC_EVENT_FILTER_DISABLE__SHIFT                                                       0x7
#define VGT_SYS_CONFIG__NUM_SUBGROUPS_IN_FLIGHT__SHIFT                                                        0x8
#define VGT_SYS_CONFIG__DUAL_CORE_EN_MASK                                                                     0x00000001L
#define VGT_SYS_CONFIG__MAX_LS_HS_THDGRP_MASK                                                                 0x0000007EL
#define VGT_SYS_CONFIG__ADC_EVENT_FILTER_DISABLE_MASK                                                         0x00000080L
#define VGT_SYS_CONFIG__NUM_SUBGROUPS_IN_FLIGHT_MASK                                                          0x0007FF00L
//GE_PRIV_CONTROL
#define GE_PRIV_CONTROL__DISCARD_LEGACY__SHIFT                                                                0x0
#define GE_PRIV_CONTROL__CLAMP_PRIMGRP_SIZE__SHIFT                                                            0x1
#define GE_PRIV_CONTROL__RESET_ON_PIPELINE_CHANGE__SHIFT                                                      0xa
#define GE_PRIV_CONTROL__FGCG_OVERRIDE__SHIFT                                                                 0xf
#define GE_PRIV_CONTROL__CLAMP_HS_OFFCHIP_PER_SE_OVERRIDE__SHIFT                                              0x10
#define GE_PRIV_CONTROL__DISCARD_LEGACY_MASK                                                                  0x00000001L
#define GE_PRIV_CONTROL__CLAMP_PRIMGRP_SIZE_MASK                                                              0x000003FEL
#define GE_PRIV_CONTROL__RESET_ON_PIPELINE_CHANGE_MASK                                                        0x00000400L
#define GE_PRIV_CONTROL__FGCG_OVERRIDE_MASK                                                                   0x00008000L
#define GE_PRIV_CONTROL__CLAMP_HS_OFFCHIP_PER_SE_OVERRIDE_MASK                                                0x00010000L
//GE_STATUS
#define GE_STATUS__PERFCOUNTER_STATUS__SHIFT                                                                  0x0
#define GE_STATUS__THREAD_TRACE_STATUS__SHIFT                                                                 0x1
#define GE_STATUS__PERFCOUNTER_STATUS_MASK                                                                    0x00000001L
#define GE_STATUS__THREAD_TRACE_STATUS_MASK                                                                   0x00000002L
//VGT_VS_MAX_WAVE_ID
#define VGT_VS_MAX_WAVE_ID__MAX_WAVE_ID__SHIFT                                                                0x0
#define VGT_VS_MAX_WAVE_ID__MAX_WAVE_ID_MASK                                                                  0x00000FFFL
//VGT_GS_MAX_WAVE_ID
#define VGT_GS_MAX_WAVE_ID__MAX_WAVE_ID__SHIFT                                                                0x0
#define VGT_GS_MAX_WAVE_ID__MAX_WAVE_ID_MASK                                                                  0x00000FFFL
//CC_GC_SHADER_ARRAY_CONFIG_GEN1
#define CC_GC_SHADER_ARRAY_CONFIG_GEN1__GEN1_INACTIVE_CU__SHIFT                                               0x0
#define CC_GC_SHADER_ARRAY_CONFIG_GEN1__GEN1_INACTIVE_CU_MASK                                                 0x00003FFFL
//CC_GC_SHADER_ARRAY_CONFIG_GEN0
#define CC_GC_SHADER_ARRAY_CONFIG_GEN0__GEN0_INACTIVE_CU__SHIFT                                               0x0
#define CC_GC_SHADER_ARRAY_CONFIG_GEN0__GEN0_INACTIVE_CU_MASK                                                 0x00003FFFL
//GFX_PIPE_CONTROL
#define GFX_PIPE_CONTROL__HYSTERESIS_CNT__SHIFT                                                               0x0
#define GFX_PIPE_CONTROL__RESERVED__SHIFT                                                                     0xd
#define GFX_PIPE_CONTROL__CONTEXT_SUSPEND_EN__SHIFT                                                           0x10
#define GFX_PIPE_CONTROL__CONTEXT_SUSPEND_STALL_EN__SHIFT                                                     0x11
#define GFX_PIPE_CONTROL__HYSTERESIS_CNT_MASK                                                                 0x00001FFFL
#define GFX_PIPE_CONTROL__RESERVED_MASK                                                                       0x0000E000L
#define GFX_PIPE_CONTROL__CONTEXT_SUSPEND_EN_MASK                                                             0x00010000L
#define GFX_PIPE_CONTROL__CONTEXT_SUSPEND_STALL_EN_MASK                                                       0x00020000L
//CC_GC_SHADER_ARRAY_CONFIG
#define CC_GC_SHADER_ARRAY_CONFIG__INACTIVE_WGPS__SHIFT                                                       0x10
#define CC_GC_SHADER_ARRAY_CONFIG__INACTIVE_WGPS_MASK                                                         0xFFFF0000L
//GC_USER_SHADER_ARRAY_CONFIG
#define GC_USER_SHADER_ARRAY_CONFIG__INACTIVE_WGPS__SHIFT                                                     0x10
#define GC_USER_SHADER_ARRAY_CONFIG__INACTIVE_WGPS_MASK                                                       0xFFFF0000L
//VGT_DMA_PRIMITIVE_TYPE
#define VGT_DMA_PRIMITIVE_TYPE__PRIM_TYPE__SHIFT                                                              0x0
#define VGT_DMA_PRIMITIVE_TYPE__PRIM_TYPE_MASK                                                                0x0000003FL
//VGT_DMA_CONTROL
#define VGT_DMA_CONTROL__PRIMGROUP_SIZE__SHIFT                                                                0x0
#define VGT_DMA_CONTROL__IA_SWITCH_ON_EOP__SHIFT                                                              0x11
#define VGT_DMA_CONTROL__SWITCH_ON_EOI__SHIFT                                                                 0x13
#define VGT_DMA_CONTROL__WD_SWITCH_ON_EOP__SHIFT                                                              0x14
#define VGT_DMA_CONTROL__PRIMGROUP_SIZE_MASK                                                                  0x0000FFFFL
#define VGT_DMA_CONTROL__IA_SWITCH_ON_EOP_MASK                                                                0x00020000L
#define VGT_DMA_CONTROL__SWITCH_ON_EOI_MASK                                                                   0x00080000L
#define VGT_DMA_CONTROL__WD_SWITCH_ON_EOP_MASK                                                                0x00100000L
//VGT_DMA_LS_HS_CONFIG
#define VGT_DMA_LS_HS_CONFIG__HS_NUM_INPUT_CP__SHIFT                                                          0x8
#define VGT_DMA_LS_HS_CONFIG__HS_NUM_INPUT_CP_MASK                                                            0x00003F00L
//VGT_STRMOUT_DELAY
#define VGT_STRMOUT_DELAY__SKIP_DELAY__SHIFT                                                                  0x0
#define VGT_STRMOUT_DELAY__SE0_WD_DELAY__SHIFT                                                                0x8
#define VGT_STRMOUT_DELAY__SE1_WD_DELAY__SHIFT                                                                0xb
#define VGT_STRMOUT_DELAY__SE2_WD_DELAY__SHIFT                                                                0xe
#define VGT_STRMOUT_DELAY__SE3_WD_DELAY__SHIFT                                                                0x11
#define VGT_STRMOUT_DELAY__SKIP_DELAY_MASK                                                                    0x000000FFL
#define VGT_STRMOUT_DELAY__SE0_WD_DELAY_MASK                                                                  0x00000700L
#define VGT_STRMOUT_DELAY__SE1_WD_DELAY_MASK                                                                  0x00003800L
#define VGT_STRMOUT_DELAY__SE2_WD_DELAY_MASK                                                                  0x0001C000L
#define VGT_STRMOUT_DELAY__SE3_WD_DELAY_MASK                                                                  0x000E0000L
//WD_BUF_RESOURCE_1
#define WD_BUF_RESOURCE_1__POS_BUF_SIZE__SHIFT                                                                0x0
#define WD_BUF_RESOURCE_1__INDEX_BUF_SIZE__SHIFT                                                              0x10
#define WD_BUF_RESOURCE_1__POS_BUF_SIZE_MASK                                                                  0x0000FFFFL
#define WD_BUF_RESOURCE_1__INDEX_BUF_SIZE_MASK                                                                0xFFFF0000L
//WD_BUF_RESOURCE_2
#define WD_BUF_RESOURCE_2__PARAM_BUF_SIZE__SHIFT                                                              0x0
#define WD_BUF_RESOURCE_2__ADDR_MODE__SHIFT                                                                   0xf
#define WD_BUF_RESOURCE_2__CNTL_SB_BUF_SIZE__SHIFT                                                            0x10
#define WD_BUF_RESOURCE_2__PARAM_BUF_SIZE_MASK                                                                0x00001FFFL
#define WD_BUF_RESOURCE_2__ADDR_MODE_MASK                                                                     0x00008000L
#define WD_BUF_RESOURCE_2__CNTL_SB_BUF_SIZE_MASK                                                              0xFFFF0000L
//PA_CL_CNTL_STATUS
#define PA_CL_CNTL_STATUS__UTC_FAULT_DETECTED__SHIFT                                                          0x0
#define PA_CL_CNTL_STATUS__UTC_RETRY_DETECTED__SHIFT                                                          0x1
#define PA_CL_CNTL_STATUS__UTC_PRT_DETECTED__SHIFT                                                            0x2
#define PA_CL_CNTL_STATUS__CL_BUSY__SHIFT                                                                     0x1f
#define PA_CL_CNTL_STATUS__UTC_FAULT_DETECTED_MASK                                                            0x00000001L
#define PA_CL_CNTL_STATUS__UTC_RETRY_DETECTED_MASK                                                            0x00000002L
#define PA_CL_CNTL_STATUS__UTC_PRT_DETECTED_MASK                                                              0x00000004L
#define PA_CL_CNTL_STATUS__CL_BUSY_MASK                                                                       0x80000000L
//PA_CL_ENHANCE
#define PA_CL_ENHANCE__CLIP_VTX_REORDER_ENA__SHIFT                                                            0x0
#define PA_CL_ENHANCE__NUM_CLIP_SEQ__SHIFT                                                                    0x1
#define PA_CL_ENHANCE__CLIPPED_PRIM_SEQ_STALL__SHIFT                                                          0x3
#define PA_CL_ENHANCE__VE_NAN_PROC_DISABLE__SHIFT                                                             0x4
#define PA_CL_ENHANCE__IGNORE_PIPELINE_RESET__SHIFT                                                           0x6
#define PA_CL_ENHANCE__KILL_INNER_EDGE_FLAGS__SHIFT                                                           0x7
#define PA_CL_ENHANCE__NGG_PA_TO_ALL_SC__SHIFT                                                                0x8
#define PA_CL_ENHANCE__TC_LATENCY_TIME_STAMP_RESOLUTION__SHIFT                                                0x9
#define PA_CL_ENHANCE__NGG_BYPASS_PRIM_FILTER__SHIFT                                                          0xb
#define PA_CL_ENHANCE__NGG_SIDEBAND_MEMORY_DEPTH__SHIFT                                                       0xc
#define PA_CL_ENHANCE__NGG_PRIM_INDICES_FIFO_DEPTH__SHIFT                                                     0xe
#define PA_CL_ENHANCE__PROG_NEAR_CLIP_PLANE_ENABLE__SHIFT                                                     0x11
#define PA_CL_ENHANCE__OUTPUT_SWITCH_TO_LEGACY_EVENT__SHIFT                                                   0x12
#define PA_CL_ENHANCE__NO_SWITCH_TO_LEGACY_AFTER_VMID_RESET__SHIFT                                            0x13
#define PA_CL_ENHANCE__POLY_INNER_EDGE_FLAG_DISABLE__SHIFT                                                    0x14
#define PA_CL_ENHANCE__TC_REQUEST_PERF_CNTR_ENABLE__SHIFT                                                     0x15
#define PA_CL_ENHANCE__DISABLE_PA_PH_INTF_FINE_CLOCK_GATE__SHIFT                                              0x16
#define PA_CL_ENHANCE__CLAMP_NEGATIVE_BB_TO_ZERO__SHIFT                                                       0x18
#define PA_CL_ENHANCE__ECO_SPARE3__SHIFT                                                                      0x1c
#define PA_CL_ENHANCE__ECO_SPARE2__SHIFT                                                                      0x1d
#define PA_CL_ENHANCE__ECO_SPARE1__SHIFT                                                                      0x1e
#define PA_CL_ENHANCE__ECO_SPARE0__SHIFT                                                                      0x1f
#define PA_CL_ENHANCE__CLIP_VTX_REORDER_ENA_MASK                                                              0x00000001L
#define PA_CL_ENHANCE__NUM_CLIP_SEQ_MASK                                                                      0x00000006L
#define PA_CL_ENHANCE__CLIPPED_PRIM_SEQ_STALL_MASK                                                            0x00000008L
#define PA_CL_ENHANCE__VE_NAN_PROC_DISABLE_MASK                                                               0x00000010L
#define PA_CL_ENHANCE__IGNORE_PIPELINE_RESET_MASK                                                             0x00000040L
#define PA_CL_ENHANCE__KILL_INNER_EDGE_FLAGS_MASK                                                             0x00000080L
#define PA_CL_ENHANCE__NGG_PA_TO_ALL_SC_MASK                                                                  0x00000100L
#define PA_CL_ENHANCE__TC_LATENCY_TIME_STAMP_RESOLUTION_MASK                                                  0x00000600L
#define PA_CL_ENHANCE__NGG_BYPASS_PRIM_FILTER_MASK                                                            0x00000800L
#define PA_CL_ENHANCE__NGG_SIDEBAND_MEMORY_DEPTH_MASK                                                         0x00003000L
#define PA_CL_ENHANCE__NGG_PRIM_INDICES_FIFO_DEPTH_MASK                                                       0x0001C000L
#define PA_CL_ENHANCE__PROG_NEAR_CLIP_PLANE_ENABLE_MASK                                                       0x00020000L
#define PA_CL_ENHANCE__OUTPUT_SWITCH_TO_LEGACY_EVENT_MASK                                                     0x00040000L
#define PA_CL_ENHANCE__NO_SWITCH_TO_LEGACY_AFTER_VMID_RESET_MASK                                              0x00080000L
#define PA_CL_ENHANCE__POLY_INNER_EDGE_FLAG_DISABLE_MASK                                                      0x00100000L
#define PA_CL_ENHANCE__TC_REQUEST_PERF_CNTR_ENABLE_MASK                                                       0x00200000L
#define PA_CL_ENHANCE__DISABLE_PA_PH_INTF_FINE_CLOCK_GATE_MASK                                                0x00400000L
#define PA_CL_ENHANCE__CLAMP_NEGATIVE_BB_TO_ZERO_MASK                                                         0x01000000L
#define PA_CL_ENHANCE__ECO_SPARE3_MASK                                                                        0x10000000L
#define PA_CL_ENHANCE__ECO_SPARE2_MASK                                                                        0x20000000L
#define PA_CL_ENHANCE__ECO_SPARE1_MASK                                                                        0x40000000L
#define PA_CL_ENHANCE__ECO_SPARE0_MASK                                                                        0x80000000L
//PA_SU_CNTL_STATUS
#define PA_SU_CNTL_STATUS__SU_BUSY__SHIFT                                                                     0x1f
#define PA_SU_CNTL_STATUS__SU_BUSY_MASK                                                                       0x80000000L
//PA_SC_FIFO_DEPTH_CNTL
#define PA_SC_FIFO_DEPTH_CNTL__DEPTH__SHIFT                                                                   0x0
#define PA_SC_FIFO_DEPTH_CNTL__DEPTH_MASK                                                                     0x000003FFL
//PA_SC_P3D_TRAP_SCREEN_HV_LOCK
#define PA_SC_P3D_TRAP_SCREEN_HV_LOCK__DISABLE_NON_PRIV_WRITES__SHIFT                                         0x0
#define PA_SC_P3D_TRAP_SCREEN_HV_LOCK__DISABLE_NON_PRIV_WRITES_MASK                                           0x00000001L
//PA_SC_HP3D_TRAP_SCREEN_HV_LOCK
#define PA_SC_HP3D_TRAP_SCREEN_HV_LOCK__DISABLE_NON_PRIV_WRITES__SHIFT                                        0x0
#define PA_SC_HP3D_TRAP_SCREEN_HV_LOCK__DISABLE_NON_PRIV_WRITES_MASK                                          0x00000001L
//PA_SC_TRAP_SCREEN_HV_LOCK
#define PA_SC_TRAP_SCREEN_HV_LOCK__DISABLE_NON_PRIV_WRITES__SHIFT                                             0x0
#define PA_SC_TRAP_SCREEN_HV_LOCK__DISABLE_NON_PRIV_WRITES_MASK                                               0x00000001L
//PA_SC_FORCE_EOV_MAX_CNTS
#define PA_SC_FORCE_EOV_MAX_CNTS__FORCE_EOV_MAX_CLK_CNT__SHIFT                                                0x0
#define PA_SC_FORCE_EOV_MAX_CNTS__FORCE_EOV_MAX_REZ_CNT__SHIFT                                                0x10
#define PA_SC_FORCE_EOV_MAX_CNTS__FORCE_EOV_MAX_CLK_CNT_MASK                                                  0x0000FFFFL
#define PA_SC_FORCE_EOV_MAX_CNTS__FORCE_EOV_MAX_REZ_CNT_MASK                                                  0xFFFF0000L
//PA_SC_BINNER_EVENT_CNTL_0
#define PA_SC_BINNER_EVENT_CNTL_0__RESERVED_0__SHIFT                                                          0x0
#define PA_SC_BINNER_EVENT_CNTL_0__SAMPLE_STREAMOUTSTATS1__SHIFT                                              0x2
#define PA_SC_BINNER_EVENT_CNTL_0__SAMPLE_STREAMOUTSTATS2__SHIFT                                              0x4
#define PA_SC_BINNER_EVENT_CNTL_0__SAMPLE_STREAMOUTSTATS3__SHIFT                                              0x6
#define PA_SC_BINNER_EVENT_CNTL_0__CACHE_FLUSH_TS__SHIFT                                                      0x8
#define PA_SC_BINNER_EVENT_CNTL_0__CONTEXT_DONE__SHIFT                                                        0xa
#define PA_SC_BINNER_EVENT_CNTL_0__CACHE_FLUSH__SHIFT                                                         0xc
#define PA_SC_BINNER_EVENT_CNTL_0__CS_PARTIAL_FLUSH__SHIFT                                                    0xe
#define PA_SC_BINNER_EVENT_CNTL_0__VGT_STREAMOUT_SYNC__SHIFT                                                  0x10
#define PA_SC_BINNER_EVENT_CNTL_0__RESERVED_9__SHIFT                                                          0x12
#define PA_SC_BINNER_EVENT_CNTL_0__VGT_STREAMOUT_RESET__SHIFT                                                 0x14
#define PA_SC_BINNER_EVENT_CNTL_0__END_OF_PIPE_INCR_DE__SHIFT                                                 0x16
#define PA_SC_BINNER_EVENT_CNTL_0__END_OF_PIPE_IB_END__SHIFT                                                  0x18
#define PA_SC_BINNER_EVENT_CNTL_0__RST_PIX_CNT__SHIFT                                                         0x1a
#define PA_SC_BINNER_EVENT_CNTL_0__BREAK_BATCH__SHIFT                                                         0x1c
#define PA_SC_BINNER_EVENT_CNTL_0__VS_PARTIAL_FLUSH__SHIFT                                                    0x1e
#define PA_SC_BINNER_EVENT_CNTL_0__RESERVED_0_MASK                                                            0x00000003L
#define PA_SC_BINNER_EVENT_CNTL_0__SAMPLE_STREAMOUTSTATS1_MASK                                                0x0000000CL
#define PA_SC_BINNER_EVENT_CNTL_0__SAMPLE_STREAMOUTSTATS2_MASK                                                0x00000030L
#define PA_SC_BINNER_EVENT_CNTL_0__SAMPLE_STREAMOUTSTATS3_MASK                                                0x000000C0L
#define PA_SC_BINNER_EVENT_CNTL_0__CACHE_FLUSH_TS_MASK                                                        0x00000300L
#define PA_SC_BINNER_EVENT_CNTL_0__CONTEXT_DONE_MASK                                                          0x00000C00L
#define PA_SC_BINNER_EVENT_CNTL_0__CACHE_FLUSH_MASK                                                           0x00003000L
#define PA_SC_BINNER_EVENT_CNTL_0__CS_PARTIAL_FLUSH_MASK                                                      0x0000C000L
#define PA_SC_BINNER_EVENT_CNTL_0__VGT_STREAMOUT_SYNC_MASK                                                    0x00030000L
#define PA_SC_BINNER_EVENT_CNTL_0__RESERVED_9_MASK                                                            0x000C0000L
#define PA_SC_BINNER_EVENT_CNTL_0__VGT_STREAMOUT_RESET_MASK                                                   0x00300000L
#define PA_SC_BINNER_EVENT_CNTL_0__END_OF_PIPE_INCR_DE_MASK                                                   0x00C00000L
#define PA_SC_BINNER_EVENT_CNTL_0__END_OF_PIPE_IB_END_MASK                                                    0x03000000L
#define PA_SC_BINNER_EVENT_CNTL_0__RST_PIX_CNT_MASK                                                           0x0C000000L
#define PA_SC_BINNER_EVENT_CNTL_0__BREAK_BATCH_MASK                                                           0x30000000L
#define PA_SC_BINNER_EVENT_CNTL_0__VS_PARTIAL_FLUSH_MASK                                                      0xC0000000L
//PA_SC_BINNER_EVENT_CNTL_1
#define PA_SC_BINNER_EVENT_CNTL_1__PS_PARTIAL_FLUSH__SHIFT                                                    0x0
#define PA_SC_BINNER_EVENT_CNTL_1__FLUSH_HS_OUTPUT__SHIFT                                                     0x2
#define PA_SC_BINNER_EVENT_CNTL_1__FLUSH_DFSM__SHIFT                                                          0x4
#define PA_SC_BINNER_EVENT_CNTL_1__RESET_TO_LOWEST_VGT__SHIFT                                                 0x6
#define PA_SC_BINNER_EVENT_CNTL_1__CACHE_FLUSH_AND_INV_TS_EVENT__SHIFT                                        0x8
#define PA_SC_BINNER_EVENT_CNTL_1__ZPASS_DONE__SHIFT                                                          0xa
#define PA_SC_BINNER_EVENT_CNTL_1__CACHE_FLUSH_AND_INV_EVENT__SHIFT                                           0xc
#define PA_SC_BINNER_EVENT_CNTL_1__PERFCOUNTER_START__SHIFT                                                   0xe
#define PA_SC_BINNER_EVENT_CNTL_1__PERFCOUNTER_STOP__SHIFT                                                    0x10
#define PA_SC_BINNER_EVENT_CNTL_1__PIPELINESTAT_START__SHIFT                                                  0x12
#define PA_SC_BINNER_EVENT_CNTL_1__PIPELINESTAT_STOP__SHIFT                                                   0x14
#define PA_SC_BINNER_EVENT_CNTL_1__PERFCOUNTER_SAMPLE__SHIFT                                                  0x16
#define PA_SC_BINNER_EVENT_CNTL_1__FLUSH_ES_OUTPUT__SHIFT                                                     0x18
#define PA_SC_BINNER_EVENT_CNTL_1__BIN_CONF_OVERRIDE_CHECK__SHIFT                                             0x1a
#define PA_SC_BINNER_EVENT_CNTL_1__SAMPLE_PIPELINESTAT__SHIFT                                                 0x1c
#define PA_SC_BINNER_EVENT_CNTL_1__SO_VGTSTREAMOUT_FLUSH__SHIFT                                               0x1e
#define PA_SC_BINNER_EVENT_CNTL_1__PS_PARTIAL_FLUSH_MASK                                                      0x00000003L
#define PA_SC_BINNER_EVENT_CNTL_1__FLUSH_HS_OUTPUT_MASK                                                       0x0000000CL
#define PA_SC_BINNER_EVENT_CNTL_1__FLUSH_DFSM_MASK                                                            0x00000030L
#define PA_SC_BINNER_EVENT_CNTL_1__RESET_TO_LOWEST_VGT_MASK                                                   0x000000C0L
#define PA_SC_BINNER_EVENT_CNTL_1__CACHE_FLUSH_AND_INV_TS_EVENT_MASK                                          0x00000300L
#define PA_SC_BINNER_EVENT_CNTL_1__ZPASS_DONE_MASK                                                            0x00000C00L
#define PA_SC_BINNER_EVENT_CNTL_1__CACHE_FLUSH_AND_INV_EVENT_MASK                                             0x00003000L
#define PA_SC_BINNER_EVENT_CNTL_1__PERFCOUNTER_START_MASK                                                     0x0000C000L
#define PA_SC_BINNER_EVENT_CNTL_1__PERFCOUNTER_STOP_MASK                                                      0x00030000L
#define PA_SC_BINNER_EVENT_CNTL_1__PIPELINESTAT_START_MASK                                                    0x000C0000L
#define PA_SC_BINNER_EVENT_CNTL_1__PIPELINESTAT_STOP_MASK                                                     0x00300000L
#define PA_SC_BINNER_EVENT_CNTL_1__PERFCOUNTER_SAMPLE_MASK                                                    0x00C00000L
#define PA_SC_BINNER_EVENT_CNTL_1__FLUSH_ES_OUTPUT_MASK                                                       0x03000000L
#define PA_SC_BINNER_EVENT_CNTL_1__BIN_CONF_OVERRIDE_CHECK_MASK                                               0x0C000000L
#define PA_SC_BINNER_EVENT_CNTL_1__SAMPLE_PIPELINESTAT_MASK                                                   0x30000000L
#define PA_SC_BINNER_EVENT_CNTL_1__SO_VGTSTREAMOUT_FLUSH_MASK                                                 0xC0000000L
//PA_SC_BINNER_EVENT_CNTL_2
#define PA_SC_BINNER_EVENT_CNTL_2__SAMPLE_STREAMOUTSTATS__SHIFT                                               0x0
#define PA_SC_BINNER_EVENT_CNTL_2__RESET_VTX_CNT__SHIFT                                                       0x2
#define PA_SC_BINNER_EVENT_CNTL_2__BLOCK_CONTEXT_DONE__SHIFT                                                  0x4
#define PA_SC_BINNER_EVENT_CNTL_2__RESERVED_35__SHIFT                                                         0x6
#define PA_SC_BINNER_EVENT_CNTL_2__VGT_FLUSH__SHIFT                                                           0x8
#define PA_SC_BINNER_EVENT_CNTL_2__TGID_ROLLOVER__SHIFT                                                       0xa
#define PA_SC_BINNER_EVENT_CNTL_2__SQ_NON_EVENT__SHIFT                                                        0xc
#define PA_SC_BINNER_EVENT_CNTL_2__SC_SEND_DB_VPZ__SHIFT                                                      0xe
#define PA_SC_BINNER_EVENT_CNTL_2__BOTTOM_OF_PIPE_TS__SHIFT                                                   0x10
#define PA_SC_BINNER_EVENT_CNTL_2__RESERVED_41__SHIFT                                                         0x12
#define PA_SC_BINNER_EVENT_CNTL_2__DB_CACHE_FLUSH_AND_INV__SHIFT                                              0x14
#define PA_SC_BINNER_EVENT_CNTL_2__FLUSH_AND_INV_DB_DATA_TS__SHIFT                                            0x16
#define PA_SC_BINNER_EVENT_CNTL_2__FLUSH_AND_INV_DB_META__SHIFT                                               0x18
#define PA_SC_BINNER_EVENT_CNTL_2__FLUSH_AND_INV_CB_DATA_TS__SHIFT                                            0x1a
#define PA_SC_BINNER_EVENT_CNTL_2__FLUSH_AND_INV_CB_META__SHIFT                                               0x1c
#define PA_SC_BINNER_EVENT_CNTL_2__CS_DONE__SHIFT                                                             0x1e
#define PA_SC_BINNER_EVENT_CNTL_2__SAMPLE_STREAMOUTSTATS_MASK                                                 0x00000003L
#define PA_SC_BINNER_EVENT_CNTL_2__RESET_VTX_CNT_MASK                                                         0x0000000CL
#define PA_SC_BINNER_EVENT_CNTL_2__BLOCK_CONTEXT_DONE_MASK                                                    0x00000030L
#define PA_SC_BINNER_EVENT_CNTL_2__RESERVED_35_MASK                                                           0x000000C0L
#define PA_SC_BINNER_EVENT_CNTL_2__VGT_FLUSH_MASK                                                             0x00000300L
#define PA_SC_BINNER_EVENT_CNTL_2__TGID_ROLLOVER_MASK                                                         0x00000C00L
#define PA_SC_BINNER_EVENT_CNTL_2__SQ_NON_EVENT_MASK                                                          0x00003000L
#define PA_SC_BINNER_EVENT_CNTL_2__SC_SEND_DB_VPZ_MASK                                                        0x0000C000L
#define PA_SC_BINNER_EVENT_CNTL_2__BOTTOM_OF_PIPE_TS_MASK                                                     0x00030000L
#define PA_SC_BINNER_EVENT_CNTL_2__RESERVED_41_MASK                                                           0x000C0000L
#define PA_SC_BINNER_EVENT_CNTL_2__DB_CACHE_FLUSH_AND_INV_MASK                                                0x00300000L
#define PA_SC_BINNER_EVENT_CNTL_2__FLUSH_AND_INV_DB_DATA_TS_MASK                                              0x00C00000L
#define PA_SC_BINNER_EVENT_CNTL_2__FLUSH_AND_INV_DB_META_MASK                                                 0x03000000L
#define PA_SC_BINNER_EVENT_CNTL_2__FLUSH_AND_INV_CB_DATA_TS_MASK                                              0x0C000000L
#define PA_SC_BINNER_EVENT_CNTL_2__FLUSH_AND_INV_CB_META_MASK                                                 0x30000000L
#define PA_SC_BINNER_EVENT_CNTL_2__CS_DONE_MASK                                                               0xC0000000L
//PA_SC_BINNER_EVENT_CNTL_3
#define PA_SC_BINNER_EVENT_CNTL_3__PS_DONE__SHIFT                                                             0x0
#define PA_SC_BINNER_EVENT_CNTL_3__FLUSH_AND_INV_CB_PIXEL_DATA__SHIFT                                         0x2
#define PA_SC_BINNER_EVENT_CNTL_3__RESERVED_50__SHIFT                                                         0x4
#define PA_SC_BINNER_EVENT_CNTL_3__THREAD_TRACE_START__SHIFT                                                  0x6
#define PA_SC_BINNER_EVENT_CNTL_3__THREAD_TRACE_STOP__SHIFT                                                   0x8
#define PA_SC_BINNER_EVENT_CNTL_3__THREAD_TRACE_MARKER__SHIFT                                                 0xa
#define PA_SC_BINNER_EVENT_CNTL_3__THREAD_TRACE_DRAW__SHIFT                                                   0xc
#define PA_SC_BINNER_EVENT_CNTL_3__THREAD_TRACE_FINISH__SHIFT                                                 0xe
#define PA_SC_BINNER_EVENT_CNTL_3__PIXEL_PIPE_STAT_CONTROL__SHIFT                                             0x10
#define PA_SC_BINNER_EVENT_CNTL_3__PIXEL_PIPE_STAT_DUMP__SHIFT                                                0x12
#define PA_SC_BINNER_EVENT_CNTL_3__PIXEL_PIPE_STAT_RESET__SHIFT                                               0x14
#define PA_SC_BINNER_EVENT_CNTL_3__CONTEXT_SUSPEND__SHIFT                                                     0x16
#define PA_SC_BINNER_EVENT_CNTL_3__OFFCHIP_HS_DEALLOC__SHIFT                                                  0x18
#define PA_SC_BINNER_EVENT_CNTL_3__ENABLE_NGG_PIPELINE__SHIFT                                                 0x1a
#define PA_SC_BINNER_EVENT_CNTL_3__ENABLE_LEGACY_PIPELINE__SHIFT                                              0x1c
#define PA_SC_BINNER_EVENT_CNTL_3__DRAW_DONE__SHIFT                                                           0x1e
#define PA_SC_BINNER_EVENT_CNTL_3__PS_DONE_MASK                                                               0x00000003L
#define PA_SC_BINNER_EVENT_CNTL_3__FLUSH_AND_INV_CB_PIXEL_DATA_MASK                                           0x0000000CL
#define PA_SC_BINNER_EVENT_CNTL_3__RESERVED_50_MASK                                                           0x00000030L
#define PA_SC_BINNER_EVENT_CNTL_3__THREAD_TRACE_START_MASK                                                    0x000000C0L
#define PA_SC_BINNER_EVENT_CNTL_3__THREAD_TRACE_STOP_MASK                                                     0x00000300L
#define PA_SC_BINNER_EVENT_CNTL_3__THREAD_TRACE_MARKER_MASK                                                   0x00000C00L
#define PA_SC_BINNER_EVENT_CNTL_3__THREAD_TRACE_DRAW_MASK                                                     0x00003000L
#define PA_SC_BINNER_EVENT_CNTL_3__THREAD_TRACE_FINISH_MASK                                                   0x0000C000L
#define PA_SC_BINNER_EVENT_CNTL_3__PIXEL_PIPE_STAT_CONTROL_MASK                                               0x00030000L
#define PA_SC_BINNER_EVENT_CNTL_3__PIXEL_PIPE_STAT_DUMP_MASK                                                  0x000C0000L
#define PA_SC_BINNER_EVENT_CNTL_3__PIXEL_PIPE_STAT_RESET_MASK                                                 0x00300000L
#define PA_SC_BINNER_EVENT_CNTL_3__CONTEXT_SUSPEND_MASK                                                       0x00C00000L
#define PA_SC_BINNER_EVENT_CNTL_3__OFFCHIP_HS_DEALLOC_MASK                                                    0x03000000L
#define PA_SC_BINNER_EVENT_CNTL_3__ENABLE_NGG_PIPELINE_MASK                                                   0x0C000000L
#define PA_SC_BINNER_EVENT_CNTL_3__ENABLE_LEGACY_PIPELINE_MASK                                                0x30000000L
#define PA_SC_BINNER_EVENT_CNTL_3__DRAW_DONE_MASK                                                             0xC0000000L
//PA_SC_BINNER_TIMEOUT_COUNTER
#define PA_SC_BINNER_TIMEOUT_COUNTER__THRESHOLD__SHIFT                                                        0x0
#define PA_SC_BINNER_TIMEOUT_COUNTER__THRESHOLD_MASK                                                          0xFFFFFFFFL
//PA_SC_BINNER_PERF_CNTL_0
#define PA_SC_BINNER_PERF_CNTL_0__BIN_HIST_NUM_PRIMS_THRESHOLD__SHIFT                                         0x0
#define PA_SC_BINNER_PERF_CNTL_0__BATCH_HIST_NUM_PRIMS_THRESHOLD__SHIFT                                       0xa
#define PA_SC_BINNER_PERF_CNTL_0__BIN_HIST_NUM_CONTEXT_THRESHOLD__SHIFT                                       0x14
#define PA_SC_BINNER_PERF_CNTL_0__BATCH_HIST_NUM_CONTEXT_THRESHOLD__SHIFT                                     0x17
#define PA_SC_BINNER_PERF_CNTL_0__BIN_HIST_NUM_PRIMS_THRESHOLD_MASK                                           0x000003FFL
#define PA_SC_BINNER_PERF_CNTL_0__BATCH_HIST_NUM_PRIMS_THRESHOLD_MASK                                         0x000FFC00L
#define PA_SC_BINNER_PERF_CNTL_0__BIN_HIST_NUM_CONTEXT_THRESHOLD_MASK                                         0x00700000L
#define PA_SC_BINNER_PERF_CNTL_0__BATCH_HIST_NUM_CONTEXT_THRESHOLD_MASK                                       0x03800000L
//PA_SC_BINNER_PERF_CNTL_1
#define PA_SC_BINNER_PERF_CNTL_1__BIN_HIST_NUM_PERSISTENT_STATE_THRESHOLD__SHIFT                              0x0
#define PA_SC_BINNER_PERF_CNTL_1__BATCH_HIST_NUM_PERSISTENT_STATE_THRESHOLD__SHIFT                            0x5
#define PA_SC_BINNER_PERF_CNTL_1__BATCH_HIST_NUM_TRIV_REJECTED_PRIMS_THRESHOLD__SHIFT                         0xa
#define PA_SC_BINNER_PERF_CNTL_1__BIN_HIST_NUM_PERSISTENT_STATE_THRESHOLD_MASK                                0x0000001FL
#define PA_SC_BINNER_PERF_CNTL_1__BATCH_HIST_NUM_PERSISTENT_STATE_THRESHOLD_MASK                              0x000003E0L
#define PA_SC_BINNER_PERF_CNTL_1__BATCH_HIST_NUM_TRIV_REJECTED_PRIMS_THRESHOLD_MASK                           0x03FFFC00L
//PA_SC_BINNER_PERF_CNTL_2
#define PA_SC_BINNER_PERF_CNTL_2__BATCH_HIST_NUM_ROWS_PER_PRIM_THRESHOLD__SHIFT                               0x0
#define PA_SC_BINNER_PERF_CNTL_2__BATCH_HIST_NUM_COLUMNS_PER_ROW_THRESHOLD__SHIFT                             0xb
#define PA_SC_BINNER_PERF_CNTL_2__BATCH_HIST_NUM_ROWS_PER_PRIM_THRESHOLD_MASK                                 0x000007FFL
#define PA_SC_BINNER_PERF_CNTL_2__BATCH_HIST_NUM_COLUMNS_PER_ROW_THRESHOLD_MASK                               0x003FF800L
//PA_SC_BINNER_PERF_CNTL_3
#define PA_SC_BINNER_PERF_CNTL_3__BATCH_HIST_NUM_PS_WAVE_BREAKS_THRESHOLD__SHIFT                              0x0
#define PA_SC_BINNER_PERF_CNTL_3__BATCH_HIST_NUM_PS_WAVE_BREAKS_THRESHOLD_MASK                                0xFFFFFFFFL
//PA_SC_ENHANCE_2
#define PA_SC_ENHANCE_2__DISABLE_SC_MEM_MACRO_FINE_CLOCK_GATE__SHIFT                                          0x0
#define PA_SC_ENHANCE_2__DISABLE_SC_DB_QUAD_INTF_FINE_CLOCK_GATE__SHIFT                                       0x1
#define PA_SC_ENHANCE_2__DISABLE_SC_BCI_QUAD_INTF_FINE_CLOCK_GATE__SHIFT                                      0x2
#define PA_SC_ENHANCE_2__DISABLE_SC_BCI_PRIM_INTF_FINE_CLOCK_GATE__SHIFT                                      0x3
#define PA_SC_ENHANCE_2__ENABLE_LPOV_WAVE_BREAK__SHIFT                                                        0x4
#define PA_SC_ENHANCE_2__ENABLE_FPOV_WAVE_BREAK__SHIFT                                                        0x5
#define PA_SC_ENHANCE_2__ENABLE_SC_SEND_DB_VPZ_FOR_EN_PRIM_PAYLOAD__SHIFT                                     0x7
#define PA_SC_ENHANCE_2__DISABLE_BREAK_BATCH_ON_GFX_PIPE_SWITCH__SHIFT                                        0x8
#define PA_SC_ENHANCE_2__DISABLE_FULL_TILE_WAVE_BREAK__SHIFT                                                  0x9
#define PA_SC_ENHANCE_2__ENABLE_VPZ_INJECTION_BEFORE_NULL_PRIMS__SHIFT                                        0xa
#define PA_SC_ENHANCE_2__PBB_TIMEOUT_THRESHOLD_MODE__SHIFT                                                    0xb
#define PA_SC_ENHANCE_2__DISABLE_PACKER_GRAD_FDCE_ENHANCE__SHIFT                                              0xc
#define PA_SC_ENHANCE_2__DISABLE_SC_SPI_INTF_EARLY_WAKEUP__SHIFT                                              0xd
#define PA_SC_ENHANCE_2__DISABLE_SC_BCI_INTF_EARLY_WAKEUP__SHIFT                                              0xe
#define PA_SC_ENHANCE_2__DISABLE_EXPOSED_GT_DETAIL_RATE_TILE_COV_ADJ__SHIFT                                   0xf
#define PA_SC_ENHANCE_2__PBB_WARP_CLK_MAIN_CLK_WAKEUP__SHIFT                                                  0x10
#define PA_SC_ENHANCE_2__PBB_MAIN_CLK_REG_BUSY_WAKEUP__SHIFT                                                  0x11
#define PA_SC_ENHANCE_2__DISABLE_BREAK_BATCH_ON_GFX_PIPELINE_RESET__SHIFT                                     0x12
#define PA_SC_ENHANCE_2__ENABLE_BLOCKING_WRITES_OF_GEN1_REG__SHIFT                                            0x13
#define PA_SC_ENHANCE_2__ENABLE_BLOCKING_WRITES_OF_GEN2_REG__SHIFT                                            0x14
#define PA_SC_ENHANCE_2__DISABLE_SC_DBR_DATAPATH_FGCG__SHIFT                                                  0x15
#define PA_SC_ENHANCE_2__PROCESS_RESET_FORCE_STILE_MASK_TO_ZERO__SHIFT                                        0x17
#define PA_SC_ENHANCE_2__DISABLE_PBB_EOP_INSERTION_FOR_MIXED_BINNING_AND_IMMEDIATE__SHIFT                     0x18
#define PA_SC_ENHANCE_2__DISABLE_DFSM_FLUSH__SHIFT                                                            0x19
#define PA_SC_ENHANCE_2__BREAK_WHEN_ONE_NULL_PRIM_BATCH__SHIFT                                                0x1a
#define PA_SC_ENHANCE_2__NULL_PRIM_BREAK_BATCH_LIMIT__SHIFT                                                   0x1b
#define PA_SC_ENHANCE_2__DISABLE_MAX_DEALLOC_FORCE_EOV_RESET_N_WAVES_COUNT__SHIFT                             0x1e
#define PA_SC_ENHANCE_2__RSVD__SHIFT                                                                          0x1f
#define PA_SC_ENHANCE_2__DISABLE_SC_MEM_MACRO_FINE_CLOCK_GATE_MASK                                            0x00000001L
#define PA_SC_ENHANCE_2__DISABLE_SC_DB_QUAD_INTF_FINE_CLOCK_GATE_MASK                                         0x00000002L
#define PA_SC_ENHANCE_2__DISABLE_SC_BCI_QUAD_INTF_FINE_CLOCK_GATE_MASK                                        0x00000004L
#define PA_SC_ENHANCE_2__DISABLE_SC_BCI_PRIM_INTF_FINE_CLOCK_GATE_MASK                                        0x00000008L
#define PA_SC_ENHANCE_2__ENABLE_LPOV_WAVE_BREAK_MASK                                                          0x00000010L
#define PA_SC_ENHANCE_2__ENABLE_FPOV_WAVE_BREAK_MASK                                                          0x00000020L
#define PA_SC_ENHANCE_2__ENABLE_SC_SEND_DB_VPZ_FOR_EN_PRIM_PAYLOAD_MASK                                       0x00000080L
#define PA_SC_ENHANCE_2__DISABLE_BREAK_BATCH_ON_GFX_PIPE_SWITCH_MASK                                          0x00000100L
#define PA_SC_ENHANCE_2__DISABLE_FULL_TILE_WAVE_BREAK_MASK                                                    0x00000200L
#define PA_SC_ENHANCE_2__ENABLE_VPZ_INJECTION_BEFORE_NULL_PRIMS_MASK                                          0x00000400L
#define PA_SC_ENHANCE_2__PBB_TIMEOUT_THRESHOLD_MODE_MASK                                                      0x00000800L
#define PA_SC_ENHANCE_2__DISABLE_PACKER_GRAD_FDCE_ENHANCE_MASK                                                0x00001000L
#define PA_SC_ENHANCE_2__DISABLE_SC_SPI_INTF_EARLY_WAKEUP_MASK                                                0x00002000L
#define PA_SC_ENHANCE_2__DISABLE_SC_BCI_INTF_EARLY_WAKEUP_MASK                                                0x00004000L
#define PA_SC_ENHANCE_2__DISABLE_EXPOSED_GT_DETAIL_RATE_TILE_COV_ADJ_MASK                                     0x00008000L
#define PA_SC_ENHANCE_2__PBB_WARP_CLK_MAIN_CLK_WAKEUP_MASK                                                    0x00010000L
#define PA_SC_ENHANCE_2__PBB_MAIN_CLK_REG_BUSY_WAKEUP_MASK                                                    0x00020000L
#define PA_SC_ENHANCE_2__DISABLE_BREAK_BATCH_ON_GFX_PIPELINE_RESET_MASK                                       0x00040000L
#define PA_SC_ENHANCE_2__ENABLE_BLOCKING_WRITES_OF_GEN1_REG_MASK                                              0x00080000L
#define PA_SC_ENHANCE_2__ENABLE_BLOCKING_WRITES_OF_GEN2_REG_MASK                                              0x00100000L
#define PA_SC_ENHANCE_2__DISABLE_SC_DBR_DATAPATH_FGCG_MASK                                                    0x00200000L
#define PA_SC_ENHANCE_2__PROCESS_RESET_FORCE_STILE_MASK_TO_ZERO_MASK                                          0x00800000L
#define PA_SC_ENHANCE_2__DISABLE_PBB_EOP_INSERTION_FOR_MIXED_BINNING_AND_IMMEDIATE_MASK                       0x01000000L
#define PA_SC_ENHANCE_2__DISABLE_DFSM_FLUSH_MASK                                                              0x02000000L
#define PA_SC_ENHANCE_2__BREAK_WHEN_ONE_NULL_PRIM_BATCH_MASK                                                  0x04000000L
#define PA_SC_ENHANCE_2__NULL_PRIM_BREAK_BATCH_LIMIT_MASK                                                     0x38000000L
#define PA_SC_ENHANCE_2__DISABLE_MAX_DEALLOC_FORCE_EOV_RESET_N_WAVES_COUNT_MASK                               0x40000000L
#define PA_SC_ENHANCE_2__RSVD_MASK                                                                            0x80000000L
//PA_SC_ENHANCE_INTERNAL
//PA_SC_BINNER_CNTL_OVERRIDE
#define PA_SC_BINNER_CNTL_OVERRIDE__BINNING_MODE__SHIFT                                                       0x0
#define PA_SC_BINNER_CNTL_OVERRIDE__CONTEXT_STATES_PER_BIN__SHIFT                                             0xa
#define PA_SC_BINNER_CNTL_OVERRIDE__PERSISTENT_STATES_PER_BIN__SHIFT                                          0xd
#define PA_SC_BINNER_CNTL_OVERRIDE__FPOVS_PER_BATCH__SHIFT                                                    0x13
#define PA_SC_BINNER_CNTL_OVERRIDE__DIRECT_OVERRIDE_MODE__SHIFT                                               0x1b
#define PA_SC_BINNER_CNTL_OVERRIDE__OVERRIDE__SHIFT                                                           0x1c
#define PA_SC_BINNER_CNTL_OVERRIDE__BINNING_MODE_MASK                                                         0x00000003L
#define PA_SC_BINNER_CNTL_OVERRIDE__CONTEXT_STATES_PER_BIN_MASK                                               0x00001C00L
#define PA_SC_BINNER_CNTL_OVERRIDE__PERSISTENT_STATES_PER_BIN_MASK                                            0x0003E000L
#define PA_SC_BINNER_CNTL_OVERRIDE__FPOVS_PER_BATCH_MASK                                                      0x07F80000L
#define PA_SC_BINNER_CNTL_OVERRIDE__DIRECT_OVERRIDE_MODE_MASK                                                 0x08000000L
#define PA_SC_BINNER_CNTL_OVERRIDE__OVERRIDE_MASK                                                             0xF0000000L
//PA_SC_PBB_OVERRIDE_FLAG
#define PA_SC_PBB_OVERRIDE_FLAG__OVERRIDE__SHIFT                                                              0x0
#define PA_SC_PBB_OVERRIDE_FLAG__PIPE_ID__SHIFT                                                               0x1
#define PA_SC_PBB_OVERRIDE_FLAG__OVERRIDE_MASK                                                                0x00000001L
#define PA_SC_PBB_OVERRIDE_FLAG__PIPE_ID_MASK                                                                 0x00000002L
//PA_PH_INTERFACE_FIFO_SIZE
#define PA_PH_INTERFACE_FIFO_SIZE__PA_PH_IF_FIFO_SIZE__SHIFT                                                  0x0
#define PA_PH_INTERFACE_FIFO_SIZE__PH_SC_IF_FIFO_SIZE__SHIFT                                                  0x10
#define PA_PH_INTERFACE_FIFO_SIZE__PA_PH_IF_FIFO_SIZE_MASK                                                    0x000003FFL
#define PA_PH_INTERFACE_FIFO_SIZE__PH_SC_IF_FIFO_SIZE_MASK                                                    0x003F0000L
//PA_PH_ENHANCE
#define PA_PH_ENHANCE__ECO_SPARE0__SHIFT                                                                      0x0
#define PA_PH_ENHANCE__ECO_SPARE1__SHIFT                                                                      0x1
#define PA_PH_ENHANCE__ECO_SPARE2__SHIFT                                                                      0x2
#define PA_PH_ENHANCE__ECO_SPARE3__SHIFT                                                                      0x3
#define PA_PH_ENHANCE__DISABLE_PH_SC_INTF_FINE_CLOCK_GATE__SHIFT                                              0x4
#define PA_PH_ENHANCE__DISABLE_FOPKT__SHIFT                                                                   0x5
#define PA_PH_ENHANCE__DISABLE_FOPKT_SCAN_POST_RESET__SHIFT                                                   0x6
#define PA_PH_ENHANCE__DISABLE_PH_SC_INTF_CLKEN_CLOCK_GATE__SHIFT                                             0x7
#define PA_PH_ENHANCE__DISABLE_PH_PERF_REG_FGCG__SHIFT                                                        0x9
#define PA_PH_ENHANCE__ENABLE_PH_INTF_CLKEN_STRETCH__SHIFT                                                    0xa
#define PA_PH_ENHANCE__DISABLE_USE_LAST_PH_ARBITER_PERFCOUNTER_SAMPLE_EVENT__SHIFT                            0xd
#define PA_PH_ENHANCE__ECO_SPARE0_MASK                                                                        0x00000001L
#define PA_PH_ENHANCE__ECO_SPARE1_MASK                                                                        0x00000002L
#define PA_PH_ENHANCE__ECO_SPARE2_MASK                                                                        0x00000004L
#define PA_PH_ENHANCE__ECO_SPARE3_MASK                                                                        0x00000008L
#define PA_PH_ENHANCE__DISABLE_PH_SC_INTF_FINE_CLOCK_GATE_MASK                                                0x00000010L
#define PA_PH_ENHANCE__DISABLE_FOPKT_MASK                                                                     0x00000020L
#define PA_PH_ENHANCE__DISABLE_FOPKT_SCAN_POST_RESET_MASK                                                     0x00000040L
#define PA_PH_ENHANCE__DISABLE_PH_SC_INTF_CLKEN_CLOCK_GATE_MASK                                               0x00000080L
#define PA_PH_ENHANCE__DISABLE_PH_PERF_REG_FGCG_MASK                                                          0x00000200L
#define PA_PH_ENHANCE__ENABLE_PH_INTF_CLKEN_STRETCH_MASK                                                      0x00001C00L
#define PA_PH_ENHANCE__DISABLE_USE_LAST_PH_ARBITER_PERFCOUNTER_SAMPLE_EVENT_MASK                              0x00002000L
//PA_SC_BC_WAVE_BREAK
#define PA_SC_BC_WAVE_BREAK__MAX_DEALLOCS_IN_WAVE__SHIFT                                                      0x0
#define PA_SC_BC_WAVE_BREAK__MAX_FPOVS_IN_WAVE__SHIFT                                                         0x10
#define PA_SC_BC_WAVE_BREAK__MAX_DEALLOCS_IN_WAVE_MASK                                                        0x000007FFL
#define PA_SC_BC_WAVE_BREAK__MAX_FPOVS_IN_WAVE_MASK                                                           0x00FF0000L
//PA_SC_ENHANCE_3
#define PA_SC_ENHANCE_3__FORCE_USE_OF_SC_CENTROID_DATA__SHIFT                                                 0x0
#define PA_SC_ENHANCE_3__DISABLE_RB_MASK_COPY_FOR_NONP2_SA_HARVEST__SHIFT                                     0x2
#define PA_SC_ENHANCE_3__FORCE_PBB_WORKLOAD_MODE_TO_ZERO__SHIFT                                               0x3
#define PA_SC_ENHANCE_3__DISABLE_PKR_BCI_QUAD_NEW_PRIM_DATA_LOAD_OPTIMIZATION__SHIFT                          0x4
#define PA_SC_ENHANCE_3__DISABLE_CP_CONTEXT_DONE_PERFCOUNT_SAMPLE_EN__SHIFT                                   0x5
#define PA_SC_ENHANCE_3__RSVD__SHIFT                                                                          0x6
#define PA_SC_ENHANCE_3__FORCE_USE_OF_SC_CENTROID_DATA_MASK                                                   0x00000001L
#define PA_SC_ENHANCE_3__DISABLE_RB_MASK_COPY_FOR_NONP2_SA_HARVEST_MASK                                       0x00000004L
#define PA_SC_ENHANCE_3__FORCE_PBB_WORKLOAD_MODE_TO_ZERO_MASK                                                 0x00000008L
#define PA_SC_ENHANCE_3__DISABLE_PKR_BCI_QUAD_NEW_PRIM_DATA_LOAD_OPTIMIZATION_MASK                            0x00000010L
#define PA_SC_ENHANCE_3__DISABLE_CP_CONTEXT_DONE_PERFCOUNT_SAMPLE_EN_MASK                                     0x00000020L
#define PA_SC_ENHANCE_3__RSVD_MASK                                                                            0xFFFFFFC0L
//PA_SC_FIFO_SIZE
#define PA_SC_FIFO_SIZE__SC_FRONTEND_PRIM_FIFO_SIZE__SHIFT                                                    0x0
#define PA_SC_FIFO_SIZE__SC_BACKEND_PRIM_FIFO_SIZE__SHIFT                                                     0x6
#define PA_SC_FIFO_SIZE__SC_HIZ_TILE_FIFO_SIZE__SHIFT                                                         0xf
#define PA_SC_FIFO_SIZE__SC_EARLYZ_TILE_FIFO_SIZE__SHIFT                                                      0x15
#define PA_SC_FIFO_SIZE__SC_FRONTEND_PRIM_FIFO_SIZE_MASK                                                      0x0000003FL
#define PA_SC_FIFO_SIZE__SC_BACKEND_PRIM_FIFO_SIZE_MASK                                                       0x00007FC0L
#define PA_SC_FIFO_SIZE__SC_HIZ_TILE_FIFO_SIZE_MASK                                                           0x001F8000L
#define PA_SC_FIFO_SIZE__SC_EARLYZ_TILE_FIFO_SIZE_MASK                                                        0xFFE00000L
//PA_SC_IF_FIFO_SIZE
#define PA_SC_IF_FIFO_SIZE__SC_DB_TILE_IF_FIFO_SIZE__SHIFT                                                    0x0
#define PA_SC_IF_FIFO_SIZE__SC_DB_QUAD_IF_FIFO_SIZE__SHIFT                                                    0x6
#define PA_SC_IF_FIFO_SIZE__SC_SPI_IF_FIFO_SIZE__SHIFT                                                        0xc
#define PA_SC_IF_FIFO_SIZE__SC_BCI_IF_FIFO_SIZE__SHIFT                                                        0x12
#define PA_SC_IF_FIFO_SIZE__SC_DB_TILE_IF_FIFO_SIZE_MASK                                                      0x0000003FL
#define PA_SC_IF_FIFO_SIZE__SC_DB_QUAD_IF_FIFO_SIZE_MASK                                                      0x00000FC0L
#define PA_SC_IF_FIFO_SIZE__SC_SPI_IF_FIFO_SIZE_MASK                                                          0x0003F000L
#define PA_SC_IF_FIFO_SIZE__SC_BCI_IF_FIFO_SIZE_MASK                                                          0x00FC0000L
//PA_SC_PKR_WAVE_TABLE_CNTL
#define PA_SC_PKR_WAVE_TABLE_CNTL__SIZE__SHIFT                                                                0x0
#define PA_SC_PKR_WAVE_TABLE_CNTL__SIZE_MASK                                                                  0x0000003FL
//PA_SIDEBAND_REQUEST_DELAYS
#define PA_SIDEBAND_REQUEST_DELAYS__RETRY_DELAY__SHIFT                                                        0x0
#define PA_SIDEBAND_REQUEST_DELAYS__INITIAL_DELAY__SHIFT                                                      0x10
#define PA_SIDEBAND_REQUEST_DELAYS__RETRY_DELAY_MASK                                                          0x0000FFFFL
#define PA_SIDEBAND_REQUEST_DELAYS__INITIAL_DELAY_MASK                                                        0xFFFF0000L
//PA_SC_ENHANCE
#define PA_SC_ENHANCE__ENABLE_PA_SC_OUT_OF_ORDER__SHIFT                                                       0x0
#define PA_SC_ENHANCE__DISABLE_SC_DB_TILE_FIX__SHIFT                                                          0x1
#define PA_SC_ENHANCE__DISABLE_AA_MASK_FULL_FIX__SHIFT                                                        0x2
#define PA_SC_ENHANCE__ENABLE_1XMSAA_SAMPLE_LOCATIONS__SHIFT                                                  0x3
#define PA_SC_ENHANCE__ENABLE_1XMSAA_SAMPLE_LOC_CENTROID__SHIFT                                               0x4
#define PA_SC_ENHANCE__DISABLE_SCISSOR_FIX__SHIFT                                                             0x5
#define PA_SC_ENHANCE__SEND_UNLIT_STILES_TO_PACKER__SHIFT                                                     0x6
#define PA_SC_ENHANCE__DISABLE_DUALGRAD_PERF_OPTIMIZATION__SHIFT                                              0x7
#define PA_SC_ENHANCE__DISABLE_SC_PROCESS_RESET_PRIM__SHIFT                                                   0x8
#define PA_SC_ENHANCE__DISABLE_SC_PROCESS_RESET_SUPERTILE__SHIFT                                              0x9
#define PA_SC_ENHANCE__DISABLE_SC_PROCESS_RESET_TILE__SHIFT                                                   0xa
#define PA_SC_ENHANCE__DISABLE_PA_SC_GUIDANCE__SHIFT                                                          0xb
#define PA_SC_ENHANCE__DISABLE_EOV_ALL_CTRL_ONLY_COMBINATIONS__SHIFT                                          0xc
#define PA_SC_ENHANCE__ENABLE_MULTICYCLE_BUBBLE_FREEZE__SHIFT                                                 0xd
#define PA_SC_ENHANCE__DISABLE_OUT_OF_ORDER_PA_SC_GUIDANCE__SHIFT                                             0xe
#define PA_SC_ENHANCE__ENABLE_OUT_OF_ORDER_POLY_MODE__SHIFT                                                   0xf
#define PA_SC_ENHANCE__DISABLE_OUT_OF_ORDER_EOP_SYNC_NULL_PRIMS_LAST__SHIFT                                   0x10
#define PA_SC_ENHANCE__DISABLE_OUT_OF_ORDER_THRESHOLD_SWITCHING__SHIFT                                        0x11
#define PA_SC_ENHANCE__ENABLE_OUT_OF_ORDER_THRESHOLD_SWITCH_AT_EOPG_ONLY__SHIFT                               0x12
#define PA_SC_ENHANCE__DISABLE_OUT_OF_ORDER_DESIRED_FIFO_EMPTY_SWITCHING__SHIFT                               0x13
#define PA_SC_ENHANCE__DISABLE_OUT_OF_ORDER_SELECTED_FIFO_EMPTY_SWITCHING__SHIFT                              0x14
#define PA_SC_ENHANCE__DISABLE_OUT_OF_ORDER_EMPTY_SWITCHING_HYSTERYSIS__SHIFT                                 0x15
#define PA_SC_ENHANCE__ENABLE_OUT_OF_ORDER_DESIRED_FIFO_IS_NEXT_FEID__SHIFT                                   0x16
#define PA_SC_ENHANCE__DISABLE_OOO_NO_EOPG_SKEW_DESIRED_FIFO_IS_CURRENT_FIFO__SHIFT                           0x17
#define PA_SC_ENHANCE__OOO_DISABLE_EOP_ON_FIRST_LIVE_PRIM_HIT__SHIFT                                          0x18
#define PA_SC_ENHANCE__OOO_DISABLE_EOPG_SKEW_THRESHOLD_SWITCHING__SHIFT                                       0x19
#define PA_SC_ENHANCE__DISABLE_EOP_LINE_STIPPLE_RESET__SHIFT                                                  0x1a
#define PA_SC_ENHANCE__DISABLE_VPZ_EOP_LINE_STIPPLE_RESET__SHIFT                                              0x1b
#define PA_SC_ENHANCE__IOO_DISABLE_SCAN_UNSELECTED_FIFOS_FOR_DUAL_GFX_RING_CHANGE__SHIFT                      0x1c
#define PA_SC_ENHANCE__OOO_USE_ABSOLUTE_FIFO_COUNT_IN_THRESHOLD_SWITCHING__SHIFT                              0x1d
#define PA_SC_ENHANCE__ENABLE_PA_SC_OUT_OF_ORDER_MASK                                                         0x00000001L
#define PA_SC_ENHANCE__DISABLE_SC_DB_TILE_FIX_MASK                                                            0x00000002L
#define PA_SC_ENHANCE__DISABLE_AA_MASK_FULL_FIX_MASK                                                          0x00000004L
#define PA_SC_ENHANCE__ENABLE_1XMSAA_SAMPLE_LOCATIONS_MASK                                                    0x00000008L
#define PA_SC_ENHANCE__ENABLE_1XMSAA_SAMPLE_LOC_CENTROID_MASK                                                 0x00000010L
#define PA_SC_ENHANCE__DISABLE_SCISSOR_FIX_MASK                                                               0x00000020L
#define PA_SC_ENHANCE__SEND_UNLIT_STILES_TO_PACKER_MASK                                                       0x00000040L
#define PA_SC_ENHANCE__DISABLE_DUALGRAD_PERF_OPTIMIZATION_MASK                                                0x00000080L
#define PA_SC_ENHANCE__DISABLE_SC_PROCESS_RESET_PRIM_MASK                                                     0x00000100L
#define PA_SC_ENHANCE__DISABLE_SC_PROCESS_RESET_SUPERTILE_MASK                                                0x00000200L
#define PA_SC_ENHANCE__DISABLE_SC_PROCESS_RESET_TILE_MASK                                                     0x00000400L
#define PA_SC_ENHANCE__DISABLE_PA_SC_GUIDANCE_MASK                                                            0x00000800L
#define PA_SC_ENHANCE__DISABLE_EOV_ALL_CTRL_ONLY_COMBINATIONS_MASK                                            0x00001000L
#define PA_SC_ENHANCE__ENABLE_MULTICYCLE_BUBBLE_FREEZE_MASK                                                   0x00002000L
#define PA_SC_ENHANCE__DISABLE_OUT_OF_ORDER_PA_SC_GUIDANCE_MASK                                               0x00004000L
#define PA_SC_ENHANCE__ENABLE_OUT_OF_ORDER_POLY_MODE_MASK                                                     0x00008000L
#define PA_SC_ENHANCE__DISABLE_OUT_OF_ORDER_EOP_SYNC_NULL_PRIMS_LAST_MASK                                     0x00010000L
#define PA_SC_ENHANCE__DISABLE_OUT_OF_ORDER_THRESHOLD_SWITCHING_MASK                                          0x00020000L
#define PA_SC_ENHANCE__ENABLE_OUT_OF_ORDER_THRESHOLD_SWITCH_AT_EOPG_ONLY_MASK                                 0x00040000L
#define PA_SC_ENHANCE__DISABLE_OUT_OF_ORDER_DESIRED_FIFO_EMPTY_SWITCHING_MASK                                 0x00080000L
#define PA_SC_ENHANCE__DISABLE_OUT_OF_ORDER_SELECTED_FIFO_EMPTY_SWITCHING_MASK                                0x00100000L
#define PA_SC_ENHANCE__DISABLE_OUT_OF_ORDER_EMPTY_SWITCHING_HYSTERYSIS_MASK                                   0x00200000L
#define PA_SC_ENHANCE__ENABLE_OUT_OF_ORDER_DESIRED_FIFO_IS_NEXT_FEID_MASK                                     0x00400000L
#define PA_SC_ENHANCE__DISABLE_OOO_NO_EOPG_SKEW_DESIRED_FIFO_IS_CURRENT_FIFO_MASK                             0x00800000L
#define PA_SC_ENHANCE__OOO_DISABLE_EOP_ON_FIRST_LIVE_PRIM_HIT_MASK                                            0x01000000L
#define PA_SC_ENHANCE__OOO_DISABLE_EOPG_SKEW_THRESHOLD_SWITCHING_MASK                                         0x02000000L
#define PA_SC_ENHANCE__DISABLE_EOP_LINE_STIPPLE_RESET_MASK                                                    0x04000000L
#define PA_SC_ENHANCE__DISABLE_VPZ_EOP_LINE_STIPPLE_RESET_MASK                                                0x08000000L
#define PA_SC_ENHANCE__IOO_DISABLE_SCAN_UNSELECTED_FIFOS_FOR_DUAL_GFX_RING_CHANGE_MASK                        0x10000000L
#define PA_SC_ENHANCE__OOO_USE_ABSOLUTE_FIFO_COUNT_IN_THRESHOLD_SWITCHING_MASK                                0x20000000L
//PA_SC_ENHANCE_1
#define PA_SC_ENHANCE_1__REALIGN_DQUADS_OVERRIDE_ENABLE__SHIFT                                                0x0
#define PA_SC_ENHANCE_1__REALIGN_DQUADS_OVERRIDE__SHIFT                                                       0x1
#define PA_SC_ENHANCE_1__DISABLE_SC_BINNING__SHIFT                                                            0x3
#define PA_SC_ENHANCE_1__BYPASS_PBB__SHIFT                                                                    0x4
#define PA_SC_ENHANCE_1__ECO_SPARE0__SHIFT                                                                    0x5
#define PA_SC_ENHANCE_1__ECO_SPARE1__SHIFT                                                                    0x6
#define PA_SC_ENHANCE_1__ECO_SPARE2__SHIFT                                                                    0x7
#define PA_SC_ENHANCE_1__ECO_SPARE3__SHIFT                                                                    0x8
#define PA_SC_ENHANCE_1__DISABLE_SC_PROCESS_RESET_PBB__SHIFT                                                  0x9
#define PA_SC_ENHANCE_1__DISABLE_PBB_SCISSOR_OPT__SHIFT                                                       0xa
#define PA_SC_ENHANCE_1__ENABLE_DFSM_FLUSH_EVENT_TO_FLUSH_POPS_CAM__SHIFT                                     0xb
#define PA_SC_ENHANCE_1__DISABLE_SC_DB_TILE_INTF_FINE_CLOCK_GATE__SHIFT                                       0xe
#define PA_SC_ENHANCE_1__DISABLE_SC_PIPELINE_RESET_LEGACY_MODE_TRANSITION__SHIFT                              0xf
#define PA_SC_ENHANCE_1__DISABLE_PACKER_ODC_ENHANCE__SHIFT                                                    0x10
#define PA_SC_ENHANCE_1__OPTIMAL_BIN_SELECTION__SHIFT                                                         0x12
#define PA_SC_ENHANCE_1__DISABLE_FORCE_SOP_ALL_EVENTS__SHIFT                                                  0x13
#define PA_SC_ENHANCE_1__DISABLE_PBB_CLK_OPTIMIZATION__SHIFT                                                  0x14
#define PA_SC_ENHANCE_1__DISABLE_PBB_SCISSOR_CLK_OPTIMIZATION__SHIFT                                          0x15
#define PA_SC_ENHANCE_1__DISABLE_PBB_BINNING_CLK_OPTIMIZATION__SHIFT                                          0x16
#define PA_SC_ENHANCE_1__DISABLE_INTF_CG__SHIFT                                                               0x17
#define PA_SC_ENHANCE_1__IOO_DISABLE_EOP_ON_FIRST_LIVE_PRIM_HIT__SHIFT                                        0x18
#define PA_SC_ENHANCE_1__DISABLE_SHADER_PROFILING_FOR_POWER__SHIFT                                            0x19
#define PA_SC_ENHANCE_1__FLUSH_ON_BINNING_TRANSITION__SHIFT                                                   0x1a
#define PA_SC_ENHANCE_1__DISABLE_QUAD_PROC_FDCE_ENHANCE__SHIFT                                                0x1b
#define PA_SC_ENHANCE_1__DISABLE_SC_PS_PA_ARBITER_FIX__SHIFT                                                  0x1c
#define PA_SC_ENHANCE_1__DISABLE_SC_PS_PA_ARBITER_FIX_1__SHIFT                                                0x1d
#define PA_SC_ENHANCE_1__PASS_VPZ_EVENT_TO_SPI__SHIFT                                                         0x1e
#define PA_SC_ENHANCE_1__REALIGN_DQUADS_OVERRIDE_ENABLE_MASK                                                  0x00000001L
#define PA_SC_ENHANCE_1__REALIGN_DQUADS_OVERRIDE_MASK                                                         0x00000006L
#define PA_SC_ENHANCE_1__DISABLE_SC_BINNING_MASK                                                              0x00000008L
#define PA_SC_ENHANCE_1__BYPASS_PBB_MASK                                                                      0x00000010L
#define PA_SC_ENHANCE_1__ECO_SPARE0_MASK                                                                      0x00000020L
#define PA_SC_ENHANCE_1__ECO_SPARE1_MASK                                                                      0x00000040L
#define PA_SC_ENHANCE_1__ECO_SPARE2_MASK                                                                      0x00000080L
#define PA_SC_ENHANCE_1__ECO_SPARE3_MASK                                                                      0x00000100L
#define PA_SC_ENHANCE_1__DISABLE_SC_PROCESS_RESET_PBB_MASK                                                    0x00000200L
#define PA_SC_ENHANCE_1__DISABLE_PBB_SCISSOR_OPT_MASK                                                         0x00000400L
#define PA_SC_ENHANCE_1__ENABLE_DFSM_FLUSH_EVENT_TO_FLUSH_POPS_CAM_MASK                                       0x00000800L
#define PA_SC_ENHANCE_1__DISABLE_SC_DB_TILE_INTF_FINE_CLOCK_GATE_MASK                                         0x00004000L
#define PA_SC_ENHANCE_1__DISABLE_SC_PIPELINE_RESET_LEGACY_MODE_TRANSITION_MASK                                0x00008000L
#define PA_SC_ENHANCE_1__DISABLE_PACKER_ODC_ENHANCE_MASK                                                      0x00010000L
#define PA_SC_ENHANCE_1__OPTIMAL_BIN_SELECTION_MASK                                                           0x00040000L
#define PA_SC_ENHANCE_1__DISABLE_FORCE_SOP_ALL_EVENTS_MASK                                                    0x00080000L
#define PA_SC_ENHANCE_1__DISABLE_PBB_CLK_OPTIMIZATION_MASK                                                    0x00100000L
#define PA_SC_ENHANCE_1__DISABLE_PBB_SCISSOR_CLK_OPTIMIZATION_MASK                                            0x00200000L
#define PA_SC_ENHANCE_1__DISABLE_PBB_BINNING_CLK_OPTIMIZATION_MASK                                            0x00400000L
#define PA_SC_ENHANCE_1__DISABLE_INTF_CG_MASK                                                                 0x00800000L
#define PA_SC_ENHANCE_1__IOO_DISABLE_EOP_ON_FIRST_LIVE_PRIM_HIT_MASK                                          0x01000000L
#define PA_SC_ENHANCE_1__DISABLE_SHADER_PROFILING_FOR_POWER_MASK                                              0x02000000L
#define PA_SC_ENHANCE_1__FLUSH_ON_BINNING_TRANSITION_MASK                                                     0x04000000L
#define PA_SC_ENHANCE_1__DISABLE_QUAD_PROC_FDCE_ENHANCE_MASK                                                  0x08000000L
#define PA_SC_ENHANCE_1__DISABLE_SC_PS_PA_ARBITER_FIX_MASK                                                    0x10000000L
#define PA_SC_ENHANCE_1__DISABLE_SC_PS_PA_ARBITER_FIX_1_MASK                                                  0x20000000L
#define PA_SC_ENHANCE_1__PASS_VPZ_EVENT_TO_SPI_MASK                                                           0x40000000L
//PA_SC_DSM_CNTL
#define PA_SC_DSM_CNTL__FORCE_EOV_REZ_0__SHIFT                                                                0x0
#define PA_SC_DSM_CNTL__FORCE_EOV_REZ_1__SHIFT                                                                0x1
#define PA_SC_DSM_CNTL__FORCE_EOV_REZ_0_MASK                                                                  0x00000001L
#define PA_SC_DSM_CNTL__FORCE_EOV_REZ_1_MASK                                                                  0x00000002L
//PA_SC_TILE_STEERING_CREST_OVERRIDE
#define PA_SC_TILE_STEERING_CREST_OVERRIDE__ONE_RB_MODE_ENABLE__SHIFT                                         0x0
#define PA_SC_TILE_STEERING_CREST_OVERRIDE__SE_SELECT__SHIFT                                                  0x1
#define PA_SC_TILE_STEERING_CREST_OVERRIDE__RB_SELECT__SHIFT                                                  0x5
#define PA_SC_TILE_STEERING_CREST_OVERRIDE__SA_SELECT__SHIFT                                                  0x8
#define PA_SC_TILE_STEERING_CREST_OVERRIDE__FORCE_TILE_STEERING_OVERRIDE_USE__SHIFT                           0x1f
#define PA_SC_TILE_STEERING_CREST_OVERRIDE__ONE_RB_MODE_ENABLE_MASK                                           0x00000001L
#define PA_SC_TILE_STEERING_CREST_OVERRIDE__SE_SELECT_MASK                                                    0x00000006L
#define PA_SC_TILE_STEERING_CREST_OVERRIDE__RB_SELECT_MASK                                                    0x00000060L
#define PA_SC_TILE_STEERING_CREST_OVERRIDE__SA_SELECT_MASK                                                    0x00000700L
#define PA_SC_TILE_STEERING_CREST_OVERRIDE__FORCE_TILE_STEERING_OVERRIDE_USE_MASK                             0x80000000L


// addressBlock: gc_sqdec
//SQ_CONFIG
#define SQ_CONFIG__UNUSED__SHIFT                                                                              0x0
#define SQ_CONFIG__CHICKEN_BIT_DEGGIGXX0_8637__SHIFT                                                          0x5
#define SQ_CONFIG__UNUSED_6__SHIFT                                                                            0x6
#define SQ_CONFIG__DISABLE_SGPR_RD_KILL__SHIFT                                                                0xa
#define SQ_CONFIG__VGPR_SWIZZLE_EN__SHIFT                                                                     0xc
#define SQ_CONFIG__LDS_BUSY_HYSTERESIS_CNT__SHIFT                                                             0xd
#define SQ_CONFIG__SP_BUSY_HYSTERESIS_CNT__SHIFT                                                              0xf
#define SQ_CONFIG__ENABLE_HIPRIO_ON_EXP_RDY_VS__SHIFT                                                         0x12
#define SQ_CONFIG__PRIO_VAL_ON_EXP_RDY_VS__SHIFT                                                              0x13
#define SQ_CONFIG__WCLK_HYSTERESIS_CNT__SHIFT                                                                 0x15
#define SQ_CONFIG__DISABLE_SP_REDUNDANT_THREAD_GATING__SHIFT                                                  0x1d
#define SQ_CONFIG__TA_BUSY_HYSTERESIS_CNT__SHIFT                                                              0x1e
#define SQ_CONFIG__UNUSED_MASK                                                                                0x0000001FL
#define SQ_CONFIG__VGPR_SWIZZLE_EN_MASK                                                                       0x00001000L
#define SQ_CONFIG__LDS_BUSY_HYSTERESIS_CNT_MASK                                                               0x00006000L
#define SQ_CONFIG__SP_BUSY_HYSTERESIS_CNT_MASK                                                                0x00018000L
#define SQ_CONFIG__ENABLE_HIPRIO_ON_EXP_RDY_VS_MASK                                                           0x00040000L
#define SQ_CONFIG__PRIO_VAL_ON_EXP_RDY_VS_MASK                                                                0x00180000L
#define SQ_CONFIG__DISABLE_SP_REDUNDANT_THREAD_GATING_MASK                                                    0x20000000L
#define SQ_CONFIG__TA_BUSY_HYSTERESIS_CNT_MASK                                                                0xC0000000L
//SQC_CONFIG
#define SQC_CONFIG__INST_CACHE_SIZE__SHIFT                                                                    0x0
#define SQC_CONFIG__DATA_CACHE_SIZE__SHIFT                                                                    0x2
#define SQC_CONFIG__MISS_FIFO_DEPTH__SHIFT                                                                    0x4
#define SQC_CONFIG__HIT_FIFO_DEPTH__SHIFT                                                                     0x6
#define SQC_CONFIG__FORCE_ALWAYS_MISS__SHIFT                                                                  0x7
#define SQC_CONFIG__FORCE_IN_ORDER__SHIFT                                                                     0x8
#define SQC_CONFIG__PER_VMID_INV_DISABLE__SHIFT                                                               0xb
#define SQC_CONFIG__EVICT_LRU__SHIFT                                                                          0xc
#define SQC_CONFIG__FORCE_2_BANK__SHIFT                                                                       0xe
#define SQC_CONFIG__FORCE_1_BANK__SHIFT                                                                       0xf
#define SQC_CONFIG__LS_DISABLE_CLOCKS__SHIFT                                                                  0x10
#define SQC_CONFIG__INST_CACHE_SIZE_MASK                                                                      0x00000003L
#define SQC_CONFIG__DATA_CACHE_SIZE_MASK                                                                      0x0000000CL
#define SQC_CONFIG__MISS_FIFO_DEPTH_MASK                                                                      0x00000030L
#define SQC_CONFIG__HIT_FIFO_DEPTH_MASK                                                                       0x00000040L
#define SQC_CONFIG__FORCE_ALWAYS_MISS_MASK                                                                    0x00000080L
#define SQC_CONFIG__FORCE_IN_ORDER_MASK                                                                       0x00000100L
#define SQC_CONFIG__PER_VMID_INV_DISABLE_MASK                                                                 0x00000800L
#define SQC_CONFIG__EVICT_LRU_MASK                                                                            0x00003000L
#define SQC_CONFIG__FORCE_2_BANK_MASK                                                                         0x00004000L
#define SQC_CONFIG__FORCE_1_BANK_MASK                                                                         0x00008000L
#define SQC_CONFIG__LS_DISABLE_CLOCKS_MASK                                                                    0x00FF0000L
//LDS_CONFIG
#define LDS_CONFIG__ADDR_OUT_OF_RANGE_REPORTING__SHIFT                                                        0x0
#define LDS_CONFIG__VGPR_SWIZZLE_EN__SHIFT                                                                    0x1
#define LDS_CONFIG__WAVE32_INTERP_DUAL_ISSUE_DISABLE__SHIFT                                                   0x2
#define LDS_CONFIG__SP_TDDATA_FGCG_OVERRIDE__SHIFT                                                            0x3
#define LDS_CONFIG__SQC_PERF_FGCG_OVERRIDE__SHIFT                                                             0x4
#define LDS_CONFIG__CONF_BIT_5__SHIFT                                                                         0x5
#define LDS_CONFIG__CONF_BIT_6__SHIFT                                                                         0x6
#define LDS_CONFIG__CONF_BIT_7__SHIFT                                                                         0x7
#define LDS_CONFIG__CONF_BIT_8__SHIFT                                                                         0x8
#define LDS_CONFIG__ADDR_OUT_OF_RANGE_REPORTING_MASK                                                          0x00000001L
#define LDS_CONFIG__VGPR_SWIZZLE_EN_MASK                                                                      0x00000002L
#define LDS_CONFIG__WAVE32_INTERP_DUAL_ISSUE_DISABLE_MASK                                                     0x00000004L
#define LDS_CONFIG__SP_TDDATA_FGCG_OVERRIDE_MASK                                                              0x00000008L
#define LDS_CONFIG__SQC_PERF_FGCG_OVERRIDE_MASK                                                               0x00000010L
#define LDS_CONFIG__CONF_BIT_5_MASK                                                                           0x00000020L
#define LDS_CONFIG__CONF_BIT_6_MASK                                                                           0x00000040L
#define LDS_CONFIG__CONF_BIT_7_MASK                                                                           0x00000080L
#define LDS_CONFIG__CONF_BIT_8_MASK                                                                           0x00000100L
//SQ_RANDOM_WAVE_PRI
#define SQ_RANDOM_WAVE_PRI__RET__SHIFT                                                                        0x0
#define SQ_RANDOM_WAVE_PRI__RUI__SHIFT                                                                        0x7
#define SQ_RANDOM_WAVE_PRI__RNG__SHIFT                                                                        0xa
#define SQ_RANDOM_WAVE_PRI__FORCE_IB_ARB_PRIO_MSK_VALID__SHIFT                                                0x1f
#define SQ_RANDOM_WAVE_PRI__RET_MASK                                                                          0x0000007FL
#define SQ_RANDOM_WAVE_PRI__RUI_MASK                                                                          0x00000380L
#define SQ_RANDOM_WAVE_PRI__RNG_MASK                                                                          0x00FFFC00L
#define SQ_RANDOM_WAVE_PRI__FORCE_IB_ARB_PRIO_MSK_VALID_MASK                                                  0x80000000L
//SQG_STATUS
#define SQG_STATUS__REG_BUSY__SHIFT                                                                           0x0
#define SQG_STATUS__REG_BUSY_MASK                                                                             0x00000001L
//SQ_FIFO_SIZES
#define SQ_FIFO_SIZES__INTERRUPT_FIFO_SIZE__SHIFT                                                             0x0
#define SQ_FIFO_SIZES__TTRACE_FIFO_SIZE__SHIFT                                                                0x8
#define SQ_FIFO_SIZES__EXPORT_BUF_VS_RESERVED__SHIFT                                                          0xc
#define SQ_FIFO_SIZES__EXPORT_BUF_PS_RESERVED__SHIFT                                                          0xe
#define SQ_FIFO_SIZES__EXPORT_BUF_REDUCE__SHIFT                                                               0x10
#define SQ_FIFO_SIZES__VMEM_DATA_FIFO_SIZE__SHIFT                                                             0x12
#define SQ_FIFO_SIZES__INTERRUPT_FIFO_SIZE_MASK                                                               0x0000000FL
#define SQ_FIFO_SIZES__TTRACE_FIFO_SIZE_MASK                                                                  0x00000300L
#define SQ_FIFO_SIZES__EXPORT_BUF_VS_RESERVED_MASK                                                            0x00003000L
#define SQ_FIFO_SIZES__EXPORT_BUF_PS_RESERVED_MASK                                                            0x0000C000L
#define SQ_FIFO_SIZES__EXPORT_BUF_REDUCE_MASK                                                                 0x00030000L
#define SQ_FIFO_SIZES__VMEM_DATA_FIFO_SIZE_MASK                                                               0x000C0000L
//SQ_DSM_CNTL
#define SQ_DSM_CNTL__WAVEFRONT_STALL_0__SHIFT                                                                 0x0
#define SQ_DSM_CNTL__WAVEFRONT_STALL_1__SHIFT                                                                 0x1
#define SQ_DSM_CNTL__SPI_BACKPRESSURE_0__SHIFT                                                                0x2
#define SQ_DSM_CNTL__SPI_BACKPRESSURE_1__SHIFT                                                                0x3
#define SQ_DSM_CNTL__SEL_DSM_SGPR_IRRITATOR_DATA0__SHIFT                                                      0x8
#define SQ_DSM_CNTL__SEL_DSM_SGPR_IRRITATOR_DATA1__SHIFT                                                      0x9
#define SQ_DSM_CNTL__SGPR_ENABLE_SINGLE_WRITE__SHIFT                                                          0xa
#define SQ_DSM_CNTL__SEL_DSM_LDS_IRRITATOR_DATA0__SHIFT                                                       0x10
#define SQ_DSM_CNTL__SEL_DSM_LDS_IRRITATOR_DATA1__SHIFT                                                       0x11
#define SQ_DSM_CNTL__LDS_ENABLE_SINGLE_WRITE01__SHIFT                                                         0x12
#define SQ_DSM_CNTL__SEL_DSM_LDS_IRRITATOR_DATA2__SHIFT                                                       0x13
#define SQ_DSM_CNTL__SEL_DSM_LDS_IRRITATOR_DATA3__SHIFT                                                       0x14
#define SQ_DSM_CNTL__LDS_ENABLE_SINGLE_WRITE23__SHIFT                                                         0x15
#define SQ_DSM_CNTL__SEL_DSM_SP_IRRITATOR_DATA0__SHIFT                                                        0x18
#define SQ_DSM_CNTL__SEL_DSM_SP_IRRITATOR_DATA1__SHIFT                                                        0x19
#define SQ_DSM_CNTL__SP_ENABLE_SINGLE_WRITE__SHIFT                                                            0x1a
#define SQ_DSM_CNTL__WAVEFRONT_STALL_0_MASK                                                                   0x00000001L
#define SQ_DSM_CNTL__WAVEFRONT_STALL_1_MASK                                                                   0x00000002L
#define SQ_DSM_CNTL__SPI_BACKPRESSURE_0_MASK                                                                  0x00000004L
#define SQ_DSM_CNTL__SPI_BACKPRESSURE_1_MASK                                                                  0x00000008L
#define SQ_DSM_CNTL__SEL_DSM_SGPR_IRRITATOR_DATA0_MASK                                                        0x00000100L
#define SQ_DSM_CNTL__SEL_DSM_SGPR_IRRITATOR_DATA1_MASK                                                        0x00000200L
#define SQ_DSM_CNTL__SGPR_ENABLE_SINGLE_WRITE_MASK                                                            0x00000400L
#define SQ_DSM_CNTL__SEL_DSM_LDS_IRRITATOR_DATA0_MASK                                                         0x00010000L
#define SQ_DSM_CNTL__SEL_DSM_LDS_IRRITATOR_DATA1_MASK                                                         0x00020000L
#define SQ_DSM_CNTL__LDS_ENABLE_SINGLE_WRITE01_MASK                                                           0x00040000L
#define SQ_DSM_CNTL__SEL_DSM_LDS_IRRITATOR_DATA2_MASK                                                         0x00080000L
#define SQ_DSM_CNTL__SEL_DSM_LDS_IRRITATOR_DATA3_MASK                                                         0x00100000L
#define SQ_DSM_CNTL__LDS_ENABLE_SINGLE_WRITE23_MASK                                                           0x00200000L
#define SQ_DSM_CNTL__SEL_DSM_SP_IRRITATOR_DATA0_MASK                                                          0x01000000L
#define SQ_DSM_CNTL__SEL_DSM_SP_IRRITATOR_DATA1_MASK                                                          0x02000000L
#define SQ_DSM_CNTL__SP_ENABLE_SINGLE_WRITE_MASK                                                              0x04000000L
//SQ_DSM_CNTL2
#define SQ_DSM_CNTL2__SGPR_ENABLE_ERROR_INJECT__SHIFT                                                         0x0
#define SQ_DSM_CNTL2__SGPR_SELECT_INJECT_DELAY__SHIFT                                                         0x2
#define SQ_DSM_CNTL2__LDS_D_ENABLE_ERROR_INJECT__SHIFT                                                        0x3
#define SQ_DSM_CNTL2__LDS_D_SELECT_INJECT_DELAY__SHIFT                                                        0x5
#define SQ_DSM_CNTL2__LDS_I_ENABLE_ERROR_INJECT__SHIFT                                                        0x6
#define SQ_DSM_CNTL2__LDS_I_SELECT_INJECT_DELAY__SHIFT                                                        0x8
#define SQ_DSM_CNTL2__SP_ENABLE_ERROR_INJECT__SHIFT                                                           0x9
#define SQ_DSM_CNTL2__SP_SELECT_INJECT_DELAY__SHIFT                                                           0xb
#define SQ_DSM_CNTL2__LDS_INJECT_DELAY__SHIFT                                                                 0xe
#define SQ_DSM_CNTL2__SP_INJECT_DELAY__SHIFT                                                                  0x14
#define SQ_DSM_CNTL2__SQ_INJECT_DELAY__SHIFT                                                                  0x1a
#define SQ_DSM_CNTL2__SGPR_ENABLE_ERROR_INJECT_MASK                                                           0x00000003L
#define SQ_DSM_CNTL2__SGPR_SELECT_INJECT_DELAY_MASK                                                           0x00000004L
#define SQ_DSM_CNTL2__LDS_D_ENABLE_ERROR_INJECT_MASK                                                          0x00000018L
#define SQ_DSM_CNTL2__LDS_D_SELECT_INJECT_DELAY_MASK                                                          0x00000020L
#define SQ_DSM_CNTL2__LDS_I_ENABLE_ERROR_INJECT_MASK                                                          0x000000C0L
#define SQ_DSM_CNTL2__LDS_I_SELECT_INJECT_DELAY_MASK                                                          0x00000100L
#define SQ_DSM_CNTL2__SP_ENABLE_ERROR_INJECT_MASK                                                             0x00000600L
#define SQ_DSM_CNTL2__SP_SELECT_INJECT_DELAY_MASK                                                             0x00000800L
#define SQ_DSM_CNTL2__LDS_INJECT_DELAY_MASK                                                                   0x000FC000L
#define SQ_DSM_CNTL2__SP_INJECT_DELAY_MASK                                                                    0x03F00000L
#define SQ_DSM_CNTL2__SQ_INJECT_DELAY_MASK                                                                    0xFC000000L
//SQ_RUNTIME_CONFIG
#define SQ_RUNTIME_CONFIG__UNUSED_REGISTER__SHIFT                                                             0x0
#define SQ_RUNTIME_CONFIG__UNUSED_REGISTER_MASK                                                               0x00000001L
//SH_MEM_BASES
#define SH_MEM_BASES__PRIVATE_BASE__SHIFT                                                                     0x0
#define SH_MEM_BASES__SHARED_BASE__SHIFT                                                                      0x10
#define SH_MEM_BASES__PRIVATE_BASE_MASK                                                                       0x0000FFFFL
#define SH_MEM_BASES__SHARED_BASE_MASK                                                                        0xFFFF0000L
//SP_CONFIG
#define SP_CONFIG__DEST_CACHE_EVICT_COUNTER__SHIFT                                                            0x0
#define SP_CONFIG__ALU_BUSY_MGCG_OVERRIDE__SHIFT                                                              0x2
#define SP_CONFIG__DISABLE_TRANS_COEXEC__SHIFT                                                                0x3
#define SP_CONFIG__CAC_COUNTER_OVERRIDE__SHIFT                                                                0x4
#define SP_CONFIG__SP_SX_EXPVDATA_FGCG_OVERRIDE__SHIFT                                                        0x5
#define SP_CONFIG__DEST_CACHE_EVICT_COUNTER_MASK                                                              0x00000003L
#define SP_CONFIG__ALU_BUSY_MGCG_OVERRIDE_MASK                                                                0x00000004L
#define SP_CONFIG__DISABLE_TRANS_COEXEC_MASK                                                                  0x00000008L
#define SP_CONFIG__CAC_COUNTER_OVERRIDE_MASK                                                                  0x00000010L
#define SP_CONFIG__SP_SX_EXPVDATA_FGCG_OVERRIDE_MASK                                                          0x00000020L
//SQ_ARB_CONFIG
#define SQ_ARB_CONFIG__WG_RR_INTERVAL__SHIFT                                                                  0x0
#define SQ_ARB_CONFIG__FWD_PROG_INTERVAL__SHIFT                                                               0x4
#define SQ_ARB_CONFIG__WG_RR_INTERVAL_MASK                                                                    0x00000003L
#define SQ_ARB_CONFIG__FWD_PROG_INTERVAL_MASK                                                                 0x00000030L
//SH_MEM_CONFIG
#define SH_MEM_CONFIG__ADDRESS_MODE__SHIFT                                                                    0x0
#define SH_MEM_CONFIG__ALIGNMENT_MODE__SHIFT                                                                  0x2
#define SH_MEM_CONFIG__DEFAULT_MTYPE__SHIFT                                                                   0x4
#define SH_MEM_CONFIG__INITIAL_INST_PREFETCH__SHIFT                                                           0xe
#define SH_MEM_CONFIG__ICACHE_USE_GL1__SHIFT                                                                  0x12
#define SH_MEM_CONFIG__ADDRESS_MODE_MASK                                                                      0x00000001L
#define SH_MEM_CONFIG__ALIGNMENT_MODE_MASK                                                                    0x0000000CL
#define SH_MEM_CONFIG__DEFAULT_MTYPE_MASK                                                                     0x00000070L
#define SH_MEM_CONFIG__INITIAL_INST_PREFETCH_MASK                                                             0x0000C000L
#define SH_MEM_CONFIG__ICACHE_USE_GL1_MASK                                                                    0x00040000L
//SQ_SHADER_TBA_LO
#define SQ_SHADER_TBA_LO__ADDR_LO__SHIFT                                                                      0x0
#define SQ_SHADER_TBA_LO__ADDR_LO_MASK                                                                        0xFFFFFFFFL
//SQ_SHADER_TBA_HI
#define SQ_SHADER_TBA_HI__ADDR_HI__SHIFT                                                                      0x0
#define SQ_SHADER_TBA_HI__TRAP_EN__SHIFT                                                                      0x1f
#define SQ_SHADER_TBA_HI__ADDR_HI_MASK                                                                        0x000000FFL
#define SQ_SHADER_TBA_HI__TRAP_EN_MASK                                                                        0x80000000L
//SQ_SHADER_TMA_LO
#define SQ_SHADER_TMA_LO__ADDR_LO__SHIFT                                                                      0x0
#define SQ_SHADER_TMA_LO__ADDR_LO_MASK                                                                        0xFFFFFFFFL
//SQ_SHADER_TMA_HI
#define SQ_SHADER_TMA_HI__ADDR_HI__SHIFT                                                                      0x0
#define SQ_SHADER_TMA_HI__ADDR_HI_MASK                                                                        0x000000FFL
//SQG_UTCL0_CNTL1
#define SQG_UTCL0_CNTL1__FORCE_4K_L2_RESP__SHIFT                                                              0x0
#define SQG_UTCL0_CNTL1__GPUVM_64K_DEF__SHIFT                                                                 0x1
#define SQG_UTCL0_CNTL1__GPUVM_PERM_MODE__SHIFT                                                               0x2
#define SQG_UTCL0_CNTL1__RESP_MODE__SHIFT                                                                     0x3
#define SQG_UTCL0_CNTL1__RESP_FAULT_MODE__SHIFT                                                               0x5
#define SQG_UTCL0_CNTL1__CLIENTID__SHIFT                                                                      0x7
#define SQG_UTCL0_CNTL1__RESERVED__SHIFT                                                                      0x10
#define SQG_UTCL0_CNTL1__ENABLE_PUSH_LFIFO__SHIFT                                                             0x11
#define SQG_UTCL0_CNTL1__ENABLE_LFIFO_PRI_ARB__SHIFT                                                          0x12
#define SQG_UTCL0_CNTL1__REG_INV_VMID__SHIFT                                                                  0x13
#define SQG_UTCL0_CNTL1__REG_INV_ALL_VMID__SHIFT                                                              0x17
#define SQG_UTCL0_CNTL1__REG_INV_TOGGLE__SHIFT                                                                0x18
#define SQG_UTCL0_CNTL1__CLIENT_INVALIDATE_ALL_VMID__SHIFT                                                    0x19
#define SQG_UTCL0_CNTL1__FORCE_MISS__SHIFT                                                                    0x1a
#define SQG_UTCL0_CNTL1__FORCE_IN_ORDER__SHIFT                                                                0x1b
#define SQG_UTCL0_CNTL1__REDUCE_FIFO_DEPTH_BY_2__SHIFT                                                        0x1c
#define SQG_UTCL0_CNTL1__REDUCE_CACHE_SIZE_BY_2__SHIFT                                                        0x1e
#define SQG_UTCL0_CNTL1__FORCE_4K_L2_RESP_MASK                                                                0x00000001L
#define SQG_UTCL0_CNTL1__GPUVM_64K_DEF_MASK                                                                   0x00000002L
#define SQG_UTCL0_CNTL1__GPUVM_PERM_MODE_MASK                                                                 0x00000004L
#define SQG_UTCL0_CNTL1__RESP_MODE_MASK                                                                       0x00000018L
#define SQG_UTCL0_CNTL1__RESP_FAULT_MODE_MASK                                                                 0x00000060L
#define SQG_UTCL0_CNTL1__CLIENTID_MASK                                                                        0x0000FF80L
#define SQG_UTCL0_CNTL1__RESERVED_MASK                                                                        0x00010000L
#define SQG_UTCL0_CNTL1__ENABLE_PUSH_LFIFO_MASK                                                               0x00020000L
#define SQG_UTCL0_CNTL1__ENABLE_LFIFO_PRI_ARB_MASK                                                            0x00040000L
#define SQG_UTCL0_CNTL1__REG_INV_VMID_MASK                                                                    0x00780000L
#define SQG_UTCL0_CNTL1__REG_INV_ALL_VMID_MASK                                                                0x00800000L
#define SQG_UTCL0_CNTL1__REG_INV_TOGGLE_MASK                                                                  0x01000000L
#define SQG_UTCL0_CNTL1__CLIENT_INVALIDATE_ALL_VMID_MASK                                                      0x02000000L
#define SQG_UTCL0_CNTL1__FORCE_MISS_MASK                                                                      0x04000000L
#define SQG_UTCL0_CNTL1__FORCE_IN_ORDER_MASK                                                                  0x08000000L
#define SQG_UTCL0_CNTL1__REDUCE_FIFO_DEPTH_BY_2_MASK                                                          0x30000000L
#define SQG_UTCL0_CNTL1__REDUCE_CACHE_SIZE_BY_2_MASK                                                          0xC0000000L
//SQG_UTCL0_CNTL2
#define SQG_UTCL0_CNTL2__SPARE__SHIFT                                                                         0x0
#define SQG_UTCL0_CNTL2__LFIFO_SCAN_DISABLE__SHIFT                                                            0x8
#define SQG_UTCL0_CNTL2__MTYPE_OVRD_DIS__SHIFT                                                                0x9
#define SQG_UTCL0_CNTL2__LINE_VALID__SHIFT                                                                    0xa
#define SQG_UTCL0_CNTL2__DIS_EDC__SHIFT                                                                       0xb
#define SQG_UTCL0_CNTL2__GPUVM_INV_MODE__SHIFT                                                                0xc
#define SQG_UTCL0_CNTL2__SHOOTDOWN_OPT__SHIFT                                                                 0xd
#define SQG_UTCL0_CNTL2__FORCE_SNOOP__SHIFT                                                                   0xe
#define SQG_UTCL0_CNTL2__FORCE_GPUVM_INV_ACK__SHIFT                                                           0xf
#define SQG_UTCL0_CNTL2__ARB_BURST_MODE__SHIFT                                                                0x10
#define SQG_UTCL0_CNTL2__ENABLE_PERF_EVENT_RD_WR__SHIFT                                                       0x12
#define SQG_UTCL0_CNTL2__PERF_EVENT_RD_WR__SHIFT                                                              0x13
#define SQG_UTCL0_CNTL2__ENABLE_PERF_EVENT_VMID__SHIFT                                                        0x14
#define SQG_UTCL0_CNTL2__PERF_EVENT_VMID__SHIFT                                                               0x15
#define SQG_UTCL0_CNTL2__DIS_DUAL_L2_REQ__SHIFT                                                               0x19
#define SQG_UTCL0_CNTL2__FORCE_FRAG_2M_TO_64K__SHIFT                                                          0x1a
#define SQG_UTCL0_CNTL2__PERM_MODE_OVRD__SHIFT                                                                0x1b
#define SQG_UTCL0_CNTL2__LINE_INVALIDATE_OPT__SHIFT                                                           0x1c
#define SQG_UTCL0_CNTL2__GPUVM_16K_DEF__SHIFT                                                                 0x1d
#define SQG_UTCL0_CNTL2__RESERVED__SHIFT                                                                      0x1e
#define SQG_UTCL0_CNTL2__SPARE_MASK                                                                           0x000000FFL
#define SQG_UTCL0_CNTL2__LFIFO_SCAN_DISABLE_MASK                                                              0x00000100L
#define SQG_UTCL0_CNTL2__MTYPE_OVRD_DIS_MASK                                                                  0x00000200L
#define SQG_UTCL0_CNTL2__LINE_VALID_MASK                                                                      0x00000400L
#define SQG_UTCL0_CNTL2__DIS_EDC_MASK                                                                         0x00000800L
#define SQG_UTCL0_CNTL2__GPUVM_INV_MODE_MASK                                                                  0x00001000L
#define SQG_UTCL0_CNTL2__SHOOTDOWN_OPT_MASK                                                                   0x00002000L
#define SQG_UTCL0_CNTL2__FORCE_SNOOP_MASK                                                                     0x00004000L
#define SQG_UTCL0_CNTL2__FORCE_GPUVM_INV_ACK_MASK                                                             0x00008000L
#define SQG_UTCL0_CNTL2__ARB_BURST_MODE_MASK                                                                  0x00030000L
#define SQG_UTCL0_CNTL2__ENABLE_PERF_EVENT_RD_WR_MASK                                                         0x00040000L
#define SQG_UTCL0_CNTL2__PERF_EVENT_RD_WR_MASK                                                                0x00080000L
#define SQG_UTCL0_CNTL2__ENABLE_PERF_EVENT_VMID_MASK                                                          0x00100000L
#define SQG_UTCL0_CNTL2__PERF_EVENT_VMID_MASK                                                                 0x01E00000L
#define SQG_UTCL0_CNTL2__DIS_DUAL_L2_REQ_MASK                                                                 0x02000000L
#define SQG_UTCL0_CNTL2__FORCE_FRAG_2M_TO_64K_MASK                                                            0x04000000L
#define SQG_UTCL0_CNTL2__PERM_MODE_OVRD_MASK                                                                  0x08000000L
#define SQG_UTCL0_CNTL2__LINE_INVALIDATE_OPT_MASK                                                             0x10000000L
#define SQG_UTCL0_CNTL2__GPUVM_16K_DEF_MASK                                                                   0x20000000L
#define SQG_UTCL0_CNTL2__RESERVED_MASK                                                                        0xC0000000L
//SQG_UTCL0_STATUS
#define SQG_UTCL0_STATUS__FAULT_DETECTED__SHIFT                                                               0x0
#define SQG_UTCL0_STATUS__RETRY_DETECTED__SHIFT                                                               0x1
#define SQG_UTCL0_STATUS__PRT_DETECTED__SHIFT                                                                 0x2
#define SQG_UTCL0_STATUS__RESERVED__SHIFT                                                                     0x3
#define SQG_UTCL0_STATUS__UNUSED__SHIFT                                                                       0x8
#define SQG_UTCL0_STATUS__FAULT_DETECTED_MASK                                                                 0x00000001L
#define SQG_UTCL0_STATUS__RETRY_DETECTED_MASK                                                                 0x00000002L
#define SQG_UTCL0_STATUS__PRT_DETECTED_MASK                                                                   0x00000004L
#define SQG_UTCL0_STATUS__RESERVED_MASK                                                                       0x000000F8L
#define SQG_UTCL0_STATUS__UNUSED_MASK                                                                         0xFFFFFF00L
//SQG_CONFIG
#define SQG_CONFIG__UTCL0_PREFETCH_PAGE__SHIFT                                                                0x0
#define SQG_CONFIG__UTCL0_RETRY_TIMER__SHIFT                                                                  0x4
#define SQG_CONFIG__UTCL0_PREFETCH_PAGE_MASK                                                                  0x0000000FL
#define SQG_CONFIG__UTCL0_RETRY_TIMER_MASK                                                                    0x000007F0L
//CC_GC_SHADER_RATE_CONFIG
#define CC_GC_SHADER_RATE_CONFIG__DPFP_RATE__SHIFT                                                            0x1
#define CC_GC_SHADER_RATE_CONFIG__SQC_BALANCE_DISABLE__SHIFT                                                  0x3
#define CC_GC_SHADER_RATE_CONFIG__DPFP_RATE_MASK                                                              0x00000006L
#define CC_GC_SHADER_RATE_CONFIG__SQC_BALANCE_DISABLE_MASK                                                    0x00000008L
//GC_USER_SHADER_RATE_CONFIG
#define GC_USER_SHADER_RATE_CONFIG__DPFP_RATE__SHIFT                                                          0x1
#define GC_USER_SHADER_RATE_CONFIG__SQC_BALANCE_DISABLE__SHIFT                                                0x3
#define GC_USER_SHADER_RATE_CONFIG__DPFP_RATE_MASK                                                            0x00000006L
#define GC_USER_SHADER_RATE_CONFIG__SQC_BALANCE_DISABLE_MASK                                                  0x00000008L
//SQ_INTERRUPT_AUTO_MASK
#define SQ_INTERRUPT_AUTO_MASK__MASK__SHIFT                                                                   0x0
#define SQ_INTERRUPT_AUTO_MASK__MASK_MASK                                                                     0x00FFFFFFL
//SQ_INTERRUPT_MSG_CTRL
#define SQ_INTERRUPT_MSG_CTRL__STALL__SHIFT                                                                   0x0
#define SQ_INTERRUPT_MSG_CTRL__STALL_MASK                                                                     0x00000001L
//SQ_WATCH0_ADDR_H
#define SQ_WATCH0_ADDR_H__ADDR__SHIFT                                                                         0x0
#define SQ_WATCH0_ADDR_H__ADDR_MASK                                                                           0x0000FFFFL
//SQ_WATCH0_ADDR_L
#define SQ_WATCH0_ADDR_L__ADDR__SHIFT                                                                         0x6
#define SQ_WATCH0_ADDR_L__ADDR_MASK                                                                           0xFFFFFFC0L
//SQ_WATCH0_CNTL
#define SQ_WATCH0_CNTL__MASK__SHIFT                                                                           0x0
#define SQ_WATCH0_CNTL__VMID__SHIFT                                                                           0x18
#define SQ_WATCH0_CNTL__VALID__SHIFT                                                                          0x1f
#define SQ_WATCH0_CNTL__MASK_MASK                                                                             0x00FFFFFFL
#define SQ_WATCH0_CNTL__VMID_MASK                                                                             0x0F000000L
#define SQ_WATCH0_CNTL__VALID_MASK                                                                            0x80000000L
//SQ_WATCH1_ADDR_H
#define SQ_WATCH1_ADDR_H__ADDR__SHIFT                                                                         0x0
#define SQ_WATCH1_ADDR_H__ADDR_MASK                                                                           0x0000FFFFL
//SQ_WATCH1_ADDR_L
#define SQ_WATCH1_ADDR_L__ADDR__SHIFT                                                                         0x6
#define SQ_WATCH1_ADDR_L__ADDR_MASK                                                                           0xFFFFFFC0L
//SQ_WATCH1_CNTL
#define SQ_WATCH1_CNTL__MASK__SHIFT                                                                           0x0
#define SQ_WATCH1_CNTL__VMID__SHIFT                                                                           0x18
#define SQ_WATCH1_CNTL__VALID__SHIFT                                                                          0x1f
#define SQ_WATCH1_CNTL__MASK_MASK                                                                             0x00FFFFFFL
#define SQ_WATCH1_CNTL__VMID_MASK                                                                             0x0F000000L
#define SQ_WATCH1_CNTL__VALID_MASK                                                                            0x80000000L
//SQ_WATCH2_ADDR_H
#define SQ_WATCH2_ADDR_H__ADDR__SHIFT                                                                         0x0
#define SQ_WATCH2_ADDR_H__ADDR_MASK                                                                           0x0000FFFFL
//SQ_WATCH2_ADDR_L
#define SQ_WATCH2_ADDR_L__ADDR__SHIFT                                                                         0x6
#define SQ_WATCH2_ADDR_L__ADDR_MASK                                                                           0xFFFFFFC0L
//SQ_WATCH2_CNTL
#define SQ_WATCH2_CNTL__MASK__SHIFT                                                                           0x0
#define SQ_WATCH2_CNTL__VMID__SHIFT                                                                           0x18
#define SQ_WATCH2_CNTL__VALID__SHIFT                                                                          0x1f
#define SQ_WATCH2_CNTL__MASK_MASK                                                                             0x00FFFFFFL
#define SQ_WATCH2_CNTL__VMID_MASK                                                                             0x0F000000L
#define SQ_WATCH2_CNTL__VALID_MASK                                                                            0x80000000L
//SQ_WATCH3_ADDR_H
#define SQ_WATCH3_ADDR_H__ADDR__SHIFT                                                                         0x0
#define SQ_WATCH3_ADDR_H__ADDR_MASK                                                                           0x0000FFFFL
//SQ_WATCH3_ADDR_L
#define SQ_WATCH3_ADDR_L__ADDR__SHIFT                                                                         0x6
#define SQ_WATCH3_ADDR_L__ADDR_MASK                                                                           0xFFFFFFC0L
//SQ_WATCH3_CNTL
#define SQ_WATCH3_CNTL__MASK__SHIFT                                                                           0x0
#define SQ_WATCH3_CNTL__VMID__SHIFT                                                                           0x18
#define SQ_WATCH3_CNTL__VALID__SHIFT                                                                          0x1f
#define SQ_WATCH3_CNTL__MASK_MASK                                                                             0x00FFFFFFL
#define SQ_WATCH3_CNTL__VMID_MASK                                                                             0x0F000000L
#define SQ_WATCH3_CNTL__VALID_MASK                                                                            0x80000000L
//SQ_THREAD_TRACE_BUF0_BASE
#define SQ_THREAD_TRACE_BUF0_BASE__BASE_LO__SHIFT                                                             0x0
#define SQ_THREAD_TRACE_BUF0_BASE__BASE_LO_MASK                                                               0xFFFFFFFFL
//SQ_THREAD_TRACE_BUF0_SIZE
#define SQ_THREAD_TRACE_BUF0_SIZE__BASE_HI__SHIFT                                                             0x0
#define SQ_THREAD_TRACE_BUF0_SIZE__SIZE__SHIFT                                                                0x8
#define SQ_THREAD_TRACE_BUF0_SIZE__BASE_HI_MASK                                                               0x0000000FL
#define SQ_THREAD_TRACE_BUF0_SIZE__SIZE_MASK                                                                  0x3FFFFF00L
//SQ_THREAD_TRACE_BUF1_BASE
#define SQ_THREAD_TRACE_BUF1_BASE__BASE_LO__SHIFT                                                             0x0
#define SQ_THREAD_TRACE_BUF1_BASE__BASE_LO_MASK                                                               0xFFFFFFFFL
//SQ_THREAD_TRACE_BUF1_SIZE
#define SQ_THREAD_TRACE_BUF1_SIZE__BASE_HI__SHIFT                                                             0x0
#define SQ_THREAD_TRACE_BUF1_SIZE__SIZE__SHIFT                                                                0x8
#define SQ_THREAD_TRACE_BUF1_SIZE__BASE_HI_MASK                                                               0x0000000FL
#define SQ_THREAD_TRACE_BUF1_SIZE__SIZE_MASK                                                                  0x3FFFFF00L
//SQ_THREAD_TRACE_WPTR
#define SQ_THREAD_TRACE_WPTR__OFFSET__SHIFT                                                                   0x0
#define SQ_THREAD_TRACE_WPTR__BUFFER_ID__SHIFT                                                                0x1f
#define SQ_THREAD_TRACE_WPTR__OFFSET_MASK                                                                     0x1FFFFFFFL
#define SQ_THREAD_TRACE_WPTR__BUFFER_ID_MASK                                                                  0x80000000L
//SQ_THREAD_TRACE_MASK
#define SQ_THREAD_TRACE_MASK__SIMD_SEL__SHIFT                                                                 0x0
#define SQ_THREAD_TRACE_MASK__WGP_SEL__SHIFT                                                                  0x4
#define SQ_THREAD_TRACE_MASK__SA_SEL__SHIFT                                                                   0x9
#define SQ_THREAD_TRACE_MASK__WTYPE_INCLUDE__SHIFT                                                            0xa
#define SQ_THREAD_TRACE_MASK__SIMD_SEL_MASK                                                                   0x00000003L
#define SQ_THREAD_TRACE_MASK__WGP_SEL_MASK                                                                    0x000000F0L
#define SQ_THREAD_TRACE_MASK__SA_SEL_MASK                                                                     0x00000200L
#define SQ_THREAD_TRACE_MASK__WTYPE_INCLUDE_MASK                                                              0x0001FC00L
//SQ_THREAD_TRACE_TOKEN_MASK
#define SQ_THREAD_TRACE_TOKEN_MASK__TOKEN_EXCLUDE__SHIFT                                                      0x0
#define SQ_THREAD_TRACE_TOKEN_MASK__BOP_EVENTS_TOKEN_INCLUDE__SHIFT                                           0xc
#define SQ_THREAD_TRACE_TOKEN_MASK__REG_INCLUDE__SHIFT                                                        0x10
#define SQ_THREAD_TRACE_TOKEN_MASK__INST_EXCLUDE__SHIFT                                                       0x18
#define SQ_THREAD_TRACE_TOKEN_MASK__REG_EXCLUDE__SHIFT                                                        0x1a
#define SQ_THREAD_TRACE_TOKEN_MASK__REG_DETAIL_ALL__SHIFT                                                     0x1f
#define SQ_THREAD_TRACE_TOKEN_MASK__TOKEN_EXCLUDE_MASK                                                        0x000007FFL
#define SQ_THREAD_TRACE_TOKEN_MASK__BOP_EVENTS_TOKEN_INCLUDE_MASK                                             0x00001000L
#define SQ_THREAD_TRACE_TOKEN_MASK__REG_INCLUDE_MASK                                                          0x00FF0000L
#define SQ_THREAD_TRACE_TOKEN_MASK__INST_EXCLUDE_MASK                                                         0x03000000L
#define SQ_THREAD_TRACE_TOKEN_MASK__REG_EXCLUDE_MASK                                                          0x1C000000L
#define SQ_THREAD_TRACE_TOKEN_MASK__REG_DETAIL_ALL_MASK                                                       0x80000000L
//SQ_THREAD_TRACE_CTRL
#define SQ_THREAD_TRACE_CTRL__MODE__SHIFT                                                                     0x0
#define SQ_THREAD_TRACE_CTRL__ALL_VMID__SHIFT                                                                 0x2
#define SQ_THREAD_TRACE_CTRL__CH_PERF_EN__SHIFT                                                               0x3
#define SQ_THREAD_TRACE_CTRL__INTERRUPT_EN__SHIFT                                                             0x4
#define SQ_THREAD_TRACE_CTRL__DOUBLE_BUFFER__SHIFT                                                            0x5
#define SQ_THREAD_TRACE_CTRL__HIWATER__SHIFT                                                                  0x6
#define SQ_THREAD_TRACE_CTRL__REG_STALL_EN__SHIFT                                                             0x9
#define SQ_THREAD_TRACE_CTRL__SPI_STALL_EN__SHIFT                                                             0xa
#define SQ_THREAD_TRACE_CTRL__SQ_STALL_EN__SHIFT                                                              0xb
#define SQ_THREAD_TRACE_CTRL__REG_DROP_ON_STALL__SHIFT                                                        0xc
#define SQ_THREAD_TRACE_CTRL__UTIL_TIMER__SHIFT                                                               0xd
#define SQ_THREAD_TRACE_CTRL__WAVESTART_MODE__SHIFT                                                           0xe
#define SQ_THREAD_TRACE_CTRL__RT_FREQ__SHIFT                                                                  0x10
#define SQ_THREAD_TRACE_CTRL__SYNC_COUNT_MARKERS__SHIFT                                                       0x12
#define SQ_THREAD_TRACE_CTRL__SYNC_COUNT_DRAWS__SHIFT                                                         0x13
#define SQ_THREAD_TRACE_CTRL__LOWATER_OFFSET__SHIFT                                                           0x14
#define SQ_THREAD_TRACE_CTRL__AUTO_FLUSH_PADDING_DIS__SHIFT                                                   0x1c
#define SQ_THREAD_TRACE_CTRL__AUTO_FLUSH_MODE__SHIFT                                                          0x1d
#define SQ_THREAD_TRACE_CTRL__CAPTURE_ALL__SHIFT                                                              0x1e
#define SQ_THREAD_TRACE_CTRL__DRAW_EVENT_EN__SHIFT                                                            0x1f
#define SQ_THREAD_TRACE_CTRL__MODE_MASK                                                                       0x00000003L
#define SQ_THREAD_TRACE_CTRL__ALL_VMID_MASK                                                                   0x00000004L
#define SQ_THREAD_TRACE_CTRL__CH_PERF_EN_MASK                                                                 0x00000008L
#define SQ_THREAD_TRACE_CTRL__INTERRUPT_EN_MASK                                                               0x00000010L
#define SQ_THREAD_TRACE_CTRL__DOUBLE_BUFFER_MASK                                                              0x00000020L
#define SQ_THREAD_TRACE_CTRL__HIWATER_MASK                                                                    0x000001C0L
#define SQ_THREAD_TRACE_CTRL__REG_STALL_EN_MASK                                                               0x00000200L
#define SQ_THREAD_TRACE_CTRL__SPI_STALL_EN_MASK                                                               0x00000400L
#define SQ_THREAD_TRACE_CTRL__SQ_STALL_EN_MASK                                                                0x00000800L
#define SQ_THREAD_TRACE_CTRL__REG_DROP_ON_STALL_MASK                                                          0x00001000L
#define SQ_THREAD_TRACE_CTRL__UTIL_TIMER_MASK                                                                 0x00002000L
#define SQ_THREAD_TRACE_CTRL__WAVESTART_MODE_MASK                                                             0x0000C000L
#define SQ_THREAD_TRACE_CTRL__RT_FREQ_MASK                                                                    0x00030000L
#define SQ_THREAD_TRACE_CTRL__SYNC_COUNT_MARKERS_MASK                                                         0x00040000L
#define SQ_THREAD_TRACE_CTRL__SYNC_COUNT_DRAWS_MASK                                                           0x00080000L
#define SQ_THREAD_TRACE_CTRL__LOWATER_OFFSET_MASK                                                             0x00700000L
#define SQ_THREAD_TRACE_CTRL__AUTO_FLUSH_PADDING_DIS_MASK                                                     0x10000000L
#define SQ_THREAD_TRACE_CTRL__AUTO_FLUSH_MODE_MASK                                                            0x20000000L
#define SQ_THREAD_TRACE_CTRL__CAPTURE_ALL_MASK                                                                0x40000000L
#define SQ_THREAD_TRACE_CTRL__DRAW_EVENT_EN_MASK                                                              0x80000000L
//SQ_THREAD_TRACE_STATUS
#define SQ_THREAD_TRACE_STATUS__FINISH_PENDING__SHIFT                                                         0x0
#define SQ_THREAD_TRACE_STATUS__FINISH_DONE__SHIFT                                                            0xc
#define SQ_THREAD_TRACE_STATUS__UTC_ERR__SHIFT                                                                0x18
#define SQ_THREAD_TRACE_STATUS__BUSY__SHIFT                                                                   0x19
#define SQ_THREAD_TRACE_STATUS__EVENT_CNTR_OVERFLOW__SHIFT                                                    0x1a
#define SQ_THREAD_TRACE_STATUS__EVENT_CNTR_STALL__SHIFT                                                       0x1b
#define SQ_THREAD_TRACE_STATUS__OWNER_VMID__SHIFT                                                             0x1c
#define SQ_THREAD_TRACE_STATUS__FINISH_PENDING_MASK                                                           0x00000FFFL
#define SQ_THREAD_TRACE_STATUS__FINISH_DONE_MASK                                                              0x00FFF000L
#define SQ_THREAD_TRACE_STATUS__UTC_ERR_MASK                                                                  0x01000000L
#define SQ_THREAD_TRACE_STATUS__BUSY_MASK                                                                     0x02000000L
#define SQ_THREAD_TRACE_STATUS__EVENT_CNTR_OVERFLOW_MASK                                                      0x04000000L
#define SQ_THREAD_TRACE_STATUS__EVENT_CNTR_STALL_MASK                                                         0x08000000L
#define SQ_THREAD_TRACE_STATUS__OWNER_VMID_MASK                                                               0xF0000000L
//SQ_THREAD_TRACE_DROPPED_CNTR
#define SQ_THREAD_TRACE_DROPPED_CNTR__CNTR__SHIFT                                                             0x0
#define SQ_THREAD_TRACE_DROPPED_CNTR__CNTR_MASK                                                               0xFFFFFFFFL
//SQ_THREAD_TRACE_GFX_DRAW_CNTR
#define SQ_THREAD_TRACE_GFX_DRAW_CNTR__CNTR__SHIFT                                                            0x0
#define SQ_THREAD_TRACE_GFX_DRAW_CNTR__CNTR_MASK                                                              0xFFFFFFFFL
//SQ_THREAD_TRACE_GFX_MARKER_CNTR
#define SQ_THREAD_TRACE_GFX_MARKER_CNTR__CNTR__SHIFT                                                          0x0
#define SQ_THREAD_TRACE_GFX_MARKER_CNTR__CNTR_MASK                                                            0xFFFFFFFFL
//SQ_THREAD_TRACE_HP3D_DRAW_CNTR
#define SQ_THREAD_TRACE_HP3D_DRAW_CNTR__CNTR__SHIFT                                                           0x0
#define SQ_THREAD_TRACE_HP3D_DRAW_CNTR__CNTR_MASK                                                             0xFFFFFFFFL
//SQ_THREAD_TRACE_HP3D_MARKER_CNTR
#define SQ_THREAD_TRACE_HP3D_MARKER_CNTR__CNTR__SHIFT                                                         0x0
#define SQ_THREAD_TRACE_HP3D_MARKER_CNTR__CNTR_MASK                                                           0xFFFFFFFFL
//SQ_THREAD_TRACE_STATUS2
#define SQ_THREAD_TRACE_STATUS2__BUF0_FULL__SHIFT                                                             0x0
#define SQ_THREAD_TRACE_STATUS2__BUF1_FULL__SHIFT                                                             0x1
#define SQ_THREAD_TRACE_STATUS2__PACKET_LOST_BUF_NO_LOCKDOWN__SHIFT                                           0x4
#define SQ_THREAD_TRACE_STATUS2__BUF0_FULL_MASK                                                               0x00000001L
#define SQ_THREAD_TRACE_STATUS2__BUF1_FULL_MASK                                                               0x00000002L
#define SQ_THREAD_TRACE_STATUS2__PACKET_LOST_BUF_NO_LOCKDOWN_MASK                                             0x00000010L
//SQ_IND_INDEX
#define SQ_IND_INDEX__WAVE_ID__SHIFT                                                                          0x0
#define SQ_IND_INDEX__WORKITEM_ID__SHIFT                                                                      0x5
#define SQ_IND_INDEX__AUTO_INCR__SHIFT                                                                        0xb
#define SQ_IND_INDEX__INDEX__SHIFT                                                                            0x10
#define SQ_IND_INDEX__WAVE_ID_MASK                                                                            0x0000001FL
#define SQ_IND_INDEX__WORKITEM_ID_MASK                                                                        0x000007E0L
#define SQ_IND_INDEX__AUTO_INCR_MASK                                                                          0x00000800L
#define SQ_IND_INDEX__INDEX_MASK                                                                              0xFFFF0000L
//SQ_IND_DATA
#define SQ_IND_DATA__DATA__SHIFT                                                                              0x0
#define SQ_IND_DATA__DATA_MASK                                                                                0xFFFFFFFFL
//SQ_CMD
#define SQ_CMD__CMD__SHIFT                                                                                    0x0
#define SQ_CMD__MODE__SHIFT                                                                                   0x4
#define SQ_CMD__CHECK_VMID__SHIFT                                                                             0x7
#define SQ_CMD__DATA__SHIFT                                                                                   0x8
#define SQ_CMD__WAVE_ID__SHIFT                                                                                0x10
#define SQ_CMD__QUEUE_ID__SHIFT                                                                               0x18
#define SQ_CMD__VM_ID__SHIFT                                                                                  0x1c
#define SQ_CMD__CMD_MASK                                                                                      0x0000000FL
#define SQ_CMD__MODE_MASK                                                                                     0x00000070L
#define SQ_CMD__CHECK_VMID_MASK                                                                               0x00000080L
#define SQ_CMD__DATA_MASK                                                                                     0x00000F00L
#define SQ_CMD__WAVE_ID_MASK                                                                                  0x001F0000L
#define SQ_CMD__QUEUE_ID_MASK                                                                                 0x07000000L
#define SQ_CMD__VM_ID_MASK                                                                                    0xF0000000L
//SQ_TIME_HI
#define SQ_TIME_HI__TIME__SHIFT                                                                               0x0
#define SQ_TIME_HI__TIME_MASK                                                                                 0xFFFFFFFFL
//SQ_TIME_LO
#define SQ_TIME_LO__TIME__SHIFT                                                                               0x0
#define SQ_TIME_LO__TIME_MASK                                                                                 0xFFFFFFFFL
//SQ_LB_CTR_CTRL
#define SQ_LB_CTR_CTRL__START__SHIFT                                                                          0x0
#define SQ_LB_CTR_CTRL__LOAD__SHIFT                                                                           0x1
#define SQ_LB_CTR_CTRL__CLEAR__SHIFT                                                                          0x2
#define SQ_LB_CTR_CTRL__START_MASK                                                                            0x00000001L
#define SQ_LB_CTR_CTRL__LOAD_MASK                                                                             0x00000002L
#define SQ_LB_CTR_CTRL__CLEAR_MASK                                                                            0x00000004L
//SQ_LB_DATA0
#define SQ_LB_DATA0__DATA__SHIFT                                                                              0x0
#define SQ_LB_DATA0__DATA_MASK                                                                                0xFFFFFFFFL
//SQ_LB_DATA1
#define SQ_LB_DATA1__DATA__SHIFT                                                                              0x0
#define SQ_LB_DATA1__DATA_MASK                                                                                0xFFFFFFFFL
//SQ_LB_DATA2
#define SQ_LB_DATA2__DATA__SHIFT                                                                              0x0
#define SQ_LB_DATA2__DATA_MASK                                                                                0xFFFFFFFFL
//SQ_LB_DATA3
#define SQ_LB_DATA3__DATA__SHIFT                                                                              0x0
#define SQ_LB_DATA3__DATA_MASK                                                                                0xFFFFFFFFL
//SQ_LB_CTR_SEL0
#define SQ_LB_CTR_SEL0__SEL0__SHIFT                                                                           0x0
#define SQ_LB_CTR_SEL0__DIV0__SHIFT                                                                           0xf
#define SQ_LB_CTR_SEL0__SEL1__SHIFT                                                                           0x10
#define SQ_LB_CTR_SEL0__DIV1__SHIFT                                                                           0x1f
#define SQ_LB_CTR_SEL0__SEL0_MASK                                                                             0x000000FFL
#define SQ_LB_CTR_SEL0__DIV0_MASK                                                                             0x00008000L
#define SQ_LB_CTR_SEL0__SEL1_MASK                                                                             0x00FF0000L
#define SQ_LB_CTR_SEL0__DIV1_MASK                                                                             0x80000000L
//SQ_LB_CTR_SEL1
#define SQ_LB_CTR_SEL1__SEL2__SHIFT                                                                           0x0
#define SQ_LB_CTR_SEL1__DIV2__SHIFT                                                                           0xf
#define SQ_LB_CTR_SEL1__SEL3__SHIFT                                                                           0x10
#define SQ_LB_CTR_SEL1__DIV3__SHIFT                                                                           0x1f
#define SQ_LB_CTR_SEL1__SEL2_MASK                                                                             0x000000FFL
#define SQ_LB_CTR_SEL1__DIV2_MASK                                                                             0x00008000L
#define SQ_LB_CTR_SEL1__SEL3_MASK                                                                             0x00FF0000L
#define SQ_LB_CTR_SEL1__DIV3_MASK                                                                             0x80000000L
//SQ_EDC_CNT
#define SQ_EDC_CNT__LDS_D_SEC_COUNT__SHIFT                                                                    0x0
#define SQ_EDC_CNT__LDS_D_DED_COUNT__SHIFT                                                                    0x2
#define SQ_EDC_CNT__LDS_I_SEC_COUNT__SHIFT                                                                    0x4
#define SQ_EDC_CNT__LDS_I_DED_COUNT__SHIFT                                                                    0x6
#define SQ_EDC_CNT__SGPR_SEC_COUNT__SHIFT                                                                     0x8
#define SQ_EDC_CNT__SGPR_DED_COUNT__SHIFT                                                                     0xa
#define SQ_EDC_CNT__VGPR0_SEC_COUNT__SHIFT                                                                    0xc
#define SQ_EDC_CNT__VGPR0_DED_COUNT__SHIFT                                                                    0xe
#define SQ_EDC_CNT__VGPR1_SEC_COUNT__SHIFT                                                                    0x10
#define SQ_EDC_CNT__VGPR1_DED_COUNT__SHIFT                                                                    0x12
#define SQ_EDC_CNT__VGPR2_SEC_COUNT__SHIFT                                                                    0x14
#define SQ_EDC_CNT__VGPR2_DED_COUNT__SHIFT                                                                    0x16
#define SQ_EDC_CNT__VGPR3_SEC_COUNT__SHIFT                                                                    0x18
#define SQ_EDC_CNT__VGPR3_DED_COUNT__SHIFT                                                                    0x1a
#define SQ_EDC_CNT__LDS_D_SEC_COUNT_MASK                                                                      0x00000003L
#define SQ_EDC_CNT__LDS_D_DED_COUNT_MASK                                                                      0x0000000CL
#define SQ_EDC_CNT__LDS_I_SEC_COUNT_MASK                                                                      0x00000030L
#define SQ_EDC_CNT__LDS_I_DED_COUNT_MASK                                                                      0x000000C0L
#define SQ_EDC_CNT__SGPR_SEC_COUNT_MASK                                                                       0x00000300L
#define SQ_EDC_CNT__SGPR_DED_COUNT_MASK                                                                       0x00000C00L
#define SQ_EDC_CNT__VGPR0_SEC_COUNT_MASK                                                                      0x00003000L
#define SQ_EDC_CNT__VGPR0_DED_COUNT_MASK                                                                      0x0000C000L
#define SQ_EDC_CNT__VGPR1_SEC_COUNT_MASK                                                                      0x00030000L
#define SQ_EDC_CNT__VGPR1_DED_COUNT_MASK                                                                      0x000C0000L
#define SQ_EDC_CNT__VGPR2_SEC_COUNT_MASK                                                                      0x00300000L
#define SQ_EDC_CNT__VGPR2_DED_COUNT_MASK                                                                      0x00C00000L
#define SQ_EDC_CNT__VGPR3_SEC_COUNT_MASK                                                                      0x03000000L
#define SQ_EDC_CNT__VGPR3_DED_COUNT_MASK                                                                      0x0C000000L
//SQ_EDC_FUE_CNTL
#define SQ_EDC_FUE_CNTL__BLOCK_FUE_FLAGS__SHIFT                                                               0x0
#define SQ_EDC_FUE_CNTL__FUE_INTERRUPT_ENABLES__SHIFT                                                         0x10
#define SQ_EDC_FUE_CNTL__BLOCK_FUE_FLAGS_MASK                                                                 0x0000FFFFL
#define SQ_EDC_FUE_CNTL__FUE_INTERRUPT_ENABLES_MASK                                                           0xFFFF0000L
//SQ_WREXEC_EXEC_HI
#define SQ_WREXEC_EXEC_HI__ADDR_HI__SHIFT                                                                     0x0
#define SQ_WREXEC_EXEC_HI__FIRST_WAVE__SHIFT                                                                  0x1a
#define SQ_WREXEC_EXEC_HI__MTYPE__SHIFT                                                                       0x1c
#define SQ_WREXEC_EXEC_HI__MSB__SHIFT                                                                         0x1f
#define SQ_WREXEC_EXEC_HI__ADDR_HI_MASK                                                                       0x0000FFFFL
#define SQ_WREXEC_EXEC_HI__FIRST_WAVE_MASK                                                                    0x04000000L
#define SQ_WREXEC_EXEC_HI__MTYPE_MASK                                                                         0x70000000L
#define SQ_WREXEC_EXEC_HI__MSB_MASK                                                                           0x80000000L
//SQ_WREXEC_EXEC_LO
#define SQ_WREXEC_EXEC_LO__ADDR_LO__SHIFT                                                                     0x0
#define SQ_WREXEC_EXEC_LO__ADDR_LO_MASK                                                                       0xFFFFFFFFL
//SQC_ICACHE_UTCL0_CNTL1
#define SQC_ICACHE_UTCL0_CNTL1__FORCE_4K_L2_RESP__SHIFT                                                       0x0
#define SQC_ICACHE_UTCL0_CNTL1__GPUVM_64K_DEF__SHIFT                                                          0x1
#define SQC_ICACHE_UTCL0_CNTL1__GPUVM_PERM_MODE__SHIFT                                                        0x2
#define SQC_ICACHE_UTCL0_CNTL1__RESP_MODE__SHIFT                                                              0x3
#define SQC_ICACHE_UTCL0_CNTL1__RESP_FAULT_MODE__SHIFT                                                        0x5
#define SQC_ICACHE_UTCL0_CNTL1__CLIENTID__SHIFT                                                               0x7
#define SQC_ICACHE_UTCL0_CNTL1__ENABLE_PUSH_LFIFO__SHIFT                                                      0x11
#define SQC_ICACHE_UTCL0_CNTL1__ENABLE_LFIFO_PRI_ARB__SHIFT                                                   0x12
#define SQC_ICACHE_UTCL0_CNTL1__REG_INV_VMID__SHIFT                                                           0x13
#define SQC_ICACHE_UTCL0_CNTL1__REG_INV_ALL_VMID__SHIFT                                                       0x17
#define SQC_ICACHE_UTCL0_CNTL1__REG_INV_TOGGLE__SHIFT                                                         0x18
#define SQC_ICACHE_UTCL0_CNTL1__CLIENT_INVALIDATE_ALL_VMID__SHIFT                                             0x19
#define SQC_ICACHE_UTCL0_CNTL1__FORCE_MISS__SHIFT                                                             0x1a
#define SQC_ICACHE_UTCL0_CNTL1__FORCE_IN_ORDER__SHIFT                                                         0x1b
#define SQC_ICACHE_UTCL0_CNTL1__REDUCE_FIFO_DEPTH_BY_2__SHIFT                                                 0x1c
#define SQC_ICACHE_UTCL0_CNTL1__REDUCE_CACHE_SIZE_BY_2__SHIFT                                                 0x1e
#define SQC_ICACHE_UTCL0_CNTL1__FORCE_4K_L2_RESP_MASK                                                         0x00000001L
#define SQC_ICACHE_UTCL0_CNTL1__GPUVM_64K_DEF_MASK                                                            0x00000002L
#define SQC_ICACHE_UTCL0_CNTL1__GPUVM_PERM_MODE_MASK                                                          0x00000004L
#define SQC_ICACHE_UTCL0_CNTL1__RESP_MODE_MASK                                                                0x00000018L
#define SQC_ICACHE_UTCL0_CNTL1__RESP_FAULT_MODE_MASK                                                          0x00000060L
#define SQC_ICACHE_UTCL0_CNTL1__CLIENTID_MASK                                                                 0x0000FF80L
#define SQC_ICACHE_UTCL0_CNTL1__ENABLE_PUSH_LFIFO_MASK                                                        0x00020000L
#define SQC_ICACHE_UTCL0_CNTL1__ENABLE_LFIFO_PRI_ARB_MASK                                                     0x00040000L
#define SQC_ICACHE_UTCL0_CNTL1__REG_INV_VMID_MASK                                                             0x00780000L
#define SQC_ICACHE_UTCL0_CNTL1__REG_INV_ALL_VMID_MASK                                                         0x00800000L
#define SQC_ICACHE_UTCL0_CNTL1__REG_INV_TOGGLE_MASK                                                           0x01000000L
#define SQC_ICACHE_UTCL0_CNTL1__CLIENT_INVALIDATE_ALL_VMID_MASK                                               0x02000000L
#define SQC_ICACHE_UTCL0_CNTL1__FORCE_MISS_MASK                                                               0x04000000L
#define SQC_ICACHE_UTCL0_CNTL1__FORCE_IN_ORDER_MASK                                                           0x08000000L
#define SQC_ICACHE_UTCL0_CNTL1__REDUCE_FIFO_DEPTH_BY_2_MASK                                                   0x30000000L
#define SQC_ICACHE_UTCL0_CNTL1__REDUCE_CACHE_SIZE_BY_2_MASK                                                   0xC0000000L
//SQC_ICACHE_UTCL0_CNTL2
#define SQC_ICACHE_UTCL0_CNTL2__SPARE__SHIFT                                                                  0x0
#define SQC_ICACHE_UTCL0_CNTL2__LFIFO_SCAN_DISABLE__SHIFT                                                     0x8
#define SQC_ICACHE_UTCL0_CNTL2__MTYPE_OVRD_DIS__SHIFT                                                         0x9
#define SQC_ICACHE_UTCL0_CNTL2__LINE_VALID__SHIFT                                                             0xa
#define SQC_ICACHE_UTCL0_CNTL2__DIS_EDC__SHIFT                                                                0xb
#define SQC_ICACHE_UTCL0_CNTL2__GPUVM_INV_MODE__SHIFT                                                         0xc
#define SQC_ICACHE_UTCL0_CNTL2__SHOOTDOWN_OPT__SHIFT                                                          0xd
#define SQC_ICACHE_UTCL0_CNTL2__FORCE_SNOOP__SHIFT                                                            0xe
#define SQC_ICACHE_UTCL0_CNTL2__FORCE_GPUVM_INV_ACK__SHIFT                                                    0xf
#define SQC_ICACHE_UTCL0_CNTL2__ARB_BURST_MODE__SHIFT                                                         0x10
#define SQC_ICACHE_UTCL0_CNTL2__ENABLE_PERF_EVENT_RD_WR__SHIFT                                                0x12
#define SQC_ICACHE_UTCL0_CNTL2__PERF_EVENT_RD_WR__SHIFT                                                       0x13
#define SQC_ICACHE_UTCL0_CNTL2__ENABLE_PERF_EVENT_VMID__SHIFT                                                 0x14
#define SQC_ICACHE_UTCL0_CNTL2__PERF_EVENT_VMID__SHIFT                                                        0x15
#define SQC_ICACHE_UTCL0_CNTL2__FORCE_FRAG_2M_TO_64K__SHIFT                                                   0x1a
#define SQC_ICACHE_UTCL0_CNTL2__PERM_MODE_OVRD__SHIFT                                                         0x1b
#define SQC_ICACHE_UTCL0_CNTL2__LINE_INVALIDATE_OPT__SHIFT                                                    0x1c
#define SQC_ICACHE_UTCL0_CNTL2__GPUVM_16K_DEF__SHIFT                                                          0x1d
#define SQC_ICACHE_UTCL0_CNTL2__FGCG_DISABLE__SHIFT                                                           0x1e
#define SQC_ICACHE_UTCL0_CNTL2__SPARE_MASK                                                                    0x000000FFL
#define SQC_ICACHE_UTCL0_CNTL2__LFIFO_SCAN_DISABLE_MASK                                                       0x00000100L
#define SQC_ICACHE_UTCL0_CNTL2__MTYPE_OVRD_DIS_MASK                                                           0x00000200L
#define SQC_ICACHE_UTCL0_CNTL2__LINE_VALID_MASK                                                               0x00000400L
#define SQC_ICACHE_UTCL0_CNTL2__DIS_EDC_MASK                                                                  0x00000800L
#define SQC_ICACHE_UTCL0_CNTL2__GPUVM_INV_MODE_MASK                                                           0x00001000L
#define SQC_ICACHE_UTCL0_CNTL2__SHOOTDOWN_OPT_MASK                                                            0x00002000L
#define SQC_ICACHE_UTCL0_CNTL2__FORCE_SNOOP_MASK                                                              0x00004000L
#define SQC_ICACHE_UTCL0_CNTL2__FORCE_GPUVM_INV_ACK_MASK                                                      0x00008000L
#define SQC_ICACHE_UTCL0_CNTL2__ARB_BURST_MODE_MASK                                                           0x00030000L
#define SQC_ICACHE_UTCL0_CNTL2__ENABLE_PERF_EVENT_RD_WR_MASK                                                  0x00040000L
#define SQC_ICACHE_UTCL0_CNTL2__PERF_EVENT_RD_WR_MASK                                                         0x00080000L
#define SQC_ICACHE_UTCL0_CNTL2__ENABLE_PERF_EVENT_VMID_MASK                                                   0x00100000L
#define SQC_ICACHE_UTCL0_CNTL2__PERF_EVENT_VMID_MASK                                                          0x01E00000L
#define SQC_ICACHE_UTCL0_CNTL2__FORCE_FRAG_2M_TO_64K_MASK                                                     0x04000000L
#define SQC_ICACHE_UTCL0_CNTL2__PERM_MODE_OVRD_MASK                                                           0x08000000L
#define SQC_ICACHE_UTCL0_CNTL2__LINE_INVALIDATE_OPT_MASK                                                      0x10000000L
#define SQC_ICACHE_UTCL0_CNTL2__GPUVM_16K_DEF_MASK                                                            0x20000000L
#define SQC_ICACHE_UTCL0_CNTL2__FGCG_DISABLE_MASK                                                             0x40000000L
//SQC_DCACHE_UTCL0_CNTL1
#define SQC_DCACHE_UTCL0_CNTL1__FORCE_4K_L2_RESP__SHIFT                                                       0x0
#define SQC_DCACHE_UTCL0_CNTL1__GPUVM_64K_DEF__SHIFT                                                          0x1
#define SQC_DCACHE_UTCL0_CNTL1__GPUVM_PERM_MODE__SHIFT                                                        0x2
#define SQC_DCACHE_UTCL0_CNTL1__RESP_MODE__SHIFT                                                              0x3
#define SQC_DCACHE_UTCL0_CNTL1__RESP_FAULT_MODE__SHIFT                                                        0x5
#define SQC_DCACHE_UTCL0_CNTL1__CLIENTID__SHIFT                                                               0x7
#define SQC_DCACHE_UTCL0_CNTL1__ENABLE_PUSH_LFIFO__SHIFT                                                      0x11
#define SQC_DCACHE_UTCL0_CNTL1__ENABLE_LFIFO_PRI_ARB__SHIFT                                                   0x12
#define SQC_DCACHE_UTCL0_CNTL1__REG_INV_VMID__SHIFT                                                           0x13
#define SQC_DCACHE_UTCL0_CNTL1__REG_INV_ALL_VMID__SHIFT                                                       0x17
#define SQC_DCACHE_UTCL0_CNTL1__REG_INV_TOGGLE__SHIFT                                                         0x18
#define SQC_DCACHE_UTCL0_CNTL1__CLIENT_INVALIDATE_ALL_VMID__SHIFT                                             0x19
#define SQC_DCACHE_UTCL0_CNTL1__FORCE_MISS__SHIFT                                                             0x1a
#define SQC_DCACHE_UTCL0_CNTL1__FORCE_IN_ORDER__SHIFT                                                         0x1b
#define SQC_DCACHE_UTCL0_CNTL1__REDUCE_FIFO_DEPTH_BY_2__SHIFT                                                 0x1c
#define SQC_DCACHE_UTCL0_CNTL1__REDUCE_CACHE_SIZE_BY_2__SHIFT                                                 0x1e
#define SQC_DCACHE_UTCL0_CNTL1__FORCE_4K_L2_RESP_MASK                                                         0x00000001L
#define SQC_DCACHE_UTCL0_CNTL1__GPUVM_64K_DEF_MASK                                                            0x00000002L
#define SQC_DCACHE_UTCL0_CNTL1__GPUVM_PERM_MODE_MASK                                                          0x00000004L
#define SQC_DCACHE_UTCL0_CNTL1__RESP_MODE_MASK                                                                0x00000018L
#define SQC_DCACHE_UTCL0_CNTL1__RESP_FAULT_MODE_MASK                                                          0x00000060L
#define SQC_DCACHE_UTCL0_CNTL1__CLIENTID_MASK                                                                 0x0000FF80L
#define SQC_DCACHE_UTCL0_CNTL1__ENABLE_PUSH_LFIFO_MASK                                                        0x00020000L
#define SQC_DCACHE_UTCL0_CNTL1__ENABLE_LFIFO_PRI_ARB_MASK                                                     0x00040000L
#define SQC_DCACHE_UTCL0_CNTL1__REG_INV_VMID_MASK                                                             0x00780000L
#define SQC_DCACHE_UTCL0_CNTL1__REG_INV_ALL_VMID_MASK                                                         0x00800000L
#define SQC_DCACHE_UTCL0_CNTL1__REG_INV_TOGGLE_MASK                                                           0x01000000L
#define SQC_DCACHE_UTCL0_CNTL1__CLIENT_INVALIDATE_ALL_VMID_MASK                                               0x02000000L
#define SQC_DCACHE_UTCL0_CNTL1__FORCE_MISS_MASK                                                               0x04000000L
#define SQC_DCACHE_UTCL0_CNTL1__FORCE_IN_ORDER_MASK                                                           0x08000000L
#define SQC_DCACHE_UTCL0_CNTL1__REDUCE_FIFO_DEPTH_BY_2_MASK                                                   0x30000000L
#define SQC_DCACHE_UTCL0_CNTL1__REDUCE_CACHE_SIZE_BY_2_MASK                                                   0xC0000000L
//SQC_DCACHE_UTCL0_CNTL2
#define SQC_DCACHE_UTCL0_CNTL2__SPARE__SHIFT                                                                  0x0
#define SQC_DCACHE_UTCL0_CNTL2__LFIFO_SCAN_DISABLE__SHIFT                                                     0x8
#define SQC_DCACHE_UTCL0_CNTL2__MTYPE_OVRD_DIS__SHIFT                                                         0x9
#define SQC_DCACHE_UTCL0_CNTL2__LINE_VALID__SHIFT                                                             0xa
#define SQC_DCACHE_UTCL0_CNTL2__DIS_EDC__SHIFT                                                                0xb
#define SQC_DCACHE_UTCL0_CNTL2__GPUVM_INV_MODE__SHIFT                                                         0xc
#define SQC_DCACHE_UTCL0_CNTL2__SHOOTDOWN_OPT__SHIFT                                                          0xd
#define SQC_DCACHE_UTCL0_CNTL2__FORCE_SNOOP__SHIFT                                                            0xe
#define SQC_DCACHE_UTCL0_CNTL2__FORCE_GPUVM_INV_ACK__SHIFT                                                    0xf
#define SQC_DCACHE_UTCL0_CNTL2__ARB_BURST_MODE__SHIFT                                                         0x10
#define SQC_DCACHE_UTCL0_CNTL2__ENABLE_PERF_EVENT_RD_WR__SHIFT                                                0x12
#define SQC_DCACHE_UTCL0_CNTL2__PERF_EVENT_RD_WR__SHIFT                                                       0x13
#define SQC_DCACHE_UTCL0_CNTL2__ENABLE_PERF_EVENT_VMID__SHIFT                                                 0x14
#define SQC_DCACHE_UTCL0_CNTL2__PERF_EVENT_VMID__SHIFT                                                        0x15
#define SQC_DCACHE_UTCL0_CNTL2__FORCE_FRAG_2M_TO_64K__SHIFT                                                   0x1a
#define SQC_DCACHE_UTCL0_CNTL2__PERM_MODE_OVRD__SHIFT                                                         0x1b
#define SQC_DCACHE_UTCL0_CNTL2__LINE_INVALIDATE_OPT__SHIFT                                                    0x1c
#define SQC_DCACHE_UTCL0_CNTL2__GPUVM_16K_DEF__SHIFT                                                          0x1d
#define SQC_DCACHE_UTCL0_CNTL2__FGCG_DISABLE__SHIFT                                                           0x1e
#define SQC_DCACHE_UTCL0_CNTL2__SPARE_MASK                                                                    0x000000FFL
#define SQC_DCACHE_UTCL0_CNTL2__LFIFO_SCAN_DISABLE_MASK                                                       0x00000100L
#define SQC_DCACHE_UTCL0_CNTL2__MTYPE_OVRD_DIS_MASK                                                           0x00000200L
#define SQC_DCACHE_UTCL0_CNTL2__LINE_VALID_MASK                                                               0x00000400L
#define SQC_DCACHE_UTCL0_CNTL2__DIS_EDC_MASK                                                                  0x00000800L
#define SQC_DCACHE_UTCL0_CNTL2__GPUVM_INV_MODE_MASK                                                           0x00001000L
#define SQC_DCACHE_UTCL0_CNTL2__SHOOTDOWN_OPT_MASK                                                            0x00002000L
#define SQC_DCACHE_UTCL0_CNTL2__FORCE_SNOOP_MASK                                                              0x00004000L
#define SQC_DCACHE_UTCL0_CNTL2__FORCE_GPUVM_INV_ACK_MASK                                                      0x00008000L
#define SQC_DCACHE_UTCL0_CNTL2__ARB_BURST_MODE_MASK                                                           0x00030000L
#define SQC_DCACHE_UTCL0_CNTL2__ENABLE_PERF_EVENT_RD_WR_MASK                                                  0x00040000L
#define SQC_DCACHE_UTCL0_CNTL2__PERF_EVENT_RD_WR_MASK                                                         0x00080000L
#define SQC_DCACHE_UTCL0_CNTL2__ENABLE_PERF_EVENT_VMID_MASK                                                   0x00100000L
#define SQC_DCACHE_UTCL0_CNTL2__PERF_EVENT_VMID_MASK                                                          0x01E00000L
#define SQC_DCACHE_UTCL0_CNTL2__FORCE_FRAG_2M_TO_64K_MASK                                                     0x04000000L
#define SQC_DCACHE_UTCL0_CNTL2__PERM_MODE_OVRD_MASK                                                           0x08000000L
#define SQC_DCACHE_UTCL0_CNTL2__LINE_INVALIDATE_OPT_MASK                                                      0x10000000L
#define SQC_DCACHE_UTCL0_CNTL2__GPUVM_16K_DEF_MASK                                                            0x20000000L
#define SQC_DCACHE_UTCL0_CNTL2__FGCG_DISABLE_MASK                                                             0x40000000L
//SQC_ICACHE_UTCL0_STATUS
#define SQC_ICACHE_UTCL0_STATUS__FAULT_DETECTED__SHIFT                                                        0x0
#define SQC_ICACHE_UTCL0_STATUS__RETRY_DETECTED__SHIFT                                                        0x1
#define SQC_ICACHE_UTCL0_STATUS__PRT_DETECTED__SHIFT                                                          0x2
#define SQC_ICACHE_UTCL0_STATUS__FAULT_DETECTED_MASK                                                          0x00000001L
#define SQC_ICACHE_UTCL0_STATUS__RETRY_DETECTED_MASK                                                          0x00000002L
#define SQC_ICACHE_UTCL0_STATUS__PRT_DETECTED_MASK                                                            0x00000004L
//SQC_DCACHE_UTCL0_STATUS
#define SQC_DCACHE_UTCL0_STATUS__FAULT_DETECTED__SHIFT                                                        0x0
#define SQC_DCACHE_UTCL0_STATUS__RETRY_DETECTED__SHIFT                                                        0x1
#define SQC_DCACHE_UTCL0_STATUS__PRT_DETECTED__SHIFT                                                          0x2
#define SQC_DCACHE_UTCL0_STATUS__FAULT_DETECTED_MASK                                                          0x00000001L
#define SQC_DCACHE_UTCL0_STATUS__RETRY_DETECTED_MASK                                                          0x00000002L
#define SQC_DCACHE_UTCL0_STATUS__PRT_DETECTED_MASK                                                            0x00000004L


// addressBlock: gc_shsdec
//SX_DEBUG_1
#define SX_DEBUG_1__SX_DB_QUAD_CREDIT__SHIFT                                                                  0x0
#define SX_DEBUG_1__DISABLE_BLEND_OPT_DONT_RD_DST__SHIFT                                                      0x8
#define SX_DEBUG_1__DISABLE_BLEND_OPT_BYPASS__SHIFT                                                           0x9
#define SX_DEBUG_1__DISABLE_BLEND_OPT_DISCARD_PIXEL__SHIFT                                                    0xa
#define SX_DEBUG_1__DISABLE_QUAD_PAIR_OPT__SHIFT                                                              0xb
#define SX_DEBUG_1__DISABLE_PIX_EN_ZERO_OPT__SHIFT                                                            0xc
#define SX_DEBUG_1__DISABLE_REP_FGCG__SHIFT                                                                   0xd
#define SX_DEBUG_1__ENABLE_SAME_PC_GDS_CGTS__SHIFT                                                            0xe
#define SX_DEBUG_1__DISABLE_RAM_FGCG__SHIFT                                                                   0xf
#define SX_DEBUG_1__PC_DISABLE_SAME_ADDR_OPT__SHIFT                                                           0x10
#define SX_DEBUG_1__DISABLE_COL_VAL_READ_OPT__SHIFT                                                           0x11
#define SX_DEBUG_1__DISABLE_BC_RB_PLUS__SHIFT                                                                 0x12
#define SX_DEBUG_1__DISABLE_NATIVE_DOWNCVT_FMT_MAPPING__SHIFT                                                 0x13
#define SX_DEBUG_1__DISABLE_SCBD_READ_PWR_OPT__SHIFT                                                          0x14
#define SX_DEBUG_1__DISABLE_GDS_CGTS_OPT__SHIFT                                                               0x15
#define SX_DEBUG_1__DISABLE_DOWNCVT_PWR_OPT__SHIFT                                                            0x16
#define SX_DEBUG_1__DEBUG_DATA__SHIFT                                                                         0x17
#define SX_DEBUG_1__SX_DB_QUAD_CREDIT_MASK                                                                    0x0000007FL
#define SX_DEBUG_1__DISABLE_BLEND_OPT_DONT_RD_DST_MASK                                                        0x00000100L
#define SX_DEBUG_1__DISABLE_BLEND_OPT_BYPASS_MASK                                                             0x00000200L
#define SX_DEBUG_1__DISABLE_BLEND_OPT_DISCARD_PIXEL_MASK                                                      0x00000400L
#define SX_DEBUG_1__DISABLE_QUAD_PAIR_OPT_MASK                                                                0x00000800L
#define SX_DEBUG_1__DISABLE_PIX_EN_ZERO_OPT_MASK                                                              0x00001000L
#define SX_DEBUG_1__DISABLE_REP_FGCG_MASK                                                                     0x00002000L
#define SX_DEBUG_1__ENABLE_SAME_PC_GDS_CGTS_MASK                                                              0x00004000L
#define SX_DEBUG_1__DISABLE_RAM_FGCG_MASK                                                                     0x00008000L
#define SX_DEBUG_1__PC_DISABLE_SAME_ADDR_OPT_MASK                                                             0x00010000L
#define SX_DEBUG_1__DISABLE_COL_VAL_READ_OPT_MASK                                                             0x00020000L
#define SX_DEBUG_1__DISABLE_BC_RB_PLUS_MASK                                                                   0x00040000L
#define SX_DEBUG_1__DISABLE_NATIVE_DOWNCVT_FMT_MAPPING_MASK                                                   0x00080000L
#define SX_DEBUG_1__DISABLE_SCBD_READ_PWR_OPT_MASK                                                            0x00100000L
#define SX_DEBUG_1__DISABLE_GDS_CGTS_OPT_MASK                                                                 0x00200000L
#define SX_DEBUG_1__DISABLE_DOWNCVT_PWR_OPT_MASK                                                              0x00400000L
#define SX_DEBUG_1__DEBUG_DATA_MASK                                                                           0xFF800000L
//SPI_PS_MAX_WAVE_ID
#define SPI_PS_MAX_WAVE_ID__MAX_WAVE_ID__SHIFT                                                                0x0
#define SPI_PS_MAX_WAVE_ID__MAX_COLLISION_WAVE_ID__SHIFT                                                      0x10
#define SPI_PS_MAX_WAVE_ID__MAX_WAVE_ID_MASK                                                                  0x00000FFFL
#define SPI_PS_MAX_WAVE_ID__MAX_COLLISION_WAVE_ID_MASK                                                        0x03FF0000L
//SPI_START_PHASE
#define SPI_START_PHASE__PC_X_PHASE_SE0__SHIFT                                                                0x0
#define SPI_START_PHASE__PC_X_PHASE_SE1__SHIFT                                                                0x2
#define SPI_START_PHASE__PC_X_PHASE_SE2__SHIFT                                                                0x4
#define SPI_START_PHASE__PC_X_PHASE_SE3__SHIFT                                                                0x6
#define SPI_START_PHASE__PC_X_PHASE_SE0_MASK                                                                  0x00000003L
#define SPI_START_PHASE__PC_X_PHASE_SE1_MASK                                                                  0x0000000CL
#define SPI_START_PHASE__PC_X_PHASE_SE2_MASK                                                                  0x00000030L
#define SPI_START_PHASE__PC_X_PHASE_SE3_MASK                                                                  0x000000C0L
//SPI_GFX_CNTL
#define SPI_GFX_CNTL__RESET_COUNTS__SHIFT                                                                     0x0
#define SPI_GFX_CNTL__RESET_COUNTS_MASK                                                                       0x00000001L
//SPI_DSM_CNTL
#define SPI_DSM_CNTL__SPI_SR_MEM_DSM_IRRITATOR_DATA__SHIFT                                                    0x0
#define SPI_DSM_CNTL__SPI_SR_MEM_ENABLE_SINGLE_WRITE__SHIFT                                                   0x2
#define SPI_DSM_CNTL__SPI_SR_MEM_DSM_IRRITATOR_DATA_MASK                                                      0x00000003L
#define SPI_DSM_CNTL__SPI_SR_MEM_ENABLE_SINGLE_WRITE_MASK                                                     0x00000004L
//SPI_DSM_CNTL2
#define SPI_DSM_CNTL2__SPI_SR_MEM_ENABLE_ERROR_INJECT__SHIFT                                                  0x0
#define SPI_DSM_CNTL2__SPI_SR_MEM_SELECT_INJECT_DELAY__SHIFT                                                  0x2
#define SPI_DSM_CNTL2__SPI_SR_MEM_INJECT_DELAY__SHIFT                                                         0x3
#define SPI_DSM_CNTL2__SPI_SR_MEM_ENABLE_ERROR_INJECT_MASK                                                    0x00000003L
#define SPI_DSM_CNTL2__SPI_SR_MEM_SELECT_INJECT_DELAY_MASK                                                    0x00000004L
#define SPI_DSM_CNTL2__SPI_SR_MEM_INJECT_DELAY_MASK                                                           0x000001F8L
//SPI_EDC_CNT
#define SPI_EDC_CNT__SPI_SR_MEM_SED_COUNT__SHIFT                                                              0x0
#define SPI_EDC_CNT__SPI_SR_MEM_SED_COUNT_MASK                                                                0x00000003L
//SPI_USER_ACCUM_VMID_CNTL
#define SPI_USER_ACCUM_VMID_CNTL__EN_USER_ACCUM__SHIFT                                                        0x0
#define SPI_USER_ACCUM_VMID_CNTL__EN_USER_ACCUM_MASK                                                          0x0000000FL
//SPI_CONFIG_CNTL
#define SPI_CONFIG_CNTL__GPR_WRITE_PRIORITY__SHIFT                                                            0x0
#define SPI_CONFIG_CNTL__EXP_PRIORITY_ORDER__SHIFT                                                            0x15
#define SPI_CONFIG_CNTL__ENABLE_SQG_TOP_EVENTS__SHIFT                                                         0x18
#define SPI_CONFIG_CNTL__ENABLE_SQG_BOP_EVENTS__SHIFT                                                         0x19
#define SPI_CONFIG_CNTL__FORCE_HALF_RATE_PC_EXP__SHIFT                                                        0x1a
#define SPI_CONFIG_CNTL__TTRACE_STALL_ALL__SHIFT                                                              0x1b
#define SPI_CONFIG_CNTL__ALLOC_ARB_LRU_ENA__SHIFT                                                             0x1c
#define SPI_CONFIG_CNTL__EXP_ARB_LRU_ENA__SHIFT                                                               0x1d
#define SPI_CONFIG_CNTL__PS_PKR_PRIORITY_CNTL__SHIFT                                                          0x1e
#define SPI_CONFIG_CNTL__GPR_WRITE_PRIORITY_MASK                                                              0x001FFFFFL
#define SPI_CONFIG_CNTL__EXP_PRIORITY_ORDER_MASK                                                              0x00E00000L
#define SPI_CONFIG_CNTL__ENABLE_SQG_TOP_EVENTS_MASK                                                           0x01000000L
#define SPI_CONFIG_CNTL__ENABLE_SQG_BOP_EVENTS_MASK                                                           0x02000000L
#define SPI_CONFIG_CNTL__FORCE_HALF_RATE_PC_EXP_MASK                                                          0x04000000L
#define SPI_CONFIG_CNTL__TTRACE_STALL_ALL_MASK                                                                0x08000000L
#define SPI_CONFIG_CNTL__ALLOC_ARB_LRU_ENA_MASK                                                               0x10000000L
#define SPI_CONFIG_CNTL__EXP_ARB_LRU_ENA_MASK                                                                 0x20000000L
#define SPI_CONFIG_CNTL__PS_PKR_PRIORITY_CNTL_MASK                                                            0xC0000000L
//SPI_WAVE_LIMIT_CNTL
#define SPI_WAVE_LIMIT_CNTL__PS_WAVE_GRAN__SHIFT                                                              0x0
#define SPI_WAVE_LIMIT_CNTL__VS_WAVE_GRAN__SHIFT                                                              0x2
#define SPI_WAVE_LIMIT_CNTL__GS_WAVE_GRAN__SHIFT                                                              0x4
#define SPI_WAVE_LIMIT_CNTL__HS_WAVE_GRAN__SHIFT                                                              0x6
#define SPI_WAVE_LIMIT_CNTL__PS_WAVE_GRAN_MASK                                                                0x00000003L
#define SPI_WAVE_LIMIT_CNTL__VS_WAVE_GRAN_MASK                                                                0x0000000CL
#define SPI_WAVE_LIMIT_CNTL__GS_WAVE_GRAN_MASK                                                                0x00000030L
#define SPI_WAVE_LIMIT_CNTL__HS_WAVE_GRAN_MASK                                                                0x000000C0L
//SPI_CONFIG_CNTL_2
#define SPI_CONFIG_CNTL_2__CONTEXT_SAVE_WAIT_GDS_REQUEST_CYCLE_OVHD__SHIFT                                    0x0
#define SPI_CONFIG_CNTL_2__CONTEXT_SAVE_WAIT_GDS_GRANT_CYCLE_OVHD__SHIFT                                      0x4
#define SPI_CONFIG_CNTL_2__CONTEXT_SAVE_WAIT_GDS_REQUEST_CYCLE_OVHD_MASK                                      0x0000000FL
#define SPI_CONFIG_CNTL_2__CONTEXT_SAVE_WAIT_GDS_GRANT_CYCLE_OVHD_MASK                                        0x000000F0L
//SPI_CONFIG_CNTL_1
#define SPI_CONFIG_CNTL_1__VTX_DONE_DELAY__SHIFT                                                              0x0
#define SPI_CONFIG_CNTL_1__INTERP_ONE_PRIM_PER_ROW__SHIFT                                                     0x4
#define SPI_CONFIG_CNTL_1__PC_LIMIT_ENABLE__SHIFT                                                             0x5
#define SPI_CONFIG_CNTL_1__PC_LIMIT_STRICT__SHIFT                                                             0x7
#define SPI_CONFIG_CNTL_1__CRC_SIMD_ID_WADDR_DISABLE__SHIFT                                                   0x8
#define SPI_CONFIG_CNTL_1__LBPW_CU_CHK_MODE__SHIFT                                                            0x9
#define SPI_CONFIG_CNTL_1__LBPW_CU_CHK_CNT__SHIFT                                                             0xa
#define SPI_CONFIG_CNTL_1__CSC_PWR_SAVE_DISABLE__SHIFT                                                        0xe
#define SPI_CONFIG_CNTL_1__CSG_PWR_SAVE_DISABLE__SHIFT                                                        0xf
#define SPI_CONFIG_CNTL_1__MAX_VTX_SYNC_CNT__SHIFT                                                            0x10
#define SPI_CONFIG_CNTL_1__EN_USER_ACCUM__SHIFT                                                               0x15
#define SPI_CONFIG_CNTL_1__SA_SCREEN_MAP__SHIFT                                                               0x16
#define SPI_CONFIG_CNTL_1__RESERVED__SHIFT                                                                    0x17
#define SPI_CONFIG_CNTL_1__VTX_DONE_DELAY_MASK                                                                0x0000000FL
#define SPI_CONFIG_CNTL_1__INTERP_ONE_PRIM_PER_ROW_MASK                                                       0x00000010L
#define SPI_CONFIG_CNTL_1__PC_LIMIT_ENABLE_MASK                                                               0x00000060L
#define SPI_CONFIG_CNTL_1__PC_LIMIT_STRICT_MASK                                                               0x00000080L
#define SPI_CONFIG_CNTL_1__CRC_SIMD_ID_WADDR_DISABLE_MASK                                                     0x00000100L
#define SPI_CONFIG_CNTL_1__LBPW_CU_CHK_MODE_MASK                                                              0x00000200L
#define SPI_CONFIG_CNTL_1__LBPW_CU_CHK_CNT_MASK                                                               0x00003C00L
#define SPI_CONFIG_CNTL_1__CSC_PWR_SAVE_DISABLE_MASK                                                          0x00004000L
#define SPI_CONFIG_CNTL_1__CSG_PWR_SAVE_DISABLE_MASK                                                          0x00008000L
#define SPI_CONFIG_CNTL_1__MAX_VTX_SYNC_CNT_MASK                                                              0x001F0000L
#define SPI_CONFIG_CNTL_1__EN_USER_ACCUM_MASK                                                                 0x00200000L
#define SPI_CONFIG_CNTL_1__SA_SCREEN_MAP_MASK                                                                 0x00400000L
#define SPI_CONFIG_CNTL_1__RESERVED_MASK                                                                      0xFF800000L
//SPI_CONFIG_PS_CU_EN
#define SPI_CONFIG_PS_CU_EN__PKR_OFFSET__SHIFT                                                                0x0
#define SPI_CONFIG_PS_CU_EN__PKR_OFFSET_MASK                                                                  0x0000000FL
//SPI_WF_LIFETIME_CNTL
#define SPI_WF_LIFETIME_CNTL__SAMPLE_PERIOD__SHIFT                                                            0x0
#define SPI_WF_LIFETIME_CNTL__EN__SHIFT                                                                       0x4
#define SPI_WF_LIFETIME_CNTL__SAMPLE_PERIOD_MASK                                                              0x0000000FL
#define SPI_WF_LIFETIME_CNTL__EN_MASK                                                                         0x00000010L
//SPI_WF_LIFETIME_LIMIT_0
#define SPI_WF_LIFETIME_LIMIT_0__MAX_CNT__SHIFT                                                               0x0
#define SPI_WF_LIFETIME_LIMIT_0__EN_WARN__SHIFT                                                               0x1f
#define SPI_WF_LIFETIME_LIMIT_0__MAX_CNT_MASK                                                                 0x7FFFFFFFL
#define SPI_WF_LIFETIME_LIMIT_0__EN_WARN_MASK                                                                 0x80000000L
//SPI_WF_LIFETIME_LIMIT_1
#define SPI_WF_LIFETIME_LIMIT_1__MAX_CNT__SHIFT                                                               0x0
#define SPI_WF_LIFETIME_LIMIT_1__EN_WARN__SHIFT                                                               0x1f
#define SPI_WF_LIFETIME_LIMIT_1__MAX_CNT_MASK                                                                 0x7FFFFFFFL
#define SPI_WF_LIFETIME_LIMIT_1__EN_WARN_MASK                                                                 0x80000000L
//SPI_WF_LIFETIME_LIMIT_2
#define SPI_WF_LIFETIME_LIMIT_2__MAX_CNT__SHIFT                                                               0x0
#define SPI_WF_LIFETIME_LIMIT_2__EN_WARN__SHIFT                                                               0x1f
#define SPI_WF_LIFETIME_LIMIT_2__MAX_CNT_MASK                                                                 0x7FFFFFFFL
#define SPI_WF_LIFETIME_LIMIT_2__EN_WARN_MASK                                                                 0x80000000L
//SPI_WF_LIFETIME_LIMIT_3
#define SPI_WF_LIFETIME_LIMIT_3__MAX_CNT__SHIFT                                                               0x0
#define SPI_WF_LIFETIME_LIMIT_3__EN_WARN__SHIFT                                                               0x1f
#define SPI_WF_LIFETIME_LIMIT_3__MAX_CNT_MASK                                                                 0x7FFFFFFFL
#define SPI_WF_LIFETIME_LIMIT_3__EN_WARN_MASK                                                                 0x80000000L
//SPI_WF_LIFETIME_LIMIT_4
#define SPI_WF_LIFETIME_LIMIT_4__MAX_CNT__SHIFT                                                               0x0
#define SPI_WF_LIFETIME_LIMIT_4__EN_WARN__SHIFT                                                               0x1f
#define SPI_WF_LIFETIME_LIMIT_4__MAX_CNT_MASK                                                                 0x7FFFFFFFL
#define SPI_WF_LIFETIME_LIMIT_4__EN_WARN_MASK                                                                 0x80000000L
//SPI_WF_LIFETIME_LIMIT_5
#define SPI_WF_LIFETIME_LIMIT_5__MAX_CNT__SHIFT                                                               0x0
#define SPI_WF_LIFETIME_LIMIT_5__EN_WARN__SHIFT                                                               0x1f
#define SPI_WF_LIFETIME_LIMIT_5__MAX_CNT_MASK                                                                 0x7FFFFFFFL
#define SPI_WF_LIFETIME_LIMIT_5__EN_WARN_MASK                                                                 0x80000000L
//SPI_WF_LIFETIME_STATUS_0
#define SPI_WF_LIFETIME_STATUS_0__MAX_CNT__SHIFT                                                              0x0
#define SPI_WF_LIFETIME_STATUS_0__INT_SENT__SHIFT                                                             0x1f
#define SPI_WF_LIFETIME_STATUS_0__MAX_CNT_MASK                                                                0x7FFFFFFFL
#define SPI_WF_LIFETIME_STATUS_0__INT_SENT_MASK                                                               0x80000000L
//SPI_WF_LIFETIME_STATUS_1
#define SPI_WF_LIFETIME_STATUS_1__MAX_CNT__SHIFT                                                              0x0
#define SPI_WF_LIFETIME_STATUS_1__INT_SENT__SHIFT                                                             0x1f
#define SPI_WF_LIFETIME_STATUS_1__MAX_CNT_MASK                                                                0x7FFFFFFFL
#define SPI_WF_LIFETIME_STATUS_1__INT_SENT_MASK                                                               0x80000000L
//SPI_WF_LIFETIME_STATUS_2
#define SPI_WF_LIFETIME_STATUS_2__MAX_CNT__SHIFT                                                              0x0
#define SPI_WF_LIFETIME_STATUS_2__INT_SENT__SHIFT                                                             0x1f
#define SPI_WF_LIFETIME_STATUS_2__MAX_CNT_MASK                                                                0x7FFFFFFFL
#define SPI_WF_LIFETIME_STATUS_2__INT_SENT_MASK                                                               0x80000000L
//SPI_WF_LIFETIME_STATUS_4
#define SPI_WF_LIFETIME_STATUS_4__MAX_CNT__SHIFT                                                              0x0
#define SPI_WF_LIFETIME_STATUS_4__INT_SENT__SHIFT                                                             0x1f
#define SPI_WF_LIFETIME_STATUS_4__MAX_CNT_MASK                                                                0x7FFFFFFFL
#define SPI_WF_LIFETIME_STATUS_4__INT_SENT_MASK                                                               0x80000000L
//SPI_WF_LIFETIME_STATUS_6
#define SPI_WF_LIFETIME_STATUS_6__MAX_CNT__SHIFT                                                              0x0
#define SPI_WF_LIFETIME_STATUS_6__INT_SENT__SHIFT                                                             0x1f
#define SPI_WF_LIFETIME_STATUS_6__MAX_CNT_MASK                                                                0x7FFFFFFFL
#define SPI_WF_LIFETIME_STATUS_6__INT_SENT_MASK                                                               0x80000000L
//SPI_WF_LIFETIME_STATUS_7
#define SPI_WF_LIFETIME_STATUS_7__MAX_CNT__SHIFT                                                              0x0
#define SPI_WF_LIFETIME_STATUS_7__INT_SENT__SHIFT                                                             0x1f
#define SPI_WF_LIFETIME_STATUS_7__MAX_CNT_MASK                                                                0x7FFFFFFFL
#define SPI_WF_LIFETIME_STATUS_7__INT_SENT_MASK                                                               0x80000000L
//SPI_WF_LIFETIME_STATUS_8
#define SPI_WF_LIFETIME_STATUS_8__MAX_CNT__SHIFT                                                              0x0
#define SPI_WF_LIFETIME_STATUS_8__INT_SENT__SHIFT                                                             0x1f
#define SPI_WF_LIFETIME_STATUS_8__MAX_CNT_MASK                                                                0x7FFFFFFFL
#define SPI_WF_LIFETIME_STATUS_8__INT_SENT_MASK                                                               0x80000000L
//SPI_WF_LIFETIME_STATUS_9
#define SPI_WF_LIFETIME_STATUS_9__MAX_CNT__SHIFT                                                              0x0
#define SPI_WF_LIFETIME_STATUS_9__INT_SENT__SHIFT                                                             0x1f
#define SPI_WF_LIFETIME_STATUS_9__MAX_CNT_MASK                                                                0x7FFFFFFFL
#define SPI_WF_LIFETIME_STATUS_9__INT_SENT_MASK                                                               0x80000000L
//SPI_WF_LIFETIME_STATUS_11
#define SPI_WF_LIFETIME_STATUS_11__MAX_CNT__SHIFT                                                             0x0
#define SPI_WF_LIFETIME_STATUS_11__INT_SENT__SHIFT                                                            0x1f
#define SPI_WF_LIFETIME_STATUS_11__MAX_CNT_MASK                                                               0x7FFFFFFFL
#define SPI_WF_LIFETIME_STATUS_11__INT_SENT_MASK                                                              0x80000000L
//SPI_WF_LIFETIME_STATUS_13
#define SPI_WF_LIFETIME_STATUS_13__MAX_CNT__SHIFT                                                             0x0
#define SPI_WF_LIFETIME_STATUS_13__INT_SENT__SHIFT                                                            0x1f
#define SPI_WF_LIFETIME_STATUS_13__MAX_CNT_MASK                                                               0x7FFFFFFFL
#define SPI_WF_LIFETIME_STATUS_13__INT_SENT_MASK                                                              0x80000000L
//SPI_WF_LIFETIME_STATUS_14
#define SPI_WF_LIFETIME_STATUS_14__MAX_CNT__SHIFT                                                             0x0
#define SPI_WF_LIFETIME_STATUS_14__INT_SENT__SHIFT                                                            0x1f
#define SPI_WF_LIFETIME_STATUS_14__MAX_CNT_MASK                                                               0x7FFFFFFFL
#define SPI_WF_LIFETIME_STATUS_14__INT_SENT_MASK                                                              0x80000000L
//SPI_WF_LIFETIME_STATUS_15
#define SPI_WF_LIFETIME_STATUS_15__MAX_CNT__SHIFT                                                             0x0
#define SPI_WF_LIFETIME_STATUS_15__INT_SENT__SHIFT                                                            0x1f
#define SPI_WF_LIFETIME_STATUS_15__MAX_CNT_MASK                                                               0x7FFFFFFFL
#define SPI_WF_LIFETIME_STATUS_15__INT_SENT_MASK                                                              0x80000000L
//SPI_WF_LIFETIME_STATUS_16
#define SPI_WF_LIFETIME_STATUS_16__MAX_CNT__SHIFT                                                             0x0
#define SPI_WF_LIFETIME_STATUS_16__INT_SENT__SHIFT                                                            0x1f
#define SPI_WF_LIFETIME_STATUS_16__MAX_CNT_MASK                                                               0x7FFFFFFFL
#define SPI_WF_LIFETIME_STATUS_16__INT_SENT_MASK                                                              0x80000000L
//SPI_WF_LIFETIME_STATUS_17
#define SPI_WF_LIFETIME_STATUS_17__MAX_CNT__SHIFT                                                             0x0
#define SPI_WF_LIFETIME_STATUS_17__INT_SENT__SHIFT                                                            0x1f
#define SPI_WF_LIFETIME_STATUS_17__MAX_CNT_MASK                                                               0x7FFFFFFFL
#define SPI_WF_LIFETIME_STATUS_17__INT_SENT_MASK                                                              0x80000000L
//SPI_WF_LIFETIME_STATUS_18
#define SPI_WF_LIFETIME_STATUS_18__MAX_CNT__SHIFT                                                             0x0
#define SPI_WF_LIFETIME_STATUS_18__INT_SENT__SHIFT                                                            0x1f
#define SPI_WF_LIFETIME_STATUS_18__MAX_CNT_MASK                                                               0x7FFFFFFFL
#define SPI_WF_LIFETIME_STATUS_18__INT_SENT_MASK                                                              0x80000000L
//SPI_WF_LIFETIME_STATUS_19
#define SPI_WF_LIFETIME_STATUS_19__MAX_CNT__SHIFT                                                             0x0
#define SPI_WF_LIFETIME_STATUS_19__INT_SENT__SHIFT                                                            0x1f
#define SPI_WF_LIFETIME_STATUS_19__MAX_CNT_MASK                                                               0x7FFFFFFFL
#define SPI_WF_LIFETIME_STATUS_19__INT_SENT_MASK                                                              0x80000000L
//SPI_WF_LIFETIME_STATUS_20
#define SPI_WF_LIFETIME_STATUS_20__MAX_CNT__SHIFT                                                             0x0
#define SPI_WF_LIFETIME_STATUS_20__INT_SENT__SHIFT                                                            0x1f
#define SPI_WF_LIFETIME_STATUS_20__MAX_CNT_MASK                                                               0x7FFFFFFFL
#define SPI_WF_LIFETIME_STATUS_20__INT_SENT_MASK                                                              0x80000000L
//SPI_WF_LIFETIME_STATUS_21
#define SPI_WF_LIFETIME_STATUS_21__MAX_CNT__SHIFT                                                             0x0
#define SPI_WF_LIFETIME_STATUS_21__INT_SENT__SHIFT                                                            0x1f
#define SPI_WF_LIFETIME_STATUS_21__MAX_CNT_MASK                                                               0x7FFFFFFFL
#define SPI_WF_LIFETIME_STATUS_21__INT_SENT_MASK                                                              0x80000000L
//SPI_LB_CTR_CTRL
#define SPI_LB_CTR_CTRL__LOAD__SHIFT                                                                          0x0
#define SPI_LB_CTR_CTRL__WAVES_SELECT__SHIFT                                                                  0x1
#define SPI_LB_CTR_CTRL__CLEAR_ON_READ__SHIFT                                                                 0x3
#define SPI_LB_CTR_CTRL__RESET_COUNTS__SHIFT                                                                  0x4
#define SPI_LB_CTR_CTRL__LOAD_MASK                                                                            0x00000001L
#define SPI_LB_CTR_CTRL__WAVES_SELECT_MASK                                                                    0x00000006L
#define SPI_LB_CTR_CTRL__CLEAR_ON_READ_MASK                                                                   0x00000008L
#define SPI_LB_CTR_CTRL__RESET_COUNTS_MASK                                                                    0x00000010L
//SPI_LB_WGP_MASK
#define SPI_LB_WGP_MASK__WGP_MASK__SHIFT                                                                      0x0
#define SPI_LB_WGP_MASK__WGP_MASK_MASK                                                                        0xFFFFL
//SPI_LB_DATA_REG
#define SPI_LB_DATA_REG__CNT_DATA__SHIFT                                                                      0x0
#define SPI_LB_DATA_REG__CNT_DATA_MASK                                                                        0xFFFFFFFFL
//SPI_PG_ENABLE_STATIC_WGP_MASK
#define SPI_PG_ENABLE_STATIC_WGP_MASK__WGP_MASK__SHIFT                                                        0x0
#define SPI_PG_ENABLE_STATIC_WGP_MASK__WGP_MASK_MASK                                                          0xFFFFL
//SPI_GDS_CREDITS
#define SPI_GDS_CREDITS__DS_DATA_CREDITS__SHIFT                                                               0x0
#define SPI_GDS_CREDITS__DS_CMD_CREDITS__SHIFT                                                                0x8
#define SPI_GDS_CREDITS__DS_DATA_CREDITS_MASK                                                                 0x000000FFL
#define SPI_GDS_CREDITS__DS_CMD_CREDITS_MASK                                                                  0x0000FF00L
//SPI_SX_EXPORT_BUFFER_SIZES
#define SPI_SX_EXPORT_BUFFER_SIZES__COLOR_BUFFER_SIZE__SHIFT                                                  0x0
#define SPI_SX_EXPORT_BUFFER_SIZES__POSITION_BUFFER_SIZE__SHIFT                                               0x10
#define SPI_SX_EXPORT_BUFFER_SIZES__COLOR_BUFFER_SIZE_MASK                                                    0x0000FFFFL
#define SPI_SX_EXPORT_BUFFER_SIZES__POSITION_BUFFER_SIZE_MASK                                                 0xFFFF0000L
//SPI_SX_SCOREBOARD_BUFFER_SIZES
#define SPI_SX_SCOREBOARD_BUFFER_SIZES__COLOR_SCOREBOARD_SIZE__SHIFT                                          0x0
#define SPI_SX_SCOREBOARD_BUFFER_SIZES__POSITION_SCOREBOARD_SIZE__SHIFT                                       0x10
#define SPI_SX_SCOREBOARD_BUFFER_SIZES__COLOR_SCOREBOARD_SIZE_MASK                                            0x0000FFFFL
#define SPI_SX_SCOREBOARD_BUFFER_SIZES__POSITION_SCOREBOARD_SIZE_MASK                                         0xFFFF0000L
//SPI_CSQ_WF_ACTIVE_STATUS
#define SPI_CSQ_WF_ACTIVE_STATUS__ACTIVE__SHIFT                                                               0x0
#define SPI_CSQ_WF_ACTIVE_STATUS__ACTIVE_MASK                                                                 0xFFFFFFFFL
//SPI_CSQ_WF_ACTIVE_COUNT_0
#define SPI_CSQ_WF_ACTIVE_COUNT_0__COUNT__SHIFT                                                               0x0
#define SPI_CSQ_WF_ACTIVE_COUNT_0__EVENTS__SHIFT                                                              0x10
#define SPI_CSQ_WF_ACTIVE_COUNT_0__COUNT_MASK                                                                 0x000007FFL
#define SPI_CSQ_WF_ACTIVE_COUNT_0__EVENTS_MASK                                                                0x07FF0000L
//SPI_CSQ_WF_ACTIVE_COUNT_1
#define SPI_CSQ_WF_ACTIVE_COUNT_1__COUNT__SHIFT                                                               0x0
#define SPI_CSQ_WF_ACTIVE_COUNT_1__EVENTS__SHIFT                                                              0x10
#define SPI_CSQ_WF_ACTIVE_COUNT_1__COUNT_MASK                                                                 0x000007FFL
#define SPI_CSQ_WF_ACTIVE_COUNT_1__EVENTS_MASK                                                                0x07FF0000L
//SPI_CSQ_WF_ACTIVE_COUNT_2
#define SPI_CSQ_WF_ACTIVE_COUNT_2__COUNT__SHIFT                                                               0x0
#define SPI_CSQ_WF_ACTIVE_COUNT_2__EVENTS__SHIFT                                                              0x10
#define SPI_CSQ_WF_ACTIVE_COUNT_2__COUNT_MASK                                                                 0x000007FFL
#define SPI_CSQ_WF_ACTIVE_COUNT_2__EVENTS_MASK                                                                0x07FF0000L
//SPI_CSQ_WF_ACTIVE_COUNT_3
#define SPI_CSQ_WF_ACTIVE_COUNT_3__COUNT__SHIFT                                                               0x0
#define SPI_CSQ_WF_ACTIVE_COUNT_3__EVENTS__SHIFT                                                              0x10
#define SPI_CSQ_WF_ACTIVE_COUNT_3__COUNT_MASK                                                                 0x000007FFL
#define SPI_CSQ_WF_ACTIVE_COUNT_3__EVENTS_MASK                                                                0x07FF0000L
//SPI_LB_DATA_WAVES
#define SPI_LB_DATA_WAVES__COUNT0__SHIFT                                                                      0x0
#define SPI_LB_DATA_WAVES__COUNT1__SHIFT                                                                      0x10
#define SPI_LB_DATA_WAVES__COUNT0_MASK                                                                        0x0000FFFFL
#define SPI_LB_DATA_WAVES__COUNT1_MASK                                                                        0xFFFF0000L
//SPI_LB_DATA_PERWGP_WAVE_HSGS
#define SPI_LB_DATA_PERWGP_WAVE_HSGS__WGP_USED_HS__SHIFT                                                      0x0
#define SPI_LB_DATA_PERWGP_WAVE_HSGS__WGP_USED_GS__SHIFT                                                      0x10
#define SPI_LB_DATA_PERWGP_WAVE_HSGS__WGP_USED_HS_MASK                                                        0x0000FFFFL
#define SPI_LB_DATA_PERWGP_WAVE_HSGS__WGP_USED_GS_MASK                                                        0xFFFF0000L
//SPI_LB_DATA_PERWGP_WAVE_VSPS
#define SPI_LB_DATA_PERWGP_WAVE_VSPS__WGP_USED_VS__SHIFT                                                      0x0
#define SPI_LB_DATA_PERWGP_WAVE_VSPS__WGP_USED_PS__SHIFT                                                      0x10
#define SPI_LB_DATA_PERWGP_WAVE_VSPS__WGP_USED_VS_MASK                                                        0x0000FFFFL
#define SPI_LB_DATA_PERWGP_WAVE_VSPS__WGP_USED_PS_MASK                                                        0xFFFF0000L
//SPI_LB_DATA_PERWGP_WAVE_CS
#define SPI_LB_DATA_PERWGP_WAVE_CS__ACTIVE__SHIFT                                                             0x0
#define SPI_LB_DATA_PERWGP_WAVE_CS__ACTIVE_MASK                                                               0xFFFFL
//SPI_P0_TRAP_SCREEN_PSBA_LO
#define SPI_P0_TRAP_SCREEN_PSBA_LO__MEM_BASE__SHIFT                                                           0x0
#define SPI_P0_TRAP_SCREEN_PSBA_LO__MEM_BASE_MASK                                                             0xFFFFFFFFL
//SPI_P0_TRAP_SCREEN_PSBA_HI
#define SPI_P0_TRAP_SCREEN_PSBA_HI__MEM_BASE__SHIFT                                                           0x0
#define SPI_P0_TRAP_SCREEN_PSBA_HI__MEM_BASE_MASK                                                             0xFFL
//SPI_P0_TRAP_SCREEN_PSMA_LO
#define SPI_P0_TRAP_SCREEN_PSMA_LO__MEM_BASE__SHIFT                                                           0x0
#define SPI_P0_TRAP_SCREEN_PSMA_LO__MEM_BASE_MASK                                                             0xFFFFFFFFL
//SPI_P0_TRAP_SCREEN_PSMA_HI
#define SPI_P0_TRAP_SCREEN_PSMA_HI__MEM_BASE__SHIFT                                                           0x0
#define SPI_P0_TRAP_SCREEN_PSMA_HI__MEM_BASE_MASK                                                             0xFFL
//SPI_P0_TRAP_SCREEN_GPR_MIN
#define SPI_P0_TRAP_SCREEN_GPR_MIN__VGPR_MIN__SHIFT                                                           0x0
#define SPI_P0_TRAP_SCREEN_GPR_MIN__SGPR_MIN__SHIFT                                                           0x6
#define SPI_P0_TRAP_SCREEN_GPR_MIN__VGPR_MIN_MASK                                                             0x003FL
#define SPI_P0_TRAP_SCREEN_GPR_MIN__SGPR_MIN_MASK                                                             0x03C0L
//SPI_P1_TRAP_SCREEN_PSBA_LO
#define SPI_P1_TRAP_SCREEN_PSBA_LO__MEM_BASE__SHIFT                                                           0x0
#define SPI_P1_TRAP_SCREEN_PSBA_LO__MEM_BASE_MASK                                                             0xFFFFFFFFL
//SPI_P1_TRAP_SCREEN_PSBA_HI
#define SPI_P1_TRAP_SCREEN_PSBA_HI__MEM_BASE__SHIFT                                                           0x0
#define SPI_P1_TRAP_SCREEN_PSBA_HI__MEM_BASE_MASK                                                             0xFFL
//SPI_P1_TRAP_SCREEN_PSMA_LO
#define SPI_P1_TRAP_SCREEN_PSMA_LO__MEM_BASE__SHIFT                                                           0x0
#define SPI_P1_TRAP_SCREEN_PSMA_LO__MEM_BASE_MASK                                                             0xFFFFFFFFL
//SPI_P1_TRAP_SCREEN_PSMA_HI
#define SPI_P1_TRAP_SCREEN_PSMA_HI__MEM_BASE__SHIFT                                                           0x0
#define SPI_P1_TRAP_SCREEN_PSMA_HI__MEM_BASE_MASK                                                             0xFFL
//SPI_P1_TRAP_SCREEN_GPR_MIN
#define SPI_P1_TRAP_SCREEN_GPR_MIN__VGPR_MIN__SHIFT                                                           0x0
#define SPI_P1_TRAP_SCREEN_GPR_MIN__SGPR_MIN__SHIFT                                                           0x6
#define SPI_P1_TRAP_SCREEN_GPR_MIN__VGPR_MIN_MASK                                                             0x003FL
#define SPI_P1_TRAP_SCREEN_GPR_MIN__SGPR_MIN_MASK                                                             0x03C0L


// addressBlock: gc_tpdec
//TD_STATUS
#define TD_STATUS__BUSY__SHIFT                                                                                0x1f
#define TD_STATUS__BUSY_MASK                                                                                  0x80000000L
//TD_DSM_CNTL
#define TD_DSM_CNTL__TD_SS_FIFO_LO_DSM_IRRITATOR_DATA__SHIFT                                                  0x0
#define TD_DSM_CNTL__TD_SS_FIFO_LO_ENABLE_SINGLE_WRITE__SHIFT                                                 0x2
#define TD_DSM_CNTL__TD_SS_FIFO_HI_DSM_IRRITATOR_DATA__SHIFT                                                  0x3
#define TD_DSM_CNTL__TD_SS_FIFO_HI_ENABLE_SINGLE_WRITE__SHIFT                                                 0x5
#define TD_DSM_CNTL__TD_CS_FIFO_DSM_IRRITATOR_DATA__SHIFT                                                     0x6
#define TD_DSM_CNTL__TD_CS_FIFO_ENABLE_SINGLE_WRITE__SHIFT                                                    0x8
#define TD_DSM_CNTL__TD_SS_FIFO_LO_DSM_IRRITATOR_DATA_MASK                                                    0x00000003L
#define TD_DSM_CNTL__TD_SS_FIFO_LO_ENABLE_SINGLE_WRITE_MASK                                                   0x00000004L
#define TD_DSM_CNTL__TD_SS_FIFO_HI_DSM_IRRITATOR_DATA_MASK                                                    0x00000018L
#define TD_DSM_CNTL__TD_SS_FIFO_HI_ENABLE_SINGLE_WRITE_MASK                                                   0x00000020L
#define TD_DSM_CNTL__TD_CS_FIFO_DSM_IRRITATOR_DATA_MASK                                                       0x000000C0L
#define TD_DSM_CNTL__TD_CS_FIFO_ENABLE_SINGLE_WRITE_MASK                                                      0x00000100L
//TD_DSM_CNTL2
#define TD_DSM_CNTL2__TD_SS_FIFO_LO_ENABLE_ERROR_INJECT__SHIFT                                                0x0
#define TD_DSM_CNTL2__TD_SS_FIFO_LO_SELECT_INJECT_DELAY__SHIFT                                                0x2
#define TD_DSM_CNTL2__TD_SS_FIFO_HI_ENABLE_ERROR_INJECT__SHIFT                                                0x3
#define TD_DSM_CNTL2__TD_SS_FIFO_HI_SELECT_INJECT_DELAY__SHIFT                                                0x5
#define TD_DSM_CNTL2__TD_CS_FIFO_ENABLE_ERROR_INJECT__SHIFT                                                   0x6
#define TD_DSM_CNTL2__TD_CS_FIFO_SELECT_INJECT_DELAY__SHIFT                                                   0x8
#define TD_DSM_CNTL2__TD_INJECT_DELAY__SHIFT                                                                  0x1a
#define TD_DSM_CNTL2__TD_SS_FIFO_LO_ENABLE_ERROR_INJECT_MASK                                                  0x00000003L
#define TD_DSM_CNTL2__TD_SS_FIFO_LO_SELECT_INJECT_DELAY_MASK                                                  0x00000004L
#define TD_DSM_CNTL2__TD_SS_FIFO_HI_ENABLE_ERROR_INJECT_MASK                                                  0x00000018L
#define TD_DSM_CNTL2__TD_SS_FIFO_HI_SELECT_INJECT_DELAY_MASK                                                  0x00000020L
#define TD_DSM_CNTL2__TD_CS_FIFO_ENABLE_ERROR_INJECT_MASK                                                     0x000000C0L
#define TD_DSM_CNTL2__TD_CS_FIFO_SELECT_INJECT_DELAY_MASK                                                     0x00000100L
#define TD_DSM_CNTL2__TD_INJECT_DELAY_MASK                                                                    0xFC000000L
//TD_SCRATCH
#define TD_SCRATCH__SCRATCH__SHIFT                                                                            0x0
#define TD_SCRATCH__SCRATCH_MASK                                                                              0xFFFFFFFFL
//TA_CNTL
#define TA_CNTL__ALIGNER_CREDIT__SHIFT                                                                        0x10
#define TA_CNTL__TD_FIFO_CREDIT__SHIFT                                                                        0x16
#define TA_CNTL__ALIGNER_CREDIT_MASK                                                                          0x001F0000L
#define TA_CNTL__TD_FIFO_CREDIT_MASK                                                                          0xFFC00000L
//TA_RESERVED_010C
#define TA_RESERVED_010C__Unused__SHIFT                                                                       0x0
#define TA_RESERVED_010C__Unused_MASK                                                                         0xFFFFFFFFL
//TA_STATUS
#define TA_STATUS__FG_PFIFO_EMPTYB__SHIFT                                                                     0xc
#define TA_STATUS__FG_LFIFO_EMPTYB__SHIFT                                                                     0xd
#define TA_STATUS__FG_SFIFO_EMPTYB__SHIFT                                                                     0xe
#define TA_STATUS__FL_PFIFO_EMPTYB__SHIFT                                                                     0x10
#define TA_STATUS__FL_LFIFO_EMPTYB__SHIFT                                                                     0x11
#define TA_STATUS__FL_SFIFO_EMPTYB__SHIFT                                                                     0x12
#define TA_STATUS__FA_PFIFO_EMPTYB__SHIFT                                                                     0x14
#define TA_STATUS__FA_LFIFO_EMPTYB__SHIFT                                                                     0x15
#define TA_STATUS__FA_SFIFO_EMPTYB__SHIFT                                                                     0x16
#define TA_STATUS__IN_BUSY__SHIFT                                                                             0x18
#define TA_STATUS__FG_BUSY__SHIFT                                                                             0x19
#define TA_STATUS__LA_BUSY__SHIFT                                                                             0x1a
#define TA_STATUS__FL_BUSY__SHIFT                                                                             0x1b
#define TA_STATUS__TA_BUSY__SHIFT                                                                             0x1c
#define TA_STATUS__FA_BUSY__SHIFT                                                                             0x1d
#define TA_STATUS__AL_BUSY__SHIFT                                                                             0x1e
#define TA_STATUS__BUSY__SHIFT                                                                                0x1f
#define TA_STATUS__FG_PFIFO_EMPTYB_MASK                                                                       0x00001000L
#define TA_STATUS__FG_LFIFO_EMPTYB_MASK                                                                       0x00002000L
#define TA_STATUS__FG_SFIFO_EMPTYB_MASK                                                                       0x00004000L
#define TA_STATUS__FL_PFIFO_EMPTYB_MASK                                                                       0x00010000L
#define TA_STATUS__FL_LFIFO_EMPTYB_MASK                                                                       0x00020000L
#define TA_STATUS__FL_SFIFO_EMPTYB_MASK                                                                       0x00040000L
#define TA_STATUS__FA_PFIFO_EMPTYB_MASK                                                                       0x00100000L
#define TA_STATUS__FA_LFIFO_EMPTYB_MASK                                                                       0x00200000L
#define TA_STATUS__FA_SFIFO_EMPTYB_MASK                                                                       0x00400000L
#define TA_STATUS__IN_BUSY_MASK                                                                               0x01000000L
#define TA_STATUS__FG_BUSY_MASK                                                                               0x02000000L
#define TA_STATUS__LA_BUSY_MASK                                                                               0x04000000L
#define TA_STATUS__FL_BUSY_MASK                                                                               0x08000000L
#define TA_STATUS__TA_BUSY_MASK                                                                               0x10000000L
#define TA_STATUS__FA_BUSY_MASK                                                                               0x20000000L
#define TA_STATUS__AL_BUSY_MASK                                                                               0x40000000L
#define TA_STATUS__BUSY_MASK                                                                                  0x80000000L
//TA_SCRATCH
#define TA_SCRATCH__SCRATCH__SHIFT                                                                            0x0
#define TA_SCRATCH__SCRATCH_MASK                                                                              0xFFFFFFFFL


// addressBlock: gc_gdsdec
//GDS_CONFIG
#define GDS_CONFIG__SH0_GPR_PHASE_SEL__SHIFT                                                                  0x1
#define GDS_CONFIG__SH1_GPR_PHASE_SEL__SHIFT                                                                  0x3
#define GDS_CONFIG__SH2_GPR_PHASE_SEL__SHIFT                                                                  0x5
#define GDS_CONFIG__SH3_GPR_PHASE_SEL__SHIFT                                                                  0x7
#define GDS_CONFIG__UNUSED__SHIFT                                                                             0x9
#define GDS_CONFIG__SH0_GPR_PHASE_SEL_MASK                                                                    0x00000006L
#define GDS_CONFIG__SH1_GPR_PHASE_SEL_MASK                                                                    0x00000018L
#define GDS_CONFIG__SH2_GPR_PHASE_SEL_MASK                                                                    0x00000060L
#define GDS_CONFIG__SH3_GPR_PHASE_SEL_MASK                                                                    0x00000180L
#define GDS_CONFIG__UNUSED_MASK                                                                               0xFFFFFE00L
//GDS_CNTL_STATUS
#define GDS_CNTL_STATUS__GDS_BUSY__SHIFT                                                                      0x0
#define GDS_CNTL_STATUS__GRBM_WBUF_BUSY__SHIFT                                                                0x1
#define GDS_CNTL_STATUS__ORD_APP_BUSY__SHIFT                                                                  0x2
#define GDS_CNTL_STATUS__DS_BANK_CONFLICT__SHIFT                                                              0x3
#define GDS_CNTL_STATUS__DS_ADDR_CONFLICT__SHIFT                                                              0x4
#define GDS_CNTL_STATUS__DS_WR_CLAMP__SHIFT                                                                   0x5
#define GDS_CNTL_STATUS__DS_RD_CLAMP__SHIFT                                                                   0x6
#define GDS_CNTL_STATUS__GRBM_RBUF_BUSY__SHIFT                                                                0x7
#define GDS_CNTL_STATUS__DS_BUSY__SHIFT                                                                       0x8
#define GDS_CNTL_STATUS__GWS_BUSY__SHIFT                                                                      0x9
#define GDS_CNTL_STATUS__ORD_FIFO_BUSY__SHIFT                                                                 0xa
#define GDS_CNTL_STATUS__CREDIT_BUSY0__SHIFT                                                                  0xb
#define GDS_CNTL_STATUS__CREDIT_BUSY1__SHIFT                                                                  0xc
#define GDS_CNTL_STATUS__CREDIT_BUSY2__SHIFT                                                                  0xd
#define GDS_CNTL_STATUS__CREDIT_BUSY3__SHIFT                                                                  0xe
#define GDS_CNTL_STATUS__UNUSED__SHIFT                                                                        0xf
#define GDS_CNTL_STATUS__GDS_BUSY_MASK                                                                        0x00000001L
#define GDS_CNTL_STATUS__GRBM_WBUF_BUSY_MASK                                                                  0x00000002L
#define GDS_CNTL_STATUS__ORD_APP_BUSY_MASK                                                                    0x00000004L
#define GDS_CNTL_STATUS__DS_BANK_CONFLICT_MASK                                                                0x00000008L
#define GDS_CNTL_STATUS__DS_ADDR_CONFLICT_MASK                                                                0x00000010L
#define GDS_CNTL_STATUS__DS_WR_CLAMP_MASK                                                                     0x00000020L
#define GDS_CNTL_STATUS__DS_RD_CLAMP_MASK                                                                     0x00000040L
#define GDS_CNTL_STATUS__GRBM_RBUF_BUSY_MASK                                                                  0x00000080L
#define GDS_CNTL_STATUS__DS_BUSY_MASK                                                                         0x00000100L
#define GDS_CNTL_STATUS__GWS_BUSY_MASK                                                                        0x00000200L
#define GDS_CNTL_STATUS__ORD_FIFO_BUSY_MASK                                                                   0x00000400L
#define GDS_CNTL_STATUS__CREDIT_BUSY0_MASK                                                                    0x00000800L
#define GDS_CNTL_STATUS__CREDIT_BUSY1_MASK                                                                    0x00001000L
#define GDS_CNTL_STATUS__CREDIT_BUSY2_MASK                                                                    0x00002000L
#define GDS_CNTL_STATUS__CREDIT_BUSY3_MASK                                                                    0x00004000L
#define GDS_CNTL_STATUS__UNUSED_MASK                                                                          0xFFFF8000L
//GDS_ENHANCE
#define GDS_ENHANCE__MISC__SHIFT                                                                              0x0
#define GDS_ENHANCE__AUTO_INC_INDEX__SHIFT                                                                    0x10
#define GDS_ENHANCE__CGPG_RESTORE__SHIFT                                                                      0x11
#define GDS_ENHANCE__UNUSED__SHIFT                                                                            0x12
#define GDS_ENHANCE__MISC_MASK                                                                                0x0000FFFFL
#define GDS_ENHANCE__AUTO_INC_INDEX_MASK                                                                      0x00010000L
#define GDS_ENHANCE__CGPG_RESTORE_MASK                                                                        0x00020000L
#define GDS_ENHANCE__UNUSED_MASK                                                                              0xFFFC0000L
//GDS_PROTECTION_FAULT
#define GDS_PROTECTION_FAULT__WRITE_DIS__SHIFT                                                                0x0
#define GDS_PROTECTION_FAULT__FAULT_DETECTED__SHIFT                                                           0x1
#define GDS_PROTECTION_FAULT__GRBM__SHIFT                                                                     0x2
#define GDS_PROTECTION_FAULT__SH_ID__SHIFT                                                                    0x3
#define GDS_PROTECTION_FAULT__CU_ID__SHIFT                                                                    0x6
#define GDS_PROTECTION_FAULT__SIMD_ID__SHIFT                                                                  0xa
#define GDS_PROTECTION_FAULT__WAVE_ID__SHIFT                                                                  0xc
#define GDS_PROTECTION_FAULT__ADDRESS__SHIFT                                                                  0x10
#define GDS_PROTECTION_FAULT__WRITE_DIS_MASK                                                                  0x00000001L
#define GDS_PROTECTION_FAULT__FAULT_DETECTED_MASK                                                             0x00000002L
#define GDS_PROTECTION_FAULT__GRBM_MASK                                                                       0x00000004L
#define GDS_PROTECTION_FAULT__SH_ID_MASK                                                                      0x00000038L
#define GDS_PROTECTION_FAULT__CU_ID_MASK                                                                      0x000003C0L
#define GDS_PROTECTION_FAULT__SIMD_ID_MASK                                                                    0x00000C00L
#define GDS_PROTECTION_FAULT__WAVE_ID_MASK                                                                    0x0000F000L
#define GDS_PROTECTION_FAULT__ADDRESS_MASK                                                                    0xFFFF0000L
//GDS_VM_PROTECTION_FAULT
#define GDS_VM_PROTECTION_FAULT__WRITE_DIS__SHIFT                                                             0x0
#define GDS_VM_PROTECTION_FAULT__FAULT_DETECTED__SHIFT                                                        0x1
#define GDS_VM_PROTECTION_FAULT__GWS__SHIFT                                                                   0x2
#define GDS_VM_PROTECTION_FAULT__OA__SHIFT                                                                    0x3
#define GDS_VM_PROTECTION_FAULT__GRBM__SHIFT                                                                  0x4
#define GDS_VM_PROTECTION_FAULT__TMZ__SHIFT                                                                   0x5
#define GDS_VM_PROTECTION_FAULT__UNUSED1__SHIFT                                                               0x6
#define GDS_VM_PROTECTION_FAULT__VMID__SHIFT                                                                  0x8
#define GDS_VM_PROTECTION_FAULT__UNUSED2__SHIFT                                                               0xc
#define GDS_VM_PROTECTION_FAULT__ADDRESS__SHIFT                                                               0x10
#define GDS_VM_PROTECTION_FAULT__WRITE_DIS_MASK                                                               0x00000001L
#define GDS_VM_PROTECTION_FAULT__FAULT_DETECTED_MASK                                                          0x00000002L
#define GDS_VM_PROTECTION_FAULT__GWS_MASK                                                                     0x00000004L
#define GDS_VM_PROTECTION_FAULT__OA_MASK                                                                      0x00000008L
#define GDS_VM_PROTECTION_FAULT__GRBM_MASK                                                                    0x00000010L
#define GDS_VM_PROTECTION_FAULT__TMZ_MASK                                                                     0x00000020L
#define GDS_VM_PROTECTION_FAULT__UNUSED1_MASK                                                                 0x000000C0L
#define GDS_VM_PROTECTION_FAULT__VMID_MASK                                                                    0x00000F00L
#define GDS_VM_PROTECTION_FAULT__UNUSED2_MASK                                                                 0x0000F000L
#define GDS_VM_PROTECTION_FAULT__ADDRESS_MASK                                                                 0xFFFF0000L
//GDS_EDC_CNT
#define GDS_EDC_CNT__GDS_MEM_DED__SHIFT                                                                       0x0
#define GDS_EDC_CNT__GDS_INPUT_QUEUE_SED__SHIFT                                                               0x2
#define GDS_EDC_CNT__GDS_MEM_SEC__SHIFT                                                                       0x4
#define GDS_EDC_CNT__UNUSED__SHIFT                                                                            0x6
#define GDS_EDC_CNT__GDS_MEM_DED_MASK                                                                         0x00000003L
#define GDS_EDC_CNT__GDS_INPUT_QUEUE_SED_MASK                                                                 0x0000000CL
#define GDS_EDC_CNT__GDS_MEM_SEC_MASK                                                                         0x00000030L
#define GDS_EDC_CNT__UNUSED_MASK                                                                              0xFFFFFFC0L
//GDS_EDC_GRBM_CNT
#define GDS_EDC_GRBM_CNT__DED__SHIFT                                                                          0x0
#define GDS_EDC_GRBM_CNT__SEC__SHIFT                                                                          0x2
#define GDS_EDC_GRBM_CNT__UNUSED__SHIFT                                                                       0x4
#define GDS_EDC_GRBM_CNT__DED_MASK                                                                            0x00000003L
#define GDS_EDC_GRBM_CNT__SEC_MASK                                                                            0x0000000CL
#define GDS_EDC_GRBM_CNT__UNUSED_MASK                                                                         0xFFFFFFF0L
//GDS_EDC_OA_DED
#define GDS_EDC_OA_DED__ME0_GFXHP3D_PIX_DED__SHIFT                                                            0x0
#define GDS_EDC_OA_DED__ME0_GFXHP3D_VTX_DED__SHIFT                                                            0x1
#define GDS_EDC_OA_DED__ME0_CS_DED__SHIFT                                                                     0x2
#define GDS_EDC_OA_DED__ME0_GFXHP3D_GS_DED__SHIFT                                                             0x3
#define GDS_EDC_OA_DED__ME1_PIPE0_DED__SHIFT                                                                  0x4
#define GDS_EDC_OA_DED__ME1_PIPE1_DED__SHIFT                                                                  0x5
#define GDS_EDC_OA_DED__ME1_PIPE2_DED__SHIFT                                                                  0x6
#define GDS_EDC_OA_DED__ME1_PIPE3_DED__SHIFT                                                                  0x7
#define GDS_EDC_OA_DED__ME2_PIPE0_DED__SHIFT                                                                  0x8
#define GDS_EDC_OA_DED__ME2_PIPE1_DED__SHIFT                                                                  0x9
#define GDS_EDC_OA_DED__ME2_PIPE2_DED__SHIFT                                                                  0xa
#define GDS_EDC_OA_DED__ME2_PIPE3_DED__SHIFT                                                                  0xb
#define GDS_EDC_OA_DED__ME0_PIPE1_CS_DED__SHIFT                                                               0xc
#define GDS_EDC_OA_DED__UNUSED1__SHIFT                                                                        0xd
#define GDS_EDC_OA_DED__ME0_GFXHP3D_PIX_DED_MASK                                                              0x00000001L
#define GDS_EDC_OA_DED__ME0_GFXHP3D_VTX_DED_MASK                                                              0x00000002L
#define GDS_EDC_OA_DED__ME0_CS_DED_MASK                                                                       0x00000004L
#define GDS_EDC_OA_DED__ME0_GFXHP3D_GS_DED_MASK                                                               0x00000008L
#define GDS_EDC_OA_DED__ME1_PIPE0_DED_MASK                                                                    0x00000010L
#define GDS_EDC_OA_DED__ME1_PIPE1_DED_MASK                                                                    0x00000020L
#define GDS_EDC_OA_DED__ME1_PIPE2_DED_MASK                                                                    0x00000040L
#define GDS_EDC_OA_DED__ME1_PIPE3_DED_MASK                                                                    0x00000080L
#define GDS_EDC_OA_DED__ME2_PIPE0_DED_MASK                                                                    0x00000100L
#define GDS_EDC_OA_DED__ME2_PIPE1_DED_MASK                                                                    0x00000200L
#define GDS_EDC_OA_DED__ME2_PIPE2_DED_MASK                                                                    0x00000400L
#define GDS_EDC_OA_DED__ME2_PIPE3_DED_MASK                                                                    0x00000800L
#define GDS_EDC_OA_DED__ME0_PIPE1_CS_DED_MASK                                                                 0x00001000L
#define GDS_EDC_OA_DED__UNUSED1_MASK                                                                          0xFFFFE000L
//GDS_DSM_CNTL
#define GDS_DSM_CNTL__SEL_DSM_GDS_MEM_IRRITATOR_DATA_0__SHIFT                                                 0x0
#define GDS_DSM_CNTL__SEL_DSM_GDS_MEM_IRRITATOR_DATA_1__SHIFT                                                 0x1
#define GDS_DSM_CNTL__GDS_MEM_ENABLE_SINGLE_WRITE__SHIFT                                                      0x2
#define GDS_DSM_CNTL__SEL_DSM_GDS_INPUT_QUEUE_IRRITATOR_DATA_0__SHIFT                                         0x3
#define GDS_DSM_CNTL__SEL_DSM_GDS_INPUT_QUEUE_IRRITATOR_DATA_1__SHIFT                                         0x4
#define GDS_DSM_CNTL__GDS_INPUT_QUEUE_ENABLE_SINGLE_WRITE__SHIFT                                              0x5
#define GDS_DSM_CNTL__SEL_DSM_GDS_PHY_CMD_RAM_IRRITATOR_DATA_0__SHIFT                                         0x6
#define GDS_DSM_CNTL__SEL_DSM_GDS_PHY_CMD_RAM_IRRITATOR_DATA_1__SHIFT                                         0x7
#define GDS_DSM_CNTL__GDS_PHY_CMD_RAM_ENABLE_SINGLE_WRITE__SHIFT                                              0x8
#define GDS_DSM_CNTL__SEL_DSM_GDS_PHY_DATA_RAM_IRRITATOR_DATA_0__SHIFT                                        0x9
#define GDS_DSM_CNTL__SEL_DSM_GDS_PHY_DATA_RAM_IRRITATOR_DATA_1__SHIFT                                        0xa
#define GDS_DSM_CNTL__GDS_PHY_DATA_RAM_ENABLE_SINGLE_WRITE__SHIFT                                             0xb
#define GDS_DSM_CNTL__SEL_DSM_GDS_PIPE_MEM_IRRITATOR_DATA_0__SHIFT                                            0xc
#define GDS_DSM_CNTL__SEL_DSM_GDS_PIPE_MEM_IRRITATOR_DATA_1__SHIFT                                            0xd
#define GDS_DSM_CNTL__GDS_PIPE_MEM_ENABLE_SINGLE_WRITE__SHIFT                                                 0xe
#define GDS_DSM_CNTL__UNUSED__SHIFT                                                                           0xf
#define GDS_DSM_CNTL__SEL_DSM_GDS_MEM_IRRITATOR_DATA_0_MASK                                                   0x00000001L
#define GDS_DSM_CNTL__SEL_DSM_GDS_MEM_IRRITATOR_DATA_1_MASK                                                   0x00000002L
#define GDS_DSM_CNTL__GDS_MEM_ENABLE_SINGLE_WRITE_MASK                                                        0x00000004L
#define GDS_DSM_CNTL__SEL_DSM_GDS_INPUT_QUEUE_IRRITATOR_DATA_0_MASK                                           0x00000008L
#define GDS_DSM_CNTL__SEL_DSM_GDS_INPUT_QUEUE_IRRITATOR_DATA_1_MASK                                           0x00000010L
#define GDS_DSM_CNTL__GDS_INPUT_QUEUE_ENABLE_SINGLE_WRITE_MASK                                                0x00000020L
#define GDS_DSM_CNTL__SEL_DSM_GDS_PHY_CMD_RAM_IRRITATOR_DATA_0_MASK                                           0x00000040L
#define GDS_DSM_CNTL__SEL_DSM_GDS_PHY_CMD_RAM_IRRITATOR_DATA_1_MASK                                           0x00000080L
#define GDS_DSM_CNTL__GDS_PHY_CMD_RAM_ENABLE_SINGLE_WRITE_MASK                                                0x00000100L
#define GDS_DSM_CNTL__SEL_DSM_GDS_PHY_DATA_RAM_IRRITATOR_DATA_0_MASK                                          0x00000200L
#define GDS_DSM_CNTL__SEL_DSM_GDS_PHY_DATA_RAM_IRRITATOR_DATA_1_MASK                                          0x00000400L
#define GDS_DSM_CNTL__GDS_PHY_DATA_RAM_ENABLE_SINGLE_WRITE_MASK                                               0x00000800L
#define GDS_DSM_CNTL__SEL_DSM_GDS_PIPE_MEM_IRRITATOR_DATA_0_MASK                                              0x00001000L
#define GDS_DSM_CNTL__SEL_DSM_GDS_PIPE_MEM_IRRITATOR_DATA_1_MASK                                              0x00002000L
#define GDS_DSM_CNTL__GDS_PIPE_MEM_ENABLE_SINGLE_WRITE_MASK                                                   0x00004000L
#define GDS_DSM_CNTL__UNUSED_MASK                                                                             0xFFFF8000L
//GDS_EDC_OA_PHY_CNT
#define GDS_EDC_OA_PHY_CNT__ME0_CS_PIPE_MEM_SEC__SHIFT                                                        0x0
#define GDS_EDC_OA_PHY_CNT__ME0_CS_PIPE_MEM_DED__SHIFT                                                        0x2
#define GDS_EDC_OA_PHY_CNT__PHY_CMD_RAM_MEM_SEC__SHIFT                                                        0x4
#define GDS_EDC_OA_PHY_CNT__PHY_CMD_RAM_MEM_DED__SHIFT                                                        0x6
#define GDS_EDC_OA_PHY_CNT__PHY_DATA_RAM_MEM_SED__SHIFT                                                       0x8
#define GDS_EDC_OA_PHY_CNT__UNUSED1__SHIFT                                                                    0xa
#define GDS_EDC_OA_PHY_CNT__ME0_CS_PIPE_MEM_SEC_MASK                                                          0x00000003L
#define GDS_EDC_OA_PHY_CNT__ME0_CS_PIPE_MEM_DED_MASK                                                          0x0000000CL
#define GDS_EDC_OA_PHY_CNT__PHY_CMD_RAM_MEM_SEC_MASK                                                          0x00000030L
#define GDS_EDC_OA_PHY_CNT__PHY_CMD_RAM_MEM_DED_MASK                                                          0x000000C0L
#define GDS_EDC_OA_PHY_CNT__PHY_DATA_RAM_MEM_SED_MASK                                                         0x00000300L
#define GDS_EDC_OA_PHY_CNT__UNUSED1_MASK                                                                      0xFFFFFC00L
//GDS_EDC_OA_PIPE_CNT
#define GDS_EDC_OA_PIPE_CNT__ME1_PIPE0_PIPE_MEM_SEC__SHIFT                                                    0x0
#define GDS_EDC_OA_PIPE_CNT__ME1_PIPE0_PIPE_MEM_DED__SHIFT                                                    0x2
#define GDS_EDC_OA_PIPE_CNT__ME1_PIPE1_PIPE_MEM_SEC__SHIFT                                                    0x4
#define GDS_EDC_OA_PIPE_CNT__ME1_PIPE1_PIPE_MEM_DED__SHIFT                                                    0x6
#define GDS_EDC_OA_PIPE_CNT__ME1_PIPE2_PIPE_MEM_SEC__SHIFT                                                    0x8
#define GDS_EDC_OA_PIPE_CNT__ME1_PIPE2_PIPE_MEM_DED__SHIFT                                                    0xa
#define GDS_EDC_OA_PIPE_CNT__ME1_PIPE3_PIPE_MEM_SEC__SHIFT                                                    0xc
#define GDS_EDC_OA_PIPE_CNT__ME1_PIPE3_PIPE_MEM_DED__SHIFT                                                    0xe
#define GDS_EDC_OA_PIPE_CNT__UNUSED__SHIFT                                                                    0x10
#define GDS_EDC_OA_PIPE_CNT__ME1_PIPE0_PIPE_MEM_SEC_MASK                                                      0x00000003L
#define GDS_EDC_OA_PIPE_CNT__ME1_PIPE0_PIPE_MEM_DED_MASK                                                      0x0000000CL
#define GDS_EDC_OA_PIPE_CNT__ME1_PIPE1_PIPE_MEM_SEC_MASK                                                      0x00000030L
#define GDS_EDC_OA_PIPE_CNT__ME1_PIPE1_PIPE_MEM_DED_MASK                                                      0x000000C0L
#define GDS_EDC_OA_PIPE_CNT__ME1_PIPE2_PIPE_MEM_SEC_MASK                                                      0x00000300L
#define GDS_EDC_OA_PIPE_CNT__ME1_PIPE2_PIPE_MEM_DED_MASK                                                      0x00000C00L
#define GDS_EDC_OA_PIPE_CNT__ME1_PIPE3_PIPE_MEM_SEC_MASK                                                      0x00003000L
#define GDS_EDC_OA_PIPE_CNT__ME1_PIPE3_PIPE_MEM_DED_MASK                                                      0x0000C000L
#define GDS_EDC_OA_PIPE_CNT__UNUSED_MASK                                                                      0xFFFF0000L
//GDS_DSM_CNTL2
#define GDS_DSM_CNTL2__GDS_MEM_ENABLE_ERROR_INJECT__SHIFT                                                     0x0
#define GDS_DSM_CNTL2__GDS_MEM_SELECT_INJECT_DELAY__SHIFT                                                     0x2
#define GDS_DSM_CNTL2__GDS_INPUT_QUEUE_ENABLE_ERROR_INJECT__SHIFT                                             0x3
#define GDS_DSM_CNTL2__GDS_INPUT_QUEUE_SELECT_INJECT_DELAY__SHIFT                                             0x5
#define GDS_DSM_CNTL2__GDS_PHY_CMD_RAM_ENABLE_ERROR_INJECT__SHIFT                                             0x6
#define GDS_DSM_CNTL2__GDS_PHY_CMD_RAM_SELECT_INJECT_DELAY__SHIFT                                             0x8
#define GDS_DSM_CNTL2__GDS_PHY_DATA_RAM_ENABLE_ERROR_INJECT__SHIFT                                            0x9
#define GDS_DSM_CNTL2__GDS_PHY_DATA_RAM_SELECT_INJECT_DELAY__SHIFT                                            0xb
#define GDS_DSM_CNTL2__GDS_PIPE_MEM_ENABLE_ERROR_INJECT__SHIFT                                                0xc
#define GDS_DSM_CNTL2__GDS_PIPE_MEM_SELECT_INJECT_DELAY__SHIFT                                                0xe
#define GDS_DSM_CNTL2__UNUSED__SHIFT                                                                          0xf
#define GDS_DSM_CNTL2__GDS_INJECT_DELAY__SHIFT                                                                0x1a
#define GDS_DSM_CNTL2__GDS_MEM_ENABLE_ERROR_INJECT_MASK                                                       0x00000003L
#define GDS_DSM_CNTL2__GDS_MEM_SELECT_INJECT_DELAY_MASK                                                       0x00000004L
#define GDS_DSM_CNTL2__GDS_INPUT_QUEUE_ENABLE_ERROR_INJECT_MASK                                               0x00000018L
#define GDS_DSM_CNTL2__GDS_INPUT_QUEUE_SELECT_INJECT_DELAY_MASK                                               0x00000020L
#define GDS_DSM_CNTL2__GDS_PHY_CMD_RAM_ENABLE_ERROR_INJECT_MASK                                               0x000000C0L
#define GDS_DSM_CNTL2__GDS_PHY_CMD_RAM_SELECT_INJECT_DELAY_MASK                                               0x00000100L
#define GDS_DSM_CNTL2__GDS_PHY_DATA_RAM_ENABLE_ERROR_INJECT_MASK                                              0x00000600L
#define GDS_DSM_CNTL2__GDS_PHY_DATA_RAM_SELECT_INJECT_DELAY_MASK                                              0x00000800L
#define GDS_DSM_CNTL2__GDS_PIPE_MEM_ENABLE_ERROR_INJECT_MASK                                                  0x00003000L
#define GDS_DSM_CNTL2__GDS_PIPE_MEM_SELECT_INJECT_DELAY_MASK                                                  0x00004000L
#define GDS_DSM_CNTL2__UNUSED_MASK                                                                            0x03FF8000L
#define GDS_DSM_CNTL2__GDS_INJECT_DELAY_MASK                                                                  0xFC000000L
//GDS_WD_GDS_CSB
#define GDS_WD_GDS_CSB__COUNTER__SHIFT                                                                        0x0
#define GDS_WD_GDS_CSB__UNUSED__SHIFT                                                                         0xd
#define GDS_WD_GDS_CSB__COUNTER_MASK                                                                          0x00001FFFL
#define GDS_WD_GDS_CSB__UNUSED_MASK                                                                           0xFFFFE000L


// addressBlock: gc_rbdec
//DB_DEBUG
#define DB_DEBUG__DEBUG_STENCIL_COMPRESS_DISABLE__SHIFT                                                       0x0
#define DB_DEBUG__DEBUG_DEPTH_COMPRESS_DISABLE__SHIFT                                                         0x1
#define DB_DEBUG__FETCH_FULL_Z_TILE__SHIFT                                                                    0x2
#define DB_DEBUG__FETCH_FULL_STENCIL_TILE__SHIFT                                                              0x3
#define DB_DEBUG__FORCE_Z_MODE__SHIFT                                                                         0x4
#define DB_DEBUG__DEBUG_FORCE_DEPTH_READ__SHIFT                                                               0x6
#define DB_DEBUG__DEBUG_FORCE_STENCIL_READ__SHIFT                                                             0x7
#define DB_DEBUG__DEBUG_FORCE_HIZ_ENABLE__SHIFT                                                               0x8
#define DB_DEBUG__DEBUG_FORCE_HIS_ENABLE0__SHIFT                                                              0xa
#define DB_DEBUG__DEBUG_FORCE_HIS_ENABLE1__SHIFT                                                              0xc
#define DB_DEBUG__DEBUG_FAST_Z_DISABLE__SHIFT                                                                 0xe
#define DB_DEBUG__DEBUG_FAST_STENCIL_DISABLE__SHIFT                                                           0xf
#define DB_DEBUG__DEBUG_NOOP_CULL_DISABLE__SHIFT                                                              0x10
#define DB_DEBUG__DISABLE_SUMM_SQUADS__SHIFT                                                                  0x11
#define DB_DEBUG__DEPTH_CACHE_FORCE_MISS__SHIFT                                                               0x12
#define DB_DEBUG__DEBUG_FORCE_FULL_Z_RANGE__SHIFT                                                             0x13
#define DB_DEBUG__NEVER_FREE_Z_ONLY__SHIFT                                                                    0x15
#define DB_DEBUG__ZPASS_COUNTS_LOOK_AT_PIPE_STAT_EVENTS__SHIFT                                                0x16
#define DB_DEBUG__DISABLE_VPORT_ZPLANE_OPTIMIZATION__SHIFT                                                    0x17
#define DB_DEBUG__DECOMPRESS_AFTER_N_ZPLANES__SHIFT                                                           0x18
#define DB_DEBUG__ONE_FREE_IN_FLIGHT__SHIFT                                                                   0x1c
#define DB_DEBUG__FORCE_MISS_IF_NOT_INFLIGHT__SHIFT                                                           0x1d
#define DB_DEBUG__DISABLE_DEPTH_SURFACE_SYNC__SHIFT                                                           0x1e
#define DB_DEBUG__DISABLE_HTILE_SURFACE_SYNC__SHIFT                                                           0x1f
#define DB_DEBUG__DEBUG_STENCIL_COMPRESS_DISABLE_MASK                                                         0x00000001L
#define DB_DEBUG__DEBUG_DEPTH_COMPRESS_DISABLE_MASK                                                           0x00000002L
#define DB_DEBUG__FETCH_FULL_Z_TILE_MASK                                                                      0x00000004L
#define DB_DEBUG__FETCH_FULL_STENCIL_TILE_MASK                                                                0x00000008L
#define DB_DEBUG__FORCE_Z_MODE_MASK                                                                           0x00000030L
#define DB_DEBUG__DEBUG_FORCE_DEPTH_READ_MASK                                                                 0x00000040L
#define DB_DEBUG__DEBUG_FORCE_STENCIL_READ_MASK                                                               0x00000080L
#define DB_DEBUG__DEBUG_FORCE_HIZ_ENABLE_MASK                                                                 0x00000300L
#define DB_DEBUG__DEBUG_FORCE_HIS_ENABLE0_MASK                                                                0x00000C00L
#define DB_DEBUG__DEBUG_FORCE_HIS_ENABLE1_MASK                                                                0x00003000L
#define DB_DEBUG__DEBUG_FAST_Z_DISABLE_MASK                                                                   0x00004000L
#define DB_DEBUG__DEBUG_FAST_STENCIL_DISABLE_MASK                                                             0x00008000L
#define DB_DEBUG__DEBUG_NOOP_CULL_DISABLE_MASK                                                                0x00010000L
#define DB_DEBUG__DISABLE_SUMM_SQUADS_MASK                                                                    0x00020000L
#define DB_DEBUG__DEPTH_CACHE_FORCE_MISS_MASK                                                                 0x00040000L
#define DB_DEBUG__DEBUG_FORCE_FULL_Z_RANGE_MASK                                                               0x00180000L
#define DB_DEBUG__NEVER_FREE_Z_ONLY_MASK                                                                      0x00200000L
#define DB_DEBUG__ZPASS_COUNTS_LOOK_AT_PIPE_STAT_EVENTS_MASK                                                  0x00400000L
#define DB_DEBUG__DISABLE_VPORT_ZPLANE_OPTIMIZATION_MASK                                                      0x00800000L
#define DB_DEBUG__DECOMPRESS_AFTER_N_ZPLANES_MASK                                                             0x0F000000L
#define DB_DEBUG__ONE_FREE_IN_FLIGHT_MASK                                                                     0x10000000L
#define DB_DEBUG__FORCE_MISS_IF_NOT_INFLIGHT_MASK                                                             0x20000000L
#define DB_DEBUG__DISABLE_DEPTH_SURFACE_SYNC_MASK                                                             0x40000000L
#define DB_DEBUG__DISABLE_HTILE_SURFACE_SYNC_MASK                                                             0x80000000L
//DB_DEBUG2
#define DB_DEBUG2__ALLOW_COMPZ_BYTE_MASKING__SHIFT                                                            0x0
#define DB_DEBUG2__DISABLE_TC_ZRANGE_L0_CACHE__SHIFT                                                          0x1
#define DB_DEBUG2__DISABLE_TC_MASK_L0_CACHE__SHIFT                                                            0x2
#define DB_DEBUG2__DTR_ROUND_ROBIN_ARB__SHIFT                                                                 0x3
#define DB_DEBUG2__DTR_PREZ_STALLS_FOR_ETF_ROOM__SHIFT                                                        0x4
#define DB_DEBUG2__DISABLE_PREZL_FIFO_STALL__SHIFT                                                            0x5
#define DB_DEBUG2__DISABLE_PREZL_FIFO_STALL_REZ__SHIFT                                                        0x6
#define DB_DEBUG2__ENABLE_VIEWPORT_STALL_ON_ALL__SHIFT                                                        0x7
#define DB_DEBUG2__OPTIMIZE_HIZ_MATCHES_FB_DISABLE__SHIFT                                                     0x8
#define DB_DEBUG2__CLK_OFF_DELAY__SHIFT                                                                       0x9
#define DB_DEBUG2__FORCE_PERF_COUNTERS_ON__SHIFT                                                              0xe
#define DB_DEBUG2__FULL_TILE_CACHE_EVICT_ON_HALF_FULL__SHIFT                                                  0xf
#define DB_DEBUG2__DISABLE_HTILE_PAIRED_PIPES__SHIFT                                                          0x10
#define DB_DEBUG2__DISABLE_NULL_EOT_FORWARDING__SHIFT                                                         0x11
#define DB_DEBUG2__DISABLE_DTT_DATA_FORWARDING__SHIFT                                                         0x12
#define DB_DEBUG2__DISABLE_QUAD_COHERENCY_STALL__SHIFT                                                        0x13
#define DB_DEBUG2__FULL_TILE_WAVE_BREAK_MODE__SHIFT                                                           0x14
#define DB_DEBUG2__DUAL_PIPE_REZ_STALL_MANUAL_CONTROL__SHIFT                                                  0x16
#define DB_DEBUG2__DUAL_PIPE_REZ_STALL_SELECT_NEW__SHIFT                                                      0x17
#define DB_DEBUG2__FORCE_ITERATE_256__SHIFT                                                                   0x18
#define DB_DEBUG2__RESERVED1__SHIFT                                                                           0x1a
#define DB_DEBUG2__ENABLE_PREZ_OF_REZ_SUMM__SHIFT                                                             0x1c
#define DB_DEBUG2__DISABLE_PREZL_VIEWPORT_STALL__SHIFT                                                        0x1d
#define DB_DEBUG2__DISABLE_SINGLE_STENCIL_QUAD_SUMM__SHIFT                                                    0x1e
#define DB_DEBUG2__DISABLE_WRITE_STALL_ON_RDWR_CONFLICT__SHIFT                                                0x1f
#define DB_DEBUG2__ALLOW_COMPZ_BYTE_MASKING_MASK                                                              0x00000001L
#define DB_DEBUG2__DISABLE_TC_ZRANGE_L0_CACHE_MASK                                                            0x00000002L
#define DB_DEBUG2__DISABLE_TC_MASK_L0_CACHE_MASK                                                              0x00000004L
#define DB_DEBUG2__DTR_ROUND_ROBIN_ARB_MASK                                                                   0x00000008L
#define DB_DEBUG2__DTR_PREZ_STALLS_FOR_ETF_ROOM_MASK                                                          0x00000010L
#define DB_DEBUG2__DISABLE_PREZL_FIFO_STALL_MASK                                                              0x00000020L
#define DB_DEBUG2__DISABLE_PREZL_FIFO_STALL_REZ_MASK                                                          0x00000040L
#define DB_DEBUG2__ENABLE_VIEWPORT_STALL_ON_ALL_MASK                                                          0x00000080L
#define DB_DEBUG2__OPTIMIZE_HIZ_MATCHES_FB_DISABLE_MASK                                                       0x00000100L
#define DB_DEBUG2__CLK_OFF_DELAY_MASK                                                                         0x00003E00L
#define DB_DEBUG2__FORCE_PERF_COUNTERS_ON_MASK                                                                0x00004000L
#define DB_DEBUG2__FULL_TILE_CACHE_EVICT_ON_HALF_FULL_MASK                                                    0x00008000L
#define DB_DEBUG2__DISABLE_HTILE_PAIRED_PIPES_MASK                                                            0x00010000L
#define DB_DEBUG2__DISABLE_NULL_EOT_FORWARDING_MASK                                                           0x00020000L
#define DB_DEBUG2__DISABLE_DTT_DATA_FORWARDING_MASK                                                           0x00040000L
#define DB_DEBUG2__DISABLE_QUAD_COHERENCY_STALL_MASK                                                          0x00080000L
#define DB_DEBUG2__FULL_TILE_WAVE_BREAK_MODE_MASK                                                             0x00300000L
#define DB_DEBUG2__DUAL_PIPE_REZ_STALL_MANUAL_CONTROL_MASK                                                    0x00400000L
#define DB_DEBUG2__DUAL_PIPE_REZ_STALL_SELECT_NEW_MASK                                                        0x00800000L
#define DB_DEBUG2__FORCE_ITERATE_256_MASK                                                                     0x03000000L
#define DB_DEBUG2__RESERVED1_MASK                                                                             0x04000000L
#define DB_DEBUG2__ENABLE_PREZ_OF_REZ_SUMM_MASK                                                               0x10000000L
#define DB_DEBUG2__DISABLE_PREZL_VIEWPORT_STALL_MASK                                                          0x20000000L
#define DB_DEBUG2__DISABLE_SINGLE_STENCIL_QUAD_SUMM_MASK                                                      0x40000000L
#define DB_DEBUG2__DISABLE_WRITE_STALL_ON_RDWR_CONFLICT_MASK                                                  0x80000000L
//DB_DEBUG3
#define DB_DEBUG3__DISABLE_CLEAR_ZRANGE_CORRECTION__SHIFT                                                     0x0
#define DB_DEBUG3__DISABLE_RELOAD_CONTEXT_DRAW_DATA__SHIFT                                                    0x1
#define DB_DEBUG3__FORCE_DB_IS_GOOD__SHIFT                                                                    0x2
#define DB_DEBUG3__DISABLE_TL_SSO_NULL_SUPPRESSION__SHIFT                                                     0x3
#define DB_DEBUG3__DISABLE_HIZ_ON_VPORT_CLAMP__SHIFT                                                          0x4
#define DB_DEBUG3__EQAA_INTERPOLATE_COMP_Z__SHIFT                                                             0x5
#define DB_DEBUG3__EQAA_INTERPOLATE_SRC_Z__SHIFT                                                              0x6
#define DB_DEBUG3__DISABLE_TCP_CAM_BYPASS__SHIFT                                                              0x7
#define DB_DEBUG3__DISABLE_ZCMP_DIRTY_SUPPRESSION__SHIFT                                                      0x8
#define DB_DEBUG3__DISABLE_REDUNDANT_PLANE_FLUSHES_OPT__SHIFT                                                 0x9
#define DB_DEBUG3__DISABLE_RECOMP_TO_1ZPLANE_WITHOUT_FASTOP__SHIFT                                            0xa
#define DB_DEBUG3__ENABLE_INCOHERENT_EQAA_READS__SHIFT                                                        0xb
#define DB_DEBUG3__DISABLE_OP_Z_DATA_FORWARDING__SHIFT                                                        0xc
#define DB_DEBUG3__DISABLE_OP_DF_BYPASS__SHIFT                                                                0xd
#define DB_DEBUG3__DISABLE_OP_DF_WRITE_COMBINE__SHIFT                                                         0xe
#define DB_DEBUG3__DISABLE_OP_DF_DIRECT_FEEDBACK__SHIFT                                                       0xf
#define DB_DEBUG3__DISABLE_SLOCS_PER_CTXT_MATCH__SHIFT                                                        0x10
#define DB_DEBUG3__SLOW_PREZ_TO_A2M_OMASK_RATE__SHIFT                                                         0x11
#define DB_DEBUG3__DISABLE_OP_S_DATA_FORWARDING__SHIFT                                                        0x12
#define DB_DEBUG3__DISABLE_TC_UPDATE_WRITE_COMBINE__SHIFT                                                     0x13
#define DB_DEBUG3__DISABLE_HZ_TC_WRITE_COMBINE__SHIFT                                                         0x14
#define DB_DEBUG3__ENABLE_RECOMP_ZDIRTY_SUPPRESSION_OPT__SHIFT                                                0x15
#define DB_DEBUG3__ENABLE_TC_MA_ROUND_ROBIN_ARB__SHIFT                                                        0x16
#define DB_DEBUG3__DISABLE_RAM_READ_SUPPRESION_ON_FWD__SHIFT                                                  0x17
#define DB_DEBUG3__DISABLE_EQAA_A2M_PERF_OPT__SHIFT                                                           0x18
#define DB_DEBUG3__DISABLE_DI_DT_STALL__SHIFT                                                                 0x19
#define DB_DEBUG3__ENABLE_DB_PROCESS_RESET__SHIFT                                                             0x1a
#define DB_DEBUG3__DISABLE_OVERRASTERIZATION_FIX__SHIFT                                                       0x1b
#define DB_DEBUG3__DONT_INSERT_CONTEXT_SUSPEND__SHIFT                                                         0x1c
#define DB_DEBUG3__DELETE_CONTEXT_SUSPEND__SHIFT                                                              0x1d
#define DB_DEBUG3__DISABLE_TS_WRITE_L0__SHIFT                                                                 0x1e
#define DB_DEBUG3__DISABLE_MULTIDTAG_FL_PANIC_REQUIREMENT__SHIFT                                              0x1f
#define DB_DEBUG3__DISABLE_CLEAR_ZRANGE_CORRECTION_MASK                                                       0x00000001L
#define DB_DEBUG3__DISABLE_RELOAD_CONTEXT_DRAW_DATA_MASK                                                      0x00000002L
#define DB_DEBUG3__FORCE_DB_IS_GOOD_MASK                                                                      0x00000004L
#define DB_DEBUG3__DISABLE_TL_SSO_NULL_SUPPRESSION_MASK                                                       0x00000008L
#define DB_DEBUG3__DISABLE_HIZ_ON_VPORT_CLAMP_MASK                                                            0x00000010L
#define DB_DEBUG3__EQAA_INTERPOLATE_COMP_Z_MASK                                                               0x00000020L
#define DB_DEBUG3__EQAA_INTERPOLATE_SRC_Z_MASK                                                                0x00000040L
#define DB_DEBUG3__DISABLE_TCP_CAM_BYPASS_MASK                                                                0x00000080L
#define DB_DEBUG3__DISABLE_ZCMP_DIRTY_SUPPRESSION_MASK                                                        0x00000100L
#define DB_DEBUG3__DISABLE_REDUNDANT_PLANE_FLUSHES_OPT_MASK                                                   0x00000200L
#define DB_DEBUG3__DISABLE_RECOMP_TO_1ZPLANE_WITHOUT_FASTOP_MASK                                              0x00000400L
#define DB_DEBUG3__ENABLE_INCOHERENT_EQAA_READS_MASK                                                          0x00000800L
#define DB_DEBUG3__DISABLE_OP_Z_DATA_FORWARDING_MASK                                                          0x00001000L
#define DB_DEBUG3__DISABLE_OP_DF_BYPASS_MASK                                                                  0x00002000L
#define DB_DEBUG3__DISABLE_OP_DF_WRITE_COMBINE_MASK                                                           0x00004000L
#define DB_DEBUG3__DISABLE_OP_DF_DIRECT_FEEDBACK_MASK                                                         0x00008000L
#define DB_DEBUG3__DISABLE_SLOCS_PER_CTXT_MATCH_MASK                                                          0x00010000L
#define DB_DEBUG3__SLOW_PREZ_TO_A2M_OMASK_RATE_MASK                                                           0x00020000L
#define DB_DEBUG3__DISABLE_OP_S_DATA_FORWARDING_MASK                                                          0x00040000L
#define DB_DEBUG3__DISABLE_TC_UPDATE_WRITE_COMBINE_MASK                                                       0x00080000L
#define DB_DEBUG3__DISABLE_HZ_TC_WRITE_COMBINE_MASK                                                           0x00100000L
#define DB_DEBUG3__ENABLE_RECOMP_ZDIRTY_SUPPRESSION_OPT_MASK                                                  0x00200000L
#define DB_DEBUG3__ENABLE_TC_MA_ROUND_ROBIN_ARB_MASK                                                          0x00400000L
#define DB_DEBUG3__DISABLE_RAM_READ_SUPPRESION_ON_FWD_MASK                                                    0x00800000L
#define DB_DEBUG3__DISABLE_EQAA_A2M_PERF_OPT_MASK                                                             0x01000000L
#define DB_DEBUG3__DISABLE_DI_DT_STALL_MASK                                                                   0x02000000L
#define DB_DEBUG3__ENABLE_DB_PROCESS_RESET_MASK                                                               0x04000000L
#define DB_DEBUG3__DISABLE_OVERRASTERIZATION_FIX_MASK                                                         0x08000000L
#define DB_DEBUG3__DONT_INSERT_CONTEXT_SUSPEND_MASK                                                           0x10000000L
#define DB_DEBUG3__DELETE_CONTEXT_SUSPEND_MASK                                                                0x20000000L
#define DB_DEBUG3__DISABLE_TS_WRITE_L0_MASK                                                                   0x40000000L
#define DB_DEBUG3__DISABLE_MULTIDTAG_FL_PANIC_REQUIREMENT_MASK                                                0x80000000L
//DB_DEBUG4
#define DB_DEBUG4__DISABLE_QC_Z_MASK_SUMMATION__SHIFT                                                         0x0
#define DB_DEBUG4__DISABLE_QC_STENCIL_MASK_SUMMATION__SHIFT                                                   0x1
#define DB_DEBUG4__DISABLE_RESUMM_TO_SINGLE_STENCIL__SHIFT                                                    0x2
#define DB_DEBUG4__DISABLE_PREZ_POSTZ_DTILE_CONFLICT_STALL__SHIFT                                             0x3
#define DB_DEBUG4__DISABLE_SEPARATE_OP_PIPE_CLK__SHIFT                                                        0x4
#define DB_DEBUG4__DISABLE_SEPARATE_DFSM_CLK__SHIFT                                                           0x5
#define DB_DEBUG4__ALWAYS_ON_RMI_CLK_EN__SHIFT                                                                0x6
#define DB_DEBUG4__ENABLE_DBCB_SLOW_FORMAT_COLLAPSE__SHIFT                                                    0x7
#define DB_DEBUG4__DFSM_CONVERT_PASSTHROUGH_TO_BYPASS__SHIFT                                                  0x8
#define DB_DEBUG4__DISABLE_UNMAPPED_Z_INDICATOR__SHIFT                                                        0x9
#define DB_DEBUG4__DISABLE_UNMAPPED_S_INDICATOR__SHIFT                                                        0xa
#define DB_DEBUG4__DISABLE_UNMAPPED_H_INDICATOR__SHIFT                                                        0xb
#define DB_DEBUG4__ENABLE_A2M_DQUAD_OPTIMIZATION__SHIFT                                                       0xc
#define DB_DEBUG4__DISABLE_DTT_FAST_HTILENACK_LOOKUP__SHIFT                                                   0xd
#define DB_DEBUG4__DISABLE_RESCHECK_MEMCOHER_OPTIMIZATION__SHIFT                                              0xe
#define DB_DEBUG4__DISABLE_DYNAMIC_RAM_LIGHT_SLEEP_MODE__SHIFT                                                0xf
#define DB_DEBUG4__DISABLE_HIZ_TS_COLLISION_DETECT__SHIFT                                                     0x10
#define DB_DEBUG4__DISABLE_LAST_OF_BURST_ON_ACCUM_ALL_EOT__SHIFT                                              0x11
#define DB_DEBUG4__DISABLE_LAST_OF_BURST_ON_FLUSH_CHUNK0_ALL_DONE__SHIFT                                      0x12
#define DB_DEBUG4__ENABLE_CZ_OVERFLOW_TESTMODE__SHIFT                                                         0x13
#define DB_DEBUG4__DISABLE_LATEZ_NO_EXPORT_POWER_SAVING__SHIFT                                                0x14
#define DB_DEBUG4__DISABLE_MCC_BURST_FIFO__SHIFT                                                              0x15
#define DB_DEBUG4__DISABLE_MCC_BURST_FIFO_CONFLICT__SHIFT                                                     0x16
#define DB_DEBUG4__DISABLE_WR_MEM_BURST_FLF_CONSECUTIVE_CHECK__SHIFT                                          0x17
#define DB_DEBUG4__WR_MEM_BURST_CTL__SHIFT                                                                    0x18
#define DB_DEBUG4__DISABLE_WR_MEM_BURST_POOLING__SHIFT                                                        0x1b
#define DB_DEBUG4__DISABLE_RD_MEM_BURST__SHIFT                                                                0x1c
#define DB_DEBUG4__LATE_ACK_SCOREBOARD_NEW__SHIFT                                                             0x1d
#define DB_DEBUG4__LATE_ACK_SCOREBOARD_MULTIPLE_SLOT__SHIFT                                                   0x1e
#define DB_DEBUG4__LATE_ACK_PSD_EOP_GFX9_METHOD__SHIFT                                                        0x1f
#define DB_DEBUG4__DISABLE_QC_Z_MASK_SUMMATION_MASK                                                           0x00000001L
#define DB_DEBUG4__DISABLE_QC_STENCIL_MASK_SUMMATION_MASK                                                     0x00000002L
#define DB_DEBUG4__DISABLE_RESUMM_TO_SINGLE_STENCIL_MASK                                                      0x00000004L
#define DB_DEBUG4__DISABLE_PREZ_POSTZ_DTILE_CONFLICT_STALL_MASK                                               0x00000008L
#define DB_DEBUG4__DISABLE_SEPARATE_OP_PIPE_CLK_MASK                                                          0x00000010L
#define DB_DEBUG4__DISABLE_SEPARATE_DFSM_CLK_MASK                                                             0x00000020L
#define DB_DEBUG4__ALWAYS_ON_RMI_CLK_EN_MASK                                                                  0x00000040L
#define DB_DEBUG4__ENABLE_DBCB_SLOW_FORMAT_COLLAPSE_MASK                                                      0x00000080L
#define DB_DEBUG4__DFSM_CONVERT_PASSTHROUGH_TO_BYPASS_MASK                                                    0x00000100L
#define DB_DEBUG4__DISABLE_UNMAPPED_Z_INDICATOR_MASK                                                          0x00000200L
#define DB_DEBUG4__DISABLE_UNMAPPED_S_INDICATOR_MASK                                                          0x00000400L
#define DB_DEBUG4__DISABLE_UNMAPPED_H_INDICATOR_MASK                                                          0x00000800L
#define DB_DEBUG4__ENABLE_A2M_DQUAD_OPTIMIZATION_MASK                                                         0x00001000L
#define DB_DEBUG4__DISABLE_DTT_FAST_HTILENACK_LOOKUP_MASK                                                     0x00002000L
#define DB_DEBUG4__DISABLE_RESCHECK_MEMCOHER_OPTIMIZATION_MASK                                                0x00004000L
#define DB_DEBUG4__DISABLE_DYNAMIC_RAM_LIGHT_SLEEP_MODE_MASK                                                  0x00008000L
#define DB_DEBUG4__DISABLE_HIZ_TS_COLLISION_DETECT_MASK                                                       0x00010000L
#define DB_DEBUG4__DISABLE_LAST_OF_BURST_ON_ACCUM_ALL_EOT_MASK                                                0x00020000L
#define DB_DEBUG4__DISABLE_LAST_OF_BURST_ON_FLUSH_CHUNK0_ALL_DONE_MASK                                        0x00040000L
#define DB_DEBUG4__ENABLE_CZ_OVERFLOW_TESTMODE_MASK                                                           0x00080000L
#define DB_DEBUG4__DISABLE_LATEZ_NO_EXPORT_POWER_SAVING_MASK                                                  0x00100000L
#define DB_DEBUG4__DISABLE_MCC_BURST_FIFO_MASK                                                                0x00200000L
#define DB_DEBUG4__DISABLE_MCC_BURST_FIFO_CONFLICT_MASK                                                       0x00400000L
#define DB_DEBUG4__DISABLE_WR_MEM_BURST_FLF_CONSECUTIVE_CHECK_MASK                             