/* SPDX-License-Identifier: GPL-2.0-only */
/*
 * OMAP54XX SCRM registers and bitfields
 *
 * Copyright (C) 2013 Texas Instruments Incorporated - https://www.ti.com
 *
 * Benoit Cousson (b-cousson@ti.com)
 *
 * This file is automatically generated from the OMAP hardware databases.
 * We respectfully ask that any modifications to this file be coordinated
 * with the public linux-omap@vger.kernel.org mailing list and the
 * authors above to ensure that the autogeneration scripts are kept
 * up-to-date with the file contents.
 */

#ifndef __ARCH_ARM_MACH_OMAP2_SCRM_54XX_H
#define __ARCH_ARM_MACH_OMAP2_SCRM_54XX_H

#define OMAP5_SCRM_BASE		0x4ae0a000

#define OMAP54XX_SCRM_REGADDR(reg)				\
	OMAP2_L4_IO_ADDRESS(OMAP5_SCRM_BASE + (reg))

/* SCRM */

/* SCRM.SCRM register offsets */
#define OMAP5_SCRM_REVISION_SCRM_OFFSET		0x0000
#define OMAP5_SCRM_REVISION_SCRM		OMAP54XX_SCRM_REGADDR(0x0000)
#define OMAP5_SCRM_CLKSETUPTIME_OFFSET		0x0100
#define OMAP5_SCRM_CLKSETUPTIME			OMAP54XX_SCRM_REGADDR(0x0100)
#define OMAP5_SCRM_PMICSETUPTIME_OFFSET		0x0104
#define OMAP5_SCRM_PMICSETUPTIME		OMAP54XX_SCRM_REGADDR(0x0104)
#define OMAP5_SCRM_ALTCLKSRC_OFFSET		0x0110
#define OMAP5_SCRM_ALTCLKSRC			OMAP54XX_SCRM_REGADDR(0x0110)
#define OMAP5_SCRM_MODEMCLKM_OFFSET		0x0118
#define OMAP5_SCRM_MODEMCLKM			OMAP54XX_SCRM_REGADDR(0x0118)
#define OMAP5_SCRM_D2DCLKM_OFFSET		0x011c
#define OMAP5_SCRM_D2DCLKM			OMAP54XX_SCRM_REGADDR(0x011c)
#define OMAP5_SCRM_EXTCLKREQ_OFFSET		0x0200
#define OMAP5_SCRM_EXTCLKREQ			OMAP54XX_SCRM_REGADDR(0x0200)
#define OMAP5_SCRM_ACCCLKREQ_OFFSET		0x0204
#define OMAP5_SCRM_ACCCLKREQ			OMAP54XX_SCRM_REGADDR(0x0204)
#define OMAP5_SCRM_PWRREQ_OFFSET		0x0208
#define OMAP5_SCRM_PWRREQ			OMAP54XX_SCRM_REGADDR(0x0208)
#define OMAP5_SCRM_AUXCLKREQ0_OFFSET		0x0210
#define OMAP5_SCRM_AUXCLKREQ0			OMAP54XX_SCRM_REGADDR(0x0210)
#define OMAP5_SCRM_AUXCLKREQ1_OFFSET		0x0214
#define OMAP5_SCRM_AUXCLKREQ1			OMAP54XX_SCRM_REGADDR(0x0214)
#define OMAP5_SCRM_AUXCLKREQ2_OFFSET		0x0218
#define OMAP5_SCRM_AUXCLKREQ2			OMAP54XX_SCRM_REGADDR(0x0218)
#define OMAP5_SCRM_AUXCLKREQ3_OFFSET		0x021c
#define OMAP5_SCRM_AUXCLKREQ3			OMAP54XX_SCRM_REGADDR(0x021c)
#define OMAP5_SCRM_AUXCLKREQ4_OFFSET		0x0220
#define OMAP5_SCRM_AUXCLKREQ4			OMAP54XX_SCRM_REGADDR(0x0220)
#define OMAP5_SCRM_AUXCLKREQ5_OFFSET		0x0224
#define OMAP5_SCRM_AUXCLKREQ5			OMAP54XX_SCRM_REGADDR(0x0224)
#define OMAP5_SCRM_D2DCLKREQ_OFFSET		0x0234
#define OMAP5_SCRM_D2DCLKREQ			OMAP54XX_SCRM_REGADDR(0x0234)
#define OMAP5_SCRM_AUXCLK0_OFFSET		0x0310
#define OMAP5_SCRM_AUXCLK0			OMAP54XX_SCRM_REGADDR(0x0310)
#define OMAP5_SCRM_AUXCLK1_OFFSET		0x0314
#define OMAP5_SCRM_AUXCLK1			OMAP54XX_SCRM_REGADDR(0x0314)
#define OMAP5_SCRM_AUXCLK2_OFFSET		0x0318
#define OMAP5_SCRM_AUXCLK2			OMAP54XX_SCRM_REGADDR(0x0318)
#define OMAP5_SCRM_AUXCLK3_OFFSET		0x031c
#define OMAP5_SCRM_AUXCLK3			OMAP54XX_SCRM_REGADDR(0x031c)
#define OMAP5_SCRM_AUXCLK4_OFFSET		0x0320
#define OMAP5_SCRM_AUXCLK4			OMAP54XX_SCRM_REGADDR(0x0320)
#define OMAP5_SCRM_AUXCLK5_OFFSET		0x0324
#define OMAP5_SCRM_AUXCLK5			OMAP54XX_SCRM_REGADDR(0x0324)
#define OMAP5_SCRM_RSTTIME_OFFSET		0x0400
#define OMAP5_SCRM_RSTTIME			OMAP54XX_SCRM_REGADDR(0x0400)
#define OMAP5_SCRM_MODEMRSTCTRL_OFFSET		0x0418
#define OMAP5_SCRM_MODEMRSTCTRL			OMAP54XX_SCRM_REGADDR(0x0418)
#define OMAP5_SCRM_D2DRSTCTRL_OFFSET		0x041c
#define OMAP5_SCRM_D2DRSTCTRL			OMAP54XX_SCRM_REGADDR(0x041c)
#define OMAP5_SCRM_EXTPWRONRSTCTRL_OFFSET	0x0420
#define OMAP5_SCRM_EXTPWRONRSTCTRL		OMAP54XX_SCRM_REGADDR(0x0420)
#define OMAP5_SCRM_EXTWARMRSTST_OFFSET		0x0510
#define OMAP5_SCRM_EXTWARMRSTST			OMAP54XX_SCRM_REGADDR(0x0510)
#define OMAP5_SCRM_APEWARMRSTST_OFFSET		0x0514
#define OMAP5_SCRM_APEWARMRSTST			OMAP54XX_SCRM_REGADDR(0x0514)
#define OMAP5_SCRM_MODEMWARMRSTST_OFFSET	0x0518
#define OMAP5_SCRM_MODEMWARMRSTST		OMAP54XX_SCRM_REGADDR(0x0518)
#define OMAP5_SCRM_D2DWARMRSTST_OFFSET		0x051c
#define OMAP5_SCRM_D2DWARMRSTST			OMAP54XX_SCRM_REGADDR(0x051c)

/*
 * Used by AUXCLKREQ0, AUXCLKREQ1, AUXCLKREQ2, AUXCLKREQ3, AUXCLKREQ4,
 * AUXCLKREQ5, D2DCLKREQ
 */
#define OMAP5_ACCURACY_SHIFT			1
#define OMAP5_ACCURACY_WIDTH			0x1
#define OMAP5_ACCURACY_MASK			(1 << 1)

/* Used by APEWARMRSTST */
#define OMAP5_APEWARMRSTST_SHIFT		1
#define OMAP5_APEWARMRSTST_WIDTH		0x1
#define OMAP5_APEWARMRSTST_MASK			(1 << 1)

/* Used by AUXCLK0, AUXCLK1, AUXCLK2, AUXCLK3, AUXCLK4, AUXCLK5 */
#define OMAP5_CLKDIV_SHIFT			16
#define OMAP5_CLKDIV_WIDTH			0x4
#define OMAP5_CLKDIV_MASK			(0xf << 16)

/* Used by D2DCLKM, MODEMCLKM */
#define OMAP5_CLK_32KHZ_SHIFT			0
#define OMAP5_CLK_32KHZ_WIDTH			0x1
#define OMAP5_CLK_32KHZ_MASK			(1 << 0)

/* Used by D2DRSTCTRL, MODEMRSTCTRL */
#define OMAP5_COLDRST_SHIFT			0
#define OMAP5_COLDRST_WIDTH			0x1
#define OMAP5_COLDRST_MASK			(1 << 0)

/* Used by D2DWARMRSTST */
#define OMAP5_D2DWARMRSTST_SHIFT		3
#define OMAP5_D2DWARMRSTST_WIDTH		0x1
#define OMAP5_D2DWARMRSTST_MASK			(1 << 3)

/* Used by AUXCLK0 */
#define OMAP5_DISABLECLK_SHIFT			9
#define OMAP5_DISABLECLK_WIDTH			0x1
#define OMAP5_DISABLECLK_MASK			(1 << 9)

/* Used by CLKSETUPTIME */
#define OMAP5_DOWNTIME_SHIFT			16
#define OMAP5_DOWNTIME_WIDTH			0x6
#define OMAP5_DOWNTIME_MASK			(0x3f << 16)

/* Used by AUXCLK0, AUXCLK1, AUXCLK2, AUXCLK3, AUXCLK4, AUXCLK5 */
#define OMAP5_ENABLE_SHIFT			8
#define OMAP5_ENABLE_WIDTH			0x1
#define OMAP5_ENABLE_MASK			(1 << 8)

/* Renamed from ENABLE Used by EXTPWRONRSTCTRL */
#define OMAP5_ENABLE_0_0_SHIFT			0
#define OMAP5_ENABLE_0_0_WIDTH			0x1
#define OMAP5_ENABLE_0_0_MASK			(1 << 0)

/* Used by ALTCLKSRC */
#define OMAP5_ENABLE_EXT_SHIFT			3
#define OMAP5_ENABLE_EXT_WIDTH			0x1
#define OMAP5_ENABLE_EXT_MASK			(1 << 3)

/* Used by ALTCLKSRC */
#define OMAP5_ENABLE_INT_SHIFT			2
#define OMAP5_ENABLE_INT_WIDTH			0x1
#define OMAP5_ENABLE_INT_MASK			(1 << 2)

/* Used by EXTWARMRSTST */
#define OMAP5_EXTWARMRSTST_SHIFT		0
#define OMAP5_EXTWARMRSTST_WIDTH		0x1
#define OMAP5_EXTWARMRSTST_MASK			(1 << 0)

/*
 * Used by AUXCLKREQ0, AUXCLKREQ1, AUXCLKREQ2, AUXCLKREQ3, AUXCLKREQ4,
 * AUXCLKREQ5
 */
#define OMAP5_MAPPING_SHIFT			2
#define OMAP5_MAPPING_WIDTH			0x3
#define OMAP5_MAPPING_MASK			(0x7 << 2)

/* Used by ALTCLKSRC */
#define OMAP5_MODE_SHIFT			0
#define OMAP5_MODE_WIDTH			0x2
#define OMAP5_MODE_MASK				(0x3 << 0)

/* Used by MODEMWARMRSTST */
#define OMAP5_MODEMWARMRSTST_SHIFT		2
#define OMAP5_MODEMWARMRSTST_WIDTH		0x1
#define OMAP5_MODEMWARMRSTST_MASK		(1 << 2)

/*
 * Used by ACCCLKREQ, AUXCLK0, AUXCLK1, AUXCLK2, AUXCLK3, AUXCLK4, AUXCLK5,
 * AUXCLKREQ0, AUXCLKREQ1, AUXCLKREQ2, AUXCLKREQ3, AUXCLKREQ4, AUXCLKREQ5,
 * D2DCLKREQ, EXTCLKREQ, PWRREQ
 */
#define OMAP5_POLARITY_SHIFT			0
#define OMAP5_POLARITY_WIDTH			0x1
#define OMAP5_POLARITY_MASK			(1 << 0)

/* Used by EXTPWRONRSTCTRL */
#define OMAP5_PWRONRST_SHIFT			1
#define OMAP5_PWRONRST_WIDTH			0x1
#define OMAP5_PWRONRST_MASK			(1 << 1)

/* Used by REVISION_SCRM */
#define OMAP5_REV_SHIFT				0
#define OMAP5_REV_WIDTH				0x8
#define OMAP5_REV_MASK				(0xff << 0)

/* Used by RSTTIME */
#define OMAP5_RSTTIME_SHIFT			0
#define OMAP5_RSTTIME_WIDTH			0x4
#define OMAP5_RSTTIME_MASK			(0xf << 0)

/* Used by CLKSETUPTIME */
#define OMAP5_SETUPTIME_SHIFT			0
#define OMAP5_SETUPTIME_WIDTH			0xc
#define OMAP5_SETUPTIME_MASK			(0xfff << 0)

/* Used by PMICSETUPTIME */
#define OMAP5_SLEEPTIME_SHIFT			0
#define OMAP5_SLEEPTIME_WIDTH			0x6
#define OMAP5_SLEEPTIME_MASK			(0x3f << 0)

/* Used by AUXCLK0, AUXCLK1, AUXCLK2, AUXCLK3, AUXCLK4, AUXCLK5 */
#define OMAP5_SRCSELECT_SHIFT			1
#define OMAP5_SRCSELECT_WIDTH			0x2
#define OMAP5_SRCSELECT_MASK			(0x3 << 1)

/* Used by D2DCLKM */
#define OMAP5_SYSCLK_SHIFT			1
#define OMAP5_SYSCLK_WIDTH			0x1
#define OMAP5_SYSCLK_MASK			(1 << 1)

/* Used by PMICSETUPTIME */
#define OMAP5_WAKEUPTIME_SHIFT			16
#define OMAP5_WAKEUPTIME_WIDTH			0x6
#define OMAP5_WAKEUPTIME_MASK			(0x3f << 16)

/* Used by D2DRSTCTRL, MODEMRSTCTRL */
#define OMAP5_WARMRST_SHIFT			1
#define OMAP5_WARMRST_WIDTH			0x1
#define OMAP5_WARMRST_MASK			(1 << 1)

#endif
