/* SPDX-License-Identifier: GPL-2.0-only */
/*
 * ispreg.h
 *
 * TI OMAP3 ISP - Registers definitions
 *
 * Copyright (C) 2010 Nokia Corporation
 * Copyright (C) 2009 Texas Instruments, Inc
 *
 * Contacts: Laurent Pinchart <laurent.pinchart@ideasonboard.com>
 *	     Sakari Ailus <sakari.ailus@iki.fi>
 */

#ifndef OMAP3_ISP_REG_H
#define OMAP3_ISP_REG_H

#define CM_CAM_MCLK_HZ			172800000	/* Hz */

/* ISP module register offset */

#define ISP_REVISION			(0x000)
#define ISP_SYSCONFIG			(0x004)
#define ISP_SYSSTATUS			(0x008)
#define ISP_IRQ0ENABLE			(0x00C)
#define ISP_IRQ0STATUS			(0x010)
#define ISP_IRQ1ENABLE			(0x014)
#define ISP_IRQ1STATUS			(0x018)
#define ISP_TCTRL_GRESET_LENGTH		(0x030)
#define ISP_TCTRL_PSTRB_REPLAY		(0x034)
#define ISP_CTRL			(0x040)
#define ISP_SECURE			(0x044)
#define ISP_TCTRL_CTRL			(0x050)
#define ISP_TCTRL_FRAME			(0x054)
#define ISP_TCTRL_PSTRB_DELAY		(0x058)
#define ISP_TCTRL_STRB_DELAY		(0x05C)
#define ISP_TCTRL_SHUT_DELAY		(0x060)
#define ISP_TCTRL_PSTRB_LENGTH		(0x064)
#define ISP_TCTRL_STRB_LENGTH		(0x068)
#define ISP_TCTRL_SHUT_LENGTH		(0x06C)
#define ISP_PING_PONG_ADDR		(0x070)
#define ISP_PING_PONG_MEM_RANGE		(0x074)
#define ISP_PING_PONG_BUF_SIZE		(0x078)

/* CCP2 receiver registers */

#define ISPCCP2_REVISION		(0x000)
#define ISPCCP2_SYSCONFIG		(0x004)
#define ISPCCP2_SYSCONFIG_SOFT_RESET	(1 << 1)
#define ISPCCP2_SYSCONFIG_AUTO_IDLE		0x1
#define ISPCCP2_SYSCONFIG_MSTANDBY_MODE_SHIFT	12
#define ISPCCP2_SYSCONFIG_MSTANDBY_MODE_FORCE	\
	(0x0 << ISPCCP2_SYSCONFIG_MSTANDBY_MODE_SHIFT)
#define ISPCCP2_SYSCONFIG_MSTANDBY_MODE_NO	\
	(0x1 << ISPCCP2_SYSCONFIG_MSTANDBY_MODE_SHIFT)
#define ISPCCP2_SYSCONFIG_MSTANDBY_MODE_SMART	\
	(0x2 << ISPCCP2_SYSCONFIG_MSTANDBY_MODE_SHIFT)
#define ISPCCP2_SYSSTATUS		(0x008)
#define ISPCCP2_SYSSTATUS_RESET_DONE	(1 << 0)
#define ISPCCP2_LC01_IRQENABLE		(0x00C)
#define ISPCCP2_LC01_IRQSTATUS		(0x010)
#define ISPCCP2_LC01_IRQSTATUS_LC0_FS_IRQ	(1 << 11)
#define ISPCCP2_LC01_IRQSTATUS_LC0_LE_IRQ	(1 << 10)
#define ISPCCP2_LC01_IRQSTATUS_LC0_LS_IRQ	(1 << 9)
#define ISPCCP2_LC01_IRQSTATUS_LC0_FE_IRQ	(1 << 8)
#define ISPCCP2_LC01_IRQSTATUS_LC0_COUNT_IRQ	(1 << 7)
#define ISPCCP2_LC01_IRQSTATUS_LC0_FIFO_OVF_IRQ	(1 << 5)
#define ISPCCP2_LC01_IRQSTATUS_LC0_CRC_IRQ	(1 << 4)
#define ISPCCP2_LC01_IRQSTATUS_LC0_FSP_IRQ	(1 << 3)
#define ISPCCP2_LC01_IRQSTATUS_LC0_FW_IRQ	(1 << 2)
#define ISPCCP2_LC01_IRQSTATUS_LC0_FSC_IRQ	(1 << 1)
#define ISPCCP2_LC01_IRQSTATUS_LC0_SSC_IRQ	(1 << 0)

#define ISPCCP2_LC23_IRQENABLE		(0x014)
#define ISPCCP2_LC23_IRQSTATUS		(0x018)
#define ISPCCP2_LCM_IRQENABLE		(0x02C)
#define ISPCCP2_LCM_IRQSTATUS_EOF_IRQ		(1 << 0)
#define ISPCCP2_LCM_IRQSTATUS_OCPERROR_IRQ	(1 << 1)
#define ISPCCP2_LCM_IRQSTATUS		(0x030)
#define ISPCCP2_CTRL			(0x040)
#define ISPCCP2_CTRL_IF_EN		(1 << 0)
#define ISPCCP2_CTRL_PHY_SEL		(1 << 1)
#define ISPCCP2_CTRL_PHY_SEL_CLOCK	(0 << 1)
#define ISPCCP2_CTRL_PHY_SEL_STROBE	(1 << 1)
#define ISPCCP2_CTRL_PHY_SEL_MASK	0x1
#define ISPCCP2_CTRL_PHY_SEL_SHIFT	1
#define ISPCCP2_CTRL_IO_OUT_SEL		(1 << 2)
#define ISPCCP2_CTRL_IO_OUT_SEL_MASK	0x1
#define ISPCCP2_CTRL_IO_OUT_SEL_SHIFT	2
#define ISPCCP2_CTRL_MODE		(1 << 4)
#define ISPCCP2_CTRL_VP_CLK_FORCE_ON	(1 << 9)
#define ISPCCP2_CTRL_INV		(1 << 10)
#define ISPCCP2_CTRL_INV_MASK		0x1
#define ISPCCP2_CTRL_INV_SHIFT		10
#define ISPCCP2_CTRL_VP_ONLY_EN		(1 << 11)
#define ISPCCP2_CTRL_VP_CLK_POL		(1 << 12)
#define ISPCCP2_CTRL_VP_CLK_POL_MASK	0x1
#define ISPCCP2_CTRL_VP_CLK_POL_SHIFT	12
#define ISPCCP2_CTRL_VPCLK_DIV_SHIFT	15
#define ISPCCP2_CTRL_VPCLK_DIV_MASK	0x1ffff /* [31:15] */
#define ISPCCP2_CTRL_VP_OUT_CTRL_SHIFT	8 /* 3430 bits */
#define ISPCCP2_CTRL_VP_OUT_CTRL_MASK	0x3 /* 3430 bits */
#define ISPCCP2_DBG			(0x044)
#define ISPCCP2_GNQ			(0x048)
#define ISPCCP2_LCx_CTRL(x)			((0x050)+0x30*(x))
#define ISPCCP2_LCx_CTRL_CHAN_EN		(1 << 0)
#define ISPCCP2_LCx_CTRL_CRC_EN			(1 << 19)
#define ISPCCP2_LCx_CTRL_CRC_MASK		0x1
#define ISPCCP2_LCx_CTRL_CRC_SHIFT		2
#define ISPCCP2_LCx_CTRL_CRC_SHIFT_15_0		19
#define ISPCCP2_LCx_CTRL_REGION_EN		(1 << 1)
#define ISPCCP2_LCx_CTRL_REGION_MASK		0x1
#define ISPCCP2_LCx_CTRL_REGION_SHIFT		1
#define ISPCCP2_LCx_CTRL_FORMAT_MASK_15_0	0x3f
#define ISPCCP2_LCx_CTRL_FORMAT_SHIFT_15_0	0x2
#define ISPCCP2_LCx_CTRL_FORMAT_MASK		0x1f
#define ISPCCP2_LCx_CTRL_FORMAT_SHIFT		0x3
#define ISPCCP2_LCx_CODE(x)		((0x054)+0x30*(x))
#define ISPCCP2_LCx_STAT_START(x)	((0x058)+0x30*(x))
#define ISPCCP2_LCx_STAT_SIZE(x)	((0x05C)+0x30*(x))
#define ISPCCP2_LCx_SOF_ADDR(x)		((0x060)+0x30*(x))
#define ISPCCP2_LCx_EOF_ADDR(x)		((0x064)+0x30*(x))
#define ISPCCP2_LCx_DAT_START(x)	((0x068)+0x30*(x))
#define ISPCCP2_LCx_DAT_SIZE(x)		((0x06C)+0x30*(x))
#define ISPCCP2_LCx_DAT_MASK		0xFFF
#define ISPCCP2_LCx_DAT_SHIFT		16
#define ISPCCP2_LCx_DAT_PING_ADDR(x)	((0x070)+0x30*(x))
#define ISPCCP2_LCx_DAT_PONG_ADDR(x)	((0x074)+0x30*(x))
#define ISPCCP2_LCx_DAT_OFST(x)		((0x078)+0x30*(x))
#define ISPCCP2_LCM_CTRL		(0x1D0)
#define ISPCCP2_LCM_CTRL_CHAN_EN               (1 << 0)
#define ISPCCP2_LCM_CTRL_DST_PORT              (1 << 2)
#define ISPCCP2_LCM_CTRL_DST_PORT_SHIFT		2
#define ISPCCP2_LCM_CTRL_READ_THROTTLE_SHIFT	3
#define ISPCCP2_LCM_CTRL_READ_THROTTLE_MASK	0x11
#define ISPCCP2_LCM_CTRL_BURST_SIZE_SHIFT	5
#define ISPCCP2_LCM_CTRL_BURST_SIZE_MASK	0x7
#define ISPCCP2_LCM_CTRL_SRC_FORMAT_SHIFT	16
#define ISPCCP2_LCM_CTRL_SRC_FORMAT_MASK	0x7
#define ISPCCP2_LCM_CTRL_SRC_DECOMPR_SHIFT	20
#define ISPCCP2_LCM_CTRL_SRC_DECOMPR_MASK	0x3
#define ISPCCP2_LCM_CTRL_SRC_DPCM_PRED		(1 << 22)
#define ISPCCP2_LCM_CTRL_SRC_PACK		(1 << 23)
#define ISPCCP2_LCM_CTRL_DST_FORMAT_SHIFT	24
#define ISPCCP2_LCM_CTRL_DST_FORMAT_MASK	0x7
#define ISPCCP2_LCM_VSIZE		(0x1D4)
#define ISPCCP2_LCM_VSIZE_SHIFT		16
#define ISPCCP2_LCM_HSIZE		(0x1D8)
#define ISPCCP2_LCM_HSIZE_SHIFT		16
#define ISPCCP2_LCM_PREFETCH		(0x1DC)
#define ISPCCP2_LCM_PREFETCH_SHIFT	3
#define ISPCCP2_LCM_SRC_ADDR		(0x1E0)
#define ISPCCP2_LCM_SRC_OFST		(0x1E4)
#define ISPCCP2_LCM_DST_ADDR		(0x1E8)
#define ISPCCP2_LCM_DST_OFST		(0x1EC)

/* CCDC module register offset */

#define ISPCCDC_PID			(0x000)
#define ISPCCDC_PCR			(0x004)
#define ISPCCDC_SYN_MODE		(0x008)
#define ISPCCDC_HD_VD_WID		(0x00C)
#define ISPCCDC_PIX_LINES		(0x010)
#define ISPCCDC_HORZ_INFO		(0x014)
#define ISPCCDC_VERT_START		(0x018)
#define ISPCCDC_VERT_LINES		(0x01C)
#define ISPCCDC_CULLING			(0x020)
#define ISPCCDC_HSIZE_OFF		(0x024)
#define ISPCCDC_SDOFST			(0x028)
#define ISPCCDC_SDR_ADDR		(0x02C)
#define ISPCCDC_CLAMP			(0x030)
#define ISPCCDC_DCSUB			(0x034)
#define ISPCCDC_COLPTN			(0x038)
#define ISPCCDC_BLKCMP			(0x03C)
#define ISPCCDC_FPC			(0x040)
#define ISPCCDC_FPC_ADDR		(0x044)
#define ISPCCDC_VDINT			(0x048)
#define ISPCCDC_ALAW			(0x04C)
#define ISPCCDC_REC656IF		(0x050)
#define ISPCCDC_CFG			(0x054)
#define ISPCCDC_FMTCFG			(0x058)
#define ISPCCDC_FMT_HORZ		(0x05C)
#define ISPCCDC_FMT_VERT		(0x060)
#define ISPCCDC_FMT_ADDR0		(0x064)
#define ISPCCDC_FMT_ADDR1		(0x068)
#define ISPCCDC_FMT_ADDR2		(0x06C)
#define ISPCCDC_FMT_ADDR3		(0x070)
#define ISPCCDC_FMT_ADDR4		(0x074)
#define ISPCCDC_FMT_ADDR5		(0x078)
#define ISPCCDC_FMT_ADDR6		(0x07C)
#define ISPCCDC_FMT_ADDR7		(0x080)
#define ISPCCDC_PRGEVEN0		(0x084)
#define ISPCCDC_PRGEVEN1		(0x088)
#define ISPCCDC_PRGODD0			(0x08C)
#define ISPCCDC_PRGODD1			(0x090)
#define ISPCCDC_VP_OUT			(0x094)

#define ISPCCDC_LSC_CONFIG		(0x098)
#define ISPCCDC_LSC_INITIAL		(0x09C)
#define ISPCCDC_LSC_TABLE_BASE		(0x0A0)
#define ISPCCDC_LSC_TABLE_OFFSET	(0x0A4)

/* SBL */
#define ISPSBL_PCR			0x4
#define ISPSBL_PCR_H3A_AEAWB_WBL_OVF	(1 << 16)
#define ISPSBL_PCR_H3A_AF_WBL_OVF	(1 << 17)
#define ISPSBL_PCR_RSZ4_WBL_OVF		(1 << 18)
#define ISPSBL_PCR_RSZ3_WBL_OVF		(1 << 19)
#define ISPSBL_PCR_RSZ2_WBL_OVF		(1 << 20)
#define ISPSBL_PCR_RSZ1_WBL_OVF		(1 << 21)
#define ISPSBL_PCR_PRV_WBL_OVF		(1 << 22)
#define ISPSBL_PCR_CCDC_WBL_OVF		(1 << 23)
#define ISPSBL_PCR_CCDCPRV_2_RSZ_OVF	(1 << 24)
#define ISPSBL_PCR_CSIA_WBL_OVF		(1 << 25)
#define ISPSBL_PCR_CSIB_WBL_OVF		(1 << 26)
#define ISPSBL_CCDC_WR_0		(0x028)
#define ISPSBL_CCDC_WR_0_DATA_READY	(1 << 21)
#define ISPSBL_CCDC_WR_1		(0x02C)
#define ISPSBL_CCDC_WR_2		(0x030)
#define ISPSBL_CCDC_WR_3		(0x034)

#define ISPSBL_SDR_REQ_EXP		0xF8
#define ISPSBL_SDR_REQ_HIST_EXP_SHIFT	0
#define ISPSBL_SDR_REQ_HIST_EXP_MASK	(0x3FF)
#define ISPSBL_SDR_REQ_RSZ_EXP_SHIFT	10
#define ISPSBL_SDR_REQ_RSZ_EXP_MASK	(0x3FF << ISPSBL_SDR_REQ_RSZ_EXP_SHIFT)
#define ISPSBL_SDR_REQ_PRV_EXP_SHIFT	20
#define ISPSBL_SDR_REQ_PRV_EXP_MASK	(0x3FF << ISPSBL_SDR_REQ_PRV_EXP_SHIFT)

/* Histogram registers */
#define ISPHIST_PID			(0x000)
#define ISPHIST_PCR			(0x004)
#define ISPHIST_CNT			(0x008)
#define ISPHIST_WB_GAIN			(0x00C)
#define ISPHIST_R0_HORZ			(0x010)
#define ISPHIST_R0_VERT			(0x014)
#define ISPHIST_R1_HORZ			(0x018)
#define ISPHIST_R1_VERT			(0x01C)
#define ISPHIST_R2_HORZ			(0x020)
#define ISPHIST_R2_VERT			(0x024)
#define ISPHIST_R3_HORZ			(0x028)
#define ISPHIST_R3_VERT			(0x02C)
#define ISPHIST_ADDR			(0x030)
#define ISPHIST_DATA			(0x034)
#define ISPHIST_RADD			(0x038)
#define ISPHIST_RADD_OFF		(0x03C)
#define ISPHIST_H_V_INFO		(0x040)

/* H3A module registers */
#define ISPH3A_PID			(0x000)
#define ISPH3A_PCR			(0x004)
#define ISPH3A_AEWWIN1			(0x04C)
#define ISPH3A_AEWINSTART		(0x050)
#define ISPH3A_AEWINBLK			(0x054)
#define ISPH3A_AEWSUBWIN		(0x058)
#define ISPH3A_AEWBUFST			(0x05C)
#define ISPH3A_AFPAX1			(0x008)
#define ISPH3A_AFPAX2			(0x00C)
#define ISPH3A_AFPAXSTART		(0x010)
#define ISPH3A_AFIIRSH			(0x014)
#define ISPH3A_AFBUFST			(0x018)
#define ISPH3A_AFCOEF010		(0x01C)
#define ISPH3A_AFCOEF032		(0x020)
#define ISPH3A_AFCOEF054		(0x024)
#define ISPH3A_AFCOEF076		(0x028)
#define ISPH3A_AFCOEF098		(0x02C)
#define ISPH3A_AFCOEF0010		(0x030)
#define ISPH3A_AFCOEF110		(0x034)
#define ISPH3A_AFCOEF132		(0x038)
#define ISPH3A_AFCOEF154		(0x03C)
#define ISPH3A_AFCOEF176		(0x040)
#define ISPH3A_AFCOEF198		(0x044)
#define ISPH3A_AFCOEF1010		(0x048)

#define ISPPRV_PCR			(0x004)
#define ISPPRV_HORZ_INFO		(0x008)
#define ISPPRV_VERT_INFO		(0x00C)
#define ISPPRV_RSDR_ADDR		(0x010)
#define ISPPRV_RADR_OFFSET		(0x014)
#define ISPPRV_DSDR_ADDR		(0x018)
#define ISPPRV_DRKF_OFFSET		(0x01C)
#define ISPPRV_WSDR_ADDR		(0x020)
#define ISPPRV_WADD_OFFSET		(0x024)
#define ISPPRV_AVE			(0x028)
#define ISPPRV_HMED			(0x02C)
#define ISPPRV_NF			(0x030)
#define ISPPRV_WB_DGAIN			(0x034)
#define ISPPRV_WBGAIN			(0x038)
#define ISPPRV_WBSEL			(0x03C)
#define ISPPRV_CFA			(0x040)
#define ISPPRV_BLKADJOFF		(0x044)
#define ISPPRV_RGB_MAT1			(0x048)
#define ISPPRV_RGB_MAT2			(0x04C)
#define ISPPRV_RGB_MAT3			(0x050)
#define ISPPRV_RGB_MAT4			(0x054)
#define ISPPRV_RGB_MAT5			(0x058)
#define ISPPRV_RGB_OFF1			(0x05C)
#define ISPPRV_RGB_OFF2			(0x060)
#define ISPPRV_CSC0			(0x064)
#define ISPPRV_CSC1			(0x068)
#define ISPPRV_CSC2			(0x06C)
#define ISPPRV_CSC_OFFSET		(0x070)
#define ISPPRV_CNT_BRT			(0x074)
#define ISPPRV_CSUP			(0x078)
#define ISPPRV_SETUP_YC			(0x07C)
#define ISPPRV_SET_TBL_ADDR		(0x080)
#define ISPPRV_SET_TBL_DATA		(0x084)
#define ISPPRV_CDC_THR0			(0x090)
#define ISPPRV_CDC_THR1			(ISPPRV_CDC_THR0 + (0x4))
#define ISPPRV_CDC_THR2			(ISPPRV_CDC_THR0 + (0x4) * 2)
#define ISPPRV_CDC_THR3			(ISPPRV_CDC_THR0 + (0x4) * 3)

#define ISPPRV_REDGAMMA_TABLE_ADDR	0x0000
#define ISPPRV_GREENGAMMA_TABLE_ADDR	0x0400
#define ISPPRV_BLUEGAMMA_TABLE_ADDR	0x0800
#define ISPPRV_NF_TABLE_ADDR		0x0C00
#define ISPPRV_YENH_TABLE_ADDR		0x1000
#define ISPPRV_CFA_TABLE_ADDR		0x1400

#define ISPRSZ_MIN_OUTPUT		64
#define ISPRSZ_MAX_OUTPUT		3312

/* Resizer module register offset */
#define ISPRSZ_PID			(0x000)
#define ISPRSZ_PCR			(0x004)
#define ISPRSZ_CNT			(0x008)
#define ISPRSZ_OUT_SIZE			(0x00C)
#define ISPRSZ_IN_START			(0x010)
#define ISPRSZ_IN_SIZE			(0x014)
#define ISPRSZ_SDR_INADD		(0x018)
#define ISPRSZ_SDR_INOFF		(0x01C)
#define ISPRSZ_SDR_OUTADD		(0x020)
#define ISPRSZ_SDR_OUTOFF		(0x024)
#define ISPRSZ_HFILT10			(0x028)
#define ISPRSZ_HFILT32			(0x02C)
#define ISPRSZ_HFILT54			(0x030)
#define ISPRSZ_HFILT76			(0x034)
#define ISPRSZ_HFILT98			(0x038)
#define ISPRSZ_HFILT1110		(0x03C)
#define ISPRSZ_HFILT1312		(0x040)
#define ISPRSZ_HFILT1514		(0x044)
#define ISPRSZ_HFILT1716		(0x048)
#define ISPRSZ_HFILT1918		(0x04C)
#define ISPRSZ_HFILT2120		(0x050)
#define ISPRSZ_HFILT2322		(0x054)
#define ISPRSZ_HFILT2524		(0x058)
#define ISPRSZ_HFILT2726		(0x05C)
#define ISPRSZ_HFILT2928		(0x060)
#define ISPRSZ_HFILT3130		(0x064)
#define ISPRSZ_VFILT10			(0x068)
#define ISPRSZ_VFILT32			(0x06C)
#define ISPRSZ_VFILT54			(0x070)
#define ISPRSZ_VFILT76			(0x074)
#define ISPRSZ_VFILT98			(0x078)
#define ISPRSZ_VFILT1110		(0x07C)
#define ISPRSZ_VFILT1312		(0x080)
#define ISPRSZ_VFILT1514		(0x084)
#define ISPRSZ_VFILT1716		(0x088)
#define ISPRSZ_VFILT1918		(0x08C)
#define ISPRSZ_VFILT2120		(0x090)
#define ISPRSZ_VFILT2322		(0x094)
#define ISPRSZ_VFILT2524		(0x098)
#define ISPRSZ_VFILT2726		(0x09C)
#define ISPRSZ_VFILT2928		(0x0A0)
#define ISPRSZ_VFILT3130		(0x0A4)
#define ISPRSZ_YENH			(0x0A8)

#define ISP_INT_CLR			0xFF113F11
#define ISPPRV_PCR_EN			1
#define ISPPRV_PCR_BUSY			(1 << 1)
#define ISPPRV_PCR_SOURCE		(1 << 2)
#define ISPPRV_PCR_ONESHOT		(1 << 3)
#define ISPPRV_PCR_WIDTH		(1 << 4)
#define ISPPRV_PCR_INVALAW		(1 << 5)
#define ISPPRV_PCR_DRKFEN		(1 << 6)
#define ISPPRV_PCR_DRKFCAP		(1 << 7)
#define ISPPRV_PCR_HMEDEN		(1 << 8)
#define ISPPRV_PCR_NFEN			(1 << 9)
#define ISPPRV_PCR_CFAEN		(1 << 10)
#define ISPPRV_PCR_CFAFMT_SHIFT		11
#define ISPPRV_PCR_CFAFMT_MASK		0x7800
#define ISPPRV_PCR_CFAFMT_BAYER		(0 << 11)
#define ISPPRV_PCR_CFAFMT_SONYVGA	(1 << 11)
#define ISPPRV_PCR_CFAFMT_RGBFOVEON	(2 << 11)
#define ISPPRV_PCR_CFAFMT_DNSPL		(3 << 11)
#define ISPPRV_PCR_CFAFMT_HONEYCOMB	(4 << 11)
#define ISPPRV_PCR_CFAFMT_RRGGBBFOVEON	(5 << 11)
#define ISPPRV_PCR_YNENHEN		(1 << 15)
#define ISPPRV_PCR_SUPEN		(1 << 16)
#define ISPPRV_PCR_YCPOS_SHIFT		17
#define ISPPRV_PCR_YCPOS_YCrYCb		(0 << 17)
#define ISPPRV_PCR_YCPOS_YCbYCr		(1 << 17)
#define ISPPRV_PCR_YCPOS_CbYCrY		(2 << 17)
#define ISPPRV_PCR_YCPOS_CrYCbY		(3 << 17)
#define ISPPRV_PCR_RSZPORT		(1 << 19)
#define ISPPRV_PCR_SDRPORT		(1 << 20)
#define ISPPRV_PCR_SCOMP_EN		(1 << 21)
#define ISPPRV_PCR_SCOMP_SFT_SHIFT	(22)
#define ISPPRV_PCR_SCOMP_SFT_MASK	(7 << 22)
#define ISPPRV_PCR_GAMMA_BYPASS		(1 << 26)
#define ISPPRV_PCR_DCOREN		(1 << 27)
#define ISPPRV_PCR_DCCOUP		(1 << 28)
#define ISPPRV_PCR_DRK_FAIL		(1 << 31)

#define ISPPRV_HORZ_INFO_EPH_SHIFT	0
#define ISPPRV_HORZ_INFO_EPH_MASK	0x3fff
#define ISPPRV_HORZ_INFO_SPH_SHIFT	16
#define ISPPRV_HORZ_INFO_SPH_MASK	0x3fff0

#define ISPPRV_VERT_INFO_ELV_SHIFT	0
#define ISPPRV_VERT_INFO_ELV_MASK	0x3fff
#define ISPPRV_VERT_INFO_SLV_SHIFT	16
#define ISPPRV_VERT_INFO_SLV_MASK	0x3fff0

#define ISPPRV_AVE_EVENDIST_SHIFT	2
#define ISPPRV_AVE_EVENDIST_1		0x0
#define ISPPRV_AVE_EVENDIST_2		0x1
#define ISPPRV_AVE_EVENDIST_3		0x2
#define ISPPRV_AVE_EVENDIST_4		0x3
#define ISPPRV_AVE_ODDDIST_SHIFT	4
#define ISPPRV_AVE_ODDDIST_1		0x0
#define ISPPRV_AVE_ODDDIST_2		0x1
#define ISPPRV_AVE_ODDDIST_3		0x2
#define ISPPRV_AVE_ODDDIST_4		0x3

#define ISPPRV_HMED_THRESHOLD_SHIFT	0
#define ISPPRV_HMED_EVENDIST		(1 << 8)
#define ISPPRV_HMED_ODDDIST		(1 << 9)

#define ISPPRV_WBGAIN_COEF0_SHIFT	0
#define ISPPRV_WBGAIN_COEF1_SHIFT	8
#define ISPPRV_WBGAIN_COEF2_SHIFT	16
#define ISPPRV_WBGAIN_COEF3_SHIFT	24

#define ISPPRV_WBSEL_COEF0		0x0
#define ISPPRV_WBSEL_COEF1		0x1
#define ISPPRV_WBSEL_COEF2		0x2
#define ISPPRV_WBSEL_COEF3		0x3

#define ISPPRV_WBSEL_N0_0_SHIFT		0
#define ISPPRV_WBSEL_N0_1_SHIFT		2
#define ISPPRV_WBSEL_N0_2_SHIFT		4
#define ISPPRV_WBSEL_N0_3_SHIFT		6
#define ISPPRV_WBSEL_N1_0_SHIFT		8
#define ISPPRV_WBSEL_N1_1_SHIFT		10
#define ISPPRV_WBSEL_N1_2_SHIFT		12
#define ISPPRV_WBSEL_N1_3_SHIFT		14
#define ISPPRV_WBSEL_N2_0_SHIFT		16
#define ISPPRV_WBSEL_N2_1_SHIFT		18
#define ISPPRV_WBSEL_N2_2_SHIFT		20
#define ISPPRV_WBSEL_N2_3_SHIFT		22
#define ISPPRV_WBSEL_N3_0_SHIFT		24
#define ISPPRV_WBSEL_N3_1_SHIFT		26
#define ISPPRV_WBSEL_N3_2_SHIFT		28
#define ISPPRV_WBSEL_N3_3_SHIFT		30

#define ISPPRV_CFA_GRADTH_HOR_SHIFT	0
#define ISPPRV_CFA_GRADTH_VER_SHIFT	8

#define ISPPRV_BLKADJOFF_B_SHIFT	0
#define ISPPRV_BLKADJOFF_G_SHIFT	8
#define ISPPRV_BLKADJOFF_R_SHIFT	16

#define ISPPRV_RGB_MAT1_MTX_RR_SHIFT	0
#define ISPPRV_RGB_MAT1_MTX_GR_SHIFT	16

#define ISPPRV_RGB_MAT2_MTX_BR_SHIFT	0
#define ISPPRV_RGB_MAT2_MTX_RG_SHIFT	16

#define ISPPRV_RGB_MAT3_MTX_GG_SHIFT	0
#define ISPPRV_RGB_MAT3_MTX_BG_SHIFT	16

#define ISPPRV_RGB_MAT4_MTX_RB_SHIFT	0
#define ISPPRV_RGB_MAT4_MTX_GB_SHIFT	16

#define ISPPRV_RGB_MAT5_MTX_BB_SHIFT	0

#define ISPPRV_RGB_OFF1_MTX_OFFG_SHIFT	0
#define ISPPRV_RGB_OFF1_MTX_OFFR_SHIFT	16

#define ISPPRV_RGB_OFF2_MTX_OFFB_SHIFT	0

#define ISPPRV_CSC0_RY_SHIFT		0
#define ISPPRV_CSC0_GY_SHIFT		10
#define ISPPRV_CSC0_BY_SHIFT		20

#define ISPPRV_CSC1_RCB_SHIFT		0
#define ISPPRV_CSC1_GCB_SHIFT		10
#define ISPPRV_CSC1_BCB_SHIFT		20

#define ISPPRV_CSC2_RCR_SHIFT		0
#define ISPPRV_CSC2_GCR_SHIFT		10
#define ISPPRV_CSC2_BCR_SHIFT		20

#define ISPPRV_CSC_OFFSET_CR_SHIFT	0
#define ISPPRV_CSC_OFFSET_CB_SHIFT	8
#define ISPPRV_CSC_OFFSET_Y_SHIFT	16

#define ISPPRV_CNT_BRT_BRT_SHIFT	0
#define ISPPRV_CNT_BRT_CNT_SHIFT	8

#define ISPPRV_CONTRAST_MAX		0x10
#define ISPPRV_CONTRAST_MIN		0xFF
#define ISPPRV_BRIGHT_MIN		0x00
#define ISPPRV_BRIGHT_MAX		0xFF

#define ISPPRV_CSUP_CSUPG_SHIFT		0
#define ISPPRV_CSUP_THRES_SHIFT		8
#define ISPPRV_CSUP_HPYF_SHIFT		16

#define ISPPRV_SETUP_YC_MINC_SHIFT	0
#define ISPPRV_SETUP_YC_MAXC_SHIFT	8
#define ISPPRV_SETUP_YC_MINY_SHIFT	16
#define ISPPRV_SETUP_YC_MAXY_SHIFT	24
#define ISPPRV_YC_MAX			0xFF
#define ISPPRV_YC_MIN			0x0

/* Define bit fields within selected registers */
#define ISP_REVISION_SHIFT			0

#define ISP_SYSCONFIG_AUTOIDLE			(1 << 0)
#define ISP_SYSCONFIG_SOFTRESET			(1 << 1)
#define ISP_SYSCONFIG_MIDLEMODE_SHIFT		12
#define ISP_SYSCONFIG_MIDLEMODE_FORCESTANDBY	0x0
#define ISP_SYSCONFIG_MIDLEMODE_NOSTANBY	0x1
#define ISP_SYSCONFIG_MIDLEMODE_SMARTSTANDBY	0x2

#define ISP_SYSSTATUS_RESETDONE			0

#define IRQ0ENABLE_CSIA_IRQ			(1 << 0)
#define IRQ0ENABLE_CSIC_IRQ			(1 << 1)
#define IRQ0ENABLE_CCP2_LCM_IRQ			(1 << 3)
#define IRQ0ENABLE_CCP2_LC0_IRQ			(1 << 4)
#define IRQ0ENABLE_CCP2_LC1_IRQ			(1 << 5)
#define IRQ0ENABLE_CCP2_LC2_IRQ			(1 << 6)
#define IRQ0ENABLE_CCP2_LC3_IRQ			(1 << 7)
#define IRQ0ENABLE_CSIB_IRQ			(IRQ0ENABLE_CCP2_LCM_IRQ | \
						IRQ0ENABLE_CCP2_LC0_IRQ | \
						IRQ0ENABLE_CCP2_LC1_IRQ | \
						IRQ0ENABLE_CCP2_LC2_IRQ | \
						IRQ0ENABLE_CCP2_LC3_IRQ)

#define IRQ0ENABLE_CCDC_VD0_IRQ			(1 << 8)
#define IRQ0ENABLE_CCDC_VD1_IRQ			(1 << 9)
#define IRQ0ENABLE_CCDC_VD2_IRQ			(1 << 10)
#define IRQ0ENABLE_CCDC_ERR_IRQ			(1 << 11)
#define IRQ0ENABLE_H3A_AF_DONE_IRQ		(1 << 12)
#define IRQ0ENABLE_H3A_AWB_DONE_IRQ		(1 << 13)
#define IRQ0ENABLE_HIST_DONE_IRQ		(1 << 16)
#define IRQ0ENABLE_CCDC_LSC_DONE_IRQ		(1 << 17)
#define IRQ0ENABLE_CCDC_LSC_PREF_COMP_IRQ	(1 << 18)
#define IRQ0ENABLE_CCDC_LSC_PREF_ERR_IRQ	(1 << 19)
#define IRQ0ENABLE_PRV_DONE_IRQ			(1 << 20)
#define IRQ0ENABLE_RSZ_DONE_IRQ			(1 << 24)
#define IRQ0ENABLE_OVF_IRQ			(1 << 25)
#define IRQ0ENABLE_PING_IRQ			(1 << 26)
#define IRQ0ENABLE_PONG_IRQ			(1 << 27)
#define IRQ0ENABLE_MMU_ERR_IRQ			(1 << 28)
#define IRQ0ENABLE_OCP_ERR_IRQ			(1 << 29)
#define IRQ0ENABLE_SEC_ERR_IRQ			(1 << 30)
#define IRQ0ENABLE_HS_VS_IRQ			(1 << 31)

#define IRQ0STATUS_CSIA_IRQ			(1 << 0)
#define IRQ0STATUS_CSI2C_IRQ			(1 << 1)
#define IRQ0STATUS_CCP2_LCM_IRQ			(1 << 3)
#define IRQ0STATUS_CCP2_LC0_IRQ			(1 << 4)
#define IRQ0STATUS_CSIB_IRQ			(IRQ0STATUS_CCP2_LCM_IRQ | \
						IRQ0STATUS_CCP2_LC0_IRQ)

#define IRQ0STATUS_CSIB_LC1_IRQ			(1 << 5)
#define IRQ0STATUS_CSIB_LC2_IRQ			(1 << 6)
#define IRQ0STATUS_CSIB_LC3_IRQ			(1 << 7)
#define IRQ0STATUS_CCDC_VD0_IRQ			(1 << 8)
#define IRQ0STATUS_CCDC_VD1_IRQ			(1 << 9)
#define IRQ0STATUS_CCDC_VD2_IRQ			(1 << 10)
#define IRQ0STATUS_CCDC_ERR_IRQ			(1 << 11)
#define IRQ0STATUS_H3A_AF_DONE_IRQ		(1 << 12)
#define IRQ0STATUS_H3A_AWB_DONE_IRQ		(1 << 13)
#define IRQ0STATUS_HIST_DONE_IRQ		(1 << 16)
#define IRQ0STATUS_CCDC_LSC_DONE_IRQ		(1 << 17)
#define IRQ0STATUS_CCDC_LSC_PREF_COMP_IRQ	(1 << 18)
#define IRQ0STATUS_CCDC_LSC_PREF_ERR_IRQ	(1 << 19)
#define IRQ0STATUS_PRV_DONE_IRQ			(1 << 20)
#define IRQ0STATUS_RSZ_DONE_IRQ			(1 << 24)
#define IRQ0STATUS_OVF_IRQ			(1 << 25)
#define IRQ0STATUS_PING_IRQ			(1 << 26)
#define IRQ0STATUS_PONG_IRQ			(1 << 27)
#define IRQ0STATUS_MMU_ERR_IRQ			(1 << 28)
#define IRQ0STATUS_OCP_ERR_IRQ			(1 << 29)
#define IRQ0STATUS_SEC_ERR_IRQ			(1 << 30)
#define IRQ0STATUS_HS_VS_IRQ			(1 << 31)

#define TCTRL_GRESET_LEN			0

#define TCTRL_PSTRB_REPLAY_DELAY		0
#define TCTRL_PSTRB_REPLAY_COUNTER_SHIFT	25

#define ISPCTRL_PAR_SER_CLK_SEL_PARALLEL	0x0
#define ISPCTRL_PAR_SER_CLK_SEL_CSIA		0x1
#define ISPCTRL_PAR_SER_CLK_SEL_CSIB		0x2
#define ISPCTRL_PAR_SER_CLK_SEL_CSIC		0x3
#define ISPCTRL_PAR_SER_CLK_SEL_MASK		0x3

#define ISPCTRL_PAR_BRIDGE_SHIFT		2
#define ISPCTRL_PAR_BRIDGE_DISABLE		(0x0 << 2)
#define ISPCTRL_PAR_BRIDGE_LENDIAN		(0x2 << 2)
#define ISPCTRL_PAR_BRIDGE_BENDIAN		(0x3 << 2)
#define ISPCTRL_PAR_BRIDGE_MASK			(0x3 << 2)

#define ISPCTRL_PAR_CLK_POL_SHIFT		4
#define ISPCTRL_PAR_CLK_POL_INV			(1 << 4)
#define ISPCTRL_PING_PONG_EN			(1 << 5)
#define ISPCTRL_SHIFT_SHIFT			6
#define ISPCTRL_SHIFT_0				(0x0 << 6)
#define ISPCTRL_SHIFT_2				(0x1 << 6)
#define ISPCTRL_SHIFT_4				(0x2 << 6)
#define ISPCTRL_SHIFT_MASK			(0x3 << 6)

#define ISPCTRL_CCDC_CLK_EN			(1 << 8)
#define ISPCTRL_SCMP_CLK_EN			(1 << 9)
#define ISPCTRL_H3A_CLK_EN			(1 << 10)
#define ISPCTRL_HIST_CLK_EN			(1 << 11)
#define ISPCTRL_PREV_CLK_EN			(1 << 12)
#define ISPCTRL_RSZ_CLK_EN			(1 << 13)
#define ISPCTRL_SYNC_DETECT_SHIFT		14
#define ISPCTRL_SYNC_DETECT_HSFALL	(0x0 << ISPCTRL_SYNC_DETECT_SHIFT)
#define ISPCTRL_SYNC_DETECT_HSRISE	(0x1 << ISPCTRL_SYNC_DETECT_SHIFT)
#define ISPCTRL_SYNC_DETECT_VSFALL	(0x2 << ISPCTRL_SYNC_DETECT_SHIFT)
#define ISPCTRL_SYNC_DETECT_VSRISE	(0x3 << ISPCTRL_SYNC_DETECT_SHIFT)
#define ISPCTRL_SYNC_DETECT_MASK	(0x3 << ISPCTRL_SYNC_DETECT_SHIFT)

#define ISPCTRL_CCDC_RAM_EN		(1 << 16)
#define ISPCTRL_PREV_RAM_EN		(1 << 17)
#define ISPCTRL_SBL_RD_RAM_EN		(1 << 18)
#define ISPCTRL_SBL_WR1_RAM_EN		(1 << 19)
#define ISPCTRL_SBL_WR0_RAM_EN		(1 << 20)
#define ISPCTRL_SBL_AUTOIDLE		(1 << 21)
#define ISPCTRL_SBL_SHARED_WPORTC	(1 << 26)
#define ISPCTRL_SBL_SHARED_RPORTA	(1 << 27)
#define ISPCTRL_SBL_SHARED_RPORTB	(1 << 28)
#define ISPCTRL_JPEG_FLUSH		(1 << 30)
#define ISPCTRL_CCDC_FLUSH		(1 << 31)

#define ISPSECURE_SECUREMODE		0

#define ISPTCTRL_CTRL_DIV_LOW		0x0
#define ISPTCTRL_CTRL_DIV_HIGH		0x1
#define ISPTCTRL_CTRL_DIV_BYPASS	0x1F

#define ISPTCTRL_CTRL_DIVA_SHIFT	0
#define ISPTCTRL_CTRL_DIVA_MASK		(0x1F << ISPTCTRL_CTRL_DIVA_SHIFT)

#define ISPTCTRL_CTRL_DIVB_SHIFT	5
#define ISPTCTRL_CTRL_DIVB_MASK		(0x1F << ISPTCTRL_CTRL_DIVB_SHIFT)

#define ISPTCTRL_CTRL_DIVC_SHIFT	10
#define ISPTCTRL_CTRL_DIVC_NOCLOCK	(0x0 << 10)

#define ISPTCTRL_CTRL_SHUTEN		(1 << 21)
#define ISPTCTRL_CTRL_PSTRBEN		(1 << 22)
#define ISPTCTRL_CTRL_STRBEN		(1 << 23)
#define ISPTCTRL_CTRL_SHUTPOL		(1 << 24)
#define ISPTCTRL_CTRL_STRBPSTRBPOL	(1 << 26)

#define ISPTCTRL_CTRL_INSEL_SHIFT	27
#define ISPTCTRL_CTRL_INSEL_PARALLEL	(0x0 << 27)
#define ISPTCTRL_CTRL_INSEL_CSIA	(0x1 << 27)
#define ISPTCTRL_CTRL_INSEL_CSIB	(0x2 << 27)

#define ISPTCTRL_CTRL_GRESETEn		(1 << 29)
#define ISPTCTRL_CTRL_GRESETPOL		(1 << 30)
#define ISPTCTRL_CTRL_GRESETDIR		(1 << 31)

#define ISPTCTRL_FRAME_SHUT_SHIFT		0
#define ISPTCTRL_FRAME_PSTRB_SHIFT		6
#define ISPTCTRL_FRAME_STRB_SHIFT		12

#define ISPCCDC_PID_PREV_SHIFT			0
#define ISPCCDC_PID_CID_SHIFT			8
#define ISPCCDC_PID_TID_SHIFT			16

#define ISPCCDC_PCR_EN				1
#define ISPCCDC_PCR_BUSY			(1 << 1)

#define ISPCCDC_SYN_MODE_VDHDOUT		0x1
#define ISPCCDC_SYN_MODE_FLDOUT			(1 << 1)
#define ISPCCDC_SYN_MODE_VDPOL			(1 << 2)
#define ISPCCDC_SYN_MODE_HDPOL			(1 << 3)
#define ISPCCDC_SYN_MODE_FLDPOL			(1 << 4)
#define ISPCCDC_SYN_MODE_EXWEN			(1 << 5)
#define ISPCCDC_SYN_MODE_DATAPOL		(1 << 6)
#define ISPCCDC_SYN_MODE_FLDMODE		(1 << 7)
#define ISPCCDC_SYN_MODE_DATSIZ_MASK		(0x7 << 8)
#define ISPCCDC_SYN_MODE_DATSIZ_8_16		(0x0 << 8)
#define ISPCCDC_SYN_MODE_DATSIZ_12		(0x4 << 8)
#define ISPCCDC_SYN_MODE_DATSIZ_11		(0x5 << 8)
#define ISPCCDC_SYN_MODE_DATSIZ_10		(0x6 << 8)
#define ISPCCDC_SYN_MODE_DATSIZ_8		(0x7 << 8)
#define ISPCCDC_SYN_MODE_PACK8			(1 << 11)
#define ISPCCDC_SYN_MODE_INPMOD_MASK		(3 << 12)
#define ISPCCDC_SYN_MODE_INPMOD_RAW		(0 << 12)
#define ISPCCDC_SYN_MODE_INPMOD_YCBCR16		(1 << 12)
#define ISPCCDC_SYN_MODE_INPMOD_YCBCR8		(2 << 12)
#define ISPCCDC_SYN_MODE_LPF			(1 << 14)
#define ISPCCDC_SYN_MODE_FLDSTAT		(1 << 15)
#define ISPCCDC_SYN_MODE_VDHDEN			(1 << 16)
#define ISPCCDC_SYN_MODE_WEN			(1 << 17)
#define ISPCCDC_SYN_MODE_VP2SDR			(1 << 18)
#define ISPCCDC_SYN_MODE_SDR2RSZ		(1 << 19)

#define ISPCCDC_HD_VD_WID_VDW_SHIFT		0
#define ISPCCDC_HD_VD_WID_HDW_SHIFT		16

#define ISPCCDC_PIX_LINES_HLPRF_SHIFT		0
#define ISPCCDC_PIX_LINES_PPLN_SHIFT		16

#define ISPCCDC_HORZ_INFO_NPH_SHIFT		0
#define ISPCCDC_HORZ_INFO_NPH_MASK		0x00007fff
#define ISPCCDC_HORZ_INFO_SPH_SHIFT		16
#define ISPCCDC_HORZ_INFO_SPH_MASK		0x7fff0000

#define ISPCCDC_VERT_START_SLV1_SHIFT		0
#define ISPCCDC_VERT_START_SLV0_SHIFT		16
#define ISPCCDC_VERT_START_SLV0_MASK		0x7fff0000

#define ISPCCDC_VERT_LINES_NLV_SHIFT		0
#define ISPCCDC_VERT_LINES_NLV_MASK		0x00007fff

#define ISPCCDC_CULLING_CULV_SHIFT		0
#define ISPCCDC_CULLING_CULHODD_SHIFT		16
#define ISPCCDC_CULLING_CULHEVN_SHIFT		24

#define ISPCCDC_HSIZE_OFF_SHIFT			0

#define ISPCCDC_SDOFST_FIINV			(1 << 14)
#define ISPCCDC_SDOFST_FOFST_SHIFT		12
#define ISPCCDC_SDOFST_FOFST_MASK		(3 << 12)
#define ISPCCDC_SDOFST_LOFST3_SHIFT		0
#define ISPCCDC_SDOFST_LOFST2_SHIFT		3
#define ISPCCDC_SDOFST_LOFST1_SHIFT		6
#define ISPCCDC_SDOFST_LOFST0_SHIFT		9

#define ISPCCDC_CLAMP_OBGAIN_SHIFT		0
#define ISPCCDC_CLAMP_OBST_SHIFT		10
#define ISPCCDC_CLAMP_OBSLN_SHIFT		25
#define ISPCCDC_CLAMP_OBSLEN_SHIFT		28
#define ISPCCDC_CLAMP_CLAMPEN			(1 << 31)

#define ISPCCDC_COLPTN_R_Ye			0x0
#define ISPCCDC_COLPTN_Gr_Cy			0x1
#define ISPCCDC_COLPTN_Gb_G			0x2
#define ISPCCDC_COLPTN_B_Mg			0x3
#define ISPCCDC_COLPTN_CP0PLC0_SHIFT		0
#define ISPCCDC_COLPTN_CP0PLC1_SHIFT		2
#define ISPCCDC_COLPTN_CP0PLC2_SHIFT		4
#define ISPCCDC_COLPTN_CP0PLC3_SHIFT		6
#define ISPCCDC_COLPTN_CP1PLC0_SHIFT		8
#define ISPCCDC_COLPTN_CP1PLC1_SHIFT		10
#define ISPCCDC_COLPTN_CP1PLC2_SHIFT		12
#define ISPCCDC_COLPTN_CP1PLC3_SHIFT		14
#define ISPCCDC_COLPTN_CP2PLC0_SHIFT		16
#define ISPCCDC_COLPTN_CP2PLC1_SHIFT		18
#define ISPCCDC_COLPTN_CP2PLC2_SHIFT		20
#define ISPCCDC_COLPTN_CP2PLC3_SHIFT		22
#define ISPCCDC_COLPTN_CP3PLC0_SHIFT		24
#define ISPCCDC_COLPTN_CP3PLC1_SHIFT		26
#define ISPCCDC_COLPTN_CP3PLC2_SHIFT		28
#define ISPCCDC_COLPTN_CP3PLC3_SHIFT		30

#define ISPCCDC_BLKCMP_B_MG_SHIFT		0
#define ISPCCDC_BLKCMP_GB_G_SHIFT		8
#define ISPCCDC_BLKCMP_GR_CY_SHIFT		16
#define ISPCCDC_BLKCMP_R_YE_SHIFT		24

#define ISPCCDC_FPC_FPNUM_SHIFT			0
#define ISPCCDC_FPC_FPCEN			(1 << 15)
#define ISPCCDC_FPC_FPERR			(1 << 16)

#define ISPCCDC_VDINT_1_SHIFT			0
#define ISPCCDC_VDINT_1_MASK			0x00007fff
#define ISPCCDC_VDINT_0_SHIFT			16
#define ISPCCDC_VDINT_0_MASK			0x7fff0000

#define ISPCCDC_ALAW_GWDI_12_3			(0x3 << 0)
#define ISPCCDC_ALAW_GWDI_11_2			(0x4 << 0)
#define ISPCCDC_ALAW_GWDI_10_1			(0x5 << 0)
#define ISPCCDC_ALAW_GWDI_9_0			(0x6 << 0)
#define ISPCCDC_ALAW_CCDTBL			(1 << 3)

#define ISPCCDC_REC656IF_R656ON			1
#define ISPCCDC_REC656IF_ECCFVH			(1 << 1)

#define ISPCCDC_CFG_BW656			(1 << 5)
#define ISPCCDC_CFG_FIDMD_SHIFT			6
#define ISPCCDC_CFG_WENLOG			(1 << 8)
#define ISPCCDC_CFG_WENLOG_AND			(0 << 8)
#define ISPCCDC_CFG_WENLOG_OR			(1 << 8)
#define ISPCCDC_CFG_Y8POS			(1 << 11)
#define ISPCCDC_CFG_BSWD			(1 << 12)
#define ISPCCDC_CFG_MSBINVI			(1 << 13)
#define ISPCCDC_CFG_VDLC			(1 << 15)

#define ISPCCDC_FMTCFG_FMTEN			0x1
#define ISPCCDC_FMTCFG_LNALT			(1 << 1)
#define ISPCCDC_FMTCFG_LNUM_SHIFT		2
#define ISPCCDC_FMTCFG_PLEN_ODD_SHIFT		4
#define ISPCCDC_FMTCFG_PLEN_EVEN_SHIFT		8
#define ISPCCDC_FMTCFG_VPIN_MASK		0x00007000
#define ISPCCDC_FMTCFG_VPIN_12_3		(0x3 << 12)
#define ISPCCDC_FMTCFG_VPIN_11_2		(0x4 << 12)
#define ISPCCDC_FMTCFG_VPIN_10_1		(0x5 << 12)
#define ISPCCDC_FMTCFG_VPIN_9_0			(0x6 << 12)
#define ISPCCDC_FMTCFG_VPEN			(1 << 15)

#define ISPCCDC_FMTCFG_VPIF_FRQ_MASK		0x003f0000
#define ISPCCDC_FMTCFG_VPIF_FRQ_SHIFT		16
#define ISPCCDC_FMTCFG_VPIF_FRQ_BY2		(0x0 << 16)
#define ISPCCDC_FMTCFG_VPIF_FRQ_BY3		(0x1 << 16)
#define ISPCCDC_FMTCFG_VPIF_FRQ_BY4		(0x2 << 16)
#define ISPCCDC_FMTCFG_VPIF_FRQ_BY5		(0x3 << 16)
#define ISPCCDC_FMTCFG_VPIF_FRQ_BY6		(0x4 << 16)

#define ISPCCDC_FMT_HORZ_FMTLNH_SHIFT		0
#define ISPCCDC_FMT_HORZ_FMTSPH_SHIFT		16

#define ISPCCDC_FMT_VERT_FMTLNV_SHIFT		0
#define ISPCCDC_FMT_VERT_FMTSLV_SHIFT		16

#define ISPCCDC_FMT_HORZ_FMTSPH_MASK		0x1fff0000
#define ISPCCDC_FMT_HORZ_FMTLNH_MASK		0x00001fff

#define ISPCCDC_FMT_VERT_FMTSLV_MASK		0x1fff0000
#define ISPCCDC_FMT_VERT_FMTLNV_MASK		0x00001fff

#define ISPCCDC_VP_OUT_HORZ_ST_SHIFT		0
#define ISPCCDC_VP_OUT_HORZ_NUM_SHIFT		4
#define ISPCCDC_VP_OUT_VERT_NUM_SHIFT		17

#define ISPRSZ_PID_PREV_SHIFT			0
#define ISPRSZ_PID_CID_SHIFT			8
#define ISPRSZ_PID_TID_SHIFT			16

#define ISPRSZ_PCR_ENABLE			(1 << 0)
#define ISPRSZ_PCR_BUSY				(1 << 1)
#define ISPRSZ_PCR_ONESHOT			(1 << 2)

#define ISPRSZ_CNT_HRSZ_SHIFT			0
#define ISPRSZ_CNT_HRSZ_MASK			\
	(0x3FF << ISPRSZ_CNT_HRSZ_SHIFT)
#define ISPRSZ_CNT_VRSZ_SHIFT			10
#define ISPRSZ_CNT_VRSZ_MASK			\
	(0x3FF << ISPRSZ_CNT_VRSZ_SHIFT)
#define ISPRSZ_CNT_HSTPH_SHIFT			20
#define ISPRSZ_CNT_HSTPH_MASK			(0x7 << ISPRSZ_CNT_HSTPH_SHIFT)
#define ISPRSZ_CNT_VSTPH_SHIFT			23
#define ISPRSZ_CNT_VSTPH_MASK			(0x7 << ISPRSZ_CNT_VSTPH_SHIFT)
#define ISPRSZ_CNT_YCPOS			(1 << 26)
#define ISPRSZ_CNT_INPTYP			(1 << 27)
#define ISPRSZ_CNT_INPSRC			(1 << 28)
#define ISPRSZ_CNT_CBILIN			(1 << 29)

#define ISPRSZ_OUT_SIZE_HORZ_SHIFT		0
#define ISPRSZ_OUT_SIZE_HORZ_MASK		\
	(0xFFF << ISPRSZ_OUT_SIZE_HORZ_SHIFT)
#define ISPRSZ_OUT_SIZE_VERT_SHIFT		16
#define ISPRSZ_OUT_SIZE_VERT_MASK		\
	(0xFFF << ISPRSZ_OUT_SIZE_VERT_SHIFT)

#define ISPRSZ_IN_START_HORZ_ST_SHIFT		0
#define ISPRSZ_IN_START_HORZ_ST_MASK		\
	(0x1FFF << ISPRSZ_IN_START_HORZ_ST_SHIFT)
#define ISPRSZ_IN_START_VERT_ST_SHIFT		16
#define ISPRSZ_IN_START_VERT_ST_MASK		\
	(0x1FFF << ISPRSZ_IN_START_VERT_ST_SHIFT)

#define ISPRSZ_IN_SIZE_HORZ_SHIFT		0
#define ISPRSZ_IN_SIZE_HORZ_MASK		\
	(0x1FFF << ISPRSZ_IN_SIZE_HORZ_SHIFT)
#define ISPRSZ_IN_SIZE_VERT_SHIFT		16
#define ISPRSZ_IN_SIZE_VERT_MASK		\
	(0x1FFF << ISPRSZ_IN_SIZE_VERT_SHIFT)

#define ISPRSZ_SDR_INADD_ADDR_SHIFT		0
#define ISPRSZ_SDR_INADD_ADDR_MASK		0xFFFFFFFF

#define ISPRSZ_SDR_INOFF_OFFSET_SHIFT		0
#define ISPRSZ_SDR_INOFF_OFFSET_MASK		\
	(0xFFFF << ISPRSZ_SDR_INOFF_OFFSET_SHIFT)

#define ISPRSZ_SDR_OUTADD_ADDR_SHIFT		0
#define ISPRSZ_SDR_OUTADD_ADDR_MASK		0xFFFFFFFF


#define ISPRSZ_SDR_OUTOFF_OFFSET_SHIFT		0
#define ISPRSZ_SDR_OUTOFF_OFFSET_MASK		\
	(0xFFFF << ISPRSZ_SDR_OUTOFF_OFFSET_SHIFT)

#define ISPRSZ_HFILT_COEF0_SHIFT		0
#define ISPRSZ_HFILT_COEF0_MASK			\
	(0x3FF << ISPRSZ_HFILT_COEF0_SHIFT)
#define ISPRSZ_HFILT_COEF1_SHIFT		16
#define ISPRSZ_HFILT_COEF1_MASK			\
	(0x3FF << ISPRSZ_HFILT_COEF1_SHIFT)

#define ISPRSZ_HFILT32_COEF2_SHIFT		0
#define ISPRSZ_HFILT32_COEF2_MASK		0x3FF
#define ISPRSZ_HFILT32_COEF3_SHIFT		16
#define ISPRSZ_HFILT32_COEF3_MASK		0x3FF0000

#define ISPRSZ_HFILT54_COEF4_SHIFT		0
#define ISPRSZ_HFILT54_COEF4_MASK		0x3FF
#define ISPRSZ_HFILT54_COEF5_SHIFT		16
#define ISPRSZ_HFILT54_COEF5_MASK		0x3FF0000

#define ISPRSZ_HFILT76_COEFF6_SHIFT		0
#define ISPRSZ_HFILT76_COEFF6_MASK		0x3FF
#define ISPRSZ_HFILT76_COEFF7_SHIFT		16
#define ISPRSZ_HFILT76_COEFF7_MASK		0x3FF0000

#define ISPRSZ_HFILT98_COEFF8_SHIFT		0
#define ISPRSZ_HFILT98_COEFF8_MASK		0x3FF
#define ISPRSZ_HFILT98_COEFF9_SHIFT		16
#define ISPRSZ_HFILT98_COEFF9_MASK		0x3FF0000

#define ISPRSZ_HFILT1110_COEF10_SHIFT		0
#define ISPRSZ_HFILT1110_COEF10_MASK		0x3FF
#define ISPRSZ_HFILT1110_COEF11_SHIFT		16
#define ISPRSZ_HFILT1110_COEF11_MASK		0x3FF0000

#define ISPRSZ_HFILT1312_COEFF12_SHIFT		0
#define ISPRSZ_HFILT1312_COEFF12_MASK		0x3FF
#define ISPRSZ_HFILT1312_COEFF13_SHIFT		16
#define ISPRSZ_HFILT1312_COEFF13_MASK		0x3FF0000

#define ISPRSZ_HFILT1514_COEFF14_SHIFT		0
#define ISPRSZ_HFILT1514_COEFF14_MASK		0x3FF
#define ISPRSZ_HFILT1514_COEFF15_SHIFT		16
#define ISPRSZ_HFILT1514_COEFF15_MASK		0x3FF0000

#define ISPRSZ_HFILT1716_COEF16_SHIFT		0
#define ISPRSZ_HFILT1716_COEF16_MASK		0x3FF
#define ISPRSZ_HFILT1716_COEF17_SHIFT		16
#define ISPRSZ_HFILT1716_COEF17_MASK		0x3FF0000

#define ISPRSZ_HFILT1918_COEF18_SHIFT		0
#define ISPRSZ_HFILT1918_COEF18_MASK		0x3FF
#define ISPRSZ_HFILT1918_COEF19_SHIFT		16
#define ISPRSZ_HFILT1918_COEF19_MASK		0x3FF0000

#define ISPRSZ_HFILT2120_COEF20_SHIFT		0
#define ISPRSZ_HFILT2120_COEF20_MASK		0x3FF
#define ISPRSZ_HFILT2120_COEF21_SHIFT		16
#define ISPRSZ_HFILT2120_COEF21_MASK		0x3FF0000

#define ISPRSZ_HFILT2322_COEF22_SHIFT		0
#define ISPRSZ_HFILT2322_COEF22_MASK		0x3FF
#define ISPRSZ_HFILT2322_COEF23_SHIFT		16
#define ISPRSZ_HFILT2322_COEF23_MASK		0x3FF0000

#define ISPRSZ_HFILT2524_COEF24_SHIFT		0
#define ISPRSZ_HFILT2524_COEF24_MASK		0x3FF
#define ISPRSZ_HFILT2524_COEF25_SHIFT		16
#define ISPRSZ_HFILT2524_COEF25_MASK		0x3FF0000

#define ISPRSZ_HFILT2726_COEF26_SHIFT		0
#define ISPRSZ_HFILT2726_COEF26_MASK		0x3FF
#define ISPRSZ_HFILT2726_COEF27_SHIFT		16
#define ISPRSZ_HFILT2726_COEF27_MASK		0x3FF0000

#define ISPRSZ_HFILT2928_COEF28_SHIFT		0
#define ISPRSZ_HFILT2928_COEF28_MASK		0x3FF
#define ISPRSZ_HFILT2928_COEF29_SHIFT		16
#define ISPRSZ_HFILT2928_COEF29_MASK		0x3FF0000

#define ISPRSZ_HFILT3130_COEF30_SHIFT		0
#define ISPRSZ_HFILT3130_COEF30_MASK		0x3FF
#define ISPRSZ_HFILT3130_COEF31_SHIFT		16
#define ISPRSZ_HFILT3130_COEF31_MASK		0x3FF0000

#define ISPRSZ_VFILT_COEF0_SHIFT		0
#define ISPRSZ_VFILT_COEF0_MASK			\
	(0x3FF << ISPRSZ_VFILT_COEF0_SHIFT)
#define ISPRSZ_VFILT_COEF1_SHIFT		16
#define ISPRSZ_VFILT_COEF1_MASK			\
	(0x3FF << ISPRSZ_VFILT_COEF1_SHIFT)

#define ISPRSZ_VFILT10_COEF0_SHIFT		0
#define ISPRSZ_VFILT10_COEF0_MASK		0x3FF
#define ISPRSZ_VFILT10_COEF1_SHIFT		16
#define ISPRSZ_VFILT10_COEF1_MASK		0x3FF0000

#define ISPRSZ_VFILT32_COEF2_SHIFT		0
#define ISPRSZ_VFILT32_COEF2_MASK		0x3FF
#define ISPRSZ_VFILT32_COEF3_SHIFT		16
#define ISPRSZ_VFILT32_COEF3_MASK		0x3FF0000

#define ISPRSZ_VFILT54_COEF4_SHIFT		0
#define ISPRSZ_VFILT54_COEF4_MASK		0x3FF
#define ISPRSZ_VFILT54_COEF5_SHIFT		16
#define ISPRSZ_VFILT54_COEF5_MASK		0x3FF0000

#define ISPRSZ_VFILT76_COEFF6_SHIFT		0
#define ISPRSZ_VFILT76_COEFF6_MASK		0x3FF
#define ISPRSZ_VFILT76_COEFF7_SHIFT		16
#define ISPRSZ_VFILT76_COEFF7_MASK		0x3FF0000

#define ISPRSZ_VFILT98_COEFF8_SHIFT		0
#define ISPRSZ_VFILT98_COEFF8_MASK		0x3FF
#define ISPRSZ_VFILT98_COEFF9_SHIFT		16
#define ISPRSZ_VFILT98_COEFF9_MASK		0x3FF0000

#define ISPRSZ_VFILT1110_COEF10_SHIFT		0
#define ISPRSZ_VFILT1110_COEF10_MASK		0x3FF
#define ISPRSZ_VFILT1110_COEF11_SHIFT		16
#define ISPRSZ_VFILT1110_COEF11_MASK		0x3FF0000

#define ISPRSZ_VFILT1312_COEFF12_SHIFT		0
#define ISPRSZ_VFILT1312_COEFF12_MASK		0x3FF
#define ISPRSZ_VFILT1312_COEFF13_SHIFT		16
#define ISPRSZ_VFILT1312_COEFF13_MASK		0x3FF0000

#define ISPRSZ_VFILT1514_COEFF14_SHIFT		0
#define ISPRSZ_VFILT1514_COEFF14_MASK		0x3FF
#define ISPRSZ_VFILT1514_COEFF15_SHIFT		16
#define ISPRSZ_VFILT1514_COEFF15_MASK		0x3FF0000

#define ISPRSZ_VFILT1716_COEF16_SHIFT		0
#define ISPRSZ_VFILT1716_COEF16_MASK		0x3FF
#define ISPRSZ_VFILT1716_COEF17_SHIFT		16
#define ISPRSZ_VFILT1716_COEF17_MASK		0x3FF0000

#define ISPRSZ_VFILT1918_COEF18_SHIFT		0
#define ISPRSZ_VFILT1918_COEF18_MASK		0x3FF
#define ISPRSZ_VFILT1918_COEF19_SHIFT		16
#define ISPRSZ_VFILT1918_COEF19_MASK		0x3FF0000

#define ISPRSZ_VFILT2120_COEF20_SHIFT		0
#define ISPRSZ_VFILT2120_COEF20_MASK		0x3FF
#define ISPRSZ_VFILT2120_COEF21_SHIFT		16
#define ISPRSZ_VFILT2120_COEF21_MASK		0x3FF0000

#define ISPRSZ_VFILT2322_COEF22_SHIFT		0
#define ISPRSZ_VFILT2322_COEF22_MASK		0x3FF
#define ISPRSZ_VFILT2322_COEF23_SHIFT		16
#define ISPRSZ_VFILT2322_COEF23_MASK		0x3FF0000

#define ISPRSZ_VFILT2524_COEF24_SHIFT		0
#define ISPRSZ_VFILT2524_COEF24_MASK		0x3FF
#define ISPRSZ_VFILT2524_COEF25_SHIFT		16
#define ISPRSZ_VFILT2524_COEF25_MASK		0x3FF0000

#define ISPRSZ_VFILT2726_COEF26_SHIFT		0
#define ISPRSZ_VFILT2726_COEF26_MASK		0x3FF
#define ISPRSZ_VFILT2726_COEF27_SHIFT		16
#define ISPRSZ_VFILT2726_COEF27_MASK		0x3FF0000

#define ISPRSZ_VFILT2928_COEF28_SHIFT		0
#define ISPRSZ_VFILT2928_COEF28_MASK		0x3FF
#define ISPRSZ_VFILT2928_COEF29_SHIFT		16
#define ISPRSZ_VFILT2928_COEF29_MASK		0x3FF0000

#define ISPRSZ_VFILT3130_COEF30_SHIFT		0
#define ISPRSZ_VFILT3130_COEF30_MASK		0x3FF
#define ISPRSZ_VFILT3130_COEF31_SHIFT		16
#define ISPRSZ_VFILT3130_COEF31_MASK		0x3FF0000

#define ISPRSZ_YENH_CORE_SHIFT			0
#define ISPRSZ_YENH_CORE_MASK			\
	(0xFF << ISPRSZ_YENH_CORE_SHIFT)
#define ISPRSZ_YENH_SLOP_SHIFT			8
#define ISPRSZ_YENH_SLOP_MASK			\
	(0xF << ISPRSZ_YENH_SLOP_SHIFT)
#define ISPRSZ_YENH_GAIN_SHIFT			12
#define ISPRSZ_YENH_GAIN_MASK			\
	(0xF << ISPRSZ_YENH_GAIN_SHIFT)
#define ISPRSZ_YENH_ALGO_SHIFT			16
#define ISPRSZ_YENH_ALGO_MASK			\
	(0x3 << ISPRSZ_YENH_ALGO_SHIFT)

#define ISPH3A_PCR_AEW_ALAW_EN_SHIFT		1
#define ISPH3A_PCR_AF_MED_TH_SHIFT		3
#define ISPH3A_PCR_AF_RGBPOS_SHIFT		11
#define ISPH3A_PCR_AEW_AVE2LMT_SHIFT		22
#define ISPH3A_PCR_AEW_AVE2LMT_MASK		0xFFC00000
#define ISPH3A_PCR_BUSYAF			(1 << 15)
#define ISPH3A_PCR_BUSYAEAWB			(1 << 18)

#define ISPH3A_AEWWIN1_WINHC_SHIFT		0
#define ISPH3A_AEWWIN1_WINHC_MASK		0x3F
#define ISPH3A_AEWWIN1_WINVC_SHIFT		6
#define ISPH3A_AEWWIN1_WINVC_MASK		0x1FC0
#define ISPH3A_AEWWIN1_WINW_SHIFT		13
#define ISPH3A_AEWWIN1_WINW_MASK		0xFE000
#define ISPH3A_AEWWIN1_WINH_SHIFT		24
#define ISPH3A_AEWWIN1_WINH_MASK		0x7F000000

#define ISPH3A_AEWINSTART_WINSH_SHIFT		0
#define ISPH3A_AEWINSTART_WINSH_MASK		0x0FFF
#define ISPH3A_AEWINSTART_WINSV_SHIFT		16
#define ISPH3A_AEWINSTART_WINSV_MASK		0x0FFF0000

#define ISPH3A_AEWINBLK_WINH_SHIFT		0
#define ISPH3A_AEWINBLK_WINH_MASK		0x7F
#define ISPH3A_AEWINBLK_WINSV_SHIFT		16
#define ISPH3A_AEWINBLK_WINSV_MASK		0x0FFF0000

#define ISPH3A_AEWSUBWIN_AEWINCH_SHIFT		0
#define ISPH3A_AEWSUBWIN_AEWINCH_MASK		0x0F
#define ISPH3A_AEWSUBWIN_AEWINCV_SHIFT		8
#define ISPH3A_AEWSUBWIN_AEWINCV_MASK		0x0F00

#define ISPHIST_PCR_ENABLE_SHIFT	0
#define ISPHIST_PCR_ENABLE_MASK		0x01
#define ISPHIST_PCR_ENABLE		(1 << ISPHIST_PCR_ENABLE_SHIFT)
#define ISPHIST_PCR_BUSY		0x02

#define ISPHIST_CNT_DATASIZE_SHIFT	8
#define ISPHIST_CNT_DATASIZE_MASK	0x0100
#define ISPHIST_CNT_CLEAR_SHIFT		7
#define ISPHIST_CNT_CLEAR_MASK		0x080
#define ISPHIST_CNT_CLEAR		(1 << ISPHIST_CNT_CLEAR_SHIFT)
#define ISPHIST_CNT_CFA_SHIFT		6
#define ISPHIST_CNT_CFA_MASK		0x040
#define ISPHIST_CNT_BINS_SHIFT		4
#define ISPHIST_CNT_BINS_MASK		0x030
#define ISPHIST_CNT_SOURCE_SHIFT	3
#define ISPHIST_CNT_SOURCE_MASK		0x08
#define ISPHIST_CNT_SHIFT_SHIFT		0
#define ISPHIST_CNT_SHIFT_MASK		0x07

#define ISPHIST_WB_GAIN_WG00_SHIFT	24
#define ISPHIST_WB_GAIN_WG00_MASK	0xFF000000
#define ISPHIST_WB_GAIN_WG01_SHIFT	16
#define ISPHIST_WB_GAIN_WG01_MASK	0xFF0000
#define ISPHIST_WB_GAIN_WG02_SHIFT	8
#define ISPHIST_WB_GAIN_WG02_MASK	0xFF00
#define ISPHIST_WB_GAIN_WG03_SHIFT	0
#define ISPHIST_WB_GAIN_WG03_MASK	0xFF

#define ISPHIST_REG_START_END_MASK		0x3FFF
#define ISPHIST_REG_START_SHIFT			16
#define ISPHIST_REG_END_SHIFT			0
#define ISPHIST_REG_START_MASK			(ISPHIST_REG_START_END_MASK << \
						 ISPHIST_REG_START_SHIFT)
#define ISPHIST_REG_END_MASK			(ISPHIST_REG_START_END_MASK << \
						 ISPHIST_REG_END_SHIFT)

#define ISPHIST_REG_MASK			(ISPHIST_REG_START_MASK | \
						 ISPHIST_REG_END_MASK)

#define ISPHIST_ADDR_SHIFT			0
#define ISPHIST_ADDR_MASK			0x3FF

#define ISPHIST_DATA_SHIFT			0
#define ISPHIST_DATA_MASK			0xFFFFF

#define ISPHIST_RADD_SHIFT			0
#define ISPHIST_RADD_MASK			0xFFFFFFFF

#define ISPHIST_RADD_OFF_SHIFT			0
#define ISPHIST_RADD_OFF_MASK			0xFFFF

#define ISPHIST_HV_INFO_HSIZE_SHIFT		16
#define ISPHIST_HV_INFO_HSIZE_MASK		0x3FFF0000
#define ISPHIST_HV_INFO_VSIZE_SHIFT		0
#define ISPHIST_HV_INFO_VSIZE_MASK		0x3FFF

#define ISPHIST_HV_INFO_MASK			0x3FFF3FFF

#define ISPCCDC_LSC_ENABLE			1
#define ISPCCDC_LSC_BUSY			(1 << 7)
#define ISPCCDC_LSC_GAIN_MODE_N_MASK		0x700
#define ISPCCDC_LSC_GAIN_MODE_N_SHIFT		8
#define ISPCCDC_LSC_GAIN_MODE_M_MASK		0x3800
#define ISPCCDC_LSC_GAIN_MODE_M_SHIFT		12
#define ISPCCDC_LSC_GAIN_FORMAT_MASK		0xE
#define ISPCCDC_LSC_GAIN_FORMAT_SHIFT		1
#define ISPCCDC_LSC_AFTER_REFORMATTER_MASK	(1<<6)

#define ISPCCDC_LSC_INITIAL_X_MASK		0x3F
#define ISPCCDC_LSC_INITIAL_X_SHIFT		0
#define ISPCCDC_LSC_INITIAL_Y_MASK		0x3F0000
#define ISPCCDC_LSC_INITIAL_Y_SHIFT		16

/* -----------------------------------------------------------------------------
 * CSI2 receiver registers (ES2.0)
 */

#define ISPCSI2_REVISION			(0x000)
#define ISPCSI2_SYSCONFIG			(0x010)
#define ISPCSI2_SYSCONFIG_MSTANDBY_MODE_SHIFT	12
#define ISPCSI2_SYSCONFIG_MSTANDBY_MODE_MASK	\
	(0x3 << ISPCSI2_SYSCONFIG_MSTANDBY_MODE_SHIFT)
#define ISPCSI2_SYSCONFIG_MSTANDBY_MODE_FORCE	\
	(0x0 << ISPCSI2_SYSCONFIG_MSTANDBY_MODE_SHIFT)
#define ISPCSI2_SYSCONFIG_MSTANDBY_MODE_NO	\
	(0x1 << ISPCSI2_SYSCONFIG_MSTANDBY_MODE_SHIFT)
#define ISPCSI2_SYSCONFIG_MSTANDBY_MODE_SMART	\
	(0x2 << ISPCSI2_SYSCONFIG_MSTANDBY_MODE_SHIFT)
#define ISPCSI2_SYSCONFIG_SOFT_RESET		(1 << 1)
#define ISPCSI2_SYSCONFIG_AUTO_IDLE		(1 << 0)

#define ISPCSI2_SYSSTATUS			(0x014)
#define ISPCSI2_SYSSTATUS_RESET_DONE		(1 << 0)

#define ISPCSI2_IRQSTATUS			(0x018)
#define ISPCSI2_IRQSTATUS_OCP_ERR_IRQ		(1 << 14)
#define ISPCSI2_IRQSTATUS_SHORT_PACKET_IRQ	(1 << 13)
#define ISPCSI2_IRQSTATUS_ECC_CORRECTION_IRQ	(1 << 12)
#define ISPCSI2_IRQSTATUS_ECC_NO_CORRECTION_IRQ	(1 << 11)
#define ISPCSI2_IRQSTATUS_COMPLEXIO2_ERR_IRQ	(1 << 10)
#define ISPCSI2_IRQSTATUS_COMPLEXIO1_ERR_IRQ	(1 << 9)
#define ISPCSI2_IRQSTATUS_FIFO_OVF_IRQ		(1 << 8)
#define ISPCSI2_IRQSTATUS_CONTEXT(n)		(1 << (n))

#define ISPCSI2_IRQENABLE			(0x01c)
#define ISPCSI2_CTRL				(0x040)
#define ISPCSI2_CTRL_VP_CLK_EN			(1 << 15)
#define ISPCSI2_CTRL_VP_ONLY_EN			(1 << 11)
#define ISPCSI2_CTRL_VP_OUT_CTRL_SHIFT		8
#define ISPCSI2_CTRL_VP_OUT_CTRL_MASK		\
	(3 << ISPCSI2_CTRL_VP_OUT_CTRL_SHIFT)
#define ISPCSI2_CTRL_DBG_EN			(1 << 7)
#define ISPCSI2_CTRL_BURST_SIZE_SHIFT		5
#define ISPCSI2_CTRL_BURST_SIZE_MASK		\
	(3 << ISPCSI2_CTRL_BURST_SIZE_SHIFT)
#define ISPCSI2_CTRL_FRAME			(1 << 3)
#define ISPCSI2_CTRL_ECC_EN			(1 << 2)
#define ISPCSI2_CTRL_SECURE			(1 << 1)
#define ISPCSI2_CTRL_IF_EN			(1 << 0)

#define ISPCSI2_DBG_H				(0x044)
#define ISPCSI2_GNQ				(0x048)
#define ISPCSI2_PHY_CFG				(0x050)
#define ISPCSI2_PHY_CFG_RESET_CTRL		(1 << 30)
#define ISPCSI2_PHY_CFG_RESET_DONE		(1 << 29)
#define ISPCSI2_PHY_CFG_PWR_CMD_SHIFT		27
#define ISPCSI2_PHY_CFG_PWR_CMD_MASK		\
	(0x3 << ISPCSI2_PHY_CFG_PWR_CMD_SHIFT)
#define ISPCSI2_PHY_CFG_PWR_CMD_OFF		\
	(0x0 << ISPCSI2_PHY_CFG_PWR_CMD_SHIFT)
#define ISPCSI2_PHY_CFG_PWR_CMD_ON		\
	(0x1 << ISPCSI2_PHY_CFG_PWR_CMD_SHIFT)
#define ISPCSI2_PHY_CFG_PWR_CMD_ULPW		\
	(0x2 << ISPCSI2_PHY_CFG_PWR_CMD_SHIFT)
#define ISPCSI2_PHY_CFG_PWR_STATUS_SHIFT	25
#define ISPCSI2_PHY_CFG_PWR_STATUS_MASK		\
	(0x3 << ISPCSI2_PHY_CFG_PWR_STATUS_SHIFT)
#define ISPCSI2_PHY_CFG_PWR_STATUS_OFF		\
	(0x0 << ISPCSI2_PHY_CFG_PWR_STATUS_SHIFT)
#define ISPCSI2_PHY_CFG_PWR_STATUS_ON		\
	(0x1 << ISPCSI2_PHY_CFG_PWR_STATUS_SHIFT)
#define ISPCSI2_PHY_CFG_PWR_STATUS_ULPW		\
	(0x2 << ISPCSI2_PHY_CFG_PWR_STATUS_SHIFT)
#define ISPCSI2_PHY_CFG_PWR_AUTO		(1 << 24)

#define ISPCSI2_PHY_CFG_DATA_POL_SHIFT(n)	(3 + ((n) * 4))
#define ISPCSI2_PHY_CFG_DATA_POL_MASK(n)	\
	(0x1 << ISPCSI2_PHY_CFG_DATA_POL_SHIFT(n))
#define ISPCSI2_PHY_CFG_DATA_POL_PN(n)		\
	(0x0 << ISPCSI2_PHY_CFG_DATA_POL_SHIFT(n))
#define ISPCSI2_PHY_CFG_DATA_POL_NP(n)		\
	(0x1 << ISPCSI2_PHY_CFG_DATA_POL_SHIFT(n))

#define ISPCSI2_PHY_CFG_DATA_POSITION_SHIFT(n)	((n) * 4)
#define ISPCSI2_PHY_CFG_DATA_POSITION_MASK(n)	\
	(0x7 << ISPCSI2_PHY_CFG_DATA_POSITION_SHIFT(n))
#define ISPCSI2_PHY_CFG_DATA_POSITION_NC(n)	\
	(0x0 << ISPCSI2_PHY_CFG_DATA_POSITION_SHIFT(n))
#define ISPCSI2_PHY_CFG_DATA_POSITION_1(n)	\
	(0x1 << ISPCSI2_PHY_CFG_DATA_POSITION_SHIFT(n))
#define ISPCSI2_PHY_CFG_DATA_POSITION_2(n)	\
	(0x2 << ISPCSI2_PHY_CFG_DATA_POSITION_SHIFT(n))
#define ISPCSI2_PHY_CFG_DATA_POSITION_3(n)	\
	(0x3 << ISPCSI2_PHY_CFG_DATA_POSITION_SHIFT(n))
#define ISPCSI2_PHY_CFG_DATA_POSITION_4(n)	\
	(0x4 << ISPCSI2_PHY_CFG_DATA_POSITION_SHIFT(n))
#define ISPCSI2_PHY_CFG_DATA_POSITION_5(n)	\
	(0x5 << ISPCSI2_PHY_CFG_DATA_POSITION_SHIFT(n))

#define ISPCSI2_PHY_CFG_CLOCK_POL_SHIFT		3
#define ISPCSI2_PHY_CFG_CLOCK_POL_MASK		\
	(0x1 << ISPCSI2_PHY_CFG_CLOCK_POL_SHIFT)
#define ISPCSI2_PHY_CFG_CLOCK_POL_PN		\
	(0x0 << ISPCSI2_PHY_CFG_CLOCK_POL_SHIFT)
#define ISPCSI2_PHY_CFG_CLOCK_POL_NP		\
	(0x1 << ISPCSI2_PHY_CFG_CLOCK_POL_SHIFT)

#define ISPCSI2_PHY_CFG_CLOCK_POSITION_SHIFT	0
#define ISPCSI2_PHY_CFG_CLOCK_POSITION_MASK	\
	(0x7 << ISPCSI2_PHY_CFG_CLOCK_POSITION_SHIFT)
#define ISPCSI2_PHY_CFG_CLOCK_POSITION_1	\
	(0x1 << ISPCSI2_PHY_CFG_CLOCK_POSITION_SHIFT)
#define ISPCSI2_PHY_CFG_CLOCK_POSITION_2	\
	(0x2 << ISPCSI2_PHY_CFG_CLOCK_POSITION_SHIFT)
#define ISPCSI2_PHY_CFG_CLOCK_POSITION_3	\
	(0x3 << ISPCSI2_PHY_CFG_CLOCK_POSITION_SHIFT)
#define ISPCSI2_PHY_CFG_CLOCK_POSITION_4	\
	(0x4 << ISPCSI2_PHY_CFG_CLOCK_POSITION_SHIFT)
#define ISPCSI2_PHY_CFG_CLOCK_POSITION_5	\
	(0x5 << ISPCSI2_PHY_CFG_CLOCK_POSITION_SHIFT)

#define ISPCSI2_PHY_IRQSTATUS			(0x054)
#define ISPCSI2_PHY_IRQSTATUS_STATEALLULPMEXIT	(1 << 26)
#define ISPCSI2_PHY_IRQSTATUS_STATEALLULPMENTER	(1 << 25)
#define ISPCSI2_PHY_IRQSTATUS_STATEULPM5	(1 << 24)
#define ISPCSI2_PHY_IRQSTATUS_STATEULPM4	(1 << 23)
#define ISPCSI2_PHY_IRQSTATUS_STATEULPM3	(1 << 22)
#define ISPCSI2_PHY_IRQSTATUS_STATEULPM2	(1 << 21)
#define ISPCSI2_PHY_IRQSTATUS_STATEULPM1	(1 << 20)
#define ISPCSI2_PHY_IRQSTATUS_ERRCONTROL5	(1 << 19)
#define ISPCSI2_PHY_IRQSTATUS_ERRCONTROL4	(1 << 18)
#define ISPCSI2_PHY_IRQSTATUS_ERRCONTROL3	(1 << 17)
#define ISPCSI2_PHY_IRQSTATUS_ERRCONTROL2	(1 << 16)
#define ISPCSI2_PHY_IRQSTATUS_ERRCONTROL1	(1 << 15)
#define ISPCSI2_PHY_IRQSTATUS_ERRESC5		(1 << 14)
#define ISPCSI2_PHY_IRQSTATUS_ERRESC4		(1 << 13)
#define ISPCSI2_PHY_IRQSTATUS_ERRESC3		(1 << 12)
#define ISPCSI2_PHY_IRQSTATUS_ERRESC2		(1 << 11)
#define ISPCSI2_PHY_IRQSTATUS_ERRESC1		(1 << 10)
#define ISPCSI2_PHY_IRQSTATUS_ERRSOTSYNCHS5	(1 << 9)
#define ISPCSI2_PHY_IRQSTATUS_ERRSOTSYNCHS4	(1 << 8)
#define ISPCSI2_PHY_IRQSTATUS_ERRSOTSYNCHS3	(1 << 7)
#define ISPCSI2_PHY_IRQSTATUS_ERRSOTSYNCHS2	(1 << 6)
#define ISPCSI2_PHY_IRQSTATUS_ERRSOTSYNCHS1	(1 << 5)
#define ISPCSI2_PHY_IRQSTATUS_ERRSOTHS5		(1 << 4)
#define ISPCSI2_PHY_IRQSTATUS_ERRSOTHS4		(1 << 3)
#define ISPCSI2_PHY_IRQSTATUS_ERRSOTHS3		(1 << 2)
#define ISPCSI2_PHY_IRQSTATUS_ERRSOTHS2		(1 << 1)
#define ISPCSI2_PHY_IRQSTATUS_ERRSOTHS1		1

#define ISPCSI2_SHORT_PACKET			(0x05c)
#define ISPCSI2_PHY_IRQENABLE			(0x060)
#define ISPCSI2_PHY_IRQENABLE_STATEALLULPMEXIT	(1 << 26)
#define ISPCSI2_PHY_IRQENABLE_STATEALLULPMENTER	(1 << 25)
#define ISPCSI2_PHY_IRQENABLE_STATEULPM5	(1 << 24)
#define ISPCSI2_PHY_IRQENABLE_STATEULPM4	(1 << 23)
#define ISPCSI2_PHY_IRQENABLE_STATEULPM3	(1 << 22)
#define ISPCSI2_PHY_IRQENABLE_STATEULPM2	(1 << 21)
#define ISPCSI2_PHY_IRQENABLE_STATEULPM1	(1 << 20)
#define ISPCSI2_PHY_IRQENABLE_ERRCONTROL5	(1 << 19)
#define ISPCSI2_PHY_IRQENABLE_ERRCONTROL4	(1 << 18)
#define ISPCSI2_PHY_IRQENABLE_ERRCONTROL3	(1 << 17)
#define ISPCSI2_PHY_IRQENABLE_ERRCONTROL2	(1 << 16)
#define ISPCSI2_PHY_IRQENABLE_ERRCONTROL1	(1 << 15)
#define ISPCSI2_PHY_IRQENABLE_ERRESC5		(1 << 14)
#define ISPCSI2_PHY_IRQENABLE_ERRESC4		(1 << 13)
#define ISPCSI2_PHY_IRQENABLE_ERRESC3		(1 << 12)
#define ISPCSI2_PHY_IRQENABLE_ERRESC2		(1 << 11)
#define ISPCSI2_PHY_IRQENABLE_ERRESC1		(1 << 10)
#define ISPCSI2_PHY_IRQENABLE_ERRSOTSYNCHS5	(1 << 9)
#define ISPCSI2_PHY_IRQENABLE_ERRSOTSYNCHS4	(1 << 8)
#define ISPCSI2_PHY_IRQENABLE_ERRSOTSYNCHS3	(1 << 7)
#define ISPCSI2_PHY_IRQENABLE_ERRSOTSYNCHS2	(1 << 6)
#define ISPCSI2_PHY_IRQENABLE_ERRSOTSYNCHS1	(1 << 5)
#define ISPCSI2_PHY_IRQENABLE_ERRSOTHS5		(1 << 4)
#define ISPCSI2_PHY_IRQENABLE_ERRSOTHS4		(1 << 3)
#define ISPCSI2_PHY_IRQENABLE_ERRSOTHS3		(1 << 2)
#define ISPCSI2_PHY_IRQENABLE_ERRSOTHS2		(1 << 1)
#define ISPCSI2_PHY_IRQENABLE_ERRSOTHS1		(1 << 0)

#define ISPCSI2_DBG_P				(0x068)
#define ISPCSI2_TIMING				(0x06c)
#define ISPCSI2_TIMING_FORCE_RX_MODE_IO(n)	(1 << ((16 * ((n) - 1)) + 15))
#define ISPCSI2_TIMING_STOP_STATE_X16_IO(n)	(1 << ((16 * ((n) - 1)) + 14))
#define ISPCSI2_TIMING_STOP_STATE_X4_IO(n)	(1 << ((16 * ((n) - 1)) + 13))
#define ISPCSI2_TIMING_STOP_STATE_COUNTER_IO_SHIFT(n)	(16 * ((n) - 1))
#define ISPCSI2_TIMING_STOP_STATE_COUNTER_IO_MASK(n)	\
	(0x1fff << ISPCSI2_TIMING_STOP_STATE_COUNTER_IO_SHIFT(n))

#define ISPCSI2_CTX_CTRL1(n)			((0x070) + 0x20 * (n))
#define ISPCSI2_CTX_CTRL1_COUNT_SHIFT		8
#define ISPCSI2_CTX_CTRL1_COUNT_MASK		\
	(0xff << ISPCSI2_CTX_CTRL1_COUNT_SHIFT)
#define ISPCSI2_CTX_CTRL1_EOF_EN		(1 << 7)
#define ISPCSI2_CTX_CTRL1_EOL_EN		(1 << 6)
#define ISPCSI2_CTX_CTRL1_CS_EN			(1 << 5)
#define ISPCSI2_CTX_CTRL1_COUNT_UNLOCK		(1 << 4)
#define ISPCSI2_CTX_CTRL1_PING_PONG		(1 << 3)
#define ISPCSI2_CTX_CTRL1_CTX_EN		(1 << 0)

#define ISPCSI2_CTX_CTRL2(n)			((0x074) + 0x20 * (n))
#define ISPCSI2_CTX_CTRL2_USER_DEF_MAP_SHIFT	13
#define ISPCSI2_CTX_CTRL2_USER_DEF_MAP_MASK	\
	(0x3 << ISPCSI2_CTX_CTRL2_USER_DEF_MAP_SHIFT)
#define ISPCSI2_CTX_CTRL2_VIRTUAL_ID_SHIFT	11
#define ISPCSI2_CTX_CTRL2_VIRTUAL_ID_MASK	\
	(0x3 <<	ISPCSI2_CTX_CTRL2_VIRTUAL_ID_SHIFT)
#define ISPCSI2_CTX_CTRL2_DPCM_PRED		(1 << 10)
#define ISPCSI2_CTX_CTRL2_FORMAT_SHIFT		0
#define ISPCSI2_CTX_CTRL2_FORMAT_MASK		\
	(0x3ff << ISPCSI2_CTX_CTRL2_FORMAT_SHIFT)
#define ISPCSI2_CTX_CTRL2_FRAME_SHIFT		16
#define ISPCSI2_CTX_CTRL2_FRAME_MASK		\
	(0xffff << ISPCSI2_CTX_CTRL2_FRAME_SHIFT)

#define ISPCSI2_CTX_DAT_OFST(n)			((0x078) + 0x20 * (n))
#define ISPCSI2_CTX_DAT_OFST_OFST_SHIFT		0
#define ISPCSI2_CTX_DAT_OFST_OFST_MASK		\
	(0x1ffe0 << ISPCSI2_CTX_DAT_OFST_OFST_SHIFT)

#define ISPCSI2_CTX_DAT_PING_ADDR(n)		((0x07c) + 0x20 * (n))
#define ISPCSI2_CTX_DAT_PONG_ADDR(n)		((0x080) + 0x20 * (n))
#define ISPCSI2_CTX_IRQENABLE(n)		((0x084) + 0x20 * (n))
#define ISPCSI2_CTX_IRQENABLE_ECC_CORRECTION_IRQ	(1 << 8)
#define ISPCSI2_CTX_IRQENABLE_LINE_NUMBER_IRQ	(1 << 7)
#define ISPCSI2_CTX_IRQENABLE_FRAME_NUMBER_IRQ	(1 << 6)
#define ISPCSI2_CTX_IRQENABLE_CS_IRQ		(1 << 5)
#define ISPCSI2_CTX_IRQENABLE_LE_IRQ		(1 << 3)
#define ISPCSI2_CTX_IRQENABLE_LS_IRQ		(1 << 2)
#define ISPCSI2_CTX_IRQENABLE_FE_IRQ		(1 << 1)
#define ISPCSI2_CTX_IRQENABLE_FS_IRQ		(1 << 0)

#define ISPCSI2_CTX_IRQSTATUS(n)		((0x088) + 0x20 * (n))
#define ISPCSI2_CTX_IRQSTATUS_ECC_CORRECTION_IRQ	(1 << 8)
#define ISPCSI2_CTX_IRQSTATUS_LINE_NUMBER_IRQ	(1 << 7)
#define ISPCSI2_CTX_IRQSTATUS_FRAME_NUMBER_IRQ	(1 << 6)
#define ISPCSI2_CTX_IRQSTATUS_CS_IRQ		(1 << 5)
#define ISPCSI2_CTX_IRQSTATUS_LE_IRQ		(1 << 3)
#define ISPCSI2_CTX_IRQSTATUS_LS_IRQ		(1 << 2)
#define ISPCSI2_CTX_IRQSTATUS_FE_IRQ		(1 << 1)
#define ISPCSI2_CTX_IRQSTATUS_FS_IRQ		(1 << 0)

#define ISPCSI2_CTX_CTRL3(n)			((0x08c) + 0x20 * (n))
#define ISPCSI2_CTX_CTRL3_ALPHA_SHIFT		5
#define ISPCSI2_CTX_CTRL3_ALPHA_MASK		\
	(0x3fff << ISPCSI2_CTX_CTRL3_ALPHA_SHIFT)

/* This instance is for OMAP3630 only */
#define ISPCSI2_CTX_TRANSCODEH(n)		(0x000 + 0x8 * (n))
#define ISPCSI2_CTX_TRANSCODEH_HCOUNT_SHIFT	16
#define ISPCSI2_CTX_TRANSCODEH_HCOUNT_MASK	\
	(0x1fff << ISPCSI2_CTX_TRANSCODEH_HCOUNT_SHIFT)
#define ISPCSI2_CTX_TRANSCODEH_HSKIP_SHIFT	0
#define ISPCSI2_CTX_TRANSCODEH_HSKIP_MASK	\
	(0x1fff << ISPCSI2_CTX_TRANSCODEH_HCOUNT_SHIFT)
#define ISPCSI2_CTX_TRANSCODEV(n)		(0x004 + 0x8 * (n))
#define ISPCSI2_CTX_TRANSCODEV_VCOUNT_SHIFT	16
#define ISPCSI2_CTX_TRANSCODEV_VCOUNT_MASK	\
	(0x1fff << ISPCSI2_CTX_TRANSCODEV_VCOUNT_SHIFT)
#define ISPCSI2_CTX_TRANSCODEV_VSKIP_SHIFT	0
#define ISPCSI2_CTX_TRANSCODEV_VSKIP_MASK	\
	(0x1fff << ISPCSI2_CTX_TRANSCODEV_VCOUNT_SHIFT)

/* -----------------------------------------------------------------------------
 * CSI PHY registers
 */

#define ISPCSIPHY_REG0				(0x000)
#define ISPCSIPHY_REG0_THS_TERM_SHIFT		8
#define ISPCSIPHY_REG0_THS_TERM_MASK		\
	(0xff << ISPCSIPHY_REG0_THS_TERM_SHIFT)
#define ISPCSIPHY_REG0_THS_SETTLE_SHIFT		0
#define ISPCSIPHY_REG0_THS_SETTLE_MASK		\
	(0xff << ISPCSIPHY_REG0_THS_SETTLE_SHIFT)

#define ISPCSIPHY_REG1					(0x004)
#define ISPCSIPHY_REG1_RESET_DONE_CTRLCLK		(1 << 29)
/* This field is for OMAP3630 only */
#define ISPCSIPHY_REG1_CLOCK_MISS_DETECTOR_STATUS	(1 << 25)
#define ISPCSIPHY_REG1_TCLK_TERM_SHIFT			18
#define ISPCSIPHY_REG1_TCLK_TERM_MASK			\
	(0x7f << ISPCSIPHY_REG1_TCLK_TERM_SHIFT)
#define ISPCSIPHY_REG1_DPHY_HS_SYNC_PATTERN_SHIFT	10
#define ISPCSIPHY_REG1_DPHY_HS_SYNC_PATTERN_MASK	\
	(0xff << ISPCSIPHY_REG1_DPHY_HS_SYNC_PATTERN)
/* This field is for OMAP3430 only */
#define ISPCSIPHY_REG1_TCLK_MISS_SHIFT			8
#define ISPCSIPHY_REG1_TCLK_MISS_MASK			\
	(0x3 << ISPCSIPHY_REG1_TCLK_MISS_SHIFT)
/* This field is for OMAP3630 only */
#define ISPCSIPHY_REG1_CTRLCLK_DIV_FACTOR_SHIFT		8
#define ISPCSIPHY_REG1_CTRLCLK_DIV_FACTOR_MASK		\
	(0x3 << ISPCSIPHY_REG1_CTRLCLK_DIV_FACTOR_SHIFT)
#define ISPCSIPHY_REG1_TCLK_SETTLE_SHIFT		0
#define ISPCSIPHY_REG1_TCLK_SETTLE_MASK			\
	(0xff << ISPCSIPHY_REG1_TCLK_SETTLE_SHIFT)

/* This register is for OMAP3630 only */
#define ISPCSIPHY_REG2					(0x008)
#define ISPCSIPHY_REG2_TRIGGER_CMD_RXTRIGESC0_SHIFT	30
#define ISPCSIPHY_REG2_TRIGGER_CMD_RXTRIGESC0_MASK	\
	(0x3 << ISPCSIPHY_REG2_TRIGGER_CMD_RXTRIGESC0_SHIFT)
#define ISPCSIPHY_REG2_TRIGGER_CMD_RXTRIGESC1_SHIFT	28
#define ISPCSIPHY_REG2_TRIGGER_CMD_RXTRIGESC1_MASK	\
	(0x3 << ISPCSIPHY_REG2_TRIGGER_CMD_RXTRIGESC1_SHIFT)
#define ISPCSIPHY_REG2_TRIGGER_CMD_RXTRIGESC2_SHIFT	26
#define ISPCSIPHY_REG2_TRIGGER_CMD_RXTRIGESC2_MASK	\
	(0x3 << ISPCSIPHY_REG2_TRIGGER_CMD_RXTRIGESC2_SHIFT)
#define ISPCSIPHY_REG2_TRIGGER_CMD_RXTRIGESC3_SHIFT	24
#define ISPCSIPHY_REG2_TRIGGER_CMD_RXTRIGESC3_MASK	\
	(0x3 << ISPCSIPHY_REG2_TRIGGER_CMD_RXTRIGESC3_SHIFT)
#define ISPCSIPHY_REG2_CCP2_SYNC_PATTERN_SHIFT		0
#define ISPCSIPHY_REG2_CCP2_SYNC_PATTERN_MASK		\
	(0x7fffff << ISPCSIPHY_REG2_CCP2_SYNC_PATTERN_SHIFT)

/* -----------------------------------------------------------------------------
 * CONTROL registers for CSI-2 phy routing
 */

/* OMAP343X_CONTROL_CSIRXFE */
#define OMAP343X_CONTROL_CSIRXFE_CSIB_INV	(1 << 7)
#define OMAP343X_CONTROL_CSIRXFE_RESENABLE	(1 << 8)
#define OMAP343X_CONTROL_CSIRXFE_SELFORM	(1 << 10)
#define OMAP343X_CONTROL_CSIRXFE_PWRDNZ		(1 << 12)
#define OMAP343X_CONTROL_CSIRXFE_RESET		(1 << 13)

/* OMAP3630_CONTROL_CAMERA_PHY_CTRL */
#define OMAP3630_CONTROL_CAMERA_PHY_CTRL_CAMMODE_PHY1_SHIFT	2
#define OMAP3630_CONTROL_CAMERA_PHY_CTRL_CAMMODE_PHY2_SHIFT	0
#define OMAP3630_CONTROL_CAMERA_PHY_CTRL_CAMMODE_DPHY		0x0
#define OMAP3630_CONTROL_CAMERA_PHY_CTRL_CAMMODE_CCP2_DATA_STROBE 0x1
#define OMAP3630_CONTROL_CAMERA_PHY_CTRL_CAMMODE_CCP2_DATA_CLOCK 0x2
#define OMAP3630_CONTROL_CAMERA_PHY_CTRL_CAMMODE_GPI		0x3
#define OMAP3630_CONTROL_CAMERA_PHY_CTRL_CAMMODE_MASK		0x3
/* CCP2B: set to receive data from PHY2 instead of PHY1 */
#define OMAP3630_CONTROL_CAMERA_PHY_CTRL_CSI1_RX_SEL_PHY2	(1 << 4)

#endif	/* OMAP3_ISP_REG_H */
