/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.link;

import java.net.URI;
import org.freeplane.core.util.Hyperlink;
import org.freeplane.features.attribute.Attribute;
import org.freeplane.features.attribute.NodeAttributeTableModel;
import org.freeplane.features.filter.condition.StringConditionAdapter;
import org.freeplane.features.link.NodeLinks;
import org.freeplane.features.map.NodeModel;
import org.freeplane.n3.nanoxml.XMLElement;

public abstract class HyperLinkCondition
extends StringConditionAdapter {
    static final String TEXT = "TEXT";
    private final String hyperlink;

    public HyperLinkCondition(String hyperlink, boolean matchCase, boolean matchApproximately, boolean ignoreDiacritics) {
        super(matchCase, matchApproximately, ignoreDiacritics);
        this.hyperlink = hyperlink;
    }

    protected abstract boolean checkLink(Hyperlink var1);

    @Override
    public boolean checkNode(NodeModel node) {
        Hyperlink nodeLink = NodeLinks.getValidLink(node);
        if (nodeLink != null && this.checkLink(nodeLink)) {
            return true;
        }
        NodeAttributeTableModel attributes = NodeAttributeTableModel.getModel(node);
        if (attributes == null) {
            return false;
        }
        int rowCount = attributes.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            Attribute attribute = attributes.getAttribute(i);
            Object value = attribute.getValue();
            if (value instanceof Hyperlink && this.checkLink((Hyperlink)value)) {
                return true;
            }
            if (!(value instanceof URI) || !this.checkLink(new Hyperlink((URI)value))) continue;
            return true;
        }
        return false;
    }

    public String getHyperlink() {
        return this.hyperlink;
    }

    @Override
    protected Object conditionValue() {
        return this.hyperlink;
    }

    @Override
    protected void fillXML(XMLElement element) {
        super.fillXML(element);
        element.setAttribute(TEXT, this.hyperlink);
    }
}

