/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.view.swing.map;

import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.beans.PropertyChangeEvent;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicLabelUI;
import javax.swing.text.View;
import org.freeplane.core.ui.components.html.ScaledHTML;
import org.freeplane.core.util.TextUtils;
import org.freeplane.view.swing.map.ZoomableLabel;

public class ZoomableLabelUI
extends BasicLabelUI {
    private boolean isPainting = false;
    static ZoomableLabelUI labelUI = new ZoomableLabelUI();
    private Rectangle iconR = new Rectangle();
    private Rectangle textR = new Rectangle();
    private Rectangle viewR = new Rectangle();
    private LayoutData layoutData = new LayoutData(this.iconR, this.textR);

    @Override
    public Dimension getPreferredSize(JComponent c) {
        int minimumWidth;
        float zoom;
        Dimension preferredSize = super.getPreferredSize(c);
        ZoomableLabel zoomableLabel = (ZoomableLabel)c;
        if (zoomableLabel.getIcon() == null) {
            int fontHeight = zoomableLabel.getFontMetrics().getHeight();
            Insets insets = c.getInsets();
            preferredSize.width = Math.max(preferredSize.width, fontHeight / 2 + insets.left + insets.right);
            preferredSize.height = Math.max(preferredSize.height, fontHeight + insets.top + insets.bottom);
        }
        if ((zoom = zoomableLabel.getZoom()) != 1.0f) {
            preferredSize.width = (int)Math.ceil(zoom * (float)preferredSize.width);
            preferredSize.height = (int)Math.ceil(zoom * (float)preferredSize.height);
        }
        if ((minimumWidth = zoomableLabel.getMinimumWidth()) != 0) {
            preferredSize.width = Math.max(minimumWidth, preferredSize.width);
        }
        return preferredSize;
    }

    public static ComponentUI createUI(JComponent c) {
        return labelUI;
    }

    @Override
    protected String layoutCL(JLabel label, FontMetrics fontMetrics, String text, Icon icon, Rectangle viewR, Rectangle iconR, Rectangle textR) {
        ZoomableLabel zLabel = (ZoomableLabel)label;
        float zoom = zLabel.getZoom();
        if (this.isPainting) {
            Insets insets = zLabel.getInsets();
            int width = zLabel.getWidth();
            int height = zLabel.getHeight();
            viewR.x = insets.left;
            viewR.y = insets.top;
            viewR.width = (int)((float)width / zoom) - (insets.left + insets.right);
            viewR.height = (int)((float)height / zoom) - (insets.top + insets.bottom);
            if (viewR.width < 0) {
                viewR.width = 0;
            }
        } else if (zLabel.getMaximumWidth() != Integer.MAX_VALUE) {
            ScaledHTML.Renderer v;
            int maximumWidth = (int)((float)zLabel.getMaximumWidth() / zoom);
            Insets insets = label.getInsets();
            viewR.width = maximumWidth - insets.left - insets.right;
            if (viewR.width < 0) {
                viewR.width = 0;
            }
            if ((v = (ScaledHTML.Renderer)label.getClientProperty("html")) != null) {
                int currentWidth;
                float minimumWidth;
                int availableTextWidth = viewR.width;
                if (icon != null) {
                    availableTextWidth -= icon.getIconWidth() + label.getIconTextGap();
                }
                if ((minimumWidth = v.getMinimumSpan(0)) > (float)availableTextWidth) {
                    viewR.width = (int)((float)viewR.width + (minimumWidth - (float)availableTextWidth));
                    availableTextWidth = (int)minimumWidth;
                }
                if ((currentWidth = v.getWidth()) != availableTextWidth) {
                    float viewPreferredWidth = v.getPreferredWidth();
                    if (viewPreferredWidth > (float)availableTextWidth) {
                        v.setWidth(availableTextWidth);
                        super.layoutCL(zLabel, zLabel.getFontMetrics(), text, icon, viewR, iconR, textR);
                        return text;
                    }
                    if ((float)currentWidth != viewPreferredWidth) {
                        v.resetWidth();
                    }
                }
            }
        }
        Icon textRenderingIcon = zLabel.getTextRenderingIcon();
        if (textRenderingIcon != null) {
            ZoomableLabelUI.layoutLabelWithTextIcon(textRenderingIcon, icon, viewR, iconR, textR, zLabel);
        } else {
            super.layoutCL(zLabel, zLabel.getFontMetrics(), text, icon, viewR, iconR, textR);
        }
        return text;
    }

    private static void layoutLabelWithTextIcon(Icon textRenderingIcon, Icon icon, Rectangle viewR, Rectangle iconR, Rectangle textR, ZoomableLabel zLabel) {
        ZoomableLabel c = zLabel;
        int horizontalAlignment = zLabel.getHorizontalAlignment();
        int horizontalTextPosition = zLabel.getHorizontalTextPosition();
        boolean orientationIsLeftToRight = true;
        int hAlign = horizontalAlignment;
        int hTextPos = horizontalTextPosition;
        if (c != null && !c.getComponentOrientation().isLeftToRight()) {
            orientationIsLeftToRight = false;
        }
        switch (horizontalAlignment) {
            case 10: {
                hAlign = orientationIsLeftToRight ? 2 : 4;
                break;
            }
            case 11: {
                hAlign = orientationIsLeftToRight ? 4 : 2;
            }
        }
        switch (horizontalTextPosition) {
            case 10: {
                hTextPos = orientationIsLeftToRight ? 2 : 4;
                break;
            }
            case 11: {
                hTextPos = orientationIsLeftToRight ? 4 : 2;
            }
        }
        int verticalAlignment = zLabel.getVerticalAlignment();
        int verticalTextPosition = zLabel.getVerticalTextPosition();
        if (icon != null) {
            iconR.width = icon.getIconWidth();
            iconR.height = icon.getIconHeight();
        } else {
            iconR.height = 0;
            iconR.width = 0;
        }
        int lsb = 0;
        int rsb = 0;
        int gap = icon == null ? 0 : zLabel.getIconTextGap();
        int availTextWidth = hTextPos == 0 ? viewR.width : viewR.width - (iconR.width + gap);
        textR.width = Math.min(availTextWidth, textRenderingIcon.getIconWidth());
        textR.height = textRenderingIcon.getIconHeight();
        textR.y = verticalTextPosition == 1 ? (hTextPos != 0 ? 0 : -(textR.height + gap)) : (verticalTextPosition == 0 ? iconR.height / 2 - textR.height / 2 : (hTextPos != 0 ? iconR.height - textR.height : iconR.height + gap));
        textR.x = hTextPos == 2 ? -(textR.width + gap) : (hTextPos == 0 ? iconR.width / 2 - textR.width / 2 : iconR.width + gap);
        int labelR_x = Math.min(iconR.x, textR.x);
        int labelR_width = Math.max(iconR.x + iconR.width, textR.x + textR.width) - labelR_x;
        int labelR_y = Math.min(iconR.y, textR.y);
        int labelR_height = Math.max(iconR.y + iconR.height, textR.y + textR.height) - labelR_y;
        int dy = verticalAlignment == 1 ? viewR.y - labelR_y : (verticalAlignment == 0 ? viewR.y + viewR.height / 2 - (labelR_y + labelR_height / 2) : viewR.y + viewR.height - (labelR_y + labelR_height));
        int dx = hAlign == 2 ? viewR.x - labelR_x : (hAlign == 4 ? viewR.x + viewR.width - (labelR_x + labelR_width) : viewR.x + viewR.width / 2 - (labelR_x + labelR_width / 2));
        textR.x += dx;
        textR.y += dy;
        iconR.x += dx;
        iconR.y += dy;
        if (lsb < 0) {
            textR.x -= lsb;
            textR.width += lsb;
        }
        if (rsb > 0) {
            textR.width -= rsb;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paint(Graphics g, JComponent label) {
        Object newRenderingHintFM;
        ZoomableLabel mainView = (ZoomableLabel)label;
        if (!mainView.useFractionalMetrics()) {
            try {
                this.isPainting = true;
                this.superPaintSafe(g, mainView);
            }
            finally {
                this.isPainting = false;
            }
            return;
        }
        Graphics2D g2 = (Graphics2D)g;
        Object oldRenderingHintFM = g2.getRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS);
        if (oldRenderingHintFM != (newRenderingHintFM = RenderingHints.VALUE_FRACTIONALMETRICS_ON)) {
            g2.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, newRenderingHintFM);
        }
        AffineTransform transform = g2.getTransform();
        float factor = 0.97f;
        float zoom = mainView.getZoom() * 0.97f;
        if (mainView.getVerticalAlignment() == 0) {
            float translationFactorY = 0.5f;
            g2.translate(0.0, (float)mainView.getHeight() * 0.029999971f * 0.5f);
        }
        g2.scale(zoom, zoom);
        boolean htmlViewSet = null != label.getClientProperty("html");
        try {
            this.isPainting = true;
            if (htmlViewSet) {
                ScaledHTML.resetPainter();
            }
            this.superPaintSafe(g, mainView);
        }
        finally {
            this.isPainting = false;
            if (htmlViewSet) {
                ScaledHTML.resetPainter();
            }
        }
        g2.setTransform(transform);
        if (oldRenderingHintFM != newRenderingHintFM) {
            g2.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, oldRenderingHintFM != null ? oldRenderingHintFM : RenderingHints.VALUE_FRACTIONALMETRICS_DEFAULT);
        }
    }

    private void superPaintSafe(Graphics g, final ZoomableLabel label) {
        try {
            boolean isTextTransparent = label.getForeground().getAlpha() == 0;
            Icon textRenderingIcon = label.getTextRenderingIcon();
            if (isTextTransparent) {
                this.paintIcon(g, label);
            } else if (textRenderingIcon != null) {
                this.paintIcons(g, label, textRenderingIcon);
            } else {
                super.paint(g, label);
            }
        }
        catch (ClassCastException e) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    label.setText(TextUtils.format("html_problem", label.getText()));
                }
            });
        }
    }

    private void paintIcon(Graphics g, ZoomableLabel label) {
        Icon icon;
        Icon icon2 = icon = label.isEnabled() ? label.getIcon() : label.getDisabledIcon();
        if (icon == null) {
            return;
        }
        FontMetrics fm = label.getFontMetrics(g.getFont());
        String text = label.getText();
        Rectangle paintViewR = new Rectangle();
        Rectangle paintIconR = new Rectangle();
        Rectangle paintTextR = new Rectangle();
        this.layoutCL(label, fm, text, icon, paintViewR, paintIconR, paintTextR);
        if (icon != null) {
            icon.paintIcon(label, g, paintIconR.x, paintIconR.y);
        }
    }

    private void paintIcons(Graphics g, ZoomableLabel label, Icon textRenderingIcon) {
        Icon icon = label.isEnabled() ? label.getIcon() : label.getDisabledIcon();
        Rectangle paintViewR = new Rectangle();
        Rectangle paintIconR = new Rectangle();
        Rectangle paintTextR = new Rectangle();
        this.layoutCL(label, null, null, icon, paintViewR, paintIconR, paintTextR);
        if (icon != null) {
            icon.paintIcon(label, g, paintIconR.x, paintIconR.y);
        }
        textRenderingIcon.paintIcon(label, g, paintTextR.x, paintTextR.y);
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        ZoomableLabel lbl = (ZoomableLabel)e.getSource();
        String propertyName = e.getPropertyName();
        if (propertyName == "text" || "font" == propertyName || "foreground" == propertyName || ("ancestor" == propertyName || "graphicsConfiguration" == propertyName) && e.getNewValue() != null || "customCss" == propertyName) {
            this.updateRendererOnPropertyChange(lbl, propertyName);
        } else {
            super.propertyChange(e);
            View view = (View)lbl.getClientProperty("html");
            if (view != null && !(view instanceof ScaledHTML.Renderer)) {
                this.updateRendererOnPropertyChange(lbl, propertyName);
            }
        }
    }

    private void updateRendererOnPropertyChange(ZoomableLabel lbl, String propertyName) {
        if (lbl.getTextRenderingIcon() != null) {
            ScaledHTML.updateRenderer(lbl, "");
        } else {
            ScaledHTML.updateRendererOnPropertyChange(lbl, propertyName);
        }
    }

    @Override
    protected void installComponents(JLabel c) {
        ScaledHTML.updateRenderer(c, c.getText());
        c.setInheritsPopupMenu(true);
    }

    public Rectangle getIconR(ZoomableLabel label) {
        this.layout(label);
        return this.iconR;
    }

    public Rectangle getTextR(ZoomableLabel label) {
        this.layout(label);
        return this.textR;
    }

    public LayoutData getLayoutData(ZoomableLabel label) {
        this.layout(label);
        return this.layoutData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void layout(ZoomableLabel label) {
        String text = label.getText();
        Icon icon = label.isEnabled() ? label.getIcon() : label.getDisabledIcon();
        boolean wasPainting = this.isPainting;
        try {
            this.isPainting = true;
            this.iconR.height = 0;
            this.iconR.width = 0;
            this.iconR.y = 0;
            this.iconR.x = 0;
            this.textR.height = 0;
            this.textR.width = 0;
            this.textR.y = 0;
            this.textR.x = 0;
            this.layoutCL(label, label.getFontMetrics(), text, icon, this.viewR, this.iconR, this.textR);
            float zoom = label.getZoom();
            this.iconR.x = (int)((float)this.iconR.x * zoom);
            this.iconR.y = (int)((float)this.iconR.y * zoom);
            this.iconR.width = (int)((float)this.iconR.width * zoom);
            this.iconR.height = (int)((float)this.iconR.height * zoom);
            this.textR.x = (int)((float)this.textR.x * zoom);
            this.textR.y = (int)((float)this.textR.y * zoom);
            this.textR.width = (int)((float)this.textR.width * zoom);
            this.textR.height = (int)((float)this.textR.height * zoom);
        }
        finally {
            this.isPainting = wasPainting;
        }
    }

    public static class LayoutData {
        public final Rectangle iconR;
        public final Rectangle textR;

        public LayoutData(Rectangle iconR, Rectangle textR) {
            this.iconR = iconR;
            this.textR = textR;
        }
    }
}

