/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.plugin.codeexplorer.map;

import com.tngtech.archunit.core.domain.JavaClasses;
import com.tngtech.archunit.core.importer.ClassFileImporter;
import java.awt.Color;
import java.awt.EventQueue;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import javax.swing.UIManager;
import org.freeplane.api.HorizontalTextAlignment;
import org.freeplane.api.LengthUnit;
import org.freeplane.api.Quantity;
import org.freeplane.core.ui.AFreeplaneAction;
import org.freeplane.core.ui.components.UITools;
import org.freeplane.core.util.LogUtils;
import org.freeplane.features.attribute.AttributeRegistry;
import org.freeplane.features.filter.FilterController;
import org.freeplane.features.map.IMapSelection;
import org.freeplane.features.map.MapController;
import org.freeplane.features.map.MapModel;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.mode.ModeController;
import org.freeplane.features.nodestyle.NodeSizeModel;
import org.freeplane.features.nodestyle.NodeStyleModel;
import org.freeplane.features.styles.MapStyleModel;
import org.freeplane.features.ui.IMapViewManager;
import org.freeplane.plugin.codeexplorer.map.CodeMap;
import org.freeplane.plugin.codeexplorer.map.CodeNode;
import org.freeplane.plugin.codeexplorer.map.CodeNodeSelection;
import org.freeplane.plugin.codeexplorer.map.CodeNodeStream;
import org.freeplane.plugin.codeexplorer.map.CopyQualifiedName;
import org.freeplane.plugin.codeexplorer.map.EmptyNodeModel;
import org.freeplane.plugin.codeexplorer.map.FilterCyclesAction;
import org.freeplane.plugin.codeexplorer.map.NewCodeMapAction;
import org.freeplane.plugin.codeexplorer.map.ProjectRootNode;
import org.freeplane.plugin.codeexplorer.map.SelectCyclesAction;
import org.freeplane.plugin.codeexplorer.map.ShowAllClassesAction;
import org.freeplane.plugin.codeexplorer.map.ShowDependingNodesAction;
import org.freeplane.plugin.codeexplorer.map.ShowSelectedClassesWithExternalDependenciesAction;
import org.freeplane.plugin.codeexplorer.task.CodeExplorer;
import org.freeplane.plugin.codeexplorer.task.CodeExplorerConfiguration;
import org.freeplane.plugin.codeexplorer.task.DependencyJudge;
import org.freeplane.plugin.codeexplorer.task.DirectoryMatcher;
import org.freeplane.view.swing.map.MapView;
import org.freeplane.view.swing.map.NodeView;

public class CodeMapController
extends MapController
implements CodeExplorer {
    private final AtomicReference<CodeMap> createdMap = new AtomicReference();

    public CodeMapController(ModeController modeController) {
        super(modeController);
        modeController.addAction((AFreeplaneAction)new ShowSelectedClassesWithExternalDependenciesAction());
        for (CodeNodeSelection selection : CodeNodeSelection.values()) {
            for (ShowDependingNodesAction.DependencyDirection direction : ShowDependingNodesAction.DependencyDirection.values()) {
                for (ShowDependingNodesAction.Depth maximumDepth : ShowDependingNodesAction.Depth.values()) {
                    modeController.addAction((AFreeplaneAction)new ShowDependingNodesAction(direction, selection, maximumDepth));
                }
            }
        }
        modeController.addAction((AFreeplaneAction)new CopyQualifiedName());
        modeController.addAction((AFreeplaneAction)new ShowAllClassesAction());
        modeController.addAction((AFreeplaneAction)new SelectCyclesAction());
        modeController.addAction((AFreeplaneAction)new FilterCyclesAction());
        modeController.addAction((AFreeplaneAction)new NewCodeMapAction());
    }

    public CodeMap newMap() {
        CodeMap codeMap = new CodeMap(this.getModeController().getMapController().duplicator());
        this.fireMapCreated(codeMap);
        Color background = UIManager.getColor("Panel.background");
        Color foreground = UIManager.getColor("Panel.foreground");
        MapStyleModel mapStyleModel = MapStyleModel.getExtension((MapModel)codeMap);
        NodeModel defaultStyleNode = mapStyleModel.getDefaultStyleNode();
        NodeStyleModel nodeStyle = NodeStyleModel.createNodeStyleModel((NodeModel)defaultStyleNode);
        nodeStyle.setFontSize(Integer.valueOf(10));
        nodeStyle.setHorizontalTextAlignment(HorizontalTextAlignment.LEFT);
        if (background != null && foreground != null) {
            mapStyleModel.setBackgroundColor(background.darker());
            nodeStyle.setColor(foreground);
        } else {
            mapStyleModel.setBackgroundColor(Color.WHITE);
            nodeStyle.setColor(Color.BLACK);
        }
        NodeSizeModel nodeSizeModel = NodeSizeModel.createNodeSizeModel((NodeModel)defaultStyleNode);
        nodeSizeModel.setMinNodeWidth(Quantity.fromString((String)"6", (Enum)LengthUnit.cm));
        nodeSizeModel.setMaxNodeWidth(Quantity.fromString((String)"30", (Enum)LengthUnit.cm));
        return codeMap;
    }

    protected void fireFoldingChanged(NodeModel node) {
    }

    @Override
    public void explore(CodeExplorerConfiguration codeExplorerConfiguration) {
        Controller currentController = Controller.getCurrentController();
        IMapSelection selection = currentController.getSelection();
        List orderedSelectionIds = selection.getOrderedSelectionIds();
        IMapViewManager mapViewManager = currentController.getMapViewManager();
        MapView mapView = (MapView)mapViewManager.getMapViewComponent();
        List unfoldedNodeIDs = CodeNodeStream.nodeViews(mapView).filter(nv -> !nv.isFolded()).map(NodeView::getNode).map(NodeModel::getID).collect(Collectors.toList());
        CodeMap oldMap = (CodeMap)selection.getMap();
        CodeMap loadingHintMap = this.newMap();
        EmptyNodeModel emptyRoot = new EmptyNodeModel(loadingHintMap, "Analyzing" + (codeExplorerConfiguration != null ? " " + codeExplorerConfiguration.countLocations() : "") + " locations ...");
        loadingHintMap.setRoot(emptyRoot);
        mapView.setMap((MapModel)loadingHintMap);
        selection.selectAsTheOnlyOneSelected((NodeModel)emptyRoot);
        Controller.getCurrentController().getMapViewManager().setMapTitles();
        Controller.getCurrentController().getViewController().setWaitingCursor(true);
        CodeMap projectMap = this.newMap();
        this.createdMap.set(projectMap);
        ((AttributeRegistry)projectMap.getExtension(AttributeRegistry.class)).setAttributeViewType("hide");
        new Thread(() -> {
            CodeMap nextMap = oldMap;
            ProjectRootNode projectRoot = null;
            try {
                if (codeExplorerConfiguration != null) {
                    JavaClasses importedClasses = codeExplorerConfiguration.importClasses();
                    if (((Object)((Object)projectMap)).equals((Object)this.createdMap.get())) {
                        projectRoot = ProjectRootNode.asMapRoot(codeExplorerConfiguration.getProjectName(), projectMap, importedClasses, codeExplorerConfiguration.createDirectoryMatcher());
                        projectMap.setJudge(codeExplorerConfiguration.getDependencyJudge());
                    }
                } else {
                    ClassFileImporter classFileImporter = new ClassFileImporter();
                    JavaClasses importedClasses = classFileImporter.importPackages(new String[]{"org.freeplane"});
                    if (((Object)((Object)projectMap)).equals((Object)this.createdMap.get())) {
                        projectRoot = ProjectRootNode.asMapRoot("demo", projectMap, importedClasses, DirectoryMatcher.ALLOW_ALL);
                    }
                }
                LogUtils.info((String)"Code map prepared");
                if (projectRoot != null && ((Object)((Object)projectMap)).equals((Object)this.createdMap.get())) {
                    projectRoot.setFolded(false);
                    nextMap = projectMap;
                }
            }
            catch (Exception e) {
                LogUtils.warn((String)"Loading classes failed", (Throwable)e);
                UITools.errorMessage((Object)("Loading classes failed, " + e.getMessage()));
            }
            CodeMap viewedMap = nextMap;
            EventQueue.invokeLater(() -> {
                this.createdMap.compareAndSet(projectMap, null);
                mapView.setMap((MapModel)viewedMap);
                selection.selectAsTheOnlyOneSelected(viewedMap.getRootNode());
                unfoldedNodeIDs.stream().map(id -> this.getExistingAncestorOrSelfNode(viewedMap, (String)id)).filter(x -> x != null).forEach(node -> node.setFolded(false));
                NodeModel[] newSelection = (NodeModel[])orderedSelectionIds.stream().map(id -> this.getExistingAncestorOrSelfNode(viewedMap, (String)id)).filter(x -> x != null).distinct().toArray(NodeModel[]::new);
                if (newSelection.length > 0) {
                    selection.replaceSelection(newSelection);
                }
                FilterController.getCurrentFilterController().mapRootNodeChanged((MapModel)viewedMap);
                Controller.getCurrentController().getMapViewManager().setMapTitles();
                EventQueue.invokeLater(() -> Controller.getCurrentController().getViewController().setWaitingCursor(false));
            });
        }, "Load explored packages").start();
    }

    private CodeNode getExistingAncestorOrSelfNode(MapModel map, String id) {
        NodeModel node = map.getNodeForID(id);
        if (node != null) {
            return (CodeNode)node;
        }
        int lastDelimiterPosition = id.lastIndexOf(46);
        if (lastDelimiterPosition > 0) {
            return this.getExistingAncestorOrSelfNode(map, id.substring(0, lastDelimiterPosition));
        }
        return null;
    }

    @Override
    public void setJudge(DependencyJudge judge) {
        Controller currentController = Controller.getCurrentController();
        IMapSelection selection = currentController.getSelection();
        CodeMap map = (CodeMap)selection.getMap();
        map.setJudge(judge);
        IMapViewManager mapViewManager = currentController.getMapViewManager();
        MapView mapView = (MapView)mapViewManager.getMapViewComponent();
        mapView.repaint();
    }

    @Override
    public void cancelAnalysis() {
        this.createdMap.set(null);
    }
}

