/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.quantum;

import java.util.Map;
import javajs.api.Interface;
import javajs.util.BS;
import javajs.util.Lst;
import javajs.util.T3;
import org.jmol.jvxl.data.VolumeData;
import org.jmol.modelset.Atom;
import org.jmol.quantum.QS;
import org.jmol.quantum.QuantumCalculation;
import org.jmol.quantum.SlaterData;
import org.jmol.quantum.mo.DataAdder;
import org.jmol.util.Logger;

public class MOCalculation
extends QuantumCalculation {
    public static final double ROOT3 = 1.7320507764816284;
    private static final double CUT = -50.0;
    private double[] CX;
    private double[] CY;
    private double[] CZ;
    private double[] DXY;
    private double[] DXZ;
    private double[] DYZ;
    public double[] EX;
    public double[] EY;
    public double[] EZ;
    private String calculationType;
    private Lst<int[]> shells;
    public float[][] gaussians;
    private SlaterData[] slaters;
    private float[] moCoefficients;
    private int moCoeff;
    public int gaussianPtr;
    public static final int NORM_NONE = 0;
    public static final int NORM_STANDARD = 1;
    public static final int NORM_NWCHEM = 2;
    public static final int NORM_NBO = 3;
    public int normType = 0;
    private int[][] dfCoefMaps;
    private float[] linearCombination;
    private float[][] coefs;
    private double moFactor = 1.0;
    public boolean havePoints;
    boolean testing = true;
    private int[] highLEnabled;
    double sum = -1.0;
    public int nGaussians;
    private boolean doShowShellType;
    private String warned;
    DataAdder[] dataAdders = new DataAdder[20];
    int[] dataAdderOK = new int[20];
    public double[] coeffs;
    private int[] map;
    private int lastGaussianPtr = -1;
    private static final String[][] shellOrder = new String[][]{{"S"}, {"X", "Y", "Z"}, {"S", "X", "Y", "Z"}, {"d0/z2", "d1+/xz", "d1-/yz", "d2+/x2-y2", "d2-/xy"}, {"XX", "YY", "ZZ", "XY", "XZ", "YZ"}, {"f0/2z3-3x2z-3y2z", "f1+/4xz2-x3-xy2", "f1-/4yz2-x2y-y3", "f2+/x2z-y2z", "f2-/xyz", "f3+/x3-3xy2", "f3-/3x2y-y3"}, {"XXX", "YYY", "ZZZ", "XYY", "XXY", "XXZ", "XZZ", "YZZ", "YYZ", "XYZ"}};
    private boolean isSquaredLinear;

    public boolean setupCalculation(Map<String, Object> moData, boolean isSlaters, VolumeData volumeData, BS bsSelected, T3[] xyz, Atom[] atoms, int firstAtomOffset, int[][] dfCoefMaps, float[] moCoefficients, float[] linearCombination, boolean isSquaredLinear, float[][] coefs, T3[] points) {
        boolean doNormalize;
        String calculationType = (String)moData.get("calculationType");
        Lst shells = (Lst)moData.get("shells");
        float[][] gaussians = (float[][])moData.get("gaussians");
        Object slaters = moData.get("slaters");
        this.highLEnabled = (int[])moData.get("highLEnabled");
        this.havePoints = points != null;
        this.calculationType = calculationType;
        this.firstAtomOffset = firstAtomOffset;
        this.shells = shells;
        this.gaussians = gaussians;
        this.dfCoefMaps = dfCoefMaps == null ? QS.getNewDfCoefMap() : dfCoefMaps;
        this.coeffs = new double[this.dfCoefMaps[this.dfCoefMaps.length - 1].length];
        this.slaters = (SlaterData[])slaters;
        this.moCoefficients = moCoefficients;
        this.linearCombination = linearCombination;
        this.isSquaredLinear = isSquaredLinear;
        this.coefs = coefs;
        boolean bl = doNormalize = isSlaters || moData.get("isNormalized") != Boolean.TRUE;
        if (doNormalize) {
            this.setNormalization(moData.get("nboType"));
        }
        this.countsXYZ = volumeData.getVoxelCounts();
        this.initialize(this.countsXYZ[0], this.countsXYZ[1], this.countsXYZ[2], points);
        this.voxelData = volumeData.getVoxelData();
        this.voxelDataTemp = isSquaredLinear ? new float[this.nX][this.nY][this.nZ] : this.voxelData;
        this.setupCoordinates(volumeData.getOriginFloat(), volumeData.getVolumetricVectorLengths(), bsSelected, xyz, atoms, points, false);
        this.doDebug = Logger.debugging;
        return !bsSelected.isEmpty() && (slaters != null || this.checkCalculationType());
    }

    private void setNormalization(Object nboType) {
        String type = "standard";
        this.normType = 1;
        if (nboType != null) {
            this.normType = 3;
            type = "NBO-AO";
        } else if (this.calculationType != null && this.calculationType.indexOf("NWCHEM") >= 0) {
            this.normType = 2;
            type = "NWCHEM";
            Logger.info("Normalization of contractions (NWCHEM)");
        }
        Logger.info("Normalizing AOs: " + type + " slaters:" + (this.slaters != null));
    }

    @Override
    public void initialize(int nX, int nY, int nZ, T3[] points) {
        this.initialize0(nX, nY, nZ, points);
        this.CX = new double[this.nX];
        this.CY = new double[this.nY];
        this.CZ = new double[this.nZ];
        this.DXY = new double[this.nX];
        this.DXZ = new double[this.nX];
        this.DYZ = new double[this.nY];
        this.EX = new double[this.nX];
        this.EY = new double[this.nY];
        this.EZ = new double[this.nZ];
    }

    @Override
    public void createCube() {
        this.setXYZBohr(this.points);
        this.processPoints();
        if (!this.isSquaredLinear && (this.doDebug || this.testing)) {
            this.calculateElectronDensity();
        }
    }

    @Override
    public void processPoints() {
        if (this.linearCombination == null) {
            this.process();
        } else {
            int i;
            if (this.sum < 0.0) {
                this.sum = 0.0;
                for (i = 0; i < this.linearCombination.length; i += 2) {
                    this.sum += (double)(this.linearCombination[i] * this.linearCombination[i]);
                }
                this.sum = Math.sqrt(this.sum);
            }
            if (this.sum == 0.0) {
                return;
            }
            for (i = 0; i < this.linearCombination.length; i += 2) {
                this.moFactor = (double)this.linearCombination[i] / this.sum;
                if (this.moFactor == 0.0) continue;
                this.moCoefficients = this.coefs[(int)this.linearCombination[i + 1] - 1];
                this.process();
                if (!this.isSquaredLinear) continue;
                this.addValuesSquared(1.0f);
            }
        }
    }

    @Override
    public void process() {
        this.atomIndex = this.firstAtomOffset - 1;
        this.moCoeff = 0;
        if (this.slaters == null) {
            int nShells = this.shells.size();
            for (int i = 0; i < nShells; ++i) {
                this.processShell(i);
            }
            return;
        }
        for (int i = 0; i < this.slaters.length && this.processSlater(i); ++i) {
        }
    }

    private boolean checkCalculationType() {
        if (this.calculationType == null) {
            Logger.warn("calculation type not identified -- continuing");
            return true;
        }
        if (this.calculationType.indexOf("+") >= 0 || this.calculationType.indexOf("*") >= 0) {
            Logger.warn("polarization/diffuse wavefunctions have not been tested fully: " + this.calculationType + " -- continuing");
        }
        if (this.calculationType.indexOf("?") >= 0) {
            Logger.warn("unknown calculation type may not render correctly -- continuing");
        } else if (this.points == null) {
            Logger.info("calculation type: " + this.calculationType + " OK.");
        }
        return true;
    }

    private void processShell(int iShell) {
        int lastAtom = this.atomIndex;
        int[] shell = (int[])this.shells.get(iShell);
        this.atomIndex = shell[0] - 1 + this.firstAtomOffset;
        int basisType = shell[1];
        this.gaussianPtr = shell[2] - 1;
        this.nGaussians = shell[3];
        this.doShowShellType = this.doDebug;
        if (this.atomIndex != lastAtom && (this.thisAtom = this.qmAtoms[this.atomIndex]) != null) {
            this.thisAtom.setXYZ(this, true);
        }
        if (!this.allowType(basisType) || !this.setCoeffs(shell[1], true)) {
            return;
        }
        if (this.havePoints) {
            this.setMinMax(-1);
        }
        switch (basisType) {
            case 0: {
                this.addDataS();
                break;
            }
            case 1: {
                this.addDataP();
                break;
            }
            case 2: {
                this.addDataSP();
                break;
            }
            case 3: {
                this.addData5D();
                break;
            }
            case 4: {
                this.addData6D();
                break;
            }
            default: {
                String key;
                if (this.addHighL(basisType)) {
                    return;
                }
                if (this.warned == null) {
                    this.warned = "";
                }
                if (this.warned.indexOf(key = "=" + (this.atomIndex + 1) + ": " + QS.getQuantumShellTag(basisType)) >= 0) break;
                this.warned = this.warned + key;
                Logger.warn(" Unsupported basis type for atomno" + key);
            }
        }
    }

    private boolean addHighL(int basisType) {
        if (!this.allowType(basisType)) {
            return false;
        }
        DataAdder adder = this.dataAdders[basisType];
        switch (this.dataAdderOK[basisType]) {
            case 0: {
                this.dataAdders[basisType] = adder = (DataAdder)Interface.getInterface("org.jmol.quantum.mo.DataAdder" + QS.getQuantumShellTag(basisType));
                int n = this.dataAdderOK[basisType] = adder == null ? -1 : 1;
                if (adder != null) break;
            }
            case -1: {
                return false;
            }
        }
        if (adder.addData(this, this.havePoints)) {
            return true;
        }
        this.dataAdders[basisType] = null;
        this.dataAdderOK[basisType] = -1;
        return false;
    }

    private boolean allowType(int basisType) {
        return basisType < 7 || this.highLEnabled[basisType] != 0;
    }

    private void addValuesSquared(float occupancy) {
        int ix = this.nX;
        while (--ix >= 0) {
            int iy = this.nY;
            while (--iy >= 0) {
                int iz = this.nZ;
                while (--iz >= 0) {
                    float value = this.voxelDataTemp[ix][iy][iz];
                    if (value == 0.0f) continue;
                    float[] fArray = this.voxelData[ix][iy];
                    int n = iz;
                    fArray[n] = fArray[n] + value * value * occupancy;
                    this.voxelDataTemp[ix][iy][iz] = 0.0f;
                }
            }
        }
    }

    public double getContractionNormalization(int el, int cpt) {
        double sum;
        double df = el == 3 ? 15 : (el == 2 ? 3 : 1);
        double f = df * Math.pow(Math.PI, 1.5) / Math.pow(2.0, el);
        double p = 0.75 + (double)el / 2.0;
        if (this.nGaussians == 1) {
            sum = Math.pow(2.0, -2.0 * p) * Math.pow(this.gaussians[this.gaussianPtr][cpt], 2.0);
        } else {
            sum = 0.0;
            for (int ig1 = 0; ig1 < this.nGaussians; ++ig1) {
                double alpha1 = this.gaussians[this.gaussianPtr + ig1][0];
                double c1 = this.gaussians[this.gaussianPtr + ig1][cpt];
                double f1 = Math.pow(alpha1, p);
                for (int ig2 = 0; ig2 < this.nGaussians; ++ig2) {
                    double alpha2 = this.gaussians[this.gaussianPtr + ig2][0];
                    double c2 = this.gaussians[this.gaussianPtr + ig2][cpt];
                    double f2 = Math.pow(alpha2, p);
                    sum += c1 * f1 * c2 * f2 / Math.pow(alpha1 + alpha2, 2.0 * p);
                }
            }
        }
        sum = 1.0 / Math.sqrt(f * sum);
        if (Logger.debuggingHigh) {
            Logger.debug("\t\t\tnormalization for l=" + el + " nGaussians=" + this.nGaussians + " is " + sum);
        }
        return sum;
    }

    private boolean setCoeffs(int type, boolean isProcess) {
        boolean isOK = false;
        this.map = this.dfCoefMaps[type];
        if (isProcess && this.thisAtom == null) {
            this.moCoeff += this.map.length;
            return false;
        }
        for (int i = 0; i < this.map.length; ++i) {
            if (this.map[i] + this.moCoeff >= this.moCoefficients.length) {
                System.out.println("OHOH");
            }
            isOK |= (this.coeffs[i] = (double)this.moCoefficients[this.map[i] + this.moCoeff++]) != 0.0;
        }
        if ((isOK &= this.coeffs[0] != -2.147483648E9) && this.doDebug && isProcess) {
            this.dumpInfo(type);
        }
        return isOK;
    }

    private void addDataS() {
        double norm;
        boolean normalizeAlpha = false;
        switch (this.normType) {
            default: {
                norm = 1.0;
                break;
            }
            case 1: {
                norm = 0.7127054929733276;
                normalizeAlpha = true;
                break;
            }
            case 2: {
                norm = this.getContractionNormalization(0, 1);
                normalizeAlpha = true;
            }
        }
        double m1 = this.coeffs[0];
        for (int ig = 0; ig < this.nGaussians; ++ig) {
            double alpha = this.gaussians[this.gaussianPtr + ig][0];
            double c1 = this.gaussians[this.gaussianPtr + ig][1];
            double a = norm * m1 * c1 * this.moFactor;
            if (normalizeAlpha) {
                a *= Math.pow(alpha, 0.75);
            }
            int i = this.xMax;
            while (--i >= this.xMin) {
                this.EX[i] = a * Math.exp((double)(-this.X2[i]) * alpha);
            }
            i = this.yMax;
            while (--i >= this.yMin) {
                this.EY[i] = Math.exp((double)(-this.Y2[i]) * alpha);
            }
            i = this.zMax;
            while (--i >= this.zMin) {
                this.EZ[i] = Math.exp((double)(-this.Z2[i]) * alpha);
            }
            int ix = this.xMax;
            while (--ix >= this.xMin) {
                double eX = this.EX[ix];
                if (this.havePoints) {
                    this.setMinMax(ix);
                }
                int iy = this.yMax;
                while (--iy >= this.yMin) {
                    double eXY = eX * this.EY[iy];
                    float[] vd = this.voxelDataTemp[ix][this.havePoints ? 0 : iy];
                    int iz = this.zMax;
                    while (--iz >= this.zMin) {
                        int n = this.havePoints ? 0 : iz;
                        vd[n] = (float)((double)vd[n] + eXY * this.EZ[iz]);
                    }
                }
            }
        }
    }

    private void addDataP() {
        double norm;
        double mx = this.coeffs[0];
        double my = this.coeffs[1];
        double mz = this.coeffs[2];
        boolean normalizeAlpha = false;
        switch (this.normType) {
            default: {
                norm = 1.0;
                break;
            }
            case 1: {
                norm = 1.425411f;
                normalizeAlpha = true;
                break;
            }
            case 2: {
                norm = this.getContractionNormalization(1, 1);
                normalizeAlpha = true;
            }
        }
        for (int ig = 0; ig < this.nGaussians; ++ig) {
            double c1;
            double alpha = this.gaussians[this.gaussianPtr + ig][0];
            double a = c1 = (double)this.gaussians[this.gaussianPtr + ig][1];
            if (normalizeAlpha) {
                a *= Math.pow(alpha, 1.25) * norm;
            }
            this.calcSP(alpha, 0.0, a * mx, a * my, a * mz);
        }
    }

    private void addDataSP() {
        double norm1;
        double norm2;
        boolean isP = this.map.length == 3;
        int pPt = isP ? 0 : 1;
        double ms = isP ? 0.0 : this.coeffs[0];
        double mx = this.coeffs[pPt++];
        double my = this.coeffs[pPt++];
        double mz = this.coeffs[pPt++];
        boolean doNormalize = false;
        switch (this.normType) {
            default: {
                norm2 = 1.0;
                norm1 = 1.0;
                break;
            }
            case 1: {
                norm1 = 0.7127054929733276;
                norm2 = 1.425411f;
                doNormalize = true;
                break;
            }
            case 2: {
                norm1 = this.getContractionNormalization(0, 1);
                norm2 = this.getContractionNormalization(1, 2);
                doNormalize = true;
            }
        }
        for (int ig = 0; ig < this.nGaussians; ++ig) {
            double alpha = this.gaussians[this.gaussianPtr + ig][0];
            double c1 = this.gaussians[this.gaussianPtr + ig][1];
            double c2 = this.gaussians[this.gaussianPtr + ig][2];
            double a1 = c1;
            double a2 = c2;
            if (doNormalize) {
                a1 *= Math.pow(alpha, 0.75) * norm1;
                a2 *= Math.pow(alpha, 1.25) * norm2;
            }
            this.calcSP(alpha, a1 * ms, a2 * mx, a2 * my, a2 * mz);
        }
    }

    private void setCE(double alpha, double as, double ax, double ay, double az) {
        int i = this.xMax;
        while (--i >= this.xMin) {
            this.CX[i] = as + ax * (double)this.X[i];
            this.EX[i] = Math.exp((double)(-this.X2[i]) * alpha) * this.moFactor;
        }
        i = this.yMax;
        while (--i >= this.yMin) {
            this.CY[i] = ay * (double)this.Y[i];
            this.EY[i] = Math.exp((double)(-this.Y2[i]) * alpha);
        }
        i = this.zMax;
        while (--i >= this.zMin) {
            this.CZ[i] = az * (double)this.Z[i];
            this.EZ[i] = Math.exp((double)(-this.Z2[i]) * alpha);
        }
    }

    public void setE(double[] EX, double alpha) {
        int i = this.xMax;
        while (--i >= this.xMin) {
            EX[i] = Math.exp((double)(-this.X2[i]) * alpha) * this.moFactor;
        }
        i = this.yMax;
        while (--i >= this.yMin) {
            this.EY[i] = Math.exp((double)(-this.Y2[i]) * alpha);
        }
        i = this.zMax;
        while (--i >= this.zMin) {
            this.EZ[i] = Math.exp((double)(-this.Z2[i]) * alpha);
        }
    }

    private void calcSP(double alpha, double as, double ax, double ay, double az) {
        this.setCE(alpha, as, ax, ay, az);
        int ix = this.xMax;
        while (--ix >= this.xMin) {
            double eX = this.EX[ix];
            double cX = this.CX[ix];
            if (this.havePoints) {
                this.setMinMax(ix);
            }
            int iy = this.yMax;
            while (--iy >= this.yMin) {
                double eXY = eX * this.EY[iy];
                double cXY = cX + this.CY[iy];
                float[] vd = this.voxelDataTemp[ix][this.havePoints ? 0 : iy];
                int iz = this.zMax;
                while (--iz >= this.zMin) {
                    int n = this.havePoints ? 0 : iz;
                    vd[n] = (float)((double)vd[n] + (cXY + this.CZ[iz]) * eXY * this.EZ[iz]);
                }
            }
        }
    }

    private void addData6D() {
        double norm2;
        double norm1;
        double mxx = this.coeffs[0];
        double myy = this.coeffs[1];
        double mzz = this.coeffs[2];
        double mxy = this.coeffs[3];
        double mxz = this.coeffs[4];
        double myz = this.coeffs[5];
        boolean normalizeAlpha = false;
        switch (this.normType) {
            default: {
                norm1 = 1.0;
                norm2 = 0.5773502795520422;
                break;
            }
            case 1: {
                norm1 = 2.850822f;
                norm2 = norm1 / 1.7320507764816284;
                normalizeAlpha = true;
                break;
            }
            case 2: {
                norm1 = norm2 = this.getContractionNormalization(2, 1);
                normalizeAlpha = true;
                break;
            }
            case 3: {
                norm1 = 1.7320507764816284;
                norm2 = 1.0;
            }
        }
        for (int ig = 0; ig < this.nGaussians; ++ig) {
            double c1;
            double alpha = this.gaussians[this.gaussianPtr + ig][0];
            double a = c1 = (double)this.gaussians[this.gaussianPtr + ig][1];
            if (normalizeAlpha) {
                a *= Math.pow(alpha, 1.75);
            }
            double axy = a * norm1 * mxy;
            double axz = a * norm1 * mxz;
            double ayz = a * norm1 * myz;
            double axx = a * norm2 * mxx;
            double ayy = a * norm2 * myy;
            double azz = a * norm2 * mzz;
            this.setCE(alpha, 0.0, axx, ayy, azz);
            int i = this.xMax;
            while (--i >= this.xMin) {
                this.DXY[i] = axy * (double)this.X[i];
                this.DXZ[i] = axz * (double)this.X[i];
            }
            i = this.yMax;
            while (--i >= this.yMin) {
                this.DYZ[i] = ayz * (double)this.Y[i];
            }
            int ix = this.xMax;
            while (--ix >= this.xMin) {
                double axx_x2 = this.CX[ix] * (double)this.X[ix];
                double axy_x = this.DXY[ix];
                double axz_x = this.DXZ[ix];
                double eX = this.EX[ix];
                if (this.havePoints) {
                    this.setMinMax(ix);
                }
                int iy = this.yMax;
                while (--iy >= this.yMin) {
                    double axx_x2__ayy_y2__axy_xy = axx_x2 + (this.CY[iy] + axy_x) * (double)this.Y[iy];
                    double axz_x__ayz_y = axz_x + this.DYZ[iy];
                    double eXY = eX * this.EY[iy];
                    float[] vd = this.voxelDataTemp[ix][this.havePoints ? 0 : iy];
                    int iz = this.zMax;
                    while (--iz >= this.zMin) {
                        int n = this.havePoints ? 0 : iz;
                        vd[n] = (float)((double)vd[n] + (axx_x2__ayy_y2__axy_xy + (this.CZ[iz] + axz_x__ayz_y) * (double)this.Z[iz]) * eXY * this.EZ[iz]);
                    }
                }
            }
        }
    }

    private void addData5D() {
        double norm1;
        double norm2;
        double norm3;
        double norm4;
        double norm5;
        boolean normalizeAlpha = false;
        switch (this.normType) {
            default: {
                norm5 = 1.0;
                norm4 = 1.0;
                norm3 = 1.0;
                norm2 = 1.0;
                norm1 = 1.0;
                break;
            }
            case 3: {
                norm4 = 1.0;
                norm2 = 1.0;
                norm1 = 3.464101552963257;
                norm3 = 1.7320507764816284;
                norm5 = 2.0;
                break;
            }
            case 1: {
                norm1 = Math.pow(66.05114251919257, 0.25);
                norm2 = norm1 / 1.7320507764816284;
                norm3 = 0.8660253882408142;
                norm5 = 1.0;
                norm4 = 1.0;
                normalizeAlpha = true;
                break;
            }
            case 2: {
                norm2 = this.getContractionNormalization(2, 1);
                norm1 = norm2 * 1.7320507764816284;
                norm3 = 0.8660253882408142;
                norm4 = -1.0;
                norm5 = 1.0;
                normalizeAlpha = true;
            }
        }
        double m0 = this.coeffs[0];
        double m1p = this.coeffs[1];
        double m1n = this.coeffs[2];
        double m2p = this.coeffs[3];
        double m2n = this.coeffs[4];
        for (int ig = 0; ig < this.nGaussians; ++ig) {
            double c1;
            double alpha = this.gaussians[this.gaussianPtr + ig][0];
            double a = c1 = (double)this.gaussians[this.gaussianPtr + ig][1];
            if (normalizeAlpha) {
                a *= Math.pow(alpha, 1.75);
            }
            double ad0 = a * m0;
            double ad1p = norm4 * a * m1p;
            double ad1n = a * m1n;
            double ad2p = a * m2p;
            double ad2n = a * m2n;
            this.setE(this.EX, alpha);
            int ix = this.xMax;
            while (--ix >= this.xMin) {
                double x = this.X[ix];
                double eX = this.EX[ix];
                double cxx = norm2 * x * x;
                if (this.havePoints) {
                    this.setMinMax(ix);
                }
                int iy = this.yMax;
                while (--iy >= this.yMin) {
                    double y = this.Y[iy];
                    double eXY = eX * this.EY[iy];
                    double cyy = norm2 * y * y;
                    double cxy = norm1 * x * y;
                    float[] vd = this.voxelDataTemp[ix][this.havePoints ? 0 : iy];
                    int iz = this.zMax;
                    while (--iz >= this.zMin) {
                        double z = this.Z[iz];
                        double czz = norm2 * z * z;
                        double cxz = norm1 * x * z;
                        double cyz = norm1 * y * z;
                        int n = this.havePoints ? 0 : iz;
                        vd[n] = (float)((double)vd[n] + (ad0 * norm5 * (czz - 0.5 * (cxx + cyy)) + ad1p * cxz + ad1n * cyz + ad2p * norm3 * (cxx - cyy) + ad2n * cxy) * eXY * this.EZ[iz]);
                    }
                }
            }
        }
    }

    private boolean processSlater(int slaterIndex) {
        double coef;
        int lastAtom = this.atomIndex;
        SlaterData slater = this.slaters[slaterIndex];
        this.atomIndex = slater.atomNo - 1;
        double minuszeta = -slater.zeta;
        this.thisAtom = this.qmAtoms[this.atomIndex];
        if (this.thisAtom == null) {
            if (minuszeta <= 0.0) {
                ++this.moCoeff;
            }
            return true;
        }
        if (minuszeta > 0.0) {
            minuszeta = -minuszeta;
            --this.moCoeff;
        }
        if (this.moCoeff >= this.moCoefficients.length) {
            return false;
        }
        if ((coef = slater.coef * (double)this.moCoefficients[this.moCoeff++]) == 0.0) {
            this.atomIndex = -1;
            return true;
        }
        coef *= this.moFactor;
        if (this.atomIndex != lastAtom) {
            this.thisAtom.setXYZ(this, true);
        }
        int a = slater.x;
        int b = slater.y;
        int c = slater.z;
        int d = slater.r;
        if (a == -2) {
            int ix = this.xMax;
            while (--ix >= this.xMin) {
                double dx2 = this.X2[ix];
                if (this.havePoints) {
                    this.setMinMax(ix);
                }
                int iy = this.yMax;
                while (--iy >= this.yMin) {
                    double dy2 = this.Y2[iy];
                    double dx2y2 = dx2 + dy2;
                    float[] vd = this.voxelDataTemp[ix][this.havePoints ? 0 : iy];
                    int iz = this.zMax;
                    while (--iz >= this.zMin) {
                        double dz2 = this.Z2[iz];
                        double r2 = dx2y2 + dz2;
                        double r = Math.sqrt(r2);
                        double exponent = minuszeta * r;
                        if (exponent < -50.0) continue;
                        double value = coef * Math.exp(exponent) * (3.0 * dz2 - r2);
                        switch (d) {
                            case 3: {
                                value *= r;
                            }
                            case 2: {
                                value *= r2;
                                break;
                            }
                            case 1: {
                                value *= r;
                            }
                        }
                        int n = this.havePoints ? 0 : iz;
                        vd[n] = (float)((double)vd[n] + value);
                    }
                }
            }
        } else if (b == -2) {
            int ix = this.xMax;
            while (--ix >= this.xMin) {
                double dx2 = this.X2[ix];
                if (this.havePoints) {
                    this.setMinMax(ix);
                }
                int iy = this.yMax;
                while (--iy >= this.yMin) {
                    double dy2 = this.Y2[iy];
                    double dx2y2 = dx2 + dy2;
                    double dx2my2 = coef * (dx2 - dy2);
                    float[] vd = this.voxelDataTemp[ix][this.havePoints ? 0 : iy];
                    int iz = this.zMax;
                    while (--iz >= this.zMin) {
                        double dz2 = this.Z2[iz];
                        double r2 = dx2y2 + dz2;
                        double r = Math.sqrt(r2);
                        double exponent = minuszeta * r;
                        if (exponent < -50.0) continue;
                        double value = dx2my2 * Math.exp(exponent);
                        switch (d) {
                            case 3: {
                                value *= r;
                            }
                            case 2: {
                                value *= r2;
                                break;
                            }
                            case 1: {
                                value *= r;
                            }
                        }
                        int n = this.havePoints ? 0 : iz;
                        vd[n] = (float)((double)vd[n] + value);
                    }
                }
            }
        } else {
            int ix = this.xMax;
            while (--ix >= this.xMin) {
                double dx2 = this.X2[ix];
                double vdx = coef;
                switch (a) {
                    case 3: {
                        vdx *= (double)this.X[ix];
                    }
                    case 2: {
                        vdx *= dx2;
                        break;
                    }
                    case 1: {
                        vdx *= (double)this.X[ix];
                    }
                }
                if (this.havePoints) {
                    this.setMinMax(ix);
                }
                int iy = this.yMax;
                while (--iy >= this.yMin) {
                    double dy2 = this.Y2[iy];
                    double dx2y2 = dx2 + dy2;
                    double vdy = vdx;
                    switch (b) {
                        case 3: {
                            vdy *= (double)this.Y[iy];
                        }
                        case 2: {
                            vdy *= dy2;
                            break;
                        }
                        case 1: {
                            vdy *= (double)this.Y[iy];
                        }
                    }
                    float[] vd = this.voxelDataTemp[ix][this.havePoints ? 0 : iy];
                    int iz = this.zMax;
                    while (--iz >= this.zMin) {
                        double dz2 = this.Z2[iz];
                        double r2 = dx2y2 + dz2;
                        double r = Math.sqrt(r2);
                        double exponent = minuszeta * r;
                        if (exponent < -50.0) continue;
                        double value = vdy * Math.exp(exponent);
                        switch (c) {
                            case 3: {
                                value *= (double)this.Z[iz];
                            }
                            case 2: {
                                value *= dz2;
                                break;
                            }
                            case 1: {
                                value *= (double)this.Z[iz];
                            }
                        }
                        switch (d) {
                            case 3: {
                                value *= r;
                            }
                            case 2: {
                                value *= r2;
                                break;
                            }
                            case 1: {
                                value *= r;
                            }
                        }
                        int n = this.havePoints ? 0 : iz;
                        vd[n] = (float)((double)vd[n] + value);
                    }
                }
            }
        }
        return true;
    }

    private void dumpInfo(int shell) {
        if (this.doShowShellType) {
            Logger.debug("\n\t\t\tprocessShell: " + shell + " type=" + QS.getQuantumShellTag(shell) + " nGaussians=" + this.nGaussians + " atom=" + this.atomIndex);
            this.doShowShellType = false;
        }
        if (Logger.isActiveLevel(6) && this.gaussianPtr != this.lastGaussianPtr) {
            this.lastGaussianPtr = this.gaussianPtr;
            for (int ig = 0; ig < this.nGaussians; ++ig) {
                double alpha = this.gaussians[this.gaussianPtr + ig][0];
                double c1 = this.gaussians[this.gaussianPtr + ig][1];
                Logger.debug("\t\t\tGaussian " + (ig + 1) + " alpha=" + alpha + " c=" + c1);
            }
        }
        String[] so = MOCalculation.getShellOrder(shell);
        for (int i = 0; i < this.map.length; ++i) {
            int n = this.map[i] + this.moCoeff - this.map.length + i + 1;
            double c = this.coeffs[i];
            Logger.debug("MO coeff " + (so == null ? "?" : so[i]) + " " + n + "\t" + c + "\t" + this.thisAtom.atom);
        }
    }

    private static final String[] getShellOrder(int i) {
        return i < 0 || i >= shellOrder.length ? null : shellOrder[i];
    }

    public void calculateElectronDensity() {
        if (this.points != null) {
            return;
        }
        this.integration = 0.0f;
        int ix = this.nX;
        while (--ix >= 0) {
            int iy = this.nY;
            while (--iy >= 0) {
                int iz = this.nZ;
                while (--iz >= 0) {
                    float x = this.voxelData[ix][iy][iz];
                    this.integration += x * x;
                }
            }
        }
        float volume = this.stepBohr[0] * this.stepBohr[1] * this.stepBohr[2];
        this.integration *= volume;
        Logger.info("Integrated density = " + this.integration);
    }
}

