/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.mappaint.mapcss;

import java.util.Arrays;
import org.openstreetmap.josm.gui.mappaint.Cascade;
import org.openstreetmap.josm.gui.mappaint.Environment;
import org.openstreetmap.josm.gui.mappaint.Keyword;
import org.openstreetmap.josm.gui.mappaint.MapPaintStyles;
import org.openstreetmap.josm.gui.mappaint.StyleKeys;
import org.openstreetmap.josm.gui.mappaint.mapcss.Expression;
import org.openstreetmap.josm.gui.mappaint.mapcss.LiteralExpression;
import org.openstreetmap.josm.tools.Logging;

@FunctionalInterface
public interface Instruction
extends StyleKeys {
    public void execute(Environment var1);

    public static class AssignmentInstruction
    implements Instruction {
        public final String key;
        public final Object val;
        public final boolean isSetInstruction;

        public AssignmentInstruction(String key, Object val, boolean isSetInstruction) {
            String s;
            Object litValue;
            this.key = key.intern();
            this.isSetInstruction = isSetInstruction;
            this.val = val instanceof LiteralExpression ? ((litValue = ((LiteralExpression)val).evaluate(null)) instanceof Keyword && "none".equals(((Keyword)litValue).val) ? null : ("text".equals(key) ? (litValue.equals(Keyword.AUTO) ? Keyword.AUTO : ((s = Cascade.convertTo(litValue, String.class)) != null ? new MapPaintStyles.TagKeyReference(s) : litValue)) : litValue)) : val;
        }

        @Override
        public void execute(Environment env) {
            Object value;
            if (this.val instanceof Expression) {
                try {
                    value = ((Expression)this.val).evaluate(env);
                }
                catch (RuntimeException ex) {
                    Logging.error(ex);
                    value = null;
                }
            } else {
                value = this.val;
            }
            if (("icon-image".equals(this.key) || "fill-image".equals(this.key) || "repeat-image".equals(this.key)) && value instanceof String) {
                value = new MapPaintStyles.IconReference((String)value, env.source);
            }
            env.mc.getOrCreateCascade(env.layer).putOrClear(this.key, value);
        }

        public String toString() {
            return this.key + ": " + (this.val instanceof float[] ? Arrays.toString((float[])this.val) : (this.val instanceof String ? "String<" + this.val + '>' : this.val)) + ';';
        }
    }

    public static class RelativeFloat {
        public final float val;

        public RelativeFloat(float val) {
            this.val = val;
        }

        public String toString() {
            return "RelativeFloat{val=" + this.val + '}';
        }
    }
}

