/*
 * Decompiled with CFR 0.152.
 */
package sun.security.rsa;

import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.KeyPair;
import java.security.KeyPairGeneratorSpi;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.RSAKeyGenParameterSpec;
import sun.security.jca.JCAUtil;
import sun.security.rsa.RSAKeyFactory;
import sun.security.rsa.RSAPrivateCrtKeyImpl;
import sun.security.rsa.RSAPublicKeyImpl;
import sun.security.util.SecurityProviderConstants;

public final class RSAKeyPairGenerator
extends KeyPairGeneratorSpi {
    private BigInteger publicExponent;
    private int keySize;
    private SecureRandom random;

    public RSAKeyPairGenerator() {
        this.initialize(SecurityProviderConstants.DEF_RSA_KEY_SIZE, null);
    }

    @Override
    public void initialize(int keySize, SecureRandom random) {
        try {
            RSAKeyFactory.checkKeyLengths(keySize, RSAKeyGenParameterSpec.F4, 512, 65536);
        }
        catch (InvalidKeyException e) {
            throw new InvalidParameterException(e.getMessage());
        }
        this.keySize = keySize;
        this.random = random;
        this.publicExponent = RSAKeyGenParameterSpec.F4;
    }

    @Override
    public void initialize(AlgorithmParameterSpec params, SecureRandom random) throws InvalidAlgorithmParameterException {
        if (!(params instanceof RSAKeyGenParameterSpec)) {
            throw new InvalidAlgorithmParameterException("Params must be instance of RSAKeyGenParameterSpec");
        }
        RSAKeyGenParameterSpec rsaSpec = (RSAKeyGenParameterSpec)params;
        int tmpKeySize = rsaSpec.getKeysize();
        BigInteger tmpPublicExponent = rsaSpec.getPublicExponent();
        if (tmpPublicExponent == null) {
            tmpPublicExponent = RSAKeyGenParameterSpec.F4;
        } else {
            if (tmpPublicExponent.compareTo(RSAKeyGenParameterSpec.F0) < 0) {
                throw new InvalidAlgorithmParameterException("Public exponent must be 3 or larger");
            }
            if (tmpPublicExponent.bitLength() > tmpKeySize) {
                throw new InvalidAlgorithmParameterException("Public exponent must be smaller than key size");
            }
        }
        try {
            RSAKeyFactory.checkKeyLengths(tmpKeySize, tmpPublicExponent, 512, 65536);
        }
        catch (InvalidKeyException e) {
            throw new InvalidAlgorithmParameterException("Invalid key sizes", e);
        }
        this.keySize = tmpKeySize;
        this.publicExponent = tmpPublicExponent;
        this.random = random;
    }

    @Override
    public KeyPair generateKeyPair() {
        BigInteger n;
        BigInteger q;
        BigInteger q1;
        BigInteger p;
        BigInteger p1;
        BigInteger phi;
        int lp = this.keySize + 1 >> 1;
        int lq = this.keySize - lp;
        if (this.random == null) {
            this.random = JCAUtil.getSecureRandom();
        }
        BigInteger e = this.publicExponent;
        do {
            p = BigInteger.probablePrime(lp, this.random);
            do {
                if (p.compareTo(q = BigInteger.probablePrime(lq, this.random)) >= 0) continue;
                BigInteger tmp = p;
                p = q;
                q = tmp;
            } while ((n = p.multiply(q)).bitLength() < this.keySize);
        } while (!e.gcd(phi = (p1 = p.subtract(BigInteger.ONE)).multiply(q1 = q.subtract(BigInteger.ONE))).equals(BigInteger.ONE));
        BigInteger d = e.modInverse(phi);
        BigInteger pe = d.mod(p1);
        BigInteger qe = d.mod(q1);
        BigInteger coeff = q.modInverse(p);
        try {
            RSAPublicKeyImpl publicKey = new RSAPublicKeyImpl(n, e);
            RSAPrivateCrtKeyImpl privateKey = new RSAPrivateCrtKeyImpl(n, e, d, p, q, pe, qe, coeff);
            return new KeyPair(publicKey, privateKey);
        }
        catch (InvalidKeyException exc) {
            throw new RuntimeException(exc);
        }
    }
}

