/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf.swingx.ui;

import com.formdev.flatlaf.ui.FlatLineBorder;
import com.formdev.flatlaf.util.UIScale;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.geom.Rectangle2D;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import org.jdesktop.swingx.JXTitledPanel;
import org.jdesktop.swingx.SwingXUtilities;
import org.jdesktop.swingx.painter.MattePainter;
import org.jdesktop.swingx.plaf.PainterUIResource;
import org.jdesktop.swingx.plaf.basic.BasicTitledPanelUI;

public class FlatTitledPanelUI
extends BasicTitledPanelUI {
    public static ComponentUI createUI(JComponent c) {
        return new FlatTitledPanelUI();
    }

    @Override
    protected void installDefaults(JXTitledPanel titledPanel) {
        super.installDefaults(titledPanel);
        this.installProperty(titledPanel, "titlePainter", new PainterUIResource<Object>(new TitlePainter(UIManager.getColor("JXTitledPanel.titleBackground"), UIManager.getColor("JXTitledPanel.borderColor"))));
    }

    @Override
    protected void installComponents(JXTitledPanel titledPanel) {
        super.installComponents(titledPanel);
        if (SwingXUtilities.isUIInstallable(titledPanel.getBorder())) {
            titledPanel.setBorder(new FlatLineBorder(new Insets(1, 1, 1, 1), UIManager.getColor("JXTitledPanel.borderColor")));
        }
    }

    @Override
    protected Insets getCaptionInsets() {
        return UIScale.scale(super.getCaptionInsets());
    }

    private static class TitlePainter
    extends MattePainter {
        private final Color borderColor;

        TitlePainter(Color color, Color borderColor) {
            super(color);
            this.borderColor = borderColor;
        }

        @Override
        protected void doPaint(Graphics2D g2, Object component, int width, int height) {
            super.doPaint(g2, component, width, height);
            float h2 = UIScale.scale(1.0f);
            g2.setColor(this.borderColor);
            g2.fill(new Rectangle2D.Float(0.0f, (float)height - h2, width, h2));
        }
    }
}

