/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.utils;

import com.jidesoft.range.BigDecimalRange;
import com.jidesoft.range.Range;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeSet;

public final class BigDecimalMathUtils {
    public static final BigDecimal TWO = BigDecimal.valueOf(2L);

    protected BigDecimalMathUtils() {
    }

    public static BigDecimal sum(List<BigDecimal> numbers) {
        BigDecimal sum = new BigDecimal(0);
        for (BigDecimal bigDecimal : numbers) {
            sum = sum.add(bigDecimal);
        }
        return sum;
    }

    public static BigDecimal mean(List<BigDecimal> numbers, MathContext context) {
        BigDecimal sum = BigDecimalMathUtils.sum(numbers);
        return sum.divide(new BigDecimal(numbers.size()), context);
    }

    public static BigDecimal min(List<BigDecimal> numbers) {
        return new TreeSet<BigDecimal>(numbers).first();
    }

    public static BigDecimal max(List<BigDecimal> numbers) {
        return new TreeSet<BigDecimal>(numbers).last();
    }

    public static Range<BigDecimal> range(List<BigDecimal> numbers) {
        TreeSet<BigDecimal> decimals = new TreeSet<BigDecimal>(numbers);
        return new BigDecimalRange(decimals.first(), decimals.last());
    }

    public static BigDecimal stddev(List<BigDecimal> numbers, boolean biasCorrected, MathContext context) {
        int n = numbers.size();
        BigDecimal stddev = n > 0 ? (n > 1 ? BigDecimalMathUtils.sqrt(BigDecimalMathUtils.var(numbers, biasCorrected, context)) : BigDecimal.ZERO) : BigDecimal.valueOf(Double.NaN);
        return stddev;
    }

    public static BigDecimal var(List<BigDecimal> numbers, boolean biasCorrected, MathContext context) {
        int n = numbers.size();
        if (n == 0) {
            return BigDecimal.valueOf(Double.NaN);
        }
        if (n == 1) {
            return BigDecimal.ZERO;
        }
        BigDecimal mean = BigDecimalMathUtils.mean(numbers, context);
        ArrayList<BigDecimal> squares = new ArrayList<BigDecimal>();
        for (BigDecimal number : numbers) {
            BigDecimal XminMean = number.subtract(mean);
            squares.add(XminMean.pow(2, context));
        }
        BigDecimal sum = BigDecimalMathUtils.sum(squares);
        return sum.divide(new BigDecimal(biasCorrected ? numbers.size() - 1 : numbers.size()), context);
    }

    public static BigDecimal sqrt(BigDecimal number) {
        BigDecimal iteration2;
        BigDecimal iteration1;
        BigDecimal temp1 = null;
        BigDecimal temp2 = null;
        int extraPrecision = number.precision();
        MathContext mc = new MathContext(extraPrecision, RoundingMode.HALF_UP);
        BigDecimal numberToBeSquareRooted = number;
        double num = numberToBeSquareRooted.doubleValue();
        if (mc.getPrecision() == 0) {
            throw new IllegalArgumentException("\nRoots need a MathContext precision > 0");
        }
        if (num < 0.0) {
            throw new ArithmeticException("\nCannot calculate the square root of a negative number");
        }
        if (num == 0.0) {
            return number.round(mc);
        }
        if (mc.getPrecision() < 50) {
            extraPrecision += 10;
        }
        int startPrecision = 1;
        if (num == Double.POSITIVE_INFINITY) {
            BigInteger bi = numberToBeSquareRooted.unscaledValue();
            int biLen = bi.bitLength();
            int biSqrtLen = biLen / 2;
            bi = bi.shiftRight(biSqrtLen);
            iteration1 = new BigDecimal(bi);
            MathContext mm3 = new MathContext(5, RoundingMode.HALF_DOWN);
            extraPrecision += 10;
            iteration2 = BigDecimal.ONE.divide(TWO.multiply(iteration1, mm3), mm3);
        } else {
            double s2 = Math.sqrt(num);
            iteration1 = new BigDecimal(Double.valueOf(s2).toString());
            iteration2 = new BigDecimal(Double.valueOf(0.5 / s2).toString());
            startPrecision = 64;
        }
        int digits = mc.getPrecision() + extraPrecision;
        MathContext n = new MathContext(startPrecision, mc.getRoundingMode());
        return BigDecimalMathUtils.sqrtProcedure(n, digits, numberToBeSquareRooted, iteration1, iteration2, temp1, temp2);
    }

    private static BigDecimal sqrtProcedure(MathContext mc, int digits, BigDecimal numberToBeSquareRooted, BigDecimal iteration1, BigDecimal iteration2, BigDecimal temp1, BigDecimal temp2) {
        temp1 = BigDecimal.ONE.subtract(TWO.multiply(iteration1, mc).multiply(iteration2, mc), mc);
        iteration2 = iteration2.add(temp1.multiply(iteration2, mc), mc);
        temp2 = numberToBeSquareRooted.subtract(iteration1.multiply(iteration1, mc), mc);
        iteration1 = iteration1.add(temp2.multiply(iteration2, mc), mc);
        int m3 = mc.getPrecision();
        m3 = m3 < 2 ? ++m3 : m3 * 2 - 1;
        if (m3 < 2 * digits) {
            mc = new MathContext(m3, mc.getRoundingMode());
            BigDecimalMathUtils.sqrtProcedure(mc, digits, numberToBeSquareRooted, iteration1, iteration2, temp1, temp2);
        }
        return iteration1;
    }

    public static void main(String[] args2) {
        System.out.println(BigDecimalMathUtils.sqrt(new BigDecimal("25029.33333")));
    }
}

