/*
 * Decompiled with CFR 0.152.
 */
package mediathek.gui.tabs.tab_film.helpers;

import java.util.HashSet;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javafx.collections.ObservableList;
import javax.swing.table.TableModel;
import mediathek.config.Daten;
import mediathek.controller.history.SeenHistoryController;
import mediathek.daten.DatenFilm;
import mediathek.daten.ListeFilme;
import mediathek.gui.tabs.tab_film.SearchFieldData;
import mediathek.gui.tabs.tab_film.helpers.GuiModelHelper;
import mediathek.gui.tabs.tab_film.searchfilters.FinalStageFilterNoPattern;
import mediathek.gui.tabs.tab_film.searchfilters.FinalStageFilterNoPatternWithDescription;
import mediathek.gui.tabs.tab_film.searchfilters.FinalStagePatternFilter;
import mediathek.gui.tabs.tab_film.searchfilters.FinalStagePatternFilterWithDescription;
import mediathek.javafx.filterpanel.FilmActionPanel;
import mediathek.tool.Filter;
import mediathek.tool.models.TModelFilm;
import org.controlsfx.control.RangeSlider;
import org.jetbrains.annotations.NotNull;

public class GuiFilmeModelHelper
extends GuiModelHelper {
    private TModelFilm filmModel;
    private String[] arrIrgendwo;

    public GuiFilmeModelHelper(@NotNull FilmActionPanel filmActionPanel, @NotNull SeenHistoryController historyController, @NotNull SearchFieldData searchFieldData) {
        this.filmActionPanel = filmActionPanel;
        this.historyController = historyController;
        this.searchFieldData = searchFieldData;
    }

    private String getFilterThema() {
        String filterThema = (String)this.filmActionPanel.getViewSettingsPane().themaComboBox.getSelectionModel().getSelectedItem();
        if (filterThema == null) {
            filterThema = "";
        }
        return filterThema;
    }

    @Override
    protected boolean noFiltersAreSet() {
        RangeSlider filmLengthSlider = this.filmActionPanel.getFilmLengthSlider();
        return this.filmActionPanel.getViewSettingsPane().senderCheckList.getCheckModel().isEmpty() && this.getFilterThema().isEmpty() && this.searchFieldData.isEmpty() && (int)filmLengthSlider.getLowValue() == 0 && (int)filmLengthSlider.getHighValue() == 110 && !this.filmActionPanel.isDontShowAbos() && !this.filmActionPanel.isShowUnseenOnly() && !this.filmActionPanel.isShowOnlyHighQuality() && !this.filmActionPanel.isShowSubtitlesOnly() && !this.filmActionPanel.isShowLivestreamsOnly() && !this.filmActionPanel.isShowNewOnly() && !this.filmActionPanel.isShowBookMarkedOnly() && !this.filmActionPanel.isDontShowTrailers() && !this.filmActionPanel.isDontShowSignLanguage() && !this.filmActionPanel.isDontShowAudioVersions();
    }

    private void performTableFiltering() {
        boolean searchFieldEmpty;
        this.arrIrgendwo = this.searchFieldData.evaluateThemaTitel();
        this.calculateFilmLengthSliderValues();
        String filterThema = this.getFilterThema();
        ObservableList selectedSenders = this.filmActionPanel.getViewSettingsPane().senderCheckList.getCheckModel().getCheckedItems();
        if (this.filmActionPanel.isShowUnseenOnly()) {
            this.historyController.prepareMemoryCache();
        }
        Stream<Object> stream = Daten.getInstance().getListeFilmeNachBlackList().parallelStream();
        if (!selectedSenders.isEmpty()) {
            HashSet senderSet = new HashSet(selectedSenders.size());
            senderSet.addAll(selectedSenders);
            stream = stream.filter(f -> senderSet.contains(f.getSender()));
        }
        if (this.filmActionPanel.isShowNewOnly()) {
            stream = stream.filter(DatenFilm::isNew);
        }
        if (this.filmActionPanel.isShowBookMarkedOnly()) {
            stream = stream.filter(DatenFilm::isBookmarked);
        }
        if (this.filmActionPanel.isShowLivestreamsOnly()) {
            stream = stream.filter(DatenFilm::isLivestream);
        }
        if (this.filmActionPanel.isShowOnlyHighQuality()) {
            stream = stream.filter(DatenFilm::isHighQuality);
        }
        if (this.filmActionPanel.isDontShowTrailers()) {
            stream = stream.filter(film -> !film.isTrailerTeaser());
        }
        if (this.filmActionPanel.isDontShowSignLanguage()) {
            stream = stream.filter(film -> !film.isSignLanguage());
        }
        if (this.filmActionPanel.isDontShowAudioVersions()) {
            stream = stream.filter(film -> !film.isAudioVersion());
        }
        if (this.filmActionPanel.isDontShowAbos()) {
            stream = stream.filter(film -> film.getAbo() == null);
        }
        if (this.filmActionPanel.isShowSubtitlesOnly()) {
            stream = stream.filter(this::subtitleCheck);
        }
        if (!filterThema.isEmpty()) {
            stream = stream.filter(film -> film.getThema().equalsIgnoreCase(filterThema));
        }
        if (this.maxLength < 110L) {
            stream = stream.filter(this::maxLengthCheck);
        }
        if (this.filmActionPanel.isShowUnseenOnly()) {
            stream = stream.filter(this::seenCheck);
        }
        stream = stream.filter(this::minLengthCheck);
        boolean bl = searchFieldEmpty = this.arrIrgendwo.length == 0;
        if (!searchFieldEmpty) {
            stream = stream.filter(this.createFinalStageFilter());
        }
        List<DatenFilm> list = stream.collect(Collectors.toList());
        stream.close();
        this.filmModel = new TModelFilm(list.size());
        this.filmModel.addAll(list);
        list.clear();
        if (this.filmActionPanel.isShowUnseenOnly()) {
            this.historyController.emptyMemoryCache();
        }
    }

    private Predicate<DatenFilm> createFinalStageFilter() {
        boolean isPattern;
        boolean bl = isPattern = Filter.isPattern(this.arrIrgendwo[0]) || this.arrIrgendwo.length > 1;
        Predicate<DatenFilm> filter = this.searchFieldData.searchThroughDescriptions() ? (isPattern ? new FinalStagePatternFilterWithDescription(this.arrIrgendwo) : new FinalStageFilterNoPatternWithDescription(this.arrIrgendwo)) : (isPattern ? new FinalStagePatternFilter(this.arrIrgendwo) : new FinalStageFilterNoPattern(this.arrIrgendwo));
        return filter;
    }

    private boolean subtitleCheck(DatenFilm film) {
        return film.hasSubtitle() || film.hasBurnedInSubtitles();
    }

    @Override
    public TableModel getFilteredTableModel() {
        ListeFilme listeFilme = Daten.getInstance().getListeFilmeNachBlackList();
        if (!listeFilme.isEmpty()) {
            if (this.noFiltersAreSet()) {
                this.filmModel = new TModelFilm(listeFilme.size());
                this.filmModel.addAll(listeFilme);
            } else {
                this.performTableFiltering();
            }
        } else {
            return new TModelFilm();
        }
        return this.filmModel;
    }
}

