/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.plaf;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.lang.reflect.Method;
import javax.accessibility.Accessible;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.plaf.TextUI;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.EditorKit;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import javax.swing.text.View;
import org.jdesktop.swingx.painter.Painter;
import org.jdesktop.swingx.prompt.PromptSupport;

public abstract class PromptTextUI
extends TextUI {
    static final FocusHandler focusHandler = new FocusHandler();
    protected final TextUI delegate;
    protected JTextComponent promptComponent;

    public PromptTextUI(TextUI delegate) {
        this.delegate = delegate;
    }

    protected abstract JTextComponent createPromptComponent();

    @Override
    public void installUI(JComponent c) {
        this.delegate.installUI(c);
        JTextComponent txt = (JTextComponent)c;
        txt.addFocusListener(focusHandler);
    }

    @Override
    public void uninstallUI(JComponent c) {
        this.delegate.uninstallUI(c);
        c.removeFocusListener(focusHandler);
        this.promptComponent = null;
    }

    public JTextComponent getPromptComponent(JTextComponent txt) {
        if (this.promptComponent == null) {
            this.promptComponent = this.createPromptComponent();
        }
        if (txt.isFocusOwner() && PromptSupport.getFocusBehavior(txt) == PromptSupport.FocusBehavior.HIDE_PROMPT) {
            this.promptComponent.setText(null);
        } else {
            this.promptComponent.setText(PromptSupport.getPrompt(txt));
        }
        this.promptComponent.getHighlighter().removeAllHighlights();
        if (txt.isFocusOwner() && PromptSupport.getFocusBehavior(txt) == PromptSupport.FocusBehavior.HIGHLIGHT_PROMPT) {
            this.promptComponent.setForeground(txt.getSelectedTextColor());
            try {
                this.promptComponent.getHighlighter().addHighlight(0, this.promptComponent.getText().length(), new DefaultHighlighter.DefaultHighlightPainter(txt.getSelectionColor()));
            }
            catch (BadLocationException e) {
                e.printStackTrace();
            }
        } else {
            this.promptComponent.setForeground(PromptSupport.getForeground(txt));
        }
        if (PromptSupport.getFontStyle(txt) == null) {
            this.promptComponent.setFont(txt.getFont());
        } else {
            this.promptComponent.setFont(txt.getFont().deriveFont(PromptSupport.getFontStyle(txt)));
        }
        this.promptComponent.setBackground(PromptSupport.getBackground(txt));
        this.promptComponent.setHighlighter(new PainterHighlighter(PromptSupport.getBackgroundPainter(txt)));
        this.promptComponent.setEnabled(txt.isEnabled());
        this.promptComponent.setOpaque(txt.isOpaque());
        this.promptComponent.setBounds(txt.getBounds());
        Border b = txt.getBorder();
        if (b == null) {
            this.promptComponent.setBorder(txt.getBorder());
        } else {
            Insets insets = b.getBorderInsets(txt);
            this.promptComponent.setBorder(BorderFactory.createEmptyBorder(insets.top, insets.left, insets.bottom, insets.right));
        }
        this.promptComponent.setSelectedTextColor(txt.getSelectedTextColor());
        this.promptComponent.setSelectionColor(txt.getSelectionColor());
        this.promptComponent.setEditable(txt.isEditable());
        this.promptComponent.setMargin(txt.getMargin());
        return this.promptComponent;
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        JTextComponent txt = (JTextComponent)c;
        if (this.shouldPaintPrompt(txt)) {
            return this.getPromptComponent(txt).getPreferredSize();
        }
        return this.delegate.getPreferredSize(c);
    }

    @Override
    public void paint(Graphics g2, JComponent c) {
        JTextComponent txt = (JTextComponent)c;
        if (this.shouldPaintPrompt(txt)) {
            this.paintPromptComponent(g2, txt);
        } else {
            this.delegate.paint(g2, c);
        }
    }

    protected void paintPromptComponent(Graphics g2, JTextComponent txt) {
        JTextComponent lbl = this.getPromptComponent(txt);
        SwingUtilities.paintComponent(g2, lbl, txt, 0, 0, txt.getWidth(), txt.getHeight());
        if (txt.getCaret() != null) {
            txt.getCaret().paint(g2);
        }
    }

    public boolean shouldPaintPrompt(JTextComponent txt) {
        return txt.getText() == null || txt.getText().length() == 0;
    }

    @Override
    public void update(Graphics g2, JComponent c) {
        if (this.shouldPaintPrompt((JTextComponent)c)) {
            super.update(g2, c);
        } else {
            this.delegate.update(g2, c);
        }
    }

    @Override
    public Rectangle modelToView(JTextComponent t, int pos, Position.Bias bias) throws BadLocationException {
        if (this.shouldPaintPrompt(t)) {
            return this.getPromptComponent(t).getUI().modelToView(t, pos, bias);
        }
        return this.delegate.modelToView(t, pos, bias);
    }

    @Override
    public Rectangle modelToView(JTextComponent t, int pos) throws BadLocationException {
        return this.modelToView(t, pos, Position.Bias.Forward);
    }

    @Override
    public boolean contains(JComponent c, int x, int y) {
        return this.delegate.contains(c, x, y);
    }

    @Override
    public void damageRange(JTextComponent t, int p0, int p1, Position.Bias firstBias, Position.Bias secondBias) {
        this.delegate.damageRange(t, p0, p1, firstBias, secondBias);
    }

    @Override
    public void damageRange(JTextComponent t, int p0, int p1) {
        this.delegate.damageRange(t, p0, p1);
    }

    public boolean equals(Object obj) {
        return this.delegate.equals(obj);
    }

    @Override
    public Accessible getAccessibleChild(JComponent c, int i) {
        return this.delegate.getAccessibleChild(c, i);
    }

    @Override
    public int getAccessibleChildrenCount(JComponent c) {
        return this.delegate.getAccessibleChildrenCount(c);
    }

    @Override
    public EditorKit getEditorKit(JTextComponent t) {
        return this.delegate.getEditorKit(t);
    }

    @Override
    public Dimension getMaximumSize(JComponent c) {
        return this.delegate.getMaximumSize(c);
    }

    @Override
    public Dimension getMinimumSize(JComponent c) {
        return this.delegate.getMinimumSize(c);
    }

    @Override
    public int getNextVisualPositionFrom(JTextComponent t, int pos, Position.Bias b, int direction, Position.Bias[] biasRet) throws BadLocationException {
        return this.delegate.getNextVisualPositionFrom(t, pos, b, direction, biasRet);
    }

    @Override
    public View getRootView(JTextComponent t) {
        return this.delegate.getRootView(t);
    }

    @Override
    public String getToolTipText(JTextComponent t, Point pt) {
        return this.delegate.getToolTipText(t, pt);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public String toString() {
        return String.format("%s (%s)", this.getClass().getName(), this.delegate.toString());
    }

    @Override
    public int viewToModel(JTextComponent t, Point pt, Position.Bias[] biasReturn) {
        return this.delegate.viewToModel(t, pt, biasReturn);
    }

    @Override
    public int viewToModel(JTextComponent t, Point pt) {
        return this.delegate.viewToModel(t, pt);
    }

    @Override
    public int getBaseline(JComponent c, int width, int height) {
        try {
            Method m3 = this.delegate.getClass().getMethod("getBaseline", JComponent.class, Integer.TYPE, Integer.TYPE);
            Object o = m3.invoke((Object)this.delegate, c, width, height);
            return (Integer)o;
        }
        catch (Exception ex) {
            return -2;
        }
    }

    private static final class FocusHandler
    extends FocusAdapter {
        private FocusHandler() {
        }

        @Override
        public void focusGained(FocusEvent e) {
            e.getComponent().repaint();
        }

        @Override
        public void focusLost(FocusEvent e) {
            e.getComponent().repaint();
        }
    }

    protected class PainterHighlighter
    implements Highlighter {
        private final Painter painter;
        private JTextComponent c;

        public PainterHighlighter(Painter painter) {
            this.painter = painter;
        }

        @Override
        public Object addHighlight(int p0, int p1, Highlighter.HighlightPainter p) throws BadLocationException {
            return new Object();
        }

        @Override
        public void changeHighlight(Object tag, int p0, int p1) throws BadLocationException {
        }

        @Override
        public void deinstall(JTextComponent c) {
            c = null;
        }

        @Override
        public Highlighter.Highlight[] getHighlights() {
            return null;
        }

        @Override
        public void install(JTextComponent c) {
            this.c = c;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void paint(Graphics g2) {
            Graphics2D g2d = (Graphics2D)g2.create();
            try {
                this.painter.paint(g2d, this.c, this.c.getWidth(), this.c.getHeight());
            }
            finally {
                g2d.dispose();
            }
        }

        @Override
        public void removeAllHighlights() {
        }

        @Override
        public void removeHighlight(Object tag) {
        }
    }
}

