# coding: utf-8

"""
    PeerTube

    # Introduction  The PeerTube API is built on HTTP(S) and is RESTful. You can use your favorite HTTP/REST library for your programming language to use PeerTube. The spec API is fully compatible with [openapi-generator](https://github.com/OpenAPITools/openapi-generator/wiki/API-client-generator-HOWTO) which generates a client SDK in the language of your choice - we generate some client SDKs automatically:  - [Python](https://framagit.org/framasoft/peertube/clients/python) - [Go](https://framagit.org/framasoft/peertube/clients/go) - [Kotlin](https://framagit.org/framasoft/peertube/clients/kotlin)  See the [Quick Start guide](https://docs.joinpeertube.org/#/api-rest-getting-started) so you can play with the PeerTube API.  # Authentication  When you sign up for an account, you are given the possibility to generate sessions, and authenticate using this session token. One session token can currently be used at a time.  ## Roles  Accounts are given permissions based on their role. There are three roles on PeerTube: Administrator, Moderator, and User. See the [roles guide](https://docs.joinpeertube.org/#/admin-managing-users?id=roles) for a detail of their permissions.  # Errors  The API uses standard HTTP status codes to indicate the success or failure of the API call. The body of the response will be JSON in the following format.  ``` {   \"code\": \"unauthorized_request\", // example inner error code   \"error\": \"Token is invalid.\" // example exposed error message } ```   # noqa: E501

    The version of the OpenAPI document: 2.4.0
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from peertube.api_client import ApiClient
from peertube.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)


class VideoApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def accounts_name_videos_get(self, name, **kwargs):  # noqa: E501
        """List videos of an account  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.accounts_name_videos_get(name, async_req=True)
        >>> result = thread.get()

        :param name: The name of the account (required)
        :type name: str
        :param category_one_of: category id of the video (see [/videos/categories](#tag/Video/paths/~1videos~1categories/get))
        :type category_one_of: OneOfintegerarray
        :param tags_one_of: tag(s) of the video
        :type tags_one_of: OneOfstringarray
        :param tags_all_of: tag(s) of the video, where all should be present in the video
        :type tags_all_of: OneOfstringarray
        :param licence_one_of: licence id of the video (see [/videos/licences](#tag/Video/paths/~1videos~1licences/get))
        :type licence_one_of: OneOfintegerarray
        :param language_one_of: language id of the video (see [/videos/languages](#tag/Video/paths/~1videos~1languages/get)). Use `_unknown` to filter on videos that don't have a video language
        :type language_one_of: OneOfstringarray
        :param nsfw: whether to include nsfw videos, if any
        :type nsfw: str
        :param filter: Special filters which might require special rights:  * `local` - only videos local to the instance  * `all-local` - only videos local to the instance, but showing private and unlisted videos (requires Admin privileges)  * `all` - all videos, showing private and unlisted videos (requires Admin privileges) 
        :type filter: str
        :param skip_count: if you don't need the `total` in the response
        :type skip_count: str
        :param start: Offset used to paginate results
        :type start: int
        :param count: Number of items to return
        :type count: int
        :param sort: Sort videos by criteria
        :type sort: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: VideoListResponse
        """
        kwargs['_return_http_data_only'] = True
        return self.accounts_name_videos_get_with_http_info(name, **kwargs)  # noqa: E501

    def accounts_name_videos_get_with_http_info(self, name, **kwargs):  # noqa: E501
        """List videos of an account  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.accounts_name_videos_get_with_http_info(name, async_req=True)
        >>> result = thread.get()

        :param name: The name of the account (required)
        :type name: str
        :param category_one_of: category id of the video (see [/videos/categories](#tag/Video/paths/~1videos~1categories/get))
        :type category_one_of: OneOfintegerarray
        :param tags_one_of: tag(s) of the video
        :type tags_one_of: OneOfstringarray
        :param tags_all_of: tag(s) of the video, where all should be present in the video
        :type tags_all_of: OneOfstringarray
        :param licence_one_of: licence id of the video (see [/videos/licences](#tag/Video/paths/~1videos~1licences/get))
        :type licence_one_of: OneOfintegerarray
        :param language_one_of: language id of the video (see [/videos/languages](#tag/Video/paths/~1videos~1languages/get)). Use `_unknown` to filter on videos that don't have a video language
        :type language_one_of: OneOfstringarray
        :param nsfw: whether to include nsfw videos, if any
        :type nsfw: str
        :param filter: Special filters which might require special rights:  * `local` - only videos local to the instance  * `all-local` - only videos local to the instance, but showing private and unlisted videos (requires Admin privileges)  * `all` - all videos, showing private and unlisted videos (requires Admin privileges) 
        :type filter: str
        :param skip_count: if you don't need the `total` in the response
        :type skip_count: str
        :param start: Offset used to paginate results
        :type start: int
        :param count: Number of items to return
        :type count: int
        :param sort: Sort videos by criteria
        :type sort: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(VideoListResponse, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'name',
            'category_one_of',
            'tags_one_of',
            'tags_all_of',
            'licence_one_of',
            'language_one_of',
            'nsfw',
            'filter',
            'skip_count',
            'start',
            'count',
            'sort'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method accounts_name_videos_get" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'name' is set
        if self.api_client.client_side_validation and ('name' not in local_var_params or  # noqa: E501
                                                        local_var_params['name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `name` when calling `accounts_name_videos_get`")  # noqa: E501

        if self.api_client.client_side_validation and 'start' in local_var_params and local_var_params['start'] < 0:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `start` when calling `accounts_name_videos_get`, must be a value greater than or equal to `0`")  # noqa: E501
        if self.api_client.client_side_validation and 'count' in local_var_params and local_var_params['count'] > 100:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `count` when calling `accounts_name_videos_get`, must be a value less than or equal to `100`")  # noqa: E501
        if self.api_client.client_side_validation and 'count' in local_var_params and local_var_params['count'] < 1:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `count` when calling `accounts_name_videos_get`, must be a value greater than or equal to `1`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'name' in local_var_params:
            path_params['name'] = local_var_params['name']  # noqa: E501

        query_params = []
        if 'category_one_of' in local_var_params and local_var_params['category_one_of'] is not None:  # noqa: E501
            query_params.append(('categoryOneOf', local_var_params['category_one_of']))  # noqa: E501
        if 'tags_one_of' in local_var_params and local_var_params['tags_one_of'] is not None:  # noqa: E501
            query_params.append(('tagsOneOf', local_var_params['tags_one_of']))  # noqa: E501
        if 'tags_all_of' in local_var_params and local_var_params['tags_all_of'] is not None:  # noqa: E501
            query_params.append(('tagsAllOf', local_var_params['tags_all_of']))  # noqa: E501
        if 'licence_one_of' in local_var_params and local_var_params['licence_one_of'] is not None:  # noqa: E501
            query_params.append(('licenceOneOf', local_var_params['licence_one_of']))  # noqa: E501
        if 'language_one_of' in local_var_params and local_var_params['language_one_of'] is not None:  # noqa: E501
            query_params.append(('languageOneOf', local_var_params['language_one_of']))  # noqa: E501
        if 'nsfw' in local_var_params and local_var_params['nsfw'] is not None:  # noqa: E501
            query_params.append(('nsfw', local_var_params['nsfw']))  # noqa: E501
        if 'filter' in local_var_params and local_var_params['filter'] is not None:  # noqa: E501
            query_params.append(('filter', local_var_params['filter']))  # noqa: E501
        if 'skip_count' in local_var_params and local_var_params['skip_count'] is not None:  # noqa: E501
            query_params.append(('skipCount', local_var_params['skip_count']))  # noqa: E501
        if 'start' in local_var_params and local_var_params['start'] is not None:  # noqa: E501
            query_params.append(('start', local_var_params['start']))  # noqa: E501
        if 'count' in local_var_params and local_var_params['count'] is not None:  # noqa: E501
            query_params.append(('count', local_var_params['count']))  # noqa: E501
        if 'sort' in local_var_params and local_var_params['sort'] is not None:  # noqa: E501
            query_params.append(('sort', local_var_params['sort']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/accounts/{name}/videos', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='VideoListResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def video_channels_channel_handle_videos_get(self, channel_handle, **kwargs):  # noqa: E501
        """List videos of a video channel  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.video_channels_channel_handle_videos_get(channel_handle, async_req=True)
        >>> result = thread.get()

        :param channel_handle: The video channel handle (required)
        :type channel_handle: str
        :param category_one_of: category id of the video (see [/videos/categories](#tag/Video/paths/~1videos~1categories/get))
        :type category_one_of: OneOfintegerarray
        :param tags_one_of: tag(s) of the video
        :type tags_one_of: OneOfstringarray
        :param tags_all_of: tag(s) of the video, where all should be present in the video
        :type tags_all_of: OneOfstringarray
        :param licence_one_of: licence id of the video (see [/videos/licences](#tag/Video/paths/~1videos~1licences/get))
        :type licence_one_of: OneOfintegerarray
        :param language_one_of: language id of the video (see [/videos/languages](#tag/Video/paths/~1videos~1languages/get)). Use `_unknown` to filter on videos that don't have a video language
        :type language_one_of: OneOfstringarray
        :param nsfw: whether to include nsfw videos, if any
        :type nsfw: str
        :param filter: Special filters which might require special rights:  * `local` - only videos local to the instance  * `all-local` - only videos local to the instance, but showing private and unlisted videos (requires Admin privileges)  * `all` - all videos, showing private and unlisted videos (requires Admin privileges) 
        :type filter: str
        :param skip_count: if you don't need the `total` in the response
        :type skip_count: str
        :param start: Offset used to paginate results
        :type start: int
        :param count: Number of items to return
        :type count: int
        :param sort: Sort videos by criteria
        :type sort: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: VideoListResponse
        """
        kwargs['_return_http_data_only'] = True
        return self.video_channels_channel_handle_videos_get_with_http_info(channel_handle, **kwargs)  # noqa: E501

    def video_channels_channel_handle_videos_get_with_http_info(self, channel_handle, **kwargs):  # noqa: E501
        """List videos of a video channel  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.video_channels_channel_handle_videos_get_with_http_info(channel_handle, async_req=True)
        >>> result = thread.get()

        :param channel_handle: The video channel handle (required)
        :type channel_handle: str
        :param category_one_of: category id of the video (see [/videos/categories](#tag/Video/paths/~1videos~1categories/get))
        :type category_one_of: OneOfintegerarray
        :param tags_one_of: tag(s) of the video
        :type tags_one_of: OneOfstringarray
        :param tags_all_of: tag(s) of the video, where all should be present in the video
        :type tags_all_of: OneOfstringarray
        :param licence_one_of: licence id of the video (see [/videos/licences](#tag/Video/paths/~1videos~1licences/get))
        :type licence_one_of: OneOfintegerarray
        :param language_one_of: language id of the video (see [/videos/languages](#tag/Video/paths/~1videos~1languages/get)). Use `_unknown` to filter on videos that don't have a video language
        :type language_one_of: OneOfstringarray
        :param nsfw: whether to include nsfw videos, if any
        :type nsfw: str
        :param filter: Special filters which might require special rights:  * `local` - only videos local to the instance  * `all-local` - only videos local to the instance, but showing private and unlisted videos (requires Admin privileges)  * `all` - all videos, showing private and unlisted videos (requires Admin privileges) 
        :type filter: str
        :param skip_count: if you don't need the `total` in the response
        :type skip_count: str
        :param start: Offset used to paginate results
        :type start: int
        :param count: Number of items to return
        :type count: int
        :param sort: Sort videos by criteria
        :type sort: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(VideoListResponse, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'channel_handle',
            'category_one_of',
            'tags_one_of',
            'tags_all_of',
            'licence_one_of',
            'language_one_of',
            'nsfw',
            'filter',
            'skip_count',
            'start',
            'count',
            'sort'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method video_channels_channel_handle_videos_get" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'channel_handle' is set
        if self.api_client.client_side_validation and ('channel_handle' not in local_var_params or  # noqa: E501
                                                        local_var_params['channel_handle'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `channel_handle` when calling `video_channels_channel_handle_videos_get`")  # noqa: E501

        if self.api_client.client_side_validation and 'start' in local_var_params and local_var_params['start'] < 0:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `start` when calling `video_channels_channel_handle_videos_get`, must be a value greater than or equal to `0`")  # noqa: E501
        if self.api_client.client_side_validation and 'count' in local_var_params and local_var_params['count'] > 100:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `count` when calling `video_channels_channel_handle_videos_get`, must be a value less than or equal to `100`")  # noqa: E501
        if self.api_client.client_side_validation and 'count' in local_var_params and local_var_params['count'] < 1:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `count` when calling `video_channels_channel_handle_videos_get`, must be a value greater than or equal to `1`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'channel_handle' in local_var_params:
            path_params['channelHandle'] = local_var_params['channel_handle']  # noqa: E501

        query_params = []
        if 'category_one_of' in local_var_params and local_var_params['category_one_of'] is not None:  # noqa: E501
            query_params.append(('categoryOneOf', local_var_params['category_one_of']))  # noqa: E501
        if 'tags_one_of' in local_var_params and local_var_params['tags_one_of'] is not None:  # noqa: E501
            query_params.append(('tagsOneOf', local_var_params['tags_one_of']))  # noqa: E501
        if 'tags_all_of' in local_var_params and local_var_params['tags_all_of'] is not None:  # noqa: E501
            query_params.append(('tagsAllOf', local_var_params['tags_all_of']))  # noqa: E501
        if 'licence_one_of' in local_var_params and local_var_params['licence_one_of'] is not None:  # noqa: E501
            query_params.append(('licenceOneOf', local_var_params['licence_one_of']))  # noqa: E501
        if 'language_one_of' in local_var_params and local_var_params['language_one_of'] is not None:  # noqa: E501
            query_params.append(('languageOneOf', local_var_params['language_one_of']))  # noqa: E501
        if 'nsfw' in local_var_params and local_var_params['nsfw'] is not None:  # noqa: E501
            query_params.append(('nsfw', local_var_params['nsfw']))  # noqa: E501
        if 'filter' in local_var_params and local_var_params['filter'] is not None:  # noqa: E501
            query_params.append(('filter', local_var_params['filter']))  # noqa: E501
        if 'skip_count' in local_var_params and local_var_params['skip_count'] is not None:  # noqa: E501
            query_params.append(('skipCount', local_var_params['skip_count']))  # noqa: E501
        if 'start' in local_var_params and local_var_params['start'] is not None:  # noqa: E501
            query_params.append(('start', local_var_params['start']))  # noqa: E501
        if 'count' in local_var_params and local_var_params['count'] is not None:  # noqa: E501
            query_params.append(('count', local_var_params['count']))  # noqa: E501
        if 'sort' in local_var_params and local_var_params['sort'] is not None:  # noqa: E501
            query_params.append(('sort', local_var_params['sort']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/video-channels/{channelHandle}/videos', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='VideoListResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def videos_categories_get(self, **kwargs):  # noqa: E501
        """List available video categories  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.videos_categories_get(async_req=True)
        >>> result = thread.get()

        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: list[str]
        """
        kwargs['_return_http_data_only'] = True
        return self.videos_categories_get_with_http_info(**kwargs)  # noqa: E501

    def videos_categories_get_with_http_info(self, **kwargs):  # noqa: E501
        """List available video categories  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.videos_categories_get_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(list[str], status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method videos_categories_get" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/videos/categories', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[str]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def videos_get(self, **kwargs):  # noqa: E501
        """List videos  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.videos_get(async_req=True)
        >>> result = thread.get()

        :param category_one_of: category id of the video (see [/videos/categories](#tag/Video/paths/~1videos~1categories/get))
        :type category_one_of: OneOfintegerarray
        :param tags_one_of: tag(s) of the video
        :type tags_one_of: OneOfstringarray
        :param tags_all_of: tag(s) of the video, where all should be present in the video
        :type tags_all_of: OneOfstringarray
        :param licence_one_of: licence id of the video (see [/videos/licences](#tag/Video/paths/~1videos~1licences/get))
        :type licence_one_of: OneOfintegerarray
        :param language_one_of: language id of the video (see [/videos/languages](#tag/Video/paths/~1videos~1languages/get)). Use `_unknown` to filter on videos that don't have a video language
        :type language_one_of: OneOfstringarray
        :param nsfw: whether to include nsfw videos, if any
        :type nsfw: str
        :param filter: Special filters which might require special rights:  * `local` - only videos local to the instance  * `all-local` - only videos local to the instance, but showing private and unlisted videos (requires Admin privileges)  * `all` - all videos, showing private and unlisted videos (requires Admin privileges) 
        :type filter: str
        :param skip_count: if you don't need the `total` in the response
        :type skip_count: str
        :param start: Offset used to paginate results
        :type start: int
        :param count: Number of items to return
        :type count: int
        :param sort: Sort videos by criteria
        :type sort: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: VideoListResponse
        """
        kwargs['_return_http_data_only'] = True
        return self.videos_get_with_http_info(**kwargs)  # noqa: E501

    def videos_get_with_http_info(self, **kwargs):  # noqa: E501
        """List videos  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.videos_get_with_http_info(async_req=True)
        >>> result = thread.get()

        :param category_one_of: category id of the video (see [/videos/categories](#tag/Video/paths/~1videos~1categories/get))
        :type category_one_of: OneOfintegerarray
        :param tags_one_of: tag(s) of the video
        :type tags_one_of: OneOfstringarray
        :param tags_all_of: tag(s) of the video, where all should be present in the video
        :type tags_all_of: OneOfstringarray
        :param licence_one_of: licence id of the video (see [/videos/licences](#tag/Video/paths/~1videos~1licences/get))
        :type licence_one_of: OneOfintegerarray
        :param language_one_of: language id of the video (see [/videos/languages](#tag/Video/paths/~1videos~1languages/get)). Use `_unknown` to filter on videos that don't have a video language
        :type language_one_of: OneOfstringarray
        :param nsfw: whether to include nsfw videos, if any
        :type nsfw: str
        :param filter: Special filters which might require special rights:  * `local` - only videos local to the instance  * `all-local` - only videos local to the instance, but showing private and unlisted videos (requires Admin privileges)  * `all` - all videos, showing private and unlisted videos (requires Admin privileges) 
        :type filter: str
        :param skip_count: if you don't need the `total` in the response
        :type skip_count: str
        :param start: Offset used to paginate results
        :type start: int
        :param count: Number of items to return
        :type count: int
        :param sort: Sort videos by criteria
        :type sort: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(VideoListResponse, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'category_one_of',
            'tags_one_of',
            'tags_all_of',
            'licence_one_of',
            'language_one_of',
            'nsfw',
            'filter',
            'skip_count',
            'start',
            'count',
            'sort'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method videos_get" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        if self.api_client.client_side_validation and 'start' in local_var_params and local_var_params['start'] < 0:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `start` when calling `videos_get`, must be a value greater than or equal to `0`")  # noqa: E501
        if self.api_client.client_side_validation and 'count' in local_var_params and local_var_params['count'] > 100:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `count` when calling `videos_get`, must be a value less than or equal to `100`")  # noqa: E501
        if self.api_client.client_side_validation and 'count' in local_var_params and local_var_params['count'] < 1:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `count` when calling `videos_get`, must be a value greater than or equal to `1`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'category_one_of' in local_var_params and local_var_params['category_one_of'] is not None:  # noqa: E501
            query_params.append(('categoryOneOf', local_var_params['category_one_of']))  # noqa: E501
        if 'tags_one_of' in local_var_params and local_var_params['tags_one_of'] is not None:  # noqa: E501
            query_params.append(('tagsOneOf', local_var_params['tags_one_of']))  # noqa: E501
        if 'tags_all_of' in local_var_params and local_var_params['tags_all_of'] is not None:  # noqa: E501
            query_params.append(('tagsAllOf', local_var_params['tags_all_of']))  # noqa: E501
        if 'licence_one_of' in local_var_params and local_var_params['licence_one_of'] is not None:  # noqa: E501
            query_params.append(('licenceOneOf', local_var_params['licence_one_of']))  # noqa: E501
        if 'language_one_of' in local_var_params and local_var_params['language_one_of'] is not None:  # noqa: E501
            query_params.append(('languageOneOf', local_var_params['language_one_of']))  # noqa: E501
        if 'nsfw' in local_var_params and local_var_params['nsfw'] is not None:  # noqa: E501
            query_params.append(('nsfw', local_var_params['nsfw']))  # noqa: E501
        if 'filter' in local_var_params and local_var_params['filter'] is not None:  # noqa: E501
            query_params.append(('filter', local_var_params['filter']))  # noqa: E501
        if 'skip_count' in local_var_params and local_var_params['skip_count'] is not None:  # noqa: E501
            query_params.append(('skipCount', local_var_params['skip_count']))  # noqa: E501
        if 'start' in local_var_params and local_var_params['start'] is not None:  # noqa: E501
            query_params.append(('start', local_var_params['start']))  # noqa: E501
        if 'count' in local_var_params and local_var_params['count'] is not None:  # noqa: E501
            query_params.append(('count', local_var_params['count']))  # noqa: E501
        if 'sort' in local_var_params and local_var_params['sort'] is not None:  # noqa: E501
            query_params.append(('sort', local_var_params['sort']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/videos', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='VideoListResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def videos_id_delete(self, id, **kwargs):  # noqa: E501
        """Delete a video  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.videos_id_delete(id, async_req=True)
        >>> result = thread.get()

        :param id: The object id or uuid (required)
        :type id: OneOfintegerUUID
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """
        kwargs['_return_http_data_only'] = True
        return self.videos_id_delete_with_http_info(id, **kwargs)  # noqa: E501

    def videos_id_delete_with_http_info(self, id, **kwargs):  # noqa: E501
        """Delete a video  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.videos_id_delete_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param id: The object id or uuid (required)
        :type id: OneOfintegerUUID
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """

        local_var_params = locals()

        all_params = [
            'id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method videos_id_delete" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `videos_id_delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['OAuth2']  # noqa: E501

        return self.api_client.call_api(
            '/videos/{id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def videos_id_description_get(self, id, **kwargs):  # noqa: E501
        """Get complete video description  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.videos_id_description_get(id, async_req=True)
        >>> result = thread.get()

        :param id: The object id or uuid (required)
        :type id: OneOfintegerUUID
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: str
        """
        kwargs['_return_http_data_only'] = True
        return self.videos_id_description_get_with_http_info(id, **kwargs)  # noqa: E501

    def videos_id_description_get_with_http_info(self, id, **kwargs):  # noqa: E501
        """Get complete video description  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.videos_id_description_get_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param id: The object id or uuid (required)
        :type id: OneOfintegerUUID
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(str, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method videos_id_description_get" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `videos_id_description_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/videos/{id}/description', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def videos_id_get(self, id, **kwargs):  # noqa: E501
        """Get a video  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.videos_id_get(id, async_req=True)
        >>> result = thread.get()

        :param id: The object id or uuid (required)
        :type id: OneOfintegerUUID
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: VideoDetails
        """
        kwargs['_return_http_data_only'] = True
        return self.videos_id_get_with_http_info(id, **kwargs)  # noqa: E501

    def videos_id_get_with_http_info(self, id, **kwargs):  # noqa: E501
        """Get a video  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.videos_id_get_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param id: The object id or uuid (required)
        :type id: OneOfintegerUUID
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(VideoDetails, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method videos_id_get" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `videos_id_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/videos/{id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='VideoDetails',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def videos_id_put(self, id, **kwargs):  # noqa: E501
        """Update a video  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.videos_id_put(id, async_req=True)
        >>> result = thread.get()

        :param id: The object id or uuid (required)
        :type id: OneOfintegerUUID
        :param thumbnailfile: Video thumbnail file
        :type thumbnailfile: file
        :param previewfile: Video preview file
        :type previewfile: file
        :param category: Video category
        :type category: int
        :param licence: Video licence
        :type licence: int
        :param language: Video language
        :type language: str
        :param privacy:
        :type privacy: VideoPrivacySet
        :param description: Video description
        :type description: str
        :param wait_transcoding: Whether or not we wait transcoding before publish the video
        :type wait_transcoding: str
        :param support: A text tell the audience how to support the video creator
        :type support: str
        :param nsfw: Whether or not this video contains sensitive content
        :type nsfw: bool
        :param name: Video name
        :type name: str
        :param tags: Video tags (maximum 5 tags each between 2 and 30 characters)
        :type tags: list[str]
        :param comments_enabled: Enable or disable comments for this video
        :type comments_enabled: bool
        :param originally_published_at: Date when the content was originally published
        :type originally_published_at: datetime
        :param schedule_update:
        :type schedule_update: VideoScheduledUpdate
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """
        kwargs['_return_http_data_only'] = True
        return self.videos_id_put_with_http_info(id, **kwargs)  # noqa: E501

    def videos_id_put_with_http_info(self, id, **kwargs):  # noqa: E501
        """Update a video  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.videos_id_put_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param id: The object id or uuid (required)
        :type id: OneOfintegerUUID
        :param thumbnailfile: Video thumbnail file
        :type thumbnailfile: file
        :param previewfile: Video preview file
        :type previewfile: file
        :param category: Video category
        :type category: int
        :param licence: Video licence
        :type licence: int
        :param language: Video language
        :type language: str
        :param privacy:
        :type privacy: VideoPrivacySet
        :param description: Video description
        :type description: str
        :param wait_transcoding: Whether or not we wait transcoding before publish the video
        :type wait_transcoding: str
        :param support: A text tell the audience how to support the video creator
        :type support: str
        :param nsfw: Whether or not this video contains sensitive content
        :type nsfw: bool
        :param name: Video name
        :type name: str
        :param tags: Video tags (maximum 5 tags each between 2 and 30 characters)
        :type tags: list[str]
        :param comments_enabled: Enable or disable comments for this video
        :type comments_enabled: bool
        :param originally_published_at: Date when the content was originally published
        :type originally_published_at: datetime
        :param schedule_update:
        :type schedule_update: VideoScheduledUpdate
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """

        local_var_params = locals()

        all_params = [
            'id',
            'thumbnailfile',
            'previewfile',
            'category',
            'licence',
            'language',
            'privacy',
            'description',
            'wait_transcoding',
            'support',
            'nsfw',
            'name',
            'tags',
            'comments_enabled',
            'originally_published_at',
            'schedule_update'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method videos_id_put" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `videos_id_put`")  # noqa: E501

        if self.api_client.client_side_validation and ('tags' in local_var_params and  # noqa: E501
                                                        len(local_var_params['tags']) > 30):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `tags` when calling `videos_id_put`, length must be less than or equal to `30`")  # noqa: E501
        if self.api_client.client_side_validation and ('tags' in local_var_params and  # noqa: E501
                                                        len(local_var_params['tags']) < 2):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `tags` when calling `videos_id_put`, length must be greater than or equal to `2`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'thumbnailfile' in local_var_params:
            local_var_files['thumbnailfile'] = local_var_params['thumbnailfile']  # noqa: E501
        if 'previewfile' in local_var_params:
            local_var_files['previewfile'] = local_var_params['previewfile']  # noqa: E501
        if 'category' in local_var_params:
            form_params.append(('category', local_var_params['category']))  # noqa: E501
        if 'licence' in local_var_params:
            form_params.append(('licence', local_var_params['licence']))  # noqa: E501
        if 'language' in local_var_params:
            form_params.append(('language', local_var_params['language']))  # noqa: E501
        if 'privacy' in local_var_params:
            form_params.append(('privacy', local_var_params['privacy']))  # noqa: E501
        if 'description' in local_var_params:
            form_params.append(('description', local_var_params['description']))  # noqa: E501
        if 'wait_transcoding' in local_var_params:
            form_params.append(('waitTranscoding', local_var_params['wait_transcoding']))  # noqa: E501
        if 'support' in local_var_params:
            form_params.append(('support', local_var_params['support']))  # noqa: E501
        if 'nsfw' in local_var_params:
            form_params.append(('nsfw', local_var_params['nsfw']))  # noqa: E501
        if 'name' in local_var_params:
            form_params.append(('name', local_var_params['name']))  # noqa: E501
        if 'tags' in local_var_params:
            form_params.append(('tags', local_var_params['tags']))  # noqa: E501
            collection_formats['tags'] = 'csv'  # noqa: E501
        if 'comments_enabled' in local_var_params:
            form_params.append(('commentsEnabled', local_var_params['comments_enabled']))  # noqa: E501
        if 'originally_published_at' in local_var_params:
            form_params.append(('originallyPublishedAt', local_var_params['originally_published_at']))  # noqa: E501
        if 'schedule_update' in local_var_params:
            form_params.append(('scheduleUpdate', local_var_params['schedule_update']))  # noqa: E501

        body_params = None
        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = ['OAuth2']  # noqa: E501

        return self.api_client.call_api(
            '/videos/{id}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def videos_id_views_post(self, id, **kwargs):  # noqa: E501
        """Add a view to a video  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.videos_id_views_post(id, async_req=True)
        >>> result = thread.get()

        :param id: The object id or uuid (required)
        :type id: OneOfintegerUUID
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """
        kwargs['_return_http_data_only'] = True
        return self.videos_id_views_post_with_http_info(id, **kwargs)  # noqa: E501

    def videos_id_views_post_with_http_info(self, id, **kwargs):  # noqa: E501
        """Add a view to a video  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.videos_id_views_post_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param id: The object id or uuid (required)
        :type id: OneOfintegerUUID
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """

        local_var_params = locals()

        all_params = [
            'id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method videos_id_views_post" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `videos_id_views_post`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/videos/{id}/views', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def videos_id_watching_put(self, id, user_watching_video, **kwargs):  # noqa: E501
        """Set watching progress of a video  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.videos_id_watching_put(id, user_watching_video, async_req=True)
        >>> result = thread.get()

        :param id: The object id or uuid (required)
        :type id: OneOfintegerUUID
        :param user_watching_video: (required)
        :type user_watching_video: UserWatchingVideo
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """
        kwargs['_return_http_data_only'] = True
        return self.videos_id_watching_put_with_http_info(id, user_watching_video, **kwargs)  # noqa: E501

    def videos_id_watching_put_with_http_info(self, id, user_watching_video, **kwargs):  # noqa: E501
        """Set watching progress of a video  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.videos_id_watching_put_with_http_info(id, user_watching_video, async_req=True)
        >>> result = thread.get()

        :param id: The object id or uuid (required)
        :type id: OneOfintegerUUID
        :param user_watching_video: (required)
        :type user_watching_video: UserWatchingVideo
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """

        local_var_params = locals()

        all_params = [
            'id',
            'user_watching_video'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method videos_id_watching_put" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `videos_id_watching_put`")  # noqa: E501
        # verify the required parameter 'user_watching_video' is set
        if self.api_client.client_side_validation and ('user_watching_video' not in local_var_params or  # noqa: E501
                                                        local_var_params['user_watching_video'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `user_watching_video` when calling `videos_id_watching_put`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'user_watching_video' in local_var_params:
            body_params = local_var_params['user_watching_video']
        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['OAuth2']  # noqa: E501

        return self.api_client.call_api(
            '/videos/{id}/watching', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def videos_imports_post(self, channel_id, name, **kwargs):  # noqa: E501
        """Import a video  # noqa: E501

        Import a torrent or magnetURI or HTTP resource (if enabled by the instance administrator)  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.videos_imports_post(channel_id, name, async_req=True)
        >>> result = thread.get()

        :param channel_id: Channel id that will contain this video (required)
        :type channel_id: int
        :param name: Video name (required)
        :type name: str
        :param torrentfile: Torrent File
        :type torrentfile: file
        :param target_url: HTTP target URL
        :type target_url: str
        :param magnet_uri: Magnet URI
        :type magnet_uri: str
        :param thumbnailfile: Video thumbnail file
        :type thumbnailfile: file
        :param previewfile: Video preview file
        :type previewfile: file
        :param privacy:
        :type privacy: VideoPrivacySet
        :param category: Video category
        :type category: str
        :param licence: Video licence
        :type licence: str
        :param language: Video language
        :type language: str
        :param description: Video description
        :type description: str
        :param wait_transcoding: Whether or not we wait transcoding before publish the video
        :type wait_transcoding: bool
        :param support: A text tell the audience how to support the video creator
        :type support: str
        :param nsfw: Whether or not this video contains sensitive content
        :type nsfw: bool
        :param tags: Video tags (maximum 5 tags each between 2 and 30 characters)
        :type tags: list[str]
        :param comments_enabled: Enable or disable comments for this video
        :type comments_enabled: bool
        :param download_enabled: Enable or disable downloading for this video
        :type download_enabled: bool
        :param schedule_update:
        :type schedule_update: VideoScheduledUpdate
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: VideoUploadResponse
        """
        kwargs['_return_http_data_only'] = True
        return self.videos_imports_post_with_http_info(channel_id, name, **kwargs)  # noqa: E501

    def videos_imports_post_with_http_info(self, channel_id, name, **kwargs):  # noqa: E501
        """Import a video  # noqa: E501

        Import a torrent or magnetURI or HTTP resource (if enabled by the instance administrator)  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.videos_imports_post_with_http_info(channel_id, name, async_req=True)
        >>> result = thread.get()

        :param channel_id: Channel id that will contain this video (required)
        :type channel_id: int
        :param name: Video name (required)
        :type name: str
        :param torrentfile: Torrent File
        :type torrentfile: file
        :param target_url: HTTP target URL
        :type target_url: str
        :param magnet_uri: Magnet URI
        :type magnet_uri: str
        :param thumbnailfile: Video thumbnail file
        :type thumbnailfile: file
        :param previewfile: Video preview file
        :type previewfile: file
        :param privacy:
        :type privacy: VideoPrivacySet
        :param category: Video category
        :type category: str
        :param licence: Video licence
        :type licence: str
        :param language: Video language
        :type language: str
        :param description: Video description
        :type description: str
        :param wait_transcoding: Whether or not we wait transcoding before publish the video
        :type wait_transcoding: bool
        :param support: A text tell the audience how to support the video creator
        :type support: str
        :param nsfw: Whether or not this video contains sensitive content
        :type nsfw: bool
        :param tags: Video tags (maximum 5 tags each between 2 and 30 characters)
        :type tags: list[str]
        :param comments_enabled: Enable or disable comments for this video
        :type comments_enabled: bool
        :param download_enabled: Enable or disable downloading for this video
        :type download_enabled: bool
        :param schedule_update:
        :type schedule_update: VideoScheduledUpdate
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(VideoUploadResponse, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'channel_id',
            'name',
            'torrentfile',
            'target_url',
            'magnet_uri',
            'thumbnailfile',
            'previewfile',
            'privacy',
            'category',
            'licence',
            'language',
            'description',
            'wait_transcoding',
            'support',
            'nsfw',
            'tags',
            'comments_enabled',
            'download_enabled',
            'schedule_update'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method videos_imports_post" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'channel_id' is set
        if self.api_client.client_side_validation and ('channel_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['channel_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `channel_id` when calling `videos_imports_post`")  # noqa: E501
        # verify the required parameter 'name' is set
        if self.api_client.client_side_validation and ('name' not in local_var_params or  # noqa: E501
                                                        local_var_params['name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `name` when calling `videos_imports_post`")  # noqa: E501

        if self.api_client.client_side_validation and ('tags' in local_var_params and  # noqa: E501
                                                        len(local_var_params['tags']) > 30):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `tags` when calling `videos_imports_post`, length must be less than or equal to `30`")  # noqa: E501
        if self.api_client.client_side_validation and ('tags' in local_var_params and  # noqa: E501
                                                        len(local_var_params['tags']) < 2):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `tags` when calling `videos_imports_post`, length must be greater than or equal to `2`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'torrentfile' in local_var_params:
            local_var_files['torrentfile'] = local_var_params['torrentfile']  # noqa: E501
        if 'target_url' in local_var_params:
            form_params.append(('targetUrl', local_var_params['target_url']))  # noqa: E501
        if 'magnet_uri' in local_var_params:
            form_params.append(('magnetUri', local_var_params['magnet_uri']))  # noqa: E501
        if 'channel_id' in local_var_params:
            form_params.append(('channelId', local_var_params['channel_id']))  # noqa: E501
        if 'thumbnailfile' in local_var_params:
            local_var_files['thumbnailfile'] = local_var_params['thumbnailfile']  # noqa: E501
        if 'previewfile' in local_var_params:
            local_var_files['previewfile'] = local_var_params['previewfile']  # noqa: E501
        if 'privacy' in local_var_params:
            form_params.append(('privacy', local_var_params['privacy']))  # noqa: E501
        if 'category' in local_var_params:
            form_params.append(('category', local_var_params['category']))  # noqa: E501
        if 'licence' in local_var_params:
            form_params.append(('licence', local_var_params['licence']))  # noqa: E501
        if 'language' in local_var_params:
            form_params.append(('language', local_var_params['language']))  # noqa: E501
        if 'description' in local_var_params:
            form_params.append(('description', local_var_params['description']))  # noqa: E501
        if 'wait_transcoding' in local_var_params:
            form_params.append(('waitTranscoding', local_var_params['wait_transcoding']))  # noqa: E501
        if 'support' in local_var_params:
            form_params.append(('support', local_var_params['support']))  # noqa: E501
        if 'nsfw' in local_var_params:
            form_params.append(('nsfw', local_var_params['nsfw']))  # noqa: E501
        if 'name' in local_var_params:
            form_params.append(('name', local_var_params['name']))  # noqa: E501
        if 'tags' in local_var_params:
            form_params.append(('tags', local_var_params['tags']))  # noqa: E501
            collection_formats['tags'] = 'csv'  # noqa: E501
        if 'comments_enabled' in local_var_params:
            form_params.append(('commentsEnabled', local_var_params['comments_enabled']))  # noqa: E501
        if 'download_enabled' in local_var_params:
            form_params.append(('downloadEnabled', local_var_params['download_enabled']))  # noqa: E501
        if 'schedule_update' in local_var_params:
            form_params.append(('scheduleUpdate', local_var_params['schedule_update']))  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = ['OAuth2']  # noqa: E501

        return self.api_client.call_api(
            '/videos/imports', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='VideoUploadResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def videos_languages_get(self, **kwargs):  # noqa: E501
        """List available video languages  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.videos_languages_get(async_req=True)
        >>> result = thread.get()

        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: list[str]
        """
        kwargs['_return_http_data_only'] = True
        return self.videos_languages_get_with_http_info(**kwargs)  # noqa: E501

    def videos_languages_get_with_http_info(self, **kwargs):  # noqa: E501
        """List available video languages  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.videos_languages_get_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(list[str], status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method videos_languages_get" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/videos/languages', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[str]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def videos_licences_get(self, **kwargs):  # noqa: E501
        """List available video licences  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.videos_licences_get(async_req=True)
        >>> result = thread.get()

        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: list[str]
        """
        kwargs['_return_http_data_only'] = True
        return self.videos_licences_get_with_http_info(**kwargs)  # noqa: E501

    def videos_licences_get_with_http_info(self, **kwargs):  # noqa: E501
        """List available video licences  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.videos_licences_get_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(list[str], status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method videos_licences_get" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/videos/licences', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[str]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def videos_live_id_get(self, id, **kwargs):  # noqa: E501
        """Get a live information  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.videos_live_id_get(id, async_req=True)
        >>> result = thread.get()

        :param id: The object id or uuid (required)
        :type id: OneOfintegerUUID
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: LiveVideoResponse
        """
        kwargs['_return_http_data_only'] = True
        return self.videos_live_id_get_with_http_info(id, **kwargs)  # noqa: E501

    def videos_live_id_get_with_http_info(self, id, **kwargs):  # noqa: E501
        """Get a live information  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.videos_live_id_get_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param id: The object id or uuid (required)
        :type id: OneOfintegerUUID
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(LiveVideoResponse, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method videos_live_id_get" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `videos_live_id_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['OAuth2']  # noqa: E501

        return self.api_client.call_api(
            '/videos/live/{id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='LiveVideoResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def videos_live_id_put(self, id, **kwargs):  # noqa: E501
        """Update a live information  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.videos_live_id_put(id, async_req=True)
        >>> result = thread.get()

        :param id: The object id or uuid (required)
        :type id: OneOfintegerUUID
        :param live_video_update:
        :type live_video_update: LiveVideoUpdate
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """
        kwargs['_return_http_data_only'] = True
        return self.videos_live_id_put_with_http_info(id, **kwargs)  # noqa: E501

    def videos_live_id_put_with_http_info(self, id, **kwargs):  # noqa: E501
        """Update a live information  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.videos_live_id_put_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param id: The object id or uuid (required)
        :type id: OneOfintegerUUID
        :param live_video_update:
        :type live_video_update: LiveVideoUpdate
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: None
        """

        local_var_params = locals()

        all_params = [
            'id',
            'live_video_update'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method videos_live_id_put" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `videos_live_id_put`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'live_video_update' in local_var_params:
            body_params = local_var_params['live_video_update']
        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['OAuth2']  # noqa: E501

        return self.api_client.call_api(
            '/videos/live/{id}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def videos_live_post(self, channel_id, name, **kwargs):  # noqa: E501
        """Create a live  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.videos_live_post(channel_id, name, async_req=True)
        >>> result = thread.get()

        :param channel_id: Channel id that will contain this live video (required)
        :type channel_id: int
        :param name: Live video/replay name (required)
        :type name: str
        :param save_replay:
        :type save_replay: bool
        :param thumbnailfile: Live video/replay thumbnail file
        :type thumbnailfile: file
        :param previewfile: Live video/replay preview file
        :type previewfile: file
        :param privacy:
        :type privacy: VideoPrivacySet
        :param category: Live video/replay category
        :type category: str
        :param licence: Live video/replay licence
        :type licence: str
        :param language: Live video/replay language
        :type language: str
        :param description: Live video/replay description
        :type description: str
        :param support: A text tell the audience how to support the creator
        :type support: str
        :param nsfw: Whether or not this live video/replay contains sensitive content
        :type nsfw: bool
        :param tags: Live video/replay tags (maximum 5 tags each between 2 and 30 characters)
        :type tags: list[str]
        :param comments_enabled: Enable or disable comments for this live video/replay
        :type comments_enabled: bool
        :param download_enabled: Enable or disable downloading for the replay of this live
        :type download_enabled: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: VideoUploadResponse
        """
        kwargs['_return_http_data_only'] = True
        return self.videos_live_post_with_http_info(channel_id, name, **kwargs)  # noqa: E501

    def videos_live_post_with_http_info(self, channel_id, name, **kwargs):  # noqa: E501
        """Create a live  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.videos_live_post_with_http_info(channel_id, name, async_req=True)
        >>> result = thread.get()

        :param channel_id: Channel id that will contain this live video (required)
        :type channel_id: int
        :param name: Live video/replay name (required)
        :type name: str
        :param save_replay:
        :type save_replay: bool
        :param thumbnailfile: Live video/replay thumbnail file
        :type thumbnailfile: file
        :param previewfile: Live video/replay preview file
        :type previewfile: file
        :param privacy:
        :type privacy: VideoPrivacySet
        :param category: Live video/replay category
        :type category: str
        :param licence: Live video/replay licence
        :type licence: str
        :param language: Live video/replay language
        :type language: str
        :param description: Live video/replay description
        :type description: str
        :param support: A text tell the audience how to support the creator
        :type support: str
        :param nsfw: Whether or not this live video/replay contains sensitive content
        :type nsfw: bool
        :param tags: Live video/replay tags (maximum 5 tags each between 2 and 30 characters)
        :type tags: list[str]
        :param comments_enabled: Enable or disable comments for this live video/replay
        :type comments_enabled: bool
        :param download_enabled: Enable or disable downloading for the replay of this live
        :type download_enabled: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(VideoUploadResponse, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'channel_id',
            'name',
            'save_replay',
            'thumbnailfile',
            'previewfile',
            'privacy',
            'category',
            'licence',
            'language',
            'description',
            'support',
            'nsfw',
            'tags',
            'comments_enabled',
            'download_enabled'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method videos_live_post" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'channel_id' is set
        if self.api_client.client_side_validation and ('channel_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['channel_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `channel_id` when calling `videos_live_post`")  # noqa: E501
        # verify the required parameter 'name' is set
        if self.api_client.client_side_validation and ('name' not in local_var_params or  # noqa: E501
                                                        local_var_params['name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `name` when calling `videos_live_post`")  # noqa: E501

        if self.api_client.client_side_validation and ('tags' in local_var_params and  # noqa: E501
                                                        len(local_var_params['tags']) > 30):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `tags` when calling `videos_live_post`, length must be less than or equal to `30`")  # noqa: E501
        if self.api_client.client_side_validation and ('tags' in local_var_params and  # noqa: E501
                                                        len(local_var_params['tags']) < 2):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `tags` when calling `videos_live_post`, length must be greater than or equal to `2`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'channel_id' in local_var_params:
            form_params.append(('channelId', local_var_params['channel_id']))  # noqa: E501
        if 'save_replay' in local_var_params:
            form_params.append(('saveReplay', local_var_params['save_replay']))  # noqa: E501
        if 'thumbnailfile' in local_var_params:
            local_var_files['thumbnailfile'] = local_var_params['thumbnailfile']  # noqa: E501
        if 'previewfile' in local_var_params:
            local_var_files['previewfile'] = local_var_params['previewfile']  # noqa: E501
        if 'privacy' in local_var_params:
            form_params.append(('privacy', local_var_params['privacy']))  # noqa: E501
        if 'category' in local_var_params:
            form_params.append(('category', local_var_params['category']))  # noqa: E501
        if 'licence' in local_var_params:
            form_params.append(('licence', local_var_params['licence']))  # noqa: E501
        if 'language' in local_var_params:
            form_params.append(('language', local_var_params['language']))  # noqa: E501
        if 'description' in local_var_params:
            form_params.append(('description', local_var_params['description']))  # noqa: E501
        if 'support' in local_var_params:
            form_params.append(('support', local_var_params['support']))  # noqa: E501
        if 'nsfw' in local_var_params:
            form_params.append(('nsfw', local_var_params['nsfw']))  # noqa: E501
        if 'name' in local_var_params:
            form_params.append(('name', local_var_params['name']))  # noqa: E501
        if 'tags' in local_var_params:
            form_params.append(('tags', local_var_params['tags']))  # noqa: E501
            collection_formats['tags'] = 'csv'  # noqa: E501
        if 'comments_enabled' in local_var_params:
            form_params.append(('commentsEnabled', local_var_params['comments_enabled']))  # noqa: E501
        if 'download_enabled' in local_var_params:
            form_params.append(('downloadEnabled', local_var_params['download_enabled']))  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = ['OAuth2']  # noqa: E501

        return self.api_client.call_api(
            '/videos/live', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='VideoUploadResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def videos_privacies_get(self, **kwargs):  # noqa: E501
        """List available video privacies  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.videos_privacies_get(async_req=True)
        >>> result = thread.get()

        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: list[str]
        """
        kwargs['_return_http_data_only'] = True
        return self.videos_privacies_get_with_http_info(**kwargs)  # noqa: E501

    def videos_privacies_get_with_http_info(self, **kwargs):  # noqa: E501
        """List available video privacies  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.videos_privacies_get_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(list[str], status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method videos_privacies_get" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/videos/privacies', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[str]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def videos_upload_post(self, videofile, channel_id, name, **kwargs):  # noqa: E501
        """Upload a video  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.videos_upload_post(videofile, channel_id, name, async_req=True)
        >>> result = thread.get()

        :param videofile: Video file (required)
        :type videofile: file
        :param channel_id: Channel id that will contain this video (required)
        :type channel_id: int
        :param name: Video name (required)
        :type name: str
        :param thumbnailfile: Video thumbnail file
        :type thumbnailfile: file
        :param previewfile: Video preview file
        :type previewfile: file
        :param privacy:
        :type privacy: VideoPrivacySet
        :param category: Video category
        :type category: int
        :param licence: Video licence
        :type licence: str
        :param language: Video language
        :type language: int
        :param description: Video description
        :type description: str
        :param wait_transcoding: Whether or not we wait transcoding before publish the video
        :type wait_transcoding: bool
        :param support: A text tell the audience how to support the video creator
        :type support: str
        :param nsfw: Whether or not this video contains sensitive content
        :type nsfw: bool
        :param tags: Video tags (maximum 5 tags each between 2 and 30 characters)
        :type tags: list[str]
        :param comments_enabled: Enable or disable comments for this video
        :type comments_enabled: bool
        :param download_enabled: Enable or disable downloading for this video
        :type download_enabled: bool
        :param originally_published_at: Date when the content was originally published
        :type originally_published_at: datetime
        :param schedule_update:
        :type schedule_update: VideoScheduledUpdate
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: VideoUploadResponse
        """
        kwargs['_return_http_data_only'] = True
        return self.videos_upload_post_with_http_info(videofile, channel_id, name, **kwargs)  # noqa: E501

    def videos_upload_post_with_http_info(self, videofile, channel_id, name, **kwargs):  # noqa: E501
        """Upload a video  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.videos_upload_post_with_http_info(videofile, channel_id, name, async_req=True)
        >>> result = thread.get()

        :param videofile: Video file (required)
        :type videofile: file
        :param channel_id: Channel id that will contain this video (required)
        :type channel_id: int
        :param name: Video name (required)
        :type name: str
        :param thumbnailfile: Video thumbnail file
        :type thumbnailfile: file
        :param previewfile: Video preview file
        :type previewfile: file
        :param privacy:
        :type privacy: VideoPrivacySet
        :param category: Video category
        :type category: int
        :param licence: Video licence
        :type licence: str
        :param language: Video language
        :type language: int
        :param description: Video description
        :type description: str
        :param wait_transcoding: Whether or not we wait transcoding before publish the video
        :type wait_transcoding: bool
        :param support: A text tell the audience how to support the video creator
        :type support: str
        :param nsfw: Whether or not this video contains sensitive content
        :type nsfw: bool
        :param tags: Video tags (maximum 5 tags each between 2 and 30 characters)
        :type tags: list[str]
        :param comments_enabled: Enable or disable comments for this video
        :type comments_enabled: bool
        :param download_enabled: Enable or disable downloading for this video
        :type download_enabled: bool
        :param originally_published_at: Date when the content was originally published
        :type originally_published_at: datetime
        :param schedule_update:
        :type schedule_update: VideoScheduledUpdate
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(VideoUploadResponse, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'videofile',
            'channel_id',
            'name',
            'thumbnailfile',
            'previewfile',
            'privacy',
            'category',
            'licence',
            'language',
            'description',
            'wait_transcoding',
            'support',
            'nsfw',
            'tags',
            'comments_enabled',
            'download_enabled',
            'originally_published_at',
            'schedule_update'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method videos_upload_post" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'videofile' is set
        if self.api_client.client_side_validation and ('videofile' not in local_var_params or  # noqa: E501
                                                        local_var_params['videofile'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `videofile` when calling `videos_upload_post`")  # noqa: E501
        # verify the required parameter 'channel_id' is set
        if self.api_client.client_side_validation and ('channel_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['channel_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `channel_id` when calling `videos_upload_post`")  # noqa: E501
        # verify the required parameter 'name' is set
        if self.api_client.client_side_validation and ('name' not in local_var_params or  # noqa: E501
                                                        local_var_params['name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `name` when calling `videos_upload_post`")  # noqa: E501

        if self.api_client.client_side_validation and ('tags' in local_var_params and  # noqa: E501
                                                        len(local_var_params['tags']) > 30):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `tags` when calling `videos_upload_post`, length must be less than or equal to `30`")  # noqa: E501
        if self.api_client.client_side_validation and ('tags' in local_var_params and  # noqa: E501
                                                        len(local_var_params['tags']) < 2):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `tags` when calling `videos_upload_post`, length must be greater than or equal to `2`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'videofile' in local_var_params:
            local_var_files['videofile'] = local_var_params['videofile']  # noqa: E501
        if 'channel_id' in local_var_params:
            form_params.append(('channelId', local_var_params['channel_id']))  # noqa: E501
        if 'thumbnailfile' in local_var_params:
            local_var_files['thumbnailfile'] = local_var_params['thumbnailfile']  # noqa: E501
        if 'previewfile' in local_var_params:
            local_var_files['previewfile'] = local_var_params['previewfile']  # noqa: E501
        if 'privacy' in local_var_params:
            form_params.append(('privacy', local_var_params['privacy']))  # noqa: E501
        if 'category' in local_var_params:
            form_params.append(('category', local_var_params['category']))  # noqa: E501
        if 'licence' in local_var_params:
            form_params.append(('licence', local_var_params['licence']))  # noqa: E501
        if 'language' in local_var_params:
            form_params.append(('language', local_var_params['language']))  # noqa: E501
        if 'description' in local_var_params:
            form_params.append(('description', local_var_params['description']))  # noqa: E501
        if 'wait_transcoding' in local_var_params:
            form_params.append(('waitTranscoding', local_var_params['wait_transcoding']))  # noqa: E501
        if 'support' in local_var_params:
            form_params.append(('support', local_var_params['support']))  # noqa: E501
        if 'nsfw' in local_var_params:
            form_params.append(('nsfw', local_var_params['nsfw']))  # noqa: E501
        if 'name' in local_var_params:
            form_params.append(('name', local_var_params['name']))  # noqa: E501
        if 'tags' in local_var_params:
            form_params.append(('tags', local_var_params['tags']))  # noqa: E501
            collection_formats['tags'] = 'csv'  # noqa: E501
        if 'comments_enabled' in local_var_params:
            form_params.append(('commentsEnabled', local_var_params['comments_enabled']))  # noqa: E501
        if 'download_enabled' in local_var_params:
            form_params.append(('downloadEnabled', local_var_params['download_enabled']))  # noqa: E501
        if 'originally_published_at' in local_var_params:
            form_params.append(('originallyPublishedAt', local_var_params['originally_published_at']))  # noqa: E501
        if 'schedule_update' in local_var_params:
            form_params.append(('scheduleUpdate', local_var_params['schedule_update']))  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = ['OAuth2']  # noqa: E501

        return self.api_client.call_api(
            '/videos/upload', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='VideoUploadResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))
