# coding: utf-8

"""
    PeerTube

    # Introduction  The PeerTube API is built on HTTP(S) and is RESTful. You can use your favorite HTTP/REST library for your programming language to use PeerTube. The spec API is fully compatible with [openapi-generator](https://github.com/OpenAPITools/openapi-generator/wiki/API-client-generator-HOWTO) which generates a client SDK in the language of your choice - we generate some client SDKs automatically:  - [Python](https://framagit.org/framasoft/peertube/clients/python) - [Go](https://framagit.org/framasoft/peertube/clients/go) - [Kotlin](https://framagit.org/framasoft/peertube/clients/kotlin)  See the [Quick Start guide](https://docs.joinpeertube.org/#/api-rest-getting-started) so you can play with the PeerTube API.  # Authentication  When you sign up for an account, you are given the possibility to generate sessions, and authenticate using this session token. One session token can currently be used at a time.  ## Roles  Accounts are given permissions based on their role. There are three roles on PeerTube: Administrator, Moderator, and User. See the [roles guide](https://docs.joinpeertube.org/#/admin-managing-users?id=roles) for a detail of their permissions.  # Errors  The API uses standard HTTP status codes to indicate the success or failure of the API call. The body of the response will be JSON in the following format.  ``` {   \"code\": \"unauthorized_request\", // example inner error code   \"error\": \"Token is invalid.\" // example exposed error message } ```   # noqa: E501

    The version of the OpenAPI document: 2.4.0
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from peertube.configuration import Configuration


class VideoFile(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'magnet_uri': 'str',
        'resolution': 'VideoResolutionConstant',
        'size': 'int',
        'torrent_url': 'str',
        'torrent_download_url': 'str',
        'file_url': 'str',
        'file_download_url': 'str',
        'fps': 'float',
        'metadata_url': 'str'
    }

    attribute_map = {
        'magnet_uri': 'magnetUri',
        'resolution': 'resolution',
        'size': 'size',
        'torrent_url': 'torrentUrl',
        'torrent_download_url': 'torrentDownloadUrl',
        'file_url': 'fileUrl',
        'file_download_url': 'fileDownloadUrl',
        'fps': 'fps',
        'metadata_url': 'metadataUrl'
    }

    def __init__(self, magnet_uri=None, resolution=None, size=None, torrent_url=None, torrent_download_url=None, file_url=None, file_download_url=None, fps=None, metadata_url=None, local_vars_configuration=None):  # noqa: E501
        """VideoFile - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._magnet_uri = None
        self._resolution = None
        self._size = None
        self._torrent_url = None
        self._torrent_download_url = None
        self._file_url = None
        self._file_download_url = None
        self._fps = None
        self._metadata_url = None
        self.discriminator = None

        if magnet_uri is not None:
            self.magnet_uri = magnet_uri
        if resolution is not None:
            self.resolution = resolution
        if size is not None:
            self.size = size
        if torrent_url is not None:
            self.torrent_url = torrent_url
        if torrent_download_url is not None:
            self.torrent_download_url = torrent_download_url
        if file_url is not None:
            self.file_url = file_url
        if file_download_url is not None:
            self.file_download_url = file_download_url
        if fps is not None:
            self.fps = fps
        if metadata_url is not None:
            self.metadata_url = metadata_url

    @property
    def magnet_uri(self):
        """Gets the magnet_uri of this VideoFile.  # noqa: E501


        :return: The magnet_uri of this VideoFile.  # noqa: E501
        :rtype: str
        """
        return self._magnet_uri

    @magnet_uri.setter
    def magnet_uri(self, magnet_uri):
        """Sets the magnet_uri of this VideoFile.


        :param magnet_uri: The magnet_uri of this VideoFile.  # noqa: E501
        :type magnet_uri: str
        """

        self._magnet_uri = magnet_uri

    @property
    def resolution(self):
        """Gets the resolution of this VideoFile.  # noqa: E501


        :return: The resolution of this VideoFile.  # noqa: E501
        :rtype: VideoResolutionConstant
        """
        return self._resolution

    @resolution.setter
    def resolution(self, resolution):
        """Sets the resolution of this VideoFile.


        :param resolution: The resolution of this VideoFile.  # noqa: E501
        :type resolution: VideoResolutionConstant
        """

        self._resolution = resolution

    @property
    def size(self):
        """Gets the size of this VideoFile.  # noqa: E501

        Video file size in bytes  # noqa: E501

        :return: The size of this VideoFile.  # noqa: E501
        :rtype: int
        """
        return self._size

    @size.setter
    def size(self, size):
        """Sets the size of this VideoFile.

        Video file size in bytes  # noqa: E501

        :param size: The size of this VideoFile.  # noqa: E501
        :type size: int
        """

        self._size = size

    @property
    def torrent_url(self):
        """Gets the torrent_url of this VideoFile.  # noqa: E501


        :return: The torrent_url of this VideoFile.  # noqa: E501
        :rtype: str
        """
        return self._torrent_url

    @torrent_url.setter
    def torrent_url(self, torrent_url):
        """Sets the torrent_url of this VideoFile.


        :param torrent_url: The torrent_url of this VideoFile.  # noqa: E501
        :type torrent_url: str
        """

        self._torrent_url = torrent_url

    @property
    def torrent_download_url(self):
        """Gets the torrent_download_url of this VideoFile.  # noqa: E501


        :return: The torrent_download_url of this VideoFile.  # noqa: E501
        :rtype: str
        """
        return self._torrent_download_url

    @torrent_download_url.setter
    def torrent_download_url(self, torrent_download_url):
        """Sets the torrent_download_url of this VideoFile.


        :param torrent_download_url: The torrent_download_url of this VideoFile.  # noqa: E501
        :type torrent_download_url: str
        """

        self._torrent_download_url = torrent_download_url

    @property
    def file_url(self):
        """Gets the file_url of this VideoFile.  # noqa: E501


        :return: The file_url of this VideoFile.  # noqa: E501
        :rtype: str
        """
        return self._file_url

    @file_url.setter
    def file_url(self, file_url):
        """Sets the file_url of this VideoFile.


        :param file_url: The file_url of this VideoFile.  # noqa: E501
        :type file_url: str
        """

        self._file_url = file_url

    @property
    def file_download_url(self):
        """Gets the file_download_url of this VideoFile.  # noqa: E501


        :return: The file_download_url of this VideoFile.  # noqa: E501
        :rtype: str
        """
        return self._file_download_url

    @file_download_url.setter
    def file_download_url(self, file_download_url):
        """Sets the file_download_url of this VideoFile.


        :param file_download_url: The file_download_url of this VideoFile.  # noqa: E501
        :type file_download_url: str
        """

        self._file_download_url = file_download_url

    @property
    def fps(self):
        """Gets the fps of this VideoFile.  # noqa: E501


        :return: The fps of this VideoFile.  # noqa: E501
        :rtype: float
        """
        return self._fps

    @fps.setter
    def fps(self, fps):
        """Sets the fps of this VideoFile.


        :param fps: The fps of this VideoFile.  # noqa: E501
        :type fps: float
        """

        self._fps = fps

    @property
    def metadata_url(self):
        """Gets the metadata_url of this VideoFile.  # noqa: E501


        :return: The metadata_url of this VideoFile.  # noqa: E501
        :rtype: str
        """
        return self._metadata_url

    @metadata_url.setter
    def metadata_url(self, metadata_url):
        """Sets the metadata_url of this VideoFile.


        :param metadata_url: The metadata_url of this VideoFile.  # noqa: E501
        :type metadata_url: str
        """

        self._metadata_url = metadata_url

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, VideoFile):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, VideoFile):
            return True

        return self.to_dict() != other.to_dict()
