/*
 * Copyright (c) 2012, 2022, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2012 Unicode, Inc. All rights reserved. Distributed under
 * the Terms of Use in http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of the Unicode data files and any associated documentation (the "Data
 * Files") or Unicode software and any associated documentation (the
 * "Software") to deal in the Data Files or Software without restriction,
 * including without limitation the rights to use, copy, modify, merge,
 * publish, distribute, and/or sell copies of the Data Files or Software, and
 * to permit persons to whom the Data Files or Software are furnished to do so,
 * provided that (a) the above copyright notice(s) and this permission notice
 * appear with all copies of the Data Files or Software, (b) both the above
 * copyright notice(s) and this permission notice appear in associated
 * documentation, and (c) there is clear notice in each modified Data File or
 * in the Software as well as in the documentation associated with the Data
 * File(s) or Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF ANY
 * KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT OF
 * THIRD PARTY RIGHTS. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS
 * INCLUDED IN THIS NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR
 * CONSEQUENTIAL DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE
 * OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder shall not
 * be used in advertising or otherwise to promote the sale, use or other
 * dealings in these Data Files or Software without prior written authorization
 * of the copyright holder.
 */

package sun.util.resources.cldr.it;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_it extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final Object[][] data = new Object[][] {
            { "001", "Mondo" },
            { "002", "Africa" },
            { "003", "Nord America" },
            { "005", "America del Sud" },
            { "009", "Oceania" },
            { "011", "Africa occidentale" },
            { "013", "America centrale" },
            { "014", "Africa orientale" },
            { "015", "Africa del Nord" },
            { "017", "Africa centrale" },
            { "018", "Africa del Sud" },
            { "019", "Americhe" },
            { "021", "America del Nord" },
            { "029", "Caraibi" },
            { "030", "Asia orientale" },
            { "034", "Asia del Sud" },
            { "035", "Asia sudorientale" },
            { "039", "Europa del Sud" },
            { "053", "Australia e Nuova Zelanda" },
            { "054", "Melanesia" },
            { "057", "Regione Micronesiana" },
            { "061", "Polinesia" },
            { "142", "Asia" },
            { "143", "Asia centrale" },
            { "145", "Asia occidentale" },
            { "150", "Europa" },
            { "151", "Europa orientale" },
            { "154", "Europa del Nord" },
            { "155", "Europa occidentale" },
            { "419", "America Latina" },
            { "AC", "Isola di Ascensione" },
            { "AD", "Andorra" },
            { "AE", "Emirati Arabi Uniti" },
            { "AF", "Afghanistan" },
            { "AG", "Antigua e Barbuda" },
            { "AI", "Anguilla" },
            { "AL", "Albania" },
            { "AM", "Armenia" },
            { "AN", "Antille Olandesi" },
            { "AO", "Angola" },
            { "AQ", "Antartide" },
            { "AR", "Argentina" },
            { "AS", "Samoa Americane" },
            { "AT", "Austria" },
            { "AU", "Australia" },
            { "AW", "Aruba" },
            { "AX", "Isole Aland" },
            { "AZ", "Azerbaigian" },
            { "BA", "Bosnia Erzegovina" },
            { "BB", "Barbados" },
            { "BD", "Bangladesh" },
            { "BE", "Belgio" },
            { "BF", "Burkina Faso" },
            { "BG", "Bulgaria" },
            { "BH", "Bahrein" },
            { "BI", "Burundi" },
            { "BJ", "Benin" },
            { "BL", "San Bartolomeo" },
            { "BM", "Bermuda" },
            { "BN", "Brunei" },
            { "BO", "Bolivia" },
            { "BR", "Brasile" },
            { "BS", "Bahamas" },
            { "BT", "Bhutan" },
            { "BV", "Isola Bouvet" },
            { "BW", "Botswana" },
            { "BY", "Bielorussia" },
            { "BZ", "Belize" },
            { "CA", "Canada" },
            { "CC", "Isole Cocos" },
            { "CD", "Repubblica Democratica del Congo" },
            { "CF", "Repubblica Centrafricana" },
            { "CG", "Congo" },
            { "CH", "Svizzera" },
            { "CI", "Costa d\u2019Avorio" },
            { "CK", "Isole Cook" },
            { "CL", "Cile" },
            { "CM", "Camerun" },
            { "CN", "Cina" },
            { "CO", "Colombia" },
            { "CP", "Isola di Clipperton" },
            { "CR", "Costa Rica" },
            { "CS", "Serbia e Montenegro" },
            { "CU", "Cuba" },
            { "CV", "Capo Verde" },
            { "CX", "Isola di Christmas" },
            { "CY", "Cipro" },
            { "CZ", "Repubblica Ceca" },
            { "DE", "Germania" },
            { "DG", "Diego Garcia" },
            { "DJ", "Gibuti" },
            { "DK", "Danimarca" },
            { "DM", "Dominica" },
            { "DO", "Repubblica Dominicana" },
            { "DZ", "Algeria" },
            { "EA", "Ceuta e Melilla" },
            { "EC", "Ecuador" },
            { "EE", "Estonia" },
            { "EG", "Egitto" },
            { "EH", "Sahara Occidentale" },
            { "ER", "Eritrea" },
            { "ES", "Spagna" },
            { "ET", "Etiopia" },
            { "EU", "Unione Europea" },
            { "FI", "Finlandia" },
            { "FJ", "Figi" },
            { "FK", "Isole Falkland" },
            { "FM", "Micronesia" },
            { "FO", "Isole Faroe" },
            { "FR", "Francia" },
            { "FX", "Francia metropolitana" },
            { "GA", "Gabon" },
            { "GB", "Regno Unito" },
            { "GD", "Grenada" },
            { "GE", "Georgia" },
            { "GF", "Guiana Francese" },
            { "GG", "Guernsey" },
            { "GH", "Ghana" },
            { "GI", "Gibilterra" },
            { "GL", "Groenlandia" },
            { "GM", "Gambia" },
            { "GN", "Guinea" },
            { "GP", "Guadalupa" },
            { "GQ", "Guinea Equatoriale" },
            { "GR", "Grecia" },
            { "GS", "Georgia del Sud e Isole Sandwich del Sud" },
            { "GT", "Guatemala" },
            { "GU", "Guam" },
            { "GW", "Guinea-Bissau" },
            { "GY", "Guyana" },
            { "HK", "Regione Amministrativa Speciale di Hong Kong della Repubblica Popolare Cinese" },
            { "HM", "Isole Heard ed Isole McDonald" },
            { "HN", "Honduras" },
            { "HR", "Croazia" },
            { "HT", "Haiti" },
            { "HU", "Ungheria" },
            { "IC", "Isole Canarie" },
            { "ID", "Indonesia" },
            { "IE", "Irlanda" },
            { "IL", "Israele" },
            { "IM", "Isola di Man" },
            { "IN", "India" },
            { "IO", "Territorio Britannico dell\u2019Oceano Indiano" },
            { "IQ", "Iraq" },
            { "IR", "Iran" },
            { "IS", "Islanda" },
            { "IT", "Italia" },
            { "JE", "Jersey" },
            { "JM", "Giamaica" },
            { "JO", "Giordania" },
            { "JP", "Giappone" },
            { "KE", "Kenya" },
            { "KG", "Kirghizistan" },
            { "KH", "Cambogia" },
            { "KI", "Kiribati" },
            { "KM", "Comore" },
            { "KN", "Saint Kitts e Nevis" },
            { "KP", "Corea del Nord" },
            { "KR", "Corea del Sud" },
            { "KW", "Kuwait" },
            { "KY", "Isole Cayman" },
            { "KZ", "Kazakistan" },
            { "LA", "Laos" },
            { "LB", "Libano" },
            { "LC", "Saint Lucia" },
            { "LI", "Liechtenstein" },
            { "LK", "Sri Lanka" },
            { "LR", "Liberia" },
            { "LS", "Lesotho" },
            { "LT", "Lituania" },
            { "LU", "Lussemburgo" },
            { "LV", "Lettonia" },
            { "LY", "Libia" },
            { "MA", "Marocco" },
            { "MC", "Monaco" },
            { "MD", "Moldavia" },
            { "ME", "Montenegro" },
            { "MF", "Saint Martin" },
            { "MG", "Madagascar" },
            { "MH", "Isole Marshall" },
            { "MK", "Repubblica di Macedonia" },
            { "ML", "Mali" },
            { "MM", "Myanmar" },
            { "MN", "Mongolia" },
            { "MO", "Regione Amministrativa Speciale di Macao della Repubblica Popolare Cinese" },
            { "MP", "Isole Marianne Settentrionali" },
            { "MQ", "Martinica" },
            { "MR", "Mauritania" },
            { "MS", "Montserrat" },
            { "MT", "Malta" },
            { "MU", "Mauritius" },
            { "MV", "Maldive" },
            { "MW", "Malawi" },
            { "MX", "Messico" },
            { "MY", "Malesia" },
            { "MZ", "Mozambico" },
            { "NA", "Namibia" },
            { "NC", "Nuova Caledonia" },
            { "NE", "Niger" },
            { "NF", "Isola Norfolk" },
            { "NG", "Nigeria" },
            { "NI", "Nicaragua" },
            { "NL", "Paesi Bassi" },
            { "NO", "Norvegia" },
            { "NP", "Nepal" },
            { "NR", "Nauru" },
            { "NU", "Niue" },
            { "NZ", "Nuova Zelanda" },
            { "OM", "Oman" },
            { "PA", "Panama" },
            { "PE", "Per\u00f9" },
            { "PF", "Polinesia Francese" },
            { "PG", "Papua Nuova Guinea" },
            { "PH", "Filippine" },
            { "PK", "Pakistan" },
            { "PL", "Polonia" },
            { "PM", "Saint Pierre e Miquelon" },
            { "PN", "Pitcairn" },
            { "PR", "Portorico" },
            { "PS", "Territori palestinesi" },
            { "PT", "Portogallo" },
            { "PW", "Palau" },
            { "PY", "Paraguay" },
            { "QA", "Qatar" },
            { "QO", "Oceania lontana" },
            { "RE", "R\u00e9union" },
            { "RO", "Romania" },
            { "RS", "Serbia" },
            { "RU", "Federazione Russa" },
            { "RW", "Ruanda" },
            { "SA", "Arabia Saudita" },
            { "SB", "Isole Solomon" },
            { "SC", "Seychelles" },
            { "SD", "Sudan" },
            { "SE", "Svezia" },
            { "SG", "Singapore" },
            { "SH", "Sant\u2019Elena" },
            { "SI", "Slovenia" },
            { "SJ", "Svalbard e Jan Mayen" },
            { "SK", "Slovacchia" },
            { "SL", "Sierra Leone" },
            { "SM", "San Marino" },
            { "SN", "Senegal" },
            { "SO", "Somalia" },
            { "SR", "Suriname" },
            { "ST", "Sao Tom\u00e9 e Pr\u00edncipe" },
            { "SV", "El Salvador" },
            { "SY", "Siria" },
            { "SZ", "Swaziland" },
            { "TA", "Tristan da Cunha" },
            { "TC", "Isole Turks e Caicos" },
            { "TD", "Ciad" },
            { "TF", "Territori australi francesi" },
            { "TG", "Togo" },
            { "TH", "Tailandia" },
            { "TJ", "Tagikistan" },
            { "TK", "Tokelau" },
            { "TL", "Timor Est" },
            { "TM", "Turkmenistan" },
            { "TN", "Tunisia" },
            { "TO", "Tonga" },
            { "TR", "Turchia" },
            { "TT", "Trinidad e Tobago" },
            { "TV", "Tuvalu" },
            { "TW", "Taiwan" },
            { "TZ", "Tanzania" },
            { "UA", "Ucraina" },
            { "UG", "Uganda" },
            { "UM", "Isole Minori lontane dagli Stati Uniti" },
            { "US", "Stati Uniti" },
            { "UY", "Uruguay" },
            { "UZ", "Uzbekistan" },
            { "VA", "Vaticano" },
            { "VC", "Saint Vincent e Grenadines" },
            { "VE", "Venezuela" },
            { "VG", "Isole Vergini Britanniche" },
            { "VI", "Isole Vergini Americane" },
            { "VN", "Vietnam" },
            { "VU", "Vanuatu" },
            { "WF", "Wallis e Futuna" },
            { "WS", "Samoa" },
            { "YE", "Yemen" },
            { "YT", "Mayotte" },
            { "ZA", "Sudafrica" },
            { "ZM", "Zambia" },
            { "ZW", "Zimbabwe" },
            { "ZZ", "Regione non valida o sconosciuta" },
            { "aa", "afar" },
            { "ab", "abkhazian" },
            { "ae", "avestan" },
            { "af", "afrikaans" },
            { "ak", "akan" },
            { "am", "amarico" },
            { "an", "aragonese" },
            { "ar", "arabo" },
            { "as", "assamese" },
            { "av", "avaro" },
            { "ay", "aymara" },
            { "az", "azerbaigiano" },
            { "ba", "baschiro" },
            { "be", "bielorusso" },
            { "bg", "bulgaro" },
            { "bh", "bihari" },
            { "bi", "bislama" },
            { "bm", "bambara" },
            { "bn", "bengalese" },
            { "bo", "tibetano" },
            { "br", "bretone" },
            { "bs", "bosniaco" },
            { "ca", "catalano" },
            { "ce", "ceceno" },
            { "ch", "chamorro" },
            { "co", "corso" },
            { "cr", "cree" },
            { "cs", "ceco" },
            { "cu", "slavo della Chiesa" },
            { "cv", "chuvash" },
            { "cy", "gallese" },
            { "da", "danese" },
            { "de", "tedesco" },
            { "dv", "divehi" },
            { "dz", "dzongkha" },
            { "ee", "ewe" },
            { "el", "greco" },
            { "en", "inglese" },
            { "eo", "esperanto" },
            { "es", "spagnolo" },
            { "et", "estone" },
            { "eu", "basco" },
            { "fa", "persiano" },
            { "ff", "fulah" },
            { "fi", "finlandese" },
            { "fj", "figiano" },
            { "fo", "faroese" },
            { "fr", "francese" },
            { "fy", "frisone" },
            { "ga", "irlandese" },
            { "gd", "gaelico scozzese" },
            { "gl", "galiziano" },
            { "gn", "guarana" },
            { "gu", "gujarati" },
            { "gv", "manx" },
            { "ha", "haussa" },
            { "he", "ebraico" },
            { "hi", "hindi" },
            { "ho", "hiri motu" },
            { "hr", "croato" },
            { "ht", "haitiano" },
            { "hu", "ungherese" },
            { "hy", "armeno" },
            { "hz", "herero" },
            { "ia", "interlingua" },
            { "id", "indonesiano" },
            { "ie", "interlingue" },
            { "ig", "igbo" },
            { "ii", "sichuan yi" },
            { "ik", "inupiak" },
            { "io", "ido" },
            { "is", "islandese" },
            { "it", "italiano" },
            { "iu", "inuktitut" },
            { "ja", "giapponese" },
            { "jv", "giavanese" },
            { "ka", "georgiano" },
            { "kg", "kongo" },
            { "ki", "kikuyu" },
            { "kj", "kuanyama" },
            { "kk", "kazako" },
            { "kl", "kalaallisut" },
            { "km", "khmer" },
            { "kn", "kannada" },
            { "ko", "coreano" },
            { "kr", "kanuri" },
            { "ks", "kashmiri" },
            { "ku", "curdo" },
            { "kv", "komi" },
            { "kw", "cornico" },
            { "ky", "kirghiso" },
            { "la", "latino" },
            { "lb", "lussemburghese" },
            { "lg", "ganda" },
            { "li", "limburgese" },
            { "ln", "lingala" },
            { "lo", "lao" },
            { "lt", "lituano" },
            { "lu", "luba-katanga" },
            { "lv", "lettone" },
            { "mg", "malgascio" },
            { "mh", "marshallese" },
            { "mi", "maori" },
            { "mk", "macedone" },
            { "ml", "malayalam" },
            { "mn", "mongolo" },
            { "mo", "moldavo" },
            { "mr", "marathi" },
            { "ms", "malese" },
            { "mt", "maltese" },
            { "my", "birmano" },
            { "na", "nauru" },
            { "nb", "norvegese bokmal" },
            { "nd", "ndebele del nord" },
            { "ne", "nepalese" },
            { "ng", "ndonga" },
            { "nl", "olandese" },
            { "nn", "norvegese nynorsk" },
            { "no", "norvegese" },
            { "nr", "ndebele del sud" },
            { "nv", "navajo" },
            { "ny", "nyanja" },
            { "oc", "occitano" },
            { "oj", "ojibwa" },
            { "om", "oromo" },
            { "or", "oriya" },
            { "os", "ossetico" },
            { "pa", "punjabi" },
            { "pi", "pali" },
            { "pl", "polacco" },
            { "ps", "pashto" },
            { "pt", "portoghese" },
            { "qu", "quechua" },
            { "rm", "lingua rhaeto-romance" },
            { "rn", "rundi" },
            { "ro", "rumeno" },
            { "ru", "russo" },
            { "rw", "kinyarwanda" },
            { "sa", "sanscrito" },
            { "sc", "sardo" },
            { "sd", "sindhi" },
            { "se", "sami del nord" },
            { "sg", "sango" },
            { "sh", "serbo-croato" },
            { "si", "singalese" },
            { "sk", "slovacco" },
            { "sl", "sloveno" },
            { "sm", "samoano" },
            { "sn", "shona" },
            { "so", "somalo" },
            { "sq", "albanese" },
            { "sr", "serbo" },
            { "ss", "swati" },
            { "st", "sotho del sud" },
            { "su", "sundanese" },
            { "sv", "svedese" },
            { "sw", "swahili" },
            { "ta", "tamil" },
            { "te", "telugu" },
            { "tg", "tagicco" },
            { "th", "thai" },
            { "ti", "tigrinya" },
            { "tk", "turcomanno" },
            { "tl", "tagalog" },
            { "tn", "tswana" },
            { "to", "tonga" },
            { "tr", "turco" },
            { "ts", "tsonga" },
            { "tt", "tatarico" },
            { "tw", "ci" },
            { "ty", "taitiano" },
            { "ug", "uigurico" },
            { "uk", "ucraino" },
            { "ur", "urdu" },
            { "uz", "usbeco" },
            { "ve", "venda" },
            { "vi", "vietnamita" },
            { "vo", "volap\u00fck" },
            { "wa", "vallone" },
            { "wo", "volof" },
            { "xh", "xosa" },
            { "yi", "yiddish" },
            { "yo", "yoruba" },
            { "za", "zhuang" },
            { "zh", "cinese" },
            { "zu", "zulu" },
            { "ace", "accinese" },
            { "ach", "acioli" },
            { "ada", "adangme" },
            { "ady", "adyghe" },
            { "afa", "lingua afroasiatica" },
            { "afh", "afrihili" },
            { "ain", "ainu" },
            { "akk", "accado" },
            { "ale", "aleuto" },
            { "alg", "lingue algonchine" },
            { "alt", "altai meridionale" },
            { "ang", "inglese antico" },
            { "anp", "angika" },
            { "apa", "lingue apache" },
            { "arc", "aramaico" },
            { "arn", "araucano" },
            { "arp", "arapaho" },
            { "art", "lingua artificiale" },
            { "arw", "aruaco" },
            { "ast", "asturiano" },
            { "ath", "lingue athabaska" },
            { "aus", "lingue australiane" },
            { "awa", "awadhi" },
            { "bad", "banda" },
            { "bai", "lingue bamileke" },
            { "bal", "beluci" },
            { "ban", "balinese" },
            { "bas", "basa" },
            { "bat", "lingua baltica" },
            { "bej", "begia" },
            { "bem", "wemba" },
            { "ber", "berbero" },
            { "bho", "bhojpuri" },
            { "bik", "bicol" },
            { "bin", "bini" },
            { "bla", "siksika" },
            { "bnt", "bantu" },
            { "bra", "braj" },
            { "btk", "batak" },
            { "bua", "buriat" },
            { "bug", "bugi" },
            { "byn", "blin" },
            { "cad", "caddo" },
            { "cai", "lingua indiana dell'America Centrale" },
            { "car", "caribico" },
            { "cau", "lingua caucasica" },
            { "cch", "atsam" },
            { "ceb", "cebuano" },
            { "cel", "celtica altra lingua" },
            { "chb", "chibcha" },
            { "chg", "ciagataico" },
            { "chk", "chuukese" },
            { "chm", "mari" },
            { "chn", "gergo chinook" },
            { "cho", "choctaw" },
            { "chp", "chipewyan" },
            { "chr", "cherokee" },
            { "chy", "cheyenne" },
            { "cmc", "lingue chamic" },
            { "cop", "copto" },
            { "cpe", "creolo o pidgin basati sull'inglese" },
            { "cpf", "creolo o pidgin basati sul francese" },
            { "cpp", "creolo o pidgin basati sul portoghese" },
            { "crh", "turco crimeo" },
            { "crp", "creolo o pidgin" },
            { "csb", "kashubian" },
            { "cus", "lingua cuscitica" },
            { "dak", "dakota" },
            { "dar", "dargwa" },
            { "day", "dayak" },
            { "del", "delaware" },
            { "den", "slave" },
            { "dgr", "dogrib" },
            { "din", "dinca" },
            { "doi", "dogri" },
            { "dra", "lingua dravidica" },
            { "dsb", "basso sorabo" },
            { "dua", "duala" },
            { "dum", "olandese medio" },
            { "dyu", "diula" },
            { "efi", "efik" },
            { "egy", "egiziano antico" },
            { "eka", "ekajuka" },
            { "elx", "elamitico" },
            { "enm", "inglese medio" },
            { "ewo", "ewondo" },
            { "fan", "fang" },
            { "fat", "fanti" },
            { "fil", "filippino" },
            { "fiu", "lingua ungrofinnica" },
            { "frm", "francese medio" },
            { "fro", "francese antico" },
            { "frr", "frisone settentrionale" },
            { "fur", "friulano" },
            { "gaa", "ga" },
            { "gay", "gayo" },
            { "gba", "gbaya" },
            { "gem", "lingua germanica" },
            { "gez", "geez" },
            { "gil", "gilbertese" },
            { "gmh", "tedesco medio alto" },
            { "goh", "tedesco antico alto" },
            { "gon", "gondi" },
            { "gor", "gorontalo" },
            { "got", "gotico" },
            { "grb", "gerbo" },
            { "grc", "greco antico" },
            { "gsw", "tedesco svizzero" },
            { "gwi", "gwich\u02bcin" },
            { "hai", "haida" },
            { "haw", "hawaiano" },
            { "hil", "hiligayna" },
            { "him", "himachali" },
            { "hit", "hittite" },
            { "hmn", "hmong" },
            { "hsb", "alto sorabo" },
            { "hup", "hupa" },
            { "iba", "iban" },
            { "ilo", "ilocano" },
            { "inc", "lingua indiana" },
            { "ine", "lingua indoeuropea" },
            { "inh", "ingush" },
            { "ira", "iraniana" },
            { "iro", "lingue irochesi" },
            { "jbo", "lojban" },
            { "jpr", "giudeo persiano" },
            { "jrb", "giudeo arabo" },
            { "kaa", "kara-kalpak" },
            { "kab", "kabyle" },
            { "kac", "kachin" },
            { "kaj", "kai" },
            { "kam", "kamba" },
            { "kar", "karen" },
            { "kaw", "kawi" },
            { "kbd", "kabardia" },
            { "kcg", "tyap" },
            { "kha", "khasi" },
            { "khi", "lingua khoisan" },
            { "kho", "khotanese" },
            { "kmb", "kimbundu" },
            { "kok", "konkani" },
            { "kos", "kosraean" },
            { "kpe", "kpelle" },
            { "krc", "karachay-Balkar" },
            { "krl", "careliano" },
            { "kro", "kru" },
            { "kru", "kurukh" },
            { "kum", "kumyk" },
            { "kut", "kutenai" },
            { "lad", "ladino" },
            { "lah", "lahnda" },
            { "lam", "lamba" },
            { "lez", "lezghian" },
            { "lol", "lolo bantu" },
            { "loz", "lozi" },
            { "lua", "luba-lulua" },
            { "lui", "luiseno" },
            { "lun", "lunda" },
            { "luo", "luo" },
            { "lus", "lushai" },
            { "mad", "madurese" },
            { "mag", "magahi" },
            { "mai", "maithili" },
            { "mak", "makasar" },
            { "man", "mandingo" },
            { "map", "austronesiano" },
            { "mas", "masai" },
            { "mdf", "moksha" },
            { "mdr", "mandar" },
            { "men", "mende" },
            { "mga", "irlandese medio" },
            { "mic", "micmac" },
            { "min", "menangkabau" },
            { "mis", "lingue diverse" },
            { "mkh", "lingua mon-khmer" },
            { "mnc", "manchu" },
            { "mni", "manipuri" },
            { "mno", "manobo" },
            { "moh", "mohawk" },
            { "mos", "mossi" },
            { "mul", "multilingua" },
            { "mun", "lingua munda" },
            { "mus", "creek" },
            { "mwl", "mirandese" },
            { "mwr", "marwari" },
            { "myn", "lingue maya" },
            { "myv", "erzya" },
            { "nah", "nahuatl" },
            { "nai", "lingua indiana del Nord America" },
            { "nap", "napoletano" },
            { "nds", "basso tedesco" },
            { "new", "newari" },
            { "nia", "nias" },
            { "nic", "lingua niger-cordofan" },
            { "niu", "niue" },
            { "nog", "nogai" },
            { "non", "norse antico" },
            { "nqo", "n'ko" },
            { "nso", "sotho del nord" },
            { "nub", "nubiano" },
            { "nwc", "newari classico" },
            { "nym", "nyamwezi" },
            { "nyn", "nyankole" },
            { "nyo", "nyoro" },
            { "nzi", "nzima" },
            { "osa", "osage" },
            { "ota", "turco ottomano" },
            { "oto", "lingue otomi" },
            { "paa", "lingua papuana" },
            { "pag", "pangasinan" },
            { "pal", "pahlavi" },
            { "pam", "pampanga" },
            { "pap", "papiamento" },
            { "pau", "palau" },
            { "peo", "persiano antico" },
            { "phi", "lingua filippina" },
            { "phn", "fenicio" },
            { "pon", "ponape" },
            { "pra", "pracrito" },
            { "pro", "provenzale antico" },
            { "raj", "rajasthani" },
            { "rap", "rapanui" },
            { "rar", "rarotonga" },
            { "roa", "lingua romanza" },
            { "rom", "romani" },
            { "rup", "arumeno" },
            { "sad", "sandawe" },
            { "sah", "yakut" },
            { "sai", "lingua indiana del Sud America" },
            { "sal", "lingue salish" },
            { "sam", "aramaico samaritano" },
            { "sas", "sasak" },
            { "sat", "santali" },
            { "scn", "siciliano" },
            { "sco", "scozzese" },
            { "sel", "selkup" },
            { "sem", "lingua semitica" },
            { "sga", "irlandese antico" },
            { "sgn", "lingue sign" },
            { "shn", "shan" },
            { "sid", "sidamo" },
            { "sio", "lingue sioux" },
            { "sit", "lingua sino-tibetana" },
            { "sla", "lingua slava" },
            { "sma", "sami del sud" },
            { "smi", "lingua sami" },
            { "smj", "sami lule" },
            { "smn", "sami inari" },
            { "sms", "sami skolt" },
            { "snk", "soninke" },
            { "sog", "sogdiano" },
            { "son", "songhai" },
            { "srn", "sranan tongo" },
            { "srr", "serer" },
            { "ssa", "lingua nilo-sahariana" },
            { "suk", "sukuma" },
            { "sus", "susu" },
            { "sux", "sumero" },
            { "swb", "comoriano" },
            { "syr", "siriaco" },
            { "tai", "lingua tailandese" },
            { "tem", "temne" },
            { "ter", "tereno" },
            { "tet", "tetum" },
            { "tig", "tigre" },
            { "tiv", "tiv" },
            { "tkl", "tokelau" },
            { "tlh", "klingon" },
            { "tli", "tlingit" },
            { "tmh", "tamashek" },
            { "tog", "nyasa del Tonga" },
            { "tpi", "tok pisin" },
            { "tsi", "tsimshian" },
            { "tum", "tumbuka" },
            { "tup", "lingue tupi" },
            { "tut", "lingua altaica" },
            { "tvl", "tuvalu" },
            { "tyv", "tuvinian" },
            { "udm", "udmurt" },
            { "uga", "ugaritico" },
            { "umb", "mbundu" },
            { "und", "lingua imprecisata" },
            { "vai", "vai" },
            { "vot", "voto" },
            { "wak", "lingue wakash" },
            { "wal", "walamo" },
            { "war", "waray" },
            { "was", "washo" },
            { "wen", "sorabo" },
            { "xal", "kalmyk" },
            { "yao", "yao (bantu)" },
            { "yap", "yapese" },
            { "ypk", "lingue yupik" },
            { "yue", "cantonese" },
            { "zap", "zapotec" },
            { "zen", "zenaga" },
            { "znd", "zande" },
            { "zun", "zuni" },
            { "zxx", "nessun contenuto linguistico" },
            { "zza", "zaza" },
            { "Arab", "arabo" },
            { "Armn", "armeno" },
            { "Bali", "balinese" },
            { "Batk", "batak" },
            { "Beng", "bengali" },
            { "Blis", "simboli bliss" },
            { "Bopo", "bopomofo" },
            { "Brah", "brahmi" },
            { "Brai", "braille" },
            { "Bugi", "buginese" },
            { "Buhd", "buhid" },
            { "Cans", "simboli aborigeni canadesi unificati" },
            { "Cari", "carian" },
            { "Cham", "cham" },
            { "Cher", "cherokee" },
            { "Cirt", "cirth" },
            { "Copt", "copto" },
            { "Cprt", "cipriota" },
            { "Cyrl", "cirillico" },
            { "Cyrs", "cirillico antica chiesa slavonica" },
            { "Deva", "devanagari" },
            { "Dsrt", "deseret" },
            { "Egyd", "egiziano demotico" },
            { "Egyh", "ieratico egiziano" },
            { "Egyp", "geroglifici egiziani" },
            { "Ethi", "etiope" },
            { "Geok", "kutsuri" },
            { "Geor", "georgiano" },
            { "Glag", "glagolitico" },
            { "Goth", "gotico" },
            { "Grek", "greco" },
            { "Gujr", "gujarati" },
            { "Guru", "gurmukhi" },
            { "Hang", "hangul" },
            { "Hani", "han" },
            { "Hano", "hanunoo" },
            { "Hans", "han semplificato" },
            { "Hant", "han tradizionale" },
            { "Hebr", "ebraico" },
            { "Hira", "hiragana" },
            { "Hmng", "pahawn hmong" },
            { "Hrkt", "katanaka o hiragana" },
            { "Hung", "antico ungherese" },
            { "Inds", "indu" },
            { "Ital", "italico antico" },
            { "Java", "javanese" },
            { "Jpan", "giapponese" },
            { "Kali", "kayah li" },
            { "Kana", "katakana" },
            { "Khar", "kharoshthi" },
            { "Khmr", "khmer" },
            { "Knda", "kannada" },
            { "Kore", "coreano" },
            { "Lana", "lanna" },
            { "Laoo", "lao" },
            { "Latf", "variante fraktur del latino" },
            { "Latg", "variante gaelica del latino" },
            { "Latn", "latino" },
            { "Lepc", "lepcha" },
            { "Limb", "limbu" },
            { "Lina", "lineare A" },
            { "Linb", "lineare B" },
            { "Lyci", "lyci" },
            { "Lydi", "lydi" },
            { "Mand", "mandaico" },
            { "Maya", "geroglifici maya" },
            { "Mero", "meroitico" },
            { "Mlym", "malayalam" },
            { "Mong", "mongolo" },
            { "Moon", "moon" },
            { "Mtei", "meetei mayek" },
            { "Mymr", "myanmar" },
            { "Nkoo", "n'ko" },
            { "Ogam", "ogham" },
            { "Olck", "ol chiki" },
            { "Orkh", "orkhon" },
            { "Orya", "oriya" },
            { "Osma", "osmanya" },
            { "Perm", "permico antico" },
            { "Phag", "phags-pa" },
            { "Phnx", "fenicio" },
            { "Plrd", "fonetica di pollard" },
            { "Rjng", "rejang" },
            { "Roro", "rongorongo" },
            { "Runr", "runico" },
            { "Sara", "sarati" },
            { "Saur", "saurashtra" },
            { "Sgnw", "linguaggio dei segni" },
            { "Shaw", "shaviano" },
            { "Sinh", "singalese" },
            { "Sund", "sundanese" },
            { "Sylo", "syloti nagri" },
            { "Syrc", "siriano" },
            { "Syre", "siriaco estrangelo" },
            { "Syrj", "siriaco occidentale" },
            { "Syrn", "siriaco orientale" },
            { "Tagb", "tagbanwa" },
            { "Tale", "tai le" },
            { "Talu", "tai lue" },
            { "Taml", "tamil" },
            { "Telu", "telugu" },
            { "Teng", "tengwar" },
            { "Tfng", "tifinagh" },
            { "Tglg", "tagalog" },
            { "Thaa", "thaana" },
            { "Thai", "tailandese" },
            { "Tibt", "tibetano" },
            { "Ugar", "ugarita" },
            { "Vaii", "vaii" },
            { "Visp", "alfabeto visivo" },
            { "Xpeo", "persiano antico" },
            { "Xsux", "sumero-accadiano cuneiforme" },
            { "Yiii", "yi" },
            { "Zinh", "ereditato" },
            { "Zsym", "simboli" },
            { "Zxxx", "non scritto" },
            { "Zyyy", "comune" },
            { "Zzzz", "ignoto o non valido" },
            { "de_AT", "tedesco austriaco" },
            { "de_CH", "alto tedesco svizzero" },
            { "en_AU", "inglese australiano" },
            { "en_CA", "inglese canadese" },
            { "en_GB", "inglese britannico" },
            { "en_US", "inglese americano" },
            { "es_ES", "spagnolo della Spagna" },
            { "fr_CA", "francese canadese" },
            { "fr_CH", "francese svizzero" },
            { "nl_BE", "fiammingo belga" },
            { "pt_BR", "portoghese brasiliano" },
            { "pt_PT", "portoghese del Portogallo" },
            { "es_419", "spagnolo latinoamericano" },
            { "zh_Hans", "cinese semplificato" },
            { "zh_Hant", "cinese tradizionale" },
        };
        return data;
    }
}
