/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.action.bulk;

import java.io.IOException;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.LongSupplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.apache.logging.log4j.util.MessageSupplier;
import org.opensearch.ExceptionsHelper;
import org.opensearch.action.ActionListenerResponseHandler;
import org.opensearch.action.ActionRunnable;
import org.opensearch.action.DocWriteRequest;
import org.opensearch.action.DocWriteResponse;
import org.opensearch.action.bulk.BulkAction;
import org.opensearch.action.bulk.BulkItemRequest;
import org.opensearch.action.bulk.BulkItemResponse;
import org.opensearch.action.bulk.BulkPrimaryExecutionContext;
import org.opensearch.action.bulk.BulkShardRequest;
import org.opensearch.action.bulk.BulkShardResponse;
import org.opensearch.action.bulk.MappingUpdatePerformer;
import org.opensearch.action.delete.DeleteRequest;
import org.opensearch.action.delete.DeleteResponse;
import org.opensearch.action.index.IndexRequest;
import org.opensearch.action.index.IndexResponse;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.ChannelActionListener;
import org.opensearch.action.support.replication.ReplicatedWriteRequest;
import org.opensearch.action.support.replication.ReplicationMode;
import org.opensearch.action.support.replication.ReplicationOperation;
import org.opensearch.action.support.replication.ReplicationTask;
import org.opensearch.action.support.replication.TransportReplicationAction;
import org.opensearch.action.support.replication.TransportWriteAction;
import org.opensearch.action.update.UpdateHelper;
import org.opensearch.action.update.UpdateRequest;
import org.opensearch.action.update.UpdateResponse;
import org.opensearch.client.transport.NoNodeAvailableException;
import org.opensearch.cluster.ClusterState;
import org.opensearch.cluster.ClusterStateObserver;
import org.opensearch.cluster.action.index.MappingUpdatedAction;
import org.opensearch.cluster.action.shard.ShardStateAction;
import org.opensearch.cluster.metadata.IndexMetadata;
import org.opensearch.cluster.metadata.MappingMetadata;
import org.opensearch.cluster.node.DiscoveryNode;
import org.opensearch.cluster.routing.ShardRouting;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.collect.Tuple;
import org.opensearch.common.compress.CompressedXContent;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.lease.Releasable;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.common.util.concurrent.AbstractRunnable;
import org.opensearch.common.xcontent.XContentHelper;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.common.bytes.BytesReference;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.index.shard.ShardId;
import org.opensearch.core.tasks.TaskId;
import org.opensearch.core.xcontent.MediaType;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.index.IndexingPressureService;
import org.opensearch.index.SegmentReplicationPressureService;
import org.opensearch.index.engine.Engine;
import org.opensearch.index.engine.VersionConflictEngineException;
import org.opensearch.index.get.GetResult;
import org.opensearch.index.mapper.MapperException;
import org.opensearch.index.mapper.MapperService;
import org.opensearch.index.mapper.SourceToParse;
import org.opensearch.index.remote.RemoteStorePressureService;
import org.opensearch.index.shard.IndexShard;
import org.opensearch.index.shard.ShardNotFoundException;
import org.opensearch.index.translog.Translog;
import org.opensearch.indices.IndicesService;
import org.opensearch.indices.SystemIndices;
import org.opensearch.node.NodeClosedException;
import org.opensearch.tasks.Task;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.transport.TransportChannel;
import org.opensearch.transport.TransportRequest;
import org.opensearch.transport.TransportRequestOptions;
import org.opensearch.transport.TransportService;

public class TransportShardBulkAction
extends TransportWriteAction<BulkShardRequest, BulkShardRequest, BulkShardResponse> {
    public static final String ACTION_NAME = "indices:data/write/bulk[s]";
    private static final Logger logger = LogManager.getLogger(TransportShardBulkAction.class);
    private static final Function<IndexShard, String> EXECUTOR_NAME_FUNCTION = shard -> {
        if (shard.indexSettings().getIndexMetadata().isSystem()) {
            return "system_write";
        }
        return "write";
    };
    private final UpdateHelper updateHelper;
    private final MappingUpdatedAction mappingUpdatedAction;
    private final SegmentReplicationPressureService segmentReplicationPressureService;
    private final RemoteStorePressureService remoteStorePressureService;
    private final String transportPrimaryTermValidationAction;

    @Inject
    public TransportShardBulkAction(Settings settings, TransportService transportService, ClusterService clusterService, IndicesService indicesService, ThreadPool threadPool, ShardStateAction shardStateAction, MappingUpdatedAction mappingUpdatedAction, UpdateHelper updateHelper, ActionFilters actionFilters, IndexingPressureService indexingPressureService, SegmentReplicationPressureService segmentReplicationPressureService, RemoteStorePressureService remoteStorePressureService, SystemIndices systemIndices) {
        super(settings, ACTION_NAME, transportService, clusterService, indicesService, threadPool, shardStateAction, actionFilters, BulkShardRequest::new, BulkShardRequest::new, EXECUTOR_NAME_FUNCTION, false, indexingPressureService, systemIndices);
        this.updateHelper = updateHelper;
        this.mappingUpdatedAction = mappingUpdatedAction;
        this.segmentReplicationPressureService = segmentReplicationPressureService;
        this.remoteStorePressureService = remoteStorePressureService;
        this.transportPrimaryTermValidationAction = "indices:data/write/bulk[s][validate_primary_term]";
        transportService.registerRequestHandler(this.transportPrimaryTermValidationAction, this.executor, true, true, PrimaryTermValidationRequest::new, this::handlePrimaryTermValidationRequest);
    }

    protected void handlePrimaryTermValidationRequest(PrimaryTermValidationRequest request, TransportChannel channel, Task task) {
        ChannelActionListener listener = new ChannelActionListener(channel, this.transportPrimaryTermValidationAction, request);
        ShardId shardId = request.getShardId();
        assert (shardId != null) : "request shardId must be set";
        IndexShard replica = this.getIndexShard(shardId);
        try {
            new PrimaryTermValidationReplicaAction(listener, replica, (ReplicationTask)task, request).run();
        }
        catch (RuntimeException e) {
            listener.onFailure(e);
        }
    }

    @Override
    protected ReplicationOperation.Replicas<BulkShardRequest> primaryTermValidationReplicasProxy() {
        return new PrimaryTermValidationProxy();
    }

    @Override
    protected TransportRequestOptions transportOptions(Settings settings) {
        return BulkAction.INSTANCE.transportOptions(settings);
    }

    @Override
    protected BulkShardResponse newResponseInstance(StreamInput in) throws IOException {
        return new BulkShardResponse(in);
    }

    @Override
    protected void dispatchedShardOperationOnPrimary(BulkShardRequest request, IndexShard primary, ActionListener<TransportReplicationAction.PrimaryResult<BulkShardRequest, BulkShardResponse>> listener) {
        ClusterStateObserver observer = new ClusterStateObserver(this.clusterService, request.timeout(), logger, this.threadPool.getThreadContext());
        TransportShardBulkAction.performOnPrimary(request, primary, this.updateHelper, this.threadPool::absoluteTimeInMillis, (update, shardId, mappingListener) -> {
            assert (update != null);
            assert (shardId != null);
            this.mappingUpdatedAction.updateMappingOnClusterManager(shardId.getIndex(), update, (ActionListener<Void>)mappingListener);
        }, mappingUpdateListener -> observer.waitForNextChange(new ClusterStateObserver.Listener((ActionListener)mappingUpdateListener){
            final /* synthetic */ ActionListener val$mappingUpdateListener;
            {
                this.val$mappingUpdateListener = actionListener;
            }

            @Override
            public void onNewClusterState(ClusterState state) {
                this.val$mappingUpdateListener.onResponse(null);
            }

            @Override
            public void onClusterServiceClose() {
                this.val$mappingUpdateListener.onFailure((Exception)((Object)new NodeClosedException(TransportShardBulkAction.this.clusterService.localNode())));
            }

            @Override
            public void onTimeout(TimeValue timeout) {
                this.val$mappingUpdateListener.onFailure((Exception)((Object)new MapperException("timed out while waiting for a dynamic mapping update")));
            }
        }), listener, this.threadPool, this.executor(primary));
    }

    @Override
    protected long primaryOperationSize(BulkShardRequest request) {
        return request.ramBytesUsed();
    }

    @Override
    public ReplicationMode getReplicationMode(IndexShard indexShard) {
        if (indexShard.isRemoteTranslogEnabled()) {
            return ReplicationMode.PRIMARY_TERM_VALIDATION;
        }
        return super.getReplicationMode(indexShard);
    }

    public static void performOnPrimary(final BulkShardRequest request, final IndexShard primary, final UpdateHelper updateHelper, final LongSupplier nowInMillisSupplier, final MappingUpdatePerformer mappingUpdater, final Consumer<ActionListener<Void>> waitForMappingUpdate, ActionListener<TransportReplicationAction.PrimaryResult<BulkShardRequest, BulkShardResponse>> listener, final ThreadPool threadPool, final String executorName) {
        new ActionRunnable<TransportReplicationAction.PrimaryResult<BulkShardRequest, BulkShardResponse>>(listener){
            private final Executor executor;
            private final BulkPrimaryExecutionContext context;
            {
                super(listener);
                this.executor = threadPool.executor(executorName);
                this.context = new BulkPrimaryExecutionContext(request, primary);
            }

            @Override
            protected void doRun() throws Exception {
                while (this.context.hasMoreOperationsToExecute()) {
                    if (!TransportShardBulkAction.executeBulkItemRequest(this.context, updateHelper, nowInMillisSupplier, mappingUpdater, waitForMappingUpdate, (ActionListener<Void>)ActionListener.wrap(v -> this.executor.execute(this), this::onRejection))) {
                        return;
                    }
                    assert (this.context.isInitial());
                }
                this.finishRequest();
            }

            @Override
            public void onRejection(final Exception e) {
                this.executor.execute(new ActionRunnable<TransportReplicationAction.PrimaryResult<BulkShardRequest, BulkShardResponse>>(this.listener){

                    @Override
                    protected void doRun() {
                        while (context.hasMoreOperationsToExecute()) {
                            context.setRequestToExecute(context.getCurrent());
                            Object docWriteRequest = context.getRequestToExecute();
                            TransportShardBulkAction.onComplete(TransportShardBulkAction.exceptionToResult(e, primary, docWriteRequest.opType() == DocWriteRequest.OpType.DELETE, docWriteRequest.version()), context, null);
                        }
                        this.finishRequest();
                    }

                    @Override
                    public boolean isForceExecution() {
                        return true;
                    }
                });
            }

            private void finishRequest() {
                ActionListener.completeWith((ActionListener)this.listener, () -> new TransportWriteAction.WritePrimaryResult<BulkShardRequest, BulkShardResponse>(this.context.getBulkShardRequest(), this.context.buildShardResponse(), this.context.getLocationToSync(), null, this.context.getPrimary(), logger));
            }
        }.run();
    }

    @Override
    protected Releasable checkPrimaryLimits(BulkShardRequest request, boolean rerouteWasLocal, boolean localRerouteInitiatedByNodeClient) {
        if (!this.force(request)) {
            if (this.segmentReplicationPressureService.isSegmentReplicationBackpressureEnabled()) {
                this.segmentReplicationPressureService.isSegrepLimitBreached(request.shardId());
            }
            if (this.remoteStorePressureService.isSegmentsUploadBackpressureEnabled()) {
                this.remoteStorePressureService.validateSegmentsUploadLag(request.shardId());
            }
        }
        return super.checkPrimaryLimits(request, rerouteWasLocal, localRerouteInitiatedByNodeClient);
    }

    static boolean executeBulkItemRequest(final BulkPrimaryExecutionContext context, UpdateHelper updateHelper, LongSupplier nowInMillisSupplier, MappingUpdatePerformer mappingUpdater, final Consumer<ActionListener<Void>> waitForMappingUpdate, final ActionListener<Void> itemDoneListener) throws Exception {
        Engine.Result result;
        ReplicatedWriteRequest request;
        boolean isDelete;
        UpdateHelper.Result updateResult;
        DocWriteRequest.OpType opType = context.getCurrent().opType();
        if (opType == DocWriteRequest.OpType.UPDATE) {
            UpdateRequest updateRequest = (UpdateRequest)context.getCurrent();
            try {
                updateResult = updateHelper.prepare(updateRequest, context.getPrimary(), nowInMillisSupplier);
            }
            catch (Exception failure) {
                Engine.IndexResult result2 = new Engine.IndexResult(failure, updateRequest.version());
                context.setRequestToExecute(updateRequest);
                context.markOperationAsExecuted(result2);
                context.markAsCompleted(context.getExecutionResult());
                return true;
            }
            switch (updateResult.getResponseResult()) {
                case CREATED: 
                case UPDATED: {
                    IndexRequest indexRequest = (IndexRequest)updateResult.action();
                    IndexMetadata metadata = context.getPrimary().indexSettings().getIndexMetadata();
                    MappingMetadata mappingMd = metadata.mapping();
                    indexRequest.process(metadata.getCreationVersion(), mappingMd, updateRequest.concreteIndex());
                    context.setRequestToExecute(indexRequest);
                    break;
                }
                case DELETED: {
                    context.setRequestToExecute((DocWriteRequest)updateResult.action());
                    break;
                }
                case NOOP: {
                    context.markOperationAsNoOp((DocWriteResponse)updateResult.action());
                    context.markAsCompleted(context.getExecutionResult());
                    return true;
                }
                default: {
                    throw new IllegalStateException("Illegal update operation " + updateResult.getResponseResult());
                }
            }
        } else {
            context.setRequestToExecute(context.getCurrent());
            updateResult = null;
        }
        assert (context.getRequestToExecute() != null);
        final IndexShard primary = context.getPrimary();
        final long version = context.getRequestToExecute().version();
        boolean bl = isDelete = context.getRequestToExecute().opType() == DocWriteRequest.OpType.DELETE;
        if (isDelete) {
            request = (DeleteRequest)context.getRequestToExecute();
            result = primary.applyDeleteOperationOnPrimary(version, ((DeleteRequest)request).id(), ((DeleteRequest)request).versionType(), ((DeleteRequest)request).ifSeqNo(), ((DeleteRequest)request).ifPrimaryTerm());
        } else {
            request = (IndexRequest)context.getRequestToExecute();
            result = primary.applyIndexOperationOnPrimary(version, ((IndexRequest)request).versionType(), new SourceToParse(request.index(), ((IndexRequest)request).id(), ((IndexRequest)request).source(), ((IndexRequest)request).getContentType(), ((IndexRequest)request).routing()), ((IndexRequest)request).ifSeqNo(), ((IndexRequest)request).ifPrimaryTerm(), ((IndexRequest)request).getAutoGeneratedTimestamp(), ((IndexRequest)request).isRetry());
        }
        if (result.getResultType() == Engine.Result.Type.MAPPING_UPDATE_REQUIRED) {
            try {
                primary.mapperService().merge("_doc", new CompressedXContent((ToXContent)result.getRequiredMappingUpdate(), ToXContent.EMPTY_PARAMS), MapperService.MergeReason.MAPPING_UPDATE_PREFLIGHT);
            }
            catch (Exception e) {
                logger.info(() -> new ParameterizedMessage("{} mapping update rejected by primary", (Object)primary.shardId()), (Throwable)e);
                TransportShardBulkAction.onComplete(TransportShardBulkAction.exceptionToResult(e, primary, isDelete, version), context, updateResult);
                return true;
            }
            mappingUpdater.updateMappings(result.getRequiredMappingUpdate(), primary.shardId(), new ActionListener<Void>(){

                public void onResponse(Void v) {
                    context.markAsRequiringMappingUpdate();
                    waitForMappingUpdate.accept(ActionListener.runAfter((ActionListener)new ActionListener<Void>(){

                        public void onResponse(Void v) {
                            assert (context.requiresWaitingForMappingUpdate());
                            context.resetForExecutionForRetry();
                        }

                        public void onFailure(Exception e) {
                            context.failOnMappingUpdate(e);
                        }
                    }, () -> itemDoneListener.onResponse(null)));
                }

                public void onFailure(Exception e) {
                    TransportShardBulkAction.onComplete(TransportShardBulkAction.exceptionToResult(e, primary, isDelete, version), context, updateResult);
                    assert (context.isInitial());
                    itemDoneListener.onResponse(null);
                }
            });
            return false;
        }
        TransportShardBulkAction.onComplete(result, context, updateResult);
        return true;
    }

    private static Engine.Result exceptionToResult(Exception e, IndexShard primary, boolean isDelete, long version) {
        return isDelete ? primary.getFailedDeleteResult(e, version) : primary.getFailedIndexResult(e, version);
    }

    private static void onComplete(Engine.Result r, BulkPrimaryExecutionContext context, UpdateHelper.Result updateResult) {
        BulkItemResponse response;
        context.markOperationAsExecuted(r);
        DocWriteRequest<?> docWriteRequest = context.getCurrent();
        DocWriteRequest.OpType opType = docWriteRequest.opType();
        boolean isUpdate = opType == DocWriteRequest.OpType.UPDATE;
        BulkItemResponse executionResult = context.getExecutionResult();
        boolean isFailed = executionResult.isFailed();
        if (isUpdate && isFailed && TransportShardBulkAction.isConflictException(executionResult.getFailure().getCause()) && context.getRetryCounter() < ((UpdateRequest)docWriteRequest).retryOnConflict()) {
            context.resetForExecutionForRetry();
            return;
        }
        if (isUpdate) {
            response = TransportShardBulkAction.processUpdateResponse((UpdateRequest)docWriteRequest, context.getConcreteIndex(), executionResult, updateResult);
        } else {
            if (isFailed) {
                Exception failure = executionResult.getFailure().getCause();
                MessageSupplier messageSupplier = () -> new ParameterizedMessage("{} failed to execute bulk item ({}) {}", new Object[]{context.getPrimary().shardId(), opType.getLowercase(), docWriteRequest});
                if (TransportShardBulkAction.isConflictException(failure)) {
                    logger.trace(messageSupplier, (Throwable)failure);
                } else {
                    logger.debug(messageSupplier, (Throwable)failure);
                }
            }
            response = executionResult;
        }
        context.markAsCompleted(response);
        assert (context.isInitial());
    }

    private static boolean isConflictException(Exception e) {
        return ExceptionsHelper.unwrapCause((Throwable)e) instanceof VersionConflictEngineException;
    }

    static BulkItemResponse processUpdateResponse(UpdateRequest updateRequest, String concreteIndex, BulkItemResponse operationResponse, UpdateHelper.Result translate) {
        BulkItemResponse response;
        if (operationResponse.isFailed()) {
            response = new BulkItemResponse(operationResponse.getItemId(), DocWriteRequest.OpType.UPDATE, operationResponse.getFailure());
        } else {
            UpdateResponse updateResponse;
            DocWriteResponse.Result translatedResult = translate.getResponseResult();
            if (translatedResult == DocWriteResponse.Result.CREATED || translatedResult == DocWriteResponse.Result.UPDATED) {
                IndexRequest updateIndexRequest = (IndexRequest)translate.action();
                IndexResponse indexResponse = (IndexResponse)operationResponse.getResponse();
                updateResponse = new UpdateResponse(indexResponse.getShardInfo(), indexResponse.getShardId(), indexResponse.getId(), indexResponse.getSeqNo(), indexResponse.getPrimaryTerm(), indexResponse.getVersion(), indexResponse.getResult());
                if (updateRequest.fetchSource() != null && updateRequest.fetchSource().fetchSource()) {
                    BytesReference indexSourceAsBytes = updateIndexRequest.source();
                    Tuple<? extends MediaType, Map<String, Object>> sourceAndContent = XContentHelper.convertToMap(indexSourceAsBytes, true, updateIndexRequest.getContentType());
                    updateResponse.setGetResult(UpdateHelper.extractGetResult(updateRequest, concreteIndex, indexResponse.getSeqNo(), indexResponse.getPrimaryTerm(), indexResponse.getVersion(), (Map)sourceAndContent.v2(), (MediaType)sourceAndContent.v1(), indexSourceAsBytes));
                }
            } else if (translatedResult == DocWriteResponse.Result.DELETED) {
                DeleteResponse deleteResponse = (DeleteResponse)operationResponse.getResponse();
                updateResponse = new UpdateResponse(deleteResponse.getShardInfo(), deleteResponse.getShardId(), deleteResponse.getId(), deleteResponse.getSeqNo(), deleteResponse.getPrimaryTerm(), deleteResponse.getVersion(), deleteResponse.getResult());
                GetResult getResult = UpdateHelper.extractGetResult(updateRequest, concreteIndex, deleteResponse.getSeqNo(), deleteResponse.getPrimaryTerm(), deleteResponse.getVersion(), translate.updatedSourceAsMap(), translate.updateSourceContentType(), null);
                updateResponse.setGetResult(getResult);
            } else {
                throw new IllegalArgumentException("unknown operation type: " + translatedResult);
            }
            response = new BulkItemResponse(operationResponse.getItemId(), DocWriteRequest.OpType.UPDATE, updateResponse);
        }
        return response;
    }

    @Override
    protected void dispatchedShardOperationOnReplica(BulkShardRequest request, IndexShard replica, ActionListener<TransportReplicationAction.ReplicaResult> listener) {
        ActionListener.completeWith(listener, () -> {
            Translog.Location location = TransportShardBulkAction.performOnReplica(request, replica);
            return new TransportWriteAction.WriteReplicaResult<BulkShardRequest>(request, location, null, replica, logger);
        });
    }

    @Override
    protected long replicaOperationSize(BulkShardRequest request) {
        return request.ramBytesUsed();
    }

    public static Translog.Location performOnReplica(BulkShardRequest request, IndexShard replica) throws Exception {
        Translog.Location location = null;
        for (int i = 0; i < request.items().length; ++i) {
            Engine.Result operationResult;
            BulkItemRequest item = request.items()[i];
            BulkItemResponse response = item.getPrimaryResponse();
            if (item.getPrimaryResponse().isFailed()) {
                if (response.getFailure().getSeqNo() == -2L) continue;
                long primaryTerm = response.getFailure().getTerm() == 0L ? replica.getOperationPrimaryTerm() : response.getFailure().getTerm();
                operationResult = replica.markSeqNoAsNoop(response.getFailure().getSeqNo(), primaryTerm, response.getFailure().getMessage());
            } else {
                if (((DocWriteResponse)response.getResponse()).getResult() == DocWriteResponse.Result.NOOP) continue;
                assert (((DocWriteResponse)response.getResponse()).getSeqNo() != -2L);
                operationResult = TransportShardBulkAction.performOpOnReplica(response.getResponse(), item.request(), replica);
            }
            assert (operationResult != null) : "operation result must never be null when primary response has no failure";
            location = TransportShardBulkAction.syncOperationResultOrThrow(operationResult, location);
        }
        return location;
    }

    private static Engine.Result performOpOnReplica(DocWriteResponse primaryResponse, DocWriteRequest<?> docWriteRequest, IndexShard replica) throws Exception {
        Engine.Result result;
        switch (docWriteRequest.opType()) {
            case CREATE: 
            case INDEX: {
                IndexRequest indexRequest = (IndexRequest)docWriteRequest;
                ShardId shardId = replica.shardId();
                SourceToParse sourceToParse = new SourceToParse(shardId.getIndexName(), indexRequest.id(), indexRequest.source(), indexRequest.getContentType(), indexRequest.routing());
                result = replica.applyIndexOperationOnReplica(primaryResponse.getId(), primaryResponse.getSeqNo(), primaryResponse.getPrimaryTerm(), primaryResponse.getVersion(), indexRequest.getAutoGeneratedTimestamp(), indexRequest.isRetry(), sourceToParse);
                break;
            }
            case DELETE: {
                DeleteRequest deleteRequest = (DeleteRequest)docWriteRequest;
                result = replica.applyDeleteOperationOnReplica(primaryResponse.getSeqNo(), primaryResponse.getPrimaryTerm(), primaryResponse.getVersion(), deleteRequest.id());
                break;
            }
            default: {
                assert (false) : "Unexpected request operation type on replica: " + docWriteRequest + ";primary result: " + primaryResponse;
                throw new IllegalStateException("Unexpected request operation type on replica: " + docWriteRequest.opType().getLowercase());
            }
        }
        if (result.getResultType() == Engine.Result.Type.MAPPING_UPDATE_REQUIRED) {
            throw new TransportReplicationAction.RetryOnReplicaException(replica.shardId(), "Mappings are not available on the replica yet, triggered update: " + result.getRequiredMappingUpdate());
        }
        return result;
    }

    private final class PrimaryTermValidationProxy
    extends TransportWriteAction.WriteActionReplicasProxy {
        private PrimaryTermValidationProxy() {
            super(TransportShardBulkAction.this);
        }

        @Override
        public void performOn(ShardRouting replica, BulkShardRequest request, long primaryTerm, long globalCheckpoint, long maxSeqNoOfUpdatesOrDeletes, ActionListener<ReplicationOperation.ReplicaResponse> listener) {
            String nodeId = replica.currentNodeId();
            DiscoveryNode node = TransportShardBulkAction.this.clusterService.state().nodes().get(nodeId);
            if (node == null) {
                listener.onFailure((Exception)((Object)new NoNodeAvailableException("unknown node [" + nodeId + "]")));
                return;
            }
            PrimaryTermValidationRequest validationRequest = new PrimaryTermValidationRequest(replica.allocationId().getId(), primaryTerm, replica.shardId());
            ActionListenerResponseHandler<ReplicationOperation.ReplicaResponse> handler = new ActionListenerResponseHandler<ReplicationOperation.ReplicaResponse>(listener, TransportReplicationAction.ReplicaResponse::new);
            TransportShardBulkAction.this.transportService.sendRequest(node, TransportShardBulkAction.this.transportPrimaryTermValidationAction, (TransportRequest)validationRequest, TransportShardBulkAction.this.transportOptions, handler);
        }
    }

    protected static final class PrimaryTermValidationRequest
    extends TransportRequest {
        private final String targetAllocationID;
        private final long primaryTerm;
        private final ShardId shardId;

        public PrimaryTermValidationRequest(String targetAllocationID, long primaryTerm, ShardId shardId) {
            this.targetAllocationID = Objects.requireNonNull(targetAllocationID);
            this.primaryTerm = primaryTerm;
            this.shardId = Objects.requireNonNull(shardId);
        }

        public PrimaryTermValidationRequest(StreamInput in) throws IOException {
            super(in);
            this.targetAllocationID = in.readString();
            this.primaryTerm = in.readVLong();
            this.shardId = new ShardId(in);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeString(this.targetAllocationID);
            out.writeVLong(this.primaryTerm);
            this.shardId.writeTo(out);
        }

        @Override
        public Task createTask(long id, String type, String action, TaskId parentTaskId, Map<String, String> headers) {
            return new ReplicationTask(id, type, action, this.getDescription(), parentTaskId, headers);
        }

        public String getTargetAllocationID() {
            return this.targetAllocationID;
        }

        public long getPrimaryTerm() {
            return this.primaryTerm;
        }

        public ShardId getShardId() {
            return this.shardId;
        }

        @Override
        public String getDescription() {
            return this.toString();
        }

        public String toString() {
            return "PrimaryTermValidationRequest [" + this.shardId + "] for targetAllocationID [" + this.targetAllocationID + "] with primaryTerm [" + this.primaryTerm + "]";
        }
    }

    private static final class PrimaryTermValidationReplicaAction
    extends AbstractRunnable
    implements ActionListener<Releasable> {
        private final ActionListener<TransportReplicationAction.ReplicaResponse> onCompletionListener;
        private final IndexShard replica;
        private final ReplicationTask task;
        private final PrimaryTermValidationRequest request;

        public PrimaryTermValidationReplicaAction(ActionListener<TransportReplicationAction.ReplicaResponse> onCompletionListener, IndexShard replica, ReplicationTask task, PrimaryTermValidationRequest request) {
            this.onCompletionListener = onCompletionListener;
            this.replica = replica;
            this.task = task;
            this.request = request;
        }

        public void onResponse(Releasable releasable) {
            TransportShardBulkAction.setPhase(this.task, "finished");
            this.onCompletionListener.onResponse((Object)new TransportReplicationAction.ReplicaResponse(-1L, -1L));
        }

        @Override
        public void onFailure(Exception e) {
            TransportShardBulkAction.setPhase(this.task, "failed");
            this.onCompletionListener.onFailure(e);
        }

        @Override
        protected void doRun() throws Exception {
            TransportShardBulkAction.setPhase(this.task, "primary-term-validation");
            String actualAllocationId = this.replica.routingEntry().allocationId().getId();
            if (!actualAllocationId.equals(this.request.getTargetAllocationID())) {
                throw new ShardNotFoundException(this.replica.shardId(), "expected allocation id [{}] but found [{}]", this.request.getTargetAllocationID(), actualAllocationId);
            }
            if (this.request.getPrimaryTerm() < this.replica.getOperationPrimaryTerm()) {
                String message = String.format(Locale.ROOT, "%s operation primary term [%d] is too old (current [%d])", this.request.getShardId(), this.request.getPrimaryTerm(), this.replica.getOperationPrimaryTerm());
                this.onFailure(new IllegalStateException(message));
            } else {
                this.onResponse(null);
            }
        }
    }
}

