/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.telemetry.tracing.channels;

import java.io.IOException;
import org.opensearch.Version;
import org.opensearch.common.util.FeatureFlags;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.transport.TransportResponse;
import org.opensearch.telemetry.tracing.Span;
import org.opensearch.telemetry.tracing.SpanScope;
import org.opensearch.telemetry.tracing.Tracer;
import org.opensearch.transport.BaseTcpTransportChannel;
import org.opensearch.transport.TcpTransportChannel;
import org.opensearch.transport.TransportChannel;

public class TraceableTcpTransportChannel
extends BaseTcpTransportChannel {
    private final TransportChannel delegate;
    private final Span span;
    private final Tracer tracer;

    public TraceableTcpTransportChannel(TcpTransportChannel delegate, Span span, Tracer tracer) {
        super(delegate.getChannel());
        this.delegate = delegate;
        this.span = span;
        this.tracer = tracer;
    }

    public static TransportChannel create(TcpTransportChannel delegate, final Span span, Tracer tracer) {
        if (FeatureFlags.isEnabled("opensearch.experimental.feature.telemetry.enabled")) {
            delegate.getChannel().addCloseListener(new ActionListener<Void>(){

                public void onResponse(Void unused) {
                    this.onFailure(null);
                }

                public void onFailure(Exception e) {
                    span.addEvent("The TransportChannel was closed without sending the response");
                    span.setError(e);
                    span.endSpan();
                }
            });
            return new TraceableTcpTransportChannel(delegate, span, tracer);
        }
        return delegate;
    }

    @Override
    public String getProfileName() {
        return this.delegate.getProfileName();
    }

    @Override
    public String getChannelType() {
        return this.delegate.getChannelType();
    }

    @Override
    public void sendResponse(TransportResponse response) throws IOException {
        try (SpanScope scope = this.tracer.withSpanInScope(this.span);){
            this.delegate.sendResponse(response);
        }
        catch (IOException ex) {
            this.span.setError((Exception)ex);
            throw ex;
        }
        finally {
            this.span.endSpan();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendResponse(Exception exception) throws IOException {
        try (SpanScope scope = this.tracer.withSpanInScope(this.span);){
            this.delegate.sendResponse(exception);
        }
        finally {
            this.span.setError(exception);
            this.span.endSpan();
        }
    }

    @Override
    public Version getVersion() {
        return this.delegate.getVersion();
    }
}

